//@copyright_begin
// ================================================================
// Copyright Notice
// Copyright (C) 1998-2004 by Joe Linoff
// 
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL JOE LINOFF BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// OTHER DEALINGS IN THE SOFTWARE.
// 
// Comments and suggestions are always welcome.
// Please report bugs to http://ccdoc.sourceforge.net/ccdoc
// ================================================================
//@copyright_end

// ================================================================
// This static variable allows the header version
// to be queried at runtime.
// ================================================================
namespace {
  char ccdoc_rcsid[] = "$Id: exceptions.cc,v 1.6 2004/09/30 04:16:01 jlinoff Exp $";
}

#include "exceptions.h"
#include <iostream>
#include <cstdio>

// ================================================================
// Default constructor.
// ================================================================
ccdoc::exceptions::base::base() {
}
// ================================================================
// Id based constructor.
// ================================================================
ccdoc::exceptions::base::base(const char* id,
			      const char* file,
			      int lineno,
			      const char* msg)
{
  char nbuf[32];
  sprintf(nbuf,"%d",lineno);
  ccdoc_assert(file);
  ccdoc_assert(msg);
  m_msg = "EXCEPTION:";
  m_msg += id;
  m_msg += ":";
  m_msg += file;
  m_msg += ":";
  m_msg += nbuf;
  m_msg += ": ";
  m_msg += msg;
}
// ================================================================
// Destructor.
// ================================================================
ccdoc::exceptions::base::~base() {
}
// ================================================================
// Report
// ================================================================
void ccdoc::exceptions::base::report() const {
  cerr << endl << m_msg.c_str() << endl;
}

// ================================================================
// assert_true
// ================================================================
ccdoc::exceptions::assert_true::assert_true(const char* file,
					    int lineno,
					    const char* expr)
  : ccdoc::exceptions::base("assertion failed",file,lineno,expr)
{
}

// ================================================================
// invalid_database
// ================================================================
ccdoc::exceptions::invalid_database::invalid_database(const char* file,
						      int lineno,
						      const char* dbfile,
						      const char* msg)
  : ccdoc::exceptions::base("invalid database",file,lineno,dbfile)
{
  ccdoc_assert(msg);
  m_msg += " ";
  m_msg += msg;
}

// ================================================================
// duplicate_name
// ================================================================
ccdoc::exceptions::duplicate_name::duplicate_name(const char* file,
						  int lineno,
						  const char* name,
						  const char* msg)
  : ccdoc::exceptions::base("duplicate name",file,lineno,name)
{
  ccdoc_assert(msg);
  m_msg += " ";
  m_msg += msg;
}
// ================================================================
// duplicate_name
// ================================================================
ccdoc::exceptions::
unwriteable_output_file::unwriteable_output_file(const char* file,
						 int lineno,
						 const char* name)
  : ccdoc::exceptions::base("unwriteable output file",file,lineno,name)
{
}
