/* Generated by re2c 0.16 */
/*
 * phpdbg_lexer.l
 */

#include "phpdbg.h"
#include "phpdbg_cmd.h"

#include "phpdbg_parser.h"

#define LEX(v) (PHPDBG_G(lexer).v)

#define YYCTYPE unsigned char
#define YYSETCONDITION(x) LEX(state) = x;
#define YYGETCONDITION() LEX(state)
#define YYCURSOR LEX(cursor)
#define YYMARKER LEX(marker)
#define YYCTXMARKER LEX(ctxmarker)
#define yyleng LEX(len)
#define yytext ((char*) LEX(text))
#undef YYDEBUG
#define YYDEBUG(a, b)
#define YYFILL(n)

#define NORMAL 0
#define PRE_RAW 1
#define RAW 2
#define INITIAL 3

ZEND_EXTERN_MODULE_GLOBALS(phpdbg)

void phpdbg_init_lexer (phpdbg_param_t *stack, char *input) {
	PHPDBG_G(parser_stack) = stack;

	YYSETCONDITION(INITIAL);

	LEX(text) = YYCURSOR = YYMARKER = (unsigned char *) input;
	LEX(len) = strlen(input);
}

static int unescape_string(char *s) {
	switch (*s) {
		case '\'':
		case '\"': {
			char start = *s;
			size_t off = 1;
			do {
				if (s[off] == '\\') {
					off++;
				}
				*s = s[off];
			} while ((++s)[off] != start);
			return off + 1;
		}
	}

	return 0;
}

int phpdbg_lex (phpdbg_param_t* yylval) {

restart:
	LEX(text) = YYCURSOR;


{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	if (YYGETCONDITION() < 2) {
		if (YYGETCONDITION() < 1) {
			goto yyc_NORMAL;
		} else {
			goto yyc_PRE_RAW;
		}
	} else {
		if (YYGETCONDITION() < 3) {
			goto yyc_RAW;
		} else {
			goto yyc_INITIAL;
		}
	}
/* *********************************** */
yyc_INITIAL:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0, 128,   0,   0,   0, 128,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
		};
		YYDEBUG(1, *YYCURSOR);
		YYFILL(4);
		yych = *YYCURSOR;
		if (yych <= 'E') {
			if (yych <= '\r') {
				if (yych == '\t') goto yy5;
				if (yych >= '\r') goto yy5;
			} else {
				if (yych == ' ') goto yy6;
				if (yych >= 'E') goto yy9;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= 'Q') goto yy3;
				if (yych <= 'R') goto yy10;
				if (yych <= 'S') goto yy11;
			} else {
				if (yych <= 'q') {
					if (yych <= 'e') goto yy9;
				} else {
					if (yych <= 'r') goto yy12;
					if (yych <= 's') goto yy11;
				}
			}
		}
yy3:
		YYDEBUG(3, *YYCURSOR);
		++YYCURSOR;
yy4:
		YYDEBUG(4, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	YYSETCONDITION(NORMAL);

	YYCURSOR = LEX(text);
	goto restart;
}
yy5:
		YYDEBUG(5, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy6;
		}
		goto yy4;
yy6:
		YYDEBUG(6, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(7, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy6;
		}
		YYDEBUG(8, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	/* ignore whitespace */

	goto restart;
}
yy9:
		YYDEBUG(9, *YYCURSOR);
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'V') goto yy13;
		if (yych == 'v') goto yy13;
		goto yy4;
yy10:
		YYDEBUG(10, *YYCURSOR);
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'U') goto yy15;
		if (yych == 'u') goto yy15;
		goto yy4;
yy11:
		YYDEBUG(11, *YYCURSOR);
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy16;
		if (yych == 'h') goto yy16;
		goto yy4;
yy12:
		YYDEBUG(12, *YYCURSOR);
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x1F) {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy4;
				goto yy17;
			} else {
				if (yych == '\r') goto yy17;
				goto yy4;
			}
		} else {
			if (yych <= 'U') {
				if (yych <= ' ') goto yy17;
				if (yych <= 'T') goto yy4;
				goto yy15;
			} else {
				if (yych == 'u') goto yy15;
				goto yy4;
			}
		}
yy13:
		YYDEBUG(13, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\f') {
			if (yych == '\t') goto yy20;
		} else {
			if (yych <= '\r') goto yy20;
			if (yych == ' ') goto yy20;
		}
yy14:
		YYDEBUG(14, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy4;
yy15:
		YYDEBUG(15, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy23;
		if (yych == 'n') goto yy23;
		goto yy14;
yy16:
		YYDEBUG(16, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\f') {
			if (yych == '\t') goto yy24;
			goto yy14;
		} else {
			if (yych <= '\r') goto yy24;
			if (yych == ' ') goto yy24;
			goto yy14;
		}
yy17:
		YYDEBUG(17, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(18, *YYCURSOR);
		if (yych <= '\f') {
			if (yych == '\t') goto yy17;
		} else {
			if (yych <= '\r') goto yy17;
			if (yych == ' ') goto yy17;
		}
		YYDEBUG(19, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	YYSETCONDITION(PRE_RAW);
	phpdbg_init_param(yylval, EMPTY_PARAM);
	return T_RUN;
}
yy20:
		YYDEBUG(20, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(21, *YYCURSOR);
		if (yych <= '\f') {
			if (yych == '\t') goto yy20;
		} else {
			if (yych <= '\r') goto yy20;
			if (yych == ' ') goto yy20;
		}
		YYDEBUG(22, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	YYSETCONDITION(PRE_RAW);
	phpdbg_init_param(yylval, EMPTY_PARAM);
	return T_EVAL;
}
yy23:
		YYDEBUG(23, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\f') {
			if (yych == '\t') goto yy17;
			goto yy14;
		} else {
			if (yych <= '\r') goto yy17;
			if (yych == ' ') goto yy17;
			goto yy14;
		}
yy24:
		YYDEBUG(24, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(25, *YYCURSOR);
		if (yych <= '\f') {
			if (yych == '\t') goto yy24;
		} else {
			if (yych <= '\r') goto yy24;
			if (yych == ' ') goto yy24;
		}
		YYDEBUG(26, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	YYSETCONDITION(PRE_RAW);
	phpdbg_init_param(yylval, EMPTY_PARAM);
	return T_SHELL;
}
	}
/* *********************************** */
yyc_NORMAL:
	{
		static const unsigned char yybm[] = {
			/* table 1 .. 8: 0 */
			  0,  62,  62,  62,  62,  62,  62,  62, 
			 62,  40,   0,  62,  62,  40,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 40,  62,  50,  40,  62,  62,  62,  14, 
			 62,  62,  62,  62,  62,  62,  63,  62, 
			127, 127, 127, 127, 127, 127, 127, 127, 
			127, 127,  40,  62,  62,  62,  62,  62, 
			 62, 254, 254, 254, 254, 254, 254, 190, 
			190, 190, 190, 190, 190, 190, 190, 190, 
			190, 190, 190, 190, 190, 190, 190, 190, 
			190, 190, 190,  62,   2,  62,  62,  62, 
			 62, 254, 254, 254, 254, 254, 254, 190, 
			190, 190, 190, 190, 190, 190, 190, 190, 
			190, 190, 190, 190, 190, 190, 190, 190, 
			190, 190, 190,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			/* table 9 .. 10: 256 */
			  0,  64,  64,  64,  64,  64,  64,  64, 
			 64, 128,   0,  64,  64, 128,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			128,  64,   0,   0,  64,  64,  64,   0, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,   0,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
		};
		YYDEBUG(27, *YYCURSOR);
		YYFILL(11);
		yych = *YYCURSOR;
		if (yybm[256+yych] & 128) {
			goto yy34;
		}
		switch (yych) {
		case 0x00:
		case '\t':
		case '\n':	goto yy29;
		case '"':	goto yy37;
		case '#':	goto yy39;
		case '\'':	goto yy41;
		case '-':	goto yy42;
		case '.':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':	goto yy43;
		case '0':	goto yy46;
		case ':':	goto yy47;
		case 'D':
		case 'd':	goto yy48;
		case 'E':
		case 'e':	goto yy49;
		case 'F':
		case 'f':	goto yy50;
		case 'I':
		case 'i':	goto yy51;
		case 'N':
		case 'n':	goto yy52;
		case 'O':
		case 'o':	goto yy53;
		case 'T':
		case 't':	goto yy54;
		case 'Y':
		case 'y':	goto yy55;
		case 'Z':	goto yy56;
		case 'z':	goto yy57;
		default:	goto yy31;
		}
yy29:
		YYDEBUG(29, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(30, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	return 0;
}
yy31:
		YYDEBUG(31, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy32:
		YYDEBUG(32, *YYCURSOR);
		if (yybm[256+yych] & 64) {
			goto yy31;
		}
		if (yych <= ' ') goto yy33;
		if (yych == '#') goto yy33;
		if (yych <= '\'') goto yy58;
		goto yy61;
yy33:
		YYDEBUG(33, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	phpdbg_init_param(yylval, STR_PARAM);
	yylval->str = estrndup(yytext, yyleng - unescape_string(yytext));
	yylval->len = yyleng;
	return T_ID;
}
yy34:
		YYDEBUG(34, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(35, *YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy34;
		}
		YYDEBUG(36, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	/* ignore whitespace */

	goto restart;
}
yy37:
		YYDEBUG(37, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\n') {
			if (yych <= 0x00) goto yy38;
			if (yych <= '\t') goto yy63;
		} else {
			if (yych == '"') goto yy58;
			goto yy63;
		}
yy38:
		YYDEBUG(38, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	return T_UNEXPECTED;
}
yy39:
		YYDEBUG(39, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		YYCTXMARKER = YYCURSOR;
		if (yych <= '.') {
			if (yych <= ',') goto yy40;
			if (yych <= '-') goto yy68;
			goto yy69;
		} else {
			if (yych <= '/') goto yy40;
			if (yych <= '9') goto yy69;
		}
yy40:
		YYDEBUG(40, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	YYSETCONDITION(INITIAL);
	return T_SEPARATOR;
}
yy41:
		YYDEBUG(41, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\n') {
			if (yych <= 0x00) goto yy38;
			if (yych <= '\t') goto yy73;
			goto yy38;
		} else {
			if (yych == '\'') goto yy58;
			goto yy73;
		}
yy42:
		YYDEBUG(42, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 1) {
			goto yy43;
		}
		if (yych == 'r') goto yy78;
		goto yy32;
yy43:
		YYDEBUG(43, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(44, *YYCURSOR);
		if (yybm[0+yych] & 1) {
			goto yy43;
		}
		if (yych <= ' ') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy45;
				if (yych <= 0x08) goto yy31;
			} else {
				if (yych == '\r') goto yy45;
				if (yych <= 0x1F) goto yy31;
			}
		} else {
			if (yych <= '&') {
				if (yych <= '!') goto yy31;
				if (yych <= '"') goto yy58;
				if (yych >= '$') goto yy31;
			} else {
				if (yych <= '\'') goto yy58;
				if (yych <= '/') goto yy31;
				if (yych <= ':') goto yy61;
				goto yy31;
			}
		}
yy45:
		YYDEBUG(45, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	phpdbg_init_param(yylval, NUMERIC_PARAM);
	yylval->num = atoi(yytext);
	return T_DIGITS;
}
yy46:
		YYDEBUG(46, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 1) {
			goto yy43;
		}
		if (yych <= 0x1F) {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy45;
				if (yych <= 0x08) goto yy32;
				goto yy45;
			} else {
				if (yych == '\r') goto yy45;
				goto yy32;
			}
		} else {
			if (yych <= '#') {
				if (yych <= ' ') goto yy45;
				if (yych <= '"') goto yy32;
				goto yy45;
			} else {
				if (yych == 'x') goto yy79;
				goto yy32;
			}
		}
yy47:
		YYDEBUG(47, *YYCURSOR);
		yych = *++YYCURSOR;
		YYCTXMARKER = YYCURSOR;
		if (yych == ':') goto yy82;
		if (yych == '\\') goto yy84;
		goto yy80;
yy48:
		YYDEBUG(48, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy86;
		if (yych == 'i') goto yy86;
		goto yy32;
yy49:
		YYDEBUG(49, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy87;
		if (yych == 'n') goto yy87;
		goto yy32;
yy50:
		YYDEBUG(50, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy88;
		if (yych == 'a') goto yy88;
		goto yy32;
yy51:
		YYDEBUG(51, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'F') goto yy89;
		if (yych == 'f') goto yy89;
		goto yy32;
yy52:
		YYDEBUG(52, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy90;
		if (yych == 'o') goto yy90;
		goto yy32;
yy53:
		YYDEBUG(53, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'N') {
			if (yych == 'F') goto yy91;
			if (yych <= 'M') goto yy32;
			goto yy92;
		} else {
			if (yych <= 'f') {
				if (yych <= 'e') goto yy32;
				goto yy91;
			} else {
				if (yych == 'n') goto yy92;
				goto yy32;
			}
		}
yy54:
		YYDEBUG(54, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy93;
		if (yych == 'r') goto yy93;
		goto yy32;
yy55:
		YYDEBUG(55, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy94;
		if (yych == 'e') goto yy94;
		goto yy32;
yy56:
		YYDEBUG(56, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy95;
		goto yy32;
yy57:
		YYDEBUG(57, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'e') goto yy96;
		goto yy32;
yy58:
		YYDEBUG(58, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy59:
		YYDEBUG(59, *YYCURSOR);
		if (yybm[0+yych] & 2) {
			goto yy58;
		}
		if (yych >= '$') goto yy97;
yy60:
		YYDEBUG(60, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 3) {
			if (yyaccept <= 1) {
				if (yyaccept == 0) {
					goto yy33;
				} else {
					goto yy38;
				}
			} else {
				if (yyaccept == 2) {
					goto yy40;
				} else {
					goto yy45;
				}
			}
		} else {
			if (yyaccept <= 5) {
				if (yyaccept == 4) {
					goto yy110;
				} else {
					goto yy113;
				}
			} else {
				if (yyaccept == 6) {
					goto yy129;
				} else {
					goto yy146;
				}
			}
		}
yy61:
		YYDEBUG(61, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '/') goto yy98;
		if (yych == '\\') goto yy84;
		goto yy60;
yy62:
		YYDEBUG(62, *YYCURSOR);
		++YYCURSOR;
		YYFILL(4);
		yych = *YYCURSOR;
yy63:
		YYDEBUG(63, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy62;
		}
		if (yych <= ' ') {
			if (yych <= 0x00) goto yy60;
			if (yych == '\n') goto yy60;
		} else {
			if (yych <= '"') goto yy99;
			if (yych <= '#') goto yy64;
			if (yych <= ':') goto yy66;
			goto yy67;
		}
yy64:
		YYDEBUG(64, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy65:
		YYDEBUG(65, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy64;
		}
		if (yych <= '\n') goto yy60;
		if (yych <= '"') goto yy100;
		goto yy101;
yy66:
		YYDEBUG(66, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '/') goto yy102;
		goto yy65;
yy67:
		YYDEBUG(67, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		if (yych <= ' ') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy60;
				if (yych <= 0x08) goto yy58;
				goto yy60;
			} else {
				if (yych == '\r') goto yy60;
				if (yych <= 0x1F) goto yy58;
				goto yy60;
			}
		} else {
			if (yych <= '9') {
				if (yych <= '!') goto yy58;
				if (yych <= '"') goto yy62;
				if (yych <= '#') goto yy60;
				goto yy58;
			} else {
				if (yych <= ':') goto yy97;
				if (yych == '\\') goto yy62;
				goto yy58;
			}
		}
yy68:
		YYDEBUG(68, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '.') goto yy69;
		if (yych <= '/') goto yy60;
		if (yych >= ':') goto yy60;
yy69:
		YYDEBUG(69, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(70, *YYCURSOR);
		if (yych == '.') goto yy69;
		if (yych <= '/') goto yy71;
		if (yych <= '9') goto yy69;
yy71:
		YYDEBUG(71, *YYCURSOR);
		YYCURSOR = YYCTXMARKER;
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	return T_POUND;
}
yy72:
		YYDEBUG(72, *YYCURSOR);
		++YYCURSOR;
		YYFILL(4);
		yych = *YYCURSOR;
yy73:
		YYDEBUG(73, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy72;
		}
		if (yych <= '\n') {
			if (yych <= 0x00) goto yy60;
			if (yych >= '\n') goto yy60;
		} else {
			if (yych <= '#') goto yy74;
			if (yych <= '\'') goto yy99;
			if (yych <= ':') goto yy76;
			goto yy77;
		}
yy74:
		YYDEBUG(74, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy75:
		YYDEBUG(75, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy74;
		}
		if (yych <= '\n') goto yy60;
		if (yych <= '\'') goto yy100;
		goto yy103;
yy76:
		YYDEBUG(76, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '/') goto yy104;
		goto yy75;
yy77:
		YYDEBUG(77, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		if (yych <= '"') {
			if (yych <= '\f') {
				if (yych <= 0x00) goto yy60;
				if (yych <= 0x08) goto yy58;
				if (yych <= '\n') goto yy60;
				goto yy58;
			} else {
				if (yych <= '\r') goto yy60;
				if (yych == ' ') goto yy60;
				goto yy58;
			}
		} else {
			if (yych <= '9') {
				if (yych <= '#') goto yy60;
				if (yych == '\'') goto yy72;
				goto yy58;
			} else {
				if (yych <= ':') goto yy97;
				if (yych == '\\') goto yy72;
				goto yy58;
			}
		}
yy78:
		YYDEBUG(78, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ' ') {
			if (yych <= '\f') {
				if (yych == '\t') goto yy105;
				goto yy32;
			} else {
				if (yych <= '\r') goto yy105;
				if (yych <= 0x1F) goto yy32;
				goto yy105;
			}
		} else {
			if (yych <= '.') {
				if (yych <= ',') goto yy32;
				if (yych <= '-') goto yy107;
				goto yy108;
			} else {
				if (yych <= '/') goto yy32;
				if (yych <= '9') goto yy108;
				goto yy32;
			}
		}
yy79:
		YYDEBUG(79, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy111;
		}
		goto yy32;
yy80:
		YYDEBUG(80, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(81, *YYCURSOR);
		YYCURSOR = YYCTXMARKER;
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	return T_COLON;
}
yy82:
		YYDEBUG(82, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(83, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	return T_DCOLON;
}
yy84:
		YYDEBUG(84, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(85, *YYCURSOR);
		if (yych <= ' ') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy33;
				if (yych <= 0x08) goto yy84;
				goto yy33;
			} else {
				if (yych == '\r') goto yy33;
				if (yych <= 0x1F) goto yy84;
				goto yy33;
			}
		} else {
			if (yych <= '&') {
				if (yych <= '!') goto yy84;
				if (yych <= '#') goto yy33;
				goto yy84;
			} else {
				if (yych <= '\'') goto yy33;
				if (yych == ':') goto yy114;
				goto yy84;
			}
		}
yy86:
		YYDEBUG(86, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy115;
		if (yych == 's') goto yy115;
		goto yy32;
yy87:
		YYDEBUG(87, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy116;
		if (yych == 'a') goto yy116;
		goto yy32;
yy88:
		YYDEBUG(88, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy117;
		if (yych == 'l') goto yy117;
		goto yy32;
yy89:
		YYDEBUG(89, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\f') {
			if (yych == '\t') goto yy118;
			goto yy32;
		} else {
			if (yych <= '\r') goto yy118;
			if (yych == ' ') goto yy118;
			goto yy32;
		}
yy90:
		YYDEBUG(90, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		YYCTXMARKER = YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x00) goto yy121;
			if (yych <= 0x08) goto yy32;
			if (yych <= '\n') goto yy121;
			goto yy32;
		} else {
			if (yych <= '\r') goto yy121;
			if (yych == ' ') goto yy121;
			goto yy32;
		}
yy91:
		YYDEBUG(91, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'F') goto yy90;
		if (yych == 'f') goto yy90;
		goto yy32;
yy92:
		YYDEBUG(92, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		YYCTXMARKER = YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x00) goto yy123;
			if (yych <= 0x08) goto yy32;
			if (yych <= '\n') goto yy123;
			goto yy32;
		} else {
			if (yych <= '\r') goto yy123;
			if (yych == ' ') goto yy123;
			goto yy32;
		}
yy93:
		YYDEBUG(93, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'U') goto yy125;
		if (yych == 'u') goto yy125;
		goto yy32;
yy94:
		YYDEBUG(94, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy92;
		if (yych == 's') goto yy92;
		goto yy32;
yy95:
		YYDEBUG(95, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy126;
		goto yy32;
yy96:
		YYDEBUG(96, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'n') goto yy127;
		goto yy32;
yy97:
		YYDEBUG(97, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '/') goto yy60;
yy98:
		YYDEBUG(98, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '/') goto yy128;
		goto yy60;
yy99:
		YYDEBUG(99, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\r') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy33;
				goto yy59;
			} else {
				if (yych <= '\n') goto yy33;
				if (yych <= '\f') goto yy59;
				goto yy33;
			}
		} else {
			if (yych <= ' ') {
				if (yych <= 0x1F) goto yy59;
				goto yy33;
			} else {
				if (yych == '#') goto yy33;
				goto yy59;
			}
		}
yy100:
		YYDEBUG(100, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy33;
yy101:
		YYDEBUG(101, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych == '"') goto yy64;
		if (yych == '\\') goto yy64;
		goto yy60;
yy102:
		YYDEBUG(102, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '/') goto yy130;
		goto yy65;
yy103:
		YYDEBUG(103, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych == '\'') goto yy74;
		if (yych == '\\') goto yy74;
		goto yy60;
yy104:
		YYDEBUG(104, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '/') goto yy131;
		goto yy75;
yy105:
		YYDEBUG(105, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(106, *YYCURSOR);
		if (yych <= ' ') {
			if (yych <= '\f') {
				if (yych == '\t') goto yy105;
				goto yy60;
			} else {
				if (yych <= '\r') goto yy105;
				if (yych <= 0x1F) goto yy60;
				goto yy105;
			}
		} else {
			if (yych <= '.') {
				if (yych <= ',') goto yy60;
				if (yych <= '-') goto yy132;
				goto yy133;
			} else {
				if (yych <= '/') goto yy60;
				if (yych <= '9') goto yy133;
				goto yy60;
			}
		}
yy107:
		YYDEBUG(107, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '.') goto yy108;
		if (yych <= '/') goto yy32;
		if (yych >= ':') goto yy32;
yy108:
		YYDEBUG(108, *YYCURSOR);
		yyaccept = 4;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(109, *YYCURSOR);
		if (yych <= '"') {
			if (yych <= '\f') {
				if (yych <= 0x00) goto yy110;
				if (yych <= 0x08) goto yy31;
				if (yych >= '\v') goto yy31;
			} else {
				if (yych <= 0x1F) {
					if (yych >= 0x0E) goto yy31;
				} else {
					if (yych <= ' ') goto yy110;
					if (yych <= '!') goto yy31;
					goto yy58;
				}
			}
		} else {
			if (yych <= '-') {
				if (yych <= '#') goto yy110;
				if (yych == '\'') goto yy58;
				goto yy31;
			} else {
				if (yych <= '/') {
					if (yych <= '.') goto yy108;
					goto yy31;
				} else {
					if (yych <= '9') goto yy108;
					if (yych <= ':') goto yy61;
					goto yy31;
				}
			}
		}
yy110:
		YYDEBUG(110, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	char *text = yytext + 2;
	while (*++text < '0');
	yylval->num = atoi(text);
	return T_REQ_ID;
}
yy111:
		YYDEBUG(111, *YYCURSOR);
		yyaccept = 5;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(112, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy111;
		}
		if (yych <= ' ') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy113;
				if (yych <= 0x08) goto yy31;
			} else {
				if (yych == '\r') goto yy113;
				if (yych <= 0x1F) goto yy31;
			}
		} else {
			if (yych <= '&') {
				if (yych <= '!') goto yy31;
				if (yych <= '"') goto yy58;
				if (yych >= '$') goto yy31;
			} else {
				if (yych <= '\'') goto yy58;
				if (yych <= '/') goto yy31;
				if (yych <= ':') goto yy61;
				goto yy31;
			}
		}
yy113:
		YYDEBUG(113, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	phpdbg_init_param(yylval, ADDR_PARAM);
	yylval->addr = strtoul(yytext, 0, 16);
	return T_ADDR;
}
yy114:
		YYDEBUG(114, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych == '\\') goto yy84;
		goto yy60;
yy115:
		YYDEBUG(115, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy135;
		if (yych == 'a') goto yy135;
		goto yy32;
yy116:
		YYDEBUG(116, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'B') goto yy136;
		if (yych == 'b') goto yy136;
		goto yy32;
yy117:
		YYDEBUG(117, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy137;
		if (yych == 's') goto yy137;
		goto yy32;
yy118:
		YYDEBUG(118, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(119, *YYCURSOR);
		if (yych <= '\f') {
			if (yych == '\t') goto yy118;
		} else {
			if (yych <= '\r') goto yy118;
			if (yych == ' ') goto yy118;
		}
		YYDEBUG(120, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	YYSETCONDITION(RAW);
	phpdbg_init_param(yylval, EMPTY_PARAM);
	return T_IF;
}
yy121:
		YYDEBUG(121, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(122, *YYCURSOR);
		YYCURSOR = YYCTXMARKER;
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	phpdbg_init_param(yylval, NUMERIC_PARAM);
	yylval->num = 0;
	return T_FALSY;
}
yy123:
		YYDEBUG(123, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(124, *YYCURSOR);
		YYCURSOR = YYCTXMARKER;
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	phpdbg_init_param(yylval, NUMERIC_PARAM);
	yylval->num = 1;
	return T_TRUTHY;
}
yy125:
		YYDEBUG(125, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy92;
		if (yych == 'e') goto yy92;
		goto yy32;
yy126:
		YYDEBUG(126, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy138;
		goto yy32;
yy127:
		YYDEBUG(127, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'd') goto yy138;
		goto yy32;
yy128:
		YYDEBUG(128, *YYCURSOR);
		++YYCURSOR;
yy129:
		YYDEBUG(129, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	phpdbg_init_param(yylval, STR_PARAM);
	yylval->str = estrndup(yytext, yyleng);
	yylval->len = yyleng;
	return T_PROTO;
}
yy130:
		YYDEBUG(130, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x00) goto yy129;
		if (yych == '\n') goto yy129;
		goto yy65;
yy131:
		YYDEBUG(131, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x00) goto yy129;
		if (yych == '\n') goto yy129;
		goto yy75;
yy132:
		YYDEBUG(132, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '.') goto yy133;
		if (yych <= '/') goto yy60;
		if (yych >= ':') goto yy60;
yy133:
		YYDEBUG(133, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(134, *YYCURSOR);
		if (yych == '.') goto yy133;
		if (yych <= '/') goto yy110;
		if (yych <= '9') goto yy133;
		goto yy110;
yy135:
		YYDEBUG(135, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'B') goto yy139;
		if (yych == 'b') goto yy139;
		goto yy32;
yy136:
		YYDEBUG(136, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy140;
		if (yych == 'l') goto yy140;
		goto yy32;
yy137:
		YYDEBUG(137, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy90;
		if (yych == 'e') goto yy90;
		goto yy32;
yy138:
		YYDEBUG(138, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy141;
		goto yy32;
yy139:
		YYDEBUG(139, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy142;
		if (yych == 'l') goto yy142;
		goto yy32;
yy140:
		YYDEBUG(140, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy143;
		if (yych == 'e') goto yy143;
		goto yy32;
yy141:
		YYDEBUG(141, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy144;
		}
		goto yy32;
yy142:
		YYDEBUG(142, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy147;
		if (yych == 'e') goto yy147;
		goto yy32;
yy143:
		YYDEBUG(143, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy92;
		if (yych == 'd') goto yy92;
		goto yy32;
yy144:
		YYDEBUG(144, *YYCURSOR);
		yyaccept = 7;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(145, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy144;
		}
		if (yych <= ' ') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy146;
				if (yych <= 0x08) goto yy31;
			} else {
				if (yych == '\r') goto yy146;
				if (yych <= 0x1F) goto yy31;
			}
		} else {
			if (yych <= '&') {
				if (yych <= '!') goto yy31;
				if (yych <= '"') goto yy58;
				if (yych >= '$') goto yy31;
			} else {
				if (yych <= '\'') goto yy58;
				if (yych == ':') goto yy61;
				goto yy31;
			}
		}
yy146:
		YYDEBUG(146, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	phpdbg_init_param(yylval, OP_PARAM);
	yylval->str = estrndup(yytext, yyleng);
	yylval->len = yyleng;
	return T_OPCODE;
}
yy147:
		YYDEBUG(147, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy90;
		if (yych == 'd') goto yy90;
		goto yy32;
	}
/* *********************************** */
yyc_PRE_RAW:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,  64,   0,   0,   0,  64,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 64,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0, 128,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
		};
		YYDEBUG(148, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych == '\t') goto yy152;
			if (yych >= '\r') goto yy152;
		} else {
			if (yych <= ' ') {
				if (yych >= ' ') goto yy153;
			} else {
				if (yych == '-') goto yy156;
			}
		}
		YYDEBUG(150, *YYCURSOR);
		++YYCURSOR;
yy151:
		YYDEBUG(151, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	YYSETCONDITION(RAW);

	YYCURSOR = LEX(text);
	goto restart;
}
yy152:
		YYDEBUG(152, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy153;
		}
		goto yy151;
yy153:
		YYDEBUG(153, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(154, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy153;
		}
		YYDEBUG(155, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	/* ignore whitespace */

	goto restart;
}
yy156:
		YYDEBUG(156, *YYCURSOR);
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych != 'r') goto yy151;
yy157:
		YYDEBUG(157, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(158, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy161;
		}
		if (yych <= '\r') {
			if (yych == '\t') goto yy157;
			if (yych >= '\r') goto yy157;
		} else {
			if (yych <= ' ') {
				if (yych >= ' ') goto yy157;
			} else {
				if (yych == '-') goto yy160;
			}
		}
yy159:
		YYDEBUG(159, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy151;
yy160:
		YYDEBUG(160, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy161;
		}
		goto yy159;
yy161:
		YYDEBUG(161, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(162, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy161;
		}
		YYDEBUG(163, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	char *text = yytext + 2;
	while (*++text < '0');
	yylval->num = atoi(text);
	return T_REQ_ID;
}
	}
/* *********************************** */
yyc_RAW:
	{
		static const unsigned char yybm[] = {
			  0, 232, 232, 232, 232, 232, 232, 232, 
			232, 232,   0, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232,  64, 224, 232, 232, 232,  32, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232,  16, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
		};
		YYDEBUG(164, *YYCURSOR);
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 8) {
			goto yy168;
		}
		if (yych <= '\n') goto yy166;
		if (yych <= '"') goto yy171;
		if (yych <= '#') goto yy173;
		if (yych <= '\'') goto yy175;
		goto yy176;
yy166:
		YYDEBUG(166, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(167, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	return 0;
}
yy168:
		YYDEBUG(168, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(169, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy168;
		}
		if (yych <= '\n') goto yy170;
		if (yych <= '"') goto yy171;
		if (yych <= '#') goto yy170;
		if (yych <= '\'') goto yy175;
		goto yy176;
yy170:
		YYDEBUG(170, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	phpdbg_init_param(yylval, STR_PARAM);
	yylval->str = estrdup(yytext);
	yylval->len = yyleng;
	return T_INPUT;
}
yy171:
		YYDEBUG(171, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 32) {
			goto yy178;
		}
		if (yych >= '#') goto yy180;
yy172:
		YYDEBUG(172, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy170;
yy173:
		YYDEBUG(173, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(174, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	YYSETCONDITION(INITIAL);
	return T_SEPARATOR;
}
yy175:
		YYDEBUG(175, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy182;
		}
		if (yych <= '\'') goto yy172;
		goto yy184;
yy176:
		YYDEBUG(176, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(177, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy176;
		}
		if (yych <= '!') {
			if (yych <= 0x00) goto yy170;
			if (yych == '\n') goto yy170;
			goto yy168;
		} else {
			if (yych <= '"') goto yy186;
			if (yych == '\'') goto yy187;
			goto yy168;
		}
yy178:
		YYDEBUG(178, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(179, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy178;
		}
		if (yych <= '\n') goto yy172;
		if (yych <= '"') goto yy168;
yy180:
		YYDEBUG(180, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(181, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy178;
		}
		if (yych <= '\n') goto yy172;
		if (yych <= '"') goto yy188;
		goto yy180;
yy182:
		YYDEBUG(182, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(183, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy182;
		}
		if (yych <= '\n') goto yy172;
		if (yych <= '\'') goto yy168;
yy184:
		YYDEBUG(184, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(185, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy182;
		}
		if (yych <= '\n') goto yy172;
		if (yych <= '\'') goto yy190;
		goto yy184;
yy186:
		YYDEBUG(186, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '"') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy170;
				goto yy188;
			} else {
				if (yych <= '\n') goto yy170;
				if (yych <= '!') goto yy188;
				goto yy171;
			}
		} else {
			if (yych <= '\'') {
				if (yych <= '#') goto yy178;
				if (yych <= '&') goto yy188;
				goto yy192;
			} else {
				if (yych == '\\') goto yy193;
				goto yy188;
			}
		}
yy187:
		YYDEBUG(187, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '"') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy170;
				goto yy190;
			} else {
				if (yych <= '\n') goto yy170;
				if (yych <= '!') goto yy190;
				goto yy195;
			}
		} else {
			if (yych <= '\'') {
				if (yych <= '#') goto yy182;
				if (yych <= '&') goto yy190;
				goto yy175;
			} else {
				if (yych == '\\') goto yy196;
				goto yy190;
			}
		}
yy188:
		YYDEBUG(188, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(189, *YYCURSOR);
		if (yych <= '"') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy170;
				goto yy188;
			} else {
				if (yych <= '\n') goto yy170;
				if (yych <= '!') goto yy188;
				goto yy186;
			}
		} else {
			if (yych <= '\'') {
				if (yych <= '#') goto yy178;
				if (yych <= '&') goto yy188;
				goto yy192;
			} else {
				if (yych == '\\') goto yy193;
				goto yy188;
			}
		}
yy190:
		YYDEBUG(190, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(191, *YYCURSOR);
		if (yych <= '"') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy170;
				goto yy190;
			} else {
				if (yych <= '\n') goto yy170;
				if (yych <= '!') goto yy190;
				goto yy195;
			}
		} else {
			if (yych <= '\'') {
				if (yych <= '#') goto yy182;
				if (yych <= '&') goto yy190;
				goto yy187;
			} else {
				if (yych == '\\') goto yy196;
				goto yy190;
			}
		}
yy192:
		YYDEBUG(192, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy198;
		}
		if (yych <= '\n') goto yy172;
		if (yych <= '"') goto yy190;
		if (yych <= '\'') goto yy178;
		goto yy200;
yy193:
		YYDEBUG(193, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(194, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= 0x00) goto yy170;
			if (yych == '\n') goto yy170;
			goto yy188;
		} else {
			if (yych <= '\'') goto yy202;
			if (yych == '\\') goto yy193;
			goto yy188;
		}
yy195:
		YYDEBUG(195, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy198;
		}
		if (yych <= '\n') goto yy172;
		if (yych <= '"') goto yy182;
		if (yych <= '\'') goto yy188;
		goto yy200;
yy196:
		YYDEBUG(196, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(197, *YYCURSOR);
		if (yych <= '!') {
			if (yych <= 0x00) goto yy170;
			if (yych == '\n') goto yy170;
			goto yy190;
		} else {
			if (yych <= '"') goto yy203;
			if (yych == '\\') goto yy196;
			goto yy190;
		}
yy198:
		YYDEBUG(198, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(199, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy198;
		}
		if (yych <= '\n') goto yy172;
		if (yych <= '"') goto yy190;
		if (yych <= '\'') goto yy188;
yy200:
		YYDEBUG(200, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(201, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy198;
		}
		if (yych <= '\n') goto yy172;
		if (yych <= '\'') goto yy204;
		goto yy200;
yy202:
		YYDEBUG(202, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '"') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy170;
				goto yy204;
			} else {
				if (yych <= '\n') goto yy170;
				if (yych <= '!') goto yy204;
			}
		} else {
			if (yych <= '\'') {
				if (yych <= '#') goto yy198;
				if (yych <= '&') goto yy204;
				goto yy192;
			} else {
				if (yych == '\\') goto yy206;
				goto yy204;
			}
		}
yy203:
		YYDEBUG(203, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '"') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy170;
			} else {
				if (yych <= '\n') goto yy170;
				if (yych >= '"') goto yy195;
			}
		} else {
			if (yych <= '\'') {
				if (yych <= '#') goto yy198;
				if (yych >= '\'') goto yy202;
			} else {
				if (yych == '\\') goto yy206;
			}
		}
yy204:
		YYDEBUG(204, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(205, *YYCURSOR);
		if (yych <= '"') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy170;
				goto yy204;
			} else {
				if (yych <= '\n') goto yy170;
				if (yych <= '!') goto yy204;
				goto yy203;
			}
		} else {
			if (yych <= '\'') {
				if (yych <= '#') goto yy198;
				if (yych <= '&') goto yy204;
				goto yy202;
			} else {
				if (yych != '\\') goto yy204;
			}
		}
yy206:
		YYDEBUG(206, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(207, *YYCURSOR);
		if (yych <= '\n') {
			if (yych <= 0x00) goto yy170;
			if (yych <= '\t') goto yy204;
			goto yy170;
		} else {
			if (yych == '\\') goto yy206;
			goto yy204;
		}
	}
}

}
