/* Generated by re2c 1.0.1 */
#line 1 "Zend/zend_language_scanner.l"
/*
   +----------------------------------------------------------------------+
   | Zend Engine                                                          |
   +----------------------------------------------------------------------+
   | Copyright (c) 1998-2018 Zend Technologies Ltd. (http://www.zend.com) |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.00 of the Zend license,     |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.zend.com/license/2_00.txt.                                |
   | If you did not receive a copy of the Zend license and are unable to  |
   | obtain it through the world-wide-web, please send a note to          |
   | license@zend.com so we can mail you a copy immediately.              |
   +----------------------------------------------------------------------+
   | Authors: Marcus Boerger <helly@php.net>                              |
   |          Nuno Lopes <nlopess@php.net>                                |
   |          Scott MacVicar <scottmac@php.net>                           |
   | Flex version authors:                                                |
   |          Andi Gutmans <andi@php.net>                                 |
   |          Zeev Suraski <zeev@php.net>                                 |
   +----------------------------------------------------------------------+
*/

#if 0
# define YYDEBUG(s, c) printf("state: %d char: %c\n", s, c)
#else
# define YYDEBUG(s, c)
#endif

#include "zend_language_scanner_defs.h"

#include <errno.h>
#include "zend.h"
#ifdef ZEND_WIN32
# include <Winuser.h>
#endif
#include "zend_alloc.h"
#include <zend_language_parser.h>
#include "zend_compile.h"
#include "zend_language_scanner.h"
#include "zend_highlight.h"
#include "zend_constants.h"
#include "zend_variables.h"
#include "zend_operators.h"
#include "zend_API.h"
#include "zend_strtod.h"
#include "zend_exceptions.h"
#include "zend_virtual_cwd.h"
#include "tsrm_config_common.h"

#define YYCTYPE   unsigned char
#define YYFILL(n) { if ((YYCURSOR + n) >= (YYLIMIT + ZEND_MMAP_AHEAD)) { return 0; } }
#define YYCURSOR  SCNG(yy_cursor)
#define YYLIMIT   SCNG(yy_limit)
#define YYMARKER  SCNG(yy_marker)

#define YYGETCONDITION()  SCNG(yy_state)
#define YYSETCONDITION(s) SCNG(yy_state) = s

#define STATE(name)  yyc##name

/* emulate flex constructs */
#define BEGIN(state) YYSETCONDITION(STATE(state))
#define YYSTATE      YYGETCONDITION()
#define yytext       ((char*)SCNG(yy_text))
#define yyleng       SCNG(yy_leng)
#define yyless(x)    do { YYCURSOR = (unsigned char*)yytext + x; \
                          yyleng   = (unsigned int)x; } while(0)
#define yymore()     goto yymore_restart

/* perform sanity check. If this message is triggered you should
   increase the ZEND_MMAP_AHEAD value in the zend_streams.h file */
#define YYMAXFILL 16

#if ZEND_MMAP_AHEAD < YYMAXFILL
# error ZEND_MMAP_AHEAD should be greater than or equal to YYMAXFILL
#endif

#ifdef HAVE_STDARG_H
# include <stdarg.h>
#endif

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif

/* Globals Macros */
#define SCNG	LANG_SCNG
#ifdef ZTS
ZEND_API ts_rsrc_id language_scanner_globals_id;
#else
ZEND_API zend_php_scanner_globals language_scanner_globals;
#endif

#define HANDLE_NEWLINES(s, l)													\
do {																			\
	char *p = (s), *boundary = p+(l);											\
																				\
	while (p<boundary) {														\
		if (*p == '\n' || (*p == '\r' && (*(p+1) != '\n'))) {					\
			CG(zend_lineno)++;													\
		}																		\
		p++;																	\
	}																			\
} while (0)

#define HANDLE_NEWLINE(c) \
{ \
	if (c == '\n' || c == '\r') { \
		CG(zend_lineno)++; \
	} \
}

/* To save initial string length after scanning to first variable */
#define SET_DOUBLE_QUOTES_SCANNED_LENGTH(len) SCNG(scanned_string_len) = (len)
#define GET_DOUBLE_QUOTES_SCANNED_LENGTH()    SCNG(scanned_string_len)

#define IS_LABEL_START(c) (((c) >= 'a' && (c) <= 'z') || ((c) >= 'A' && (c) <= 'Z') || (c) == '_' || (c) >= 0x80)

#define ZEND_IS_OCT(c)  ((c)>='0' && (c)<='7')
#define ZEND_IS_HEX(c)  (((c)>='0' && (c)<='9') || ((c)>='a' && (c)<='f') || ((c)>='A' && (c)<='F'))

BEGIN_EXTERN_C()

static size_t encoding_filter_script_to_internal(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding();
	ZEND_ASSERT(internal_encoding);
	return zend_multibyte_encoding_converter(to, to_length, from, from_length, internal_encoding, LANG_SCNG(script_encoding));
}

static size_t encoding_filter_script_to_intermediate(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	return zend_multibyte_encoding_converter(to, to_length, from, from_length, zend_multibyte_encoding_utf8, LANG_SCNG(script_encoding));
}

static size_t encoding_filter_intermediate_to_script(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	return zend_multibyte_encoding_converter(to, to_length, from, from_length,
LANG_SCNG(script_encoding), zend_multibyte_encoding_utf8);
}

static size_t encoding_filter_intermediate_to_internal(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding();
	ZEND_ASSERT(internal_encoding);
	return zend_multibyte_encoding_converter(to, to_length, from, from_length,
internal_encoding, zend_multibyte_encoding_utf8);
}


static void _yy_push_state(int new_state)
{
	zend_stack_push(&SCNG(state_stack), (void *) &YYGETCONDITION());
	YYSETCONDITION(new_state);
}

#define yy_push_state(state_and_tsrm) _yy_push_state(yyc##state_and_tsrm)

static void yy_pop_state(void)
{
	int *stack_state = zend_stack_top(&SCNG(state_stack));
	YYSETCONDITION(*stack_state);
	zend_stack_del_top(&SCNG(state_stack));
}

static void yy_scan_buffer(char *str, unsigned int len)
{
	YYCURSOR       = (YYCTYPE*)str;
	YYLIMIT        = YYCURSOR + len;
	if (!SCNG(yy_start)) {
		SCNG(yy_start) = YYCURSOR;
	}
}

void startup_scanner(void)
{
	CG(parse_error) = 0;
	CG(doc_comment) = NULL;
	CG(extra_fn_flags) = 0;
	zend_stack_init(&SCNG(state_stack), sizeof(int));
	zend_ptr_stack_init(&SCNG(heredoc_label_stack));
	SCNG(heredoc_scan_ahead) = 0;
}

static void heredoc_label_dtor(zend_heredoc_label *heredoc_label) {
    efree(heredoc_label->label);
}

void shutdown_scanner(void)
{
	CG(parse_error) = 0;
	RESET_DOC_COMMENT();
	zend_stack_destroy(&SCNG(state_stack));
	zend_ptr_stack_clean(&SCNG(heredoc_label_stack), (void (*)(void *)) &heredoc_label_dtor, 1);
	zend_ptr_stack_destroy(&SCNG(heredoc_label_stack));
	SCNG(heredoc_scan_ahead) = 0;
	SCNG(on_event) = NULL;
}

ZEND_API void zend_save_lexical_state(zend_lex_state *lex_state)
{
	lex_state->yy_leng   = SCNG(yy_leng);
	lex_state->yy_start  = SCNG(yy_start);
	lex_state->yy_text   = SCNG(yy_text);
	lex_state->yy_cursor = SCNG(yy_cursor);
	lex_state->yy_marker = SCNG(yy_marker);
	lex_state->yy_limit  = SCNG(yy_limit);

	lex_state->state_stack = SCNG(state_stack);
	zend_stack_init(&SCNG(state_stack), sizeof(int));

	lex_state->heredoc_label_stack = SCNG(heredoc_label_stack);
	zend_ptr_stack_init(&SCNG(heredoc_label_stack));

	lex_state->in = SCNG(yy_in);
	lex_state->yy_state = YYSTATE;
	lex_state->filename = zend_get_compiled_filename();
	lex_state->lineno = CG(zend_lineno);

	lex_state->script_org = SCNG(script_org);
	lex_state->script_org_size = SCNG(script_org_size);
	lex_state->script_filtered = SCNG(script_filtered);
	lex_state->script_filtered_size = SCNG(script_filtered_size);
	lex_state->input_filter = SCNG(input_filter);
	lex_state->output_filter = SCNG(output_filter);
	lex_state->script_encoding = SCNG(script_encoding);

	lex_state->on_event = SCNG(on_event);
	lex_state->on_event_context = SCNG(on_event_context);

	lex_state->ast = CG(ast);
	lex_state->ast_arena = CG(ast_arena);
}

ZEND_API void zend_restore_lexical_state(zend_lex_state *lex_state)
{
	SCNG(yy_leng)   = lex_state->yy_leng;
	SCNG(yy_start)  = lex_state->yy_start;
	SCNG(yy_text)   = lex_state->yy_text;
	SCNG(yy_cursor) = lex_state->yy_cursor;
	SCNG(yy_marker) = lex_state->yy_marker;
	SCNG(yy_limit)  = lex_state->yy_limit;

	zend_stack_destroy(&SCNG(state_stack));
	SCNG(state_stack) = lex_state->state_stack;

	zend_ptr_stack_clean(&SCNG(heredoc_label_stack), (void (*)(void *)) &heredoc_label_dtor, 1);
	zend_ptr_stack_destroy(&SCNG(heredoc_label_stack));
	SCNG(heredoc_label_stack) = lex_state->heredoc_label_stack;

	SCNG(yy_in) = lex_state->in;
	YYSETCONDITION(lex_state->yy_state);
	CG(zend_lineno) = lex_state->lineno;
	zend_restore_compiled_filename(lex_state->filename);

	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	SCNG(script_org) = lex_state->script_org;
	SCNG(script_org_size) = lex_state->script_org_size;
	SCNG(script_filtered) = lex_state->script_filtered;
	SCNG(script_filtered_size) = lex_state->script_filtered_size;
	SCNG(input_filter) = lex_state->input_filter;
	SCNG(output_filter) = lex_state->output_filter;
	SCNG(script_encoding) = lex_state->script_encoding;

	SCNG(on_event) = lex_state->on_event;
	SCNG(on_event_context) = lex_state->on_event_context;

	CG(ast) = lex_state->ast;
	CG(ast_arena) = lex_state->ast_arena;

	RESET_DOC_COMMENT();
}

ZEND_API void zend_destroy_file_handle(zend_file_handle *file_handle)
{
	zend_llist_del_element(&CG(open_files), file_handle, (int (*)(void *, void *)) zend_compare_file_handles);
	/* zend_file_handle_dtor() operates on the copy, so we have to NULLify the original here */
	file_handle->opened_path = NULL;
	if (file_handle->free_filename) {
		file_handle->filename = NULL;
	}
}

ZEND_API void zend_lex_tstring(zval *zv)
{
	if (SCNG(on_event)) {
		SCNG(on_event)(ON_FEEDBACK, T_STRING, 0, SCNG(on_event_context));
	}

	ZVAL_STRINGL(zv, (char*)SCNG(yy_text), SCNG(yy_leng));
}

#define BOM_UTF32_BE	"\x00\x00\xfe\xff"
#define	BOM_UTF32_LE	"\xff\xfe\x00\x00"
#define	BOM_UTF16_BE	"\xfe\xff"
#define	BOM_UTF16_LE	"\xff\xfe"
#define	BOM_UTF8		"\xef\xbb\xbf"

static const zend_encoding *zend_multibyte_detect_utf_encoding(const unsigned char *script, size_t script_size)
{
	const unsigned char *p;
	int wchar_size = 2;
	int le = 0;

	/* utf-16 or utf-32? */
	p = script;
	assert(p >= script);
	while ((size_t)(p-script) < script_size) {
		p = memchr(p, 0, script_size-(p-script)-2);
		if (!p) {
			break;
		}
		if (*(p+1) == '\0' && *(p+2) == '\0') {
			wchar_size = 4;
			break;
		}

		/* searching for UTF-32 specific byte orders, so this will do */
		p += 4;
	}

	/* BE or LE? */
	p = script;
	assert(p >= script);
	while ((size_t)(p-script) < script_size) {
		if (*p == '\0' && *(p+wchar_size-1) != '\0') {
			/* BE */
			le = 0;
			break;
		} else if (*p != '\0' && *(p+wchar_size-1) == '\0') {
			/* LE* */
			le = 1;
			break;
		}
		p += wchar_size;
	}

	if (wchar_size == 2) {
		return le ? zend_multibyte_encoding_utf16le : zend_multibyte_encoding_utf16be;
	} else {
		return le ? zend_multibyte_encoding_utf32le : zend_multibyte_encoding_utf32be;
	}

	return NULL;
}

static const zend_encoding* zend_multibyte_detect_unicode(void)
{
	const zend_encoding *script_encoding = NULL;
	int bom_size;
	unsigned char *pos1, *pos2;

	if (LANG_SCNG(script_org_size) < sizeof(BOM_UTF32_LE)-1) {
		return NULL;
	}

	/* check out BOM */
	if (!memcmp(LANG_SCNG(script_org), BOM_UTF32_BE, sizeof(BOM_UTF32_BE)-1)) {
		script_encoding = zend_multibyte_encoding_utf32be;
		bom_size = sizeof(BOM_UTF32_BE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF32_LE, sizeof(BOM_UTF32_LE)-1)) {
		script_encoding = zend_multibyte_encoding_utf32le;
		bom_size = sizeof(BOM_UTF32_LE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF16_BE, sizeof(BOM_UTF16_BE)-1)) {
		script_encoding = zend_multibyte_encoding_utf16be;
		bom_size = sizeof(BOM_UTF16_BE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF16_LE, sizeof(BOM_UTF16_LE)-1)) {
		script_encoding = zend_multibyte_encoding_utf16le;
		bom_size = sizeof(BOM_UTF16_LE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF8, sizeof(BOM_UTF8)-1)) {
		script_encoding = zend_multibyte_encoding_utf8;
		bom_size = sizeof(BOM_UTF8)-1;
	}

	if (script_encoding) {
		/* remove BOM */
		LANG_SCNG(script_org) += bom_size;
		LANG_SCNG(script_org_size) -= bom_size;

		return script_encoding;
	}

	/* script contains NULL bytes -> auto-detection */
	if ((pos1 = memchr(LANG_SCNG(script_org), 0, LANG_SCNG(script_org_size)))) {
		/* check if the NULL byte is after the __HALT_COMPILER(); */
		pos2 = LANG_SCNG(script_org);

		while ((size_t)(pos1 - pos2) >= sizeof("__HALT_COMPILER();")-1) {
			pos2 = memchr(pos2, '_', pos1 - pos2);
			if (!pos2) break;
			pos2++;
			if (strncasecmp((char*)pos2, "_HALT_COMPILER", sizeof("_HALT_COMPILER")-1) == 0) {
				pos2 += sizeof("_HALT_COMPILER")-1;
				while (*pos2 == ' '  ||
					   *pos2 == '\t' ||
					   *pos2 == '\r' ||
					   *pos2 == '\n') {
					pos2++;
				}
				if (*pos2 == '(') {
					pos2++;
					while (*pos2 == ' '  ||
						   *pos2 == '\t' ||
						   *pos2 == '\r' ||
						   *pos2 == '\n') {
						pos2++;
					}
					if (*pos2 == ')') {
						pos2++;
						while (*pos2 == ' '  ||
							   *pos2 == '\t' ||
							   *pos2 == '\r' ||
							   *pos2 == '\n') {
							pos2++;
						}
						if (*pos2 == ';') {
							return NULL;
						}
					}
				}
			}
		}
		/* make best effort if BOM is missing */
		return zend_multibyte_detect_utf_encoding(LANG_SCNG(script_org), LANG_SCNG(script_org_size));
	}

	return NULL;
}

static const zend_encoding* zend_multibyte_find_script_encoding(void)
{
	const zend_encoding *script_encoding;

	if (CG(detect_unicode)) {
		/* check out bom(byte order mark) and see if containing wchars */
		script_encoding = zend_multibyte_detect_unicode();
		if (script_encoding != NULL) {
			/* bom or wchar detection is prior to 'script_encoding' option */
			return script_encoding;
		}
	}

	/* if no script_encoding specified, just leave alone */
	if (!CG(script_encoding_list) || !CG(script_encoding_list_size)) {
		return NULL;
	}

	/* if multiple encodings specified, detect automagically */
	if (CG(script_encoding_list_size) > 1) {
		return zend_multibyte_encoding_detector(LANG_SCNG(script_org), LANG_SCNG(script_org_size), CG(script_encoding_list), CG(script_encoding_list_size));
	}

	return CG(script_encoding_list)[0];
}

ZEND_API int zend_multibyte_set_filter(const zend_encoding *onetime_encoding)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding();
	const zend_encoding *script_encoding = onetime_encoding ? onetime_encoding: zend_multibyte_find_script_encoding();

	if (!script_encoding) {
		return FAILURE;
	}

	/* judge input/output filter */
	LANG_SCNG(script_encoding) = script_encoding;
	LANG_SCNG(input_filter) = NULL;
	LANG_SCNG(output_filter) = NULL;

	if (!internal_encoding || LANG_SCNG(script_encoding) == internal_encoding) {
		if (!zend_multibyte_check_lexer_compatibility(LANG_SCNG(script_encoding))) {
			/* and if not, work around w/ script_encoding -> utf-8 -> script_encoding conversion */
			LANG_SCNG(input_filter) = encoding_filter_script_to_intermediate;
			LANG_SCNG(output_filter) = encoding_filter_intermediate_to_script;
		} else {
			LANG_SCNG(input_filter) = NULL;
			LANG_SCNG(output_filter) = NULL;
		}
		return SUCCESS;
	}

	if (zend_multibyte_check_lexer_compatibility(internal_encoding)) {
		LANG_SCNG(input_filter) = encoding_filter_script_to_internal;
		LANG_SCNG(output_filter) = NULL;
	} else if (zend_multibyte_check_lexer_compatibility(LANG_SCNG(script_encoding))) {
		LANG_SCNG(input_filter) = NULL;
		LANG_SCNG(output_filter) = encoding_filter_script_to_internal;
	} else {
		/* both script and internal encodings are incompatible w/ flex */
		LANG_SCNG(input_filter) = encoding_filter_script_to_intermediate;
		LANG_SCNG(output_filter) = encoding_filter_intermediate_to_internal;
	}

	return 0;
}

ZEND_API int open_file_for_scanning(zend_file_handle *file_handle)
{
	char *buf;
	size_t size, offset = 0;
	zend_string *compiled_filename;

	/* The shebang line was read, get the current position to obtain the buffer start */
	if (CG(start_lineno) == 2 && file_handle->type == ZEND_HANDLE_FP && file_handle->handle.fp) {
		if ((offset = ftell(file_handle->handle.fp)) == (size_t)-1) {
			offset = 0;
		}
	}

	if (zend_stream_fixup(file_handle, &buf, &size) == FAILURE) {
		return FAILURE;
	}

	zend_llist_add_element(&CG(open_files), file_handle);
	if (file_handle->handle.stream.handle >= (void*)file_handle && file_handle->handle.stream.handle <= (void*)(file_handle+1)) {
		zend_file_handle *fh = (zend_file_handle*)zend_llist_get_last(&CG(open_files));
		size_t diff = (char*)file_handle->handle.stream.handle - (char*)file_handle;
		fh->handle.stream.handle = (void*)(((char*)fh) + diff);
		file_handle->handle.stream.handle = fh->handle.stream.handle;
	}

	/* Reset the scanner for scanning the new file */
	SCNG(yy_in) = file_handle;
	SCNG(yy_start) = NULL;

	if (size != (size_t)-1) {
		if (CG(multibyte)) {
			SCNG(script_org) = (unsigned char*)buf;
			SCNG(script_org_size) = size;
			SCNG(script_filtered) = NULL;

			zend_multibyte_set_filter(NULL);

			if (SCNG(input_filter)) {
				if ((size_t)-1 == SCNG(input_filter)(&SCNG(script_filtered), &SCNG(script_filtered_size), SCNG(script_org), SCNG(script_org_size))) {
					zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
							"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
				}
				buf = (char*)SCNG(script_filtered);
				size = SCNG(script_filtered_size);
			}
		}
		SCNG(yy_start) = (unsigned char *)buf - offset;
		yy_scan_buffer(buf, (unsigned int)size);
	} else {
		zend_error_noreturn(E_COMPILE_ERROR, "zend_stream_mmap() failed");
	}

	BEGIN(INITIAL);

	if (file_handle->opened_path) {
		compiled_filename = zend_string_copy(file_handle->opened_path);
	} else {
		compiled_filename = zend_string_init(file_handle->filename, strlen(file_handle->filename), 0);
	}

	zend_set_compiled_filename(compiled_filename);
	zend_string_release_ex(compiled_filename, 0);

	if (CG(start_lineno)) {
		CG(zend_lineno) = CG(start_lineno);
		CG(start_lineno) = 0;
	} else {
		CG(zend_lineno) = 1;
	}

	RESET_DOC_COMMENT();
	CG(increment_lineno) = 0;
	return SUCCESS;
}
END_EXTERN_C()

static zend_op_array *zend_compile(int type)
{
	zend_op_array *op_array = NULL;
	zend_bool original_in_compilation = CG(in_compilation);

	CG(in_compilation) = 1;
	CG(ast) = NULL;
	CG(ast_arena) = zend_arena_create(1024 * 32);

	if (!zendparse()) {
		int last_lineno = CG(zend_lineno);
		zend_file_context original_file_context;
		zend_oparray_context original_oparray_context;
		zend_op_array *original_active_op_array = CG(active_op_array);

		op_array = emalloc(sizeof(zend_op_array));
		init_op_array(op_array, type, INITIAL_OP_ARRAY_SIZE);
		CG(active_op_array) = op_array;

		if (zend_ast_process) {
			zend_ast_process(CG(ast));
		}

		zend_file_context_begin(&original_file_context);
		zend_oparray_context_begin(&original_oparray_context);
		zend_compile_top_stmt(CG(ast));
		CG(zend_lineno) = last_lineno;
		zend_emit_final_return(type == ZEND_USER_FUNCTION);
		op_array->line_start = 1;
		op_array->line_end = last_lineno;
		pass_two(op_array);
		zend_oparray_context_end(&original_oparray_context);
		zend_file_context_end(&original_file_context);

		CG(active_op_array) = original_active_op_array;
	}

	zend_ast_destroy(CG(ast));
	zend_arena_destroy(CG(ast_arena));

	CG(in_compilation) = original_in_compilation;

	return op_array;
}

ZEND_API zend_op_array *compile_file(zend_file_handle *file_handle, int type)
{
	zend_lex_state original_lex_state;
	zend_op_array *op_array = NULL;
	zend_save_lexical_state(&original_lex_state);

	if (open_file_for_scanning(file_handle)==FAILURE) {
		if (type==ZEND_REQUIRE) {
			zend_message_dispatcher(ZMSG_FAILED_REQUIRE_FOPEN, file_handle->filename);
			zend_bailout();
		} else {
			zend_message_dispatcher(ZMSG_FAILED_INCLUDE_FOPEN, file_handle->filename);
		}
	} else {
		op_array = zend_compile(ZEND_USER_FUNCTION);
	}

	zend_restore_lexical_state(&original_lex_state);
	return op_array;
}


zend_op_array *compile_filename(int type, zval *filename)
{
	zend_file_handle file_handle;
	zval tmp;
	zend_op_array *retval;
	zend_string *opened_path = NULL;

	if (Z_TYPE_P(filename) != IS_STRING) {
		ZVAL_STR(&tmp, zval_get_string(filename));
		filename = &tmp;
	}
	file_handle.filename = Z_STRVAL_P(filename);
	file_handle.free_filename = 0;
	file_handle.type = ZEND_HANDLE_FILENAME;
	file_handle.opened_path = NULL;
	file_handle.handle.fp = NULL;

	retval = zend_compile_file(&file_handle, type);
	if (retval && file_handle.handle.stream.handle) {
		if (!file_handle.opened_path) {
			file_handle.opened_path = opened_path = zend_string_copy(Z_STR_P(filename));
		}

		zend_hash_add_empty_element(&EG(included_files), file_handle.opened_path);

		if (opened_path) {
			zend_string_release_ex(opened_path, 0);
		}
	}
	zend_destroy_file_handle(&file_handle);

	if (UNEXPECTED(filename == &tmp)) {
		zval_ptr_dtor(&tmp);
	}
	return retval;
}

ZEND_API int zend_prepare_string_for_scanning(zval *str, char *filename)
{
	char *buf;
	size_t size, old_len;
	zend_string *new_compiled_filename;

	/* enforce ZEND_MMAP_AHEAD trailing NULLs for flex... */
	old_len = Z_STRLEN_P(str);
	Z_STR_P(str) = zend_string_extend(Z_STR_P(str), old_len + ZEND_MMAP_AHEAD, 0);
	Z_TYPE_INFO_P(str) = IS_STRING_EX;
	memset(Z_STRVAL_P(str) + old_len, 0, ZEND_MMAP_AHEAD + 1);

	SCNG(yy_in) = NULL;
	SCNG(yy_start) = NULL;

	buf = Z_STRVAL_P(str);
	size = old_len;

	if (CG(multibyte)) {
		SCNG(script_org) = (unsigned char*)buf;
		SCNG(script_org_size) = size;
		SCNG(script_filtered) = NULL;

		zend_multibyte_set_filter(zend_multibyte_get_internal_encoding());

		if (SCNG(input_filter)) {
			if ((size_t)-1 == SCNG(input_filter)(&SCNG(script_filtered), &SCNG(script_filtered_size), SCNG(script_org), SCNG(script_org_size))) {
				zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
						"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
			}
			buf = (char*)SCNG(script_filtered);
			size = SCNG(script_filtered_size);
		}
	}

	yy_scan_buffer(buf, (unsigned int)size);

	new_compiled_filename = zend_string_init(filename, strlen(filename), 0);
	zend_set_compiled_filename(new_compiled_filename);
	zend_string_release_ex(new_compiled_filename, 0);
	CG(zend_lineno) = 1;
	CG(increment_lineno) = 0;
	RESET_DOC_COMMENT();
	return SUCCESS;
}


ZEND_API size_t zend_get_scanned_file_offset(void)
{
	size_t offset = SCNG(yy_cursor) - SCNG(yy_start);
	if (SCNG(input_filter)) {
		size_t original_offset = offset, length = 0;
		do {
			unsigned char *p = NULL;
			if ((size_t)-1 == SCNG(input_filter)(&p, &length, SCNG(script_org), offset)) {
				return (size_t)-1;
			}
			efree(p);
			if (length > original_offset) {
				offset--;
			} else if (length < original_offset) {
				offset++;
			}
		} while (original_offset != length);
	}
	return offset;
}

zend_op_array *compile_string(zval *source_string, char *filename)
{
	zend_lex_state original_lex_state;
	zend_op_array *op_array = NULL;
	zval tmp;

	if (UNEXPECTED(Z_TYPE_P(source_string) != IS_STRING)) {
		ZVAL_STR(&tmp, zval_get_string_func(source_string));
	} else {
		ZVAL_COPY(&tmp, source_string);
	}

	if (Z_STRLEN(tmp)==0) {
		zval_ptr_dtor(&tmp);
		return NULL;
	}

	zend_save_lexical_state(&original_lex_state);
	if (zend_prepare_string_for_scanning(&tmp, filename) == SUCCESS) {
		BEGIN(ST_IN_SCRIPTING);
		op_array = zend_compile(ZEND_EVAL_CODE);
	}

	zend_restore_lexical_state(&original_lex_state);
	zval_ptr_dtor(&tmp);

	return op_array;
}


BEGIN_EXTERN_C()
int highlight_file(char *filename, zend_syntax_highlighter_ini *syntax_highlighter_ini)
{
	zend_lex_state original_lex_state;
	zend_file_handle file_handle;

	file_handle.type = ZEND_HANDLE_FILENAME;
	file_handle.filename = filename;
	file_handle.free_filename = 0;
	file_handle.opened_path = NULL;
	zend_save_lexical_state(&original_lex_state);
	if (open_file_for_scanning(&file_handle)==FAILURE) {
		zend_message_dispatcher(ZMSG_FAILED_HIGHLIGHT_FOPEN, filename);
		zend_restore_lexical_state(&original_lex_state);
		return FAILURE;
	}
	zend_highlight(syntax_highlighter_ini);
	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	zend_destroy_file_handle(&file_handle);
	zend_restore_lexical_state(&original_lex_state);
	return SUCCESS;
}

int highlight_string(zval *str, zend_syntax_highlighter_ini *syntax_highlighter_ini, char *str_name)
{
	zend_lex_state original_lex_state;
	zval tmp;

	if (UNEXPECTED(Z_TYPE_P(str) != IS_STRING)) {
		ZVAL_STR(&tmp, zval_get_string_func(str));
		str = &tmp;
	}
	zend_save_lexical_state(&original_lex_state);
	if (zend_prepare_string_for_scanning(str, str_name)==FAILURE) {
		zend_restore_lexical_state(&original_lex_state);
		if (UNEXPECTED(str == &tmp)) {
			zval_ptr_dtor(&tmp);
		}
		return FAILURE;
	}
	BEGIN(INITIAL);
	zend_highlight(syntax_highlighter_ini);
	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	zend_restore_lexical_state(&original_lex_state);
	if (UNEXPECTED(str == &tmp)) {
		zval_ptr_dtor(&tmp);
	}
	return SUCCESS;
}

ZEND_API void zend_multibyte_yyinput_again(zend_encoding_filter old_input_filter, const zend_encoding *old_encoding)
{
	size_t length;
	unsigned char *new_yy_start;

	/* convert and set */
	if (!SCNG(input_filter)) {
		if (SCNG(script_filtered)) {
			efree(SCNG(script_filtered));
			SCNG(script_filtered) = NULL;
		}
		SCNG(script_filtered_size) = 0;
		length = SCNG(script_org_size);
		new_yy_start = SCNG(script_org);
	} else {
		if ((size_t)-1 == SCNG(input_filter)(&new_yy_start, &length, SCNG(script_org), SCNG(script_org_size))) {
			zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
					"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
		}
		if (SCNG(script_filtered)) {
			efree(SCNG(script_filtered));
		}
		SCNG(script_filtered) = new_yy_start;
		SCNG(script_filtered_size) = length;
	}

	SCNG(yy_cursor) = new_yy_start + (SCNG(yy_cursor) - SCNG(yy_start));
	SCNG(yy_marker) = new_yy_start + (SCNG(yy_marker) - SCNG(yy_start));
	SCNG(yy_text) = new_yy_start + (SCNG(yy_text) - SCNG(yy_start));
	SCNG(yy_limit) = new_yy_start + length;

	SCNG(yy_start) = new_yy_start;
}


// TODO: avoid reallocation ???
# define zend_copy_value(zendlval, yytext, yyleng) \
	if (SCNG(output_filter)) { \
		size_t sz = 0; \
		char *s = NULL; \
		SCNG(output_filter)((unsigned char **)&s, &sz, (unsigned char *)yytext, (size_t)yyleng); \
		ZVAL_STRINGL(zendlval, s, sz); \
		efree(s); \
	} else if (yyleng == 1) { \
		ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR((zend_uchar)*(yytext))); \
	} else { \
		ZVAL_STRINGL(zendlval, yytext, yyleng); \
	}

static int zend_scan_escape_string(zval *zendlval, char *str, int len, char quote_type)
{
	register char *s, *t;
	char *end;

	if (len <= 1) {
		if (len < 1) {
			ZVAL_EMPTY_STRING(zendlval);
		} else {
			zend_uchar c = (zend_uchar)*str;
			if (c == '\n' || c == '\r') {
				CG(zend_lineno)++;
			}
			ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR(c));
		}
		goto skip_escape_conversion;
	}

	ZVAL_STRINGL(zendlval, str, len);

	/* convert escape sequences */
	s = Z_STRVAL_P(zendlval);
	end = s+Z_STRLEN_P(zendlval);
	while (1) {
		if (UNEXPECTED(*s=='\\')) {
			break;
		}
		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
		if (s == end) {
			goto skip_escape_conversion;
		}
	}

	t = s;
	while (s<end) {
		if (*s=='\\') {
			s++;
			if (s >= end) {
				*t++ = '\\';
				break;
			}

			switch(*s) {
				case 'n':
					*t++ = '\n';
					break;
				case 'r':
					*t++ = '\r';
					break;
				case 't':
					*t++ = '\t';
					break;
				case 'f':
					*t++ = '\f';
					break;
				case 'v':
					*t++ = '\v';
					break;
				case 'e':
#ifdef ZEND_WIN32
					*t++ = VK_ESCAPE;
#else
					*t++ = '\e';
#endif
					break;
				case '"':
				case '`':
					if (*s != quote_type) {
						*t++ = '\\';
						*t++ = *s;
						break;
					}
				case '\\':
				case '$':
					*t++ = *s;
					break;
				case 'x':
				case 'X':
					if (ZEND_IS_HEX(*(s+1))) {
						char hex_buf[3] = { 0, 0, 0 };

						hex_buf[0] = *(++s);
						if (ZEND_IS_HEX(*(s+1))) {
							hex_buf[1] = *(++s);
						}
						*t++ = (char) ZEND_STRTOL(hex_buf, NULL, 16);
					} else {
						*t++ = '\\';
						*t++ = *s;
					}
					break;
				/* UTF-8 codepoint escape, format: /\\u\{\x+\}/ */
				case 'u':
					{
						/* cache where we started so we can parse after validating */
						char *start = s + 1;
						size_t len = 0;
						zend_bool valid = 1;
						unsigned long codepoint;

						if (*start != '{') {
							/* we silently let this pass to avoid breaking code
							 * with JSON in string literals (e.g. "\"\u202e\""
							 */
							*t++ = '\\';
							*t++ = 'u';
							break;
						} else {
							/* on the other hand, invalid \u{blah} errors */
							s++;
							len++;
							s++;
							while (*s != '}') {
								if (!ZEND_IS_HEX(*s)) {
									valid = 0;
									break;
								} else {
									len++;
								}
								s++;
							}
							if (*s == '}') {
								valid = 1;
								len++;
							}
						}

						/* \u{} is invalid */
						if (len <= 2) {
							valid = 0;
						}

						if (!valid) {
							zend_throw_exception(zend_ce_parse_error,
								"Invalid UTF-8 codepoint escape sequence", 0);
							zval_ptr_dtor(zendlval);
							ZVAL_UNDEF(zendlval);
							return FAILURE;
						}

						errno = 0;
						codepoint = strtoul(start + 1, NULL, 16);

						/* per RFC 3629, UTF-8 can only represent 21 bits */
						if (codepoint > 0x10FFFF || errno) {
							zend_throw_exception(zend_ce_parse_error,
								"Invalid UTF-8 codepoint escape sequence: Codepoint too large", 0);
							zval_ptr_dtor(zendlval);
							ZVAL_UNDEF(zendlval);
							return FAILURE;
						}

						/* based on https://en.wikipedia.org/wiki/UTF-8#Sample_code */
						if (codepoint < 0x80) {
							*t++ = codepoint;
						} else if (codepoint <= 0x7FF) {
							*t++ = (codepoint >> 6) + 0xC0;
							*t++ = (codepoint & 0x3F) + 0x80;
						} else if (codepoint <= 0xFFFF) {
							*t++ = (codepoint >> 12) + 0xE0;
							*t++ = ((codepoint >> 6) & 0x3F) + 0x80;
							*t++ = (codepoint & 0x3F) + 0x80;
						} else if (codepoint <= 0x10FFFF) {
							*t++ = (codepoint >> 18) + 0xF0;
							*t++ = ((codepoint >> 12) & 0x3F) + 0x80;
							*t++ = ((codepoint >> 6) & 0x3F) + 0x80;
							*t++ = (codepoint & 0x3F) + 0x80;
						}
					}
					break;
				default:
					/* check for an octal */
					if (ZEND_IS_OCT(*s)) {
						char octal_buf[4] = { 0, 0, 0, 0 };

						octal_buf[0] = *s;
						if (ZEND_IS_OCT(*(s+1))) {
							octal_buf[1] = *(++s);
							if (ZEND_IS_OCT(*(s+1))) {
								octal_buf[2] = *(++s);
							}
						}
						if (octal_buf[2] &&
						    (octal_buf[0] > '3')) {
							/* 3 octit values must not overflow 0xFF (\377) */
							zend_error(E_COMPILE_WARNING, "Octal escape sequence overflow \\%s is greater than \\377", octal_buf);
						}

						*t++ = (char) ZEND_STRTOL(octal_buf, NULL, 8);
					} else {
						*t++ = '\\';
						*t++ = *s;
					}
					break;
			}
		} else {
			*t++ = *s;
		}

		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
	}
	*t = 0;
	Z_STRLEN_P(zendlval) = t - Z_STRVAL_P(zendlval);

skip_escape_conversion:
	if (SCNG(output_filter)) {
		size_t sz = 0;
		unsigned char *str;
		// TODO: avoid realocation ???
		s = Z_STRVAL_P(zendlval);
		SCNG(output_filter)(&str, &sz, (unsigned char *)s, (size_t)Z_STRLEN_P(zendlval));
		zval_ptr_dtor(zendlval);
		ZVAL_STRINGL(zendlval, (char *) str, sz);
		efree(str);
	}
	return SUCCESS;
}

#define HEREDOC_USING_SPACES 1
#define HEREDOC_USING_TABS 2

static const char *next_newline(const char *str, const char *end, size_t *newline_len) {
	for (; str < end; str++) {
		if (*str == '\r') {
			*newline_len = str + 1 < end && *(str + 1) == '\n' ? 2 : 1;
		} else if (*str == '\n') {
			*newline_len = 1;
			return str;
		}
	}
	*newline_len = 0;
	return NULL;
}

static zend_bool strip_multiline_string_indentation(
	zval *zendlval, int indentation, zend_bool using_spaces,
	zend_bool newline_at_start, zend_bool newline_at_end)
{
	const char *str = Z_STRVAL_P(zendlval), *end = str + Z_STRLEN_P(zendlval);
	char *copy = Z_STRVAL_P(zendlval);

	int newline_count = 0;
	size_t newline_len;
	const char *nl;

	if (!newline_at_start) {
		nl = next_newline(str, end, &newline_len);
		if (!nl) {
			return 1;
		}

		str = nl + newline_len;
		copy = (char *) nl + newline_len;
		newline_count++;
	} else {
		nl = str;
	}

	/* <= intentional */
	while (str <= end && nl) {
		size_t skip;
		nl = next_newline(str, end, &newline_len);
		if (!nl && newline_at_end) {
			nl = end;
		}

		/* Try to skip indentation */
		for (skip = 0; skip < indentation; skip++, str++) {
			if (str == nl) {
				/* Don't require full indentation on whitespace-only lines */
				break;
			}

			if (str == end || (*str != ' ' && *str != '\t')) {
				CG(zend_lineno) += newline_count;
				zend_throw_exception_ex(zend_ce_parse_error, 0,
					"Invalid body indentation level (expecting an indentation level of at least %d)", indentation);
				goto error;
			}

			if ((!using_spaces && *str == ' ') || (using_spaces && *str == '\t')) {
				CG(zend_lineno) += newline_count;
				zend_throw_exception(zend_ce_parse_error,
					"Invalid indentation - tabs and spaces cannot be mixed", 0);
				goto error;
			}
		}

		if (str == end) {
			break;
		}

		size_t len = nl ? (nl - str + newline_len) : (end - str);
		memmove(copy, str, len);
		str += len;
		copy += len;
		newline_count++;
	}

	*copy = '\0';
	Z_STRLEN_P(zendlval) = copy - Z_STRVAL_P(zendlval);
	return 1;

error:
	zval_ptr_dtor_str(zendlval);
	ZVAL_UNDEF(zendlval);

	return 0;
}

static void copy_heredoc_label_stack(void *void_heredoc_label)
{
	zend_heredoc_label *heredoc_label = void_heredoc_label;
	zend_heredoc_label *new_heredoc_label = emalloc(sizeof(zend_heredoc_label));

	*new_heredoc_label = *heredoc_label;
	new_heredoc_label->label = estrndup(heredoc_label->label, heredoc_label->length);

	zend_ptr_stack_push(&SCNG(heredoc_label_stack), (void *) new_heredoc_label);
}

#define PARSER_MODE() \
	EXPECTED(elem != NULL)

#define RETURN_TOKEN(_token) do { \
		token = _token; \
		goto emit_token; \
	} while (0)

#define RETURN_TOKEN_WITH_VAL(_token) do { \
		token = _token; \
		goto emit_token_with_val; \
	} while (0)

#define RETURN_TOKEN_WITH_STR(_token, _offset) do { \
		token = _token; \
		offset = _offset; \
		goto emit_token_with_str; \
	} while (0)

#define SKIP_TOKEN(_token) do { \
		token = _token; \
		goto skip_token; \
	} while (0)

int ZEND_FASTCALL lex_scan(zval *zendlval, zend_parser_stack_elem *elem)
{
int token;
int offset;
int start_line = CG(zend_lineno);

	ZVAL_UNDEF(zendlval);
restart:
	SCNG(yy_text) = YYCURSOR;


#line 1249 "Zend/zend_language_scanner.c"
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	if (YYGETCONDITION() < 5) {
		if (YYGETCONDITION() < 2) {
			if (YYGETCONDITION() < 1) {
				goto yyc_ST_IN_SCRIPTING;
			} else {
				goto yyc_ST_LOOKING_FOR_PROPERTY;
			}
		} else {
			if (YYGETCONDITION() < 3) {
				goto yyc_ST_BACKQUOTE;
			} else {
				if (YYGETCONDITION() < 4) {
					goto yyc_ST_DOUBLE_QUOTES;
				} else {
					goto yyc_ST_HEREDOC;
				}
			}
		}
	} else {
		if (YYGETCONDITION() < 7) {
			if (YYGETCONDITION() < 6) {
				goto yyc_ST_LOOKING_FOR_VARNAME;
			} else {
				goto yyc_ST_VAR_OFFSET;
			}
		} else {
			if (YYGETCONDITION() < 8) {
				goto yyc_INITIAL;
			} else {
				if (YYGETCONDITION() < 9) {
					goto yyc_ST_END_HEREDOC;
				} else {
					goto yyc_ST_NOWDOC;
				}
			}
		}
	}
/* *********************************** */
yyc_ST_IN_SCRIPTING:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,  36,   4,   0,   0,   4,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 36,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			216, 216, 152, 152, 152, 152, 152, 152, 
			152, 152,   0,   0,   0,   0,   0,   0, 
			  0, 144, 144, 144, 144, 144, 144,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,   0,   0,   0,   0,  16, 
			  0, 144, 144, 144, 144, 144, 144,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,   0,   0,   0,   0,   0, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
		};
		YYDEBUG(1, *YYCURSOR);
		YYFILL(16);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 4) {
			goto yy5;
		}
		switch (yych) {
		case 0x00:
		case 0x01:
		case 0x02:
		case 0x03:
		case 0x04:
		case 0x05:
		case 0x06:
		case 0x07:
		case 0x08:
		case '\t':
		case '\n':
		case '\v':
		case '\f':
		case '\r':
		case 0x0E:
		case 0x0F:
		case 0x10:
		case 0x11:
		case 0x12:
		case 0x13:
		case 0x14:
		case 0x15:
		case 0x16:
		case 0x17:
		case 0x18:
		case 0x19:
		case 0x1A:
		case 0x1B:
		case 0x1C:
		case 0x1D:
		case 0x1E:
		case 0x1F:
		case 0x7F:	goto yy3;
		case ' ':
		case '!':	goto yy8;
		case '"':	goto yy10;
		case '#':	goto yy12;
		case '$':	goto yy14;
		case '%':	goto yy15;
		case '&':	goto yy16;
		case '\'':	goto yy17;
		case '(':	goto yy19;
		case ')':
		case ',':
		case ';':
		case '@':
		case '[':
		case ']':
		case '~':	goto yy20;
		case '*':	goto yy21;
		case '+':	goto yy22;
		case '-':	goto yy23;
		case '.':	goto yy24;
		case '/':	goto yy25;
		case '0':	goto yy26;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':	goto yy28;
		case ':':	goto yy30;
		case '<':	goto yy31;
		case '=':	goto yy32;
		case '>':	goto yy33;
		case '?':	goto yy34;
		case 'A':
		case 'a':	goto yy35;
		case 'B':
		case 'b':	goto yy37;
		case 'C':
		case 'c':	goto yy38;
		case 'D':
		case 'd':	goto yy39;
		case 'E':
		case 'e':	goto yy40;
		case 'F':
		case 'f':	goto yy41;
		case 'G':
		case 'g':	goto yy42;
		case 'I':
		case 'i':	goto yy45;
		case 'L':
		case 'l':	goto yy46;
		case 'N':
		case 'n':	goto yy47;
		case 'O':
		case 'o':	goto yy48;
		case 'P':
		case 'p':	goto yy49;
		case 'R':
		case 'r':	goto yy50;
		case 'S':
		case 's':	goto yy51;
		case 'T':
		case 't':	goto yy52;
		case 'U':
		case 'u':	goto yy53;
		case 'V':
		case 'v':	goto yy54;
		case 'W':
		case 'w':	goto yy55;
		case 'X':
		case 'x':	goto yy56;
		case 'Y':
		case 'y':	goto yy57;
		case '\\':	goto yy58;
		case '^':	goto yy60;
		case '_':	goto yy61;
		case '`':	goto yy62;
		case '{':	goto yy64;
		case '|':	goto yy66;
		case '}':	goto yy67;
		default:	goto yy43;
		}
yy3:
		YYDEBUG(3, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(4, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2749 "Zend/zend_language_scanner.l"
		{
	if (YYCURSOR > YYLIMIT) {
		RETURN_TOKEN(END);
	}

	zend_error(E_COMPILE_WARNING,"Unexpected character in input:  '%c' (ASCII=%d) state=%d", yytext[0], yytext[0], YYSTATE);
	goto restart;
}
#line 1466 "Zend/zend_language_scanner.c"
yy5:
		YYDEBUG(5, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(6, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy5;
		}
		YYDEBUG(7, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1428 "Zend/zend_language_scanner.l"
		{
	goto return_whitespace;
}
#line 1482 "Zend/zend_language_scanner.c"
yy8:
		YYDEBUG(8, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy69;
yy9:
		YYDEBUG(9, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1711 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(yytext[0]);
}
#line 1494 "Zend/zend_language_scanner.c"
yy10:
		YYDEBUG(10, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(11, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2223 "Zend/zend_language_scanner.l"
		{
	int bprefix = (yytext[0] != '"') ? 1 : 0;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				yyleng = YYCURSOR - SCNG(yy_text);
				if (EXPECTED(zend_scan_escape_string(zendlval, yytext+bprefix+1, yyleng-bprefix-2, '"') == SUCCESS)
				 || !PARSER_MODE()) {
					RETURN_TOKEN_WITH_VAL(T_CONSTANT_ENCAPSED_STRING);
				} else {
					RETURN_TOKEN(T_ERROR);
				}
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	/* Remember how much was scanned to save rescanning */
	SET_DOUBLE_QUOTES_SCANNED_LENGTH(YYCURSOR - SCNG(yy_text) - yyleng);

	YYCURSOR = SCNG(yy_text) + yyleng;

	BEGIN(ST_DOUBLE_QUOTES);
	RETURN_TOKEN('"');
}
#line 1545 "Zend/zend_language_scanner.c"
yy12:
		YYDEBUG(12, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(13, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2050 "Zend/zend_language_scanner.l"
		{
	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				CG(zend_lineno)++;
				break;
			case '?':
				if (*YYCURSOR == '>') {
					YYCURSOR--;
					break;
				}
				/* fall through */
			default:
				continue;
		}

		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	if (PARSER_MODE()) {
		SKIP_TOKEN(T_COMMENT);
	}
	RETURN_TOKEN(T_COMMENT);
}
#line 1583 "Zend/zend_language_scanner.c"
yy14:
		YYDEBUG(14, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy9;
			if (yych <= 'Z') goto yy71;
			if (yych <= '^') goto yy9;
			goto yy71;
		} else {
			if (yych <= '`') goto yy9;
			if (yych <= 'z') goto yy71;
			if (yych <= 0x7F) goto yy9;
			goto yy71;
		}
yy15:
		YYDEBUG(15, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy74;
		goto yy9;
yy16:
		YYDEBUG(16, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '&') goto yy76;
		if (yych == '=') goto yy78;
		goto yy9;
yy17:
		YYDEBUG(17, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(18, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2133 "Zend/zend_language_scanner.l"
		{
	register char *s, *t;
	char *end;
	int bprefix = (yytext[0] != '\'') ? 1 : 0;

	while (1) {
		if (YYCURSOR < YYLIMIT) {
			if (*YYCURSOR == '\'') {
				YYCURSOR++;
				yyleng = YYCURSOR - SCNG(yy_text);

				break;
			} else if (*YYCURSOR++ == '\\' && YYCURSOR < YYLIMIT) {
				YYCURSOR++;
			}
		} else {
			yyleng = YYLIMIT - SCNG(yy_text);

			/* Unclosed single quotes; treat similar to double quotes, but without a separate token
			 * for ' (unrecognized by parser), instead of old flex fallback to "Unexpected character..."
			 * rule, which continued in ST_IN_SCRIPTING state after the quote */
			ZVAL_NULL(zendlval);
			RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
		}
	}

	if (yyleng-bprefix-2 <= 1) {
		if (yyleng-bprefix-2 < 1) {
			ZVAL_EMPTY_STRING(zendlval);
		} else {
			zend_uchar c = (zend_uchar)*(yytext+bprefix+1);
			if (c == '\n' || c == '\r') {
				CG(zend_lineno)++;
			}
			ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR(c));
		}
		goto skip_escape_conversion;
	}
	ZVAL_STRINGL(zendlval, yytext+bprefix+1, yyleng-bprefix-2);

	/* convert escape sequences */
	s = Z_STRVAL_P(zendlval);
	end = s+Z_STRLEN_P(zendlval);
	while (1) {
		if (UNEXPECTED(*s=='\\')) {
			break;
		}
		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
		if (s == end) {
			goto skip_escape_conversion;
		}
	}

	t = s;
	while (s<end) {
		if (*s=='\\') {
			s++;
			if (*s == '\\' || *s == '\'') {
				*t++ = *s;
			} else {
				*t++ = '\\';
				*t++ = *s;
			}
		} else {
			*t++ = *s;
		}
		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
	}
	*t = 0;
	Z_STRLEN_P(zendlval) = t - Z_STRVAL_P(zendlval);

skip_escape_conversion:
	if (SCNG(output_filter)) {
		size_t sz = 0;
		char *str = NULL;
		s = Z_STRVAL_P(zendlval);
		// TODO: avoid reallocation ???
		SCNG(output_filter)((unsigned char **)&str, &sz, (unsigned char *)s, (size_t)Z_STRLEN_P(zendlval));
		ZVAL_STRINGL(zendlval, str, sz);
	}
	RETURN_TOKEN_WITH_VAL(T_CONSTANT_ENCAPSED_STRING);
}
#line 1703 "Zend/zend_language_scanner.c"
yy19:
		YYDEBUG(19, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'S') {
			if (yych <= 'D') {
				if (yych <= ' ') {
					if (yych == '\t') goto yy81;
					if (yych <= 0x1F) goto yy9;
					goto yy81;
				} else {
					if (yych <= '@') goto yy9;
					if (yych == 'C') goto yy9;
					goto yy81;
				}
			} else {
				if (yych <= 'I') {
					if (yych == 'F') goto yy81;
					if (yych <= 'H') goto yy9;
					goto yy81;
				} else {
					if (yych == 'O') goto yy81;
					if (yych <= 'Q') goto yy9;
					goto yy81;
				}
			}
		} else {
			if (yych <= 'f') {
				if (yych <= 'b') {
					if (yych == 'U') goto yy81;
					if (yych <= '`') goto yy9;
					goto yy81;
				} else {
					if (yych == 'd') goto yy81;
					if (yych <= 'e') goto yy9;
					goto yy81;
				}
			} else {
				if (yych <= 'o') {
					if (yych == 'i') goto yy81;
					if (yych <= 'n') goto yy9;
					goto yy81;
				} else {
					if (yych <= 's') {
						if (yych <= 'q') goto yy9;
						goto yy81;
					} else {
						if (yych == 'u') goto yy81;
						goto yy9;
					}
				}
			}
		}
yy20:
		YYDEBUG(20, *YYCURSOR);
		++YYCURSOR;
		goto yy9;
yy21:
		YYDEBUG(21, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '*') goto yy92;
		if (yych == '=') goto yy94;
		goto yy9;
yy22:
		YYDEBUG(22, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '+') goto yy96;
		if (yych == '=') goto yy98;
		goto yy9;
yy23:
		YYDEBUG(23, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') {
			if (yych == '-') goto yy100;
			goto yy9;
		} else {
			if (yych <= '=') goto yy102;
			if (yych <= '>') goto yy104;
			goto yy9;
		}
yy24:
		YYDEBUG(24, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') {
			if (yych == '.') goto yy106;
			goto yy9;
		} else {
			if (yych <= '9') goto yy107;
			if (yych == '=') goto yy110;
			goto yy9;
		}
yy25:
		YYDEBUG(25, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '.') {
			if (yych == '*') goto yy112;
			goto yy9;
		} else {
			if (yych <= '/') goto yy12;
			if (yych == '=') goto yy114;
			goto yy9;
		}
yy26:
		YYDEBUG(26, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'X') {
			if (yych == 'B') goto yy116;
			if (yych <= 'W') goto yy29;
			goto yy118;
		} else {
			if (yych <= 'b') {
				if (yych <= 'a') goto yy29;
				goto yy116;
			} else {
				if (yych == 'x') goto yy118;
				goto yy29;
			}
		}
yy27:
		YYDEBUG(27, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1780 "Zend/zend_language_scanner.l"
		{
	char *end;
	if (yyleng < MAX_LENGTH_OF_LONG - 1) { /* Won't overflow */
		errno = 0;
		/* base must be passed explicitly for correct parse error on Windows */
		ZVAL_LONG(zendlval, ZEND_STRTOL(yytext, &end, yytext[0] == '0' ? 8 : 10));
		/* This isn't an assert, we need to ensure 019 isn't valid octal
		 * Because the lexing itself doesn't do that for us
		 */
		if (end != yytext + yyleng) {
			zend_throw_exception(zend_ce_parse_error, "Invalid numeric literal", 0);
			ZVAL_UNDEF(zendlval);
			if (PARSER_MODE()) {
				RETURN_TOKEN(T_ERROR);
			}
			RETURN_TOKEN_WITH_VAL(T_LNUMBER);
		}
	} else {
		errno = 0;
		ZVAL_LONG(zendlval, ZEND_STRTOL(yytext, &end, 0));
		if (errno == ERANGE) { /* Overflow */
			errno = 0;
			if (yytext[0] == '0') { /* octal overflow */
				ZVAL_DOUBLE(zendlval, zend_oct_strtod(yytext, (const char **)&end));
			} else {
				ZVAL_DOUBLE(zendlval, zend_strtod(yytext, (const char **)&end));
			}
			/* Also not an assert for the same reason */
			if (end != yytext + yyleng) {
				zend_throw_exception(zend_ce_parse_error,
					"Invalid numeric literal", 0);
				ZVAL_UNDEF(zendlval);
				if (PARSER_MODE()) {
					RETURN_TOKEN(T_ERROR);
				}
			}
			RETURN_TOKEN_WITH_VAL(T_DNUMBER);
		}
		/* Also not an assert for the same reason */
		if (end != yytext + yyleng) {
			zend_throw_exception(zend_ce_parse_error, "Invalid numeric literal", 0);
			ZVAL_UNDEF(zendlval);
			if (PARSER_MODE()) {
				RETURN_TOKEN(T_ERROR);
			}
			RETURN_TOKEN_WITH_VAL(T_DNUMBER);
		}
	}
	ZEND_ASSERT(!errno);
	RETURN_TOKEN_WITH_VAL(T_LNUMBER);
}
#line 1879 "Zend/zend_language_scanner.c"
yy28:
		YYDEBUG(28, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy29:
		YYDEBUG(29, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy28;
		}
		if (yych <= 'D') {
			if (yych == '.') goto yy107;
			goto yy27;
		} else {
			if (yych <= 'E') goto yy117;
			if (yych == 'e') goto yy117;
			goto yy27;
		}
yy30:
		YYDEBUG(30, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == ':') goto yy119;
		goto yy9;
yy31:
		YYDEBUG(31, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= ';') goto yy9;
		if (yych <= '<') goto yy121;
		if (yych <= '=') goto yy123;
		if (yych <= '>') goto yy125;
		goto yy9;
yy32:
		YYDEBUG(32, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy9;
		if (yych <= '=') goto yy126;
		if (yych <= '>') goto yy128;
		goto yy9;
yy33:
		YYDEBUG(33, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy9;
		if (yych <= '=') goto yy130;
		if (yych <= '>') goto yy132;
		goto yy9;
yy34:
		YYDEBUG(34, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '=') goto yy9;
		if (yych <= '>') goto yy134;
		if (yych <= '?') goto yy136;
		goto yy9;
yy35:
		YYDEBUG(35, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'S') {
			if (yych <= 'M') {
				if (yych == 'B') goto yy138;
				goto yy44;
			} else {
				if (yych <= 'N') goto yy139;
				if (yych <= 'Q') goto yy44;
				if (yych <= 'R') goto yy140;
				goto yy141;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'b') goto yy138;
				if (yych <= 'm') goto yy44;
				goto yy139;
			} else {
				if (yych <= 'q') goto yy44;
				if (yych <= 'r') goto yy140;
				if (yych <= 's') goto yy141;
				goto yy44;
			}
		}
yy36:
		YYDEBUG(36, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2045 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN_WITH_STR(T_STRING, 0);
}
#line 1965 "Zend/zend_language_scanner.c"
yy37:
		YYDEBUG(37, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ';') {
			if (yych <= '"') {
				if (yych <= '!') goto yy44;
				goto yy10;
			} else {
				if (yych == '\'') goto yy17;
				goto yy44;
			}
		} else {
			if (yych <= 'R') {
				if (yych <= '<') goto yy143;
				if (yych <= 'Q') goto yy44;
				goto yy144;
			} else {
				if (yych == 'r') goto yy144;
				goto yy44;
			}
		}
yy38:
		YYDEBUG(38, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych <= 'K') {
				if (yych == 'A') goto yy145;
				goto yy44;
			} else {
				if (yych <= 'L') goto yy146;
				if (yych <= 'N') goto yy44;
				goto yy147;
			}
		} else {
			if (yych <= 'k') {
				if (yych == 'a') goto yy145;
				goto yy44;
			} else {
				if (yych <= 'l') goto yy146;
				if (yych == 'o') goto yy147;
				goto yy44;
			}
		}
yy39:
		YYDEBUG(39, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych <= 'H') {
				if (yych == 'E') goto yy148;
				goto yy44;
			} else {
				if (yych <= 'I') goto yy149;
				if (yych <= 'N') goto yy44;
				goto yy150;
			}
		} else {
			if (yych <= 'h') {
				if (yych == 'e') goto yy148;
				goto yy44;
			} else {
				if (yych <= 'i') goto yy149;
				if (yych == 'o') goto yy150;
				goto yy44;
			}
		}
yy40:
		YYDEBUG(40, *YYCURSOR);
		yych = *++YYCURSOR;
		switch (yych) {
		case 'C':
		case 'c':	goto yy152;
		case 'L':
		case 'l':	goto yy153;
		case 'M':
		case 'm':	goto yy154;
		case 'N':
		case 'n':	goto yy155;
		case 'V':
		case 'v':	goto yy156;
		case 'X':
		case 'x':	goto yy157;
		default:	goto yy44;
		}
yy41:
		YYDEBUG(41, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'U') {
			if (yych <= 'N') {
				if (yych == 'I') goto yy158;
				goto yy44;
			} else {
				if (yych <= 'O') goto yy159;
				if (yych <= 'T') goto yy44;
				goto yy160;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'i') goto yy158;
				goto yy44;
			} else {
				if (yych <= 'o') goto yy159;
				if (yych == 'u') goto yy160;
				goto yy44;
			}
		}
yy42:
		YYDEBUG(42, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych == 'L') goto yy161;
			if (yych <= 'N') goto yy44;
			goto yy162;
		} else {
			if (yych <= 'l') {
				if (yych <= 'k') goto yy44;
				goto yy161;
			} else {
				if (yych == 'o') goto yy162;
				goto yy44;
			}
		}
yy43:
		YYDEBUG(43, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy44:
		YYDEBUG(44, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		goto yy36;
yy45:
		YYDEBUG(45, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'S') {
			if (yych <= 'L') {
				if (yych == 'F') goto yy163;
				goto yy44;
			} else {
				if (yych <= 'M') goto yy165;
				if (yych <= 'N') goto yy166;
				if (yych <= 'R') goto yy44;
				goto yy167;
			}
		} else {
			if (yych <= 'm') {
				if (yych == 'f') goto yy163;
				if (yych <= 'l') goto yy44;
				goto yy165;
			} else {
				if (yych <= 'n') goto yy166;
				if (yych == 's') goto yy167;
				goto yy44;
			}
		}
yy46:
		YYDEBUG(46, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy168;
		if (yych == 'i') goto yy168;
		goto yy44;
yy47:
		YYDEBUG(47, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'E') {
			if (yych == 'A') goto yy169;
			if (yych <= 'D') goto yy44;
			goto yy170;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy44;
				goto yy169;
			} else {
				if (yych == 'e') goto yy170;
				goto yy44;
			}
		}
yy48:
		YYDEBUG(48, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy171;
		if (yych == 'r') goto yy171;
		goto yy44;
yy49:
		YYDEBUG(49, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'U') {
			if (yych == 'R') goto yy173;
			if (yych <= 'T') goto yy44;
			goto yy174;
		} else {
			if (yych <= 'r') {
				if (yych <= 'q') goto yy44;
				goto yy173;
			} else {
				if (yych == 'u') goto yy174;
				goto yy44;
			}
		}
yy50:
		YYDEBUG(50, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy175;
		if (yych == 'e') goto yy175;
		goto yy44;
yy51:
		YYDEBUG(51, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'W') {
			if (yych == 'T') goto yy176;
			if (yych <= 'V') goto yy44;
			goto yy177;
		} else {
			if (yych <= 't') {
				if (yych <= 's') goto yy44;
				goto yy176;
			} else {
				if (yych == 'w') goto yy177;
				goto yy44;
			}
		}
yy52:
		YYDEBUG(52, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'R') {
			if (yych == 'H') goto yy178;
			if (yych <= 'Q') goto yy44;
			goto yy179;
		} else {
			if (yych <= 'h') {
				if (yych <= 'g') goto yy44;
				goto yy178;
			} else {
				if (yych == 'r') goto yy179;
				goto yy44;
			}
		}
yy53:
		YYDEBUG(53, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'S') {
			if (yych == 'N') goto yy180;
			if (yych <= 'R') goto yy44;
			goto yy181;
		} else {
			if (yych <= 'n') {
				if (yych <= 'm') goto yy44;
				goto yy180;
			} else {
				if (yych == 's') goto yy181;
				goto yy44;
			}
		}
yy54:
		YYDEBUG(54, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy182;
		if (yych == 'a') goto yy182;
		goto yy44;
yy55:
		YYDEBUG(55, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy183;
		if (yych == 'h') goto yy183;
		goto yy44;
yy56:
		YYDEBUG(56, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy184;
		if (yych == 'o') goto yy184;
		goto yy44;
yy57:
		YYDEBUG(57, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy185;
		if (yych == 'i') goto yy185;
		goto yy44;
yy58:
		YYDEBUG(58, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(59, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1451 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_NS_SEPARATOR);
}
#line 2254 "Zend/zend_language_scanner.c"
yy60:
		YYDEBUG(60, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy186;
		goto yy9;
yy61:
		YYDEBUG(61, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy188;
		goto yy44;
yy62:
		YYDEBUG(62, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(63, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2402 "Zend/zend_language_scanner.l"
		{
	BEGIN(ST_BACKQUOTE);
	RETURN_TOKEN('`');
}
#line 2275 "Zend/zend_language_scanner.c"
yy64:
		YYDEBUG(64, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(65, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1716 "Zend/zend_language_scanner.l"
		{
	yy_push_state(ST_IN_SCRIPTING);
	RETURN_TOKEN('{');
}
#line 2286 "Zend/zend_language_scanner.c"
yy66:
		YYDEBUG(66, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy189;
		if (yych == '|') goto yy191;
		goto yy9;
yy67:
		YYDEBUG(67, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(68, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1728 "Zend/zend_language_scanner.l"
		{
	RESET_DOC_COMMENT();
	if (!zend_stack_is_empty(&SCNG(state_stack))) {
		yy_pop_state();
	}
	RETURN_TOKEN('}');
}
#line 2306 "Zend/zend_language_scanner.c"
yy69:
		YYDEBUG(69, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy193;
yy70:
		YYDEBUG(70, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1615 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_IS_NOT_EQUAL);
}
#line 2318 "Zend/zend_language_scanner.c"
yy71:
		YYDEBUG(71, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(72, *YYCURSOR);
		if (yych <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy71;
			} else {
				if (yych <= '@') goto yy73;
				if (yych <= 'Z') goto yy71;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy71;
			} else {
				if (yych <= 'z') goto yy71;
				if (yych >= 0x80) goto yy71;
			}
		}
yy73:
		YYDEBUG(73, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2023 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
#line 2347 "Zend/zend_language_scanner.c"
yy74:
		YYDEBUG(74, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(75, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1659 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_MOD_EQUAL);
}
#line 2357 "Zend/zend_language_scanner.c"
yy76:
		YYDEBUG(76, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(77, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1687 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_BOOLEAN_AND);
}
#line 2367 "Zend/zend_language_scanner.c"
yy78:
		YYDEBUG(78, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(79, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1671 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_AND_EQUAL);
}
#line 2377 "Zend/zend_language_scanner.c"
yy80:
		YYDEBUG(80, *YYCURSOR);
		++YYCURSOR;
		YYFILL(7);
		yych = *YYCURSOR;
yy81:
		YYDEBUG(81, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy80;
		}
		switch (yych) {
		case 'A':
		case 'a':	goto yy83;
		case 'B':
		case 'b':	goto yy84;
		case 'D':
		case 'd':	goto yy85;
		case 'F':
		case 'f':	goto yy86;
		case 'I':
		case 'i':	goto yy87;
		case 'O':
		case 'o':	goto yy88;
		case 'R':
		case 'r':	goto yy89;
		case 'S':
		case 's':	goto yy90;
		case 'U':
		case 'u':	goto yy91;
		default:	goto yy82;
		}
yy82:
		YYDEBUG(82, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 3) {
			if (yyaccept <= 1) {
				if (yyaccept == 0) {
					goto yy9;
				} else {
					goto yy27;
				}
			} else {
				if (yyaccept == 2) {
					goto yy36;
				} else {
					goto yy109;
				}
			}
		} else {
			if (yyaccept <= 5) {
				if (yyaccept == 4) {
					goto yy113;
				} else {
					goto yy122;
				}
			} else {
				goto yy457;
			}
		}
yy83:
		YYDEBUG(83, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy195;
		if (yych == 'r') goto yy195;
		goto yy82;
yy84:
		YYDEBUG(84, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych == 'I') goto yy196;
			if (yych <= 'N') goto yy82;
			goto yy197;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy82;
				goto yy196;
			} else {
				if (yych == 'o') goto yy197;
				goto yy82;
			}
		}
yy85:
		YYDEBUG(85, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy198;
		if (yych == 'o') goto yy198;
		goto yy82;
yy86:
		YYDEBUG(86, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy199;
		if (yych == 'l') goto yy199;
		goto yy82;
yy87:
		YYDEBUG(87, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy200;
		if (yych == 'n') goto yy200;
		goto yy82;
yy88:
		YYDEBUG(88, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy201;
		if (yych == 'b') goto yy201;
		goto yy82;
yy89:
		YYDEBUG(89, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy202;
		if (yych == 'e') goto yy202;
		goto yy82;
yy90:
		YYDEBUG(90, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy203;
		if (yych == 't') goto yy203;
		goto yy82;
yy91:
		YYDEBUG(91, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy204;
		if (yych == 'n') goto yy204;
		goto yy82;
yy92:
		YYDEBUG(92, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy205;
		YYDEBUG(93, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1643 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_POW);
}
#line 2511 "Zend/zend_language_scanner.c"
yy94:
		YYDEBUG(94, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(95, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1639 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_MUL_EQUAL);
}
#line 2521 "Zend/zend_language_scanner.c"
yy96:
		YYDEBUG(96, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(97, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1595 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_INC);
}
#line 2531 "Zend/zend_language_scanner.c"
yy98:
		YYDEBUG(98, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(99, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1631 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_PLUS_EQUAL);
}
#line 2541 "Zend/zend_language_scanner.c"
yy100:
		YYDEBUG(100, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(101, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1599 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_DEC);
}
#line 2551 "Zend/zend_language_scanner.c"
yy102:
		YYDEBUG(102, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(103, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1635 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_MINUS_EQUAL);
}
#line 2561 "Zend/zend_language_scanner.c"
yy104:
		YYDEBUG(104, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(105, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1423 "Zend/zend_language_scanner.l"
		{
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN(T_OBJECT_OPERATOR);
}
#line 2572 "Zend/zend_language_scanner.c"
yy106:
		YYDEBUG(106, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '.') goto yy207;
		goto yy82;
yy107:
		YYDEBUG(107, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(108, *YYCURSOR);
		if (yych <= 'D') {
			if (yych <= '/') goto yy109;
			if (yych <= '9') goto yy107;
		} else {
			if (yych <= 'E') goto yy117;
			if (yych == 'e') goto yy117;
		}
yy109:
		YYDEBUG(109, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1885 "Zend/zend_language_scanner.l"
		{
	const char *end;

	ZVAL_DOUBLE(zendlval, zend_strtod(yytext, &end));
	/* errno isn't checked since we allow HUGE_VAL/INF overflow */
	ZEND_ASSERT(end == yytext + yyleng);
	RETURN_TOKEN_WITH_VAL(T_DNUMBER);
}
#line 2604 "Zend/zend_language_scanner.c"
yy110:
		YYDEBUG(110, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(111, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1655 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_CONCAT_EQUAL);
}
#line 2614 "Zend/zend_language_scanner.c"
yy112:
		YYDEBUG(112, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '*') goto yy209;
yy113:
		YYDEBUG(113, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2082 "Zend/zend_language_scanner.l"
		{
	int doc_com;

	if (yyleng > 2) {
		doc_com = 1;
		RESET_DOC_COMMENT();
	} else {
		doc_com = 0;
	}

	while (YYCURSOR < YYLIMIT) {
		if (*YYCURSOR++ == '*' && *YYCURSOR == '/') {
			break;
		}
	}

	if (YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	} else {
		zend_error(E_COMPILE_WARNING, "Unterminated comment starting line %d", CG(zend_lineno));
	}

	yyleng = YYCURSOR - SCNG(yy_text);
	HANDLE_NEWLINES(yytext, yyleng);

	if (doc_com) {
		CG(doc_comment) = zend_string_init(yytext, yyleng, 0);
		if (PARSER_MODE()) {
			SKIP_TOKEN(T_DOC_COMMENT);
		}
		RETURN_TOKEN(T_DOC_COMMENT);
	}

	if (PARSER_MODE()) {
		SKIP_TOKEN(T_COMMENT);
	}
	RETURN_TOKEN(T_COMMENT);
}
#line 2662 "Zend/zend_language_scanner.c"
yy114:
		YYDEBUG(114, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(115, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1651 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_DIV_EQUAL);
}
#line 2672 "Zend/zend_language_scanner.c"
yy116:
		YYDEBUG(116, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy210;
		}
		goto yy82;
yy117:
		YYDEBUG(117, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= ',') {
			if (yych == '+') goto yy213;
			goto yy82;
		} else {
			if (yych <= '-') goto yy213;
			if (yych <= '/') goto yy82;
			if (yych <= '9') goto yy214;
			goto yy82;
		}
yy118:
		YYDEBUG(118, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy216;
		}
		goto yy82;
yy119:
		YYDEBUG(119, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(120, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1447 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_PAAMAYIM_NEKUDOTAYIM);
}
#line 2708 "Zend/zend_language_scanner.c"
yy121:
		YYDEBUG(121, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ';') goto yy122;
		if (yych <= '<') goto yy219;
		if (yych <= '=') goto yy221;
yy122:
		YYDEBUG(122, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1703 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_SL);
}
#line 2723 "Zend/zend_language_scanner.c"
yy123:
		YYDEBUG(123, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy223;
		YYDEBUG(124, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1623 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_IS_SMALLER_OR_EQUAL);
}
#line 2734 "Zend/zend_language_scanner.c"
yy125:
		YYDEBUG(125, *YYCURSOR);
		++YYCURSOR;
		goto yy70;
yy126:
		YYDEBUG(126, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy225;
		YYDEBUG(127, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1611 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_IS_EQUAL);
}
#line 2749 "Zend/zend_language_scanner.c"
yy128:
		YYDEBUG(128, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(129, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1579 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_DOUBLE_ARROW);
}
#line 2759 "Zend/zend_language_scanner.c"
yy130:
		YYDEBUG(130, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(131, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1627 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_IS_GREATER_OR_EQUAL);
}
#line 2769 "Zend/zend_language_scanner.c"
yy132:
		YYDEBUG(132, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy227;
		YYDEBUG(133, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1707 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_SR);
}
#line 2780 "Zend/zend_language_scanner.c"
yy134:
		YYDEBUG(134, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy229;
		if (yych == '\r') goto yy230;
yy135:
		YYDEBUG(135, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2121 "Zend/zend_language_scanner.l"
		{
	BEGIN(INITIAL);
	if (yytext[yyleng-1] != '>') {
		CG(increment_lineno) = 1;
	}
	if (PARSER_MODE()) {
		RETURN_TOKEN(';');  /* implicit ';' at php-end tag */
	}
	RETURN_TOKEN(T_CLOSE_TAG);
}
#line 2800 "Zend/zend_language_scanner.c"
yy136:
		YYDEBUG(136, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(137, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1459 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_COALESCE);
}
#line 2810 "Zend/zend_language_scanner.c"
yy138:
		YYDEBUG(138, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy231;
		if (yych == 's') goto yy231;
		goto yy44;
yy139:
		YYDEBUG(139, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy232;
		if (yych == 'd') goto yy232;
		goto yy44;
yy140:
		YYDEBUG(140, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy234;
		if (yych == 'r') goto yy234;
		goto yy44;
yy141:
		YYDEBUG(141, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(142, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1363 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_AS);
}
#line 2841 "Zend/zend_language_scanner.c"
yy143:
		YYDEBUG(143, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '<') goto yy235;
		goto yy82;
yy144:
		YYDEBUG(144, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy236;
		if (yych == 'e') goto yy236;
		goto yy44;
yy145:
		YYDEBUG(145, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych <= 'L') {
				if (yych <= 'K') goto yy44;
				goto yy237;
			} else {
				if (yych <= 'R') goto yy44;
				if (yych <= 'S') goto yy238;
				goto yy239;
			}
		} else {
			if (yych <= 'r') {
				if (yych == 'l') goto yy237;
				goto yy44;
			} else {
				if (yych <= 's') goto yy238;
				if (yych <= 't') goto yy239;
				goto yy44;
			}
		}
yy146:
		YYDEBUG(146, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych == 'A') goto yy240;
			if (yych <= 'N') goto yy44;
			goto yy241;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy44;
				goto yy240;
			} else {
				if (yych == 'o') goto yy241;
				goto yy44;
			}
		}
yy147:
		YYDEBUG(147, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy242;
		if (yych == 'n') goto yy242;
		goto yy44;
yy148:
		YYDEBUG(148, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'F') {
			if (yych == 'C') goto yy243;
			if (yych <= 'E') goto yy44;
			goto yy244;
		} else {
			if (yych <= 'c') {
				if (yych <= 'b') goto yy44;
				goto yy243;
			} else {
				if (yych == 'f') goto yy244;
				goto yy44;
			}
		}
yy149:
		YYDEBUG(149, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy245;
		if (yych == 'e') goto yy245;
		goto yy44;
yy150:
		YYDEBUG(150, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(151, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1331 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_DO);
}
#line 2931 "Zend/zend_language_scanner.c"
yy152:
		YYDEBUG(152, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy247;
		if (yych == 'h') goto yy247;
		goto yy44;
yy153:
		YYDEBUG(153, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy248;
		if (yych == 's') goto yy248;
		goto yy44;
yy154:
		YYDEBUG(154, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy249;
		if (yych == 'p') goto yy249;
		goto yy44;
yy155:
		YYDEBUG(155, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy250;
		if (yych == 'd') goto yy250;
		goto yy44;
yy156:
		YYDEBUG(156, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy251;
		if (yych == 'a') goto yy251;
		goto yy44;
yy157:
		YYDEBUG(157, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych == 'I') goto yy252;
			if (yych <= 'S') goto yy44;
			goto yy253;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy44;
				goto yy252;
			} else {
				if (yych == 't') goto yy253;
				goto yy44;
			}
		}
yy158:
		YYDEBUG(158, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy254;
		if (yych == 'n') goto yy254;
		goto yy44;
yy159:
		YYDEBUG(159, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy255;
		if (yych == 'r') goto yy255;
		goto yy44;
yy160:
		YYDEBUG(160, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy257;
		if (yych == 'n') goto yy257;
		goto yy44;
yy161:
		YYDEBUG(161, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy258;
		if (yych == 'o') goto yy258;
		goto yy44;
yy162:
		YYDEBUG(162, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy259;
		if (yych == 't') goto yy259;
		goto yy44;
yy163:
		YYDEBUG(163, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(164, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1307 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_IF);
}
#line 3020 "Zend/zend_language_scanner.c"
yy165:
		YYDEBUG(165, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy260;
		if (yych == 'p') goto yy260;
		goto yy44;
yy166:
		YYDEBUG(166, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych <= 'C') {
				if (yych <= 'B') goto yy44;
				goto yy261;
			} else {
				if (yych <= 'R') goto yy44;
				if (yych <= 'S') goto yy262;
				goto yy263;
			}
		} else {
			if (yych <= 'r') {
				if (yych == 'c') goto yy261;
				goto yy44;
			} else {
				if (yych <= 's') goto yy262;
				if (yych <= 't') goto yy263;
				goto yy44;
			}
		}
yy167:
		YYDEBUG(167, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy264;
		if (yych == 's') goto yy264;
		goto yy44;
yy168:
		YYDEBUG(168, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy265;
		if (yych == 's') goto yy265;
		goto yy44;
yy169:
		YYDEBUG(169, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy266;
		if (yych == 'm') goto yy266;
		goto yy44;
yy170:
		YYDEBUG(170, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'W') goto yy267;
		if (yych == 'w') goto yy267;
		goto yy44;
yy171:
		YYDEBUG(171, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(172, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1691 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_LOGICAL_OR);
}
#line 3085 "Zend/zend_language_scanner.c"
yy173:
		YYDEBUG(173, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych == 'I') goto yy269;
			if (yych <= 'N') goto yy44;
			goto yy270;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy44;
				goto yy269;
			} else {
				if (yych == 'o') goto yy270;
				goto yy44;
			}
		}
yy174:
		YYDEBUG(174, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy271;
		if (yych == 'b') goto yy271;
		goto yy44;
yy175:
		YYDEBUG(175, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych == 'Q') goto yy272;
			if (yych <= 'S') goto yy44;
			goto yy273;
		} else {
			if (yych <= 'q') {
				if (yych <= 'p') goto yy44;
				goto yy272;
			} else {
				if (yych == 't') goto yy273;
				goto yy44;
			}
		}
yy176:
		YYDEBUG(176, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy274;
		if (yych == 'a') goto yy274;
		goto yy44;
yy177:
		YYDEBUG(177, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy275;
		if (yych == 'i') goto yy275;
		goto yy44;
yy178:
		YYDEBUG(178, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy276;
		if (yych == 'r') goto yy276;
		goto yy44;
yy179:
		YYDEBUG(179, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'Y') {
			if (yych == 'A') goto yy277;
			if (yych <= 'X') goto yy44;
			goto yy278;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy44;
				goto yy277;
			} else {
				if (yych == 'y') goto yy278;
				goto yy44;
			}
		}
yy180:
		YYDEBUG(180, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy280;
		if (yych == 's') goto yy280;
		goto yy44;
yy181:
		YYDEBUG(181, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy281;
		if (yych == 'e') goto yy281;
		goto yy44;
yy182:
		YYDEBUG(182, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy283;
		if (yych == 'r') goto yy283;
		goto yy44;
yy183:
		YYDEBUG(183, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy285;
		if (yych == 'i') goto yy285;
		goto yy44;
yy184:
		YYDEBUG(184, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy286;
		if (yych == 'r') goto yy286;
		goto yy44;
yy185:
		YYDEBUG(185, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy288;
		if (yych == 'e') goto yy288;
		goto yy44;
yy186:
		YYDEBUG(186, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(187, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1679 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_XOR_EQUAL);
}
#line 3203 "Zend/zend_language_scanner.c"
yy188:
		YYDEBUG(188, *YYCURSOR);
		yych = *++YYCURSOR;
		switch (yych) {
		case 'C':
		case 'c':	goto yy289;
		case 'D':
		case 'd':	goto yy290;
		case 'F':
		case 'f':	goto yy291;
		case 'H':
		case 'h':	goto yy292;
		case 'L':
		case 'l':	goto yy293;
		case 'M':
		case 'm':	goto yy294;
		case 'N':
		case 'n':	goto yy295;
		case 'T':
		case 't':	goto yy296;
		default:	goto yy44;
		}
yy189:
		YYDEBUG(189, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(190, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1675 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_OR_EQUAL);
}
#line 3235 "Zend/zend_language_scanner.c"
yy191:
		YYDEBUG(191, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(192, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1683 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_BOOLEAN_OR);
}
#line 3245 "Zend/zend_language_scanner.c"
yy193:
		YYDEBUG(193, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(194, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1607 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_IS_NOT_IDENTICAL);
}
#line 3255 "Zend/zend_language_scanner.c"
yy195:
		YYDEBUG(195, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy297;
		if (yych == 'r') goto yy297;
		goto yy82;
yy196:
		YYDEBUG(196, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy298;
		if (yych == 'n') goto yy298;
		goto yy82;
yy197:
		YYDEBUG(197, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy299;
		if (yych == 'o') goto yy299;
		goto yy82;
yy198:
		YYDEBUG(198, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy300;
		if (yych == 'u') goto yy300;
		goto yy82;
yy199:
		YYDEBUG(199, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy301;
		if (yych == 'o') goto yy301;
		goto yy82;
yy200:
		YYDEBUG(200, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy302;
		if (yych == 't') goto yy302;
		goto yy82;
yy201:
		YYDEBUG(201, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'J') goto yy303;
		if (yych == 'j') goto yy303;
		goto yy82;
yy202:
		YYDEBUG(202, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy304;
		if (yych == 'a') goto yy304;
		goto yy82;
yy203:
		YYDEBUG(203, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy305;
		if (yych == 'r') goto yy305;
		goto yy82;
yy204:
		YYDEBUG(204, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy306;
		if (yych == 's') goto yy306;
		goto yy82;
yy205:
		YYDEBUG(205, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(206, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1647 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_POW_EQUAL);
}
#line 3325 "Zend/zend_language_scanner.c"
yy207:
		YYDEBUG(207, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(208, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1455 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ELLIPSIS);
}
#line 3335 "Zend/zend_language_scanner.c"
yy209:
		YYDEBUG(209, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy82;
			if (yych <= '\n') goto yy307;
			goto yy82;
		} else {
			if (yych <= '\r') goto yy307;
			if (yych == ' ') goto yy307;
			goto yy82;
		}
yy210:
		YYDEBUG(210, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(211, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy210;
		}
		YYDEBUG(212, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1752 "Zend/zend_language_scanner.l"
		{
	char *bin = yytext + 2; /* Skip "0b" */
	int len = yyleng - 2;
	char *end;

	/* Skip any leading 0s */
	while (*bin == '0') {
		++bin;
		--len;
	}

	if (len < SIZEOF_ZEND_LONG * 8) {
		if (len == 0) {
			ZVAL_LONG(zendlval, 0);
		} else {
			errno = 0;
			ZVAL_LONG(zendlval, ZEND_STRTOL(bin, &end, 2));
			ZEND_ASSERT(!errno && end == yytext + yyleng);
		}
		RETURN_TOKEN_WITH_VAL(T_LNUMBER);
	} else {
		ZVAL_DOUBLE(zendlval, zend_bin_strtod(bin, (const char **)&end));
		/* errno isn't checked since we allow HUGE_VAL/INF overflow */
		ZEND_ASSERT(end == yytext + yyleng);
		RETURN_TOKEN_WITH_VAL(T_DNUMBER);
	}
}
#line 3387 "Zend/zend_language_scanner.c"
yy213:
		YYDEBUG(213, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '/') goto yy82;
		if (yych >= ':') goto yy82;
yy214:
		YYDEBUG(214, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(215, *YYCURSOR);
		if (yych <= '/') goto yy109;
		if (yych <= '9') goto yy214;
		goto yy109;
yy216:
		YYDEBUG(216, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(217, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy216;
		}
		YYDEBUG(218, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1832 "Zend/zend_language_scanner.l"
		{
	char *hex = yytext + 2; /* Skip "0x" */
	int len = yyleng - 2;
	char *end;

	/* Skip any leading 0s */
	while (*hex == '0') {
		hex++;
		len--;
	}

	if (len < SIZEOF_ZEND_LONG * 2 || (len == SIZEOF_ZEND_LONG * 2 && *hex <= '7')) {
		if (len == 0) {
			ZVAL_LONG(zendlval, 0);
		} else {
			errno = 0;
			ZVAL_LONG(zendlval, ZEND_STRTOL(hex, &end, 16));
			ZEND_ASSERT(!errno && end == hex + len);
		}
		RETURN_TOKEN_WITH_VAL(T_LNUMBER);
	} else {
		ZVAL_DOUBLE(zendlval, zend_hex_strtod(hex, (const char **)&end));
		/* errno isn't checked since we allow HUGE_VAL/INF overflow */
		ZEND_ASSERT(end == hex + len);
		RETURN_TOKEN_WITH_VAL(T_DNUMBER);
	}
}
#line 3441 "Zend/zend_language_scanner.c"
yy219:
		YYDEBUG(219, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(220, *YYCURSOR);
		if (yych <= '\'') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy219;
				if (yych <= 0x1F) goto yy82;
				goto yy219;
			} else {
				if (yych == '"') goto yy309;
				if (yych <= '&') goto yy82;
				goto yy310;
			}
		} else {
			if (yych <= '_') {
				if (yych <= '@') goto yy82;
				if (yych <= 'Z') goto yy311;
				if (yych <= '^') goto yy82;
				goto yy311;
			} else {
				if (yych <= '`') goto yy82;
				if (yych <= 'z') goto yy311;
				if (yych <= 0x7F) goto yy82;
				goto yy311;
			}
		}
yy221:
		YYDEBUG(221, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(222, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1663 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_SL_EQUAL);
}
#line 3480 "Zend/zend_language_scanner.c"
yy223:
		YYDEBUG(223, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(224, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1619 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_SPACESHIP);
}
#line 3490 "Zend/zend_language_scanner.c"
yy225:
		YYDEBUG(225, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(226, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1603 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_IS_IDENTICAL);
}
#line 3500 "Zend/zend_language_scanner.c"
yy227:
		YYDEBUG(227, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(228, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1667 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_SR_EQUAL);
}
#line 3510 "Zend/zend_language_scanner.c"
yy229:
		YYDEBUG(229, *YYCURSOR);
		++YYCURSOR;
		goto yy135;
yy230:
		YYDEBUG(230, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy229;
		goto yy135;
yy231:
		YYDEBUG(231, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy313;
		if (yych == 't') goto yy313;
		goto yy44;
yy232:
		YYDEBUG(232, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(233, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1695 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_LOGICAL_AND);
}
#line 3538 "Zend/zend_language_scanner.c"
yy234:
		YYDEBUG(234, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy314;
		if (yych == 'a') goto yy314;
		goto yy44;
yy235:
		YYDEBUG(235, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '<') goto yy219;
		goto yy82;
yy236:
		YYDEBUG(236, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy315;
		if (yych == 'a') goto yy315;
		goto yy44;
yy237:
		YYDEBUG(237, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy316;
		if (yych == 'l') goto yy316;
		goto yy44;
yy238:
		YYDEBUG(238, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy317;
		if (yych == 'e') goto yy317;
		goto yy44;
yy239:
		YYDEBUG(239, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy319;
		if (yych == 'c') goto yy319;
		goto yy44;
yy240:
		YYDEBUG(240, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy320;
		if (yych == 's') goto yy320;
		goto yy44;
yy241:
		YYDEBUG(241, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy321;
		if (yych == 'n') goto yy321;
		goto yy44;
yy242:
		YYDEBUG(242, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych <= 'R') goto yy44;
			if (yych <= 'S') goto yy322;
			goto yy323;
		} else {
			if (yych <= 'r') goto yy44;
			if (yych <= 's') goto yy322;
			if (yych <= 't') goto yy323;
			goto yy44;
		}
yy243:
		YYDEBUG(243, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy324;
		if (yych == 'l') goto yy324;
		goto yy44;
yy244:
		YYDEBUG(244, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy325;
		if (yych == 'a') goto yy325;
		goto yy44;
yy245:
		YYDEBUG(245, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(246, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1265 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_EXIT);
}
#line 3623 "Zend/zend_language_scanner.c"
yy247:
		YYDEBUG(247, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy326;
		if (yych == 'o') goto yy326;
		goto yy44;
yy248:
		YYDEBUG(248, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy328;
		if (yych == 'e') goto yy328;
		goto yy44;
yy249:
		YYDEBUG(249, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy330;
		if (yych == 't') goto yy330;
		goto yy44;
yy250:
		YYDEBUG(250, *YYCURSOR);
		yych = *++YYCURSOR;
		switch (yych) {
		case 'D':
		case 'd':	goto yy331;
		case 'F':
		case 'f':	goto yy332;
		case 'I':
		case 'i':	goto yy333;
		case 'S':
		case 's':	goto yy334;
		case 'W':
		case 'w':	goto yy335;
		default:	goto yy44;
		}
yy251:
		YYDEBUG(251, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy336;
		if (yych == 'l') goto yy336;
		goto yy44;
yy252:
		YYDEBUG(252, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy338;
		if (yych == 't') goto yy338;
		goto yy44;
yy253:
		YYDEBUG(253, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy340;
		if (yych == 'e') goto yy340;
		goto yy44;
yy254:
		YYDEBUG(254, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy341;
		if (yych == 'a') goto yy341;
		goto yy44;
yy255:
		YYDEBUG(255, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '^') {
			if (yych <= '@') {
				if (yych <= '/') goto yy256;
				if (yych <= '9') goto yy43;
			} else {
				if (yych == 'E') goto yy342;
				if (yych <= 'Z') goto yy43;
			}
		} else {
			if (yych <= 'd') {
				if (yych != '`') goto yy43;
			} else {
				if (yych <= 'e') goto yy342;
				if (yych <= 'z') goto yy43;
				if (yych >= 0x80) goto yy43;
			}
		}
yy256:
		YYDEBUG(256, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1335 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_FOR);
}
#line 3709 "Zend/zend_language_scanner.c"
yy257:
		YYDEBUG(257, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy343;
		if (yych == 'c') goto yy343;
		goto yy44;
yy258:
		YYDEBUG(258, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy344;
		if (yych == 'b') goto yy344;
		goto yy44;
yy259:
		YYDEBUG(259, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy345;
		if (yych == 'o') goto yy345;
		goto yy44;
yy260:
		YYDEBUG(260, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy347;
		if (yych == 'l') goto yy347;
		goto yy44;
yy261:
		YYDEBUG(261, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy348;
		if (yych == 'l') goto yy348;
		goto yy44;
yy262:
		YYDEBUG(262, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy349;
		if (yych == 't') goto yy349;
		goto yy44;
yy263:
		YYDEBUG(263, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy350;
		if (yych == 'e') goto yy350;
		goto yy44;
yy264:
		YYDEBUG(264, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy351;
		if (yych == 'e') goto yy351;
		goto yy44;
yy265:
		YYDEBUG(265, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy352;
		if (yych == 't') goto yy352;
		goto yy44;
yy266:
		YYDEBUG(266, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy354;
		if (yych == 'e') goto yy354;
		goto yy44;
yy267:
		YYDEBUG(267, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(268, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1463 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_NEW);
}
#line 3782 "Zend/zend_language_scanner.c"
yy269:
		YYDEBUG(269, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'V') {
			if (yych == 'N') goto yy355;
			if (yych <= 'U') goto yy44;
			goto yy356;
		} else {
			if (yych <= 'n') {
				if (yych <= 'm') goto yy44;
				goto yy355;
			} else {
				if (yych == 'v') goto yy356;
				goto yy44;
			}
		}
yy270:
		YYDEBUG(270, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy357;
		if (yych == 't') goto yy357;
		goto yy44;
yy271:
		YYDEBUG(271, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy358;
		if (yych == 'l') goto yy358;
		goto yy44;
yy272:
		YYDEBUG(272, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy359;
		if (yych == 'u') goto yy359;
		goto yy44;
yy273:
		YYDEBUG(273, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy360;
		if (yych == 'u') goto yy360;
		goto yy44;
yy274:
		YYDEBUG(274, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy361;
		if (yych == 't') goto yy361;
		goto yy44;
yy275:
		YYDEBUG(275, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy362;
		if (yych == 't') goto yy362;
		goto yy44;
yy276:
		YYDEBUG(276, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy363;
		if (yych == 'o') goto yy363;
		goto yy44;
yy277:
		YYDEBUG(277, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy364;
		if (yych == 'i') goto yy364;
		goto yy44;
yy278:
		YYDEBUG(278, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(279, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1291 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_TRY);
}
#line 3859 "Zend/zend_language_scanner.c"
yy280:
		YYDEBUG(280, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy365;
		if (yych == 'e') goto yy365;
		goto yy44;
yy281:
		YYDEBUG(281, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(282, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1527 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_USE);
}
#line 3878 "Zend/zend_language_scanner.c"
yy283:
		YYDEBUG(283, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(284, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1471 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_VAR);
}
#line 3891 "Zend/zend_language_scanner.c"
yy285:
		YYDEBUG(285, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy366;
		if (yych == 'l') goto yy366;
		goto yy44;
yy286:
		YYDEBUG(286, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(287, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1699 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_LOGICAL_XOR);
}
#line 3910 "Zend/zend_language_scanner.c"
yy288:
		YYDEBUG(288, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy367;
		if (yych == 'l') goto yy367;
		goto yy44;
yy289:
		YYDEBUG(289, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy368;
		if (yych == 'l') goto yy368;
		goto yy44;
yy290:
		YYDEBUG(290, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy369;
		if (yych == 'i') goto yy369;
		goto yy44;
yy291:
		YYDEBUG(291, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'U') {
			if (yych == 'I') goto yy370;
			if (yych <= 'T') goto yy44;
			goto yy371;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy44;
				goto yy370;
			} else {
				if (yych == 'u') goto yy371;
				goto yy44;
			}
		}
yy292:
		YYDEBUG(292, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy372;
		if (yych == 'a') goto yy372;
		goto yy44;
yy293:
		YYDEBUG(293, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy373;
		if (yych == 'i') goto yy373;
		goto yy44;
yy294:
		YYDEBUG(294, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy374;
		if (yych == 'e') goto yy374;
		goto yy44;
yy295:
		YYDEBUG(295, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy375;
		if (yych == 'a') goto yy375;
		goto yy44;
yy296:
		YYDEBUG(296, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy376;
		if (yych == 'r') goto yy376;
		goto yy44;
yy297:
		YYDEBUG(297, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy377;
		if (yych == 'a') goto yy377;
		goto yy82;
yy298:
		YYDEBUG(298, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy378;
		if (yych == 'a') goto yy378;
		goto yy82;
yy299:
		YYDEBUG(299, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy379;
		if (yych == 'l') goto yy379;
		goto yy82;
yy300:
		YYDEBUG(300, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy380;
		if (yych == 'b') goto yy380;
		goto yy82;
yy301:
		YYDEBUG(301, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy381;
		if (yych == 'a') goto yy381;
		goto yy82;
yy302:
		YYDEBUG(302, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy386;
		if (yych == 'e') goto yy386;
		goto yy383;
yy303:
		YYDEBUG(303, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy387;
		if (yych == 'e') goto yy387;
		goto yy82;
yy304:
		YYDEBUG(304, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy388;
		if (yych == 'l') goto yy388;
		goto yy82;
yy305:
		YYDEBUG(305, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy390;
		if (yych == 'i') goto yy390;
		goto yy82;
yy306:
		YYDEBUG(306, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy391;
		if (yych == 'e') goto yy391;
		goto yy82;
yy307:
		YYDEBUG(307, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(308, *YYCURSOR);
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy113;
			if (yych <= '\n') goto yy307;
			goto yy113;
		} else {
			if (yych <= '\r') goto yy307;
			if (yych == ' ') goto yy307;
			goto yy113;
		}
yy309:
		YYDEBUG(309, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '"') goto yy82;
		if (yych <= '/') goto yy393;
		if (yych <= '9') goto yy82;
		goto yy393;
yy310:
		YYDEBUG(310, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\'') goto yy82;
		if (yych <= '/') goto yy395;
		if (yych <= '9') goto yy82;
		goto yy395;
yy311:
		YYDEBUG(311, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(312, *YYCURSOR);
		if (yych <= '@') {
			if (yych <= '\f') {
				if (yych == '\n') goto yy396;
				goto yy82;
			} else {
				if (yych <= '\r') goto yy398;
				if (yych <= '/') goto yy82;
				if (yych <= '9') goto yy311;
				goto yy82;
			}
		} else {
			if (yych <= '_') {
				if (yych <= 'Z') goto yy311;
				if (yych <= '^') goto yy82;
				goto yy311;
			} else {
				if (yych <= '`') goto yy82;
				if (yych <= 'z') goto yy311;
				if (yych <= 0x7F) goto yy82;
				goto yy311;
			}
		}
yy313:
		YYDEBUG(313, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy399;
		if (yych == 'r') goto yy399;
		goto yy44;
yy314:
		YYDEBUG(314, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy400;
		if (yych == 'y') goto yy400;
		goto yy44;
yy315:
		YYDEBUG(315, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'K') goto yy402;
		if (yych == 'k') goto yy402;
		goto yy44;
yy316:
		YYDEBUG(316, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy404;
		if (yych == 'a') goto yy404;
		goto yy44;
yy317:
		YYDEBUG(317, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(318, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1375 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_CASE);
}
#line 4128 "Zend/zend_language_scanner.c"
yy319:
		YYDEBUG(319, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy405;
		if (yych == 'h') goto yy405;
		goto yy44;
yy320:
		YYDEBUG(320, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy407;
		if (yych == 's') goto yy407;
		goto yy44;
yy321:
		YYDEBUG(321, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy409;
		if (yych == 'e') goto yy409;
		goto yy44;
yy322:
		YYDEBUG(322, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy411;
		if (yych == 't') goto yy411;
		goto yy44;
yy323:
		YYDEBUG(323, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy413;
		if (yych == 'i') goto yy413;
		goto yy44;
yy324:
		YYDEBUG(324, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy414;
		if (yych == 'a') goto yy414;
		goto yy44;
yy325:
		YYDEBUG(325, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy415;
		if (yych == 'u') goto yy415;
		goto yy44;
yy326:
		YYDEBUG(326, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(327, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1395 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ECHO);
}
#line 4183 "Zend/zend_language_scanner.c"
yy328:
		YYDEBUG(328, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '^') {
			if (yych <= '@') {
				if (yych <= '/') goto yy329;
				if (yych <= '9') goto yy43;
			} else {
				if (yych == 'I') goto yy416;
				if (yych <= 'Z') goto yy43;
			}
		} else {
			if (yych <= 'h') {
				if (yych != '`') goto yy43;
			} else {
				if (yych <= 'i') goto yy416;
				if (yych <= 'z') goto yy43;
				if (yych >= 0x80) goto yy43;
			}
		}
yy329:
		YYDEBUG(329, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1319 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ELSE);
}
#line 4211 "Zend/zend_language_scanner.c"
yy330:
		YYDEBUG(330, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy417;
		if (yych == 'y') goto yy417;
		goto yy44;
yy331:
		YYDEBUG(331, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy419;
		if (yych == 'e') goto yy419;
		goto yy44;
yy332:
		YYDEBUG(332, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy420;
		if (yych == 'o') goto yy420;
		goto yy44;
yy333:
		YYDEBUG(333, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy421;
		if (yych == 'f') goto yy421;
		goto yy44;
yy334:
		YYDEBUG(334, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'W') goto yy423;
		if (yych == 'w') goto yy423;
		goto yy44;
yy335:
		YYDEBUG(335, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy424;
		if (yych == 'h') goto yy424;
		goto yy44;
yy336:
		YYDEBUG(336, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(337, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1503 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_EVAL);
}
#line 4260 "Zend/zend_language_scanner.c"
yy338:
		YYDEBUG(338, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(339, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1261 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_EXIT);
}
#line 4273 "Zend/zend_language_scanner.c"
yy340:
		YYDEBUG(340, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy425;
		if (yych == 'n') goto yy425;
		goto yy44;
yy341:
		YYDEBUG(341, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy426;
		if (yych == 'l') goto yy426;
		goto yy44;
yy342:
		YYDEBUG(342, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy428;
		if (yych == 'a') goto yy428;
		goto yy44;
yy343:
		YYDEBUG(343, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy429;
		if (yych == 't') goto yy429;
		goto yy44;
yy344:
		YYDEBUG(344, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy430;
		if (yych == 'a') goto yy430;
		goto yy44;
yy345:
		YYDEBUG(345, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(346, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1391 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_GOTO);
}
#line 4316 "Zend/zend_language_scanner.c"
yy347:
		YYDEBUG(347, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy431;
		if (yych == 'e') goto yy431;
		goto yy44;
yy348:
		YYDEBUG(348, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy432;
		if (yych == 'u') goto yy432;
		goto yy44;
yy349:
		YYDEBUG(349, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'E') {
			if (yych == 'A') goto yy433;
			if (yych <= 'D') goto yy44;
			goto yy434;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy44;
				goto yy433;
			} else {
				if (yych == 'e') goto yy434;
				goto yy44;
			}
		}
yy350:
		YYDEBUG(350, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy435;
		if (yych == 'r') goto yy435;
		goto yy44;
yy351:
		YYDEBUG(351, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy436;
		if (yych == 't') goto yy436;
		goto yy44;
yy352:
		YYDEBUG(352, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(353, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1583 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_LIST);
}
#line 4369 "Zend/zend_language_scanner.c"
yy354:
		YYDEBUG(354, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy438;
		if (yych == 's') goto yy438;
		goto yy44;
yy355:
		YYDEBUG(355, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy439;
		if (yych == 't') goto yy439;
		goto yy44;
yy356:
		YYDEBUG(356, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy441;
		if (yych == 'a') goto yy441;
		goto yy44;
yy357:
		YYDEBUG(357, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy442;
		if (yych == 'e') goto yy442;
		goto yy44;
yy358:
		YYDEBUG(358, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy443;
		if (yych == 'i') goto yy443;
		goto yy44;
yy359:
		YYDEBUG(359, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy444;
		if (yych == 'i') goto yy444;
		goto yy44;
yy360:
		YYDEBUG(360, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy445;
		if (yych == 'r') goto yy445;
		goto yy44;
yy361:
		YYDEBUG(361, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy446;
		if (yych == 'i') goto yy446;
		goto yy44;
yy362:
		YYDEBUG(362, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy447;
		if (yych == 'c') goto yy447;
		goto yy44;
yy363:
		YYDEBUG(363, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'W') goto yy448;
		if (yych == 'w') goto yy448;
		goto yy44;
yy364:
		YYDEBUG(364, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy450;
		if (yych == 't') goto yy450;
		goto yy44;
yy365:
		YYDEBUG(365, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy452;
		if (yych == 't') goto yy452;
		goto yy44;
yy366:
		YYDEBUG(366, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy454;
		if (yych == 'e') goto yy454;
		goto yy44;
yy367:
		YYDEBUG(367, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy456;
		if (yych == 'd') goto yy456;
		goto yy44;
yy368:
		YYDEBUG(368, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy458;
		if (yych == 'a') goto yy458;
		goto yy44;
yy369:
		YYDEBUG(369, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy459;
		if (yych == 'r') goto yy459;
		goto yy44;
yy370:
		YYDEBUG(370, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy460;
		if (yych == 'l') goto yy460;
		goto yy44;
yy371:
		YYDEBUG(371, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy461;
		if (yych == 'n') goto yy461;
		goto yy44;
yy372:
		YYDEBUG(372, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy462;
		if (yych == 'l') goto yy462;
		goto yy44;
yy373:
		YYDEBUG(373, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy463;
		if (yych == 'n') goto yy463;
		goto yy44;
yy374:
		YYDEBUG(374, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy464;
		if (yych == 't') goto yy464;
		goto yy44;
yy375:
		YYDEBUG(375, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy465;
		if (yych == 'm') goto yy465;
		goto yy44;
yy376:
		YYDEBUG(376, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy466;
		if (yych == 'a') goto yy466;
		goto yy44;
yy377:
		YYDEBUG(377, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy467;
		if (yych == 'y') goto yy467;
		goto yy82;
yy378:
		YYDEBUG(378, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy469;
		if (yych == 'r') goto yy469;
		goto yy82;
yy379:
		YYDEBUG(379, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy474;
		if (yych == 'e') goto yy474;
		goto yy471;
yy380:
		YYDEBUG(380, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy475;
		if (yych == 'l') goto yy475;
		goto yy82;
yy381:
		YYDEBUG(381, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy388;
		if (yych == 't') goto yy388;
		goto yy82;
yy382:
		YYDEBUG(382, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy383:
		YYDEBUG(383, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy382;
			goto yy82;
		} else {
			if (yych <= ' ') goto yy382;
			if (yych != ')') goto yy82;
		}
		YYDEBUG(384, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(385, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1475 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_INT_CAST);
}
#line 4560 "Zend/zend_language_scanner.c"
yy386:
		YYDEBUG(386, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'G') goto yy476;
		if (yych == 'g') goto yy476;
		goto yy82;
yy387:
		YYDEBUG(387, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy477;
		if (yych == 'c') goto yy477;
		goto yy82;
yy388:
		YYDEBUG(388, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(389, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy388;
			goto yy82;
		} else {
			if (yych <= ' ') goto yy388;
			if (yych == ')') goto yy478;
			goto yy82;
		}
yy390:
		YYDEBUG(390, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy480;
		if (yych == 'n') goto yy480;
		goto yy82;
yy391:
		YYDEBUG(391, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy481;
		if (yych == 't') goto yy481;
		goto yy82;
yy392:
		YYDEBUG(392, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy393:
		YYDEBUG(393, *YYCURSOR);
		if (yych <= 'Z') {
			if (yych <= '/') {
				if (yych == '"') goto yy483;
				goto yy82;
			} else {
				if (yych <= '9') goto yy392;
				if (yych <= '@') goto yy82;
				goto yy392;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy392;
				goto yy82;
			} else {
				if (yych <= 'z') goto yy392;
				if (yych <= 0x7F) goto yy82;
				goto yy392;
			}
		}
yy394:
		YYDEBUG(394, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy395:
		YYDEBUG(395, *YYCURSOR);
		if (yych <= 'Z') {
			if (yych <= '/') {
				if (yych == '\'') goto yy483;
				goto yy82;
			} else {
				if (yych <= '9') goto yy394;
				if (yych <= '@') goto yy82;
				goto yy394;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy394;
				goto yy82;
			} else {
				if (yych <= 'z') goto yy394;
				if (yych <= 0x7F) goto yy82;
				goto yy394;
			}
		}
yy396:
		YYDEBUG(396, *YYCURSOR);
		++YYCURSOR;
yy397:
		YYDEBUG(397, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2269 "Zend/zend_language_scanner.l"
		{
	char *s;
	unsigned char *saved_cursor;
	int bprefix = (yytext[0] != '<') ? 1 : 0, spacing = 0, indentation = 0;
	zend_heredoc_label *heredoc_label = emalloc(sizeof(zend_heredoc_label));
	zend_bool is_heredoc = 1;

	CG(zend_lineno)++;
	heredoc_label->length = yyleng-bprefix-3-1-(yytext[yyleng-2]=='\r'?1:0);
	s = yytext+bprefix+3;
	while ((*s == ' ') || (*s == '\t')) {
		s++;
		heredoc_label->length--;
	}

	if (*s == '\'') {
		s++;
		heredoc_label->length -= 2;
		is_heredoc = 0;

		BEGIN(ST_NOWDOC);
	} else {
		if (*s == '"') {
			s++;
			heredoc_label->length -= 2;
		}

		BEGIN(ST_HEREDOC);
	}

	heredoc_label->label = estrndup(s, heredoc_label->length);
	heredoc_label->indentation = 0;
	saved_cursor = YYCURSOR;

	zend_ptr_stack_push(&SCNG(heredoc_label_stack), (void *) heredoc_label);

	while (YYCURSOR < YYLIMIT && (*YYCURSOR == ' ' || *YYCURSOR == '\t')) {
		if (*YYCURSOR == '\t') {
			spacing |= HEREDOC_USING_TABS;
		} else {
			spacing |= HEREDOC_USING_SPACES;
		}
		++YYCURSOR;
		++indentation;
	}

	if (YYCURSOR == YYLIMIT) {
		YYCURSOR = saved_cursor;
		RETURN_TOKEN(T_START_HEREDOC);
	}

	/* Check for ending label on the next line */
	if (heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, s, heredoc_label->length)) {
		if (!IS_LABEL_START(YYCURSOR[heredoc_label->length])) {
			if (spacing == (HEREDOC_USING_SPACES | HEREDOC_USING_TABS)) {
				zend_throw_exception(zend_ce_parse_error, "Invalid indentation - tabs and spaces cannot be mixed", 0);
			}

			YYCURSOR = saved_cursor;
			heredoc_label->indentation = indentation;

			BEGIN(ST_END_HEREDOC);
			RETURN_TOKEN(T_START_HEREDOC);
		}
	}

	YYCURSOR = saved_cursor;

	if (is_heredoc && !SCNG(heredoc_scan_ahead)) {
		zend_lex_state current_state;
		int heredoc_nesting_level = 1;
		int first_token = 0;

		zend_save_lexical_state(&current_state);

		SCNG(heredoc_scan_ahead) = 1;
		SCNG(heredoc_indentation) = 0;
		SCNG(heredoc_indentation_uses_spaces) = 0;
		LANG_SCNG(on_event) = NULL;

		zend_ptr_stack_reverse_apply(&current_state.heredoc_label_stack, copy_heredoc_label_stack);

		zend_exception_save();
		while (heredoc_nesting_level) {
			zval zv;
			int retval;

			ZVAL_UNDEF(&zv);
			retval = lex_scan(&zv, NULL);
			zval_ptr_dtor_nogc(&zv);

			if (EG(exception)) {
				zend_clear_exception();
				break;
			}

			if (!first_token) {
				first_token = retval;
			}

			switch (retval) {
				case T_START_HEREDOC:
					++heredoc_nesting_level;
					break;
				case T_END_HEREDOC:
					--heredoc_nesting_level;
					break;
				case END:
					heredoc_nesting_level = 0;
			}
		}
		zend_exception_restore();

		if (
		    (first_token == T_VARIABLE
		     || first_token == T_DOLLAR_OPEN_CURLY_BRACES
		     || first_token == T_CURLY_OPEN
		    ) && SCNG(heredoc_indentation)) {
			zend_throw_exception_ex(zend_ce_parse_error, 0, "Invalid body indentation level (expecting an indentation level of at least %d)", SCNG(heredoc_indentation));
		}

		heredoc_label->indentation = SCNG(heredoc_indentation);
		heredoc_label->indentation_uses_spaces = SCNG(heredoc_indentation_uses_spaces);

		zend_restore_lexical_state(&current_state);
		SCNG(heredoc_scan_ahead) = 0;
		CG(increment_lineno) = 0;
	}

	RETURN_TOKEN(T_START_HEREDOC);
}
#line 4789 "Zend/zend_language_scanner.c"
yy398:
		YYDEBUG(398, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy396;
		goto yy397;
yy399:
		YYDEBUG(399, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy484;
		if (yych == 'a') goto yy484;
		goto yy44;
yy400:
		YYDEBUG(400, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(401, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1587 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ARRAY);
}
#line 4813 "Zend/zend_language_scanner.c"
yy402:
		YYDEBUG(402, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(403, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1383 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_BREAK);
}
#line 4826 "Zend/zend_language_scanner.c"
yy404:
		YYDEBUG(404, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy485;
		if (yych == 'b') goto yy485;
		goto yy44;
yy405:
		YYDEBUG(405, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(406, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1295 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_CATCH);
}
#line 4845 "Zend/zend_language_scanner.c"
yy407:
		YYDEBUG(407, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(408, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1403 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_CLASS);
}
#line 4858 "Zend/zend_language_scanner.c"
yy409:
		YYDEBUG(409, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(410, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1467 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_CLONE);
}
#line 4871 "Zend/zend_language_scanner.c"
yy411:
		YYDEBUG(411, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(412, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1273 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_CONST);
}
#line 4884 "Zend/zend_language_scanner.c"
yy413:
		YYDEBUG(413, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy486;
		if (yych == 'n') goto yy486;
		goto yy44;
yy414:
		YYDEBUG(414, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy487;
		if (yych == 'r') goto yy487;
		goto yy44;
yy415:
		YYDEBUG(415, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy488;
		if (yych == 'l') goto yy488;
		goto yy44;
yy416:
		YYDEBUG(416, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy489;
		if (yych == 'f') goto yy489;
		goto yy44;
yy417:
		YYDEBUG(417, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(418, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1543 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_EMPTY);
}
#line 4921 "Zend/zend_language_scanner.c"
yy419:
		YYDEBUG(419, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy491;
		if (yych == 'c') goto yy491;
		goto yy44;
yy420:
		YYDEBUG(420, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy492;
		if (yych == 'r') goto yy492;
		goto yy44;
yy421:
		YYDEBUG(421, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(422, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1315 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ENDIF);
}
#line 4946 "Zend/zend_language_scanner.c"
yy423:
		YYDEBUG(423, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy494;
		if (yych == 'i') goto yy494;
		goto yy44;
yy424:
		YYDEBUG(424, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy495;
		if (yych == 'i') goto yy495;
		goto yy44;
yy425:
		YYDEBUG(425, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy496;
		if (yych == 'd') goto yy496;
		goto yy44;
yy426:
		YYDEBUG(426, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '^') {
			if (yych <= '@') {
				if (yych <= '/') goto yy427;
				if (yych <= '9') goto yy43;
			} else {
				if (yych == 'L') goto yy497;
				if (yych <= 'Z') goto yy43;
			}
		} else {
			if (yych <= 'k') {
				if (yych != '`') goto yy43;
			} else {
				if (yych <= 'l') goto yy497;
				if (yych <= 'z') goto yy43;
				if (yych >= 0x80) goto yy43;
			}
		}
yy427:
		YYDEBUG(427, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1559 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_FINAL);
}
#line 4992 "Zend/zend_language_scanner.c"
yy428:
		YYDEBUG(428, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy498;
		if (yych == 'c') goto yy498;
		goto yy44;
yy429:
		YYDEBUG(429, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy499;
		if (yych == 'i') goto yy499;
		goto yy44;
yy430:
		YYDEBUG(430, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy500;
		if (yych == 'l') goto yy500;
		goto yy44;
yy431:
		YYDEBUG(431, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy502;
		if (yych == 'm') goto yy502;
		goto yy44;
yy432:
		YYDEBUG(432, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy503;
		if (yych == 'd') goto yy503;
		goto yy44;
yy433:
		YYDEBUG(433, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy504;
		if (yych == 'n') goto yy504;
		goto yy44;
yy434:
		YYDEBUG(434, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy505;
		if (yych == 'a') goto yy505;
		goto yy44;
yy435:
		YYDEBUG(435, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy506;
		if (yych == 'f') goto yy506;
		goto yy44;
yy436:
		YYDEBUG(436, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(437, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1539 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ISSET);
}
#line 5053 "Zend/zend_language_scanner.c"
yy438:
		YYDEBUG(438, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy507;
		if (yych == 'p') goto yy507;
		goto yy44;
yy439:
		YYDEBUG(439, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(440, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1399 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_PRINT);
}
#line 5072 "Zend/zend_language_scanner.c"
yy441:
		YYDEBUG(441, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy508;
		if (yych == 't') goto yy508;
		goto yy44;
yy442:
		YYDEBUG(442, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy509;
		if (yych == 'c') goto yy509;
		goto yy44;
yy443:
		YYDEBUG(443, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy510;
		if (yych == 'c') goto yy510;
		goto yy44;
yy444:
		YYDEBUG(444, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy512;
		if (yych == 'r') goto yy512;
		goto yy44;
yy445:
		YYDEBUG(445, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy513;
		if (yych == 'n') goto yy513;
		goto yy44;
yy446:
		YYDEBUG(446, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy515;
		if (yych == 'c') goto yy515;
		goto yy44;
yy447:
		YYDEBUG(447, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy517;
		if (yych == 'h') goto yy517;
		goto yy44;
yy448:
		YYDEBUG(448, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(449, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1303 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_THROW);
}
#line 5127 "Zend/zend_language_scanner.c"
yy450:
		YYDEBUG(450, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(451, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1411 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_TRAIT);
}
#line 5140 "Zend/zend_language_scanner.c"
yy452:
		YYDEBUG(452, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(453, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1575 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_UNSET);
}
#line 5153 "Zend/zend_language_scanner.c"
yy454:
		YYDEBUG(454, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(455, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1323 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_WHILE);
}
#line 5166 "Zend/zend_language_scanner.c"
yy456:
		YYDEBUG(456, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy457;
			if (yych <= '\n') goto yy519;
		} else {
			if (yych <= '\r') goto yy519;
			if (yych == ' ') goto yy519;
		}
yy457:
		YYDEBUG(457, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1287 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_YIELD);
}
#line 5188 "Zend/zend_language_scanner.c"
yy458:
		YYDEBUG(458, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy521;
		if (yych == 's') goto yy521;
		goto yy44;
yy459:
		YYDEBUG(459, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy522;
		goto yy44;
yy460:
		YYDEBUG(460, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy523;
		if (yych == 'e') goto yy523;
		goto yy44;
yy461:
		YYDEBUG(461, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy524;
		if (yych == 'c') goto yy524;
		goto yy44;
yy462:
		YYDEBUG(462, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy525;
		if (yych == 't') goto yy525;
		goto yy44;
yy463:
		YYDEBUG(463, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy526;
		if (yych == 'e') goto yy526;
		goto yy44;
yy464:
		YYDEBUG(464, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy527;
		if (yych == 'h') goto yy527;
		goto yy44;
yy465:
		YYDEBUG(465, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy528;
		if (yych == 'e') goto yy528;
		goto yy44;
yy466:
		YYDEBUG(466, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy529;
		if (yych == 'i') goto yy529;
		goto yy44;
yy467:
		YYDEBUG(467, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(468, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy467;
			goto yy82;
		} else {
			if (yych <= ' ') goto yy467;
			if (yych == ')') goto yy530;
			goto yy82;
		}
yy469:
		YYDEBUG(469, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy532;
		if (yych == 'y') goto yy532;
		goto yy82;
yy470:
		YYDEBUG(470, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy471:
		YYDEBUG(471, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy470;
			goto yy82;
		} else {
			if (yych <= ' ') goto yy470;
			if (yych != ')') goto yy82;
		}
		YYDEBUG(472, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(473, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1495 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_BOOL_CAST);
}
#line 5284 "Zend/zend_language_scanner.c"
yy474:
		YYDEBUG(474, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy534;
		if (yych == 'a') goto yy534;
		goto yy82;
yy475:
		YYDEBUG(475, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy388;
		if (yych == 'e') goto yy388;
		goto yy82;
yy476:
		YYDEBUG(476, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy535;
		if (yych == 'e') goto yy535;
		goto yy82;
yy477:
		YYDEBUG(477, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy536;
		if (yych == 't') goto yy536;
		goto yy82;
yy478:
		YYDEBUG(478, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(479, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1479 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_DOUBLE_CAST);
}
#line 5318 "Zend/zend_language_scanner.c"
yy480:
		YYDEBUG(480, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'G') goto yy532;
		if (yych == 'g') goto yy532;
		goto yy82;
yy481:
		YYDEBUG(481, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(482, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy481;
			goto yy82;
		} else {
			if (yych <= ' ') goto yy481;
			if (yych == ')') goto yy538;
			goto yy82;
		}
yy483:
		YYDEBUG(483, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy396;
		if (yych == '\r') goto yy398;
		goto yy82;
yy484:
		YYDEBUG(484, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy540;
		if (yych == 'c') goto yy540;
		goto yy44;
yy485:
		YYDEBUG(485, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy541;
		if (yych == 'l') goto yy541;
		goto yy44;
yy486:
		YYDEBUG(486, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy542;
		if (yych == 'u') goto yy542;
		goto yy44;
yy487:
		YYDEBUG(487, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy543;
		if (yych == 'e') goto yy543;
		goto yy44;
yy488:
		YYDEBUG(488, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy545;
		if (yych == 't') goto yy545;
		goto yy44;
yy489:
		YYDEBUG(489, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(490, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1311 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ELSEIF);
}
#line 5387 "Zend/zend_language_scanner.c"
yy491:
		YYDEBUG(491, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy547;
		if (yych == 'l') goto yy547;
		goto yy44;
yy492:
		YYDEBUG(492, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '^') {
			if (yych <= '@') {
				if (yych <= '/') goto yy493;
				if (yych <= '9') goto yy43;
			} else {
				if (yych == 'E') goto yy548;
				if (yych <= 'Z') goto yy43;
			}
		} else {
			if (yych <= 'd') {
				if (yych != '`') goto yy43;
			} else {
				if (yych <= 'e') goto yy548;
				if (yych <= 'z') goto yy43;
				if (yych >= 0x80) goto yy43;
			}
		}
yy493:
		YYDEBUG(493, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1339 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ENDFOR);
}
#line 5421 "Zend/zend_language_scanner.c"
yy494:
		YYDEBUG(494, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy549;
		if (yych == 't') goto yy549;
		goto yy44;
yy495:
		YYDEBUG(495, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy550;
		if (yych == 'l') goto yy550;
		goto yy44;
yy496:
		YYDEBUG(496, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy551;
		if (yych == 's') goto yy551;
		goto yy44;
yy497:
		YYDEBUG(497, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy553;
		if (yych == 'y') goto yy553;
		goto yy44;
yy498:
		YYDEBUG(498, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy555;
		if (yych == 'h') goto yy555;
		goto yy44;
yy499:
		YYDEBUG(499, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy557;
		if (yych == 'o') goto yy557;
		goto yy44;
yy500:
		YYDEBUG(500, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(501, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1535 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_GLOBAL);
}
#line 5470 "Zend/zend_language_scanner.c"
yy502:
		YYDEBUG(502, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy558;
		if (yych == 'e') goto yy558;
		goto yy44;
yy503:
		YYDEBUG(503, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy559;
		if (yych == 'e') goto yy559;
		goto yy44;
yy504:
		YYDEBUG(504, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy561;
		if (yych == 'c') goto yy561;
		goto yy44;
yy505:
		YYDEBUG(505, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy562;
		if (yych == 'd') goto yy562;
		goto yy44;
yy506:
		YYDEBUG(506, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy563;
		if (yych == 'a') goto yy563;
		goto yy44;
yy507:
		YYDEBUG(507, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy564;
		if (yych == 'a') goto yy564;
		goto yy44;
yy508:
		YYDEBUG(508, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy565;
		if (yych == 'e') goto yy565;
		goto yy44;
yy509:
		YYDEBUG(509, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy567;
		if (yych == 't') goto yy567;
		goto yy44;
yy510:
		YYDEBUG(510, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(511, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1571 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_PUBLIC);
}
#line 5531 "Zend/zend_language_scanner.c"
yy512:
		YYDEBUG(512, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy568;
		if (yych == 'e') goto yy568;
		goto yy44;
yy513:
		YYDEBUG(513, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(514, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1277 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_RETURN);
}
#line 5550 "Zend/zend_language_scanner.c"
yy515:
		YYDEBUG(515, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(516, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1551 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_STATIC);
}
#line 5563 "Zend/zend_language_scanner.c"
yy517:
		YYDEBUG(517, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(518, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1367 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_SWITCH);
}
#line 5576 "Zend/zend_language_scanner.c"
yy519:
		YYDEBUG(519, *YYCURSOR);
		++YYCURSOR;
		YYFILL(5);
		yych = *YYCURSOR;
		YYDEBUG(520, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych <= '\n') {
				if (yych <= 0x08) goto yy82;
				goto yy519;
			} else {
				if (yych == '\r') goto yy519;
				goto yy82;
			}
		} else {
			if (yych <= 'F') {
				if (yych <= ' ') goto yy519;
				if (yych <= 'E') goto yy82;
				goto yy570;
			} else {
				if (yych == 'f') goto yy570;
				goto yy82;
			}
		}
yy521:
		YYDEBUG(521, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy571;
		if (yych == 's') goto yy571;
		goto yy44;
yy522:
		YYDEBUG(522, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy572;
		goto yy44;
yy523:
		YYDEBUG(523, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy574;
		goto yy44;
yy524:
		YYDEBUG(524, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy575;
		if (yych == 't') goto yy575;
		goto yy44;
yy525:
		YYDEBUG(525, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy576;
		goto yy44;
yy526:
		YYDEBUG(526, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy577;
		goto yy44;
yy527:
		YYDEBUG(527, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy578;
		if (yych == 'o') goto yy578;
		goto yy44;
yy528:
		YYDEBUG(528, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy579;
		if (yych == 's') goto yy579;
		goto yy44;
yy529:
		YYDEBUG(529, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy580;
		if (yych == 't') goto yy580;
		goto yy44;
yy530:
		YYDEBUG(530, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(531, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1487 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ARRAY_CAST);
}
#line 5660 "Zend/zend_language_scanner.c"
yy532:
		YYDEBUG(532, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(533, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy532;
			goto yy82;
		} else {
			if (yych <= ' ') goto yy532;
			if (yych == ')') goto yy581;
			goto yy82;
		}
yy534:
		YYDEBUG(534, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy470;
		if (yych == 'n') goto yy470;
		goto yy82;
yy535:
		YYDEBUG(535, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy382;
		if (yych == 'r') goto yy382;
		goto yy82;
yy536:
		YYDEBUG(536, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(537, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy536;
			goto yy82;
		} else {
			if (yych <= ' ') goto yy536;
			if (yych == ')') goto yy583;
			goto yy82;
		}
yy538:
		YYDEBUG(538, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(539, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1499 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_UNSET_CAST);
}
#line 5710 "Zend/zend_language_scanner.c"
yy540:
		YYDEBUG(540, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy585;
		if (yych == 't') goto yy585;
		goto yy44;
yy541:
		YYDEBUG(541, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy587;
		if (yych == 'e') goto yy587;
		goto yy44;
yy542:
		YYDEBUG(542, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy589;
		if (yych == 'e') goto yy589;
		goto yy44;
yy543:
		YYDEBUG(543, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(544, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1351 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_DECLARE);
}
#line 5741 "Zend/zend_language_scanner.c"
yy545:
		YYDEBUG(545, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(546, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1379 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_DEFAULT);
}
#line 5754 "Zend/zend_language_scanner.c"
yy547:
		YYDEBUG(547, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy591;
		if (yych == 'a') goto yy591;
		goto yy44;
yy548:
		YYDEBUG(548, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy592;
		if (yych == 'a') goto yy592;
		goto yy44;
yy549:
		YYDEBUG(549, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy593;
		if (yych == 'c') goto yy593;
		goto yy44;
yy550:
		YYDEBUG(550, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy594;
		if (yych == 'e') goto yy594;
		goto yy44;
yy551:
		YYDEBUG(551, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(552, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1415 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_EXTENDS);
}
#line 5791 "Zend/zend_language_scanner.c"
yy553:
		YYDEBUG(553, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(554, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1299 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_FINALLY);
}
#line 5804 "Zend/zend_language_scanner.c"
yy555:
		YYDEBUG(555, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(556, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1343 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_FOREACH);
}
#line 5817 "Zend/zend_language_scanner.c"
yy557:
		YYDEBUG(557, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy596;
		if (yych == 'n') goto yy596;
		goto yy44;
yy558:
		YYDEBUG(558, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy598;
		if (yych == 'n') goto yy598;
		goto yy44;
yy559:
		YYDEBUG(559, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy43;
			} else {
				if (yych <= '@') goto yy560;
				if (yych <= 'Z') goto yy43;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy599;
			} else {
				if (yych <= 'z') goto yy43;
				if (yych >= 0x80) goto yy43;
			}
		}
yy560:
		YYDEBUG(560, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1507 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_INCLUDE);
}
#line 5855 "Zend/zend_language_scanner.c"
yy561:
		YYDEBUG(561, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy600;
		if (yych == 'e') goto yy600;
		goto yy44;
yy562:
		YYDEBUG(562, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy601;
		if (yych == 'o') goto yy601;
		goto yy44;
yy563:
		YYDEBUG(563, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy602;
		if (yych == 'c') goto yy602;
		goto yy44;
yy564:
		YYDEBUG(564, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy603;
		if (yych == 'c') goto yy603;
		goto yy44;
yy565:
		YYDEBUG(565, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(566, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1563 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_PRIVATE);
}
#line 5892 "Zend/zend_language_scanner.c"
yy567:
		YYDEBUG(567, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy604;
		if (yych == 'e') goto yy604;
		goto yy44;
yy568:
		YYDEBUG(568, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy43;
			} else {
				if (yych <= '@') goto yy569;
				if (yych <= 'Z') goto yy43;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy605;
			} else {
				if (yych <= 'z') goto yy43;
				if (yych >= 0x80) goto yy43;
			}
		}
yy569:
		YYDEBUG(569, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1515 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_REQUIRE);
}
#line 5924 "Zend/zend_language_scanner.c"
yy570:
		YYDEBUG(570, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy606;
		if (yych == 'r') goto yy606;
		goto yy82;
yy571:
		YYDEBUG(571, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy607;
		goto yy44;
yy572:
		YYDEBUG(572, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(573, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1918 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_DIR);
}
#line 5948 "Zend/zend_language_scanner.c"
yy574:
		YYDEBUG(574, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy608;
		goto yy44;
yy575:
		YYDEBUG(575, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy610;
		if (yych == 'i') goto yy610;
		goto yy44;
yy576:
		YYDEBUG(576, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy611;
		if (yych == 'c') goto yy611;
		goto yy44;
yy577:
		YYDEBUG(577, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy612;
		goto yy44;
yy578:
		YYDEBUG(578, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy614;
		if (yych == 'd') goto yy614;
		goto yy44;
yy579:
		YYDEBUG(579, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy615;
		if (yych == 'p') goto yy615;
		goto yy44;
yy580:
		YYDEBUG(580, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy616;
		goto yy44;
yy581:
		YYDEBUG(581, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(582, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1483 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_STRING_CAST);
}
#line 5997 "Zend/zend_language_scanner.c"
yy583:
		YYDEBUG(583, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(584, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1491 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_OBJECT_CAST);
}
#line 6007 "Zend/zend_language_scanner.c"
yy585:
		YYDEBUG(585, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(586, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1555 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ABSTRACT);
}
#line 6020 "Zend/zend_language_scanner.c"
yy587:
		YYDEBUG(587, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(588, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1591 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_CALLABLE);
}
#line 6033 "Zend/zend_language_scanner.c"
yy589:
		YYDEBUG(589, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(590, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1387 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_CONTINUE);
}
#line 6046 "Zend/zend_language_scanner.c"
yy591:
		YYDEBUG(591, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy617;
		if (yych == 'r') goto yy617;
		goto yy44;
yy592:
		YYDEBUG(592, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy618;
		if (yych == 'c') goto yy618;
		goto yy44;
yy593:
		YYDEBUG(593, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy619;
		if (yych == 'h') goto yy619;
		goto yy44;
yy594:
		YYDEBUG(594, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(595, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1327 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ENDWHILE);
}
#line 6077 "Zend/zend_language_scanner.c"
yy596:
		YYDEBUG(596, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(597, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1269 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_FUNCTION);
}
#line 6090 "Zend/zend_language_scanner.c"
yy598:
		YYDEBUG(598, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy621;
		if (yych == 't') goto yy621;
		goto yy44;
yy599:
		YYDEBUG(599, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy622;
		if (yych == 'o') goto yy622;
		goto yy44;
yy600:
		YYDEBUG(600, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy623;
		if (yych == 'o') goto yy623;
		goto yy44;
yy601:
		YYDEBUG(601, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy624;
		if (yych == 'f') goto yy624;
		goto yy44;
yy602:
		YYDEBUG(602, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy626;
		if (yych == 'e') goto yy626;
		goto yy44;
yy603:
		YYDEBUG(603, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy628;
		if (yych == 'e') goto yy628;
		goto yy44;
yy604:
		YYDEBUG(604, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy630;
		if (yych == 'd') goto yy630;
		goto yy44;
yy605:
		YYDEBUG(605, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy632;
		if (yych == 'o') goto yy632;
		goto yy44;
yy606:
		YYDEBUG(606, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy633;
		if (yych == 'o') goto yy633;
		goto yy82;
yy607:
		YYDEBUG(607, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy634;
		goto yy44;
yy608:
		YYDEBUG(608, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(609, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1914 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_FILE);
}
#line 6162 "Zend/zend_language_scanner.c"
yy610:
		YYDEBUG(610, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy636;
		if (yych == 'o') goto yy636;
		goto yy44;
yy611:
		YYDEBUG(611, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy637;
		if (yych == 'o') goto yy637;
		goto yy44;
yy612:
		YYDEBUG(612, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(613, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1910 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_LINE);
}
#line 6187 "Zend/zend_language_scanner.c"
yy614:
		YYDEBUG(614, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy638;
		goto yy44;
yy615:
		YYDEBUG(615, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy639;
		if (yych == 'a') goto yy639;
		goto yy44;
yy616:
		YYDEBUG(616, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy640;
		goto yy44;
yy617:
		YYDEBUG(617, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy642;
		if (yych == 'e') goto yy642;
		goto yy44;
yy618:
		YYDEBUG(618, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy644;
		if (yych == 'h') goto yy644;
		goto yy44;
yy619:
		YYDEBUG(619, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(620, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1371 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ENDSWITCH);
}
#line 6228 "Zend/zend_language_scanner.c"
yy621:
		YYDEBUG(621, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy646;
		if (yych == 's') goto yy646;
		goto yy44;
yy622:
		YYDEBUG(622, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy648;
		if (yych == 'n') goto yy648;
		goto yy44;
yy623:
		YYDEBUG(623, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy649;
		if (yych == 'f') goto yy649;
		goto yy44;
yy624:
		YYDEBUG(624, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(625, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1531 "Zend/zend_language_scanner.l"
		{
    RETURN_TOKEN(T_INSTEADOF);
}
#line 6259 "Zend/zend_language_scanner.c"
yy626:
		YYDEBUG(626, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(627, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1407 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_INTERFACE);
}
#line 6272 "Zend/zend_language_scanner.c"
yy628:
		YYDEBUG(628, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(629, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1523 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_NAMESPACE);
}
#line 6285 "Zend/zend_language_scanner.c"
yy630:
		YYDEBUG(630, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(631, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1567 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_PROTECTED);
}
#line 6298 "Zend/zend_language_scanner.c"
yy632:
		YYDEBUG(632, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy651;
		if (yych == 'n') goto yy651;
		goto yy44;
yy633:
		YYDEBUG(633, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy652;
		if (yych == 'm') goto yy652;
		goto yy82;
yy634:
		YYDEBUG(634, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(635, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1894 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_CLASS_C);
}
#line 6323 "Zend/zend_language_scanner.c"
yy636:
		YYDEBUG(636, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy653;
		if (yych == 'n') goto yy653;
		goto yy44;
yy637:
		YYDEBUG(637, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy654;
		if (yych == 'm') goto yy654;
		goto yy44;
yy638:
		YYDEBUG(638, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy655;
		goto yy44;
yy639:
		YYDEBUG(639, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy657;
		if (yych == 'c') goto yy657;
		goto yy44;
yy640:
		YYDEBUG(640, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(641, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1898 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_TRAIT_C);
}
#line 6359 "Zend/zend_language_scanner.c"
yy642:
		YYDEBUG(642, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(643, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1355 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ENDDECLARE);
}
#line 6372 "Zend/zend_language_scanner.c"
yy644:
		YYDEBUG(644, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(645, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1347 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ENDFOREACH);
}
#line 6385 "Zend/zend_language_scanner.c"
yy646:
		YYDEBUG(646, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(647, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1419 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_IMPLEMENTS);
}
#line 6398 "Zend/zend_language_scanner.c"
yy648:
		YYDEBUG(648, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy658;
		if (yych == 'c') goto yy658;
		goto yy44;
yy649:
		YYDEBUG(649, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(650, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1359 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_INSTANCEOF);
}
#line 6417 "Zend/zend_language_scanner.c"
yy651:
		YYDEBUG(651, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy659;
		if (yych == 'c') goto yy659;
		goto yy44;
yy652:
		YYDEBUG(652, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '^') {
			if (yych <= '9') {
				if (yych <= '/') goto yy660;
				goto yy82;
			} else {
				if (yych <= '@') goto yy660;
				if (yych <= 'Z') goto yy82;
				goto yy660;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy82;
				goto yy660;
			} else {
				if (yych <= 'z') goto yy82;
				if (yych <= 0x7F) goto yy660;
				goto yy82;
			}
		}
yy653:
		YYDEBUG(653, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy662;
		goto yy44;
yy654:
		YYDEBUG(654, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy663;
		if (yych == 'p') goto yy663;
		goto yy44;
yy655:
		YYDEBUG(655, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(656, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1906 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_METHOD_C);
}
#line 6469 "Zend/zend_language_scanner.c"
yy657:
		YYDEBUG(657, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy664;
		if (yych == 'e') goto yy664;
		goto yy44;
yy658:
		YYDEBUG(658, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy665;
		if (yych == 'e') goto yy665;
		goto yy44;
yy659:
		YYDEBUG(659, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy667;
		if (yych == 'e') goto yy667;
		goto yy44;
yy660:
		YYDEBUG(660, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(661, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1281 "Zend/zend_language_scanner.l"
		{
	yyless(yyleng - 1);
	HANDLE_NEWLINES(yytext, yyleng);
	RETURN_TOKEN(T_YIELD_FROM);
}
#line 6499 "Zend/zend_language_scanner.c"
yy662:
		YYDEBUG(662, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy669;
		goto yy44;
yy663:
		YYDEBUG(663, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy671;
		if (yych == 'i') goto yy671;
		goto yy44;
yy664:
		YYDEBUG(664, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy672;
		goto yy44;
yy665:
		YYDEBUG(665, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(666, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1511 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_INCLUDE_ONCE);
}
#line 6528 "Zend/zend_language_scanner.c"
yy667:
		YYDEBUG(667, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(668, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1519 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_REQUIRE_ONCE);
}
#line 6541 "Zend/zend_language_scanner.c"
yy669:
		YYDEBUG(669, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(670, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1902 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_FUNC_C);
}
#line 6554 "Zend/zend_language_scanner.c"
yy671:
		YYDEBUG(671, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy673;
		if (yych == 'l') goto yy673;
		goto yy44;
yy672:
		YYDEBUG(672, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy674;
		goto yy44;
yy673:
		YYDEBUG(673, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy676;
		if (yych == 'e') goto yy676;
		goto yy44;
yy674:
		YYDEBUG(674, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(675, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1922 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_NS_C);
}
#line 6584 "Zend/zend_language_scanner.c"
yy676:
		YYDEBUG(676, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy677;
		if (yych != 'r') goto yy44;
yy677:
		YYDEBUG(677, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(678, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1547 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_HALT_COMPILER);
}
#line 6602 "Zend/zend_language_scanner.c"
	}
/* *********************************** */
yyc_ST_LOOKING_FOR_PROPERTY:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,  64,  64,   0,   0,  64,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 64,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(679, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy683;
		}
		if (yych <= '^') {
			if (yych <= '-') {
				if (yych >= '-') goto yy686;
			} else {
				if (yych <= '@') goto yy681;
				if (yych <= 'Z') goto yy687;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy687;
			} else {
				if (yych <= 'z') goto yy687;
				if (yych >= 0x80) goto yy687;
			}
		}
yy681:
		YYDEBUG(681, *YYCURSOR);
		++YYCURSOR;
yy682:
		YYDEBUG(682, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1441 "Zend/zend_language_scanner.l"
		{
	yyless(0);
	yy_pop_state();
	goto restart;
}
#line 6674 "Zend/zend_language_scanner.c"
yy683:
		YYDEBUG(683, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(684, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy683;
		}
		YYDEBUG(685, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1428 "Zend/zend_language_scanner.l"
		{
	goto return_whitespace;
}
#line 6690 "Zend/zend_language_scanner.c"
yy686:
		YYDEBUG(686, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy690;
		goto yy682;
yy687:
		YYDEBUG(687, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(688, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy687;
		}
		YYDEBUG(689, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1436 "Zend/zend_language_scanner.l"
		{
	yy_pop_state();
	RETURN_TOKEN_WITH_STR(T_STRING, 0);
}
#line 6712 "Zend/zend_language_scanner.c"
yy690:
		YYDEBUG(690, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(691, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1432 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_OBJECT_OPERATOR);
}
#line 6722 "Zend/zend_language_scanner.c"
	}
/* *********************************** */
yyc_ST_BACKQUOTE:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(692, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych == '$') goto yy696;
		} else {
			if (yych <= '`') goto yy697;
			if (yych == '{') goto yy699;
		}
		YYDEBUG(694, *YYCURSOR);
		++YYCURSOR;
yy695:
		YYDEBUG(695, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2494 "Zend/zend_language_scanner.l"
		{
	if (YYCURSOR > YYLIMIT) {
		RETURN_TOKEN(END);
	}
	if (yytext[0] == '\\' && YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '`':
				break;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	if (EXPECTED(zend_scan_escape_string(zendlval, yytext, yyleng, '`') == SUCCESS)
	 || !PARSER_MODE()) {
		RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
	} else {
		RETURN_TOKEN(T_ERROR);
	}
}
#line 6820 "Zend/zend_language_scanner.c"
yy696:
		YYDEBUG(696, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy695;
			if (yych <= 'Z') goto yy700;
			if (yych <= '^') goto yy695;
			goto yy700;
		} else {
			if (yych <= 'z') {
				if (yych <= '`') goto yy695;
				goto yy700;
			} else {
				if (yych <= '{') goto yy703;
				if (yych <= 0x7F) goto yy695;
				goto yy700;
			}
		}
yy697:
		YYDEBUG(697, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(698, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2434 "Zend/zend_language_scanner.l"
		{
	BEGIN(ST_IN_SCRIPTING);
	RETURN_TOKEN('`');
}
#line 6849 "Zend/zend_language_scanner.c"
yy699:
		YYDEBUG(699, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy705;
		goto yy695;
yy700:
		YYDEBUG(700, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(701, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy700;
		}
		if (yych == '-') goto yy707;
		if (yych <= '@') goto yy702;
		if (yych <= '[') goto yy709;
yy702:
		YYDEBUG(702, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2023 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
#line 6874 "Zend/zend_language_scanner.c"
yy703:
		YYDEBUG(703, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(704, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1722 "Zend/zend_language_scanner.l"
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME);
	RETURN_TOKEN(T_DOLLAR_OPEN_CURLY_BRACES);
}
#line 6885 "Zend/zend_language_scanner.c"
yy705:
		YYDEBUG(705, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(706, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2422 "Zend/zend_language_scanner.l"
		{
	yy_push_state(ST_IN_SCRIPTING);
	yyless(1);
	RETURN_TOKEN(T_CURLY_OPEN);
}
#line 6897 "Zend/zend_language_scanner.c"
yy707:
		YYDEBUG(707, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy711;
yy708:
		YYDEBUG(708, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy702;
yy709:
		YYDEBUG(709, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(710, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2017 "Zend/zend_language_scanner.l"
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
#line 6917 "Zend/zend_language_scanner.c"
yy711:
		YYDEBUG(711, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy708;
			if (yych <= 'Z') goto yy712;
			if (yych <= '^') goto yy708;
		} else {
			if (yych <= '`') goto yy708;
			if (yych <= 'z') goto yy712;
			if (yych <= 0x7F) goto yy708;
		}
yy712:
		YYDEBUG(712, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(713, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2009 "Zend/zend_language_scanner.l"
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
#line 6941 "Zend/zend_language_scanner.c"
	}
/* *********************************** */
yyc_ST_DOUBLE_QUOTES:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(714, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '#') {
			if (yych == '"') goto yy718;
		} else {
			if (yych <= '$') goto yy720;
			if (yych == '{') goto yy721;
		}
		YYDEBUG(716, *YYCURSOR);
		++YYCURSOR;
yy717:
		YYDEBUG(717, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2440 "Zend/zend_language_scanner.l"
		{
	if (GET_DOUBLE_QUOTES_SCANNED_LENGTH()) {
		YYCURSOR += GET_DOUBLE_QUOTES_SCANNED_LENGTH() - 1;
		SET_DOUBLE_QUOTES_SCANNED_LENGTH(0);

		goto double_quotes_scan_done;
	}

	if (YYCURSOR > YYLIMIT) {
		RETURN_TOKEN(END);
	}
	if (yytext[0] == '\\' && YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				break;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

double_quotes_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	if (EXPECTED(zend_scan_escape_string(zendlval, yytext, yyleng, '"') == SUCCESS)
	 || !PARSER_MODE()) {
		RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
	} else {
		RETURN_TOKEN(T_ERROR);
	}
}
#line 7047 "Zend/zend_language_scanner.c"
yy718:
		YYDEBUG(718, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(719, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2429 "Zend/zend_language_scanner.l"
		{
	BEGIN(ST_IN_SCRIPTING);
	RETURN_TOKEN('"');
}
#line 7058 "Zend/zend_language_scanner.c"
yy720:
		YYDEBUG(720, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy717;
			if (yych <= 'Z') goto yy722;
			if (yych <= '^') goto yy717;
			goto yy722;
		} else {
			if (yych <= 'z') {
				if (yych <= '`') goto yy717;
				goto yy722;
			} else {
				if (yych <= '{') goto yy725;
				if (yych <= 0x7F) goto yy717;
				goto yy722;
			}
		}
yy721:
		YYDEBUG(721, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy727;
		goto yy717;
yy722:
		YYDEBUG(722, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(723, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy722;
		}
		if (yych == '-') goto yy729;
		if (yych <= '@') goto yy724;
		if (yych <= '[') goto yy731;
yy724:
		YYDEBUG(724, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2023 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
#line 7101 "Zend/zend_language_scanner.c"
yy725:
		YYDEBUG(725, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(726, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1722 "Zend/zend_language_scanner.l"
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME);
	RETURN_TOKEN(T_DOLLAR_OPEN_CURLY_BRACES);
}
#line 7112 "Zend/zend_language_scanner.c"
yy727:
		YYDEBUG(727, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(728, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2422 "Zend/zend_language_scanner.l"
		{
	yy_push_state(ST_IN_SCRIPTING);
	yyless(1);
	RETURN_TOKEN(T_CURLY_OPEN);
}
#line 7124 "Zend/zend_language_scanner.c"
yy729:
		YYDEBUG(729, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy733;
yy730:
		YYDEBUG(730, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy724;
yy731:
		YYDEBUG(731, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(732, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2017 "Zend/zend_language_scanner.l"
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
#line 7144 "Zend/zend_language_scanner.c"
yy733:
		YYDEBUG(733, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy730;
			if (yych <= 'Z') goto yy734;
			if (yych <= '^') goto yy730;
		} else {
			if (yych <= '`') goto yy730;
			if (yych <= 'z') goto yy734;
			if (yych <= 0x7F) goto yy730;
		}
yy734:
		YYDEBUG(734, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(735, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2009 "Zend/zend_language_scanner.l"
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
#line 7168 "Zend/zend_language_scanner.c"
	}
/* *********************************** */
yyc_ST_HEREDOC:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(736, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych == '$') goto yy740;
		if (yych == '{') goto yy741;
		YYDEBUG(738, *YYCURSOR);
		++YYCURSOR;
yy739:
		YYDEBUG(739, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2540 "Zend/zend_language_scanner.l"
		{
	zend_heredoc_label *heredoc_label = zend_ptr_stack_top(&SCNG(heredoc_label_stack));
	int newline = 0, indentation = 0, spacing = 0;

	if (YYCURSOR > YYLIMIT) {
		RETURN_TOKEN(END);
	}

	YYCURSOR--;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				indentation = spacing = 0;

				while (YYCURSOR < YYLIMIT && (*YYCURSOR == ' ' || *YYCURSOR == '\t')) {
					if (*YYCURSOR == '\t') {
						spacing |= HEREDOC_USING_TABS;
					} else {
						spacing |= HEREDOC_USING_SPACES;
					}
					++YYCURSOR;
					++indentation;
				}

				if (YYCURSOR == YYLIMIT) {
					yyleng = YYCURSOR - SCNG(yy_text);
					HANDLE_NEWLINES(yytext, yyleng);
					ZVAL_NULL(zendlval);
					RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
				}

				/* Check for ending label on the next line */
				if (IS_LABEL_START(*YYCURSOR) && heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, heredoc_label->label, heredoc_label->length)) {
					if (IS_LABEL_START(YYCURSOR[heredoc_label->length])) {
						continue;
					}

					if (spacing == (HEREDOC_USING_SPACES | HEREDOC_USING_TABS)) {
						zend_throw_exception(zend_ce_parse_error, "Invalid indentation - tabs and spaces cannot be mixed", 0);
					}

					/* newline before label will be subtracted from returned text, but
					 * yyleng/yytext will include it, for zend_highlight/strip, tokenizer, etc. */
					if (YYCURSOR[-indentation - 2] == '\r' && YYCURSOR[-indentation - 1] == '\n') {
						newline = 2; /* Windows newline */
					} else {
						newline = 1;
					}

					CG(increment_lineno) = 1; /* For newline before label */

					if (SCNG(heredoc_scan_ahead)) {
						SCNG(heredoc_indentation) = indentation;
						SCNG(heredoc_indentation_uses_spaces) = (spacing == HEREDOC_USING_SPACES);
					} else {
						YYCURSOR -= indentation;
					}

					BEGIN(ST_END_HEREDOC);

					goto heredoc_scan_done;
				}
				continue;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT && *YYCURSOR != '\n' && *YYCURSOR != '\r') {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

heredoc_scan_done:

	yyleng = YYCURSOR - SCNG(yy_text);
	ZVAL_STRINGL(zendlval, yytext, yyleng - newline);

	if (!SCNG(heredoc_scan_ahead) && !EG(exception) && PARSER_MODE()) {
		zend_bool newline_at_start = *(yytext - 1) == '\n' || *(yytext - 1) == '\r';
		zend_string *copy = Z_STR_P(zendlval);

		if (!strip_multiline_string_indentation(
				zendlval, heredoc_label->indentation, heredoc_label->indentation_uses_spaces,
				newline_at_start, newline != 0)) {
			RETURN_TOKEN(T_ERROR);
		}

		if (UNEXPECTED(zend_scan_escape_string(zendlval, ZSTR_VAL(copy), ZSTR_LEN(copy), 0) != SUCCESS)) {
			zend_string_efree(copy);
			RETURN_TOKEN(T_ERROR);
		}

		zend_string_efree(copy);
	} else {
		HANDLE_NEWLINES(yytext, yyleng - newline);
	}

	RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
}
#line 7337 "Zend/zend_language_scanner.c"
yy740:
		YYDEBUG(740, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy739;
			if (yych <= 'Z') goto yy742;
			if (yych <= '^') goto yy739;
			goto yy742;
		} else {
			if (yych <= 'z') {
				if (yych <= '`') goto yy739;
				goto yy742;
			} else {
				if (yych <= '{') goto yy745;
				if (yych <= 0x7F) goto yy739;
				goto yy742;
			}
		}
yy741:
		YYDEBUG(741, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy747;
		goto yy739;
yy742:
		YYDEBUG(742, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(743, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy742;
		}
		if (yych == '-') goto yy749;
		if (yych <= '@') goto yy744;
		if (yych <= '[') goto yy751;
yy744:
		YYDEBUG(744, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2023 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
#line 7380 "Zend/zend_language_scanner.c"
yy745:
		YYDEBUG(745, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(746, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1722 "Zend/zend_language_scanner.l"
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME);
	RETURN_TOKEN(T_DOLLAR_OPEN_CURLY_BRACES);
}
#line 7391 "Zend/zend_language_scanner.c"
yy747:
		YYDEBUG(747, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(748, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2422 "Zend/zend_language_scanner.l"
		{
	yy_push_state(ST_IN_SCRIPTING);
	yyless(1);
	RETURN_TOKEN(T_CURLY_OPEN);
}
#line 7403 "Zend/zend_language_scanner.c"
yy749:
		YYDEBUG(749, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy753;
yy750:
		YYDEBUG(750, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy744;
yy751:
		YYDEBUG(751, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(752, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2017 "Zend/zend_language_scanner.l"
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
#line 7423 "Zend/zend_language_scanner.c"
yy753:
		YYDEBUG(753, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy750;
			if (yych <= 'Z') goto yy754;
			if (yych <= '^') goto yy750;
		} else {
			if (yych <= '`') goto yy750;
			if (yych <= 'z') goto yy754;
			if (yych <= 0x7F) goto yy750;
		}
yy754:
		YYDEBUG(754, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(755, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2009 "Zend/zend_language_scanner.l"
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
#line 7447 "Zend/zend_language_scanner.c"
	}
/* *********************************** */
yyc_ST_LOOKING_FOR_VARNAME:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(756, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy758;
			if (yych <= 'Z') goto yy760;
			if (yych >= '_') goto yy760;
		} else {
			if (yych <= '`') goto yy758;
			if (yych <= 'z') goto yy760;
			if (yych >= 0x80) goto yy760;
		}
yy758:
		YYDEBUG(758, *YYCURSOR);
		++YYCURSOR;
yy759:
		YYDEBUG(759, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1745 "Zend/zend_language_scanner.l"
		{
	yyless(0);
	yy_pop_state();
	yy_push_state(ST_IN_SCRIPTING);
	goto restart;
}
#line 7511 "Zend/zend_language_scanner.c"
yy760:
		YYDEBUG(760, *YYCURSOR);
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '_') {
			if (yych <= '@') {
				if (yych <= '/') goto yy759;
				if (yych <= '9') goto yy762;
				goto yy759;
			} else {
				if (yych <= '[') goto yy762;
				if (yych <= '^') goto yy759;
				goto yy762;
			}
		} else {
			if (yych <= '|') {
				if (yych <= '`') goto yy759;
				if (yych <= 'z') goto yy762;
				goto yy759;
			} else {
				if (yych <= '}') goto yy762;
				if (yych <= 0x7F) goto yy759;
				goto yy762;
			}
		}
yy761:
		YYDEBUG(761, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy762:
		YYDEBUG(762, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy761;
		}
		if (yych <= '@') goto yy763;
		if (yych <= '[') goto yy764;
		if (yych == '}') goto yy764;
yy763:
		YYDEBUG(763, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy759;
yy764:
		YYDEBUG(764, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(765, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1737 "Zend/zend_language_scanner.l"
		{
	yyless(yyleng - 1);
	yy_pop_state();
	yy_push_state(ST_IN_SCRIPTING);
	RETURN_TOKEN_WITH_STR(T_STRING_VARNAME, 0);
}
#line 7565 "Zend/zend_language_scanner.c"
	}
/* *********************************** */
yyc_ST_VAR_OFFSET:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			240, 240, 176, 176, 176, 176, 176, 176, 
			176, 176,   0,   0,   0,   0,   0,   0, 
			  0, 160, 160, 160, 160, 160, 160,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,   0,   0,   0,   0,  32, 
			  0, 160, 160, 160, 160, 160, 160,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,   0,   0,   0,   0,   0, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
		};
		YYDEBUG(766, *YYCURSOR);
		YYFILL(3);
		yych = *YYCURSOR;
		if (yych <= '0') {
			if (yych <= ' ') {
				if (yych <= '\f') {
					if (yych <= 0x08) goto yy768;
					if (yych <= '\n') goto yy770;
				} else {
					if (yych <= '\r') goto yy770;
					if (yych >= ' ') goto yy770;
				}
			} else {
				if (yych <= '$') {
					if (yych <= '"') goto yy772;
					if (yych <= '#') goto yy770;
					goto yy774;
				} else {
					if (yych == '\'') goto yy770;
					if (yych <= '/') goto yy772;
					goto yy775;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= 'Z') {
					if (yych <= '9') goto yy777;
					if (yych <= '@') goto yy772;
					goto yy779;
				} else {
					if (yych <= '[') goto yy772;
					if (yych <= '\\') goto yy770;
					goto yy782;
				}
			} else {
				if (yych <= '`') {
					if (yych == '_') goto yy779;
					goto yy772;
				} else {
					if (yych <= 'z') goto yy779;
					if (yych <= '~') goto yy772;
					if (yych >= 0x80) goto yy779;
				}
			}
		}
yy768:
		YYDEBUG(768, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(769, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2749 "Zend/zend_language_scanner.l"
		{
	if (YYCURSOR > YYLIMIT) {
		RETURN_TOKEN(END);
	}

	zend_error(E_COMPILE_WARNING,"Unexpected character in input:  '%c' (ASCII=%d) state=%d", yytext[0], yytext[0], YYSTATE);
	goto restart;
}
#line 7663 "Zend/zend_language_scanner.c"
yy770:
		YYDEBUG(770, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(771, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2037 "Zend/zend_language_scanner.l"
		{
	/* Invalid rule to return a more explicit parse error with proper line number */
	yyless(0);
	yy_pop_state();
	ZVAL_NULL(zendlval);
	RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
}
#line 7677 "Zend/zend_language_scanner.c"
yy772:
		YYDEBUG(772, *YYCURSOR);
		++YYCURSOR;
yy773:
		YYDEBUG(773, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2032 "Zend/zend_language_scanner.l"
		{
	/* Only '[' or '-' can be valid, but returning other tokens will allow a more explicit parse error */
	RETURN_TOKEN(yytext[0]);
}
#line 7689 "Zend/zend_language_scanner.c"
yy774:
		YYDEBUG(774, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy773;
			if (yych <= 'Z') goto yy784;
			if (yych <= '^') goto yy773;
			goto yy784;
		} else {
			if (yych <= '`') goto yy773;
			if (yych <= 'z') goto yy784;
			if (yych <= 0x7F) goto yy773;
			goto yy784;
		}
yy775:
		YYDEBUG(775, *YYCURSOR);
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'W') {
			if (yych <= '9') {
				if (yych >= '0') goto yy787;
			} else {
				if (yych == 'B') goto yy790;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= 'X') goto yy792;
				if (yych >= 'b') goto yy790;
			} else {
				if (yych == 'x') goto yy792;
			}
		}
yy776:
		YYDEBUG(776, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1860 "Zend/zend_language_scanner.l"
		{ /* Offset could be treated as a long */
	if (yyleng < MAX_LENGTH_OF_LONG - 1 || (yyleng == MAX_LENGTH_OF_LONG - 1 && strcmp(yytext, long_min_digits) < 0)) {
		char *end;
		errno = 0;
		ZVAL_LONG(zendlval, ZEND_STRTOL(yytext, &end, 10));
		if (errno == ERANGE) {
			goto string;
		}
		ZEND_ASSERT(end == yytext + yyleng);
	} else {
string:
		ZVAL_STRINGL(zendlval, yytext, yyleng);
	}
	RETURN_TOKEN_WITH_VAL(T_NUM_STRING);
}
#line 7740 "Zend/zend_language_scanner.c"
yy777:
		YYDEBUG(777, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(778, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy777;
		}
		goto yy776;
yy779:
		YYDEBUG(779, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(780, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy779;
		}
		YYDEBUG(781, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2045 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN_WITH_STR(T_STRING, 0);
}
#line 7766 "Zend/zend_language_scanner.c"
yy782:
		YYDEBUG(782, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(783, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2027 "Zend/zend_language_scanner.l"
		{
	yy_pop_state();
	RETURN_TOKEN(']');
}
#line 7777 "Zend/zend_language_scanner.c"
yy784:
		YYDEBUG(784, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(785, *YYCURSOR);
		if (yych <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy784;
			} else {
				if (yych <= '@') goto yy786;
				if (yych <= 'Z') goto yy784;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy784;
			} else {
				if (yych <= 'z') goto yy784;
				if (yych >= 0x80) goto yy784;
			}
		}
yy786:
		YYDEBUG(786, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2023 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
#line 7806 "Zend/zend_language_scanner.c"
yy787:
		YYDEBUG(787, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(788, *YYCURSOR);
		if (yych <= '/') goto yy789;
		if (yych <= '9') goto yy787;
yy789:
		YYDEBUG(789, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1876 "Zend/zend_language_scanner.l"
		{ /* Offset must be treated as a string */
	if (yyleng == 1) {
		ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR((zend_uchar)*(yytext)));
	} else {
		ZVAL_STRINGL(zendlval, yytext, yyleng);
	}
	RETURN_TOKEN_WITH_VAL(T_NUM_STRING);
}
#line 7827 "Zend/zend_language_scanner.c"
yy790:
		YYDEBUG(790, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy793;
		}
yy791:
		YYDEBUG(791, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy776;
yy792:
		YYDEBUG(792, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy795;
		}
		goto yy791;
yy793:
		YYDEBUG(793, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(794, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy793;
		}
		goto yy789;
yy795:
		YYDEBUG(795, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(796, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy795;
		}
		goto yy789;
	}
/* *********************************** */
yyc_INITIAL:
	YYDEBUG(797, *YYCURSOR);
	YYFILL(7);
	yych = *YYCURSOR;
	if (yych == '<') goto yy801;
	YYDEBUG(799, *YYCURSOR);
	++YYCURSOR;
yy800:
	YYDEBUG(800, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
#line 1958 "Zend/zend_language_scanner.l"
	{
	if (YYCURSOR > YYLIMIT) {
		RETURN_TOKEN(END);
	}

inline_char_handler:

	while (1) {
		YYCTYPE *ptr = memchr(YYCURSOR, '<', YYLIMIT - YYCURSOR);

		YYCURSOR = ptr ? ptr + 1 : YYLIMIT;

		if (YYCURSOR >= YYLIMIT) {
			break;
		}

		if (*YYCURSOR == '?') {
			if (CG(short_tags) || !strncasecmp((char*)YYCURSOR + 1, "php", 3) || (*(YYCURSOR + 1) == '=')) { /* Assume [ \t\n\r] follows "php" */

				YYCURSOR--;
				break;
			}
		}
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	if (SCNG(output_filter)) {
		size_t readsize;
		char *s = NULL;
		size_t sz = 0;
		// TODO: avoid reallocation ???
		readsize = SCNG(output_filter)((unsigned char **)&s, &sz, (unsigned char *)yytext, (size_t)yyleng);
		ZVAL_STRINGL(zendlval, s, sz);
		efree(s);
		if (readsize < yyleng) {
			yyless(readsize);
		}
	} else if (yyleng == 1) {
		ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR((zend_uchar)*yytext));
	} else {
		ZVAL_STRINGL(zendlval, yytext, yyleng);
	}
	HANDLE_NEWLINES(yytext, yyleng);
	RETURN_TOKEN_WITH_VAL(T_INLINE_HTML);
}
#line 7924 "Zend/zend_language_scanner.c"
yy801:
	YYDEBUG(801, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '?') goto yy800;
	YYDEBUG(802, *YYCURSOR);
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych == '=') goto yy804;
	} else {
		if (yych <= 'P') goto yy806;
		if (yych == 'p') goto yy806;
	}
yy803:
	YYDEBUG(803, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
#line 1946 "Zend/zend_language_scanner.l"
	{
	if (CG(short_tags)) {
		BEGIN(ST_IN_SCRIPTING);
		if (PARSER_MODE()) {
			SKIP_TOKEN(T_OPEN_TAG);
		}
		RETURN_TOKEN(T_OPEN_TAG);
	} else {
		goto inline_char_handler;
	}
}
#line 7952 "Zend/zend_language_scanner.c"
yy804:
	YYDEBUG(804, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(805, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
#line 1927 "Zend/zend_language_scanner.l"
	{
	BEGIN(ST_IN_SCRIPTING);
	if (PARSER_MODE()) {
		RETURN_TOKEN(T_ECHO);
	}
	RETURN_TOKEN(T_OPEN_TAG_WITH_ECHO);
}
#line 7966 "Zend/zend_language_scanner.c"
yy806:
	YYDEBUG(806, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy808;
	if (yych == 'h') goto yy808;
yy807:
	YYDEBUG(807, *YYCURSOR);
	YYCURSOR = YYMARKER;
	goto yy803;
yy808:
	YYDEBUG(808, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy809;
	if (yych != 'p') goto yy807;
yy809:
	YYDEBUG(809, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\f') {
		if (yych <= 0x08) goto yy807;
		if (yych >= '\v') goto yy807;
	} else {
		if (yych <= '\r') goto yy812;
		if (yych != ' ') goto yy807;
	}
yy810:
	YYDEBUG(810, *YYCURSOR);
	++YYCURSOR;
yy811:
	YYDEBUG(811, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
#line 1936 "Zend/zend_language_scanner.l"
	{
	HANDLE_NEWLINE(yytext[yyleng-1]);
	BEGIN(ST_IN_SCRIPTING);
	if (PARSER_MODE()) {
		SKIP_TOKEN(T_OPEN_TAG);
	}
	RETURN_TOKEN(T_OPEN_TAG);
}
#line 8006 "Zend/zend_language_scanner.c"
yy812:
	YYDEBUG(812, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\n') goto yy810;
	goto yy811;
/* *********************************** */
yyc_ST_END_HEREDOC:
	YYDEBUG(813, *YYCURSOR);
	YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(815, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(816, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
#line 2408 "Zend/zend_language_scanner.l"
	{
	zend_heredoc_label *heredoc_label = zend_ptr_stack_pop(&SCNG(heredoc_label_stack));

	yyleng = heredoc_label->indentation + heredoc_label->length;
	YYCURSOR += yyleng - 1;

	heredoc_label_dtor(heredoc_label);
	efree(heredoc_label);

	BEGIN(ST_IN_SCRIPTING);
	RETURN_TOKEN(T_END_HEREDOC);
}
#line 8034 "Zend/zend_language_scanner.c"
/* *********************************** */
yyc_ST_NOWDOC:
	YYDEBUG(817, *YYCURSOR);
	YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(819, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(820, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
#line 2661 "Zend/zend_language_scanner.l"
	{
	zend_heredoc_label *heredoc_label = zend_ptr_stack_top(&SCNG(heredoc_label_stack));
	int newline = 0, indentation = 0, spacing = -1;

	if (YYCURSOR > YYLIMIT) {
		RETURN_TOKEN(END);
	}

	YYCURSOR--;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				indentation = spacing = 0;

				while (YYCURSOR < YYLIMIT && (*YYCURSOR == ' ' || *YYCURSOR == '\t')) {
					if (*YYCURSOR == '\t') {
						spacing |= HEREDOC_USING_TABS;
					} else {
						spacing |= HEREDOC_USING_SPACES;
					}
					++YYCURSOR;
					++indentation;
				}

				if (YYCURSOR == YYLIMIT) {
					yyleng = YYCURSOR - SCNG(yy_text);
					HANDLE_NEWLINES(yytext, yyleng);
					ZVAL_NULL(zendlval);
					RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
				}

				/* Check for ending label on the next line */
				if (IS_LABEL_START(*YYCURSOR) && heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, heredoc_label->label, heredoc_label->length)) {
					if (IS_LABEL_START(YYCURSOR[heredoc_label->length])) {
						continue;
					}

					if (spacing == (HEREDOC_USING_SPACES | HEREDOC_USING_TABS)) {
						zend_throw_exception(zend_ce_parse_error, "Invalid indentation - tabs and spaces cannot be mixed", 0);
					}

					/* newline before label will be subtracted from returned text, but
					 * yyleng/yytext will include it, for zend_highlight/strip, tokenizer, etc. */
					if (YYCURSOR[-indentation - 2] == '\r' && YYCURSOR[-indentation - 1] == '\n') {
						newline = 2; /* Windows newline */
					} else {
						newline = 1;
					}

					CG(increment_lineno) = 1; /* For newline before label */

					YYCURSOR -= indentation;
					heredoc_label->indentation = indentation;

					BEGIN(ST_END_HEREDOC);

					goto nowdoc_scan_done;
				}
				/* fall through */
			default:
				continue;
		}
	}

nowdoc_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);
	ZVAL_STRINGL(zendlval, yytext, yyleng - newline);

	if (!EG(exception) && spacing != -1 && PARSER_MODE()) {
		zend_bool newline_at_start = *(yytext - 1) == '\n' || *(yytext - 1) == '\r';
		if (!strip_multiline_string_indentation(
				zendlval, indentation, spacing == HEREDOC_USING_SPACES,
				newline_at_start, newline != 0)) {
			RETURN_TOKEN(T_ERROR);
		}
	}

	HANDLE_NEWLINES(yytext, yyleng - newline);
	RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
}
#line 8131 "Zend/zend_language_scanner.c"
}
#line 2758 "Zend/zend_language_scanner.l"


emit_token_with_str:
	zend_copy_value(zendlval, (yytext + offset), (yyleng - offset));

emit_token_with_val:
	if (PARSER_MODE()) {
		ZEND_ASSERT(Z_TYPE_P(zendlval) != IS_UNDEF);
		elem->ast = zend_ast_create_zval_with_lineno(zendlval, start_line);
	}

emit_token:
	if (SCNG(on_event)) {
		SCNG(on_event)(ON_TOKEN, token, start_line, SCNG(on_event_context));
	}
	return token;

return_whitespace:
	HANDLE_NEWLINES(yytext, yyleng);
	if (SCNG(on_event)) {
		SCNG(on_event)(ON_TOKEN, T_WHITESPACE, start_line, SCNG(on_event_context));
	}
	if (PARSER_MODE()) {
		start_line = CG(zend_lineno);
		goto restart;
	} else {
		return T_WHITESPACE;
	}

skip_token:
	if (SCNG(on_event)) {
		SCNG(on_event)(ON_TOKEN, token, start_line, SCNG(on_event_context));
	}
	start_line = CG(zend_lineno);
	goto restart;
}
