--TEST--
Bug #66731: file: extensive backtraking
--SKIPIF--
<?php
if (!class_exists('finfo'))
	die('skip no fileinfo extension');
--FILE--
<?php
$fd = __DIR__.'/cve-2014-3538.data';

file_put_contents($fd,
  'try:' .
  str_repeat("\n", 1000000));

$fi = finfo_open(FILEINFO_NONE);
$t = microtime(true);
var_dump(finfo_file($fi, $fd));
$t = microtime(true) - $t;
finfo_close($fi);
if ($t < 1) {
	echo "Ok\n";
} else {
	printf("Failed, time=%.2f\n", $t);
}

?>
Done
--CLEAN--
<?php
@unlink(__DIR__.'/cve-2014-3538.data');
?>
--EXPECTF--
string(%d) "%s"
Ok
Done