/* Generated by re2c 0.15.3 on Tue Jul  4 19:43:56 2017 */
/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2015 Derick Rethans
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/* $Id$ */

#include "timelib.h"

#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <assert.h>

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif

#if defined(_MSC_VER)
# define strtoll(s, f, b) _atoi64(s)
#elif !defined(HAVE_STRTOLL)
# if defined(HAVE_ATOLL)
#  define strtoll(s, f, b) atoll(s)
# else
#  define strtoll(s, f, b) strtol(s, f, b)
# endif
#endif

#define TIMELIB_UNSET   -99999

#define TIMELIB_SECOND  1
#define TIMELIB_MINUTE  2
#define TIMELIB_HOUR    3
#define TIMELIB_DAY     4
#define TIMELIB_MONTH   5
#define TIMELIB_YEAR    6
#define TIMELIB_WEEKDAY 7
#define TIMELIB_SPECIAL 8

#define EOI      257
#define TIME     258
#define DATE     259

#define TIMELIB_XMLRPC_SOAP    260
#define TIMELIB_TIME12         261
#define TIMELIB_TIME24         262
#define TIMELIB_GNU_NOCOLON    263
#define TIMELIB_GNU_NOCOLON_TZ 264
#define TIMELIB_ISO_NOCOLON    265

#define TIMELIB_AMERICAN       266
#define TIMELIB_ISO_DATE       267
#define TIMELIB_DATE_FULL      268
#define TIMELIB_DATE_TEXT      269
#define TIMELIB_DATE_NOCOLON   270
#define TIMELIB_PG_YEARDAY     271
#define TIMELIB_PG_TEXT        272
#define TIMELIB_PG_REVERSE     273
#define TIMELIB_CLF            274
#define TIMELIB_DATE_NO_DAY    275
#define TIMELIB_SHORTDATE_WITH_TIME 276
#define TIMELIB_DATE_FULL_POINTED 277
#define TIMELIB_TIME24_WITH_ZONE 278
#define TIMELIB_ISO_WEEK       279
#define TIMELIB_LF_DAY_OF_MONTH 280
#define TIMELIB_WEEK_DAY_OF_MONTH 281

#define TIMELIB_TIMEZONE       300
#define TIMELIB_AGO            301

#define TIMELIB_RELATIVE       310

#define TIMELIB_ERROR          999

/* Some compilers like AIX, defines uchar in sys/types.h */
#undef uchar
typedef unsigned char uchar;

#define   BSIZE	   8192

#define   YYCTYPE      uchar
#define   YYCURSOR     cursor
#define   YYLIMIT      s->lim
#define   YYMARKER     s->ptr
#define   YYFILL(n)    return EOI;

#define   RET(i)       {s->cur = cursor; return i;}

#define timelib_string_free timelib_free

#define TIMELIB_HAVE_TIME() { if (s->time->have_time) { add_error(s, "Double time specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_time = 1; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->f = 0; } }
#define TIMELIB_UNHAVE_TIME() { s->time->have_time = 0; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->f = 0; }
#define TIMELIB_HAVE_DATE() { if (s->time->have_date) { add_error(s, "Double date specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_date = 1; } }
#define TIMELIB_UNHAVE_DATE() { s->time->have_date = 0; s->time->d = 0; s->time->m = 0; s->time->y = 0; }
#define TIMELIB_HAVE_RELATIVE() { s->time->have_relative = 1; }
#define TIMELIB_HAVE_WEEKDAY_RELATIVE() { s->time->have_relative = 1; s->time->relative.have_weekday_relative = 1; }
#define TIMELIB_HAVE_SPECIAL_RELATIVE() { s->time->have_relative = 1; s->time->relative.have_special_relative = 1; }
#define TIMELIB_HAVE_TZ() { s->cur = cursor; if (s->time->have_zone) { s->time->have_zone > 1 ? add_error(s, "Double timezone specification") : add_warning(s, "Double timezone specification"); timelib_string_free(str); s->time->have_zone++; return TIMELIB_ERROR; } else { s->time->have_zone++; } }

#define TIMELIB_INIT  s->cur = cursor; str = timelib_string(s); ptr = str
#define TIMELIB_DEINIT timelib_string_free(str)
#define TIMELIB_ADJUST_RELATIVE_WEEKDAY() if (in->time.have_weekday_relative && (in.rel.d > 0)) { in.rel.d -= 7; }

#define TIMELIB_PROCESS_YEAR(x, l) { \
	if (((x) == TIMELIB_UNSET) || ((l) >= 4)) { \
	/*	(x) = 0; */          \
	} else if ((x) < 100) {  \
		if ((x) < 70) {      \
			(x) += 2000;     \
		} else {             \
			(x) += 1900;     \
		}                    \
	}                        \
}

#ifdef DEBUG_PARSER
#define DEBUG_OUTPUT(s) printf("%s\n", s);
#define YYDEBUG(s,c) { if (s != -1) { printf("state: %d ", s); printf("[%c]\n", c); } }
#else
#define DEBUG_OUTPUT(s)
#define YYDEBUG(s,c)
#endif

#include "timelib_structs.h"

typedef struct timelib_elems {
	unsigned int   c; /* Number of elements */
	char         **v; /* Values */
} timelib_elems;

typedef struct Scanner {
	int           fd;
	uchar        *lim, *str, *ptr, *cur, *tok, *pos;
	unsigned int  line, len;
	struct timelib_error_container *errors;

	struct timelib_time *time;
	const timelib_tzdb  *tzdb;
} Scanner;

typedef struct _timelib_lookup_table {
    const char *name;
    int         type;
    int         value;
} timelib_lookup_table;

typedef struct _timelib_relunit {
	const char *name;
	int         unit;
	int         multiplier;
} timelib_relunit;

/* The timezone table. */
const static timelib_tz_lookup_table timelib_timezone_lookup[] = {
#include "timezonemap.h"
	{ NULL, 0, 0, NULL },
};

const static timelib_tz_lookup_table timelib_timezone_fallbackmap[] = {
#include "fallbackmap.h"
	{ NULL, 0, 0, NULL },
};

const static timelib_tz_lookup_table timelib_timezone_utc[] = {
	{ "utc", 0, 0, "UTC" },
};

static timelib_relunit const timelib_relunit_lookup[] = {
	{ "sec",         TIMELIB_SECOND,  1 },
	{ "secs",        TIMELIB_SECOND,  1 },
	{ "second",      TIMELIB_SECOND,  1 },
	{ "seconds",     TIMELIB_SECOND,  1 },
	{ "min",         TIMELIB_MINUTE,  1 },
	{ "mins",        TIMELIB_MINUTE,  1 },
	{ "minute",      TIMELIB_MINUTE,  1 },
	{ "minutes",     TIMELIB_MINUTE,  1 },
	{ "hour",        TIMELIB_HOUR,    1 },
	{ "hours",       TIMELIB_HOUR,    1 },
	{ "day",         TIMELIB_DAY,     1 },
	{ "days",        TIMELIB_DAY,     1 },
	{ "week",        TIMELIB_DAY,     7 },
	{ "weeks",       TIMELIB_DAY,     7 },
	{ "fortnight",   TIMELIB_DAY,    14 },
	{ "fortnights",  TIMELIB_DAY,    14 },
	{ "forthnight",  TIMELIB_DAY,    14 },
	{ "forthnights", TIMELIB_DAY,    14 },
	{ "month",       TIMELIB_MONTH,   1 },
	{ "months",      TIMELIB_MONTH,   1 },
	{ "year",        TIMELIB_YEAR,    1 },
	{ "years",       TIMELIB_YEAR,    1 },

	{ "monday",      TIMELIB_WEEKDAY, 1 },
	{ "mon",         TIMELIB_WEEKDAY, 1 },
	{ "tuesday",     TIMELIB_WEEKDAY, 2 },
	{ "tue",         TIMELIB_WEEKDAY, 2 },
	{ "wednesday",   TIMELIB_WEEKDAY, 3 },
	{ "wed",         TIMELIB_WEEKDAY, 3 },
	{ "thursday",    TIMELIB_WEEKDAY, 4 },
	{ "thu",         TIMELIB_WEEKDAY, 4 },
	{ "friday",      TIMELIB_WEEKDAY, 5 },
	{ "fri",         TIMELIB_WEEKDAY, 5 },
	{ "saturday",    TIMELIB_WEEKDAY, 6 },
	{ "sat",         TIMELIB_WEEKDAY, 6 },
	{ "sunday",      TIMELIB_WEEKDAY, 0 },
	{ "sun",         TIMELIB_WEEKDAY, 0 },

	{ "weekday",     TIMELIB_SPECIAL, TIMELIB_SPECIAL_WEEKDAY },
	{ "weekdays",    TIMELIB_SPECIAL, TIMELIB_SPECIAL_WEEKDAY },
	{ NULL,          0,          0 }
};

/* The relative text table. */
static timelib_lookup_table const timelib_reltext_lookup[] = {
	{ "first",    0,  1 },
	{ "next",     0,  1 },
	{ "second",   0,  2 },
	{ "third",    0,  3 },
	{ "fourth",   0,  4 },
	{ "fifth",    0,  5 },
	{ "sixth",    0,  6 },
	{ "seventh",  0,  7 },
	{ "eight",    0,  8 },
	{ "eighth",   0,  8 },
	{ "ninth",    0,  9 },
	{ "tenth",    0, 10 },
	{ "eleventh", 0, 11 },
	{ "twelfth",  0, 12 },
	{ "last",     0, -1 },
	{ "previous", 0, -1 },
	{ "this",     1,  0 },
	{ NULL,       1,  0 }
};

/* The month table. */
static timelib_lookup_table const timelib_month_lookup[] = {
	{ "jan",  0,  1 },
	{ "feb",  0,  2 },
	{ "mar",  0,  3 },
	{ "apr",  0,  4 },
	{ "may",  0,  5 },
	{ "jun",  0,  6 },
	{ "jul",  0,  7 },
	{ "aug",  0,  8 },
	{ "sep",  0,  9 },
	{ "sept", 0,  9 },
	{ "oct",  0, 10 },
	{ "nov",  0, 11 },
	{ "dec",  0, 12 },
	{ "i",    0,  1 },
	{ "ii",   0,  2 },
	{ "iii",  0,  3 },
	{ "iv",   0,  4 },
	{ "v",    0,  5 },
	{ "vi",   0,  6 },
	{ "vii",  0,  7 },
	{ "viii", 0,  8 },
	{ "ix",   0,  9 },
	{ "x",    0, 10 },
	{ "xi",   0, 11 },
	{ "xii",  0, 12 },

	{ "january",   0,  1 },
	{ "february",  0,  2 },
	{ "march",     0,  3 },
	{ "april",     0,  4 },
	{ "may",       0,  5 },
	{ "june",      0,  6 },
	{ "july",      0,  7 },
	{ "august",    0,  8 },
	{ "september", 0,  9 },
	{ "october",   0, 10 },
	{ "november",  0, 11 },
	{ "december",  0, 12 },
	{  NULL,       0,  0 }
};

#if 0
static char* timelib_ltrim(char *s)
{
	char *ptr = s;
	while (ptr[0] == ' ' || ptr[0] == '\t') {
		ptr++;
	}
	return ptr;
}
#endif

#if 0
uchar *fill(Scanner *s, uchar *cursor){
	if(!s->eof){
		unsigned int cnt = s->tok - s->bot;
		if(cnt){
			memcpy(s->bot, s->tok, s->lim - s->tok);
			s->tok = s->bot;
			s->ptr -= cnt;
			cursor -= cnt;
			s->pos -= cnt;
			s->lim -= cnt;
		}
		if((s->top - s->lim) < BSIZE){
			uchar *buf = (uchar*) timelib_malloc(((s->lim - s->bot) + BSIZE)*sizeof(uchar));
			memcpy(buf, s->tok, s->lim - s->tok);
			s->tok = buf;
			s->ptr = &buf[s->ptr - s->bot];
			cursor = &buf[cursor - s->bot];
			s->pos = &buf[s->pos - s->bot];
			s->lim = &buf[s->lim - s->bot];
			s->top = &s->lim[BSIZE];
			timelib_free(s->bot);
			s->bot = buf;
		}
		if((cnt = read(s->fd, (char*) s->lim, BSIZE)) != BSIZE){
			s->eof = &s->lim[cnt]; *(s->eof)++ = '\n';
		}
		s->lim += cnt;
	}
	return cursor;
}
#endif

static void add_warning(Scanner *s, char *error)
{
	s->errors->warning_count++;
	s->errors->warning_messages = timelib_realloc(s->errors->warning_messages, s->errors->warning_count * sizeof(timelib_error_message));
	s->errors->warning_messages[s->errors->warning_count - 1].position = s->tok ? s->tok - s->str : 0;
	s->errors->warning_messages[s->errors->warning_count - 1].character = s->tok ? *s->tok : 0;
	s->errors->warning_messages[s->errors->warning_count - 1].message = timelib_strdup(error);
}

static void add_error(Scanner *s, char *error)
{
	s->errors->error_count++;
	s->errors->error_messages = timelib_realloc(s->errors->error_messages, s->errors->error_count * sizeof(timelib_error_message));
	s->errors->error_messages[s->errors->error_count - 1].position = s->tok ? s->tok - s->str : 0;
	s->errors->error_messages[s->errors->error_count - 1].character = s->tok ? *s->tok : 0;
	s->errors->error_messages[s->errors->error_count - 1].message = timelib_strdup(error);
}

static void add_pbf_warning(Scanner *s, char *error, char *sptr, char *cptr)
{
	s->errors->warning_count++;
	s->errors->warning_messages = timelib_realloc(s->errors->warning_messages, s->errors->warning_count * sizeof(timelib_error_message));
	s->errors->warning_messages[s->errors->warning_count - 1].position = cptr - sptr;
	s->errors->warning_messages[s->errors->warning_count - 1].character = *cptr;
	s->errors->warning_messages[s->errors->warning_count - 1].message = timelib_strdup(error);
}

static void add_pbf_error(Scanner *s, char *error, char *sptr, char *cptr)
{
	s->errors->error_count++;
	s->errors->error_messages = timelib_realloc(s->errors->error_messages, s->errors->error_count * sizeof(timelib_error_message));
	s->errors->error_messages[s->errors->error_count - 1].position = cptr - sptr;
	s->errors->error_messages[s->errors->error_count - 1].character = *cptr;
	s->errors->error_messages[s->errors->error_count - 1].message = timelib_strdup(error);
}

static timelib_sll timelib_meridian(char **ptr, timelib_sll h)
{
	timelib_sll retval = 0;

	while (!strchr("AaPp", **ptr)) {
		++*ptr;
	}
	if (**ptr == 'a' || **ptr == 'A') {
		if (h == 12) {
			retval = -12;
		}
	} else if (h != 12) {
		retval = 12;
	}
	++*ptr;
	if (**ptr == '.') {
		++*ptr;
	}
	if (**ptr == 'M' || **ptr == 'm') {
		++*ptr;
	}
	if (**ptr == '.') {
		++*ptr;
	}
	return retval;
}

static timelib_sll timelib_meridian_with_check(char **ptr, timelib_sll h)
{
	timelib_sll retval = 0;

	while (**ptr && !strchr("AaPp", **ptr)) {
		++*ptr;
	}
	if(!**ptr) {
		return TIMELIB_UNSET;
	}
	if (**ptr == 'a' || **ptr == 'A') {
		if (h == 12) {
			retval = -12;
		}
	} else if (h != 12) {
		retval = 12;
	}
	++*ptr;
	if (**ptr == '.') {
		++*ptr;
		if (**ptr != 'm' && **ptr != 'M') {
			return TIMELIB_UNSET;
		}
		++*ptr;
		if (**ptr != '.' ) {
			return TIMELIB_UNSET;
		}
		++*ptr;
	} else if (**ptr == 'm' || **ptr == 'M') {
		++*ptr;
	} else {
		return TIMELIB_UNSET;
	}
	return retval;
}

static char *timelib_string(Scanner *s)
{
	char *tmp = timelib_calloc(1, s->cur - s->tok + 1);
	memcpy(tmp, s->tok, s->cur - s->tok);

	return tmp;
}

static timelib_sll timelib_get_nr_ex(char **ptr, int max_length, int *scanned_length)
{
	char *begin, *end, *str;
	timelib_sll tmp_nr = TIMELIB_UNSET;
	int len = 0;

	while ((**ptr < '0') || (**ptr > '9')) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}
	begin = *ptr;
	while ((**ptr >= '0') && (**ptr <= '9') && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	if (scanned_length) {
		*scanned_length = end - begin;
	}
	str = timelib_calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	tmp_nr = strtoll(str, NULL, 10);
	timelib_free(str);
	return tmp_nr;
}

static timelib_sll timelib_get_nr(char **ptr, int max_length)
{
	return timelib_get_nr_ex(ptr, max_length, NULL);
}

static void timelib_skip_day_suffix(char **ptr)
{
	if (isspace(**ptr)) {
		return;
	}
	if (!strncasecmp(*ptr, "nd", 2) || !strncasecmp(*ptr, "rd", 2) ||!strncasecmp(*ptr, "st", 2) || !strncasecmp(*ptr, "th", 2)) {
		*ptr += 2;
	}
}

static double timelib_get_frac_nr(char **ptr, int max_length)
{
	char *begin, *end, *str;
	double tmp_nr = TIMELIB_UNSET;
	int len = 0;

	while ((**ptr != '.') && (**ptr != ':') && ((**ptr < '0') || (**ptr > '9'))) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}
	begin = *ptr;
	while (((**ptr == '.') || (**ptr == ':') || ((**ptr >= '0') && (**ptr <= '9'))) && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	str = timelib_calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	if (str[0] == ':') {
		str[0] = '.';
	}
	tmp_nr = strtod(str, NULL);
	timelib_free(str);
	return tmp_nr;
}

static timelib_ull timelib_get_unsigned_nr(char **ptr, int max_length)
{
	timelib_ull dir = 1;

	while (((**ptr < '0') || (**ptr > '9')) && (**ptr != '+') && (**ptr != '-')) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}

	while (**ptr == '+' || **ptr == '-')
	{
		if (**ptr == '-') {
			dir *= -1;
		}
		++*ptr;
	}
	return dir * timelib_get_nr(ptr, max_length);
}

static timelib_sll timelib_lookup_relative_text(char **ptr, int *behavior)
{
	char *word;
	char *begin = *ptr, *end;
	timelib_sll  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_reltext_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
			*behavior = tp->type;
		}
	}

	timelib_free(word);
	return value;
}

static timelib_sll timelib_get_relative_text(char **ptr, int *behavior)
{
	while (**ptr == ' ' || **ptr == '\t' || **ptr == '-' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_relative_text(ptr, behavior);
}

static timelib_long timelib_lookup_month(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	timelib_long  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_month_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
		}
	}

	timelib_free(word);
	return value;
}

static timelib_long timelib_get_month(char **ptr)
{
	while (**ptr == ' ' || **ptr == '\t' || **ptr == '-' || **ptr == '.' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_month(ptr);
}

static void timelib_eat_spaces(char **ptr)
{
	while (**ptr == ' ' || **ptr == '\t') {
		++*ptr;
	}
}

static void timelib_eat_until_separator(char **ptr)
{
	++*ptr;
	while (strchr(" \t.,:;/-0123456789", **ptr) == NULL) {
		++*ptr;
	}
}

static const timelib_relunit* timelib_lookup_relunit(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	const timelib_relunit *tp, *value = NULL;

	while (**ptr != '\0' && **ptr != ' ' && **ptr != ',' && **ptr != '\t' && **ptr != ';' && **ptr != ':' &&
           **ptr != '/' && **ptr != '.' && **ptr != '-' && **ptr != '(' && **ptr != ')' ) {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_relunit_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp;
			break;
		}
	}

	timelib_free(word);
	return value;
}

static void timelib_set_relative(char **ptr, timelib_sll amount, int behavior, Scanner *s)
{
	const timelib_relunit* relunit;

	if (!(relunit = timelib_lookup_relunit(ptr))) {
		return;
	}

	switch (relunit->unit) {
		case TIMELIB_SECOND: s->time->relative.s += amount * relunit->multiplier; break;
		case TIMELIB_MINUTE: s->time->relative.i += amount * relunit->multiplier; break;
		case TIMELIB_HOUR:   s->time->relative.h += amount * relunit->multiplier; break;
		case TIMELIB_DAY:    s->time->relative.d += amount * relunit->multiplier; break;
		case TIMELIB_MONTH:  s->time->relative.m += amount * relunit->multiplier; break;
		case TIMELIB_YEAR:   s->time->relative.y += amount * relunit->multiplier; break;

		case TIMELIB_WEEKDAY:
			TIMELIB_HAVE_WEEKDAY_RELATIVE();
			TIMELIB_UNHAVE_TIME();
			s->time->relative.d += (amount > 0 ? amount - 1 : amount) * 7;
			s->time->relative.weekday = relunit->multiplier;
			s->time->relative.weekday_behavior = behavior;
			break;

		case TIMELIB_SPECIAL:
			TIMELIB_HAVE_SPECIAL_RELATIVE();
			TIMELIB_UNHAVE_TIME();
			s->time->relative.special.type = relunit->multiplier;
			s->time->relative.special.amount = amount;
	}
}

const static timelib_tz_lookup_table* abbr_search(const char *word, timelib_long gmtoffset, int isdst)
{
	int first_found = 0;
	const timelib_tz_lookup_table  *tp, *first_found_elem = NULL;
	const timelib_tz_lookup_table  *fmp;

	if (strcasecmp("utc", word) == 0 || strcasecmp("gmt", word) == 0) {
		return timelib_timezone_utc;
	}

	for (tp = timelib_timezone_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			if (!first_found) {
				first_found = 1;
				first_found_elem = tp;
				if (gmtoffset == -1) {
					return tp;
				}
			}
			if (tp->gmtoffset == gmtoffset) {
				return tp;
			}
		}
	}
	if (first_found) {
		return first_found_elem;
	}

	/* Still didn't find anything, let's find the zone solely based on
	 * offset/isdst then */
	for (fmp = timelib_timezone_fallbackmap; fmp->name; fmp++) {
		if ((fmp->gmtoffset * 60) == gmtoffset && fmp->type == isdst) {
			return fmp;
		}
	}
	return NULL;
}

static timelib_long timelib_lookup_abbr(char **ptr, int *dst, char **tz_abbr, int *found)
{
	char *word;
	char *begin = *ptr, *end;
	timelib_long  value = 0;
	const timelib_tz_lookup_table *tp;

	while (**ptr != '\0' && **ptr != ')' && **ptr != ' ') {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	if ((tp = abbr_search(word, -1, 0))) {
		value = -tp->gmtoffset / 60;
		*dst = tp->type;
		value += tp->type * 60;
		*found = 1;
	} else {
		*found = 0;
	}

	*tz_abbr = word;
	return value;
}

timelib_long timelib_parse_zone(char **ptr, int *dst, timelib_time *t, int *tz_not_found, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_wrapper)
{
	timelib_tzinfo *res;
	timelib_long            retval = 0;

	*tz_not_found = 0;

	while (**ptr == ' ' || **ptr == '\t' || **ptr == '(') {
		++*ptr;
	}
	if ((*ptr)[0] == 'G' && (*ptr)[1] == 'M' && (*ptr)[2] == 'T' && ((*ptr)[3] == '+' || (*ptr)[3] == '-')) {
		*ptr += 3;
	}
	if (**ptr == '+') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = -1 * timelib_parse_tz_cor(ptr);
	} else if (**ptr == '-') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = timelib_parse_tz_cor(ptr);
	} else {
		int found = 0;
		timelib_long offset = 0;
		char *tz_abbr;

		t->is_localtime = 1;

		/* First, we lookup by abbreviation only */
		offset = timelib_lookup_abbr(ptr, dst, &tz_abbr, &found);
		if (found) {
			t->zone_type = TIMELIB_ZONETYPE_ABBR;
			timelib_time_tz_abbr_update(t, tz_abbr);
		}

		/* Otherwise, we look if we have a TimeZone identifier */
		if (!found || strcmp("UTC", tz_abbr) == 0) {
			if ((res = tz_wrapper(tz_abbr, tzdb)) != NULL) {
				t->tz_info = res;
				t->zone_type = TIMELIB_ZONETYPE_ID;
				found++;
			}
		}
		timelib_free(tz_abbr);
		*tz_not_found = (found == 0);
		retval = offset;
	}
	while (**ptr == ')') {
		++*ptr;
	}
	return retval;
}

#define timelib_split_free(arg) {       \
	int i;                         \
	for (i = 0; i < arg.c; i++) {  \
		timelib_free(arg.v[i]);    \
	}                              \
	if (arg.v) {                   \
		timelib_free(arg.v);       \
	}                              \
}

static int scan(Scanner *s, timelib_tz_get_wrapper tz_get_wrapper)
{
	uchar *cursor = s->cur;
	char *str, *ptr = NULL;

std:
	s->tok = cursor;
	s->len = 0;



{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	static const unsigned char yybm[] = {
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0, 100,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		100,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0, 128,  64, 160,  96,   0, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   0,   0,   0,   0,   0,   0, 
		  0,   8,   8,   8,   8,   8,   8,   8, 
		  8,   8,   8,   8,   8,   8,   8,   8, 
		  8,   8,   8,   8,   8,   8,   8,   8, 
		  8,   8,   8,   0,   0,   0,   0,   0, 
		  0,  24,  24,  24,  88,  24,  24,  24, 
		 88,  24,  24,  24,  24,  24,  88,  24, 
		 24,  24,  88,  88,  88,  24,  24,  24, 
		 24,  24,  24,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
	};
	if ((YYLIMIT - YYCURSOR) < 33) YYFILL(33);
	yych = *YYCURSOR;
	switch (yych) {
	case 0x00:
	case '\n':	goto yy51;
	case '\t':
	case ' ':	goto yy48;
	case '(':	goto yy45;
	case '+':
	case '-':	goto yy30;
	case ',':
	case '.':	goto yy50;
	case '0':	goto yy25;
	case '1':	goto yy26;
	case '2':	goto yy27;
	case '3':	goto yy28;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy29;
	case '@':	goto yy11;
	case 'A':	goto yy36;
	case 'B':	goto yy17;
	case 'C':
	case 'H':
	case 'K':
	case 'Q':
	case 'R':
	case 'U':
	case 'Z':	goto yy46;
	case 'D':	goto yy40;
	case 'E':	goto yy21;
	case 'F':	goto yy13;
	case 'G':	goto yy44;
	case 'I':	goto yy31;
	case 'J':	goto yy34;
	case 'L':	goto yy15;
	case 'M':	goto yy7;
	case 'N':	goto yy5;
	case 'O':	goto yy38;
	case 'P':	goto yy23;
	case 'S':	goto yy19;
	case 'T':	goto yy9;
	case 'V':	goto yy32;
	case 'W':	goto yy42;
	case 'X':	goto yy33;
	case 'Y':	goto yy2;
	case 'a':	goto yy37;
	case 'b':	goto yy18;
	case 'c':
	case 'g':
	case 'h':
	case 'i':
	case 'k':
	case 'q':
	case 'r':
	case 'u':
	case 'v':
	case 'x':
	case 'z':	goto yy47;
	case 'd':	goto yy41;
	case 'e':	goto yy22;
	case 'f':	goto yy14;
	case 'j':	goto yy35;
	case 'l':	goto yy16;
	case 'm':	goto yy8;
	case 'n':	goto yy6;
	case 'o':	goto yy39;
	case 'p':	goto yy24;
	case 's':	goto yy20;
	case 't':	goto yy10;
	case 'w':	goto yy43;
	case 'y':	goto yy4;
	default:	goto yy53;
	}
yy2:
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= 'E') {
		if (yych <= ')') {
			if (yych >= ')') goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy140;
			goto yy1463;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy140;
			if (yych >= 'a') goto yy145;
		} else {
			if (yych <= 'e') goto yy1472;
			if (yych <= 'z') goto yy145;
		}
	}
yy3:
	{
		int tz_not_found;
		DEBUG_OUTPUT("tzcorrection | tz");
		TIMELIB_INIT;
		TIMELIB_HAVE_TZ();
		s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
		if (tz_not_found) {
			add_error(s, "The timezone could not be found in the database");
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIMEZONE;
	}
yy4:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy140;
			goto yy1463;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'e') goto yy1463;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy5:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'D') {
			if (yych == ')') goto yy139;
			if (yych <= '@') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy1434;
				goto yy140;
			} else {
				if (yych <= 'I') goto yy1435;
				if (yych <= 'N') goto yy140;
				goto yy1433;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy140;
				goto yy3;
			} else {
				if (yych == 'e') goto yy1450;
				goto yy145;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1451;
				goto yy145;
			} else {
				if (yych <= 'o') goto yy1449;
				if (yych <= 'z') goto yy145;
				goto yy3;
			}
		}
	}
yy6:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'D') {
			if (yych == ')') goto yy139;
			if (yych <= '@') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy1434;
				goto yy140;
			} else {
				if (yych <= 'I') goto yy1435;
				if (yych <= 'N') goto yy140;
				goto yy1433;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy140;
				goto yy3;
			} else {
				if (yych == 'e') goto yy1434;
				goto yy140;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1435;
				goto yy140;
			} else {
				if (yych <= 'o') goto yy1433;
				if (yych <= 'z') goto yy140;
				goto yy3;
			}
		}
	}
yy7:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'A') {
			if (yych == ')') goto yy139;
			if (yych <= '@') goto yy3;
			goto yy1403;
		} else {
			if (yych == 'I') goto yy1404;
			if (yych <= 'N') goto yy140;
			goto yy1405;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1418;
			goto yy145;
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1419;
				goto yy145;
			} else {
				if (yych <= 'o') goto yy1420;
				if (yych <= 'z') goto yy145;
				goto yy3;
			}
		}
	}
yy8:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'A') {
			if (yych == ')') goto yy139;
			if (yych <= '@') goto yy3;
			goto yy1403;
		} else {
			if (yych == 'I') goto yy1404;
			if (yych <= 'N') goto yy140;
			goto yy1405;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1403;
			goto yy140;
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1404;
				goto yy140;
			} else {
				if (yych <= 'o') goto yy1405;
				if (yych <= 'z') goto yy140;
				goto yy3;
			}
		}
	}
yy9:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy139;
	case '0':
	case '1':	goto yy1333;
	case '2':	goto yy1334;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1335;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'Z':	goto yy140;
	case 'E':	goto yy1328;
	case 'H':	goto yy1329;
	case 'O':	goto yy1330;
	case 'U':	goto yy1331;
	case 'W':	goto yy1332;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'x':
	case 'y':
	case 'z':	goto yy145;
	case 'e':	goto yy1371;
	case 'h':	goto yy1372;
	case 'o':	goto yy1373;
	case 'u':	goto yy1374;
	case 'w':	goto yy1375;
	default:	goto yy3;
	}
yy10:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy139;
	case '0':
	case '1':	goto yy1333;
	case '2':	goto yy1334;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1335;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'x':
	case 'y':
	case 'z':	goto yy140;
	case 'E':
	case 'e':	goto yy1328;
	case 'H':
	case 'h':	goto yy1329;
	case 'O':
	case 'o':	goto yy1330;
	case 'U':
	case 'u':	goto yy1331;
	case 'W':
	case 'w':	goto yy1332;
	default:	goto yy3;
	}
yy11:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy1324;
	if (yych <= '/') goto yy12;
	if (yych <= '9') goto yy1325;
yy12:
	{
		add_error(s, "Unexpected character");
		goto std;
	}
yy13:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'E') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy139;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'D') goto yy140;
				goto yy1260;
			}
		} else {
			if (yych <= 'N') {
				if (yych == 'I') goto yy1261;
				goto yy140;
			} else {
				if (yych <= 'O') goto yy1262;
				if (yych <= 'Q') goto yy140;
				goto yy1263;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy140;
				if (yych <= '`') goto yy3;
				goto yy145;
			} else {
				if (yych <= 'e') goto yy1301;
				if (yych <= 'h') goto yy145;
				goto yy1302;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy1303;
				goto yy145;
			} else {
				if (yych <= 'r') goto yy1304;
				if (yych <= 'z') goto yy145;
				goto yy3;
			}
		}
	}
yy14:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'E') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy139;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'D') goto yy140;
				goto yy1260;
			}
		} else {
			if (yych <= 'N') {
				if (yych == 'I') goto yy1261;
				goto yy140;
			} else {
				if (yych <= 'O') goto yy1262;
				if (yych <= 'Q') goto yy140;
				goto yy1263;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy140;
				if (yych <= '`') goto yy3;
				goto yy140;
			} else {
				if (yych <= 'e') goto yy1260;
				if (yych <= 'h') goto yy140;
				goto yy1261;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy1262;
				goto yy140;
			} else {
				if (yych <= 'r') goto yy1263;
				if (yych <= 'z') goto yy140;
				goto yy3;
			}
		}
	}
yy15:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
		goto yy1246;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1257;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy16:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
		goto yy1246;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1246;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy17:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
		goto yy1226;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1243;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy18:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
		goto yy1226;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1226;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy19:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy139;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'A') goto yy1169;
				goto yy140;
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy1168;
				goto yy140;
			} else {
				if (yych <= 'I') goto yy1170;
				if (yych <= 'T') goto yy140;
				goto yy1171;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy140;
				goto yy3;
			} else {
				if (yych <= 'a') goto yy1198;
				if (yych <= 'd') goto yy145;
				goto yy1197;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy1199;
				goto yy145;
			} else {
				if (yych <= 'u') goto yy1200;
				if (yych <= 'z') goto yy145;
				goto yy3;
			}
		}
	}
yy20:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy139;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'A') goto yy1169;
				goto yy140;
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy1168;
				goto yy140;
			} else {
				if (yych <= 'I') goto yy1170;
				if (yych <= 'T') goto yy140;
				goto yy1171;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy140;
				goto yy3;
			} else {
				if (yych <= 'a') goto yy1169;
				if (yych <= 'd') goto yy140;
				goto yy1168;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy1170;
				goto yy140;
			} else {
				if (yych <= 'u') goto yy1171;
				if (yych <= 'z') goto yy140;
				goto yy3;
			}
		}
	}
yy21:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= '@') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == 'I') goto yy1138;
			if (yych <= 'K') goto yy140;
			goto yy1139;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			if (yych <= 'h') goto yy145;
			goto yy1156;
		} else {
			if (yych == 'l') goto yy1157;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy22:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= '@') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == 'I') goto yy1138;
			if (yych <= 'K') goto yy140;
			goto yy1139;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			if (yych <= 'h') goto yy140;
			goto yy1138;
		} else {
			if (yych == 'l') goto yy1139;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy23:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy140;
			goto yy1037;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy145;
		} else {
			if (yych <= 'r') goto yy1131;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy24:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy140;
			goto yy1037;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'r') goto yy1037;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy25:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':	goto yy991;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'w':
	case 'y':	goto yy993;
	case '-':	goto yy412;
	case '.':	goto yy1003;
	case '/':	goto yy411;
	case '0':	goto yy1036;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1035;
	case ':':	goto yy1004;
	case 'n':	goto yy409;
	case 'r':	goto yy410;
	case 's':	goto yy403;
	case 't':	goto yy407;
	default:	goto yy12;
	}
yy26:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':	goto yy399;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy401;
	case '-':	goto yy412;
	case '.':	goto yy413;
	case '/':	goto yy411;
	case '0':
	case '1':
	case '2':	goto yy1035;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1002;
	case ':':	goto yy422;
	case 'n':	goto yy409;
	case 'r':	goto yy410;
	case 's':	goto yy403;
	case 't':	goto yy407;
	default:	goto yy12;
	}
yy27:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':	goto yy399;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy401;
	case '-':	goto yy412;
	case '.':	goto yy413;
	case '/':	goto yy411;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':	goto yy1002;
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy989;
	case ':':	goto yy422;
	case 'n':	goto yy409;
	case 'r':	goto yy410;
	case 's':	goto yy403;
	case 't':	goto yy407;
	default:	goto yy12;
	}
yy28:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':	goto yy399;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy401;
	case '-':	goto yy412;
	case '.':	goto yy413;
	case '/':	goto yy411;
	case '0':
	case '1':	goto yy989;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy408;
	case ':':	goto yy422;
	case 'n':	goto yy409;
	case 'r':	goto yy410;
	case 's':	goto yy403;
	case 't':	goto yy407;
	default:	goto yy12;
	}
yy29:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':	goto yy399;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy401;
	case '-':	goto yy412;
	case '.':	goto yy413;
	case '/':	goto yy411;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy408;
	case ':':	goto yy422;
	case 'n':	goto yy409;
	case 'r':	goto yy410;
	case 's':	goto yy403;
	case 't':	goto yy407;
	default:	goto yy12;
	}
yy30:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 4) {
		goto yy57;
	}
	switch (yych) {
	case '+':
	case '-':	goto yy379;
	case '0':
	case '1':	goto yy376;
	case '2':	goto yy377;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy378;
	default:	goto yy12;
	}
yy31:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy3;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy3;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy3;
			} else {
				if (yych == '/') goto yy3;
				goto yy195;
			}
		}
	} else {
		if (yych <= 'V') {
			if (yych <= 'H') {
				if (yych <= '@') goto yy3;
				goto yy140;
			} else {
				if (yych <= 'I') goto yy375;
				if (yych <= 'U') goto yy140;
				goto yy374;
			}
		} else {
			if (yych <= 'Z') {
				if (yych == 'X') goto yy374;
				goto yy140;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy145;
				goto yy3;
			}
		}
	}
yy32:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy195;
			if (yych <= 0x1F) goto yy3;
			goto yy195;
		} else {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy195;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy195;
			if (yych <= '@') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy371;
				goto yy140;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy145;
				goto yy3;
			}
		}
	}
yy33:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy195;
			if (yych <= 0x1F) goto yy3;
			goto yy195;
		} else {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy195;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy195;
			if (yych <= '@') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy369;
				goto yy140;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy145;
				goto yy3;
			}
		}
	}
yy34:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych <= 'A') goto yy352;
			if (yych <= 'T') goto yy140;
			goto yy351;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy361;
		} else {
			if (yych == 'u') goto yy360;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy35:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych <= 'A') goto yy352;
			if (yych <= 'T') goto yy140;
			goto yy351;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy352;
		} else {
			if (yych == 'u') goto yy351;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy36:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'F') {
			if (yych == ')') goto yy139;
			if (yych <= '@') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'O') {
				if (yych <= 'G') goto yy330;
				goto yy140;
			} else {
				if (yych <= 'P') goto yy329;
				if (yych <= 'T') goto yy140;
				goto yy328;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy140;
				goto yy3;
			} else {
				if (yych == 'g') goto yy342;
				goto yy145;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'p') goto yy341;
				goto yy145;
			} else {
				if (yych <= 'u') goto yy340;
				if (yych <= 'z') goto yy145;
				goto yy3;
			}
		}
	}
yy37:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'F') {
			if (yych == ')') goto yy139;
			if (yych <= '@') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'O') {
				if (yych <= 'G') goto yy330;
				goto yy140;
			} else {
				if (yych <= 'P') goto yy329;
				if (yych <= 'T') goto yy140;
				goto yy328;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy140;
				goto yy3;
			} else {
				if (yych == 'g') goto yy330;
				goto yy140;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'p') goto yy329;
				goto yy140;
			} else {
				if (yych <= 'u') goto yy328;
				if (yych <= 'z') goto yy140;
				goto yy3;
			}
		}
	}
yy38:
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'B') goto yy140;
			goto yy318;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy145;
		} else {
			if (yych <= 'c') goto yy323;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy39:
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'B') goto yy140;
			goto yy318;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'c') goto yy318;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy40:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy140;
			goto yy191;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy145;
		} else {
			if (yych <= 'e') goto yy309;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy41:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy140;
			goto yy191;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'e') goto yy191;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy42:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy140;
			goto yy164;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy145;
		} else {
			if (yych <= 'e') goto yy178;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy43:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy140;
			goto yy164;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'e') goto yy164;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy44:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
		goto yy140;
	} else {
		if (yych <= 'Z') {
			if (yych <= 'M') goto yy156;
			goto yy140;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy45:
	yych = *++YYCURSOR;
	if (yych <= '@') goto yy12;
	if (yych <= 'Z') goto yy155;
	if (yych <= '`') goto yy12;
	if (yych <= 'z') goto yy155;
	goto yy12;
yy46:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy140;
		if (yych <= '`') goto yy3;
		if (yych <= 'z') goto yy145;
		goto yy3;
	}
yy47:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy140;
		if (yych <= '`') goto yy3;
		if (yych <= 'z') goto yy140;
		goto yy3;
	}
yy48:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 4) {
		goto yy57;
	}
	if (yych <= '/') goto yy49;
	if (yych <= '9') goto yy54;
yy49:
	{
		goto std;
	}
yy50:
	yych = *++YYCURSOR;
	goto yy49;
yy51:
	++YYCURSOR;
	{
		s->pos = cursor; s->line++;
		goto std;
	}
yy53:
	yych = *++YYCURSOR;
	goto yy12;
yy54:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych >= ' ') goto yy59;
			} else {
				if (yych == 'D') goto yy64;
				if (yych >= 'F') goto yy65;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy63;
				if (yych >= 'M') goto yy62;
			} else {
				if (yych <= 'S') {
					if (yych >= 'S') goto yy61;
				} else {
					if (yych <= 'T') goto yy68;
					if (yych >= 'W') goto yy67;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy66;
				if (yych >= 'd') goto yy64;
			} else {
				if (yych <= 'f') {
					if (yych >= 'f') goto yy65;
				} else {
					if (yych == 'h') goto yy63;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy62;
				if (yych <= 'r') goto yy56;
				if (yych <= 's') goto yy61;
				goto yy68;
			} else {
				if (yych <= 'w') {
					if (yych >= 'w') goto yy67;
				} else {
					if (yych == 'y') goto yy66;
				}
			}
		}
	}
yy56:
	YYCURSOR = YYMARKER;
	if (yyaccept <= 16) {
		if (yyaccept <= 8) {
			if (yyaccept <= 4) {
				if (yyaccept <= 2) {
					if (yyaccept <= 1) {
						if (yyaccept == 0) {
							goto yy3;
						} else {
							goto yy12;
						}
					} else {
						goto yy49;
					}
				} else {
					if (yyaccept == 3) {
						goto yy72;
					} else {
						goto yy166;
					}
				}
			} else {
				if (yyaccept <= 6) {
					if (yyaccept == 5) {
						goto yy193;
					} else {
						goto yy207;
					}
				} else {
					if (yyaccept == 7) {
						goto yy221;
					} else {
						goto yy332;
					}
				}
			}
		} else {
			if (yyaccept <= 12) {
				if (yyaccept <= 10) {
					if (yyaccept == 9) {
						goto yy415;
					} else {
						goto yy430;
					}
				} else {
					if (yyaccept == 11) {
						goto yy551;
					} else {
						goto yy596;
					}
				}
			} else {
				if (yyaccept <= 14) {
					if (yyaccept == 13) {
						goto yy606;
					} else {
						goto yy703;
					}
				} else {
					if (yyaccept == 15) {
						goto yy723;
					} else {
						goto yy754;
					}
				}
			}
		}
	} else {
		if (yyaccept <= 24) {
			if (yyaccept <= 20) {
				if (yyaccept <= 18) {
					if (yyaccept == 17) {
						goto yy761;
					} else {
						goto yy788;
					}
				} else {
					if (yyaccept == 19) {
						goto yy733;
					} else {
						goto yy394;
					}
				}
			} else {
				if (yyaccept <= 22) {
					if (yyaccept == 21) {
						goto yy913;
					} else {
						goto yy782;
					}
				} else {
					if (yyaccept == 23) {
						goto yy1007;
					} else {
						goto yy1015;
					}
				}
			}
		} else {
			if (yyaccept <= 28) {
				if (yyaccept <= 26) {
					if (yyaccept == 25) {
						goto yy1057;
					} else {
						goto yy1081;
					}
				} else {
					if (yyaccept == 27) {
						goto yy1234;
					} else {
						goto yy1357;
					}
				}
			} else {
				if (yyaccept <= 30) {
					if (yyaccept == 29) {
						goto yy1360;
					} else {
						goto yy1440;
					}
				} else {
					if (yyaccept == 31) {
						goto yy1448;
					} else {
						goto yy1471;
					}
				}
			}
		}
	}
yy57:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 4) {
		goto yy57;
	}
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy54;
	goto yy56;
yy59:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy60:
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych <= 0x1F) goto yy56;
				goto yy59;
			} else {
				if (yych == 'D') goto yy64;
				if (yych <= 'E') goto yy56;
				goto yy65;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy63;
				if (yych <= 'L') goto yy56;
				goto yy62;
			} else {
				if (yych <= 'S') {
					if (yych <= 'R') goto yy56;
				} else {
					if (yych <= 'T') goto yy68;
					if (yych <= 'V') goto yy56;
					goto yy67;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy66;
				if (yych <= 'c') goto yy56;
				goto yy64;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy56;
					goto yy65;
				} else {
					if (yych == 'h') goto yy63;
					goto yy56;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy62;
				if (yych <= 'r') goto yy56;
				if (yych >= 't') goto yy68;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy56;
					goto yy67;
				} else {
					if (yych == 'y') goto yy66;
					goto yy56;
				}
			}
		}
	}
yy61:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy126;
			goto yy56;
		} else {
			if (yych <= 'E') goto yy127;
			if (yych <= 'T') goto yy56;
			goto yy125;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy126;
			goto yy56;
		} else {
			if (yych <= 'e') goto yy127;
			if (yych == 'u') goto yy125;
			goto yy56;
		}
	}
yy62:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych == 'I') goto yy117;
		if (yych <= 'N') goto yy56;
		goto yy116;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy56;
			goto yy117;
		} else {
			if (yych == 'o') goto yy116;
			goto yy56;
		}
	}
yy63:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy114;
	if (yych == 'o') goto yy114;
	goto yy56;
yy64:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy113;
	if (yych == 'a') goto yy113;
	goto yy56;
yy65:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy98;
		if (yych <= 'Q') goto yy56;
		goto yy97;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy56;
			goto yy98;
		} else {
			if (yych == 'r') goto yy97;
			goto yy56;
		}
	}
yy66:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy94;
	if (yych == 'e') goto yy94;
	goto yy56;
yy67:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy82;
	if (yych == 'e') goto yy82;
	goto yy56;
yy68:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy69;
		if (yych <= 'T') goto yy56;
		goto yy70;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy56;
		} else {
			if (yych == 'u') goto yy70;
			goto yy56;
		}
	}
yy69:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy77;
	if (yych == 'u') goto yy77;
	goto yy56;
yy70:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy71;
	if (yych != 'e') goto yy56;
yy71:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'S') goto yy73;
	if (yych == 's') goto yy73;
yy72:
	{
		timelib_ull i;
		DEBUG_OUTPUT("relative");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_unsigned_nr((char **) &ptr, 24);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, 1, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy73:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy74;
	if (yych != 'd') goto yy56;
yy74:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy75;
	if (yych != 'a') goto yy56;
yy75:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy76;
	if (yych != 'y') goto yy56;
yy76:
	yych = *++YYCURSOR;
	goto yy72;
yy77:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy78;
	if (yych != 'r') goto yy72;
yy78:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy79;
	if (yych != 's') goto yy56;
yy79:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy80;
	if (yych != 'd') goto yy56;
yy80:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy81;
	if (yych != 'a') goto yy56;
yy81:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy76;
	if (yych == 'y') goto yy76;
	goto yy56;
yy82:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy56;
		if (yych <= 'D') goto yy84;
	} else {
		if (yych <= 'c') goto yy56;
		if (yych <= 'd') goto yy84;
		if (yych >= 'f') goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy90;
	if (yych == 'k') goto yy90;
	goto yy56;
yy84:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'N') goto yy85;
	if (yych != 'n') goto yy72;
yy85:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy86;
	if (yych != 'e') goto yy56;
yy86:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy87;
	if (yych != 's') goto yy56;
yy87:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy88;
	if (yych != 'd') goto yy56;
yy88:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy89;
	if (yych != 'a') goto yy56;
yy89:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy76;
	if (yych == 'y') goto yy76;
	goto yy56;
yy90:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'D') goto yy91;
		if (yych <= 'R') goto yy72;
		goto yy76;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy72;
		} else {
			if (yych == 's') goto yy76;
			goto yy72;
		}
	}
yy91:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy92;
	if (yych != 'a') goto yy56;
yy92:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy93;
	if (yych != 'y') goto yy56;
yy93:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy76;
	if (yych == 's') goto yy76;
	goto yy72;
yy94:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy95;
	if (yych != 'a') goto yy56;
yy95:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy96;
	if (yych != 'r') goto yy56;
yy96:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy76;
	if (yych == 's') goto yy76;
	goto yy72;
yy97:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy110;
	if (yych == 'i') goto yy110;
	goto yy56;
yy98:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy99;
	if (yych != 'r') goto yy56;
yy99:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy100;
	if (yych != 't') goto yy56;
yy100:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy102;
		if (yych <= 'M') goto yy56;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy56;
			goto yy102;
		} else {
			if (yych != 'n') goto yy56;
		}
	}
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy107;
	if (yych == 'i') goto yy107;
	goto yy56;
yy102:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy103;
	if (yych != 'n') goto yy56;
yy103:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy104;
	if (yych != 'i') goto yy56;
yy104:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy105;
	if (yych != 'g') goto yy56;
yy105:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy106;
	if (yych != 'h') goto yy56;
yy106:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy96;
	if (yych == 't') goto yy96;
	goto yy56;
yy107:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy108;
	if (yych != 'g') goto yy56;
yy108:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy109;
	if (yych != 'h') goto yy56;
yy109:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy96;
	if (yych == 't') goto yy96;
	goto yy56;
yy110:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy111;
	if (yych != 'd') goto yy72;
yy111:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy112;
	if (yych != 'a') goto yy56;
yy112:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy76;
	if (yych == 'y') goto yy76;
	goto yy56;
yy113:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy96;
	if (yych == 'y') goto yy96;
	goto yy56;
yy114:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy115;
	if (yych != 'u') goto yy56;
yy115:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy96;
	if (yych == 'r') goto yy96;
	goto yy56;
yy116:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy121;
	if (yych == 'n') goto yy121;
	goto yy56;
yy117:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy118;
	if (yych != 'n') goto yy56;
yy118:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych == 'S') goto yy76;
		if (yych <= 'T') goto yy72;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy72;
			goto yy76;
		} else {
			if (yych != 'u') goto yy72;
		}
	}
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy120;
	if (yych != 't') goto yy56;
yy120:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy96;
	if (yych == 'e') goto yy96;
	goto yy56;
yy121:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == 'D') goto yy122;
		if (yych <= 'S') goto yy72;
		goto yy123;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy72;
		} else {
			if (yych == 't') goto yy123;
			goto yy72;
		}
	}
yy122:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy124;
	if (yych == 'a') goto yy124;
	goto yy56;
yy123:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy96;
	if (yych == 'h') goto yy96;
	goto yy56;
yy124:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy76;
	if (yych == 'y') goto yy76;
	goto yy56;
yy125:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy136;
	if (yych == 'n') goto yy136;
	goto yy56;
yy126:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy131;
	if (yych == 't') goto yy131;
	goto yy56;
yy127:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy128;
	if (yych != 'c') goto yy56;
yy128:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'O') goto yy129;
		if (yych <= 'R') goto yy72;
		goto yy76;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy72;
		} else {
			if (yych == 's') goto yy76;
			goto yy72;
		}
	}
yy129:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy130;
	if (yych != 'n') goto yy56;
yy130:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy96;
	if (yych == 'd') goto yy96;
	goto yy56;
yy131:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy132;
	if (yych != 'u') goto yy72;
yy132:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy133;
	if (yych != 'r') goto yy56;
yy133:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy134;
	if (yych != 'd') goto yy56;
yy134:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy135;
	if (yych != 'a') goto yy56;
yy135:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy76;
	if (yych == 'y') goto yy76;
	goto yy56;
yy136:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy137;
	if (yych != 'd') goto yy72;
yy137:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy138;
	if (yych != 'a') goto yy56;
yy138:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy76;
	if (yych == 'y') goto yy76;
	goto yy56;
yy139:
	yych = *++YYCURSOR;
	goto yy3;
yy140:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy141;
		if (yych <= '`') goto yy3;
		if (yych >= '{') goto yy3;
	}
yy141:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy142;
		if (yych <= '`') goto yy3;
		if (yych >= '{') goto yy3;
	}
yy142:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy143;
		if (yych <= '`') goto yy3;
		if (yych >= '{') goto yy3;
	}
yy143:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy144;
		if (yych <= '`') goto yy3;
		if (yych >= '{') goto yy3;
	}
yy144:
	yych = *++YYCURSOR;
	if (yych == ')') goto yy139;
	goto yy3;
yy145:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			goto yy147;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy141;
			goto yy3;
		} else {
			if (yych <= '_') goto yy147;
			if (yych <= '`') goto yy3;
			if (yych >= '{') goto yy3;
		}
	}
yy146:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy142;
			goto yy3;
		} else {
			if (yych <= '_') goto yy147;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy147:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 8) {
		goto yy148;
	}
	goto yy56;
yy148:
	yyaccept = 0;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 8) {
		goto yy148;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy147;
		goto yy3;
	} else {
		if (yych <= '/') goto yy147;
		if (yych == '_') goto yy147;
		goto yy3;
	}
yy150:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			goto yy147;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy143;
			goto yy3;
		} else {
			if (yych <= '_') goto yy147;
			if (yych <= '`') goto yy3;
			if (yych >= '{') goto yy3;
		}
	}
yy151:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			goto yy147;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy144;
			goto yy3;
		} else {
			if (yych <= '_') goto yy147;
			if (yych <= '`') goto yy3;
			if (yych >= '{') goto yy3;
		}
	}
yy152:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy153;
	}
	if (yych <= '-') {
		if (yych == ')') goto yy139;
		if (yych <= ',') goto yy3;
		goto yy147;
	} else {
		if (yych <= '/') {
			if (yych <= '.') goto yy3;
			goto yy147;
		} else {
			if (yych == '_') goto yy147;
			goto yy3;
		}
	}
yy153:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy154:
	if (yybm[0+yych] & 16) {
		goto yy153;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy147;
		goto yy56;
	} else {
		if (yych <= '/') goto yy147;
		if (yych == '_') goto yy147;
		goto yy56;
	}
yy155:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy140;
		if (yych <= '`') goto yy3;
		if (yych <= 'z') goto yy140;
		goto yy3;
	}
yy156:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
		goto yy141;
	} else {
		if (yych <= 'Z') {
			if (yych >= 'U') goto yy141;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych != '+') goto yy3;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '-') goto yy158;
			if (yych <= '@') goto yy3;
			goto yy142;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy158:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy159;
	if (yych <= '2') goto yy160;
	if (yych <= '9') goto yy161;
	goto yy56;
yy159:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy3;
	if (yych <= '9') goto yy161;
	if (yych <= ':') goto yy162;
	goto yy3;
yy160:
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy3;
		if (yych >= '5') goto yy163;
	} else {
		if (yych <= '9') goto yy139;
		if (yych <= ':') goto yy162;
		goto yy3;
	}
yy161:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy3;
	if (yych <= '5') goto yy163;
	if (yych <= '9') goto yy139;
	if (yych >= ';') goto yy3;
yy162:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy3;
	if (yych <= '5') goto yy163;
	if (yych <= '9') goto yy139;
	goto yy3;
yy163:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy3;
	if (yych <= '9') goto yy139;
	goto yy3;
yy164:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= '@') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych <= 'C') goto yy141;
			if (yych >= 'E') goto yy167;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'd') goto yy165;
			if (yych <= 'e') goto yy167;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy165:
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= 'N') {
		if (yych <= ')') {
			if (yych >= ')') goto yy139;
		} else {
			if (yych <= '@') goto yy166;
			if (yych <= 'M') goto yy142;
			goto yy173;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy142;
			if (yych >= 'a') goto yy142;
		} else {
			if (yych <= 'n') goto yy173;
			if (yych <= 'z') goto yy142;
		}
	}
yy166:
	{
		const timelib_relunit* relunit;
		DEBUG_OUTPUT("daytext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_HAVE_WEEKDAY_RELATIVE();
		TIMELIB_UNHAVE_TIME();
		relunit = timelib_lookup_relunit((char**) &ptr);
		s->time->relative.weekday = relunit->multiplier;
		if (s->time->relative.weekday_behavior != 2) {
			s->time->relative.weekday_behavior = 1;
		}

		TIMELIB_DEINIT;
		return TIMELIB_WEEKDAY;
	}
yy167:
	yych = *++YYCURSOR;
	if (yych <= 'K') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'J') goto yy142;
		}
	} else {
		if (yych <= 'j') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'k') goto yy168;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy168:
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy143;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'd') goto yy169;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy169:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy144;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy170;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy170:
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'Y') goto yy171;
		if (yych != 'y') goto yy3;
	}
yy171:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy172;
	if (yych != 's') goto yy166;
yy172:
	yych = *++YYCURSOR;
	goto yy166;
yy173:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy143;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'e') goto yy174;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy174:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy144;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 's') goto yy175;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy175:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'D') goto yy176;
		if (yych != 'd') goto yy3;
	}
yy176:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy177;
	if (yych != 'a') goto yy56;
yy177:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy172;
	if (yych == 'y') goto yy172;
	goto yy56;
yy178:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych <= '/') {
				if (yych <= '.') goto yy3;
				goto yy147;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'C') goto yy141;
				goto yy165;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'E') goto yy167;
				goto yy141;
			} else {
				if (yych == '_') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy146;
			} else {
				if (yych <= 'e') goto yy180;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy166;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy166;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy173;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy166;
			goto yy147;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy166;
				goto yy150;
			} else {
				if (yych <= 'n') goto yy186;
				if (yych <= 'z') goto yy150;
				goto yy166;
			}
		}
	}
yy180:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'J') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'K') goto yy168;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'j') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'k') goto yy181;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy181:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy169;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'd') goto yy182;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy182:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy170;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy183;
			if (yych <= 'z') goto yy152;
			goto yy3;
		}
	}
yy183:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Y') goto yy171;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'y') goto yy184;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy184:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == '-') goto yy147;
			goto yy166;
		} else {
			if (yych <= '/') goto yy147;
			if (yych <= 'R') goto yy166;
			goto yy172;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy147;
			goto yy166;
		} else {
			if (yych == 's') goto yy185;
			if (yych <= 'z') goto yy153;
			goto yy166;
		}
	}
yy185:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy153;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy147;
		goto yy166;
	} else {
		if (yych <= '/') goto yy147;
		if (yych == '_') goto yy147;
		goto yy166;
	}
yy186:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy174;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'e') goto yy187;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy187:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy175;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 's') goto yy188;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy188:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'D') goto yy176;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'd') goto yy189;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy189:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy177;
	if (yych != 'a') goto yy154;
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy172;
	if (yych == 'y') goto yy185;
	goto yy154;
yy191:
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'B') goto yy141;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'c') goto yy192;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy192:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych >= '\t') goto yy195;
			} else {
				if (yych == ' ') goto yy195;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
			} else {
				if (yych <= '-') goto yy196;
				if (yych <= '.') goto yy195;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy195;
			} else {
				if (yych == 'E') goto yy200;
				goto yy142;
			}
		} else {
			if (yych <= 'd') {
				if (yych >= 'a') goto yy142;
			} else {
				if (yych <= 'e') goto yy200;
				if (yych <= 'z') goto yy142;
			}
		}
	}
yy193:
	{
		DEBUG_OUTPUT("monthtext");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_lookup_month((char **) &ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
yy194:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 23) YYFILL(23);
	yych = *YYCURSOR;
yy195:
	if (yybm[0+yych] & 32) {
		goto yy194;
	}
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy197;
	if (yych <= '3') goto yy198;
	if (yych <= '9') goto yy199;
	goto yy56;
yy196:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy195;
	if (yych <= '0') goto yy299;
	if (yych <= '2') goto yy300;
	if (yych <= '3') goto yy301;
	goto yy195;
yy197:
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy213;
				goto yy56;
			} else {
				if (yych <= '\t') goto yy211;
				if (yych <= 0x1F) goto yy56;
				goto yy211;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy211;
				goto yy56;
			} else {
				if (yych <= '.') goto yy211;
				if (yych <= '/') goto yy56;
				goto yy298;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy56;
				goto yy211;
			} else {
				if (yych == 'h') goto yy211;
				goto yy56;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy208;
				if (yych <= 'q') goto yy56;
				goto yy209;
			} else {
				if (yych <= 's') goto yy206;
				if (yych <= 't') goto yy210;
				goto yy56;
			}
		}
	}
yy198:
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy213;
				goto yy56;
			} else {
				if (yych <= '\t') goto yy211;
				if (yych <= 0x1F) goto yy56;
				goto yy211;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy211;
				goto yy56;
			} else {
				if (yych <= '.') goto yy211;
				if (yych <= '/') goto yy56;
				goto yy298;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= '9') goto yy205;
				if (yych <= 'c') goto yy56;
				goto yy211;
			} else {
				if (yych == 'h') goto yy211;
				goto yy56;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy208;
				if (yych <= 'q') goto yy56;
				goto yy209;
			} else {
				if (yych <= 's') goto yy206;
				if (yych <= 't') goto yy210;
				goto yy56;
			}
		}
	}
yy199:
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy213;
				goto yy56;
			} else {
				if (yych <= '\t') goto yy211;
				if (yych <= 0x1F) goto yy56;
				goto yy211;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy211;
				goto yy56;
			} else {
				if (yych <= '.') goto yy211;
				if (yych <= '/') goto yy56;
				goto yy205;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy56;
				goto yy211;
			} else {
				if (yych == 'h') goto yy211;
				goto yy56;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy208;
				if (yych <= 'q') goto yy56;
				goto yy209;
			} else {
				if (yych <= 's') goto yy206;
				if (yych <= 't') goto yy210;
				goto yy56;
			}
		}
	}
yy200:
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'L') goto yy143;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'm') goto yy201;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy201:
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy144;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'b') goto yy202;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy202:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'E') goto yy203;
		if (yych != 'e') goto yy3;
	}
yy203:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy204;
	if (yych != 'r') goto yy56;
yy204:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy195;
		if (yych <= 0x1F) goto yy193;
		goto yy195;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy193;
			goto yy195;
		} else {
			if (yych <= '/') goto yy193;
			if (yych <= '9') goto yy195;
			goto yy193;
		}
	}
yy205:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy295;
	goto yy56;
yy206:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 't') goto yy294;
	goto yy212;
yy207:
	{
		int length = 0;
		DEBUG_OUTPUT("datetextual | datenoyear");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
yy208:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'd') goto yy294;
	goto yy212;
yy209:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'd') goto yy294;
	goto yy212;
yy210:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'h') goto yy294;
	goto yy212;
yy211:
	yyaccept = 6;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 18) YYFILL(18);
	yych = *YYCURSOR;
yy212:
	if (yybm[0+yych] & 64) {
		goto yy211;
	}
	if (yych <= '2') {
		if (yych <= '/') goto yy207;
		if (yych <= '0') goto yy285;
		if (yych <= '1') goto yy286;
		goto yy287;
	} else {
		if (yych <= '9') goto yy288;
		if (yych == 'T') goto yy214;
		goto yy207;
	}
yy213:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '0') {
			if (yych <= '/') goto yy207;
			goto yy215;
		} else {
			if (yych <= '1') goto yy216;
			if (yych <= '2') goto yy217;
			goto yy218;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= 'S') goto yy207;
		} else {
			if (yych != 't') goto yy207;
		}
	}
yy214:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy283;
	if (yych <= '2') goto yy284;
	if (yych <= '9') goto yy273;
	goto yy56;
yy215:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy274;
		goto yy56;
	} else {
		if (yych <= '0') goto yy273;
		if (yych <= '9') goto yy218;
		if (yych <= ':') goto yy274;
		goto yy56;
	}
yy216:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy219;
		goto yy56;
	} else {
		if (yych <= '2') goto yy218;
		if (yych <= '9') goto yy273;
		if (yych <= ':') goto yy219;
		goto yy56;
	}
yy217:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy219;
		goto yy56;
	} else {
		if (yych <= '4') goto yy273;
		if (yych == ':') goto yy219;
		goto yy56;
	}
yy218:
	yych = *++YYCURSOR;
	if (yych == '.') goto yy219;
	if (yych != ':') goto yy56;
yy219:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy220;
	if (yych <= '9') goto yy222;
	goto yy56;
yy220:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy223;
	} else {
		if (yych <= '9') goto yy266;
		if (yych <= ':') goto yy223;
	}
yy221:
	{
		int tz_not_found;
		DEBUG_OUTPUT("dateshortwithtimeshort | dateshortwithtimelong | dateshortwithtimelongtz");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
			if (tz_not_found) {
				add_error(s, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
yy222:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy223;
	if (yych != ':') goto yy221;
yy223:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy224;
	if (yych <= '6') goto yy225;
	if (yych <= '9') goto yy226;
	goto yy56;
yy224:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy221;
	if (yych <= '9') goto yy227;
	goto yy221;
yy225:
	yych = *++YYCURSOR;
	if (yych == '0') goto yy227;
	goto yy221;
yy226:
	yych = *++YYCURSOR;
	goto yy221;
yy227:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '*') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy229;
			goto yy221;
		} else {
			if (yych <= ' ') goto yy229;
			if (yych == '(') goto yy229;
			goto yy221;
		}
	} else {
		if (yych <= '@') {
			if (yych == ',') goto yy221;
			if (yych <= '-') goto yy229;
			goto yy221;
		} else {
			if (yych <= 'Z') goto yy229;
			if (yych <= '`') goto yy221;
			if (yych <= 'z') goto yy229;
			goto yy221;
		}
	}
yy228:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy229:
	if (yych <= '@') {
		if (yych <= '\'') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy56;
				goto yy228;
			} else {
				if (yych == ' ') goto yy228;
				goto yy56;
			}
		} else {
			if (yych <= '+') {
				if (yych <= '(') goto yy232;
				if (yych <= '*') goto yy56;
				goto yy231;
			} else {
				if (yych == '-') goto yy231;
				goto yy56;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= 'G') {
				if (yych <= 'A') goto yy233;
				if (yych <= 'F') goto yy234;
			} else {
				if (yych == 'P') goto yy233;
				goto yy234;
			}
		} else {
			if (yych <= 'o') {
				if (yych <= '`') goto yy56;
				if (yych <= 'a') goto yy235;
				goto yy236;
			} else {
				if (yych <= 'p') goto yy235;
				if (yych <= 'z') goto yy236;
				goto yy56;
			}
		}
	}
yy230:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == ')') goto yy226;
		if (yych <= '@') goto yy221;
		goto yy237;
	} else {
		if (yych <= 'Z') {
			if (yych <= 'M') goto yy264;
			goto yy237;
		} else {
			if (yych <= '`') goto yy221;
			if (yych <= 'z') goto yy248;
			goto yy221;
		}
	}
yy231:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy259;
	if (yych <= '2') goto yy260;
	if (yych <= '9') goto yy261;
	goto yy56;
yy232:
	yych = *++YYCURSOR;
	if (yych <= '@') goto yy56;
	if (yych <= 'Z') goto yy236;
	if (yych <= '`') goto yy56;
	if (yych <= 'z') goto yy236;
	goto yy56;
yy233:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy226;
			goto yy221;
		} else {
			if (yych <= '.') goto yy242;
			if (yych <= '@') goto yy221;
			goto yy237;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy243;
			if (yych <= 'Z') goto yy237;
			goto yy221;
		} else {
			if (yych == 'm') goto yy258;
			if (yych <= 'z') goto yy248;
			goto yy221;
		}
	}
yy234:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy226;
		goto yy221;
	} else {
		if (yych <= 'Z') goto yy237;
		if (yych <= '`') goto yy221;
		if (yych <= 'z') goto yy248;
		goto yy221;
	}
yy235:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy226;
			goto yy221;
		} else {
			if (yych <= '.') goto yy242;
			if (yych <= '@') goto yy221;
			goto yy237;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy243;
			if (yych <= 'Z') goto yy237;
			goto yy221;
		} else {
			if (yych == 'm') goto yy243;
			if (yych <= 'z') goto yy237;
			goto yy221;
		}
	}
yy236:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy226;
		goto yy221;
	} else {
		if (yych <= 'Z') goto yy237;
		if (yych <= '`') goto yy221;
		if (yych >= '{') goto yy221;
	}
yy237:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy226;
		goto yy221;
	} else {
		if (yych <= 'Z') goto yy238;
		if (yych <= '`') goto yy221;
		if (yych >= '{') goto yy221;
	}
yy238:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy226;
		goto yy221;
	} else {
		if (yych <= 'Z') goto yy239;
		if (yych <= '`') goto yy221;
		if (yych >= '{') goto yy221;
	}
yy239:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy226;
		goto yy221;
	} else {
		if (yych <= 'Z') goto yy240;
		if (yych <= '`') goto yy221;
		if (yych >= '{') goto yy221;
	}
yy240:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy226;
		goto yy221;
	} else {
		if (yych <= 'Z') goto yy241;
		if (yych <= '`') goto yy221;
		if (yych >= '{') goto yy221;
	}
yy241:
	yych = *++YYCURSOR;
	if (yych == ')') goto yy226;
	goto yy221;
yy242:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy247;
	if (yych == 'm') goto yy247;
	goto yy56;
yy243:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych <= '\t') {
			if (yych <= 0x00) goto yy245;
			if (yych <= 0x08) goto yy221;
			goto yy245;
		} else {
			if (yych == ' ') goto yy245;
			if (yych <= '(') goto yy221;
			goto yy226;
		}
	} else {
		if (yych <= '@') {
			if (yych != '.') goto yy221;
		} else {
			if (yych <= 'Z') goto yy238;
			if (yych <= '`') goto yy221;
			if (yych <= 'z') goto yy238;
			goto yy221;
		}
	}
yy244:
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy245;
		if (yych <= 0x08) goto yy56;
	} else {
		if (yych != ' ') goto yy56;
	}
yy245:
	++YYCURSOR;
	{
		DEBUG_OUTPUT("dateshortwithtimeshort12 | dateshortwithtimelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
yy247:
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy245;
		if (yych == '\t') goto yy245;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy245;
		if (yych == '.') goto yy244;
		goto yy56;
	}
yy248:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy226;
			goto yy221;
		} else {
			if (yych == '.') goto yy221;
			goto yy250;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy221;
			if (yych <= 'Z') goto yy238;
			goto yy221;
		} else {
			if (yych <= '_') goto yy250;
			if (yych <= '`') goto yy221;
			if (yych >= '{') goto yy221;
		}
	}
yy249:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy226;
			goto yy221;
		} else {
			if (yych == '.') goto yy221;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy221;
			if (yych <= 'Z') goto yy239;
			goto yy221;
		} else {
			if (yych <= '_') goto yy250;
			if (yych <= '`') goto yy221;
			if (yych <= 'z') goto yy253;
			goto yy221;
		}
	}
yy250:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '@') goto yy56;
	if (yych <= 'Z') goto yy251;
	if (yych <= '`') goto yy56;
	if (yych >= '{') goto yy56;
yy251:
	yyaccept = 7;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '@') {
		if (yych <= '-') {
			if (yych <= ',') goto yy221;
			goto yy250;
		} else {
			if (yych == '/') goto yy250;
			goto yy221;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy251;
			if (yych <= '^') goto yy221;
			goto yy250;
		} else {
			if (yych <= '`') goto yy221;
			if (yych <= 'z') goto yy251;
			goto yy221;
		}
	}
yy253:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy226;
			goto yy221;
		} else {
			if (yych == '.') goto yy221;
			goto yy250;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy221;
			if (yych <= 'Z') goto yy240;
			goto yy221;
		} else {
			if (yych <= '_') goto yy250;
			if (yych <= '`') goto yy221;
			if (yych >= '{') goto yy221;
		}
	}
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy226;
			goto yy221;
		} else {
			if (yych == '.') goto yy221;
			goto yy250;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy221;
			if (yych <= 'Z') goto yy241;
			goto yy221;
		} else {
			if (yych <= '_') goto yy250;
			if (yych <= '`') goto yy221;
			if (yych >= '{') goto yy221;
		}
	}
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ')') {
			if (yych <= '(') goto yy221;
			goto yy226;
		} else {
			if (yych == '-') goto yy250;
			goto yy221;
		}
	} else {
		if (yych <= '_') {
			if (yych <= '/') goto yy250;
			if (yych <= '^') goto yy221;
			goto yy250;
		} else {
			if (yych <= '`') goto yy221;
			if (yych >= '{') goto yy221;
		}
	}
yy256:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '/') {
		if (yych == '-') goto yy250;
		if (yych <= '.') goto yy56;
		goto yy250;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy56;
			goto yy250;
		} else {
			if (yych <= '`') goto yy56;
			if (yych <= 'z') goto yy256;
			goto yy56;
		}
	}
yy258:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= 0x1F) {
			if (yych <= 0x00) goto yy245;
			if (yych == '\t') goto yy245;
			goto yy221;
		} else {
			if (yych <= '(') {
				if (yych <= ' ') goto yy245;
				goto yy221;
			} else {
				if (yych <= ')') goto yy226;
				if (yych <= ',') goto yy221;
				goto yy250;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '.') goto yy244;
			if (yych <= '/') goto yy250;
			if (yych <= '@') goto yy221;
			goto yy238;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy221;
				goto yy250;
			} else {
				if (yych <= '`') goto yy221;
				if (yych <= 'z') goto yy249;
				goto yy221;
			}
		}
	}
yy259:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy221;
	if (yych <= '9') goto yy261;
	if (yych <= ':') goto yy262;
	goto yy221;
yy260:
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy221;
		if (yych >= '5') goto yy263;
	} else {
		if (yych <= '9') goto yy226;
		if (yych <= ':') goto yy262;
		goto yy221;
	}
yy261:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy221;
	if (yych <= '5') goto yy263;
	if (yych <= '9') goto yy226;
	if (yych >= ';') goto yy221;
yy262:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy221;
	if (yych <= '5') goto yy263;
	if (yych <= '9') goto yy226;
	goto yy221;
yy263:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy221;
	if (yych <= '9') goto yy226;
	goto yy221;
yy264:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == ')') goto yy226;
		if (yych <= '@') goto yy221;
		goto yy238;
	} else {
		if (yych <= 'Z') {
			if (yych >= 'U') goto yy238;
		} else {
			if (yych <= '`') goto yy221;
			if (yych <= 'z') goto yy238;
			goto yy221;
		}
	}
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ')') {
			if (yych <= '(') goto yy221;
			goto yy226;
		} else {
			if (yych == '+') goto yy231;
			goto yy221;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '-') goto yy231;
			if (yych <= '@') goto yy221;
			goto yy239;
		} else {
			if (yych <= '`') goto yy221;
			if (yych <= 'z') goto yy239;
			goto yy221;
		}
	}
yy266:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy267;
			if (yych <= 0x1F) goto yy221;
		} else {
			if (yych == '.') goto yy223;
			if (yych <= '9') goto yy221;
			goto yy223;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy269;
			if (yych <= 'O') goto yy221;
			goto yy269;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy221;
				goto yy269;
			} else {
				if (yych == 'p') goto yy269;
				goto yy221;
			}
		}
	}
yy267:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy267;
			goto yy56;
		} else {
			if (yych <= ' ') goto yy267;
			if (yych <= '@') goto yy56;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy56;
		} else {
			if (yych <= 'a') goto yy269;
			if (yych != 'p') goto yy56;
		}
	}
yy269:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy56;
	} else {
		if (yych <= 'M') goto yy271;
		if (yych == 'm') goto yy271;
		goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy271;
	if (yych != 'm') goto yy56;
yy271:
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy245;
		if (yych == '\t') goto yy245;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy245;
		if (yych != '.') goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy245;
		if (yych <= 0x08) goto yy56;
		goto yy245;
	} else {
		if (yych == ' ') goto yy245;
		goto yy56;
	}
yy273:
	yych = *++YYCURSOR;
	if (yych == '.') goto yy274;
	if (yych != ':') goto yy56;
yy274:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy275;
	if (yych <= '9') goto yy276;
	goto yy56;
yy275:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy277;
		goto yy221;
	} else {
		if (yych <= '9') goto yy276;
		if (yych <= ':') goto yy277;
		goto yy221;
	}
yy276:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy277;
	if (yych != ':') goto yy221;
yy277:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy278;
	if (yych <= '6') goto yy279;
	if (yych <= '9') goto yy226;
	goto yy56;
yy278:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy221;
	if (yych <= '9') goto yy280;
	goto yy221;
yy279:
	yych = *++YYCURSOR;
	if (yych != '0') goto yy221;
yy280:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '*') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy282;
			goto yy221;
		} else {
			if (yych <= ' ') goto yy282;
			if (yych == '(') goto yy282;
			goto yy221;
		}
	} else {
		if (yych <= '@') {
			if (yych == ',') goto yy221;
			if (yych <= '-') goto yy282;
			goto yy221;
		} else {
			if (yych <= 'Z') goto yy282;
			if (yych <= '`') goto yy221;
			if (yych <= 'z') goto yy282;
			goto yy221;
		}
	}
yy281:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy282:
	if (yych <= '+') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy281;
			if (yych <= 0x1F) goto yy56;
			goto yy281;
		} else {
			if (yych == '(') goto yy232;
			if (yych <= '*') goto yy56;
			goto yy231;
		}
	} else {
		if (yych <= 'F') {
			if (yych == '-') goto yy231;
			if (yych <= '@') goto yy56;
			goto yy234;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'G') goto yy230;
				goto yy234;
			} else {
				if (yych <= '`') goto yy56;
				if (yych <= 'z') goto yy236;
				goto yy56;
			}
		}
	}
yy283:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy274;
		goto yy56;
	} else {
		if (yych <= '9') goto yy273;
		if (yych <= ':') goto yy274;
		goto yy56;
	}
yy284:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy274;
		goto yy56;
	} else {
		if (yych <= '4') goto yy273;
		if (yych == ':') goto yy274;
		goto yy56;
	}
yy285:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy274;
		goto yy207;
	} else {
		if (yych <= '0') goto yy292;
		if (yych <= '9') goto yy293;
		if (yych <= ':') goto yy274;
		goto yy207;
	}
yy286:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy219;
		goto yy207;
	} else {
		if (yych <= '2') goto yy293;
		if (yych <= '9') goto yy292;
		if (yych <= ':') goto yy219;
		goto yy207;
	}
yy287:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy219;
		goto yy207;
	} else {
		if (yych <= '4') goto yy292;
		if (yych <= '9') goto yy289;
		if (yych <= ':') goto yy219;
		goto yy207;
	}
yy288:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy219;
		goto yy207;
	} else {
		if (yych <= '9') goto yy289;
		if (yych <= ':') goto yy219;
		goto yy207;
	}
yy289:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy207;
	if (yych >= ':') goto yy207;
yy290:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy207;
	if (yych >= ':') goto yy207;
	yych = *++YYCURSOR;
	goto yy207;
yy292:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy274;
		goto yy207;
	} else {
		if (yych <= '9') goto yy290;
		if (yych <= ':') goto yy274;
		goto yy207;
	}
yy293:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy219;
		goto yy207;
	} else {
		if (yych <= '9') goto yy290;
		if (yych <= ':') goto yy219;
		goto yy207;
	}
yy294:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x00) goto yy213;
	goto yy212;
yy295:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	++YYCURSOR;
	{
		int length = 0;
		DEBUG_OUTPUT("datenoday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
yy298:
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy213;
				goto yy56;
			} else {
				if (yych <= '\t') goto yy211;
				if (yych <= 0x1F) goto yy56;
				goto yy211;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy211;
				goto yy56;
			} else {
				if (yych <= '.') goto yy211;
				if (yych <= '/') goto yy56;
				goto yy295;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy56;
				goto yy211;
			} else {
				if (yych == 'h') goto yy211;
				goto yy56;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy208;
				if (yych <= 'q') goto yy56;
				goto yy209;
			} else {
				if (yych <= 's') goto yy206;
				if (yych <= 't') goto yy210;
				goto yy56;
			}
		}
	}
yy299:
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy213;
				goto yy56;
			} else {
				if (yych <= '\t') goto yy211;
				if (yych <= 0x1F) goto yy56;
				goto yy211;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy211;
				goto yy56;
			} else {
				if (yych <= '.') goto yy211;
				if (yych <= '/') goto yy56;
				goto yy302;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy56;
				goto yy211;
			} else {
				if (yych == 'h') goto yy211;
				goto yy56;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy208;
				if (yych <= 'q') goto yy56;
				goto yy209;
			} else {
				if (yych <= 's') goto yy206;
				if (yych <= 't') goto yy210;
				goto yy56;
			}
		}
	}
yy300:
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy213;
				goto yy56;
			} else {
				if (yych <= '\t') goto yy211;
				if (yych <= 0x1F) goto yy56;
				goto yy211;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy211;
				goto yy56;
			} else {
				if (yych <= '.') goto yy211;
				if (yych <= '/') goto yy56;
				goto yy302;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy56;
				goto yy211;
			} else {
				if (yych == 'h') goto yy211;
				goto yy56;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy208;
				if (yych <= 'q') goto yy56;
				goto yy209;
			} else {
				if (yych <= 's') goto yy206;
				if (yych <= 't') goto yy210;
				goto yy56;
			}
		}
	}
yy301:
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy213;
				goto yy56;
			} else {
				if (yych <= '\t') goto yy211;
				if (yych <= 0x1F) goto yy56;
				goto yy211;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy211;
				goto yy56;
			} else {
				if (yych <= '.') goto yy211;
				if (yych <= '/') goto yy56;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= '9') goto yy205;
				if (yych <= 'c') goto yy56;
				goto yy211;
			} else {
				if (yych == 'h') goto yy211;
				goto yy56;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy208;
				if (yych <= 'q') goto yy56;
				goto yy209;
			} else {
				if (yych <= 's') goto yy206;
				if (yych <= 't') goto yy210;
				goto yy56;
			}
		}
	}
yy302:
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy213;
				goto yy56;
			} else {
				if (yych <= '\t') goto yy211;
				if (yych <= 0x1F) goto yy56;
				goto yy211;
			}
		} else {
			if (yych <= '-') {
				if (yych <= '+') goto yy56;
				if (yych <= ',') goto yy211;
			} else {
				if (yych <= '.') goto yy211;
				if (yych <= '/') goto yy56;
				goto yy295;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy56;
				goto yy211;
			} else {
				if (yych == 'h') goto yy211;
				goto yy56;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy208;
				if (yych <= 'q') goto yy56;
				goto yy209;
			} else {
				if (yych <= 's') goto yy206;
				if (yych <= 't') goto yy210;
				goto yy56;
			}
		}
	}
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '/') goto yy305;
	if (yych <= '9') goto yy306;
yy305:
	{
		int length = 0;
		DEBUG_OUTPUT("pgtextshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
yy306:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy305;
	if (yych >= ':') goto yy305;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy305;
	if (yych >= ':') goto yy305;
	yych = *++YYCURSOR;
	goto yy305;
yy309:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'C') goto yy192;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'c') goto yy310;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy310:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy139;
				if (yych <= ',') goto yy193;
			} else {
				if (yych == '/') goto yy147;
				goto yy195;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'E') goto yy200;
				if (yych <= 'Z') goto yy142;
				goto yy193;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy193;
				goto yy150;
			} else {
				if (yych <= 'e') goto yy312;
				if (yych <= 'z') goto yy150;
				goto yy193;
			}
		}
	}
yy311:
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 8) {
		goto yy148;
	}
	if (yych <= '/') goto yy195;
	if (yych <= '0') goto yy299;
	if (yych <= '2') goto yy300;
	if (yych <= '3') goto yy301;
	goto yy195;
yy312:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'M') goto yy201;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'l') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'm') goto yy313;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy313:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy202;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'b') goto yy314;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy314:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'E') goto yy203;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'e') goto yy315;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy315:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy204;
	if (yych != 'r') goto yy154;
yy316:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy153;
	}
	if (yych <= '-') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy195;
			goto yy193;
		} else {
			if (yych <= ' ') goto yy195;
			if (yych <= ',') goto yy193;
		}
	} else {
		if (yych <= '9') {
			if (yych == '/') goto yy147;
			goto yy195;
		} else {
			if (yych == '_') goto yy147;
			goto yy193;
		}
	}
yy317:
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 8) {
		goto yy148;
	}
	goto yy195;
yy318:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy141;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 't') goto yy319;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy319:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy193;
			} else {
				if (yych <= '-') goto yy196;
				if (yych <= '.') goto yy195;
				goto yy193;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy195;
				goto yy193;
			} else {
				if (yych != 'O') goto yy142;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'o') goto yy320;
				if (yych <= 'z') goto yy142;
				goto yy193;
			}
		}
	}
yy320:
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy143;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'b') goto yy321;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy321:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy144;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'e') goto yy322;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy322:
	yych = *++YYCURSOR;
	if (yych <= 'Q') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'R') goto yy204;
		if (yych == 'r') goto yy204;
		goto yy3;
	}
yy323:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy319;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 't') goto yy324;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy324:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy139;
				if (yych <= ',') goto yy193;
				goto yy311;
			} else {
				if (yych == '/') goto yy147;
				goto yy195;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'N') {
				if (yych <= '@') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'O') goto yy320;
				if (yych <= 'Z') goto yy142;
				goto yy193;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy193;
				goto yy150;
			} else {
				if (yych <= 'o') goto yy325;
				if (yych <= 'z') goto yy150;
				goto yy193;
			}
		}
	}
yy325:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy321;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'b') goto yy326;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy326:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy322;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'e') goto yy327;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy327:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'R') goto yy204;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'r') goto yy316;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy328:
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'F') goto yy141;
			goto yy336;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'g') goto yy336;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy329:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy141;
			goto yy333;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'r') goto yy333;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy330:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy141;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'o') goto yy331;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy331:
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy139;
	} else {
		if (yych <= 'Z') goto yy142;
		if (yych <= '`') goto yy332;
		if (yych <= 'z') goto yy142;
	}
yy332:
	{
		DEBUG_OUTPUT("ago");
		TIMELIB_INIT;
		s->time->relative.y = 0 - s->time->relative.y;
		s->time->relative.m = 0 - s->time->relative.m;
		s->time->relative.d = 0 - s->time->relative.d;
		s->time->relative.h = 0 - s->time->relative.h;
		s->time->relative.i = 0 - s->time->relative.i;
		s->time->relative.s = 0 - s->time->relative.s;
		s->time->relative.weekday = 0 - s->time->relative.weekday;
		if (s->time->relative.weekday == 0) {
			s->time->relative.weekday = -7;
		}
		if (s->time->relative.have_special_relative && s->time->relative.special.type == TIMELIB_SPECIAL_WEEKDAY) {
			s->time->relative.special.amount = 0 - s->time->relative.special.amount;
		}
		TIMELIB_DEINIT;
		return TIMELIB_AGO;
	}
yy333:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy193;
			} else {
				if (yych <= '-') goto yy196;
				if (yych <= '.') goto yy195;
				goto yy193;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy195;
				goto yy193;
			} else {
				if (yych != 'I') goto yy142;
			}
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'i') goto yy334;
				if (yych <= 'z') goto yy142;
				goto yy193;
			}
		}
	}
yy334:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'K') goto yy143;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'l') goto yy335;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy335:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy195;
			goto yy193;
		} else {
			if (yych <= ' ') goto yy195;
			if (yych == ')') goto yy139;
			goto yy193;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy193;
			if (yych <= '9') goto yy195;
			goto yy193;
		} else {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy193;
			if (yych <= 'z') goto yy144;
			goto yy193;
		}
	}
yy336:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy193;
			} else {
				if (yych <= '-') goto yy196;
				if (yych <= '.') goto yy195;
				goto yy193;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy195;
				goto yy193;
			} else {
				if (yych != 'U') goto yy142;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'u') goto yy337;
				if (yych <= 'z') goto yy142;
				goto yy193;
			}
		}
	}
yy337:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy143;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 's') goto yy338;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy338:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy144;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 't') goto yy339;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy339:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy193;
			goto yy195;
		} else {
			if (yych == ' ') goto yy195;
			goto yy193;
		}
	} else {
		if (yych <= '.') {
			if (yych <= ')') goto yy139;
			if (yych <= ',') goto yy193;
			goto yy195;
		} else {
			if (yych <= '/') goto yy193;
			if (yych <= '9') goto yy195;
			goto yy193;
		}
	}
yy340:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'G') goto yy336;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'f') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'g') goto yy347;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy341:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy333;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'r') goto yy344;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy342:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy331;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'o') goto yy343;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy343:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy332;
		} else {
			if (yych == '.') goto yy332;
			goto yy147;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy332;
			if (yych <= 'Z') goto yy142;
			goto yy332;
		} else {
			if (yych <= '_') goto yy147;
			if (yych <= '`') goto yy332;
			if (yych <= 'z') goto yy150;
			goto yy332;
		}
	}
yy344:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy139;
				if (yych <= ',') goto yy193;
				goto yy311;
			} else {
				if (yych == '/') goto yy147;
				goto yy195;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'H') {
				if (yych <= '@') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'I') goto yy334;
				if (yych <= 'Z') goto yy142;
				goto yy193;
			}
		} else {
			if (yych <= 'h') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy193;
				goto yy150;
			} else {
				if (yych <= 'i') goto yy345;
				if (yych <= 'z') goto yy150;
				goto yy193;
			}
		}
	}
yy345:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'K') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'L') goto yy335;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'k') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'l') goto yy346;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy346:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy195;
			if (yych <= 0x1F) goto yy193;
			goto yy195;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy193;
				goto yy139;
			} else {
				if (yych <= ',') goto yy193;
				if (yych <= '-') goto yy317;
				goto yy195;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy147;
			if (yych <= '9') goto yy195;
			if (yych <= '@') goto yy193;
			goto yy144;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy193;
				goto yy147;
			} else {
				if (yych <= '`') goto yy193;
				if (yych <= 'z') goto yy152;
				goto yy193;
			}
		}
	}
yy347:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy139;
				if (yych <= ',') goto yy193;
				goto yy311;
			} else {
				if (yych == '/') goto yy147;
				goto yy195;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'T') {
				if (yych <= '@') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'U') goto yy337;
				if (yych <= 'Z') goto yy142;
				goto yy193;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy193;
				goto yy150;
			} else {
				if (yych <= 'u') goto yy348;
				if (yych <= 'z') goto yy150;
				goto yy193;
			}
		}
	}
yy348:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy338;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 's') goto yy349;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy349:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy339;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 't') goto yy350;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy350:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy153;
	}
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy195;
			goto yy193;
		} else {
			if (yych <= ' ') goto yy195;
			if (yych == ')') goto yy139;
			goto yy193;
		}
	} else {
		if (yych <= '/') {
			if (yych <= '-') goto yy317;
			if (yych <= '.') goto yy195;
			goto yy147;
		} else {
			if (yych <= '9') goto yy195;
			if (yych == '_') goto yy147;
			goto yy193;
		}
	}
yy351:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= '@') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == 'L') goto yy358;
			if (yych <= 'M') goto yy141;
			goto yy357;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			if (yych <= 'k') goto yy141;
			goto yy358;
		} else {
			if (yych == 'n') goto yy357;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy352:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy141;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'n') goto yy353;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy353:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy193;
			} else {
				if (yych <= '-') goto yy196;
				if (yych <= '.') goto yy195;
				goto yy193;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy195;
				goto yy193;
			} else {
				if (yych != 'U') goto yy142;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'u') goto yy354;
				if (yych <= 'z') goto yy142;
				goto yy193;
			}
		}
	}
yy354:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy143;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy355;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy355:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy144;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'r') goto yy356;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy356:
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'Y') goto yy204;
		if (yych == 'y') goto yy204;
		goto yy3;
	}
yy357:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy193;
			} else {
				if (yych <= '-') goto yy196;
				if (yych <= '.') goto yy195;
				goto yy193;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy195;
				goto yy193;
			} else {
				if (yych == 'E') goto yy359;
				goto yy142;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'e') goto yy359;
				if (yych <= 'z') goto yy142;
				goto yy193;
			}
		}
	}
yy358:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy193;
			} else {
				if (yych <= '-') goto yy196;
				if (yych <= '.') goto yy195;
				goto yy193;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy195;
				goto yy193;
			} else {
				if (yych != 'Y') goto yy142;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'y') goto yy359;
				if (yych <= 'z') goto yy142;
				goto yy193;
			}
		}
	}
yy359:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy195;
			goto yy193;
		} else {
			if (yych <= ' ') goto yy195;
			if (yych == ')') goto yy139;
			goto yy193;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy193;
			if (yych <= '9') goto yy195;
			goto yy193;
		} else {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy193;
			if (yych <= 'z') goto yy143;
			goto yy193;
		}
	}
yy360:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy139;
			} else {
				if (yych == '-') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy147;
				goto yy3;
			} else {
				if (yych == 'L') goto yy358;
				goto yy141;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'N') goto yy357;
				goto yy141;
			} else {
				if (yych == '_') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= 'm') {
				if (yych == 'l') goto yy367;
				goto yy146;
			} else {
				if (yych <= 'n') goto yy366;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy361:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy353;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'n') goto yy362;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy362:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy139;
				if (yych <= ',') goto yy193;
				goto yy311;
			} else {
				if (yych == '/') goto yy147;
				goto yy195;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'T') {
				if (yych <= '@') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'U') goto yy354;
				if (yych <= 'Z') goto yy142;
				goto yy193;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy193;
				goto yy150;
			} else {
				if (yych <= 'u') goto yy363;
				if (yych <= 'z') goto yy150;
				goto yy193;
			}
		}
	}
yy363:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy355;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy364;
			if (yych <= 'z') goto yy151;
			goto yy3;
		}
	}
yy364:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy356;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'r') goto yy365;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy365:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Y') goto yy204;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'y') goto yy316;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy366:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy139;
				if (yych <= ',') goto yy193;
				goto yy311;
			} else {
				if (yych == '/') goto yy147;
				goto yy195;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'E') goto yy359;
				if (yych <= 'Z') goto yy142;
				goto yy193;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy193;
				goto yy150;
			} else {
				if (yych <= 'e') goto yy368;
				if (yych <= 'z') goto yy150;
				goto yy193;
			}
		}
	}
yy367:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy139;
				if (yych <= ',') goto yy193;
				goto yy311;
			} else {
				if (yych == '/') goto yy147;
				goto yy195;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'X') {
				if (yych <= '@') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'Y') goto yy359;
				if (yych <= 'Z') goto yy142;
				goto yy193;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy193;
				goto yy150;
			} else {
				if (yych <= 'y') goto yy368;
				if (yych <= 'z') goto yy150;
				goto yy193;
			}
		}
	}
yy368:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy195;
			if (yych <= 0x1F) goto yy193;
			goto yy195;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy193;
				goto yy139;
			} else {
				if (yych <= ',') goto yy193;
				if (yych <= '-') goto yy317;
				goto yy195;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy147;
			if (yych <= '9') goto yy195;
			if (yych <= '@') goto yy193;
			goto yy143;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy193;
				goto yy147;
			} else {
				if (yych <= '`') goto yy193;
				if (yych <= 'z') goto yy151;
				goto yy193;
			}
		}
	}
yy369:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy195;
			if (yych <= 0x1F) goto yy3;
			goto yy195;
		} else {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy195;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy195;
			if (yych <= '@') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'Z') {
				if (yych >= 'J') goto yy141;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy141;
				goto yy3;
			}
		}
	}
yy370:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy195;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy195;
			if (yych == ')') goto yy139;
			goto yy3;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy3;
			if (yych <= '9') goto yy195;
			goto yy3;
		} else {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy371:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy195;
			if (yych <= 0x1F) goto yy3;
			goto yy195;
		} else {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy195;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy195;
			if (yych <= '@') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'Z') {
				if (yych >= 'J') goto yy141;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy141;
				goto yy3;
			}
		}
	}
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy195;
			if (yych <= 0x1F) goto yy3;
			goto yy195;
		} else {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy195;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy195;
			if (yych <= '@') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'Z') {
				if (yych >= 'J') goto yy142;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy142;
				goto yy3;
			}
		}
	}
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy195;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy195;
			if (yych == ')') goto yy139;
			goto yy3;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy3;
			if (yych <= '9') goto yy195;
			goto yy3;
		} else {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy374:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy195;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy195;
			if (yych == ')') goto yy139;
			goto yy3;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy3;
			if (yych <= '9') goto yy195;
			goto yy3;
		} else {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy375:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy195;
			if (yych <= 0x1F) goto yy3;
			goto yy195;
		} else {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy195;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy195;
			if (yych <= '@') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy370;
				goto yy141;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy141;
				goto yy3;
			}
		}
	}
yy376:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy3;
					goto yy396;
				} else {
					if (yych <= ':') goto yy162;
					if (yych <= 'C') goto yy3;
					goto yy60;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy60;
				if (yych <= 'G') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'T') goto yy60;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy3;
				if (yych <= 'Y') goto yy60;
				goto yy3;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy60;
					goto yy3;
				} else {
					if (yych == 'g') goto yy3;
					goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych <= 'r') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy3;
				}
			}
		}
	}
yy377:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= ':') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '4') {
					if (yych <= '/') goto yy3;
					goto yy396;
				} else {
					if (yych <= '5') goto yy381;
					if (yych <= '9') goto yy382;
					goto yy162;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy3;
					goto yy60;
				} else {
					if (yych == 'F') goto yy60;
					goto yy3;
				}
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy60;
					goto yy3;
				} else {
					if (yych <= 'M') goto yy60;
					if (yych <= 'R') goto yy3;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy60;
				if (yych <= 'X') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy3;
					goto yy60;
				} else {
					if (yych == 'f') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy60;
					goto yy3;
				} else {
					if (yych <= 'm') goto yy60;
					if (yych <= 'r') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy3;
				}
			}
		}
	}
yy378:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= 'C') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '5') {
					if (yych <= '/') goto yy3;
					goto yy381;
				} else {
					if (yych <= '9') goto yy382;
					if (yych <= ':') goto yy162;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych == 'E') goto yy3;
				if (yych <= 'F') goto yy60;
				goto yy3;
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy60;
					goto yy3;
				} else {
					if (yych <= 'M') goto yy60;
					if (yych <= 'R') goto yy3;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy60;
				if (yych <= 'X') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy3;
					goto yy60;
				} else {
					if (yych == 'f') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy60;
					goto yy3;
				} else {
					if (yych <= 'm') goto yy60;
					if (yych <= 'r') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy3;
				}
			}
		}
	}
yy379:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 4) {
		goto yy57;
	}
	if (yych <= ',') {
		if (yych == '+') goto yy379;
		goto yy56;
	} else {
		if (yych <= '-') goto yy379;
		if (yych <= '/') goto yy56;
		if (yych <= '9') goto yy54;
		goto yy56;
	}
yy381:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '/') goto yy3;
				if (yych <= '9') goto yy395;
				if (yych <= 'C') goto yy3;
				goto yy60;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy60;
				if (yych <= 'G') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'T') goto yy60;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy3;
				if (yych <= 'Y') goto yy60;
				goto yy3;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy60;
					goto yy3;
				} else {
					if (yych == 'g') goto yy3;
					goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych <= 'r') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy3;
				}
			}
		}
	}
yy382:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '/') goto yy3;
				if (yych <= '9') goto yy383;
				if (yych <= 'C') goto yy3;
				goto yy60;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy60;
				if (yych <= 'G') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'T') goto yy60;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy3;
				if (yych <= 'Y') goto yy60;
				goto yy3;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy60;
					goto yy3;
				} else {
					if (yych == 'g') goto yy3;
					goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych <= 'r') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy3;
				}
			}
		}
	}
yy383:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych >= ':') goto yy60;
yy384:
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	if (yych != '-') goto yy60;
yy385:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy386;
	if (yych <= '1') goto yy387;
	goto yy56;
yy386:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy388;
	goto yy56;
yy387:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '3') goto yy56;
yy388:
	yych = *++YYCURSOR;
	if (yych != '-') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy390;
	if (yych <= '2') goto yy391;
	if (yych <= '3') goto yy392;
	goto yy56;
yy390:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy393;
	goto yy56;
yy391:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy393;
	goto yy56;
yy392:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '2') goto yy56;
yy393:
	++YYCURSOR;
yy394:
	{
		DEBUG_OUTPUT("iso8601date4 | iso8601date2 | iso8601dateslash | dateslash");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_unsigned_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
yy395:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '/') goto yy3;
				if (yych <= '9') goto yy384;
				if (yych <= 'C') goto yy3;
				goto yy60;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy60;
				if (yych <= 'G') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'T') goto yy60;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy3;
				if (yych <= 'Y') goto yy60;
				goto yy3;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy60;
					goto yy3;
				} else {
					if (yych == 'g') goto yy3;
					goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych <= 'r') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy3;
				}
			}
		}
	}
yy396:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= 'C') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '5') {
					if (yych <= '/') goto yy3;
				} else {
					if (yych <= '9') goto yy395;
					if (yych <= ':') goto yy162;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych == 'E') goto yy3;
				if (yych <= 'F') goto yy60;
				goto yy3;
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy60;
					goto yy3;
				} else {
					if (yych <= 'M') goto yy60;
					if (yych <= 'R') goto yy3;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy60;
				if (yych <= 'X') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy3;
					goto yy60;
				} else {
					if (yych == 'f') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy60;
					goto yy3;
				} else {
					if (yych <= 'm') goto yy60;
					if (yych <= 'r') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy3;
				}
			}
		}
	}
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '/') goto yy3;
				if (yych <= '9') goto yy398;
				if (yych <= 'C') goto yy3;
				goto yy60;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy60;
				if (yych <= 'G') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'T') goto yy60;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy3;
				if (yych <= 'Y') goto yy60;
				goto yy3;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy60;
					goto yy3;
				} else {
					if (yych == 'g') goto yy3;
					goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych <= 'r') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy3;
				}
			}
		}
	}
yy398:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych == '-') goto yy385;
				if (yych <= 'C') goto yy3;
				goto yy60;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy60;
				if (yych <= 'G') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'T') goto yy60;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy3;
				if (yych <= 'Y') goto yy60;
				goto yy3;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy60;
					goto yy3;
				} else {
					if (yych == 'g') goto yy3;
					goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych <= 'r') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy3;
				}
			}
		}
	}
yy399:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy401;
	if (yych <= '0') goto yy675;
	if (yych <= '1') goto yy676;
	if (yych <= '9') goto yy677;
	goto yy401;
yy400:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy401:
	switch (yych) {
	case '\t':
	case ' ':	goto yy400;
	case '-':
	case '.':	goto yy516;
	case 'A':
	case 'a':	goto yy419;
	case 'D':
	case 'd':	goto yy405;
	case 'F':
	case 'f':	goto yy406;
	case 'H':
	case 'h':	goto yy63;
	case 'I':	goto yy414;
	case 'J':
	case 'j':	goto yy418;
	case 'M':
	case 'm':	goto yy404;
	case 'N':
	case 'n':	goto yy421;
	case 'O':
	case 'o':	goto yy420;
	case 'P':
	case 'p':	goto yy423;
	case 'S':
	case 's':	goto yy402;
	case 'T':
	case 't':	goto yy68;
	case 'V':	goto yy416;
	case 'W':
	case 'w':	goto yy67;
	case 'X':	goto yy417;
	case 'Y':
	case 'y':	goto yy66;
	default:	goto yy56;
	}
yy402:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy126;
			goto yy56;
		} else {
			if (yych <= 'E') goto yy988;
			if (yych <= 'T') goto yy56;
			goto yy125;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy126;
			goto yy56;
		} else {
			if (yych <= 'e') goto yy988;
			if (yych == 'u') goto yy125;
			goto yy56;
		}
	}
yy403:
	yych = *++YYCURSOR;
	if (yych <= '`') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy126;
			goto yy56;
		} else {
			if (yych <= 'E') goto yy988;
			if (yych == 'U') goto yy125;
			goto yy56;
		}
	} else {
		if (yych <= 'e') {
			if (yych <= 'a') goto yy126;
			if (yych <= 'd') goto yy56;
			goto yy988;
		} else {
			if (yych <= 's') goto yy56;
			if (yych <= 't') goto yy668;
			if (yych <= 'u') goto yy125;
			goto yy56;
		}
	}
yy404:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'H') {
			if (yych == 'A') goto yy531;
			goto yy56;
		} else {
			if (yych <= 'I') goto yy117;
			if (yych <= 'N') goto yy56;
			goto yy116;
		}
	} else {
		if (yych <= 'h') {
			if (yych == 'a') goto yy531;
			goto yy56;
		} else {
			if (yych <= 'i') goto yy117;
			if (yych == 'o') goto yy116;
			goto yy56;
		}
	}
yy405:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych == 'A') goto yy113;
		if (yych <= 'D') goto yy56;
		goto yy518;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy113;
		} else {
			if (yych == 'e') goto yy518;
			goto yy56;
		}
	}
yy406:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'N') {
			if (yych == 'E') goto yy534;
			goto yy56;
		} else {
			if (yych <= 'O') goto yy98;
			if (yych <= 'Q') goto yy56;
			goto yy97;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'e') goto yy534;
			goto yy56;
		} else {
			if (yych <= 'o') goto yy98;
			if (yych == 'r') goto yy97;
			goto yy56;
		}
	}
yy407:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy69;
		if (yych <= 'T') goto yy56;
		goto yy70;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy56;
			goto yy987;
		} else {
			if (yych == 'u') goto yy70;
			goto yy56;
		}
	}
yy408:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy681;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy680;
	goto yy60;
yy409:
	yych = *++YYCURSOR;
	if (yych <= 'c') {
		if (yych == 'O') goto yy469;
		goto yy56;
	} else {
		if (yych <= 'd') goto yy668;
		if (yych == 'o') goto yy469;
		goto yy56;
	}
yy410:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy668;
	goto yy56;
yy411:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':	goto yy605;
	case '3':	goto yy607;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy608;
	case 'A':
	case 'a':	goto yy612;
	case 'D':
	case 'd':	goto yy616;
	case 'F':
	case 'f':	goto yy610;
	case 'J':
	case 'j':	goto yy609;
	case 'M':
	case 'm':	goto yy611;
	case 'N':
	case 'n':	goto yy615;
	case 'O':
	case 'o':	goto yy614;
	case 'S':
	case 's':	goto yy613;
	default:	goto yy56;
	}
yy412:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy555;
	case '1':	goto yy556;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy557;
	case 'A':
	case 'a':	goto yy561;
	case 'D':
	case 'd':	goto yy565;
	case 'F':
	case 'f':	goto yy559;
	case 'J':
	case 'j':	goto yy558;
	case 'M':
	case 'm':	goto yy560;
	case 'N':
	case 'n':	goto yy564;
	case 'O':
	case 'o':	goto yy563;
	case 'S':
	case 's':	goto yy562;
	default:	goto yy517;
	}
yy413:
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= '/') goto yy517;
		if (yych <= '0') goto yy507;
		goto yy508;
	} else {
		if (yych <= '5') goto yy509;
		if (yych <= '9') goto yy510;
		goto yy517;
	}
yy414:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy471;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
			if (yych <= '.') goto yy471;
		}
	} else {
		if (yych <= 'U') {
			if (yych <= '9') goto yy473;
			if (yych == 'I') goto yy506;
		} else {
			if (yych == 'W') goto yy415;
			if (yych <= 'X') goto yy479;
		}
	}
yy415:
	{
		DEBUG_OUTPUT("datenoyearrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
yy416:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy415;
			goto yy471;
		} else {
			if (yych == ' ') goto yy471;
			goto yy415;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy471;
			if (yych <= '/') goto yy415;
			goto yy473;
		} else {
			if (yych == 'I') goto yy504;
			goto yy415;
		}
	}
yy417:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy415;
			goto yy471;
		} else {
			if (yych == ' ') goto yy471;
			goto yy415;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy471;
			if (yych <= '/') goto yy415;
			goto yy473;
		} else {
			if (yych == 'I') goto yy503;
			goto yy415;
		}
	}
yy418:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy496;
		if (yych <= 'T') goto yy56;
		goto yy495;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy496;
		} else {
			if (yych == 'u') goto yy495;
			goto yy56;
		}
	}
yy419:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= 'L') {
			if (yych == '.') goto yy424;
			goto yy56;
		} else {
			if (yych <= 'M') goto yy425;
			if (yych == 'P') goto yy489;
			goto yy56;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'U') goto yy488;
			if (yych == 'm') goto yy425;
			goto yy56;
		} else {
			if (yych <= 'p') goto yy489;
			if (yych == 'u') goto yy488;
			goto yy56;
		}
	}
yy420:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy483;
	if (yych == 'c') goto yy483;
	goto yy56;
yy421:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy469;
	if (yych == 'o') goto yy469;
	goto yy56;
yy422:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy429;
	if (yych <= '9') goto yy431;
	goto yy56;
yy423:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy56;
	} else {
		if (yych <= 'M') goto yy425;
		if (yych == 'm') goto yy425;
		goto yy56;
	}
yy424:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy425;
	if (yych != 'm') goto yy56;
yy425:
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy427;
		if (yych == '\t') goto yy427;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy427;
		if (yych != '.') goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy427;
		if (yych <= 0x08) goto yy56;
	} else {
		if (yych != ' ') goto yy56;
	}
yy427:
	++YYCURSOR;
	{
		DEBUG_OUTPUT("timetiny12 | timeshort12 | timelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->i = timelib_get_nr((char **) &ptr, 2);
			if (*ptr == ':' || *ptr == '.') {
				s->time->s = timelib_get_nr((char **) &ptr, 2);
			}
		}
		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_TIME12;
	}
yy429:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy432;
	} else {
		if (yych <= '9') goto yy446;
		if (yych <= ':') goto yy432;
	}
yy430:
	{
		int tz_not_found;
		DEBUG_OUTPUT("timeshort24 | timelong24 | iso8601long");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
			if (tz_not_found) {
				add_error(s, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIME24_WITH_ZONE;
	}
yy431:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy432;
	if (yych != ':') goto yy430;
yy432:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy433;
	if (yych <= '6') goto yy434;
	if (yych <= '9') goto yy435;
	goto yy56;
yy433:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy436;
	if (yych <= '/') goto yy430;
	if (yych <= '9') goto yy439;
	goto yy430;
yy434:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy436;
	if (yych == '0') goto yy439;
	goto yy430;
yy435:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '.') goto yy430;
yy436:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy437:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '/') goto yy430;
	if (yych <= '9') goto yy437;
	goto yy430;
yy439:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych != '\t') goto yy430;
		} else {
			if (yych <= ' ') goto yy440;
			if (yych == '.') goto yy436;
			goto yy430;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'A') goto yy442;
			if (yych == 'P') goto yy442;
			goto yy430;
		} else {
			if (yych <= 'a') goto yy442;
			if (yych == 'p') goto yy442;
			goto yy430;
		}
	}
yy440:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy440;
			goto yy56;
		} else {
			if (yych <= ' ') goto yy440;
			if (yych <= '@') goto yy56;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy56;
		} else {
			if (yych <= 'a') goto yy442;
			if (yych != 'p') goto yy56;
		}
	}
yy442:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy56;
	} else {
		if (yych <= 'M') goto yy444;
		if (yych == 'm') goto yy444;
		goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy444;
	if (yych != 'm') goto yy56;
yy444:
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy427;
		if (yych == '\t') goto yy427;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy427;
		if (yych != '.') goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy427;
		if (yych <= 0x08) goto yy56;
		goto yy427;
	} else {
		if (yych == ' ') goto yy427;
		goto yy56;
	}
yy446:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy447;
			if (yych <= 0x1F) goto yy430;
		} else {
			if (yych == '.') goto yy432;
			if (yych <= '9') goto yy430;
			goto yy450;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy449;
			if (yych <= 'O') goto yy430;
			goto yy449;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy430;
				goto yy449;
			} else {
				if (yych == 'p') goto yy449;
				goto yy430;
			}
		}
	}
yy447:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy447;
			goto yy56;
		} else {
			if (yych <= ' ') goto yy447;
			if (yych <= '@') goto yy56;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy56;
		} else {
			if (yych <= 'a') goto yy449;
			if (yych != 'p') goto yy56;
		}
	}
yy449:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == '.') goto yy466;
		goto yy56;
	} else {
		if (yych <= 'M') goto yy467;
		if (yych == 'm') goto yy467;
		goto yy56;
	}
yy450:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy451;
	if (yych <= '6') goto yy452;
	if (yych <= '9') goto yy435;
	goto yy56;
yy451:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy436;
	if (yych <= '/') goto yy430;
	if (yych <= '9') goto yy453;
	goto yy430;
yy452:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy436;
	if (yych != '0') goto yy430;
yy453:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy440;
			if (yych <= 0x1F) goto yy430;
			goto yy440;
		} else {
			if (yych == '.') goto yy454;
			if (yych <= '9') goto yy430;
			goto yy455;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy442;
			if (yych <= 'O') goto yy430;
			goto yy442;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy430;
				goto yy442;
			} else {
				if (yych == 'p') goto yy442;
				goto yy430;
			}
		}
	}
yy454:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy464;
	goto yy56;
yy455:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy456:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych <= 'O') {
		if (yych <= '9') {
			if (yych <= '/') goto yy56;
			goto yy456;
		} else {
			if (yych != 'A') goto yy56;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'P') goto yy458;
			if (yych <= '`') goto yy56;
		} else {
			if (yych != 'p') goto yy56;
		}
	}
yy458:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy56;
	} else {
		if (yych <= 'M') goto yy460;
		if (yych == 'm') goto yy460;
		goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy460;
	if (yych != 'm') goto yy56;
yy460:
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy462;
		if (yych == '\t') goto yy462;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy462;
		if (yych != '.') goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy462;
		if (yych <= 0x08) goto yy56;
	} else {
		if (yych != ' ') goto yy56;
	}
yy462:
	++YYCURSOR;
	{
		DEBUG_OUTPUT("mssqltime");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == ':' || *ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}
		timelib_eat_spaces((char **) &ptr);
		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_TIME24_WITH_ZONE;
	}
yy464:
	yyaccept = 10;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych <= 'O') {
		if (yych <= '9') {
			if (yych <= '/') goto yy430;
			goto yy464;
		} else {
			if (yych == 'A') goto yy458;
			goto yy430;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'P') goto yy458;
			if (yych <= '`') goto yy430;
			goto yy458;
		} else {
			if (yych == 'p') goto yy458;
			goto yy430;
		}
	}
yy466:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy467;
	if (yych != 'm') goto yy56;
yy467:
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy427;
		if (yych == '\t') goto yy427;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy427;
		if (yych != '.') goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy427;
		if (yych <= 0x08) goto yy56;
		goto yy427;
	} else {
		if (yych == ' ') goto yy427;
		goto yy56;
	}
yy469:
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy470;
	if (yych != 'v') goto yy56;
yy470:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych != '\t') goto yy415;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		} else {
			if (yych <= 'E') goto yy475;
			if (yych == 'e') goto yy475;
			goto yy415;
		}
	}
yy471:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
	yych = *YYCURSOR;
yy472:
	if (yych <= ' ') {
		if (yych == '\t') goto yy471;
		if (yych <= 0x1F) goto yy56;
		goto yy471;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy56;
			goto yy471;
		} else {
			if (yych <= '/') goto yy56;
			if (yych >= ':') goto yy56;
		}
	}
yy473:
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '/') goto yy474;
	if (yych <= '9') goto yy480;
yy474:
	{
		int length = 0;
		DEBUG_OUTPUT("datefull");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL;
	}
yy475:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy476;
	if (yych != 'm') goto yy56;
yy476:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy477;
	if (yych != 'b') goto yy56;
yy477:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy478;
	if (yych != 'e') goto yy56;
yy478:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy479;
	if (yych != 'r') goto yy56;
yy479:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy471;
		if (yych <= 0x1F) goto yy415;
		goto yy471;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy415;
			goto yy471;
		} else {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		}
	}
yy480:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy474;
	if (yych >= ':') goto yy474;
yy481:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy474;
	if (yych >= ':') goto yy474;
	yych = *++YYCURSOR;
	goto yy474;
yy483:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy484;
	if (yych != 't') goto yy56;
yy484:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy471;
			goto yy415;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
			goto yy471;
		}
	} else {
		if (yych <= 'N') {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		} else {
			if (yych <= 'O') goto yy485;
			if (yych != 'o') goto yy415;
		}
	}
yy485:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy486;
	if (yych != 'b') goto yy56;
yy486:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy487;
	if (yych != 'e') goto yy56;
yy487:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy479;
	if (yych == 'r') goto yy479;
	goto yy56;
yy488:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy492;
	if (yych == 'g') goto yy492;
	goto yy56;
yy489:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy490;
	if (yych != 'r') goto yy56;
yy490:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy471;
			goto yy415;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
			goto yy471;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		} else {
			if (yych <= 'I') goto yy491;
			if (yych != 'i') goto yy415;
		}
	}
yy491:
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy479;
	if (yych == 'l') goto yy479;
	goto yy56;
yy492:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy471;
			goto yy415;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
			goto yy471;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		} else {
			if (yych <= 'U') goto yy493;
			if (yych != 'u') goto yy415;
		}
	}
yy493:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy494;
	if (yych != 's') goto yy56;
yy494:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy479;
	if (yych == 't') goto yy479;
	goto yy56;
yy495:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy502;
		if (yych <= 'M') goto yy56;
		goto yy501;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy502;
		} else {
			if (yych == 'n') goto yy501;
			goto yy56;
		}
	}
yy496:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy497;
	if (yych != 'n') goto yy56;
yy497:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy471;
			goto yy415;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
			goto yy471;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		} else {
			if (yych <= 'U') goto yy498;
			if (yych != 'u') goto yy415;
		}
	}
yy498:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy499;
	if (yych != 'a') goto yy56;
yy499:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy500;
	if (yych != 'r') goto yy56;
yy500:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy479;
	if (yych == 'y') goto yy479;
	goto yy56;
yy501:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy471;
			goto yy415;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
			goto yy471;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		} else {
			if (yych <= 'E') goto yy479;
			if (yych == 'e') goto yy479;
			goto yy415;
		}
	}
yy502:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy471;
			goto yy415;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
			goto yy471;
		}
	} else {
		if (yych <= 'X') {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		} else {
			if (yych <= 'Y') goto yy479;
			if (yych == 'y') goto yy479;
			goto yy415;
		}
	}
yy503:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy415;
			goto yy471;
		} else {
			if (yych == ' ') goto yy471;
			goto yy415;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy471;
			if (yych <= '/') goto yy415;
			goto yy473;
		} else {
			if (yych == 'I') goto yy479;
			goto yy415;
		}
	}
yy504:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy415;
			goto yy471;
		} else {
			if (yych == ' ') goto yy471;
			goto yy415;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy471;
			if (yych <= '/') goto yy415;
			goto yy473;
		} else {
			if (yych != 'I') goto yy415;
		}
	}
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy415;
			goto yy471;
		} else {
			if (yych == ' ') goto yy471;
			goto yy415;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy471;
			if (yych <= '/') goto yy415;
			goto yy473;
		} else {
			if (yych == 'I') goto yy479;
			goto yy415;
		}
	}
yy506:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy415;
			goto yy471;
		} else {
			if (yych == ' ') goto yy471;
			goto yy415;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy471;
			if (yych <= '/') goto yy415;
			goto yy473;
		} else {
			if (yych == 'I') goto yy479;
			goto yy415;
		}
	}
yy507:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy430;
		if (yych <= '-') goto yy541;
		goto yy540;
	} else {
		if (yych <= '/') goto yy430;
		if (yych <= '9') goto yy554;
		if (yych <= ':') goto yy432;
		goto yy430;
	}
yy508:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') goto yy430;
		if (yych <= '-') goto yy541;
		if (yych <= '.') goto yy540;
		goto yy430;
	} else {
		if (yych <= '2') goto yy554;
		if (yych <= '9') goto yy553;
		if (yych <= ':') goto yy432;
		goto yy430;
	}
yy509:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy430;
		if (yych <= '-') goto yy541;
		goto yy540;
	} else {
		if (yych <= '/') goto yy430;
		if (yych <= '9') goto yy553;
		if (yych <= ':') goto yy432;
		goto yy430;
	}
yy510:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy430;
		if (yych <= '-') goto yy541;
		goto yy540;
	} else {
		if (yych == ':') goto yy432;
		goto yy430;
	}
yy511:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy534;
	if (yych == 'e') goto yy534;
	goto yy56;
yy512:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy531;
	if (yych == 'a') goto yy531;
	goto yy56;
yy513:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy489;
		if (yych <= 'T') goto yy56;
		goto yy488;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy489;
		} else {
			if (yych == 'u') goto yy488;
			goto yy56;
		}
	}
yy514:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy524;
	if (yych == 'e') goto yy524;
	goto yy56;
yy515:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy518;
	if (yych == 'e') goto yy518;
	goto yy56;
yy516:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy517:
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy516;
	case 'A':
	case 'a':	goto yy513;
	case 'D':
	case 'd':	goto yy515;
	case 'F':
	case 'f':	goto yy511;
	case 'I':	goto yy414;
	case 'J':
	case 'j':	goto yy418;
	case 'M':
	case 'm':	goto yy512;
	case 'N':
	case 'n':	goto yy421;
	case 'O':
	case 'o':	goto yy420;
	case 'S':
	case 's':	goto yy514;
	case 'V':	goto yy416;
	case 'X':	goto yy417;
	default:	goto yy56;
	}
yy518:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy519;
	if (yych != 'c') goto yy56;
yy519:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy471;
			goto yy415;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
			goto yy471;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		} else {
			if (yych <= 'E') goto yy520;
			if (yych != 'e') goto yy415;
		}
	}
yy520:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy521;
	if (yych != 'm') goto yy56;
yy521:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy522;
	if (yych != 'b') goto yy56;
yy522:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy523;
	if (yych != 'e') goto yy56;
yy523:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy479;
	if (yych == 'r') goto yy479;
	goto yy56;
yy524:
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy525;
	if (yych != 'p') goto yy56;
yy525:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy471;
			goto yy415;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
			goto yy471;
		}
	} else {
		if (yych <= 'S') {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		} else {
			if (yych <= 'T') goto yy526;
			if (yych != 't') goto yy415;
		}
	}
yy526:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy471;
			goto yy415;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
			goto yy471;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		} else {
			if (yych <= 'E') goto yy527;
			if (yych != 'e') goto yy415;
		}
	}
yy527:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy528;
	if (yych != 'm') goto yy56;
yy528:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy529;
	if (yych != 'b') goto yy56;
yy529:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy530;
	if (yych != 'e') goto yy56;
yy530:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy479;
	if (yych == 'r') goto yy479;
	goto yy56;
yy531:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy532;
		if (yych <= 'X') goto yy56;
		goto yy479;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
		} else {
			if (yych == 'y') goto yy479;
			goto yy56;
		}
	}
yy532:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy471;
			goto yy415;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
			goto yy471;
		}
	} else {
		if (yych <= 'B') {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		} else {
			if (yych <= 'C') goto yy533;
			if (yych != 'c') goto yy415;
		}
	}
yy533:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy479;
	if (yych == 'h') goto yy479;
	goto yy56;
yy534:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy535;
	if (yych != 'b') goto yy56;
yy535:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy471;
			goto yy415;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
			goto yy471;
		}
	} else {
		if (yych <= 'Q') {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		} else {
			if (yych <= 'R') goto yy536;
			if (yych != 'r') goto yy415;
		}
	}
yy536:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy537;
	if (yych != 'u') goto yy56;
yy537:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy538;
	if (yych != 'a') goto yy56;
yy538:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy539;
	if (yych != 'r') goto yy56;
yy539:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy479;
	if (yych == 'y') goto yy479;
	goto yy56;
yy540:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy547;
	if (yych <= '6') goto yy548;
	if (yych <= '9') goto yy549;
	goto yy56;
yy541:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy543:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy544:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	++YYCURSOR;
	{
		DEBUG_OUTPUT("pointed date YYYY");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
yy547:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy436;
	if (yych <= '/') goto yy430;
	if (yych <= '9') goto yy552;
	goto yy430;
yy548:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy436;
		goto yy430;
	} else {
		if (yych <= '0') goto yy552;
		if (yych <= '9') goto yy550;
		goto yy430;
	}
yy549:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy436;
	if (yych <= '/') goto yy430;
	if (yych >= ':') goto yy430;
yy550:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy551;
	if (yych <= '9') goto yy544;
yy551:
	{
		int length = 0;
		DEBUG_OUTPUT("pointed date YY");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 2, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
yy552:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy440;
			if (yych <= 0x1F) goto yy430;
			goto yy440;
		} else {
			if (yych == '.') goto yy436;
			if (yych <= '/') goto yy430;
			goto yy544;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy442;
			if (yych <= 'O') goto yy430;
			goto yy442;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy430;
				goto yy442;
			} else {
				if (yych == 'p') goto yy442;
				goto yy430;
			}
		}
	}
yy553:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy447;
			if (yych <= 0x1F) goto yy430;
			goto yy447;
		} else {
			if (yych == '.') goto yy432;
			if (yych <= '9') goto yy430;
			goto yy432;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy449;
			if (yych <= 'O') goto yy430;
			goto yy449;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy430;
				goto yy449;
			} else {
				if (yych == 'p') goto yy449;
				goto yy430;
			}
		}
	}
yy554:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy447;
			if (yych <= 0x1F) goto yy430;
			goto yy447;
		} else {
			if (yych <= '-') {
				if (yych <= ',') goto yy430;
				goto yy541;
			} else {
				if (yych <= '.') goto yy540;
				if (yych <= '9') goto yy430;
				goto yy432;
			}
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy449;
			if (yych <= 'O') goto yy430;
			goto yy449;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy430;
				goto yy449;
			} else {
				if (yych == 'p') goto yy449;
				goto yy430;
			}
		}
	}
yy555:
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy594;
		goto yy541;
	} else {
		if (yych <= '/') goto yy56;
		if (yych <= '9') goto yy557;
		goto yy56;
	}
yy556:
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy594;
		goto yy541;
	} else {
		if (yych <= '/') goto yy56;
		if (yych >= '3') goto yy56;
	}
yy557:
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '-') goto yy594;
	if (yych <= '.') goto yy541;
	goto yy56;
yy558:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy590;
		if (yych <= 'T') goto yy56;
		goto yy589;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy590;
		} else {
			if (yych == 'u') goto yy589;
			goto yy56;
		}
	}
yy559:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy587;
	if (yych == 'e') goto yy587;
	goto yy56;
yy560:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy584;
	if (yych == 'a') goto yy584;
	goto yy56;
yy561:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy581;
		if (yych <= 'T') goto yy56;
		goto yy580;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy581;
		} else {
			if (yych == 'u') goto yy580;
			goto yy56;
		}
	}
yy562:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy577;
	if (yych == 'e') goto yy577;
	goto yy56;
yy563:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy575;
	if (yych == 'c') goto yy575;
	goto yy56;
yy564:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy573;
	if (yych == 'o') goto yy573;
	goto yy56;
yy565:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy566;
	if (yych != 'e') goto yy56;
yy566:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy567;
	if (yych != 'c') goto yy56;
yy567:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy471;
			goto yy415;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
			if (yych >= '.') goto yy471;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		} else {
			if (yych <= 'E') goto yy520;
			if (yych == 'e') goto yy520;
			goto yy415;
		}
	}
yy568:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy472;
	if (yych <= '0') goto yy569;
	if (yych <= '2') goto yy570;
	if (yych <= '3') goto yy571;
	goto yy472;
yy569:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy474;
	if (yych <= '9') goto yy572;
	goto yy474;
yy570:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy474;
	if (yych <= '9') goto yy572;
	goto yy474;
yy571:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy474;
	if (yych <= '1') goto yy572;
	if (yych <= '9') goto yy480;
	goto yy474;
yy572:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy474;
	if (yych <= '9') goto yy481;
	goto yy474;
yy573:
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy574;
	if (yych != 'v') goto yy56;
yy574:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy471;
			goto yy415;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
			if (yych <= '-') goto yy568;
			goto yy471;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		} else {
			if (yych <= 'E') goto yy475;
			if (yych == 'e') goto yy475;
			goto yy415;
		}
	}
yy575:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy576;
	if (yych != 't') goto yy56;
yy576:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy471;
			goto yy415;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
			if (yych <= '-') goto yy568;
			goto yy471;
		}
	} else {
		if (yych <= 'N') {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		} else {
			if (yych <= 'O') goto yy485;
			if (yych == 'o') goto yy485;
			goto yy415;
		}
	}
yy577:
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy578;
	if (yych != 'p') goto yy56;
yy578:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy471;
			goto yy415;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
			if (yych <= '-') goto yy568;
			goto yy471;
		}
	} else {
		if (yych <= 'S') {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		} else {
			if (yych <= 'T') goto yy579;
			if (yych != 't') goto yy415;
		}
	}
yy579:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy471;
			goto yy415;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
			if (yych <= '-') goto yy568;
			goto yy471;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		} else {
			if (yych <= 'E') goto yy527;
			if (yych == 'e') goto yy527;
			goto yy415;
		}
	}
yy580:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy583;
	if (yych == 'g') goto yy583;
	goto yy56;
yy581:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy582;
	if (yych != 'r') goto yy56;
yy582:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy471;
			goto yy415;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
			if (yych <= '-') goto yy568;
			goto yy471;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		} else {
			if (yych <= 'I') goto yy491;
			if (yych == 'i') goto yy491;
			goto yy415;
		}
	}
yy583:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy471;
			goto yy415;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
			if (yych <= '-') goto yy568;
			goto yy471;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		} else {
			if (yych <= 'U') goto yy493;
			if (yych == 'u') goto yy493;
			goto yy415;
		}
	}
yy584:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy585;
		if (yych <= 'X') goto yy56;
		goto yy586;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
		} else {
			if (yych == 'y') goto yy586;
			goto yy56;
		}
	}
yy585:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy471;
			goto yy415;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
			if (yych <= '-') goto yy568;
			goto yy471;
		}
	} else {
		if (yych <= 'B') {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		} else {
			if (yych <= 'C') goto yy533;
			if (yych == 'c') goto yy533;
			goto yy415;
		}
	}
yy586:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy415;
			goto yy471;
		} else {
			if (yych == ' ') goto yy471;
			goto yy415;
		}
	} else {
		if (yych <= '.') {
			if (yych <= '-') goto yy568;
			goto yy471;
		} else {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		}
	}
yy587:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy588;
	if (yych != 'b') goto yy56;
yy588:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy471;
			goto yy415;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
			if (yych <= '-') goto yy568;
			goto yy471;
		}
	} else {
		if (yych <= 'Q') {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		} else {
			if (yych <= 'R') goto yy536;
			if (yych == 'r') goto yy536;
			goto yy415;
		}
	}
yy589:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy593;
		if (yych <= 'M') goto yy56;
		goto yy592;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy593;
		} else {
			if (yych == 'n') goto yy592;
			goto yy56;
		}
	}
yy590:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy591;
	if (yych != 'n') goto yy56;
yy591:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy471;
			goto yy415;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
			if (yych <= '-') goto yy568;
			goto yy471;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		} else {
			if (yych <= 'U') goto yy498;
			if (yych == 'u') goto yy498;
			goto yy415;
		}
	}
yy592:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy471;
			goto yy415;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
			if (yych <= '-') goto yy568;
			goto yy471;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		} else {
			if (yych <= 'E') goto yy479;
			if (yych == 'e') goto yy479;
			goto yy415;
		}
	}
yy593:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy471;
			goto yy415;
		} else {
			if (yych <= ' ') goto yy471;
			if (yych <= ',') goto yy415;
			if (yych <= '-') goto yy568;
			goto yy471;
		}
	} else {
		if (yych <= 'X') {
			if (yych <= '/') goto yy415;
			if (yych <= '9') goto yy473;
			goto yy415;
		} else {
			if (yych <= 'Y') goto yy479;
			if (yych == 'y') goto yy479;
			goto yy415;
		}
	}
yy594:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy595;
	if (yych <= '3') goto yy597;
	if (yych <= '9') goto yy598;
	goto yy56;
yy595:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy596;
		if (yych <= '9') goto yy604;
		if (yych >= 'n') goto yy600;
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy601;
		} else {
			if (yych <= 's') goto yy599;
			if (yych <= 't') goto yy602;
		}
	}
yy596:
	{
		int length = 0;
		DEBUG_OUTPUT("gnudateshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
yy597:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '1') {
			if (yych <= '/') goto yy596;
			goto yy604;
		} else {
			if (yych <= '9') goto yy543;
			if (yych <= 'm') goto yy596;
			goto yy600;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy596;
			goto yy601;
		} else {
			if (yych <= 's') goto yy599;
			if (yych <= 't') goto yy602;
			goto yy596;
		}
	}
yy598:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy596;
		if (yych <= '9') goto yy543;
		if (yych <= 'm') goto yy596;
		goto yy600;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy596;
			goto yy601;
		} else {
			if (yych <= 's') goto yy599;
			if (yych <= 't') goto yy602;
			goto yy596;
		}
	}
yy599:
	yych = *++YYCURSOR;
	if (yych == 't') goto yy603;
	goto yy56;
yy600:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy603;
	goto yy56;
yy601:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy603;
	goto yy56;
yy602:
	yych = *++YYCURSOR;
	if (yych != 'h') goto yy56;
yy603:
	yych = *++YYCURSOR;
	goto yy596;
yy604:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy596;
		if (yych <= '9') goto yy544;
		if (yych <= 'm') goto yy596;
		goto yy600;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy596;
			goto yy601;
		} else {
			if (yych <= 's') goto yy599;
			if (yych <= 't') goto yy602;
			goto yy596;
		}
	}
yy605:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') {
			if (yych >= '/') goto yy662;
		} else {
			if (yych <= '9') goto yy608;
			if (yych >= 'n') goto yy659;
		}
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy660;
		} else {
			if (yych <= 's') goto yy658;
			if (yych <= 't') goto yy661;
		}
	}
yy606:
	{
		int length = 0;
		DEBUG_OUTPUT("americanshort | american");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '/') {
			s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
			TIMELIB_PROCESS_YEAR(s->time->y, length);
		}
		TIMELIB_DEINIT;
		return TIMELIB_AMERICAN;
	}
yy607:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') {
			if (yych <= '.') goto yy606;
			goto yy662;
		} else {
			if (yych <= '1') goto yy608;
			if (yych <= 'm') goto yy606;
			goto yy659;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy606;
			goto yy660;
		} else {
			if (yych <= 's') goto yy658;
			if (yych <= 't') goto yy661;
			goto yy606;
		}
	}
yy608:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == '/') goto yy662;
		if (yych <= 'm') goto yy606;
		goto yy659;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy606;
			goto yy660;
		} else {
			if (yych <= 's') goto yy658;
			if (yych <= 't') goto yy661;
			goto yy606;
		}
	}
yy609:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy657;
		if (yych <= 'T') goto yy56;
		goto yy656;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy657;
		} else {
			if (yych == 'u') goto yy656;
			goto yy56;
		}
	}
yy610:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy655;
	if (yych == 'e') goto yy655;
	goto yy56;
yy611:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy654;
	if (yych == 'a') goto yy654;
	goto yy56;
yy612:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy653;
		if (yych <= 'T') goto yy56;
		goto yy652;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy653;
		} else {
			if (yych == 'u') goto yy652;
			goto yy56;
		}
	}
yy613:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy650;
	if (yych == 'e') goto yy650;
	goto yy56;
yy614:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy649;
	if (yych == 'c') goto yy649;
	goto yy56;
yy615:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy648;
	if (yych == 'o') goto yy648;
	goto yy56;
yy616:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy617;
	if (yych != 'e') goto yy56;
yy617:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy618;
	if (yych != 'c') goto yy56;
yy618:
	yych = *++YYCURSOR;
	if (yych != '/') goto yy56;
yy619:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy625;
	if (yych <= '2') goto yy626;
	goto yy56;
yy625:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy627;
	goto yy56;
yy626:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '5') goto yy56;
yy627:
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '6') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy632;
	if (yych <= '6') goto yy633;
	goto yy56;
yy632:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy634;
	goto yy56;
yy633:
	yych = *++YYCURSOR;
	if (yych != '0') goto yy56;
yy634:
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy635;
	if (yych != ' ') goto yy56;
yy635:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
	if (yych <= '*') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy56;
			goto yy635;
		} else {
			if (yych == ' ') goto yy635;
			goto yy56;
		}
	} else {
		if (yych <= '-') {
			if (yych == ',') goto yy56;
			goto yy638;
		} else {
			if (yych != 'G') goto yy56;
		}
	}
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy646;
	goto yy56;
yy638:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy639;
	if (yych <= '2') goto yy641;
	if (yych <= '9') goto yy642;
	goto yy56;
yy639:
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '/') goto yy640;
	if (yych <= '9') goto yy642;
	if (yych <= ':') goto yy643;
yy640:
	{
		int tz_not_found;
		DEBUG_OUTPUT("clf");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
		if (tz_not_found) {
			add_error(s, "The timezone could not be found in the database");
		}
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
yy641:
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy640;
		if (yych >= '5') goto yy644;
	} else {
		if (yych <= '9') goto yy645;
		if (yych <= ':') goto yy643;
		goto yy640;
	}
yy642:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy640;
	if (yych <= '5') goto yy644;
	if (yych <= '9') goto yy645;
	if (yych >= ';') goto yy640;
yy643:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy640;
	if (yych <= '5') goto yy644;
	if (yych <= '9') goto yy645;
	goto yy640;
yy644:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy640;
	if (yych >= ':') goto yy640;
yy645:
	yych = *++YYCURSOR;
	goto yy640;
yy646:
	yych = *++YYCURSOR;
	if (yych != 'T') goto yy56;
	yych = *++YYCURSOR;
	if (yych == '+') goto yy638;
	if (yych == '-') goto yy638;
	goto yy56;
yy648:
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy618;
	if (yych == 'v') goto yy618;
	goto yy56;
yy649:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy618;
	if (yych == 't') goto yy618;
	goto yy56;
yy650:
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy651;
	if (yych != 'p') goto yy56;
yy651:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == '/') goto yy619;
		goto yy56;
	} else {
		if (yych <= 'T') goto yy618;
		if (yych == 't') goto yy618;
		goto yy56;
	}
yy652:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy618;
	if (yych == 'g') goto yy618;
	goto yy56;
yy653:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy618;
	if (yych == 'r') goto yy618;
	goto yy56;
yy654:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy618;
		if (yych <= 'X') goto yy56;
		goto yy618;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
			goto yy618;
		} else {
			if (yych == 'y') goto yy618;
			goto yy56;
		}
	}
yy655:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy618;
	if (yych == 'b') goto yy618;
	goto yy56;
yy656:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy618;
		if (yych <= 'M') goto yy56;
		goto yy618;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy618;
		} else {
			if (yych == 'n') goto yy618;
			goto yy56;
		}
	}
yy657:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy618;
	if (yych == 'n') goto yy618;
	goto yy56;
yy658:
	yych = *++YYCURSOR;
	if (yych == 't') goto yy667;
	goto yy56;
yy659:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy667;
	goto yy56;
yy660:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy667;
	goto yy56;
yy661:
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy667;
	goto yy56;
yy662:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy606;
	if (yych >= ':') goto yy606;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy606;
	if (yych >= ':') goto yy606;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy606;
	if (yych >= ':') goto yy606;
	yych = *++YYCURSOR;
	goto yy606;
yy667:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '/') goto yy662;
	goto yy606;
yy668:
	yych = *++YYCURSOR;
	if (yych <= ',') {
		if (yych == '\t') goto yy670;
		goto yy517;
	} else {
		if (yych <= '-') goto yy671;
		if (yych <= '.') goto yy670;
		if (yych >= '0') goto yy517;
	}
yy669:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy612;
	case 'D':
	case 'd':	goto yy616;
	case 'F':
	case 'f':	goto yy610;
	case 'J':
	case 'j':	goto yy609;
	case 'M':
	case 'm':	goto yy611;
	case 'N':
	case 'n':	goto yy615;
	case 'O':
	case 'o':	goto yy614;
	case 'S':
	case 's':	goto yy613;
	default:	goto yy56;
	}
yy670:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy517;
	if (yych <= '0') goto yy675;
	if (yych <= '1') goto yy676;
	if (yych <= '9') goto yy677;
	goto yy517;
yy671:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy517;
	if (yych <= '0') goto yy672;
	if (yych <= '1') goto yy673;
	if (yych <= '9') goto yy674;
	goto yy517;
yy672:
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '.') goto yy541;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy674;
	goto yy56;
yy673:
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '.') goto yy541;
	if (yych <= '/') goto yy56;
	if (yych >= '3') goto yy56;
yy674:
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '.') goto yy541;
	goto yy56;
yy675:
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy541;
		goto yy678;
	} else {
		if (yych <= '/') goto yy56;
		if (yych <= '9') goto yy677;
		goto yy56;
	}
yy676:
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy541;
		goto yy678;
	} else {
		if (yych <= '/') goto yy56;
		if (yych >= '3') goto yy56;
	}
yy677:
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '-') goto yy541;
	if (yych >= '/') goto yy56;
yy678:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy550;
	goto yy56;
yy680:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy724;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy722;
	goto yy60;
yy681:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy690;
	case '1':	goto yy691;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy692;
	case 'A':
	case 'a':	goto yy685;
	case 'D':
	case 'd':	goto yy689;
	case 'F':
	case 'f':	goto yy683;
	case 'J':
	case 'j':	goto yy682;
	case 'M':
	case 'm':	goto yy684;
	case 'N':
	case 'n':	goto yy688;
	case 'O':
	case 'o':	goto yy687;
	case 'S':
	case 's':	goto yy686;
	default:	goto yy56;
	}
yy682:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy721;
		if (yych <= 'T') goto yy56;
		goto yy720;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy721;
		} else {
			if (yych == 'u') goto yy720;
			goto yy56;
		}
	}
yy683:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy719;
	if (yych == 'e') goto yy719;
	goto yy56;
yy684:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy718;
	if (yych == 'a') goto yy718;
	goto yy56;
yy685:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy717;
		if (yych <= 'T') goto yy56;
		goto yy716;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy717;
		} else {
			if (yych == 'u') goto yy716;
			goto yy56;
		}
	}
yy686:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy714;
	if (yych == 'e') goto yy714;
	goto yy56;
yy687:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy713;
	if (yych == 'c') goto yy713;
	goto yy56;
yy688:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy712;
	if (yych == 'o') goto yy712;
	goto yy56;
yy689:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy704;
	if (yych == 'e') goto yy704;
	goto yy56;
yy690:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy693;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy697;
	goto yy56;
yy691:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy693;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy697;
	goto yy56;
yy692:
	yych = *++YYCURSOR;
	if (yych != '-') goto yy56;
yy693:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy694;
	if (yych <= '3') goto yy695;
	if (yych <= '9') goto yy696;
	goto yy56;
yy694:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy596;
		if (yych <= '9') goto yy696;
		if (yych <= 'm') goto yy596;
		goto yy600;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy596;
			goto yy601;
		} else {
			if (yych <= 's') goto yy599;
			if (yych <= 't') goto yy602;
			goto yy596;
		}
	}
yy695:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy596;
		if (yych <= '1') goto yy696;
		if (yych <= 'm') goto yy596;
		goto yy600;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy596;
			goto yy601;
		} else {
			if (yych <= 's') goto yy599;
			if (yych <= 't') goto yy602;
			goto yy596;
		}
	}
yy696:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy600;
		goto yy596;
	} else {
		if (yych <= 'r') goto yy601;
		if (yych <= 's') goto yy599;
		if (yych <= 't') goto yy602;
		goto yy596;
	}
yy697:
	yych = *++YYCURSOR;
	if (yych != '-') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy56;
		if (yych >= '1') goto yy700;
	} else {
		if (yych <= '3') goto yy701;
		if (yych <= '9') goto yy696;
		goto yy56;
	}
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy596;
		if (yych <= '9') goto yy702;
		if (yych <= 'm') goto yy596;
		goto yy600;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy596;
			goto yy601;
		} else {
			if (yych <= 's') goto yy599;
			if (yych <= 't') goto yy602;
			goto yy596;
		}
	}
yy700:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy596;
		if (yych <= '9') goto yy702;
		if (yych <= 'm') goto yy596;
		goto yy600;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy596;
			goto yy601;
		} else {
			if (yych <= 's') goto yy599;
			if (yych <= 't') goto yy602;
			goto yy596;
		}
	}
yy701:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy596;
		if (yych <= '1') goto yy702;
		if (yych <= 'm') goto yy596;
		goto yy600;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy596;
			goto yy601;
		} else {
			if (yych <= 's') goto yy599;
			if (yych <= 't') goto yy602;
			goto yy596;
		}
	}
yy702:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy600;
	} else {
		if (yych <= 'r') goto yy601;
		if (yych <= 's') goto yy599;
		if (yych <= 't') goto yy602;
	}
yy703:
	{
		int length = 0;
		DEBUG_OUTPUT("iso8601date2");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
yy704:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy705;
	if (yych != 'c') goto yy56;
yy705:
	yych = *++YYCURSOR;
	if (yych != '-') goto yy56;
yy706:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy707;
	if (yych <= '2') goto yy708;
	if (yych <= '3') goto yy709;
	goto yy56;
yy707:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy710;
	goto yy56;
yy708:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy710;
	goto yy56;
yy709:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '2') goto yy56;
yy710:
	++YYCURSOR;
	{
		int length = 0;
		DEBUG_OUTPUT("pgtextreverse");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
yy712:
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy705;
	if (yych == 'v') goto yy705;
	goto yy56;
yy713:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy705;
	if (yych == 't') goto yy705;
	goto yy56;
yy714:
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy715;
	if (yych != 'p') goto yy56;
yy715:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == '-') goto yy706;
		goto yy56;
	} else {
		if (yych <= 'T') goto yy705;
		if (yych == 't') goto yy705;
		goto yy56;
	}
yy716:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy705;
	if (yych == 'g') goto yy705;
	goto yy56;
yy717:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy705;
	if (yych == 'r') goto yy705;
	goto yy56;
yy718:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy705;
		if (yych <= 'X') goto yy56;
		goto yy705;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
			goto yy705;
		} else {
			if (yych == 'y') goto yy705;
			goto yy56;
		}
	}
yy719:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy705;
	if (yych == 'b') goto yy705;
	goto yy56;
yy720:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy705;
		if (yych <= 'M') goto yy56;
		goto yy705;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy705;
		} else {
			if (yych == 'n') goto yy705;
			goto yy56;
		}
	}
yy721:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy705;
	if (yych == 'n') goto yy705;
	goto yy56;
yy722:
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'n':
	case 'o':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy730;
	case '-':	goto yy727;
	case '.':	goto yy731;
	case '/':	goto yy728;
	case '0':	goto yy744;
	case '1':	goto yy745;
	case '2':	goto yy747;
	case '3':	goto yy748;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy54;
	case ':':	goto yy746;
	case 'W':	goto yy749;
	default:	goto yy723;
	}
yy723:
	{
		DEBUG_OUTPUT("year4");
		TIMELIB_INIT;
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
yy724:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy725;
	case '1':	goto yy726;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy692;
	case 'A':
	case 'a':	goto yy685;
	case 'D':
	case 'd':	goto yy689;
	case 'F':
	case 'f':	goto yy683;
	case 'J':
	case 'j':	goto yy682;
	case 'M':
	case 'm':	goto yy684;
	case 'N':
	case 'n':	goto yy688;
	case 'O':
	case 'o':	goto yy687;
	case 'S':
	case 's':	goto yy686;
	default:	goto yy56;
	}
yy725:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy693;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy692;
	goto yy56;
yy726:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy693;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy692;
	goto yy56;
yy727:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy912;
	case '1':	goto yy914;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy915;
	case 'A':
	case 'a':	goto yy906;
	case 'D':
	case 'd':	goto yy910;
	case 'F':
	case 'f':	goto yy904;
	case 'J':
	case 'j':	goto yy903;
	case 'M':
	case 'm':	goto yy905;
	case 'N':
	case 'n':	goto yy909;
	case 'O':
	case 'o':	goto yy908;
	case 'S':
	case 's':	goto yy907;
	case 'W':	goto yy911;
	default:	goto yy878;
	}
yy728:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy886;
	if (yych <= '1') goto yy887;
	if (yych <= '9') goto yy888;
	goto yy56;
yy729:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy730:
	switch (yych) {
	case '\t':
	case ' ':	goto yy729;
	case '-':
	case '.':	goto yy877;
	case 'A':
	case 'a':	goto yy739;
	case 'D':
	case 'd':	goto yy743;
	case 'F':
	case 'f':	goto yy737;
	case 'H':
	case 'h':	goto yy63;
	case 'I':	goto yy732;
	case 'J':
	case 'j':	goto yy736;
	case 'M':
	case 'm':	goto yy738;
	case 'N':
	case 'n':	goto yy742;
	case 'O':
	case 'o':	goto yy741;
	case 'S':
	case 's':	goto yy740;
	case 'T':
	case 't':	goto yy68;
	case 'V':	goto yy734;
	case 'W':
	case 'w':	goto yy67;
	case 'X':	goto yy735;
	case 'Y':
	case 'y':	goto yy66;
	default:	goto yy56;
	}
yy731:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy878;
	if (yych <= '0') goto yy870;
	if (yych <= '2') goto yy871;
	if (yych <= '3') goto yy872;
	goto yy878;
yy732:
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= 'U') {
		if (yych == 'I') goto yy869;
	} else {
		if (yych == 'W') goto yy733;
		if (yych <= 'X') goto yy823;
	}
yy733:
	{
		int length = 0;
		DEBUG_OUTPUT("datenodayrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
yy734:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy867;
	goto yy733;
yy735:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy866;
	goto yy733;
yy736:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy859;
		if (yych <= 'T') goto yy56;
		goto yy858;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy859;
		} else {
			if (yych == 'u') goto yy858;
			goto yy56;
		}
	}
yy737:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'N') {
			if (yych == 'E') goto yy852;
			goto yy56;
		} else {
			if (yych <= 'O') goto yy98;
			if (yych <= 'Q') goto yy56;
			goto yy97;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'e') goto yy852;
			goto yy56;
		} else {
			if (yych <= 'o') goto yy98;
			if (yych == 'r') goto yy97;
			goto yy56;
		}
	}
yy738:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'H') {
			if (yych == 'A') goto yy849;
			goto yy56;
		} else {
			if (yych <= 'I') goto yy117;
			if (yych <= 'N') goto yy56;
			goto yy116;
		}
	} else {
		if (yych <= 'h') {
			if (yych == 'a') goto yy849;
			goto yy56;
		} else {
			if (yych <= 'i') goto yy117;
			if (yych == 'o') goto yy116;
			goto yy56;
		}
	}
yy739:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy843;
		if (yych <= 'T') goto yy56;
		goto yy842;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy843;
		} else {
			if (yych == 'u') goto yy842;
			goto yy56;
		}
	}
yy740:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy126;
			goto yy56;
		} else {
			if (yych <= 'E') goto yy835;
			if (yych <= 'T') goto yy56;
			goto yy125;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy126;
			goto yy56;
		} else {
			if (yych <= 'e') goto yy835;
			if (yych == 'u') goto yy125;
			goto yy56;
		}
	}
yy741:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy830;
	if (yych == 'c') goto yy830;
	goto yy56;
yy742:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy824;
	if (yych == 'o') goto yy824;
	goto yy56;
yy743:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych == 'A') goto yy113;
		if (yych <= 'D') goto yy56;
		goto yy817;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy113;
		} else {
			if (yych == 'e') goto yy817;
			goto yy56;
		}
	}
yy744:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '0') goto yy814;
	if (yych <= '9') goto yy815;
	goto yy60;
yy745:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '2') goto yy783;
	if (yych <= '9') goto yy762;
	goto yy60;
yy746:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy763;
	if (yych <= '1') goto yy764;
	goto yy56;
yy747:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy762;
	goto yy60;
yy748:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '5') goto yy758;
	if (yych <= '6') goto yy759;
	if (yych <= '9') goto yy54;
	goto yy60;
yy749:
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy56;
		if (yych <= '0') goto yy750;
		if (yych <= '4') goto yy751;
		goto yy752;
	} else {
		if (yych <= 'E') {
			if (yych <= 'D') goto yy56;
			goto yy82;
		} else {
			if (yych == 'e') goto yy82;
			goto yy56;
		}
	}
yy750:
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy56;
	if (yych <= '9') goto yy753;
	goto yy56;
yy751:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy753;
	goto yy56;
yy752:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '4') goto yy56;
yy753:
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy755;
	if (yych <= '/') goto yy754;
	if (yych <= '7') goto yy756;
yy754:
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweek");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();

		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = 1;
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
yy755:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '8') goto yy56;
yy756:
	++YYCURSOR;
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweekday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();

		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = timelib_get_nr((char **) &ptr, 1);
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
yy758:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy760;
	goto yy60;
yy759:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '6') goto yy760;
	if (yych <= '9') goto yy54;
	goto yy60;
yy760:
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych >= ' ') goto yy60;
			} else {
				if (yych == 'D') goto yy60;
				if (yych >= 'F') goto yy60;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy60;
				if (yych >= 'M') goto yy60;
			} else {
				if (yych <= 'R') goto yy761;
				if (yych <= 'T') goto yy60;
				if (yych >= 'W') goto yy60;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy60;
				if (yych >= 'd') goto yy60;
			} else {
				if (yych == 'f') goto yy60;
				if (yych >= 'h') goto yy60;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych >= 's') goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych >= 'w') goto yy60;
				} else {
					if (yych == 'y') goto yy60;
				}
			}
		}
	}
yy761:
	{
		int length = 0;
		DEBUG_OUTPUT("pgydotd");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->d = timelib_get_nr((char **) &ptr, 3);
		s->time->m = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_PG_YEARDAY;
	}
yy762:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy760;
	goto yy60;
yy763:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy765;
	goto yy56;
yy764:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '3') goto yy56;
yy765:
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy767;
	if (yych <= '2') goto yy768;
	if (yych <= '3') goto yy769;
	goto yy56;
yy767:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy770;
	goto yy56;
yy768:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy770;
	goto yy56;
yy769:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '2') goto yy56;
yy770:
	yych = *++YYCURSOR;
	if (yych != ' ') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy772;
	if (yych <= '2') goto yy773;
	goto yy56;
yy772:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy774;
	goto yy56;
yy773:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '5') goto yy56;
yy774:
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '6') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy779;
	if (yych <= '6') goto yy780;
	goto yy56;
yy779:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy781;
	goto yy56;
yy780:
	yych = *++YYCURSOR;
	if (yych != '0') goto yy56;
yy781:
	++YYCURSOR;
yy782:
	{
		int tz_not_found;
		DEBUG_OUTPUT("xmlrpc | xmlrpcnocolon | soap | wddx | exif");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '.') {
			s->time->f = timelib_get_frac_nr((char **) &ptr, 9);
			if (*ptr) { /* timezone is optional */
				s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
				if (tz_not_found) {
					add_error(s, "The timezone could not be found in the database");
				}
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_XMLRPC_SOAP;
	}
yy783:
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy60;
		if (yych >= '1') goto yy785;
	} else {
		if (yych <= '3') goto yy786;
		if (yych <= '9') goto yy760;
		goto yy60;
	}
yy784:
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy761;
				goto yy60;
			} else {
				if (yych <= '/') goto yy761;
				if (yych <= '9') goto yy787;
				if (yych <= 'C') goto yy761;
				goto yy60;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy60;
				if (yych <= 'G') goto yy761;
				goto yy60;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy761;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy761;
					if (yych <= 'T') goto yy60;
					goto yy761;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy761;
				if (yych <= 'Y') goto yy60;
				goto yy761;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy60;
					goto yy761;
				} else {
					if (yych == 'g') goto yy761;
					goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych <= 'r') goto yy761;
				goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy761;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy761;
				}
			}
		}
	}
yy785:
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy761;
				goto yy60;
			} else {
				if (yych <= '/') goto yy761;
				if (yych <= '9') goto yy787;
				if (yych <= 'C') goto yy761;
				goto yy60;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy60;
				if (yych <= 'G') goto yy761;
				goto yy60;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy761;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy761;
					if (yych <= 'T') goto yy60;
					goto yy761;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy761;
				if (yych <= 'Y') goto yy60;
				goto yy761;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy60;
					goto yy761;
				} else {
					if (yych == 'g') goto yy761;
					goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych <= 'r') goto yy761;
				goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy761;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy761;
				}
			}
		}
	}
yy786:
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy761;
				goto yy60;
			} else {
				if (yych <= '1') {
					if (yych <= '/') goto yy761;
				} else {
					if (yych <= '9') goto yy54;
					if (yych <= 'C') goto yy761;
					goto yy60;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy60;
				if (yych <= 'G') goto yy761;
				goto yy60;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy761;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy761;
					if (yych <= 'T') goto yy60;
					goto yy761;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy761;
				if (yych <= 'Y') goto yy60;
				goto yy761;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy60;
					goto yy761;
				} else {
					if (yych == 'g') goto yy761;
					goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych <= 'r') goto yy761;
				goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy761;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy761;
				}
			}
		}
	}
yy787:
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych >= ' ') goto yy59;
			} else {
				if (yych == 'D') goto yy64;
				if (yych >= 'F') goto yy65;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy63;
				if (yych >= 'M') goto yy62;
			} else {
				if (yych <= 'S') {
					if (yych >= 'S') goto yy61;
				} else {
					if (yych <= 'T') goto yy789;
					if (yych >= 'W') goto yy67;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy66;
				if (yych >= 'd') goto yy64;
			} else {
				if (yych <= 'f') {
					if (yych >= 'f') goto yy65;
				} else {
					if (yych == 'h') goto yy63;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy62;
				if (yych <= 'r') goto yy788;
				if (yych <= 's') goto yy61;
				goto yy790;
			} else {
				if (yych <= 'w') {
					if (yych >= 'w') goto yy67;
				} else {
					if (yych == 'y') goto yy66;
				}
			}
		}
	}
yy788:
	{
		DEBUG_OUTPUT("datenocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NOCOLON;
	}
yy789:
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= '2') {
			if (yych <= '/') goto yy56;
			if (yych <= '1') goto yy804;
			goto yy805;
		} else {
			if (yych <= '9') goto yy806;
			if (yych <= 'G') goto yy56;
			goto yy69;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'U') goto yy70;
			goto yy56;
		} else {
			if (yych <= 'h') goto yy69;
			if (yych == 'u') goto yy70;
			goto yy56;
		}
	}
yy790:
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= '2') {
			if (yych <= '/') goto yy56;
			if (yych >= '2') goto yy792;
		} else {
			if (yych <= '9') goto yy793;
			if (yych <= 'G') goto yy56;
			goto yy69;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'U') goto yy70;
			goto yy56;
		} else {
			if (yych <= 'h') goto yy69;
			if (yych == 'u') goto yy70;
			goto yy56;
		}
	}
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy798;
	if (yych <= '9') goto yy793;
	goto yy56;
yy792:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '4') goto yy798;
	if (yych <= '5') goto yy794;
	goto yy56;
yy793:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '6') goto yy56;
yy794:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy795:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy796;
	if (yych <= '6') goto yy797;
	goto yy56;
yy796:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy781;
	goto yy56;
yy797:
	yych = *++YYCURSOR;
	if (yych == '0') goto yy781;
	goto yy56;
yy798:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy799;
	if (yych <= '9') goto yy795;
	goto yy56;
yy799:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy800;
	if (yych <= '6') goto yy801;
	if (yych <= '9') goto yy795;
	goto yy56;
yy800:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy802;
	if (yych <= '6') goto yy803;
	if (yych <= '9') goto yy781;
	goto yy56;
yy801:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy802;
	if (yych <= '5') goto yy796;
	if (yych <= '6') goto yy797;
	goto yy56;
yy802:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy782;
	if (yych <= '9') goto yy781;
	goto yy782;
yy803:
	yych = *++YYCURSOR;
	if (yych == '0') goto yy781;
	goto yy782;
yy804:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy813;
	if (yych <= '9') goto yy806;
	if (yych <= ':') goto yy807;
	goto yy56;
yy805:
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy56;
		if (yych <= '4') goto yy813;
		goto yy794;
	} else {
		if (yych == ':') goto yy807;
		goto yy56;
	}
yy806:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy794;
	if (yych != ':') goto yy56;
yy807:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '6') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy811;
	if (yych <= '6') goto yy812;
	goto yy56;
yy811:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy781;
	goto yy56;
yy812:
	yych = *++YYCURSOR;
	if (yych == '0') goto yy781;
	goto yy56;
yy813:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy799;
	if (yych <= '9') goto yy795;
	if (yych <= ':') goto yy807;
	goto yy56;
yy814:
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy60;
		if (yych <= '0') goto yy816;
		goto yy785;
	} else {
		if (yych <= '3') goto yy786;
		if (yych <= '9') goto yy760;
		goto yy60;
	}
yy815:
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy60;
		if (yych <= '0') goto yy784;
		goto yy785;
	} else {
		if (yych <= '3') goto yy786;
		if (yych <= '9') goto yy760;
		goto yy60;
	}
yy816:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy787;
	goto yy60;
yy817:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy818;
	if (yych != 'c') goto yy56;
yy818:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy819;
	if (yych != 'e') goto yy733;
yy819:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy820;
	if (yych != 'm') goto yy56;
yy820:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy821;
	if (yych != 'b') goto yy56;
yy821:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy822;
	if (yych != 'e') goto yy56;
yy822:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy823;
	if (yych != 'r') goto yy56;
yy823:
	yych = *++YYCURSOR;
	goto yy733;
yy824:
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy825;
	if (yych != 'v') goto yy56;
yy825:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy826;
	if (yych != 'e') goto yy733;
yy826:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy827;
	if (yych != 'm') goto yy56;
yy827:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy828;
	if (yych != 'b') goto yy56;
yy828:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy829;
	if (yych != 'e') goto yy56;
yy829:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy823;
	if (yych == 'r') goto yy823;
	goto yy56;
yy830:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy831;
	if (yych != 't') goto yy56;
yy831:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'O') goto yy832;
	if (yych != 'o') goto yy733;
yy832:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy833;
	if (yych != 'b') goto yy56;
yy833:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy834;
	if (yych != 'e') goto yy56;
yy834:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy823;
	if (yych == 'r') goto yy823;
	goto yy56;
yy835:
	yych = *++YYCURSOR;
	if (yych <= 'P') {
		if (yych == 'C') goto yy128;
		if (yych <= 'O') goto yy56;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy56;
			goto yy128;
		} else {
			if (yych != 'p') goto yy56;
		}
	}
yy836:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy837;
	if (yych != 't') goto yy733;
yy837:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy838;
	if (yych != 'e') goto yy733;
yy838:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy839;
	if (yych != 'm') goto yy56;
yy839:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy840;
	if (yych != 'b') goto yy56;
yy840:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy841;
	if (yych != 'e') goto yy56;
yy841:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy823;
	if (yych == 'r') goto yy823;
	goto yy56;
yy842:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy846;
	if (yych == 'g') goto yy846;
	goto yy56;
yy843:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy844;
	if (yych != 'r') goto yy56;
yy844:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'I') goto yy845;
	if (yych != 'i') goto yy733;
yy845:
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy823;
	if (yych == 'l') goto yy823;
	goto yy56;
yy846:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy847;
	if (yych != 'u') goto yy733;
yy847:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy848;
	if (yych != 's') goto yy56;
yy848:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy823;
	if (yych == 't') goto yy823;
	goto yy56;
yy849:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy850;
		if (yych <= 'X') goto yy56;
		goto yy823;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
		} else {
			if (yych == 'y') goto yy823;
			goto yy56;
		}
	}
yy850:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'C') goto yy851;
	if (yych != 'c') goto yy733;
yy851:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy823;
	if (yych == 'h') goto yy823;
	goto yy56;
yy852:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy853;
	if (yych != 'b') goto yy56;
yy853:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy854;
	if (yych != 'r') goto yy733;
yy854:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy855;
	if (yych != 'u') goto yy56;
yy855:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy856;
	if (yych != 'a') goto yy56;
yy856:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy857;
	if (yych != 'r') goto yy56;
yy857:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy823;
	if (yych == 'y') goto yy823;
	goto yy56;
yy858:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy865;
		if (yych <= 'M') goto yy56;
		goto yy864;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy865;
		} else {
			if (yych == 'n') goto yy864;
			goto yy56;
		}
	}
yy859:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy860;
	if (yych != 'n') goto yy56;
yy860:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy861;
	if (yych != 'u') goto yy733;
yy861:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy862;
	if (yych != 'a') goto yy56;
yy862:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy863;
	if (yych != 'r') goto yy56;
yy863:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy823;
	if (yych == 'y') goto yy823;
	goto yy56;
yy864:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy823;
	if (yych == 'e') goto yy823;
	goto yy733;
yy865:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy823;
	if (yych == 'y') goto yy823;
	goto yy733;
yy866:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy823;
	goto yy733;
yy867:
	yych = *++YYCURSOR;
	if (yych != 'I') goto yy733;
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy823;
	goto yy733;
yy869:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy823;
	goto yy733;
yy870:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy885;
	if (yych <= '9') goto yy884;
	goto yy56;
yy871:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy883;
	goto yy56;
yy872:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy881;
	if (yych <= '6') goto yy880;
	goto yy56;
yy873:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy852;
	if (yych == 'e') goto yy852;
	goto yy56;
yy874:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy849;
	if (yych == 'a') goto yy849;
	goto yy56;
yy875:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy879;
	if (yych == 'e') goto yy879;
	goto yy56;
yy876:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy817;
	if (yych == 'e') goto yy817;
	goto yy56;
yy877:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy878:
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy877;
	case 'A':
	case 'a':	goto yy739;
	case 'D':
	case 'd':	goto yy876;
	case 'F':
	case 'f':	goto yy873;
	case 'I':	goto yy732;
	case 'J':
	case 'j':	goto yy736;
	case 'M':
	case 'm':	goto yy874;
	case 'N':
	case 'n':	goto yy742;
	case 'O':
	case 'o':	goto yy741;
	case 'S':
	case 's':	goto yy875;
	case 'V':	goto yy734;
	case 'X':	goto yy735;
	default:	goto yy56;
	}
yy879:
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy836;
	if (yych == 'p') goto yy836;
	goto yy56;
yy880:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '6') goto yy882;
	goto yy56;
yy881:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy882:
	yych = *++YYCURSOR;
	goto yy761;
yy883:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy882;
	goto yy56;
yy884:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy882;
	goto yy56;
yy885:
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy56;
	if (yych <= '9') goto yy882;
	goto yy56;
yy886:
	yych = *++YYCURSOR;
	if (yych <= '.') goto yy56;
	if (yych <= '/') goto yy889;
	if (yych <= '9') goto yy897;
	goto yy56;
yy887:
	yych = *++YYCURSOR;
	if (yych <= '.') goto yy56;
	if (yych <= '/') goto yy889;
	if (yych <= '2') goto yy897;
	goto yy56;
yy888:
	yych = *++YYCURSOR;
	if (yych != '/') goto yy56;
yy889:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy890;
	if (yych <= '3') goto yy891;
	if (yych <= '9') goto yy892;
	goto yy56;
yy890:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy394;
		if (yych <= '9') goto yy892;
		if (yych <= 'm') goto yy394;
		goto yy894;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy394;
			goto yy895;
		} else {
			if (yych <= 's') goto yy893;
			if (yych <= 't') goto yy896;
			goto yy394;
		}
	}
yy891:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy394;
		if (yych <= '1') goto yy892;
		if (yych <= 'm') goto yy394;
		goto yy894;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy394;
			goto yy895;
		} else {
			if (yych <= 's') goto yy893;
			if (yych <= 't') goto yy896;
			goto yy394;
		}
	}
yy892:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy894;
		goto yy394;
	} else {
		if (yych <= 'r') goto yy895;
		if (yych <= 's') goto yy893;
		if (yych <= 't') goto yy896;
		goto yy394;
	}
yy893:
	yych = *++YYCURSOR;
	if (yych == 't') goto yy393;
	goto yy56;
yy894:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy393;
	goto yy56;
yy895:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy393;
	goto yy56;
yy896:
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy393;
	goto yy56;
yy897:
	yych = *++YYCURSOR;
	if (yych != '/') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy56;
		if (yych >= '1') goto yy900;
	} else {
		if (yych <= '3') goto yy901;
		if (yych <= '9') goto yy892;
		goto yy56;
	}
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy394;
		if (yych <= '9') goto yy902;
		if (yych <= 'm') goto yy394;
		goto yy894;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy394;
			goto yy895;
		} else {
			if (yych <= 's') goto yy893;
			if (yych <= 't') goto yy896;
			goto yy394;
		}
	}
yy900:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy394;
		if (yych <= '9') goto yy902;
		if (yych <= 'm') goto yy394;
		goto yy894;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy394;
			goto yy895;
		} else {
			if (yych <= 's') goto yy893;
			if (yych <= 't') goto yy896;
			goto yy394;
		}
	}
yy901:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy394;
		if (yych <= '1') goto yy902;
		if (yych <= 'm') goto yy394;
		goto yy894;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy394;
			goto yy895;
		} else {
			if (yych <= 's') goto yy893;
			if (yych <= 't') goto yy896;
			goto yy394;
		}
	}
yy902:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == '/') goto yy393;
		if (yych <= 'm') goto yy394;
		goto yy894;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy394;
			goto yy895;
		} else {
			if (yych <= 's') goto yy893;
			if (yych <= 't') goto yy896;
			goto yy394;
		}
	}
yy903:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy983;
		if (yych <= 'T') goto yy56;
		goto yy982;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy983;
		} else {
			if (yych == 'u') goto yy982;
			goto yy56;
		}
	}
yy904:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy980;
	if (yych == 'e') goto yy980;
	goto yy56;
yy905:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy977;
	if (yych == 'a') goto yy977;
	goto yy56;
yy906:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy974;
		if (yych <= 'T') goto yy56;
		goto yy973;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy974;
		} else {
			if (yych == 'u') goto yy973;
			goto yy56;
		}
	}
yy907:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy970;
	if (yych == 'e') goto yy970;
	goto yy56;
yy908:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy968;
	if (yych == 'c') goto yy968;
	goto yy56;
yy909:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy966;
	if (yych == 'o') goto yy966;
	goto yy56;
yy910:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy964;
	if (yych == 'e') goto yy964;
	goto yy56;
yy911:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy750;
	if (yych <= '4') goto yy751;
	if (yych <= '5') goto yy752;
	goto yy56;
yy912:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy916;
	if (yych <= '/') goto yy913;
	if (yych <= '9') goto yy935;
yy913:
	{
		int length = 0;
		DEBUG_OUTPUT("gnudateshorter");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
yy914:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy916;
	if (yych <= '/') goto yy913;
	if (yych <= '2') goto yy935;
	goto yy913;
yy915:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '-') goto yy913;
yy916:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy917;
	if (yych <= '3') goto yy918;
	if (yych <= '9') goto yy919;
	goto yy56;
yy917:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy596;
			goto yy919;
		} else {
			if (yych == 'T') goto yy924;
			goto yy596;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy921;
			if (yych <= 'q') goto yy596;
			goto yy922;
		} else {
			if (yych <= 's') goto yy920;
			if (yych <= 't') goto yy923;
			goto yy596;
		}
	}
yy918:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy596;
		} else {
			if (yych == 'T') goto yy924;
			goto yy596;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy921;
			if (yych <= 'q') goto yy596;
			goto yy922;
		} else {
			if (yych <= 's') goto yy920;
			if (yych <= 't') goto yy923;
			goto yy596;
		}
	}
yy919:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == 'T') goto yy924;
		if (yych <= 'm') goto yy596;
		goto yy921;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy596;
			goto yy922;
		} else {
			if (yych <= 's') goto yy920;
			if (yych <= 't') goto yy923;
			goto yy596;
		}
	}
yy920:
	yych = *++YYCURSOR;
	if (yych == 't') goto yy934;
	goto yy56;
yy921:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy934;
	goto yy56;
yy922:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy934;
	goto yy56;
yy923:
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy934;
	goto yy56;
yy924:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy925;
	if (yych <= '2') goto yy926;
	if (yych <= '9') goto yy927;
	goto yy56;
yy925:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy927;
	if (yych <= ':') goto yy928;
	goto yy56;
yy926:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '4') goto yy927;
	if (yych == ':') goto yy928;
	goto yy56;
yy927:
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
yy928:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy929;
	if (yych <= '9') goto yy930;
	goto yy56;
yy929:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy930;
	if (yych <= ':') goto yy931;
	goto yy56;
yy930:
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
yy931:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy932;
	if (yych <= '6') goto yy933;
	if (yych <= '9') goto yy781;
	goto yy56;
yy932:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy782;
	if (yych <= '9') goto yy781;
	goto yy782;
yy933:
	yych = *++YYCURSOR;
	if (yych == '0') goto yy781;
	goto yy782;
yy934:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'T') goto yy924;
	goto yy596;
yy935:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '-') goto yy913;
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy56;
		if (yych >= '1') goto yy938;
	} else {
		if (yych <= '3') goto yy939;
		if (yych <= '9') goto yy919;
		goto yy56;
	}
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy596;
			goto yy940;
		} else {
			if (yych == 'T') goto yy924;
			goto yy596;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy921;
			if (yych <= 'q') goto yy596;
			goto yy922;
		} else {
			if (yych <= 's') goto yy920;
			if (yych <= 't') goto yy923;
			goto yy596;
		}
	}
yy938:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy596;
			goto yy940;
		} else {
			if (yych == 'T') goto yy924;
			goto yy596;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy921;
			if (yych <= 'q') goto yy596;
			goto yy922;
		} else {
			if (yych <= 's') goto yy920;
			if (yych <= 't') goto yy923;
			goto yy596;
		}
	}
yy939:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy596;
		} else {
			if (yych == 'T') goto yy924;
			goto yy596;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy921;
			if (yych <= 'q') goto yy596;
			goto yy922;
		} else {
			if (yych <= 's') goto yy920;
			if (yych <= 't') goto yy923;
			goto yy596;
		}
	}
yy940:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == 'T') goto yy941;
		if (yych <= 'm') goto yy394;
		goto yy921;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy394;
			goto yy922;
		} else {
			if (yych <= 's') goto yy920;
			if (yych <= 't') goto yy923;
			goto yy394;
		}
	}
yy941:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy942;
	if (yych <= '2') goto yy943;
	if (yych <= '9') goto yy927;
	goto yy56;
yy942:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy944;
	if (yych <= ':') goto yy928;
	goto yy56;
yy943:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '4') goto yy944;
	if (yych == ':') goto yy928;
	goto yy56;
yy944:
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy946;
	if (yych <= '9') goto yy930;
	goto yy56;
yy946:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy947;
	if (yych <= ':') goto yy931;
	goto yy56;
yy947:
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy949;
	if (yych <= '6') goto yy950;
	if (yych <= '9') goto yy781;
	goto yy56;
yy949:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy782;
	if (yych <= '9') goto yy951;
	goto yy782;
yy950:
	yych = *++YYCURSOR;
	if (yych != '0') goto yy782;
yy951:
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '.') goto yy782;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy953:
	yyaccept = 22;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
	if (yych <= '-') {
		if (yych == '+') goto yy956;
		if (yych <= ',') goto yy782;
		goto yy956;
	} else {
		if (yych <= '9') {
			if (yych <= '/') goto yy782;
			goto yy953;
		} else {
			if (yych != 'G') goto yy782;
		}
	}
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy962;
	goto yy56;
yy956:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy957;
	if (yych <= '2') goto yy958;
	if (yych <= '9') goto yy959;
	goto yy56;
yy957:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy782;
	if (yych <= '9') goto yy959;
	if (yych <= ':') goto yy960;
	goto yy782;
yy958:
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy782;
		if (yych >= '5') goto yy961;
	} else {
		if (yych <= '9') goto yy781;
		if (yych <= ':') goto yy960;
		goto yy782;
	}
yy959:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy782;
	if (yych <= '5') goto yy961;
	if (yych <= '9') goto yy781;
	if (yych >= ';') goto yy782;
yy960:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy782;
	if (yych <= '5') goto yy961;
	if (yych <= '9') goto yy781;
	goto yy782;
yy961:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy782;
	if (yych <= '9') goto yy781;
	goto yy782;
yy962:
	yych = *++YYCURSOR;
	if (yych != 'T') goto yy56;
	yych = *++YYCURSOR;
	if (yych == '+') goto yy956;
	if (yych == '-') goto yy956;
	goto yy56;
yy964:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy965;
	if (yych != 'c') goto yy56;
yy965:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy706;
		goto yy733;
	} else {
		if (yych <= 'E') goto yy819;
		if (yych == 'e') goto yy819;
		goto yy733;
	}
yy966:
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy967;
	if (yych != 'v') goto yy56;
yy967:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy706;
		goto yy733;
	} else {
		if (yych <= 'E') goto yy826;
		if (yych == 'e') goto yy826;
		goto yy733;
	}
yy968:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy969;
	if (yych != 't') goto yy56;
yy969:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych == '-') goto yy706;
		goto yy733;
	} else {
		if (yych <= 'O') goto yy832;
		if (yych == 'o') goto yy832;
		goto yy733;
	}
yy970:
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy971;
	if (yych != 'p') goto yy56;
yy971:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == '-') goto yy706;
		goto yy733;
	} else {
		if (yych <= 'T') goto yy972;
		if (yych != 't') goto yy733;
	}
yy972:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy706;
		goto yy733;
	} else {
		if (yych <= 'E') goto yy838;
		if (yych == 'e') goto yy838;
		goto yy733;
	}
yy973:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy976;
	if (yych == 'g') goto yy976;
	goto yy56;
yy974:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy975;
	if (yych != 'r') goto yy56;
yy975:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych == '-') goto yy706;
		goto yy733;
	} else {
		if (yych <= 'I') goto yy845;
		if (yych == 'i') goto yy845;
		goto yy733;
	}
yy976:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == '-') goto yy706;
		goto yy733;
	} else {
		if (yych <= 'U') goto yy847;
		if (yych == 'u') goto yy847;
		goto yy733;
	}
yy977:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy978;
		if (yych <= 'X') goto yy56;
		goto yy979;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
		} else {
			if (yych == 'y') goto yy979;
			goto yy56;
		}
	}
yy978:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych == '-') goto yy706;
		goto yy733;
	} else {
		if (yych <= 'C') goto yy851;
		if (yych == 'c') goto yy851;
		goto yy733;
	}
yy979:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy706;
	goto yy733;
yy980:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy981;
	if (yych != 'b') goto yy56;
yy981:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == '-') goto yy706;
		goto yy733;
	} else {
		if (yych <= 'R') goto yy854;
		if (yych == 'r') goto yy854;
		goto yy733;
	}
yy982:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy986;
		if (yych <= 'M') goto yy56;
		goto yy985;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy986;
		} else {
			if (yych == 'n') goto yy985;
			goto yy56;
		}
	}
yy983:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy984;
	if (yych != 'n') goto yy56;
yy984:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == '-') goto yy706;
		goto yy733;
	} else {
		if (yych <= 'U') goto yy861;
		if (yych == 'u') goto yy861;
		goto yy733;
	}
yy985:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy706;
		goto yy733;
	} else {
		if (yych <= 'E') goto yy823;
		if (yych == 'e') goto yy823;
		goto yy733;
	}
yy986:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych == '-') goto yy706;
		goto yy733;
	} else {
		if (yych <= 'Y') goto yy823;
		if (yych == 'y') goto yy823;
		goto yy733;
	}
yy987:
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy517;
			goto yy670;
		} else {
			if (yych <= ',') goto yy517;
			if (yych <= '-') goto yy671;
			goto yy670;
		}
	} else {
		if (yych <= 'U') {
			if (yych <= '/') goto yy669;
			if (yych <= 'T') goto yy517;
			goto yy77;
		} else {
			if (yych == 'u') goto yy77;
			goto yy517;
		}
	}
yy988:
	yych = *++YYCURSOR;
	if (yych <= 'P') {
		if (yych == 'C') goto yy128;
		if (yych <= 'O') goto yy56;
		goto yy525;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy56;
			goto yy128;
		} else {
			if (yych == 'p') goto yy525;
			goto yy56;
		}
	}
yy989:
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ',') {
			if (yych == '\t') goto yy991;
			goto yy993;
		} else {
			if (yych <= '-') goto yy990;
			if (yych <= '.') goto yy670;
			if (yych <= '/') goto yy669;
			goto yy680;
		}
	} else {
		if (yych <= 'q') {
			if (yych == 'n') goto yy409;
			goto yy993;
		} else {
			if (yych <= 'r') goto yy410;
			if (yych <= 's') goto yy403;
			if (yych <= 't') goto yy407;
			goto yy993;
		}
	}
yy990:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy994;
	case '1':	goto yy995;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy557;
	case 'A':
	case 'a':	goto yy561;
	case 'D':
	case 'd':	goto yy565;
	case 'F':
	case 'f':	goto yy559;
	case 'J':
	case 'j':	goto yy558;
	case 'M':
	case 'm':	goto yy560;
	case 'N':
	case 'n':	goto yy564;
	case 'O':
	case 'o':	goto yy563;
	case 'S':
	case 's':	goto yy562;
	default:	goto yy517;
	}
yy991:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy993;
	if (yych <= '0') goto yy675;
	if (yych <= '1') goto yy676;
	if (yych <= '9') goto yy677;
	goto yy993;
yy992:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy993:
	switch (yych) {
	case '\t':
	case ' ':	goto yy992;
	case '-':
	case '.':	goto yy516;
	case 'A':
	case 'a':	goto yy513;
	case 'D':
	case 'd':	goto yy405;
	case 'F':
	case 'f':	goto yy406;
	case 'H':
	case 'h':	goto yy63;
	case 'I':	goto yy414;
	case 'J':
	case 'j':	goto yy418;
	case 'M':
	case 'm':	goto yy404;
	case 'N':
	case 'n':	goto yy421;
	case 'O':
	case 'o':	goto yy420;
	case 'S':
	case 's':	goto yy402;
	case 'T':
	case 't':	goto yy68;
	case 'V':	goto yy416;
	case 'W':
	case 'w':	goto yy67;
	case 'X':	goto yy417;
	case 'Y':
	case 'y':	goto yy66;
	default:	goto yy56;
	}
yy994:
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy594;
		goto yy541;
	} else {
		if (yych <= '/') goto yy56;
		if (yych <= '9') goto yy996;
		goto yy56;
	}
yy995:
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy594;
		goto yy541;
	} else {
		if (yych <= '/') goto yy56;
		if (yych >= '3') goto yy56;
	}
yy996:
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '-') goto yy997;
	if (yych <= '.') goto yy541;
	goto yy56;
yy997:
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy56;
		if (yych >= '1') goto yy999;
	} else {
		if (yych <= '3') goto yy1000;
		if (yych <= '9') goto yy598;
		goto yy56;
	}
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy596;
		if (yych <= '9') goto yy1001;
		if (yych <= 'm') goto yy596;
		goto yy600;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy596;
			goto yy601;
		} else {
			if (yych <= 's') goto yy599;
			if (yych <= 't') goto yy602;
			goto yy596;
		}
	}
yy999:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy596;
		if (yych <= '9') goto yy1001;
		if (yych <= 'm') goto yy596;
		goto yy600;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy596;
			goto yy601;
		} else {
			if (yych <= 's') goto yy599;
			if (yych <= 't') goto yy602;
			goto yy596;
		}
	}
yy1000:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '1') {
			if (yych <= '/') goto yy596;
		} else {
			if (yych <= '9') goto yy543;
			if (yych <= 'm') goto yy596;
			goto yy600;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy596;
			goto yy601;
		} else {
			if (yych <= 's') goto yy599;
			if (yych <= 't') goto yy602;
			goto yy596;
		}
	}
yy1001:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy703;
		if (yych <= '9') goto yy544;
		if (yych <= 'm') goto yy703;
		goto yy600;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy703;
			goto yy601;
		} else {
			if (yych <= 's') goto yy599;
			if (yych <= 't') goto yy602;
			goto yy703;
		}
	}
yy1002:
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy991;
			if (yych <= ',') goto yy993;
			goto yy990;
		} else {
			if (yych <= '.') goto yy1003;
			if (yych <= '/') goto yy669;
			if (yych <= '5') goto yy1005;
			goto yy680;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy1004;
			if (yych == 'n') goto yy409;
			goto yy993;
		} else {
			if (yych <= 'r') goto yy410;
			if (yych <= 's') goto yy403;
			if (yych <= 't') goto yy407;
			goto yy993;
		}
	}
yy1003:
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= '/') goto yy517;
		if (yych <= '0') goto yy1027;
		goto yy1028;
	} else {
		if (yych <= '5') goto yy1029;
		if (yych <= '9') goto yy1030;
		goto yy517;
	}
yy1004:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1022;
	if (yych <= '9') goto yy1023;
	goto yy56;
yy1005:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy724;
	if (yych <= '/') goto yy60;
	if (yych >= ':') goto yy60;
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'n':
	case 'o':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy730;
	case '-':	goto yy727;
	case '.':	goto yy731;
	case '/':	goto yy728;
	case '0':	goto yy1008;
	case '1':	goto yy1009;
	case '2':	goto yy1010;
	case '3':	goto yy1011;
	case '4':
	case '5':	goto yy1012;
	case '6':	goto yy1013;
	case '7':
	case '8':
	case '9':	goto yy54;
	case ':':	goto yy746;
	case 'W':	goto yy749;
	default:	goto yy1007;
	}
yy1007:
	{
		DEBUG_OUTPUT("gnunocolon");
		TIMELIB_INIT;
		switch (s->time->have_time) {
			case 0:
				s->time->h = timelib_get_nr((char **) &ptr, 2);
				s->time->i = timelib_get_nr((char **) &ptr, 2);
				s->time->s = 0;
				break;
			case 1:
				s->time->y = timelib_get_nr((char **) &ptr, 4);
				break;
			default:
				TIMELIB_DEINIT;
				add_error(s, "Double time specification");
				return TIMELIB_ERROR;
		}
		s->time->have_time++;
		TIMELIB_DEINIT;
		return TIMELIB_GNU_NOCOLON;
	}
yy1008:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '0') goto yy1020;
	if (yych <= '9') goto yy1021;
	goto yy60;
yy1009:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '2') goto yy1019;
	if (yych <= '9') goto yy1018;
	goto yy60;
yy1010:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy1018;
	goto yy60;
yy1011:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '5') goto yy1016;
	if (yych <= '6') goto yy1017;
	if (yych <= '9') goto yy1014;
	goto yy60;
yy1012:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy1014;
	goto yy60;
yy1013:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '0') goto yy1014;
	if (yych <= '9') goto yy54;
	goto yy60;
yy1014:
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych >= ' ') goto yy60;
			} else {
				if (yych == 'D') goto yy60;
				if (yych >= 'F') goto yy60;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy60;
				if (yych >= 'M') goto yy60;
			} else {
				if (yych <= 'R') goto yy1015;
				if (yych <= 'T') goto yy60;
				if (yych >= 'W') goto yy60;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy60;
				if (yych >= 'd') goto yy60;
			} else {
				if (yych == 'f') goto yy60;
				if (yych >= 'h') goto yy60;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych >= 's') goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych >= 'w') goto yy60;
				} else {
					if (yych == 'y') goto yy60;
				}
			}
		}
	}
yy1015:
	{
		int tz_not_found;
		DEBUG_OUTPUT("iso8601nocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);

		if (*ptr != '\0') {
			s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
			if (tz_not_found) {
				add_error(s, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_ISO_NOCOLON;
	}
yy1016:
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy1015;
				goto yy60;
			} else {
				if (yych <= '/') goto yy1015;
				if (yych <= '9') goto yy760;
				if (yych <= 'C') goto yy1015;
				goto yy60;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy60;
				if (yych <= 'G') goto yy1015;
				goto yy60;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy1015;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy1015;
					if (yych <= 'T') goto yy60;
					goto yy1015;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy1015;
				if (yych <= 'Y') goto yy60;
				goto yy1015;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy60;
					goto yy1015;
				} else {
					if (yych == 'g') goto yy1015;
					goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych <= 'r') goto yy1015;
				goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1015;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy1015;
				}
			}
		}
	}
yy1017:
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy1015;
				goto yy60;
			} else {
				if (yych <= '6') {
					if (yych <= '/') goto yy1015;
					goto yy760;
				} else {
					if (yych <= '9') goto yy54;
					if (yych <= 'C') goto yy1015;
					goto yy60;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy60;
				if (yych <= 'G') goto yy1015;
				goto yy60;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy1015;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy1015;
					if (yych <= 'T') goto yy60;
					goto yy1015;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy1015;
				if (yych <= 'Y') goto yy60;
				goto yy1015;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy60;
					goto yy1015;
				} else {
					if (yych == 'g') goto yy1015;
					goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych <= 'r') goto yy1015;
				goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1015;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy1015;
				}
			}
		}
	}
yy1018:
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy1015;
				goto yy60;
			} else {
				if (yych <= '/') goto yy1015;
				if (yych <= '9') goto yy760;
				if (yych <= 'C') goto yy1015;
				goto yy60;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy60;
				if (yych <= 'G') goto yy1015;
				goto yy60;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy1015;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy1015;
					if (yych <= 'T') goto yy60;
					goto yy1015;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy1015;
				if (yych <= 'Y') goto yy60;
				goto yy1015;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy60;
					goto yy1015;
				} else {
					if (yych == 'g') goto yy1015;
					goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych <= 'r') goto yy1015;
				goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1015;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy1015;
				}
			}
		}
	}
yy1019:
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '9') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy1015;
				goto yy60;
			} else {
				if (yych <= '0') {
					if (yych <= '/') goto yy1015;
					goto yy784;
				} else {
					if (yych <= '2') goto yy785;
					if (yych <= '3') goto yy786;
					goto yy760;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy1015;
					goto yy60;
				} else {
					if (yych == 'F') goto yy60;
					goto yy1015;
				}
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy60;
					goto yy1015;
				} else {
					if (yych <= 'M') goto yy60;
					if (yych <= 'R') goto yy1015;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy60;
				if (yych <= 'X') goto yy1015;
				goto yy60;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy1015;
					goto yy60;
				} else {
					if (yych == 'f') goto yy60;
					goto yy1015;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy60;
					goto yy1015;
				} else {
					if (yych <= 'm') goto yy60;
					if (yych <= 'r') goto yy1015;
					goto yy60;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1015;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy1015;
				}
			}
		}
	}
yy1020:
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '9') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy1015;
				goto yy60;
			} else {
				if (yych <= '0') {
					if (yych <= '/') goto yy1015;
					goto yy816;
				} else {
					if (yych <= '2') goto yy785;
					if (yych <= '3') goto yy786;
					goto yy760;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy1015;
					goto yy60;
				} else {
					if (yych == 'F') goto yy60;
					goto yy1015;
				}
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy60;
					goto yy1015;
				} else {
					if (yych <= 'M') goto yy60;
					if (yych <= 'R') goto yy1015;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy60;
				if (yych <= 'X') goto yy1015;
				goto yy60;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy1015;
					goto yy60;
				} else {
					if (yych == 'f') goto yy60;
					goto yy1015;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy60;
					goto yy1015;
				} else {
					if (yych <= 'm') goto yy60;
					if (yych <= 'r') goto yy1015;
					goto yy60;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1015;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy1015;
				}
			}
		}
	}
yy1021:
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '9') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy1015;
				goto yy60;
			} else {
				if (yych <= '0') {
					if (yych <= '/') goto yy1015;
					goto yy784;
				} else {
					if (yych <= '2') goto yy785;
					if (yych <= '3') goto yy786;
					goto yy760;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy1015;
					goto yy60;
				} else {
					if (yych == 'F') goto yy60;
					goto yy1015;
				}
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy60;
					goto yy1015;
				} else {
					if (yych <= 'M') goto yy60;
					if (yych <= 'R') goto yy1015;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy60;
				if (yych <= 'X') goto yy1015;
				goto yy60;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy1015;
					goto yy60;
				} else {
					if (yych == 'f') goto yy60;
					goto yy1015;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy60;
					goto yy1015;
				} else {
					if (yych <= 'm') goto yy60;
					if (yych <= 'r') goto yy1015;
					goto yy60;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1015;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy1015;
				}
			}
		}
	}
yy1022:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy1024;
		goto yy430;
	} else {
		if (yych <= '9') goto yy1023;
		if (yych <= ':') goto yy1024;
		goto yy430;
	}
yy1023:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy1024;
	if (yych != ':') goto yy430;
yy1024:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1025;
	if (yych <= '6') goto yy1026;
	if (yych <= '9') goto yy435;
	goto yy56;
yy1025:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy436;
	if (yych <= '/') goto yy430;
	if (yych <= '9') goto yy435;
	goto yy430;
yy1026:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy436;
	if (yych == '0') goto yy435;
	goto yy430;
yy1027:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy430;
		if (yych <= '-') goto yy541;
		goto yy1031;
	} else {
		if (yych <= '/') goto yy430;
		if (yych <= '9') goto yy1030;
		if (yych <= ':') goto yy1024;
		goto yy430;
	}
yy1028:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') goto yy430;
		if (yych <= '-') goto yy541;
		if (yych <= '.') goto yy1031;
		goto yy430;
	} else {
		if (yych <= '2') goto yy1030;
		if (yych <= '9') goto yy1023;
		if (yych <= ':') goto yy1024;
		goto yy430;
	}
yy1029:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy430;
		if (yych <= '-') goto yy541;
		goto yy1031;
	} else {
		if (yych <= '/') goto yy430;
		if (yych <= '9') goto yy1023;
		if (yych <= ':') goto yy1024;
		goto yy430;
	}
yy1030:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy430;
		if (yych <= '-') goto yy541;
	} else {
		if (yych == ':') goto yy1024;
		goto yy430;
	}
yy1031:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1032;
	if (yych <= '6') goto yy1033;
	if (yych <= '9') goto yy549;
	goto yy56;
yy1032:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy436;
	if (yych <= '/') goto yy430;
	if (yych <= '9') goto yy1034;
	goto yy430;
yy1033:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy436;
		goto yy430;
	} else {
		if (yych <= '0') goto yy1034;
		if (yych <= '9') goto yy550;
		goto yy430;
	}
yy1034:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy436;
	if (yych <= '/') goto yy430;
	if (yych <= '9') goto yy544;
	goto yy430;
yy1035:
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy399;
			if (yych <= ',') goto yy401;
			goto yy990;
		} else {
			if (yych <= '.') goto yy413;
			if (yych <= '/') goto yy411;
			if (yych <= '5') goto yy1005;
			goto yy680;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy422;
			if (yych == 'n') goto yy409;
			goto yy401;
		} else {
			if (yych <= 'r') goto yy410;
			if (yych <= 's') goto yy403;
			if (yych <= 't') goto yy407;
			goto yy401;
		}
	}
yy1036:
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy991;
			if (yych <= ',') goto yy993;
			goto yy990;
		} else {
			if (yych <= '.') goto yy1003;
			if (yych <= '/') goto yy411;
			if (yych <= '5') goto yy1005;
			goto yy680;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy1004;
			if (yych == 'n') goto yy409;
			goto yy993;
		} else {
			if (yych <= 'r') goto yy410;
			if (yych <= 's') goto yy403;
			if (yych <= 't') goto yy407;
			goto yy993;
		}
	}
yy1037:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy141;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'e') goto yy1038;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1038:
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'U') goto yy142;
		}
	} else {
		if (yych <= 'u') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'v') goto yy1039;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1039:
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'H') goto yy143;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'i') goto yy1040;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1040:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy144;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'o') goto yy1041;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1041:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'U') goto yy1042;
		if (yych != 'u') goto yy3;
	}
yy1042:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1043;
	if (yych != 's') goto yy56;
yy1043:
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy1044;
	if (yych != ' ') goto yy56;
yy1044:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy1045:
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy1044;
				if (yych <= 0x1F) goto yy56;
				goto yy1044;
			} else {
				if (yych == 'D') goto yy1049;
				if (yych <= 'E') goto yy56;
				goto yy1050;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy1048;
				if (yych <= 'L') goto yy56;
				goto yy1047;
			} else {
				if (yych <= 'S') {
					if (yych <= 'R') goto yy56;
				} else {
					if (yych <= 'T') goto yy1053;
					if (yych <= 'V') goto yy56;
					goto yy1052;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy1051;
				if (yych <= 'c') goto yy56;
				goto yy1049;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy56;
					goto yy1050;
				} else {
					if (yych == 'h') goto yy1048;
					goto yy56;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy1047;
				if (yych <= 'r') goto yy56;
				if (yych >= 't') goto yy1053;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy56;
					goto yy1052;
				} else {
					if (yych == 'y') goto yy1051;
					goto yy56;
				}
			}
		}
	}
yy1046:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy1118;
			goto yy56;
		} else {
			if (yych <= 'E') goto yy1119;
			if (yych <= 'T') goto yy56;
			goto yy1117;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy1118;
			goto yy56;
		} else {
			if (yych <= 'e') goto yy1119;
			if (yych == 'u') goto yy1117;
			goto yy56;
		}
	}
yy1047:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych == 'I') goto yy1109;
		if (yych <= 'N') goto yy56;
		goto yy1108;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy56;
			goto yy1109;
		} else {
			if (yych == 'o') goto yy1108;
			goto yy56;
		}
	}
yy1048:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1106;
	if (yych == 'o') goto yy1106;
	goto yy56;
yy1049:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1105;
	if (yych == 'a') goto yy1105;
	goto yy56;
yy1050:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy1090;
		if (yych <= 'Q') goto yy56;
		goto yy1089;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy56;
			goto yy1090;
		} else {
			if (yych == 'r') goto yy1089;
			goto yy56;
		}
	}
yy1051:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1086;
	if (yych == 'e') goto yy1086;
	goto yy56;
yy1052:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1072;
	if (yych == 'e') goto yy1072;
	goto yy56;
yy1053:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy1054;
		if (yych <= 'T') goto yy56;
		goto yy1055;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy56;
		} else {
			if (yych == 'u') goto yy1055;
			goto yy56;
		}
	}
yy1054:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy1067;
	if (yych == 'u') goto yy1067;
	goto yy56;
yy1055:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1056;
	if (yych != 'e') goto yy56;
yy1056:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1058;
		if (yych >= ' ') goto yy1058;
	} else {
		if (yych <= 'S') {
			if (yych >= 'S') goto yy1060;
		} else {
			if (yych == 's') goto yy1060;
		}
	}
yy1057:
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("relativetext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_relative_text((char **) &ptr, &behavior);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, behavior, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1058:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	if (yych <= ' ') {
		if (yych == '\t') goto yy1058;
		if (yych <= 0x1F) goto yy56;
		goto yy1058;
	} else {
		if (yych <= 'O') {
			if (yych <= 'N') goto yy56;
			goto yy1064;
		} else {
			if (yych == 'o') goto yy1064;
			goto yy56;
		}
	}
yy1060:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1061;
	if (yych != 'd') goto yy56;
yy1061:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1062;
	if (yych != 'a') goto yy56;
yy1062:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1063;
	if (yych != 'y') goto yy56;
yy1063:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '\t') goto yy1058;
	if (yych == ' ') goto yy1058;
	goto yy1057;
yy1064:
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1065;
	if (yych != 'f') goto yy56;
yy1065:
	++YYCURSOR;
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("weekdayof");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_HAVE_SPECIAL_RELATIVE();

		i = timelib_get_relative_text((char **) &ptr, &behavior);
		timelib_eat_spaces((char **) &ptr);
		if (i > 0) { /* first, second... etc */
			s->time->relative.special.type = TIMELIB_SPECIAL_DAY_OF_WEEK_IN_MONTH;
			timelib_set_relative((char **) &ptr, i, 1, s);
		} else { /* last */
			s->time->relative.special.type = TIMELIB_SPECIAL_LAST_DAY_OF_WEEK_IN_MONTH;
			timelib_set_relative((char **) &ptr, i, behavior, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_WEEK_DAY_OF_MONTH;
	}
yy1067:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1058;
		if (yych <= 0x1F) goto yy1057;
		goto yy1058;
	} else {
		if (yych <= 'R') {
			if (yych <= 'Q') goto yy1057;
		} else {
			if (yych != 'r') goto yy1057;
		}
	}
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1069;
	if (yych != 's') goto yy56;
yy1069:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1070;
	if (yych != 'd') goto yy56;
yy1070:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1071;
	if (yych != 'a') goto yy56;
yy1071:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1063;
	if (yych == 'y') goto yy1063;
	goto yy56;
yy1072:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy56;
		if (yych <= 'D') goto yy1074;
	} else {
		if (yych <= 'c') goto yy56;
		if (yych <= 'd') goto yy1074;
		if (yych >= 'f') goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy1080;
	if (yych == 'k') goto yy1080;
	goto yy56;
yy1074:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1058;
		if (yych <= 0x1F) goto yy1057;
		goto yy1058;
	} else {
		if (yych <= 'N') {
			if (yych <= 'M') goto yy1057;
		} else {
			if (yych != 'n') goto yy1057;
		}
	}
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1076;
	if (yych != 'e') goto yy56;
yy1076:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1077;
	if (yych != 's') goto yy56;
yy1077:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1078;
	if (yych != 'd') goto yy56;
yy1078:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1079;
	if (yych != 'a') goto yy56;
yy1079:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1063;
	if (yych == 'y') goto yy1063;
	goto yy56;
yy1080:
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'D') goto yy1083;
		if (yych >= 'S') goto yy1082;
	} else {
		if (yych <= 'd') {
			if (yych >= 'd') goto yy1083;
		} else {
			if (yych == 's') goto yy1082;
		}
	}
yy1081:
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("relativetextweek");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_relative_text((char **) &ptr, &behavior);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, behavior, s);
			s->time->relative.weekday_behavior = 2;

			/* to handle the format weekday + last/this/next week */
			if (s->time->relative.have_weekday_relative == 0) {
				TIMELIB_HAVE_WEEKDAY_RELATIVE();
				s->time->relative.weekday = 1;
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1082:
	yych = *++YYCURSOR;
	goto yy1057;
yy1083:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1084;
	if (yych != 'a') goto yy56;
yy1084:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1085;
	if (yych != 'y') goto yy56;
yy1085:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1082;
	if (yych == 's') goto yy1082;
	goto yy1057;
yy1086:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1087;
	if (yych != 'a') goto yy56;
yy1087:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1088;
	if (yych != 'r') goto yy56;
yy1088:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1082;
	if (yych == 's') goto yy1082;
	goto yy1057;
yy1089:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1102;
	if (yych == 'i') goto yy1102;
	goto yy56;
yy1090:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1091;
	if (yych != 'r') goto yy56;
yy1091:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1092;
	if (yych != 't') goto yy56;
yy1092:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy1094;
		if (yych <= 'M') goto yy56;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy56;
			goto yy1094;
		} else {
			if (yych != 'n') goto yy56;
		}
	}
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1099;
	if (yych == 'i') goto yy1099;
	goto yy56;
yy1094:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1095;
	if (yych != 'n') goto yy56;
yy1095:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1096;
	if (yych != 'i') goto yy56;
yy1096:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1097;
	if (yych != 'g') goto yy56;
yy1097:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1098;
	if (yych != 'h') goto yy56;
yy1098:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1088;
	if (yych == 't') goto yy1088;
	goto yy56;
yy1099:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1100;
	if (yych != 'g') goto yy56;
yy1100:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1101;
	if (yych != 'h') goto yy56;
yy1101:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1088;
	if (yych == 't') goto yy1088;
	goto yy56;
yy1102:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1058;
		if (yych <= 0x1F) goto yy1057;
		goto yy1058;
	} else {
		if (yych <= 'D') {
			if (yych <= 'C') goto yy1057;
		} else {
			if (yych != 'd') goto yy1057;
		}
	}
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1104;
	if (yych != 'a') goto yy56;
yy1104:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1063;
	if (yych == 'y') goto yy1063;
	goto yy56;
yy1105:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1088;
	if (yych == 'y') goto yy1088;
	goto yy56;
yy1106:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy1107;
	if (yych != 'u') goto yy56;
yy1107:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1088;
	if (yych == 'r') goto yy1088;
	goto yy56;
yy1108:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1113;
	if (yych == 'n') goto yy1113;
	goto yy56;
yy1109:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1110;
	if (yych != 'n') goto yy56;
yy1110:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych == 'S') goto yy1082;
		if (yych <= 'T') goto yy1057;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy1057;
			goto yy1082;
		} else {
			if (yych != 'u') goto yy1057;
		}
	}
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1112;
	if (yych != 't') goto yy56;
yy1112:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1088;
	if (yych == 'e') goto yy1088;
	goto yy56;
yy1113:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1058;
			goto yy1057;
		} else {
			if (yych <= ' ') goto yy1058;
			if (yych <= 'C') goto yy1057;
		}
	} else {
		if (yych <= 'c') {
			if (yych == 'T') goto yy1115;
			goto yy1057;
		} else {
			if (yych <= 'd') goto yy1114;
			if (yych == 't') goto yy1115;
			goto yy1057;
		}
	}
yy1114:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1116;
	if (yych == 'a') goto yy1116;
	goto yy56;
yy1115:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1088;
	if (yych == 'h') goto yy1088;
	goto yy56;
yy1116:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1063;
	if (yych == 'y') goto yy1063;
	goto yy56;
yy1117:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1128;
	if (yych == 'n') goto yy1128;
	goto yy56;
yy1118:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1123;
	if (yych == 't') goto yy1123;
	goto yy56;
yy1119:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1120;
	if (yych != 'c') goto yy56;
yy1120:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'O') goto yy1121;
		if (yych <= 'R') goto yy1057;
		goto yy1082;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy1057;
		} else {
			if (yych == 's') goto yy1082;
			goto yy1057;
		}
	}
yy1121:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1122;
	if (yych != 'n') goto yy56;
yy1122:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1088;
	if (yych == 'd') goto yy1088;
	goto yy56;
yy1123:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1058;
		if (yych <= 0x1F) goto yy1057;
		goto yy1058;
	} else {
		if (yych <= 'U') {
			if (yych <= 'T') goto yy1057;
		} else {
			if (yych != 'u') goto yy1057;
		}
	}
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1125;
	if (yych != 'r') goto yy56;
yy1125:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1126;
	if (yych != 'd') goto yy56;
yy1126:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1127;
	if (yych != 'a') goto yy56;
yy1127:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1063;
	if (yych == 'y') goto yy1063;
	goto yy56;
yy1128:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1058;
		if (yych <= 0x1F) goto yy1057;
		goto yy1058;
	} else {
		if (yych <= 'D') {
			if (yych <= 'C') goto yy1057;
		} else {
			if (yych != 'd') goto yy1057;
		}
	}
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1130;
	if (yych != 'a') goto yy56;
yy1130:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1063;
	if (yych == 'y') goto yy1063;
	goto yy56;
yy1131:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1038;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'e') goto yy1132;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1132:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'V') goto yy1039;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'u') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'v') goto yy1133;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1133:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'I') goto yy1040;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'i') goto yy1134;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1134:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy1041;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'o') goto yy1135;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1135:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'U') goto yy1042;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'u') goto yy1136;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1136:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1043;
	if (yych != 's') goto yy154;
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 16) {
		goto yy153;
	}
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy56;
			goto yy1044;
		} else {
			if (yych == ' ') goto yy1044;
			goto yy56;
		}
	} else {
		if (yych <= '/') {
			if (yych == '.') goto yy56;
			goto yy147;
		} else {
			if (yych == '_') goto yy147;
			goto yy56;
		}
	}
yy1138:
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'F') goto yy141;
			goto yy1152;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'g') goto yy1152;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1139:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy141;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'e') goto yy1140;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1140:
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'U') goto yy142;
		}
	} else {
		if (yych <= 'u') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'v') goto yy1141;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1141:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy143;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'e') goto yy1142;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1142:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy144;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'n') goto yy1143;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1143:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'T') goto yy1144;
		if (yych != 't') goto yy3;
	}
yy1144:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1145;
	if (yych != 'h') goto yy56;
yy1145:
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy1146;
	if (yych != ' ') goto yy56;
yy1146:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy1147:
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy1146;
				if (yych <= 0x1F) goto yy56;
				goto yy1146;
			} else {
				if (yych == 'D') goto yy1049;
				if (yych <= 'E') goto yy56;
				goto yy1050;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy1048;
				if (yych <= 'L') goto yy56;
				goto yy1047;
			} else {
				if (yych <= 'S') {
					if (yych <= 'R') goto yy56;
					goto yy1046;
				} else {
					if (yych <= 'T') goto yy1053;
					if (yych <= 'V') goto yy56;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy1051;
				if (yych <= 'c') goto yy56;
				goto yy1049;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy56;
					goto yy1050;
				} else {
					if (yych == 'h') goto yy1048;
					goto yy56;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy1047;
				if (yych <= 'r') goto yy56;
				if (yych <= 's') goto yy1046;
				goto yy1053;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy56;
				} else {
					if (yych == 'y') goto yy1051;
					goto yy56;
				}
			}
		}
	}
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1149;
	if (yych != 'e') goto yy56;
yy1149:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy56;
		if (yych <= 'D') goto yy1074;
	} else {
		if (yych <= 'c') goto yy56;
		if (yych <= 'd') goto yy1074;
		if (yych >= 'f') goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy1151;
	if (yych != 'k') goto yy56;
yy1151:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == 'D') goto yy1083;
		if (yych <= 'R') goto yy56;
		goto yy1082;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy56;
			goto yy1083;
		} else {
			if (yych == 's') goto yy1082;
			goto yy56;
		}
	}
yy1152:
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy142;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'h') goto yy1153;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1153:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy143;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 't') goto yy1154;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1154:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1146;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy1146;
			if (yych == ')') goto yy139;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych == 'H') goto yy1155;
			if (yych <= 'Z') goto yy144;
			goto yy3;
		} else {
			if (yych == 'h') goto yy1155;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1155:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x1F) {
		if (yych == '\t') goto yy1146;
		goto yy3;
	} else {
		if (yych <= ' ') goto yy1146;
		if (yych == ')') goto yy139;
		goto yy3;
	}
yy1156:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'G') goto yy1152;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'f') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'g') goto yy1164;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1157:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1140;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'e') goto yy1158;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1158:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'V') goto yy1141;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'u') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'v') goto yy1159;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1159:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1142;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'e') goto yy1160;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1160:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1143;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'n') goto yy1161;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1161:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'T') goto yy1144;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 't') goto yy1162;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1162:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1145;
	if (yych != 'h') goto yy154;
yy1163:
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 16) {
		goto yy153;
	}
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy56;
			goto yy1146;
		} else {
			if (yych == ' ') goto yy1146;
			goto yy56;
		}
	} else {
		if (yych <= '/') {
			if (yych == '.') goto yy56;
			goto yy147;
		} else {
			if (yych == '_') goto yy147;
			goto yy56;
		}
	}
yy1164:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1153;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'h') goto yy1165;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1165:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1154;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 't') goto yy1166;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1166:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy3;
				goto yy1146;
			} else {
				if (yych == ' ') goto yy1146;
				goto yy3;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy3;
			} else {
				if (yych == '.') goto yy3;
				goto yy147;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'G') {
				if (yych <= '@') goto yy3;
				goto yy144;
			} else {
				if (yych <= 'H') goto yy1155;
				if (yych <= 'Z') goto yy144;
				goto yy3;
			}
		} else {
			if (yych <= 'g') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'h') goto yy1167;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1167:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy153;
	}
	if (yych <= ')') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1146;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy1146;
			if (yych <= '(') goto yy3;
			goto yy139;
		}
	} else {
		if (yych <= '.') {
			if (yych == '-') goto yy147;
			goto yy3;
		} else {
			if (yych <= '/') goto yy147;
			if (yych == '_') goto yy147;
			goto yy3;
		}
	}
yy1168:
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= 'B') {
			if (yych == ')') goto yy139;
			if (yych <= '@') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'O') {
				if (yych <= 'C') goto yy1184;
				goto yy141;
			} else {
				if (yych <= 'P') goto yy1186;
				if (yych <= 'U') goto yy141;
				goto yy1185;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy141;
				goto yy3;
			} else {
				if (yych == 'c') goto yy1184;
				goto yy141;
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'p') goto yy1186;
				goto yy141;
			} else {
				if (yych <= 'v') goto yy1185;
				if (yych <= 'z') goto yy141;
				goto yy3;
			}
		}
	}
yy1169:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy141;
			goto yy1179;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 't') goto yy1179;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1170:
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'W') goto yy141;
			goto yy1176;
		}
	} else {
		if (yych <= 'w') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'x') goto yy1176;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1171:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy141;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'n') goto yy1172;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1172:
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy166;
			goto yy139;
		} else {
			if (yych <= '@') goto yy166;
			if (yych <= 'C') goto yy142;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy166;
			goto yy142;
		} else {
			if (yych <= 'd') goto yy1173;
			if (yych <= 'z') goto yy142;
			goto yy166;
		}
	}
yy1173:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy143;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1174;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1174:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy144;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'y') goto yy1175;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1175:
	yych = *++YYCURSOR;
	if (yych == ')') goto yy139;
	goto yy166;
yy1176:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy142;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 't') goto yy1177;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1177:
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy143;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'h') goto yy1178;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1178:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy3;
			goto yy1146;
		} else {
			if (yych == ' ') goto yy1146;
			goto yy3;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy139;
			if (yych <= '@') goto yy3;
			goto yy144;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1179:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy166;
			goto yy139;
		} else {
			if (yych <= '@') goto yy166;
			if (yych <= 'T') goto yy142;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy166;
			goto yy142;
		} else {
			if (yych <= 'u') goto yy1180;
			if (yych <= 'z') goto yy142;
			goto yy166;
		}
	}
yy1180:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy143;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'r') goto yy1181;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1181:
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy144;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'd') goto yy1182;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1182:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'A') goto yy1183;
		if (yych != 'a') goto yy3;
	}
yy1183:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy172;
	if (yych == 'y') goto yy172;
	goto yy56;
yy1184:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy142;
			goto yy1195;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'o') goto yy1195;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1185:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy142;
			goto yy1192;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'e') goto yy1192;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1186:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy193;
			} else {
				if (yych <= '-') goto yy196;
				if (yych <= '.') goto yy195;
				goto yy193;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy195;
				goto yy193;
			} else {
				if (yych != 'T') goto yy142;
			}
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy193;
				goto yy142;
			} else {
				if (yych <= 't') goto yy1187;
				if (yych <= 'z') goto yy142;
				goto yy193;
			}
		}
	}
yy1187:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy193;
			} else {
				if (yych <= '-') goto yy196;
				if (yych <= '.') goto yy195;
				goto yy193;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy195;
				goto yy193;
			} else {
				if (yych != 'E') goto yy143;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy193;
				goto yy143;
			} else {
				if (yych <= 'e') goto yy1188;
				if (yych <= 'z') goto yy143;
				goto yy193;
			}
		}
	}
yy1188:
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'L') goto yy144;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'm') goto yy1189;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1189:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'B') goto yy1190;
		if (yych != 'b') goto yy3;
	}
yy1190:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1191;
	if (yych != 'e') goto yy56;
yy1191:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy204;
	if (yych == 'r') goto yy204;
	goto yy56;
yy1192:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy143;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'n') goto yy1193;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1193:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy144;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 't') goto yy1194;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1194:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'H') goto yy1145;
		if (yych == 'h') goto yy1145;
		goto yy3;
	}
yy1195:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy143;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'n') goto yy1196;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1196:
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy144;
			goto yy1155;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'd') goto yy1155;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1197:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '/') {
			if (yych <= ',') {
				if (yych == ')') goto yy139;
				goto yy3;
			} else {
				if (yych == '.') goto yy3;
				goto yy147;
			}
		} else {
			if (yych <= 'C') {
				if (yych <= '@') goto yy3;
				if (yych <= 'B') goto yy141;
				goto yy1184;
			} else {
				if (yych == 'P') goto yy1186;
				goto yy141;
			}
		}
	} else {
		if (yych <= 'b') {
			if (yych <= '^') {
				if (yych <= 'V') goto yy1185;
				if (yych <= 'Z') goto yy141;
				goto yy3;
			} else {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy3;
				goto yy146;
			}
		} else {
			if (yych <= 'p') {
				if (yych <= 'c') goto yy1213;
				if (yych <= 'o') goto yy146;
				goto yy1215;
			} else {
				if (yych == 'v') goto yy1214;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1198:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1179;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 't') goto yy1208;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1199:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'X') goto yy1176;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'w') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'x') goto yy1205;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1200:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1172;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'n') goto yy1201;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1201:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy166;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy166;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1173;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy166;
			goto yy147;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy166;
				goto yy150;
			} else {
				if (yych <= 'd') goto yy1202;
				if (yych <= 'z') goto yy150;
				goto yy166;
			}
		}
	}
yy1202:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1174;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1203;
			if (yych <= 'z') goto yy151;
			goto yy3;
		}
	}
yy1203:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy1175;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'y') goto yy1204;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1204:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy153;
	}
	if (yych <= '-') {
		if (yych == ')') goto yy139;
		if (yych <= ',') goto yy166;
		goto yy147;
	} else {
		if (yych <= '/') {
			if (yych <= '.') goto yy166;
			goto yy147;
		} else {
			if (yych == '_') goto yy147;
			goto yy166;
		}
	}
yy1205:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1177;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 't') goto yy1206;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1206:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1178;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'h') goto yy1207;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1207:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1146;
			if (yych <= 0x1F) goto yy3;
			goto yy1146;
		} else {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy3;
				goto yy147;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1208:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy166;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy166;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') goto yy1180;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy166;
			goto yy147;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy166;
				goto yy150;
			} else {
				if (yych <= 'u') goto yy1209;
				if (yych <= 'z') goto yy150;
				goto yy166;
			}
		}
	}
yy1209:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1181;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'r') goto yy1210;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1210:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1182;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'd') goto yy1211;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1211:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1183;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1212;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1212:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy172;
	if (yych == 'y') goto yy185;
	goto yy154;
yy1213:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy1195;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'o') goto yy1224;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1214:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1192;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'e') goto yy1221;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1215:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy139;
				if (yych <= ',') goto yy193;
				goto yy311;
			} else {
				if (yych == '/') goto yy147;
				goto yy195;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'S') {
				if (yych <= '@') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'T') goto yy1187;
				if (yych <= 'Z') goto yy142;
				goto yy193;
			}
		} else {
			if (yych <= 's') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy193;
				goto yy150;
			} else {
				if (yych <= 't') goto yy1216;
				if (yych <= 'z') goto yy150;
				goto yy193;
			}
		}
	}
yy1216:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy139;
				if (yych <= ',') goto yy193;
				goto yy311;
			} else {
				if (yych == '/') goto yy147;
				goto yy195;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy193;
				goto yy143;
			} else {
				if (yych <= 'E') goto yy1188;
				if (yych <= 'Z') goto yy143;
				goto yy193;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy193;
				goto yy151;
			} else {
				if (yych <= 'e') goto yy1217;
				if (yych <= 'z') goto yy151;
				goto yy193;
			}
		}
	}
yy1217:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'M') goto yy1189;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'l') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'm') goto yy1218;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1218:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'B') goto yy1190;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'b') goto yy1219;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1219:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1191;
	if (yych != 'e') goto yy154;
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy204;
	if (yych == 'r') goto yy316;
	goto yy154;
yy1221:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1193;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'n') goto yy1222;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1222:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1194;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 't') goto yy1223;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1223:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'H') goto yy1145;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'h') goto yy1163;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1224:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1196;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'n') goto yy1225;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1225:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1155;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'd') goto yy1167;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1226:
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'B') goto yy141;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'c') goto yy1227;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1227:
	yych = *++YYCURSOR;
	if (yych <= 'K') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'J') goto yy142;
		}
	} else {
		if (yych <= 'j') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'k') goto yy1228;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1228:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych == ' ') goto yy1229;
		if (yych <= '(') goto yy3;
		goto yy139;
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy3;
			goto yy143;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1229:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1230;
	if (yych != 'o') goto yy56;
yy1230:
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1231;
	if (yych != 'f') goto yy56;
yy1231:
	yych = *++YYCURSOR;
	if (yych != ' ') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy1233;
	if (yych <= '2') goto yy1235;
	if (yych <= '9') goto yy1236;
	goto yy56;
yy1233:
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1237;
	if (yych <= '9') goto yy1236;
	goto yy1237;
yy1234:
	{
		DEBUG_OUTPUT("backof | frontof");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TIME();

		if (*ptr == 'b') {
			s->time->h = timelib_get_nr((char **) &ptr, 2);
			s->time->i = 15;
		} else {
			s->time->h = timelib_get_nr((char **) &ptr, 2) - 1;
			s->time->i = 45;
		}
		if (*ptr != '\0' ) {
			timelib_eat_spaces((char **) &ptr);
			s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		}

		TIMELIB_DEINIT;
		return TIMELIB_LF_DAY_OF_MONTH;
	}
yy1235:
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1237;
	if (yych >= '5') goto yy1237;
yy1236:
	yyaccept = 27;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
yy1237:
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1236;
			goto yy1234;
		} else {
			if (yych <= ' ') goto yy1236;
			if (yych <= '@') goto yy1234;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy1234;
		} else {
			if (yych <= 'a') goto yy1238;
			if (yych != 'p') goto yy1234;
		}
	}
yy1238:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy56;
	} else {
		if (yych <= 'M') goto yy1240;
		if (yych == 'm') goto yy1240;
		goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1240;
	if (yych != 'm') goto yy56;
yy1240:
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy1242;
		if (yych == '\t') goto yy1242;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy1242;
		if (yych != '.') goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy1242;
		if (yych <= 0x08) goto yy56;
	} else {
		if (yych != ' ') goto yy56;
	}
yy1242:
	yych = *++YYCURSOR;
	goto yy1234;
yy1243:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'C') goto yy1227;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'c') goto yy1244;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1244:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'J') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'K') goto yy1228;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'j') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'k') goto yy1245;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1245:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= '(') {
			if (yych == ' ') goto yy1229;
			goto yy3;
		} else {
			if (yych <= ')') goto yy139;
			if (yych == '-') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '/') goto yy147;
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy143;
			goto yy3;
		} else {
			if (yych <= '_') goto yy147;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy151;
			goto yy3;
		}
	}
yy1246:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy141;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 's') goto yy1247;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1247:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy142;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 't') goto yy1248;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1248:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy3;
			goto yy1044;
		} else {
			if (yych != ' ') goto yy3;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy139;
			if (yych <= '@') goto yy3;
			goto yy143;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1249:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1250;
	if (yych != 'd') goto yy1045;
yy1250:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1251;
	if (yych != 'a') goto yy56;
yy1251:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1252;
	if (yych != 'y') goto yy56;
yy1252:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych != ' ') goto yy1057;
	} else {
		if (yych <= 'S') goto yy1082;
		if (yych == 's') goto yy1082;
		goto yy1057;
	}
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1254;
	if (yych != 'o') goto yy56;
yy1254:
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1255;
	if (yych != 'f') goto yy56;
yy1255:
	++YYCURSOR;
	{
		DEBUG_OUTPUT("firstdayof | lastdayof");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		/* skip "last day of" or "first day of" */
		if (*ptr == 'l' || *ptr == 'L') {
			s->time->relative.first_last_day_of = TIMELIB_SPECIAL_LAST_DAY_OF_MONTH;
		} else {
			s->time->relative.first_last_day_of = TIMELIB_SPECIAL_FIRST_DAY_OF_MONTH;
		}

		TIMELIB_DEINIT;
		return TIMELIB_LF_DAY_OF_MONTH;
	}
yy1257:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1247;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 's') goto yy1258;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1258:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1248;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 't') goto yy1259;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1259:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1044;
			if (yych <= 0x1F) goto yy3;
			goto yy1249;
		} else {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy3;
				goto yy147;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1260:
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy141;
			goto yy1296;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'b') goto yy1296;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1261:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= '@') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == 'F') goto yy1286;
			if (yych <= 'Q') goto yy141;
			goto yy1285;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			if (yych <= 'e') goto yy141;
			goto yy1286;
		} else {
			if (yych == 'r') goto yy1285;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1262:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'T') goto yy141;
			goto yy1282;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'u') goto yy1282;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1263:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= '@') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == 'I') goto yy1265;
			if (yych <= 'N') goto yy141;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			if (yych <= 'h') goto yy141;
			goto yy1265;
		} else {
			if (yych == 'o') goto yy1264;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1264:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy142;
			goto yy1268;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'n') goto yy1268;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1265:
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy166;
			goto yy139;
		} else {
			if (yych <= '@') goto yy166;
			if (yych <= 'C') goto yy142;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy166;
			goto yy142;
		} else {
			if (yych <= 'd') goto yy1266;
			if (yych <= 'z') goto yy142;
			goto yy166;
		}
	}
yy1266:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy143;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1267;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1267:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy144;
			goto yy1175;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'y') goto yy1175;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1268:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy143;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 't') goto yy1269;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1269:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych == ' ') goto yy1270;
		if (yych <= '(') goto yy3;
		goto yy139;
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy3;
			goto yy144;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1270:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1271;
	if (yych != 'o') goto yy56;
yy1271:
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1272;
	if (yych != 'f') goto yy56;
yy1272:
	yych = *++YYCURSOR;
	if (yych != ' ') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy1274;
	if (yych <= '2') goto yy1275;
	if (yych <= '9') goto yy1276;
	goto yy56;
yy1274:
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1277;
	if (yych <= '9') goto yy1276;
	goto yy1277;
yy1275:
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1277;
	if (yych >= '5') goto yy1277;
yy1276:
	yyaccept = 27;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
yy1277:
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1276;
			goto yy1234;
		} else {
			if (yych <= ' ') goto yy1276;
			if (yych <= '@') goto yy1234;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy1234;
		} else {
			if (yych <= 'a') goto yy1278;
			if (yych != 'p') goto yy1234;
		}
	}
yy1278:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy56;
	} else {
		if (yych <= 'M') goto yy1280;
		if (yych == 'm') goto yy1280;
		goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1280;
	if (yych != 'm') goto yy56;
yy1280:
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy1242;
		if (yych == '\t') goto yy1242;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy1242;
		if (yych != '.') goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy1242;
		if (yych <= 0x08) goto yy56;
		goto yy1242;
	} else {
		if (yych == ' ') goto yy1242;
		goto yy56;
	}
yy1282:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy142;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'r') goto yy1283;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1283:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy143;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 't') goto yy1284;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1284:
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy144;
			goto yy1155;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'h') goto yy1155;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1285:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy142;
			goto yy1288;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 's') goto yy1288;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1286:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy142;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 't') goto yy1287;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1287:
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy143;
			goto yy1178;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'h') goto yy1178;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1288:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy143;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 't') goto yy1289;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1289:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy3;
			goto yy1146;
		} else {
			if (yych != ' ') goto yy3;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy139;
			if (yych <= '@') goto yy3;
			goto yy144;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1290:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1291;
	if (yych != 'd') goto yy1147;
yy1291:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1292;
	if (yych != 'a') goto yy56;
yy1292:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1293;
	if (yych != 'y') goto yy56;
yy1293:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych != ' ') goto yy1057;
	} else {
		if (yych <= 'S') goto yy1082;
		if (yych == 's') goto yy1082;
		goto yy1057;
	}
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1295;
	if (yych != 'o') goto yy56;
yy1295:
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1255;
	if (yych == 'f') goto yy1255;
	goto yy56;
yy1296:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy193;
			} else {
				if (yych <= '-') goto yy196;
				if (yych <= '.') goto yy195;
				goto yy193;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy195;
				goto yy193;
			} else {
				if (yych != 'R') goto yy142;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'r') goto yy1297;
				if (yych <= 'z') goto yy142;
				goto yy193;
			}
		}
	}
yy1297:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'T') goto yy143;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'u') goto yy1298;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1298:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy144;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1299;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1299:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'R') goto yy1300;
		if (yych != 'r') goto yy3;
	}
yy1300:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy204;
	if (yych == 'y') goto yy204;
	goto yy56;
yy1301:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy1296;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'b') goto yy1319;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1302:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy139;
			} else {
				if (yych == '-') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy147;
				goto yy3;
			} else {
				if (yych == 'F') goto yy1286;
				goto yy141;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'R') goto yy1285;
				goto yy141;
			} else {
				if (yych == '_') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'f') goto yy1315;
				goto yy146;
			} else {
				if (yych <= 'r') goto yy1314;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1303:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') goto yy1282;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'u') goto yy1311;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1304:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy139;
			} else {
				if (yych == '-') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy147;
				goto yy3;
			} else {
				if (yych == 'I') goto yy1265;
				goto yy141;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'O') goto yy1264;
				goto yy141;
			} else {
				if (yych == '_') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'i') goto yy1306;
				goto yy146;
			} else {
				if (yych <= 'o') goto yy1305;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1305:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1268;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'n') goto yy1309;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1306:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy166;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy166;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1266;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy166;
			goto yy147;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy166;
				goto yy150;
			} else {
				if (yych <= 'd') goto yy1307;
				if (yych <= 'z') goto yy150;
				goto yy166;
			}
		}
	}
yy1307:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1267;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1308;
			if (yych <= 'z') goto yy151;
			goto yy3;
		}
	}
yy1308:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy1175;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'y') goto yy1204;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1309:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1269;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 't') goto yy1310;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1310:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= '(') {
			if (yych == ' ') goto yy1270;
			goto yy3;
		} else {
			if (yych <= ')') goto yy139;
			if (yych == '-') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '/') goto yy147;
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy144;
			goto yy3;
		} else {
			if (yych <= '_') goto yy147;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy152;
			goto yy3;
		}
	}
yy1311:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1283;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'r') goto yy1312;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1312:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1284;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 't') goto yy1313;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1313:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1155;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'h') goto yy1167;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1314:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1288;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 's') goto yy1317;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1315:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1287;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 't') goto yy1316;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1316:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1178;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'h') goto yy1207;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1317:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1289;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 't') goto yy1318;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1318:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1146;
			if (yych <= 0x1F) goto yy3;
			goto yy1290;
		} else {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy3;
				goto yy147;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1319:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy139;
				if (yych <= ',') goto yy193;
				goto yy311;
			} else {
				if (yych == '/') goto yy147;
				goto yy195;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'Q') {
				if (yych <= '@') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'R') goto yy1297;
				if (yych <= 'Z') goto yy142;
				goto yy193;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy193;
				goto yy150;
			} else {
				if (yych <= 'r') goto yy1320;
				if (yych <= 'z') goto yy150;
				goto yy193;
			}
		}
	}
yy1320:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') goto yy1298;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'u') goto yy1321;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1321:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1299;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1322;
			if (yych <= 'z') goto yy152;
			goto yy3;
		}
	}
yy1322:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'R') goto yy1300;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'r') goto yy1323;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1323:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy204;
	if (yych == 'y') goto yy316;
	goto yy154;
yy1324:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy1325:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '/') goto yy1327;
	if (yych <= '9') goto yy1325;
yy1327:
	{
		timelib_ull i;

		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_DATE();
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TZ();

		i = timelib_get_unsigned_nr((char **) &ptr, 24);
		s->time->y = 1970;
		s->time->m = 1;
		s->time->d = 1;
		s->time->h = s->time->i = s->time->s = 0;
		s->time->f = 0.0;
		s->time->relative.s += i;
		s->time->is_localtime = 1;
		s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
		s->time->z = 0;
		s->time->dst = 0;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1328:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy141;
			goto yy1369;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'n') goto yy1369;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1329:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == 'I') goto yy1361;
			if (yych <= 'T') goto yy141;
			goto yy1362;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			if (yych <= 'h') goto yy141;
			goto yy1361;
		} else {
			if (yych == 'u') goto yy1362;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1330:
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= '@') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == 'D') goto yy1350;
			if (yych <= 'L') goto yy141;
			goto yy1351;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			if (yych <= 'c') goto yy141;
			goto yy1350;
		} else {
			if (yych == 'm') goto yy1351;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1331:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy141;
			goto yy1346;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'e') goto yy1346;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1332:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy141;
			goto yy1342;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'e') goto yy1342;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1333:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy1004;
		goto yy56;
	} else {
		if (yych <= '9') goto yy1336;
		if (yych <= ':') goto yy1004;
		goto yy56;
	}
yy1334:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy1004;
		goto yy56;
	} else {
		if (yych <= '4') goto yy1336;
		if (yych == ':') goto yy1004;
		goto yy56;
	}
yy1335:
	yych = *++YYCURSOR;
	if (yych == '.') goto yy1004;
	if (yych == ':') goto yy1004;
	goto yy56;
yy1336:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy1004;
		goto yy56;
	} else {
		if (yych <= '5') goto yy1337;
		if (yych == ':') goto yy1004;
		goto yy56;
	}
yy1337:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1007;
	if (yych <= '5') goto yy1339;
	if (yych <= '6') goto yy1340;
	goto yy1007;
yy1339:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1341;
	goto yy56;
yy1340:
	yych = *++YYCURSOR;
	if (yych != '0') goto yy56;
yy1341:
	yych = *++YYCURSOR;
	goto yy1015;
yy1342:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'K') goto yy142;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'l') goto yy1343;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1343:
	yych = *++YYCURSOR;
	if (yych <= 'F') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'E') goto yy143;
		}
	} else {
		if (yych <= 'e') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'f') goto yy1344;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1344:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy144;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 't') goto yy1345;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1345:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'H') goto yy1145;
		if (yych == 'h') goto yy1145;
		goto yy3;
	}
yy1346:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy166;
			goto yy139;
		} else {
			if (yych <= '@') goto yy166;
			if (yych <= 'R') goto yy142;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy166;
			goto yy142;
		} else {
			if (yych <= 's') goto yy1347;
			if (yych <= 'z') goto yy142;
			goto yy166;
		}
	}
yy1347:
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy143;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'd') goto yy1348;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1348:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy144;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1349;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1349:
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'Y') goto yy172;
		if (yych == 'y') goto yy172;
		goto yy3;
	}
yy1350:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
		goto yy1358;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy142;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1358;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1351:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy142;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'o') goto yy1352;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1352:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy143;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'r') goto yy1353;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1353:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy144;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'r') goto yy1354;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1354:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'O') goto yy1355;
		if (yych != 'o') goto yy3;
	}
yy1355:
	yych = *++YYCURSOR;
	if (yych == 'W') goto yy1356;
	if (yych != 'w') goto yy56;
yy1356:
	++YYCURSOR;
yy1357:
	{
		DEBUG_OUTPUT("tomorrow");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = 1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1358:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy143;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'y') goto yy1359;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1359:
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy139;
	} else {
		if (yych <= 'Z') goto yy144;
		if (yych <= '`') goto yy1360;
		if (yych <= 'z') goto yy144;
	}
yy1360:
	{
		DEBUG_OUTPUT("midnight | today");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1361:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= '@') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych <= 'Q') goto yy142;
			if (yych <= 'R') goto yy1367;
			goto yy1368;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'r') goto yy1367;
			if (yych <= 's') goto yy1368;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1362:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy166;
			goto yy139;
		} else {
			if (yych <= '@') goto yy166;
			if (yych <= 'Q') goto yy142;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy166;
			goto yy142;
		} else {
			if (yych <= 'r') goto yy1363;
			if (yych <= 'z') goto yy142;
			goto yy166;
		}
	}
yy1363:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy143;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 's') goto yy1364;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1364:
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy144;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'd') goto yy1365;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1365:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'A') goto yy1366;
		if (yych != 'a') goto yy3;
	}
yy1366:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy172;
	if (yych == 'y') goto yy172;
	goto yy56;
yy1367:
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy143;
			goto yy1178;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'd') goto yy1178;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1368:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy3;
			goto yy1044;
		} else {
			if (yych == ' ') goto yy1044;
			goto yy3;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy139;
			if (yych <= '@') goto yy3;
			goto yy143;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1369:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy142;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 't') goto yy1370;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1370:
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy143;
			goto yy1178;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'h') goto yy1178;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1371:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1369;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'n') goto yy1401;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1372:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy139;
			} else {
				if (yych == '-') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy147;
				goto yy3;
			} else {
				if (yych == 'I') goto yy1361;
				goto yy141;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'U') goto yy1362;
				goto yy141;
			} else {
				if (yych == '_') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy1393;
				goto yy146;
			} else {
				if (yych <= 'u') goto yy1394;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1373:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy139;
			} else {
				if (yych == '-') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy147;
				goto yy3;
			} else {
				if (yych == 'D') goto yy1350;
				goto yy141;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'M') goto yy1351;
				goto yy141;
			} else {
				if (yych == '_') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= 'l') {
				if (yych == 'd') goto yy1384;
				goto yy146;
			} else {
				if (yych <= 'm') goto yy1385;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1374:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1346;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'e') goto yy1380;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1375:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1342;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'e') goto yy1376;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1376:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'K') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'L') goto yy1343;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'k') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'l') goto yy1377;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1377:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'F') goto yy1344;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'e') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'f') goto yy1378;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1378:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1345;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 't') goto yy1379;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1379:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'H') goto yy1145;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'h') goto yy1163;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1380:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy166;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy166;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1347;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy166;
			goto yy147;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy166;
				goto yy150;
			} else {
				if (yych <= 's') goto yy1381;
				if (yych <= 'z') goto yy150;
				goto yy166;
			}
		}
	}
yy1381:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1348;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'd') goto yy1382;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1382:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1349;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1383;
			if (yych <= 'z') goto yy152;
			goto yy3;
		}
	}
yy1383:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Y') goto yy172;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'y') goto yy185;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1384:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1358;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1391;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy1385:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy1352;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'o') goto yy1386;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1386:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1353;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'r') goto yy1387;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1387:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1354;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'r') goto yy1388;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1388:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'O') goto yy1355;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'o') goto yy1389;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1389:
	yych = *++YYCURSOR;
	if (yych == 'W') goto yy1356;
	if (yych != 'w') goto yy154;
	yyaccept = 28;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy153;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy147;
		goto yy1357;
	} else {
		if (yych <= '/') goto yy147;
		if (yych == '_') goto yy147;
		goto yy1357;
	}
yy1391:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy1359;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'y') goto yy1392;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1392:
	yyaccept = 29;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy1360;
		} else {
			if (yych == '.') goto yy1360;
			goto yy147;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy1360;
			if (yych <= 'Z') goto yy144;
			goto yy1360;
		} else {
			if (yych <= '_') goto yy147;
			if (yych <= '`') goto yy1360;
			if (yych <= 'z') goto yy152;
			goto yy1360;
		}
	}
yy1393:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych <= '/') {
				if (yych <= '.') goto yy3;
				goto yy147;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'Q') goto yy142;
				goto yy1367;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'S') goto yy1368;
				goto yy142;
			} else {
				if (yych == '_') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'q') goto yy150;
				goto yy1399;
			} else {
				if (yych <= 's') goto yy1400;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1394:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy166;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy166;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1363;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy166;
			goto yy147;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy166;
				goto yy150;
			} else {
				if (yych <= 'r') goto yy1395;
				if (yych <= 'z') goto yy150;
				goto yy166;
			}
		}
	}
yy1395:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1364;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 's') goto yy1396;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1396:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1365;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'd') goto yy1397;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1397:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1366;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1398;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1398:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy172;
	if (yych == 'y') goto yy185;
	goto yy154;
yy1399:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1178;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'd') goto yy1207;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1400:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1044;
			if (yych <= 0x1F) goto yy3;
			goto yy1044;
		} else {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy3;
				goto yy147;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1401:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1370;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 't') goto yy1402;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1402:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1178;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'h') goto yy1207;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1403:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= '@') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == 'R') goto yy1415;
			if (yych <= 'X') goto yy141;
			goto yy1416;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			if (yych <= 'q') goto yy141;
			goto yy1415;
		} else {
			if (yych == 'y') goto yy1416;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1404:
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy141;
			goto yy1409;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'd') goto yy1409;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1405:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy141;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'n') goto yy1406;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1406:
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy166;
			goto yy139;
		} else {
			if (yych <= '@') goto yy166;
			if (yych <= 'C') goto yy142;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy166;
			goto yy142;
		} else {
			if (yych <= 'd') goto yy1407;
			if (yych <= 'z') goto yy142;
			goto yy166;
		}
	}
yy1407:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy143;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1408;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1408:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy144;
			goto yy1175;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'y') goto yy1175;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1409:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy142;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'n') goto yy1410;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1410:
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'H') goto yy143;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'i') goto yy1411;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1411:
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'F') goto yy144;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'g') goto yy1412;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1412:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'H') goto yy1413;
		if (yych != 'h') goto yy3;
	}
yy1413:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1414;
	if (yych != 't') goto yy56;
yy1414:
	yych = *++YYCURSOR;
	goto yy1360;
yy1415:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy193;
			} else {
				if (yych <= '-') goto yy196;
				if (yych <= '.') goto yy195;
				goto yy193;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy195;
				goto yy193;
			} else {
				if (yych == 'C') goto yy1417;
				goto yy142;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'c') goto yy1417;
				if (yych <= 'z') goto yy142;
				goto yy193;
			}
		}
	}
yy1416:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy195;
			if (yych <= 0x1F) goto yy193;
			goto yy195;
		} else {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy193;
			goto yy196;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy193;
			if (yych <= '9') goto yy195;
			goto yy193;
		} else {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy193;
			if (yych <= 'z') goto yy142;
			goto yy193;
		}
	}
yy1417:
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy143;
			goto yy335;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'h') goto yy335;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1418:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy139;
			} else {
				if (yych == '-') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy147;
				goto yy3;
			} else {
				if (yych == 'R') goto yy1415;
				goto yy141;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'Y') goto yy1416;
				goto yy141;
			} else {
				if (yych == '_') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= 'x') {
				if (yych == 'r') goto yy1430;
				goto yy146;
			} else {
				if (yych <= 'y') goto yy1431;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1419:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1409;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'd') goto yy1424;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1420:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1406;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'n') goto yy1421;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1421:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy166;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy166;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1407;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy166;
			goto yy147;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy166;
				goto yy150;
			} else {
				if (yych <= 'd') goto yy1422;
				if (yych <= 'z') goto yy150;
				goto yy166;
			}
		}
	}
yy1422:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1408;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1423;
			if (yych <= 'z') goto yy151;
			goto yy3;
		}
	}
yy1423:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy1175;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'y') goto yy1204;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1424:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1410;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'n') goto yy1425;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1425:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'I') goto yy1411;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'i') goto yy1426;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1426:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'G') goto yy1412;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'f') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'g') goto yy1427;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1427:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'H') goto yy1413;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'h') goto yy1428;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1428:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1414;
	if (yych != 't') goto yy154;
	yyaccept = 29;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy153;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy147;
		goto yy1360;
	} else {
		if (yych <= '/') goto yy147;
		if (yych == '_') goto yy147;
		goto yy1360;
	}
yy1430:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy139;
				if (yych <= ',') goto yy193;
				goto yy311;
			} else {
				if (yych == '/') goto yy147;
				goto yy195;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'B') {
				if (yych <= '@') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'C') goto yy1417;
				if (yych <= 'Z') goto yy142;
				goto yy193;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy193;
				goto yy150;
			} else {
				if (yych <= 'c') goto yy1432;
				if (yych <= 'z') goto yy150;
				goto yy193;
			}
		}
	}
yy1431:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy195;
			if (yych <= 0x1F) goto yy193;
			goto yy195;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy193;
				goto yy139;
			} else {
				if (yych <= ',') goto yy193;
				if (yych <= '-') goto yy311;
				goto yy195;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy147;
			if (yych <= '9') goto yy195;
			if (yych <= '@') goto yy193;
			goto yy142;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy193;
				goto yy147;
			} else {
				if (yych <= '`') goto yy193;
				if (yych <= 'z') goto yy150;
				goto yy193;
			}
		}
	}
yy1432:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy335;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'h') goto yy346;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1433:
	yych = *++YYCURSOR;
	if (yych <= 'W') {
		if (yych <= 'N') {
			if (yych == ')') goto yy139;
			if (yych <= '@') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'O') goto yy1441;
			if (yych <= 'U') goto yy141;
			if (yych <= 'V') goto yy1442;
			goto yy1439;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			if (yych <= 'n') goto yy141;
			goto yy1441;
		} else {
			if (yych <= 'v') {
				if (yych <= 'u') goto yy141;
				goto yy1442;
			} else {
				if (yych <= 'w') goto yy1439;
				if (yych <= 'z') goto yy141;
				goto yy3;
			}
		}
	}
yy1434:
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'W') goto yy141;
			goto yy1438;
		}
	} else {
		if (yych <= 'w') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'x') goto yy1438;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1435:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy141;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'n') goto yy1436;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1436:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy142;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 't') goto yy1437;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1437:
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy143;
			goto yy1178;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'h') goto yy1178;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1438:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy142;
			goto yy1368;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 't') goto yy1368;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1439:
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy139;
	} else {
		if (yych <= 'Z') goto yy142;
		if (yych <= '`') goto yy1440;
		if (yych <= 'z') goto yy142;
	}
yy1440:
	{
		DEBUG_OUTPUT("now");
		TIMELIB_INIT;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1441:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy142;
			goto yy1447;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'n') goto yy1447;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1442:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy193;
			} else {
				if (yych <= '-') goto yy196;
				if (yych <= '.') goto yy195;
				goto yy193;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy195;
				goto yy193;
			} else {
				if (yych != 'E') goto yy142;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'e') goto yy1443;
				if (yych <= 'z') goto yy142;
				goto yy193;
			}
		}
	}
yy1443:
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'L') goto yy143;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'm') goto yy1444;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1444:
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy144;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'b') goto yy1445;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1445:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'E') goto yy1446;
		if (yych != 'e') goto yy3;
	}
yy1446:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy204;
	if (yych == 'r') goto yy204;
	goto yy56;
yy1447:
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy139;
	} else {
		if (yych <= 'Z') goto yy143;
		if (yych <= '`') goto yy1448;
		if (yych <= 'z') goto yy143;
	}
yy1448:
	{
		DEBUG_OUTPUT("noon");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TIME();
		s->time->h = 12;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1449:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy139;
			} else {
				if (yych == '-') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= 'N') {
				if (yych <= '/') goto yy147;
				if (yych <= '@') goto yy3;
				goto yy141;
			} else {
				if (yych <= 'O') goto yy1441;
				if (yych <= 'U') goto yy141;
				goto yy1442;
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= '^') {
				if (yych <= 'W') goto yy1439;
				if (yych <= 'Z') goto yy141;
				goto yy3;
			} else {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy3;
				goto yy146;
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 'o') goto yy1456;
				if (yych <= 'u') goto yy146;
				goto yy1457;
			} else {
				if (yych <= 'w') goto yy1455;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1450:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'X') goto yy1438;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'w') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'x') goto yy1454;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1451:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1436;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'n') goto yy1452;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1452:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1437;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 't') goto yy1453;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1453:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1178;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'h') goto yy1207;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1454:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1368;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 't') goto yy1400;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1455:
	yyaccept = 30;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy1440;
		} else {
			if (yych == '.') goto yy1440;
			goto yy147;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy1440;
			if (yych <= 'Z') goto yy142;
			goto yy1440;
		} else {
			if (yych <= '_') goto yy147;
			if (yych <= '`') goto yy1440;
			if (yych <= 'z') goto yy150;
			goto yy1440;
		}
	}
yy1456:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1447;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'n') goto yy1462;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1457:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy139;
				if (yych <= ',') goto yy193;
				goto yy311;
			} else {
				if (yych == '/') goto yy147;
				goto yy195;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'E') goto yy1443;
				if (yych <= 'Z') goto yy142;
				goto yy193;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy193;
				goto yy150;
			} else {
				if (yych <= 'e') goto yy1458;
				if (yych <= 'z') goto yy150;
				goto yy193;
			}
		}
	}
yy1458:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'M') goto yy1444;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'l') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'm') goto yy1459;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1459:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy1445;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'b') goto yy1460;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1460:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'E') goto yy1446;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'e') goto yy1461;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1461:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy204;
	if (yych == 'r') goto yy316;
	goto yy154;
yy1462:
	yyaccept = 31;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy1448;
		} else {
			if (yych == '.') goto yy1448;
			goto yy147;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy1448;
			if (yych <= 'Z') goto yy143;
			goto yy1448;
		} else {
			if (yych <= '_') goto yy147;
			if (yych <= '`') goto yy1448;
			if (yych <= 'z') goto yy151;
			goto yy1448;
		}
	}
yy1463:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy141;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 's') goto yy1464;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1464:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy142;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 't') goto yy1465;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1465:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy143;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'e') goto yy1466;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1466:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy144;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'r') goto yy1467;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1467:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'D') goto yy1468;
		if (yych != 'd') goto yy3;
	}
yy1468:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1469;
	if (yych != 'a') goto yy56;
yy1469:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1470;
	if (yych != 'y') goto yy56;
yy1470:
	++YYCURSOR;
yy1471:
	{
		DEBUG_OUTPUT("yesterday");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = -1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1472:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1464;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 's') goto yy1473;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1473:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1465;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 't') goto yy1474;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1474:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1466;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'e') goto yy1475;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1475:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1467;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'r') goto yy1476;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1476:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'D') goto yy1468;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'd') goto yy1477;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1477:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1469;
	if (yych != 'a') goto yy154;
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1470;
	if (yych != 'y') goto yy154;
	yyaccept = 32;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy153;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy147;
		goto yy1471;
	} else {
		if (yych <= '/') goto yy147;
		if (yych == '_') goto yy147;
		goto yy1471;
	}
}

}

#define YYMAXFILL 33

timelib_time* timelib_strtotime(char *s, size_t len, struct timelib_error_container **errors, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_get_wrapper)
{
	Scanner in;
	int t;
	char *e = s + len - 1;

	memset(&in, 0, sizeof(in));
	in.errors = timelib_malloc(sizeof(struct timelib_error_container));
	in.errors->warning_count = 0;
	in.errors->warning_messages = NULL;
	in.errors->error_count = 0;
	in.errors->error_messages = NULL;

	if (len > 0) {
		while (isspace(*s) && s < e) {
			s++;
		}
		while (isspace(*e) && e > s) {
			e--;
		}
	}
	if (e - s < 0) {
		in.time = timelib_time_ctor();
		add_error(&in, "Empty string");
		if (errors) {
			*errors = in.errors;
		} else {
			timelib_error_container_dtor(in.errors);
		}
		in.time->y = in.time->d = in.time->m = in.time->h = in.time->i = in.time->s = in.time->f = in.time->dst = in.time->z = TIMELIB_UNSET;
		in.time->is_localtime = in.time->zone_type = 0;
		return in.time;
	}
	e++;

	in.str = timelib_malloc((e - s) + YYMAXFILL);
	memset(in.str, 0, (e - s) + YYMAXFILL);
	memcpy(in.str, s, (e - s));
	in.lim = in.str + (e - s) + YYMAXFILL;
	in.cur = in.str;
	in.time = timelib_time_ctor();
	in.time->y = TIMELIB_UNSET;
	in.time->d = TIMELIB_UNSET;
	in.time->m = TIMELIB_UNSET;
	in.time->h = TIMELIB_UNSET;
	in.time->i = TIMELIB_UNSET;
	in.time->s = TIMELIB_UNSET;
	in.time->f = TIMELIB_UNSET;
	in.time->z = TIMELIB_UNSET;
	in.time->dst = TIMELIB_UNSET;
	in.tzdb = tzdb;
	in.time->is_localtime = 0;
	in.time->zone_type = 0;
	in.time->relative.days = TIMELIB_UNSET;

	do {
		t = scan(&in, tz_get_wrapper);
#ifdef DEBUG_PARSER
		printf("%d\n", t);
#endif
	} while(t != EOI);

	/* do funky checking whether the parsed time was valid time */
	if (in.time->have_time && !timelib_valid_time( in.time->h, in.time->i, in.time->s)) {
		add_warning(&in, "The parsed time was invalid");
	}
	/* do funky checking whether the parsed date was valid date */
	if (in.time->have_date && !timelib_valid_date( in.time->y, in.time->m, in.time->d)) {
		add_warning(&in, "The parsed date was invalid");
	}

	timelib_free(in.str);
	if (errors) {
		*errors = in.errors;
	} else {
		timelib_error_container_dtor(in.errors);
	}
	return in.time;
}

#define TIMELIB_CHECK_NUMBER                                           \
		if (strchr("0123456789", *ptr) == NULL)                        \
		{                                                              \
			add_pbf_error(s, "Unexpected data found.", string, begin); \
		}
#define TIMELIB_CHECK_SIGNED_NUMBER                                    \
		if (strchr("-0123456789", *ptr) == NULL)                       \
		{                                                              \
			add_pbf_error(s, "Unexpected data found.", string, begin); \
		}

static void timelib_time_reset_fields(timelib_time *time)
{
	assert(time != NULL);

	time->y = 1970;
	time->m = 1;
	time->d = 1;
	time->h = time->i = time->s = 0;
	time->f = 0.0;
	time->tz_info = NULL;
}

static void timelib_time_reset_unset_fields(timelib_time *time)
{
	assert(time != NULL);

	if (time->y == TIMELIB_UNSET ) time->y = 1970;
	if (time->m == TIMELIB_UNSET ) time->m = 1;
	if (time->d == TIMELIB_UNSET ) time->d = 1;
	if (time->h == TIMELIB_UNSET ) time->h = 0;
	if (time->i == TIMELIB_UNSET ) time->i = 0;
	if (time->s == TIMELIB_UNSET ) time->s = 0;
	if (time->f == TIMELIB_UNSET ) time->f = 0.0;
}

timelib_time *timelib_parse_from_format(char *format, char *string, size_t len, timelib_error_container **errors, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_get_wrapper)
{
	char       *fptr = format;
	char       *ptr = string;
	char       *begin;
	timelib_sll tmp;
	Scanner in;
	Scanner *s = &in;
	int allow_extra = 0;

	memset(&in, 0, sizeof(in));
	in.errors = timelib_malloc(sizeof(struct timelib_error_container));
	in.errors->warning_count = 0;
	in.errors->warning_messages = NULL;
	in.errors->error_count = 0;
	in.errors->error_messages = NULL;

	in.time = timelib_time_ctor();
	in.time->y = TIMELIB_UNSET;
	in.time->d = TIMELIB_UNSET;
	in.time->m = TIMELIB_UNSET;
	in.time->h = TIMELIB_UNSET;
	in.time->i = TIMELIB_UNSET;
	in.time->s = TIMELIB_UNSET;
	in.time->f = TIMELIB_UNSET;
	in.time->z = TIMELIB_UNSET;
	in.time->dst = TIMELIB_UNSET;
	in.tzdb = tzdb;
	in.time->is_localtime = 0;
	in.time->zone_type = 0;

	/* Loop over the format string */
	while (*fptr && *ptr) {
		begin = ptr;
		switch (*fptr) {
			case 'D': /* three letter day */
			case 'l': /* full day */
				{
					const timelib_relunit* tmprel = 0;

					tmprel = timelib_lookup_relunit((char **) &ptr);
					if (!tmprel) {
						add_pbf_error(s, "A textual day could not be found", string, begin);
						break;
					} else {
						in.time->have_relative = 1;
						in.time->relative.have_weekday_relative = 1;
						in.time->relative.weekday = tmprel->multiplier;
						in.time->relative.weekday_behavior = 1;
					}
				}
				break;
			case 'd': /* two digit day, with leading zero */
			case 'j': /* two digit day, without leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->d = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A two digit day could not be found", string, begin);
				}
				break;
			case 'S': /* day suffix, ignored, nor checked */
				timelib_skip_day_suffix((char **) &ptr);
				break;
			case 'z': /* day of year - resets month (0 based) - also initializes everything else to !TIMELIB_UNSET */
				TIMELIB_CHECK_NUMBER;
				if ((tmp = timelib_get_nr((char **) &ptr, 3)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A three digit day-of-year could not be found", string, begin);
				} else {
					s->time->m = 1;
					s->time->d = tmp + 1;
					timelib_do_normalize(s->time);
				}
				break;

			case 'm': /* two digit month, with leading zero */
			case 'n': /* two digit month, without leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->m = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A two digit month could not be found", string, begin);
				}
				break;
			case 'M': /* three letter month */
			case 'F': /* full month */
				tmp = timelib_lookup_month((char **) &ptr);
				if (!tmp) {
					add_pbf_error(s, "A textual month could not be found", string, begin);
				} else {
					s->time->m = tmp;
				}
				break;
			case 'y': /* two digit year */
				{
					int length = 0;
					TIMELIB_CHECK_NUMBER;
					if ((s->time->y = timelib_get_nr_ex((char **) &ptr, 2, &length)) == TIMELIB_UNSET) {
						add_pbf_error(s, "A two digit year could not be found", string, begin);
					}
					TIMELIB_PROCESS_YEAR(s->time->y, length);
				}
				break;
			case 'Y': /* four digit year */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->y = timelib_get_nr((char **) &ptr, 4)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A four digit year could not be found", string, begin);
				}
				break;
			case 'g': /* two digit hour, with leading zero */
			case 'h': /* two digit hour, without leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->h = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A two digit hour could not be found", string, begin);
				}
				if (s->time->h > 12) {
					add_pbf_error(s, "Hour can not be higher than 12", string, begin);
				}
				break;
			case 'G': /* two digit hour, with leading zero */
			case 'H': /* two digit hour, without leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->h = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A two digit hour could not be found", string, begin);
				}
				break;
			case 'a': /* am/pm/a.m./p.m. */
			case 'A': /* AM/PM/A.M./P.M. */
				if (s->time->h == TIMELIB_UNSET) {
					add_pbf_error(s, "Meridian can only come after an hour has been found", string, begin);
				} else if ((tmp = timelib_meridian_with_check((char **) &ptr, s->time->h)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A meridian could not be found", string, begin);
				} else {
					s->time->h += tmp;
				}
				break;
			case 'i': /* two digit minute, with leading zero */
				{
					int length;
					timelib_sll min;

					TIMELIB_CHECK_NUMBER;
					min = timelib_get_nr_ex((char **) &ptr, 2, &length);
					if (min == TIMELIB_UNSET || length != 2) {
						add_pbf_error(s, "A two digit minute could not be found", string, begin);
					} else {
						s->time->i = min;
					}
				}
				break;
			case 's': /* two digit second, with leading zero */
				{
					int length;
					timelib_sll sec;

					TIMELIB_CHECK_NUMBER;
					sec = timelib_get_nr_ex((char **) &ptr, 2, &length);
					if (sec == TIMELIB_UNSET || length != 2) {
						add_pbf_error(s, "A two digit second could not be found", string, begin);
					} else {
						s->time->s = sec;
					}
				}
				break;
			case 'u': /* up to six digit millisecond */
				{
					double f;
					char *tptr;

					TIMELIB_CHECK_NUMBER;
					tptr = ptr;
					if ((f = timelib_get_nr((char **) &ptr, 6)) == TIMELIB_UNSET || (ptr - tptr < 1)) {
						add_pbf_error(s, "A six digit millisecond could not be found", string, begin);
					} else {
						s->time->f = (f / pow(10, (ptr - tptr)));
					}
				}
				break;
			case ' ': /* any sort of whitespace (' ' and \t) */
				timelib_eat_spaces((char **) &ptr);
				break;
			case 'U': /* epoch seconds */
				TIMELIB_CHECK_SIGNED_NUMBER;
				TIMELIB_HAVE_RELATIVE();
				tmp = timelib_get_unsigned_nr((char **) &ptr, 24);
				s->time->y = 1970;
				s->time->m = 1;
				s->time->d = 1;
				s->time->h = s->time->i = s->time->s = 0;
				s->time->f = 0.0;
				s->time->relative.s += tmp;
				s->time->is_localtime = 1;
				s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
				s->time->z = 0;
				s->time->dst = 0;
				break;

			case 'e': /* timezone */
			case 'P': /* timezone */
			case 'T': /* timezone */
			case 'O': /* timezone */
				{
					int tz_not_found;
					s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
					if (tz_not_found) {
						add_pbf_error(s, "The timezone could not be found in the database", string, begin);
					}
				}
				break;

			case '#': /* separation symbol */
				if (*ptr == ';' || *ptr == ':' || *ptr == '/' || *ptr == '.' || *ptr == ',' || *ptr == '-' || *ptr == '(' || *ptr == ')') {
					++ptr;
				} else {
					add_pbf_error(s, "The separation symbol ([;:/.,-]) could not be found", string, begin);
				}
				break;

			case ';':
			case ':':
			case '/':
			case '.':
			case ',':
			case '-':
			case '(':
			case ')':
				if (*ptr == *fptr) {
					++ptr;
				} else {
					add_pbf_error(s, "The separation symbol could not be found", string, begin);
				}
				break;

			case '!': /* reset all fields to default */
				timelib_time_reset_fields(s->time);
				break; /* break intentionally not missing */

			case '|': /* reset all fields to default when not set */
				timelib_time_reset_unset_fields(s->time);
				break; /* break intentionally not missing */

			case '?': /* random char */
				++ptr;
				break;

			case '\\': /* escaped char */
				if(!fptr[1]) {
					add_pbf_error(s, "Escaped character expected", string, begin);
					break;
				}
				fptr++;
				if (*ptr == *fptr) {
					++ptr;
				} else {
					add_pbf_error(s, "The escaped character could not be found", string, begin);
				}
				break;

			case '*': /* random chars until a separator or number ([ \t.,:;/-0123456789]) */
				timelib_eat_until_separator((char **) &ptr);
				break;

			case '+': /* allow extra chars in the format */
				allow_extra = 1;
				break;

			default:
				if (*fptr != *ptr) {
					add_pbf_error(s, "The format separator does not match", string, begin);
				}
				ptr++;
		}
		fptr++;
	}
	if (*ptr) {
		if (allow_extra) {
			add_pbf_warning(s, "Trailing data", string, ptr);
		} else {
			add_pbf_error(s, "Trailing data", string, ptr);
		}
	}
	/* ignore trailing +'s */
	while (*fptr == '+') {
		fptr++;
	}
	if (*fptr) {
		/* Trailing | and ! specifiers are valid. */
		int done = 0;
		while (*fptr && !done) {
			switch (*fptr++) {
				case '!': /* reset all fields to default */
					timelib_time_reset_fields(s->time);
					break;

				case '|': /* reset all fields to default when not set */
					timelib_time_reset_unset_fields(s->time);
					break;

				default:
					add_pbf_error(s, "Data missing", string, ptr);
					done = 1;
			}
		}
	}

	/* clean up a bit */
	if (s->time->h != TIMELIB_UNSET || s->time->i != TIMELIB_UNSET || s->time->s != TIMELIB_UNSET) {
		if (s->time->h == TIMELIB_UNSET ) {
			s->time->h = 0;
		}
		if (s->time->i == TIMELIB_UNSET ) {
			s->time->i = 0;
		}
		if (s->time->s == TIMELIB_UNSET ) {
			s->time->s = 0;
		}
	}

	/* do funky checking whether the parsed time was valid time */
	if (s->time->h != TIMELIB_UNSET && s->time->i != TIMELIB_UNSET &&
		s->time->s != TIMELIB_UNSET &&
		!timelib_valid_time( s->time->h, s->time->i, s->time->s)) {
		add_pbf_warning(s, "The parsed time was invalid", string, ptr);
	}
	/* do funky checking whether the parsed date was valid date */
	if (s->time->y != TIMELIB_UNSET && s->time->m != TIMELIB_UNSET &&
		s->time->d != TIMELIB_UNSET &&
		!timelib_valid_date( s->time->y, s->time->m, s->time->d)) {
		add_pbf_warning(s, "The parsed date was invalid", string, ptr);
	}

	if (errors) {
		*errors = in.errors;
	} else {
		timelib_error_container_dtor(in.errors);
	}
	return in.time;
}

void timelib_fill_holes(timelib_time *parsed, timelib_time *now, int options)
{
	if (!(options & TIMELIB_OVERRIDE_TIME) && parsed->have_date && !parsed->have_time) {
		parsed->h = 0;
		parsed->i = 0;
		parsed->s = 0;
		parsed->f = 0;
	}
	if (parsed->y == TIMELIB_UNSET) parsed->y = now->y != TIMELIB_UNSET ? now->y : 0;
	if (parsed->d == TIMELIB_UNSET) parsed->d = now->d != TIMELIB_UNSET ? now->d : 0;
	if (parsed->m == TIMELIB_UNSET) parsed->m = now->m != TIMELIB_UNSET ? now->m : 0;
	if (parsed->h == TIMELIB_UNSET) parsed->h = now->h != TIMELIB_UNSET ? now->h : 0;
	if (parsed->i == TIMELIB_UNSET) parsed->i = now->i != TIMELIB_UNSET ? now->i : 0;
	if (parsed->s == TIMELIB_UNSET) parsed->s = now->s != TIMELIB_UNSET ? now->s : 0;
	if (parsed->f == TIMELIB_UNSET) parsed->f = now->f != TIMELIB_UNSET ? now->f : 0;
	if (parsed->z == TIMELIB_UNSET) parsed->z = now->z != TIMELIB_UNSET ? now->z : 0;
	if (parsed->dst == TIMELIB_UNSET) parsed->dst = now->dst != TIMELIB_UNSET ? now->dst : 0;

	if (!parsed->tz_abbr) {
		parsed->tz_abbr = now->tz_abbr ? timelib_strdup(now->tz_abbr) : NULL;
	}
	if (!parsed->tz_info) {
		parsed->tz_info = now->tz_info ? (!(options & TIMELIB_NO_CLONE) ? timelib_tzinfo_clone(now->tz_info) : now->tz_info) : NULL;
	}
	if (parsed->zone_type == 0 && now->zone_type != 0) {
		parsed->zone_type = now->zone_type;
/*		parsed->tz_abbr = now->tz_abbr ? timelib_strdup(now->tz_abbr) : NULL;
		parsed->tz_info = now->tz_info ? timelib_tzinfo_clone(now->tz_info) : NULL;
*/		parsed->is_localtime = 1;
	}
/*	timelib_dump_date(parsed, 2);
	timelib_dump_date(now, 2);
*/
}

char *timelib_timezone_id_from_abbr(const char *abbr, timelib_long gmtoffset, int isdst)
{
	const timelib_tz_lookup_table *tp;

	tp = abbr_search(abbr, gmtoffset, isdst);
	if (tp) {
		return (tp->full_tz_name);
	} else {
		return NULL;
	}
}

const timelib_tz_lookup_table *timelib_timezone_abbreviations_list(void)
{
	return timelib_timezone_lookup;
}

#ifdef DEBUG_PARSER_STUB
int main(void)
{
	timelib_time time = timelib_strtotime("May 12");

	printf ("%04d-%02d-%02d %02d:%02d:%02d.%-5d %+04d %1d",
		time.y, time.m, time.d, time.h, time.i, time.s, time.f, time.z, time.dst);
	if (time.have_relative) {
		printf ("%3dY %3dM %3dD / %3dH %3dM %3dS",
			time.relative.y, time.relative.m, time.relative.d, time.relative.h, time.relative.i, time.relative.s);
	}
	if (time.have_weekday_relative) {
		printf (" / %d", time.relative.weekday);
	}
	if (time.have_weeknr_day) {
		printf(" / %dW%d", time.relative.weeknr_day.weeknr, time.relative.weeknr_day.dayofweek);
	}
	return 0;
}
#endif

/*
 * vim: syntax=c
 */
