/* Generated by re2c 0.13.5 */
#line 1 "Zend/zend_language_scanner.l"
/*
   +----------------------------------------------------------------------+
   | Zend Engine                                                          |
   +----------------------------------------------------------------------+
   | Copyright (c) 1998-2015 Zend Technologies Ltd. (http://www.zend.com) |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.00 of the Zend license,     |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.zend.com/license/2_00.txt.                                |
   | If you did not receive a copy of the Zend license and are unable to  |
   | obtain it through the world-wide-web, please send a note to          |
   | license@zend.com so we can mail you a copy immediately.              |
   +----------------------------------------------------------------------+
   | Authors: Marcus Boerger <helly@php.net>                              |
   |          Nuno Lopes <nlopess@php.net>                                |
   |          Scott MacVicar <scottmac@php.net>                           |
   | Flex version authors:                                                |
   |          Andi Gutmans <andi@zend.com>                                |
   |          Zeev Suraski <zeev@zend.com>                                |
   +----------------------------------------------------------------------+
*/

/* $Id$ */

#if 0
# define YYDEBUG(s, c) printf("state: %d char: %c\n", s, c)
#else
# define YYDEBUG(s, c)
#endif

#include "zend_language_scanner_defs.h"

#include <errno.h>
#include "zend.h"
#ifdef ZEND_WIN32
# include <Winuser.h>
#endif
#include "zend_alloc.h"
#include <zend_language_parser.h>
#include "zend_compile.h"
#include "zend_language_scanner.h"
#include "zend_highlight.h"
#include "zend_constants.h"
#include "zend_variables.h"
#include "zend_operators.h"
#include "zend_API.h"
#include "zend_strtod.h"
#include "zend_exceptions.h"
#include "zend_virtual_cwd.h"
#include "tsrm_config_common.h"

#define YYCTYPE   unsigned char
#define YYFILL(n) { if ((YYCURSOR + n) >= (YYLIMIT + ZEND_MMAP_AHEAD)) { return 0; } }
#define YYCURSOR  SCNG(yy_cursor)
#define YYLIMIT   SCNG(yy_limit)
#define YYMARKER  SCNG(yy_marker)

#define YYGETCONDITION()  SCNG(yy_state)
#define YYSETCONDITION(s) SCNG(yy_state) = s

#define STATE(name)  yyc##name

/* emulate flex constructs */
#define BEGIN(state) YYSETCONDITION(STATE(state))
#define YYSTATE      YYGETCONDITION()
#define yytext       ((char*)SCNG(yy_text))
#define yyleng       SCNG(yy_leng)
#define yyless(x)    do { YYCURSOR = (unsigned char*)yytext + x; \
                          yyleng   = (unsigned int)x; } while(0)
#define yymore()     goto yymore_restart

/* perform sanity check. If this message is triggered you should
   increase the ZEND_MMAP_AHEAD value in the zend_streams.h file */
#define YYMAXFILL 16
#if ZEND_MMAP_AHEAD < YYMAXFILL
# error ZEND_MMAP_AHEAD should be greater than or equal to YYMAXFILL
#endif

#ifdef HAVE_STDARG_H
# include <stdarg.h>
#endif

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif

/* Globals Macros */
#define SCNG	LANG_SCNG
#ifdef ZTS
ZEND_API ts_rsrc_id language_scanner_globals_id;
#else
ZEND_API zend_php_scanner_globals language_scanner_globals;
#endif

#define HANDLE_NEWLINES(s, l)													\
do {																			\
	char *p = (s), *boundary = p+(l);											\
																				\
	while (p<boundary) {														\
		if (*p == '\n' || (*p == '\r' && (*(p+1) != '\n'))) {					\
			CG(zend_lineno)++;													\
		}																		\
		p++;																	\
	}																			\
} while (0)

#define HANDLE_NEWLINE(c) \
{ \
	if (c == '\n' || c == '\r') { \
		CG(zend_lineno)++; \
	} \
}

/* To save initial string length after scanning to first variable */
#define SET_DOUBLE_QUOTES_SCANNED_LENGTH(len) SCNG(scanned_string_len) = (len)
#define GET_DOUBLE_QUOTES_SCANNED_LENGTH()    SCNG(scanned_string_len)

#define IS_LABEL_START(c) (((c) >= 'a' && (c) <= 'z') || ((c) >= 'A' && (c) <= 'Z') || (c) == '_' || (c) >= 0x7F)

#define ZEND_IS_OCT(c)  ((c)>='0' && (c)<='7')
#define ZEND_IS_HEX(c)  (((c)>='0' && (c)<='9') || ((c)>='a' && (c)<='f') || ((c)>='A' && (c)<='F'))

BEGIN_EXTERN_C()

static size_t encoding_filter_script_to_internal(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding();
	ZEND_ASSERT(internal_encoding);
	return zend_multibyte_encoding_converter(to, to_length, from, from_length, internal_encoding, LANG_SCNG(script_encoding));
}

static size_t encoding_filter_script_to_intermediate(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	return zend_multibyte_encoding_converter(to, to_length, from, from_length, zend_multibyte_encoding_utf8, LANG_SCNG(script_encoding));
}

static size_t encoding_filter_intermediate_to_script(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	return zend_multibyte_encoding_converter(to, to_length, from, from_length,
LANG_SCNG(script_encoding), zend_multibyte_encoding_utf8);
}

static size_t encoding_filter_intermediate_to_internal(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding();
	ZEND_ASSERT(internal_encoding);
	return zend_multibyte_encoding_converter(to, to_length, from, from_length,
internal_encoding, zend_multibyte_encoding_utf8);
}


static void _yy_push_state(int new_state)
{
	zend_stack_push(&SCNG(state_stack), (void *) &YYGETCONDITION());
	YYSETCONDITION(new_state);
}

#define yy_push_state(state_and_tsrm) _yy_push_state(yyc##state_and_tsrm)

static void yy_pop_state(void)
{
	int *stack_state = zend_stack_top(&SCNG(state_stack));
	YYSETCONDITION(*stack_state);
	zend_stack_del_top(&SCNG(state_stack));
}

static void yy_scan_buffer(char *str, unsigned int len)
{
	YYCURSOR       = (YYCTYPE*)str;
	YYLIMIT        = YYCURSOR + len;
	if (!SCNG(yy_start)) {
		SCNG(yy_start) = YYCURSOR;
	}
}

void startup_scanner(void)
{
	CG(parse_error) = 0;
	CG(doc_comment) = NULL;
	zend_stack_init(&SCNG(state_stack), sizeof(int));
	zend_ptr_stack_init(&SCNG(heredoc_label_stack));
}

static void heredoc_label_dtor(zend_heredoc_label *heredoc_label) {
    efree(heredoc_label->label);
}

void shutdown_scanner(void)
{
	CG(parse_error) = 0;
	RESET_DOC_COMMENT();
	zend_stack_destroy(&SCNG(state_stack));
	zend_ptr_stack_clean(&SCNG(heredoc_label_stack), (void (*)(void *)) &heredoc_label_dtor, 1);
	zend_ptr_stack_destroy(&SCNG(heredoc_label_stack));
	SCNG(on_event) = NULL;
}

ZEND_API void zend_save_lexical_state(zend_lex_state *lex_state)
{
	lex_state->yy_leng   = SCNG(yy_leng);
	lex_state->yy_start  = SCNG(yy_start);
	lex_state->yy_text   = SCNG(yy_text);
	lex_state->yy_cursor = SCNG(yy_cursor);
	lex_state->yy_marker = SCNG(yy_marker);
	lex_state->yy_limit  = SCNG(yy_limit);

	lex_state->state_stack = SCNG(state_stack);
	zend_stack_init(&SCNG(state_stack), sizeof(int));

	lex_state->heredoc_label_stack = SCNG(heredoc_label_stack);
	zend_ptr_stack_init(&SCNG(heredoc_label_stack));

	lex_state->in = SCNG(yy_in);
	lex_state->yy_state = YYSTATE;
	lex_state->filename = zend_get_compiled_filename();
	lex_state->lineno = CG(zend_lineno);

	lex_state->script_org = SCNG(script_org);
	lex_state->script_org_size = SCNG(script_org_size);
	lex_state->script_filtered = SCNG(script_filtered);
	lex_state->script_filtered_size = SCNG(script_filtered_size);
	lex_state->input_filter = SCNG(input_filter);
	lex_state->output_filter = SCNG(output_filter);
	lex_state->script_encoding = SCNG(script_encoding);

	lex_state->on_event = SCNG(on_event);

	lex_state->ast = CG(ast);
	lex_state->ast_arena = CG(ast_arena);
}

ZEND_API void zend_restore_lexical_state(zend_lex_state *lex_state)
{
	SCNG(yy_leng)   = lex_state->yy_leng;
	SCNG(yy_start)  = lex_state->yy_start;
	SCNG(yy_text)   = lex_state->yy_text;
	SCNG(yy_cursor) = lex_state->yy_cursor;
	SCNG(yy_marker) = lex_state->yy_marker;
	SCNG(yy_limit)  = lex_state->yy_limit;

	zend_stack_destroy(&SCNG(state_stack));
	SCNG(state_stack) = lex_state->state_stack;

	zend_ptr_stack_clean(&SCNG(heredoc_label_stack), (void (*)(void *)) &heredoc_label_dtor, 1);
	zend_ptr_stack_destroy(&SCNG(heredoc_label_stack));
	SCNG(heredoc_label_stack) = lex_state->heredoc_label_stack;

	SCNG(yy_in) = lex_state->in;
	YYSETCONDITION(lex_state->yy_state);
	CG(zend_lineno) = lex_state->lineno;
	zend_restore_compiled_filename(lex_state->filename);

	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	SCNG(script_org) = lex_state->script_org;
	SCNG(script_org_size) = lex_state->script_org_size;
	SCNG(script_filtered) = lex_state->script_filtered;
	SCNG(script_filtered_size) = lex_state->script_filtered_size;
	SCNG(input_filter) = lex_state->input_filter;
	SCNG(output_filter) = lex_state->output_filter;
	SCNG(script_encoding) = lex_state->script_encoding;

	SCNG(on_event) = lex_state->on_event;

	CG(ast) = lex_state->ast;
	CG(ast_arena) = lex_state->ast_arena;

	RESET_DOC_COMMENT();
}

ZEND_API void zend_destroy_file_handle(zend_file_handle *file_handle)
{
	zend_llist_del_element(&CG(open_files), file_handle, (int (*)(void *, void *)) zend_compare_file_handles);
	/* zend_file_handle_dtor() operates on the copy, so we have to NULLify the original here */
	file_handle->opened_path = NULL;
	if (file_handle->free_filename) {
		file_handle->filename = NULL;
	}
}

ZEND_API void zend_lex_tstring(zval *zv)
{
	if (SCNG(on_event)) SCNG(on_event)(ON_FEEDBACK, T_STRING, 0);

	ZVAL_STRINGL(zv, (char*)SCNG(yy_text), SCNG(yy_leng));
}

#define BOM_UTF32_BE	"\x00\x00\xfe\xff"
#define	BOM_UTF32_LE	"\xff\xfe\x00\x00"
#define	BOM_UTF16_BE	"\xfe\xff"
#define	BOM_UTF16_LE	"\xff\xfe"
#define	BOM_UTF8		"\xef\xbb\xbf"

static const zend_encoding *zend_multibyte_detect_utf_encoding(const unsigned char *script, size_t script_size)
{
	const unsigned char *p;
	int wchar_size = 2;
	int le = 0;

	/* utf-16 or utf-32? */
	p = script;
	assert(p >= script);
	while ((size_t)(p-script) < script_size) {
		p = memchr(p, 0, script_size-(p-script)-2);
		if (!p) {
			break;
		}
		if (*(p+1) == '\0' && *(p+2) == '\0') {
			wchar_size = 4;
			break;
		}

		/* searching for UTF-32 specific byte orders, so this will do */
		p += 4;
	}

	/* BE or LE? */
	p = script;
	assert(p >= script);
	while ((size_t)(p-script) < script_size) {
		if (*p == '\0' && *(p+wchar_size-1) != '\0') {
			/* BE */
			le = 0;
			break;
		} else if (*p != '\0' && *(p+wchar_size-1) == '\0') {
			/* LE* */
			le = 1;
			break;
		}
		p += wchar_size;
	}

	if (wchar_size == 2) {
		return le ? zend_multibyte_encoding_utf16le : zend_multibyte_encoding_utf16be;
	} else {
		return le ? zend_multibyte_encoding_utf32le : zend_multibyte_encoding_utf32be;
	}

	return NULL;
}

static const zend_encoding* zend_multibyte_detect_unicode(void)
{
	const zend_encoding *script_encoding = NULL;
	int bom_size;
	unsigned char *pos1, *pos2;

	if (LANG_SCNG(script_org_size) < sizeof(BOM_UTF32_LE)-1) {
		return NULL;
	}

	/* check out BOM */
	if (!memcmp(LANG_SCNG(script_org), BOM_UTF32_BE, sizeof(BOM_UTF32_BE)-1)) {
		script_encoding = zend_multibyte_encoding_utf32be;
		bom_size = sizeof(BOM_UTF32_BE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF32_LE, sizeof(BOM_UTF32_LE)-1)) {
		script_encoding = zend_multibyte_encoding_utf32le;
		bom_size = sizeof(BOM_UTF32_LE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF16_BE, sizeof(BOM_UTF16_BE)-1)) {
		script_encoding = zend_multibyte_encoding_utf16be;
		bom_size = sizeof(BOM_UTF16_BE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF16_LE, sizeof(BOM_UTF16_LE)-1)) {
		script_encoding = zend_multibyte_encoding_utf16le;
		bom_size = sizeof(BOM_UTF16_LE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF8, sizeof(BOM_UTF8)-1)) {
		script_encoding = zend_multibyte_encoding_utf8;
		bom_size = sizeof(BOM_UTF8)-1;
	}

	if (script_encoding) {
		/* remove BOM */
		LANG_SCNG(script_org) += bom_size;
		LANG_SCNG(script_org_size) -= bom_size;

		return script_encoding;
	}

	/* script contains NULL bytes -> auto-detection */
	if ((pos1 = memchr(LANG_SCNG(script_org), 0, LANG_SCNG(script_org_size)))) {
		/* check if the NULL byte is after the __HALT_COMPILER(); */
		pos2 = LANG_SCNG(script_org);

		while (pos1 - pos2 >= sizeof("__HALT_COMPILER();")-1) {
			pos2 = memchr(pos2, '_', pos1 - pos2);
			if (!pos2) break;
			pos2++;
			if (strncasecmp((char*)pos2, "_HALT_COMPILER", sizeof("_HALT_COMPILER")-1) == 0) {
				pos2 += sizeof("_HALT_COMPILER")-1;
				while (*pos2 == ' '  ||
					   *pos2 == '\t' ||
					   *pos2 == '\r' ||
					   *pos2 == '\n') {
					pos2++;
				}
				if (*pos2 == '(') {
					pos2++;
					while (*pos2 == ' '  ||
						   *pos2 == '\t' ||
						   *pos2 == '\r' ||
						   *pos2 == '\n') {
						pos2++;
					}
					if (*pos2 == ')') {
						pos2++;
						while (*pos2 == ' '  ||
							   *pos2 == '\t' ||
							   *pos2 == '\r' ||
							   *pos2 == '\n') {
							pos2++;
						}
						if (*pos2 == ';') {
							return NULL;
						}
					}
				}
			}
		}
		/* make best effort if BOM is missing */
		return zend_multibyte_detect_utf_encoding(LANG_SCNG(script_org), LANG_SCNG(script_org_size));
	}

	return NULL;
}

static const zend_encoding* zend_multibyte_find_script_encoding(void)
{
	const zend_encoding *script_encoding;

	if (CG(detect_unicode)) {
		/* check out bom(byte order mark) and see if containing wchars */
		script_encoding = zend_multibyte_detect_unicode();
		if (script_encoding != NULL) {
			/* bom or wchar detection is prior to 'script_encoding' option */
			return script_encoding;
		}
	}

	/* if no script_encoding specified, just leave alone */
	if (!CG(script_encoding_list) || !CG(script_encoding_list_size)) {
		return NULL;
	}

	/* if multiple encodings specified, detect automagically */
	if (CG(script_encoding_list_size) > 1) {
		return zend_multibyte_encoding_detector(LANG_SCNG(script_org), LANG_SCNG(script_org_size), CG(script_encoding_list), CG(script_encoding_list_size));
	}

	return CG(script_encoding_list)[0];
}

ZEND_API int zend_multibyte_set_filter(const zend_encoding *onetime_encoding)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding();
	const zend_encoding *script_encoding = onetime_encoding ? onetime_encoding: zend_multibyte_find_script_encoding();

	if (!script_encoding) {
		return FAILURE;
	}

	/* judge input/output filter */
	LANG_SCNG(script_encoding) = script_encoding;
	LANG_SCNG(input_filter) = NULL;
	LANG_SCNG(output_filter) = NULL;

	if (!internal_encoding || LANG_SCNG(script_encoding) == internal_encoding) {
		if (!zend_multibyte_check_lexer_compatibility(LANG_SCNG(script_encoding))) {
			/* and if not, work around w/ script_encoding -> utf-8 -> script_encoding conversion */
			LANG_SCNG(input_filter) = encoding_filter_script_to_intermediate;
			LANG_SCNG(output_filter) = encoding_filter_intermediate_to_script;
		} else {
			LANG_SCNG(input_filter) = NULL;
			LANG_SCNG(output_filter) = NULL;
		}
		return SUCCESS;
	}

	if (zend_multibyte_check_lexer_compatibility(internal_encoding)) {
		LANG_SCNG(input_filter) = encoding_filter_script_to_internal;
		LANG_SCNG(output_filter) = NULL;
	} else if (zend_multibyte_check_lexer_compatibility(LANG_SCNG(script_encoding))) {
		LANG_SCNG(input_filter) = NULL;
		LANG_SCNG(output_filter) = encoding_filter_script_to_internal;
	} else {
		/* both script and internal encodings are incompatible w/ flex */
		LANG_SCNG(input_filter) = encoding_filter_script_to_intermediate;
		LANG_SCNG(output_filter) = encoding_filter_intermediate_to_internal;
	}

	return 0;
}

ZEND_API int open_file_for_scanning(zend_file_handle *file_handle)
{
	char *buf;
	size_t size, offset = 0;
	zend_string *compiled_filename;

	/* The shebang line was read, get the current position to obtain the buffer start */
	if (CG(start_lineno) == 2 && file_handle->type == ZEND_HANDLE_FP && file_handle->handle.fp) {
		if ((offset = ftell(file_handle->handle.fp)) == -1) {
			offset = 0;
		}
	}

	if (zend_stream_fixup(file_handle, &buf, &size) == FAILURE) {
		return FAILURE;
	}

	zend_llist_add_element(&CG(open_files), file_handle);
	if (file_handle->handle.stream.handle >= (void*)file_handle && file_handle->handle.stream.handle <= (void*)(file_handle+1)) {
		zend_file_handle *fh = (zend_file_handle*)zend_llist_get_last(&CG(open_files));
		size_t diff = (char*)file_handle->handle.stream.handle - (char*)file_handle;
		fh->handle.stream.handle = (void*)(((char*)fh) + diff);
		file_handle->handle.stream.handle = fh->handle.stream.handle;
	}

	/* Reset the scanner for scanning the new file */
	SCNG(yy_in) = file_handle;
	SCNG(yy_start) = NULL;

	if (size != -1) {
		if (CG(multibyte)) {
			SCNG(script_org) = (unsigned char*)buf;
			SCNG(script_org_size) = size;
			SCNG(script_filtered) = NULL;

			zend_multibyte_set_filter(NULL);

			if (SCNG(input_filter)) {
				if ((size_t)-1 == SCNG(input_filter)(&SCNG(script_filtered), &SCNG(script_filtered_size), SCNG(script_org), SCNG(script_org_size))) {
					zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
							"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
				}
				buf = (char*)SCNG(script_filtered);
				size = SCNG(script_filtered_size);
			}
		}
		SCNG(yy_start) = (unsigned char *)buf - offset;
		yy_scan_buffer(buf, (unsigned int)size);
	} else {
		zend_error_noreturn(E_COMPILE_ERROR, "zend_stream_mmap() failed");
	}

	BEGIN(INITIAL);

	if (file_handle->opened_path) {
		compiled_filename = zend_string_copy(file_handle->opened_path);
	} else {
		compiled_filename = zend_string_init(file_handle->filename, strlen(file_handle->filename), 0);
	}

	zend_set_compiled_filename(compiled_filename);
	zend_string_release(compiled_filename);

	if (CG(start_lineno)) {
		CG(zend_lineno) = CG(start_lineno);
		CG(start_lineno) = 0;
	} else {
		CG(zend_lineno) = 1;
	}

	RESET_DOC_COMMENT();
	CG(increment_lineno) = 0;
	return SUCCESS;
}
END_EXTERN_C()


ZEND_API zend_op_array *compile_file(zend_file_handle *file_handle, int type)
{
	zend_lex_state original_lex_state;
	zend_op_array *op_array = NULL;
	zend_save_lexical_state(&original_lex_state);

	if (open_file_for_scanning(file_handle)==FAILURE) {
		if (type==ZEND_REQUIRE) {
			zend_message_dispatcher(ZMSG_FAILED_REQUIRE_FOPEN, file_handle->filename);
			zend_bailout();
		} else {
			zend_message_dispatcher(ZMSG_FAILED_INCLUDE_FOPEN, file_handle->filename);
		}
	} else {
		zend_bool original_in_compilation = CG(in_compilation);
		CG(in_compilation) = 1;

		CG(ast) = NULL;
		CG(ast_arena) = zend_arena_create(1024 * 32);
		if (!zendparse()) {
			zval retval_zv;
			zend_file_context original_file_context;
			zend_oparray_context original_oparray_context;
			zend_op_array *original_active_op_array = CG(active_op_array);
			op_array = emalloc(sizeof(zend_op_array));
			init_op_array(op_array, ZEND_USER_FUNCTION, INITIAL_OP_ARRAY_SIZE);
			CG(active_op_array) = op_array;
			ZVAL_LONG(&retval_zv, 1);

			if (zend_ast_process) {
				zend_ast_process(CG(ast));
			}

			zend_file_context_begin(&original_file_context);
			zend_oparray_context_begin(&original_oparray_context);
			zend_compile_top_stmt(CG(ast));
			zend_emit_final_return(&retval_zv);
			op_array->line_start = 1;
			op_array->line_end = CG(zend_lineno);
			pass_two(op_array);
			zend_oparray_context_end(&original_oparray_context);
			zend_file_context_end(&original_file_context);

			CG(active_op_array) = original_active_op_array;
		}

		zend_ast_destroy(CG(ast));
		zend_arena_destroy(CG(ast_arena));
		CG(in_compilation) = original_in_compilation;
	}

	zend_restore_lexical_state(&original_lex_state);
	return op_array;
}


zend_op_array *compile_filename(int type, zval *filename)
{
	zend_file_handle file_handle;
	zval tmp;
	zend_op_array *retval;
	zend_string *opened_path = NULL;

	if (Z_TYPE_P(filename) != IS_STRING) {
		tmp = *filename;
		zval_copy_ctor(&tmp);
		convert_to_string(&tmp);
		filename = &tmp;
	}
	file_handle.filename = Z_STRVAL_P(filename);
	file_handle.free_filename = 0;
	file_handle.type = ZEND_HANDLE_FILENAME;
	file_handle.opened_path = NULL;
	file_handle.handle.fp = NULL;

	retval = zend_compile_file(&file_handle, type);
	if (retval && file_handle.handle.stream.handle) {
		if (!file_handle.opened_path) {
			file_handle.opened_path = opened_path = zend_string_copy(Z_STR_P(filename));
		}

		zend_hash_add_empty_element(&EG(included_files), file_handle.opened_path);

		if (opened_path) {
			zend_string_release(opened_path);
		}
	}
	zend_destroy_file_handle(&file_handle);

	if (filename==&tmp) {
		zval_dtor(&tmp);
	}
	return retval;
}

ZEND_API int zend_prepare_string_for_scanning(zval *str, char *filename)
{
	char *buf;
	size_t size, old_len;
	zend_string *new_compiled_filename;

	/* enforce ZEND_MMAP_AHEAD trailing NULLs for flex... */
	old_len = Z_STRLEN_P(str);
	Z_STR_P(str) = zend_string_extend(Z_STR_P(str), old_len + ZEND_MMAP_AHEAD, 0);
	Z_TYPE_INFO_P(str) = IS_STRING_EX;
	memset(Z_STRVAL_P(str) + old_len, 0, ZEND_MMAP_AHEAD + 1);

	SCNG(yy_in) = NULL;
	SCNG(yy_start) = NULL;

	buf = Z_STRVAL_P(str);
	size = old_len;

	if (CG(multibyte)) {
		SCNG(script_org) = (unsigned char*)buf;
		SCNG(script_org_size) = size;
		SCNG(script_filtered) = NULL;

		zend_multibyte_set_filter(zend_multibyte_get_internal_encoding());

		if (SCNG(input_filter)) {
			if ((size_t)-1 == SCNG(input_filter)(&SCNG(script_filtered), &SCNG(script_filtered_size), SCNG(script_org), SCNG(script_org_size))) {
				zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
						"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
			}
			buf = (char*)SCNG(script_filtered);
			size = SCNG(script_filtered_size);
		}
	}

	yy_scan_buffer(buf, (unsigned int)size);

	new_compiled_filename = zend_string_init(filename, strlen(filename), 0);
	zend_set_compiled_filename(new_compiled_filename);
	zend_string_release(new_compiled_filename);
	CG(zend_lineno) = 1;
	CG(increment_lineno) = 0;
	RESET_DOC_COMMENT();
	return SUCCESS;
}


ZEND_API size_t zend_get_scanned_file_offset(void)
{
	size_t offset = SCNG(yy_cursor) - SCNG(yy_start);
	if (SCNG(input_filter)) {
		size_t original_offset = offset, length = 0;
		do {
			unsigned char *p = NULL;
			if ((size_t)-1 == SCNG(input_filter)(&p, &length, SCNG(script_org), offset)) {
				return (size_t)-1;
			}
			efree(p);
			if (length > original_offset) {
				offset--;
			} else if (length < original_offset) {
				offset++;
			}
		} while (original_offset != length);
	}
	return offset;
}


zend_op_array *compile_string(zval *source_string, char *filename)
{
	zend_lex_state original_lex_state;
	zend_op_array *op_array = NULL;
	zval tmp;
	zend_bool original_in_compilation = CG(in_compilation);

	if (Z_STRLEN_P(source_string)==0) {
		return NULL;
	}

	ZVAL_DUP(&tmp, source_string);
	convert_to_string(&tmp);
	source_string = &tmp;

	CG(in_compilation) = 1;
	zend_save_lexical_state(&original_lex_state);
	if (zend_prepare_string_for_scanning(source_string, filename) == SUCCESS) {
		CG(ast) = NULL;
		CG(ast_arena) = zend_arena_create(1024 * 32);
		BEGIN(ST_IN_SCRIPTING);

		if (!zendparse()) {
			zend_file_context original_file_context;
			zend_oparray_context original_oparray_context;
			zend_op_array *original_active_op_array = CG(active_op_array);
			op_array = emalloc(sizeof(zend_op_array));
			init_op_array(op_array, ZEND_EVAL_CODE, INITIAL_OP_ARRAY_SIZE);
			CG(active_op_array) = op_array;

			if (zend_ast_process) {
				zend_ast_process(CG(ast));
			}

			zend_file_context_begin(&original_file_context);
			zend_oparray_context_begin(&original_oparray_context);
			zend_compile_top_stmt(CG(ast));
			zend_emit_final_return(NULL);
			op_array->line_start = 1;
			op_array->line_end = CG(zend_lineno);
			pass_two(op_array);
			zend_oparray_context_end(&original_oparray_context);
			zend_file_context_end(&original_file_context);

			CG(active_op_array) = original_active_op_array;
		}

		zend_ast_destroy(CG(ast));
		zend_arena_destroy(CG(ast_arena));
	}

	zend_restore_lexical_state(&original_lex_state);
	zval_dtor(&tmp);
	CG(in_compilation) = original_in_compilation;
	return op_array;
}


BEGIN_EXTERN_C()
int highlight_file(char *filename, zend_syntax_highlighter_ini *syntax_highlighter_ini)
{
	zend_lex_state original_lex_state;
	zend_file_handle file_handle;

	file_handle.type = ZEND_HANDLE_FILENAME;
	file_handle.filename = filename;
	file_handle.free_filename = 0;
	file_handle.opened_path = NULL;
	zend_save_lexical_state(&original_lex_state);
	if (open_file_for_scanning(&file_handle)==FAILURE) {
		zend_message_dispatcher(ZMSG_FAILED_HIGHLIGHT_FOPEN, filename);
		zend_restore_lexical_state(&original_lex_state);
		return FAILURE;
	}
	zend_highlight(syntax_highlighter_ini);
	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	zend_destroy_file_handle(&file_handle);
	zend_restore_lexical_state(&original_lex_state);
	return SUCCESS;
}

int highlight_string(zval *str, zend_syntax_highlighter_ini *syntax_highlighter_ini, char *str_name)
{
	zend_lex_state original_lex_state;
	zval tmp = *str;

	str = &tmp;
	zval_copy_ctor(str);
	zend_save_lexical_state(&original_lex_state);
	if (zend_prepare_string_for_scanning(str, str_name)==FAILURE) {
		zend_restore_lexical_state(&original_lex_state);
		return FAILURE;
	}
	BEGIN(INITIAL);
	zend_highlight(syntax_highlighter_ini);
	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	zend_restore_lexical_state(&original_lex_state);
	zval_dtor(str);
	return SUCCESS;
}

ZEND_API void zend_multibyte_yyinput_again(zend_encoding_filter old_input_filter, const zend_encoding *old_encoding)
{
	size_t length;
	unsigned char *new_yy_start;

	/* convert and set */
	if (!SCNG(input_filter)) {
		if (SCNG(script_filtered)) {
			efree(SCNG(script_filtered));
			SCNG(script_filtered) = NULL;
		}
		SCNG(script_filtered_size) = 0;
		length = SCNG(script_org_size);
		new_yy_start = SCNG(script_org);
	} else {
		if ((size_t)-1 == SCNG(input_filter)(&new_yy_start, &length, SCNG(script_org), SCNG(script_org_size))) {
			zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
					"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
		}
		if (SCNG(script_filtered)) {
			efree(SCNG(script_filtered));
		}
		SCNG(script_filtered) = new_yy_start;
		SCNG(script_filtered_size) = length;
	}

	SCNG(yy_cursor) = new_yy_start + (SCNG(yy_cursor) - SCNG(yy_start));
	SCNG(yy_marker) = new_yy_start + (SCNG(yy_marker) - SCNG(yy_start));
	SCNG(yy_text) = new_yy_start + (SCNG(yy_text) - SCNG(yy_start));
	SCNG(yy_limit) = new_yy_start + length;

	SCNG(yy_start) = new_yy_start;
}


// TODO: avoid reallocation ???
# define zend_copy_value(zendlval, yytext, yyleng) \
	if (SCNG(output_filter)) { \
		size_t sz = 0; \
		char *s = NULL; \
		SCNG(output_filter)((unsigned char **)&s, &sz, (unsigned char *)yytext, (size_t)yyleng); \
		ZVAL_STRINGL(zendlval, s, sz); \
		efree(s); \
	} else { \
		ZVAL_STRINGL(zendlval, yytext, yyleng); \
	}

static int zend_scan_escape_string(zval *zendlval, char *str, int len, char quote_type)
{
	register char *s, *t;
	char *end;

	ZVAL_STRINGL(zendlval, str, len);

	/* convert escape sequences */
	s = t = Z_STRVAL_P(zendlval);
	end = s+Z_STRLEN_P(zendlval);
	while (s<end) {
		if (*s=='\\') {
			s++;
			if (s >= end) {
				*t++ = '\\';
				break;
			}

			switch(*s) {
				case 'n':
					*t++ = '\n';
					Z_STRLEN_P(zendlval)--;
					break;
				case 'r':
					*t++ = '\r';
					Z_STRLEN_P(zendlval)--;
					break;
				case 't':
					*t++ = '\t';
					Z_STRLEN_P(zendlval)--;
					break;
				case 'f':
					*t++ = '\f';
					Z_STRLEN_P(zendlval)--;
					break;
				case 'v':
					*t++ = '\v';
					Z_STRLEN_P(zendlval)--;
					break;
				case 'e':
#ifdef ZEND_WIN32
					*t++ = VK_ESCAPE;
#else
					*t++ = '\e';
#endif
					Z_STRLEN_P(zendlval)--;
					break;
				case '"':
				case '`':
					if (*s != quote_type) {
						*t++ = '\\';
						*t++ = *s;
						break;
					}
				case '\\':
				case '$':
					*t++ = *s;
					Z_STRLEN_P(zendlval)--;
					break;
				case 'x':
				case 'X':
					if (ZEND_IS_HEX(*(s+1))) {
						char hex_buf[3] = { 0, 0, 0 };

						Z_STRLEN_P(zendlval)--; /* for the 'x' */

						hex_buf[0] = *(++s);
						Z_STRLEN_P(zendlval)--;
						if (ZEND_IS_HEX(*(s+1))) {
							hex_buf[1] = *(++s);
							Z_STRLEN_P(zendlval)--;
						}
						*t++ = (char) ZEND_STRTOL(hex_buf, NULL, 16);
					} else {
						*t++ = '\\';
						*t++ = *s;
					}
					break;
				/* UTF-8 codepoint escape, format: /\\u\{\x+\}/ */
				case 'u':
					{
						/* cache where we started so we can parse after validating */
						char *start = s + 1;
						size_t len = 0;
						zend_bool valid = 1;
						unsigned long codepoint;
						size_t byte_len = 0;

						if (*start != '{') {
							/* we silently let this pass to avoid breaking code
							 * with JSON in string literals (e.g. "\"\u202e\""
							 */
							*t++ = '\\';
							*t++ = 'u';
							break;
						} else {
							/* on the other hand, invalid \u{blah} errors */
							s++;
							len++;
							s++;
							while (*s != '}') {
								if (!ZEND_IS_HEX(*s)) {
									valid = 0;
									break;
								} else {
									len++;
								}
								s++;
							}
							if (*s == '}') {
								valid = 1;
								len++;
							}
						}

						/* \u{} is invalid */
						if (len <= 2) {
							valid = 0;
						}

						if (!valid) {
							zend_throw_exception(zend_ce_parse_error,
								"Invalid UTF-8 codepoint escape sequence", 0);
							zval_ptr_dtor(zendlval);
							ZVAL_UNDEF(zendlval);
							return FAILURE;
						}

						errno = 0;
						codepoint = strtoul(start + 1, NULL, 16);

						/* per RFC 3629, UTF-8 can only represent 21 bits */
						if (codepoint > 0x10FFFF || errno) {
							zend_throw_exception(zend_ce_parse_error,
								"Invalid UTF-8 codepoint escape sequence: Codepoint too large", 0);
							zval_ptr_dtor(zendlval);
							ZVAL_UNDEF(zendlval);
							return FAILURE;
						}

						/* based on https://en.wikipedia.org/wiki/UTF-8#Sample_code */
						if (codepoint < 0x80) {
							byte_len = 1;
							*t++ = codepoint;
						} else if (codepoint <= 0x7FF) {
							byte_len = 2;
							*t++ = (codepoint >> 6) + 0xC0;
							*t++ = (codepoint & 0x3F) + 0x80;
						} else if (codepoint <= 0xFFFF) {
							byte_len = 3;
							*t++ = (codepoint >> 12) + 0xE0;
							*t++ = ((codepoint >> 6) & 0x3F) + 0x80;
							*t++ = (codepoint & 0x3F) + 0x80;
						} else if (codepoint <= 0x10FFFF) {
							byte_len = 4;
							*t++ = (codepoint >> 18) + 0xF0;
							*t++ = ((codepoint >> 12) & 0x3F) + 0x80;
							*t++ = ((codepoint >> 6) & 0x3F) + 0x80;
							*t++ = (codepoint & 0x3F) + 0x80;
						}

						Z_STRLEN_P(zendlval) -= 2; /* \u */
						Z_STRLEN_P(zendlval) -= (len - byte_len);
					}
					break;
				default:
					/* check for an octal */
					if (ZEND_IS_OCT(*s)) {
						char octal_buf[4] = { 0, 0, 0, 0 };

						octal_buf[0] = *s;
						Z_STRLEN_P(zendlval)--;
						if (ZEND_IS_OCT(*(s+1))) {
							octal_buf[1] = *(++s);
							Z_STRLEN_P(zendlval)--;
							if (ZEND_IS_OCT(*(s+1))) {
								octal_buf[2] = *(++s);
								Z_STRLEN_P(zendlval)--;
							}
						}
						*t++ = (char) ZEND_STRTOL(octal_buf, NULL, 8);
					} else {
						*t++ = '\\';
						*t++ = *s;
					}
					break;
			}
		} else {
			*t++ = *s;
		}

		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
	}
	*t = 0;
	if (SCNG(output_filter)) {
		size_t sz = 0;
		unsigned char *str;
		// TODO: avoid realocation ???
		s = Z_STRVAL_P(zendlval);
		SCNG(output_filter)(&str, &sz, (unsigned char *)s, (size_t)Z_STRLEN_P(zendlval));
		zval_ptr_dtor(zendlval);
		ZVAL_STRINGL(zendlval, (char *) str, sz);
		efree(str);
	}
	return SUCCESS;
}

static zend_always_inline int emit_token(int token, int token_line)
{
	if(SCNG(on_event)) SCNG(on_event)(ON_TOKEN, token, token_line);

	return token;
}

#define RETURN_TOKEN(token) return emit_token(token, start_line);

int lex_scan(zval *zendlval)
{

int start_line = CG(zend_lineno);

restart:
	SCNG(yy_text) = YYCURSOR;


#line 1121 "Zend/zend_language_scanner.c"
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	if (YYGETCONDITION() < 5) {
		if (YYGETCONDITION() < 2) {
			if (YYGETCONDITION() < 1) {
				goto yyc_ST_IN_SCRIPTING;
			} else {
				goto yyc_ST_LOOKING_FOR_PROPERTY;
			}
		} else {
			if (YYGETCONDITION() < 3) {
				goto yyc_ST_BACKQUOTE;
			} else {
				if (YYGETCONDITION() < 4) {
					goto yyc_ST_DOUBLE_QUOTES;
				} else {
					goto yyc_ST_HEREDOC;
				}
			}
		}
	} else {
		if (YYGETCONDITION() < 7) {
			if (YYGETCONDITION() < 6) {
				goto yyc_ST_LOOKING_FOR_VARNAME;
			} else {
				goto yyc_ST_VAR_OFFSET;
			}
		} else {
			if (YYGETCONDITION() < 8) {
				goto yyc_INITIAL;
			} else {
				if (YYGETCONDITION() < 9) {
					goto yyc_ST_END_HEREDOC;
				} else {
					goto yyc_ST_NOWDOC;
				}
			}
		}
	}
/* *********************************** */
yyc_INITIAL:

	YYDEBUG(0, *YYCURSOR);
	YYFILL(7);
	yych = *YYCURSOR;
	if (yych != '<') goto yy4;
	YYDEBUG(2, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) == '?') goto yy5;
yy3:
	YYDEBUG(3, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
#line 1812 "Zend/zend_language_scanner.l"
	{
	if (YYCURSOR > YYLIMIT) {
		RETURN_TOKEN(END);
	}

inline_char_handler:

	while (1) {
		YYCTYPE *ptr = memchr(YYCURSOR, '<', YYLIMIT - YYCURSOR);

		YYCURSOR = ptr ? ptr + 1 : YYLIMIT;

		if (YYCURSOR >= YYLIMIT) {
			break;
		}

		if (*YYCURSOR == '?') {
			if (CG(short_tags) || !strncasecmp((char*)YYCURSOR + 1, "php", 3) || (*(YYCURSOR + 1) == '=')) { /* Assume [ \t\n\r] follows "php" */

				YYCURSOR--;
				break;
			}
		}
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	if (SCNG(output_filter)) {
		size_t readsize;
		char *s = NULL;
		size_t sz = 0;
		// TODO: avoid reallocation ???
		readsize = SCNG(output_filter)((unsigned char **)&s, &sz, (unsigned char *)yytext, (size_t)yyleng);
		ZVAL_STRINGL(zendlval, s, sz);
		efree(s);
		if (readsize < yyleng) {
			yyless(readsize);
		}
	} else {
	  ZVAL_STRINGL(zendlval, yytext, yyleng);
	}
	HANDLE_NEWLINES(yytext, yyleng);
	RETURN_TOKEN(T_INLINE_HTML);
}
#line 1220 "Zend/zend_language_scanner.c"
yy4:
	YYDEBUG(4, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy3;
yy5:
	YYDEBUG(5, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych == '=') goto yy7;
	} else {
		if (yych <= 'P') goto yy9;
		if (yych == 'p') goto yy9;
	}
yy6:
	YYDEBUG(6, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
#line 1803 "Zend/zend_language_scanner.l"
	{
	if (CG(short_tags)) {
		BEGIN(ST_IN_SCRIPTING);
		RETURN_TOKEN(T_OPEN_TAG);
	} else {
		goto inline_char_handler;
	}
}
#line 1247 "Zend/zend_language_scanner.c"
yy7:
	YYDEBUG(7, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(8, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
#line 1790 "Zend/zend_language_scanner.l"
	{
	BEGIN(ST_IN_SCRIPTING);
	RETURN_TOKEN(T_OPEN_TAG_WITH_ECHO);
}
#line 1258 "Zend/zend_language_scanner.c"
yy9:
	YYDEBUG(9, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy11;
	if (yych == 'h') goto yy11;
yy10:
	YYDEBUG(10, *YYCURSOR);
	YYCURSOR = YYMARKER;
	goto yy6;
yy11:
	YYDEBUG(11, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy12;
	if (yych != 'p') goto yy10;
yy12:
	YYDEBUG(12, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\f') {
		if (yych <= 0x08) goto yy10;
		if (yych >= '\v') goto yy10;
	} else {
		if (yych <= '\r') goto yy15;
		if (yych != ' ') goto yy10;
	}
yy13:
	YYDEBUG(13, *YYCURSOR);
	++YYCURSOR;
yy14:
	YYDEBUG(14, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
#line 1796 "Zend/zend_language_scanner.l"
	{
	HANDLE_NEWLINE(yytext[yyleng-1]);
	BEGIN(ST_IN_SCRIPTING);
	RETURN_TOKEN(T_OPEN_TAG);
}
#line 1295 "Zend/zend_language_scanner.c"
yy15:
	YYDEBUG(15, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) == '\n') goto yy13;
	goto yy14;
/* *********************************** */
yyc_ST_BACKQUOTE:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(16, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych != '$') goto yy23;
		} else {
			if (yych <= '`') goto yy21;
			if (yych == '{') goto yy20;
			goto yy23;
		}
		YYDEBUG(18, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '_') {
			if (yych <= '@') goto yy19;
			if (yych <= 'Z') goto yy26;
			if (yych >= '_') goto yy26;
		} else {
			if (yych <= 'z') {
				if (yych >= 'a') goto yy26;
			} else {
				if (yych <= '{') goto yy29;
				if (yych >= 0x7F) goto yy26;
			}
		}
yy19:
		YYDEBUG(19, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2222 "Zend/zend_language_scanner.l"
		{
	if (YYCURSOR > YYLIMIT) {
		RETURN_TOKEN(END);
	}
	if (yytext[0] == '\\' && YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '`':
				break;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	zend_scan_escape_string(zendlval, yytext, yyleng, '`');
	RETURN_TOKEN(T_ENCAPSED_AND_WHITESPACE);
}
#line 1406 "Zend/zend_language_scanner.c"
yy20:
		YYDEBUG(20, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy24;
		goto yy19;
yy21:
		YYDEBUG(21, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(22, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2166 "Zend/zend_language_scanner.l"
		{
	BEGIN(ST_IN_SCRIPTING);
	RETURN_TOKEN('`');
}
#line 1422 "Zend/zend_language_scanner.c"
yy23:
		YYDEBUG(23, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy19;
yy24:
		YYDEBUG(24, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(25, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2153 "Zend/zend_language_scanner.l"
		{
	Z_LVAL_P(zendlval) = (zend_long) '{';
	yy_push_state(ST_IN_SCRIPTING);
	yyless(1);
	RETURN_TOKEN(T_CURLY_OPEN);
}
#line 1439 "Zend/zend_language_scanner.c"
yy26:
		YYDEBUG(26, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(27, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy26;
		}
		if (yych == '-') goto yy31;
		if (yych == '[') goto yy33;
yy28:
		YYDEBUG(28, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1877 "Zend/zend_language_scanner.l"
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	RETURN_TOKEN(T_VARIABLE);
}
#line 1460 "Zend/zend_language_scanner.c"
yy29:
		YYDEBUG(29, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(30, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1595 "Zend/zend_language_scanner.l"
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME);
	RETURN_TOKEN(T_DOLLAR_OPEN_CURLY_BRACES);
}
#line 1471 "Zend/zend_language_scanner.c"
yy31:
		YYDEBUG(31, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy35;
yy32:
		YYDEBUG(32, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy28;
yy33:
		YYDEBUG(33, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(34, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1870 "Zend/zend_language_scanner.l"
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	RETURN_TOKEN(T_VARIABLE);
}
#line 1492 "Zend/zend_language_scanner.c"
yy35:
		YYDEBUG(35, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy32;
			if (yych <= 'Z') goto yy36;
			if (yych <= '^') goto yy32;
		} else {
			if (yych <= '`') goto yy32;
			if (yych <= 'z') goto yy36;
			if (yych <= '~') goto yy32;
		}
yy36:
		YYDEBUG(36, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(37, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1861 "Zend/zend_language_scanner.l"
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	RETURN_TOKEN(T_VARIABLE);
}
#line 1517 "Zend/zend_language_scanner.c"
	}
/* *********************************** */
yyc_ST_DOUBLE_QUOTES:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(38, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '#') {
			if (yych == '"') goto yy43;
			goto yy45;
		} else {
			if (yych <= '$') goto yy40;
			if (yych == '{') goto yy42;
			goto yy45;
		}
yy40:
		YYDEBUG(40, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '_') {
			if (yych <= '@') goto yy41;
			if (yych <= 'Z') goto yy48;
			if (yych >= '_') goto yy48;
		} else {
			if (yych <= 'z') {
				if (yych >= 'a') goto yy48;
			} else {
				if (yych <= '{') goto yy51;
				if (yych >= 0x7F) goto yy48;
			}
		}
yy41:
		YYDEBUG(41, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2172 "Zend/zend_language_scanner.l"
		{
	if (GET_DOUBLE_QUOTES_SCANNED_LENGTH()) {
		YYCURSOR += GET_DOUBLE_QUOTES_SCANNED_LENGTH() - 1;
		SET_DOUBLE_QUOTES_SCANNED_LENGTH(0);

		goto double_quotes_scan_done;
	}

	if (YYCURSOR > YYLIMIT) {
		RETURN_TOKEN(END);
	}
	if (yytext[0] == '\\' && YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				break;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

double_quotes_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	zend_scan_escape_string(zendlval, yytext, yyleng, '"');
	RETURN_TOKEN(T_ENCAPSED_AND_WHITESPACE);
}
#line 1634 "Zend/zend_language_scanner.c"
yy42:
		YYDEBUG(42, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy46;
		goto yy41;
yy43:
		YYDEBUG(43, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(44, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2161 "Zend/zend_language_scanner.l"
		{
	BEGIN(ST_IN_SCRIPTING);
	RETURN_TOKEN('"');
}
#line 1650 "Zend/zend_language_scanner.c"
yy45:
		YYDEBUG(45, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy41;
yy46:
		YYDEBUG(46, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(47, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2153 "Zend/zend_language_scanner.l"
		{
	Z_LVAL_P(zendlval) = (zend_long) '{';
	yy_push_state(ST_IN_SCRIPTING);
	yyless(1);
	RETURN_TOKEN(T_CURLY_OPEN);
}
#line 1667 "Zend/zend_language_scanner.c"
yy48:
		YYDEBUG(48, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(49, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy48;
		}
		if (yych == '-') goto yy53;
		if (yych == '[') goto yy55;
yy50:
		YYDEBUG(50, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1877 "Zend/zend_language_scanner.l"
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	RETURN_TOKEN(T_VARIABLE);
}
#line 1688 "Zend/zend_language_scanner.c"
yy51:
		YYDEBUG(51, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(52, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1595 "Zend/zend_language_scanner.l"
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME);
	RETURN_TOKEN(T_DOLLAR_OPEN_CURLY_BRACES);
}
#line 1699 "Zend/zend_language_scanner.c"
yy53:
		YYDEBUG(53, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy57;
yy54:
		YYDEBUG(54, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy50;
yy55:
		YYDEBUG(55, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(56, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1870 "Zend/zend_language_scanner.l"
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	RETURN_TOKEN(T_VARIABLE);
}
#line 1720 "Zend/zend_language_scanner.c"
yy57:
		YYDEBUG(57, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy54;
			if (yych <= 'Z') goto yy58;
			if (yych <= '^') goto yy54;
		} else {
			if (yych <= '`') goto yy54;
			if (yych <= 'z') goto yy58;
			if (yych <= '~') goto yy54;
		}
yy58:
		YYDEBUG(58, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(59, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1861 "Zend/zend_language_scanner.l"
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	RETURN_TOKEN(T_VARIABLE);
}
#line 1745 "Zend/zend_language_scanner.c"
	}
/* *********************************** */
yyc_ST_END_HEREDOC:
	YYDEBUG(60, *YYCURSOR);
	YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(62, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(63, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
#line 2139 "Zend/zend_language_scanner.l"
	{
	zend_heredoc_label *heredoc_label = zend_ptr_stack_pop(&SCNG(heredoc_label_stack));

	YYCURSOR += heredoc_label->length - 1;
	yyleng = heredoc_label->length;

	heredoc_label_dtor(heredoc_label);
	efree(heredoc_label);

	BEGIN(ST_IN_SCRIPTING);
	RETURN_TOKEN(T_END_HEREDOC);
}
#line 1769 "Zend/zend_language_scanner.c"
/* *********************************** */
yyc_ST_HEREDOC:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(64, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych == '$') goto yy66;
		if (yych == '{') goto yy68;
		goto yy69;
yy66:
		YYDEBUG(66, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '_') {
			if (yych <= '@') goto yy67;
			if (yych <= 'Z') goto yy72;
			if (yych >= '_') goto yy72;
		} else {
			if (yych <= 'z') {
				if (yych >= 'a') goto yy72;
			} else {
				if (yych <= '{') goto yy75;
				if (yych >= 0x7F) goto yy72;
			}
		}
yy67:
		YYDEBUG(67, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2264 "Zend/zend_language_scanner.l"
		{
	int newline = 0;

	zend_heredoc_label *heredoc_label = zend_ptr_stack_top(&SCNG(heredoc_label_stack));

	if (YYCURSOR > YYLIMIT) {
		RETURN_TOKEN(END);
	}

	YYCURSOR--;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				/* Check for ending label on the next line */
				if (IS_LABEL_START(*YYCURSOR) && heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, heredoc_label->label, heredoc_label->length)) {
					YYCTYPE *end = YYCURSOR + heredoc_label->length;

					if (*end == ';') {
						end++;
					}

					if (*end == '\n' || *end == '\r') {
						/* newline before label will be subtracted from returned text, but
						 * yyleng/yytext will include it, for zend_highlight/strip, tokenizer, etc. */
						if (YYCURSOR[-2] == '\r' && YYCURSOR[-1] == '\n') {
							newline = 2; /* Windows newline */
						} else {
							newline = 1;
						}

						CG(increment_lineno) = 1; /* For newline before label */
						BEGIN(ST_END_HEREDOC);

						goto heredoc_scan_done;
					}
				}
				continue;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT && *YYCURSOR != '\n' && *YYCURSOR != '\r') {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

heredoc_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	zend_scan_escape_string(zendlval, yytext, yyleng - newline, 0);
	RETURN_TOKEN(T_ENCAPSED_AND_WHITESPACE);
}
#line 1904 "Zend/zend_language_scanner.c"
yy68:
		YYDEBUG(68, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy70;
		goto yy67;
yy69:
		YYDEBUG(69, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy67;
yy70:
		YYDEBUG(70, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(71, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2153 "Zend/zend_language_scanner.l"
		{
	Z_LVAL_P(zendlval) = (zend_long) '{';
	yy_push_state(ST_IN_SCRIPTING);
	yyless(1);
	RETURN_TOKEN(T_CURLY_OPEN);
}
#line 1926 "Zend/zend_language_scanner.c"
yy72:
		YYDEBUG(72, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(73, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy72;
		}
		if (yych == '-') goto yy77;
		if (yych == '[') goto yy79;
yy74:
		YYDEBUG(74, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1877 "Zend/zend_language_scanner.l"
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	RETURN_TOKEN(T_VARIABLE);
}
#line 1947 "Zend/zend_language_scanner.c"
yy75:
		YYDEBUG(75, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(76, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1595 "Zend/zend_language_scanner.l"
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME);
	RETURN_TOKEN(T_DOLLAR_OPEN_CURLY_BRACES);
}
#line 1958 "Zend/zend_language_scanner.c"
yy77:
		YYDEBUG(77, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy81;
yy78:
		YYDEBUG(78, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy74;
yy79:
		YYDEBUG(79, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(80, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1870 "Zend/zend_language_scanner.l"
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	RETURN_TOKEN(T_VARIABLE);
}
#line 1979 "Zend/zend_language_scanner.c"
yy81:
		YYDEBUG(81, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy78;
			if (yych <= 'Z') goto yy82;
			if (yych <= '^') goto yy78;
		} else {
			if (yych <= '`') goto yy78;
			if (yych <= 'z') goto yy82;
			if (yych <= '~') goto yy78;
		}
yy82:
		YYDEBUG(82, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(83, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1861 "Zend/zend_language_scanner.l"
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	RETURN_TOKEN(T_VARIABLE);
}
#line 2004 "Zend/zend_language_scanner.c"
	}
/* *********************************** */
yyc_ST_IN_SCRIPTING:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0, 192,  64,   0,   0,  64,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			192,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 60,  60,  44,  44,  44,  44,  44,  44, 
			 44,  44,   0,   0,   0,   0,   0,   0, 
			  0,  36,  36,  36,  36,  36,  36,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   0,   0,   0,   0,   4, 
			  0,  36,  36,  36,  36,  36,  36,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   0,   0,   0,   0,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
		};
		YYDEBUG(84, *YYCURSOR);
		YYFILL(16);
		yych = *YYCURSOR;
		YYDEBUG(-1, yych);
		switch (yych) {
		case 0x00:
		case 0x01:
		case 0x02:
		case 0x03:
		case 0x04:
		case 0x05:
		case 0x06:
		case 0x07:
		case 0x08:
		case '\v':
		case '\f':
		case 0x0E:
		case 0x0F:
		case 0x10:
		case 0x11:
		case 0x12:
		case 0x13:
		case 0x14:
		case 0x15:
		case 0x16:
		case 0x17:
		case 0x18:
		case 0x19:
		case 0x1A:
		case 0x1B:
		case 0x1C:
		case 0x1D:
		case 0x1E:
		case 0x1F:	goto yy147;
		case '\t':
		case '\n':
		case '\r':
		case ' ':	goto yy103;
		case '!':	goto yy118;
		case '"':	goto yy143;
		case '#':	goto yy139;
		case '$':	goto yy129;
		case '%':	goto yy123;
		case '&':	goto yy124;
		case '\'':	goto yy141;
		case '(':	goto yy112;
		case ')':
		case ',':
		case ';':
		case '@':
		case '[':
		case ']':
		case '~':	goto yy130;
		case '*':	goto yy121;
		case '+':	goto yy117;
		case '-':	goto yy101;
		case '.':	goto yy108;
		case '/':	goto yy122;
		case '0':	goto yy135;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':	goto yy137;
		case ':':	goto yy105;
		case '<':	goto yy119;
		case '=':	goto yy115;
		case '>':	goto yy120;
		case '?':	goto yy109;
		case 'A':
		case 'a':	goto yy96;
		case 'B':
		case 'b':	goto yy98;
		case 'C':
		case 'c':	goto yy90;
		case 'D':
		case 'd':	goto yy88;
		case 'E':
		case 'e':	goto yy86;
		case 'F':
		case 'f':	goto yy89;
		case 'G':
		case 'g':	goto yy99;
		case 'I':
		case 'i':	goto yy94;
		case 'L':
		case 'l':	goto yy116;
		case 'N':
		case 'n':	goto yy110;
		case 'O':
		case 'o':	goto yy127;
		case 'P':
		case 'p':	goto yy100;
		case 'R':
		case 'r':	goto yy91;
		case 'S':
		case 's':	goto yy97;
		case 'T':
		case 't':	goto yy93;
		case 'U':
		case 'u':	goto yy113;
		case 'V':
		case 'v':	goto yy111;
		case 'W':
		case 'w':	goto yy95;
		case 'X':
		case 'x':	goto yy128;
		case 'Y':
		case 'y':	goto yy92;
		case '\\':	goto yy106;
		case '^':	goto yy126;
		case '_':	goto yy114;
		case '`':	goto yy145;
		case '{':	goto yy131;
		case '|':	goto yy125;
		case '}':	goto yy133;
		default:	goto yy138;
		}
yy86:
		YYDEBUG(86, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(-1, yych);
		switch ((yych = *YYCURSOR)) {
		case 'C':
		case 'c':	goto yy704;
		case 'L':
		case 'l':	goto yy705;
		case 'M':
		case 'm':	goto yy706;
		case 'N':
		case 'n':	goto yy707;
		case 'V':
		case 'v':	goto yy708;
		case 'X':
		case 'x':	goto yy709;
		default:	goto yy150;
		}
yy87:
		YYDEBUG(87, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1900 "Zend/zend_language_scanner.l"
		{
	zend_copy_value(zendlval, yytext, yyleng);
	RETURN_TOKEN(T_STRING);
}
#line 2192 "Zend/zend_language_scanner.c"
yy88:
		YYDEBUG(88, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych <= 'H') {
				if (yych == 'E') goto yy686;
				goto yy150;
			} else {
				if (yych <= 'I') goto yy687;
				if (yych <= 'N') goto yy150;
				goto yy688;
			}
		} else {
			if (yych <= 'h') {
				if (yych == 'e') goto yy686;
				goto yy150;
			} else {
				if (yych <= 'i') goto yy687;
				if (yych == 'o') goto yy688;
				goto yy150;
			}
		}
yy89:
		YYDEBUG(89, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'U') {
			if (yych <= 'N') {
				if (yych == 'I') goto yy662;
				goto yy150;
			} else {
				if (yych <= 'O') goto yy663;
				if (yych <= 'T') goto yy150;
				goto yy664;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'i') goto yy662;
				goto yy150;
			} else {
				if (yych <= 'o') goto yy663;
				if (yych == 'u') goto yy664;
				goto yy150;
			}
		}
yy90:
		YYDEBUG(90, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych <= 'K') {
				if (yych == 'A') goto yy627;
				goto yy150;
			} else {
				if (yych <= 'L') goto yy628;
				if (yych <= 'N') goto yy150;
				goto yy629;
			}
		} else {
			if (yych <= 'k') {
				if (yych == 'a') goto yy627;
				goto yy150;
			} else {
				if (yych <= 'l') goto yy628;
				if (yych == 'o') goto yy629;
				goto yy150;
			}
		}
yy91:
		YYDEBUG(91, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy609;
		if (yych == 'e') goto yy609;
		goto yy150;
yy92:
		YYDEBUG(92, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy597;
		if (yych == 'i') goto yy597;
		goto yy150;
yy93:
		YYDEBUG(93, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'R') {
			if (yych == 'H') goto yy585;
			if (yych <= 'Q') goto yy150;
			goto yy586;
		} else {
			if (yych <= 'h') {
				if (yych <= 'g') goto yy150;
				goto yy585;
			} else {
				if (yych == 'r') goto yy586;
				goto yy150;
			}
		}
yy94:
		YYDEBUG(94, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'S') {
			if (yych <= 'L') {
				if (yych == 'F') goto yy532;
				goto yy150;
			} else {
				if (yych <= 'M') goto yy534;
				if (yych <= 'N') goto yy535;
				if (yych <= 'R') goto yy150;
				goto yy536;
			}
		} else {
			if (yych <= 'm') {
				if (yych == 'f') goto yy532;
				if (yych <= 'l') goto yy150;
				goto yy534;
			} else {
				if (yych <= 'n') goto yy535;
				if (yych == 's') goto yy536;
				goto yy150;
			}
		}
yy95:
		YYDEBUG(95, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy527;
		if (yych == 'h') goto yy527;
		goto yy150;
yy96:
		YYDEBUG(96, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'S') {
			if (yych <= 'M') {
				if (yych == 'B') goto yy509;
				goto yy150;
			} else {
				if (yych <= 'N') goto yy510;
				if (yych <= 'Q') goto yy150;
				if (yych <= 'R') goto yy511;
				goto yy512;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'b') goto yy509;
				if (yych <= 'm') goto yy150;
				goto yy510;
			} else {
				if (yych <= 'q') goto yy150;
				if (yych <= 'r') goto yy511;
				if (yych <= 's') goto yy512;
				goto yy150;
			}
		}
yy97:
		YYDEBUG(97, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'W') {
			if (yych == 'T') goto yy497;
			if (yych <= 'V') goto yy150;
			goto yy498;
		} else {
			if (yych <= 't') {
				if (yych <= 's') goto yy150;
				goto yy497;
			} else {
				if (yych == 'w') goto yy498;
				goto yy150;
			}
		}
yy98:
		YYDEBUG(98, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ';') {
			if (yych <= '"') {
				if (yych <= '!') goto yy150;
				goto yy489;
			} else {
				if (yych == '\'') goto yy490;
				goto yy150;
			}
		} else {
			if (yych <= 'R') {
				if (yych <= '<') goto yy488;
				if (yych <= 'Q') goto yy150;
				goto yy491;
			} else {
				if (yych == 'r') goto yy491;
				goto yy150;
			}
		}
yy99:
		YYDEBUG(99, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych == 'L') goto yy478;
			if (yych <= 'N') goto yy150;
			goto yy479;
		} else {
			if (yych <= 'l') {
				if (yych <= 'k') goto yy150;
				goto yy478;
			} else {
				if (yych == 'o') goto yy479;
				goto yy150;
			}
		}
yy100:
		YYDEBUG(100, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'U') {
			if (yych == 'R') goto yy454;
			if (yych <= 'T') goto yy150;
			goto yy455;
		} else {
			if (yych <= 'r') {
				if (yych <= 'q') goto yy150;
				goto yy454;
			} else {
				if (yych == 'u') goto yy455;
				goto yy150;
			}
		}
yy101:
		YYDEBUG(101, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '<') {
			if (yych == '-') goto yy450;
		} else {
			if (yych <= '=') goto yy448;
			if (yych <= '>') goto yy452;
		}
yy102:
		YYDEBUG(102, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1584 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(yytext[0]);
}
#line 2428 "Zend/zend_language_scanner.c"
yy103:
		YYDEBUG(103, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy447;
yy104:
		YYDEBUG(104, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1299 "Zend/zend_language_scanner.l"
		{
	HANDLE_NEWLINES(yytext, yyleng);
	RETURN_TOKEN(T_WHITESPACE);
}
#line 2442 "Zend/zend_language_scanner.c"
yy105:
		YYDEBUG(105, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == ':') goto yy444;
		goto yy102;
yy106:
		YYDEBUG(106, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(107, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1324 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_NS_SEPARATOR);
}
#line 2457 "Zend/zend_language_scanner.c"
yy108:
		YYDEBUG(108, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') {
			if (yych == '.') goto yy441;
			goto yy102;
		} else {
			if (yych <= '9') goto yy437;
			if (yych == '=') goto yy439;
			goto yy102;
		}
yy109:
		YYDEBUG(109, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '=') goto yy102;
		if (yych <= '>') goto yy431;
		if (yych <= '?') goto yy433;
		goto yy102;
yy110:
		YYDEBUG(110, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'E') {
			if (yych == 'A') goto yy419;
			if (yych <= 'D') goto yy150;
			goto yy420;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy150;
				goto yy419;
			} else {
				if (yych == 'e') goto yy420;
				goto yy150;
			}
		}
yy111:
		YYDEBUG(111, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy416;
		if (yych == 'a') goto yy416;
		goto yy150;
yy112:
		YYDEBUG(112, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'S') {
			if (yych <= 'D') {
				if (yych <= ' ') {
					if (yych == '\t') goto yy341;
					if (yych <= 0x1F) goto yy102;
					goto yy341;
				} else {
					if (yych <= '@') goto yy102;
					if (yych == 'C') goto yy102;
					goto yy341;
				}
			} else {
				if (yych <= 'I') {
					if (yych == 'F') goto yy341;
					if (yych <= 'H') goto yy102;
					goto yy341;
				} else {
					if (yych == 'O') goto yy341;
					if (yych <= 'Q') goto yy102;
					goto yy341;
				}
			}
		} else {
			if (yych <= 'f') {
				if (yych <= 'b') {
					if (yych == 'U') goto yy341;
					if (yych <= '`') goto yy102;
					goto yy341;
				} else {
					if (yych == 'd') goto yy341;
					if (yych <= 'e') goto yy102;
					goto yy341;
				}
			} else {
				if (yych <= 'o') {
					if (yych == 'i') goto yy341;
					if (yych <= 'n') goto yy102;
					goto yy341;
				} else {
					if (yych <= 's') {
						if (yych <= 'q') goto yy102;
						goto yy341;
					} else {
						if (yych == 'u') goto yy341;
						goto yy102;
					}
				}
			}
		}
yy113:
		YYDEBUG(113, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'S') {
			if (yych == 'N') goto yy332;
			if (yych <= 'R') goto yy150;
			goto yy333;
		} else {
			if (yych <= 'n') {
				if (yych <= 'm') goto yy150;
				goto yy332;
			} else {
				if (yych == 's') goto yy333;
				goto yy150;
			}
		}
yy114:
		YYDEBUG(114, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy250;
		goto yy150;
yy115:
		YYDEBUG(115, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy102;
		if (yych <= '=') goto yy244;
		if (yych <= '>') goto yy246;
		goto yy102;
yy116:
		YYDEBUG(116, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy240;
		if (yych == 'i') goto yy240;
		goto yy150;
yy117:
		YYDEBUG(117, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '+') goto yy238;
		if (yych == '=') goto yy236;
		goto yy102;
yy118:
		YYDEBUG(118, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy233;
		goto yy102;
yy119:
		YYDEBUG(119, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= ';') goto yy102;
		if (yych <= '<') goto yy209;
		if (yych <= '=') goto yy211;
		if (yych <= '>') goto yy213;
		goto yy102;
yy120:
		YYDEBUG(120, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy102;
		if (yych <= '=') goto yy205;
		if (yych <= '>') goto yy203;
		goto yy102;
yy121:
		YYDEBUG(121, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '*') goto yy197;
		if (yych == '=') goto yy199;
		goto yy102;
yy122:
		YYDEBUG(122, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '.') {
			if (yych == '*') goto yy189;
			goto yy102;
		} else {
			if (yych <= '/') goto yy191;
			if (yych == '=') goto yy192;
			goto yy102;
		}
yy123:
		YYDEBUG(123, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy187;
		goto yy102;
yy124:
		YYDEBUG(124, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '&') goto yy183;
		if (yych == '=') goto yy185;
		goto yy102;
yy125:
		YYDEBUG(125, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy181;
		if (yych == '|') goto yy179;
		goto yy102;
yy126:
		YYDEBUG(126, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy177;
		goto yy102;
yy127:
		YYDEBUG(127, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy175;
		if (yych == 'r') goto yy175;
		goto yy150;
yy128:
		YYDEBUG(128, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy172;
		if (yych == 'o') goto yy172;
		goto yy150;
yy129:
		YYDEBUG(129, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy102;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy102;
			goto yy169;
		} else {
			if (yych <= '`') goto yy102;
			if (yych <= 'z') goto yy169;
			if (yych <= '~') goto yy102;
			goto yy169;
		}
yy130:
		YYDEBUG(130, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy102;
yy131:
		YYDEBUG(131, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(132, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1589 "Zend/zend_language_scanner.l"
		{
	yy_push_state(ST_IN_SCRIPTING);
	RETURN_TOKEN('{');
}
#line 2691 "Zend/zend_language_scanner.c"
yy133:
		YYDEBUG(133, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(134, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1601 "Zend/zend_language_scanner.l"
		{
	RESET_DOC_COMMENT();
	if (!zend_stack_is_empty(&SCNG(state_stack))) {
		yy_pop_state();
	}
	RETURN_TOKEN('}');
}
#line 2705 "Zend/zend_language_scanner.c"
yy135:
		YYDEBUG(135, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'E') {
			if (yych <= '9') {
				if (yych == '.') goto yy151;
				if (yych >= '0') goto yy154;
			} else {
				if (yych == 'B') goto yy162;
				if (yych >= 'E') goto yy156;
			}
		} else {
			if (yych <= 'b') {
				if (yych == 'X') goto yy161;
				if (yych >= 'b') goto yy162;
			} else {
				if (yych <= 'e') {
					if (yych >= 'e') goto yy156;
				} else {
					if (yych == 'x') goto yy161;
				}
			}
		}
yy136:
		YYDEBUG(136, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1654 "Zend/zend_language_scanner.l"
		{
	char *end;
	if (yyleng < MAX_LENGTH_OF_LONG - 1) { /* Won't overflow */
		errno = 0;
		ZVAL_LONG(zendlval, ZEND_STRTOL(yytext, &end, 0));
		/* This isn't an assert, we need to ensure 019 isn't valid octal
		 * Because the lexing itself doesn't do that for us
		 */
		if (end != yytext + yyleng) {
			zend_throw_exception(zend_ce_parse_error, "Invalid numeric literal", 0);
			ZVAL_UNDEF(zendlval);
			RETURN_TOKEN(T_LNUMBER);
		}
	} else {
		errno = 0;
		ZVAL_LONG(zendlval, ZEND_STRTOL(yytext, &end, 0));
		if (errno == ERANGE) { /* Overflow */
			errno = 0;
			if (yytext[0] == '0') { /* octal overflow */
				errno = 0;
				ZVAL_DOUBLE(zendlval, zend_oct_strtod(yytext, (const char **)&end));
			} else {
				ZVAL_DOUBLE(zendlval, zend_strtod(yytext, (const char **)&end));
			}
			/* Also not an assert for the same reason */
			if (end != yytext + yyleng) {
				zend_throw_exception(zend_ce_parse_error,
					"Invalid numeric literal", 0);
				ZVAL_UNDEF(zendlval);
				RETURN_TOKEN(T_DNUMBER);
			}
			ZEND_ASSERT(!errno);
			RETURN_TOKEN(T_DNUMBER);
		}
		/* Also not an assert for the same reason */
		if (end != yytext + yyleng) {
			zend_throw_exception(zend_ce_parse_error, "Invalid numeric literal", 0);
			ZVAL_UNDEF(zendlval);
			RETURN_TOKEN(T_DNUMBER);
		}
	}
	ZEND_ASSERT(!errno);
	RETURN_TOKEN(T_LNUMBER);
}
#line 2778 "Zend/zend_language_scanner.c"
yy137:
		YYDEBUG(137, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '9') {
			if (yych == '.') goto yy151;
			if (yych <= '/') goto yy136;
			goto yy154;
		} else {
			if (yych <= 'E') {
				if (yych <= 'D') goto yy136;
				goto yy156;
			} else {
				if (yych == 'e') goto yy156;
				goto yy136;
			}
		}
yy138:
		YYDEBUG(138, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy150;
yy139:
		YYDEBUG(139, *YYCURSOR);
		++YYCURSOR;
yy140:
		YYDEBUG(140, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1906 "Zend/zend_language_scanner.l"
		{
	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				CG(zend_lineno)++;
				break;
			case '?':
				if (*YYCURSOR == '>') {
					YYCURSOR--;
					break;
				}
				/* fall through */
			default:
				continue;
		}

		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	RETURN_TOKEN(T_COMMENT);
}
#line 2835 "Zend/zend_language_scanner.c"
yy141:
		YYDEBUG(141, *YYCURSOR);
		++YYCURSOR;
yy142:
		YYDEBUG(142, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1974 "Zend/zend_language_scanner.l"
		{
	register char *s, *t;
	char *end;
	int bprefix = (yytext[0] != '\'') ? 1 : 0;

	while (1) {
		if (YYCURSOR < YYLIMIT) {
			if (*YYCURSOR == '\'') {
				YYCURSOR++;
				yyleng = YYCURSOR - SCNG(yy_text);

				break;
			} else if (*YYCURSOR++ == '\\' && YYCURSOR < YYLIMIT) {
				YYCURSOR++;
			}
		} else {
			yyleng = YYLIMIT - SCNG(yy_text);

			/* Unclosed single quotes; treat similar to double quotes, but without a separate token
			 * for ' (unrecognized by parser), instead of old flex fallback to "Unexpected character..."
			 * rule, which continued in ST_IN_SCRIPTING state after the quote */
			ZVAL_NULL(zendlval);
			RETURN_TOKEN(T_ENCAPSED_AND_WHITESPACE);
		}
	}

	ZVAL_STRINGL(zendlval, yytext+bprefix+1, yyleng-bprefix-2);

	/* convert escape sequences */
	s = t = Z_STRVAL_P(zendlval);
	end = s+Z_STRLEN_P(zendlval);
	while (s<end) {
		if (*s=='\\') {
			s++;

			switch(*s) {
				case '\\':
				case '\'':
					*t++ = *s;
					Z_STRLEN_P(zendlval)--;
					break;
				default:
					*t++ = '\\';
					*t++ = *s;
					break;
			}
		} else {
			*t++ = *s;
		}

		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
	}
	*t = 0;

	if (SCNG(output_filter)) {
		size_t sz = 0;
		char *str = NULL;
		s = Z_STRVAL_P(zendlval);
		// TODO: avoid reallocation ???
		SCNG(output_filter)((unsigned char **)&str, &sz, (unsigned char *)s, (size_t)Z_STRLEN_P(zendlval));
		ZVAL_STRINGL(zendlval, str, sz);
	}
	RETURN_TOKEN(T_CONSTANT_ENCAPSED_STRING);
}
#line 2910 "Zend/zend_language_scanner.c"
yy143:
		YYDEBUG(143, *YYCURSOR);
		++YYCURSOR;
yy144:
		YYDEBUG(144, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2043 "Zend/zend_language_scanner.l"
		{
	int bprefix = (yytext[0] != '"') ? 1 : 0;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				yyleng = YYCURSOR - SCNG(yy_text);
				zend_scan_escape_string(zendlval, yytext+bprefix+1, yyleng-bprefix-2, '"');
				RETURN_TOKEN(T_CONSTANT_ENCAPSED_STRING);
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	/* Remember how much was scanned to save rescanning */
	SET_DOUBLE_QUOTES_SCANNED_LENGTH(YYCURSOR - SCNG(yy_text) - yyleng);

	YYCURSOR = SCNG(yy_text) + yyleng;

	BEGIN(ST_DOUBLE_QUOTES);
	RETURN_TOKEN('"');
}
#line 2958 "Zend/zend_language_scanner.c"
yy145:
		YYDEBUG(145, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(146, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2133 "Zend/zend_language_scanner.l"
		{
	BEGIN(ST_BACKQUOTE);
	RETURN_TOKEN('`');
}
#line 2969 "Zend/zend_language_scanner.c"
yy147:
		YYDEBUG(147, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(148, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2395 "Zend/zend_language_scanner.l"
		{
	if (YYCURSOR > YYLIMIT) {
		RETURN_TOKEN(END);
	}

	zend_error(E_COMPILE_WARNING,"Unexpected character in input:  '%c' (ASCII=%d) state=%d", yytext[0], yytext[0], YYSTATE);
	goto restart;
}
#line 2984 "Zend/zend_language_scanner.c"
yy149:
		YYDEBUG(149, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy150:
		YYDEBUG(150, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy149;
		}
		goto yy87;
yy151:
		YYDEBUG(151, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(152, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy151;
		}
		if (yych == 'E') goto yy156;
		if (yych == 'e') goto yy156;
yy153:
		YYDEBUG(153, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1748 "Zend/zend_language_scanner.l"
		{
	const char *end;

	ZVAL_DOUBLE(zendlval, zend_strtod(yytext, &end));
	/* errno isn't checked since we allow HUGE_VAL/INF overflow */
	ZEND_ASSERT(end == yytext + yyleng);
	RETURN_TOKEN(T_DNUMBER);
}
#line 3020 "Zend/zend_language_scanner.c"
yy154:
		YYDEBUG(154, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(155, *YYCURSOR);
		if (yych <= '9') {
			if (yych == '.') goto yy151;
			if (yych <= '/') goto yy136;
			goto yy154;
		} else {
			if (yych <= 'E') {
				if (yych <= 'D') goto yy136;
			} else {
				if (yych != 'e') goto yy136;
			}
		}
yy156:
		YYDEBUG(156, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= ',') {
			if (yych == '+') goto yy158;
		} else {
			if (yych <= '-') goto yy158;
			if (yych <= '/') goto yy157;
			if (yych <= '9') goto yy159;
		}
yy157:
		YYDEBUG(157, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 3) {
			if (yyaccept <= 1) {
				if (yyaccept <= 0) {
					goto yy87;
				} else {
					goto yy102;
				}
			} else {
				if (yyaccept <= 2) {
					goto yy136;
				} else {
					goto yy153;
				}
			}
		} else {
			if (yyaccept <= 5) {
				if (yyaccept <= 4) {
					goto yy190;
				} else {
					goto yy210;
				}
			} else {
				goto yy601;
			}
		}
yy158:
		YYDEBUG(158, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '/') goto yy157;
		if (yych >= ':') goto yy157;
yy159:
		YYDEBUG(159, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(160, *YYCURSOR);
		if (yych <= '/') goto yy153;
		if (yych <= '9') goto yy159;
		goto yy153;
yy161:
		YYDEBUG(161, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 32) {
			goto yy166;
		}
		goto yy157;
yy162:
		YYDEBUG(162, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy163;
		}
		goto yy157;
yy163:
		YYDEBUG(163, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(164, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy163;
		}
		YYDEBUG(165, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1626 "Zend/zend_language_scanner.l"
		{
	char *bin = yytext + 2; /* Skip "0b" */
	int len = yyleng - 2;
	char *end;

	/* Skip any leading 0s */
	while (*bin == '0') {
		++bin;
		--len;
	}

	if (len < SIZEOF_ZEND_LONG * 8) {
		if (len == 0) {
			ZVAL_LONG(zendlval, 0);
		} else {
			errno = 0;
			ZVAL_LONG(zendlval, ZEND_STRTOL(bin, &end, 2));
			ZEND_ASSERT(!errno && end == yytext + yyleng);
		}
		RETURN_TOKEN(T_LNUMBER);
	} else {
		ZVAL_DOUBLE(zendlval, zend_bin_strtod(bin, (const char **)&end));
		/* errno isn't checked since we allow HUGE_VAL/INF overflow */
		ZEND_ASSERT(end == yytext + yyleng);
		RETURN_TOKEN(T_DNUMBER);
	}
}
#line 3144 "Zend/zend_language_scanner.c"
yy166:
		YYDEBUG(166, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(167, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy166;
		}
		YYDEBUG(168, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1699 "Zend/zend_language_scanner.l"
		{
	char *hex = yytext + 2; /* Skip "0x" */
	int len = yyleng - 2;
	char *end;

	/* Skip any leading 0s */
	while (*hex == '0') {
		hex++;
		len--;
	}

	if (len < SIZEOF_ZEND_LONG * 2 || (len == SIZEOF_ZEND_LONG * 2 && *hex <= '7')) {
		if (len == 0) {
			ZVAL_LONG(zendlval, 0);
		} else {
			errno = 0;
			ZVAL_LONG(zendlval, ZEND_STRTOL(hex, &end, 16));
			ZEND_ASSERT(!errno && end == hex + len);
		}
		RETURN_TOKEN(T_LNUMBER);
	} else {
		ZVAL_DOUBLE(zendlval, zend_hex_strtod(hex, (const char **)&end));
		/* errno isn't checked since we allow HUGE_VAL/INF overflow */
		ZEND_ASSERT(end == hex + len);
		RETURN_TOKEN(T_DNUMBER);
	}
}
#line 3184 "Zend/zend_language_scanner.c"
yy169:
		YYDEBUG(169, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(170, *YYCURSOR);
		if (yych <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy169;
			} else {
				if (yych <= '@') goto yy171;
				if (yych <= 'Z') goto yy169;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy169;
			} else {
				if (yych <= 'z') goto yy169;
				if (yych >= 0x7F) goto yy169;
			}
		}
yy171:
		YYDEBUG(171, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1877 "Zend/zend_language_scanner.l"
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	RETURN_TOKEN(T_VARIABLE);
}
#line 3214 "Zend/zend_language_scanner.c"
yy172:
		YYDEBUG(172, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy173;
		if (yych != 'r') goto yy150;
yy173:
		YYDEBUG(173, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(174, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1572 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_LOGICAL_XOR);
}
#line 3232 "Zend/zend_language_scanner.c"
yy175:
		YYDEBUG(175, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(176, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1564 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_LOGICAL_OR);
}
#line 3245 "Zend/zend_language_scanner.c"
yy177:
		YYDEBUG(177, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(178, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1552 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_XOR_EQUAL);
}
#line 3255 "Zend/zend_language_scanner.c"
yy179:
		YYDEBUG(179, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(180, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1556 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_BOOLEAN_OR);
}
#line 3265 "Zend/zend_language_scanner.c"
yy181:
		YYDEBUG(181, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(182, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1548 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_OR_EQUAL);
}
#line 3275 "Zend/zend_language_scanner.c"
yy183:
		YYDEBUG(183, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(184, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1560 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_BOOLEAN_AND);
}
#line 3285 "Zend/zend_language_scanner.c"
yy185:
		YYDEBUG(185, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(186, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1544 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_AND_EQUAL);
}
#line 3295 "Zend/zend_language_scanner.c"
yy187:
		YYDEBUG(187, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(188, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1532 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_MOD_EQUAL);
}
#line 3305 "Zend/zend_language_scanner.c"
yy189:
		YYDEBUG(189, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '*') goto yy194;
yy190:
		YYDEBUG(190, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1935 "Zend/zend_language_scanner.l"
		{
	int doc_com;

	if (yyleng > 2) {
		doc_com = 1;
		RESET_DOC_COMMENT();
	} else {
		doc_com = 0;
	}

	while (YYCURSOR < YYLIMIT) {
		if (*YYCURSOR++ == '*' && *YYCURSOR == '/') {
			break;
		}
	}

	if (YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	} else {
		zend_error(E_COMPILE_WARNING, "Unterminated comment starting line %d", CG(zend_lineno));
	}

	yyleng = YYCURSOR - SCNG(yy_text);
	HANDLE_NEWLINES(yytext, yyleng);

	if (doc_com) {
		CG(doc_comment) = zend_string_init(yytext, yyleng, 0);
		RETURN_TOKEN(T_DOC_COMMENT);
	}

	RETURN_TOKEN(T_COMMENT);
}
#line 3347 "Zend/zend_language_scanner.c"
yy191:
		YYDEBUG(191, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy140;
yy192:
		YYDEBUG(192, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(193, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1524 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_DIV_EQUAL);
}
#line 3361 "Zend/zend_language_scanner.c"
yy194:
		YYDEBUG(194, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy195;
		}
		goto yy157;
yy195:
		YYDEBUG(195, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(196, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy195;
		}
		goto yy190;
yy197:
		YYDEBUG(197, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '=') goto yy201;
		YYDEBUG(198, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1516 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_POW);
}
#line 3389 "Zend/zend_language_scanner.c"
yy199:
		YYDEBUG(199, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(200, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1512 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_MUL_EQUAL);
}
#line 3399 "Zend/zend_language_scanner.c"
yy201:
		YYDEBUG(201, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(202, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1520 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_POW_EQUAL);
}
#line 3409 "Zend/zend_language_scanner.c"
yy203:
		YYDEBUG(203, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '=') goto yy207;
		YYDEBUG(204, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1580 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_SR);
}
#line 3420 "Zend/zend_language_scanner.c"
yy205:
		YYDEBUG(205, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(206, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1500 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_IS_GREATER_OR_EQUAL);
}
#line 3430 "Zend/zend_language_scanner.c"
yy207:
		YYDEBUG(207, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(208, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1540 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_SR_EQUAL);
}
#line 3440 "Zend/zend_language_scanner.c"
yy209:
		YYDEBUG(209, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ';') goto yy210;
		if (yych <= '<') goto yy219;
		if (yych <= '=') goto yy217;
yy210:
		YYDEBUG(210, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1576 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_SL);
}
#line 3455 "Zend/zend_language_scanner.c"
yy211:
		YYDEBUG(211, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '>') goto yy215;
		YYDEBUG(212, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1496 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_IS_SMALLER_OR_EQUAL);
}
#line 3466 "Zend/zend_language_scanner.c"
yy213:
		YYDEBUG(213, *YYCURSOR);
		++YYCURSOR;
yy214:
		YYDEBUG(214, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1488 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_IS_NOT_EQUAL);
}
#line 3477 "Zend/zend_language_scanner.c"
yy215:
		YYDEBUG(215, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(216, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1492 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_SPACESHIP);
}
#line 3487 "Zend/zend_language_scanner.c"
yy217:
		YYDEBUG(217, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(218, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1536 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_SL_EQUAL);
}
#line 3497 "Zend/zend_language_scanner.c"
yy219:
		YYDEBUG(219, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(220, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy219;
		}
		if (yych <= 'Z') {
			if (yych <= '&') {
				if (yych == '"') goto yy224;
				goto yy157;
			} else {
				if (yych <= '\'') goto yy223;
				if (yych <= '@') goto yy157;
			}
		} else {
			if (yych <= '`') {
				if (yych != '_') goto yy157;
			} else {
				if (yych <= 'z') goto yy221;
				if (yych <= '~') goto yy157;
			}
		}
yy221:
		YYDEBUG(221, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(222, *YYCURSOR);
		if (yych <= '@') {
			if (yych <= '\f') {
				if (yych == '\n') goto yy228;
				goto yy157;
			} else {
				if (yych <= '\r') goto yy230;
				if (yych <= '/') goto yy157;
				if (yych <= '9') goto yy221;
				goto yy157;
			}
		} else {
			if (yych <= '_') {
				if (yych <= 'Z') goto yy221;
				if (yych <= '^') goto yy157;
				goto yy221;
			} else {
				if (yych <= '`') goto yy157;
				if (yych <= 'z') goto yy221;
				if (yych <= '~') goto yy157;
				goto yy221;
			}
		}
yy223:
		YYDEBUG(223, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\'') goto yy157;
		if (yych <= '/') goto yy232;
		if (yych <= '9') goto yy157;
		goto yy232;
yy224:
		YYDEBUG(224, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '"') goto yy157;
		if (yych <= '/') goto yy226;
		if (yych <= '9') goto yy157;
		goto yy226;
yy225:
		YYDEBUG(225, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy226:
		YYDEBUG(226, *YYCURSOR);
		if (yych <= 'Z') {
			if (yych <= '/') {
				if (yych != '"') goto yy157;
			} else {
				if (yych <= '9') goto yy225;
				if (yych <= '@') goto yy157;
				goto yy225;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy225;
				goto yy157;
			} else {
				if (yych <= 'z') goto yy225;
				if (yych <= '~') goto yy157;
				goto yy225;
			}
		}
yy227:
		YYDEBUG(227, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy228;
		if (yych == '\r') goto yy230;
		goto yy157;
yy228:
		YYDEBUG(228, *YYCURSOR);
		++YYCURSOR;
yy229:
		YYDEBUG(229, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2085 "Zend/zend_language_scanner.l"
		{
	char *s;
	int bprefix = (yytext[0] != '<') ? 1 : 0;
	zend_heredoc_label *heredoc_label = emalloc(sizeof(zend_heredoc_label));

	CG(zend_lineno)++;
	heredoc_label->length = yyleng-bprefix-3-1-(yytext[yyleng-2]=='\r'?1:0);
	s = yytext+bprefix+3;
	while ((*s == ' ') || (*s == '\t')) {
		s++;
		heredoc_label->length--;
	}

	if (*s == '\'') {
		s++;
		heredoc_label->length -= 2;

		BEGIN(ST_NOWDOC);
	} else {
		if (*s == '"') {
			s++;
			heredoc_label->length -= 2;
		}

		BEGIN(ST_HEREDOC);
	}

	heredoc_label->label = estrndup(s, heredoc_label->length);

	/* Check for ending label on the next line */
	if (heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, s, heredoc_label->length)) {
		YYCTYPE *end = YYCURSOR + heredoc_label->length;

		if (*end == ';') {
			end++;
		}

		if (*end == '\n' || *end == '\r') {
			BEGIN(ST_END_HEREDOC);
		}
	}

	zend_ptr_stack_push(&SCNG(heredoc_label_stack), (void *) heredoc_label);

	RETURN_TOKEN(T_START_HEREDOC);
}
#line 3649 "Zend/zend_language_scanner.c"
yy230:
		YYDEBUG(230, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy228;
		goto yy229;
yy231:
		YYDEBUG(231, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy232:
		YYDEBUG(232, *YYCURSOR);
		if (yych <= 'Z') {
			if (yych <= '/') {
				if (yych == '\'') goto yy227;
				goto yy157;
			} else {
				if (yych <= '9') goto yy231;
				if (yych <= '@') goto yy157;
				goto yy231;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy231;
				goto yy157;
			} else {
				if (yych <= 'z') goto yy231;
				if (yych <= '~') goto yy157;
				goto yy231;
			}
		}
yy233:
		YYDEBUG(233, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '=') goto yy214;
		YYDEBUG(234, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(235, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1480 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_IS_NOT_IDENTICAL);
}
#line 3693 "Zend/zend_language_scanner.c"
yy236:
		YYDEBUG(236, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(237, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1504 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_PLUS_EQUAL);
}
#line 3703 "Zend/zend_language_scanner.c"
yy238:
		YYDEBUG(238, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(239, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1468 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_INC);
}
#line 3713 "Zend/zend_language_scanner.c"
yy240:
		YYDEBUG(240, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy241;
		if (yych != 's') goto yy150;
yy241:
		YYDEBUG(241, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy242;
		if (yych != 't') goto yy150;
yy242:
		YYDEBUG(242, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(243, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1456 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_LIST);
}
#line 3736 "Zend/zend_language_scanner.c"
yy244:
		YYDEBUG(244, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '=') goto yy248;
		YYDEBUG(245, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1484 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_IS_EQUAL);
}
#line 3747 "Zend/zend_language_scanner.c"
yy246:
		YYDEBUG(246, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(247, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1452 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_DOUBLE_ARROW);
}
#line 3757 "Zend/zend_language_scanner.c"
yy248:
		YYDEBUG(248, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(249, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1476 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_IS_IDENTICAL);
}
#line 3767 "Zend/zend_language_scanner.c"
yy250:
		YYDEBUG(250, *YYCURSOR);
		yych = *++YYCURSOR;
		YYDEBUG(-1, yych);
		switch (yych) {
		case 'C':
		case 'c':	goto yy252;
		case 'D':
		case 'd':	goto yy257;
		case 'F':
		case 'f':	goto yy254;
		case 'H':
		case 'h':	goto yy251;
		case 'L':
		case 'l':	goto yy256;
		case 'M':
		case 'm':	goto yy255;
		case 'N':
		case 'n':	goto yy258;
		case 'T':
		case 't':	goto yy253;
		default:	goto yy150;
		}
yy251:
		YYDEBUG(251, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy319;
		if (yych == 'a') goto yy319;
		goto yy150;
yy252:
		YYDEBUG(252, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy312;
		if (yych == 'l') goto yy312;
		goto yy150;
yy253:
		YYDEBUG(253, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy305;
		if (yych == 'r') goto yy305;
		goto yy150;
yy254:
		YYDEBUG(254, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'U') {
			if (yych == 'I') goto yy289;
			if (yych <= 'T') goto yy150;
			goto yy290;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy150;
				goto yy289;
			} else {
				if (yych == 'u') goto yy290;
				goto yy150;
			}
		}
yy255:
		YYDEBUG(255, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy281;
		if (yych == 'e') goto yy281;
		goto yy150;
yy256:
		YYDEBUG(256, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy275;
		if (yych == 'i') goto yy275;
		goto yy150;
yy257:
		YYDEBUG(257, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy270;
		if (yych == 'i') goto yy270;
		goto yy150;
yy258:
		YYDEBUG(258, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy259;
		if (yych != 'a') goto yy150;
yy259:
		YYDEBUG(259, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy260;
		if (yych != 'm') goto yy150;
yy260:
		YYDEBUG(260, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy261;
		if (yych != 'e') goto yy150;
yy261:
		YYDEBUG(261, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy262;
		if (yych != 's') goto yy150;
yy262:
		YYDEBUG(262, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy263;
		if (yych != 'p') goto yy150;
yy263:
		YYDEBUG(263, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy264;
		if (yych != 'a') goto yy150;
yy264:
		YYDEBUG(264, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy265;
		if (yych != 'c') goto yy150;
yy265:
		YYDEBUG(265, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy266;
		if (yych != 'e') goto yy150;
yy266:
		YYDEBUG(266, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy150;
		YYDEBUG(267, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy150;
		YYDEBUG(268, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(269, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1785 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_NS_C);
}
#line 3901 "Zend/zend_language_scanner.c"
yy270:
		YYDEBUG(270, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy271;
		if (yych != 'r') goto yy150;
yy271:
		YYDEBUG(271, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy150;
		YYDEBUG(272, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy150;
		YYDEBUG(273, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(274, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1781 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_DIR);
}
#line 3925 "Zend/zend_language_scanner.c"
yy275:
		YYDEBUG(275, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy276;
		if (yych != 'n') goto yy150;
yy276:
		YYDEBUG(276, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy277;
		if (yych != 'e') goto yy150;
yy277:
		YYDEBUG(277, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy150;
		YYDEBUG(278, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy150;
		YYDEBUG(279, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(280, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1773 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_LINE);
}
#line 3954 "Zend/zend_language_scanner.c"
yy281:
		YYDEBUG(281, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy282;
		if (yych != 't') goto yy150;
yy282:
		YYDEBUG(282, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy283;
		if (yych != 'h') goto yy150;
yy283:
		YYDEBUG(283, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy284;
		if (yych != 'o') goto yy150;
yy284:
		YYDEBUG(284, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy285;
		if (yych != 'd') goto yy150;
yy285:
		YYDEBUG(285, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy150;
		YYDEBUG(286, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy150;
		YYDEBUG(287, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(288, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1769 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_METHOD_C);
}
#line 3993 "Zend/zend_language_scanner.c"
yy289:
		YYDEBUG(289, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy300;
		if (yych == 'l') goto yy300;
		goto yy150;
yy290:
		YYDEBUG(290, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy291;
		if (yych != 'n') goto yy150;
yy291:
		YYDEBUG(291, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy292;
		if (yych != 'c') goto yy150;
yy292:
		YYDEBUG(292, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy293;
		if (yych != 't') goto yy150;
yy293:
		YYDEBUG(293, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy294;
		if (yych != 'i') goto yy150;
yy294:
		YYDEBUG(294, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy295;
		if (yych != 'o') goto yy150;
yy295:
		YYDEBUG(295, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy296;
		if (yych != 'n') goto yy150;
yy296:
		YYDEBUG(296, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy150;
		YYDEBUG(297, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy150;
		YYDEBUG(298, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(299, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1765 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_FUNC_C);
}
#line 4048 "Zend/zend_language_scanner.c"
yy300:
		YYDEBUG(300, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy301;
		if (yych != 'e') goto yy150;
yy301:
		YYDEBUG(301, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy150;
		YYDEBUG(302, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy150;
		YYDEBUG(303, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(304, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1777 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_FILE);
}
#line 4072 "Zend/zend_language_scanner.c"
yy305:
		YYDEBUG(305, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy306;
		if (yych != 'a') goto yy150;
yy306:
		YYDEBUG(306, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy307;
		if (yych != 'i') goto yy150;
yy307:
		YYDEBUG(307, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy308;
		if (yych != 't') goto yy150;
yy308:
		YYDEBUG(308, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy150;
		YYDEBUG(309, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy150;
		YYDEBUG(310, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(311, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1761 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_TRAIT_C);
}
#line 4106 "Zend/zend_language_scanner.c"
yy312:
		YYDEBUG(312, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy313;
		if (yych != 'a') goto yy150;
yy313:
		YYDEBUG(313, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy314;
		if (yych != 's') goto yy150;
yy314:
		YYDEBUG(314, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy315;
		if (yych != 's') goto yy150;
yy315:
		YYDEBUG(315, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy150;
		YYDEBUG(316, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy150;
		YYDEBUG(317, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(318, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1757 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_CLASS_C);
}
#line 4140 "Zend/zend_language_scanner.c"
yy319:
		YYDEBUG(319, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy320;
		if (yych != 'l') goto yy150;
yy320:
		YYDEBUG(320, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy321;
		if (yych != 't') goto yy150;
yy321:
		YYDEBUG(321, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy150;
		YYDEBUG(322, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy323;
		if (yych != 'c') goto yy150;
yy323:
		YYDEBUG(323, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy324;
		if (yych != 'o') goto yy150;
yy324:
		YYDEBUG(324, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy325;
		if (yych != 'm') goto yy150;
yy325:
		YYDEBUG(325, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy326;
		if (yych != 'p') goto yy150;
yy326:
		YYDEBUG(326, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy327;
		if (yych != 'i') goto yy150;
yy327:
		YYDEBUG(327, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy328;
		if (yych != 'l') goto yy150;
yy328:
		YYDEBUG(328, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy329;
		if (yych != 'e') goto yy150;
yy329:
		YYDEBUG(329, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy330;
		if (yych != 'r') goto yy150;
yy330:
		YYDEBUG(330, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(331, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1420 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_HALT_COMPILER);
}
#line 4206 "Zend/zend_language_scanner.c"
yy332:
		YYDEBUG(332, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy336;
		if (yych == 's') goto yy336;
		goto yy150;
yy333:
		YYDEBUG(333, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy334;
		if (yych != 'e') goto yy150;
yy334:
		YYDEBUG(334, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(335, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1400 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_USE);
}
#line 4230 "Zend/zend_language_scanner.c"
yy336:
		YYDEBUG(336, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy337;
		if (yych != 'e') goto yy150;
yy337:
		YYDEBUG(337, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy338;
		if (yych != 't') goto yy150;
yy338:
		YYDEBUG(338, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(339, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1448 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_UNSET);
}
#line 4253 "Zend/zend_language_scanner.c"
yy340:
		YYDEBUG(340, *YYCURSOR);
		++YYCURSOR;
		YYFILL(7);
		yych = *YYCURSOR;
yy341:
		YYDEBUG(341, *YYCURSOR);
		if (yych <= 'S') {
			if (yych <= 'D') {
				if (yych <= ' ') {
					if (yych == '\t') goto yy340;
					if (yych <= 0x1F) goto yy157;
					goto yy340;
				} else {
					if (yych <= 'A') {
						if (yych <= '@') goto yy157;
						goto yy345;
					} else {
						if (yych <= 'B') goto yy343;
						if (yych <= 'C') goto yy157;
						goto yy348;
					}
				}
			} else {
				if (yych <= 'I') {
					if (yych == 'F') goto yy349;
					if (yych <= 'H') goto yy157;
					goto yy350;
				} else {
					if (yych <= 'O') {
						if (yych <= 'N') goto yy157;
						goto yy344;
					} else {
						if (yych <= 'Q') goto yy157;
						if (yych <= 'R') goto yy347;
						goto yy346;
					}
				}
			}
		} else {
			if (yych <= 'f') {
				if (yych <= 'a') {
					if (yych == 'U') goto yy342;
					if (yych <= '`') goto yy157;
					goto yy345;
				} else {
					if (yych <= 'c') {
						if (yych <= 'b') goto yy343;
						goto yy157;
					} else {
						if (yych <= 'd') goto yy348;
						if (yych <= 'e') goto yy157;
						goto yy349;
					}
				}
			} else {
				if (yych <= 'q') {
					if (yych <= 'i') {
						if (yych <= 'h') goto yy157;
						goto yy350;
					} else {
						if (yych == 'o') goto yy344;
						goto yy157;
					}
				} else {
					if (yych <= 's') {
						if (yych <= 'r') goto yy347;
						goto yy346;
					} else {
						if (yych != 'u') goto yy157;
					}
				}
			}
		}
yy342:
		YYDEBUG(342, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy409;
		if (yych == 'n') goto yy409;
		goto yy157;
yy343:
		YYDEBUG(343, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych == 'I') goto yy396;
			if (yych <= 'N') goto yy157;
			goto yy397;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy157;
				goto yy396;
			} else {
				if (yych == 'o') goto yy397;
				goto yy157;
			}
		}
yy344:
		YYDEBUG(344, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy388;
		if (yych == 'b') goto yy388;
		goto yy157;
yy345:
		YYDEBUG(345, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy381;
		if (yych == 'r') goto yy381;
		goto yy157;
yy346:
		YYDEBUG(346, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy373;
		if (yych == 't') goto yy373;
		goto yy157;
yy347:
		YYDEBUG(347, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy371;
		if (yych == 'e') goto yy371;
		goto yy157;
yy348:
		YYDEBUG(348, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy367;
		if (yych == 'o') goto yy367;
		goto yy157;
yy349:
		YYDEBUG(349, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy360;
		if (yych == 'l') goto yy360;
		goto yy157;
yy350:
		YYDEBUG(350, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy351;
		if (yych != 'n') goto yy157;
yy351:
		YYDEBUG(351, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy352;
		if (yych != 't') goto yy157;
yy352:
		YYDEBUG(352, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy353;
		if (yych != 'e') goto yy355;
yy353:
		YYDEBUG(353, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'G') goto yy358;
		if (yych == 'g') goto yy358;
		goto yy157;
yy354:
		YYDEBUG(354, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy355:
		YYDEBUG(355, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy354;
			goto yy157;
		} else {
			if (yych <= ' ') goto yy354;
			if (yych != ')') goto yy157;
		}
		YYDEBUG(356, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(357, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1348 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_INT_CAST);
}
#line 4429 "Zend/zend_language_scanner.c"
yy358:
		YYDEBUG(358, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy359;
		if (yych != 'e') goto yy157;
yy359:
		YYDEBUG(359, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy354;
		if (yych == 'r') goto yy354;
		goto yy157;
yy360:
		YYDEBUG(360, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy361;
		if (yych != 'o') goto yy157;
yy361:
		YYDEBUG(361, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy362;
		if (yych != 'a') goto yy157;
yy362:
		YYDEBUG(362, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy363;
		if (yych != 't') goto yy157;
yy363:
		YYDEBUG(363, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(364, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy363;
			goto yy157;
		} else {
			if (yych <= ' ') goto yy363;
			if (yych != ')') goto yy157;
		}
		YYDEBUG(365, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(366, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1352 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_DOUBLE_CAST);
}
#line 4477 "Zend/zend_language_scanner.c"
yy367:
		YYDEBUG(367, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy368;
		if (yych != 'u') goto yy157;
yy368:
		YYDEBUG(368, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy369;
		if (yych != 'b') goto yy157;
yy369:
		YYDEBUG(369, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy370;
		if (yych != 'l') goto yy157;
yy370:
		YYDEBUG(370, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy363;
		if (yych == 'e') goto yy363;
		goto yy157;
yy371:
		YYDEBUG(371, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy372;
		if (yych != 'a') goto yy157;
yy372:
		YYDEBUG(372, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy363;
		if (yych == 'l') goto yy363;
		goto yy157;
yy373:
		YYDEBUG(373, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy374;
		if (yych != 'r') goto yy157;
yy374:
		YYDEBUG(374, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy375;
		if (yych != 'i') goto yy157;
yy375:
		YYDEBUG(375, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy376;
		if (yych != 'n') goto yy157;
yy376:
		YYDEBUG(376, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'G') goto yy377;
		if (yych != 'g') goto yy157;
yy377:
		YYDEBUG(377, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(378, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy377;
			goto yy157;
		} else {
			if (yych <= ' ') goto yy377;
			if (yych != ')') goto yy157;
		}
		YYDEBUG(379, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(380, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1356 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_STRING_CAST);
}
#line 4551 "Zend/zend_language_scanner.c"
yy381:
		YYDEBUG(381, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy382;
		if (yych != 'r') goto yy157;
yy382:
		YYDEBUG(382, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy383;
		if (yych != 'a') goto yy157;
yy383:
		YYDEBUG(383, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy384;
		if (yych != 'y') goto yy157;
yy384:
		YYDEBUG(384, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(385, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy384;
			goto yy157;
		} else {
			if (yych <= ' ') goto yy384;
			if (yych != ')') goto yy157;
		}
		YYDEBUG(386, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(387, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1360 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ARRAY_CAST);
}
#line 4588 "Zend/zend_language_scanner.c"
yy388:
		YYDEBUG(388, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'J') goto yy389;
		if (yych != 'j') goto yy157;
yy389:
		YYDEBUG(389, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy390;
		if (yych != 'e') goto yy157;
yy390:
		YYDEBUG(390, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy391;
		if (yych != 'c') goto yy157;
yy391:
		YYDEBUG(391, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy392;
		if (yych != 't') goto yy157;
yy392:
		YYDEBUG(392, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(393, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy392;
			goto yy157;
		} else {
			if (yych <= ' ') goto yy392;
			if (yych != ')') goto yy157;
		}
		YYDEBUG(394, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(395, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1364 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_OBJECT_CAST);
}
#line 4630 "Zend/zend_language_scanner.c"
yy396:
		YYDEBUG(396, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy406;
		if (yych == 'n') goto yy406;
		goto yy157;
yy397:
		YYDEBUG(397, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy398;
		if (yych != 'o') goto yy157;
yy398:
		YYDEBUG(398, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy399;
		if (yych != 'l') goto yy157;
yy399:
		YYDEBUG(399, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy404;
		if (yych == 'e') goto yy404;
		goto yy401;
yy400:
		YYDEBUG(400, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy401:
		YYDEBUG(401, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy400;
			goto yy157;
		} else {
			if (yych <= ' ') goto yy400;
			if (yych != ')') goto yy157;
		}
		YYDEBUG(402, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(403, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1368 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_BOOL_CAST);
}
#line 4675 "Zend/zend_language_scanner.c"
yy404:
		YYDEBUG(404, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy405;
		if (yych != 'a') goto yy157;
yy405:
		YYDEBUG(405, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy400;
		if (yych == 'n') goto yy400;
		goto yy157;
yy406:
		YYDEBUG(406, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy407;
		if (yych != 'a') goto yy157;
yy407:
		YYDEBUG(407, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy408;
		if (yych != 'r') goto yy157;
yy408:
		YYDEBUG(408, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy377;
		if (yych == 'y') goto yy377;
		goto yy157;
yy409:
		YYDEBUG(409, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy410;
		if (yych != 's') goto yy157;
yy410:
		YYDEBUG(410, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy411;
		if (yych != 'e') goto yy157;
yy411:
		YYDEBUG(411, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy412;
		if (yych != 't') goto yy157;
yy412:
		YYDEBUG(412, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(413, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy412;
			goto yy157;
		} else {
			if (yych <= ' ') goto yy412;
			if (yych != ')') goto yy157;
		}
		YYDEBUG(414, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(415, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1372 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_UNSET_CAST);
}
#line 4739 "Zend/zend_language_scanner.c"
yy416:
		YYDEBUG(416, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy417;
		if (yych != 'r') goto yy150;
yy417:
		YYDEBUG(417, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(418, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1344 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_VAR);
}
#line 4757 "Zend/zend_language_scanner.c"
yy419:
		YYDEBUG(419, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy423;
		if (yych == 'm') goto yy423;
		goto yy150;
yy420:
		YYDEBUG(420, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'W') goto yy421;
		if (yych != 'w') goto yy150;
yy421:
		YYDEBUG(421, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(422, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1336 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_NEW);
}
#line 4781 "Zend/zend_language_scanner.c"
yy423:
		YYDEBUG(423, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy424;
		if (yych != 'e') goto yy150;
yy424:
		YYDEBUG(424, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy425;
		if (yych != 's') goto yy150;
yy425:
		YYDEBUG(425, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy426;
		if (yych != 'p') goto yy150;
yy426:
		YYDEBUG(426, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy427;
		if (yych != 'a') goto yy150;
yy427:
		YYDEBUG(427, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy428;
		if (yych != 'c') goto yy150;
yy428:
		YYDEBUG(428, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy429;
		if (yych != 'e') goto yy150;
yy429:
		YYDEBUG(429, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(430, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1396 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_NAMESPACE);
}
#line 4824 "Zend/zend_language_scanner.c"
yy431:
		YYDEBUG(431, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '\n') goto yy435;
		if (yych == '\r') goto yy436;
yy432:
		YYDEBUG(432, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1968 "Zend/zend_language_scanner.l"
		{
	BEGIN(INITIAL);
	RETURN_TOKEN(T_CLOSE_TAG);  /* implicit ';' at php-end tag */
}
#line 4838 "Zend/zend_language_scanner.c"
yy433:
		YYDEBUG(433, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(434, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1332 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_COALESCE);
}
#line 4848 "Zend/zend_language_scanner.c"
yy435:
		YYDEBUG(435, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy432;
yy436:
		YYDEBUG(436, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy435;
		goto yy432;
yy437:
		YYDEBUG(437, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(438, *YYCURSOR);
		if (yych <= 'D') {
			if (yych <= '/') goto yy153;
			if (yych <= '9') goto yy437;
			goto yy153;
		} else {
			if (yych <= 'E') goto yy156;
			if (yych == 'e') goto yy156;
			goto yy153;
		}
yy439:
		YYDEBUG(439, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(440, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1528 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_CONCAT_EQUAL);
}
#line 4883 "Zend/zend_language_scanner.c"
yy441:
		YYDEBUG(441, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '.') goto yy157;
		YYDEBUG(442, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(443, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1328 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ELLIPSIS);
}
#line 4896 "Zend/zend_language_scanner.c"
yy444:
		YYDEBUG(444, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(445, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1320 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_PAAMAYIM_NEKUDOTAYIM);
}
#line 4906 "Zend/zend_language_scanner.c"
yy446:
		YYDEBUG(446, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy447:
		YYDEBUG(447, *YYCURSOR);
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy104;
			if (yych <= '\n') goto yy446;
			goto yy104;
		} else {
			if (yych <= '\r') goto yy446;
			if (yych == ' ') goto yy446;
			goto yy104;
		}
yy448:
		YYDEBUG(448, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(449, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1508 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_MINUS_EQUAL);
}
#line 4932 "Zend/zend_language_scanner.c"
yy450:
		YYDEBUG(450, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(451, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1472 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_DEC);
}
#line 4942 "Zend/zend_language_scanner.c"
yy452:
		YYDEBUG(452, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(453, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1294 "Zend/zend_language_scanner.l"
		{
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN(T_OBJECT_OPERATOR);
}
#line 4953 "Zend/zend_language_scanner.c"
yy454:
		YYDEBUG(454, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych == 'I') goto yy461;
			if (yych <= 'N') goto yy150;
			goto yy462;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy150;
				goto yy461;
			} else {
				if (yych == 'o') goto yy462;
				goto yy150;
			}
		}
yy455:
		YYDEBUG(455, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy456;
		if (yych != 'b') goto yy150;
yy456:
		YYDEBUG(456, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy457;
		if (yych != 'l') goto yy150;
yy457:
		YYDEBUG(457, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy458;
		if (yych != 'i') goto yy150;
yy458:
		YYDEBUG(458, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy459;
		if (yych != 'c') goto yy150;
yy459:
		YYDEBUG(459, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(460, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1444 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_PUBLIC);
}
#line 5002 "Zend/zend_language_scanner.c"
yy461:
		YYDEBUG(461, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'V') {
			if (yych == 'N') goto yy470;
			if (yych <= 'U') goto yy150;
			goto yy471;
		} else {
			if (yych <= 'n') {
				if (yych <= 'm') goto yy150;
				goto yy470;
			} else {
				if (yych == 'v') goto yy471;
				goto yy150;
			}
		}
yy462:
		YYDEBUG(462, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy463;
		if (yych != 't') goto yy150;
yy463:
		YYDEBUG(463, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy464;
		if (yych != 'e') goto yy150;
yy464:
		YYDEBUG(464, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy465;
		if (yych != 'c') goto yy150;
yy465:
		YYDEBUG(465, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy466;
		if (yych != 't') goto yy150;
yy466:
		YYDEBUG(466, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy467;
		if (yych != 'e') goto yy150;
yy467:
		YYDEBUG(467, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy468;
		if (yych != 'd') goto yy150;
yy468:
		YYDEBUG(468, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(469, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1440 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_PROTECTED);
}
#line 5061 "Zend/zend_language_scanner.c"
yy470:
		YYDEBUG(470, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy476;
		if (yych == 't') goto yy476;
		goto yy150;
yy471:
		YYDEBUG(471, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy472;
		if (yych != 'a') goto yy150;
yy472:
		YYDEBUG(472, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy473;
		if (yych != 't') goto yy150;
yy473:
		YYDEBUG(473, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy474;
		if (yych != 'e') goto yy150;
yy474:
		YYDEBUG(474, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(475, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1436 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_PRIVATE);
}
#line 5095 "Zend/zend_language_scanner.c"
yy476:
		YYDEBUG(476, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(477, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1270 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_PRINT);
}
#line 5108 "Zend/zend_language_scanner.c"
yy478:
		YYDEBUG(478, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy483;
		if (yych == 'o') goto yy483;
		goto yy150;
yy479:
		YYDEBUG(479, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy480;
		if (yych != 't') goto yy150;
yy480:
		YYDEBUG(480, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy481;
		if (yych != 'o') goto yy150;
yy481:
		YYDEBUG(481, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(482, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1262 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_GOTO);
}
#line 5137 "Zend/zend_language_scanner.c"
yy483:
		YYDEBUG(483, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy484;
		if (yych != 'b') goto yy150;
yy484:
		YYDEBUG(484, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy485;
		if (yych != 'a') goto yy150;
yy485:
		YYDEBUG(485, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy486;
		if (yych != 'l') goto yy150;
yy486:
		YYDEBUG(486, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(487, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1408 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_GLOBAL);
}
#line 5165 "Zend/zend_language_scanner.c"
yy488:
		YYDEBUG(488, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '<') goto yy496;
		goto yy157;
yy489:
		YYDEBUG(489, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy144;
yy490:
		YYDEBUG(490, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy142;
yy491:
		YYDEBUG(491, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy492;
		if (yych != 'e') goto yy150;
yy492:
		YYDEBUG(492, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy493;
		if (yych != 'a') goto yy150;
yy493:
		YYDEBUG(493, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'K') goto yy494;
		if (yych != 'k') goto yy150;
yy494:
		YYDEBUG(494, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(495, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1254 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_BREAK);
}
#line 5206 "Zend/zend_language_scanner.c"
yy496:
		YYDEBUG(496, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '<') goto yy219;
		goto yy157;
yy497:
		YYDEBUG(497, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy504;
		if (yych == 'a') goto yy504;
		goto yy150;
yy498:
		YYDEBUG(498, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy499;
		if (yych != 'i') goto yy150;
yy499:
		YYDEBUG(499, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy500;
		if (yych != 't') goto yy150;
yy500:
		YYDEBUG(500, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy501;
		if (yych != 'c') goto yy150;
yy501:
		YYDEBUG(501, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy502;
		if (yych != 'h') goto yy150;
yy502:
		YYDEBUG(502, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(503, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1238 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_SWITCH);
}
#line 5250 "Zend/zend_language_scanner.c"
yy504:
		YYDEBUG(504, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy505;
		if (yych != 't') goto yy150;
yy505:
		YYDEBUG(505, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy506;
		if (yych != 'i') goto yy150;
yy506:
		YYDEBUG(506, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy507;
		if (yych != 'c') goto yy150;
yy507:
		YYDEBUG(507, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(508, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1424 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_STATIC);
}
#line 5278 "Zend/zend_language_scanner.c"
yy509:
		YYDEBUG(509, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy520;
		if (yych == 's') goto yy520;
		goto yy150;
yy510:
		YYDEBUG(510, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy518;
		if (yych == 'd') goto yy518;
		goto yy150;
yy511:
		YYDEBUG(511, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy514;
		if (yych == 'r') goto yy514;
		goto yy150;
yy512:
		YYDEBUG(512, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(513, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1234 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_AS);
}
#line 5309 "Zend/zend_language_scanner.c"
yy514:
		YYDEBUG(514, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy515;
		if (yych != 'a') goto yy150;
yy515:
		YYDEBUG(515, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy516;
		if (yych != 'y') goto yy150;
yy516:
		YYDEBUG(516, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(517, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1460 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ARRAY);
}
#line 5332 "Zend/zend_language_scanner.c"
yy518:
		YYDEBUG(518, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(519, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1568 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_LOGICAL_AND);
}
#line 5345 "Zend/zend_language_scanner.c"
yy520:
		YYDEBUG(520, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy521;
		if (yych != 't') goto yy150;
yy521:
		YYDEBUG(521, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy522;
		if (yych != 'r') goto yy150;
yy522:
		YYDEBUG(522, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy523;
		if (yych != 'a') goto yy150;
yy523:
		YYDEBUG(523, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy524;
		if (yych != 'c') goto yy150;
yy524:
		YYDEBUG(524, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy525;
		if (yych != 't') goto yy150;
yy525:
		YYDEBUG(525, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(526, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1428 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ABSTRACT);
}
#line 5383 "Zend/zend_language_scanner.c"
yy527:
		YYDEBUG(527, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy528;
		if (yych != 'i') goto yy150;
yy528:
		YYDEBUG(528, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy529;
		if (yych != 'l') goto yy150;
yy529:
		YYDEBUG(529, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy530;
		if (yych != 'e') goto yy150;
yy530:
		YYDEBUG(530, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(531, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1194 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_WHILE);
}
#line 5411 "Zend/zend_language_scanner.c"
yy532:
		YYDEBUG(532, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(533, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1178 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_IF);
}
#line 5424 "Zend/zend_language_scanner.c"
yy534:
		YYDEBUG(534, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy576;
		if (yych == 'p') goto yy576;
		goto yy150;
yy535:
		YYDEBUG(535, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych <= 'C') {
				if (yych <= 'B') goto yy150;
				goto yy543;
			} else {
				if (yych <= 'R') goto yy150;
				if (yych <= 'S') goto yy541;
				goto yy542;
			}
		} else {
			if (yych <= 'r') {
				if (yych == 'c') goto yy543;
				goto yy150;
			} else {
				if (yych <= 's') goto yy541;
				if (yych <= 't') goto yy542;
				goto yy150;
			}
		}
yy536:
		YYDEBUG(536, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy537;
		if (yych != 's') goto yy150;
yy537:
		YYDEBUG(537, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy538;
		if (yych != 'e') goto yy150;
yy538:
		YYDEBUG(538, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy539;
		if (yych != 't') goto yy150;
yy539:
		YYDEBUG(539, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(540, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1412 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ISSET);
}
#line 5480 "Zend/zend_language_scanner.c"
yy541:
		YYDEBUG(541, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy562;
		if (yych == 't') goto yy562;
		goto yy150;
yy542:
		YYDEBUG(542, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy555;
		if (yych == 'e') goto yy555;
		goto yy150;
yy543:
		YYDEBUG(543, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy544;
		if (yych != 'l') goto yy150;
yy544:
		YYDEBUG(544, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy545;
		if (yych != 'u') goto yy150;
yy545:
		YYDEBUG(545, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy546;
		if (yych != 'd') goto yy150;
yy546:
		YYDEBUG(546, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy547;
		if (yych != 'e') goto yy150;
yy547:
		YYDEBUG(547, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy149;
			} else {
				if (yych <= '@') goto yy548;
				if (yych <= 'Z') goto yy149;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy549;
			} else {
				if (yych <= 'z') goto yy149;
				if (yych >= 0x7F) goto yy149;
			}
		}
yy548:
		YYDEBUG(548, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1380 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_INCLUDE);
}
#line 5538 "Zend/zend_language_scanner.c"
yy549:
		YYDEBUG(549, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy550;
		if (yych != 'o') goto yy150;
yy550:
		YYDEBUG(550, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy551;
		if (yych != 'n') goto yy150;
yy551:
		YYDEBUG(551, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy552;
		if (yych != 'c') goto yy150;
yy552:
		YYDEBUG(552, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy553;
		if (yych != 'e') goto yy150;
yy553:
		YYDEBUG(553, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(554, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1384 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_INCLUDE_ONCE);
}
#line 5571 "Zend/zend_language_scanner.c"
yy555:
		YYDEBUG(555, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy556;
		if (yych != 'r') goto yy150;
yy556:
		YYDEBUG(556, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy557;
		if (yych != 'f') goto yy150;
yy557:
		YYDEBUG(557, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy558;
		if (yych != 'a') goto yy150;
yy558:
		YYDEBUG(558, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy559;
		if (yych != 'c') goto yy150;
yy559:
		YYDEBUG(559, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy560;
		if (yych != 'e') goto yy150;
yy560:
		YYDEBUG(560, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(561, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1278 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_INTERFACE);
}
#line 5609 "Zend/zend_language_scanner.c"
yy562:
		YYDEBUG(562, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'E') {
			if (yych == 'A') goto yy563;
			if (yych <= 'D') goto yy150;
			goto yy564;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy150;
			} else {
				if (yych == 'e') goto yy564;
				goto yy150;
			}
		}
yy563:
		YYDEBUG(563, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy570;
		if (yych == 'n') goto yy570;
		goto yy150;
yy564:
		YYDEBUG(564, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy565;
		if (yych != 'a') goto yy150;
yy565:
		YYDEBUG(565, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy566;
		if (yych != 'd') goto yy150;
yy566:
		YYDEBUG(566, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy567;
		if (yych != 'o') goto yy150;
yy567:
		YYDEBUG(567, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy568;
		if (yych != 'f') goto yy150;
yy568:
		YYDEBUG(568, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(569, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1404 "Zend/zend_language_scanner.l"
		{
    RETURN_TOKEN(T_INSTEADOF);
}
#line 5663 "Zend/zend_language_scanner.c"
yy570:
		YYDEBUG(570, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy571;
		if (yych != 'c') goto yy150;
yy571:
		YYDEBUG(571, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy572;
		if (yych != 'e') goto yy150;
yy572:
		YYDEBUG(572, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy573;
		if (yych != 'o') goto yy150;
yy573:
		YYDEBUG(573, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy574;
		if (yych != 'f') goto yy150;
yy574:
		YYDEBUG(574, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(575, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1230 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_INSTANCEOF);
}
#line 5696 "Zend/zend_language_scanner.c"
yy576:
		YYDEBUG(576, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy577;
		if (yych != 'l') goto yy150;
yy577:
		YYDEBUG(577, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy578;
		if (yych != 'e') goto yy150;
yy578:
		YYDEBUG(578, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy579;
		if (yych != 'm') goto yy150;
yy579:
		YYDEBUG(579, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy580;
		if (yych != 'e') goto yy150;
yy580:
		YYDEBUG(580, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy581;
		if (yych != 'n') goto yy150;
yy581:
		YYDEBUG(581, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy582;
		if (yych != 't') goto yy150;
yy582:
		YYDEBUG(582, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy583;
		if (yych != 's') goto yy150;
yy583:
		YYDEBUG(583, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(584, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1290 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_IMPLEMENTS);
}
#line 5744 "Zend/zend_language_scanner.c"
yy585:
		YYDEBUG(585, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy593;
		if (yych == 'r') goto yy593;
		goto yy150;
yy586:
		YYDEBUG(586, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'Y') {
			if (yych == 'A') goto yy589;
			if (yych <= 'X') goto yy150;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy150;
				goto yy589;
			} else {
				if (yych != 'y') goto yy150;
			}
		}
		YYDEBUG(587, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(588, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1162 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_TRY);
}
#line 5776 "Zend/zend_language_scanner.c"
yy589:
		YYDEBUG(589, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy590;
		if (yych != 'i') goto yy150;
yy590:
		YYDEBUG(590, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy591;
		if (yych != 't') goto yy150;
yy591:
		YYDEBUG(591, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(592, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1282 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_TRAIT);
}
#line 5799 "Zend/zend_language_scanner.c"
yy593:
		YYDEBUG(593, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy594;
		if (yych != 'o') goto yy150;
yy594:
		YYDEBUG(594, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'W') goto yy595;
		if (yych != 'w') goto yy150;
yy595:
		YYDEBUG(595, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(596, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1174 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_THROW);
}
#line 5822 "Zend/zend_language_scanner.c"
yy597:
		YYDEBUG(597, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy598;
		if (yych != 'e') goto yy150;
yy598:
		YYDEBUG(598, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy599;
		if (yych != 'l') goto yy150;
yy599:
		YYDEBUG(599, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy600;
		if (yych != 'd') goto yy150;
yy600:
		YYDEBUG(600, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy149;
		}
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy601;
			if (yych <= '\n') goto yy602;
		} else {
			if (yych <= '\r') goto yy602;
			if (yych == ' ') goto yy602;
		}
yy601:
		YYDEBUG(601, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1158 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_YIELD);
}
#line 5859 "Zend/zend_language_scanner.c"
yy602:
		YYDEBUG(602, *YYCURSOR);
		++YYCURSOR;
		YYFILL(4);
		yych = *YYCURSOR;
		YYDEBUG(603, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych <= '\n') {
				if (yych <= 0x08) goto yy157;
				goto yy602;
			} else {
				if (yych == '\r') goto yy602;
				goto yy157;
			}
		} else {
			if (yych <= 'F') {
				if (yych <= ' ') goto yy602;
				if (yych <= 'E') goto yy157;
			} else {
				if (yych != 'f') goto yy157;
			}
		}
		YYDEBUG(604, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy605;
		if (yych != 'r') goto yy157;
yy605:
		YYDEBUG(605, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy606;
		if (yych != 'o') goto yy157;
yy606:
		YYDEBUG(606, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy607;
		if (yych != 'm') goto yy157;
yy607:
		YYDEBUG(607, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(608, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1154 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_YIELD_FROM);
}
#line 5905 "Zend/zend_language_scanner.c"
yy609:
		YYDEBUG(609, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych == 'Q') goto yy611;
			if (yych <= 'S') goto yy150;
		} else {
			if (yych <= 'q') {
				if (yych <= 'p') goto yy150;
				goto yy611;
			} else {
				if (yych != 't') goto yy150;
			}
		}
		YYDEBUG(610, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy623;
		if (yych == 'u') goto yy623;
		goto yy150;
yy611:
		YYDEBUG(611, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy612;
		if (yych != 'u') goto yy150;
yy612:
		YYDEBUG(612, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy613;
		if (yych != 'i') goto yy150;
yy613:
		YYDEBUG(613, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy614;
		if (yych != 'r') goto yy150;
yy614:
		YYDEBUG(614, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy615;
		if (yych != 'e') goto yy150;
yy615:
		YYDEBUG(615, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy149;
			} else {
				if (yych <= '@') goto yy616;
				if (yych <= 'Z') goto yy149;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy617;
			} else {
				if (yych <= 'z') goto yy149;
				if (yych >= 0x7F) goto yy149;
			}
		}
yy616:
		YYDEBUG(616, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1388 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_REQUIRE);
}
#line 5970 "Zend/zend_language_scanner.c"
yy617:
		YYDEBUG(617, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy618;
		if (yych != 'o') goto yy150;
yy618:
		YYDEBUG(618, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy619;
		if (yych != 'n') goto yy150;
yy619:
		YYDEBUG(619, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy620;
		if (yych != 'c') goto yy150;
yy620:
		YYDEBUG(620, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy621;
		if (yych != 'e') goto yy150;
yy621:
		YYDEBUG(621, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(622, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1392 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_REQUIRE_ONCE);
}
#line 6003 "Zend/zend_language_scanner.c"
yy623:
		YYDEBUG(623, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy624;
		if (yych != 'r') goto yy150;
yy624:
		YYDEBUG(624, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy625;
		if (yych != 'n') goto yy150;
yy625:
		YYDEBUG(625, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(626, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1150 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_RETURN);
}
#line 6026 "Zend/zend_language_scanner.c"
yy627:
		YYDEBUG(627, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych <= 'L') {
				if (yych <= 'K') goto yy150;
				goto yy650;
			} else {
				if (yych <= 'R') goto yy150;
				if (yych <= 'S') goto yy649;
				goto yy648;
			}
		} else {
			if (yych <= 'r') {
				if (yych == 'l') goto yy650;
				goto yy150;
			} else {
				if (yych <= 's') goto yy649;
				if (yych <= 't') goto yy648;
				goto yy150;
			}
		}
yy628:
		YYDEBUG(628, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych == 'A') goto yy640;
			if (yych <= 'N') goto yy150;
			goto yy641;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy150;
				goto yy640;
			} else {
				if (yych == 'o') goto yy641;
				goto yy150;
			}
		}
yy629:
		YYDEBUG(629, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy630;
		if (yych != 'n') goto yy150;
yy630:
		YYDEBUG(630, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych <= 'R') goto yy150;
			if (yych >= 'T') goto yy632;
		} else {
			if (yych <= 'r') goto yy150;
			if (yych <= 's') goto yy631;
			if (yych <= 't') goto yy632;
			goto yy150;
		}
yy631:
		YYDEBUG(631, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy638;
		if (yych == 't') goto yy638;
		goto yy150;
yy632:
		YYDEBUG(632, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy633;
		if (yych != 'i') goto yy150;
yy633:
		YYDEBUG(633, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy634;
		if (yych != 'n') goto yy150;
yy634:
		YYDEBUG(634, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy635;
		if (yych != 'u') goto yy150;
yy635:
		YYDEBUG(635, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy636;
		if (yych != 'e') goto yy150;
yy636:
		YYDEBUG(636, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(637, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1258 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_CONTINUE);
}
#line 6120 "Zend/zend_language_scanner.c"
yy638:
		YYDEBUG(638, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(639, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1146 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_CONST);
}
#line 6133 "Zend/zend_language_scanner.c"
yy640:
		YYDEBUG(640, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy645;
		if (yych == 's') goto yy645;
		goto yy150;
yy641:
		YYDEBUG(641, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy642;
		if (yych != 'n') goto yy150;
yy642:
		YYDEBUG(642, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy643;
		if (yych != 'e') goto yy150;
yy643:
		YYDEBUG(643, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(644, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1340 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_CLONE);
}
#line 6162 "Zend/zend_language_scanner.c"
yy645:
		YYDEBUG(645, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy646;
		if (yych != 's') goto yy150;
yy646:
		YYDEBUG(646, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(647, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1274 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_CLASS);
}
#line 6180 "Zend/zend_language_scanner.c"
yy648:
		YYDEBUG(648, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy659;
		if (yych == 'c') goto yy659;
		goto yy150;
yy649:
		YYDEBUG(649, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy657;
		if (yych == 'e') goto yy657;
		goto yy150;
yy650:
		YYDEBUG(650, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy651;
		if (yych != 'l') goto yy150;
yy651:
		YYDEBUG(651, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy652;
		if (yych != 'a') goto yy150;
yy652:
		YYDEBUG(652, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy653;
		if (yych != 'b') goto yy150;
yy653:
		YYDEBUG(653, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy654;
		if (yych != 'l') goto yy150;
yy654:
		YYDEBUG(654, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy655;
		if (yych != 'e') goto yy150;
yy655:
		YYDEBUG(655, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(656, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1464 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_CALLABLE);
}
#line 6230 "Zend/zend_language_scanner.c"
yy657:
		YYDEBUG(657, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(658, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1246 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_CASE);
}
#line 6243 "Zend/zend_language_scanner.c"
yy659:
		YYDEBUG(659, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy660;
		if (yych != 'h') goto yy150;
yy660:
		YYDEBUG(660, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(661, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1166 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_CATCH);
}
#line 6261 "Zend/zend_language_scanner.c"
yy662:
		YYDEBUG(662, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy679;
		if (yych == 'n') goto yy679;
		goto yy150;
yy663:
		YYDEBUG(663, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy672;
		if (yych == 'r') goto yy672;
		goto yy150;
yy664:
		YYDEBUG(664, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy665;
		if (yych != 'n') goto yy150;
yy665:
		YYDEBUG(665, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy666;
		if (yych != 'c') goto yy150;
yy666:
		YYDEBUG(666, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy667;
		if (yych != 't') goto yy150;
yy667:
		YYDEBUG(667, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy668;
		if (yych != 'i') goto yy150;
yy668:
		YYDEBUG(668, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy669;
		if (yych != 'o') goto yy150;
yy669:
		YYDEBUG(669, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy670;
		if (yych != 'n') goto yy150;
yy670:
		YYDEBUG(670, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(671, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1142 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_FUNCTION);
}
#line 6316 "Zend/zend_language_scanner.c"
yy672:
		YYDEBUG(672, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '@') {
				if (yych <= '/') goto yy673;
				if (yych <= '9') goto yy149;
			} else {
				if (yych == 'E') goto yy674;
				if (yych <= 'Z') goto yy149;
			}
		} else {
			if (yych <= 'd') {
				if (yych != '`') goto yy149;
			} else {
				if (yych <= 'e') goto yy674;
				if (yych <= 'z') goto yy149;
				if (yych >= 0x7F) goto yy149;
			}
		}
yy673:
		YYDEBUG(673, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1206 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_FOR);
}
#line 6344 "Zend/zend_language_scanner.c"
yy674:
		YYDEBUG(674, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy675;
		if (yych != 'a') goto yy150;
yy675:
		YYDEBUG(675, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy676;
		if (yych != 'c') goto yy150;
yy676:
		YYDEBUG(676, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy677;
		if (yych != 'h') goto yy150;
yy677:
		YYDEBUG(677, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(678, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1214 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_FOREACH);
}
#line 6372 "Zend/zend_language_scanner.c"
yy679:
		YYDEBUG(679, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy680;
		if (yych != 'a') goto yy150;
yy680:
		YYDEBUG(680, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy681;
		if (yych != 'l') goto yy150;
yy681:
		YYDEBUG(681, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '@') {
				if (yych <= '/') goto yy682;
				if (yych <= '9') goto yy149;
			} else {
				if (yych == 'L') goto yy683;
				if (yych <= 'Z') goto yy149;
			}
		} else {
			if (yych <= 'k') {
				if (yych != '`') goto yy149;
			} else {
				if (yych <= 'l') goto yy683;
				if (yych <= 'z') goto yy149;
				if (yych >= 0x7F) goto yy149;
			}
		}
yy682:
		YYDEBUG(682, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1432 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_FINAL);
}
#line 6410 "Zend/zend_language_scanner.c"
yy683:
		YYDEBUG(683, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy684;
		if (yych != 'y') goto yy150;
yy684:
		YYDEBUG(684, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(685, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1170 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_FINALLY);
}
#line 6428 "Zend/zend_language_scanner.c"
yy686:
		YYDEBUG(686, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'F') {
			if (yych == 'C') goto yy692;
			if (yych <= 'E') goto yy150;
			goto yy693;
		} else {
			if (yych <= 'c') {
				if (yych <= 'b') goto yy150;
				goto yy692;
			} else {
				if (yych == 'f') goto yy693;
				goto yy150;
			}
		}
yy687:
		YYDEBUG(687, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy690;
		if (yych == 'e') goto yy690;
		goto yy150;
yy688:
		YYDEBUG(688, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(689, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1202 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_DO);
}
#line 6463 "Zend/zend_language_scanner.c"
yy690:
		YYDEBUG(690, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(691, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1138 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_EXIT);
}
#line 6476 "Zend/zend_language_scanner.c"
yy692:
		YYDEBUG(692, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy699;
		if (yych == 'l') goto yy699;
		goto yy150;
yy693:
		YYDEBUG(693, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy694;
		if (yych != 'a') goto yy150;
yy694:
		YYDEBUG(694, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy695;
		if (yych != 'u') goto yy150;
yy695:
		YYDEBUG(695, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy696;
		if (yych != 'l') goto yy150;
yy696:
		YYDEBUG(696, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy697;
		if (yych != 't') goto yy150;
yy697:
		YYDEBUG(697, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(698, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1250 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_DEFAULT);
}
#line 6515 "Zend/zend_language_scanner.c"
yy699:
		YYDEBUG(699, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy700;
		if (yych != 'a') goto yy150;
yy700:
		YYDEBUG(700, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy701;
		if (yych != 'r') goto yy150;
yy701:
		YYDEBUG(701, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy702;
		if (yych != 'e') goto yy150;
yy702:
		YYDEBUG(702, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(703, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1222 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_DECLARE);
}
#line 6543 "Zend/zend_language_scanner.c"
yy704:
		YYDEBUG(704, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy766;
		if (yych == 'h') goto yy766;
		goto yy150;
yy705:
		YYDEBUG(705, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy760;
		if (yych == 's') goto yy760;
		goto yy150;
yy706:
		YYDEBUG(706, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy756;
		if (yych == 'p') goto yy756;
		goto yy150;
yy707:
		YYDEBUG(707, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy722;
		if (yych == 'd') goto yy722;
		goto yy150;
yy708:
		YYDEBUG(708, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy719;
		if (yych == 'a') goto yy719;
		goto yy150;
yy709:
		YYDEBUG(709, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych == 'I') goto yy710;
			if (yych <= 'S') goto yy150;
			goto yy711;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy150;
			} else {
				if (yych == 't') goto yy711;
				goto yy150;
			}
		}
yy710:
		YYDEBUG(710, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy717;
		if (yych == 't') goto yy717;
		goto yy150;
yy711:
		YYDEBUG(711, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy712;
		if (yych != 'e') goto yy150;
yy712:
		YYDEBUG(712, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy713;
		if (yych != 'n') goto yy150;
yy713:
		YYDEBUG(713, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy714;
		if (yych != 'd') goto yy150;
yy714:
		YYDEBUG(714, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy715;
		if (yych != 's') goto yy150;
yy715:
		YYDEBUG(715, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(716, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1286 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_EXTENDS);
}
#line 6627 "Zend/zend_language_scanner.c"
yy717:
		YYDEBUG(717, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(718, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1134 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_EXIT);
}
#line 6640 "Zend/zend_language_scanner.c"
yy719:
		YYDEBUG(719, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy720;
		if (yych != 'l') goto yy150;
yy720:
		YYDEBUG(720, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(721, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1376 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_EVAL);
}
#line 6658 "Zend/zend_language_scanner.c"
yy722:
		YYDEBUG(722, *YYCURSOR);
		yych = *++YYCURSOR;
		YYDEBUG(-1, yych);
		switch (yych) {
		case 'D':
		case 'd':	goto yy723;
		case 'F':
		case 'f':	goto yy724;
		case 'I':
		case 'i':	goto yy725;
		case 'S':
		case 's':	goto yy726;
		case 'W':
		case 'w':	goto yy727;
		default:	goto yy150;
		}
yy723:
		YYDEBUG(723, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy749;
		if (yych == 'e') goto yy749;
		goto yy150;
yy724:
		YYDEBUG(724, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy741;
		if (yych == 'o') goto yy741;
		goto yy150;
yy725:
		YYDEBUG(725, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy739;
		if (yych == 'f') goto yy739;
		goto yy150;
yy726:
		YYDEBUG(726, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'W') goto yy733;
		if (yych == 'w') goto yy733;
		goto yy150;
yy727:
		YYDEBUG(727, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy728;
		if (yych != 'h') goto yy150;
yy728:
		YYDEBUG(728, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy729;
		if (yych != 'i') goto yy150;
yy729:
		YYDEBUG(729, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy730;
		if (yych != 'l') goto yy150;
yy730:
		YYDEBUG(730, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy731;
		if (yych != 'e') goto yy150;
yy731:
		YYDEBUG(731, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(732, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1198 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ENDWHILE);
}
#line 6732 "Zend/zend_language_scanner.c"
yy733:
		YYDEBUG(733, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy734;
		if (yych != 'i') goto yy150;
yy734:
		YYDEBUG(734, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy735;
		if (yych != 't') goto yy150;
yy735:
		YYDEBUG(735, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy736;
		if (yych != 'c') goto yy150;
yy736:
		YYDEBUG(736, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy737;
		if (yych != 'h') goto yy150;
yy737:
		YYDEBUG(737, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(738, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1242 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ENDSWITCH);
}
#line 6765 "Zend/zend_language_scanner.c"
yy739:
		YYDEBUG(739, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(740, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1186 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ENDIF);
}
#line 6778 "Zend/zend_language_scanner.c"
yy741:
		YYDEBUG(741, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy742;
		if (yych != 'r') goto yy150;
yy742:
		YYDEBUG(742, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '@') {
				if (yych <= '/') goto yy743;
				if (yych <= '9') goto yy149;
			} else {
				if (yych == 'E') goto yy744;
				if (yych <= 'Z') goto yy149;
			}
		} else {
			if (yych <= 'd') {
				if (yych != '`') goto yy149;
			} else {
				if (yych <= 'e') goto yy744;
				if (yych <= 'z') goto yy149;
				if (yych >= 0x7F) goto yy149;
			}
		}
yy743:
		YYDEBUG(743, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1210 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ENDFOR);
}
#line 6811 "Zend/zend_language_scanner.c"
yy744:
		YYDEBUG(744, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy745;
		if (yych != 'a') goto yy150;
yy745:
		YYDEBUG(745, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy746;
		if (yych != 'c') goto yy150;
yy746:
		YYDEBUG(746, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy747;
		if (yych != 'h') goto yy150;
yy747:
		YYDEBUG(747, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(748, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1218 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ENDFOREACH);
}
#line 6839 "Zend/zend_language_scanner.c"
yy749:
		YYDEBUG(749, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy750;
		if (yych != 'c') goto yy150;
yy750:
		YYDEBUG(750, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy751;
		if (yych != 'l') goto yy150;
yy751:
		YYDEBUG(751, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy752;
		if (yych != 'a') goto yy150;
yy752:
		YYDEBUG(752, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy753;
		if (yych != 'r') goto yy150;
yy753:
		YYDEBUG(753, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy754;
		if (yych != 'e') goto yy150;
yy754:
		YYDEBUG(754, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(755, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1226 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ENDDECLARE);
}
#line 6877 "Zend/zend_language_scanner.c"
yy756:
		YYDEBUG(756, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy757;
		if (yych != 't') goto yy150;
yy757:
		YYDEBUG(757, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy758;
		if (yych != 'y') goto yy150;
yy758:
		YYDEBUG(758, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(759, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1416 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_EMPTY);
}
#line 6900 "Zend/zend_language_scanner.c"
yy760:
		YYDEBUG(760, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy761;
		if (yych != 'e') goto yy150;
yy761:
		YYDEBUG(761, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '@') {
				if (yych <= '/') goto yy762;
				if (yych <= '9') goto yy149;
			} else {
				if (yych == 'I') goto yy763;
				if (yych <= 'Z') goto yy149;
			}
		} else {
			if (yych <= 'h') {
				if (yych != '`') goto yy149;
			} else {
				if (yych <= 'i') goto yy763;
				if (yych <= 'z') goto yy149;
				if (yych >= 0x7F) goto yy149;
			}
		}
yy762:
		YYDEBUG(762, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1190 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ELSE);
}
#line 6933 "Zend/zend_language_scanner.c"
yy763:
		YYDEBUG(763, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy764;
		if (yych != 'f') goto yy150;
yy764:
		YYDEBUG(764, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(765, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1182 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ELSEIF);
}
#line 6951 "Zend/zend_language_scanner.c"
yy766:
		YYDEBUG(766, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy767;
		if (yych != 'o') goto yy150;
yy767:
		YYDEBUG(767, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy149;
		}
		YYDEBUG(768, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1266 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_ECHO);
}
#line 6969 "Zend/zend_language_scanner.c"
	}
/* *********************************** */
yyc_ST_LOOKING_FOR_PROPERTY:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128,   0,   0, 128,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,   0,   0,   0,   0,   0,   0, 
			  0,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,   0,   0,   0,   0,  64, 
			  0,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,   0,   0,   0,   0,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
		};
		YYDEBUG(769, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '-') {
			if (yych <= '\r') {
				if (yych <= 0x08) goto yy777;
				if (yych <= '\n') goto yy771;
				if (yych <= '\f') goto yy777;
			} else {
				if (yych == ' ') goto yy771;
				if (yych <= ',') goto yy777;
				goto yy773;
			}
		} else {
			if (yych <= '_') {
				if (yych <= '@') goto yy777;
				if (yych <= 'Z') goto yy775;
				if (yych <= '^') goto yy777;
				goto yy775;
			} else {
				if (yych <= '`') goto yy777;
				if (yych <= 'z') goto yy775;
				if (yych <= '~') goto yy777;
				goto yy775;
			}
		}
yy771:
		YYDEBUG(771, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy783;
yy772:
		YYDEBUG(772, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1299 "Zend/zend_language_scanner.l"
		{
	HANDLE_NEWLINES(yytext, yyleng);
	RETURN_TOKEN(T_WHITESPACE);
}
#line 7047 "Zend/zend_language_scanner.c"
yy773:
		YYDEBUG(773, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '>') goto yy780;
yy774:
		YYDEBUG(774, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1314 "Zend/zend_language_scanner.l"
		{
	yyless(0);
	yy_pop_state();
	goto restart;
}
#line 7061 "Zend/zend_language_scanner.c"
yy775:
		YYDEBUG(775, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy779;
yy776:
		YYDEBUG(776, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1308 "Zend/zend_language_scanner.l"
		{
	yy_pop_state();
	zend_copy_value(zendlval, yytext, yyleng);
	RETURN_TOKEN(T_STRING);
}
#line 7076 "Zend/zend_language_scanner.c"
yy777:
		YYDEBUG(777, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy774;
yy778:
		YYDEBUG(778, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy779:
		YYDEBUG(779, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy778;
		}
		goto yy776;
yy780:
		YYDEBUG(780, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(781, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1304 "Zend/zend_language_scanner.l"
		{
	RETURN_TOKEN(T_OBJECT_OPERATOR);
}
#line 7101 "Zend/zend_language_scanner.c"
yy782:
		YYDEBUG(782, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy783:
		YYDEBUG(783, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy782;
		}
		goto yy772;
	}
/* *********************************** */
yyc_ST_LOOKING_FOR_VARNAME:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(784, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy788;
			if (yych <= 'Z') goto yy786;
			if (yych <= '^') goto yy788;
		} else {
			if (yych <= '`') goto yy788;
			if (yych <= 'z') goto yy786;
			if (yych <= '~') goto yy788;
		}
yy786:
		YYDEBUG(786, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '_') {
			if (yych <= '@') {
				if (yych <= '/') goto yy787;
				if (yych <= '9') goto yy790;
			} else {
				if (yych <= '[') goto yy790;
				if (yych >= '_') goto yy790;
			}
		} else {
			if (yych <= '|') {
				if (yych <= '`') goto yy787;
				if (yych <= 'z') goto yy790;
			} else {
				if (yych != '~') goto yy790;
			}
		}
yy787:
		YYDEBUG(787, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1619 "Zend/zend_language_scanner.l"
		{
	yyless(0);
	yy_pop_state();
	yy_push_state(ST_IN_SCRIPTING);
	goto restart;
}
#line 7193 "Zend/zend_language_scanner.c"
yy788:
		YYDEBUG(788, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy787;
yy789:
		YYDEBUG(789, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy790:
		YYDEBUG(790, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy789;
		}
		if (yych == '[') goto yy792;
		if (yych == '}') goto yy792;
		YYDEBUG(791, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy787;
yy792:
		YYDEBUG(792, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(793, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1610 "Zend/zend_language_scanner.l"
		{
	yyless(yyleng - 1);
	zend_copy_value(zendlval, yytext, yyleng);
	yy_pop_state();
	yy_push_state(ST_IN_SCRIPTING);
	RETURN_TOKEN(T_STRING_VARNAME);
}
#line 7226 "Zend/zend_language_scanner.c"
	}
/* *********************************** */
yyc_ST_NOWDOC:
	YYDEBUG(794, *YYCURSOR);
	YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(796, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(797, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
#line 2338 "Zend/zend_language_scanner.l"
	{
	int newline = 0;

	zend_heredoc_label *heredoc_label = zend_ptr_stack_top(&SCNG(heredoc_label_stack));

	if (YYCURSOR > YYLIMIT) {
		RETURN_TOKEN(END);
	}

	YYCURSOR--;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				/* Check for ending label on the next line */
				if (IS_LABEL_START(*YYCURSOR) && heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, heredoc_label->label, heredoc_label->length)) {
					YYCTYPE *end = YYCURSOR + heredoc_label->length;

					if (*end == ';') {
						end++;
					}

					if (*end == '\n' || *end == '\r') {
						/* newline before label will be subtracted from returned text, but
						 * yyleng/yytext will include it, for zend_highlight/strip, tokenizer, etc. */
						if (YYCURSOR[-2] == '\r' && YYCURSOR[-1] == '\n') {
							newline = 2; /* Windows newline */
						} else {
							newline = 1;
						}

						CG(increment_lineno) = 1; /* For newline before label */
						BEGIN(ST_END_HEREDOC);

						goto nowdoc_scan_done;
					}
				}
				/* fall through */
			default:
				continue;
		}
	}

nowdoc_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	zend_copy_value(zendlval, yytext, yyleng - newline);
	HANDLE_NEWLINES(yytext, yyleng - newline);
	RETURN_TOKEN(T_ENCAPSED_AND_WHITESPACE);
}
#line 7293 "Zend/zend_language_scanner.c"
/* *********************************** */
yyc_ST_VAR_OFFSET:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			240, 240, 112, 112, 112, 112, 112, 112, 
			112, 112,   0,   0,   0,   0,   0,   0, 
			  0,  80,  80,  80,  80,  80,  80,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,   0,   0,   0,   0,  16, 
			  0,  80,  80,  80,  80,  80,  80,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,   0,   0,   0,   0,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
		};
		YYDEBUG(798, *YYCURSOR);
		YYFILL(3);
		yych = *YYCURSOR;
		if (yych <= '/') {
			if (yych <= ' ') {
				if (yych <= '\f') {
					if (yych <= 0x08) goto yy812;
					if (yych <= '\n') goto yy808;
					goto yy812;
				} else {
					if (yych <= '\r') goto yy808;
					if (yych <= 0x1F) goto yy812;
					goto yy808;
				}
			} else {
				if (yych <= '$') {
					if (yych <= '"') goto yy807;
					if (yych <= '#') goto yy808;
					goto yy803;
				} else {
					if (yych == '\'') goto yy808;
					goto yy807;
				}
			}
		} else {
			if (yych <= '\\') {
				if (yych <= '@') {
					if (yych <= '0') goto yy800;
					if (yych <= '9') goto yy802;
					goto yy807;
				} else {
					if (yych <= 'Z') goto yy810;
					if (yych <= '[') goto yy807;
					goto yy808;
				}
			} else {
				if (yych <= '_') {
					if (yych <= ']') goto yy805;
					if (yych <= '^') goto yy807;
					goto yy810;
				} else {
					if (yych <= '`') goto yy807;
					if (yych <= 'z') goto yy810;
					if (yych <= '~') goto yy807;
					goto yy810;
				}
			}
		}
yy800:
		YYDEBUG(800, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'W') {
			if (yych <= '9') {
				if (yych >= '0') goto yy824;
			} else {
				if (yych == 'B') goto yy821;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= 'X') goto yy823;
				if (yych >= 'b') goto yy821;
			} else {
				if (yych == 'x') goto yy823;
			}
		}
yy801:
		YYDEBUG(801, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1727 "Zend/zend_language_scanner.l"
		{ /* Offset could be treated as a long */
	if (yyleng < MAX_LENGTH_OF_LONG - 1 || (yyleng == MAX_LENGTH_OF_LONG - 1 && strcmp(yytext, long_min_digits) < 0)) {
		char *end;
		errno = 0;
		ZVAL_LONG(zendlval, ZEND_STRTOL(yytext, &end, 10));
		if (errno == ERANGE) {
			goto string;
		}
		ZEND_ASSERT(end == yytext + yyleng);
	} else {
string:
		ZVAL_STRINGL(zendlval, yytext, yyleng);
	}
	RETURN_TOKEN(T_NUM_STRING);
}
#line 7416 "Zend/zend_language_scanner.c"
yy802:
		YYDEBUG(802, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy820;
yy803:
		YYDEBUG(803, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '_') {
			if (yych <= '@') goto yy804;
			if (yych <= 'Z') goto yy816;
			if (yych >= '_') goto yy816;
		} else {
			if (yych <= '`') goto yy804;
			if (yych <= 'z') goto yy816;
			if (yych >= 0x7F) goto yy816;
		}
yy804:
		YYDEBUG(804, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1887 "Zend/zend_language_scanner.l"
		{
	/* Only '[' can be valid, but returning other tokens will allow a more explicit parse error */
	RETURN_TOKEN(yytext[0]);
}
#line 7441 "Zend/zend_language_scanner.c"
yy805:
		YYDEBUG(805, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(806, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1882 "Zend/zend_language_scanner.l"
		{
	yy_pop_state();
	RETURN_TOKEN(']');
}
#line 7452 "Zend/zend_language_scanner.c"
yy807:
		YYDEBUG(807, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy804;
yy808:
		YYDEBUG(808, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(809, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1892 "Zend/zend_language_scanner.l"
		{
	/* Invalid rule to return a more explicit parse error with proper line number */
	yyless(0);
	yy_pop_state();
	ZVAL_NULL(zendlval);
	RETURN_TOKEN(T_ENCAPSED_AND_WHITESPACE);
}
#line 7470 "Zend/zend_language_scanner.c"
yy810:
		YYDEBUG(810, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy815;
yy811:
		YYDEBUG(811, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1900 "Zend/zend_language_scanner.l"
		{
	zend_copy_value(zendlval, yytext, yyleng);
	RETURN_TOKEN(T_STRING);
}
#line 7484 "Zend/zend_language_scanner.c"
yy812:
		YYDEBUG(812, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(813, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2395 "Zend/zend_language_scanner.l"
		{
	if (YYCURSOR > YYLIMIT) {
		RETURN_TOKEN(END);
	}

	zend_error(E_COMPILE_WARNING,"Unexpected character in input:  '%c' (ASCII=%d) state=%d", yytext[0], yytext[0], YYSTATE);
	goto restart;
}
#line 7499 "Zend/zend_language_scanner.c"
yy814:
		YYDEBUG(814, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy815:
		YYDEBUG(815, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy814;
		}
		goto yy811;
yy816:
		YYDEBUG(816, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(817, *YYCURSOR);
		if (yych <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy816;
			} else {
				if (yych <= '@') goto yy818;
				if (yych <= 'Z') goto yy816;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy816;
			} else {
				if (yych <= 'z') goto yy816;
				if (yych >= 0x7F) goto yy816;
			}
		}
yy818:
		YYDEBUG(818, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1877 "Zend/zend_language_scanner.l"
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	RETURN_TOKEN(T_VARIABLE);
}
#line 7540 "Zend/zend_language_scanner.c"
yy819:
		YYDEBUG(819, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy820:
		YYDEBUG(820, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy819;
		}
		goto yy801;
yy821:
		YYDEBUG(821, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy829;
		}
yy822:
		YYDEBUG(822, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy801;
yy823:
		YYDEBUG(823, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy827;
		}
		goto yy822;
yy824:
		YYDEBUG(824, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(825, *YYCURSOR);
		if (yych <= '/') goto yy826;
		if (yych <= '9') goto yy824;
yy826:
		YYDEBUG(826, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1743 "Zend/zend_language_scanner.l"
		{ /* Offset must be treated as a string */
	ZVAL_STRINGL(zendlval, yytext, yyleng);
	RETURN_TOKEN(T_NUM_STRING);
}
#line 7585 "Zend/zend_language_scanner.c"
yy827:
		YYDEBUG(827, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(828, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy827;
		}
		goto yy826;
yy829:
		YYDEBUG(829, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(830, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy829;
		}
		goto yy826;
	}
}
#line 2404 "Zend/zend_language_scanner.l"

}
