/**
 *  Copyright 2009 Opera Software ASA. All rights reserved.
 *
 * This file contains Original Code and/or Contributions to the Original 
 * Code as defined in the Opera Web Applications License (the License). 
 * You may not use this file except in compliance with the License. Please 
 * obtain a copy of the License at http://www.opera.com/license/owal/
 * and read it before using this file. 
 *
 * The Original Code and all Contributions to the Original Code distributed 
 * under the License are distributed on an AS IS basis, WITHOUT WARRANTY 
 * OF ANY KIND, EITHER EXPRESS OR IMPLIED, AND OPERA HEREBY DISCLAIMS ALL 
 * SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF 
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT. 
 *
 * Please see the License for the specific language governing rights and 
 * limitations under the License.
 */
 
var g_StatusWidget = {};

window.languages = 
{
    'en' : 'locale/en.js'
};


function $(id) {return document.getElementById(id);}

window.onload = function()
{
	window.setLanguage('en', function(lang)
	{ 
		document.toLocale(); 
		main();	
	});	
}

/* 
 * The main function where the execution beings
 */
function main()
{
	g_StatusWidget.firstTimePage = new FirstTimePage();
	g_StatusWidget.firstStartValidate = new FirstStartValidate();
	g_StatusWidget.storedConfig = new StoredConfig();
	g_StatusWidget.mainScreen = new MainScreen();
	g_StatusWidget.settingsScreen = new SettingsScreen();
	g_StatusWidget.webService; 
	
	if(g_StatusWidget.storedConfig.apiKey == "")
	{
		g_StatusWidget.firstTimePage.show();
	}
	else
	{
		g_StatusWidget.webService = new Pingfm(g_StatusWidget.storedConfig.apiKey);
		g_StatusWidget.mainScreen.show();
	}
	
	//For adjusting Font-Size on qvga landscape mode:font size dosen't go below 10px or so 


}


function SettingsScreen()
{
	var btnSettingsDone = $("btnSettingsDone");	
	var btnUpdate = $("btnUpdate");
	var txtKeySettings = $("txtKeySettings");
	var settingsServices = $("settings_services");
	
	var panelPushingTo = $("panel_pushing_to");
	var settingsDoneWrapper = $("settings_done_wrapper");
	var settingsLabelValidating = $("settings_label_validating");
	var imgSettingsValidation = $("imgSettingsValidation");
	
	btnSettingsDone.onclick = btnSettingsDone_Click;
	btnUpdate.onclick = btnUpdate_Click;
	
	function showWelcomeScreen()
	{
		$("settings_page").style.display = "";
		g_StatusWidget.firstTimePage.show();
		g_StatusWidget.storedConfig.apiKey = "";
		widget.setPreferenceForKey("", "API_KEY");
		widget.setPreferenceForKey("", "USER_SERVICES");
	}
	
	function btnUpdate_Click(event)
	{
		//Incase there is an empty key. Clear the key and return to welcome screen.
		if(txtKeySettings.value == "")
		{
			showWelcomeScreen();
			return;
		}
		
		panelPushingTo.style.display = "none";
		settingsDoneWrapper.style.display = "none";
		settingsLabelValidating.style.display = "block";
		imgSettingsValidation.style.display = "inline-block";
		$("lblSettingsValidating").innerHTML = "Validating1".toLocale();		
		
		this.innerHTML = "cancel".toLocale();
		this.onclick = btnCancel_Click;
		
		var webService = new Pingfm(txtKeySettings.value);
		webService.validateUser(function(response)
		{
			if(response.status == "OK")
			{
				$("lblSettingsValidating").innerHTML = "Success".toLocale();
				widget.setPreferenceForKey(txtKeySettings.value, "API_KEY");
				g_StatusWidget.storedConfig.apiKey = txtKeySettings.value;
				g_StatusWidget.webService = webService;
				getServices();
			}
			else
			{
				$("lblSettingsValidating").innerHTML = "Failure".toLocale() + ": " + response.message;
				txtKeySettings.value = g_StatusWidget.storedConfig.apiKey;
				imgSettingsValidation.style.display = "none";
			}
			
			panelPushingTo.style.display = "";
			settingsDoneWrapper.style.display = "";
			imgSettingsValidation.style.display = "none";
			
			window.setTimeout(function()
			{
				settingsLabelValidating.style.display = "";	
			}, 1000 * 10);
			
			btnUpdate.innerHTML = "update".toLocale();
			btnUpdate.onclick = btnUpdate_Click;
		});
	}	
	
	function btnCancel_Click(event)	
	{
		panelPushingTo.style.display = "";
		settingsDoneWrapper.style.display = "";
		settingsLabelValidating.style.display = "";
		
		this.innerHTML = "update".toLocale();
		this.onclick = btnUpdate_Click;
	}
	
	function getServices()
	{
		g_StatusWidget.webService.getUserServices(function(response)
		{
			if(response.status == "OK")
			{
				widget.setPreferenceForKey( JSON.stringify(response), "USER_SERVICES");
				getServices_Complete(response);
			}
			
			if(response.status == "")
			{
				widget.setPreferenceForKey("", "USER_SERVICES");
				getServices_Complete(response);					
			}			
		});		
	}
	
	function showUserServices()
	{
		if(g_StatusWidget.storedConfig.userServices)
		{
			getServices_Complete(g_StatusWidget.storedConfig.userServices);
		}		
	}
	
	function getServices_Complete(response)
	{
		settingsServices.innerHTML = "";
		
		g_StatusWidget.storedConfig.userServices = response;
		
		var serviceCount = 0;
		for(var x = 0; x < response.services.length; x++)
		{
			if(response.services[x].methods.indexOf("status") == -1) continue;
			serviceCount++;
			var span = document.createElement("span");
			var img = document.createElement("img");
			img.src = response.services[x].icon;
			span.appendChild(img);
			span.appendChild(document.createTextNode(response.services[x].name));
			settingsServices.appendChild(span);
		}
		
		if(response.services.length == 0 || serviceCount == 0)
		{
			var a = document.createElement("a");
			a.href = "http://ping.fm/networks/";
			a.appendChild(document.createTextNode("add_network".toLocale()));
			settingsServices.appendChild(a);
		}
	
	}
	
	
	function btnSettingsDone_Click(event)
	{
		$("settings_page").style.display = "none";	
		$("header").style.display = "block";
		g_StatusWidget.mainScreen.show();
	}
	
	this.show = function()
	{
		txtKeySettings.value = g_StatusWidget.storedConfig.apiKey;
		$("settings_page").style.display = "block";	
		
		// Show user services from cache
		showUserServices();
		
		// Also get updated information from the server.
		getServices();
	}
}

function MainScreen()
{
	var btnReset = $("btnReset");
	var btnPublish = $("btnPublish");
	var btnSettings = $("btnSettings");
	var btnCancel = $("btnCancelPublish");
	var imgThrobber = $("imgThrobber");	
	
	var txtStatus = $("txtStatus");
	var lblChars = $("lblChars");
	var MAX_CHARACTERS = 140;
	
	btnReset.onclick = btnReset_Click;
	btnPublish.onclick = btnPublish_Click;
	btnCancel.onclick = btnCancel_Click;
	txtStatus.onkeyup = txtStatus_KeyUp;
	btnSettings.onclick = btnSettings_Click;
	
	function getServices(forceUpdate)
	{
		var userServices = g_StatusWidget.storedConfig.userServices;		
		
		if(userServices)
		{
			getServices_Complete(userServices);
		}
		else
		{
			g_StatusWidget.webService.getUserServices(function(response)
			{
				if(response.status == "OK")
				{
					widget.setPreferenceForKey( JSON.stringify(response), "USER_SERVICES");
					getServices_Complete(response);
				}
				
				if(response.status == "")
				{
					widget.setPreferenceForKey("", "USER_SERVICES");
					getServices_Complete(response);					
				}				
			});			
		}
		
	}
	
	function getServices_Complete(response)
	{
		var serviceIcons =  $("service_icons");
		serviceIcons.innerHTML = "";
		
		g_StatusWidget.storedConfig.userServices = response;
		var serviceCount = 0;		
		for(var x = 0; x < response.services.length; x++)
		{
			if(response.services[x].methods.indexOf("status") == -1) continue;
			serviceCount++;
			var span = document.createElement("span");
			var img = document.createElement("img");
			img.src = response.services[x].icon;
			span.appendChild(img);
			serviceIcons.appendChild(span);
		}
		
		if(response.services.length == 0 || serviceCount == 0)
		{
			var a = document.createElement("a");
			a.href = "http://ping.fm/networks/";
			a.appendChild(document.createTextNode("add_network".toLocale()));
			serviceIcons.appendChild(a);
		}
	}
	
	
	function btnSettings_Click(event)
	{
		$("main_screen").style.display = "none";
		$("header").style = "display :none;";
		$("settings_page").style = "position:absolute;top:0px;";
		g_StatusWidget.settingsScreen.show();
		btnSettings.style.display = "none";
	}
	
	function txtStatus_KeyUp(event)
	{
		
		lblChars.innerHTML = MAX_CHARACTERS - txtStatus.value.length;		
		if(txtStatus.value.length > MAX_CHARACTERS) lblChars.className = "error";
		else lblChars.className = "";		
	}
	
	function btnCancel_Click(event)
	{
		g_StatusWidget.webService.abort();
		txtStatus.disabled = false;
		btnPublish.style.display = "block";
		btnCancel.style.display = "none";
		btnReset.style.display = "block";		
	}
	
	function btnPublish_Click(event)
	{
		g_StatusWidget.webService.postStatus(txtStatus.value, function(response)
		{
			if (response.status == "OK") 
			{				
				txtStatus.value = "";
				lblChars.innerHTML = MAX_CHARACTERS;
				lblPublishStatus.innerHTML = "Published".toLocale();
				setTimeout(function(){
					lblPublishStatus.innerHTML = "";	
				}, 10000);
			}
			else
			{
				if(response.message) lblPublishStatus.innerHTML = response.message;
				else lblPublishStatus.innerHTML = "could_not_publish".toLocale();
			}
			txtStatus.disabled = false;
			btnPublish.style.display = "block";
			btnCancel.style.display = "none";
			btnReset.style.display = "block";
			imgThrobber.className = "";
			txtStatus.focus();
		});
		
		txtStatus.disabled = true;
		btnPublish.style.display = "none";
		btnCancel.style.display = "block";
		btnReset.style.display = "none";
		lblPublishStatus.innerHTML = "Publishing".toLocale();
		imgThrobber.className = "visible";
		
	}
	
	function btnReset_Click(event)
	{
		$("txtStatus").focus();
		txtStatus.value = "";
		lblChars.innerHTML = MAX_CHARACTERS;
	}
	
	this.show = function()
	{
		$("main_screen").style.display = "block";
		$("txtStatus").focus();
		btnSettings.style.display = "block";
		getServices();
	}	
}

function StoredConfig()
{
	this.apiKey 	  = widget.preferenceForKey("API_KEY");	
	this.userServices = null;
	if (widget.preferenceForKey("USER_SERVICES")) 
	{
		try 
		{
			this.userServices = JSON.parse(widget.preferenceForKey("USER_SERVICES"));
		} 
		catch(ex)
		{
			this.userServices =  null;
		}
	}
}

function FirstTimePage()
{
	var txtKey = $("txtKey");	
	var btnDone = $("btnDone");
	var pasteKey = "paste_key".toLocale();
	
	txtKey.onfocus = txtKey_Focus;
	txtKey.onblur = txtKey_LostFocus;
	btnDone.onclick = btnDone_Click;
	
	function btnDone_Click(event)
	{
		if (txtKey.value == "" || txtKey.value == pasteKey) 
		{
			txtKey.value = pasteKey;
			txtKey.className = "empty";
		}
		else
		{
			$("txtKeyValidating").value = txtKey.value;
			$("first_start_validating").style.display = "block";
			$("first_start").style.display = "";
			g_StatusWidget.firstStartValidate.validateUser();
		}
	}
	
	function txtKey_Focus(event)
	{
		if(this.className == "empty") 
		{
			this.className = "";
			this.value = "";
		}
	}
	
	function txtKey_LostFocus(event)
	{
		if(txtKey.value == "")
		{
			txtKey.value = pasteKey;
			txtKey.className = "empty";
		}
	}	
	
	this.show = function()
	{
		txtKey.value == pasteKey;
		txtKey.className = "empty";
		$("first_start").style.display = "block";
	}	
}

function FirstStartValidate()
{
	var btnCancel = $("btnCancel");	
	var imgValidation = $("imgValidation");
	btnCancel.onclick = btnCancel_Click;
	
	function btnCancel_Click(event)
	{
		
		$("txtKeyValidating").disabled = "";
		$("txtKeyValidating").focus();
		$("label_validating").style.display = "none";
		btnCancel.innerHTML = "Send".toLocale();
		btnCancel.onclick = btnSend_Click;
	}
	
	function btnSend_Click(event)
	{
		btnCancel.innerHTML = "cancel".toLocale();
		btnCancel.onclick = btnCancel_Click;
		$("label_validating").style.display = "";
		$("txtKeyValidating").disabled = true;
		$("lblValidating").innerHTML = "Validating1".toLocale();		
		g_StatusWidget.firstStartValidate.validateUser();
		imgValidation.style.display = "";
	}	
	
	this.validateUser = function()
	{
		g_StatusWidget.webService = new Pingfm($("txtKeyValidating").value);
		g_StatusWidget.webService.validateUser(function(response)
		{
			if(response.status == "OK")
			{
				$("lblValidating").innerHTML = "Success".toLocale();
				$("first_start_validating").style.display = "none";				
				g_StatusWidget.mainScreen.show();
				g_StatusWidget.storedConfig.apiKey = $("txtKeyValidating").value;
				widget.setPreferenceForKey($("txtKeyValidating").value, "API_KEY");
			}
			else
			{
				$("txtKeyValidating").disabled = "";
				$("txtKeyValidating").focus();
				btnCancel.innerHTML = "Send".toLocale();
				btnCancel.onclick = btnSend_Click;
				$("lblValidating").innerHTML = "Failure".toLocale();
				imgValidation.style.display = "none";
			}
		});
	}
}
