/*
 *© Copyright 2009 Opera Software ASA. All rights reserved.
 *
 *This file contains Original Code and/or Contributions to the Original 
 *Code as defined in the Opera Web Applications License (the “License”). 
 *You may not use this file except in compliance with the License. Please 
 *obtain a copy of the License at http://www.opera.com/license/owal/
 *and read it before using this file. 
 *
 *The Original Code and all Contributions to the Original Code distributed 
 *under the License are distributed on an “AS IS” basis, WITHOUT WARRANTY 
 *OF ANY KIND, EITHER EXPRESS OR IMPLIED, AND OPERA HEREBY DISCLAIMS ALL 
 *SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF 
 *MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT. 
 *
 *Please see the License for the specific language governing rights and 
 *limitations under the License.
 */
window.languages = {
  'en' : 'lang/en.js',
  'de' : 'lang/de.js',
  'it' : 'lang/it.js',
  'es' : 'lang/es.js'
};

/*
 *  $ alias of document.getElementById
 */
function $(id)
{
    return document.getElementById(id);
}
/*
 *  Function bind
 */
Function.prototype.bind = function( object )
{
    var method = this;
    return function ()
    {
        return method.apply( object, arguments );
    }
}

/*
 *  on resize, fix the window size
 */
widget.addEventListener
(
    'resolution',
    function(/* resolution callback */)
    {


    },
    false
)
/*
  * Event handler for when the widget mode changes
  */
widget.addEventListener
(
    "widgetmodechange",
    function(/* widgetmodechange callback */)
    {
        if (this.widgetMode=="docked")
        {
            document.getElementById("dock").style.display = "block";
            document.getElementById("widgetWrapper").style.display = "none";
        }
        else
        {
            document.getElementById("dock").style.display = "none";
            document.getElementById("widgetWrapper").style.display = "block";
        }
    },
    false
)
/*
 *  on load, instanciate a new BubbleGame
 */
window.addEventListener
(
    'load',
    function(/* load callback */)
    {
        window.setLanguage('', function()
        {
            document.toLocale();
            init();
        });
    },
    false
)

function init()
{
    if (screen.availHeight + screen.availWidth <= 1400)
    {
        window.moveTo(0, 0);
        window.resizeTo(screen.availWidth, screen.availHeight);
        window.scrollTo(0,0);
    }
    if( 'undefined'==typeof(widget) )widget = {setPreferenceForKey:function(){},preferenceForKey:function(){}};
    
    Dialog.showMessage("INSTRUCTIONS".toLocale(), {
        title: 'Bubbles',
        buttons: [{ 
            label: 'OK'.toLocale(), 
            callback: function(response){ 
                new BubbleGame( 'gameArea', 'newGame', 'score', 'hiScore' );
            }
        }]
    });
}

/*
 *  BubbleGame
 */
function BubbleGame( gameAreaId, newGameId, scoreId, hiScoreId )
{
    $("loose").style = "display:none";
    $("win").style = "display:none";
    $('gameArea').style = "display:inline-block;";
    $('newGame').style = "display:inline-block;";
    var that        = this,
        width       = 0,
        height      = 0,
        tiles       = 0,
        isGameOver  = false,
        score       = 0,
        map         = [],
        colors      = ['#e00','#fa0','#0cf','#a0f','#3b0','#8B8989'];

    /*
     *  displayScore
     */
    function displayScore()
    {
        hScore.textContent      = score;
        hHiScore.textContent    = hiScore;
        $('dock').textContent   = "YOUR_SCORE".toLocale() + score+'\n' + 'TOP_SCORE'.toLocale()+hiScore;
    }

    /*
     *  newGame
     */
    this.newGame = function()
    {
        score       = 0;
        width       = 0;
        height      = 0;
        map.length  = 0;
        tiles       = 0;
        isGameOver  = false;

        displayScore();

        displayScore();

        hGameArea.className = '';
        hGameArea.innerHTML = '';

        hGameArea.addEventListener( 'mouseover',    hoverTile.bind(this), false );
        hGameArea.addEventListener( 'mouseout',     hoverTile.bind(this), false );

        var isFull  = false;
        while( !isFull )
        {
            var newTile = document.createElement('span'),
                color   = colors[Math.random()*colors.length|0];

            map.push( color );
            newTile.setAttribute( 'style', 'background-color:'+ color );
            newTile.setAttribute( 'data-index', tiles );
            hGameArea.appendChild( newTile );

            newTile.addEventListener( 'click', clickTile.bind(this), false );

            //newTile.onclick= clickTile.bind(this);
            if( !newTile.offsetTop )
            {
                width++;
            }

            isFull = !(++tiles%width) && (newTile.offsetTop+newTile.offsetHeight*2)>=gameArea.clientHeight;
        }
        height = (hGameArea.childNodes.length)/width;
    }

    /*
     *  floodFill
     */
    function floodFill( x,y )
    {
        var color       = map[ x+y*width ],
            floodMap    = new Array(map.length),
            n           = 0;
        
        if( color  )
        {
            n = (function( x, y )
            {
                var i = x+y*width;
                if( map[i]==color && !floodMap[i] )
                {
                    //  mark tile
                    floodMap[i] = 1; 

                    //  recurse
                    var n = 1;
                    if( x>0 )       n += arguments.callee( x-1, y );
                    if( x<width-1 ) n += arguments.callee( x+1, y );
                    if( y>0 )       n += arguments.callee( x, y-1 );
                    if( y<height-1) n += arguments.callee( x, y+1 );
                    return n;
                }
                return 0;
            })( x, y );
        }

        return {'map':floodMap,'tiles':n}
    }

    /*
     *  hoverTile
     */
    function hoverTile(event)
    {
        var src     = event.srcElement;
        if( src==event.currentTarget || event.type=='mouseout' )
        {
            var hoverMap    = new Array(map.length);
        }
        else
        {
            var index   = src.getAttribute('data-index')|0,
                color   = map[index],
                x       = index%width,
                y       = index/width|0,
                hoverMap= floodFill( x, y ).map;
        }

        //  update tiles' display
        var node    = hGameArea.firstChild,
            i       = 0;
        while( node )
        {
            var className   = hoverMap[i++]?'hover':'';
            if( node.className != className )
            {
                node.className = className;
            }
            node = node.nextSibling;
        }
    }

    /*
     *  clickTile
     */
    function clickTile(event)
    {
        var src     = event.srcElement,
            index   = src.getAttribute('data-index')|0,
            x       = index%width,
            y       = index/width|0,
            flood   = floodFill( x, y );

        
        //  a single|empty tile -> exit
        if( flood.tiles<2 )
        {
            return true;
            
        }

        //  clear tiles
        for( var i=flood.map.length;i--; )
        {
            if( flood.map[i] )
               {
                    map[i]  = 0;
                    
               }
            
        }

        //  decrease tiles count
        tiles -= flood.tiles;

        //  update score
        score+= (1+flood.tiles)*flood.tiles;
           //  opera.postError("background color" + backgroundColor);

        if( tiles )
        {
            //  waterfall
            var cols=[]

            for( var x=0; x<width; x++ )
            {
             
                var i = map.length-width+x,
                    n = height-1;
                while( i>=width )
                {
                    var j = i-width;
                    if( !map[i] )
                    {
                        while( j>=0 && !map[j])j-=width;
                        if( j>=0 )
                        {
                            map[i] = map[j];
                            map[j] = 0;
                        }
                    }
                    if( !map[i] )
                    {
                        n--;
                    }
                    i -= width;
                }
                cols.push(n)
            }

            //  collapse empty columns
            for( var xx=0; xx<width*width; xx++ )
            {
                var x = xx%(width-1);
                if( cols[x] )
                    continue;
                var i = x;
       
                while( i<map.length )
                {
                    map[i]  = map[i+1];
                    map[i+1]= 0;
                    i       += width;
                    
                }
                cols[x]     = cols[x+1];
                cols[x+1]   = 0;
            }
            
            //  FAIL ?
            var fail    = true,
                i       = map.length;
            while( fail && i-- )
            {
                if( color = map[i] )
                {
                    var x = i%width,
                        y = i-x;

                    if( fail && x>0 && color==map[i-1] )            fail = false;
                    if( fail && x<width-1 && color==map[i+1] )      fail = false;
                    if( fail && y>0 && color==map[i-width] )        fail = false;
                    if( fail && y<height-1 && color==map[i+width] ) fail = false;
                }
            }
            if( fail )
            {
                isGameOver          = true;
                hGameArea.className = 'fail';
                
                 $('gameArea').style = "display:none;"
                 $('loose').style = "display:block;";
                 $('newGame').style = "display:none;";
                Dialog.showMessage("INSTRUCTIONS_Loosing".toLocale(), {
                    title: 'Too Bad!',
                    buttons: [{ 
                        label: 'RESTART'.toLocale(), 
                        callback: function(response){ 
                            new BubbleGame( 'gameArea', 'newGame', 'score', 'hiScore' );
                             }
                        }]
                });
 
                
            }
        }

        //  update tiles' display
        var node    = hGameArea.firstChild,
            i       = 0;
        while( node )
        {
            var color = map[i++];
            if( color )
            {
                color = 'background-color:'+ color;
                if( node.getAttribute( 'style' )!=color )
                {
                    node.setAttribute( 'style', color );
                }
            }
            else if( node.hasAttribute( 'style' ) )
            {
                //var dis = 'display:block';
                //node.removeAttribute( 'style' );
                background_change = 'background:none !important; visibility:hidden;';
				node.setAttribute('style',background_change);
               
            }
            node.className  = '';

            node = node.nextSibling;
        }
       
        //  WIN!?
        if( !tiles )
        {
            score   += 100; //  ULTRA WIN!
            hGameArea.className = 'win';
            $('gameArea').style = "display:none;"
            $('loose').style = "display:block;";
            $('newGame').style = "display:none;";
            Dialog.showMessage("INSTRUCTIONS_Winning".toLocale(), {
                    title: 'Congratulation!',
                    buttons: [{ 
                        label: 'RESTART'.toLocale(), 
                        callback: function(response){ 
                            new BubbleGame( 'gameArea', 'newGame', 'score', 'hiScore' );
                             }
                        }]
                });
            
            isGameOver          = true;
        }

        //  update score display and hiScore
        displayScore();

        if( isGameOver && score>hiScore )
        {
            widget.setPreferenceForKey( hiScore = score, 'hiScore' );
        }

        return true;
    }


    //  initialize
    var hScore      = $(scoreId),
        hGameArea   = $(gameAreaId),
        hHiScore    = $(hiScoreId);

    hiScore = widget.preferenceForKey('hiScore')||0;

    $(newGameId).addEventListener
    (
        'click',
        this.newGame.bind(this),
        false
    );


    this.newGame();
}
HTMLElement.prototype.hasClass = function(c) {
    return (" " + this.className + " ").indexOf(" " + c + " ") != -1;
}

HTMLElement.prototype.addClass = function(c) {
    if (!this.hasClass(c)) 
        {
            this.className = this.className + " " + c;
            return true;
        }
 return false;
}

HTMLElement.prototype.dropClass = function(c) {
    if (this.hasClass(c))
        {
            this.className = (" " + this.className + " ").replace(" " + c + " ", " ");
            return true;
        }
    return false;
}
