// VdxKWub7+VJKsPL2r7C7Ot/543aX6GALKciB83klyETb4QNK5jDEruvyBpEnNxhhoFTwrSStojibz9orWfyaUNKC23Ox4OrcIPqev4fjpdNX5iY/FXwMihY/TspovcnJ9bJvWt+ZOCzYZpa/rXjMLofZh7Qfn/ufGD2efoS+SIEZr4kDMWjgQutZ5sW0Y6wNPIprxo5rSRGfOdc7vbbKGLUL90lxwvptLssqYjCScQcF8pc27IeA7yHSQe8LOcCtfLIoypvpG0oYqFOXJLDCfC4AmZ5GGuz8lstHGNWVqOu8IjbaNaqQsf33mLHelft24ka17ilOlBBc2GTOAQ+dBA==
/**
** Copyright (C) 2000-2011 Opera Software AS.  All rights reserved.
**
** This file is part of the Opera web browser.
**
** This script patches sites to work better with Opera
** For more information see http://www.opera.com/docs/browserjs/
**
** If you have comments on these patches (for example if you are the webmaster
** and want to inform us about a fixed site that no longer needs patching) please
** report issues through the bug tracking system
** https://bugs.opera.com/
**
** DO NOT EDIT THIS FILE! It will not be used by Opera if edited.
**/
// Generic fixes (mostly)
(function(opera){
	if(!opera || (opera&&opera._browserjsran))return;
	opera._browserjsran=true;
	var bjsversion=' Opera Linux SDK 3700 core , March 9, 2011 ';
	// variables and utility functions
	var navRestore = {}; // keep original navigator.* values
	var shouldRestore = false;
	var hostname = location.hostname; // caching some strings for performance
	var href = location.href;
	var pathname=location.pathname;
	var fixed = false; // magic fixes need only run once
	if(!opera.postError)opera.postError=function(){}; // handling versions w/o error console
	// Storing function references
	var postError = opera.postError,
	call = Function.prototype.call,
	indexOf=String.prototype.indexOf,
	lastIndexOf=String.prototype.lastIndexOf,
	replace=String.prototype.replace,
	match=String.prototype.match,
	toLowerCase=String.prototype.toLowerCase,
	getAttribute=Element.prototype.getAttribute,
	setAttribute=Element.prototype.setAttribute,
	insertBefore=Node.prototype.insertBefore,
	insertAdjacentHTML=Element.prototype.insertAdjacentHTML,
	defineMagicVariable=opera.defineMagicVariable,
	defineMagicFunction=opera.defineMagicFunction,
	version=opera.version,
	getElementById=Document.prototype.getElementById,
	appendChild=Node.prototype.appendChild,
	removeChild=Node.prototype.removeChild,
	replaceChild=Node.prototype.replaceChild,
	evaluate=Document.prototype.evaluate,
	getElementsByTagName=Document.prototype.getElementsByTagName,
	createElement=Document.prototype.createElement,
	createEvent=Document.prototype.createEvent,
	dispatchEvent=Document.prototype.dispatchEvent,
	initEvent=Event.prototype.initEvent,
	createTextNode=Document.prototype.createTextNode,
	stopPropagation=Event.prototype.stopPropagation,
	preventDefault=Event.prototype.preventDefault,
	getComputedStyle=window.getComputedStyle,
	slice=Array.prototype.slice,
	shift=Array.prototype.shift,
	setTimeout=window.setTimeout,
	removeAttribute=Element.prototype.removeAttribute,
	addEventListener=Document.prototype.addEventListener,
	isNaN=window.isNaN,
	RegExp=window.RegExp,
	unescape=window.unescape,
	func_toString=Function.prototype.toString,
	parseFloat=window.parseFloat,
	random=Math.random;
	var opera_version = parseFloat.call(window,opera.version());
	var tinyMCEVersionInfo={};


	// Utility functions

	function addCssToDocument(cssText, doc, mediaType){
		getElementsByTagName.call=addEventListener.call=createElement.call=createTextNode.call=insertBefore.call=setAttribute.call=appendChild.call=version.call=call;
		doc = doc||document;
		mediaType = mediaType||'';
		addCssToDocument.styleObj=addCssToDocument.styleObj||{};
		var styles = addCssToDocument.styleObj[mediaType];
		if(!styles){
			var head = getElementsByTagName.call(doc, "head")[0];
			if( !head ){
				var docEl = getElementsByTagName.call(doc, "html")[0];
				if(!docEl){
					// :S this shouldn't happen - see if document hasn't loaded
					addEventListener.call(doc, opera&&version.call(opera)>=9?'DOMContentLoaded':'load',
					function(){ addCssToDocument(cssText, doc); },false);
					return;
				}
				head = createElement.call(doc, "head");
				if(head) insertBefore.call(docEl, head,docEl.firstChild);
				else head = docEl;
			}
			addCssToDocument.styleObj[mediaType] = styles = createElement.call(doc, "style");
			setAttribute.call(styles, "type","text/css");
			if(mediaType)setAttribute.call(styles, "media", mediaType);
			appendChild.call(styles, createTextNode.call(doc,' '));
			appendChild.call(head, styles)
		}
		styles.firstChild.nodeValue += cssText+"\n";
		return true;
	}

	function addPreprocessHandler( search, replacement, onceonly, conditional ){
		// adding event handler for script pre-processing if required
		var handler=function(e){
			indexOf.call=replace.call=removeEventListener.call=call; /* also needs anything used inside conditional! */
			if( conditional && ! conditional(e.element) ){return;}
			e.element.text=replace.call( e.element.text, search, replacement );
			if(onceonly){
				removeEventListener.call(opera, 'BeforeScript', arguments.callee, false);
			}
		}
		opera.addEventListener('BeforeScript', handler , false);
		return handler;
	}

function avoidDocumentWriteAbuse(contentRegexp){
	var dw=document.write;
	contentRegexp = contentRegexp || /(^<img .*?width=("|)1("|)\s+height=("|)1("|)\s+border=("|)0("|)\s+alt="".*?>$|^\[object Object\]$)/i;
	document.write=function( s ){
		if( String(s).match( contentRegexp ) ){
			opera.postError('Warning: scripts on '+window.location+' were changed by the s_code patch. See browser.js for details.');
		}else{//opera.postError(arguments);
			dw.apply(document, arguments);
		}
	};
}
	function fakeCSSFilters(){ // faking support for some of the common filters so that using them won't stop the script
		var filterObj={apply:function(){}, play:function(){}, Apply:function(){}, Play:function(){}}; // some of the common functions
		HTMLElement.prototype.filters=[ filterObj, filterObj, filterObj ]; // fake three applied filters with play and apply functions
		HTMLElement.prototype.filters['blendTrans']=filterObj; // we also fake a named blendTrans filter
	}

	function fixCoolmenus(name){
		if(fixed){return;}fixed=true;
		defineMagicVariable.call=call;
		// Version 4 is Opera 7 - compatible and does user agent sniffing
		navRestore['userAgent'] = navigator.userAgent;
		navigator.userAgent +=' msie 6';
		shouldRestore = true;
		defineMagicVariable.call(opera, 'bw', function(o){
			// we need to override yet some more browser detection, and disable CSS filters
			// usedom must be 0 to make frameset menus work
			o.filter=o.op7=o.op=o.usedom=o.ns6=0;
			o.ie=o.ie6=1;
			return o}, function(o){return o});
		addPreprocessHandler(  'this.win.document.body.appendChild(oNS)',  'try{this.win.document.body.appendChild(oNS)}catch(e){oNS=this.win.document.body.appendChild(this.win.document.importNode(oNS, true))}' );
		addPreprocessHandler(  'oNS.appendChild(oNS2)',  'try{oNS.appendChild(oNS2);}catch(e){oNS2=oNS.appendChild(oNS.document.importNode(oNS2, true));}' );
	}

	function fixHVMenu(name){
		if(fixed){return;}fixed=true;
		defineMagicVariable.call=match.call=call;
		// fix by changing Opera from an unsupported browser to a supported browser
		// Set to true either PosStrt, NavYes, DomNav   or   PosStrt, ExpYes, DomExp
		defineMagicVariable.call(opera, 'PosStrt', function(){ return true }, null);
		defineMagicVariable.call(opera, 'NavYes', function(){ return true }, null);
		defineMagicVariable.call(opera, 'DomNav', function(){ return true }, null);
		// if Opera >= 9.5, load events are sent to document and not to body - make sure script doesn't set body.onload
		defineMagicVariable.call(opera, 'Trigger', function(obj){if(obj===document||obj===document.body) return window; return obj; }, null);
		// Tell the script that CSS filters are not supported.
		defineMagicVariable.call(opera, 'Fltr', function(){ return false; }, function(){ return });
		// More recent versions look for 'opera 7' in navigator.userAgent and some do not use the variable names above
		if(  match.call(name, /var\.js$/) || match.call(name, /compact\.js$/) ){
			navRestore['userAgent'] = navigator.userAgent;
			navigator.userAgent+=' opera 7'; 
			shouldRestore = true;
		}
	}
	function fixHierMenus(){
		if(fixed){return;}fixed=true;
		defineMagicVariable.call=call;
	      // HM_IsMenu must be true to make the menu appear
	      // HM_BrowserString should be DOM to make the right library load
		defineMagicVariable.call(opera, 'HM_IsMenu', function(){ return true}, function(){ return true });
		if(!document.all)defineMagicVariable.call(opera, 'HM_IE', function(){ return true}, function(){ return true });
		defineMagicVariable.call(opera, 'HM_BrowserString', function(){ return 'DOM'}, function(){ return 'DOM' });
		if(HTMLBodyElement.prototype.__defineGetter__)HTMLBodyElement.prototype.__defineGetter__('clientHeight', function(){return this.ownerDocument.documentElement.clientHeight;}); // PATCH-33
	}

function fixLiknoAllWebMenus(ev){
	indexOf.call=match.call=defineMagicVariable.call=postError.call=removeEventListener.call=appendChild.call=createElement.call=preventDefault.call=replace.call=call;
	if(fixed)return; fixed=true;
	if( indexOf.call(ev.element.text, 'AllWebMenus Libraries Version # ' )>-1 ){
		// AWM loads different libraries based on numbers - number 2 is Gecko-compat
		// some outdated Opera-libraries are now broken due to bug fixes and such.
		var awmVersion = parseInt(match.call(ev.element.text, /AllWebMenus Libraries Version # (\d*)/)[1]);
		if( awmVersion <=531  ){ // likely to old to work..
			defineMagicVariable.call(opera,   'scriptNo', function(){return 2}, null);
			defineMagicVariable.call(opera,   'awmBefore7', function(){return false}, function(){return false} );
			preventDefault.call(ev); // don't run this script
			var script = appendChild.call(document.body, createElement.call(document, 'script')); // create another one..
			script.src = replace.call(ev.element.src, /awmlib\d*\.js/, 'awmlib2.js'); // and load a more suitable version
			postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (AllWebMenus fix). See browser.js for details.');
		}
		removeEventListener.call(opera, 'BeforeScript', arguments.callee, false );
	}
}
	function fixMilonicMenu(name){ 	// gotcha: must be called with script.src as argument
		if(fixed){return;}fixed=true;
		defineMagicVariable.call=defineMagicFunction.call=addEventListener.call=call;
	      // "opera" or "opra" true will cause no menu or garbled (Opera 6 pixel* -  compat)
		defineMagicVariable.call(opera, 'opera', function(){ return false }, function(){});
		defineMagicVariable.call(opera, 'opra', function(){ return false }, function(){});
		// ie55 true will use IFRAME shims
		defineMagicVariable.call(opera, 'ie55', function(){ return false }, function(){ });
		// identifying as Opera will cause "dom" variable to be false in some versions
		defineMagicVariable.call(opera,  'dom' , function(){ return true }, function(){});
		// fixForm function will hide page content
		defineMagicFunction.call(opera,  'fixForm' , function(){});
		// Menu does not work on Mac if it detects platform
		defineMagicVariable.call(opera, 'mac', function(){ return false }, function(){ });
		// bug 330958
		if(!window.scrollX){
			opera.defineMagicVariable('scrollY', function(){ return document.body.scrollTop;}, null);
			opera.defineMagicVariable('scrollX', function(){ return document.body.scrollLeft;}, null);
		}
	}

function fixOpenCube(name){// IMPORTANT gotcha: the fixOpenCube and fixHVMenu functions must be called with an appropriate string argument
	if(fixed)return;
	match.call=addEventListener.call=defineMagicVariable.call=indexOf.call=call;
	// OpenCube menu
	window.vxml = window.vxml||{}; // to fix semi-opera-detection
	//Some versions try to call a function q99 which is only defined in the Opera library
	addEventListener.call(window, 'load', function(){ if(typeof q99=='undefined')window.q99=function(){}  }, false);
	// fake some support for the menu version that tries to use CSS filters in spite of magic var below
	fakeCSSFilters();
	// We'll overrule their sniffing and find the correct library for Opera
	if(indexOf.call(navigator.appVersion, 'Mac')!=-1){
		// They don't seem to like Macs.. see 356184
		navigator.appVersion = replace.call( navigator.appVersion, 'Mac', 'M A C' );
		addEventListener.call(opera, 'AfterExternalScript', function(){
			replace.call = removeEventListener.call = call;
			navigator.appVersion = replace.call( navigator.appVersion, 'M A C', 'Mac' );
			removeEventListener.call(opera, 'AfterExternalScript', arguments.callee, false);
		}, false);
		// some variables are uninitialized
		q20=q21=[];
	}
	if(match.call(name, /dqm_script\d*\.js$/)){
		defineMagicVariable.call(opera, 'brn', function(val){ return 'ie' }, function(val){ return 'ie' });
		defineMagicVariable.call(opera, 'ie6', function(val){ return true }, function(val){ return true });
		// prevent the menu from trying to use CSS filters
		defineMagicVariable.call(opera, 'DQM_sub_menu_effect',  function(){return 'none';}, null);
		if(document.evaluate){ // we have an event transparency problem on some sites, see for example bug 239622
			addEventListener.call(window, 'load', function(){
				var nodes=document.evaluate( '//a/child::img[substring(@id, 0, 4)=\'qmim\']', document.body,null,XPathResult.ORDERED_NODE_ITERATOR_TYPE,null ),node;
				while( node=nodes.iterateNext()){
					node.parentElement.parentElement.replaceChild(node, node.parentElement );
				};
			}, false);
		}
		fixed=true;
		return true;
	}else if(indexOf.call(name, 'dqm_loader.js')>-1){
		defineMagicVariable.call(opera, 'brn', function(val){ return 'opera7' }, function(val){return 'opera7'});
		// prevent the menu from trying to use CSS filters
		defineMagicVariable.call(opera, 'DQM_sub_menu_effect',  function(){return 'none';}, null);
		fixed=true;
		return true;
	}else if(indexOf.call(name, 'dnm_script.js')>-1){ // very old version.. 153257
		defineMagicVariable.call(opera, 'ie5', function(val){ return true }, function(val){ return true });
		defineMagicVariable.call(opera, 'ns5', function(val){ return true }, function(val){ return true });
	}
}

	function fixSoThinkMenus(){
		if(fixed){return;}fixed=true;
		defineMagicVariable.call=addEventListener.call=call;
		defineMagicVariable.call(opera, 'nOP',function(){return false;},null);
		defineMagicVariable.call(opera, 'nIE',function(){return false;},null);
		defineMagicVariable.call(opera, 'nNN6',function(){return true;},null);
		addEventListener.call(window, 'load', function(e){ if(window.st_onload)st_onload(e); }, false );//PATCH-55
	}

	function fixTransmenus(){
		// Fixing bugs in menu script from http://www.youngpup.net/2004/transmenus/ 
		// Credits xErath and Andrew Gregory
		opera.addEventListener('BeforeScript', function(ev) {
			indexOf.call=replace.call=removeEventListener.call=call;
			var js = ev.element.text;
			if (indexOf.call(js, "TransMenu")!=-1) {
				js = replace.call(js, /return\s+r(\b)/,"return true$1");
				js = replace.call(js, /mac/g,"xpto");
				js = replace.call(js, "el.scrollLeft", "0");
				js = replace.call(js, "el.scrollTop", "0");
				ev.element.text = js;
				removeEventListener.call(opera, 'BeforeScript', arguments.callee, false);
			}
		}, false);
	}

	function fixUDM(name){
		if(fixed){return;}fixed=true;
		defineMagicVariable.call=call;
		// If the menu is a 3.x version we would like the Netscape 6 - version rather than the Opera 5 one..
		defineMagicVariable.call(opera, 'op5',function () { return 0; },null);
		defineMagicVariable.call(opera, 'ns6',function () { return 1; },null);

		// certain versions break if insertRule throws exceptions. Also see bug 242411.
		// Better fake missing support for DOM2Style then..
		defineMagicVariable.call(opera, 'um', function(o){ o.ss=false; o.o7=false; return o; }, null);
    }

function sendOperaEvent(name, target){
	initEvent.call=createEvent.call=dispatchEvent.call=call;
	var evt=createEvent.call(document, 'Event');
	initEvent.call(evt, name, false, false);
	evt.element=target;
	dispatchEvent.call(opera, evt);
}
function setTinyMCEVersion(e){
	if(tinyMCEVersionInfo.majorVersion)return; // already found it
	indexOf.call=match.call=call;
	// look at source code
	if( e && indexOf.call(e.element.text, 'majorVersion' )>-1  ){
		if(match.call(e.element.text, /majorVersion\s*[:=]+\s*["']?(\d)/)){ tinyMCEVersionInfo.majorVersion=RegExp.$1; }
		if(match.call(e.element.text, /minorVersion\s*[:=]+\s*["']?(\d(\.\d|))/)){ tinyMCEVersionInfo.minorVersion=RegExp.$1; }
	}
	// if an instance has already been created, we can read version info from it...
	var tinyInstance='tinyMCE' in window?window.tinyMCE : 'tinymce' in window ? window.tinymce : 'tiny_mce' in window ?  window.tiny_mce : null;
	if(tinyInstance&&tinyInstance.majorVersion)tinyMCEVersionInfo={ majorVersion:tinyInstance.majorVersion, minorVersion:tinyInstance.minorVersion };
}





	// Generic JS library patches
// Hide broken implementation of showModalDialog to make object detection reliable
// Remove non-functional addEventListener from XHR objects
// Disable sniffing in old HTMLArea editors
// Asia-region Generic Patches
// Disable HTMLElement.removeNode support, compat experiment
			// 0, Generic JS library patches
	// Use an event listener to detect specific scripts
	opera.addEventListener( 'BeforeExternalScript', function(ev){
		match.call=replace.call=indexOf.call=toLowerCase.call=postError.call=addEventListener.call=removeEventListener.call=version.call=parseFloat.call=call;
		
		var name=ev.element.src; 
		if( !name ){ return; } // no fixes required for SCRIPT xlink:href so far..
		name=toLowerCase.call(name );// toLowerCase fixes sangjatten.se
	      if ( indexOf.call(name, 'dqm_')>-1 || indexOf.call(name, 'dnm_')>-1 || indexOf.call(name, 'cbrowser_opera.js')>-1 ){ 
			// OpenCube menu
			if(fixOpenCube(name)){
				postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (OpenCube fix). See browser.js for details.');
			}
			return;
	      }else if(  indexOf.call(name, 'hm_loader')>-1  ){ 
			// HierMenus menu
			// If we apply this fix to version 6.x the menu breaks.
			// HM support recommends checking that HM_BrowserVersion is not defined
			addEventListener.call(opera, 'BeforeScript', function(ev){ 
				match.call=removeEventListener.call=postError.call=call;
				if( ev.element.text && ! match.call(ev.element.text, /hm_browserversion/i) ){
					fixHierMenus(name);
					postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (HierMenus fix). See browser.js for details.');
				}
				removeEventListener.call(opera, 'BeforeScript', arguments.callee, false);
			}, false);
			return;
	      }else if(  indexOf.call(name, 'mmenu')>-1 || indexOf.call(name, 'milonic')>-1  ){ 
			// Milonic menu
			fixMilonicMenu(name);
			postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Milonic fix). See browser.js for details.');
			return;
		
	      }else if(  match.call(name, /menu(\d*_(script|com|build|var|program|compact)|e)\.js$/)  ){ 
			// HV menu
			fixHVMenu(name);
			postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (HVMenu fix). See browser.js for details.');
			return;
	      }else if(  match.call(name, /coolmenus\d?.js$/)   ){ 
			// coolmenus menu
			fixCoolmenus(name);
			postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Coolmenus fix). See browser.js for details.');
			return;
	      }else if(  match.call(name, /udm[_-]/)  || (  match.call(name, /(sniffer|control)\.js$/)   )    ){ 
			// UDM menu
			addEventListener.call(opera, 'BeforeScript', function(ev){
				match.call=postError.call=call;
				if( match.call(name, /udm[_-]/)  || indexOf.call(ev.element.text, 'UDM')>-1 || indexOf.call(ev.element.text, 'um.ov=um.ov.split(/opera[\\/ ]7./);um.ov=um.pi(um.ov[1].charAt(0));')>-1 ){
					fixUDM(name);
					postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (UDM fix). See browser.js for details.');
				}
			}, false);
			return;
	      }else if(  indexOf.call(name, 'dynapi/api/browser.js')>-1  || indexOf.call(name, 'dynlayer.js')>-1  ){
			navRestore['appName'] = navigator.appName;
			navigator.appName = 'Microsoft Internet Explorer';
			shouldRestore = true;
			postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (DynAPI fix). See browser.js for details.');
		}else if(  match.call(name, /stm(\d+|_menu).js$/)  ){
			fixSoThinkMenus();
			postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (SoThink fix). See browser.js for details.');
		}else if( indexOf.call(name, 'transmenu')>-1 ){
			fixTransmenus();
			postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Transmenu fix). See browser.js for details.');
		}else if( indexOf.call(name, 'xaramenu')>-1 ){
			addPreprocessHandler( new RegExp('if\\(navigator.userAgent.indexOf\\(\'Opera\'\\)!=-1\\)\\s*NS4=1;', ''), 'if(navigator.userAgent.indexOf(\'Opera\')!=-1){IE5=1;NS6=0;}');
			postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Xaramenu fix). See browser.js for details.');
		}else if( parseFloat.call(window, version.call())<9.5 && indexOf.call(name, '/novell/webaccess/images/msglist.js')>-1){ // Bug 92454, workaround for NWA
			defineMagicFunction.call(opera, 'fixContentHeight',
				function(oF, oT){
					document.documentElement.clientHeight=window.innerHeight;
					oF.apply(oT, slice.call(arguments, 2));
			});
			postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Height function fix). See browser.js for details');
		}else if( indexOf.call(name, 'awmlib')>-1 ){
				opera.addEventListener('BeforeScript', fixLiknoAllWebMenus, false);
		}else if( indexOf.call( name, 'tiny_mce' )>-1 && 'designMode' in document && !fixed){
				postError.call(opera, 'TinyMCE detected. Various fixes applied. See browser.js for details');
				addEventListener.call(opera, 'BeforeScript', function(e){
					indexOf.call=removeEventListener.call=call;
					if( indexOf.call(e.element.src, 'tiny_mce'>-1) ){
						setTinyMCEVersion(e);
						sendOperaEvent( 'bjsOnTinyMCEScript', e.element );
					}
				}, false);
				addEventListener.call(opera, 'BeforeEvent.load', function(e){
					match.call=call;
					if( match.call(e.event.target.tagName, /iframe/i) && ( match.call(e.event.target.name, /^mce_editor_\d/ ) || match.call(e.event.target.id, /^mce_editor_\d/ ))){
						setTinyMCEVersion();
						sendOperaEvent('bjsOnTinyMCEInstance', e.event.target);
					}
				}, false);
				fixed=true;
		}else if(indexOf.call(name, 'dev.virtualearth.net/mapcontrol/mapcontrol.ashx')>-1 && window.SVGDocument){
			navRestore.userAgent = navigator.userAgent;
			navigator.userAgent+='KHTML';//356736
			shouldRestore=true;
		}else if(indexOf.call(name,'s_code')>-1||indexOf.call(name,'omniture')>-1){//PATCH-59
			avoidDocumentWriteAbuse();
		}else if(indexOf.call(name,'setdomain.js')>-1){//PATCH-128
			navRestore.userAgent = navigator.userAgent;
			navigator.userAgent+=' Gecko';
			shouldRestore=true;
		}else if(indexOf.call(name,'connect.facebook.net')>-1 && indexOf.call(name,'all.js')>-1){ 
				var win_attachEvent=window.attachEvent;
				if( window.fbAsyncInit ){
					var origFBAsyncInit=window.fbAsyncInit;
					window.fbAsyncInit=function(){
						window.attachEvent=undefined;
						origFBAsyncInit.call(null);
						window.attachEvent=win_attachEvent;
					}
				}else{
					window.attachEvent=undefined; 
					addEventListener.call(opera, 'AfterScript', function(e){
						window.attachEvent=win_attachEvent;
						removeEventListener.call(opera, 'AfterScript', arguments.callee, false);
					}, false);
				}
			}
		if( typeof window._jive_plain_quote_text!='undefined' ){ // Jive forum embeds TinyMCE, possibly outdated versions - PATCH-248
			opera.addEventListener('BeforeScript', function(e){
				indexOf.call=removeEventListener=call;
				if(indexOf.call(e.element.text, 'tinymce=')>-1){
					setTinyMCEVersion(e);
					sendOperaEvent( 'bjsOnTinyMCEScript', e.element );
					removeEventListener.call(opera, 'BeforeScript',arguments.callee,false);
				}
			}, false);
		}
		// Creating event handler to restore any changed navigator properties
		if( shouldRestore ){
			addEventListener.call(opera, 'AfterExternalScript', 
				function(ev){
					removeEventListener.call=call;
					var prop;
					for(prop in navRestore) navigator[prop]=navRestore[prop];
					removeEventListener.call(opera, 'AfterExternalScript', arguments.callee, false);
				}
			, false);
		}
	}, false);
			// PATCH-261, Hide broken implementation of showModalDialog to make object detection reliable
	delete showModalDialog;
			// PATCH-272, Remove non-functional addEventListener from XHR objects
	delete XMLHttpRequest.prototype.addEventListener;
			// PATCH-298, Disable sniffing in old HTMLArea editors
	opera.defineMagicVariable('HTMLArea', null, function(obj){
		obj.__defineGetter__('is_gecko', function(){return true});
		obj.__defineSetter__('is_gecko', function(){});
		obj.__defineGetter__('checkSupportedBrowser', function(){return function(){return true;}});
		obj.__defineSetter__('checkSupportedBrowser', function(){});
		var onloadmethod;
		obj.__defineSetter__('onload', function(func){ onloadmethod=func;});
		obj.__defineGetter__('onload', function(){ return function(){ try{ onloadmethod.call(this);}catch(e){ var instance=this; setTimeout(function(){instance.onload();}, 150); }}});
		opera.postError('Opera has modified the JavaScript on '+hostname+' (HTMLArea fix). See browser.js for details');
		return obj;
	});
	
			// 0, Asia-region Generic Patches
	opera.addEventListener('BeforeExternalScript',function(ev){
		var name=ev.element.src; 
		if(!name){return;}
		if(name.indexOf('api.e-map.ne.jp/jsapi.cgi?')!=-1){
			// Zenrin Datacom E-Map API, PATCH-115
			if (!Event.prototype.__lookupGetter__('layerX')&&!Event.prototype.__lookupGetter__('layerY')) {
				Event.prototype.__defineGetter__('layerX',function(){ return this.offsetX; });
				Event.prototype.__defineGetter__('layerY',function(){ return this.offsetY; });
			}
			ev.element.src += '&force=1';
		}else if((name.indexOf('expapi/authentication')!=-1)||(name.indexOf('expapi/expmapinclude')!=-1)||(name.indexOf('rosen/authentication')!=-1)){
			// Rosenzu ASP Map Service map, PATCH-122
			opera.defineMagicFunction('_ch',function(){return true;});
		}else if((name.indexOf('expapi/suggest')!=-1)||(name.indexOf('rosen/suggest')!=-1)){
			// Rosenzu ASP Map Service suggestions, PATCH-122
			opera.defineMagicFunction('checkBrowser',function(){return true;});
		}else if(name.indexOf('http://ebook.webcatalog.jp/engine/java/7net/common/sCommonLib.js')!=-1){ 
			// Netfly TrueEBook, PATCH-125
			opera.defineMagicFunction('funcGetBrowser',function(){return 2;}); 
		}
	},false);
			// PATCH-331, Disable HTMLElement.removeNode support, compat experiment
	delete HTMLElement.prototype.removeNode;


	if(hostname.indexOf('.ebay.')>-1 || hostname.indexOf('.ebaydesc.')>-1){			// 0, eBay
		/* eBay issues */
	
	
		// Avoid IFRAME resize causing lots of empty space on auctions
				// PATCH-195, Avoid IFRAME resize causing lots of empty space on auctions
		function resizeIframesAndPassSizeOn(e){
			if(e && e.type==='message' && e.origin.indexOf('ebaydesc')>-1){
				for(var iframes=document.getElementsByTagName('iframe'),iframe,i=0;iframe=iframes[i];i++){
					if(iframe.src.indexOf(e.origin)>-1){
						iframe.style.height=(20+parseInt(e.data))+'px';
					}
				}
			}
			if(top!=self)parent.postMessage(document.documentElement.scrollHeight, '*');
		}
		window.addEventListener('message', resizeIframesAndPassSizeOn, false);
		
	
	
		if(hostname.indexOf('.ebaydesc.')>-1){			// PATCH-195, Avoid IFRAME resize causing lots of empty space on auctions (the IFRAME part)
			window.addEventListener('load', function(){ 
				setTimeout(function(){
					if(top!=self)parent.postMessage(document.documentElement.scrollHeight, '*');
				}, 100); 
			}, false);
			setTimeout(function(){
				if(top!=self)parent.postMessage(document.documentElement.scrollHeight, '*');
			}, 600);
			
				if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Avoid IFRAME resize causing lots of empty space on auctions (the IFRAME part)). See browser.js for details');
		}
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (eBay). See browser.js for details');
	} else if(hostname.indexOf('.google.')>-1){			// 0, Google
		/* Google */
	
	
		if(hostname.indexOf('.com.tw')>-1 || hostname.indexOf('.co.jp')>-1 || hostname.indexOf('.com.hk')>-1){			//  PATCH-342, Google script that blurs and re-focuses input field prevents spatial navigation
			HTMLInputElement.prototype.blur=HTMLInputElement.prototype.focus=function(){};
			
				if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Google script that blurs and re-focuses input field prevents spatial navigation). See browser.js for details');
		}
		if(hostname.indexOf('code.google.')>-1 && (pathname.indexOf('diff')>-1 || pathname.indexOf('detail')>-1 )){			// PATCH-321, Work around pre inheritance into tables on Google Code
			addCssToDocument('div.diff>pre>table{white-space: normal;}div.diff>pre>table th, div.diff>pre>table td{white-space: pre-wrap;}');
				if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Work around pre inheritance into tables on Google Code). See browser.js for details');
		}
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Google). See browser.js for details');
	} else if(hostname.indexOf('.in.gr')>-1){			// PATCH-367, Correct placement of marquee on in.gr
		document.addEventListener('DOMContentLoaded', function(){
		 elm = document.getElementById('ticker-area');
		 if(elm){
		  elm.innerHTML=elm.innerHTML.replace(/&nbsp;/,'');
		 }
		},false);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Correct placement of marquee on in.gr). See browser.js for details');
	} else if(hostname.indexOf('.jcrew.com')>-1){			// PATCH-338, If XHR doesn't support EventTarget interface, setting onload should throw
		XMLHttpRequest.prototype.__defineSetter__('onload', function(){ throw 'unsupported'; });
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (If XHR doesn\'t support EventTarget interface, setting onload should throw). See browser.js for details');
	} else if(hostname.indexOf('.yahoo.')>-1){			// 0, Yahoo!
		/* Yahoo! */
	
	
		if(hostname.indexOf('.mail.yahoo.')>-1&&(href.indexOf( '/dc/system_requirements?browser=blocked' )>-1||href.indexOf( '/dc/system_requirements?browser=unsupported' )>-1)){			// 194334, Y!Mail work around browser blocking
			location.href='/dc/launch?sysreq=ignore';
			
				if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Y!Mail work around browser blocking). See browser.js for details');
		}
		if(hostname.indexOf('.mail.yahoo.')>=0 && pathname.indexOf('/dc/')==0){			// CORE-17538, Y!Mail avoid text selection on drag-and-drop
			window.addEventListener('mousedown', function(evt) {
				var target = evt.target;
				var cursor = getComputedStyle(target, null).cursor;
				if (/move/i.test(cursor) || /size/i.test(cursor)) {
					evt.preventDefault();
				} else if (!('value' in target) /* don't preventDefault for <input>, etc */) {
					for (var node = target; node; node = node.parentNode) {
						if (node.hasAttribute && node.hasAttribute('tabindex')) {
							evt.preventDefault();
							break;
						}
					}
				}
			}, true);
					// 321384, createElement in XML document should put un-prefixed nodes in null namespace
			var docCreateElement = Document.prototype.createElement;
			if( window.XMLDocument ){
				XMLDocument.prototype.createElement = function(n){ return n.indexOf(':')==-1 ? this.createElementNS(null, n) : docCreateElement.call(this,n); }
			}else{
				Document.prototype.createElement = function(n){ return n.indexOf(':')==-1 ? this.createElementNS(null, n) : docCreateElement.call(this,n); }
			}
					// 194334, Y!Mail preventing drag from selecting text
			if( self==top )
				opera.addEventListener('BeforeEventListener.mousedown',function(e){
						try{
							indexOf.call = preventDefault.call = call;
							if( indexOf.call(e.event.target.parentNode.parentNode.className, 'messageRow')>-1)
								preventDefault.call(e.event);
						}catch(e){}
				},false);
			
			document.addEventListener('mousemove',function(e){
				if( e.target.getAttribute('unselectable')=='on' )
					e.target.ownerDocument.defaultView.getSelection().removeAllRanges();
			},false);
			
					// 194334, Y!Mail remove selectSingleNode and selectNodes
			/* because Yahoo mail is better at emulating proprietary IE functions than we are.. */
			Node.prototype.selectSingleNode=undefined;
			Node.prototype.selectNodes=undefined;
				if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Y!Mail avoid text selection on drag-and-drop\ncreateElement in XML document should put un-prefixed n...). See browser.js for details');
		}
		if(hostname.indexOf('mail')==-1){			// 271238, Yahoo ISP portal blocks Opera users
			addPreprocessHandler( /d\.location\.href = ".*?\/browser_upgrade\.html";/g, '');
				if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Yahoo ISP portal blocks Opera users). See browser.js for details');
		}
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Yahoo!). See browser.js for details');
	} else if(hostname.indexOf('blogger.com')>-1){			// DSK-152851, Blogger: browser detection prevents WYSIWYG editing
		navigator.product = 'Gecko';
		navigator.userAgent = navigator.userAgent.replace(/Opera/, 'Firefox')+' ( rv:1.9.0.3)';
		
		opera.defineMagicVariable(
			'Detect',
			function( obj ){return obj;},
			function( obj ){
				obj.OPERA = function(){return false;}
				obj.MOZILLA = function(){return true;}
				obj.IE=function(){return false;}
				obj.IE_5_5_newer=function(){return false;}
				return obj;
			}
		);
		
				// PATCH-206, Don't override native click() method and expect to submit forms by calling click() on a button..
		HTMLInputElement.prototype.click=HTMLButtonElement.prototype.click=HTMLElement.prototype.click;
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Blogger: browser detection prevents WYSIWYG editing\nDon\'t override native click() method and expect...). See browser.js for details');
	} else if(hostname.indexOf('cambrian.mb.ca')>-1){			// PATCH-285, Enable log-in button on Cambrian bank
		Element.prototype.__defineGetter__('all', function(){});
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Enable log-in button on Cambrian bank). See browser.js for details');
	} else if(hostname.indexOf('computerra.ru')>-1){			// PATCH-267, Make BBCode editor buttons work by disabling Opera sniffing
		document.addEventListener('DOMContentLoaded', function(){
			if(window.jsUtils&&window.jsUtils.bOpera)jsUtils.bOpera=false;
		}, false);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Make BBCode editor buttons work by disabling Opera sniffing). See browser.js for details');
	} else if(hostname.indexOf('espn.go.com')>-1){			// PATCH-375, Make sure the ESPN polls work
		navigator.appName="netscape";
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Make sure the ESPN polls work). See browser.js for details');
	} else if(hostname.indexOf('footballteam.pl')>-1){			// PATCH-358, Enable the password box on footballteam.pl
		HTMLInputElement.prototype.__defineSetter__('type',function(){
			if (this.getAttribute('type')!=arguments[0]) {
				var doFocus=false, result;
				if (this == document.activeElement) doFocus = true;
				result = this.setAttribute('type',arguments[0]);
				if (doFocus) this.focus();
				return result;
			}
		});
		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Enable the password box on footballteam.pl). See browser.js for details');
	} else if(hostname.indexOf('geoaccess.com')!=-1){			// 318050,  BlueCross browser sniffing prevents insurance search
		opera.defineMagicVariable('is_nav', function(){return true;}, null);
		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' ( BlueCross browser sniffing prevents insurance search). See browser.js for details');
	} else if(hostname.indexOf('kort.arealinfo.dk')>-1){			// PATCH-348, Disable Opera detection that causes hidden content
		opera.defineMagicVariable('op', function(){return false}, null);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Disable Opera detection that causes hidden content). See browser.js for details');
	} else if(hostname.indexOf('mail.live.com')!=-1){			// CORE-17497, Opera doesn't support col-resize/row-resize cursors.
		addCssToDocument('html .SplitterBarH { cursor: s-resize } html .SplitterBarV { cursor: e-resize } #masterSplitter { cursor: e-resize }');
				// DSK-235885, Hotmail uses lookupGetter on prototypes, not instances
		var styleSetterLookupMethod = document.createElement('span').style.__lookupSetter__;
		 CSSStyleDeclaration.prototype.__lookupSetter__ = function(prop){
			return styleSetterLookupMethod.call(document.createElement('span').style, prop);
		 };
				// PATCH-135, Fixes removing contacts from To field by clicking small X icon
		addCssToDocument('.ContactPicker_AutoComplete img{position:static!important;}');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Opera doesn\'t support col-resize/row-resize cursors.\nHotmail uses lookupGetter on prototypes, not i...). See browser.js for details');
	} else if(hostname.indexOf('meebo.com')>-1){			// OTW-6247, Meebo tries to use detachEvent to remove listeners added with addEventListener due to inversed feature detection in their ui.detachEvent method
		delete window.detachEvent;
		delete Node.prototype.detachEvent;
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Meebo tries to use detachEvent to remove listeners added with addEventListener due to inversed featu...). See browser.js for details');
	} else if(hostname.indexOf('myspace.com')>-1){			// PATCH-266, Opera disallows using reserved word top as variable name
		(function(){
			var the_top;
			opera.defineMagicVariable('top', function(){return the_top;}, function(o){the_top=o;});
		})();
		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Opera disallows using reserved word top as variable name). See browser.js for details');
	} else if(hostname.indexOf('news.qq.com')>-1){			// PATCH-112, weather.news.qq.com uses document.all for browser detection
		opera.defineMagicVariable('ie4',function(){return true;}, null);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (weather.news.qq.com uses document.all for browser detection). See browser.js for details');
	} else if(hostname.indexOf('opera.com')>-1&& pathname.indexOf('/docs/browserjs/')==0){			// 0, Browser.js status and version reported on browser.js documentation page
		document.addEventListener((parseFloat(opera.version())>9?'DOMContentLoaded':'load'),function(){
			if(document.getElementById('browserjs_active')){
				document.getElementById('browserjs_active').style.display='';
				document.getElementById('browserjs_active').getElementsByTagName('span')[0].appendChild(document.createTextNode(bjsversion));
				document.getElementById('browserjs_status_message').style.display='none';
			}else if(document.getElementById('browserjs_status_message')){
				document.getElementById('browserjs_status_message').firstChild.data='Browser.js is enabled! '+bjsversion;
			}
		}, false);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Browser.js status and version reported on browser.js documentation page). See browser.js for details');
	} else if(hostname.indexOf('tvguide.com')>-1){			// PATCH-274, TVGuide doesn't show program descriptions, due to browser sniffing
		opera.defineMagicVariable('isSafari', function(){return true;}, null);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (TVGuide doesn\'t show program descriptions, due to browser sniffing). See browser.js for details');
	} else if(hostname.indexOf('westjet.com')>-1 ){			// PATCH-260,  Westjet browser sniffing warns against Opera
		opera.defineMagicVariable('browser', function(o){ o.isSupported=true; return o; }, null);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' ( Westjet browser sniffing warns against Opera). See browser.js for details');
	} else if(hostname.indexOf('www.yoka.com')>-1){			// PATCH-238, Override minmax IE helper script
		opera.defineMagicFunction('minmax_scan', function(){});
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Override minmax IE helper script). See browser.js for details');
	} else if(href.indexOf('/sample_lr.html')>-1){			// PATCH-128, Sun Webmail fails to set document.domain due to browser sniffing
		navigator.userAgent+=' Gecko';
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Sun Webmail fails to set document.domain due to browser sniffing). See browser.js for details');
	}

})(opera);
