# Another HTML-lint ###########################################

eval(q|require 'htmllint.env'|);
eval(q|require 'common.rul'|);

package htmllint;

=ignore
use strict;
use vars qw($htmlfile @htmlfiles $curcwd $ext $prune);
use vars qw($rule $HTML $line $ungetl $token $reacheof $readsize $fromfile
            $textcode $jcharcode $charset $xcharset $bom
            @ucase @lcase @xcase @ucaseln @lcaseln @xcaseln $pretab
            $xmldecl $seenXml $seenHtml, $metaLang,
            $lang $tagscnt $whinescnt $pwhinescnt $upenalty $penalty $maxpnt
            $tagsNestWhine @tagsNest @inclNest @exclNest $nonAsciiEarly
            $omit_html $p_isnot_br $appElem $lastTag $contBRs %seenAllTags
            $seenCharset $metaCharset $baseURL @refreshHTML %iddef %idref $ahref
            %hrefAnchors %seenAnchors %seenAnchorsU %seenAnchorsID %seenAnchorsIN
            %mapAnchors %seenMapAnchors %seenMapAnchorsU %seenMapAnchorsID
            %seenFrameName $seenRelURL $headElements @ijams @istas @ilets @iswfs @irsts
            @tableInfos @tableInfo $tableCell %linkText %linkInfo %alt %bgcolor $txcolor
            $multibody $bodyline @seenLabels @seenLabel @ctrlLabels @ctrlLabel
            @seenSelect @selOption $selOptions $seenPre @seenObjects @seenObject
            @headingLevel $headingStart %formNames $needprchar
            $nestULOL $cntLI $nestOBJECT $cntPARAM
            $isohtml $xhtml $xml $xmlns @xmlns @markedSection $procdoctype);
use vars qw($allTags $emptyTags $pairTags $deprecatedTags $omitStartTags $omitEndTags
            $maybeEmpty %requiredTags %onceonlyTags $sequencialTags
            %tagsElements %excludedElems %includedElems $noOmitEtag
            %deprecatedElems %deprecatedAttrs %deprecatedAttrsCss %deprecatedVals
            %tagsAttributes %requiredAttrs $disabled
            %refEntities %refParams %indexhtml %stathtml);
use vars qw($nameChr $nameStr $idStr $tokenStr $nutokenStr %tokenizedType);
use vars qw($opt_pedantic $opt_banner $opt_echoname
            $opt_score $opt_scorenowhines $opt_scoreonly
            $opt_religious $opt_accessibility $opt_warnings $opt_prune $opt_base
            $opt_igndoctype $opt_igncharset $opt_lc $opt_limit $opt_omit $opt_mime
            $opt_lang $opt_charset $opt_style $opt_script $opt_local $opt_linklist
            $opt_after $opt_w $opt_f $opt_x $opt_stat $opt_dbg);
use vars qw($cnf_style $cnf_html $cnf_limit $cnf_omit
            %cnf_e %opt_e $opt_r $opt_listwarnings $opt_u $opt_v $opt_version $opt_help);
use vars qw($analizing $pcdata
            $TAG $oTAG $atag $minetag %seenTags %seenAttrs %seenAttrsOrg $unknownTag
            $ATTR $oATTR $subATTR $value $ahref $quot);
use vars qw($lastPairTag $lastOmitTag @innerTags @seq $seqid $thisTagElements);
use vars qw($stdio $htmlVer %colorTable $ruledir $rulefile
            %messages %alias_messages %religious %accessibility %shortid %enabled
            %uniquewhine %pairTags %emptyTags %attributes);
use vars qw($charsets $usascii %japanesesets %escapeseq);
use vars qw($VERSION);
=cut

my ($PROGRAM, $PROGDIR);
my ($WIN, $MAC, $UNIX);
my ($SEP, $version);

BEGIN {     require 5.002;  # JPerl ł͓삵܂

$VERSION = '3.58';

my $myADDRESS = 'k16@chiba.email.ne.jp';

$version = <<EndOfVersion;
  Another HTML-lint ver$VERSION
    Copyright (c) 1997-2007 by ISHINO Keiichiro <$myADDRESS>.
    All rights reserved.
EndOfVersion

$WIN = $^O =~ /Win32/i;
$MAC = $^O =~ /MacOS/i;
my $OS2; #UNSUPPORTED;
$UNIX = !($WIN || $MAC || $OS2);

$SEP = '/';
if ($WIN) {
  ($PROGRAM = $0) =~ s#\\#/#g; # {t@Cs
  $PROGRAM =~ m#^([A-Za-z]:)?(.*)#;
  $PROGDIR = $1;
  $2 =~ m#^(.*?)([^/]+)$#;
  $PROGRAM = $2;
  $PROGDIR .= ($1 eq '')? '.': $1;
} elsif ($MAC) {
  ($PROGDIR, $PROGRAM) = $0 =~ m#^(.*?)([^:]+)$#;
  $SEP = ':';
} else {
  $PROGRAM = $0;
  my $LINK;
  while ($LINK = readlink($PROGRAM)) {
    if ($LINK =~ m#^/#) {
      $PROGRAM = $LINK;
    } else {
      $PROGRAM =~ m#^(.*?)[^/]+$#;
      $PROGRAM = $1.$LINK;
    }
    $PROGRAM = &NormalizeDots($PROGRAM);
  }
  ($PROGDIR, $PROGRAM) = $PROGRAM =~ m#^(.*?)([^/]+)$#;
  $PROGDIR = '.' if $PROGDIR eq '';
}
$PROGDIR .= $SEP if $PROGDIR !~ m#$SEP$#o;
unshift @::INC, $PROGDIR;
$stdio = "\tstdio\t";

sub HTMLlint(@);
sub ListWarnings(;\@);

} # End of BEGIN

use Time::Local;
use Getopt::Long;
   $Getopt::Long::autoabbrev = 1;
use Cwd;
use File::Find;
require RFC2396;
my $Jcode;
if (!$::NOUSEJCODE && eval('require Jcode')) {
  $Jcode = $Jcode::VERSION;
  *Jgetcode = \&Jcode::getcode;
  *Jconvert = \&Jcode::convert;
} else {
  $Jcode = 0;
  require 'jcode.pl';
  *Jgetcode = \&jcode::getcode;
  *Jconvert = \&jcode::convert;
}

my $usage = <<EndOfUsage . <<'EndOfOptions';
  usage: perl5 $PROGRAM options file.html...
EndOfUsage
  options: (*=default)
    -d <warn>     : w肳ꂽx𖳌ɂB(ex̓R}ŋ؂)
    -e <warn>     : w肳ꂽxLɂB(ex̓R}ŋ؂)
    -f <file>     : ݒt@C(htmllintrc)w肷B
    -pedantic     : ׂĂ̌xLɂB(̂Ƃ -d -e ̎w薳)
    -nopedantic   : ׂĂ̌xLɂ邱Ƃ͂ȂB
    -religious    : @IȌxLɂB
    -noreligious  : @IȌx𖳌ɂB
    -accessibility   : ANZXɊւxLɂB
    -noaccessibility : ANZXɊւx𖳌ɂB
    -banner       : JnƏIbZ[W\B
    -nobanner     : JnƏIbZ[W\ȂB
    -echoname     : `FbN HTML t@CWG[o͂B
    -noechoname   : `FbN HTML t@CWG[o͂ȂB
    -score        : `FbN HTML ̓_\B
    -scorenowhines: `FbN HTML ̓_x̂Ƃ̂ݕ\B
    -scoreonly    : `FbN HTML ̓_݂̂\B
    -noscore      : `FbN HTML ̓_\ȂB
    -prune        : fBNgŵƂʃfBNgTȂB
    -noprune      : fBNgŵƂʃfBNgTB
    -warnings     : `FbNɂx\B
    -nowarnings   : `FbNĉx\ȂB
    -linklist     : HTML Ɋ܂܂郊N\B
    -nolinklist   : HTML Ɋ܂܂郊N\ȂB
    -lc           : x̗vf⑮ŕ\BXHTML͖B
    -uc           : x̗vf⑮啶ŕ\BXHTML͖B
    -listwarnings : T|[gĂ邷ׂĂ̌x\B
    -w <style>    : xbZ[W̃X^Cw肷B
                     <style> = lint     file(#): warning-message
                             = short    #: warning-message
                             = long     #: warning-id: warning-message
                             = terse    file:#:warning-id
                             = verbose  file: #: warning-id: warning-message
    -limit <n>    : x̑ł؂w肷B
    -omit <n>     : _x̑ł؂萔w肷B
    -x <html>     : w肳ꂽ HTML @[WŃ`FbNB
                     <html> = html10
                            = html20 | RFC1866
                            = html2x | RFC2070 | i18n
                            = html+ | htmlplus
                            = html30 | arena
                            = html32 | wilbur
                            = html40 | html40s | html40-strict
                            = html40t | html40-transitional
                            = html40f | html40-frameset
                            = html40m | html40-mobile
                            = html401 | html401s | html401-strict
                            = html401t | html401-transitional
                            = html401f | html401-frameset
                            = xhtml1 | xhtml1s | xhtml1-strict
                            = xhtml1t | xhtml1-transitional
                            = xhtml1f | xhtml1-frameset
                            = xhtml11
                            = xhtml-rdfa
                            = xhtmlb
                            = xhtmlmp
                            = 15445 | iso-html
                            = 15445p | 15445-preparation | iso-html-preparation
                            = mozilla20
                            = mozilla30
                            = mozilla40 | navigator | netscape
                            = ie30b | msie30b
                            = ie30 | msie30
                            = ie40 | msie40
                            = ie50 | msie50
                            = ie55 | msie55 | microsoft
                            = webexp
                            = compact-html | compact
                            = imode10
                            = imode20
                            = imode30
                            = imode40
                            = imode-xhtml | ixhtml
                            = imode-xhtml11 | ixhtml11
                            = jskyweb
                            = jskystation
                            = doti10
                            = jpo
                    啶̋ʂȂB
    -igndoctype   : HTML  DOCTYPE 錾𖳎B
    -usedoctype   : HTML  DOCTYPE 錾𖳎ȂB
    -igncharset   : CHARSET ̎wƃR[ḧv𖳎B
    -usecharset   : CHARSET ̎wƃR[ḧv𖳎ȂB
    -local        : HTML ̃[Jt@C̎QƂB
    -nolocal      : HTML ̃[Jt@C̎QƂ֎~B
    -after <date> : wȍ~̃t@Ĉ݃`FbNB
                     <date> = YYYY-MM-DD-hh-mm-ss (؂͔CӁAr܂łŉ)
                            = @file (̃t@C̃^CX^v)
    -r <dir>      : Kt@C̃fBNgw肷B
                    w肪Ȃ htmllint ƓꏊƂ݂ȂB
    -v | -version : @[W\B
    -u | -help    : ̃bZ[W\B
  return: G[Ȃ΃G[Xe[^X 0 ŏIB
EndOfOptions

my $myCODE = &Jgetcode(\$usage); # euc ܂ sjis

$::HTMLLINTRC = '.htmllintrc'          unless defined($::HTMLLINTRC);
$::HTMLEXT    = 'html?|[sp]ht(ml?)?'   unless defined($::HTMLEXT);
$::INDEXHTML  = "index\\.($::HTMLEXT)" unless defined($::INDEXHTML);

my $stdNameChr  = '[A-Za-z0-9\.\-]';
my $stdTokenStr = $stdNameChr.'+';
#  $nameStr     = '[A-Za-z]'.$stdNameChr.'*';
my $allc     = '[\x00-\xFF]';
my $digits   = '\d+';
my $charData = '(?=[CNIE])(?:CDATA|NUMBER|NAME|NMTOKEN|NUTOKEN'.
               '|NUMBERS|NAMES|NMTOKENS|NUTOKENS|ID|IDREF|IDREFS|ENTITY'.
               '|CDATA\+)'; # ɂłȂ CDATA
my $internalElem = '#\d+';
my $unsafeuri   = '~';
my $nameSep     = '/';  # $nameChr Ɋ܂܂Ȃ
my %URLcollection = ();
my $stylescript = '(?:STYLE|SCRIPT)';

my %TagAttrCheckers = (
  'BASE'.  $nameSep.'HREF'     => \&CheckTagAttrBASE_HREF,
  'FRAME'. $nameSep.'NAME'     => \&CheckTagAttrFRAME_NAME,
  'FRAME'. $nameSep.'SRC'      => \&CheckTagAttrFRAME_SRC,
  'A'.     $nameSep.'HREF'     => \&CheckTagAttrA_HREF,
  'A'.     $nameSep.'IJAM'     => \&CheckTagAttrA_IJAM,
  'A'.     $nameSep.'ISTA'     => \&CheckTagAttrA_ISTA,
  'A'.     $nameSep.'ILET'     => \&CheckTagAttrA_ILET,
  'A'.     $nameSep.'ISWF'     => \&CheckTagAttrA_ISWF,
  'A'.     $nameSep.'IRST'     => \&CheckTagAttrA_IRST,
  'A'.     $nameSep.'CTI'      => \&CheckTagAttrA_CTI,
  'A'.     $nameSep.'KANA'     => \&CheckTagAttrA_KANA,
  'A'.     $nameSep.'EMAIL'    => \&CheckTagAttrA_EMAIL,
  'IMG'.   $nameSep.'ALT'      => \&CheckTagAttrIMG_ALT,
  'IMG'.   $nameSep.'USEMAP'   => \&CheckTagAttrIMG_USEMAP,
  'IMG'.   $nameSep.'ISMAP'    => \&CheckTagAttrIMG_ISMAP,
  'IMG'.   $nameSep.'MOTION'   => \&CheckTagAttrIMG_MOTION,
  'OBJECT'.$nameSep.'TITLE'    => \&CheckTagAttrOBJECT_TITLE,
  'OPTION'.$nameSep.'SELECTED' => \&CheckTagAttrOPTION_SELECTED,
  'FONT'.  $nameSep.'COLOR'    => \&CheckTagAttrFONT_COLOR,
);
my %AttrCheckers = (
  CLASS      => \&CheckAttrCLASS,
  LANG       => \&CheckAttrLANG,
  'XML:LANG' => \&CheckAttrXMLLANG,
  ALT        => \&CheckAttrALT,
  ISMAP      => \&CheckAttrISMAP,
  TARGET     => \&CheckAttrTARGET,
  STYLE      => \&CheckAttrSTYLE,
  TABINDEX   => \&CheckAttrTABINDEX,
  DISABLED   => \&CheckAttrDISABLED,
  BGCOLOR    => \&CheckAttrBGCOLOR,
);
my %TagCheckers = (
  HTML     => \&CheckTagHTML,
  BODY     => \&CheckTagBODY,
  LINK     => \&CheckTagLINK,
  META     => \&CheckTagMETA,
  SCRIPT   => \&CheckTagSCRIPT,
  STYLE    => \&CheckTagSTYLE,
  OL       => \&CheckTagOLUL,
  UL       => \&CheckTagOLUL,
  LI       => \&CheckTagLI,
  DD       => \&CheckTagDD,
  A        => \&CheckTagA,
  MAP      => \&CheckTagMAP,
  LABEL    => \&CheckTagLABEL,
  SELECT   => \&CheckTagSELECT,
  OPTION   => \&CheckTagOPTION,
  INPUT    => \&CheckTagINPUT,
  BUTTON   => \&CheckTagBUTTON,
  TEXTAREA => \&CheckTagTEXTAREA,
# TABLE    => \&CheckTagTABLE,
  COL      => \&CheckTagCOL,
  TR       => \&CheckTagTR,
  TH       => \&CheckTagTHTD,
  TD       => \&CheckTagTHTD,
  BR       => \&CheckTagBR,
  PRE      => \&CheckTagPRE,
  IMG      => \&CheckTagIMG,
  APPLET   => \&CheckTagAPPLET,
  OBJECT   => \&CheckTagOBJECT,
  PARAM    => \&CheckTagPARAM,
  XML      => \&CheckTagXML,
);
my %TagClosing = (
  HTML     => \&CloseTagHTML,
  PRE      => \&CloseTagPRE,
  FORM     => \&CloseTagFORM,
  SELECT   => \&CloseTagSELECT,
  LABEL    => \&CloseTagLABEL,
  HEAD     => \&CloseTagHEAD,
  OBJECT   => \&CloseTagOBJECT,
  APPLET   => \&CloseTagOBJECT,
  OL       => \&CloseTagOLUL,
  UL       => \&CloseTagOLUL,
);

##################################################
# 

sub HTMLlint(@)
{
  local @ARGV = @_;
  local ($opt_pedantic, $opt_banner, $opt_echoname,
         $opt_score, $opt_scorenowhines, $opt_scoreonly,
         $opt_religious, $opt_accessibility, $opt_warnings, $opt_prune, $opt_base,
         $opt_igndoctype, $opt_igncharset, $opt_lc, $opt_limit, $opt_omit, $opt_mime,
         $opt_lang, $opt_charset, $opt_style, $opt_script, $opt_local, $opt_linklist,
         $opt_after, $opt_w, $opt_f, $opt_x, $opt_stat, $opt_dbg);
  return if &ReadOptions();
  &ReadRule('charsets.rul');
  &ReadRule('colortable.rul');
  &ReadTagsSet();

  if ($myCODE eq 'sjis') {
    # {̊܂܂鐳K\pGXP[v
    my $esc = 0;
    my $escStr = '';
    foreach (unpack('C*', $::hereAnchorsJ)) {
      $esc = 2 if $esc <= 0 && ((0x0081 <= $_ && $_ <= 0x009F) ||
                                (0x00E0 <= $_ && $_ <= 0x00FC));
      $escStr .= ($esc-- <= 0)? chr: sprintf('\\x%02X', $_);
    }
    $::hereAnchorsJ = $escStr; # dGXP[v
  }

  my $exit_status;
  while (@ARGV > 0) {
    local @htmlfiles;
    $_ = shift(@ARGV);
    if ($_ eq $stdio) {
      *HTML = *STDIN;
      &Lint('');
      &::TakeStatistics($opt_stat) if $opt_stat;
    } else {
      local $curcwd = &currentdir;
      if (-d) {
        local $ext = '\.('.$::HTMLEXT.')';
        &find(\&HTMLwanted, $_);
      } else {
        /(.*?[$SEP])?([^$SEP]+)$/o;
        my $dir = $1;
        local $ext = $2;
        if ($ext =~ /[*?]/) {
          $ext =~ s/([.^()\$@%+])/\\$1/g;
          $ext =~ s/\*/.*/g;
          $ext =~ s/\?/./g;
          &find(\&HTMLwanted, ($dir eq '')? '.': $dir);
        } else {
          push(@htmlfiles, $_);
        }
      }
      foreach (@htmlfiles) {
        if (open(HTML, "<$_")) {
          if ($opt_after && [stat HTML]->[9] <= $opt_after) { next; }
          binmode HTML if $WIN;
          $exit_status = 1 if &Lint($_);
          close(HTML);
          &::TakeStatistics($opt_stat) if $opt_stat;
        } else {
          warn "Can't open `$_`.\n";
        }
      }
    }
  }
  $exit_status;
}

sub currentdir
{
  my $dir = &Cwd::getcwd().$SEP;
  $dir =~ s/$SEP$SEP$/$SEP/e;
  $dir;
}

sub HTMLwanted
{
  if (-d) {
    $File::Find::prune = 1 if $opt_prune && $_ ne '.' && $_ ne '..';
  } elsif (/$ext$/i) {
    my $name = &currentdir.$_;
    if (substr($name, 0, length($curcwd)) eq $curcwd) {
      $name = substr($name, length($curcwd));
    }
    push(@htmlfiles, $name);
  }
}

sub DetectSeparator
{
  my $buff;
  read(HTML, $buff, 1024);
  my $top = 0;
  if ($buff =~ /^(\xEF\xBB\xBF|\xFF\xFE(?:\x00\x00)?|(?:\x00\x00)?\xFE\xFF)/) {
    # BOM
    $bom = $1;
    $top = length($bom);
    #$buff = substr($buff, $top);
    &Whine(0, 'bom');
  }
  my $sep = "\n";
  if ($buff !~ /\x0D\x0A/) {
    $sep = "\x0A" if $buff =~ /\x0A/;
    $sep = "\x0D" if $buff =~ /\x0D/;
  }
  seek(HTML, $top, 0);
  $sep;
}

sub DetectEncoding
{
  my $buff = shift;
  my ($code, $nmatch);
  if ($Jcode) {
    ($code, $nmatch) = &Jgetcode($buff);
  } else {
    ($nmatch, $code) = &Jgetcode($buff);
  }
  if ($code =~ /^(?:jis|euc|sjis|utf8)$/) {
    return $code if $code =~ /^(?:jis)$/ or $nmatch >= 8;
  }
  undef;
}

##################################################
# HTML ǂŉ͂

  sub xc { ($opt_lc || $xhtml)? lc(shift): shift; }
  sub xetag { ($opt_lc || $xhtml)? ' />': '>'; }

sub Lint
{
  undef %::whinesStat;
  local ($htmlfile) = @_;
  local ($rule, $HTML, $line, $ungetl, $token, $reacheof, $readsize, $fromfile,
         $textcode, $jcharcode, $charset, $xcharset, $bom,
         @ucase, @lcase, @xcase, @ucaseln, @lcaseln, @xcaseln, $pretab,
         $xmldecl, $seenXml, $seenHtml, $metaLang,
         $lang, $tagscnt, $whinescnt, $pwhinescnt, $upenalty, $penalty, $maxpnt,
         $tagsNestWhine, @tagsNest, @inclNest, @exclNest, $nonAsciiEarly,
         $omit_html, $p_isnot_br, $appElem, $lastTag, $contBRs, %seenAllTags,
         $seenCharset, $metaCharset, $baseURL, @refreshHTML, %iddef, %idref, $ahref,
         %hrefAnchors, %seenAnchors, %seenAnchorsU, %seenAnchorsID, %seenAnchorsIN,
         %mapAnchors, %seenMapAnchors, %seenMapAnchorsU, %seenMapAnchorsID,
         %seenFrameName, $seenRelURL, $headElements, @ijams, @istas, @ilets, @iswfs, @irsts,
         @tableInfos, @tableInfo, $tableCell, %linkText, %linkInfo, %bgcolor, $txcolor,
         $multibody, $bodyline, @seenLabels, @seenLabel, @ctrlLabels, @ctrlLabel,
         @seenSelect, @selOption, $selOptions, $seenPre, @seenObjects, @seenObject,
         @headingLevel, $headingStart, %formNames, $needprchar,
         $nestULOL, $cntLI, $nestOBJECT, $cntPARAM,
         $isohtml, $xhtml, $xml, $xmlns, @xmlns, @markedSection, $procdoctype);
  local ($allTags, $emptyTags, $pairTags, $deprecatedTags, $omitStartTags, $omitEndTags,
         $maybeEmpty, %requiredTags, %onceonlyTags, $sequencialTags,
         %tagsElements, %excludedElems, %includedElems, $noOmitEtag,
         %deprecatedElems, %deprecatedAttrs, %deprecatedAttrsCss, %deprecatedVals,
         %tagsAttributes, %requiredAttrs, $disabled,
         %refEntities, %refParams, %indexhtml, %stathtml);
  local ($nameChr, $nameStr, $idStr, $tokenStr, $nutokenStr, %tokenizedType);
  local $/;
  if ($htmlfile eq '') {
    $htmlfile = 'stdin';
  } else {
    $fromfile = 1;
    $/ = &DetectSeparator;
  }
  %URLcollection = ();
  $penalty = 0;
  return 1 if &Doctype;
  $lang = { val=>$opt_lang, n=>0 };
  if ($opt_charset ne '') {
    if ($opt_charset =~ /^(?:$usascii)$/oi) {
      $charset = 'usascii';
    } else {
      $charset = $opt_charset;
      foreach (keys %japanesesets) {
        if ($opt_charset =~ /^(?:$japanesesets{$_})$/i) {
          $jcharcode = $_;
          last;
        }
      }
    }
    $metaCharset++;
  }
  $tagscnt = 0;
  push(@headingLevel, [ 0, 0 ]);
  my ($ln, $tag);
  local $analizing = 1;
  ($ln, $tag) = &ReadTag($HTML) until $tag eq $HTML;
  $analizing = 0;
  # ȍ~n #############
  my $over = ($whinescnt >= $opt_limit);
  if (!$over) {
    {
      my @noattrs;
      my $seens = 0;
      foreach (qw(BGCOLOR TEXT LINK VLINK ALINK)) {
        if ($seenAllTags{'BODY'.$nameSep.$_}) {
          $seens++;
        } elsif ($tagsAttributes{BODY}->{$_} ne '') {
          push(@noattrs, xc($_));
        }
      }
      if ($seens && @noattrs) {
        if ($seenAllTags{'A'.$nameSep.'HREF'}) {
          my $attrs = join('A', @noattrs);
          &Whine($bodyline, 'body-color', xc('BODY'), $attrs);
        } elsif ($tagsAttributes{BODY}->{BGCOLOR} ne '') {
          if ($seenAllTags{'BODY'.$nameSep.'TEXT'}) {
            &Whine($bodyline, 'body-color', xc('BODY'), xc('BGCOLOR'))
              unless $seenAllTags{'BODY'.$nameSep.'BGCOLOR'};
          } else {
            &Whine($bodyline, 'body-color', xc('BODY'), xc('TEXT'))
              if $seenAllTags{'BODY'.$nameSep.'BGCOLOR'};
          }
        }
      }
    }
    foreach (@ctrlLabels) {
      my @label = &SearchLabel(@$_);
      &CheckAccesskey(\@label, \@$_);
    }
    foreach my $ijam (@ijams, @istas, @ilets, @iswfs, @irsts) {
      my $found;
      foreach (@seenObjects) {
        if (uc($ijam->{id}) eq uc($_->{id})) {
          $found = 1;
          last;
        }
      }
      unless ($found) {
        &Whine($., 'undef-id', xc($ijam->{tag}), xc($ijam->{attr}), xc($ijam->{id}), $ijam->{n});
        delete $idref{$ijam->{id}};
      }
    }
    &SkipComment;
    if ($line ne '') {
      &Whine($., 'unexpected-end-of-html', xc($HTML));
      while (&GetLine ne '') { $line = ''; } # sJEgĂ
    }
    foreach (reverse keys %idref) {
      unless ($iddef{$_}) {
        $idref{$_} =~ /^(\d+)$nameSep($idStr)$nameSep($idStr)$/;
        &Whine($., 'undef-id', xc($2), xc($3), $_, $1);
      }
    }
    if ($tagsAttributes{A}->{NAME} ne '' || $htmlVer >= 4) {
      if ($htmlVer >= 4) {
        # HTML4 ł́AAJ[ ID ͓
        foreach (sort {$seenAnchors{$a} <=> $seenAnchors{$b}} keys %seenAnchors) {
          my $uval = $xhtml? $_: uc;
          &Whine($seenAnchors{$_}, 'same-fragment-id',
                                   xc('A'), $_, $iddef{$uval}, xc('ID'))
            if $iddef{$uval} && !$seenAnchorsID{$uval} && !$seenAnchorsIN{$uval};
        }
      }
      foreach (sort {$hrefAnchors{$a}[0] <=> $hrefAnchors{$b}[0]} keys %hrefAnchors) {
        if ($seenAnchors{$_}) {
          delete $seenAnchors{$_};
        } else {
          my $uval = $xhtml? $_: uc;
          my $lin = $hrefAnchors{$_}[0];
          my $tag = xc($hrefAnchors{$_}[1]);
          if ($htmlVer >= 4 && $iddef{$uval}) {
            &Whine($lin, 'id-link', $tag, $_, $iddef{$uval}, xc('ID')) if $htmlVer == 4 && !$isohtml;
            &Whine($lin, 'lower-id', $tag, xc('ID'), $_) if !$xhtml && !$isohtml && /[a-z]/;
          } else {
            &Whine($lin, 'bad-link', $tag, $_);
          }
        }
      }
    }
    foreach (sort {$seenAnchors{$a} <=> $seenAnchors{$b}} keys %seenAnchors) {
      &Whine($seenAnchors{$_}, 'unref-link', xc('A'), $_);
    }
    if ($tagsAttributes{MAP}->{NAME} ne '') {
      foreach (sort {$mapAnchors{$a}[0] <=> $mapAnchors{$b}[0]} keys %mapAnchors) {
        if ($seenMapAnchors{$_}) {
          delete $seenMapAnchors{$_};
        } else {
          my $uval = $xhtml? $_: uc;
          &Whine($mapAnchors{$_}[0], 'bad-link', xc($mapAnchors{$_}[1]), $_);
        }
      }
    }
    foreach (keys %::nonsupportedTagsPair) {
      my $alt = $::nonsupportedTagsPair{$_}[0];
      if ($alt =~ /^(?:$allTags)$/ &&
          $seenAllTags{$_} && !$seenAllTags{$alt}) {
        &Whine($., $::nonsupportedTagsPair{$_}[1], xc($_), xc($alt));
      }
    }
  }
  &CheckMIME($opt_mime, 'HTTPX|Xwb_');
  &Whine($., 'http-head-charset', '', xc('CHARSET')) if $opt_base && $xml && $opt_charset eq '' && !$opt_igncharset; # $opt_base  URL ẘmFp
  if (!$xcharset && $xhtml) {
    if ($xml || $opt_charset eq '') {
      &Whine($., 'xml-encoding', ${$::doctypes{$rule}}{group});
    }
  }
  if (!$opt_igncharset) {
    if (${$::doctypes{$rule}}{restrict} & $::restrictsjisutf) {
      if ($textcode eq 'jis' || $textcode eq 'euc') {
        &Whine($., 'jpo-shift-jis', '', ${$::doctypes{$rule}}{guide}, 'Shift JIS ܂ UTF-8');
      }
    }
    if (${$::doctypes{$rule}}{restrict} & $::restrictsjiseuc) {
      if ($textcode eq 'jis' || $textcode eq 'utf8') {
        &Whine($., 'jpo-shift-jis', '', ${$::doctypes{$rule}}{guide}, 'Shift JIS ܂ EUC');
      }
    }
    if (${$::doctypes{$rule}}{restrict} & $::restrictsjis) {
      if ($textcode eq 'jis' || $textcode eq 'euc' || $textcode eq 'utf8') {
        &Whine($., 'jpo-shift-jis', '', ${$::doctypes{$rule}}{guide}, 'Shift JIS');
      }
    }
    my $textcode2 = $textcode;
    $textcode2 =~ tr/a-z/A-Z/;
    $textcode2 = 'Shift JIS' if $textcode2 eq 'SJIS';
    $textcode2 = 'UTF-8'     if $textcode2 eq 'UTF8';
#   if ($textcode eq 'jis' || $textcode eq 'sjis' || $textcode eq 'euc') {
#     &Whine($seenXml, 'xmldecl-encoding', $textcode2) if $seenXml && $xcharset eq '';
#   }
    if ($jcharcode && $textcode && $jcharcode ne $textcode) {
      if ($opt_charset ne '') {
        &Whine($., 'charset-mismatch', $charset, $textcode2, 'HTTPX|Xwb_');
      } else {
        &Whine($seenCharset, 'charset-mismatch', $charset, $textcode2);
      }
    }
    if ($opt_charset ne '' && $opt_charset !~ /^($charsets)$/oi) {
      &Whine($., ($opt_charset =~ /^x-/i)?
                  'no-registered-charset-ex':
                  'no-registered-charset', '', 'HTTPX|Xwb_', $opt_charset);
    }
  }
  &Whine($refreshHTML[0], 'refresh-link', xc($tag), xc('HTTP-EQUIV'), xc('REFRESH'),
                                          xc('CONTENT').'="`"') if @refreshHTML;
  foreach (0, 1) {
    if (($lcase[$_] && $ucase[$_]) || $xcase[$_]) {
      $ln = $xcaseln[$_];
      $ln = $lcaseln[$_] if $lcase[$_] && $lcase[$_] <= $ucase[$_];
      $ln = $ucaseln[$_] if $ucase[$_] && $ucase[$_] <= $lcase[$_];
      &Whine($ln, 'mixed-case', $_? '': 'vf');
    }
  }
  foreach (reverse @markedSection) {
    &Whine($., 'unclosed-marked-section', '', $_->[1], $_->[0]);
  }
  if (${$::doctypes{$rule}}{doclimit} &&
      ${$::doctypes{$rule}}{doclimit}*1024 < $readsize) {
    &Whine($., 'over-file-size', '', ${$::doctypes{$rule}}{guide},
                                     ${$::doctypes{$rule}}{doclimit});
  }
  &Whine($., 'over-limit-whines', $opt_limit) if $over;
  $ln = $.;
  my $kind = scalar(keys %seenAllTags);
  if ($opt_stat) {
    $::seenMultiBody{$multibody}++ if $multibody > 1;
    $::seenTagsKind{$kind}++;
    foreach (keys %seenAllTags) {
      $::seenTagsStat{$_} += $seenAllTags{$_} unless m#$nameSep#o;
    }
  }
  print "panalty=$penalty+$upenalty/lines=$ln/tags=$tagscnt/kind=$kind" if $opt_dbg;
  if ($penalty+$upenalty) {
    my $weight = $tagscnt+($kind+13)/29; # 16(=29-13)ʂ̓^O̎ނ~
#   my $threshold = 200;
#   if ($tagscnt > $threshold) {
#     $weight += $tagscnt*sqrt($tagscnt-$threshold)/$threshold;
#   }
    $penalty = int((1-$penalty/$weight)*100 -$upenalty);
    $penalty = 99 if $penalty == 100;
    if ($penalty < 80) {
      # (80, 80), (0, -$c) ʂA(80, 80) ̌X 1  sqrt Ȑ
      my $c = -5;
      my $a = $c/6400;
      my $b = (1-$c/40)/$a;
      $penalty = int((-$b-sqrt($b*$b-4*($c-$penalty)/$a))/2);
    }
    if    ($maxpnt >= 9) { $penalty -= 27 }
    elsif ($maxpnt >= 8) { $penalty -= 24 }
    elsif ($maxpnt >= 7) { $penalty -= 21 } # 7ȏ͕@ᔽ
    elsif ($maxpnt >= 6) { $penalty -= 4 }
    elsif ($maxpnt >= 5) { $penalty -= 3 }
    elsif ($maxpnt >= 4) { $penalty -= 2 }
    elsif ($maxpnt >= 3) { $penalty -= 1 }
  } else {
    $penalty = 100;
  }
  print "/score=$penalty\n" if $opt_dbg;
  if ($whinescnt || !$opt_scorenowhines) {
    if ($opt_banner) {
      if ($whinescnt) {
        print $whinescnt, ''.($over?'ȏ':'').'̃G[܂',
              ($opt_score && $penalty >= 100)? 'A': 'B';
      } else {
        print 'G[͌܂łB_(^o^)^ ';
      }
    }
    if ($opt_score) {
      if ($opt_scoreonly) {
        print $penalty;
      } else {
        print 'HTML ', $penalty, '_łB';
        print '^O ', $kind, ' ', $tagscnt, 'ggĂ܂B' if !$over;
        if (!$opt_igncharset) {
          my $code = ($textcode eq 'jis')? 'JIS (ISO-2022-JP)':
                     ($textcode eq 'sjis')? 'Shift JIS':
                     ($textcode eq 'euc')? 'EUC-JP':
                     ($textcode eq 'utf8')? 'UTF-8': undef;
          print 'R[h ', $code, ' ̂悤łB' if $code;
        }
      }
    }
    if ($opt_banner || $opt_score) {
      print "\n" unless $opt_scoreonly;
      print "\n" if $opt_echoname;
    }
  }
  if ($opt_linklist && %URLcollection) {
    print $htmlfile.' ɂ͈ȉ̃N܂܂Ă܂B'."\n";
    foreach (sort { my $ah = $a =~ /^$::httpSchemes/o;
                    my $bh = $b =~ /^$::httpSchemes/o;
                    $ah <=> $bh or $a cmp $b; } keys %URLcollection) {
      print "$_\n";
    }
  }
  $whinescnt? 1: 0;
}

##################################################
# ^Oǂ
# ^OƂ́AΏI^O܂ŏAsԍƃ^OԂ
# ́A(nnn, TAG) ̌`̃Xgł
# ^OȂƂ nnn  0 ł
# ̂Ƃ悤Ƃ^O TAG ɃZbgĂ邩mȂ

sub ReadTag
{
  my $tags = shift; # ^OZbg
  $pretab = 0;
  my $ln;
  $tags = ($tags =~ /^%(.*)/)? $refParams{$1}: &ExpandInternalElements($tags);
  if ($tags =~ /^R?CDATA$/) {
    #$ln = $.;
    &ReadCDATA($tags);
    return (0, $TAG);
  }
  my $oldxmlns = $xmlns;
  local $xmlns = $oldxmlns;
  my $id = &GetTag;
  local $TAG = uc($id);
  local $oTAG = $xhtml? $id: $TAG;
  local $atag = $TAG; # XMLNS:namespace ɑΉ邽߂̑\
  local $minetag;
  local (%seenAttrs, %seenAttrsOrg);
  $needprchar = 0 unless $token =~ /^<A(?:\s|>|$)/i;
  $ln = $.;
  local $unknownTag = 0;
  my %oldbgcolor = %bgcolor;
  local %bgcolor = %oldbgcolor;
  if ($TAG eq '') {
    #  $appElem ͗LȓeȂƂɖ[vh
    &GetLine ne '' || !$appElem++ || return (0, '');
    $ln = $.;
    $TAG = '#PCDATA';
  } else {
    if ($TAG =~ m#^/#) {
      if ($#tagsNest >= 0) {
        # ł͏I^O͏łȂ
        &UnGetToken;
        return (0, $TAG);
      }
    } else {
      if ($xhtml && $id ne lc($id)) {
        &Whine($., 'lower-case-tag', '', $id) if uc($id) =~ /^(?:$allTags)$/;
      }
      my $unknown;
      if ($TAG =~ /^([^:]+):/) {
        # IE5  XMLNS:namespace Ή
        my $xmlns = $1;
        $unknown = 1;
        foreach (@xmlns) {
          if ($xmlns eq $_) {
            $unknown = 0;
            $atag = ':XMLNS:';
            $tagsElements{$TAG} = $tagsElements{$atag};
            &Whine($., 'unsupported-tag', xc($TAG));
            last;
          }
        }
      } else {
        $unknown = $TAG !~ /^(?:$allTags)$/ && !$xmlns;
      }
      if ($unknown) {
        # sȃ^O
        if ($TAG eq '!DOCTYPE') {
          &Whine($., 'misplaced-doctype');
          &AdvanceCloseTag($TAG, $.);
          return ($ln, $lastTag = $TAG);
        }
        $unknownTag++;
        if (&WhineUnknownElement($id)) {
          # HTML̗vf
          $seenAllTags{$TAG}++;
          $tagscnt++;
          $unknownTag++;
        }
      }
    }
  }
  my $omitstart = '';
  my $omitstart_trivial = 0;
  my $allow = 0;
  my $unget = 0;
  my $errHtml = 0;
  if (!$unknownTag) {
    if ($#tagsNest != -1) {
      # Jn^Ȍȗ $omitStartTags ɂ^OŎ̂ꂩ̂Ƃɉ\Ƃ
      #   $tags  1 ^ÔƂ
      #   ^ÔƂ
      #   ȗ\ȃ^OЂƂłɂ $TAG 悤ɂȂƂ
      if (@seq) {
        my $stag = ($seqid == -1)? '': &ExpandInternalElements($seq[$seqid]);
        my $parent = $tagsNest[$#tagsNest]{tag};
        if ($stag ne '' && $TAG =~ /^(?:$stag)$/ &&
            $TAG !~ /^(?:$onceonlyTags{$parent})$/) {
          # ̃^O͂ɏ
        } else {
          foreach my $i ($seqid+1..$#seq) {
            $stag = &ExpandInternalElements($seq[$i]);
            last if $TAG =~ /^(?:$stag)$/;
            next unless $seq[$i] =~ /^(?:$requiredTags{$parent})$/;
            foreach (split(/\|/, $stag)) {
              if (/^(?:$omitStartTags)$/) {
                $omitstart = $_;
                $seqid = $i;
                # ̔肠܂ (TBODYΉ)
                $omitstart_trivial = 1 if $#tagsNest > 0;
                last;
              }
            }
            last if $omitstart;
          }
        }
      } else {
        if ($tags =~ /\|/) {
          # ̏͂
          # Cougar09/04  TABLE z肵Ă邪ATBODY ̏֌WȂǌĂȂ
          foreach (split(/\|/, $tags)) {
            if (/^(?:$omitStartTags)$/) {
              $omitstart = $_;
              $omitstart_trivial = 1 if $#tagsNest > 0;
              last;
            }
          }
        } else {
          $omitstart = $tags if $tags =~ /^(?:$omitStartTags)$/;
        }
      }
    }
    if ($TAG ne '') {
      foreach (reverse @inclNest) {
        if ($TAG =~ /^(?:$_)$/) {
          $allow = 1;
          last;
        }
      }
    }
    if (!$allow) {
      my ($exclude, $exclude_force) = (-1, -1);
      # ֎~Ă^O𒲂ׂ (납)
      foreach (reverse 0..$#exclNest) {
        if ($TAG =~ /^(?:$exclNest[$_])$/) {
          if ($omitstart) {
            # Jn^OȗłƂ͂ꂪꂽƂď𑱂
            $unget++;
            last;
          }
          if (&OmitEndTag($_)) {
            # I^OȗłƂ͏I
            &UnGetToken;
            return (0, $TAG);
          }
          $exclude_force = $exclude = $_+1;
          last;
        }
      }
      if (!$unget && $tags ne 'ANY' && ($TAG eq '' || $TAG !~ /^(?:$tags)$/)) {
        # ɂ͏Ȃ^O
        if ($omitstart) {
          #  $tags ꂽƂď
          $unget++;
          $exclude = -1;
        } else {
          if (&OmitEndTag($#tagsNest)) {
            # I^OȗłƂ͏I
            &UnGetToken;
            return (0, $TAG);
          }
          $exclude = $#tagsNest+1;
        }
      }
      my ($parent, $pln);
      if ($exclude == -1) {
        ($parent, $pln) = ($tagsNest[$#tagsNest]{tag}, $tagsNest[$#tagsNest]{n})
          if $#tagsNest != -1;
        if ($unget || ($omitstart && $omitstart ne $TAG &&
            $omitstart =~ /^(?:$requiredTags{$parent})$/)) {
          # ȗĂȗ\ȃ^OKvȂƂ͂ꂪꂽƂď𑱂
          &UnGetToken;
          $TAG = $omitstart;
          &Whine($., $omitstart_trivial? 'omit-start-tag-trivial':
                                         'omit-start-tag', xc($TAG));
          $unget++;
        }
      } elsif ($exclude-- == 0) {
        # ȗs <HTML> ȗꂽP[X
        &UnGetToken;
        $TAG = $tags;
        &Whine($., ($TAG =~ /^(?:$omitStartTags)$/)?
                   'omit-start-tag': 'required-start-tag', xc($TAG));
        $unget++;
      } else {
        # Ȃ^Oɑ΂x
        ($parent, $pln) = ($tagsNest[$exclude]{tag}, $tagsNest[$exclude]{n});
        my ($msg, @cand);
        if ($TAG ne '#PCDATA') {
          foreach my $x (reverse 0..$exclude-1) {
            @cand = grep((!/^$internalElem$/o &&
                          $TAG =~ /^(?:$tagsElements{$_})$/ &&
                          $tagsElements{$_} !~ /^(?:$deprecatedTags)$/),
                           split(/\|/, $tagsElements{$tagsNest[$x]{tag}}));
            last if @cand;
          }
          if (@cand) {
            $msg = &Join('|', @cand);
            if ($exclude_force == -1 &&
                $msg !~ /\|/ && $msg =~ /^(?:$omitStartTags)$/ &&
                $TAG =~ /^(?:$tagsElements{$msg})$/ &&
                $msg =~ /^(?:$tagsElements{$lastTag})$/) {
              # ₪ЂƂłꂪȗ\ŁA
              # ̌ɏƂłƂ́A
              # ɂꂪꂽƂď
              &UnGetToken;
              $TAG = $omitstart = $msg;
              &Whine($., 'omit-start-tag', xc($TAG));
              $unget++;
              $exclude = -1;
            } else {
              $msg = ($#cand >= 5)? '': # ܂₪Ƃ͏oȂ
                     &FormatTagGuide($msg, '%s ɂȂ珑܂B');
            }
          }
        }
      }
      if ($exclude != -1) {
        foreach (reverse 0..$exclude-1) {
          last unless $tagsNest[$_+1]{tag} =~ /^(?:$omitEndTags)$/;
          if ($TAG =~ /^(?:$tagsElements{$tagsNest[$_]{tag}})$/) {
            # eȗƏ悤ɂȂ^O
            &UnGetToken;
            return (0, $TAG);
          }
        }
        if ($TAG ne '#PCDATA') {
          my $msg;
          &::PushStat('ExcludedElement', $parent.' '.$TAG) if $opt_stat;
          if ($TAG =~ /^(?:$pairTags)$/ && $parent =~ /^(?:$tagsElements{$TAG})$/) {
            # ւƏ悤ɂȂ^O
            $msg = xc("<$TAG>").'`'.xc("</$TAG>").'  '.
                   xc("<$parent>").' Ƃ͂ł܂B';
          }
          if ($exclude == $#tagsNest && $TAG eq $parent) {
            if ($TAG ne $HTML) {
              # O^ÔƂ́ȀI^O₤ </A> Ył
              # ʌx点
              &WhineExcludedElement($TAG, $parent, $pln,
                                    xc("</$parent>").' ĂB');
              &UnGetToken;
              return (0, $TAG);
            }
            &WhineExcludedElement($TAG, $parent, $pln, $msg);
            $errHtml = 1;
          } elsif (&WhineExcludedElement($TAG, $parent, $pln, $msg)) {
            &UnGetToken;
            $line = '</'.xc($parent).'>'.$line;
            return (0, $TAG);
          }
          $parent = '';
        }
      }
      if ($parent && $TAG =~ /^(?:$deprecatedElems{$parent})$/) {
        my $elem = ($TAG eq '#PCDATA')? 'ʂ̃eLXg': xc("<$TAG> ");
        &Whine($., 'deprecated-element', '', $elem, xc($parent), $pln);
        &::PushStat('DeprecatedElement', $parent.' '.$TAG) if $opt_stat;
      }
      if ($TAG eq '#PCDATA') {
        &ReadPCDATA;
        if ($pcdata ne '' &&
            ($exclude != -1 || ($tags ne 'ANY' && $TAG !~ /^(?:$tags)$/))) {
          &::PushStat('UnexpectedPCDATA', $tagsNest[$#tagsNest]{tag}) if $opt_stat;
          if (&WhineExcludedElement($TAG, $tagsNest[$#tagsNest]{tag},
                                          $tagsNest[$#tagsNest]{n})) {
            &UnGetToken;
            $line = '</'.xc($parent).'>'.$pcdata.$line;
            return (0, $TAG);
          }
        }
        if ($parent eq 'FIELDSET' && $pcdata ne '') {
          my $legend = 0;
          foreach (0..$seqid) {
            if ($seq[$_] eq 'LEGEND') {
              $legend++;
              last;
            }
          }
          &Whine($., 'fieldset-whitespace', '', xc($parent)) unless $legend;
        }
        return ($ln, $lastTag = $TAG);
      }
    }
  }
  if (!$unget) {
    my $badInner = '';
    if (!$unknownTag && $TAG ne $HTML) {
      if (@seq) {
        # ^Ȍo𒲂ׂ
        # @seq  $seqid ̎ɒ
        # @seq ɂ #XXX Ƃ̂Ă邪̂܂܂ō\Ȃ
        my ($where, $stag, $rtag, @last);
        my $parent = $tagsNest[$#tagsNest]{tag};
        foreach $where ($seqid..$#seq) {
          next if $where == -1;
          $stag = &ExpandInternalElements($seq[$where]);
          unless ($TAG =~ /^(?:$stag)$/) {
            if ($where == $#seq) {
              my $err = 0;
              foreach (reverse 0..$#seq-1) {
                $stag = &ExpandInternalElements($seq[$_]);
                if ($err) {
                  push(@last, $stag);
                  if ($seq[$_] =~ /^(?:$requiredTags{$parent})$/) {
                    $err = -1;
                    last;
                  }
                } elsif ($TAG =~ /^(?:$stag)$/) {
                  $err++;
                }
              }
              push(@last, '') if $err > 0;
            }
          } else {
            my $err = 0;
            if ($where == $seqid) {
              if ($TAG =~ /^(?:$onceonlyTags{$parent})$/) {
                $err = $where;
                my $last = '';
                foreach (@seq) {
                  push(@last, $last) if $_ eq $TAG && $last !~ /^#/;
                  $last = $_;
                }
              }
            } else {
              foreach ($seqid+1..$where-1) {
                if ($seq[$_] =~ /^(?:$requiredTags{$parent})$/) {
                  $err = $_;
                  push(@last, &ExpandInternalElements($seq[$_]));
                }
              }
            }
            unless ($err) {
              undef @last;
              $seqid = $where;
              last;
            }
          }
        }
        if (@last) {
          my $last = join('|',
            map { (($_ eq '')? $parent: /^(?:$pairTags)$/? "/$_": $_) } @last);
          &Whine($., 'must-follow', xc($TAG), &FormatTagGuide($last));
          &::PushStat('MustFollow', $TAG.' '.$last) if $opt_stat;
        }
      }
#     # ̃^OɂȂ^Oׂ
#     my $badInner = '';
#     foreach (keys %::innerElements) {
#       if ($TAG =~ /^(?:$::innerElements{$_})$/) {
#         $badInner = $_;
#         foreach (reverse @tagsNest) {
#           if ($badInner eq $$_{tag}) {
#             $badInner = '';
#             last;
#           }
#         }
#         if ($badInner ne '') {
#           &Whine($., 'misplaced-element', xc($TAG), xc($badInner));
#           last;
#         }
#       }
#     }
      # E߂Ȃ^Oׂ
      if ($TAG =~ /^(?:$deprecatedTags)$/) {
        my $alt = '';
        my $whine = 'deprecated-tag';
        foreach (keys %::altDeprecated) {
          if ($TAG =~ /^(?:$_)$/) {
            $alt = $::altDeprecated{$_};
            if ($alt eq 'css') {
              $whine = 'deprecated-tag-css';
#             &::PushStat('DeprecatedTagCSS', $TAG) if $opt_stat;
            } elsif ($alt eq 'css2') {
              $whine = 'deprecated-tag-css2';
#             &::PushStat('DeprecatedTagCSS', $TAG) if $opt_stat;
            } else {
              $alt = xc("<$alt>").(($htmlVer >= 4 && $alt =~ /ALIGN/)?
                                   ' X^CV[gg܂傤B':
                                   ' g܂傤B');
            }
            last;
          }
        }
        &Whine($., $whine, xc($TAG), $alt);
        &::PushStat('DeprecatedTag', $TAG) if $opt_stat && $whine eq 'deprecated-tag';
      }
      # wfBȌ𒲂ׂ
      if ($TAG =~ /^H(\d)$/) {
        my $level = $1;
        if ($headingStart <= $#headingLevel) {
          my $last = $headingLevel[$#headingLevel];
          if ($last->[0] and $last->[0]+1 < $level) {
            &Whine($., 'heading-order', xc($TAG), xc('H'.$last->[0]), $last->[1]);
          } else {
            foreach (reverse $headingStart..$#headingLevel) {
              last if $level >= $last->[0];
              pop(@headingLevel);
            }
          }
        }
        push(@headingLevel, [ $level, $. ]);
      }
    }
    # gׂłȂ^O
    &Whine($., 'should-not-use', xc($TAG)) if $TAG =~ /^(?:$::shouldNotUse)$/o;
    # 𒲂ׂ
    local ($ATTR, $oATTR, $subATTR, $value);
    while (&GetAttrName ne '') {
      my $sp = $line =~ /^(?:\s|$)/;
      my $orgvalue = '';
      if (&GetLine =~ /^=($allc*)/o) {
        #  = l
        $line = $1;
        if ($sp || $line =~ /^(?:\s|$)/) {
          &Whine($., 'space-around-equal', xc($TAG), xc($ATTR));
        }
        $orgvalue = $value = &GetAttrValue;
        &CheckAttribute($TAG, $ATTR) || next;
        ($_ = $TagAttrCheckers{$TAG.$nameSep.$ATTR}) and &$_;
        ($_ = $AttrCheckers{$ATTR}) and &$_;
        # ̔ '%Script' v (Kt@Cɂ̎ʂ)
        &CheckAttrINTRINSIC
          if $tagsAttributes{$atag}->{$ATTR} =~ /^\%Script(?:\.datatype)?$/o;
      } else {
        # ȗĂꍇ
        $line = ' '.$line if $sp;
        ($_ = $TagAttrCheckers{$TAG.$nameSep.$ATTR}) and &$_;
        if ($ATTR =~ /:$/) {
          # IE5  XMLNS:namespace Ή
          $value = '';
        } else {
          $value = $ATTR;
          &Whine($., 'no-minimization', xc($TAG), xc($value)) if $xhtml;
          ($_ = $AttrCheckers{$ATTR}) and &$_;
          my ($akey, $avals) = ('', '');
          my $attrval = \%{$tagsAttributes{$TAG}};
          foreach (keys %{$attrval}) {
            # w肳ꂽlT
            $ATTR = $_;
            $avals = $attrval->{$ATTR};
            next if $avals =~ /=/;
            if ($avals =~ /^%(.*)/) {
              # ł <TABLE BORDER> ̂悤ȏ𔻒肷
              # IȊO񐳋K\ƂĔr quotemeta ł͂
              my $x = $refParams{$1};
              $x =~ s/([^\w\(\|\)])/\\$1/g;
              if ($value =~ /^(?:$x)$/i) {
                $akey = $ATTR;
                last;
              }
            }
            if ($avals !~ /^(?:$charData)$/oi && $value =~ /^(?:$avals)$/i) {
              if ($akey) {
                # l݂
                $akey = '';
                last;
              }
              $akey = $ATTR;
            }
          }
          if ($akey eq '') {
            if ($tagsAttributes{$atag}->{$value} ne '') {
              # ľ\Ă悢
              &Whine($., 'required-value', xc($TAG), xc($value));
              &::PushStat('RequiredValue', $TAG.' '.$value) if $opt_stat;
            } else {
              &WhineUnknownAttribute($TAG, $value);
            }
            next;
          }
          unless ($value =~ /^$akey$/i) {
            &Whine($., 'omit-attribute-name', xc($TAG), xc($akey), $value);
            &::PushStat('OmitAttributeName', $TAG.' '.$value) if $opt_stat;
          }
          $ATTR = $akey;
        }
      }
      if ($ATTR =~ /^(?:$deprecatedAttrsCss{$TAG})$/i) {
        # E߂Ȃ (X^CV[g)
        &Whine($., 'deprecated-attribute-css', xc($TAG), xc($ATTR));
#       &::PushStat('DeprecatedAttrCSS', $TAG.' '.$ATTR) if $opt_stat;
      } elsif ($ATTR =~ /^(?:$deprecatedAttrs{$TAG})$/ ||
               $ATTR =~ /^(?:$deprecatedAttrs{'*'})$/) {
        # E߂Ȃ
        # <SCRIPT LANGUAGE> ́A<SCRIPT TYPE> Ζ_Ƃ
        # ͕̏ʂ̏ꏊōsȂ
        unless ($TAG eq 'SCRIPT' && $ATTR eq 'LANGUAGE') {
          &Whine($., 'deprecated-attribute', xc($TAG), xc($ATTR));
        }
        &::PushStat('DeprecatedAttr', $TAG.' '.$ATTR) if $opt_stat;
      }
      &Whine($., 'repeated-attribute', xc($TAG), xc($ATTR))
        if defined($seenAttrs{$ATTR});
      $seenAttrs{$ATTR.$subATTR} = $value;
      if ($orgvalue ne '') { $seenAttrsOrg{$ATTR.$subATTR} = $orgvalue; }
    } # &GetAttrName
    # tHg^Oׂ
    if ($::physicalFontElements{$TAG} && !$seenAttrs{CLASS}) {
      my @p = grep(/^(?:$allTags)$/,
                   split(/\|/, $::physicalFontElements{$TAG}));
      &Whine($., 'physical-font', xc($TAG),
                 &FormatTagGuide(&Join('|', @p), 'Ⴆ %sB')) if @p;
    }
    if ($textcode =~ /^(?:jis|euc|sjis)$/ && ${$lang}{val} ne '') {
      # {ȊOw肳ĂƂɑl̕R[h𒲂ׂ
      foreach (keys %seenAttrs) {
        my $v = $seenAttrsOrg{$_};
        if ($v eq '') { $v = $seenAttrs{$_}; }
        if (&CheckLanguageCode($v)) {
          &WhineLanguageCode($ln, 'lang-attribute', $TAG, $_);
        }
      }
    }
    if ($tagsAttributes{$TAG}->{LANG} && $tagsAttributes{$TAG}->{'XML:LANG'}) {
      my $seens = ($seenAttrs{LANG} ne '')+($seenAttrs{'XML:LANG'} ne '');
      if ($TAG ne $HTML && $seens == 1) {
        my ($seen, $noseen) = ($seenAttrs{LANG} ne '')? ('LANG', 'XML:LANG'): ('XML:LANG', 'LANG');
        &Whine($., 'lang', xc($TAG), xc($seen), xc($noseen));
      }
      if ($seens == 2 && $seenAttrs{LANG} ne $seenAttrs{'XML:LANG'}) {
        &Whine($., 'lang-mismatch', xc($TAG), xc('LANG'), xc('XML:LANG'));
      }
    }
    return ($ln, $lastTag = $TAG) if $unknownTag || $errHtml;
    if ($TAG =~ /^(?:$::formControls)$/o) {
      my @label;
      if (@seenLabel) {
        # x̃tH[Rg[𒲂ׂ
        @label = @seenLabel;
        &Whine($., 'label-control', xc($TAG), $seenLabel[0], xc('LABEL'),
                                    $ctrlLabel[0], xc($ctrlLabel[1]))
          if @ctrlLabel;
        if ($seenLabel[1] ne '') {
          &Whine($., 'label-for-control', xc($TAG), $seenLabel[0],
                       xc('LABEL'), xc('FOR'),
                       (($seenAttrs{ID} eq '')? 'w肳ĂȂ ': ' ').xc('ID'))
            if uc($seenLabel[1]) ne uc($seenAttrs{ID});
        }
        @ctrlLabel = ($., $TAG);
      }
      if (!$disabled && $TAG =~ /^(?:$::recommendedAccesskey)$/o) {
        # Rg[ɑΉ郉xT
        my @ctrl = ($., $TAG, $seenAttrs{ID}, $seenAttrs{ACCESSKEY});
        @label = &SearchLabel(@ctrl) unless @label;
        if (@label) {
          # Ή郉xłɂ
          &CheckAccesskey(\@label, \@ctrl);
        } else {
          # Ή郉x܂Ȃ (ivɂȂmȂ)
          push(@ctrlLabels, [@ctrl])
            if $TAG ne 'INPUT' || uc($seenAttrs{TYPE}) ne 'HIDDEN';
        }
      }
    }
    # K{𒲂ׂ
    foreach (split(/&/, $requiredAttrs{$TAG})) {
      if (/\|/) {
        my $req = $_;
        foreach (keys %seenAttrs) {
          if (/^(?:$req)$/) {
            $req = '';
            last;
          }
        }
        if ($req) {
          &Whine($., 'required-attribute', xc($TAG), &FormatAttrGuide($req));
          &::PushStat('RequiredAttr', $TAG.' '.$req) if $opt_stat;
        }
      } elsif (!defined($seenAttrs{$_})) {
        &Whine($., 'required-attribute', xc($TAG), xc($_));
        &::PushStat('RequiredAttr', $TAG.' '.$_) if $opt_stat;
      }
    }
    ($_ = $TagCheckers{$TAG}) and &$_;
    if ($htmlVer >= 4 && $TAG =~ /^(?:$::deprecatedName)$/o &&
          $tagsAttributes{$TAG}->{NAME} ne '') {
      my $name = $seenAttrs{NAME};
      my $id   = $seenAttrs{ID};
      if ($name ne '') {
        if ($id ne '') {
          if ($name ne $id) {
            &Whine($., 'diff-id-link', xc($TAG), xc('NAME'), $name, xc('ID'), $id);
            $seenAnchorsIN{xc($id)} = $. if !$xhtml && uc($id) eq uc($name);
          } else {
            if (!$xhtml && !$isohtml) {
              &Whine($., 'lower-id', xc($TAG), xc('ID'), $id) if $id =~ /[a-z]/;
            }
          }
        } else {
          if ($xhtml) {
            &Whine($., 'deprecated-attribute',
                   xc($TAG), xc('NAME'), xc('ID').' g܂傤B');
          }
        }
      }
      if (($name eq '')^($id eq '')) {
        &Whine($., 'need-id-name', xc($TAG), xc('NAME'), xc('ID')) if $xhtml || $isohtml;
      }
    }
    if ($badInner eq '' && $TAG =~ /^(?:$::innerElements{FORM})$/o) {
      my $name = $seenAttrs{NAME};
      my $type = uc($seenAttrs{TYPE});
      $type = 'TEXT' if $type eq '';
      if ($name ne '') {
        my ($ln, $chk);
        if ($formNames{$name} =~ /^(\d+)$nameSep($nameStr)(${nameSep}1)?/) {
          ($ln, $chk) = ($1, $3);
          &Whine($., 'repeated-name', xc($TAG), xc('NAME'), $name, $ln)
            if $type ne $2 || $TAG !~ /^(?:INPUT|BUTTON)$/ ||
               $type !~ /^(?:RADIO|CHECKBOX|SUBMIT|RESET|BUTTON|IMAGE|HIDDEN)$/;
        }
        if ($TAG eq 'INPUT' && $type eq 'RADIO' && $seenAttrs{CHECKED} ne '') {
          &Whine($., 'multiple-checked', xc($TAG), xc('TYPE'), $type, xc('CHECKED'), $ln) if $chk;
          $chk = $nameSep.'1';
        }
        $formNames{$name} = $..$nameSep.$type.$chk;
      }
      if ($TAG eq 'INPUT' && $type eq 'TEXT' && !defined($seenAttrs{VALUE})) {
        &Whine($., 'default-text', xc($TAG), xc(' VALUE ').'');
      }
    }
    my $alt = 'ALT';
    if ($tagsAttributes{$atag}->{$alt} ne '' && !defined($seenAttrs{$alt}) &&
        # INPUT  IMAGE ̂Ƃ̂݌x
        ($TAG ne 'INPUT' || uc($seenAttrs{TYPE}) eq 'IMAGE') &&
        # APPLET  applet-text-equivalent Ōx
        $TAG ne 'APPLET') {
      my $req = $requiredAttrs{$TAG};
      $req =~ s/&/\|/g;
      # %requiredAttrs  ALT ƃG[d̂
      &Whine($., 'img-alt', xc($TAG), xc($alt)) unless $alt =~ /^(?:$req)$/;
    }
    if ($TAG =~ /^(?:$::recommendedWidth)$/o &&
        $tagsAttributes{$TAG}->{WIDTH} ne '' &&
        !($seenAttrs{WIDTH} ne '' && $seenAttrs{HEIGHT} ne '')) {
      &Whine($., 'img-size', xc($TAG), xc('WIDTH'), xc('HEIGHT')) unless $headElements;
    }
    &WhineRecommendedAttribute($., 'TITLE', $::recommendedTitle, 'recommended-title');
    &WhineRecommendedAttribute($., 'TITLE', $::recommendedFrameTitle, 'frame-title');
    &WhineRecommendedAttribute($., 'SUMMARY', $::recommendedSummary, 'table-summary');
    &WhineRecommendedAttribute($., 'ABBR', $::recommendedAbbr, 'abbr-header-label');
    unless ($disabled) {
      &WhineRecommendedAttribute($., 'ACCESSKEY', $::recommendedAccesskey,
                                 ($TAG eq 'A')? 'link-accesskey': 'form-accesskey')
        if $TAG !~ /^(?:$::formControls)$/o && # tH[Rg[͕ʎd
           $tagsAttributes{$TAG}->{HREF} eq '' || $seenAttrs{HREF} ne '';
      &WhineRecommendedAttribute($., 'TABINDEX',
                                 $::recommendedTabindex, 'form-tabindex');
    }
    if ($TAG =~ /^(?:$::cuddleContainers)$/) {
      &Whine($., 'container-whitespace', xc($TAG), '擪') if $line =~ /^\s/;
    }
    &WhinePairEvent($., 'ONMOUSEDOWN', 'ONKEYDOWN');
    &WhinePairEvent($., 'ONMOUSEUP', 'ONKEYUP');
    &WhinePairEvent($., 'ONCLICK', 'ONKEYPRESS');
    $seenAllTags{$TAG}++;
    $tagscnt++;
  } # $unget
  $lastTag = $TAG;
  if (!($TAG =~ /^(?:$emptyTags)$/ && !$tagsElements{$TAG}) || $xmlns) {
    push(@tagsNest, { tag=>$TAG,
                      n=>$.,
                      lang=>$lang,
                      xmlns=>$xmlns,
                      ahref=>$ahref,
                      attrs=>\%seenAttrs });
    if ($#tagsNest >= 100) {
      &Whine($., 'tags-nest', xc($TAG)) unless $tagsNestWhine++;
    } else {
      $tagsNestWhine = 0;
    }
    push(@inclNest, $includedElems{$TAG});
    push(@exclNest, $excludedElems{$TAG});
    local ($lastPairTag, $lastOmitTag) = ('', $omitstart);
    local (@innerTags, %seenTags, @seq);
    local $seqid = -1;
    my $lastTagElements = $thisTagElements;
    local $thisTagElements = $tagsElements{$TAG};
    if ($headElements && $TAG eq 'OBJECT') {
      # HEAD  OBJECT vfɂ͂قƂǉȂ
      push(@exclNest, &Join('|', pop(@exclNest),
              grep(!/^(?:$headElements|PARAM)$/, split(/\|/, $thisTagElements))));
    }
    if ($TAG =~ /^(?:INS|DEL)$/ && $#tagsNest > 0) {
      # HTML4.0 ł INS  DEL ̗vf𒲐
      $thisTagElements = &Join('|',
              grep(/^(?:$lastTagElements)$/, split(/\|/, $thisTagElements)));
    }
    @seq = split(/\|/, $thisTagElements) if $TAG =~ /^(?:$sequencialTags)$/;
    my $tableInfoSave = $#tableInfos;
    my $tableCellSave = $tableCell;
    if ($TAG eq 'TABLE') {
      push(@tableInfos, [@tableInfo]);
      @tableInfo = ();
      $tableCell = 0;
    } elsif ($TAG eq 'HEAD') {
      $headElements = $thisTagElements;
    }
    my $headingStartSave = $headingStart;
    $headingStart = $#headingLevel+1 if $TAG =~ /^(?:$::headingBlocks)$/;
    TAGSLOOP:
    while ($whinescnt < $opt_limit) {
      while () {
        last TAGSLOOP if $whinescnt >= $opt_limit;
        local ($ahref, %alt);
#       local $titleattr;
        my $olddisabled = $disabled;
        my ($rln, $read) = &ReadTag($thisTagElements);
        $disabled = $olddisabled;
        $needprchar = $ahref if $read eq 'A';
        last unless $rln;
        if ($read eq '#PCDATA') {
          push(@innerTags, {tag=>$read, data=>$pcdata});
          if ($TAG eq 'TITLE') {
            &Whine($., 'title-length', xc($TAG), 64) if &StrLength($pcdata) > 64;
          }
          foreach (0..$#seenObject) {
            $seenObject[$_]->{app} = $.;
          }
        } else {
          if ($read =~ /^(?:IMG|OBJECT|APPLET)$/) {
            foreach (0..$#seenObject) {
              $seenObject[$_]->{app} = $.;
            }
          }
          push(@innerTags, {tag=>$read, data=>$alt{value}, alt=>\%alt});
          $lastPairTag = $read if $read =~ /^(?:$pairTags)$/;
          my $once = $onceonlyTags{$TAG};
          $once = &ExpandOnceonlyElements($once) if $TAG eq 'RUBY'; # i
          if ($read =~ /^(?:$once)$/) {
            if ($seenTags{$read}) {
              my @once = ($once =~ /\b($read)\b/g);
              if ($#once == 0) {
                &Whine($rln, 'once-only', xc($read), xc($TAG), $seenTags{$read});
                &::PushStat('OnceOnly', $read) if $opt_stat;
              }
            }
          } else {
            ONCELOOP:
            while ($once =~ /($internalElem)(.*)/o) {
              $once = $2;
              my $ext = $tagsElements{$1}; # i̓WĴ
              if ($read =~ /^(?:$ext)$/) {
                if ($seenTags{$read}) {
                  if ($read !~ /^(?:COL|COLGROUP)$/) { # R[h
                    &Whine($rln, 'once-only', xc($read), xc($TAG), $seenTags{$read});
                    &::PushStat('OnceOnly', $read) if $opt_stat;
                  }
                  last ONCELOOP;
                }
                foreach (split(/\|/, $ext)) {
                  if ($seenTags{$_}) {
                    if ($read ne $_) {
                      &Whine($rln, 'once-only-group',
                                   xc($read), xc($TAG), $seenTags{$_}, xc($_));
                      &::PushStat('OnceOnlyGroup', (($read lt $_)?
                                  $read.' '.$_: $_.' '.$read).' '.$TAG) if $opt_stat;
                    }
                    last ONCELOOP;
                  }
                }
              }
            }
          }
          $seenTags{$read} = $rln;
        }
      }
      if (&ReadEndTag) {
        foreach (split(/\|/, $requiredTags{$TAG})) {
          my $req = $_;
          if (/^$internalElem$/o) {
            $req = &ExpandInternalElement($req);
            foreach (split(/\|/, $req)) {
              if ($seenTags{$_}) {
                undef $req;
                last;
              }
            }
          } else {
            undef $req if $seenTags{$req};
          }
          if ($req && $req !~ /#PCDATA/) {
            my $msg = &FormatTagGuide($req, '', 5);
            $msg .= ' ' if $msg =~ />$/;
            &Whine($., 'required', xc($TAG), $msg);
            &::PushStat('Required', $TAG.' '.$req) if $opt_stat;
          }
        }
        if (!@innerTags) {
          if ($TAG !~ /^(?:$maybeEmpty)$/ && $tagsElements{$TAG}) {
            &Whine($., 'empty-container', xc($TAG));
            &::PushStat('EmptyContainer', $TAG) if $opt_stat;
          }
          if ($TAG eq 'TEXTAREA') {
            &Whine($., 'default-text', xc($TAG));
#         } elsif ($TAG eq 'OBJECT') {
#           &Whine($., 'recommended-title', xc($TAG), xc('TITLE'),
#                      $headElements? '': 'e') unless $titleattr;
          }
        } else {
          if ($#innerTags == 0) {
            if ($TAG eq 'A') {
              my $href = $linkInfo{href};
              if ($href ne '' && $innerTags[0]->{tag} eq '#PCDATA') {
                my $data = $innerTags[0]->{data};
                my $title = $linkInfo{title};
                $title = '' unless defined($title);
                if (defined($linkText{$data}) &&
                    defined($linkText{$data}->{$title}->{href}) &&
                    !CompareURL($linkText{$data}->{$title}->{href}, $href)) {
                  &Whine($., 'same-link-text', xc($TAG), $data, $linkText{$data}->{$title}->{n});
                }
                $linkText{$data}->{$title} = {n=>$., href=>$href};
              }
            }
            my $alt = $innerTags[0]->{alt};
            if ($alt->{n} && $alt->{value} =~ /^\s*$/) {
              if ($TAG eq 'A') {
                &Whine($alt->{n}, 'link-text-equivalent', xc($TAG), xc($alt->{tag}), xc($alt->{attr}));
              }
              if ($TAG =~ /^H\d$/) {
                &Whine($alt->{n}, 'heading-text-equivalent', xc($TAG), xc($alt->{tag}), xc($alt->{attr}));
              }
            }
          }
#         if ($TAG !~ /^(?:$maybeEmpty)$/ && $tagsElements{$TAG}) {
            my $br = 0;
            my $sp = 0;
            my $spaces = &spaces;
            foreach (@innerTags) {
              if ($_->{tag} eq '#PCDATA') {
                my $data = $_->{data};
                $data =~ s/(?:$spaces)//og;
                $sp++ if $data eq '';
              } elsif ($_ eq 'BR') {
                $br++;
              }
            }
            my $in = $#innerTags+1;
            if ($br) {
              &Whine($., 'br-only-container', xc($TAG), xc('BR'))
                if $TAG =~ /^(P|TD|TH)$/ && $br+$sp == $in;
            } else {
              &Whine($., 'space-container', xc($TAG)) if $sp == $in;
            }
#         }
        }
        undef %linkInfo;
        ($_ = $TagClosing{$TAG}) and &$_;
        # I^Oł甲
        last;
      }
    } # TAGSLOOP
    if ($headingStart != $headingStartSave) {
      splice(@headingLevel, $headingStart);
      $headingStart = $headingStartSave;
    }
    if ($tableInfoSave != $#tableInfos) {
      @tableInfo = @{pop(@tableInfos)};
      $tableCell = $tableCellSave;
    }
    pop(@exclNest);
    pop(@inclNest);
    pop(@tagsNest);
  } # $emptyTag
  $lang = @tagsNest? $tagsNest[$#tagsNest]{lang}: undef;
  ($ln, $TAG);
}

sub spaces
{
  my $spaces = '\s|&nbsp;|&#0*160;|&#[xX]0*[aA]0;';
  $spaces .= '|'.quotemeta('@') if $textcode ne '';
  $spaces;
}

##################################################
# xƃRg[̊֌W𒲂ׂ⏕֐

sub SearchLabel
{
  my $id = $_[2];
  if ($id ne '') {
    foreach (@seenLabels) {
      return @$_ if lc($$_[1]) eq lc($id);
    }
  }
  ();
}

sub CheckAccesskey
{
  my ($label, $ctrl) = @_;
  # @$label == [ ln, for, accesskey ]
  # @$ctrl  == [ ln, tag, id, accesskey ]
  local $TAG = $$ctrl[1];
  if ($$label[2] eq '') {
    &WhineRecommendedAttribute($$ctrl[0], 'ACCESSKEY', $::recommendedAccesskey,
            ($TAG eq 'A')? 'link-accesskey': 'form-accesskey') if $$ctrl[3] eq '';
  } else {
    # if ($$ctrl[3] ne '' && uc($$ctrl[3]) ne uc($$label[2]))
    #   L[HĂ邪Ƃ肠͌xȂ
  }
}

##################################################
# ^O/`FbN֐Q

sub CheckTagAttrBASE_HREF
{
  &Whine($., 'later-base', xc($TAG), xc($ATTR), $seenRelURL) if $seenRelURL;
  if ($value =~ m#^$RFC2396::scheme://.#o) {
    $baseURL = $value;
  } else {
    &Whine($., 'absolute-base-url', xc($TAG), xc($ATTR));
  }
}

sub CheckTagAttrFRAME_NAME
{
  if ($value ne '') {
    &Whine($., 'existing-target-name', xc($TAG), xc($ATTR), $value,
               $seenFrameName{lc($value)}) if $seenFrameName{lc($value)};
    if ($value =~ /^(?:$::reservedFrameNames)$/oi) {
      &Whine($., 'reserved-target-name', xc($TAG), xc($ATTR), $value);
      &Whine($., 'reserved-target-name-upper', xc($TAG), xc($ATTR), $value)
        unless $value =~ /^(?:$::reservedFrameNames)$/o;
    } elsif ($value !~ /^[A-Za-z]/) {
      &Whine($., 'illegal-target-name', xc($TAG), xc($ATTR), $value);
    }
    $seenFrameName{lc($value)} = $.;
  }
}
sub CheckTagAttrFRAME_SRC
{
  if ($value ne '') {
    my ($scheme, $url) = &SplitFragmentID($value);
    &Whine($., 'same-document-frameset', xc($TAG), xc($ATTR), $value) if $url eq '';
  }
}
sub CheckTagAttrA_HREF
{
  my ($scheme, $url, $frgid) = &SplitFragmentID($value);
  if ($frgid =~ /^#(.*)/) {
    $frgid = $1;
    if ($frgid eq '' ) {
      &Whine($., 'empty-fragment-id', xc($TAG));
    } else {
      $hrefAnchors{$frgid} = [ $., $TAG ] if $url eq '';
      if ($frgid =~ /\s/) {
        &Whine($., 'fragment-id-whitespace', xc($TAG), $frgid);
      } elsif ($frgid =~ /%/ || $frgid !~ /^(?:$RFC2396::fragment)$/o) {
        &Whine($., 'unsafe-fragment-id', xc($TAG), $frgid);
      }
    }
  }
  if ($needprchar) {
    &Whine($., 'link-separation', xc($TAG));
    $needprchar = 0;
  }
  $ahref = 1;
}
  sub CheckTagAttrA_iMode
  {
    if ($rule =~ /^imode/) {
      my $array = shift;
      push @$array, {n=>$., tag=>$TAG, attr=>$ATTR, id=>uc($value)};
    }
  }
sub CheckTagAttrA_IJAM { CheckTagAttrA_iMode(\@ijams); }
sub CheckTagAttrA_ISTA { CheckTagAttrA_iMode(\@istas); }
sub CheckTagAttrA_ILET { CheckTagAttrA_iMode(\@ilets); }
sub CheckTagAttrA_ISWF { CheckTagAttrA_iMode(\@iswfs); }
sub CheckTagAttrA_IRST { CheckTagAttrA_iMode(\@irsts); }
sub CheckTagAttrA_CTI
{
  if ($rule =~ /^imode/) {
    &Whine($., 'attribute-format', xc($TAG), xc($ATTR), $value,
               '/ A邱Ƃ͂ł܂B') if $value =~ m#//#;
  }
}
sub CheckTagAttrA_KANA
{
  if ($rule =~ /^imode/) {
    &Whine($., 'attribute-format', xc($TAG), xc($ATTR), $value,
               'pJiłȂ΂Ȃ܂B')
               if $value !~ /^[\xA0-\xDF]+$/;
  }
}
sub CheckTagAttrA_EMAIL
{
  if ($rule =~ /^imode/) {
    &Whine($., 'attribute-format', xc($TAG), xc($ATTR), $value,
               'pn܂ p . - _ ̗ łȂ΂Ȃ܂B')
               if $value !~ /^(?:\d+|[A-Z][\w.\-_]*)$/i;
  }
}
sub CheckTagAttrIMG_ALT
{
#  if ($value ne '') {
#    foreach (0..$#seenObject) {
#      $seenObject[$_]->{app} = $.;
#    }
#  }
}
sub CheckTagAttrIMG_USEMAP
{
  my ($scheme, $url, $frgid) = &SplitFragmentID($value);
  if ($frgid =~ /^#(.*)/) {
    $frgid = $1;
    if ($frgid eq '' ) {
      &Whine($., 'empty-fragment-id', xc($TAG));
    } else {
      $mapAnchors{$frgid} = [ $., $TAG ] if $url eq '';
      if ($frgid =~ /\s/) {
        &Whine($., 'fragment-id-whitespace', xc($TAG), $frgid);
      } elsif ($frgid =~ /%/ || $frgid !~ /^(?:$RFC2396::fragment)$/o) {
        &Whine($., 'unsafe-fragment-id', xc($TAG), $frgid);
      }
    }
  }
  foreach (reverse @tagsNest) {
    if ($$_{tag} eq 'BUTTON') {
      &Whine($., 'button-usemap', xc($$_{tag}), xc($TAG), xc($ATTR));
      last;
    }
  }
}
sub CheckTagAttrIMG_ISMAP
{
  foreach (reverse @tagsNest) {
    if ($$_{tag} eq 'BUTTON') {
      &Whine($., 'button-usemap', xc($$_{tag}), xc($TAG), xc($ATTR));
      last;
    }
  }
  my $badInner = 'A';
  foreach (@tagsNest) {
    if ($badInner eq $$_{tag} && $$_{ahref}) {
      $badInner = '';
      last;
    }
  }
  &Whine($., 'misplaced-element', xc("$TAG $ATTR"), xc($badInner), xc(' HREF')) if $badInner ne '';
}
sub CheckTagAttrIMG_MOTION
{
  if ($rule =~ /^jsky/) {
    undef $seenAttrs{MOTION}; # x MOTION SGMLIdl
  }
}
sub CheckTagAttrOBJECT_TITLE
{
#  $titleattr = $ln;
}
sub CheckTagAttrOPTION_SELECTED
{
print "$.>$TAG:$seenSelect[1]\n";
  if (@seenSelect) {
    if (@selOption && !$seenSelect[1]) {
      my $msg = ($tagsAttributes{SELECT}->{MULTIPLE} ne '')?
                 $seenSelect[0].'sڂ '.xc('<SELECT>').'  '.
                 xc('MULTIPLE').' w肵ĂB': '';
      &Whine($., 'multiple-selected', xc($TAG), xc($ATTR), $selOption[0], $msg);
    }
    @selOption = ($., $TAG);
  }
}
sub CheckTagAttrFONT_COLOR
{
  &CheckBgColor($TAG, $ATTR, $value);
}
sub CheckAttrBGCOLOR
{
  $bgcolor{COL} = &HexColor($value);
  $bgcolor{TAG} = $TAG;
  if ($txcolor ne '') {
    &CheckBgColor('BODY', 'TEXT', $txcolor);
  }
}

sub CheckAttrCLASS
{
  if ($value eq '') {
    my $avals = $tagsAttributes{$TAG}->{$ATTR};
    if ($avals =~ /^%(.*)/ && $refParams{$1} ne 'CDATA+') {
      &Whine($., 'empty-value', xc($TAG), xc($ATTR));
    }
  }
}
sub CheckAttrLANG
{
  $lang = { val=>$value, n=>$., attr=>$ATTR } if !$seenAttrs{'XML:LANG'};
}
sub CheckAttrXMLLANG
{
  $lang = { val=>$value, n=>$., attr=>$ATTR };
}
sub CheckAttrALT
{
  &Whine($., 'alt-spaces', xc($TAG), xc($ATTR)) if $value =~ /^(?:&nbsp;?|\s)+$/;
  if ($tagsNest[$#tagsNest]{tag} =~ /^(A|H\d)$/) {
    if ($1 eq 'A') {
      if ($tagsAttributes{$TAG}->{LONGDESC} ne '' && $value =~ /^D(?:-link)?$/) {
        &Whine($., 'd-link', xc($TAG), xc($ATTR), $value, xc('LONGDESC'));
      }
      if ($value =~ /^\s*($::hereAnchors|$::hereAnchorsJ)\s*$/oi) {
        my $here = $1;
        $here =~ s/^\s+//;
        $here =~ s/\s+$//;
        &Whine($., 'here-anchor-alt', xc('A'), xc($TAG), xc($ATTR), $here);
      }
    }
    %alt = (n=>$., tag=>$TAG, attr=>$ATTR, value=>$value);
  }
}
sub CheckAttrISMAP
{
  &Whine($., 'server-side-image-map', xc($TAG), xc($ATTR));
}
sub CheckAttrTARGET
{
  if ($value =~ /^(?:$::reservedFrameNames)$/oi) {
    &Whine($., 'reserved-target-name-upper', xc($TAG), xc($ATTR), $value)
      unless $value =~ /^(?:$::reservedFrameNames)$/o;
  } else {
    &Whine($., 'illegal-target-name', xc($TAG), xc($ATTR), $value)
      unless $value =~ /^[A-Za-z]/;
  }
}
sub CheckAttrSTYLE
{
  if (!$opt_style && !$seenAllTags{'META'.$nameSep.'CONTENT-STYLE-TYPE'}) {
    &Whine($., 'need-content-xxxx-type', xc($TAG), xc($ATTR), xc('HEAD'),
           xc('<META HTTP-EQUIV="CONTENT-STYLE-TYPE" CONTENT').'="`"'.xetag()) if !$xml;
  }
#  if ($xml) {
#    &Whine($., 'need-xml-stylesheet', xc($TAG), $opt_mime, 'xml-stylesheet');
#  }
}
sub CheckAttrINTRINSIC
{
  if (!$opt_script && !$seenAllTags{'META'.$nameSep.'CONTENT-SCRIPT-TYPE'}) {
    &Whine($., 'need-content-xxxx-type', xc($TAG), xc($ATTR), xc('HEAD'),
           xc('<META HTTP-EQUIV="CONTENT-SCRIPT-TYPE" CONTENT').'="`"'.xetag()) if !$xml;
  }
}
sub CheckAttrTABINDEX
{
  &WhineAttributeFormat('[0-32767]') if $value < 0 || $value > 32767;
}
sub CheckAttrDISABLED
{
  $disabled++;
}

sub CheckTagHTML
{
   $seenHtml = $.;
}
sub CloseTagHTML
{
  if (!$opt_lang && !$metaLang) {
    foreach ('LANG', 'XML:LANG') {
      if ($seenAttrs{$_} eq '' && $tagsAttributes{$TAG}->{$_} ne '') {
        &Whine($seenHtml, 'html-lang', xc($TAG), xc($_));
      }
    }
  }
}
sub CheckTagBODY
{
  if (!$multibody++) {
    $bodyline = $.;
    foreach (qw(BGCOLOR TEXT LINK VLINK ALINK)) {
      $seenAllTags{'BODY'.$nameSep.$_}++ if $seenAttrs{$_} ne '';
    }
  }
  if ($tagsAttributes{BODY}->{BGCOLOR} ne '' &&
      $seenAttrs{BACKGROUND} ne '' && $seenAttrs{BGCOLOR} eq '') {
    &Whine($., 'background', xc($TAG), xc('BACKGROUND'), xc('BGCOLOR'));
  }
  if ($seenAttrs{TEXT}) {
    $txcolor = &HexColor($seenAttrs{TEXT});
  }
  &CheckBgColor($TAG, 'TEXT',  $seenAttrs{TEXT});
  &CheckBgColor($TAG, 'LINK',  $seenAttrs{LINK});
  &CheckBgColor($TAG, 'VLINK', $seenAttrs{VLINK});
  &CheckBgColor($TAG, 'ALINK', $seenAttrs{ALINK});
}
  sub CheckBgColor
  {
    if (%bgcolor) {
      my ($tag, $attr, $col) = @_;
      $col = &HexColor($col);
      if ($col ne '') {
        my $bgtag = xc("<$bgcolor{TAG} BGCOLOR>");
        if (hex($col) == hex($bgcolor{COL})) {
          &Whine($., 'same-bgcolor', xc($tag), xc($attr), $bgtag);
        } else {
          my @x = $col =~ /(..)/g;
          my @y = $bgcolor{COL} =~ /(..)/g;
          my %rgbX = (R=>hex($x[0]),G=>hex($x[1]),B=>hex($x[2]));
          my %rgbY = (R=>hex($y[0]),G=>hex($y[1]),B=>hex($y[2]));
          my $brightnessX = &Brightness($rgbX{R},$rgbX{G},$rgbX{B});
          my $brightnessY = &Brightness($rgbY{R},$rgbY{G},$rgbY{B});
          my $diffb = abs($brightnessX-$brightnessY)/1000;
          my $diffc = abs($rgbX{R}-$rgbY{R})+abs($rgbX{G}-$rgbY{G})+abs($rgbX{B}-$rgbY{B});
          $diffb = ($diffb < 125)? 'x('.$diffb.')': '';
          $diffc = ($diffc < 500)? 'F('  .$diffc.')': '';
          if ($diffb or $diffc) {
            &Whine($., 'near-bgcolor', xc($tag), xc($attr), $bgtag,
                       &Join(($diffb and $diffc)? '': '', $diffb, $diffc));
          }
          my $lx = &Luminosity($rgbX{R},$rgbX{G},$rgbX{B});
          my $ly = &Luminosity($rgbY{R},$rgbY{G},$rgbY{B});
          my $contrast = ($lx >= $ly)? ($lx+0.05)/($ly+0.05): ($ly+0.05)/($lx+0.05);
          if ($contrast < 7.0) {
            &Whine($., ($contrast < 4.5)? 'contrast': 'contrast-aaa',
                       xc($tag), xc($attr), $bgtag, $contrast);
          }
        }
      }
    }
  }
  sub HexColor
  {
    my $col = shift;
    ($col =~ /^#?([0-9A-Fa-f]{6})$/)? $1: $colorTable{lc($col)};
  }
  sub Brightness
  {
    my ($r, $g, $b) = @_;
    $r*299+$g*587+$b*114;
  }
  sub Luminosity
  {
    my $r = &GammaLinearize($_[0]);
    my $g = &GammaLinearize($_[1]);
    my $b = &GammaLinearize($_[2]);
    $r*0.2126 + $g*0.7152 + $b*0.0722;
  }
  sub GammaLinearize
  {
    my $col = shift;
    $col /= 255;
    ($col <= 0.03928)? $col/12.92: (($col+0.055)/1.055)**2.4;
  }
sub CheckTagLINK
{
  foreach (split(' ', $seenAttrs{REV})) {
    if (/^MADE$/i) {
#     if ($seenAttrs{HREF} =~ /^mailto:/i) {
        $seenTags{'LINK'.$nameSep.'MAILTO'} = $.;
#     }
    }
  }
  foreach (split(' ', $seenAttrs{REL})) {
    if (/^CONTENT$/i) {
      &Whine($., 'mistype-links', xc($TAG), xc('REL'), $_, 'CONTENTS');
    }
    if (/^(?:$::navigationLinks)$/oi) {
      if ($seenAttrs{HREF} ne '') {
        $seenTags{'LINK'.$nameSep.'NAVIGATE'} = $.;
      }
    }
  }
}
  sub CheckMIME
  {
    my ($mime, $here) = @_;
    if ($mime ne '') {
      if ($mime eq 'text/html') {
        if (${$::doctypes{$rule}}{version} >= 4.6) {
          &Whine($., 'unrecommended-mime-slight', $here, $mime, ${$::doctypes{$rule}}{guide});
        }
      } else {
        if (!$xhtml) {
          &Whine($., 'unrecommended-mime', $here, $mime, ${$::doctypes{$rule}}{guide});
        }
      }
    }
  }
  sub CheckCHARSET
  {
    my ($v, $where, $ocs, $seen) = @_;
    if ($v =~ /^(?:$charsets)$/oi) {
      if ($v =~ /^(?:$usascii)$/oi) {
        # US-ASCII
        if ($ocs eq '') {
          $charset = 'usascii';
        } elsif ($ocs !~ /^(?:$usascii)$/oi) {
          # CHARSET
          &Whine($., 'conflict-charset', xc($TAG), $where, $ocs, $seen, $v);
        }
      } else {
        # {CHARSETׂ
        foreach (keys %japanesesets) {
          if ($v =~ /^(?:$japanesesets{$_})$/i) {
            if ($ocs eq '') {
              $charset = $v;
              $jcharcode = $_;
            } elsif ($ocs !~ /^(?:$japanesesets{$_})$/i) {
              # CHARSET
              &Whine($., 'conflict-charset', xc($TAG), $where, $ocs, $seen, $v);
            }
            last;
          }
        }
      }
    } elsif ($ocs eq '') {
      my $a = ''; # ȉ̔菇 (㏟)
      if ($Jcode && ($v =~ /utf\W*8/i)) {
        $a = 'UTF-8';
        $jcharcode = 'utf8';
      }
      if ($v =~ /jis|2022|jp/i) {
        $a = 'ISO-2022-JP';
        $charset = $v;
        $jcharcode = 'jis';
      }
      if ($v =~ /s(?:hift)?\W*(?:jis|jp)/i) {
        $a = 'Shift_JIS|MS_Kanji';
        $charset = $v;
        $jcharcode = 'sjis';
      }
      if ($v =~ /euc\W*j/i) {
        $a = 'EUC-JP';
        $charset = $v;
        $jcharcode = 'euc';
      }
      &Whine($., ($v =~ /^x-/i)?
                  'no-registered-charset-ex':
                  'no-registered-charset', '', $seen.'',
                  $v, &FormatAttrGuide($a, '%s Ȃo^Ă܂B'));
      &::PushStat('NoRegCharset', $v) if $opt_stat;
    }
  }
sub CheckTagMETA
{
  if ($seenAttrs{'HTTP-EQUIV'} =~ /^(CONTENT-.+-TYPE)$/i) {
    my $content_type = uc($1);
    &Whine($., 'existing-content-type', xc($TAG), xc('HTTP-EQUIV'), xc($content_type),
              $seenTags{$TAG.$nameSep.$content_type})
           if $seenTags{$TAG.$nameSep.$content_type};
    $seenTags{$TAG.$nameSep.$content_type} = $.;
    $seenAllTags{$TAG.$nameSep.$content_type}++;
  } elsif ($seenAttrs{'HTTP-EQUIV'} =~ /^(CONTENT-TYPE)$/i) {
    my $content_type = uc($1);
    &Whine($., 'existing-content-type', xc($TAG), xc('HTTP-EQUIV'), xc($content_type),
              $seenTags{$TAG.$nameSep.$content_type})
           if $seenTags{$TAG.$nameSep.$content_type};
    $seenTags{$TAG.$nameSep.$content_type} = $.;
    if ($seenAttrs{CONTENT} ne '') { # 璷Ô
      $seenAttrs{CONTENT} =~ m#^\s*([^\s;]+)(?:\s*;\s*)?(.*)#;
      my $type = $1;
      my @param = split(/\s*;\s*/, $2);
      if ($type !~ m#^\s*(text/html|application/xhtml\+xml)(?: |;|$)#i) {
        my $mime = ${$::doctypes{$rule}}{version} >= 4.6? 'application/xhtml+xml':
                   $xhtml? 'text/html ܂ application/xhtml+xml': 'text/html';
        &Whine($., 'no-text-html', xc($TAG), xc('CONTENT-TYPE'), $mime);
        &::PushStat('NoTextHtml', $type) if $opt_stat;
      } else {
        my $mime = $1;
        if ($opt_mime ne '' && $opt_mime ne $mime) {
          &Whine($., 'conflict-mime', xc($TAG), 'HTTPX|Xwb_', $opt_mime, $mime);
        }
        &CheckMIME($mime, xc('<META> '));
      }
      while (@param) {
        my ($a, $v) = shift(@param) =~ /^\s*([^\s=]+)\s*=\s*([^"=][^\s=]*|"[^"]+")/;
        $v = $1 if $v =~ /^"(.+)"$/;
        if (uc($a) eq 'CHARSET') {
          &CheckCHARSET($v, 'XML錾', $xcharset, xc('<META> ')) if $xcharset;
          $seenCharset = $.;
          $charset = $v if $opt_charset eq '';
          &CheckCHARSET($v, 'HTTPX|Xwb_', $opt_charset, xc('<META> '));
        }
      }
      if ($seenCharset) {
        $metaCharset++;
      } else {
        &Whine($., 'no-charset', xc($TAG),
               xc('HTTP-EQUIV="CONTENT-TYPE" CONTENT').'="`"', xc('CHARSET')) if !$xml;
      }
    }
  } elsif (uc($seenAttrs{'HTTP-EQUIV'}) eq 'REFRESH') {
    &Whine($., 'existing-content-type', xc($TAG), xc('HTTP-EQUIV'), xc('REFRESH'),
              $seenTags{$TAG.$nameSep.'REFRESH'})
           if $seenTags{$TAG.$nameSep.'REFRESH'};
    $seenTags{$TAG.$nameSep.'REFRESH'} = $.;
    if ($seenAttrs{CONTENT} =~ /^\d+(?:\s*(\W)\s*(.+))?/) {
      my ($sep, $href) = ($1, $2);
      if ($sep) {
        $href = $1 if $sep eq ';' && $href =~ /^URL\s*=\s*(.*)/i;
        local $ATTR = 'CONTENT';
        &CheckURL($href, 2);
        @refreshHTML = ($., &NormalizeURL($href)) if $href;
      }
      &Whine($., 'refresh', xc($TAG), xc('HTTP-EQUIV'), xc('REFRESH'));
    }
  } elsif ($seenAttrs{'HTTP-EQUIV'} =~ /^(CONTENT-LANGUAGE)$/i) {
    $metaLang = $seenAttrs{CONTENT};
  }
  if (uc($seenAttrs{NAME}) eq 'ROBOTS') {
#   &Whine($., 'robots-upper', xc($TAG), xc('NAME'), $seenAttrs{NAME})
#     if $seenAttrs{NAME} ne 'ROBOTS';
    if ($::robotsContents ne '') {
      foreach (split(/\s*,\s*/, $seenAttrs{CONTENT})) {
        &Whine($., 'robots-content', xc($TAG), xc('NAME'), $seenAttrs{NAME},
               xc('CONTENT'), $_) unless /^(?:$::robotsContents)$/o;
      }
    }
  }
  if ($seenAttrs{'HTTP-EQUIV'} && $seenAttrs{NAME}) {
    &Whine($., 'meta-http-equiv-name', xc($TAG), xc('HTTP-EQUIV'), xc('NAME'));
  } elsif ($seenAttrs{'CONTENT'} && !$seenAttrs{'HTTP-EQUIV'} && !$seenAttrs{NAME}) {
    &Whine($., 'meta-no-http-equiv-name', xc($TAG), xc('CONTENT'), xc('HTTP-EQUIV'), xc('NAME'));
  }
  if ($xml && $seenAttrs{'HTTP-EQUIV'}) {
    if ($opt_mime) {
      &Whine($., 'xml-http-equiv', xc($TAG), xc('HTTP-EQUIV'), 'fBA^Cv '.$opt_mime)
        if $opt_mime ne 'text/html';
    } else {
      &Whine($., 'xml-http-equiv', xc($TAG), xc('HTTP-EQUIV'), ${$::doctypes{$rule}}{guide});
    }
  }
}
sub CheckTagSCRIPT
{
  if (!$opt_script && !$seenAllTags{SCRIPT} &&
      !$seenAllTags{'META'.$nameSep.'CONTENT-SCRIPT-TYPE'}) {
    &Whine($., 'content-xxxx-type', xc($TAG), xc('HEAD'),
           xc('<META HTTP-EQUIV="CONTENT-SCRIPT-TYPE" CONTENT').'="`"'.xetag()) if !$xml;
  }
  if ('LANGUAGE' =~ /^(?:$deprecatedAttrs{$TAG})$/ && $seenAttrs{LANGUAGE}) {
    &Whine($., $seenAttrs{TYPE}? 'deprecated-attribute-0': 'deprecated-attribute',
               xc($TAG), xc('LANGUAGE'));
  }
}
sub CheckTagSTYLE
{
  if (!$opt_style && !$seenAllTags{STYLE} &&
      !$seenAllTags{'META'.$nameSep.'CONTENT-STYLE-TYPE'}) {
    &Whine($., 'content-xxxx-type', xc($TAG), xc('HEAD'),
           xc('<META HTTP-EQUIV="CONTENT-STYLE-TYPE" CONTENT').'="`"'.xetag()) if !$xml;
  }
}
sub CheckTagOLUL
{
  if ($rule =~ /^jsky/) {
    $cntLI = 0 if $nestULOL == 0;
    &Whine($., 'jskyweb-olul', xc($TAG), 3) if $nestULOL++ == 3;
  }
}
sub CheckTagLI
{
  if ($rule =~ /^jsky/) {
    &Whine($., 'jskyweb-li', xc($TAG), xc('<UL>').'A'.xc('<OL>'), 99) if $nestULOL && $cntLI++ == 99;
  }
}
sub CheckTagDD
{
  if ($htmlVer < 4) {
    &Whine($., ($rule =~ /^htmlplus/)? 'must-follow': 'must-follow-slight',
               xc($TAG), xc('</DT>')) if $lastPairTag ne 'DT';
  }
}
sub CheckTagA
{
  if ($seenAttrs{TITLE} eq '') {
    if ($line =~ /^\s*($::hereAnchors|$::hereAnchorsJ)\s*</oi) {
      my $here = $1;
      $here =~ s/^\s+//;
      $here =~ s/\s+$//;
      &Whine($., 'here-anchor', xc($TAG), $here);
      &::PushStat('HereAnchor', $here) if $opt_stat;
    }
  }
  my $href = $seenAttrs{HREF};
  if ($href ne '') {
    my ($scheme, $url, $frgid) = &SplitFragmentID($href);
    $href = &NormalizeURL($url).$frgid if $scheme =~ /^(?:$::httpSchemes)?$/o;
    $seenAllTags{'A'.$nameSep.'HREF'}++;
    undef @refreshHTML if @refreshHTML && $href eq $refreshHTML[1];
  }
  &CheckNameAnchor(\%seenAnchors, \%seenAnchorsU, \%seenAnchorsID);
  %linkInfo = (href=>$href, title=>$seenAttrs{TITLE});
  if ($rule =~ /^imode/) {
    &CheckValueLength('CTI', 128);
    &CheckValueLength('SUBJECT', 30);
    &CheckValueLength('BODY', 500);
    &CheckValueLength('TELBOOK', 20);
    &CheckValueLength('KANA', 18);
    &CheckValueLength('EMAIL', 50);
    if ($seenAttrs{IJAM}) {
      &Whine($., 'required-attribute-pair', xc($TAG), xc('IJAM'), xc('HREF'))
        if !$seenAttrs{HREF};
    }
    if ($seenAttrs{ISTA}) {
      &Whine($., 'required-attribute-pair', xc($TAG), xc('ISTA'), xc('HREF'))
        if !$seenAttrs{HREF};
      &Whine($., 'nomixed-attribute', xc($TAG), xc('ISTA'), xc('IJAM'))
        if $seenAttrs{IJAM};
    }
    my @telbook;
    push @telbook, 'TELBOOK' if $seenAttrs{TELBOOK};
    push @telbook, 'KANA'    if $seenAttrs{KANA};
    push @telbook, 'EMAIL'   if $seenAttrs{EMAIL};
    if (@telbook) {
      my @notuse;
      push @notuse, 'TELBOOK' if !$seenAttrs{TELBOOK};
      push @notuse, 'KANA'    if !$seenAttrs{KANA};
      push @notuse, 'EMAIL'   if !$seenAttrs{EMAIL};
      push @notuse, 'HREF'    if !$seenAttrs{HREF};
      &Whine($., 'required-attribute-pair', xc($TAG),
             join('A', @telbook), join('A', @notuse)) if @notuse;
    }
  }
}
  sub CheckValueLength
  {
    my $attr = shift;
    my $lim = shift;
    &Whine($., 'attribute-length', xc($TAG), xc($attr), $lim)
      if $lim && length($seenAttrs{$attr}) > $lim;
  }
  sub CheckNameAnchor
  {
    my ($seen, $seenU, $seenID) = @_;
    my $name = $seenAttrs{NAME};
    if ($name ne '') {
      &Whine($., 'fragment-id-whitespace', xc($TAG), $name) if $name =~ /\s/;
      my $id = $seenAttrs{ID};
      my $same = 0;
      if ($htmlVer >= 4 && $id ne '') {
        $same = $. if $name eq $id;
      }
      my $uname = uc($name);
      if ($seen->{$name}) {
        &Whine($., 'existing-fragment-id', xc($TAG), $name, $seen->{$name});
        $seen->{$name} = $. unless $same;
        $same = 0;
      } else {
        $seen->{$name} = $.;
        &Whine($., 'case-insensitive-fragment-id',
                   xc($TAG), $name, $seenU->{$uname}) if $seenU->{$uname};
      }
      $seenU->{$uname} = $.;
      if ($xhtml) {
        $seenID->{$name} = $same;
      } else {
        $seenID->{xc($name)} = $seenID->{uc($name)} = $same;
      }
    }
  }
sub CheckTagMAP
{
  &CheckNameAnchor(\%seenMapAnchors, \%seenMapAnchorsU, \%seenMapAnchorsID);
}
sub CheckTagLABEL
{
  @seenLabel = ($., $seenAttrs{FOR}, $seenAttrs{ACCESSKEY});
  push(@seenLabels, [@seenLabel]);
}
sub CheckTagSELECT
{
  @seenSelect = ($., $seenAttrs{MULTIPLE});
}
sub CheckTagOPTION
{
  $selOptions++;
  if ($rule =~ /^imode/) {
    my $lim = 0;
    if ($rule eq 'imode') {
      $lim = 10;
      &Whine($., 'over-select-options', xc($TAG), xc('SELECT'), 20)
        if $selOptions == 21;
    } elsif ($rule eq 'imode20') {
      $lim = 42;
    }
    &CheckValueLength('VALUE', $lim);
  }
}
sub CheckTagINPUT
{
  my $type = $seenAttrs{TYPE};
  if ($type !~ /^(?:IMAGE|SUBMIT|RESET|BUTTON|HIDDEN|TEXT)$/i && $seenAttrs{NAME} eq '') {
    &Whine($., 'required-attribute', xc($TAG), xc('NAME'));
    &::PushStat('RequiredAttr', $TAG.' NAME') if $opt_stat;
  }
  if ($type =~ /^(?:RADIO|CHECKBOX)$/i &&
      !defined($seenAttrs{VALUE}) && $htmlVer == 4) {
    &Whine($., 'required-attribute', xc($TAG), xc('VALUE'));
    &::PushStat('RequiredAttr', $TAG.' VALUE') if $opt_stat;
  }
  if ($rule eq '15445') {
    if ($type =~ /^(?:HIDDEN|TEXT)$/i && !defined($seenAttrs{VALUE})) {
      &Whine($., 'required-attribute', xc($TAG), xc('VALUE'));
      &::PushStat('RequiredAttr', $TAG.' VALUE') if $opt_stat;
    }
    if ($type eq 'SUBMIT' &&
        $seenAttrs{NAME} eq '' && defined($seenAttrs{VALUE})) {
      &Whine($., 'required-attribute', xc($TAG), xc('NAME'));
      &::PushStat('RequiredAttr', $TAG.' NAME') if $opt_stat;
    }
  }
  if ($rule eq 'imode') {
    my ($size, $maxlen);
    if ($type eq 'TEXT') {
      $size = 14;
      $maxlen = 256;
    } elsif ($type eq 'PASSWORD') {
      $size = 14;
      $maxlen = 20;
    }
    local $ATTR = 'SIZE';
    local $value = $seenAttrs{$ATTR};
    &WhineAttributeFormat('<='.$size) if $size && $value > $size;
    $ATTR = 'MAXLENGTH';
    $value = $seenAttrs{$ATTR};
    &WhineAttributeFormat('<='.$maxlen) if $maxlen && $value > $maxlen;
  }
}
sub CheckTagBUTTON
{
  if ($rule eq '15445') {
    my $type = $seenAttrs{TYPE};
    if ($type eq '') {
      &Whine($., 'input-type', xc($TAG), xc('TYPE'));
      $type = 'SUBMIT';
    }
    if ($type eq 'SUBMIT') {
      if ($seenAttrs{NAME} eq '') {
        &Whine($., 'required-attribute', xc($TAG), xc('NAME'));
        &::PushStat('RequiredAttr', $TAG.' NAME') if $opt_stat;
      }
      if (!defined($seenAttrs{VALUE})) {
        &Whine($., 'required-attribute', xc($TAG), xc('VALUE'));
        &::PushStat('RequiredAttr', $TAG.' VALUE') if $opt_stat;
      }
    }
  }
}
sub CheckTagTEXTAREA
{
  if ($rule eq 'imode') {
    local $ATTR = 'COLS';
    local $value = $seenAttrs{$ATTR};
    &WhineAttributeFormat('<=10') if $value > 10;
    $ATTR = 'ROWS';
    $value = $seenAttrs{$ATTR};
    &WhineAttributeFormat('<=6') if $value > 6;
  }
}
sub CheckTagCOL
{
  if ($tagsNest[$#tagsNest]{tag} eq 'COLGROUP' && !$tagsNest[$#tagsNest]{whined} &&
      $tagsNest[$#tagsNest]{attrs}->{SPAN} ne '') {
    &Whine($tagsNest[$#tagsNest]{n}, 'colgroup-span',
           xc($tagsNest[$#tagsNest]{tag}), xc('SPAN'), xc($TAG));
    $tagsNest[$#tagsNest]{whined} = 1;
  }
}
sub CheckTagTR
{
  $tableCell = 0;
  while ($tableInfo[$tableCell][0]) {
    $tableInfo[$tableCell++][0]--;
  }
}
sub CheckTagTHTD
{
  my $row = $seenAttrs{ROWSPAN}-1; $row = 0 if $row < 0;
  my $col = $seenAttrs{COLSPAN}-1; $col = 0 if $col < 0;
  foreach (0..$col) {
    if ($tableInfo[$tableCell][0] && $tableInfo[$tableCell][1] == 0) {
      &Whine($., 'overlap-cells', xc($TAG), xc('COLSPAN'),
                 $tableInfo[$tableCell][2], $tableInfo[$tableCell][3], xc('ROWSPAN'));
    }
    $tableInfo[$tableCell++] = [$row, $_, $., $TAG];
  }
  while ($tableInfo[$tableCell][0]) {
    $tableInfo[$tableCell++][0]--;
  }
}
sub CheckTagBR
{
  if ($contBRs < 0) {
    $contBRs = 0;
  } else {
    ++$contBRs;
    my $whine;
    if ($lastTag eq '#PCDATA') {
      my $spaces = &spaces;
      my $data = $pcdata;
      $data =~ s/(?:$spaces)//og;
      if ($data eq '') {
        # 󔒂ŋUȘA
        &Whine($., 'continuous-brs-fake', xc('BR'));
        $whine++;
      }
    }
    if ($lastTag ne 'BR') {
      $contBRs = 0;
    } elsif ($contBRs == 1 && !$whine) {
      &Whine($., 'continuous-brs', xc('BR'));
    }
  }
}
sub CheckTagPRE
{
  $seenPre = $.;
}
sub CheckTagIMG
{
  if ($seenAttrs{ISMAP} ne '' && $seenAttrs{USEMAP} ne '') {
    &Whine($., 'img-map', xc($TAG), xc('ISMAP'), xc('USEMAP'));
  }
}
sub CheckTagAPPLET
{
  push(@seenObject, {n=>$., alt=>$seenAttrs{ALT}});
}
sub CheckTagOBJECT
{
  push(@seenObject, {n=>$., alt=>$seenAttrs{ALT}, id=>$seenAttrs{ID}});
  push(@seenObjects, $seenObject[0]);
  if ($rule =~ /^imode/) {
    $cntPARAM = 0 if $nestOBJECT == 0;
    $nestOBJECT++;
  }
}
sub CheckTagPARAM
{
  if ($rule =~ /^imode/) {
    &Whine($., 'jskyweb-li', xc($TAG), xc('<OBJECT>'), 16) if $nestOBJECT && $cntPARAM++ == 16;
  }
}
sub CheckTagXML
{
  &Whine($., 'unsupported-tag', xc($TAG));
  &Whine($., 'excluded-element', xc($TAG), xc($TAG), $xmlns) if $xmlns;
  $xmlns = $.;
}
sub CloseTagPRE
{
  # PRE ͓qɂłȂƉ
  undef $seenPre;
}
sub CloseTagFORM
{
  # FORM ͓qɂłȂƉ
  foreach (keys %formNames) {
    $formNames{$_} =~ /^(\d+)$nameSep($nameStr)(${nameSep}1)?/;
    if ($2 eq 'RADIO' and !$3) {
      &Whine($1, 'no-checked', xc('INPUT'), xc('TYPE'), xc('RADIO'), xc('NAME'), $_, xc('CHECKED'));
    }
  }
  undef %formNames;
}
sub CloseTagSELECT
{
  # SELECT ͓qɂłȂƉ
  unless (@selOption) {
    &Whine($., 'no-selected', xc('OPTION'), xc('SELECTED'));
  }
  undef @seenSelect;
  undef @selOption;
  undef $selOptions;
}
sub CloseTagLABEL
{
  # LABEL ͓qɂłȂƉ
  if ($seenLabel[1] eq '') {
    &Whine($seenLabel[0], 'label-no-control', xc('LABEL')) if !@ctrlLabel;
  }
  undef @seenLabel;
  undef @ctrlLabel;
}
sub CloseTagHEAD
{
  if ('LINK' =~ /^(?:$allTags)$/) {
    &Whine($., 'mailto-link', xc('HEAD'),
           xc('<LINK REV="MADE" HREF').'="mailto:`"'.xetag())
               if !$seenTags{'LINK'.$nameSep.'MAILTO'};
    &Whine($., 'navigation-link', xc('HEAD'),
           xc('<LINK REL="NEXT" HREF').'="`"'.xetag())
               if !$seenTags{'LINK'.$nameSep.'NAVIGATE'};
  }
  if (!$xml) {
    if ('META' =~ /^(?:$allTags)$/ && $opt_charset eq '' &&
        $opt_charset eq '' && !$seenTags{'META'.$nameSep.'CONTENT-TYPE'}) {
      &Whine($., 'content-type', xc('HEAD'),
             xc('<META HTTP-EQUIV="CONTENT-TYPE" CONTENT').'="`"'.xetag())
        unless $rule =~ /^compact-html/;
    }
  }
  $metaCharset++;
  undef $headElements;
}
sub CloseTagOBJECT
{
  my $obj = pop(@seenObject);
  if ($obj->{app}) {
    &Whine($obj->{n}, 'applet-text-equivalent', xc($TAG), xc('ALT')) if defined($obj->{alt});
  } else {
    &Whine($obj->{n}, 'object-text-equivalent', xc($TAG)) if !defined($obj->{alt}) && !$headElements;
  }
  if ($rule =~ /^imode/) {
    $nestOBJECT--;
  }
}
sub CloseTagOLUL
{
  if ($rule =~ /^jsky/) {
    $nestULOL--;
  }
}

##################################################
# I^O
# ̏I^OɑΉƎvJn^O $TAG ł
#  $tagsNest[$#tagsNest]{tag} Ɠ
# I^ȌƂ 1 Ԃ
# $TAG ɑΉI^OȂƂ 0 Ԃ

sub ReadEndTag
{
  my $id = &GetTag;
  my $end = uc($id);
  my $oend = $xhtml? $id: $end;
  if ($id =~ m#^/(.*)#) {
    $id = $1;
    if ($xhtml && $id ne lc($id)) {
      &Whine($., 'lower-case-tag', '', "/$id") if uc($id) =~ /^(?:$allTags)$/;
    }
    my $oid = $id;
    $id = uc($id);
    unless ($xmlns) {
      if ($id !~ /^(?:$pairTags)$/) {
        # s̏I^O
        &WhineUnknownElement("/$oid");
        &Whine($., 'closing-attribute', xc($TAG), xc($id))
          if &AdvanceCloseTag($end, $.);
        return 0;
      }
      if ($id =~ /^(?:$emptyTags)$/) {
        # vf^Oɂ͏I^O͂Ȃ
        &Whine($., 'illegal-closing', xc($TAG), xc($id));
        &::PushStat('IllegalClosing', $id) if $opt_stat;
        &Whine($., 'closing-attribute', xc($TAG), xc($id))
          if &AdvanceCloseTag($end, $.);
        return 0;
      }
    }
    if ($TAG ne 'BR') {
      $contBRs = -1;
    }
    if ($TAG eq $id) {
      # I^O
      if ($TAG =~ /^(?:$::cuddleContainers)$/) {
        &Whine($., 'container-whitespace', xc($TAG), '') if $token =~ /^\s/;
      }
      &Whine($., 'closing-attribute', xc($TAG), xc($id)) if &AdvanceCloseTag($end, $.);
      &Whine($., 'minimized-endtag', xc($TAG)) if $minetag && !$xml;
    } else {
      my $omit = &OmitEndTag($#tagsNest, $id);
      if ($omit) {
        # I^O͏ȗł
        &UnGetToken;
        &WhineOmitEndTag($TAG, $end, $omit);
      } else {
        my $oid = $#tagsNest;
        foreach (reverse 0..$#tagsNest-1) {
          if ($id eq $tagsNest[$_]{tag}) {
            if ($_ > 1 && !$xmlns) { # ΂O͏
              if ($tagsNest[$_]{tag} =~ /^(?:$omitEndTags)$/ &&
                  $tagsNest[$_]{tag} =~ /^(?:$tagsElements{$id})$/) {
                &Whine($., 'required-end-tag', xc($TAG));
                &::PushStat('OmitEndTag', $TAG) if $opt_stat;
              } else {
                my $parent = $tagsNest[$oid]{tag};
                if ($xhtml && !$tagsElements{$parent}) {
                  &Whine($tagsNest[$oid]{n}, 'endtag-slash', xc($parent));
                } else {
                  # ^O̓q\
                  &Whine($., 'element-overlap', xc($TAG), xc($id),
                                      $tagsNest[$oid]{n}, xc($parent));
                  &Whine($., 'omit-end-tag', xc($TAG), xc("</$id>").' ̑O');
                # &::PushStat('ElementOverlap', $id.' '.$TAG) if $opt_stat;
                # &::PushStat('OmitEndTag', $TAG) vケ͏o͂Ă͂ȂȂ
                }
              }
            } else {
              # I^OȂ\
              &Whine($., 'unclosed-element', xc($TAG), $tagsNest[$#tagsNest]{n});
              &::PushStat('UnclosedElement', $TAG) if !$xmlns && $opt_stat;
            }
            &UnGetToken;
            return 1;
          }
          $oid = $_ if $tagsNest[$_]{tag} =~ /^(?:$omitEndTags)$/;
        }
        # ȏI^O
        ($atag =~ /^(?:$pairTags)$/)? &Whine($., 'mis-match', xc($TAG), xc($id)):
                                      &Whine($., 'unknown-element', $oend);
        &Whine($., 'closing-attribute', xc($TAG), xc($id))
          if &AdvanceCloseTag($end, $.);
        return 0;
      }
    }
  } else {
    # I^OȂƂ
    &UnGetToken;
    my $omit = &OmitEndTag($#tagsNest);
    if ($omit) {
      # I^O͏ȗł
      &WhineOmitEndTag($TAG, $end, $omit);
    } else {
      # I^OȂ\
      if ($TAG eq $HTML && !$reacheof) {
        # r </HTML> ͏ȗȂ悤ɂ
        # ̂߂ɁA<BODY> ܂ĂȂƂď
        # ̔́Ał͕svmȂ
        my $rest = $..$nameSep.$line; # [vh߂̍׍H
        if ($omit_html ne $rest) {
          $omit_html = $rest;
          undef $seenTags{BODY};
          return 0;
        }
      }
      &Whine($., 'unclosed-element', xc($TAG), $tagsNest[$#tagsNest]{n});
      &::PushStat('UnclosedElement', $TAG) if !$xmlns && $opt_stat;
    }
  }
  1;
}

##################################################
# I^Oȗł邩ׂ
#    <A>
#    <B> -- <D> ֎~Ă $tagsNest[$pn]{tag}
#    <C>
#    <D> -- ꂪ݂̃^O $TAG
# ݂̃^OI^OȂΑQɂꂪZbgĂ (/)
# ̂Ƃ $TAG ͂ɑΉƗ\zJn^O
# <D> vf^OłȂAȗɂĒÕ^O <C> ̗vfɂȂ炸A
# </C> </B> ȗŁA<A>  <D> ƂA
# </C> ȗłƂ
# ܂A<C> <D> ^ÔЂƂ̂Ƃ́AȗłȂłƂ
# ȗłȂƂ 0 Ԃ

sub OmitEndTag
{
  my ($pn, $end, $whine) = @_;
  return 0 if $pn < 0 || $xmlns;
  my $last = $tagsNest[$#tagsNest]{tag};
  # ܂eLXgƂ </HTML> ȗłȂ
  return 0 if $last eq $HTML && !$reacheof;
  return 1 if $#tagsNest == 0;
  # vf^OÕ^Oȗs̂Ƃ͏ȗłȂ
  return 0 if $TAG =~ /^(?:$emptyTags)$/ || $last !~ /^(?:$omitEndTags)$/;
  # <OBJECT>  <HEAD> ɂ̂ŁAOĂ
  return 0 if $last eq 'BODY' && $TAG eq 'OBJECT';
  # O̊Jn^Oȗėvf̂Ƃ͏ȗłȂ
  # $pn > 1 Ƃ̂ <HEAD></HEAD> ̑Ώ
  return 0 if $pn == $#tagsNest && $pn > 1 && !@innerTags && $lastOmitTag;
  my $last1 = $tagsNest[$#tagsNest-1]{tag};
  if ($pn) {
    # ȗƂ̃^O邩ǂׂ
    my $ext = &ExpandInternalElements($tagsElements{$tagsNest[$pn-1]{tag}});
    if ($TAG ne $tagsNest[$pn-1]{tag} && $TAG !~ /^(?:$ext)$/) {
      my $omit = 0;
      # Jn^OȗƂ̂Ƃl (Ƃ肠1î)
      foreach (split(/\|/, $ext)) {
        if (/^($omitStartTags)$/) {
          my $oext = &ExpandInternalElements($tagsElements{$_});
          if ($TAG =~ /^(?:$oext)$/) {
            $omit++;
            last;
          }
        }
      }
      return 0 unless $omit;
    }
  }
  if (!$end && $last1 =~ /^(?:$sequencialTags)$/) {
    # ^ÔЂƂ̂Ƃ
#   return 1 if $last =~ /^(?:$omitEndTags)$/;
    my $ext = &ExpandInternalElements($onceonlyTags{$last1});
    # ̔͂܂萳mȂ
    if ($TAG =~ /^(?:$ext)$/ && $last !~ /^(?:$ext)$/) {
      $ext = &ExpandInternalElements($tagsElements{$last1});
      return 1 if $TAG =~ /^(?:$ext)$/;
    }
  }
# return 0 if $last eq $lastTag; # Õ^O
  foreach (reverse $pn..$#tagsNest-1) {
    # r̃^Oȗǂׂ
    return 0 unless $tagsNest[$_]{tag} =~ /^(?:$omitEndTags)$/;
  }
  if ($end) {
    # ꂽ̂I^ÔƂ
    foreach (reverse 0..$#tagsNest-1) {
      # ΉJn^O݂邩ׂ
      if ($end eq $tagsNest[$_]{tag}) {
        undef $end;
        last;
      }
      next if $_ >= $pn; # łɎ̓`FbNς
      # ݂Ȃ炻܂ł̃^OSȗׂ
      return 0 unless $tagsNest[$_]{tag} =~ /^(?:$omitEndTags)$/;
    }
    return 0 if $end;
  }
  2;
}

##################################################
# #NNN `̓vfWJ

sub ExpandInternalElement
{
  my $elem = shift;
  &ExpandInternalElements($tagsElements{$elem});
# &ExpandInternalElements($tagsElements{shift}); Ƃ܂Ȃ?
}
sub ExpandInternalElements
{
  my $elem = shift;
  $elem =~ s/($internalElem)/&ExpandInternalElement($1)/oge;
  $elem;
}

sub ExpandOnceonlyElement
{
  my $elem = shift;
  $elem = ($onceonlyTags{$elem} or $tagsElements{$elem});
  &ExpandOnceonlyElements($elem);
}
sub ExpandOnceonlyElements
{
  my $elem = shift;
  $elem =~ s/($internalElem)/&ExpandOnceonlyElement($1)/oge;
  $elem;
}

##################################################
# l𒲂ׂ
# sȑ̂Ƃ 0 Ԃ

sub CheckAttribute
{
  my ($tag, $attr) = @_;
  my $avals = $tagsAttributes{$tag}->{$attr};
  my $fixed = '';
  if ($avals =~ /^([^=]+)(?:=(.*))?/) {
    ($avals, $fixed) = ($1, $2);
  }
  if ($avals eq '') {
    &WhineUnknownAttribute($tag, $attr);
    $quot = '';
    return 0;
  }
  if (StrLength($value) > 1024) {
    &Whine($., 'attribute-length', xc($tag), xc($attr), 1024);
  }
  if ($fixed ne '') {
    if (lc($value) ne lc($fixed)) {
      &Whine($., 'fixed-attribute', xc($tag), xc($attr), $fixed);
    }
    return 1;
  }
  my $icase = '(?i)';  # 啶ʂȂ
  if ($avals =~ /^%(.*)/) {
    $icase = ''; # ̂Ƃ͑啶ʂ
    $avals = $refParams{$1};
  } elsif ($avals !~ /^(?:$charData)$/oi) {
    # l̗ (啶ʂȂ/XHTMLł͂)
    if ($value eq '') {
      &Whine($., 'empty-value', xc($tag), xc($attr));
    } else {
      &WhineWhiteSpaceInValue;
      if ($value =~ /^(?:$avals)$/i) {
        if ($htmlVer >= 4.5 && $value !~ /^(?:$avals)$/) {
          my $cval;
          foreach (split(/\|/, $avals)) {
            if (/^$value$/i) {
              $cval = $_;
              last;
            }
          }
          &Whine($., 'attribute-value-case', xc($tag), xc($attr), $value, $cval);
        }
        if ($attr =~ /^(?:$avals)$/i && !$xhtml) {
          &Whine($., 'minimized-attribute', xc($tag), xc($attr));
          &::PushStat('MinimizedAttribute', $tag.' '.$attr) if $opt_stat;
        }
        my $dvals = $deprecatedVals{$tag.$nameSep.$attr};
        if ($dvals && $value =~ /^(?:$dvals)$/i) {
          &Whine($., 'deprecated-value', xc($tag), xc($attr), $value);
        }
      } else {
        &WhineAttributeFormat(($attr =~ /^(?:$avals)$/i)? '': $avals);
      }
    }
    $quot = '';
    return 1;
  }
  if ($avals =~ /^&/) {
    eval $avals;
  } elsif ($avals eq 'CDATA') {
    &CDATA;
  } elsif ($avals eq 'CDATA+') {
    if ($value eq '') {
      &Whine($., 'empty-value', xc($tag), xc($attr));
    } else {
      &CDATA;
    }
  } else {
    &WhineWhiteSpaceInValue;
    my $tvals = $tokenizedType{$avals} || $avals;
    if ($value =~ /^(?:$icase$tvals)$/) {
      if ($avals eq 'ID') {
        my $uval = $xhtml? $value: uc($value);
        &Whine($., 'repeated-id', xc($tag), xc($attr), $value, $iddef{$uval}) if $iddef{$uval};
        $iddef{$uval} = $.;
        if ($isohtml) {
          &Whine($., 'lower-id', xc($tag), xc($attr), $value) if $value =~ /[a-z]/;
        }
        if ($xhtml) {
          &Whine($., 'attribute-format', xc($tag), xc($attr), $value, $1.' Ŏn߂邱Ƃ͂ł܂B') if $value =~ /^(xml)/i;
          &Whine($., 'unsafe-attribute', xc($tag), xc($attr), $value) if $value =~ /^_/;
        }
      } elsif ($avals eq 'IDREF') {
        my $uval = $xhtml? $value: uc($value);
        $idref{$uval} = $..$nameSep.$tag.$nameSep.$attr;
      } elsif ($avals eq 'IDREFS') {
        foreach (split(/\s*,\s*|\s+/, $value)) {
          my $uval = $xhtml? $_: uc;
          $idref{$uval} = $..$nameSep.$tag.$nameSep.$attr;
        }
      } elsif ($avals eq 'NUMBER+') {
        &WhineAttributeFormat($avals) if $value < 1;
      }
    } elsif ($value eq '') {
      &Whine($., 'empty-value', xc($tag), xc($attr));
    } else {
      &WhineAttributeFormat($avals);
    }
  }
  $quot = '';
  1;
}

##################################################
# eLXg̕R[h{ꂩǂׂ

sub CheckLanguageCode
{
  if ($textcode =~ /^(?:jis|euc|sjis)$/ &&
      ${$lang}{val} ne '' && ${$lang}{val} !~ /^(?:ja|jpn)(?:-JP)?$/i) {
    my $text = shift;
    if ($text =~ /[\x80-\xFF]/) {
      my $code = &Jgetcode(\$text);
      if ($japanesesets{$code} ne '') {
        &Jconvert(\$text, $myCODE, $code) if $myCODE ne $code;
        if ($myCODE eq 'euc') {
          my $c = 0;
          foreach (unpack('C*', $text)) {
            if ($c) {
              if (0x00A1 <= $_ && $_ <= 0x00FE && $c != 0x008E) {
                my $n = ($c<<8)|$_;
                if ((0xA4A1 <= $n && $n <= 0xA5F6) ||
                    (0xB0A1 <= $n && $n <= 0xF4A6)) { return 1; }
              }
              $c = 0;
            } elsif ((0x00A1 <= $_ && $_ <= 0x00FE) || $_ == 0x008E) {
              $c = $_;
            }
          }
        } else {
          my $c = 0;
          foreach (unpack('C*', $text)) {
            if ($c) {
              if ((0x0040 <= $_ && $_ <= 0x007E) ||
                  (0x0080 <= $_ && $_ <= 0x00FC)) {
                my $n = ($c<<8)|$_;
                if ((0x829F <= $n && $n <= 0x8596) ||
                    (0x889F <= $n && $n <= 0xEAA4)) { return 1; }
              } else {
                $c = ((0x0081 <= $_ && $_ <= 0x009F) ||
                      (0x00E0 <= $_ && $_ <= 0x00FC))? $_: 0;
              }
              $c = 0;
            } elsif ((0x0081 <= $_ && $_ <= 0x009F) ||
                     (0x00E0 <= $_ && $_ <= 0x00FC)) {
              $c = $_;
            }
          }
        }
      }
    }
  }
  0;
}
sub WhineLanguageCode
{
  my ($ln, $whine, $tag, $attr) = @_;
  &Whine($ln, $whine, xc($tag), xc($attr), ${$lang}{attr}, ${$lang}{val},
         ${$lang}{n}? ${$lang}{n}.'sڂ': 'HTTPX|Xwb_');
}

##################################################
# Kvȑt悤x\

sub WhineRecommendedAttribute
{
  my ($ln, $attr, $recommended, $whine) = @_;
  if ($TAG =~ /^(?:$recommended)$/ &&
      $tagsAttributes{$TAG}->{$attr} ne '' && $seenAttrs{$attr} eq '' &&
      # <INPUT TYPE=HIDDEN> ͏
      ($TAG ne 'INPUT' || uc($seenAttrs{TYPE}) ne 'HIDDEN')) {
    my $req = $requiredAttrs{$TAG};
    $req =~ s/&/\|/g;
    &Whine($ln, $whine, xc($TAG), xc($attr)) unless $attr =~ /^(?:$req)$/;
  }
}

##################################################
# Cxg΂̕sx

sub WhinePairEvent{
  my ($ln, $event1, $event2) = @_;
  if ($tagsAttributes{$TAG}->{$event1} ne '' &&
      $tagsAttributes{$TAG}->{$event2} ne '') {
    if (defined($seenAttrs{$event1}) && !defined($seenAttrs{$event2})) {
      &Whine($ln, 'event-pair', xc($TAG), xc($event1), xc($event2));
    }
    if (defined($seenAttrs{$event2}) && !defined($seenAttrs{$event1})) {
      &Whine($ln, 'event-pair', xc($TAG), xc($event2), xc($event1));
    }
  }
}

##################################################
# ȂɊւx\

sub WhineAttributeFormat
{
  my $avals = shift;
  my $cdata ='';
  my $whine = 'attribute-format';
  if ($avals =~ /^($charData)$/oi) {
    $cdata = $1;
    $cdata = ($avals =~ /^CDATA/i)? '': "($cdata)";
    $avals = ($avals =~ /^ID/i)? $xhtml? 'p܂_n܂:O':
                                         'pn܂閼O':
             ($avals =~ /^NUMBER/i)? 'l':
             ($avals =~ /^NAME/i)? 'p'.($xhtml?'܂_':'').'n܂閼O':
             ($avals =~ /^NMTOKEN/i)? 'O':
             ($avals =~ /^NUTOKEN/i)? 'n܂閼O':
             '';
  } elsif ($avals =~ /#\[0-9A-F\]\{6\}/i) {
    $whine = 'attribute-color';
    $avals = '';
  } else {
    $avals = ($avals eq 'NUMBER+')? '1ȏ̐l':
             ($avals eq '\d+')? 'l':
             ($avals eq '\d+%?')? 'l %t̐l':
             ($avals eq '(\d+(\.\d+)?(\*|%)?|\*)')? 'l %t̐l *t̐l':
             ($avals =~ /^\[(\d+)-(\d+)\]$/)? $1.'`'.$2.' ':
             ($avals =~ /^<=(\d+)$/)? $1.'ȉ':
             ($avals eq '[+|-]?[1-7]')? '}1`}7 ':
             ($avals eq '[\x20-\x7E]')? 'ASCIIP':
             ($avals eq '[0-9#\*]')? '0`9 # * ':
             ($avals eq '[0-9#\*\/,]')? '0`9 # * , / ':
             ($avals eq '\w+')? 'pp':
             ($avals =~ /^$tokenStr(?:\|$tokenStr)+$/)? &FormatAttrGuide($avals, '%s '):
             '';
  }
  $avals .= ($avals ne '')? $cdata.'łȂ΂Ȃ܂B': $cdata;
  &Whine($., $whine, xc($TAG), xc($ATTR), $value, $avals);
}

##################################################
# 󔒂܂܂鑮ľx\
# x $value ̐ss󔒂͎̂Ă
# ̏ꍇ͏

sub WhineWhiteSpaceInValue
{
  if ($value =~ /^\s|\s$/) {
    &Whine($., 'whitespace-attribute-value', xc($TAG), xc($ATTR), $value);
    $value =~ s/^\s+//;
    $value =~ s/\s+$//;
  }
}

##################################################
# <LI TYPE=> ̑]

sub LIStyle
{
# &CDATA;
  &CheckAttribute($tagsNest[$#tagsNest]{tag}, $ATTR);
}

##################################################
# <OL TYPE=> ̑]

sub OLStyle
{
  &CDATA;
  if ($value eq '') {
     &Whine($., 'empty-value', xc($TAG), xc($ATTR));
  } else {
    &WhineWhiteSpaceInValue;
    my $OLStyle = ($rule =~ /^(?:imode|jsky|doti)/)? '1|a|A': '1|a|A|i|I';
    &WhineAttributeFormat($OLStyle) unless $value =~ /^(?:$OLStyle)$/;
  }
}

##################################################
# <DIR TYPE=> ̑]

sub DIRStyle
{
  &CDATA;
  if ($value eq '') {
     &Whine($., 'empty-value', xc($TAG), xc($ATTR));
  } else {
    &WhineWhiteSpaceInValue;
    my $OLStyle = ($rule =~ /^(?:imode|jsky|doti)/)? '1|a|A': '1|a|A|i|I';
    &WhineAttributeFormat($OLStyle)
      unless $value =~ /^(?:$OLStyle)$/ ||
             $value =~ /^(?:$tagsAttributes{UL}->{TYPE})$/i;
  }
}

##################################################
# URL ]
#  $value ɓĂAʂɓ

sub URL
{
# &CDATA;
  if (&CheckURL($value)) {
    $seenRelURL = $. if $TAG ne 'BASE';
  }
}

sub URLs
{
# &CDATA;
  my $n = 0;
  foreach (split(/\s+/, $value)) {
    if (&CheckURL($_)) {
      $seenRelURL = $. if $TAG ne 'BASE';
    }
    $n++;
  }
  if ($n > 1 && $ATTR eq 'PROFILE') {
    &Whine($., 'profile-uri', xc($TAG), xc($ATTR));
  }
}

sub CheckURL
{
  my ($value, $urichk) = @_;
  $urichk or ($urichk = 1);
  my $reluri = 0;
  if ($value =~ /^\s*$/) {
    &Whine($., 'empty-url', xc($TAG), xc($ATTR));
  } else {
    my ($scheme, $url) = &SplitFragmentID($value);
    if ($scheme eq '') {
      $reluri = 1;
    } else {
      if ($scheme =~ /^(?:$::allSchemes)$/oi ||
          $scheme =~ /^(?:${$::doctypes{$rule}}{scheme})$/i) {
        &Whine($., 'upper-protocol', xc($TAG), xc($ATTR), $scheme)
          if $scheme ne lc($scheme);
        if (${$::doctypes{$rule}}{allschemes} &&
            $scheme !~ /^(?:${$::doctypes{$rule}}{allschemes})$/i) {
          &Whine($., 'cantuse-protocol', xc($TAG), xc($ATTR), $scheme);
        }
      } elsif ($scheme =~ /^(?:$RFC2396::scheme)$/o) {
        &Whine($., 'upper-protocol', xc($TAG), xc($ATTR), $scheme)
          if $scheme ne lc($scheme);
        &Whine($., 'unknown-protocol', xc($TAG), xc($ATTR), $scheme);
        &::PushStat('UnknownProtocol', $scheme) if $opt_stat;
      } else {
        &Whine($., 'illegal-protocol', xc($TAG), xc($ATTR), $scheme);
      }
      $scheme =~ tr/A-Z/a-z/;
      if ($scheme eq 'javascript') {
        &Whine($., 'javascript-url', xc($TAG), xc($ATTR), $scheme);
      }
    }
    my $whine = 0;
    my $illchar = 0;
    my $ok = 1;
    my $urlorg = $url;
    my $http   = $scheme =~ /^(?:$::httpSchemes)?$/o; # ̂Ƃ http
    $URLcollection{&AbsoluteURL(($baseURL ne '')? $baseURL: $opt_base, $url)}++
      if $opt_linklist && $http;
    my $syntax = \&{'RFC2396::URL_'.($http? 'http': $scheme)};
    my $chkurl = ($opt_base ne '' && defined(&::AskHTML) && $http &&
                 ($enabled{'cant-get-url'} > 0.0 || $opt_pedantic));
    if ($http || defined(&$syntax)) {
      &Whine($., 'url-whitespace', xc($TAG), xc($ATTR), $url), $whine++
        if $url =~ /\s/;
      &Whine($., 'url-backslash', xc($TAG), xc($ATTR), $url), $whine++
        if $url =~ /\\/;
      if ($url =~ /$RFC2396::control/o) {
        &Whine($., 'no-corresponding-url', xc($TAG), xc($ATTR), $url);
        &Whine($., 'illegal-format-url', xc($TAG), xc($ATTR), $url);
        $whine++;
      }
      if ($ok = !$whine) {
        # URL ̎̎QƂ`FbNăfR[h (̃`FbNsS)
        my $urlscan = $url;
        my $exurl = '';
        while ($urlscan =~ /^([^&]*)(&.*)/) {
          my ($scanned, $c) = ($1);
          ($urlscan, $c) = &CheckRefEntities($2, $urichk, 1);
          $exurl .= $scanned.$c;
          $illchar += &CheckCharURL($scanned, $url);
        }
        $illchar += &CheckCharURL($urlscan, $url);
        $url = $exurl.$urlscan;
        $ok = !$whine;
      }
      if ($ok) {
        if ($scheme eq '') {
          $ok = $url =~ /^$RFC2396::relativeURI$/o if $url ne '';
          &Whine($., 'net-path', xc($TAG), xc($ATTR), $url) if $ok && $http && $url =~ m#^//#;
        } else {
          # URL̃XL[ɂ
          substr($url, 0, length($scheme)) = $scheme;
          if ($http) {
            $ok = $url =~ /^$RFC2396::URL_http$/o;
            if ($ok) {
              my ($path) = $url =~ m#^\w+://(?:[^/]+)(.*)$#;
              if (!$chkurl) {
                &Whine($., 'trailing-slash', xc($TAG), xc($ATTR), $urlorg)
                  if $path =~ m#^/(?:~|%7E)[^/]+$#i;
              }
              # index.html ̏ȗ𒲂ׂ
              my $urlxquery = $1 if $url =~ /^([^?]*)[?]/;
              my $filespec = &NormalizeURL($urlxquery);
              if ($filespec =~ m#^(.*?)/$#) {
                &Whine($., 'conflict-directory', xc($TAG), xc($ATTR), $urlorg,
                       $indexhtml{$1}[0], $indexhtml{$1}[1]) if $indexhtml{$1};
                foreach (keys %indexhtml) {
                  if (m#^$filespec$::INDEXHTML$#i) {
                    &Whine($., 'index-html', xc($TAG), xc($ATTR), $urlorg,
                           $indexhtml{$_}[0], $indexhtml{$_}[1]);
                    last;
                  }
                }
              } else {
                my $dir = $filespec.'/';
                &Whine($., 'conflict-directory', xc($TAG), xc($ATTR), $urlorg,
                       $indexhtml{$dir}[0], $indexhtml{$dir}[1]) if $indexhtml{$dir};
                if ($filespec =~ m#(?:^|/)($::INDEXHTML)$#oi) {
                  substr($dir = $filespec, -length($1)) = '';
                  &Whine($., 'index-html', xc($TAG), xc($ATTR), $urlorg,
                         $indexhtml{$dir}[0], $indexhtml{$dir}[1]) if $indexhtml{$dir};
                }
              }
              $indexhtml{$filespec} = [ $., $urlxquery ];
            }
          } elsif (defined(&$syntax)) {
            if ($ok) {
              $ok = $url =~ /^$RFC2396::absoluteURI$/o && &$syntax($url);
            }
            if ($scheme eq 'file') {
              # file:/// ܂Ō
              &Whine($., 'local-protocol', xc($TAG), xc($ATTR), $urlorg)
                unless $opt_local;
            }
          }
        }
      }
    } else {
#     $ok = $url =~ /^$RFC2396::absoluteURI$/o;
      # mȂXL[̓`FbNȂ悢
      # Ⴆ javascript: Ȃǂ̓lbg[N𗬂Ȃ̂
      # RFC ͈̎͊OmꂸAǂȕł
      #  javascript:document.write("xxxx") ȂǂƕʂɎg邾낤
    }
    if ($ok) {
      # URL 邩ׂ (`FbNƎԂ)
      if ($url ne '') {
        if ($chkurl) {
          defined($stathtml{$url}) or
          ($stathtml{$url} = &::AskHTML(($baseURL ne '')? $baseURL: $opt_base, $url));
          my ($stat, $rurl, $ctype, $length, $msg) = @{$stathtml{$url}};
          if ($stat < 200 || $stat >= 400) {
            $msg = join(' ', $stat, $msg);
            &Whine($., 'cant-get-url', xc($TAG), xc($ATTR), $url, 'C^lbg', $msg);
          }
          &Whine($., 'trailing-slash', xc($TAG), xc($ATTR), $url)
            if $stat == 200 && $rurl =~ m#$url/$#i &&
               $url !~ m#^\w+://[^/]+$#; # hC̏ꍇ͏
          if ($TAG eq 'IMG') {
            if ($ATTR eq 'SRC') {
              if ($rule =~ /^imode/) {
                &Whine($., 'unsupported-image', xc($TAG), xc($ATTR), $url,
                       ${$::doctypes{$rule}}{guide}, 'GIF')
                       if $ctype ne '' && $ctype ne 'image/gif';
                $readsize += $length;
              } elsif ($rule =~ /^jsky/) {
                &Whine($., 'unsupported-image', xc($TAG), xc($ATTR), $url,
                       ${$::doctypes{$rule}}{guide}, 'PNG')
                       if $ctype ne '' && $ctype ne 'image/png';
                $readsize += $length;
              } elsif ($rule =~ /^doti/) {
                &Whine($., 'unsupported-image', xc($TAG), xc($ATTR), $url,
                       ${$::doctypes{$rule}}{guide}, 'GIF ܂ PNG')
                       if $ctype ne '' && $ctype !~ m#^image/(?:gif|png)$#;
                $readsize += $length;
              }
            }
          } elsif ($TAG eq 'FRAME') {
            if ($ATTR eq 'SRC') {
              &Whine($., 'frame-image', xc($TAG), xc($ATTR))
                if $ctype ne '' && $ctype !~ m#^\s*text/html( |;|$)#i;
            }
          }
        } elsif (!&CallCGI() && ($enabled{'cant-get-url'} > 0.0 || $opt_pedantic) &&
                 $scheme eq '') {
          # b ($opt_base ƂĂȂ)
          $url =~ s|\?.+$||; # querŷĂ
          my $file = $htmlfile;
          $file =~ s|\\|/|g;
          $file =~ s|[^/]+$||;
          $file .= $url;
          unless (-e $file) {
            &Whine($., 'cant-get-url', xc($TAG), xc($ATTR), $url);
          }
        }
      }
    } elsif (!$whine) {
      &Whine($., 'illegal-format-url', xc($TAG), xc($ATTR), $urlorg);
    # &::PushStat('IllegalFormatURL', $urlorg) if !$illchar && $opt_stat;
    }
  }
  $reluri;
}

# gȂ`FbN
sub CheckCharURL
{
  my ($urlscan, $url, $nowhine) = @_;
  my $whine = 0;
  while ($urlscan =~ /($RFC2396::delimunwise|$unsafeuri)(.*)/o) {
    $urlscan = $2;
    my $c = substr($1, 0, 1);
    next if $1 eq '\\'; # łɌxς
    next if $1 eq '%' && $urlscan =~ /^$RFC2396::hex2/o;
    unless ($nowhine) {
      my $x = sprintf('%%%02X', ord($c));
      &Whine($., ($c =~ /$unsafeuri/o)? 'unsafe-url': 'excluded-url',
                 xc($TAG), xc($ATTR), $url, $c, $x);
      $whine++;
    }
  }
  $whine;
}

##################################################
# URL 𕪉 (http ̂)

sub ParseURL
{
  my $url = shift;
  $url =~ s/^\s*//;
  my $proto = ($url =~ s#^(\w*:)##)? lc($1): '';
  my $host = ($url =~ s#^(//[^/]*)##)? $1: '';
  my $port = '';
  ($host, $port) = ($1, $2) if $host =~ /^((?:[^@]+\@)?.+)(:\d+)$/;
  my $path;
  my ($file, $flgid)  = $url =~ /^([^#]*)(#.*)?$/;
  ($path, $file) = ($1, $2) if $file =~ m#^(/(?:[^/]*/)*)([^/]*)$#;
  ($proto eq ':' || $host eq '//' || $port eq ':')?
    undef: ($proto, $host, $port, $path, $file, $flgid);
}

##################################################
# URL ΃pXɂ (http ̂)

sub AbsoluteURL
{
  my ($base, $url, $dport) = @_;
  my ($bproto, $bhost, $bport, $bpath, $bfile) = &ParseURL($base);
  my ($uproto, $uhost, $uport, $upath, $ufile, $flgid) = &ParseURL($url);
  if ($dport) {  # ==80
    $bport =~ s/^://;
    $uport =~ s/^://;
    $bport = $dport if $bhost ne '' && $bport eq '';
    $uport = $dport if $uhost ne '' && $uport eq '';
    $bport = ':'.($bport+0);
    $uport = ':'.($uport+0);
  } else {
    $flgid = ''; # ʏ͎̂Ă
  }
  &NormalizeDots(
    (!($url ne '' && $upath eq '' && $ufile eq '') &&
     (($uproto eq '' || $uproto =~ /^http/i) && $bproto =~ /^http/i))?
        (($uproto ne '')? $uproto: $bproto).
        (($uhost  ne '')? $uhost.$uport: $bhost.$bport).
        (($upath  ne '')? $upath.$ufile: ($bpath.
        (($ufile  ne '')? $ufile: $bfile))).$flgid: $url);
}

##################################################
# URL  . 
                            BEGIN {
sub NormalizeDots
{
  my @files;
  my ($domain, $filespec) = ('', shift);
  if ($filespec =~ m#^(\w+://(?:[^/]+))(.*)$#) {
    ($domain, $filespec) = ($1, $2);
  }
  $filespec .= '/' if $filespec =~ m#(?:^|/)\.\.?$#;
  foreach (split(m#/+#, $filespec, -1)) {
    next if $_ eq '.';
    if ($_ eq '..' && @files) {
      my $parent = pop(@files);
      next if $parent ne '' && $parent ne $_;
      push(@files, $parent);
    }
    push(@files, $_);
  }
  $domain.join('/', @files);
}
                                  }

##################################################
# URL 𐳋K (http̂)

sub NormalizeURL
{
  my $url = shift;
  my ($domain, $filespec) = $url =~ m@^(\w+://[^/]+)?([^#\?]*)$@;
  $filespec = '/' if $domain !~ m#/$# && $filespec eq '';
  $domain =~ s#^(\w+://)#\L$1\E#;
  $filespec = &NormalizeDots($filespec);
  if ($filespec eq '' || ($domain eq '' && $filespec =~ m#^[^/.]#)) {
    $filespec = './'.$filespec;
  }
  $domain.$filespec;
}

##################################################
# URL r

sub CompareURL
{
  my ($url1, $url2) = @_;
  my $base = ($baseURL ne '')? $baseURL: $opt_base;
  &AbsoluteURL($base, $url1, 80) eq &AbsoluteURL($base, $url2, 80);
}

##################################################
# URL AJ[𕪗

sub SplitFragmentID
{
  my $url = shift;
  my $scheme;
  { # scheme ̂Ƃ܂Ŏ̎QƂ
    my $urlscan = $url;
    my $exurl = '';
    while ($urlscan =~ /^([^&]*)(&.*)/) {
      my ($scanned, $c) = ($1, $2);
      last if $scanned =~ /[:?#]/;
      ($urlscan, $c) = &CheckRefEntities($c, 1);
      $exurl .= $scanned.$c;
      last if $c eq ':';
    }
    $urlscan = $exurl.$urlscan;
    if ($urlscan =~ /^([^:?#]*):/) {
      $scheme = $1;
      if ($scheme !~ /^($RFC2396::scheme)$/o) {
        $scheme = substr($url, 0, length($url)-length($urlscan)+length($scheme));
      }
    }
    $url = $urlscan if $scheme ne '';
  }
  my $spurl = $url;
  my $frgid;
  if ($scheme eq '' || $scheme =~ /^(?:$::httpSchemes)?$/oi) {
    my ($cref, $sharp) = ($htmlVer >= 4)? ('\d|x[0-9A-F]', '23|x17'): ('\d', '23');
    { # # ̎̎QƂ
      my $urlscan = $url;
      while ($urlscan =~ /^([^&]*)(&.*)/g) {
        my ($scanned, $ref) = ($1, $2);
        my $c;
        ($urlscan, $c) = &CheckRefEntities($ref, 2);
        if ($c eq '#') {
          $ref =~ /^([^;]+;)(.*)/;
          $url =~ s/$1/#/;
          last;
        }
        last if $c eq ':';
      }
    }
    if ($url =~ /#/) {
      my @parts = split(/#/, $url);
      $spurl = @parts? shift(@parts): '';
      if (@parts) {
        foreach (@parts) {
          my $amp = $spurl =~ /&$/;
          unless ($amp && /^$cref/i) {
            $frgid = '#'.substr($url, length($spurl)+1);
            last;
          }
          if (/^((?:$sharp)(?:;|$|(?=\D)))/i) {
            my $splen = length($1)+2;
            $spurl = substr($spurl, 0, length($spurl)-1);
            $frgid = '#'.substr($url, length($spurl)+$splen);
            last;
          }
          $spurl = $spurl.'#'.$_;
        }
      } else {
        $frgid = '#';
      }
    }
  }
  ($scheme, $spurl, $frgid);
}

##################################################
# CDATA ]
#  $value ɓĂAʂɓ

sub CDATA
{
# unless ($quot) {
    my $c;
    my $value2 = '';
    while ($value =~ /^([^<&>]*)([<&>])(.*)$/) {
      $value2 .= $1;
      if ($2 eq '&') {
        ($value, $c) = &CheckRefEntities($2.$3);
        $value2 .= $c;
      } else {
        $value2 .= $2;
        $value = $3;
        &WhineRefEntities($2);
      }
    }
    $value = $value2.$value;
# }
}

##################################################
# CDATA/RCDATA ǂ
# CDATA/RCDATA ̏ÍA{ </ ł邪͂ĂȂ
# ǂ܂ꂽ͎̂Ă

sub ReadCDATA
{
  my $type = shift; # CDATA or RCDATA
  my $tag = $tagsNest[$#tagsNest]{tag};
  my ($start, $last, $pend);
  if (&GetLine =~ /^(<!--)($allc*)/o) {
    ($start, $line) = ($., $2);
  }
  my $elem = 0;
  while (&GetLine ne '') {
    my ($etag, $rest) = ('', '');
    ($line, $etag, $rest) = split(m#(</)#, $line, 2) if $line =~ m#</#;
    if ($line =~ /\S/ && $type eq 'CDATA' && $tag =~ /^${stylescript}$/oi) {
      if ($line =~ /^(.*)--\s*>\s*$/) {
        # --> ۗ
        ($line, $pend) = ($1, $.);
      } else {
        if ($pend) {
          &Whine($pend, ($htmlVer >= 4.5)? 'embedded-in-cdata': 'embedded-in-cdata-0', xc($tag), '--', &StyleOrScript($tag));
          undef $pend;
        }
      }
      while ($line =~ /(<|&|]]>|--)/g) {
        my $str = $1;
        &Whine($., ($htmlVer >= 4.5)? 'embedded-in-cdata': 'embedded-in-cdata-0', xc($tag), $str, &StyleOrScript($tag));
      }
    }
    if ($line =~ /\S/) {
      $elem++;
      $last = $line;
      if ($type eq 'RCDATA') {
        while ($line =~ /(&$allc*)/o) {
          ($line) = &CheckRefEntities($1);
        }
      }
    }
    if ($etag) {
      if ($rest =~ m#$tag[\s>]#i) {
        # I
        $line = $etag.$rest;
        last;
      }
      &Whine($., 'etago-in-cdata', xc($tag)) if $type eq 'CDATA';
    }
    $line = $rest;
  }
  if ($elem && $tag =~ /^(?:$::commentedElement)$/oi) {
    if ($start) {
      &Whine($., 'unclosed-comment', xc($tag), $start) unless ($pend || $last =~ /--\s*>\s*$/);
    } else {
      &Whine($., 'comment-element', xc($tag));
    }
  }
}
sub StyleOrScript { (shift eq 'STYLE')? 'X^CV[g': 'XNvg'; }

##################################################
# #PCDATA ǂ
# ǂ܂ꂽ $pcdata ɃZbg

sub ReadPCDATA
{
  $pcdata = '';
  my ($ln, $lnja);
  while () {
    if ($seenPre && $pretab) {
      &Whine($ln = $., 'tab-in-pre', xc('PRE'), $seenPre) if $ln != $.;
      $pcdata =~ s/\t/ /;
    }
    $pretab = 0;
    $pcdata .= ' ' if $line =~ /^\s+/;
    &SkipComment;
    last if $line eq '';
    if ($line =~ /^([^<&">]*)([<&">])($allc*)/o) {
      my ($pre, $delim, $rest) = ($1, $2, $3);
      $line = $delim.$rest;
      if ($delim eq '<' && $pre =~ /\S/ && $p_isnot_br != $. && 'P' =~ /^(?:$pairTags)$/) {
        my $chlin = uc($line);
        chomp($chlin);
        if ($chlin eq '<P>') {
          &Whine($., 'p-isnot-br', xc('P'), xc('BR'));
          $p_isnot_br = $.;
        }
      }
      if ($enabled{'lang-pcdata'} > 0.0 || $opt_pedantic) {
        if ($lnja != $. && &CheckLanguageCode($pre)) {
          &WhineLanguageCode($., 'lang-pcdata');
          $lnja = $.;
        }
      }
      $pcdata .= $pre;
      if ($delim eq '&') {
        $pcdata .= $line;
        my $pcode;
        ($line, $pcode) = &CheckRefEntities($line);
        $pretab++ if $pcode eq "\t";
        substr($pcdata, -length($line)) = '';
      } else {
        last if $delim ne '"' && &CheckTag ne '';
        &WhineRefEntities($delim);
        $pcdata .= $delim;
        $line = $rest;
      }
    } else {
      if ($enabled{'lang-pcdata'} > 0.0 || $opt_pedantic) {
        if ($lnja != $. && &CheckLanguageCode($line)) {
          &WhineLanguageCode($., 'lang-pcdata');
          $lnja = $.;
        }
      }
      $pcdata .= $line;
      $line = '';
    }
    $pretab++ if $pcdata =~ /\t/;
  }
  if ($pcdata =~ /^(.*?)(\s+)$/) {
    # s󔒂͖߂
    $line = $2.$line;
    $pcdata = $1;
  }
}

##################################################
# J^Oǂ`FbN
# $line J^OȂ < n܂镶񂪕Ԃ

sub CheckTag
{
  my $tag = '';
  if ($line =~ m#^(<(?:(\s*)/?($nameStr)|!(?:$nameStr)?))#) {
    $tag = $1;
    # 󔒂܂܂ĂƂ͐^Ôݒʂ
    $tag = '' if $2 ne '' && $3 !~ /^(?:$allTags)$/i;
  }
  $tag;
}

##################################################
# J^O𓾂
# $token  < ܂ޕ񂪋܂
# < Ƌ󔒂菜đ啶ɂ񂪕Ԃ
# ̃g[NJ^OłȂꍇ͋󕶎

sub GetTag
{
  my $tag = '';
  my $leadingspace = &SkipComment;
  if (($token = &CheckTag) =~ /^<(.*)/) {
    $tag = $1;
    &Whine($., 'leading-whitespace', '', xc(uc($tag))) if $tag =~ s/\s+//g;
    &CheckCase($tag, 0) unless $tag =~ /!/;
    $line = substr($line, length($token));
  }
  $token = ' '.$token if $leadingspace;
  $tag;
}

##################################################
# $token  $line ɖ߂

sub UnGetToken
{
  $line = $token.$line;
}

##################################################
# ^O > ܂œǂݔ΂
# rɉ 1 Ԃ

sub AdvanceCloseTag
{
  my ($tag, $ln) = @_;
  if (&GetLine =~ m#^>($allc*)#o) {
    $line = $1;
    return 0;
  }
  my $ret = $line ne '';
  if ($ret) {
    while (&GetLine ne '') {
      if ($line =~ m#([<>])($allc*)#o) {
        if ($1 eq '<') {
          &Whine($., 'unexpected-open', xc($tag));
        } else {
          $line = $2;
        }
        return 1;
      }
      $line = '';
    }
  }
  &Whine($., 'unclosed-tag', xc($tag), $ln);
  $ret;
}

##################################################
# 肷

sub StrLength
{
  my $str = shift;
  my $len = 0;
  my $dbcs;
  $str =~ s/^&($nameStr|#\d+)/a/g; # ̎QƂ1Ɋ
  $str =~ s/^&(#x[0-9A-F]+)/x/gi if $htmlVer >= 4;
  foreach (unpack('C*', $str)) {
    if ($dbcs) {
      undef $dbcs;
    } else {
      $len++;
      $dbcs = $_ >= 0x0080; # sjis/euc  DBCS z
    }
  }
  $len;
}

##################################################
# 啶`FbN

sub CheckCase
{
  my ($id, $typ) = @_; # $typ=0:TAG =1:ATTR
  if    ($id eq lc($id)) { $lcase[$typ]++; $lcaseln[$typ] = $.; }
  elsif ($id eq uc($id)) { $ucase[$typ]++; $ucaseln[$typ] = $.; }
  else                   { $xcase[$typ]++; $xcaseln[$typ] = $.; }
}

##################################################
# $TAG ̑ $token  $ATTR ɓ

sub GetAttrName
{
  $token = $ATTR = $subATTR = '';
  my $leadingspace = $line =~ /^(?:\s|$)/;
  while (&GetLine ne '') {
    if ($xhtml && $line =~ m#^(/?)(>$allc*)#) {
      if ($1) {
        $line = '></'.xc($TAG).$2;
        if (!$xml) {
          if (!$tagsElements{$TAG}) {
            unless ($leadingspace) {
              &Whine($., 'leading-space-endtag-slash', xc($TAG));
            }
          } else {
            &Whine($., 'noempty-endtag-slash', xc($TAG));
          }
        }
      } else {
        if (!$tagsElements{$TAG}) {
          $minetag = $TAG;
          if ($TAG !~ /^([^:]+):/ or !$xhtml) {
            &Whine($., 'contain-no-space', xc($TAG)) if $line =~ m#^>\s#;
          }
        }
      }
    }
    if ($line =~ m#^($nameStr|>)($allc*)#) {
      ($token, $line) = ($1, $2);
      if ($token ne '>') {
        &CheckCase($token, 1);
        if ($xhtml && $token ne lc($token)) {
          &Whine($., 'lower-case-attribute', xc($TAG), $token) if $TAG =~ /^(?:$allTags)$/ && $tagsAttributes{$TAG}->{uc($token)} ne '';
        }
        $ATTR = $token;
        if ($xhtml) {
          $ATTR =~ s/^\s+//;
          $ATTR =~ s/\s+$//;
          $ATTR =~ s/\s+/ /;
          $oATTR = $ATTR;
        } else {
          $oATTR = uc($ATTR);
        }
        $ATTR = uc($ATTR);
        if (!$leadingspace) {
          &Whine($., $xhtml? 'leading-space-attribute': 'leading-space-attribute-html', xc($TAG), xc($oATTR))
        }
        if ($ATTR =~ /^([^:]+:)(.*)/) {
          # IE5  XMLNS:namespace Ή
          my ($xmlns, $suffix) = ($1, $2);
          foreach (keys %tagsAttributes) {
            if ($tagsAttributes{$_}->{$xmlns} ne '') {
              &Whine($., 'unsupported-attribute', xc($TAG), xc($ATTR));
              ($ATTR, $subATTR) = ($xmlns, $suffix);
              push(@xmlns, $subATTR);
              last;
            }
          }
        }
      }
      last;
    }
    chomp($line);
    my ($rest, $mid);
    if ($line =~ /^([^\s\x21-\x2F\x3A-\x3F]*)([\s\x21-\x2F\x3A-\x3F])($allc*)/o) {
      ($rest, $mid, $line) = ($1, $2, $3);
      if ($mid =~ /[<\s>]/) {
        $line = $mid.$line;
      } else {
        $rest .= $mid;
      }
      if ($line =~ /^</) {
        &Whine($., 'unexpected-open', xc($TAG));
        $line = '>'.$line;
      } else {
        if (!$xhtml && $rest eq '/' && $line =~ /^>/) {
          &Whine($., 'xhtml-emptytag', ${$::doctypes{$rule}}{guide}, xc($TAG));
        } else {
          &Whine($., 'illegal-attribute', xc($TAG), $rest);
        }
      }
    } else {
      $rest = $line;
      $line = '';
      &Whine($., 'illegal-attribute', xc($TAG), $rest);
    }
  }
  $ATTR;
}

##################################################
# $TAG ̑ $ATTR ̑l $token ɓ
# $quot Ɉp̎ނ

sub
GetAttrValue
{
  $quot = '';
  $token = '';
  if (&GetLine =~ /^(["'])($allc*)/o) {
    ($quot, $line) = ($1, $2);
    my $quotregexp = "[<$quot>]";
    my $notquotregexp = "[^<$quot>]";
    my $across = 0;
    while () {
      if ($line =~ /^($notquotregexp*)($quotregexp)($allc*)/) {
        if ($2 eq $quot) {
          $token .= $1;
          $line = $3;
#         if ($token eq '') {
#           &Whine($., 'empty-value', xc($TAG), xc($ATTR));
#         }
          if ($quot eq "'") {
            ($quot = $token) =~ s/"/&quot;/g;
            &Whine($., 'attribute-delimiter', xc($TAG), xc($ATTR), $token, $quot);
          }
          last;
        } elsif ($2 eq '>') {
          $token .= $1;
          $line = $3;
#         if ($line =~ /^[^<"'>]*$quot/) {
#           㑱ɈpA<  > ȑOɌȂƂ
#           pĂƂ݂ȂĂ悢
#           $token .= '>';
#           &WhineRefEntities('>');
#         } else {
            $line = '>'.$line;
            &Whine($., 'unclosed-quotes', xc($TAG), xc($ATTR));
            last;
#         }
        } else {
          $token .= $1.$2;
          $line = $3;
          &WhineRefEntities($2);
        }
      } else {
        chomp($line);
        $token .= $line.' ';
        $line = '';
        if (&GetLine eq '') {
          &Whine($., 'unclosed-quotes', xc($TAG), xc($ATTR));
          last;
        }
        $across++;
      }
    }
    &Whine($., 'across-lines-attribute', xc($TAG), xc($ATTR)) if $across;
  } else {
    $line =~ /^([^<\s>]+)($allc*)/o;
    ($token, $line) = ($1, $2);
    &Whine($., ($token eq '')? 'no-attribute-value':
               ($token !~ /^$tokenStr$/ || &StrLength($token) > 72 || $xhtml)?
                 'quote-attribute-value':
               ($token !~ /^$stdTokenStr$/)?
                 'recommend-quote-attribute-value': 'bare-attribute-value',
                 $oTAG, $oATTR, $token)
  }
  $token;
}

##################################################
# Rg <!-- --> ǂݔ΂
# <!SGML...>  SGML錾/DTD錾ǂݔ΂
# <?...>  XML錾ǂݔ΂
# <![CDATA[...]]> ̃}[NԂxl

sub SkipComment
{
  my $leadingspace = $line =~ /^\s/;
  while (@markedSection && &GetLine =~ /^(.*?)]\s*]\s*>($allc*)/o) {
    $line = $1.$2;
    &CheckMarkedSection($1);
    $leadingspace = $line =~ /^\s/;
    pop(@markedSection);
  }
  while (&GetLine ne '') {
    if ($line =~ /^(<!(-{0,3}(\s*)!?)>)($allc*)/o) {
      $line = $4;
      if ($2 eq '') {
        &Whine($., 'empty-comment', $1);
        &Whine($., 'title-comment', xc($TAG)) if $TAG eq 'TITLE';
      } else {
        &Whine($., 'illegal-comment', $1);
      }
      &Whine($., 'space-in-closed-comment') if $3 ne '';
      next;
    }
    if ($line =~ /^<(![A-Za-z]+|\?)($allc*)/o) {
      my $token = uc($1);
      if ($token ne '!DOCTYPE') {
        my $tof = $readsize == length($line);
        $line = $2;
        if ($token eq '?') {
          $seenXml = ($line =~ /^xml[^\w\.\-]/)? $.: 0;
          #$seenXmlStylesheet = ($line =~ /^xml-stylesheet[^\w\.\-]/)? $.: 0;
          &Whine($., 'processing-instruction') unless $seenXml;
          &Whine($., 'misplaced-xmldecl') if $seenXml && !$tof;
        } else {
          &Whine($., 'ignore-declaration', '', $token);
#         &::PushStat('IgnoreDeclaration', $token) if $opt_stat;
        }
        while (&GetLine ne '') {
          if ($line =~ /^([^>]*)>($allc*)/o) {
            $line = $2;
            if ($seenXml) {
              $xmldecl .= $1;
              if ($xmldecl =~ /^(.*)\?$/) {
                $xmldecl = $1;
              } else {
                &Whine($., 'end-xmldecl');
              }
              &Whine($., 'bad-xmldecl') if $xmldecl !~ /^xml\s+version\s*=\s*(?:'1\.0'|"1\.0")(?:\s+encoding\s*=\s*(?:'[A-Za-z][A-Za-z0-9._\-]*'|"[A-Za-z][A-Za-z0-9._\-]*"))?(?:\s+standalone\s*=\s*(?:'(?:yes|no)'|"(?:yes|no)"))?\s*$/;
              if ($xmldecl =~ /\bencoding\s*=\s*["']([^"']+)["']/) {
                my $xc = $1;
                &CheckCHARSET($xc, 'HTTPX|Xwb_', $opt_charset, 'XML錾');
                $xcharset = $xc;
                $seenCharset = $.;
              }
            }
            return &SkipComment;
          } else {
            if ($seenXml) {
              chomp($line);
              $xmldecl .= $line.' ';
            }
          }
          $line = '';
        }
      }
    }
    if ($line =~ /^<!\[\s*([^\[\]]+)\s*\[?($allc*)/o) {
      my $mark = $1;
      $line = $2;
      &Whine($., 'marked-section', '', $mark);
      push(@markedSection, [ $mark, $., $#tagsNest ]);
      if ($htmlVer >= 4) {
        if (uc($mark) eq 'CDATA') {
          while (&GetLine ne '') {
            if ($line =~ /^(.*?)]]>($allc*)/o) {
              $line = $2;
              &CheckMarkedSection($1);
              pop(@markedSection);
              return &SkipComment;
            }
            &CheckMarkedSection($line);
            $line = '';
          }
        }
      }
      last;
    }
    last if $line =~ /^(?:[^<]|<[^!]|<![A-Za-z])/;
    my $ln = $.;
#   my ($whine_hyphens, $hyphen);
    my ($whine_markup, $markup, $closed);
    $line =~ /^(<!-{0,2})($allc*)/o;
    $line = $2;
    my $ill = $1 eq '<!';
    if ($1 ne '<!--') {
      &Whine($., 'illegal-comment', $1)
    } else {
      &Whine($., 'title-comment', xc($TAG)) if $TAG eq 'TITLE';
      if ($htmlVer >= 4.5 && $TAG =~ /^${stylescript}$/oi) {
        &Whine($., 'comment-in-stylescript', xc($TAG));
      }
    }
    while (&GetLine ne '') {
      unless ($line =~ /(<|--|-?>)($allc*)/o) {
        $line = '';
        next;
      }
      my $pre = $1;
      $line = $2;
      if ($pre eq '--') {
        if ($line =~ /^(!?)(\s*)>($allc*)/o) {
          $line = $3;
          &Whine($., 'space-in-closed-comment') if $2 ne '';
          &Whine($., 'illegal-closed-comment', '--!>') if $1 ne '';
          $closed = 1;
          $leadingspace++ if $line =~ /^\s/;
          last;
        }
        $line = '--'.$1 if $line =~ /^-+($allc*)/o;
#       if (!$whine_hyphens && $. != $hyphen) {
          &Whine($., ($htmlVer >= 4)? 'excluded-w-hyphens-in-comment':
                                               'w-hyphens-in-comment');
#       }
#       $whine_hyphens = $hyphen = $.;
      } elsif ($pre eq '->') {
        &Whine($., 'illegal-closed-comment', '', $pre);
        $closed = 1;
        last;
      } elsif ($ill && $pre =~ />$/) {
        $closed = 1;
        last;
      } else {
        if ($pre eq '<' && $htmlVer >= 4.5 && $TAG =~ /^${stylescript}$/oi) {
          my $etag;
          { local $line = '<'.$line; $etag = &CheckTag; }
          if (uc($etag) eq "</$TAG") {
            # <STYLE><SCRIPT> ł̓RgYƂ݂Ȃ
            $line = '<'.$line;
            last;
          }
        }
        if ($pre eq '<' && $line =~ /^!--($allc*)/o) {
          $line = $1;
          &Whine($., 'nested-comment');
        } elsif (!$whine_markup && $. != $markup) {
          &Whine($., 'markup-in-comment');
        }
        $whine_markup = $markup = $.;
      }
    }
    &Whine($., 'unclosed-comment', '', $ln) unless $closed;
  }
  $leadingspace;
}

sub CheckMarkedSection
{
  my $line = shift;
  my $section = $markedSection[0]->[0];
  my $parent = $tagsNest[$#tagsNest]{tag};
  my %checked;
  if ($section ne 'CDATA') {
    while ($line =~ /(<|&)/g) {
      my $str = $1;
      &Whine($., 'badstr-in-marked-section', '', $str) if !$checked{$str}++;
    }
  } elsif ($parent =~ /^${stylescript}$/oi) {
    while ($line =~ /(<|&|--)/g) {
      my $str = $1;
      &Whine($., 'embedded-in-cdata', xc($parent), $str,
             &StyleOrScript($parent), '̃}[N <![CDATA ` ]]> ') if !$checked{$str}++;
    }
  }
}

##################################################
# <!DOCTYPE...>

sub Doctype
{
  $HTML = 'HTML';
  my ($type, @whines, $tag, $lwspace, $doctypeline, $dln, $predoctype, $orgdoctype);
  my ($guide0, $guide1, $guide2, $guide3, $guide4);
  my ($expired, $obsoleted);
  if ($line eq '') {
    $line = <HTML>;
    $readsize += length($line);
  }
  my $firstline = $line;
  &SkipComment;
  undef $xhtml;
  $procdoctype = 1;
  if ($line =~ /^([^<]*)<(!DOCTYPE)($allc*)/oi) {
    $predoctype = $1;
    $orgdoctype = $2;
    $line = $3;
    if ($predoctype ne '') {
      if ($predoctype =~ /[\00-\x08\x0B\x0C\x0E-\x1F\x7F]/) {
        push(@whines, 'prectrl-doctype');
      }
      push(@whines, 'required-doctype');
    }
  }
  if ($orgdoctype eq '') {
    push(@whines, 'required-doctype');
    &UnGetToken;
  } else {
    $tag = uc($orgdoctype);
    $dln = $.;
    while (&GetLine ne '') {
      if ($line =~ /^([^<>]*)([<>])($allc*)/o) {
        $line = $2.$3;
        $doctypeline = &Join(' ', $doctypeline, $1);
        last;
      }
      chomp($line);
      $doctypeline = &Join(' ', $doctypeline, $line);
      $line = '';
    }
    $doctypeline =~ s/^\s+//;
    foreach my $guess (0..1) {
      foreach (keys %::doctypes) {
        my $doctype = ${$::doctypes{$_}}{doctype};
        if ($doctype ne '' && $doctypeline =~ /^($doctype)/i) {
          my $sysid = substr($doctypeline, length($1));
          $sysid = ($sysid =~ /^\s*["'](.+)["']/)? $1: '';
          my $rulsysid = ${$::doctypes{$_}}{system};
          if ($guess == 0 && $rulsysid) {
            if (${$::doctypes{$_}}{version} >= 4.5 || $sysid ne '') {
#             next if $sysid eq '' || ($rulsysid !~ /$sysid$/i && $sysid !~ /$rulsysid$/i);
              next if $sysid eq '' || $sysid !~ /$rulsysid$/i;
            }
          }
          my $sep = q|\[\"\'\]|;
          my ($public, $pubid) = $doctype =~ /(PUBLIC)?\\s\+($sep.+$sep)/oi;
          $type = $_;
          $obsoleted = ${$::doctypes{$_}}{obsoleted};
          $expired = ${$::doctypes{$_}}{expired};
          push(@whines, 'doctype-case-mismatch') if $public && $doctypeline !~ /$pubid/;
          if ($guess) {
            push(@whines, ($sysid eq '')? 'empty-systemid': 'illegal-systemid');
          } elsif ($sysid ne '' && $rulsysid !~ /$sysid$/ && $sysid !~ /$rulsysid$/) {
            push(@whines, 'systemid-case-mismatch');
          }
          last;
        }
      }
      last if $type;
    }
    unless ($type) {
      foreach (keys %::xdoctypes) {
        my $doctype = ${$::xdoctypes{$_}}{doctype};
        if ($doctype ne '' && $doctypeline =~ /^(?:$doctype)/i) {
          $type   = ${$::xdoctypes{$_}}{subst};
          $guide3 = ${$::xdoctypes{$_}}{guide};
          last;
        }
      }
      if ($type) {
        $expired = ${$::doctypes{$type}}{expired};
        $guide2 = ${$::doctypes{$type}}{abbr}.' Ƃ݂Ȃ܂B';
        push(@whines, 'unsupported-doctype');
      } else {
        unless ($opt_igndoctype) {
          foreach (keys %::xdoctypes) {
            my $doctype = ${$::xdoctypes{$_}}{guess};
            if ($doctype ne '' && $doctypeline =~ /(?:$doctype)/i) {
              $type = ${$::xdoctypes{$_}}{subst};
              last;
            }
          }
          unless ($type) {
            foreach (keys %::doctypes) {
              my $doctype = ${$::doctypes{$_}}{guess};
              if ($doctype ne '' && $doctypeline =~ /(?:$doctype)/i) {
                $type = $_;
                last;
              }
            }
          }
          if ($type) {
            $expired = ${$::doctypes{$type}}{expired};
            $guide2 = ${$::doctypes{$type}}{abbr}.' Ƃ݂Ȃ܂B';
          }
        }
        push(@whines, 'unknown-doctype');
      # &::PushStat('UnknownDoctype', $doctypeline) if $opt_stat;
      }
    }
  }
  if ($opt_x) {
    foreach (keys %::doctypes) {
      if ($opt_x =~ /^(?:${$::doctypes{$_}}{name})$/i) {
        $rule = $_;
        $guide2 = '';
        last;
      }
    }
    print 'Kt@C '.$opt_x.' ͓o^Ă܂B'."\n" unless $rule;
  }
  $rule = $type if !$opt_igndoctype && $type;
  my $mismatch = !@whines && $rule && $type ne $rule;
  if ($mismatch) {
    my $superset = ${$::doctypes{$rule}}{superset};
    foreach (split(/\|/, $superset)) {
      my $doctype = ${$::doctypes{$_}}{doctype};
      if ($doctype ne '' && $doctypeline =~ /^(?:$doctype)/i) {
        $mismatch = 0;
        last;
      }
    }
  }
  if ($obsoleted) {
    push(@whines, 'obsoleted-doctype');
    $guide0 = ${$::doctypes{$type}}{guide};
    $guide4 = ${$::doctypes{$obsoleted}}{guide}
  } elsif ($expired) {
    push(@whines, 'expired-doctype');
    $guide0 = $expired;
  }
  $rule = $type unless $rule;
  $rule = $::defaultrule unless $rule;
  # e DOCTYPE ɑΉK
  my $file = $rule.'.rul';
  if ($file ne $rulefile && !&ReadRule($file)) {
    print 'w肳ꂽ DOCTYPE ɑΉKt@C܂B'."\n";
    $rule = ($rule eq $type)? '': $type;
    $rule = $::defaultrule unless $rule;
    $file = $rule.'.rul';
    $mismatch = 0;
    return 1 unless &ReadRule($file);
  }
  $allTags = &Join('|', $emptyTags, $pairTags);
  push(@whines, 'doctype-mismatch') if $mismatch;
  print STDERR "$htmlfile\n" if $opt_echoname;
  $guide1 = ${$::doctypes{$rule}}{guide};
  print $htmlfile.'  '.$guide1.' Ƃă`FbN܂B'."\n" if $opt_banner;
  foreach (@whines) { &Whine($., $_, $guide0, $guide1, $guide2, $guide3, $guide4); }
  &AdvanceCloseTag($tag, $.) if $tag ne '';
  # HTML4 ł͖O _  : ǉĂ
  $htmlVer = ${$::doctypes{$rule}}{version};
  $xhtml = $htmlVer >= 4.5;
  $xml = ($xhtml && $opt_mime eq 'application/xhtml+xml') || ($htmlVer >= 4.6);
  $isohtml = ${$::doctypes{$rule}}{group} eq 'ISO15445';
  $nameChr    = ($htmlVer >= 4)? '[A-Za-z0-9\.\-_:]': $stdNameChr;
  $nameStr    = ($xhtml? '[A-Za-z_]': '[A-Za-z]').$nameChr.'*';
  $idStr      = $xhtml? '[A-Za-z_][A-Za-z0-9\.\-_]*': $nameStr;
  $tokenStr   = $nameChr.'+';
  $nutokenStr = '\d'.$nameChr.'*';
  %tokenizedType = (
    NAME     => $nameStr,
    NAMES    => $nameStr.'(\s+'.$nameStr.')*',
    NMTOKEN  => $tokenStr,
    NMTOKENS => $tokenStr.'(\s+'.$tokenStr.')*',
    NUTOKEN  => $nutokenStr,
    NUTOKENS => $nutokenStr.'(\s+'.$nutokenStr.')*',
    NUMBER   => $digits,
    'NUMBER+'=> $digits,
    NUMBERS  => $digits.'(\s+'.$digits.')*',
    ENTITY   => $nameStr,
    ENTITIES => $nameStr.'(\s+'.$nameStr.')*',
    ID       => $idStr,
    IDREF    => $idStr,
    IDREFS   => $idStr.'(\s+'.$idStr.')*',
  );
  $noOmitEtag = $::noOmissibleEndTags;
  if (${$::doctypes{$rule}}{doctype} =~ /^([\w\.\-]+)/) {
    $HTML = uc($1);
  }
  if ($rule =~ /^mozilla/) {
    $noOmitEtag .= '|TD|TH';
  }
  if ($rule =~ /^jpo/) {
    &Whine($., 'jpo-no-html', xc($HTML), ${$::doctypes{$rule}}{guide})
      unless $firstline =~ /^<\s*HTML\s*>/i;
  }
  my ($html, $public) = $doctypeline =~ /^([\w\.\-]+)\s+(\w+)/;
  if ($xhtml) {
    &Whine($dln, 'xhtml-xmldecl', '', ${$::doctypes{$rule}}{group}) unless $xmldecl;
    &Whine($dln, 'lower-case-doctype', '', $html) if $html ne lc($html);
    $omitStartTags = $omitEndTags = '';
  }
  if ($htmlVer >= 4.5) {
    my @nouc;
    push @nouc, "`$orgdoctype`" if $orgdoctype ne uc($orgdoctype);
    push @nouc, "`$public`" if $public ne uc($public);
    &Whine($dln, 'upper-case-doctype', '', join('  ', @nouc)) if @nouc;
  }
  0;
}

##################################################
# s $line ɓǂށBEOF Ȃ󕶎񂪕ԂB

sub GetLine
{
  for (;;) {
    # s󔒂̂Ă
    $line =~ s/^(\s+)//;
    $pretab += $1 =~ /\t/;
    last if $line ne '';
    $line = ($ungetl ne '')? $ungetl: <HTML>;
    $ungetl = '';
    $readsize += length($line);
    if ($line eq '' && eof) {
      unless ($reacheof) {
        $.++;
        $reacheof = 1;
      }
      last;
    }
    if (!defined($textcode)) {
      if (!defined($charset) || $jcharcode) {
        if ($bom) {
          if ($bom eq "\xEF\xBB\xBF") { # UTF-8 ȊO͖
            $textcode = 'utf8';
          } else {
            $textcode = '';
          }
        } else {
#         # {̂Ƃ̂ $textcode ݒ肳  
#         if (${$lang}{val} ne '' && ${$lang}{val} !~ /^(?:ja|jpn)(?:-JP)?$/i) {
#           $textcode = '';
#         } else {
           $textcode = &DetectEncoding(\$line);
           if ($fromfile && $textcode =~ /^(?:euc|sjis|utf8)$/) {
             # 딻悤Ɠw͂Ă݂
             my $tell = tell(HTML);
             my $buff;
             my %app = ( $textcode=>1 );
             foreach (1..10) { # 10xł悩낤
               read(HTML, $buff, 1024) or last;
               my $code = &DetectEncoding(\$buff);
               next unless $code;
               if ($app{$code}++) {
                 $textcode = $code;
                 last;
               }
             }
             seek(HTML, $tell, 0);
           }
#         }
        }
        if ($textcode ne '' && &CallCGI()) {
          #  : CGǏĂяôƂ
          $::TXTCODE = $textcode;
        }
      } else {
        $textcode = '';
      }
    }
    if ($nonAsciiEarly == 0 && !$metaCharset && !$xcharset && $textcode ne 'jis' && 'META' =~ /^(?:$allTags)$/) {
      my @s = split(/(<META\s[^>]*>)/i, $line, 2);
      $line = $s[0].$s[1];
      $ungetl = $s[2];
      if ($line =~ /[^\x09\x0A\x0D\x20-\x7E]/) {
        &Whine($., 'non-ascii-early', xc('META'),
               xc('HTTP-EQUIV="CONTENT-TYPE" CONTENT').'="`"', xc('CHARSET'));
        $nonAsciiEarly++; # xɂȂƔߎS
      }
    }
    if (!$opt_igncharset) {
      if (($charset eq 'usascii' || $textcode eq 'jis') && $line =~ /[\x7F-\xFF]/) {
        &Whine($., 'non-ascii');
      }
      if ($textcode eq 'jis' && $line =~ /\e\(I/) {
        &Whine($., (${$::doctypes{$rule}}{restrict} & $::restrictkana)?
                                'han-katakana-0': 'han-katakana');
      } elsif ($textcode eq 'sjis' && $line =~ /[\xA0-\xDF]/) {
        my $esc = 0;
        foreach (unpack('C*', $line)) {
          $esc = 2 if $esc <= 0 && ((0x0081 <= $_ && $_ <= 0x009F) ||
                                    (0x00E0 <= $_ && $_ <= 0x00FC));
          if ($esc-- <= 0) {
            if (0x00A0 <= $_ && $_ <= 0x00DF) {
              &Whine($., (${$::doctypes{$rule}}{restrict} & $::restrictkana)?
                                'han-katakana-0': 'han-katakana');
              last;
            }
          }
        }
      }
      my $deesc = $line;
      if ($textcode && $escapeseq{$textcode}) {
        $deesc =~ s/$escapeseq{$textcode}//og;
      }
      if ($deesc =~ /([\x00-\x08\x0B\x0C\x0E-\x1F])/) {
        &Whine($., 'ctrl-character', '', $1); # \ꕶł悩낤
      }
    }
    if ($Jcode && $textcode =~ /^(?:utf8)$/) {
      &Jconvert(\$line, $myCODE, $textcode);
    } elsif ($textcode =~ /^(?:jis|euc|sjis)$/) {
      &Jconvert(\$line, $myCODE, $textcode) if $myCODE ne $textcode;
      if ($line =~ /[\x80-\xFF]/) {
        my $bad = '';
        if ($myCODE eq 'euc') {
          # G3 ͍lȂ
          my $c = 0;
          foreach (unpack('C*', $line)) {
            if ($c) {
              if (0x00A1 <= $_ && $_ <= 0x00FE && $c != 0x008E) {
                my $n = ($c<<8)|$_;
                if ($rule =~ /^jpo/ && $n == 0xA2A3) {
                  &Whine($., 'jpo-bad-char', '', ${$::doctypes{$rule}}{guide}, '');
                }
                unless (($n < 0xB0A1)?
                          ($n < 0xA4A1)?
                            ($n < 0xA3B0)?
                              ($n < 0xA2DC)?
                                ($n < 0xA2BA)? (0xA1A1 <= $n && $n <= 0xA2AE):
                                ($n < 0xA2CA)? ($n <= 0xA2C1):
                                               ($n <= 0xA2D0):
                                ($n < 0xA2F2)? ($n <= 0xA2EA):
                                               ($n <= 0xA2F9 || $n == 0xA2FE):
                              ($n < 0xA3C1)? ($n <= 0xA3B9): # 
                              ($n < 0xA3E1)? ($n <= 0xA3DA): # p啶
                                             ($n <= 0xA3FA): # p
                            ($n < 0xA6A1)?
                              ($n < 0xA5A1)? ($n <= 0xA4F3): # Ђ炪
                                             ($n <= 0xA5F6): # J^Ji
                              ($n < 0xA7A1)?
                                ($n < 0xA6C1)? ($n <= 0xA6B8): # MV啶
                                               ($n <= 0xA6D8): # MV
                                ($n < 0xA8A1)?
                                  ($n < 0xA7D1)? ($n <= 0xA7C1): # VA啶
                                                 ($n <= 0xA7F1): # VA
                                                 ($n <= 0xA8C0): # rf
                          ($n < 0xD0A1)? ($n <= 0xCFD3):   # ꐅ
                                         ($n <= 0xF4A6)) { # 񐅏
                  $c = pack('CC', $c, $_);
                  foreach (keys %{${$::doctypes{$rule}}{alloweuc}}) {
                    if ($n >= $_ && $n <= ${$::doctypes{$rule}}{alloweuc}{$_}) {
                      $c = '';
                      last;
                    }
                  }
                  if ($c ne '') {
                    $bad .= $c;
                    &::PushStat('BadJISX0208', $c) if $opt_stat;
                  }
                }
              }
              $c = 0;
            } elsif ((0x00A1 <= $_ && $_ <= 0x00FE) || $_ == 0x008E) {
              $c = $_;
            }
          }
        } elsif ($myCODE eq 'sjis') {
          my $c = 0;
          foreach (unpack('C*', $line)) {
            if ($c) {
              if ((0x0040 <= $_ && $_ <= 0x007E) ||
                  (0x0080 <= $_ && $_ <= 0x00FC)) {
                my $n = ($c<<8)|$_;
                if ($rule =~ /^jpo/ && $n == 0x81A1) {
                  &Whine($., 'jpo-bad-char', '', ${$::doctypes{$rule}}{guide}, '');
                }
                unless (($n < 0x889F)?
                          ($n < 0x829F)?
                            ($n < 0x824F)?
                              ($n < 0x81DA)?
                                ($n < 0x81B8)? (0x8140 <= $n && $n <= 0x81AC):
                                ($n < 0x81C8)? ($n <= 0x81BF):
                                               ($n <= 0x81CE):
                                ($n < 0x81F0)? ($n <= 0x81E8):
                                               ($n <= 0x81F7 || $n == 0x81FC):
                              ($n < 0x8260)? ($n <= 0x8258): # 
                              ($n < 0x8281)? ($n <= 0x8279): # p啶
                                             ($n <= 0x829A): # p
                            ($n < 0x839F)?
                              ($n < 0x8340)? ($n <= 0x82F1): # Ђ炪
                                             ($n <= 0x8396): # J^Ji
                              ($n < 0x8440)?
                                ($n < 0x83BF)? ($n <= 0x83B6): # MV啶
                                               ($n <= 0x83D6): # MV
                                ($n < 0x849F)?
                                  ($n < 0x8470)? ($n <= 0x8460): # VA啶
                                                 ($n <= 0x8491): # VA
                                                 ($n <= 0x84BE): # rf
                          ($n < 0x989F)? ($n <= 0x9872):   # ꐅ
                                         ($n <= 0xEAA4)) { # 񐅏
                  $c = pack('CC', $c, $_);
                  foreach (keys %{${$::doctypes{$rule}}{allowsjis}}) {
                    if ($n >= $_ && $n <= ${$::doctypes{$rule}}{allowsjis}{$_}) {
                      $c = '';
                      last;
                    }
                  }
                  if ($c ne '') {
                    $bad .= $c;
                    &::PushStat('BadJISX0208', $c) if $opt_stat;
                  }
                }
                $c = 0;
              } else {
                $c = ((0x0081 <= $_ && $_ <= 0x009F) ||
                      (0x00E0 <= $_ && $_ <= 0x00FC))? $_: 0;
              }
            } elsif ((0x0081 <= $_ && $_ <= 0x009F) ||
                     (0x00E0 <= $_ && $_ <= 0x00FC)) {
              $c = $_;
            }
          }
        }
        &Whine($., 'bad-jis-x0208', '', $bad) if $bad ne '';
      }
    }
  }
  $line;
}

##################################################
# A
# join() ł͋󕶎AĂ܂͋󕶎͎̂Ă

sub Join
{
  my $sep = shift;
  my $str = '';
  foreach (@_) { $str = ($str ne '')? $str.$sep.$_: $_ if $_ ne ''; }
  $str;
}

##################################################
# xɕt^O/l̃KCh

sub FormatGuide
{
  my ($s, $e, $aval, $format, $limit) = @_;
  my $msg = '';
  if ($aval ne '') {
    my @v = split(/\|/, $aval);
    my $x = ($s ne '' && $e ne '')? '': ',';
    if ($limit && $limit <= $#v) {
      splice(@v, $limit);
      $msg = join(',', map { ($_ eq '#PCDATA')? 'ʂ̃eLXg':
                                                ($s eq '<')? xc("$s$_$e"): "$s$_$e" } @v);
      $msg =~ s/,($s[^$s$e$x]+$e)$/  $1/;
      $msg .= ' Ȃ';
    } else {
      $msg = join(',', map { ($_ eq '#PCDATA')? 'ʂ̃eLXg':
                                                ($s eq '<')? xc("$s$_$e"): "$s$_$e" } @v);
      $msg =~ s/,($s[^$s$e$x]+$e)$/ ܂ $1/;
    }
    $msg =~ s/,/A/g;
    $msg = sprintf($format, $msg) if $format ne '';
  }
  $msg;
}

sub FormatTagGuide
{
  &FormatGuide('<', '>', @_);
}

sub FormatAttrGuide
{
  &FormatGuide('`', '`', @_);
}

sub FormatOtherHTMLsGuide
{
# if ($#_ > 4) {
   &FormatGuide('', '', 'HTML');
# } else {
#    my @htmls;
#    my $last;
#    foreach (sort {${$::doctypes{$a}}{order} <=> ${$::doctypes{$b}}{order}} @_) {
#      my $html = (${$::doctypes{$rule}}{group} eq ${$::doctypes{$_}}{group})?
#                  ${$::doctypes{$_}}{abbr}: ${$::doctypes{$_}}{group};
#      push(@htmls, $last = $html) if $last ne $html;
#    }
#    ' '.&FormatGuide('', '', join('|', @htmls)).' ';
# }
}

##################################################
# ̎QƂ`FbN
# & Ŏn܂镶𒲂ׁAKɌx𔭂Ēׂ̕
# fR[h̎QƂXgŕԂ

sub CheckRefEntities
{
  my ($line, $urichk, $refchk) = @_; # $urichk : 0=Sx 1=ꕔx 2=x
  my $orgline = $line;
  my $pcode;
  if ($line =~ /^&($nameStr|#\d+)($allc*)/ ||
      # HTML4 ł 16i̕QƂ\
      ($htmlVer >= 4 && $line =~ /^&(#x[0-9A-F]+)($allc*)/oi)) {
    $line = $2;
    my $ref = $1;
    my $code;
    if ($ref =~ /^#(.*)/) {
      $code = $1;
      if ($code =~ /^x(.*)/i) {
        $code = hex($1);
        if ($xhtml && $ref =~ /^#X/) {
          $ref =~ s/^#X/#x/;
          &Whine($., 'lower-x', ${$::doctypes{$rule}}{guide}, '&'.$ref.';') if $urichk < 2;
        }
      }
      if ($line =~ /^;($allc*)/o) {
        $line = $1;
        $ref .= ';';
      } else {
        &Whine($., 'required-semicolon', '&'.$ref) if $urichk < 2;
      }
      if ($urichk < 2) {
        my $limit = ${$::doctypes{$rule}}{charref};
        if (defined($limit) && $code >= $limit) {
          if ($limit) {
            $limit--;
            $limit = sprintf('x%lX', $limit) if $ref =~ /^#x/i;
            &Whine($., 'over-ref-charset', '&'.$ref, '&#'.$limit.';');
          } else {
            &Whine($., 'no-ref-charset', '&'.$ref);
          }
        }
      }
    } else {
      if ($code = $refEntities{$ref}) {
        if ($line =~ /^;($allc*)/o) {
          $line = $1;
          $ref .= ';';
        } else {
          &Whine($., 'required-semicolon', '&'.$ref) if $urichk < 2;
        }
        if ($ref =~ /^apos;?$/) {
          &Whine($., 'apos') if $urichk < 2;
        }
        $code =~ /^&#([^;]*)/;
        $code = $1;
      } else {
        my $cand;
        foreach (keys %refEntities) {
          if (lc($ref) eq lc) {
            # 啶Ⴄ̃P[X
            $cand = $_;
            last;
          } elsif ($ref =~ /^$_/i) {
            # 擪vP[X
            $cand = $_;
          }
        }
        if ($line =~ /^;($allc*)/o) {
          $line = $1;
          $ref .= ';';
        }
        if ($urichk < 2) {
          &Whine($., 'bad-entity',
                     '&'.$ref, $cand? '&'.$cand.'; Ȃ琳̂łB': '');
#         &::PushStat('BadEntity', '&'.$ref) if $opt_stat;
       }
      }
    }
    if ($code ne '') {
      $pcode = chr($code);
      if ($urichk && $refchk && $pcode =~ /($RFC2396::spdelimunwise)/o) {
        if ($1 ne '%') {
          &Whine($., 'excluded-url-ref', xc($TAG), xc($ATTR), '&'.$ref, $1);
          &::PushStat('ExcludedURLRef', '&'.$ref) if $opt_stat;
        }
      }
    }
  } else {
    $line = substr($line, 1);
    &WhineRefEntities($pcode = '&') if $urichk < 2;
  }
  if ($pcode eq '') {
    $pcode = substr($orgline, 0, length($orgline)-length($line));
  }
  ($line, $pcode);
}

##################################################
# ̎QƂɊւx\

sub WhineRefEntities
{
  my $c = shift;
  &Whine($., 'literal-metacharacter', '&', '&amp;'), return if $c eq '&';
  &Whine($., 'literal-metacharacter', '<', '&lt;') , return if $c eq '<';
  &Whine($., 'literal-metacharacter', '>', '&gt;') , return if $c eq '>';
  if ($quot eq '') {
    &Whine($., 'double-quote-in-text',  '"', '&quot;'), return if $c eq '"';
  } elsif ($quot eq '"') {
    &Whine($., 'literal-metacharacter', '"', '&quot;'), return if $c eq '"';
  }
}

##################################################
# Ȃ^OɊւx\

sub WhineExcludedElement
{
  unless ($xmlns) {
    my ($tag, $parent, $pln, $msg) = @_;
    my $inhead;
    if ($headElements && $tag =~ /^(?:$thisTagElements)$/) {
      $inhead = xc('<HEAD>`</HEAD>').' ł́A';
      $msg = '';
    }
    if ($xhtml && !$tagsElements{$parent}) {
      &Whine($pln, 'endtag-slash', xc($parent));
      return 1;
    }
    ($tag eq '#PCDATA')?
      &Whine($., 'unexpected-pcdata', '', xc($parent), $inhead):
      &Whine($., 'excluded-element', xc($tag), xc($parent), $pln, $msg, $inhead);
  }
  0;
}

##################################################
# sȃ^OɊւx\

sub WhineUnknownElement
{
  my $tag = shift;
  my $TAG = uc($tag);
  my $id = ($TAG =~ m#^/(.*)#)? $1: $TAG;
  if (!$xmlns) {
    if ($TAG ne $id && $id !~ /^(?:$pairTags)$/ && $id =~ /^(?:$emptyTags)$/) {
      &Whine($., 'illegal-closing', xc($TAG), xc($id));
      &::PushStat('IllegalClosing', $id) if $opt_stat;
    } else {
      if ($TAG !~ /^(?:[^:]+):/) { # IE5  XMLNS:namespace Ή
        my @htmls = grep($id =~ /^(?:$pairTags{$_})$/, keys %pairTags);
        if ($id eq $TAG) {
          push(@htmls, grep($id =~ /^(?:$emptyTags{$_})$/, keys %emptyTags));
        }
        if (@htmls) {
          &Whine($., 'other-html-element', xc($TAG), &FormatOtherHTMLsGuide(@htmls));
          return 1;
        }
      } else {
        return 0 if $xhtml;
      }
      &Whine($., 'unknown-element', $tag);
      &::PushStat('UnknownElement', $tag) if $opt_stat;
    }
  }
  0;
}

##################################################
# sȑɊւx\

sub WhineUnknownAttribute
{
  my ($tag, $attr) = @_;
  if ($xmlns) {
    return if $tag !~ /^(?:$allTags)$/;
  }
  my @htmls = grep { $attr =~ /^(?:$attributes{$_}->{$tag})$/ } keys %attributes;
  if (@htmls) {
    &Whine($., 'other-html-attribute', xc($tag), xc($attr),
               &FormatOtherHTMLsGuide(@htmls)) if $unknownTag != 2;
  } else {
    if ($tag =~ /^(?:$allTags)$/) {
      &Whine($., 'unknown-attribute', xc($tag), $oATTR); #  $oATTR ͂܂Ȃ
      &::PushStat('UnknownAttribute', $tag.' '.$attr) if $opt_stat;
    }
  }
}

##################################################
# I^ȌȗɊւx\
# 3 &OmitEndTag ̌ʂ != 0

sub WhineOmitEndTag
{
  my ($tag, $end, $omit) = @_;
  my $whine = 0;
  if ($tag eq $lastTag && $tag !~ /^(?:$maybeEmpty)$/) {
    # vfȂxo
    $whine = 1;
  } elsif ($omit == 1) {
    # ^ÔƂ
    my $last = &ExpandInternalElements($onceonlyTags{$tagsNest[$#tagsNest-1]{tag}});
    $whine = 1 if $#tagsNest == 0 || ($tag =~ /^(?:$last)$/ &&
                                      $tag !~ /^(?:$omitStartTags)$/);
  } elsif ($tag =~ /^(?:$noOmitEtag)$/) {
    $whine = 1;
  } elsif ($omit == 2 && $tag ne $end) { # <P>`<P> ̂悤ȂƂ͏ȗƂ݂Ȃ
    # vf $tag ܂܂Ă
    # #PCDATA ܂܂ĂȂƂ́Aʂ͏ȗI^OƂ݂Ȃ
    my $last = &ExpandInternalElements($tagsElements{$tagsNest[$#tagsNest-1]{tag}});
    $whine = 1 unless $tag =~ /^(?:$last)$/ && '#PCDATA' !~ /^(?:$last)$/;
  }
  &Whine($., $whine? ($tag !~ /^($omitEndTags)$/)?
             'required-end-tag': 'omit-end-tag': 'omit-end-tag-trivial',
             xc($tag), $end? xc("<$end>").' ̑O': '');
  &::PushStat('OmitEndTag', $tag) if $opt_stat && $whine;
}

##################################################
# xbZ[W\

sub Whine
{
  unless (%messages) { # foOp
    print @_, "\n";
    return;
  }
  my ($ln, $id, @argv) = @_;
  # $argv[0] ͗vfA܂֌Wȕ
  if ($analizing && uc($argv[0]) eq 'INPUT' && $seenAttrs{TYPE} ne '') {
    $argv[0] = xc(qq|INPUT TYPE="\U$seenAttrs{TYPE}"|);
  }
  my $oid = $id;
  my $msg = ${$messages{$id}}[0];
  my $pnt = $enabled{$id};
  unless ($msg) {
    $oid = $alias_messages{$id};
    $msg = ${$messages{$oid}}[0];
    $pnt = -$pnt if $enabled{$oid} < 0.0;
  }
  if ($msg) {
    $::whinesStat{$id}++;
    return if (!$opt_religious     && $religious{$oid}) ||
              (!$opt_accessibility && $accessibility{$oid});
    if ($pnt >= 0.1) {
      $uniquewhine{$id}? ($upenalty += $pnt): ($penalty += $pnt);
      $pwhinescnt++;
    } elsif ($pnt < -0.01 && $opt_pedantic) {
      $uniquewhine{$id}? ($upenalty -= $pnt): ($penalty -= $pnt);
      $pwhinescnt++;
    }
    return unless $pnt > 0.0 || $opt_pedantic;
    $maxpnt = $pnt if $maxpnt < $pnt;
  } else {
    $pnt = 1; # Zʂ͓K
    $penalty += $pnt;
    $msg = 'sȃbZ[Wv : '.$id;
  }
  if ($opt_warnings) {
    my $file = $htmlfile;
#   $file =~ s#/#\\#g if $WIN;
    $file =~ s/\\/\\\\/g;
    $file =~ s/\$/\\\$/g;
    $file =~ s/\@/\\\@/g;
    $file =~ s/\%/\\\%/g;
    unless (&CallCGI()) {
      my $n = int(&WhineScore($id)+0.9);
      $n = 9 if $n > 9;
      $msg = "$n: $msg";
    }
    if ($opt_w eq 'long') {
      $msg = "$ln: $id: $msg";
    } elsif ($opt_w eq 'short') {
      $msg = "$ln: $msg";
    } elsif ($opt_w eq 'verbose') {
      $msg = "$file: $ln: $oid: $msg";
    } elsif ($opt_w eq 'terse') {
      $msg = "$file:$ln:$oid";
    } else { # 'lint'
      $msg = "$file($ln): $msg";
    }
    if ($pnt < 0.1) {
      return if $::whinesStat{$id} > $opt_omit;
      if ($::whinesStat{$id} == $opt_omit) {
        my $addmsg = 'ȍ~̌x͕\܂B';
        $addmsg =~ s/\\/\\\\/g;
        $msg .= $addmsg;
      }
    }
    $msg = eval qq|"$msg"|;
    $msg =~ s/\\([\[\]\{\}])/$1/g;
    unless (&CallCGI()) {
      # CGǏĂяôƂ̓GXP[vCGIōsȂ
      $msg =~ s/([\x00-\x08\x0B\x0C\x0E-\x1F])/'^'.chr(ord($1)+0x40)/eg;
    }
    print "$msg\n";
  }
  $whinescnt++;
}

##################################################
# x̗Lݒ肷

sub EnableWarning
{
   my ($id, $en) = @_;
   $id = $shortid{$id} if $shortid{$id};
   if (${$messages{$id}}[0]) {
     my $n = $enabled{$id};
     $n = -$n if $n < 0.0;
     $enabled{$id} = $en? $n: -$n if $n < 100;
     return 1;
   }
#  print "$configfile: $.: " if $configfile ne '';
   print "Unknown warning id `$id`.\n";
   0;
}

##################################################
# ^OZbgǂݍ
# &ReadRule ꕔǂޕ

sub ReadTagsSet
{
  local $/ = ';';
  local *RULE;
  foreach my $file (keys %::doctypes) {
    if (open(RULE, $ruledir.$file.'.rul')) {
      my ($line, $appear);
      while ($line = <RULE>) {
        if ($line =~ /\$emptyTags/) {
          local $emptyTags;
          eval $line;
          $emptyTags{$file} = $emptyTags;
          $appear |= 1;
        } elsif ($line =~ /\$pairTags/) {
          local $pairTags;
          eval $line;
          $pairTags{$file} = $pairTags;
          $appear |= 2;
        } elsif ($line =~ /\%tagsAttributes/) {
          local %tagsAttributes;
          eval $line;
          foreach (keys %tagsAttributes) {
            $attributes{$file}->{$_} = &Join('|', keys %{$tagsAttributes{$_}});
          }
          $appear |= 4;
        }
        last if $appear == 7;
      }
      close(RULE);
    }
  }
}

##################################################
# Kt@Cǂݍ
# require ł͂

sub ReadRule
{
  my $file = shift;
  $file = $ruledir.$file;
  return 0 unless -f $file;
  do $file;
  $rulefile = $file;
  1;
}

##################################################
# ݒt@Cǂݍ

sub ReadConfigFile
{
  my $configfile = '';
  if ($opt_f) {
    $configfile = $opt_f;
  } elsif ($ENV{HTMLLINTRC} && -f $ENV{HTMLLINTRC}) {
    $configfile = $ENV{HTMLLINTRC};
  } elsif ($::HTMLLINTRC ne '') {
    if ($::HTMLLINTRC !~ /^\./) {
      $configfile = $PROGDIR.$::HTMLLINTRC if -e $PROGDIR.$::HTMLLINTRC;
    } elsif ($UNIX) {
      my $user = eval 'getlogin() || (getpwuid($<))[0]' || $ENV{USER};
      my $home = eval '(getpwnam($user))[7]' || $ENV{HOME} || '/';
      $home .= '/' unless $home =~ m#/$#;
      $configfile = $home.$::HTMLLINTRC if -e $home.$::HTMLLINTRC;
    }
  }
  if ($configfile ne '') {
    local *CONFIG;
    local ($cnf_style, $cnf_html, $cnf_limit, $cnf_omit);
    my ($keyword, $arglist);
    open(CONFIG, "<$configfile") || die "Can't open config file `$configfile`.\n";
    while (<CONFIG>) {
      chomp;
      s/#.*$//;
      next if /^\s*$/;
      if (/^\s*(\S+)(?:\s+(.+))?$/i) {
        local @ARGV = ("-$1");
        push(@ARGV, $2) if $2 ne '';
        &GetOptions('disable=s'      => \&cnf_ed,
                    'enable=s'       => \&cnf_ed,
                    'style=s'        => \$cnf_style,
                    'html=s'         => \$cnf_html,
                    'limit=i'        => \$cnf_limit,
                    'omit=i'         => \$cnf_omit,
                    'pedantic!'      => \&cnf_noval,
                    'banner!'        => \&cnf_noval,
                    'echoname!'      => \&cnf_noval,
                    'score!'         => \&cnf_noval,
                    'scorenowhines'  => \&cnf_noval,
                    'scoreonly'      => \&cnf_noval,
                    'local!'         => \&cnf_noval,
                    'religious!'     => \&cnf_noval,
                    'accessibility!' => \&cnf_noval,
                    'warnings!'      => \&cnf_noval,
                    'prune!'         => \&cnf_noval,
                    'lc'             => \&cnf_lcuc,
                    'uc'             => \&cnf_lcuc,
                    'igndoctype'     => \&cnf_ignuse,
                    'usedoctype'     => \&cnf_ignuse,
                    'igncharset'     => \&cnf_ignuse,
                    'usecharset'     => \&cnf_ignuse);
      } else {
        print "$configfile: $.: Illegal line.\n";
      }
    }
    close(CONFIG);
    $opt_w     = $cnf_style if !defined($opt_w);
    $opt_x     = $cnf_html  if !defined($opt_x);
    $opt_limit = $cnf_limit if !defined($opt_limit);
    $opt_omit  = $cnf_omit  if !defined($opt_omit);
  }
}

  sub cnf_ed
  {
    my ($ed, $ids) = @_;
    while ($ids =~ /^\s*(\S+)(.*)/) {
      $ids = $2;
      my $id = $shortid{$1}? $shortid{$1}: $1;
      $cnf_e{$id} = $ed =~ /^e/i;
    }
  }

  sub cnf_lcuc
  {
    if (!defined($opt_lc)) {
      $opt_lc = (shift =~ /^l/i)? 1: 0;
    }
  }

  sub cnf_noval
  {
    my $opt = shift;
    my $val = shift;
    $opt = lc("opt_$opt");
    ${"$opt"} = $val if !defined(${"$opt"});
  }

  sub cnf_ignuse
  {
    my $opt = shift;
    if ($opt =~ /^use(.+)$/i) {
      $opt = lc("opt_ign$1");
      ${"$opt"} = 0 if !defined(${"$opt"});
    } else {
      $opt = lc("opt_$opt");
      ${"$opt"} = 1 if !defined(${"$opt"});
    }
  }

##################################################
# NIvVǂݍ

  sub opt_ed
  {
    my ($ed, $ids) = @_;
    foreach (split(/[,;:]/, $ids)) {
      my $id = $shortid{$_}? $shortid{$_}: $_;
      $opt_e{$id} = $ed =~ /^e/i;
    }
  }

  sub opt_lcuc
  {
    $opt_lc = (shift =~ /^l/)? 1: 0;
  }

  sub opt_ignuse
  {
    my $opt = shift;
    if ($opt =~ /^use(.+)$/) {
      ${"opt_ign$1"} = 0;
    } else {
      ${"opt_$opt"} = 1;
    }
  }

sub ReadOptions
{
  local (%cnf_e, %opt_e, $opt_r, $opt_listwarnings, $opt_version, $opt_help);
  &ReadWarnings();
  grep(s/^-$/$stdio/, @ARGV); # t@C '-' (stdin/out)  GetOptions ̕]
  # IvV̑ɔȂ HTMLlint() ɂ local $opt_xxx ̒邱
  &GetOptions('d=s' => \&opt_ed,
              'e=s' => \&opt_ed,
              'w=s',
              'f=s',
              'x=s',
              'r=s',
              'stat=s',    # CGIp
              'lang=s',    # CGIp
              'charset=s', # CGIp
              'mime=s',    # CGIp
              'style=s',   # CGIp
              'script=s',  # CGIp
              'base=s',    # CGIp
              'limit=i',
              'omit=i',
              'help|u',
              'version|v',
              'listwarnings',
              'linklist!',
              'pedantic!',
              'banner!',
              'echoname!',
              'score!',
              'scorenowhines',
              'scoreonly',
              'local!',
              'religious!',
              'accessibility!',
              'warnings!',
              'prune!',
              'after=s',
              'lc'         => \&opt_lcuc,
              'uc'         => \&opt_lcuc,
              'igndoctype' => \&opt_ignuse,
              'usedoctype' => \&opt_ignuse,
              'igncharset' => \&opt_ignuse,
              'usecharset' => \&opt_ignuse,
#             'j=s',  # gp
#             'cr',   # gp
              'dbg')
            || die 'g -U IvVw肷ƕ\܂B'."\n";
  &ReadConfigFile();
  $opt_charset = '' if $opt_igncharset;
  $opt_charset = $1 if $opt_charset =~ /^"(.+)"$/;
  $opt_limit = 999       if !defined($opt_limit); # ł؂Ex
  $opt_omit  = 20        if !defined($opt_omit);  # _x̏ȗ
  $opt_banner = 1        if !defined($opt_banner);
  $opt_score = 1         if !defined($opt_score);
  $opt_score = 1         if  defined($opt_scorenowhines);
  $opt_local = 1         if !defined($opt_local);
  $opt_warnings = 1      if !defined($opt_warnings);
  $opt_religious = 1     if !defined($opt_religious);
  $opt_accessibility = 1 if !defined($opt_accessibility);
  $opt_igndoctype = 1    if !defined($opt_igndoctype) && defined($opt_x);
  $opt_stat = ''         if !defined(&::TakeStatistics);
  foreach (keys %cnf_e) { &EnableWarning($_, $cnf_e{$_}); }
  foreach (keys %opt_e) { &EnableWarning($_, $opt_e{$_}); }
  if ($opt_listwarnings) {
    &ListWarnings();
    return 1;
  }
  if ($opt_v || $opt_version) {
    print $version;
    return 1;
  }
  if ($opt_u || $opt_help || !@ARGV) {
    print $version;
    unless ($opt_x) { $opt_x = ${$::doctypes{$::defaultrule}}{name}; }
    unless ($opt_w) { $opt_w = 'lint'; }
    foreach (split(/\n/, $usage)) {
      print;
      foreach my $opt (qw(pedantic banner religious accessibility echoname score prune warnings linklist local)) {
        if (${"opt_$opt"}? /-$opt\b/: /-no$opt\b/) { print '(*)'; }
      }
      foreach my $opt (qw(doctype charset)) {
        if (${"opt_ign$opt"}? /-ign$opt\b/: /-use$opt\b/) { print '(*)'; }
      }
      if ($opt_lc? /-lc\b/: /-uc\b/) { print '(*)'; }
      if (/= $opt_w\b/) { print '  (*)'; }
      if (/=.+\b(?:$opt_x)\b/) { print '  (*)'; }
      if (/-limit\b/) { print "($opt_limit)"; }
      if (/-omit\b/) { print "($opt_omit)"; }
      print "\n";
    }
    return 1;
  }
  $opt_after =~ s/^\s+//g;
  $opt_after =~ s/\s+$//g;
  if ($opt_after ne '') {
    if ($opt_after =~ /^\@(.*)$/) {
      $opt_after = ($1 ne '')? [stat $1]->[9]: 0;
    } else {
      # yyyy-mm-dd-hh-mm-ss
      my @tm = map($_+0, split(/\D/, $opt_after));
      $opt_after = timelocal(($tm[5]>=0 && $tm[5]<60)? $tm[5]:0,
                             ($tm[4]>=0 && $tm[4]<60)? $tm[4]:0,
                             ($tm[3]>=0 && $tm[3]<24)? $tm[3]:0,
                             ($tm[2]>=1 && $tm[2]<=31)? $tm[2]:1,
                             ($tm[1]>=1 && $tm[1]<=12)? $tm[1]-1:0,
                             ($tm[0]>=1900)? $tm[0]-1900:0);
    }
    $opt_after = 0 if $opt_after < 0;
  }
  $opt_w =~ tr/A-Z/a-z/;
  $ruledir = $::RULEDIR;
  $ruledir = $opt_r if $opt_r;
  $ruledir .= $SEP if $ruledir ne '' && $ruledir !~ m#$SEP$#o;
  $ruledir = $PROGDIR.$ruledir if $ruledir eq '' || $ruledir =~ /^\./;
  $ruledir =~ s#\\#/#g if $WIN;
  0;
}

##################################################
# Sx\

sub ListWarnings(;\@)
{
  &ReadWarnings unless %messages;
  my $aref = shift;
  my %msgshort;
  foreach my $id (keys %shortid) { $msgshort{$shortid{$id}} = $id; }
  foreach my $id (sort keys %messages) {
    my $msg = ${$messages{$id}}[0];
    $msg =~ s#<\$argv\[\d+\]>#<TAG>#g;
    $msg =~ s#</\$argv\[\d+\]>#</TAG>#g;
    $msg =~ s#\$argv\[\d+\] #ATTR #g;
    $msg =~ s#\$argv\[\d+\] ̑l#ATTR ̑l#g;
    $msg =~ s#\$argv\[\d+\]s#NNs#g;
    $msg =~ s#\$argv\[\d+\]#XXXX#g;
    $msg =~ s#\\"#"#g;
    $msg =~ s#\\\\#\\#g;
    my $n = &WhineScore($id);
    my $str = $id.' '.($msgshort{$id}? $msgshort{$id}: '-').
                  ' '.(($enabled{$id} > 0.0)? 'ENABLED': 'DISABLED').
                  ' '.$n;
    foreach (keys %alias_messages) {
      if ($alias_messages{$_} eq $id) {
        $n = $enabled{$_};
        $n = 0 if $n < 0.1;
        $str .= " $_ $n";
      }
    }
    if (defined($aref)) {
      push(@$aref, $str);
    } else {
      print "$str\n$msg\n";
    }
  }
}

sub WhineScore
{
  my $id = shift;
  my $n = $enabled{$id};
  $n = -$n if $n < 0.0;
  $n < 0.1? 0: $n;
}

sub CallCGI
{
  # CGI(htmllint.pm)̌Ăяo
  defined(&::AskHTML); # őp
}

##################################################
# gݍ݌xbZ[WƊlǂݍ

sub ReadWarnings
{
# return if %messages;
  my (@elem, $rel, $acc, $id, $default, $msg, $alias, $n, $nalias);
  my $i = 0;
  while (<DATA>) {
    chomp;
    s/^\s*//;
    s/\s*$//;
    next if !$_ || /^#/;
    push(@elem, $_);
    next unless @elem == 3;
    ($id, $default, $msg) = @elem;
    $id = $1 if $rel = $id =~ /^\*(.*)/;
    $id = $1 if $acc = $id =~ /^\@(.*)/;
    ($id, $alias) = split(' ', $id);
    if ($id =~ /^([^:]+):(.*)/) {
      $id = $1;
      die "Already used short name '$2'.\n" if $shortid{$2};
      $shortid{$2} = $id;
    }
    ($default, $n, $nalias) = split(' ', $default);
    $religious{$id} = 1 if $rel;
    $accessibility{$id} = 1 if $acc;
    if ($n =~ /^\*(.*)/) {
      $n = $1;
      $uniquewhine{$id}++;
    }
    $enabled{$id} = ($default =~ /^(?:E|ON|1)/i)? $n: -$n;
    $msg =~ s/\\/\\\\/g;
    $msg =~ s/"/\\"/g;
    ${$messages{$id}}[0] and die "Already used message id '$id'.\n";
    ${$messages{$id}}[0] = $msg;
    ${$messages{$id}}[1] = $i++;
    if ($alias) {
      $alias_messages{$alias} = $id;
      $enabled{$alias} = $nalias? $nalias: $n;
    }
    undef @elem;
  }
}

1;

__DATA__

# _ 0 傫ƁB0.1̓_͉ZȂB100ȏ DISABLE ɂłȂB
# xɂ́AꃁbZ[Wœ_̈قȂʖ(̂ƂЂƂ)włB
# OƓ_󔒂ŋ؂ĕׂ΂悢B
# O̓ * ͏@IȂ́A@ ͕K{łȂANZXɊւ̂B
# _ * ́A̓_̂܂܌_ (0.1ȏ̂Ƃ)B
# łȂꍇ́A 1/^O Č_B

# x̑ɑ΂Ĉȉ̒sȂ
#     htmllint.html ̃`FbN𒲐
#     explain.html ̉𒲐
#     htmllintrc 𒲐
#     stat-whines.dat 𒲐 (optional)

over-limit-whines
  ENABLE 100
  G[̐ $argv[0]𒴂̂Ń`FbNł؂܂B
cant-get-url:u
  DISABLE 5
  <$argv[0]>  $argv[1]  URI `$argv[2]` $argv[3]݂ȂANZXł܂B$argv[4]
required-doctype:qd
  ENABLE *8
  ŏ̋Lq DOCTYPE錾ł͂܂B
prectrl-doctype:pcd
  ENABLE *3
  DOCTYPE錾̑Oɉ䕶܂܂Ă܂B
unknown-doctype:ud
  ENABLE *6
  s DOCTYPE錾łB$argv[2]
doctype-case-mismatch:dcm
  ENABLE *8
  DOCTYPE錾Ɏw肳ĂJʎq̑啶܂B
unsupported-doctype:usd
  ENABLE *1
  $argv[3]  Another HTML-lint ł̓T|[gĂȂ DOCTYPE錾łB$argv[2]
expired-doctype:xd
  ENABLE *6
  $argv[0] ͂łɔpꂽHTMLłBgȂ悤ɂ܂傤B
obsoleted-doctype:od
  ENABLE *0.01
  $argv[0] ͂܂E߂ȂHTMLłB$argv[4] g܂傤B
doctype-mismatch:dm
  ENABLE *0.01
  w肳Ă $argv[1]  DOCTYPE錾ƈv܂BDOCTYPE錾𖳎܂B
misplaced-doctype:md
  ENABLE *9
  DOCTYPE錾͕̐擪łȂ΂Ȃ܂B
lower-case-doctype:lcd
  ENABLE *7
  DOCTYPE錾 `$argv[1]` ͏ŏȂ΂Ȃ܂B
upper-case-doctype:ucd
  ENABLE *7
  DOCTYPE錾 $argv[1] ͑啶ŏȂ΂Ȃ܂B
empty-systemid:esi
  ENABLE *8
  DOCTYPE錾ɂ̓VXeʎqKvłB
illegal-systemid:isi
  ENABLE *8
  DOCTYPE錾Ɏw肳ĂVXeʎq܂B
systemid-case-mismatch:sicm
  ENABLE *7
  DOCTYPE錾Ɏw肳ĂVXeʎq̑啶܂B
ignore-declaration:id
  ENABLE 1
  SGML錾 DTD錾ȂǂƎv <$argv[1] `> ͖܂B
marked-section:mks
  ENABLE 0.01
  }[N <!\[$argv[1]\[ ` \]\]> ́ÃuEU͗ł܂B
badstr-in-marked-section:bsmk
  ENABLE 9
  }[NԒ `$argv[1]` Ƃ͂ł܂B
unclosed-marked-section:ucmk
  ENABLE 9
  $argv[1]sڂ̃}[N <!\[$argv[2]\[ Ă܂B
misplaced-xmldecl:mxml
  ENABLE *9
  XML錾͕̐擪łȂ΂Ȃ܂B
xhtml-xmldecl:xxd
  ENABLE *6
  $argv[1] ł XML錾邱Ƃ߂Ă܂B
end-xmldecl:exd
  ENABLE *9
  XML錾̂ `?>` łB
bad-xmldecl:bxd
  ENABLE *9
  XML錾͐܂B
processing-instruction:pi
  ENABLE 0.01
   `<?`>` ͗ł܂B
w-hyphens-in-comment:hy
  ENABLE 2
  Rg `--` ͏ȂSłB
excluded-w-hyphens-in-comment:xhy
  ENABLE 9
  Rg `--` Ƃ͂ł܂B
*empty-comment:ecm
  ENABLE 2
  ̃Rg `<!>` ͏ȂSłB
illegal-comment:icm
  ENABLE 9
  ̃Rĝ悤ȋLq `$argv[0]` ͐܂B
title-comment:tm
  ENABLE 3
  <$argv[0]> ɂ̓RgȂ悤ɂ܂傤B
*markup-in-comment:mk
  ENABLE 0.01
  Rg `<`  `>` ƁA̃uEU邱Ƃ܂B
nested-comment:ncm
  ENABLE 3
  Rgqɂ邱Ƃ͂ł܂B
*space-in-closed-comment:scc
  ENABLE 2
  Rg `--`  `>` ̊Ԃɂ͋󔒂Ȃ悤ɂ܂傤B
illegal-closed-comment:icc
  ENABLE 8
  Rg `$argv[1]` ł͂Ȃ `-->` łB
unclosed-comment:ucc
  ENABLE 9
  $argv[1]sڂ̃RgĂ܂B
unclosed-tag:ut
  ENABLE *9
  $argv[1]sڂ <$argv[0] Ă܂B
leading-whitespace:lw
  ENABLE 9
  `<`  `$argv[1]` ̊Ԃɂ͋󔒂Ă͂܂B
unexpected-open:uo
  ENABLE 7
  \ `<`  <$argv[0]> ɂ܂BĂȂ^Ỏ\܂B
endtag-slash:es
  ENABLE 8
  vf^O <$argv[0]>  <$argv[0] /> ƂĕȂ΂Ȃ܂B
leading-space-endtag-slash:les
  ENABLE 1
  vf^O <$argv[0]> Ƃ `/>` ɋ󔒂s܂傤B
contain-no-space:cns
  ENABLE 9
  vf^O <$argv[0]> ̗vfɂ͋󔒂܂߂邱Ƃ͂ł܂B
minimized-endtag:met
  ENABLE 1
  vf^O <$argv[0] /> Ə悤ɂ܂傤B
noempty-endtag-slash:nes
  ENABLE 9
  vf^O <$argv[0]>  `/>` ŕ邱Ƃ͂ł܂B
excluded-element:xe
  ENABLE 9
  $argv[4]<$argv[0]>  $argv[2]sڂ <$argv[1]>`</$argv[1]> ɏƂ͂ł܂B$argv[3]
deprecated-element:de
  DISABLE 0.01
  $argv[1] $argv[3]sڂ <$argv[2]>`</$argv[2]> ɏƂ͂܂E߂܂B
misplaced-element:me
  ENABLE 9
  <$argv[0]>  <$argv[1]$argv[2]>`</$argv[1]> ̊OɏƂ͂ł܂B
once-only:oo
  ENABLE 8
  <$argv[0]>  <$argv[1]>`</$argv[1]> 1x܂B$argv[2]sڂɂ܂B
once-only-group:oog
  ENABLE 8
  <$argv[0]>  $argv[2]sڂ <$argv[3]> Ɠ <$argv[1]>`</$argv[1]> ɏƂ͂ł܂B
must-follow:mf
  ENABLE 8
  <$argv[0]>  $argv[1] ̒ɑȂ΂Ȃ܂B
must-follow-slight:mfs
  ENABLE 1
  <$argv[0]>  $argv[1] ̒ɑȂ΂Ȃ܂B
required:q
  ENABLE 9
  <$argv[0]>`</$argv[0]> ɂ $argv[1]KvłB
*empty-container:ec
  ENABLE 1
  <$argv[0]>  </$argv[0]> ̊ԂłB
@space-container:sc
  ENABLE 0.01
  <$argv[0]>  </$argv[0]> ̊Ԃɋ󔒕܂܂Ă܂B
*br-only-container:boc
  ENABLE 0.01
  <$argv[0]>`</$argv[0]> ɂ͋󔒈ȊO <$argv[1]> ܂܂Ă܂B
unknown-element:ue
  ENABLE 8
  <$argv[0]> ͕sȃ^OłB
other-html-element:he
  ENABLE 7
  <$argv[0]> $argv[1]p̃^OłB
deprecated-tag:dt deprecated-tag-0
  ENABLE 1        0.01
  <$argv[0]> ͂܂E߂Ȃ^OłB$argv[1]
deprecated-tag-css:dtc  deprecated-tag-css2
  ENABLE 0.01           0.02
  <$argv[0]> ͂܂E߂Ȃ^OłBX^CV[gg܂傤B
unsupported-tag:ust
  ENABLE 0.01
  <$argv[0]>  Another HTML-lint ł͐mȕ]͂ł܂B
should-not-use:snu
  ENABLE 6
  <$argv[0]> ͎gׂł܂B
required-start-tag:qst
  ENABLE 9
  ɂ <$argv[0]> KvłB
omit-start-tag:os
  ENABLE 4
   <$argv[0]> ȗĂ悤łBȗȂ悤ɂ܂傤B
omit-start-tag-trivial:ost
  DISABLE 0.01
   <$argv[0]> ȗĂ悤łB
required-end-tag:qet
  ENABLE 9
  ɂ </$argv[0]> KvłB
omit-end-tag:oe
  ENABLE 2
  $argv[1] </$argv[0]> ȗĂƂ݂Ȃ܂B
omit-end-tag-trivial:oet
  DISABLE 0.01
  $argv[1] </$argv[0]> ȗĂƂ݂Ȃ܂B
closing-attribute:ca
  ENABLE 9
  I^O </$argv[1]> ɂ͑w肷邱Ƃ͂ł܂B
illegal-closing:ic
  ENABLE 7
  <$argv[1]> ɂ͏I^O </$argv[1]> ͂܂B
*container-whitespace:cw
  DISABLE 0.01
  <$argv[0]>`</$argv[0]> $argv[1]ɋ󔒕܂B
mis-match:m
  ENABLE 9
  </$argv[1]> ɑΉJn^O <$argv[1]> ܂B
element-overlap:eo
  ENABLE 9
  </$argv[1]>  $argv[2]sڂ <$argv[3]> ƏdȂ荇Ă悤łB
tags-nest:tn
  ENABLE 6
  <$argv[0]> ^O̓q[߂܂B
unclosed-element:uce
  ENABLE 9
  $argv[1]sڂ <$argv[0]> ɑΉI^O </$argv[0]> ܂B
unexpected-pcdata:xp
  ENABLE 9
  $argv[2]<$argv[1]>`</$argv[1]> ɕʂ̃eLXgƂ͂ł܂B
illegal-attribute:ia
  ENABLE 8
  <$argv[0]> ɂȕ `$argv[1]` ܂B
xhtml-emptytag:xet
  ENABLE 7
  $argv[0] ł͋vf^O `<$argv[1] />` ƏƂ͂ł܂B
*mixed-case:mx
  DISABLE 0.01
  $argv[0]̑啶𓝈ꂷ悤ɂ܂傤B
lower-case-tag:lct
  ENABLE 9
  ^O <$argv[1]> ͏ŏȂ΂Ȃ܂B
lower-case-attribute:lca
  ENABLE 9
  <$argv[0]> ̑ `$argv[1]` ͏ŏȂ΂Ȃ܂B
unknown-attribute:ua
  ENABLE 6
  <$argv[0]> ɕsȑ `$argv[1]` w肳Ă܂B
other-html-attribute:oa
  ENABLE 5
  <$argv[0]> $argv[2]p̑ `$argv[1]` w肳Ă܂B
deprecated-attribute:da deprecated-attribute-0
  ENABLE 0.1              0.01
  <$argv[0]> ̑ `$argv[1]` ͂܂E߂ȂłB$argv[2]
deprecated-attribute-css:dac
  ENABLE 0.01
  <$argv[0]> ̑ `$argv[1]` ͂܂E߂ȂłBX^CV[gg܂傤B
unsupported-attribute:usa
  ENABLE 0.01
  <$argv[0]> ̑ `$argv[1]`  Another HTML-lint ł͐mȕ]͂ł܂B
leading-space-attribute:la leading-space-attribute-html
  ENABLE 6                 2
  <$argv[0]>  $argv[1] ̑Oɂ͋󔒂KvłB
repeated-attribute:ra
  ENABLE 7
  <$argv[0]>  $argv[1] ̎w肪JԂĂ܂B
required-attribute:qa
  ENABLE 6
  <$argv[0]> ɂ $argv[1] KvłB
required-attribute-pair:qap
  ENABLE 5
  <$argv[0]>  $argv[1] gƂ $argv[2] KvłB
nomixed-attribute:nma
  ENABLE 5
  <$argv[0]>  $argv[1]  $argv[2] 𓯎Ɏw肷邱Ƃ͂ł܂B
required-value:qv
  ENABLE 5
  <$argv[0]>  $argv[1] ɂ͑lKvłB
no-attribute-value:nv
  ENABLE 7
  <$argv[0]>  $argv[1] ̑lw肳Ă܂B
*across-lines-attribute:xl
  ENABLE 0.01
  <$argv[0]>  $argv[1] ̑lsɓnĂ܂B
*space-around-equal:sq
  DISABLE 0.01
  <$argv[0]>  $argv[1] ̑l؂ = Oɋ󔒂܂܂Ă܂B
unclosed-quotes:uq
  ENABLE 9
  <$argv[0]>  $argv[1] ̑l̈pĂ܂B
*attribute-delimiter:ad
  DISABLE 0.01
  <$argv[0]>  $argv[1] ̑l '$argv[2]' ƏĂ܂A"$argv[3]" ̕SłB
quote-attribute-value:qu
  ENABLE 8
  <$argv[0]>  $argv[1] ̑l `$argv[2]` ͈pň͂܂Ȃ΂Ȃ܂B
recommend-quote-attribute-value:rq
  ENABLE 1
  <$argv[0]>  $argv[1] ̑l `$argv[2]` ͈pň͂񂾕SłB
*bare-attribute-value:bv
  DISABLE 0.01
  <$argv[0]>  $argv[1] ̑l `$argv[2]` pň͂܂Ă܂B
*whitespace-attribute-value:wv
  ENABLE 1
  <$argv[0]>  $argv[1] ̑l `$argv[2]` ͋󔒕s܂͌sĂ܂B
deprecated-value:dv deprecated-value-0
  ENABLE 1          0.01
  <$argv[0]>  $argv[1] ̑l `$argv[2]` ͂܂E߂ȂlłB
empty-value:ev
  ENABLE 7
  <$argv[0]>  $argv[1] ̑lɋ̒lw肷邱Ƃ͂ł܂B
attribute-length:al
  ENABLE 4
  <$argv[0]>  $argv[1] ̑l $argv[2]𒴂Ă܂B
attribute-format:af
  ENABLE 7
  <$argv[0]>  $argv[1] ̑l `$argv[2]` ͐܂B$argv[3]
attribute-color:ac
  ENABLE 7
  <$argv[0]>  $argv[1] ̑l `$argv[2]` ͐܂B#RRGGBB ̌`߂ꂽF̖OłȂ΂Ȃ܂B
profile-uri:pu
  ENABLE 0.01
  <$argv[0]>  $argv[1] ̑ĺADTD͒PURIƂĂ܂B
unsafe-attribute:usfa
  ENABLE 0.01
  <$argv[0]>  $argv[1] ̑l `$argv[2]` ͎gȂSłB
attribute-value-case:avc
  ENABLE 7
  <$argv[0]>  $argv[1] ̑l `$argv[2]`  `$argv[3]` łȂ΂Ȃ܂B
fixed-attribute:fa
  ENABLE 7
  <$argv[0]>  $argv[1] ̑l `$argv[2]` łȂ΂Ȃ܂B
minimized-attribute:ma
  ENABLE 2
  <$argv[0]>  $argv[1] ͑ƑlłBȗđl̎wɂ܂傤B
no-minimization:nom
  ENABLE 8
  <$argv[0]> ̑ `$argv[1]` őȗ邱Ƃ͂ł܂B
omit-attribute-name:on
  ENABLE 3
  <$argv[0]>  `$argv[2]` ͑ $argv[1] ȗĂ܂A܂]Ȃm܂B
required-semicolon:qs
  ENABLE 7
  ̎Q `$argv[0]` ̌ɂ `;` ܂傤B
apos
  ENABLE 1
  ̎Q `&apos;`  `&#39;` Ə悤ɂ܂傤B
lower-x:lx
  ENABLE 7
  $argv[0] ł 16i̕QƂ `$argv[1]` ƏŎn߂Ȃ΂Ȃ܂B
bad-entity:be
  ENABLE 3
  `$argv[0]` ͕sȎ̎QƂłB$argv[1]
over-ref-charset:orc
  ENABLE 3
  Q `$argv[0]` ͌E𒴂R[hłBQƂł̂ `$argv[1]` ܂łłB
no-ref-charset:nrc
  ENABLE 3
  Q `$argv[0]` gp邱Ƃ͂ł܂B
literal-metacharacter:lm
  ENABLE 5
  ^ `$argv[0]`  `$argv[1]` ƏȂ΂Ȃ܂B
*double-quote-in-text:dq
  DISABLE 0.01
  eLXg `$argv[0]`  `$argv[1]` Ə܂傤B
@html-lang:hl
  ENABLE 2
  <$argv[0]> ɂ $argv[1] w肷悤ɂ܂傤B
lang:l
  ENABLE 2
  <$argv[0]>  $argv[1] w肷Ƃ $argv[2] w肷悤ɂ܂傤B
lang-mismatch:lmis
  ENABLE 4
  <$argv[0]> Ɏw肳Ă $argv[1] ̒l $argv[2] ̒lHĂ܂B
lang-attribute:laa
  ENABLE 0.01
  $argv[4]w肳Ă $argv[2]  `$argv[3]` łA<$argv[0]>  $argv[1] ̑lɓ{̂悤ȕ܂܂Ă܂B
lang-pcdata:lap
  ENABLE 0.01
  $argv[4]w肳Ă $argv[2]  `$argv[3]` łAeLXgɓ{̂悤ȕ܂܂Ă܂B
*mailto-link:ml
  ENABLE *0.01
  <$argv[0]>`</$argv[0]>  $argv[1] ܂܂Ă܂B
@navigation-link:nl
  ENABLE *0.01
  <$argv[0]>`</$argv[0]>  $argv[1] Ȃǂ̃iBQ[Vp̃N܂܂Ă܂B
mistype-links:mtl
  ENABLE 0.1
  <$argv[0]>  $argv[1] ̑l `$argv[2]`  `$argv[3]` ̌肾Ǝv܂B
#robots-upper:rou
#  ENABLE 0.1
#  <$argv[0] $argv[1]="$argv[2]"> ͑啶 `ROBOTS` łȂ΂Ȃ܂B
*robots-content:roc
  ENABLE 0.01
  <$argv[0] $argv[1]="$argv[2]"> Ɏw肳Ă $argv[3] ̒l `$argv[4]` ͂܂E߂܂B
content-type:ct
  ENABLE *4
  <$argv[0]>`</$argv[0]>  $argv[1] ܂܂Ă܂B
no-registered-charset:rc no-registered-charset-ex
  ENABLE 1               0.01
  $argv[1]w肳Ă镶R[hZbg `$argv[2]`  IANA ɓo^Ă܂B$argv[3]
no-charset:nc
  ENABLE 3
  <$argv[0] $argv[1]>  $argv[2] w肷悤ɂ܂傤B
non-ascii-early:nae
  ENABLE *39
  <$argv[0] $argv[1]>  $argv[2] w肳OɔASCII܂܂Ă܂B
non-ascii:na
  ENABLE 0.9
  ASCII܂܂Ă܂B
ctrl-character:ctl
  ENABLE 0.8
  䕶 `$argv[1]` ܂܂Ă܂B
han-katakana:hk han-katakana-0
  ENABLE 0.7    0.01
  pJ^Ji܂܂Ă܂B
bad-jis-x0208:jx
  ENABLE 1
  @ˑSp `$argv[1]` ܂܂Ă܂B
bom
  DISABLE 0.01
  ̐擪 BOM ܂܂Ă܂B
xml-encoding:xen
  ENABLE *5
  $argv[0] ł XML錾 encoding w܂傤B
charset-mismatch:cm
  ENABLE *66
  $argv[2]w肳Ă镶R[hZbg `$argv[0]` łAۂ̃R[h $argv[1] ̂悤łB
conflict-charset:cc
  ENABLE *11
  $argv[1]Ɏw肳Ă镶R[hZbg `$argv[2]` łA$argv[3]Ɏw肳Ă̂ `$argv[4]` łB
http-head-charset:hhc
  ENABLE 5
  HTTPX|Xwb_ $argv[1] w肪܂܂Ă܂B
no-text-html:th
  ENABLE *7
  <$argv[0]> Ɏw肳Ă $argv[1]  $argv[2] ł͂܂B
conflict-mime:cmi
  ENABLE *8
  $argv[1]Ɏw肳Ă郁fBA^Cv `$argv[2]` łA<$argv[0]> Ɏw肳Ă̂ `$argv[3]` łB
unrecommended-mime:urmi unrecommended-mime-slight
  ENABLE 5              0.5
  $argv[0]Ɏw肳Ă郁fBA^Cv $argv[1]  $argv[2] ɂ͎w肵Ȃ悤ɂ܂傤B
xml-http-equiv:xhq
  ENABLE 5
  $argv[2] ł <$argv[0] $argv[1]> Lqׂł͂܂B
existing-content-type:xc
  ENABLE 4
  <$argv[0] $argv[1]="$argv[2]">  $argv[3]sڂɂ܂B
content-xxxx-type:cxt
  ENABLE *1
  <$argv[0]> gƂ <$argv[1]>`</$argv[1]>  $argv[2] w肷悤ɂ܂傤B
need-content-xxxx-type:nxt
  ENABLE 3
  $argv[1] gƂ <$argv[2]>`</$argv[2]>  $argv[3] w肵Ȃ΂Ȃ܂B
#need-xml-stylesheet:nxs
#  ENABLE 2
#  fBA^Cv $argv[1] ł X^CV[ggƂ $argv[2] ߂g܂傤B
meta-http-equiv-name:mhn
  ENABLE 5
  <$argv[0]>  $argv[1]  $argv[2] ̗w肷邱Ƃ͂ł܂B
meta-no-http-equiv-name:mnhn
  ENABLE 5
  <$argv[0]>  $argv[1] w肷Ƃ $argv[2]  $argv[3] w肵Ȃ΂Ȃ܂B
@event-pair:ep
  ENABLE 1
  $argv[1] gƂ $argv[2] w肵܂傤B
refresh:r
  ENABLE *2
  <$argv[0] $argv[1]="$argv[2]"> 𗘗pĂ̎Iȃy[WXV͔܂傤B
refresh-link:rl
  ENABLE *3
  <$argv[0] $argv[1]="$argv[2]" $argv[3]> 𗘗pƂ͓̃Npӂ܂傤B
comment-element:ce
  ENABLE 3
  <$argv[0]>`</$argv[0]> ̗vfׂ͂ăRgň͂񂾕SłB
etago-in-cdata:et
  ENABLE *7
  <$argv[0]>`</$argv[0]>  `</` 𒼐ڏƂ͂ł܂B
embedded-in-cdata:em embedded-in-cdata-0
  ENABLE 2           0.01
  <$argv[0]>`</$argv[0]> $argv[3] `$argv[1]` Ƃ͊O$argv[2]pӂ܂傤B
comment-in-stylescript:cis
  ENABLE 0.1
  <$argv[0]>`</$argv[0]> ɃRgƁA{ɃRgƂĈ܂B
@no-noscript:ns
  DISABLE 0.01
  <$argv[0]> ^O܂A<$argv[1]> ^O܂B
title-length:tl
  ENABLE 1
  <$argv[0]> ̓e $argv[1]ȓɎ߂悤ɂ܂傤B
body-color:bc
  ENABLE 1
  <$argv[0]> ł̐Fw肪sSłB$argv[1] ܂߂悤ɂ܂傤B
background:bg
  ENABLE 1
  <$argv[0]>  $argv[1] w肵Ƃ $argv[2] w肷悤ɂ܂傤B
same-bgcolor:sbg
  ENABLE 3
  <$argv[0] $argv[1]> ̐Fw肪 $argv[2] ̐FƓłB
near-bgcolor:nbg
  ENABLE 3
  <$argv[0] $argv[1]> ̐Fw $argv[2] ̐F$argv[3]s\łB
contrast:con contrast-aaa
  ENABLE 3   1
  <$argv[0] $argv[1]> ̐Fw $argv[2] ̐F͋Px($argv[3])s\łB
repeated-id:ri
  ENABLE 7
  <$argv[0]>  $argv[1] ̒l `$argv[2]`  $argv[3]sڂłłɎgĂ܂B
undef-id:ui
  ENABLE 7
  $argv[3]sڂŎQƂĂ <$argv[0]>  $argv[1]  ID `$argv[2]` ͒`Ă܂B
repeated-name:rn
  ENABLE 2
  <$argv[0]>  $argv[1] ̒l `$argv[2]`  $argv[3]sڂłłɎgĂ܂B
fieldset-whitespace:fsw
  ENABLE 3
  <$argv[1]> ̒ɋ󔒈ȊÕeLXgƂ͂ł܂B
multiple-checked:mc
  ENABLE 4
  <$argv[0] $argv[1]="$argv[2]">  $argv[3] w肳Ă܂A$argv[4]sڂłłɎw肳Ă܂B
no-checked:noc
  ENABLE 1
  ǂ <$argv[0] $argv[1]="$argv[2]" $argv[3]="$argv[4]"> ɂ $argv[5] w肳Ă܂B
no-selected:nos
  ENABLE 1
  ǂ <$argv[0]> ɂ $argv[1] w肳Ă܂B
multiple-selected:ms
  ENABLE 4
  <$argv[0]>  $argv[1] w肳Ă܂A$argv[2]sڂłłɎw肳Ă܂B$argv[3]
over-select-options:oso
  ENABLE 4
  ЂƂ <$argv[1]> Ɏwł <$argv[0]>  $argv[2]܂łłB
@default-text:dtx
  ENABLE 0.1
  <$argv[0]> ɂ$argv[1]lƂȂeLXgw肵Ă܂傤B
input-type:int
  ENABLE 2
  <$argv[0]> ɂ $argv[1] w肷悤ɂ܂傤B
button-usemap:bu
  ENABLE 6
  <$argv[0]> ɗp <$argv[1]> ɂ $argv[2] w肷邱Ƃ͂ł܂B
label-control:lc
  ENABLE 7
  <$argv[0]> ɏƂ͂ł܂B$argv[1]sڂ <$argv[2]>`</$argv[2]> ɂ $argv[3]sڂ <$argv[4]> ܂܂Ă܂B
label-no-control:lnc
  ENABLE 7
  FOR ̊܂܂Ȃ <$argv[0]>`</$argv[0]> ɂ̓tH[Rg[w肵Ȃ΂Ȃ܂B
label-for-control:lfc
  ENABLE 1
  <$argv[0]> $argv[4] ̒l $argv[1]sڂ <$argv[2]>  $argv[3] ̒lHĂ܂B
@form-tabindex:tb
  ENABLE 0.01
  <$argv[0]> ɂ $argv[1] w肷悤ɂ܂傤B
@form-accesskey:fak
  ENABLE 0.01
  <$argv[0]> ɂ $argv[1] w肷悤ɂ܂傤B
@recommended-title:t
  ENABLE 0.01
  <$argv[0]> ɂ $argv[1] $argv[2]w肷悤ɂ܂傤B
object-text-equivalent:oq
  ENABLE 3
  <$argv[0]> ɂ͓ȓe悤ɂ܂傤B
applet-text-equivalent:aq
  ENABLE 1
  <$argv[0]>  $argv[1] Ɠȓe̗Ƃ͑E߂Ă܂B
@alt-spaces:as
  ENABLE 2
  <$argv[0]>  $argv[1] ɋ󔒂̕w肷邱Ƃ͑E߂Ă܂B
img-alt:a
  ENABLE 7
  <$argv[0]> ɂ $argv[1] w肷悤ɂ܂傤B
*img-size:z
  ENABLE 0.01
  <$argv[0]> ɂ $argv[1]  $argv[2] w肷悤ɂ܂傤B
img-map:im
  ENABLE 5
  <$argv[0]> ɂ $argv[1]  $argv[2] ̗w肷邱Ƃ͂ł܂B
server-side-image-map:sm
  ENABLE 5
  <$argv[0] $argv[1]> ł̃T[oTChC[W}bv͎g킸ANCAgTChC[W}bvg܂傤B
@table-summary:su
  ENABLE 1
  <$argv[0]> ɂ $argv[1] w肷悤ɂ܂傤B
@abbr-header-label:ab
  ENABLE 0.01
  <$argv[0]> ɂ $argv[1] w肷悤ɂ܂傤B
colgroup-span:cgs
  ENABLE 4
  <$argv[2]> vfɎ <$argv[0]> ɂ $argv[1] w肷ׂł͂܂B
overlap-cells:oc
  ENABLE 8
  <$argv[0]>  $argv[1] ̎wƁA$argv[2]sڂ <$argv[3]>  $argv[4] ̎w肪dȂ荇Ă܂B
no-noframes:nf
  ENABLE 6
  <$argv[0]> ^O܂A<$argv[1]> ^O܂B
same-document-frameset:sd
  ENABLE 8
  <$argv[0]>  $argv[1] Ɏgw URI `$argv[2]` w肷邱Ƃ͂ł܂B
frame-image:fi
  ENABLE 6
  <$argv[0]>  $argv[1] ŒڃC[WȂǂw肷邱Ƃ͑E߂Ă܂B
frame-title:ft
  ENABLE 4
  <$argv[0]> ɂ $argv[1] w肷悤ɂ܂傤B
existing-target-name:xt
  ENABLE 5
  <$argv[0]>  $argv[1] ̃t[^[Qbg `$argv[2]`  $argv[3]sڂłłɎw肳Ă܂B
reserved-target-name:rt
  ENABLE 5
  <$argv[0]>  $argv[1] ̃t[^[Qbg `$argv[2]` ͗\񂳂Ă܂B
reserved-target-name-upper:rtu
  ENABLE 0.1
  <$argv[0]>  $argv[1] ̃t[^[Qbg `$argv[2]` ͏ŏقSłB
illegal-target-name:it
  ENABLE 6
  <$argv[0]>  $argv[1] ̃t[^[Qbg `$argv[2]` ͐܂B
@physical-font:pf
  ENABLE 0.01
  <$argv[0]> ͕ItHg^OłB_I^Og悤ɂ܂傤B$argv[1]
p-isnot-br:p
  ENABLE 4
  <$argv[0]> ͒î߂̃^OłBs^O <$argv[1]> łB
continuous-brs:brs continuous-brs-fake
  ENABLE 0.8       7
  <$argv[0]> AĂ܂B
tab-in-pre:tp
  ENABLE 3
  $argv[1]sڂ <$argv[0]> ɂ̓^uȂ悤ɂ܂傤B
heading-order:ho
  ENABLE 4
  <$argv[0]>  $argv[2]sڂ <$argv[1]> ɑĂ܂D܂܂B
@heading-text-equivalent:hq
  ENABLE 1
  <$argv[0]>`</$argv[0]>  <$argv[1]>  $argv[2] ɂ͉܂傤B
@link-accesskey:ak
  DISABLE 0.01
  <$argv[0]> ɂ $argv[1] w肷悤ɂ܂傤B
@link-separation:ls
  ENABLE 0.9
  NƃN̊Ԃ͓Kȕŋ؂܂傤B
@link-text-equivalent:lq
  ENABLE 2
  NC[W <$argv[1]>  $argv[2] ɂ͉܂傤B
@d-link:dl
  DISABLE 0.1
  <$argv[0]>  $argv[1] ̒l `$argv[2]` ͂܂E߂܂B$argv[3] 𗘗p܂傤B
@same-link-text:slt
  ENABLE 1
  <$argv[0]> ̃AJ[ `$argv[1]`  $argv[2]sڂňقȂ郊NwĂ܂B
@here-anchor:h
  ENABLE 1
  <$argv[0]> ̃AJ[Ƃ `$argv[1]` Ȃǂĝ͍D܂܂B
@here-anchor-alt:ha
  ENABLE 1
  <$argv[0]> ̃AJ[Ƃ <$argv[1]>  $argv[2] ̒l `$argv[3]` Ȃǂĝ͍D܂܂B
fragment-id-whitespace:fw
  ENABLE 1
  <$argv[0]> ̃AJ[ `$argv[1]` ɋ󔒕܂܂Ă܂B
unsafe-fragment-id:uf
  ENABLE 1
  <$argv[0]> ̃AJ[ `$argv[1]` ɈSłȂ܂܂Ă܂B
empty-fragment-id:ef
  ENABLE 5
  <$argv[0]> ̃AJ[łB
existing-fragment-id:xf
  ENABLE 5
  <$argv[0]> ̃AJ[ `$argv[1]`  $argv[2]sڂɂ܂B
case-insensitive-fragment-id:cf
  ENABLE 2
  <$argv[0]> ̃AJ[ `$argv[1]`  $argv[2]sڂɂ܂B啶͋ʂȂ\܂B
same-fragment-id:sf
  ENABLE 5
  <$argv[0]> ̃AJ[ `$argv[1]`  $argv[2]sڂ $argv[3] ƂĂw肳Ă܂B
*id-link:il
  ENABLE 0.01
  <$argv[0]> ̃AJ[ `$argv[1]`  $argv[2]sڂ $argv[3] ƂĒ`Ă܂B
diff-id-link:dil
  ENABLE 4
  <$argv[0]>  $argv[1] ̒l `$argv[2]`  $argv[3] ̒l `$argv[4]` ́A^Oł͓łȂ΂Ȃ܂B
need-id-name:nin
  ENABLE 0.3
  <$argv[0]> ɂ $argv[1]  $argv[2] ̗w肷悤ɂ܂傤B
lower-id:lid
  ENABLE 2
  <$argv[0]>  $argv[1] ̒l `$argv[2]` ɂ͏܂߂Ȃ悤ɂ܂傤B
bad-link:bl
  ENABLE 6
  <$argv[0]> ̃AJ[ `$argv[1]` ܂łB
*unref-link:ul
  DISABLE 0.01
  <$argv[0]> ̃AJ[ `$argv[1]` ͎QƂĂ܂B
empty-url:eu
  ENABLE 5
  <$argv[0]>  $argv[1]  URI łB
url-whitespace:uw
  ENABLE 3
  <$argv[0]>  $argv[1]  URI `$argv[2]` ɋ󔒕܂܂Ă܂B
url-backslash:ub
  ENABLE 3
  <$argv[0]>  $argv[1]  URI `$argv[2]`  `\` ܂܂Ă܂BpX̋؂ `/` łȂ΂Ȃ܂B
*unsafe-url:uu
  DISABLE 0.01
  <$argv[0]>  $argv[1]  URI `$argv[2]`  `$argv[3]` ܂܂Ă܂B$argv[4] ƏSłB
excluded-url:xu
  ENABLE 1
  <$argv[0]>  $argv[1]  URI `$argv[2]` ɎgpłȂ `$argv[3]` ܂܂Ă܂B$argv[4] ƏȂ΂Ȃ܂B
excluded-url-ref:xur
  ENABLE 1
  <$argv[0]>  $argv[1]  URI ̎̎Q `$argv[2]` ͎gpłȂ `$argv[3]` łB
no-corresponding-url:nu
  ENABLE 7
  <$argv[0]>  $argv[1]  URI `$argv[2]`  ASCIIȊO̕܂܂Ă܂B
illegal-protocol:ip
  ENABLE 7
  <$argv[0]>  $argv[1]  URI Ɏw肳ĂXL[ `$argv[2]` ͐܂B
upper-protocol:upp
  ENABLE 0.3
  <$argv[0]>  $argv[1]  URI ̃XL[ `$argv[2]` ͏Ŏw肵܂傤B
unknown-protocol:up
  ENABLE 1
  <$argv[0]>  $argv[1]  URI ɕs̃XL[ `$argv[2]` w肳Ă܂B
local-protocol:lp
  ENABLE 5
  <$argv[0]>  $argv[1]  URI `$argv[2]` ̓C^lbgォQƂłȂm܂B
cantuse-protocol:cup
  ENABLE 5
  <$argv[0]>  $argv[1]  URI ̃XL[ `$argv[2]` ͗pł܂B
@javascript-url:js
  ENABLE 0.01
  <$argv[0]>  $argv[1]  URI Ɏw肳ĂXL[ `$argv[2]` ̗p͑E߂Ă܂B
illegal-format-url:if
  ENABLE 4
  <$argv[0]>  $argv[1]  URI `$argv[2]` ͐ȂłB
trailing-slash:ts
  ENABLE 2
  <$argv[0]>  $argv[1]  URI `$argv[2]`  `/` ŏI点悤ɂ܂傤B
net-path:np
  ENABLE 3
  <$argv[0]>  $argv[1]  URI `$argv[2]` ͂܂]Ȃm܂B
*conflict-directory:cd
  DISABLE 0.01
  <$argv[0]>  $argv[1]  URI `$argv[2]`  $argv[3]sڂ `$argv[4]` Ǝw肳Ă܂B
*index-html:ih
  ENABLE 1
  <$argv[0]>  $argv[1]  URI `$argv[2]`  $argv[3]sڂ `$argv[4]` Ǝw肳Ă܂B
later-base:lb
  ENABLE 5
  <$argv[0]>  $argv[1] Ŏw肷O $argv[2]sڂő URI w肳Ă܂B
absolute-base-url:abu
  ENABLE 6
  <$argv[0]>  $argv[1]  URI ͐ΈʒuŎw肵Ȃ΂Ȃ܂B
unexpected-end-of-html:xh
  ENABLE *9
  </$argv[0]> ̌ɂ܂eLXg܂B
over-file-size:ofs
  ENABLE *9
  $argv[1] ł́AHTML $argv[2]KoCgȓłȂ΂Ȃ܂B
unsupported-image:uim
  ENABLE 5
  <$argv[0]>  $argv[1]  URI `$argv[2]`  $argv[4] ł͂܂B$argv[3] ł̓C[W $argv[4] łȂ΂Ȃ܂B
jskyweb-olul:jolul
  ENABLE 8
  <$argv[0]> ̓q[߂܂B<UL>A<OL> ̓q $argv[1]KwȓłȂ΂Ȃ܂B
jskyweb-li:jli
  ENABLE 8
  $argv[1] Ɏwł <$argv[0]>  $argv[2]܂łłB
jpo-no-html:jnh
  ENABLE *9
  $argv[1]  <$argv[0]> n܂Ȃ΂Ȃ܂B
jpo-shift-jis:jsj
  ENABLE *9
  $argv[1]  $argv[2] ŋLqȂ΂Ȃ܂B
jpo-bad-char:jbc
  ENABLE 1
  $argv[1] ł `$argv[2]` gƂ͂ł܂B
