/*
   Unix SMB/CIFS implementation.
   test suite for ntprinting ndr operations

   Copyright (C) Guenther Deschner 2012

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "includes.h"
#include "torture/ndr/ndr.h"
#include "librpc/gen_ndr/ndr_ntprinting.h"
#include "torture/ndr/proto.h"
#include "param/param.h"

static const uint8_t ntprinting_printer_data[] = {
	0x48, 0x10, 0x08, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9d, 0x0e, 0x03, 0x09,
	0x00, 0x00, 0x00, 0x00, 0x24, 0x13, 0xb8, 0x4e, 0x00, 0x4b, 0x79, 0x6f,
	0x63, 0x65, 0x72, 0x61, 0x2d, 0x35, 0x30, 0x30, 0x00, 0x6b, 0x79, 0x6f,
	0x63, 0x65, 0x72, 0x61, 0x2d, 0x35, 0x30, 0x30, 0x00, 0x53, 0x61, 0x6d,
	0x62, 0x61, 0x20, 0x50, 0x72, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x20, 0x50,
	0x6f, 0x72, 0x74, 0x00, 0x6b, 0x79, 0x6f, 0x63, 0x65, 0x72, 0x61, 0x2d,
	0x35, 0x30, 0x30, 0x00, 0x4b, 0x79, 0x6f, 0x63, 0x65, 0x72, 0x61, 0x20,
	0x54, 0x61, 0x73, 0x6b, 0x41, 0x6c, 0x66, 0x61, 0x20, 0x35, 0x30, 0x30,
	0x63, 0x69, 0x00, 0x62, 0x75, 0x6c, 0x6c, 0x70, 0x65, 0x6e, 0x00, 0x00,
	0x77, 0x69, 0x6e, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x00, 0x52, 0x41, 0x57,
	0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x5c, 0x5c, 0x69, 0x72, 0x6f, 0x62,
	0x6f, 0x74, 0x5c, 0x4b, 0x79, 0x6f, 0x63, 0x65, 0x72, 0x61, 0x2d, 0x35,
	0x30, 0x30, 0x00, 0x4c, 0x65, 0x74, 0x74, 0x65, 0x72, 0x00, 0x01, 0x04,
	0x00, 0x06, 0xdc, 0x00, 0x60, 0x08, 0x01, 0x00, 0x01, 0x00, 0xea, 0x0a,
	0x6f, 0x08, 0x64, 0x00, 0x01, 0x00, 0x0f, 0x00, 0x58, 0x02, 0x02, 0x00,
	0x01, 0x00, 0x58, 0x02, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x53, 0xff,
	0x81, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
	0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x60, 0x08,
	0x00, 0x00, 0x50, 0x52, 0x49, 0x56, 0xe2, 0x30, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x10, 0x27, 0x10, 0x27, 0x10, 0x27, 0x00, 0x00, 0x10, 0x27, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x03, 0x54, 0x06, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x03, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x02, 0x10, 0x00, 0x5c, 0x4b,
	0x03, 0x00, 0x68, 0x43, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0x75,
	0xbf, 0xbb, 0x29, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0e, 0x00, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x03, 0x00, 0x00, 0x53, 0x4d,
	0x54, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x70, 0x03, 0x6b, 0x00,
	0x79, 0x00, 0x6f, 0x00, 0x63, 0x00, 0x65, 0x00, 0x72, 0x00, 0x61, 0x00,
	0x2d, 0x00, 0x35, 0x00, 0x30, 0x00, 0x30, 0x00, 0x00, 0x00, 0x4a, 0x43,
	0x4c, 0x54, 0x72, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x00, 0x4d, 0x65,
	0x64, 0x69, 0x75, 0x6d, 0x00, 0x4a, 0x43, 0x4c, 0x48, 0x61, 0x6c, 0x66,
	0x74, 0x6f, 0x6e, 0x65, 0x00, 0x47, 0x72, 0x61, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x00, 0x4a, 0x43, 0x4c, 0x52, 0x65, 0x64, 0x4c, 0x65, 0x76,
	0x65, 0x6c, 0x00, 0x4e, 0x6f, 0x6e, 0x65, 0x00, 0x4a, 0x43, 0x4c, 0x47,
	0x72, 0x65, 0x65, 0x6e, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x00, 0x4e, 0x6f,
	0x6e, 0x65, 0x00, 0x4a, 0x43, 0x4c, 0x42, 0x6c, 0x75, 0x65, 0x4c, 0x65,
	0x76, 0x65, 0x6c, 0x00, 0x4e, 0x6f, 0x6e, 0x65, 0x00, 0x4a, 0x43, 0x4c,
	0x48, 0x75, 0x65, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x00, 0x4e, 0x6f,
	0x6e, 0x65, 0x00, 0x4a, 0x43, 0x4c, 0x48, 0x75, 0x65, 0x52, 0x65, 0x64,
	0x00, 0x4e, 0x6f, 0x6e, 0x65, 0x00, 0x4a, 0x43, 0x4c, 0x48, 0x75, 0x65,
	0x59, 0x65, 0x6c, 0x6c, 0x6f, 0x77, 0x00, 0x4e, 0x6f, 0x6e, 0x65, 0x00,
	0x4a, 0x43, 0x4c, 0x48, 0x75, 0x65, 0x47, 0x72, 0x65, 0x65, 0x6e, 0x00,
	0x4e, 0x6f, 0x6e, 0x65, 0x00, 0x4a, 0x43, 0x4c, 0x48, 0x75, 0x65, 0x43,
	0x79, 0x61, 0x6e, 0x00, 0x4e, 0x6f, 0x6e, 0x65, 0x00, 0x4a, 0x43, 0x4c,
	0x48, 0x75, 0x65, 0x42, 0x6c, 0x75, 0x65, 0x00, 0x4e, 0x6f, 0x6e, 0x65,
	0x00, 0x4a, 0x43, 0x4c, 0x48, 0x75, 0x65, 0x4d, 0x61, 0x67, 0x65, 0x6e,
	0x74, 0x61, 0x00, 0x4e, 0x6f, 0x6e, 0x65, 0x00, 0x4a, 0x43, 0x4c, 0x4c,
	0x69, 0x67, 0x68, 0x74, 0x6e, 0x65, 0x73, 0x73, 0x47, 0x61, 0x6d, 0x6d,
	0x61, 0x00, 0x4e, 0x6f, 0x6e, 0x65, 0x00, 0x4a, 0x43, 0x4c, 0x4c, 0x69,
	0x67, 0x68, 0x74, 0x6e, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72,
	0x61, 0x73, 0x74, 0x00, 0x4e, 0x6f, 0x6e, 0x65, 0x00, 0x4a, 0x43, 0x4c,
	0x53, 0x61, 0x74, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x00, 0x4e,
	0x6f, 0x6e, 0x65, 0x00, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x00, 0x36, 0x30, 0x30, 0x64, 0x70, 0x69, 0x00, 0x4b, 0x43,
	0x45, 0x63, 0x6f, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x00, 0x4f, 0x66, 0x66,
	0x00, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x00,
	0x43, 0x4d, 0x59, 0x4b, 0x00, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x72, 0x65,
	0x70, 0x72, 0x6f, 0x64, 0x00, 0x50, 0x72, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x00, 0x43, 0x49, 0x45,
	0x00, 0x50, 0x72, 0x6e, 0x44, 0x65, 0x66, 0x00, 0x50, 0x61, 0x67, 0x65,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x00, 0x4f, 0x6e, 0x00, 0x50, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x00, 0x4c, 0x65, 0x74, 0x74, 0x65,
	0x72, 0x00, 0x50, 0x61, 0x67, 0x65, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e,
	0x00, 0x00, 0x4c, 0x65, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x45, 0x64, 0x67,
	0x65, 0x00, 0x00, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x53, 0x6c, 0x6f, 0x74,
	0x00, 0x2a, 0x55, 0x73, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x54, 0x72, 0x61,
	0x79, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x00, 0x4d, 0x65, 0x64, 0x69, 0x61,
	0x54, 0x79, 0x70, 0x65, 0x00, 0x41, 0x75, 0x74, 0x6f, 0x00, 0x4f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x42, 0x69, 0x6e, 0x00, 0x4e, 0x6f, 0x6e, 0x65,
	0x00, 0x4b, 0x43, 0x53, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x00, 0x4e, 0x6f,
	0x6e, 0x65, 0x00, 0x53, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x00, 0x4e, 0x6f, 0x6e, 0x65, 0x00, 0x4b, 0x43, 0x50, 0x75,
	0x6e, 0x63, 0x68, 0x00, 0x4e, 0x6f, 0x6e, 0x65, 0x00, 0x4b, 0x43, 0x42,
	0x6f, 0x6f, 0x6b, 0x6c, 0x65, 0x74, 0x00, 0x4e, 0x6f, 0x6e, 0x65, 0x00,
	0x4b, 0x43, 0x46, 0x6f, 0x6c, 0x64, 0x00, 0x4e, 0x6f, 0x6e, 0x65, 0x00,
	0x52, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x00, 0x46, 0x61, 0x6c, 0x73, 0x65,
	0x00, 0x4a, 0x6f, 0x67, 0x00, 0x4e, 0x6f, 0x6e, 0x65, 0x00, 0x44, 0x75,
	0x70, 0x6c, 0x65, 0x78, 0x00, 0x4e, 0x6f, 0x6e, 0x65, 0x00, 0x4b, 0x43,
	0x43, 0x6f, 0x6c, 0x6c, 0x61, 0x74, 0x65, 0x00, 0x50, 0x72, 0x6e, 0x44,
	0x65, 0x66, 0x00, 0x4b, 0x6d, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x00, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x00, 0x4b,
	0x43, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x00, 0x44, 0x65, 0x66,
	0x61, 0x75, 0x6c, 0x74, 0x00, 0x63, 0x75, 0x70, 0x73, 0x4a, 0x6f, 0x62,
	0x48, 0x6f, 0x6c, 0x64, 0x55, 0x6e, 0x74, 0x69, 0x6c, 0x00, 0x6e, 0x6f,
	0x2d, 0x68, 0x6f, 0x6c, 0x64, 0x00, 0x63, 0x75, 0x70, 0x73, 0x4a, 0x6f,
	0x62, 0x53, 0x68, 0x65, 0x65, 0x74, 0x73, 0x53, 0x74, 0x61, 0x72, 0x74,
	0x00, 0x6e, 0x6f, 0x6e, 0x65, 0x00, 0x63, 0x75, 0x70, 0x73, 0x4a, 0x6f,
	0x62, 0x53, 0x68, 0x65, 0x65, 0x74, 0x73, 0x45, 0x6e, 0x64, 0x00, 0x6e,
	0x6f, 0x6e, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x0c, 0x02, 0x00, 0x00, 0x53, 0x50, 0x55, 0x43, 0x00, 0x06,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
	0x00, 0x00, 0x50, 0x72, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x44, 0x72, 0x69,
	0x76, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x50, 0x72, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x44, 0x72, 0x69, 0x76, 0x65, 0x72, 0x44, 0x61, 0x74,
	0x61, 0x5c, 0x54, 0x72, 0x61, 0x79, 0x46, 0x6f, 0x72, 0x6d, 0x53, 0x69,
	0x7a, 0x65, 0x00, 0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0xce,
	0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x50, 0x72, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x44, 0x72, 0x69, 0x76, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61,
	0x5c, 0x54, 0x72, 0x61, 0x79, 0x46, 0x6f, 0x72, 0x6d, 0x54, 0x61, 0x62,
	0x6c, 0x65, 0x00, 0x03, 0x00, 0x00, 0x00, 0xce, 0x00, 0x00, 0x00, 0xce,
	0x00, 0x43, 0x00, 0x61, 0x00, 0x73, 0x00, 0x73, 0x00, 0x65, 0x00, 0x74,
	0x00, 0x74, 0x00, 0x65, 0x00, 0x20, 0x00, 0x31, 0x00, 0x00, 0x00, 0x4c,
	0x00, 0x65, 0x00, 0x74, 0x00, 0x74, 0x00, 0x65, 0x00, 0x72, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x43, 0x00, 0x61, 0x00, 0x73, 0x00, 0x73,
	0x00, 0x65, 0x00, 0x74, 0x00, 0x74, 0x00, 0x65, 0x00, 0x20, 0x00, 0x32,
	0x00, 0x00, 0x00, 0x4c, 0x00, 0x65, 0x00, 0x74, 0x00, 0x74, 0x00, 0x65,
	0x00, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x43, 0x00, 0x61,
	0x00, 0x73, 0x00, 0x73, 0x00, 0x65, 0x00, 0x74, 0x00, 0x74, 0x00, 0x65,
	0x00, 0x20, 0x00, 0x33, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x65, 0x00, 0x74,
	0x00, 0x74, 0x00, 0x65, 0x00, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x43, 0x00, 0x61, 0x00, 0x73, 0x00, 0x73, 0x00, 0x65, 0x00, 0x74,
	0x00, 0x74, 0x00, 0x65, 0x00, 0x20, 0x00, 0x34, 0x00, 0x00, 0x00, 0x4c,
	0x00, 0x65, 0x00, 0x74, 0x00, 0x74, 0x00, 0x65, 0x00, 0x72, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x00, 0x79, 0x00, 0x70, 0x00, 0x61,
	0x00, 0x73, 0x00, 0x73, 0x00, 0x20, 0x00, 0x54, 0x00, 0x72, 0x00, 0x61,
	0x00, 0x79, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x65, 0x00, 0x74, 0x00, 0x74,
	0x00, 0x65, 0x00, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x00, 0x00, 0x00, 0x50, 0x72, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x44, 0x72, 0x69, 0x76, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x5c, 0x54,
	0x72, 0x61, 0x79, 0x46, 0x6f, 0x72, 0x6d, 0x4d, 0x61, 0x70, 0x53, 0x69,
	0x7a, 0x65, 0x00, 0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x39,
	0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x50, 0x72, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x44, 0x72, 0x69, 0x76, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61,
	0x5c, 0x54, 0x72, 0x61, 0x79, 0x46, 0x6f, 0x72, 0x6d, 0x4d, 0x61, 0x70,
	0x00, 0x03, 0x00, 0x00, 0x00, 0x39, 0x00, 0x00, 0x00, 0x50, 0x46, 0x37,
	0x30, 0x30, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0x46, 0x37, 0x30,
	0x30, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0x46, 0x37, 0x30, 0x30,
	0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0x46, 0x37, 0x30, 0x30, 0x44,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x4d, 0x46, 0x31, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x50, 0x72,
	0x69, 0x6e, 0x74, 0x65, 0x72, 0x44, 0x72, 0x69, 0x76, 0x65, 0x72, 0x44,
	0x61, 0x74, 0x61, 0x5c, 0x54, 0x72, 0x61, 0x79, 0x46, 0x6f, 0x72, 0x6d,
	0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x53, 0x69, 0x7a, 0x65, 0x00,
	0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x26, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x50, 0x72, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x44,
	0x72, 0x69, 0x76, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x5c, 0x54, 0x72,
	0x61, 0x79, 0x46, 0x6f, 0x72, 0x6d, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72,
	0x64, 0x00, 0x03, 0x00, 0x00, 0x00, 0x26, 0x00, 0x00, 0x00, 0x50, 0x46,
	0x37, 0x30, 0x30, 0x41, 0x00, 0x00, 0x50, 0x46, 0x37, 0x30, 0x30, 0x42,
	0x00, 0x00, 0x50, 0x46, 0x37, 0x30, 0x30, 0x43, 0x00, 0x00, 0x50, 0x46,
	0x37, 0x30, 0x30, 0x44, 0x00, 0x00, 0x4d, 0x46, 0x31, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x44, 0x73, 0x53, 0x70, 0x6f, 0x6f, 0x6c, 0x65,
	0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
	0x00, 0x00, 0x44, 0x73, 0x53, 0x70, 0x6f, 0x6f, 0x6c, 0x65, 0x72, 0x5c,
	0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x00, 0x01,
	0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x49, 0x00, 0x52, 0x00, 0x4f,
	0x00, 0x42, 0x00, 0x4f, 0x00, 0x54, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
	0x00, 0x44, 0x73, 0x53, 0x70, 0x6f, 0x6f, 0x6c, 0x65, 0x72, 0x5c, 0x73,
	0x68, 0x6f, 0x72, 0x74, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x4e, 0x61,
	0x6d, 0x65, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x49,
	0x00, 0x52, 0x00, 0x4f, 0x00, 0x42, 0x00, 0x4f, 0x00, 0x54, 0x00, 0x00,
	0x00, 0x01, 0x00, 0x00, 0x00, 0x44, 0x73, 0x53, 0x70, 0x6f, 0x6f, 0x6c,
	0x65, 0x72, 0x5c, 0x75, 0x4e, 0x43, 0x4e, 0x61, 0x6d, 0x65, 0x00, 0x01,
	0x00, 0x00, 0x00, 0x2a, 0x00, 0x00, 0x00, 0x5c, 0x00, 0x5c, 0x00, 0x49,
	0x00, 0x52, 0x00, 0x4f, 0x00, 0x42, 0x00, 0x4f, 0x00, 0x54, 0x00, 0x5c,
	0x00, 0x6b, 0x00, 0x79, 0x00, 0x6f, 0x00, 0x63, 0x00, 0x65, 0x00, 0x72,
	0x00, 0x61, 0x00, 0x2d, 0x00, 0x35, 0x00, 0x30, 0x00, 0x30, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t ntprinting_printer_data_latin1[] = {
	0x48, 0x1a, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x94, 0x46, 0x50, 0x0e, 0x00, 0x00, 0x00, 0x00,
	0x94, 0xee, 0xb9, 0x50, 0x00, 0x53, 0x30, 0x42,
	0x43, 0x00, 0x53, 0x30, 0x42, 0x43, 0x00, 0x53,
	0x61, 0x6d, 0x62, 0x61, 0x20, 0x50, 0x72, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x20, 0x50, 0x6f, 0x72,
	0x74, 0x00, 0x48, 0x50, 0x20, 0x44, 0x65, 0x73,
	0x69, 0x67, 0x6e, 0x6a, 0x65, 0x74, 0x20, 0x38,
	0x30, 0x30, 0x50, 0x53, 0x20, 0x34, 0x32, 0x20,
	0x62, 0x79, 0x20, 0x48, 0x50, 0x00, 0x22, 0x20,
	0x53, 0x41, 0x4c, 0x41, 0x20, 0x44, 0x41, 0x20,
	0x52, 0x45, 0x43, 0x45, 0x50, 0xc7, 0xc3, 0x4f,
	0x20, 0x44, 0x41, 0x20, 0x43, 0x4f, 0x4e, 0x53,
	0x54, 0x52, 0x55, 0xc7, 0xc3, 0x4f, 0x20, 0x2d,
	0x20, 0x52, 0x41, 0x4e, 0x44, 0x30, 0x20, 0x4c,
	0x4f, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x00, 0x55,
	0x54, 0x47, 0x43, 0x41, 0x20, 0x00, 0x00, 0x77,
	0x69, 0x6e, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x00,
	0x52, 0x41, 0x57, 0x00, 0x00, 0x01, 0x00, 0x00,
	0x00, 0x5c, 0x5c, 0x4c, 0x4f, 0x43, 0x41, 0x4c,
	0x48, 0x4f, 0x53, 0x54, 0x5c, 0x53, 0x30, 0x42,
	0x43, 0x00, 0x4c, 0x65, 0x74, 0x74, 0x65, 0x72,
	0x00, 0x01, 0x04, 0x00, 0x04, 0xdc, 0x00, 0x00,
	0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x64, 0x00, 0x01, 0x00, 0x0f, 0x00, 0xfc,
	0xff, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x03,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x47, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x00, 0x00, 0x00, 0x50, 0x72, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x44, 0x72, 0x69, 0x76,
	0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
	0x00, 0x00, 0x00, 0x50, 0x72, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x44, 0x72, 0x69, 0x76, 0x65, 0x72,
	0x44, 0x61, 0x74, 0x61, 0x5c, 0x44, 0x72, 0x76,
	0x50, 0x61, 0x70, 0x65, 0x72, 0x53, 0x74, 0x61,
	0x6e, 0x64, 0x61, 0x72, 0x64, 0x73, 0x00, 0x04,
	0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x61,
	0xc2, 0x00, 0xc0, 0x01, 0x00, 0x00, 0x00, 0x50,
	0x72, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x44, 0x72,
	0x69, 0x76, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61,
	0x5c, 0x44, 0x72, 0x76, 0x44, 0x65, 0x76, 0x4d,
	0x6f, 0x64, 0x65, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x42, 0x02, 0x00, 0x00, 0x31, 0x00, 0x3b, 0x00,
	0x31, 0x00, 0x3b, 0x00, 0x32, 0x00, 0x36, 0x00,
	0x36, 0x00, 0x3b, 0x00, 0x2d, 0x00, 0x33, 0x00,
	0x3b, 0x00, 0x31, 0x00, 0x3b, 0x00, 0x31, 0x00,
	0x30, 0x00, 0x3b, 0x00, 0x30, 0x00, 0x3b, 0x00,
	0x30, 0x00, 0x3b, 0x00, 0x31, 0x00, 0x3b, 0x00,
	0x31, 0x00, 0x30, 0x00, 0x37, 0x00, 0x33, 0x00,
	0x37, 0x00, 0x34, 0x00, 0x31, 0x00, 0x39, 0x00,
	0x30, 0x00, 0x35, 0x00, 0x3b, 0x00, 0x30, 0x00,
	0x3b, 0x00, 0x30, 0x00, 0x3b, 0x00, 0x30, 0x00,
	0x3b, 0x00, 0x31, 0x00, 0x3b, 0x00, 0x35, 0x00,
	0x30, 0x00, 0x3b, 0x00, 0x34, 0x00, 0x3b, 0x00,
	0x35, 0x00, 0x3b, 0x00, 0x30, 0x00, 0x3b, 0x00,
	0x32, 0x00, 0x30, 0x00, 0x30, 0x00, 0x3b, 0x00,
	0x30, 0x00, 0x3b, 0x00, 0x30, 0x00, 0x3b, 0x00,
	0x30, 0x00, 0x3b, 0x00, 0x30, 0x00, 0x3b, 0x00,
	0x32, 0x00, 0x3b, 0x00, 0x32, 0x00, 0x3b, 0x00,
	0x32, 0x00, 0x3b, 0x00, 0x31, 0x00, 0x3b, 0x00,
	0x31, 0x00, 0x3b, 0x00, 0x31, 0x00, 0x3b, 0x00,
	0x30, 0x00, 0x3b, 0x00, 0x32, 0x00, 0x36, 0x00,
	0x32, 0x00, 0x3b, 0x00, 0x31, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x3b, 0x00, 0x31, 0x00, 0x36, 0x00,
	0x37, 0x00, 0x37, 0x00, 0x37, 0x00, 0x32, 0x00,
	0x31, 0x00, 0x36, 0x00, 0x3b, 0x00, 0x30, 0x00,
	0x3b, 0x00, 0x31, 0x00, 0x3b, 0x00, 0x30, 0x00,
	0x3b, 0x00, 0x31, 0x00, 0x36, 0x00, 0x3b, 0x00,
	0x32, 0x00, 0x31, 0x00, 0x3b, 0x00, 0x32, 0x00,
	0x30, 0x00, 0x3b, 0x00, 0x31, 0x00, 0x3b, 0x00,
	0x31, 0x00, 0x3b, 0x00, 0x30, 0x00, 0x3b, 0x00,
	0x30, 0x00, 0x3b, 0x00, 0x30, 0x00, 0x3b, 0x00,
	0x30, 0x00, 0x3b, 0x00, 0x31, 0x00, 0x3b, 0x00,
	0x31, 0x00, 0x3b, 0x00, 0x30, 0x00, 0x3b, 0x00,
	0x34, 0x00, 0x3b, 0x00, 0x36, 0x00, 0x35, 0x00,
	0x35, 0x00, 0x33, 0x00, 0x35, 0x00, 0x3b, 0x00,
	0x32, 0x00, 0x36, 0x00, 0x33, 0x00, 0x31, 0x00,
	0x37, 0x00, 0x32, 0x00, 0x3b, 0x00, 0x30, 0x00,
	0x3b, 0x00, 0x30, 0x00, 0x3b, 0x00, 0x31, 0x00,
	0x3b, 0x00, 0x30, 0x00, 0x3b, 0x00, 0x37, 0x00,
	0x3b, 0x00, 0x31, 0x00, 0x30, 0x00, 0x32, 0x00,
	0x37, 0x00, 0x3b, 0x00, 0x31, 0x00, 0x3b, 0x00,
	0x30, 0x00, 0x3b, 0x00, 0x32, 0x00, 0x3b, 0x00,
	0x31, 0x00, 0x3b, 0x00, 0x32, 0x00, 0x31, 0x00,
	0x35, 0x00, 0x39, 0x00, 0x3b, 0x00, 0x32, 0x00,
	0x37, 0x00, 0x39, 0x00, 0x34, 0x00, 0x3b, 0x00,
	0x32, 0x00, 0x31, 0x00, 0x35, 0x00, 0x39, 0x00,
	0x3b, 0x00, 0x32, 0x00, 0x37, 0x00, 0x39, 0x00,
	0x34, 0x00, 0x3b, 0x00, 0x32, 0x00, 0x31, 0x00,
	0x35, 0x00, 0x39, 0x00, 0x3b, 0x00, 0x32, 0x00,
	0x37, 0x00, 0x39, 0x00, 0x34, 0x00, 0x3b, 0x00,
	0x32, 0x00, 0x31, 0x00, 0x35, 0x00, 0x39, 0x00,
	0x3b, 0x00, 0x32, 0x00, 0x37, 0x00, 0x39, 0x00,
	0x34, 0x00, 0x3b, 0x00, 0x32, 0x00, 0x31, 0x00,
	0x35, 0x00, 0x39, 0x00, 0x3b, 0x00, 0x32, 0x00,
	0x37, 0x00, 0x39, 0x00, 0x34, 0x00, 0x3b, 0x00,
	0x32, 0x00, 0x31, 0x00, 0x35, 0x00, 0x39, 0x00,
	0x3b, 0x00, 0x32, 0x00, 0x37, 0x00, 0x39, 0x00,
	0x34, 0x00, 0x3b, 0x00, 0x32, 0x00, 0x31, 0x00,
	0x35, 0x00, 0x39, 0x00, 0x3b, 0x00, 0x32, 0x00,
	0x37, 0x00, 0x39, 0x00, 0x34, 0x00, 0x3b, 0x00,
	0x32, 0x00, 0x31, 0x00, 0x35, 0x00, 0x39, 0x00,
	0x3b, 0x00, 0x32, 0x00, 0x37, 0x00, 0x39, 0x00,
	0x34, 0x00, 0x3b, 0x00, 0x32, 0x00, 0x31, 0x00,
	0x35, 0x00, 0x39, 0x00, 0x3b, 0x00, 0x32, 0x00,
	0x37, 0x00, 0x39, 0x00, 0x34, 0x00, 0x3b, 0x00,
	0x32, 0x00, 0x31, 0x00, 0x35, 0x00, 0x39, 0x00,
	0x3b, 0x00, 0x32, 0x00, 0x37, 0x00, 0x39, 0x00,
	0x34, 0x00, 0x3b, 0x00, 0x30, 0x00, 0x3b, 0x00,
	0x3b, 0x00, 0x3b, 0x00, 0x3b, 0x00, 0x3b, 0x00,
	0x3b, 0x00, 0x31, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x3b, 0x00, 0x31, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x3b, 0x00, 0x31, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x3b, 0x00, 0x30, 0x00, 0x3b, 0x00, 0x30, 0x00,
	0x3b, 0x00, 0x3b, 0x00, 0x00, 0x00, 0x01, 0x00,
	0x00, 0x00, 0x50, 0x72, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x44, 0x72, 0x69, 0x76, 0x65, 0x72, 0x44,
	0x61, 0x74, 0x61, 0x5c, 0x44, 0x72, 0x76, 0x45,
	0x57, 0x53, 0x49, 0x50, 0x00, 0x01, 0x00, 0x00,
	0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
	0x00, 0x00, 0x00, 0x44, 0x73, 0x53, 0x70, 0x6f,
	0x6f, 0x6c, 0x65, 0x72, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
	0x00, 0x44, 0x73, 0x53, 0x70, 0x6f, 0x6f, 0x6c,
	0x65, 0x72, 0x5c, 0x70, 0x72, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x00, 0x01,
	0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x53,
	0x00, 0x30, 0x00, 0x42, 0x00, 0x43, 0x00, 0x00,
	0x00, 0x01, 0x00, 0x00, 0x00, 0x44, 0x73, 0x53,
	0x70, 0x6f, 0x6f, 0x6c, 0x65, 0x72, 0x5c, 0x73,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x4e, 0x61, 0x6d,
	0x65, 0x00, 0x01, 0x00, 0x00, 0x00, 0x14, 0x00,
	0x00, 0x00, 0x53, 0x00, 0x36, 0x00, 0x30, 0x00,
	0x32, 0x00, 0x30, 0x00, 0x50, 0x00, 0x53, 0x00,
	0x36, 0x00, 0x36, 0x00, 0x00, 0x00, 0x01, 0x00,
	0x00, 0x00, 0x44, 0x73, 0x53, 0x70, 0x6f, 0x6f,
	0x6c, 0x65, 0x72, 0x5c, 0x73, 0x68, 0x6f, 0x72,
	0x74, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x4e,
	0x61, 0x6d, 0x65, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x14, 0x00, 0x00, 0x00, 0x53, 0x00, 0x36, 0x00,
	0x30, 0x00, 0x32, 0x00, 0x30, 0x00, 0x50, 0x00,
	0x53, 0x00, 0x36, 0x00, 0x36, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x44, 0x73, 0x53, 0x70,
	0x6f, 0x6f, 0x6c, 0x65, 0x72, 0x5c, 0x75, 0x4e,
	0x43, 0x4e, 0x61, 0x6d, 0x65, 0x00, 0x01, 0x00,
	0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x5c, 0x00,
	0x5c, 0x00, 0x53, 0x00, 0x36, 0x00, 0x30, 0x00,
	0x32, 0x00, 0x30, 0x00, 0x50, 0x00, 0x53, 0x00,
	0x36, 0x00, 0x36, 0x00, 0x5c, 0x00, 0x53, 0x00,
	0x30, 0x00, 0x42, 0x00, 0x43, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00
};

static bool ntprinting_printer_check(struct torture_context *tctx,
				     struct ntprinting_printer *r)
{
	torture_assert_int_equal(tctx, r->info.attributes, 0x00081048, "attributes");
	torture_assert_int_equal(tctx, r->info.priority, 1, "priority");
	torture_assert_int_equal(tctx, r->info.default_priority, 1, "default_priority");
	torture_assert_int_equal(tctx, r->info.starttime, 0, "startime");
	torture_assert_int_equal(tctx, r->info.untiltime, 0, "untiltime");
	torture_assert_int_equal(tctx, r->info.status, 0, "status");
	torture_assert_int_equal(tctx, r->info.cjobs, 5, "cjobs");
	torture_assert_int_equal(tctx, r->info.averageppm, 0, "averageppm");
	torture_assert_int_equal(tctx, r->info.changeid, 0x09030e9d, "changeid");
	torture_assert_int_equal(tctx, r->info.c_setprinter, 0, "c_setprinter");
	torture_assert_int_equal(tctx, r->info.setuptime, 0x4eb81324, "setuptime");
	torture_assert_str_equal(tctx, r->info.servername, "", "servername");
	torture_assert_str_equal(tctx, r->info.printername, "Kyocera-500", "printername");
	torture_assert_str_equal(tctx, r->info.sharename, "kyocera-500", "sharename");
	torture_assert_str_equal(tctx, r->info.portname, "Samba Printer Port", "portname");
	torture_assert_str_equal(tctx, r->info.drivername, "kyocera-500", "drivername");
	torture_assert_str_equal(tctx, r->info.comment, "Kyocera TaskAlfa 500ci", "comment");
	torture_assert_str_equal(tctx, r->info.location, "bullpen", "comment");
	torture_assert_str_equal(tctx, r->info.sepfile, "", "sepfile");
	torture_assert_str_equal(tctx, r->info.printprocessor, "winprint", "printprocessor");
	torture_assert_str_equal(tctx, r->info.datatype, "RAW", "datatype");
	torture_assert_str_equal(tctx, r->info.parameters, "", "parameters");

	torture_assert(tctx, r->devmode, "devmode");
	torture_assert_str_equal(tctx, r->devmode->devicename, "\\\\irobot\\Kyocera-500", "devicename");
	torture_assert_str_equal(tctx, r->devmode->formname, "Letter", "formname");
	torture_assert_int_equal(tctx, r->devmode->specversion, 0x0401, "specversion");
	torture_assert_int_equal(tctx, r->devmode->driverversion, 0x0600, "driverversion");
	torture_assert_int_equal(tctx, r->devmode->size, 0x00dc, "size");
	torture_assert_int_equal(tctx, r->devmode->driverextra, 0x0860, "driverextra");
	torture_assert_int_equal(tctx, r->devmode->orientation, 1, "orientation");
	torture_assert_int_equal(tctx, r->devmode->papersize, 1, "papersize");
	torture_assert_int_equal(tctx, r->devmode->paperlength, 0x0aea, "paperlength");
	torture_assert_int_equal(tctx, r->devmode->paperwidth, 0x086f, "paperwidth");
	torture_assert_int_equal(tctx, r->devmode->scale, 0x0064, "scale");
	torture_assert_int_equal(tctx, r->devmode->copies, 1, "copies");
	torture_assert_int_equal(tctx, r->devmode->defaultsource, 0x000f, "defaultsource");
	torture_assert_int_equal(tctx, r->devmode->printquality, 0x0258, "printquality");
	torture_assert_int_equal(tctx, r->devmode->color, 2, "color");
	torture_assert_int_equal(tctx, r->devmode->duplex, 1, "duplex");
	torture_assert_int_equal(tctx, r->devmode->yresolution, 0x0258, "yresolution");
	torture_assert_int_equal(tctx, r->devmode->ttoption, 2, "ttoption");
	torture_assert_int_equal(tctx, r->devmode->collate, 1, "collate");
	torture_assert_int_equal(tctx, r->devmode->logpixels, 0, "logpixels");
	torture_assert_int_equal(tctx, r->devmode->fields, 0x0381ff53, "fields");
	torture_assert_int_equal(tctx, r->devmode->bitsperpel, 0, "bitsperpel");
	torture_assert_int_equal(tctx, r->devmode->pelswidth, 0, "pelswidth");
	torture_assert_int_equal(tctx, r->devmode->pelsheight, 0, "pelsheight");
	torture_assert_int_equal(tctx, r->devmode->displayflags, 1, "displayflags");
	torture_assert_int_equal(tctx, r->devmode->displayfrequency, 0, "displayfrequency");
	torture_assert_int_equal(tctx, r->devmode->icmmethod, 1, "icmmethod");
	torture_assert_int_equal(tctx, r->devmode->icmintent, 2, "icmintent");
	torture_assert_int_equal(tctx, r->devmode->mediatype, 0x00000101, "mediatype");
	torture_assert_int_equal(tctx, r->devmode->dithertype, 0, "dithertype");
	torture_assert_int_equal(tctx, r->devmode->reserved1, 0, "reserved1");
	torture_assert_int_equal(tctx, r->devmode->reserved2, 0, "reserved2");
	torture_assert_int_equal(tctx, r->devmode->panningwidth, 0, "panningwidth");
	torture_assert_int_equal(tctx, r->devmode->panningheight, 0, "panningheight");

	torture_assert(tctx, r->devmode->nt_dev_private, "nt_dev_private");
	torture_assert_int_equal(tctx, r->devmode->nt_dev_private->length, 2144, "nt_dev_private->length");

	torture_assert_int_equal(tctx, r->count, 11, "count");

	torture_assert_int_equal(tctx, r->printer_data[0].ptr, 1, "ptr");
	torture_assert_str_equal(tctx, r->printer_data[0].name, "PrinterDriverData", "name");
	torture_assert_int_equal(tctx, r->printer_data[0].type, 0, "type");
	torture_assert_int_equal(tctx, r->printer_data[0].data.length, 0, "data.length");

	torture_assert_int_equal(tctx, r->printer_data[1].ptr, 1, "ptr");
	torture_assert_str_equal(tctx, r->printer_data[1].name, "PrinterDriverData\\TrayFormSize", "name");
	torture_assert_int_equal(tctx, r->printer_data[1].type, 4, "type");
	torture_assert_int_equal(tctx, r->printer_data[1].data.length, 4, "data.length");

	torture_assert_int_equal(tctx, r->printer_data[2].ptr, 1, "ptr");
	torture_assert_str_equal(tctx, r->printer_data[2].name, "PrinterDriverData\\TrayFormTable", "name");
	torture_assert_int_equal(tctx, r->printer_data[2].type, 3, "type");
	torture_assert_int_equal(tctx, r->printer_data[2].data.length, 206, "data.length");

	torture_assert_int_equal(tctx, r->printer_data[3].ptr, 1, "ptr");
	torture_assert_str_equal(tctx, r->printer_data[3].name, "PrinterDriverData\\TrayFormMapSize", "name");
	torture_assert_int_equal(tctx, r->printer_data[3].type, 4, "type");
	torture_assert_int_equal(tctx, r->printer_data[3].data.length, 4, "data.length");

	torture_assert_int_equal(tctx, r->printer_data[4].ptr, 1, "ptr");
	torture_assert_str_equal(tctx, r->printer_data[4].name, "PrinterDriverData\\TrayFormMap", "name");
	torture_assert_int_equal(tctx, r->printer_data[4].type, 3, "type");
	torture_assert_int_equal(tctx, r->printer_data[4].data.length, 57, "data.length");

	torture_assert_int_equal(tctx, r->printer_data[5].ptr, 1, "ptr");
	torture_assert_str_equal(tctx, r->printer_data[5].name, "PrinterDriverData\\TrayFormKeywordSize", "name");
	torture_assert_int_equal(tctx, r->printer_data[5].type, 4, "type");
	torture_assert_int_equal(tctx, r->printer_data[5].data.length, 4, "data.length");

	torture_assert_int_equal(tctx, r->printer_data[6].ptr, 1, "ptr");
	torture_assert_str_equal(tctx, r->printer_data[6].name, "PrinterDriverData\\TrayFormKeyword", "name");
	torture_assert_int_equal(tctx, r->printer_data[6].type, 3, "type");
	torture_assert_int_equal(tctx, r->printer_data[6].data.length, 38, "data.length");

	torture_assert_int_equal(tctx, r->printer_data[7].ptr, 1, "ptr");
	torture_assert_str_equal(tctx, r->printer_data[7].name, "DsSpooler", "name");
	torture_assert_int_equal(tctx, r->printer_data[7].type, 0, "type");
	torture_assert_int_equal(tctx, r->printer_data[7].data.length, 0, "data.length");

	torture_assert_int_equal(tctx, r->printer_data[8].ptr, 1, "ptr");
	torture_assert_str_equal(tctx, r->printer_data[8].name, "DsSpooler\\serverName", "name");
	torture_assert_int_equal(tctx, r->printer_data[8].type, 1, "type");
	torture_assert_int_equal(tctx, r->printer_data[8].data.length, 14, "data.length");

	torture_assert_int_equal(tctx, r->printer_data[9].ptr, 1, "ptr");
	torture_assert_str_equal(tctx, r->printer_data[9].name, "DsSpooler\\shortServerName", "name");
	torture_assert_int_equal(tctx, r->printer_data[9].type, 1, "type");
	torture_assert_int_equal(tctx, r->printer_data[9].data.length, 14, "data.length");

	torture_assert_int_equal(tctx, r->printer_data[10].ptr, 1, "ptr");
	torture_assert_str_equal(tctx, r->printer_data[10].name, "DsSpooler\\uNCName", "name");
	torture_assert_int_equal(tctx, r->printer_data[10].type, 1, "type");
	torture_assert_int_equal(tctx, r->printer_data[10].data.length, 42, "data.length");

	return true;
}

static bool ntprinting_printer_latin1_check(struct torture_context *tctx)
{
	enum ndr_err_code ndr_err;
	struct ntprinting_printer r;
	DATA_BLOB blob;
	bool ok;

	ok = lpcfg_do_global_parameter(tctx->lp_ctx, "dos charset", "CP1252");
	if (!ok) {
		torture_comment(tctx, "Could not set 'dos charset' option.\n");
		return false;
	}
	reload_charcnv(tctx->lp_ctx);

	ZERO_STRUCT(r);
	r.info.string_flags = LIBNDR_FLAG_STR_ASCII;

	blob = data_blob_const(ntprinting_printer_data_latin1,
			       sizeof(ntprinting_printer_data_latin1));

	ndr_err = ndr_pull_struct_blob(&blob, tctx, &r,
		   (ndr_pull_flags_fn_t)ndr_pull_ntprinting_printer);

	torture_assert_ndr_success(tctx,
				   ndr_err,
				   "ndr_pull_ntprinting_printer");
#if 0
	ndr_print_debug((ndr_print_fn_t) ndr_print_ntprinting_printer,
			"ntprinter",
			&r);
#endif
	torture_assert_str_equal(tctx,
				 r.info.printername,
				 "S0BC",
				 "printername");
	/* latin1 encoding check */
	torture_assert_str_equal(tctx,
				 r.info.comment,
				 "\" SALA DA RECEPÇÃO DA CONSTRUÇÃO - RAND0 LOCATIO",
				 "comment");
	torture_assert_str_equal(tctx,
				 r.info.location,
				 "UTGCA ",
				 "location");

	return true;
}

struct torture_suite *ndr_ntprinting_suite(TALLOC_CTX *ctx)
{
	struct torture_suite *suite = torture_suite_create(ctx, "ntprinting");

	torture_suite_add_simple_test(suite,
				      "ntprinting latin1 check",
				      ntprinting_printer_latin1_check);

	torture_suite_add_ndr_pull_test(suite,
					ntprinting_printer,
					ntprinting_printer_data,
					ntprinting_printer_check);

	/* pullpush not working atm.
	torture_suite_add_ndr_pullpush_test(suite,
					    ntprinting_printer,
					    data_blob_const(ntprinting_printer_data, sizeof(ntprinting_printer_data)),
					    ntprinting_printer_check);
	*/
	return suite;
}
