#!/bin/sh

# Run this script to build samba from SVN.

## insert all possible names (only works with 
## autoconf 2.x
TESTAUTOHEADER="autoheader autoheader-2.53 autoheader2.50 autoheader259 autoheader253"
TESTAUTOCONF="autoconf autoconf-2.53 autoconf2.50 autoconf259 autoconf253"


AUTOHEADERFOUND="0"
AUTOCONFFOUND="0"


##
## Look for autoheader 
##
for i in $TESTAUTOHEADER; do
	if which $i > /dev/null 2>&1; then
		if [ `$i --version | head -n 1 | cut -d.  -f 2 | tr -d [:alpha:]` -ge 53 ]; then
			AUTOHEADER=$i
			AUTOHEADERFOUND="1"
			break
		fi
	fi
done

## 
## Look for autoconf
##

for i in $TESTAUTOCONF; do
	if which $i > /dev/null 2>&1; then
		if [ `$i --version | head -n 1 | cut -d.  -f 2 | tr -d [:alpha:]` -ge 53 ]; then
			AUTOCONF=$i
			AUTOCONFFOUND="1"
			break
		fi
	fi
done


## 
## do we have it?
##
if [ "$AUTOCONFFOUND" = "0" -o "$AUTOHEADERFOUND" = "0" ]; then
	echo "$0: need autoconf 2.53 or later to build samba from SVN" >&2
	exit 1
fi

rm -rf autom4te*.cache

echo "$0: running $AUTOHEADER"
$AUTOHEADER || exit 1

echo "$0: running $AUTOCONF"
$AUTOCONF || exit 1

rm -rf autom4te*.cache

echo "Now run ./configure and then make."
exit 0

