
/* Python wrapper functions auto-generated by pidl */
#include <Python.h>
#include "includes.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "autoconf/librpc/gen_ndr/ndr_netlogon.h"
#include "autoconf/librpc/gen_ndr/ndr_netlogon_c.h"

#include "librpc/gen_ndr/misc.h"
#include "librpc/gen_ndr/lsa.h"
#include "librpc/gen_ndr/samr.h"
#include "librpc/gen_ndr/security.h"
staticforward PyTypeObject netr_UasInfo_Type;
staticforward PyTypeObject netr_UasLogoffInfo_Type;
staticforward PyTypeObject netr_AcctLockStr_Type;
staticforward PyTypeObject netr_IdentityInfo_Type;
staticforward PyTypeObject netr_PasswordInfo_Type;
staticforward PyTypeObject netr_ChallengeResponse_Type;
staticforward PyTypeObject netr_NetworkInfo_Type;
staticforward PyTypeObject netr_GenericInfo_Type;
staticforward PyTypeObject netr_UserSessionKey_Type;
staticforward PyTypeObject netr_LMSessionKey_Type;
staticforward PyTypeObject netr_SamBaseInfo_Type;
staticforward PyTypeObject netr_SamInfo2_Type;
staticforward PyTypeObject netr_SidAttr_Type;
staticforward PyTypeObject netr_SamInfo3_Type;
staticforward PyTypeObject netr_SamInfo6_Type;
staticforward PyTypeObject netr_PacInfo_Type;
staticforward PyTypeObject netr_GenericInfo2_Type;
staticforward PyTypeObject netr_Credential_Type;
staticforward PyTypeObject netr_Authenticator_Type;
staticforward PyTypeObject netr_DELTA_DELETE_USER_Type;
staticforward PyTypeObject netr_USER_KEY16_Type;
staticforward PyTypeObject netr_PasswordHistory_Type;
staticforward PyTypeObject netr_USER_KEYS2_Type;
staticforward PyTypeObject netr_USER_KEY_UNION_Type;
staticforward PyTypeObject netr_USER_KEYS_Type;
staticforward PyTypeObject netr_USER_PRIVATE_INFO_Type;
staticforward PyTypeObject netr_DELTA_USER_Type;
staticforward PyTypeObject netr_DELTA_DOMAIN_Type;
staticforward PyTypeObject netr_DELTA_GROUP_Type;
staticforward PyTypeObject netr_DELTA_RENAME_Type;
staticforward PyTypeObject netr_DELTA_GROUP_MEMBER_Type;
staticforward PyTypeObject netr_DELTA_ALIAS_Type;
staticforward PyTypeObject netr_DELTA_ALIAS_MEMBER_Type;
staticforward PyTypeObject netr_QUOTA_LIMITS_Type;
staticforward PyTypeObject netr_DELTA_POLICY_Type;
staticforward PyTypeObject netr_DELTA_TRUSTED_DOMAIN_Type;
staticforward PyTypeObject netr_DELTA_ACCOUNT_Type;
staticforward PyTypeObject netr_CIPHER_VALUE_Type;
staticforward PyTypeObject netr_DELTA_SECRET_Type;
staticforward PyTypeObject netr_DELTA_ENUM_Type;
staticforward PyTypeObject netr_DELTA_ENUM_ARRAY_Type;
staticforward PyTypeObject netr_UAS_INFO_0_Type;
staticforward PyTypeObject netr_AccountBuffer_Type;
staticforward PyTypeObject netr_NETLOGON_INFO_1_Type;
staticforward PyTypeObject netr_NETLOGON_INFO_2_Type;
staticforward PyTypeObject netr_NETLOGON_INFO_3_Type;
staticforward PyTypeObject netr_NETLOGON_INFO_4_Type;
staticforward PyTypeObject netr_ChangeLogEntry_Type;
staticforward PyTypeObject netr_Blob_Type;
staticforward PyTypeObject netr_DsRGetDCNameInfo_Type;
staticforward PyTypeObject netr_LsaPolicyInformation_Type;
staticforward PyTypeObject netr_OsVersionInfoEx_Type;
staticforward PyTypeObject netr_OsVersion_Type;
staticforward PyTypeObject netr_OsVersionContainer_Type;
staticforward PyTypeObject netr_WorkstationInformation_Type;
staticforward PyTypeObject netr_trust_extension_Type;
staticforward PyTypeObject netr_trust_extension_container_Type;
staticforward PyTypeObject netr_OneDomainInfo_Type;
staticforward PyTypeObject netr_DomainInformation_Type;
staticforward PyTypeObject NL_PASSWORD_VERSION_Type;
staticforward PyTypeObject netr_CryptPassword_Type;
staticforward PyTypeObject netr_DsRAddressToSitenamesWCtr_Type;
staticforward PyTypeObject netr_DsRAddress_Type;
staticforward PyTypeObject netr_DomainTrust_Type;
staticforward PyTypeObject netr_DomainTrustList_Type;
staticforward PyTypeObject netr_DsRAddressToSitenamesExWCtr_Type;
staticforward PyTypeObject DcSitesCtr_Type;
staticforward PyTypeObject netr_TrustInfo_Type;
staticforward PyTypeObject NL_DNS_NAME_INFO_Type;
staticforward PyTypeObject NL_DNS_NAME_INFO_ARRAY_Type;
staticforward PyTypeObject netlogon_InterfaceType;

void initnetlogon(void);static PyTypeObject *GUID_Type;
static PyTypeObject *samr_Password_Type;
static PyTypeObject *sec_desc_buf_Type;
static PyTypeObject *samr_RidWithAttributeArray_Type;
static PyTypeObject *Object_Type;
static PyTypeObject *ClientConnection_Type;
static PyTypeObject *lsa_StringLarge_Type;
static PyTypeObject *lsa_SidArray_Type;
static PyTypeObject *lsa_BinaryString_Type;
static PyTypeObject *lsa_String_Type;
static PyTypeObject *lsa_ForestTrustInformation_Type;
static PyTypeObject *dom_sid_Type;
static PyTypeObject *samr_LogonHours_Type;

static PyObject *py_netr_UasInfo_get_account_name(PyObject *obj, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)pytalloc_get_ptr(obj);
	PyObject *py_account_name;
	if (object->account_name == NULL) {
		py_account_name = Py_None;
		Py_INCREF(py_account_name);
	} else {
		if (object->account_name == NULL) {
			py_account_name = Py_None;
			Py_INCREF(py_account_name);
		} else {
			py_account_name = PyUnicode_Decode(object->account_name, strlen(object->account_name), "utf-8", "ignore");
		}
	}
	return py_account_name;
}

static int py_netr_UasInfo_set_account_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->account_name = NULL;
	} else {
		object->account_name = NULL;
		if (PyUnicode_Check(value)) {
			object->account_name = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->account_name = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_UasInfo_get_priv(PyObject *obj, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)pytalloc_get_ptr(obj);
	PyObject *py_priv;
	py_priv = PyInt_FromLong(object->priv);
	return py_priv;
}

static int py_netr_UasInfo_set_priv(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->priv = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_UasInfo_get_auth_flags(PyObject *obj, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)pytalloc_get_ptr(obj);
	PyObject *py_auth_flags;
	py_auth_flags = PyInt_FromLong(object->auth_flags);
	return py_auth_flags;
}

static int py_netr_UasInfo_set_auth_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->auth_flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_UasInfo_get_logon_count(PyObject *obj, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)pytalloc_get_ptr(obj);
	PyObject *py_logon_count;
	py_logon_count = PyInt_FromLong(object->logon_count);
	return py_logon_count;
}

static int py_netr_UasInfo_set_logon_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->logon_count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_UasInfo_get_bad_pw_count(PyObject *obj, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)pytalloc_get_ptr(obj);
	PyObject *py_bad_pw_count;
	py_bad_pw_count = PyInt_FromLong(object->bad_pw_count);
	return py_bad_pw_count;
}

static int py_netr_UasInfo_set_bad_pw_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->bad_pw_count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_UasInfo_get_last_logon(PyObject *obj, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)pytalloc_get_ptr(obj);
	PyObject *py_last_logon;
	py_last_logon = PyInt_FromLong(object->last_logon);
	return py_last_logon;
}

static int py_netr_UasInfo_set_last_logon(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->last_logon = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_UasInfo_get_last_logoff(PyObject *obj, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)pytalloc_get_ptr(obj);
	PyObject *py_last_logoff;
	py_last_logoff = PyInt_FromLong(object->last_logoff);
	return py_last_logoff;
}

static int py_netr_UasInfo_set_last_logoff(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->last_logoff = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_UasInfo_get_logoff_time(PyObject *obj, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)pytalloc_get_ptr(obj);
	PyObject *py_logoff_time;
	py_logoff_time = PyInt_FromLong(object->logoff_time);
	return py_logoff_time;
}

static int py_netr_UasInfo_set_logoff_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->logoff_time = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_UasInfo_get_kickoff_time(PyObject *obj, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)pytalloc_get_ptr(obj);
	PyObject *py_kickoff_time;
	py_kickoff_time = PyInt_FromLong(object->kickoff_time);
	return py_kickoff_time;
}

static int py_netr_UasInfo_set_kickoff_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->kickoff_time = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_UasInfo_get_password_age(PyObject *obj, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)pytalloc_get_ptr(obj);
	PyObject *py_password_age;
	py_password_age = PyInt_FromLong(object->password_age);
	return py_password_age;
}

static int py_netr_UasInfo_set_password_age(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->password_age = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_UasInfo_get_pw_can_change(PyObject *obj, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)pytalloc_get_ptr(obj);
	PyObject *py_pw_can_change;
	py_pw_can_change = PyInt_FromLong(object->pw_can_change);
	return py_pw_can_change;
}

static int py_netr_UasInfo_set_pw_can_change(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->pw_can_change = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_UasInfo_get_pw_must_change(PyObject *obj, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)pytalloc_get_ptr(obj);
	PyObject *py_pw_must_change;
	py_pw_must_change = PyInt_FromLong(object->pw_must_change);
	return py_pw_must_change;
}

static int py_netr_UasInfo_set_pw_must_change(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->pw_must_change = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_UasInfo_get_computer(PyObject *obj, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)pytalloc_get_ptr(obj);
	PyObject *py_computer;
	if (object->computer == NULL) {
		py_computer = Py_None;
		Py_INCREF(py_computer);
	} else {
		if (object->computer == NULL) {
			py_computer = Py_None;
			Py_INCREF(py_computer);
		} else {
			py_computer = PyUnicode_Decode(object->computer, strlen(object->computer), "utf-8", "ignore");
		}
	}
	return py_computer;
}

static int py_netr_UasInfo_set_computer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->computer = NULL;
	} else {
		object->computer = NULL;
		if (PyUnicode_Check(value)) {
			object->computer = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->computer = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_UasInfo_get_domain(PyObject *obj, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)pytalloc_get_ptr(obj);
	PyObject *py_domain;
	if (object->domain == NULL) {
		py_domain = Py_None;
		Py_INCREF(py_domain);
	} else {
		if (object->domain == NULL) {
			py_domain = Py_None;
			Py_INCREF(py_domain);
		} else {
			py_domain = PyUnicode_Decode(object->domain, strlen(object->domain), "utf-8", "ignore");
		}
	}
	return py_domain;
}

static int py_netr_UasInfo_set_domain(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->domain = NULL;
	} else {
		object->domain = NULL;
		if (PyUnicode_Check(value)) {
			object->domain = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->domain = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_UasInfo_get_script_path(PyObject *obj, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)pytalloc_get_ptr(obj);
	PyObject *py_script_path;
	if (object->script_path == NULL) {
		py_script_path = Py_None;
		Py_INCREF(py_script_path);
	} else {
		if (object->script_path == NULL) {
			py_script_path = Py_None;
			Py_INCREF(py_script_path);
		} else {
			py_script_path = PyUnicode_Decode(object->script_path, strlen(object->script_path), "utf-8", "ignore");
		}
	}
	return py_script_path;
}

static int py_netr_UasInfo_set_script_path(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->script_path = NULL;
	} else {
		object->script_path = NULL;
		if (PyUnicode_Check(value)) {
			object->script_path = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->script_path = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_UasInfo_get_unknown(PyObject *obj, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)pytalloc_get_ptr(obj);
	PyObject *py_unknown;
	py_unknown = PyInt_FromLong(object->unknown);
	return py_unknown;
}

static int py_netr_UasInfo_set_unknown(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasInfo *object = (struct netr_UasInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_UasInfo_getsetters[] = {
	{ discard_const_p(char, "account_name"), py_netr_UasInfo_get_account_name, py_netr_UasInfo_set_account_name },
	{ discard_const_p(char, "priv"), py_netr_UasInfo_get_priv, py_netr_UasInfo_set_priv },
	{ discard_const_p(char, "auth_flags"), py_netr_UasInfo_get_auth_flags, py_netr_UasInfo_set_auth_flags },
	{ discard_const_p(char, "logon_count"), py_netr_UasInfo_get_logon_count, py_netr_UasInfo_set_logon_count },
	{ discard_const_p(char, "bad_pw_count"), py_netr_UasInfo_get_bad_pw_count, py_netr_UasInfo_set_bad_pw_count },
	{ discard_const_p(char, "last_logon"), py_netr_UasInfo_get_last_logon, py_netr_UasInfo_set_last_logon },
	{ discard_const_p(char, "last_logoff"), py_netr_UasInfo_get_last_logoff, py_netr_UasInfo_set_last_logoff },
	{ discard_const_p(char, "logoff_time"), py_netr_UasInfo_get_logoff_time, py_netr_UasInfo_set_logoff_time },
	{ discard_const_p(char, "kickoff_time"), py_netr_UasInfo_get_kickoff_time, py_netr_UasInfo_set_kickoff_time },
	{ discard_const_p(char, "password_age"), py_netr_UasInfo_get_password_age, py_netr_UasInfo_set_password_age },
	{ discard_const_p(char, "pw_can_change"), py_netr_UasInfo_get_pw_can_change, py_netr_UasInfo_set_pw_can_change },
	{ discard_const_p(char, "pw_must_change"), py_netr_UasInfo_get_pw_must_change, py_netr_UasInfo_set_pw_must_change },
	{ discard_const_p(char, "computer"), py_netr_UasInfo_get_computer, py_netr_UasInfo_set_computer },
	{ discard_const_p(char, "domain"), py_netr_UasInfo_get_domain, py_netr_UasInfo_set_domain },
	{ discard_const_p(char, "script_path"), py_netr_UasInfo_get_script_path, py_netr_UasInfo_set_script_path },
	{ discard_const_p(char, "unknown"), py_netr_UasInfo_get_unknown, py_netr_UasInfo_set_unknown },
	{ NULL }
};

static PyObject *py_netr_UasInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_UasInfo, type);
}


static PyTypeObject netr_UasInfo_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_UasInfo",
	.tp_getset = py_netr_UasInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_UasInfo_new,
};


static PyObject *py_netr_UasLogoffInfo_get_duration(PyObject *obj, void *closure)
{
	struct netr_UasLogoffInfo *object = (struct netr_UasLogoffInfo *)pytalloc_get_ptr(obj);
	PyObject *py_duration;
	py_duration = PyInt_FromLong(object->duration);
	return py_duration;
}

static int py_netr_UasLogoffInfo_set_duration(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasLogoffInfo *object = (struct netr_UasLogoffInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->duration = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_UasLogoffInfo_get_logon_count(PyObject *obj, void *closure)
{
	struct netr_UasLogoffInfo *object = (struct netr_UasLogoffInfo *)pytalloc_get_ptr(obj);
	PyObject *py_logon_count;
	py_logon_count = PyInt_FromLong(object->logon_count);
	return py_logon_count;
}

static int py_netr_UasLogoffInfo_set_logon_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UasLogoffInfo *object = (struct netr_UasLogoffInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->logon_count = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_UasLogoffInfo_getsetters[] = {
	{ discard_const_p(char, "duration"), py_netr_UasLogoffInfo_get_duration, py_netr_UasLogoffInfo_set_duration },
	{ discard_const_p(char, "logon_count"), py_netr_UasLogoffInfo_get_logon_count, py_netr_UasLogoffInfo_set_logon_count },
	{ NULL }
};

static PyObject *py_netr_UasLogoffInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_UasLogoffInfo, type);
}


static PyTypeObject netr_UasLogoffInfo_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_UasLogoffInfo",
	.tp_getset = py_netr_UasLogoffInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_UasLogoffInfo_new,
};


static PyObject *py_netr_AcctLockStr_get_lockout_duration(PyObject *obj, void *closure)
{
	struct netr_AcctLockStr *object = (struct netr_AcctLockStr *)pytalloc_get_ptr(obj);
	PyObject *py_lockout_duration;
	py_lockout_duration = PyLong_FromLongLong(object->lockout_duration);
	return py_lockout_duration;
}

static int py_netr_AcctLockStr_set_lockout_duration(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_AcctLockStr *object = (struct netr_AcctLockStr *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->lockout_duration = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->lockout_duration = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netr_AcctLockStr_get_reset_count(PyObject *obj, void *closure)
{
	struct netr_AcctLockStr *object = (struct netr_AcctLockStr *)pytalloc_get_ptr(obj);
	PyObject *py_reset_count;
	py_reset_count = PyLong_FromLongLong(object->reset_count);
	return py_reset_count;
}

static int py_netr_AcctLockStr_set_reset_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_AcctLockStr *object = (struct netr_AcctLockStr *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->reset_count = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->reset_count = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netr_AcctLockStr_get_bad_attempt_lockout(PyObject *obj, void *closure)
{
	struct netr_AcctLockStr *object = (struct netr_AcctLockStr *)pytalloc_get_ptr(obj);
	PyObject *py_bad_attempt_lockout;
	py_bad_attempt_lockout = PyInt_FromLong(object->bad_attempt_lockout);
	return py_bad_attempt_lockout;
}

static int py_netr_AcctLockStr_set_bad_attempt_lockout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_AcctLockStr *object = (struct netr_AcctLockStr *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->bad_attempt_lockout = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_AcctLockStr_get_dummy(PyObject *obj, void *closure)
{
	struct netr_AcctLockStr *object = (struct netr_AcctLockStr *)pytalloc_get_ptr(obj);
	PyObject *py_dummy;
	py_dummy = PyInt_FromLong(object->dummy);
	return py_dummy;
}

static int py_netr_AcctLockStr_set_dummy(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_AcctLockStr *object = (struct netr_AcctLockStr *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dummy = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_AcctLockStr_getsetters[] = {
	{ discard_const_p(char, "lockout_duration"), py_netr_AcctLockStr_get_lockout_duration, py_netr_AcctLockStr_set_lockout_duration },
	{ discard_const_p(char, "reset_count"), py_netr_AcctLockStr_get_reset_count, py_netr_AcctLockStr_set_reset_count },
	{ discard_const_p(char, "bad_attempt_lockout"), py_netr_AcctLockStr_get_bad_attempt_lockout, py_netr_AcctLockStr_set_bad_attempt_lockout },
	{ discard_const_p(char, "dummy"), py_netr_AcctLockStr_get_dummy, py_netr_AcctLockStr_set_dummy },
	{ NULL }
};

static PyObject *py_netr_AcctLockStr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_AcctLockStr, type);
}

static PyObject *py_netr_AcctLockStr_ndr_pack(PyObject *py_obj)
{
	struct netr_AcctLockStr *object = (struct netr_AcctLockStr *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_netr_AcctLockStr);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_netr_AcctLockStr_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_AcctLockStr *object = (struct netr_AcctLockStr *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_AcctLockStr);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_AcctLockStr);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_netr_AcctLockStr_ndr_print(PyObject *py_obj)
{
	struct netr_AcctLockStr *object = (struct netr_AcctLockStr *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_AcctLockStr, "netr_AcctLockStr", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_netr_AcctLockStr_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_netr_AcctLockStr_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_netr_AcctLockStr_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_netr_AcctLockStr_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netr_AcctLockStr_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_AcctLockStr",
	.tp_getset = py_netr_AcctLockStr_getsetters,
	.tp_methods = py_netr_AcctLockStr_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_AcctLockStr_new,
};


static PyObject *py_netr_IdentityInfo_get_domain_name(PyObject *obj, void *closure)
{
	struct netr_IdentityInfo *object = (struct netr_IdentityInfo *)pytalloc_get_ptr(obj);
	PyObject *py_domain_name;
	py_domain_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->domain_name);
	return py_domain_name;
}

static int py_netr_IdentityInfo_set_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_IdentityInfo *object = (struct netr_IdentityInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->domain_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_IdentityInfo_get_parameter_control(PyObject *obj, void *closure)
{
	struct netr_IdentityInfo *object = (struct netr_IdentityInfo *)pytalloc_get_ptr(obj);
	PyObject *py_parameter_control;
	py_parameter_control = PyInt_FromLong(object->parameter_control);
	return py_parameter_control;
}

static int py_netr_IdentityInfo_set_parameter_control(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_IdentityInfo *object = (struct netr_IdentityInfo *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->parameter_control = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->parameter_control = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netr_IdentityInfo_get_logon_id_low(PyObject *obj, void *closure)
{
	struct netr_IdentityInfo *object = (struct netr_IdentityInfo *)pytalloc_get_ptr(obj);
	PyObject *py_logon_id_low;
	py_logon_id_low = PyInt_FromLong(object->logon_id_low);
	return py_logon_id_low;
}

static int py_netr_IdentityInfo_set_logon_id_low(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_IdentityInfo *object = (struct netr_IdentityInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->logon_id_low = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_IdentityInfo_get_logon_id_high(PyObject *obj, void *closure)
{
	struct netr_IdentityInfo *object = (struct netr_IdentityInfo *)pytalloc_get_ptr(obj);
	PyObject *py_logon_id_high;
	py_logon_id_high = PyInt_FromLong(object->logon_id_high);
	return py_logon_id_high;
}

static int py_netr_IdentityInfo_set_logon_id_high(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_IdentityInfo *object = (struct netr_IdentityInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->logon_id_high = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_IdentityInfo_get_account_name(PyObject *obj, void *closure)
{
	struct netr_IdentityInfo *object = (struct netr_IdentityInfo *)pytalloc_get_ptr(obj);
	PyObject *py_account_name;
	py_account_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->account_name);
	return py_account_name;
}

static int py_netr_IdentityInfo_set_account_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_IdentityInfo *object = (struct netr_IdentityInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->account_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_IdentityInfo_get_workstation(PyObject *obj, void *closure)
{
	struct netr_IdentityInfo *object = (struct netr_IdentityInfo *)pytalloc_get_ptr(obj);
	PyObject *py_workstation;
	py_workstation = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->workstation);
	return py_workstation;
}

static int py_netr_IdentityInfo_set_workstation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_IdentityInfo *object = (struct netr_IdentityInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->workstation = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_netr_IdentityInfo_getsetters[] = {
	{ discard_const_p(char, "domain_name"), py_netr_IdentityInfo_get_domain_name, py_netr_IdentityInfo_set_domain_name },
	{ discard_const_p(char, "parameter_control"), py_netr_IdentityInfo_get_parameter_control, py_netr_IdentityInfo_set_parameter_control },
	{ discard_const_p(char, "logon_id_low"), py_netr_IdentityInfo_get_logon_id_low, py_netr_IdentityInfo_set_logon_id_low },
	{ discard_const_p(char, "logon_id_high"), py_netr_IdentityInfo_get_logon_id_high, py_netr_IdentityInfo_set_logon_id_high },
	{ discard_const_p(char, "account_name"), py_netr_IdentityInfo_get_account_name, py_netr_IdentityInfo_set_account_name },
	{ discard_const_p(char, "workstation"), py_netr_IdentityInfo_get_workstation, py_netr_IdentityInfo_set_workstation },
	{ NULL }
};

static PyObject *py_netr_IdentityInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_IdentityInfo, type);
}


static PyTypeObject netr_IdentityInfo_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_IdentityInfo",
	.tp_getset = py_netr_IdentityInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_IdentityInfo_new,
};


static PyObject *py_netr_PasswordInfo_get_identity_info(PyObject *obj, void *closure)
{
	struct netr_PasswordInfo *object = (struct netr_PasswordInfo *)pytalloc_get_ptr(obj);
	PyObject *py_identity_info;
	py_identity_info = pytalloc_reference_ex(&netr_IdentityInfo_Type, pytalloc_get_mem_ctx(obj), &object->identity_info);
	return py_identity_info;
}

static int py_netr_PasswordInfo_set_identity_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PasswordInfo *object = (struct netr_PasswordInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_IdentityInfo_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->identity_info = *(struct netr_IdentityInfo *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_PasswordInfo_get_lmpassword(PyObject *obj, void *closure)
{
	struct netr_PasswordInfo *object = (struct netr_PasswordInfo *)pytalloc_get_ptr(obj);
	PyObject *py_lmpassword;
	py_lmpassword = pytalloc_reference_ex(samr_Password_Type, pytalloc_get_mem_ctx(obj), &object->lmpassword);
	return py_lmpassword;
}

static int py_netr_PasswordInfo_set_lmpassword(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PasswordInfo *object = (struct netr_PasswordInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(samr_Password_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->lmpassword = *(struct samr_Password *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_PasswordInfo_get_ntpassword(PyObject *obj, void *closure)
{
	struct netr_PasswordInfo *object = (struct netr_PasswordInfo *)pytalloc_get_ptr(obj);
	PyObject *py_ntpassword;
	py_ntpassword = pytalloc_reference_ex(samr_Password_Type, pytalloc_get_mem_ctx(obj), &object->ntpassword);
	return py_ntpassword;
}

static int py_netr_PasswordInfo_set_ntpassword(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PasswordInfo *object = (struct netr_PasswordInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(samr_Password_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->ntpassword = *(struct samr_Password *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_netr_PasswordInfo_getsetters[] = {
	{ discard_const_p(char, "identity_info"), py_netr_PasswordInfo_get_identity_info, py_netr_PasswordInfo_set_identity_info },
	{ discard_const_p(char, "lmpassword"), py_netr_PasswordInfo_get_lmpassword, py_netr_PasswordInfo_set_lmpassword },
	{ discard_const_p(char, "ntpassword"), py_netr_PasswordInfo_get_ntpassword, py_netr_PasswordInfo_set_ntpassword },
	{ NULL }
};

static PyObject *py_netr_PasswordInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_PasswordInfo, type);
}


static PyTypeObject netr_PasswordInfo_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_PasswordInfo",
	.tp_getset = py_netr_PasswordInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_PasswordInfo_new,
};


static PyObject *py_netr_ChallengeResponse_get_length(PyObject *obj, void *closure)
{
	struct netr_ChallengeResponse *object = (struct netr_ChallengeResponse *)pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyInt_FromLong(object->length);
	return py_length;
}

static int py_netr_ChallengeResponse_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_ChallengeResponse *object = (struct netr_ChallengeResponse *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_ChallengeResponse_get_size(PyObject *obj, void *closure)
{
	struct netr_ChallengeResponse *object = (struct netr_ChallengeResponse *)pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyInt_FromLong(object->size);
	return py_size;
}

static int py_netr_ChallengeResponse_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_ChallengeResponse *object = (struct netr_ChallengeResponse *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_ChallengeResponse_get_data(PyObject *obj, void *closure)
{
	struct netr_ChallengeResponse *object = (struct netr_ChallengeResponse *)pytalloc_get_ptr(obj);
	PyObject *py_data;
	if (object->data == NULL) {
		py_data = Py_None;
		Py_INCREF(py_data);
	} else {
		py_data = PyList_New(object->length);
		if (py_data == NULL) {
			return NULL;
		}
		{
			int data_cntr_1;
			for (data_cntr_1 = 0; data_cntr_1 < object->length; data_cntr_1++) {
				PyObject *py_data_1;
				py_data_1 = PyInt_FromLong(object->data[data_cntr_1]);
				PyList_SetItem(py_data, data_cntr_1, py_data_1);
			}
		}
	}
	return py_data;
}

static int py_netr_ChallengeResponse_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_ChallengeResponse *object = (struct netr_ChallengeResponse *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->data);
	if (value == Py_None) {
		object->data = NULL;
	} else {
		object->data = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int data_cntr_1;
			object->data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->data, PyList_GET_SIZE(value));
			if (!object->data) { return -1;; }
			talloc_set_name_const(object->data, "ARRAY: object->data");
			for (data_cntr_1 = 0; data_cntr_1 < PyList_GET_SIZE(value); data_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, data_cntr_1), return -1;);
				object->data[data_cntr_1] = PyInt_AsLong(PyList_GET_ITEM(value, data_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_netr_ChallengeResponse_getsetters[] = {
	{ discard_const_p(char, "length"), py_netr_ChallengeResponse_get_length, py_netr_ChallengeResponse_set_length },
	{ discard_const_p(char, "size"), py_netr_ChallengeResponse_get_size, py_netr_ChallengeResponse_set_size },
	{ discard_const_p(char, "data"), py_netr_ChallengeResponse_get_data, py_netr_ChallengeResponse_set_data },
	{ NULL }
};

static PyObject *py_netr_ChallengeResponse_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_ChallengeResponse, type);
}


static PyTypeObject netr_ChallengeResponse_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_ChallengeResponse",
	.tp_getset = py_netr_ChallengeResponse_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_ChallengeResponse_new,
};


static PyObject *py_netr_NetworkInfo_get_identity_info(PyObject *obj, void *closure)
{
	struct netr_NetworkInfo *object = (struct netr_NetworkInfo *)pytalloc_get_ptr(obj);
	PyObject *py_identity_info;
	py_identity_info = pytalloc_reference_ex(&netr_IdentityInfo_Type, pytalloc_get_mem_ctx(obj), &object->identity_info);
	return py_identity_info;
}

static int py_netr_NetworkInfo_set_identity_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NetworkInfo *object = (struct netr_NetworkInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_IdentityInfo_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->identity_info = *(struct netr_IdentityInfo *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_NetworkInfo_get_challenge(PyObject *obj, void *closure)
{
	struct netr_NetworkInfo *object = (struct netr_NetworkInfo *)pytalloc_get_ptr(obj);
	PyObject *py_challenge;
	py_challenge = PyList_New(8);
	if (py_challenge == NULL) {
		return NULL;
	}
	{
		int challenge_cntr_0;
		for (challenge_cntr_0 = 0; challenge_cntr_0 < 8; challenge_cntr_0++) {
			PyObject *py_challenge_0;
			py_challenge_0 = PyInt_FromLong(object->challenge[challenge_cntr_0]);
			PyList_SetItem(py_challenge, challenge_cntr_0, py_challenge_0);
		}
	}
	return py_challenge;
}

static int py_netr_NetworkInfo_set_challenge(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NetworkInfo *object = (struct netr_NetworkInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int challenge_cntr_0;
		for (challenge_cntr_0 = 0; challenge_cntr_0 < PyList_GET_SIZE(value); challenge_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, challenge_cntr_0), return -1;);
			object->challenge[challenge_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, challenge_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_netr_NetworkInfo_get_nt(PyObject *obj, void *closure)
{
	struct netr_NetworkInfo *object = (struct netr_NetworkInfo *)pytalloc_get_ptr(obj);
	PyObject *py_nt;
	py_nt = pytalloc_reference_ex(&netr_ChallengeResponse_Type, pytalloc_get_mem_ctx(obj), &object->nt);
	return py_nt;
}

static int py_netr_NetworkInfo_set_nt(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NetworkInfo *object = (struct netr_NetworkInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_ChallengeResponse_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->nt = *(struct netr_ChallengeResponse *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_NetworkInfo_get_lm(PyObject *obj, void *closure)
{
	struct netr_NetworkInfo *object = (struct netr_NetworkInfo *)pytalloc_get_ptr(obj);
	PyObject *py_lm;
	py_lm = pytalloc_reference_ex(&netr_ChallengeResponse_Type, pytalloc_get_mem_ctx(obj), &object->lm);
	return py_lm;
}

static int py_netr_NetworkInfo_set_lm(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NetworkInfo *object = (struct netr_NetworkInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_ChallengeResponse_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->lm = *(struct netr_ChallengeResponse *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_netr_NetworkInfo_getsetters[] = {
	{ discard_const_p(char, "identity_info"), py_netr_NetworkInfo_get_identity_info, py_netr_NetworkInfo_set_identity_info },
	{ discard_const_p(char, "challenge"), py_netr_NetworkInfo_get_challenge, py_netr_NetworkInfo_set_challenge },
	{ discard_const_p(char, "nt"), py_netr_NetworkInfo_get_nt, py_netr_NetworkInfo_set_nt },
	{ discard_const_p(char, "lm"), py_netr_NetworkInfo_get_lm, py_netr_NetworkInfo_set_lm },
	{ NULL }
};

static PyObject *py_netr_NetworkInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_NetworkInfo, type);
}


static PyTypeObject netr_NetworkInfo_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_NetworkInfo",
	.tp_getset = py_netr_NetworkInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_NetworkInfo_new,
};


static PyObject *py_netr_GenericInfo_get_identity_info(PyObject *obj, void *closure)
{
	struct netr_GenericInfo *object = (struct netr_GenericInfo *)pytalloc_get_ptr(obj);
	PyObject *py_identity_info;
	py_identity_info = pytalloc_reference_ex(&netr_IdentityInfo_Type, pytalloc_get_mem_ctx(obj), &object->identity_info);
	return py_identity_info;
}

static int py_netr_GenericInfo_set_identity_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_GenericInfo *object = (struct netr_GenericInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_IdentityInfo_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->identity_info = *(struct netr_IdentityInfo *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_GenericInfo_get_package_name(PyObject *obj, void *closure)
{
	struct netr_GenericInfo *object = (struct netr_GenericInfo *)pytalloc_get_ptr(obj);
	PyObject *py_package_name;
	py_package_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->package_name);
	return py_package_name;
}

static int py_netr_GenericInfo_set_package_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_GenericInfo *object = (struct netr_GenericInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->package_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_GenericInfo_get_length(PyObject *obj, void *closure)
{
	struct netr_GenericInfo *object = (struct netr_GenericInfo *)pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyInt_FromLong(object->length);
	return py_length;
}

static int py_netr_GenericInfo_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_GenericInfo *object = (struct netr_GenericInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_GenericInfo_get_data(PyObject *obj, void *closure)
{
	struct netr_GenericInfo *object = (struct netr_GenericInfo *)pytalloc_get_ptr(obj);
	PyObject *py_data;
	if (object->data == NULL) {
		py_data = Py_None;
		Py_INCREF(py_data);
	} else {
		py_data = PyList_New(object->length);
		if (py_data == NULL) {
			return NULL;
		}
		{
			int data_cntr_1;
			for (data_cntr_1 = 0; data_cntr_1 < object->length; data_cntr_1++) {
				PyObject *py_data_1;
				py_data_1 = PyInt_FromLong(object->data[data_cntr_1]);
				PyList_SetItem(py_data, data_cntr_1, py_data_1);
			}
		}
	}
	return py_data;
}

static int py_netr_GenericInfo_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_GenericInfo *object = (struct netr_GenericInfo *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->data);
	if (value == Py_None) {
		object->data = NULL;
	} else {
		object->data = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int data_cntr_1;
			object->data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->data, PyList_GET_SIZE(value));
			if (!object->data) { return -1;; }
			talloc_set_name_const(object->data, "ARRAY: object->data");
			for (data_cntr_1 = 0; data_cntr_1 < PyList_GET_SIZE(value); data_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, data_cntr_1), return -1;);
				object->data[data_cntr_1] = PyInt_AsLong(PyList_GET_ITEM(value, data_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_netr_GenericInfo_getsetters[] = {
	{ discard_const_p(char, "identity_info"), py_netr_GenericInfo_get_identity_info, py_netr_GenericInfo_set_identity_info },
	{ discard_const_p(char, "package_name"), py_netr_GenericInfo_get_package_name, py_netr_GenericInfo_set_package_name },
	{ discard_const_p(char, "length"), py_netr_GenericInfo_get_length, py_netr_GenericInfo_set_length },
	{ discard_const_p(char, "data"), py_netr_GenericInfo_get_data, py_netr_GenericInfo_set_data },
	{ NULL }
};

static PyObject *py_netr_GenericInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_GenericInfo, type);
}


static PyTypeObject netr_GenericInfo_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_GenericInfo",
	.tp_getset = py_netr_GenericInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_GenericInfo_new,
};

PyObject *py_import_netr_LogonLevel(TALLOC_CTX *mem_ctx, int level, union netr_LogonLevel *in)
{
	PyObject *ret;

	switch (level) {
		case NetlogonInteractiveInformation:
			if (in->password == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_PasswordInfo_Type, in->password, in->password);
			}
			return ret;

		case NetlogonNetworkInformation:
			if (in->network == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_NetworkInfo_Type, in->network, in->network);
			}
			return ret;

		case NetlogonServiceInformation:
			if (in->password == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_PasswordInfo_Type, in->password, in->password);
			}
			return ret;

		case NetlogonGenericInformation:
			if (in->generic == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_GenericInfo_Type, in->generic, in->generic);
			}
			return ret;

		case NetlogonInteractiveTransitiveInformation:
			if (in->password == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_PasswordInfo_Type, in->password, in->password);
			}
			return ret;

		case NetlogonNetworkTransitiveInformation:
			if (in->network == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_NetworkInfo_Type, in->network, in->network);
			}
			return ret;

		case NetlogonServiceTransitiveInformation:
			if (in->password == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_PasswordInfo_Type, in->password, in->password);
			}
			return ret;

		default:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union netr_LogonLevel *py_export_netr_LogonLevel(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union netr_LogonLevel *ret = talloc_zero(mem_ctx, union netr_LogonLevel);
	switch (level) {
		case NetlogonInteractiveInformation:
			if (in == Py_None) {
				ret->password = NULL;
			} else {
				ret->password = NULL;
				PY_CHECK_TYPE(&netr_PasswordInfo_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->password = (struct netr_PasswordInfo *)pytalloc_get_ptr(in);
			}
			break;

		case NetlogonNetworkInformation:
			if (in == Py_None) {
				ret->network = NULL;
			} else {
				ret->network = NULL;
				PY_CHECK_TYPE(&netr_NetworkInfo_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->network = (struct netr_NetworkInfo *)pytalloc_get_ptr(in);
			}
			break;

		case NetlogonServiceInformation:
			if (in == Py_None) {
				ret->password = NULL;
			} else {
				ret->password = NULL;
				PY_CHECK_TYPE(&netr_PasswordInfo_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->password = (struct netr_PasswordInfo *)pytalloc_get_ptr(in);
			}
			break;

		case NetlogonGenericInformation:
			if (in == Py_None) {
				ret->generic = NULL;
			} else {
				ret->generic = NULL;
				PY_CHECK_TYPE(&netr_GenericInfo_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->generic = (struct netr_GenericInfo *)pytalloc_get_ptr(in);
			}
			break;

		case NetlogonInteractiveTransitiveInformation:
			if (in == Py_None) {
				ret->password = NULL;
			} else {
				ret->password = NULL;
				PY_CHECK_TYPE(&netr_PasswordInfo_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->password = (struct netr_PasswordInfo *)pytalloc_get_ptr(in);
			}
			break;

		case NetlogonNetworkTransitiveInformation:
			if (in == Py_None) {
				ret->network = NULL;
			} else {
				ret->network = NULL;
				PY_CHECK_TYPE(&netr_NetworkInfo_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->network = (struct netr_NetworkInfo *)pytalloc_get_ptr(in);
			}
			break;

		case NetlogonServiceTransitiveInformation:
			if (in == Py_None) {
				ret->password = NULL;
			} else {
				ret->password = NULL;
				PY_CHECK_TYPE(&netr_PasswordInfo_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->password = (struct netr_PasswordInfo *)pytalloc_get_ptr(in);
			}
			break;

		default:
			break;

	}

	return ret;
}


static PyObject *py_netr_UserSessionKey_get_key(PyObject *obj, void *closure)
{
	struct netr_UserSessionKey *object = (struct netr_UserSessionKey *)pytalloc_get_ptr(obj);
	PyObject *py_key;
	py_key = PyList_New(16);
	if (py_key == NULL) {
		return NULL;
	}
	{
		int key_cntr_0;
		for (key_cntr_0 = 0; key_cntr_0 < 16; key_cntr_0++) {
			PyObject *py_key_0;
			py_key_0 = PyInt_FromLong(object->key[key_cntr_0]);
			PyList_SetItem(py_key, key_cntr_0, py_key_0);
		}
	}
	return py_key;
}

static int py_netr_UserSessionKey_set_key(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UserSessionKey *object = (struct netr_UserSessionKey *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int key_cntr_0;
		for (key_cntr_0 = 0; key_cntr_0 < PyList_GET_SIZE(value); key_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, key_cntr_0), return -1;);
			object->key[key_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, key_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_netr_UserSessionKey_getsetters[] = {
	{ discard_const_p(char, "key"), py_netr_UserSessionKey_get_key, py_netr_UserSessionKey_set_key },
	{ NULL }
};

static PyObject *py_netr_UserSessionKey_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_UserSessionKey, type);
}

static PyObject *py_netr_UserSessionKey_ndr_pack(PyObject *py_obj)
{
	struct netr_UserSessionKey *object = (struct netr_UserSessionKey *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_netr_UserSessionKey);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_netr_UserSessionKey_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_UserSessionKey *object = (struct netr_UserSessionKey *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_UserSessionKey);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_UserSessionKey);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_netr_UserSessionKey_ndr_print(PyObject *py_obj)
{
	struct netr_UserSessionKey *object = (struct netr_UserSessionKey *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_UserSessionKey, "netr_UserSessionKey", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_netr_UserSessionKey_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_netr_UserSessionKey_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_netr_UserSessionKey_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_netr_UserSessionKey_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netr_UserSessionKey_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_UserSessionKey",
	.tp_getset = py_netr_UserSessionKey_getsetters,
	.tp_methods = py_netr_UserSessionKey_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_UserSessionKey_new,
};


static PyObject *py_netr_LMSessionKey_get_key(PyObject *obj, void *closure)
{
	struct netr_LMSessionKey *object = (struct netr_LMSessionKey *)pytalloc_get_ptr(obj);
	PyObject *py_key;
	py_key = PyList_New(8);
	if (py_key == NULL) {
		return NULL;
	}
	{
		int key_cntr_0;
		for (key_cntr_0 = 0; key_cntr_0 < 8; key_cntr_0++) {
			PyObject *py_key_0;
			py_key_0 = PyInt_FromLong(object->key[key_cntr_0]);
			PyList_SetItem(py_key, key_cntr_0, py_key_0);
		}
	}
	return py_key;
}

static int py_netr_LMSessionKey_set_key(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_LMSessionKey *object = (struct netr_LMSessionKey *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int key_cntr_0;
		for (key_cntr_0 = 0; key_cntr_0 < PyList_GET_SIZE(value); key_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, key_cntr_0), return -1;);
			object->key[key_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, key_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_netr_LMSessionKey_getsetters[] = {
	{ discard_const_p(char, "key"), py_netr_LMSessionKey_get_key, py_netr_LMSessionKey_set_key },
	{ NULL }
};

static PyObject *py_netr_LMSessionKey_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_LMSessionKey, type);
}

static PyObject *py_netr_LMSessionKey_ndr_pack(PyObject *py_obj)
{
	struct netr_LMSessionKey *object = (struct netr_LMSessionKey *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_netr_LMSessionKey);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_netr_LMSessionKey_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_LMSessionKey *object = (struct netr_LMSessionKey *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_LMSessionKey);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_LMSessionKey);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_netr_LMSessionKey_ndr_print(PyObject *py_obj)
{
	struct netr_LMSessionKey *object = (struct netr_LMSessionKey *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_LMSessionKey, "netr_LMSessionKey", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_netr_LMSessionKey_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_netr_LMSessionKey_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_netr_LMSessionKey_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_netr_LMSessionKey_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netr_LMSessionKey_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_LMSessionKey",
	.tp_getset = py_netr_LMSessionKey_getsetters,
	.tp_methods = py_netr_LMSessionKey_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_LMSessionKey_new,
};


static PyObject *py_netr_SamBaseInfo_get_logon_time(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(obj);
	PyObject *py_logon_time;
	py_logon_time = PyLong_FromLongLong(object->logon_time);
	return py_logon_time;
}

static int py_netr_SamBaseInfo_set_logon_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->logon_time = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->logon_time = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_logoff_time(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(obj);
	PyObject *py_logoff_time;
	py_logoff_time = PyLong_FromLongLong(object->logoff_time);
	return py_logoff_time;
}

static int py_netr_SamBaseInfo_set_logoff_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->logoff_time = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->logoff_time = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_kickoff_time(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(obj);
	PyObject *py_kickoff_time;
	py_kickoff_time = PyLong_FromLongLong(object->kickoff_time);
	return py_kickoff_time;
}

static int py_netr_SamBaseInfo_set_kickoff_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->kickoff_time = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->kickoff_time = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_last_password_change(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(obj);
	PyObject *py_last_password_change;
	py_last_password_change = PyLong_FromLongLong(object->last_password_change);
	return py_last_password_change;
}

static int py_netr_SamBaseInfo_set_last_password_change(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->last_password_change = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->last_password_change = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_allow_password_change(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(obj);
	PyObject *py_allow_password_change;
	py_allow_password_change = PyLong_FromLongLong(object->allow_password_change);
	return py_allow_password_change;
}

static int py_netr_SamBaseInfo_set_allow_password_change(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->allow_password_change = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->allow_password_change = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_force_password_change(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(obj);
	PyObject *py_force_password_change;
	py_force_password_change = PyLong_FromLongLong(object->force_password_change);
	return py_force_password_change;
}

static int py_netr_SamBaseInfo_set_force_password_change(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->force_password_change = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->force_password_change = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_account_name(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(obj);
	PyObject *py_account_name;
	py_account_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->account_name);
	return py_account_name;
}

static int py_netr_SamBaseInfo_set_account_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->account_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_full_name(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(obj);
	PyObject *py_full_name;
	py_full_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->full_name);
	return py_full_name;
}

static int py_netr_SamBaseInfo_set_full_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->full_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_logon_script(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(obj);
	PyObject *py_logon_script;
	py_logon_script = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->logon_script);
	return py_logon_script;
}

static int py_netr_SamBaseInfo_set_logon_script(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->logon_script = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_profile_path(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(obj);
	PyObject *py_profile_path;
	py_profile_path = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->profile_path);
	return py_profile_path;
}

static int py_netr_SamBaseInfo_set_profile_path(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->profile_path = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_home_directory(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(obj);
	PyObject *py_home_directory;
	py_home_directory = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->home_directory);
	return py_home_directory;
}

static int py_netr_SamBaseInfo_set_home_directory(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->home_directory = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_home_drive(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(obj);
	PyObject *py_home_drive;
	py_home_drive = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->home_drive);
	return py_home_drive;
}

static int py_netr_SamBaseInfo_set_home_drive(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->home_drive = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_logon_count(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(obj);
	PyObject *py_logon_count;
	py_logon_count = PyInt_FromLong(object->logon_count);
	return py_logon_count;
}

static int py_netr_SamBaseInfo_set_logon_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->logon_count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_bad_password_count(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(obj);
	PyObject *py_bad_password_count;
	py_bad_password_count = PyInt_FromLong(object->bad_password_count);
	return py_bad_password_count;
}

static int py_netr_SamBaseInfo_set_bad_password_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->bad_password_count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_rid(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(obj);
	PyObject *py_rid;
	py_rid = PyInt_FromLong(object->rid);
	return py_rid;
}

static int py_netr_SamBaseInfo_set_rid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->rid = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_primary_gid(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(obj);
	PyObject *py_primary_gid;
	py_primary_gid = PyInt_FromLong(object->primary_gid);
	return py_primary_gid;
}

static int py_netr_SamBaseInfo_set_primary_gid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->primary_gid = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_groups(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(obj);
	PyObject *py_groups;
	py_groups = pytalloc_reference_ex(samr_RidWithAttributeArray_Type, pytalloc_get_mem_ctx(obj), &object->groups);
	return py_groups;
}

static int py_netr_SamBaseInfo_set_groups(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(samr_RidWithAttributeArray_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->groups = *(struct samr_RidWithAttributeArray *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_user_flags(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(obj);
	PyObject *py_user_flags;
	py_user_flags = PyInt_FromLong(object->user_flags);
	return py_user_flags;
}

static int py_netr_SamBaseInfo_set_user_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->user_flags = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->user_flags = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_key(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(obj);
	PyObject *py_key;
	py_key = pytalloc_reference_ex(&netr_UserSessionKey_Type, pytalloc_get_mem_ctx(obj), &object->key);
	return py_key;
}

static int py_netr_SamBaseInfo_set_key(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_UserSessionKey_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->key = *(struct netr_UserSessionKey *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_logon_server(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(obj);
	PyObject *py_logon_server;
	py_logon_server = pytalloc_reference_ex(lsa_StringLarge_Type, pytalloc_get_mem_ctx(obj), &object->logon_server);
	return py_logon_server;
}

static int py_netr_SamBaseInfo_set_logon_server(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_StringLarge_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->logon_server = *(struct lsa_StringLarge *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_logon_domain(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(obj);
	PyObject *py_logon_domain;
	py_logon_domain = pytalloc_reference_ex(lsa_StringLarge_Type, pytalloc_get_mem_ctx(obj), &object->logon_domain);
	return py_logon_domain;
}

static int py_netr_SamBaseInfo_set_logon_domain(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_StringLarge_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->logon_domain = *(struct lsa_StringLarge *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_domain_sid(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(obj);
	PyObject *py_domain_sid;
	if (object->domain_sid == NULL) {
		py_domain_sid = Py_None;
		Py_INCREF(py_domain_sid);
	} else {
		py_domain_sid = pytalloc_reference_ex(dom_sid_Type, object->domain_sid, object->domain_sid);
	}
	return py_domain_sid;
}

static int py_netr_SamBaseInfo_set_domain_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->domain_sid);
	if (value == Py_None) {
		object->domain_sid = NULL;
	} else {
		object->domain_sid = NULL;
		PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->domain_sid = (struct dom_sid *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_LMSessKey(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(obj);
	PyObject *py_LMSessKey;
	py_LMSessKey = pytalloc_reference_ex(&netr_LMSessionKey_Type, pytalloc_get_mem_ctx(obj), &object->LMSessKey);
	return py_LMSessKey;
}

static int py_netr_SamBaseInfo_set_LMSessKey(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_LMSessionKey_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->LMSessKey = *(struct netr_LMSessionKey *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_acct_flags(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(obj);
	PyObject *py_acct_flags;
	py_acct_flags = PyInt_FromLong(object->acct_flags);
	return py_acct_flags;
}

static int py_netr_SamBaseInfo_set_acct_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->acct_flags = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->acct_flags = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_sub_auth_status(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(obj);
	PyObject *py_sub_auth_status;
	py_sub_auth_status = PyInt_FromLong(object->sub_auth_status);
	return py_sub_auth_status;
}

static int py_netr_SamBaseInfo_set_sub_auth_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->sub_auth_status = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_last_successful_logon(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(obj);
	PyObject *py_last_successful_logon;
	py_last_successful_logon = PyLong_FromLongLong(object->last_successful_logon);
	return py_last_successful_logon;
}

static int py_netr_SamBaseInfo_set_last_successful_logon(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->last_successful_logon = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->last_successful_logon = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_last_failed_logon(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(obj);
	PyObject *py_last_failed_logon;
	py_last_failed_logon = PyLong_FromLongLong(object->last_failed_logon);
	return py_last_failed_logon;
}

static int py_netr_SamBaseInfo_set_last_failed_logon(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->last_failed_logon = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->last_failed_logon = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_failed_logon_count(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(obj);
	PyObject *py_failed_logon_count;
	py_failed_logon_count = PyInt_FromLong(object->failed_logon_count);
	return py_failed_logon_count;
}

static int py_netr_SamBaseInfo_set_failed_logon_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->failed_logon_count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_SamBaseInfo_get_reserved(PyObject *obj, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(obj);
	PyObject *py_reserved;
	py_reserved = PyInt_FromLong(object->reserved);
	return py_reserved;
}

static int py_netr_SamBaseInfo_set_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamBaseInfo *object = (struct netr_SamBaseInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->reserved = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_SamBaseInfo_getsetters[] = {
	{ discard_const_p(char, "logon_time"), py_netr_SamBaseInfo_get_logon_time, py_netr_SamBaseInfo_set_logon_time },
	{ discard_const_p(char, "logoff_time"), py_netr_SamBaseInfo_get_logoff_time, py_netr_SamBaseInfo_set_logoff_time },
	{ discard_const_p(char, "kickoff_time"), py_netr_SamBaseInfo_get_kickoff_time, py_netr_SamBaseInfo_set_kickoff_time },
	{ discard_const_p(char, "last_password_change"), py_netr_SamBaseInfo_get_last_password_change, py_netr_SamBaseInfo_set_last_password_change },
	{ discard_const_p(char, "allow_password_change"), py_netr_SamBaseInfo_get_allow_password_change, py_netr_SamBaseInfo_set_allow_password_change },
	{ discard_const_p(char, "force_password_change"), py_netr_SamBaseInfo_get_force_password_change, py_netr_SamBaseInfo_set_force_password_change },
	{ discard_const_p(char, "account_name"), py_netr_SamBaseInfo_get_account_name, py_netr_SamBaseInfo_set_account_name },
	{ discard_const_p(char, "full_name"), py_netr_SamBaseInfo_get_full_name, py_netr_SamBaseInfo_set_full_name },
	{ discard_const_p(char, "logon_script"), py_netr_SamBaseInfo_get_logon_script, py_netr_SamBaseInfo_set_logon_script },
	{ discard_const_p(char, "profile_path"), py_netr_SamBaseInfo_get_profile_path, py_netr_SamBaseInfo_set_profile_path },
	{ discard_const_p(char, "home_directory"), py_netr_SamBaseInfo_get_home_directory, py_netr_SamBaseInfo_set_home_directory },
	{ discard_const_p(char, "home_drive"), py_netr_SamBaseInfo_get_home_drive, py_netr_SamBaseInfo_set_home_drive },
	{ discard_const_p(char, "logon_count"), py_netr_SamBaseInfo_get_logon_count, py_netr_SamBaseInfo_set_logon_count },
	{ discard_const_p(char, "bad_password_count"), py_netr_SamBaseInfo_get_bad_password_count, py_netr_SamBaseInfo_set_bad_password_count },
	{ discard_const_p(char, "rid"), py_netr_SamBaseInfo_get_rid, py_netr_SamBaseInfo_set_rid },
	{ discard_const_p(char, "primary_gid"), py_netr_SamBaseInfo_get_primary_gid, py_netr_SamBaseInfo_set_primary_gid },
	{ discard_const_p(char, "groups"), py_netr_SamBaseInfo_get_groups, py_netr_SamBaseInfo_set_groups },
	{ discard_const_p(char, "user_flags"), py_netr_SamBaseInfo_get_user_flags, py_netr_SamBaseInfo_set_user_flags },
	{ discard_const_p(char, "key"), py_netr_SamBaseInfo_get_key, py_netr_SamBaseInfo_set_key },
	{ discard_const_p(char, "logon_server"), py_netr_SamBaseInfo_get_logon_server, py_netr_SamBaseInfo_set_logon_server },
	{ discard_const_p(char, "logon_domain"), py_netr_SamBaseInfo_get_logon_domain, py_netr_SamBaseInfo_set_logon_domain },
	{ discard_const_p(char, "domain_sid"), py_netr_SamBaseInfo_get_domain_sid, py_netr_SamBaseInfo_set_domain_sid },
	{ discard_const_p(char, "LMSessKey"), py_netr_SamBaseInfo_get_LMSessKey, py_netr_SamBaseInfo_set_LMSessKey },
	{ discard_const_p(char, "acct_flags"), py_netr_SamBaseInfo_get_acct_flags, py_netr_SamBaseInfo_set_acct_flags },
	{ discard_const_p(char, "sub_auth_status"), py_netr_SamBaseInfo_get_sub_auth_status, py_netr_SamBaseInfo_set_sub_auth_status },
	{ discard_const_p(char, "last_successful_logon"), py_netr_SamBaseInfo_get_last_successful_logon, py_netr_SamBaseInfo_set_last_successful_logon },
	{ discard_const_p(char, "last_failed_logon"), py_netr_SamBaseInfo_get_last_failed_logon, py_netr_SamBaseInfo_set_last_failed_logon },
	{ discard_const_p(char, "failed_logon_count"), py_netr_SamBaseInfo_get_failed_logon_count, py_netr_SamBaseInfo_set_failed_logon_count },
	{ discard_const_p(char, "reserved"), py_netr_SamBaseInfo_get_reserved, py_netr_SamBaseInfo_set_reserved },
	{ NULL }
};

static PyObject *py_netr_SamBaseInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_SamBaseInfo, type);
}


static PyTypeObject netr_SamBaseInfo_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_SamBaseInfo",
	.tp_getset = py_netr_SamBaseInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_SamBaseInfo_new,
};


static PyObject *py_netr_SamInfo2_get_base(PyObject *obj, void *closure)
{
	struct netr_SamInfo2 *object = (struct netr_SamInfo2 *)pytalloc_get_ptr(obj);
	PyObject *py_base;
	py_base = pytalloc_reference_ex(&netr_SamBaseInfo_Type, pytalloc_get_mem_ctx(obj), &object->base);
	return py_base;
}

static int py_netr_SamInfo2_set_base(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamInfo2 *object = (struct netr_SamInfo2 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_SamBaseInfo_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->base = *(struct netr_SamBaseInfo *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_netr_SamInfo2_getsetters[] = {
	{ discard_const_p(char, "base"), py_netr_SamInfo2_get_base, py_netr_SamInfo2_set_base },
	{ NULL }
};

static PyObject *py_netr_SamInfo2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_SamInfo2, type);
}


static PyTypeObject netr_SamInfo2_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_SamInfo2",
	.tp_getset = py_netr_SamInfo2_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_SamInfo2_new,
};


static PyObject *py_netr_SidAttr_get_sid(PyObject *obj, void *closure)
{
	struct netr_SidAttr *object = (struct netr_SidAttr *)pytalloc_get_ptr(obj);
	PyObject *py_sid;
	if (object->sid == NULL) {
		py_sid = Py_None;
		Py_INCREF(py_sid);
	} else {
		py_sid = pytalloc_reference_ex(dom_sid_Type, object->sid, object->sid);
	}
	return py_sid;
}

static int py_netr_SidAttr_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SidAttr *object = (struct netr_SidAttr *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->sid);
	if (value == Py_None) {
		object->sid = NULL;
	} else {
		object->sid = NULL;
		PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->sid = (struct dom_sid *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_netr_SidAttr_get_attributes(PyObject *obj, void *closure)
{
	struct netr_SidAttr *object = (struct netr_SidAttr *)pytalloc_get_ptr(obj);
	PyObject *py_attributes;
	py_attributes = PyInt_FromLong(object->attributes);
	return py_attributes;
}

static int py_netr_SidAttr_set_attributes(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SidAttr *object = (struct netr_SidAttr *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->attributes = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->attributes = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyGetSetDef py_netr_SidAttr_getsetters[] = {
	{ discard_const_p(char, "sid"), py_netr_SidAttr_get_sid, py_netr_SidAttr_set_sid },
	{ discard_const_p(char, "attributes"), py_netr_SidAttr_get_attributes, py_netr_SidAttr_set_attributes },
	{ NULL }
};

static PyObject *py_netr_SidAttr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_SidAttr, type);
}


static PyTypeObject netr_SidAttr_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_SidAttr",
	.tp_getset = py_netr_SidAttr_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_SidAttr_new,
};


static PyObject *py_netr_SamInfo3_get_base(PyObject *obj, void *closure)
{
	struct netr_SamInfo3 *object = (struct netr_SamInfo3 *)pytalloc_get_ptr(obj);
	PyObject *py_base;
	py_base = pytalloc_reference_ex(&netr_SamBaseInfo_Type, pytalloc_get_mem_ctx(obj), &object->base);
	return py_base;
}

static int py_netr_SamInfo3_set_base(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamInfo3 *object = (struct netr_SamInfo3 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_SamBaseInfo_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->base = *(struct netr_SamBaseInfo *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_SamInfo3_get_sidcount(PyObject *obj, void *closure)
{
	struct netr_SamInfo3 *object = (struct netr_SamInfo3 *)pytalloc_get_ptr(obj);
	PyObject *py_sidcount;
	py_sidcount = PyInt_FromLong(object->sidcount);
	return py_sidcount;
}

static int py_netr_SamInfo3_set_sidcount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamInfo3 *object = (struct netr_SamInfo3 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->sidcount = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_SamInfo3_get_sids(PyObject *obj, void *closure)
{
	struct netr_SamInfo3 *object = (struct netr_SamInfo3 *)pytalloc_get_ptr(obj);
	PyObject *py_sids;
	if (object->sids == NULL) {
		py_sids = Py_None;
		Py_INCREF(py_sids);
	} else {
		py_sids = PyList_New(object->sidcount);
		if (py_sids == NULL) {
			return NULL;
		}
		{
			int sids_cntr_1;
			for (sids_cntr_1 = 0; sids_cntr_1 < object->sidcount; sids_cntr_1++) {
				PyObject *py_sids_1;
				py_sids_1 = pytalloc_reference_ex(&netr_SidAttr_Type, object->sids, &object->sids[sids_cntr_1]);
				PyList_SetItem(py_sids, sids_cntr_1, py_sids_1);
			}
		}
	}
	return py_sids;
}

static int py_netr_SamInfo3_set_sids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamInfo3 *object = (struct netr_SamInfo3 *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->sids);
	if (value == Py_None) {
		object->sids = NULL;
	} else {
		object->sids = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int sids_cntr_1;
			object->sids = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->sids, PyList_GET_SIZE(value));
			if (!object->sids) { return -1;; }
			talloc_set_name_const(object->sids, "ARRAY: object->sids");
			for (sids_cntr_1 = 0; sids_cntr_1 < PyList_GET_SIZE(value); sids_cntr_1++) {
				PY_CHECK_TYPE(&netr_SidAttr_Type, PyList_GET_ITEM(value, sids_cntr_1), return -1;);
				if (talloc_reference(object->sids, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, sids_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				object->sids[sids_cntr_1] = *(struct netr_SidAttr *)pytalloc_get_ptr(PyList_GET_ITEM(value, sids_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_netr_SamInfo3_getsetters[] = {
	{ discard_const_p(char, "base"), py_netr_SamInfo3_get_base, py_netr_SamInfo3_set_base },
	{ discard_const_p(char, "sidcount"), py_netr_SamInfo3_get_sidcount, py_netr_SamInfo3_set_sidcount },
	{ discard_const_p(char, "sids"), py_netr_SamInfo3_get_sids, py_netr_SamInfo3_set_sids },
	{ NULL }
};

static PyObject *py_netr_SamInfo3_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_SamInfo3, type);
}

static PyObject *py_netr_SamInfo3_ndr_pack(PyObject *py_obj)
{
	struct netr_SamInfo3 *object = (struct netr_SamInfo3 *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_netr_SamInfo3);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_netr_SamInfo3_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_SamInfo3 *object = (struct netr_SamInfo3 *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_SamInfo3);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_SamInfo3);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_netr_SamInfo3_ndr_print(PyObject *py_obj)
{
	struct netr_SamInfo3 *object = (struct netr_SamInfo3 *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_SamInfo3, "netr_SamInfo3", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_netr_SamInfo3_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_netr_SamInfo3_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_netr_SamInfo3_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_netr_SamInfo3_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netr_SamInfo3_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_SamInfo3",
	.tp_getset = py_netr_SamInfo3_getsetters,
	.tp_methods = py_netr_SamInfo3_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_SamInfo3_new,
};


static PyObject *py_netr_SamInfo6_get_base(PyObject *obj, void *closure)
{
	struct netr_SamInfo6 *object = (struct netr_SamInfo6 *)pytalloc_get_ptr(obj);
	PyObject *py_base;
	py_base = pytalloc_reference_ex(&netr_SamBaseInfo_Type, pytalloc_get_mem_ctx(obj), &object->base);
	return py_base;
}

static int py_netr_SamInfo6_set_base(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamInfo6 *object = (struct netr_SamInfo6 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_SamBaseInfo_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->base = *(struct netr_SamBaseInfo *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_SamInfo6_get_sidcount(PyObject *obj, void *closure)
{
	struct netr_SamInfo6 *object = (struct netr_SamInfo6 *)pytalloc_get_ptr(obj);
	PyObject *py_sidcount;
	py_sidcount = PyInt_FromLong(object->sidcount);
	return py_sidcount;
}

static int py_netr_SamInfo6_set_sidcount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamInfo6 *object = (struct netr_SamInfo6 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->sidcount = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_SamInfo6_get_sids(PyObject *obj, void *closure)
{
	struct netr_SamInfo6 *object = (struct netr_SamInfo6 *)pytalloc_get_ptr(obj);
	PyObject *py_sids;
	if (object->sids == NULL) {
		py_sids = Py_None;
		Py_INCREF(py_sids);
	} else {
		py_sids = PyList_New(object->sidcount);
		if (py_sids == NULL) {
			return NULL;
		}
		{
			int sids_cntr_1;
			for (sids_cntr_1 = 0; sids_cntr_1 < object->sidcount; sids_cntr_1++) {
				PyObject *py_sids_1;
				py_sids_1 = pytalloc_reference_ex(&netr_SidAttr_Type, object->sids, &object->sids[sids_cntr_1]);
				PyList_SetItem(py_sids, sids_cntr_1, py_sids_1);
			}
		}
	}
	return py_sids;
}

static int py_netr_SamInfo6_set_sids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamInfo6 *object = (struct netr_SamInfo6 *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->sids);
	if (value == Py_None) {
		object->sids = NULL;
	} else {
		object->sids = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int sids_cntr_1;
			object->sids = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->sids, PyList_GET_SIZE(value));
			if (!object->sids) { return -1;; }
			talloc_set_name_const(object->sids, "ARRAY: object->sids");
			for (sids_cntr_1 = 0; sids_cntr_1 < PyList_GET_SIZE(value); sids_cntr_1++) {
				PY_CHECK_TYPE(&netr_SidAttr_Type, PyList_GET_ITEM(value, sids_cntr_1), return -1;);
				if (talloc_reference(object->sids, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, sids_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				object->sids[sids_cntr_1] = *(struct netr_SidAttr *)pytalloc_get_ptr(PyList_GET_ITEM(value, sids_cntr_1));
			}
		}
	}
	return 0;
}

static PyObject *py_netr_SamInfo6_get_dns_domainname(PyObject *obj, void *closure)
{
	struct netr_SamInfo6 *object = (struct netr_SamInfo6 *)pytalloc_get_ptr(obj);
	PyObject *py_dns_domainname;
	py_dns_domainname = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->dns_domainname);
	return py_dns_domainname;
}

static int py_netr_SamInfo6_set_dns_domainname(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamInfo6 *object = (struct netr_SamInfo6 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->dns_domainname = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_SamInfo6_get_principle(PyObject *obj, void *closure)
{
	struct netr_SamInfo6 *object = (struct netr_SamInfo6 *)pytalloc_get_ptr(obj);
	PyObject *py_principle;
	py_principle = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->principle);
	return py_principle;
}

static int py_netr_SamInfo6_set_principle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamInfo6 *object = (struct netr_SamInfo6 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->principle = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_SamInfo6_get_unknown4(PyObject *obj, void *closure)
{
	struct netr_SamInfo6 *object = (struct netr_SamInfo6 *)pytalloc_get_ptr(obj);
	PyObject *py_unknown4;
	py_unknown4 = PyList_New(20);
	if (py_unknown4 == NULL) {
		return NULL;
	}
	{
		int unknown4_cntr_0;
		for (unknown4_cntr_0 = 0; unknown4_cntr_0 < 20; unknown4_cntr_0++) {
			PyObject *py_unknown4_0;
			py_unknown4_0 = PyInt_FromLong(object->unknown4[unknown4_cntr_0]);
			PyList_SetItem(py_unknown4, unknown4_cntr_0, py_unknown4_0);
		}
	}
	return py_unknown4;
}

static int py_netr_SamInfo6_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_SamInfo6 *object = (struct netr_SamInfo6 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int unknown4_cntr_0;
		for (unknown4_cntr_0 = 0; unknown4_cntr_0 < PyList_GET_SIZE(value); unknown4_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, unknown4_cntr_0), return -1;);
			object->unknown4[unknown4_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, unknown4_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_netr_SamInfo6_getsetters[] = {
	{ discard_const_p(char, "base"), py_netr_SamInfo6_get_base, py_netr_SamInfo6_set_base },
	{ discard_const_p(char, "sidcount"), py_netr_SamInfo6_get_sidcount, py_netr_SamInfo6_set_sidcount },
	{ discard_const_p(char, "sids"), py_netr_SamInfo6_get_sids, py_netr_SamInfo6_set_sids },
	{ discard_const_p(char, "dns_domainname"), py_netr_SamInfo6_get_dns_domainname, py_netr_SamInfo6_set_dns_domainname },
	{ discard_const_p(char, "principle"), py_netr_SamInfo6_get_principle, py_netr_SamInfo6_set_principle },
	{ discard_const_p(char, "unknown4"), py_netr_SamInfo6_get_unknown4, py_netr_SamInfo6_set_unknown4 },
	{ NULL }
};

static PyObject *py_netr_SamInfo6_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_SamInfo6, type);
}


static PyTypeObject netr_SamInfo6_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_SamInfo6",
	.tp_getset = py_netr_SamInfo6_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_SamInfo6_new,
};


static PyObject *py_netr_PacInfo_get_pac_size(PyObject *obj, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)pytalloc_get_ptr(obj);
	PyObject *py_pac_size;
	py_pac_size = PyInt_FromLong(object->pac_size);
	return py_pac_size;
}

static int py_netr_PacInfo_set_pac_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->pac_size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_PacInfo_get_pac(PyObject *obj, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)pytalloc_get_ptr(obj);
	PyObject *py_pac;
	if (object->pac == NULL) {
		py_pac = Py_None;
		Py_INCREF(py_pac);
	} else {
		py_pac = PyList_New(object->pac_size);
		if (py_pac == NULL) {
			return NULL;
		}
		{
			int pac_cntr_1;
			for (pac_cntr_1 = 0; pac_cntr_1 < object->pac_size; pac_cntr_1++) {
				PyObject *py_pac_1;
				py_pac_1 = PyInt_FromLong(object->pac[pac_cntr_1]);
				PyList_SetItem(py_pac, pac_cntr_1, py_pac_1);
			}
		}
	}
	return py_pac;
}

static int py_netr_PacInfo_set_pac(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->pac);
	if (value == Py_None) {
		object->pac = NULL;
	} else {
		object->pac = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int pac_cntr_1;
			object->pac = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->pac, PyList_GET_SIZE(value));
			if (!object->pac) { return -1;; }
			talloc_set_name_const(object->pac, "ARRAY: object->pac");
			for (pac_cntr_1 = 0; pac_cntr_1 < PyList_GET_SIZE(value); pac_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, pac_cntr_1), return -1;);
				object->pac[pac_cntr_1] = PyInt_AsLong(PyList_GET_ITEM(value, pac_cntr_1));
			}
		}
	}
	return 0;
}

static PyObject *py_netr_PacInfo_get_logon_domain(PyObject *obj, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)pytalloc_get_ptr(obj);
	PyObject *py_logon_domain;
	py_logon_domain = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->logon_domain);
	return py_logon_domain;
}

static int py_netr_PacInfo_set_logon_domain(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->logon_domain = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_PacInfo_get_logon_server(PyObject *obj, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)pytalloc_get_ptr(obj);
	PyObject *py_logon_server;
	py_logon_server = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->logon_server);
	return py_logon_server;
}

static int py_netr_PacInfo_set_logon_server(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->logon_server = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_PacInfo_get_principal_name(PyObject *obj, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)pytalloc_get_ptr(obj);
	PyObject *py_principal_name;
	py_principal_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->principal_name);
	return py_principal_name;
}

static int py_netr_PacInfo_set_principal_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->principal_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_PacInfo_get_auth_size(PyObject *obj, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)pytalloc_get_ptr(obj);
	PyObject *py_auth_size;
	py_auth_size = PyInt_FromLong(object->auth_size);
	return py_auth_size;
}

static int py_netr_PacInfo_set_auth_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->auth_size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_PacInfo_get_auth(PyObject *obj, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)pytalloc_get_ptr(obj);
	PyObject *py_auth;
	if (object->auth == NULL) {
		py_auth = Py_None;
		Py_INCREF(py_auth);
	} else {
		py_auth = PyList_New(object->auth_size);
		if (py_auth == NULL) {
			return NULL;
		}
		{
			int auth_cntr_1;
			for (auth_cntr_1 = 0; auth_cntr_1 < object->auth_size; auth_cntr_1++) {
				PyObject *py_auth_1;
				py_auth_1 = PyInt_FromLong(object->auth[auth_cntr_1]);
				PyList_SetItem(py_auth, auth_cntr_1, py_auth_1);
			}
		}
	}
	return py_auth;
}

static int py_netr_PacInfo_set_auth(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->auth);
	if (value == Py_None) {
		object->auth = NULL;
	} else {
		object->auth = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int auth_cntr_1;
			object->auth = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->auth, PyList_GET_SIZE(value));
			if (!object->auth) { return -1;; }
			talloc_set_name_const(object->auth, "ARRAY: object->auth");
			for (auth_cntr_1 = 0; auth_cntr_1 < PyList_GET_SIZE(value); auth_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, auth_cntr_1), return -1;);
				object->auth[auth_cntr_1] = PyInt_AsLong(PyList_GET_ITEM(value, auth_cntr_1));
			}
		}
	}
	return 0;
}

static PyObject *py_netr_PacInfo_get_user_session_key(PyObject *obj, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)pytalloc_get_ptr(obj);
	PyObject *py_user_session_key;
	py_user_session_key = pytalloc_reference_ex(&netr_UserSessionKey_Type, pytalloc_get_mem_ctx(obj), &object->user_session_key);
	return py_user_session_key;
}

static int py_netr_PacInfo_set_user_session_key(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_UserSessionKey_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->user_session_key = *(struct netr_UserSessionKey *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_PacInfo_get_expansionroom(PyObject *obj, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)pytalloc_get_ptr(obj);
	PyObject *py_expansionroom;
	py_expansionroom = PyList_New(10);
	if (py_expansionroom == NULL) {
		return NULL;
	}
	{
		int expansionroom_cntr_0;
		for (expansionroom_cntr_0 = 0; expansionroom_cntr_0 < 10; expansionroom_cntr_0++) {
			PyObject *py_expansionroom_0;
			py_expansionroom_0 = PyInt_FromLong(object->expansionroom[expansionroom_cntr_0]);
			PyList_SetItem(py_expansionroom, expansionroom_cntr_0, py_expansionroom_0);
		}
	}
	return py_expansionroom;
}

static int py_netr_PacInfo_set_expansionroom(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int expansionroom_cntr_0;
		for (expansionroom_cntr_0 = 0; expansionroom_cntr_0 < PyList_GET_SIZE(value); expansionroom_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, expansionroom_cntr_0), return -1;);
			object->expansionroom[expansionroom_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, expansionroom_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_netr_PacInfo_get_unknown1(PyObject *obj, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)pytalloc_get_ptr(obj);
	PyObject *py_unknown1;
	py_unknown1 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown1);
	return py_unknown1;
}

static int py_netr_PacInfo_set_unknown1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown1 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_PacInfo_get_unknown2(PyObject *obj, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)pytalloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown2);
	return py_unknown2;
}

static int py_netr_PacInfo_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown2 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_PacInfo_get_unknown3(PyObject *obj, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)pytalloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown3);
	return py_unknown3;
}

static int py_netr_PacInfo_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown3 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_PacInfo_get_unknown4(PyObject *obj, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)pytalloc_get_ptr(obj);
	PyObject *py_unknown4;
	py_unknown4 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown4);
	return py_unknown4;
}

static int py_netr_PacInfo_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PacInfo *object = (struct netr_PacInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown4 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_netr_PacInfo_getsetters[] = {
	{ discard_const_p(char, "pac_size"), py_netr_PacInfo_get_pac_size, py_netr_PacInfo_set_pac_size },
	{ discard_const_p(char, "pac"), py_netr_PacInfo_get_pac, py_netr_PacInfo_set_pac },
	{ discard_const_p(char, "logon_domain"), py_netr_PacInfo_get_logon_domain, py_netr_PacInfo_set_logon_domain },
	{ discard_const_p(char, "logon_server"), py_netr_PacInfo_get_logon_server, py_netr_PacInfo_set_logon_server },
	{ discard_const_p(char, "principal_name"), py_netr_PacInfo_get_principal_name, py_netr_PacInfo_set_principal_name },
	{ discard_const_p(char, "auth_size"), py_netr_PacInfo_get_auth_size, py_netr_PacInfo_set_auth_size },
	{ discard_const_p(char, "auth"), py_netr_PacInfo_get_auth, py_netr_PacInfo_set_auth },
	{ discard_const_p(char, "user_session_key"), py_netr_PacInfo_get_user_session_key, py_netr_PacInfo_set_user_session_key },
	{ discard_const_p(char, "expansionroom"), py_netr_PacInfo_get_expansionroom, py_netr_PacInfo_set_expansionroom },
	{ discard_const_p(char, "unknown1"), py_netr_PacInfo_get_unknown1, py_netr_PacInfo_set_unknown1 },
	{ discard_const_p(char, "unknown2"), py_netr_PacInfo_get_unknown2, py_netr_PacInfo_set_unknown2 },
	{ discard_const_p(char, "unknown3"), py_netr_PacInfo_get_unknown3, py_netr_PacInfo_set_unknown3 },
	{ discard_const_p(char, "unknown4"), py_netr_PacInfo_get_unknown4, py_netr_PacInfo_set_unknown4 },
	{ NULL }
};

static PyObject *py_netr_PacInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_PacInfo, type);
}


static PyTypeObject netr_PacInfo_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_PacInfo",
	.tp_getset = py_netr_PacInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_PacInfo_new,
};


static PyObject *py_netr_GenericInfo2_get_length(PyObject *obj, void *closure)
{
	struct netr_GenericInfo2 *object = (struct netr_GenericInfo2 *)pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyInt_FromLong(object->length);
	return py_length;
}

static int py_netr_GenericInfo2_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_GenericInfo2 *object = (struct netr_GenericInfo2 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_GenericInfo2_get_data(PyObject *obj, void *closure)
{
	struct netr_GenericInfo2 *object = (struct netr_GenericInfo2 *)pytalloc_get_ptr(obj);
	PyObject *py_data;
	if (object->data == NULL) {
		py_data = Py_None;
		Py_INCREF(py_data);
	} else {
		py_data = PyList_New(object->length);
		if (py_data == NULL) {
			return NULL;
		}
		{
			int data_cntr_1;
			for (data_cntr_1 = 0; data_cntr_1 < object->length; data_cntr_1++) {
				PyObject *py_data_1;
				py_data_1 = PyInt_FromLong(object->data[data_cntr_1]);
				PyList_SetItem(py_data, data_cntr_1, py_data_1);
			}
		}
	}
	return py_data;
}

static int py_netr_GenericInfo2_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_GenericInfo2 *object = (struct netr_GenericInfo2 *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->data);
	if (value == Py_None) {
		object->data = NULL;
	} else {
		object->data = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int data_cntr_1;
			object->data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->data, PyList_GET_SIZE(value));
			if (!object->data) { return -1;; }
			talloc_set_name_const(object->data, "ARRAY: object->data");
			for (data_cntr_1 = 0; data_cntr_1 < PyList_GET_SIZE(value); data_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, data_cntr_1), return -1;);
				object->data[data_cntr_1] = PyInt_AsLong(PyList_GET_ITEM(value, data_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_netr_GenericInfo2_getsetters[] = {
	{ discard_const_p(char, "length"), py_netr_GenericInfo2_get_length, py_netr_GenericInfo2_set_length },
	{ discard_const_p(char, "data"), py_netr_GenericInfo2_get_data, py_netr_GenericInfo2_set_data },
	{ NULL }
};

static PyObject *py_netr_GenericInfo2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_GenericInfo2, type);
}


static PyTypeObject netr_GenericInfo2_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_GenericInfo2",
	.tp_getset = py_netr_GenericInfo2_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_GenericInfo2_new,
};

PyObject *py_import_netr_Validation(TALLOC_CTX *mem_ctx, int level, union netr_Validation *in)
{
	PyObject *ret;

	switch (level) {
		case NetlogonValidationSamInfo:
			if (in->sam2 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_SamInfo2_Type, in->sam2, in->sam2);
			}
			return ret;

		case NetlogonValidationSamInfo2:
			if (in->sam3 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_SamInfo3_Type, in->sam3, in->sam3);
			}
			return ret;

		case 4:
			if (in->pac == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_PacInfo_Type, in->pac, in->pac);
			}
			return ret;

		case NetlogonValidationGenericInfo2:
			if (in->generic == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_GenericInfo2_Type, in->generic, in->generic);
			}
			return ret;

		case NetlogonValidationSamInfo4:
			if (in->sam6 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_SamInfo6_Type, in->sam6, in->sam6);
			}
			return ret;

		default:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union netr_Validation *py_export_netr_Validation(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union netr_Validation *ret = talloc_zero(mem_ctx, union netr_Validation);
	switch (level) {
		case NetlogonValidationSamInfo:
			if (in == Py_None) {
				ret->sam2 = NULL;
			} else {
				ret->sam2 = NULL;
				PY_CHECK_TYPE(&netr_SamInfo2_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->sam2 = (struct netr_SamInfo2 *)pytalloc_get_ptr(in);
			}
			break;

		case NetlogonValidationSamInfo2:
			if (in == Py_None) {
				ret->sam3 = NULL;
			} else {
				ret->sam3 = NULL;
				PY_CHECK_TYPE(&netr_SamInfo3_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->sam3 = (struct netr_SamInfo3 *)pytalloc_get_ptr(in);
			}
			break;

		case 4:
			if (in == Py_None) {
				ret->pac = NULL;
			} else {
				ret->pac = NULL;
				PY_CHECK_TYPE(&netr_PacInfo_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->pac = (struct netr_PacInfo *)pytalloc_get_ptr(in);
			}
			break;

		case NetlogonValidationGenericInfo2:
			if (in == Py_None) {
				ret->generic = NULL;
			} else {
				ret->generic = NULL;
				PY_CHECK_TYPE(&netr_GenericInfo2_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->generic = (struct netr_GenericInfo2 *)pytalloc_get_ptr(in);
			}
			break;

		case NetlogonValidationSamInfo4:
			if (in == Py_None) {
				ret->sam6 = NULL;
			} else {
				ret->sam6 = NULL;
				PY_CHECK_TYPE(&netr_SamInfo6_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->sam6 = (struct netr_SamInfo6 *)pytalloc_get_ptr(in);
			}
			break;

		default:
			break;

	}

	return ret;
}


static PyObject *py_netr_Credential_get_data(PyObject *obj, void *closure)
{
	struct netr_Credential *object = (struct netr_Credential *)pytalloc_get_ptr(obj);
	PyObject *py_data;
	py_data = PyList_New(8);
	if (py_data == NULL) {
		return NULL;
	}
	{
		int data_cntr_0;
		for (data_cntr_0 = 0; data_cntr_0 < 8; data_cntr_0++) {
			PyObject *py_data_0;
			py_data_0 = PyInt_FromLong(object->data[data_cntr_0]);
			PyList_SetItem(py_data, data_cntr_0, py_data_0);
		}
	}
	return py_data;
}

static int py_netr_Credential_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_Credential *object = (struct netr_Credential *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int data_cntr_0;
		for (data_cntr_0 = 0; data_cntr_0 < PyList_GET_SIZE(value); data_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, data_cntr_0), return -1;);
			object->data[data_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, data_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_netr_Credential_getsetters[] = {
	{ discard_const_p(char, "data"), py_netr_Credential_get_data, py_netr_Credential_set_data },
	{ NULL }
};

static PyObject *py_netr_Credential_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_Credential, type);
}

static PyObject *py_netr_Credential_ndr_pack(PyObject *py_obj)
{
	struct netr_Credential *object = (struct netr_Credential *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_netr_Credential);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_netr_Credential_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_Credential *object = (struct netr_Credential *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_Credential);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_Credential);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_netr_Credential_ndr_print(PyObject *py_obj)
{
	struct netr_Credential *object = (struct netr_Credential *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_Credential, "netr_Credential", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_netr_Credential_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_netr_Credential_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_netr_Credential_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_netr_Credential_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netr_Credential_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_Credential",
	.tp_getset = py_netr_Credential_getsetters,
	.tp_methods = py_netr_Credential_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_Credential_new,
};


static PyObject *py_netr_Authenticator_get_cred(PyObject *obj, void *closure)
{
	struct netr_Authenticator *object = (struct netr_Authenticator *)pytalloc_get_ptr(obj);
	PyObject *py_cred;
	py_cred = pytalloc_reference_ex(&netr_Credential_Type, pytalloc_get_mem_ctx(obj), &object->cred);
	return py_cred;
}

static int py_netr_Authenticator_set_cred(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_Authenticator *object = (struct netr_Authenticator *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_Credential_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->cred = *(struct netr_Credential *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_Authenticator_get_timestamp(PyObject *obj, void *closure)
{
	struct netr_Authenticator *object = (struct netr_Authenticator *)pytalloc_get_ptr(obj);
	PyObject *py_timestamp;
	py_timestamp = PyInt_FromLong(object->timestamp);
	return py_timestamp;
}

static int py_netr_Authenticator_set_timestamp(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_Authenticator *object = (struct netr_Authenticator *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->timestamp = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_Authenticator_getsetters[] = {
	{ discard_const_p(char, "cred"), py_netr_Authenticator_get_cred, py_netr_Authenticator_set_cred },
	{ discard_const_p(char, "timestamp"), py_netr_Authenticator_get_timestamp, py_netr_Authenticator_set_timestamp },
	{ NULL }
};

static PyObject *py_netr_Authenticator_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_Authenticator, type);
}

static PyObject *py_netr_Authenticator_ndr_pack(PyObject *py_obj)
{
	struct netr_Authenticator *object = (struct netr_Authenticator *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_netr_Authenticator);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_netr_Authenticator_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_Authenticator *object = (struct netr_Authenticator *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_Authenticator);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_Authenticator);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_netr_Authenticator_ndr_print(PyObject *py_obj)
{
	struct netr_Authenticator *object = (struct netr_Authenticator *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_Authenticator, "netr_Authenticator", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_netr_Authenticator_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_netr_Authenticator_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_netr_Authenticator_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_netr_Authenticator_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netr_Authenticator_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_Authenticator",
	.tp_getset = py_netr_Authenticator_getsetters,
	.tp_methods = py_netr_Authenticator_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_Authenticator_new,
};


static PyObject *py_netr_DELTA_DELETE_USER_get_account_name(PyObject *obj, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = (struct netr_DELTA_DELETE_USER *)pytalloc_get_ptr(obj);
	PyObject *py_account_name;
	if (object->account_name == NULL) {
		py_account_name = Py_None;
		Py_INCREF(py_account_name);
	} else {
		if (object->account_name == NULL) {
			py_account_name = Py_None;
			Py_INCREF(py_account_name);
		} else {
			py_account_name = PyUnicode_Decode(object->account_name, strlen(object->account_name), "utf-8", "ignore");
		}
	}
	return py_account_name;
}

static int py_netr_DELTA_DELETE_USER_set_account_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = (struct netr_DELTA_DELETE_USER *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->account_name = NULL;
	} else {
		object->account_name = NULL;
		if (PyUnicode_Check(value)) {
			object->account_name = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->account_name = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_DELETE_USER_get_unknown1(PyObject *obj, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = (struct netr_DELTA_DELETE_USER *)pytalloc_get_ptr(obj);
	PyObject *py_unknown1;
	py_unknown1 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown1);
	return py_unknown1;
}

static int py_netr_DELTA_DELETE_USER_set_unknown1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = (struct netr_DELTA_DELETE_USER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown1 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_DELETE_USER_get_unknown2(PyObject *obj, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = (struct netr_DELTA_DELETE_USER *)pytalloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown2);
	return py_unknown2;
}

static int py_netr_DELTA_DELETE_USER_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = (struct netr_DELTA_DELETE_USER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown2 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_DELETE_USER_get_unknown3(PyObject *obj, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = (struct netr_DELTA_DELETE_USER *)pytalloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown3);
	return py_unknown3;
}

static int py_netr_DELTA_DELETE_USER_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = (struct netr_DELTA_DELETE_USER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown3 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_DELETE_USER_get_unknown4(PyObject *obj, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = (struct netr_DELTA_DELETE_USER *)pytalloc_get_ptr(obj);
	PyObject *py_unknown4;
	py_unknown4 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown4);
	return py_unknown4;
}

static int py_netr_DELTA_DELETE_USER_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = (struct netr_DELTA_DELETE_USER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown4 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_DELETE_USER_get_unknown5(PyObject *obj, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = (struct netr_DELTA_DELETE_USER *)pytalloc_get_ptr(obj);
	PyObject *py_unknown5;
	py_unknown5 = PyInt_FromLong(object->unknown5);
	return py_unknown5;
}

static int py_netr_DELTA_DELETE_USER_set_unknown5(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = (struct netr_DELTA_DELETE_USER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown5 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_DELETE_USER_get_unknown6(PyObject *obj, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = (struct netr_DELTA_DELETE_USER *)pytalloc_get_ptr(obj);
	PyObject *py_unknown6;
	py_unknown6 = PyInt_FromLong(object->unknown6);
	return py_unknown6;
}

static int py_netr_DELTA_DELETE_USER_set_unknown6(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = (struct netr_DELTA_DELETE_USER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown6 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_DELETE_USER_get_unknown7(PyObject *obj, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = (struct netr_DELTA_DELETE_USER *)pytalloc_get_ptr(obj);
	PyObject *py_unknown7;
	py_unknown7 = PyInt_FromLong(object->unknown7);
	return py_unknown7;
}

static int py_netr_DELTA_DELETE_USER_set_unknown7(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = (struct netr_DELTA_DELETE_USER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown7 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_DELETE_USER_get_unknown8(PyObject *obj, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = (struct netr_DELTA_DELETE_USER *)pytalloc_get_ptr(obj);
	PyObject *py_unknown8;
	py_unknown8 = PyInt_FromLong(object->unknown8);
	return py_unknown8;
}

static int py_netr_DELTA_DELETE_USER_set_unknown8(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DELETE_USER *object = (struct netr_DELTA_DELETE_USER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown8 = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_DELTA_DELETE_USER_getsetters[] = {
	{ discard_const_p(char, "account_name"), py_netr_DELTA_DELETE_USER_get_account_name, py_netr_DELTA_DELETE_USER_set_account_name },
	{ discard_const_p(char, "unknown1"), py_netr_DELTA_DELETE_USER_get_unknown1, py_netr_DELTA_DELETE_USER_set_unknown1 },
	{ discard_const_p(char, "unknown2"), py_netr_DELTA_DELETE_USER_get_unknown2, py_netr_DELTA_DELETE_USER_set_unknown2 },
	{ discard_const_p(char, "unknown3"), py_netr_DELTA_DELETE_USER_get_unknown3, py_netr_DELTA_DELETE_USER_set_unknown3 },
	{ discard_const_p(char, "unknown4"), py_netr_DELTA_DELETE_USER_get_unknown4, py_netr_DELTA_DELETE_USER_set_unknown4 },
	{ discard_const_p(char, "unknown5"), py_netr_DELTA_DELETE_USER_get_unknown5, py_netr_DELTA_DELETE_USER_set_unknown5 },
	{ discard_const_p(char, "unknown6"), py_netr_DELTA_DELETE_USER_get_unknown6, py_netr_DELTA_DELETE_USER_set_unknown6 },
	{ discard_const_p(char, "unknown7"), py_netr_DELTA_DELETE_USER_get_unknown7, py_netr_DELTA_DELETE_USER_set_unknown7 },
	{ discard_const_p(char, "unknown8"), py_netr_DELTA_DELETE_USER_get_unknown8, py_netr_DELTA_DELETE_USER_set_unknown8 },
	{ NULL }
};

static PyObject *py_netr_DELTA_DELETE_USER_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_DELTA_DELETE_USER, type);
}


static PyTypeObject netr_DELTA_DELETE_USER_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_DELTA_DELETE_USER",
	.tp_getset = py_netr_DELTA_DELETE_USER_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_DELTA_DELETE_USER_new,
};


static PyObject *py_netr_USER_KEY16_get_length(PyObject *obj, void *closure)
{
	struct netr_USER_KEY16 *object = (struct netr_USER_KEY16 *)pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyInt_FromLong(object->length);
	return py_length;
}

static int py_netr_USER_KEY16_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_USER_KEY16 *object = (struct netr_USER_KEY16 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_USER_KEY16_get_size(PyObject *obj, void *closure)
{
	struct netr_USER_KEY16 *object = (struct netr_USER_KEY16 *)pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyInt_FromLong(object->size);
	return py_size;
}

static int py_netr_USER_KEY16_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_USER_KEY16 *object = (struct netr_USER_KEY16 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_USER_KEY16_get_flags(PyObject *obj, void *closure)
{
	struct netr_USER_KEY16 *object = (struct netr_USER_KEY16 *)pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyInt_FromLong(object->flags);
	return py_flags;
}

static int py_netr_USER_KEY16_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_USER_KEY16 *object = (struct netr_USER_KEY16 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_USER_KEY16_get_pwd(PyObject *obj, void *closure)
{
	struct netr_USER_KEY16 *object = (struct netr_USER_KEY16 *)pytalloc_get_ptr(obj);
	PyObject *py_pwd;
	py_pwd = pytalloc_reference_ex(samr_Password_Type, pytalloc_get_mem_ctx(obj), &object->pwd);
	return py_pwd;
}

static int py_netr_USER_KEY16_set_pwd(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_USER_KEY16 *object = (struct netr_USER_KEY16 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(samr_Password_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->pwd = *(struct samr_Password *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_netr_USER_KEY16_getsetters[] = {
	{ discard_const_p(char, "length"), py_netr_USER_KEY16_get_length, py_netr_USER_KEY16_set_length },
	{ discard_const_p(char, "size"), py_netr_USER_KEY16_get_size, py_netr_USER_KEY16_set_size },
	{ discard_const_p(char, "flags"), py_netr_USER_KEY16_get_flags, py_netr_USER_KEY16_set_flags },
	{ discard_const_p(char, "pwd"), py_netr_USER_KEY16_get_pwd, py_netr_USER_KEY16_set_pwd },
	{ NULL }
};

static PyObject *py_netr_USER_KEY16_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_USER_KEY16, type);
}


static PyTypeObject netr_USER_KEY16_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_USER_KEY16",
	.tp_getset = py_netr_USER_KEY16_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_USER_KEY16_new,
};


static PyObject *py_netr_PasswordHistory_get_nt_length(PyObject *obj, void *closure)
{
	struct netr_PasswordHistory *object = (struct netr_PasswordHistory *)pytalloc_get_ptr(obj);
	PyObject *py_nt_length;
	py_nt_length = PyInt_FromLong(object->nt_length);
	return py_nt_length;
}

static int py_netr_PasswordHistory_set_nt_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PasswordHistory *object = (struct netr_PasswordHistory *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->nt_length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_PasswordHistory_get_nt_size(PyObject *obj, void *closure)
{
	struct netr_PasswordHistory *object = (struct netr_PasswordHistory *)pytalloc_get_ptr(obj);
	PyObject *py_nt_size;
	py_nt_size = PyInt_FromLong(object->nt_size);
	return py_nt_size;
}

static int py_netr_PasswordHistory_set_nt_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PasswordHistory *object = (struct netr_PasswordHistory *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->nt_size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_PasswordHistory_get_nt_flags(PyObject *obj, void *closure)
{
	struct netr_PasswordHistory *object = (struct netr_PasswordHistory *)pytalloc_get_ptr(obj);
	PyObject *py_nt_flags;
	py_nt_flags = PyInt_FromLong(object->nt_flags);
	return py_nt_flags;
}

static int py_netr_PasswordHistory_set_nt_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PasswordHistory *object = (struct netr_PasswordHistory *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->nt_flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_PasswordHistory_get_lm_length(PyObject *obj, void *closure)
{
	struct netr_PasswordHistory *object = (struct netr_PasswordHistory *)pytalloc_get_ptr(obj);
	PyObject *py_lm_length;
	py_lm_length = PyInt_FromLong(object->lm_length);
	return py_lm_length;
}

static int py_netr_PasswordHistory_set_lm_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PasswordHistory *object = (struct netr_PasswordHistory *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->lm_length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_PasswordHistory_get_lm_size(PyObject *obj, void *closure)
{
	struct netr_PasswordHistory *object = (struct netr_PasswordHistory *)pytalloc_get_ptr(obj);
	PyObject *py_lm_size;
	py_lm_size = PyInt_FromLong(object->lm_size);
	return py_lm_size;
}

static int py_netr_PasswordHistory_set_lm_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PasswordHistory *object = (struct netr_PasswordHistory *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->lm_size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_PasswordHistory_get_lm_flags(PyObject *obj, void *closure)
{
	struct netr_PasswordHistory *object = (struct netr_PasswordHistory *)pytalloc_get_ptr(obj);
	PyObject *py_lm_flags;
	py_lm_flags = PyInt_FromLong(object->lm_flags);
	return py_lm_flags;
}

static int py_netr_PasswordHistory_set_lm_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PasswordHistory *object = (struct netr_PasswordHistory *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->lm_flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_PasswordHistory_get_nt_history(PyObject *obj, void *closure)
{
	struct netr_PasswordHistory *object = (struct netr_PasswordHistory *)pytalloc_get_ptr(obj);
	PyObject *py_nt_history;
	py_nt_history = PyList_New(object->nt_length);
	if (py_nt_history == NULL) {
		return NULL;
	}
	{
		int nt_history_cntr_0;
		for (nt_history_cntr_0 = 0; nt_history_cntr_0 < object->nt_length; nt_history_cntr_0++) {
			PyObject *py_nt_history_0;
			py_nt_history_0 = PyInt_FromLong(object->nt_history[nt_history_cntr_0]);
			PyList_SetItem(py_nt_history, nt_history_cntr_0, py_nt_history_0);
		}
	}
	return py_nt_history;
}

static int py_netr_PasswordHistory_set_nt_history(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PasswordHistory *object = (struct netr_PasswordHistory *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int nt_history_cntr_0;
		object->nt_history = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->nt_history, PyList_GET_SIZE(value));
		if (!object->nt_history) { return -1;; }
		talloc_set_name_const(object->nt_history, "ARRAY: object->nt_history");
		for (nt_history_cntr_0 = 0; nt_history_cntr_0 < PyList_GET_SIZE(value); nt_history_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, nt_history_cntr_0), return -1;);
			object->nt_history[nt_history_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, nt_history_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_netr_PasswordHistory_get_lm_history(PyObject *obj, void *closure)
{
	struct netr_PasswordHistory *object = (struct netr_PasswordHistory *)pytalloc_get_ptr(obj);
	PyObject *py_lm_history;
	py_lm_history = PyList_New(object->lm_length);
	if (py_lm_history == NULL) {
		return NULL;
	}
	{
		int lm_history_cntr_0;
		for (lm_history_cntr_0 = 0; lm_history_cntr_0 < object->lm_length; lm_history_cntr_0++) {
			PyObject *py_lm_history_0;
			py_lm_history_0 = PyInt_FromLong(object->lm_history[lm_history_cntr_0]);
			PyList_SetItem(py_lm_history, lm_history_cntr_0, py_lm_history_0);
		}
	}
	return py_lm_history;
}

static int py_netr_PasswordHistory_set_lm_history(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_PasswordHistory *object = (struct netr_PasswordHistory *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int lm_history_cntr_0;
		object->lm_history = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->lm_history, PyList_GET_SIZE(value));
		if (!object->lm_history) { return -1;; }
		talloc_set_name_const(object->lm_history, "ARRAY: object->lm_history");
		for (lm_history_cntr_0 = 0; lm_history_cntr_0 < PyList_GET_SIZE(value); lm_history_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, lm_history_cntr_0), return -1;);
			object->lm_history[lm_history_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, lm_history_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_netr_PasswordHistory_getsetters[] = {
	{ discard_const_p(char, "nt_length"), py_netr_PasswordHistory_get_nt_length, py_netr_PasswordHistory_set_nt_length },
	{ discard_const_p(char, "nt_size"), py_netr_PasswordHistory_get_nt_size, py_netr_PasswordHistory_set_nt_size },
	{ discard_const_p(char, "nt_flags"), py_netr_PasswordHistory_get_nt_flags, py_netr_PasswordHistory_set_nt_flags },
	{ discard_const_p(char, "lm_length"), py_netr_PasswordHistory_get_lm_length, py_netr_PasswordHistory_set_lm_length },
	{ discard_const_p(char, "lm_size"), py_netr_PasswordHistory_get_lm_size, py_netr_PasswordHistory_set_lm_size },
	{ discard_const_p(char, "lm_flags"), py_netr_PasswordHistory_get_lm_flags, py_netr_PasswordHistory_set_lm_flags },
	{ discard_const_p(char, "nt_history"), py_netr_PasswordHistory_get_nt_history, py_netr_PasswordHistory_set_nt_history },
	{ discard_const_p(char, "lm_history"), py_netr_PasswordHistory_get_lm_history, py_netr_PasswordHistory_set_lm_history },
	{ NULL }
};

static PyObject *py_netr_PasswordHistory_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_PasswordHistory, type);
}


static PyTypeObject netr_PasswordHistory_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_PasswordHistory",
	.tp_getset = py_netr_PasswordHistory_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_PasswordHistory_new,
};


static PyObject *py_netr_USER_KEYS2_get_lmpassword(PyObject *obj, void *closure)
{
	struct netr_USER_KEYS2 *object = (struct netr_USER_KEYS2 *)pytalloc_get_ptr(obj);
	PyObject *py_lmpassword;
	py_lmpassword = pytalloc_reference_ex(&netr_USER_KEY16_Type, pytalloc_get_mem_ctx(obj), &object->lmpassword);
	return py_lmpassword;
}

static int py_netr_USER_KEYS2_set_lmpassword(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_USER_KEYS2 *object = (struct netr_USER_KEYS2 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_USER_KEY16_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->lmpassword = *(struct netr_USER_KEY16 *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_USER_KEYS2_get_ntpassword(PyObject *obj, void *closure)
{
	struct netr_USER_KEYS2 *object = (struct netr_USER_KEYS2 *)pytalloc_get_ptr(obj);
	PyObject *py_ntpassword;
	py_ntpassword = pytalloc_reference_ex(&netr_USER_KEY16_Type, pytalloc_get_mem_ctx(obj), &object->ntpassword);
	return py_ntpassword;
}

static int py_netr_USER_KEYS2_set_ntpassword(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_USER_KEYS2 *object = (struct netr_USER_KEYS2 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_USER_KEY16_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->ntpassword = *(struct netr_USER_KEY16 *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_USER_KEYS2_get_history(PyObject *obj, void *closure)
{
	struct netr_USER_KEYS2 *object = (struct netr_USER_KEYS2 *)pytalloc_get_ptr(obj);
	PyObject *py_history;
	py_history = pytalloc_reference_ex(&netr_PasswordHistory_Type, pytalloc_get_mem_ctx(obj), &object->history);
	return py_history;
}

static int py_netr_USER_KEYS2_set_history(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_USER_KEYS2 *object = (struct netr_USER_KEYS2 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_PasswordHistory_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->history = *(struct netr_PasswordHistory *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_netr_USER_KEYS2_getsetters[] = {
	{ discard_const_p(char, "lmpassword"), py_netr_USER_KEYS2_get_lmpassword, py_netr_USER_KEYS2_set_lmpassword },
	{ discard_const_p(char, "ntpassword"), py_netr_USER_KEYS2_get_ntpassword, py_netr_USER_KEYS2_set_ntpassword },
	{ discard_const_p(char, "history"), py_netr_USER_KEYS2_get_history, py_netr_USER_KEYS2_set_history },
	{ NULL }
};

static PyObject *py_netr_USER_KEYS2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_USER_KEYS2, type);
}


static PyTypeObject netr_USER_KEYS2_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_USER_KEYS2",
	.tp_getset = py_netr_USER_KEYS2_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_USER_KEYS2_new,
};


static PyObject *py_netr_USER_KEY_UNION_get_keys2(PyObject *obj, void *closure)
{
	struct netr_USER_KEY_UNION *object = (struct netr_USER_KEY_UNION *)pytalloc_get_ptr(obj);
	PyObject *py_keys2;
	py_keys2 = pytalloc_reference_ex(&netr_USER_KEYS2_Type, pytalloc_get_mem_ctx(obj), &object->keys2);
	return py_keys2;
}

static int py_netr_USER_KEY_UNION_set_keys2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_USER_KEY_UNION *object = (struct netr_USER_KEY_UNION *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_USER_KEYS2_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->keys2 = *(struct netr_USER_KEYS2 *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_netr_USER_KEY_UNION_getsetters[] = {
	{ discard_const_p(char, "keys2"), py_netr_USER_KEY_UNION_get_keys2, py_netr_USER_KEY_UNION_set_keys2 },
	{ NULL }
};

static PyObject *py_netr_USER_KEY_UNION_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_USER_KEY_UNION, type);
}


static PyTypeObject netr_USER_KEY_UNION_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_USER_KEY_UNION",
	.tp_getset = py_netr_USER_KEY_UNION_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_USER_KEY_UNION_new,
};


static PyObject *py_netr_USER_KEYS_get_version(PyObject *obj, void *closure)
{
	struct netr_USER_KEYS *object = (struct netr_USER_KEYS *)pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyInt_FromLong(object->version);
	return py_version;
}

static int py_netr_USER_KEYS_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_USER_KEYS *object = (struct netr_USER_KEYS *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->version = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_USER_KEYS_get_keys(PyObject *obj, void *closure)
{
	struct netr_USER_KEYS *object = (struct netr_USER_KEYS *)pytalloc_get_ptr(obj);
	PyObject *py_keys;
	py_keys = pytalloc_reference_ex(&netr_USER_KEY_UNION_Type, pytalloc_get_mem_ctx(obj), &object->keys);
	return py_keys;
}

static int py_netr_USER_KEYS_set_keys(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_USER_KEYS *object = (struct netr_USER_KEYS *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_USER_KEY_UNION_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->keys = *(struct netr_USER_KEY_UNION *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_netr_USER_KEYS_getsetters[] = {
	{ discard_const_p(char, "version"), py_netr_USER_KEYS_get_version, py_netr_USER_KEYS_set_version },
	{ discard_const_p(char, "keys"), py_netr_USER_KEYS_get_keys, py_netr_USER_KEYS_set_keys },
	{ NULL }
};

static PyObject *py_netr_USER_KEYS_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_USER_KEYS, type);
}

static PyObject *py_netr_USER_KEYS_ndr_pack(PyObject *py_obj)
{
	struct netr_USER_KEYS *object = (struct netr_USER_KEYS *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_netr_USER_KEYS);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_netr_USER_KEYS_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_USER_KEYS *object = (struct netr_USER_KEYS *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_USER_KEYS);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_USER_KEYS);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_netr_USER_KEYS_ndr_print(PyObject *py_obj)
{
	struct netr_USER_KEYS *object = (struct netr_USER_KEYS *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_USER_KEYS, "netr_USER_KEYS", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_netr_USER_KEYS_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_netr_USER_KEYS_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_netr_USER_KEYS_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_netr_USER_KEYS_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netr_USER_KEYS_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_USER_KEYS",
	.tp_getset = py_netr_USER_KEYS_getsetters,
	.tp_methods = py_netr_USER_KEYS_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_USER_KEYS_new,
};


static PyObject *py_netr_USER_PRIVATE_INFO_get_SensitiveDataFlag(PyObject *obj, void *closure)
{
	struct netr_USER_PRIVATE_INFO *object = (struct netr_USER_PRIVATE_INFO *)pytalloc_get_ptr(obj);
	PyObject *py_SensitiveDataFlag;
	py_SensitiveDataFlag = PyInt_FromLong(object->SensitiveDataFlag);
	return py_SensitiveDataFlag;
}

static int py_netr_USER_PRIVATE_INFO_set_SensitiveDataFlag(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_USER_PRIVATE_INFO *object = (struct netr_USER_PRIVATE_INFO *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->SensitiveDataFlag = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_USER_PRIVATE_INFO_get_DataLength(PyObject *obj, void *closure)
{
	struct netr_USER_PRIVATE_INFO *object = (struct netr_USER_PRIVATE_INFO *)pytalloc_get_ptr(obj);
	PyObject *py_DataLength;
	py_DataLength = PyInt_FromLong(object->DataLength);
	return py_DataLength;
}

static int py_netr_USER_PRIVATE_INFO_set_DataLength(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_USER_PRIVATE_INFO *object = (struct netr_USER_PRIVATE_INFO *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->DataLength = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_USER_PRIVATE_INFO_get_SensitiveData(PyObject *obj, void *closure)
{
	struct netr_USER_PRIVATE_INFO *object = (struct netr_USER_PRIVATE_INFO *)pytalloc_get_ptr(obj);
	PyObject *py_SensitiveData;
	if (object->SensitiveData == NULL) {
		py_SensitiveData = Py_None;
		Py_INCREF(py_SensitiveData);
	} else {
		py_SensitiveData = PyList_New(object->DataLength);
		if (py_SensitiveData == NULL) {
			return NULL;
		}
		{
			int SensitiveData_cntr_1;
			for (SensitiveData_cntr_1 = 0; SensitiveData_cntr_1 < object->DataLength; SensitiveData_cntr_1++) {
				PyObject *py_SensitiveData_1;
				py_SensitiveData_1 = PyInt_FromLong(object->SensitiveData[SensitiveData_cntr_1]);
				PyList_SetItem(py_SensitiveData, SensitiveData_cntr_1, py_SensitiveData_1);
			}
		}
	}
	return py_SensitiveData;
}

static int py_netr_USER_PRIVATE_INFO_set_SensitiveData(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_USER_PRIVATE_INFO *object = (struct netr_USER_PRIVATE_INFO *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->SensitiveData);
	if (value == Py_None) {
		object->SensitiveData = NULL;
	} else {
		object->SensitiveData = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int SensitiveData_cntr_1;
			object->SensitiveData = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->SensitiveData, PyList_GET_SIZE(value));
			if (!object->SensitiveData) { return -1;; }
			talloc_set_name_const(object->SensitiveData, "ARRAY: object->SensitiveData");
			for (SensitiveData_cntr_1 = 0; SensitiveData_cntr_1 < PyList_GET_SIZE(value); SensitiveData_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, SensitiveData_cntr_1), return -1;);
				object->SensitiveData[SensitiveData_cntr_1] = PyInt_AsLong(PyList_GET_ITEM(value, SensitiveData_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_netr_USER_PRIVATE_INFO_getsetters[] = {
	{ discard_const_p(char, "SensitiveDataFlag"), py_netr_USER_PRIVATE_INFO_get_SensitiveDataFlag, py_netr_USER_PRIVATE_INFO_set_SensitiveDataFlag },
	{ discard_const_p(char, "DataLength"), py_netr_USER_PRIVATE_INFO_get_DataLength, py_netr_USER_PRIVATE_INFO_set_DataLength },
	{ discard_const_p(char, "SensitiveData"), py_netr_USER_PRIVATE_INFO_get_SensitiveData, py_netr_USER_PRIVATE_INFO_set_SensitiveData },
	{ NULL }
};

static PyObject *py_netr_USER_PRIVATE_INFO_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_USER_PRIVATE_INFO, type);
}


static PyTypeObject netr_USER_PRIVATE_INFO_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_USER_PRIVATE_INFO",
	.tp_getset = py_netr_USER_PRIVATE_INFO_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_USER_PRIVATE_INFO_new,
};


static PyObject *py_netr_DELTA_USER_get_account_name(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(obj);
	PyObject *py_account_name;
	py_account_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->account_name);
	return py_account_name;
}

static int py_netr_DELTA_USER_set_account_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->account_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_full_name(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(obj);
	PyObject *py_full_name;
	py_full_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->full_name);
	return py_full_name;
}

static int py_netr_DELTA_USER_set_full_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->full_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_rid(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(obj);
	PyObject *py_rid;
	py_rid = PyInt_FromLong(object->rid);
	return py_rid;
}

static int py_netr_DELTA_USER_set_rid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->rid = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_primary_gid(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(obj);
	PyObject *py_primary_gid;
	py_primary_gid = PyInt_FromLong(object->primary_gid);
	return py_primary_gid;
}

static int py_netr_DELTA_USER_set_primary_gid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->primary_gid = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_home_directory(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(obj);
	PyObject *py_home_directory;
	py_home_directory = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->home_directory);
	return py_home_directory;
}

static int py_netr_DELTA_USER_set_home_directory(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->home_directory = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_home_drive(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(obj);
	PyObject *py_home_drive;
	py_home_drive = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->home_drive);
	return py_home_drive;
}

static int py_netr_DELTA_USER_set_home_drive(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->home_drive = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_logon_script(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(obj);
	PyObject *py_logon_script;
	py_logon_script = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->logon_script);
	return py_logon_script;
}

static int py_netr_DELTA_USER_set_logon_script(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->logon_script = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_description(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(obj);
	PyObject *py_description;
	py_description = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->description);
	return py_description;
}

static int py_netr_DELTA_USER_set_description(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->description = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_workstations(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(obj);
	PyObject *py_workstations;
	py_workstations = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->workstations);
	return py_workstations;
}

static int py_netr_DELTA_USER_set_workstations(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->workstations = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_last_logon(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(obj);
	PyObject *py_last_logon;
	py_last_logon = PyLong_FromLongLong(object->last_logon);
	return py_last_logon;
}

static int py_netr_DELTA_USER_set_last_logon(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->last_logon = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->last_logon = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_last_logoff(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(obj);
	PyObject *py_last_logoff;
	py_last_logoff = PyLong_FromLongLong(object->last_logoff);
	return py_last_logoff;
}

static int py_netr_DELTA_USER_set_last_logoff(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->last_logoff = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->last_logoff = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_logon_hours(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(obj);
	PyObject *py_logon_hours;
	py_logon_hours = pytalloc_reference_ex(samr_LogonHours_Type, pytalloc_get_mem_ctx(obj), &object->logon_hours);
	return py_logon_hours;
}

static int py_netr_DELTA_USER_set_logon_hours(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(samr_LogonHours_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->logon_hours = *(struct samr_LogonHours *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_bad_password_count(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(obj);
	PyObject *py_bad_password_count;
	py_bad_password_count = PyInt_FromLong(object->bad_password_count);
	return py_bad_password_count;
}

static int py_netr_DELTA_USER_set_bad_password_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->bad_password_count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_logon_count(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(obj);
	PyObject *py_logon_count;
	py_logon_count = PyInt_FromLong(object->logon_count);
	return py_logon_count;
}

static int py_netr_DELTA_USER_set_logon_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->logon_count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_last_password_change(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(obj);
	PyObject *py_last_password_change;
	py_last_password_change = PyLong_FromLongLong(object->last_password_change);
	return py_last_password_change;
}

static int py_netr_DELTA_USER_set_last_password_change(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->last_password_change = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->last_password_change = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_acct_expiry(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(obj);
	PyObject *py_acct_expiry;
	py_acct_expiry = PyLong_FromLongLong(object->acct_expiry);
	return py_acct_expiry;
}

static int py_netr_DELTA_USER_set_acct_expiry(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->acct_expiry = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->acct_expiry = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_acct_flags(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(obj);
	PyObject *py_acct_flags;
	py_acct_flags = PyInt_FromLong(object->acct_flags);
	return py_acct_flags;
}

static int py_netr_DELTA_USER_set_acct_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->acct_flags = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->acct_flags = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_lmpassword(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(obj);
	PyObject *py_lmpassword;
	py_lmpassword = pytalloc_reference_ex(samr_Password_Type, pytalloc_get_mem_ctx(obj), &object->lmpassword);
	return py_lmpassword;
}

static int py_netr_DELTA_USER_set_lmpassword(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(samr_Password_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->lmpassword = *(struct samr_Password *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_ntpassword(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(obj);
	PyObject *py_ntpassword;
	py_ntpassword = pytalloc_reference_ex(samr_Password_Type, pytalloc_get_mem_ctx(obj), &object->ntpassword);
	return py_ntpassword;
}

static int py_netr_DELTA_USER_set_ntpassword(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(samr_Password_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->ntpassword = *(struct samr_Password *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_nt_password_present(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(obj);
	PyObject *py_nt_password_present;
	py_nt_password_present = PyInt_FromLong(object->nt_password_present);
	return py_nt_password_present;
}

static int py_netr_DELTA_USER_set_nt_password_present(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->nt_password_present = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_lm_password_present(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(obj);
	PyObject *py_lm_password_present;
	py_lm_password_present = PyInt_FromLong(object->lm_password_present);
	return py_lm_password_present;
}

static int py_netr_DELTA_USER_set_lm_password_present(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->lm_password_present = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_password_expired(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(obj);
	PyObject *py_password_expired;
	py_password_expired = PyInt_FromLong(object->password_expired);
	return py_password_expired;
}

static int py_netr_DELTA_USER_set_password_expired(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->password_expired = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_comment(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(obj);
	PyObject *py_comment;
	py_comment = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->comment);
	return py_comment;
}

static int py_netr_DELTA_USER_set_comment(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->comment = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_parameters(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(obj);
	PyObject *py_parameters;
	py_parameters = pytalloc_reference_ex(lsa_BinaryString_Type, pytalloc_get_mem_ctx(obj), &object->parameters);
	return py_parameters;
}

static int py_netr_DELTA_USER_set_parameters(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_BinaryString_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->parameters = *(struct lsa_BinaryString *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_country_code(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(obj);
	PyObject *py_country_code;
	py_country_code = PyInt_FromLong(object->country_code);
	return py_country_code;
}

static int py_netr_DELTA_USER_set_country_code(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->country_code = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_code_page(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(obj);
	PyObject *py_code_page;
	py_code_page = PyInt_FromLong(object->code_page);
	return py_code_page;
}

static int py_netr_DELTA_USER_set_code_page(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->code_page = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_user_private_info(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(obj);
	PyObject *py_user_private_info;
	py_user_private_info = pytalloc_reference_ex(&netr_USER_PRIVATE_INFO_Type, pytalloc_get_mem_ctx(obj), &object->user_private_info);
	return py_user_private_info;
}

static int py_netr_DELTA_USER_set_user_private_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_USER_PRIVATE_INFO_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->user_private_info = *(struct netr_USER_PRIVATE_INFO *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_SecurityInformation(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(obj);
	PyObject *py_SecurityInformation;
	py_SecurityInformation = PyInt_FromLong(object->SecurityInformation);
	return py_SecurityInformation;
}

static int py_netr_DELTA_USER_set_SecurityInformation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->SecurityInformation = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_sdbuf(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(obj);
	PyObject *py_sdbuf;
	py_sdbuf = pytalloc_reference_ex(sec_desc_buf_Type, pytalloc_get_mem_ctx(obj), &object->sdbuf);
	return py_sdbuf;
}

static int py_netr_DELTA_USER_set_sdbuf(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(sec_desc_buf_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->sdbuf = *(struct sec_desc_buf *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_profile_path(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(obj);
	PyObject *py_profile_path;
	py_profile_path = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->profile_path);
	return py_profile_path;
}

static int py_netr_DELTA_USER_set_profile_path(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->profile_path = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_unknown2(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown2);
	return py_unknown2;
}

static int py_netr_DELTA_USER_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown2 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_unknown3(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown3);
	return py_unknown3;
}

static int py_netr_DELTA_USER_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown3 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_unknown4(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(obj);
	PyObject *py_unknown4;
	py_unknown4 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown4);
	return py_unknown4;
}

static int py_netr_DELTA_USER_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown4 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_unknown5(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(obj);
	PyObject *py_unknown5;
	py_unknown5 = PyInt_FromLong(object->unknown5);
	return py_unknown5;
}

static int py_netr_DELTA_USER_set_unknown5(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown5 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_unknown6(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(obj);
	PyObject *py_unknown6;
	py_unknown6 = PyInt_FromLong(object->unknown6);
	return py_unknown6;
}

static int py_netr_DELTA_USER_set_unknown6(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown6 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_unknown7(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(obj);
	PyObject *py_unknown7;
	py_unknown7 = PyInt_FromLong(object->unknown7);
	return py_unknown7;
}

static int py_netr_DELTA_USER_set_unknown7(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown7 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_USER_get_unknown8(PyObject *obj, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(obj);
	PyObject *py_unknown8;
	py_unknown8 = PyInt_FromLong(object->unknown8);
	return py_unknown8;
}

static int py_netr_DELTA_USER_set_unknown8(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_USER *object = (struct netr_DELTA_USER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown8 = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_DELTA_USER_getsetters[] = {
	{ discard_const_p(char, "account_name"), py_netr_DELTA_USER_get_account_name, py_netr_DELTA_USER_set_account_name },
	{ discard_const_p(char, "full_name"), py_netr_DELTA_USER_get_full_name, py_netr_DELTA_USER_set_full_name },
	{ discard_const_p(char, "rid"), py_netr_DELTA_USER_get_rid, py_netr_DELTA_USER_set_rid },
	{ discard_const_p(char, "primary_gid"), py_netr_DELTA_USER_get_primary_gid, py_netr_DELTA_USER_set_primary_gid },
	{ discard_const_p(char, "home_directory"), py_netr_DELTA_USER_get_home_directory, py_netr_DELTA_USER_set_home_directory },
	{ discard_const_p(char, "home_drive"), py_netr_DELTA_USER_get_home_drive, py_netr_DELTA_USER_set_home_drive },
	{ discard_const_p(char, "logon_script"), py_netr_DELTA_USER_get_logon_script, py_netr_DELTA_USER_set_logon_script },
	{ discard_const_p(char, "description"), py_netr_DELTA_USER_get_description, py_netr_DELTA_USER_set_description },
	{ discard_const_p(char, "workstations"), py_netr_DELTA_USER_get_workstations, py_netr_DELTA_USER_set_workstations },
	{ discard_const_p(char, "last_logon"), py_netr_DELTA_USER_get_last_logon, py_netr_DELTA_USER_set_last_logon },
	{ discard_const_p(char, "last_logoff"), py_netr_DELTA_USER_get_last_logoff, py_netr_DELTA_USER_set_last_logoff },
	{ discard_const_p(char, "logon_hours"), py_netr_DELTA_USER_get_logon_hours, py_netr_DELTA_USER_set_logon_hours },
	{ discard_const_p(char, "bad_password_count"), py_netr_DELTA_USER_get_bad_password_count, py_netr_DELTA_USER_set_bad_password_count },
	{ discard_const_p(char, "logon_count"), py_netr_DELTA_USER_get_logon_count, py_netr_DELTA_USER_set_logon_count },
	{ discard_const_p(char, "last_password_change"), py_netr_DELTA_USER_get_last_password_change, py_netr_DELTA_USER_set_last_password_change },
	{ discard_const_p(char, "acct_expiry"), py_netr_DELTA_USER_get_acct_expiry, py_netr_DELTA_USER_set_acct_expiry },
	{ discard_const_p(char, "acct_flags"), py_netr_DELTA_USER_get_acct_flags, py_netr_DELTA_USER_set_acct_flags },
	{ discard_const_p(char, "lmpassword"), py_netr_DELTA_USER_get_lmpassword, py_netr_DELTA_USER_set_lmpassword },
	{ discard_const_p(char, "ntpassword"), py_netr_DELTA_USER_get_ntpassword, py_netr_DELTA_USER_set_ntpassword },
	{ discard_const_p(char, "nt_password_present"), py_netr_DELTA_USER_get_nt_password_present, py_netr_DELTA_USER_set_nt_password_present },
	{ discard_const_p(char, "lm_password_present"), py_netr_DELTA_USER_get_lm_password_present, py_netr_DELTA_USER_set_lm_password_present },
	{ discard_const_p(char, "password_expired"), py_netr_DELTA_USER_get_password_expired, py_netr_DELTA_USER_set_password_expired },
	{ discard_const_p(char, "comment"), py_netr_DELTA_USER_get_comment, py_netr_DELTA_USER_set_comment },
	{ discard_const_p(char, "parameters"), py_netr_DELTA_USER_get_parameters, py_netr_DELTA_USER_set_parameters },
	{ discard_const_p(char, "country_code"), py_netr_DELTA_USER_get_country_code, py_netr_DELTA_USER_set_country_code },
	{ discard_const_p(char, "code_page"), py_netr_DELTA_USER_get_code_page, py_netr_DELTA_USER_set_code_page },
	{ discard_const_p(char, "user_private_info"), py_netr_DELTA_USER_get_user_private_info, py_netr_DELTA_USER_set_user_private_info },
	{ discard_const_p(char, "SecurityInformation"), py_netr_DELTA_USER_get_SecurityInformation, py_netr_DELTA_USER_set_SecurityInformation },
	{ discard_const_p(char, "sdbuf"), py_netr_DELTA_USER_get_sdbuf, py_netr_DELTA_USER_set_sdbuf },
	{ discard_const_p(char, "profile_path"), py_netr_DELTA_USER_get_profile_path, py_netr_DELTA_USER_set_profile_path },
	{ discard_const_p(char, "unknown2"), py_netr_DELTA_USER_get_unknown2, py_netr_DELTA_USER_set_unknown2 },
	{ discard_const_p(char, "unknown3"), py_netr_DELTA_USER_get_unknown3, py_netr_DELTA_USER_set_unknown3 },
	{ discard_const_p(char, "unknown4"), py_netr_DELTA_USER_get_unknown4, py_netr_DELTA_USER_set_unknown4 },
	{ discard_const_p(char, "unknown5"), py_netr_DELTA_USER_get_unknown5, py_netr_DELTA_USER_set_unknown5 },
	{ discard_const_p(char, "unknown6"), py_netr_DELTA_USER_get_unknown6, py_netr_DELTA_USER_set_unknown6 },
	{ discard_const_p(char, "unknown7"), py_netr_DELTA_USER_get_unknown7, py_netr_DELTA_USER_set_unknown7 },
	{ discard_const_p(char, "unknown8"), py_netr_DELTA_USER_get_unknown8, py_netr_DELTA_USER_set_unknown8 },
	{ NULL }
};

static PyObject *py_netr_DELTA_USER_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_DELTA_USER, type);
}


static PyTypeObject netr_DELTA_USER_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_DELTA_USER",
	.tp_getset = py_netr_DELTA_USER_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_DELTA_USER_new,
};


static PyObject *py_netr_DELTA_DOMAIN_get_domain_name(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)pytalloc_get_ptr(obj);
	PyObject *py_domain_name;
	py_domain_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->domain_name);
	return py_domain_name;
}

static int py_netr_DELTA_DOMAIN_set_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->domain_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_oem_information(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)pytalloc_get_ptr(obj);
	PyObject *py_oem_information;
	py_oem_information = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->oem_information);
	return py_oem_information;
}

static int py_netr_DELTA_DOMAIN_set_oem_information(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->oem_information = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_force_logoff_time(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)pytalloc_get_ptr(obj);
	PyObject *py_force_logoff_time;
	py_force_logoff_time = PyLong_FromLongLong(object->force_logoff_time);
	return py_force_logoff_time;
}

static int py_netr_DELTA_DOMAIN_set_force_logoff_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->force_logoff_time = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->force_logoff_time = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_min_password_length(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)pytalloc_get_ptr(obj);
	PyObject *py_min_password_length;
	py_min_password_length = PyInt_FromLong(object->min_password_length);
	return py_min_password_length;
}

static int py_netr_DELTA_DOMAIN_set_min_password_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->min_password_length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_password_history_length(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)pytalloc_get_ptr(obj);
	PyObject *py_password_history_length;
	py_password_history_length = PyInt_FromLong(object->password_history_length);
	return py_password_history_length;
}

static int py_netr_DELTA_DOMAIN_set_password_history_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->password_history_length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_max_password_age(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)pytalloc_get_ptr(obj);
	PyObject *py_max_password_age;
	py_max_password_age = PyLong_FromLongLong(object->max_password_age);
	return py_max_password_age;
}

static int py_netr_DELTA_DOMAIN_set_max_password_age(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->max_password_age = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->max_password_age = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_min_password_age(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)pytalloc_get_ptr(obj);
	PyObject *py_min_password_age;
	py_min_password_age = PyLong_FromLongLong(object->min_password_age);
	return py_min_password_age;
}

static int py_netr_DELTA_DOMAIN_set_min_password_age(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->min_password_age = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->min_password_age = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_sequence_num(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)pytalloc_get_ptr(obj);
	PyObject *py_sequence_num;
	py_sequence_num = PyLong_FromLongLong(object->sequence_num);
	return py_sequence_num;
}

static int py_netr_DELTA_DOMAIN_set_sequence_num(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->sequence_num = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->sequence_num = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_domain_create_time(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)pytalloc_get_ptr(obj);
	PyObject *py_domain_create_time;
	py_domain_create_time = PyLong_FromLongLong(object->domain_create_time);
	return py_domain_create_time;
}

static int py_netr_DELTA_DOMAIN_set_domain_create_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->domain_create_time = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->domain_create_time = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_SecurityInformation(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)pytalloc_get_ptr(obj);
	PyObject *py_SecurityInformation;
	py_SecurityInformation = PyInt_FromLong(object->SecurityInformation);
	return py_SecurityInformation;
}

static int py_netr_DELTA_DOMAIN_set_SecurityInformation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->SecurityInformation = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_sdbuf(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)pytalloc_get_ptr(obj);
	PyObject *py_sdbuf;
	py_sdbuf = pytalloc_reference_ex(sec_desc_buf_Type, pytalloc_get_mem_ctx(obj), &object->sdbuf);
	return py_sdbuf;
}

static int py_netr_DELTA_DOMAIN_set_sdbuf(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(sec_desc_buf_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->sdbuf = *(struct sec_desc_buf *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_account_lockout(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)pytalloc_get_ptr(obj);
	PyObject *py_account_lockout;
	py_account_lockout = pytalloc_reference_ex(lsa_BinaryString_Type, pytalloc_get_mem_ctx(obj), &object->account_lockout);
	return py_account_lockout;
}

static int py_netr_DELTA_DOMAIN_set_account_lockout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_BinaryString_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->account_lockout = *(struct lsa_BinaryString *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_unknown2(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)pytalloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown2);
	return py_unknown2;
}

static int py_netr_DELTA_DOMAIN_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown2 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_unknown3(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)pytalloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown3);
	return py_unknown3;
}

static int py_netr_DELTA_DOMAIN_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown3 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_unknown4(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)pytalloc_get_ptr(obj);
	PyObject *py_unknown4;
	py_unknown4 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown4);
	return py_unknown4;
}

static int py_netr_DELTA_DOMAIN_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown4 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_logon_to_chgpass(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)pytalloc_get_ptr(obj);
	PyObject *py_logon_to_chgpass;
	py_logon_to_chgpass = PyInt_FromLong(object->logon_to_chgpass);
	return py_logon_to_chgpass;
}

static int py_netr_DELTA_DOMAIN_set_logon_to_chgpass(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->logon_to_chgpass = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_unknown6(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)pytalloc_get_ptr(obj);
	PyObject *py_unknown6;
	py_unknown6 = PyInt_FromLong(object->unknown6);
	return py_unknown6;
}

static int py_netr_DELTA_DOMAIN_set_unknown6(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown6 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_unknown7(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)pytalloc_get_ptr(obj);
	PyObject *py_unknown7;
	py_unknown7 = PyInt_FromLong(object->unknown7);
	return py_unknown7;
}

static int py_netr_DELTA_DOMAIN_set_unknown7(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown7 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_DOMAIN_get_unknown8(PyObject *obj, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)pytalloc_get_ptr(obj);
	PyObject *py_unknown8;
	py_unknown8 = PyInt_FromLong(object->unknown8);
	return py_unknown8;
}

static int py_netr_DELTA_DOMAIN_set_unknown8(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_DOMAIN *object = (struct netr_DELTA_DOMAIN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown8 = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_DELTA_DOMAIN_getsetters[] = {
	{ discard_const_p(char, "domain_name"), py_netr_DELTA_DOMAIN_get_domain_name, py_netr_DELTA_DOMAIN_set_domain_name },
	{ discard_const_p(char, "oem_information"), py_netr_DELTA_DOMAIN_get_oem_information, py_netr_DELTA_DOMAIN_set_oem_information },
	{ discard_const_p(char, "force_logoff_time"), py_netr_DELTA_DOMAIN_get_force_logoff_time, py_netr_DELTA_DOMAIN_set_force_logoff_time },
	{ discard_const_p(char, "min_password_length"), py_netr_DELTA_DOMAIN_get_min_password_length, py_netr_DELTA_DOMAIN_set_min_password_length },
	{ discard_const_p(char, "password_history_length"), py_netr_DELTA_DOMAIN_get_password_history_length, py_netr_DELTA_DOMAIN_set_password_history_length },
	{ discard_const_p(char, "max_password_age"), py_netr_DELTA_DOMAIN_get_max_password_age, py_netr_DELTA_DOMAIN_set_max_password_age },
	{ discard_const_p(char, "min_password_age"), py_netr_DELTA_DOMAIN_get_min_password_age, py_netr_DELTA_DOMAIN_set_min_password_age },
	{ discard_const_p(char, "sequence_num"), py_netr_DELTA_DOMAIN_get_sequence_num, py_netr_DELTA_DOMAIN_set_sequence_num },
	{ discard_const_p(char, "domain_create_time"), py_netr_DELTA_DOMAIN_get_domain_create_time, py_netr_DELTA_DOMAIN_set_domain_create_time },
	{ discard_const_p(char, "SecurityInformation"), py_netr_DELTA_DOMAIN_get_SecurityInformation, py_netr_DELTA_DOMAIN_set_SecurityInformation },
	{ discard_const_p(char, "sdbuf"), py_netr_DELTA_DOMAIN_get_sdbuf, py_netr_DELTA_DOMAIN_set_sdbuf },
	{ discard_const_p(char, "account_lockout"), py_netr_DELTA_DOMAIN_get_account_lockout, py_netr_DELTA_DOMAIN_set_account_lockout },
	{ discard_const_p(char, "unknown2"), py_netr_DELTA_DOMAIN_get_unknown2, py_netr_DELTA_DOMAIN_set_unknown2 },
	{ discard_const_p(char, "unknown3"), py_netr_DELTA_DOMAIN_get_unknown3, py_netr_DELTA_DOMAIN_set_unknown3 },
	{ discard_const_p(char, "unknown4"), py_netr_DELTA_DOMAIN_get_unknown4, py_netr_DELTA_DOMAIN_set_unknown4 },
	{ discard_const_p(char, "logon_to_chgpass"), py_netr_DELTA_DOMAIN_get_logon_to_chgpass, py_netr_DELTA_DOMAIN_set_logon_to_chgpass },
	{ discard_const_p(char, "unknown6"), py_netr_DELTA_DOMAIN_get_unknown6, py_netr_DELTA_DOMAIN_set_unknown6 },
	{ discard_const_p(char, "unknown7"), py_netr_DELTA_DOMAIN_get_unknown7, py_netr_DELTA_DOMAIN_set_unknown7 },
	{ discard_const_p(char, "unknown8"), py_netr_DELTA_DOMAIN_get_unknown8, py_netr_DELTA_DOMAIN_set_unknown8 },
	{ NULL }
};

static PyObject *py_netr_DELTA_DOMAIN_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_DELTA_DOMAIN, type);
}


static PyTypeObject netr_DELTA_DOMAIN_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_DELTA_DOMAIN",
	.tp_getset = py_netr_DELTA_DOMAIN_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_DELTA_DOMAIN_new,
};


static PyObject *py_netr_DELTA_GROUP_get_group_name(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)pytalloc_get_ptr(obj);
	PyObject *py_group_name;
	py_group_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->group_name);
	return py_group_name;
}

static int py_netr_DELTA_GROUP_set_group_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->group_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_get_rid(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)pytalloc_get_ptr(obj);
	PyObject *py_rid;
	py_rid = PyInt_FromLong(object->rid);
	return py_rid;
}

static int py_netr_DELTA_GROUP_set_rid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->rid = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_get_attributes(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)pytalloc_get_ptr(obj);
	PyObject *py_attributes;
	py_attributes = PyInt_FromLong(object->attributes);
	return py_attributes;
}

static int py_netr_DELTA_GROUP_set_attributes(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->attributes = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_get_description(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)pytalloc_get_ptr(obj);
	PyObject *py_description;
	py_description = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->description);
	return py_description;
}

static int py_netr_DELTA_GROUP_set_description(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->description = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_get_SecurityInformation(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)pytalloc_get_ptr(obj);
	PyObject *py_SecurityInformation;
	py_SecurityInformation = PyInt_FromLong(object->SecurityInformation);
	return py_SecurityInformation;
}

static int py_netr_DELTA_GROUP_set_SecurityInformation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->SecurityInformation = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_get_sdbuf(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)pytalloc_get_ptr(obj);
	PyObject *py_sdbuf;
	py_sdbuf = pytalloc_reference_ex(sec_desc_buf_Type, pytalloc_get_mem_ctx(obj), &object->sdbuf);
	return py_sdbuf;
}

static int py_netr_DELTA_GROUP_set_sdbuf(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(sec_desc_buf_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->sdbuf = *(struct sec_desc_buf *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_get_unknown1(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)pytalloc_get_ptr(obj);
	PyObject *py_unknown1;
	py_unknown1 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown1);
	return py_unknown1;
}

static int py_netr_DELTA_GROUP_set_unknown1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown1 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_get_unknown2(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)pytalloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown2);
	return py_unknown2;
}

static int py_netr_DELTA_GROUP_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown2 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_get_unknown3(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)pytalloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown3);
	return py_unknown3;
}

static int py_netr_DELTA_GROUP_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown3 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_get_unknown4(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)pytalloc_get_ptr(obj);
	PyObject *py_unknown4;
	py_unknown4 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown4);
	return py_unknown4;
}

static int py_netr_DELTA_GROUP_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown4 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_get_unknown5(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)pytalloc_get_ptr(obj);
	PyObject *py_unknown5;
	py_unknown5 = PyInt_FromLong(object->unknown5);
	return py_unknown5;
}

static int py_netr_DELTA_GROUP_set_unknown5(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown5 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_get_unknown6(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)pytalloc_get_ptr(obj);
	PyObject *py_unknown6;
	py_unknown6 = PyInt_FromLong(object->unknown6);
	return py_unknown6;
}

static int py_netr_DELTA_GROUP_set_unknown6(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown6 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_get_unknown7(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)pytalloc_get_ptr(obj);
	PyObject *py_unknown7;
	py_unknown7 = PyInt_FromLong(object->unknown7);
	return py_unknown7;
}

static int py_netr_DELTA_GROUP_set_unknown7(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown7 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_get_unknown8(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)pytalloc_get_ptr(obj);
	PyObject *py_unknown8;
	py_unknown8 = PyInt_FromLong(object->unknown8);
	return py_unknown8;
}

static int py_netr_DELTA_GROUP_set_unknown8(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP *object = (struct netr_DELTA_GROUP *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown8 = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_DELTA_GROUP_getsetters[] = {
	{ discard_const_p(char, "group_name"), py_netr_DELTA_GROUP_get_group_name, py_netr_DELTA_GROUP_set_group_name },
	{ discard_const_p(char, "rid"), py_netr_DELTA_GROUP_get_rid, py_netr_DELTA_GROUP_set_rid },
	{ discard_const_p(char, "attributes"), py_netr_DELTA_GROUP_get_attributes, py_netr_DELTA_GROUP_set_attributes },
	{ discard_const_p(char, "description"), py_netr_DELTA_GROUP_get_description, py_netr_DELTA_GROUP_set_description },
	{ discard_const_p(char, "SecurityInformation"), py_netr_DELTA_GROUP_get_SecurityInformation, py_netr_DELTA_GROUP_set_SecurityInformation },
	{ discard_const_p(char, "sdbuf"), py_netr_DELTA_GROUP_get_sdbuf, py_netr_DELTA_GROUP_set_sdbuf },
	{ discard_const_p(char, "unknown1"), py_netr_DELTA_GROUP_get_unknown1, py_netr_DELTA_GROUP_set_unknown1 },
	{ discard_const_p(char, "unknown2"), py_netr_DELTA_GROUP_get_unknown2, py_netr_DELTA_GROUP_set_unknown2 },
	{ discard_const_p(char, "unknown3"), py_netr_DELTA_GROUP_get_unknown3, py_netr_DELTA_GROUP_set_unknown3 },
	{ discard_const_p(char, "unknown4"), py_netr_DELTA_GROUP_get_unknown4, py_netr_DELTA_GROUP_set_unknown4 },
	{ discard_const_p(char, "unknown5"), py_netr_DELTA_GROUP_get_unknown5, py_netr_DELTA_GROUP_set_unknown5 },
	{ discard_const_p(char, "unknown6"), py_netr_DELTA_GROUP_get_unknown6, py_netr_DELTA_GROUP_set_unknown6 },
	{ discard_const_p(char, "unknown7"), py_netr_DELTA_GROUP_get_unknown7, py_netr_DELTA_GROUP_set_unknown7 },
	{ discard_const_p(char, "unknown8"), py_netr_DELTA_GROUP_get_unknown8, py_netr_DELTA_GROUP_set_unknown8 },
	{ NULL }
};

static PyObject *py_netr_DELTA_GROUP_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_DELTA_GROUP, type);
}


static PyTypeObject netr_DELTA_GROUP_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_DELTA_GROUP",
	.tp_getset = py_netr_DELTA_GROUP_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_DELTA_GROUP_new,
};


static PyObject *py_netr_DELTA_RENAME_get_OldName(PyObject *obj, void *closure)
{
	struct netr_DELTA_RENAME *object = (struct netr_DELTA_RENAME *)pytalloc_get_ptr(obj);
	PyObject *py_OldName;
	py_OldName = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->OldName);
	return py_OldName;
}

static int py_netr_DELTA_RENAME_set_OldName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_RENAME *object = (struct netr_DELTA_RENAME *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->OldName = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_RENAME_get_NewName(PyObject *obj, void *closure)
{
	struct netr_DELTA_RENAME *object = (struct netr_DELTA_RENAME *)pytalloc_get_ptr(obj);
	PyObject *py_NewName;
	py_NewName = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->NewName);
	return py_NewName;
}

static int py_netr_DELTA_RENAME_set_NewName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_RENAME *object = (struct netr_DELTA_RENAME *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->NewName = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_RENAME_get_unknown1(PyObject *obj, void *closure)
{
	struct netr_DELTA_RENAME *object = (struct netr_DELTA_RENAME *)pytalloc_get_ptr(obj);
	PyObject *py_unknown1;
	py_unknown1 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown1);
	return py_unknown1;
}

static int py_netr_DELTA_RENAME_set_unknown1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_RENAME *object = (struct netr_DELTA_RENAME *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown1 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_RENAME_get_unknown2(PyObject *obj, void *closure)
{
	struct netr_DELTA_RENAME *object = (struct netr_DELTA_RENAME *)pytalloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown2);
	return py_unknown2;
}

static int py_netr_DELTA_RENAME_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_RENAME *object = (struct netr_DELTA_RENAME *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown2 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_RENAME_get_unknown3(PyObject *obj, void *closure)
{
	struct netr_DELTA_RENAME *object = (struct netr_DELTA_RENAME *)pytalloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown3);
	return py_unknown3;
}

static int py_netr_DELTA_RENAME_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_RENAME *object = (struct netr_DELTA_RENAME *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown3 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_RENAME_get_unknown4(PyObject *obj, void *closure)
{
	struct netr_DELTA_RENAME *object = (struct netr_DELTA_RENAME *)pytalloc_get_ptr(obj);
	PyObject *py_unknown4;
	py_unknown4 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown4);
	return py_unknown4;
}

static int py_netr_DELTA_RENAME_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_RENAME *object = (struct netr_DELTA_RENAME *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown4 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_RENAME_get_unknown5(PyObject *obj, void *closure)
{
	struct netr_DELTA_RENAME *object = (struct netr_DELTA_RENAME *)pytalloc_get_ptr(obj);
	PyObject *py_unknown5;
	py_unknown5 = PyInt_FromLong(object->unknown5);
	return py_unknown5;
}

static int py_netr_DELTA_RENAME_set_unknown5(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_RENAME *object = (struct netr_DELTA_RENAME *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown5 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_RENAME_get_unknown6(PyObject *obj, void *closure)
{
	struct netr_DELTA_RENAME *object = (struct netr_DELTA_RENAME *)pytalloc_get_ptr(obj);
	PyObject *py_unknown6;
	py_unknown6 = PyInt_FromLong(object->unknown6);
	return py_unknown6;
}

static int py_netr_DELTA_RENAME_set_unknown6(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_RENAME *object = (struct netr_DELTA_RENAME *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown6 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_RENAME_get_unknown7(PyObject *obj, void *closure)
{
	struct netr_DELTA_RENAME *object = (struct netr_DELTA_RENAME *)pytalloc_get_ptr(obj);
	PyObject *py_unknown7;
	py_unknown7 = PyInt_FromLong(object->unknown7);
	return py_unknown7;
}

static int py_netr_DELTA_RENAME_set_unknown7(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_RENAME *object = (struct netr_DELTA_RENAME *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown7 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_RENAME_get_unknown8(PyObject *obj, void *closure)
{
	struct netr_DELTA_RENAME *object = (struct netr_DELTA_RENAME *)pytalloc_get_ptr(obj);
	PyObject *py_unknown8;
	py_unknown8 = PyInt_FromLong(object->unknown8);
	return py_unknown8;
}

static int py_netr_DELTA_RENAME_set_unknown8(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_RENAME *object = (struct netr_DELTA_RENAME *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown8 = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_DELTA_RENAME_getsetters[] = {
	{ discard_const_p(char, "OldName"), py_netr_DELTA_RENAME_get_OldName, py_netr_DELTA_RENAME_set_OldName },
	{ discard_const_p(char, "NewName"), py_netr_DELTA_RENAME_get_NewName, py_netr_DELTA_RENAME_set_NewName },
	{ discard_const_p(char, "unknown1"), py_netr_DELTA_RENAME_get_unknown1, py_netr_DELTA_RENAME_set_unknown1 },
	{ discard_const_p(char, "unknown2"), py_netr_DELTA_RENAME_get_unknown2, py_netr_DELTA_RENAME_set_unknown2 },
	{ discard_const_p(char, "unknown3"), py_netr_DELTA_RENAME_get_unknown3, py_netr_DELTA_RENAME_set_unknown3 },
	{ discard_const_p(char, "unknown4"), py_netr_DELTA_RENAME_get_unknown4, py_netr_DELTA_RENAME_set_unknown4 },
	{ discard_const_p(char, "unknown5"), py_netr_DELTA_RENAME_get_unknown5, py_netr_DELTA_RENAME_set_unknown5 },
	{ discard_const_p(char, "unknown6"), py_netr_DELTA_RENAME_get_unknown6, py_netr_DELTA_RENAME_set_unknown6 },
	{ discard_const_p(char, "unknown7"), py_netr_DELTA_RENAME_get_unknown7, py_netr_DELTA_RENAME_set_unknown7 },
	{ discard_const_p(char, "unknown8"), py_netr_DELTA_RENAME_get_unknown8, py_netr_DELTA_RENAME_set_unknown8 },
	{ NULL }
};

static PyObject *py_netr_DELTA_RENAME_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_DELTA_RENAME, type);
}


static PyTypeObject netr_DELTA_RENAME_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_DELTA_RENAME",
	.tp_getset = py_netr_DELTA_RENAME_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_DELTA_RENAME_new,
};


static PyObject *py_netr_DELTA_GROUP_MEMBER_get_rids(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP_MEMBER *object = (struct netr_DELTA_GROUP_MEMBER *)pytalloc_get_ptr(obj);
	PyObject *py_rids;
	if (object->rids == NULL) {
		py_rids = Py_None;
		Py_INCREF(py_rids);
	} else {
		py_rids = PyList_New(object->num_rids);
		if (py_rids == NULL) {
			return NULL;
		}
		{
			int rids_cntr_1;
			for (rids_cntr_1 = 0; rids_cntr_1 < object->num_rids; rids_cntr_1++) {
				PyObject *py_rids_1;
				py_rids_1 = PyInt_FromLong(object->rids[rids_cntr_1]);
				PyList_SetItem(py_rids, rids_cntr_1, py_rids_1);
			}
		}
	}
	return py_rids;
}

static int py_netr_DELTA_GROUP_MEMBER_set_rids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP_MEMBER *object = (struct netr_DELTA_GROUP_MEMBER *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->rids);
	if (value == Py_None) {
		object->rids = NULL;
	} else {
		object->rids = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int rids_cntr_1;
			object->rids = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->rids, PyList_GET_SIZE(value));
			if (!object->rids) { return -1;; }
			talloc_set_name_const(object->rids, "ARRAY: object->rids");
			for (rids_cntr_1 = 0; rids_cntr_1 < PyList_GET_SIZE(value); rids_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, rids_cntr_1), return -1;);
				object->rids[rids_cntr_1] = PyInt_AsLong(PyList_GET_ITEM(value, rids_cntr_1));
			}
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_MEMBER_get_attribs(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP_MEMBER *object = (struct netr_DELTA_GROUP_MEMBER *)pytalloc_get_ptr(obj);
	PyObject *py_attribs;
	if (object->attribs == NULL) {
		py_attribs = Py_None;
		Py_INCREF(py_attribs);
	} else {
		py_attribs = PyList_New(object->num_rids);
		if (py_attribs == NULL) {
			return NULL;
		}
		{
			int attribs_cntr_1;
			for (attribs_cntr_1 = 0; attribs_cntr_1 < object->num_rids; attribs_cntr_1++) {
				PyObject *py_attribs_1;
				py_attribs_1 = PyInt_FromLong(object->attribs[attribs_cntr_1]);
				PyList_SetItem(py_attribs, attribs_cntr_1, py_attribs_1);
			}
		}
	}
	return py_attribs;
}

static int py_netr_DELTA_GROUP_MEMBER_set_attribs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP_MEMBER *object = (struct netr_DELTA_GROUP_MEMBER *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->attribs);
	if (value == Py_None) {
		object->attribs = NULL;
	} else {
		object->attribs = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int attribs_cntr_1;
			object->attribs = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->attribs, PyList_GET_SIZE(value));
			if (!object->attribs) { return -1;; }
			talloc_set_name_const(object->attribs, "ARRAY: object->attribs");
			for (attribs_cntr_1 = 0; attribs_cntr_1 < PyList_GET_SIZE(value); attribs_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, attribs_cntr_1), return -1;);
				object->attribs[attribs_cntr_1] = PyInt_AsLong(PyList_GET_ITEM(value, attribs_cntr_1));
			}
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_MEMBER_get_num_rids(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP_MEMBER *object = (struct netr_DELTA_GROUP_MEMBER *)pytalloc_get_ptr(obj);
	PyObject *py_num_rids;
	py_num_rids = PyInt_FromLong(object->num_rids);
	return py_num_rids;
}

static int py_netr_DELTA_GROUP_MEMBER_set_num_rids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP_MEMBER *object = (struct netr_DELTA_GROUP_MEMBER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->num_rids = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_MEMBER_get_unknown1(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP_MEMBER *object = (struct netr_DELTA_GROUP_MEMBER *)pytalloc_get_ptr(obj);
	PyObject *py_unknown1;
	py_unknown1 = PyInt_FromLong(object->unknown1);
	return py_unknown1;
}

static int py_netr_DELTA_GROUP_MEMBER_set_unknown1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP_MEMBER *object = (struct netr_DELTA_GROUP_MEMBER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown1 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_MEMBER_get_unknown2(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP_MEMBER *object = (struct netr_DELTA_GROUP_MEMBER *)pytalloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = PyInt_FromLong(object->unknown2);
	return py_unknown2;
}

static int py_netr_DELTA_GROUP_MEMBER_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP_MEMBER *object = (struct netr_DELTA_GROUP_MEMBER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown2 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_MEMBER_get_unknown3(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP_MEMBER *object = (struct netr_DELTA_GROUP_MEMBER *)pytalloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = PyInt_FromLong(object->unknown3);
	return py_unknown3;
}

static int py_netr_DELTA_GROUP_MEMBER_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP_MEMBER *object = (struct netr_DELTA_GROUP_MEMBER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown3 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_GROUP_MEMBER_get_unknown4(PyObject *obj, void *closure)
{
	struct netr_DELTA_GROUP_MEMBER *object = (struct netr_DELTA_GROUP_MEMBER *)pytalloc_get_ptr(obj);
	PyObject *py_unknown4;
	py_unknown4 = PyInt_FromLong(object->unknown4);
	return py_unknown4;
}

static int py_netr_DELTA_GROUP_MEMBER_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_GROUP_MEMBER *object = (struct netr_DELTA_GROUP_MEMBER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown4 = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_DELTA_GROUP_MEMBER_getsetters[] = {
	{ discard_const_p(char, "rids"), py_netr_DELTA_GROUP_MEMBER_get_rids, py_netr_DELTA_GROUP_MEMBER_set_rids },
	{ discard_const_p(char, "attribs"), py_netr_DELTA_GROUP_MEMBER_get_attribs, py_netr_DELTA_GROUP_MEMBER_set_attribs },
	{ discard_const_p(char, "num_rids"), py_netr_DELTA_GROUP_MEMBER_get_num_rids, py_netr_DELTA_GROUP_MEMBER_set_num_rids },
	{ discard_const_p(char, "unknown1"), py_netr_DELTA_GROUP_MEMBER_get_unknown1, py_netr_DELTA_GROUP_MEMBER_set_unknown1 },
	{ discard_const_p(char, "unknown2"), py_netr_DELTA_GROUP_MEMBER_get_unknown2, py_netr_DELTA_GROUP_MEMBER_set_unknown2 },
	{ discard_const_p(char, "unknown3"), py_netr_DELTA_GROUP_MEMBER_get_unknown3, py_netr_DELTA_GROUP_MEMBER_set_unknown3 },
	{ discard_const_p(char, "unknown4"), py_netr_DELTA_GROUP_MEMBER_get_unknown4, py_netr_DELTA_GROUP_MEMBER_set_unknown4 },
	{ NULL }
};

static PyObject *py_netr_DELTA_GROUP_MEMBER_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_DELTA_GROUP_MEMBER, type);
}


static PyTypeObject netr_DELTA_GROUP_MEMBER_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_DELTA_GROUP_MEMBER",
	.tp_getset = py_netr_DELTA_GROUP_MEMBER_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_DELTA_GROUP_MEMBER_new,
};


static PyObject *py_netr_DELTA_ALIAS_get_alias_name(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS *object = (struct netr_DELTA_ALIAS *)pytalloc_get_ptr(obj);
	PyObject *py_alias_name;
	py_alias_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->alias_name);
	return py_alias_name;
}

static int py_netr_DELTA_ALIAS_set_alias_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS *object = (struct netr_DELTA_ALIAS *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->alias_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_ALIAS_get_rid(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS *object = (struct netr_DELTA_ALIAS *)pytalloc_get_ptr(obj);
	PyObject *py_rid;
	py_rid = PyInt_FromLong(object->rid);
	return py_rid;
}

static int py_netr_DELTA_ALIAS_set_rid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS *object = (struct netr_DELTA_ALIAS *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->rid = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_ALIAS_get_SecurityInformation(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS *object = (struct netr_DELTA_ALIAS *)pytalloc_get_ptr(obj);
	PyObject *py_SecurityInformation;
	py_SecurityInformation = PyInt_FromLong(object->SecurityInformation);
	return py_SecurityInformation;
}

static int py_netr_DELTA_ALIAS_set_SecurityInformation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS *object = (struct netr_DELTA_ALIAS *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->SecurityInformation = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_ALIAS_get_sdbuf(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS *object = (struct netr_DELTA_ALIAS *)pytalloc_get_ptr(obj);
	PyObject *py_sdbuf;
	py_sdbuf = pytalloc_reference_ex(sec_desc_buf_Type, pytalloc_get_mem_ctx(obj), &object->sdbuf);
	return py_sdbuf;
}

static int py_netr_DELTA_ALIAS_set_sdbuf(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS *object = (struct netr_DELTA_ALIAS *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(sec_desc_buf_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->sdbuf = *(struct sec_desc_buf *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_ALIAS_get_description(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS *object = (struct netr_DELTA_ALIAS *)pytalloc_get_ptr(obj);
	PyObject *py_description;
	py_description = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->description);
	return py_description;
}

static int py_netr_DELTA_ALIAS_set_description(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS *object = (struct netr_DELTA_ALIAS *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->description = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_ALIAS_get_unknown2(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS *object = (struct netr_DELTA_ALIAS *)pytalloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown2);
	return py_unknown2;
}

static int py_netr_DELTA_ALIAS_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS *object = (struct netr_DELTA_ALIAS *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown2 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_ALIAS_get_unknown3(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS *object = (struct netr_DELTA_ALIAS *)pytalloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown3);
	return py_unknown3;
}

static int py_netr_DELTA_ALIAS_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS *object = (struct netr_DELTA_ALIAS *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown3 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_ALIAS_get_unknown4(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS *object = (struct netr_DELTA_ALIAS *)pytalloc_get_ptr(obj);
	PyObject *py_unknown4;
	py_unknown4 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown4);
	return py_unknown4;
}

static int py_netr_DELTA_ALIAS_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS *object = (struct netr_DELTA_ALIAS *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown4 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_ALIAS_get_unknown5(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS *object = (struct netr_DELTA_ALIAS *)pytalloc_get_ptr(obj);
	PyObject *py_unknown5;
	py_unknown5 = PyInt_FromLong(object->unknown5);
	return py_unknown5;
}

static int py_netr_DELTA_ALIAS_set_unknown5(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS *object = (struct netr_DELTA_ALIAS *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown5 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_ALIAS_get_unknown6(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS *object = (struct netr_DELTA_ALIAS *)pytalloc_get_ptr(obj);
	PyObject *py_unknown6;
	py_unknown6 = PyInt_FromLong(object->unknown6);
	return py_unknown6;
}

static int py_netr_DELTA_ALIAS_set_unknown6(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS *object = (struct netr_DELTA_ALIAS *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown6 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_ALIAS_get_unknown7(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS *object = (struct netr_DELTA_ALIAS *)pytalloc_get_ptr(obj);
	PyObject *py_unknown7;
	py_unknown7 = PyInt_FromLong(object->unknown7);
	return py_unknown7;
}

static int py_netr_DELTA_ALIAS_set_unknown7(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS *object = (struct netr_DELTA_ALIAS *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown7 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_ALIAS_get_unknown8(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS *object = (struct netr_DELTA_ALIAS *)pytalloc_get_ptr(obj);
	PyObject *py_unknown8;
	py_unknown8 = PyInt_FromLong(object->unknown8);
	return py_unknown8;
}

static int py_netr_DELTA_ALIAS_set_unknown8(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS *object = (struct netr_DELTA_ALIAS *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown8 = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_DELTA_ALIAS_getsetters[] = {
	{ discard_const_p(char, "alias_name"), py_netr_DELTA_ALIAS_get_alias_name, py_netr_DELTA_ALIAS_set_alias_name },
	{ discard_const_p(char, "rid"), py_netr_DELTA_ALIAS_get_rid, py_netr_DELTA_ALIAS_set_rid },
	{ discard_const_p(char, "SecurityInformation"), py_netr_DELTA_ALIAS_get_SecurityInformation, py_netr_DELTA_ALIAS_set_SecurityInformation },
	{ discard_const_p(char, "sdbuf"), py_netr_DELTA_ALIAS_get_sdbuf, py_netr_DELTA_ALIAS_set_sdbuf },
	{ discard_const_p(char, "description"), py_netr_DELTA_ALIAS_get_description, py_netr_DELTA_ALIAS_set_description },
	{ discard_const_p(char, "unknown2"), py_netr_DELTA_ALIAS_get_unknown2, py_netr_DELTA_ALIAS_set_unknown2 },
	{ discard_const_p(char, "unknown3"), py_netr_DELTA_ALIAS_get_unknown3, py_netr_DELTA_ALIAS_set_unknown3 },
	{ discard_const_p(char, "unknown4"), py_netr_DELTA_ALIAS_get_unknown4, py_netr_DELTA_ALIAS_set_unknown4 },
	{ discard_const_p(char, "unknown5"), py_netr_DELTA_ALIAS_get_unknown5, py_netr_DELTA_ALIAS_set_unknown5 },
	{ discard_const_p(char, "unknown6"), py_netr_DELTA_ALIAS_get_unknown6, py_netr_DELTA_ALIAS_set_unknown6 },
	{ discard_const_p(char, "unknown7"), py_netr_DELTA_ALIAS_get_unknown7, py_netr_DELTA_ALIAS_set_unknown7 },
	{ discard_const_p(char, "unknown8"), py_netr_DELTA_ALIAS_get_unknown8, py_netr_DELTA_ALIAS_set_unknown8 },
	{ NULL }
};

static PyObject *py_netr_DELTA_ALIAS_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_DELTA_ALIAS, type);
}


static PyTypeObject netr_DELTA_ALIAS_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_DELTA_ALIAS",
	.tp_getset = py_netr_DELTA_ALIAS_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_DELTA_ALIAS_new,
};


static PyObject *py_netr_DELTA_ALIAS_MEMBER_get_sids(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS_MEMBER *object = (struct netr_DELTA_ALIAS_MEMBER *)pytalloc_get_ptr(obj);
	PyObject *py_sids;
	py_sids = pytalloc_reference_ex(lsa_SidArray_Type, pytalloc_get_mem_ctx(obj), &object->sids);
	return py_sids;
}

static int py_netr_DELTA_ALIAS_MEMBER_set_sids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS_MEMBER *object = (struct netr_DELTA_ALIAS_MEMBER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_SidArray_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->sids = *(struct lsa_SidArray *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_ALIAS_MEMBER_get_unknown1(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS_MEMBER *object = (struct netr_DELTA_ALIAS_MEMBER *)pytalloc_get_ptr(obj);
	PyObject *py_unknown1;
	py_unknown1 = PyInt_FromLong(object->unknown1);
	return py_unknown1;
}

static int py_netr_DELTA_ALIAS_MEMBER_set_unknown1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS_MEMBER *object = (struct netr_DELTA_ALIAS_MEMBER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown1 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_ALIAS_MEMBER_get_unknown2(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS_MEMBER *object = (struct netr_DELTA_ALIAS_MEMBER *)pytalloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = PyInt_FromLong(object->unknown2);
	return py_unknown2;
}

static int py_netr_DELTA_ALIAS_MEMBER_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS_MEMBER *object = (struct netr_DELTA_ALIAS_MEMBER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown2 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_ALIAS_MEMBER_get_unknown3(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS_MEMBER *object = (struct netr_DELTA_ALIAS_MEMBER *)pytalloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = PyInt_FromLong(object->unknown3);
	return py_unknown3;
}

static int py_netr_DELTA_ALIAS_MEMBER_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS_MEMBER *object = (struct netr_DELTA_ALIAS_MEMBER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown3 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_ALIAS_MEMBER_get_unknown4(PyObject *obj, void *closure)
{
	struct netr_DELTA_ALIAS_MEMBER *object = (struct netr_DELTA_ALIAS_MEMBER *)pytalloc_get_ptr(obj);
	PyObject *py_unknown4;
	py_unknown4 = PyInt_FromLong(object->unknown4);
	return py_unknown4;
}

static int py_netr_DELTA_ALIAS_MEMBER_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ALIAS_MEMBER *object = (struct netr_DELTA_ALIAS_MEMBER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown4 = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_DELTA_ALIAS_MEMBER_getsetters[] = {
	{ discard_const_p(char, "sids"), py_netr_DELTA_ALIAS_MEMBER_get_sids, py_netr_DELTA_ALIAS_MEMBER_set_sids },
	{ discard_const_p(char, "unknown1"), py_netr_DELTA_ALIAS_MEMBER_get_unknown1, py_netr_DELTA_ALIAS_MEMBER_set_unknown1 },
	{ discard_const_p(char, "unknown2"), py_netr_DELTA_ALIAS_MEMBER_get_unknown2, py_netr_DELTA_ALIAS_MEMBER_set_unknown2 },
	{ discard_const_p(char, "unknown3"), py_netr_DELTA_ALIAS_MEMBER_get_unknown3, py_netr_DELTA_ALIAS_MEMBER_set_unknown3 },
	{ discard_const_p(char, "unknown4"), py_netr_DELTA_ALIAS_MEMBER_get_unknown4, py_netr_DELTA_ALIAS_MEMBER_set_unknown4 },
	{ NULL }
};

static PyObject *py_netr_DELTA_ALIAS_MEMBER_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_DELTA_ALIAS_MEMBER, type);
}


static PyTypeObject netr_DELTA_ALIAS_MEMBER_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_DELTA_ALIAS_MEMBER",
	.tp_getset = py_netr_DELTA_ALIAS_MEMBER_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_DELTA_ALIAS_MEMBER_new,
};


static PyObject *py_netr_QUOTA_LIMITS_get_pagedpoollimit(PyObject *obj, void *closure)
{
	struct netr_QUOTA_LIMITS *object = (struct netr_QUOTA_LIMITS *)pytalloc_get_ptr(obj);
	PyObject *py_pagedpoollimit;
	py_pagedpoollimit = PyInt_FromLong(object->pagedpoollimit);
	return py_pagedpoollimit;
}

static int py_netr_QUOTA_LIMITS_set_pagedpoollimit(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_QUOTA_LIMITS *object = (struct netr_QUOTA_LIMITS *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->pagedpoollimit = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_QUOTA_LIMITS_get_nonpagedpoollimit(PyObject *obj, void *closure)
{
	struct netr_QUOTA_LIMITS *object = (struct netr_QUOTA_LIMITS *)pytalloc_get_ptr(obj);
	PyObject *py_nonpagedpoollimit;
	py_nonpagedpoollimit = PyInt_FromLong(object->nonpagedpoollimit);
	return py_nonpagedpoollimit;
}

static int py_netr_QUOTA_LIMITS_set_nonpagedpoollimit(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_QUOTA_LIMITS *object = (struct netr_QUOTA_LIMITS *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->nonpagedpoollimit = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_QUOTA_LIMITS_get_minimumworkingsetsize(PyObject *obj, void *closure)
{
	struct netr_QUOTA_LIMITS *object = (struct netr_QUOTA_LIMITS *)pytalloc_get_ptr(obj);
	PyObject *py_minimumworkingsetsize;
	py_minimumworkingsetsize = PyInt_FromLong(object->minimumworkingsetsize);
	return py_minimumworkingsetsize;
}

static int py_netr_QUOTA_LIMITS_set_minimumworkingsetsize(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_QUOTA_LIMITS *object = (struct netr_QUOTA_LIMITS *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->minimumworkingsetsize = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_QUOTA_LIMITS_get_maximumworkingsetsize(PyObject *obj, void *closure)
{
	struct netr_QUOTA_LIMITS *object = (struct netr_QUOTA_LIMITS *)pytalloc_get_ptr(obj);
	PyObject *py_maximumworkingsetsize;
	py_maximumworkingsetsize = PyInt_FromLong(object->maximumworkingsetsize);
	return py_maximumworkingsetsize;
}

static int py_netr_QUOTA_LIMITS_set_maximumworkingsetsize(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_QUOTA_LIMITS *object = (struct netr_QUOTA_LIMITS *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->maximumworkingsetsize = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_QUOTA_LIMITS_get_pagefilelimit(PyObject *obj, void *closure)
{
	struct netr_QUOTA_LIMITS *object = (struct netr_QUOTA_LIMITS *)pytalloc_get_ptr(obj);
	PyObject *py_pagefilelimit;
	py_pagefilelimit = PyInt_FromLong(object->pagefilelimit);
	return py_pagefilelimit;
}

static int py_netr_QUOTA_LIMITS_set_pagefilelimit(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_QUOTA_LIMITS *object = (struct netr_QUOTA_LIMITS *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->pagefilelimit = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_QUOTA_LIMITS_get_timelimit(PyObject *obj, void *closure)
{
	struct netr_QUOTA_LIMITS *object = (struct netr_QUOTA_LIMITS *)pytalloc_get_ptr(obj);
	PyObject *py_timelimit;
	py_timelimit = PyLong_FromLongLong(object->timelimit);
	return py_timelimit;
}

static int py_netr_QUOTA_LIMITS_set_timelimit(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_QUOTA_LIMITS *object = (struct netr_QUOTA_LIMITS *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->timelimit = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->timelimit = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyGetSetDef py_netr_QUOTA_LIMITS_getsetters[] = {
	{ discard_const_p(char, "pagedpoollimit"), py_netr_QUOTA_LIMITS_get_pagedpoollimit, py_netr_QUOTA_LIMITS_set_pagedpoollimit },
	{ discard_const_p(char, "nonpagedpoollimit"), py_netr_QUOTA_LIMITS_get_nonpagedpoollimit, py_netr_QUOTA_LIMITS_set_nonpagedpoollimit },
	{ discard_const_p(char, "minimumworkingsetsize"), py_netr_QUOTA_LIMITS_get_minimumworkingsetsize, py_netr_QUOTA_LIMITS_set_minimumworkingsetsize },
	{ discard_const_p(char, "maximumworkingsetsize"), py_netr_QUOTA_LIMITS_get_maximumworkingsetsize, py_netr_QUOTA_LIMITS_set_maximumworkingsetsize },
	{ discard_const_p(char, "pagefilelimit"), py_netr_QUOTA_LIMITS_get_pagefilelimit, py_netr_QUOTA_LIMITS_set_pagefilelimit },
	{ discard_const_p(char, "timelimit"), py_netr_QUOTA_LIMITS_get_timelimit, py_netr_QUOTA_LIMITS_set_timelimit },
	{ NULL }
};

static PyObject *py_netr_QUOTA_LIMITS_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_QUOTA_LIMITS, type);
}


static PyTypeObject netr_QUOTA_LIMITS_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_QUOTA_LIMITS",
	.tp_getset = py_netr_QUOTA_LIMITS_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_QUOTA_LIMITS_new,
};


static PyObject *py_netr_DELTA_POLICY_get_maxlogsize(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)pytalloc_get_ptr(obj);
	PyObject *py_maxlogsize;
	py_maxlogsize = PyInt_FromLong(object->maxlogsize);
	return py_maxlogsize;
}

static int py_netr_DELTA_POLICY_set_maxlogsize(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->maxlogsize = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_auditretentionperiod(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)pytalloc_get_ptr(obj);
	PyObject *py_auditretentionperiod;
	py_auditretentionperiod = PyLong_FromLongLong(object->auditretentionperiod);
	return py_auditretentionperiod;
}

static int py_netr_DELTA_POLICY_set_auditretentionperiod(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->auditretentionperiod = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->auditretentionperiod = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_auditingmode(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)pytalloc_get_ptr(obj);
	PyObject *py_auditingmode;
	py_auditingmode = PyInt_FromLong(object->auditingmode);
	return py_auditingmode;
}

static int py_netr_DELTA_POLICY_set_auditingmode(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->auditingmode = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_maxauditeventcount(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)pytalloc_get_ptr(obj);
	PyObject *py_maxauditeventcount;
	py_maxauditeventcount = PyInt_FromLong(object->maxauditeventcount);
	return py_maxauditeventcount;
}

static int py_netr_DELTA_POLICY_set_maxauditeventcount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->maxauditeventcount = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_eventauditoptions(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)pytalloc_get_ptr(obj);
	PyObject *py_eventauditoptions;
	if (object->eventauditoptions == NULL) {
		py_eventauditoptions = Py_None;
		Py_INCREF(py_eventauditoptions);
	} else {
		py_eventauditoptions = PyList_New(object->maxauditeventcount + 1);
		if (py_eventauditoptions == NULL) {
			return NULL;
		}
		{
			int eventauditoptions_cntr_1;
			for (eventauditoptions_cntr_1 = 0; eventauditoptions_cntr_1 < object->maxauditeventcount + 1; eventauditoptions_cntr_1++) {
				PyObject *py_eventauditoptions_1;
				py_eventauditoptions_1 = PyInt_FromLong(object->eventauditoptions[eventauditoptions_cntr_1]);
				PyList_SetItem(py_eventauditoptions, eventauditoptions_cntr_1, py_eventauditoptions_1);
			}
		}
	}
	return py_eventauditoptions;
}

static int py_netr_DELTA_POLICY_set_eventauditoptions(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->eventauditoptions);
	if (value == Py_None) {
		object->eventauditoptions = NULL;
	} else {
		object->eventauditoptions = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int eventauditoptions_cntr_1;
			object->eventauditoptions = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->eventauditoptions, PyList_GET_SIZE(value));
			if (!object->eventauditoptions) { return -1;; }
			talloc_set_name_const(object->eventauditoptions, "ARRAY: object->eventauditoptions");
			for (eventauditoptions_cntr_1 = 0; eventauditoptions_cntr_1 < PyList_GET_SIZE(value); eventauditoptions_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, eventauditoptions_cntr_1), return -1;);
				object->eventauditoptions[eventauditoptions_cntr_1] = PyInt_AsLong(PyList_GET_ITEM(value, eventauditoptions_cntr_1));
			}
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_primary_domain_name(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)pytalloc_get_ptr(obj);
	PyObject *py_primary_domain_name;
	py_primary_domain_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->primary_domain_name);
	return py_primary_domain_name;
}

static int py_netr_DELTA_POLICY_set_primary_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->primary_domain_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_sid(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)pytalloc_get_ptr(obj);
	PyObject *py_sid;
	if (object->sid == NULL) {
		py_sid = Py_None;
		Py_INCREF(py_sid);
	} else {
		py_sid = pytalloc_reference_ex(dom_sid_Type, object->sid, object->sid);
	}
	return py_sid;
}

static int py_netr_DELTA_POLICY_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->sid);
	if (value == Py_None) {
		object->sid = NULL;
	} else {
		object->sid = NULL;
		PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->sid = (struct dom_sid *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_quota_limits(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)pytalloc_get_ptr(obj);
	PyObject *py_quota_limits;
	py_quota_limits = pytalloc_reference_ex(&netr_QUOTA_LIMITS_Type, pytalloc_get_mem_ctx(obj), &object->quota_limits);
	return py_quota_limits;
}

static int py_netr_DELTA_POLICY_set_quota_limits(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_QUOTA_LIMITS_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->quota_limits = *(struct netr_QUOTA_LIMITS *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_sequence_num(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)pytalloc_get_ptr(obj);
	PyObject *py_sequence_num;
	py_sequence_num = PyLong_FromLongLong(object->sequence_num);
	return py_sequence_num;
}

static int py_netr_DELTA_POLICY_set_sequence_num(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->sequence_num = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->sequence_num = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_db_create_time(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)pytalloc_get_ptr(obj);
	PyObject *py_db_create_time;
	py_db_create_time = PyLong_FromLongLong(object->db_create_time);
	return py_db_create_time;
}

static int py_netr_DELTA_POLICY_set_db_create_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->db_create_time = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->db_create_time = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_SecurityInformation(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)pytalloc_get_ptr(obj);
	PyObject *py_SecurityInformation;
	py_SecurityInformation = PyInt_FromLong(object->SecurityInformation);
	return py_SecurityInformation;
}

static int py_netr_DELTA_POLICY_set_SecurityInformation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->SecurityInformation = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_sdbuf(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)pytalloc_get_ptr(obj);
	PyObject *py_sdbuf;
	py_sdbuf = pytalloc_reference_ex(sec_desc_buf_Type, pytalloc_get_mem_ctx(obj), &object->sdbuf);
	return py_sdbuf;
}

static int py_netr_DELTA_POLICY_set_sdbuf(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(sec_desc_buf_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->sdbuf = *(struct sec_desc_buf *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_unknown1(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)pytalloc_get_ptr(obj);
	PyObject *py_unknown1;
	py_unknown1 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown1);
	return py_unknown1;
}

static int py_netr_DELTA_POLICY_set_unknown1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown1 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_unknown2(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)pytalloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown2);
	return py_unknown2;
}

static int py_netr_DELTA_POLICY_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown2 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_unknown3(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)pytalloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown3);
	return py_unknown3;
}

static int py_netr_DELTA_POLICY_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown3 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_unknown4(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)pytalloc_get_ptr(obj);
	PyObject *py_unknown4;
	py_unknown4 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown4);
	return py_unknown4;
}

static int py_netr_DELTA_POLICY_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown4 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_unknown5(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)pytalloc_get_ptr(obj);
	PyObject *py_unknown5;
	py_unknown5 = PyInt_FromLong(object->unknown5);
	return py_unknown5;
}

static int py_netr_DELTA_POLICY_set_unknown5(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown5 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_unknown6(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)pytalloc_get_ptr(obj);
	PyObject *py_unknown6;
	py_unknown6 = PyInt_FromLong(object->unknown6);
	return py_unknown6;
}

static int py_netr_DELTA_POLICY_set_unknown6(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown6 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_unknown7(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)pytalloc_get_ptr(obj);
	PyObject *py_unknown7;
	py_unknown7 = PyInt_FromLong(object->unknown7);
	return py_unknown7;
}

static int py_netr_DELTA_POLICY_set_unknown7(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown7 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_POLICY_get_unknown8(PyObject *obj, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)pytalloc_get_ptr(obj);
	PyObject *py_unknown8;
	py_unknown8 = PyInt_FromLong(object->unknown8);
	return py_unknown8;
}

static int py_netr_DELTA_POLICY_set_unknown8(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_POLICY *object = (struct netr_DELTA_POLICY *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown8 = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_DELTA_POLICY_getsetters[] = {
	{ discard_const_p(char, "maxlogsize"), py_netr_DELTA_POLICY_get_maxlogsize, py_netr_DELTA_POLICY_set_maxlogsize },
	{ discard_const_p(char, "auditretentionperiod"), py_netr_DELTA_POLICY_get_auditretentionperiod, py_netr_DELTA_POLICY_set_auditretentionperiod },
	{ discard_const_p(char, "auditingmode"), py_netr_DELTA_POLICY_get_auditingmode, py_netr_DELTA_POLICY_set_auditingmode },
	{ discard_const_p(char, "maxauditeventcount"), py_netr_DELTA_POLICY_get_maxauditeventcount, py_netr_DELTA_POLICY_set_maxauditeventcount },
	{ discard_const_p(char, "eventauditoptions"), py_netr_DELTA_POLICY_get_eventauditoptions, py_netr_DELTA_POLICY_set_eventauditoptions },
	{ discard_const_p(char, "primary_domain_name"), py_netr_DELTA_POLICY_get_primary_domain_name, py_netr_DELTA_POLICY_set_primary_domain_name },
	{ discard_const_p(char, "sid"), py_netr_DELTA_POLICY_get_sid, py_netr_DELTA_POLICY_set_sid },
	{ discard_const_p(char, "quota_limits"), py_netr_DELTA_POLICY_get_quota_limits, py_netr_DELTA_POLICY_set_quota_limits },
	{ discard_const_p(char, "sequence_num"), py_netr_DELTA_POLICY_get_sequence_num, py_netr_DELTA_POLICY_set_sequence_num },
	{ discard_const_p(char, "db_create_time"), py_netr_DELTA_POLICY_get_db_create_time, py_netr_DELTA_POLICY_set_db_create_time },
	{ discard_const_p(char, "SecurityInformation"), py_netr_DELTA_POLICY_get_SecurityInformation, py_netr_DELTA_POLICY_set_SecurityInformation },
	{ discard_const_p(char, "sdbuf"), py_netr_DELTA_POLICY_get_sdbuf, py_netr_DELTA_POLICY_set_sdbuf },
	{ discard_const_p(char, "unknown1"), py_netr_DELTA_POLICY_get_unknown1, py_netr_DELTA_POLICY_set_unknown1 },
	{ discard_const_p(char, "unknown2"), py_netr_DELTA_POLICY_get_unknown2, py_netr_DELTA_POLICY_set_unknown2 },
	{ discard_const_p(char, "unknown3"), py_netr_DELTA_POLICY_get_unknown3, py_netr_DELTA_POLICY_set_unknown3 },
	{ discard_const_p(char, "unknown4"), py_netr_DELTA_POLICY_get_unknown4, py_netr_DELTA_POLICY_set_unknown4 },
	{ discard_const_p(char, "unknown5"), py_netr_DELTA_POLICY_get_unknown5, py_netr_DELTA_POLICY_set_unknown5 },
	{ discard_const_p(char, "unknown6"), py_netr_DELTA_POLICY_get_unknown6, py_netr_DELTA_POLICY_set_unknown6 },
	{ discard_const_p(char, "unknown7"), py_netr_DELTA_POLICY_get_unknown7, py_netr_DELTA_POLICY_set_unknown7 },
	{ discard_const_p(char, "unknown8"), py_netr_DELTA_POLICY_get_unknown8, py_netr_DELTA_POLICY_set_unknown8 },
	{ NULL }
};

static PyObject *py_netr_DELTA_POLICY_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_DELTA_POLICY, type);
}


static PyTypeObject netr_DELTA_POLICY_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_DELTA_POLICY",
	.tp_getset = py_netr_DELTA_POLICY_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_DELTA_POLICY_new,
};


static PyObject *py_netr_DELTA_TRUSTED_DOMAIN_get_domain_name(PyObject *obj, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)pytalloc_get_ptr(obj);
	PyObject *py_domain_name;
	py_domain_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->domain_name);
	return py_domain_name;
}

static int py_netr_DELTA_TRUSTED_DOMAIN_set_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->domain_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_TRUSTED_DOMAIN_get_num_controllers(PyObject *obj, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)pytalloc_get_ptr(obj);
	PyObject *py_num_controllers;
	py_num_controllers = PyInt_FromLong(object->num_controllers);
	return py_num_controllers;
}

static int py_netr_DELTA_TRUSTED_DOMAIN_set_num_controllers(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->num_controllers = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_TRUSTED_DOMAIN_get_controller_names(PyObject *obj, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)pytalloc_get_ptr(obj);
	PyObject *py_controller_names;
	if (object->controller_names == NULL) {
		py_controller_names = Py_None;
		Py_INCREF(py_controller_names);
	} else {
		py_controller_names = PyList_New(object->num_controllers);
		if (py_controller_names == NULL) {
			return NULL;
		}
		{
			int controller_names_cntr_1;
			for (controller_names_cntr_1 = 0; controller_names_cntr_1 < object->num_controllers; controller_names_cntr_1++) {
				PyObject *py_controller_names_1;
				py_controller_names_1 = pytalloc_reference_ex(lsa_String_Type, object->controller_names, &object->controller_names[controller_names_cntr_1]);
				PyList_SetItem(py_controller_names, controller_names_cntr_1, py_controller_names_1);
			}
		}
	}
	return py_controller_names;
}

static int py_netr_DELTA_TRUSTED_DOMAIN_set_controller_names(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->controller_names);
	if (value == Py_None) {
		object->controller_names = NULL;
	} else {
		object->controller_names = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int controller_names_cntr_1;
			object->controller_names = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->controller_names, PyList_GET_SIZE(value));
			if (!object->controller_names) { return -1;; }
			talloc_set_name_const(object->controller_names, "ARRAY: object->controller_names");
			for (controller_names_cntr_1 = 0; controller_names_cntr_1 < PyList_GET_SIZE(value); controller_names_cntr_1++) {
				PY_CHECK_TYPE(lsa_String_Type, PyList_GET_ITEM(value, controller_names_cntr_1), return -1;);
				if (talloc_reference(object->controller_names, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, controller_names_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				object->controller_names[controller_names_cntr_1] = *(struct lsa_String *)pytalloc_get_ptr(PyList_GET_ITEM(value, controller_names_cntr_1));
			}
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_TRUSTED_DOMAIN_get_SecurityInformation(PyObject *obj, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)pytalloc_get_ptr(obj);
	PyObject *py_SecurityInformation;
	py_SecurityInformation = PyInt_FromLong(object->SecurityInformation);
	return py_SecurityInformation;
}

static int py_netr_DELTA_TRUSTED_DOMAIN_set_SecurityInformation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->SecurityInformation = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_TRUSTED_DOMAIN_get_sdbuf(PyObject *obj, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)pytalloc_get_ptr(obj);
	PyObject *py_sdbuf;
	py_sdbuf = pytalloc_reference_ex(sec_desc_buf_Type, pytalloc_get_mem_ctx(obj), &object->sdbuf);
	return py_sdbuf;
}

static int py_netr_DELTA_TRUSTED_DOMAIN_set_sdbuf(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(sec_desc_buf_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->sdbuf = *(struct sec_desc_buf *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_TRUSTED_DOMAIN_get_unknown1(PyObject *obj, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)pytalloc_get_ptr(obj);
	PyObject *py_unknown1;
	py_unknown1 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown1);
	return py_unknown1;
}

static int py_netr_DELTA_TRUSTED_DOMAIN_set_unknown1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown1 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_TRUSTED_DOMAIN_get_unknown2(PyObject *obj, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)pytalloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown2);
	return py_unknown2;
}

static int py_netr_DELTA_TRUSTED_DOMAIN_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown2 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_TRUSTED_DOMAIN_get_unknown3(PyObject *obj, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)pytalloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown3);
	return py_unknown3;
}

static int py_netr_DELTA_TRUSTED_DOMAIN_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown3 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_TRUSTED_DOMAIN_get_unknown4(PyObject *obj, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)pytalloc_get_ptr(obj);
	PyObject *py_unknown4;
	py_unknown4 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown4);
	return py_unknown4;
}

static int py_netr_DELTA_TRUSTED_DOMAIN_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown4 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_TRUSTED_DOMAIN_get_posix_offset(PyObject *obj, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)pytalloc_get_ptr(obj);
	PyObject *py_posix_offset;
	py_posix_offset = PyInt_FromLong(object->posix_offset);
	return py_posix_offset;
}

static int py_netr_DELTA_TRUSTED_DOMAIN_set_posix_offset(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->posix_offset = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_TRUSTED_DOMAIN_get_unknown6(PyObject *obj, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)pytalloc_get_ptr(obj);
	PyObject *py_unknown6;
	py_unknown6 = PyInt_FromLong(object->unknown6);
	return py_unknown6;
}

static int py_netr_DELTA_TRUSTED_DOMAIN_set_unknown6(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown6 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_TRUSTED_DOMAIN_get_unknown7(PyObject *obj, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)pytalloc_get_ptr(obj);
	PyObject *py_unknown7;
	py_unknown7 = PyInt_FromLong(object->unknown7);
	return py_unknown7;
}

static int py_netr_DELTA_TRUSTED_DOMAIN_set_unknown7(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown7 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_TRUSTED_DOMAIN_get_unknown8(PyObject *obj, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)pytalloc_get_ptr(obj);
	PyObject *py_unknown8;
	py_unknown8 = PyInt_FromLong(object->unknown8);
	return py_unknown8;
}

static int py_netr_DELTA_TRUSTED_DOMAIN_set_unknown8(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_TRUSTED_DOMAIN *object = (struct netr_DELTA_TRUSTED_DOMAIN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown8 = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_DELTA_TRUSTED_DOMAIN_getsetters[] = {
	{ discard_const_p(char, "domain_name"), py_netr_DELTA_TRUSTED_DOMAIN_get_domain_name, py_netr_DELTA_TRUSTED_DOMAIN_set_domain_name },
	{ discard_const_p(char, "num_controllers"), py_netr_DELTA_TRUSTED_DOMAIN_get_num_controllers, py_netr_DELTA_TRUSTED_DOMAIN_set_num_controllers },
	{ discard_const_p(char, "controller_names"), py_netr_DELTA_TRUSTED_DOMAIN_get_controller_names, py_netr_DELTA_TRUSTED_DOMAIN_set_controller_names },
	{ discard_const_p(char, "SecurityInformation"), py_netr_DELTA_TRUSTED_DOMAIN_get_SecurityInformation, py_netr_DELTA_TRUSTED_DOMAIN_set_SecurityInformation },
	{ discard_const_p(char, "sdbuf"), py_netr_DELTA_TRUSTED_DOMAIN_get_sdbuf, py_netr_DELTA_TRUSTED_DOMAIN_set_sdbuf },
	{ discard_const_p(char, "unknown1"), py_netr_DELTA_TRUSTED_DOMAIN_get_unknown1, py_netr_DELTA_TRUSTED_DOMAIN_set_unknown1 },
	{ discard_const_p(char, "unknown2"), py_netr_DELTA_TRUSTED_DOMAIN_get_unknown2, py_netr_DELTA_TRUSTED_DOMAIN_set_unknown2 },
	{ discard_const_p(char, "unknown3"), py_netr_DELTA_TRUSTED_DOMAIN_get_unknown3, py_netr_DELTA_TRUSTED_DOMAIN_set_unknown3 },
	{ discard_const_p(char, "unknown4"), py_netr_DELTA_TRUSTED_DOMAIN_get_unknown4, py_netr_DELTA_TRUSTED_DOMAIN_set_unknown4 },
	{ discard_const_p(char, "posix_offset"), py_netr_DELTA_TRUSTED_DOMAIN_get_posix_offset, py_netr_DELTA_TRUSTED_DOMAIN_set_posix_offset },
	{ discard_const_p(char, "unknown6"), py_netr_DELTA_TRUSTED_DOMAIN_get_unknown6, py_netr_DELTA_TRUSTED_DOMAIN_set_unknown6 },
	{ discard_const_p(char, "unknown7"), py_netr_DELTA_TRUSTED_DOMAIN_get_unknown7, py_netr_DELTA_TRUSTED_DOMAIN_set_unknown7 },
	{ discard_const_p(char, "unknown8"), py_netr_DELTA_TRUSTED_DOMAIN_get_unknown8, py_netr_DELTA_TRUSTED_DOMAIN_set_unknown8 },
	{ NULL }
};

static PyObject *py_netr_DELTA_TRUSTED_DOMAIN_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_DELTA_TRUSTED_DOMAIN, type);
}


static PyTypeObject netr_DELTA_TRUSTED_DOMAIN_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_DELTA_TRUSTED_DOMAIN",
	.tp_getset = py_netr_DELTA_TRUSTED_DOMAIN_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_DELTA_TRUSTED_DOMAIN_new,
};


static PyObject *py_netr_DELTA_ACCOUNT_get_privilege_entries(PyObject *obj, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)pytalloc_get_ptr(obj);
	PyObject *py_privilege_entries;
	py_privilege_entries = PyInt_FromLong(object->privilege_entries);
	return py_privilege_entries;
}

static int py_netr_DELTA_ACCOUNT_set_privilege_entries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->privilege_entries = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_ACCOUNT_get_privilege_control(PyObject *obj, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)pytalloc_get_ptr(obj);
	PyObject *py_privilege_control;
	py_privilege_control = PyInt_FromLong(object->privilege_control);
	return py_privilege_control;
}

static int py_netr_DELTA_ACCOUNT_set_privilege_control(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->privilege_control = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_ACCOUNT_get_privilege_attrib(PyObject *obj, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)pytalloc_get_ptr(obj);
	PyObject *py_privilege_attrib;
	if (object->privilege_attrib == NULL) {
		py_privilege_attrib = Py_None;
		Py_INCREF(py_privilege_attrib);
	} else {
		py_privilege_attrib = PyList_New(object->privilege_entries);
		if (py_privilege_attrib == NULL) {
			return NULL;
		}
		{
			int privilege_attrib_cntr_1;
			for (privilege_attrib_cntr_1 = 0; privilege_attrib_cntr_1 < object->privilege_entries; privilege_attrib_cntr_1++) {
				PyObject *py_privilege_attrib_1;
				py_privilege_attrib_1 = PyInt_FromLong(object->privilege_attrib[privilege_attrib_cntr_1]);
				PyList_SetItem(py_privilege_attrib, privilege_attrib_cntr_1, py_privilege_attrib_1);
			}
		}
	}
	return py_privilege_attrib;
}

static int py_netr_DELTA_ACCOUNT_set_privilege_attrib(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->privilege_attrib);
	if (value == Py_None) {
		object->privilege_attrib = NULL;
	} else {
		object->privilege_attrib = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int privilege_attrib_cntr_1;
			object->privilege_attrib = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->privilege_attrib, PyList_GET_SIZE(value));
			if (!object->privilege_attrib) { return -1;; }
			talloc_set_name_const(object->privilege_attrib, "ARRAY: object->privilege_attrib");
			for (privilege_attrib_cntr_1 = 0; privilege_attrib_cntr_1 < PyList_GET_SIZE(value); privilege_attrib_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, privilege_attrib_cntr_1), return -1;);
				object->privilege_attrib[privilege_attrib_cntr_1] = PyInt_AsLong(PyList_GET_ITEM(value, privilege_attrib_cntr_1));
			}
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_ACCOUNT_get_privilege_name(PyObject *obj, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)pytalloc_get_ptr(obj);
	PyObject *py_privilege_name;
	if (object->privilege_name == NULL) {
		py_privilege_name = Py_None;
		Py_INCREF(py_privilege_name);
	} else {
		py_privilege_name = PyList_New(object->privilege_entries);
		if (py_privilege_name == NULL) {
			return NULL;
		}
		{
			int privilege_name_cntr_1;
			for (privilege_name_cntr_1 = 0; privilege_name_cntr_1 < object->privilege_entries; privilege_name_cntr_1++) {
				PyObject *py_privilege_name_1;
				py_privilege_name_1 = pytalloc_reference_ex(lsa_String_Type, object->privilege_name, &object->privilege_name[privilege_name_cntr_1]);
				PyList_SetItem(py_privilege_name, privilege_name_cntr_1, py_privilege_name_1);
			}
		}
	}
	return py_privilege_name;
}

static int py_netr_DELTA_ACCOUNT_set_privilege_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->privilege_name);
	if (value == Py_None) {
		object->privilege_name = NULL;
	} else {
		object->privilege_name = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int privilege_name_cntr_1;
			object->privilege_name = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->privilege_name, PyList_GET_SIZE(value));
			if (!object->privilege_name) { return -1;; }
			talloc_set_name_const(object->privilege_name, "ARRAY: object->privilege_name");
			for (privilege_name_cntr_1 = 0; privilege_name_cntr_1 < PyList_GET_SIZE(value); privilege_name_cntr_1++) {
				PY_CHECK_TYPE(lsa_String_Type, PyList_GET_ITEM(value, privilege_name_cntr_1), return -1;);
				if (talloc_reference(object->privilege_name, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, privilege_name_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				object->privilege_name[privilege_name_cntr_1] = *(struct lsa_String *)pytalloc_get_ptr(PyList_GET_ITEM(value, privilege_name_cntr_1));
			}
		}
	}
	return 0;
}

static PyObject *py_netr_DELTA_ACCOUNT_get_quotalimits(PyObject *obj, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)pytalloc_get_ptr(obj);
	PyObject *py_quotalimits;
	py_quotalimits = pytalloc_reference_ex(&netr_QUOTA_LIMITS_Type, pytalloc_get_mem_ctx(obj), &object->quotalimits);
	return py_quotalimits;
}

static int py_netr_DELTA_ACCOUNT_set_quotalimits(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_QUOTA_LIMITS_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->quotalimits = *(struct netr_QUOTA_LIMITS *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_ACCOUNT_get_system_flags(PyObject *obj, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)pytalloc_get_ptr(obj);
	PyObject *py_system_flags;
	py_system_flags = PyInt_FromLong(object->system_flags);
	return py_system_flags;
}

static int py_netr_DELTA_ACCOUNT_set_system_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->system_flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_ACCOUNT_get_SecurityInformation(PyObject *obj, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)pytalloc_get_ptr(obj);
	PyObject *py_SecurityInformation;
	py_SecurityInformation = PyInt_FromLong(object->SecurityInformation);
	return py_SecurityInformation;
}

static int py_netr_DELTA_ACCOUNT_set_SecurityInformation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->SecurityInformation = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_ACCOUNT_get_sdbuf(PyObject *obj, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)pytalloc_get_ptr(obj);
	PyObject *py_sdbuf;
	py_sdbuf = pytalloc_reference_ex(sec_desc_buf_Type, pytalloc_get_mem_ctx(obj), &object->sdbuf);
	return py_sdbuf;
}

static int py_netr_DELTA_ACCOUNT_set_sdbuf(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(sec_desc_buf_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->sdbuf = *(struct sec_desc_buf *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_ACCOUNT_get_unknown1(PyObject *obj, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)pytalloc_get_ptr(obj);
	PyObject *py_unknown1;
	py_unknown1 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown1);
	return py_unknown1;
}

static int py_netr_DELTA_ACCOUNT_set_unknown1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown1 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_ACCOUNT_get_unknown2(PyObject *obj, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)pytalloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown2);
	return py_unknown2;
}

static int py_netr_DELTA_ACCOUNT_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown2 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_ACCOUNT_get_unknown3(PyObject *obj, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)pytalloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown3);
	return py_unknown3;
}

static int py_netr_DELTA_ACCOUNT_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown3 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_ACCOUNT_get_unknown4(PyObject *obj, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)pytalloc_get_ptr(obj);
	PyObject *py_unknown4;
	py_unknown4 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown4);
	return py_unknown4;
}

static int py_netr_DELTA_ACCOUNT_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown4 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_ACCOUNT_get_unknown5(PyObject *obj, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)pytalloc_get_ptr(obj);
	PyObject *py_unknown5;
	py_unknown5 = PyInt_FromLong(object->unknown5);
	return py_unknown5;
}

static int py_netr_DELTA_ACCOUNT_set_unknown5(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown5 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_ACCOUNT_get_unknown6(PyObject *obj, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)pytalloc_get_ptr(obj);
	PyObject *py_unknown6;
	py_unknown6 = PyInt_FromLong(object->unknown6);
	return py_unknown6;
}

static int py_netr_DELTA_ACCOUNT_set_unknown6(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown6 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_ACCOUNT_get_unknown7(PyObject *obj, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)pytalloc_get_ptr(obj);
	PyObject *py_unknown7;
	py_unknown7 = PyInt_FromLong(object->unknown7);
	return py_unknown7;
}

static int py_netr_DELTA_ACCOUNT_set_unknown7(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown7 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_ACCOUNT_get_unknown8(PyObject *obj, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)pytalloc_get_ptr(obj);
	PyObject *py_unknown8;
	py_unknown8 = PyInt_FromLong(object->unknown8);
	return py_unknown8;
}

static int py_netr_DELTA_ACCOUNT_set_unknown8(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ACCOUNT *object = (struct netr_DELTA_ACCOUNT *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown8 = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_DELTA_ACCOUNT_getsetters[] = {
	{ discard_const_p(char, "privilege_entries"), py_netr_DELTA_ACCOUNT_get_privilege_entries, py_netr_DELTA_ACCOUNT_set_privilege_entries },
	{ discard_const_p(char, "privilege_control"), py_netr_DELTA_ACCOUNT_get_privilege_control, py_netr_DELTA_ACCOUNT_set_privilege_control },
	{ discard_const_p(char, "privilege_attrib"), py_netr_DELTA_ACCOUNT_get_privilege_attrib, py_netr_DELTA_ACCOUNT_set_privilege_attrib },
	{ discard_const_p(char, "privilege_name"), py_netr_DELTA_ACCOUNT_get_privilege_name, py_netr_DELTA_ACCOUNT_set_privilege_name },
	{ discard_const_p(char, "quotalimits"), py_netr_DELTA_ACCOUNT_get_quotalimits, py_netr_DELTA_ACCOUNT_set_quotalimits },
	{ discard_const_p(char, "system_flags"), py_netr_DELTA_ACCOUNT_get_system_flags, py_netr_DELTA_ACCOUNT_set_system_flags },
	{ discard_const_p(char, "SecurityInformation"), py_netr_DELTA_ACCOUNT_get_SecurityInformation, py_netr_DELTA_ACCOUNT_set_SecurityInformation },
	{ discard_const_p(char, "sdbuf"), py_netr_DELTA_ACCOUNT_get_sdbuf, py_netr_DELTA_ACCOUNT_set_sdbuf },
	{ discard_const_p(char, "unknown1"), py_netr_DELTA_ACCOUNT_get_unknown1, py_netr_DELTA_ACCOUNT_set_unknown1 },
	{ discard_const_p(char, "unknown2"), py_netr_DELTA_ACCOUNT_get_unknown2, py_netr_DELTA_ACCOUNT_set_unknown2 },
	{ discard_const_p(char, "unknown3"), py_netr_DELTA_ACCOUNT_get_unknown3, py_netr_DELTA_ACCOUNT_set_unknown3 },
	{ discard_const_p(char, "unknown4"), py_netr_DELTA_ACCOUNT_get_unknown4, py_netr_DELTA_ACCOUNT_set_unknown4 },
	{ discard_const_p(char, "unknown5"), py_netr_DELTA_ACCOUNT_get_unknown5, py_netr_DELTA_ACCOUNT_set_unknown5 },
	{ discard_const_p(char, "unknown6"), py_netr_DELTA_ACCOUNT_get_unknown6, py_netr_DELTA_ACCOUNT_set_unknown6 },
	{ discard_const_p(char, "unknown7"), py_netr_DELTA_ACCOUNT_get_unknown7, py_netr_DELTA_ACCOUNT_set_unknown7 },
	{ discard_const_p(char, "unknown8"), py_netr_DELTA_ACCOUNT_get_unknown8, py_netr_DELTA_ACCOUNT_set_unknown8 },
	{ NULL }
};

static PyObject *py_netr_DELTA_ACCOUNT_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_DELTA_ACCOUNT, type);
}


static PyTypeObject netr_DELTA_ACCOUNT_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_DELTA_ACCOUNT",
	.tp_getset = py_netr_DELTA_ACCOUNT_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_DELTA_ACCOUNT_new,
};


static PyObject *py_netr_CIPHER_VALUE_get_len(PyObject *obj, void *closure)
{
	struct netr_CIPHER_VALUE *object = (struct netr_CIPHER_VALUE *)pytalloc_get_ptr(obj);
	PyObject *py_len;
	py_len = PyInt_FromLong(object->len);
	return py_len;
}

static int py_netr_CIPHER_VALUE_set_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_CIPHER_VALUE *object = (struct netr_CIPHER_VALUE *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->len = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_CIPHER_VALUE_get_maxlen(PyObject *obj, void *closure)
{
	struct netr_CIPHER_VALUE *object = (struct netr_CIPHER_VALUE *)pytalloc_get_ptr(obj);
	PyObject *py_maxlen;
	py_maxlen = PyInt_FromLong(object->maxlen);
	return py_maxlen;
}

static int py_netr_CIPHER_VALUE_set_maxlen(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_CIPHER_VALUE *object = (struct netr_CIPHER_VALUE *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->maxlen = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_CIPHER_VALUE_get_cipher_data(PyObject *obj, void *closure)
{
	struct netr_CIPHER_VALUE *object = (struct netr_CIPHER_VALUE *)pytalloc_get_ptr(obj);
	PyObject *py_cipher_data;
	if (object->cipher_data == NULL) {
		py_cipher_data = Py_None;
		Py_INCREF(py_cipher_data);
	} else {
		py_cipher_data = PyList_New(object->len);
		if (py_cipher_data == NULL) {
			return NULL;
		}
		{
			int cipher_data_cntr_1;
			for (cipher_data_cntr_1 = 0; cipher_data_cntr_1 < object->len; cipher_data_cntr_1++) {
				PyObject *py_cipher_data_1;
				py_cipher_data_1 = PyInt_FromLong(object->cipher_data[cipher_data_cntr_1]);
				PyList_SetItem(py_cipher_data, cipher_data_cntr_1, py_cipher_data_1);
			}
		}
	}
	return py_cipher_data;
}

static int py_netr_CIPHER_VALUE_set_cipher_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_CIPHER_VALUE *object = (struct netr_CIPHER_VALUE *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->cipher_data);
	if (value == Py_None) {
		object->cipher_data = NULL;
	} else {
		object->cipher_data = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int cipher_data_cntr_1;
			object->cipher_data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->cipher_data, PyList_GET_SIZE(value));
			if (!object->cipher_data) { return -1;; }
			talloc_set_name_const(object->cipher_data, "ARRAY: object->cipher_data");
			for (cipher_data_cntr_1 = 0; cipher_data_cntr_1 < PyList_GET_SIZE(value); cipher_data_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, cipher_data_cntr_1), return -1;);
				object->cipher_data[cipher_data_cntr_1] = PyInt_AsLong(PyList_GET_ITEM(value, cipher_data_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_netr_CIPHER_VALUE_getsetters[] = {
	{ discard_const_p(char, "len"), py_netr_CIPHER_VALUE_get_len, py_netr_CIPHER_VALUE_set_len },
	{ discard_const_p(char, "maxlen"), py_netr_CIPHER_VALUE_get_maxlen, py_netr_CIPHER_VALUE_set_maxlen },
	{ discard_const_p(char, "cipher_data"), py_netr_CIPHER_VALUE_get_cipher_data, py_netr_CIPHER_VALUE_set_cipher_data },
	{ NULL }
};

static PyObject *py_netr_CIPHER_VALUE_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_CIPHER_VALUE, type);
}


static PyTypeObject netr_CIPHER_VALUE_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_CIPHER_VALUE",
	.tp_getset = py_netr_CIPHER_VALUE_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_CIPHER_VALUE_new,
};


static PyObject *py_netr_DELTA_SECRET_get_current_cipher(PyObject *obj, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)pytalloc_get_ptr(obj);
	PyObject *py_current_cipher;
	py_current_cipher = pytalloc_reference_ex(&netr_CIPHER_VALUE_Type, pytalloc_get_mem_ctx(obj), &object->current_cipher);
	return py_current_cipher;
}

static int py_netr_DELTA_SECRET_set_current_cipher(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_CIPHER_VALUE_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->current_cipher = *(struct netr_CIPHER_VALUE *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_SECRET_get_current_cipher_set_time(PyObject *obj, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)pytalloc_get_ptr(obj);
	PyObject *py_current_cipher_set_time;
	py_current_cipher_set_time = PyLong_FromLongLong(object->current_cipher_set_time);
	return py_current_cipher_set_time;
}

static int py_netr_DELTA_SECRET_set_current_cipher_set_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->current_cipher_set_time = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->current_cipher_set_time = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netr_DELTA_SECRET_get_old_cipher(PyObject *obj, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)pytalloc_get_ptr(obj);
	PyObject *py_old_cipher;
	py_old_cipher = pytalloc_reference_ex(&netr_CIPHER_VALUE_Type, pytalloc_get_mem_ctx(obj), &object->old_cipher);
	return py_old_cipher;
}

static int py_netr_DELTA_SECRET_set_old_cipher(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_CIPHER_VALUE_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->old_cipher = *(struct netr_CIPHER_VALUE *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_SECRET_get_old_cipher_set_time(PyObject *obj, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)pytalloc_get_ptr(obj);
	PyObject *py_old_cipher_set_time;
	py_old_cipher_set_time = PyLong_FromLongLong(object->old_cipher_set_time);
	return py_old_cipher_set_time;
}

static int py_netr_DELTA_SECRET_set_old_cipher_set_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->old_cipher_set_time = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->old_cipher_set_time = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netr_DELTA_SECRET_get_SecurityInformation(PyObject *obj, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)pytalloc_get_ptr(obj);
	PyObject *py_SecurityInformation;
	py_SecurityInformation = PyInt_FromLong(object->SecurityInformation);
	return py_SecurityInformation;
}

static int py_netr_DELTA_SECRET_set_SecurityInformation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->SecurityInformation = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_SECRET_get_sdbuf(PyObject *obj, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)pytalloc_get_ptr(obj);
	PyObject *py_sdbuf;
	py_sdbuf = pytalloc_reference_ex(sec_desc_buf_Type, pytalloc_get_mem_ctx(obj), &object->sdbuf);
	return py_sdbuf;
}

static int py_netr_DELTA_SECRET_set_sdbuf(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(sec_desc_buf_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->sdbuf = *(struct sec_desc_buf *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_SECRET_get_unknown1(PyObject *obj, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)pytalloc_get_ptr(obj);
	PyObject *py_unknown1;
	py_unknown1 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown1);
	return py_unknown1;
}

static int py_netr_DELTA_SECRET_set_unknown1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown1 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_SECRET_get_unknown2(PyObject *obj, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)pytalloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown2);
	return py_unknown2;
}

static int py_netr_DELTA_SECRET_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown2 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_SECRET_get_unknown3(PyObject *obj, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)pytalloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown3);
	return py_unknown3;
}

static int py_netr_DELTA_SECRET_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown3 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_SECRET_get_unknown4(PyObject *obj, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)pytalloc_get_ptr(obj);
	PyObject *py_unknown4;
	py_unknown4 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->unknown4);
	return py_unknown4;
}

static int py_netr_DELTA_SECRET_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unknown4 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DELTA_SECRET_get_unknown5(PyObject *obj, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)pytalloc_get_ptr(obj);
	PyObject *py_unknown5;
	py_unknown5 = PyInt_FromLong(object->unknown5);
	return py_unknown5;
}

static int py_netr_DELTA_SECRET_set_unknown5(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown5 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_SECRET_get_unknown6(PyObject *obj, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)pytalloc_get_ptr(obj);
	PyObject *py_unknown6;
	py_unknown6 = PyInt_FromLong(object->unknown6);
	return py_unknown6;
}

static int py_netr_DELTA_SECRET_set_unknown6(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown6 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_SECRET_get_unknown7(PyObject *obj, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)pytalloc_get_ptr(obj);
	PyObject *py_unknown7;
	py_unknown7 = PyInt_FromLong(object->unknown7);
	return py_unknown7;
}

static int py_netr_DELTA_SECRET_set_unknown7(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown7 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_SECRET_get_unknown8(PyObject *obj, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)pytalloc_get_ptr(obj);
	PyObject *py_unknown8;
	py_unknown8 = PyInt_FromLong(object->unknown8);
	return py_unknown8;
}

static int py_netr_DELTA_SECRET_set_unknown8(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_SECRET *object = (struct netr_DELTA_SECRET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown8 = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_DELTA_SECRET_getsetters[] = {
	{ discard_const_p(char, "current_cipher"), py_netr_DELTA_SECRET_get_current_cipher, py_netr_DELTA_SECRET_set_current_cipher },
	{ discard_const_p(char, "current_cipher_set_time"), py_netr_DELTA_SECRET_get_current_cipher_set_time, py_netr_DELTA_SECRET_set_current_cipher_set_time },
	{ discard_const_p(char, "old_cipher"), py_netr_DELTA_SECRET_get_old_cipher, py_netr_DELTA_SECRET_set_old_cipher },
	{ discard_const_p(char, "old_cipher_set_time"), py_netr_DELTA_SECRET_get_old_cipher_set_time, py_netr_DELTA_SECRET_set_old_cipher_set_time },
	{ discard_const_p(char, "SecurityInformation"), py_netr_DELTA_SECRET_get_SecurityInformation, py_netr_DELTA_SECRET_set_SecurityInformation },
	{ discard_const_p(char, "sdbuf"), py_netr_DELTA_SECRET_get_sdbuf, py_netr_DELTA_SECRET_set_sdbuf },
	{ discard_const_p(char, "unknown1"), py_netr_DELTA_SECRET_get_unknown1, py_netr_DELTA_SECRET_set_unknown1 },
	{ discard_const_p(char, "unknown2"), py_netr_DELTA_SECRET_get_unknown2, py_netr_DELTA_SECRET_set_unknown2 },
	{ discard_const_p(char, "unknown3"), py_netr_DELTA_SECRET_get_unknown3, py_netr_DELTA_SECRET_set_unknown3 },
	{ discard_const_p(char, "unknown4"), py_netr_DELTA_SECRET_get_unknown4, py_netr_DELTA_SECRET_set_unknown4 },
	{ discard_const_p(char, "unknown5"), py_netr_DELTA_SECRET_get_unknown5, py_netr_DELTA_SECRET_set_unknown5 },
	{ discard_const_p(char, "unknown6"), py_netr_DELTA_SECRET_get_unknown6, py_netr_DELTA_SECRET_set_unknown6 },
	{ discard_const_p(char, "unknown7"), py_netr_DELTA_SECRET_get_unknown7, py_netr_DELTA_SECRET_set_unknown7 },
	{ discard_const_p(char, "unknown8"), py_netr_DELTA_SECRET_get_unknown8, py_netr_DELTA_SECRET_set_unknown8 },
	{ NULL }
};

static PyObject *py_netr_DELTA_SECRET_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_DELTA_SECRET, type);
}


static PyTypeObject netr_DELTA_SECRET_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_DELTA_SECRET",
	.tp_getset = py_netr_DELTA_SECRET_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_DELTA_SECRET_new,
};

PyObject *py_import_netr_DELTA_UNION(TALLOC_CTX *mem_ctx, int level, union netr_DELTA_UNION *in)
{
	PyObject *ret;

	switch (level) {
		case NETR_DELTA_DOMAIN:
			if (in->domain == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_DELTA_DOMAIN_Type, in->domain, in->domain);
			}
			return ret;

		case NETR_DELTA_GROUP:
			if (in->group == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_DELTA_GROUP_Type, in->group, in->group);
			}
			return ret;

		case NETR_DELTA_DELETE_GROUP:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

		case NETR_DELTA_RENAME_GROUP:
			if (in->rename_group == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_DELTA_RENAME_Type, in->rename_group, in->rename_group);
			}
			return ret;

		case NETR_DELTA_USER:
			if (in->user == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_DELTA_USER_Type, in->user, in->user);
			}
			return ret;

		case NETR_DELTA_DELETE_USER:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

		case NETR_DELTA_RENAME_USER:
			if (in->rename_user == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_DELTA_RENAME_Type, in->rename_user, in->rename_user);
			}
			return ret;

		case NETR_DELTA_GROUP_MEMBER:
			if (in->group_member == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_DELTA_GROUP_MEMBER_Type, in->group_member, in->group_member);
			}
			return ret;

		case NETR_DELTA_ALIAS:
			if (in->alias == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_DELTA_ALIAS_Type, in->alias, in->alias);
			}
			return ret;

		case NETR_DELTA_DELETE_ALIAS:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

		case NETR_DELTA_RENAME_ALIAS:
			if (in->rename_alias == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_DELTA_RENAME_Type, in->rename_alias, in->rename_alias);
			}
			return ret;

		case NETR_DELTA_ALIAS_MEMBER:
			if (in->alias_member == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_DELTA_ALIAS_MEMBER_Type, in->alias_member, in->alias_member);
			}
			return ret;

		case NETR_DELTA_POLICY:
			if (in->policy == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_DELTA_POLICY_Type, in->policy, in->policy);
			}
			return ret;

		case NETR_DELTA_TRUSTED_DOMAIN:
			if (in->trusted_domain == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_DELTA_TRUSTED_DOMAIN_Type, in->trusted_domain, in->trusted_domain);
			}
			return ret;

		case NETR_DELTA_DELETE_TRUST:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

		case NETR_DELTA_ACCOUNT:
			if (in->account == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_DELTA_ACCOUNT_Type, in->account, in->account);
			}
			return ret;

		case NETR_DELTA_DELETE_ACCOUNT:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

		case NETR_DELTA_SECRET:
			if (in->secret == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_DELTA_SECRET_Type, in->secret, in->secret);
			}
			return ret;

		case NETR_DELTA_DELETE_SECRET:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

		case NETR_DELTA_DELETE_GROUP2:
			if (in->delete_group == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_DELTA_DELETE_USER_Type, in->delete_group, in->delete_group);
			}
			return ret;

		case NETR_DELTA_DELETE_USER2:
			if (in->delete_user == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_DELTA_DELETE_USER_Type, in->delete_user, in->delete_user);
			}
			return ret;

		case NETR_DELTA_MODIFY_COUNT:
			if (in->modified_count == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = PyLong_FromLongLong(*in->modified_count);
			}
			return ret;

		default:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union netr_DELTA_UNION *py_export_netr_DELTA_UNION(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union netr_DELTA_UNION *ret = talloc_zero(mem_ctx, union netr_DELTA_UNION);
	switch (level) {
		case NETR_DELTA_DOMAIN:
			if (in == Py_None) {
				ret->domain = NULL;
			} else {
				ret->domain = NULL;
				PY_CHECK_TYPE(&netr_DELTA_DOMAIN_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->domain = (struct netr_DELTA_DOMAIN *)pytalloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_GROUP:
			if (in == Py_None) {
				ret->group = NULL;
			} else {
				ret->group = NULL;
				PY_CHECK_TYPE(&netr_DELTA_GROUP_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->group = (struct netr_DELTA_GROUP *)pytalloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_DELETE_GROUP:
			break;

		case NETR_DELTA_RENAME_GROUP:
			if (in == Py_None) {
				ret->rename_group = NULL;
			} else {
				ret->rename_group = NULL;
				PY_CHECK_TYPE(&netr_DELTA_RENAME_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->rename_group = (struct netr_DELTA_RENAME *)pytalloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_USER:
			if (in == Py_None) {
				ret->user = NULL;
			} else {
				ret->user = NULL;
				PY_CHECK_TYPE(&netr_DELTA_USER_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->user = (struct netr_DELTA_USER *)pytalloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_DELETE_USER:
			break;

		case NETR_DELTA_RENAME_USER:
			if (in == Py_None) {
				ret->rename_user = NULL;
			} else {
				ret->rename_user = NULL;
				PY_CHECK_TYPE(&netr_DELTA_RENAME_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->rename_user = (struct netr_DELTA_RENAME *)pytalloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_GROUP_MEMBER:
			if (in == Py_None) {
				ret->group_member = NULL;
			} else {
				ret->group_member = NULL;
				PY_CHECK_TYPE(&netr_DELTA_GROUP_MEMBER_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->group_member = (struct netr_DELTA_GROUP_MEMBER *)pytalloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_ALIAS:
			if (in == Py_None) {
				ret->alias = NULL;
			} else {
				ret->alias = NULL;
				PY_CHECK_TYPE(&netr_DELTA_ALIAS_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->alias = (struct netr_DELTA_ALIAS *)pytalloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_DELETE_ALIAS:
			break;

		case NETR_DELTA_RENAME_ALIAS:
			if (in == Py_None) {
				ret->rename_alias = NULL;
			} else {
				ret->rename_alias = NULL;
				PY_CHECK_TYPE(&netr_DELTA_RENAME_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->rename_alias = (struct netr_DELTA_RENAME *)pytalloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_ALIAS_MEMBER:
			if (in == Py_None) {
				ret->alias_member = NULL;
			} else {
				ret->alias_member = NULL;
				PY_CHECK_TYPE(&netr_DELTA_ALIAS_MEMBER_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->alias_member = (struct netr_DELTA_ALIAS_MEMBER *)pytalloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_POLICY:
			if (in == Py_None) {
				ret->policy = NULL;
			} else {
				ret->policy = NULL;
				PY_CHECK_TYPE(&netr_DELTA_POLICY_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->policy = (struct netr_DELTA_POLICY *)pytalloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_TRUSTED_DOMAIN:
			if (in == Py_None) {
				ret->trusted_domain = NULL;
			} else {
				ret->trusted_domain = NULL;
				PY_CHECK_TYPE(&netr_DELTA_TRUSTED_DOMAIN_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->trusted_domain = (struct netr_DELTA_TRUSTED_DOMAIN *)pytalloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_DELETE_TRUST:
			break;

		case NETR_DELTA_ACCOUNT:
			if (in == Py_None) {
				ret->account = NULL;
			} else {
				ret->account = NULL;
				PY_CHECK_TYPE(&netr_DELTA_ACCOUNT_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->account = (struct netr_DELTA_ACCOUNT *)pytalloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_DELETE_ACCOUNT:
			break;

		case NETR_DELTA_SECRET:
			if (in == Py_None) {
				ret->secret = NULL;
			} else {
				ret->secret = NULL;
				PY_CHECK_TYPE(&netr_DELTA_SECRET_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->secret = (struct netr_DELTA_SECRET *)pytalloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_DELETE_SECRET:
			break;

		case NETR_DELTA_DELETE_GROUP2:
			if (in == Py_None) {
				ret->delete_group = NULL;
			} else {
				ret->delete_group = NULL;
				PY_CHECK_TYPE(&netr_DELTA_DELETE_USER_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->delete_group = (struct netr_DELTA_DELETE_USER *)pytalloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_DELETE_USER2:
			if (in == Py_None) {
				ret->delete_user = NULL;
			} else {
				ret->delete_user = NULL;
				PY_CHECK_TYPE(&netr_DELTA_DELETE_USER_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->delete_user = (struct netr_DELTA_DELETE_USER *)pytalloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_MODIFY_COUNT:
			if (in == Py_None) {
				ret->modified_count = NULL;
			} else {
				ret->modified_count = talloc_ptrtype(mem_ctx, ret->modified_count);
				if (PyLong_Check(in)) {
					*ret->modified_count = PyLong_AsLongLong(in);
				} else if (PyInt_Check(in)) {
					*ret->modified_count = PyInt_AsLong(in);
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
					  PyInt_Type.tp_name, PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		default:
			break;

	}

	return ret;
}

PyObject *py_import_netr_DELTA_ID_UNION(TALLOC_CTX *mem_ctx, int level, union netr_DELTA_ID_UNION *in)
{
	PyObject *ret;

	switch (level) {
		case NETR_DELTA_DOMAIN:
			ret = PyInt_FromLong(in->rid);
			return ret;

		case NETR_DELTA_GROUP:
			ret = PyInt_FromLong(in->rid);
			return ret;

		case NETR_DELTA_DELETE_GROUP:
			ret = PyInt_FromLong(in->rid);
			return ret;

		case NETR_DELTA_RENAME_GROUP:
			ret = PyInt_FromLong(in->rid);
			return ret;

		case NETR_DELTA_USER:
			ret = PyInt_FromLong(in->rid);
			return ret;

		case NETR_DELTA_DELETE_USER:
			ret = PyInt_FromLong(in->rid);
			return ret;

		case NETR_DELTA_RENAME_USER:
			ret = PyInt_FromLong(in->rid);
			return ret;

		case NETR_DELTA_GROUP_MEMBER:
			ret = PyInt_FromLong(in->rid);
			return ret;

		case NETR_DELTA_ALIAS:
			ret = PyInt_FromLong(in->rid);
			return ret;

		case NETR_DELTA_DELETE_ALIAS:
			ret = PyInt_FromLong(in->rid);
			return ret;

		case NETR_DELTA_RENAME_ALIAS:
			ret = PyInt_FromLong(in->rid);
			return ret;

		case NETR_DELTA_ALIAS_MEMBER:
			ret = PyInt_FromLong(in->rid);
			return ret;

		case NETR_DELTA_POLICY:
			if (in->sid == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(dom_sid_Type, in->sid, in->sid);
			}
			return ret;

		case NETR_DELTA_TRUSTED_DOMAIN:
			if (in->sid == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(dom_sid_Type, in->sid, in->sid);
			}
			return ret;

		case NETR_DELTA_DELETE_TRUST:
			if (in->sid == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(dom_sid_Type, in->sid, in->sid);
			}
			return ret;

		case NETR_DELTA_ACCOUNT:
			if (in->sid == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(dom_sid_Type, in->sid, in->sid);
			}
			return ret;

		case NETR_DELTA_DELETE_ACCOUNT:
			if (in->sid == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(dom_sid_Type, in->sid, in->sid);
			}
			return ret;

		case NETR_DELTA_SECRET:
			if (in->name == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				if (in->name == NULL) {
					ret = Py_None;
					Py_INCREF(ret);
				} else {
					ret = PyUnicode_Decode(in->name, strlen(in->name), "utf-8", "ignore");
				}
			}
			return ret;

		case NETR_DELTA_DELETE_SECRET:
			if (in->name == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				if (in->name == NULL) {
					ret = Py_None;
					Py_INCREF(ret);
				} else {
					ret = PyUnicode_Decode(in->name, strlen(in->name), "utf-8", "ignore");
				}
			}
			return ret;

		case NETR_DELTA_DELETE_GROUP2:
			ret = PyInt_FromLong(in->rid);
			return ret;

		case NETR_DELTA_DELETE_USER2:
			ret = PyInt_FromLong(in->rid);
			return ret;

		case NETR_DELTA_MODIFY_COUNT:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

		default:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union netr_DELTA_ID_UNION *py_export_netr_DELTA_ID_UNION(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union netr_DELTA_ID_UNION *ret = talloc_zero(mem_ctx, union netr_DELTA_ID_UNION);
	switch (level) {
		case NETR_DELTA_DOMAIN:
			PY_CHECK_TYPE(&PyInt_Type, in, talloc_free(ret); return NULL;);
			ret->rid = PyInt_AsLong(in);
			break;

		case NETR_DELTA_GROUP:
			PY_CHECK_TYPE(&PyInt_Type, in, talloc_free(ret); return NULL;);
			ret->rid = PyInt_AsLong(in);
			break;

		case NETR_DELTA_DELETE_GROUP:
			PY_CHECK_TYPE(&PyInt_Type, in, talloc_free(ret); return NULL;);
			ret->rid = PyInt_AsLong(in);
			break;

		case NETR_DELTA_RENAME_GROUP:
			PY_CHECK_TYPE(&PyInt_Type, in, talloc_free(ret); return NULL;);
			ret->rid = PyInt_AsLong(in);
			break;

		case NETR_DELTA_USER:
			PY_CHECK_TYPE(&PyInt_Type, in, talloc_free(ret); return NULL;);
			ret->rid = PyInt_AsLong(in);
			break;

		case NETR_DELTA_DELETE_USER:
			PY_CHECK_TYPE(&PyInt_Type, in, talloc_free(ret); return NULL;);
			ret->rid = PyInt_AsLong(in);
			break;

		case NETR_DELTA_RENAME_USER:
			PY_CHECK_TYPE(&PyInt_Type, in, talloc_free(ret); return NULL;);
			ret->rid = PyInt_AsLong(in);
			break;

		case NETR_DELTA_GROUP_MEMBER:
			PY_CHECK_TYPE(&PyInt_Type, in, talloc_free(ret); return NULL;);
			ret->rid = PyInt_AsLong(in);
			break;

		case NETR_DELTA_ALIAS:
			PY_CHECK_TYPE(&PyInt_Type, in, talloc_free(ret); return NULL;);
			ret->rid = PyInt_AsLong(in);
			break;

		case NETR_DELTA_DELETE_ALIAS:
			PY_CHECK_TYPE(&PyInt_Type, in, talloc_free(ret); return NULL;);
			ret->rid = PyInt_AsLong(in);
			break;

		case NETR_DELTA_RENAME_ALIAS:
			PY_CHECK_TYPE(&PyInt_Type, in, talloc_free(ret); return NULL;);
			ret->rid = PyInt_AsLong(in);
			break;

		case NETR_DELTA_ALIAS_MEMBER:
			PY_CHECK_TYPE(&PyInt_Type, in, talloc_free(ret); return NULL;);
			ret->rid = PyInt_AsLong(in);
			break;

		case NETR_DELTA_POLICY:
			if (in == Py_None) {
				ret->sid = NULL;
			} else {
				ret->sid = NULL;
				PY_CHECK_TYPE(dom_sid_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->sid = (struct dom_sid *)pytalloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_TRUSTED_DOMAIN:
			if (in == Py_None) {
				ret->sid = NULL;
			} else {
				ret->sid = NULL;
				PY_CHECK_TYPE(dom_sid_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->sid = (struct dom_sid *)pytalloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_DELETE_TRUST:
			if (in == Py_None) {
				ret->sid = NULL;
			} else {
				ret->sid = NULL;
				PY_CHECK_TYPE(dom_sid_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->sid = (struct dom_sid *)pytalloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_ACCOUNT:
			if (in == Py_None) {
				ret->sid = NULL;
			} else {
				ret->sid = NULL;
				PY_CHECK_TYPE(dom_sid_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->sid = (struct dom_sid *)pytalloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_DELETE_ACCOUNT:
			if (in == Py_None) {
				ret->sid = NULL;
			} else {
				ret->sid = NULL;
				PY_CHECK_TYPE(dom_sid_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->sid = (struct dom_sid *)pytalloc_get_ptr(in);
			}
			break;

		case NETR_DELTA_SECRET:
			if (in == Py_None) {
				ret->name = NULL;
			} else {
				ret->name = NULL;
				if (PyUnicode_Check(in)) {
					ret->name = PyString_AS_STRING(PyUnicode_AsEncodedString(in, "utf-8", "ignore"));
				} else if (PyString_Check(in)) {
					ret->name = PyString_AS_STRING(in);
				} else {
					PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case NETR_DELTA_DELETE_SECRET:
			if (in == Py_None) {
				ret->name = NULL;
			} else {
				ret->name = NULL;
				if (PyUnicode_Check(in)) {
					ret->name = PyString_AS_STRING(PyUnicode_AsEncodedString(in, "utf-8", "ignore"));
				} else if (PyString_Check(in)) {
					ret->name = PyString_AS_STRING(in);
				} else {
					PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case NETR_DELTA_DELETE_GROUP2:
			PY_CHECK_TYPE(&PyInt_Type, in, talloc_free(ret); return NULL;);
			ret->rid = PyInt_AsLong(in);
			break;

		case NETR_DELTA_DELETE_USER2:
			PY_CHECK_TYPE(&PyInt_Type, in, talloc_free(ret); return NULL;);
			ret->rid = PyInt_AsLong(in);
			break;

		case NETR_DELTA_MODIFY_COUNT:
			break;

		default:
			break;

	}

	return ret;
}


static PyObject *py_netr_DELTA_ENUM_get_delta_type(PyObject *obj, void *closure)
{
	struct netr_DELTA_ENUM *object = (struct netr_DELTA_ENUM *)pytalloc_get_ptr(obj);
	PyObject *py_delta_type;
	py_delta_type = PyInt_FromLong(object->delta_type);
	return py_delta_type;
}

static int py_netr_DELTA_ENUM_set_delta_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ENUM *object = (struct netr_DELTA_ENUM *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->delta_type = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->delta_type = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netr_DELTA_ENUM_get_delta_id_union(PyObject *obj, void *closure)
{
	struct netr_DELTA_ENUM *object = (struct netr_DELTA_ENUM *)pytalloc_get_ptr(obj);
	PyObject *py_delta_id_union;
	py_delta_id_union = py_import_netr_DELTA_ID_UNION(pytalloc_get_mem_ctx(obj), object->delta_type, &object->delta_id_union);
	if (py_delta_id_union == NULL) {
		return NULL;
	}
	return py_delta_id_union;
}

static int py_netr_DELTA_ENUM_set_delta_id_union(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ENUM *object = (struct netr_DELTA_ENUM *)pytalloc_get_ptr(py_obj);
	{
		union netr_DELTA_ID_UNION *delta_id_union_switch_0;
		delta_id_union_switch_0 = py_export_netr_DELTA_ID_UNION(pytalloc_get_mem_ctx(py_obj), object->delta_type, value);
		if (delta_id_union_switch_0 == NULL) {
			return -1;
		}
		object->delta_id_union = *delta_id_union_switch_0;
	}
	return 0;
}

static PyObject *py_netr_DELTA_ENUM_get_delta_union(PyObject *obj, void *closure)
{
	struct netr_DELTA_ENUM *object = (struct netr_DELTA_ENUM *)pytalloc_get_ptr(obj);
	PyObject *py_delta_union;
	py_delta_union = py_import_netr_DELTA_UNION(pytalloc_get_mem_ctx(obj), object->delta_type, &object->delta_union);
	if (py_delta_union == NULL) {
		return NULL;
	}
	return py_delta_union;
}

static int py_netr_DELTA_ENUM_set_delta_union(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ENUM *object = (struct netr_DELTA_ENUM *)pytalloc_get_ptr(py_obj);
	{
		union netr_DELTA_UNION *delta_union_switch_0;
		delta_union_switch_0 = py_export_netr_DELTA_UNION(pytalloc_get_mem_ctx(py_obj), object->delta_type, value);
		if (delta_union_switch_0 == NULL) {
			return -1;
		}
		object->delta_union = *delta_union_switch_0;
	}
	return 0;
}

static PyGetSetDef py_netr_DELTA_ENUM_getsetters[] = {
	{ discard_const_p(char, "delta_type"), py_netr_DELTA_ENUM_get_delta_type, py_netr_DELTA_ENUM_set_delta_type },
	{ discard_const_p(char, "delta_id_union"), py_netr_DELTA_ENUM_get_delta_id_union, py_netr_DELTA_ENUM_set_delta_id_union },
	{ discard_const_p(char, "delta_union"), py_netr_DELTA_ENUM_get_delta_union, py_netr_DELTA_ENUM_set_delta_union },
	{ NULL }
};

static PyObject *py_netr_DELTA_ENUM_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_DELTA_ENUM, type);
}


static PyTypeObject netr_DELTA_ENUM_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_DELTA_ENUM",
	.tp_getset = py_netr_DELTA_ENUM_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_DELTA_ENUM_new,
};


static PyObject *py_netr_DELTA_ENUM_ARRAY_get_num_deltas(PyObject *obj, void *closure)
{
	struct netr_DELTA_ENUM_ARRAY *object = (struct netr_DELTA_ENUM_ARRAY *)pytalloc_get_ptr(obj);
	PyObject *py_num_deltas;
	py_num_deltas = PyInt_FromLong(object->num_deltas);
	return py_num_deltas;
}

static int py_netr_DELTA_ENUM_ARRAY_set_num_deltas(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ENUM_ARRAY *object = (struct netr_DELTA_ENUM_ARRAY *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->num_deltas = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DELTA_ENUM_ARRAY_get_delta_enum(PyObject *obj, void *closure)
{
	struct netr_DELTA_ENUM_ARRAY *object = (struct netr_DELTA_ENUM_ARRAY *)pytalloc_get_ptr(obj);
	PyObject *py_delta_enum;
	if (object->delta_enum == NULL) {
		py_delta_enum = Py_None;
		Py_INCREF(py_delta_enum);
	} else {
		py_delta_enum = PyList_New(object->num_deltas);
		if (py_delta_enum == NULL) {
			return NULL;
		}
		{
			int delta_enum_cntr_1;
			for (delta_enum_cntr_1 = 0; delta_enum_cntr_1 < object->num_deltas; delta_enum_cntr_1++) {
				PyObject *py_delta_enum_1;
				py_delta_enum_1 = pytalloc_reference_ex(&netr_DELTA_ENUM_Type, object->delta_enum, &object->delta_enum[delta_enum_cntr_1]);
				PyList_SetItem(py_delta_enum, delta_enum_cntr_1, py_delta_enum_1);
			}
		}
	}
	return py_delta_enum;
}

static int py_netr_DELTA_ENUM_ARRAY_set_delta_enum(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DELTA_ENUM_ARRAY *object = (struct netr_DELTA_ENUM_ARRAY *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->delta_enum);
	if (value == Py_None) {
		object->delta_enum = NULL;
	} else {
		object->delta_enum = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int delta_enum_cntr_1;
			object->delta_enum = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->delta_enum, PyList_GET_SIZE(value));
			if (!object->delta_enum) { return -1;; }
			talloc_set_name_const(object->delta_enum, "ARRAY: object->delta_enum");
			for (delta_enum_cntr_1 = 0; delta_enum_cntr_1 < PyList_GET_SIZE(value); delta_enum_cntr_1++) {
				PY_CHECK_TYPE(&netr_DELTA_ENUM_Type, PyList_GET_ITEM(value, delta_enum_cntr_1), return -1;);
				if (talloc_reference(object->delta_enum, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, delta_enum_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				object->delta_enum[delta_enum_cntr_1] = *(struct netr_DELTA_ENUM *)pytalloc_get_ptr(PyList_GET_ITEM(value, delta_enum_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_netr_DELTA_ENUM_ARRAY_getsetters[] = {
	{ discard_const_p(char, "num_deltas"), py_netr_DELTA_ENUM_ARRAY_get_num_deltas, py_netr_DELTA_ENUM_ARRAY_set_num_deltas },
	{ discard_const_p(char, "delta_enum"), py_netr_DELTA_ENUM_ARRAY_get_delta_enum, py_netr_DELTA_ENUM_ARRAY_set_delta_enum },
	{ NULL }
};

static PyObject *py_netr_DELTA_ENUM_ARRAY_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_DELTA_ENUM_ARRAY, type);
}


static PyTypeObject netr_DELTA_ENUM_ARRAY_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_DELTA_ENUM_ARRAY",
	.tp_getset = py_netr_DELTA_ENUM_ARRAY_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_DELTA_ENUM_ARRAY_new,
};


static PyObject *py_netr_UAS_INFO_0_get_computer_name(PyObject *obj, void *closure)
{
	struct netr_UAS_INFO_0 *object = (struct netr_UAS_INFO_0 *)pytalloc_get_ptr(obj);
	PyObject *py_computer_name;
	py_computer_name = PyList_New(16);
	if (py_computer_name == NULL) {
		return NULL;
	}
	{
		int computer_name_cntr_0;
		for (computer_name_cntr_0 = 0; computer_name_cntr_0 < 16; computer_name_cntr_0++) {
			PyObject *py_computer_name_0;
			py_computer_name_0 = PyInt_FromLong(object->computer_name[computer_name_cntr_0]);
			PyList_SetItem(py_computer_name, computer_name_cntr_0, py_computer_name_0);
		}
	}
	return py_computer_name;
}

static int py_netr_UAS_INFO_0_set_computer_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UAS_INFO_0 *object = (struct netr_UAS_INFO_0 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int computer_name_cntr_0;
		for (computer_name_cntr_0 = 0; computer_name_cntr_0 < PyList_GET_SIZE(value); computer_name_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, computer_name_cntr_0), return -1;);
			object->computer_name[computer_name_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, computer_name_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_netr_UAS_INFO_0_get_timecreated(PyObject *obj, void *closure)
{
	struct netr_UAS_INFO_0 *object = (struct netr_UAS_INFO_0 *)pytalloc_get_ptr(obj);
	PyObject *py_timecreated;
	py_timecreated = PyInt_FromLong(object->timecreated);
	return py_timecreated;
}

static int py_netr_UAS_INFO_0_set_timecreated(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UAS_INFO_0 *object = (struct netr_UAS_INFO_0 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->timecreated = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_UAS_INFO_0_get_serial_number(PyObject *obj, void *closure)
{
	struct netr_UAS_INFO_0 *object = (struct netr_UAS_INFO_0 *)pytalloc_get_ptr(obj);
	PyObject *py_serial_number;
	py_serial_number = PyInt_FromLong(object->serial_number);
	return py_serial_number;
}

static int py_netr_UAS_INFO_0_set_serial_number(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_UAS_INFO_0 *object = (struct netr_UAS_INFO_0 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->serial_number = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_UAS_INFO_0_getsetters[] = {
	{ discard_const_p(char, "computer_name"), py_netr_UAS_INFO_0_get_computer_name, py_netr_UAS_INFO_0_set_computer_name },
	{ discard_const_p(char, "timecreated"), py_netr_UAS_INFO_0_get_timecreated, py_netr_UAS_INFO_0_set_timecreated },
	{ discard_const_p(char, "serial_number"), py_netr_UAS_INFO_0_get_serial_number, py_netr_UAS_INFO_0_set_serial_number },
	{ NULL }
};

static PyObject *py_netr_UAS_INFO_0_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_UAS_INFO_0, type);
}


static PyTypeObject netr_UAS_INFO_0_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_UAS_INFO_0",
	.tp_getset = py_netr_UAS_INFO_0_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_UAS_INFO_0_new,
};


static PyObject *py_netr_AccountBuffer_get_blob(PyObject *obj, void *closure)
{
	struct netr_AccountBuffer *object = (struct netr_AccountBuffer *)pytalloc_get_ptr(obj);
	PyObject *py_blob;
	py_blob = PyString_FromStringAndSize((char *)(object->blob).data, (object->blob).length);
	return py_blob;
}

static int py_netr_AccountBuffer_set_blob(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_AccountBuffer *object = (struct netr_AccountBuffer *)pytalloc_get_ptr(py_obj);
	object->blob = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value), PyString_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_netr_AccountBuffer_getsetters[] = {
	{ discard_const_p(char, "blob"), py_netr_AccountBuffer_get_blob, py_netr_AccountBuffer_set_blob },
	{ NULL }
};

static PyObject *py_netr_AccountBuffer_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_AccountBuffer, type);
}


static PyTypeObject netr_AccountBuffer_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_AccountBuffer",
	.tp_getset = py_netr_AccountBuffer_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_AccountBuffer_new,
};


static PyObject *py_netr_NETLOGON_INFO_1_get_flags(PyObject *obj, void *closure)
{
	struct netr_NETLOGON_INFO_1 *object = (struct netr_NETLOGON_INFO_1 *)pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyInt_FromLong(object->flags);
	return py_flags;
}

static int py_netr_NETLOGON_INFO_1_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NETLOGON_INFO_1 *object = (struct netr_NETLOGON_INFO_1 *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->flags = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->flags = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netr_NETLOGON_INFO_1_get_pdc_connection_status(PyObject *obj, void *closure)
{
	struct netr_NETLOGON_INFO_1 *object = (struct netr_NETLOGON_INFO_1 *)pytalloc_get_ptr(obj);
	PyObject *py_pdc_connection_status;
	py_pdc_connection_status = PyErr_FromWERROR(object->pdc_connection_status);
	return py_pdc_connection_status;
}

static int py_netr_NETLOGON_INFO_1_set_pdc_connection_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NETLOGON_INFO_1 *object = (struct netr_NETLOGON_INFO_1 *)pytalloc_get_ptr(py_obj);
	object->pdc_connection_status = W_ERROR(PyInt_AsLong(value));
	return 0;
}

static PyGetSetDef py_netr_NETLOGON_INFO_1_getsetters[] = {
	{ discard_const_p(char, "flags"), py_netr_NETLOGON_INFO_1_get_flags, py_netr_NETLOGON_INFO_1_set_flags },
	{ discard_const_p(char, "pdc_connection_status"), py_netr_NETLOGON_INFO_1_get_pdc_connection_status, py_netr_NETLOGON_INFO_1_set_pdc_connection_status },
	{ NULL }
};

static PyObject *py_netr_NETLOGON_INFO_1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_NETLOGON_INFO_1, type);
}


static PyTypeObject netr_NETLOGON_INFO_1_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_NETLOGON_INFO_1",
	.tp_getset = py_netr_NETLOGON_INFO_1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_NETLOGON_INFO_1_new,
};


static PyObject *py_netr_NETLOGON_INFO_2_get_flags(PyObject *obj, void *closure)
{
	struct netr_NETLOGON_INFO_2 *object = (struct netr_NETLOGON_INFO_2 *)pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyInt_FromLong(object->flags);
	return py_flags;
}

static int py_netr_NETLOGON_INFO_2_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NETLOGON_INFO_2 *object = (struct netr_NETLOGON_INFO_2 *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->flags = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->flags = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netr_NETLOGON_INFO_2_get_pdc_connection_status(PyObject *obj, void *closure)
{
	struct netr_NETLOGON_INFO_2 *object = (struct netr_NETLOGON_INFO_2 *)pytalloc_get_ptr(obj);
	PyObject *py_pdc_connection_status;
	py_pdc_connection_status = PyErr_FromWERROR(object->pdc_connection_status);
	return py_pdc_connection_status;
}

static int py_netr_NETLOGON_INFO_2_set_pdc_connection_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NETLOGON_INFO_2 *object = (struct netr_NETLOGON_INFO_2 *)pytalloc_get_ptr(py_obj);
	object->pdc_connection_status = W_ERROR(PyInt_AsLong(value));
	return 0;
}

static PyObject *py_netr_NETLOGON_INFO_2_get_trusted_dc_name(PyObject *obj, void *closure)
{
	struct netr_NETLOGON_INFO_2 *object = (struct netr_NETLOGON_INFO_2 *)pytalloc_get_ptr(obj);
	PyObject *py_trusted_dc_name;
	if (object->trusted_dc_name == NULL) {
		py_trusted_dc_name = Py_None;
		Py_INCREF(py_trusted_dc_name);
	} else {
		if (object->trusted_dc_name == NULL) {
			py_trusted_dc_name = Py_None;
			Py_INCREF(py_trusted_dc_name);
		} else {
			py_trusted_dc_name = PyUnicode_Decode(object->trusted_dc_name, strlen(object->trusted_dc_name), "utf-8", "ignore");
		}
	}
	return py_trusted_dc_name;
}

static int py_netr_NETLOGON_INFO_2_set_trusted_dc_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NETLOGON_INFO_2 *object = (struct netr_NETLOGON_INFO_2 *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->trusted_dc_name = NULL;
	} else {
		object->trusted_dc_name = NULL;
		if (PyUnicode_Check(value)) {
			object->trusted_dc_name = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->trusted_dc_name = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_NETLOGON_INFO_2_get_tc_connection_status(PyObject *obj, void *closure)
{
	struct netr_NETLOGON_INFO_2 *object = (struct netr_NETLOGON_INFO_2 *)pytalloc_get_ptr(obj);
	PyObject *py_tc_connection_status;
	py_tc_connection_status = PyErr_FromWERROR(object->tc_connection_status);
	return py_tc_connection_status;
}

static int py_netr_NETLOGON_INFO_2_set_tc_connection_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NETLOGON_INFO_2 *object = (struct netr_NETLOGON_INFO_2 *)pytalloc_get_ptr(py_obj);
	object->tc_connection_status = W_ERROR(PyInt_AsLong(value));
	return 0;
}

static PyGetSetDef py_netr_NETLOGON_INFO_2_getsetters[] = {
	{ discard_const_p(char, "flags"), py_netr_NETLOGON_INFO_2_get_flags, py_netr_NETLOGON_INFO_2_set_flags },
	{ discard_const_p(char, "pdc_connection_status"), py_netr_NETLOGON_INFO_2_get_pdc_connection_status, py_netr_NETLOGON_INFO_2_set_pdc_connection_status },
	{ discard_const_p(char, "trusted_dc_name"), py_netr_NETLOGON_INFO_2_get_trusted_dc_name, py_netr_NETLOGON_INFO_2_set_trusted_dc_name },
	{ discard_const_p(char, "tc_connection_status"), py_netr_NETLOGON_INFO_2_get_tc_connection_status, py_netr_NETLOGON_INFO_2_set_tc_connection_status },
	{ NULL }
};

static PyObject *py_netr_NETLOGON_INFO_2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_NETLOGON_INFO_2, type);
}


static PyTypeObject netr_NETLOGON_INFO_2_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_NETLOGON_INFO_2",
	.tp_getset = py_netr_NETLOGON_INFO_2_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_NETLOGON_INFO_2_new,
};


static PyObject *py_netr_NETLOGON_INFO_3_get_flags(PyObject *obj, void *closure)
{
	struct netr_NETLOGON_INFO_3 *object = (struct netr_NETLOGON_INFO_3 *)pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyInt_FromLong(object->flags);
	return py_flags;
}

static int py_netr_NETLOGON_INFO_3_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NETLOGON_INFO_3 *object = (struct netr_NETLOGON_INFO_3 *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->flags = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->flags = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netr_NETLOGON_INFO_3_get_logon_attempts(PyObject *obj, void *closure)
{
	struct netr_NETLOGON_INFO_3 *object = (struct netr_NETLOGON_INFO_3 *)pytalloc_get_ptr(obj);
	PyObject *py_logon_attempts;
	py_logon_attempts = PyInt_FromLong(object->logon_attempts);
	return py_logon_attempts;
}

static int py_netr_NETLOGON_INFO_3_set_logon_attempts(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NETLOGON_INFO_3 *object = (struct netr_NETLOGON_INFO_3 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->logon_attempts = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_NETLOGON_INFO_3_get_unknown1(PyObject *obj, void *closure)
{
	struct netr_NETLOGON_INFO_3 *object = (struct netr_NETLOGON_INFO_3 *)pytalloc_get_ptr(obj);
	PyObject *py_unknown1;
	py_unknown1 = PyInt_FromLong(object->unknown1);
	return py_unknown1;
}

static int py_netr_NETLOGON_INFO_3_set_unknown1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NETLOGON_INFO_3 *object = (struct netr_NETLOGON_INFO_3 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown1 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_NETLOGON_INFO_3_get_unknown2(PyObject *obj, void *closure)
{
	struct netr_NETLOGON_INFO_3 *object = (struct netr_NETLOGON_INFO_3 *)pytalloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = PyInt_FromLong(object->unknown2);
	return py_unknown2;
}

static int py_netr_NETLOGON_INFO_3_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NETLOGON_INFO_3 *object = (struct netr_NETLOGON_INFO_3 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown2 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_NETLOGON_INFO_3_get_unknown3(PyObject *obj, void *closure)
{
	struct netr_NETLOGON_INFO_3 *object = (struct netr_NETLOGON_INFO_3 *)pytalloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = PyInt_FromLong(object->unknown3);
	return py_unknown3;
}

static int py_netr_NETLOGON_INFO_3_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NETLOGON_INFO_3 *object = (struct netr_NETLOGON_INFO_3 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown3 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_NETLOGON_INFO_3_get_unknown4(PyObject *obj, void *closure)
{
	struct netr_NETLOGON_INFO_3 *object = (struct netr_NETLOGON_INFO_3 *)pytalloc_get_ptr(obj);
	PyObject *py_unknown4;
	py_unknown4 = PyInt_FromLong(object->unknown4);
	return py_unknown4;
}

static int py_netr_NETLOGON_INFO_3_set_unknown4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NETLOGON_INFO_3 *object = (struct netr_NETLOGON_INFO_3 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown4 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_NETLOGON_INFO_3_get_unknown5(PyObject *obj, void *closure)
{
	struct netr_NETLOGON_INFO_3 *object = (struct netr_NETLOGON_INFO_3 *)pytalloc_get_ptr(obj);
	PyObject *py_unknown5;
	py_unknown5 = PyInt_FromLong(object->unknown5);
	return py_unknown5;
}

static int py_netr_NETLOGON_INFO_3_set_unknown5(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NETLOGON_INFO_3 *object = (struct netr_NETLOGON_INFO_3 *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->unknown5 = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_NETLOGON_INFO_3_getsetters[] = {
	{ discard_const_p(char, "flags"), py_netr_NETLOGON_INFO_3_get_flags, py_netr_NETLOGON_INFO_3_set_flags },
	{ discard_const_p(char, "logon_attempts"), py_netr_NETLOGON_INFO_3_get_logon_attempts, py_netr_NETLOGON_INFO_3_set_logon_attempts },
	{ discard_const_p(char, "unknown1"), py_netr_NETLOGON_INFO_3_get_unknown1, py_netr_NETLOGON_INFO_3_set_unknown1 },
	{ discard_const_p(char, "unknown2"), py_netr_NETLOGON_INFO_3_get_unknown2, py_netr_NETLOGON_INFO_3_set_unknown2 },
	{ discard_const_p(char, "unknown3"), py_netr_NETLOGON_INFO_3_get_unknown3, py_netr_NETLOGON_INFO_3_set_unknown3 },
	{ discard_const_p(char, "unknown4"), py_netr_NETLOGON_INFO_3_get_unknown4, py_netr_NETLOGON_INFO_3_set_unknown4 },
	{ discard_const_p(char, "unknown5"), py_netr_NETLOGON_INFO_3_get_unknown5, py_netr_NETLOGON_INFO_3_set_unknown5 },
	{ NULL }
};

static PyObject *py_netr_NETLOGON_INFO_3_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_NETLOGON_INFO_3, type);
}


static PyTypeObject netr_NETLOGON_INFO_3_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_NETLOGON_INFO_3",
	.tp_getset = py_netr_NETLOGON_INFO_3_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_NETLOGON_INFO_3_new,
};


static PyObject *py_netr_NETLOGON_INFO_4_get_trusted_dc_name(PyObject *obj, void *closure)
{
	struct netr_NETLOGON_INFO_4 *object = (struct netr_NETLOGON_INFO_4 *)pytalloc_get_ptr(obj);
	PyObject *py_trusted_dc_name;
	if (object->trusted_dc_name == NULL) {
		py_trusted_dc_name = Py_None;
		Py_INCREF(py_trusted_dc_name);
	} else {
		if (object->trusted_dc_name == NULL) {
			py_trusted_dc_name = Py_None;
			Py_INCREF(py_trusted_dc_name);
		} else {
			py_trusted_dc_name = PyUnicode_Decode(object->trusted_dc_name, strlen(object->trusted_dc_name), "utf-8", "ignore");
		}
	}
	return py_trusted_dc_name;
}

static int py_netr_NETLOGON_INFO_4_set_trusted_dc_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NETLOGON_INFO_4 *object = (struct netr_NETLOGON_INFO_4 *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->trusted_dc_name = NULL;
	} else {
		object->trusted_dc_name = NULL;
		if (PyUnicode_Check(value)) {
			object->trusted_dc_name = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->trusted_dc_name = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_NETLOGON_INFO_4_get_trusted_domain_name(PyObject *obj, void *closure)
{
	struct netr_NETLOGON_INFO_4 *object = (struct netr_NETLOGON_INFO_4 *)pytalloc_get_ptr(obj);
	PyObject *py_trusted_domain_name;
	if (object->trusted_domain_name == NULL) {
		py_trusted_domain_name = Py_None;
		Py_INCREF(py_trusted_domain_name);
	} else {
		if (object->trusted_domain_name == NULL) {
			py_trusted_domain_name = Py_None;
			Py_INCREF(py_trusted_domain_name);
		} else {
			py_trusted_domain_name = PyUnicode_Decode(object->trusted_domain_name, strlen(object->trusted_domain_name), "utf-8", "ignore");
		}
	}
	return py_trusted_domain_name;
}

static int py_netr_NETLOGON_INFO_4_set_trusted_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_NETLOGON_INFO_4 *object = (struct netr_NETLOGON_INFO_4 *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->trusted_domain_name = NULL;
	} else {
		object->trusted_domain_name = NULL;
		if (PyUnicode_Check(value)) {
			object->trusted_domain_name = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->trusted_domain_name = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_netr_NETLOGON_INFO_4_getsetters[] = {
	{ discard_const_p(char, "trusted_dc_name"), py_netr_NETLOGON_INFO_4_get_trusted_dc_name, py_netr_NETLOGON_INFO_4_set_trusted_dc_name },
	{ discard_const_p(char, "trusted_domain_name"), py_netr_NETLOGON_INFO_4_get_trusted_domain_name, py_netr_NETLOGON_INFO_4_set_trusted_domain_name },
	{ NULL }
};

static PyObject *py_netr_NETLOGON_INFO_4_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_NETLOGON_INFO_4, type);
}


static PyTypeObject netr_NETLOGON_INFO_4_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_NETLOGON_INFO_4",
	.tp_getset = py_netr_NETLOGON_INFO_4_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_NETLOGON_INFO_4_new,
};

PyObject *py_import_netr_CONTROL_QUERY_INFORMATION(TALLOC_CTX *mem_ctx, int level, union netr_CONTROL_QUERY_INFORMATION *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			if (in->info1 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_NETLOGON_INFO_1_Type, in->info1, in->info1);
			}
			return ret;

		case 2:
			if (in->info2 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_NETLOGON_INFO_2_Type, in->info2, in->info2);
			}
			return ret;

		case 3:
			if (in->info3 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_NETLOGON_INFO_3_Type, in->info3, in->info3);
			}
			return ret;

		case 4:
			if (in->info4 == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_NETLOGON_INFO_4_Type, in->info4, in->info4);
			}
			return ret;

		default:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union netr_CONTROL_QUERY_INFORMATION *py_export_netr_CONTROL_QUERY_INFORMATION(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union netr_CONTROL_QUERY_INFORMATION *ret = talloc_zero(mem_ctx, union netr_CONTROL_QUERY_INFORMATION);
	switch (level) {
		case 1:
			if (in == Py_None) {
				ret->info1 = NULL;
			} else {
				ret->info1 = NULL;
				PY_CHECK_TYPE(&netr_NETLOGON_INFO_1_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info1 = (struct netr_NETLOGON_INFO_1 *)pytalloc_get_ptr(in);
			}
			break;

		case 2:
			if (in == Py_None) {
				ret->info2 = NULL;
			} else {
				ret->info2 = NULL;
				PY_CHECK_TYPE(&netr_NETLOGON_INFO_2_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info2 = (struct netr_NETLOGON_INFO_2 *)pytalloc_get_ptr(in);
			}
			break;

		case 3:
			if (in == Py_None) {
				ret->info3 = NULL;
			} else {
				ret->info3 = NULL;
				PY_CHECK_TYPE(&netr_NETLOGON_INFO_3_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info3 = (struct netr_NETLOGON_INFO_3 *)pytalloc_get_ptr(in);
			}
			break;

		case 4:
			if (in == Py_None) {
				ret->info4 = NULL;
			} else {
				ret->info4 = NULL;
				PY_CHECK_TYPE(&netr_NETLOGON_INFO_4_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->info4 = (struct netr_NETLOGON_INFO_4 *)pytalloc_get_ptr(in);
			}
			break;

		default:
			break;

	}

	return ret;
}

PyObject *py_import_netr_CONTROL_DATA_INFORMATION(TALLOC_CTX *mem_ctx, int level, union netr_CONTROL_DATA_INFORMATION *in)
{
	PyObject *ret;

	switch (level) {
		case NETLOGON_CONTROL_REDISCOVER:
			if (in->domain == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				if (in->domain == NULL) {
					ret = Py_None;
					Py_INCREF(ret);
				} else {
					ret = PyUnicode_Decode(in->domain, strlen(in->domain), "utf-8", "ignore");
				}
			}
			return ret;

		case NETLOGON_CONTROL_TC_QUERY:
			if (in->domain == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				if (in->domain == NULL) {
					ret = Py_None;
					Py_INCREF(ret);
				} else {
					ret = PyUnicode_Decode(in->domain, strlen(in->domain), "utf-8", "ignore");
				}
			}
			return ret;

		case NETLOGON_CONTROL_TRANSPORT_NOTIFY:
			if (in->domain == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				if (in->domain == NULL) {
					ret = Py_None;
					Py_INCREF(ret);
				} else {
					ret = PyUnicode_Decode(in->domain, strlen(in->domain), "utf-8", "ignore");
				}
			}
			return ret;

		case NETLOGON_CONTROL_CHANGE_PASSWORD:
			if (in->domain == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				if (in->domain == NULL) {
					ret = Py_None;
					Py_INCREF(ret);
				} else {
					ret = PyUnicode_Decode(in->domain, strlen(in->domain), "utf-8", "ignore");
				}
			}
			return ret;

		case NETLOGON_CONTROL_TC_VERIFY:
			if (in->domain == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				if (in->domain == NULL) {
					ret = Py_None;
					Py_INCREF(ret);
				} else {
					ret = PyUnicode_Decode(in->domain, strlen(in->domain), "utf-8", "ignore");
				}
			}
			return ret;

		case NETLOGON_CONTROL_FIND_USER:
			if (in->user == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				if (in->user == NULL) {
					ret = Py_None;
					Py_INCREF(ret);
				} else {
					ret = PyUnicode_Decode(in->user, strlen(in->user), "utf-8", "ignore");
				}
			}
			return ret;

		case NETLOGON_CONTROL_SET_DBFLAG:
			ret = PyInt_FromLong(in->debug_level);
			return ret;

		default:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union netr_CONTROL_DATA_INFORMATION *py_export_netr_CONTROL_DATA_INFORMATION(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union netr_CONTROL_DATA_INFORMATION *ret = talloc_zero(mem_ctx, union netr_CONTROL_DATA_INFORMATION);
	switch (level) {
		case NETLOGON_CONTROL_REDISCOVER:
			if (in == Py_None) {
				ret->domain = NULL;
			} else {
				ret->domain = NULL;
				if (PyUnicode_Check(in)) {
					ret->domain = PyString_AS_STRING(PyUnicode_AsEncodedString(in, "utf-8", "ignore"));
				} else if (PyString_Check(in)) {
					ret->domain = PyString_AS_STRING(in);
				} else {
					PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case NETLOGON_CONTROL_TC_QUERY:
			if (in == Py_None) {
				ret->domain = NULL;
			} else {
				ret->domain = NULL;
				if (PyUnicode_Check(in)) {
					ret->domain = PyString_AS_STRING(PyUnicode_AsEncodedString(in, "utf-8", "ignore"));
				} else if (PyString_Check(in)) {
					ret->domain = PyString_AS_STRING(in);
				} else {
					PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case NETLOGON_CONTROL_TRANSPORT_NOTIFY:
			if (in == Py_None) {
				ret->domain = NULL;
			} else {
				ret->domain = NULL;
				if (PyUnicode_Check(in)) {
					ret->domain = PyString_AS_STRING(PyUnicode_AsEncodedString(in, "utf-8", "ignore"));
				} else if (PyString_Check(in)) {
					ret->domain = PyString_AS_STRING(in);
				} else {
					PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case NETLOGON_CONTROL_CHANGE_PASSWORD:
			if (in == Py_None) {
				ret->domain = NULL;
			} else {
				ret->domain = NULL;
				if (PyUnicode_Check(in)) {
					ret->domain = PyString_AS_STRING(PyUnicode_AsEncodedString(in, "utf-8", "ignore"));
				} else if (PyString_Check(in)) {
					ret->domain = PyString_AS_STRING(in);
				} else {
					PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case NETLOGON_CONTROL_TC_VERIFY:
			if (in == Py_None) {
				ret->domain = NULL;
			} else {
				ret->domain = NULL;
				if (PyUnicode_Check(in)) {
					ret->domain = PyString_AS_STRING(PyUnicode_AsEncodedString(in, "utf-8", "ignore"));
				} else if (PyString_Check(in)) {
					ret->domain = PyString_AS_STRING(in);
				} else {
					PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case NETLOGON_CONTROL_FIND_USER:
			if (in == Py_None) {
				ret->user = NULL;
			} else {
				ret->user = NULL;
				if (PyUnicode_Check(in)) {
					ret->user = PyString_AS_STRING(PyUnicode_AsEncodedString(in, "utf-8", "ignore"));
				} else if (PyString_Check(in)) {
					ret->user = PyString_AS_STRING(in);
				} else {
					PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case NETLOGON_CONTROL_SET_DBFLAG:
			PY_CHECK_TYPE(&PyInt_Type, in, talloc_free(ret); return NULL;);
			ret->debug_level = PyInt_AsLong(in);
			break;

		default:
			break;

	}

	return ret;
}

PyObject *py_import_netr_ChangeLogObject(TALLOC_CTX *mem_ctx, int level, union netr_ChangeLogObject *in)
{
	PyObject *ret;

	switch (level) {
		case NETR_CHANGELOG_SID_INCLUDED:
			ret = pytalloc_reference_ex(dom_sid_Type, mem_ctx, &in->object_sid);
			return ret;

		case NETR_CHANGELOG_NAME_INCLUDED:
			ret = PyString_FromStringOrNULL(in->object_name);
			return ret;

		default:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union netr_ChangeLogObject *py_export_netr_ChangeLogObject(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union netr_ChangeLogObject *ret = talloc_zero(mem_ctx, union netr_ChangeLogObject);
	switch (level) {
		case NETR_CHANGELOG_SID_INCLUDED:
			PY_CHECK_TYPE(dom_sid_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->object_sid = *(struct dom_sid *)pytalloc_get_ptr(in);
			break;

		case NETR_CHANGELOG_NAME_INCLUDED:
			ret->object_name = talloc_strdup(mem_ctx, PyString_AS_STRING(in));
			break;

		default:
			break;

	}

	return ret;
}


static PyObject *py_netr_ChangeLogEntry_get_serial_number1(PyObject *obj, void *closure)
{
	struct netr_ChangeLogEntry *object = (struct netr_ChangeLogEntry *)pytalloc_get_ptr(obj);
	PyObject *py_serial_number1;
	py_serial_number1 = PyInt_FromLong(object->serial_number1);
	return py_serial_number1;
}

static int py_netr_ChangeLogEntry_set_serial_number1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_ChangeLogEntry *object = (struct netr_ChangeLogEntry *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->serial_number1 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_ChangeLogEntry_get_serial_number2(PyObject *obj, void *closure)
{
	struct netr_ChangeLogEntry *object = (struct netr_ChangeLogEntry *)pytalloc_get_ptr(obj);
	PyObject *py_serial_number2;
	py_serial_number2 = PyInt_FromLong(object->serial_number2);
	return py_serial_number2;
}

static int py_netr_ChangeLogEntry_set_serial_number2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_ChangeLogEntry *object = (struct netr_ChangeLogEntry *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->serial_number2 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_ChangeLogEntry_get_object_rid(PyObject *obj, void *closure)
{
	struct netr_ChangeLogEntry *object = (struct netr_ChangeLogEntry *)pytalloc_get_ptr(obj);
	PyObject *py_object_rid;
	py_object_rid = PyInt_FromLong(object->object_rid);
	return py_object_rid;
}

static int py_netr_ChangeLogEntry_set_object_rid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_ChangeLogEntry *object = (struct netr_ChangeLogEntry *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->object_rid = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_ChangeLogEntry_get_flags(PyObject *obj, void *closure)
{
	struct netr_ChangeLogEntry *object = (struct netr_ChangeLogEntry *)pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyInt_FromLong(object->flags);
	return py_flags;
}

static int py_netr_ChangeLogEntry_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_ChangeLogEntry *object = (struct netr_ChangeLogEntry *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->flags = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->flags = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netr_ChangeLogEntry_get_db_index(PyObject *obj, void *closure)
{
	struct netr_ChangeLogEntry *object = (struct netr_ChangeLogEntry *)pytalloc_get_ptr(obj);
	PyObject *py_db_index;
	py_db_index = PyInt_FromLong(object->db_index);
	return py_db_index;
}

static int py_netr_ChangeLogEntry_set_db_index(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_ChangeLogEntry *object = (struct netr_ChangeLogEntry *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->db_index = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->db_index = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netr_ChangeLogEntry_get_delta_type(PyObject *obj, void *closure)
{
	struct netr_ChangeLogEntry *object = (struct netr_ChangeLogEntry *)pytalloc_get_ptr(obj);
	PyObject *py_delta_type;
	py_delta_type = PyInt_FromLong(object->delta_type);
	return py_delta_type;
}

static int py_netr_ChangeLogEntry_set_delta_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_ChangeLogEntry *object = (struct netr_ChangeLogEntry *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->delta_type = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->delta_type = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netr_ChangeLogEntry_get_object(PyObject *obj, void *closure)
{
	struct netr_ChangeLogEntry *object = (struct netr_ChangeLogEntry *)pytalloc_get_ptr(obj);
	PyObject *py_object;
	py_object = py_import_netr_ChangeLogObject(pytalloc_get_mem_ctx(obj), object->flags & (NETR_CHANGELOG_SID_INCLUDED | NETR_CHANGELOG_NAME_INCLUDED), &object->object);
	if (py_object == NULL) {
		return NULL;
	}
	return py_object;
}

static int py_netr_ChangeLogEntry_set_object(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_ChangeLogEntry *object = (struct netr_ChangeLogEntry *)pytalloc_get_ptr(py_obj);
	{
		union netr_ChangeLogObject *object_switch_0;
		object_switch_0 = py_export_netr_ChangeLogObject(pytalloc_get_mem_ctx(py_obj), object->flags & (NETR_CHANGELOG_SID_INCLUDED | NETR_CHANGELOG_NAME_INCLUDED), value);
		if (object_switch_0 == NULL) {
			return -1;
		}
		object->object = *object_switch_0;
	}
	return 0;
}

static PyGetSetDef py_netr_ChangeLogEntry_getsetters[] = {
	{ discard_const_p(char, "serial_number1"), py_netr_ChangeLogEntry_get_serial_number1, py_netr_ChangeLogEntry_set_serial_number1 },
	{ discard_const_p(char, "serial_number2"), py_netr_ChangeLogEntry_get_serial_number2, py_netr_ChangeLogEntry_set_serial_number2 },
	{ discard_const_p(char, "object_rid"), py_netr_ChangeLogEntry_get_object_rid, py_netr_ChangeLogEntry_set_object_rid },
	{ discard_const_p(char, "flags"), py_netr_ChangeLogEntry_get_flags, py_netr_ChangeLogEntry_set_flags },
	{ discard_const_p(char, "db_index"), py_netr_ChangeLogEntry_get_db_index, py_netr_ChangeLogEntry_set_db_index },
	{ discard_const_p(char, "delta_type"), py_netr_ChangeLogEntry_get_delta_type, py_netr_ChangeLogEntry_set_delta_type },
	{ discard_const_p(char, "object"), py_netr_ChangeLogEntry_get_object, py_netr_ChangeLogEntry_set_object },
	{ NULL }
};

static PyObject *py_netr_ChangeLogEntry_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_ChangeLogEntry, type);
}

static PyObject *py_netr_ChangeLogEntry_ndr_pack(PyObject *py_obj)
{
	struct netr_ChangeLogEntry *object = (struct netr_ChangeLogEntry *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_netr_ChangeLogEntry);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_netr_ChangeLogEntry_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_ChangeLogEntry *object = (struct netr_ChangeLogEntry *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_ChangeLogEntry);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_ChangeLogEntry);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_netr_ChangeLogEntry_ndr_print(PyObject *py_obj)
{
	struct netr_ChangeLogEntry *object = (struct netr_ChangeLogEntry *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_ChangeLogEntry, "netr_ChangeLogEntry", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_netr_ChangeLogEntry_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_netr_ChangeLogEntry_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_netr_ChangeLogEntry_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_netr_ChangeLogEntry_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netr_ChangeLogEntry_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_ChangeLogEntry",
	.tp_getset = py_netr_ChangeLogEntry_getsetters,
	.tp_methods = py_netr_ChangeLogEntry_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_ChangeLogEntry_new,
};


static PyObject *py_netr_Blob_get_length(PyObject *obj, void *closure)
{
	struct netr_Blob *object = (struct netr_Blob *)pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyInt_FromLong(object->length);
	return py_length;
}

static int py_netr_Blob_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_Blob *object = (struct netr_Blob *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_Blob_get_data(PyObject *obj, void *closure)
{
	struct netr_Blob *object = (struct netr_Blob *)pytalloc_get_ptr(obj);
	PyObject *py_data;
	if (object->data == NULL) {
		py_data = Py_None;
		Py_INCREF(py_data);
	} else {
		py_data = PyList_New(object->length);
		if (py_data == NULL) {
			return NULL;
		}
		{
			int data_cntr_1;
			for (data_cntr_1 = 0; data_cntr_1 < object->length; data_cntr_1++) {
				PyObject *py_data_1;
				py_data_1 = PyInt_FromLong(object->data[data_cntr_1]);
				PyList_SetItem(py_data, data_cntr_1, py_data_1);
			}
		}
	}
	return py_data;
}

static int py_netr_Blob_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_Blob *object = (struct netr_Blob *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->data);
	if (value == Py_None) {
		object->data = NULL;
	} else {
		object->data = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int data_cntr_1;
			object->data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->data, PyList_GET_SIZE(value));
			if (!object->data) { return -1;; }
			talloc_set_name_const(object->data, "ARRAY: object->data");
			for (data_cntr_1 = 0; data_cntr_1 < PyList_GET_SIZE(value); data_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, data_cntr_1), return -1;);
				object->data[data_cntr_1] = PyInt_AsLong(PyList_GET_ITEM(value, data_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_netr_Blob_getsetters[] = {
	{ discard_const_p(char, "length"), py_netr_Blob_get_length, py_netr_Blob_set_length },
	{ discard_const_p(char, "data"), py_netr_Blob_get_data, py_netr_Blob_set_data },
	{ NULL }
};

static PyObject *py_netr_Blob_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_Blob, type);
}


static PyTypeObject netr_Blob_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_Blob",
	.tp_getset = py_netr_Blob_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_Blob_new,
};


static PyObject *py_netr_DsRGetDCNameInfo_get_dc_unc(PyObject *obj, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = (struct netr_DsRGetDCNameInfo *)pytalloc_get_ptr(obj);
	PyObject *py_dc_unc;
	if (object->dc_unc == NULL) {
		py_dc_unc = Py_None;
		Py_INCREF(py_dc_unc);
	} else {
		if (object->dc_unc == NULL) {
			py_dc_unc = Py_None;
			Py_INCREF(py_dc_unc);
		} else {
			py_dc_unc = PyUnicode_Decode(object->dc_unc, strlen(object->dc_unc), "utf-8", "ignore");
		}
	}
	return py_dc_unc;
}

static int py_netr_DsRGetDCNameInfo_set_dc_unc(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = (struct netr_DsRGetDCNameInfo *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->dc_unc = NULL;
	} else {
		object->dc_unc = NULL;
		if (PyUnicode_Check(value)) {
			object->dc_unc = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->dc_unc = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DsRGetDCNameInfo_get_dc_address(PyObject *obj, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = (struct netr_DsRGetDCNameInfo *)pytalloc_get_ptr(obj);
	PyObject *py_dc_address;
	if (object->dc_address == NULL) {
		py_dc_address = Py_None;
		Py_INCREF(py_dc_address);
	} else {
		if (object->dc_address == NULL) {
			py_dc_address = Py_None;
			Py_INCREF(py_dc_address);
		} else {
			py_dc_address = PyUnicode_Decode(object->dc_address, strlen(object->dc_address), "utf-8", "ignore");
		}
	}
	return py_dc_address;
}

static int py_netr_DsRGetDCNameInfo_set_dc_address(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = (struct netr_DsRGetDCNameInfo *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->dc_address = NULL;
	} else {
		object->dc_address = NULL;
		if (PyUnicode_Check(value)) {
			object->dc_address = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->dc_address = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DsRGetDCNameInfo_get_dc_address_type(PyObject *obj, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = (struct netr_DsRGetDCNameInfo *)pytalloc_get_ptr(obj);
	PyObject *py_dc_address_type;
	py_dc_address_type = PyInt_FromLong(object->dc_address_type);
	return py_dc_address_type;
}

static int py_netr_DsRGetDCNameInfo_set_dc_address_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = (struct netr_DsRGetDCNameInfo *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->dc_address_type = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->dc_address_type = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netr_DsRGetDCNameInfo_get_domain_guid(PyObject *obj, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = (struct netr_DsRGetDCNameInfo *)pytalloc_get_ptr(obj);
	PyObject *py_domain_guid;
	py_domain_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->domain_guid);
	return py_domain_guid;
}

static int py_netr_DsRGetDCNameInfo_set_domain_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = (struct netr_DsRGetDCNameInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->domain_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DsRGetDCNameInfo_get_domain_name(PyObject *obj, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = (struct netr_DsRGetDCNameInfo *)pytalloc_get_ptr(obj);
	PyObject *py_domain_name;
	if (object->domain_name == NULL) {
		py_domain_name = Py_None;
		Py_INCREF(py_domain_name);
	} else {
		if (object->domain_name == NULL) {
			py_domain_name = Py_None;
			Py_INCREF(py_domain_name);
		} else {
			py_domain_name = PyUnicode_Decode(object->domain_name, strlen(object->domain_name), "utf-8", "ignore");
		}
	}
	return py_domain_name;
}

static int py_netr_DsRGetDCNameInfo_set_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = (struct netr_DsRGetDCNameInfo *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->domain_name = NULL;
	} else {
		object->domain_name = NULL;
		if (PyUnicode_Check(value)) {
			object->domain_name = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->domain_name = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DsRGetDCNameInfo_get_forest_name(PyObject *obj, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = (struct netr_DsRGetDCNameInfo *)pytalloc_get_ptr(obj);
	PyObject *py_forest_name;
	if (object->forest_name == NULL) {
		py_forest_name = Py_None;
		Py_INCREF(py_forest_name);
	} else {
		if (object->forest_name == NULL) {
			py_forest_name = Py_None;
			Py_INCREF(py_forest_name);
		} else {
			py_forest_name = PyUnicode_Decode(object->forest_name, strlen(object->forest_name), "utf-8", "ignore");
		}
	}
	return py_forest_name;
}

static int py_netr_DsRGetDCNameInfo_set_forest_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = (struct netr_DsRGetDCNameInfo *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->forest_name = NULL;
	} else {
		object->forest_name = NULL;
		if (PyUnicode_Check(value)) {
			object->forest_name = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->forest_name = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DsRGetDCNameInfo_get_dc_flags(PyObject *obj, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = (struct netr_DsRGetDCNameInfo *)pytalloc_get_ptr(obj);
	PyObject *py_dc_flags;
	py_dc_flags = PyInt_FromLong(object->dc_flags);
	return py_dc_flags;
}

static int py_netr_DsRGetDCNameInfo_set_dc_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = (struct netr_DsRGetDCNameInfo *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->dc_flags = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->dc_flags = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netr_DsRGetDCNameInfo_get_dc_site_name(PyObject *obj, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = (struct netr_DsRGetDCNameInfo *)pytalloc_get_ptr(obj);
	PyObject *py_dc_site_name;
	if (object->dc_site_name == NULL) {
		py_dc_site_name = Py_None;
		Py_INCREF(py_dc_site_name);
	} else {
		if (object->dc_site_name == NULL) {
			py_dc_site_name = Py_None;
			Py_INCREF(py_dc_site_name);
		} else {
			py_dc_site_name = PyUnicode_Decode(object->dc_site_name, strlen(object->dc_site_name), "utf-8", "ignore");
		}
	}
	return py_dc_site_name;
}

static int py_netr_DsRGetDCNameInfo_set_dc_site_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = (struct netr_DsRGetDCNameInfo *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->dc_site_name = NULL;
	} else {
		object->dc_site_name = NULL;
		if (PyUnicode_Check(value)) {
			object->dc_site_name = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->dc_site_name = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DsRGetDCNameInfo_get_client_site_name(PyObject *obj, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = (struct netr_DsRGetDCNameInfo *)pytalloc_get_ptr(obj);
	PyObject *py_client_site_name;
	if (object->client_site_name == NULL) {
		py_client_site_name = Py_None;
		Py_INCREF(py_client_site_name);
	} else {
		if (object->client_site_name == NULL) {
			py_client_site_name = Py_None;
			Py_INCREF(py_client_site_name);
		} else {
			py_client_site_name = PyUnicode_Decode(object->client_site_name, strlen(object->client_site_name), "utf-8", "ignore");
		}
	}
	return py_client_site_name;
}

static int py_netr_DsRGetDCNameInfo_set_client_site_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DsRGetDCNameInfo *object = (struct netr_DsRGetDCNameInfo *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->client_site_name = NULL;
	} else {
		object->client_site_name = NULL;
		if (PyUnicode_Check(value)) {
			object->client_site_name = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->client_site_name = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_netr_DsRGetDCNameInfo_getsetters[] = {
	{ discard_const_p(char, "dc_unc"), py_netr_DsRGetDCNameInfo_get_dc_unc, py_netr_DsRGetDCNameInfo_set_dc_unc },
	{ discard_const_p(char, "dc_address"), py_netr_DsRGetDCNameInfo_get_dc_address, py_netr_DsRGetDCNameInfo_set_dc_address },
	{ discard_const_p(char, "dc_address_type"), py_netr_DsRGetDCNameInfo_get_dc_address_type, py_netr_DsRGetDCNameInfo_set_dc_address_type },
	{ discard_const_p(char, "domain_guid"), py_netr_DsRGetDCNameInfo_get_domain_guid, py_netr_DsRGetDCNameInfo_set_domain_guid },
	{ discard_const_p(char, "domain_name"), py_netr_DsRGetDCNameInfo_get_domain_name, py_netr_DsRGetDCNameInfo_set_domain_name },
	{ discard_const_p(char, "forest_name"), py_netr_DsRGetDCNameInfo_get_forest_name, py_netr_DsRGetDCNameInfo_set_forest_name },
	{ discard_const_p(char, "dc_flags"), py_netr_DsRGetDCNameInfo_get_dc_flags, py_netr_DsRGetDCNameInfo_set_dc_flags },
	{ discard_const_p(char, "dc_site_name"), py_netr_DsRGetDCNameInfo_get_dc_site_name, py_netr_DsRGetDCNameInfo_set_dc_site_name },
	{ discard_const_p(char, "client_site_name"), py_netr_DsRGetDCNameInfo_get_client_site_name, py_netr_DsRGetDCNameInfo_set_client_site_name },
	{ NULL }
};

static PyObject *py_netr_DsRGetDCNameInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_DsRGetDCNameInfo, type);
}

static PyObject *py_netr_DsRGetDCNameInfo_ndr_pack(PyObject *py_obj)
{
	struct netr_DsRGetDCNameInfo *object = (struct netr_DsRGetDCNameInfo *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_netr_DsRGetDCNameInfo);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_netr_DsRGetDCNameInfo_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct netr_DsRGetDCNameInfo *object = (struct netr_DsRGetDCNameInfo *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_DsRGetDCNameInfo);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_netr_DsRGetDCNameInfo);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_netr_DsRGetDCNameInfo_ndr_print(PyObject *py_obj)
{
	struct netr_DsRGetDCNameInfo *object = (struct netr_DsRGetDCNameInfo *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_netr_DsRGetDCNameInfo, "netr_DsRGetDCNameInfo", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_netr_DsRGetDCNameInfo_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_netr_DsRGetDCNameInfo_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_netr_DsRGetDCNameInfo_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_netr_DsRGetDCNameInfo_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject netr_DsRGetDCNameInfo_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_DsRGetDCNameInfo",
	.tp_getset = py_netr_DsRGetDCNameInfo_getsetters,
	.tp_methods = py_netr_DsRGetDCNameInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_DsRGetDCNameInfo_new,
};

PyObject *py_import_netr_Capabilities(TALLOC_CTX *mem_ctx, int level, union netr_Capabilities *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			ret = PyInt_FromLong(in->server_capabilities);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union netr_Capabilities *py_export_netr_Capabilities(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union netr_Capabilities *ret = talloc_zero(mem_ctx, union netr_Capabilities);
	switch (level) {
		case 1:
			if (PyLong_Check(in)) {
				ret->server_capabilities = PyLong_AsLongLong(in);
			} else if (PyInt_Check(in)) {
				ret->server_capabilities = PyInt_AsLong(in);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
				  PyInt_Type.tp_name, PyLong_Type.tp_name);
				talloc_free(ret); return NULL;
			}
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}


static PyObject *py_netr_LsaPolicyInformation_get_policy_size(PyObject *obj, void *closure)
{
	struct netr_LsaPolicyInformation *object = (struct netr_LsaPolicyInformation *)pytalloc_get_ptr(obj);
	PyObject *py_policy_size;
	py_policy_size = PyInt_FromLong(object->policy_size);
	return py_policy_size;
}

static int py_netr_LsaPolicyInformation_set_policy_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_LsaPolicyInformation *object = (struct netr_LsaPolicyInformation *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->policy_size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_LsaPolicyInformation_get_policy(PyObject *obj, void *closure)
{
	struct netr_LsaPolicyInformation *object = (struct netr_LsaPolicyInformation *)pytalloc_get_ptr(obj);
	PyObject *py_policy;
	if (object->policy == NULL) {
		py_policy = Py_None;
		Py_INCREF(py_policy);
	} else {
		py_policy = PyList_New(object->policy_size);
		if (py_policy == NULL) {
			return NULL;
		}
		{
			int policy_cntr_1;
			for (policy_cntr_1 = 0; policy_cntr_1 < object->policy_size; policy_cntr_1++) {
				PyObject *py_policy_1;
				py_policy_1 = PyInt_FromLong(object->policy[policy_cntr_1]);
				PyList_SetItem(py_policy, policy_cntr_1, py_policy_1);
			}
		}
	}
	return py_policy;
}

static int py_netr_LsaPolicyInformation_set_policy(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_LsaPolicyInformation *object = (struct netr_LsaPolicyInformation *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->policy);
	if (value == Py_None) {
		object->policy = NULL;
	} else {
		object->policy = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int policy_cntr_1;
			object->policy = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->policy, PyList_GET_SIZE(value));
			if (!object->policy) { return -1;; }
			talloc_set_name_const(object->policy, "ARRAY: object->policy");
			for (policy_cntr_1 = 0; policy_cntr_1 < PyList_GET_SIZE(value); policy_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, policy_cntr_1), return -1;);
				object->policy[policy_cntr_1] = PyInt_AsLong(PyList_GET_ITEM(value, policy_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_netr_LsaPolicyInformation_getsetters[] = {
	{ discard_const_p(char, "policy_size"), py_netr_LsaPolicyInformation_get_policy_size, py_netr_LsaPolicyInformation_set_policy_size },
	{ discard_const_p(char, "policy"), py_netr_LsaPolicyInformation_get_policy, py_netr_LsaPolicyInformation_set_policy },
	{ NULL }
};

static PyObject *py_netr_LsaPolicyInformation_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_LsaPolicyInformation, type);
}


static PyTypeObject netr_LsaPolicyInformation_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_LsaPolicyInformation",
	.tp_getset = py_netr_LsaPolicyInformation_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_LsaPolicyInformation_new,
};


static PyObject *py_netr_OsVersionInfoEx_get_OSVersionInfoSize(PyObject *obj, void *closure)
{
	struct netr_OsVersionInfoEx *object = (struct netr_OsVersionInfoEx *)pytalloc_get_ptr(obj);
	PyObject *py_OSVersionInfoSize;
	py_OSVersionInfoSize = PyInt_FromLong(object->OSVersionInfoSize);
	return py_OSVersionInfoSize;
}

static int py_netr_OsVersionInfoEx_set_OSVersionInfoSize(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OsVersionInfoEx *object = (struct netr_OsVersionInfoEx *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->OSVersionInfoSize = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_OsVersionInfoEx_get_MajorVersion(PyObject *obj, void *closure)
{
	struct netr_OsVersionInfoEx *object = (struct netr_OsVersionInfoEx *)pytalloc_get_ptr(obj);
	PyObject *py_MajorVersion;
	py_MajorVersion = PyInt_FromLong(object->MajorVersion);
	return py_MajorVersion;
}

static int py_netr_OsVersionInfoEx_set_MajorVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OsVersionInfoEx *object = (struct netr_OsVersionInfoEx *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->MajorVersion = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_OsVersionInfoEx_get_MinorVersion(PyObject *obj, void *closure)
{
	struct netr_OsVersionInfoEx *object = (struct netr_OsVersionInfoEx *)pytalloc_get_ptr(obj);
	PyObject *py_MinorVersion;
	py_MinorVersion = PyInt_FromLong(object->MinorVersion);
	return py_MinorVersion;
}

static int py_netr_OsVersionInfoEx_set_MinorVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OsVersionInfoEx *object = (struct netr_OsVersionInfoEx *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->MinorVersion = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_OsVersionInfoEx_get_BuildNumber(PyObject *obj, void *closure)
{
	struct netr_OsVersionInfoEx *object = (struct netr_OsVersionInfoEx *)pytalloc_get_ptr(obj);
	PyObject *py_BuildNumber;
	py_BuildNumber = PyInt_FromLong(object->BuildNumber);
	return py_BuildNumber;
}

static int py_netr_OsVersionInfoEx_set_BuildNumber(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OsVersionInfoEx *object = (struct netr_OsVersionInfoEx *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->BuildNumber = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_OsVersionInfoEx_get_PlatformId(PyObject *obj, void *closure)
{
	struct netr_OsVersionInfoEx *object = (struct netr_OsVersionInfoEx *)pytalloc_get_ptr(obj);
	PyObject *py_PlatformId;
	py_PlatformId = PyInt_FromLong(object->PlatformId);
	return py_PlatformId;
}

static int py_netr_OsVersionInfoEx_set_PlatformId(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OsVersionInfoEx *object = (struct netr_OsVersionInfoEx *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->PlatformId = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_OsVersionInfoEx_get_CSDVersion(PyObject *obj, void *closure)
{
	struct netr_OsVersionInfoEx *object = (struct netr_OsVersionInfoEx *)pytalloc_get_ptr(obj);
	PyObject *py_CSDVersion;
	py_CSDVersion = PyString_FromStringOrNULL(object->CSDVersion);
	return py_CSDVersion;
}

static int py_netr_OsVersionInfoEx_set_CSDVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OsVersionInfoEx *object = (struct netr_OsVersionInfoEx *)pytalloc_get_ptr(py_obj);
	object->CSDVersion = talloc_strdup(pytalloc_get_mem_ctx(py_obj), PyString_AS_STRING(value));
	return 0;
}

static PyObject *py_netr_OsVersionInfoEx_get_ServicePackMajor(PyObject *obj, void *closure)
{
	struct netr_OsVersionInfoEx *object = (struct netr_OsVersionInfoEx *)pytalloc_get_ptr(obj);
	PyObject *py_ServicePackMajor;
	py_ServicePackMajor = PyInt_FromLong(object->ServicePackMajor);
	return py_ServicePackMajor;
}

static int py_netr_OsVersionInfoEx_set_ServicePackMajor(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OsVersionInfoEx *object = (struct netr_OsVersionInfoEx *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->ServicePackMajor = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_OsVersionInfoEx_get_ServicePackMinor(PyObject *obj, void *closure)
{
	struct netr_OsVersionInfoEx *object = (struct netr_OsVersionInfoEx *)pytalloc_get_ptr(obj);
	PyObject *py_ServicePackMinor;
	py_ServicePackMinor = PyInt_FromLong(object->ServicePackMinor);
	return py_ServicePackMinor;
}

static int py_netr_OsVersionInfoEx_set_ServicePackMinor(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OsVersionInfoEx *object = (struct netr_OsVersionInfoEx *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->ServicePackMinor = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_OsVersionInfoEx_get_SuiteMask(PyObject *obj, void *closure)
{
	struct netr_OsVersionInfoEx *object = (struct netr_OsVersionInfoEx *)pytalloc_get_ptr(obj);
	PyObject *py_SuiteMask;
	py_SuiteMask = PyInt_FromLong(object->SuiteMask);
	return py_SuiteMask;
}

static int py_netr_OsVersionInfoEx_set_SuiteMask(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OsVersionInfoEx *object = (struct netr_OsVersionInfoEx *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->SuiteMask = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->SuiteMask = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netr_OsVersionInfoEx_get_ProductType(PyObject *obj, void *closure)
{
	struct netr_OsVersionInfoEx *object = (struct netr_OsVersionInfoEx *)pytalloc_get_ptr(obj);
	PyObject *py_ProductType;
	py_ProductType = PyInt_FromLong(object->ProductType);
	return py_ProductType;
}

static int py_netr_OsVersionInfoEx_set_ProductType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OsVersionInfoEx *object = (struct netr_OsVersionInfoEx *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->ProductType = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->ProductType = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netr_OsVersionInfoEx_get_Reserved(PyObject *obj, void *closure)
{
	struct netr_OsVersionInfoEx *object = (struct netr_OsVersionInfoEx *)pytalloc_get_ptr(obj);
	PyObject *py_Reserved;
	py_Reserved = PyInt_FromLong(object->Reserved);
	return py_Reserved;
}

static int py_netr_OsVersionInfoEx_set_Reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OsVersionInfoEx *object = (struct netr_OsVersionInfoEx *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->Reserved = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_OsVersionInfoEx_getsetters[] = {
	{ discard_const_p(char, "OSVersionInfoSize"), py_netr_OsVersionInfoEx_get_OSVersionInfoSize, py_netr_OsVersionInfoEx_set_OSVersionInfoSize },
	{ discard_const_p(char, "MajorVersion"), py_netr_OsVersionInfoEx_get_MajorVersion, py_netr_OsVersionInfoEx_set_MajorVersion },
	{ discard_const_p(char, "MinorVersion"), py_netr_OsVersionInfoEx_get_MinorVersion, py_netr_OsVersionInfoEx_set_MinorVersion },
	{ discard_const_p(char, "BuildNumber"), py_netr_OsVersionInfoEx_get_BuildNumber, py_netr_OsVersionInfoEx_set_BuildNumber },
	{ discard_const_p(char, "PlatformId"), py_netr_OsVersionInfoEx_get_PlatformId, py_netr_OsVersionInfoEx_set_PlatformId },
	{ discard_const_p(char, "CSDVersion"), py_netr_OsVersionInfoEx_get_CSDVersion, py_netr_OsVersionInfoEx_set_CSDVersion },
	{ discard_const_p(char, "ServicePackMajor"), py_netr_OsVersionInfoEx_get_ServicePackMajor, py_netr_OsVersionInfoEx_set_ServicePackMajor },
	{ discard_const_p(char, "ServicePackMinor"), py_netr_OsVersionInfoEx_get_ServicePackMinor, py_netr_OsVersionInfoEx_set_ServicePackMinor },
	{ discard_const_p(char, "SuiteMask"), py_netr_OsVersionInfoEx_get_SuiteMask, py_netr_OsVersionInfoEx_set_SuiteMask },
	{ discard_const_p(char, "ProductType"), py_netr_OsVersionInfoEx_get_ProductType, py_netr_OsVersionInfoEx_set_ProductType },
	{ discard_const_p(char, "Reserved"), py_netr_OsVersionInfoEx_get_Reserved, py_netr_OsVersionInfoEx_set_Reserved },
	{ NULL }
};

static PyObject *py_netr_OsVersionInfoEx_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_OsVersionInfoEx, type);
}


static PyTypeObject netr_OsVersionInfoEx_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_OsVersionInfoEx",
	.tp_getset = py_netr_OsVersionInfoEx_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_OsVersionInfoEx_new,
};


static PyObject *py_netr_OsVersion_get_length(PyObject *obj, void *closure)
{
	struct netr_OsVersion *object = (struct netr_OsVersion *)pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyInt_FromLong(object->length);
	return py_length;
}

static int py_netr_OsVersion_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OsVersion *object = (struct netr_OsVersion *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_OsVersion_get_dummy(PyObject *obj, void *closure)
{
	struct netr_OsVersion *object = (struct netr_OsVersion *)pytalloc_get_ptr(obj);
	PyObject *py_dummy;
	py_dummy = PyInt_FromLong(object->dummy);
	return py_dummy;
}

static int py_netr_OsVersion_set_dummy(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OsVersion *object = (struct netr_OsVersion *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dummy = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_OsVersion_get_size(PyObject *obj, void *closure)
{
	struct netr_OsVersion *object = (struct netr_OsVersion *)pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyInt_FromLong(object->size);
	return py_size;
}

static int py_netr_OsVersion_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OsVersion *object = (struct netr_OsVersion *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_OsVersion_get_os(PyObject *obj, void *closure)
{
	struct netr_OsVersion *object = (struct netr_OsVersion *)pytalloc_get_ptr(obj);
	PyObject *py_os;
	py_os = pytalloc_reference_ex(&netr_OsVersionInfoEx_Type, pytalloc_get_mem_ctx(obj), &object->os);
	return py_os;
}

static int py_netr_OsVersion_set_os(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OsVersion *object = (struct netr_OsVersion *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_OsVersionInfoEx_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->os = *(struct netr_OsVersionInfoEx *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_netr_OsVersion_getsetters[] = {
	{ discard_const_p(char, "length"), py_netr_OsVersion_get_length, py_netr_OsVersion_set_length },
	{ discard_const_p(char, "dummy"), py_netr_OsVersion_get_dummy, py_netr_OsVersion_set_dummy },
	{ discard_const_p(char, "size"), py_netr_OsVersion_get_size, py_netr_OsVersion_set_size },
	{ discard_const_p(char, "os"), py_netr_OsVersion_get_os, py_netr_OsVersion_set_os },
	{ NULL }
};

static PyObject *py_netr_OsVersion_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_OsVersion, type);
}


static PyTypeObject netr_OsVersion_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_OsVersion",
	.tp_getset = py_netr_OsVersion_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_OsVersion_new,
};


static PyObject *py_netr_OsVersionContainer_get_length(PyObject *obj, void *closure)
{
	struct netr_OsVersionContainer *object = (struct netr_OsVersionContainer *)pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyInt_FromLong(object->length);
	return py_length;
}

static int py_netr_OsVersionContainer_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OsVersionContainer *object = (struct netr_OsVersionContainer *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_OsVersionContainer_get_size(PyObject *obj, void *closure)
{
	struct netr_OsVersionContainer *object = (struct netr_OsVersionContainer *)pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyInt_FromLong(object->size);
	return py_size;
}

static int py_netr_OsVersionContainer_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OsVersionContainer *object = (struct netr_OsVersionContainer *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_OsVersionContainer_get_os(PyObject *obj, void *closure)
{
	struct netr_OsVersionContainer *object = (struct netr_OsVersionContainer *)pytalloc_get_ptr(obj);
	PyObject *py_os;
	if (object->os == NULL) {
		py_os = Py_None;
		Py_INCREF(py_os);
	} else {
		py_os = pytalloc_reference_ex(&netr_OsVersion_Type, object->os, object->os);
	}
	return py_os;
}

static int py_netr_OsVersionContainer_set_os(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OsVersionContainer *object = (struct netr_OsVersionContainer *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->os);
	if (value == Py_None) {
		object->os = NULL;
	} else {
		object->os = NULL;
		PY_CHECK_TYPE(&netr_OsVersion_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->os = (struct netr_OsVersion *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_netr_OsVersionContainer_getsetters[] = {
	{ discard_const_p(char, "length"), py_netr_OsVersionContainer_get_length, py_netr_OsVersionContainer_set_length },
	{ discard_const_p(char, "size"), py_netr_OsVersionContainer_get_size, py_netr_OsVersionContainer_set_size },
	{ discard_const_p(char, "os"), py_netr_OsVersionContainer_get_os, py_netr_OsVersionContainer_set_os },
	{ NULL }
};

static PyObject *py_netr_OsVersionContainer_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_OsVersionContainer, type);
}


static PyTypeObject netr_OsVersionContainer_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_OsVersionContainer",
	.tp_getset = py_netr_OsVersionContainer_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_OsVersionContainer_new,
};


static PyObject *py_netr_WorkstationInformation_get_lsa_policy(PyObject *obj, void *closure)
{
	struct netr_WorkstationInformation *object = (struct netr_WorkstationInformation *)pytalloc_get_ptr(obj);
	PyObject *py_lsa_policy;
	py_lsa_policy = pytalloc_reference_ex(&netr_LsaPolicyInformation_Type, pytalloc_get_mem_ctx(obj), &object->lsa_policy);
	return py_lsa_policy;
}

static int py_netr_WorkstationInformation_set_lsa_policy(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_WorkstationInformation *object = (struct netr_WorkstationInformation *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_LsaPolicyInformation_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->lsa_policy = *(struct netr_LsaPolicyInformation *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_WorkstationInformation_get_dns_hostname(PyObject *obj, void *closure)
{
	struct netr_WorkstationInformation *object = (struct netr_WorkstationInformation *)pytalloc_get_ptr(obj);
	PyObject *py_dns_hostname;
	if (object->dns_hostname == NULL) {
		py_dns_hostname = Py_None;
		Py_INCREF(py_dns_hostname);
	} else {
		if (object->dns_hostname == NULL) {
			py_dns_hostname = Py_None;
			Py_INCREF(py_dns_hostname);
		} else {
			py_dns_hostname = PyUnicode_Decode(object->dns_hostname, strlen(object->dns_hostname), "utf-8", "ignore");
		}
	}
	return py_dns_hostname;
}

static int py_netr_WorkstationInformation_set_dns_hostname(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_WorkstationInformation *object = (struct netr_WorkstationInformation *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->dns_hostname = NULL;
	} else {
		object->dns_hostname = NULL;
		if (PyUnicode_Check(value)) {
			object->dns_hostname = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->dns_hostname = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_WorkstationInformation_get_sitename(PyObject *obj, void *closure)
{
	struct netr_WorkstationInformation *object = (struct netr_WorkstationInformation *)pytalloc_get_ptr(obj);
	PyObject *py_sitename;
	if (object->sitename == NULL) {
		py_sitename = Py_None;
		Py_INCREF(py_sitename);
	} else {
		if (object->sitename == NULL) {
			py_sitename = Py_None;
			Py_INCREF(py_sitename);
		} else {
			py_sitename = PyUnicode_Decode(object->sitename, strlen(object->sitename), "utf-8", "ignore");
		}
	}
	return py_sitename;
}

static int py_netr_WorkstationInformation_set_sitename(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_WorkstationInformation *object = (struct netr_WorkstationInformation *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->sitename = NULL;
	} else {
		object->sitename = NULL;
		if (PyUnicode_Check(value)) {
			object->sitename = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->sitename = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_WorkstationInformation_get_dummy1(PyObject *obj, void *closure)
{
	struct netr_WorkstationInformation *object = (struct netr_WorkstationInformation *)pytalloc_get_ptr(obj);
	PyObject *py_dummy1;
	if (object->dummy1 == NULL) {
		py_dummy1 = Py_None;
		Py_INCREF(py_dummy1);
	} else {
		if (object->dummy1 == NULL) {
			py_dummy1 = Py_None;
			Py_INCREF(py_dummy1);
		} else {
			py_dummy1 = PyUnicode_Decode(object->dummy1, strlen(object->dummy1), "utf-8", "ignore");
		}
	}
	return py_dummy1;
}

static int py_netr_WorkstationInformation_set_dummy1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_WorkstationInformation *object = (struct netr_WorkstationInformation *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->dummy1 = NULL;
	} else {
		object->dummy1 = NULL;
		if (PyUnicode_Check(value)) {
			object->dummy1 = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->dummy1 = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_WorkstationInformation_get_dummy2(PyObject *obj, void *closure)
{
	struct netr_WorkstationInformation *object = (struct netr_WorkstationInformation *)pytalloc_get_ptr(obj);
	PyObject *py_dummy2;
	if (object->dummy2 == NULL) {
		py_dummy2 = Py_None;
		Py_INCREF(py_dummy2);
	} else {
		if (object->dummy2 == NULL) {
			py_dummy2 = Py_None;
			Py_INCREF(py_dummy2);
		} else {
			py_dummy2 = PyUnicode_Decode(object->dummy2, strlen(object->dummy2), "utf-8", "ignore");
		}
	}
	return py_dummy2;
}

static int py_netr_WorkstationInformation_set_dummy2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_WorkstationInformation *object = (struct netr_WorkstationInformation *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->dummy2 = NULL;
	} else {
		object->dummy2 = NULL;
		if (PyUnicode_Check(value)) {
			object->dummy2 = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->dummy2 = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_WorkstationInformation_get_dummy3(PyObject *obj, void *closure)
{
	struct netr_WorkstationInformation *object = (struct netr_WorkstationInformation *)pytalloc_get_ptr(obj);
	PyObject *py_dummy3;
	if (object->dummy3 == NULL) {
		py_dummy3 = Py_None;
		Py_INCREF(py_dummy3);
	} else {
		if (object->dummy3 == NULL) {
			py_dummy3 = Py_None;
			Py_INCREF(py_dummy3);
		} else {
			py_dummy3 = PyUnicode_Decode(object->dummy3, strlen(object->dummy3), "utf-8", "ignore");
		}
	}
	return py_dummy3;
}

static int py_netr_WorkstationInformation_set_dummy3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_WorkstationInformation *object = (struct netr_WorkstationInformation *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->dummy3 = NULL;
	} else {
		object->dummy3 = NULL;
		if (PyUnicode_Check(value)) {
			object->dummy3 = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->dummy3 = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_WorkstationInformation_get_dummy4(PyObject *obj, void *closure)
{
	struct netr_WorkstationInformation *object = (struct netr_WorkstationInformation *)pytalloc_get_ptr(obj);
	PyObject *py_dummy4;
	if (object->dummy4 == NULL) {
		py_dummy4 = Py_None;
		Py_INCREF(py_dummy4);
	} else {
		if (object->dummy4 == NULL) {
			py_dummy4 = Py_None;
			Py_INCREF(py_dummy4);
		} else {
			py_dummy4 = PyUnicode_Decode(object->dummy4, strlen(object->dummy4), "utf-8", "ignore");
		}
	}
	return py_dummy4;
}

static int py_netr_WorkstationInformation_set_dummy4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_WorkstationInformation *object = (struct netr_WorkstationInformation *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->dummy4 = NULL;
	} else {
		object->dummy4 = NULL;
		if (PyUnicode_Check(value)) {
			object->dummy4 = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->dummy4 = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_WorkstationInformation_get_os_version(PyObject *obj, void *closure)
{
	struct netr_WorkstationInformation *object = (struct netr_WorkstationInformation *)pytalloc_get_ptr(obj);
	PyObject *py_os_version;
	py_os_version = pytalloc_reference_ex(&netr_OsVersionContainer_Type, pytalloc_get_mem_ctx(obj), &object->os_version);
	return py_os_version;
}

static int py_netr_WorkstationInformation_set_os_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_WorkstationInformation *object = (struct netr_WorkstationInformation *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_OsVersionContainer_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->os_version = *(struct netr_OsVersionContainer *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_WorkstationInformation_get_os_name(PyObject *obj, void *closure)
{
	struct netr_WorkstationInformation *object = (struct netr_WorkstationInformation *)pytalloc_get_ptr(obj);
	PyObject *py_os_name;
	py_os_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->os_name);
	return py_os_name;
}

static int py_netr_WorkstationInformation_set_os_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_WorkstationInformation *object = (struct netr_WorkstationInformation *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->os_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_WorkstationInformation_get_dummy_string3(PyObject *obj, void *closure)
{
	struct netr_WorkstationInformation *object = (struct netr_WorkstationInformation *)pytalloc_get_ptr(obj);
	PyObject *py_dummy_string3;
	py_dummy_string3 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->dummy_string3);
	return py_dummy_string3;
}

static int py_netr_WorkstationInformation_set_dummy_string3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_WorkstationInformation *object = (struct netr_WorkstationInformation *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->dummy_string3 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_WorkstationInformation_get_dummy_string4(PyObject *obj, void *closure)
{
	struct netr_WorkstationInformation *object = (struct netr_WorkstationInformation *)pytalloc_get_ptr(obj);
	PyObject *py_dummy_string4;
	py_dummy_string4 = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->dummy_string4);
	return py_dummy_string4;
}

static int py_netr_WorkstationInformation_set_dummy_string4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_WorkstationInformation *object = (struct netr_WorkstationInformation *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->dummy_string4 = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_WorkstationInformation_get_workstation_flags(PyObject *obj, void *closure)
{
	struct netr_WorkstationInformation *object = (struct netr_WorkstationInformation *)pytalloc_get_ptr(obj);
	PyObject *py_workstation_flags;
	py_workstation_flags = PyInt_FromLong(object->workstation_flags);
	return py_workstation_flags;
}

static int py_netr_WorkstationInformation_set_workstation_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_WorkstationInformation *object = (struct netr_WorkstationInformation *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->workstation_flags = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->workstation_flags = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netr_WorkstationInformation_get_dummy_long2(PyObject *obj, void *closure)
{
	struct netr_WorkstationInformation *object = (struct netr_WorkstationInformation *)pytalloc_get_ptr(obj);
	PyObject *py_dummy_long2;
	py_dummy_long2 = PyInt_FromLong(object->dummy_long2);
	return py_dummy_long2;
}

static int py_netr_WorkstationInformation_set_dummy_long2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_WorkstationInformation *object = (struct netr_WorkstationInformation *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dummy_long2 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_WorkstationInformation_get_dummy_long3(PyObject *obj, void *closure)
{
	struct netr_WorkstationInformation *object = (struct netr_WorkstationInformation *)pytalloc_get_ptr(obj);
	PyObject *py_dummy_long3;
	py_dummy_long3 = PyInt_FromLong(object->dummy_long3);
	return py_dummy_long3;
}

static int py_netr_WorkstationInformation_set_dummy_long3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_WorkstationInformation *object = (struct netr_WorkstationInformation *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dummy_long3 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_WorkstationInformation_get_dummy_long4(PyObject *obj, void *closure)
{
	struct netr_WorkstationInformation *object = (struct netr_WorkstationInformation *)pytalloc_get_ptr(obj);
	PyObject *py_dummy_long4;
	py_dummy_long4 = PyInt_FromLong(object->dummy_long4);
	return py_dummy_long4;
}

static int py_netr_WorkstationInformation_set_dummy_long4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_WorkstationInformation *object = (struct netr_WorkstationInformation *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dummy_long4 = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_WorkstationInformation_getsetters[] = {
	{ discard_const_p(char, "lsa_policy"), py_netr_WorkstationInformation_get_lsa_policy, py_netr_WorkstationInformation_set_lsa_policy },
	{ discard_const_p(char, "dns_hostname"), py_netr_WorkstationInformation_get_dns_hostname, py_netr_WorkstationInformation_set_dns_hostname },
	{ discard_const_p(char, "sitename"), py_netr_WorkstationInformation_get_sitename, py_netr_WorkstationInformation_set_sitename },
	{ discard_const_p(char, "dummy1"), py_netr_WorkstationInformation_get_dummy1, py_netr_WorkstationInformation_set_dummy1 },
	{ discard_const_p(char, "dummy2"), py_netr_WorkstationInformation_get_dummy2, py_netr_WorkstationInformation_set_dummy2 },
	{ discard_const_p(char, "dummy3"), py_netr_WorkstationInformation_get_dummy3, py_netr_WorkstationInformation_set_dummy3 },
	{ discard_const_p(char, "dummy4"), py_netr_WorkstationInformation_get_dummy4, py_netr_WorkstationInformation_set_dummy4 },
	{ discard_const_p(char, "os_version"), py_netr_WorkstationInformation_get_os_version, py_netr_WorkstationInformation_set_os_version },
	{ discard_const_p(char, "os_name"), py_netr_WorkstationInformation_get_os_name, py_netr_WorkstationInformation_set_os_name },
	{ discard_const_p(char, "dummy_string3"), py_netr_WorkstationInformation_get_dummy_string3, py_netr_WorkstationInformation_set_dummy_string3 },
	{ discard_const_p(char, "dummy_string4"), py_netr_WorkstationInformation_get_dummy_string4, py_netr_WorkstationInformation_set_dummy_string4 },
	{ discard_const_p(char, "workstation_flags"), py_netr_WorkstationInformation_get_workstation_flags, py_netr_WorkstationInformation_set_workstation_flags },
	{ discard_const_p(char, "dummy_long2"), py_netr_WorkstationInformation_get_dummy_long2, py_netr_WorkstationInformation_set_dummy_long2 },
	{ discard_const_p(char, "dummy_long3"), py_netr_WorkstationInformation_get_dummy_long3, py_netr_WorkstationInformation_set_dummy_long3 },
	{ discard_const_p(char, "dummy_long4"), py_netr_WorkstationInformation_get_dummy_long4, py_netr_WorkstationInformation_set_dummy_long4 },
	{ NULL }
};

static PyObject *py_netr_WorkstationInformation_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_WorkstationInformation, type);
}


static PyTypeObject netr_WorkstationInformation_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_WorkstationInformation",
	.tp_getset = py_netr_WorkstationInformation_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_WorkstationInformation_new,
};

PyObject *py_import_netr_WorkstationInfo(TALLOC_CTX *mem_ctx, int level, union netr_WorkstationInfo *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			if (in->workstation_info == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_WorkstationInformation_Type, in->workstation_info, in->workstation_info);
			}
			return ret;

		case 2:
			if (in->lsa_policy_info == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_WorkstationInformation_Type, in->lsa_policy_info, in->lsa_policy_info);
			}
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union netr_WorkstationInfo *py_export_netr_WorkstationInfo(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union netr_WorkstationInfo *ret = talloc_zero(mem_ctx, union netr_WorkstationInfo);
	switch (level) {
		case 1:
			if (in == Py_None) {
				ret->workstation_info = NULL;
			} else {
				ret->workstation_info = NULL;
				PY_CHECK_TYPE(&netr_WorkstationInformation_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->workstation_info = (struct netr_WorkstationInformation *)pytalloc_get_ptr(in);
			}
			break;

		case 2:
			if (in == Py_None) {
				ret->lsa_policy_info = NULL;
			} else {
				ret->lsa_policy_info = NULL;
				PY_CHECK_TYPE(&netr_WorkstationInformation_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->lsa_policy_info = (struct netr_WorkstationInformation *)pytalloc_get_ptr(in);
			}
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}


static PyObject *py_netr_trust_extension_get_length(PyObject *obj, void *closure)
{
	struct netr_trust_extension *object = (struct netr_trust_extension *)pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyInt_FromLong(object->length);
	return py_length;
}

static int py_netr_trust_extension_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_trust_extension *object = (struct netr_trust_extension *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_trust_extension_get_dummy(PyObject *obj, void *closure)
{
	struct netr_trust_extension *object = (struct netr_trust_extension *)pytalloc_get_ptr(obj);
	PyObject *py_dummy;
	py_dummy = PyInt_FromLong(object->dummy);
	return py_dummy;
}

static int py_netr_trust_extension_set_dummy(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_trust_extension *object = (struct netr_trust_extension *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dummy = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_trust_extension_get_size(PyObject *obj, void *closure)
{
	struct netr_trust_extension *object = (struct netr_trust_extension *)pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyInt_FromLong(object->size);
	return py_size;
}

static int py_netr_trust_extension_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_trust_extension *object = (struct netr_trust_extension *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_trust_extension_get_flags(PyObject *obj, void *closure)
{
	struct netr_trust_extension *object = (struct netr_trust_extension *)pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyInt_FromLong(object->flags);
	return py_flags;
}

static int py_netr_trust_extension_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_trust_extension *object = (struct netr_trust_extension *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->flags = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->flags = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netr_trust_extension_get_parent_index(PyObject *obj, void *closure)
{
	struct netr_trust_extension *object = (struct netr_trust_extension *)pytalloc_get_ptr(obj);
	PyObject *py_parent_index;
	py_parent_index = PyInt_FromLong(object->parent_index);
	return py_parent_index;
}

static int py_netr_trust_extension_set_parent_index(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_trust_extension *object = (struct netr_trust_extension *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->parent_index = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_trust_extension_get_trust_type(PyObject *obj, void *closure)
{
	struct netr_trust_extension *object = (struct netr_trust_extension *)pytalloc_get_ptr(obj);
	PyObject *py_trust_type;
	py_trust_type = PyInt_FromLong(object->trust_type);
	return py_trust_type;
}

static int py_netr_trust_extension_set_trust_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_trust_extension *object = (struct netr_trust_extension *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->trust_type = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_trust_extension_get_trust_attributes(PyObject *obj, void *closure)
{
	struct netr_trust_extension *object = (struct netr_trust_extension *)pytalloc_get_ptr(obj);
	PyObject *py_trust_attributes;
	py_trust_attributes = PyInt_FromLong(object->trust_attributes);
	return py_trust_attributes;
}

static int py_netr_trust_extension_set_trust_attributes(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_trust_extension *object = (struct netr_trust_extension *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->trust_attributes = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_trust_extension_getsetters[] = {
	{ discard_const_p(char, "length"), py_netr_trust_extension_get_length, py_netr_trust_extension_set_length },
	{ discard_const_p(char, "dummy"), py_netr_trust_extension_get_dummy, py_netr_trust_extension_set_dummy },
	{ discard_const_p(char, "size"), py_netr_trust_extension_get_size, py_netr_trust_extension_set_size },
	{ discard_const_p(char, "flags"), py_netr_trust_extension_get_flags, py_netr_trust_extension_set_flags },
	{ discard_const_p(char, "parent_index"), py_netr_trust_extension_get_parent_index, py_netr_trust_extension_set_parent_index },
	{ discard_const_p(char, "trust_type"), py_netr_trust_extension_get_trust_type, py_netr_trust_extension_set_trust_type },
	{ discard_const_p(char, "trust_attributes"), py_netr_trust_extension_get_trust_attributes, py_netr_trust_extension_set_trust_attributes },
	{ NULL }
};

static PyObject *py_netr_trust_extension_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_trust_extension, type);
}


static PyTypeObject netr_trust_extension_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_trust_extension",
	.tp_getset = py_netr_trust_extension_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_trust_extension_new,
};


static PyObject *py_netr_trust_extension_container_get_length(PyObject *obj, void *closure)
{
	struct netr_trust_extension_container *object = (struct netr_trust_extension_container *)pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyInt_FromLong(object->length);
	return py_length;
}

static int py_netr_trust_extension_container_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_trust_extension_container *object = (struct netr_trust_extension_container *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_trust_extension_container_get_size(PyObject *obj, void *closure)
{
	struct netr_trust_extension_container *object = (struct netr_trust_extension_container *)pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyInt_FromLong(object->size);
	return py_size;
}

static int py_netr_trust_extension_container_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_trust_extension_container *object = (struct netr_trust_extension_container *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_trust_extension_container_get_info(PyObject *obj, void *closure)
{
	struct netr_trust_extension_container *object = (struct netr_trust_extension_container *)pytalloc_get_ptr(obj);
	PyObject *py_info;
	if (object->info == NULL) {
		py_info = Py_None;
		Py_INCREF(py_info);
	} else {
		py_info = pytalloc_reference_ex(&netr_trust_extension_Type, object->info, object->info);
	}
	return py_info;
}

static int py_netr_trust_extension_container_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_trust_extension_container *object = (struct netr_trust_extension_container *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->info);
	if (value == Py_None) {
		object->info = NULL;
	} else {
		object->info = NULL;
		PY_CHECK_TYPE(&netr_trust_extension_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->info = (struct netr_trust_extension *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_netr_trust_extension_container_getsetters[] = {
	{ discard_const_p(char, "length"), py_netr_trust_extension_container_get_length, py_netr_trust_extension_container_set_length },
	{ discard_const_p(char, "size"), py_netr_trust_extension_container_get_size, py_netr_trust_extension_container_set_size },
	{ discard_const_p(char, "info"), py_netr_trust_extension_container_get_info, py_netr_trust_extension_container_set_info },
	{ NULL }
};

static PyObject *py_netr_trust_extension_container_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_trust_extension_container, type);
}


static PyTypeObject netr_trust_extension_container_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_trust_extension_container",
	.tp_getset = py_netr_trust_extension_container_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_trust_extension_container_new,
};


static PyObject *py_netr_OneDomainInfo_get_domainname(PyObject *obj, void *closure)
{
	struct netr_OneDomainInfo *object = (struct netr_OneDomainInfo *)pytalloc_get_ptr(obj);
	PyObject *py_domainname;
	py_domainname = pytalloc_reference_ex(lsa_StringLarge_Type, pytalloc_get_mem_ctx(obj), &object->domainname);
	return py_domainname;
}

static int py_netr_OneDomainInfo_set_domainname(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OneDomainInfo *object = (struct netr_OneDomainInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_StringLarge_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->domainname = *(struct lsa_StringLarge *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_OneDomainInfo_get_dns_domainname(PyObject *obj, void *closure)
{
	struct netr_OneDomainInfo *object = (struct netr_OneDomainInfo *)pytalloc_get_ptr(obj);
	PyObject *py_dns_domainname;
	py_dns_domainname = pytalloc_reference_ex(lsa_StringLarge_Type, pytalloc_get_mem_ctx(obj), &object->dns_domainname);
	return py_dns_domainname;
}

static int py_netr_OneDomainInfo_set_dns_domainname(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OneDomainInfo *object = (struct netr_OneDomainInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_StringLarge_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->dns_domainname = *(struct lsa_StringLarge *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_OneDomainInfo_get_dns_forestname(PyObject *obj, void *closure)
{
	struct netr_OneDomainInfo *object = (struct netr_OneDomainInfo *)pytalloc_get_ptr(obj);
	PyObject *py_dns_forestname;
	py_dns_forestname = pytalloc_reference_ex(lsa_StringLarge_Type, pytalloc_get_mem_ctx(obj), &object->dns_forestname);
	return py_dns_forestname;
}

static int py_netr_OneDomainInfo_set_dns_forestname(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OneDomainInfo *object = (struct netr_OneDomainInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_StringLarge_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->dns_forestname = *(struct lsa_StringLarge *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_OneDomainInfo_get_domain_guid(PyObject *obj, void *closure)
{
	struct netr_OneDomainInfo *object = (struct netr_OneDomainInfo *)pytalloc_get_ptr(obj);
	PyObject *py_domain_guid;
	py_domain_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->domain_guid);
	return py_domain_guid;
}

static int py_netr_OneDomainInfo_set_domain_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OneDomainInfo *object = (struct netr_OneDomainInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->domain_guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_OneDomainInfo_get_domain_sid(PyObject *obj, void *closure)
{
	struct netr_OneDomainInfo *object = (struct netr_OneDomainInfo *)pytalloc_get_ptr(obj);
	PyObject *py_domain_sid;
	if (object->domain_sid == NULL) {
		py_domain_sid = Py_None;
		Py_INCREF(py_domain_sid);
	} else {
		py_domain_sid = pytalloc_reference_ex(dom_sid_Type, object->domain_sid, object->domain_sid);
	}
	return py_domain_sid;
}

static int py_netr_OneDomainInfo_set_domain_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OneDomainInfo *object = (struct netr_OneDomainInfo *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->domain_sid);
	if (value == Py_None) {
		object->domain_sid = NULL;
	} else {
		object->domain_sid = NULL;
		PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->domain_sid = (struct dom_sid *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_netr_OneDomainInfo_get_trust_extension(PyObject *obj, void *closure)
{
	struct netr_OneDomainInfo *object = (struct netr_OneDomainInfo *)pytalloc_get_ptr(obj);
	PyObject *py_trust_extension;
	py_trust_extension = pytalloc_reference_ex(&netr_trust_extension_container_Type, pytalloc_get_mem_ctx(obj), &object->trust_extension);
	return py_trust_extension;
}

static int py_netr_OneDomainInfo_set_trust_extension(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OneDomainInfo *object = (struct netr_OneDomainInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_trust_extension_container_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->trust_extension = *(struct netr_trust_extension_container *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_OneDomainInfo_get_dummy_string2(PyObject *obj, void *closure)
{
	struct netr_OneDomainInfo *object = (struct netr_OneDomainInfo *)pytalloc_get_ptr(obj);
	PyObject *py_dummy_string2;
	py_dummy_string2 = pytalloc_reference_ex(lsa_StringLarge_Type, pytalloc_get_mem_ctx(obj), &object->dummy_string2);
	return py_dummy_string2;
}

static int py_netr_OneDomainInfo_set_dummy_string2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OneDomainInfo *object = (struct netr_OneDomainInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_StringLarge_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->dummy_string2 = *(struct lsa_StringLarge *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_OneDomainInfo_get_dummy_string3(PyObject *obj, void *closure)
{
	struct netr_OneDomainInfo *object = (struct netr_OneDomainInfo *)pytalloc_get_ptr(obj);
	PyObject *py_dummy_string3;
	py_dummy_string3 = pytalloc_reference_ex(lsa_StringLarge_Type, pytalloc_get_mem_ctx(obj), &object->dummy_string3);
	return py_dummy_string3;
}

static int py_netr_OneDomainInfo_set_dummy_string3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OneDomainInfo *object = (struct netr_OneDomainInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_StringLarge_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->dummy_string3 = *(struct lsa_StringLarge *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_OneDomainInfo_get_dummy_string4(PyObject *obj, void *closure)
{
	struct netr_OneDomainInfo *object = (struct netr_OneDomainInfo *)pytalloc_get_ptr(obj);
	PyObject *py_dummy_string4;
	py_dummy_string4 = pytalloc_reference_ex(lsa_StringLarge_Type, pytalloc_get_mem_ctx(obj), &object->dummy_string4);
	return py_dummy_string4;
}

static int py_netr_OneDomainInfo_set_dummy_string4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OneDomainInfo *object = (struct netr_OneDomainInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_StringLarge_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->dummy_string4 = *(struct lsa_StringLarge *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_OneDomainInfo_get_dummy_long1(PyObject *obj, void *closure)
{
	struct netr_OneDomainInfo *object = (struct netr_OneDomainInfo *)pytalloc_get_ptr(obj);
	PyObject *py_dummy_long1;
	py_dummy_long1 = PyInt_FromLong(object->dummy_long1);
	return py_dummy_long1;
}

static int py_netr_OneDomainInfo_set_dummy_long1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OneDomainInfo *object = (struct netr_OneDomainInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dummy_long1 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_OneDomainInfo_get_dummy_long2(PyObject *obj, void *closure)
{
	struct netr_OneDomainInfo *object = (struct netr_OneDomainInfo *)pytalloc_get_ptr(obj);
	PyObject *py_dummy_long2;
	py_dummy_long2 = PyInt_FromLong(object->dummy_long2);
	return py_dummy_long2;
}

static int py_netr_OneDomainInfo_set_dummy_long2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OneDomainInfo *object = (struct netr_OneDomainInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dummy_long2 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_OneDomainInfo_get_dummy_long3(PyObject *obj, void *closure)
{
	struct netr_OneDomainInfo *object = (struct netr_OneDomainInfo *)pytalloc_get_ptr(obj);
	PyObject *py_dummy_long3;
	py_dummy_long3 = PyInt_FromLong(object->dummy_long3);
	return py_dummy_long3;
}

static int py_netr_OneDomainInfo_set_dummy_long3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OneDomainInfo *object = (struct netr_OneDomainInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dummy_long3 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_OneDomainInfo_get_dummy_long4(PyObject *obj, void *closure)
{
	struct netr_OneDomainInfo *object = (struct netr_OneDomainInfo *)pytalloc_get_ptr(obj);
	PyObject *py_dummy_long4;
	py_dummy_long4 = PyInt_FromLong(object->dummy_long4);
	return py_dummy_long4;
}

static int py_netr_OneDomainInfo_set_dummy_long4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_OneDomainInfo *object = (struct netr_OneDomainInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dummy_long4 = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_OneDomainInfo_getsetters[] = {
	{ discard_const_p(char, "domainname"), py_netr_OneDomainInfo_get_domainname, py_netr_OneDomainInfo_set_domainname },
	{ discard_const_p(char, "dns_domainname"), py_netr_OneDomainInfo_get_dns_domainname, py_netr_OneDomainInfo_set_dns_domainname },
	{ discard_const_p(char, "dns_forestname"), py_netr_OneDomainInfo_get_dns_forestname, py_netr_OneDomainInfo_set_dns_forestname },
	{ discard_const_p(char, "domain_guid"), py_netr_OneDomainInfo_get_domain_guid, py_netr_OneDomainInfo_set_domain_guid },
	{ discard_const_p(char, "domain_sid"), py_netr_OneDomainInfo_get_domain_sid, py_netr_OneDomainInfo_set_domain_sid },
	{ discard_const_p(char, "trust_extension"), py_netr_OneDomainInfo_get_trust_extension, py_netr_OneDomainInfo_set_trust_extension },
	{ discard_const_p(char, "dummy_string2"), py_netr_OneDomainInfo_get_dummy_string2, py_netr_OneDomainInfo_set_dummy_string2 },
	{ discard_const_p(char, "dummy_string3"), py_netr_OneDomainInfo_get_dummy_string3, py_netr_OneDomainInfo_set_dummy_string3 },
	{ discard_const_p(char, "dummy_string4"), py_netr_OneDomainInfo_get_dummy_string4, py_netr_OneDomainInfo_set_dummy_string4 },
	{ discard_const_p(char, "dummy_long1"), py_netr_OneDomainInfo_get_dummy_long1, py_netr_OneDomainInfo_set_dummy_long1 },
	{ discard_const_p(char, "dummy_long2"), py_netr_OneDomainInfo_get_dummy_long2, py_netr_OneDomainInfo_set_dummy_long2 },
	{ discard_const_p(char, "dummy_long3"), py_netr_OneDomainInfo_get_dummy_long3, py_netr_OneDomainInfo_set_dummy_long3 },
	{ discard_const_p(char, "dummy_long4"), py_netr_OneDomainInfo_get_dummy_long4, py_netr_OneDomainInfo_set_dummy_long4 },
	{ NULL }
};

static PyObject *py_netr_OneDomainInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_OneDomainInfo, type);
}


static PyTypeObject netr_OneDomainInfo_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_OneDomainInfo",
	.tp_getset = py_netr_OneDomainInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_OneDomainInfo_new,
};


static PyObject *py_netr_DomainInformation_get_primary_domain(PyObject *obj, void *closure)
{
	struct netr_DomainInformation *object = (struct netr_DomainInformation *)pytalloc_get_ptr(obj);
	PyObject *py_primary_domain;
	py_primary_domain = pytalloc_reference_ex(&netr_OneDomainInfo_Type, pytalloc_get_mem_ctx(obj), &object->primary_domain);
	return py_primary_domain;
}

static int py_netr_DomainInformation_set_primary_domain(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainInformation *object = (struct netr_DomainInformation *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_OneDomainInfo_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->primary_domain = *(struct netr_OneDomainInfo *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DomainInformation_get_trusted_domain_count(PyObject *obj, void *closure)
{
	struct netr_DomainInformation *object = (struct netr_DomainInformation *)pytalloc_get_ptr(obj);
	PyObject *py_trusted_domain_count;
	py_trusted_domain_count = PyInt_FromLong(object->trusted_domain_count);
	return py_trusted_domain_count;
}

static int py_netr_DomainInformation_set_trusted_domain_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainInformation *object = (struct netr_DomainInformation *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->trusted_domain_count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DomainInformation_get_trusted_domains(PyObject *obj, void *closure)
{
	struct netr_DomainInformation *object = (struct netr_DomainInformation *)pytalloc_get_ptr(obj);
	PyObject *py_trusted_domains;
	if (object->trusted_domains == NULL) {
		py_trusted_domains = Py_None;
		Py_INCREF(py_trusted_domains);
	} else {
		py_trusted_domains = PyList_New(object->trusted_domain_count);
		if (py_trusted_domains == NULL) {
			return NULL;
		}
		{
			int trusted_domains_cntr_1;
			for (trusted_domains_cntr_1 = 0; trusted_domains_cntr_1 < object->trusted_domain_count; trusted_domains_cntr_1++) {
				PyObject *py_trusted_domains_1;
				py_trusted_domains_1 = pytalloc_reference_ex(&netr_OneDomainInfo_Type, object->trusted_domains, &object->trusted_domains[trusted_domains_cntr_1]);
				PyList_SetItem(py_trusted_domains, trusted_domains_cntr_1, py_trusted_domains_1);
			}
		}
	}
	return py_trusted_domains;
}

static int py_netr_DomainInformation_set_trusted_domains(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainInformation *object = (struct netr_DomainInformation *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->trusted_domains);
	if (value == Py_None) {
		object->trusted_domains = NULL;
	} else {
		object->trusted_domains = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int trusted_domains_cntr_1;
			object->trusted_domains = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->trusted_domains, PyList_GET_SIZE(value));
			if (!object->trusted_domains) { return -1;; }
			talloc_set_name_const(object->trusted_domains, "ARRAY: object->trusted_domains");
			for (trusted_domains_cntr_1 = 0; trusted_domains_cntr_1 < PyList_GET_SIZE(value); trusted_domains_cntr_1++) {
				PY_CHECK_TYPE(&netr_OneDomainInfo_Type, PyList_GET_ITEM(value, trusted_domains_cntr_1), return -1;);
				if (talloc_reference(object->trusted_domains, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, trusted_domains_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				object->trusted_domains[trusted_domains_cntr_1] = *(struct netr_OneDomainInfo *)pytalloc_get_ptr(PyList_GET_ITEM(value, trusted_domains_cntr_1));
			}
		}
	}
	return 0;
}

static PyObject *py_netr_DomainInformation_get_lsa_policy(PyObject *obj, void *closure)
{
	struct netr_DomainInformation *object = (struct netr_DomainInformation *)pytalloc_get_ptr(obj);
	PyObject *py_lsa_policy;
	py_lsa_policy = pytalloc_reference_ex(&netr_LsaPolicyInformation_Type, pytalloc_get_mem_ctx(obj), &object->lsa_policy);
	return py_lsa_policy;
}

static int py_netr_DomainInformation_set_lsa_policy(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainInformation *object = (struct netr_DomainInformation *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&netr_LsaPolicyInformation_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->lsa_policy = *(struct netr_LsaPolicyInformation *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DomainInformation_get_dns_hostname(PyObject *obj, void *closure)
{
	struct netr_DomainInformation *object = (struct netr_DomainInformation *)pytalloc_get_ptr(obj);
	PyObject *py_dns_hostname;
	py_dns_hostname = pytalloc_reference_ex(lsa_StringLarge_Type, pytalloc_get_mem_ctx(obj), &object->dns_hostname);
	return py_dns_hostname;
}

static int py_netr_DomainInformation_set_dns_hostname(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainInformation *object = (struct netr_DomainInformation *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_StringLarge_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->dns_hostname = *(struct lsa_StringLarge *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DomainInformation_get_dummy_string2(PyObject *obj, void *closure)
{
	struct netr_DomainInformation *object = (struct netr_DomainInformation *)pytalloc_get_ptr(obj);
	PyObject *py_dummy_string2;
	py_dummy_string2 = pytalloc_reference_ex(lsa_StringLarge_Type, pytalloc_get_mem_ctx(obj), &object->dummy_string2);
	return py_dummy_string2;
}

static int py_netr_DomainInformation_set_dummy_string2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainInformation *object = (struct netr_DomainInformation *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_StringLarge_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->dummy_string2 = *(struct lsa_StringLarge *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DomainInformation_get_dummy_string3(PyObject *obj, void *closure)
{
	struct netr_DomainInformation *object = (struct netr_DomainInformation *)pytalloc_get_ptr(obj);
	PyObject *py_dummy_string3;
	py_dummy_string3 = pytalloc_reference_ex(lsa_StringLarge_Type, pytalloc_get_mem_ctx(obj), &object->dummy_string3);
	return py_dummy_string3;
}

static int py_netr_DomainInformation_set_dummy_string3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainInformation *object = (struct netr_DomainInformation *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_StringLarge_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->dummy_string3 = *(struct lsa_StringLarge *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DomainInformation_get_dummy_string4(PyObject *obj, void *closure)
{
	struct netr_DomainInformation *object = (struct netr_DomainInformation *)pytalloc_get_ptr(obj);
	PyObject *py_dummy_string4;
	py_dummy_string4 = pytalloc_reference_ex(lsa_StringLarge_Type, pytalloc_get_mem_ctx(obj), &object->dummy_string4);
	return py_dummy_string4;
}

static int py_netr_DomainInformation_set_dummy_string4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainInformation *object = (struct netr_DomainInformation *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(lsa_StringLarge_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->dummy_string4 = *(struct lsa_StringLarge *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_netr_DomainInformation_get_workstation_flags(PyObject *obj, void *closure)
{
	struct netr_DomainInformation *object = (struct netr_DomainInformation *)pytalloc_get_ptr(obj);
	PyObject *py_workstation_flags;
	py_workstation_flags = PyInt_FromLong(object->workstation_flags);
	return py_workstation_flags;
}

static int py_netr_DomainInformation_set_workstation_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainInformation *object = (struct netr_DomainInformation *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->workstation_flags = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->workstation_flags = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netr_DomainInformation_get_supported_enc_types(PyObject *obj, void *closure)
{
	struct netr_DomainInformation *object = (struct netr_DomainInformation *)pytalloc_get_ptr(obj);
	PyObject *py_supported_enc_types;
	py_supported_enc_types = PyInt_FromLong(object->supported_enc_types);
	return py_supported_enc_types;
}

static int py_netr_DomainInformation_set_supported_enc_types(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainInformation *object = (struct netr_DomainInformation *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->supported_enc_types = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->supported_enc_types = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netr_DomainInformation_get_dummy_long3(PyObject *obj, void *closure)
{
	struct netr_DomainInformation *object = (struct netr_DomainInformation *)pytalloc_get_ptr(obj);
	PyObject *py_dummy_long3;
	py_dummy_long3 = PyInt_FromLong(object->dummy_long3);
	return py_dummy_long3;
}

static int py_netr_DomainInformation_set_dummy_long3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainInformation *object = (struct netr_DomainInformation *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dummy_long3 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DomainInformation_get_dummy_long4(PyObject *obj, void *closure)
{
	struct netr_DomainInformation *object = (struct netr_DomainInformation *)pytalloc_get_ptr(obj);
	PyObject *py_dummy_long4;
	py_dummy_long4 = PyInt_FromLong(object->dummy_long4);
	return py_dummy_long4;
}

static int py_netr_DomainInformation_set_dummy_long4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainInformation *object = (struct netr_DomainInformation *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dummy_long4 = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_DomainInformation_getsetters[] = {
	{ discard_const_p(char, "primary_domain"), py_netr_DomainInformation_get_primary_domain, py_netr_DomainInformation_set_primary_domain },
	{ discard_const_p(char, "trusted_domain_count"), py_netr_DomainInformation_get_trusted_domain_count, py_netr_DomainInformation_set_trusted_domain_count },
	{ discard_const_p(char, "trusted_domains"), py_netr_DomainInformation_get_trusted_domains, py_netr_DomainInformation_set_trusted_domains },
	{ discard_const_p(char, "lsa_policy"), py_netr_DomainInformation_get_lsa_policy, py_netr_DomainInformation_set_lsa_policy },
	{ discard_const_p(char, "dns_hostname"), py_netr_DomainInformation_get_dns_hostname, py_netr_DomainInformation_set_dns_hostname },
	{ discard_const_p(char, "dummy_string2"), py_netr_DomainInformation_get_dummy_string2, py_netr_DomainInformation_set_dummy_string2 },
	{ discard_const_p(char, "dummy_string3"), py_netr_DomainInformation_get_dummy_string3, py_netr_DomainInformation_set_dummy_string3 },
	{ discard_const_p(char, "dummy_string4"), py_netr_DomainInformation_get_dummy_string4, py_netr_DomainInformation_set_dummy_string4 },
	{ discard_const_p(char, "workstation_flags"), py_netr_DomainInformation_get_workstation_flags, py_netr_DomainInformation_set_workstation_flags },
	{ discard_const_p(char, "supported_enc_types"), py_netr_DomainInformation_get_supported_enc_types, py_netr_DomainInformation_set_supported_enc_types },
	{ discard_const_p(char, "dummy_long3"), py_netr_DomainInformation_get_dummy_long3, py_netr_DomainInformation_set_dummy_long3 },
	{ discard_const_p(char, "dummy_long4"), py_netr_DomainInformation_get_dummy_long4, py_netr_DomainInformation_set_dummy_long4 },
	{ NULL }
};

static PyObject *py_netr_DomainInformation_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_DomainInformation, type);
}


static PyTypeObject netr_DomainInformation_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_DomainInformation",
	.tp_getset = py_netr_DomainInformation_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_DomainInformation_new,
};

PyObject *py_import_netr_DomainInfo(TALLOC_CTX *mem_ctx, int level, union netr_DomainInfo *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			if (in->domain_info == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_DomainInformation_Type, in->domain_info, in->domain_info);
			}
			return ret;

		case 2:
			if (in->lsa_policy_info == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&netr_LsaPolicyInformation_Type, in->lsa_policy_info, in->lsa_policy_info);
			}
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union netr_DomainInfo *py_export_netr_DomainInfo(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union netr_DomainInfo *ret = talloc_zero(mem_ctx, union netr_DomainInfo);
	switch (level) {
		case 1:
			if (in == Py_None) {
				ret->domain_info = NULL;
			} else {
				ret->domain_info = NULL;
				PY_CHECK_TYPE(&netr_DomainInformation_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->domain_info = (struct netr_DomainInformation *)pytalloc_get_ptr(in);
			}
			break;

		case 2:
			if (in == Py_None) {
				ret->lsa_policy_info = NULL;
			} else {
				ret->lsa_policy_info = NULL;
				PY_CHECK_TYPE(&netr_LsaPolicyInformation_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->lsa_policy_info = (struct netr_LsaPolicyInformation *)pytalloc_get_ptr(in);
			}
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}


static PyObject *py_NL_PASSWORD_VERSION_get_ReservedField(PyObject *obj, void *closure)
{
	struct NL_PASSWORD_VERSION *object = (struct NL_PASSWORD_VERSION *)pytalloc_get_ptr(obj);
	PyObject *py_ReservedField;
	py_ReservedField = PyInt_FromLong(object->ReservedField);
	return py_ReservedField;
}

static int py_NL_PASSWORD_VERSION_set_ReservedField(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_PASSWORD_VERSION *object = (struct NL_PASSWORD_VERSION *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->ReservedField = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_NL_PASSWORD_VERSION_get_PasswordVersionNumber(PyObject *obj, void *closure)
{
	struct NL_PASSWORD_VERSION *object = (struct NL_PASSWORD_VERSION *)pytalloc_get_ptr(obj);
	PyObject *py_PasswordVersionNumber;
	py_PasswordVersionNumber = PyInt_FromLong(object->PasswordVersionNumber);
	return py_PasswordVersionNumber;
}

static int py_NL_PASSWORD_VERSION_set_PasswordVersionNumber(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_PASSWORD_VERSION *object = (struct NL_PASSWORD_VERSION *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->PasswordVersionNumber = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_NL_PASSWORD_VERSION_get_PasswordVersionPresent(PyObject *obj, void *closure)
{
	struct NL_PASSWORD_VERSION *object = (struct NL_PASSWORD_VERSION *)pytalloc_get_ptr(obj);
	PyObject *py_PasswordVersionPresent;
	py_PasswordVersionPresent = PyInt_FromLong(object->PasswordVersionPresent);
	return py_PasswordVersionPresent;
}

static int py_NL_PASSWORD_VERSION_set_PasswordVersionPresent(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_PASSWORD_VERSION *object = (struct NL_PASSWORD_VERSION *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->PasswordVersionPresent = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_NL_PASSWORD_VERSION_getsetters[] = {
	{ discard_const_p(char, "ReservedField"), py_NL_PASSWORD_VERSION_get_ReservedField, py_NL_PASSWORD_VERSION_set_ReservedField },
	{ discard_const_p(char, "PasswordVersionNumber"), py_NL_PASSWORD_VERSION_get_PasswordVersionNumber, py_NL_PASSWORD_VERSION_set_PasswordVersionNumber },
	{ discard_const_p(char, "PasswordVersionPresent"), py_NL_PASSWORD_VERSION_get_PasswordVersionPresent, py_NL_PASSWORD_VERSION_set_PasswordVersionPresent },
	{ NULL }
};

static PyObject *py_NL_PASSWORD_VERSION_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct NL_PASSWORD_VERSION, type);
}


static PyTypeObject NL_PASSWORD_VERSION_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.NL_PASSWORD_VERSION",
	.tp_getset = py_NL_PASSWORD_VERSION_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_NL_PASSWORD_VERSION_new,
};


static PyObject *py_netr_CryptPassword_get_data(PyObject *obj, void *closure)
{
	struct netr_CryptPassword *object = (struct netr_CryptPassword *)pytalloc_get_ptr(obj);
	PyObject *py_data;
	py_data = PyList_New(512);
	if (py_data == NULL) {
		return NULL;
	}
	{
		int data_cntr_0;
		for (data_cntr_0 = 0; data_cntr_0 < 512; data_cntr_0++) {
			PyObject *py_data_0;
			py_data_0 = PyInt_FromLong(object->data[data_cntr_0]);
			PyList_SetItem(py_data, data_cntr_0, py_data_0);
		}
	}
	return py_data;
}

static int py_netr_CryptPassword_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_CryptPassword *object = (struct netr_CryptPassword *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int data_cntr_0;
		for (data_cntr_0 = 0; data_cntr_0 < PyList_GET_SIZE(value); data_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, data_cntr_0), return -1;);
			object->data[data_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, data_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_netr_CryptPassword_get_length(PyObject *obj, void *closure)
{
	struct netr_CryptPassword *object = (struct netr_CryptPassword *)pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyInt_FromLong(object->length);
	return py_length;
}

static int py_netr_CryptPassword_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_CryptPassword *object = (struct netr_CryptPassword *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->length = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_CryptPassword_getsetters[] = {
	{ discard_const_p(char, "data"), py_netr_CryptPassword_get_data, py_netr_CryptPassword_set_data },
	{ discard_const_p(char, "length"), py_netr_CryptPassword_get_length, py_netr_CryptPassword_set_length },
	{ NULL }
};

static PyObject *py_netr_CryptPassword_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_CryptPassword, type);
}


static PyTypeObject netr_CryptPassword_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_CryptPassword",
	.tp_getset = py_netr_CryptPassword_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_CryptPassword_new,
};


static PyObject *py_netr_DsRAddressToSitenamesWCtr_get_count(PyObject *obj, void *closure)
{
	struct netr_DsRAddressToSitenamesWCtr *object = (struct netr_DsRAddressToSitenamesWCtr *)pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyInt_FromLong(object->count);
	return py_count;
}

static int py_netr_DsRAddressToSitenamesWCtr_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DsRAddressToSitenamesWCtr *object = (struct netr_DsRAddressToSitenamesWCtr *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DsRAddressToSitenamesWCtr_get_sitename(PyObject *obj, void *closure)
{
	struct netr_DsRAddressToSitenamesWCtr *object = (struct netr_DsRAddressToSitenamesWCtr *)pytalloc_get_ptr(obj);
	PyObject *py_sitename;
	if (object->sitename == NULL) {
		py_sitename = Py_None;
		Py_INCREF(py_sitename);
	} else {
		py_sitename = PyList_New(object->count);
		if (py_sitename == NULL) {
			return NULL;
		}
		{
			int sitename_cntr_1;
			for (sitename_cntr_1 = 0; sitename_cntr_1 < object->count; sitename_cntr_1++) {
				PyObject *py_sitename_1;
				py_sitename_1 = pytalloc_reference_ex(lsa_String_Type, object->sitename, &object->sitename[sitename_cntr_1]);
				PyList_SetItem(py_sitename, sitename_cntr_1, py_sitename_1);
			}
		}
	}
	return py_sitename;
}

static int py_netr_DsRAddressToSitenamesWCtr_set_sitename(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DsRAddressToSitenamesWCtr *object = (struct netr_DsRAddressToSitenamesWCtr *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->sitename);
	if (value == Py_None) {
		object->sitename = NULL;
	} else {
		object->sitename = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int sitename_cntr_1;
			object->sitename = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->sitename, PyList_GET_SIZE(value));
			if (!object->sitename) { return -1;; }
			talloc_set_name_const(object->sitename, "ARRAY: object->sitename");
			for (sitename_cntr_1 = 0; sitename_cntr_1 < PyList_GET_SIZE(value); sitename_cntr_1++) {
				PY_CHECK_TYPE(lsa_String_Type, PyList_GET_ITEM(value, sitename_cntr_1), return -1;);
				if (talloc_reference(object->sitename, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, sitename_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				object->sitename[sitename_cntr_1] = *(struct lsa_String *)pytalloc_get_ptr(PyList_GET_ITEM(value, sitename_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_netr_DsRAddressToSitenamesWCtr_getsetters[] = {
	{ discard_const_p(char, "count"), py_netr_DsRAddressToSitenamesWCtr_get_count, py_netr_DsRAddressToSitenamesWCtr_set_count },
	{ discard_const_p(char, "sitename"), py_netr_DsRAddressToSitenamesWCtr_get_sitename, py_netr_DsRAddressToSitenamesWCtr_set_sitename },
	{ NULL }
};

static PyObject *py_netr_DsRAddressToSitenamesWCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_DsRAddressToSitenamesWCtr, type);
}


static PyTypeObject netr_DsRAddressToSitenamesWCtr_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_DsRAddressToSitenamesWCtr",
	.tp_getset = py_netr_DsRAddressToSitenamesWCtr_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_DsRAddressToSitenamesWCtr_new,
};


static PyObject *py_netr_DsRAddress_get_buffer(PyObject *obj, void *closure)
{
	struct netr_DsRAddress *object = (struct netr_DsRAddress *)pytalloc_get_ptr(obj);
	PyObject *py_buffer;
	if (object->buffer == NULL) {
		py_buffer = Py_None;
		Py_INCREF(py_buffer);
	} else {
		py_buffer = PyList_New(object->size);
		if (py_buffer == NULL) {
			return NULL;
		}
		{
			int buffer_cntr_1;
			for (buffer_cntr_1 = 0; buffer_cntr_1 < object->size; buffer_cntr_1++) {
				PyObject *py_buffer_1;
				py_buffer_1 = PyInt_FromLong(object->buffer[buffer_cntr_1]);
				PyList_SetItem(py_buffer, buffer_cntr_1, py_buffer_1);
			}
		}
	}
	return py_buffer;
}

static int py_netr_DsRAddress_set_buffer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DsRAddress *object = (struct netr_DsRAddress *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->buffer);
	if (value == Py_None) {
		object->buffer = NULL;
	} else {
		object->buffer = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int buffer_cntr_1;
			object->buffer = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->buffer, PyList_GET_SIZE(value));
			if (!object->buffer) { return -1;; }
			talloc_set_name_const(object->buffer, "ARRAY: object->buffer");
			for (buffer_cntr_1 = 0; buffer_cntr_1 < PyList_GET_SIZE(value); buffer_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, buffer_cntr_1), return -1;);
				object->buffer[buffer_cntr_1] = PyInt_AsLong(PyList_GET_ITEM(value, buffer_cntr_1));
			}
		}
	}
	return 0;
}

static PyObject *py_netr_DsRAddress_get_size(PyObject *obj, void *closure)
{
	struct netr_DsRAddress *object = (struct netr_DsRAddress *)pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyInt_FromLong(object->size);
	return py_size;
}

static int py_netr_DsRAddress_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DsRAddress *object = (struct netr_DsRAddress *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->size = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_netr_DsRAddress_getsetters[] = {
	{ discard_const_p(char, "buffer"), py_netr_DsRAddress_get_buffer, py_netr_DsRAddress_set_buffer },
	{ discard_const_p(char, "size"), py_netr_DsRAddress_get_size, py_netr_DsRAddress_set_size },
	{ NULL }
};

static PyObject *py_netr_DsRAddress_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_DsRAddress, type);
}


static PyTypeObject netr_DsRAddress_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_DsRAddress",
	.tp_getset = py_netr_DsRAddress_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_DsRAddress_new,
};


static PyObject *py_netr_DomainTrust_get_netbios_name(PyObject *obj, void *closure)
{
	struct netr_DomainTrust *object = (struct netr_DomainTrust *)pytalloc_get_ptr(obj);
	PyObject *py_netbios_name;
	if (object->netbios_name == NULL) {
		py_netbios_name = Py_None;
		Py_INCREF(py_netbios_name);
	} else {
		if (object->netbios_name == NULL) {
			py_netbios_name = Py_None;
			Py_INCREF(py_netbios_name);
		} else {
			py_netbios_name = PyUnicode_Decode(object->netbios_name, strlen(object->netbios_name), "utf-8", "ignore");
		}
	}
	return py_netbios_name;
}

static int py_netr_DomainTrust_set_netbios_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainTrust *object = (struct netr_DomainTrust *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->netbios_name = NULL;
	} else {
		object->netbios_name = NULL;
		if (PyUnicode_Check(value)) {
			object->netbios_name = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->netbios_name = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DomainTrust_get_dns_name(PyObject *obj, void *closure)
{
	struct netr_DomainTrust *object = (struct netr_DomainTrust *)pytalloc_get_ptr(obj);
	PyObject *py_dns_name;
	if (object->dns_name == NULL) {
		py_dns_name = Py_None;
		Py_INCREF(py_dns_name);
	} else {
		if (object->dns_name == NULL) {
			py_dns_name = Py_None;
			Py_INCREF(py_dns_name);
		} else {
			py_dns_name = PyUnicode_Decode(object->dns_name, strlen(object->dns_name), "utf-8", "ignore");
		}
	}
	return py_dns_name;
}

static int py_netr_DomainTrust_set_dns_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainTrust *object = (struct netr_DomainTrust *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->dns_name = NULL;
	} else {
		object->dns_name = NULL;
		if (PyUnicode_Check(value)) {
			object->dns_name = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->dns_name = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_netr_DomainTrust_get_trust_flags(PyObject *obj, void *closure)
{
	struct netr_DomainTrust *object = (struct netr_DomainTrust *)pytalloc_get_ptr(obj);
	PyObject *py_trust_flags;
	py_trust_flags = PyInt_FromLong(object->trust_flags);
	return py_trust_flags;
}

static int py_netr_DomainTrust_set_trust_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainTrust *object = (struct netr_DomainTrust *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->trust_flags = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->trust_flags = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netr_DomainTrust_get_parent_index(PyObject *obj, void *closure)
{
	struct netr_DomainTrust *object = (struct netr_DomainTrust *)pytalloc_get_ptr(obj);
	PyObject *py_parent_index;
	py_parent_index = PyInt_FromLong(object->parent_index);
	return py_parent_index;
}

static int py_netr_DomainTrust_set_parent_index(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainTrust *object = (struct netr_DomainTrust *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->parent_index = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DomainTrust_get_trust_type(PyObject *obj, void *closure)
{
	struct netr_DomainTrust *object = (struct netr_DomainTrust *)pytalloc_get_ptr(obj);
	PyObject *py_trust_type;
	py_trust_type = PyInt_FromLong(object->trust_type);
	return py_trust_type;
}

static int py_netr_DomainTrust_set_trust_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainTrust *object = (struct netr_DomainTrust *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->trust_type = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->trust_type = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netr_DomainTrust_get_trust_attributes(PyObject *obj, void *closure)
{
	struct netr_DomainTrust *object = (struct netr_DomainTrust *)pytalloc_get_ptr(obj);
	PyObject *py_trust_attributes;
	py_trust_attributes = PyInt_FromLong(object->trust_attributes);
	return py_trust_attributes;
}

static int py_netr_DomainTrust_set_trust_attributes(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainTrust *object = (struct netr_DomainTrust *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->trust_attributes = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->trust_attributes = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_netr_DomainTrust_get_sid(PyObject *obj, void *closure)
{
	struct netr_DomainTrust *object = (struct netr_DomainTrust *)pytalloc_get_ptr(obj);
	PyObject *py_sid;
	if (object->sid == NULL) {
		py_sid = Py_None;
		Py_INCREF(py_sid);
	} else {
		py_sid = pytalloc_reference_ex(dom_sid_Type, object->sid, object->sid);
	}
	return py_sid;
}

static int py_netr_DomainTrust_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainTrust *object = (struct netr_DomainTrust *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->sid);
	if (value == Py_None) {
		object->sid = NULL;
	} else {
		object->sid = NULL;
		PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->sid = (struct dom_sid *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_netr_DomainTrust_get_guid(PyObject *obj, void *closure)
{
	struct netr_DomainTrust *object = (struct netr_DomainTrust *)pytalloc_get_ptr(obj);
	PyObject *py_guid;
	py_guid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->guid);
	return py_guid;
}

static int py_netr_DomainTrust_set_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainTrust *object = (struct netr_DomainTrust *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->guid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_netr_DomainTrust_getsetters[] = {
	{ discard_const_p(char, "netbios_name"), py_netr_DomainTrust_get_netbios_name, py_netr_DomainTrust_set_netbios_name },
	{ discard_const_p(char, "dns_name"), py_netr_DomainTrust_get_dns_name, py_netr_DomainTrust_set_dns_name },
	{ discard_const_p(char, "trust_flags"), py_netr_DomainTrust_get_trust_flags, py_netr_DomainTrust_set_trust_flags },
	{ discard_const_p(char, "parent_index"), py_netr_DomainTrust_get_parent_index, py_netr_DomainTrust_set_parent_index },
	{ discard_const_p(char, "trust_type"), py_netr_DomainTrust_get_trust_type, py_netr_DomainTrust_set_trust_type },
	{ discard_const_p(char, "trust_attributes"), py_netr_DomainTrust_get_trust_attributes, py_netr_DomainTrust_set_trust_attributes },
	{ discard_const_p(char, "sid"), py_netr_DomainTrust_get_sid, py_netr_DomainTrust_set_sid },
	{ discard_const_p(char, "guid"), py_netr_DomainTrust_get_guid, py_netr_DomainTrust_set_guid },
	{ NULL }
};

static PyObject *py_netr_DomainTrust_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_DomainTrust, type);
}


static PyTypeObject netr_DomainTrust_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_DomainTrust",
	.tp_getset = py_netr_DomainTrust_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_DomainTrust_new,
};


static PyObject *py_netr_DomainTrustList_get_count(PyObject *obj, void *closure)
{
	struct netr_DomainTrustList *object = (struct netr_DomainTrustList *)pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyInt_FromLong(object->count);
	return py_count;
}

static int py_netr_DomainTrustList_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainTrustList *object = (struct netr_DomainTrustList *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DomainTrustList_get_array(PyObject *obj, void *closure)
{
	struct netr_DomainTrustList *object = (struct netr_DomainTrustList *)pytalloc_get_ptr(obj);
	PyObject *py_array;
	if (object->array == NULL) {
		py_array = Py_None;
		Py_INCREF(py_array);
	} else {
		py_array = PyList_New(object->count);
		if (py_array == NULL) {
			return NULL;
		}
		{
			int array_cntr_1;
			for (array_cntr_1 = 0; array_cntr_1 < object->count; array_cntr_1++) {
				PyObject *py_array_1;
				py_array_1 = pytalloc_reference_ex(&netr_DomainTrust_Type, object->array, &object->array[array_cntr_1]);
				PyList_SetItem(py_array, array_cntr_1, py_array_1);
			}
		}
	}
	return py_array;
}

static int py_netr_DomainTrustList_set_array(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DomainTrustList *object = (struct netr_DomainTrustList *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->array);
	if (value == Py_None) {
		object->array = NULL;
	} else {
		object->array = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int array_cntr_1;
			object->array = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->array, PyList_GET_SIZE(value));
			if (!object->array) { return -1;; }
			talloc_set_name_const(object->array, "ARRAY: object->array");
			for (array_cntr_1 = 0; array_cntr_1 < PyList_GET_SIZE(value); array_cntr_1++) {
				PY_CHECK_TYPE(&netr_DomainTrust_Type, PyList_GET_ITEM(value, array_cntr_1), return -1;);
				if (talloc_reference(object->array, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, array_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				object->array[array_cntr_1] = *(struct netr_DomainTrust *)pytalloc_get_ptr(PyList_GET_ITEM(value, array_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_netr_DomainTrustList_getsetters[] = {
	{ discard_const_p(char, "count"), py_netr_DomainTrustList_get_count, py_netr_DomainTrustList_set_count },
	{ discard_const_p(char, "array"), py_netr_DomainTrustList_get_array, py_netr_DomainTrustList_set_array },
	{ NULL }
};

static PyObject *py_netr_DomainTrustList_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_DomainTrustList, type);
}


static PyTypeObject netr_DomainTrustList_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_DomainTrustList",
	.tp_getset = py_netr_DomainTrustList_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_DomainTrustList_new,
};


static PyObject *py_netr_DsRAddressToSitenamesExWCtr_get_count(PyObject *obj, void *closure)
{
	struct netr_DsRAddressToSitenamesExWCtr *object = (struct netr_DsRAddressToSitenamesExWCtr *)pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyInt_FromLong(object->count);
	return py_count;
}

static int py_netr_DsRAddressToSitenamesExWCtr_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DsRAddressToSitenamesExWCtr *object = (struct netr_DsRAddressToSitenamesExWCtr *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_DsRAddressToSitenamesExWCtr_get_sitename(PyObject *obj, void *closure)
{
	struct netr_DsRAddressToSitenamesExWCtr *object = (struct netr_DsRAddressToSitenamesExWCtr *)pytalloc_get_ptr(obj);
	PyObject *py_sitename;
	if (object->sitename == NULL) {
		py_sitename = Py_None;
		Py_INCREF(py_sitename);
	} else {
		py_sitename = PyList_New(object->count);
		if (py_sitename == NULL) {
			return NULL;
		}
		{
			int sitename_cntr_1;
			for (sitename_cntr_1 = 0; sitename_cntr_1 < object->count; sitename_cntr_1++) {
				PyObject *py_sitename_1;
				py_sitename_1 = pytalloc_reference_ex(lsa_String_Type, object->sitename, &object->sitename[sitename_cntr_1]);
				PyList_SetItem(py_sitename, sitename_cntr_1, py_sitename_1);
			}
		}
	}
	return py_sitename;
}

static int py_netr_DsRAddressToSitenamesExWCtr_set_sitename(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DsRAddressToSitenamesExWCtr *object = (struct netr_DsRAddressToSitenamesExWCtr *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->sitename);
	if (value == Py_None) {
		object->sitename = NULL;
	} else {
		object->sitename = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int sitename_cntr_1;
			object->sitename = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->sitename, PyList_GET_SIZE(value));
			if (!object->sitename) { return -1;; }
			talloc_set_name_const(object->sitename, "ARRAY: object->sitename");
			for (sitename_cntr_1 = 0; sitename_cntr_1 < PyList_GET_SIZE(value); sitename_cntr_1++) {
				PY_CHECK_TYPE(lsa_String_Type, PyList_GET_ITEM(value, sitename_cntr_1), return -1;);
				if (talloc_reference(object->sitename, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, sitename_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				object->sitename[sitename_cntr_1] = *(struct lsa_String *)pytalloc_get_ptr(PyList_GET_ITEM(value, sitename_cntr_1));
			}
		}
	}
	return 0;
}

static PyObject *py_netr_DsRAddressToSitenamesExWCtr_get_subnetname(PyObject *obj, void *closure)
{
	struct netr_DsRAddressToSitenamesExWCtr *object = (struct netr_DsRAddressToSitenamesExWCtr *)pytalloc_get_ptr(obj);
	PyObject *py_subnetname;
	if (object->subnetname == NULL) {
		py_subnetname = Py_None;
		Py_INCREF(py_subnetname);
	} else {
		py_subnetname = PyList_New(object->count);
		if (py_subnetname == NULL) {
			return NULL;
		}
		{
			int subnetname_cntr_1;
			for (subnetname_cntr_1 = 0; subnetname_cntr_1 < object->count; subnetname_cntr_1++) {
				PyObject *py_subnetname_1;
				py_subnetname_1 = pytalloc_reference_ex(lsa_String_Type, object->subnetname, &object->subnetname[subnetname_cntr_1]);
				PyList_SetItem(py_subnetname, subnetname_cntr_1, py_subnetname_1);
			}
		}
	}
	return py_subnetname;
}

static int py_netr_DsRAddressToSitenamesExWCtr_set_subnetname(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_DsRAddressToSitenamesExWCtr *object = (struct netr_DsRAddressToSitenamesExWCtr *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->subnetname);
	if (value == Py_None) {
		object->subnetname = NULL;
	} else {
		object->subnetname = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int subnetname_cntr_1;
			object->subnetname = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->subnetname, PyList_GET_SIZE(value));
			if (!object->subnetname) { return -1;; }
			talloc_set_name_const(object->subnetname, "ARRAY: object->subnetname");
			for (subnetname_cntr_1 = 0; subnetname_cntr_1 < PyList_GET_SIZE(value); subnetname_cntr_1++) {
				PY_CHECK_TYPE(lsa_String_Type, PyList_GET_ITEM(value, subnetname_cntr_1), return -1;);
				if (talloc_reference(object->subnetname, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, subnetname_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				object->subnetname[subnetname_cntr_1] = *(struct lsa_String *)pytalloc_get_ptr(PyList_GET_ITEM(value, subnetname_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_netr_DsRAddressToSitenamesExWCtr_getsetters[] = {
	{ discard_const_p(char, "count"), py_netr_DsRAddressToSitenamesExWCtr_get_count, py_netr_DsRAddressToSitenamesExWCtr_set_count },
	{ discard_const_p(char, "sitename"), py_netr_DsRAddressToSitenamesExWCtr_get_sitename, py_netr_DsRAddressToSitenamesExWCtr_set_sitename },
	{ discard_const_p(char, "subnetname"), py_netr_DsRAddressToSitenamesExWCtr_get_subnetname, py_netr_DsRAddressToSitenamesExWCtr_set_subnetname },
	{ NULL }
};

static PyObject *py_netr_DsRAddressToSitenamesExWCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_DsRAddressToSitenamesExWCtr, type);
}


static PyTypeObject netr_DsRAddressToSitenamesExWCtr_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_DsRAddressToSitenamesExWCtr",
	.tp_getset = py_netr_DsRAddressToSitenamesExWCtr_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_DsRAddressToSitenamesExWCtr_new,
};


static PyObject *py_DcSitesCtr_get_num_sites(PyObject *obj, void *closure)
{
	struct DcSitesCtr *object = (struct DcSitesCtr *)pytalloc_get_ptr(obj);
	PyObject *py_num_sites;
	py_num_sites = PyInt_FromLong(object->num_sites);
	return py_num_sites;
}

static int py_DcSitesCtr_set_num_sites(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DcSitesCtr *object = (struct DcSitesCtr *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->num_sites = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DcSitesCtr_get_sites(PyObject *obj, void *closure)
{
	struct DcSitesCtr *object = (struct DcSitesCtr *)pytalloc_get_ptr(obj);
	PyObject *py_sites;
	if (object->sites == NULL) {
		py_sites = Py_None;
		Py_INCREF(py_sites);
	} else {
		py_sites = PyList_New(object->num_sites);
		if (py_sites == NULL) {
			return NULL;
		}
		{
			int sites_cntr_1;
			for (sites_cntr_1 = 0; sites_cntr_1 < object->num_sites; sites_cntr_1++) {
				PyObject *py_sites_1;
				py_sites_1 = pytalloc_reference_ex(lsa_String_Type, object->sites, &object->sites[sites_cntr_1]);
				PyList_SetItem(py_sites, sites_cntr_1, py_sites_1);
			}
		}
	}
	return py_sites;
}

static int py_DcSitesCtr_set_sites(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DcSitesCtr *object = (struct DcSitesCtr *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->sites);
	if (value == Py_None) {
		object->sites = NULL;
	} else {
		object->sites = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int sites_cntr_1;
			object->sites = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->sites, PyList_GET_SIZE(value));
			if (!object->sites) { return -1;; }
			talloc_set_name_const(object->sites, "ARRAY: object->sites");
			for (sites_cntr_1 = 0; sites_cntr_1 < PyList_GET_SIZE(value); sites_cntr_1++) {
				PY_CHECK_TYPE(lsa_String_Type, PyList_GET_ITEM(value, sites_cntr_1), return -1;);
				if (talloc_reference(object->sites, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, sites_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				object->sites[sites_cntr_1] = *(struct lsa_String *)pytalloc_get_ptr(PyList_GET_ITEM(value, sites_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_DcSitesCtr_getsetters[] = {
	{ discard_const_p(char, "num_sites"), py_DcSitesCtr_get_num_sites, py_DcSitesCtr_set_num_sites },
	{ discard_const_p(char, "sites"), py_DcSitesCtr_get_sites, py_DcSitesCtr_set_sites },
	{ NULL }
};

static PyObject *py_DcSitesCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DcSitesCtr, type);
}


static PyTypeObject DcSitesCtr_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.DcSitesCtr",
	.tp_getset = py_DcSitesCtr_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DcSitesCtr_new,
};


static PyObject *py_netr_TrustInfo_get_count(PyObject *obj, void *closure)
{
	struct netr_TrustInfo *object = (struct netr_TrustInfo *)pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyInt_FromLong(object->count);
	return py_count;
}

static int py_netr_TrustInfo_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_TrustInfo *object = (struct netr_TrustInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_TrustInfo_get_data(PyObject *obj, void *closure)
{
	struct netr_TrustInfo *object = (struct netr_TrustInfo *)pytalloc_get_ptr(obj);
	PyObject *py_data;
	if (object->data == NULL) {
		py_data = Py_None;
		Py_INCREF(py_data);
	} else {
		py_data = PyList_New(object->count);
		if (py_data == NULL) {
			return NULL;
		}
		{
			int data_cntr_1;
			for (data_cntr_1 = 0; data_cntr_1 < object->count; data_cntr_1++) {
				PyObject *py_data_1;
				py_data_1 = PyInt_FromLong(object->data[data_cntr_1]);
				PyList_SetItem(py_data, data_cntr_1, py_data_1);
			}
		}
	}
	return py_data;
}

static int py_netr_TrustInfo_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_TrustInfo *object = (struct netr_TrustInfo *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->data);
	if (value == Py_None) {
		object->data = NULL;
	} else {
		object->data = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int data_cntr_1;
			object->data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->data, PyList_GET_SIZE(value));
			if (!object->data) { return -1;; }
			talloc_set_name_const(object->data, "ARRAY: object->data");
			for (data_cntr_1 = 0; data_cntr_1 < PyList_GET_SIZE(value); data_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, data_cntr_1), return -1;);
				object->data[data_cntr_1] = PyInt_AsLong(PyList_GET_ITEM(value, data_cntr_1));
			}
		}
	}
	return 0;
}

static PyObject *py_netr_TrustInfo_get_entry_count(PyObject *obj, void *closure)
{
	struct netr_TrustInfo *object = (struct netr_TrustInfo *)pytalloc_get_ptr(obj);
	PyObject *py_entry_count;
	py_entry_count = PyInt_FromLong(object->entry_count);
	return py_entry_count;
}

static int py_netr_TrustInfo_set_entry_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_TrustInfo *object = (struct netr_TrustInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->entry_count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_netr_TrustInfo_get_entries(PyObject *obj, void *closure)
{
	struct netr_TrustInfo *object = (struct netr_TrustInfo *)pytalloc_get_ptr(obj);
	PyObject *py_entries;
	if (object->entries == NULL) {
		py_entries = Py_None;
		Py_INCREF(py_entries);
	} else {
		py_entries = PyList_New(object->count);
		if (py_entries == NULL) {
			return NULL;
		}
		{
			int entries_cntr_1;
			for (entries_cntr_1 = 0; entries_cntr_1 < object->count; entries_cntr_1++) {
				PyObject *py_entries_1;
				py_entries_1 = pytalloc_reference_ex(lsa_String_Type, object->entries, &object->entries[entries_cntr_1]);
				PyList_SetItem(py_entries, entries_cntr_1, py_entries_1);
			}
		}
	}
	return py_entries;
}

static int py_netr_TrustInfo_set_entries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct netr_TrustInfo *object = (struct netr_TrustInfo *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->entries);
	if (value == Py_None) {
		object->entries = NULL;
	} else {
		object->entries = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int entries_cntr_1;
			object->entries = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->entries, PyList_GET_SIZE(value));
			if (!object->entries) { return -1;; }
			talloc_set_name_const(object->entries, "ARRAY: object->entries");
			for (entries_cntr_1 = 0; entries_cntr_1 < PyList_GET_SIZE(value); entries_cntr_1++) {
				PY_CHECK_TYPE(lsa_String_Type, PyList_GET_ITEM(value, entries_cntr_1), return -1;);
				if (talloc_reference(object->entries, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, entries_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				object->entries[entries_cntr_1] = *(struct lsa_String *)pytalloc_get_ptr(PyList_GET_ITEM(value, entries_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_netr_TrustInfo_getsetters[] = {
	{ discard_const_p(char, "count"), py_netr_TrustInfo_get_count, py_netr_TrustInfo_set_count },
	{ discard_const_p(char, "data"), py_netr_TrustInfo_get_data, py_netr_TrustInfo_set_data },
	{ discard_const_p(char, "entry_count"), py_netr_TrustInfo_get_entry_count, py_netr_TrustInfo_set_entry_count },
	{ discard_const_p(char, "entries"), py_netr_TrustInfo_get_entries, py_netr_TrustInfo_set_entries },
	{ NULL }
};

static PyObject *py_netr_TrustInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct netr_TrustInfo, type);
}


static PyTypeObject netr_TrustInfo_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netr_TrustInfo",
	.tp_getset = py_netr_TrustInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_netr_TrustInfo_new,
};


static PyObject *py_NL_DNS_NAME_INFO_get_type(PyObject *obj, void *closure)
{
	struct NL_DNS_NAME_INFO *object = (struct NL_DNS_NAME_INFO *)pytalloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyInt_FromLong(object->type);
	return py_type;
}

static int py_NL_DNS_NAME_INFO_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_DNS_NAME_INFO *object = (struct NL_DNS_NAME_INFO *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->type = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->type = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_NL_DNS_NAME_INFO_get_dns_domain_info(PyObject *obj, void *closure)
{
	struct NL_DNS_NAME_INFO *object = (struct NL_DNS_NAME_INFO *)pytalloc_get_ptr(obj);
	PyObject *py_dns_domain_info;
	if (object->dns_domain_info == NULL) {
		py_dns_domain_info = Py_None;
		Py_INCREF(py_dns_domain_info);
	} else {
		if (object->dns_domain_info == NULL) {
			py_dns_domain_info = Py_None;
			Py_INCREF(py_dns_domain_info);
		} else {
			py_dns_domain_info = PyUnicode_Decode(object->dns_domain_info, strlen(object->dns_domain_info), "utf-8", "ignore");
		}
	}
	return py_dns_domain_info;
}

static int py_NL_DNS_NAME_INFO_set_dns_domain_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_DNS_NAME_INFO *object = (struct NL_DNS_NAME_INFO *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->dns_domain_info = NULL;
	} else {
		object->dns_domain_info = NULL;
		if (PyUnicode_Check(value)) {
			object->dns_domain_info = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->dns_domain_info = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_NL_DNS_NAME_INFO_get_dns_domain_info_type(PyObject *obj, void *closure)
{
	struct NL_DNS_NAME_INFO *object = (struct NL_DNS_NAME_INFO *)pytalloc_get_ptr(obj);
	PyObject *py_dns_domain_info_type;
	py_dns_domain_info_type = PyInt_FromLong(object->dns_domain_info_type);
	return py_dns_domain_info_type;
}

static int py_NL_DNS_NAME_INFO_set_dns_domain_info_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_DNS_NAME_INFO *object = (struct NL_DNS_NAME_INFO *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->dns_domain_info_type = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->dns_domain_info_type = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_NL_DNS_NAME_INFO_get_priority(PyObject *obj, void *closure)
{
	struct NL_DNS_NAME_INFO *object = (struct NL_DNS_NAME_INFO *)pytalloc_get_ptr(obj);
	PyObject *py_priority;
	py_priority = PyInt_FromLong(object->priority);
	return py_priority;
}

static int py_NL_DNS_NAME_INFO_set_priority(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_DNS_NAME_INFO *object = (struct NL_DNS_NAME_INFO *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->priority = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_NL_DNS_NAME_INFO_get_weight(PyObject *obj, void *closure)
{
	struct NL_DNS_NAME_INFO *object = (struct NL_DNS_NAME_INFO *)pytalloc_get_ptr(obj);
	PyObject *py_weight;
	py_weight = PyInt_FromLong(object->weight);
	return py_weight;
}

static int py_NL_DNS_NAME_INFO_set_weight(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_DNS_NAME_INFO *object = (struct NL_DNS_NAME_INFO *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->weight = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_NL_DNS_NAME_INFO_get_port(PyObject *obj, void *closure)
{
	struct NL_DNS_NAME_INFO *object = (struct NL_DNS_NAME_INFO *)pytalloc_get_ptr(obj);
	PyObject *py_port;
	py_port = PyInt_FromLong(object->port);
	return py_port;
}

static int py_NL_DNS_NAME_INFO_set_port(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_DNS_NAME_INFO *object = (struct NL_DNS_NAME_INFO *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->port = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_NL_DNS_NAME_INFO_get_dns_register(PyObject *obj, void *closure)
{
	struct NL_DNS_NAME_INFO *object = (struct NL_DNS_NAME_INFO *)pytalloc_get_ptr(obj);
	PyObject *py_dns_register;
	py_dns_register = PyInt_FromLong(object->dns_register);
	return py_dns_register;
}

static int py_NL_DNS_NAME_INFO_set_dns_register(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_DNS_NAME_INFO *object = (struct NL_DNS_NAME_INFO *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dns_register = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_NL_DNS_NAME_INFO_get_status(PyObject *obj, void *closure)
{
	struct NL_DNS_NAME_INFO *object = (struct NL_DNS_NAME_INFO *)pytalloc_get_ptr(obj);
	PyObject *py_status;
	py_status = PyInt_FromLong(object->status);
	return py_status;
}

static int py_NL_DNS_NAME_INFO_set_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_DNS_NAME_INFO *object = (struct NL_DNS_NAME_INFO *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->status = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_NL_DNS_NAME_INFO_getsetters[] = {
	{ discard_const_p(char, "type"), py_NL_DNS_NAME_INFO_get_type, py_NL_DNS_NAME_INFO_set_type },
	{ discard_const_p(char, "dns_domain_info"), py_NL_DNS_NAME_INFO_get_dns_domain_info, py_NL_DNS_NAME_INFO_set_dns_domain_info },
	{ discard_const_p(char, "dns_domain_info_type"), py_NL_DNS_NAME_INFO_get_dns_domain_info_type, py_NL_DNS_NAME_INFO_set_dns_domain_info_type },
	{ discard_const_p(char, "priority"), py_NL_DNS_NAME_INFO_get_priority, py_NL_DNS_NAME_INFO_set_priority },
	{ discard_const_p(char, "weight"), py_NL_DNS_NAME_INFO_get_weight, py_NL_DNS_NAME_INFO_set_weight },
	{ discard_const_p(char, "port"), py_NL_DNS_NAME_INFO_get_port, py_NL_DNS_NAME_INFO_set_port },
	{ discard_const_p(char, "dns_register"), py_NL_DNS_NAME_INFO_get_dns_register, py_NL_DNS_NAME_INFO_set_dns_register },
	{ discard_const_p(char, "status"), py_NL_DNS_NAME_INFO_get_status, py_NL_DNS_NAME_INFO_set_status },
	{ NULL }
};

static PyObject *py_NL_DNS_NAME_INFO_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct NL_DNS_NAME_INFO, type);
}


static PyTypeObject NL_DNS_NAME_INFO_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.NL_DNS_NAME_INFO",
	.tp_getset = py_NL_DNS_NAME_INFO_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_NL_DNS_NAME_INFO_new,
};


static PyObject *py_NL_DNS_NAME_INFO_ARRAY_get_count(PyObject *obj, void *closure)
{
	struct NL_DNS_NAME_INFO_ARRAY *object = (struct NL_DNS_NAME_INFO_ARRAY *)pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyInt_FromLong(object->count);
	return py_count;
}

static int py_NL_DNS_NAME_INFO_ARRAY_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_DNS_NAME_INFO_ARRAY *object = (struct NL_DNS_NAME_INFO_ARRAY *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_NL_DNS_NAME_INFO_ARRAY_get_names(PyObject *obj, void *closure)
{
	struct NL_DNS_NAME_INFO_ARRAY *object = (struct NL_DNS_NAME_INFO_ARRAY *)pytalloc_get_ptr(obj);
	PyObject *py_names;
	if (object->names == NULL) {
		py_names = Py_None;
		Py_INCREF(py_names);
	} else {
		py_names = PyList_New(object->count);
		if (py_names == NULL) {
			return NULL;
		}
		{
			int names_cntr_1;
			for (names_cntr_1 = 0; names_cntr_1 < object->count; names_cntr_1++) {
				PyObject *py_names_1;
				py_names_1 = pytalloc_reference_ex(&NL_DNS_NAME_INFO_Type, object->names, &object->names[names_cntr_1]);
				PyList_SetItem(py_names, names_cntr_1, py_names_1);
			}
		}
	}
	return py_names;
}

static int py_NL_DNS_NAME_INFO_ARRAY_set_names(PyObject *py_obj, PyObject *value, void *closure)
{
	struct NL_DNS_NAME_INFO_ARRAY *object = (struct NL_DNS_NAME_INFO_ARRAY *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->names);
	if (value == Py_None) {
		object->names = NULL;
	} else {
		object->names = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int names_cntr_1;
			object->names = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->names, PyList_GET_SIZE(value));
			if (!object->names) { return -1;; }
			talloc_set_name_const(object->names, "ARRAY: object->names");
			for (names_cntr_1 = 0; names_cntr_1 < PyList_GET_SIZE(value); names_cntr_1++) {
				PY_CHECK_TYPE(&NL_DNS_NAME_INFO_Type, PyList_GET_ITEM(value, names_cntr_1), return -1;);
				if (talloc_reference(object->names, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, names_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				object->names[names_cntr_1] = *(struct NL_DNS_NAME_INFO *)pytalloc_get_ptr(PyList_GET_ITEM(value, names_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_NL_DNS_NAME_INFO_ARRAY_getsetters[] = {
	{ discard_const_p(char, "count"), py_NL_DNS_NAME_INFO_ARRAY_get_count, py_NL_DNS_NAME_INFO_ARRAY_set_count },
	{ discard_const_p(char, "names"), py_NL_DNS_NAME_INFO_ARRAY_get_names, py_NL_DNS_NAME_INFO_ARRAY_set_names },
	{ NULL }
};

static PyObject *py_NL_DNS_NAME_INFO_ARRAY_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct NL_DNS_NAME_INFO_ARRAY, type);
}

static PyObject *py_NL_DNS_NAME_INFO_ARRAY_ndr_pack(PyObject *py_obj)
{
	struct NL_DNS_NAME_INFO_ARRAY *object = (struct NL_DNS_NAME_INFO_ARRAY *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_NL_DNS_NAME_INFO_ARRAY);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_NL_DNS_NAME_INFO_ARRAY_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct NL_DNS_NAME_INFO_ARRAY *object = (struct NL_DNS_NAME_INFO_ARRAY *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_NL_DNS_NAME_INFO_ARRAY);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_NL_DNS_NAME_INFO_ARRAY);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_NL_DNS_NAME_INFO_ARRAY_ndr_print(PyObject *py_obj)
{
	struct NL_DNS_NAME_INFO_ARRAY *object = (struct NL_DNS_NAME_INFO_ARRAY *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_NL_DNS_NAME_INFO_ARRAY, "NL_DNS_NAME_INFO_ARRAY", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_NL_DNS_NAME_INFO_ARRAY_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_NL_DNS_NAME_INFO_ARRAY_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_NL_DNS_NAME_INFO_ARRAY_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_NL_DNS_NAME_INFO_ARRAY_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject NL_DNS_NAME_INFO_ARRAY_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.NL_DNS_NAME_INFO_ARRAY",
	.tp_getset = py_NL_DNS_NAME_INFO_ARRAY_getsetters,
	.tp_methods = py_NL_DNS_NAME_INFO_ARRAY_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_NL_DNS_NAME_INFO_ARRAY_new,
};


static bool pack_py_netr_LogonUasLogon_args_in(PyObject *args, PyObject *kwargs, struct netr_LogonUasLogon *r)
{
	PyObject *py_server_name;
	PyObject *py_account_name;
	PyObject *py_workstation;
	const char *kwnames[] = {
		"server_name", "account_name", "workstation", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:netr_LogonUasLogon", discard_const_p(char *, kwnames), &py_server_name, &py_account_name, &py_workstation)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		if (PyUnicode_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
		} else if (PyString_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(py_server_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
			return false;
		}
	}
	r->in.account_name = talloc_ptrtype(r, r->in.account_name);
	if (PyUnicode_Check(py_account_name)) {
		r->in.account_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_account_name, "utf-8", "ignore"));
	} else if (PyString_Check(py_account_name)) {
		r->in.account_name = PyString_AS_STRING(py_account_name);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_account_name)->tp_name);
		return false;
	}
	r->in.workstation = talloc_ptrtype(r, r->in.workstation);
	if (PyUnicode_Check(py_workstation)) {
		r->in.workstation = PyString_AS_STRING(PyUnicode_AsEncodedString(py_workstation, "utf-8", "ignore"));
	} else if (PyString_Check(py_workstation)) {
		r->in.workstation = PyString_AS_STRING(py_workstation);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_workstation)->tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_netr_LogonUasLogon_args_out(struct netr_LogonUasLogon *r)
{
	PyObject *result;
	PyObject *py_info;
	if (*r->out.info == NULL) {
		py_info = Py_None;
		Py_INCREF(py_info);
	} else {
		py_info = pytalloc_reference_ex(&netr_UasInfo_Type, *r->out.info, *r->out.info);
	}
	result = py_info;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_LogonUasLogoff_args_in(PyObject *args, PyObject *kwargs, struct netr_LogonUasLogoff *r)
{
	PyObject *py_server_name;
	PyObject *py_account_name;
	PyObject *py_workstation;
	const char *kwnames[] = {
		"server_name", "account_name", "workstation", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:netr_LogonUasLogoff", discard_const_p(char *, kwnames), &py_server_name, &py_account_name, &py_workstation)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		if (PyUnicode_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
		} else if (PyString_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(py_server_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
			return false;
		}
	}
	r->in.account_name = talloc_ptrtype(r, r->in.account_name);
	if (PyUnicode_Check(py_account_name)) {
		r->in.account_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_account_name, "utf-8", "ignore"));
	} else if (PyString_Check(py_account_name)) {
		r->in.account_name = PyString_AS_STRING(py_account_name);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_account_name)->tp_name);
		return false;
	}
	r->in.workstation = talloc_ptrtype(r, r->in.workstation);
	if (PyUnicode_Check(py_workstation)) {
		r->in.workstation = PyString_AS_STRING(PyUnicode_AsEncodedString(py_workstation, "utf-8", "ignore"));
	} else if (PyString_Check(py_workstation)) {
		r->in.workstation = PyString_AS_STRING(py_workstation);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_workstation)->tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_netr_LogonUasLogoff_args_out(struct netr_LogonUasLogoff *r)
{
	PyObject *result;
	PyObject *py_info;
	py_info = pytalloc_reference_ex(&netr_UasLogoffInfo_Type, r->out.info, r->out.info);
	result = py_info;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_LogonSamLogon_args_in(PyObject *args, PyObject *kwargs, struct netr_LogonSamLogon *r)
{
	PyObject *py_server_name;
	PyObject *py_computer_name;
	PyObject *py_credential;
	PyObject *py_return_authenticator;
	PyObject *py_logon_level;
	PyObject *py_logon;
	PyObject *py_validation_level;
	const char *kwnames[] = {
		"server_name", "computer_name", "credential", "return_authenticator", "logon_level", "logon", "validation_level", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOO:netr_LogonSamLogon", discard_const_p(char *, kwnames), &py_server_name, &py_computer_name, &py_credential, &py_return_authenticator, &py_logon_level, &py_logon, &py_validation_level)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		if (PyUnicode_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
		} else if (PyString_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(py_server_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
			return false;
		}
	}
	if (py_computer_name == Py_None) {
		r->in.computer_name = NULL;
	} else {
		r->in.computer_name = NULL;
		if (PyUnicode_Check(py_computer_name)) {
			r->in.computer_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_computer_name, "utf-8", "ignore"));
		} else if (PyString_Check(py_computer_name)) {
			r->in.computer_name = PyString_AS_STRING(py_computer_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_computer_name)->tp_name);
			return false;
		}
	}
	if (py_credential == Py_None) {
		r->in.credential = NULL;
	} else {
		r->in.credential = NULL;
		PY_CHECK_TYPE(&netr_Authenticator_Type, py_credential, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_credential)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.credential = (struct netr_Authenticator *)pytalloc_get_ptr(py_credential);
	}
	if (py_return_authenticator == Py_None) {
		r->in.return_authenticator = NULL;
	} else {
		r->in.return_authenticator = NULL;
		PY_CHECK_TYPE(&netr_Authenticator_Type, py_return_authenticator, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_return_authenticator)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.return_authenticator = (struct netr_Authenticator *)pytalloc_get_ptr(py_return_authenticator);
	}
	if (PyLong_Check(py_logon_level)) {
		r->in.logon_level = PyLong_AsLongLong(py_logon_level);
	} else if (PyInt_Check(py_logon_level)) {
		r->in.logon_level = PyInt_AsLong(py_logon_level);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	r->in.logon = talloc_ptrtype(r, r->in.logon);
	{
		union netr_LogonLevel *logon_switch_1;
		logon_switch_1 = py_export_netr_LogonLevel(r, r->in.logon_level, py_logon);
		if (logon_switch_1 == NULL) {
			return false;
		}
		r->in.logon = logon_switch_1;
	}
	PY_CHECK_TYPE(&PyInt_Type, py_validation_level, return false;);
	r->in.validation_level = PyInt_AsLong(py_validation_level);
	return true;
}

static PyObject *unpack_py_netr_LogonSamLogon_args_out(struct netr_LogonSamLogon *r)
{
	PyObject *result;
	PyObject *py_return_authenticator;
	PyObject *py_validation;
	PyObject *py_authoritative;
	result = PyTuple_New(3);
	if (r->out.return_authenticator == NULL) {
		py_return_authenticator = Py_None;
		Py_INCREF(py_return_authenticator);
	} else {
		py_return_authenticator = pytalloc_reference_ex(&netr_Authenticator_Type, r->out.return_authenticator, r->out.return_authenticator);
	}
	PyTuple_SetItem(result, 0, py_return_authenticator);
	py_validation = py_import_netr_Validation(r->out.validation, r->in.validation_level, r->out.validation);
	if (py_validation == NULL) {
		return NULL;
	}
	PyTuple_SetItem(result, 1, py_validation);
	py_authoritative = PyInt_FromLong(*r->out.authoritative);
	PyTuple_SetItem(result, 2, py_authoritative);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_LogonSamLogoff_args_in(PyObject *args, PyObject *kwargs, struct netr_LogonSamLogoff *r)
{
	PyObject *py_server_name;
	PyObject *py_computer_name;
	PyObject *py_credential;
	PyObject *py_return_authenticator;
	PyObject *py_logon_level;
	PyObject *py_logon;
	const char *kwnames[] = {
		"server_name", "computer_name", "credential", "return_authenticator", "logon_level", "logon", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOO:netr_LogonSamLogoff", discard_const_p(char *, kwnames), &py_server_name, &py_computer_name, &py_credential, &py_return_authenticator, &py_logon_level, &py_logon)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		if (PyUnicode_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
		} else if (PyString_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(py_server_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
			return false;
		}
	}
	if (py_computer_name == Py_None) {
		r->in.computer_name = NULL;
	} else {
		r->in.computer_name = NULL;
		if (PyUnicode_Check(py_computer_name)) {
			r->in.computer_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_computer_name, "utf-8", "ignore"));
		} else if (PyString_Check(py_computer_name)) {
			r->in.computer_name = PyString_AS_STRING(py_computer_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_computer_name)->tp_name);
			return false;
		}
	}
	if (py_credential == Py_None) {
		r->in.credential = NULL;
	} else {
		r->in.credential = NULL;
		PY_CHECK_TYPE(&netr_Authenticator_Type, py_credential, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_credential)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.credential = (struct netr_Authenticator *)pytalloc_get_ptr(py_credential);
	}
	if (py_return_authenticator == Py_None) {
		r->in.return_authenticator = NULL;
	} else {
		r->in.return_authenticator = NULL;
		PY_CHECK_TYPE(&netr_Authenticator_Type, py_return_authenticator, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_return_authenticator)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.return_authenticator = (struct netr_Authenticator *)pytalloc_get_ptr(py_return_authenticator);
	}
	if (PyLong_Check(py_logon_level)) {
		r->in.logon_level = PyLong_AsLongLong(py_logon_level);
	} else if (PyInt_Check(py_logon_level)) {
		r->in.logon_level = PyInt_AsLong(py_logon_level);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	{
		union netr_LogonLevel *logon_switch_0;
		logon_switch_0 = py_export_netr_LogonLevel(r, r->in.logon_level, py_logon);
		if (logon_switch_0 == NULL) {
			return false;
		}
		r->in.logon = *logon_switch_0;
	}
	return true;
}

static PyObject *unpack_py_netr_LogonSamLogoff_args_out(struct netr_LogonSamLogoff *r)
{
	PyObject *result;
	PyObject *py_return_authenticator;
	if (r->out.return_authenticator == NULL) {
		py_return_authenticator = Py_None;
		Py_INCREF(py_return_authenticator);
	} else {
		py_return_authenticator = pytalloc_reference_ex(&netr_Authenticator_Type, r->out.return_authenticator, r->out.return_authenticator);
	}
	result = py_return_authenticator;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_ServerReqChallenge_args_in(PyObject *args, PyObject *kwargs, struct netr_ServerReqChallenge *r)
{
	PyObject *py_server_name;
	PyObject *py_computer_name;
	PyObject *py_credentials;
	const char *kwnames[] = {
		"server_name", "computer_name", "credentials", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:netr_ServerReqChallenge", discard_const_p(char *, kwnames), &py_server_name, &py_computer_name, &py_credentials)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		if (PyUnicode_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
		} else if (PyString_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(py_server_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
			return false;
		}
	}
	r->in.computer_name = talloc_ptrtype(r, r->in.computer_name);
	if (PyUnicode_Check(py_computer_name)) {
		r->in.computer_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_computer_name, "utf-8", "ignore"));
	} else if (PyString_Check(py_computer_name)) {
		r->in.computer_name = PyString_AS_STRING(py_computer_name);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_computer_name)->tp_name);
		return false;
	}
	r->in.credentials = talloc_ptrtype(r, r->in.credentials);
	PY_CHECK_TYPE(&netr_Credential_Type, py_credentials, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_credentials)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.credentials = (struct netr_Credential *)pytalloc_get_ptr(py_credentials);
	return true;
}

static PyObject *unpack_py_netr_ServerReqChallenge_args_out(struct netr_ServerReqChallenge *r)
{
	PyObject *result;
	PyObject *py_return_credentials;
	py_return_credentials = pytalloc_reference_ex(&netr_Credential_Type, r->out.return_credentials, r->out.return_credentials);
	result = py_return_credentials;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_ServerAuthenticate_args_in(PyObject *args, PyObject *kwargs, struct netr_ServerAuthenticate *r)
{
	PyObject *py_server_name;
	PyObject *py_account_name;
	PyObject *py_secure_channel_type;
	PyObject *py_computer_name;
	PyObject *py_credentials;
	const char *kwnames[] = {
		"server_name", "account_name", "secure_channel_type", "computer_name", "credentials", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:netr_ServerAuthenticate", discard_const_p(char *, kwnames), &py_server_name, &py_account_name, &py_secure_channel_type, &py_computer_name, &py_credentials)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		if (PyUnicode_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
		} else if (PyString_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(py_server_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
			return false;
		}
	}
	r->in.account_name = talloc_ptrtype(r, r->in.account_name);
	if (PyUnicode_Check(py_account_name)) {
		r->in.account_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_account_name, "utf-8", "ignore"));
	} else if (PyString_Check(py_account_name)) {
		r->in.account_name = PyString_AS_STRING(py_account_name);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_account_name)->tp_name);
		return false;
	}
	if (PyLong_Check(py_secure_channel_type)) {
		r->in.secure_channel_type = PyLong_AsLongLong(py_secure_channel_type);
	} else if (PyInt_Check(py_secure_channel_type)) {
		r->in.secure_channel_type = PyInt_AsLong(py_secure_channel_type);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	r->in.computer_name = talloc_ptrtype(r, r->in.computer_name);
	if (PyUnicode_Check(py_computer_name)) {
		r->in.computer_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_computer_name, "utf-8", "ignore"));
	} else if (PyString_Check(py_computer_name)) {
		r->in.computer_name = PyString_AS_STRING(py_computer_name);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_computer_name)->tp_name);
		return false;
	}
	r->in.credentials = talloc_ptrtype(r, r->in.credentials);
	PY_CHECK_TYPE(&netr_Credential_Type, py_credentials, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_credentials)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.credentials = (struct netr_Credential *)pytalloc_get_ptr(py_credentials);
	return true;
}

static PyObject *unpack_py_netr_ServerAuthenticate_args_out(struct netr_ServerAuthenticate *r)
{
	PyObject *result;
	PyObject *py_return_credentials;
	py_return_credentials = pytalloc_reference_ex(&netr_Credential_Type, r->out.return_credentials, r->out.return_credentials);
	result = py_return_credentials;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_ServerPasswordSet_args_in(PyObject *args, PyObject *kwargs, struct netr_ServerPasswordSet *r)
{
	PyObject *py_server_name;
	PyObject *py_account_name;
	PyObject *py_secure_channel_type;
	PyObject *py_computer_name;
	PyObject *py_credential;
	PyObject *py_new_password;
	const char *kwnames[] = {
		"server_name", "account_name", "secure_channel_type", "computer_name", "credential", "new_password", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOO:netr_ServerPasswordSet", discard_const_p(char *, kwnames), &py_server_name, &py_account_name, &py_secure_channel_type, &py_computer_name, &py_credential, &py_new_password)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		if (PyUnicode_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
		} else if (PyString_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(py_server_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
			return false;
		}
	}
	r->in.account_name = talloc_ptrtype(r, r->in.account_name);
	if (PyUnicode_Check(py_account_name)) {
		r->in.account_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_account_name, "utf-8", "ignore"));
	} else if (PyString_Check(py_account_name)) {
		r->in.account_name = PyString_AS_STRING(py_account_name);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_account_name)->tp_name);
		return false;
	}
	if (PyLong_Check(py_secure_channel_type)) {
		r->in.secure_channel_type = PyLong_AsLongLong(py_secure_channel_type);
	} else if (PyInt_Check(py_secure_channel_type)) {
		r->in.secure_channel_type = PyInt_AsLong(py_secure_channel_type);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	r->in.computer_name = talloc_ptrtype(r, r->in.computer_name);
	if (PyUnicode_Check(py_computer_name)) {
		r->in.computer_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_computer_name, "utf-8", "ignore"));
	} else if (PyString_Check(py_computer_name)) {
		r->in.computer_name = PyString_AS_STRING(py_computer_name);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_computer_name)->tp_name);
		return false;
	}
	r->in.credential = talloc_ptrtype(r, r->in.credential);
	PY_CHECK_TYPE(&netr_Authenticator_Type, py_credential, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_credential)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.credential = (struct netr_Authenticator *)pytalloc_get_ptr(py_credential);
	r->in.new_password = talloc_ptrtype(r, r->in.new_password);
	PY_CHECK_TYPE(samr_Password_Type, py_new_password, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_new_password)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.new_password = (struct samr_Password *)pytalloc_get_ptr(py_new_password);
	return true;
}

static PyObject *unpack_py_netr_ServerPasswordSet_args_out(struct netr_ServerPasswordSet *r)
{
	PyObject *result;
	PyObject *py_return_authenticator;
	py_return_authenticator = pytalloc_reference_ex(&netr_Authenticator_Type, r->out.return_authenticator, r->out.return_authenticator);
	result = py_return_authenticator;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_DatabaseDeltas_args_in(PyObject *args, PyObject *kwargs, struct netr_DatabaseDeltas *r)
{
	PyObject *py_logon_server;
	PyObject *py_computername;
	PyObject *py_credential;
	PyObject *py_return_authenticator;
	PyObject *py_database_id;
	PyObject *py_sequence_num;
	PyObject *py_preferredmaximumlength;
	const char *kwnames[] = {
		"logon_server", "computername", "credential", "return_authenticator", "database_id", "sequence_num", "preferredmaximumlength", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOO:netr_DatabaseDeltas", discard_const_p(char *, kwnames), &py_logon_server, &py_computername, &py_credential, &py_return_authenticator, &py_database_id, &py_sequence_num, &py_preferredmaximumlength)) {
		return false;
	}

	r->in.logon_server = talloc_ptrtype(r, r->in.logon_server);
	if (PyUnicode_Check(py_logon_server)) {
		r->in.logon_server = PyString_AS_STRING(PyUnicode_AsEncodedString(py_logon_server, "utf-8", "ignore"));
	} else if (PyString_Check(py_logon_server)) {
		r->in.logon_server = PyString_AS_STRING(py_logon_server);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_logon_server)->tp_name);
		return false;
	}
	r->in.computername = talloc_ptrtype(r, r->in.computername);
	if (PyUnicode_Check(py_computername)) {
		r->in.computername = PyString_AS_STRING(PyUnicode_AsEncodedString(py_computername, "utf-8", "ignore"));
	} else if (PyString_Check(py_computername)) {
		r->in.computername = PyString_AS_STRING(py_computername);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_computername)->tp_name);
		return false;
	}
	r->in.credential = talloc_ptrtype(r, r->in.credential);
	PY_CHECK_TYPE(&netr_Authenticator_Type, py_credential, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_credential)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.credential = (struct netr_Authenticator *)pytalloc_get_ptr(py_credential);
	r->in.return_authenticator = talloc_ptrtype(r, r->in.return_authenticator);
	PY_CHECK_TYPE(&netr_Authenticator_Type, py_return_authenticator, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_return_authenticator)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.return_authenticator = (struct netr_Authenticator *)pytalloc_get_ptr(py_return_authenticator);
	if (PyLong_Check(py_database_id)) {
		r->in.database_id = PyLong_AsLongLong(py_database_id);
	} else if (PyInt_Check(py_database_id)) {
		r->in.database_id = PyInt_AsLong(py_database_id);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	r->in.sequence_num = talloc_ptrtype(r, r->in.sequence_num);
	if (PyLong_Check(py_sequence_num)) {
		*r->in.sequence_num = PyLong_AsLongLong(py_sequence_num);
	} else if (PyInt_Check(py_sequence_num)) {
		*r->in.sequence_num = PyInt_AsLong(py_sequence_num);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	PY_CHECK_TYPE(&PyInt_Type, py_preferredmaximumlength, return false;);
	r->in.preferredmaximumlength = PyInt_AsLong(py_preferredmaximumlength);
	return true;
}

static PyObject *unpack_py_netr_DatabaseDeltas_args_out(struct netr_DatabaseDeltas *r)
{
	PyObject *result;
	PyObject *py_return_authenticator;
	PyObject *py_sequence_num;
	PyObject *py_delta_enum_array;
	result = PyTuple_New(3);
	py_return_authenticator = pytalloc_reference_ex(&netr_Authenticator_Type, r->out.return_authenticator, r->out.return_authenticator);
	PyTuple_SetItem(result, 0, py_return_authenticator);
	py_sequence_num = PyLong_FromLongLong(*r->out.sequence_num);
	PyTuple_SetItem(result, 1, py_sequence_num);
	if (*r->out.delta_enum_array == NULL) {
		py_delta_enum_array = Py_None;
		Py_INCREF(py_delta_enum_array);
	} else {
		py_delta_enum_array = pytalloc_reference_ex(&netr_DELTA_ENUM_ARRAY_Type, *r->out.delta_enum_array, *r->out.delta_enum_array);
	}
	PyTuple_SetItem(result, 2, py_delta_enum_array);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_DatabaseSync_args_in(PyObject *args, PyObject *kwargs, struct netr_DatabaseSync *r)
{
	PyObject *py_logon_server;
	PyObject *py_computername;
	PyObject *py_credential;
	PyObject *py_return_authenticator;
	PyObject *py_database_id;
	PyObject *py_sync_context;
	PyObject *py_preferredmaximumlength;
	const char *kwnames[] = {
		"logon_server", "computername", "credential", "return_authenticator", "database_id", "sync_context", "preferredmaximumlength", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOO:netr_DatabaseSync", discard_const_p(char *, kwnames), &py_logon_server, &py_computername, &py_credential, &py_return_authenticator, &py_database_id, &py_sync_context, &py_preferredmaximumlength)) {
		return false;
	}

	r->in.logon_server = talloc_ptrtype(r, r->in.logon_server);
	if (PyUnicode_Check(py_logon_server)) {
		r->in.logon_server = PyString_AS_STRING(PyUnicode_AsEncodedString(py_logon_server, "utf-8", "ignore"));
	} else if (PyString_Check(py_logon_server)) {
		r->in.logon_server = PyString_AS_STRING(py_logon_server);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_logon_server)->tp_name);
		return false;
	}
	r->in.computername = talloc_ptrtype(r, r->in.computername);
	if (PyUnicode_Check(py_computername)) {
		r->in.computername = PyString_AS_STRING(PyUnicode_AsEncodedString(py_computername, "utf-8", "ignore"));
	} else if (PyString_Check(py_computername)) {
		r->in.computername = PyString_AS_STRING(py_computername);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_computername)->tp_name);
		return false;
	}
	r->in.credential = talloc_ptrtype(r, r->in.credential);
	PY_CHECK_TYPE(&netr_Authenticator_Type, py_credential, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_credential)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.credential = (struct netr_Authenticator *)pytalloc_get_ptr(py_credential);
	r->in.return_authenticator = talloc_ptrtype(r, r->in.return_authenticator);
	PY_CHECK_TYPE(&netr_Authenticator_Type, py_return_authenticator, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_return_authenticator)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.return_authenticator = (struct netr_Authenticator *)pytalloc_get_ptr(py_return_authenticator);
	if (PyLong_Check(py_database_id)) {
		r->in.database_id = PyLong_AsLongLong(py_database_id);
	} else if (PyInt_Check(py_database_id)) {
		r->in.database_id = PyInt_AsLong(py_database_id);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	r->in.sync_context = talloc_ptrtype(r, r->in.sync_context);
	PY_CHECK_TYPE(&PyInt_Type, py_sync_context, return false;);
	*r->in.sync_context = PyInt_AsLong(py_sync_context);
	PY_CHECK_TYPE(&PyInt_Type, py_preferredmaximumlength, return false;);
	r->in.preferredmaximumlength = PyInt_AsLong(py_preferredmaximumlength);
	return true;
}

static PyObject *unpack_py_netr_DatabaseSync_args_out(struct netr_DatabaseSync *r)
{
	PyObject *result;
	PyObject *py_return_authenticator;
	PyObject *py_sync_context;
	PyObject *py_delta_enum_array;
	result = PyTuple_New(3);
	py_return_authenticator = pytalloc_reference_ex(&netr_Authenticator_Type, r->out.return_authenticator, r->out.return_authenticator);
	PyTuple_SetItem(result, 0, py_return_authenticator);
	py_sync_context = PyInt_FromLong(*r->out.sync_context);
	PyTuple_SetItem(result, 1, py_sync_context);
	if (*r->out.delta_enum_array == NULL) {
		py_delta_enum_array = Py_None;
		Py_INCREF(py_delta_enum_array);
	} else {
		py_delta_enum_array = pytalloc_reference_ex(&netr_DELTA_ENUM_ARRAY_Type, *r->out.delta_enum_array, *r->out.delta_enum_array);
	}
	PyTuple_SetItem(result, 2, py_delta_enum_array);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_AccountDeltas_args_in(PyObject *args, PyObject *kwargs, struct netr_AccountDeltas *r)
{
	PyObject *py_logon_server;
	PyObject *py_computername;
	PyObject *py_credential;
	PyObject *py_return_authenticator;
	PyObject *py_uas;
	PyObject *py_count;
	PyObject *py_level;
	PyObject *py_buffersize;
	const char *kwnames[] = {
		"logon_server", "computername", "credential", "return_authenticator", "uas", "count", "level", "buffersize", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOOO:netr_AccountDeltas", discard_const_p(char *, kwnames), &py_logon_server, &py_computername, &py_credential, &py_return_authenticator, &py_uas, &py_count, &py_level, &py_buffersize)) {
		return false;
	}

	if (py_logon_server == Py_None) {
		r->in.logon_server = NULL;
	} else {
		r->in.logon_server = NULL;
		if (PyUnicode_Check(py_logon_server)) {
			r->in.logon_server = PyString_AS_STRING(PyUnicode_AsEncodedString(py_logon_server, "utf-8", "ignore"));
		} else if (PyString_Check(py_logon_server)) {
			r->in.logon_server = PyString_AS_STRING(py_logon_server);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_logon_server)->tp_name);
			return false;
		}
	}
	r->in.computername = talloc_ptrtype(r, r->in.computername);
	if (PyUnicode_Check(py_computername)) {
		r->in.computername = PyString_AS_STRING(PyUnicode_AsEncodedString(py_computername, "utf-8", "ignore"));
	} else if (PyString_Check(py_computername)) {
		r->in.computername = PyString_AS_STRING(py_computername);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_computername)->tp_name);
		return false;
	}
	PY_CHECK_TYPE(&netr_Authenticator_Type, py_credential, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_credential)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.credential = *(struct netr_Authenticator *)pytalloc_get_ptr(py_credential);
	r->in.return_authenticator = talloc_ptrtype(r, r->in.return_authenticator);
	PY_CHECK_TYPE(&netr_Authenticator_Type, py_return_authenticator, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_return_authenticator)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.return_authenticator = (struct netr_Authenticator *)pytalloc_get_ptr(py_return_authenticator);
	PY_CHECK_TYPE(&netr_UAS_INFO_0_Type, py_uas, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_uas)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.uas = *(struct netr_UAS_INFO_0 *)pytalloc_get_ptr(py_uas);
	PY_CHECK_TYPE(&PyInt_Type, py_count, return false;);
	r->in.count = PyInt_AsLong(py_count);
	PY_CHECK_TYPE(&PyInt_Type, py_level, return false;);
	r->in.level = PyInt_AsLong(py_level);
	PY_CHECK_TYPE(&PyInt_Type, py_buffersize, return false;);
	r->in.buffersize = PyInt_AsLong(py_buffersize);
	return true;
}

static PyObject *unpack_py_netr_AccountDeltas_args_out(struct netr_AccountDeltas *r)
{
	PyObject *result;
	PyObject *py_return_authenticator;
	PyObject *py_buffer;
	PyObject *py_count_returned;
	PyObject *py_total_entries;
	PyObject *py_recordid;
	result = PyTuple_New(5);
	py_return_authenticator = pytalloc_reference_ex(&netr_Authenticator_Type, r->out.return_authenticator, r->out.return_authenticator);
	PyTuple_SetItem(result, 0, py_return_authenticator);
	py_buffer = pytalloc_reference_ex(&netr_AccountBuffer_Type, r->out.buffer, r->out.buffer);
	PyTuple_SetItem(result, 1, py_buffer);
	py_count_returned = PyInt_FromLong(*r->out.count_returned);
	PyTuple_SetItem(result, 2, py_count_returned);
	py_total_entries = PyInt_FromLong(*r->out.total_entries);
	PyTuple_SetItem(result, 3, py_total_entries);
	py_recordid = pytalloc_reference_ex(&netr_UAS_INFO_0_Type, r->out.recordid, r->out.recordid);
	PyTuple_SetItem(result, 4, py_recordid);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_AccountSync_args_in(PyObject *args, PyObject *kwargs, struct netr_AccountSync *r)
{
	PyObject *py_logon_server;
	PyObject *py_computername;
	PyObject *py_credential;
	PyObject *py_return_authenticator;
	PyObject *py_reference;
	PyObject *py_level;
	PyObject *py_buffersize;
	PyObject *py_recordid;
	const char *kwnames[] = {
		"logon_server", "computername", "credential", "return_authenticator", "reference", "level", "buffersize", "recordid", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOOO:netr_AccountSync", discard_const_p(char *, kwnames), &py_logon_server, &py_computername, &py_credential, &py_return_authenticator, &py_reference, &py_level, &py_buffersize, &py_recordid)) {
		return false;
	}

	if (py_logon_server == Py_None) {
		r->in.logon_server = NULL;
	} else {
		r->in.logon_server = NULL;
		if (PyUnicode_Check(py_logon_server)) {
			r->in.logon_server = PyString_AS_STRING(PyUnicode_AsEncodedString(py_logon_server, "utf-8", "ignore"));
		} else if (PyString_Check(py_logon_server)) {
			r->in.logon_server = PyString_AS_STRING(py_logon_server);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_logon_server)->tp_name);
			return false;
		}
	}
	r->in.computername = talloc_ptrtype(r, r->in.computername);
	if (PyUnicode_Check(py_computername)) {
		r->in.computername = PyString_AS_STRING(PyUnicode_AsEncodedString(py_computername, "utf-8", "ignore"));
	} else if (PyString_Check(py_computername)) {
		r->in.computername = PyString_AS_STRING(py_computername);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_computername)->tp_name);
		return false;
	}
	PY_CHECK_TYPE(&netr_Authenticator_Type, py_credential, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_credential)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.credential = *(struct netr_Authenticator *)pytalloc_get_ptr(py_credential);
	r->in.return_authenticator = talloc_ptrtype(r, r->in.return_authenticator);
	PY_CHECK_TYPE(&netr_Authenticator_Type, py_return_authenticator, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_return_authenticator)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.return_authenticator = (struct netr_Authenticator *)pytalloc_get_ptr(py_return_authenticator);
	PY_CHECK_TYPE(&PyInt_Type, py_reference, return false;);
	r->in.reference = PyInt_AsLong(py_reference);
	PY_CHECK_TYPE(&PyInt_Type, py_level, return false;);
	r->in.level = PyInt_AsLong(py_level);
	PY_CHECK_TYPE(&PyInt_Type, py_buffersize, return false;);
	r->in.buffersize = PyInt_AsLong(py_buffersize);
	r->in.recordid = talloc_ptrtype(r, r->in.recordid);
	PY_CHECK_TYPE(&netr_UAS_INFO_0_Type, py_recordid, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_recordid)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.recordid = (struct netr_UAS_INFO_0 *)pytalloc_get_ptr(py_recordid);
	return true;
}

static PyObject *unpack_py_netr_AccountSync_args_out(struct netr_AccountSync *r)
{
	PyObject *result;
	PyObject *py_return_authenticator;
	PyObject *py_buffer;
	PyObject *py_count_returned;
	PyObject *py_total_entries;
	PyObject *py_next_reference;
	PyObject *py_recordid;
	result = PyTuple_New(6);
	py_return_authenticator = pytalloc_reference_ex(&netr_Authenticator_Type, r->out.return_authenticator, r->out.return_authenticator);
	PyTuple_SetItem(result, 0, py_return_authenticator);
	py_buffer = pytalloc_reference_ex(&netr_AccountBuffer_Type, r->out.buffer, r->out.buffer);
	PyTuple_SetItem(result, 1, py_buffer);
	py_count_returned = PyInt_FromLong(*r->out.count_returned);
	PyTuple_SetItem(result, 2, py_count_returned);
	py_total_entries = PyInt_FromLong(*r->out.total_entries);
	PyTuple_SetItem(result, 3, py_total_entries);
	py_next_reference = PyInt_FromLong(*r->out.next_reference);
	PyTuple_SetItem(result, 4, py_next_reference);
	py_recordid = pytalloc_reference_ex(&netr_UAS_INFO_0_Type, r->out.recordid, r->out.recordid);
	PyTuple_SetItem(result, 5, py_recordid);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_GetDcName_args_in(PyObject *args, PyObject *kwargs, struct netr_GetDcName *r)
{
	PyObject *py_logon_server;
	PyObject *py_domainname;
	const char *kwnames[] = {
		"logon_server", "domainname", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:netr_GetDcName", discard_const_p(char *, kwnames), &py_logon_server, &py_domainname)) {
		return false;
	}

	r->in.logon_server = talloc_ptrtype(r, r->in.logon_server);
	if (PyUnicode_Check(py_logon_server)) {
		r->in.logon_server = PyString_AS_STRING(PyUnicode_AsEncodedString(py_logon_server, "utf-8", "ignore"));
	} else if (PyString_Check(py_logon_server)) {
		r->in.logon_server = PyString_AS_STRING(py_logon_server);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_logon_server)->tp_name);
		return false;
	}
	if (py_domainname == Py_None) {
		r->in.domainname = NULL;
	} else {
		r->in.domainname = NULL;
		if (PyUnicode_Check(py_domainname)) {
			r->in.domainname = PyString_AS_STRING(PyUnicode_AsEncodedString(py_domainname, "utf-8", "ignore"));
		} else if (PyString_Check(py_domainname)) {
			r->in.domainname = PyString_AS_STRING(py_domainname);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_domainname)->tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_netr_GetDcName_args_out(struct netr_GetDcName *r)
{
	PyObject *result;
	PyObject *py_dcname;
	if (*r->out.dcname == NULL) {
		py_dcname = Py_None;
		Py_INCREF(py_dcname);
	} else {
		if (*r->out.dcname == NULL) {
			py_dcname = Py_None;
			Py_INCREF(py_dcname);
		} else {
			py_dcname = PyUnicode_Decode(*r->out.dcname, strlen(*r->out.dcname), "utf-8", "ignore");
		}
	}
	result = py_dcname;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_LogonControl_args_in(PyObject *args, PyObject *kwargs, struct netr_LogonControl *r)
{
	PyObject *py_logon_server;
	PyObject *py_function_code;
	PyObject *py_level;
	const char *kwnames[] = {
		"logon_server", "function_code", "level", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:netr_LogonControl", discard_const_p(char *, kwnames), &py_logon_server, &py_function_code, &py_level)) {
		return false;
	}

	if (py_logon_server == Py_None) {
		r->in.logon_server = NULL;
	} else {
		r->in.logon_server = NULL;
		if (PyUnicode_Check(py_logon_server)) {
			r->in.logon_server = PyString_AS_STRING(PyUnicode_AsEncodedString(py_logon_server, "utf-8", "ignore"));
		} else if (PyString_Check(py_logon_server)) {
			r->in.logon_server = PyString_AS_STRING(py_logon_server);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_logon_server)->tp_name);
			return false;
		}
	}
	if (PyLong_Check(py_function_code)) {
		r->in.function_code = PyLong_AsLongLong(py_function_code);
	} else if (PyInt_Check(py_function_code)) {
		r->in.function_code = PyInt_AsLong(py_function_code);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	PY_CHECK_TYPE(&PyInt_Type, py_level, return false;);
	r->in.level = PyInt_AsLong(py_level);
	return true;
}

static PyObject *unpack_py_netr_LogonControl_args_out(struct netr_LogonControl *r)
{
	PyObject *result;
	PyObject *py_query;
	py_query = py_import_netr_CONTROL_QUERY_INFORMATION(r->out.query, r->in.level, r->out.query);
	if (py_query == NULL) {
		return NULL;
	}
	result = py_query;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_GetAnyDCName_args_in(PyObject *args, PyObject *kwargs, struct netr_GetAnyDCName *r)
{
	PyObject *py_logon_server;
	PyObject *py_domainname;
	const char *kwnames[] = {
		"logon_server", "domainname", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:netr_GetAnyDCName", discard_const_p(char *, kwnames), &py_logon_server, &py_domainname)) {
		return false;
	}

	if (py_logon_server == Py_None) {
		r->in.logon_server = NULL;
	} else {
		r->in.logon_server = NULL;
		if (PyUnicode_Check(py_logon_server)) {
			r->in.logon_server = PyString_AS_STRING(PyUnicode_AsEncodedString(py_logon_server, "utf-8", "ignore"));
		} else if (PyString_Check(py_logon_server)) {
			r->in.logon_server = PyString_AS_STRING(py_logon_server);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_logon_server)->tp_name);
			return false;
		}
	}
	if (py_domainname == Py_None) {
		r->in.domainname = NULL;
	} else {
		r->in.domainname = NULL;
		if (PyUnicode_Check(py_domainname)) {
			r->in.domainname = PyString_AS_STRING(PyUnicode_AsEncodedString(py_domainname, "utf-8", "ignore"));
		} else if (PyString_Check(py_domainname)) {
			r->in.domainname = PyString_AS_STRING(py_domainname);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_domainname)->tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_netr_GetAnyDCName_args_out(struct netr_GetAnyDCName *r)
{
	PyObject *result;
	PyObject *py_dcname;
	if (*r->out.dcname == NULL) {
		py_dcname = Py_None;
		Py_INCREF(py_dcname);
	} else {
		if (*r->out.dcname == NULL) {
			py_dcname = Py_None;
			Py_INCREF(py_dcname);
		} else {
			py_dcname = PyUnicode_Decode(*r->out.dcname, strlen(*r->out.dcname), "utf-8", "ignore");
		}
	}
	result = py_dcname;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_LogonControl2_args_in(PyObject *args, PyObject *kwargs, struct netr_LogonControl2 *r)
{
	PyObject *py_logon_server;
	PyObject *py_function_code;
	PyObject *py_level;
	PyObject *py_data;
	const char *kwnames[] = {
		"logon_server", "function_code", "level", "data", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:netr_LogonControl2", discard_const_p(char *, kwnames), &py_logon_server, &py_function_code, &py_level, &py_data)) {
		return false;
	}

	if (py_logon_server == Py_None) {
		r->in.logon_server = NULL;
	} else {
		r->in.logon_server = NULL;
		if (PyUnicode_Check(py_logon_server)) {
			r->in.logon_server = PyString_AS_STRING(PyUnicode_AsEncodedString(py_logon_server, "utf-8", "ignore"));
		} else if (PyString_Check(py_logon_server)) {
			r->in.logon_server = PyString_AS_STRING(py_logon_server);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_logon_server)->tp_name);
			return false;
		}
	}
	if (PyLong_Check(py_function_code)) {
		r->in.function_code = PyLong_AsLongLong(py_function_code);
	} else if (PyInt_Check(py_function_code)) {
		r->in.function_code = PyInt_AsLong(py_function_code);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	PY_CHECK_TYPE(&PyInt_Type, py_level, return false;);
	r->in.level = PyInt_AsLong(py_level);
	r->in.data = talloc_ptrtype(r, r->in.data);
	{
		union netr_CONTROL_DATA_INFORMATION *data_switch_1;
		data_switch_1 = py_export_netr_CONTROL_DATA_INFORMATION(r, r->in.function_code, py_data);
		if (data_switch_1 == NULL) {
			return false;
		}
		r->in.data = data_switch_1;
	}
	return true;
}

static PyObject *unpack_py_netr_LogonControl2_args_out(struct netr_LogonControl2 *r)
{
	PyObject *result;
	PyObject *py_query;
	py_query = py_import_netr_CONTROL_QUERY_INFORMATION(r->out.query, r->in.level, r->out.query);
	if (py_query == NULL) {
		return NULL;
	}
	result = py_query;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_ServerAuthenticate2_args_in(PyObject *args, PyObject *kwargs, struct netr_ServerAuthenticate2 *r)
{
	PyObject *py_server_name;
	PyObject *py_account_name;
	PyObject *py_secure_channel_type;
	PyObject *py_computer_name;
	PyObject *py_credentials;
	PyObject *py_negotiate_flags;
	const char *kwnames[] = {
		"server_name", "account_name", "secure_channel_type", "computer_name", "credentials", "negotiate_flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOO:netr_ServerAuthenticate2", discard_const_p(char *, kwnames), &py_server_name, &py_account_name, &py_secure_channel_type, &py_computer_name, &py_credentials, &py_negotiate_flags)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		if (PyUnicode_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
		} else if (PyString_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(py_server_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
			return false;
		}
	}
	r->in.account_name = talloc_ptrtype(r, r->in.account_name);
	if (PyUnicode_Check(py_account_name)) {
		r->in.account_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_account_name, "utf-8", "ignore"));
	} else if (PyString_Check(py_account_name)) {
		r->in.account_name = PyString_AS_STRING(py_account_name);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_account_name)->tp_name);
		return false;
	}
	if (PyLong_Check(py_secure_channel_type)) {
		r->in.secure_channel_type = PyLong_AsLongLong(py_secure_channel_type);
	} else if (PyInt_Check(py_secure_channel_type)) {
		r->in.secure_channel_type = PyInt_AsLong(py_secure_channel_type);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	r->in.computer_name = talloc_ptrtype(r, r->in.computer_name);
	if (PyUnicode_Check(py_computer_name)) {
		r->in.computer_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_computer_name, "utf-8", "ignore"));
	} else if (PyString_Check(py_computer_name)) {
		r->in.computer_name = PyString_AS_STRING(py_computer_name);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_computer_name)->tp_name);
		return false;
	}
	r->in.credentials = talloc_ptrtype(r, r->in.credentials);
	PY_CHECK_TYPE(&netr_Credential_Type, py_credentials, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_credentials)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.credentials = (struct netr_Credential *)pytalloc_get_ptr(py_credentials);
	r->in.negotiate_flags = talloc_ptrtype(r, r->in.negotiate_flags);
	if (PyLong_Check(py_negotiate_flags)) {
		*r->in.negotiate_flags = PyLong_AsLongLong(py_negotiate_flags);
	} else if (PyInt_Check(py_negotiate_flags)) {
		*r->in.negotiate_flags = PyInt_AsLong(py_negotiate_flags);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_netr_ServerAuthenticate2_args_out(struct netr_ServerAuthenticate2 *r)
{
	PyObject *result;
	PyObject *py_return_credentials;
	PyObject *py_negotiate_flags;
	result = PyTuple_New(2);
	py_return_credentials = pytalloc_reference_ex(&netr_Credential_Type, r->out.return_credentials, r->out.return_credentials);
	PyTuple_SetItem(result, 0, py_return_credentials);
	py_negotiate_flags = PyInt_FromLong(*r->out.negotiate_flags);
	PyTuple_SetItem(result, 1, py_negotiate_flags);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_DatabaseSync2_args_in(PyObject *args, PyObject *kwargs, struct netr_DatabaseSync2 *r)
{
	PyObject *py_logon_server;
	PyObject *py_computername;
	PyObject *py_credential;
	PyObject *py_return_authenticator;
	PyObject *py_database_id;
	PyObject *py_restart_state;
	PyObject *py_sync_context;
	PyObject *py_preferredmaximumlength;
	const char *kwnames[] = {
		"logon_server", "computername", "credential", "return_authenticator", "database_id", "restart_state", "sync_context", "preferredmaximumlength", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOOO:netr_DatabaseSync2", discard_const_p(char *, kwnames), &py_logon_server, &py_computername, &py_credential, &py_return_authenticator, &py_database_id, &py_restart_state, &py_sync_context, &py_preferredmaximumlength)) {
		return false;
	}

	r->in.logon_server = talloc_ptrtype(r, r->in.logon_server);
	if (PyUnicode_Check(py_logon_server)) {
		r->in.logon_server = PyString_AS_STRING(PyUnicode_AsEncodedString(py_logon_server, "utf-8", "ignore"));
	} else if (PyString_Check(py_logon_server)) {
		r->in.logon_server = PyString_AS_STRING(py_logon_server);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_logon_server)->tp_name);
		return false;
	}
	r->in.computername = talloc_ptrtype(r, r->in.computername);
	if (PyUnicode_Check(py_computername)) {
		r->in.computername = PyString_AS_STRING(PyUnicode_AsEncodedString(py_computername, "utf-8", "ignore"));
	} else if (PyString_Check(py_computername)) {
		r->in.computername = PyString_AS_STRING(py_computername);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_computername)->tp_name);
		return false;
	}
	r->in.credential = talloc_ptrtype(r, r->in.credential);
	PY_CHECK_TYPE(&netr_Authenticator_Type, py_credential, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_credential)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.credential = (struct netr_Authenticator *)pytalloc_get_ptr(py_credential);
	r->in.return_authenticator = talloc_ptrtype(r, r->in.return_authenticator);
	PY_CHECK_TYPE(&netr_Authenticator_Type, py_return_authenticator, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_return_authenticator)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.return_authenticator = (struct netr_Authenticator *)pytalloc_get_ptr(py_return_authenticator);
	if (PyLong_Check(py_database_id)) {
		r->in.database_id = PyLong_AsLongLong(py_database_id);
	} else if (PyInt_Check(py_database_id)) {
		r->in.database_id = PyInt_AsLong(py_database_id);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	if (PyLong_Check(py_restart_state)) {
		r->in.restart_state = PyLong_AsLongLong(py_restart_state);
	} else if (PyInt_Check(py_restart_state)) {
		r->in.restart_state = PyInt_AsLong(py_restart_state);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	r->in.sync_context = talloc_ptrtype(r, r->in.sync_context);
	PY_CHECK_TYPE(&PyInt_Type, py_sync_context, return false;);
	*r->in.sync_context = PyInt_AsLong(py_sync_context);
	PY_CHECK_TYPE(&PyInt_Type, py_preferredmaximumlength, return false;);
	r->in.preferredmaximumlength = PyInt_AsLong(py_preferredmaximumlength);
	return true;
}

static PyObject *unpack_py_netr_DatabaseSync2_args_out(struct netr_DatabaseSync2 *r)
{
	PyObject *result;
	PyObject *py_return_authenticator;
	PyObject *py_sync_context;
	PyObject *py_delta_enum_array;
	result = PyTuple_New(3);
	py_return_authenticator = pytalloc_reference_ex(&netr_Authenticator_Type, r->out.return_authenticator, r->out.return_authenticator);
	PyTuple_SetItem(result, 0, py_return_authenticator);
	py_sync_context = PyInt_FromLong(*r->out.sync_context);
	PyTuple_SetItem(result, 1, py_sync_context);
	if (*r->out.delta_enum_array == NULL) {
		py_delta_enum_array = Py_None;
		Py_INCREF(py_delta_enum_array);
	} else {
		py_delta_enum_array = pytalloc_reference_ex(&netr_DELTA_ENUM_ARRAY_Type, *r->out.delta_enum_array, *r->out.delta_enum_array);
	}
	PyTuple_SetItem(result, 2, py_delta_enum_array);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_DatabaseRedo_args_in(PyObject *args, PyObject *kwargs, struct netr_DatabaseRedo *r)
{
	PyObject *py_logon_server;
	PyObject *py_computername;
	PyObject *py_credential;
	PyObject *py_return_authenticator;
	PyObject *py_change_log_entry;
	PyObject *py_change_log_entry_size;
	const char *kwnames[] = {
		"logon_server", "computername", "credential", "return_authenticator", "change_log_entry", "change_log_entry_size", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOO:netr_DatabaseRedo", discard_const_p(char *, kwnames), &py_logon_server, &py_computername, &py_credential, &py_return_authenticator, &py_change_log_entry, &py_change_log_entry_size)) {
		return false;
	}

	r->in.logon_server = talloc_ptrtype(r, r->in.logon_server);
	if (PyUnicode_Check(py_logon_server)) {
		r->in.logon_server = PyString_AS_STRING(PyUnicode_AsEncodedString(py_logon_server, "utf-8", "ignore"));
	} else if (PyString_Check(py_logon_server)) {
		r->in.logon_server = PyString_AS_STRING(py_logon_server);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_logon_server)->tp_name);
		return false;
	}
	r->in.computername = talloc_ptrtype(r, r->in.computername);
	if (PyUnicode_Check(py_computername)) {
		r->in.computername = PyString_AS_STRING(PyUnicode_AsEncodedString(py_computername, "utf-8", "ignore"));
	} else if (PyString_Check(py_computername)) {
		r->in.computername = PyString_AS_STRING(py_computername);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_computername)->tp_name);
		return false;
	}
	r->in.credential = talloc_ptrtype(r, r->in.credential);
	PY_CHECK_TYPE(&netr_Authenticator_Type, py_credential, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_credential)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.credential = (struct netr_Authenticator *)pytalloc_get_ptr(py_credential);
	r->in.return_authenticator = talloc_ptrtype(r, r->in.return_authenticator);
	PY_CHECK_TYPE(&netr_Authenticator_Type, py_return_authenticator, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_return_authenticator)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.return_authenticator = (struct netr_Authenticator *)pytalloc_get_ptr(py_return_authenticator);
	PY_CHECK_TYPE(&netr_ChangeLogEntry_Type, py_change_log_entry, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_change_log_entry)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.change_log_entry = *(struct netr_ChangeLogEntry *)pytalloc_get_ptr(py_change_log_entry);
	PY_CHECK_TYPE(&PyInt_Type, py_change_log_entry_size, return false;);
	r->in.change_log_entry_size = PyInt_AsLong(py_change_log_entry_size);
	return true;
}

static PyObject *unpack_py_netr_DatabaseRedo_args_out(struct netr_DatabaseRedo *r)
{
	PyObject *result;
	PyObject *py_return_authenticator;
	PyObject *py_delta_enum_array;
	result = PyTuple_New(2);
	py_return_authenticator = pytalloc_reference_ex(&netr_Authenticator_Type, r->out.return_authenticator, r->out.return_authenticator);
	PyTuple_SetItem(result, 0, py_return_authenticator);
	if (*r->out.delta_enum_array == NULL) {
		py_delta_enum_array = Py_None;
		Py_INCREF(py_delta_enum_array);
	} else {
		py_delta_enum_array = pytalloc_reference_ex(&netr_DELTA_ENUM_ARRAY_Type, *r->out.delta_enum_array, *r->out.delta_enum_array);
	}
	PyTuple_SetItem(result, 1, py_delta_enum_array);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_LogonControl2Ex_args_in(PyObject *args, PyObject *kwargs, struct netr_LogonControl2Ex *r)
{
	PyObject *py_logon_server;
	PyObject *py_function_code;
	PyObject *py_level;
	PyObject *py_data;
	const char *kwnames[] = {
		"logon_server", "function_code", "level", "data", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:netr_LogonControl2Ex", discard_const_p(char *, kwnames), &py_logon_server, &py_function_code, &py_level, &py_data)) {
		return false;
	}

	if (py_logon_server == Py_None) {
		r->in.logon_server = NULL;
	} else {
		r->in.logon_server = NULL;
		if (PyUnicode_Check(py_logon_server)) {
			r->in.logon_server = PyString_AS_STRING(PyUnicode_AsEncodedString(py_logon_server, "utf-8", "ignore"));
		} else if (PyString_Check(py_logon_server)) {
			r->in.logon_server = PyString_AS_STRING(py_logon_server);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_logon_server)->tp_name);
			return false;
		}
	}
	if (PyLong_Check(py_function_code)) {
		r->in.function_code = PyLong_AsLongLong(py_function_code);
	} else if (PyInt_Check(py_function_code)) {
		r->in.function_code = PyInt_AsLong(py_function_code);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	PY_CHECK_TYPE(&PyInt_Type, py_level, return false;);
	r->in.level = PyInt_AsLong(py_level);
	r->in.data = talloc_ptrtype(r, r->in.data);
	{
		union netr_CONTROL_DATA_INFORMATION *data_switch_1;
		data_switch_1 = py_export_netr_CONTROL_DATA_INFORMATION(r, r->in.function_code, py_data);
		if (data_switch_1 == NULL) {
			return false;
		}
		r->in.data = data_switch_1;
	}
	return true;
}

static PyObject *unpack_py_netr_LogonControl2Ex_args_out(struct netr_LogonControl2Ex *r)
{
	PyObject *result;
	PyObject *py_query;
	py_query = py_import_netr_CONTROL_QUERY_INFORMATION(r->out.query, r->in.level, r->out.query);
	if (py_query == NULL) {
		return NULL;
	}
	result = py_query;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_NetrEnumerateTrustedDomains_args_in(PyObject *args, PyObject *kwargs, struct netr_NetrEnumerateTrustedDomains *r)
{
	PyObject *py_server_name;
	const char *kwnames[] = {
		"server_name", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:netr_NetrEnumerateTrustedDomains", discard_const_p(char *, kwnames), &py_server_name)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		if (PyUnicode_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
		} else if (PyString_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(py_server_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_netr_NetrEnumerateTrustedDomains_args_out(struct netr_NetrEnumerateTrustedDomains *r)
{
	PyObject *result;
	PyObject *py_trusted_domains_blob;
	py_trusted_domains_blob = pytalloc_reference_ex(&netr_Blob_Type, r->out.trusted_domains_blob, r->out.trusted_domains_blob);
	result = py_trusted_domains_blob;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_DsRGetDCName_args_in(PyObject *args, PyObject *kwargs, struct netr_DsRGetDCName *r)
{
	PyObject *py_server_unc;
	PyObject *py_domain_name;
	PyObject *py_domain_guid;
	PyObject *py_site_guid;
	PyObject *py_flags;
	const char *kwnames[] = {
		"server_unc", "domain_name", "domain_guid", "site_guid", "flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:netr_DsRGetDCName", discard_const_p(char *, kwnames), &py_server_unc, &py_domain_name, &py_domain_guid, &py_site_guid, &py_flags)) {
		return false;
	}

	if (py_server_unc == Py_None) {
		r->in.server_unc = NULL;
	} else {
		r->in.server_unc = NULL;
		if (PyUnicode_Check(py_server_unc)) {
			r->in.server_unc = PyString_AS_STRING(PyUnicode_AsEncodedString(py_server_unc, "utf-8", "ignore"));
		} else if (PyString_Check(py_server_unc)) {
			r->in.server_unc = PyString_AS_STRING(py_server_unc);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_unc)->tp_name);
			return false;
		}
	}
	if (py_domain_name == Py_None) {
		r->in.domain_name = NULL;
	} else {
		r->in.domain_name = NULL;
		if (PyUnicode_Check(py_domain_name)) {
			r->in.domain_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_domain_name, "utf-8", "ignore"));
		} else if (PyString_Check(py_domain_name)) {
			r->in.domain_name = PyString_AS_STRING(py_domain_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_domain_name)->tp_name);
			return false;
		}
	}
	if (py_domain_guid == Py_None) {
		r->in.domain_guid = NULL;
	} else {
		r->in.domain_guid = NULL;
		PY_CHECK_TYPE(GUID_Type, py_domain_guid, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_domain_guid)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.domain_guid = (struct GUID *)pytalloc_get_ptr(py_domain_guid);
	}
	if (py_site_guid == Py_None) {
		r->in.site_guid = NULL;
	} else {
		r->in.site_guid = NULL;
		PY_CHECK_TYPE(GUID_Type, py_site_guid, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_site_guid)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.site_guid = (struct GUID *)pytalloc_get_ptr(py_site_guid);
	}
	if (PyLong_Check(py_flags)) {
		r->in.flags = PyLong_AsLongLong(py_flags);
	} else if (PyInt_Check(py_flags)) {
		r->in.flags = PyInt_AsLong(py_flags);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_netr_DsRGetDCName_args_out(struct netr_DsRGetDCName *r)
{
	PyObject *result;
	PyObject *py_info;
	if (*r->out.info == NULL) {
		py_info = Py_None;
		Py_INCREF(py_info);
	} else {
		py_info = pytalloc_reference_ex(&netr_DsRGetDCNameInfo_Type, *r->out.info, *r->out.info);
	}
	result = py_info;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_LogonGetCapabilities_args_in(PyObject *args, PyObject *kwargs, struct netr_LogonGetCapabilities *r)
{
	PyObject *py_server_name;
	PyObject *py_computer_name;
	PyObject *py_credential;
	PyObject *py_return_authenticator;
	PyObject *py_query_level;
	const char *kwnames[] = {
		"server_name", "computer_name", "credential", "return_authenticator", "query_level", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:netr_LogonGetCapabilities", discard_const_p(char *, kwnames), &py_server_name, &py_computer_name, &py_credential, &py_return_authenticator, &py_query_level)) {
		return false;
	}

	r->in.server_name = talloc_ptrtype(r, r->in.server_name);
	if (PyUnicode_Check(py_server_name)) {
		r->in.server_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
	} else if (PyString_Check(py_server_name)) {
		r->in.server_name = PyString_AS_STRING(py_server_name);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
		return false;
	}
	if (py_computer_name == Py_None) {
		r->in.computer_name = NULL;
	} else {
		r->in.computer_name = NULL;
		if (PyUnicode_Check(py_computer_name)) {
			r->in.computer_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_computer_name, "utf-8", "ignore"));
		} else if (PyString_Check(py_computer_name)) {
			r->in.computer_name = PyString_AS_STRING(py_computer_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_computer_name)->tp_name);
			return false;
		}
	}
	r->in.credential = talloc_ptrtype(r, r->in.credential);
	PY_CHECK_TYPE(&netr_Authenticator_Type, py_credential, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_credential)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.credential = (struct netr_Authenticator *)pytalloc_get_ptr(py_credential);
	r->in.return_authenticator = talloc_ptrtype(r, r->in.return_authenticator);
	PY_CHECK_TYPE(&netr_Authenticator_Type, py_return_authenticator, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_return_authenticator)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.return_authenticator = (struct netr_Authenticator *)pytalloc_get_ptr(py_return_authenticator);
	PY_CHECK_TYPE(&PyInt_Type, py_query_level, return false;);
	r->in.query_level = PyInt_AsLong(py_query_level);
	return true;
}

static PyObject *unpack_py_netr_LogonGetCapabilities_args_out(struct netr_LogonGetCapabilities *r)
{
	PyObject *result;
	PyObject *py_return_authenticator;
	PyObject *py_capabilities;
	result = PyTuple_New(2);
	py_return_authenticator = pytalloc_reference_ex(&netr_Authenticator_Type, r->out.return_authenticator, r->out.return_authenticator);
	PyTuple_SetItem(result, 0, py_return_authenticator);
	py_capabilities = py_import_netr_Capabilities(r->out.capabilities, r->in.query_level, r->out.capabilities);
	if (py_capabilities == NULL) {
		return NULL;
	}
	PyTuple_SetItem(result, 1, py_capabilities);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_LogonGetTrustRid_args_in(PyObject *args, PyObject *kwargs, struct netr_LogonGetTrustRid *r)
{
	PyObject *py_server_name;
	PyObject *py_domain_name;
	const char *kwnames[] = {
		"server_name", "domain_name", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:netr_LogonGetTrustRid", discard_const_p(char *, kwnames), &py_server_name, &py_domain_name)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		if (PyUnicode_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
		} else if (PyString_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(py_server_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
			return false;
		}
	}
	if (py_domain_name == Py_None) {
		r->in.domain_name = NULL;
	} else {
		r->in.domain_name = NULL;
		if (PyUnicode_Check(py_domain_name)) {
			r->in.domain_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_domain_name, "utf-8", "ignore"));
		} else if (PyString_Check(py_domain_name)) {
			r->in.domain_name = PyString_AS_STRING(py_domain_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_domain_name)->tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_netr_LogonGetTrustRid_args_out(struct netr_LogonGetTrustRid *r)
{
	PyObject *result;
	PyObject *py_rid;
	py_rid = PyInt_FromLong(*r->out.rid);
	result = py_rid;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_ServerAuthenticate3_args_in(PyObject *args, PyObject *kwargs, struct netr_ServerAuthenticate3 *r)
{
	PyObject *py_server_name;
	PyObject *py_account_name;
	PyObject *py_secure_channel_type;
	PyObject *py_computer_name;
	PyObject *py_credentials;
	PyObject *py_negotiate_flags;
	const char *kwnames[] = {
		"server_name", "account_name", "secure_channel_type", "computer_name", "credentials", "negotiate_flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOO:netr_ServerAuthenticate3", discard_const_p(char *, kwnames), &py_server_name, &py_account_name, &py_secure_channel_type, &py_computer_name, &py_credentials, &py_negotiate_flags)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		if (PyUnicode_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
		} else if (PyString_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(py_server_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
			return false;
		}
	}
	r->in.account_name = talloc_ptrtype(r, r->in.account_name);
	if (PyUnicode_Check(py_account_name)) {
		r->in.account_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_account_name, "utf-8", "ignore"));
	} else if (PyString_Check(py_account_name)) {
		r->in.account_name = PyString_AS_STRING(py_account_name);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_account_name)->tp_name);
		return false;
	}
	if (PyLong_Check(py_secure_channel_type)) {
		r->in.secure_channel_type = PyLong_AsLongLong(py_secure_channel_type);
	} else if (PyInt_Check(py_secure_channel_type)) {
		r->in.secure_channel_type = PyInt_AsLong(py_secure_channel_type);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	r->in.computer_name = talloc_ptrtype(r, r->in.computer_name);
	if (PyUnicode_Check(py_computer_name)) {
		r->in.computer_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_computer_name, "utf-8", "ignore"));
	} else if (PyString_Check(py_computer_name)) {
		r->in.computer_name = PyString_AS_STRING(py_computer_name);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_computer_name)->tp_name);
		return false;
	}
	r->in.credentials = talloc_ptrtype(r, r->in.credentials);
	PY_CHECK_TYPE(&netr_Credential_Type, py_credentials, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_credentials)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.credentials = (struct netr_Credential *)pytalloc_get_ptr(py_credentials);
	r->in.negotiate_flags = talloc_ptrtype(r, r->in.negotiate_flags);
	if (PyLong_Check(py_negotiate_flags)) {
		*r->in.negotiate_flags = PyLong_AsLongLong(py_negotiate_flags);
	} else if (PyInt_Check(py_negotiate_flags)) {
		*r->in.negotiate_flags = PyInt_AsLong(py_negotiate_flags);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_netr_ServerAuthenticate3_args_out(struct netr_ServerAuthenticate3 *r)
{
	PyObject *result;
	PyObject *py_return_credentials;
	PyObject *py_negotiate_flags;
	PyObject *py_rid;
	result = PyTuple_New(3);
	py_return_credentials = pytalloc_reference_ex(&netr_Credential_Type, r->out.return_credentials, r->out.return_credentials);
	PyTuple_SetItem(result, 0, py_return_credentials);
	py_negotiate_flags = PyInt_FromLong(*r->out.negotiate_flags);
	PyTuple_SetItem(result, 1, py_negotiate_flags);
	py_rid = PyInt_FromLong(*r->out.rid);
	PyTuple_SetItem(result, 2, py_rid);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_DsRGetDCNameEx_args_in(PyObject *args, PyObject *kwargs, struct netr_DsRGetDCNameEx *r)
{
	PyObject *py_server_unc;
	PyObject *py_domain_name;
	PyObject *py_domain_guid;
	PyObject *py_site_name;
	PyObject *py_flags;
	const char *kwnames[] = {
		"server_unc", "domain_name", "domain_guid", "site_name", "flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:netr_DsRGetDCNameEx", discard_const_p(char *, kwnames), &py_server_unc, &py_domain_name, &py_domain_guid, &py_site_name, &py_flags)) {
		return false;
	}

	if (py_server_unc == Py_None) {
		r->in.server_unc = NULL;
	} else {
		r->in.server_unc = NULL;
		if (PyUnicode_Check(py_server_unc)) {
			r->in.server_unc = PyString_AS_STRING(PyUnicode_AsEncodedString(py_server_unc, "utf-8", "ignore"));
		} else if (PyString_Check(py_server_unc)) {
			r->in.server_unc = PyString_AS_STRING(py_server_unc);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_unc)->tp_name);
			return false;
		}
	}
	if (py_domain_name == Py_None) {
		r->in.domain_name = NULL;
	} else {
		r->in.domain_name = NULL;
		if (PyUnicode_Check(py_domain_name)) {
			r->in.domain_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_domain_name, "utf-8", "ignore"));
		} else if (PyString_Check(py_domain_name)) {
			r->in.domain_name = PyString_AS_STRING(py_domain_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_domain_name)->tp_name);
			return false;
		}
	}
	if (py_domain_guid == Py_None) {
		r->in.domain_guid = NULL;
	} else {
		r->in.domain_guid = NULL;
		PY_CHECK_TYPE(GUID_Type, py_domain_guid, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_domain_guid)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.domain_guid = (struct GUID *)pytalloc_get_ptr(py_domain_guid);
	}
	if (py_site_name == Py_None) {
		r->in.site_name = NULL;
	} else {
		r->in.site_name = NULL;
		if (PyUnicode_Check(py_site_name)) {
			r->in.site_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_site_name, "utf-8", "ignore"));
		} else if (PyString_Check(py_site_name)) {
			r->in.site_name = PyString_AS_STRING(py_site_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_site_name)->tp_name);
			return false;
		}
	}
	if (PyLong_Check(py_flags)) {
		r->in.flags = PyLong_AsLongLong(py_flags);
	} else if (PyInt_Check(py_flags)) {
		r->in.flags = PyInt_AsLong(py_flags);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_netr_DsRGetDCNameEx_args_out(struct netr_DsRGetDCNameEx *r)
{
	PyObject *result;
	PyObject *py_info;
	if (*r->out.info == NULL) {
		py_info = Py_None;
		Py_INCREF(py_info);
	} else {
		py_info = pytalloc_reference_ex(&netr_DsRGetDCNameInfo_Type, *r->out.info, *r->out.info);
	}
	result = py_info;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_DsRGetSiteName_args_in(PyObject *args, PyObject *kwargs, struct netr_DsRGetSiteName *r)
{
	PyObject *py_computer_name;
	const char *kwnames[] = {
		"computer_name", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:netr_DsRGetSiteName", discard_const_p(char *, kwnames), &py_computer_name)) {
		return false;
	}

	if (py_computer_name == Py_None) {
		r->in.computer_name = NULL;
	} else {
		r->in.computer_name = NULL;
		if (PyUnicode_Check(py_computer_name)) {
			r->in.computer_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_computer_name, "utf-8", "ignore"));
		} else if (PyString_Check(py_computer_name)) {
			r->in.computer_name = PyString_AS_STRING(py_computer_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_computer_name)->tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_netr_DsRGetSiteName_args_out(struct netr_DsRGetSiteName *r)
{
	PyObject *result;
	PyObject *py_site;
	if (*r->out.site == NULL) {
		py_site = Py_None;
		Py_INCREF(py_site);
	} else {
		if (*r->out.site == NULL) {
			py_site = Py_None;
			Py_INCREF(py_site);
		} else {
			py_site = PyUnicode_Decode(*r->out.site, strlen(*r->out.site), "utf-8", "ignore");
		}
	}
	result = py_site;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_LogonGetDomainInfo_args_in(PyObject *args, PyObject *kwargs, struct netr_LogonGetDomainInfo *r)
{
	PyObject *py_server_name;
	PyObject *py_computer_name;
	PyObject *py_credential;
	PyObject *py_return_authenticator;
	PyObject *py_level;
	PyObject *py_query;
	const char *kwnames[] = {
		"server_name", "computer_name", "credential", "return_authenticator", "level", "query", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOO:netr_LogonGetDomainInfo", discard_const_p(char *, kwnames), &py_server_name, &py_computer_name, &py_credential, &py_return_authenticator, &py_level, &py_query)) {
		return false;
	}

	r->in.server_name = talloc_ptrtype(r, r->in.server_name);
	if (PyUnicode_Check(py_server_name)) {
		r->in.server_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
	} else if (PyString_Check(py_server_name)) {
		r->in.server_name = PyString_AS_STRING(py_server_name);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
		return false;
	}
	if (py_computer_name == Py_None) {
		r->in.computer_name = NULL;
	} else {
		r->in.computer_name = NULL;
		if (PyUnicode_Check(py_computer_name)) {
			r->in.computer_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_computer_name, "utf-8", "ignore"));
		} else if (PyString_Check(py_computer_name)) {
			r->in.computer_name = PyString_AS_STRING(py_computer_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_computer_name)->tp_name);
			return false;
		}
	}
	r->in.credential = talloc_ptrtype(r, r->in.credential);
	PY_CHECK_TYPE(&netr_Authenticator_Type, py_credential, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_credential)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.credential = (struct netr_Authenticator *)pytalloc_get_ptr(py_credential);
	r->in.return_authenticator = talloc_ptrtype(r, r->in.return_authenticator);
	PY_CHECK_TYPE(&netr_Authenticator_Type, py_return_authenticator, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_return_authenticator)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.return_authenticator = (struct netr_Authenticator *)pytalloc_get_ptr(py_return_authenticator);
	PY_CHECK_TYPE(&PyInt_Type, py_level, return false;);
	r->in.level = PyInt_AsLong(py_level);
	r->in.query = talloc_ptrtype(r, r->in.query);
	{
		union netr_WorkstationInfo *query_switch_1;
		query_switch_1 = py_export_netr_WorkstationInfo(r, r->in.level, py_query);
		if (query_switch_1 == NULL) {
			return false;
		}
		r->in.query = query_switch_1;
	}
	return true;
}

static PyObject *unpack_py_netr_LogonGetDomainInfo_args_out(struct netr_LogonGetDomainInfo *r)
{
	PyObject *result;
	PyObject *py_return_authenticator;
	PyObject *py_info;
	result = PyTuple_New(2);
	py_return_authenticator = pytalloc_reference_ex(&netr_Authenticator_Type, r->out.return_authenticator, r->out.return_authenticator);
	PyTuple_SetItem(result, 0, py_return_authenticator);
	py_info = py_import_netr_DomainInfo(r->out.info, r->in.level, r->out.info);
	if (py_info == NULL) {
		return NULL;
	}
	PyTuple_SetItem(result, 1, py_info);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_ServerPasswordSet2_args_in(PyObject *args, PyObject *kwargs, struct netr_ServerPasswordSet2 *r)
{
	PyObject *py_server_name;
	PyObject *py_account_name;
	PyObject *py_secure_channel_type;
	PyObject *py_computer_name;
	PyObject *py_credential;
	PyObject *py_new_password;
	const char *kwnames[] = {
		"server_name", "account_name", "secure_channel_type", "computer_name", "credential", "new_password", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOO:netr_ServerPasswordSet2", discard_const_p(char *, kwnames), &py_server_name, &py_account_name, &py_secure_channel_type, &py_computer_name, &py_credential, &py_new_password)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		if (PyUnicode_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
		} else if (PyString_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(py_server_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
			return false;
		}
	}
	r->in.account_name = talloc_ptrtype(r, r->in.account_name);
	if (PyUnicode_Check(py_account_name)) {
		r->in.account_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_account_name, "utf-8", "ignore"));
	} else if (PyString_Check(py_account_name)) {
		r->in.account_name = PyString_AS_STRING(py_account_name);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_account_name)->tp_name);
		return false;
	}
	if (PyLong_Check(py_secure_channel_type)) {
		r->in.secure_channel_type = PyLong_AsLongLong(py_secure_channel_type);
	} else if (PyInt_Check(py_secure_channel_type)) {
		r->in.secure_channel_type = PyInt_AsLong(py_secure_channel_type);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	r->in.computer_name = talloc_ptrtype(r, r->in.computer_name);
	if (PyUnicode_Check(py_computer_name)) {
		r->in.computer_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_computer_name, "utf-8", "ignore"));
	} else if (PyString_Check(py_computer_name)) {
		r->in.computer_name = PyString_AS_STRING(py_computer_name);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_computer_name)->tp_name);
		return false;
	}
	r->in.credential = talloc_ptrtype(r, r->in.credential);
	PY_CHECK_TYPE(&netr_Authenticator_Type, py_credential, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_credential)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.credential = (struct netr_Authenticator *)pytalloc_get_ptr(py_credential);
	r->in.new_password = talloc_ptrtype(r, r->in.new_password);
	PY_CHECK_TYPE(&netr_CryptPassword_Type, py_new_password, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_new_password)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.new_password = (struct netr_CryptPassword *)pytalloc_get_ptr(py_new_password);
	return true;
}

static PyObject *unpack_py_netr_ServerPasswordSet2_args_out(struct netr_ServerPasswordSet2 *r)
{
	PyObject *result;
	PyObject *py_return_authenticator;
	py_return_authenticator = pytalloc_reference_ex(&netr_Authenticator_Type, r->out.return_authenticator, r->out.return_authenticator);
	result = py_return_authenticator;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_ServerPasswordGet_args_in(PyObject *args, PyObject *kwargs, struct netr_ServerPasswordGet *r)
{
	PyObject *py_server_name;
	PyObject *py_account_name;
	PyObject *py_secure_channel_type;
	PyObject *py_computer_name;
	PyObject *py_credential;
	const char *kwnames[] = {
		"server_name", "account_name", "secure_channel_type", "computer_name", "credential", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:netr_ServerPasswordGet", discard_const_p(char *, kwnames), &py_server_name, &py_account_name, &py_secure_channel_type, &py_computer_name, &py_credential)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		if (PyUnicode_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
		} else if (PyString_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(py_server_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
			return false;
		}
	}
	r->in.account_name = talloc_ptrtype(r, r->in.account_name);
	if (PyUnicode_Check(py_account_name)) {
		r->in.account_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_account_name, "utf-8", "ignore"));
	} else if (PyString_Check(py_account_name)) {
		r->in.account_name = PyString_AS_STRING(py_account_name);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_account_name)->tp_name);
		return false;
	}
	if (PyLong_Check(py_secure_channel_type)) {
		r->in.secure_channel_type = PyLong_AsLongLong(py_secure_channel_type);
	} else if (PyInt_Check(py_secure_channel_type)) {
		r->in.secure_channel_type = PyInt_AsLong(py_secure_channel_type);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	r->in.computer_name = talloc_ptrtype(r, r->in.computer_name);
	if (PyUnicode_Check(py_computer_name)) {
		r->in.computer_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_computer_name, "utf-8", "ignore"));
	} else if (PyString_Check(py_computer_name)) {
		r->in.computer_name = PyString_AS_STRING(py_computer_name);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_computer_name)->tp_name);
		return false;
	}
	r->in.credential = talloc_ptrtype(r, r->in.credential);
	PY_CHECK_TYPE(&netr_Authenticator_Type, py_credential, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_credential)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.credential = (struct netr_Authenticator *)pytalloc_get_ptr(py_credential);
	return true;
}

static PyObject *unpack_py_netr_ServerPasswordGet_args_out(struct netr_ServerPasswordGet *r)
{
	PyObject *result;
	PyObject *py_return_authenticator;
	PyObject *py_password;
	result = PyTuple_New(2);
	py_return_authenticator = pytalloc_reference_ex(&netr_Authenticator_Type, r->out.return_authenticator, r->out.return_authenticator);
	PyTuple_SetItem(result, 0, py_return_authenticator);
	py_password = pytalloc_reference_ex(samr_Password_Type, r->out.password, r->out.password);
	PyTuple_SetItem(result, 1, py_password);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_DsRAddressToSitenamesW_args_in(PyObject *args, PyObject *kwargs, struct netr_DsRAddressToSitenamesW *r)
{
	PyObject *py_server_name;
	PyObject *py_addresses;
	const char *kwnames[] = {
		"server_name", "addresses", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:netr_DsRAddressToSitenamesW", discard_const_p(char *, kwnames), &py_server_name, &py_addresses)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		if (PyUnicode_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
		} else if (PyString_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(py_server_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
			return false;
		}
	}
	PY_CHECK_TYPE(&PyList_Type, py_addresses, return false;);
	r->in.count = PyList_GET_SIZE(py_addresses);
	r->in.addresses = talloc_ptrtype(r, r->in.addresses);
	PY_CHECK_TYPE(&PyList_Type, py_addresses, return false;);
	{
		int addresses_cntr_1;
		r->in.addresses = talloc_array_ptrtype(r, r->in.addresses, PyList_GET_SIZE(py_addresses));
		if (!r->in.addresses) { return false;; }
		talloc_set_name_const(r->in.addresses, "ARRAY: r->in.addresses");
		for (addresses_cntr_1 = 0; addresses_cntr_1 < PyList_GET_SIZE(py_addresses); addresses_cntr_1++) {
			PY_CHECK_TYPE(&netr_DsRAddress_Type, PyList_GET_ITEM(py_addresses, addresses_cntr_1), return false;);
			if (talloc_reference(r->in.addresses, pytalloc_get_mem_ctx(PyList_GET_ITEM(py_addresses, addresses_cntr_1))) == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.addresses[addresses_cntr_1] = *(struct netr_DsRAddress *)pytalloc_get_ptr(PyList_GET_ITEM(py_addresses, addresses_cntr_1));
		}
	}
	return true;
}

static PyObject *unpack_py_netr_DsRAddressToSitenamesW_args_out(struct netr_DsRAddressToSitenamesW *r)
{
	PyObject *result;
	PyObject *py_ctr;
	if (*r->out.ctr == NULL) {
		py_ctr = Py_None;
		Py_INCREF(py_ctr);
	} else {
		py_ctr = pytalloc_reference_ex(&netr_DsRAddressToSitenamesWCtr_Type, *r->out.ctr, *r->out.ctr);
	}
	result = py_ctr;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_DsRGetDCNameEx2_args_in(PyObject *args, PyObject *kwargs, struct netr_DsRGetDCNameEx2 *r)
{
	PyObject *py_server_unc;
	PyObject *py_client_account;
	PyObject *py_mask;
	PyObject *py_domain_name;
	PyObject *py_domain_guid;
	PyObject *py_site_name;
	PyObject *py_flags;
	const char *kwnames[] = {
		"server_unc", "client_account", "mask", "domain_name", "domain_guid", "site_name", "flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOO:netr_DsRGetDCNameEx2", discard_const_p(char *, kwnames), &py_server_unc, &py_client_account, &py_mask, &py_domain_name, &py_domain_guid, &py_site_name, &py_flags)) {
		return false;
	}

	if (py_server_unc == Py_None) {
		r->in.server_unc = NULL;
	} else {
		r->in.server_unc = NULL;
		if (PyUnicode_Check(py_server_unc)) {
			r->in.server_unc = PyString_AS_STRING(PyUnicode_AsEncodedString(py_server_unc, "utf-8", "ignore"));
		} else if (PyString_Check(py_server_unc)) {
			r->in.server_unc = PyString_AS_STRING(py_server_unc);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_unc)->tp_name);
			return false;
		}
	}
	if (py_client_account == Py_None) {
		r->in.client_account = NULL;
	} else {
		r->in.client_account = NULL;
		if (PyUnicode_Check(py_client_account)) {
			r->in.client_account = PyString_AS_STRING(PyUnicode_AsEncodedString(py_client_account, "utf-8", "ignore"));
		} else if (PyString_Check(py_client_account)) {
			r->in.client_account = PyString_AS_STRING(py_client_account);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_client_account)->tp_name);
			return false;
		}
	}
	if (PyLong_Check(py_mask)) {
		r->in.mask = PyLong_AsLongLong(py_mask);
	} else if (PyInt_Check(py_mask)) {
		r->in.mask = PyInt_AsLong(py_mask);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	if (py_domain_name == Py_None) {
		r->in.domain_name = NULL;
	} else {
		r->in.domain_name = NULL;
		if (PyUnicode_Check(py_domain_name)) {
			r->in.domain_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_domain_name, "utf-8", "ignore"));
		} else if (PyString_Check(py_domain_name)) {
			r->in.domain_name = PyString_AS_STRING(py_domain_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_domain_name)->tp_name);
			return false;
		}
	}
	if (py_domain_guid == Py_None) {
		r->in.domain_guid = NULL;
	} else {
		r->in.domain_guid = NULL;
		PY_CHECK_TYPE(GUID_Type, py_domain_guid, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_domain_guid)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.domain_guid = (struct GUID *)pytalloc_get_ptr(py_domain_guid);
	}
	if (py_site_name == Py_None) {
		r->in.site_name = NULL;
	} else {
		r->in.site_name = NULL;
		if (PyUnicode_Check(py_site_name)) {
			r->in.site_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_site_name, "utf-8", "ignore"));
		} else if (PyString_Check(py_site_name)) {
			r->in.site_name = PyString_AS_STRING(py_site_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_site_name)->tp_name);
			return false;
		}
	}
	if (PyLong_Check(py_flags)) {
		r->in.flags = PyLong_AsLongLong(py_flags);
	} else if (PyInt_Check(py_flags)) {
		r->in.flags = PyInt_AsLong(py_flags);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_netr_DsRGetDCNameEx2_args_out(struct netr_DsRGetDCNameEx2 *r)
{
	PyObject *result;
	PyObject *py_info;
	if (*r->out.info == NULL) {
		py_info = Py_None;
		Py_INCREF(py_info);
	} else {
		py_info = pytalloc_reference_ex(&netr_DsRGetDCNameInfo_Type, *r->out.info, *r->out.info);
	}
	result = py_info;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_NetrEnumerateTrustedDomainsEx_args_in(PyObject *args, PyObject *kwargs, struct netr_NetrEnumerateTrustedDomainsEx *r)
{
	PyObject *py_server_name;
	const char *kwnames[] = {
		"server_name", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:netr_NetrEnumerateTrustedDomainsEx", discard_const_p(char *, kwnames), &py_server_name)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		if (PyUnicode_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
		} else if (PyString_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(py_server_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_netr_NetrEnumerateTrustedDomainsEx_args_out(struct netr_NetrEnumerateTrustedDomainsEx *r)
{
	PyObject *result;
	PyObject *py_dom_trust_list;
	py_dom_trust_list = pytalloc_reference_ex(&netr_DomainTrustList_Type, r->out.dom_trust_list, r->out.dom_trust_list);
	result = py_dom_trust_list;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_DsRAddressToSitenamesExW_args_in(PyObject *args, PyObject *kwargs, struct netr_DsRAddressToSitenamesExW *r)
{
	PyObject *py_server_name;
	PyObject *py_addresses;
	const char *kwnames[] = {
		"server_name", "addresses", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:netr_DsRAddressToSitenamesExW", discard_const_p(char *, kwnames), &py_server_name, &py_addresses)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		if (PyUnicode_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
		} else if (PyString_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(py_server_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
			return false;
		}
	}
	PY_CHECK_TYPE(&PyList_Type, py_addresses, return false;);
	r->in.count = PyList_GET_SIZE(py_addresses);
	r->in.addresses = talloc_ptrtype(r, r->in.addresses);
	PY_CHECK_TYPE(&PyList_Type, py_addresses, return false;);
	{
		int addresses_cntr_1;
		r->in.addresses = talloc_array_ptrtype(r, r->in.addresses, PyList_GET_SIZE(py_addresses));
		if (!r->in.addresses) { return false;; }
		talloc_set_name_const(r->in.addresses, "ARRAY: r->in.addresses");
		for (addresses_cntr_1 = 0; addresses_cntr_1 < PyList_GET_SIZE(py_addresses); addresses_cntr_1++) {
			PY_CHECK_TYPE(&netr_DsRAddress_Type, PyList_GET_ITEM(py_addresses, addresses_cntr_1), return false;);
			if (talloc_reference(r->in.addresses, pytalloc_get_mem_ctx(PyList_GET_ITEM(py_addresses, addresses_cntr_1))) == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.addresses[addresses_cntr_1] = *(struct netr_DsRAddress *)pytalloc_get_ptr(PyList_GET_ITEM(py_addresses, addresses_cntr_1));
		}
	}
	return true;
}

static PyObject *unpack_py_netr_DsRAddressToSitenamesExW_args_out(struct netr_DsRAddressToSitenamesExW *r)
{
	PyObject *result;
	PyObject *py_ctr;
	if (*r->out.ctr == NULL) {
		py_ctr = Py_None;
		Py_INCREF(py_ctr);
	} else {
		py_ctr = pytalloc_reference_ex(&netr_DsRAddressToSitenamesExWCtr_Type, *r->out.ctr, *r->out.ctr);
	}
	result = py_ctr;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_DsrGetDcSiteCoverageW_args_in(PyObject *args, PyObject *kwargs, struct netr_DsrGetDcSiteCoverageW *r)
{
	PyObject *py_server_name;
	const char *kwnames[] = {
		"server_name", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:netr_DsrGetDcSiteCoverageW", discard_const_p(char *, kwnames), &py_server_name)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		if (PyUnicode_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
		} else if (PyString_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(py_server_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_netr_DsrGetDcSiteCoverageW_args_out(struct netr_DsrGetDcSiteCoverageW *r)
{
	PyObject *result;
	PyObject *py_ctr;
	if (*r->out.ctr == NULL) {
		py_ctr = Py_None;
		Py_INCREF(py_ctr);
	} else {
		py_ctr = pytalloc_reference_ex(&DcSitesCtr_Type, *r->out.ctr, *r->out.ctr);
	}
	result = py_ctr;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_LogonSamLogonEx_args_in(PyObject *args, PyObject *kwargs, struct netr_LogonSamLogonEx *r)
{
	PyObject *py_server_name;
	PyObject *py_computer_name;
	PyObject *py_logon_level;
	PyObject *py_logon;
	PyObject *py_validation_level;
	PyObject *py_flags;
	const char *kwnames[] = {
		"server_name", "computer_name", "logon_level", "logon", "validation_level", "flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOO:netr_LogonSamLogonEx", discard_const_p(char *, kwnames), &py_server_name, &py_computer_name, &py_logon_level, &py_logon, &py_validation_level, &py_flags)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		if (PyUnicode_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
		} else if (PyString_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(py_server_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
			return false;
		}
	}
	if (py_computer_name == Py_None) {
		r->in.computer_name = NULL;
	} else {
		r->in.computer_name = NULL;
		if (PyUnicode_Check(py_computer_name)) {
			r->in.computer_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_computer_name, "utf-8", "ignore"));
		} else if (PyString_Check(py_computer_name)) {
			r->in.computer_name = PyString_AS_STRING(py_computer_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_computer_name)->tp_name);
			return false;
		}
	}
	if (PyLong_Check(py_logon_level)) {
		r->in.logon_level = PyLong_AsLongLong(py_logon_level);
	} else if (PyInt_Check(py_logon_level)) {
		r->in.logon_level = PyInt_AsLong(py_logon_level);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	r->in.logon = talloc_ptrtype(r, r->in.logon);
	{
		union netr_LogonLevel *logon_switch_1;
		logon_switch_1 = py_export_netr_LogonLevel(r, r->in.logon_level, py_logon);
		if (logon_switch_1 == NULL) {
			return false;
		}
		r->in.logon = logon_switch_1;
	}
	PY_CHECK_TYPE(&PyInt_Type, py_validation_level, return false;);
	r->in.validation_level = PyInt_AsLong(py_validation_level);
	r->in.flags = talloc_ptrtype(r, r->in.flags);
	PY_CHECK_TYPE(&PyInt_Type, py_flags, return false;);
	*r->in.flags = PyInt_AsLong(py_flags);
	return true;
}

static PyObject *unpack_py_netr_LogonSamLogonEx_args_out(struct netr_LogonSamLogonEx *r)
{
	PyObject *result;
	PyObject *py_validation;
	PyObject *py_authoritative;
	PyObject *py_flags;
	result = PyTuple_New(3);
	py_validation = py_import_netr_Validation(r->out.validation, r->in.validation_level, r->out.validation);
	if (py_validation == NULL) {
		return NULL;
	}
	PyTuple_SetItem(result, 0, py_validation);
	py_authoritative = PyInt_FromLong(*r->out.authoritative);
	PyTuple_SetItem(result, 1, py_authoritative);
	py_flags = PyInt_FromLong(*r->out.flags);
	PyTuple_SetItem(result, 2, py_flags);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_DsrEnumerateDomainTrusts_args_in(PyObject *args, PyObject *kwargs, struct netr_DsrEnumerateDomainTrusts *r)
{
	PyObject *py_server_name;
	PyObject *py_trust_flags;
	const char *kwnames[] = {
		"server_name", "trust_flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:netr_DsrEnumerateDomainTrusts", discard_const_p(char *, kwnames), &py_server_name, &py_trust_flags)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		if (PyUnicode_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
		} else if (PyString_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(py_server_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
			return false;
		}
	}
	if (PyLong_Check(py_trust_flags)) {
		r->in.trust_flags = PyLong_AsLongLong(py_trust_flags);
	} else if (PyInt_Check(py_trust_flags)) {
		r->in.trust_flags = PyInt_AsLong(py_trust_flags);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_netr_DsrEnumerateDomainTrusts_args_out(struct netr_DsrEnumerateDomainTrusts *r)
{
	PyObject *result;
	PyObject *py_trusts;
	py_trusts = pytalloc_reference_ex(&netr_DomainTrustList_Type, r->out.trusts, r->out.trusts);
	result = py_trusts;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_DsrDeregisterDNSHostRecords_args_in(PyObject *args, PyObject *kwargs, struct netr_DsrDeregisterDNSHostRecords *r)
{
	PyObject *py_server_name;
	PyObject *py_domain;
	PyObject *py_domain_guid;
	PyObject *py_dsa_guid;
	PyObject *py_dns_host;
	const char *kwnames[] = {
		"server_name", "domain", "domain_guid", "dsa_guid", "dns_host", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:netr_DsrDeregisterDNSHostRecords", discard_const_p(char *, kwnames), &py_server_name, &py_domain, &py_domain_guid, &py_dsa_guid, &py_dns_host)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		if (PyUnicode_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
		} else if (PyString_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(py_server_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
			return false;
		}
	}
	if (py_domain == Py_None) {
		r->in.domain = NULL;
	} else {
		r->in.domain = NULL;
		if (PyUnicode_Check(py_domain)) {
			r->in.domain = PyString_AS_STRING(PyUnicode_AsEncodedString(py_domain, "utf-8", "ignore"));
		} else if (PyString_Check(py_domain)) {
			r->in.domain = PyString_AS_STRING(py_domain);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_domain)->tp_name);
			return false;
		}
	}
	if (py_domain_guid == Py_None) {
		r->in.domain_guid = NULL;
	} else {
		r->in.domain_guid = NULL;
		PY_CHECK_TYPE(GUID_Type, py_domain_guid, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_domain_guid)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.domain_guid = (struct GUID *)pytalloc_get_ptr(py_domain_guid);
	}
	if (py_dsa_guid == Py_None) {
		r->in.dsa_guid = NULL;
	} else {
		r->in.dsa_guid = NULL;
		PY_CHECK_TYPE(GUID_Type, py_dsa_guid, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_dsa_guid)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.dsa_guid = (struct GUID *)pytalloc_get_ptr(py_dsa_guid);
	}
	r->in.dns_host = talloc_ptrtype(r, r->in.dns_host);
	if (PyUnicode_Check(py_dns_host)) {
		r->in.dns_host = PyString_AS_STRING(PyUnicode_AsEncodedString(py_dns_host, "utf-8", "ignore"));
	} else if (PyString_Check(py_dns_host)) {
		r->in.dns_host = PyString_AS_STRING(py_dns_host);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_dns_host)->tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_netr_DsrDeregisterDNSHostRecords_args_out(struct netr_DsrDeregisterDNSHostRecords *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_ServerTrustPasswordsGet_args_in(PyObject *args, PyObject *kwargs, struct netr_ServerTrustPasswordsGet *r)
{
	PyObject *py_server_name;
	PyObject *py_account_name;
	PyObject *py_secure_channel_type;
	PyObject *py_computer_name;
	PyObject *py_credential;
	const char *kwnames[] = {
		"server_name", "account_name", "secure_channel_type", "computer_name", "credential", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:netr_ServerTrustPasswordsGet", discard_const_p(char *, kwnames), &py_server_name, &py_account_name, &py_secure_channel_type, &py_computer_name, &py_credential)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		if (PyUnicode_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
		} else if (PyString_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(py_server_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
			return false;
		}
	}
	r->in.account_name = talloc_ptrtype(r, r->in.account_name);
	if (PyUnicode_Check(py_account_name)) {
		r->in.account_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_account_name, "utf-8", "ignore"));
	} else if (PyString_Check(py_account_name)) {
		r->in.account_name = PyString_AS_STRING(py_account_name);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_account_name)->tp_name);
		return false;
	}
	if (PyLong_Check(py_secure_channel_type)) {
		r->in.secure_channel_type = PyLong_AsLongLong(py_secure_channel_type);
	} else if (PyInt_Check(py_secure_channel_type)) {
		r->in.secure_channel_type = PyInt_AsLong(py_secure_channel_type);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	r->in.computer_name = talloc_ptrtype(r, r->in.computer_name);
	if (PyUnicode_Check(py_computer_name)) {
		r->in.computer_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_computer_name, "utf-8", "ignore"));
	} else if (PyString_Check(py_computer_name)) {
		r->in.computer_name = PyString_AS_STRING(py_computer_name);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_computer_name)->tp_name);
		return false;
	}
	r->in.credential = talloc_ptrtype(r, r->in.credential);
	PY_CHECK_TYPE(&netr_Authenticator_Type, py_credential, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_credential)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.credential = (struct netr_Authenticator *)pytalloc_get_ptr(py_credential);
	return true;
}

static PyObject *unpack_py_netr_ServerTrustPasswordsGet_args_out(struct netr_ServerTrustPasswordsGet *r)
{
	PyObject *result;
	PyObject *py_return_authenticator;
	PyObject *py_password;
	PyObject *py_password2;
	result = PyTuple_New(3);
	py_return_authenticator = pytalloc_reference_ex(&netr_Authenticator_Type, r->out.return_authenticator, r->out.return_authenticator);
	PyTuple_SetItem(result, 0, py_return_authenticator);
	py_password = pytalloc_reference_ex(samr_Password_Type, r->out.password, r->out.password);
	PyTuple_SetItem(result, 1, py_password);
	py_password2 = pytalloc_reference_ex(samr_Password_Type, r->out.password2, r->out.password2);
	PyTuple_SetItem(result, 2, py_password2);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_DsRGetForestTrustInformation_args_in(PyObject *args, PyObject *kwargs, struct netr_DsRGetForestTrustInformation *r)
{
	PyObject *py_server_name;
	PyObject *py_trusted_domain_name;
	PyObject *py_flags;
	const char *kwnames[] = {
		"server_name", "trusted_domain_name", "flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:netr_DsRGetForestTrustInformation", discard_const_p(char *, kwnames), &py_server_name, &py_trusted_domain_name, &py_flags)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		if (PyUnicode_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
		} else if (PyString_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(py_server_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
			return false;
		}
	}
	if (py_trusted_domain_name == Py_None) {
		r->in.trusted_domain_name = NULL;
	} else {
		r->in.trusted_domain_name = NULL;
		if (PyUnicode_Check(py_trusted_domain_name)) {
			r->in.trusted_domain_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_trusted_domain_name, "utf-8", "ignore"));
		} else if (PyString_Check(py_trusted_domain_name)) {
			r->in.trusted_domain_name = PyString_AS_STRING(py_trusted_domain_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_trusted_domain_name)->tp_name);
			return false;
		}
	}
	PY_CHECK_TYPE(&PyInt_Type, py_flags, return false;);
	r->in.flags = PyInt_AsLong(py_flags);
	return true;
}

static PyObject *unpack_py_netr_DsRGetForestTrustInformation_args_out(struct netr_DsRGetForestTrustInformation *r)
{
	PyObject *result;
	PyObject *py_forest_trust_info;
	if (*r->out.forest_trust_info == NULL) {
		py_forest_trust_info = Py_None;
		Py_INCREF(py_forest_trust_info);
	} else {
		py_forest_trust_info = pytalloc_reference_ex(lsa_ForestTrustInformation_Type, *r->out.forest_trust_info, *r->out.forest_trust_info);
	}
	result = py_forest_trust_info;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_GetForestTrustInformation_args_in(PyObject *args, PyObject *kwargs, struct netr_GetForestTrustInformation *r)
{
	PyObject *py_server_name;
	PyObject *py_computer_name;
	PyObject *py_credential;
	PyObject *py_flags;
	const char *kwnames[] = {
		"server_name", "computer_name", "credential", "flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:netr_GetForestTrustInformation", discard_const_p(char *, kwnames), &py_server_name, &py_computer_name, &py_credential, &py_flags)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		if (PyUnicode_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
		} else if (PyString_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(py_server_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
			return false;
		}
	}
	r->in.computer_name = talloc_ptrtype(r, r->in.computer_name);
	if (PyUnicode_Check(py_computer_name)) {
		r->in.computer_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_computer_name, "utf-8", "ignore"));
	} else if (PyString_Check(py_computer_name)) {
		r->in.computer_name = PyString_AS_STRING(py_computer_name);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_computer_name)->tp_name);
		return false;
	}
	r->in.credential = talloc_ptrtype(r, r->in.credential);
	PY_CHECK_TYPE(&netr_Authenticator_Type, py_credential, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_credential)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.credential = (struct netr_Authenticator *)pytalloc_get_ptr(py_credential);
	PY_CHECK_TYPE(&PyInt_Type, py_flags, return false;);
	r->in.flags = PyInt_AsLong(py_flags);
	return true;
}

static PyObject *unpack_py_netr_GetForestTrustInformation_args_out(struct netr_GetForestTrustInformation *r)
{
	PyObject *result;
	PyObject *py_return_authenticator;
	PyObject *py_forest_trust_info;
	result = PyTuple_New(2);
	py_return_authenticator = pytalloc_reference_ex(&netr_Authenticator_Type, r->out.return_authenticator, r->out.return_authenticator);
	PyTuple_SetItem(result, 0, py_return_authenticator);
	if (*r->out.forest_trust_info == NULL) {
		py_forest_trust_info = Py_None;
		Py_INCREF(py_forest_trust_info);
	} else {
		py_forest_trust_info = pytalloc_reference_ex(lsa_ForestTrustInformation_Type, *r->out.forest_trust_info, *r->out.forest_trust_info);
	}
	PyTuple_SetItem(result, 1, py_forest_trust_info);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_LogonSamLogonWithFlags_args_in(PyObject *args, PyObject *kwargs, struct netr_LogonSamLogonWithFlags *r)
{
	PyObject *py_server_name;
	PyObject *py_computer_name;
	PyObject *py_credential;
	PyObject *py_return_authenticator;
	PyObject *py_logon_level;
	PyObject *py_logon;
	PyObject *py_validation_level;
	PyObject *py_flags;
	const char *kwnames[] = {
		"server_name", "computer_name", "credential", "return_authenticator", "logon_level", "logon", "validation_level", "flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOOO:netr_LogonSamLogonWithFlags", discard_const_p(char *, kwnames), &py_server_name, &py_computer_name, &py_credential, &py_return_authenticator, &py_logon_level, &py_logon, &py_validation_level, &py_flags)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		if (PyUnicode_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
		} else if (PyString_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(py_server_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
			return false;
		}
	}
	if (py_computer_name == Py_None) {
		r->in.computer_name = NULL;
	} else {
		r->in.computer_name = NULL;
		if (PyUnicode_Check(py_computer_name)) {
			r->in.computer_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_computer_name, "utf-8", "ignore"));
		} else if (PyString_Check(py_computer_name)) {
			r->in.computer_name = PyString_AS_STRING(py_computer_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_computer_name)->tp_name);
			return false;
		}
	}
	if (py_credential == Py_None) {
		r->in.credential = NULL;
	} else {
		r->in.credential = NULL;
		PY_CHECK_TYPE(&netr_Authenticator_Type, py_credential, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_credential)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.credential = (struct netr_Authenticator *)pytalloc_get_ptr(py_credential);
	}
	if (py_return_authenticator == Py_None) {
		r->in.return_authenticator = NULL;
	} else {
		r->in.return_authenticator = NULL;
		PY_CHECK_TYPE(&netr_Authenticator_Type, py_return_authenticator, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_return_authenticator)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.return_authenticator = (struct netr_Authenticator *)pytalloc_get_ptr(py_return_authenticator);
	}
	if (PyLong_Check(py_logon_level)) {
		r->in.logon_level = PyLong_AsLongLong(py_logon_level);
	} else if (PyInt_Check(py_logon_level)) {
		r->in.logon_level = PyInt_AsLong(py_logon_level);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	r->in.logon = talloc_ptrtype(r, r->in.logon);
	{
		union netr_LogonLevel *logon_switch_1;
		logon_switch_1 = py_export_netr_LogonLevel(r, r->in.logon_level, py_logon);
		if (logon_switch_1 == NULL) {
			return false;
		}
		r->in.logon = logon_switch_1;
	}
	PY_CHECK_TYPE(&PyInt_Type, py_validation_level, return false;);
	r->in.validation_level = PyInt_AsLong(py_validation_level);
	r->in.flags = talloc_ptrtype(r, r->in.flags);
	PY_CHECK_TYPE(&PyInt_Type, py_flags, return false;);
	*r->in.flags = PyInt_AsLong(py_flags);
	return true;
}

static PyObject *unpack_py_netr_LogonSamLogonWithFlags_args_out(struct netr_LogonSamLogonWithFlags *r)
{
	PyObject *result;
	PyObject *py_return_authenticator;
	PyObject *py_validation;
	PyObject *py_authoritative;
	PyObject *py_flags;
	result = PyTuple_New(4);
	if (r->out.return_authenticator == NULL) {
		py_return_authenticator = Py_None;
		Py_INCREF(py_return_authenticator);
	} else {
		py_return_authenticator = pytalloc_reference_ex(&netr_Authenticator_Type, r->out.return_authenticator, r->out.return_authenticator);
	}
	PyTuple_SetItem(result, 0, py_return_authenticator);
	py_validation = py_import_netr_Validation(r->out.validation, r->in.validation_level, r->out.validation);
	if (py_validation == NULL) {
		return NULL;
	}
	PyTuple_SetItem(result, 1, py_validation);
	py_authoritative = PyInt_FromLong(*r->out.authoritative);
	PyTuple_SetItem(result, 2, py_authoritative);
	py_flags = PyInt_FromLong(*r->out.flags);
	PyTuple_SetItem(result, 3, py_flags);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_ServerGetTrustInfo_args_in(PyObject *args, PyObject *kwargs, struct netr_ServerGetTrustInfo *r)
{
	PyObject *py_server_name;
	PyObject *py_account_name;
	PyObject *py_secure_channel_type;
	PyObject *py_computer_name;
	PyObject *py_credential;
	const char *kwnames[] = {
		"server_name", "account_name", "secure_channel_type", "computer_name", "credential", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:netr_ServerGetTrustInfo", discard_const_p(char *, kwnames), &py_server_name, &py_account_name, &py_secure_channel_type, &py_computer_name, &py_credential)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		if (PyUnicode_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
		} else if (PyString_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(py_server_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
			return false;
		}
	}
	r->in.account_name = talloc_ptrtype(r, r->in.account_name);
	if (PyUnicode_Check(py_account_name)) {
		r->in.account_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_account_name, "utf-8", "ignore"));
	} else if (PyString_Check(py_account_name)) {
		r->in.account_name = PyString_AS_STRING(py_account_name);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_account_name)->tp_name);
		return false;
	}
	if (PyLong_Check(py_secure_channel_type)) {
		r->in.secure_channel_type = PyLong_AsLongLong(py_secure_channel_type);
	} else if (PyInt_Check(py_secure_channel_type)) {
		r->in.secure_channel_type = PyInt_AsLong(py_secure_channel_type);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	r->in.computer_name = talloc_ptrtype(r, r->in.computer_name);
	if (PyUnicode_Check(py_computer_name)) {
		r->in.computer_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_computer_name, "utf-8", "ignore"));
	} else if (PyString_Check(py_computer_name)) {
		r->in.computer_name = PyString_AS_STRING(py_computer_name);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_computer_name)->tp_name);
		return false;
	}
	r->in.credential = talloc_ptrtype(r, r->in.credential);
	PY_CHECK_TYPE(&netr_Authenticator_Type, py_credential, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_credential)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.credential = (struct netr_Authenticator *)pytalloc_get_ptr(py_credential);
	return true;
}

static PyObject *unpack_py_netr_ServerGetTrustInfo_args_out(struct netr_ServerGetTrustInfo *r)
{
	PyObject *result;
	PyObject *py_return_authenticator;
	PyObject *py_new_owf_password;
	PyObject *py_old_owf_password;
	PyObject *py_trust_info;
	result = PyTuple_New(4);
	py_return_authenticator = pytalloc_reference_ex(&netr_Authenticator_Type, r->out.return_authenticator, r->out.return_authenticator);
	PyTuple_SetItem(result, 0, py_return_authenticator);
	py_new_owf_password = pytalloc_reference_ex(samr_Password_Type, r->out.new_owf_password, r->out.new_owf_password);
	PyTuple_SetItem(result, 1, py_new_owf_password);
	py_old_owf_password = pytalloc_reference_ex(samr_Password_Type, r->out.old_owf_password, r->out.old_owf_password);
	PyTuple_SetItem(result, 2, py_old_owf_password);
	if (*r->out.trust_info == NULL) {
		py_trust_info = Py_None;
		Py_INCREF(py_trust_info);
	} else {
		py_trust_info = pytalloc_reference_ex(&netr_TrustInfo_Type, *r->out.trust_info, *r->out.trust_info);
	}
	PyTuple_SetItem(result, 3, py_trust_info);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_Unused47_args_in(PyObject *args, PyObject *kwargs, struct netr_Unused47 *r)
{
	const char *kwnames[] = {
		NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":netr_Unused47", discard_const_p(char *, kwnames))) {
		return false;
	}

	return true;
}

static PyObject *unpack_py_netr_Unused47_args_out(struct netr_Unused47 *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_netr_DsrUpdateReadOnlyServerDnsRecords_args_in(PyObject *args, PyObject *kwargs, struct netr_DsrUpdateReadOnlyServerDnsRecords *r)
{
	PyObject *py_server_name;
	PyObject *py_computer_name;
	PyObject *py_credential;
	PyObject *py_site_name;
	PyObject *py_dns_ttl;
	PyObject *py_dns_names;
	const char *kwnames[] = {
		"server_name", "computer_name", "credential", "site_name", "dns_ttl", "dns_names", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOO:netr_DsrUpdateReadOnlyServerDnsRecords", discard_const_p(char *, kwnames), &py_server_name, &py_computer_name, &py_credential, &py_site_name, &py_dns_ttl, &py_dns_names)) {
		return false;
	}

	if (py_server_name == Py_None) {
		r->in.server_name = NULL;
	} else {
		r->in.server_name = NULL;
		if (PyUnicode_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_server_name, "utf-8", "ignore"));
		} else if (PyString_Check(py_server_name)) {
			r->in.server_name = PyString_AS_STRING(py_server_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_server_name)->tp_name);
			return false;
		}
	}
	r->in.computer_name = talloc_ptrtype(r, r->in.computer_name);
	if (PyUnicode_Check(py_computer_name)) {
		r->in.computer_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_computer_name, "utf-8", "ignore"));
	} else if (PyString_Check(py_computer_name)) {
		r->in.computer_name = PyString_AS_STRING(py_computer_name);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_computer_name)->tp_name);
		return false;
	}
	r->in.credential = talloc_ptrtype(r, r->in.credential);
	PY_CHECK_TYPE(&netr_Authenticator_Type, py_credential, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_credential)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.credential = (struct netr_Authenticator *)pytalloc_get_ptr(py_credential);
	if (py_site_name == Py_None) {
		r->in.site_name = NULL;
	} else {
		r->in.site_name = NULL;
		if (PyUnicode_Check(py_site_name)) {
			r->in.site_name = PyString_AS_STRING(PyUnicode_AsEncodedString(py_site_name, "utf-8", "ignore"));
		} else if (PyString_Check(py_site_name)) {
			r->in.site_name = PyString_AS_STRING(py_site_name);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_site_name)->tp_name);
			return false;
		}
	}
	PY_CHECK_TYPE(&PyInt_Type, py_dns_ttl, return false;);
	r->in.dns_ttl = PyInt_AsLong(py_dns_ttl);
	r->in.dns_names = talloc_ptrtype(r, r->in.dns_names);
	PY_CHECK_TYPE(&NL_DNS_NAME_INFO_ARRAY_Type, py_dns_names, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_dns_names)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.dns_names = (struct NL_DNS_NAME_INFO_ARRAY *)pytalloc_get_ptr(py_dns_names);
	return true;
}

static PyObject *unpack_py_netr_DsrUpdateReadOnlyServerDnsRecords_args_out(struct netr_DsrUpdateReadOnlyServerDnsRecords *r)
{
	PyObject *result;
	PyObject *py_return_authenticator;
	PyObject *py_dns_names;
	result = PyTuple_New(2);
	py_return_authenticator = pytalloc_reference_ex(&netr_Authenticator_Type, r->out.return_authenticator, r->out.return_authenticator);
	PyTuple_SetItem(result, 0, py_return_authenticator);
	py_dns_names = pytalloc_reference_ex(&NL_DNS_NAME_INFO_ARRAY_Type, r->out.dns_names, r->out.dns_names);
	PyTuple_SetItem(result, 1, py_dns_names);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

const struct PyNdrRpcMethodDef py_ndr_netlogon_methods[] = {
	{ "netr_LogonUasLogon", "S.netr_LogonUasLogon(server_name, account_name, workstation) -> info", (py_dcerpc_call_fn)dcerpc_netr_LogonUasLogon_r, (py_data_pack_fn)pack_py_netr_LogonUasLogon_args_in, (py_data_unpack_fn)unpack_py_netr_LogonUasLogon_args_out, 0, &ndr_table_netlogon },
	{ "netr_LogonUasLogoff", "S.netr_LogonUasLogoff(server_name, account_name, workstation) -> info", (py_dcerpc_call_fn)dcerpc_netr_LogonUasLogoff_r, (py_data_pack_fn)pack_py_netr_LogonUasLogoff_args_in, (py_data_unpack_fn)unpack_py_netr_LogonUasLogoff_args_out, 1, &ndr_table_netlogon },
	{ "netr_LogonSamLogon", "S.netr_LogonSamLogon(server_name, computer_name, credential, return_authenticator, logon_level, logon, validation_level) -> (return_authenticator, validation, authoritative)", (py_dcerpc_call_fn)dcerpc_netr_LogonSamLogon_r, (py_data_pack_fn)pack_py_netr_LogonSamLogon_args_in, (py_data_unpack_fn)unpack_py_netr_LogonSamLogon_args_out, 2, &ndr_table_netlogon },
	{ "netr_LogonSamLogoff", "S.netr_LogonSamLogoff(server_name, computer_name, credential, return_authenticator, logon_level, logon) -> return_authenticator", (py_dcerpc_call_fn)dcerpc_netr_LogonSamLogoff_r, (py_data_pack_fn)pack_py_netr_LogonSamLogoff_args_in, (py_data_unpack_fn)unpack_py_netr_LogonSamLogoff_args_out, 3, &ndr_table_netlogon },
	{ "netr_ServerReqChallenge", "S.netr_ServerReqChallenge(server_name, computer_name, credentials) -> return_credentials", (py_dcerpc_call_fn)dcerpc_netr_ServerReqChallenge_r, (py_data_pack_fn)pack_py_netr_ServerReqChallenge_args_in, (py_data_unpack_fn)unpack_py_netr_ServerReqChallenge_args_out, 4, &ndr_table_netlogon },
	{ "netr_ServerAuthenticate", "S.netr_ServerAuthenticate(server_name, account_name, secure_channel_type, computer_name, credentials) -> return_credentials", (py_dcerpc_call_fn)dcerpc_netr_ServerAuthenticate_r, (py_data_pack_fn)pack_py_netr_ServerAuthenticate_args_in, (py_data_unpack_fn)unpack_py_netr_ServerAuthenticate_args_out, 5, &ndr_table_netlogon },
	{ "netr_ServerPasswordSet", "S.netr_ServerPasswordSet(server_name, account_name, secure_channel_type, computer_name, credential, new_password) -> return_authenticator", (py_dcerpc_call_fn)dcerpc_netr_ServerPasswordSet_r, (py_data_pack_fn)pack_py_netr_ServerPasswordSet_args_in, (py_data_unpack_fn)unpack_py_netr_ServerPasswordSet_args_out, 6, &ndr_table_netlogon },
	{ "netr_DatabaseDeltas", "S.netr_DatabaseDeltas(logon_server, computername, credential, return_authenticator, database_id, sequence_num, preferredmaximumlength) -> (return_authenticator, sequence_num, delta_enum_array)", (py_dcerpc_call_fn)dcerpc_netr_DatabaseDeltas_r, (py_data_pack_fn)pack_py_netr_DatabaseDeltas_args_in, (py_data_unpack_fn)unpack_py_netr_DatabaseDeltas_args_out, 7, &ndr_table_netlogon },
	{ "netr_DatabaseSync", "S.netr_DatabaseSync(logon_server, computername, credential, return_authenticator, database_id, sync_context, preferredmaximumlength) -> (return_authenticator, sync_context, delta_enum_array)", (py_dcerpc_call_fn)dcerpc_netr_DatabaseSync_r, (py_data_pack_fn)pack_py_netr_DatabaseSync_args_in, (py_data_unpack_fn)unpack_py_netr_DatabaseSync_args_out, 8, &ndr_table_netlogon },
	{ "netr_AccountDeltas", "S.netr_AccountDeltas(logon_server, computername, credential, return_authenticator, uas, count, level, buffersize) -> (return_authenticator, buffer, count_returned, total_entries, recordid)", (py_dcerpc_call_fn)dcerpc_netr_AccountDeltas_r, (py_data_pack_fn)pack_py_netr_AccountDeltas_args_in, (py_data_unpack_fn)unpack_py_netr_AccountDeltas_args_out, 9, &ndr_table_netlogon },
	{ "netr_AccountSync", "S.netr_AccountSync(logon_server, computername, credential, return_authenticator, reference, level, buffersize, recordid) -> (return_authenticator, buffer, count_returned, total_entries, next_reference, recordid)", (py_dcerpc_call_fn)dcerpc_netr_AccountSync_r, (py_data_pack_fn)pack_py_netr_AccountSync_args_in, (py_data_unpack_fn)unpack_py_netr_AccountSync_args_out, 10, &ndr_table_netlogon },
	{ "netr_GetDcName", "S.netr_GetDcName(logon_server, domainname) -> dcname", (py_dcerpc_call_fn)dcerpc_netr_GetDcName_r, (py_data_pack_fn)pack_py_netr_GetDcName_args_in, (py_data_unpack_fn)unpack_py_netr_GetDcName_args_out, 11, &ndr_table_netlogon },
	{ "netr_LogonControl", "S.netr_LogonControl(logon_server, function_code, level) -> query", (py_dcerpc_call_fn)dcerpc_netr_LogonControl_r, (py_data_pack_fn)pack_py_netr_LogonControl_args_in, (py_data_unpack_fn)unpack_py_netr_LogonControl_args_out, 12, &ndr_table_netlogon },
	{ "netr_GetAnyDCName", "S.netr_GetAnyDCName(logon_server, domainname) -> dcname", (py_dcerpc_call_fn)dcerpc_netr_GetAnyDCName_r, (py_data_pack_fn)pack_py_netr_GetAnyDCName_args_in, (py_data_unpack_fn)unpack_py_netr_GetAnyDCName_args_out, 13, &ndr_table_netlogon },
	{ "netr_LogonControl2", "S.netr_LogonControl2(logon_server, function_code, level, data) -> query", (py_dcerpc_call_fn)dcerpc_netr_LogonControl2_r, (py_data_pack_fn)pack_py_netr_LogonControl2_args_in, (py_data_unpack_fn)unpack_py_netr_LogonControl2_args_out, 14, &ndr_table_netlogon },
	{ "netr_ServerAuthenticate2", "S.netr_ServerAuthenticate2(server_name, account_name, secure_channel_type, computer_name, credentials, negotiate_flags) -> (return_credentials, negotiate_flags)", (py_dcerpc_call_fn)dcerpc_netr_ServerAuthenticate2_r, (py_data_pack_fn)pack_py_netr_ServerAuthenticate2_args_in, (py_data_unpack_fn)unpack_py_netr_ServerAuthenticate2_args_out, 15, &ndr_table_netlogon },
	{ "netr_DatabaseSync2", "S.netr_DatabaseSync2(logon_server, computername, credential, return_authenticator, database_id, restart_state, sync_context, preferredmaximumlength) -> (return_authenticator, sync_context, delta_enum_array)", (py_dcerpc_call_fn)dcerpc_netr_DatabaseSync2_r, (py_data_pack_fn)pack_py_netr_DatabaseSync2_args_in, (py_data_unpack_fn)unpack_py_netr_DatabaseSync2_args_out, 16, &ndr_table_netlogon },
	{ "netr_DatabaseRedo", "S.netr_DatabaseRedo(logon_server, computername, credential, return_authenticator, change_log_entry, change_log_entry_size) -> (return_authenticator, delta_enum_array)", (py_dcerpc_call_fn)dcerpc_netr_DatabaseRedo_r, (py_data_pack_fn)pack_py_netr_DatabaseRedo_args_in, (py_data_unpack_fn)unpack_py_netr_DatabaseRedo_args_out, 17, &ndr_table_netlogon },
	{ "netr_LogonControl2Ex", "S.netr_LogonControl2Ex(logon_server, function_code, level, data) -> query", (py_dcerpc_call_fn)dcerpc_netr_LogonControl2Ex_r, (py_data_pack_fn)pack_py_netr_LogonControl2Ex_args_in, (py_data_unpack_fn)unpack_py_netr_LogonControl2Ex_args_out, 18, &ndr_table_netlogon },
	{ "netr_NetrEnumerateTrustedDomains", "S.netr_NetrEnumerateTrustedDomains(server_name) -> trusted_domains_blob", (py_dcerpc_call_fn)dcerpc_netr_NetrEnumerateTrustedDomains_r, (py_data_pack_fn)pack_py_netr_NetrEnumerateTrustedDomains_args_in, (py_data_unpack_fn)unpack_py_netr_NetrEnumerateTrustedDomains_args_out, 19, &ndr_table_netlogon },
	{ "netr_DsRGetDCName", "S.netr_DsRGetDCName(server_unc, domain_name, domain_guid, site_guid, flags) -> info", (py_dcerpc_call_fn)dcerpc_netr_DsRGetDCName_r, (py_data_pack_fn)pack_py_netr_DsRGetDCName_args_in, (py_data_unpack_fn)unpack_py_netr_DsRGetDCName_args_out, 20, &ndr_table_netlogon },
	{ "netr_LogonGetCapabilities", "S.netr_LogonGetCapabilities(server_name, computer_name, credential, return_authenticator, query_level) -> (return_authenticator, capabilities)", (py_dcerpc_call_fn)dcerpc_netr_LogonGetCapabilities_r, (py_data_pack_fn)pack_py_netr_LogonGetCapabilities_args_in, (py_data_unpack_fn)unpack_py_netr_LogonGetCapabilities_args_out, 21, &ndr_table_netlogon },
	{ "netr_LogonGetTrustRid", "S.netr_LogonGetTrustRid(server_name, domain_name) -> rid", (py_dcerpc_call_fn)dcerpc_netr_LogonGetTrustRid_r, (py_data_pack_fn)pack_py_netr_LogonGetTrustRid_args_in, (py_data_unpack_fn)unpack_py_netr_LogonGetTrustRid_args_out, 23, &ndr_table_netlogon },
	{ "netr_ServerAuthenticate3", "S.netr_ServerAuthenticate3(server_name, account_name, secure_channel_type, computer_name, credentials, negotiate_flags) -> (return_credentials, negotiate_flags, rid)", (py_dcerpc_call_fn)dcerpc_netr_ServerAuthenticate3_r, (py_data_pack_fn)pack_py_netr_ServerAuthenticate3_args_in, (py_data_unpack_fn)unpack_py_netr_ServerAuthenticate3_args_out, 26, &ndr_table_netlogon },
	{ "netr_DsRGetDCNameEx", "S.netr_DsRGetDCNameEx(server_unc, domain_name, domain_guid, site_name, flags) -> info", (py_dcerpc_call_fn)dcerpc_netr_DsRGetDCNameEx_r, (py_data_pack_fn)pack_py_netr_DsRGetDCNameEx_args_in, (py_data_unpack_fn)unpack_py_netr_DsRGetDCNameEx_args_out, 27, &ndr_table_netlogon },
	{ "netr_DsRGetSiteName", "S.netr_DsRGetSiteName(computer_name) -> site", (py_dcerpc_call_fn)dcerpc_netr_DsRGetSiteName_r, (py_data_pack_fn)pack_py_netr_DsRGetSiteName_args_in, (py_data_unpack_fn)unpack_py_netr_DsRGetSiteName_args_out, 28, &ndr_table_netlogon },
	{ "netr_LogonGetDomainInfo", "S.netr_LogonGetDomainInfo(server_name, computer_name, credential, return_authenticator, level, query) -> (return_authenticator, info)", (py_dcerpc_call_fn)dcerpc_netr_LogonGetDomainInfo_r, (py_data_pack_fn)pack_py_netr_LogonGetDomainInfo_args_in, (py_data_unpack_fn)unpack_py_netr_LogonGetDomainInfo_args_out, 29, &ndr_table_netlogon },
	{ "netr_ServerPasswordSet2", "S.netr_ServerPasswordSet2(server_name, account_name, secure_channel_type, computer_name, credential, new_password) -> return_authenticator", (py_dcerpc_call_fn)dcerpc_netr_ServerPasswordSet2_r, (py_data_pack_fn)pack_py_netr_ServerPasswordSet2_args_in, (py_data_unpack_fn)unpack_py_netr_ServerPasswordSet2_args_out, 30, &ndr_table_netlogon },
	{ "netr_ServerPasswordGet", "S.netr_ServerPasswordGet(server_name, account_name, secure_channel_type, computer_name, credential) -> (return_authenticator, password)", (py_dcerpc_call_fn)dcerpc_netr_ServerPasswordGet_r, (py_data_pack_fn)pack_py_netr_ServerPasswordGet_args_in, (py_data_unpack_fn)unpack_py_netr_ServerPasswordGet_args_out, 31, &ndr_table_netlogon },
	{ "netr_DsRAddressToSitenamesW", "S.netr_DsRAddressToSitenamesW(server_name, addresses) -> ctr", (py_dcerpc_call_fn)dcerpc_netr_DsRAddressToSitenamesW_r, (py_data_pack_fn)pack_py_netr_DsRAddressToSitenamesW_args_in, (py_data_unpack_fn)unpack_py_netr_DsRAddressToSitenamesW_args_out, 33, &ndr_table_netlogon },
	{ "netr_DsRGetDCNameEx2", "S.netr_DsRGetDCNameEx2(server_unc, client_account, mask, domain_name, domain_guid, site_name, flags) -> info", (py_dcerpc_call_fn)dcerpc_netr_DsRGetDCNameEx2_r, (py_data_pack_fn)pack_py_netr_DsRGetDCNameEx2_args_in, (py_data_unpack_fn)unpack_py_netr_DsRGetDCNameEx2_args_out, 34, &ndr_table_netlogon },
	{ "netr_NetrEnumerateTrustedDomainsEx", "S.netr_NetrEnumerateTrustedDomainsEx(server_name) -> dom_trust_list", (py_dcerpc_call_fn)dcerpc_netr_NetrEnumerateTrustedDomainsEx_r, (py_data_pack_fn)pack_py_netr_NetrEnumerateTrustedDomainsEx_args_in, (py_data_unpack_fn)unpack_py_netr_NetrEnumerateTrustedDomainsEx_args_out, 36, &ndr_table_netlogon },
	{ "netr_DsRAddressToSitenamesExW", "S.netr_DsRAddressToSitenamesExW(server_name, addresses) -> ctr", (py_dcerpc_call_fn)dcerpc_netr_DsRAddressToSitenamesExW_r, (py_data_pack_fn)pack_py_netr_DsRAddressToSitenamesExW_args_in, (py_data_unpack_fn)unpack_py_netr_DsRAddressToSitenamesExW_args_out, 37, &ndr_table_netlogon },
	{ "netr_DsrGetDcSiteCoverageW", "S.netr_DsrGetDcSiteCoverageW(server_name) -> ctr", (py_dcerpc_call_fn)dcerpc_netr_DsrGetDcSiteCoverageW_r, (py_data_pack_fn)pack_py_netr_DsrGetDcSiteCoverageW_args_in, (py_data_unpack_fn)unpack_py_netr_DsrGetDcSiteCoverageW_args_out, 38, &ndr_table_netlogon },
	{ "netr_LogonSamLogonEx", "S.netr_LogonSamLogonEx(server_name, computer_name, logon_level, logon, validation_level, flags) -> (validation, authoritative, flags)", (py_dcerpc_call_fn)dcerpc_netr_LogonSamLogonEx_r, (py_data_pack_fn)pack_py_netr_LogonSamLogonEx_args_in, (py_data_unpack_fn)unpack_py_netr_LogonSamLogonEx_args_out, 39, &ndr_table_netlogon },
	{ "netr_DsrEnumerateDomainTrusts", "S.netr_DsrEnumerateDomainTrusts(server_name, trust_flags) -> trusts", (py_dcerpc_call_fn)dcerpc_netr_DsrEnumerateDomainTrusts_r, (py_data_pack_fn)pack_py_netr_DsrEnumerateDomainTrusts_args_in, (py_data_unpack_fn)unpack_py_netr_DsrEnumerateDomainTrusts_args_out, 40, &ndr_table_netlogon },
	{ "netr_DsrDeregisterDNSHostRecords", "S.netr_DsrDeregisterDNSHostRecords(server_name, domain, domain_guid, dsa_guid, dns_host) -> None", (py_dcerpc_call_fn)dcerpc_netr_DsrDeregisterDNSHostRecords_r, (py_data_pack_fn)pack_py_netr_DsrDeregisterDNSHostRecords_args_in, (py_data_unpack_fn)unpack_py_netr_DsrDeregisterDNSHostRecords_args_out, 41, &ndr_table_netlogon },
	{ "netr_ServerTrustPasswordsGet", "S.netr_ServerTrustPasswordsGet(server_name, account_name, secure_channel_type, computer_name, credential) -> (return_authenticator, password, password2)", (py_dcerpc_call_fn)dcerpc_netr_ServerTrustPasswordsGet_r, (py_data_pack_fn)pack_py_netr_ServerTrustPasswordsGet_args_in, (py_data_unpack_fn)unpack_py_netr_ServerTrustPasswordsGet_args_out, 42, &ndr_table_netlogon },
	{ "netr_DsRGetForestTrustInformation", "S.netr_DsRGetForestTrustInformation(server_name, trusted_domain_name, flags) -> forest_trust_info", (py_dcerpc_call_fn)dcerpc_netr_DsRGetForestTrustInformation_r, (py_data_pack_fn)pack_py_netr_DsRGetForestTrustInformation_args_in, (py_data_unpack_fn)unpack_py_netr_DsRGetForestTrustInformation_args_out, 43, &ndr_table_netlogon },
	{ "netr_GetForestTrustInformation", "S.netr_GetForestTrustInformation(server_name, computer_name, credential, flags) -> (return_authenticator, forest_trust_info)", (py_dcerpc_call_fn)dcerpc_netr_GetForestTrustInformation_r, (py_data_pack_fn)pack_py_netr_GetForestTrustInformation_args_in, (py_data_unpack_fn)unpack_py_netr_GetForestTrustInformation_args_out, 44, &ndr_table_netlogon },
	{ "netr_LogonSamLogonWithFlags", "S.netr_LogonSamLogonWithFlags(server_name, computer_name, credential, return_authenticator, logon_level, logon, validation_level, flags) -> (return_authenticator, validation, authoritative, flags)", (py_dcerpc_call_fn)dcerpc_netr_LogonSamLogonWithFlags_r, (py_data_pack_fn)pack_py_netr_LogonSamLogonWithFlags_args_in, (py_data_unpack_fn)unpack_py_netr_LogonSamLogonWithFlags_args_out, 45, &ndr_table_netlogon },
	{ "netr_ServerGetTrustInfo", "S.netr_ServerGetTrustInfo(server_name, account_name, secure_channel_type, computer_name, credential) -> (return_authenticator, new_owf_password, old_owf_password, trust_info)", (py_dcerpc_call_fn)dcerpc_netr_ServerGetTrustInfo_r, (py_data_pack_fn)pack_py_netr_ServerGetTrustInfo_args_in, (py_data_unpack_fn)unpack_py_netr_ServerGetTrustInfo_args_out, 46, &ndr_table_netlogon },
	{ "netr_Unused47", "S.netr_Unused47() -> None", (py_dcerpc_call_fn)dcerpc_netr_Unused47_r, (py_data_pack_fn)pack_py_netr_Unused47_args_in, (py_data_unpack_fn)unpack_py_netr_Unused47_args_out, 47, &ndr_table_netlogon },
	{ "netr_DsrUpdateReadOnlyServerDnsRecords", "S.netr_DsrUpdateReadOnlyServerDnsRecords(server_name, computer_name, credential, site_name, dns_ttl, dns_names) -> (return_authenticator, dns_names)", (py_dcerpc_call_fn)dcerpc_netr_DsrUpdateReadOnlyServerDnsRecords_r, (py_data_pack_fn)pack_py_netr_DsrUpdateReadOnlyServerDnsRecords_args_in, (py_data_unpack_fn)unpack_py_netr_DsrUpdateReadOnlyServerDnsRecords_args_out, 48, &ndr_table_netlogon },
	{ NULL }
};

static PyObject *interface_netlogon_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_netlogon);
}

static PyTypeObject netlogon_InterfaceType = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "netlogon.netlogon",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "netlogon(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n",
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_netlogon_new,
};

static PyMethodDef netlogon_methods[] = {
	{ NULL, NULL, 0, NULL }
};

void initnetlogon(void)
{
	PyObject *m;
	PyObject *dep_samba_dcerpc_security;
	PyObject *dep_samba_dcerpc_misc;
	PyObject *dep_samba_dcerpc_samr;
	PyObject *dep_talloc;
	PyObject *dep_samba_dcerpc_lsa;
	PyObject *dep_samba_dcerpc_base;

	dep_samba_dcerpc_security = PyImport_ImportModule("samba.dcerpc.security");
	if (dep_samba_dcerpc_security == NULL)
		return;

	dep_samba_dcerpc_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_samba_dcerpc_misc == NULL)
		return;

	dep_samba_dcerpc_samr = PyImport_ImportModule("samba.dcerpc.samr");
	if (dep_samba_dcerpc_samr == NULL)
		return;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		return;

	dep_samba_dcerpc_lsa = PyImport_ImportModule("samba.dcerpc.lsa");
	if (dep_samba_dcerpc_lsa == NULL)
		return;

	dep_samba_dcerpc_base = PyImport_ImportModule("samba.dcerpc.base");
	if (dep_samba_dcerpc_base == NULL)
		return;

	GUID_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "GUID");
	if (GUID_Type == NULL)
		return;

	samr_Password_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_samr, "Password");
	if (samr_Password_Type == NULL)
		return;

	sec_desc_buf_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_security, "sec_desc_buf");
	if (sec_desc_buf_Type == NULL)
		return;

	samr_RidWithAttributeArray_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_samr, "RidWithAttributeArray");
	if (samr_RidWithAttributeArray_Type == NULL)
		return;

	Object_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "Object");
	if (Object_Type == NULL)
		return;

	ClientConnection_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_base, "ClientConnection");
	if (ClientConnection_Type == NULL)
		return;

	lsa_StringLarge_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_lsa, "StringLarge");
	if (lsa_StringLarge_Type == NULL)
		return;

	lsa_SidArray_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_lsa, "SidArray");
	if (lsa_SidArray_Type == NULL)
		return;

	lsa_BinaryString_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_lsa, "BinaryString");
	if (lsa_BinaryString_Type == NULL)
		return;

	lsa_String_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_lsa, "String");
	if (lsa_String_Type == NULL)
		return;

	lsa_ForestTrustInformation_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_lsa, "ForestTrustInformation");
	if (lsa_ForestTrustInformation_Type == NULL)
		return;

	dom_sid_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_security, "dom_sid");
	if (dom_sid_Type == NULL)
		return;

	samr_LogonHours_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_samr, "LogonHours");
	if (samr_LogonHours_Type == NULL)
		return;

	netr_UasInfo_Type.tp_base = Object_Type;

	netr_UasLogoffInfo_Type.tp_base = Object_Type;

	netr_AcctLockStr_Type.tp_base = Object_Type;

	netr_IdentityInfo_Type.tp_base = Object_Type;

	netr_PasswordInfo_Type.tp_base = Object_Type;

	netr_ChallengeResponse_Type.tp_base = Object_Type;

	netr_NetworkInfo_Type.tp_base = Object_Type;

	netr_GenericInfo_Type.tp_base = Object_Type;

	netr_UserSessionKey_Type.tp_base = Object_Type;

	netr_LMSessionKey_Type.tp_base = Object_Type;

	netr_SamBaseInfo_Type.tp_base = Object_Type;

	netr_SamInfo2_Type.tp_base = Object_Type;

	netr_SidAttr_Type.tp_base = Object_Type;

	netr_SamInfo3_Type.tp_base = Object_Type;

	netr_SamInfo6_Type.tp_base = Object_Type;

	netr_PacInfo_Type.tp_base = Object_Type;

	netr_GenericInfo2_Type.tp_base = Object_Type;

	netr_Credential_Type.tp_base = Object_Type;

	netr_Authenticator_Type.tp_base = Object_Type;

	netr_DELTA_DELETE_USER_Type.tp_base = Object_Type;

	netr_USER_KEY16_Type.tp_base = Object_Type;

	netr_PasswordHistory_Type.tp_base = Object_Type;

	netr_USER_KEYS2_Type.tp_base = Object_Type;

	netr_USER_KEY_UNION_Type.tp_base = Object_Type;

	netr_USER_KEYS_Type.tp_base = Object_Type;

	netr_USER_PRIVATE_INFO_Type.tp_base = Object_Type;

	netr_DELTA_USER_Type.tp_base = Object_Type;

	netr_DELTA_DOMAIN_Type.tp_base = Object_Type;

	netr_DELTA_GROUP_Type.tp_base = Object_Type;

	netr_DELTA_RENAME_Type.tp_base = Object_Type;

	netr_DELTA_GROUP_MEMBER_Type.tp_base = Object_Type;

	netr_DELTA_ALIAS_Type.tp_base = Object_Type;

	netr_DELTA_ALIAS_MEMBER_Type.tp_base = Object_Type;

	netr_QUOTA_LIMITS_Type.tp_base = Object_Type;

	netr_DELTA_POLICY_Type.tp_base = Object_Type;

	netr_DELTA_TRUSTED_DOMAIN_Type.tp_base = Object_Type;

	netr_DELTA_ACCOUNT_Type.tp_base = Object_Type;

	netr_CIPHER_VALUE_Type.tp_base = Object_Type;

	netr_DELTA_SECRET_Type.tp_base = Object_Type;

	netr_DELTA_ENUM_Type.tp_base = Object_Type;

	netr_DELTA_ENUM_ARRAY_Type.tp_base = Object_Type;

	netr_UAS_INFO_0_Type.tp_base = Object_Type;

	netr_AccountBuffer_Type.tp_base = Object_Type;

	netr_NETLOGON_INFO_1_Type.tp_base = Object_Type;

	netr_NETLOGON_INFO_2_Type.tp_base = Object_Type;

	netr_NETLOGON_INFO_3_Type.tp_base = Object_Type;

	netr_NETLOGON_INFO_4_Type.tp_base = Object_Type;

	netr_ChangeLogEntry_Type.tp_base = Object_Type;

	netr_Blob_Type.tp_base = Object_Type;

	netr_DsRGetDCNameInfo_Type.tp_base = Object_Type;

	netr_LsaPolicyInformation_Type.tp_base = Object_Type;

	netr_OsVersionInfoEx_Type.tp_base = Object_Type;

	netr_OsVersion_Type.tp_base = Object_Type;

	netr_OsVersionContainer_Type.tp_base = Object_Type;

	netr_WorkstationInformation_Type.tp_base = Object_Type;

	netr_trust_extension_Type.tp_base = Object_Type;

	netr_trust_extension_container_Type.tp_base = Object_Type;

	netr_OneDomainInfo_Type.tp_base = Object_Type;

	netr_DomainInformation_Type.tp_base = Object_Type;

	NL_PASSWORD_VERSION_Type.tp_base = Object_Type;

	netr_CryptPassword_Type.tp_base = Object_Type;

	netr_DsRAddressToSitenamesWCtr_Type.tp_base = Object_Type;

	netr_DsRAddress_Type.tp_base = Object_Type;

	netr_DomainTrust_Type.tp_base = Object_Type;

	netr_DomainTrustList_Type.tp_base = Object_Type;

	netr_DsRAddressToSitenamesExWCtr_Type.tp_base = Object_Type;

	DcSitesCtr_Type.tp_base = Object_Type;

	netr_TrustInfo_Type.tp_base = Object_Type;

	NL_DNS_NAME_INFO_Type.tp_base = Object_Type;

	NL_DNS_NAME_INFO_ARRAY_Type.tp_base = Object_Type;

	netlogon_InterfaceType.tp_base = ClientConnection_Type;

	if (PyType_Ready(&netr_UasInfo_Type) < 0)
		return;
	if (PyType_Ready(&netr_UasLogoffInfo_Type) < 0)
		return;
	if (PyType_Ready(&netr_AcctLockStr_Type) < 0)
		return;
	if (PyType_Ready(&netr_IdentityInfo_Type) < 0)
		return;
	if (PyType_Ready(&netr_PasswordInfo_Type) < 0)
		return;
	if (PyType_Ready(&netr_ChallengeResponse_Type) < 0)
		return;
	if (PyType_Ready(&netr_NetworkInfo_Type) < 0)
		return;
	if (PyType_Ready(&netr_GenericInfo_Type) < 0)
		return;
	if (PyType_Ready(&netr_UserSessionKey_Type) < 0)
		return;
	if (PyType_Ready(&netr_LMSessionKey_Type) < 0)
		return;
	if (PyType_Ready(&netr_SamBaseInfo_Type) < 0)
		return;
	if (PyType_Ready(&netr_SamInfo2_Type) < 0)
		return;
	if (PyType_Ready(&netr_SidAttr_Type) < 0)
		return;
	if (PyType_Ready(&netr_SamInfo3_Type) < 0)
		return;
	if (PyType_Ready(&netr_SamInfo6_Type) < 0)
		return;
	if (PyType_Ready(&netr_PacInfo_Type) < 0)
		return;
	if (PyType_Ready(&netr_GenericInfo2_Type) < 0)
		return;
	if (PyType_Ready(&netr_Credential_Type) < 0)
		return;
	if (PyType_Ready(&netr_Authenticator_Type) < 0)
		return;
	if (PyType_Ready(&netr_DELTA_DELETE_USER_Type) < 0)
		return;
	if (PyType_Ready(&netr_USER_KEY16_Type) < 0)
		return;
	if (PyType_Ready(&netr_PasswordHistory_Type) < 0)
		return;
	if (PyType_Ready(&netr_USER_KEYS2_Type) < 0)
		return;
	if (PyType_Ready(&netr_USER_KEY_UNION_Type) < 0)
		return;
	if (PyType_Ready(&netr_USER_KEYS_Type) < 0)
		return;
	if (PyType_Ready(&netr_USER_PRIVATE_INFO_Type) < 0)
		return;
	if (PyType_Ready(&netr_DELTA_USER_Type) < 0)
		return;
	if (PyType_Ready(&netr_DELTA_DOMAIN_Type) < 0)
		return;
	if (PyType_Ready(&netr_DELTA_GROUP_Type) < 0)
		return;
	if (PyType_Ready(&netr_DELTA_RENAME_Type) < 0)
		return;
	if (PyType_Ready(&netr_DELTA_GROUP_MEMBER_Type) < 0)
		return;
	if (PyType_Ready(&netr_DELTA_ALIAS_Type) < 0)
		return;
	if (PyType_Ready(&netr_DELTA_ALIAS_MEMBER_Type) < 0)
		return;
	if (PyType_Ready(&netr_QUOTA_LIMITS_Type) < 0)
		return;
	if (PyType_Ready(&netr_DELTA_POLICY_Type) < 0)
		return;
	if (PyType_Ready(&netr_DELTA_TRUSTED_DOMAIN_Type) < 0)
		return;
	if (PyType_Ready(&netr_DELTA_ACCOUNT_Type) < 0)
		return;
	if (PyType_Ready(&netr_CIPHER_VALUE_Type) < 0)
		return;
	if (PyType_Ready(&netr_DELTA_SECRET_Type) < 0)
		return;
	if (PyType_Ready(&netr_DELTA_ENUM_Type) < 0)
		return;
	if (PyType_Ready(&netr_DELTA_ENUM_ARRAY_Type) < 0)
		return;
	if (PyType_Ready(&netr_UAS_INFO_0_Type) < 0)
		return;
	if (PyType_Ready(&netr_AccountBuffer_Type) < 0)
		return;
	if (PyType_Ready(&netr_NETLOGON_INFO_1_Type) < 0)
		return;
	if (PyType_Ready(&netr_NETLOGON_INFO_2_Type) < 0)
		return;
	if (PyType_Ready(&netr_NETLOGON_INFO_3_Type) < 0)
		return;
	if (PyType_Ready(&netr_NETLOGON_INFO_4_Type) < 0)
		return;
	if (PyType_Ready(&netr_ChangeLogEntry_Type) < 0)
		return;
	if (PyType_Ready(&netr_Blob_Type) < 0)
		return;
	if (PyType_Ready(&netr_DsRGetDCNameInfo_Type) < 0)
		return;
	if (PyType_Ready(&netr_LsaPolicyInformation_Type) < 0)
		return;
	if (PyType_Ready(&netr_OsVersionInfoEx_Type) < 0)
		return;
	if (PyType_Ready(&netr_OsVersion_Type) < 0)
		return;
	if (PyType_Ready(&netr_OsVersionContainer_Type) < 0)
		return;
	if (PyType_Ready(&netr_WorkstationInformation_Type) < 0)
		return;
	if (PyType_Ready(&netr_trust_extension_Type) < 0)
		return;
	if (PyType_Ready(&netr_trust_extension_container_Type) < 0)
		return;
	if (PyType_Ready(&netr_OneDomainInfo_Type) < 0)
		return;
	if (PyType_Ready(&netr_DomainInformation_Type) < 0)
		return;
	if (PyType_Ready(&NL_PASSWORD_VERSION_Type) < 0)
		return;
	if (PyType_Ready(&netr_CryptPassword_Type) < 0)
		return;
	if (PyType_Ready(&netr_DsRAddressToSitenamesWCtr_Type) < 0)
		return;
	if (PyType_Ready(&netr_DsRAddress_Type) < 0)
		return;
	if (PyType_Ready(&netr_DomainTrust_Type) < 0)
		return;
	if (PyType_Ready(&netr_DomainTrustList_Type) < 0)
		return;
	if (PyType_Ready(&netr_DsRAddressToSitenamesExWCtr_Type) < 0)
		return;
	if (PyType_Ready(&DcSitesCtr_Type) < 0)
		return;
	if (PyType_Ready(&netr_TrustInfo_Type) < 0)
		return;
	if (PyType_Ready(&NL_DNS_NAME_INFO_Type) < 0)
		return;
	if (PyType_Ready(&NL_DNS_NAME_INFO_ARRAY_Type) < 0)
		return;
	if (PyType_Ready(&netlogon_InterfaceType) < 0)
		return;
	if (!PyInterface_AddNdrRpcMethods(&netlogon_InterfaceType, py_ndr_netlogon_methods))
		return;

#ifdef PY_NETR_UASINFO_PATCH
	PY_NETR_UASINFO_PATCH(&netr_UasInfo_Type);
#endif
#ifdef PY_NETR_UASLOGOFFINFO_PATCH
	PY_NETR_UASLOGOFFINFO_PATCH(&netr_UasLogoffInfo_Type);
#endif
#ifdef PY_NETR_ACCTLOCKSTR_PATCH
	PY_NETR_ACCTLOCKSTR_PATCH(&netr_AcctLockStr_Type);
#endif
#ifdef PY_NETR_IDENTITYINFO_PATCH
	PY_NETR_IDENTITYINFO_PATCH(&netr_IdentityInfo_Type);
#endif
#ifdef PY_NETR_PASSWORDINFO_PATCH
	PY_NETR_PASSWORDINFO_PATCH(&netr_PasswordInfo_Type);
#endif
#ifdef PY_NETR_CHALLENGERESPONSE_PATCH
	PY_NETR_CHALLENGERESPONSE_PATCH(&netr_ChallengeResponse_Type);
#endif
#ifdef PY_NETR_NETWORKINFO_PATCH
	PY_NETR_NETWORKINFO_PATCH(&netr_NetworkInfo_Type);
#endif
#ifdef PY_NETR_GENERICINFO_PATCH
	PY_NETR_GENERICINFO_PATCH(&netr_GenericInfo_Type);
#endif
#ifdef PY_NETR_USERSESSIONKEY_PATCH
	PY_NETR_USERSESSIONKEY_PATCH(&netr_UserSessionKey_Type);
#endif
#ifdef PY_NETR_LMSESSIONKEY_PATCH
	PY_NETR_LMSESSIONKEY_PATCH(&netr_LMSessionKey_Type);
#endif
#ifdef PY_NETR_SAMBASEINFO_PATCH
	PY_NETR_SAMBASEINFO_PATCH(&netr_SamBaseInfo_Type);
#endif
#ifdef PY_NETR_SAMINFO2_PATCH
	PY_NETR_SAMINFO2_PATCH(&netr_SamInfo2_Type);
#endif
#ifdef PY_NETR_SIDATTR_PATCH
	PY_NETR_SIDATTR_PATCH(&netr_SidAttr_Type);
#endif
#ifdef PY_NETR_SAMINFO3_PATCH
	PY_NETR_SAMINFO3_PATCH(&netr_SamInfo3_Type);
#endif
#ifdef PY_NETR_SAMINFO6_PATCH
	PY_NETR_SAMINFO6_PATCH(&netr_SamInfo6_Type);
#endif
#ifdef PY_NETR_PACINFO_PATCH
	PY_NETR_PACINFO_PATCH(&netr_PacInfo_Type);
#endif
#ifdef PY_NETR_GENERICINFO2_PATCH
	PY_NETR_GENERICINFO2_PATCH(&netr_GenericInfo2_Type);
#endif
#ifdef PY_NETR_CREDENTIAL_PATCH
	PY_NETR_CREDENTIAL_PATCH(&netr_Credential_Type);
#endif
#ifdef PY_NETR_AUTHENTICATOR_PATCH
	PY_NETR_AUTHENTICATOR_PATCH(&netr_Authenticator_Type);
#endif
#ifdef PY_NETR_DELTA_DELETE_USER_PATCH
	PY_NETR_DELTA_DELETE_USER_PATCH(&netr_DELTA_DELETE_USER_Type);
#endif
#ifdef PY_NETR_USER_KEY16_PATCH
	PY_NETR_USER_KEY16_PATCH(&netr_USER_KEY16_Type);
#endif
#ifdef PY_NETR_PASSWORDHISTORY_PATCH
	PY_NETR_PASSWORDHISTORY_PATCH(&netr_PasswordHistory_Type);
#endif
#ifdef PY_NETR_USER_KEYS2_PATCH
	PY_NETR_USER_KEYS2_PATCH(&netr_USER_KEYS2_Type);
#endif
#ifdef PY_NETR_USER_KEY_UNION_PATCH
	PY_NETR_USER_KEY_UNION_PATCH(&netr_USER_KEY_UNION_Type);
#endif
#ifdef PY_NETR_USER_KEYS_PATCH
	PY_NETR_USER_KEYS_PATCH(&netr_USER_KEYS_Type);
#endif
#ifdef PY_NETR_USER_PRIVATE_INFO_PATCH
	PY_NETR_USER_PRIVATE_INFO_PATCH(&netr_USER_PRIVATE_INFO_Type);
#endif
#ifdef PY_NETR_DELTA_USER_PATCH
	PY_NETR_DELTA_USER_PATCH(&netr_DELTA_USER_Type);
#endif
#ifdef PY_NETR_DELTA_DOMAIN_PATCH
	PY_NETR_DELTA_DOMAIN_PATCH(&netr_DELTA_DOMAIN_Type);
#endif
#ifdef PY_NETR_DELTA_GROUP_PATCH
	PY_NETR_DELTA_GROUP_PATCH(&netr_DELTA_GROUP_Type);
#endif
#ifdef PY_NETR_DELTA_RENAME_PATCH
	PY_NETR_DELTA_RENAME_PATCH(&netr_DELTA_RENAME_Type);
#endif
#ifdef PY_NETR_DELTA_GROUP_MEMBER_PATCH
	PY_NETR_DELTA_GROUP_MEMBER_PATCH(&netr_DELTA_GROUP_MEMBER_Type);
#endif
#ifdef PY_NETR_DELTA_ALIAS_PATCH
	PY_NETR_DELTA_ALIAS_PATCH(&netr_DELTA_ALIAS_Type);
#endif
#ifdef PY_NETR_DELTA_ALIAS_MEMBER_PATCH
	PY_NETR_DELTA_ALIAS_MEMBER_PATCH(&netr_DELTA_ALIAS_MEMBER_Type);
#endif
#ifdef PY_NETR_QUOTA_LIMITS_PATCH
	PY_NETR_QUOTA_LIMITS_PATCH(&netr_QUOTA_LIMITS_Type);
#endif
#ifdef PY_NETR_DELTA_POLICY_PATCH
	PY_NETR_DELTA_POLICY_PATCH(&netr_DELTA_POLICY_Type);
#endif
#ifdef PY_NETR_DELTA_TRUSTED_DOMAIN_PATCH
	PY_NETR_DELTA_TRUSTED_DOMAIN_PATCH(&netr_DELTA_TRUSTED_DOMAIN_Type);
#endif
#ifdef PY_NETR_DELTA_ACCOUNT_PATCH
	PY_NETR_DELTA_ACCOUNT_PATCH(&netr_DELTA_ACCOUNT_Type);
#endif
#ifdef PY_NETR_CIPHER_VALUE_PATCH
	PY_NETR_CIPHER_VALUE_PATCH(&netr_CIPHER_VALUE_Type);
#endif
#ifdef PY_NETR_DELTA_SECRET_PATCH
	PY_NETR_DELTA_SECRET_PATCH(&netr_DELTA_SECRET_Type);
#endif
#ifdef PY_NETR_DELTA_ENUM_PATCH
	PY_NETR_DELTA_ENUM_PATCH(&netr_DELTA_ENUM_Type);
#endif
#ifdef PY_NETR_DELTA_ENUM_ARRAY_PATCH
	PY_NETR_DELTA_ENUM_ARRAY_PATCH(&netr_DELTA_ENUM_ARRAY_Type);
#endif
#ifdef PY_NETR_UAS_INFO_0_PATCH
	PY_NETR_UAS_INFO_0_PATCH(&netr_UAS_INFO_0_Type);
#endif
#ifdef PY_NETR_ACCOUNTBUFFER_PATCH
	PY_NETR_ACCOUNTBUFFER_PATCH(&netr_AccountBuffer_Type);
#endif
#ifdef PY_NETR_NETLOGON_INFO_1_PATCH
	PY_NETR_NETLOGON_INFO_1_PATCH(&netr_NETLOGON_INFO_1_Type);
#endif
#ifdef PY_NETR_NETLOGON_INFO_2_PATCH
	PY_NETR_NETLOGON_INFO_2_PATCH(&netr_NETLOGON_INFO_2_Type);
#endif
#ifdef PY_NETR_NETLOGON_INFO_3_PATCH
	PY_NETR_NETLOGON_INFO_3_PATCH(&netr_NETLOGON_INFO_3_Type);
#endif
#ifdef PY_NETR_NETLOGON_INFO_4_PATCH
	PY_NETR_NETLOGON_INFO_4_PATCH(&netr_NETLOGON_INFO_4_Type);
#endif
#ifdef PY_NETR_CHANGELOGENTRY_PATCH
	PY_NETR_CHANGELOGENTRY_PATCH(&netr_ChangeLogEntry_Type);
#endif
#ifdef PY_NETR_BLOB_PATCH
	PY_NETR_BLOB_PATCH(&netr_Blob_Type);
#endif
#ifdef PY_NETR_DSRGETDCNAMEINFO_PATCH
	PY_NETR_DSRGETDCNAMEINFO_PATCH(&netr_DsRGetDCNameInfo_Type);
#endif
#ifdef PY_NETR_LSAPOLICYINFORMATION_PATCH
	PY_NETR_LSAPOLICYINFORMATION_PATCH(&netr_LsaPolicyInformation_Type);
#endif
#ifdef PY_NETR_OSVERSIONINFOEX_PATCH
	PY_NETR_OSVERSIONINFOEX_PATCH(&netr_OsVersionInfoEx_Type);
#endif
#ifdef PY_NETR_OSVERSION_PATCH
	PY_NETR_OSVERSION_PATCH(&netr_OsVersion_Type);
#endif
#ifdef PY_NETR_OSVERSIONCONTAINER_PATCH
	PY_NETR_OSVERSIONCONTAINER_PATCH(&netr_OsVersionContainer_Type);
#endif
#ifdef PY_NETR_WORKSTATIONINFORMATION_PATCH
	PY_NETR_WORKSTATIONINFORMATION_PATCH(&netr_WorkstationInformation_Type);
#endif
#ifdef PY_NETR_TRUST_EXTENSION_PATCH
	PY_NETR_TRUST_EXTENSION_PATCH(&netr_trust_extension_Type);
#endif
#ifdef PY_NETR_TRUST_EXTENSION_CONTAINER_PATCH
	PY_NETR_TRUST_EXTENSION_CONTAINER_PATCH(&netr_trust_extension_container_Type);
#endif
#ifdef PY_NETR_ONEDOMAININFO_PATCH
	PY_NETR_ONEDOMAININFO_PATCH(&netr_OneDomainInfo_Type);
#endif
#ifdef PY_NETR_DOMAININFORMATION_PATCH
	PY_NETR_DOMAININFORMATION_PATCH(&netr_DomainInformation_Type);
#endif
#ifdef PY_NL_PASSWORD_VERSION_PATCH
	PY_NL_PASSWORD_VERSION_PATCH(&NL_PASSWORD_VERSION_Type);
#endif
#ifdef PY_NETR_CRYPTPASSWORD_PATCH
	PY_NETR_CRYPTPASSWORD_PATCH(&netr_CryptPassword_Type);
#endif
#ifdef PY_NETR_DSRADDRESSTOSITENAMESWCTR_PATCH
	PY_NETR_DSRADDRESSTOSITENAMESWCTR_PATCH(&netr_DsRAddressToSitenamesWCtr_Type);
#endif
#ifdef PY_NETR_DSRADDRESS_PATCH
	PY_NETR_DSRADDRESS_PATCH(&netr_DsRAddress_Type);
#endif
#ifdef PY_NETR_DOMAINTRUST_PATCH
	PY_NETR_DOMAINTRUST_PATCH(&netr_DomainTrust_Type);
#endif
#ifdef PY_NETR_DOMAINTRUSTLIST_PATCH
	PY_NETR_DOMAINTRUSTLIST_PATCH(&netr_DomainTrustList_Type);
#endif
#ifdef PY_NETR_DSRADDRESSTOSITENAMESEXWCTR_PATCH
	PY_NETR_DSRADDRESSTOSITENAMESEXWCTR_PATCH(&netr_DsRAddressToSitenamesExWCtr_Type);
#endif
#ifdef PY_DCSITESCTR_PATCH
	PY_DCSITESCTR_PATCH(&DcSitesCtr_Type);
#endif
#ifdef PY_NETR_TRUSTINFO_PATCH
	PY_NETR_TRUSTINFO_PATCH(&netr_TrustInfo_Type);
#endif
#ifdef PY_NL_DNS_NAME_INFO_PATCH
	PY_NL_DNS_NAME_INFO_PATCH(&NL_DNS_NAME_INFO_Type);
#endif
#ifdef PY_NL_DNS_NAME_INFO_ARRAY_PATCH
	PY_NL_DNS_NAME_INFO_ARRAY_PATCH(&NL_DNS_NAME_INFO_ARRAY_Type);
#endif
#ifdef PY_NETLOGON_PATCH
	PY_NETLOGON_PATCH(&netlogon_InterfaceType);
#endif

	m = Py_InitModule3("netlogon", netlogon_methods, "netlogon DCE/RPC");
	if (m == NULL)
		return;

	PyModule_AddObject(m, "DS_GOOD_TIMESERV_PREFERRED", PyInt_FromLong(DS_GOOD_TIMESERV_PREFERRED));
	PyModule_AddObject(m, "NlDnsGcAtSite", PyInt_FromLong(NlDnsGcAtSite));
	PyModule_AddObject(m, "DS_PDC_REQUIRED", PyInt_FromLong(DS_PDC_REQUIRED));
	PyModule_AddObject(m, "NETR_DELTA_ALIAS_MEMBER", PyInt_FromLong(NETR_DELTA_ALIAS_MEMBER));
	PyModule_AddObject(m, "NetlogonValidationSamInfo2", PyInt_FromLong(NetlogonValidationSamInfo2));
	PyModule_AddObject(m, "NlDnsKdcAtSite", PyInt_FromLong(NlDnsKdcAtSite));
	PyModule_AddObject(m, "NETLOGON_VERIFY_STATUS_RETURNED", PyInt_FromLong(NETLOGON_VERIFY_STATUS_RETURNED));
	PyModule_AddObject(m, "NetlogonInteractiveTransitiveInformation", PyInt_FromLong(NetlogonInteractiveTransitiveInformation));
	PyModule_AddObject(m, "NETLOGON_RESOURCE_GROUPS", PyInt_FromLong(NETLOGON_RESOURCE_GROUPS));
	PyModule_AddObject(m, "NETLOGON_NEG_SCHANNEL", PyInt_FromLong(NETLOGON_NEG_AUTHENTICATED_RPC));
	PyModule_AddObject(m, "DS_KDC_REQUIRED", PyInt_FromLong(DS_KDC_REQUIRED));
	PyModule_AddObject(m, "NETLOGON_NEG_REDO", PyInt_FromLong(NETLOGON_NEG_REDO));
	PyModule_AddObject(m, "NetlogonServiceInformation", PyInt_FromLong(NetlogonServiceInformation));
	PyModule_AddObject(m, "NETR_DELTA_DOMAIN", PyInt_FromLong(NETR_DELTA_DOMAIN));
	PyModule_AddObject(m, "NETR_DELTA_DELETE_ACCOUNT", PyInt_FromLong(NETR_DELTA_DELETE_ACCOUNT));
	PyModule_AddObject(m, "NetlogonValidationSamInfo4", PyInt_FromLong(NetlogonValidationSamInfo4));
	PyModule_AddObject(m, "NETLOGON_NEG_FULL_SYNC_REPL", PyInt_FromLong(NETLOGON_NEG_FULL_SYNC_REPL));
	PyModule_AddObject(m, "NetlogonInteractiveInformation", PyInt_FromLong(NetlogonInteractiveInformation));
	PyModule_AddObject(m, "NETR_DELTA_ACCOUNT", PyInt_FromLong(NETR_DELTA_ACCOUNT));
	PyModule_AddObject(m, "DS_WRITABLE_REQUIRED", PyInt_FromLong(DS_WRITABLE_REQUIRED));
	PyModule_AddObject(m, "DS_SERVER_NDNC", PyInt_FromLong(DS_SERVER_NDNC));
	PyModule_AddObject(m, "NETR_CHANGELOG_FIRST_PROMOTION_OBJ", PyInt_FromLong(NETR_CHANGELOG_FIRST_PROMOTION_OBJ));
	PyModule_AddObject(m, "NETLOGON_CONTROL_PDC_REPLICATE", PyInt_FromLong(NETLOGON_CONTROL_PDC_REPLICATE));
	PyModule_AddObject(m, "MSV1_0_RETURN_PROFILE_PATH", PyInt_FromLong(MSV1_0_RETURN_PROFILE_PATH));
	PyModule_AddObject(m, "NETLOGON_CONTROL_TC_QUERY", PyInt_FromLong(NETLOGON_CONTROL_TC_QUERY));
	PyModule_AddObject(m, "NETLOGON_CONTROL_QUERY_DNS_REG", PyInt_FromLong(NETLOGON_CONTROL_QUERY_DNS_REG));
	PyModule_AddObject(m, "DS_SERVER_SELECT_SECRET_DOMAIN_6", PyInt_FromLong(DS_SERVER_SELECT_SECRET_DOMAIN_6));
	PyModule_AddObject(m, "NETR_TRUST_FLAG_IN_FOREST", PyInt_FromLong(NETR_TRUST_FLAG_IN_FOREST));
	PyModule_AddObject(m, "NETR_CHANGELOG_NAME_INCLUDED", PyInt_FromLong(NETR_CHANGELOG_NAME_INCLUDED));
	PyModule_AddObject(m, "MSV1_0_ALLOW_WORKSTATION_TRUST_ACCOUNT", PyInt_FromLong(MSV1_0_ALLOW_WORKSTATION_TRUST_ACCOUNT));
	PyModule_AddObject(m, "NETR_VER_SUITE_SMALLBUSINESS_RESTRICTED", PyInt_FromLong(NETR_VER_SUITE_SMALLBUSINESS_RESTRICTED));
	PyModule_AddObject(m, "MSV1_0_RETURN_USER_PARAMETERS", PyInt_FromLong(MSV1_0_RETURN_USER_PARAMETERS));
	PyModule_AddObject(m, "NETR_DELTA_POLICY", PyInt_FromLong(NETR_DELTA_POLICY));
	PyModule_AddObject(m, "NETR_TRUST_TYPE_UPLEVEL", PyInt_FromLong(NETR_TRUST_TYPE_UPLEVEL));
	PyModule_AddObject(m, "NetlogonValidationSamInfo", PyInt_FromLong(NetlogonValidationSamInfo));
	PyModule_AddObject(m, "DS_TRY_NEXTCLOSEST_SITE", PyInt_FromLong(DS_TRY_NEXTCLOSEST_SITE));
	PyModule_AddObject(m, "DS_SERVER_LDAP", PyInt_FromLong(DS_SERVER_LDAP));
	PyModule_AddObject(m, "NETLOGON_NEG_AVOID_ACCOUNT_DB_REPL", PyInt_FromLong(NETLOGON_NEG_AVOID_ACCOUNT_DB_REPL));
	PyModule_AddObject(m, "NlDnsDomainNameAlias", PyInt_FromLong(NlDnsDomainNameAlias));
	PyModule_AddObject(m, "NETLOGON_NEG_SUPPORTS_AES", PyInt_FromLong(NETLOGON_NEG_SUPPORTS_AES));
	PyModule_AddObject(m, "MSV1_0_CLEARTEXT_PASSWORD_SUPPLIED", PyInt_FromLong(MSV1_0_CLEARTEXT_PASSWORD_SUPPLIED));
	PyModule_AddObject(m, "NETR_DELTA_SECRET", PyInt_FromLong(NETR_DELTA_SECRET));
	PyModule_AddObject(m, "NETR_TRUST_ATTRIBUTE_FOREST_TRANSITIVE", PyInt_FromLong(NETR_TRUST_ATTRIBUTE_FOREST_TRANSITIVE));
	PyModule_AddObject(m, "NETR_VER_SUITE_ENTERPRISE", PyInt_FromLong(NETR_VER_SUITE_ENTERPRISE));
	PyModule_AddObject(m, "NETLOGON_NEG_ACCOUNT_LOCKOUT", PyInt_FromLong(NETLOGON_NEG_ACCOUNT_LOCKOUT));
	PyModule_AddObject(m, "NlDnsInfoTypeNone", PyInt_FromLong(NlDnsInfoTypeNone));
	PyModule_AddObject(m, "SYNCSTATE_DOMAIN_STATE", PyInt_FromLong(SYNCSTATE_DOMAIN_STATE));
	PyModule_AddObject(m, "NETLOGON_USED_LM_PASSWORD", PyInt_FromLong(NETLOGON_USED_LM_PASSWORD));
	PyModule_AddObject(m, "NETLOGON_CONTROL_FIND_USER", PyInt_FromLong(NETLOGON_CONTROL_FIND_USER));
	PyModule_AddObject(m, "SYNCSTATE_ALIAS_STATE", PyInt_FromLong(SYNCSTATE_ALIAS_STATE));
	PyModule_AddObject(m, "NETR_TRUST_ATTRIBUTE_NON_TRANSITIVE", PyInt_FromLong(NETR_TRUST_ATTRIBUTE_NON_TRANSITIVE));
	PyModule_AddObject(m, "SYNCSTATE_GROUP_STATE", PyInt_FromLong(SYNCSTATE_GROUP_STATE));
	PyModule_AddObject(m, "SYNCSTATE_NORMAL_STATE", PyInt_FromLong(SYNCSTATE_NORMAL_STATE));
	PyModule_AddObject(m, "NETLOGON_NEG_GETDOMAININFO", PyInt_FromLong(NETLOGON_NEG_GETDOMAININFO));
	PyModule_AddObject(m, "NETLOGON_CONTROL_BACKUP_CHANGE_LOG", PyInt_FromLong(NETLOGON_CONTROL_BACKUP_CHANGE_LOG));
	PyModule_AddObject(m, "NETR_TRUST_FLAG_OUTBOUND", PyInt_FromLong(NETR_TRUST_FLAG_OUTBOUND));
	PyModule_AddObject(m, "NlDnsForestName", PyInt_FromLong(NlDnsForestName));
	PyModule_AddObject(m, "NETLOGON_NEG_NEUTRALIZE_NT4_EMULATION", PyInt_FromLong(NETLOGON_NEG_NEUTRALIZE_NT4_EMULATION));
	PyModule_AddObject(m, "NETLOGON_NEG_RODC_PASSTHROUGH", PyInt_FromLong(NETLOGON_NEG_RODC_PASSTHROUGH));
	PyModule_AddObject(m, "DS_AVOID_SELF", PyInt_FromLong(DS_AVOID_SELF));
	PyModule_AddObject(m, "MSV1_0_DONT_TRY_GUEST_ACCOUNT", PyInt_FromLong(MSV1_0_DONT_TRY_GUEST_ACCOUNT));
	PyModule_AddObject(m, "NlDnsRfc1510KdcAtSite", PyInt_FromLong(NlDnsRfc1510KdcAtSite));
	PyModule_AddObject(m, "NETLOGON_NEG_GENERIC_PASSTHROUGH", PyInt_FromLong(NETLOGON_NEG_GENERIC_PASSTHROUGH));
	PyModule_AddObject(m, "SYNCSTATE_UAS_BUILT_IN_GROUP_STATE", PyInt_FromLong(SYNCSTATE_UAS_BUILT_IN_GROUP_STATE));
	PyModule_AddObject(m, "NETLOGON_HAS_IP", PyInt_FromLong(NETLOGON_HAS_IP));
	PyModule_AddObject(m, "NETR_VER_SUITE_SMALLBUSINESS", PyInt_FromLong(NETR_VER_SUITE_SMALLBUSINESS));
	PyModule_AddObject(m, "NETLOGON_NEG_AUTHENTICATED_RPC_LSASS", PyInt_FromLong(NETLOGON_NEG_AUTHENTICATED_RPC_LSASS));
	PyModule_AddObject(m, "DS_BACKGROUND_ONLY", PyInt_FromLong(DS_BACKGROUND_ONLY));
	PyModule_AddObject(m, "NETR_VER_SUITE_BACKOFFICE", PyInt_FromLong(NETR_VER_SUITE_BACKOFFICE));
	PyModule_AddObject(m, "MSV1_0_DISABLE_PERSONAL_FALLBACK", PyInt_FromLong(MSV1_0_DISABLE_PERSONAL_FALLBACK));
	PyModule_AddObject(m, "MSV1_0_CHECK_LOGONHOURS_FOR_S4U", PyInt_FromLong(MSV1_0_CHECK_LOGONHOURS_FOR_S4U));
	PyModule_AddObject(m, "NETR_TRUST_ATTRIBUTE_UPLEVEL_ONLY", PyInt_FromLong(NETR_TRUST_ATTRIBUTE_UPLEVEL_ONLY));
	PyModule_AddObject(m, "NETR_CHANGELOG_SID_INCLUDED", PyInt_FromLong(NETR_CHANGELOG_SID_INCLUDED));
	PyModule_AddObject(m, "NETLOGON_NEG_STRONG_KEYS", PyInt_FromLong(NETLOGON_NEG_STRONG_KEYS));
	PyModule_AddObject(m, "NETLOGON_SUBAUTH_SESSION_KEY", PyInt_FromLong(NETLOGON_SUBAUTH_SESSION_KEY));
	PyModule_AddObject(m, "DS_DIRECTORY_SERVICE_6_REQUIRED", PyInt_FromLong(DS_DIRECTORY_SERVICE_6_REQUIRED));
	PyModule_AddObject(m, "ENC_CRC32", PyInt_FromLong(ENC_CRC32));
	PyModule_AddObject(m, "NETR_VER_SUITE_SINGLEUSERTS", PyInt_FromLong(NETR_VER_SUITE_SINGLEUSERTS));
	PyModule_AddObject(m, "MSV1_0_USE_CLIENT_CHALLENGE", PyInt_FromLong(MSV1_0_USE_CLIENT_CHALLENGE));
	PyModule_AddObject(m, "DS_SERVER_GOOD_TIMESERV", PyInt_FromLong(DS_SERVER_GOOD_TIMESERV));
	PyModule_AddObject(m, "NETLOGON_CONTROL_BREAKPOINT", PyInt_FromLong(NETLOGON_CONTROL_BREAKPOINT));
	PyModule_AddObject(m, "MSV1_0_ALLOW_MSVCHAPV2", PyInt_FromLong(MSV1_0_ALLOW_MSVCHAPV2));
	PyModule_AddObject(m, "NETR_TRUST_FLAG_AES", PyInt_FromLong(NETR_TRUST_FLAG_AES));
	PyModule_AddObject(m, "NlDnsLdapAtSite", PyInt_FromLong(NlDnsLdapAtSite));
	PyModule_AddObject(m, "MSV1_0_TRY_SPECIFIED_DOMAIN_ONLY", PyInt_FromLong(MSV1_0_TRY_SPECIFIED_DOMAIN_ONLY));
	PyModule_AddObject(m, "DS_DIRECTORY_SERVICE_PREFERRED", PyInt_FromLong(DS_DIRECTORY_SERVICE_PREFERRED));
	PyModule_AddObject(m, "NETLOGON_NEG_TRANSITIVE_TRUSTS", PyInt_FromLong(NETLOGON_NEG_TRANSITIVE_TRUSTS));
	PyModule_AddObject(m, "NETLOGON_CONTROL_REDISCOVER", PyInt_FromLong(NETLOGON_CONTROL_REDISCOVER));
	PyModule_AddObject(m, "NETLOGON_NEG_AUTHENTICATED_RPC", PyInt_FromLong(NETLOGON_NEG_AUTHENTICATED_RPC));
	PyModule_AddObject(m, "NETLOGON_CONTROL_TRUNCATE_LOG", PyInt_FromLong(NETLOGON_CONTROL_TRUNCATE_LOG));
	PyModule_AddObject(m, "NETLOGON_GRACE_LOGON", PyInt_FromLong(NETLOGON_GRACE_LOGON));
	PyModule_AddObject(m, "NETR_DELTA_RENAME_GROUP", PyInt_FromLong(NETR_DELTA_RENAME_GROUP));
	PyModule_AddObject(m, "ENC_HMAC_SHA1_96_AES128", PyInt_FromLong(ENC_HMAC_SHA1_96_AES128));
	PyModule_AddObject(m, "NETLOGON_NEG_CONCURRENT_RPC", PyInt_FromLong(NETLOGON_NEG_CONCURRENT_RPC));
	PyModule_AddObject(m, "MSV1_0_TRY_GUEST_ACCOUNT_ONLY", PyInt_FromLong(MSV1_0_TRY_GUEST_ACCOUNT_ONLY));
	PyModule_AddObject(m, "NETLOGON_NEG_SEND_PASSWORD_INFO_PDC", PyInt_FromLong(NETLOGON_NEG_SEND_PASSWORD_INFO_PDC));
	PyModule_AddObject(m, "NETR_TRUST_FLAG_MIT_KRB5", PyInt_FromLong(NETR_TRUST_FLAG_MIT_KRB5));
	PyModule_AddObject(m, "NETR_TRUST_ATTRIBUTE_TREAT_AS_EXTERNAL", PyInt_FromLong(NETR_TRUST_ATTRIBUTE_TREAT_AS_EXTERNAL));
	PyModule_AddObject(m, "NetlogonNetworkInformation", PyInt_FromLong(NetlogonNetworkInformation));
	PyModule_AddObject(m, "NETLOGON_CONTROL_REPLICATE", PyInt_FromLong(NETLOGON_CONTROL_REPLICATE));
	PyModule_AddObject(m, "NETLOGON_FULL_SYNC_REPLICATION", PyInt_FromLong(NETLOGON_FULL_SYNC_REPLICATION));
	PyModule_AddObject(m, "NETR_VER_SUITE_DATACENTER", PyInt_FromLong(NETR_VER_SUITE_DATACENTER));
	PyModule_AddObject(m, "NETR_VER_NT_DOMAIN_CONTROLLER", PyInt_FromLong(NETR_VER_NT_DOMAIN_CONTROLLER));
	PyModule_AddObject(m, "MSV1_0_ALLOW_FORCE_GUEST", PyInt_FromLong(MSV1_0_ALLOW_FORCE_GUEST));
	PyModule_AddObject(m, "NlDnsDsaCname", PyInt_FromLong(NlDnsDsaCname));
	PyModule_AddObject(m, "NETR_VER_NT_SERVER", PyInt_FromLong(NETR_VER_NT_SERVER));
	PyModule_AddObject(m, "DS_TIMESERV_REQUIRED", PyInt_FromLong(DS_TIMESERV_REQUIRED));
	PyModule_AddObject(m, "SYNCSTATE_ALIAS_MEMBER_STATE", PyInt_FromLong(SYNCSTATE_ALIAS_MEMBER_STATE));
	PyModule_AddObject(m, "NETLOGON_CONTROL_TRANSPORT_NOTIFY", PyInt_FromLong(NETLOGON_CONTROL_TRANSPORT_NOTIFY));
	PyModule_AddObject(m, "DS_SERVER_WRITABLE", PyInt_FromLong(DS_SERVER_WRITABLE));
	PyModule_AddObject(m, "DS_IS_FLAT_NAME", PyInt_FromLong(DS_IS_FLAT_NAME));
	PyModule_AddObject(m, "NETLOGON_NEG_CROSS_FOREST_TRUSTS", PyInt_FromLong(NETLOGON_NEG_CROSS_FOREST_TRUSTS));
	PyModule_AddObject(m, "NETLOGON_NEG_MULTIPLE_SIDS", PyInt_FromLong(NETLOGON_NEG_MULTIPLE_SIDS));
	PyModule_AddObject(m, "NETR_DELTA_DELETE_SECRET", PyInt_FromLong(NETR_DELTA_DELETE_SECRET));
	PyModule_AddObject(m, "NETR_VER_NT_WORKSTATION", PyInt_FromLong(NETR_VER_NT_WORKSTATION));
	PyModule_AddObject(m, "ENC_HMAC_SHA1_96_AES256", PyInt_FromLong(ENC_HMAC_SHA1_96_AES256));
	PyModule_AddObject(m, "NETR_DELTA_TRUSTED_DOMAIN", PyInt_FromLong(NETR_DELTA_TRUSTED_DOMAIN));
	PyModule_AddObject(m, "NETR_DELTA_DELETE_USER", PyInt_FromLong(NETR_DELTA_DELETE_USER));
	PyModule_AddObject(m, "NETLOGON_REDO_NEEDED", PyInt_FromLong(NETLOGON_REDO_NEEDED));
	PyModule_AddObject(m, "NETR_TRUST_TYPE_DOWNLEVEL", PyInt_FromLong(NETR_TRUST_TYPE_DOWNLEVEL));
	PyModule_AddObject(m, "NETLOGON_CONTROL_SYNCHRONIZE", PyInt_FromLong(NETLOGON_CONTROL_SYNCHRONIZE));
	PyModule_AddObject(m, "NETR_VER_SUITE_TERMINAL", PyInt_FromLong(NETR_VER_SUITE_TERMINAL));
	PyModule_AddObject(m, "NETLOGON_PROFILE_PATH_RETURNED", PyInt_FromLong(NETLOGON_PROFILE_PATH_RETURNED));
	PyModule_AddObject(m, "NetlogonGenericInformation", PyInt_FromLong(NetlogonGenericInformation));
	PyModule_AddObject(m, "NETR_CHANGELOG_CHANGED_PASSWORD", PyInt_FromLong(NETR_CHANGELOG_CHANGED_PASSWORD));
	PyModule_AddObject(m, "NetlogonValidationGenericInfo2", PyInt_FromLong(NetlogonValidationGenericInfo2));
	PyModule_AddObject(m, "NlDnsNdncDomainName", PyInt_FromLong(NlDnsNdncDomainName));
	PyModule_AddObject(m, "ENC_RC4_HMAC_MD5", PyInt_FromLong(ENC_RC4_HMAC_MD5));
	PyModule_AddObject(m, "DS_ONLY_LDAP_NEEDED", PyInt_FromLong(DS_ONLY_LDAP_NEEDED));
	PyModule_AddObject(m, "DS_SERVER_TIMESERV", PyInt_FromLong(DS_SERVER_TIMESERV));
	PyModule_AddObject(m, "SYNCSTATE_SAM_DONE_STATE", PyInt_FromLong(SYNCSTATE_SAM_DONE_STATE));
	PyModule_AddObject(m, "NETLOGON_EXTRA_SIDS", PyInt_FromLong(NETLOGON_EXTRA_SIDS));
	PyModule_AddObject(m, "NETLOGON_NEG_PERSISTENT_SAMREPL", PyInt_FromLong(NETLOGON_NEG_PERSISTENT_SAMREPL));
	PyModule_AddObject(m, "DS_SERVER_GC", PyInt_FromLong(DS_SERVER_GC));
	PyModule_AddObject(m, "NETR_DELTA_MODIFY_COUNT", PyInt_FromLong(NETR_DELTA_MODIFY_COUNT));
	PyModule_AddObject(m, "NETR_TRUST_ATTRIBUTE_QUARANTINED_DOMAIN", PyInt_FromLong(NETR_TRUST_ATTRIBUTE_QUARANTINED_DOMAIN));
	PyModule_AddObject(m, "NETLOGON_SERVER_TRUST_ACCOUNT", PyInt_FromLong(NETLOGON_SERVER_TRUST_ACCOUNT));
	PyModule_AddObject(m, "NETR_TRUST_TYPE_MIT", PyInt_FromLong(NETR_TRUST_TYPE_MIT));
	PyModule_AddObject(m, "SYNCSTATE_USER_STATE", PyInt_FromLong(SYNCSTATE_USER_STATE));
	PyModule_AddObject(m, "NETLOGON_NOENCRYPTION", PyInt_FromLong(NETLOGON_NOENCRYPTION));
	PyModule_AddObject(m, "DS_SERVER_KDC", PyInt_FromLong(DS_SERVER_KDC));
	PyModule_AddObject(m, "MSV1_0_RETURN_PASSWORD_EXPIRY", PyInt_FromLong(MSV1_0_RETURN_PASSWORD_EXPIRY));
	PyModule_AddObject(m, "NETLOGON_NEG_PASSWORD_CHANGE_REFUSAL", PyInt_FromLong(NETLOGON_NEG_PASSWORD_CHANGE_REFUSAL));
	PyModule_AddObject(m, "NETLOGON_NTLMV2_ENABLED", PyInt_FromLong(NETLOGON_NTLMV2_ENABLED));
	PyModule_AddObject(m, "NETR_DELTA_DELETE_GROUP", PyInt_FromLong(NETR_DELTA_DELETE_GROUP));
	PyModule_AddObject(m, "DS_ADDRESS_TYPE_NETBIOS", PyInt_FromLong(DS_ADDRESS_TYPE_NETBIOS));
	PyModule_AddObject(m, "DS_RETURN_DNS_NAME", PyInt_FromLong(DS_RETURN_DNS_NAME));
	PyModule_AddObject(m, "MSV1_0_CLEARTEXT_PASSWORD_ALLOWED", PyInt_FromLong(MSV1_0_CLEARTEXT_PASSWORD_ALLOWED));
	PyModule_AddObject(m, "DS_DIRECTORY_SERVICE_REQUIRED", PyInt_FromLong(DS_DIRECTORY_SERVICE_REQUIRED));
	PyModule_AddObject(m, "NETR_VER_SUITE_PERSONAL", PyInt_FromLong(NETR_VER_SUITE_PERSONAL));
	PyModule_AddObject(m, "MSV1_0_SUBAUTHENTICATION_DLL_EX", PyInt_FromLong(MSV1_0_SUBAUTHENTICATION_DLL_EX));
	PyModule_AddObject(m, "DS_IP_REQUIRED", PyInt_FromLong(DS_IP_REQUIRED));
	PyModule_AddObject(m, "NETLOGON_NEG_AVOID_SECURITYAUTH_DB_REPL", PyInt_FromLong(NETLOGON_NEG_AVOID_SECURITYAUTH_DB_REPL));
	PyModule_AddObject(m, "DS_DNS_FOREST_ROOT", PyInt_FromLong(DS_DNS_FOREST_ROOT));
	PyModule_AddObject(m, "NETR_TRUST_ATTRIBUTE_CROSS_ORGANIZATION", PyInt_FromLong(NETR_TRUST_ATTRIBUTE_CROSS_ORGANIZATION));
	PyModule_AddObject(m, "NETLOGON_PASSWORD_VERSION_NUMBER_PRESENT", PyInt_FromLong(0x02231968));
	PyModule_AddObject(m, "NETR_TRUST_ATTRIBUTE_WITHIN_FOREST", PyInt_FromLong(NETR_TRUST_ATTRIBUTE_WITHIN_FOREST));
	PyModule_AddObject(m, "DS_RETURN_FLAT_NAME", PyInt_FromLong(DS_RETURN_FLAT_NAME));
	PyModule_AddObject(m, "NETR_DELTA_RENAME_ALIAS", PyInt_FromLong(NETR_DELTA_RENAME_ALIAS));
	PyModule_AddObject(m, "NETR_TRUST_FLAG_INBOUND", PyInt_FromLong(NETR_TRUST_FLAG_INBOUND));
	PyModule_AddObject(m, "NlDnsRecordName", PyInt_FromLong(NlDnsRecordName));
	PyModule_AddObject(m, "NETR_WS_FLAG_HANDLES_SPN_UPDATE", PyInt_FromLong(NETR_WS_FLAG_HANDLES_SPN_UPDATE));
	PyModule_AddObject(m, "NETR_VER_SUITE_BLADE", PyInt_FromLong(NETR_VER_SUITE_BLADE));
	PyModule_AddObject(m, "NETR_TRUST_FLAG_TREEROOT", PyInt_FromLong(NETR_TRUST_FLAG_TREEROOT));
	PyModule_AddObject(m, "NETLOGON_REPLICATION_NEEDED", PyInt_FromLong(NETLOGON_REPLICATION_NEEDED));
	PyModule_AddObject(m, "NETR_TRUST_FLAG_PRIMARY", PyInt_FromLong(NETR_TRUST_FLAG_PRIMARY));
	PyModule_AddObject(m, "NETR_DELTA_DELETE_ALIAS", PyInt_FromLong(NETR_DELTA_DELETE_ALIAS));
	PyModule_AddObject(m, "NETLOGON_NEG_ARCFOUR", PyInt_FromLong(NETLOGON_NEG_ARCFOUR));
	PyModule_AddObject(m, "NETR_DELTA_USER", PyInt_FromLong(NETR_DELTA_USER));
	PyModule_AddObject(m, "MSV1_0_USE_DOMAIN_FOR_ROUTING_ONLY", PyInt_FromLong(MSV1_0_USE_DOMAIN_FOR_ROUTING_ONLY));
	PyModule_AddObject(m, "DS_SERVER_DS", PyInt_FromLong(DS_SERVER_DS));
	PyModule_AddObject(m, "NETR_CHANGELOG_IMMEDIATE_REPL_REQUIRED", PyInt_FromLong(NETR_CHANGELOG_IMMEDIATE_REPL_REQUIRED));
	PyModule_AddObject(m, "DS_ADDRESS_TYPE_INET", PyInt_FromLong(DS_ADDRESS_TYPE_INET));
	PyModule_AddObject(m, "NETR_DELTA_DELETE_USER2", PyInt_FromLong(NETR_DELTA_DELETE_USER2));
	PyModule_AddObject(m, "NETR_DELTA_ALIAS", PyInt_FromLong(NETR_DELTA_ALIAS));
	PyModule_AddObject(m, "DS_WEB_SERVICE_REQUIRED", PyInt_FromLong(DS_WEB_SERVICE_REQUIRED));
	PyModule_AddObject(m, "NETLOGON_NEG_SUPPORTS_AES_SHA2", PyInt_FromLong(NETLOGON_NEG_SUPPORTS_AES_SHA2));
	PyModule_AddObject(m, "NETR_TRUST_FLAG_NATIVE", PyInt_FromLong(NETR_TRUST_FLAG_NATIVE));
	PyModule_AddObject(m, "ENC_RSA_MD5", PyInt_FromLong(ENC_RSA_MD5));
	PyModule_AddObject(m, "NETLOGON_CACHED_ACCOUNT", PyInt_FromLong(NETLOGON_CACHED_ACCOUNT));
	PyModule_AddObject(m, "NETLOGON_NEG_PASSWORD_SET2", PyInt_FromLong(NETLOGON_NEG_PASSWORD_SET2));
	PyModule_AddObject(m, "DS_GFTI_UPDATE_TDO", PyInt_FromLong(0x1));
	PyModule_AddObject(m, "DS_DNS_CONTROLLER", PyInt_FromLong(DS_DNS_CONTROLLER));
	PyModule_AddObject(m, "NETLOGON_NEG_128BIT", PyInt_FromLong(NETLOGON_NEG_STRONG_KEYS));
	PyModule_AddObject(m, "NETLOGON_CONTROL_TC_VERIFY", PyInt_FromLong(NETLOGON_CONTROL_TC_VERIFY));
	PyModule_AddObject(m, "NlDnsDcAtSite", PyInt_FromLong(NlDnsDcAtSite));
	PyModule_AddObject(m, "NETLOGON_REPLICATION_IN_PROGRESS", PyInt_FromLong(NETLOGON_REPLICATION_IN_PROGRESS));
	PyModule_AddObject(m, "NETLOGON_NEG_PROMOTION_COUNT", PyInt_FromLong(NETLOGON_NEG_PROMOTION_COUNT));
	PyModule_AddObject(m, "NETR_DELTA_DELETE_GROUP2", PyInt_FromLong(NETR_DELTA_DELETE_GROUP2));
	PyModule_AddObject(m, "NETR_TRUST_TYPE_DCE", PyInt_FromLong(NETR_TRUST_TYPE_DCE));
	PyModule_AddObject(m, "MSV1_0_S4U2SELF", PyInt_FromLong(MSV1_0_S4U2SELF));
	PyModule_AddObject(m, "DS_IS_DNS_NAME", PyInt_FromLong(DS_IS_DNS_NAME));
	PyModule_AddObject(m, "NETR_VER_SUITE_WH_SERVER", PyInt_FromLong(NETR_VER_SUITE_WH_SERVER));
	PyModule_AddObject(m, "DSGETDC_VALID_FLAGS", PyInt_FromLong((DS_FORCE_REDISCOVERY|DS_DIRECTORY_SERVICE_REQUIRED|DS_DIRECTORY_SERVICE_PREFERRED|DS_GC_SERVER_REQUIRED|DS_PDC_REQUIRED|DS_BACKGROUND_ONLY|DS_IP_REQUIRED|DS_KDC_REQUIRED|DS_TIMESERV_REQUIRED|DS_WRITABLE_REQUIRED|DS_GOOD_TIMESERV_PREFERRED|DS_AVOID_SELF|DS_ONLY_LDAP_NEEDED|DS_IS_FLAT_NAME|DS_IS_DNS_NAME|DS_TRY_NEXTCLOSEST_SITE|DS_DIRECTORY_SERVICE_6_REQUIRED|DS_WEB_SERVICE_REQUIRED|DS_RETURN_FLAT_NAME|DS_RETURN_DNS_NAME)));
	PyModule_AddObject(m, "DS_SERVER_PDC", PyInt_FromLong(DS_SERVER_PDC));
	PyModule_AddObject(m, "SYNCSTATE_GROUP_MEMBER_STATE", PyInt_FromLong(SYNCSTATE_GROUP_MEMBER_STATE));
	PyModule_AddObject(m, "NETLOGON_GUEST", PyInt_FromLong(NETLOGON_GUEST));
	PyModule_AddObject(m, "NETR_VER_SUITE_COMPUTE_SERVER", PyInt_FromLong(NETR_VER_SUITE_COMPUTE_SERVER));
	PyModule_AddObject(m, "DS_DNS_DOMAIN", PyInt_FromLong(DS_DNS_DOMAIN));
	PyModule_AddObject(m, "NlDnsGenericGcAtSite", PyInt_FromLong(NlDnsGenericGcAtSite));
	PyModule_AddObject(m, "NETLOGON_NEG_CHANGELOG_BDC", PyInt_FromLong(NETLOGON_NEG_CHANGELOG_BDC));
	PyModule_AddObject(m, "MSV1_0_ALLOW_SERVER_TRUST_ACCOUNT", PyInt_FromLong(MSV1_0_ALLOW_SERVER_TRUST_ACCOUNT));
	PyModule_AddObject(m, "NETR_VER_SUITE_EMBEDDEDNT", PyInt_FromLong(NETR_VER_SUITE_EMBEDDEDNT));
	PyModule_AddObject(m, "DS_GC_SERVER_REQUIRED", PyInt_FromLong(DS_GC_SERVER_REQUIRED));
	PyModule_AddObject(m, "DS_SERVER_FULL_SECRET_DOMAIN_6", PyInt_FromLong(DS_SERVER_FULL_SECRET_DOMAIN_6));
	PyModule_AddObject(m, "NETLOGON_CONTROL_FORCE_DNS_REG", PyInt_FromLong(NETLOGON_CONTROL_FORCE_DNS_REG));
	PyModule_AddObject(m, "NETR_DELTA_DELETE_TRUST", PyInt_FromLong(NETR_DELTA_DELETE_TRUST));
	PyModule_AddObject(m, "NetlogonNetworkTransitiveInformation", PyInt_FromLong(NetlogonNetworkTransitiveInformation));
	PyModule_AddObject(m, "NETLOGON_DNS_UPDATE_FAILURE", PyInt_FromLong(NETLOGON_DNS_UPDATE_FAILURE));
	PyModule_AddObject(m, "NlDnsForestNameAlias", PyInt_FromLong(NlDnsForestNameAlias));
	PyModule_AddObject(m, "NetlogonServiceTransitiveInformation", PyInt_FromLong(NetlogonServiceTransitiveInformation));
	PyModule_AddObject(m, "NETLOGON_CONTROL_SET_DBFLAG", PyInt_FromLong(NETLOGON_CONTROL_SET_DBFLAG));
	PyModule_AddObject(m, "DS_SERVER_WEBSERV", PyInt_FromLong(DS_SERVER_WEBSERV));
	PyModule_AddObject(m, "NETR_DELTA_RENAME_USER", PyInt_FromLong(NETR_DELTA_RENAME_USER));
	PyModule_AddObject(m, "NETLOGON_HAS_TIMESERV", PyInt_FromLong(NETLOGON_HAS_TIMESERV));
	PyModule_AddObject(m, "MSV1_0_UPDATE_LOGON_STATISTICS", PyInt_FromLong(MSV1_0_UPDATE_LOGON_STATISTICS));
	PyModule_AddObject(m, "NlDnsDomainName", PyInt_FromLong(NlDnsDomainName));
	PyModule_AddObject(m, "NETLOGON_CONTROL_QUERY", PyInt_FromLong(NETLOGON_CONTROL_QUERY));
	PyModule_AddObject(m, "NetlogonValidationUasInfo", PyInt_FromLong(NetlogonValidationUasInfo));
	PyModule_AddObject(m, "NETR_VER_SUITE_STORAGE_SERVER", PyInt_FromLong(NETR_VER_SUITE_STORAGE_SERVER));
	PyModule_AddObject(m, "NETR_DELTA_GROUP", PyInt_FromLong(NETR_DELTA_GROUP));
	PyModule_AddObject(m, "NETR_WS_FLAG_HANDLES_INBOUND_TRUSTS", PyInt_FromLong(NETR_WS_FLAG_HANDLES_INBOUND_TRUSTS));
	PyModule_AddObject(m, "DS_SERVER_CLOSEST", PyInt_FromLong(DS_SERVER_CLOSEST));
	PyModule_AddObject(m, "NETLOGON_CONTROL_CHANGE_PASSWORD", PyInt_FromLong(NETLOGON_CONTROL_CHANGE_PASSWORD));
	PyModule_AddObject(m, "DS_FORCE_REDISCOVERY", PyInt_FromLong(DS_FORCE_REDISCOVERY));
	PyModule_AddObject(m, "NETR_DELTA_GROUP_MEMBER", PyInt_FromLong(NETR_DELTA_GROUP_MEMBER));
	PyModule_AddObject(m, "NETLOGON_NEG_DNS_DOMAIN_TRUSTS", PyInt_FromLong(NETLOGON_NEG_DNS_DOMAIN_TRUSTS));
	Py_INCREF((PyObject *)(void *)&netr_UasInfo_Type);
	PyModule_AddObject(m, "netr_UasInfo", (PyObject *)(void *)&netr_UasInfo_Type);
	Py_INCREF((PyObject *)(void *)&netr_UasLogoffInfo_Type);
	PyModule_AddObject(m, "netr_UasLogoffInfo", (PyObject *)(void *)&netr_UasLogoffInfo_Type);
	Py_INCREF((PyObject *)(void *)&netr_AcctLockStr_Type);
	PyModule_AddObject(m, "netr_AcctLockStr", (PyObject *)(void *)&netr_AcctLockStr_Type);
	Py_INCREF((PyObject *)(void *)&netr_IdentityInfo_Type);
	PyModule_AddObject(m, "netr_IdentityInfo", (PyObject *)(void *)&netr_IdentityInfo_Type);
	Py_INCREF((PyObject *)(void *)&netr_PasswordInfo_Type);
	PyModule_AddObject(m, "netr_PasswordInfo", (PyObject *)(void *)&netr_PasswordInfo_Type);
	Py_INCREF((PyObject *)(void *)&netr_ChallengeResponse_Type);
	PyModule_AddObject(m, "netr_ChallengeResponse", (PyObject *)(void *)&netr_ChallengeResponse_Type);
	Py_INCREF((PyObject *)(void *)&netr_NetworkInfo_Type);
	PyModule_AddObject(m, "netr_NetworkInfo", (PyObject *)(void *)&netr_NetworkInfo_Type);
	Py_INCREF((PyObject *)(void *)&netr_GenericInfo_Type);
	PyModule_AddObject(m, "netr_GenericInfo", (PyObject *)(void *)&netr_GenericInfo_Type);
	Py_INCREF((PyObject *)(void *)&netr_UserSessionKey_Type);
	PyModule_AddObject(m, "netr_UserSessionKey", (PyObject *)(void *)&netr_UserSessionKey_Type);
	Py_INCREF((PyObject *)(void *)&netr_LMSessionKey_Type);
	PyModule_AddObject(m, "netr_LMSessionKey", (PyObject *)(void *)&netr_LMSessionKey_Type);
	Py_INCREF((PyObject *)(void *)&netr_SamBaseInfo_Type);
	PyModule_AddObject(m, "netr_SamBaseInfo", (PyObject *)(void *)&netr_SamBaseInfo_Type);
	Py_INCREF((PyObject *)(void *)&netr_SamInfo2_Type);
	PyModule_AddObject(m, "netr_SamInfo2", (PyObject *)(void *)&netr_SamInfo2_Type);
	Py_INCREF((PyObject *)(void *)&netr_SidAttr_Type);
	PyModule_AddObject(m, "netr_SidAttr", (PyObject *)(void *)&netr_SidAttr_Type);
	Py_INCREF((PyObject *)(void *)&netr_SamInfo3_Type);
	PyModule_AddObject(m, "netr_SamInfo3", (PyObject *)(void *)&netr_SamInfo3_Type);
	Py_INCREF((PyObject *)(void *)&netr_SamInfo6_Type);
	PyModule_AddObject(m, "netr_SamInfo6", (PyObject *)(void *)&netr_SamInfo6_Type);
	Py_INCREF((PyObject *)(void *)&netr_PacInfo_Type);
	PyModule_AddObject(m, "netr_PacInfo", (PyObject *)(void *)&netr_PacInfo_Type);
	Py_INCREF((PyObject *)(void *)&netr_GenericInfo2_Type);
	PyModule_AddObject(m, "netr_GenericInfo2", (PyObject *)(void *)&netr_GenericInfo2_Type);
	Py_INCREF((PyObject *)(void *)&netr_Credential_Type);
	PyModule_AddObject(m, "netr_Credential", (PyObject *)(void *)&netr_Credential_Type);
	Py_INCREF((PyObject *)(void *)&netr_Authenticator_Type);
	PyModule_AddObject(m, "netr_Authenticator", (PyObject *)(void *)&netr_Authenticator_Type);
	Py_INCREF((PyObject *)(void *)&netr_DELTA_DELETE_USER_Type);
	PyModule_AddObject(m, "netr_DELTA_DELETE_USER", (PyObject *)(void *)&netr_DELTA_DELETE_USER_Type);
	Py_INCREF((PyObject *)(void *)&netr_USER_KEY16_Type);
	PyModule_AddObject(m, "netr_USER_KEY16", (PyObject *)(void *)&netr_USER_KEY16_Type);
	Py_INCREF((PyObject *)(void *)&netr_PasswordHistory_Type);
	PyModule_AddObject(m, "netr_PasswordHistory", (PyObject *)(void *)&netr_PasswordHistory_Type);
	Py_INCREF((PyObject *)(void *)&netr_USER_KEYS2_Type);
	PyModule_AddObject(m, "netr_USER_KEYS2", (PyObject *)(void *)&netr_USER_KEYS2_Type);
	Py_INCREF((PyObject *)(void *)&netr_USER_KEY_UNION_Type);
	PyModule_AddObject(m, "netr_USER_KEY_UNION", (PyObject *)(void *)&netr_USER_KEY_UNION_Type);
	Py_INCREF((PyObject *)(void *)&netr_USER_KEYS_Type);
	PyModule_AddObject(m, "netr_USER_KEYS", (PyObject *)(void *)&netr_USER_KEYS_Type);
	Py_INCREF((PyObject *)(void *)&netr_USER_PRIVATE_INFO_Type);
	PyModule_AddObject(m, "netr_USER_PRIVATE_INFO", (PyObject *)(void *)&netr_USER_PRIVATE_INFO_Type);
	Py_INCREF((PyObject *)(void *)&netr_DELTA_USER_Type);
	PyModule_AddObject(m, "netr_DELTA_USER", (PyObject *)(void *)&netr_DELTA_USER_Type);
	Py_INCREF((PyObject *)(void *)&netr_DELTA_DOMAIN_Type);
	PyModule_AddObject(m, "netr_DELTA_DOMAIN", (PyObject *)(void *)&netr_DELTA_DOMAIN_Type);
	Py_INCREF((PyObject *)(void *)&netr_DELTA_GROUP_Type);
	PyModule_AddObject(m, "netr_DELTA_GROUP", (PyObject *)(void *)&netr_DELTA_GROUP_Type);
	Py_INCREF((PyObject *)(void *)&netr_DELTA_RENAME_Type);
	PyModule_AddObject(m, "netr_DELTA_RENAME", (PyObject *)(void *)&netr_DELTA_RENAME_Type);
	Py_INCREF((PyObject *)(void *)&netr_DELTA_GROUP_MEMBER_Type);
	PyModule_AddObject(m, "netr_DELTA_GROUP_MEMBER", (PyObject *)(void *)&netr_DELTA_GROUP_MEMBER_Type);
	Py_INCREF((PyObject *)(void *)&netr_DELTA_ALIAS_Type);
	PyModule_AddObject(m, "netr_DELTA_ALIAS", (PyObject *)(void *)&netr_DELTA_ALIAS_Type);
	Py_INCREF((PyObject *)(void *)&netr_DELTA_ALIAS_MEMBER_Type);
	PyModule_AddObject(m, "netr_DELTA_ALIAS_MEMBER", (PyObject *)(void *)&netr_DELTA_ALIAS_MEMBER_Type);
	Py_INCREF((PyObject *)(void *)&netr_QUOTA_LIMITS_Type);
	PyModule_AddObject(m, "netr_QUOTA_LIMITS", (PyObject *)(void *)&netr_QUOTA_LIMITS_Type);
	Py_INCREF((PyObject *)(void *)&netr_DELTA_POLICY_Type);
	PyModule_AddObject(m, "netr_DELTA_POLICY", (PyObject *)(void *)&netr_DELTA_POLICY_Type);
	Py_INCREF((PyObject *)(void *)&netr_DELTA_TRUSTED_DOMAIN_Type);
	PyModule_AddObject(m, "netr_DELTA_TRUSTED_DOMAIN", (PyObject *)(void *)&netr_DELTA_TRUSTED_DOMAIN_Type);
	Py_INCREF((PyObject *)(void *)&netr_DELTA_ACCOUNT_Type);
	PyModule_AddObject(m, "netr_DELTA_ACCOUNT", (PyObject *)(void *)&netr_DELTA_ACCOUNT_Type);
	Py_INCREF((PyObject *)(void *)&netr_CIPHER_VALUE_Type);
	PyModule_AddObject(m, "netr_CIPHER_VALUE", (PyObject *)(void *)&netr_CIPHER_VALUE_Type);
	Py_INCREF((PyObject *)(void *)&netr_DELTA_SECRET_Type);
	PyModule_AddObject(m, "netr_DELTA_SECRET", (PyObject *)(void *)&netr_DELTA_SECRET_Type);
	Py_INCREF((PyObject *)(void *)&netr_DELTA_ENUM_Type);
	PyModule_AddObject(m, "netr_DELTA_ENUM", (PyObject *)(void *)&netr_DELTA_ENUM_Type);
	Py_INCREF((PyObject *)(void *)&netr_DELTA_ENUM_ARRAY_Type);
	PyModule_AddObject(m, "netr_DELTA_ENUM_ARRAY", (PyObject *)(void *)&netr_DELTA_ENUM_ARRAY_Type);
	Py_INCREF((PyObject *)(void *)&netr_UAS_INFO_0_Type);
	PyModule_AddObject(m, "netr_UAS_INFO_0", (PyObject *)(void *)&netr_UAS_INFO_0_Type);
	Py_INCREF((PyObject *)(void *)&netr_AccountBuffer_Type);
	PyModule_AddObject(m, "netr_AccountBuffer", (PyObject *)(void *)&netr_AccountBuffer_Type);
	Py_INCREF((PyObject *)(void *)&netr_NETLOGON_INFO_1_Type);
	PyModule_AddObject(m, "netr_NETLOGON_INFO_1", (PyObject *)(void *)&netr_NETLOGON_INFO_1_Type);
	Py_INCREF((PyObject *)(void *)&netr_NETLOGON_INFO_2_Type);
	PyModule_AddObject(m, "netr_NETLOGON_INFO_2", (PyObject *)(void *)&netr_NETLOGON_INFO_2_Type);
	Py_INCREF((PyObject *)(void *)&netr_NETLOGON_INFO_3_Type);
	PyModule_AddObject(m, "netr_NETLOGON_INFO_3", (PyObject *)(void *)&netr_NETLOGON_INFO_3_Type);
	Py_INCREF((PyObject *)(void *)&netr_NETLOGON_INFO_4_Type);
	PyModule_AddObject(m, "netr_NETLOGON_INFO_4", (PyObject *)(void *)&netr_NETLOGON_INFO_4_Type);
	Py_INCREF((PyObject *)(void *)&netr_ChangeLogEntry_Type);
	PyModule_AddObject(m, "netr_ChangeLogEntry", (PyObject *)(void *)&netr_ChangeLogEntry_Type);
	Py_INCREF((PyObject *)(void *)&netr_Blob_Type);
	PyModule_AddObject(m, "netr_Blob", (PyObject *)(void *)&netr_Blob_Type);
	Py_INCREF((PyObject *)(void *)&netr_DsRGetDCNameInfo_Type);
	PyModule_AddObject(m, "netr_DsRGetDCNameInfo", (PyObject *)(void *)&netr_DsRGetDCNameInfo_Type);
	Py_INCREF((PyObject *)(void *)&netr_LsaPolicyInformation_Type);
	PyModule_AddObject(m, "netr_LsaPolicyInformation", (PyObject *)(void *)&netr_LsaPolicyInformation_Type);
	Py_INCREF((PyObject *)(void *)&netr_OsVersionInfoEx_Type);
	PyModule_AddObject(m, "netr_OsVersionInfoEx", (PyObject *)(void *)&netr_OsVersionInfoEx_Type);
	Py_INCREF((PyObject *)(void *)&netr_OsVersion_Type);
	PyModule_AddObject(m, "netr_OsVersion", (PyObject *)(void *)&netr_OsVersion_Type);
	Py_INCREF((PyObject *)(void *)&netr_OsVersionContainer_Type);
	PyModule_AddObject(m, "netr_OsVersionContainer", (PyObject *)(void *)&netr_OsVersionContainer_Type);
	Py_INCREF((PyObject *)(void *)&netr_WorkstationInformation_Type);
	PyModule_AddObject(m, "netr_WorkstationInformation", (PyObject *)(void *)&netr_WorkstationInformation_Type);
	Py_INCREF((PyObject *)(void *)&netr_trust_extension_Type);
	PyModule_AddObject(m, "netr_trust_extension", (PyObject *)(void *)&netr_trust_extension_Type);
	Py_INCREF((PyObject *)(void *)&netr_trust_extension_container_Type);
	PyModule_AddObject(m, "netr_trust_extension_container", (PyObject *)(void *)&netr_trust_extension_container_Type);
	Py_INCREF((PyObject *)(void *)&netr_OneDomainInfo_Type);
	PyModule_AddObject(m, "netr_OneDomainInfo", (PyObject *)(void *)&netr_OneDomainInfo_Type);
	Py_INCREF((PyObject *)(void *)&netr_DomainInformation_Type);
	PyModule_AddObject(m, "netr_DomainInformation", (PyObject *)(void *)&netr_DomainInformation_Type);
	Py_INCREF((PyObject *)(void *)&NL_PASSWORD_VERSION_Type);
	PyModule_AddObject(m, "NL_PASSWORD_VERSION", (PyObject *)(void *)&NL_PASSWORD_VERSION_Type);
	Py_INCREF((PyObject *)(void *)&netr_CryptPassword_Type);
	PyModule_AddObject(m, "netr_CryptPassword", (PyObject *)(void *)&netr_CryptPassword_Type);
	Py_INCREF((PyObject *)(void *)&netr_DsRAddressToSitenamesWCtr_Type);
	PyModule_AddObject(m, "netr_DsRAddressToSitenamesWCtr", (PyObject *)(void *)&netr_DsRAddressToSitenamesWCtr_Type);
	Py_INCREF((PyObject *)(void *)&netr_DsRAddress_Type);
	PyModule_AddObject(m, "netr_DsRAddress", (PyObject *)(void *)&netr_DsRAddress_Type);
	Py_INCREF((PyObject *)(void *)&netr_DomainTrust_Type);
	PyModule_AddObject(m, "netr_DomainTrust", (PyObject *)(void *)&netr_DomainTrust_Type);
	Py_INCREF((PyObject *)(void *)&netr_DomainTrustList_Type);
	PyModule_AddObject(m, "netr_DomainTrustList", (PyObject *)(void *)&netr_DomainTrustList_Type);
	Py_INCREF((PyObject *)(void *)&netr_DsRAddressToSitenamesExWCtr_Type);
	PyModule_AddObject(m, "netr_DsRAddressToSitenamesExWCtr", (PyObject *)(void *)&netr_DsRAddressToSitenamesExWCtr_Type);
	Py_INCREF((PyObject *)(void *)&DcSitesCtr_Type);
	PyModule_AddObject(m, "DcSitesCtr", (PyObject *)(void *)&DcSitesCtr_Type);
	Py_INCREF((PyObject *)(void *)&netr_TrustInfo_Type);
	PyModule_AddObject(m, "netr_TrustInfo", (PyObject *)(void *)&netr_TrustInfo_Type);
	Py_INCREF((PyObject *)(void *)&NL_DNS_NAME_INFO_Type);
	PyModule_AddObject(m, "NL_DNS_NAME_INFO", (PyObject *)(void *)&NL_DNS_NAME_INFO_Type);
	Py_INCREF((PyObject *)(void *)&NL_DNS_NAME_INFO_ARRAY_Type);
	PyModule_AddObject(m, "NL_DNS_NAME_INFO_ARRAY", (PyObject *)(void *)&NL_DNS_NAME_INFO_ARRAY_Type);
	Py_INCREF((PyObject *)(void *)&netlogon_InterfaceType);
	PyModule_AddObject(m, "netlogon", (PyObject *)(void *)&netlogon_InterfaceType);
#ifdef PY_MOD_NETLOGON_PATCH
	PY_MOD_NETLOGON_PATCH(m);
#endif

}
