/* client functions auto-generated by pidl */

#include "includes.h"
#include <tevent.h>
#include "lib/util/tevent_ntstatus.h"
#include "autoconf/librpc/gen_ndr/ndr_dnsserver.h"
#include "autoconf/librpc/gen_ndr/ndr_dnsserver_c.h"

/* dnsserver - client functions generated by pidl */

struct dcerpc_DnssrvOperation_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_DnssrvOperation_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_DnssrvOperation_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct DnssrvOperation *r)
{
	struct tevent_req *req;
	struct dcerpc_DnssrvOperation_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_DnssrvOperation_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_dnsserver,
			NDR_DNSSRVOPERATION, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_DnssrvOperation_r_done, req);

	return req;
}

static void dcerpc_DnssrvOperation_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_DnssrvOperation_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_DnssrvOperation_r_state *state =
		tevent_req_data(req,
		struct dcerpc_DnssrvOperation_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_DnssrvOperation_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct DnssrvOperation *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_dnsserver,
			NDR_DNSSRVOPERATION, mem_ctx, r);

	return status;
}

struct dcerpc_DnssrvOperation_state {
	struct DnssrvOperation orig;
	struct DnssrvOperation tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_DnssrvOperation_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_DnssrvOperation_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       const char *_pwszServerName /* [in] [unique,charset(UTF16)] */,
					       const char *_pszZone /* [in] [charset(UTF8),unique] */,
					       uint32_t _dwContext /* [in]  */,
					       const char *_pszOperation /* [in] [unique,charset(UTF8)] */,
					       enum DNS_RPC_TYPEID _dwTypeId /* [in]  */,
					       union DNSSRV_RPC_UNION _pData /* [in] [switch_is(dwTypeId)] */)
{
	struct tevent_req *req;
	struct dcerpc_DnssrvOperation_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_DnssrvOperation_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.pwszServerName = _pwszServerName;
	state->orig.in.pszZone = _pszZone;
	state->orig.in.dwContext = _dwContext;
	state->orig.in.pszOperation = _pszOperation;
	state->orig.in.dwTypeId = _dwTypeId;
	state->orig.in.pData = _pData;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_DnssrvOperation_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_DnssrvOperation_done, req);
	return req;
}

static void dcerpc_DnssrvOperation_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_DnssrvOperation_state *state = tevent_req_data(
		req, struct dcerpc_DnssrvOperation_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_DnssrvOperation_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_DnssrvOperation_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result)
{
	struct dcerpc_DnssrvOperation_state *state = tevent_req_data(
		req, struct dcerpc_DnssrvOperation_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_DnssrvOperation(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				const char *_pwszServerName /* [in] [unique,charset(UTF16)] */,
				const char *_pszZone /* [in] [charset(UTF8),unique] */,
				uint32_t _dwContext /* [in]  */,
				const char *_pszOperation /* [in] [unique,charset(UTF8)] */,
				enum DNS_RPC_TYPEID _dwTypeId /* [in]  */,
				union DNSSRV_RPC_UNION _pData /* [in] [switch_is(dwTypeId)] */,
				WERROR *result)
{
	struct DnssrvOperation r;
	NTSTATUS status;

	/* In parameters */
	r.in.pwszServerName = _pwszServerName;
	r.in.pszZone = _pszZone;
	r.in.dwContext = _dwContext;
	r.in.pszOperation = _pszOperation;
	r.in.dwTypeId = _dwTypeId;
	r.in.pData = _pData;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_DnssrvOperation_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_DnssrvQuery_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_DnssrvQuery_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_DnssrvQuery_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct DnssrvQuery *r)
{
	struct tevent_req *req;
	struct dcerpc_DnssrvQuery_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_DnssrvQuery_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_dnsserver,
			NDR_DNSSRVQUERY, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_DnssrvQuery_r_done, req);

	return req;
}

static void dcerpc_DnssrvQuery_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_DnssrvQuery_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_DnssrvQuery_r_state *state =
		tevent_req_data(req,
		struct dcerpc_DnssrvQuery_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_DnssrvQuery_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct DnssrvQuery *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_dnsserver,
			NDR_DNSSRVQUERY, mem_ctx, r);

	return status;
}

struct dcerpc_DnssrvQuery_state {
	struct DnssrvQuery orig;
	struct DnssrvQuery tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_DnssrvQuery_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_DnssrvQuery_send(TALLOC_CTX *mem_ctx,
					   struct tevent_context *ev,
					   struct dcerpc_binding_handle *h,
					   const char *_pwszServerName /* [in] [unique,charset(UTF16)] */,
					   const char *_pszZone /* [in] [unique,charset(UTF8)] */,
					   const char *_pszOperation /* [in] [charset(UTF8),unique] */,
					   enum DNS_RPC_TYPEID *_pdwTypeId /* [out] [ref] */,
					   union DNSSRV_RPC_UNION *_ppData /* [out] [switch_is(*pdwTypeId),ref] */)
{
	struct tevent_req *req;
	struct dcerpc_DnssrvQuery_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_DnssrvQuery_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.pwszServerName = _pwszServerName;
	state->orig.in.pszZone = _pszZone;
	state->orig.in.pszOperation = _pszOperation;

	/* Out parameters */
	state->orig.out.pdwTypeId = _pdwTypeId;
	state->orig.out.ppData = _ppData;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_DnssrvQuery_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_DnssrvQuery_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_DnssrvQuery_done, req);
	return req;
}

static void dcerpc_DnssrvQuery_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_DnssrvQuery_state *state = tevent_req_data(
		req, struct dcerpc_DnssrvQuery_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_DnssrvQuery_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.pdwTypeId = *state->tmp.out.pdwTypeId;
	*state->orig.out.ppData = *state->tmp.out.ppData;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_DnssrvQuery_recv(struct tevent_req *req,
				 TALLOC_CTX *mem_ctx,
				 WERROR *result)
{
	struct dcerpc_DnssrvQuery_state *state = tevent_req_data(
		req, struct dcerpc_DnssrvQuery_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_DnssrvQuery(struct dcerpc_binding_handle *h,
			    TALLOC_CTX *mem_ctx,
			    const char *_pwszServerName /* [in] [unique,charset(UTF16)] */,
			    const char *_pszZone /* [in] [unique,charset(UTF8)] */,
			    const char *_pszOperation /* [in] [charset(UTF8),unique] */,
			    enum DNS_RPC_TYPEID *_pdwTypeId /* [out] [ref] */,
			    union DNSSRV_RPC_UNION *_ppData /* [out] [switch_is(*pdwTypeId),ref] */,
			    WERROR *result)
{
	struct DnssrvQuery r;
	NTSTATUS status;

	/* In parameters */
	r.in.pwszServerName = _pwszServerName;
	r.in.pszZone = _pszZone;
	r.in.pszOperation = _pszOperation;

	/* Out parameters */
	r.out.pdwTypeId = _pdwTypeId;
	r.out.ppData = _ppData;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_DnssrvQuery_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_pdwTypeId = *r.out.pdwTypeId;
	*_ppData = *r.out.ppData;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_DnssrvComplexOperation_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_DnssrvComplexOperation_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_DnssrvComplexOperation_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct DnssrvComplexOperation *r)
{
	struct tevent_req *req;
	struct dcerpc_DnssrvComplexOperation_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_DnssrvComplexOperation_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_dnsserver,
			NDR_DNSSRVCOMPLEXOPERATION, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_DnssrvComplexOperation_r_done, req);

	return req;
}

static void dcerpc_DnssrvComplexOperation_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_DnssrvComplexOperation_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_DnssrvComplexOperation_r_state *state =
		tevent_req_data(req,
		struct dcerpc_DnssrvComplexOperation_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_DnssrvComplexOperation_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct DnssrvComplexOperation *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_dnsserver,
			NDR_DNSSRVCOMPLEXOPERATION, mem_ctx, r);

	return status;
}

struct dcerpc_DnssrvComplexOperation_state {
	struct DnssrvComplexOperation orig;
	struct DnssrvComplexOperation tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_DnssrvComplexOperation_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_DnssrvComplexOperation_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      const char *_pwszServerName /* [in] [charset(UTF16),unique] */,
						      const char *_pszZone /* [in] [charset(UTF8),unique] */,
						      const char *_pszOperation /* [in] [charset(UTF8),unique] */,
						      enum DNS_RPC_TYPEID _dwTypeIn /* [in]  */,
						      union DNSSRV_RPC_UNION _pDataIn /* [in] [switch_is(dwTypeIn)] */,
						      enum DNS_RPC_TYPEID *_pdwTypeOut /* [out] [ref] */,
						      union DNSSRV_RPC_UNION *_ppDataOut /* [out] [switch_is(*pdwTypeOut),ref] */)
{
	struct tevent_req *req;
	struct dcerpc_DnssrvComplexOperation_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_DnssrvComplexOperation_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.pwszServerName = _pwszServerName;
	state->orig.in.pszZone = _pszZone;
	state->orig.in.pszOperation = _pszOperation;
	state->orig.in.dwTypeIn = _dwTypeIn;
	state->orig.in.pDataIn = _pDataIn;

	/* Out parameters */
	state->orig.out.pdwTypeOut = _pdwTypeOut;
	state->orig.out.ppDataOut = _ppDataOut;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_DnssrvComplexOperation_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_DnssrvComplexOperation_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_DnssrvComplexOperation_done, req);
	return req;
}

static void dcerpc_DnssrvComplexOperation_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_DnssrvComplexOperation_state *state = tevent_req_data(
		req, struct dcerpc_DnssrvComplexOperation_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_DnssrvComplexOperation_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.pdwTypeOut = *state->tmp.out.pdwTypeOut;
	*state->orig.out.ppDataOut = *state->tmp.out.ppDataOut;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_DnssrvComplexOperation_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    WERROR *result)
{
	struct dcerpc_DnssrvComplexOperation_state *state = tevent_req_data(
		req, struct dcerpc_DnssrvComplexOperation_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_DnssrvComplexOperation(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       const char *_pwszServerName /* [in] [charset(UTF16),unique] */,
				       const char *_pszZone /* [in] [charset(UTF8),unique] */,
				       const char *_pszOperation /* [in] [charset(UTF8),unique] */,
				       enum DNS_RPC_TYPEID _dwTypeIn /* [in]  */,
				       union DNSSRV_RPC_UNION _pDataIn /* [in] [switch_is(dwTypeIn)] */,
				       enum DNS_RPC_TYPEID *_pdwTypeOut /* [out] [ref] */,
				       union DNSSRV_RPC_UNION *_ppDataOut /* [out] [switch_is(*pdwTypeOut),ref] */,
				       WERROR *result)
{
	struct DnssrvComplexOperation r;
	NTSTATUS status;

	/* In parameters */
	r.in.pwszServerName = _pwszServerName;
	r.in.pszZone = _pszZone;
	r.in.pszOperation = _pszOperation;
	r.in.dwTypeIn = _dwTypeIn;
	r.in.pDataIn = _pDataIn;

	/* Out parameters */
	r.out.pdwTypeOut = _pdwTypeOut;
	r.out.ppDataOut = _ppDataOut;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_DnssrvComplexOperation_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_pdwTypeOut = *r.out.pdwTypeOut;
	*_ppDataOut = *r.out.ppDataOut;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_DnssrvEnumRecords_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_DnssrvEnumRecords_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_DnssrvEnumRecords_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct DnssrvEnumRecords *r)
{
	struct tevent_req *req;
	struct dcerpc_DnssrvEnumRecords_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_DnssrvEnumRecords_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_dnsserver,
			NDR_DNSSRVENUMRECORDS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_DnssrvEnumRecords_r_done, req);

	return req;
}

static void dcerpc_DnssrvEnumRecords_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_DnssrvEnumRecords_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_DnssrvEnumRecords_r_state *state =
		tevent_req_data(req,
		struct dcerpc_DnssrvEnumRecords_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_DnssrvEnumRecords_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct DnssrvEnumRecords *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_dnsserver,
			NDR_DNSSRVENUMRECORDS, mem_ctx, r);

	return status;
}

struct dcerpc_DnssrvEnumRecords_state {
	struct DnssrvEnumRecords orig;
	struct DnssrvEnumRecords tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_DnssrvEnumRecords_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_DnssrvEnumRecords_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 const char *_pwszServerName /* [in] [unique,charset(UTF16)] */,
						 const char *_pszZone /* [in] [unique,charset(UTF8)] */,
						 const char *_pszNodeName /* [in] [unique,charset(UTF8)] */,
						 const char *_pszStartChild /* [in] [charset(UTF8),unique] */,
						 enum dns_record_type _wRecordType /* [in]  */,
						 uint32_t _fSelectFlag /* [in]  */,
						 const char *_pszFilterStart /* [in] [unique,charset(UTF8)] */,
						 const char *_pszFilterStop /* [in] [charset(UTF8),unique] */,
						 uint32_t *_pdwBufferLength /* [out] [ref] */,
						 struct DNS_RPC_RECORDS_ARRAY **_pBuffer /* [out] [subcontext_size(*pdwBufferLength),subcontext(4),ref] */)
{
	struct tevent_req *req;
	struct dcerpc_DnssrvEnumRecords_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_DnssrvEnumRecords_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.pwszServerName = _pwszServerName;
	state->orig.in.pszZone = _pszZone;
	state->orig.in.pszNodeName = _pszNodeName;
	state->orig.in.pszStartChild = _pszStartChild;
	state->orig.in.wRecordType = _wRecordType;
	state->orig.in.fSelectFlag = _fSelectFlag;
	state->orig.in.pszFilterStart = _pszFilterStart;
	state->orig.in.pszFilterStop = _pszFilterStop;

	/* Out parameters */
	state->orig.out.pdwBufferLength = _pdwBufferLength;
	state->orig.out.pBuffer = _pBuffer;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_DnssrvEnumRecords_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_DnssrvEnumRecords_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_DnssrvEnumRecords_done, req);
	return req;
}

static void dcerpc_DnssrvEnumRecords_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_DnssrvEnumRecords_state *state = tevent_req_data(
		req, struct dcerpc_DnssrvEnumRecords_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_DnssrvEnumRecords_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.pdwBufferLength = *state->tmp.out.pdwBufferLength;
	*state->orig.out.pBuffer = *state->tmp.out.pBuffer;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_DnssrvEnumRecords_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       WERROR *result)
{
	struct dcerpc_DnssrvEnumRecords_state *state = tevent_req_data(
		req, struct dcerpc_DnssrvEnumRecords_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_DnssrvEnumRecords(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  const char *_pwszServerName /* [in] [unique,charset(UTF16)] */,
				  const char *_pszZone /* [in] [unique,charset(UTF8)] */,
				  const char *_pszNodeName /* [in] [unique,charset(UTF8)] */,
				  const char *_pszStartChild /* [in] [charset(UTF8),unique] */,
				  enum dns_record_type _wRecordType /* [in]  */,
				  uint32_t _fSelectFlag /* [in]  */,
				  const char *_pszFilterStart /* [in] [unique,charset(UTF8)] */,
				  const char *_pszFilterStop /* [in] [charset(UTF8),unique] */,
				  uint32_t *_pdwBufferLength /* [out] [ref] */,
				  struct DNS_RPC_RECORDS_ARRAY **_pBuffer /* [out] [subcontext_size(*pdwBufferLength),subcontext(4),ref] */,
				  WERROR *result)
{
	struct DnssrvEnumRecords r;
	NTSTATUS status;

	/* In parameters */
	r.in.pwszServerName = _pwszServerName;
	r.in.pszZone = _pszZone;
	r.in.pszNodeName = _pszNodeName;
	r.in.pszStartChild = _pszStartChild;
	r.in.wRecordType = _wRecordType;
	r.in.fSelectFlag = _fSelectFlag;
	r.in.pszFilterStart = _pszFilterStart;
	r.in.pszFilterStop = _pszFilterStop;

	/* Out parameters */
	r.out.pdwBufferLength = _pdwBufferLength;
	r.out.pBuffer = _pBuffer;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_DnssrvEnumRecords_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_pdwBufferLength = *r.out.pdwBufferLength;
	*_pBuffer = *r.out.pBuffer;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_DnssrvUpdateRecord_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_DnssrvUpdateRecord_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_DnssrvUpdateRecord_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct DnssrvUpdateRecord *r)
{
	struct tevent_req *req;
	struct dcerpc_DnssrvUpdateRecord_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_DnssrvUpdateRecord_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_dnsserver,
			NDR_DNSSRVUPDATERECORD, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_DnssrvUpdateRecord_r_done, req);

	return req;
}

static void dcerpc_DnssrvUpdateRecord_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_DnssrvUpdateRecord_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_DnssrvUpdateRecord_r_state *state =
		tevent_req_data(req,
		struct dcerpc_DnssrvUpdateRecord_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_DnssrvUpdateRecord_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct DnssrvUpdateRecord *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_dnsserver,
			NDR_DNSSRVUPDATERECORD, mem_ctx, r);

	return status;
}

struct dcerpc_DnssrvUpdateRecord_state {
	struct DnssrvUpdateRecord orig;
	struct DnssrvUpdateRecord tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_DnssrvUpdateRecord_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_DnssrvUpdateRecord_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct dcerpc_binding_handle *h,
						  const char *_pwszServerName /* [in] [charset(UTF16),unique] */,
						  const char *_pszZone /* [in] [unique,charset(UTF8)] */,
						  const char *_pszNodeName /* [in] [unique,charset(UTF8)] */,
						  struct DNS_RPC_RECORD_BUF *_pAddRecord /* [in] [unique] */,
						  struct DNS_RPC_RECORD_BUF *_pDeleteRecord /* [in] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_DnssrvUpdateRecord_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_DnssrvUpdateRecord_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.pwszServerName = _pwszServerName;
	state->orig.in.pszZone = _pszZone;
	state->orig.in.pszNodeName = _pszNodeName;
	state->orig.in.pAddRecord = _pAddRecord;
	state->orig.in.pDeleteRecord = _pDeleteRecord;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_DnssrvUpdateRecord_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_DnssrvUpdateRecord_done, req);
	return req;
}

static void dcerpc_DnssrvUpdateRecord_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_DnssrvUpdateRecord_state *state = tevent_req_data(
		req, struct dcerpc_DnssrvUpdateRecord_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_DnssrvUpdateRecord_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_DnssrvUpdateRecord_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					WERROR *result)
{
	struct dcerpc_DnssrvUpdateRecord_state *state = tevent_req_data(
		req, struct dcerpc_DnssrvUpdateRecord_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_DnssrvUpdateRecord(struct dcerpc_binding_handle *h,
				   TALLOC_CTX *mem_ctx,
				   const char *_pwszServerName /* [in] [charset(UTF16),unique] */,
				   const char *_pszZone /* [in] [unique,charset(UTF8)] */,
				   const char *_pszNodeName /* [in] [unique,charset(UTF8)] */,
				   struct DNS_RPC_RECORD_BUF *_pAddRecord /* [in] [unique] */,
				   struct DNS_RPC_RECORD_BUF *_pDeleteRecord /* [in] [unique] */,
				   WERROR *result)
{
	struct DnssrvUpdateRecord r;
	NTSTATUS status;

	/* In parameters */
	r.in.pwszServerName = _pwszServerName;
	r.in.pszZone = _pszZone;
	r.in.pszNodeName = _pszNodeName;
	r.in.pAddRecord = _pAddRecord;
	r.in.pDeleteRecord = _pDeleteRecord;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_DnssrvUpdateRecord_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_DnssrvOperation2_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_DnssrvOperation2_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_DnssrvOperation2_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct DnssrvOperation2 *r)
{
	struct tevent_req *req;
	struct dcerpc_DnssrvOperation2_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_DnssrvOperation2_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_dnsserver,
			NDR_DNSSRVOPERATION2, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_DnssrvOperation2_r_done, req);

	return req;
}

static void dcerpc_DnssrvOperation2_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_DnssrvOperation2_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_DnssrvOperation2_r_state *state =
		tevent_req_data(req,
		struct dcerpc_DnssrvOperation2_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_DnssrvOperation2_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct DnssrvOperation2 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_dnsserver,
			NDR_DNSSRVOPERATION2, mem_ctx, r);

	return status;
}

struct dcerpc_DnssrvOperation2_state {
	struct DnssrvOperation2 orig;
	struct DnssrvOperation2 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_DnssrvOperation2_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_DnssrvOperation2_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						enum DNS_RPC_CLIENT_VERSION _dwClientVersion /* [in]  */,
						uint32_t _dwSettingFlags /* [in]  */,
						const char *_pwszServerName /* [in] [charset(UTF16),unique] */,
						const char *_pszZone /* [in] [unique,charset(UTF8)] */,
						uint32_t _dwContext /* [in]  */,
						const char *_pszOperation /* [in] [charset(UTF8),unique] */,
						enum DNS_RPC_TYPEID _dwTypeId /* [in]  */,
						union DNSSRV_RPC_UNION _pData /* [in] [switch_is(dwTypeId)] */)
{
	struct tevent_req *req;
	struct dcerpc_DnssrvOperation2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_DnssrvOperation2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.dwClientVersion = _dwClientVersion;
	state->orig.in.dwSettingFlags = _dwSettingFlags;
	state->orig.in.pwszServerName = _pwszServerName;
	state->orig.in.pszZone = _pszZone;
	state->orig.in.dwContext = _dwContext;
	state->orig.in.pszOperation = _pszOperation;
	state->orig.in.dwTypeId = _dwTypeId;
	state->orig.in.pData = _pData;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_DnssrvOperation2_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_DnssrvOperation2_done, req);
	return req;
}

static void dcerpc_DnssrvOperation2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_DnssrvOperation2_state *state = tevent_req_data(
		req, struct dcerpc_DnssrvOperation2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_DnssrvOperation2_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_DnssrvOperation2_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result)
{
	struct dcerpc_DnssrvOperation2_state *state = tevent_req_data(
		req, struct dcerpc_DnssrvOperation2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_DnssrvOperation2(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 enum DNS_RPC_CLIENT_VERSION _dwClientVersion /* [in]  */,
				 uint32_t _dwSettingFlags /* [in]  */,
				 const char *_pwszServerName /* [in] [charset(UTF16),unique] */,
				 const char *_pszZone /* [in] [unique,charset(UTF8)] */,
				 uint32_t _dwContext /* [in]  */,
				 const char *_pszOperation /* [in] [charset(UTF8),unique] */,
				 enum DNS_RPC_TYPEID _dwTypeId /* [in]  */,
				 union DNSSRV_RPC_UNION _pData /* [in] [switch_is(dwTypeId)] */,
				 WERROR *result)
{
	struct DnssrvOperation2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.dwClientVersion = _dwClientVersion;
	r.in.dwSettingFlags = _dwSettingFlags;
	r.in.pwszServerName = _pwszServerName;
	r.in.pszZone = _pszZone;
	r.in.dwContext = _dwContext;
	r.in.pszOperation = _pszOperation;
	r.in.dwTypeId = _dwTypeId;
	r.in.pData = _pData;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_DnssrvOperation2_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_DnssrvQuery2_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_DnssrvQuery2_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_DnssrvQuery2_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct DnssrvQuery2 *r)
{
	struct tevent_req *req;
	struct dcerpc_DnssrvQuery2_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_DnssrvQuery2_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_dnsserver,
			NDR_DNSSRVQUERY2, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_DnssrvQuery2_r_done, req);

	return req;
}

static void dcerpc_DnssrvQuery2_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_DnssrvQuery2_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_DnssrvQuery2_r_state *state =
		tevent_req_data(req,
		struct dcerpc_DnssrvQuery2_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_DnssrvQuery2_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct DnssrvQuery2 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_dnsserver,
			NDR_DNSSRVQUERY2, mem_ctx, r);

	return status;
}

struct dcerpc_DnssrvQuery2_state {
	struct DnssrvQuery2 orig;
	struct DnssrvQuery2 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_DnssrvQuery2_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_DnssrvQuery2_send(TALLOC_CTX *mem_ctx,
					    struct tevent_context *ev,
					    struct dcerpc_binding_handle *h,
					    enum DNS_RPC_CLIENT_VERSION _dwClientVersion /* [in]  */,
					    uint32_t _dwSettingFlags /* [in]  */,
					    const char *_pwszServerName /* [in] [unique,charset(UTF16)] */,
					    const char *_pszZone /* [in] [unique,charset(UTF8)] */,
					    const char *_pszOperation /* [in] [unique,charset(UTF8)] */,
					    enum DNS_RPC_TYPEID *_pdwTypeId /* [out] [ref] */,
					    union DNSSRV_RPC_UNION *_ppData /* [out] [switch_is(*pdwTypeId),ref] */)
{
	struct tevent_req *req;
	struct dcerpc_DnssrvQuery2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_DnssrvQuery2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.dwClientVersion = _dwClientVersion;
	state->orig.in.dwSettingFlags = _dwSettingFlags;
	state->orig.in.pwszServerName = _pwszServerName;
	state->orig.in.pszZone = _pszZone;
	state->orig.in.pszOperation = _pszOperation;

	/* Out parameters */
	state->orig.out.pdwTypeId = _pdwTypeId;
	state->orig.out.ppData = _ppData;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_DnssrvQuery2_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_DnssrvQuery2_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_DnssrvQuery2_done, req);
	return req;
}

static void dcerpc_DnssrvQuery2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_DnssrvQuery2_state *state = tevent_req_data(
		req, struct dcerpc_DnssrvQuery2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_DnssrvQuery2_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.pdwTypeId = *state->tmp.out.pdwTypeId;
	*state->orig.out.ppData = *state->tmp.out.ppData;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_DnssrvQuery2_recv(struct tevent_req *req,
				  TALLOC_CTX *mem_ctx,
				  WERROR *result)
{
	struct dcerpc_DnssrvQuery2_state *state = tevent_req_data(
		req, struct dcerpc_DnssrvQuery2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_DnssrvQuery2(struct dcerpc_binding_handle *h,
			     TALLOC_CTX *mem_ctx,
			     enum DNS_RPC_CLIENT_VERSION _dwClientVersion /* [in]  */,
			     uint32_t _dwSettingFlags /* [in]  */,
			     const char *_pwszServerName /* [in] [unique,charset(UTF16)] */,
			     const char *_pszZone /* [in] [unique,charset(UTF8)] */,
			     const char *_pszOperation /* [in] [unique,charset(UTF8)] */,
			     enum DNS_RPC_TYPEID *_pdwTypeId /* [out] [ref] */,
			     union DNSSRV_RPC_UNION *_ppData /* [out] [switch_is(*pdwTypeId),ref] */,
			     WERROR *result)
{
	struct DnssrvQuery2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.dwClientVersion = _dwClientVersion;
	r.in.dwSettingFlags = _dwSettingFlags;
	r.in.pwszServerName = _pwszServerName;
	r.in.pszZone = _pszZone;
	r.in.pszOperation = _pszOperation;

	/* Out parameters */
	r.out.pdwTypeId = _pdwTypeId;
	r.out.ppData = _ppData;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_DnssrvQuery2_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_pdwTypeId = *r.out.pdwTypeId;
	*_ppData = *r.out.ppData;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_DnssrvComplexOperation2_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_DnssrvComplexOperation2_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_DnssrvComplexOperation2_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct DnssrvComplexOperation2 *r)
{
	struct tevent_req *req;
	struct dcerpc_DnssrvComplexOperation2_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_DnssrvComplexOperation2_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_dnsserver,
			NDR_DNSSRVCOMPLEXOPERATION2, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_DnssrvComplexOperation2_r_done, req);

	return req;
}

static void dcerpc_DnssrvComplexOperation2_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_DnssrvComplexOperation2_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_DnssrvComplexOperation2_r_state *state =
		tevent_req_data(req,
		struct dcerpc_DnssrvComplexOperation2_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_DnssrvComplexOperation2_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct DnssrvComplexOperation2 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_dnsserver,
			NDR_DNSSRVCOMPLEXOPERATION2, mem_ctx, r);

	return status;
}

struct dcerpc_DnssrvComplexOperation2_state {
	struct DnssrvComplexOperation2 orig;
	struct DnssrvComplexOperation2 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_DnssrvComplexOperation2_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_DnssrvComplexOperation2_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       enum DNS_RPC_CLIENT_VERSION _dwClientVersion /* [in]  */,
						       uint32_t _dwSettingFlags /* [in]  */,
						       const char *_pwszServerName /* [in] [charset(UTF16),unique] */,
						       const char *_pszZone /* [in] [charset(UTF8),unique] */,
						       const char *_pszOperation /* [in] [charset(UTF8),unique] */,
						       enum DNS_RPC_TYPEID _dwTypeIn /* [in]  */,
						       union DNSSRV_RPC_UNION _pDataIn /* [in] [switch_is(dwTypeIn)] */,
						       enum DNS_RPC_TYPEID *_pdwTypeOut /* [out] [ref] */,
						       union DNSSRV_RPC_UNION *_ppDataOut /* [out] [switch_is(*pdwTypeOut),ref] */)
{
	struct tevent_req *req;
	struct dcerpc_DnssrvComplexOperation2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_DnssrvComplexOperation2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.dwClientVersion = _dwClientVersion;
	state->orig.in.dwSettingFlags = _dwSettingFlags;
	state->orig.in.pwszServerName = _pwszServerName;
	state->orig.in.pszZone = _pszZone;
	state->orig.in.pszOperation = _pszOperation;
	state->orig.in.dwTypeIn = _dwTypeIn;
	state->orig.in.pDataIn = _pDataIn;

	/* Out parameters */
	state->orig.out.pdwTypeOut = _pdwTypeOut;
	state->orig.out.ppDataOut = _ppDataOut;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_DnssrvComplexOperation2_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_DnssrvComplexOperation2_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_DnssrvComplexOperation2_done, req);
	return req;
}

static void dcerpc_DnssrvComplexOperation2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_DnssrvComplexOperation2_state *state = tevent_req_data(
		req, struct dcerpc_DnssrvComplexOperation2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_DnssrvComplexOperation2_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.pdwTypeOut = *state->tmp.out.pdwTypeOut;
	*state->orig.out.ppDataOut = *state->tmp.out.ppDataOut;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_DnssrvComplexOperation2_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     WERROR *result)
{
	struct dcerpc_DnssrvComplexOperation2_state *state = tevent_req_data(
		req, struct dcerpc_DnssrvComplexOperation2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_DnssrvComplexOperation2(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					enum DNS_RPC_CLIENT_VERSION _dwClientVersion /* [in]  */,
					uint32_t _dwSettingFlags /* [in]  */,
					const char *_pwszServerName /* [in] [charset(UTF16),unique] */,
					const char *_pszZone /* [in] [charset(UTF8),unique] */,
					const char *_pszOperation /* [in] [charset(UTF8),unique] */,
					enum DNS_RPC_TYPEID _dwTypeIn /* [in]  */,
					union DNSSRV_RPC_UNION _pDataIn /* [in] [switch_is(dwTypeIn)] */,
					enum DNS_RPC_TYPEID *_pdwTypeOut /* [out] [ref] */,
					union DNSSRV_RPC_UNION *_ppDataOut /* [out] [switch_is(*pdwTypeOut),ref] */,
					WERROR *result)
{
	struct DnssrvComplexOperation2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.dwClientVersion = _dwClientVersion;
	r.in.dwSettingFlags = _dwSettingFlags;
	r.in.pwszServerName = _pwszServerName;
	r.in.pszZone = _pszZone;
	r.in.pszOperation = _pszOperation;
	r.in.dwTypeIn = _dwTypeIn;
	r.in.pDataIn = _pDataIn;

	/* Out parameters */
	r.out.pdwTypeOut = _pdwTypeOut;
	r.out.ppDataOut = _ppDataOut;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_DnssrvComplexOperation2_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_pdwTypeOut = *r.out.pdwTypeOut;
	*_ppDataOut = *r.out.ppDataOut;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_DnssrvEnumRecords2_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_DnssrvEnumRecords2_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_DnssrvEnumRecords2_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct DnssrvEnumRecords2 *r)
{
	struct tevent_req *req;
	struct dcerpc_DnssrvEnumRecords2_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_DnssrvEnumRecords2_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_dnsserver,
			NDR_DNSSRVENUMRECORDS2, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_DnssrvEnumRecords2_r_done, req);

	return req;
}

static void dcerpc_DnssrvEnumRecords2_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_DnssrvEnumRecords2_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_DnssrvEnumRecords2_r_state *state =
		tevent_req_data(req,
		struct dcerpc_DnssrvEnumRecords2_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_DnssrvEnumRecords2_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct DnssrvEnumRecords2 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_dnsserver,
			NDR_DNSSRVENUMRECORDS2, mem_ctx, r);

	return status;
}

struct dcerpc_DnssrvEnumRecords2_state {
	struct DnssrvEnumRecords2 orig;
	struct DnssrvEnumRecords2 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_DnssrvEnumRecords2_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_DnssrvEnumRecords2_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct dcerpc_binding_handle *h,
						  enum DNS_RPC_CLIENT_VERSION _dwClientVersion /* [in]  */,
						  uint32_t _dwSettingFlags /* [in]  */,
						  const char *_pwszServerName /* [in] [charset(UTF16),unique] */,
						  const char *_pszZone /* [in] [unique,charset(UTF8)] */,
						  const char *_pszNodeName /* [in] [charset(UTF8),unique] */,
						  const char *_pszStartChild /* [in] [unique,charset(UTF8)] */,
						  enum dns_record_type _wRecordType /* [in]  */,
						  uint32_t _fSelectFlag /* [in]  */,
						  const char *_pszFilterStart /* [in] [unique,charset(UTF8)] */,
						  const char *_pszFilterStop /* [in] [unique,charset(UTF8)] */,
						  uint32_t *_pdwBufferLength /* [out] [ref] */,
						  struct DNS_RPC_RECORDS_ARRAY **_pBuffer /* [out] [ref,subcontext(4),subcontext_size(*pdwBufferLength)] */)
{
	struct tevent_req *req;
	struct dcerpc_DnssrvEnumRecords2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_DnssrvEnumRecords2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.dwClientVersion = _dwClientVersion;
	state->orig.in.dwSettingFlags = _dwSettingFlags;
	state->orig.in.pwszServerName = _pwszServerName;
	state->orig.in.pszZone = _pszZone;
	state->orig.in.pszNodeName = _pszNodeName;
	state->orig.in.pszStartChild = _pszStartChild;
	state->orig.in.wRecordType = _wRecordType;
	state->orig.in.fSelectFlag = _fSelectFlag;
	state->orig.in.pszFilterStart = _pszFilterStart;
	state->orig.in.pszFilterStop = _pszFilterStop;

	/* Out parameters */
	state->orig.out.pdwBufferLength = _pdwBufferLength;
	state->orig.out.pBuffer = _pBuffer;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_DnssrvEnumRecords2_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_DnssrvEnumRecords2_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_DnssrvEnumRecords2_done, req);
	return req;
}

static void dcerpc_DnssrvEnumRecords2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_DnssrvEnumRecords2_state *state = tevent_req_data(
		req, struct dcerpc_DnssrvEnumRecords2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_DnssrvEnumRecords2_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.pdwBufferLength = *state->tmp.out.pdwBufferLength;
	*state->orig.out.pBuffer = *state->tmp.out.pBuffer;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_DnssrvEnumRecords2_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					WERROR *result)
{
	struct dcerpc_DnssrvEnumRecords2_state *state = tevent_req_data(
		req, struct dcerpc_DnssrvEnumRecords2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_DnssrvEnumRecords2(struct dcerpc_binding_handle *h,
				   TALLOC_CTX *mem_ctx,
				   enum DNS_RPC_CLIENT_VERSION _dwClientVersion /* [in]  */,
				   uint32_t _dwSettingFlags /* [in]  */,
				   const char *_pwszServerName /* [in] [charset(UTF16),unique] */,
				   const char *_pszZone /* [in] [unique,charset(UTF8)] */,
				   const char *_pszNodeName /* [in] [charset(UTF8),unique] */,
				   const char *_pszStartChild /* [in] [unique,charset(UTF8)] */,
				   enum dns_record_type _wRecordType /* [in]  */,
				   uint32_t _fSelectFlag /* [in]  */,
				   const char *_pszFilterStart /* [in] [unique,charset(UTF8)] */,
				   const char *_pszFilterStop /* [in] [unique,charset(UTF8)] */,
				   uint32_t *_pdwBufferLength /* [out] [ref] */,
				   struct DNS_RPC_RECORDS_ARRAY **_pBuffer /* [out] [ref,subcontext(4),subcontext_size(*pdwBufferLength)] */,
				   WERROR *result)
{
	struct DnssrvEnumRecords2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.dwClientVersion = _dwClientVersion;
	r.in.dwSettingFlags = _dwSettingFlags;
	r.in.pwszServerName = _pwszServerName;
	r.in.pszZone = _pszZone;
	r.in.pszNodeName = _pszNodeName;
	r.in.pszStartChild = _pszStartChild;
	r.in.wRecordType = _wRecordType;
	r.in.fSelectFlag = _fSelectFlag;
	r.in.pszFilterStart = _pszFilterStart;
	r.in.pszFilterStop = _pszFilterStop;

	/* Out parameters */
	r.out.pdwBufferLength = _pdwBufferLength;
	r.out.pBuffer = _pBuffer;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_DnssrvEnumRecords2_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_pdwBufferLength = *r.out.pdwBufferLength;
	*_pBuffer = *r.out.pBuffer;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_DnssrvUpdateRecord2_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_DnssrvUpdateRecord2_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_DnssrvUpdateRecord2_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct DnssrvUpdateRecord2 *r)
{
	struct tevent_req *req;
	struct dcerpc_DnssrvUpdateRecord2_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_DnssrvUpdateRecord2_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_dnsserver,
			NDR_DNSSRVUPDATERECORD2, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_DnssrvUpdateRecord2_r_done, req);

	return req;
}

static void dcerpc_DnssrvUpdateRecord2_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_DnssrvUpdateRecord2_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_DnssrvUpdateRecord2_r_state *state =
		tevent_req_data(req,
		struct dcerpc_DnssrvUpdateRecord2_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_DnssrvUpdateRecord2_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct DnssrvUpdateRecord2 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_dnsserver,
			NDR_DNSSRVUPDATERECORD2, mem_ctx, r);

	return status;
}

struct dcerpc_DnssrvUpdateRecord2_state {
	struct DnssrvUpdateRecord2 orig;
	struct DnssrvUpdateRecord2 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_DnssrvUpdateRecord2_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_DnssrvUpdateRecord2_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct dcerpc_binding_handle *h,
						   enum DNS_RPC_CLIENT_VERSION _dwClientVersion /* [in]  */,
						   uint32_t _dwSettingFlags /* [in]  */,
						   const char *_pwszServerName /* [in] [unique,charset(UTF16)] */,
						   const char *_pszZone /* [in] [unique,charset(UTF8)] */,
						   const char *_pszNodeName /* [in] [ref,charset(UTF8)] */,
						   struct DNS_RPC_RECORD_BUF *_pAddRecord /* [in] [unique] */,
						   struct DNS_RPC_RECORD_BUF *_pDeleteRecord /* [in] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_DnssrvUpdateRecord2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_DnssrvUpdateRecord2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.dwClientVersion = _dwClientVersion;
	state->orig.in.dwSettingFlags = _dwSettingFlags;
	state->orig.in.pwszServerName = _pwszServerName;
	state->orig.in.pszZone = _pszZone;
	state->orig.in.pszNodeName = _pszNodeName;
	state->orig.in.pAddRecord = _pAddRecord;
	state->orig.in.pDeleteRecord = _pDeleteRecord;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_DnssrvUpdateRecord2_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_DnssrvUpdateRecord2_done, req);
	return req;
}

static void dcerpc_DnssrvUpdateRecord2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_DnssrvUpdateRecord2_state *state = tevent_req_data(
		req, struct dcerpc_DnssrvUpdateRecord2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_DnssrvUpdateRecord2_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_DnssrvUpdateRecord2_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 WERROR *result)
{
	struct dcerpc_DnssrvUpdateRecord2_state *state = tevent_req_data(
		req, struct dcerpc_DnssrvUpdateRecord2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_DnssrvUpdateRecord2(struct dcerpc_binding_handle *h,
				    TALLOC_CTX *mem_ctx,
				    enum DNS_RPC_CLIENT_VERSION _dwClientVersion /* [in]  */,
				    uint32_t _dwSettingFlags /* [in]  */,
				    const char *_pwszServerName /* [in] [unique,charset(UTF16)] */,
				    const char *_pszZone /* [in] [unique,charset(UTF8)] */,
				    const char *_pszNodeName /* [in] [ref,charset(UTF8)] */,
				    struct DNS_RPC_RECORD_BUF *_pAddRecord /* [in] [unique] */,
				    struct DNS_RPC_RECORD_BUF *_pDeleteRecord /* [in] [unique] */,
				    WERROR *result)
{
	struct DnssrvUpdateRecord2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.dwClientVersion = _dwClientVersion;
	r.in.dwSettingFlags = _dwSettingFlags;
	r.in.pwszServerName = _pwszServerName;
	r.in.pszZone = _pszZone;
	r.in.pszNodeName = _pszNodeName;
	r.in.pAddRecord = _pAddRecord;
	r.in.pDeleteRecord = _pDeleteRecord;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_DnssrvUpdateRecord2_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

