/* client functions auto-generated by pidl */

#include "includes.h"
#include <tevent.h>
#include "lib/util/tevent_ntstatus.h"
#include "autoconf/librpc/gen_ndr/ndr_dfs.h"
#include "autoconf/librpc/gen_ndr/ndr_dfs_c.h"

/* netdfs - client functions generated by pidl */

struct dcerpc_dfs_GetManagerVersion_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_dfs_GetManagerVersion_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_dfs_GetManagerVersion_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct dfs_GetManagerVersion *r)
{
	struct tevent_req *req;
	struct dcerpc_dfs_GetManagerVersion_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_dfs_GetManagerVersion_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netdfs,
			NDR_DFS_GETMANAGERVERSION, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_dfs_GetManagerVersion_r_done, req);

	return req;
}

static void dcerpc_dfs_GetManagerVersion_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_dfs_GetManagerVersion_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_dfs_GetManagerVersion_r_state *state =
		tevent_req_data(req,
		struct dcerpc_dfs_GetManagerVersion_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_dfs_GetManagerVersion_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct dfs_GetManagerVersion *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netdfs,
			NDR_DFS_GETMANAGERVERSION, mem_ctx, r);

	return status;
}

struct dcerpc_dfs_GetManagerVersion_state {
	struct dfs_GetManagerVersion orig;
	struct dfs_GetManagerVersion tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_dfs_GetManagerVersion_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_dfs_GetManagerVersion_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     enum dfs_ManagerVersion *_version /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_dfs_GetManagerVersion_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_dfs_GetManagerVersion_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */
	state->orig.out.version = _version;

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_dfs_GetManagerVersion_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_dfs_GetManagerVersion_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_dfs_GetManagerVersion_done, req);
	return req;
}

static void dcerpc_dfs_GetManagerVersion_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_dfs_GetManagerVersion_state *state = tevent_req_data(
		req, struct dcerpc_dfs_GetManagerVersion_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_dfs_GetManagerVersion_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.version = *state->tmp.out.version;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_dfs_GetManagerVersion_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx)
{
	struct dcerpc_dfs_GetManagerVersion_state *state = tevent_req_data(
		req, struct dcerpc_dfs_GetManagerVersion_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_dfs_GetManagerVersion(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      enum dfs_ManagerVersion *_version /* [out] [ref] */)
{
	struct dfs_GetManagerVersion r;
	NTSTATUS status;

	/* In parameters */

	/* Out parameters */
	r.out.version = _version;

	status = dcerpc_dfs_GetManagerVersion_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_version = *r.out.version;

	/* Return result */

	return NT_STATUS_OK;
}

struct dcerpc_dfs_Add_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_dfs_Add_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_dfs_Add_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct dfs_Add *r)
{
	struct tevent_req *req;
	struct dcerpc_dfs_Add_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_dfs_Add_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netdfs,
			NDR_DFS_ADD, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_dfs_Add_r_done, req);

	return req;
}

static void dcerpc_dfs_Add_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_dfs_Add_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_dfs_Add_r_state *state =
		tevent_req_data(req,
		struct dcerpc_dfs_Add_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_dfs_Add_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct dfs_Add *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netdfs,
			NDR_DFS_ADD, mem_ctx, r);

	return status;
}

struct dcerpc_dfs_Add_state {
	struct dfs_Add orig;
	struct dfs_Add tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_dfs_Add_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_dfs_Add_send(TALLOC_CTX *mem_ctx,
				       struct tevent_context *ev,
				       struct dcerpc_binding_handle *h,
				       const char *_path /* [in] [ref,charset(UTF16)] */,
				       const char *_server /* [in] [charset(UTF16),ref] */,
				       const char *_share /* [in] [charset(UTF16),unique] */,
				       const char *_comment /* [in] [unique,charset(UTF16)] */,
				       uint32_t _flags /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_dfs_Add_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_dfs_Add_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.path = _path;
	state->orig.in.server = _server;
	state->orig.in.share = _share;
	state->orig.in.comment = _comment;
	state->orig.in.flags = _flags;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_dfs_Add_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_dfs_Add_done, req);
	return req;
}

static void dcerpc_dfs_Add_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_dfs_Add_state *state = tevent_req_data(
		req, struct dcerpc_dfs_Add_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_dfs_Add_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_dfs_Add_recv(struct tevent_req *req,
			     TALLOC_CTX *mem_ctx,
			     WERROR *result)
{
	struct dcerpc_dfs_Add_state *state = tevent_req_data(
		req, struct dcerpc_dfs_Add_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_dfs_Add(struct dcerpc_binding_handle *h,
			TALLOC_CTX *mem_ctx,
			const char *_path /* [in] [ref,charset(UTF16)] */,
			const char *_server /* [in] [charset(UTF16),ref] */,
			const char *_share /* [in] [charset(UTF16),unique] */,
			const char *_comment /* [in] [unique,charset(UTF16)] */,
			uint32_t _flags /* [in]  */,
			WERROR *result)
{
	struct dfs_Add r;
	NTSTATUS status;

	/* In parameters */
	r.in.path = _path;
	r.in.server = _server;
	r.in.share = _share;
	r.in.comment = _comment;
	r.in.flags = _flags;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_dfs_Add_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_dfs_Remove_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_dfs_Remove_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_dfs_Remove_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct dfs_Remove *r)
{
	struct tevent_req *req;
	struct dcerpc_dfs_Remove_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_dfs_Remove_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netdfs,
			NDR_DFS_REMOVE, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_dfs_Remove_r_done, req);

	return req;
}

static void dcerpc_dfs_Remove_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_dfs_Remove_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_dfs_Remove_r_state *state =
		tevent_req_data(req,
		struct dcerpc_dfs_Remove_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_dfs_Remove_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct dfs_Remove *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netdfs,
			NDR_DFS_REMOVE, mem_ctx, r);

	return status;
}

struct dcerpc_dfs_Remove_state {
	struct dfs_Remove orig;
	struct dfs_Remove tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_dfs_Remove_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_dfs_Remove_send(TALLOC_CTX *mem_ctx,
					  struct tevent_context *ev,
					  struct dcerpc_binding_handle *h,
					  const char *_dfs_entry_path /* [in] [charset(UTF16),ref] */,
					  const char *_servername /* [in] [charset(UTF16),unique] */,
					  const char *_sharename /* [in] [charset(UTF16),unique] */)
{
	struct tevent_req *req;
	struct dcerpc_dfs_Remove_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_dfs_Remove_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.dfs_entry_path = _dfs_entry_path;
	state->orig.in.servername = _servername;
	state->orig.in.sharename = _sharename;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_dfs_Remove_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_dfs_Remove_done, req);
	return req;
}

static void dcerpc_dfs_Remove_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_dfs_Remove_state *state = tevent_req_data(
		req, struct dcerpc_dfs_Remove_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_dfs_Remove_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_dfs_Remove_recv(struct tevent_req *req,
				TALLOC_CTX *mem_ctx,
				WERROR *result)
{
	struct dcerpc_dfs_Remove_state *state = tevent_req_data(
		req, struct dcerpc_dfs_Remove_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_dfs_Remove(struct dcerpc_binding_handle *h,
			   TALLOC_CTX *mem_ctx,
			   const char *_dfs_entry_path /* [in] [charset(UTF16),ref] */,
			   const char *_servername /* [in] [charset(UTF16),unique] */,
			   const char *_sharename /* [in] [charset(UTF16),unique] */,
			   WERROR *result)
{
	struct dfs_Remove r;
	NTSTATUS status;

	/* In parameters */
	r.in.dfs_entry_path = _dfs_entry_path;
	r.in.servername = _servername;
	r.in.sharename = _sharename;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_dfs_Remove_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_dfs_SetInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_dfs_SetInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_dfs_SetInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct dfs_SetInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_dfs_SetInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_dfs_SetInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netdfs,
			NDR_DFS_SETINFO, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_dfs_SetInfo_r_done, req);

	return req;
}

static void dcerpc_dfs_SetInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_dfs_SetInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_dfs_SetInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_dfs_SetInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_dfs_SetInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct dfs_SetInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netdfs,
			NDR_DFS_SETINFO, mem_ctx, r);

	return status;
}

struct dcerpc_dfs_SetInfo_state {
	struct dfs_SetInfo orig;
	struct dfs_SetInfo tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_dfs_SetInfo_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_dfs_SetInfo_send(TALLOC_CTX *mem_ctx,
					   struct tevent_context *ev,
					   struct dcerpc_binding_handle *h,
					   const char *_dfs_entry_path /* [in] [charset(UTF16)] */,
					   const char *_servername /* [in] [charset(UTF16),unique] */,
					   const char *_sharename /* [in] [charset(UTF16),unique] */,
					   uint32_t _level /* [in]  */,
					   union dfs_Info *_info /* [in] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_dfs_SetInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_dfs_SetInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.dfs_entry_path = _dfs_entry_path;
	state->orig.in.servername = _servername;
	state->orig.in.sharename = _sharename;
	state->orig.in.level = _level;
	state->orig.in.info = _info;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_dfs_SetInfo_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_dfs_SetInfo_done, req);
	return req;
}

static void dcerpc_dfs_SetInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_dfs_SetInfo_state *state = tevent_req_data(
		req, struct dcerpc_dfs_SetInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_dfs_SetInfo_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_dfs_SetInfo_recv(struct tevent_req *req,
				 TALLOC_CTX *mem_ctx,
				 WERROR *result)
{
	struct dcerpc_dfs_SetInfo_state *state = tevent_req_data(
		req, struct dcerpc_dfs_SetInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_dfs_SetInfo(struct dcerpc_binding_handle *h,
			    TALLOC_CTX *mem_ctx,
			    const char *_dfs_entry_path /* [in] [charset(UTF16)] */,
			    const char *_servername /* [in] [charset(UTF16),unique] */,
			    const char *_sharename /* [in] [charset(UTF16),unique] */,
			    uint32_t _level /* [in]  */,
			    union dfs_Info *_info /* [in] [ref,switch_is(level)] */,
			    WERROR *result)
{
	struct dfs_SetInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.dfs_entry_path = _dfs_entry_path;
	r.in.servername = _servername;
	r.in.sharename = _sharename;
	r.in.level = _level;
	r.in.info = _info;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_dfs_SetInfo_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_dfs_GetInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_dfs_GetInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_dfs_GetInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct dfs_GetInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_dfs_GetInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_dfs_GetInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netdfs,
			NDR_DFS_GETINFO, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_dfs_GetInfo_r_done, req);

	return req;
}

static void dcerpc_dfs_GetInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_dfs_GetInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_dfs_GetInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_dfs_GetInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_dfs_GetInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct dfs_GetInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netdfs,
			NDR_DFS_GETINFO, mem_ctx, r);

	return status;
}

struct dcerpc_dfs_GetInfo_state {
	struct dfs_GetInfo orig;
	struct dfs_GetInfo tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_dfs_GetInfo_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_dfs_GetInfo_send(TALLOC_CTX *mem_ctx,
					   struct tevent_context *ev,
					   struct dcerpc_binding_handle *h,
					   const char *_dfs_entry_path /* [in] [charset(UTF16)] */,
					   const char *_servername /* [in] [unique,charset(UTF16)] */,
					   const char *_sharename /* [in] [charset(UTF16),unique] */,
					   uint32_t _level /* [in]  */,
					   union dfs_Info *_info /* [out] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_dfs_GetInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_dfs_GetInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.dfs_entry_path = _dfs_entry_path;
	state->orig.in.servername = _servername;
	state->orig.in.sharename = _sharename;
	state->orig.in.level = _level;

	/* Out parameters */
	state->orig.out.info = _info;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_dfs_GetInfo_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_dfs_GetInfo_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_dfs_GetInfo_done, req);
	return req;
}

static void dcerpc_dfs_GetInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_dfs_GetInfo_state *state = tevent_req_data(
		req, struct dcerpc_dfs_GetInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_dfs_GetInfo_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_dfs_GetInfo_recv(struct tevent_req *req,
				 TALLOC_CTX *mem_ctx,
				 WERROR *result)
{
	struct dcerpc_dfs_GetInfo_state *state = tevent_req_data(
		req, struct dcerpc_dfs_GetInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_dfs_GetInfo(struct dcerpc_binding_handle *h,
			    TALLOC_CTX *mem_ctx,
			    const char *_dfs_entry_path /* [in] [charset(UTF16)] */,
			    const char *_servername /* [in] [unique,charset(UTF16)] */,
			    const char *_sharename /* [in] [charset(UTF16),unique] */,
			    uint32_t _level /* [in]  */,
			    union dfs_Info *_info /* [out] [ref,switch_is(level)] */,
			    WERROR *result)
{
	struct dfs_GetInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.dfs_entry_path = _dfs_entry_path;
	r.in.servername = _servername;
	r.in.sharename = _sharename;
	r.in.level = _level;

	/* Out parameters */
	r.out.info = _info;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_dfs_GetInfo_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_info = *r.out.info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_dfs_Enum_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_dfs_Enum_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_dfs_Enum_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct dfs_Enum *r)
{
	struct tevent_req *req;
	struct dcerpc_dfs_Enum_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_dfs_Enum_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netdfs,
			NDR_DFS_ENUM, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_dfs_Enum_r_done, req);

	return req;
}

static void dcerpc_dfs_Enum_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_dfs_Enum_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_dfs_Enum_r_state *state =
		tevent_req_data(req,
		struct dcerpc_dfs_Enum_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_dfs_Enum_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct dfs_Enum *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netdfs,
			NDR_DFS_ENUM, mem_ctx, r);

	return status;
}

struct dcerpc_dfs_Enum_state {
	struct dfs_Enum orig;
	struct dfs_Enum tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_dfs_Enum_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_dfs_Enum_send(TALLOC_CTX *mem_ctx,
					struct tevent_context *ev,
					struct dcerpc_binding_handle *h,
					uint32_t _level /* [in]  */,
					uint32_t _bufsize /* [in]  */,
					struct dfs_EnumStruct *_info /* [in,out] [unique] */,
					uint32_t *_total /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_dfs_Enum_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_dfs_Enum_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.level = _level;
	state->orig.in.bufsize = _bufsize;
	state->orig.in.info = _info;
	state->orig.in.total = _total;

	/* Out parameters */
	state->orig.out.info = _info;
	state->orig.out.total = _total;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_dfs_Enum_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_dfs_Enum_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_dfs_Enum_done, req);
	return req;
}

static void dcerpc_dfs_Enum_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_dfs_Enum_state *state = tevent_req_data(
		req, struct dcerpc_dfs_Enum_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_dfs_Enum_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.info && state->tmp.out.info) {
		*state->orig.out.info = *state->tmp.out.info;
	}
	if (state->orig.out.total && state->tmp.out.total) {
		*state->orig.out.total = *state->tmp.out.total;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_dfs_Enum_recv(struct tevent_req *req,
			      TALLOC_CTX *mem_ctx,
			      WERROR *result)
{
	struct dcerpc_dfs_Enum_state *state = tevent_req_data(
		req, struct dcerpc_dfs_Enum_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_dfs_Enum(struct dcerpc_binding_handle *h,
			 TALLOC_CTX *mem_ctx,
			 uint32_t _level /* [in]  */,
			 uint32_t _bufsize /* [in]  */,
			 struct dfs_EnumStruct *_info /* [in,out] [unique] */,
			 uint32_t *_total /* [in,out] [unique] */,
			 WERROR *result)
{
	struct dfs_Enum r;
	NTSTATUS status;

	/* In parameters */
	r.in.level = _level;
	r.in.bufsize = _bufsize;
	r.in.info = _info;
	r.in.total = _total;

	/* Out parameters */
	r.out.info = _info;
	r.out.total = _total;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_dfs_Enum_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_info && r.out.info) {
		*_info = *r.out.info;
	}
	if (_total && r.out.total) {
		*_total = *r.out.total;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_dfs_AddFtRoot_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_dfs_AddFtRoot_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_dfs_AddFtRoot_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct dfs_AddFtRoot *r)
{
	struct tevent_req *req;
	struct dcerpc_dfs_AddFtRoot_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_dfs_AddFtRoot_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netdfs,
			NDR_DFS_ADDFTROOT, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_dfs_AddFtRoot_r_done, req);

	return req;
}

static void dcerpc_dfs_AddFtRoot_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_dfs_AddFtRoot_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_dfs_AddFtRoot_r_state *state =
		tevent_req_data(req,
		struct dcerpc_dfs_AddFtRoot_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_dfs_AddFtRoot_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct dfs_AddFtRoot *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netdfs,
			NDR_DFS_ADDFTROOT, mem_ctx, r);

	return status;
}

struct dcerpc_dfs_AddFtRoot_state {
	struct dfs_AddFtRoot orig;
	struct dfs_AddFtRoot tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_dfs_AddFtRoot_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_dfs_AddFtRoot_send(TALLOC_CTX *mem_ctx,
					     struct tevent_context *ev,
					     struct dcerpc_binding_handle *h,
					     const char *_servername /* [in] [charset(UTF16)] */,
					     const char *_dns_servername /* [in] [charset(UTF16)] */,
					     const char *_dfsname /* [in] [charset(UTF16)] */,
					     const char *_rootshare /* [in] [charset(UTF16)] */,
					     const char *_comment /* [in] [charset(UTF16)] */,
					     const char *_dfs_config_dn /* [in] [charset(UTF16)] */,
					     uint8_t _unknown1 /* [in]  */,
					     uint32_t _flags /* [in]  */,
					     struct dfs_UnknownStruct **_unknown2 /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_dfs_AddFtRoot_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_dfs_AddFtRoot_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.servername = _servername;
	state->orig.in.dns_servername = _dns_servername;
	state->orig.in.dfsname = _dfsname;
	state->orig.in.rootshare = _rootshare;
	state->orig.in.comment = _comment;
	state->orig.in.dfs_config_dn = _dfs_config_dn;
	state->orig.in.unknown1 = _unknown1;
	state->orig.in.flags = _flags;
	state->orig.in.unknown2 = _unknown2;

	/* Out parameters */
	state->orig.out.unknown2 = _unknown2;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_dfs_AddFtRoot_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_dfs_AddFtRoot_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_dfs_AddFtRoot_done, req);
	return req;
}

static void dcerpc_dfs_AddFtRoot_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_dfs_AddFtRoot_state *state = tevent_req_data(
		req, struct dcerpc_dfs_AddFtRoot_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_dfs_AddFtRoot_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.unknown2 && state->tmp.out.unknown2) {
		*state->orig.out.unknown2 = *state->tmp.out.unknown2;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_dfs_AddFtRoot_recv(struct tevent_req *req,
				   TALLOC_CTX *mem_ctx,
				   WERROR *result)
{
	struct dcerpc_dfs_AddFtRoot_state *state = tevent_req_data(
		req, struct dcerpc_dfs_AddFtRoot_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_dfs_AddFtRoot(struct dcerpc_binding_handle *h,
			      TALLOC_CTX *mem_ctx,
			      const char *_servername /* [in] [charset(UTF16)] */,
			      const char *_dns_servername /* [in] [charset(UTF16)] */,
			      const char *_dfsname /* [in] [charset(UTF16)] */,
			      const char *_rootshare /* [in] [charset(UTF16)] */,
			      const char *_comment /* [in] [charset(UTF16)] */,
			      const char *_dfs_config_dn /* [in] [charset(UTF16)] */,
			      uint8_t _unknown1 /* [in]  */,
			      uint32_t _flags /* [in]  */,
			      struct dfs_UnknownStruct **_unknown2 /* [in,out] [unique] */,
			      WERROR *result)
{
	struct dfs_AddFtRoot r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = _servername;
	r.in.dns_servername = _dns_servername;
	r.in.dfsname = _dfsname;
	r.in.rootshare = _rootshare;
	r.in.comment = _comment;
	r.in.dfs_config_dn = _dfs_config_dn;
	r.in.unknown1 = _unknown1;
	r.in.flags = _flags;
	r.in.unknown2 = _unknown2;

	/* Out parameters */
	r.out.unknown2 = _unknown2;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_dfs_AddFtRoot_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_unknown2 && r.out.unknown2) {
		*_unknown2 = *r.out.unknown2;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_dfs_RemoveFtRoot_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_dfs_RemoveFtRoot_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_dfs_RemoveFtRoot_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct dfs_RemoveFtRoot *r)
{
	struct tevent_req *req;
	struct dcerpc_dfs_RemoveFtRoot_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_dfs_RemoveFtRoot_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netdfs,
			NDR_DFS_REMOVEFTROOT, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_dfs_RemoveFtRoot_r_done, req);

	return req;
}

static void dcerpc_dfs_RemoveFtRoot_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_dfs_RemoveFtRoot_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_dfs_RemoveFtRoot_r_state *state =
		tevent_req_data(req,
		struct dcerpc_dfs_RemoveFtRoot_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_dfs_RemoveFtRoot_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct dfs_RemoveFtRoot *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netdfs,
			NDR_DFS_REMOVEFTROOT, mem_ctx, r);

	return status;
}

struct dcerpc_dfs_RemoveFtRoot_state {
	struct dfs_RemoveFtRoot orig;
	struct dfs_RemoveFtRoot tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_dfs_RemoveFtRoot_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_dfs_RemoveFtRoot_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						const char *_servername /* [in] [charset(UTF16)] */,
						const char *_dns_servername /* [in] [charset(UTF16)] */,
						const char *_dfsname /* [in] [charset(UTF16)] */,
						const char *_rootshare /* [in] [charset(UTF16)] */,
						uint32_t _flags /* [in]  */,
						struct dfs_UnknownStruct **_unknown /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_dfs_RemoveFtRoot_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_dfs_RemoveFtRoot_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.servername = _servername;
	state->orig.in.dns_servername = _dns_servername;
	state->orig.in.dfsname = _dfsname;
	state->orig.in.rootshare = _rootshare;
	state->orig.in.flags = _flags;
	state->orig.in.unknown = _unknown;

	/* Out parameters */
	state->orig.out.unknown = _unknown;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_dfs_RemoveFtRoot_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_dfs_RemoveFtRoot_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_dfs_RemoveFtRoot_done, req);
	return req;
}

static void dcerpc_dfs_RemoveFtRoot_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_dfs_RemoveFtRoot_state *state = tevent_req_data(
		req, struct dcerpc_dfs_RemoveFtRoot_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_dfs_RemoveFtRoot_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.unknown && state->tmp.out.unknown) {
		*state->orig.out.unknown = *state->tmp.out.unknown;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_dfs_RemoveFtRoot_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result)
{
	struct dcerpc_dfs_RemoveFtRoot_state *state = tevent_req_data(
		req, struct dcerpc_dfs_RemoveFtRoot_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_dfs_RemoveFtRoot(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 const char *_servername /* [in] [charset(UTF16)] */,
				 const char *_dns_servername /* [in] [charset(UTF16)] */,
				 const char *_dfsname /* [in] [charset(UTF16)] */,
				 const char *_rootshare /* [in] [charset(UTF16)] */,
				 uint32_t _flags /* [in]  */,
				 struct dfs_UnknownStruct **_unknown /* [in,out] [unique] */,
				 WERROR *result)
{
	struct dfs_RemoveFtRoot r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = _servername;
	r.in.dns_servername = _dns_servername;
	r.in.dfsname = _dfsname;
	r.in.rootshare = _rootshare;
	r.in.flags = _flags;
	r.in.unknown = _unknown;

	/* Out parameters */
	r.out.unknown = _unknown;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_dfs_RemoveFtRoot_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_unknown && r.out.unknown) {
		*_unknown = *r.out.unknown;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_dfs_AddStdRoot_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_dfs_AddStdRoot_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_dfs_AddStdRoot_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct dfs_AddStdRoot *r)
{
	struct tevent_req *req;
	struct dcerpc_dfs_AddStdRoot_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_dfs_AddStdRoot_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netdfs,
			NDR_DFS_ADDSTDROOT, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_dfs_AddStdRoot_r_done, req);

	return req;
}

static void dcerpc_dfs_AddStdRoot_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_dfs_AddStdRoot_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_dfs_AddStdRoot_r_state *state =
		tevent_req_data(req,
		struct dcerpc_dfs_AddStdRoot_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_dfs_AddStdRoot_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct dfs_AddStdRoot *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netdfs,
			NDR_DFS_ADDSTDROOT, mem_ctx, r);

	return status;
}

struct dcerpc_dfs_AddStdRoot_state {
	struct dfs_AddStdRoot orig;
	struct dfs_AddStdRoot tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_dfs_AddStdRoot_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_dfs_AddStdRoot_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct dcerpc_binding_handle *h,
					      const char *_servername /* [in] [charset(UTF16)] */,
					      const char *_rootshare /* [in] [charset(UTF16)] */,
					      const char *_comment /* [in] [charset(UTF16)] */,
					      uint32_t _flags /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_dfs_AddStdRoot_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_dfs_AddStdRoot_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.servername = _servername;
	state->orig.in.rootshare = _rootshare;
	state->orig.in.comment = _comment;
	state->orig.in.flags = _flags;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_dfs_AddStdRoot_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_dfs_AddStdRoot_done, req);
	return req;
}

static void dcerpc_dfs_AddStdRoot_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_dfs_AddStdRoot_state *state = tevent_req_data(
		req, struct dcerpc_dfs_AddStdRoot_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_dfs_AddStdRoot_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_dfs_AddStdRoot_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    WERROR *result)
{
	struct dcerpc_dfs_AddStdRoot_state *state = tevent_req_data(
		req, struct dcerpc_dfs_AddStdRoot_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_dfs_AddStdRoot(struct dcerpc_binding_handle *h,
			       TALLOC_CTX *mem_ctx,
			       const char *_servername /* [in] [charset(UTF16)] */,
			       const char *_rootshare /* [in] [charset(UTF16)] */,
			       const char *_comment /* [in] [charset(UTF16)] */,
			       uint32_t _flags /* [in]  */,
			       WERROR *result)
{
	struct dfs_AddStdRoot r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = _servername;
	r.in.rootshare = _rootshare;
	r.in.comment = _comment;
	r.in.flags = _flags;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_dfs_AddStdRoot_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_dfs_RemoveStdRoot_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_dfs_RemoveStdRoot_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_dfs_RemoveStdRoot_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct dfs_RemoveStdRoot *r)
{
	struct tevent_req *req;
	struct dcerpc_dfs_RemoveStdRoot_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_dfs_RemoveStdRoot_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netdfs,
			NDR_DFS_REMOVESTDROOT, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_dfs_RemoveStdRoot_r_done, req);

	return req;
}

static void dcerpc_dfs_RemoveStdRoot_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_dfs_RemoveStdRoot_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_dfs_RemoveStdRoot_r_state *state =
		tevent_req_data(req,
		struct dcerpc_dfs_RemoveStdRoot_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_dfs_RemoveStdRoot_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct dfs_RemoveStdRoot *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netdfs,
			NDR_DFS_REMOVESTDROOT, mem_ctx, r);

	return status;
}

struct dcerpc_dfs_RemoveStdRoot_state {
	struct dfs_RemoveStdRoot orig;
	struct dfs_RemoveStdRoot tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_dfs_RemoveStdRoot_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_dfs_RemoveStdRoot_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 const char *_servername /* [in] [charset(UTF16)] */,
						 const char *_rootshare /* [in] [charset(UTF16)] */,
						 uint32_t _flags /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_dfs_RemoveStdRoot_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_dfs_RemoveStdRoot_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.servername = _servername;
	state->orig.in.rootshare = _rootshare;
	state->orig.in.flags = _flags;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_dfs_RemoveStdRoot_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_dfs_RemoveStdRoot_done, req);
	return req;
}

static void dcerpc_dfs_RemoveStdRoot_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_dfs_RemoveStdRoot_state *state = tevent_req_data(
		req, struct dcerpc_dfs_RemoveStdRoot_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_dfs_RemoveStdRoot_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_dfs_RemoveStdRoot_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       WERROR *result)
{
	struct dcerpc_dfs_RemoveStdRoot_state *state = tevent_req_data(
		req, struct dcerpc_dfs_RemoveStdRoot_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_dfs_RemoveStdRoot(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  const char *_servername /* [in] [charset(UTF16)] */,
				  const char *_rootshare /* [in] [charset(UTF16)] */,
				  uint32_t _flags /* [in]  */,
				  WERROR *result)
{
	struct dfs_RemoveStdRoot r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = _servername;
	r.in.rootshare = _rootshare;
	r.in.flags = _flags;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_dfs_RemoveStdRoot_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_dfs_ManagerInitialize_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_dfs_ManagerInitialize_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_dfs_ManagerInitialize_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct dfs_ManagerInitialize *r)
{
	struct tevent_req *req;
	struct dcerpc_dfs_ManagerInitialize_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_dfs_ManagerInitialize_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netdfs,
			NDR_DFS_MANAGERINITIALIZE, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_dfs_ManagerInitialize_r_done, req);

	return req;
}

static void dcerpc_dfs_ManagerInitialize_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_dfs_ManagerInitialize_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_dfs_ManagerInitialize_r_state *state =
		tevent_req_data(req,
		struct dcerpc_dfs_ManagerInitialize_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_dfs_ManagerInitialize_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct dfs_ManagerInitialize *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netdfs,
			NDR_DFS_MANAGERINITIALIZE, mem_ctx, r);

	return status;
}

struct dcerpc_dfs_ManagerInitialize_state {
	struct dfs_ManagerInitialize orig;
	struct dfs_ManagerInitialize tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_dfs_ManagerInitialize_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_dfs_ManagerInitialize_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     const char *_servername /* [in] [charset(UTF16),ref] */,
						     uint32_t _flags /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_dfs_ManagerInitialize_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_dfs_ManagerInitialize_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.servername = _servername;
	state->orig.in.flags = _flags;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_dfs_ManagerInitialize_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_dfs_ManagerInitialize_done, req);
	return req;
}

static void dcerpc_dfs_ManagerInitialize_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_dfs_ManagerInitialize_state *state = tevent_req_data(
		req, struct dcerpc_dfs_ManagerInitialize_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_dfs_ManagerInitialize_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_dfs_ManagerInitialize_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_dfs_ManagerInitialize_state *state = tevent_req_data(
		req, struct dcerpc_dfs_ManagerInitialize_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_dfs_ManagerInitialize(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      const char *_servername /* [in] [charset(UTF16),ref] */,
				      uint32_t _flags /* [in]  */,
				      WERROR *result)
{
	struct dfs_ManagerInitialize r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = _servername;
	r.in.flags = _flags;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_dfs_ManagerInitialize_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_dfs_AddStdRootForced_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_dfs_AddStdRootForced_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_dfs_AddStdRootForced_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct dfs_AddStdRootForced *r)
{
	struct tevent_req *req;
	struct dcerpc_dfs_AddStdRootForced_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_dfs_AddStdRootForced_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netdfs,
			NDR_DFS_ADDSTDROOTFORCED, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_dfs_AddStdRootForced_r_done, req);

	return req;
}

static void dcerpc_dfs_AddStdRootForced_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_dfs_AddStdRootForced_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_dfs_AddStdRootForced_r_state *state =
		tevent_req_data(req,
		struct dcerpc_dfs_AddStdRootForced_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_dfs_AddStdRootForced_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct dfs_AddStdRootForced *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netdfs,
			NDR_DFS_ADDSTDROOTFORCED, mem_ctx, r);

	return status;
}

struct dcerpc_dfs_AddStdRootForced_state {
	struct dfs_AddStdRootForced orig;
	struct dfs_AddStdRootForced tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_dfs_AddStdRootForced_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_dfs_AddStdRootForced_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    const char *_servername /* [in] [charset(UTF16)] */,
						    const char *_rootshare /* [in] [charset(UTF16)] */,
						    const char *_comment /* [in] [charset(UTF16)] */,
						    const char *_store /* [in] [charset(UTF16)] */)
{
	struct tevent_req *req;
	struct dcerpc_dfs_AddStdRootForced_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_dfs_AddStdRootForced_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.servername = _servername;
	state->orig.in.rootshare = _rootshare;
	state->orig.in.comment = _comment;
	state->orig.in.store = _store;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_dfs_AddStdRootForced_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_dfs_AddStdRootForced_done, req);
	return req;
}

static void dcerpc_dfs_AddStdRootForced_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_dfs_AddStdRootForced_state *state = tevent_req_data(
		req, struct dcerpc_dfs_AddStdRootForced_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_dfs_AddStdRootForced_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_dfs_AddStdRootForced_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct dcerpc_dfs_AddStdRootForced_state *state = tevent_req_data(
		req, struct dcerpc_dfs_AddStdRootForced_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_dfs_AddStdRootForced(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     const char *_servername /* [in] [charset(UTF16)] */,
				     const char *_rootshare /* [in] [charset(UTF16)] */,
				     const char *_comment /* [in] [charset(UTF16)] */,
				     const char *_store /* [in] [charset(UTF16)] */,
				     WERROR *result)
{
	struct dfs_AddStdRootForced r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = _servername;
	r.in.rootshare = _rootshare;
	r.in.comment = _comment;
	r.in.store = _store;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_dfs_AddStdRootForced_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_dfs_GetDcAddress_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_dfs_GetDcAddress_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_dfs_GetDcAddress_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct dfs_GetDcAddress *r)
{
	struct tevent_req *req;
	struct dcerpc_dfs_GetDcAddress_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_dfs_GetDcAddress_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netdfs,
			NDR_DFS_GETDCADDRESS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_dfs_GetDcAddress_r_done, req);

	return req;
}

static void dcerpc_dfs_GetDcAddress_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_dfs_GetDcAddress_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_dfs_GetDcAddress_r_state *state =
		tevent_req_data(req,
		struct dcerpc_dfs_GetDcAddress_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_dfs_GetDcAddress_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct dfs_GetDcAddress *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netdfs,
			NDR_DFS_GETDCADDRESS, mem_ctx, r);

	return status;
}

struct dcerpc_dfs_GetDcAddress_state {
	struct dfs_GetDcAddress orig;
	struct dfs_GetDcAddress tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_dfs_GetDcAddress_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_dfs_GetDcAddress_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						const char *_servername /* [in] [charset(UTF16)] */,
						const char **_server_fullname /* [in,out] [ref,charset(UTF16)] */,
						uint8_t *_is_root /* [in,out] [ref] */,
						uint32_t *_ttl /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_dfs_GetDcAddress_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_dfs_GetDcAddress_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.servername = _servername;
	state->orig.in.server_fullname = _server_fullname;
	state->orig.in.is_root = _is_root;
	state->orig.in.ttl = _ttl;

	/* Out parameters */
	state->orig.out.server_fullname = _server_fullname;
	state->orig.out.is_root = _is_root;
	state->orig.out.ttl = _ttl;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_dfs_GetDcAddress_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_dfs_GetDcAddress_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_dfs_GetDcAddress_done, req);
	return req;
}

static void dcerpc_dfs_GetDcAddress_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_dfs_GetDcAddress_state *state = tevent_req_data(
		req, struct dcerpc_dfs_GetDcAddress_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_dfs_GetDcAddress_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.server_fullname = *state->tmp.out.server_fullname;
	*state->orig.out.is_root = *state->tmp.out.is_root;
	*state->orig.out.ttl = *state->tmp.out.ttl;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_dfs_GetDcAddress_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result)
{
	struct dcerpc_dfs_GetDcAddress_state *state = tevent_req_data(
		req, struct dcerpc_dfs_GetDcAddress_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_dfs_GetDcAddress(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 const char *_servername /* [in] [charset(UTF16)] */,
				 const char **_server_fullname /* [in,out] [ref,charset(UTF16)] */,
				 uint8_t *_is_root /* [in,out] [ref] */,
				 uint32_t *_ttl /* [in,out] [ref] */,
				 WERROR *result)
{
	struct dfs_GetDcAddress r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = _servername;
	r.in.server_fullname = _server_fullname;
	r.in.is_root = _is_root;
	r.in.ttl = _ttl;

	/* Out parameters */
	r.out.server_fullname = _server_fullname;
	r.out.is_root = _is_root;
	r.out.ttl = _ttl;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_dfs_GetDcAddress_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_server_fullname = *r.out.server_fullname;
	*_is_root = *r.out.is_root;
	*_ttl = *r.out.ttl;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_dfs_SetDcAddress_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_dfs_SetDcAddress_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_dfs_SetDcAddress_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct dfs_SetDcAddress *r)
{
	struct tevent_req *req;
	struct dcerpc_dfs_SetDcAddress_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_dfs_SetDcAddress_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netdfs,
			NDR_DFS_SETDCADDRESS, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_dfs_SetDcAddress_r_done, req);

	return req;
}

static void dcerpc_dfs_SetDcAddress_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_dfs_SetDcAddress_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_dfs_SetDcAddress_r_state *state =
		tevent_req_data(req,
		struct dcerpc_dfs_SetDcAddress_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_dfs_SetDcAddress_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct dfs_SetDcAddress *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netdfs,
			NDR_DFS_SETDCADDRESS, mem_ctx, r);

	return status;
}

struct dcerpc_dfs_SetDcAddress_state {
	struct dfs_SetDcAddress orig;
	struct dfs_SetDcAddress tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_dfs_SetDcAddress_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_dfs_SetDcAddress_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						const char *_servername /* [in] [charset(UTF16)] */,
						const char *_server_fullname /* [in] [charset(UTF16)] */,
						uint32_t _flags /* [in]  */,
						uint32_t _ttl /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_dfs_SetDcAddress_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_dfs_SetDcAddress_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.servername = _servername;
	state->orig.in.server_fullname = _server_fullname;
	state->orig.in.flags = _flags;
	state->orig.in.ttl = _ttl;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_dfs_SetDcAddress_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_dfs_SetDcAddress_done, req);
	return req;
}

static void dcerpc_dfs_SetDcAddress_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_dfs_SetDcAddress_state *state = tevent_req_data(
		req, struct dcerpc_dfs_SetDcAddress_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_dfs_SetDcAddress_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_dfs_SetDcAddress_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result)
{
	struct dcerpc_dfs_SetDcAddress_state *state = tevent_req_data(
		req, struct dcerpc_dfs_SetDcAddress_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_dfs_SetDcAddress(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 const char *_servername /* [in] [charset(UTF16)] */,
				 const char *_server_fullname /* [in] [charset(UTF16)] */,
				 uint32_t _flags /* [in]  */,
				 uint32_t _ttl /* [in]  */,
				 WERROR *result)
{
	struct dfs_SetDcAddress r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = _servername;
	r.in.server_fullname = _server_fullname;
	r.in.flags = _flags;
	r.in.ttl = _ttl;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_dfs_SetDcAddress_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_dfs_FlushFtTable_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_dfs_FlushFtTable_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_dfs_FlushFtTable_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct dfs_FlushFtTable *r)
{
	struct tevent_req *req;
	struct dcerpc_dfs_FlushFtTable_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_dfs_FlushFtTable_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netdfs,
			NDR_DFS_FLUSHFTTABLE, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_dfs_FlushFtTable_r_done, req);

	return req;
}

static void dcerpc_dfs_FlushFtTable_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_dfs_FlushFtTable_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_dfs_FlushFtTable_r_state *state =
		tevent_req_data(req,
		struct dcerpc_dfs_FlushFtTable_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_dfs_FlushFtTable_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct dfs_FlushFtTable *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netdfs,
			NDR_DFS_FLUSHFTTABLE, mem_ctx, r);

	return status;
}

struct dcerpc_dfs_FlushFtTable_state {
	struct dfs_FlushFtTable orig;
	struct dfs_FlushFtTable tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_dfs_FlushFtTable_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_dfs_FlushFtTable_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						const char *_servername /* [in] [charset(UTF16)] */,
						const char *_rootshare /* [in] [charset(UTF16)] */)
{
	struct tevent_req *req;
	struct dcerpc_dfs_FlushFtTable_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_dfs_FlushFtTable_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.servername = _servername;
	state->orig.in.rootshare = _rootshare;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_dfs_FlushFtTable_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_dfs_FlushFtTable_done, req);
	return req;
}

static void dcerpc_dfs_FlushFtTable_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_dfs_FlushFtTable_state *state = tevent_req_data(
		req, struct dcerpc_dfs_FlushFtTable_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_dfs_FlushFtTable_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_dfs_FlushFtTable_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result)
{
	struct dcerpc_dfs_FlushFtTable_state *state = tevent_req_data(
		req, struct dcerpc_dfs_FlushFtTable_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_dfs_FlushFtTable(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 const char *_servername /* [in] [charset(UTF16)] */,
				 const char *_rootshare /* [in] [charset(UTF16)] */,
				 WERROR *result)
{
	struct dfs_FlushFtTable r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = _servername;
	r.in.rootshare = _rootshare;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_dfs_FlushFtTable_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_dfs_EnumEx_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_dfs_EnumEx_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_dfs_EnumEx_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct dfs_EnumEx *r)
{
	struct tevent_req *req;
	struct dcerpc_dfs_EnumEx_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_dfs_EnumEx_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_netdfs,
			NDR_DFS_ENUMEX, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_dfs_EnumEx_r_done, req);

	return req;
}

static void dcerpc_dfs_EnumEx_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_dfs_EnumEx_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_dfs_EnumEx_r_state *state =
		tevent_req_data(req,
		struct dcerpc_dfs_EnumEx_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_dfs_EnumEx_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct dfs_EnumEx *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_netdfs,
			NDR_DFS_ENUMEX, mem_ctx, r);

	return status;
}

struct dcerpc_dfs_EnumEx_state {
	struct dfs_EnumEx orig;
	struct dfs_EnumEx tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_dfs_EnumEx_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_dfs_EnumEx_send(TALLOC_CTX *mem_ctx,
					  struct tevent_context *ev,
					  struct dcerpc_binding_handle *h,
					  const char *_dfs_name /* [in] [charset(UTF16)] */,
					  uint32_t _level /* [in]  */,
					  uint32_t _bufsize /* [in]  */,
					  struct dfs_EnumStruct *_info /* [in,out] [unique] */,
					  uint32_t *_total /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_dfs_EnumEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_dfs_EnumEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.dfs_name = _dfs_name;
	state->orig.in.level = _level;
	state->orig.in.bufsize = _bufsize;
	state->orig.in.info = _info;
	state->orig.in.total = _total;

	/* Out parameters */
	state->orig.out.info = _info;
	state->orig.out.total = _total;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_dfs_EnumEx_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_dfs_EnumEx_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_dfs_EnumEx_done, req);
	return req;
}

static void dcerpc_dfs_EnumEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_dfs_EnumEx_state *state = tevent_req_data(
		req, struct dcerpc_dfs_EnumEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_dfs_EnumEx_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.info && state->tmp.out.info) {
		*state->orig.out.info = *state->tmp.out.info;
	}
	if (state->orig.out.total && state->tmp.out.total) {
		*state->orig.out.total = *state->tmp.out.total;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_dfs_EnumEx_recv(struct tevent_req *req,
				TALLOC_CTX *mem_ctx,
				WERROR *result)
{
	struct dcerpc_dfs_EnumEx_state *state = tevent_req_data(
		req, struct dcerpc_dfs_EnumEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_dfs_EnumEx(struct dcerpc_binding_handle *h,
			   TALLOC_CTX *mem_ctx,
			   const char *_dfs_name /* [in] [charset(UTF16)] */,
			   uint32_t _level /* [in]  */,
			   uint32_t _bufsize /* [in]  */,
			   struct dfs_EnumStruct *_info /* [in,out] [unique] */,
			   uint32_t *_total /* [in,out] [unique] */,
			   WERROR *result)
{
	struct dfs_EnumEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.dfs_name = _dfs_name;
	r.in.level = _level;
	r.in.bufsize = _bufsize;
	r.in.info = _info;
	r.in.total = _total;

	/* Out parameters */
	r.out.info = _info;
	r.out.total = _total;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_dfs_EnumEx_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_info && r.out.info) {
		*_info = *r.out.info;
	}
	if (_total && r.out.total) {
		*_total = *r.out.total;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

