/* client functions auto-generated by pidl */

#include "includes.h"
#include <tevent.h>
#include "lib/util/tevent_ntstatus.h"
#include "autoconf/librpc/gen_ndr/ndr_srvsvc.h"
#include "autoconf/librpc/gen_ndr/ndr_srvsvc_c.h"

/* srvsvc - client functions generated by pidl */

struct dcerpc_srvsvc_NetCharDevEnum_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetCharDevEnum_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetCharDevEnum_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct srvsvc_NetCharDevEnum *r)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetCharDevEnum_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetCharDevEnum_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETCHARDEVENUM, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetCharDevEnum_r_done, req);

	return req;
}

static void dcerpc_srvsvc_NetCharDevEnum_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetCharDevEnum_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_srvsvc_NetCharDevEnum_r_state *state =
		tevent_req_data(req,
		struct dcerpc_srvsvc_NetCharDevEnum_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetCharDevEnum_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct srvsvc_NetCharDevEnum *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETCHARDEVENUM, mem_ctx, r);

	return status;
}

struct dcerpc_srvsvc_NetCharDevEnum_state {
	struct srvsvc_NetCharDevEnum orig;
	struct srvsvc_NetCharDevEnum tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetCharDevEnum_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetCharDevEnum_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     const char *_server_unc /* [in] [charset(UTF16),unique] */,
						     struct srvsvc_NetCharDevInfoCtr *_info_ctr /* [in,out] [ref] */,
						     uint32_t _max_buffer /* [in]  */,
						     uint32_t *_totalentries /* [out] [ref] */,
						     uint32_t *_resume_handle /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetCharDevEnum_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetCharDevEnum_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_unc = _server_unc;
	state->orig.in.info_ctr = _info_ctr;
	state->orig.in.max_buffer = _max_buffer;
	state->orig.in.resume_handle = _resume_handle;

	/* Out parameters */
	state->orig.out.info_ctr = _info_ctr;
	state->orig.out.totalentries = _totalentries;
	state->orig.out.resume_handle = _resume_handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_srvsvc_NetCharDevEnum_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_srvsvc_NetCharDevEnum_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetCharDevEnum_done, req);
	return req;
}

static void dcerpc_srvsvc_NetCharDevEnum_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_srvsvc_NetCharDevEnum_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetCharDevEnum_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_srvsvc_NetCharDevEnum_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info_ctr = *state->tmp.out.info_ctr;
	*state->orig.out.totalentries = *state->tmp.out.totalentries;
	if (state->orig.out.resume_handle && state->tmp.out.resume_handle) {
		*state->orig.out.resume_handle = *state->tmp.out.resume_handle;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetCharDevEnum_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_srvsvc_NetCharDevEnum_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetCharDevEnum_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetCharDevEnum(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      const char *_server_unc /* [in] [charset(UTF16),unique] */,
				      struct srvsvc_NetCharDevInfoCtr *_info_ctr /* [in,out] [ref] */,
				      uint32_t _max_buffer /* [in]  */,
				      uint32_t *_totalentries /* [out] [ref] */,
				      uint32_t *_resume_handle /* [in,out] [unique] */,
				      WERROR *result)
{
	struct srvsvc_NetCharDevEnum r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = _server_unc;
	r.in.info_ctr = _info_ctr;
	r.in.max_buffer = _max_buffer;
	r.in.resume_handle = _resume_handle;

	/* Out parameters */
	r.out.info_ctr = _info_ctr;
	r.out.totalentries = _totalentries;
	r.out.resume_handle = _resume_handle;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_srvsvc_NetCharDevEnum_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_info_ctr = *r.out.info_ctr;
	*_totalentries = *r.out.totalentries;
	if (_resume_handle && r.out.resume_handle) {
		*_resume_handle = *r.out.resume_handle;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_srvsvc_NetCharDevGetInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetCharDevGetInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetCharDevGetInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct srvsvc_NetCharDevGetInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetCharDevGetInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetCharDevGetInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETCHARDEVGETINFO, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetCharDevGetInfo_r_done, req);

	return req;
}

static void dcerpc_srvsvc_NetCharDevGetInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetCharDevGetInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_srvsvc_NetCharDevGetInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_srvsvc_NetCharDevGetInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetCharDevGetInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct srvsvc_NetCharDevGetInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETCHARDEVGETINFO, mem_ctx, r);

	return status;
}

struct dcerpc_srvsvc_NetCharDevGetInfo_state {
	struct srvsvc_NetCharDevGetInfo orig;
	struct srvsvc_NetCharDevGetInfo tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetCharDevGetInfo_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetCharDevGetInfo_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							const char *_server_unc /* [in] [unique,charset(UTF16)] */,
							const char *_device_name /* [in] [charset(UTF16)] */,
							uint32_t _level /* [in]  */,
							union srvsvc_NetCharDevInfo *_info /* [out] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetCharDevGetInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetCharDevGetInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_unc = _server_unc;
	state->orig.in.device_name = _device_name;
	state->orig.in.level = _level;

	/* Out parameters */
	state->orig.out.info = _info;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_srvsvc_NetCharDevGetInfo_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_srvsvc_NetCharDevGetInfo_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetCharDevGetInfo_done, req);
	return req;
}

static void dcerpc_srvsvc_NetCharDevGetInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_srvsvc_NetCharDevGetInfo_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetCharDevGetInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_srvsvc_NetCharDevGetInfo_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetCharDevGetInfo_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      WERROR *result)
{
	struct dcerpc_srvsvc_NetCharDevGetInfo_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetCharDevGetInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetCharDevGetInfo(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 const char *_server_unc /* [in] [unique,charset(UTF16)] */,
					 const char *_device_name /* [in] [charset(UTF16)] */,
					 uint32_t _level /* [in]  */,
					 union srvsvc_NetCharDevInfo *_info /* [out] [ref,switch_is(level)] */,
					 WERROR *result)
{
	struct srvsvc_NetCharDevGetInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = _server_unc;
	r.in.device_name = _device_name;
	r.in.level = _level;

	/* Out parameters */
	r.out.info = _info;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_srvsvc_NetCharDevGetInfo_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_info = *r.out.info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_srvsvc_NetCharDevControl_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetCharDevControl_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetCharDevControl_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct srvsvc_NetCharDevControl *r)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetCharDevControl_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetCharDevControl_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETCHARDEVCONTROL, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetCharDevControl_r_done, req);

	return req;
}

static void dcerpc_srvsvc_NetCharDevControl_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetCharDevControl_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_srvsvc_NetCharDevControl_r_state *state =
		tevent_req_data(req,
		struct dcerpc_srvsvc_NetCharDevControl_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetCharDevControl_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct srvsvc_NetCharDevControl *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETCHARDEVCONTROL, mem_ctx, r);

	return status;
}

struct dcerpc_srvsvc_NetCharDevControl_state {
	struct srvsvc_NetCharDevControl orig;
	struct srvsvc_NetCharDevControl tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetCharDevControl_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetCharDevControl_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							const char *_server_unc /* [in] [charset(UTF16),unique] */,
							const char *_device_name /* [in] [charset(UTF16)] */,
							uint32_t _opcode /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetCharDevControl_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetCharDevControl_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_unc = _server_unc;
	state->orig.in.device_name = _device_name;
	state->orig.in.opcode = _opcode;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_srvsvc_NetCharDevControl_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetCharDevControl_done, req);
	return req;
}

static void dcerpc_srvsvc_NetCharDevControl_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_srvsvc_NetCharDevControl_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetCharDevControl_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_srvsvc_NetCharDevControl_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetCharDevControl_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      WERROR *result)
{
	struct dcerpc_srvsvc_NetCharDevControl_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetCharDevControl_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetCharDevControl(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 const char *_server_unc /* [in] [charset(UTF16),unique] */,
					 const char *_device_name /* [in] [charset(UTF16)] */,
					 uint32_t _opcode /* [in]  */,
					 WERROR *result)
{
	struct srvsvc_NetCharDevControl r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = _server_unc;
	r.in.device_name = _device_name;
	r.in.opcode = _opcode;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_srvsvc_NetCharDevControl_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_srvsvc_NetCharDevQEnum_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetCharDevQEnum_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetCharDevQEnum_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct srvsvc_NetCharDevQEnum *r)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetCharDevQEnum_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetCharDevQEnum_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETCHARDEVQENUM, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetCharDevQEnum_r_done, req);

	return req;
}

static void dcerpc_srvsvc_NetCharDevQEnum_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetCharDevQEnum_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_srvsvc_NetCharDevQEnum_r_state *state =
		tevent_req_data(req,
		struct dcerpc_srvsvc_NetCharDevQEnum_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetCharDevQEnum_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct srvsvc_NetCharDevQEnum *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETCHARDEVQENUM, mem_ctx, r);

	return status;
}

struct dcerpc_srvsvc_NetCharDevQEnum_state {
	struct srvsvc_NetCharDevQEnum orig;
	struct srvsvc_NetCharDevQEnum tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetCharDevQEnum_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetCharDevQEnum_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      const char *_server_unc /* [in] [charset(UTF16),unique] */,
						      const char *_user /* [in] [unique,charset(UTF16)] */,
						      struct srvsvc_NetCharDevQInfoCtr *_info_ctr /* [in,out] [ref] */,
						      uint32_t _max_buffer /* [in]  */,
						      uint32_t *_totalentries /* [out] [ref] */,
						      uint32_t *_resume_handle /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetCharDevQEnum_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetCharDevQEnum_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_unc = _server_unc;
	state->orig.in.user = _user;
	state->orig.in.info_ctr = _info_ctr;
	state->orig.in.max_buffer = _max_buffer;
	state->orig.in.resume_handle = _resume_handle;

	/* Out parameters */
	state->orig.out.info_ctr = _info_ctr;
	state->orig.out.totalentries = _totalentries;
	state->orig.out.resume_handle = _resume_handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_srvsvc_NetCharDevQEnum_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_srvsvc_NetCharDevQEnum_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetCharDevQEnum_done, req);
	return req;
}

static void dcerpc_srvsvc_NetCharDevQEnum_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_srvsvc_NetCharDevQEnum_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetCharDevQEnum_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_srvsvc_NetCharDevQEnum_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info_ctr = *state->tmp.out.info_ctr;
	*state->orig.out.totalentries = *state->tmp.out.totalentries;
	if (state->orig.out.resume_handle && state->tmp.out.resume_handle) {
		*state->orig.out.resume_handle = *state->tmp.out.resume_handle;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetCharDevQEnum_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    WERROR *result)
{
	struct dcerpc_srvsvc_NetCharDevQEnum_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetCharDevQEnum_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetCharDevQEnum(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       const char *_server_unc /* [in] [charset(UTF16),unique] */,
				       const char *_user /* [in] [unique,charset(UTF16)] */,
				       struct srvsvc_NetCharDevQInfoCtr *_info_ctr /* [in,out] [ref] */,
				       uint32_t _max_buffer /* [in]  */,
				       uint32_t *_totalentries /* [out] [ref] */,
				       uint32_t *_resume_handle /* [in,out] [unique] */,
				       WERROR *result)
{
	struct srvsvc_NetCharDevQEnum r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = _server_unc;
	r.in.user = _user;
	r.in.info_ctr = _info_ctr;
	r.in.max_buffer = _max_buffer;
	r.in.resume_handle = _resume_handle;

	/* Out parameters */
	r.out.info_ctr = _info_ctr;
	r.out.totalentries = _totalentries;
	r.out.resume_handle = _resume_handle;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_srvsvc_NetCharDevQEnum_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_info_ctr = *r.out.info_ctr;
	*_totalentries = *r.out.totalentries;
	if (_resume_handle && r.out.resume_handle) {
		*_resume_handle = *r.out.resume_handle;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_srvsvc_NetCharDevQGetInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetCharDevQGetInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetCharDevQGetInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct srvsvc_NetCharDevQGetInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetCharDevQGetInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetCharDevQGetInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETCHARDEVQGETINFO, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetCharDevQGetInfo_r_done, req);

	return req;
}

static void dcerpc_srvsvc_NetCharDevQGetInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetCharDevQGetInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_srvsvc_NetCharDevQGetInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_srvsvc_NetCharDevQGetInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetCharDevQGetInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct srvsvc_NetCharDevQGetInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETCHARDEVQGETINFO, mem_ctx, r);

	return status;
}

struct dcerpc_srvsvc_NetCharDevQGetInfo_state {
	struct srvsvc_NetCharDevQGetInfo orig;
	struct srvsvc_NetCharDevQGetInfo tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetCharDevQGetInfo_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetCharDevQGetInfo_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h,
							 const char *_server_unc /* [in] [unique,charset(UTF16)] */,
							 const char *_queue_name /* [in] [charset(UTF16)] */,
							 const char *_user /* [in] [charset(UTF16)] */,
							 uint32_t _level /* [in]  */,
							 union srvsvc_NetCharDevQInfo *_info /* [out] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetCharDevQGetInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetCharDevQGetInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_unc = _server_unc;
	state->orig.in.queue_name = _queue_name;
	state->orig.in.user = _user;
	state->orig.in.level = _level;

	/* Out parameters */
	state->orig.out.info = _info;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_srvsvc_NetCharDevQGetInfo_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_srvsvc_NetCharDevQGetInfo_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetCharDevQGetInfo_done, req);
	return req;
}

static void dcerpc_srvsvc_NetCharDevQGetInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_srvsvc_NetCharDevQGetInfo_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetCharDevQGetInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_srvsvc_NetCharDevQGetInfo_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetCharDevQGetInfo_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result)
{
	struct dcerpc_srvsvc_NetCharDevQGetInfo_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetCharDevQGetInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetCharDevQGetInfo(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  const char *_server_unc /* [in] [unique,charset(UTF16)] */,
					  const char *_queue_name /* [in] [charset(UTF16)] */,
					  const char *_user /* [in] [charset(UTF16)] */,
					  uint32_t _level /* [in]  */,
					  union srvsvc_NetCharDevQInfo *_info /* [out] [ref,switch_is(level)] */,
					  WERROR *result)
{
	struct srvsvc_NetCharDevQGetInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = _server_unc;
	r.in.queue_name = _queue_name;
	r.in.user = _user;
	r.in.level = _level;

	/* Out parameters */
	r.out.info = _info;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_srvsvc_NetCharDevQGetInfo_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_info = *r.out.info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_srvsvc_NetCharDevQSetInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetCharDevQSetInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetCharDevQSetInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct srvsvc_NetCharDevQSetInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetCharDevQSetInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetCharDevQSetInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETCHARDEVQSETINFO, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetCharDevQSetInfo_r_done, req);

	return req;
}

static void dcerpc_srvsvc_NetCharDevQSetInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetCharDevQSetInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_srvsvc_NetCharDevQSetInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_srvsvc_NetCharDevQSetInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetCharDevQSetInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct srvsvc_NetCharDevQSetInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETCHARDEVQSETINFO, mem_ctx, r);

	return status;
}

struct dcerpc_srvsvc_NetCharDevQSetInfo_state {
	struct srvsvc_NetCharDevQSetInfo orig;
	struct srvsvc_NetCharDevQSetInfo tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetCharDevQSetInfo_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetCharDevQSetInfo_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h,
							 const char *_server_unc /* [in] [unique,charset(UTF16)] */,
							 const char *_queue_name /* [in] [charset(UTF16)] */,
							 uint32_t _level /* [in]  */,
							 union srvsvc_NetCharDevQInfo _info /* [in] [switch_is(level)] */,
							 uint32_t *_parm_error /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetCharDevQSetInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetCharDevQSetInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_unc = _server_unc;
	state->orig.in.queue_name = _queue_name;
	state->orig.in.level = _level;
	state->orig.in.info = _info;
	state->orig.in.parm_error = _parm_error;

	/* Out parameters */
	state->orig.out.parm_error = _parm_error;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_srvsvc_NetCharDevQSetInfo_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_srvsvc_NetCharDevQSetInfo_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetCharDevQSetInfo_done, req);
	return req;
}

static void dcerpc_srvsvc_NetCharDevQSetInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_srvsvc_NetCharDevQSetInfo_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetCharDevQSetInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_srvsvc_NetCharDevQSetInfo_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.parm_error && state->tmp.out.parm_error) {
		*state->orig.out.parm_error = *state->tmp.out.parm_error;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetCharDevQSetInfo_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result)
{
	struct dcerpc_srvsvc_NetCharDevQSetInfo_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetCharDevQSetInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetCharDevQSetInfo(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  const char *_server_unc /* [in] [unique,charset(UTF16)] */,
					  const char *_queue_name /* [in] [charset(UTF16)] */,
					  uint32_t _level /* [in]  */,
					  union srvsvc_NetCharDevQInfo _info /* [in] [switch_is(level)] */,
					  uint32_t *_parm_error /* [in,out] [unique] */,
					  WERROR *result)
{
	struct srvsvc_NetCharDevQSetInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = _server_unc;
	r.in.queue_name = _queue_name;
	r.in.level = _level;
	r.in.info = _info;
	r.in.parm_error = _parm_error;

	/* Out parameters */
	r.out.parm_error = _parm_error;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_srvsvc_NetCharDevQSetInfo_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_parm_error && r.out.parm_error) {
		*_parm_error = *r.out.parm_error;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_srvsvc_NetCharDevQPurge_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetCharDevQPurge_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetCharDevQPurge_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct srvsvc_NetCharDevQPurge *r)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetCharDevQPurge_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetCharDevQPurge_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETCHARDEVQPURGE, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetCharDevQPurge_r_done, req);

	return req;
}

static void dcerpc_srvsvc_NetCharDevQPurge_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetCharDevQPurge_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_srvsvc_NetCharDevQPurge_r_state *state =
		tevent_req_data(req,
		struct dcerpc_srvsvc_NetCharDevQPurge_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetCharDevQPurge_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct srvsvc_NetCharDevQPurge *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETCHARDEVQPURGE, mem_ctx, r);

	return status;
}

struct dcerpc_srvsvc_NetCharDevQPurge_state {
	struct srvsvc_NetCharDevQPurge orig;
	struct srvsvc_NetCharDevQPurge tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetCharDevQPurge_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetCharDevQPurge_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       const char *_server_unc /* [in] [unique,charset(UTF16)] */,
						       const char *_queue_name /* [in] [charset(UTF16)] */)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetCharDevQPurge_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetCharDevQPurge_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_unc = _server_unc;
	state->orig.in.queue_name = _queue_name;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_srvsvc_NetCharDevQPurge_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetCharDevQPurge_done, req);
	return req;
}

static void dcerpc_srvsvc_NetCharDevQPurge_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_srvsvc_NetCharDevQPurge_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetCharDevQPurge_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_srvsvc_NetCharDevQPurge_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetCharDevQPurge_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     WERROR *result)
{
	struct dcerpc_srvsvc_NetCharDevQPurge_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetCharDevQPurge_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetCharDevQPurge(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					const char *_server_unc /* [in] [unique,charset(UTF16)] */,
					const char *_queue_name /* [in] [charset(UTF16)] */,
					WERROR *result)
{
	struct srvsvc_NetCharDevQPurge r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = _server_unc;
	r.in.queue_name = _queue_name;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_srvsvc_NetCharDevQPurge_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_srvsvc_NetCharDevQPurgeSelf_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetCharDevQPurgeSelf_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetCharDevQPurgeSelf_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct srvsvc_NetCharDevQPurgeSelf *r)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetCharDevQPurgeSelf_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetCharDevQPurgeSelf_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETCHARDEVQPURGESELF, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetCharDevQPurgeSelf_r_done, req);

	return req;
}

static void dcerpc_srvsvc_NetCharDevQPurgeSelf_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetCharDevQPurgeSelf_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_srvsvc_NetCharDevQPurgeSelf_r_state *state =
		tevent_req_data(req,
		struct dcerpc_srvsvc_NetCharDevQPurgeSelf_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetCharDevQPurgeSelf_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct srvsvc_NetCharDevQPurgeSelf *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETCHARDEVQPURGESELF, mem_ctx, r);

	return status;
}

struct dcerpc_srvsvc_NetCharDevQPurgeSelf_state {
	struct srvsvc_NetCharDevQPurgeSelf orig;
	struct srvsvc_NetCharDevQPurgeSelf tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetCharDevQPurgeSelf_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetCharDevQPurgeSelf_send(TALLOC_CTX *mem_ctx,
							   struct tevent_context *ev,
							   struct dcerpc_binding_handle *h,
							   const char *_server_unc /* [in] [charset(UTF16),unique] */,
							   const char *_queue_name /* [in] [charset(UTF16)] */,
							   const char *_computer_name /* [in] [charset(UTF16)] */)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetCharDevQPurgeSelf_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetCharDevQPurgeSelf_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_unc = _server_unc;
	state->orig.in.queue_name = _queue_name;
	state->orig.in.computer_name = _computer_name;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_srvsvc_NetCharDevQPurgeSelf_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetCharDevQPurgeSelf_done, req);
	return req;
}

static void dcerpc_srvsvc_NetCharDevQPurgeSelf_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_srvsvc_NetCharDevQPurgeSelf_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetCharDevQPurgeSelf_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_srvsvc_NetCharDevQPurgeSelf_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetCharDevQPurgeSelf_recv(struct tevent_req *req,
						 TALLOC_CTX *mem_ctx,
						 WERROR *result)
{
	struct dcerpc_srvsvc_NetCharDevQPurgeSelf_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetCharDevQPurgeSelf_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetCharDevQPurgeSelf(struct dcerpc_binding_handle *h,
					    TALLOC_CTX *mem_ctx,
					    const char *_server_unc /* [in] [charset(UTF16),unique] */,
					    const char *_queue_name /* [in] [charset(UTF16)] */,
					    const char *_computer_name /* [in] [charset(UTF16)] */,
					    WERROR *result)
{
	struct srvsvc_NetCharDevQPurgeSelf r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = _server_unc;
	r.in.queue_name = _queue_name;
	r.in.computer_name = _computer_name;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_srvsvc_NetCharDevQPurgeSelf_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_srvsvc_NetConnEnum_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetConnEnum_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetConnEnum_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct srvsvc_NetConnEnum *r)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetConnEnum_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetConnEnum_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETCONNENUM, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetConnEnum_r_done, req);

	return req;
}

static void dcerpc_srvsvc_NetConnEnum_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetConnEnum_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_srvsvc_NetConnEnum_r_state *state =
		tevent_req_data(req,
		struct dcerpc_srvsvc_NetConnEnum_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetConnEnum_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct srvsvc_NetConnEnum *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETCONNENUM, mem_ctx, r);

	return status;
}

struct dcerpc_srvsvc_NetConnEnum_state {
	struct srvsvc_NetConnEnum orig;
	struct srvsvc_NetConnEnum tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetConnEnum_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetConnEnum_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct dcerpc_binding_handle *h,
						  const char *_server_unc /* [in] [unique,charset(UTF16)] */,
						  const char *_path /* [in] [charset(UTF16),unique] */,
						  struct srvsvc_NetConnInfoCtr *_info_ctr /* [in,out] [ref] */,
						  uint32_t _max_buffer /* [in]  */,
						  uint32_t *_totalentries /* [out] [ref] */,
						  uint32_t *_resume_handle /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetConnEnum_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetConnEnum_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_unc = _server_unc;
	state->orig.in.path = _path;
	state->orig.in.info_ctr = _info_ctr;
	state->orig.in.max_buffer = _max_buffer;
	state->orig.in.resume_handle = _resume_handle;

	/* Out parameters */
	state->orig.out.info_ctr = _info_ctr;
	state->orig.out.totalentries = _totalentries;
	state->orig.out.resume_handle = _resume_handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_srvsvc_NetConnEnum_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_srvsvc_NetConnEnum_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetConnEnum_done, req);
	return req;
}

static void dcerpc_srvsvc_NetConnEnum_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_srvsvc_NetConnEnum_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetConnEnum_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_srvsvc_NetConnEnum_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info_ctr = *state->tmp.out.info_ctr;
	*state->orig.out.totalentries = *state->tmp.out.totalentries;
	if (state->orig.out.resume_handle && state->tmp.out.resume_handle) {
		*state->orig.out.resume_handle = *state->tmp.out.resume_handle;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetConnEnum_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					WERROR *result)
{
	struct dcerpc_srvsvc_NetConnEnum_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetConnEnum_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetConnEnum(struct dcerpc_binding_handle *h,
				   TALLOC_CTX *mem_ctx,
				   const char *_server_unc /* [in] [unique,charset(UTF16)] */,
				   const char *_path /* [in] [charset(UTF16),unique] */,
				   struct srvsvc_NetConnInfoCtr *_info_ctr /* [in,out] [ref] */,
				   uint32_t _max_buffer /* [in]  */,
				   uint32_t *_totalentries /* [out] [ref] */,
				   uint32_t *_resume_handle /* [in,out] [unique] */,
				   WERROR *result)
{
	struct srvsvc_NetConnEnum r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = _server_unc;
	r.in.path = _path;
	r.in.info_ctr = _info_ctr;
	r.in.max_buffer = _max_buffer;
	r.in.resume_handle = _resume_handle;

	/* Out parameters */
	r.out.info_ctr = _info_ctr;
	r.out.totalentries = _totalentries;
	r.out.resume_handle = _resume_handle;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_srvsvc_NetConnEnum_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_info_ctr = *r.out.info_ctr;
	*_totalentries = *r.out.totalentries;
	if (_resume_handle && r.out.resume_handle) {
		*_resume_handle = *r.out.resume_handle;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_srvsvc_NetFileEnum_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetFileEnum_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetFileEnum_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct srvsvc_NetFileEnum *r)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetFileEnum_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetFileEnum_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETFILEENUM, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetFileEnum_r_done, req);

	return req;
}

static void dcerpc_srvsvc_NetFileEnum_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetFileEnum_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_srvsvc_NetFileEnum_r_state *state =
		tevent_req_data(req,
		struct dcerpc_srvsvc_NetFileEnum_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetFileEnum_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct srvsvc_NetFileEnum *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETFILEENUM, mem_ctx, r);

	return status;
}

struct dcerpc_srvsvc_NetFileEnum_state {
	struct srvsvc_NetFileEnum orig;
	struct srvsvc_NetFileEnum tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetFileEnum_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetFileEnum_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct dcerpc_binding_handle *h,
						  const char *_server_unc /* [in] [unique,charset(UTF16)] */,
						  const char *_path /* [in] [unique,charset(UTF16)] */,
						  const char *_user /* [in] [charset(UTF16),unique] */,
						  struct srvsvc_NetFileInfoCtr *_info_ctr /* [in,out] [ref] */,
						  uint32_t _max_buffer /* [in]  */,
						  uint32_t *_totalentries /* [out] [ref] */,
						  uint32_t *_resume_handle /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetFileEnum_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetFileEnum_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_unc = _server_unc;
	state->orig.in.path = _path;
	state->orig.in.user = _user;
	state->orig.in.info_ctr = _info_ctr;
	state->orig.in.max_buffer = _max_buffer;
	state->orig.in.resume_handle = _resume_handle;

	/* Out parameters */
	state->orig.out.info_ctr = _info_ctr;
	state->orig.out.totalentries = _totalentries;
	state->orig.out.resume_handle = _resume_handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_srvsvc_NetFileEnum_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_srvsvc_NetFileEnum_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetFileEnum_done, req);
	return req;
}

static void dcerpc_srvsvc_NetFileEnum_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_srvsvc_NetFileEnum_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetFileEnum_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_srvsvc_NetFileEnum_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info_ctr = *state->tmp.out.info_ctr;
	*state->orig.out.totalentries = *state->tmp.out.totalentries;
	if (state->orig.out.resume_handle && state->tmp.out.resume_handle) {
		*state->orig.out.resume_handle = *state->tmp.out.resume_handle;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetFileEnum_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					WERROR *result)
{
	struct dcerpc_srvsvc_NetFileEnum_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetFileEnum_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetFileEnum(struct dcerpc_binding_handle *h,
				   TALLOC_CTX *mem_ctx,
				   const char *_server_unc /* [in] [unique,charset(UTF16)] */,
				   const char *_path /* [in] [unique,charset(UTF16)] */,
				   const char *_user /* [in] [charset(UTF16),unique] */,
				   struct srvsvc_NetFileInfoCtr *_info_ctr /* [in,out] [ref] */,
				   uint32_t _max_buffer /* [in]  */,
				   uint32_t *_totalentries /* [out] [ref] */,
				   uint32_t *_resume_handle /* [in,out] [unique] */,
				   WERROR *result)
{
	struct srvsvc_NetFileEnum r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = _server_unc;
	r.in.path = _path;
	r.in.user = _user;
	r.in.info_ctr = _info_ctr;
	r.in.max_buffer = _max_buffer;
	r.in.resume_handle = _resume_handle;

	/* Out parameters */
	r.out.info_ctr = _info_ctr;
	r.out.totalentries = _totalentries;
	r.out.resume_handle = _resume_handle;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_srvsvc_NetFileEnum_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_info_ctr = *r.out.info_ctr;
	*_totalentries = *r.out.totalentries;
	if (_resume_handle && r.out.resume_handle) {
		*_resume_handle = *r.out.resume_handle;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_srvsvc_NetFileGetInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetFileGetInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetFileGetInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct srvsvc_NetFileGetInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetFileGetInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetFileGetInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETFILEGETINFO, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetFileGetInfo_r_done, req);

	return req;
}

static void dcerpc_srvsvc_NetFileGetInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetFileGetInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_srvsvc_NetFileGetInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_srvsvc_NetFileGetInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetFileGetInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct srvsvc_NetFileGetInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETFILEGETINFO, mem_ctx, r);

	return status;
}

struct dcerpc_srvsvc_NetFileGetInfo_state {
	struct srvsvc_NetFileGetInfo orig;
	struct srvsvc_NetFileGetInfo tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetFileGetInfo_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetFileGetInfo_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     const char *_server_unc /* [in] [charset(UTF16),unique] */,
						     uint32_t _fid /* [in]  */,
						     uint32_t _level /* [in]  */,
						     union srvsvc_NetFileInfo *_info /* [out] [switch_is(level),ref] */)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetFileGetInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetFileGetInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_unc = _server_unc;
	state->orig.in.fid = _fid;
	state->orig.in.level = _level;

	/* Out parameters */
	state->orig.out.info = _info;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_srvsvc_NetFileGetInfo_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_srvsvc_NetFileGetInfo_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetFileGetInfo_done, req);
	return req;
}

static void dcerpc_srvsvc_NetFileGetInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_srvsvc_NetFileGetInfo_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetFileGetInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_srvsvc_NetFileGetInfo_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetFileGetInfo_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_srvsvc_NetFileGetInfo_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetFileGetInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetFileGetInfo(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      const char *_server_unc /* [in] [charset(UTF16),unique] */,
				      uint32_t _fid /* [in]  */,
				      uint32_t _level /* [in]  */,
				      union srvsvc_NetFileInfo *_info /* [out] [switch_is(level),ref] */,
				      WERROR *result)
{
	struct srvsvc_NetFileGetInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = _server_unc;
	r.in.fid = _fid;
	r.in.level = _level;

	/* Out parameters */
	r.out.info = _info;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_srvsvc_NetFileGetInfo_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_info = *r.out.info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_srvsvc_NetFileClose_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetFileClose_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetFileClose_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct srvsvc_NetFileClose *r)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetFileClose_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetFileClose_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETFILECLOSE, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetFileClose_r_done, req);

	return req;
}

static void dcerpc_srvsvc_NetFileClose_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetFileClose_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_srvsvc_NetFileClose_r_state *state =
		tevent_req_data(req,
		struct dcerpc_srvsvc_NetFileClose_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetFileClose_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct srvsvc_NetFileClose *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETFILECLOSE, mem_ctx, r);

	return status;
}

struct dcerpc_srvsvc_NetFileClose_state {
	struct srvsvc_NetFileClose orig;
	struct srvsvc_NetFileClose tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetFileClose_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetFileClose_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct dcerpc_binding_handle *h,
						   const char *_server_unc /* [in] [unique,charset(UTF16)] */,
						   uint32_t _fid /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetFileClose_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetFileClose_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_unc = _server_unc;
	state->orig.in.fid = _fid;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_srvsvc_NetFileClose_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetFileClose_done, req);
	return req;
}

static void dcerpc_srvsvc_NetFileClose_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_srvsvc_NetFileClose_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetFileClose_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_srvsvc_NetFileClose_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetFileClose_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 WERROR *result)
{
	struct dcerpc_srvsvc_NetFileClose_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetFileClose_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetFileClose(struct dcerpc_binding_handle *h,
				    TALLOC_CTX *mem_ctx,
				    const char *_server_unc /* [in] [unique,charset(UTF16)] */,
				    uint32_t _fid /* [in]  */,
				    WERROR *result)
{
	struct srvsvc_NetFileClose r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = _server_unc;
	r.in.fid = _fid;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_srvsvc_NetFileClose_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_srvsvc_NetSessEnum_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetSessEnum_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetSessEnum_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct srvsvc_NetSessEnum *r)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetSessEnum_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetSessEnum_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETSESSENUM, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetSessEnum_r_done, req);

	return req;
}

static void dcerpc_srvsvc_NetSessEnum_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetSessEnum_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_srvsvc_NetSessEnum_r_state *state =
		tevent_req_data(req,
		struct dcerpc_srvsvc_NetSessEnum_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetSessEnum_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct srvsvc_NetSessEnum *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETSESSENUM, mem_ctx, r);

	return status;
}

struct dcerpc_srvsvc_NetSessEnum_state {
	struct srvsvc_NetSessEnum orig;
	struct srvsvc_NetSessEnum tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetSessEnum_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetSessEnum_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct dcerpc_binding_handle *h,
						  const char *_server_unc /* [in] [charset(UTF16),unique] */,
						  const char *_client /* [in] [charset(UTF16),unique] */,
						  const char *_user /* [in] [charset(UTF16),unique] */,
						  struct srvsvc_NetSessInfoCtr *_info_ctr /* [in,out] [ref] */,
						  uint32_t _max_buffer /* [in]  */,
						  uint32_t *_totalentries /* [out] [ref] */,
						  uint32_t *_resume_handle /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetSessEnum_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetSessEnum_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_unc = _server_unc;
	state->orig.in.client = _client;
	state->orig.in.user = _user;
	state->orig.in.info_ctr = _info_ctr;
	state->orig.in.max_buffer = _max_buffer;
	state->orig.in.resume_handle = _resume_handle;

	/* Out parameters */
	state->orig.out.info_ctr = _info_ctr;
	state->orig.out.totalentries = _totalentries;
	state->orig.out.resume_handle = _resume_handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_srvsvc_NetSessEnum_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_srvsvc_NetSessEnum_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetSessEnum_done, req);
	return req;
}

static void dcerpc_srvsvc_NetSessEnum_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_srvsvc_NetSessEnum_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetSessEnum_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_srvsvc_NetSessEnum_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info_ctr = *state->tmp.out.info_ctr;
	*state->orig.out.totalentries = *state->tmp.out.totalentries;
	if (state->orig.out.resume_handle && state->tmp.out.resume_handle) {
		*state->orig.out.resume_handle = *state->tmp.out.resume_handle;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetSessEnum_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					WERROR *result)
{
	struct dcerpc_srvsvc_NetSessEnum_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetSessEnum_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetSessEnum(struct dcerpc_binding_handle *h,
				   TALLOC_CTX *mem_ctx,
				   const char *_server_unc /* [in] [charset(UTF16),unique] */,
				   const char *_client /* [in] [charset(UTF16),unique] */,
				   const char *_user /* [in] [charset(UTF16),unique] */,
				   struct srvsvc_NetSessInfoCtr *_info_ctr /* [in,out] [ref] */,
				   uint32_t _max_buffer /* [in]  */,
				   uint32_t *_totalentries /* [out] [ref] */,
				   uint32_t *_resume_handle /* [in,out] [unique] */,
				   WERROR *result)
{
	struct srvsvc_NetSessEnum r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = _server_unc;
	r.in.client = _client;
	r.in.user = _user;
	r.in.info_ctr = _info_ctr;
	r.in.max_buffer = _max_buffer;
	r.in.resume_handle = _resume_handle;

	/* Out parameters */
	r.out.info_ctr = _info_ctr;
	r.out.totalentries = _totalentries;
	r.out.resume_handle = _resume_handle;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_srvsvc_NetSessEnum_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_info_ctr = *r.out.info_ctr;
	*_totalentries = *r.out.totalentries;
	if (_resume_handle && r.out.resume_handle) {
		*_resume_handle = *r.out.resume_handle;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_srvsvc_NetSessDel_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetSessDel_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetSessDel_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct srvsvc_NetSessDel *r)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetSessDel_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetSessDel_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETSESSDEL, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetSessDel_r_done, req);

	return req;
}

static void dcerpc_srvsvc_NetSessDel_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetSessDel_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_srvsvc_NetSessDel_r_state *state =
		tevent_req_data(req,
		struct dcerpc_srvsvc_NetSessDel_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetSessDel_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct srvsvc_NetSessDel *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETSESSDEL, mem_ctx, r);

	return status;
}

struct dcerpc_srvsvc_NetSessDel_state {
	struct srvsvc_NetSessDel orig;
	struct srvsvc_NetSessDel tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetSessDel_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetSessDel_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 const char *_server_unc /* [in] [unique,charset(UTF16)] */,
						 const char *_client /* [in] [charset(UTF16),unique] */,
						 const char *_user /* [in] [unique,charset(UTF16)] */)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetSessDel_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetSessDel_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_unc = _server_unc;
	state->orig.in.client = _client;
	state->orig.in.user = _user;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_srvsvc_NetSessDel_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetSessDel_done, req);
	return req;
}

static void dcerpc_srvsvc_NetSessDel_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_srvsvc_NetSessDel_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetSessDel_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_srvsvc_NetSessDel_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetSessDel_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       WERROR *result)
{
	struct dcerpc_srvsvc_NetSessDel_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetSessDel_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetSessDel(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  const char *_server_unc /* [in] [unique,charset(UTF16)] */,
				  const char *_client /* [in] [charset(UTF16),unique] */,
				  const char *_user /* [in] [unique,charset(UTF16)] */,
				  WERROR *result)
{
	struct srvsvc_NetSessDel r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = _server_unc;
	r.in.client = _client;
	r.in.user = _user;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_srvsvc_NetSessDel_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_srvsvc_NetShareAdd_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetShareAdd_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetShareAdd_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct srvsvc_NetShareAdd *r)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetShareAdd_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetShareAdd_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETSHAREADD, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetShareAdd_r_done, req);

	return req;
}

static void dcerpc_srvsvc_NetShareAdd_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetShareAdd_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_srvsvc_NetShareAdd_r_state *state =
		tevent_req_data(req,
		struct dcerpc_srvsvc_NetShareAdd_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetShareAdd_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct srvsvc_NetShareAdd *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETSHAREADD, mem_ctx, r);

	return status;
}

struct dcerpc_srvsvc_NetShareAdd_state {
	struct srvsvc_NetShareAdd orig;
	struct srvsvc_NetShareAdd tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetShareAdd_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetShareAdd_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct dcerpc_binding_handle *h,
						  const char *_server_unc /* [in] [charset(UTF16),unique] */,
						  uint32_t _level /* [in]  */,
						  union srvsvc_NetShareInfo *_info /* [in] [switch_is(level),ref] */,
						  uint32_t *_parm_error /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetShareAdd_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetShareAdd_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_unc = _server_unc;
	state->orig.in.level = _level;
	state->orig.in.info = _info;
	state->orig.in.parm_error = _parm_error;

	/* Out parameters */
	state->orig.out.parm_error = _parm_error;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_srvsvc_NetShareAdd_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_srvsvc_NetShareAdd_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetShareAdd_done, req);
	return req;
}

static void dcerpc_srvsvc_NetShareAdd_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_srvsvc_NetShareAdd_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetShareAdd_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_srvsvc_NetShareAdd_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.parm_error && state->tmp.out.parm_error) {
		*state->orig.out.parm_error = *state->tmp.out.parm_error;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetShareAdd_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					WERROR *result)
{
	struct dcerpc_srvsvc_NetShareAdd_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetShareAdd_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetShareAdd(struct dcerpc_binding_handle *h,
				   TALLOC_CTX *mem_ctx,
				   const char *_server_unc /* [in] [charset(UTF16),unique] */,
				   uint32_t _level /* [in]  */,
				   union srvsvc_NetShareInfo *_info /* [in] [switch_is(level),ref] */,
				   uint32_t *_parm_error /* [in,out] [unique] */,
				   WERROR *result)
{
	struct srvsvc_NetShareAdd r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = _server_unc;
	r.in.level = _level;
	r.in.info = _info;
	r.in.parm_error = _parm_error;

	/* Out parameters */
	r.out.parm_error = _parm_error;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_srvsvc_NetShareAdd_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_parm_error && r.out.parm_error) {
		*_parm_error = *r.out.parm_error;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_srvsvc_NetShareEnumAll_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetShareEnumAll_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetShareEnumAll_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct srvsvc_NetShareEnumAll *r)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetShareEnumAll_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetShareEnumAll_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETSHAREENUMALL, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetShareEnumAll_r_done, req);

	return req;
}

static void dcerpc_srvsvc_NetShareEnumAll_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetShareEnumAll_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_srvsvc_NetShareEnumAll_r_state *state =
		tevent_req_data(req,
		struct dcerpc_srvsvc_NetShareEnumAll_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetShareEnumAll_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct srvsvc_NetShareEnumAll *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETSHAREENUMALL, mem_ctx, r);

	return status;
}

struct dcerpc_srvsvc_NetShareEnumAll_state {
	struct srvsvc_NetShareEnumAll orig;
	struct srvsvc_NetShareEnumAll tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetShareEnumAll_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetShareEnumAll_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      const char *_server_unc /* [in] [charset(UTF16),unique] */,
						      struct srvsvc_NetShareInfoCtr *_info_ctr /* [in,out] [ref] */,
						      uint32_t _max_buffer /* [in]  */,
						      uint32_t *_totalentries /* [out] [ref] */,
						      uint32_t *_resume_handle /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetShareEnumAll_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetShareEnumAll_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_unc = _server_unc;
	state->orig.in.info_ctr = _info_ctr;
	state->orig.in.max_buffer = _max_buffer;
	state->orig.in.resume_handle = _resume_handle;

	/* Out parameters */
	state->orig.out.info_ctr = _info_ctr;
	state->orig.out.totalentries = _totalentries;
	state->orig.out.resume_handle = _resume_handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_srvsvc_NetShareEnumAll_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_srvsvc_NetShareEnumAll_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetShareEnumAll_done, req);
	return req;
}

static void dcerpc_srvsvc_NetShareEnumAll_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_srvsvc_NetShareEnumAll_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetShareEnumAll_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_srvsvc_NetShareEnumAll_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info_ctr = *state->tmp.out.info_ctr;
	*state->orig.out.totalentries = *state->tmp.out.totalentries;
	if (state->orig.out.resume_handle && state->tmp.out.resume_handle) {
		*state->orig.out.resume_handle = *state->tmp.out.resume_handle;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetShareEnumAll_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    WERROR *result)
{
	struct dcerpc_srvsvc_NetShareEnumAll_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetShareEnumAll_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetShareEnumAll(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       const char *_server_unc /* [in] [charset(UTF16),unique] */,
				       struct srvsvc_NetShareInfoCtr *_info_ctr /* [in,out] [ref] */,
				       uint32_t _max_buffer /* [in]  */,
				       uint32_t *_totalentries /* [out] [ref] */,
				       uint32_t *_resume_handle /* [in,out] [unique] */,
				       WERROR *result)
{
	struct srvsvc_NetShareEnumAll r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = _server_unc;
	r.in.info_ctr = _info_ctr;
	r.in.max_buffer = _max_buffer;
	r.in.resume_handle = _resume_handle;

	/* Out parameters */
	r.out.info_ctr = _info_ctr;
	r.out.totalentries = _totalentries;
	r.out.resume_handle = _resume_handle;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_srvsvc_NetShareEnumAll_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_info_ctr = *r.out.info_ctr;
	*_totalentries = *r.out.totalentries;
	if (_resume_handle && r.out.resume_handle) {
		*_resume_handle = *r.out.resume_handle;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_srvsvc_NetShareGetInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetShareGetInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetShareGetInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct srvsvc_NetShareGetInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetShareGetInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetShareGetInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETSHAREGETINFO, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetShareGetInfo_r_done, req);

	return req;
}

static void dcerpc_srvsvc_NetShareGetInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetShareGetInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_srvsvc_NetShareGetInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_srvsvc_NetShareGetInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetShareGetInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct srvsvc_NetShareGetInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETSHAREGETINFO, mem_ctx, r);

	return status;
}

struct dcerpc_srvsvc_NetShareGetInfo_state {
	struct srvsvc_NetShareGetInfo orig;
	struct srvsvc_NetShareGetInfo tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetShareGetInfo_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetShareGetInfo_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      const char *_server_unc /* [in] [charset(UTF16),unique] */,
						      const char *_share_name /* [in] [charset(UTF16)] */,
						      uint32_t _level /* [in]  */,
						      union srvsvc_NetShareInfo *_info /* [out] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetShareGetInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetShareGetInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_unc = _server_unc;
	state->orig.in.share_name = _share_name;
	state->orig.in.level = _level;

	/* Out parameters */
	state->orig.out.info = _info;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_srvsvc_NetShareGetInfo_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_srvsvc_NetShareGetInfo_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetShareGetInfo_done, req);
	return req;
}

static void dcerpc_srvsvc_NetShareGetInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_srvsvc_NetShareGetInfo_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetShareGetInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_srvsvc_NetShareGetInfo_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetShareGetInfo_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    WERROR *result)
{
	struct dcerpc_srvsvc_NetShareGetInfo_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetShareGetInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetShareGetInfo(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       const char *_server_unc /* [in] [charset(UTF16),unique] */,
				       const char *_share_name /* [in] [charset(UTF16)] */,
				       uint32_t _level /* [in]  */,
				       union srvsvc_NetShareInfo *_info /* [out] [ref,switch_is(level)] */,
				       WERROR *result)
{
	struct srvsvc_NetShareGetInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = _server_unc;
	r.in.share_name = _share_name;
	r.in.level = _level;

	/* Out parameters */
	r.out.info = _info;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_srvsvc_NetShareGetInfo_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_info = *r.out.info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_srvsvc_NetShareSetInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetShareSetInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetShareSetInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct srvsvc_NetShareSetInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetShareSetInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetShareSetInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETSHARESETINFO, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetShareSetInfo_r_done, req);

	return req;
}

static void dcerpc_srvsvc_NetShareSetInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetShareSetInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_srvsvc_NetShareSetInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_srvsvc_NetShareSetInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetShareSetInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct srvsvc_NetShareSetInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETSHARESETINFO, mem_ctx, r);

	return status;
}

struct dcerpc_srvsvc_NetShareSetInfo_state {
	struct srvsvc_NetShareSetInfo orig;
	struct srvsvc_NetShareSetInfo tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetShareSetInfo_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetShareSetInfo_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      const char *_server_unc /* [in] [charset(UTF16),unique] */,
						      const char *_share_name /* [in] [charset(UTF16)] */,
						      uint32_t _level /* [in]  */,
						      union srvsvc_NetShareInfo *_info /* [in] [ref,switch_is(level)] */,
						      uint32_t *_parm_error /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetShareSetInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetShareSetInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_unc = _server_unc;
	state->orig.in.share_name = _share_name;
	state->orig.in.level = _level;
	state->orig.in.info = _info;
	state->orig.in.parm_error = _parm_error;

	/* Out parameters */
	state->orig.out.parm_error = _parm_error;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_srvsvc_NetShareSetInfo_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_srvsvc_NetShareSetInfo_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetShareSetInfo_done, req);
	return req;
}

static void dcerpc_srvsvc_NetShareSetInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_srvsvc_NetShareSetInfo_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetShareSetInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_srvsvc_NetShareSetInfo_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.parm_error && state->tmp.out.parm_error) {
		*state->orig.out.parm_error = *state->tmp.out.parm_error;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetShareSetInfo_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    WERROR *result)
{
	struct dcerpc_srvsvc_NetShareSetInfo_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetShareSetInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetShareSetInfo(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       const char *_server_unc /* [in] [charset(UTF16),unique] */,
				       const char *_share_name /* [in] [charset(UTF16)] */,
				       uint32_t _level /* [in]  */,
				       union srvsvc_NetShareInfo *_info /* [in] [ref,switch_is(level)] */,
				       uint32_t *_parm_error /* [in,out] [unique] */,
				       WERROR *result)
{
	struct srvsvc_NetShareSetInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = _server_unc;
	r.in.share_name = _share_name;
	r.in.level = _level;
	r.in.info = _info;
	r.in.parm_error = _parm_error;

	/* Out parameters */
	r.out.parm_error = _parm_error;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_srvsvc_NetShareSetInfo_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_parm_error && r.out.parm_error) {
		*_parm_error = *r.out.parm_error;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_srvsvc_NetShareDel_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetShareDel_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetShareDel_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct srvsvc_NetShareDel *r)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetShareDel_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetShareDel_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETSHAREDEL, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetShareDel_r_done, req);

	return req;
}

static void dcerpc_srvsvc_NetShareDel_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetShareDel_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_srvsvc_NetShareDel_r_state *state =
		tevent_req_data(req,
		struct dcerpc_srvsvc_NetShareDel_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetShareDel_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct srvsvc_NetShareDel *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETSHAREDEL, mem_ctx, r);

	return status;
}

struct dcerpc_srvsvc_NetShareDel_state {
	struct srvsvc_NetShareDel orig;
	struct srvsvc_NetShareDel tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetShareDel_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetShareDel_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct dcerpc_binding_handle *h,
						  const char *_server_unc /* [in] [charset(UTF16),unique] */,
						  const char *_share_name /* [in] [charset(UTF16)] */,
						  uint32_t _reserved /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetShareDel_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetShareDel_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_unc = _server_unc;
	state->orig.in.share_name = _share_name;
	state->orig.in.reserved = _reserved;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_srvsvc_NetShareDel_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetShareDel_done, req);
	return req;
}

static void dcerpc_srvsvc_NetShareDel_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_srvsvc_NetShareDel_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetShareDel_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_srvsvc_NetShareDel_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetShareDel_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					WERROR *result)
{
	struct dcerpc_srvsvc_NetShareDel_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetShareDel_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetShareDel(struct dcerpc_binding_handle *h,
				   TALLOC_CTX *mem_ctx,
				   const char *_server_unc /* [in] [charset(UTF16),unique] */,
				   const char *_share_name /* [in] [charset(UTF16)] */,
				   uint32_t _reserved /* [in]  */,
				   WERROR *result)
{
	struct srvsvc_NetShareDel r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = _server_unc;
	r.in.share_name = _share_name;
	r.in.reserved = _reserved;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_srvsvc_NetShareDel_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_srvsvc_NetShareDelSticky_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetShareDelSticky_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetShareDelSticky_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct srvsvc_NetShareDelSticky *r)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetShareDelSticky_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetShareDelSticky_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETSHAREDELSTICKY, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetShareDelSticky_r_done, req);

	return req;
}

static void dcerpc_srvsvc_NetShareDelSticky_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetShareDelSticky_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_srvsvc_NetShareDelSticky_r_state *state =
		tevent_req_data(req,
		struct dcerpc_srvsvc_NetShareDelSticky_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetShareDelSticky_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct srvsvc_NetShareDelSticky *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETSHAREDELSTICKY, mem_ctx, r);

	return status;
}

struct dcerpc_srvsvc_NetShareDelSticky_state {
	struct srvsvc_NetShareDelSticky orig;
	struct srvsvc_NetShareDelSticky tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetShareDelSticky_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetShareDelSticky_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							const char *_server_unc /* [in] [unique,charset(UTF16)] */,
							const char *_share_name /* [in] [charset(UTF16)] */,
							uint32_t _reserved /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetShareDelSticky_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetShareDelSticky_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_unc = _server_unc;
	state->orig.in.share_name = _share_name;
	state->orig.in.reserved = _reserved;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_srvsvc_NetShareDelSticky_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetShareDelSticky_done, req);
	return req;
}

static void dcerpc_srvsvc_NetShareDelSticky_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_srvsvc_NetShareDelSticky_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetShareDelSticky_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_srvsvc_NetShareDelSticky_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetShareDelSticky_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      WERROR *result)
{
	struct dcerpc_srvsvc_NetShareDelSticky_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetShareDelSticky_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetShareDelSticky(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 const char *_server_unc /* [in] [unique,charset(UTF16)] */,
					 const char *_share_name /* [in] [charset(UTF16)] */,
					 uint32_t _reserved /* [in]  */,
					 WERROR *result)
{
	struct srvsvc_NetShareDelSticky r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = _server_unc;
	r.in.share_name = _share_name;
	r.in.reserved = _reserved;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_srvsvc_NetShareDelSticky_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_srvsvc_NetShareCheck_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetShareCheck_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetShareCheck_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct srvsvc_NetShareCheck *r)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetShareCheck_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetShareCheck_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETSHARECHECK, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetShareCheck_r_done, req);

	return req;
}

static void dcerpc_srvsvc_NetShareCheck_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetShareCheck_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_srvsvc_NetShareCheck_r_state *state =
		tevent_req_data(req,
		struct dcerpc_srvsvc_NetShareCheck_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetShareCheck_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct srvsvc_NetShareCheck *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETSHARECHECK, mem_ctx, r);

	return status;
}

struct dcerpc_srvsvc_NetShareCheck_state {
	struct srvsvc_NetShareCheck orig;
	struct srvsvc_NetShareCheck tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetShareCheck_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetShareCheck_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    const char *_server_unc /* [in] [charset(UTF16),unique] */,
						    const char *_device_name /* [in] [charset(UTF16)] */,
						    enum srvsvc_ShareType *_type /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetShareCheck_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetShareCheck_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_unc = _server_unc;
	state->orig.in.device_name = _device_name;

	/* Out parameters */
	state->orig.out.type = _type;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_srvsvc_NetShareCheck_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_srvsvc_NetShareCheck_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetShareCheck_done, req);
	return req;
}

static void dcerpc_srvsvc_NetShareCheck_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_srvsvc_NetShareCheck_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetShareCheck_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_srvsvc_NetShareCheck_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.type = *state->tmp.out.type;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetShareCheck_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct dcerpc_srvsvc_NetShareCheck_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetShareCheck_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetShareCheck(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     const char *_server_unc /* [in] [charset(UTF16),unique] */,
				     const char *_device_name /* [in] [charset(UTF16)] */,
				     enum srvsvc_ShareType *_type /* [out] [ref] */,
				     WERROR *result)
{
	struct srvsvc_NetShareCheck r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = _server_unc;
	r.in.device_name = _device_name;

	/* Out parameters */
	r.out.type = _type;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_srvsvc_NetShareCheck_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_type = *r.out.type;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_srvsvc_NetSrvGetInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetSrvGetInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetSrvGetInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct srvsvc_NetSrvGetInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetSrvGetInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetSrvGetInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETSRVGETINFO, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetSrvGetInfo_r_done, req);

	return req;
}

static void dcerpc_srvsvc_NetSrvGetInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetSrvGetInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_srvsvc_NetSrvGetInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_srvsvc_NetSrvGetInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetSrvGetInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct srvsvc_NetSrvGetInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETSRVGETINFO, mem_ctx, r);

	return status;
}

struct dcerpc_srvsvc_NetSrvGetInfo_state {
	struct srvsvc_NetSrvGetInfo orig;
	struct srvsvc_NetSrvGetInfo tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetSrvGetInfo_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetSrvGetInfo_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    const char *_server_unc /* [in] [charset(UTF16),unique] */,
						    uint32_t _level /* [in]  */,
						    union srvsvc_NetSrvInfo *_info /* [out] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetSrvGetInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetSrvGetInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_unc = _server_unc;
	state->orig.in.level = _level;

	/* Out parameters */
	state->orig.out.info = _info;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_srvsvc_NetSrvGetInfo_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_srvsvc_NetSrvGetInfo_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetSrvGetInfo_done, req);
	return req;
}

static void dcerpc_srvsvc_NetSrvGetInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_srvsvc_NetSrvGetInfo_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetSrvGetInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_srvsvc_NetSrvGetInfo_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetSrvGetInfo_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct dcerpc_srvsvc_NetSrvGetInfo_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetSrvGetInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetSrvGetInfo(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     const char *_server_unc /* [in] [charset(UTF16),unique] */,
				     uint32_t _level /* [in]  */,
				     union srvsvc_NetSrvInfo *_info /* [out] [ref,switch_is(level)] */,
				     WERROR *result)
{
	struct srvsvc_NetSrvGetInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = _server_unc;
	r.in.level = _level;

	/* Out parameters */
	r.out.info = _info;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_srvsvc_NetSrvGetInfo_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_info = *r.out.info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_srvsvc_NetSrvSetInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetSrvSetInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetSrvSetInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct srvsvc_NetSrvSetInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetSrvSetInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetSrvSetInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETSRVSETINFO, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetSrvSetInfo_r_done, req);

	return req;
}

static void dcerpc_srvsvc_NetSrvSetInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetSrvSetInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_srvsvc_NetSrvSetInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_srvsvc_NetSrvSetInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetSrvSetInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct srvsvc_NetSrvSetInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETSRVSETINFO, mem_ctx, r);

	return status;
}

struct dcerpc_srvsvc_NetSrvSetInfo_state {
	struct srvsvc_NetSrvSetInfo orig;
	struct srvsvc_NetSrvSetInfo tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetSrvSetInfo_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetSrvSetInfo_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    const char *_server_unc /* [in] [charset(UTF16),unique] */,
						    uint32_t _level /* [in]  */,
						    union srvsvc_NetSrvInfo *_info /* [in] [ref,switch_is(level)] */,
						    uint32_t *_parm_error /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetSrvSetInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetSrvSetInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_unc = _server_unc;
	state->orig.in.level = _level;
	state->orig.in.info = _info;
	state->orig.in.parm_error = _parm_error;

	/* Out parameters */
	state->orig.out.parm_error = _parm_error;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_srvsvc_NetSrvSetInfo_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_srvsvc_NetSrvSetInfo_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetSrvSetInfo_done, req);
	return req;
}

static void dcerpc_srvsvc_NetSrvSetInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_srvsvc_NetSrvSetInfo_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetSrvSetInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_srvsvc_NetSrvSetInfo_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.parm_error && state->tmp.out.parm_error) {
		*state->orig.out.parm_error = *state->tmp.out.parm_error;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetSrvSetInfo_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct dcerpc_srvsvc_NetSrvSetInfo_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetSrvSetInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetSrvSetInfo(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     const char *_server_unc /* [in] [charset(UTF16),unique] */,
				     uint32_t _level /* [in]  */,
				     union srvsvc_NetSrvInfo *_info /* [in] [ref,switch_is(level)] */,
				     uint32_t *_parm_error /* [in,out] [unique] */,
				     WERROR *result)
{
	struct srvsvc_NetSrvSetInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = _server_unc;
	r.in.level = _level;
	r.in.info = _info;
	r.in.parm_error = _parm_error;

	/* Out parameters */
	r.out.parm_error = _parm_error;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_srvsvc_NetSrvSetInfo_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_parm_error && r.out.parm_error) {
		*_parm_error = *r.out.parm_error;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_srvsvc_NetDiskEnum_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetDiskEnum_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetDiskEnum_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct srvsvc_NetDiskEnum *r)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetDiskEnum_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetDiskEnum_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETDISKENUM, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetDiskEnum_r_done, req);

	return req;
}

static void dcerpc_srvsvc_NetDiskEnum_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetDiskEnum_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_srvsvc_NetDiskEnum_r_state *state =
		tevent_req_data(req,
		struct dcerpc_srvsvc_NetDiskEnum_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetDiskEnum_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct srvsvc_NetDiskEnum *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETDISKENUM, mem_ctx, r);

	return status;
}

struct dcerpc_srvsvc_NetDiskEnum_state {
	struct srvsvc_NetDiskEnum orig;
	struct srvsvc_NetDiskEnum tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetDiskEnum_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetDiskEnum_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct dcerpc_binding_handle *h,
						  const char *_server_unc /* [in] [charset(UTF16),unique] */,
						  uint32_t _level /* [in]  */,
						  struct srvsvc_NetDiskInfo *_info /* [in,out] [ref] */,
						  uint32_t _maxlen /* [in]  */,
						  uint32_t *_totalentries /* [out] [ref] */,
						  uint32_t *_resume_handle /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetDiskEnum_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetDiskEnum_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_unc = _server_unc;
	state->orig.in.level = _level;
	state->orig.in.info = _info;
	state->orig.in.maxlen = _maxlen;
	state->orig.in.resume_handle = _resume_handle;

	/* Out parameters */
	state->orig.out.info = _info;
	state->orig.out.totalentries = _totalentries;
	state->orig.out.resume_handle = _resume_handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_srvsvc_NetDiskEnum_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_srvsvc_NetDiskEnum_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetDiskEnum_done, req);
	return req;
}

static void dcerpc_srvsvc_NetDiskEnum_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_srvsvc_NetDiskEnum_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetDiskEnum_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_srvsvc_NetDiskEnum_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;
	*state->orig.out.totalentries = *state->tmp.out.totalentries;
	if (state->orig.out.resume_handle && state->tmp.out.resume_handle) {
		*state->orig.out.resume_handle = *state->tmp.out.resume_handle;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetDiskEnum_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					WERROR *result)
{
	struct dcerpc_srvsvc_NetDiskEnum_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetDiskEnum_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetDiskEnum(struct dcerpc_binding_handle *h,
				   TALLOC_CTX *mem_ctx,
				   const char *_server_unc /* [in] [charset(UTF16),unique] */,
				   uint32_t _level /* [in]  */,
				   struct srvsvc_NetDiskInfo *_info /* [in,out] [ref] */,
				   uint32_t _maxlen /* [in]  */,
				   uint32_t *_totalentries /* [out] [ref] */,
				   uint32_t *_resume_handle /* [in,out] [unique] */,
				   WERROR *result)
{
	struct srvsvc_NetDiskEnum r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = _server_unc;
	r.in.level = _level;
	r.in.info = _info;
	r.in.maxlen = _maxlen;
	r.in.resume_handle = _resume_handle;

	/* Out parameters */
	r.out.info = _info;
	r.out.totalentries = _totalentries;
	r.out.resume_handle = _resume_handle;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_srvsvc_NetDiskEnum_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_info = *r.out.info;
	*_totalentries = *r.out.totalentries;
	if (_resume_handle && r.out.resume_handle) {
		*_resume_handle = *r.out.resume_handle;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_srvsvc_NetServerStatisticsGet_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetServerStatisticsGet_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetServerStatisticsGet_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct srvsvc_NetServerStatisticsGet *r)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetServerStatisticsGet_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetServerStatisticsGet_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETSERVERSTATISTICSGET, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetServerStatisticsGet_r_done, req);

	return req;
}

static void dcerpc_srvsvc_NetServerStatisticsGet_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetServerStatisticsGet_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_srvsvc_NetServerStatisticsGet_r_state *state =
		tevent_req_data(req,
		struct dcerpc_srvsvc_NetServerStatisticsGet_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetServerStatisticsGet_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct srvsvc_NetServerStatisticsGet *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETSERVERSTATISTICSGET, mem_ctx, r);

	return status;
}

struct dcerpc_srvsvc_NetServerStatisticsGet_state {
	struct srvsvc_NetServerStatisticsGet orig;
	struct srvsvc_NetServerStatisticsGet tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetServerStatisticsGet_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetServerStatisticsGet_send(TALLOC_CTX *mem_ctx,
							     struct tevent_context *ev,
							     struct dcerpc_binding_handle *h,
							     const char *_server_unc /* [in] [unique,charset(UTF16)] */,
							     const char *_service /* [in] [charset(UTF16),unique] */,
							     uint32_t _level /* [in]  */,
							     uint32_t _options /* [in]  */,
							     struct srvsvc_Statistics **_stats /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetServerStatisticsGet_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetServerStatisticsGet_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_unc = _server_unc;
	state->orig.in.service = _service;
	state->orig.in.level = _level;
	state->orig.in.options = _options;

	/* Out parameters */
	state->orig.out.stats = _stats;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_srvsvc_NetServerStatisticsGet_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_srvsvc_NetServerStatisticsGet_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetServerStatisticsGet_done, req);
	return req;
}

static void dcerpc_srvsvc_NetServerStatisticsGet_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_srvsvc_NetServerStatisticsGet_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetServerStatisticsGet_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_srvsvc_NetServerStatisticsGet_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.stats = *state->tmp.out.stats;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetServerStatisticsGet_recv(struct tevent_req *req,
						   TALLOC_CTX *mem_ctx,
						   WERROR *result)
{
	struct dcerpc_srvsvc_NetServerStatisticsGet_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetServerStatisticsGet_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetServerStatisticsGet(struct dcerpc_binding_handle *h,
					      TALLOC_CTX *mem_ctx,
					      const char *_server_unc /* [in] [unique,charset(UTF16)] */,
					      const char *_service /* [in] [charset(UTF16),unique] */,
					      uint32_t _level /* [in]  */,
					      uint32_t _options /* [in]  */,
					      struct srvsvc_Statistics **_stats /* [out] [ref] */,
					      WERROR *result)
{
	struct srvsvc_NetServerStatisticsGet r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = _server_unc;
	r.in.service = _service;
	r.in.level = _level;
	r.in.options = _options;

	/* Out parameters */
	r.out.stats = _stats;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_srvsvc_NetServerStatisticsGet_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_stats = *r.out.stats;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_srvsvc_NetTransportAdd_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetTransportAdd_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetTransportAdd_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct srvsvc_NetTransportAdd *r)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetTransportAdd_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetTransportAdd_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETTRANSPORTADD, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetTransportAdd_r_done, req);

	return req;
}

static void dcerpc_srvsvc_NetTransportAdd_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetTransportAdd_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_srvsvc_NetTransportAdd_r_state *state =
		tevent_req_data(req,
		struct dcerpc_srvsvc_NetTransportAdd_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetTransportAdd_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct srvsvc_NetTransportAdd *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETTRANSPORTADD, mem_ctx, r);

	return status;
}

struct dcerpc_srvsvc_NetTransportAdd_state {
	struct srvsvc_NetTransportAdd orig;
	struct srvsvc_NetTransportAdd tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetTransportAdd_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetTransportAdd_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      const char *_server_unc /* [in] [charset(UTF16),unique] */,
						      uint32_t _level /* [in]  */,
						      union srvsvc_NetTransportInfo _info /* [in] [switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetTransportAdd_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetTransportAdd_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_unc = _server_unc;
	state->orig.in.level = _level;
	state->orig.in.info = _info;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_srvsvc_NetTransportAdd_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetTransportAdd_done, req);
	return req;
}

static void dcerpc_srvsvc_NetTransportAdd_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_srvsvc_NetTransportAdd_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetTransportAdd_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_srvsvc_NetTransportAdd_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetTransportAdd_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    WERROR *result)
{
	struct dcerpc_srvsvc_NetTransportAdd_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetTransportAdd_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetTransportAdd(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       const char *_server_unc /* [in] [charset(UTF16),unique] */,
				       uint32_t _level /* [in]  */,
				       union srvsvc_NetTransportInfo _info /* [in] [switch_is(level)] */,
				       WERROR *result)
{
	struct srvsvc_NetTransportAdd r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = _server_unc;
	r.in.level = _level;
	r.in.info = _info;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_srvsvc_NetTransportAdd_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_srvsvc_NetTransportEnum_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetTransportEnum_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetTransportEnum_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct srvsvc_NetTransportEnum *r)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetTransportEnum_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetTransportEnum_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETTRANSPORTENUM, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetTransportEnum_r_done, req);

	return req;
}

static void dcerpc_srvsvc_NetTransportEnum_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetTransportEnum_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_srvsvc_NetTransportEnum_r_state *state =
		tevent_req_data(req,
		struct dcerpc_srvsvc_NetTransportEnum_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetTransportEnum_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct srvsvc_NetTransportEnum *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETTRANSPORTENUM, mem_ctx, r);

	return status;
}

struct dcerpc_srvsvc_NetTransportEnum_state {
	struct srvsvc_NetTransportEnum orig;
	struct srvsvc_NetTransportEnum tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetTransportEnum_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetTransportEnum_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       const char *_server_unc /* [in] [charset(UTF16),unique] */,
						       struct srvsvc_NetTransportInfoCtr *_transports /* [in,out] [ref] */,
						       uint32_t _max_buffer /* [in]  */,
						       uint32_t *_totalentries /* [out] [ref] */,
						       uint32_t *_resume_handle /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetTransportEnum_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetTransportEnum_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_unc = _server_unc;
	state->orig.in.transports = _transports;
	state->orig.in.max_buffer = _max_buffer;
	state->orig.in.resume_handle = _resume_handle;

	/* Out parameters */
	state->orig.out.transports = _transports;
	state->orig.out.totalentries = _totalentries;
	state->orig.out.resume_handle = _resume_handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_srvsvc_NetTransportEnum_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_srvsvc_NetTransportEnum_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetTransportEnum_done, req);
	return req;
}

static void dcerpc_srvsvc_NetTransportEnum_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_srvsvc_NetTransportEnum_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetTransportEnum_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_srvsvc_NetTransportEnum_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.transports = *state->tmp.out.transports;
	*state->orig.out.totalentries = *state->tmp.out.totalentries;
	if (state->orig.out.resume_handle && state->tmp.out.resume_handle) {
		*state->orig.out.resume_handle = *state->tmp.out.resume_handle;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetTransportEnum_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     WERROR *result)
{
	struct dcerpc_srvsvc_NetTransportEnum_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetTransportEnum_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetTransportEnum(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					const char *_server_unc /* [in] [charset(UTF16),unique] */,
					struct srvsvc_NetTransportInfoCtr *_transports /* [in,out] [ref] */,
					uint32_t _max_buffer /* [in]  */,
					uint32_t *_totalentries /* [out] [ref] */,
					uint32_t *_resume_handle /* [in,out] [unique] */,
					WERROR *result)
{
	struct srvsvc_NetTransportEnum r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = _server_unc;
	r.in.transports = _transports;
	r.in.max_buffer = _max_buffer;
	r.in.resume_handle = _resume_handle;

	/* Out parameters */
	r.out.transports = _transports;
	r.out.totalentries = _totalentries;
	r.out.resume_handle = _resume_handle;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_srvsvc_NetTransportEnum_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_transports = *r.out.transports;
	*_totalentries = *r.out.totalentries;
	if (_resume_handle && r.out.resume_handle) {
		*_resume_handle = *r.out.resume_handle;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_srvsvc_NetTransportDel_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetTransportDel_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetTransportDel_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct srvsvc_NetTransportDel *r)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetTransportDel_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetTransportDel_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETTRANSPORTDEL, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetTransportDel_r_done, req);

	return req;
}

static void dcerpc_srvsvc_NetTransportDel_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetTransportDel_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_srvsvc_NetTransportDel_r_state *state =
		tevent_req_data(req,
		struct dcerpc_srvsvc_NetTransportDel_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetTransportDel_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct srvsvc_NetTransportDel *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETTRANSPORTDEL, mem_ctx, r);

	return status;
}

struct dcerpc_srvsvc_NetTransportDel_state {
	struct srvsvc_NetTransportDel orig;
	struct srvsvc_NetTransportDel tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetTransportDel_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetTransportDel_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      const char *_server_unc /* [in] [unique,charset(UTF16)] */,
						      uint32_t _level /* [in]  */,
						      struct srvsvc_NetTransportInfo0 *_info0 /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetTransportDel_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetTransportDel_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_unc = _server_unc;
	state->orig.in.level = _level;
	state->orig.in.info0 = _info0;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_srvsvc_NetTransportDel_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetTransportDel_done, req);
	return req;
}

static void dcerpc_srvsvc_NetTransportDel_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_srvsvc_NetTransportDel_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetTransportDel_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_srvsvc_NetTransportDel_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetTransportDel_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    WERROR *result)
{
	struct dcerpc_srvsvc_NetTransportDel_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetTransportDel_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetTransportDel(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       const char *_server_unc /* [in] [unique,charset(UTF16)] */,
				       uint32_t _level /* [in]  */,
				       struct srvsvc_NetTransportInfo0 *_info0 /* [in] [ref] */,
				       WERROR *result)
{
	struct srvsvc_NetTransportDel r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = _server_unc;
	r.in.level = _level;
	r.in.info0 = _info0;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_srvsvc_NetTransportDel_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_srvsvc_NetRemoteTOD_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetRemoteTOD_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetRemoteTOD_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct srvsvc_NetRemoteTOD *r)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetRemoteTOD_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetRemoteTOD_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETREMOTETOD, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetRemoteTOD_r_done, req);

	return req;
}

static void dcerpc_srvsvc_NetRemoteTOD_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetRemoteTOD_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_srvsvc_NetRemoteTOD_r_state *state =
		tevent_req_data(req,
		struct dcerpc_srvsvc_NetRemoteTOD_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetRemoteTOD_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct srvsvc_NetRemoteTOD *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETREMOTETOD, mem_ctx, r);

	return status;
}

struct dcerpc_srvsvc_NetRemoteTOD_state {
	struct srvsvc_NetRemoteTOD orig;
	struct srvsvc_NetRemoteTOD tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetRemoteTOD_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetRemoteTOD_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct dcerpc_binding_handle *h,
						   const char *_server_unc /* [in] [charset(UTF16),unique] */,
						   struct srvsvc_NetRemoteTODInfo **_info /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetRemoteTOD_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetRemoteTOD_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_unc = _server_unc;

	/* Out parameters */
	state->orig.out.info = _info;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_srvsvc_NetRemoteTOD_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_srvsvc_NetRemoteTOD_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetRemoteTOD_done, req);
	return req;
}

static void dcerpc_srvsvc_NetRemoteTOD_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_srvsvc_NetRemoteTOD_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetRemoteTOD_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_srvsvc_NetRemoteTOD_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetRemoteTOD_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 WERROR *result)
{
	struct dcerpc_srvsvc_NetRemoteTOD_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetRemoteTOD_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetRemoteTOD(struct dcerpc_binding_handle *h,
				    TALLOC_CTX *mem_ctx,
				    const char *_server_unc /* [in] [charset(UTF16),unique] */,
				    struct srvsvc_NetRemoteTODInfo **_info /* [out] [ref] */,
				    WERROR *result)
{
	struct srvsvc_NetRemoteTOD r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = _server_unc;

	/* Out parameters */
	r.out.info = _info;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_srvsvc_NetRemoteTOD_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_info = *r.out.info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_srvsvc_NetSetServiceBits_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetSetServiceBits_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetSetServiceBits_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct srvsvc_NetSetServiceBits *r)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetSetServiceBits_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetSetServiceBits_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETSETSERVICEBITS, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetSetServiceBits_r_done, req);

	return req;
}

static void dcerpc_srvsvc_NetSetServiceBits_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetSetServiceBits_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_srvsvc_NetSetServiceBits_r_state *state =
		tevent_req_data(req,
		struct dcerpc_srvsvc_NetSetServiceBits_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetSetServiceBits_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct srvsvc_NetSetServiceBits *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETSETSERVICEBITS, mem_ctx, r);

	return status;
}

struct dcerpc_srvsvc_NetSetServiceBits_state {
	struct srvsvc_NetSetServiceBits orig;
	struct srvsvc_NetSetServiceBits tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetSetServiceBits_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetSetServiceBits_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							const char *_server_unc /* [in] [charset(UTF16),unique] */,
							const char *_transport /* [in] [charset(UTF16),unique] */,
							uint32_t _servicebits /* [in]  */,
							uint32_t _updateimmediately /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetSetServiceBits_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetSetServiceBits_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_unc = _server_unc;
	state->orig.in.transport = _transport;
	state->orig.in.servicebits = _servicebits;
	state->orig.in.updateimmediately = _updateimmediately;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_srvsvc_NetSetServiceBits_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetSetServiceBits_done, req);
	return req;
}

static void dcerpc_srvsvc_NetSetServiceBits_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_srvsvc_NetSetServiceBits_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetSetServiceBits_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_srvsvc_NetSetServiceBits_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetSetServiceBits_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      WERROR *result)
{
	struct dcerpc_srvsvc_NetSetServiceBits_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetSetServiceBits_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetSetServiceBits(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 const char *_server_unc /* [in] [charset(UTF16),unique] */,
					 const char *_transport /* [in] [charset(UTF16),unique] */,
					 uint32_t _servicebits /* [in]  */,
					 uint32_t _updateimmediately /* [in]  */,
					 WERROR *result)
{
	struct srvsvc_NetSetServiceBits r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = _server_unc;
	r.in.transport = _transport;
	r.in.servicebits = _servicebits;
	r.in.updateimmediately = _updateimmediately;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_srvsvc_NetSetServiceBits_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_srvsvc_NetPathType_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetPathType_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetPathType_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct srvsvc_NetPathType *r)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetPathType_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetPathType_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETPATHTYPE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetPathType_r_done, req);

	return req;
}

static void dcerpc_srvsvc_NetPathType_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetPathType_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_srvsvc_NetPathType_r_state *state =
		tevent_req_data(req,
		struct dcerpc_srvsvc_NetPathType_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetPathType_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct srvsvc_NetPathType *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETPATHTYPE, mem_ctx, r);

	return status;
}

struct dcerpc_srvsvc_NetPathType_state {
	struct srvsvc_NetPathType orig;
	struct srvsvc_NetPathType tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetPathType_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetPathType_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct dcerpc_binding_handle *h,
						  const char *_server_unc /* [in] [unique,charset(UTF16)] */,
						  const char *_path /* [in] [charset(UTF16)] */,
						  uint32_t _pathflags /* [in]  */,
						  uint32_t *_pathtype /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetPathType_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetPathType_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_unc = _server_unc;
	state->orig.in.path = _path;
	state->orig.in.pathflags = _pathflags;

	/* Out parameters */
	state->orig.out.pathtype = _pathtype;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_srvsvc_NetPathType_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_srvsvc_NetPathType_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetPathType_done, req);
	return req;
}

static void dcerpc_srvsvc_NetPathType_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_srvsvc_NetPathType_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetPathType_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_srvsvc_NetPathType_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.pathtype = *state->tmp.out.pathtype;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetPathType_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					WERROR *result)
{
	struct dcerpc_srvsvc_NetPathType_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetPathType_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetPathType(struct dcerpc_binding_handle *h,
				   TALLOC_CTX *mem_ctx,
				   const char *_server_unc /* [in] [unique,charset(UTF16)] */,
				   const char *_path /* [in] [charset(UTF16)] */,
				   uint32_t _pathflags /* [in]  */,
				   uint32_t *_pathtype /* [out] [ref] */,
				   WERROR *result)
{
	struct srvsvc_NetPathType r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = _server_unc;
	r.in.path = _path;
	r.in.pathflags = _pathflags;

	/* Out parameters */
	r.out.pathtype = _pathtype;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_srvsvc_NetPathType_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_pathtype = *r.out.pathtype;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_srvsvc_NetPathCanonicalize_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetPathCanonicalize_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetPathCanonicalize_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct srvsvc_NetPathCanonicalize *r)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetPathCanonicalize_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetPathCanonicalize_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETPATHCANONICALIZE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetPathCanonicalize_r_done, req);

	return req;
}

static void dcerpc_srvsvc_NetPathCanonicalize_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetPathCanonicalize_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_srvsvc_NetPathCanonicalize_r_state *state =
		tevent_req_data(req,
		struct dcerpc_srvsvc_NetPathCanonicalize_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetPathCanonicalize_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct srvsvc_NetPathCanonicalize *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETPATHCANONICALIZE, mem_ctx, r);

	return status;
}

struct dcerpc_srvsvc_NetPathCanonicalize_state {
	struct srvsvc_NetPathCanonicalize orig;
	struct srvsvc_NetPathCanonicalize tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetPathCanonicalize_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetPathCanonicalize_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  const char *_server_unc /* [in] [unique,charset(UTF16)] */,
							  const char *_path /* [in] [charset(UTF16)] */,
							  uint8_t *_can_path /* [out] [size_is(maxbuf)] */,
							  uint32_t _maxbuf /* [in]  */,
							  const char *_prefix /* [in] [charset(UTF16)] */,
							  uint32_t *_pathtype /* [in,out] [ref] */,
							  uint32_t _pathflags /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetPathCanonicalize_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetPathCanonicalize_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_unc = _server_unc;
	state->orig.in.path = _path;
	state->orig.in.maxbuf = _maxbuf;
	state->orig.in.prefix = _prefix;
	state->orig.in.pathtype = _pathtype;
	state->orig.in.pathflags = _pathflags;

	/* Out parameters */
	state->orig.out.can_path = _can_path;
	state->orig.out.pathtype = _pathtype;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_srvsvc_NetPathCanonicalize_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_srvsvc_NetPathCanonicalize_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetPathCanonicalize_done, req);
	return req;
}

static void dcerpc_srvsvc_NetPathCanonicalize_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_srvsvc_NetPathCanonicalize_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetPathCanonicalize_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_srvsvc_NetPathCanonicalize_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_can_path;
		_copy_len_can_path = state->tmp.in.maxbuf;
		memcpy(state->orig.out.can_path, state->tmp.out.can_path, _copy_len_can_path * sizeof(*state->orig.out.can_path));
	}
	*state->orig.out.pathtype = *state->tmp.out.pathtype;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetPathCanonicalize_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result)
{
	struct dcerpc_srvsvc_NetPathCanonicalize_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetPathCanonicalize_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetPathCanonicalize(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   const char *_server_unc /* [in] [unique,charset(UTF16)] */,
					   const char *_path /* [in] [charset(UTF16)] */,
					   uint8_t *_can_path /* [out] [size_is(maxbuf)] */,
					   uint32_t _maxbuf /* [in]  */,
					   const char *_prefix /* [in] [charset(UTF16)] */,
					   uint32_t *_pathtype /* [in,out] [ref] */,
					   uint32_t _pathflags /* [in]  */,
					   WERROR *result)
{
	struct srvsvc_NetPathCanonicalize r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = _server_unc;
	r.in.path = _path;
	r.in.maxbuf = _maxbuf;
	r.in.prefix = _prefix;
	r.in.pathtype = _pathtype;
	r.in.pathflags = _pathflags;

	/* Out parameters */
	r.out.can_path = _can_path;
	r.out.pathtype = _pathtype;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_srvsvc_NetPathCanonicalize_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_can_path;
		_copy_len_can_path = r.in.maxbuf;
		memcpy(_can_path, r.out.can_path, _copy_len_can_path * sizeof(*_can_path));
	}
	*_pathtype = *r.out.pathtype;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_srvsvc_NetPathCompare_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetPathCompare_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetPathCompare_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct srvsvc_NetPathCompare *r)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetPathCompare_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetPathCompare_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETPATHCOMPARE, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetPathCompare_r_done, req);

	return req;
}

static void dcerpc_srvsvc_NetPathCompare_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetPathCompare_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_srvsvc_NetPathCompare_r_state *state =
		tevent_req_data(req,
		struct dcerpc_srvsvc_NetPathCompare_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetPathCompare_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct srvsvc_NetPathCompare *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETPATHCOMPARE, mem_ctx, r);

	return status;
}

struct dcerpc_srvsvc_NetPathCompare_state {
	struct srvsvc_NetPathCompare orig;
	struct srvsvc_NetPathCompare tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetPathCompare_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetPathCompare_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     const char *_server_unc /* [in] [unique,charset(UTF16)] */,
						     const char *_path1 /* [in] [charset(UTF16)] */,
						     const char *_path2 /* [in] [charset(UTF16)] */,
						     uint32_t _pathtype /* [in]  */,
						     uint32_t _pathflags /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetPathCompare_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetPathCompare_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_unc = _server_unc;
	state->orig.in.path1 = _path1;
	state->orig.in.path2 = _path2;
	state->orig.in.pathtype = _pathtype;
	state->orig.in.pathflags = _pathflags;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_srvsvc_NetPathCompare_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetPathCompare_done, req);
	return req;
}

static void dcerpc_srvsvc_NetPathCompare_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_srvsvc_NetPathCompare_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetPathCompare_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_srvsvc_NetPathCompare_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetPathCompare_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_srvsvc_NetPathCompare_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetPathCompare_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetPathCompare(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      const char *_server_unc /* [in] [unique,charset(UTF16)] */,
				      const char *_path1 /* [in] [charset(UTF16)] */,
				      const char *_path2 /* [in] [charset(UTF16)] */,
				      uint32_t _pathtype /* [in]  */,
				      uint32_t _pathflags /* [in]  */,
				      WERROR *result)
{
	struct srvsvc_NetPathCompare r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = _server_unc;
	r.in.path1 = _path1;
	r.in.path2 = _path2;
	r.in.pathtype = _pathtype;
	r.in.pathflags = _pathflags;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_srvsvc_NetPathCompare_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_srvsvc_NetNameValidate_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetNameValidate_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetNameValidate_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct srvsvc_NetNameValidate *r)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetNameValidate_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetNameValidate_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETNAMEVALIDATE, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetNameValidate_r_done, req);

	return req;
}

static void dcerpc_srvsvc_NetNameValidate_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetNameValidate_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_srvsvc_NetNameValidate_r_state *state =
		tevent_req_data(req,
		struct dcerpc_srvsvc_NetNameValidate_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetNameValidate_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct srvsvc_NetNameValidate *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETNAMEVALIDATE, mem_ctx, r);

	return status;
}

struct dcerpc_srvsvc_NetNameValidate_state {
	struct srvsvc_NetNameValidate orig;
	struct srvsvc_NetNameValidate tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetNameValidate_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetNameValidate_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      const char *_server_unc /* [in] [unique,charset(UTF16)] */,
						      const char *_name /* [in] [charset(UTF16)] */,
						      uint32_t _name_type /* [in]  */,
						      uint32_t _flags /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetNameValidate_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetNameValidate_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_unc = _server_unc;
	state->orig.in.name = _name;
	state->orig.in.name_type = _name_type;
	state->orig.in.flags = _flags;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_srvsvc_NetNameValidate_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetNameValidate_done, req);
	return req;
}

static void dcerpc_srvsvc_NetNameValidate_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_srvsvc_NetNameValidate_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetNameValidate_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_srvsvc_NetNameValidate_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetNameValidate_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    WERROR *result)
{
	struct dcerpc_srvsvc_NetNameValidate_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetNameValidate_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetNameValidate(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       const char *_server_unc /* [in] [unique,charset(UTF16)] */,
				       const char *_name /* [in] [charset(UTF16)] */,
				       uint32_t _name_type /* [in]  */,
				       uint32_t _flags /* [in]  */,
				       WERROR *result)
{
	struct srvsvc_NetNameValidate r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = _server_unc;
	r.in.name = _name;
	r.in.name_type = _name_type;
	r.in.flags = _flags;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_srvsvc_NetNameValidate_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_srvsvc_NetPRNameCompare_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetPRNameCompare_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetPRNameCompare_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct srvsvc_NetPRNameCompare *r)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetPRNameCompare_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetPRNameCompare_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETPRNAMECOMPARE, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetPRNameCompare_r_done, req);

	return req;
}

static void dcerpc_srvsvc_NetPRNameCompare_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetPRNameCompare_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_srvsvc_NetPRNameCompare_r_state *state =
		tevent_req_data(req,
		struct dcerpc_srvsvc_NetPRNameCompare_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetPRNameCompare_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct srvsvc_NetPRNameCompare *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETPRNAMECOMPARE, mem_ctx, r);

	return status;
}

struct dcerpc_srvsvc_NetPRNameCompare_state {
	struct srvsvc_NetPRNameCompare orig;
	struct srvsvc_NetPRNameCompare tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetPRNameCompare_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetPRNameCompare_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       const char *_server_unc /* [in] [charset(UTF16),unique] */,
						       const char *_name1 /* [in] [charset(UTF16)] */,
						       const char *_name2 /* [in] [charset(UTF16)] */,
						       uint32_t _name_type /* [in]  */,
						       uint32_t _flags /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetPRNameCompare_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetPRNameCompare_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_unc = _server_unc;
	state->orig.in.name1 = _name1;
	state->orig.in.name2 = _name2;
	state->orig.in.name_type = _name_type;
	state->orig.in.flags = _flags;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_srvsvc_NetPRNameCompare_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetPRNameCompare_done, req);
	return req;
}

static void dcerpc_srvsvc_NetPRNameCompare_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_srvsvc_NetPRNameCompare_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetPRNameCompare_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_srvsvc_NetPRNameCompare_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetPRNameCompare_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     WERROR *result)
{
	struct dcerpc_srvsvc_NetPRNameCompare_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetPRNameCompare_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetPRNameCompare(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					const char *_server_unc /* [in] [charset(UTF16),unique] */,
					const char *_name1 /* [in] [charset(UTF16)] */,
					const char *_name2 /* [in] [charset(UTF16)] */,
					uint32_t _name_type /* [in]  */,
					uint32_t _flags /* [in]  */,
					WERROR *result)
{
	struct srvsvc_NetPRNameCompare r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = _server_unc;
	r.in.name1 = _name1;
	r.in.name2 = _name2;
	r.in.name_type = _name_type;
	r.in.flags = _flags;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_srvsvc_NetPRNameCompare_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_srvsvc_NetShareEnum_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetShareEnum_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetShareEnum_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct srvsvc_NetShareEnum *r)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetShareEnum_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetShareEnum_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETSHAREENUM, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetShareEnum_r_done, req);

	return req;
}

static void dcerpc_srvsvc_NetShareEnum_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetShareEnum_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_srvsvc_NetShareEnum_r_state *state =
		tevent_req_data(req,
		struct dcerpc_srvsvc_NetShareEnum_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetShareEnum_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct srvsvc_NetShareEnum *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETSHAREENUM, mem_ctx, r);

	return status;
}

struct dcerpc_srvsvc_NetShareEnum_state {
	struct srvsvc_NetShareEnum orig;
	struct srvsvc_NetShareEnum tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetShareEnum_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetShareEnum_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct dcerpc_binding_handle *h,
						   const char *_server_unc /* [in] [unique,charset(UTF16)] */,
						   struct srvsvc_NetShareInfoCtr *_info_ctr /* [in,out] [ref] */,
						   uint32_t _max_buffer /* [in]  */,
						   uint32_t *_totalentries /* [out] [ref] */,
						   uint32_t *_resume_handle /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetShareEnum_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetShareEnum_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_unc = _server_unc;
	state->orig.in.info_ctr = _info_ctr;
	state->orig.in.max_buffer = _max_buffer;
	state->orig.in.resume_handle = _resume_handle;

	/* Out parameters */
	state->orig.out.info_ctr = _info_ctr;
	state->orig.out.totalentries = _totalentries;
	state->orig.out.resume_handle = _resume_handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_srvsvc_NetShareEnum_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_srvsvc_NetShareEnum_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetShareEnum_done, req);
	return req;
}

static void dcerpc_srvsvc_NetShareEnum_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_srvsvc_NetShareEnum_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetShareEnum_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_srvsvc_NetShareEnum_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info_ctr = *state->tmp.out.info_ctr;
	*state->orig.out.totalentries = *state->tmp.out.totalentries;
	if (state->orig.out.resume_handle && state->tmp.out.resume_handle) {
		*state->orig.out.resume_handle = *state->tmp.out.resume_handle;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetShareEnum_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 WERROR *result)
{
	struct dcerpc_srvsvc_NetShareEnum_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetShareEnum_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetShareEnum(struct dcerpc_binding_handle *h,
				    TALLOC_CTX *mem_ctx,
				    const char *_server_unc /* [in] [unique,charset(UTF16)] */,
				    struct srvsvc_NetShareInfoCtr *_info_ctr /* [in,out] [ref] */,
				    uint32_t _max_buffer /* [in]  */,
				    uint32_t *_totalentries /* [out] [ref] */,
				    uint32_t *_resume_handle /* [in,out] [unique] */,
				    WERROR *result)
{
	struct srvsvc_NetShareEnum r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = _server_unc;
	r.in.info_ctr = _info_ctr;
	r.in.max_buffer = _max_buffer;
	r.in.resume_handle = _resume_handle;

	/* Out parameters */
	r.out.info_ctr = _info_ctr;
	r.out.totalentries = _totalentries;
	r.out.resume_handle = _resume_handle;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_srvsvc_NetShareEnum_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_info_ctr = *r.out.info_ctr;
	*_totalentries = *r.out.totalentries;
	if (_resume_handle && r.out.resume_handle) {
		*_resume_handle = *r.out.resume_handle;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_srvsvc_NetShareDelStart_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetShareDelStart_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetShareDelStart_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct srvsvc_NetShareDelStart *r)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetShareDelStart_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetShareDelStart_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETSHAREDELSTART, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetShareDelStart_r_done, req);

	return req;
}

static void dcerpc_srvsvc_NetShareDelStart_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetShareDelStart_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_srvsvc_NetShareDelStart_r_state *state =
		tevent_req_data(req,
		struct dcerpc_srvsvc_NetShareDelStart_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetShareDelStart_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct srvsvc_NetShareDelStart *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETSHAREDELSTART, mem_ctx, r);

	return status;
}

struct dcerpc_srvsvc_NetShareDelStart_state {
	struct srvsvc_NetShareDelStart orig;
	struct srvsvc_NetShareDelStart tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetShareDelStart_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetShareDelStart_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       const char *_server_unc /* [in] [charset(UTF16),unique] */,
						       const char *_share /* [in] [charset(UTF16)] */,
						       uint32_t _reserved /* [in]  */,
						       struct policy_handle *_hnd /* [out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetShareDelStart_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetShareDelStart_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_unc = _server_unc;
	state->orig.in.share = _share;
	state->orig.in.reserved = _reserved;

	/* Out parameters */
	state->orig.out.hnd = _hnd;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_srvsvc_NetShareDelStart_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_srvsvc_NetShareDelStart_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetShareDelStart_done, req);
	return req;
}

static void dcerpc_srvsvc_NetShareDelStart_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_srvsvc_NetShareDelStart_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetShareDelStart_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_srvsvc_NetShareDelStart_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.hnd && state->tmp.out.hnd) {
		*state->orig.out.hnd = *state->tmp.out.hnd;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetShareDelStart_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     WERROR *result)
{
	struct dcerpc_srvsvc_NetShareDelStart_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetShareDelStart_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetShareDelStart(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					const char *_server_unc /* [in] [charset(UTF16),unique] */,
					const char *_share /* [in] [charset(UTF16)] */,
					uint32_t _reserved /* [in]  */,
					struct policy_handle *_hnd /* [out] [unique] */,
					WERROR *result)
{
	struct srvsvc_NetShareDelStart r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = _server_unc;
	r.in.share = _share;
	r.in.reserved = _reserved;

	/* Out parameters */
	r.out.hnd = _hnd;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_srvsvc_NetShareDelStart_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_hnd && r.out.hnd) {
		*_hnd = *r.out.hnd;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_srvsvc_NetShareDelCommit_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetShareDelCommit_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetShareDelCommit_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct srvsvc_NetShareDelCommit *r)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetShareDelCommit_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetShareDelCommit_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETSHAREDELCOMMIT, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetShareDelCommit_r_done, req);

	return req;
}

static void dcerpc_srvsvc_NetShareDelCommit_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetShareDelCommit_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_srvsvc_NetShareDelCommit_r_state *state =
		tevent_req_data(req,
		struct dcerpc_srvsvc_NetShareDelCommit_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetShareDelCommit_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct srvsvc_NetShareDelCommit *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETSHAREDELCOMMIT, mem_ctx, r);

	return status;
}

struct dcerpc_srvsvc_NetShareDelCommit_state {
	struct srvsvc_NetShareDelCommit orig;
	struct srvsvc_NetShareDelCommit tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetShareDelCommit_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetShareDelCommit_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							struct policy_handle *_hnd /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetShareDelCommit_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetShareDelCommit_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hnd = _hnd;

	/* Out parameters */
	state->orig.out.hnd = _hnd;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_srvsvc_NetShareDelCommit_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_srvsvc_NetShareDelCommit_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetShareDelCommit_done, req);
	return req;
}

static void dcerpc_srvsvc_NetShareDelCommit_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_srvsvc_NetShareDelCommit_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetShareDelCommit_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_srvsvc_NetShareDelCommit_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.hnd && state->tmp.out.hnd) {
		*state->orig.out.hnd = *state->tmp.out.hnd;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetShareDelCommit_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      WERROR *result)
{
	struct dcerpc_srvsvc_NetShareDelCommit_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetShareDelCommit_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetShareDelCommit(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle *_hnd /* [in,out] [unique] */,
					 WERROR *result)
{
	struct srvsvc_NetShareDelCommit r;
	NTSTATUS status;

	/* In parameters */
	r.in.hnd = _hnd;

	/* Out parameters */
	r.out.hnd = _hnd;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_srvsvc_NetShareDelCommit_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_hnd && r.out.hnd) {
		*_hnd = *r.out.hnd;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_srvsvc_NetGetFileSecurity_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetGetFileSecurity_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetGetFileSecurity_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct srvsvc_NetGetFileSecurity *r)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetGetFileSecurity_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetGetFileSecurity_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETGETFILESECURITY, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetGetFileSecurity_r_done, req);

	return req;
}

static void dcerpc_srvsvc_NetGetFileSecurity_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetGetFileSecurity_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_srvsvc_NetGetFileSecurity_r_state *state =
		tevent_req_data(req,
		struct dcerpc_srvsvc_NetGetFileSecurity_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetGetFileSecurity_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct srvsvc_NetGetFileSecurity *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETGETFILESECURITY, mem_ctx, r);

	return status;
}

struct dcerpc_srvsvc_NetGetFileSecurity_state {
	struct srvsvc_NetGetFileSecurity orig;
	struct srvsvc_NetGetFileSecurity tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetGetFileSecurity_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetGetFileSecurity_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h,
							 const char *_server_unc /* [in] [unique,charset(UTF16)] */,
							 const char *_share /* [in] [charset(UTF16),unique] */,
							 const char *_file /* [in] [charset(UTF16)] */,
							 uint32_t _securityinformation /* [in]  */,
							 struct sec_desc_buf **_sd_buf /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetGetFileSecurity_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetGetFileSecurity_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_unc = _server_unc;
	state->orig.in.share = _share;
	state->orig.in.file = _file;
	state->orig.in.securityinformation = _securityinformation;

	/* Out parameters */
	state->orig.out.sd_buf = _sd_buf;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_srvsvc_NetGetFileSecurity_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_srvsvc_NetGetFileSecurity_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetGetFileSecurity_done, req);
	return req;
}

static void dcerpc_srvsvc_NetGetFileSecurity_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_srvsvc_NetGetFileSecurity_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetGetFileSecurity_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_srvsvc_NetGetFileSecurity_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.sd_buf = *state->tmp.out.sd_buf;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetGetFileSecurity_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result)
{
	struct dcerpc_srvsvc_NetGetFileSecurity_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetGetFileSecurity_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetGetFileSecurity(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  const char *_server_unc /* [in] [unique,charset(UTF16)] */,
					  const char *_share /* [in] [charset(UTF16),unique] */,
					  const char *_file /* [in] [charset(UTF16)] */,
					  uint32_t _securityinformation /* [in]  */,
					  struct sec_desc_buf **_sd_buf /* [out] [ref] */,
					  WERROR *result)
{
	struct srvsvc_NetGetFileSecurity r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = _server_unc;
	r.in.share = _share;
	r.in.file = _file;
	r.in.securityinformation = _securityinformation;

	/* Out parameters */
	r.out.sd_buf = _sd_buf;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_srvsvc_NetGetFileSecurity_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_sd_buf = *r.out.sd_buf;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_srvsvc_NetSetFileSecurity_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetSetFileSecurity_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetSetFileSecurity_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct srvsvc_NetSetFileSecurity *r)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetSetFileSecurity_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetSetFileSecurity_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETSETFILESECURITY, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetSetFileSecurity_r_done, req);

	return req;
}

static void dcerpc_srvsvc_NetSetFileSecurity_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetSetFileSecurity_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_srvsvc_NetSetFileSecurity_r_state *state =
		tevent_req_data(req,
		struct dcerpc_srvsvc_NetSetFileSecurity_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetSetFileSecurity_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct srvsvc_NetSetFileSecurity *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETSETFILESECURITY, mem_ctx, r);

	return status;
}

struct dcerpc_srvsvc_NetSetFileSecurity_state {
	struct srvsvc_NetSetFileSecurity orig;
	struct srvsvc_NetSetFileSecurity tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetSetFileSecurity_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetSetFileSecurity_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h,
							 const char *_server_unc /* [in] [unique,charset(UTF16)] */,
							 const char *_share /* [in] [unique,charset(UTF16)] */,
							 const char *_file /* [in] [charset(UTF16)] */,
							 uint32_t _securityinformation /* [in]  */,
							 struct sec_desc_buf *_sd_buf /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetSetFileSecurity_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetSetFileSecurity_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_unc = _server_unc;
	state->orig.in.share = _share;
	state->orig.in.file = _file;
	state->orig.in.securityinformation = _securityinformation;
	state->orig.in.sd_buf = _sd_buf;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_srvsvc_NetSetFileSecurity_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetSetFileSecurity_done, req);
	return req;
}

static void dcerpc_srvsvc_NetSetFileSecurity_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_srvsvc_NetSetFileSecurity_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetSetFileSecurity_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_srvsvc_NetSetFileSecurity_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetSetFileSecurity_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result)
{
	struct dcerpc_srvsvc_NetSetFileSecurity_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetSetFileSecurity_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetSetFileSecurity(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  const char *_server_unc /* [in] [unique,charset(UTF16)] */,
					  const char *_share /* [in] [unique,charset(UTF16)] */,
					  const char *_file /* [in] [charset(UTF16)] */,
					  uint32_t _securityinformation /* [in]  */,
					  struct sec_desc_buf *_sd_buf /* [in] [ref] */,
					  WERROR *result)
{
	struct srvsvc_NetSetFileSecurity r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = _server_unc;
	r.in.share = _share;
	r.in.file = _file;
	r.in.securityinformation = _securityinformation;
	r.in.sd_buf = _sd_buf;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_srvsvc_NetSetFileSecurity_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_srvsvc_NetServerTransportAddEx_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetServerTransportAddEx_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetServerTransportAddEx_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct srvsvc_NetServerTransportAddEx *r)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetServerTransportAddEx_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetServerTransportAddEx_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETSERVERTRANSPORTADDEX, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetServerTransportAddEx_r_done, req);

	return req;
}

static void dcerpc_srvsvc_NetServerTransportAddEx_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetServerTransportAddEx_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_srvsvc_NetServerTransportAddEx_r_state *state =
		tevent_req_data(req,
		struct dcerpc_srvsvc_NetServerTransportAddEx_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetServerTransportAddEx_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct srvsvc_NetServerTransportAddEx *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETSERVERTRANSPORTADDEX, mem_ctx, r);

	return status;
}

struct dcerpc_srvsvc_NetServerTransportAddEx_state {
	struct srvsvc_NetServerTransportAddEx orig;
	struct srvsvc_NetServerTransportAddEx tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetServerTransportAddEx_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetServerTransportAddEx_send(TALLOC_CTX *mem_ctx,
							      struct tevent_context *ev,
							      struct dcerpc_binding_handle *h,
							      const char *_server_unc /* [in] [unique,charset(UTF16)] */,
							      uint32_t _level /* [in]  */,
							      union srvsvc_NetTransportInfo _info /* [in] [switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetServerTransportAddEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetServerTransportAddEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_unc = _server_unc;
	state->orig.in.level = _level;
	state->orig.in.info = _info;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_srvsvc_NetServerTransportAddEx_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetServerTransportAddEx_done, req);
	return req;
}

static void dcerpc_srvsvc_NetServerTransportAddEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_srvsvc_NetServerTransportAddEx_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetServerTransportAddEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_srvsvc_NetServerTransportAddEx_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetServerTransportAddEx_recv(struct tevent_req *req,
						    TALLOC_CTX *mem_ctx,
						    WERROR *result)
{
	struct dcerpc_srvsvc_NetServerTransportAddEx_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetServerTransportAddEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetServerTransportAddEx(struct dcerpc_binding_handle *h,
					       TALLOC_CTX *mem_ctx,
					       const char *_server_unc /* [in] [unique,charset(UTF16)] */,
					       uint32_t _level /* [in]  */,
					       union srvsvc_NetTransportInfo _info /* [in] [switch_is(level)] */,
					       WERROR *result)
{
	struct srvsvc_NetServerTransportAddEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = _server_unc;
	r.in.level = _level;
	r.in.info = _info;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_srvsvc_NetServerTransportAddEx_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_srvsvc_NetServerSetServiceBitsEx_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetServerSetServiceBitsEx_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetServerSetServiceBitsEx_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct srvsvc_NetServerSetServiceBitsEx *r)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetServerSetServiceBitsEx_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetServerSetServiceBitsEx_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETSERVERSETSERVICEBITSEX, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetServerSetServiceBitsEx_r_done, req);

	return req;
}

static void dcerpc_srvsvc_NetServerSetServiceBitsEx_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetServerSetServiceBitsEx_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_srvsvc_NetServerSetServiceBitsEx_r_state *state =
		tevent_req_data(req,
		struct dcerpc_srvsvc_NetServerSetServiceBitsEx_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetServerSetServiceBitsEx_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct srvsvc_NetServerSetServiceBitsEx *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_srvsvc,
			NDR_SRVSVC_NETSERVERSETSERVICEBITSEX, mem_ctx, r);

	return status;
}

struct dcerpc_srvsvc_NetServerSetServiceBitsEx_state {
	struct srvsvc_NetServerSetServiceBitsEx orig;
	struct srvsvc_NetServerSetServiceBitsEx tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_srvsvc_NetServerSetServiceBitsEx_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_srvsvc_NetServerSetServiceBitsEx_send(TALLOC_CTX *mem_ctx,
								struct tevent_context *ev,
								struct dcerpc_binding_handle *h,
								const char *_server_unc /* [in] [unique,charset(UTF16)] */,
								const char *_emulated_server_unc /* [in] [unique,charset(UTF16)] */,
								const char *_transport /* [in] [unique,charset(UTF16)] */,
								uint32_t _servicebitsofinterest /* [in]  */,
								uint32_t _servicebits /* [in]  */,
								uint32_t _updateimmediately /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_srvsvc_NetServerSetServiceBitsEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_srvsvc_NetServerSetServiceBitsEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_unc = _server_unc;
	state->orig.in.emulated_server_unc = _emulated_server_unc;
	state->orig.in.transport = _transport;
	state->orig.in.servicebitsofinterest = _servicebitsofinterest;
	state->orig.in.servicebits = _servicebits;
	state->orig.in.updateimmediately = _updateimmediately;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_srvsvc_NetServerSetServiceBitsEx_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_srvsvc_NetServerSetServiceBitsEx_done, req);
	return req;
}

static void dcerpc_srvsvc_NetServerSetServiceBitsEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_srvsvc_NetServerSetServiceBitsEx_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetServerSetServiceBitsEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_srvsvc_NetServerSetServiceBitsEx_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_srvsvc_NetServerSetServiceBitsEx_recv(struct tevent_req *req,
						      TALLOC_CTX *mem_ctx,
						      WERROR *result)
{
	struct dcerpc_srvsvc_NetServerSetServiceBitsEx_state *state = tevent_req_data(
		req, struct dcerpc_srvsvc_NetServerSetServiceBitsEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_srvsvc_NetServerSetServiceBitsEx(struct dcerpc_binding_handle *h,
						 TALLOC_CTX *mem_ctx,
						 const char *_server_unc /* [in] [unique,charset(UTF16)] */,
						 const char *_emulated_server_unc /* [in] [unique,charset(UTF16)] */,
						 const char *_transport /* [in] [unique,charset(UTF16)] */,
						 uint32_t _servicebitsofinterest /* [in]  */,
						 uint32_t _servicebits /* [in]  */,
						 uint32_t _updateimmediately /* [in]  */,
						 WERROR *result)
{
	struct srvsvc_NetServerSetServiceBitsEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = _server_unc;
	r.in.emulated_server_unc = _emulated_server_unc;
	r.in.transport = _transport;
	r.in.servicebitsofinterest = _servicebitsofinterest;
	r.in.servicebits = _servicebits;
	r.in.updateimmediately = _updateimmediately;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_srvsvc_NetServerSetServiceBitsEx_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

