/* client functions auto-generated by pidl */

#include "includes.h"
#include <tevent.h>
#include "lib/util/tevent_ntstatus.h"
#include "autoconf/librpc/gen_ndr/ndr_frstrans.h"
#include "autoconf/librpc/gen_ndr/ndr_frstrans_c.h"

/* frstrans - client functions generated by pidl */

struct dcerpc_frstrans_CheckConnectivity_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_frstrans_CheckConnectivity_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_frstrans_CheckConnectivity_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct frstrans_CheckConnectivity *r)
{
	struct tevent_req *req;
	struct dcerpc_frstrans_CheckConnectivity_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_frstrans_CheckConnectivity_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_frstrans,
			NDR_FRSTRANS_CHECKCONNECTIVITY, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_frstrans_CheckConnectivity_r_done, req);

	return req;
}

static void dcerpc_frstrans_CheckConnectivity_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_frstrans_CheckConnectivity_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_frstrans_CheckConnectivity_r_state *state =
		tevent_req_data(req,
		struct dcerpc_frstrans_CheckConnectivity_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_frstrans_CheckConnectivity_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct frstrans_CheckConnectivity *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_frstrans,
			NDR_FRSTRANS_CHECKCONNECTIVITY, mem_ctx, r);

	return status;
}

struct dcerpc_frstrans_CheckConnectivity_state {
	struct frstrans_CheckConnectivity orig;
	struct frstrans_CheckConnectivity tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_frstrans_CheckConnectivity_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_frstrans_CheckConnectivity_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  struct GUID _replica_set_guid /* [in]  */,
							  struct GUID _connection_guid /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_frstrans_CheckConnectivity_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_frstrans_CheckConnectivity_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.replica_set_guid = _replica_set_guid;
	state->orig.in.connection_guid = _connection_guid;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_frstrans_CheckConnectivity_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_frstrans_CheckConnectivity_done, req);
	return req;
}

static void dcerpc_frstrans_CheckConnectivity_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_frstrans_CheckConnectivity_state *state = tevent_req_data(
		req, struct dcerpc_frstrans_CheckConnectivity_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_frstrans_CheckConnectivity_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_frstrans_CheckConnectivity_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result)
{
	struct dcerpc_frstrans_CheckConnectivity_state *state = tevent_req_data(
		req, struct dcerpc_frstrans_CheckConnectivity_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_frstrans_CheckConnectivity(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   struct GUID _replica_set_guid /* [in]  */,
					   struct GUID _connection_guid /* [in]  */,
					   WERROR *result)
{
	struct frstrans_CheckConnectivity r;
	NTSTATUS status;

	/* In parameters */
	r.in.replica_set_guid = _replica_set_guid;
	r.in.connection_guid = _connection_guid;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_frstrans_CheckConnectivity_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_frstrans_EstablishConnection_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_frstrans_EstablishConnection_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_frstrans_EstablishConnection_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct frstrans_EstablishConnection *r)
{
	struct tevent_req *req;
	struct dcerpc_frstrans_EstablishConnection_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_frstrans_EstablishConnection_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_frstrans,
			NDR_FRSTRANS_ESTABLISHCONNECTION, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_frstrans_EstablishConnection_r_done, req);

	return req;
}

static void dcerpc_frstrans_EstablishConnection_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_frstrans_EstablishConnection_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_frstrans_EstablishConnection_r_state *state =
		tevent_req_data(req,
		struct dcerpc_frstrans_EstablishConnection_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_frstrans_EstablishConnection_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct frstrans_EstablishConnection *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_frstrans,
			NDR_FRSTRANS_ESTABLISHCONNECTION, mem_ctx, r);

	return status;
}

struct dcerpc_frstrans_EstablishConnection_state {
	struct frstrans_EstablishConnection orig;
	struct frstrans_EstablishConnection tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_frstrans_EstablishConnection_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_frstrans_EstablishConnection_send(TALLOC_CTX *mem_ctx,
							    struct tevent_context *ev,
							    struct dcerpc_binding_handle *h,
							    struct GUID _replica_set_guid /* [in]  */,
							    struct GUID _connection_guid /* [in]  */,
							    enum frstrans_ProtocolVersion _downstream_protocol_version /* [in]  */,
							    uint32_t _downstream_flags /* [in]  */,
							    enum frstrans_ProtocolVersion *_upstream_protocol_version /* [out] [ref] */,
							    uint32_t *_upstream_flags /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_frstrans_EstablishConnection_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_frstrans_EstablishConnection_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.replica_set_guid = _replica_set_guid;
	state->orig.in.connection_guid = _connection_guid;
	state->orig.in.downstream_protocol_version = _downstream_protocol_version;
	state->orig.in.downstream_flags = _downstream_flags;

	/* Out parameters */
	state->orig.out.upstream_protocol_version = _upstream_protocol_version;
	state->orig.out.upstream_flags = _upstream_flags;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_frstrans_EstablishConnection_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_frstrans_EstablishConnection_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_frstrans_EstablishConnection_done, req);
	return req;
}

static void dcerpc_frstrans_EstablishConnection_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_frstrans_EstablishConnection_state *state = tevent_req_data(
		req, struct dcerpc_frstrans_EstablishConnection_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_frstrans_EstablishConnection_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.upstream_protocol_version = *state->tmp.out.upstream_protocol_version;
	*state->orig.out.upstream_flags = *state->tmp.out.upstream_flags;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_frstrans_EstablishConnection_recv(struct tevent_req *req,
						  TALLOC_CTX *mem_ctx,
						  WERROR *result)
{
	struct dcerpc_frstrans_EstablishConnection_state *state = tevent_req_data(
		req, struct dcerpc_frstrans_EstablishConnection_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_frstrans_EstablishConnection(struct dcerpc_binding_handle *h,
					     TALLOC_CTX *mem_ctx,
					     struct GUID _replica_set_guid /* [in]  */,
					     struct GUID _connection_guid /* [in]  */,
					     enum frstrans_ProtocolVersion _downstream_protocol_version /* [in]  */,
					     uint32_t _downstream_flags /* [in]  */,
					     enum frstrans_ProtocolVersion *_upstream_protocol_version /* [out] [ref] */,
					     uint32_t *_upstream_flags /* [out] [ref] */,
					     WERROR *result)
{
	struct frstrans_EstablishConnection r;
	NTSTATUS status;

	/* In parameters */
	r.in.replica_set_guid = _replica_set_guid;
	r.in.connection_guid = _connection_guid;
	r.in.downstream_protocol_version = _downstream_protocol_version;
	r.in.downstream_flags = _downstream_flags;

	/* Out parameters */
	r.out.upstream_protocol_version = _upstream_protocol_version;
	r.out.upstream_flags = _upstream_flags;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_frstrans_EstablishConnection_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_upstream_protocol_version = *r.out.upstream_protocol_version;
	*_upstream_flags = *r.out.upstream_flags;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_frstrans_EstablishSession_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_frstrans_EstablishSession_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_frstrans_EstablishSession_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct frstrans_EstablishSession *r)
{
	struct tevent_req *req;
	struct dcerpc_frstrans_EstablishSession_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_frstrans_EstablishSession_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_frstrans,
			NDR_FRSTRANS_ESTABLISHSESSION, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_frstrans_EstablishSession_r_done, req);

	return req;
}

static void dcerpc_frstrans_EstablishSession_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_frstrans_EstablishSession_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_frstrans_EstablishSession_r_state *state =
		tevent_req_data(req,
		struct dcerpc_frstrans_EstablishSession_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_frstrans_EstablishSession_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct frstrans_EstablishSession *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_frstrans,
			NDR_FRSTRANS_ESTABLISHSESSION, mem_ctx, r);

	return status;
}

struct dcerpc_frstrans_EstablishSession_state {
	struct frstrans_EstablishSession orig;
	struct frstrans_EstablishSession tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_frstrans_EstablishSession_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_frstrans_EstablishSession_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h,
							 struct GUID _connection_guid /* [in]  */,
							 struct GUID _content_set_guid /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_frstrans_EstablishSession_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_frstrans_EstablishSession_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.connection_guid = _connection_guid;
	state->orig.in.content_set_guid = _content_set_guid;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_frstrans_EstablishSession_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_frstrans_EstablishSession_done, req);
	return req;
}

static void dcerpc_frstrans_EstablishSession_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_frstrans_EstablishSession_state *state = tevent_req_data(
		req, struct dcerpc_frstrans_EstablishSession_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_frstrans_EstablishSession_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_frstrans_EstablishSession_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result)
{
	struct dcerpc_frstrans_EstablishSession_state *state = tevent_req_data(
		req, struct dcerpc_frstrans_EstablishSession_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_frstrans_EstablishSession(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  struct GUID _connection_guid /* [in]  */,
					  struct GUID _content_set_guid /* [in]  */,
					  WERROR *result)
{
	struct frstrans_EstablishSession r;
	NTSTATUS status;

	/* In parameters */
	r.in.connection_guid = _connection_guid;
	r.in.content_set_guid = _content_set_guid;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_frstrans_EstablishSession_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_frstrans_RequestUpdates_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_frstrans_RequestUpdates_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_frstrans_RequestUpdates_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct frstrans_RequestUpdates *r)
{
	struct tevent_req *req;
	struct dcerpc_frstrans_RequestUpdates_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_frstrans_RequestUpdates_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_frstrans,
			NDR_FRSTRANS_REQUESTUPDATES, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_frstrans_RequestUpdates_r_done, req);

	return req;
}

static void dcerpc_frstrans_RequestUpdates_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_frstrans_RequestUpdates_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_frstrans_RequestUpdates_r_state *state =
		tevent_req_data(req,
		struct dcerpc_frstrans_RequestUpdates_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_frstrans_RequestUpdates_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct frstrans_RequestUpdates *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_frstrans,
			NDR_FRSTRANS_REQUESTUPDATES, mem_ctx, r);

	return status;
}

struct dcerpc_frstrans_RequestUpdates_state {
	struct frstrans_RequestUpdates orig;
	struct frstrans_RequestUpdates tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_frstrans_RequestUpdates_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_frstrans_RequestUpdates_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       struct GUID _connection_guid /* [in]  */,
						       struct GUID _content_set_guid /* [in]  */,
						       uint32_t _credits_available /* [in] [range(0,256)] */,
						       uint32_t _hash_requested /* [in] [range(0,1)] */,
						       enum frstrans_UpdateRequestType _update_request_type /* [in] [range(0,2)] */,
						       uint32_t _version_vector_diff_count /* [in]  */,
						       struct frstrans_VersionVector *_version_vector_diff /* [in] [ref,size_is(version_vector_diff_count)] */,
						       struct frstrans_Update *_frs_update /* [out] [length_is(*update_count),size_is(credits_available),ref] */,
						       uint32_t *_update_count /* [out] [ref] */,
						       enum frstrans_UpdateStatus *_update_status /* [out] [ref] */,
						       struct GUID *_gvsn_db_guid /* [out] [ref] */,
						       uint64_t *_gvsn_version /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_frstrans_RequestUpdates_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_frstrans_RequestUpdates_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.connection_guid = _connection_guid;
	state->orig.in.content_set_guid = _content_set_guid;
	state->orig.in.credits_available = _credits_available;
	state->orig.in.hash_requested = _hash_requested;
	state->orig.in.update_request_type = _update_request_type;
	state->orig.in.version_vector_diff_count = _version_vector_diff_count;
	state->orig.in.version_vector_diff = _version_vector_diff;

	/* Out parameters */
	state->orig.out.frs_update = _frs_update;
	state->orig.out.update_count = _update_count;
	state->orig.out.update_status = _update_status;
	state->orig.out.gvsn_db_guid = _gvsn_db_guid;
	state->orig.out.gvsn_version = _gvsn_version;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_frstrans_RequestUpdates_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_frstrans_RequestUpdates_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_frstrans_RequestUpdates_done, req);
	return req;
}

static void dcerpc_frstrans_RequestUpdates_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_frstrans_RequestUpdates_state *state = tevent_req_data(
		req, struct dcerpc_frstrans_RequestUpdates_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_frstrans_RequestUpdates_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_frs_update;
		if ((*state->tmp.out.update_count) > (state->tmp.in.credits_available)) {
			tevent_req_nterror(req, NT_STATUS_INVALID_NETWORK_RESPONSE);
			return;
		}
		_copy_len_frs_update = *state->tmp.out.update_count;
		memcpy(state->orig.out.frs_update, state->tmp.out.frs_update, _copy_len_frs_update * sizeof(*state->orig.out.frs_update));
	}
	*state->orig.out.update_count = *state->tmp.out.update_count;
	*state->orig.out.update_status = *state->tmp.out.update_status;
	*state->orig.out.gvsn_db_guid = *state->tmp.out.gvsn_db_guid;
	*state->orig.out.gvsn_version = *state->tmp.out.gvsn_version;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_frstrans_RequestUpdates_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     WERROR *result)
{
	struct dcerpc_frstrans_RequestUpdates_state *state = tevent_req_data(
		req, struct dcerpc_frstrans_RequestUpdates_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_frstrans_RequestUpdates(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					struct GUID _connection_guid /* [in]  */,
					struct GUID _content_set_guid /* [in]  */,
					uint32_t _credits_available /* [in] [range(0,256)] */,
					uint32_t _hash_requested /* [in] [range(0,1)] */,
					enum frstrans_UpdateRequestType _update_request_type /* [in] [range(0,2)] */,
					uint32_t _version_vector_diff_count /* [in]  */,
					struct frstrans_VersionVector *_version_vector_diff /* [in] [ref,size_is(version_vector_diff_count)] */,
					struct frstrans_Update *_frs_update /* [out] [length_is(*update_count),size_is(credits_available),ref] */,
					uint32_t *_update_count /* [out] [ref] */,
					enum frstrans_UpdateStatus *_update_status /* [out] [ref] */,
					struct GUID *_gvsn_db_guid /* [out] [ref] */,
					uint64_t *_gvsn_version /* [out] [ref] */,
					WERROR *result)
{
	struct frstrans_RequestUpdates r;
	NTSTATUS status;

	/* In parameters */
	r.in.connection_guid = _connection_guid;
	r.in.content_set_guid = _content_set_guid;
	r.in.credits_available = _credits_available;
	r.in.hash_requested = _hash_requested;
	r.in.update_request_type = _update_request_type;
	r.in.version_vector_diff_count = _version_vector_diff_count;
	r.in.version_vector_diff = _version_vector_diff;

	/* Out parameters */
	r.out.frs_update = _frs_update;
	r.out.update_count = _update_count;
	r.out.update_status = _update_status;
	r.out.gvsn_db_guid = _gvsn_db_guid;
	r.out.gvsn_version = _gvsn_version;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_frstrans_RequestUpdates_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_frs_update;
		if ((*r.out.update_count) > (r.in.credits_available)) {
			return NT_STATUS_INVALID_NETWORK_RESPONSE;
		}
		_copy_len_frs_update = *r.out.update_count;
		memcpy(_frs_update, r.out.frs_update, _copy_len_frs_update * sizeof(*_frs_update));
	}
	*_update_count = *r.out.update_count;
	*_update_status = *r.out.update_status;
	*_gvsn_db_guid = *r.out.gvsn_db_guid;
	*_gvsn_version = *r.out.gvsn_version;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_frstrans_RequestVersionVector_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_frstrans_RequestVersionVector_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_frstrans_RequestVersionVector_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct frstrans_RequestVersionVector *r)
{
	struct tevent_req *req;
	struct dcerpc_frstrans_RequestVersionVector_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_frstrans_RequestVersionVector_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_frstrans,
			NDR_FRSTRANS_REQUESTVERSIONVECTOR, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_frstrans_RequestVersionVector_r_done, req);

	return req;
}

static void dcerpc_frstrans_RequestVersionVector_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_frstrans_RequestVersionVector_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_frstrans_RequestVersionVector_r_state *state =
		tevent_req_data(req,
		struct dcerpc_frstrans_RequestVersionVector_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_frstrans_RequestVersionVector_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct frstrans_RequestVersionVector *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_frstrans,
			NDR_FRSTRANS_REQUESTVERSIONVECTOR, mem_ctx, r);

	return status;
}

struct dcerpc_frstrans_RequestVersionVector_state {
	struct frstrans_RequestVersionVector orig;
	struct frstrans_RequestVersionVector tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_frstrans_RequestVersionVector_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_frstrans_RequestVersionVector_send(TALLOC_CTX *mem_ctx,
							     struct tevent_context *ev,
							     struct dcerpc_binding_handle *h,
							     uint32_t _sequence_number /* [in]  */,
							     struct GUID _connection_guid /* [in]  */,
							     struct GUID _content_set_guid /* [in]  */,
							     enum frstrans_VersionRequestType _request_type /* [in] [range(0,2)] */,
							     enum frstrans_VersionChangeType _change_type /* [in] [range(0,2)] */,
							     uint64_t _vv_generation /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_frstrans_RequestVersionVector_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_frstrans_RequestVersionVector_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.sequence_number = _sequence_number;
	state->orig.in.connection_guid = _connection_guid;
	state->orig.in.content_set_guid = _content_set_guid;
	state->orig.in.request_type = _request_type;
	state->orig.in.change_type = _change_type;
	state->orig.in.vv_generation = _vv_generation;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_frstrans_RequestVersionVector_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_frstrans_RequestVersionVector_done, req);
	return req;
}

static void dcerpc_frstrans_RequestVersionVector_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_frstrans_RequestVersionVector_state *state = tevent_req_data(
		req, struct dcerpc_frstrans_RequestVersionVector_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_frstrans_RequestVersionVector_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_frstrans_RequestVersionVector_recv(struct tevent_req *req,
						   TALLOC_CTX *mem_ctx,
						   WERROR *result)
{
	struct dcerpc_frstrans_RequestVersionVector_state *state = tevent_req_data(
		req, struct dcerpc_frstrans_RequestVersionVector_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_frstrans_RequestVersionVector(struct dcerpc_binding_handle *h,
					      TALLOC_CTX *mem_ctx,
					      uint32_t _sequence_number /* [in]  */,
					      struct GUID _connection_guid /* [in]  */,
					      struct GUID _content_set_guid /* [in]  */,
					      enum frstrans_VersionRequestType _request_type /* [in] [range(0,2)] */,
					      enum frstrans_VersionChangeType _change_type /* [in] [range(0,2)] */,
					      uint64_t _vv_generation /* [in]  */,
					      WERROR *result)
{
	struct frstrans_RequestVersionVector r;
	NTSTATUS status;

	/* In parameters */
	r.in.sequence_number = _sequence_number;
	r.in.connection_guid = _connection_guid;
	r.in.content_set_guid = _content_set_guid;
	r.in.request_type = _request_type;
	r.in.change_type = _change_type;
	r.in.vv_generation = _vv_generation;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_frstrans_RequestVersionVector_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_frstrans_AsyncPoll_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_frstrans_AsyncPoll_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_frstrans_AsyncPoll_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct frstrans_AsyncPoll *r)
{
	struct tevent_req *req;
	struct dcerpc_frstrans_AsyncPoll_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_frstrans_AsyncPoll_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_frstrans,
			NDR_FRSTRANS_ASYNCPOLL, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_frstrans_AsyncPoll_r_done, req);

	return req;
}

static void dcerpc_frstrans_AsyncPoll_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_frstrans_AsyncPoll_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_frstrans_AsyncPoll_r_state *state =
		tevent_req_data(req,
		struct dcerpc_frstrans_AsyncPoll_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_frstrans_AsyncPoll_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct frstrans_AsyncPoll *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_frstrans,
			NDR_FRSTRANS_ASYNCPOLL, mem_ctx, r);

	return status;
}

struct dcerpc_frstrans_AsyncPoll_state {
	struct frstrans_AsyncPoll orig;
	struct frstrans_AsyncPoll tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_frstrans_AsyncPoll_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_frstrans_AsyncPoll_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct dcerpc_binding_handle *h,
						  struct GUID _connection_guid /* [in]  */,
						  struct frstrans_AsyncResponseContext *_response /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_frstrans_AsyncPoll_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_frstrans_AsyncPoll_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.connection_guid = _connection_guid;

	/* Out parameters */
	state->orig.out.response = _response;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_frstrans_AsyncPoll_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_frstrans_AsyncPoll_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_frstrans_AsyncPoll_done, req);
	return req;
}

static void dcerpc_frstrans_AsyncPoll_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_frstrans_AsyncPoll_state *state = tevent_req_data(
		req, struct dcerpc_frstrans_AsyncPoll_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_frstrans_AsyncPoll_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.response = *state->tmp.out.response;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_frstrans_AsyncPoll_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					WERROR *result)
{
	struct dcerpc_frstrans_AsyncPoll_state *state = tevent_req_data(
		req, struct dcerpc_frstrans_AsyncPoll_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_frstrans_AsyncPoll(struct dcerpc_binding_handle *h,
				   TALLOC_CTX *mem_ctx,
				   struct GUID _connection_guid /* [in]  */,
				   struct frstrans_AsyncResponseContext *_response /* [out] [ref] */,
				   WERROR *result)
{
	struct frstrans_AsyncPoll r;
	NTSTATUS status;

	/* In parameters */
	r.in.connection_guid = _connection_guid;

	/* Out parameters */
	r.out.response = _response;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_frstrans_AsyncPoll_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_response = *r.out.response;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_frstrans_InitializeFileTransferAsync_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_frstrans_InitializeFileTransferAsync_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_frstrans_InitializeFileTransferAsync_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct frstrans_InitializeFileTransferAsync *r)
{
	struct tevent_req *req;
	struct dcerpc_frstrans_InitializeFileTransferAsync_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_frstrans_InitializeFileTransferAsync_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_frstrans,
			NDR_FRSTRANS_INITIALIZEFILETRANSFERASYNC, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_frstrans_InitializeFileTransferAsync_r_done, req);

	return req;
}

static void dcerpc_frstrans_InitializeFileTransferAsync_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_frstrans_InitializeFileTransferAsync_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_frstrans_InitializeFileTransferAsync_r_state *state =
		tevent_req_data(req,
		struct dcerpc_frstrans_InitializeFileTransferAsync_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_frstrans_InitializeFileTransferAsync_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct frstrans_InitializeFileTransferAsync *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_frstrans,
			NDR_FRSTRANS_INITIALIZEFILETRANSFERASYNC, mem_ctx, r);

	return status;
}

struct dcerpc_frstrans_InitializeFileTransferAsync_state {
	struct frstrans_InitializeFileTransferAsync orig;
	struct frstrans_InitializeFileTransferAsync tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_frstrans_InitializeFileTransferAsync_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_frstrans_InitializeFileTransferAsync_send(TALLOC_CTX *mem_ctx,
								    struct tevent_context *ev,
								    struct dcerpc_binding_handle *h,
								    struct GUID _connection_guid /* [in]  */,
								    struct frstrans_Update *_frs_update /* [in,out] [ref] */,
								    uint32_t _rdc_desired /* [in] [range(0,1)] */,
								    enum frstrans_RequestedStagingPolicy *_staging_policy /* [in,out] [ref] */,
								    struct policy_handle *_server_context /* [out] [ref] */,
								    struct frstrans_RdcFileInfo **_rdc_file_info /* [out] [ref] */,
								    uint8_t *_data_buffer /* [out] [size_is(buffer_size),ref,length_is(*size_read)] */,
								    uint32_t _buffer_size /* [in] [range(0,262144)] */,
								    uint32_t *_size_read /* [out] [ref] */,
								    uint32_t *_is_end_of_file /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_frstrans_InitializeFileTransferAsync_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_frstrans_InitializeFileTransferAsync_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.connection_guid = _connection_guid;
	state->orig.in.frs_update = _frs_update;
	state->orig.in.rdc_desired = _rdc_desired;
	state->orig.in.staging_policy = _staging_policy;
	state->orig.in.buffer_size = _buffer_size;

	/* Out parameters */
	state->orig.out.frs_update = _frs_update;
	state->orig.out.staging_policy = _staging_policy;
	state->orig.out.server_context = _server_context;
	state->orig.out.rdc_file_info = _rdc_file_info;
	state->orig.out.data_buffer = _data_buffer;
	state->orig.out.size_read = _size_read;
	state->orig.out.is_end_of_file = _is_end_of_file;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_frstrans_InitializeFileTransferAsync_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_frstrans_InitializeFileTransferAsync_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_frstrans_InitializeFileTransferAsync_done, req);
	return req;
}

static void dcerpc_frstrans_InitializeFileTransferAsync_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_frstrans_InitializeFileTransferAsync_state *state = tevent_req_data(
		req, struct dcerpc_frstrans_InitializeFileTransferAsync_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_frstrans_InitializeFileTransferAsync_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.frs_update = *state->tmp.out.frs_update;
	*state->orig.out.staging_policy = *state->tmp.out.staging_policy;
	*state->orig.out.server_context = *state->tmp.out.server_context;
	*state->orig.out.rdc_file_info = *state->tmp.out.rdc_file_info;
	{
		size_t _copy_len_data_buffer;
		if ((*state->tmp.out.size_read) > (state->tmp.in.buffer_size)) {
			tevent_req_nterror(req, NT_STATUS_INVALID_NETWORK_RESPONSE);
			return;
		}
		_copy_len_data_buffer = *state->tmp.out.size_read;
		memcpy(state->orig.out.data_buffer, state->tmp.out.data_buffer, _copy_len_data_buffer * sizeof(*state->orig.out.data_buffer));
	}
	*state->orig.out.size_read = *state->tmp.out.size_read;
	*state->orig.out.is_end_of_file = *state->tmp.out.is_end_of_file;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_frstrans_InitializeFileTransferAsync_recv(struct tevent_req *req,
							  TALLOC_CTX *mem_ctx,
							  WERROR *result)
{
	struct dcerpc_frstrans_InitializeFileTransferAsync_state *state = tevent_req_data(
		req, struct dcerpc_frstrans_InitializeFileTransferAsync_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_frstrans_InitializeFileTransferAsync(struct dcerpc_binding_handle *h,
						     TALLOC_CTX *mem_ctx,
						     struct GUID _connection_guid /* [in]  */,
						     struct frstrans_Update *_frs_update /* [in,out] [ref] */,
						     uint32_t _rdc_desired /* [in] [range(0,1)] */,
						     enum frstrans_RequestedStagingPolicy *_staging_policy /* [in,out] [ref] */,
						     struct policy_handle *_server_context /* [out] [ref] */,
						     struct frstrans_RdcFileInfo **_rdc_file_info /* [out] [ref] */,
						     uint8_t *_data_buffer /* [out] [size_is(buffer_size),ref,length_is(*size_read)] */,
						     uint32_t _buffer_size /* [in] [range(0,262144)] */,
						     uint32_t *_size_read /* [out] [ref] */,
						     uint32_t *_is_end_of_file /* [out] [ref] */,
						     WERROR *result)
{
	struct frstrans_InitializeFileTransferAsync r;
	NTSTATUS status;

	/* In parameters */
	r.in.connection_guid = _connection_guid;
	r.in.frs_update = _frs_update;
	r.in.rdc_desired = _rdc_desired;
	r.in.staging_policy = _staging_policy;
	r.in.buffer_size = _buffer_size;

	/* Out parameters */
	r.out.frs_update = _frs_update;
	r.out.staging_policy = _staging_policy;
	r.out.server_context = _server_context;
	r.out.rdc_file_info = _rdc_file_info;
	r.out.data_buffer = _data_buffer;
	r.out.size_read = _size_read;
	r.out.is_end_of_file = _is_end_of_file;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_frstrans_InitializeFileTransferAsync_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_frs_update = *r.out.frs_update;
	*_staging_policy = *r.out.staging_policy;
	*_server_context = *r.out.server_context;
	*_rdc_file_info = *r.out.rdc_file_info;
	{
		size_t _copy_len_data_buffer;
		if ((*r.out.size_read) > (r.in.buffer_size)) {
			return NT_STATUS_INVALID_NETWORK_RESPONSE;
		}
		_copy_len_data_buffer = *r.out.size_read;
		memcpy(_data_buffer, r.out.data_buffer, _copy_len_data_buffer * sizeof(*_data_buffer));
	}
	*_size_read = *r.out.size_read;
	*_is_end_of_file = *r.out.is_end_of_file;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

