/* client functions auto-generated by pidl */

#include "includes.h"
#include <tevent.h>
#include "lib/util/tevent_ntstatus.h"
#include "autoconf/librpc/gen_ndr/ndr_svcctl.h"
#include "autoconf/librpc/gen_ndr/ndr_svcctl_c.h"

/* svcctl - client functions generated by pidl */

struct dcerpc_svcctl_CloseServiceHandle_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_CloseServiceHandle_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_CloseServiceHandle_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_CloseServiceHandle *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_CloseServiceHandle_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_CloseServiceHandle_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_CLOSESERVICEHANDLE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_CloseServiceHandle_r_done, req);

	return req;
}

static void dcerpc_svcctl_CloseServiceHandle_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_CloseServiceHandle_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_CloseServiceHandle_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_CloseServiceHandle_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_CloseServiceHandle_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_CloseServiceHandle *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_CLOSESERVICEHANDLE, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_CloseServiceHandle_state {
	struct svcctl_CloseServiceHandle orig;
	struct svcctl_CloseServiceHandle tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_CloseServiceHandle_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_CloseServiceHandle_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h,
							 struct policy_handle *_handle /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_CloseServiceHandle_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_CloseServiceHandle_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;

	/* Out parameters */
	state->orig.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_CloseServiceHandle_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_CloseServiceHandle_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_CloseServiceHandle_done, req);
	return req;
}

static void dcerpc_svcctl_CloseServiceHandle_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_CloseServiceHandle_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_CloseServiceHandle_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_CloseServiceHandle_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_CloseServiceHandle_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result)
{
	struct dcerpc_svcctl_CloseServiceHandle_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_CloseServiceHandle_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_CloseServiceHandle(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  struct policy_handle *_handle /* [in,out] [ref] */,
					  WERROR *result)
{
	struct svcctl_CloseServiceHandle r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;

	/* Out parameters */
	r.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_CloseServiceHandle_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_handle = *r.out.handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_ControlService_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_ControlService_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_ControlService_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_ControlService *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_ControlService_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_ControlService_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_CONTROLSERVICE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_ControlService_r_done, req);

	return req;
}

static void dcerpc_svcctl_ControlService_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_ControlService_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_ControlService_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_ControlService_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_ControlService_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_ControlService *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_CONTROLSERVICE, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_ControlService_state {
	struct svcctl_ControlService orig;
	struct svcctl_ControlService tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_ControlService_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_ControlService_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     struct policy_handle *_handle /* [in] [ref] */,
						     enum SERVICE_CONTROL _control /* [in]  */,
						     struct SERVICE_STATUS *_service_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_ControlService_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_ControlService_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.control = _control;

	/* Out parameters */
	state->orig.out.service_status = _service_status;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_ControlService_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_ControlService_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_ControlService_done, req);
	return req;
}

static void dcerpc_svcctl_ControlService_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_ControlService_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_ControlService_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_ControlService_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.service_status = *state->tmp.out.service_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_ControlService_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_svcctl_ControlService_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_ControlService_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_ControlService(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *_handle /* [in] [ref] */,
				      enum SERVICE_CONTROL _control /* [in]  */,
				      struct SERVICE_STATUS *_service_status /* [out] [ref] */,
				      WERROR *result)
{
	struct svcctl_ControlService r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.control = _control;

	/* Out parameters */
	r.out.service_status = _service_status;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_ControlService_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_service_status = *r.out.service_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_DeleteService_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_DeleteService_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_DeleteService_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_DeleteService *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_DeleteService_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_DeleteService_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_DELETESERVICE, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_DeleteService_r_done, req);

	return req;
}

static void dcerpc_svcctl_DeleteService_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_DeleteService_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_DeleteService_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_DeleteService_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_DeleteService_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_DeleteService *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_DELETESERVICE, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_DeleteService_state {
	struct svcctl_DeleteService orig;
	struct svcctl_DeleteService tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_DeleteService_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_DeleteService_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    struct policy_handle *_handle /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_DeleteService_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_DeleteService_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_DeleteService_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_DeleteService_done, req);
	return req;
}

static void dcerpc_svcctl_DeleteService_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_DeleteService_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_DeleteService_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_DeleteService_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_DeleteService_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct dcerpc_svcctl_DeleteService_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_DeleteService_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_DeleteService(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle *_handle /* [in] [ref] */,
				     WERROR *result)
{
	struct svcctl_DeleteService r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_DeleteService_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_LockServiceDatabase_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_LockServiceDatabase_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_LockServiceDatabase_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_LockServiceDatabase *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_LockServiceDatabase_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_LockServiceDatabase_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_LOCKSERVICEDATABASE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_LockServiceDatabase_r_done, req);

	return req;
}

static void dcerpc_svcctl_LockServiceDatabase_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_LockServiceDatabase_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_LockServiceDatabase_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_LockServiceDatabase_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_LockServiceDatabase_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_LockServiceDatabase *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_LOCKSERVICEDATABASE, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_LockServiceDatabase_state {
	struct svcctl_LockServiceDatabase orig;
	struct svcctl_LockServiceDatabase tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_LockServiceDatabase_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_LockServiceDatabase_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  struct policy_handle *_handle /* [in] [ref] */,
							  struct policy_handle *_lock /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_LockServiceDatabase_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_LockServiceDatabase_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;

	/* Out parameters */
	state->orig.out.lock = _lock;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_LockServiceDatabase_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_LockServiceDatabase_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_LockServiceDatabase_done, req);
	return req;
}

static void dcerpc_svcctl_LockServiceDatabase_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_LockServiceDatabase_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_LockServiceDatabase_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_LockServiceDatabase_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.lock = *state->tmp.out.lock;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_LockServiceDatabase_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result)
{
	struct dcerpc_svcctl_LockServiceDatabase_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_LockServiceDatabase_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_LockServiceDatabase(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle *_handle /* [in] [ref] */,
					   struct policy_handle *_lock /* [out] [ref] */,
					   WERROR *result)
{
	struct svcctl_LockServiceDatabase r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;

	/* Out parameters */
	r.out.lock = _lock;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_LockServiceDatabase_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_lock = *r.out.lock;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_QueryServiceObjectSecurity_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_QueryServiceObjectSecurity_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_QueryServiceObjectSecurity_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_QueryServiceObjectSecurity *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_QueryServiceObjectSecurity_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_QueryServiceObjectSecurity_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_QUERYSERVICEOBJECTSECURITY, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_QueryServiceObjectSecurity_r_done, req);

	return req;
}

static void dcerpc_svcctl_QueryServiceObjectSecurity_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_QueryServiceObjectSecurity_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_QueryServiceObjectSecurity_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_QueryServiceObjectSecurity_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_QueryServiceObjectSecurity_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_QueryServiceObjectSecurity *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_QUERYSERVICEOBJECTSECURITY, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_QueryServiceObjectSecurity_state {
	struct svcctl_QueryServiceObjectSecurity orig;
	struct svcctl_QueryServiceObjectSecurity tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_QueryServiceObjectSecurity_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_QueryServiceObjectSecurity_send(TALLOC_CTX *mem_ctx,
								 struct tevent_context *ev,
								 struct dcerpc_binding_handle *h,
								 struct policy_handle *_handle /* [in] [ref] */,
								 uint32_t _security_flags /* [in]  */,
								 uint8_t *_buffer /* [out] [size_is(offered),ref] */,
								 uint32_t _offered /* [in] [range(0,0x40000)] */,
								 uint32_t *_needed /* [out] [ref,range(0,0x40000)] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_QueryServiceObjectSecurity_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_QueryServiceObjectSecurity_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.security_flags = _security_flags;
	state->orig.in.offered = _offered;

	/* Out parameters */
	state->orig.out.buffer = _buffer;
	state->orig.out.needed = _needed;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_QueryServiceObjectSecurity_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_QueryServiceObjectSecurity_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_QueryServiceObjectSecurity_done, req);
	return req;
}

static void dcerpc_svcctl_QueryServiceObjectSecurity_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_QueryServiceObjectSecurity_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_QueryServiceObjectSecurity_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_QueryServiceObjectSecurity_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_buffer;
		_copy_len_buffer = state->tmp.in.offered;
		memcpy(state->orig.out.buffer, state->tmp.out.buffer, _copy_len_buffer * sizeof(*state->orig.out.buffer));
	}
	*state->orig.out.needed = *state->tmp.out.needed;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_QueryServiceObjectSecurity_recv(struct tevent_req *req,
						       TALLOC_CTX *mem_ctx,
						       WERROR *result)
{
	struct dcerpc_svcctl_QueryServiceObjectSecurity_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_QueryServiceObjectSecurity_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_QueryServiceObjectSecurity(struct dcerpc_binding_handle *h,
						  TALLOC_CTX *mem_ctx,
						  struct policy_handle *_handle /* [in] [ref] */,
						  uint32_t _security_flags /* [in]  */,
						  uint8_t *_buffer /* [out] [size_is(offered),ref] */,
						  uint32_t _offered /* [in] [range(0,0x40000)] */,
						  uint32_t *_needed /* [out] [ref,range(0,0x40000)] */,
						  WERROR *result)
{
	struct svcctl_QueryServiceObjectSecurity r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.security_flags = _security_flags;
	r.in.offered = _offered;

	/* Out parameters */
	r.out.buffer = _buffer;
	r.out.needed = _needed;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_QueryServiceObjectSecurity_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_buffer;
		_copy_len_buffer = r.in.offered;
		memcpy(_buffer, r.out.buffer, _copy_len_buffer * sizeof(*_buffer));
	}
	*_needed = *r.out.needed;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_SetServiceObjectSecurity_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_SetServiceObjectSecurity_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_SetServiceObjectSecurity_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_SetServiceObjectSecurity *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_SetServiceObjectSecurity_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_SetServiceObjectSecurity_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_SETSERVICEOBJECTSECURITY, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_SetServiceObjectSecurity_r_done, req);

	return req;
}

static void dcerpc_svcctl_SetServiceObjectSecurity_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_SetServiceObjectSecurity_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_SetServiceObjectSecurity_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_SetServiceObjectSecurity_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_SetServiceObjectSecurity_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_SetServiceObjectSecurity *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_SETSERVICEOBJECTSECURITY, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_SetServiceObjectSecurity_state {
	struct svcctl_SetServiceObjectSecurity orig;
	struct svcctl_SetServiceObjectSecurity tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_SetServiceObjectSecurity_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_SetServiceObjectSecurity_send(TALLOC_CTX *mem_ctx,
							       struct tevent_context *ev,
							       struct dcerpc_binding_handle *h,
							       struct policy_handle *_handle /* [in] [ref] */,
							       uint32_t _security_flags /* [in]  */,
							       uint8_t *_buffer /* [in] [size_is(offered),ref] */,
							       uint32_t _offered /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_SetServiceObjectSecurity_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_SetServiceObjectSecurity_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.security_flags = _security_flags;
	state->orig.in.buffer = _buffer;
	state->orig.in.offered = _offered;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_SetServiceObjectSecurity_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_SetServiceObjectSecurity_done, req);
	return req;
}

static void dcerpc_svcctl_SetServiceObjectSecurity_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_SetServiceObjectSecurity_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_SetServiceObjectSecurity_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_SetServiceObjectSecurity_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_SetServiceObjectSecurity_recv(struct tevent_req *req,
						     TALLOC_CTX *mem_ctx,
						     WERROR *result)
{
	struct dcerpc_svcctl_SetServiceObjectSecurity_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_SetServiceObjectSecurity_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_SetServiceObjectSecurity(struct dcerpc_binding_handle *h,
						TALLOC_CTX *mem_ctx,
						struct policy_handle *_handle /* [in] [ref] */,
						uint32_t _security_flags /* [in]  */,
						uint8_t *_buffer /* [in] [size_is(offered),ref] */,
						uint32_t _offered /* [in]  */,
						WERROR *result)
{
	struct svcctl_SetServiceObjectSecurity r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.security_flags = _security_flags;
	r.in.buffer = _buffer;
	r.in.offered = _offered;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_SetServiceObjectSecurity_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_QueryServiceStatus_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_QueryServiceStatus_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_QueryServiceStatus_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_QueryServiceStatus *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_QueryServiceStatus_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_QueryServiceStatus_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_QUERYSERVICESTATUS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_QueryServiceStatus_r_done, req);

	return req;
}

static void dcerpc_svcctl_QueryServiceStatus_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_QueryServiceStatus_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_QueryServiceStatus_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_QueryServiceStatus_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_QueryServiceStatus_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_QueryServiceStatus *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_QUERYSERVICESTATUS, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_QueryServiceStatus_state {
	struct svcctl_QueryServiceStatus orig;
	struct svcctl_QueryServiceStatus tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_QueryServiceStatus_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_QueryServiceStatus_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h,
							 struct policy_handle *_handle /* [in] [ref] */,
							 struct SERVICE_STATUS *_service_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_QueryServiceStatus_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_QueryServiceStatus_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;

	/* Out parameters */
	state->orig.out.service_status = _service_status;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_QueryServiceStatus_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_QueryServiceStatus_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_QueryServiceStatus_done, req);
	return req;
}

static void dcerpc_svcctl_QueryServiceStatus_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_QueryServiceStatus_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_QueryServiceStatus_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_QueryServiceStatus_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.service_status = *state->tmp.out.service_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_QueryServiceStatus_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result)
{
	struct dcerpc_svcctl_QueryServiceStatus_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_QueryServiceStatus_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_QueryServiceStatus(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  struct policy_handle *_handle /* [in] [ref] */,
					  struct SERVICE_STATUS *_service_status /* [out] [ref] */,
					  WERROR *result)
{
	struct svcctl_QueryServiceStatus r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;

	/* Out parameters */
	r.out.service_status = _service_status;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_QueryServiceStatus_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_service_status = *r.out.service_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_UnlockServiceDatabase_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_UnlockServiceDatabase_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_UnlockServiceDatabase_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_UnlockServiceDatabase *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_UnlockServiceDatabase_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_UnlockServiceDatabase_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_UNLOCKSERVICEDATABASE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_UnlockServiceDatabase_r_done, req);

	return req;
}

static void dcerpc_svcctl_UnlockServiceDatabase_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_UnlockServiceDatabase_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_UnlockServiceDatabase_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_UnlockServiceDatabase_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_UnlockServiceDatabase_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_UnlockServiceDatabase *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_UNLOCKSERVICEDATABASE, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_UnlockServiceDatabase_state {
	struct svcctl_UnlockServiceDatabase orig;
	struct svcctl_UnlockServiceDatabase tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_UnlockServiceDatabase_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_UnlockServiceDatabase_send(TALLOC_CTX *mem_ctx,
							    struct tevent_context *ev,
							    struct dcerpc_binding_handle *h,
							    struct policy_handle *_lock /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_UnlockServiceDatabase_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_UnlockServiceDatabase_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.lock = _lock;

	/* Out parameters */
	state->orig.out.lock = _lock;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_UnlockServiceDatabase_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_UnlockServiceDatabase_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_UnlockServiceDatabase_done, req);
	return req;
}

static void dcerpc_svcctl_UnlockServiceDatabase_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_UnlockServiceDatabase_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_UnlockServiceDatabase_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_UnlockServiceDatabase_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.lock = *state->tmp.out.lock;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_UnlockServiceDatabase_recv(struct tevent_req *req,
						  TALLOC_CTX *mem_ctx,
						  WERROR *result)
{
	struct dcerpc_svcctl_UnlockServiceDatabase_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_UnlockServiceDatabase_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_UnlockServiceDatabase(struct dcerpc_binding_handle *h,
					     TALLOC_CTX *mem_ctx,
					     struct policy_handle *_lock /* [in,out] [ref] */,
					     WERROR *result)
{
	struct svcctl_UnlockServiceDatabase r;
	NTSTATUS status;

	/* In parameters */
	r.in.lock = _lock;

	/* Out parameters */
	r.out.lock = _lock;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_UnlockServiceDatabase_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_lock = *r.out.lock;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_SCSetServiceBitsW_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_SCSetServiceBitsW_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_SCSetServiceBitsW_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_SCSetServiceBitsW *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_SCSetServiceBitsW_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_SCSetServiceBitsW_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_SCSETSERVICEBITSW, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_SCSetServiceBitsW_r_done, req);

	return req;
}

static void dcerpc_svcctl_SCSetServiceBitsW_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_SCSetServiceBitsW_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_SCSetServiceBitsW_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_SCSetServiceBitsW_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_SCSetServiceBitsW_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_SCSetServiceBitsW *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_SCSETSERVICEBITSW, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_SCSetServiceBitsW_state {
	struct svcctl_SCSetServiceBitsW orig;
	struct svcctl_SCSetServiceBitsW tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_SCSetServiceBitsW_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_SCSetServiceBitsW_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							struct policy_handle *_handle /* [in] [ref] */,
							uint32_t _bits /* [in]  */,
							uint32_t _bitson /* [in]  */,
							uint32_t _immediate /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_SCSetServiceBitsW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_SCSetServiceBitsW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.bits = _bits;
	state->orig.in.bitson = _bitson;
	state->orig.in.immediate = _immediate;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_SCSetServiceBitsW_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_SCSetServiceBitsW_done, req);
	return req;
}

static void dcerpc_svcctl_SCSetServiceBitsW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_SCSetServiceBitsW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_SCSetServiceBitsW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_SCSetServiceBitsW_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_SCSetServiceBitsW_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      WERROR *result)
{
	struct dcerpc_svcctl_SCSetServiceBitsW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_SCSetServiceBitsW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_SCSetServiceBitsW(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle *_handle /* [in] [ref] */,
					 uint32_t _bits /* [in]  */,
					 uint32_t _bitson /* [in]  */,
					 uint32_t _immediate /* [in]  */,
					 WERROR *result)
{
	struct svcctl_SCSetServiceBitsW r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.bits = _bits;
	r.in.bitson = _bitson;
	r.in.immediate = _immediate;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_SCSetServiceBitsW_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_ChangeServiceConfigW_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_ChangeServiceConfigW_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_ChangeServiceConfigW_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_ChangeServiceConfigW *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_ChangeServiceConfigW_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_ChangeServiceConfigW_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_CHANGESERVICECONFIGW, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_ChangeServiceConfigW_r_done, req);

	return req;
}

static void dcerpc_svcctl_ChangeServiceConfigW_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_ChangeServiceConfigW_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_ChangeServiceConfigW_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_ChangeServiceConfigW_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_ChangeServiceConfigW_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_ChangeServiceConfigW *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_CHANGESERVICECONFIGW, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_ChangeServiceConfigW_state {
	struct svcctl_ChangeServiceConfigW orig;
	struct svcctl_ChangeServiceConfigW tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_ChangeServiceConfigW_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_ChangeServiceConfigW_send(TALLOC_CTX *mem_ctx,
							   struct tevent_context *ev,
							   struct dcerpc_binding_handle *h,
							   struct policy_handle *_handle /* [in] [ref] */,
							   uint32_t _type /* [in]  */,
							   enum svcctl_StartType _start_type /* [in]  */,
							   enum svcctl_ErrorControl _error_control /* [in]  */,
							   const char *_binary_path /* [in] [unique,charset(UTF16)] */,
							   const char *_load_order_group /* [in] [unique,charset(UTF16)] */,
							   uint32_t *_tag_id /* [out] [ref] */,
							   const char *_dependencies /* [in] [charset(UTF16),unique] */,
							   const char *_service_start_name /* [in] [unique,charset(UTF16)] */,
							   const char *_password /* [in] [charset(UTF16),unique] */,
							   const char *_display_name /* [in] [unique,charset(UTF16)] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_ChangeServiceConfigW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_ChangeServiceConfigW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.type = _type;
	state->orig.in.start_type = _start_type;
	state->orig.in.error_control = _error_control;
	state->orig.in.binary_path = _binary_path;
	state->orig.in.load_order_group = _load_order_group;
	state->orig.in.dependencies = _dependencies;
	state->orig.in.service_start_name = _service_start_name;
	state->orig.in.password = _password;
	state->orig.in.display_name = _display_name;

	/* Out parameters */
	state->orig.out.tag_id = _tag_id;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_ChangeServiceConfigW_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_ChangeServiceConfigW_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_ChangeServiceConfigW_done, req);
	return req;
}

static void dcerpc_svcctl_ChangeServiceConfigW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_ChangeServiceConfigW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_ChangeServiceConfigW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_ChangeServiceConfigW_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.tag_id = *state->tmp.out.tag_id;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_ChangeServiceConfigW_recv(struct tevent_req *req,
						 TALLOC_CTX *mem_ctx,
						 WERROR *result)
{
	struct dcerpc_svcctl_ChangeServiceConfigW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_ChangeServiceConfigW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_ChangeServiceConfigW(struct dcerpc_binding_handle *h,
					    TALLOC_CTX *mem_ctx,
					    struct policy_handle *_handle /* [in] [ref] */,
					    uint32_t _type /* [in]  */,
					    enum svcctl_StartType _start_type /* [in]  */,
					    enum svcctl_ErrorControl _error_control /* [in]  */,
					    const char *_binary_path /* [in] [unique,charset(UTF16)] */,
					    const char *_load_order_group /* [in] [unique,charset(UTF16)] */,
					    uint32_t *_tag_id /* [out] [ref] */,
					    const char *_dependencies /* [in] [charset(UTF16),unique] */,
					    const char *_service_start_name /* [in] [unique,charset(UTF16)] */,
					    const char *_password /* [in] [charset(UTF16),unique] */,
					    const char *_display_name /* [in] [unique,charset(UTF16)] */,
					    WERROR *result)
{
	struct svcctl_ChangeServiceConfigW r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.type = _type;
	r.in.start_type = _start_type;
	r.in.error_control = _error_control;
	r.in.binary_path = _binary_path;
	r.in.load_order_group = _load_order_group;
	r.in.dependencies = _dependencies;
	r.in.service_start_name = _service_start_name;
	r.in.password = _password;
	r.in.display_name = _display_name;

	/* Out parameters */
	r.out.tag_id = _tag_id;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_ChangeServiceConfigW_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_tag_id = *r.out.tag_id;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_CreateServiceW_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_CreateServiceW_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_CreateServiceW_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_CreateServiceW *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_CreateServiceW_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_CreateServiceW_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_CREATESERVICEW, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_CreateServiceW_r_done, req);

	return req;
}

static void dcerpc_svcctl_CreateServiceW_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_CreateServiceW_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_CreateServiceW_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_CreateServiceW_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_CreateServiceW_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_CreateServiceW *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_CREATESERVICEW, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_CreateServiceW_state {
	struct svcctl_CreateServiceW orig;
	struct svcctl_CreateServiceW tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_CreateServiceW_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_CreateServiceW_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     struct policy_handle *_scmanager_handle /* [in] [ref] */,
						     const char *_ServiceName /* [in] [charset(UTF16)] */,
						     const char *_DisplayName /* [in] [charset(UTF16),unique] */,
						     uint32_t _desired_access /* [in]  */,
						     uint32_t _type /* [in]  */,
						     enum svcctl_StartType _start_type /* [in]  */,
						     enum svcctl_ErrorControl _error_control /* [in]  */,
						     const char *_binary_path /* [in] [charset(UTF16)] */,
						     const char *_LoadOrderGroupKey /* [in] [charset(UTF16),unique] */,
						     uint32_t *_TagId /* [in,out] [unique] */,
						     uint8_t *_dependencies /* [in] [size_is(dependencies_size),unique] */,
						     uint32_t _dependencies_size /* [in]  */,
						     const char *_service_start_name /* [in] [charset(UTF16),unique] */,
						     uint8_t *_password /* [in] [unique,size_is(password_size)] */,
						     uint32_t _password_size /* [in]  */,
						     struct policy_handle *_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_CreateServiceW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_CreateServiceW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.scmanager_handle = _scmanager_handle;
	state->orig.in.ServiceName = _ServiceName;
	state->orig.in.DisplayName = _DisplayName;
	state->orig.in.desired_access = _desired_access;
	state->orig.in.type = _type;
	state->orig.in.start_type = _start_type;
	state->orig.in.error_control = _error_control;
	state->orig.in.binary_path = _binary_path;
	state->orig.in.LoadOrderGroupKey = _LoadOrderGroupKey;
	state->orig.in.TagId = _TagId;
	state->orig.in.dependencies = _dependencies;
	state->orig.in.dependencies_size = _dependencies_size;
	state->orig.in.service_start_name = _service_start_name;
	state->orig.in.password = _password;
	state->orig.in.password_size = _password_size;

	/* Out parameters */
	state->orig.out.TagId = _TagId;
	state->orig.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_CreateServiceW_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_CreateServiceW_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_CreateServiceW_done, req);
	return req;
}

static void dcerpc_svcctl_CreateServiceW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_CreateServiceW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_CreateServiceW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_CreateServiceW_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.TagId && state->tmp.out.TagId) {
		*state->orig.out.TagId = *state->tmp.out.TagId;
	}
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_CreateServiceW_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_svcctl_CreateServiceW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_CreateServiceW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_CreateServiceW(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *_scmanager_handle /* [in] [ref] */,
				      const char *_ServiceName /* [in] [charset(UTF16)] */,
				      const char *_DisplayName /* [in] [charset(UTF16),unique] */,
				      uint32_t _desired_access /* [in]  */,
				      uint32_t _type /* [in]  */,
				      enum svcctl_StartType _start_type /* [in]  */,
				      enum svcctl_ErrorControl _error_control /* [in]  */,
				      const char *_binary_path /* [in] [charset(UTF16)] */,
				      const char *_LoadOrderGroupKey /* [in] [charset(UTF16),unique] */,
				      uint32_t *_TagId /* [in,out] [unique] */,
				      uint8_t *_dependencies /* [in] [size_is(dependencies_size),unique] */,
				      uint32_t _dependencies_size /* [in]  */,
				      const char *_service_start_name /* [in] [charset(UTF16),unique] */,
				      uint8_t *_password /* [in] [unique,size_is(password_size)] */,
				      uint32_t _password_size /* [in]  */,
				      struct policy_handle *_handle /* [out] [ref] */,
				      WERROR *result)
{
	struct svcctl_CreateServiceW r;
	NTSTATUS status;

	/* In parameters */
	r.in.scmanager_handle = _scmanager_handle;
	r.in.ServiceName = _ServiceName;
	r.in.DisplayName = _DisplayName;
	r.in.desired_access = _desired_access;
	r.in.type = _type;
	r.in.start_type = _start_type;
	r.in.error_control = _error_control;
	r.in.binary_path = _binary_path;
	r.in.LoadOrderGroupKey = _LoadOrderGroupKey;
	r.in.TagId = _TagId;
	r.in.dependencies = _dependencies;
	r.in.dependencies_size = _dependencies_size;
	r.in.service_start_name = _service_start_name;
	r.in.password = _password;
	r.in.password_size = _password_size;

	/* Out parameters */
	r.out.TagId = _TagId;
	r.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_CreateServiceW_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_TagId && r.out.TagId) {
		*_TagId = *r.out.TagId;
	}
	*_handle = *r.out.handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_EnumDependentServicesW_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_EnumDependentServicesW_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_EnumDependentServicesW_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_EnumDependentServicesW *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_EnumDependentServicesW_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_EnumDependentServicesW_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_ENUMDEPENDENTSERVICESW, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_EnumDependentServicesW_r_done, req);

	return req;
}

static void dcerpc_svcctl_EnumDependentServicesW_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_EnumDependentServicesW_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_EnumDependentServicesW_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_EnumDependentServicesW_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_EnumDependentServicesW_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_EnumDependentServicesW *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_ENUMDEPENDENTSERVICESW, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_EnumDependentServicesW_state {
	struct svcctl_EnumDependentServicesW orig;
	struct svcctl_EnumDependentServicesW tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_EnumDependentServicesW_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_EnumDependentServicesW_send(TALLOC_CTX *mem_ctx,
							     struct tevent_context *ev,
							     struct dcerpc_binding_handle *h,
							     struct policy_handle *_service /* [in] [ref] */,
							     enum svcctl_ServiceState _state /* [in]  */,
							     uint8_t *_service_status /* [out] [size_is(offered),ref] */,
							     uint32_t _offered /* [in] [range(0,0x40000)] */,
							     uint32_t *_needed /* [out] [range(0,0x40000),ref] */,
							     uint32_t *_services_returned /* [out] [ref,range(0,0x40000)] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_EnumDependentServicesW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_EnumDependentServicesW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.service = _service;
	state->orig.in.state = _state;
	state->orig.in.offered = _offered;

	/* Out parameters */
	state->orig.out.service_status = _service_status;
	state->orig.out.needed = _needed;
	state->orig.out.services_returned = _services_returned;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_EnumDependentServicesW_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_EnumDependentServicesW_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_EnumDependentServicesW_done, req);
	return req;
}

static void dcerpc_svcctl_EnumDependentServicesW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_EnumDependentServicesW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_EnumDependentServicesW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_EnumDependentServicesW_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_service_status;
		_copy_len_service_status = state->tmp.in.offered;
		memcpy(state->orig.out.service_status, state->tmp.out.service_status, _copy_len_service_status * sizeof(*state->orig.out.service_status));
	}
	*state->orig.out.needed = *state->tmp.out.needed;
	*state->orig.out.services_returned = *state->tmp.out.services_returned;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_EnumDependentServicesW_recv(struct tevent_req *req,
						   TALLOC_CTX *mem_ctx,
						   WERROR *result)
{
	struct dcerpc_svcctl_EnumDependentServicesW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_EnumDependentServicesW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_EnumDependentServicesW(struct dcerpc_binding_handle *h,
					      TALLOC_CTX *mem_ctx,
					      struct policy_handle *_service /* [in] [ref] */,
					      enum svcctl_ServiceState _state /* [in]  */,
					      uint8_t *_service_status /* [out] [size_is(offered),ref] */,
					      uint32_t _offered /* [in] [range(0,0x40000)] */,
					      uint32_t *_needed /* [out] [range(0,0x40000),ref] */,
					      uint32_t *_services_returned /* [out] [ref,range(0,0x40000)] */,
					      WERROR *result)
{
	struct svcctl_EnumDependentServicesW r;
	NTSTATUS status;

	/* In parameters */
	r.in.service = _service;
	r.in.state = _state;
	r.in.offered = _offered;

	/* Out parameters */
	r.out.service_status = _service_status;
	r.out.needed = _needed;
	r.out.services_returned = _services_returned;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_EnumDependentServicesW_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_service_status;
		_copy_len_service_status = r.in.offered;
		memcpy(_service_status, r.out.service_status, _copy_len_service_status * sizeof(*_service_status));
	}
	*_needed = *r.out.needed;
	*_services_returned = *r.out.services_returned;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_EnumServicesStatusW_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_EnumServicesStatusW_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_EnumServicesStatusW_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_EnumServicesStatusW *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_EnumServicesStatusW_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_EnumServicesStatusW_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_ENUMSERVICESSTATUSW, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_EnumServicesStatusW_r_done, req);

	return req;
}

static void dcerpc_svcctl_EnumServicesStatusW_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_EnumServicesStatusW_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_EnumServicesStatusW_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_EnumServicesStatusW_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_EnumServicesStatusW_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_EnumServicesStatusW *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_ENUMSERVICESSTATUSW, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_EnumServicesStatusW_state {
	struct svcctl_EnumServicesStatusW orig;
	struct svcctl_EnumServicesStatusW tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_EnumServicesStatusW_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_EnumServicesStatusW_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  struct policy_handle *_handle /* [in] [ref] */,
							  uint32_t _type /* [in]  */,
							  enum svcctl_ServiceState _state /* [in]  */,
							  uint8_t *_service /* [out] [ref,size_is(offered)] */,
							  uint32_t _offered /* [in] [range(0,0x40000)] */,
							  uint32_t *_needed /* [out] [ref,range(0,0x40000)] */,
							  uint32_t *_services_returned /* [out] [ref,range(0,0x40000)] */,
							  uint32_t *_resume_handle /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_EnumServicesStatusW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_EnumServicesStatusW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.type = _type;
	state->orig.in.state = _state;
	state->orig.in.offered = _offered;
	state->orig.in.resume_handle = _resume_handle;

	/* Out parameters */
	state->orig.out.service = _service;
	state->orig.out.needed = _needed;
	state->orig.out.services_returned = _services_returned;
	state->orig.out.resume_handle = _resume_handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_EnumServicesStatusW_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_EnumServicesStatusW_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_EnumServicesStatusW_done, req);
	return req;
}

static void dcerpc_svcctl_EnumServicesStatusW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_EnumServicesStatusW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_EnumServicesStatusW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_EnumServicesStatusW_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_service;
		_copy_len_service = state->tmp.in.offered;
		memcpy(state->orig.out.service, state->tmp.out.service, _copy_len_service * sizeof(*state->orig.out.service));
	}
	*state->orig.out.needed = *state->tmp.out.needed;
	*state->orig.out.services_returned = *state->tmp.out.services_returned;
	if (state->orig.out.resume_handle && state->tmp.out.resume_handle) {
		*state->orig.out.resume_handle = *state->tmp.out.resume_handle;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_EnumServicesStatusW_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result)
{
	struct dcerpc_svcctl_EnumServicesStatusW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_EnumServicesStatusW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_EnumServicesStatusW(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle *_handle /* [in] [ref] */,
					   uint32_t _type /* [in]  */,
					   enum svcctl_ServiceState _state /* [in]  */,
					   uint8_t *_service /* [out] [ref,size_is(offered)] */,
					   uint32_t _offered /* [in] [range(0,0x40000)] */,
					   uint32_t *_needed /* [out] [ref,range(0,0x40000)] */,
					   uint32_t *_services_returned /* [out] [ref,range(0,0x40000)] */,
					   uint32_t *_resume_handle /* [in,out] [unique] */,
					   WERROR *result)
{
	struct svcctl_EnumServicesStatusW r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.type = _type;
	r.in.state = _state;
	r.in.offered = _offered;
	r.in.resume_handle = _resume_handle;

	/* Out parameters */
	r.out.service = _service;
	r.out.needed = _needed;
	r.out.services_returned = _services_returned;
	r.out.resume_handle = _resume_handle;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_EnumServicesStatusW_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_service;
		_copy_len_service = r.in.offered;
		memcpy(_service, r.out.service, _copy_len_service * sizeof(*_service));
	}
	*_needed = *r.out.needed;
	*_services_returned = *r.out.services_returned;
	if (_resume_handle && r.out.resume_handle) {
		*_resume_handle = *r.out.resume_handle;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_OpenSCManagerW_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_OpenSCManagerW_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_OpenSCManagerW_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_OpenSCManagerW *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_OpenSCManagerW_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_OpenSCManagerW_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_OPENSCMANAGERW, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_OpenSCManagerW_r_done, req);

	return req;
}

static void dcerpc_svcctl_OpenSCManagerW_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_OpenSCManagerW_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_OpenSCManagerW_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_OpenSCManagerW_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_OpenSCManagerW_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_OpenSCManagerW *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_OPENSCMANAGERW, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_OpenSCManagerW_state {
	struct svcctl_OpenSCManagerW orig;
	struct svcctl_OpenSCManagerW tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_OpenSCManagerW_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_OpenSCManagerW_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     const char *_MachineName /* [in] [charset(UTF16),unique] */,
						     const char *_DatabaseName /* [in] [charset(UTF16),unique] */,
						     uint32_t _access_mask /* [in]  */,
						     struct policy_handle *_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_OpenSCManagerW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_OpenSCManagerW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.MachineName = _MachineName;
	state->orig.in.DatabaseName = _DatabaseName;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */
	state->orig.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_OpenSCManagerW_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_OpenSCManagerW_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_OpenSCManagerW_done, req);
	return req;
}

static void dcerpc_svcctl_OpenSCManagerW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_OpenSCManagerW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_OpenSCManagerW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_OpenSCManagerW_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_OpenSCManagerW_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_svcctl_OpenSCManagerW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_OpenSCManagerW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_OpenSCManagerW(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      const char *_MachineName /* [in] [charset(UTF16),unique] */,
				      const char *_DatabaseName /* [in] [charset(UTF16),unique] */,
				      uint32_t _access_mask /* [in]  */,
				      struct policy_handle *_handle /* [out] [ref] */,
				      WERROR *result)
{
	struct svcctl_OpenSCManagerW r;
	NTSTATUS status;

	/* In parameters */
	r.in.MachineName = _MachineName;
	r.in.DatabaseName = _DatabaseName;
	r.in.access_mask = _access_mask;

	/* Out parameters */
	r.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_OpenSCManagerW_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_handle = *r.out.handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_OpenServiceW_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_OpenServiceW_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_OpenServiceW_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_OpenServiceW *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_OpenServiceW_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_OpenServiceW_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_OPENSERVICEW, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_OpenServiceW_r_done, req);

	return req;
}

static void dcerpc_svcctl_OpenServiceW_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_OpenServiceW_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_OpenServiceW_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_OpenServiceW_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_OpenServiceW_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_OpenServiceW *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_OPENSERVICEW, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_OpenServiceW_state {
	struct svcctl_OpenServiceW orig;
	struct svcctl_OpenServiceW tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_OpenServiceW_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_OpenServiceW_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct dcerpc_binding_handle *h,
						   struct policy_handle *_scmanager_handle /* [in] [ref] */,
						   const char *_ServiceName /* [in] [charset(UTF16)] */,
						   uint32_t _access_mask /* [in]  */,
						   struct policy_handle *_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_OpenServiceW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_OpenServiceW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.scmanager_handle = _scmanager_handle;
	state->orig.in.ServiceName = _ServiceName;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */
	state->orig.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_OpenServiceW_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_OpenServiceW_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_OpenServiceW_done, req);
	return req;
}

static void dcerpc_svcctl_OpenServiceW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_OpenServiceW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_OpenServiceW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_OpenServiceW_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_OpenServiceW_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 WERROR *result)
{
	struct dcerpc_svcctl_OpenServiceW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_OpenServiceW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_OpenServiceW(struct dcerpc_binding_handle *h,
				    TALLOC_CTX *mem_ctx,
				    struct policy_handle *_scmanager_handle /* [in] [ref] */,
				    const char *_ServiceName /* [in] [charset(UTF16)] */,
				    uint32_t _access_mask /* [in]  */,
				    struct policy_handle *_handle /* [out] [ref] */,
				    WERROR *result)
{
	struct svcctl_OpenServiceW r;
	NTSTATUS status;

	/* In parameters */
	r.in.scmanager_handle = _scmanager_handle;
	r.in.ServiceName = _ServiceName;
	r.in.access_mask = _access_mask;

	/* Out parameters */
	r.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_OpenServiceW_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_handle = *r.out.handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_QueryServiceConfigW_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_QueryServiceConfigW_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_QueryServiceConfigW_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_QueryServiceConfigW *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_QueryServiceConfigW_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_QueryServiceConfigW_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_QUERYSERVICECONFIGW, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_QueryServiceConfigW_r_done, req);

	return req;
}

static void dcerpc_svcctl_QueryServiceConfigW_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_QueryServiceConfigW_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_QueryServiceConfigW_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_QueryServiceConfigW_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_QueryServiceConfigW_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_QueryServiceConfigW *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_QUERYSERVICECONFIGW, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_QueryServiceConfigW_state {
	struct svcctl_QueryServiceConfigW orig;
	struct svcctl_QueryServiceConfigW tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_QueryServiceConfigW_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_QueryServiceConfigW_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  struct policy_handle *_handle /* [in] [ref] */,
							  struct QUERY_SERVICE_CONFIG *_query /* [out] [ref] */,
							  uint32_t _offered /* [in] [range(0,8192)] */,
							  uint32_t *_needed /* [out] [ref,range(0,8192)] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_QueryServiceConfigW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_QueryServiceConfigW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.offered = _offered;

	/* Out parameters */
	state->orig.out.query = _query;
	state->orig.out.needed = _needed;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_QueryServiceConfigW_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_QueryServiceConfigW_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_QueryServiceConfigW_done, req);
	return req;
}

static void dcerpc_svcctl_QueryServiceConfigW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_QueryServiceConfigW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_QueryServiceConfigW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_QueryServiceConfigW_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.query = *state->tmp.out.query;
	*state->orig.out.needed = *state->tmp.out.needed;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_QueryServiceConfigW_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result)
{
	struct dcerpc_svcctl_QueryServiceConfigW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_QueryServiceConfigW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_QueryServiceConfigW(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle *_handle /* [in] [ref] */,
					   struct QUERY_SERVICE_CONFIG *_query /* [out] [ref] */,
					   uint32_t _offered /* [in] [range(0,8192)] */,
					   uint32_t *_needed /* [out] [ref,range(0,8192)] */,
					   WERROR *result)
{
	struct svcctl_QueryServiceConfigW r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.offered = _offered;

	/* Out parameters */
	r.out.query = _query;
	r.out.needed = _needed;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_QueryServiceConfigW_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_query = *r.out.query;
	*_needed = *r.out.needed;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_QueryServiceLockStatusW_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_QueryServiceLockStatusW_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_QueryServiceLockStatusW_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_QueryServiceLockStatusW *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_QueryServiceLockStatusW_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_QueryServiceLockStatusW_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_QUERYSERVICELOCKSTATUSW, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_QueryServiceLockStatusW_r_done, req);

	return req;
}

static void dcerpc_svcctl_QueryServiceLockStatusW_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_QueryServiceLockStatusW_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_QueryServiceLockStatusW_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_QueryServiceLockStatusW_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_QueryServiceLockStatusW_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_QueryServiceLockStatusW *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_QUERYSERVICELOCKSTATUSW, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_QueryServiceLockStatusW_state {
	struct svcctl_QueryServiceLockStatusW orig;
	struct svcctl_QueryServiceLockStatusW tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_QueryServiceLockStatusW_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_QueryServiceLockStatusW_send(TALLOC_CTX *mem_ctx,
							      struct tevent_context *ev,
							      struct dcerpc_binding_handle *h,
							      struct policy_handle *_handle /* [in] [ref] */,
							      uint32_t _offered /* [in]  */,
							      struct SERVICE_LOCK_STATUS *_lock_status /* [out] [ref] */,
							      uint32_t *_needed /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_QueryServiceLockStatusW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_QueryServiceLockStatusW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.offered = _offered;

	/* Out parameters */
	state->orig.out.lock_status = _lock_status;
	state->orig.out.needed = _needed;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_QueryServiceLockStatusW_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_QueryServiceLockStatusW_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_QueryServiceLockStatusW_done, req);
	return req;
}

static void dcerpc_svcctl_QueryServiceLockStatusW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_QueryServiceLockStatusW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_QueryServiceLockStatusW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_QueryServiceLockStatusW_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.lock_status = *state->tmp.out.lock_status;
	*state->orig.out.needed = *state->tmp.out.needed;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_QueryServiceLockStatusW_recv(struct tevent_req *req,
						    TALLOC_CTX *mem_ctx,
						    WERROR *result)
{
	struct dcerpc_svcctl_QueryServiceLockStatusW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_QueryServiceLockStatusW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_QueryServiceLockStatusW(struct dcerpc_binding_handle *h,
					       TALLOC_CTX *mem_ctx,
					       struct policy_handle *_handle /* [in] [ref] */,
					       uint32_t _offered /* [in]  */,
					       struct SERVICE_LOCK_STATUS *_lock_status /* [out] [ref] */,
					       uint32_t *_needed /* [out] [ref] */,
					       WERROR *result)
{
	struct svcctl_QueryServiceLockStatusW r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.offered = _offered;

	/* Out parameters */
	r.out.lock_status = _lock_status;
	r.out.needed = _needed;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_QueryServiceLockStatusW_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_lock_status = *r.out.lock_status;
	*_needed = *r.out.needed;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_StartServiceW_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_StartServiceW_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_StartServiceW_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_StartServiceW *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_StartServiceW_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_StartServiceW_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_STARTSERVICEW, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_StartServiceW_r_done, req);

	return req;
}

static void dcerpc_svcctl_StartServiceW_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_StartServiceW_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_StartServiceW_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_StartServiceW_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_StartServiceW_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_StartServiceW *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_STARTSERVICEW, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_StartServiceW_state {
	struct svcctl_StartServiceW orig;
	struct svcctl_StartServiceW tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_StartServiceW_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_StartServiceW_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    struct policy_handle *_handle /* [in] [ref] */,
						    uint32_t _NumArgs /* [in] [range(0,SC_MAX_ARGUMENTS)] */,
						    struct svcctl_ArgumentString *_Arguments /* [in] [unique,size_is(NumArgs)] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_StartServiceW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_StartServiceW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.NumArgs = _NumArgs;
	state->orig.in.Arguments = _Arguments;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_StartServiceW_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_StartServiceW_done, req);
	return req;
}

static void dcerpc_svcctl_StartServiceW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_StartServiceW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_StartServiceW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_StartServiceW_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_StartServiceW_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct dcerpc_svcctl_StartServiceW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_StartServiceW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_StartServiceW(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle *_handle /* [in] [ref] */,
				     uint32_t _NumArgs /* [in] [range(0,SC_MAX_ARGUMENTS)] */,
				     struct svcctl_ArgumentString *_Arguments /* [in] [unique,size_is(NumArgs)] */,
				     WERROR *result)
{
	struct svcctl_StartServiceW r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.NumArgs = _NumArgs;
	r.in.Arguments = _Arguments;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_StartServiceW_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_GetServiceDisplayNameW_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_GetServiceDisplayNameW_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_GetServiceDisplayNameW_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_GetServiceDisplayNameW *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_GetServiceDisplayNameW_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_GetServiceDisplayNameW_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_GETSERVICEDISPLAYNAMEW, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_GetServiceDisplayNameW_r_done, req);

	return req;
}

static void dcerpc_svcctl_GetServiceDisplayNameW_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_GetServiceDisplayNameW_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_GetServiceDisplayNameW_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_GetServiceDisplayNameW_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_GetServiceDisplayNameW_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_GetServiceDisplayNameW *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_GETSERVICEDISPLAYNAMEW, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_GetServiceDisplayNameW_state {
	struct svcctl_GetServiceDisplayNameW orig;
	struct svcctl_GetServiceDisplayNameW tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_GetServiceDisplayNameW_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_GetServiceDisplayNameW_send(TALLOC_CTX *mem_ctx,
							     struct tevent_context *ev,
							     struct dcerpc_binding_handle *h,
							     struct policy_handle *_handle /* [in] [ref] */,
							     const char *_service_name /* [in] [charset(UTF16),unique] */,
							     const char **_display_name /* [out] [charset(UTF16),ref] */,
							     uint32_t *_display_name_length /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_GetServiceDisplayNameW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_GetServiceDisplayNameW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.service_name = _service_name;
	state->orig.in.display_name_length = _display_name_length;

	/* Out parameters */
	state->orig.out.display_name = _display_name;
	state->orig.out.display_name_length = _display_name_length;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_GetServiceDisplayNameW_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_GetServiceDisplayNameW_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_GetServiceDisplayNameW_done, req);
	return req;
}

static void dcerpc_svcctl_GetServiceDisplayNameW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_GetServiceDisplayNameW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_GetServiceDisplayNameW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_GetServiceDisplayNameW_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.display_name = *state->tmp.out.display_name;
	if (state->orig.out.display_name_length && state->tmp.out.display_name_length) {
		*state->orig.out.display_name_length = *state->tmp.out.display_name_length;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_GetServiceDisplayNameW_recv(struct tevent_req *req,
						   TALLOC_CTX *mem_ctx,
						   WERROR *result)
{
	struct dcerpc_svcctl_GetServiceDisplayNameW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_GetServiceDisplayNameW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_GetServiceDisplayNameW(struct dcerpc_binding_handle *h,
					      TALLOC_CTX *mem_ctx,
					      struct policy_handle *_handle /* [in] [ref] */,
					      const char *_service_name /* [in] [charset(UTF16),unique] */,
					      const char **_display_name /* [out] [charset(UTF16),ref] */,
					      uint32_t *_display_name_length /* [in,out] [unique] */,
					      WERROR *result)
{
	struct svcctl_GetServiceDisplayNameW r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.service_name = _service_name;
	r.in.display_name_length = _display_name_length;

	/* Out parameters */
	r.out.display_name = _display_name;
	r.out.display_name_length = _display_name_length;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_GetServiceDisplayNameW_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_display_name = *r.out.display_name;
	if (_display_name_length && r.out.display_name_length) {
		*_display_name_length = *r.out.display_name_length;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_GetServiceKeyNameW_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_GetServiceKeyNameW_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_GetServiceKeyNameW_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_GetServiceKeyNameW *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_GetServiceKeyNameW_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_GetServiceKeyNameW_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_GETSERVICEKEYNAMEW, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_GetServiceKeyNameW_r_done, req);

	return req;
}

static void dcerpc_svcctl_GetServiceKeyNameW_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_GetServiceKeyNameW_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_GetServiceKeyNameW_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_GetServiceKeyNameW_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_GetServiceKeyNameW_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_GetServiceKeyNameW *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_GETSERVICEKEYNAMEW, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_GetServiceKeyNameW_state {
	struct svcctl_GetServiceKeyNameW orig;
	struct svcctl_GetServiceKeyNameW tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_GetServiceKeyNameW_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_GetServiceKeyNameW_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h,
							 struct policy_handle *_handle /* [in] [ref] */,
							 const char *_service_name /* [in] [charset(UTF16),unique] */,
							 const char **_key_name /* [out] [charset(UTF16),ref] */,
							 uint32_t *_display_name_length /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_GetServiceKeyNameW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_GetServiceKeyNameW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.service_name = _service_name;
	state->orig.in.display_name_length = _display_name_length;

	/* Out parameters */
	state->orig.out.key_name = _key_name;
	state->orig.out.display_name_length = _display_name_length;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_GetServiceKeyNameW_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_GetServiceKeyNameW_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_GetServiceKeyNameW_done, req);
	return req;
}

static void dcerpc_svcctl_GetServiceKeyNameW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_GetServiceKeyNameW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_GetServiceKeyNameW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_GetServiceKeyNameW_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.key_name = *state->tmp.out.key_name;
	if (state->orig.out.display_name_length && state->tmp.out.display_name_length) {
		*state->orig.out.display_name_length = *state->tmp.out.display_name_length;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_GetServiceKeyNameW_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result)
{
	struct dcerpc_svcctl_GetServiceKeyNameW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_GetServiceKeyNameW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_GetServiceKeyNameW(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  struct policy_handle *_handle /* [in] [ref] */,
					  const char *_service_name /* [in] [charset(UTF16),unique] */,
					  const char **_key_name /* [out] [charset(UTF16),ref] */,
					  uint32_t *_display_name_length /* [in,out] [unique] */,
					  WERROR *result)
{
	struct svcctl_GetServiceKeyNameW r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.service_name = _service_name;
	r.in.display_name_length = _display_name_length;

	/* Out parameters */
	r.out.key_name = _key_name;
	r.out.display_name_length = _display_name_length;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_GetServiceKeyNameW_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_key_name = *r.out.key_name;
	if (_display_name_length && r.out.display_name_length) {
		*_display_name_length = *r.out.display_name_length;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_SCSetServiceBitsA_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_SCSetServiceBitsA_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_SCSetServiceBitsA_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_SCSetServiceBitsA *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_SCSetServiceBitsA_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_SCSetServiceBitsA_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_SCSETSERVICEBITSA, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_SCSetServiceBitsA_r_done, req);

	return req;
}

static void dcerpc_svcctl_SCSetServiceBitsA_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_SCSetServiceBitsA_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_SCSetServiceBitsA_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_SCSetServiceBitsA_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_SCSetServiceBitsA_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_SCSetServiceBitsA *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_SCSETSERVICEBITSA, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_SCSetServiceBitsA_state {
	struct svcctl_SCSetServiceBitsA orig;
	struct svcctl_SCSetServiceBitsA tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_SCSetServiceBitsA_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_SCSetServiceBitsA_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							struct policy_handle *_handle /* [in] [ref] */,
							uint32_t _bits /* [in]  */,
							uint32_t _bitson /* [in]  */,
							uint32_t _immediate /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_SCSetServiceBitsA_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_SCSetServiceBitsA_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.bits = _bits;
	state->orig.in.bitson = _bitson;
	state->orig.in.immediate = _immediate;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_SCSetServiceBitsA_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_SCSetServiceBitsA_done, req);
	return req;
}

static void dcerpc_svcctl_SCSetServiceBitsA_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_SCSetServiceBitsA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_SCSetServiceBitsA_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_SCSetServiceBitsA_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_SCSetServiceBitsA_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      WERROR *result)
{
	struct dcerpc_svcctl_SCSetServiceBitsA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_SCSetServiceBitsA_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_SCSetServiceBitsA(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle *_handle /* [in] [ref] */,
					 uint32_t _bits /* [in]  */,
					 uint32_t _bitson /* [in]  */,
					 uint32_t _immediate /* [in]  */,
					 WERROR *result)
{
	struct svcctl_SCSetServiceBitsA r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.bits = _bits;
	r.in.bitson = _bitson;
	r.in.immediate = _immediate;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_SCSetServiceBitsA_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_ChangeServiceConfigA_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_ChangeServiceConfigA_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_ChangeServiceConfigA_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_ChangeServiceConfigA *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_ChangeServiceConfigA_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_ChangeServiceConfigA_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_CHANGESERVICECONFIGA, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_ChangeServiceConfigA_r_done, req);

	return req;
}

static void dcerpc_svcctl_ChangeServiceConfigA_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_ChangeServiceConfigA_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_ChangeServiceConfigA_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_ChangeServiceConfigA_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_ChangeServiceConfigA_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_ChangeServiceConfigA *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_CHANGESERVICECONFIGA, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_ChangeServiceConfigA_state {
	struct svcctl_ChangeServiceConfigA orig;
	struct svcctl_ChangeServiceConfigA tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_ChangeServiceConfigA_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_ChangeServiceConfigA_send(TALLOC_CTX *mem_ctx,
							   struct tevent_context *ev,
							   struct dcerpc_binding_handle *h,
							   struct policy_handle *_handle /* [in] [ref] */,
							   uint32_t _type /* [in]  */,
							   enum svcctl_StartType _start_type /* [in]  */,
							   enum svcctl_ErrorControl _error_control /* [in]  */,
							   const char *_binary_path /* [in] [unique,charset(UTF16)] */,
							   const char *_load_order_group /* [in] [unique,charset(UTF16)] */,
							   uint32_t *_tag_id /* [out] [ref] */,
							   const char *_dependencies /* [in] [unique,charset(UTF16)] */,
							   const char *_service_start_name /* [in] [unique,charset(UTF16)] */,
							   const char *_password /* [in] [unique,charset(UTF16)] */,
							   const char *_display_name /* [in] [unique,charset(UTF16)] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_ChangeServiceConfigA_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_ChangeServiceConfigA_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.type = _type;
	state->orig.in.start_type = _start_type;
	state->orig.in.error_control = _error_control;
	state->orig.in.binary_path = _binary_path;
	state->orig.in.load_order_group = _load_order_group;
	state->orig.in.dependencies = _dependencies;
	state->orig.in.service_start_name = _service_start_name;
	state->orig.in.password = _password;
	state->orig.in.display_name = _display_name;

	/* Out parameters */
	state->orig.out.tag_id = _tag_id;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_ChangeServiceConfigA_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_ChangeServiceConfigA_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_ChangeServiceConfigA_done, req);
	return req;
}

static void dcerpc_svcctl_ChangeServiceConfigA_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_ChangeServiceConfigA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_ChangeServiceConfigA_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_ChangeServiceConfigA_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.tag_id = *state->tmp.out.tag_id;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_ChangeServiceConfigA_recv(struct tevent_req *req,
						 TALLOC_CTX *mem_ctx,
						 WERROR *result)
{
	struct dcerpc_svcctl_ChangeServiceConfigA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_ChangeServiceConfigA_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_ChangeServiceConfigA(struct dcerpc_binding_handle *h,
					    TALLOC_CTX *mem_ctx,
					    struct policy_handle *_handle /* [in] [ref] */,
					    uint32_t _type /* [in]  */,
					    enum svcctl_StartType _start_type /* [in]  */,
					    enum svcctl_ErrorControl _error_control /* [in]  */,
					    const char *_binary_path /* [in] [unique,charset(UTF16)] */,
					    const char *_load_order_group /* [in] [unique,charset(UTF16)] */,
					    uint32_t *_tag_id /* [out] [ref] */,
					    const char *_dependencies /* [in] [unique,charset(UTF16)] */,
					    const char *_service_start_name /* [in] [unique,charset(UTF16)] */,
					    const char *_password /* [in] [unique,charset(UTF16)] */,
					    const char *_display_name /* [in] [unique,charset(UTF16)] */,
					    WERROR *result)
{
	struct svcctl_ChangeServiceConfigA r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.type = _type;
	r.in.start_type = _start_type;
	r.in.error_control = _error_control;
	r.in.binary_path = _binary_path;
	r.in.load_order_group = _load_order_group;
	r.in.dependencies = _dependencies;
	r.in.service_start_name = _service_start_name;
	r.in.password = _password;
	r.in.display_name = _display_name;

	/* Out parameters */
	r.out.tag_id = _tag_id;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_ChangeServiceConfigA_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_tag_id = *r.out.tag_id;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_CreateServiceA_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_CreateServiceA_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_CreateServiceA_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_CreateServiceA *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_CreateServiceA_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_CreateServiceA_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_CREATESERVICEA, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_CreateServiceA_r_done, req);

	return req;
}

static void dcerpc_svcctl_CreateServiceA_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_CreateServiceA_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_CreateServiceA_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_CreateServiceA_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_CreateServiceA_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_CreateServiceA *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_CREATESERVICEA, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_CreateServiceA_state {
	struct svcctl_CreateServiceA orig;
	struct svcctl_CreateServiceA tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_CreateServiceA_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_CreateServiceA_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     struct policy_handle *_handle /* [in] [ref] */,
						     const char *_ServiceName /* [in] [charset(UTF16),unique] */,
						     const char *_DisplayName /* [in] [charset(UTF16),unique] */,
						     uint32_t _desired_access /* [in]  */,
						     uint32_t _type /* [in]  */,
						     enum svcctl_StartType _start_type /* [in]  */,
						     enum svcctl_ErrorControl _error_control /* [in]  */,
						     const char *_binary_path /* [in] [unique,charset(UTF16)] */,
						     const char *_LoadOrderGroupKey /* [in] [charset(UTF16),unique] */,
						     uint32_t *_TagId /* [out] [unique] */,
						     const char *_dependencies /* [in] [unique,charset(UTF16)] */,
						     const char *_service_start_name /* [in] [unique,charset(UTF16)] */,
						     const char *_password /* [in] [unique,charset(UTF16)] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_CreateServiceA_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_CreateServiceA_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.ServiceName = _ServiceName;
	state->orig.in.DisplayName = _DisplayName;
	state->orig.in.desired_access = _desired_access;
	state->orig.in.type = _type;
	state->orig.in.start_type = _start_type;
	state->orig.in.error_control = _error_control;
	state->orig.in.binary_path = _binary_path;
	state->orig.in.LoadOrderGroupKey = _LoadOrderGroupKey;
	state->orig.in.dependencies = _dependencies;
	state->orig.in.service_start_name = _service_start_name;
	state->orig.in.password = _password;

	/* Out parameters */
	state->orig.out.TagId = _TagId;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_CreateServiceA_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_CreateServiceA_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_CreateServiceA_done, req);
	return req;
}

static void dcerpc_svcctl_CreateServiceA_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_CreateServiceA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_CreateServiceA_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_CreateServiceA_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.TagId && state->tmp.out.TagId) {
		*state->orig.out.TagId = *state->tmp.out.TagId;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_CreateServiceA_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_svcctl_CreateServiceA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_CreateServiceA_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_CreateServiceA(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *_handle /* [in] [ref] */,
				      const char *_ServiceName /* [in] [charset(UTF16),unique] */,
				      const char *_DisplayName /* [in] [charset(UTF16),unique] */,
				      uint32_t _desired_access /* [in]  */,
				      uint32_t _type /* [in]  */,
				      enum svcctl_StartType _start_type /* [in]  */,
				      enum svcctl_ErrorControl _error_control /* [in]  */,
				      const char *_binary_path /* [in] [unique,charset(UTF16)] */,
				      const char *_LoadOrderGroupKey /* [in] [charset(UTF16),unique] */,
				      uint32_t *_TagId /* [out] [unique] */,
				      const char *_dependencies /* [in] [unique,charset(UTF16)] */,
				      const char *_service_start_name /* [in] [unique,charset(UTF16)] */,
				      const char *_password /* [in] [unique,charset(UTF16)] */,
				      WERROR *result)
{
	struct svcctl_CreateServiceA r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.ServiceName = _ServiceName;
	r.in.DisplayName = _DisplayName;
	r.in.desired_access = _desired_access;
	r.in.type = _type;
	r.in.start_type = _start_type;
	r.in.error_control = _error_control;
	r.in.binary_path = _binary_path;
	r.in.LoadOrderGroupKey = _LoadOrderGroupKey;
	r.in.dependencies = _dependencies;
	r.in.service_start_name = _service_start_name;
	r.in.password = _password;

	/* Out parameters */
	r.out.TagId = _TagId;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_CreateServiceA_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_TagId && r.out.TagId) {
		*_TagId = *r.out.TagId;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_EnumDependentServicesA_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_EnumDependentServicesA_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_EnumDependentServicesA_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_EnumDependentServicesA *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_EnumDependentServicesA_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_EnumDependentServicesA_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_ENUMDEPENDENTSERVICESA, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_EnumDependentServicesA_r_done, req);

	return req;
}

static void dcerpc_svcctl_EnumDependentServicesA_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_EnumDependentServicesA_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_EnumDependentServicesA_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_EnumDependentServicesA_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_EnumDependentServicesA_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_EnumDependentServicesA *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_ENUMDEPENDENTSERVICESA, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_EnumDependentServicesA_state {
	struct svcctl_EnumDependentServicesA orig;
	struct svcctl_EnumDependentServicesA tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_EnumDependentServicesA_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_EnumDependentServicesA_send(TALLOC_CTX *mem_ctx,
							     struct tevent_context *ev,
							     struct dcerpc_binding_handle *h,
							     struct policy_handle *_service /* [in] [ref] */,
							     enum svcctl_ServiceState _state /* [in]  */,
							     struct ENUM_SERVICE_STATUSA *_service_status /* [out] [unique] */,
							     uint32_t _offered /* [in]  */,
							     uint32_t *_needed /* [out] [ref] */,
							     uint32_t *_services_returned /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_EnumDependentServicesA_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_EnumDependentServicesA_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.service = _service;
	state->orig.in.state = _state;
	state->orig.in.offered = _offered;

	/* Out parameters */
	state->orig.out.service_status = _service_status;
	state->orig.out.needed = _needed;
	state->orig.out.services_returned = _services_returned;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_EnumDependentServicesA_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_EnumDependentServicesA_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_EnumDependentServicesA_done, req);
	return req;
}

static void dcerpc_svcctl_EnumDependentServicesA_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_EnumDependentServicesA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_EnumDependentServicesA_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_EnumDependentServicesA_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.service_status && state->tmp.out.service_status) {
		*state->orig.out.service_status = *state->tmp.out.service_status;
	}
	*state->orig.out.needed = *state->tmp.out.needed;
	*state->orig.out.services_returned = *state->tmp.out.services_returned;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_EnumDependentServicesA_recv(struct tevent_req *req,
						   TALLOC_CTX *mem_ctx,
						   WERROR *result)
{
	struct dcerpc_svcctl_EnumDependentServicesA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_EnumDependentServicesA_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_EnumDependentServicesA(struct dcerpc_binding_handle *h,
					      TALLOC_CTX *mem_ctx,
					      struct policy_handle *_service /* [in] [ref] */,
					      enum svcctl_ServiceState _state /* [in]  */,
					      struct ENUM_SERVICE_STATUSA *_service_status /* [out] [unique] */,
					      uint32_t _offered /* [in]  */,
					      uint32_t *_needed /* [out] [ref] */,
					      uint32_t *_services_returned /* [out] [ref] */,
					      WERROR *result)
{
	struct svcctl_EnumDependentServicesA r;
	NTSTATUS status;

	/* In parameters */
	r.in.service = _service;
	r.in.state = _state;
	r.in.offered = _offered;

	/* Out parameters */
	r.out.service_status = _service_status;
	r.out.needed = _needed;
	r.out.services_returned = _services_returned;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_EnumDependentServicesA_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_service_status && r.out.service_status) {
		*_service_status = *r.out.service_status;
	}
	*_needed = *r.out.needed;
	*_services_returned = *r.out.services_returned;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_EnumServicesStatusA_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_EnumServicesStatusA_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_EnumServicesStatusA_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_EnumServicesStatusA *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_EnumServicesStatusA_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_EnumServicesStatusA_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_ENUMSERVICESSTATUSA, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_EnumServicesStatusA_r_done, req);

	return req;
}

static void dcerpc_svcctl_EnumServicesStatusA_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_EnumServicesStatusA_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_EnumServicesStatusA_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_EnumServicesStatusA_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_EnumServicesStatusA_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_EnumServicesStatusA *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_ENUMSERVICESSTATUSA, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_EnumServicesStatusA_state {
	struct svcctl_EnumServicesStatusA orig;
	struct svcctl_EnumServicesStatusA tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_EnumServicesStatusA_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_EnumServicesStatusA_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  struct policy_handle *_handle /* [in] [ref] */,
							  uint32_t _type /* [in]  */,
							  enum svcctl_ServiceState _state /* [in]  */,
							  uint32_t _offered /* [in]  */,
							  uint8_t *_service /* [out] [size_is(offered)] */,
							  uint32_t *_needed /* [out] [ref] */,
							  uint32_t *_services_returned /* [out] [ref] */,
							  uint32_t *_resume_handle /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_EnumServicesStatusA_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_EnumServicesStatusA_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.type = _type;
	state->orig.in.state = _state;
	state->orig.in.offered = _offered;
	state->orig.in.resume_handle = _resume_handle;

	/* Out parameters */
	state->orig.out.service = _service;
	state->orig.out.needed = _needed;
	state->orig.out.services_returned = _services_returned;
	state->orig.out.resume_handle = _resume_handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_EnumServicesStatusA_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_EnumServicesStatusA_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_EnumServicesStatusA_done, req);
	return req;
}

static void dcerpc_svcctl_EnumServicesStatusA_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_EnumServicesStatusA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_EnumServicesStatusA_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_EnumServicesStatusA_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_service;
		_copy_len_service = state->tmp.in.offered;
		memcpy(state->orig.out.service, state->tmp.out.service, _copy_len_service * sizeof(*state->orig.out.service));
	}
	*state->orig.out.needed = *state->tmp.out.needed;
	*state->orig.out.services_returned = *state->tmp.out.services_returned;
	if (state->orig.out.resume_handle && state->tmp.out.resume_handle) {
		*state->orig.out.resume_handle = *state->tmp.out.resume_handle;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_EnumServicesStatusA_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result)
{
	struct dcerpc_svcctl_EnumServicesStatusA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_EnumServicesStatusA_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_EnumServicesStatusA(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle *_handle /* [in] [ref] */,
					   uint32_t _type /* [in]  */,
					   enum svcctl_ServiceState _state /* [in]  */,
					   uint32_t _offered /* [in]  */,
					   uint8_t *_service /* [out] [size_is(offered)] */,
					   uint32_t *_needed /* [out] [ref] */,
					   uint32_t *_services_returned /* [out] [ref] */,
					   uint32_t *_resume_handle /* [in,out] [unique] */,
					   WERROR *result)
{
	struct svcctl_EnumServicesStatusA r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.type = _type;
	r.in.state = _state;
	r.in.offered = _offered;
	r.in.resume_handle = _resume_handle;

	/* Out parameters */
	r.out.service = _service;
	r.out.needed = _needed;
	r.out.services_returned = _services_returned;
	r.out.resume_handle = _resume_handle;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_EnumServicesStatusA_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_service;
		_copy_len_service = r.in.offered;
		memcpy(_service, r.out.service, _copy_len_service * sizeof(*_service));
	}
	*_needed = *r.out.needed;
	*_services_returned = *r.out.services_returned;
	if (_resume_handle && r.out.resume_handle) {
		*_resume_handle = *r.out.resume_handle;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_OpenSCManagerA_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_OpenSCManagerA_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_OpenSCManagerA_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_OpenSCManagerA *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_OpenSCManagerA_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_OpenSCManagerA_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_OPENSCMANAGERA, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_OpenSCManagerA_r_done, req);

	return req;
}

static void dcerpc_svcctl_OpenSCManagerA_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_OpenSCManagerA_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_OpenSCManagerA_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_OpenSCManagerA_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_OpenSCManagerA_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_OpenSCManagerA *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_OPENSCMANAGERA, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_OpenSCManagerA_state {
	struct svcctl_OpenSCManagerA orig;
	struct svcctl_OpenSCManagerA tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_OpenSCManagerA_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_OpenSCManagerA_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     const char *_MachineName /* [in] [unique,charset(UTF16)] */,
						     const char *_DatabaseName /* [in] [unique,charset(UTF16)] */,
						     uint32_t _access_mask /* [in]  */,
						     struct policy_handle *_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_OpenSCManagerA_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_OpenSCManagerA_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.MachineName = _MachineName;
	state->orig.in.DatabaseName = _DatabaseName;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */
	state->orig.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_OpenSCManagerA_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_OpenSCManagerA_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_OpenSCManagerA_done, req);
	return req;
}

static void dcerpc_svcctl_OpenSCManagerA_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_OpenSCManagerA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_OpenSCManagerA_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_OpenSCManagerA_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_OpenSCManagerA_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_svcctl_OpenSCManagerA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_OpenSCManagerA_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_OpenSCManagerA(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      const char *_MachineName /* [in] [unique,charset(UTF16)] */,
				      const char *_DatabaseName /* [in] [unique,charset(UTF16)] */,
				      uint32_t _access_mask /* [in]  */,
				      struct policy_handle *_handle /* [out] [ref] */,
				      WERROR *result)
{
	struct svcctl_OpenSCManagerA r;
	NTSTATUS status;

	/* In parameters */
	r.in.MachineName = _MachineName;
	r.in.DatabaseName = _DatabaseName;
	r.in.access_mask = _access_mask;

	/* Out parameters */
	r.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_OpenSCManagerA_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_handle = *r.out.handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_OpenServiceA_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_OpenServiceA_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_OpenServiceA_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_OpenServiceA *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_OpenServiceA_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_OpenServiceA_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_OPENSERVICEA, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_OpenServiceA_r_done, req);

	return req;
}

static void dcerpc_svcctl_OpenServiceA_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_OpenServiceA_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_OpenServiceA_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_OpenServiceA_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_OpenServiceA_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_OpenServiceA *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_OPENSERVICEA, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_OpenServiceA_state {
	struct svcctl_OpenServiceA orig;
	struct svcctl_OpenServiceA tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_OpenServiceA_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_OpenServiceA_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct dcerpc_binding_handle *h,
						   struct policy_handle *_scmanager_handle /* [in] [ref] */,
						   const char *_ServiceName /* [in] [unique,charset(UTF16)] */,
						   uint32_t _access_mask /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_OpenServiceA_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_OpenServiceA_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.scmanager_handle = _scmanager_handle;
	state->orig.in.ServiceName = _ServiceName;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_OpenServiceA_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_OpenServiceA_done, req);
	return req;
}

static void dcerpc_svcctl_OpenServiceA_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_OpenServiceA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_OpenServiceA_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_OpenServiceA_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_OpenServiceA_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 WERROR *result)
{
	struct dcerpc_svcctl_OpenServiceA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_OpenServiceA_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_OpenServiceA(struct dcerpc_binding_handle *h,
				    TALLOC_CTX *mem_ctx,
				    struct policy_handle *_scmanager_handle /* [in] [ref] */,
				    const char *_ServiceName /* [in] [unique,charset(UTF16)] */,
				    uint32_t _access_mask /* [in]  */,
				    WERROR *result)
{
	struct svcctl_OpenServiceA r;
	NTSTATUS status;

	/* In parameters */
	r.in.scmanager_handle = _scmanager_handle;
	r.in.ServiceName = _ServiceName;
	r.in.access_mask = _access_mask;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_OpenServiceA_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_QueryServiceConfigA_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_QueryServiceConfigA_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_QueryServiceConfigA_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_QueryServiceConfigA *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_QueryServiceConfigA_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_QueryServiceConfigA_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_QUERYSERVICECONFIGA, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_QueryServiceConfigA_r_done, req);

	return req;
}

static void dcerpc_svcctl_QueryServiceConfigA_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_QueryServiceConfigA_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_QueryServiceConfigA_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_QueryServiceConfigA_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_QueryServiceConfigA_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_QueryServiceConfigA *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_QUERYSERVICECONFIGA, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_QueryServiceConfigA_state {
	struct svcctl_QueryServiceConfigA orig;
	struct svcctl_QueryServiceConfigA tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_QueryServiceConfigA_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_QueryServiceConfigA_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  struct policy_handle *_handle /* [in] [ref] */,
							  uint8_t *_query /* [out]  */,
							  uint32_t _offered /* [in]  */,
							  uint32_t *_needed /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_QueryServiceConfigA_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_QueryServiceConfigA_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.offered = _offered;

	/* Out parameters */
	state->orig.out.query = _query;
	state->orig.out.needed = _needed;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_QueryServiceConfigA_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_QueryServiceConfigA_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_QueryServiceConfigA_done, req);
	return req;
}

static void dcerpc_svcctl_QueryServiceConfigA_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_QueryServiceConfigA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_QueryServiceConfigA_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_QueryServiceConfigA_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_query;
		_copy_len_query = state->tmp.in.offered;
		memcpy(state->orig.out.query, state->tmp.out.query, _copy_len_query * sizeof(*state->orig.out.query));
	}
	*state->orig.out.needed = *state->tmp.out.needed;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_QueryServiceConfigA_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result)
{
	struct dcerpc_svcctl_QueryServiceConfigA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_QueryServiceConfigA_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_QueryServiceConfigA(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle *_handle /* [in] [ref] */,
					   uint8_t *_query /* [out]  */,
					   uint32_t _offered /* [in]  */,
					   uint32_t *_needed /* [out] [ref] */,
					   WERROR *result)
{
	struct svcctl_QueryServiceConfigA r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.offered = _offered;

	/* Out parameters */
	r.out.query = _query;
	r.out.needed = _needed;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_QueryServiceConfigA_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_query;
		_copy_len_query = r.in.offered;
		memcpy(_query, r.out.query, _copy_len_query * sizeof(*_query));
	}
	*_needed = *r.out.needed;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_QueryServiceLockStatusA_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_QueryServiceLockStatusA_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_QueryServiceLockStatusA_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_QueryServiceLockStatusA *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_QueryServiceLockStatusA_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_QueryServiceLockStatusA_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_QUERYSERVICELOCKSTATUSA, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_QueryServiceLockStatusA_r_done, req);

	return req;
}

static void dcerpc_svcctl_QueryServiceLockStatusA_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_QueryServiceLockStatusA_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_QueryServiceLockStatusA_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_QueryServiceLockStatusA_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_QueryServiceLockStatusA_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_QueryServiceLockStatusA *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_QUERYSERVICELOCKSTATUSA, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_QueryServiceLockStatusA_state {
	struct svcctl_QueryServiceLockStatusA orig;
	struct svcctl_QueryServiceLockStatusA tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_QueryServiceLockStatusA_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_QueryServiceLockStatusA_send(TALLOC_CTX *mem_ctx,
							      struct tevent_context *ev,
							      struct dcerpc_binding_handle *h,
							      struct policy_handle *_handle /* [in] [ref] */,
							      uint32_t _offered /* [in]  */,
							      struct SERVICE_LOCK_STATUS *_lock_status /* [out] [ref] */,
							      uint32_t *_needed /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_QueryServiceLockStatusA_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_QueryServiceLockStatusA_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.offered = _offered;

	/* Out parameters */
	state->orig.out.lock_status = _lock_status;
	state->orig.out.needed = _needed;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_QueryServiceLockStatusA_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_QueryServiceLockStatusA_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_QueryServiceLockStatusA_done, req);
	return req;
}

static void dcerpc_svcctl_QueryServiceLockStatusA_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_QueryServiceLockStatusA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_QueryServiceLockStatusA_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_QueryServiceLockStatusA_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.lock_status = *state->tmp.out.lock_status;
	*state->orig.out.needed = *state->tmp.out.needed;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_QueryServiceLockStatusA_recv(struct tevent_req *req,
						    TALLOC_CTX *mem_ctx,
						    WERROR *result)
{
	struct dcerpc_svcctl_QueryServiceLockStatusA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_QueryServiceLockStatusA_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_QueryServiceLockStatusA(struct dcerpc_binding_handle *h,
					       TALLOC_CTX *mem_ctx,
					       struct policy_handle *_handle /* [in] [ref] */,
					       uint32_t _offered /* [in]  */,
					       struct SERVICE_LOCK_STATUS *_lock_status /* [out] [ref] */,
					       uint32_t *_needed /* [out] [ref] */,
					       WERROR *result)
{
	struct svcctl_QueryServiceLockStatusA r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.offered = _offered;

	/* Out parameters */
	r.out.lock_status = _lock_status;
	r.out.needed = _needed;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_QueryServiceLockStatusA_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_lock_status = *r.out.lock_status;
	*_needed = *r.out.needed;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_StartServiceA_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_StartServiceA_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_StartServiceA_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_StartServiceA *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_StartServiceA_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_StartServiceA_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_STARTSERVICEA, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_StartServiceA_r_done, req);

	return req;
}

static void dcerpc_svcctl_StartServiceA_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_StartServiceA_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_StartServiceA_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_StartServiceA_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_StartServiceA_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_StartServiceA *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_STARTSERVICEA, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_StartServiceA_state {
	struct svcctl_StartServiceA orig;
	struct svcctl_StartServiceA tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_StartServiceA_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_StartServiceA_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    struct policy_handle *_handle /* [in] [ref] */,
						    uint32_t _NumArgs /* [in]  */,
						    const char *_Arguments /* [in] [unique,charset(UTF16)] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_StartServiceA_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_StartServiceA_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.NumArgs = _NumArgs;
	state->orig.in.Arguments = _Arguments;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_StartServiceA_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_StartServiceA_done, req);
	return req;
}

static void dcerpc_svcctl_StartServiceA_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_StartServiceA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_StartServiceA_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_StartServiceA_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_StartServiceA_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct dcerpc_svcctl_StartServiceA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_StartServiceA_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_StartServiceA(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle *_handle /* [in] [ref] */,
				     uint32_t _NumArgs /* [in]  */,
				     const char *_Arguments /* [in] [unique,charset(UTF16)] */,
				     WERROR *result)
{
	struct svcctl_StartServiceA r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.NumArgs = _NumArgs;
	r.in.Arguments = _Arguments;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_StartServiceA_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_GetServiceDisplayNameA_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_GetServiceDisplayNameA_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_GetServiceDisplayNameA_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_GetServiceDisplayNameA *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_GetServiceDisplayNameA_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_GetServiceDisplayNameA_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_GETSERVICEDISPLAYNAMEA, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_GetServiceDisplayNameA_r_done, req);

	return req;
}

static void dcerpc_svcctl_GetServiceDisplayNameA_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_GetServiceDisplayNameA_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_GetServiceDisplayNameA_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_GetServiceDisplayNameA_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_GetServiceDisplayNameA_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_GetServiceDisplayNameA *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_GETSERVICEDISPLAYNAMEA, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_GetServiceDisplayNameA_state {
	struct svcctl_GetServiceDisplayNameA orig;
	struct svcctl_GetServiceDisplayNameA tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_GetServiceDisplayNameA_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_GetServiceDisplayNameA_send(TALLOC_CTX *mem_ctx,
							     struct tevent_context *ev,
							     struct dcerpc_binding_handle *h,
							     struct policy_handle *_handle /* [in] [ref] */,
							     const char *_service_name /* [in] [unique,charset(UTF16)] */,
							     const char **_display_name /* [out] [ref,charset(UTF16)] */,
							     uint32_t *_display_name_length /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_GetServiceDisplayNameA_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_GetServiceDisplayNameA_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.service_name = _service_name;
	state->orig.in.display_name_length = _display_name_length;

	/* Out parameters */
	state->orig.out.display_name = _display_name;
	state->orig.out.display_name_length = _display_name_length;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_GetServiceDisplayNameA_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_GetServiceDisplayNameA_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_GetServiceDisplayNameA_done, req);
	return req;
}

static void dcerpc_svcctl_GetServiceDisplayNameA_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_GetServiceDisplayNameA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_GetServiceDisplayNameA_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_GetServiceDisplayNameA_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.display_name = *state->tmp.out.display_name;
	if (state->orig.out.display_name_length && state->tmp.out.display_name_length) {
		*state->orig.out.display_name_length = *state->tmp.out.display_name_length;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_GetServiceDisplayNameA_recv(struct tevent_req *req,
						   TALLOC_CTX *mem_ctx,
						   WERROR *result)
{
	struct dcerpc_svcctl_GetServiceDisplayNameA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_GetServiceDisplayNameA_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_GetServiceDisplayNameA(struct dcerpc_binding_handle *h,
					      TALLOC_CTX *mem_ctx,
					      struct policy_handle *_handle /* [in] [ref] */,
					      const char *_service_name /* [in] [unique,charset(UTF16)] */,
					      const char **_display_name /* [out] [ref,charset(UTF16)] */,
					      uint32_t *_display_name_length /* [in,out] [unique] */,
					      WERROR *result)
{
	struct svcctl_GetServiceDisplayNameA r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.service_name = _service_name;
	r.in.display_name_length = _display_name_length;

	/* Out parameters */
	r.out.display_name = _display_name;
	r.out.display_name_length = _display_name_length;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_GetServiceDisplayNameA_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_display_name = *r.out.display_name;
	if (_display_name_length && r.out.display_name_length) {
		*_display_name_length = *r.out.display_name_length;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_GetServiceKeyNameA_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_GetServiceKeyNameA_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_GetServiceKeyNameA_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_GetServiceKeyNameA *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_GetServiceKeyNameA_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_GetServiceKeyNameA_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_GETSERVICEKEYNAMEA, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_GetServiceKeyNameA_r_done, req);

	return req;
}

static void dcerpc_svcctl_GetServiceKeyNameA_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_GetServiceKeyNameA_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_GetServiceKeyNameA_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_GetServiceKeyNameA_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_GetServiceKeyNameA_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_GetServiceKeyNameA *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_GETSERVICEKEYNAMEA, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_GetServiceKeyNameA_state {
	struct svcctl_GetServiceKeyNameA orig;
	struct svcctl_GetServiceKeyNameA tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_GetServiceKeyNameA_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_GetServiceKeyNameA_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h,
							 struct policy_handle *_handle /* [in] [ref] */,
							 const char *_service_name /* [in] [unique,charset(UTF16)] */,
							 const char **_key_name /* [out] [charset(UTF16),ref] */,
							 uint32_t *_display_name_length /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_GetServiceKeyNameA_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_GetServiceKeyNameA_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.service_name = _service_name;
	state->orig.in.display_name_length = _display_name_length;

	/* Out parameters */
	state->orig.out.key_name = _key_name;
	state->orig.out.display_name_length = _display_name_length;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_GetServiceKeyNameA_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_GetServiceKeyNameA_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_GetServiceKeyNameA_done, req);
	return req;
}

static void dcerpc_svcctl_GetServiceKeyNameA_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_GetServiceKeyNameA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_GetServiceKeyNameA_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_GetServiceKeyNameA_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.key_name = *state->tmp.out.key_name;
	if (state->orig.out.display_name_length && state->tmp.out.display_name_length) {
		*state->orig.out.display_name_length = *state->tmp.out.display_name_length;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_GetServiceKeyNameA_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result)
{
	struct dcerpc_svcctl_GetServiceKeyNameA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_GetServiceKeyNameA_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_GetServiceKeyNameA(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  struct policy_handle *_handle /* [in] [ref] */,
					  const char *_service_name /* [in] [unique,charset(UTF16)] */,
					  const char **_key_name /* [out] [charset(UTF16),ref] */,
					  uint32_t *_display_name_length /* [in,out] [unique] */,
					  WERROR *result)
{
	struct svcctl_GetServiceKeyNameA r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.service_name = _service_name;
	r.in.display_name_length = _display_name_length;

	/* Out parameters */
	r.out.key_name = _key_name;
	r.out.display_name_length = _display_name_length;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_GetServiceKeyNameA_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_key_name = *r.out.key_name;
	if (_display_name_length && r.out.display_name_length) {
		*_display_name_length = *r.out.display_name_length;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_ChangeServiceConfig2A_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_ChangeServiceConfig2A_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_ChangeServiceConfig2A_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_ChangeServiceConfig2A *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_ChangeServiceConfig2A_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_ChangeServiceConfig2A_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_CHANGESERVICECONFIG2A, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_ChangeServiceConfig2A_r_done, req);

	return req;
}

static void dcerpc_svcctl_ChangeServiceConfig2A_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_ChangeServiceConfig2A_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_ChangeServiceConfig2A_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_ChangeServiceConfig2A_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_ChangeServiceConfig2A_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_ChangeServiceConfig2A *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_CHANGESERVICECONFIG2A, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_ChangeServiceConfig2A_state {
	struct svcctl_ChangeServiceConfig2A orig;
	struct svcctl_ChangeServiceConfig2A tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_ChangeServiceConfig2A_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_ChangeServiceConfig2A_send(TALLOC_CTX *mem_ctx,
							    struct tevent_context *ev,
							    struct dcerpc_binding_handle *h,
							    struct policy_handle *_handle /* [in] [ref] */,
							    uint32_t _info_level /* [in]  */,
							    uint8_t *_info /* [in] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_ChangeServiceConfig2A_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_ChangeServiceConfig2A_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.info_level = _info_level;
	state->orig.in.info = _info;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_ChangeServiceConfig2A_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_ChangeServiceConfig2A_done, req);
	return req;
}

static void dcerpc_svcctl_ChangeServiceConfig2A_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_ChangeServiceConfig2A_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_ChangeServiceConfig2A_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_ChangeServiceConfig2A_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_ChangeServiceConfig2A_recv(struct tevent_req *req,
						  TALLOC_CTX *mem_ctx,
						  WERROR *result)
{
	struct dcerpc_svcctl_ChangeServiceConfig2A_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_ChangeServiceConfig2A_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_ChangeServiceConfig2A(struct dcerpc_binding_handle *h,
					     TALLOC_CTX *mem_ctx,
					     struct policy_handle *_handle /* [in] [ref] */,
					     uint32_t _info_level /* [in]  */,
					     uint8_t *_info /* [in] [unique] */,
					     WERROR *result)
{
	struct svcctl_ChangeServiceConfig2A r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.info_level = _info_level;
	r.in.info = _info;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_ChangeServiceConfig2A_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_ChangeServiceConfig2W_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_ChangeServiceConfig2W_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_ChangeServiceConfig2W_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_ChangeServiceConfig2W *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_ChangeServiceConfig2W_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_ChangeServiceConfig2W_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_CHANGESERVICECONFIG2W, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_ChangeServiceConfig2W_r_done, req);

	return req;
}

static void dcerpc_svcctl_ChangeServiceConfig2W_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_ChangeServiceConfig2W_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_ChangeServiceConfig2W_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_ChangeServiceConfig2W_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_ChangeServiceConfig2W_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_ChangeServiceConfig2W *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_CHANGESERVICECONFIG2W, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_ChangeServiceConfig2W_state {
	struct svcctl_ChangeServiceConfig2W orig;
	struct svcctl_ChangeServiceConfig2W tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_ChangeServiceConfig2W_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_ChangeServiceConfig2W_send(TALLOC_CTX *mem_ctx,
							    struct tevent_context *ev,
							    struct dcerpc_binding_handle *h,
							    struct policy_handle *_handle /* [in] [ref] */,
							    uint32_t _info_level /* [in]  */,
							    uint8_t *_info /* [in] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_ChangeServiceConfig2W_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_ChangeServiceConfig2W_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.info_level = _info_level;
	state->orig.in.info = _info;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_ChangeServiceConfig2W_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_ChangeServiceConfig2W_done, req);
	return req;
}

static void dcerpc_svcctl_ChangeServiceConfig2W_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_ChangeServiceConfig2W_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_ChangeServiceConfig2W_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_ChangeServiceConfig2W_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_ChangeServiceConfig2W_recv(struct tevent_req *req,
						  TALLOC_CTX *mem_ctx,
						  WERROR *result)
{
	struct dcerpc_svcctl_ChangeServiceConfig2W_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_ChangeServiceConfig2W_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_ChangeServiceConfig2W(struct dcerpc_binding_handle *h,
					     TALLOC_CTX *mem_ctx,
					     struct policy_handle *_handle /* [in] [ref] */,
					     uint32_t _info_level /* [in]  */,
					     uint8_t *_info /* [in] [unique] */,
					     WERROR *result)
{
	struct svcctl_ChangeServiceConfig2W r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.info_level = _info_level;
	r.in.info = _info;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_ChangeServiceConfig2W_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_QueryServiceConfig2A_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_QueryServiceConfig2A_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_QueryServiceConfig2A_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_QueryServiceConfig2A *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_QueryServiceConfig2A_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_QueryServiceConfig2A_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_QUERYSERVICECONFIG2A, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_QueryServiceConfig2A_r_done, req);

	return req;
}

static void dcerpc_svcctl_QueryServiceConfig2A_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_QueryServiceConfig2A_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_QueryServiceConfig2A_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_QueryServiceConfig2A_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_QueryServiceConfig2A_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_QueryServiceConfig2A *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_QUERYSERVICECONFIG2A, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_QueryServiceConfig2A_state {
	struct svcctl_QueryServiceConfig2A orig;
	struct svcctl_QueryServiceConfig2A tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_QueryServiceConfig2A_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_QueryServiceConfig2A_send(TALLOC_CTX *mem_ctx,
							   struct tevent_context *ev,
							   struct dcerpc_binding_handle *h,
							   struct policy_handle *_handle /* [in] [ref] */,
							   enum svcctl_ConfigLevel _info_level /* [in]  */,
							   uint8_t *_buffer /* [out]  */,
							   uint32_t _offered /* [in]  */,
							   uint32_t *_needed /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_QueryServiceConfig2A_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_QueryServiceConfig2A_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.info_level = _info_level;
	state->orig.in.offered = _offered;

	/* Out parameters */
	state->orig.out.buffer = _buffer;
	state->orig.out.needed = _needed;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_QueryServiceConfig2A_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_QueryServiceConfig2A_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_QueryServiceConfig2A_done, req);
	return req;
}

static void dcerpc_svcctl_QueryServiceConfig2A_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_QueryServiceConfig2A_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_QueryServiceConfig2A_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_QueryServiceConfig2A_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_buffer;
		_copy_len_buffer = state->tmp.in.offered;
		memcpy(state->orig.out.buffer, state->tmp.out.buffer, _copy_len_buffer * sizeof(*state->orig.out.buffer));
	}
	*state->orig.out.needed = *state->tmp.out.needed;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_QueryServiceConfig2A_recv(struct tevent_req *req,
						 TALLOC_CTX *mem_ctx,
						 WERROR *result)
{
	struct dcerpc_svcctl_QueryServiceConfig2A_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_QueryServiceConfig2A_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_QueryServiceConfig2A(struct dcerpc_binding_handle *h,
					    TALLOC_CTX *mem_ctx,
					    struct policy_handle *_handle /* [in] [ref] */,
					    enum svcctl_ConfigLevel _info_level /* [in]  */,
					    uint8_t *_buffer /* [out]  */,
					    uint32_t _offered /* [in]  */,
					    uint32_t *_needed /* [out] [ref] */,
					    WERROR *result)
{
	struct svcctl_QueryServiceConfig2A r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.info_level = _info_level;
	r.in.offered = _offered;

	/* Out parameters */
	r.out.buffer = _buffer;
	r.out.needed = _needed;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_QueryServiceConfig2A_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_buffer;
		_copy_len_buffer = r.in.offered;
		memcpy(_buffer, r.out.buffer, _copy_len_buffer * sizeof(*_buffer));
	}
	*_needed = *r.out.needed;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_QueryServiceConfig2W_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_QueryServiceConfig2W_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_QueryServiceConfig2W_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_QueryServiceConfig2W *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_QueryServiceConfig2W_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_QueryServiceConfig2W_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_QUERYSERVICECONFIG2W, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_QueryServiceConfig2W_r_done, req);

	return req;
}

static void dcerpc_svcctl_QueryServiceConfig2W_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_QueryServiceConfig2W_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_QueryServiceConfig2W_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_QueryServiceConfig2W_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_QueryServiceConfig2W_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_QueryServiceConfig2W *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_QUERYSERVICECONFIG2W, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_QueryServiceConfig2W_state {
	struct svcctl_QueryServiceConfig2W orig;
	struct svcctl_QueryServiceConfig2W tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_QueryServiceConfig2W_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_QueryServiceConfig2W_send(TALLOC_CTX *mem_ctx,
							   struct tevent_context *ev,
							   struct dcerpc_binding_handle *h,
							   struct policy_handle *_handle /* [in] [ref] */,
							   enum svcctl_ConfigLevel _info_level /* [in]  */,
							   uint8_t *_buffer /* [out] [ref,size_is(offered)] */,
							   uint32_t _offered /* [in] [range(0,8192)] */,
							   uint32_t *_needed /* [out] [range(0,8192),ref] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_QueryServiceConfig2W_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_QueryServiceConfig2W_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.info_level = _info_level;
	state->orig.in.offered = _offered;

	/* Out parameters */
	state->orig.out.buffer = _buffer;
	state->orig.out.needed = _needed;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_QueryServiceConfig2W_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_QueryServiceConfig2W_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_QueryServiceConfig2W_done, req);
	return req;
}

static void dcerpc_svcctl_QueryServiceConfig2W_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_QueryServiceConfig2W_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_QueryServiceConfig2W_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_QueryServiceConfig2W_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_buffer;
		_copy_len_buffer = state->tmp.in.offered;
		memcpy(state->orig.out.buffer, state->tmp.out.buffer, _copy_len_buffer * sizeof(*state->orig.out.buffer));
	}
	*state->orig.out.needed = *state->tmp.out.needed;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_QueryServiceConfig2W_recv(struct tevent_req *req,
						 TALLOC_CTX *mem_ctx,
						 WERROR *result)
{
	struct dcerpc_svcctl_QueryServiceConfig2W_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_QueryServiceConfig2W_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_QueryServiceConfig2W(struct dcerpc_binding_handle *h,
					    TALLOC_CTX *mem_ctx,
					    struct policy_handle *_handle /* [in] [ref] */,
					    enum svcctl_ConfigLevel _info_level /* [in]  */,
					    uint8_t *_buffer /* [out] [ref,size_is(offered)] */,
					    uint32_t _offered /* [in] [range(0,8192)] */,
					    uint32_t *_needed /* [out] [range(0,8192),ref] */,
					    WERROR *result)
{
	struct svcctl_QueryServiceConfig2W r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.info_level = _info_level;
	r.in.offered = _offered;

	/* Out parameters */
	r.out.buffer = _buffer;
	r.out.needed = _needed;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_QueryServiceConfig2W_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_buffer;
		_copy_len_buffer = r.in.offered;
		memcpy(_buffer, r.out.buffer, _copy_len_buffer * sizeof(*_buffer));
	}
	*_needed = *r.out.needed;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_QueryServiceStatusEx_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_QueryServiceStatusEx_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_QueryServiceStatusEx_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_QueryServiceStatusEx *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_QueryServiceStatusEx_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_QueryServiceStatusEx_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_QUERYSERVICESTATUSEX, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_QueryServiceStatusEx_r_done, req);

	return req;
}

static void dcerpc_svcctl_QueryServiceStatusEx_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_QueryServiceStatusEx_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_QueryServiceStatusEx_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_QueryServiceStatusEx_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_QueryServiceStatusEx_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_QueryServiceStatusEx *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_QUERYSERVICESTATUSEX, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_QueryServiceStatusEx_state {
	struct svcctl_QueryServiceStatusEx orig;
	struct svcctl_QueryServiceStatusEx tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_QueryServiceStatusEx_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_QueryServiceStatusEx_send(TALLOC_CTX *mem_ctx,
							   struct tevent_context *ev,
							   struct dcerpc_binding_handle *h,
							   struct policy_handle *_handle /* [in] [ref] */,
							   enum svcctl_StatusLevel _info_level /* [in]  */,
							   uint8_t *_buffer /* [out] [size_is(offered),ref] */,
							   uint32_t _offered /* [in] [range(0,8192)] */,
							   uint32_t *_needed /* [out] [ref,range(0,8192)] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_QueryServiceStatusEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_QueryServiceStatusEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.info_level = _info_level;
	state->orig.in.offered = _offered;

	/* Out parameters */
	state->orig.out.buffer = _buffer;
	state->orig.out.needed = _needed;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_QueryServiceStatusEx_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_QueryServiceStatusEx_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_QueryServiceStatusEx_done, req);
	return req;
}

static void dcerpc_svcctl_QueryServiceStatusEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_QueryServiceStatusEx_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_QueryServiceStatusEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_QueryServiceStatusEx_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_buffer;
		_copy_len_buffer = state->tmp.in.offered;
		memcpy(state->orig.out.buffer, state->tmp.out.buffer, _copy_len_buffer * sizeof(*state->orig.out.buffer));
	}
	*state->orig.out.needed = *state->tmp.out.needed;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_QueryServiceStatusEx_recv(struct tevent_req *req,
						 TALLOC_CTX *mem_ctx,
						 WERROR *result)
{
	struct dcerpc_svcctl_QueryServiceStatusEx_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_QueryServiceStatusEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_QueryServiceStatusEx(struct dcerpc_binding_handle *h,
					    TALLOC_CTX *mem_ctx,
					    struct policy_handle *_handle /* [in] [ref] */,
					    enum svcctl_StatusLevel _info_level /* [in]  */,
					    uint8_t *_buffer /* [out] [size_is(offered),ref] */,
					    uint32_t _offered /* [in] [range(0,8192)] */,
					    uint32_t *_needed /* [out] [ref,range(0,8192)] */,
					    WERROR *result)
{
	struct svcctl_QueryServiceStatusEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.info_level = _info_level;
	r.in.offered = _offered;

	/* Out parameters */
	r.out.buffer = _buffer;
	r.out.needed = _needed;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_QueryServiceStatusEx_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_buffer;
		_copy_len_buffer = r.in.offered;
		memcpy(_buffer, r.out.buffer, _copy_len_buffer * sizeof(*_buffer));
	}
	*_needed = *r.out.needed;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_EnumServicesStatusExA_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_EnumServicesStatusExA_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_EnumServicesStatusExA_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct EnumServicesStatusExA *r)
{
	struct tevent_req *req;
	struct dcerpc_EnumServicesStatusExA_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_EnumServicesStatusExA_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_ENUMSERVICESSTATUSEXA, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_EnumServicesStatusExA_r_done, req);

	return req;
}

static void dcerpc_EnumServicesStatusExA_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_EnumServicesStatusExA_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_EnumServicesStatusExA_r_state *state =
		tevent_req_data(req,
		struct dcerpc_EnumServicesStatusExA_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_EnumServicesStatusExA_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct EnumServicesStatusExA *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_ENUMSERVICESSTATUSEXA, mem_ctx, r);

	return status;
}

struct dcerpc_EnumServicesStatusExA_state {
	struct EnumServicesStatusExA orig;
	struct EnumServicesStatusExA tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_EnumServicesStatusExA_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_EnumServicesStatusExA_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     struct policy_handle *_scmanager /* [in] [ref] */,
						     uint32_t _info_level /* [in]  */,
						     uint32_t _type /* [in]  */,
						     enum svcctl_ServiceState _state /* [in]  */,
						     uint8_t *_services /* [out]  */,
						     uint32_t _offered /* [in]  */,
						     uint32_t *_needed /* [out] [ref] */,
						     uint32_t *_service_returned /* [out] [ref] */,
						     uint32_t *_resume_handle /* [in,out] [unique] */,
						     const char **_group_name /* [out] [ref,charset(UTF16)] */)
{
	struct tevent_req *req;
	struct dcerpc_EnumServicesStatusExA_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_EnumServicesStatusExA_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.scmanager = _scmanager;
	state->orig.in.info_level = _info_level;
	state->orig.in.type = _type;
	state->orig.in.state = _state;
	state->orig.in.offered = _offered;
	state->orig.in.resume_handle = _resume_handle;

	/* Out parameters */
	state->orig.out.services = _services;
	state->orig.out.needed = _needed;
	state->orig.out.service_returned = _service_returned;
	state->orig.out.resume_handle = _resume_handle;
	state->orig.out.group_name = _group_name;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_EnumServicesStatusExA_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_EnumServicesStatusExA_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_EnumServicesStatusExA_done, req);
	return req;
}

static void dcerpc_EnumServicesStatusExA_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_EnumServicesStatusExA_state *state = tevent_req_data(
		req, struct dcerpc_EnumServicesStatusExA_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_EnumServicesStatusExA_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_services;
		_copy_len_services = state->tmp.in.offered;
		memcpy(state->orig.out.services, state->tmp.out.services, _copy_len_services * sizeof(*state->orig.out.services));
	}
	*state->orig.out.needed = *state->tmp.out.needed;
	*state->orig.out.service_returned = *state->tmp.out.service_returned;
	if (state->orig.out.resume_handle && state->tmp.out.resume_handle) {
		*state->orig.out.resume_handle = *state->tmp.out.resume_handle;
	}
	*state->orig.out.group_name = *state->tmp.out.group_name;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_EnumServicesStatusExA_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_EnumServicesStatusExA_state *state = tevent_req_data(
		req, struct dcerpc_EnumServicesStatusExA_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_EnumServicesStatusExA(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *_scmanager /* [in] [ref] */,
				      uint32_t _info_level /* [in]  */,
				      uint32_t _type /* [in]  */,
				      enum svcctl_ServiceState _state /* [in]  */,
				      uint8_t *_services /* [out]  */,
				      uint32_t _offered /* [in]  */,
				      uint32_t *_needed /* [out] [ref] */,
				      uint32_t *_service_returned /* [out] [ref] */,
				      uint32_t *_resume_handle /* [in,out] [unique] */,
				      const char **_group_name /* [out] [ref,charset(UTF16)] */,
				      WERROR *result)
{
	struct EnumServicesStatusExA r;
	NTSTATUS status;

	/* In parameters */
	r.in.scmanager = _scmanager;
	r.in.info_level = _info_level;
	r.in.type = _type;
	r.in.state = _state;
	r.in.offered = _offered;
	r.in.resume_handle = _resume_handle;

	/* Out parameters */
	r.out.services = _services;
	r.out.needed = _needed;
	r.out.service_returned = _service_returned;
	r.out.resume_handle = _resume_handle;
	r.out.group_name = _group_name;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_EnumServicesStatusExA_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_services;
		_copy_len_services = r.in.offered;
		memcpy(_services, r.out.services, _copy_len_services * sizeof(*_services));
	}
	*_needed = *r.out.needed;
	*_service_returned = *r.out.service_returned;
	if (_resume_handle && r.out.resume_handle) {
		*_resume_handle = *r.out.resume_handle;
	}
	*_group_name = *r.out.group_name;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_EnumServicesStatusExW_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_EnumServicesStatusExW_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_EnumServicesStatusExW_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct EnumServicesStatusExW *r)
{
	struct tevent_req *req;
	struct dcerpc_EnumServicesStatusExW_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_EnumServicesStatusExW_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_ENUMSERVICESSTATUSEXW, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_EnumServicesStatusExW_r_done, req);

	return req;
}

static void dcerpc_EnumServicesStatusExW_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_EnumServicesStatusExW_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_EnumServicesStatusExW_r_state *state =
		tevent_req_data(req,
		struct dcerpc_EnumServicesStatusExW_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_EnumServicesStatusExW_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct EnumServicesStatusExW *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_ENUMSERVICESSTATUSEXW, mem_ctx, r);

	return status;
}

struct dcerpc_EnumServicesStatusExW_state {
	struct EnumServicesStatusExW orig;
	struct EnumServicesStatusExW tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_EnumServicesStatusExW_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_EnumServicesStatusExW_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     struct policy_handle *_scmanager /* [in] [ref] */,
						     uint32_t _info_level /* [in]  */,
						     uint32_t _type /* [in]  */,
						     enum svcctl_ServiceState _state /* [in]  */,
						     uint8_t *_services /* [out] [ref,size_is(offered)] */,
						     uint32_t _offered /* [in] [range(0,0x40000)] */,
						     uint32_t *_needed /* [out] [range(0,0x40000),ref] */,
						     uint32_t *_service_returned /* [out] [ref,range(0,0x40000)] */,
						     uint32_t *_resume_handle /* [in,out] [range(0,0x40000),unique] */,
						     const char *_group_name /* [in] [unique,charset(UTF16)] */)
{
	struct tevent_req *req;
	struct dcerpc_EnumServicesStatusExW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_EnumServicesStatusExW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.scmanager = _scmanager;
	state->orig.in.info_level = _info_level;
	state->orig.in.type = _type;
	state->orig.in.state = _state;
	state->orig.in.offered = _offered;
	state->orig.in.resume_handle = _resume_handle;
	state->orig.in.group_name = _group_name;

	/* Out parameters */
	state->orig.out.services = _services;
	state->orig.out.needed = _needed;
	state->orig.out.service_returned = _service_returned;
	state->orig.out.resume_handle = _resume_handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_EnumServicesStatusExW_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_EnumServicesStatusExW_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_EnumServicesStatusExW_done, req);
	return req;
}

static void dcerpc_EnumServicesStatusExW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_EnumServicesStatusExW_state *state = tevent_req_data(
		req, struct dcerpc_EnumServicesStatusExW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_EnumServicesStatusExW_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_services;
		_copy_len_services = state->tmp.in.offered;
		memcpy(state->orig.out.services, state->tmp.out.services, _copy_len_services * sizeof(*state->orig.out.services));
	}
	*state->orig.out.needed = *state->tmp.out.needed;
	*state->orig.out.service_returned = *state->tmp.out.service_returned;
	if (state->orig.out.resume_handle && state->tmp.out.resume_handle) {
		*state->orig.out.resume_handle = *state->tmp.out.resume_handle;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_EnumServicesStatusExW_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_EnumServicesStatusExW_state *state = tevent_req_data(
		req, struct dcerpc_EnumServicesStatusExW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_EnumServicesStatusExW(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *_scmanager /* [in] [ref] */,
				      uint32_t _info_level /* [in]  */,
				      uint32_t _type /* [in]  */,
				      enum svcctl_ServiceState _state /* [in]  */,
				      uint8_t *_services /* [out] [ref,size_is(offered)] */,
				      uint32_t _offered /* [in] [range(0,0x40000)] */,
				      uint32_t *_needed /* [out] [range(0,0x40000),ref] */,
				      uint32_t *_service_returned /* [out] [ref,range(0,0x40000)] */,
				      uint32_t *_resume_handle /* [in,out] [range(0,0x40000),unique] */,
				      const char *_group_name /* [in] [unique,charset(UTF16)] */,
				      WERROR *result)
{
	struct EnumServicesStatusExW r;
	NTSTATUS status;

	/* In parameters */
	r.in.scmanager = _scmanager;
	r.in.info_level = _info_level;
	r.in.type = _type;
	r.in.state = _state;
	r.in.offered = _offered;
	r.in.resume_handle = _resume_handle;
	r.in.group_name = _group_name;

	/* Out parameters */
	r.out.services = _services;
	r.out.needed = _needed;
	r.out.service_returned = _service_returned;
	r.out.resume_handle = _resume_handle;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_EnumServicesStatusExW_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_services;
		_copy_len_services = r.in.offered;
		memcpy(_services, r.out.services, _copy_len_services * sizeof(*_services));
	}
	*_needed = *r.out.needed;
	*_service_returned = *r.out.service_returned;
	if (_resume_handle && r.out.resume_handle) {
		*_resume_handle = *r.out.resume_handle;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

