
/* Python wrapper functions auto-generated by pidl */
#include <Python.h>
#include "includes.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "autoconf/librpc/gen_ndr/ndr_atsvc.h"
#include "autoconf/librpc/gen_ndr/ndr_atsvc_c.h"

staticforward PyTypeObject atsvc_JobInfo_Type;
staticforward PyTypeObject atsvc_JobEnumInfo_Type;
staticforward PyTypeObject atsvc_enum_ctr_Type;
staticforward PyTypeObject atsvc_InterfaceType;

void initatsvc(void);static PyTypeObject *ClientConnection_Type;
static PyTypeObject *Object_Type;

static PyObject *py_atsvc_JobInfo_get_job_time(PyObject *obj, void *closure)
{
	struct atsvc_JobInfo *object = (struct atsvc_JobInfo *)pytalloc_get_ptr(obj);
	PyObject *py_job_time;
	py_job_time = PyInt_FromLong(object->job_time);
	return py_job_time;
}

static int py_atsvc_JobInfo_set_job_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct atsvc_JobInfo *object = (struct atsvc_JobInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->job_time = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_atsvc_JobInfo_get_days_of_month(PyObject *obj, void *closure)
{
	struct atsvc_JobInfo *object = (struct atsvc_JobInfo *)pytalloc_get_ptr(obj);
	PyObject *py_days_of_month;
	py_days_of_month = PyInt_FromLong(object->days_of_month);
	return py_days_of_month;
}

static int py_atsvc_JobInfo_set_days_of_month(PyObject *py_obj, PyObject *value, void *closure)
{
	struct atsvc_JobInfo *object = (struct atsvc_JobInfo *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->days_of_month = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->days_of_month = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_atsvc_JobInfo_get_days_of_week(PyObject *obj, void *closure)
{
	struct atsvc_JobInfo *object = (struct atsvc_JobInfo *)pytalloc_get_ptr(obj);
	PyObject *py_days_of_week;
	py_days_of_week = PyInt_FromLong(object->days_of_week);
	return py_days_of_week;
}

static int py_atsvc_JobInfo_set_days_of_week(PyObject *py_obj, PyObject *value, void *closure)
{
	struct atsvc_JobInfo *object = (struct atsvc_JobInfo *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->days_of_week = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->days_of_week = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_atsvc_JobInfo_get_flags(PyObject *obj, void *closure)
{
	struct atsvc_JobInfo *object = (struct atsvc_JobInfo *)pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyInt_FromLong(object->flags);
	return py_flags;
}

static int py_atsvc_JobInfo_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct atsvc_JobInfo *object = (struct atsvc_JobInfo *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->flags = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->flags = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_atsvc_JobInfo_get_command(PyObject *obj, void *closure)
{
	struct atsvc_JobInfo *object = (struct atsvc_JobInfo *)pytalloc_get_ptr(obj);
	PyObject *py_command;
	if (object->command == NULL) {
		py_command = Py_None;
		Py_INCREF(py_command);
	} else {
		if (object->command == NULL) {
			py_command = Py_None;
			Py_INCREF(py_command);
		} else {
			py_command = PyUnicode_Decode(object->command, strlen(object->command), "utf-8", "ignore");
		}
	}
	return py_command;
}

static int py_atsvc_JobInfo_set_command(PyObject *py_obj, PyObject *value, void *closure)
{
	struct atsvc_JobInfo *object = (struct atsvc_JobInfo *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->command = NULL;
	} else {
		object->command = NULL;
		if (PyUnicode_Check(value)) {
			object->command = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->command = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_atsvc_JobInfo_getsetters[] = {
	{ discard_const_p(char, "job_time"), py_atsvc_JobInfo_get_job_time, py_atsvc_JobInfo_set_job_time },
	{ discard_const_p(char, "days_of_month"), py_atsvc_JobInfo_get_days_of_month, py_atsvc_JobInfo_set_days_of_month },
	{ discard_const_p(char, "days_of_week"), py_atsvc_JobInfo_get_days_of_week, py_atsvc_JobInfo_set_days_of_week },
	{ discard_const_p(char, "flags"), py_atsvc_JobInfo_get_flags, py_atsvc_JobInfo_set_flags },
	{ discard_const_p(char, "command"), py_atsvc_JobInfo_get_command, py_atsvc_JobInfo_set_command },
	{ NULL }
};

static PyObject *py_atsvc_JobInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct atsvc_JobInfo, type);
}


static PyTypeObject atsvc_JobInfo_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "atsvc.JobInfo",
	.tp_getset = py_atsvc_JobInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_atsvc_JobInfo_new,
};


static PyObject *py_atsvc_JobEnumInfo_get_job_id(PyObject *obj, void *closure)
{
	struct atsvc_JobEnumInfo *object = (struct atsvc_JobEnumInfo *)pytalloc_get_ptr(obj);
	PyObject *py_job_id;
	py_job_id = PyInt_FromLong(object->job_id);
	return py_job_id;
}

static int py_atsvc_JobEnumInfo_set_job_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct atsvc_JobEnumInfo *object = (struct atsvc_JobEnumInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->job_id = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_atsvc_JobEnumInfo_get_job_time(PyObject *obj, void *closure)
{
	struct atsvc_JobEnumInfo *object = (struct atsvc_JobEnumInfo *)pytalloc_get_ptr(obj);
	PyObject *py_job_time;
	py_job_time = PyInt_FromLong(object->job_time);
	return py_job_time;
}

static int py_atsvc_JobEnumInfo_set_job_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct atsvc_JobEnumInfo *object = (struct atsvc_JobEnumInfo *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->job_time = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_atsvc_JobEnumInfo_get_days_of_month(PyObject *obj, void *closure)
{
	struct atsvc_JobEnumInfo *object = (struct atsvc_JobEnumInfo *)pytalloc_get_ptr(obj);
	PyObject *py_days_of_month;
	py_days_of_month = PyInt_FromLong(object->days_of_month);
	return py_days_of_month;
}

static int py_atsvc_JobEnumInfo_set_days_of_month(PyObject *py_obj, PyObject *value, void *closure)
{
	struct atsvc_JobEnumInfo *object = (struct atsvc_JobEnumInfo *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->days_of_month = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->days_of_month = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_atsvc_JobEnumInfo_get_days_of_week(PyObject *obj, void *closure)
{
	struct atsvc_JobEnumInfo *object = (struct atsvc_JobEnumInfo *)pytalloc_get_ptr(obj);
	PyObject *py_days_of_week;
	py_days_of_week = PyInt_FromLong(object->days_of_week);
	return py_days_of_week;
}

static int py_atsvc_JobEnumInfo_set_days_of_week(PyObject *py_obj, PyObject *value, void *closure)
{
	struct atsvc_JobEnumInfo *object = (struct atsvc_JobEnumInfo *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->days_of_week = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->days_of_week = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_atsvc_JobEnumInfo_get_flags(PyObject *obj, void *closure)
{
	struct atsvc_JobEnumInfo *object = (struct atsvc_JobEnumInfo *)pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyInt_FromLong(object->flags);
	return py_flags;
}

static int py_atsvc_JobEnumInfo_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct atsvc_JobEnumInfo *object = (struct atsvc_JobEnumInfo *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->flags = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->flags = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_atsvc_JobEnumInfo_get_command(PyObject *obj, void *closure)
{
	struct atsvc_JobEnumInfo *object = (struct atsvc_JobEnumInfo *)pytalloc_get_ptr(obj);
	PyObject *py_command;
	if (object->command == NULL) {
		py_command = Py_None;
		Py_INCREF(py_command);
	} else {
		if (object->command == NULL) {
			py_command = Py_None;
			Py_INCREF(py_command);
		} else {
			py_command = PyUnicode_Decode(object->command, strlen(object->command), "utf-8", "ignore");
		}
	}
	return py_command;
}

static int py_atsvc_JobEnumInfo_set_command(PyObject *py_obj, PyObject *value, void *closure)
{
	struct atsvc_JobEnumInfo *object = (struct atsvc_JobEnumInfo *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->command = NULL;
	} else {
		object->command = NULL;
		if (PyUnicode_Check(value)) {
			object->command = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->command = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_atsvc_JobEnumInfo_getsetters[] = {
	{ discard_const_p(char, "job_id"), py_atsvc_JobEnumInfo_get_job_id, py_atsvc_JobEnumInfo_set_job_id },
	{ discard_const_p(char, "job_time"), py_atsvc_JobEnumInfo_get_job_time, py_atsvc_JobEnumInfo_set_job_time },
	{ discard_const_p(char, "days_of_month"), py_atsvc_JobEnumInfo_get_days_of_month, py_atsvc_JobEnumInfo_set_days_of_month },
	{ discard_const_p(char, "days_of_week"), py_atsvc_JobEnumInfo_get_days_of_week, py_atsvc_JobEnumInfo_set_days_of_week },
	{ discard_const_p(char, "flags"), py_atsvc_JobEnumInfo_get_flags, py_atsvc_JobEnumInfo_set_flags },
	{ discard_const_p(char, "command"), py_atsvc_JobEnumInfo_get_command, py_atsvc_JobEnumInfo_set_command },
	{ NULL }
};

static PyObject *py_atsvc_JobEnumInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct atsvc_JobEnumInfo, type);
}


static PyTypeObject atsvc_JobEnumInfo_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "atsvc.JobEnumInfo",
	.tp_getset = py_atsvc_JobEnumInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_atsvc_JobEnumInfo_new,
};


static PyObject *py_atsvc_enum_ctr_get_entries_read(PyObject *obj, void *closure)
{
	struct atsvc_enum_ctr *object = (struct atsvc_enum_ctr *)pytalloc_get_ptr(obj);
	PyObject *py_entries_read;
	py_entries_read = PyInt_FromLong(object->entries_read);
	return py_entries_read;
}

static int py_atsvc_enum_ctr_set_entries_read(PyObject *py_obj, PyObject *value, void *closure)
{
	struct atsvc_enum_ctr *object = (struct atsvc_enum_ctr *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->entries_read = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_atsvc_enum_ctr_get_first_entry(PyObject *obj, void *closure)
{
	struct atsvc_enum_ctr *object = (struct atsvc_enum_ctr *)pytalloc_get_ptr(obj);
	PyObject *py_first_entry;
	if (object->first_entry == NULL) {
		py_first_entry = Py_None;
		Py_INCREF(py_first_entry);
	} else {
		py_first_entry = PyList_New(object->entries_read);
		if (py_first_entry == NULL) {
			return NULL;
		}
		{
			int first_entry_cntr_1;
			for (first_entry_cntr_1 = 0; first_entry_cntr_1 < object->entries_read; first_entry_cntr_1++) {
				PyObject *py_first_entry_1;
				py_first_entry_1 = pytalloc_reference_ex(&atsvc_JobEnumInfo_Type, object->first_entry, &object->first_entry[first_entry_cntr_1]);
				PyList_SetItem(py_first_entry, first_entry_cntr_1, py_first_entry_1);
			}
		}
	}
	return py_first_entry;
}

static int py_atsvc_enum_ctr_set_first_entry(PyObject *py_obj, PyObject *value, void *closure)
{
	struct atsvc_enum_ctr *object = (struct atsvc_enum_ctr *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->first_entry);
	if (value == Py_None) {
		object->first_entry = NULL;
	} else {
		object->first_entry = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int first_entry_cntr_1;
			object->first_entry = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->first_entry, PyList_GET_SIZE(value));
			if (!object->first_entry) { return -1;; }
			talloc_set_name_const(object->first_entry, "ARRAY: object->first_entry");
			for (first_entry_cntr_1 = 0; first_entry_cntr_1 < PyList_GET_SIZE(value); first_entry_cntr_1++) {
				PY_CHECK_TYPE(&atsvc_JobEnumInfo_Type, PyList_GET_ITEM(value, first_entry_cntr_1), return -1;);
				if (talloc_reference(object->first_entry, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, first_entry_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				object->first_entry[first_entry_cntr_1] = *(struct atsvc_JobEnumInfo *)pytalloc_get_ptr(PyList_GET_ITEM(value, first_entry_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_atsvc_enum_ctr_getsetters[] = {
	{ discard_const_p(char, "entries_read"), py_atsvc_enum_ctr_get_entries_read, py_atsvc_enum_ctr_set_entries_read },
	{ discard_const_p(char, "first_entry"), py_atsvc_enum_ctr_get_first_entry, py_atsvc_enum_ctr_set_first_entry },
	{ NULL }
};

static PyObject *py_atsvc_enum_ctr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct atsvc_enum_ctr, type);
}


static PyTypeObject atsvc_enum_ctr_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "atsvc.enum_ctr",
	.tp_getset = py_atsvc_enum_ctr_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_atsvc_enum_ctr_new,
};


static bool pack_py_atsvc_JobAdd_args_in(PyObject *args, PyObject *kwargs, struct atsvc_JobAdd *r)
{
	PyObject *py_servername;
	PyObject *py_job_info;
	const char *kwnames[] = {
		"servername", "job_info", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:atsvc_JobAdd", discard_const_p(char *, kwnames), &py_servername, &py_job_info)) {
		return false;
	}

	if (py_servername == Py_None) {
		r->in.servername = NULL;
	} else {
		r->in.servername = NULL;
		if (PyUnicode_Check(py_servername)) {
			r->in.servername = PyString_AS_STRING(PyUnicode_AsEncodedString(py_servername, "utf-8", "ignore"));
		} else if (PyString_Check(py_servername)) {
			r->in.servername = PyString_AS_STRING(py_servername);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_servername)->tp_name);
			return false;
		}
	}
	r->in.job_info = talloc_ptrtype(r, r->in.job_info);
	PY_CHECK_TYPE(&atsvc_JobInfo_Type, py_job_info, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_job_info)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.job_info = (struct atsvc_JobInfo *)pytalloc_get_ptr(py_job_info);
	return true;
}

static PyObject *unpack_py_atsvc_JobAdd_args_out(struct atsvc_JobAdd *r)
{
	PyObject *result;
	PyObject *py_job_id;
	py_job_id = PyInt_FromLong(*r->out.job_id);
	result = py_job_id;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_atsvc_JobDel_args_in(PyObject *args, PyObject *kwargs, struct atsvc_JobDel *r)
{
	PyObject *py_servername;
	PyObject *py_min_job_id;
	PyObject *py_max_job_id;
	const char *kwnames[] = {
		"servername", "min_job_id", "max_job_id", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:atsvc_JobDel", discard_const_p(char *, kwnames), &py_servername, &py_min_job_id, &py_max_job_id)) {
		return false;
	}

	if (py_servername == Py_None) {
		r->in.servername = NULL;
	} else {
		r->in.servername = NULL;
		if (PyUnicode_Check(py_servername)) {
			r->in.servername = PyString_AS_STRING(PyUnicode_AsEncodedString(py_servername, "utf-8", "ignore"));
		} else if (PyString_Check(py_servername)) {
			r->in.servername = PyString_AS_STRING(py_servername);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_servername)->tp_name);
			return false;
		}
	}
	PY_CHECK_TYPE(&PyInt_Type, py_min_job_id, return false;);
	r->in.min_job_id = PyInt_AsLong(py_min_job_id);
	PY_CHECK_TYPE(&PyInt_Type, py_max_job_id, return false;);
	r->in.max_job_id = PyInt_AsLong(py_max_job_id);
	return true;
}

static PyObject *unpack_py_atsvc_JobDel_args_out(struct atsvc_JobDel *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_atsvc_JobEnum_args_in(PyObject *args, PyObject *kwargs, struct atsvc_JobEnum *r)
{
	PyObject *py_servername;
	PyObject *py_ctr;
	PyObject *py_preferred_max_len;
	PyObject *py_resume_handle;
	const char *kwnames[] = {
		"servername", "ctr", "preferred_max_len", "resume_handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:atsvc_JobEnum", discard_const_p(char *, kwnames), &py_servername, &py_ctr, &py_preferred_max_len, &py_resume_handle)) {
		return false;
	}

	if (py_servername == Py_None) {
		r->in.servername = NULL;
	} else {
		r->in.servername = NULL;
		if (PyUnicode_Check(py_servername)) {
			r->in.servername = PyString_AS_STRING(PyUnicode_AsEncodedString(py_servername, "utf-8", "ignore"));
		} else if (PyString_Check(py_servername)) {
			r->in.servername = PyString_AS_STRING(py_servername);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_servername)->tp_name);
			return false;
		}
	}
	r->in.ctr = talloc_ptrtype(r, r->in.ctr);
	PY_CHECK_TYPE(&atsvc_enum_ctr_Type, py_ctr, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ctr)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ctr = (struct atsvc_enum_ctr *)pytalloc_get_ptr(py_ctr);
	PY_CHECK_TYPE(&PyInt_Type, py_preferred_max_len, return false;);
	r->in.preferred_max_len = PyInt_AsLong(py_preferred_max_len);
	if (py_resume_handle == Py_None) {
		r->in.resume_handle = NULL;
	} else {
		r->in.resume_handle = talloc_ptrtype(r, r->in.resume_handle);
		PY_CHECK_TYPE(&PyInt_Type, py_resume_handle, return false;);
		*r->in.resume_handle = PyInt_AsLong(py_resume_handle);
	}
	return true;
}

static PyObject *unpack_py_atsvc_JobEnum_args_out(struct atsvc_JobEnum *r)
{
	PyObject *result;
	PyObject *py_ctr;
	PyObject *py_total_entries;
	PyObject *py_resume_handle;
	result = PyTuple_New(3);
	py_ctr = pytalloc_reference_ex(&atsvc_enum_ctr_Type, r->out.ctr, r->out.ctr);
	PyTuple_SetItem(result, 0, py_ctr);
	py_total_entries = PyInt_FromLong(*r->out.total_entries);
	PyTuple_SetItem(result, 1, py_total_entries);
	if (r->out.resume_handle == NULL) {
		py_resume_handle = Py_None;
		Py_INCREF(py_resume_handle);
	} else {
		py_resume_handle = PyInt_FromLong(*r->out.resume_handle);
	}
	PyTuple_SetItem(result, 2, py_resume_handle);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_atsvc_JobGetInfo_args_in(PyObject *args, PyObject *kwargs, struct atsvc_JobGetInfo *r)
{
	PyObject *py_servername;
	PyObject *py_job_id;
	const char *kwnames[] = {
		"servername", "job_id", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:atsvc_JobGetInfo", discard_const_p(char *, kwnames), &py_servername, &py_job_id)) {
		return false;
	}

	if (py_servername == Py_None) {
		r->in.servername = NULL;
	} else {
		r->in.servername = NULL;
		if (PyUnicode_Check(py_servername)) {
			r->in.servername = PyString_AS_STRING(PyUnicode_AsEncodedString(py_servername, "utf-8", "ignore"));
		} else if (PyString_Check(py_servername)) {
			r->in.servername = PyString_AS_STRING(py_servername);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_servername)->tp_name);
			return false;
		}
	}
	PY_CHECK_TYPE(&PyInt_Type, py_job_id, return false;);
	r->in.job_id = PyInt_AsLong(py_job_id);
	return true;
}

static PyObject *unpack_py_atsvc_JobGetInfo_args_out(struct atsvc_JobGetInfo *r)
{
	PyObject *result;
	PyObject *py_job_info;
	if (*r->out.job_info == NULL) {
		py_job_info = Py_None;
		Py_INCREF(py_job_info);
	} else {
		py_job_info = pytalloc_reference_ex(&atsvc_JobInfo_Type, *r->out.job_info, *r->out.job_info);
	}
	result = py_job_info;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

const struct PyNdrRpcMethodDef py_ndr_atsvc_methods[] = {
	{ "JobAdd", "S.JobAdd(servername, job_info) -> job_id", (py_dcerpc_call_fn)dcerpc_atsvc_JobAdd_r, (py_data_pack_fn)pack_py_atsvc_JobAdd_args_in, (py_data_unpack_fn)unpack_py_atsvc_JobAdd_args_out, 0, &ndr_table_atsvc },
	{ "JobDel", "S.JobDel(servername, min_job_id, max_job_id) -> None", (py_dcerpc_call_fn)dcerpc_atsvc_JobDel_r, (py_data_pack_fn)pack_py_atsvc_JobDel_args_in, (py_data_unpack_fn)unpack_py_atsvc_JobDel_args_out, 1, &ndr_table_atsvc },
	{ "JobEnum", "S.JobEnum(servername, ctr, preferred_max_len, resume_handle) -> (ctr, total_entries, resume_handle)", (py_dcerpc_call_fn)dcerpc_atsvc_JobEnum_r, (py_data_pack_fn)pack_py_atsvc_JobEnum_args_in, (py_data_unpack_fn)unpack_py_atsvc_JobEnum_args_out, 2, &ndr_table_atsvc },
	{ "JobGetInfo", "S.JobGetInfo(servername, job_id) -> job_info", (py_dcerpc_call_fn)dcerpc_atsvc_JobGetInfo_r, (py_data_pack_fn)pack_py_atsvc_JobGetInfo_args_in, (py_data_unpack_fn)unpack_py_atsvc_JobGetInfo_args_out, 3, &ndr_table_atsvc },
	{ NULL }
};

static PyObject *interface_atsvc_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_atsvc);
}

#define PY_DOC_ATSVC "Microsoft AT-Scheduler Service"
static PyTypeObject atsvc_InterfaceType = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "atsvc.atsvc",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "atsvc(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n"PY_DOC_ATSVC,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_atsvc_new,
};

static PyMethodDef atsvc_methods[] = {
	{ NULL, NULL, 0, NULL }
};

void initatsvc(void)
{
	PyObject *m;
	PyObject *dep_talloc;
	PyObject *dep_samba_dcerpc_base;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		return;

	dep_samba_dcerpc_base = PyImport_ImportModule("samba.dcerpc.base");
	if (dep_samba_dcerpc_base == NULL)
		return;

	ClientConnection_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_base, "ClientConnection");
	if (ClientConnection_Type == NULL)
		return;

	Object_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "Object");
	if (Object_Type == NULL)
		return;

	atsvc_JobInfo_Type.tp_base = Object_Type;

	atsvc_JobEnumInfo_Type.tp_base = Object_Type;

	atsvc_enum_ctr_Type.tp_base = Object_Type;

	atsvc_InterfaceType.tp_base = ClientConnection_Type;

	if (PyType_Ready(&atsvc_JobInfo_Type) < 0)
		return;
	if (PyType_Ready(&atsvc_JobEnumInfo_Type) < 0)
		return;
	if (PyType_Ready(&atsvc_enum_ctr_Type) < 0)
		return;
	if (PyType_Ready(&atsvc_InterfaceType) < 0)
		return;
	if (!PyInterface_AddNdrRpcMethods(&atsvc_InterfaceType, py_ndr_atsvc_methods))
		return;

#ifdef PY_JOBINFO_PATCH
	PY_JOBINFO_PATCH(&atsvc_JobInfo_Type);
#endif
#ifdef PY_JOBENUMINFO_PATCH
	PY_JOBENUMINFO_PATCH(&atsvc_JobEnumInfo_Type);
#endif
#ifdef PY_ENUM_CTR_PATCH
	PY_ENUM_CTR_PATCH(&atsvc_enum_ctr_Type);
#endif
#ifdef PY_ATSVC_PATCH
	PY_ATSVC_PATCH(&atsvc_InterfaceType);
#endif

	m = Py_InitModule3("atsvc", atsvc_methods, "atsvc DCE/RPC");
	if (m == NULL)
		return;

	PyModule_AddObject(m, "Eighteenth", PyInt_FromLong(Eighteenth));
	PyModule_AddObject(m, "Twentysecond", PyInt_FromLong(Twentysecond));
	PyModule_AddObject(m, "JOB_RUN_PERIODICALLY", PyInt_FromLong(JOB_RUN_PERIODICALLY));
	PyModule_AddObject(m, "Eight", PyInt_FromLong(Eight));
	PyModule_AddObject(m, "Fifth", PyInt_FromLong(Fifth));
	PyModule_AddObject(m, "First", PyInt_FromLong(First));
	PyModule_AddObject(m, "Ninth", PyInt_FromLong(Ninth));
	PyModule_AddObject(m, "DAYSOFWEEK_MONDAY", PyInt_FromLong(DAYSOFWEEK_MONDAY));
	PyModule_AddObject(m, "Twentyninth", PyInt_FromLong(Twentyninth));
	PyModule_AddObject(m, "Twentyeighth", PyInt_FromLong(Twentyeighth));
	PyModule_AddObject(m, "JOB_NONINTERACTIVE", PyInt_FromLong(JOB_NONINTERACTIVE));
	PyModule_AddObject(m, "DAYSOFWEEK_WEDNESDAY", PyInt_FromLong(DAYSOFWEEK_WEDNESDAY));
	PyModule_AddObject(m, "Twentyfirst", PyInt_FromLong(Twentyfirst));
	PyModule_AddObject(m, "Thitteenth", PyInt_FromLong(Thitteenth));
	PyModule_AddObject(m, "DAYSOFWEEK_FRIDAY", PyInt_FromLong(DAYSOFWEEK_FRIDAY));
	PyModule_AddObject(m, "Thirtieth", PyInt_FromLong(Thirtieth));
	PyModule_AddObject(m, "DAYSOFWEEK_SATURDAY", PyInt_FromLong(DAYSOFWEEK_SATURDAY));
	PyModule_AddObject(m, "DAYSOFWEEK_TUESDAY", PyInt_FromLong(DAYSOFWEEK_TUESDAY));
	PyModule_AddObject(m, "Third", PyInt_FromLong(Third));
	PyModule_AddObject(m, "Twentyfifth", PyInt_FromLong(Twentyfifth));
	PyModule_AddObject(m, "Sixth", PyInt_FromLong(Sixth));
	PyModule_AddObject(m, "Ninteenth", PyInt_FromLong(Ninteenth));
	PyModule_AddObject(m, "JOB_RUNS_TODAY", PyInt_FromLong(JOB_RUNS_TODAY));
	PyModule_AddObject(m, "Sixteenth", PyInt_FromLong(Sixteenth));
	PyModule_AddObject(m, "Fourth", PyInt_FromLong(Fourth));
	PyModule_AddObject(m, "Twentyseventh", PyInt_FromLong(Twentyseventh));
	PyModule_AddObject(m, "DAYSOFWEEK_SUNDAY", PyInt_FromLong(DAYSOFWEEK_SUNDAY));
	PyModule_AddObject(m, "Seventeenth", PyInt_FromLong(Seventeenth));
	PyModule_AddObject(m, "Twentyth", PyInt_FromLong(Twentyth));
	PyModule_AddObject(m, "Thirtyfirst", PyInt_FromLong(Thirtyfirst));
	PyModule_AddObject(m, "Twentythird", PyInt_FromLong(Twentythird));
	PyModule_AddObject(m, "Fourteenth", PyInt_FromLong(Fourteenth));
	PyModule_AddObject(m, "Twelfth", PyInt_FromLong(Twelfth));
	PyModule_AddObject(m, "Fifteenth", PyInt_FromLong(Fifteenth));
	PyModule_AddObject(m, "DAYSOFWEEK_THURSDAY", PyInt_FromLong(DAYSOFWEEK_THURSDAY));
	PyModule_AddObject(m, "Tenth", PyInt_FromLong(Tenth));
	PyModule_AddObject(m, "Eleventh", PyInt_FromLong(Eleventh));
	PyModule_AddObject(m, "Second", PyInt_FromLong(Second));
	PyModule_AddObject(m, "JOB_EXEC_ERROR", PyInt_FromLong(JOB_EXEC_ERROR));
	PyModule_AddObject(m, "Twentysixth", PyInt_FromLong(Twentysixth));
	PyModule_AddObject(m, "Seventh", PyInt_FromLong(Seventh));
	PyModule_AddObject(m, "Twentyfourth", PyInt_FromLong(Twentyfourth));
	PyModule_AddObject(m, "JOB_ADD_CURRENT_DATE", PyInt_FromLong(JOB_ADD_CURRENT_DATE));
	Py_INCREF((PyObject *)(void *)&atsvc_JobInfo_Type);
	PyModule_AddObject(m, "JobInfo", (PyObject *)(void *)&atsvc_JobInfo_Type);
	Py_INCREF((PyObject *)(void *)&atsvc_JobEnumInfo_Type);
	PyModule_AddObject(m, "JobEnumInfo", (PyObject *)(void *)&atsvc_JobEnumInfo_Type);
	Py_INCREF((PyObject *)(void *)&atsvc_enum_ctr_Type);
	PyModule_AddObject(m, "enum_ctr", (PyObject *)(void *)&atsvc_enum_ctr_Type);
	Py_INCREF((PyObject *)(void *)&atsvc_InterfaceType);
	PyModule_AddObject(m, "atsvc", (PyObject *)(void *)&atsvc_InterfaceType);
#ifdef PY_MOD_ATSVC_PATCH
	PY_MOD_ATSVC_PATCH(m);
#endif

}
