
/* Python wrapper functions auto-generated by pidl */
#include <Python.h>
#include "includes.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "autoconf/librpc/gen_ndr/ndr_dnsserver.h"
#include "autoconf/librpc/gen_ndr/ndr_dnsserver_c.h"

#include "librpc/gen_ndr/misc.h"
#include "librpc/gen_ndr/dnsp.h"
staticforward PyTypeObject DNS_RPC_BUFFER_Type;
staticforward PyTypeObject DNS_RPC_UTF8_STRING_LIST_Type;
staticforward PyTypeObject DNS_RPC_NAME_AND_PARAM_Type;
staticforward PyTypeObject DNS_RPC_NAME_Type;
staticforward PyTypeObject DNS_RPC_NODE_Type;
staticforward PyTypeObject DNS_RPC_RECORD_SOA_Type;
staticforward PyTypeObject DNS_RPC_RECORD_NAME_PREFERENCE_Type;
staticforward PyTypeObject DNS_RPC_RECORD_STRING_Type;
staticforward PyTypeObject DNS_RPC_RECORD_SRV_Type;
staticforward PyTypeObject DNS_RPC_RECORD_Type;
staticforward PyTypeObject DNS_RPC_RECORD_BUF_Type;
staticforward PyTypeObject IP4_ARRAY_Type;
staticforward PyTypeObject DNS_ADDR_Type;
staticforward PyTypeObject DNS_ADDR_ARRAY_Type;
staticforward PyTypeObject DNS_RPC_IP_VALIDATE_Type;
staticforward PyTypeObject DNS_RPC_SERVER_INFO_W2K_Type;
staticforward PyTypeObject DNS_EXTENSION_Type;
staticforward PyTypeObject DNS_RPC_SERVER_INFO_DOTNET_Type;
staticforward PyTypeObject DNS_RPC_SERVER_INFO_LONGHORN_Type;
staticforward PyTypeObject DNS_RPC_DP_REPLICA_Type;
staticforward PyTypeObject DNS_RPC_DP_INFO_Type;
staticforward PyTypeObject DNS_RPC_DP_ENUM_Type;
staticforward PyTypeObject DNS_RPC_DP_LIST_Type;
staticforward PyTypeObject DNS_RPC_ENLIST_DP_Type;
staticforward PyTypeObject DNS_RPC_ZONE_CHANGE_DP_Type;
staticforward PyTypeObject DNS_RPC_ZONE_W2K_Type;
staticforward PyTypeObject DNS_RPC_ZONE_DOTNET_Type;
staticforward PyTypeObject DNS_RPC_ZONE_LIST_W2K_Type;
staticforward PyTypeObject DNS_RPC_ZONE_LIST_DOTNET_Type;
staticforward PyTypeObject DNS_RPC_ZONE_INFO_W2K_Type;
staticforward PyTypeObject DNS_RPC_ZONE_INFO_DOTNET_Type;
staticforward PyTypeObject DNS_RPC_ZONE_INFO_LONGHORN_Type;
staticforward PyTypeObject DNS_RPC_ZONE_SECONDARIES_W2K_Type;
staticforward PyTypeObject DNS_RPC_ZONE_SECONDARIES_DOTNET_Type;
staticforward PyTypeObject DNS_RPC_ZONE_SECONDARIES_LONGHORN_Type;
staticforward PyTypeObject DNS_RPC_ZONE_DATABASE_W2K_Type;
staticforward PyTypeObject DNS_RPC_ZONE_DATABASE_DOTNET_Type;
staticforward PyTypeObject DNS_RPC_ZONE_CREATE_INFO_W2K_Type;
staticforward PyTypeObject DNS_RPC_ZONE_CREATE_INFO_DOTNET_Type;
staticforward PyTypeObject DNS_RPC_ZONE_CREATE_INFO_LONGHORN_Type;
staticforward PyTypeObject DNS_RPC_ZONE_EXPORT_INFO_Type;
staticforward PyTypeObject DNS_RPC_ENUM_ZONES_FILTER_Type;
staticforward PyTypeObject DNS_RPC_FORWARDERS_W2K_Type;
staticforward PyTypeObject DNS_RPC_FORWARDERS_DOTNET_Type;
staticforward PyTypeObject DNS_RPC_FORWARDERS_LONGHORN_Type;
staticforward PyTypeObject DNS_RPC_AUTOCONFIGURE_Type;
staticforward PyTypeObject DNSSRV_STAT_HEADER_Type;
staticforward PyTypeObject DNSSRV_STAT_Type;
staticforward PyTypeObject DNS_RPC_RECORDS_Type;
staticforward PyTypeObject DNS_RPC_RECORDS_ARRAY_Type;
staticforward PyTypeObject dnsserver_InterfaceType;

void initdnsserver(void);static PyTypeObject *ClientConnection_Type;
static PyTypeObject *Object_Type;

static PyObject *py_DNS_RPC_BUFFER_get_dwLength(PyObject *obj, void *closure)
{
	struct DNS_RPC_BUFFER *object = (struct DNS_RPC_BUFFER *)pytalloc_get_ptr(obj);
	PyObject *py_dwLength;
	py_dwLength = PyInt_FromLong(object->dwLength);
	return py_dwLength;
}

static int py_DNS_RPC_BUFFER_set_dwLength(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_BUFFER *object = (struct DNS_RPC_BUFFER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwLength = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_BUFFER_get_Buffer(PyObject *obj, void *closure)
{
	struct DNS_RPC_BUFFER *object = (struct DNS_RPC_BUFFER *)pytalloc_get_ptr(obj);
	PyObject *py_Buffer;
	py_Buffer = PyList_New(object->dwLength);
	if (py_Buffer == NULL) {
		return NULL;
	}
	{
		int Buffer_cntr_0;
		for (Buffer_cntr_0 = 0; Buffer_cntr_0 < object->dwLength; Buffer_cntr_0++) {
			PyObject *py_Buffer_0;
			py_Buffer_0 = PyInt_FromLong(object->Buffer[Buffer_cntr_0]);
			PyList_SetItem(py_Buffer, Buffer_cntr_0, py_Buffer_0);
		}
	}
	return py_Buffer;
}

static int py_DNS_RPC_BUFFER_set_Buffer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_BUFFER *object = (struct DNS_RPC_BUFFER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int Buffer_cntr_0;
		object->Buffer = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->Buffer, PyList_GET_SIZE(value));
		if (!object->Buffer) { return -1;; }
		talloc_set_name_const(object->Buffer, "ARRAY: object->Buffer");
		for (Buffer_cntr_0 = 0; Buffer_cntr_0 < PyList_GET_SIZE(value); Buffer_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, Buffer_cntr_0), return -1;);
			object->Buffer[Buffer_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, Buffer_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_BUFFER_getsetters[] = {
	{ discard_const_p(char, "dwLength"), py_DNS_RPC_BUFFER_get_dwLength, py_DNS_RPC_BUFFER_set_dwLength },
	{ discard_const_p(char, "Buffer"), py_DNS_RPC_BUFFER_get_Buffer, py_DNS_RPC_BUFFER_set_Buffer },
	{ NULL }
};

static PyObject *py_DNS_RPC_BUFFER_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_BUFFER, type);
}


static PyTypeObject DNS_RPC_BUFFER_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.DNS_RPC_BUFFER",
	.tp_getset = py_DNS_RPC_BUFFER_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DNS_RPC_BUFFER_new,
};


static PyObject *py_DNS_RPC_UTF8_STRING_LIST_get_dwCount(PyObject *obj, void *closure)
{
	struct DNS_RPC_UTF8_STRING_LIST *object = (struct DNS_RPC_UTF8_STRING_LIST *)pytalloc_get_ptr(obj);
	PyObject *py_dwCount;
	py_dwCount = PyInt_FromLong(object->dwCount);
	return py_dwCount;
}

static int py_DNS_RPC_UTF8_STRING_LIST_set_dwCount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_UTF8_STRING_LIST *object = (struct DNS_RPC_UTF8_STRING_LIST *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwCount = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_UTF8_STRING_LIST_get_pszStrings(PyObject *obj, void *closure)
{
	struct DNS_RPC_UTF8_STRING_LIST *object = (struct DNS_RPC_UTF8_STRING_LIST *)pytalloc_get_ptr(obj);
	PyObject *py_pszStrings;
	py_pszStrings = PyList_New(object->dwCount);
	if (py_pszStrings == NULL) {
		return NULL;
	}
	{
		int pszStrings_cntr_0;
		for (pszStrings_cntr_0 = 0; pszStrings_cntr_0 < object->dwCount; pszStrings_cntr_0++) {
			PyObject *py_pszStrings_0;
			if (object->pszStrings[pszStrings_cntr_0] == NULL) {
				py_pszStrings_0 = Py_None;
				Py_INCREF(py_pszStrings_0);
			} else {
				if (object->pszStrings[pszStrings_cntr_0] == NULL) {
					py_pszStrings_0 = Py_None;
					Py_INCREF(py_pszStrings_0);
				} else {
					py_pszStrings_0 = PyUnicode_Decode(object->pszStrings[pszStrings_cntr_0], strlen(object->pszStrings[pszStrings_cntr_0]), "utf-8", "ignore");
				}
			}
			PyList_SetItem(py_pszStrings, pszStrings_cntr_0, py_pszStrings_0);
		}
	}
	return py_pszStrings;
}

static int py_DNS_RPC_UTF8_STRING_LIST_set_pszStrings(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_UTF8_STRING_LIST *object = (struct DNS_RPC_UTF8_STRING_LIST *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int pszStrings_cntr_0;
		object->pszStrings = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->pszStrings, PyList_GET_SIZE(value));
		if (!object->pszStrings) { return -1;; }
		talloc_set_name_const(object->pszStrings, "ARRAY: object->pszStrings");
		for (pszStrings_cntr_0 = 0; pszStrings_cntr_0 < PyList_GET_SIZE(value); pszStrings_cntr_0++) {
			if (PyList_GET_ITEM(value, pszStrings_cntr_0) == Py_None) {
				object->pszStrings[pszStrings_cntr_0] = NULL;
			} else {
				object->pszStrings[pszStrings_cntr_0] = NULL;
				if (PyUnicode_Check(PyList_GET_ITEM(value, pszStrings_cntr_0))) {
					object->pszStrings[pszStrings_cntr_0] = PyString_AS_STRING(PyUnicode_AsEncodedString(PyList_GET_ITEM(value, pszStrings_cntr_0), "utf-8", "ignore"));
				} else if (PyString_Check(PyList_GET_ITEM(value, pszStrings_cntr_0))) {
					object->pszStrings[pszStrings_cntr_0] = PyString_AS_STRING(PyList_GET_ITEM(value, pszStrings_cntr_0));
				} else {
					PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(PyList_GET_ITEM(value, pszStrings_cntr_0))->tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_UTF8_STRING_LIST_getsetters[] = {
	{ discard_const_p(char, "dwCount"), py_DNS_RPC_UTF8_STRING_LIST_get_dwCount, py_DNS_RPC_UTF8_STRING_LIST_set_dwCount },
	{ discard_const_p(char, "pszStrings"), py_DNS_RPC_UTF8_STRING_LIST_get_pszStrings, py_DNS_RPC_UTF8_STRING_LIST_set_pszStrings },
	{ NULL }
};

static PyObject *py_DNS_RPC_UTF8_STRING_LIST_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_UTF8_STRING_LIST, type);
}


static PyTypeObject DNS_RPC_UTF8_STRING_LIST_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.DNS_RPC_UTF8_STRING_LIST",
	.tp_getset = py_DNS_RPC_UTF8_STRING_LIST_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DNS_RPC_UTF8_STRING_LIST_new,
};


static PyObject *py_DNS_RPC_NAME_AND_PARAM_get_dwParam(PyObject *obj, void *closure)
{
	struct DNS_RPC_NAME_AND_PARAM *object = (struct DNS_RPC_NAME_AND_PARAM *)pytalloc_get_ptr(obj);
	PyObject *py_dwParam;
	py_dwParam = PyInt_FromLong(object->dwParam);
	return py_dwParam;
}

static int py_DNS_RPC_NAME_AND_PARAM_set_dwParam(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_NAME_AND_PARAM *object = (struct DNS_RPC_NAME_AND_PARAM *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwParam = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_NAME_AND_PARAM_get_pszNodeName(PyObject *obj, void *closure)
{
	struct DNS_RPC_NAME_AND_PARAM *object = (struct DNS_RPC_NAME_AND_PARAM *)pytalloc_get_ptr(obj);
	PyObject *py_pszNodeName;
	if (object->pszNodeName == NULL) {
		py_pszNodeName = Py_None;
		Py_INCREF(py_pszNodeName);
	} else {
		if (object->pszNodeName == NULL) {
			py_pszNodeName = Py_None;
			Py_INCREF(py_pszNodeName);
		} else {
			py_pszNodeName = PyUnicode_Decode(object->pszNodeName, strlen(object->pszNodeName), "utf-8", "ignore");
		}
	}
	return py_pszNodeName;
}

static int py_DNS_RPC_NAME_AND_PARAM_set_pszNodeName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_NAME_AND_PARAM *object = (struct DNS_RPC_NAME_AND_PARAM *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszNodeName = NULL;
	} else {
		object->pszNodeName = NULL;
		if (PyUnicode_Check(value)) {
			object->pszNodeName = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszNodeName = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_NAME_AND_PARAM_getsetters[] = {
	{ discard_const_p(char, "dwParam"), py_DNS_RPC_NAME_AND_PARAM_get_dwParam, py_DNS_RPC_NAME_AND_PARAM_set_dwParam },
	{ discard_const_p(char, "pszNodeName"), py_DNS_RPC_NAME_AND_PARAM_get_pszNodeName, py_DNS_RPC_NAME_AND_PARAM_set_pszNodeName },
	{ NULL }
};

static PyObject *py_DNS_RPC_NAME_AND_PARAM_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_NAME_AND_PARAM, type);
}


static PyTypeObject DNS_RPC_NAME_AND_PARAM_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.DNS_RPC_NAME_AND_PARAM",
	.tp_getset = py_DNS_RPC_NAME_AND_PARAM_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DNS_RPC_NAME_AND_PARAM_new,
};


static PyObject *py_DNS_RPC_NAME_get_len(PyObject *obj, void *closure)
{
	struct DNS_RPC_NAME *object = (struct DNS_RPC_NAME *)pytalloc_get_ptr(obj);
	PyObject *py_len;
	py_len = PyInt_FromLong(object->len);
	return py_len;
}

static int py_DNS_RPC_NAME_set_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_NAME *object = (struct DNS_RPC_NAME *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->len = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_NAME_get_str(PyObject *obj, void *closure)
{
	struct DNS_RPC_NAME *object = (struct DNS_RPC_NAME *)pytalloc_get_ptr(obj);
	PyObject *py_str;
	if (object->str == NULL) {
		py_str = Py_None;
		Py_INCREF(py_str);
	} else {
		py_str = PyUnicode_Decode(object->str, strlen(object->str), "utf-8", "ignore");
	}
	return py_str;
}

static int py_DNS_RPC_NAME_set_str(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_NAME *object = (struct DNS_RPC_NAME *)pytalloc_get_ptr(py_obj);
	if (PyUnicode_Check(value)) {
		object->str = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	} else if (PyString_Check(value)) {
		object->str = PyString_AS_STRING(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
		return -1;
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_NAME_getsetters[] = {
	{ discard_const_p(char, "len"), py_DNS_RPC_NAME_get_len, py_DNS_RPC_NAME_set_len },
	{ discard_const_p(char, "str"), py_DNS_RPC_NAME_get_str, py_DNS_RPC_NAME_set_str },
	{ NULL }
};

static PyObject *py_DNS_RPC_NAME_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_NAME, type);
}

static PyObject *py_DNS_RPC_NAME_ndr_pack(PyObject *py_obj)
{
	struct DNS_RPC_NAME *object = (struct DNS_RPC_NAME *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_DNS_RPC_NAME);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_DNS_RPC_NAME_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct DNS_RPC_NAME *object = (struct DNS_RPC_NAME *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_DNS_RPC_NAME);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_DNS_RPC_NAME);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_DNS_RPC_NAME_ndr_print(PyObject *py_obj)
{
	struct DNS_RPC_NAME *object = (struct DNS_RPC_NAME *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_DNS_RPC_NAME, "DNS_RPC_NAME", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_DNS_RPC_NAME_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_DNS_RPC_NAME_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_DNS_RPC_NAME_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_DNS_RPC_NAME_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject DNS_RPC_NAME_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.DNS_RPC_NAME",
	.tp_getset = py_DNS_RPC_NAME_getsetters,
	.tp_methods = py_DNS_RPC_NAME_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DNS_RPC_NAME_new,
};


static PyObject *py_DNS_RPC_NODE_get_wLength(PyObject *obj, void *closure)
{
	struct DNS_RPC_NODE *object = (struct DNS_RPC_NODE *)pytalloc_get_ptr(obj);
	PyObject *py_wLength;
	py_wLength = PyInt_FromLong(object->wLength);
	return py_wLength;
}

static int py_DNS_RPC_NODE_set_wLength(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_NODE *object = (struct DNS_RPC_NODE *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->wLength = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_NODE_get_wRecordCount(PyObject *obj, void *closure)
{
	struct DNS_RPC_NODE *object = (struct DNS_RPC_NODE *)pytalloc_get_ptr(obj);
	PyObject *py_wRecordCount;
	py_wRecordCount = PyInt_FromLong(object->wRecordCount);
	return py_wRecordCount;
}

static int py_DNS_RPC_NODE_set_wRecordCount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_NODE *object = (struct DNS_RPC_NODE *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->wRecordCount = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_NODE_get_dwFlags(PyObject *obj, void *closure)
{
	struct DNS_RPC_NODE *object = (struct DNS_RPC_NODE *)pytalloc_get_ptr(obj);
	PyObject *py_dwFlags;
	py_dwFlags = PyInt_FromLong(object->dwFlags);
	return py_dwFlags;
}

static int py_DNS_RPC_NODE_set_dwFlags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_NODE *object = (struct DNS_RPC_NODE *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwFlags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_NODE_get_dwChildCount(PyObject *obj, void *closure)
{
	struct DNS_RPC_NODE *object = (struct DNS_RPC_NODE *)pytalloc_get_ptr(obj);
	PyObject *py_dwChildCount;
	py_dwChildCount = PyInt_FromLong(object->dwChildCount);
	return py_dwChildCount;
}

static int py_DNS_RPC_NODE_set_dwChildCount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_NODE *object = (struct DNS_RPC_NODE *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwChildCount = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_NODE_get_dnsNodeName(PyObject *obj, void *closure)
{
	struct DNS_RPC_NODE *object = (struct DNS_RPC_NODE *)pytalloc_get_ptr(obj);
	PyObject *py_dnsNodeName;
	py_dnsNodeName = pytalloc_reference_ex(&DNS_RPC_NAME_Type, pytalloc_get_mem_ctx(obj), &object->dnsNodeName);
	return py_dnsNodeName;
}

static int py_DNS_RPC_NODE_set_dnsNodeName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_NODE *object = (struct DNS_RPC_NODE *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&DNS_RPC_NAME_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->dnsNodeName = *(struct DNS_RPC_NAME *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_DNS_RPC_NODE_getsetters[] = {
	{ discard_const_p(char, "wLength"), py_DNS_RPC_NODE_get_wLength, py_DNS_RPC_NODE_set_wLength },
	{ discard_const_p(char, "wRecordCount"), py_DNS_RPC_NODE_get_wRecordCount, py_DNS_RPC_NODE_set_wRecordCount },
	{ discard_const_p(char, "dwFlags"), py_DNS_RPC_NODE_get_dwFlags, py_DNS_RPC_NODE_set_dwFlags },
	{ discard_const_p(char, "dwChildCount"), py_DNS_RPC_NODE_get_dwChildCount, py_DNS_RPC_NODE_set_dwChildCount },
	{ discard_const_p(char, "dnsNodeName"), py_DNS_RPC_NODE_get_dnsNodeName, py_DNS_RPC_NODE_set_dnsNodeName },
	{ NULL }
};

static PyObject *py_DNS_RPC_NODE_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_NODE, type);
}


static PyTypeObject DNS_RPC_NODE_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.DNS_RPC_NODE",
	.tp_getset = py_DNS_RPC_NODE_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DNS_RPC_NODE_new,
};


static PyObject *py_DNS_RPC_RECORD_SOA_get_dwSerialNo(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD_SOA *object = (struct DNS_RPC_RECORD_SOA *)pytalloc_get_ptr(obj);
	PyObject *py_dwSerialNo;
	py_dwSerialNo = PyInt_FromLong(object->dwSerialNo);
	return py_dwSerialNo;
}

static int py_DNS_RPC_RECORD_SOA_set_dwSerialNo(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD_SOA *object = (struct DNS_RPC_RECORD_SOA *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwSerialNo = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_RECORD_SOA_get_dwRefresh(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD_SOA *object = (struct DNS_RPC_RECORD_SOA *)pytalloc_get_ptr(obj);
	PyObject *py_dwRefresh;
	py_dwRefresh = PyInt_FromLong(object->dwRefresh);
	return py_dwRefresh;
}

static int py_DNS_RPC_RECORD_SOA_set_dwRefresh(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD_SOA *object = (struct DNS_RPC_RECORD_SOA *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwRefresh = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_RECORD_SOA_get_dwRetry(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD_SOA *object = (struct DNS_RPC_RECORD_SOA *)pytalloc_get_ptr(obj);
	PyObject *py_dwRetry;
	py_dwRetry = PyInt_FromLong(object->dwRetry);
	return py_dwRetry;
}

static int py_DNS_RPC_RECORD_SOA_set_dwRetry(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD_SOA *object = (struct DNS_RPC_RECORD_SOA *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwRetry = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_RECORD_SOA_get_dwExpire(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD_SOA *object = (struct DNS_RPC_RECORD_SOA *)pytalloc_get_ptr(obj);
	PyObject *py_dwExpire;
	py_dwExpire = PyInt_FromLong(object->dwExpire);
	return py_dwExpire;
}

static int py_DNS_RPC_RECORD_SOA_set_dwExpire(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD_SOA *object = (struct DNS_RPC_RECORD_SOA *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwExpire = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_RECORD_SOA_get_dwMinimumTtl(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD_SOA *object = (struct DNS_RPC_RECORD_SOA *)pytalloc_get_ptr(obj);
	PyObject *py_dwMinimumTtl;
	py_dwMinimumTtl = PyInt_FromLong(object->dwMinimumTtl);
	return py_dwMinimumTtl;
}

static int py_DNS_RPC_RECORD_SOA_set_dwMinimumTtl(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD_SOA *object = (struct DNS_RPC_RECORD_SOA *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwMinimumTtl = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_RECORD_SOA_get_NamePrimaryServer(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD_SOA *object = (struct DNS_RPC_RECORD_SOA *)pytalloc_get_ptr(obj);
	PyObject *py_NamePrimaryServer;
	py_NamePrimaryServer = pytalloc_reference_ex(&DNS_RPC_NAME_Type, pytalloc_get_mem_ctx(obj), &object->NamePrimaryServer);
	return py_NamePrimaryServer;
}

static int py_DNS_RPC_RECORD_SOA_set_NamePrimaryServer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD_SOA *object = (struct DNS_RPC_RECORD_SOA *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&DNS_RPC_NAME_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->NamePrimaryServer = *(struct DNS_RPC_NAME *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_DNS_RPC_RECORD_SOA_get_ZoneAdministratorEmail(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD_SOA *object = (struct DNS_RPC_RECORD_SOA *)pytalloc_get_ptr(obj);
	PyObject *py_ZoneAdministratorEmail;
	py_ZoneAdministratorEmail = pytalloc_reference_ex(&DNS_RPC_NAME_Type, pytalloc_get_mem_ctx(obj), &object->ZoneAdministratorEmail);
	return py_ZoneAdministratorEmail;
}

static int py_DNS_RPC_RECORD_SOA_set_ZoneAdministratorEmail(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD_SOA *object = (struct DNS_RPC_RECORD_SOA *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&DNS_RPC_NAME_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->ZoneAdministratorEmail = *(struct DNS_RPC_NAME *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_DNS_RPC_RECORD_SOA_getsetters[] = {
	{ discard_const_p(char, "dwSerialNo"), py_DNS_RPC_RECORD_SOA_get_dwSerialNo, py_DNS_RPC_RECORD_SOA_set_dwSerialNo },
	{ discard_const_p(char, "dwRefresh"), py_DNS_RPC_RECORD_SOA_get_dwRefresh, py_DNS_RPC_RECORD_SOA_set_dwRefresh },
	{ discard_const_p(char, "dwRetry"), py_DNS_RPC_RECORD_SOA_get_dwRetry, py_DNS_RPC_RECORD_SOA_set_dwRetry },
	{ discard_const_p(char, "dwExpire"), py_DNS_RPC_RECORD_SOA_get_dwExpire, py_DNS_RPC_RECORD_SOA_set_dwExpire },
	{ discard_const_p(char, "dwMinimumTtl"), py_DNS_RPC_RECORD_SOA_get_dwMinimumTtl, py_DNS_RPC_RECORD_SOA_set_dwMinimumTtl },
	{ discard_const_p(char, "NamePrimaryServer"), py_DNS_RPC_RECORD_SOA_get_NamePrimaryServer, py_DNS_RPC_RECORD_SOA_set_NamePrimaryServer },
	{ discard_const_p(char, "ZoneAdministratorEmail"), py_DNS_RPC_RECORD_SOA_get_ZoneAdministratorEmail, py_DNS_RPC_RECORD_SOA_set_ZoneAdministratorEmail },
	{ NULL }
};

static PyObject *py_DNS_RPC_RECORD_SOA_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_RECORD_SOA, type);
}


static PyTypeObject DNS_RPC_RECORD_SOA_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.DNS_RPC_RECORD_SOA",
	.tp_getset = py_DNS_RPC_RECORD_SOA_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DNS_RPC_RECORD_SOA_new,
};


static PyObject *py_DNS_RPC_RECORD_NAME_PREFERENCE_get_wPreference(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD_NAME_PREFERENCE *object = (struct DNS_RPC_RECORD_NAME_PREFERENCE *)pytalloc_get_ptr(obj);
	PyObject *py_wPreference;
	py_wPreference = PyInt_FromLong(object->wPreference);
	return py_wPreference;
}

static int py_DNS_RPC_RECORD_NAME_PREFERENCE_set_wPreference(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD_NAME_PREFERENCE *object = (struct DNS_RPC_RECORD_NAME_PREFERENCE *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->wPreference = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_RECORD_NAME_PREFERENCE_get_nameExchange(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD_NAME_PREFERENCE *object = (struct DNS_RPC_RECORD_NAME_PREFERENCE *)pytalloc_get_ptr(obj);
	PyObject *py_nameExchange;
	py_nameExchange = pytalloc_reference_ex(&DNS_RPC_NAME_Type, pytalloc_get_mem_ctx(obj), &object->nameExchange);
	return py_nameExchange;
}

static int py_DNS_RPC_RECORD_NAME_PREFERENCE_set_nameExchange(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD_NAME_PREFERENCE *object = (struct DNS_RPC_RECORD_NAME_PREFERENCE *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&DNS_RPC_NAME_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->nameExchange = *(struct DNS_RPC_NAME *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_DNS_RPC_RECORD_NAME_PREFERENCE_getsetters[] = {
	{ discard_const_p(char, "wPreference"), py_DNS_RPC_RECORD_NAME_PREFERENCE_get_wPreference, py_DNS_RPC_RECORD_NAME_PREFERENCE_set_wPreference },
	{ discard_const_p(char, "nameExchange"), py_DNS_RPC_RECORD_NAME_PREFERENCE_get_nameExchange, py_DNS_RPC_RECORD_NAME_PREFERENCE_set_nameExchange },
	{ NULL }
};

static PyObject *py_DNS_RPC_RECORD_NAME_PREFERENCE_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_RECORD_NAME_PREFERENCE, type);
}


static PyTypeObject DNS_RPC_RECORD_NAME_PREFERENCE_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.DNS_RPC_RECORD_NAME_PREFERENCE",
	.tp_getset = py_DNS_RPC_RECORD_NAME_PREFERENCE_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DNS_RPC_RECORD_NAME_PREFERENCE_new,
};


static PyObject *py_DNS_RPC_RECORD_STRING_get_count(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD_STRING *object = (struct DNS_RPC_RECORD_STRING *)pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyInt_FromLong(object->count);
	return py_count;
}

static int py_DNS_RPC_RECORD_STRING_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD_STRING *object = (struct DNS_RPC_RECORD_STRING *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_RECORD_STRING_get_str(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD_STRING *object = (struct DNS_RPC_RECORD_STRING *)pytalloc_get_ptr(obj);
	PyObject *py_str;
	py_str = PyList_New(object->count);
	if (py_str == NULL) {
		return NULL;
	}
	{
		int str_cntr_0;
		for (str_cntr_0 = 0; str_cntr_0 < object->count; str_cntr_0++) {
			PyObject *py_str_0;
			py_str_0 = pytalloc_reference_ex(&DNS_RPC_NAME_Type, object->str, &object->str[str_cntr_0]);
			PyList_SetItem(py_str, str_cntr_0, py_str_0);
		}
	}
	return py_str;
}

static int py_DNS_RPC_RECORD_STRING_set_str(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD_STRING *object = (struct DNS_RPC_RECORD_STRING *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int str_cntr_0;
		object->str = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->str, PyList_GET_SIZE(value));
		if (!object->str) { return -1;; }
		talloc_set_name_const(object->str, "ARRAY: object->str");
		for (str_cntr_0 = 0; str_cntr_0 < PyList_GET_SIZE(value); str_cntr_0++) {
			PY_CHECK_TYPE(&DNS_RPC_NAME_Type, PyList_GET_ITEM(value, str_cntr_0), return -1;);
			if (talloc_reference(object->str, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, str_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->str[str_cntr_0] = *(struct DNS_RPC_NAME *)pytalloc_get_ptr(PyList_GET_ITEM(value, str_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_RECORD_STRING_getsetters[] = {
	{ discard_const_p(char, "count"), py_DNS_RPC_RECORD_STRING_get_count, py_DNS_RPC_RECORD_STRING_set_count },
	{ discard_const_p(char, "str"), py_DNS_RPC_RECORD_STRING_get_str, py_DNS_RPC_RECORD_STRING_set_str },
	{ NULL }
};

static PyObject *py_DNS_RPC_RECORD_STRING_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_RECORD_STRING, type);
}


static PyTypeObject DNS_RPC_RECORD_STRING_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.DNS_RPC_RECORD_STRING",
	.tp_getset = py_DNS_RPC_RECORD_STRING_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DNS_RPC_RECORD_STRING_new,
};


static PyObject *py_DNS_RPC_RECORD_SRV_get_wPriority(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD_SRV *object = (struct DNS_RPC_RECORD_SRV *)pytalloc_get_ptr(obj);
	PyObject *py_wPriority;
	py_wPriority = PyInt_FromLong(object->wPriority);
	return py_wPriority;
}

static int py_DNS_RPC_RECORD_SRV_set_wPriority(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD_SRV *object = (struct DNS_RPC_RECORD_SRV *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->wPriority = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_RECORD_SRV_get_wWeight(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD_SRV *object = (struct DNS_RPC_RECORD_SRV *)pytalloc_get_ptr(obj);
	PyObject *py_wWeight;
	py_wWeight = PyInt_FromLong(object->wWeight);
	return py_wWeight;
}

static int py_DNS_RPC_RECORD_SRV_set_wWeight(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD_SRV *object = (struct DNS_RPC_RECORD_SRV *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->wWeight = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_RECORD_SRV_get_wPort(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD_SRV *object = (struct DNS_RPC_RECORD_SRV *)pytalloc_get_ptr(obj);
	PyObject *py_wPort;
	py_wPort = PyInt_FromLong(object->wPort);
	return py_wPort;
}

static int py_DNS_RPC_RECORD_SRV_set_wPort(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD_SRV *object = (struct DNS_RPC_RECORD_SRV *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->wPort = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_RECORD_SRV_get_nameTarget(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD_SRV *object = (struct DNS_RPC_RECORD_SRV *)pytalloc_get_ptr(obj);
	PyObject *py_nameTarget;
	py_nameTarget = pytalloc_reference_ex(&DNS_RPC_NAME_Type, pytalloc_get_mem_ctx(obj), &object->nameTarget);
	return py_nameTarget;
}

static int py_DNS_RPC_RECORD_SRV_set_nameTarget(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD_SRV *object = (struct DNS_RPC_RECORD_SRV *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&DNS_RPC_NAME_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->nameTarget = *(struct DNS_RPC_NAME *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_DNS_RPC_RECORD_SRV_getsetters[] = {
	{ discard_const_p(char, "wPriority"), py_DNS_RPC_RECORD_SRV_get_wPriority, py_DNS_RPC_RECORD_SRV_set_wPriority },
	{ discard_const_p(char, "wWeight"), py_DNS_RPC_RECORD_SRV_get_wWeight, py_DNS_RPC_RECORD_SRV_set_wWeight },
	{ discard_const_p(char, "wPort"), py_DNS_RPC_RECORD_SRV_get_wPort, py_DNS_RPC_RECORD_SRV_set_wPort },
	{ discard_const_p(char, "nameTarget"), py_DNS_RPC_RECORD_SRV_get_nameTarget, py_DNS_RPC_RECORD_SRV_set_nameTarget },
	{ NULL }
};

static PyObject *py_DNS_RPC_RECORD_SRV_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_RECORD_SRV, type);
}


static PyTypeObject DNS_RPC_RECORD_SRV_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.DNS_RPC_RECORD_SRV",
	.tp_getset = py_DNS_RPC_RECORD_SRV_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DNS_RPC_RECORD_SRV_new,
};

PyObject *py_import_DNS_RPC_DATA(TALLOC_CTX *mem_ctx, int level, union DNS_RPC_DATA *in)
{
	PyObject *ret;

	switch (level) {
		case DNS_TYPE_TOMBSTONE:
			ret = PyLong_FromLongLong(in->timestamp);
			return ret;

		case DNS_TYPE_A:
			ret = PyString_FromStringOrNULL(in->ipv4);
			return ret;

		case DNS_TYPE_NS:
			ret = pytalloc_reference_ex(&DNS_RPC_NAME_Type, mem_ctx, &in->name);
			return ret;

		case DNS_TYPE_MD:
			ret = pytalloc_reference_ex(&DNS_RPC_NAME_Type, mem_ctx, &in->name);
			return ret;

		case DNS_TYPE_MF:
			ret = pytalloc_reference_ex(&DNS_RPC_NAME_Type, mem_ctx, &in->name);
			return ret;

		case DNS_TYPE_CNAME:
			ret = pytalloc_reference_ex(&DNS_RPC_NAME_Type, mem_ctx, &in->name);
			return ret;

		case DNS_TYPE_SOA:
			ret = pytalloc_reference_ex(&DNS_RPC_RECORD_SOA_Type, mem_ctx, &in->soa);
			return ret;

		case DNS_TYPE_MB:
			ret = pytalloc_reference_ex(&DNS_RPC_NAME_Type, mem_ctx, &in->name);
			return ret;

		case DNS_TYPE_MG:
			ret = pytalloc_reference_ex(&DNS_RPC_NAME_Type, mem_ctx, &in->name);
			return ret;

		case DNS_TYPE_MR:
			ret = pytalloc_reference_ex(&DNS_RPC_NAME_Type, mem_ctx, &in->name);
			return ret;

		case DNS_TYPE_PTR:
			ret = pytalloc_reference_ex(&DNS_RPC_NAME_Type, mem_ctx, &in->ptr);
			return ret;

		case DNS_TYPE_HINFO:
			ret = pytalloc_reference_ex(&DNS_RPC_NAME_Type, mem_ctx, &in->hinfo);
			return ret;

		case DNS_TYPE_MX:
			ret = pytalloc_reference_ex(&DNS_RPC_RECORD_NAME_PREFERENCE_Type, mem_ctx, &in->mx);
			return ret;

		case DNS_TYPE_TXT:
			ret = pytalloc_reference_ex(&DNS_RPC_RECORD_STRING_Type, mem_ctx, &in->txt);
			return ret;

		case DNS_TYPE_AAAA:
			ret = PyString_FromStringOrNULL(in->ipv6);
			return ret;

		case DNS_TYPE_SRV:
			ret = pytalloc_reference_ex(&DNS_RPC_RECORD_SRV_Type, mem_ctx, &in->srv);
			return ret;

		case DNS_TYPE_DNAME:
			ret = pytalloc_reference_ex(&DNS_RPC_NAME_Type, mem_ctx, &in->name);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union DNS_RPC_DATA *py_export_DNS_RPC_DATA(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union DNS_RPC_DATA *ret = talloc_zero(mem_ctx, union DNS_RPC_DATA);
	switch (level) {
		case DNS_TYPE_TOMBSTONE:
			if (PyLong_Check(in)) {
				ret->timestamp = PyLong_AsLongLong(in);
			} else if (PyInt_Check(in)) {
				ret->timestamp = PyInt_AsLong(in);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
				  PyInt_Type.tp_name, PyLong_Type.tp_name);
				talloc_free(ret); return NULL;
			}
			break;

		case DNS_TYPE_A:
			ret->ipv4 = PyString_AS_STRING(in);
			break;

		case DNS_TYPE_NS:
			PY_CHECK_TYPE(&DNS_RPC_NAME_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->name = *(struct DNS_RPC_NAME *)pytalloc_get_ptr(in);
			break;

		case DNS_TYPE_MD:
			PY_CHECK_TYPE(&DNS_RPC_NAME_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->name = *(struct DNS_RPC_NAME *)pytalloc_get_ptr(in);
			break;

		case DNS_TYPE_MF:
			PY_CHECK_TYPE(&DNS_RPC_NAME_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->name = *(struct DNS_RPC_NAME *)pytalloc_get_ptr(in);
			break;

		case DNS_TYPE_CNAME:
			PY_CHECK_TYPE(&DNS_RPC_NAME_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->name = *(struct DNS_RPC_NAME *)pytalloc_get_ptr(in);
			break;

		case DNS_TYPE_SOA:
			PY_CHECK_TYPE(&DNS_RPC_RECORD_SOA_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->soa = *(struct DNS_RPC_RECORD_SOA *)pytalloc_get_ptr(in);
			break;

		case DNS_TYPE_MB:
			PY_CHECK_TYPE(&DNS_RPC_NAME_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->name = *(struct DNS_RPC_NAME *)pytalloc_get_ptr(in);
			break;

		case DNS_TYPE_MG:
			PY_CHECK_TYPE(&DNS_RPC_NAME_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->name = *(struct DNS_RPC_NAME *)pytalloc_get_ptr(in);
			break;

		case DNS_TYPE_MR:
			PY_CHECK_TYPE(&DNS_RPC_NAME_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->name = *(struct DNS_RPC_NAME *)pytalloc_get_ptr(in);
			break;

		case DNS_TYPE_PTR:
			PY_CHECK_TYPE(&DNS_RPC_NAME_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->ptr = *(struct DNS_RPC_NAME *)pytalloc_get_ptr(in);
			break;

		case DNS_TYPE_HINFO:
			PY_CHECK_TYPE(&DNS_RPC_NAME_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->hinfo = *(struct DNS_RPC_NAME *)pytalloc_get_ptr(in);
			break;

		case DNS_TYPE_MX:
			PY_CHECK_TYPE(&DNS_RPC_RECORD_NAME_PREFERENCE_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->mx = *(struct DNS_RPC_RECORD_NAME_PREFERENCE *)pytalloc_get_ptr(in);
			break;

		case DNS_TYPE_TXT:
			PY_CHECK_TYPE(&DNS_RPC_RECORD_STRING_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->txt = *(struct DNS_RPC_RECORD_STRING *)pytalloc_get_ptr(in);
			break;

		case DNS_TYPE_AAAA:
			ret->ipv6 = PyString_AsString(in);
			break;

		case DNS_TYPE_SRV:
			PY_CHECK_TYPE(&DNS_RPC_RECORD_SRV_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->srv = *(struct DNS_RPC_RECORD_SRV *)pytalloc_get_ptr(in);
			break;

		case DNS_TYPE_DNAME:
			PY_CHECK_TYPE(&DNS_RPC_NAME_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->name = *(struct DNS_RPC_NAME *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}


static PyObject *py_DNS_RPC_RECORD_get_wDataLength(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD *object = (struct DNS_RPC_RECORD *)pytalloc_get_ptr(obj);
	PyObject *py_wDataLength;
	py_wDataLength = PyInt_FromLong(object->wDataLength);
	return py_wDataLength;
}

static int py_DNS_RPC_RECORD_set_wDataLength(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD *object = (struct DNS_RPC_RECORD *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->wDataLength = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_RECORD_get_wType(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD *object = (struct DNS_RPC_RECORD *)pytalloc_get_ptr(obj);
	PyObject *py_wType;
	py_wType = PyInt_FromLong(object->wType);
	return py_wType;
}

static int py_DNS_RPC_RECORD_set_wType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD *object = (struct DNS_RPC_RECORD *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->wType = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->wType = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_DNS_RPC_RECORD_get_dwFlags(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD *object = (struct DNS_RPC_RECORD *)pytalloc_get_ptr(obj);
	PyObject *py_dwFlags;
	py_dwFlags = PyInt_FromLong(object->dwFlags);
	return py_dwFlags;
}

static int py_DNS_RPC_RECORD_set_dwFlags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD *object = (struct DNS_RPC_RECORD *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwFlags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_RECORD_get_dwSerial(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD *object = (struct DNS_RPC_RECORD *)pytalloc_get_ptr(obj);
	PyObject *py_dwSerial;
	py_dwSerial = PyInt_FromLong(object->dwSerial);
	return py_dwSerial;
}

static int py_DNS_RPC_RECORD_set_dwSerial(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD *object = (struct DNS_RPC_RECORD *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwSerial = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_RECORD_get_dwTtlSeconds(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD *object = (struct DNS_RPC_RECORD *)pytalloc_get_ptr(obj);
	PyObject *py_dwTtlSeconds;
	py_dwTtlSeconds = PyInt_FromLong(object->dwTtlSeconds);
	return py_dwTtlSeconds;
}

static int py_DNS_RPC_RECORD_set_dwTtlSeconds(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD *object = (struct DNS_RPC_RECORD *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwTtlSeconds = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_RECORD_get_dwTimeStamp(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD *object = (struct DNS_RPC_RECORD *)pytalloc_get_ptr(obj);
	PyObject *py_dwTimeStamp;
	py_dwTimeStamp = PyInt_FromLong(object->dwTimeStamp);
	return py_dwTimeStamp;
}

static int py_DNS_RPC_RECORD_set_dwTimeStamp(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD *object = (struct DNS_RPC_RECORD *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwTimeStamp = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_RECORD_get_dwReserved(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD *object = (struct DNS_RPC_RECORD *)pytalloc_get_ptr(obj);
	PyObject *py_dwReserved;
	py_dwReserved = PyInt_FromLong(object->dwReserved);
	return py_dwReserved;
}

static int py_DNS_RPC_RECORD_set_dwReserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD *object = (struct DNS_RPC_RECORD *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwReserved = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_RECORD_get_data(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD *object = (struct DNS_RPC_RECORD *)pytalloc_get_ptr(obj);
	PyObject *py_data;
	py_data = py_import_DNS_RPC_DATA(pytalloc_get_mem_ctx(obj), object->wType, &object->data);
	if (py_data == NULL) {
		return NULL;
	}
	return py_data;
}

static int py_DNS_RPC_RECORD_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD *object = (struct DNS_RPC_RECORD *)pytalloc_get_ptr(py_obj);
	{
		union DNS_RPC_DATA *data_switch_1;
		data_switch_1 = py_export_DNS_RPC_DATA(pytalloc_get_mem_ctx(py_obj), object->wType, value);
		if (data_switch_1 == NULL) {
			return -1;
		}
		object->data = *data_switch_1;
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_RECORD_getsetters[] = {
	{ discard_const_p(char, "wDataLength"), py_DNS_RPC_RECORD_get_wDataLength, py_DNS_RPC_RECORD_set_wDataLength },
	{ discard_const_p(char, "wType"), py_DNS_RPC_RECORD_get_wType, py_DNS_RPC_RECORD_set_wType },
	{ discard_const_p(char, "dwFlags"), py_DNS_RPC_RECORD_get_dwFlags, py_DNS_RPC_RECORD_set_dwFlags },
	{ discard_const_p(char, "dwSerial"), py_DNS_RPC_RECORD_get_dwSerial, py_DNS_RPC_RECORD_set_dwSerial },
	{ discard_const_p(char, "dwTtlSeconds"), py_DNS_RPC_RECORD_get_dwTtlSeconds, py_DNS_RPC_RECORD_set_dwTtlSeconds },
	{ discard_const_p(char, "dwTimeStamp"), py_DNS_RPC_RECORD_get_dwTimeStamp, py_DNS_RPC_RECORD_set_dwTimeStamp },
	{ discard_const_p(char, "dwReserved"), py_DNS_RPC_RECORD_get_dwReserved, py_DNS_RPC_RECORD_set_dwReserved },
	{ discard_const_p(char, "data"), py_DNS_RPC_RECORD_get_data, py_DNS_RPC_RECORD_set_data },
	{ NULL }
};

static PyObject *py_DNS_RPC_RECORD_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_RECORD, type);
}

static PyObject *py_DNS_RPC_RECORD_ndr_pack(PyObject *py_obj)
{
	struct DNS_RPC_RECORD *object = (struct DNS_RPC_RECORD *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_DNS_RPC_RECORD);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_DNS_RPC_RECORD_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct DNS_RPC_RECORD *object = (struct DNS_RPC_RECORD *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_DNS_RPC_RECORD);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_DNS_RPC_RECORD);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_DNS_RPC_RECORD_ndr_print(PyObject *py_obj)
{
	struct DNS_RPC_RECORD *object = (struct DNS_RPC_RECORD *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_DNS_RPC_RECORD, "DNS_RPC_RECORD", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_DNS_RPC_RECORD_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_DNS_RPC_RECORD_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_DNS_RPC_RECORD_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_DNS_RPC_RECORD_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject DNS_RPC_RECORD_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.DNS_RPC_RECORD",
	.tp_getset = py_DNS_RPC_RECORD_getsetters,
	.tp_methods = py_DNS_RPC_RECORD_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DNS_RPC_RECORD_new,
};


static PyObject *py_DNS_RPC_RECORD_BUF_get_wContextLength(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD_BUF *object = (struct DNS_RPC_RECORD_BUF *)pytalloc_get_ptr(obj);
	PyObject *py_wContextLength;
	py_wContextLength = PyInt_FromLong(object->wContextLength);
	return py_wContextLength;
}

static int py_DNS_RPC_RECORD_BUF_set_wContextLength(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD_BUF *object = (struct DNS_RPC_RECORD_BUF *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->wContextLength = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_RECORD_BUF_get_rec(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORD_BUF *object = (struct DNS_RPC_RECORD_BUF *)pytalloc_get_ptr(obj);
	PyObject *py_rec;
	py_rec = pytalloc_reference_ex(&DNS_RPC_RECORD_Type, pytalloc_get_mem_ctx(obj), &object->rec);
	return py_rec;
}

static int py_DNS_RPC_RECORD_BUF_set_rec(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORD_BUF *object = (struct DNS_RPC_RECORD_BUF *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&DNS_RPC_RECORD_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->rec = *(struct DNS_RPC_RECORD *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_DNS_RPC_RECORD_BUF_getsetters[] = {
	{ discard_const_p(char, "wContextLength"), py_DNS_RPC_RECORD_BUF_get_wContextLength, py_DNS_RPC_RECORD_BUF_set_wContextLength },
	{ discard_const_p(char, "rec"), py_DNS_RPC_RECORD_BUF_get_rec, py_DNS_RPC_RECORD_BUF_set_rec },
	{ NULL }
};

static PyObject *py_DNS_RPC_RECORD_BUF_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_RECORD_BUF, type);
}


static PyTypeObject DNS_RPC_RECORD_BUF_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.DNS_RPC_RECORD_BUF",
	.tp_getset = py_DNS_RPC_RECORD_BUF_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DNS_RPC_RECORD_BUF_new,
};


static PyObject *py_IP4_ARRAY_get_AddrCount(PyObject *obj, void *closure)
{
	struct IP4_ARRAY *object = (struct IP4_ARRAY *)pytalloc_get_ptr(obj);
	PyObject *py_AddrCount;
	py_AddrCount = PyInt_FromLong(object->AddrCount);
	return py_AddrCount;
}

static int py_IP4_ARRAY_set_AddrCount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct IP4_ARRAY *object = (struct IP4_ARRAY *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->AddrCount = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_IP4_ARRAY_get_AddrArray(PyObject *obj, void *closure)
{
	struct IP4_ARRAY *object = (struct IP4_ARRAY *)pytalloc_get_ptr(obj);
	PyObject *py_AddrArray;
	py_AddrArray = PyList_New(object->AddrCount);
	if (py_AddrArray == NULL) {
		return NULL;
	}
	{
		int AddrArray_cntr_0;
		for (AddrArray_cntr_0 = 0; AddrArray_cntr_0 < object->AddrCount; AddrArray_cntr_0++) {
			PyObject *py_AddrArray_0;
			py_AddrArray_0 = PyInt_FromLong(object->AddrArray[AddrArray_cntr_0]);
			PyList_SetItem(py_AddrArray, AddrArray_cntr_0, py_AddrArray_0);
		}
	}
	return py_AddrArray;
}

static int py_IP4_ARRAY_set_AddrArray(PyObject *py_obj, PyObject *value, void *closure)
{
	struct IP4_ARRAY *object = (struct IP4_ARRAY *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int AddrArray_cntr_0;
		object->AddrArray = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->AddrArray, PyList_GET_SIZE(value));
		if (!object->AddrArray) { return -1;; }
		talloc_set_name_const(object->AddrArray, "ARRAY: object->AddrArray");
		for (AddrArray_cntr_0 = 0; AddrArray_cntr_0 < PyList_GET_SIZE(value); AddrArray_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, AddrArray_cntr_0), return -1;);
			object->AddrArray[AddrArray_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, AddrArray_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_IP4_ARRAY_getsetters[] = {
	{ discard_const_p(char, "AddrCount"), py_IP4_ARRAY_get_AddrCount, py_IP4_ARRAY_set_AddrCount },
	{ discard_const_p(char, "AddrArray"), py_IP4_ARRAY_get_AddrArray, py_IP4_ARRAY_set_AddrArray },
	{ NULL }
};

static PyObject *py_IP4_ARRAY_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct IP4_ARRAY, type);
}


static PyTypeObject IP4_ARRAY_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.IP4_ARRAY",
	.tp_getset = py_IP4_ARRAY_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_IP4_ARRAY_new,
};


static PyObject *py_DNS_ADDR_get_MaxSa(PyObject *obj, void *closure)
{
	struct DNS_ADDR *object = (struct DNS_ADDR *)pytalloc_get_ptr(obj);
	PyObject *py_MaxSa;
	py_MaxSa = PyList_New(32);
	if (py_MaxSa == NULL) {
		return NULL;
	}
	{
		int MaxSa_cntr_0;
		for (MaxSa_cntr_0 = 0; MaxSa_cntr_0 < 32; MaxSa_cntr_0++) {
			PyObject *py_MaxSa_0;
			py_MaxSa_0 = PyInt_FromLong(object->MaxSa[MaxSa_cntr_0]);
			PyList_SetItem(py_MaxSa, MaxSa_cntr_0, py_MaxSa_0);
		}
	}
	return py_MaxSa;
}

static int py_DNS_ADDR_set_MaxSa(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_ADDR *object = (struct DNS_ADDR *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int MaxSa_cntr_0;
		for (MaxSa_cntr_0 = 0; MaxSa_cntr_0 < PyList_GET_SIZE(value); MaxSa_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, MaxSa_cntr_0), return -1;);
			object->MaxSa[MaxSa_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, MaxSa_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_DNS_ADDR_get_DnsAddrUserDword(PyObject *obj, void *closure)
{
	struct DNS_ADDR *object = (struct DNS_ADDR *)pytalloc_get_ptr(obj);
	PyObject *py_DnsAddrUserDword;
	py_DnsAddrUserDword = PyList_New(8);
	if (py_DnsAddrUserDword == NULL) {
		return NULL;
	}
	{
		int DnsAddrUserDword_cntr_0;
		for (DnsAddrUserDword_cntr_0 = 0; DnsAddrUserDword_cntr_0 < 8; DnsAddrUserDword_cntr_0++) {
			PyObject *py_DnsAddrUserDword_0;
			py_DnsAddrUserDword_0 = PyInt_FromLong(object->DnsAddrUserDword[DnsAddrUserDword_cntr_0]);
			PyList_SetItem(py_DnsAddrUserDword, DnsAddrUserDword_cntr_0, py_DnsAddrUserDword_0);
		}
	}
	return py_DnsAddrUserDword;
}

static int py_DNS_ADDR_set_DnsAddrUserDword(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_ADDR *object = (struct DNS_ADDR *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int DnsAddrUserDword_cntr_0;
		for (DnsAddrUserDword_cntr_0 = 0; DnsAddrUserDword_cntr_0 < PyList_GET_SIZE(value); DnsAddrUserDword_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, DnsAddrUserDword_cntr_0), return -1;);
			object->DnsAddrUserDword[DnsAddrUserDword_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, DnsAddrUserDword_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_ADDR_getsetters[] = {
	{ discard_const_p(char, "MaxSa"), py_DNS_ADDR_get_MaxSa, py_DNS_ADDR_set_MaxSa },
	{ discard_const_p(char, "DnsAddrUserDword"), py_DNS_ADDR_get_DnsAddrUserDword, py_DNS_ADDR_set_DnsAddrUserDword },
	{ NULL }
};

static PyObject *py_DNS_ADDR_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_ADDR, type);
}


static PyTypeObject DNS_ADDR_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.DNS_ADDR",
	.tp_getset = py_DNS_ADDR_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DNS_ADDR_new,
};


static PyObject *py_DNS_ADDR_ARRAY_get_MaxCount(PyObject *obj, void *closure)
{
	struct DNS_ADDR_ARRAY *object = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(obj);
	PyObject *py_MaxCount;
	py_MaxCount = PyInt_FromLong(object->MaxCount);
	return py_MaxCount;
}

static int py_DNS_ADDR_ARRAY_set_MaxCount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_ADDR_ARRAY *object = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->MaxCount = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_ADDR_ARRAY_get_AddrCount(PyObject *obj, void *closure)
{
	struct DNS_ADDR_ARRAY *object = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(obj);
	PyObject *py_AddrCount;
	py_AddrCount = PyInt_FromLong(object->AddrCount);
	return py_AddrCount;
}

static int py_DNS_ADDR_ARRAY_set_AddrCount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_ADDR_ARRAY *object = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->AddrCount = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_ADDR_ARRAY_get_Tag(PyObject *obj, void *closure)
{
	struct DNS_ADDR_ARRAY *object = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(obj);
	PyObject *py_Tag;
	py_Tag = PyInt_FromLong(object->Tag);
	return py_Tag;
}

static int py_DNS_ADDR_ARRAY_set_Tag(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_ADDR_ARRAY *object = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->Tag = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_ADDR_ARRAY_get_Family(PyObject *obj, void *closure)
{
	struct DNS_ADDR_ARRAY *object = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(obj);
	PyObject *py_Family;
	py_Family = PyInt_FromLong(object->Family);
	return py_Family;
}

static int py_DNS_ADDR_ARRAY_set_Family(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_ADDR_ARRAY *object = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->Family = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_ADDR_ARRAY_get_WordReserved(PyObject *obj, void *closure)
{
	struct DNS_ADDR_ARRAY *object = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(obj);
	PyObject *py_WordReserved;
	py_WordReserved = PyInt_FromLong(object->WordReserved);
	return py_WordReserved;
}

static int py_DNS_ADDR_ARRAY_set_WordReserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_ADDR_ARRAY *object = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->WordReserved = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_ADDR_ARRAY_get_Flags(PyObject *obj, void *closure)
{
	struct DNS_ADDR_ARRAY *object = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(obj);
	PyObject *py_Flags;
	py_Flags = PyInt_FromLong(object->Flags);
	return py_Flags;
}

static int py_DNS_ADDR_ARRAY_set_Flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_ADDR_ARRAY *object = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->Flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_ADDR_ARRAY_get_MatchFlag(PyObject *obj, void *closure)
{
	struct DNS_ADDR_ARRAY *object = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(obj);
	PyObject *py_MatchFlag;
	py_MatchFlag = PyInt_FromLong(object->MatchFlag);
	return py_MatchFlag;
}

static int py_DNS_ADDR_ARRAY_set_MatchFlag(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_ADDR_ARRAY *object = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->MatchFlag = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_ADDR_ARRAY_get_Reserved1(PyObject *obj, void *closure)
{
	struct DNS_ADDR_ARRAY *object = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(obj);
	PyObject *py_Reserved1;
	py_Reserved1 = PyInt_FromLong(object->Reserved1);
	return py_Reserved1;
}

static int py_DNS_ADDR_ARRAY_set_Reserved1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_ADDR_ARRAY *object = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->Reserved1 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_ADDR_ARRAY_get_Reserved2(PyObject *obj, void *closure)
{
	struct DNS_ADDR_ARRAY *object = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(obj);
	PyObject *py_Reserved2;
	py_Reserved2 = PyInt_FromLong(object->Reserved2);
	return py_Reserved2;
}

static int py_DNS_ADDR_ARRAY_set_Reserved2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_ADDR_ARRAY *object = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->Reserved2 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_ADDR_ARRAY_get_AddrArray(PyObject *obj, void *closure)
{
	struct DNS_ADDR_ARRAY *object = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(obj);
	PyObject *py_AddrArray;
	py_AddrArray = PyList_New(object->AddrCount);
	if (py_AddrArray == NULL) {
		return NULL;
	}
	{
		int AddrArray_cntr_0;
		for (AddrArray_cntr_0 = 0; AddrArray_cntr_0 < object->AddrCount; AddrArray_cntr_0++) {
			PyObject *py_AddrArray_0;
			py_AddrArray_0 = pytalloc_reference_ex(&DNS_ADDR_Type, object->AddrArray, &object->AddrArray[AddrArray_cntr_0]);
			PyList_SetItem(py_AddrArray, AddrArray_cntr_0, py_AddrArray_0);
		}
	}
	return py_AddrArray;
}

static int py_DNS_ADDR_ARRAY_set_AddrArray(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_ADDR_ARRAY *object = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int AddrArray_cntr_0;
		object->AddrArray = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->AddrArray, PyList_GET_SIZE(value));
		if (!object->AddrArray) { return -1;; }
		talloc_set_name_const(object->AddrArray, "ARRAY: object->AddrArray");
		for (AddrArray_cntr_0 = 0; AddrArray_cntr_0 < PyList_GET_SIZE(value); AddrArray_cntr_0++) {
			PY_CHECK_TYPE(&DNS_ADDR_Type, PyList_GET_ITEM(value, AddrArray_cntr_0), return -1;);
			if (talloc_reference(object->AddrArray, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, AddrArray_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->AddrArray[AddrArray_cntr_0] = *(struct DNS_ADDR *)pytalloc_get_ptr(PyList_GET_ITEM(value, AddrArray_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_ADDR_ARRAY_getsetters[] = {
	{ discard_const_p(char, "MaxCount"), py_DNS_ADDR_ARRAY_get_MaxCount, py_DNS_ADDR_ARRAY_set_MaxCount },
	{ discard_const_p(char, "AddrCount"), py_DNS_ADDR_ARRAY_get_AddrCount, py_DNS_ADDR_ARRAY_set_AddrCount },
	{ discard_const_p(char, "Tag"), py_DNS_ADDR_ARRAY_get_Tag, py_DNS_ADDR_ARRAY_set_Tag },
	{ discard_const_p(char, "Family"), py_DNS_ADDR_ARRAY_get_Family, py_DNS_ADDR_ARRAY_set_Family },
	{ discard_const_p(char, "WordReserved"), py_DNS_ADDR_ARRAY_get_WordReserved, py_DNS_ADDR_ARRAY_set_WordReserved },
	{ discard_const_p(char, "Flags"), py_DNS_ADDR_ARRAY_get_Flags, py_DNS_ADDR_ARRAY_set_Flags },
	{ discard_const_p(char, "MatchFlag"), py_DNS_ADDR_ARRAY_get_MatchFlag, py_DNS_ADDR_ARRAY_set_MatchFlag },
	{ discard_const_p(char, "Reserved1"), py_DNS_ADDR_ARRAY_get_Reserved1, py_DNS_ADDR_ARRAY_set_Reserved1 },
	{ discard_const_p(char, "Reserved2"), py_DNS_ADDR_ARRAY_get_Reserved2, py_DNS_ADDR_ARRAY_set_Reserved2 },
	{ discard_const_p(char, "AddrArray"), py_DNS_ADDR_ARRAY_get_AddrArray, py_DNS_ADDR_ARRAY_set_AddrArray },
	{ NULL }
};

static PyObject *py_DNS_ADDR_ARRAY_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_ADDR_ARRAY, type);
}


static PyTypeObject DNS_ADDR_ARRAY_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.DNS_ADDR_ARRAY",
	.tp_getset = py_DNS_ADDR_ARRAY_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DNS_ADDR_ARRAY_new,
};


static PyObject *py_DNS_RPC_IP_VALIDATE_get_dwRpcStructureVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_IP_VALIDATE *object = (struct DNS_RPC_IP_VALIDATE *)pytalloc_get_ptr(obj);
	PyObject *py_dwRpcStructureVersion;
	py_dwRpcStructureVersion = PyInt_FromLong(object->dwRpcStructureVersion);
	return py_dwRpcStructureVersion;
}

static int py_DNS_RPC_IP_VALIDATE_set_dwRpcStructureVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_IP_VALIDATE *object = (struct DNS_RPC_IP_VALIDATE *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwRpcStructureVersion = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_IP_VALIDATE_get_dwReserved0(PyObject *obj, void *closure)
{
	struct DNS_RPC_IP_VALIDATE *object = (struct DNS_RPC_IP_VALIDATE *)pytalloc_get_ptr(obj);
	PyObject *py_dwReserved0;
	py_dwReserved0 = PyInt_FromLong(object->dwReserved0);
	return py_dwReserved0;
}

static int py_DNS_RPC_IP_VALIDATE_set_dwReserved0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_IP_VALIDATE *object = (struct DNS_RPC_IP_VALIDATE *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwReserved0 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_IP_VALIDATE_get_dwContext(PyObject *obj, void *closure)
{
	struct DNS_RPC_IP_VALIDATE *object = (struct DNS_RPC_IP_VALIDATE *)pytalloc_get_ptr(obj);
	PyObject *py_dwContext;
	py_dwContext = PyInt_FromLong(object->dwContext);
	return py_dwContext;
}

static int py_DNS_RPC_IP_VALIDATE_set_dwContext(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_IP_VALIDATE *object = (struct DNS_RPC_IP_VALIDATE *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwContext = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_IP_VALIDATE_get_dwReserved1(PyObject *obj, void *closure)
{
	struct DNS_RPC_IP_VALIDATE *object = (struct DNS_RPC_IP_VALIDATE *)pytalloc_get_ptr(obj);
	PyObject *py_dwReserved1;
	py_dwReserved1 = PyInt_FromLong(object->dwReserved1);
	return py_dwReserved1;
}

static int py_DNS_RPC_IP_VALIDATE_set_dwReserved1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_IP_VALIDATE *object = (struct DNS_RPC_IP_VALIDATE *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwReserved1 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_IP_VALIDATE_get_pszContextName(PyObject *obj, void *closure)
{
	struct DNS_RPC_IP_VALIDATE *object = (struct DNS_RPC_IP_VALIDATE *)pytalloc_get_ptr(obj);
	PyObject *py_pszContextName;
	if (object->pszContextName == NULL) {
		py_pszContextName = Py_None;
		Py_INCREF(py_pszContextName);
	} else {
		if (object->pszContextName == NULL) {
			py_pszContextName = Py_None;
			Py_INCREF(py_pszContextName);
		} else {
			py_pszContextName = PyUnicode_Decode(object->pszContextName, strlen(object->pszContextName), "utf-8", "ignore");
		}
	}
	return py_pszContextName;
}

static int py_DNS_RPC_IP_VALIDATE_set_pszContextName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_IP_VALIDATE *object = (struct DNS_RPC_IP_VALIDATE *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszContextName = NULL;
	} else {
		object->pszContextName = NULL;
		if (PyUnicode_Check(value)) {
			object->pszContextName = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszContextName = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_IP_VALIDATE_get_aipValidateAddrs(PyObject *obj, void *closure)
{
	struct DNS_RPC_IP_VALIDATE *object = (struct DNS_RPC_IP_VALIDATE *)pytalloc_get_ptr(obj);
	PyObject *py_aipValidateAddrs;
	if (object->aipValidateAddrs == NULL) {
		py_aipValidateAddrs = Py_None;
		Py_INCREF(py_aipValidateAddrs);
	} else {
		py_aipValidateAddrs = pytalloc_reference_ex(&DNS_ADDR_ARRAY_Type, object->aipValidateAddrs, object->aipValidateAddrs);
	}
	return py_aipValidateAddrs;
}

static int py_DNS_RPC_IP_VALIDATE_set_aipValidateAddrs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_IP_VALIDATE *object = (struct DNS_RPC_IP_VALIDATE *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->aipValidateAddrs);
	if (value == Py_None) {
		object->aipValidateAddrs = NULL;
	} else {
		object->aipValidateAddrs = NULL;
		PY_CHECK_TYPE(&DNS_ADDR_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipValidateAddrs = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_IP_VALIDATE_getsetters[] = {
	{ discard_const_p(char, "dwRpcStructureVersion"), py_DNS_RPC_IP_VALIDATE_get_dwRpcStructureVersion, py_DNS_RPC_IP_VALIDATE_set_dwRpcStructureVersion },
	{ discard_const_p(char, "dwReserved0"), py_DNS_RPC_IP_VALIDATE_get_dwReserved0, py_DNS_RPC_IP_VALIDATE_set_dwReserved0 },
	{ discard_const_p(char, "dwContext"), py_DNS_RPC_IP_VALIDATE_get_dwContext, py_DNS_RPC_IP_VALIDATE_set_dwContext },
	{ discard_const_p(char, "dwReserved1"), py_DNS_RPC_IP_VALIDATE_get_dwReserved1, py_DNS_RPC_IP_VALIDATE_set_dwReserved1 },
	{ discard_const_p(char, "pszContextName"), py_DNS_RPC_IP_VALIDATE_get_pszContextName, py_DNS_RPC_IP_VALIDATE_set_pszContextName },
	{ discard_const_p(char, "aipValidateAddrs"), py_DNS_RPC_IP_VALIDATE_get_aipValidateAddrs, py_DNS_RPC_IP_VALIDATE_set_aipValidateAddrs },
	{ NULL }
};

static PyObject *py_DNS_RPC_IP_VALIDATE_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_IP_VALIDATE, type);
}


static PyTypeObject DNS_RPC_IP_VALIDATE_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.DNS_RPC_IP_VALIDATE",
	.tp_getset = py_DNS_RPC_IP_VALIDATE_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DNS_RPC_IP_VALIDATE_new,
};


static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_dwVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_dwVersion;
	py_dwVersion = PyInt_FromLong(object->dwVersion);
	return py_dwVersion;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_dwVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwVersion = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_fBootMethod(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_fBootMethod;
	py_fBootMethod = PyInt_FromLong(object->fBootMethod);
	return py_fBootMethod;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_fBootMethod(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->fBootMethod = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->fBootMethod = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_fAdminConfigured(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_fAdminConfigured;
	py_fAdminConfigured = PyInt_FromLong(object->fAdminConfigured);
	return py_fAdminConfigured;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_fAdminConfigured(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fAdminConfigured = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_fAllowUpdate(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_fAllowUpdate;
	py_fAllowUpdate = PyInt_FromLong(object->fAllowUpdate);
	return py_fAllowUpdate;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_fAllowUpdate(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fAllowUpdate = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_fDsAvailable(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_fDsAvailable;
	py_fDsAvailable = PyInt_FromLong(object->fDsAvailable);
	return py_fDsAvailable;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_fDsAvailable(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fDsAvailable = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_pszServerName(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_pszServerName;
	if (object->pszServerName == NULL) {
		py_pszServerName = Py_None;
		Py_INCREF(py_pszServerName);
	} else {
		if (object->pszServerName == NULL) {
			py_pszServerName = Py_None;
			Py_INCREF(py_pszServerName);
		} else {
			py_pszServerName = PyUnicode_Decode(object->pszServerName, strlen(object->pszServerName), "utf-8", "ignore");
		}
	}
	return py_pszServerName;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_pszServerName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszServerName = NULL;
	} else {
		object->pszServerName = NULL;
		if (PyUnicode_Check(value)) {
			object->pszServerName = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszServerName = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_pszDsContainer(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_pszDsContainer;
	if (object->pszDsContainer == NULL) {
		py_pszDsContainer = Py_None;
		Py_INCREF(py_pszDsContainer);
	} else {
		if (object->pszDsContainer == NULL) {
			py_pszDsContainer = Py_None;
			Py_INCREF(py_pszDsContainer);
		} else {
			py_pszDsContainer = PyUnicode_Decode(object->pszDsContainer, strlen(object->pszDsContainer), "utf-8", "ignore");
		}
	}
	return py_pszDsContainer;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_pszDsContainer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszDsContainer = NULL;
	} else {
		object->pszDsContainer = NULL;
		if (PyUnicode_Check(value)) {
			object->pszDsContainer = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszDsContainer = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_aipServerAddrs(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_aipServerAddrs;
	if (object->aipServerAddrs == NULL) {
		py_aipServerAddrs = Py_None;
		Py_INCREF(py_aipServerAddrs);
	} else {
		py_aipServerAddrs = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipServerAddrs, object->aipServerAddrs);
	}
	return py_aipServerAddrs;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_aipServerAddrs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->aipServerAddrs);
	if (value == Py_None) {
		object->aipServerAddrs = NULL;
	} else {
		object->aipServerAddrs = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipServerAddrs = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_aipListenAddrs(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_aipListenAddrs;
	if (object->aipListenAddrs == NULL) {
		py_aipListenAddrs = Py_None;
		Py_INCREF(py_aipListenAddrs);
	} else {
		py_aipListenAddrs = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipListenAddrs, object->aipListenAddrs);
	}
	return py_aipListenAddrs;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_aipListenAddrs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->aipListenAddrs);
	if (value == Py_None) {
		object->aipListenAddrs = NULL;
	} else {
		object->aipListenAddrs = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipListenAddrs = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_aipForwarders(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_aipForwarders;
	if (object->aipForwarders == NULL) {
		py_aipForwarders = Py_None;
		Py_INCREF(py_aipForwarders);
	} else {
		py_aipForwarders = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipForwarders, object->aipForwarders);
	}
	return py_aipForwarders;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_aipForwarders(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->aipForwarders);
	if (value == Py_None) {
		object->aipForwarders = NULL;
	} else {
		object->aipForwarders = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipForwarders = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_pExtension1(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_pExtension1;
	if (object->pExtension1 == NULL) {
		py_pExtension1 = Py_None;
		Py_INCREF(py_pExtension1);
	} else {
		py_pExtension1 = PyInt_FromLong(*object->pExtension1);
	}
	return py_pExtension1;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_pExtension1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->pExtension1);
	if (value == Py_None) {
		object->pExtension1 = NULL;
	} else {
		object->pExtension1 = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->pExtension1);
		PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
		*object->pExtension1 = PyInt_AsLong(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_pExtension2(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_pExtension2;
	if (object->pExtension2 == NULL) {
		py_pExtension2 = Py_None;
		Py_INCREF(py_pExtension2);
	} else {
		py_pExtension2 = PyInt_FromLong(*object->pExtension2);
	}
	return py_pExtension2;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_pExtension2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->pExtension2);
	if (value == Py_None) {
		object->pExtension2 = NULL;
	} else {
		object->pExtension2 = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->pExtension2);
		PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
		*object->pExtension2 = PyInt_AsLong(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_pExtension3(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_pExtension3;
	if (object->pExtension3 == NULL) {
		py_pExtension3 = Py_None;
		Py_INCREF(py_pExtension3);
	} else {
		py_pExtension3 = PyInt_FromLong(*object->pExtension3);
	}
	return py_pExtension3;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_pExtension3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->pExtension3);
	if (value == Py_None) {
		object->pExtension3 = NULL;
	} else {
		object->pExtension3 = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->pExtension3);
		PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
		*object->pExtension3 = PyInt_AsLong(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_pExtension4(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_pExtension4;
	if (object->pExtension4 == NULL) {
		py_pExtension4 = Py_None;
		Py_INCREF(py_pExtension4);
	} else {
		py_pExtension4 = PyInt_FromLong(*object->pExtension4);
	}
	return py_pExtension4;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_pExtension4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->pExtension4);
	if (value == Py_None) {
		object->pExtension4 = NULL;
	} else {
		object->pExtension4 = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->pExtension4);
		PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
		*object->pExtension4 = PyInt_AsLong(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_pExtension5(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_pExtension5;
	if (object->pExtension5 == NULL) {
		py_pExtension5 = Py_None;
		Py_INCREF(py_pExtension5);
	} else {
		py_pExtension5 = PyInt_FromLong(*object->pExtension5);
	}
	return py_pExtension5;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_pExtension5(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->pExtension5);
	if (value == Py_None) {
		object->pExtension5 = NULL;
	} else {
		object->pExtension5 = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->pExtension5);
		PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
		*object->pExtension5 = PyInt_AsLong(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_dwLogLevel(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_dwLogLevel;
	py_dwLogLevel = PyInt_FromLong(object->dwLogLevel);
	return py_dwLogLevel;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_dwLogLevel(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwLogLevel = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_dwDebugLevel(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_dwDebugLevel;
	py_dwDebugLevel = PyInt_FromLong(object->dwDebugLevel);
	return py_dwDebugLevel;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_dwDebugLevel(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwDebugLevel = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_dwForwardTimeout(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_dwForwardTimeout;
	py_dwForwardTimeout = PyInt_FromLong(object->dwForwardTimeout);
	return py_dwForwardTimeout;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_dwForwardTimeout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwForwardTimeout = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_dwRpcProtocol(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_dwRpcProtocol;
	py_dwRpcProtocol = PyInt_FromLong(object->dwRpcProtocol);
	return py_dwRpcProtocol;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_dwRpcProtocol(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwRpcProtocol = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_dwNameCheckFlag(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_dwNameCheckFlag;
	py_dwNameCheckFlag = PyInt_FromLong(object->dwNameCheckFlag);
	return py_dwNameCheckFlag;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_dwNameCheckFlag(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->dwNameCheckFlag = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->dwNameCheckFlag = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_cAddressAnswerLimit(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_cAddressAnswerLimit;
	py_cAddressAnswerLimit = PyInt_FromLong(object->cAddressAnswerLimit);
	return py_cAddressAnswerLimit;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_cAddressAnswerLimit(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->cAddressAnswerLimit = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_dwRecursionRetry(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_dwRecursionRetry;
	py_dwRecursionRetry = PyInt_FromLong(object->dwRecursionRetry);
	return py_dwRecursionRetry;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_dwRecursionRetry(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwRecursionRetry = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_dwRecursionTimeout(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_dwRecursionTimeout;
	py_dwRecursionTimeout = PyInt_FromLong(object->dwRecursionTimeout);
	return py_dwRecursionTimeout;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_dwRecursionTimeout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwRecursionTimeout = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_dwMaxCacheTtl(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_dwMaxCacheTtl;
	py_dwMaxCacheTtl = PyInt_FromLong(object->dwMaxCacheTtl);
	return py_dwMaxCacheTtl;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_dwMaxCacheTtl(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwMaxCacheTtl = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_dwDsPollingInterval(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_dwDsPollingInterval;
	py_dwDsPollingInterval = PyInt_FromLong(object->dwDsPollingInterval);
	return py_dwDsPollingInterval;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_dwDsPollingInterval(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwDsPollingInterval = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_dwScavengingInterval(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_dwScavengingInterval;
	py_dwScavengingInterval = PyInt_FromLong(object->dwScavengingInterval);
	return py_dwScavengingInterval;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_dwScavengingInterval(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwScavengingInterval = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_dwDefaultRefreshInterval(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_dwDefaultRefreshInterval;
	py_dwDefaultRefreshInterval = PyInt_FromLong(object->dwDefaultRefreshInterval);
	return py_dwDefaultRefreshInterval;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_dwDefaultRefreshInterval(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwDefaultRefreshInterval = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_dwDefaultNoRefreshInterval(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_dwDefaultNoRefreshInterval;
	py_dwDefaultNoRefreshInterval = PyInt_FromLong(object->dwDefaultNoRefreshInterval);
	return py_dwDefaultNoRefreshInterval;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_dwDefaultNoRefreshInterval(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwDefaultNoRefreshInterval = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_dwReserveArray(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_dwReserveArray;
	py_dwReserveArray = PyList_New(10);
	if (py_dwReserveArray == NULL) {
		return NULL;
	}
	{
		int dwReserveArray_cntr_0;
		for (dwReserveArray_cntr_0 = 0; dwReserveArray_cntr_0 < 10; dwReserveArray_cntr_0++) {
			PyObject *py_dwReserveArray_0;
			py_dwReserveArray_0 = PyInt_FromLong(object->dwReserveArray[dwReserveArray_cntr_0]);
			PyList_SetItem(py_dwReserveArray, dwReserveArray_cntr_0, py_dwReserveArray_0);
		}
	}
	return py_dwReserveArray;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_dwReserveArray(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int dwReserveArray_cntr_0;
		for (dwReserveArray_cntr_0 = 0; dwReserveArray_cntr_0 < PyList_GET_SIZE(value); dwReserveArray_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, dwReserveArray_cntr_0), return -1;);
			object->dwReserveArray[dwReserveArray_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, dwReserveArray_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_fAutoReverseZones(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_fAutoReverseZones;
	py_fAutoReverseZones = PyInt_FromLong(object->fAutoReverseZones);
	return py_fAutoReverseZones;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_fAutoReverseZones(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fAutoReverseZones = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_fAutoCacheUpdate(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_fAutoCacheUpdate;
	py_fAutoCacheUpdate = PyInt_FromLong(object->fAutoCacheUpdate);
	return py_fAutoCacheUpdate;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_fAutoCacheUpdate(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fAutoCacheUpdate = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_fRecurseAfterForwarding(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_fRecurseAfterForwarding;
	py_fRecurseAfterForwarding = PyInt_FromLong(object->fRecurseAfterForwarding);
	return py_fRecurseAfterForwarding;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_fRecurseAfterForwarding(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fRecurseAfterForwarding = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_fForwardDelegations(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_fForwardDelegations;
	py_fForwardDelegations = PyInt_FromLong(object->fForwardDelegations);
	return py_fForwardDelegations;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_fForwardDelegations(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fForwardDelegations = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_fNoRecursion(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_fNoRecursion;
	py_fNoRecursion = PyInt_FromLong(object->fNoRecursion);
	return py_fNoRecursion;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_fNoRecursion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fNoRecursion = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_fSecureResponses(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_fSecureResponses;
	py_fSecureResponses = PyInt_FromLong(object->fSecureResponses);
	return py_fSecureResponses;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_fSecureResponses(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fSecureResponses = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_fRoundRobin(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_fRoundRobin;
	py_fRoundRobin = PyInt_FromLong(object->fRoundRobin);
	return py_fRoundRobin;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_fRoundRobin(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fRoundRobin = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_fLocalNetPriority(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_fLocalNetPriority;
	py_fLocalNetPriority = PyInt_FromLong(object->fLocalNetPriority);
	return py_fLocalNetPriority;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_fLocalNetPriority(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fLocalNetPriority = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_fBindSecondaries(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_fBindSecondaries;
	py_fBindSecondaries = PyInt_FromLong(object->fBindSecondaries);
	return py_fBindSecondaries;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_fBindSecondaries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fBindSecondaries = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_fWriteAuthorityNs(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_fWriteAuthorityNs;
	py_fWriteAuthorityNs = PyInt_FromLong(object->fWriteAuthorityNs);
	return py_fWriteAuthorityNs;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_fWriteAuthorityNs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fWriteAuthorityNs = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_fStrictFileParsing(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_fStrictFileParsing;
	py_fStrictFileParsing = PyInt_FromLong(object->fStrictFileParsing);
	return py_fStrictFileParsing;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_fStrictFileParsing(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fStrictFileParsing = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_fLooseWildcarding(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_fLooseWildcarding;
	py_fLooseWildcarding = PyInt_FromLong(object->fLooseWildcarding);
	return py_fLooseWildcarding;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_fLooseWildcarding(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fLooseWildcarding = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_fDefaultAgingState(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_fDefaultAgingState;
	py_fDefaultAgingState = PyInt_FromLong(object->fDefaultAgingState);
	return py_fDefaultAgingState;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_fDefaultAgingState(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fDefaultAgingState = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_get_fReserveArray(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_fReserveArray;
	py_fReserveArray = PyList_New(15);
	if (py_fReserveArray == NULL) {
		return NULL;
	}
	{
		int fReserveArray_cntr_0;
		for (fReserveArray_cntr_0 = 0; fReserveArray_cntr_0 < 15; fReserveArray_cntr_0++) {
			PyObject *py_fReserveArray_0;
			py_fReserveArray_0 = PyInt_FromLong(object->fReserveArray[fReserveArray_cntr_0]);
			PyList_SetItem(py_fReserveArray, fReserveArray_cntr_0, py_fReserveArray_0);
		}
	}
	return py_fReserveArray;
}

static int py_DNS_RPC_SERVER_INFO_W2K_set_fReserveArray(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_W2K *object = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int fReserveArray_cntr_0;
		for (fReserveArray_cntr_0 = 0; fReserveArray_cntr_0 < PyList_GET_SIZE(value); fReserveArray_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, fReserveArray_cntr_0), return -1;);
			object->fReserveArray[fReserveArray_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, fReserveArray_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_SERVER_INFO_W2K_getsetters[] = {
	{ discard_const_p(char, "dwVersion"), py_DNS_RPC_SERVER_INFO_W2K_get_dwVersion, py_DNS_RPC_SERVER_INFO_W2K_set_dwVersion },
	{ discard_const_p(char, "fBootMethod"), py_DNS_RPC_SERVER_INFO_W2K_get_fBootMethod, py_DNS_RPC_SERVER_INFO_W2K_set_fBootMethod },
	{ discard_const_p(char, "fAdminConfigured"), py_DNS_RPC_SERVER_INFO_W2K_get_fAdminConfigured, py_DNS_RPC_SERVER_INFO_W2K_set_fAdminConfigured },
	{ discard_const_p(char, "fAllowUpdate"), py_DNS_RPC_SERVER_INFO_W2K_get_fAllowUpdate, py_DNS_RPC_SERVER_INFO_W2K_set_fAllowUpdate },
	{ discard_const_p(char, "fDsAvailable"), py_DNS_RPC_SERVER_INFO_W2K_get_fDsAvailable, py_DNS_RPC_SERVER_INFO_W2K_set_fDsAvailable },
	{ discard_const_p(char, "pszServerName"), py_DNS_RPC_SERVER_INFO_W2K_get_pszServerName, py_DNS_RPC_SERVER_INFO_W2K_set_pszServerName },
	{ discard_const_p(char, "pszDsContainer"), py_DNS_RPC_SERVER_INFO_W2K_get_pszDsContainer, py_DNS_RPC_SERVER_INFO_W2K_set_pszDsContainer },
	{ discard_const_p(char, "aipServerAddrs"), py_DNS_RPC_SERVER_INFO_W2K_get_aipServerAddrs, py_DNS_RPC_SERVER_INFO_W2K_set_aipServerAddrs },
	{ discard_const_p(char, "aipListenAddrs"), py_DNS_RPC_SERVER_INFO_W2K_get_aipListenAddrs, py_DNS_RPC_SERVER_INFO_W2K_set_aipListenAddrs },
	{ discard_const_p(char, "aipForwarders"), py_DNS_RPC_SERVER_INFO_W2K_get_aipForwarders, py_DNS_RPC_SERVER_INFO_W2K_set_aipForwarders },
	{ discard_const_p(char, "pExtension1"), py_DNS_RPC_SERVER_INFO_W2K_get_pExtension1, py_DNS_RPC_SERVER_INFO_W2K_set_pExtension1 },
	{ discard_const_p(char, "pExtension2"), py_DNS_RPC_SERVER_INFO_W2K_get_pExtension2, py_DNS_RPC_SERVER_INFO_W2K_set_pExtension2 },
	{ discard_const_p(char, "pExtension3"), py_DNS_RPC_SERVER_INFO_W2K_get_pExtension3, py_DNS_RPC_SERVER_INFO_W2K_set_pExtension3 },
	{ discard_const_p(char, "pExtension4"), py_DNS_RPC_SERVER_INFO_W2K_get_pExtension4, py_DNS_RPC_SERVER_INFO_W2K_set_pExtension4 },
	{ discard_const_p(char, "pExtension5"), py_DNS_RPC_SERVER_INFO_W2K_get_pExtension5, py_DNS_RPC_SERVER_INFO_W2K_set_pExtension5 },
	{ discard_const_p(char, "dwLogLevel"), py_DNS_RPC_SERVER_INFO_W2K_get_dwLogLevel, py_DNS_RPC_SERVER_INFO_W2K_set_dwLogLevel },
	{ discard_const_p(char, "dwDebugLevel"), py_DNS_RPC_SERVER_INFO_W2K_get_dwDebugLevel, py_DNS_RPC_SERVER_INFO_W2K_set_dwDebugLevel },
	{ discard_const_p(char, "dwForwardTimeout"), py_DNS_RPC_SERVER_INFO_W2K_get_dwForwardTimeout, py_DNS_RPC_SERVER_INFO_W2K_set_dwForwardTimeout },
	{ discard_const_p(char, "dwRpcProtocol"), py_DNS_RPC_SERVER_INFO_W2K_get_dwRpcProtocol, py_DNS_RPC_SERVER_INFO_W2K_set_dwRpcProtocol },
	{ discard_const_p(char, "dwNameCheckFlag"), py_DNS_RPC_SERVER_INFO_W2K_get_dwNameCheckFlag, py_DNS_RPC_SERVER_INFO_W2K_set_dwNameCheckFlag },
	{ discard_const_p(char, "cAddressAnswerLimit"), py_DNS_RPC_SERVER_INFO_W2K_get_cAddressAnswerLimit, py_DNS_RPC_SERVER_INFO_W2K_set_cAddressAnswerLimit },
	{ discard_const_p(char, "dwRecursionRetry"), py_DNS_RPC_SERVER_INFO_W2K_get_dwRecursionRetry, py_DNS_RPC_SERVER_INFO_W2K_set_dwRecursionRetry },
	{ discard_const_p(char, "dwRecursionTimeout"), py_DNS_RPC_SERVER_INFO_W2K_get_dwRecursionTimeout, py_DNS_RPC_SERVER_INFO_W2K_set_dwRecursionTimeout },
	{ discard_const_p(char, "dwMaxCacheTtl"), py_DNS_RPC_SERVER_INFO_W2K_get_dwMaxCacheTtl, py_DNS_RPC_SERVER_INFO_W2K_set_dwMaxCacheTtl },
	{ discard_const_p(char, "dwDsPollingInterval"), py_DNS_RPC_SERVER_INFO_W2K_get_dwDsPollingInterval, py_DNS_RPC_SERVER_INFO_W2K_set_dwDsPollingInterval },
	{ discard_const_p(char, "dwScavengingInterval"), py_DNS_RPC_SERVER_INFO_W2K_get_dwScavengingInterval, py_DNS_RPC_SERVER_INFO_W2K_set_dwScavengingInterval },
	{ discard_const_p(char, "dwDefaultRefreshInterval"), py_DNS_RPC_SERVER_INFO_W2K_get_dwDefaultRefreshInterval, py_DNS_RPC_SERVER_INFO_W2K_set_dwDefaultRefreshInterval },
	{ discard_const_p(char, "dwDefaultNoRefreshInterval"), py_DNS_RPC_SERVER_INFO_W2K_get_dwDefaultNoRefreshInterval, py_DNS_RPC_SERVER_INFO_W2K_set_dwDefaultNoRefreshInterval },
	{ discard_const_p(char, "dwReserveArray"), py_DNS_RPC_SERVER_INFO_W2K_get_dwReserveArray, py_DNS_RPC_SERVER_INFO_W2K_set_dwReserveArray },
	{ discard_const_p(char, "fAutoReverseZones"), py_DNS_RPC_SERVER_INFO_W2K_get_fAutoReverseZones, py_DNS_RPC_SERVER_INFO_W2K_set_fAutoReverseZones },
	{ discard_const_p(char, "fAutoCacheUpdate"), py_DNS_RPC_SERVER_INFO_W2K_get_fAutoCacheUpdate, py_DNS_RPC_SERVER_INFO_W2K_set_fAutoCacheUpdate },
	{ discard_const_p(char, "fRecurseAfterForwarding"), py_DNS_RPC_SERVER_INFO_W2K_get_fRecurseAfterForwarding, py_DNS_RPC_SERVER_INFO_W2K_set_fRecurseAfterForwarding },
	{ discard_const_p(char, "fForwardDelegations"), py_DNS_RPC_SERVER_INFO_W2K_get_fForwardDelegations, py_DNS_RPC_SERVER_INFO_W2K_set_fForwardDelegations },
	{ discard_const_p(char, "fNoRecursion"), py_DNS_RPC_SERVER_INFO_W2K_get_fNoRecursion, py_DNS_RPC_SERVER_INFO_W2K_set_fNoRecursion },
	{ discard_const_p(char, "fSecureResponses"), py_DNS_RPC_SERVER_INFO_W2K_get_fSecureResponses, py_DNS_RPC_SERVER_INFO_W2K_set_fSecureResponses },
	{ discard_const_p(char, "fRoundRobin"), py_DNS_RPC_SERVER_INFO_W2K_get_fRoundRobin, py_DNS_RPC_SERVER_INFO_W2K_set_fRoundRobin },
	{ discard_const_p(char, "fLocalNetPriority"), py_DNS_RPC_SERVER_INFO_W2K_get_fLocalNetPriority, py_DNS_RPC_SERVER_INFO_W2K_set_fLocalNetPriority },
	{ discard_const_p(char, "fBindSecondaries"), py_DNS_RPC_SERVER_INFO_W2K_get_fBindSecondaries, py_DNS_RPC_SERVER_INFO_W2K_set_fBindSecondaries },
	{ discard_const_p(char, "fWriteAuthorityNs"), py_DNS_RPC_SERVER_INFO_W2K_get_fWriteAuthorityNs, py_DNS_RPC_SERVER_INFO_W2K_set_fWriteAuthorityNs },
	{ discard_const_p(char, "fStrictFileParsing"), py_DNS_RPC_SERVER_INFO_W2K_get_fStrictFileParsing, py_DNS_RPC_SERVER_INFO_W2K_set_fStrictFileParsing },
	{ discard_const_p(char, "fLooseWildcarding"), py_DNS_RPC_SERVER_INFO_W2K_get_fLooseWildcarding, py_DNS_RPC_SERVER_INFO_W2K_set_fLooseWildcarding },
	{ discard_const_p(char, "fDefaultAgingState"), py_DNS_RPC_SERVER_INFO_W2K_get_fDefaultAgingState, py_DNS_RPC_SERVER_INFO_W2K_set_fDefaultAgingState },
	{ discard_const_p(char, "fReserveArray"), py_DNS_RPC_SERVER_INFO_W2K_get_fReserveArray, py_DNS_RPC_SERVER_INFO_W2K_set_fReserveArray },
	{ NULL }
};

static PyObject *py_DNS_RPC_SERVER_INFO_W2K_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_SERVER_INFO_W2K, type);
}


static PyTypeObject DNS_RPC_SERVER_INFO_W2K_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.DNS_RPC_SERVER_INFO_W2K",
	.tp_getset = py_DNS_RPC_SERVER_INFO_W2K_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DNS_RPC_SERVER_INFO_W2K_new,
};


static PyObject *py_DNS_EXTENSION_get_extension(PyObject *obj, void *closure)
{
	struct DNS_EXTENSION *object = (struct DNS_EXTENSION *)pytalloc_get_ptr(obj);
	PyObject *py_extension;
	if (object->extension == NULL) {
		py_extension = Py_None;
		Py_INCREF(py_extension);
	} else {
		if (object->extension == NULL) {
			py_extension = Py_None;
			Py_INCREF(py_extension);
		} else {
			py_extension = PyUnicode_Decode(object->extension, strlen(object->extension), "utf-8", "ignore");
		}
	}
	return py_extension;
}

static int py_DNS_EXTENSION_set_extension(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_EXTENSION *object = (struct DNS_EXTENSION *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->extension = NULL;
	} else {
		object->extension = NULL;
		if (PyUnicode_Check(value)) {
			object->extension = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->extension = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_EXTENSION_getsetters[] = {
	{ discard_const_p(char, "extension"), py_DNS_EXTENSION_get_extension, py_DNS_EXTENSION_set_extension },
	{ NULL }
};

static PyObject *py_DNS_EXTENSION_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_EXTENSION, type);
}


static PyTypeObject DNS_EXTENSION_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.DNS_EXTENSION",
	.tp_getset = py_DNS_EXTENSION_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DNS_EXTENSION_new,
};


static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_dwRpcStructureVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwRpcStructureVersion;
	py_dwRpcStructureVersion = PyInt_FromLong(object->dwRpcStructureVersion);
	return py_dwRpcStructureVersion;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_dwRpcStructureVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwRpcStructureVersion = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_dwReserved0(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwReserved0;
	py_dwReserved0 = PyInt_FromLong(object->dwReserved0);
	return py_dwReserved0;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_dwReserved0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwReserved0 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_dwVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwVersion;
	py_dwVersion = PyInt_FromLong(object->dwVersion);
	return py_dwVersion;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_dwVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwVersion = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_fBootMethod(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_fBootMethod;
	py_fBootMethod = PyInt_FromLong(object->fBootMethod);
	return py_fBootMethod;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_fBootMethod(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->fBootMethod = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->fBootMethod = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_fAdminConfigured(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_fAdminConfigured;
	py_fAdminConfigured = PyInt_FromLong(object->fAdminConfigured);
	return py_fAdminConfigured;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_fAdminConfigured(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fAdminConfigured = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_fAllowUpdate(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_fAllowUpdate;
	py_fAllowUpdate = PyInt_FromLong(object->fAllowUpdate);
	return py_fAllowUpdate;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_fAllowUpdate(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fAllowUpdate = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_fDsAvailable(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_fDsAvailable;
	py_fDsAvailable = PyInt_FromLong(object->fDsAvailable);
	return py_fDsAvailable;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_fDsAvailable(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fDsAvailable = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_pszServerName(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_pszServerName;
	if (object->pszServerName == NULL) {
		py_pszServerName = Py_None;
		Py_INCREF(py_pszServerName);
	} else {
		if (object->pszServerName == NULL) {
			py_pszServerName = Py_None;
			Py_INCREF(py_pszServerName);
		} else {
			py_pszServerName = PyUnicode_Decode(object->pszServerName, strlen(object->pszServerName), "utf-8", "ignore");
		}
	}
	return py_pszServerName;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_pszServerName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszServerName = NULL;
	} else {
		object->pszServerName = NULL;
		if (PyUnicode_Check(value)) {
			object->pszServerName = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszServerName = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_pszDsContainer(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_pszDsContainer;
	if (object->pszDsContainer == NULL) {
		py_pszDsContainer = Py_None;
		Py_INCREF(py_pszDsContainer);
	} else {
		if (object->pszDsContainer == NULL) {
			py_pszDsContainer = Py_None;
			Py_INCREF(py_pszDsContainer);
		} else {
			py_pszDsContainer = PyUnicode_Decode(object->pszDsContainer, strlen(object->pszDsContainer), "utf-8", "ignore");
		}
	}
	return py_pszDsContainer;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_pszDsContainer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszDsContainer = NULL;
	} else {
		object->pszDsContainer = NULL;
		if (PyUnicode_Check(value)) {
			object->pszDsContainer = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszDsContainer = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_aipServerAddrs(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_aipServerAddrs;
	if (object->aipServerAddrs == NULL) {
		py_aipServerAddrs = Py_None;
		Py_INCREF(py_aipServerAddrs);
	} else {
		py_aipServerAddrs = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipServerAddrs, object->aipServerAddrs);
	}
	return py_aipServerAddrs;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_aipServerAddrs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->aipServerAddrs);
	if (value == Py_None) {
		object->aipServerAddrs = NULL;
	} else {
		object->aipServerAddrs = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipServerAddrs = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_aipListenAddrs(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_aipListenAddrs;
	if (object->aipListenAddrs == NULL) {
		py_aipListenAddrs = Py_None;
		Py_INCREF(py_aipListenAddrs);
	} else {
		py_aipListenAddrs = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipListenAddrs, object->aipListenAddrs);
	}
	return py_aipListenAddrs;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_aipListenAddrs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->aipListenAddrs);
	if (value == Py_None) {
		object->aipListenAddrs = NULL;
	} else {
		object->aipListenAddrs = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipListenAddrs = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_aipForwarders(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_aipForwarders;
	if (object->aipForwarders == NULL) {
		py_aipForwarders = Py_None;
		Py_INCREF(py_aipForwarders);
	} else {
		py_aipForwarders = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipForwarders, object->aipForwarders);
	}
	return py_aipForwarders;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_aipForwarders(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->aipForwarders);
	if (value == Py_None) {
		object->aipForwarders = NULL;
	} else {
		object->aipForwarders = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipForwarders = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_aipLogFilter(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_aipLogFilter;
	if (object->aipLogFilter == NULL) {
		py_aipLogFilter = Py_None;
		Py_INCREF(py_aipLogFilter);
	} else {
		py_aipLogFilter = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipLogFilter, object->aipLogFilter);
	}
	return py_aipLogFilter;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_aipLogFilter(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->aipLogFilter);
	if (value == Py_None) {
		object->aipLogFilter = NULL;
	} else {
		object->aipLogFilter = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipLogFilter = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_pwszLogFilePath(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_pwszLogFilePath;
	if (object->pwszLogFilePath == NULL) {
		py_pwszLogFilePath = Py_None;
		Py_INCREF(py_pwszLogFilePath);
	} else {
		if (object->pwszLogFilePath == NULL) {
			py_pwszLogFilePath = Py_None;
			Py_INCREF(py_pwszLogFilePath);
		} else {
			py_pwszLogFilePath = PyUnicode_Decode(object->pwszLogFilePath, strlen(object->pwszLogFilePath), "utf-8", "ignore");
		}
	}
	return py_pwszLogFilePath;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_pwszLogFilePath(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pwszLogFilePath = NULL;
	} else {
		object->pwszLogFilePath = NULL;
		if (PyUnicode_Check(value)) {
			object->pwszLogFilePath = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pwszLogFilePath = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_pszDomainName(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_pszDomainName;
	if (object->pszDomainName == NULL) {
		py_pszDomainName = Py_None;
		Py_INCREF(py_pszDomainName);
	} else {
		if (object->pszDomainName == NULL) {
			py_pszDomainName = Py_None;
			Py_INCREF(py_pszDomainName);
		} else {
			py_pszDomainName = PyUnicode_Decode(object->pszDomainName, strlen(object->pszDomainName), "utf-8", "ignore");
		}
	}
	return py_pszDomainName;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_pszDomainName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszDomainName = NULL;
	} else {
		object->pszDomainName = NULL;
		if (PyUnicode_Check(value)) {
			object->pszDomainName = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszDomainName = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_pszForestName(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_pszForestName;
	if (object->pszForestName == NULL) {
		py_pszForestName = Py_None;
		Py_INCREF(py_pszForestName);
	} else {
		if (object->pszForestName == NULL) {
			py_pszForestName = Py_None;
			Py_INCREF(py_pszForestName);
		} else {
			py_pszForestName = PyUnicode_Decode(object->pszForestName, strlen(object->pszForestName), "utf-8", "ignore");
		}
	}
	return py_pszForestName;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_pszForestName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszForestName = NULL;
	} else {
		object->pszForestName = NULL;
		if (PyUnicode_Check(value)) {
			object->pszForestName = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszForestName = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_pszDomainDirectoryPartition(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_pszDomainDirectoryPartition;
	if (object->pszDomainDirectoryPartition == NULL) {
		py_pszDomainDirectoryPartition = Py_None;
		Py_INCREF(py_pszDomainDirectoryPartition);
	} else {
		if (object->pszDomainDirectoryPartition == NULL) {
			py_pszDomainDirectoryPartition = Py_None;
			Py_INCREF(py_pszDomainDirectoryPartition);
		} else {
			py_pszDomainDirectoryPartition = PyUnicode_Decode(object->pszDomainDirectoryPartition, strlen(object->pszDomainDirectoryPartition), "utf-8", "ignore");
		}
	}
	return py_pszDomainDirectoryPartition;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_pszDomainDirectoryPartition(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszDomainDirectoryPartition = NULL;
	} else {
		object->pszDomainDirectoryPartition = NULL;
		if (PyUnicode_Check(value)) {
			object->pszDomainDirectoryPartition = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszDomainDirectoryPartition = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_pszForestDirectoryPartition(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_pszForestDirectoryPartition;
	if (object->pszForestDirectoryPartition == NULL) {
		py_pszForestDirectoryPartition = Py_None;
		Py_INCREF(py_pszForestDirectoryPartition);
	} else {
		if (object->pszForestDirectoryPartition == NULL) {
			py_pszForestDirectoryPartition = Py_None;
			Py_INCREF(py_pszForestDirectoryPartition);
		} else {
			py_pszForestDirectoryPartition = PyUnicode_Decode(object->pszForestDirectoryPartition, strlen(object->pszForestDirectoryPartition), "utf-8", "ignore");
		}
	}
	return py_pszForestDirectoryPartition;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_pszForestDirectoryPartition(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszForestDirectoryPartition = NULL;
	} else {
		object->pszForestDirectoryPartition = NULL;
		if (PyUnicode_Check(value)) {
			object->pszForestDirectoryPartition = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszForestDirectoryPartition = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_pExtensions(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_pExtensions;
	py_pExtensions = PyList_New(6);
	if (py_pExtensions == NULL) {
		return NULL;
	}
	{
		int pExtensions_cntr_0;
		for (pExtensions_cntr_0 = 0; pExtensions_cntr_0 < 6; pExtensions_cntr_0++) {
			PyObject *py_pExtensions_0;
			py_pExtensions_0 = pytalloc_reference_ex(&DNS_EXTENSION_Type, object->pExtensions, &object->pExtensions[pExtensions_cntr_0]);
			PyList_SetItem(py_pExtensions, pExtensions_cntr_0, py_pExtensions_0);
		}
	}
	return py_pExtensions;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_pExtensions(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int pExtensions_cntr_0;
		for (pExtensions_cntr_0 = 0; pExtensions_cntr_0 < PyList_GET_SIZE(value); pExtensions_cntr_0++) {
			PY_CHECK_TYPE(&DNS_EXTENSION_Type, PyList_GET_ITEM(value, pExtensions_cntr_0), return -1;);
			if (talloc_reference(object->pExtensions, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, pExtensions_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pExtensions[pExtensions_cntr_0] = *(struct DNS_EXTENSION *)pytalloc_get_ptr(PyList_GET_ITEM(value, pExtensions_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_dwLogLevel(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwLogLevel;
	py_dwLogLevel = PyInt_FromLong(object->dwLogLevel);
	return py_dwLogLevel;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_dwLogLevel(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwLogLevel = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_dwDebugLevel(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwDebugLevel;
	py_dwDebugLevel = PyInt_FromLong(object->dwDebugLevel);
	return py_dwDebugLevel;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_dwDebugLevel(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwDebugLevel = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_dwForwardTimeout(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwForwardTimeout;
	py_dwForwardTimeout = PyInt_FromLong(object->dwForwardTimeout);
	return py_dwForwardTimeout;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_dwForwardTimeout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwForwardTimeout = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_dwRpcProtocol(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwRpcProtocol;
	py_dwRpcProtocol = PyInt_FromLong(object->dwRpcProtocol);
	return py_dwRpcProtocol;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_dwRpcProtocol(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwRpcProtocol = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_dwNameCheckFlag(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwNameCheckFlag;
	py_dwNameCheckFlag = PyInt_FromLong(object->dwNameCheckFlag);
	return py_dwNameCheckFlag;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_dwNameCheckFlag(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->dwNameCheckFlag = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->dwNameCheckFlag = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_cAddressAnswerLimit(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_cAddressAnswerLimit;
	py_cAddressAnswerLimit = PyInt_FromLong(object->cAddressAnswerLimit);
	return py_cAddressAnswerLimit;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_cAddressAnswerLimit(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->cAddressAnswerLimit = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_dwRecursionRetry(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwRecursionRetry;
	py_dwRecursionRetry = PyInt_FromLong(object->dwRecursionRetry);
	return py_dwRecursionRetry;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_dwRecursionRetry(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwRecursionRetry = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_dwRecursionTimeout(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwRecursionTimeout;
	py_dwRecursionTimeout = PyInt_FromLong(object->dwRecursionTimeout);
	return py_dwRecursionTimeout;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_dwRecursionTimeout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwRecursionTimeout = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_dwMaxCacheTtl(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwMaxCacheTtl;
	py_dwMaxCacheTtl = PyInt_FromLong(object->dwMaxCacheTtl);
	return py_dwMaxCacheTtl;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_dwMaxCacheTtl(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwMaxCacheTtl = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_dwDsPollingInterval(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwDsPollingInterval;
	py_dwDsPollingInterval = PyInt_FromLong(object->dwDsPollingInterval);
	return py_dwDsPollingInterval;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_dwDsPollingInterval(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwDsPollingInterval = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_dwLocalNetPriorityNetMask(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwLocalNetPriorityNetMask;
	py_dwLocalNetPriorityNetMask = PyInt_FromLong(object->dwLocalNetPriorityNetMask);
	return py_dwLocalNetPriorityNetMask;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_dwLocalNetPriorityNetMask(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwLocalNetPriorityNetMask = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_dwScavengingInterval(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwScavengingInterval;
	py_dwScavengingInterval = PyInt_FromLong(object->dwScavengingInterval);
	return py_dwScavengingInterval;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_dwScavengingInterval(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwScavengingInterval = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_dwDefaultRefreshInterval(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwDefaultRefreshInterval;
	py_dwDefaultRefreshInterval = PyInt_FromLong(object->dwDefaultRefreshInterval);
	return py_dwDefaultRefreshInterval;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_dwDefaultRefreshInterval(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwDefaultRefreshInterval = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_dwDefaultNoRefreshInterval(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwDefaultNoRefreshInterval;
	py_dwDefaultNoRefreshInterval = PyInt_FromLong(object->dwDefaultNoRefreshInterval);
	return py_dwDefaultNoRefreshInterval;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_dwDefaultNoRefreshInterval(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwDefaultNoRefreshInterval = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_dwLastScavengeTime(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwLastScavengeTime;
	py_dwLastScavengeTime = PyInt_FromLong(object->dwLastScavengeTime);
	return py_dwLastScavengeTime;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_dwLastScavengeTime(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwLastScavengeTime = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_dwEventLogLevel(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwEventLogLevel;
	py_dwEventLogLevel = PyInt_FromLong(object->dwEventLogLevel);
	return py_dwEventLogLevel;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_dwEventLogLevel(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwEventLogLevel = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_dwLogFileMaxSize(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwLogFileMaxSize;
	py_dwLogFileMaxSize = PyInt_FromLong(object->dwLogFileMaxSize);
	return py_dwLogFileMaxSize;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_dwLogFileMaxSize(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwLogFileMaxSize = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_dwDsForestVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwDsForestVersion;
	py_dwDsForestVersion = PyInt_FromLong(object->dwDsForestVersion);
	return py_dwDsForestVersion;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_dwDsForestVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwDsForestVersion = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_dwDsDomainVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwDsDomainVersion;
	py_dwDsDomainVersion = PyInt_FromLong(object->dwDsDomainVersion);
	return py_dwDsDomainVersion;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_dwDsDomainVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwDsDomainVersion = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_dwDsDsaVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwDsDsaVersion;
	py_dwDsDsaVersion = PyInt_FromLong(object->dwDsDsaVersion);
	return py_dwDsDsaVersion;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_dwDsDsaVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwDsDsaVersion = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_dwReserveArray(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwReserveArray;
	py_dwReserveArray = PyList_New(4);
	if (py_dwReserveArray == NULL) {
		return NULL;
	}
	{
		int dwReserveArray_cntr_0;
		for (dwReserveArray_cntr_0 = 0; dwReserveArray_cntr_0 < 4; dwReserveArray_cntr_0++) {
			PyObject *py_dwReserveArray_0;
			py_dwReserveArray_0 = PyInt_FromLong(object->dwReserveArray[dwReserveArray_cntr_0]);
			PyList_SetItem(py_dwReserveArray, dwReserveArray_cntr_0, py_dwReserveArray_0);
		}
	}
	return py_dwReserveArray;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_dwReserveArray(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int dwReserveArray_cntr_0;
		for (dwReserveArray_cntr_0 = 0; dwReserveArray_cntr_0 < PyList_GET_SIZE(value); dwReserveArray_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, dwReserveArray_cntr_0), return -1;);
			object->dwReserveArray[dwReserveArray_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, dwReserveArray_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_fAutoReverseZones(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_fAutoReverseZones;
	py_fAutoReverseZones = PyInt_FromLong(object->fAutoReverseZones);
	return py_fAutoReverseZones;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_fAutoReverseZones(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fAutoReverseZones = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_fAutoCacheUpdate(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_fAutoCacheUpdate;
	py_fAutoCacheUpdate = PyInt_FromLong(object->fAutoCacheUpdate);
	return py_fAutoCacheUpdate;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_fAutoCacheUpdate(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fAutoCacheUpdate = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_fRecurseAfterForwarding(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_fRecurseAfterForwarding;
	py_fRecurseAfterForwarding = PyInt_FromLong(object->fRecurseAfterForwarding);
	return py_fRecurseAfterForwarding;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_fRecurseAfterForwarding(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fRecurseAfterForwarding = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_fForwardDelegations(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_fForwardDelegations;
	py_fForwardDelegations = PyInt_FromLong(object->fForwardDelegations);
	return py_fForwardDelegations;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_fForwardDelegations(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fForwardDelegations = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_fNoRecursion(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_fNoRecursion;
	py_fNoRecursion = PyInt_FromLong(object->fNoRecursion);
	return py_fNoRecursion;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_fNoRecursion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fNoRecursion = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_fSecureResponses(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_fSecureResponses;
	py_fSecureResponses = PyInt_FromLong(object->fSecureResponses);
	return py_fSecureResponses;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_fSecureResponses(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fSecureResponses = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_fRoundRobin(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_fRoundRobin;
	py_fRoundRobin = PyInt_FromLong(object->fRoundRobin);
	return py_fRoundRobin;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_fRoundRobin(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fRoundRobin = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_fLocalNetPriority(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_fLocalNetPriority;
	py_fLocalNetPriority = PyInt_FromLong(object->fLocalNetPriority);
	return py_fLocalNetPriority;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_fLocalNetPriority(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fLocalNetPriority = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_fBindSecondaries(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_fBindSecondaries;
	py_fBindSecondaries = PyInt_FromLong(object->fBindSecondaries);
	return py_fBindSecondaries;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_fBindSecondaries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fBindSecondaries = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_fWriteAuthorityNs(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_fWriteAuthorityNs;
	py_fWriteAuthorityNs = PyInt_FromLong(object->fWriteAuthorityNs);
	return py_fWriteAuthorityNs;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_fWriteAuthorityNs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fWriteAuthorityNs = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_fStrictFileParsing(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_fStrictFileParsing;
	py_fStrictFileParsing = PyInt_FromLong(object->fStrictFileParsing);
	return py_fStrictFileParsing;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_fStrictFileParsing(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fStrictFileParsing = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_fLooseWildcarding(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_fLooseWildcarding;
	py_fLooseWildcarding = PyInt_FromLong(object->fLooseWildcarding);
	return py_fLooseWildcarding;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_fLooseWildcarding(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fLooseWildcarding = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_fDefaultAgingState(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_fDefaultAgingState;
	py_fDefaultAgingState = PyInt_FromLong(object->fDefaultAgingState);
	return py_fDefaultAgingState;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_fDefaultAgingState(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fDefaultAgingState = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_get_fReserveArray(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_fReserveArray;
	py_fReserveArray = PyList_New(15);
	if (py_fReserveArray == NULL) {
		return NULL;
	}
	{
		int fReserveArray_cntr_0;
		for (fReserveArray_cntr_0 = 0; fReserveArray_cntr_0 < 15; fReserveArray_cntr_0++) {
			PyObject *py_fReserveArray_0;
			py_fReserveArray_0 = PyInt_FromLong(object->fReserveArray[fReserveArray_cntr_0]);
			PyList_SetItem(py_fReserveArray, fReserveArray_cntr_0, py_fReserveArray_0);
		}
	}
	return py_fReserveArray;
}

static int py_DNS_RPC_SERVER_INFO_DOTNET_set_fReserveArray(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int fReserveArray_cntr_0;
		for (fReserveArray_cntr_0 = 0; fReserveArray_cntr_0 < PyList_GET_SIZE(value); fReserveArray_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, fReserveArray_cntr_0), return -1;);
			object->fReserveArray[fReserveArray_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, fReserveArray_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_SERVER_INFO_DOTNET_getsetters[] = {
	{ discard_const_p(char, "dwRpcStructureVersion"), py_DNS_RPC_SERVER_INFO_DOTNET_get_dwRpcStructureVersion, py_DNS_RPC_SERVER_INFO_DOTNET_set_dwRpcStructureVersion },
	{ discard_const_p(char, "dwReserved0"), py_DNS_RPC_SERVER_INFO_DOTNET_get_dwReserved0, py_DNS_RPC_SERVER_INFO_DOTNET_set_dwReserved0 },
	{ discard_const_p(char, "dwVersion"), py_DNS_RPC_SERVER_INFO_DOTNET_get_dwVersion, py_DNS_RPC_SERVER_INFO_DOTNET_set_dwVersion },
	{ discard_const_p(char, "fBootMethod"), py_DNS_RPC_SERVER_INFO_DOTNET_get_fBootMethod, py_DNS_RPC_SERVER_INFO_DOTNET_set_fBootMethod },
	{ discard_const_p(char, "fAdminConfigured"), py_DNS_RPC_SERVER_INFO_DOTNET_get_fAdminConfigured, py_DNS_RPC_SERVER_INFO_DOTNET_set_fAdminConfigured },
	{ discard_const_p(char, "fAllowUpdate"), py_DNS_RPC_SERVER_INFO_DOTNET_get_fAllowUpdate, py_DNS_RPC_SERVER_INFO_DOTNET_set_fAllowUpdate },
	{ discard_const_p(char, "fDsAvailable"), py_DNS_RPC_SERVER_INFO_DOTNET_get_fDsAvailable, py_DNS_RPC_SERVER_INFO_DOTNET_set_fDsAvailable },
	{ discard_const_p(char, "pszServerName"), py_DNS_RPC_SERVER_INFO_DOTNET_get_pszServerName, py_DNS_RPC_SERVER_INFO_DOTNET_set_pszServerName },
	{ discard_const_p(char, "pszDsContainer"), py_DNS_RPC_SERVER_INFO_DOTNET_get_pszDsContainer, py_DNS_RPC_SERVER_INFO_DOTNET_set_pszDsContainer },
	{ discard_const_p(char, "aipServerAddrs"), py_DNS_RPC_SERVER_INFO_DOTNET_get_aipServerAddrs, py_DNS_RPC_SERVER_INFO_DOTNET_set_aipServerAddrs },
	{ discard_const_p(char, "aipListenAddrs"), py_DNS_RPC_SERVER_INFO_DOTNET_get_aipListenAddrs, py_DNS_RPC_SERVER_INFO_DOTNET_set_aipListenAddrs },
	{ discard_const_p(char, "aipForwarders"), py_DNS_RPC_SERVER_INFO_DOTNET_get_aipForwarders, py_DNS_RPC_SERVER_INFO_DOTNET_set_aipForwarders },
	{ discard_const_p(char, "aipLogFilter"), py_DNS_RPC_SERVER_INFO_DOTNET_get_aipLogFilter, py_DNS_RPC_SERVER_INFO_DOTNET_set_aipLogFilter },
	{ discard_const_p(char, "pwszLogFilePath"), py_DNS_RPC_SERVER_INFO_DOTNET_get_pwszLogFilePath, py_DNS_RPC_SERVER_INFO_DOTNET_set_pwszLogFilePath },
	{ discard_const_p(char, "pszDomainName"), py_DNS_RPC_SERVER_INFO_DOTNET_get_pszDomainName, py_DNS_RPC_SERVER_INFO_DOTNET_set_pszDomainName },
	{ discard_const_p(char, "pszForestName"), py_DNS_RPC_SERVER_INFO_DOTNET_get_pszForestName, py_DNS_RPC_SERVER_INFO_DOTNET_set_pszForestName },
	{ discard_const_p(char, "pszDomainDirectoryPartition"), py_DNS_RPC_SERVER_INFO_DOTNET_get_pszDomainDirectoryPartition, py_DNS_RPC_SERVER_INFO_DOTNET_set_pszDomainDirectoryPartition },
	{ discard_const_p(char, "pszForestDirectoryPartition"), py_DNS_RPC_SERVER_INFO_DOTNET_get_pszForestDirectoryPartition, py_DNS_RPC_SERVER_INFO_DOTNET_set_pszForestDirectoryPartition },
	{ discard_const_p(char, "pExtensions"), py_DNS_RPC_SERVER_INFO_DOTNET_get_pExtensions, py_DNS_RPC_SERVER_INFO_DOTNET_set_pExtensions },
	{ discard_const_p(char, "dwLogLevel"), py_DNS_RPC_SERVER_INFO_DOTNET_get_dwLogLevel, py_DNS_RPC_SERVER_INFO_DOTNET_set_dwLogLevel },
	{ discard_const_p(char, "dwDebugLevel"), py_DNS_RPC_SERVER_INFO_DOTNET_get_dwDebugLevel, py_DNS_RPC_SERVER_INFO_DOTNET_set_dwDebugLevel },
	{ discard_const_p(char, "dwForwardTimeout"), py_DNS_RPC_SERVER_INFO_DOTNET_get_dwForwardTimeout, py_DNS_RPC_SERVER_INFO_DOTNET_set_dwForwardTimeout },
	{ discard_const_p(char, "dwRpcProtocol"), py_DNS_RPC_SERVER_INFO_DOTNET_get_dwRpcProtocol, py_DNS_RPC_SERVER_INFO_DOTNET_set_dwRpcProtocol },
	{ discard_const_p(char, "dwNameCheckFlag"), py_DNS_RPC_SERVER_INFO_DOTNET_get_dwNameCheckFlag, py_DNS_RPC_SERVER_INFO_DOTNET_set_dwNameCheckFlag },
	{ discard_const_p(char, "cAddressAnswerLimit"), py_DNS_RPC_SERVER_INFO_DOTNET_get_cAddressAnswerLimit, py_DNS_RPC_SERVER_INFO_DOTNET_set_cAddressAnswerLimit },
	{ discard_const_p(char, "dwRecursionRetry"), py_DNS_RPC_SERVER_INFO_DOTNET_get_dwRecursionRetry, py_DNS_RPC_SERVER_INFO_DOTNET_set_dwRecursionRetry },
	{ discard_const_p(char, "dwRecursionTimeout"), py_DNS_RPC_SERVER_INFO_DOTNET_get_dwRecursionTimeout, py_DNS_RPC_SERVER_INFO_DOTNET_set_dwRecursionTimeout },
	{ discard_const_p(char, "dwMaxCacheTtl"), py_DNS_RPC_SERVER_INFO_DOTNET_get_dwMaxCacheTtl, py_DNS_RPC_SERVER_INFO_DOTNET_set_dwMaxCacheTtl },
	{ discard_const_p(char, "dwDsPollingInterval"), py_DNS_RPC_SERVER_INFO_DOTNET_get_dwDsPollingInterval, py_DNS_RPC_SERVER_INFO_DOTNET_set_dwDsPollingInterval },
	{ discard_const_p(char, "dwLocalNetPriorityNetMask"), py_DNS_RPC_SERVER_INFO_DOTNET_get_dwLocalNetPriorityNetMask, py_DNS_RPC_SERVER_INFO_DOTNET_set_dwLocalNetPriorityNetMask },
	{ discard_const_p(char, "dwScavengingInterval"), py_DNS_RPC_SERVER_INFO_DOTNET_get_dwScavengingInterval, py_DNS_RPC_SERVER_INFO_DOTNET_set_dwScavengingInterval },
	{ discard_const_p(char, "dwDefaultRefreshInterval"), py_DNS_RPC_SERVER_INFO_DOTNET_get_dwDefaultRefreshInterval, py_DNS_RPC_SERVER_INFO_DOTNET_set_dwDefaultRefreshInterval },
	{ discard_const_p(char, "dwDefaultNoRefreshInterval"), py_DNS_RPC_SERVER_INFO_DOTNET_get_dwDefaultNoRefreshInterval, py_DNS_RPC_SERVER_INFO_DOTNET_set_dwDefaultNoRefreshInterval },
	{ discard_const_p(char, "dwLastScavengeTime"), py_DNS_RPC_SERVER_INFO_DOTNET_get_dwLastScavengeTime, py_DNS_RPC_SERVER_INFO_DOTNET_set_dwLastScavengeTime },
	{ discard_const_p(char, "dwEventLogLevel"), py_DNS_RPC_SERVER_INFO_DOTNET_get_dwEventLogLevel, py_DNS_RPC_SERVER_INFO_DOTNET_set_dwEventLogLevel },
	{ discard_const_p(char, "dwLogFileMaxSize"), py_DNS_RPC_SERVER_INFO_DOTNET_get_dwLogFileMaxSize, py_DNS_RPC_SERVER_INFO_DOTNET_set_dwLogFileMaxSize },
	{ discard_const_p(char, "dwDsForestVersion"), py_DNS_RPC_SERVER_INFO_DOTNET_get_dwDsForestVersion, py_DNS_RPC_SERVER_INFO_DOTNET_set_dwDsForestVersion },
	{ discard_const_p(char, "dwDsDomainVersion"), py_DNS_RPC_SERVER_INFO_DOTNET_get_dwDsDomainVersion, py_DNS_RPC_SERVER_INFO_DOTNET_set_dwDsDomainVersion },
	{ discard_const_p(char, "dwDsDsaVersion"), py_DNS_RPC_SERVER_INFO_DOTNET_get_dwDsDsaVersion, py_DNS_RPC_SERVER_INFO_DOTNET_set_dwDsDsaVersion },
	{ discard_const_p(char, "dwReserveArray"), py_DNS_RPC_SERVER_INFO_DOTNET_get_dwReserveArray, py_DNS_RPC_SERVER_INFO_DOTNET_set_dwReserveArray },
	{ discard_const_p(char, "fAutoReverseZones"), py_DNS_RPC_SERVER_INFO_DOTNET_get_fAutoReverseZones, py_DNS_RPC_SERVER_INFO_DOTNET_set_fAutoReverseZones },
	{ discard_const_p(char, "fAutoCacheUpdate"), py_DNS_RPC_SERVER_INFO_DOTNET_get_fAutoCacheUpdate, py_DNS_RPC_SERVER_INFO_DOTNET_set_fAutoCacheUpdate },
	{ discard_const_p(char, "fRecurseAfterForwarding"), py_DNS_RPC_SERVER_INFO_DOTNET_get_fRecurseAfterForwarding, py_DNS_RPC_SERVER_INFO_DOTNET_set_fRecurseAfterForwarding },
	{ discard_const_p(char, "fForwardDelegations"), py_DNS_RPC_SERVER_INFO_DOTNET_get_fForwardDelegations, py_DNS_RPC_SERVER_INFO_DOTNET_set_fForwardDelegations },
	{ discard_const_p(char, "fNoRecursion"), py_DNS_RPC_SERVER_INFO_DOTNET_get_fNoRecursion, py_DNS_RPC_SERVER_INFO_DOTNET_set_fNoRecursion },
	{ discard_const_p(char, "fSecureResponses"), py_DNS_RPC_SERVER_INFO_DOTNET_get_fSecureResponses, py_DNS_RPC_SERVER_INFO_DOTNET_set_fSecureResponses },
	{ discard_const_p(char, "fRoundRobin"), py_DNS_RPC_SERVER_INFO_DOTNET_get_fRoundRobin, py_DNS_RPC_SERVER_INFO_DOTNET_set_fRoundRobin },
	{ discard_const_p(char, "fLocalNetPriority"), py_DNS_RPC_SERVER_INFO_DOTNET_get_fLocalNetPriority, py_DNS_RPC_SERVER_INFO_DOTNET_set_fLocalNetPriority },
	{ discard_const_p(char, "fBindSecondaries"), py_DNS_RPC_SERVER_INFO_DOTNET_get_fBindSecondaries, py_DNS_RPC_SERVER_INFO_DOTNET_set_fBindSecondaries },
	{ discard_const_p(char, "fWriteAuthorityNs"), py_DNS_RPC_SERVER_INFO_DOTNET_get_fWriteAuthorityNs, py_DNS_RPC_SERVER_INFO_DOTNET_set_fWriteAuthorityNs },
	{ discard_const_p(char, "fStrictFileParsing"), py_DNS_RPC_SERVER_INFO_DOTNET_get_fStrictFileParsing, py_DNS_RPC_SERVER_INFO_DOTNET_set_fStrictFileParsing },
	{ discard_const_p(char, "fLooseWildcarding"), py_DNS_RPC_SERVER_INFO_DOTNET_get_fLooseWildcarding, py_DNS_RPC_SERVER_INFO_DOTNET_set_fLooseWildcarding },
	{ discard_const_p(char, "fDefaultAgingState"), py_DNS_RPC_SERVER_INFO_DOTNET_get_fDefaultAgingState, py_DNS_RPC_SERVER_INFO_DOTNET_set_fDefaultAgingState },
	{ discard_const_p(char, "fReserveArray"), py_DNS_RPC_SERVER_INFO_DOTNET_get_fReserveArray, py_DNS_RPC_SERVER_INFO_DOTNET_set_fReserveArray },
	{ NULL }
};

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_SERVER_INFO_DOTNET, type);
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_ndr_pack(PyObject *py_obj)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_DNS_RPC_SERVER_INFO_DOTNET);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_DNS_RPC_SERVER_INFO_DOTNET);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_DNS_RPC_SERVER_INFO_DOTNET);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_DNS_RPC_SERVER_INFO_DOTNET_ndr_print(PyObject *py_obj)
{
	struct DNS_RPC_SERVER_INFO_DOTNET *object = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_DNS_RPC_SERVER_INFO_DOTNET, "DNS_RPC_SERVER_INFO_DOTNET", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_DNS_RPC_SERVER_INFO_DOTNET_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_DNS_RPC_SERVER_INFO_DOTNET_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_DNS_RPC_SERVER_INFO_DOTNET_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_DNS_RPC_SERVER_INFO_DOTNET_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject DNS_RPC_SERVER_INFO_DOTNET_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.DNS_RPC_SERVER_INFO_DOTNET",
	.tp_getset = py_DNS_RPC_SERVER_INFO_DOTNET_getsetters,
	.tp_methods = py_DNS_RPC_SERVER_INFO_DOTNET_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DNS_RPC_SERVER_INFO_DOTNET_new,
};


static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwRpcStructureVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_dwRpcStructureVersion;
	py_dwRpcStructureVersion = PyInt_FromLong(object->dwRpcStructureVersion);
	return py_dwRpcStructureVersion;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwRpcStructureVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwRpcStructureVersion = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwReserved0(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_dwReserved0;
	py_dwReserved0 = PyInt_FromLong(object->dwReserved0);
	return py_dwReserved0;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwReserved0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwReserved0 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_dwVersion;
	py_dwVersion = PyInt_FromLong(object->dwVersion);
	return py_dwVersion;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwVersion = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_fBootMethod(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_fBootMethod;
	py_fBootMethod = PyInt_FromLong(object->fBootMethod);
	return py_fBootMethod;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_fBootMethod(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->fBootMethod = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->fBootMethod = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_fAdminConfigured(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_fAdminConfigured;
	py_fAdminConfigured = PyInt_FromLong(object->fAdminConfigured);
	return py_fAdminConfigured;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_fAdminConfigured(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fAdminConfigured = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_fAllowUpdate(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_fAllowUpdate;
	py_fAllowUpdate = PyInt_FromLong(object->fAllowUpdate);
	return py_fAllowUpdate;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_fAllowUpdate(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fAllowUpdate = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_fDsAvailable(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_fDsAvailable;
	py_fDsAvailable = PyInt_FromLong(object->fDsAvailable);
	return py_fDsAvailable;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_fDsAvailable(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fDsAvailable = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_pszServerName(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_pszServerName;
	if (object->pszServerName == NULL) {
		py_pszServerName = Py_None;
		Py_INCREF(py_pszServerName);
	} else {
		if (object->pszServerName == NULL) {
			py_pszServerName = Py_None;
			Py_INCREF(py_pszServerName);
		} else {
			py_pszServerName = PyUnicode_Decode(object->pszServerName, strlen(object->pszServerName), "utf-8", "ignore");
		}
	}
	return py_pszServerName;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_pszServerName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszServerName = NULL;
	} else {
		object->pszServerName = NULL;
		if (PyUnicode_Check(value)) {
			object->pszServerName = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszServerName = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_pszDsContainer(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_pszDsContainer;
	if (object->pszDsContainer == NULL) {
		py_pszDsContainer = Py_None;
		Py_INCREF(py_pszDsContainer);
	} else {
		if (object->pszDsContainer == NULL) {
			py_pszDsContainer = Py_None;
			Py_INCREF(py_pszDsContainer);
		} else {
			py_pszDsContainer = PyUnicode_Decode(object->pszDsContainer, strlen(object->pszDsContainer), "utf-8", "ignore");
		}
	}
	return py_pszDsContainer;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_pszDsContainer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszDsContainer = NULL;
	} else {
		object->pszDsContainer = NULL;
		if (PyUnicode_Check(value)) {
			object->pszDsContainer = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszDsContainer = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_aipServerAddrs(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_aipServerAddrs;
	if (object->aipServerAddrs == NULL) {
		py_aipServerAddrs = Py_None;
		Py_INCREF(py_aipServerAddrs);
	} else {
		py_aipServerAddrs = pytalloc_reference_ex(&DNS_ADDR_ARRAY_Type, object->aipServerAddrs, object->aipServerAddrs);
	}
	return py_aipServerAddrs;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_aipServerAddrs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->aipServerAddrs);
	if (value == Py_None) {
		object->aipServerAddrs = NULL;
	} else {
		object->aipServerAddrs = NULL;
		PY_CHECK_TYPE(&DNS_ADDR_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipServerAddrs = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_aipListenAddrs(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_aipListenAddrs;
	if (object->aipListenAddrs == NULL) {
		py_aipListenAddrs = Py_None;
		Py_INCREF(py_aipListenAddrs);
	} else {
		py_aipListenAddrs = pytalloc_reference_ex(&DNS_ADDR_ARRAY_Type, object->aipListenAddrs, object->aipListenAddrs);
	}
	return py_aipListenAddrs;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_aipListenAddrs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->aipListenAddrs);
	if (value == Py_None) {
		object->aipListenAddrs = NULL;
	} else {
		object->aipListenAddrs = NULL;
		PY_CHECK_TYPE(&DNS_ADDR_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipListenAddrs = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_aipForwarders(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_aipForwarders;
	if (object->aipForwarders == NULL) {
		py_aipForwarders = Py_None;
		Py_INCREF(py_aipForwarders);
	} else {
		py_aipForwarders = pytalloc_reference_ex(&DNS_ADDR_ARRAY_Type, object->aipForwarders, object->aipForwarders);
	}
	return py_aipForwarders;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_aipForwarders(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->aipForwarders);
	if (value == Py_None) {
		object->aipForwarders = NULL;
	} else {
		object->aipForwarders = NULL;
		PY_CHECK_TYPE(&DNS_ADDR_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipForwarders = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_aipLogFilter(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_aipLogFilter;
	if (object->aipLogFilter == NULL) {
		py_aipLogFilter = Py_None;
		Py_INCREF(py_aipLogFilter);
	} else {
		py_aipLogFilter = pytalloc_reference_ex(&DNS_ADDR_ARRAY_Type, object->aipLogFilter, object->aipLogFilter);
	}
	return py_aipLogFilter;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_aipLogFilter(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->aipLogFilter);
	if (value == Py_None) {
		object->aipLogFilter = NULL;
	} else {
		object->aipLogFilter = NULL;
		PY_CHECK_TYPE(&DNS_ADDR_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipLogFilter = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_pwszLogFilePath(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_pwszLogFilePath;
	if (object->pwszLogFilePath == NULL) {
		py_pwszLogFilePath = Py_None;
		Py_INCREF(py_pwszLogFilePath);
	} else {
		if (object->pwszLogFilePath == NULL) {
			py_pwszLogFilePath = Py_None;
			Py_INCREF(py_pwszLogFilePath);
		} else {
			py_pwszLogFilePath = PyUnicode_Decode(object->pwszLogFilePath, strlen(object->pwszLogFilePath), "utf-8", "ignore");
		}
	}
	return py_pwszLogFilePath;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_pwszLogFilePath(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pwszLogFilePath = NULL;
	} else {
		object->pwszLogFilePath = NULL;
		if (PyUnicode_Check(value)) {
			object->pwszLogFilePath = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pwszLogFilePath = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_pszDomainName(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_pszDomainName;
	if (object->pszDomainName == NULL) {
		py_pszDomainName = Py_None;
		Py_INCREF(py_pszDomainName);
	} else {
		if (object->pszDomainName == NULL) {
			py_pszDomainName = Py_None;
			Py_INCREF(py_pszDomainName);
		} else {
			py_pszDomainName = PyUnicode_Decode(object->pszDomainName, strlen(object->pszDomainName), "utf-8", "ignore");
		}
	}
	return py_pszDomainName;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_pszDomainName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszDomainName = NULL;
	} else {
		object->pszDomainName = NULL;
		if (PyUnicode_Check(value)) {
			object->pszDomainName = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszDomainName = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_pszForestName(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_pszForestName;
	if (object->pszForestName == NULL) {
		py_pszForestName = Py_None;
		Py_INCREF(py_pszForestName);
	} else {
		if (object->pszForestName == NULL) {
			py_pszForestName = Py_None;
			Py_INCREF(py_pszForestName);
		} else {
			py_pszForestName = PyUnicode_Decode(object->pszForestName, strlen(object->pszForestName), "utf-8", "ignore");
		}
	}
	return py_pszForestName;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_pszForestName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszForestName = NULL;
	} else {
		object->pszForestName = NULL;
		if (PyUnicode_Check(value)) {
			object->pszForestName = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszForestName = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_pszDomainDirectoryPartition(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_pszDomainDirectoryPartition;
	if (object->pszDomainDirectoryPartition == NULL) {
		py_pszDomainDirectoryPartition = Py_None;
		Py_INCREF(py_pszDomainDirectoryPartition);
	} else {
		if (object->pszDomainDirectoryPartition == NULL) {
			py_pszDomainDirectoryPartition = Py_None;
			Py_INCREF(py_pszDomainDirectoryPartition);
		} else {
			py_pszDomainDirectoryPartition = PyUnicode_Decode(object->pszDomainDirectoryPartition, strlen(object->pszDomainDirectoryPartition), "utf-8", "ignore");
		}
	}
	return py_pszDomainDirectoryPartition;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_pszDomainDirectoryPartition(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszDomainDirectoryPartition = NULL;
	} else {
		object->pszDomainDirectoryPartition = NULL;
		if (PyUnicode_Check(value)) {
			object->pszDomainDirectoryPartition = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszDomainDirectoryPartition = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_pszForestDirectoryPartition(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_pszForestDirectoryPartition;
	if (object->pszForestDirectoryPartition == NULL) {
		py_pszForestDirectoryPartition = Py_None;
		Py_INCREF(py_pszForestDirectoryPartition);
	} else {
		if (object->pszForestDirectoryPartition == NULL) {
			py_pszForestDirectoryPartition = Py_None;
			Py_INCREF(py_pszForestDirectoryPartition);
		} else {
			py_pszForestDirectoryPartition = PyUnicode_Decode(object->pszForestDirectoryPartition, strlen(object->pszForestDirectoryPartition), "utf-8", "ignore");
		}
	}
	return py_pszForestDirectoryPartition;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_pszForestDirectoryPartition(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszForestDirectoryPartition = NULL;
	} else {
		object->pszForestDirectoryPartition = NULL;
		if (PyUnicode_Check(value)) {
			object->pszForestDirectoryPartition = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszForestDirectoryPartition = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_pExtensions(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_pExtensions;
	py_pExtensions = PyList_New(6);
	if (py_pExtensions == NULL) {
		return NULL;
	}
	{
		int pExtensions_cntr_0;
		for (pExtensions_cntr_0 = 0; pExtensions_cntr_0 < 6; pExtensions_cntr_0++) {
			PyObject *py_pExtensions_0;
			py_pExtensions_0 = pytalloc_reference_ex(&DNS_EXTENSION_Type, object->pExtensions, &object->pExtensions[pExtensions_cntr_0]);
			PyList_SetItem(py_pExtensions, pExtensions_cntr_0, py_pExtensions_0);
		}
	}
	return py_pExtensions;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_pExtensions(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int pExtensions_cntr_0;
		for (pExtensions_cntr_0 = 0; pExtensions_cntr_0 < PyList_GET_SIZE(value); pExtensions_cntr_0++) {
			PY_CHECK_TYPE(&DNS_EXTENSION_Type, PyList_GET_ITEM(value, pExtensions_cntr_0), return -1;);
			if (talloc_reference(object->pExtensions, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, pExtensions_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pExtensions[pExtensions_cntr_0] = *(struct DNS_EXTENSION *)pytalloc_get_ptr(PyList_GET_ITEM(value, pExtensions_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwLogLevel(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_dwLogLevel;
	py_dwLogLevel = PyInt_FromLong(object->dwLogLevel);
	return py_dwLogLevel;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwLogLevel(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwLogLevel = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwDebugLevel(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_dwDebugLevel;
	py_dwDebugLevel = PyInt_FromLong(object->dwDebugLevel);
	return py_dwDebugLevel;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwDebugLevel(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwDebugLevel = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwForwardTimeout(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_dwForwardTimeout;
	py_dwForwardTimeout = PyInt_FromLong(object->dwForwardTimeout);
	return py_dwForwardTimeout;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwForwardTimeout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwForwardTimeout = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwRpcProtocol(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_dwRpcProtocol;
	py_dwRpcProtocol = PyInt_FromLong(object->dwRpcProtocol);
	return py_dwRpcProtocol;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwRpcProtocol(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwRpcProtocol = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwNameCheckFlag(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_dwNameCheckFlag;
	py_dwNameCheckFlag = PyInt_FromLong(object->dwNameCheckFlag);
	return py_dwNameCheckFlag;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwNameCheckFlag(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->dwNameCheckFlag = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->dwNameCheckFlag = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_cAddressAnswerLimit(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_cAddressAnswerLimit;
	py_cAddressAnswerLimit = PyInt_FromLong(object->cAddressAnswerLimit);
	return py_cAddressAnswerLimit;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_cAddressAnswerLimit(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->cAddressAnswerLimit = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwRecursionRetry(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_dwRecursionRetry;
	py_dwRecursionRetry = PyInt_FromLong(object->dwRecursionRetry);
	return py_dwRecursionRetry;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwRecursionRetry(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwRecursionRetry = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwRecursionTimeout(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_dwRecursionTimeout;
	py_dwRecursionTimeout = PyInt_FromLong(object->dwRecursionTimeout);
	return py_dwRecursionTimeout;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwRecursionTimeout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwRecursionTimeout = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwMaxCacheTtl(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_dwMaxCacheTtl;
	py_dwMaxCacheTtl = PyInt_FromLong(object->dwMaxCacheTtl);
	return py_dwMaxCacheTtl;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwMaxCacheTtl(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwMaxCacheTtl = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwDsPollingInterval(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_dwDsPollingInterval;
	py_dwDsPollingInterval = PyInt_FromLong(object->dwDsPollingInterval);
	return py_dwDsPollingInterval;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwDsPollingInterval(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwDsPollingInterval = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwLocalNetPriorityNetMask(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_dwLocalNetPriorityNetMask;
	py_dwLocalNetPriorityNetMask = PyInt_FromLong(object->dwLocalNetPriorityNetMask);
	return py_dwLocalNetPriorityNetMask;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwLocalNetPriorityNetMask(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwLocalNetPriorityNetMask = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwScavengingInterval(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_dwScavengingInterval;
	py_dwScavengingInterval = PyInt_FromLong(object->dwScavengingInterval);
	return py_dwScavengingInterval;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwScavengingInterval(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwScavengingInterval = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwDefaultRefreshInterval(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_dwDefaultRefreshInterval;
	py_dwDefaultRefreshInterval = PyInt_FromLong(object->dwDefaultRefreshInterval);
	return py_dwDefaultRefreshInterval;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwDefaultRefreshInterval(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwDefaultRefreshInterval = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwDefaultNoRefreshInterval(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_dwDefaultNoRefreshInterval;
	py_dwDefaultNoRefreshInterval = PyInt_FromLong(object->dwDefaultNoRefreshInterval);
	return py_dwDefaultNoRefreshInterval;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwDefaultNoRefreshInterval(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwDefaultNoRefreshInterval = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwLastScavengeTime(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_dwLastScavengeTime;
	py_dwLastScavengeTime = PyInt_FromLong(object->dwLastScavengeTime);
	return py_dwLastScavengeTime;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwLastScavengeTime(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwLastScavengeTime = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwEventLogLevel(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_dwEventLogLevel;
	py_dwEventLogLevel = PyInt_FromLong(object->dwEventLogLevel);
	return py_dwEventLogLevel;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwEventLogLevel(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwEventLogLevel = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwLogFileMaxSize(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_dwLogFileMaxSize;
	py_dwLogFileMaxSize = PyInt_FromLong(object->dwLogFileMaxSize);
	return py_dwLogFileMaxSize;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwLogFileMaxSize(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwLogFileMaxSize = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwDsForestVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_dwDsForestVersion;
	py_dwDsForestVersion = PyInt_FromLong(object->dwDsForestVersion);
	return py_dwDsForestVersion;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwDsForestVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwDsForestVersion = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwDsDomainVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_dwDsDomainVersion;
	py_dwDsDomainVersion = PyInt_FromLong(object->dwDsDomainVersion);
	return py_dwDsDomainVersion;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwDsDomainVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwDsDomainVersion = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwDsDsaVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_dwDsDsaVersion;
	py_dwDsDsaVersion = PyInt_FromLong(object->dwDsDsaVersion);
	return py_dwDsDsaVersion;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwDsDsaVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwDsDsaVersion = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_fReadOnlyDC(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_fReadOnlyDC;
	py_fReadOnlyDC = PyInt_FromLong(object->fReadOnlyDC);
	return py_fReadOnlyDC;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_fReadOnlyDC(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fReadOnlyDC = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwReserveArray(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_dwReserveArray;
	py_dwReserveArray = PyList_New(3);
	if (py_dwReserveArray == NULL) {
		return NULL;
	}
	{
		int dwReserveArray_cntr_0;
		for (dwReserveArray_cntr_0 = 0; dwReserveArray_cntr_0 < 3; dwReserveArray_cntr_0++) {
			PyObject *py_dwReserveArray_0;
			py_dwReserveArray_0 = PyInt_FromLong(object->dwReserveArray[dwReserveArray_cntr_0]);
			PyList_SetItem(py_dwReserveArray, dwReserveArray_cntr_0, py_dwReserveArray_0);
		}
	}
	return py_dwReserveArray;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwReserveArray(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int dwReserveArray_cntr_0;
		for (dwReserveArray_cntr_0 = 0; dwReserveArray_cntr_0 < PyList_GET_SIZE(value); dwReserveArray_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, dwReserveArray_cntr_0), return -1;);
			object->dwReserveArray[dwReserveArray_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, dwReserveArray_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_fAutoReverseZones(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_fAutoReverseZones;
	py_fAutoReverseZones = PyInt_FromLong(object->fAutoReverseZones);
	return py_fAutoReverseZones;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_fAutoReverseZones(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fAutoReverseZones = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_fAutoCacheUpdate(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_fAutoCacheUpdate;
	py_fAutoCacheUpdate = PyInt_FromLong(object->fAutoCacheUpdate);
	return py_fAutoCacheUpdate;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_fAutoCacheUpdate(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fAutoCacheUpdate = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_fRecurseAfterForwarding(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_fRecurseAfterForwarding;
	py_fRecurseAfterForwarding = PyInt_FromLong(object->fRecurseAfterForwarding);
	return py_fRecurseAfterForwarding;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_fRecurseAfterForwarding(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fRecurseAfterForwarding = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_fForwardDelegations(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_fForwardDelegations;
	py_fForwardDelegations = PyInt_FromLong(object->fForwardDelegations);
	return py_fForwardDelegations;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_fForwardDelegations(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fForwardDelegations = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_fNoRecursion(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_fNoRecursion;
	py_fNoRecursion = PyInt_FromLong(object->fNoRecursion);
	return py_fNoRecursion;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_fNoRecursion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fNoRecursion = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_fSecureResponses(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_fSecureResponses;
	py_fSecureResponses = PyInt_FromLong(object->fSecureResponses);
	return py_fSecureResponses;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_fSecureResponses(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fSecureResponses = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_fRoundRobin(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_fRoundRobin;
	py_fRoundRobin = PyInt_FromLong(object->fRoundRobin);
	return py_fRoundRobin;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_fRoundRobin(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fRoundRobin = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_fLocalNetPriority(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_fLocalNetPriority;
	py_fLocalNetPriority = PyInt_FromLong(object->fLocalNetPriority);
	return py_fLocalNetPriority;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_fLocalNetPriority(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fLocalNetPriority = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_fBindSecondaries(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_fBindSecondaries;
	py_fBindSecondaries = PyInt_FromLong(object->fBindSecondaries);
	return py_fBindSecondaries;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_fBindSecondaries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fBindSecondaries = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_fWriteAuthorityNs(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_fWriteAuthorityNs;
	py_fWriteAuthorityNs = PyInt_FromLong(object->fWriteAuthorityNs);
	return py_fWriteAuthorityNs;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_fWriteAuthorityNs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fWriteAuthorityNs = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_fStrictFileParsing(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_fStrictFileParsing;
	py_fStrictFileParsing = PyInt_FromLong(object->fStrictFileParsing);
	return py_fStrictFileParsing;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_fStrictFileParsing(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fStrictFileParsing = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_fLooseWildcarding(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_fLooseWildcarding;
	py_fLooseWildcarding = PyInt_FromLong(object->fLooseWildcarding);
	return py_fLooseWildcarding;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_fLooseWildcarding(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fLooseWildcarding = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_fDefaultAgingState(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_fDefaultAgingState;
	py_fDefaultAgingState = PyInt_FromLong(object->fDefaultAgingState);
	return py_fDefaultAgingState;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_fDefaultAgingState(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fDefaultAgingState = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_get_fReserveArray(PyObject *obj, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_fReserveArray;
	py_fReserveArray = PyList_New(15);
	if (py_fReserveArray == NULL) {
		return NULL;
	}
	{
		int fReserveArray_cntr_0;
		for (fReserveArray_cntr_0 = 0; fReserveArray_cntr_0 < 15; fReserveArray_cntr_0++) {
			PyObject *py_fReserveArray_0;
			py_fReserveArray_0 = PyInt_FromLong(object->fReserveArray[fReserveArray_cntr_0]);
			PyList_SetItem(py_fReserveArray, fReserveArray_cntr_0, py_fReserveArray_0);
		}
	}
	return py_fReserveArray;
}

static int py_DNS_RPC_SERVER_INFO_LONGHORN_set_fReserveArray(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int fReserveArray_cntr_0;
		for (fReserveArray_cntr_0 = 0; fReserveArray_cntr_0 < PyList_GET_SIZE(value); fReserveArray_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, fReserveArray_cntr_0), return -1;);
			object->fReserveArray[fReserveArray_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, fReserveArray_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_SERVER_INFO_LONGHORN_getsetters[] = {
	{ discard_const_p(char, "dwRpcStructureVersion"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwRpcStructureVersion, py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwRpcStructureVersion },
	{ discard_const_p(char, "dwReserved0"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwReserved0, py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwReserved0 },
	{ discard_const_p(char, "dwVersion"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwVersion, py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwVersion },
	{ discard_const_p(char, "fBootMethod"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_fBootMethod, py_DNS_RPC_SERVER_INFO_LONGHORN_set_fBootMethod },
	{ discard_const_p(char, "fAdminConfigured"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_fAdminConfigured, py_DNS_RPC_SERVER_INFO_LONGHORN_set_fAdminConfigured },
	{ discard_const_p(char, "fAllowUpdate"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_fAllowUpdate, py_DNS_RPC_SERVER_INFO_LONGHORN_set_fAllowUpdate },
	{ discard_const_p(char, "fDsAvailable"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_fDsAvailable, py_DNS_RPC_SERVER_INFO_LONGHORN_set_fDsAvailable },
	{ discard_const_p(char, "pszServerName"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_pszServerName, py_DNS_RPC_SERVER_INFO_LONGHORN_set_pszServerName },
	{ discard_const_p(char, "pszDsContainer"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_pszDsContainer, py_DNS_RPC_SERVER_INFO_LONGHORN_set_pszDsContainer },
	{ discard_const_p(char, "aipServerAddrs"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_aipServerAddrs, py_DNS_RPC_SERVER_INFO_LONGHORN_set_aipServerAddrs },
	{ discard_const_p(char, "aipListenAddrs"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_aipListenAddrs, py_DNS_RPC_SERVER_INFO_LONGHORN_set_aipListenAddrs },
	{ discard_const_p(char, "aipForwarders"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_aipForwarders, py_DNS_RPC_SERVER_INFO_LONGHORN_set_aipForwarders },
	{ discard_const_p(char, "aipLogFilter"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_aipLogFilter, py_DNS_RPC_SERVER_INFO_LONGHORN_set_aipLogFilter },
	{ discard_const_p(char, "pwszLogFilePath"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_pwszLogFilePath, py_DNS_RPC_SERVER_INFO_LONGHORN_set_pwszLogFilePath },
	{ discard_const_p(char, "pszDomainName"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_pszDomainName, py_DNS_RPC_SERVER_INFO_LONGHORN_set_pszDomainName },
	{ discard_const_p(char, "pszForestName"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_pszForestName, py_DNS_RPC_SERVER_INFO_LONGHORN_set_pszForestName },
	{ discard_const_p(char, "pszDomainDirectoryPartition"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_pszDomainDirectoryPartition, py_DNS_RPC_SERVER_INFO_LONGHORN_set_pszDomainDirectoryPartition },
	{ discard_const_p(char, "pszForestDirectoryPartition"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_pszForestDirectoryPartition, py_DNS_RPC_SERVER_INFO_LONGHORN_set_pszForestDirectoryPartition },
	{ discard_const_p(char, "pExtensions"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_pExtensions, py_DNS_RPC_SERVER_INFO_LONGHORN_set_pExtensions },
	{ discard_const_p(char, "dwLogLevel"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwLogLevel, py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwLogLevel },
	{ discard_const_p(char, "dwDebugLevel"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwDebugLevel, py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwDebugLevel },
	{ discard_const_p(char, "dwForwardTimeout"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwForwardTimeout, py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwForwardTimeout },
	{ discard_const_p(char, "dwRpcProtocol"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwRpcProtocol, py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwRpcProtocol },
	{ discard_const_p(char, "dwNameCheckFlag"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwNameCheckFlag, py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwNameCheckFlag },
	{ discard_const_p(char, "cAddressAnswerLimit"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_cAddressAnswerLimit, py_DNS_RPC_SERVER_INFO_LONGHORN_set_cAddressAnswerLimit },
	{ discard_const_p(char, "dwRecursionRetry"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwRecursionRetry, py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwRecursionRetry },
	{ discard_const_p(char, "dwRecursionTimeout"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwRecursionTimeout, py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwRecursionTimeout },
	{ discard_const_p(char, "dwMaxCacheTtl"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwMaxCacheTtl, py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwMaxCacheTtl },
	{ discard_const_p(char, "dwDsPollingInterval"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwDsPollingInterval, py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwDsPollingInterval },
	{ discard_const_p(char, "dwLocalNetPriorityNetMask"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwLocalNetPriorityNetMask, py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwLocalNetPriorityNetMask },
	{ discard_const_p(char, "dwScavengingInterval"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwScavengingInterval, py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwScavengingInterval },
	{ discard_const_p(char, "dwDefaultRefreshInterval"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwDefaultRefreshInterval, py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwDefaultRefreshInterval },
	{ discard_const_p(char, "dwDefaultNoRefreshInterval"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwDefaultNoRefreshInterval, py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwDefaultNoRefreshInterval },
	{ discard_const_p(char, "dwLastScavengeTime"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwLastScavengeTime, py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwLastScavengeTime },
	{ discard_const_p(char, "dwEventLogLevel"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwEventLogLevel, py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwEventLogLevel },
	{ discard_const_p(char, "dwLogFileMaxSize"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwLogFileMaxSize, py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwLogFileMaxSize },
	{ discard_const_p(char, "dwDsForestVersion"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwDsForestVersion, py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwDsForestVersion },
	{ discard_const_p(char, "dwDsDomainVersion"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwDsDomainVersion, py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwDsDomainVersion },
	{ discard_const_p(char, "dwDsDsaVersion"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwDsDsaVersion, py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwDsDsaVersion },
	{ discard_const_p(char, "fReadOnlyDC"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_fReadOnlyDC, py_DNS_RPC_SERVER_INFO_LONGHORN_set_fReadOnlyDC },
	{ discard_const_p(char, "dwReserveArray"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_dwReserveArray, py_DNS_RPC_SERVER_INFO_LONGHORN_set_dwReserveArray },
	{ discard_const_p(char, "fAutoReverseZones"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_fAutoReverseZones, py_DNS_RPC_SERVER_INFO_LONGHORN_set_fAutoReverseZones },
	{ discard_const_p(char, "fAutoCacheUpdate"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_fAutoCacheUpdate, py_DNS_RPC_SERVER_INFO_LONGHORN_set_fAutoCacheUpdate },
	{ discard_const_p(char, "fRecurseAfterForwarding"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_fRecurseAfterForwarding, py_DNS_RPC_SERVER_INFO_LONGHORN_set_fRecurseAfterForwarding },
	{ discard_const_p(char, "fForwardDelegations"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_fForwardDelegations, py_DNS_RPC_SERVER_INFO_LONGHORN_set_fForwardDelegations },
	{ discard_const_p(char, "fNoRecursion"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_fNoRecursion, py_DNS_RPC_SERVER_INFO_LONGHORN_set_fNoRecursion },
	{ discard_const_p(char, "fSecureResponses"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_fSecureResponses, py_DNS_RPC_SERVER_INFO_LONGHORN_set_fSecureResponses },
	{ discard_const_p(char, "fRoundRobin"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_fRoundRobin, py_DNS_RPC_SERVER_INFO_LONGHORN_set_fRoundRobin },
	{ discard_const_p(char, "fLocalNetPriority"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_fLocalNetPriority, py_DNS_RPC_SERVER_INFO_LONGHORN_set_fLocalNetPriority },
	{ discard_const_p(char, "fBindSecondaries"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_fBindSecondaries, py_DNS_RPC_SERVER_INFO_LONGHORN_set_fBindSecondaries },
	{ discard_const_p(char, "fWriteAuthorityNs"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_fWriteAuthorityNs, py_DNS_RPC_SERVER_INFO_LONGHORN_set_fWriteAuthorityNs },
	{ discard_const_p(char, "fStrictFileParsing"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_fStrictFileParsing, py_DNS_RPC_SERVER_INFO_LONGHORN_set_fStrictFileParsing },
	{ discard_const_p(char, "fLooseWildcarding"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_fLooseWildcarding, py_DNS_RPC_SERVER_INFO_LONGHORN_set_fLooseWildcarding },
	{ discard_const_p(char, "fDefaultAgingState"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_fDefaultAgingState, py_DNS_RPC_SERVER_INFO_LONGHORN_set_fDefaultAgingState },
	{ discard_const_p(char, "fReserveArray"), py_DNS_RPC_SERVER_INFO_LONGHORN_get_fReserveArray, py_DNS_RPC_SERVER_INFO_LONGHORN_set_fReserveArray },
	{ NULL }
};

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_SERVER_INFO_LONGHORN, type);
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_ndr_pack(PyObject *py_obj)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_DNS_RPC_SERVER_INFO_LONGHORN);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_DNS_RPC_SERVER_INFO_LONGHORN);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_DNS_RPC_SERVER_INFO_LONGHORN);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_DNS_RPC_SERVER_INFO_LONGHORN_ndr_print(PyObject *py_obj)
{
	struct DNS_RPC_SERVER_INFO_LONGHORN *object = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_DNS_RPC_SERVER_INFO_LONGHORN, "DNS_RPC_SERVER_INFO_LONGHORN", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_DNS_RPC_SERVER_INFO_LONGHORN_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_DNS_RPC_SERVER_INFO_LONGHORN_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_DNS_RPC_SERVER_INFO_LONGHORN_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_DNS_RPC_SERVER_INFO_LONGHORN_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject DNS_RPC_SERVER_INFO_LONGHORN_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.DNS_RPC_SERVER_INFO_LONGHORN",
	.tp_getset = py_DNS_RPC_SERVER_INFO_LONGHORN_getsetters,
	.tp_methods = py_DNS_RPC_SERVER_INFO_LONGHORN_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DNS_RPC_SERVER_INFO_LONGHORN_new,
};


static PyObject *py_DNS_RPC_DP_REPLICA_get_pszReplicaDn(PyObject *obj, void *closure)
{
	struct DNS_RPC_DP_REPLICA *object = (struct DNS_RPC_DP_REPLICA *)pytalloc_get_ptr(obj);
	PyObject *py_pszReplicaDn;
	if (object->pszReplicaDn == NULL) {
		py_pszReplicaDn = Py_None;
		Py_INCREF(py_pszReplicaDn);
	} else {
		if (object->pszReplicaDn == NULL) {
			py_pszReplicaDn = Py_None;
			Py_INCREF(py_pszReplicaDn);
		} else {
			py_pszReplicaDn = PyUnicode_Decode(object->pszReplicaDn, strlen(object->pszReplicaDn), "utf-8", "ignore");
		}
	}
	return py_pszReplicaDn;
}

static int py_DNS_RPC_DP_REPLICA_set_pszReplicaDn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_DP_REPLICA *object = (struct DNS_RPC_DP_REPLICA *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszReplicaDn = NULL;
	} else {
		object->pszReplicaDn = NULL;
		if (PyUnicode_Check(value)) {
			object->pszReplicaDn = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszReplicaDn = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_DP_REPLICA_getsetters[] = {
	{ discard_const_p(char, "pszReplicaDn"), py_DNS_RPC_DP_REPLICA_get_pszReplicaDn, py_DNS_RPC_DP_REPLICA_set_pszReplicaDn },
	{ NULL }
};

static PyObject *py_DNS_RPC_DP_REPLICA_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_DP_REPLICA, type);
}


static PyTypeObject DNS_RPC_DP_REPLICA_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.DNS_RPC_DP_REPLICA",
	.tp_getset = py_DNS_RPC_DP_REPLICA_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DNS_RPC_DP_REPLICA_new,
};


static PyObject *py_DNS_RPC_DP_INFO_get_dwRpcStructureVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_DP_INFO *object = (struct DNS_RPC_DP_INFO *)pytalloc_get_ptr(obj);
	PyObject *py_dwRpcStructureVersion;
	py_dwRpcStructureVersion = PyInt_FromLong(object->dwRpcStructureVersion);
	return py_dwRpcStructureVersion;
}

static int py_DNS_RPC_DP_INFO_set_dwRpcStructureVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_DP_INFO *object = (struct DNS_RPC_DP_INFO *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwRpcStructureVersion = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_DP_INFO_get_dwReserved0(PyObject *obj, void *closure)
{
	struct DNS_RPC_DP_INFO *object = (struct DNS_RPC_DP_INFO *)pytalloc_get_ptr(obj);
	PyObject *py_dwReserved0;
	py_dwReserved0 = PyInt_FromLong(object->dwReserved0);
	return py_dwReserved0;
}

static int py_DNS_RPC_DP_INFO_set_dwReserved0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_DP_INFO *object = (struct DNS_RPC_DP_INFO *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwReserved0 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_DP_INFO_get_pszDpFqdn(PyObject *obj, void *closure)
{
	struct DNS_RPC_DP_INFO *object = (struct DNS_RPC_DP_INFO *)pytalloc_get_ptr(obj);
	PyObject *py_pszDpFqdn;
	if (object->pszDpFqdn == NULL) {
		py_pszDpFqdn = Py_None;
		Py_INCREF(py_pszDpFqdn);
	} else {
		if (object->pszDpFqdn == NULL) {
			py_pszDpFqdn = Py_None;
			Py_INCREF(py_pszDpFqdn);
		} else {
			py_pszDpFqdn = PyUnicode_Decode(object->pszDpFqdn, strlen(object->pszDpFqdn), "utf-8", "ignore");
		}
	}
	return py_pszDpFqdn;
}

static int py_DNS_RPC_DP_INFO_set_pszDpFqdn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_DP_INFO *object = (struct DNS_RPC_DP_INFO *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszDpFqdn = NULL;
	} else {
		object->pszDpFqdn = NULL;
		if (PyUnicode_Check(value)) {
			object->pszDpFqdn = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszDpFqdn = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_DP_INFO_get_pszDpDn(PyObject *obj, void *closure)
{
	struct DNS_RPC_DP_INFO *object = (struct DNS_RPC_DP_INFO *)pytalloc_get_ptr(obj);
	PyObject *py_pszDpDn;
	if (object->pszDpDn == NULL) {
		py_pszDpDn = Py_None;
		Py_INCREF(py_pszDpDn);
	} else {
		if (object->pszDpDn == NULL) {
			py_pszDpDn = Py_None;
			Py_INCREF(py_pszDpDn);
		} else {
			py_pszDpDn = PyUnicode_Decode(object->pszDpDn, strlen(object->pszDpDn), "utf-8", "ignore");
		}
	}
	return py_pszDpDn;
}

static int py_DNS_RPC_DP_INFO_set_pszDpDn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_DP_INFO *object = (struct DNS_RPC_DP_INFO *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszDpDn = NULL;
	} else {
		object->pszDpDn = NULL;
		if (PyUnicode_Check(value)) {
			object->pszDpDn = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszDpDn = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_DP_INFO_get_pszCrDn(PyObject *obj, void *closure)
{
	struct DNS_RPC_DP_INFO *object = (struct DNS_RPC_DP_INFO *)pytalloc_get_ptr(obj);
	PyObject *py_pszCrDn;
	if (object->pszCrDn == NULL) {
		py_pszCrDn = Py_None;
		Py_INCREF(py_pszCrDn);
	} else {
		if (object->pszCrDn == NULL) {
			py_pszCrDn = Py_None;
			Py_INCREF(py_pszCrDn);
		} else {
			py_pszCrDn = PyUnicode_Decode(object->pszCrDn, strlen(object->pszCrDn), "utf-8", "ignore");
		}
	}
	return py_pszCrDn;
}

static int py_DNS_RPC_DP_INFO_set_pszCrDn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_DP_INFO *object = (struct DNS_RPC_DP_INFO *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszCrDn = NULL;
	} else {
		object->pszCrDn = NULL;
		if (PyUnicode_Check(value)) {
			object->pszCrDn = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszCrDn = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_DP_INFO_get_dwFlags(PyObject *obj, void *closure)
{
	struct DNS_RPC_DP_INFO *object = (struct DNS_RPC_DP_INFO *)pytalloc_get_ptr(obj);
	PyObject *py_dwFlags;
	py_dwFlags = PyInt_FromLong(object->dwFlags);
	return py_dwFlags;
}

static int py_DNS_RPC_DP_INFO_set_dwFlags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_DP_INFO *object = (struct DNS_RPC_DP_INFO *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwFlags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_DP_INFO_get_dwZoneCount(PyObject *obj, void *closure)
{
	struct DNS_RPC_DP_INFO *object = (struct DNS_RPC_DP_INFO *)pytalloc_get_ptr(obj);
	PyObject *py_dwZoneCount;
	py_dwZoneCount = PyInt_FromLong(object->dwZoneCount);
	return py_dwZoneCount;
}

static int py_DNS_RPC_DP_INFO_set_dwZoneCount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_DP_INFO *object = (struct DNS_RPC_DP_INFO *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwZoneCount = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_DP_INFO_get_dwState(PyObject *obj, void *closure)
{
	struct DNS_RPC_DP_INFO *object = (struct DNS_RPC_DP_INFO *)pytalloc_get_ptr(obj);
	PyObject *py_dwState;
	py_dwState = PyInt_FromLong(object->dwState);
	return py_dwState;
}

static int py_DNS_RPC_DP_INFO_set_dwState(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_DP_INFO *object = (struct DNS_RPC_DP_INFO *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->dwState = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->dwState = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_DNS_RPC_DP_INFO_get_dwReserved(PyObject *obj, void *closure)
{
	struct DNS_RPC_DP_INFO *object = (struct DNS_RPC_DP_INFO *)pytalloc_get_ptr(obj);
	PyObject *py_dwReserved;
	py_dwReserved = PyList_New(3);
	if (py_dwReserved == NULL) {
		return NULL;
	}
	{
		int dwReserved_cntr_0;
		for (dwReserved_cntr_0 = 0; dwReserved_cntr_0 < 3; dwReserved_cntr_0++) {
			PyObject *py_dwReserved_0;
			py_dwReserved_0 = PyInt_FromLong(object->dwReserved[dwReserved_cntr_0]);
			PyList_SetItem(py_dwReserved, dwReserved_cntr_0, py_dwReserved_0);
		}
	}
	return py_dwReserved;
}

static int py_DNS_RPC_DP_INFO_set_dwReserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_DP_INFO *object = (struct DNS_RPC_DP_INFO *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int dwReserved_cntr_0;
		for (dwReserved_cntr_0 = 0; dwReserved_cntr_0 < PyList_GET_SIZE(value); dwReserved_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, dwReserved_cntr_0), return -1;);
			object->dwReserved[dwReserved_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, dwReserved_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_DP_INFO_get_pwszReserved(PyObject *obj, void *closure)
{
	struct DNS_RPC_DP_INFO *object = (struct DNS_RPC_DP_INFO *)pytalloc_get_ptr(obj);
	PyObject *py_pwszReserved;
	py_pwszReserved = PyList_New(3);
	if (py_pwszReserved == NULL) {
		return NULL;
	}
	{
		int pwszReserved_cntr_0;
		for (pwszReserved_cntr_0 = 0; pwszReserved_cntr_0 < 3; pwszReserved_cntr_0++) {
			PyObject *py_pwszReserved_0;
			py_pwszReserved_0 = pytalloc_reference_ex(&DNS_EXTENSION_Type, object->pwszReserved, &object->pwszReserved[pwszReserved_cntr_0]);
			PyList_SetItem(py_pwszReserved, pwszReserved_cntr_0, py_pwszReserved_0);
		}
	}
	return py_pwszReserved;
}

static int py_DNS_RPC_DP_INFO_set_pwszReserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_DP_INFO *object = (struct DNS_RPC_DP_INFO *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int pwszReserved_cntr_0;
		for (pwszReserved_cntr_0 = 0; pwszReserved_cntr_0 < PyList_GET_SIZE(value); pwszReserved_cntr_0++) {
			PY_CHECK_TYPE(&DNS_EXTENSION_Type, PyList_GET_ITEM(value, pwszReserved_cntr_0), return -1;);
			if (talloc_reference(object->pwszReserved, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, pwszReserved_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pwszReserved[pwszReserved_cntr_0] = *(struct DNS_EXTENSION *)pytalloc_get_ptr(PyList_GET_ITEM(value, pwszReserved_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_DP_INFO_get_dwReplicaCount(PyObject *obj, void *closure)
{
	struct DNS_RPC_DP_INFO *object = (struct DNS_RPC_DP_INFO *)pytalloc_get_ptr(obj);
	PyObject *py_dwReplicaCount;
	py_dwReplicaCount = PyInt_FromLong(object->dwReplicaCount);
	return py_dwReplicaCount;
}

static int py_DNS_RPC_DP_INFO_set_dwReplicaCount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_DP_INFO *object = (struct DNS_RPC_DP_INFO *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwReplicaCount = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_DP_INFO_get_ReplicaArray(PyObject *obj, void *closure)
{
	struct DNS_RPC_DP_INFO *object = (struct DNS_RPC_DP_INFO *)pytalloc_get_ptr(obj);
	PyObject *py_ReplicaArray;
	py_ReplicaArray = PyList_New(object->dwReplicaCount);
	if (py_ReplicaArray == NULL) {
		return NULL;
	}
	{
		int ReplicaArray_cntr_0;
		for (ReplicaArray_cntr_0 = 0; ReplicaArray_cntr_0 < object->dwReplicaCount; ReplicaArray_cntr_0++) {
			PyObject *py_ReplicaArray_0;
			if (object->ReplicaArray[ReplicaArray_cntr_0] == NULL) {
				py_ReplicaArray_0 = Py_None;
				Py_INCREF(py_ReplicaArray_0);
			} else {
				py_ReplicaArray_0 = pytalloc_reference_ex(&DNS_RPC_DP_REPLICA_Type, object->ReplicaArray[ReplicaArray_cntr_0], object->ReplicaArray[ReplicaArray_cntr_0]);
			}
			PyList_SetItem(py_ReplicaArray, ReplicaArray_cntr_0, py_ReplicaArray_0);
		}
	}
	return py_ReplicaArray;
}

static int py_DNS_RPC_DP_INFO_set_ReplicaArray(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_DP_INFO *object = (struct DNS_RPC_DP_INFO *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int ReplicaArray_cntr_0;
		object->ReplicaArray = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->ReplicaArray, PyList_GET_SIZE(value));
		if (!object->ReplicaArray) { return -1;; }
		talloc_set_name_const(object->ReplicaArray, "ARRAY: object->ReplicaArray");
		for (ReplicaArray_cntr_0 = 0; ReplicaArray_cntr_0 < PyList_GET_SIZE(value); ReplicaArray_cntr_0++) {
			if (PyList_GET_ITEM(value, ReplicaArray_cntr_0) == Py_None) {
				object->ReplicaArray[ReplicaArray_cntr_0] = NULL;
			} else {
				object->ReplicaArray[ReplicaArray_cntr_0] = NULL;
				PY_CHECK_TYPE(&DNS_RPC_DP_REPLICA_Type, PyList_GET_ITEM(value, ReplicaArray_cntr_0), return -1;);
				if (talloc_reference(object->ReplicaArray, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, ReplicaArray_cntr_0))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				object->ReplicaArray[ReplicaArray_cntr_0] = (struct DNS_RPC_DP_REPLICA *)pytalloc_get_ptr(PyList_GET_ITEM(value, ReplicaArray_cntr_0));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_DP_INFO_getsetters[] = {
	{ discard_const_p(char, "dwRpcStructureVersion"), py_DNS_RPC_DP_INFO_get_dwRpcStructureVersion, py_DNS_RPC_DP_INFO_set_dwRpcStructureVersion },
	{ discard_const_p(char, "dwReserved0"), py_DNS_RPC_DP_INFO_get_dwReserved0, py_DNS_RPC_DP_INFO_set_dwReserved0 },
	{ discard_const_p(char, "pszDpFqdn"), py_DNS_RPC_DP_INFO_get_pszDpFqdn, py_DNS_RPC_DP_INFO_set_pszDpFqdn },
	{ discard_const_p(char, "pszDpDn"), py_DNS_RPC_DP_INFO_get_pszDpDn, py_DNS_RPC_DP_INFO_set_pszDpDn },
	{ discard_const_p(char, "pszCrDn"), py_DNS_RPC_DP_INFO_get_pszCrDn, py_DNS_RPC_DP_INFO_set_pszCrDn },
	{ discard_const_p(char, "dwFlags"), py_DNS_RPC_DP_INFO_get_dwFlags, py_DNS_RPC_DP_INFO_set_dwFlags },
	{ discard_const_p(char, "dwZoneCount"), py_DNS_RPC_DP_INFO_get_dwZoneCount, py_DNS_RPC_DP_INFO_set_dwZoneCount },
	{ discard_const_p(char, "dwState"), py_DNS_RPC_DP_INFO_get_dwState, py_DNS_RPC_DP_INFO_set_dwState },
	{ discard_const_p(char, "dwReserved"), py_DNS_RPC_DP_INFO_get_dwReserved, py_DNS_RPC_DP_INFO_set_dwReserved },
	{ discard_const_p(char, "pwszReserved"), py_DNS_RPC_DP_INFO_get_pwszReserved, py_DNS_RPC_DP_INFO_set_pwszReserved },
	{ discard_const_p(char, "dwReplicaCount"), py_DNS_RPC_DP_INFO_get_dwReplicaCount, py_DNS_RPC_DP_INFO_set_dwReplicaCount },
	{ discard_const_p(char, "ReplicaArray"), py_DNS_RPC_DP_INFO_get_ReplicaArray, py_DNS_RPC_DP_INFO_set_ReplicaArray },
	{ NULL }
};

static PyObject *py_DNS_RPC_DP_INFO_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_DP_INFO, type);
}


static PyTypeObject DNS_RPC_DP_INFO_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.DNS_RPC_DP_INFO",
	.tp_getset = py_DNS_RPC_DP_INFO_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DNS_RPC_DP_INFO_new,
};


static PyObject *py_DNS_RPC_DP_ENUM_get_dwRpcStructureVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_DP_ENUM *object = (struct DNS_RPC_DP_ENUM *)pytalloc_get_ptr(obj);
	PyObject *py_dwRpcStructureVersion;
	py_dwRpcStructureVersion = PyInt_FromLong(object->dwRpcStructureVersion);
	return py_dwRpcStructureVersion;
}

static int py_DNS_RPC_DP_ENUM_set_dwRpcStructureVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_DP_ENUM *object = (struct DNS_RPC_DP_ENUM *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwRpcStructureVersion = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_DP_ENUM_get_dwReserved0(PyObject *obj, void *closure)
{
	struct DNS_RPC_DP_ENUM *object = (struct DNS_RPC_DP_ENUM *)pytalloc_get_ptr(obj);
	PyObject *py_dwReserved0;
	py_dwReserved0 = PyInt_FromLong(object->dwReserved0);
	return py_dwReserved0;
}

static int py_DNS_RPC_DP_ENUM_set_dwReserved0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_DP_ENUM *object = (struct DNS_RPC_DP_ENUM *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwReserved0 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_DP_ENUM_get_pszDpFqdn(PyObject *obj, void *closure)
{
	struct DNS_RPC_DP_ENUM *object = (struct DNS_RPC_DP_ENUM *)pytalloc_get_ptr(obj);
	PyObject *py_pszDpFqdn;
	if (object->pszDpFqdn == NULL) {
		py_pszDpFqdn = Py_None;
		Py_INCREF(py_pszDpFqdn);
	} else {
		if (object->pszDpFqdn == NULL) {
			py_pszDpFqdn = Py_None;
			Py_INCREF(py_pszDpFqdn);
		} else {
			py_pszDpFqdn = PyUnicode_Decode(object->pszDpFqdn, strlen(object->pszDpFqdn), "utf-8", "ignore");
		}
	}
	return py_pszDpFqdn;
}

static int py_DNS_RPC_DP_ENUM_set_pszDpFqdn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_DP_ENUM *object = (struct DNS_RPC_DP_ENUM *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszDpFqdn = NULL;
	} else {
		object->pszDpFqdn = NULL;
		if (PyUnicode_Check(value)) {
			object->pszDpFqdn = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszDpFqdn = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_DP_ENUM_get_dwFlags(PyObject *obj, void *closure)
{
	struct DNS_RPC_DP_ENUM *object = (struct DNS_RPC_DP_ENUM *)pytalloc_get_ptr(obj);
	PyObject *py_dwFlags;
	py_dwFlags = PyInt_FromLong(object->dwFlags);
	return py_dwFlags;
}

static int py_DNS_RPC_DP_ENUM_set_dwFlags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_DP_ENUM *object = (struct DNS_RPC_DP_ENUM *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwFlags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_DP_ENUM_get_dwZoneCount(PyObject *obj, void *closure)
{
	struct DNS_RPC_DP_ENUM *object = (struct DNS_RPC_DP_ENUM *)pytalloc_get_ptr(obj);
	PyObject *py_dwZoneCount;
	py_dwZoneCount = PyInt_FromLong(object->dwZoneCount);
	return py_dwZoneCount;
}

static int py_DNS_RPC_DP_ENUM_set_dwZoneCount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_DP_ENUM *object = (struct DNS_RPC_DP_ENUM *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwZoneCount = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_DNS_RPC_DP_ENUM_getsetters[] = {
	{ discard_const_p(char, "dwRpcStructureVersion"), py_DNS_RPC_DP_ENUM_get_dwRpcStructureVersion, py_DNS_RPC_DP_ENUM_set_dwRpcStructureVersion },
	{ discard_const_p(char, "dwReserved0"), py_DNS_RPC_DP_ENUM_get_dwReserved0, py_DNS_RPC_DP_ENUM_set_dwReserved0 },
	{ discard_const_p(char, "pszDpFqdn"), py_DNS_RPC_DP_ENUM_get_pszDpFqdn, py_DNS_RPC_DP_ENUM_set_pszDpFqdn },
	{ discard_const_p(char, "dwFlags"), py_DNS_RPC_DP_ENUM_get_dwFlags, py_DNS_RPC_DP_ENUM_set_dwFlags },
	{ discard_const_p(char, "dwZoneCount"), py_DNS_RPC_DP_ENUM_get_dwZoneCount, py_DNS_RPC_DP_ENUM_set_dwZoneCount },
	{ NULL }
};

static PyObject *py_DNS_RPC_DP_ENUM_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_DP_ENUM, type);
}


static PyTypeObject DNS_RPC_DP_ENUM_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.DNS_RPC_DP_ENUM",
	.tp_getset = py_DNS_RPC_DP_ENUM_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DNS_RPC_DP_ENUM_new,
};


static PyObject *py_DNS_RPC_DP_LIST_get_dwRpcStructureVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_DP_LIST *object = (struct DNS_RPC_DP_LIST *)pytalloc_get_ptr(obj);
	PyObject *py_dwRpcStructureVersion;
	py_dwRpcStructureVersion = PyInt_FromLong(object->dwRpcStructureVersion);
	return py_dwRpcStructureVersion;
}

static int py_DNS_RPC_DP_LIST_set_dwRpcStructureVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_DP_LIST *object = (struct DNS_RPC_DP_LIST *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwRpcStructureVersion = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_DP_LIST_get_dwReserved0(PyObject *obj, void *closure)
{
	struct DNS_RPC_DP_LIST *object = (struct DNS_RPC_DP_LIST *)pytalloc_get_ptr(obj);
	PyObject *py_dwReserved0;
	py_dwReserved0 = PyInt_FromLong(object->dwReserved0);
	return py_dwReserved0;
}

static int py_DNS_RPC_DP_LIST_set_dwReserved0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_DP_LIST *object = (struct DNS_RPC_DP_LIST *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwReserved0 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_DP_LIST_get_dwDpCount(PyObject *obj, void *closure)
{
	struct DNS_RPC_DP_LIST *object = (struct DNS_RPC_DP_LIST *)pytalloc_get_ptr(obj);
	PyObject *py_dwDpCount;
	py_dwDpCount = PyInt_FromLong(object->dwDpCount);
	return py_dwDpCount;
}

static int py_DNS_RPC_DP_LIST_set_dwDpCount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_DP_LIST *object = (struct DNS_RPC_DP_LIST *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwDpCount = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_DP_LIST_get_DpArray(PyObject *obj, void *closure)
{
	struct DNS_RPC_DP_LIST *object = (struct DNS_RPC_DP_LIST *)pytalloc_get_ptr(obj);
	PyObject *py_DpArray;
	py_DpArray = PyList_New(object->dwDpCount);
	if (py_DpArray == NULL) {
		return NULL;
	}
	{
		int DpArray_cntr_0;
		for (DpArray_cntr_0 = 0; DpArray_cntr_0 < object->dwDpCount; DpArray_cntr_0++) {
			PyObject *py_DpArray_0;
			if (object->DpArray[DpArray_cntr_0] == NULL) {
				py_DpArray_0 = Py_None;
				Py_INCREF(py_DpArray_0);
			} else {
				py_DpArray_0 = pytalloc_reference_ex(&DNS_RPC_DP_ENUM_Type, object->DpArray[DpArray_cntr_0], object->DpArray[DpArray_cntr_0]);
			}
			PyList_SetItem(py_DpArray, DpArray_cntr_0, py_DpArray_0);
		}
	}
	return py_DpArray;
}

static int py_DNS_RPC_DP_LIST_set_DpArray(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_DP_LIST *object = (struct DNS_RPC_DP_LIST *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int DpArray_cntr_0;
		object->DpArray = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->DpArray, PyList_GET_SIZE(value));
		if (!object->DpArray) { return -1;; }
		talloc_set_name_const(object->DpArray, "ARRAY: object->DpArray");
		for (DpArray_cntr_0 = 0; DpArray_cntr_0 < PyList_GET_SIZE(value); DpArray_cntr_0++) {
			if (PyList_GET_ITEM(value, DpArray_cntr_0) == Py_None) {
				object->DpArray[DpArray_cntr_0] = NULL;
			} else {
				object->DpArray[DpArray_cntr_0] = NULL;
				PY_CHECK_TYPE(&DNS_RPC_DP_ENUM_Type, PyList_GET_ITEM(value, DpArray_cntr_0), return -1;);
				if (talloc_reference(object->DpArray, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, DpArray_cntr_0))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				object->DpArray[DpArray_cntr_0] = (struct DNS_RPC_DP_ENUM *)pytalloc_get_ptr(PyList_GET_ITEM(value, DpArray_cntr_0));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_DP_LIST_getsetters[] = {
	{ discard_const_p(char, "dwRpcStructureVersion"), py_DNS_RPC_DP_LIST_get_dwRpcStructureVersion, py_DNS_RPC_DP_LIST_set_dwRpcStructureVersion },
	{ discard_const_p(char, "dwReserved0"), py_DNS_RPC_DP_LIST_get_dwReserved0, py_DNS_RPC_DP_LIST_set_dwReserved0 },
	{ discard_const_p(char, "dwDpCount"), py_DNS_RPC_DP_LIST_get_dwDpCount, py_DNS_RPC_DP_LIST_set_dwDpCount },
	{ discard_const_p(char, "DpArray"), py_DNS_RPC_DP_LIST_get_DpArray, py_DNS_RPC_DP_LIST_set_DpArray },
	{ NULL }
};

static PyObject *py_DNS_RPC_DP_LIST_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_DP_LIST, type);
}


static PyTypeObject DNS_RPC_DP_LIST_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.DNS_RPC_DP_LIST",
	.tp_getset = py_DNS_RPC_DP_LIST_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DNS_RPC_DP_LIST_new,
};


static PyObject *py_DNS_RPC_ENLIST_DP_get_dwRpcStructureVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_ENLIST_DP *object = (struct DNS_RPC_ENLIST_DP *)pytalloc_get_ptr(obj);
	PyObject *py_dwRpcStructureVersion;
	py_dwRpcStructureVersion = PyInt_FromLong(object->dwRpcStructureVersion);
	return py_dwRpcStructureVersion;
}

static int py_DNS_RPC_ENLIST_DP_set_dwRpcStructureVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ENLIST_DP *object = (struct DNS_RPC_ENLIST_DP *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwRpcStructureVersion = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ENLIST_DP_get_dwReserved0(PyObject *obj, void *closure)
{
	struct DNS_RPC_ENLIST_DP *object = (struct DNS_RPC_ENLIST_DP *)pytalloc_get_ptr(obj);
	PyObject *py_dwReserved0;
	py_dwReserved0 = PyInt_FromLong(object->dwReserved0);
	return py_dwReserved0;
}

static int py_DNS_RPC_ENLIST_DP_set_dwReserved0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ENLIST_DP *object = (struct DNS_RPC_ENLIST_DP *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwReserved0 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ENLIST_DP_get_pszDpFqdn(PyObject *obj, void *closure)
{
	struct DNS_RPC_ENLIST_DP *object = (struct DNS_RPC_ENLIST_DP *)pytalloc_get_ptr(obj);
	PyObject *py_pszDpFqdn;
	if (object->pszDpFqdn == NULL) {
		py_pszDpFqdn = Py_None;
		Py_INCREF(py_pszDpFqdn);
	} else {
		if (object->pszDpFqdn == NULL) {
			py_pszDpFqdn = Py_None;
			Py_INCREF(py_pszDpFqdn);
		} else {
			py_pszDpFqdn = PyUnicode_Decode(object->pszDpFqdn, strlen(object->pszDpFqdn), "utf-8", "ignore");
		}
	}
	return py_pszDpFqdn;
}

static int py_DNS_RPC_ENLIST_DP_set_pszDpFqdn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ENLIST_DP *object = (struct DNS_RPC_ENLIST_DP *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszDpFqdn = NULL;
	} else {
		object->pszDpFqdn = NULL;
		if (PyUnicode_Check(value)) {
			object->pszDpFqdn = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszDpFqdn = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ENLIST_DP_get_dwOperation(PyObject *obj, void *closure)
{
	struct DNS_RPC_ENLIST_DP *object = (struct DNS_RPC_ENLIST_DP *)pytalloc_get_ptr(obj);
	PyObject *py_dwOperation;
	py_dwOperation = PyInt_FromLong(object->dwOperation);
	return py_dwOperation;
}

static int py_DNS_RPC_ENLIST_DP_set_dwOperation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ENLIST_DP *object = (struct DNS_RPC_ENLIST_DP *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwOperation = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_DNS_RPC_ENLIST_DP_getsetters[] = {
	{ discard_const_p(char, "dwRpcStructureVersion"), py_DNS_RPC_ENLIST_DP_get_dwRpcStructureVersion, py_DNS_RPC_ENLIST_DP_set_dwRpcStructureVersion },
	{ discard_const_p(char, "dwReserved0"), py_DNS_RPC_ENLIST_DP_get_dwReserved0, py_DNS_RPC_ENLIST_DP_set_dwReserved0 },
	{ discard_const_p(char, "pszDpFqdn"), py_DNS_RPC_ENLIST_DP_get_pszDpFqdn, py_DNS_RPC_ENLIST_DP_set_pszDpFqdn },
	{ discard_const_p(char, "dwOperation"), py_DNS_RPC_ENLIST_DP_get_dwOperation, py_DNS_RPC_ENLIST_DP_set_dwOperation },
	{ NULL }
};

static PyObject *py_DNS_RPC_ENLIST_DP_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_ENLIST_DP, type);
}


static PyTypeObject DNS_RPC_ENLIST_DP_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.DNS_RPC_ENLIST_DP",
	.tp_getset = py_DNS_RPC_ENLIST_DP_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DNS_RPC_ENLIST_DP_new,
};


static PyObject *py_DNS_RPC_ZONE_CHANGE_DP_get_dwRpcStructureVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CHANGE_DP *object = (struct DNS_RPC_ZONE_CHANGE_DP *)pytalloc_get_ptr(obj);
	PyObject *py_dwRpcStructureVersion;
	py_dwRpcStructureVersion = PyInt_FromLong(object->dwRpcStructureVersion);
	return py_dwRpcStructureVersion;
}

static int py_DNS_RPC_ZONE_CHANGE_DP_set_dwRpcStructureVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CHANGE_DP *object = (struct DNS_RPC_ZONE_CHANGE_DP *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwRpcStructureVersion = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CHANGE_DP_get_dwReserved0(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CHANGE_DP *object = (struct DNS_RPC_ZONE_CHANGE_DP *)pytalloc_get_ptr(obj);
	PyObject *py_dwReserved0;
	py_dwReserved0 = PyInt_FromLong(object->dwReserved0);
	return py_dwReserved0;
}

static int py_DNS_RPC_ZONE_CHANGE_DP_set_dwReserved0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CHANGE_DP *object = (struct DNS_RPC_ZONE_CHANGE_DP *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwReserved0 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CHANGE_DP_get_pszDestPartition(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CHANGE_DP *object = (struct DNS_RPC_ZONE_CHANGE_DP *)pytalloc_get_ptr(obj);
	PyObject *py_pszDestPartition;
	if (object->pszDestPartition == NULL) {
		py_pszDestPartition = Py_None;
		Py_INCREF(py_pszDestPartition);
	} else {
		if (object->pszDestPartition == NULL) {
			py_pszDestPartition = Py_None;
			Py_INCREF(py_pszDestPartition);
		} else {
			py_pszDestPartition = PyUnicode_Decode(object->pszDestPartition, strlen(object->pszDestPartition), "utf-8", "ignore");
		}
	}
	return py_pszDestPartition;
}

static int py_DNS_RPC_ZONE_CHANGE_DP_set_pszDestPartition(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CHANGE_DP *object = (struct DNS_RPC_ZONE_CHANGE_DP *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszDestPartition = NULL;
	} else {
		object->pszDestPartition = NULL;
		if (PyUnicode_Check(value)) {
			object->pszDestPartition = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszDestPartition = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_ZONE_CHANGE_DP_getsetters[] = {
	{ discard_const_p(char, "dwRpcStructureVersion"), py_DNS_RPC_ZONE_CHANGE_DP_get_dwRpcStructureVersion, py_DNS_RPC_ZONE_CHANGE_DP_set_dwRpcStructureVersion },
	{ discard_const_p(char, "dwReserved0"), py_DNS_RPC_ZONE_CHANGE_DP_get_dwReserved0, py_DNS_RPC_ZONE_CHANGE_DP_set_dwReserved0 },
	{ discard_const_p(char, "pszDestPartition"), py_DNS_RPC_ZONE_CHANGE_DP_get_pszDestPartition, py_DNS_RPC_ZONE_CHANGE_DP_set_pszDestPartition },
	{ NULL }
};

static PyObject *py_DNS_RPC_ZONE_CHANGE_DP_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_ZONE_CHANGE_DP, type);
}


static PyTypeObject DNS_RPC_ZONE_CHANGE_DP_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.DNS_RPC_ZONE_CHANGE_DP",
	.tp_getset = py_DNS_RPC_ZONE_CHANGE_DP_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DNS_RPC_ZONE_CHANGE_DP_new,
};


static PyObject *py_DNS_RPC_ZONE_W2K_get_pszZoneName(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_W2K *object = (struct DNS_RPC_ZONE_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_pszZoneName;
	if (object->pszZoneName == NULL) {
		py_pszZoneName = Py_None;
		Py_INCREF(py_pszZoneName);
	} else {
		if (object->pszZoneName == NULL) {
			py_pszZoneName = Py_None;
			Py_INCREF(py_pszZoneName);
		} else {
			py_pszZoneName = PyUnicode_Decode(object->pszZoneName, strlen(object->pszZoneName), "utf-8", "ignore");
		}
	}
	return py_pszZoneName;
}

static int py_DNS_RPC_ZONE_W2K_set_pszZoneName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_W2K *object = (struct DNS_RPC_ZONE_W2K *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszZoneName = NULL;
	} else {
		object->pszZoneName = NULL;
		if (PyUnicode_Check(value)) {
			object->pszZoneName = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszZoneName = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_W2K_get_Flags(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_W2K *object = (struct DNS_RPC_ZONE_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_Flags;
	py_Flags = PyInt_FromLong(object->Flags);
	return py_Flags;
}

static int py_DNS_RPC_ZONE_W2K_set_Flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_W2K *object = (struct DNS_RPC_ZONE_W2K *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->Flags = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->Flags = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_W2K_get_ZoneType(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_W2K *object = (struct DNS_RPC_ZONE_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_ZoneType;
	py_ZoneType = PyInt_FromLong(object->ZoneType);
	return py_ZoneType;
}

static int py_DNS_RPC_ZONE_W2K_set_ZoneType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_W2K *object = (struct DNS_RPC_ZONE_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->ZoneType = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_W2K_get_Version(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_W2K *object = (struct DNS_RPC_ZONE_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_Version;
	py_Version = PyInt_FromLong(object->Version);
	return py_Version;
}

static int py_DNS_RPC_ZONE_W2K_set_Version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_W2K *object = (struct DNS_RPC_ZONE_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->Version = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_DNS_RPC_ZONE_W2K_getsetters[] = {
	{ discard_const_p(char, "pszZoneName"), py_DNS_RPC_ZONE_W2K_get_pszZoneName, py_DNS_RPC_ZONE_W2K_set_pszZoneName },
	{ discard_const_p(char, "Flags"), py_DNS_RPC_ZONE_W2K_get_Flags, py_DNS_RPC_ZONE_W2K_set_Flags },
	{ discard_const_p(char, "ZoneType"), py_DNS_RPC_ZONE_W2K_get_ZoneType, py_DNS_RPC_ZONE_W2K_set_ZoneType },
	{ discard_const_p(char, "Version"), py_DNS_RPC_ZONE_W2K_get_Version, py_DNS_RPC_ZONE_W2K_set_Version },
	{ NULL }
};

static PyObject *py_DNS_RPC_ZONE_W2K_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_ZONE_W2K, type);
}


static PyTypeObject DNS_RPC_ZONE_W2K_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.DNS_RPC_ZONE_W2K",
	.tp_getset = py_DNS_RPC_ZONE_W2K_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DNS_RPC_ZONE_W2K_new,
};


static PyObject *py_DNS_RPC_ZONE_DOTNET_get_dwRpcStructureVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_DOTNET *object = (struct DNS_RPC_ZONE_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwRpcStructureVersion;
	py_dwRpcStructureVersion = PyInt_FromLong(object->dwRpcStructureVersion);
	return py_dwRpcStructureVersion;
}

static int py_DNS_RPC_ZONE_DOTNET_set_dwRpcStructureVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_DOTNET *object = (struct DNS_RPC_ZONE_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwRpcStructureVersion = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_DOTNET_get_dwReserved0(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_DOTNET *object = (struct DNS_RPC_ZONE_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwReserved0;
	py_dwReserved0 = PyInt_FromLong(object->dwReserved0);
	return py_dwReserved0;
}

static int py_DNS_RPC_ZONE_DOTNET_set_dwReserved0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_DOTNET *object = (struct DNS_RPC_ZONE_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwReserved0 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_DOTNET_get_pszZoneName(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_DOTNET *object = (struct DNS_RPC_ZONE_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_pszZoneName;
	if (object->pszZoneName == NULL) {
		py_pszZoneName = Py_None;
		Py_INCREF(py_pszZoneName);
	} else {
		if (object->pszZoneName == NULL) {
			py_pszZoneName = Py_None;
			Py_INCREF(py_pszZoneName);
		} else {
			py_pszZoneName = PyUnicode_Decode(object->pszZoneName, strlen(object->pszZoneName), "utf-8", "ignore");
		}
	}
	return py_pszZoneName;
}

static int py_DNS_RPC_ZONE_DOTNET_set_pszZoneName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_DOTNET *object = (struct DNS_RPC_ZONE_DOTNET *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszZoneName = NULL;
	} else {
		object->pszZoneName = NULL;
		if (PyUnicode_Check(value)) {
			object->pszZoneName = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszZoneName = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_DOTNET_get_Flags(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_DOTNET *object = (struct DNS_RPC_ZONE_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_Flags;
	py_Flags = PyInt_FromLong(object->Flags);
	return py_Flags;
}

static int py_DNS_RPC_ZONE_DOTNET_set_Flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_DOTNET *object = (struct DNS_RPC_ZONE_DOTNET *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->Flags = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->Flags = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_DOTNET_get_ZoneType(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_DOTNET *object = (struct DNS_RPC_ZONE_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_ZoneType;
	py_ZoneType = PyInt_FromLong(object->ZoneType);
	return py_ZoneType;
}

static int py_DNS_RPC_ZONE_DOTNET_set_ZoneType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_DOTNET *object = (struct DNS_RPC_ZONE_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->ZoneType = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_DOTNET_get_Version(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_DOTNET *object = (struct DNS_RPC_ZONE_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_Version;
	py_Version = PyInt_FromLong(object->Version);
	return py_Version;
}

static int py_DNS_RPC_ZONE_DOTNET_set_Version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_DOTNET *object = (struct DNS_RPC_ZONE_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->Version = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_DOTNET_get_dwDpFlags(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_DOTNET *object = (struct DNS_RPC_ZONE_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwDpFlags;
	py_dwDpFlags = PyInt_FromLong(object->dwDpFlags);
	return py_dwDpFlags;
}

static int py_DNS_RPC_ZONE_DOTNET_set_dwDpFlags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_DOTNET *object = (struct DNS_RPC_ZONE_DOTNET *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->dwDpFlags = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->dwDpFlags = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_DOTNET_get_pszDpFqdn(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_DOTNET *object = (struct DNS_RPC_ZONE_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_pszDpFqdn;
	if (object->pszDpFqdn == NULL) {
		py_pszDpFqdn = Py_None;
		Py_INCREF(py_pszDpFqdn);
	} else {
		if (object->pszDpFqdn == NULL) {
			py_pszDpFqdn = Py_None;
			Py_INCREF(py_pszDpFqdn);
		} else {
			py_pszDpFqdn = PyUnicode_Decode(object->pszDpFqdn, strlen(object->pszDpFqdn), "utf-8", "ignore");
		}
	}
	return py_pszDpFqdn;
}

static int py_DNS_RPC_ZONE_DOTNET_set_pszDpFqdn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_DOTNET *object = (struct DNS_RPC_ZONE_DOTNET *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszDpFqdn = NULL;
	} else {
		object->pszDpFqdn = NULL;
		if (PyUnicode_Check(value)) {
			object->pszDpFqdn = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszDpFqdn = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_ZONE_DOTNET_getsetters[] = {
	{ discard_const_p(char, "dwRpcStructureVersion"), py_DNS_RPC_ZONE_DOTNET_get_dwRpcStructureVersion, py_DNS_RPC_ZONE_DOTNET_set_dwRpcStructureVersion },
	{ discard_const_p(char, "dwReserved0"), py_DNS_RPC_ZONE_DOTNET_get_dwReserved0, py_DNS_RPC_ZONE_DOTNET_set_dwReserved0 },
	{ discard_const_p(char, "pszZoneName"), py_DNS_RPC_ZONE_DOTNET_get_pszZoneName, py_DNS_RPC_ZONE_DOTNET_set_pszZoneName },
	{ discard_const_p(char, "Flags"), py_DNS_RPC_ZONE_DOTNET_get_Flags, py_DNS_RPC_ZONE_DOTNET_set_Flags },
	{ discard_const_p(char, "ZoneType"), py_DNS_RPC_ZONE_DOTNET_get_ZoneType, py_DNS_RPC_ZONE_DOTNET_set_ZoneType },
	{ discard_const_p(char, "Version"), py_DNS_RPC_ZONE_DOTNET_get_Version, py_DNS_RPC_ZONE_DOTNET_set_Version },
	{ discard_const_p(char, "dwDpFlags"), py_DNS_RPC_ZONE_DOTNET_get_dwDpFlags, py_DNS_RPC_ZONE_DOTNET_set_dwDpFlags },
	{ discard_const_p(char, "pszDpFqdn"), py_DNS_RPC_ZONE_DOTNET_get_pszDpFqdn, py_DNS_RPC_ZONE_DOTNET_set_pszDpFqdn },
	{ NULL }
};

static PyObject *py_DNS_RPC_ZONE_DOTNET_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_ZONE_DOTNET, type);
}


static PyTypeObject DNS_RPC_ZONE_DOTNET_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.DNS_RPC_ZONE_DOTNET",
	.tp_getset = py_DNS_RPC_ZONE_DOTNET_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DNS_RPC_ZONE_DOTNET_new,
};


static PyObject *py_DNS_RPC_ZONE_LIST_W2K_get_dwZoneCount(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_LIST_W2K *object = (struct DNS_RPC_ZONE_LIST_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_dwZoneCount;
	py_dwZoneCount = PyInt_FromLong(object->dwZoneCount);
	return py_dwZoneCount;
}

static int py_DNS_RPC_ZONE_LIST_W2K_set_dwZoneCount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_LIST_W2K *object = (struct DNS_RPC_ZONE_LIST_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwZoneCount = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_LIST_W2K_get_ZoneArray(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_LIST_W2K *object = (struct DNS_RPC_ZONE_LIST_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_ZoneArray;
	py_ZoneArray = PyList_New(object->dwZoneCount);
	if (py_ZoneArray == NULL) {
		return NULL;
	}
	{
		int ZoneArray_cntr_0;
		for (ZoneArray_cntr_0 = 0; ZoneArray_cntr_0 < object->dwZoneCount; ZoneArray_cntr_0++) {
			PyObject *py_ZoneArray_0;
			if (object->ZoneArray[ZoneArray_cntr_0] == NULL) {
				py_ZoneArray_0 = Py_None;
				Py_INCREF(py_ZoneArray_0);
			} else {
				py_ZoneArray_0 = pytalloc_reference_ex(&DNS_RPC_ZONE_W2K_Type, object->ZoneArray[ZoneArray_cntr_0], object->ZoneArray[ZoneArray_cntr_0]);
			}
			PyList_SetItem(py_ZoneArray, ZoneArray_cntr_0, py_ZoneArray_0);
		}
	}
	return py_ZoneArray;
}

static int py_DNS_RPC_ZONE_LIST_W2K_set_ZoneArray(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_LIST_W2K *object = (struct DNS_RPC_ZONE_LIST_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int ZoneArray_cntr_0;
		object->ZoneArray = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->ZoneArray, PyList_GET_SIZE(value));
		if (!object->ZoneArray) { return -1;; }
		talloc_set_name_const(object->ZoneArray, "ARRAY: object->ZoneArray");
		for (ZoneArray_cntr_0 = 0; ZoneArray_cntr_0 < PyList_GET_SIZE(value); ZoneArray_cntr_0++) {
			if (PyList_GET_ITEM(value, ZoneArray_cntr_0) == Py_None) {
				object->ZoneArray[ZoneArray_cntr_0] = NULL;
			} else {
				object->ZoneArray[ZoneArray_cntr_0] = NULL;
				PY_CHECK_TYPE(&DNS_RPC_ZONE_W2K_Type, PyList_GET_ITEM(value, ZoneArray_cntr_0), return -1;);
				if (talloc_reference(object->ZoneArray, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, ZoneArray_cntr_0))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				object->ZoneArray[ZoneArray_cntr_0] = (struct DNS_RPC_ZONE_W2K *)pytalloc_get_ptr(PyList_GET_ITEM(value, ZoneArray_cntr_0));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_ZONE_LIST_W2K_getsetters[] = {
	{ discard_const_p(char, "dwZoneCount"), py_DNS_RPC_ZONE_LIST_W2K_get_dwZoneCount, py_DNS_RPC_ZONE_LIST_W2K_set_dwZoneCount },
	{ discard_const_p(char, "ZoneArray"), py_DNS_RPC_ZONE_LIST_W2K_get_ZoneArray, py_DNS_RPC_ZONE_LIST_W2K_set_ZoneArray },
	{ NULL }
};

static PyObject *py_DNS_RPC_ZONE_LIST_W2K_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_ZONE_LIST_W2K, type);
}


static PyTypeObject DNS_RPC_ZONE_LIST_W2K_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.DNS_RPC_ZONE_LIST_W2K",
	.tp_getset = py_DNS_RPC_ZONE_LIST_W2K_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DNS_RPC_ZONE_LIST_W2K_new,
};


static PyObject *py_DNS_RPC_ZONE_LIST_DOTNET_get_dwRpcStructureVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_LIST_DOTNET *object = (struct DNS_RPC_ZONE_LIST_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwRpcStructureVersion;
	py_dwRpcStructureVersion = PyInt_FromLong(object->dwRpcStructureVersion);
	return py_dwRpcStructureVersion;
}

static int py_DNS_RPC_ZONE_LIST_DOTNET_set_dwRpcStructureVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_LIST_DOTNET *object = (struct DNS_RPC_ZONE_LIST_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwRpcStructureVersion = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_LIST_DOTNET_get_dwReserved0(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_LIST_DOTNET *object = (struct DNS_RPC_ZONE_LIST_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwReserved0;
	py_dwReserved0 = PyInt_FromLong(object->dwReserved0);
	return py_dwReserved0;
}

static int py_DNS_RPC_ZONE_LIST_DOTNET_set_dwReserved0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_LIST_DOTNET *object = (struct DNS_RPC_ZONE_LIST_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwReserved0 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_LIST_DOTNET_get_dwZoneCount(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_LIST_DOTNET *object = (struct DNS_RPC_ZONE_LIST_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwZoneCount;
	py_dwZoneCount = PyInt_FromLong(object->dwZoneCount);
	return py_dwZoneCount;
}

static int py_DNS_RPC_ZONE_LIST_DOTNET_set_dwZoneCount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_LIST_DOTNET *object = (struct DNS_RPC_ZONE_LIST_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwZoneCount = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_LIST_DOTNET_get_ZoneArray(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_LIST_DOTNET *object = (struct DNS_RPC_ZONE_LIST_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_ZoneArray;
	py_ZoneArray = PyList_New(object->dwZoneCount);
	if (py_ZoneArray == NULL) {
		return NULL;
	}
	{
		int ZoneArray_cntr_0;
		for (ZoneArray_cntr_0 = 0; ZoneArray_cntr_0 < object->dwZoneCount; ZoneArray_cntr_0++) {
			PyObject *py_ZoneArray_0;
			if (object->ZoneArray[ZoneArray_cntr_0] == NULL) {
				py_ZoneArray_0 = Py_None;
				Py_INCREF(py_ZoneArray_0);
			} else {
				py_ZoneArray_0 = pytalloc_reference_ex(&DNS_RPC_ZONE_DOTNET_Type, object->ZoneArray[ZoneArray_cntr_0], object->ZoneArray[ZoneArray_cntr_0]);
			}
			PyList_SetItem(py_ZoneArray, ZoneArray_cntr_0, py_ZoneArray_0);
		}
	}
	return py_ZoneArray;
}

static int py_DNS_RPC_ZONE_LIST_DOTNET_set_ZoneArray(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_LIST_DOTNET *object = (struct DNS_RPC_ZONE_LIST_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int ZoneArray_cntr_0;
		object->ZoneArray = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->ZoneArray, PyList_GET_SIZE(value));
		if (!object->ZoneArray) { return -1;; }
		talloc_set_name_const(object->ZoneArray, "ARRAY: object->ZoneArray");
		for (ZoneArray_cntr_0 = 0; ZoneArray_cntr_0 < PyList_GET_SIZE(value); ZoneArray_cntr_0++) {
			if (PyList_GET_ITEM(value, ZoneArray_cntr_0) == Py_None) {
				object->ZoneArray[ZoneArray_cntr_0] = NULL;
			} else {
				object->ZoneArray[ZoneArray_cntr_0] = NULL;
				PY_CHECK_TYPE(&DNS_RPC_ZONE_DOTNET_Type, PyList_GET_ITEM(value, ZoneArray_cntr_0), return -1;);
				if (talloc_reference(object->ZoneArray, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, ZoneArray_cntr_0))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				object->ZoneArray[ZoneArray_cntr_0] = (struct DNS_RPC_ZONE_DOTNET *)pytalloc_get_ptr(PyList_GET_ITEM(value, ZoneArray_cntr_0));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_ZONE_LIST_DOTNET_getsetters[] = {
	{ discard_const_p(char, "dwRpcStructureVersion"), py_DNS_RPC_ZONE_LIST_DOTNET_get_dwRpcStructureVersion, py_DNS_RPC_ZONE_LIST_DOTNET_set_dwRpcStructureVersion },
	{ discard_const_p(char, "dwReserved0"), py_DNS_RPC_ZONE_LIST_DOTNET_get_dwReserved0, py_DNS_RPC_ZONE_LIST_DOTNET_set_dwReserved0 },
	{ discard_const_p(char, "dwZoneCount"), py_DNS_RPC_ZONE_LIST_DOTNET_get_dwZoneCount, py_DNS_RPC_ZONE_LIST_DOTNET_set_dwZoneCount },
	{ discard_const_p(char, "ZoneArray"), py_DNS_RPC_ZONE_LIST_DOTNET_get_ZoneArray, py_DNS_RPC_ZONE_LIST_DOTNET_set_ZoneArray },
	{ NULL }
};

static PyObject *py_DNS_RPC_ZONE_LIST_DOTNET_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_ZONE_LIST_DOTNET, type);
}


static PyTypeObject DNS_RPC_ZONE_LIST_DOTNET_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.DNS_RPC_ZONE_LIST_DOTNET",
	.tp_getset = py_DNS_RPC_ZONE_LIST_DOTNET_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DNS_RPC_ZONE_LIST_DOTNET_new,
};


static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_pszZoneName(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_pszZoneName;
	if (object->pszZoneName == NULL) {
		py_pszZoneName = Py_None;
		Py_INCREF(py_pszZoneName);
	} else {
		if (object->pszZoneName == NULL) {
			py_pszZoneName = Py_None;
			Py_INCREF(py_pszZoneName);
		} else {
			py_pszZoneName = PyUnicode_Decode(object->pszZoneName, strlen(object->pszZoneName), "utf-8", "ignore");
		}
	}
	return py_pszZoneName;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_pszZoneName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszZoneName = NULL;
	} else {
		object->pszZoneName = NULL;
		if (PyUnicode_Check(value)) {
			object->pszZoneName = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszZoneName = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_dwZoneType(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_dwZoneType;
	py_dwZoneType = PyInt_FromLong(object->dwZoneType);
	return py_dwZoneType;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_dwZoneType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwZoneType = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_fReverse(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_fReverse;
	py_fReverse = PyInt_FromLong(object->fReverse);
	return py_fReverse;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_fReverse(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fReverse = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_fAllowUpdate(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_fAllowUpdate;
	py_fAllowUpdate = PyInt_FromLong(object->fAllowUpdate);
	return py_fAllowUpdate;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_fAllowUpdate(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->fAllowUpdate = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->fAllowUpdate = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_fPaused(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_fPaused;
	py_fPaused = PyInt_FromLong(object->fPaused);
	return py_fPaused;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_fPaused(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fPaused = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_fShutdown(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_fShutdown;
	py_fShutdown = PyInt_FromLong(object->fShutdown);
	return py_fShutdown;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_fShutdown(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fShutdown = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_fAutoCreated(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_fAutoCreated;
	py_fAutoCreated = PyInt_FromLong(object->fAutoCreated);
	return py_fAutoCreated;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_fAutoCreated(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fAutoCreated = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_fUseDatabase(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_fUseDatabase;
	py_fUseDatabase = PyInt_FromLong(object->fUseDatabase);
	return py_fUseDatabase;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_fUseDatabase(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fUseDatabase = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_pszDataFile(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_pszDataFile;
	if (object->pszDataFile == NULL) {
		py_pszDataFile = Py_None;
		Py_INCREF(py_pszDataFile);
	} else {
		if (object->pszDataFile == NULL) {
			py_pszDataFile = Py_None;
			Py_INCREF(py_pszDataFile);
		} else {
			py_pszDataFile = PyUnicode_Decode(object->pszDataFile, strlen(object->pszDataFile), "utf-8", "ignore");
		}
	}
	return py_pszDataFile;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_pszDataFile(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszDataFile = NULL;
	} else {
		object->pszDataFile = NULL;
		if (PyUnicode_Check(value)) {
			object->pszDataFile = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszDataFile = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_aipMasters(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_aipMasters;
	if (object->aipMasters == NULL) {
		py_aipMasters = Py_None;
		Py_INCREF(py_aipMasters);
	} else {
		py_aipMasters = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipMasters, object->aipMasters);
	}
	return py_aipMasters;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_aipMasters(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->aipMasters);
	if (value == Py_None) {
		object->aipMasters = NULL;
	} else {
		object->aipMasters = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipMasters = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_fSecureSecondaries(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_fSecureSecondaries;
	py_fSecureSecondaries = PyInt_FromLong(object->fSecureSecondaries);
	return py_fSecureSecondaries;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_fSecureSecondaries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->fSecureSecondaries = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->fSecureSecondaries = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_fNotifyLevel(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_fNotifyLevel;
	py_fNotifyLevel = PyInt_FromLong(object->fNotifyLevel);
	return py_fNotifyLevel;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_fNotifyLevel(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->fNotifyLevel = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->fNotifyLevel = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_aipSecondaries(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_aipSecondaries;
	if (object->aipSecondaries == NULL) {
		py_aipSecondaries = Py_None;
		Py_INCREF(py_aipSecondaries);
	} else {
		py_aipSecondaries = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipSecondaries, object->aipSecondaries);
	}
	return py_aipSecondaries;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_aipSecondaries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->aipSecondaries);
	if (value == Py_None) {
		object->aipSecondaries = NULL;
	} else {
		object->aipSecondaries = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipSecondaries = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_aipNotify(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_aipNotify;
	if (object->aipNotify == NULL) {
		py_aipNotify = Py_None;
		Py_INCREF(py_aipNotify);
	} else {
		py_aipNotify = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipNotify, object->aipNotify);
	}
	return py_aipNotify;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_aipNotify(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->aipNotify);
	if (value == Py_None) {
		object->aipNotify = NULL;
	} else {
		object->aipNotify = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipNotify = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_fUseWins(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_fUseWins;
	py_fUseWins = PyInt_FromLong(object->fUseWins);
	return py_fUseWins;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_fUseWins(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fUseWins = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_fUseNbstat(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_fUseNbstat;
	py_fUseNbstat = PyInt_FromLong(object->fUseNbstat);
	return py_fUseNbstat;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_fUseNbstat(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fUseNbstat = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_fAging(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_fAging;
	py_fAging = PyInt_FromLong(object->fAging);
	return py_fAging;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_fAging(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fAging = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_dwNoRefreshInterval(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_dwNoRefreshInterval;
	py_dwNoRefreshInterval = PyInt_FromLong(object->dwNoRefreshInterval);
	return py_dwNoRefreshInterval;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_dwNoRefreshInterval(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwNoRefreshInterval = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_dwRefreshInterval(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_dwRefreshInterval;
	py_dwRefreshInterval = PyInt_FromLong(object->dwRefreshInterval);
	return py_dwRefreshInterval;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_dwRefreshInterval(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwRefreshInterval = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_dwAvailForScavengeTime(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_dwAvailForScavengeTime;
	py_dwAvailForScavengeTime = PyInt_FromLong(object->dwAvailForScavengeTime);
	return py_dwAvailForScavengeTime;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_dwAvailForScavengeTime(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwAvailForScavengeTime = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_aipScavengeServers(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_aipScavengeServers;
	if (object->aipScavengeServers == NULL) {
		py_aipScavengeServers = Py_None;
		Py_INCREF(py_aipScavengeServers);
	} else {
		py_aipScavengeServers = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipScavengeServers, object->aipScavengeServers);
	}
	return py_aipScavengeServers;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_aipScavengeServers(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->aipScavengeServers);
	if (value == Py_None) {
		object->aipScavengeServers = NULL;
	} else {
		object->aipScavengeServers = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipScavengeServers = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_pvReserved1(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_pvReserved1;
	py_pvReserved1 = PyInt_FromLong(object->pvReserved1);
	return py_pvReserved1;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_pvReserved1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->pvReserved1 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_pvReserved2(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_pvReserved2;
	py_pvReserved2 = PyInt_FromLong(object->pvReserved2);
	return py_pvReserved2;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_pvReserved2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->pvReserved2 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_pvReserved3(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_pvReserved3;
	py_pvReserved3 = PyInt_FromLong(object->pvReserved3);
	return py_pvReserved3;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_pvReserved3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->pvReserved3 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_get_pvReserved4(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_pvReserved4;
	py_pvReserved4 = PyInt_FromLong(object->pvReserved4);
	return py_pvReserved4;
}

static int py_DNS_RPC_ZONE_INFO_W2K_set_pvReserved4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_W2K *object = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->pvReserved4 = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_DNS_RPC_ZONE_INFO_W2K_getsetters[] = {
	{ discard_const_p(char, "pszZoneName"), py_DNS_RPC_ZONE_INFO_W2K_get_pszZoneName, py_DNS_RPC_ZONE_INFO_W2K_set_pszZoneName },
	{ discard_const_p(char, "dwZoneType"), py_DNS_RPC_ZONE_INFO_W2K_get_dwZoneType, py_DNS_RPC_ZONE_INFO_W2K_set_dwZoneType },
	{ discard_const_p(char, "fReverse"), py_DNS_RPC_ZONE_INFO_W2K_get_fReverse, py_DNS_RPC_ZONE_INFO_W2K_set_fReverse },
	{ discard_const_p(char, "fAllowUpdate"), py_DNS_RPC_ZONE_INFO_W2K_get_fAllowUpdate, py_DNS_RPC_ZONE_INFO_W2K_set_fAllowUpdate },
	{ discard_const_p(char, "fPaused"), py_DNS_RPC_ZONE_INFO_W2K_get_fPaused, py_DNS_RPC_ZONE_INFO_W2K_set_fPaused },
	{ discard_const_p(char, "fShutdown"), py_DNS_RPC_ZONE_INFO_W2K_get_fShutdown, py_DNS_RPC_ZONE_INFO_W2K_set_fShutdown },
	{ discard_const_p(char, "fAutoCreated"), py_DNS_RPC_ZONE_INFO_W2K_get_fAutoCreated, py_DNS_RPC_ZONE_INFO_W2K_set_fAutoCreated },
	{ discard_const_p(char, "fUseDatabase"), py_DNS_RPC_ZONE_INFO_W2K_get_fUseDatabase, py_DNS_RPC_ZONE_INFO_W2K_set_fUseDatabase },
	{ discard_const_p(char, "pszDataFile"), py_DNS_RPC_ZONE_INFO_W2K_get_pszDataFile, py_DNS_RPC_ZONE_INFO_W2K_set_pszDataFile },
	{ discard_const_p(char, "aipMasters"), py_DNS_RPC_ZONE_INFO_W2K_get_aipMasters, py_DNS_RPC_ZONE_INFO_W2K_set_aipMasters },
	{ discard_const_p(char, "fSecureSecondaries"), py_DNS_RPC_ZONE_INFO_W2K_get_fSecureSecondaries, py_DNS_RPC_ZONE_INFO_W2K_set_fSecureSecondaries },
	{ discard_const_p(char, "fNotifyLevel"), py_DNS_RPC_ZONE_INFO_W2K_get_fNotifyLevel, py_DNS_RPC_ZONE_INFO_W2K_set_fNotifyLevel },
	{ discard_const_p(char, "aipSecondaries"), py_DNS_RPC_ZONE_INFO_W2K_get_aipSecondaries, py_DNS_RPC_ZONE_INFO_W2K_set_aipSecondaries },
	{ discard_const_p(char, "aipNotify"), py_DNS_RPC_ZONE_INFO_W2K_get_aipNotify, py_DNS_RPC_ZONE_INFO_W2K_set_aipNotify },
	{ discard_const_p(char, "fUseWins"), py_DNS_RPC_ZONE_INFO_W2K_get_fUseWins, py_DNS_RPC_ZONE_INFO_W2K_set_fUseWins },
	{ discard_const_p(char, "fUseNbstat"), py_DNS_RPC_ZONE_INFO_W2K_get_fUseNbstat, py_DNS_RPC_ZONE_INFO_W2K_set_fUseNbstat },
	{ discard_const_p(char, "fAging"), py_DNS_RPC_ZONE_INFO_W2K_get_fAging, py_DNS_RPC_ZONE_INFO_W2K_set_fAging },
	{ discard_const_p(char, "dwNoRefreshInterval"), py_DNS_RPC_ZONE_INFO_W2K_get_dwNoRefreshInterval, py_DNS_RPC_ZONE_INFO_W2K_set_dwNoRefreshInterval },
	{ discard_const_p(char, "dwRefreshInterval"), py_DNS_RPC_ZONE_INFO_W2K_get_dwRefreshInterval, py_DNS_RPC_ZONE_INFO_W2K_set_dwRefreshInterval },
	{ discard_const_p(char, "dwAvailForScavengeTime"), py_DNS_RPC_ZONE_INFO_W2K_get_dwAvailForScavengeTime, py_DNS_RPC_ZONE_INFO_W2K_set_dwAvailForScavengeTime },
	{ discard_const_p(char, "aipScavengeServers"), py_DNS_RPC_ZONE_INFO_W2K_get_aipScavengeServers, py_DNS_RPC_ZONE_INFO_W2K_set_aipScavengeServers },
	{ discard_const_p(char, "pvReserved1"), py_DNS_RPC_ZONE_INFO_W2K_get_pvReserved1, py_DNS_RPC_ZONE_INFO_W2K_set_pvReserved1 },
	{ discard_const_p(char, "pvReserved2"), py_DNS_RPC_ZONE_INFO_W2K_get_pvReserved2, py_DNS_RPC_ZONE_INFO_W2K_set_pvReserved2 },
	{ discard_const_p(char, "pvReserved3"), py_DNS_RPC_ZONE_INFO_W2K_get_pvReserved3, py_DNS_RPC_ZONE_INFO_W2K_set_pvReserved3 },
	{ discard_const_p(char, "pvReserved4"), py_DNS_RPC_ZONE_INFO_W2K_get_pvReserved4, py_DNS_RPC_ZONE_INFO_W2K_set_pvReserved4 },
	{ NULL }
};

static PyObject *py_DNS_RPC_ZONE_INFO_W2K_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_ZONE_INFO_W2K, type);
}


static PyTypeObject DNS_RPC_ZONE_INFO_W2K_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.DNS_RPC_ZONE_INFO_W2K",
	.tp_getset = py_DNS_RPC_ZONE_INFO_W2K_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DNS_RPC_ZONE_INFO_W2K_new,
};


static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_dwRpcStructureVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwRpcStructureVersion;
	py_dwRpcStructureVersion = PyInt_FromLong(object->dwRpcStructureVersion);
	return py_dwRpcStructureVersion;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_dwRpcStructureVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwRpcStructureVersion = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_dwReserved0(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwReserved0;
	py_dwReserved0 = PyInt_FromLong(object->dwReserved0);
	return py_dwReserved0;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_dwReserved0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwReserved0 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_pszZoneName(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_pszZoneName;
	if (object->pszZoneName == NULL) {
		py_pszZoneName = Py_None;
		Py_INCREF(py_pszZoneName);
	} else {
		if (object->pszZoneName == NULL) {
			py_pszZoneName = Py_None;
			Py_INCREF(py_pszZoneName);
		} else {
			py_pszZoneName = PyUnicode_Decode(object->pszZoneName, strlen(object->pszZoneName), "utf-8", "ignore");
		}
	}
	return py_pszZoneName;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_pszZoneName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszZoneName = NULL;
	} else {
		object->pszZoneName = NULL;
		if (PyUnicode_Check(value)) {
			object->pszZoneName = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszZoneName = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_dwZoneType(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwZoneType;
	py_dwZoneType = PyInt_FromLong(object->dwZoneType);
	return py_dwZoneType;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_dwZoneType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwZoneType = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_fReverse(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_fReverse;
	py_fReverse = PyInt_FromLong(object->fReverse);
	return py_fReverse;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_fReverse(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fReverse = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_fAllowUpdate(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_fAllowUpdate;
	py_fAllowUpdate = PyInt_FromLong(object->fAllowUpdate);
	return py_fAllowUpdate;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_fAllowUpdate(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->fAllowUpdate = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->fAllowUpdate = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_fPaused(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_fPaused;
	py_fPaused = PyInt_FromLong(object->fPaused);
	return py_fPaused;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_fPaused(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fPaused = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_fShutdown(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_fShutdown;
	py_fShutdown = PyInt_FromLong(object->fShutdown);
	return py_fShutdown;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_fShutdown(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fShutdown = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_fAutoCreated(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_fAutoCreated;
	py_fAutoCreated = PyInt_FromLong(object->fAutoCreated);
	return py_fAutoCreated;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_fAutoCreated(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fAutoCreated = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_fUseDatabase(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_fUseDatabase;
	py_fUseDatabase = PyInt_FromLong(object->fUseDatabase);
	return py_fUseDatabase;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_fUseDatabase(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fUseDatabase = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_pszDataFile(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_pszDataFile;
	if (object->pszDataFile == NULL) {
		py_pszDataFile = Py_None;
		Py_INCREF(py_pszDataFile);
	} else {
		if (object->pszDataFile == NULL) {
			py_pszDataFile = Py_None;
			Py_INCREF(py_pszDataFile);
		} else {
			py_pszDataFile = PyUnicode_Decode(object->pszDataFile, strlen(object->pszDataFile), "utf-8", "ignore");
		}
	}
	return py_pszDataFile;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_pszDataFile(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszDataFile = NULL;
	} else {
		object->pszDataFile = NULL;
		if (PyUnicode_Check(value)) {
			object->pszDataFile = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszDataFile = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_aipMasters(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_aipMasters;
	if (object->aipMasters == NULL) {
		py_aipMasters = Py_None;
		Py_INCREF(py_aipMasters);
	} else {
		py_aipMasters = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipMasters, object->aipMasters);
	}
	return py_aipMasters;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_aipMasters(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->aipMasters);
	if (value == Py_None) {
		object->aipMasters = NULL;
	} else {
		object->aipMasters = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipMasters = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_fSecureSecondaries(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_fSecureSecondaries;
	py_fSecureSecondaries = PyInt_FromLong(object->fSecureSecondaries);
	return py_fSecureSecondaries;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_fSecureSecondaries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->fSecureSecondaries = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->fSecureSecondaries = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_fNotifyLevel(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_fNotifyLevel;
	py_fNotifyLevel = PyInt_FromLong(object->fNotifyLevel);
	return py_fNotifyLevel;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_fNotifyLevel(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->fNotifyLevel = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->fNotifyLevel = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_aipSecondaries(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_aipSecondaries;
	if (object->aipSecondaries == NULL) {
		py_aipSecondaries = Py_None;
		Py_INCREF(py_aipSecondaries);
	} else {
		py_aipSecondaries = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipSecondaries, object->aipSecondaries);
	}
	return py_aipSecondaries;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_aipSecondaries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->aipSecondaries);
	if (value == Py_None) {
		object->aipSecondaries = NULL;
	} else {
		object->aipSecondaries = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipSecondaries = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_aipNotify(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_aipNotify;
	if (object->aipNotify == NULL) {
		py_aipNotify = Py_None;
		Py_INCREF(py_aipNotify);
	} else {
		py_aipNotify = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipNotify, object->aipNotify);
	}
	return py_aipNotify;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_aipNotify(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->aipNotify);
	if (value == Py_None) {
		object->aipNotify = NULL;
	} else {
		object->aipNotify = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipNotify = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_fUseWins(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_fUseWins;
	py_fUseWins = PyInt_FromLong(object->fUseWins);
	return py_fUseWins;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_fUseWins(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fUseWins = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_fUseNbstat(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_fUseNbstat;
	py_fUseNbstat = PyInt_FromLong(object->fUseNbstat);
	return py_fUseNbstat;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_fUseNbstat(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fUseNbstat = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_fAging(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_fAging;
	py_fAging = PyInt_FromLong(object->fAging);
	return py_fAging;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_fAging(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fAging = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_dwNoRefreshInterval(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwNoRefreshInterval;
	py_dwNoRefreshInterval = PyInt_FromLong(object->dwNoRefreshInterval);
	return py_dwNoRefreshInterval;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_dwNoRefreshInterval(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwNoRefreshInterval = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_dwRefreshInterval(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwRefreshInterval;
	py_dwRefreshInterval = PyInt_FromLong(object->dwRefreshInterval);
	return py_dwRefreshInterval;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_dwRefreshInterval(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwRefreshInterval = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_dwAvailForScavengeTime(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwAvailForScavengeTime;
	py_dwAvailForScavengeTime = PyInt_FromLong(object->dwAvailForScavengeTime);
	return py_dwAvailForScavengeTime;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_dwAvailForScavengeTime(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwAvailForScavengeTime = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_aipScavengeServers(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_aipScavengeServers;
	if (object->aipScavengeServers == NULL) {
		py_aipScavengeServers = Py_None;
		Py_INCREF(py_aipScavengeServers);
	} else {
		py_aipScavengeServers = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipScavengeServers, object->aipScavengeServers);
	}
	return py_aipScavengeServers;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_aipScavengeServers(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->aipScavengeServers);
	if (value == Py_None) {
		object->aipScavengeServers = NULL;
	} else {
		object->aipScavengeServers = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipScavengeServers = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_dwForwarderTimeout(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwForwarderTimeout;
	py_dwForwarderTimeout = PyInt_FromLong(object->dwForwarderTimeout);
	return py_dwForwarderTimeout;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_dwForwarderTimeout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwForwarderTimeout = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_fForwarderSlave(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_fForwarderSlave;
	py_fForwarderSlave = PyInt_FromLong(object->fForwarderSlave);
	return py_fForwarderSlave;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_fForwarderSlave(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fForwarderSlave = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_aipLocalMasters(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_aipLocalMasters;
	if (object->aipLocalMasters == NULL) {
		py_aipLocalMasters = Py_None;
		Py_INCREF(py_aipLocalMasters);
	} else {
		py_aipLocalMasters = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipLocalMasters, object->aipLocalMasters);
	}
	return py_aipLocalMasters;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_aipLocalMasters(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->aipLocalMasters);
	if (value == Py_None) {
		object->aipLocalMasters = NULL;
	} else {
		object->aipLocalMasters = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipLocalMasters = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_dwDpFlags(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwDpFlags;
	py_dwDpFlags = PyInt_FromLong(object->dwDpFlags);
	return py_dwDpFlags;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_dwDpFlags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwDpFlags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_pszDpFqdn(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_pszDpFqdn;
	if (object->pszDpFqdn == NULL) {
		py_pszDpFqdn = Py_None;
		Py_INCREF(py_pszDpFqdn);
	} else {
		if (object->pszDpFqdn == NULL) {
			py_pszDpFqdn = Py_None;
			Py_INCREF(py_pszDpFqdn);
		} else {
			py_pszDpFqdn = PyUnicode_Decode(object->pszDpFqdn, strlen(object->pszDpFqdn), "utf-8", "ignore");
		}
	}
	return py_pszDpFqdn;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_pszDpFqdn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszDpFqdn = NULL;
	} else {
		object->pszDpFqdn = NULL;
		if (PyUnicode_Check(value)) {
			object->pszDpFqdn = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszDpFqdn = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_pwszZoneDn(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_pwszZoneDn;
	if (object->pwszZoneDn == NULL) {
		py_pwszZoneDn = Py_None;
		Py_INCREF(py_pwszZoneDn);
	} else {
		if (object->pwszZoneDn == NULL) {
			py_pwszZoneDn = Py_None;
			Py_INCREF(py_pwszZoneDn);
		} else {
			py_pwszZoneDn = PyUnicode_Decode(object->pwszZoneDn, strlen(object->pwszZoneDn), "utf-8", "ignore");
		}
	}
	return py_pwszZoneDn;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_pwszZoneDn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pwszZoneDn = NULL;
	} else {
		object->pwszZoneDn = NULL;
		if (PyUnicode_Check(value)) {
			object->pwszZoneDn = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pwszZoneDn = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_dwLastSuccessfulSoaCheck(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwLastSuccessfulSoaCheck;
	py_dwLastSuccessfulSoaCheck = PyInt_FromLong(object->dwLastSuccessfulSoaCheck);
	return py_dwLastSuccessfulSoaCheck;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_dwLastSuccessfulSoaCheck(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwLastSuccessfulSoaCheck = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_dwLastSuccessfulXfr(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwLastSuccessfulXfr;
	py_dwLastSuccessfulXfr = PyInt_FromLong(object->dwLastSuccessfulXfr);
	return py_dwLastSuccessfulXfr;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_dwLastSuccessfulXfr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwLastSuccessfulXfr = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_dwReserved1(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwReserved1;
	py_dwReserved1 = PyInt_FromLong(object->dwReserved1);
	return py_dwReserved1;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_dwReserved1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwReserved1 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_dwReserved2(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwReserved2;
	py_dwReserved2 = PyInt_FromLong(object->dwReserved2);
	return py_dwReserved2;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_dwReserved2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwReserved2 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_dwReserved3(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwReserved3;
	py_dwReserved3 = PyInt_FromLong(object->dwReserved3);
	return py_dwReserved3;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_dwReserved3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwReserved3 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_dwReserved4(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwReserved4;
	py_dwReserved4 = PyInt_FromLong(object->dwReserved4);
	return py_dwReserved4;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_dwReserved4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwReserved4 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_dwReserved5(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwReserved5;
	py_dwReserved5 = PyInt_FromLong(object->dwReserved5);
	return py_dwReserved5;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_dwReserved5(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwReserved5 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_pReserved1(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_pReserved1;
	if (object->pReserved1 == NULL) {
		py_pReserved1 = Py_None;
		Py_INCREF(py_pReserved1);
	} else {
		if (object->pReserved1 == NULL) {
			py_pReserved1 = Py_None;
			Py_INCREF(py_pReserved1);
		} else {
			py_pReserved1 = PyUnicode_Decode(object->pReserved1, strlen(object->pReserved1), "utf-8", "ignore");
		}
	}
	return py_pReserved1;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_pReserved1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pReserved1 = NULL;
	} else {
		object->pReserved1 = NULL;
		if (PyUnicode_Check(value)) {
			object->pReserved1 = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pReserved1 = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_pReserved2(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_pReserved2;
	if (object->pReserved2 == NULL) {
		py_pReserved2 = Py_None;
		Py_INCREF(py_pReserved2);
	} else {
		if (object->pReserved2 == NULL) {
			py_pReserved2 = Py_None;
			Py_INCREF(py_pReserved2);
		} else {
			py_pReserved2 = PyUnicode_Decode(object->pReserved2, strlen(object->pReserved2), "utf-8", "ignore");
		}
	}
	return py_pReserved2;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_pReserved2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pReserved2 = NULL;
	} else {
		object->pReserved2 = NULL;
		if (PyUnicode_Check(value)) {
			object->pReserved2 = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pReserved2 = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_pReserved3(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_pReserved3;
	if (object->pReserved3 == NULL) {
		py_pReserved3 = Py_None;
		Py_INCREF(py_pReserved3);
	} else {
		if (object->pReserved3 == NULL) {
			py_pReserved3 = Py_None;
			Py_INCREF(py_pReserved3);
		} else {
			py_pReserved3 = PyUnicode_Decode(object->pReserved3, strlen(object->pReserved3), "utf-8", "ignore");
		}
	}
	return py_pReserved3;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_pReserved3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pReserved3 = NULL;
	} else {
		object->pReserved3 = NULL;
		if (PyUnicode_Check(value)) {
			object->pReserved3 = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pReserved3 = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_get_pReserved4(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_pReserved4;
	if (object->pReserved4 == NULL) {
		py_pReserved4 = Py_None;
		Py_INCREF(py_pReserved4);
	} else {
		if (object->pReserved4 == NULL) {
			py_pReserved4 = Py_None;
			Py_INCREF(py_pReserved4);
		} else {
			py_pReserved4 = PyUnicode_Decode(object->pReserved4, strlen(object->pReserved4), "utf-8", "ignore");
		}
	}
	return py_pReserved4;
}

static int py_DNS_RPC_ZONE_INFO_DOTNET_set_pReserved4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pReserved4 = NULL;
	} else {
		object->pReserved4 = NULL;
		if (PyUnicode_Check(value)) {
			object->pReserved4 = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pReserved4 = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_ZONE_INFO_DOTNET_getsetters[] = {
	{ discard_const_p(char, "dwRpcStructureVersion"), py_DNS_RPC_ZONE_INFO_DOTNET_get_dwRpcStructureVersion, py_DNS_RPC_ZONE_INFO_DOTNET_set_dwRpcStructureVersion },
	{ discard_const_p(char, "dwReserved0"), py_DNS_RPC_ZONE_INFO_DOTNET_get_dwReserved0, py_DNS_RPC_ZONE_INFO_DOTNET_set_dwReserved0 },
	{ discard_const_p(char, "pszZoneName"), py_DNS_RPC_ZONE_INFO_DOTNET_get_pszZoneName, py_DNS_RPC_ZONE_INFO_DOTNET_set_pszZoneName },
	{ discard_const_p(char, "dwZoneType"), py_DNS_RPC_ZONE_INFO_DOTNET_get_dwZoneType, py_DNS_RPC_ZONE_INFO_DOTNET_set_dwZoneType },
	{ discard_const_p(char, "fReverse"), py_DNS_RPC_ZONE_INFO_DOTNET_get_fReverse, py_DNS_RPC_ZONE_INFO_DOTNET_set_fReverse },
	{ discard_const_p(char, "fAllowUpdate"), py_DNS_RPC_ZONE_INFO_DOTNET_get_fAllowUpdate, py_DNS_RPC_ZONE_INFO_DOTNET_set_fAllowUpdate },
	{ discard_const_p(char, "fPaused"), py_DNS_RPC_ZONE_INFO_DOTNET_get_fPaused, py_DNS_RPC_ZONE_INFO_DOTNET_set_fPaused },
	{ discard_const_p(char, "fShutdown"), py_DNS_RPC_ZONE_INFO_DOTNET_get_fShutdown, py_DNS_RPC_ZONE_INFO_DOTNET_set_fShutdown },
	{ discard_const_p(char, "fAutoCreated"), py_DNS_RPC_ZONE_INFO_DOTNET_get_fAutoCreated, py_DNS_RPC_ZONE_INFO_DOTNET_set_fAutoCreated },
	{ discard_const_p(char, "fUseDatabase"), py_DNS_RPC_ZONE_INFO_DOTNET_get_fUseDatabase, py_DNS_RPC_ZONE_INFO_DOTNET_set_fUseDatabase },
	{ discard_const_p(char, "pszDataFile"), py_DNS_RPC_ZONE_INFO_DOTNET_get_pszDataFile, py_DNS_RPC_ZONE_INFO_DOTNET_set_pszDataFile },
	{ discard_const_p(char, "aipMasters"), py_DNS_RPC_ZONE_INFO_DOTNET_get_aipMasters, py_DNS_RPC_ZONE_INFO_DOTNET_set_aipMasters },
	{ discard_const_p(char, "fSecureSecondaries"), py_DNS_RPC_ZONE_INFO_DOTNET_get_fSecureSecondaries, py_DNS_RPC_ZONE_INFO_DOTNET_set_fSecureSecondaries },
	{ discard_const_p(char, "fNotifyLevel"), py_DNS_RPC_ZONE_INFO_DOTNET_get_fNotifyLevel, py_DNS_RPC_ZONE_INFO_DOTNET_set_fNotifyLevel },
	{ discard_const_p(char, "aipSecondaries"), py_DNS_RPC_ZONE_INFO_DOTNET_get_aipSecondaries, py_DNS_RPC_ZONE_INFO_DOTNET_set_aipSecondaries },
	{ discard_const_p(char, "aipNotify"), py_DNS_RPC_ZONE_INFO_DOTNET_get_aipNotify, py_DNS_RPC_ZONE_INFO_DOTNET_set_aipNotify },
	{ discard_const_p(char, "fUseWins"), py_DNS_RPC_ZONE_INFO_DOTNET_get_fUseWins, py_DNS_RPC_ZONE_INFO_DOTNET_set_fUseWins },
	{ discard_const_p(char, "fUseNbstat"), py_DNS_RPC_ZONE_INFO_DOTNET_get_fUseNbstat, py_DNS_RPC_ZONE_INFO_DOTNET_set_fUseNbstat },
	{ discard_const_p(char, "fAging"), py_DNS_RPC_ZONE_INFO_DOTNET_get_fAging, py_DNS_RPC_ZONE_INFO_DOTNET_set_fAging },
	{ discard_const_p(char, "dwNoRefreshInterval"), py_DNS_RPC_ZONE_INFO_DOTNET_get_dwNoRefreshInterval, py_DNS_RPC_ZONE_INFO_DOTNET_set_dwNoRefreshInterval },
	{ discard_const_p(char, "dwRefreshInterval"), py_DNS_RPC_ZONE_INFO_DOTNET_get_dwRefreshInterval, py_DNS_RPC_ZONE_INFO_DOTNET_set_dwRefreshInterval },
	{ discard_const_p(char, "dwAvailForScavengeTime"), py_DNS_RPC_ZONE_INFO_DOTNET_get_dwAvailForScavengeTime, py_DNS_RPC_ZONE_INFO_DOTNET_set_dwAvailForScavengeTime },
	{ discard_const_p(char, "aipScavengeServers"), py_DNS_RPC_ZONE_INFO_DOTNET_get_aipScavengeServers, py_DNS_RPC_ZONE_INFO_DOTNET_set_aipScavengeServers },
	{ discard_const_p(char, "dwForwarderTimeout"), py_DNS_RPC_ZONE_INFO_DOTNET_get_dwForwarderTimeout, py_DNS_RPC_ZONE_INFO_DOTNET_set_dwForwarderTimeout },
	{ discard_const_p(char, "fForwarderSlave"), py_DNS_RPC_ZONE_INFO_DOTNET_get_fForwarderSlave, py_DNS_RPC_ZONE_INFO_DOTNET_set_fForwarderSlave },
	{ discard_const_p(char, "aipLocalMasters"), py_DNS_RPC_ZONE_INFO_DOTNET_get_aipLocalMasters, py_DNS_RPC_ZONE_INFO_DOTNET_set_aipLocalMasters },
	{ discard_const_p(char, "dwDpFlags"), py_DNS_RPC_ZONE_INFO_DOTNET_get_dwDpFlags, py_DNS_RPC_ZONE_INFO_DOTNET_set_dwDpFlags },
	{ discard_const_p(char, "pszDpFqdn"), py_DNS_RPC_ZONE_INFO_DOTNET_get_pszDpFqdn, py_DNS_RPC_ZONE_INFO_DOTNET_set_pszDpFqdn },
	{ discard_const_p(char, "pwszZoneDn"), py_DNS_RPC_ZONE_INFO_DOTNET_get_pwszZoneDn, py_DNS_RPC_ZONE_INFO_DOTNET_set_pwszZoneDn },
	{ discard_const_p(char, "dwLastSuccessfulSoaCheck"), py_DNS_RPC_ZONE_INFO_DOTNET_get_dwLastSuccessfulSoaCheck, py_DNS_RPC_ZONE_INFO_DOTNET_set_dwLastSuccessfulSoaCheck },
	{ discard_const_p(char, "dwLastSuccessfulXfr"), py_DNS_RPC_ZONE_INFO_DOTNET_get_dwLastSuccessfulXfr, py_DNS_RPC_ZONE_INFO_DOTNET_set_dwLastSuccessfulXfr },
	{ discard_const_p(char, "dwReserved1"), py_DNS_RPC_ZONE_INFO_DOTNET_get_dwReserved1, py_DNS_RPC_ZONE_INFO_DOTNET_set_dwReserved1 },
	{ discard_const_p(char, "dwReserved2"), py_DNS_RPC_ZONE_INFO_DOTNET_get_dwReserved2, py_DNS_RPC_ZONE_INFO_DOTNET_set_dwReserved2 },
	{ discard_const_p(char, "dwReserved3"), py_DNS_RPC_ZONE_INFO_DOTNET_get_dwReserved3, py_DNS_RPC_ZONE_INFO_DOTNET_set_dwReserved3 },
	{ discard_const_p(char, "dwReserved4"), py_DNS_RPC_ZONE_INFO_DOTNET_get_dwReserved4, py_DNS_RPC_ZONE_INFO_DOTNET_set_dwReserved4 },
	{ discard_const_p(char, "dwReserved5"), py_DNS_RPC_ZONE_INFO_DOTNET_get_dwReserved5, py_DNS_RPC_ZONE_INFO_DOTNET_set_dwReserved5 },
	{ discard_const_p(char, "pReserved1"), py_DNS_RPC_ZONE_INFO_DOTNET_get_pReserved1, py_DNS_RPC_ZONE_INFO_DOTNET_set_pReserved1 },
	{ discard_const_p(char, "pReserved2"), py_DNS_RPC_ZONE_INFO_DOTNET_get_pReserved2, py_DNS_RPC_ZONE_INFO_DOTNET_set_pReserved2 },
	{ discard_const_p(char, "pReserved3"), py_DNS_RPC_ZONE_INFO_DOTNET_get_pReserved3, py_DNS_RPC_ZONE_INFO_DOTNET_set_pReserved3 },
	{ discard_const_p(char, "pReserved4"), py_DNS_RPC_ZONE_INFO_DOTNET_get_pReserved4, py_DNS_RPC_ZONE_INFO_DOTNET_set_pReserved4 },
	{ NULL }
};

static PyObject *py_DNS_RPC_ZONE_INFO_DOTNET_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_ZONE_INFO_DOTNET, type);
}


static PyTypeObject DNS_RPC_ZONE_INFO_DOTNET_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.DNS_RPC_ZONE_INFO_DOTNET",
	.tp_getset = py_DNS_RPC_ZONE_INFO_DOTNET_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DNS_RPC_ZONE_INFO_DOTNET_new,
};


static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_dwRpcStructureVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_dwRpcStructureVersion;
	py_dwRpcStructureVersion = PyInt_FromLong(object->dwRpcStructureVersion);
	return py_dwRpcStructureVersion;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_dwRpcStructureVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwRpcStructureVersion = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_dwReserved0(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_dwReserved0;
	py_dwReserved0 = PyInt_FromLong(object->dwReserved0);
	return py_dwReserved0;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_dwReserved0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwReserved0 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_pszZoneName(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_pszZoneName;
	if (object->pszZoneName == NULL) {
		py_pszZoneName = Py_None;
		Py_INCREF(py_pszZoneName);
	} else {
		if (object->pszZoneName == NULL) {
			py_pszZoneName = Py_None;
			Py_INCREF(py_pszZoneName);
		} else {
			py_pszZoneName = PyUnicode_Decode(object->pszZoneName, strlen(object->pszZoneName), "utf-8", "ignore");
		}
	}
	return py_pszZoneName;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_pszZoneName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszZoneName = NULL;
	} else {
		object->pszZoneName = NULL;
		if (PyUnicode_Check(value)) {
			object->pszZoneName = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszZoneName = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_dwZoneType(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_dwZoneType;
	py_dwZoneType = PyInt_FromLong(object->dwZoneType);
	return py_dwZoneType;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_dwZoneType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwZoneType = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_fReverse(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_fReverse;
	py_fReverse = PyInt_FromLong(object->fReverse);
	return py_fReverse;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_fReverse(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fReverse = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_fAllowUpdate(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_fAllowUpdate;
	py_fAllowUpdate = PyInt_FromLong(object->fAllowUpdate);
	return py_fAllowUpdate;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_fAllowUpdate(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->fAllowUpdate = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->fAllowUpdate = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_fPaused(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_fPaused;
	py_fPaused = PyInt_FromLong(object->fPaused);
	return py_fPaused;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_fPaused(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fPaused = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_fShutdown(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_fShutdown;
	py_fShutdown = PyInt_FromLong(object->fShutdown);
	return py_fShutdown;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_fShutdown(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fShutdown = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_fAutoCreated(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_fAutoCreated;
	py_fAutoCreated = PyInt_FromLong(object->fAutoCreated);
	return py_fAutoCreated;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_fAutoCreated(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fAutoCreated = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_fUseDatabase(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_fUseDatabase;
	py_fUseDatabase = PyInt_FromLong(object->fUseDatabase);
	return py_fUseDatabase;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_fUseDatabase(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fUseDatabase = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_pszDataFile(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_pszDataFile;
	if (object->pszDataFile == NULL) {
		py_pszDataFile = Py_None;
		Py_INCREF(py_pszDataFile);
	} else {
		if (object->pszDataFile == NULL) {
			py_pszDataFile = Py_None;
			Py_INCREF(py_pszDataFile);
		} else {
			py_pszDataFile = PyUnicode_Decode(object->pszDataFile, strlen(object->pszDataFile), "utf-8", "ignore");
		}
	}
	return py_pszDataFile;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_pszDataFile(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszDataFile = NULL;
	} else {
		object->pszDataFile = NULL;
		if (PyUnicode_Check(value)) {
			object->pszDataFile = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszDataFile = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_aipMasters(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_aipMasters;
	if (object->aipMasters == NULL) {
		py_aipMasters = Py_None;
		Py_INCREF(py_aipMasters);
	} else {
		py_aipMasters = pytalloc_reference_ex(&DNS_ADDR_ARRAY_Type, object->aipMasters, object->aipMasters);
	}
	return py_aipMasters;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_aipMasters(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->aipMasters);
	if (value == Py_None) {
		object->aipMasters = NULL;
	} else {
		object->aipMasters = NULL;
		PY_CHECK_TYPE(&DNS_ADDR_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipMasters = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_fSecureSecondaries(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_fSecureSecondaries;
	py_fSecureSecondaries = PyInt_FromLong(object->fSecureSecondaries);
	return py_fSecureSecondaries;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_fSecureSecondaries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->fSecureSecondaries = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->fSecureSecondaries = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_fNotifyLevel(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_fNotifyLevel;
	py_fNotifyLevel = PyInt_FromLong(object->fNotifyLevel);
	return py_fNotifyLevel;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_fNotifyLevel(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->fNotifyLevel = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->fNotifyLevel = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_aipSecondaries(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_aipSecondaries;
	if (object->aipSecondaries == NULL) {
		py_aipSecondaries = Py_None;
		Py_INCREF(py_aipSecondaries);
	} else {
		py_aipSecondaries = pytalloc_reference_ex(&DNS_ADDR_ARRAY_Type, object->aipSecondaries, object->aipSecondaries);
	}
	return py_aipSecondaries;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_aipSecondaries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->aipSecondaries);
	if (value == Py_None) {
		object->aipSecondaries = NULL;
	} else {
		object->aipSecondaries = NULL;
		PY_CHECK_TYPE(&DNS_ADDR_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipSecondaries = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_aipNotify(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_aipNotify;
	if (object->aipNotify == NULL) {
		py_aipNotify = Py_None;
		Py_INCREF(py_aipNotify);
	} else {
		py_aipNotify = pytalloc_reference_ex(&DNS_ADDR_ARRAY_Type, object->aipNotify, object->aipNotify);
	}
	return py_aipNotify;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_aipNotify(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->aipNotify);
	if (value == Py_None) {
		object->aipNotify = NULL;
	} else {
		object->aipNotify = NULL;
		PY_CHECK_TYPE(&DNS_ADDR_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipNotify = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_fUseWins(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_fUseWins;
	py_fUseWins = PyInt_FromLong(object->fUseWins);
	return py_fUseWins;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_fUseWins(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fUseWins = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_fUseNbstat(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_fUseNbstat;
	py_fUseNbstat = PyInt_FromLong(object->fUseNbstat);
	return py_fUseNbstat;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_fUseNbstat(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fUseNbstat = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_fAging(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_fAging;
	py_fAging = PyInt_FromLong(object->fAging);
	return py_fAging;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_fAging(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fAging = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_dwNoRefreshInterval(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_dwNoRefreshInterval;
	py_dwNoRefreshInterval = PyInt_FromLong(object->dwNoRefreshInterval);
	return py_dwNoRefreshInterval;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_dwNoRefreshInterval(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwNoRefreshInterval = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_dwRefreshInterval(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_dwRefreshInterval;
	py_dwRefreshInterval = PyInt_FromLong(object->dwRefreshInterval);
	return py_dwRefreshInterval;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_dwRefreshInterval(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwRefreshInterval = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_dwAvailForScavengeTime(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_dwAvailForScavengeTime;
	py_dwAvailForScavengeTime = PyInt_FromLong(object->dwAvailForScavengeTime);
	return py_dwAvailForScavengeTime;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_dwAvailForScavengeTime(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwAvailForScavengeTime = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_aipScavengeServers(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_aipScavengeServers;
	if (object->aipScavengeServers == NULL) {
		py_aipScavengeServers = Py_None;
		Py_INCREF(py_aipScavengeServers);
	} else {
		py_aipScavengeServers = pytalloc_reference_ex(&DNS_ADDR_ARRAY_Type, object->aipScavengeServers, object->aipScavengeServers);
	}
	return py_aipScavengeServers;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_aipScavengeServers(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->aipScavengeServers);
	if (value == Py_None) {
		object->aipScavengeServers = NULL;
	} else {
		object->aipScavengeServers = NULL;
		PY_CHECK_TYPE(&DNS_ADDR_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipScavengeServers = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_dwForwarderTimeout(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_dwForwarderTimeout;
	py_dwForwarderTimeout = PyInt_FromLong(object->dwForwarderTimeout);
	return py_dwForwarderTimeout;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_dwForwarderTimeout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwForwarderTimeout = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_fForwarderSlave(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_fForwarderSlave;
	py_fForwarderSlave = PyInt_FromLong(object->fForwarderSlave);
	return py_fForwarderSlave;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_fForwarderSlave(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fForwarderSlave = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_aipLocalMasters(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_aipLocalMasters;
	if (object->aipLocalMasters == NULL) {
		py_aipLocalMasters = Py_None;
		Py_INCREF(py_aipLocalMasters);
	} else {
		py_aipLocalMasters = pytalloc_reference_ex(&DNS_ADDR_ARRAY_Type, object->aipLocalMasters, object->aipLocalMasters);
	}
	return py_aipLocalMasters;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_aipLocalMasters(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->aipLocalMasters);
	if (value == Py_None) {
		object->aipLocalMasters = NULL;
	} else {
		object->aipLocalMasters = NULL;
		PY_CHECK_TYPE(&DNS_ADDR_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipLocalMasters = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_dwDpFlags(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_dwDpFlags;
	py_dwDpFlags = PyInt_FromLong(object->dwDpFlags);
	return py_dwDpFlags;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_dwDpFlags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwDpFlags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_pszDpFqdn(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_pszDpFqdn;
	if (object->pszDpFqdn == NULL) {
		py_pszDpFqdn = Py_None;
		Py_INCREF(py_pszDpFqdn);
	} else {
		if (object->pszDpFqdn == NULL) {
			py_pszDpFqdn = Py_None;
			Py_INCREF(py_pszDpFqdn);
		} else {
			py_pszDpFqdn = PyUnicode_Decode(object->pszDpFqdn, strlen(object->pszDpFqdn), "utf-8", "ignore");
		}
	}
	return py_pszDpFqdn;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_pszDpFqdn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszDpFqdn = NULL;
	} else {
		object->pszDpFqdn = NULL;
		if (PyUnicode_Check(value)) {
			object->pszDpFqdn = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszDpFqdn = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_pwszZoneDn(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_pwszZoneDn;
	if (object->pwszZoneDn == NULL) {
		py_pwszZoneDn = Py_None;
		Py_INCREF(py_pwszZoneDn);
	} else {
		if (object->pwszZoneDn == NULL) {
			py_pwszZoneDn = Py_None;
			Py_INCREF(py_pwszZoneDn);
		} else {
			py_pwszZoneDn = PyUnicode_Decode(object->pwszZoneDn, strlen(object->pwszZoneDn), "utf-8", "ignore");
		}
	}
	return py_pwszZoneDn;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_pwszZoneDn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pwszZoneDn = NULL;
	} else {
		object->pwszZoneDn = NULL;
		if (PyUnicode_Check(value)) {
			object->pwszZoneDn = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pwszZoneDn = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_dwLastSuccessfulSoaCheck(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_dwLastSuccessfulSoaCheck;
	py_dwLastSuccessfulSoaCheck = PyInt_FromLong(object->dwLastSuccessfulSoaCheck);
	return py_dwLastSuccessfulSoaCheck;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_dwLastSuccessfulSoaCheck(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwLastSuccessfulSoaCheck = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_dwLastSuccessfulXfr(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_dwLastSuccessfulXfr;
	py_dwLastSuccessfulXfr = PyInt_FromLong(object->dwLastSuccessfulXfr);
	return py_dwLastSuccessfulXfr;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_dwLastSuccessfulXfr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwLastSuccessfulXfr = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_fQueuedForBackgroundLoad(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_fQueuedForBackgroundLoad;
	py_fQueuedForBackgroundLoad = PyInt_FromLong(object->fQueuedForBackgroundLoad);
	return py_fQueuedForBackgroundLoad;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_fQueuedForBackgroundLoad(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fQueuedForBackgroundLoad = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_fBackgroundLoadInProgress(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_fBackgroundLoadInProgress;
	py_fBackgroundLoadInProgress = PyInt_FromLong(object->fBackgroundLoadInProgress);
	return py_fBackgroundLoadInProgress;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_fBackgroundLoadInProgress(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fBackgroundLoadInProgress = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_fReadOnlyZone(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_fReadOnlyZone;
	py_fReadOnlyZone = PyInt_FromLong(object->fReadOnlyZone);
	return py_fReadOnlyZone;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_fReadOnlyZone(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fReadOnlyZone = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_dwLastXfrAttempt(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_dwLastXfrAttempt;
	py_dwLastXfrAttempt = PyInt_FromLong(object->dwLastXfrAttempt);
	return py_dwLastXfrAttempt;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_dwLastXfrAttempt(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwLastXfrAttempt = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_get_dwLastXfrResult(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_dwLastXfrResult;
	py_dwLastXfrResult = PyInt_FromLong(object->dwLastXfrResult);
	return py_dwLastXfrResult;
}

static int py_DNS_RPC_ZONE_INFO_LONGHORN_set_dwLastXfrResult(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwLastXfrResult = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_DNS_RPC_ZONE_INFO_LONGHORN_getsetters[] = {
	{ discard_const_p(char, "dwRpcStructureVersion"), py_DNS_RPC_ZONE_INFO_LONGHORN_get_dwRpcStructureVersion, py_DNS_RPC_ZONE_INFO_LONGHORN_set_dwRpcStructureVersion },
	{ discard_const_p(char, "dwReserved0"), py_DNS_RPC_ZONE_INFO_LONGHORN_get_dwReserved0, py_DNS_RPC_ZONE_INFO_LONGHORN_set_dwReserved0 },
	{ discard_const_p(char, "pszZoneName"), py_DNS_RPC_ZONE_INFO_LONGHORN_get_pszZoneName, py_DNS_RPC_ZONE_INFO_LONGHORN_set_pszZoneName },
	{ discard_const_p(char, "dwZoneType"), py_DNS_RPC_ZONE_INFO_LONGHORN_get_dwZoneType, py_DNS_RPC_ZONE_INFO_LONGHORN_set_dwZoneType },
	{ discard_const_p(char, "fReverse"), py_DNS_RPC_ZONE_INFO_LONGHORN_get_fReverse, py_DNS_RPC_ZONE_INFO_LONGHORN_set_fReverse },
	{ discard_const_p(char, "fAllowUpdate"), py_DNS_RPC_ZONE_INFO_LONGHORN_get_fAllowUpdate, py_DNS_RPC_ZONE_INFO_LONGHORN_set_fAllowUpdate },
	{ discard_const_p(char, "fPaused"), py_DNS_RPC_ZONE_INFO_LONGHORN_get_fPaused, py_DNS_RPC_ZONE_INFO_LONGHORN_set_fPaused },
	{ discard_const_p(char, "fShutdown"), py_DNS_RPC_ZONE_INFO_LONGHORN_get_fShutdown, py_DNS_RPC_ZONE_INFO_LONGHORN_set_fShutdown },
	{ discard_const_p(char, "fAutoCreated"), py_DNS_RPC_ZONE_INFO_LONGHORN_get_fAutoCreated, py_DNS_RPC_ZONE_INFO_LONGHORN_set_fAutoCreated },
	{ discard_const_p(char, "fUseDatabase"), py_DNS_RPC_ZONE_INFO_LONGHORN_get_fUseDatabase, py_DNS_RPC_ZONE_INFO_LONGHORN_set_fUseDatabase },
	{ discard_const_p(char, "pszDataFile"), py_DNS_RPC_ZONE_INFO_LONGHORN_get_pszDataFile, py_DNS_RPC_ZONE_INFO_LONGHORN_set_pszDataFile },
	{ discard_const_p(char, "aipMasters"), py_DNS_RPC_ZONE_INFO_LONGHORN_get_aipMasters, py_DNS_RPC_ZONE_INFO_LONGHORN_set_aipMasters },
	{ discard_const_p(char, "fSecureSecondaries"), py_DNS_RPC_ZONE_INFO_LONGHORN_get_fSecureSecondaries, py_DNS_RPC_ZONE_INFO_LONGHORN_set_fSecureSecondaries },
	{ discard_const_p(char, "fNotifyLevel"), py_DNS_RPC_ZONE_INFO_LONGHORN_get_fNotifyLevel, py_DNS_RPC_ZONE_INFO_LONGHORN_set_fNotifyLevel },
	{ discard_const_p(char, "aipSecondaries"), py_DNS_RPC_ZONE_INFO_LONGHORN_get_aipSecondaries, py_DNS_RPC_ZONE_INFO_LONGHORN_set_aipSecondaries },
	{ discard_const_p(char, "aipNotify"), py_DNS_RPC_ZONE_INFO_LONGHORN_get_aipNotify, py_DNS_RPC_ZONE_INFO_LONGHORN_set_aipNotify },
	{ discard_const_p(char, "fUseWins"), py_DNS_RPC_ZONE_INFO_LONGHORN_get_fUseWins, py_DNS_RPC_ZONE_INFO_LONGHORN_set_fUseWins },
	{ discard_const_p(char, "fUseNbstat"), py_DNS_RPC_ZONE_INFO_LONGHORN_get_fUseNbstat, py_DNS_RPC_ZONE_INFO_LONGHORN_set_fUseNbstat },
	{ discard_const_p(char, "fAging"), py_DNS_RPC_ZONE_INFO_LONGHORN_get_fAging, py_DNS_RPC_ZONE_INFO_LONGHORN_set_fAging },
	{ discard_const_p(char, "dwNoRefreshInterval"), py_DNS_RPC_ZONE_INFO_LONGHORN_get_dwNoRefreshInterval, py_DNS_RPC_ZONE_INFO_LONGHORN_set_dwNoRefreshInterval },
	{ discard_const_p(char, "dwRefreshInterval"), py_DNS_RPC_ZONE_INFO_LONGHORN_get_dwRefreshInterval, py_DNS_RPC_ZONE_INFO_LONGHORN_set_dwRefreshInterval },
	{ discard_const_p(char, "dwAvailForScavengeTime"), py_DNS_RPC_ZONE_INFO_LONGHORN_get_dwAvailForScavengeTime, py_DNS_RPC_ZONE_INFO_LONGHORN_set_dwAvailForScavengeTime },
	{ discard_const_p(char, "aipScavengeServers"), py_DNS_RPC_ZONE_INFO_LONGHORN_get_aipScavengeServers, py_DNS_RPC_ZONE_INFO_LONGHORN_set_aipScavengeServers },
	{ discard_const_p(char, "dwForwarderTimeout"), py_DNS_RPC_ZONE_INFO_LONGHORN_get_dwForwarderTimeout, py_DNS_RPC_ZONE_INFO_LONGHORN_set_dwForwarderTimeout },
	{ discard_const_p(char, "fForwarderSlave"), py_DNS_RPC_ZONE_INFO_LONGHORN_get_fForwarderSlave, py_DNS_RPC_ZONE_INFO_LONGHORN_set_fForwarderSlave },
	{ discard_const_p(char, "aipLocalMasters"), py_DNS_RPC_ZONE_INFO_LONGHORN_get_aipLocalMasters, py_DNS_RPC_ZONE_INFO_LONGHORN_set_aipLocalMasters },
	{ discard_const_p(char, "dwDpFlags"), py_DNS_RPC_ZONE_INFO_LONGHORN_get_dwDpFlags, py_DNS_RPC_ZONE_INFO_LONGHORN_set_dwDpFlags },
	{ discard_const_p(char, "pszDpFqdn"), py_DNS_RPC_ZONE_INFO_LONGHORN_get_pszDpFqdn, py_DNS_RPC_ZONE_INFO_LONGHORN_set_pszDpFqdn },
	{ discard_const_p(char, "pwszZoneDn"), py_DNS_RPC_ZONE_INFO_LONGHORN_get_pwszZoneDn, py_DNS_RPC_ZONE_INFO_LONGHORN_set_pwszZoneDn },
	{ discard_const_p(char, "dwLastSuccessfulSoaCheck"), py_DNS_RPC_ZONE_INFO_LONGHORN_get_dwLastSuccessfulSoaCheck, py_DNS_RPC_ZONE_INFO_LONGHORN_set_dwLastSuccessfulSoaCheck },
	{ discard_const_p(char, "dwLastSuccessfulXfr"), py_DNS_RPC_ZONE_INFO_LONGHORN_get_dwLastSuccessfulXfr, py_DNS_RPC_ZONE_INFO_LONGHORN_set_dwLastSuccessfulXfr },
	{ discard_const_p(char, "fQueuedForBackgroundLoad"), py_DNS_RPC_ZONE_INFO_LONGHORN_get_fQueuedForBackgroundLoad, py_DNS_RPC_ZONE_INFO_LONGHORN_set_fQueuedForBackgroundLoad },
	{ discard_const_p(char, "fBackgroundLoadInProgress"), py_DNS_RPC_ZONE_INFO_LONGHORN_get_fBackgroundLoadInProgress, py_DNS_RPC_ZONE_INFO_LONGHORN_set_fBackgroundLoadInProgress },
	{ discard_const_p(char, "fReadOnlyZone"), py_DNS_RPC_ZONE_INFO_LONGHORN_get_fReadOnlyZone, py_DNS_RPC_ZONE_INFO_LONGHORN_set_fReadOnlyZone },
	{ discard_const_p(char, "dwLastXfrAttempt"), py_DNS_RPC_ZONE_INFO_LONGHORN_get_dwLastXfrAttempt, py_DNS_RPC_ZONE_INFO_LONGHORN_set_dwLastXfrAttempt },
	{ discard_const_p(char, "dwLastXfrResult"), py_DNS_RPC_ZONE_INFO_LONGHORN_get_dwLastXfrResult, py_DNS_RPC_ZONE_INFO_LONGHORN_set_dwLastXfrResult },
	{ NULL }
};

static PyObject *py_DNS_RPC_ZONE_INFO_LONGHORN_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_ZONE_INFO_LONGHORN, type);
}


static PyTypeObject DNS_RPC_ZONE_INFO_LONGHORN_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.DNS_RPC_ZONE_INFO_LONGHORN",
	.tp_getset = py_DNS_RPC_ZONE_INFO_LONGHORN_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DNS_RPC_ZONE_INFO_LONGHORN_new,
};


static PyObject *py_DNS_RPC_ZONE_SECONDARIES_W2K_get_fSecureSecondaries(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_W2K *object = (struct DNS_RPC_ZONE_SECONDARIES_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_fSecureSecondaries;
	py_fSecureSecondaries = PyInt_FromLong(object->fSecureSecondaries);
	return py_fSecureSecondaries;
}

static int py_DNS_RPC_ZONE_SECONDARIES_W2K_set_fSecureSecondaries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_W2K *object = (struct DNS_RPC_ZONE_SECONDARIES_W2K *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->fSecureSecondaries = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->fSecureSecondaries = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_SECONDARIES_W2K_get_fNotifyLevel(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_W2K *object = (struct DNS_RPC_ZONE_SECONDARIES_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_fNotifyLevel;
	py_fNotifyLevel = PyInt_FromLong(object->fNotifyLevel);
	return py_fNotifyLevel;
}

static int py_DNS_RPC_ZONE_SECONDARIES_W2K_set_fNotifyLevel(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_W2K *object = (struct DNS_RPC_ZONE_SECONDARIES_W2K *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->fNotifyLevel = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->fNotifyLevel = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_SECONDARIES_W2K_get_aipSecondaries(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_W2K *object = (struct DNS_RPC_ZONE_SECONDARIES_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_aipSecondaries;
	if (object->aipSecondaries == NULL) {
		py_aipSecondaries = Py_None;
		Py_INCREF(py_aipSecondaries);
	} else {
		py_aipSecondaries = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipSecondaries, object->aipSecondaries);
	}
	return py_aipSecondaries;
}

static int py_DNS_RPC_ZONE_SECONDARIES_W2K_set_aipSecondaries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_W2K *object = (struct DNS_RPC_ZONE_SECONDARIES_W2K *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->aipSecondaries);
	if (value == Py_None) {
		object->aipSecondaries = NULL;
	} else {
		object->aipSecondaries = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipSecondaries = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_SECONDARIES_W2K_get_aipNotify(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_W2K *object = (struct DNS_RPC_ZONE_SECONDARIES_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_aipNotify;
	if (object->aipNotify == NULL) {
		py_aipNotify = Py_None;
		Py_INCREF(py_aipNotify);
	} else {
		py_aipNotify = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipNotify, object->aipNotify);
	}
	return py_aipNotify;
}

static int py_DNS_RPC_ZONE_SECONDARIES_W2K_set_aipNotify(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_W2K *object = (struct DNS_RPC_ZONE_SECONDARIES_W2K *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->aipNotify);
	if (value == Py_None) {
		object->aipNotify = NULL;
	} else {
		object->aipNotify = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipNotify = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_ZONE_SECONDARIES_W2K_getsetters[] = {
	{ discard_const_p(char, "fSecureSecondaries"), py_DNS_RPC_ZONE_SECONDARIES_W2K_get_fSecureSecondaries, py_DNS_RPC_ZONE_SECONDARIES_W2K_set_fSecureSecondaries },
	{ discard_const_p(char, "fNotifyLevel"), py_DNS_RPC_ZONE_SECONDARIES_W2K_get_fNotifyLevel, py_DNS_RPC_ZONE_SECONDARIES_W2K_set_fNotifyLevel },
	{ discard_const_p(char, "aipSecondaries"), py_DNS_RPC_ZONE_SECONDARIES_W2K_get_aipSecondaries, py_DNS_RPC_ZONE_SECONDARIES_W2K_set_aipSecondaries },
	{ discard_const_p(char, "aipNotify"), py_DNS_RPC_ZONE_SECONDARIES_W2K_get_aipNotify, py_DNS_RPC_ZONE_SECONDARIES_W2K_set_aipNotify },
	{ NULL }
};

static PyObject *py_DNS_RPC_ZONE_SECONDARIES_W2K_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_ZONE_SECONDARIES_W2K, type);
}


static PyTypeObject DNS_RPC_ZONE_SECONDARIES_W2K_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.DNS_RPC_ZONE_SECONDARIES_W2K",
	.tp_getset = py_DNS_RPC_ZONE_SECONDARIES_W2K_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DNS_RPC_ZONE_SECONDARIES_W2K_new,
};


static PyObject *py_DNS_RPC_ZONE_SECONDARIES_DOTNET_get_dwRpcStructureVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_DOTNET *object = (struct DNS_RPC_ZONE_SECONDARIES_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwRpcStructureVersion;
	py_dwRpcStructureVersion = PyInt_FromLong(object->dwRpcStructureVersion);
	return py_dwRpcStructureVersion;
}

static int py_DNS_RPC_ZONE_SECONDARIES_DOTNET_set_dwRpcStructureVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_DOTNET *object = (struct DNS_RPC_ZONE_SECONDARIES_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwRpcStructureVersion = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_SECONDARIES_DOTNET_get_dwReserved0(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_DOTNET *object = (struct DNS_RPC_ZONE_SECONDARIES_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwReserved0;
	py_dwReserved0 = PyInt_FromLong(object->dwReserved0);
	return py_dwReserved0;
}

static int py_DNS_RPC_ZONE_SECONDARIES_DOTNET_set_dwReserved0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_DOTNET *object = (struct DNS_RPC_ZONE_SECONDARIES_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwReserved0 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_SECONDARIES_DOTNET_get_fSecureSecondaries(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_DOTNET *object = (struct DNS_RPC_ZONE_SECONDARIES_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_fSecureSecondaries;
	py_fSecureSecondaries = PyInt_FromLong(object->fSecureSecondaries);
	return py_fSecureSecondaries;
}

static int py_DNS_RPC_ZONE_SECONDARIES_DOTNET_set_fSecureSecondaries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_DOTNET *object = (struct DNS_RPC_ZONE_SECONDARIES_DOTNET *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->fSecureSecondaries = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->fSecureSecondaries = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_SECONDARIES_DOTNET_get_fNotifyLevel(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_DOTNET *object = (struct DNS_RPC_ZONE_SECONDARIES_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_fNotifyLevel;
	py_fNotifyLevel = PyInt_FromLong(object->fNotifyLevel);
	return py_fNotifyLevel;
}

static int py_DNS_RPC_ZONE_SECONDARIES_DOTNET_set_fNotifyLevel(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_DOTNET *object = (struct DNS_RPC_ZONE_SECONDARIES_DOTNET *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->fNotifyLevel = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->fNotifyLevel = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_SECONDARIES_DOTNET_get_aipSecondaries(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_DOTNET *object = (struct DNS_RPC_ZONE_SECONDARIES_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_aipSecondaries;
	if (object->aipSecondaries == NULL) {
		py_aipSecondaries = Py_None;
		Py_INCREF(py_aipSecondaries);
	} else {
		py_aipSecondaries = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipSecondaries, object->aipSecondaries);
	}
	return py_aipSecondaries;
}

static int py_DNS_RPC_ZONE_SECONDARIES_DOTNET_set_aipSecondaries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_DOTNET *object = (struct DNS_RPC_ZONE_SECONDARIES_DOTNET *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->aipSecondaries);
	if (value == Py_None) {
		object->aipSecondaries = NULL;
	} else {
		object->aipSecondaries = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipSecondaries = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_SECONDARIES_DOTNET_get_aipNotify(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_DOTNET *object = (struct DNS_RPC_ZONE_SECONDARIES_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_aipNotify;
	if (object->aipNotify == NULL) {
		py_aipNotify = Py_None;
		Py_INCREF(py_aipNotify);
	} else {
		py_aipNotify = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipNotify, object->aipNotify);
	}
	return py_aipNotify;
}

static int py_DNS_RPC_ZONE_SECONDARIES_DOTNET_set_aipNotify(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_DOTNET *object = (struct DNS_RPC_ZONE_SECONDARIES_DOTNET *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->aipNotify);
	if (value == Py_None) {
		object->aipNotify = NULL;
	} else {
		object->aipNotify = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipNotify = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_ZONE_SECONDARIES_DOTNET_getsetters[] = {
	{ discard_const_p(char, "dwRpcStructureVersion"), py_DNS_RPC_ZONE_SECONDARIES_DOTNET_get_dwRpcStructureVersion, py_DNS_RPC_ZONE_SECONDARIES_DOTNET_set_dwRpcStructureVersion },
	{ discard_const_p(char, "dwReserved0"), py_DNS_RPC_ZONE_SECONDARIES_DOTNET_get_dwReserved0, py_DNS_RPC_ZONE_SECONDARIES_DOTNET_set_dwReserved0 },
	{ discard_const_p(char, "fSecureSecondaries"), py_DNS_RPC_ZONE_SECONDARIES_DOTNET_get_fSecureSecondaries, py_DNS_RPC_ZONE_SECONDARIES_DOTNET_set_fSecureSecondaries },
	{ discard_const_p(char, "fNotifyLevel"), py_DNS_RPC_ZONE_SECONDARIES_DOTNET_get_fNotifyLevel, py_DNS_RPC_ZONE_SECONDARIES_DOTNET_set_fNotifyLevel },
	{ discard_const_p(char, "aipSecondaries"), py_DNS_RPC_ZONE_SECONDARIES_DOTNET_get_aipSecondaries, py_DNS_RPC_ZONE_SECONDARIES_DOTNET_set_aipSecondaries },
	{ discard_const_p(char, "aipNotify"), py_DNS_RPC_ZONE_SECONDARIES_DOTNET_get_aipNotify, py_DNS_RPC_ZONE_SECONDARIES_DOTNET_set_aipNotify },
	{ NULL }
};

static PyObject *py_DNS_RPC_ZONE_SECONDARIES_DOTNET_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_ZONE_SECONDARIES_DOTNET, type);
}


static PyTypeObject DNS_RPC_ZONE_SECONDARIES_DOTNET_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.DNS_RPC_ZONE_SECONDARIES_DOTNET",
	.tp_getset = py_DNS_RPC_ZONE_SECONDARIES_DOTNET_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DNS_RPC_ZONE_SECONDARIES_DOTNET_new,
};


static PyObject *py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_get_dwRpcStructureVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_LONGHORN *object = (struct DNS_RPC_ZONE_SECONDARIES_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_dwRpcStructureVersion;
	py_dwRpcStructureVersion = PyInt_FromLong(object->dwRpcStructureVersion);
	return py_dwRpcStructureVersion;
}

static int py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_set_dwRpcStructureVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_LONGHORN *object = (struct DNS_RPC_ZONE_SECONDARIES_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwRpcStructureVersion = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_get_dwReserved0(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_LONGHORN *object = (struct DNS_RPC_ZONE_SECONDARIES_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_dwReserved0;
	py_dwReserved0 = PyInt_FromLong(object->dwReserved0);
	return py_dwReserved0;
}

static int py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_set_dwReserved0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_LONGHORN *object = (struct DNS_RPC_ZONE_SECONDARIES_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwReserved0 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_get_fSecureSecondaries(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_LONGHORN *object = (struct DNS_RPC_ZONE_SECONDARIES_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_fSecureSecondaries;
	py_fSecureSecondaries = PyInt_FromLong(object->fSecureSecondaries);
	return py_fSecureSecondaries;
}

static int py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_set_fSecureSecondaries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_LONGHORN *object = (struct DNS_RPC_ZONE_SECONDARIES_LONGHORN *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->fSecureSecondaries = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->fSecureSecondaries = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_get_fNotifyLevel(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_LONGHORN *object = (struct DNS_RPC_ZONE_SECONDARIES_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_fNotifyLevel;
	py_fNotifyLevel = PyInt_FromLong(object->fNotifyLevel);
	return py_fNotifyLevel;
}

static int py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_set_fNotifyLevel(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_LONGHORN *object = (struct DNS_RPC_ZONE_SECONDARIES_LONGHORN *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->fNotifyLevel = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->fNotifyLevel = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_get_aipSecondaries(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_LONGHORN *object = (struct DNS_RPC_ZONE_SECONDARIES_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_aipSecondaries;
	if (object->aipSecondaries == NULL) {
		py_aipSecondaries = Py_None;
		Py_INCREF(py_aipSecondaries);
	} else {
		py_aipSecondaries = pytalloc_reference_ex(&DNS_ADDR_ARRAY_Type, object->aipSecondaries, object->aipSecondaries);
	}
	return py_aipSecondaries;
}

static int py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_set_aipSecondaries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_LONGHORN *object = (struct DNS_RPC_ZONE_SECONDARIES_LONGHORN *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->aipSecondaries);
	if (value == Py_None) {
		object->aipSecondaries = NULL;
	} else {
		object->aipSecondaries = NULL;
		PY_CHECK_TYPE(&DNS_ADDR_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipSecondaries = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_get_aipNotify(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_LONGHORN *object = (struct DNS_RPC_ZONE_SECONDARIES_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_aipNotify;
	if (object->aipNotify == NULL) {
		py_aipNotify = Py_None;
		Py_INCREF(py_aipNotify);
	} else {
		py_aipNotify = pytalloc_reference_ex(&DNS_ADDR_ARRAY_Type, object->aipNotify, object->aipNotify);
	}
	return py_aipNotify;
}

static int py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_set_aipNotify(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_SECONDARIES_LONGHORN *object = (struct DNS_RPC_ZONE_SECONDARIES_LONGHORN *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->aipNotify);
	if (value == Py_None) {
		object->aipNotify = NULL;
	} else {
		object->aipNotify = NULL;
		PY_CHECK_TYPE(&DNS_ADDR_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipNotify = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_getsetters[] = {
	{ discard_const_p(char, "dwRpcStructureVersion"), py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_get_dwRpcStructureVersion, py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_set_dwRpcStructureVersion },
	{ discard_const_p(char, "dwReserved0"), py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_get_dwReserved0, py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_set_dwReserved0 },
	{ discard_const_p(char, "fSecureSecondaries"), py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_get_fSecureSecondaries, py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_set_fSecureSecondaries },
	{ discard_const_p(char, "fNotifyLevel"), py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_get_fNotifyLevel, py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_set_fNotifyLevel },
	{ discard_const_p(char, "aipSecondaries"), py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_get_aipSecondaries, py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_set_aipSecondaries },
	{ discard_const_p(char, "aipNotify"), py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_get_aipNotify, py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_set_aipNotify },
	{ NULL }
};

static PyObject *py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_ZONE_SECONDARIES_LONGHORN, type);
}


static PyTypeObject DNS_RPC_ZONE_SECONDARIES_LONGHORN_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.DNS_RPC_ZONE_SECONDARIES_LONGHORN",
	.tp_getset = py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DNS_RPC_ZONE_SECONDARIES_LONGHORN_new,
};


static PyObject *py_DNS_RPC_ZONE_DATABASE_W2K_get_fDsIntegrated(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_DATABASE_W2K *object = (struct DNS_RPC_ZONE_DATABASE_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_fDsIntegrated;
	py_fDsIntegrated = PyInt_FromLong(object->fDsIntegrated);
	return py_fDsIntegrated;
}

static int py_DNS_RPC_ZONE_DATABASE_W2K_set_fDsIntegrated(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_DATABASE_W2K *object = (struct DNS_RPC_ZONE_DATABASE_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fDsIntegrated = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_DATABASE_W2K_get_pszFileName(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_DATABASE_W2K *object = (struct DNS_RPC_ZONE_DATABASE_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_pszFileName;
	if (object->pszFileName == NULL) {
		py_pszFileName = Py_None;
		Py_INCREF(py_pszFileName);
	} else {
		if (object->pszFileName == NULL) {
			py_pszFileName = Py_None;
			Py_INCREF(py_pszFileName);
		} else {
			py_pszFileName = PyUnicode_Decode(object->pszFileName, strlen(object->pszFileName), "utf-8", "ignore");
		}
	}
	return py_pszFileName;
}

static int py_DNS_RPC_ZONE_DATABASE_W2K_set_pszFileName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_DATABASE_W2K *object = (struct DNS_RPC_ZONE_DATABASE_W2K *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszFileName = NULL;
	} else {
		object->pszFileName = NULL;
		if (PyUnicode_Check(value)) {
			object->pszFileName = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszFileName = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_ZONE_DATABASE_W2K_getsetters[] = {
	{ discard_const_p(char, "fDsIntegrated"), py_DNS_RPC_ZONE_DATABASE_W2K_get_fDsIntegrated, py_DNS_RPC_ZONE_DATABASE_W2K_set_fDsIntegrated },
	{ discard_const_p(char, "pszFileName"), py_DNS_RPC_ZONE_DATABASE_W2K_get_pszFileName, py_DNS_RPC_ZONE_DATABASE_W2K_set_pszFileName },
	{ NULL }
};

static PyObject *py_DNS_RPC_ZONE_DATABASE_W2K_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_ZONE_DATABASE_W2K, type);
}


static PyTypeObject DNS_RPC_ZONE_DATABASE_W2K_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.DNS_RPC_ZONE_DATABASE_W2K",
	.tp_getset = py_DNS_RPC_ZONE_DATABASE_W2K_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DNS_RPC_ZONE_DATABASE_W2K_new,
};


static PyObject *py_DNS_RPC_ZONE_DATABASE_DOTNET_get_dwRpcStructureVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_DATABASE_DOTNET *object = (struct DNS_RPC_ZONE_DATABASE_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwRpcStructureVersion;
	py_dwRpcStructureVersion = PyInt_FromLong(object->dwRpcStructureVersion);
	return py_dwRpcStructureVersion;
}

static int py_DNS_RPC_ZONE_DATABASE_DOTNET_set_dwRpcStructureVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_DATABASE_DOTNET *object = (struct DNS_RPC_ZONE_DATABASE_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwRpcStructureVersion = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_DATABASE_DOTNET_get_dwReserved0(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_DATABASE_DOTNET *object = (struct DNS_RPC_ZONE_DATABASE_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwReserved0;
	py_dwReserved0 = PyInt_FromLong(object->dwReserved0);
	return py_dwReserved0;
}

static int py_DNS_RPC_ZONE_DATABASE_DOTNET_set_dwReserved0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_DATABASE_DOTNET *object = (struct DNS_RPC_ZONE_DATABASE_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwReserved0 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_DATABASE_DOTNET_get_fDsIntegrated(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_DATABASE_DOTNET *object = (struct DNS_RPC_ZONE_DATABASE_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_fDsIntegrated;
	py_fDsIntegrated = PyInt_FromLong(object->fDsIntegrated);
	return py_fDsIntegrated;
}

static int py_DNS_RPC_ZONE_DATABASE_DOTNET_set_fDsIntegrated(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_DATABASE_DOTNET *object = (struct DNS_RPC_ZONE_DATABASE_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fDsIntegrated = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_DATABASE_DOTNET_get_pszFileName(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_DATABASE_DOTNET *object = (struct DNS_RPC_ZONE_DATABASE_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_pszFileName;
	if (object->pszFileName == NULL) {
		py_pszFileName = Py_None;
		Py_INCREF(py_pszFileName);
	} else {
		if (object->pszFileName == NULL) {
			py_pszFileName = Py_None;
			Py_INCREF(py_pszFileName);
		} else {
			py_pszFileName = PyUnicode_Decode(object->pszFileName, strlen(object->pszFileName), "utf-8", "ignore");
		}
	}
	return py_pszFileName;
}

static int py_DNS_RPC_ZONE_DATABASE_DOTNET_set_pszFileName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_DATABASE_DOTNET *object = (struct DNS_RPC_ZONE_DATABASE_DOTNET *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszFileName = NULL;
	} else {
		object->pszFileName = NULL;
		if (PyUnicode_Check(value)) {
			object->pszFileName = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszFileName = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_ZONE_DATABASE_DOTNET_getsetters[] = {
	{ discard_const_p(char, "dwRpcStructureVersion"), py_DNS_RPC_ZONE_DATABASE_DOTNET_get_dwRpcStructureVersion, py_DNS_RPC_ZONE_DATABASE_DOTNET_set_dwRpcStructureVersion },
	{ discard_const_p(char, "dwReserved0"), py_DNS_RPC_ZONE_DATABASE_DOTNET_get_dwReserved0, py_DNS_RPC_ZONE_DATABASE_DOTNET_set_dwReserved0 },
	{ discard_const_p(char, "fDsIntegrated"), py_DNS_RPC_ZONE_DATABASE_DOTNET_get_fDsIntegrated, py_DNS_RPC_ZONE_DATABASE_DOTNET_set_fDsIntegrated },
	{ discard_const_p(char, "pszFileName"), py_DNS_RPC_ZONE_DATABASE_DOTNET_get_pszFileName, py_DNS_RPC_ZONE_DATABASE_DOTNET_set_pszFileName },
	{ NULL }
};

static PyObject *py_DNS_RPC_ZONE_DATABASE_DOTNET_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_ZONE_DATABASE_DOTNET, type);
}


static PyTypeObject DNS_RPC_ZONE_DATABASE_DOTNET_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.DNS_RPC_ZONE_DATABASE_DOTNET",
	.tp_getset = py_DNS_RPC_ZONE_DATABASE_DOTNET_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DNS_RPC_ZONE_DATABASE_DOTNET_new,
};


static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_pszZoneName(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_pszZoneName;
	if (object->pszZoneName == NULL) {
		py_pszZoneName = Py_None;
		Py_INCREF(py_pszZoneName);
	} else {
		if (object->pszZoneName == NULL) {
			py_pszZoneName = Py_None;
			Py_INCREF(py_pszZoneName);
		} else {
			py_pszZoneName = PyUnicode_Decode(object->pszZoneName, strlen(object->pszZoneName), "utf-8", "ignore");
		}
	}
	return py_pszZoneName;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_pszZoneName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszZoneName = NULL;
	} else {
		object->pszZoneName = NULL;
		if (PyUnicode_Check(value)) {
			object->pszZoneName = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszZoneName = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_dwZoneType(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_dwZoneType;
	py_dwZoneType = PyInt_FromLong(object->dwZoneType);
	return py_dwZoneType;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_dwZoneType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwZoneType = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_fAllowUpdate(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_fAllowUpdate;
	py_fAllowUpdate = PyInt_FromLong(object->fAllowUpdate);
	return py_fAllowUpdate;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_fAllowUpdate(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->fAllowUpdate = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->fAllowUpdate = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_fAging(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_fAging;
	py_fAging = PyInt_FromLong(object->fAging);
	return py_fAging;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_fAging(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fAging = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_dwFlags(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_dwFlags;
	py_dwFlags = PyInt_FromLong(object->dwFlags);
	return py_dwFlags;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_dwFlags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwFlags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_pszDataFile(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_pszDataFile;
	if (object->pszDataFile == NULL) {
		py_pszDataFile = Py_None;
		Py_INCREF(py_pszDataFile);
	} else {
		if (object->pszDataFile == NULL) {
			py_pszDataFile = Py_None;
			Py_INCREF(py_pszDataFile);
		} else {
			py_pszDataFile = PyUnicode_Decode(object->pszDataFile, strlen(object->pszDataFile), "utf-8", "ignore");
		}
	}
	return py_pszDataFile;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_pszDataFile(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszDataFile = NULL;
	} else {
		object->pszDataFile = NULL;
		if (PyUnicode_Check(value)) {
			object->pszDataFile = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszDataFile = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_fDsIntegrated(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_fDsIntegrated;
	py_fDsIntegrated = PyInt_FromLong(object->fDsIntegrated);
	return py_fDsIntegrated;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_fDsIntegrated(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fDsIntegrated = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_fLoadExisting(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_fLoadExisting;
	py_fLoadExisting = PyInt_FromLong(object->fLoadExisting);
	return py_fLoadExisting;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_fLoadExisting(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fLoadExisting = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_pszAdmin(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_pszAdmin;
	if (object->pszAdmin == NULL) {
		py_pszAdmin = Py_None;
		Py_INCREF(py_pszAdmin);
	} else {
		if (object->pszAdmin == NULL) {
			py_pszAdmin = Py_None;
			Py_INCREF(py_pszAdmin);
		} else {
			py_pszAdmin = PyUnicode_Decode(object->pszAdmin, strlen(object->pszAdmin), "utf-8", "ignore");
		}
	}
	return py_pszAdmin;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_pszAdmin(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszAdmin = NULL;
	} else {
		object->pszAdmin = NULL;
		if (PyUnicode_Check(value)) {
			object->pszAdmin = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszAdmin = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_aipMasters(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_aipMasters;
	if (object->aipMasters == NULL) {
		py_aipMasters = Py_None;
		Py_INCREF(py_aipMasters);
	} else {
		py_aipMasters = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipMasters, object->aipMasters);
	}
	return py_aipMasters;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_aipMasters(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->aipMasters);
	if (value == Py_None) {
		object->aipMasters = NULL;
	} else {
		object->aipMasters = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipMasters = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_aipSecondaries(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_aipSecondaries;
	if (object->aipSecondaries == NULL) {
		py_aipSecondaries = Py_None;
		Py_INCREF(py_aipSecondaries);
	} else {
		py_aipSecondaries = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipSecondaries, object->aipSecondaries);
	}
	return py_aipSecondaries;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_aipSecondaries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->aipSecondaries);
	if (value == Py_None) {
		object->aipSecondaries = NULL;
	} else {
		object->aipSecondaries = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipSecondaries = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_fSecureSecondaries(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_fSecureSecondaries;
	py_fSecureSecondaries = PyInt_FromLong(object->fSecureSecondaries);
	return py_fSecureSecondaries;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_fSecureSecondaries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->fSecureSecondaries = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->fSecureSecondaries = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_fNotifyLevel(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_fNotifyLevel;
	py_fNotifyLevel = PyInt_FromLong(object->fNotifyLevel);
	return py_fNotifyLevel;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_fNotifyLevel(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->fNotifyLevel = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->fNotifyLevel = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_pvReserved1(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_pvReserved1;
	if (object->pvReserved1 == NULL) {
		py_pvReserved1 = Py_None;
		Py_INCREF(py_pvReserved1);
	} else {
		if (object->pvReserved1 == NULL) {
			py_pvReserved1 = Py_None;
			Py_INCREF(py_pvReserved1);
		} else {
			py_pvReserved1 = PyUnicode_Decode(object->pvReserved1, strlen(object->pvReserved1), "utf-8", "ignore");
		}
	}
	return py_pvReserved1;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_pvReserved1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pvReserved1 = NULL;
	} else {
		object->pvReserved1 = NULL;
		if (PyUnicode_Check(value)) {
			object->pvReserved1 = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pvReserved1 = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_pvReserved2(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_pvReserved2;
	if (object->pvReserved2 == NULL) {
		py_pvReserved2 = Py_None;
		Py_INCREF(py_pvReserved2);
	} else {
		if (object->pvReserved2 == NULL) {
			py_pvReserved2 = Py_None;
			Py_INCREF(py_pvReserved2);
		} else {
			py_pvReserved2 = PyUnicode_Decode(object->pvReserved2, strlen(object->pvReserved2), "utf-8", "ignore");
		}
	}
	return py_pvReserved2;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_pvReserved2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pvReserved2 = NULL;
	} else {
		object->pvReserved2 = NULL;
		if (PyUnicode_Check(value)) {
			object->pvReserved2 = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pvReserved2 = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_pvReserved3(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_pvReserved3;
	if (object->pvReserved3 == NULL) {
		py_pvReserved3 = Py_None;
		Py_INCREF(py_pvReserved3);
	} else {
		if (object->pvReserved3 == NULL) {
			py_pvReserved3 = Py_None;
			Py_INCREF(py_pvReserved3);
		} else {
			py_pvReserved3 = PyUnicode_Decode(object->pvReserved3, strlen(object->pvReserved3), "utf-8", "ignore");
		}
	}
	return py_pvReserved3;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_pvReserved3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pvReserved3 = NULL;
	} else {
		object->pvReserved3 = NULL;
		if (PyUnicode_Check(value)) {
			object->pvReserved3 = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pvReserved3 = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_pvReserved4(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_pvReserved4;
	if (object->pvReserved4 == NULL) {
		py_pvReserved4 = Py_None;
		Py_INCREF(py_pvReserved4);
	} else {
		if (object->pvReserved4 == NULL) {
			py_pvReserved4 = Py_None;
			Py_INCREF(py_pvReserved4);
		} else {
			py_pvReserved4 = PyUnicode_Decode(object->pvReserved4, strlen(object->pvReserved4), "utf-8", "ignore");
		}
	}
	return py_pvReserved4;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_pvReserved4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pvReserved4 = NULL;
	} else {
		object->pvReserved4 = NULL;
		if (PyUnicode_Check(value)) {
			object->pvReserved4 = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pvReserved4 = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_pvReserved5(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_pvReserved5;
	if (object->pvReserved5 == NULL) {
		py_pvReserved5 = Py_None;
		Py_INCREF(py_pvReserved5);
	} else {
		if (object->pvReserved5 == NULL) {
			py_pvReserved5 = Py_None;
			Py_INCREF(py_pvReserved5);
		} else {
			py_pvReserved5 = PyUnicode_Decode(object->pvReserved5, strlen(object->pvReserved5), "utf-8", "ignore");
		}
	}
	return py_pvReserved5;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_pvReserved5(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pvReserved5 = NULL;
	} else {
		object->pvReserved5 = NULL;
		if (PyUnicode_Check(value)) {
			object->pvReserved5 = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pvReserved5 = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_pvReserved6(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_pvReserved6;
	if (object->pvReserved6 == NULL) {
		py_pvReserved6 = Py_None;
		Py_INCREF(py_pvReserved6);
	} else {
		if (object->pvReserved6 == NULL) {
			py_pvReserved6 = Py_None;
			Py_INCREF(py_pvReserved6);
		} else {
			py_pvReserved6 = PyUnicode_Decode(object->pvReserved6, strlen(object->pvReserved6), "utf-8", "ignore");
		}
	}
	return py_pvReserved6;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_pvReserved6(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pvReserved6 = NULL;
	} else {
		object->pvReserved6 = NULL;
		if (PyUnicode_Check(value)) {
			object->pvReserved6 = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pvReserved6 = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_pvReserved7(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_pvReserved7;
	if (object->pvReserved7 == NULL) {
		py_pvReserved7 = Py_None;
		Py_INCREF(py_pvReserved7);
	} else {
		if (object->pvReserved7 == NULL) {
			py_pvReserved7 = Py_None;
			Py_INCREF(py_pvReserved7);
		} else {
			py_pvReserved7 = PyUnicode_Decode(object->pvReserved7, strlen(object->pvReserved7), "utf-8", "ignore");
		}
	}
	return py_pvReserved7;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_pvReserved7(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pvReserved7 = NULL;
	} else {
		object->pvReserved7 = NULL;
		if (PyUnicode_Check(value)) {
			object->pvReserved7 = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pvReserved7 = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_pvReserved8(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_pvReserved8;
	if (object->pvReserved8 == NULL) {
		py_pvReserved8 = Py_None;
		Py_INCREF(py_pvReserved8);
	} else {
		if (object->pvReserved8 == NULL) {
			py_pvReserved8 = Py_None;
			Py_INCREF(py_pvReserved8);
		} else {
			py_pvReserved8 = PyUnicode_Decode(object->pvReserved8, strlen(object->pvReserved8), "utf-8", "ignore");
		}
	}
	return py_pvReserved8;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_pvReserved8(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pvReserved8 = NULL;
	} else {
		object->pvReserved8 = NULL;
		if (PyUnicode_Check(value)) {
			object->pvReserved8 = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pvReserved8 = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_dwReserved1(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_dwReserved1;
	py_dwReserved1 = PyInt_FromLong(object->dwReserved1);
	return py_dwReserved1;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_dwReserved1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwReserved1 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_dwReserved2(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_dwReserved2;
	py_dwReserved2 = PyInt_FromLong(object->dwReserved2);
	return py_dwReserved2;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_dwReserved2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwReserved2 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_dwReserved3(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_dwReserved3;
	py_dwReserved3 = PyInt_FromLong(object->dwReserved3);
	return py_dwReserved3;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_dwReserved3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwReserved3 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_dwReserved4(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_dwReserved4;
	py_dwReserved4 = PyInt_FromLong(object->dwReserved4);
	return py_dwReserved4;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_dwReserved4(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwReserved4 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_dwReserved5(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_dwReserved5;
	py_dwReserved5 = PyInt_FromLong(object->dwReserved5);
	return py_dwReserved5;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_dwReserved5(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwReserved5 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_dwReserved6(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_dwReserved6;
	py_dwReserved6 = PyInt_FromLong(object->dwReserved6);
	return py_dwReserved6;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_dwReserved6(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwReserved6 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_dwReserved7(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_dwReserved7;
	py_dwReserved7 = PyInt_FromLong(object->dwReserved7);
	return py_dwReserved7;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_dwReserved7(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwReserved7 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_dwReserved8(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_dwReserved8;
	py_dwReserved8 = PyInt_FromLong(object->dwReserved8);
	return py_dwReserved8;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_dwReserved8(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_W2K *object = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwReserved8 = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_DNS_RPC_ZONE_CREATE_INFO_W2K_getsetters[] = {
	{ discard_const_p(char, "pszZoneName"), py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_pszZoneName, py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_pszZoneName },
	{ discard_const_p(char, "dwZoneType"), py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_dwZoneType, py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_dwZoneType },
	{ discard_const_p(char, "fAllowUpdate"), py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_fAllowUpdate, py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_fAllowUpdate },
	{ discard_const_p(char, "fAging"), py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_fAging, py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_fAging },
	{ discard_const_p(char, "dwFlags"), py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_dwFlags, py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_dwFlags },
	{ discard_const_p(char, "pszDataFile"), py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_pszDataFile, py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_pszDataFile },
	{ discard_const_p(char, "fDsIntegrated"), py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_fDsIntegrated, py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_fDsIntegrated },
	{ discard_const_p(char, "fLoadExisting"), py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_fLoadExisting, py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_fLoadExisting },
	{ discard_const_p(char, "pszAdmin"), py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_pszAdmin, py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_pszAdmin },
	{ discard_const_p(char, "aipMasters"), py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_aipMasters, py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_aipMasters },
	{ discard_const_p(char, "aipSecondaries"), py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_aipSecondaries, py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_aipSecondaries },
	{ discard_const_p(char, "fSecureSecondaries"), py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_fSecureSecondaries, py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_fSecureSecondaries },
	{ discard_const_p(char, "fNotifyLevel"), py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_fNotifyLevel, py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_fNotifyLevel },
	{ discard_const_p(char, "pvReserved1"), py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_pvReserved1, py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_pvReserved1 },
	{ discard_const_p(char, "pvReserved2"), py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_pvReserved2, py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_pvReserved2 },
	{ discard_const_p(char, "pvReserved3"), py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_pvReserved3, py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_pvReserved3 },
	{ discard_const_p(char, "pvReserved4"), py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_pvReserved4, py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_pvReserved4 },
	{ discard_const_p(char, "pvReserved5"), py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_pvReserved5, py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_pvReserved5 },
	{ discard_const_p(char, "pvReserved6"), py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_pvReserved6, py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_pvReserved6 },
	{ discard_const_p(char, "pvReserved7"), py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_pvReserved7, py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_pvReserved7 },
	{ discard_const_p(char, "pvReserved8"), py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_pvReserved8, py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_pvReserved8 },
	{ discard_const_p(char, "dwReserved1"), py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_dwReserved1, py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_dwReserved1 },
	{ discard_const_p(char, "dwReserved2"), py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_dwReserved2, py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_dwReserved2 },
	{ discard_const_p(char, "dwReserved3"), py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_dwReserved3, py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_dwReserved3 },
	{ discard_const_p(char, "dwReserved4"), py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_dwReserved4, py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_dwReserved4 },
	{ discard_const_p(char, "dwReserved5"), py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_dwReserved5, py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_dwReserved5 },
	{ discard_const_p(char, "dwReserved6"), py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_dwReserved6, py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_dwReserved6 },
	{ discard_const_p(char, "dwReserved7"), py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_dwReserved7, py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_dwReserved7 },
	{ discard_const_p(char, "dwReserved8"), py_DNS_RPC_ZONE_CREATE_INFO_W2K_get_dwReserved8, py_DNS_RPC_ZONE_CREATE_INFO_W2K_set_dwReserved8 },
	{ NULL }
};

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_W2K_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_ZONE_CREATE_INFO_W2K, type);
}


static PyTypeObject DNS_RPC_ZONE_CREATE_INFO_W2K_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.DNS_RPC_ZONE_CREATE_INFO_W2K",
	.tp_getset = py_DNS_RPC_ZONE_CREATE_INFO_W2K_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DNS_RPC_ZONE_CREATE_INFO_W2K_new,
};


static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_dwRpcStructureVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwRpcStructureVersion;
	py_dwRpcStructureVersion = PyInt_FromLong(object->dwRpcStructureVersion);
	return py_dwRpcStructureVersion;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_dwRpcStructureVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwRpcStructureVersion = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_dwReserved0(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwReserved0;
	py_dwReserved0 = PyInt_FromLong(object->dwReserved0);
	return py_dwReserved0;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_dwReserved0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwReserved0 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_pszZoneName(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_pszZoneName;
	if (object->pszZoneName == NULL) {
		py_pszZoneName = Py_None;
		Py_INCREF(py_pszZoneName);
	} else {
		if (object->pszZoneName == NULL) {
			py_pszZoneName = Py_None;
			Py_INCREF(py_pszZoneName);
		} else {
			py_pszZoneName = PyUnicode_Decode(object->pszZoneName, strlen(object->pszZoneName), "utf-8", "ignore");
		}
	}
	return py_pszZoneName;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_pszZoneName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszZoneName = NULL;
	} else {
		object->pszZoneName = NULL;
		if (PyUnicode_Check(value)) {
			object->pszZoneName = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszZoneName = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_dwZoneType(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwZoneType;
	py_dwZoneType = PyInt_FromLong(object->dwZoneType);
	return py_dwZoneType;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_dwZoneType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwZoneType = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_fAllowUpdate(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_fAllowUpdate;
	py_fAllowUpdate = PyInt_FromLong(object->fAllowUpdate);
	return py_fAllowUpdate;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_fAllowUpdate(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->fAllowUpdate = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->fAllowUpdate = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_fAging(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_fAging;
	py_fAging = PyInt_FromLong(object->fAging);
	return py_fAging;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_fAging(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fAging = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_dwFlags(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwFlags;
	py_dwFlags = PyInt_FromLong(object->dwFlags);
	return py_dwFlags;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_dwFlags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwFlags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_pszDataFile(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_pszDataFile;
	if (object->pszDataFile == NULL) {
		py_pszDataFile = Py_None;
		Py_INCREF(py_pszDataFile);
	} else {
		if (object->pszDataFile == NULL) {
			py_pszDataFile = Py_None;
			Py_INCREF(py_pszDataFile);
		} else {
			py_pszDataFile = PyUnicode_Decode(object->pszDataFile, strlen(object->pszDataFile), "utf-8", "ignore");
		}
	}
	return py_pszDataFile;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_pszDataFile(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszDataFile = NULL;
	} else {
		object->pszDataFile = NULL;
		if (PyUnicode_Check(value)) {
			object->pszDataFile = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszDataFile = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_fDsIntegrated(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_fDsIntegrated;
	py_fDsIntegrated = PyInt_FromLong(object->fDsIntegrated);
	return py_fDsIntegrated;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_fDsIntegrated(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fDsIntegrated = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_fLoadExisting(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_fLoadExisting;
	py_fLoadExisting = PyInt_FromLong(object->fLoadExisting);
	return py_fLoadExisting;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_fLoadExisting(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fLoadExisting = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_pszAdmin(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_pszAdmin;
	if (object->pszAdmin == NULL) {
		py_pszAdmin = Py_None;
		Py_INCREF(py_pszAdmin);
	} else {
		if (object->pszAdmin == NULL) {
			py_pszAdmin = Py_None;
			Py_INCREF(py_pszAdmin);
		} else {
			py_pszAdmin = PyUnicode_Decode(object->pszAdmin, strlen(object->pszAdmin), "utf-8", "ignore");
		}
	}
	return py_pszAdmin;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_pszAdmin(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszAdmin = NULL;
	} else {
		object->pszAdmin = NULL;
		if (PyUnicode_Check(value)) {
			object->pszAdmin = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszAdmin = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_aipMasters(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_aipMasters;
	if (object->aipMasters == NULL) {
		py_aipMasters = Py_None;
		Py_INCREF(py_aipMasters);
	} else {
		py_aipMasters = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipMasters, object->aipMasters);
	}
	return py_aipMasters;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_aipMasters(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->aipMasters);
	if (value == Py_None) {
		object->aipMasters = NULL;
	} else {
		object->aipMasters = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipMasters = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_aipSecondaries(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_aipSecondaries;
	if (object->aipSecondaries == NULL) {
		py_aipSecondaries = Py_None;
		Py_INCREF(py_aipSecondaries);
	} else {
		py_aipSecondaries = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipSecondaries, object->aipSecondaries);
	}
	return py_aipSecondaries;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_aipSecondaries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->aipSecondaries);
	if (value == Py_None) {
		object->aipSecondaries = NULL;
	} else {
		object->aipSecondaries = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipSecondaries = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_fSecureSecondaries(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_fSecureSecondaries;
	py_fSecureSecondaries = PyInt_FromLong(object->fSecureSecondaries);
	return py_fSecureSecondaries;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_fSecureSecondaries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->fSecureSecondaries = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->fSecureSecondaries = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_fNotifyLevel(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_fNotifyLevel;
	py_fNotifyLevel = PyInt_FromLong(object->fNotifyLevel);
	return py_fNotifyLevel;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_fNotifyLevel(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->fNotifyLevel = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->fNotifyLevel = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_dwTimeout(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwTimeout;
	py_dwTimeout = PyInt_FromLong(object->dwTimeout);
	return py_dwTimeout;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_dwTimeout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwTimeout = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_fRecurseAfterForwarding(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_fRecurseAfterForwarding;
	py_fRecurseAfterForwarding = PyInt_FromLong(object->fRecurseAfterForwarding);
	return py_fRecurseAfterForwarding;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_fRecurseAfterForwarding(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fRecurseAfterForwarding = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_dwDpFlags(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwDpFlags;
	py_dwDpFlags = PyInt_FromLong(object->dwDpFlags);
	return py_dwDpFlags;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_dwDpFlags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwDpFlags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_pszDpFqdn(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_pszDpFqdn;
	if (object->pszDpFqdn == NULL) {
		py_pszDpFqdn = Py_None;
		Py_INCREF(py_pszDpFqdn);
	} else {
		if (object->pszDpFqdn == NULL) {
			py_pszDpFqdn = Py_None;
			Py_INCREF(py_pszDpFqdn);
		} else {
			py_pszDpFqdn = PyUnicode_Decode(object->pszDpFqdn, strlen(object->pszDpFqdn), "utf-8", "ignore");
		}
	}
	return py_pszDpFqdn;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_pszDpFqdn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszDpFqdn = NULL;
	} else {
		object->pszDpFqdn = NULL;
		if (PyUnicode_Check(value)) {
			object->pszDpFqdn = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszDpFqdn = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_dwReserved(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwReserved;
	py_dwReserved = PyList_New(32);
	if (py_dwReserved == NULL) {
		return NULL;
	}
	{
		int dwReserved_cntr_0;
		for (dwReserved_cntr_0 = 0; dwReserved_cntr_0 < 32; dwReserved_cntr_0++) {
			PyObject *py_dwReserved_0;
			py_dwReserved_0 = PyInt_FromLong(object->dwReserved[dwReserved_cntr_0]);
			PyList_SetItem(py_dwReserved, dwReserved_cntr_0, py_dwReserved_0);
		}
	}
	return py_dwReserved;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_dwReserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *object = (struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int dwReserved_cntr_0;
		for (dwReserved_cntr_0 = 0; dwReserved_cntr_0 < PyList_GET_SIZE(value); dwReserved_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, dwReserved_cntr_0), return -1;);
			object->dwReserved[dwReserved_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, dwReserved_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_getsetters[] = {
	{ discard_const_p(char, "dwRpcStructureVersion"), py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_dwRpcStructureVersion, py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_dwRpcStructureVersion },
	{ discard_const_p(char, "dwReserved0"), py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_dwReserved0, py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_dwReserved0 },
	{ discard_const_p(char, "pszZoneName"), py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_pszZoneName, py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_pszZoneName },
	{ discard_const_p(char, "dwZoneType"), py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_dwZoneType, py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_dwZoneType },
	{ discard_const_p(char, "fAllowUpdate"), py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_fAllowUpdate, py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_fAllowUpdate },
	{ discard_const_p(char, "fAging"), py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_fAging, py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_fAging },
	{ discard_const_p(char, "dwFlags"), py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_dwFlags, py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_dwFlags },
	{ discard_const_p(char, "pszDataFile"), py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_pszDataFile, py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_pszDataFile },
	{ discard_const_p(char, "fDsIntegrated"), py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_fDsIntegrated, py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_fDsIntegrated },
	{ discard_const_p(char, "fLoadExisting"), py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_fLoadExisting, py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_fLoadExisting },
	{ discard_const_p(char, "pszAdmin"), py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_pszAdmin, py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_pszAdmin },
	{ discard_const_p(char, "aipMasters"), py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_aipMasters, py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_aipMasters },
	{ discard_const_p(char, "aipSecondaries"), py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_aipSecondaries, py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_aipSecondaries },
	{ discard_const_p(char, "fSecureSecondaries"), py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_fSecureSecondaries, py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_fSecureSecondaries },
	{ discard_const_p(char, "fNotifyLevel"), py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_fNotifyLevel, py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_fNotifyLevel },
	{ discard_const_p(char, "dwTimeout"), py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_dwTimeout, py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_dwTimeout },
	{ discard_const_p(char, "fRecurseAfterForwarding"), py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_fRecurseAfterForwarding, py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_fRecurseAfterForwarding },
	{ discard_const_p(char, "dwDpFlags"), py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_dwDpFlags, py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_dwDpFlags },
	{ discard_const_p(char, "pszDpFqdn"), py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_pszDpFqdn, py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_pszDpFqdn },
	{ discard_const_p(char, "dwReserved"), py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_get_dwReserved, py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_set_dwReserved },
	{ NULL }
};

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_ZONE_CREATE_INFO_DOTNET, type);
}


static PyTypeObject DNS_RPC_ZONE_CREATE_INFO_DOTNET_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.DNS_RPC_ZONE_CREATE_INFO_DOTNET",
	.tp_getset = py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DNS_RPC_ZONE_CREATE_INFO_DOTNET_new,
};


static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_dwRpcStructureVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_dwRpcStructureVersion;
	py_dwRpcStructureVersion = PyInt_FromLong(object->dwRpcStructureVersion);
	return py_dwRpcStructureVersion;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_dwRpcStructureVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwRpcStructureVersion = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_dwReserved0(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_dwReserved0;
	py_dwReserved0 = PyInt_FromLong(object->dwReserved0);
	return py_dwReserved0;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_dwReserved0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwReserved0 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_pszZoneName(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_pszZoneName;
	if (object->pszZoneName == NULL) {
		py_pszZoneName = Py_None;
		Py_INCREF(py_pszZoneName);
	} else {
		if (object->pszZoneName == NULL) {
			py_pszZoneName = Py_None;
			Py_INCREF(py_pszZoneName);
		} else {
			py_pszZoneName = PyUnicode_Decode(object->pszZoneName, strlen(object->pszZoneName), "utf-8", "ignore");
		}
	}
	return py_pszZoneName;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_pszZoneName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszZoneName = NULL;
	} else {
		object->pszZoneName = NULL;
		if (PyUnicode_Check(value)) {
			object->pszZoneName = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszZoneName = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_dwZoneType(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_dwZoneType;
	py_dwZoneType = PyInt_FromLong(object->dwZoneType);
	return py_dwZoneType;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_dwZoneType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwZoneType = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_fAllowUpdate(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_fAllowUpdate;
	py_fAllowUpdate = PyInt_FromLong(object->fAllowUpdate);
	return py_fAllowUpdate;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_fAllowUpdate(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->fAllowUpdate = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->fAllowUpdate = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_fAging(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_fAging;
	py_fAging = PyInt_FromLong(object->fAging);
	return py_fAging;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_fAging(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fAging = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_dwFlags(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_dwFlags;
	py_dwFlags = PyInt_FromLong(object->dwFlags);
	return py_dwFlags;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_dwFlags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwFlags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_pszDataFile(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_pszDataFile;
	if (object->pszDataFile == NULL) {
		py_pszDataFile = Py_None;
		Py_INCREF(py_pszDataFile);
	} else {
		if (object->pszDataFile == NULL) {
			py_pszDataFile = Py_None;
			Py_INCREF(py_pszDataFile);
		} else {
			py_pszDataFile = PyUnicode_Decode(object->pszDataFile, strlen(object->pszDataFile), "utf-8", "ignore");
		}
	}
	return py_pszDataFile;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_pszDataFile(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszDataFile = NULL;
	} else {
		object->pszDataFile = NULL;
		if (PyUnicode_Check(value)) {
			object->pszDataFile = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszDataFile = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_fDsIntegrated(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_fDsIntegrated;
	py_fDsIntegrated = PyInt_FromLong(object->fDsIntegrated);
	return py_fDsIntegrated;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_fDsIntegrated(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fDsIntegrated = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_fLoadExisting(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_fLoadExisting;
	py_fLoadExisting = PyInt_FromLong(object->fLoadExisting);
	return py_fLoadExisting;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_fLoadExisting(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fLoadExisting = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_pszAdmin(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_pszAdmin;
	if (object->pszAdmin == NULL) {
		py_pszAdmin = Py_None;
		Py_INCREF(py_pszAdmin);
	} else {
		if (object->pszAdmin == NULL) {
			py_pszAdmin = Py_None;
			Py_INCREF(py_pszAdmin);
		} else {
			py_pszAdmin = PyUnicode_Decode(object->pszAdmin, strlen(object->pszAdmin), "utf-8", "ignore");
		}
	}
	return py_pszAdmin;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_pszAdmin(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszAdmin = NULL;
	} else {
		object->pszAdmin = NULL;
		if (PyUnicode_Check(value)) {
			object->pszAdmin = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszAdmin = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_aipMasters(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_aipMasters;
	if (object->aipMasters == NULL) {
		py_aipMasters = Py_None;
		Py_INCREF(py_aipMasters);
	} else {
		py_aipMasters = pytalloc_reference_ex(&DNS_ADDR_ARRAY_Type, object->aipMasters, object->aipMasters);
	}
	return py_aipMasters;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_aipMasters(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->aipMasters);
	if (value == Py_None) {
		object->aipMasters = NULL;
	} else {
		object->aipMasters = NULL;
		PY_CHECK_TYPE(&DNS_ADDR_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipMasters = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_aipSecondaries(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_aipSecondaries;
	if (object->aipSecondaries == NULL) {
		py_aipSecondaries = Py_None;
		Py_INCREF(py_aipSecondaries);
	} else {
		py_aipSecondaries = pytalloc_reference_ex(&DNS_ADDR_ARRAY_Type, object->aipSecondaries, object->aipSecondaries);
	}
	return py_aipSecondaries;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_aipSecondaries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->aipSecondaries);
	if (value == Py_None) {
		object->aipSecondaries = NULL;
	} else {
		object->aipSecondaries = NULL;
		PY_CHECK_TYPE(&DNS_ADDR_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipSecondaries = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_fSecureSecondaries(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_fSecureSecondaries;
	py_fSecureSecondaries = PyInt_FromLong(object->fSecureSecondaries);
	return py_fSecureSecondaries;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_fSecureSecondaries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->fSecureSecondaries = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->fSecureSecondaries = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_fNotifyLevel(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_fNotifyLevel;
	py_fNotifyLevel = PyInt_FromLong(object->fNotifyLevel);
	return py_fNotifyLevel;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_fNotifyLevel(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->fNotifyLevel = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->fNotifyLevel = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_dwTimeout(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_dwTimeout;
	py_dwTimeout = PyInt_FromLong(object->dwTimeout);
	return py_dwTimeout;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_dwTimeout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwTimeout = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_fRecurseAfterForwarding(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_fRecurseAfterForwarding;
	py_fRecurseAfterForwarding = PyInt_FromLong(object->fRecurseAfterForwarding);
	return py_fRecurseAfterForwarding;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_fRecurseAfterForwarding(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fRecurseAfterForwarding = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_dwDpFlags(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_dwDpFlags;
	py_dwDpFlags = PyInt_FromLong(object->dwDpFlags);
	return py_dwDpFlags;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_dwDpFlags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwDpFlags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_pszDpFqdn(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_pszDpFqdn;
	if (object->pszDpFqdn == NULL) {
		py_pszDpFqdn = Py_None;
		Py_INCREF(py_pszDpFqdn);
	} else {
		if (object->pszDpFqdn == NULL) {
			py_pszDpFqdn = Py_None;
			Py_INCREF(py_pszDpFqdn);
		} else {
			py_pszDpFqdn = PyUnicode_Decode(object->pszDpFqdn, strlen(object->pszDpFqdn), "utf-8", "ignore");
		}
	}
	return py_pszDpFqdn;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_pszDpFqdn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszDpFqdn = NULL;
	} else {
		object->pszDpFqdn = NULL;
		if (PyUnicode_Check(value)) {
			object->pszDpFqdn = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszDpFqdn = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_dwReserved(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_dwReserved;
	py_dwReserved = PyList_New(32);
	if (py_dwReserved == NULL) {
		return NULL;
	}
	{
		int dwReserved_cntr_0;
		for (dwReserved_cntr_0 = 0; dwReserved_cntr_0 < 32; dwReserved_cntr_0++) {
			PyObject *py_dwReserved_0;
			py_dwReserved_0 = PyInt_FromLong(object->dwReserved[dwReserved_cntr_0]);
			PyList_SetItem(py_dwReserved, dwReserved_cntr_0, py_dwReserved_0);
		}
	}
	return py_dwReserved;
}

static int py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_dwReserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *object = (struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int dwReserved_cntr_0;
		for (dwReserved_cntr_0 = 0; dwReserved_cntr_0 < PyList_GET_SIZE(value); dwReserved_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, dwReserved_cntr_0), return -1;);
			object->dwReserved[dwReserved_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, dwReserved_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_getsetters[] = {
	{ discard_const_p(char, "dwRpcStructureVersion"), py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_dwRpcStructureVersion, py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_dwRpcStructureVersion },
	{ discard_const_p(char, "dwReserved0"), py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_dwReserved0, py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_dwReserved0 },
	{ discard_const_p(char, "pszZoneName"), py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_pszZoneName, py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_pszZoneName },
	{ discard_const_p(char, "dwZoneType"), py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_dwZoneType, py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_dwZoneType },
	{ discard_const_p(char, "fAllowUpdate"), py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_fAllowUpdate, py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_fAllowUpdate },
	{ discard_const_p(char, "fAging"), py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_fAging, py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_fAging },
	{ discard_const_p(char, "dwFlags"), py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_dwFlags, py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_dwFlags },
	{ discard_const_p(char, "pszDataFile"), py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_pszDataFile, py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_pszDataFile },
	{ discard_const_p(char, "fDsIntegrated"), py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_fDsIntegrated, py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_fDsIntegrated },
	{ discard_const_p(char, "fLoadExisting"), py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_fLoadExisting, py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_fLoadExisting },
	{ discard_const_p(char, "pszAdmin"), py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_pszAdmin, py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_pszAdmin },
	{ discard_const_p(char, "aipMasters"), py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_aipMasters, py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_aipMasters },
	{ discard_const_p(char, "aipSecondaries"), py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_aipSecondaries, py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_aipSecondaries },
	{ discard_const_p(char, "fSecureSecondaries"), py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_fSecureSecondaries, py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_fSecureSecondaries },
	{ discard_const_p(char, "fNotifyLevel"), py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_fNotifyLevel, py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_fNotifyLevel },
	{ discard_const_p(char, "dwTimeout"), py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_dwTimeout, py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_dwTimeout },
	{ discard_const_p(char, "fRecurseAfterForwarding"), py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_fRecurseAfterForwarding, py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_fRecurseAfterForwarding },
	{ discard_const_p(char, "dwDpFlags"), py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_dwDpFlags, py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_dwDpFlags },
	{ discard_const_p(char, "pszDpFqdn"), py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_pszDpFqdn, py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_pszDpFqdn },
	{ discard_const_p(char, "dwReserved"), py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_get_dwReserved, py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_set_dwReserved },
	{ NULL }
};

static PyObject *py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN, type);
}


static PyTypeObject DNS_RPC_ZONE_CREATE_INFO_LONGHORN_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.DNS_RPC_ZONE_CREATE_INFO_LONGHORN",
	.tp_getset = py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_new,
};


static PyObject *py_DNS_RPC_ZONE_EXPORT_INFO_get_dwRpcStructureVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_EXPORT_INFO *object = (struct DNS_RPC_ZONE_EXPORT_INFO *)pytalloc_get_ptr(obj);
	PyObject *py_dwRpcStructureVersion;
	py_dwRpcStructureVersion = PyInt_FromLong(object->dwRpcStructureVersion);
	return py_dwRpcStructureVersion;
}

static int py_DNS_RPC_ZONE_EXPORT_INFO_set_dwRpcStructureVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_EXPORT_INFO *object = (struct DNS_RPC_ZONE_EXPORT_INFO *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwRpcStructureVersion = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_EXPORT_INFO_get_dwReserved0(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_EXPORT_INFO *object = (struct DNS_RPC_ZONE_EXPORT_INFO *)pytalloc_get_ptr(obj);
	PyObject *py_dwReserved0;
	py_dwReserved0 = PyInt_FromLong(object->dwReserved0);
	return py_dwReserved0;
}

static int py_DNS_RPC_ZONE_EXPORT_INFO_set_dwReserved0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_EXPORT_INFO *object = (struct DNS_RPC_ZONE_EXPORT_INFO *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwReserved0 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ZONE_EXPORT_INFO_get_pszZoneExportFile(PyObject *obj, void *closure)
{
	struct DNS_RPC_ZONE_EXPORT_INFO *object = (struct DNS_RPC_ZONE_EXPORT_INFO *)pytalloc_get_ptr(obj);
	PyObject *py_pszZoneExportFile;
	if (object->pszZoneExportFile == NULL) {
		py_pszZoneExportFile = Py_None;
		Py_INCREF(py_pszZoneExportFile);
	} else {
		if (object->pszZoneExportFile == NULL) {
			py_pszZoneExportFile = Py_None;
			Py_INCREF(py_pszZoneExportFile);
		} else {
			py_pszZoneExportFile = PyUnicode_Decode(object->pszZoneExportFile, strlen(object->pszZoneExportFile), "utf-8", "ignore");
		}
	}
	return py_pszZoneExportFile;
}

static int py_DNS_RPC_ZONE_EXPORT_INFO_set_pszZoneExportFile(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ZONE_EXPORT_INFO *object = (struct DNS_RPC_ZONE_EXPORT_INFO *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszZoneExportFile = NULL;
	} else {
		object->pszZoneExportFile = NULL;
		if (PyUnicode_Check(value)) {
			object->pszZoneExportFile = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszZoneExportFile = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_ZONE_EXPORT_INFO_getsetters[] = {
	{ discard_const_p(char, "dwRpcStructureVersion"), py_DNS_RPC_ZONE_EXPORT_INFO_get_dwRpcStructureVersion, py_DNS_RPC_ZONE_EXPORT_INFO_set_dwRpcStructureVersion },
	{ discard_const_p(char, "dwReserved0"), py_DNS_RPC_ZONE_EXPORT_INFO_get_dwReserved0, py_DNS_RPC_ZONE_EXPORT_INFO_set_dwReserved0 },
	{ discard_const_p(char, "pszZoneExportFile"), py_DNS_RPC_ZONE_EXPORT_INFO_get_pszZoneExportFile, py_DNS_RPC_ZONE_EXPORT_INFO_set_pszZoneExportFile },
	{ NULL }
};

static PyObject *py_DNS_RPC_ZONE_EXPORT_INFO_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_ZONE_EXPORT_INFO, type);
}


static PyTypeObject DNS_RPC_ZONE_EXPORT_INFO_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.DNS_RPC_ZONE_EXPORT_INFO",
	.tp_getset = py_DNS_RPC_ZONE_EXPORT_INFO_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DNS_RPC_ZONE_EXPORT_INFO_new,
};


static PyObject *py_DNS_RPC_ENUM_ZONES_FILTER_get_dwRpcStructureVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_ENUM_ZONES_FILTER *object = (struct DNS_RPC_ENUM_ZONES_FILTER *)pytalloc_get_ptr(obj);
	PyObject *py_dwRpcStructureVersion;
	py_dwRpcStructureVersion = PyInt_FromLong(object->dwRpcStructureVersion);
	return py_dwRpcStructureVersion;
}

static int py_DNS_RPC_ENUM_ZONES_FILTER_set_dwRpcStructureVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ENUM_ZONES_FILTER *object = (struct DNS_RPC_ENUM_ZONES_FILTER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwRpcStructureVersion = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ENUM_ZONES_FILTER_get_dwReserved0(PyObject *obj, void *closure)
{
	struct DNS_RPC_ENUM_ZONES_FILTER *object = (struct DNS_RPC_ENUM_ZONES_FILTER *)pytalloc_get_ptr(obj);
	PyObject *py_dwReserved0;
	py_dwReserved0 = PyInt_FromLong(object->dwReserved0);
	return py_dwReserved0;
}

static int py_DNS_RPC_ENUM_ZONES_FILTER_set_dwReserved0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ENUM_ZONES_FILTER *object = (struct DNS_RPC_ENUM_ZONES_FILTER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwReserved0 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ENUM_ZONES_FILTER_get_dwFilter(PyObject *obj, void *closure)
{
	struct DNS_RPC_ENUM_ZONES_FILTER *object = (struct DNS_RPC_ENUM_ZONES_FILTER *)pytalloc_get_ptr(obj);
	PyObject *py_dwFilter;
	py_dwFilter = PyInt_FromLong(object->dwFilter);
	return py_dwFilter;
}

static int py_DNS_RPC_ENUM_ZONES_FILTER_set_dwFilter(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ENUM_ZONES_FILTER *object = (struct DNS_RPC_ENUM_ZONES_FILTER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwFilter = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_ENUM_ZONES_FILTER_get_pszPartitionFqdn(PyObject *obj, void *closure)
{
	struct DNS_RPC_ENUM_ZONES_FILTER *object = (struct DNS_RPC_ENUM_ZONES_FILTER *)pytalloc_get_ptr(obj);
	PyObject *py_pszPartitionFqdn;
	if (object->pszPartitionFqdn == NULL) {
		py_pszPartitionFqdn = Py_None;
		Py_INCREF(py_pszPartitionFqdn);
	} else {
		if (object->pszPartitionFqdn == NULL) {
			py_pszPartitionFqdn = Py_None;
			Py_INCREF(py_pszPartitionFqdn);
		} else {
			py_pszPartitionFqdn = PyUnicode_Decode(object->pszPartitionFqdn, strlen(object->pszPartitionFqdn), "utf-8", "ignore");
		}
	}
	return py_pszPartitionFqdn;
}

static int py_DNS_RPC_ENUM_ZONES_FILTER_set_pszPartitionFqdn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ENUM_ZONES_FILTER *object = (struct DNS_RPC_ENUM_ZONES_FILTER *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszPartitionFqdn = NULL;
	} else {
		object->pszPartitionFqdn = NULL;
		if (PyUnicode_Check(value)) {
			object->pszPartitionFqdn = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszPartitionFqdn = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ENUM_ZONES_FILTER_get_pszQueryString(PyObject *obj, void *closure)
{
	struct DNS_RPC_ENUM_ZONES_FILTER *object = (struct DNS_RPC_ENUM_ZONES_FILTER *)pytalloc_get_ptr(obj);
	PyObject *py_pszQueryString;
	if (object->pszQueryString == NULL) {
		py_pszQueryString = Py_None;
		Py_INCREF(py_pszQueryString);
	} else {
		if (object->pszQueryString == NULL) {
			py_pszQueryString = Py_None;
			Py_INCREF(py_pszQueryString);
		} else {
			py_pszQueryString = PyUnicode_Decode(object->pszQueryString, strlen(object->pszQueryString), "utf-8", "ignore");
		}
	}
	return py_pszQueryString;
}

static int py_DNS_RPC_ENUM_ZONES_FILTER_set_pszQueryString(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ENUM_ZONES_FILTER *object = (struct DNS_RPC_ENUM_ZONES_FILTER *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszQueryString = NULL;
	} else {
		object->pszQueryString = NULL;
		if (PyUnicode_Check(value)) {
			object->pszQueryString = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszQueryString = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_DNS_RPC_ENUM_ZONES_FILTER_get_pszReserved(PyObject *obj, void *closure)
{
	struct DNS_RPC_ENUM_ZONES_FILTER *object = (struct DNS_RPC_ENUM_ZONES_FILTER *)pytalloc_get_ptr(obj);
	PyObject *py_pszReserved;
	py_pszReserved = PyList_New(6);
	if (py_pszReserved == NULL) {
		return NULL;
	}
	{
		int pszReserved_cntr_0;
		for (pszReserved_cntr_0 = 0; pszReserved_cntr_0 < 6; pszReserved_cntr_0++) {
			PyObject *py_pszReserved_0;
			py_pszReserved_0 = pytalloc_reference_ex(&DNS_EXTENSION_Type, object->pszReserved, &object->pszReserved[pszReserved_cntr_0]);
			PyList_SetItem(py_pszReserved, pszReserved_cntr_0, py_pszReserved_0);
		}
	}
	return py_pszReserved;
}

static int py_DNS_RPC_ENUM_ZONES_FILTER_set_pszReserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_ENUM_ZONES_FILTER *object = (struct DNS_RPC_ENUM_ZONES_FILTER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int pszReserved_cntr_0;
		for (pszReserved_cntr_0 = 0; pszReserved_cntr_0 < PyList_GET_SIZE(value); pszReserved_cntr_0++) {
			PY_CHECK_TYPE(&DNS_EXTENSION_Type, PyList_GET_ITEM(value, pszReserved_cntr_0), return -1;);
			if (talloc_reference(object->pszReserved, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, pszReserved_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->pszReserved[pszReserved_cntr_0] = *(struct DNS_EXTENSION *)pytalloc_get_ptr(PyList_GET_ITEM(value, pszReserved_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_ENUM_ZONES_FILTER_getsetters[] = {
	{ discard_const_p(char, "dwRpcStructureVersion"), py_DNS_RPC_ENUM_ZONES_FILTER_get_dwRpcStructureVersion, py_DNS_RPC_ENUM_ZONES_FILTER_set_dwRpcStructureVersion },
	{ discard_const_p(char, "dwReserved0"), py_DNS_RPC_ENUM_ZONES_FILTER_get_dwReserved0, py_DNS_RPC_ENUM_ZONES_FILTER_set_dwReserved0 },
	{ discard_const_p(char, "dwFilter"), py_DNS_RPC_ENUM_ZONES_FILTER_get_dwFilter, py_DNS_RPC_ENUM_ZONES_FILTER_set_dwFilter },
	{ discard_const_p(char, "pszPartitionFqdn"), py_DNS_RPC_ENUM_ZONES_FILTER_get_pszPartitionFqdn, py_DNS_RPC_ENUM_ZONES_FILTER_set_pszPartitionFqdn },
	{ discard_const_p(char, "pszQueryString"), py_DNS_RPC_ENUM_ZONES_FILTER_get_pszQueryString, py_DNS_RPC_ENUM_ZONES_FILTER_set_pszQueryString },
	{ discard_const_p(char, "pszReserved"), py_DNS_RPC_ENUM_ZONES_FILTER_get_pszReserved, py_DNS_RPC_ENUM_ZONES_FILTER_set_pszReserved },
	{ NULL }
};

static PyObject *py_DNS_RPC_ENUM_ZONES_FILTER_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_ENUM_ZONES_FILTER, type);
}


static PyTypeObject DNS_RPC_ENUM_ZONES_FILTER_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.DNS_RPC_ENUM_ZONES_FILTER",
	.tp_getset = py_DNS_RPC_ENUM_ZONES_FILTER_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DNS_RPC_ENUM_ZONES_FILTER_new,
};


static PyObject *py_DNS_RPC_FORWARDERS_W2K_get_fRecurseAfterForwarding(PyObject *obj, void *closure)
{
	struct DNS_RPC_FORWARDERS_W2K *object = (struct DNS_RPC_FORWARDERS_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_fRecurseAfterForwarding;
	py_fRecurseAfterForwarding = PyInt_FromLong(object->fRecurseAfterForwarding);
	return py_fRecurseAfterForwarding;
}

static int py_DNS_RPC_FORWARDERS_W2K_set_fRecurseAfterForwarding(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_FORWARDERS_W2K *object = (struct DNS_RPC_FORWARDERS_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fRecurseAfterForwarding = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_FORWARDERS_W2K_get_dwForwardTimeout(PyObject *obj, void *closure)
{
	struct DNS_RPC_FORWARDERS_W2K *object = (struct DNS_RPC_FORWARDERS_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_dwForwardTimeout;
	py_dwForwardTimeout = PyInt_FromLong(object->dwForwardTimeout);
	return py_dwForwardTimeout;
}

static int py_DNS_RPC_FORWARDERS_W2K_set_dwForwardTimeout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_FORWARDERS_W2K *object = (struct DNS_RPC_FORWARDERS_W2K *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwForwardTimeout = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_FORWARDERS_W2K_get_aipForwarders(PyObject *obj, void *closure)
{
	struct DNS_RPC_FORWARDERS_W2K *object = (struct DNS_RPC_FORWARDERS_W2K *)pytalloc_get_ptr(obj);
	PyObject *py_aipForwarders;
	if (object->aipForwarders == NULL) {
		py_aipForwarders = Py_None;
		Py_INCREF(py_aipForwarders);
	} else {
		py_aipForwarders = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipForwarders, object->aipForwarders);
	}
	return py_aipForwarders;
}

static int py_DNS_RPC_FORWARDERS_W2K_set_aipForwarders(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_FORWARDERS_W2K *object = (struct DNS_RPC_FORWARDERS_W2K *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->aipForwarders);
	if (value == Py_None) {
		object->aipForwarders = NULL;
	} else {
		object->aipForwarders = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipForwarders = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_FORWARDERS_W2K_getsetters[] = {
	{ discard_const_p(char, "fRecurseAfterForwarding"), py_DNS_RPC_FORWARDERS_W2K_get_fRecurseAfterForwarding, py_DNS_RPC_FORWARDERS_W2K_set_fRecurseAfterForwarding },
	{ discard_const_p(char, "dwForwardTimeout"), py_DNS_RPC_FORWARDERS_W2K_get_dwForwardTimeout, py_DNS_RPC_FORWARDERS_W2K_set_dwForwardTimeout },
	{ discard_const_p(char, "aipForwarders"), py_DNS_RPC_FORWARDERS_W2K_get_aipForwarders, py_DNS_RPC_FORWARDERS_W2K_set_aipForwarders },
	{ NULL }
};

static PyObject *py_DNS_RPC_FORWARDERS_W2K_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_FORWARDERS_W2K, type);
}


static PyTypeObject DNS_RPC_FORWARDERS_W2K_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.DNS_RPC_FORWARDERS_W2K",
	.tp_getset = py_DNS_RPC_FORWARDERS_W2K_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DNS_RPC_FORWARDERS_W2K_new,
};


static PyObject *py_DNS_RPC_FORWARDERS_DOTNET_get_dwRpcStructureVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_FORWARDERS_DOTNET *object = (struct DNS_RPC_FORWARDERS_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwRpcStructureVersion;
	py_dwRpcStructureVersion = PyInt_FromLong(object->dwRpcStructureVersion);
	return py_dwRpcStructureVersion;
}

static int py_DNS_RPC_FORWARDERS_DOTNET_set_dwRpcStructureVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_FORWARDERS_DOTNET *object = (struct DNS_RPC_FORWARDERS_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwRpcStructureVersion = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_FORWARDERS_DOTNET_get_dwReserved0(PyObject *obj, void *closure)
{
	struct DNS_RPC_FORWARDERS_DOTNET *object = (struct DNS_RPC_FORWARDERS_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwReserved0;
	py_dwReserved0 = PyInt_FromLong(object->dwReserved0);
	return py_dwReserved0;
}

static int py_DNS_RPC_FORWARDERS_DOTNET_set_dwReserved0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_FORWARDERS_DOTNET *object = (struct DNS_RPC_FORWARDERS_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwReserved0 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_FORWARDERS_DOTNET_get_fRecurseAfterForwarding(PyObject *obj, void *closure)
{
	struct DNS_RPC_FORWARDERS_DOTNET *object = (struct DNS_RPC_FORWARDERS_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_fRecurseAfterForwarding;
	py_fRecurseAfterForwarding = PyInt_FromLong(object->fRecurseAfterForwarding);
	return py_fRecurseAfterForwarding;
}

static int py_DNS_RPC_FORWARDERS_DOTNET_set_fRecurseAfterForwarding(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_FORWARDERS_DOTNET *object = (struct DNS_RPC_FORWARDERS_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fRecurseAfterForwarding = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_FORWARDERS_DOTNET_get_dwForwardTimeout(PyObject *obj, void *closure)
{
	struct DNS_RPC_FORWARDERS_DOTNET *object = (struct DNS_RPC_FORWARDERS_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_dwForwardTimeout;
	py_dwForwardTimeout = PyInt_FromLong(object->dwForwardTimeout);
	return py_dwForwardTimeout;
}

static int py_DNS_RPC_FORWARDERS_DOTNET_set_dwForwardTimeout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_FORWARDERS_DOTNET *object = (struct DNS_RPC_FORWARDERS_DOTNET *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwForwardTimeout = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_FORWARDERS_DOTNET_get_aipForwarders(PyObject *obj, void *closure)
{
	struct DNS_RPC_FORWARDERS_DOTNET *object = (struct DNS_RPC_FORWARDERS_DOTNET *)pytalloc_get_ptr(obj);
	PyObject *py_aipForwarders;
	if (object->aipForwarders == NULL) {
		py_aipForwarders = Py_None;
		Py_INCREF(py_aipForwarders);
	} else {
		py_aipForwarders = pytalloc_reference_ex(&IP4_ARRAY_Type, object->aipForwarders, object->aipForwarders);
	}
	return py_aipForwarders;
}

static int py_DNS_RPC_FORWARDERS_DOTNET_set_aipForwarders(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_FORWARDERS_DOTNET *object = (struct DNS_RPC_FORWARDERS_DOTNET *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->aipForwarders);
	if (value == Py_None) {
		object->aipForwarders = NULL;
	} else {
		object->aipForwarders = NULL;
		PY_CHECK_TYPE(&IP4_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipForwarders = (struct IP4_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_FORWARDERS_DOTNET_getsetters[] = {
	{ discard_const_p(char, "dwRpcStructureVersion"), py_DNS_RPC_FORWARDERS_DOTNET_get_dwRpcStructureVersion, py_DNS_RPC_FORWARDERS_DOTNET_set_dwRpcStructureVersion },
	{ discard_const_p(char, "dwReserved0"), py_DNS_RPC_FORWARDERS_DOTNET_get_dwReserved0, py_DNS_RPC_FORWARDERS_DOTNET_set_dwReserved0 },
	{ discard_const_p(char, "fRecurseAfterForwarding"), py_DNS_RPC_FORWARDERS_DOTNET_get_fRecurseAfterForwarding, py_DNS_RPC_FORWARDERS_DOTNET_set_fRecurseAfterForwarding },
	{ discard_const_p(char, "dwForwardTimeout"), py_DNS_RPC_FORWARDERS_DOTNET_get_dwForwardTimeout, py_DNS_RPC_FORWARDERS_DOTNET_set_dwForwardTimeout },
	{ discard_const_p(char, "aipForwarders"), py_DNS_RPC_FORWARDERS_DOTNET_get_aipForwarders, py_DNS_RPC_FORWARDERS_DOTNET_set_aipForwarders },
	{ NULL }
};

static PyObject *py_DNS_RPC_FORWARDERS_DOTNET_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_FORWARDERS_DOTNET, type);
}


static PyTypeObject DNS_RPC_FORWARDERS_DOTNET_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.DNS_RPC_FORWARDERS_DOTNET",
	.tp_getset = py_DNS_RPC_FORWARDERS_DOTNET_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DNS_RPC_FORWARDERS_DOTNET_new,
};


static PyObject *py_DNS_RPC_FORWARDERS_LONGHORN_get_dwRpcStructureVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_FORWARDERS_LONGHORN *object = (struct DNS_RPC_FORWARDERS_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_dwRpcStructureVersion;
	py_dwRpcStructureVersion = PyInt_FromLong(object->dwRpcStructureVersion);
	return py_dwRpcStructureVersion;
}

static int py_DNS_RPC_FORWARDERS_LONGHORN_set_dwRpcStructureVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_FORWARDERS_LONGHORN *object = (struct DNS_RPC_FORWARDERS_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwRpcStructureVersion = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_FORWARDERS_LONGHORN_get_dwReserved0(PyObject *obj, void *closure)
{
	struct DNS_RPC_FORWARDERS_LONGHORN *object = (struct DNS_RPC_FORWARDERS_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_dwReserved0;
	py_dwReserved0 = PyInt_FromLong(object->dwReserved0);
	return py_dwReserved0;
}

static int py_DNS_RPC_FORWARDERS_LONGHORN_set_dwReserved0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_FORWARDERS_LONGHORN *object = (struct DNS_RPC_FORWARDERS_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwReserved0 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_FORWARDERS_LONGHORN_get_fRecurseAfterForwarding(PyObject *obj, void *closure)
{
	struct DNS_RPC_FORWARDERS_LONGHORN *object = (struct DNS_RPC_FORWARDERS_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_fRecurseAfterForwarding;
	py_fRecurseAfterForwarding = PyInt_FromLong(object->fRecurseAfterForwarding);
	return py_fRecurseAfterForwarding;
}

static int py_DNS_RPC_FORWARDERS_LONGHORN_set_fRecurseAfterForwarding(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_FORWARDERS_LONGHORN *object = (struct DNS_RPC_FORWARDERS_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fRecurseAfterForwarding = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_FORWARDERS_LONGHORN_get_dwForwardTimeout(PyObject *obj, void *closure)
{
	struct DNS_RPC_FORWARDERS_LONGHORN *object = (struct DNS_RPC_FORWARDERS_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_dwForwardTimeout;
	py_dwForwardTimeout = PyInt_FromLong(object->dwForwardTimeout);
	return py_dwForwardTimeout;
}

static int py_DNS_RPC_FORWARDERS_LONGHORN_set_dwForwardTimeout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_FORWARDERS_LONGHORN *object = (struct DNS_RPC_FORWARDERS_LONGHORN *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwForwardTimeout = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_FORWARDERS_LONGHORN_get_aipForwarders(PyObject *obj, void *closure)
{
	struct DNS_RPC_FORWARDERS_LONGHORN *object = (struct DNS_RPC_FORWARDERS_LONGHORN *)pytalloc_get_ptr(obj);
	PyObject *py_aipForwarders;
	if (object->aipForwarders == NULL) {
		py_aipForwarders = Py_None;
		Py_INCREF(py_aipForwarders);
	} else {
		py_aipForwarders = pytalloc_reference_ex(&DNS_ADDR_ARRAY_Type, object->aipForwarders, object->aipForwarders);
	}
	return py_aipForwarders;
}

static int py_DNS_RPC_FORWARDERS_LONGHORN_set_aipForwarders(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_FORWARDERS_LONGHORN *object = (struct DNS_RPC_FORWARDERS_LONGHORN *)pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), object->aipForwarders);
	if (value == Py_None) {
		object->aipForwarders = NULL;
	} else {
		object->aipForwarders = NULL;
		PY_CHECK_TYPE(&DNS_ADDR_ARRAY_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->aipForwarders = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_FORWARDERS_LONGHORN_getsetters[] = {
	{ discard_const_p(char, "dwRpcStructureVersion"), py_DNS_RPC_FORWARDERS_LONGHORN_get_dwRpcStructureVersion, py_DNS_RPC_FORWARDERS_LONGHORN_set_dwRpcStructureVersion },
	{ discard_const_p(char, "dwReserved0"), py_DNS_RPC_FORWARDERS_LONGHORN_get_dwReserved0, py_DNS_RPC_FORWARDERS_LONGHORN_set_dwReserved0 },
	{ discard_const_p(char, "fRecurseAfterForwarding"), py_DNS_RPC_FORWARDERS_LONGHORN_get_fRecurseAfterForwarding, py_DNS_RPC_FORWARDERS_LONGHORN_set_fRecurseAfterForwarding },
	{ discard_const_p(char, "dwForwardTimeout"), py_DNS_RPC_FORWARDERS_LONGHORN_get_dwForwardTimeout, py_DNS_RPC_FORWARDERS_LONGHORN_set_dwForwardTimeout },
	{ discard_const_p(char, "aipForwarders"), py_DNS_RPC_FORWARDERS_LONGHORN_get_aipForwarders, py_DNS_RPC_FORWARDERS_LONGHORN_set_aipForwarders },
	{ NULL }
};

static PyObject *py_DNS_RPC_FORWARDERS_LONGHORN_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_FORWARDERS_LONGHORN, type);
}


static PyTypeObject DNS_RPC_FORWARDERS_LONGHORN_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.DNS_RPC_FORWARDERS_LONGHORN",
	.tp_getset = py_DNS_RPC_FORWARDERS_LONGHORN_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DNS_RPC_FORWARDERS_LONGHORN_new,
};


static PyObject *py_DNS_RPC_AUTOCONFIGURE_get_dwRpcStructureVersion(PyObject *obj, void *closure)
{
	struct DNS_RPC_AUTOCONFIGURE *object = (struct DNS_RPC_AUTOCONFIGURE *)pytalloc_get_ptr(obj);
	PyObject *py_dwRpcStructureVersion;
	py_dwRpcStructureVersion = PyInt_FromLong(object->dwRpcStructureVersion);
	return py_dwRpcStructureVersion;
}

static int py_DNS_RPC_AUTOCONFIGURE_set_dwRpcStructureVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_AUTOCONFIGURE *object = (struct DNS_RPC_AUTOCONFIGURE *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwRpcStructureVersion = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_AUTOCONFIGURE_get_dwReserved0(PyObject *obj, void *closure)
{
	struct DNS_RPC_AUTOCONFIGURE *object = (struct DNS_RPC_AUTOCONFIGURE *)pytalloc_get_ptr(obj);
	PyObject *py_dwReserved0;
	py_dwReserved0 = PyInt_FromLong(object->dwReserved0);
	return py_dwReserved0;
}

static int py_DNS_RPC_AUTOCONFIGURE_set_dwReserved0(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_AUTOCONFIGURE *object = (struct DNS_RPC_AUTOCONFIGURE *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwReserved0 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_AUTOCONFIGURE_get_dwAutoConfigFlags(PyObject *obj, void *closure)
{
	struct DNS_RPC_AUTOCONFIGURE *object = (struct DNS_RPC_AUTOCONFIGURE *)pytalloc_get_ptr(obj);
	PyObject *py_dwAutoConfigFlags;
	py_dwAutoConfigFlags = PyInt_FromLong(object->dwAutoConfigFlags);
	return py_dwAutoConfigFlags;
}

static int py_DNS_RPC_AUTOCONFIGURE_set_dwAutoConfigFlags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_AUTOCONFIGURE *object = (struct DNS_RPC_AUTOCONFIGURE *)pytalloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->dwAutoConfigFlags = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->dwAutoConfigFlags = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_DNS_RPC_AUTOCONFIGURE_get_dwReserved1(PyObject *obj, void *closure)
{
	struct DNS_RPC_AUTOCONFIGURE *object = (struct DNS_RPC_AUTOCONFIGURE *)pytalloc_get_ptr(obj);
	PyObject *py_dwReserved1;
	py_dwReserved1 = PyInt_FromLong(object->dwReserved1);
	return py_dwReserved1;
}

static int py_DNS_RPC_AUTOCONFIGURE_set_dwReserved1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_AUTOCONFIGURE *object = (struct DNS_RPC_AUTOCONFIGURE *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwReserved1 = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_AUTOCONFIGURE_get_pszNewDomainName(PyObject *obj, void *closure)
{
	struct DNS_RPC_AUTOCONFIGURE *object = (struct DNS_RPC_AUTOCONFIGURE *)pytalloc_get_ptr(obj);
	PyObject *py_pszNewDomainName;
	if (object->pszNewDomainName == NULL) {
		py_pszNewDomainName = Py_None;
		Py_INCREF(py_pszNewDomainName);
	} else {
		if (object->pszNewDomainName == NULL) {
			py_pszNewDomainName = Py_None;
			Py_INCREF(py_pszNewDomainName);
		} else {
			py_pszNewDomainName = PyUnicode_Decode(object->pszNewDomainName, strlen(object->pszNewDomainName), "utf-8", "ignore");
		}
	}
	return py_pszNewDomainName;
}

static int py_DNS_RPC_AUTOCONFIGURE_set_pszNewDomainName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_AUTOCONFIGURE *object = (struct DNS_RPC_AUTOCONFIGURE *)pytalloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->pszNewDomainName = NULL;
	} else {
		object->pszNewDomainName = NULL;
		if (PyUnicode_Check(value)) {
			object->pszNewDomainName = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->pszNewDomainName = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_AUTOCONFIGURE_getsetters[] = {
	{ discard_const_p(char, "dwRpcStructureVersion"), py_DNS_RPC_AUTOCONFIGURE_get_dwRpcStructureVersion, py_DNS_RPC_AUTOCONFIGURE_set_dwRpcStructureVersion },
	{ discard_const_p(char, "dwReserved0"), py_DNS_RPC_AUTOCONFIGURE_get_dwReserved0, py_DNS_RPC_AUTOCONFIGURE_set_dwReserved0 },
	{ discard_const_p(char, "dwAutoConfigFlags"), py_DNS_RPC_AUTOCONFIGURE_get_dwAutoConfigFlags, py_DNS_RPC_AUTOCONFIGURE_set_dwAutoConfigFlags },
	{ discard_const_p(char, "dwReserved1"), py_DNS_RPC_AUTOCONFIGURE_get_dwReserved1, py_DNS_RPC_AUTOCONFIGURE_set_dwReserved1 },
	{ discard_const_p(char, "pszNewDomainName"), py_DNS_RPC_AUTOCONFIGURE_get_pszNewDomainName, py_DNS_RPC_AUTOCONFIGURE_set_pszNewDomainName },
	{ NULL }
};

static PyObject *py_DNS_RPC_AUTOCONFIGURE_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_AUTOCONFIGURE, type);
}


static PyTypeObject DNS_RPC_AUTOCONFIGURE_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.DNS_RPC_AUTOCONFIGURE",
	.tp_getset = py_DNS_RPC_AUTOCONFIGURE_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DNS_RPC_AUTOCONFIGURE_new,
};


static PyObject *py_DNSSRV_STAT_HEADER_get_StatId(PyObject *obj, void *closure)
{
	struct DNSSRV_STAT_HEADER *object = (struct DNSSRV_STAT_HEADER *)pytalloc_get_ptr(obj);
	PyObject *py_StatId;
	py_StatId = PyInt_FromLong(object->StatId);
	return py_StatId;
}

static int py_DNSSRV_STAT_HEADER_set_StatId(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNSSRV_STAT_HEADER *object = (struct DNSSRV_STAT_HEADER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->StatId = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNSSRV_STAT_HEADER_get_wLength(PyObject *obj, void *closure)
{
	struct DNSSRV_STAT_HEADER *object = (struct DNSSRV_STAT_HEADER *)pytalloc_get_ptr(obj);
	PyObject *py_wLength;
	py_wLength = PyInt_FromLong(object->wLength);
	return py_wLength;
}

static int py_DNSSRV_STAT_HEADER_set_wLength(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNSSRV_STAT_HEADER *object = (struct DNSSRV_STAT_HEADER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->wLength = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNSSRV_STAT_HEADER_get_fClear(PyObject *obj, void *closure)
{
	struct DNSSRV_STAT_HEADER *object = (struct DNSSRV_STAT_HEADER *)pytalloc_get_ptr(obj);
	PyObject *py_fClear;
	py_fClear = PyInt_FromLong(object->fClear);
	return py_fClear;
}

static int py_DNSSRV_STAT_HEADER_set_fClear(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNSSRV_STAT_HEADER *object = (struct DNSSRV_STAT_HEADER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fClear = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNSSRV_STAT_HEADER_get_fReserved(PyObject *obj, void *closure)
{
	struct DNSSRV_STAT_HEADER *object = (struct DNSSRV_STAT_HEADER *)pytalloc_get_ptr(obj);
	PyObject *py_fReserved;
	py_fReserved = PyInt_FromLong(object->fReserved);
	return py_fReserved;
}

static int py_DNSSRV_STAT_HEADER_set_fReserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNSSRV_STAT_HEADER *object = (struct DNSSRV_STAT_HEADER *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->fReserved = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_DNSSRV_STAT_HEADER_getsetters[] = {
	{ discard_const_p(char, "StatId"), py_DNSSRV_STAT_HEADER_get_StatId, py_DNSSRV_STAT_HEADER_set_StatId },
	{ discard_const_p(char, "wLength"), py_DNSSRV_STAT_HEADER_get_wLength, py_DNSSRV_STAT_HEADER_set_wLength },
	{ discard_const_p(char, "fClear"), py_DNSSRV_STAT_HEADER_get_fClear, py_DNSSRV_STAT_HEADER_set_fClear },
	{ discard_const_p(char, "fReserved"), py_DNSSRV_STAT_HEADER_get_fReserved, py_DNSSRV_STAT_HEADER_set_fReserved },
	{ NULL }
};

static PyObject *py_DNSSRV_STAT_HEADER_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNSSRV_STAT_HEADER, type);
}


static PyTypeObject DNSSRV_STAT_HEADER_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.DNSSRV_STAT_HEADER",
	.tp_getset = py_DNSSRV_STAT_HEADER_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DNSSRV_STAT_HEADER_new,
};


static PyObject *py_DNSSRV_STAT_get_Header(PyObject *obj, void *closure)
{
	struct DNSSRV_STAT *object = (struct DNSSRV_STAT *)pytalloc_get_ptr(obj);
	PyObject *py_Header;
	py_Header = pytalloc_reference_ex(&DNSSRV_STAT_HEADER_Type, pytalloc_get_mem_ctx(obj), &object->Header);
	return py_Header;
}

static int py_DNSSRV_STAT_set_Header(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNSSRV_STAT *object = (struct DNSSRV_STAT *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&DNSSRV_STAT_HEADER_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->Header = *(struct DNSSRV_STAT_HEADER *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_DNSSRV_STAT_get_Buffer(PyObject *obj, void *closure)
{
	struct DNSSRV_STAT *object = (struct DNSSRV_STAT *)pytalloc_get_ptr(obj);
	PyObject *py_Buffer;
	py_Buffer = PyList_New(1);
	if (py_Buffer == NULL) {
		return NULL;
	}
	{
		int Buffer_cntr_0;
		for (Buffer_cntr_0 = 0; Buffer_cntr_0 < 1; Buffer_cntr_0++) {
			PyObject *py_Buffer_0;
			py_Buffer_0 = PyInt_FromLong(object->Buffer[Buffer_cntr_0]);
			PyList_SetItem(py_Buffer, Buffer_cntr_0, py_Buffer_0);
		}
	}
	return py_Buffer;
}

static int py_DNSSRV_STAT_set_Buffer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNSSRV_STAT *object = (struct DNSSRV_STAT *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int Buffer_cntr_0;
		for (Buffer_cntr_0 = 0; Buffer_cntr_0 < PyList_GET_SIZE(value); Buffer_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, Buffer_cntr_0), return -1;);
			object->Buffer[Buffer_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, Buffer_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_DNSSRV_STAT_getsetters[] = {
	{ discard_const_p(char, "Header"), py_DNSSRV_STAT_get_Header, py_DNSSRV_STAT_set_Header },
	{ discard_const_p(char, "Buffer"), py_DNSSRV_STAT_get_Buffer, py_DNSSRV_STAT_set_Buffer },
	{ NULL }
};

static PyObject *py_DNSSRV_STAT_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNSSRV_STAT, type);
}


static PyTypeObject DNSSRV_STAT_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.DNSSRV_STAT",
	.tp_getset = py_DNSSRV_STAT_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DNSSRV_STAT_new,
};

PyObject *py_import_DNSSRV_RPC_UNION(TALLOC_CTX *mem_ctx, int level, union DNSSRV_RPC_UNION *in)
{
	PyObject *ret;

	switch (level) {
		case DNSSRV_TYPEID_NULL:
			if (in->Null == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = PyInt_FromLong(*in->Null);
			}
			return ret;

		case DNSSRV_TYPEID_DWORD:
			ret = PyInt_FromLong(in->Dword);
			return ret;

		case DNSSRV_TYPEID_LPSTR:
			if (in->String == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				if (in->String == NULL) {
					ret = Py_None;
					Py_INCREF(ret);
				} else {
					ret = PyUnicode_Decode(in->String, strlen(in->String), "utf-8", "ignore");
				}
			}
			return ret;

		case DNSSRV_TYPEID_LPWSTR:
			if (in->WideString == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				if (in->WideString == NULL) {
					ret = Py_None;
					Py_INCREF(ret);
				} else {
					ret = PyUnicode_Decode(in->WideString, strlen(in->WideString), "utf-8", "ignore");
				}
			}
			return ret;

		case DNSSRV_TYPEID_IPARRAY:
			if (in->IpArray == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&IP4_ARRAY_Type, in->IpArray, in->IpArray);
			}
			return ret;

		case DNSSRV_TYPEID_BUFFER:
			if (in->Buffer == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_BUFFER_Type, in->Buffer, in->Buffer);
			}
			return ret;

		case DNSSRV_TYPEID_SERVER_INFO_W2K:
			if (in->ServerInfoW2K == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_SERVER_INFO_W2K_Type, in->ServerInfoW2K, in->ServerInfoW2K);
			}
			return ret;

		case DNSSRV_TYPEID_STATS:
			if (in->Stats == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNSSRV_STAT_Type, in->Stats, in->Stats);
			}
			return ret;

		case DNSSRV_TYPEID_FORWARDERS_W2K:
			if (in->ForwardersW2K == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_FORWARDERS_W2K_Type, in->ForwardersW2K, in->ForwardersW2K);
			}
			return ret;

		case DNSSRV_TYPEID_ZONE_W2K:
			if (in->ZoneW2K == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_ZONE_W2K_Type, in->ZoneW2K, in->ZoneW2K);
			}
			return ret;

		case DNSSRV_TYPEID_ZONE_INFO_W2K:
			if (in->ZoneInfoW2K == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_ZONE_INFO_W2K_Type, in->ZoneInfoW2K, in->ZoneInfoW2K);
			}
			return ret;

		case DNSSRV_TYPEID_ZONE_SECONDARIES_W2K:
			if (in->SecondariesW2K == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_ZONE_SECONDARIES_W2K_Type, in->SecondariesW2K, in->SecondariesW2K);
			}
			return ret;

		case DNSSRV_TYPEID_ZONE_DATABASE_W2K:
			if (in->DatabaseW2K == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_ZONE_DATABASE_W2K_Type, in->DatabaseW2K, in->DatabaseW2K);
			}
			return ret;

		case DNSSRV_TYPEID_ZONE_CREATE_W2K:
			if (in->ZoneCreateW2K == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_ZONE_CREATE_INFO_W2K_Type, in->ZoneCreateW2K, in->ZoneCreateW2K);
			}
			return ret;

		case DNSSRV_TYPEID_NAME_AND_PARAM:
			if (in->NameAndParam == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_NAME_AND_PARAM_Type, in->NameAndParam, in->NameAndParam);
			}
			return ret;

		case DNSSRV_TYPEID_ZONE_LIST_W2K:
			if (in->ZoneListW2K == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_ZONE_LIST_W2K_Type, in->ZoneListW2K, in->ZoneListW2K);
			}
			return ret;

		case DNSSRV_TYPEID_SERVER_INFO_DOTNET:
			if (in->ServerInfoDotNet == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_SERVER_INFO_DOTNET_Type, in->ServerInfoDotNet, in->ServerInfoDotNet);
			}
			return ret;

		case DNSSRV_TYPEID_FORWARDERS_DOTNET:
			if (in->ForwardersDotNet == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_FORWARDERS_DOTNET_Type, in->ForwardersDotNet, in->ForwardersDotNet);
			}
			return ret;

		case DNSSRV_TYPEID_ZONE:
			if (in->Zone == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_ZONE_DOTNET_Type, in->Zone, in->Zone);
			}
			return ret;

		case DNSSRV_TYPEID_ZONE_INFO_DOTNET:
			if (in->ZoneInfoDotNet == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_ZONE_INFO_DOTNET_Type, in->ZoneInfoDotNet, in->ZoneInfoDotNet);
			}
			return ret;

		case DNSSRV_TYPEID_ZONE_SECONDARIES_DOTNET:
			if (in->SecondariesDotNet == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_ZONE_SECONDARIES_DOTNET_Type, in->SecondariesDotNet, in->SecondariesDotNet);
			}
			return ret;

		case DNSSRV_TYPEID_ZONE_DATABASE:
			if (in->Database == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_ZONE_DATABASE_DOTNET_Type, in->Database, in->Database);
			}
			return ret;

		case DNSSRV_TYPEID_ZONE_CREATE_DOTNET:
			if (in->ZoneCreateDotNet == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_ZONE_CREATE_INFO_DOTNET_Type, in->ZoneCreateDotNet, in->ZoneCreateDotNet);
			}
			return ret;

		case DNSSRV_TYPEID_ZONE_LIST:
			if (in->ZoneList == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_ZONE_LIST_DOTNET_Type, in->ZoneList, in->ZoneList);
			}
			return ret;

		case DNSSRV_TYPEID_ZONE_EXPORT:
			if (in->ZoneExport == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_ZONE_EXPORT_INFO_Type, in->ZoneExport, in->ZoneExport);
			}
			return ret;

		case DNSSRV_TYPEID_DP_INFO:
			if (in->DirectoryPartition == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_DP_INFO_Type, in->DirectoryPartition, in->DirectoryPartition);
			}
			return ret;

		case DNSSRV_TYPEID_DP_ENUM:
			if (in->DirectoryPartitionEnum == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_DP_ENUM_Type, in->DirectoryPartitionEnum, in->DirectoryPartitionEnum);
			}
			return ret;

		case DNSSRV_TYPEID_DP_LIST:
			if (in->DirectoryPartitionList == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_DP_LIST_Type, in->DirectoryPartitionList, in->DirectoryPartitionList);
			}
			return ret;

		case DNSSRV_TYPEID_ENLIST_DP:
			if (in->EnlistDirectoryPartition == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_ENLIST_DP_Type, in->EnlistDirectoryPartition, in->EnlistDirectoryPartition);
			}
			return ret;

		case DNSSRV_TYPEID_ZONE_CHANGE_DP:
			if (in->ZoneChangeDirectoryPartition == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_ZONE_CHANGE_DP_Type, in->ZoneChangeDirectoryPartition, in->ZoneChangeDirectoryPartition);
			}
			return ret;

		case DNSSRV_TYPEID_ENUM_ZONES_FILTER:
			if (in->EnumZonesFilter == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_ENUM_ZONES_FILTER_Type, in->EnumZonesFilter, in->EnumZonesFilter);
			}
			return ret;

		case DNSSRV_TYPEID_ADDRARRAY:
			if (in->AddrArray == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_ADDR_ARRAY_Type, in->AddrArray, in->AddrArray);
			}
			return ret;

		case DNSSRV_TYPEID_SERVER_INFO:
			if (in->ServerInfo == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_SERVER_INFO_LONGHORN_Type, in->ServerInfo, in->ServerInfo);
			}
			return ret;

		case DNSSRV_TYPEID_ZONE_CREATE:
			if (in->ZoneCreate == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_ZONE_CREATE_INFO_LONGHORN_Type, in->ZoneCreate, in->ZoneCreate);
			}
			return ret;

		case DNSSRV_TYPEID_FORWARDERS:
			if (in->Forwarders == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_FORWARDERS_LONGHORN_Type, in->Forwarders, in->Forwarders);
			}
			return ret;

		case DNSSRV_TYPEID_ZONE_SECONDARIES:
			if (in->Secondaries == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_ZONE_SECONDARIES_LONGHORN_Type, in->Secondaries, in->Secondaries);
			}
			return ret;

		case DNSSRV_TYPEID_IP_VALIDATE:
			if (in->IpValidate == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_IP_VALIDATE_Type, in->IpValidate, in->IpValidate);
			}
			return ret;

		case DNSSRV_TYPEID_ZONE_INFO:
			if (in->ZoneInfo == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_ZONE_INFO_LONGHORN_Type, in->ZoneInfo, in->ZoneInfo);
			}
			return ret;

		case DNSSRV_TYPEID_AUTOCONFIGURE:
			if (in->AutoConfigure == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_AUTOCONFIGURE_Type, in->AutoConfigure, in->AutoConfigure);
			}
			return ret;

		case DNSSRV_TYPEID_UTF8_STRING_LIST:
			if (in->Utf8StringList == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&DNS_RPC_UTF8_STRING_LIST_Type, in->Utf8StringList, in->Utf8StringList);
			}
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union DNSSRV_RPC_UNION *py_export_DNSSRV_RPC_UNION(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union DNSSRV_RPC_UNION *ret = talloc_zero(mem_ctx, union DNSSRV_RPC_UNION);
	switch (level) {
		case DNSSRV_TYPEID_NULL:
			if (in == Py_None) {
				ret->Null = NULL;
			} else {
				ret->Null = talloc_ptrtype(mem_ctx, ret->Null);
				PY_CHECK_TYPE(&PyInt_Type, in, talloc_free(ret); return NULL;);
				*ret->Null = PyInt_AsLong(in);
			}
			break;

		case DNSSRV_TYPEID_DWORD:
			PY_CHECK_TYPE(&PyInt_Type, in, talloc_free(ret); return NULL;);
			ret->Dword = PyInt_AsLong(in);
			break;

		case DNSSRV_TYPEID_LPSTR:
			if (in == Py_None) {
				ret->String = NULL;
			} else {
				ret->String = NULL;
				if (PyUnicode_Check(in)) {
					ret->String = PyString_AS_STRING(PyUnicode_AsEncodedString(in, "utf-8", "ignore"));
				} else if (PyString_Check(in)) {
					ret->String = PyString_AS_STRING(in);
				} else {
					PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case DNSSRV_TYPEID_LPWSTR:
			if (in == Py_None) {
				ret->WideString = NULL;
			} else {
				ret->WideString = NULL;
				if (PyUnicode_Check(in)) {
					ret->WideString = PyString_AS_STRING(PyUnicode_AsEncodedString(in, "utf-8", "ignore"));
				} else if (PyString_Check(in)) {
					ret->WideString = PyString_AS_STRING(in);
				} else {
					PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case DNSSRV_TYPEID_IPARRAY:
			if (in == Py_None) {
				ret->IpArray = NULL;
			} else {
				ret->IpArray = NULL;
				PY_CHECK_TYPE(&IP4_ARRAY_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->IpArray = (struct IP4_ARRAY *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_BUFFER:
			if (in == Py_None) {
				ret->Buffer = NULL;
			} else {
				ret->Buffer = NULL;
				PY_CHECK_TYPE(&DNS_RPC_BUFFER_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->Buffer = (struct DNS_RPC_BUFFER *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_SERVER_INFO_W2K:
			if (in == Py_None) {
				ret->ServerInfoW2K = NULL;
			} else {
				ret->ServerInfoW2K = NULL;
				PY_CHECK_TYPE(&DNS_RPC_SERVER_INFO_W2K_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ServerInfoW2K = (struct DNS_RPC_SERVER_INFO_W2K *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_STATS:
			if (in == Py_None) {
				ret->Stats = NULL;
			} else {
				ret->Stats = NULL;
				PY_CHECK_TYPE(&DNSSRV_STAT_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->Stats = (struct DNSSRV_STAT *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_FORWARDERS_W2K:
			if (in == Py_None) {
				ret->ForwardersW2K = NULL;
			} else {
				ret->ForwardersW2K = NULL;
				PY_CHECK_TYPE(&DNS_RPC_FORWARDERS_W2K_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ForwardersW2K = (struct DNS_RPC_FORWARDERS_W2K *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_ZONE_W2K:
			if (in == Py_None) {
				ret->ZoneW2K = NULL;
			} else {
				ret->ZoneW2K = NULL;
				PY_CHECK_TYPE(&DNS_RPC_ZONE_W2K_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ZoneW2K = (struct DNS_RPC_ZONE_W2K *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_ZONE_INFO_W2K:
			if (in == Py_None) {
				ret->ZoneInfoW2K = NULL;
			} else {
				ret->ZoneInfoW2K = NULL;
				PY_CHECK_TYPE(&DNS_RPC_ZONE_INFO_W2K_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ZoneInfoW2K = (struct DNS_RPC_ZONE_INFO_W2K *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_ZONE_SECONDARIES_W2K:
			if (in == Py_None) {
				ret->SecondariesW2K = NULL;
			} else {
				ret->SecondariesW2K = NULL;
				PY_CHECK_TYPE(&DNS_RPC_ZONE_SECONDARIES_W2K_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->SecondariesW2K = (struct DNS_RPC_ZONE_SECONDARIES_W2K *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_ZONE_DATABASE_W2K:
			if (in == Py_None) {
				ret->DatabaseW2K = NULL;
			} else {
				ret->DatabaseW2K = NULL;
				PY_CHECK_TYPE(&DNS_RPC_ZONE_DATABASE_W2K_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->DatabaseW2K = (struct DNS_RPC_ZONE_DATABASE_W2K *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_ZONE_CREATE_W2K:
			if (in == Py_None) {
				ret->ZoneCreateW2K = NULL;
			} else {
				ret->ZoneCreateW2K = NULL;
				PY_CHECK_TYPE(&DNS_RPC_ZONE_CREATE_INFO_W2K_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ZoneCreateW2K = (struct DNS_RPC_ZONE_CREATE_INFO_W2K *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_NAME_AND_PARAM:
			if (in == Py_None) {
				ret->NameAndParam = NULL;
			} else {
				ret->NameAndParam = NULL;
				PY_CHECK_TYPE(&DNS_RPC_NAME_AND_PARAM_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->NameAndParam = (struct DNS_RPC_NAME_AND_PARAM *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_ZONE_LIST_W2K:
			if (in == Py_None) {
				ret->ZoneListW2K = NULL;
			} else {
				ret->ZoneListW2K = NULL;
				PY_CHECK_TYPE(&DNS_RPC_ZONE_LIST_W2K_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ZoneListW2K = (struct DNS_RPC_ZONE_LIST_W2K *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_SERVER_INFO_DOTNET:
			if (in == Py_None) {
				ret->ServerInfoDotNet = NULL;
			} else {
				ret->ServerInfoDotNet = NULL;
				PY_CHECK_TYPE(&DNS_RPC_SERVER_INFO_DOTNET_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ServerInfoDotNet = (struct DNS_RPC_SERVER_INFO_DOTNET *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_FORWARDERS_DOTNET:
			if (in == Py_None) {
				ret->ForwardersDotNet = NULL;
			} else {
				ret->ForwardersDotNet = NULL;
				PY_CHECK_TYPE(&DNS_RPC_FORWARDERS_DOTNET_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ForwardersDotNet = (struct DNS_RPC_FORWARDERS_DOTNET *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_ZONE:
			if (in == Py_None) {
				ret->Zone = NULL;
			} else {
				ret->Zone = NULL;
				PY_CHECK_TYPE(&DNS_RPC_ZONE_DOTNET_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->Zone = (struct DNS_RPC_ZONE_DOTNET *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_ZONE_INFO_DOTNET:
			if (in == Py_None) {
				ret->ZoneInfoDotNet = NULL;
			} else {
				ret->ZoneInfoDotNet = NULL;
				PY_CHECK_TYPE(&DNS_RPC_ZONE_INFO_DOTNET_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ZoneInfoDotNet = (struct DNS_RPC_ZONE_INFO_DOTNET *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_ZONE_SECONDARIES_DOTNET:
			if (in == Py_None) {
				ret->SecondariesDotNet = NULL;
			} else {
				ret->SecondariesDotNet = NULL;
				PY_CHECK_TYPE(&DNS_RPC_ZONE_SECONDARIES_DOTNET_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->SecondariesDotNet = (struct DNS_RPC_ZONE_SECONDARIES_DOTNET *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_ZONE_DATABASE:
			if (in == Py_None) {
				ret->Database = NULL;
			} else {
				ret->Database = NULL;
				PY_CHECK_TYPE(&DNS_RPC_ZONE_DATABASE_DOTNET_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->Database = (struct DNS_RPC_ZONE_DATABASE_DOTNET *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_ZONE_CREATE_DOTNET:
			if (in == Py_None) {
				ret->ZoneCreateDotNet = NULL;
			} else {
				ret->ZoneCreateDotNet = NULL;
				PY_CHECK_TYPE(&DNS_RPC_ZONE_CREATE_INFO_DOTNET_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ZoneCreateDotNet = (struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_ZONE_LIST:
			if (in == Py_None) {
				ret->ZoneList = NULL;
			} else {
				ret->ZoneList = NULL;
				PY_CHECK_TYPE(&DNS_RPC_ZONE_LIST_DOTNET_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ZoneList = (struct DNS_RPC_ZONE_LIST_DOTNET *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_ZONE_EXPORT:
			if (in == Py_None) {
				ret->ZoneExport = NULL;
			} else {
				ret->ZoneExport = NULL;
				PY_CHECK_TYPE(&DNS_RPC_ZONE_EXPORT_INFO_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ZoneExport = (struct DNS_RPC_ZONE_EXPORT_INFO *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_DP_INFO:
			if (in == Py_None) {
				ret->DirectoryPartition = NULL;
			} else {
				ret->DirectoryPartition = NULL;
				PY_CHECK_TYPE(&DNS_RPC_DP_INFO_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->DirectoryPartition = (struct DNS_RPC_DP_INFO *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_DP_ENUM:
			if (in == Py_None) {
				ret->DirectoryPartitionEnum = NULL;
			} else {
				ret->DirectoryPartitionEnum = NULL;
				PY_CHECK_TYPE(&DNS_RPC_DP_ENUM_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->DirectoryPartitionEnum = (struct DNS_RPC_DP_ENUM *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_DP_LIST:
			if (in == Py_None) {
				ret->DirectoryPartitionList = NULL;
			} else {
				ret->DirectoryPartitionList = NULL;
				PY_CHECK_TYPE(&DNS_RPC_DP_LIST_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->DirectoryPartitionList = (struct DNS_RPC_DP_LIST *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_ENLIST_DP:
			if (in == Py_None) {
				ret->EnlistDirectoryPartition = NULL;
			} else {
				ret->EnlistDirectoryPartition = NULL;
				PY_CHECK_TYPE(&DNS_RPC_ENLIST_DP_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->EnlistDirectoryPartition = (struct DNS_RPC_ENLIST_DP *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_ZONE_CHANGE_DP:
			if (in == Py_None) {
				ret->ZoneChangeDirectoryPartition = NULL;
			} else {
				ret->ZoneChangeDirectoryPartition = NULL;
				PY_CHECK_TYPE(&DNS_RPC_ZONE_CHANGE_DP_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ZoneChangeDirectoryPartition = (struct DNS_RPC_ZONE_CHANGE_DP *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_ENUM_ZONES_FILTER:
			if (in == Py_None) {
				ret->EnumZonesFilter = NULL;
			} else {
				ret->EnumZonesFilter = NULL;
				PY_CHECK_TYPE(&DNS_RPC_ENUM_ZONES_FILTER_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->EnumZonesFilter = (struct DNS_RPC_ENUM_ZONES_FILTER *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_ADDRARRAY:
			if (in == Py_None) {
				ret->AddrArray = NULL;
			} else {
				ret->AddrArray = NULL;
				PY_CHECK_TYPE(&DNS_ADDR_ARRAY_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->AddrArray = (struct DNS_ADDR_ARRAY *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_SERVER_INFO:
			if (in == Py_None) {
				ret->ServerInfo = NULL;
			} else {
				ret->ServerInfo = NULL;
				PY_CHECK_TYPE(&DNS_RPC_SERVER_INFO_LONGHORN_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ServerInfo = (struct DNS_RPC_SERVER_INFO_LONGHORN *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_ZONE_CREATE:
			if (in == Py_None) {
				ret->ZoneCreate = NULL;
			} else {
				ret->ZoneCreate = NULL;
				PY_CHECK_TYPE(&DNS_RPC_ZONE_CREATE_INFO_LONGHORN_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ZoneCreate = (struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_FORWARDERS:
			if (in == Py_None) {
				ret->Forwarders = NULL;
			} else {
				ret->Forwarders = NULL;
				PY_CHECK_TYPE(&DNS_RPC_FORWARDERS_LONGHORN_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->Forwarders = (struct DNS_RPC_FORWARDERS_LONGHORN *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_ZONE_SECONDARIES:
			if (in == Py_None) {
				ret->Secondaries = NULL;
			} else {
				ret->Secondaries = NULL;
				PY_CHECK_TYPE(&DNS_RPC_ZONE_SECONDARIES_LONGHORN_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->Secondaries = (struct DNS_RPC_ZONE_SECONDARIES_LONGHORN *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_IP_VALIDATE:
			if (in == Py_None) {
				ret->IpValidate = NULL;
			} else {
				ret->IpValidate = NULL;
				PY_CHECK_TYPE(&DNS_RPC_IP_VALIDATE_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->IpValidate = (struct DNS_RPC_IP_VALIDATE *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_ZONE_INFO:
			if (in == Py_None) {
				ret->ZoneInfo = NULL;
			} else {
				ret->ZoneInfo = NULL;
				PY_CHECK_TYPE(&DNS_RPC_ZONE_INFO_LONGHORN_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ZoneInfo = (struct DNS_RPC_ZONE_INFO_LONGHORN *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_AUTOCONFIGURE:
			if (in == Py_None) {
				ret->AutoConfigure = NULL;
			} else {
				ret->AutoConfigure = NULL;
				PY_CHECK_TYPE(&DNS_RPC_AUTOCONFIGURE_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->AutoConfigure = (struct DNS_RPC_AUTOCONFIGURE *)pytalloc_get_ptr(in);
			}
			break;

		case DNSSRV_TYPEID_UTF8_STRING_LIST:
			if (in == Py_None) {
				ret->Utf8StringList = NULL;
			} else {
				ret->Utf8StringList = NULL;
				PY_CHECK_TYPE(&DNS_RPC_UTF8_STRING_LIST_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->Utf8StringList = (struct DNS_RPC_UTF8_STRING_LIST *)pytalloc_get_ptr(in);
			}
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}


static PyObject *py_DNS_RPC_RECORDS_get_wLength(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORDS *object = (struct DNS_RPC_RECORDS *)pytalloc_get_ptr(obj);
	PyObject *py_wLength;
	py_wLength = PyInt_FromLong(object->wLength);
	return py_wLength;
}

static int py_DNS_RPC_RECORDS_set_wLength(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORDS *object = (struct DNS_RPC_RECORDS *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->wLength = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_RECORDS_get_wRecordCount(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORDS *object = (struct DNS_RPC_RECORDS *)pytalloc_get_ptr(obj);
	PyObject *py_wRecordCount;
	py_wRecordCount = PyInt_FromLong(object->wRecordCount);
	return py_wRecordCount;
}

static int py_DNS_RPC_RECORDS_set_wRecordCount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORDS *object = (struct DNS_RPC_RECORDS *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->wRecordCount = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_RECORDS_get_dwFlags(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORDS *object = (struct DNS_RPC_RECORDS *)pytalloc_get_ptr(obj);
	PyObject *py_dwFlags;
	py_dwFlags = PyInt_FromLong(object->dwFlags);
	return py_dwFlags;
}

static int py_DNS_RPC_RECORDS_set_dwFlags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORDS *object = (struct DNS_RPC_RECORDS *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwFlags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_RECORDS_get_dwChildCount(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORDS *object = (struct DNS_RPC_RECORDS *)pytalloc_get_ptr(obj);
	PyObject *py_dwChildCount;
	py_dwChildCount = PyInt_FromLong(object->dwChildCount);
	return py_dwChildCount;
}

static int py_DNS_RPC_RECORDS_set_dwChildCount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORDS *object = (struct DNS_RPC_RECORDS *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->dwChildCount = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_RECORDS_get_dnsNodeName(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORDS *object = (struct DNS_RPC_RECORDS *)pytalloc_get_ptr(obj);
	PyObject *py_dnsNodeName;
	py_dnsNodeName = pytalloc_reference_ex(&DNS_RPC_NAME_Type, pytalloc_get_mem_ctx(obj), &object->dnsNodeName);
	return py_dnsNodeName;
}

static int py_DNS_RPC_RECORDS_set_dnsNodeName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORDS *object = (struct DNS_RPC_RECORDS *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&DNS_RPC_NAME_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->dnsNodeName = *(struct DNS_RPC_NAME *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_DNS_RPC_RECORDS_get_records(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORDS *object = (struct DNS_RPC_RECORDS *)pytalloc_get_ptr(obj);
	PyObject *py_records;
	py_records = PyList_New(object->wRecordCount);
	if (py_records == NULL) {
		return NULL;
	}
	{
		int records_cntr_0;
		for (records_cntr_0 = 0; records_cntr_0 < object->wRecordCount; records_cntr_0++) {
			PyObject *py_records_0;
			py_records_0 = pytalloc_reference_ex(&DNS_RPC_RECORD_Type, object->records, &object->records[records_cntr_0]);
			PyList_SetItem(py_records, records_cntr_0, py_records_0);
		}
	}
	return py_records;
}

static int py_DNS_RPC_RECORDS_set_records(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORDS *object = (struct DNS_RPC_RECORDS *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int records_cntr_0;
		object->records = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->records, PyList_GET_SIZE(value));
		if (!object->records) { return -1;; }
		talloc_set_name_const(object->records, "ARRAY: object->records");
		for (records_cntr_0 = 0; records_cntr_0 < PyList_GET_SIZE(value); records_cntr_0++) {
			PY_CHECK_TYPE(&DNS_RPC_RECORD_Type, PyList_GET_ITEM(value, records_cntr_0), return -1;);
			if (talloc_reference(object->records, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, records_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->records[records_cntr_0] = *(struct DNS_RPC_RECORD *)pytalloc_get_ptr(PyList_GET_ITEM(value, records_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_RECORDS_getsetters[] = {
	{ discard_const_p(char, "wLength"), py_DNS_RPC_RECORDS_get_wLength, py_DNS_RPC_RECORDS_set_wLength },
	{ discard_const_p(char, "wRecordCount"), py_DNS_RPC_RECORDS_get_wRecordCount, py_DNS_RPC_RECORDS_set_wRecordCount },
	{ discard_const_p(char, "dwFlags"), py_DNS_RPC_RECORDS_get_dwFlags, py_DNS_RPC_RECORDS_set_dwFlags },
	{ discard_const_p(char, "dwChildCount"), py_DNS_RPC_RECORDS_get_dwChildCount, py_DNS_RPC_RECORDS_set_dwChildCount },
	{ discard_const_p(char, "dnsNodeName"), py_DNS_RPC_RECORDS_get_dnsNodeName, py_DNS_RPC_RECORDS_set_dnsNodeName },
	{ discard_const_p(char, "records"), py_DNS_RPC_RECORDS_get_records, py_DNS_RPC_RECORDS_set_records },
	{ NULL }
};

static PyObject *py_DNS_RPC_RECORDS_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_RECORDS, type);
}

static PyObject *py_DNS_RPC_RECORDS_ndr_pack(PyObject *py_obj)
{
	struct DNS_RPC_RECORDS *object = (struct DNS_RPC_RECORDS *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_DNS_RPC_RECORDS);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_DNS_RPC_RECORDS_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct DNS_RPC_RECORDS *object = (struct DNS_RPC_RECORDS *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_DNS_RPC_RECORDS);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_DNS_RPC_RECORDS);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_DNS_RPC_RECORDS_ndr_print(PyObject *py_obj)
{
	struct DNS_RPC_RECORDS *object = (struct DNS_RPC_RECORDS *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_DNS_RPC_RECORDS, "DNS_RPC_RECORDS", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_DNS_RPC_RECORDS_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_DNS_RPC_RECORDS_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_DNS_RPC_RECORDS_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_DNS_RPC_RECORDS_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject DNS_RPC_RECORDS_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.DNS_RPC_RECORDS",
	.tp_getset = py_DNS_RPC_RECORDS_getsetters,
	.tp_methods = py_DNS_RPC_RECORDS_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DNS_RPC_RECORDS_new,
};


static PyObject *py_DNS_RPC_RECORDS_ARRAY_get_count(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORDS_ARRAY *object = (struct DNS_RPC_RECORDS_ARRAY *)pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyInt_FromLong(object->count);
	return py_count;
}

static int py_DNS_RPC_RECORDS_ARRAY_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORDS_ARRAY *object = (struct DNS_RPC_RECORDS_ARRAY *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_DNS_RPC_RECORDS_ARRAY_get_rec(PyObject *obj, void *closure)
{
	struct DNS_RPC_RECORDS_ARRAY *object = (struct DNS_RPC_RECORDS_ARRAY *)pytalloc_get_ptr(obj);
	PyObject *py_rec;
	py_rec = PyList_New(object->count);
	if (py_rec == NULL) {
		return NULL;
	}
	{
		int rec_cntr_0;
		for (rec_cntr_0 = 0; rec_cntr_0 < object->count; rec_cntr_0++) {
			PyObject *py_rec_0;
			py_rec_0 = pytalloc_reference_ex(&DNS_RPC_RECORDS_Type, object->rec, &object->rec[rec_cntr_0]);
			PyList_SetItem(py_rec, rec_cntr_0, py_rec_0);
		}
	}
	return py_rec;
}

static int py_DNS_RPC_RECORDS_ARRAY_set_rec(PyObject *py_obj, PyObject *value, void *closure)
{
	struct DNS_RPC_RECORDS_ARRAY *object = (struct DNS_RPC_RECORDS_ARRAY *)pytalloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int rec_cntr_0;
		object->rec = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->rec, PyList_GET_SIZE(value));
		if (!object->rec) { return -1;; }
		talloc_set_name_const(object->rec, "ARRAY: object->rec");
		for (rec_cntr_0 = 0; rec_cntr_0 < PyList_GET_SIZE(value); rec_cntr_0++) {
			PY_CHECK_TYPE(&DNS_RPC_RECORDS_Type, PyList_GET_ITEM(value, rec_cntr_0), return -1;);
			if (talloc_reference(object->rec, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, rec_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->rec[rec_cntr_0] = *(struct DNS_RPC_RECORDS *)pytalloc_get_ptr(PyList_GET_ITEM(value, rec_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_DNS_RPC_RECORDS_ARRAY_getsetters[] = {
	{ discard_const_p(char, "count"), py_DNS_RPC_RECORDS_ARRAY_get_count, py_DNS_RPC_RECORDS_ARRAY_set_count },
	{ discard_const_p(char, "rec"), py_DNS_RPC_RECORDS_ARRAY_get_rec, py_DNS_RPC_RECORDS_ARRAY_set_rec },
	{ NULL }
};

static PyObject *py_DNS_RPC_RECORDS_ARRAY_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct DNS_RPC_RECORDS_ARRAY, type);
}

static PyObject *py_DNS_RPC_RECORDS_ARRAY_ndr_pack(PyObject *py_obj)
{
	struct DNS_RPC_RECORDS_ARRAY *object = (struct DNS_RPC_RECORDS_ARRAY *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_push_flags_fn_t)ndr_push_DNS_RPC_RECORDS_ARRAY);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_DNS_RPC_RECORDS_ARRAY_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct DNS_RPC_RECORDS_ARRAY *object = (struct DNS_RPC_RECORDS_ARRAY *)pytalloc_get_ptr(py_obj);
	DATA_BLOB blob;
	int blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s#|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_DNS_RPC_RECORDS_ARRAY);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_DNS_RPC_RECORDS_ARRAY);
	}
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_DNS_RPC_RECORDS_ARRAY_ndr_print(PyObject *py_obj)
{
	struct DNS_RPC_RECORDS_ARRAY *object = (struct DNS_RPC_RECORDS_ARRAY *)pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_DNS_RPC_RECORDS_ARRAY, "DNS_RPC_RECORDS_ARRAY", object);
	ret = PyString_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_DNS_RPC_RECORDS_ARRAY_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_DNS_RPC_RECORDS_ARRAY_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_DNS_RPC_RECORDS_ARRAY_ndr_unpack, METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_DNS_RPC_RECORDS_ARRAY_ndr_print, METH_VARARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject DNS_RPC_RECORDS_ARRAY_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.DNS_RPC_RECORDS_ARRAY",
	.tp_getset = py_DNS_RPC_RECORDS_ARRAY_getsetters,
	.tp_methods = py_DNS_RPC_RECORDS_ARRAY_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(pytalloc_Object),
	.tp_new = py_DNS_RPC_RECORDS_ARRAY_new,
};


static bool pack_py_DnssrvOperation_args_in(PyObject *args, PyObject *kwargs, struct DnssrvOperation *r)
{
	PyObject *py_pwszServerName;
	PyObject *py_pszZone;
	PyObject *py_dwContext;
	PyObject *py_pszOperation;
	PyObject *py_dwTypeId;
	PyObject *py_pData;
	const char *kwnames[] = {
		"pwszServerName", "pszZone", "dwContext", "pszOperation", "dwTypeId", "pData", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOO:DnssrvOperation", discard_const_p(char *, kwnames), &py_pwszServerName, &py_pszZone, &py_dwContext, &py_pszOperation, &py_dwTypeId, &py_pData)) {
		return false;
	}

	if (py_pwszServerName == Py_None) {
		r->in.pwszServerName = NULL;
	} else {
		r->in.pwszServerName = NULL;
		if (PyUnicode_Check(py_pwszServerName)) {
			r->in.pwszServerName = PyString_AS_STRING(PyUnicode_AsEncodedString(py_pwszServerName, "utf-8", "ignore"));
		} else if (PyString_Check(py_pwszServerName)) {
			r->in.pwszServerName = PyString_AS_STRING(py_pwszServerName);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pwszServerName)->tp_name);
			return false;
		}
	}
	if (py_pszZone == Py_None) {
		r->in.pszZone = NULL;
	} else {
		r->in.pszZone = NULL;
		if (PyUnicode_Check(py_pszZone)) {
			r->in.pszZone = PyString_AS_STRING(PyUnicode_AsEncodedString(py_pszZone, "utf-8", "ignore"));
		} else if (PyString_Check(py_pszZone)) {
			r->in.pszZone = PyString_AS_STRING(py_pszZone);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pszZone)->tp_name);
			return false;
		}
	}
	PY_CHECK_TYPE(&PyInt_Type, py_dwContext, return false;);
	r->in.dwContext = PyInt_AsLong(py_dwContext);
	if (py_pszOperation == Py_None) {
		r->in.pszOperation = NULL;
	} else {
		r->in.pszOperation = NULL;
		if (PyUnicode_Check(py_pszOperation)) {
			r->in.pszOperation = PyString_AS_STRING(PyUnicode_AsEncodedString(py_pszOperation, "utf-8", "ignore"));
		} else if (PyString_Check(py_pszOperation)) {
			r->in.pszOperation = PyString_AS_STRING(py_pszOperation);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pszOperation)->tp_name);
			return false;
		}
	}
	if (PyLong_Check(py_dwTypeId)) {
		r->in.dwTypeId = PyLong_AsLongLong(py_dwTypeId);
	} else if (PyInt_Check(py_dwTypeId)) {
		r->in.dwTypeId = PyInt_AsLong(py_dwTypeId);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	{
		union DNSSRV_RPC_UNION *pData_switch_0;
		pData_switch_0 = py_export_DNSSRV_RPC_UNION(r, r->in.dwTypeId, py_pData);
		if (pData_switch_0 == NULL) {
			return false;
		}
		r->in.pData = *pData_switch_0;
	}
	return true;
}

static PyObject *unpack_py_DnssrvOperation_args_out(struct DnssrvOperation *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_DnssrvQuery_args_in(PyObject *args, PyObject *kwargs, struct DnssrvQuery *r)
{
	PyObject *py_pwszServerName;
	PyObject *py_pszZone;
	PyObject *py_pszOperation;
	const char *kwnames[] = {
		"pwszServerName", "pszZone", "pszOperation", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:DnssrvQuery", discard_const_p(char *, kwnames), &py_pwszServerName, &py_pszZone, &py_pszOperation)) {
		return false;
	}

	if (py_pwszServerName == Py_None) {
		r->in.pwszServerName = NULL;
	} else {
		r->in.pwszServerName = NULL;
		if (PyUnicode_Check(py_pwszServerName)) {
			r->in.pwszServerName = PyString_AS_STRING(PyUnicode_AsEncodedString(py_pwszServerName, "utf-8", "ignore"));
		} else if (PyString_Check(py_pwszServerName)) {
			r->in.pwszServerName = PyString_AS_STRING(py_pwszServerName);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pwszServerName)->tp_name);
			return false;
		}
	}
	if (py_pszZone == Py_None) {
		r->in.pszZone = NULL;
	} else {
		r->in.pszZone = NULL;
		if (PyUnicode_Check(py_pszZone)) {
			r->in.pszZone = PyString_AS_STRING(PyUnicode_AsEncodedString(py_pszZone, "utf-8", "ignore"));
		} else if (PyString_Check(py_pszZone)) {
			r->in.pszZone = PyString_AS_STRING(py_pszZone);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pszZone)->tp_name);
			return false;
		}
	}
	if (py_pszOperation == Py_None) {
		r->in.pszOperation = NULL;
	} else {
		r->in.pszOperation = NULL;
		if (PyUnicode_Check(py_pszOperation)) {
			r->in.pszOperation = PyString_AS_STRING(PyUnicode_AsEncodedString(py_pszOperation, "utf-8", "ignore"));
		} else if (PyString_Check(py_pszOperation)) {
			r->in.pszOperation = PyString_AS_STRING(py_pszOperation);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pszOperation)->tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_DnssrvQuery_args_out(struct DnssrvQuery *r)
{
	PyObject *result;
	PyObject *py_pdwTypeId;
	PyObject *py_ppData;
	result = PyTuple_New(2);
	py_pdwTypeId = PyInt_FromLong(*r->out.pdwTypeId);
	PyTuple_SetItem(result, 0, py_pdwTypeId);
	py_ppData = py_import_DNSSRV_RPC_UNION(r->out.ppData, *r->out.pdwTypeId, r->out.ppData);
	if (py_ppData == NULL) {
		return NULL;
	}
	PyTuple_SetItem(result, 1, py_ppData);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_DnssrvComplexOperation_args_in(PyObject *args, PyObject *kwargs, struct DnssrvComplexOperation *r)
{
	PyObject *py_pwszServerName;
	PyObject *py_pszZone;
	PyObject *py_pszOperation;
	PyObject *py_dwTypeIn;
	PyObject *py_pDataIn;
	const char *kwnames[] = {
		"pwszServerName", "pszZone", "pszOperation", "dwTypeIn", "pDataIn", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:DnssrvComplexOperation", discard_const_p(char *, kwnames), &py_pwszServerName, &py_pszZone, &py_pszOperation, &py_dwTypeIn, &py_pDataIn)) {
		return false;
	}

	if (py_pwszServerName == Py_None) {
		r->in.pwszServerName = NULL;
	} else {
		r->in.pwszServerName = NULL;
		if (PyUnicode_Check(py_pwszServerName)) {
			r->in.pwszServerName = PyString_AS_STRING(PyUnicode_AsEncodedString(py_pwszServerName, "utf-8", "ignore"));
		} else if (PyString_Check(py_pwszServerName)) {
			r->in.pwszServerName = PyString_AS_STRING(py_pwszServerName);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pwszServerName)->tp_name);
			return false;
		}
	}
	if (py_pszZone == Py_None) {
		r->in.pszZone = NULL;
	} else {
		r->in.pszZone = NULL;
		if (PyUnicode_Check(py_pszZone)) {
			r->in.pszZone = PyString_AS_STRING(PyUnicode_AsEncodedString(py_pszZone, "utf-8", "ignore"));
		} else if (PyString_Check(py_pszZone)) {
			r->in.pszZone = PyString_AS_STRING(py_pszZone);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pszZone)->tp_name);
			return false;
		}
	}
	if (py_pszOperation == Py_None) {
		r->in.pszOperation = NULL;
	} else {
		r->in.pszOperation = NULL;
		if (PyUnicode_Check(py_pszOperation)) {
			r->in.pszOperation = PyString_AS_STRING(PyUnicode_AsEncodedString(py_pszOperation, "utf-8", "ignore"));
		} else if (PyString_Check(py_pszOperation)) {
			r->in.pszOperation = PyString_AS_STRING(py_pszOperation);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pszOperation)->tp_name);
			return false;
		}
	}
	if (PyLong_Check(py_dwTypeIn)) {
		r->in.dwTypeIn = PyLong_AsLongLong(py_dwTypeIn);
	} else if (PyInt_Check(py_dwTypeIn)) {
		r->in.dwTypeIn = PyInt_AsLong(py_dwTypeIn);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	{
		union DNSSRV_RPC_UNION *pDataIn_switch_0;
		pDataIn_switch_0 = py_export_DNSSRV_RPC_UNION(r, r->in.dwTypeIn, py_pDataIn);
		if (pDataIn_switch_0 == NULL) {
			return false;
		}
		r->in.pDataIn = *pDataIn_switch_0;
	}
	return true;
}

static PyObject *unpack_py_DnssrvComplexOperation_args_out(struct DnssrvComplexOperation *r)
{
	PyObject *result;
	PyObject *py_pdwTypeOut;
	PyObject *py_ppDataOut;
	result = PyTuple_New(2);
	py_pdwTypeOut = PyInt_FromLong(*r->out.pdwTypeOut);
	PyTuple_SetItem(result, 0, py_pdwTypeOut);
	py_ppDataOut = py_import_DNSSRV_RPC_UNION(r->out.ppDataOut, *r->out.pdwTypeOut, r->out.ppDataOut);
	if (py_ppDataOut == NULL) {
		return NULL;
	}
	PyTuple_SetItem(result, 1, py_ppDataOut);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_DnssrvEnumRecords_args_in(PyObject *args, PyObject *kwargs, struct DnssrvEnumRecords *r)
{
	PyObject *py_pwszServerName;
	PyObject *py_pszZone;
	PyObject *py_pszNodeName;
	PyObject *py_pszStartChild;
	PyObject *py_wRecordType;
	PyObject *py_fSelectFlag;
	PyObject *py_pszFilterStart;
	PyObject *py_pszFilterStop;
	const char *kwnames[] = {
		"pwszServerName", "pszZone", "pszNodeName", "pszStartChild", "wRecordType", "fSelectFlag", "pszFilterStart", "pszFilterStop", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOOO:DnssrvEnumRecords", discard_const_p(char *, kwnames), &py_pwszServerName, &py_pszZone, &py_pszNodeName, &py_pszStartChild, &py_wRecordType, &py_fSelectFlag, &py_pszFilterStart, &py_pszFilterStop)) {
		return false;
	}

	if (py_pwszServerName == Py_None) {
		r->in.pwszServerName = NULL;
	} else {
		r->in.pwszServerName = NULL;
		if (PyUnicode_Check(py_pwszServerName)) {
			r->in.pwszServerName = PyString_AS_STRING(PyUnicode_AsEncodedString(py_pwszServerName, "utf-8", "ignore"));
		} else if (PyString_Check(py_pwszServerName)) {
			r->in.pwszServerName = PyString_AS_STRING(py_pwszServerName);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pwszServerName)->tp_name);
			return false;
		}
	}
	if (py_pszZone == Py_None) {
		r->in.pszZone = NULL;
	} else {
		r->in.pszZone = NULL;
		if (PyUnicode_Check(py_pszZone)) {
			r->in.pszZone = PyString_AS_STRING(PyUnicode_AsEncodedString(py_pszZone, "utf-8", "ignore"));
		} else if (PyString_Check(py_pszZone)) {
			r->in.pszZone = PyString_AS_STRING(py_pszZone);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pszZone)->tp_name);
			return false;
		}
	}
	if (py_pszNodeName == Py_None) {
		r->in.pszNodeName = NULL;
	} else {
		r->in.pszNodeName = NULL;
		if (PyUnicode_Check(py_pszNodeName)) {
			r->in.pszNodeName = PyString_AS_STRING(PyUnicode_AsEncodedString(py_pszNodeName, "utf-8", "ignore"));
		} else if (PyString_Check(py_pszNodeName)) {
			r->in.pszNodeName = PyString_AS_STRING(py_pszNodeName);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pszNodeName)->tp_name);
			return false;
		}
	}
	if (py_pszStartChild == Py_None) {
		r->in.pszStartChild = NULL;
	} else {
		r->in.pszStartChild = NULL;
		if (PyUnicode_Check(py_pszStartChild)) {
			r->in.pszStartChild = PyString_AS_STRING(PyUnicode_AsEncodedString(py_pszStartChild, "utf-8", "ignore"));
		} else if (PyString_Check(py_pszStartChild)) {
			r->in.pszStartChild = PyString_AS_STRING(py_pszStartChild);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pszStartChild)->tp_name);
			return false;
		}
	}
	if (PyLong_Check(py_wRecordType)) {
		r->in.wRecordType = PyLong_AsLongLong(py_wRecordType);
	} else if (PyInt_Check(py_wRecordType)) {
		r->in.wRecordType = PyInt_AsLong(py_wRecordType);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	if (PyLong_Check(py_fSelectFlag)) {
		r->in.fSelectFlag = PyLong_AsLongLong(py_fSelectFlag);
	} else if (PyInt_Check(py_fSelectFlag)) {
		r->in.fSelectFlag = PyInt_AsLong(py_fSelectFlag);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	if (py_pszFilterStart == Py_None) {
		r->in.pszFilterStart = NULL;
	} else {
		r->in.pszFilterStart = NULL;
		if (PyUnicode_Check(py_pszFilterStart)) {
			r->in.pszFilterStart = PyString_AS_STRING(PyUnicode_AsEncodedString(py_pszFilterStart, "utf-8", "ignore"));
		} else if (PyString_Check(py_pszFilterStart)) {
			r->in.pszFilterStart = PyString_AS_STRING(py_pszFilterStart);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pszFilterStart)->tp_name);
			return false;
		}
	}
	if (py_pszFilterStop == Py_None) {
		r->in.pszFilterStop = NULL;
	} else {
		r->in.pszFilterStop = NULL;
		if (PyUnicode_Check(py_pszFilterStop)) {
			r->in.pszFilterStop = PyString_AS_STRING(PyUnicode_AsEncodedString(py_pszFilterStop, "utf-8", "ignore"));
		} else if (PyString_Check(py_pszFilterStop)) {
			r->in.pszFilterStop = PyString_AS_STRING(py_pszFilterStop);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pszFilterStop)->tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_DnssrvEnumRecords_args_out(struct DnssrvEnumRecords *r)
{
	PyObject *result;
	PyObject *py_pdwBufferLength;
	PyObject *py_pBuffer;
	result = PyTuple_New(2);
	py_pdwBufferLength = PyInt_FromLong(*r->out.pdwBufferLength);
	PyTuple_SetItem(result, 0, py_pdwBufferLength);
	if (*r->out.pBuffer == NULL) {
		py_pBuffer = Py_None;
		Py_INCREF(py_pBuffer);
	} else {
		py_pBuffer = pytalloc_reference_ex(&DNS_RPC_RECORDS_ARRAY_Type, *r->out.pBuffer, *r->out.pBuffer);
	}
	PyTuple_SetItem(result, 1, py_pBuffer);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_DnssrvUpdateRecord_args_in(PyObject *args, PyObject *kwargs, struct DnssrvUpdateRecord *r)
{
	PyObject *py_pwszServerName;
	PyObject *py_pszZone;
	PyObject *py_pszNodeName;
	PyObject *py_pAddRecord;
	PyObject *py_pDeleteRecord;
	const char *kwnames[] = {
		"pwszServerName", "pszZone", "pszNodeName", "pAddRecord", "pDeleteRecord", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:DnssrvUpdateRecord", discard_const_p(char *, kwnames), &py_pwszServerName, &py_pszZone, &py_pszNodeName, &py_pAddRecord, &py_pDeleteRecord)) {
		return false;
	}

	if (py_pwszServerName == Py_None) {
		r->in.pwszServerName = NULL;
	} else {
		r->in.pwszServerName = NULL;
		if (PyUnicode_Check(py_pwszServerName)) {
			r->in.pwszServerName = PyString_AS_STRING(PyUnicode_AsEncodedString(py_pwszServerName, "utf-8", "ignore"));
		} else if (PyString_Check(py_pwszServerName)) {
			r->in.pwszServerName = PyString_AS_STRING(py_pwszServerName);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pwszServerName)->tp_name);
			return false;
		}
	}
	if (py_pszZone == Py_None) {
		r->in.pszZone = NULL;
	} else {
		r->in.pszZone = NULL;
		if (PyUnicode_Check(py_pszZone)) {
			r->in.pszZone = PyString_AS_STRING(PyUnicode_AsEncodedString(py_pszZone, "utf-8", "ignore"));
		} else if (PyString_Check(py_pszZone)) {
			r->in.pszZone = PyString_AS_STRING(py_pszZone);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pszZone)->tp_name);
			return false;
		}
	}
	if (py_pszNodeName == Py_None) {
		r->in.pszNodeName = NULL;
	} else {
		r->in.pszNodeName = NULL;
		if (PyUnicode_Check(py_pszNodeName)) {
			r->in.pszNodeName = PyString_AS_STRING(PyUnicode_AsEncodedString(py_pszNodeName, "utf-8", "ignore"));
		} else if (PyString_Check(py_pszNodeName)) {
			r->in.pszNodeName = PyString_AS_STRING(py_pszNodeName);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pszNodeName)->tp_name);
			return false;
		}
	}
	if (py_pAddRecord == Py_None) {
		r->in.pAddRecord = NULL;
	} else {
		r->in.pAddRecord = NULL;
		PY_CHECK_TYPE(&DNS_RPC_RECORD_BUF_Type, py_pAddRecord, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_pAddRecord)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.pAddRecord = (struct DNS_RPC_RECORD_BUF *)pytalloc_get_ptr(py_pAddRecord);
	}
	if (py_pDeleteRecord == Py_None) {
		r->in.pDeleteRecord = NULL;
	} else {
		r->in.pDeleteRecord = NULL;
		PY_CHECK_TYPE(&DNS_RPC_RECORD_BUF_Type, py_pDeleteRecord, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_pDeleteRecord)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.pDeleteRecord = (struct DNS_RPC_RECORD_BUF *)pytalloc_get_ptr(py_pDeleteRecord);
	}
	return true;
}

static PyObject *unpack_py_DnssrvUpdateRecord_args_out(struct DnssrvUpdateRecord *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_DnssrvOperation2_args_in(PyObject *args, PyObject *kwargs, struct DnssrvOperation2 *r)
{
	PyObject *py_dwClientVersion;
	PyObject *py_dwSettingFlags;
	PyObject *py_pwszServerName;
	PyObject *py_pszZone;
	PyObject *py_dwContext;
	PyObject *py_pszOperation;
	PyObject *py_dwTypeId;
	PyObject *py_pData;
	const char *kwnames[] = {
		"dwClientVersion", "dwSettingFlags", "pwszServerName", "pszZone", "dwContext", "pszOperation", "dwTypeId", "pData", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOOO:DnssrvOperation2", discard_const_p(char *, kwnames), &py_dwClientVersion, &py_dwSettingFlags, &py_pwszServerName, &py_pszZone, &py_dwContext, &py_pszOperation, &py_dwTypeId, &py_pData)) {
		return false;
	}

	if (PyLong_Check(py_dwClientVersion)) {
		r->in.dwClientVersion = PyLong_AsLongLong(py_dwClientVersion);
	} else if (PyInt_Check(py_dwClientVersion)) {
		r->in.dwClientVersion = PyInt_AsLong(py_dwClientVersion);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	PY_CHECK_TYPE(&PyInt_Type, py_dwSettingFlags, return false;);
	r->in.dwSettingFlags = PyInt_AsLong(py_dwSettingFlags);
	if (py_pwszServerName == Py_None) {
		r->in.pwszServerName = NULL;
	} else {
		r->in.pwszServerName = NULL;
		if (PyUnicode_Check(py_pwszServerName)) {
			r->in.pwszServerName = PyString_AS_STRING(PyUnicode_AsEncodedString(py_pwszServerName, "utf-8", "ignore"));
		} else if (PyString_Check(py_pwszServerName)) {
			r->in.pwszServerName = PyString_AS_STRING(py_pwszServerName);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pwszServerName)->tp_name);
			return false;
		}
	}
	if (py_pszZone == Py_None) {
		r->in.pszZone = NULL;
	} else {
		r->in.pszZone = NULL;
		if (PyUnicode_Check(py_pszZone)) {
			r->in.pszZone = PyString_AS_STRING(PyUnicode_AsEncodedString(py_pszZone, "utf-8", "ignore"));
		} else if (PyString_Check(py_pszZone)) {
			r->in.pszZone = PyString_AS_STRING(py_pszZone);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pszZone)->tp_name);
			return false;
		}
	}
	PY_CHECK_TYPE(&PyInt_Type, py_dwContext, return false;);
	r->in.dwContext = PyInt_AsLong(py_dwContext);
	if (py_pszOperation == Py_None) {
		r->in.pszOperation = NULL;
	} else {
		r->in.pszOperation = NULL;
		if (PyUnicode_Check(py_pszOperation)) {
			r->in.pszOperation = PyString_AS_STRING(PyUnicode_AsEncodedString(py_pszOperation, "utf-8", "ignore"));
		} else if (PyString_Check(py_pszOperation)) {
			r->in.pszOperation = PyString_AS_STRING(py_pszOperation);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pszOperation)->tp_name);
			return false;
		}
	}
	if (PyLong_Check(py_dwTypeId)) {
		r->in.dwTypeId = PyLong_AsLongLong(py_dwTypeId);
	} else if (PyInt_Check(py_dwTypeId)) {
		r->in.dwTypeId = PyInt_AsLong(py_dwTypeId);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	{
		union DNSSRV_RPC_UNION *pData_switch_0;
		pData_switch_0 = py_export_DNSSRV_RPC_UNION(r, r->in.dwTypeId, py_pData);
		if (pData_switch_0 == NULL) {
			return false;
		}
		r->in.pData = *pData_switch_0;
	}
	return true;
}

static PyObject *unpack_py_DnssrvOperation2_args_out(struct DnssrvOperation2 *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_DnssrvQuery2_args_in(PyObject *args, PyObject *kwargs, struct DnssrvQuery2 *r)
{
	PyObject *py_dwClientVersion;
	PyObject *py_dwSettingFlags;
	PyObject *py_pwszServerName;
	PyObject *py_pszZone;
	PyObject *py_pszOperation;
	const char *kwnames[] = {
		"dwClientVersion", "dwSettingFlags", "pwszServerName", "pszZone", "pszOperation", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:DnssrvQuery2", discard_const_p(char *, kwnames), &py_dwClientVersion, &py_dwSettingFlags, &py_pwszServerName, &py_pszZone, &py_pszOperation)) {
		return false;
	}

	if (PyLong_Check(py_dwClientVersion)) {
		r->in.dwClientVersion = PyLong_AsLongLong(py_dwClientVersion);
	} else if (PyInt_Check(py_dwClientVersion)) {
		r->in.dwClientVersion = PyInt_AsLong(py_dwClientVersion);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	PY_CHECK_TYPE(&PyInt_Type, py_dwSettingFlags, return false;);
	r->in.dwSettingFlags = PyInt_AsLong(py_dwSettingFlags);
	if (py_pwszServerName == Py_None) {
		r->in.pwszServerName = NULL;
	} else {
		r->in.pwszServerName = NULL;
		if (PyUnicode_Check(py_pwszServerName)) {
			r->in.pwszServerName = PyString_AS_STRING(PyUnicode_AsEncodedString(py_pwszServerName, "utf-8", "ignore"));
		} else if (PyString_Check(py_pwszServerName)) {
			r->in.pwszServerName = PyString_AS_STRING(py_pwszServerName);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pwszServerName)->tp_name);
			return false;
		}
	}
	if (py_pszZone == Py_None) {
		r->in.pszZone = NULL;
	} else {
		r->in.pszZone = NULL;
		if (PyUnicode_Check(py_pszZone)) {
			r->in.pszZone = PyString_AS_STRING(PyUnicode_AsEncodedString(py_pszZone, "utf-8", "ignore"));
		} else if (PyString_Check(py_pszZone)) {
			r->in.pszZone = PyString_AS_STRING(py_pszZone);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pszZone)->tp_name);
			return false;
		}
	}
	if (py_pszOperation == Py_None) {
		r->in.pszOperation = NULL;
	} else {
		r->in.pszOperation = NULL;
		if (PyUnicode_Check(py_pszOperation)) {
			r->in.pszOperation = PyString_AS_STRING(PyUnicode_AsEncodedString(py_pszOperation, "utf-8", "ignore"));
		} else if (PyString_Check(py_pszOperation)) {
			r->in.pszOperation = PyString_AS_STRING(py_pszOperation);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pszOperation)->tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_DnssrvQuery2_args_out(struct DnssrvQuery2 *r)
{
	PyObject *result;
	PyObject *py_pdwTypeId;
	PyObject *py_ppData;
	result = PyTuple_New(2);
	py_pdwTypeId = PyInt_FromLong(*r->out.pdwTypeId);
	PyTuple_SetItem(result, 0, py_pdwTypeId);
	py_ppData = py_import_DNSSRV_RPC_UNION(r->out.ppData, *r->out.pdwTypeId, r->out.ppData);
	if (py_ppData == NULL) {
		return NULL;
	}
	PyTuple_SetItem(result, 1, py_ppData);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_DnssrvComplexOperation2_args_in(PyObject *args, PyObject *kwargs, struct DnssrvComplexOperation2 *r)
{
	PyObject *py_dwClientVersion;
	PyObject *py_dwSettingFlags;
	PyObject *py_pwszServerName;
	PyObject *py_pszZone;
	PyObject *py_pszOperation;
	PyObject *py_dwTypeIn;
	PyObject *py_pDataIn;
	const char *kwnames[] = {
		"dwClientVersion", "dwSettingFlags", "pwszServerName", "pszZone", "pszOperation", "dwTypeIn", "pDataIn", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOO:DnssrvComplexOperation2", discard_const_p(char *, kwnames), &py_dwClientVersion, &py_dwSettingFlags, &py_pwszServerName, &py_pszZone, &py_pszOperation, &py_dwTypeIn, &py_pDataIn)) {
		return false;
	}

	if (PyLong_Check(py_dwClientVersion)) {
		r->in.dwClientVersion = PyLong_AsLongLong(py_dwClientVersion);
	} else if (PyInt_Check(py_dwClientVersion)) {
		r->in.dwClientVersion = PyInt_AsLong(py_dwClientVersion);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	PY_CHECK_TYPE(&PyInt_Type, py_dwSettingFlags, return false;);
	r->in.dwSettingFlags = PyInt_AsLong(py_dwSettingFlags);
	if (py_pwszServerName == Py_None) {
		r->in.pwszServerName = NULL;
	} else {
		r->in.pwszServerName = NULL;
		if (PyUnicode_Check(py_pwszServerName)) {
			r->in.pwszServerName = PyString_AS_STRING(PyUnicode_AsEncodedString(py_pwszServerName, "utf-8", "ignore"));
		} else if (PyString_Check(py_pwszServerName)) {
			r->in.pwszServerName = PyString_AS_STRING(py_pwszServerName);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pwszServerName)->tp_name);
			return false;
		}
	}
	if (py_pszZone == Py_None) {
		r->in.pszZone = NULL;
	} else {
		r->in.pszZone = NULL;
		if (PyUnicode_Check(py_pszZone)) {
			r->in.pszZone = PyString_AS_STRING(PyUnicode_AsEncodedString(py_pszZone, "utf-8", "ignore"));
		} else if (PyString_Check(py_pszZone)) {
			r->in.pszZone = PyString_AS_STRING(py_pszZone);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pszZone)->tp_name);
			return false;
		}
	}
	if (py_pszOperation == Py_None) {
		r->in.pszOperation = NULL;
	} else {
		r->in.pszOperation = NULL;
		if (PyUnicode_Check(py_pszOperation)) {
			r->in.pszOperation = PyString_AS_STRING(PyUnicode_AsEncodedString(py_pszOperation, "utf-8", "ignore"));
		} else if (PyString_Check(py_pszOperation)) {
			r->in.pszOperation = PyString_AS_STRING(py_pszOperation);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pszOperation)->tp_name);
			return false;
		}
	}
	if (PyLong_Check(py_dwTypeIn)) {
		r->in.dwTypeIn = PyLong_AsLongLong(py_dwTypeIn);
	} else if (PyInt_Check(py_dwTypeIn)) {
		r->in.dwTypeIn = PyInt_AsLong(py_dwTypeIn);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	{
		union DNSSRV_RPC_UNION *pDataIn_switch_0;
		pDataIn_switch_0 = py_export_DNSSRV_RPC_UNION(r, r->in.dwTypeIn, py_pDataIn);
		if (pDataIn_switch_0 == NULL) {
			return false;
		}
		r->in.pDataIn = *pDataIn_switch_0;
	}
	return true;
}

static PyObject *unpack_py_DnssrvComplexOperation2_args_out(struct DnssrvComplexOperation2 *r)
{
	PyObject *result;
	PyObject *py_pdwTypeOut;
	PyObject *py_ppDataOut;
	result = PyTuple_New(2);
	py_pdwTypeOut = PyInt_FromLong(*r->out.pdwTypeOut);
	PyTuple_SetItem(result, 0, py_pdwTypeOut);
	py_ppDataOut = py_import_DNSSRV_RPC_UNION(r->out.ppDataOut, *r->out.pdwTypeOut, r->out.ppDataOut);
	if (py_ppDataOut == NULL) {
		return NULL;
	}
	PyTuple_SetItem(result, 1, py_ppDataOut);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_DnssrvEnumRecords2_args_in(PyObject *args, PyObject *kwargs, struct DnssrvEnumRecords2 *r)
{
	PyObject *py_dwClientVersion;
	PyObject *py_dwSettingFlags;
	PyObject *py_pwszServerName;
	PyObject *py_pszZone;
	PyObject *py_pszNodeName;
	PyObject *py_pszStartChild;
	PyObject *py_wRecordType;
	PyObject *py_fSelectFlag;
	PyObject *py_pszFilterStart;
	PyObject *py_pszFilterStop;
	const char *kwnames[] = {
		"dwClientVersion", "dwSettingFlags", "pwszServerName", "pszZone", "pszNodeName", "pszStartChild", "wRecordType", "fSelectFlag", "pszFilterStart", "pszFilterStop", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOOOOO:DnssrvEnumRecords2", discard_const_p(char *, kwnames), &py_dwClientVersion, &py_dwSettingFlags, &py_pwszServerName, &py_pszZone, &py_pszNodeName, &py_pszStartChild, &py_wRecordType, &py_fSelectFlag, &py_pszFilterStart, &py_pszFilterStop)) {
		return false;
	}

	if (PyLong_Check(py_dwClientVersion)) {
		r->in.dwClientVersion = PyLong_AsLongLong(py_dwClientVersion);
	} else if (PyInt_Check(py_dwClientVersion)) {
		r->in.dwClientVersion = PyInt_AsLong(py_dwClientVersion);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	PY_CHECK_TYPE(&PyInt_Type, py_dwSettingFlags, return false;);
	r->in.dwSettingFlags = PyInt_AsLong(py_dwSettingFlags);
	if (py_pwszServerName == Py_None) {
		r->in.pwszServerName = NULL;
	} else {
		r->in.pwszServerName = NULL;
		if (PyUnicode_Check(py_pwszServerName)) {
			r->in.pwszServerName = PyString_AS_STRING(PyUnicode_AsEncodedString(py_pwszServerName, "utf-8", "ignore"));
		} else if (PyString_Check(py_pwszServerName)) {
			r->in.pwszServerName = PyString_AS_STRING(py_pwszServerName);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pwszServerName)->tp_name);
			return false;
		}
	}
	if (py_pszZone == Py_None) {
		r->in.pszZone = NULL;
	} else {
		r->in.pszZone = NULL;
		if (PyUnicode_Check(py_pszZone)) {
			r->in.pszZone = PyString_AS_STRING(PyUnicode_AsEncodedString(py_pszZone, "utf-8", "ignore"));
		} else if (PyString_Check(py_pszZone)) {
			r->in.pszZone = PyString_AS_STRING(py_pszZone);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pszZone)->tp_name);
			return false;
		}
	}
	if (py_pszNodeName == Py_None) {
		r->in.pszNodeName = NULL;
	} else {
		r->in.pszNodeName = NULL;
		if (PyUnicode_Check(py_pszNodeName)) {
			r->in.pszNodeName = PyString_AS_STRING(PyUnicode_AsEncodedString(py_pszNodeName, "utf-8", "ignore"));
		} else if (PyString_Check(py_pszNodeName)) {
			r->in.pszNodeName = PyString_AS_STRING(py_pszNodeName);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pszNodeName)->tp_name);
			return false;
		}
	}
	if (py_pszStartChild == Py_None) {
		r->in.pszStartChild = NULL;
	} else {
		r->in.pszStartChild = NULL;
		if (PyUnicode_Check(py_pszStartChild)) {
			r->in.pszStartChild = PyString_AS_STRING(PyUnicode_AsEncodedString(py_pszStartChild, "utf-8", "ignore"));
		} else if (PyString_Check(py_pszStartChild)) {
			r->in.pszStartChild = PyString_AS_STRING(py_pszStartChild);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pszStartChild)->tp_name);
			return false;
		}
	}
	if (PyLong_Check(py_wRecordType)) {
		r->in.wRecordType = PyLong_AsLongLong(py_wRecordType);
	} else if (PyInt_Check(py_wRecordType)) {
		r->in.wRecordType = PyInt_AsLong(py_wRecordType);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	if (PyLong_Check(py_fSelectFlag)) {
		r->in.fSelectFlag = PyLong_AsLongLong(py_fSelectFlag);
	} else if (PyInt_Check(py_fSelectFlag)) {
		r->in.fSelectFlag = PyInt_AsLong(py_fSelectFlag);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	if (py_pszFilterStart == Py_None) {
		r->in.pszFilterStart = NULL;
	} else {
		r->in.pszFilterStart = NULL;
		if (PyUnicode_Check(py_pszFilterStart)) {
			r->in.pszFilterStart = PyString_AS_STRING(PyUnicode_AsEncodedString(py_pszFilterStart, "utf-8", "ignore"));
		} else if (PyString_Check(py_pszFilterStart)) {
			r->in.pszFilterStart = PyString_AS_STRING(py_pszFilterStart);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pszFilterStart)->tp_name);
			return false;
		}
	}
	if (py_pszFilterStop == Py_None) {
		r->in.pszFilterStop = NULL;
	} else {
		r->in.pszFilterStop = NULL;
		if (PyUnicode_Check(py_pszFilterStop)) {
			r->in.pszFilterStop = PyString_AS_STRING(PyUnicode_AsEncodedString(py_pszFilterStop, "utf-8", "ignore"));
		} else if (PyString_Check(py_pszFilterStop)) {
			r->in.pszFilterStop = PyString_AS_STRING(py_pszFilterStop);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pszFilterStop)->tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_DnssrvEnumRecords2_args_out(struct DnssrvEnumRecords2 *r)
{
	PyObject *result;
	PyObject *py_pdwBufferLength;
	PyObject *py_pBuffer;
	result = PyTuple_New(2);
	py_pdwBufferLength = PyInt_FromLong(*r->out.pdwBufferLength);
	PyTuple_SetItem(result, 0, py_pdwBufferLength);
	if (*r->out.pBuffer == NULL) {
		py_pBuffer = Py_None;
		Py_INCREF(py_pBuffer);
	} else {
		py_pBuffer = pytalloc_reference_ex(&DNS_RPC_RECORDS_ARRAY_Type, *r->out.pBuffer, *r->out.pBuffer);
	}
	PyTuple_SetItem(result, 1, py_pBuffer);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_DnssrvUpdateRecord2_args_in(PyObject *args, PyObject *kwargs, struct DnssrvUpdateRecord2 *r)
{
	PyObject *py_dwClientVersion;
	PyObject *py_dwSettingFlags;
	PyObject *py_pwszServerName;
	PyObject *py_pszZone;
	PyObject *py_pszNodeName;
	PyObject *py_pAddRecord;
	PyObject *py_pDeleteRecord;
	const char *kwnames[] = {
		"dwClientVersion", "dwSettingFlags", "pwszServerName", "pszZone", "pszNodeName", "pAddRecord", "pDeleteRecord", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOOO:DnssrvUpdateRecord2", discard_const_p(char *, kwnames), &py_dwClientVersion, &py_dwSettingFlags, &py_pwszServerName, &py_pszZone, &py_pszNodeName, &py_pAddRecord, &py_pDeleteRecord)) {
		return false;
	}

	if (PyLong_Check(py_dwClientVersion)) {
		r->in.dwClientVersion = PyLong_AsLongLong(py_dwClientVersion);
	} else if (PyInt_Check(py_dwClientVersion)) {
		r->in.dwClientVersion = PyInt_AsLong(py_dwClientVersion);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	PY_CHECK_TYPE(&PyInt_Type, py_dwSettingFlags, return false;);
	r->in.dwSettingFlags = PyInt_AsLong(py_dwSettingFlags);
	if (py_pwszServerName == Py_None) {
		r->in.pwszServerName = NULL;
	} else {
		r->in.pwszServerName = NULL;
		if (PyUnicode_Check(py_pwszServerName)) {
			r->in.pwszServerName = PyString_AS_STRING(PyUnicode_AsEncodedString(py_pwszServerName, "utf-8", "ignore"));
		} else if (PyString_Check(py_pwszServerName)) {
			r->in.pwszServerName = PyString_AS_STRING(py_pwszServerName);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pwszServerName)->tp_name);
			return false;
		}
	}
	if (py_pszZone == Py_None) {
		r->in.pszZone = NULL;
	} else {
		r->in.pszZone = NULL;
		if (PyUnicode_Check(py_pszZone)) {
			r->in.pszZone = PyString_AS_STRING(PyUnicode_AsEncodedString(py_pszZone, "utf-8", "ignore"));
		} else if (PyString_Check(py_pszZone)) {
			r->in.pszZone = PyString_AS_STRING(py_pszZone);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pszZone)->tp_name);
			return false;
		}
	}
	r->in.pszNodeName = talloc_ptrtype(r, r->in.pszNodeName);
	if (PyUnicode_Check(py_pszNodeName)) {
		r->in.pszNodeName = PyString_AS_STRING(PyUnicode_AsEncodedString(py_pszNodeName, "utf-8", "ignore"));
	} else if (PyString_Check(py_pszNodeName)) {
		r->in.pszNodeName = PyString_AS_STRING(py_pszNodeName);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_pszNodeName)->tp_name);
		return false;
	}
	if (py_pAddRecord == Py_None) {
		r->in.pAddRecord = NULL;
	} else {
		r->in.pAddRecord = NULL;
		PY_CHECK_TYPE(&DNS_RPC_RECORD_BUF_Type, py_pAddRecord, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_pAddRecord)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.pAddRecord = (struct DNS_RPC_RECORD_BUF *)pytalloc_get_ptr(py_pAddRecord);
	}
	if (py_pDeleteRecord == Py_None) {
		r->in.pDeleteRecord = NULL;
	} else {
		r->in.pDeleteRecord = NULL;
		PY_CHECK_TYPE(&DNS_RPC_RECORD_BUF_Type, py_pDeleteRecord, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_pDeleteRecord)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.pDeleteRecord = (struct DNS_RPC_RECORD_BUF *)pytalloc_get_ptr(py_pDeleteRecord);
	}
	return true;
}

static PyObject *unpack_py_DnssrvUpdateRecord2_args_out(struct DnssrvUpdateRecord2 *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

const struct PyNdrRpcMethodDef py_ndr_dnsserver_methods[] = {
	{ "DnssrvOperation", "S.DnssrvOperation(pwszServerName, pszZone, dwContext, pszOperation, dwTypeId, pData) -> None", (py_dcerpc_call_fn)dcerpc_DnssrvOperation_r, (py_data_pack_fn)pack_py_DnssrvOperation_args_in, (py_data_unpack_fn)unpack_py_DnssrvOperation_args_out, 0, &ndr_table_dnsserver },
	{ "DnssrvQuery", "S.DnssrvQuery(pwszServerName, pszZone, pszOperation) -> (pdwTypeId, ppData)", (py_dcerpc_call_fn)dcerpc_DnssrvQuery_r, (py_data_pack_fn)pack_py_DnssrvQuery_args_in, (py_data_unpack_fn)unpack_py_DnssrvQuery_args_out, 1, &ndr_table_dnsserver },
	{ "DnssrvComplexOperation", "S.DnssrvComplexOperation(pwszServerName, pszZone, pszOperation, dwTypeIn, pDataIn) -> (pdwTypeOut, ppDataOut)", (py_dcerpc_call_fn)dcerpc_DnssrvComplexOperation_r, (py_data_pack_fn)pack_py_DnssrvComplexOperation_args_in, (py_data_unpack_fn)unpack_py_DnssrvComplexOperation_args_out, 2, &ndr_table_dnsserver },
	{ "DnssrvEnumRecords", "S.DnssrvEnumRecords(pwszServerName, pszZone, pszNodeName, pszStartChild, wRecordType, fSelectFlag, pszFilterStart, pszFilterStop) -> (pdwBufferLength, pBuffer)", (py_dcerpc_call_fn)dcerpc_DnssrvEnumRecords_r, (py_data_pack_fn)pack_py_DnssrvEnumRecords_args_in, (py_data_unpack_fn)unpack_py_DnssrvEnumRecords_args_out, 3, &ndr_table_dnsserver },
	{ "DnssrvUpdateRecord", "S.DnssrvUpdateRecord(pwszServerName, pszZone, pszNodeName, pAddRecord, pDeleteRecord) -> None", (py_dcerpc_call_fn)dcerpc_DnssrvUpdateRecord_r, (py_data_pack_fn)pack_py_DnssrvUpdateRecord_args_in, (py_data_unpack_fn)unpack_py_DnssrvUpdateRecord_args_out, 4, &ndr_table_dnsserver },
	{ "DnssrvOperation2", "S.DnssrvOperation2(dwClientVersion, dwSettingFlags, pwszServerName, pszZone, dwContext, pszOperation, dwTypeId, pData) -> None", (py_dcerpc_call_fn)dcerpc_DnssrvOperation2_r, (py_data_pack_fn)pack_py_DnssrvOperation2_args_in, (py_data_unpack_fn)unpack_py_DnssrvOperation2_args_out, 5, &ndr_table_dnsserver },
	{ "DnssrvQuery2", "S.DnssrvQuery2(dwClientVersion, dwSettingFlags, pwszServerName, pszZone, pszOperation) -> (pdwTypeId, ppData)", (py_dcerpc_call_fn)dcerpc_DnssrvQuery2_r, (py_data_pack_fn)pack_py_DnssrvQuery2_args_in, (py_data_unpack_fn)unpack_py_DnssrvQuery2_args_out, 6, &ndr_table_dnsserver },
	{ "DnssrvComplexOperation2", "S.DnssrvComplexOperation2(dwClientVersion, dwSettingFlags, pwszServerName, pszZone, pszOperation, dwTypeIn, pDataIn) -> (pdwTypeOut, ppDataOut)", (py_dcerpc_call_fn)dcerpc_DnssrvComplexOperation2_r, (py_data_pack_fn)pack_py_DnssrvComplexOperation2_args_in, (py_data_unpack_fn)unpack_py_DnssrvComplexOperation2_args_out, 7, &ndr_table_dnsserver },
	{ "DnssrvEnumRecords2", "S.DnssrvEnumRecords2(dwClientVersion, dwSettingFlags, pwszServerName, pszZone, pszNodeName, pszStartChild, wRecordType, fSelectFlag, pszFilterStart, pszFilterStop) -> (pdwBufferLength, pBuffer)", (py_dcerpc_call_fn)dcerpc_DnssrvEnumRecords2_r, (py_data_pack_fn)pack_py_DnssrvEnumRecords2_args_in, (py_data_unpack_fn)unpack_py_DnssrvEnumRecords2_args_out, 8, &ndr_table_dnsserver },
	{ "DnssrvUpdateRecord2", "S.DnssrvUpdateRecord2(dwClientVersion, dwSettingFlags, pwszServerName, pszZone, pszNodeName, pAddRecord, pDeleteRecord) -> None", (py_dcerpc_call_fn)dcerpc_DnssrvUpdateRecord2_r, (py_data_pack_fn)pack_py_DnssrvUpdateRecord2_args_in, (py_data_unpack_fn)unpack_py_DnssrvUpdateRecord2_args_out, 9, &ndr_table_dnsserver },
	{ NULL }
};

static PyObject *interface_dnsserver_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_dnsserver);
}

#define PY_DOC_DNSSERVER "DNS Management Server"
static PyTypeObject dnsserver_InterfaceType = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dnsserver.dnsserver",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "dnsserver(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n"PY_DOC_DNSSERVER,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_dnsserver_new,
};

static PyMethodDef dnsserver_methods[] = {
	{ NULL, NULL, 0, NULL }
};

void initdnsserver(void)
{
	PyObject *m;
	PyObject *dep_talloc;
	PyObject *dep_samba_dcerpc_base;
	PyObject *dep_samba_dcerpc_dnsp;
	PyObject *dep_samba_dcerpc_misc;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		return;

	dep_samba_dcerpc_base = PyImport_ImportModule("samba.dcerpc.base");
	if (dep_samba_dcerpc_base == NULL)
		return;

	dep_samba_dcerpc_dnsp = PyImport_ImportModule("samba.dcerpc.dnsp");
	if (dep_samba_dcerpc_dnsp == NULL)
		return;

	dep_samba_dcerpc_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_samba_dcerpc_misc == NULL)
		return;

	ClientConnection_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_base, "ClientConnection");
	if (ClientConnection_Type == NULL)
		return;

	Object_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "Object");
	if (Object_Type == NULL)
		return;

	DNS_RPC_BUFFER_Type.tp_base = Object_Type;

	DNS_RPC_UTF8_STRING_LIST_Type.tp_base = Object_Type;

	DNS_RPC_NAME_AND_PARAM_Type.tp_base = Object_Type;

	DNS_RPC_NAME_Type.tp_base = Object_Type;

	DNS_RPC_NODE_Type.tp_base = Object_Type;

	DNS_RPC_RECORD_SOA_Type.tp_base = Object_Type;

	DNS_RPC_RECORD_NAME_PREFERENCE_Type.tp_base = Object_Type;

	DNS_RPC_RECORD_STRING_Type.tp_base = Object_Type;

	DNS_RPC_RECORD_SRV_Type.tp_base = Object_Type;

	DNS_RPC_RECORD_Type.tp_base = Object_Type;

	DNS_RPC_RECORD_BUF_Type.tp_base = Object_Type;

	IP4_ARRAY_Type.tp_base = Object_Type;

	DNS_ADDR_Type.tp_base = Object_Type;

	DNS_ADDR_ARRAY_Type.tp_base = Object_Type;

	DNS_RPC_IP_VALIDATE_Type.tp_base = Object_Type;

	DNS_RPC_SERVER_INFO_W2K_Type.tp_base = Object_Type;

	DNS_EXTENSION_Type.tp_base = Object_Type;

	DNS_RPC_SERVER_INFO_DOTNET_Type.tp_base = Object_Type;

	DNS_RPC_SERVER_INFO_LONGHORN_Type.tp_base = Object_Type;

	DNS_RPC_DP_REPLICA_Type.tp_base = Object_Type;

	DNS_RPC_DP_INFO_Type.tp_base = Object_Type;

	DNS_RPC_DP_ENUM_Type.tp_base = Object_Type;

	DNS_RPC_DP_LIST_Type.tp_base = Object_Type;

	DNS_RPC_ENLIST_DP_Type.tp_base = Object_Type;

	DNS_RPC_ZONE_CHANGE_DP_Type.tp_base = Object_Type;

	DNS_RPC_ZONE_W2K_Type.tp_base = Object_Type;

	DNS_RPC_ZONE_DOTNET_Type.tp_base = Object_Type;

	DNS_RPC_ZONE_LIST_W2K_Type.tp_base = Object_Type;

	DNS_RPC_ZONE_LIST_DOTNET_Type.tp_base = Object_Type;

	DNS_RPC_ZONE_INFO_W2K_Type.tp_base = Object_Type;

	DNS_RPC_ZONE_INFO_DOTNET_Type.tp_base = Object_Type;

	DNS_RPC_ZONE_INFO_LONGHORN_Type.tp_base = Object_Type;

	DNS_RPC_ZONE_SECONDARIES_W2K_Type.tp_base = Object_Type;

	DNS_RPC_ZONE_SECONDARIES_DOTNET_Type.tp_base = Object_Type;

	DNS_RPC_ZONE_SECONDARIES_LONGHORN_Type.tp_base = Object_Type;

	DNS_RPC_ZONE_DATABASE_W2K_Type.tp_base = Object_Type;

	DNS_RPC_ZONE_DATABASE_DOTNET_Type.tp_base = Object_Type;

	DNS_RPC_ZONE_CREATE_INFO_W2K_Type.tp_base = Object_Type;

	DNS_RPC_ZONE_CREATE_INFO_DOTNET_Type.tp_base = Object_Type;

	DNS_RPC_ZONE_CREATE_INFO_LONGHORN_Type.tp_base = Object_Type;

	DNS_RPC_ZONE_EXPORT_INFO_Type.tp_base = Object_Type;

	DNS_RPC_ENUM_ZONES_FILTER_Type.tp_base = Object_Type;

	DNS_RPC_FORWARDERS_W2K_Type.tp_base = Object_Type;

	DNS_RPC_FORWARDERS_DOTNET_Type.tp_base = Object_Type;

	DNS_RPC_FORWARDERS_LONGHORN_Type.tp_base = Object_Type;

	DNS_RPC_AUTOCONFIGURE_Type.tp_base = Object_Type;

	DNSSRV_STAT_HEADER_Type.tp_base = Object_Type;

	DNSSRV_STAT_Type.tp_base = Object_Type;

	DNS_RPC_RECORDS_Type.tp_base = Object_Type;

	DNS_RPC_RECORDS_ARRAY_Type.tp_base = Object_Type;

	dnsserver_InterfaceType.tp_base = ClientConnection_Type;

	if (PyType_Ready(&DNS_RPC_BUFFER_Type) < 0)
		return;
	if (PyType_Ready(&DNS_RPC_UTF8_STRING_LIST_Type) < 0)
		return;
	if (PyType_Ready(&DNS_RPC_NAME_AND_PARAM_Type) < 0)
		return;
	if (PyType_Ready(&DNS_RPC_NAME_Type) < 0)
		return;
	if (PyType_Ready(&DNS_RPC_NODE_Type) < 0)
		return;
	if (PyType_Ready(&DNS_RPC_RECORD_SOA_Type) < 0)
		return;
	if (PyType_Ready(&DNS_RPC_RECORD_NAME_PREFERENCE_Type) < 0)
		return;
	if (PyType_Ready(&DNS_RPC_RECORD_STRING_Type) < 0)
		return;
	if (PyType_Ready(&DNS_RPC_RECORD_SRV_Type) < 0)
		return;
	if (PyType_Ready(&DNS_RPC_RECORD_Type) < 0)
		return;
	if (PyType_Ready(&DNS_RPC_RECORD_BUF_Type) < 0)
		return;
	if (PyType_Ready(&IP4_ARRAY_Type) < 0)
		return;
	if (PyType_Ready(&DNS_ADDR_Type) < 0)
		return;
	if (PyType_Ready(&DNS_ADDR_ARRAY_Type) < 0)
		return;
	if (PyType_Ready(&DNS_RPC_IP_VALIDATE_Type) < 0)
		return;
	if (PyType_Ready(&DNS_RPC_SERVER_INFO_W2K_Type) < 0)
		return;
	if (PyType_Ready(&DNS_EXTENSION_Type) < 0)
		return;
	if (PyType_Ready(&DNS_RPC_SERVER_INFO_DOTNET_Type) < 0)
		return;
	if (PyType_Ready(&DNS_RPC_SERVER_INFO_LONGHORN_Type) < 0)
		return;
	if (PyType_Ready(&DNS_RPC_DP_REPLICA_Type) < 0)
		return;
	if (PyType_Ready(&DNS_RPC_DP_INFO_Type) < 0)
		return;
	if (PyType_Ready(&DNS_RPC_DP_ENUM_Type) < 0)
		return;
	if (PyType_Ready(&DNS_RPC_DP_LIST_Type) < 0)
		return;
	if (PyType_Ready(&DNS_RPC_ENLIST_DP_Type) < 0)
		return;
	if (PyType_Ready(&DNS_RPC_ZONE_CHANGE_DP_Type) < 0)
		return;
	if (PyType_Ready(&DNS_RPC_ZONE_W2K_Type) < 0)
		return;
	if (PyType_Ready(&DNS_RPC_ZONE_DOTNET_Type) < 0)
		return;
	if (PyType_Ready(&DNS_RPC_ZONE_LIST_W2K_Type) < 0)
		return;
	if (PyType_Ready(&DNS_RPC_ZONE_LIST_DOTNET_Type) < 0)
		return;
	if (PyType_Ready(&DNS_RPC_ZONE_INFO_W2K_Type) < 0)
		return;
	if (PyType_Ready(&DNS_RPC_ZONE_INFO_DOTNET_Type) < 0)
		return;
	if (PyType_Ready(&DNS_RPC_ZONE_INFO_LONGHORN_Type) < 0)
		return;
	if (PyType_Ready(&DNS_RPC_ZONE_SECONDARIES_W2K_Type) < 0)
		return;
	if (PyType_Ready(&DNS_RPC_ZONE_SECONDARIES_DOTNET_Type) < 0)
		return;
	if (PyType_Ready(&DNS_RPC_ZONE_SECONDARIES_LONGHORN_Type) < 0)
		return;
	if (PyType_Ready(&DNS_RPC_ZONE_DATABASE_W2K_Type) < 0)
		return;
	if (PyType_Ready(&DNS_RPC_ZONE_DATABASE_DOTNET_Type) < 0)
		return;
	if (PyType_Ready(&DNS_RPC_ZONE_CREATE_INFO_W2K_Type) < 0)
		return;
	if (PyType_Ready(&DNS_RPC_ZONE_CREATE_INFO_DOTNET_Type) < 0)
		return;
	if (PyType_Ready(&DNS_RPC_ZONE_CREATE_INFO_LONGHORN_Type) < 0)
		return;
	if (PyType_Ready(&DNS_RPC_ZONE_EXPORT_INFO_Type) < 0)
		return;
	if (PyType_Ready(&DNS_RPC_ENUM_ZONES_FILTER_Type) < 0)
		return;
	if (PyType_Ready(&DNS_RPC_FORWARDERS_W2K_Type) < 0)
		return;
	if (PyType_Ready(&DNS_RPC_FORWARDERS_DOTNET_Type) < 0)
		return;
	if (PyType_Ready(&DNS_RPC_FORWARDERS_LONGHORN_Type) < 0)
		return;
	if (PyType_Ready(&DNS_RPC_AUTOCONFIGURE_Type) < 0)
		return;
	if (PyType_Ready(&DNSSRV_STAT_HEADER_Type) < 0)
		return;
	if (PyType_Ready(&DNSSRV_STAT_Type) < 0)
		return;
	if (PyType_Ready(&DNS_RPC_RECORDS_Type) < 0)
		return;
	if (PyType_Ready(&DNS_RPC_RECORDS_ARRAY_Type) < 0)
		return;
	if (PyType_Ready(&dnsserver_InterfaceType) < 0)
		return;
	if (!PyInterface_AddNdrRpcMethods(&dnsserver_InterfaceType, py_ndr_dnsserver_methods))
		return;

#ifdef PY_DNS_RPC_BUFFER_PATCH
	PY_DNS_RPC_BUFFER_PATCH(&DNS_RPC_BUFFER_Type);
#endif
#ifdef PY_DNS_RPC_UTF8_STRING_LIST_PATCH
	PY_DNS_RPC_UTF8_STRING_LIST_PATCH(&DNS_RPC_UTF8_STRING_LIST_Type);
#endif
#ifdef PY_DNS_RPC_NAME_AND_PARAM_PATCH
	PY_DNS_RPC_NAME_AND_PARAM_PATCH(&DNS_RPC_NAME_AND_PARAM_Type);
#endif
#ifdef PY_DNS_RPC_NAME_PATCH
	PY_DNS_RPC_NAME_PATCH(&DNS_RPC_NAME_Type);
#endif
#ifdef PY_DNS_RPC_NODE_PATCH
	PY_DNS_RPC_NODE_PATCH(&DNS_RPC_NODE_Type);
#endif
#ifdef PY_DNS_RPC_RECORD_SOA_PATCH
	PY_DNS_RPC_RECORD_SOA_PATCH(&DNS_RPC_RECORD_SOA_Type);
#endif
#ifdef PY_DNS_RPC_RECORD_NAME_PREFERENCE_PATCH
	PY_DNS_RPC_RECORD_NAME_PREFERENCE_PATCH(&DNS_RPC_RECORD_NAME_PREFERENCE_Type);
#endif
#ifdef PY_DNS_RPC_RECORD_STRING_PATCH
	PY_DNS_RPC_RECORD_STRING_PATCH(&DNS_RPC_RECORD_STRING_Type);
#endif
#ifdef PY_DNS_RPC_RECORD_SRV_PATCH
	PY_DNS_RPC_RECORD_SRV_PATCH(&DNS_RPC_RECORD_SRV_Type);
#endif
#ifdef PY_DNS_RPC_RECORD_PATCH
	PY_DNS_RPC_RECORD_PATCH(&DNS_RPC_RECORD_Type);
#endif
#ifdef PY_DNS_RPC_RECORD_BUF_PATCH
	PY_DNS_RPC_RECORD_BUF_PATCH(&DNS_RPC_RECORD_BUF_Type);
#endif
#ifdef PY_IP4_ARRAY_PATCH
	PY_IP4_ARRAY_PATCH(&IP4_ARRAY_Type);
#endif
#ifdef PY_DNS_ADDR_PATCH
	PY_DNS_ADDR_PATCH(&DNS_ADDR_Type);
#endif
#ifdef PY_DNS_ADDR_ARRAY_PATCH
	PY_DNS_ADDR_ARRAY_PATCH(&DNS_ADDR_ARRAY_Type);
#endif
#ifdef PY_DNS_RPC_IP_VALIDATE_PATCH
	PY_DNS_RPC_IP_VALIDATE_PATCH(&DNS_RPC_IP_VALIDATE_Type);
#endif
#ifdef PY_DNS_RPC_SERVER_INFO_W2K_PATCH
	PY_DNS_RPC_SERVER_INFO_W2K_PATCH(&DNS_RPC_SERVER_INFO_W2K_Type);
#endif
#ifdef PY_DNS_EXTENSION_PATCH
	PY_DNS_EXTENSION_PATCH(&DNS_EXTENSION_Type);
#endif
#ifdef PY_DNS_RPC_SERVER_INFO_DOTNET_PATCH
	PY_DNS_RPC_SERVER_INFO_DOTNET_PATCH(&DNS_RPC_SERVER_INFO_DOTNET_Type);
#endif
#ifdef PY_DNS_RPC_SERVER_INFO_LONGHORN_PATCH
	PY_DNS_RPC_SERVER_INFO_LONGHORN_PATCH(&DNS_RPC_SERVER_INFO_LONGHORN_Type);
#endif
#ifdef PY_DNS_RPC_DP_REPLICA_PATCH
	PY_DNS_RPC_DP_REPLICA_PATCH(&DNS_RPC_DP_REPLICA_Type);
#endif
#ifdef PY_DNS_RPC_DP_INFO_PATCH
	PY_DNS_RPC_DP_INFO_PATCH(&DNS_RPC_DP_INFO_Type);
#endif
#ifdef PY_DNS_RPC_DP_ENUM_PATCH
	PY_DNS_RPC_DP_ENUM_PATCH(&DNS_RPC_DP_ENUM_Type);
#endif
#ifdef PY_DNS_RPC_DP_LIST_PATCH
	PY_DNS_RPC_DP_LIST_PATCH(&DNS_RPC_DP_LIST_Type);
#endif
#ifdef PY_DNS_RPC_ENLIST_DP_PATCH
	PY_DNS_RPC_ENLIST_DP_PATCH(&DNS_RPC_ENLIST_DP_Type);
#endif
#ifdef PY_DNS_RPC_ZONE_CHANGE_DP_PATCH
	PY_DNS_RPC_ZONE_CHANGE_DP_PATCH(&DNS_RPC_ZONE_CHANGE_DP_Type);
#endif
#ifdef PY_DNS_RPC_ZONE_W2K_PATCH
	PY_DNS_RPC_ZONE_W2K_PATCH(&DNS_RPC_ZONE_W2K_Type);
#endif
#ifdef PY_DNS_RPC_ZONE_DOTNET_PATCH
	PY_DNS_RPC_ZONE_DOTNET_PATCH(&DNS_RPC_ZONE_DOTNET_Type);
#endif
#ifdef PY_DNS_RPC_ZONE_LIST_W2K_PATCH
	PY_DNS_RPC_ZONE_LIST_W2K_PATCH(&DNS_RPC_ZONE_LIST_W2K_Type);
#endif
#ifdef PY_DNS_RPC_ZONE_LIST_DOTNET_PATCH
	PY_DNS_RPC_ZONE_LIST_DOTNET_PATCH(&DNS_RPC_ZONE_LIST_DOTNET_Type);
#endif
#ifdef PY_DNS_RPC_ZONE_INFO_W2K_PATCH
	PY_DNS_RPC_ZONE_INFO_W2K_PATCH(&DNS_RPC_ZONE_INFO_W2K_Type);
#endif
#ifdef PY_DNS_RPC_ZONE_INFO_DOTNET_PATCH
	PY_DNS_RPC_ZONE_INFO_DOTNET_PATCH(&DNS_RPC_ZONE_INFO_DOTNET_Type);
#endif
#ifdef PY_DNS_RPC_ZONE_INFO_LONGHORN_PATCH
	PY_DNS_RPC_ZONE_INFO_LONGHORN_PATCH(&DNS_RPC_ZONE_INFO_LONGHORN_Type);
#endif
#ifdef PY_DNS_RPC_ZONE_SECONDARIES_W2K_PATCH
	PY_DNS_RPC_ZONE_SECONDARIES_W2K_PATCH(&DNS_RPC_ZONE_SECONDARIES_W2K_Type);
#endif
#ifdef PY_DNS_RPC_ZONE_SECONDARIES_DOTNET_PATCH
	PY_DNS_RPC_ZONE_SECONDARIES_DOTNET_PATCH(&DNS_RPC_ZONE_SECONDARIES_DOTNET_Type);
#endif
#ifdef PY_DNS_RPC_ZONE_SECONDARIES_LONGHORN_PATCH
	PY_DNS_RPC_ZONE_SECONDARIES_LONGHORN_PATCH(&DNS_RPC_ZONE_SECONDARIES_LONGHORN_Type);
#endif
#ifdef PY_DNS_RPC_ZONE_DATABASE_W2K_PATCH
	PY_DNS_RPC_ZONE_DATABASE_W2K_PATCH(&DNS_RPC_ZONE_DATABASE_W2K_Type);
#endif
#ifdef PY_DNS_RPC_ZONE_DATABASE_DOTNET_PATCH
	PY_DNS_RPC_ZONE_DATABASE_DOTNET_PATCH(&DNS_RPC_ZONE_DATABASE_DOTNET_Type);
#endif
#ifdef PY_DNS_RPC_ZONE_CREATE_INFO_W2K_PATCH
	PY_DNS_RPC_ZONE_CREATE_INFO_W2K_PATCH(&DNS_RPC_ZONE_CREATE_INFO_W2K_Type);
#endif
#ifdef PY_DNS_RPC_ZONE_CREATE_INFO_DOTNET_PATCH
	PY_DNS_RPC_ZONE_CREATE_INFO_DOTNET_PATCH(&DNS_RPC_ZONE_CREATE_INFO_DOTNET_Type);
#endif
#ifdef PY_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_PATCH
	PY_DNS_RPC_ZONE_CREATE_INFO_LONGHORN_PATCH(&DNS_RPC_ZONE_CREATE_INFO_LONGHORN_Type);
#endif
#ifdef PY_DNS_RPC_ZONE_EXPORT_INFO_PATCH
	PY_DNS_RPC_ZONE_EXPORT_INFO_PATCH(&DNS_RPC_ZONE_EXPORT_INFO_Type);
#endif
#ifdef PY_DNS_RPC_ENUM_ZONES_FILTER_PATCH
	PY_DNS_RPC_ENUM_ZONES_FILTER_PATCH(&DNS_RPC_ENUM_ZONES_FILTER_Type);
#endif
#ifdef PY_DNS_RPC_FORWARDERS_W2K_PATCH
	PY_DNS_RPC_FORWARDERS_W2K_PATCH(&DNS_RPC_FORWARDERS_W2K_Type);
#endif
#ifdef PY_DNS_RPC_FORWARDERS_DOTNET_PATCH
	PY_DNS_RPC_FORWARDERS_DOTNET_PATCH(&DNS_RPC_FORWARDERS_DOTNET_Type);
#endif
#ifdef PY_DNS_RPC_FORWARDERS_LONGHORN_PATCH
	PY_DNS_RPC_FORWARDERS_LONGHORN_PATCH(&DNS_RPC_FORWARDERS_LONGHORN_Type);
#endif
#ifdef PY_DNS_RPC_AUTOCONFIGURE_PATCH
	PY_DNS_RPC_AUTOCONFIGURE_PATCH(&DNS_RPC_AUTOCONFIGURE_Type);
#endif
#ifdef PY_DNSSRV_STAT_HEADER_PATCH
	PY_DNSSRV_STAT_HEADER_PATCH(&DNSSRV_STAT_HEADER_Type);
#endif
#ifdef PY_DNSSRV_STAT_PATCH
	PY_DNSSRV_STAT_PATCH(&DNSSRV_STAT_Type);
#endif
#ifdef PY_DNS_RPC_RECORDS_PATCH
	PY_DNS_RPC_RECORDS_PATCH(&DNS_RPC_RECORDS_Type);
#endif
#ifdef PY_DNS_RPC_RECORDS_ARRAY_PATCH
	PY_DNS_RPC_RECORDS_ARRAY_PATCH(&DNS_RPC_RECORDS_ARRAY_Type);
#endif
#ifdef PY_DNSSERVER_PATCH
	PY_DNSSERVER_PATCH(&dnsserver_InterfaceType);
#endif

	m = Py_InitModule3("dnsserver", dnsserver_methods, "dnsserver DCE/RPC");
	if (m == NULL)
		return;

	PyModule_AddObject(m, "DNS_ZONE_NOTIFY_OFF", PyInt_FromLong(DNS_ZONE_NOTIFY_OFF));
	PyModule_AddObject(m, "DNS_BOOT_METHOD_FILE", PyInt_FromLong(DNS_BOOT_METHOD_FILE));
	PyModule_AddObject(m, "DNSSRV_TYPEID_SERVER_INFO", PyInt_FromLong(DNSSRV_TYPEID_SERVER_INFO));
	PyModule_AddObject(m, "DNSSRV_TYPEID_SERVER_INFO_W2K", PyInt_FromLong(DNSSRV_TYPEID_SERVER_INFO_W2K));
	PyModule_AddObject(m, "DNS_ZONE_REQUEST_CUSTOM_DP", PyInt_FromLong(DNS_ZONE_REQUEST_CUSTOM_DP));
	PyModule_AddObject(m, "DNS_ZONE_REQUEST_STUB", PyInt_FromLong(DNS_ZONE_REQUEST_STUB));
	PyModule_AddObject(m, "DNSSRV_TYPEID_ZONE_EXPORT", PyInt_FromLong(DNSSRV_TYPEID_ZONE_EXPORT));
	PyModule_AddObject(m, "DNS_RPC_USE_TCPIP", PyInt_FromLong(DNS_RPC_USE_TCPIP));
	PyModule_AddObject(m, "DNS_RPC_AUTOCONFIG_INTERNAL_SELFPOINT_APPEND", PyInt_FromLong(DNS_RPC_AUTOCONFIG_INTERNAL_SELFPOINT_APPEND));
	PyModule_AddObject(m, "DNS_IPVAL_UNREACHABLE", PyInt_FromLong(DNS_IPVAL_UNREACHABLE));
	PyModule_AddObject(m, "DNS_IPVAL_DNS_FORWARDERS", PyInt_FromLong(DNS_IPVAL_DNS_FORWARDERS));
	PyModule_AddObject(m, "DNS_ZONE_REQUEST_FOREST_DP", PyInt_FromLong(DNS_ZONE_REQUEST_FOREST_DP));
	PyModule_AddObject(m, "DNSSRV_TYPEID_AUTOCONFIGURE", PyInt_FromLong(DNSSRV_TYPEID_AUTOCONFIGURE));
	PyModule_AddObject(m, "DNS_EVENT_LOG_INFORMATION_TYPE", PyInt_FromLong(DNS_EVENT_LOG_INFORMATION_TYPE));
	PyModule_AddObject(m, "DNSSRV_TYPEID_ZONE_CHANGE_DP", PyInt_FromLong(DNSSRV_TYPEID_ZONE_CHANGE_DP));
	PyModule_AddObject(m, "DNS_IPVAL_NO_TCP", PyInt_FromLong(DNS_IPVAL_NO_TCP));
	PyModule_AddObject(m, "DNS_RPC_ZONE_UPDATE_SECURE", PyInt_FromLong(DNS_RPC_ZONE_UPDATE_SECURE));
	PyModule_AddObject(m, "DNS_RPC_ZONE_AUTOCREATED", PyInt_FromLong(DNS_RPC_ZONE_AUTOCREATED));
	PyModule_AddObject(m, "DNS_ALLOW_RFC_NAMES_ONLY", PyInt_FromLong(DNS_ALLOW_RFC_NAMES_ONLY));
	PyModule_AddObject(m, "DNS_RPC_VIEW_AUTHORITY_DATA", PyInt_FromLong(DNS_RPC_VIEW_AUTHORITY_DATA));
	PyModule_AddObject(m, "DNS_CLIENT_VERSION_W2K", PyInt_FromLong(DNS_CLIENT_VERSION_W2K));
	PyModule_AddObject(m, "DNSSRV_TYPEID_ZONE_DATABASE", PyInt_FromLong(DNSSRV_TYPEID_ZONE_DATABASE));
	PyModule_AddObject(m, "DNS_ZONE_SECSECURE_NO_SECURITY", PyInt_FromLong(DNS_ZONE_SECSECURE_NO_SECURITY));
	PyModule_AddObject(m, "DNS_DP_STATE_REPL_INCOMING", PyInt_FromLong(DNS_DP_STATE_REPL_INCOMING));
	PyModule_AddObject(m, "DNS_ZONE_REQUEST_NON_DS", PyInt_FromLong(DNS_ZONE_REQUEST_NON_DS));
	PyModule_AddObject(m, "DNSSRV_TYPEID_DP_LIST", PyInt_FromLong(DNSSRV_TYPEID_DP_LIST));
	PyModule_AddObject(m, "DNS_RPC_USE_LPC", PyInt_FromLong(DNS_RPC_USE_LPC));
	PyModule_AddObject(m, "DNSSRV_TYPEID_ZONE_RENAME", PyInt_FromLong(DNSSRV_TYPEID_ZONE_RENAME));
	PyModule_AddObject(m, "DNS_IPVAL_DNS_ZONE_MASTERS", PyInt_FromLong(DNS_IPVAL_DNS_ZONE_MASTERS));
	PyModule_AddObject(m, "DNS_RPC_ZONE_SHUTDOWN", PyInt_FromLong(DNS_RPC_ZONE_SHUTDOWN));
	PyModule_AddObject(m, "DNS_DP_FOREST_DEFAULT", PyInt_FromLong(DNS_DP_FOREST_DEFAULT));
	PyModule_AddObject(m, "DNS_ZONE_REQUEST_CACHE", PyInt_FromLong(DNS_ZONE_REQUEST_CACHE));
	PyModule_AddObject(m, "DNSSRV_TYPEID_ZONE_SECONDARIES", PyInt_FromLong(DNSSRV_TYPEID_ZONE_SECONDARIES));
	PyModule_AddObject(m, "DNSSRV_TYPEID_FORWARDERS_W2K", PyInt_FromLong(DNSSRV_TYPEID_FORWARDERS_W2K));
	PyModule_AddObject(m, "DNS_ZONE_SECSECURE_LIST_ONLY", PyInt_FromLong(DNS_ZONE_SECSECURE_LIST_ONLY));
	PyModule_AddObject(m, "DNS_IPVAL_INVALID_ADDR", PyInt_FromLong(DNS_IPVAL_INVALID_ADDR));
	PyModule_AddObject(m, "DNS_ZONE_REQUEST_SECONDARY", PyInt_FromLong(DNS_ZONE_REQUEST_SECONDARY));
	PyModule_AddObject(m, "DNS_CLIENT_VERSION_LONGHORN", PyInt_FromLong(DNS_CLIENT_VERSION_LONGHORN));
	PyModule_AddObject(m, "DNSSRV_TYPEID_FORWARDERS", PyInt_FromLong(DNSSRV_TYPEID_FORWARDERS));
	PyModule_AddObject(m, "DNSSRV_TYPEID_IPARRAY", PyInt_FromLong(DNSSRV_TYPEID_IPARRAY));
	PyModule_AddObject(m, "DNSSRV_TYPEID_ZONE_INFO_W2K", PyInt_FromLong(DNSSRV_TYPEID_ZONE_INFO_W2K));
	PyModule_AddObject(m, "DNSSRV_TYPEID_ZONE_CREATE", PyInt_FromLong(DNSSRV_TYPEID_ZONE_CREATE));
	PyModule_AddObject(m, "DNSSRV_TYPEID_DWORD", PyInt_FromLong(DNSSRV_TYPEID_DWORD));
	PyModule_AddObject(m, "DNSSRV_TYPEID_ZONE_INFO", PyInt_FromLong(DNSSRV_TYPEID_ZONE_INFO));
	PyModule_AddObject(m, "DNSSRV_TYPEID_NULL", PyInt_FromLong(DNSSRV_TYPEID_NULL));
	PyModule_AddObject(m, "DNS_RPC_USE_NAMED_PIPE", PyInt_FromLong(DNS_RPC_USE_NAMED_PIPE));
	PyModule_AddObject(m, "DNS_DP_DOMAIN_DEFAULT", PyInt_FromLong(DNS_DP_DOMAIN_DEFAULT));
	PyModule_AddObject(m, "DNS_RPC_VIEW_NO_CHILDREN", PyInt_FromLong(DNS_RPC_VIEW_NO_CHILDREN));
	PyModule_AddObject(m, "DNS_DP_AUTOCREATED", PyInt_FromLong(DNS_DP_AUTOCREATED));
	PyModule_AddObject(m, "DNSSRV_TYPEID_LPWSTR", PyInt_FromLong(DNSSRV_TYPEID_LPWSTR));
	PyModule_AddObject(m, "DNS_DP_DELETED", PyInt_FromLong(DNS_DP_DELETED));
	PyModule_AddObject(m, "DNSSRV_TYPEID_ADDRARRAY", PyInt_FromLong(DNSSRV_TYPEID_ADDRARRAY));
	PyModule_AddObject(m, "DNS_RPC_AUTOCONFIG_INTERNAL_ZONES", PyInt_FromLong(DNS_RPC_AUTOCONFIG_INTERNAL_ZONES));
	PyModule_AddObject(m, "DNS_ZONE_REQUEST_REVERSE", PyInt_FromLong(DNS_ZONE_REQUEST_REVERSE));
	PyModule_AddObject(m, "DNS_DP_ENLISTED", PyInt_FromLong(DNS_DP_ENLISTED));
	PyModule_AddObject(m, "DNSSRV_TYPEID_ZONE", PyInt_FromLong(DNSSRV_TYPEID_ZONE));
	PyModule_AddObject(m, "DNS_BOOT_METHOD_REGISTRY", PyInt_FromLong(DNS_BOOT_METHOD_REGISTRY));
	PyModule_AddObject(m, "DNS_ZONE_REQUEST_AUTO", PyInt_FromLong(DNS_ZONE_REQUEST_AUTO));
	PyModule_AddObject(m, "DNS_RPC_VIEW_ONLY_CHILDREN", PyInt_FromLong(DNS_RPC_VIEW_ONLY_CHILDREN));
	PyModule_AddObject(m, "DNS_DP_STATE_UNKNOWN", PyInt_FromLong(DNS_DP_STATE_UNKNOWN));
	PyModule_AddObject(m, "DNS_BOOT_METHOD_UNINITIALIZED", PyInt_FromLong(DNS_BOOT_METHOD_UNINITIALIZED));
	PyModule_AddObject(m, "DNSSRV_TYPEID_NAME_AND_PARAM", PyInt_FromLong(DNSSRV_TYPEID_NAME_AND_PARAM));
	PyModule_AddObject(m, "DNSSRV_TYPEID_ZONE_SECONDARIES_DOTNET", PyInt_FromLong(DNSSRV_TYPEID_ZONE_SECONDARIES_DOTNET));
	PyModule_AddObject(m, "DNSSRV_TYPEID_ZONE_TYPE_RESET_DOTNET", PyInt_FromLong(DNSSRV_TYPEID_ZONE_TYPE_RESET_DOTNET));
	PyModule_AddObject(m, "DNS_RPC_AUTOCONFIG_INTERNAL_SELFPOINT_PREPEND", PyInt_FromLong(DNS_RPC_AUTOCONFIG_INTERNAL_SELFPOINT_PREPEND));
	PyModule_AddObject(m, "DNS_CLIENT_VERSION_DOTNET", PyInt_FromLong(DNS_CLIENT_VERSION_DOTNET));
	PyModule_AddObject(m, "DNSSRV_TYPEID_UTF8_STRING_LIST", PyInt_FromLong(DNSSRV_TYPEID_UTF8_STRING_LIST));
	PyModule_AddObject(m, "DNSSRV_TYPEID_UNICODE_STRING_LIST", PyInt_FromLong(DNSSRV_TYPEID_UNICODE_STRING_LIST));
	PyModule_AddObject(m, "DNSSRV_TYPEID_BUFFER", PyInt_FromLong(DNSSRV_TYPEID_BUFFER));
	PyModule_AddObject(m, "DNSSRV_TYPEID_ENLIST_DP", PyInt_FromLong(DNSSRV_TYPEID_ENLIST_DP));
	PyModule_AddObject(m, "DNS_DP_LEGACY", PyInt_FromLong(DNS_DP_LEGACY));
	PyModule_AddObject(m, "DNSSRV_TYPEID_ZONE_TYPE_RESET", PyInt_FromLong(DNSSRV_TYPEID_ZONE_TYPE_RESET));
	PyModule_AddObject(m, "DNS_IPVAL_DNS_ROOTHINTS", PyInt_FromLong(DNS_IPVAL_DNS_ROOTHINTS));
	PyModule_AddObject(m, "DNS_RPC_VIEW_ADDITIONAL_DATA", PyInt_FromLong(DNS_RPC_VIEW_ADDITIONAL_DATA));
	PyModule_AddObject(m, "DNSSRV_TYPEID_ZONE_DATABASE_W2K", PyInt_FromLong(DNSSRV_TYPEID_ZONE_DATABASE_W2K));
	PyModule_AddObject(m, "DNS_RPC_VIEW_CACHE_DATA", PyInt_FromLong(DNS_RPC_VIEW_CACHE_DATA));
	PyModule_AddObject(m, "ERROR_SUCCESS", PyInt_FromLong(ERROR_SUCCESS));
	PyModule_AddObject(m, "DNS_ZONE_NOTIFY_ALL_SECONDARIES", PyInt_FromLong(DNS_ZONE_NOTIFY_ALL_SECONDARIES));
	PyModule_AddObject(m, "DNS_ZONE_REQUEST_LEGACY_DP", PyInt_FromLong(DNS_ZONE_REQUEST_LEGACY_DP));
	PyModule_AddObject(m, "DNSSRV_TYPEID_DP_INFO", PyInt_FromLong(DNSSRV_TYPEID_DP_INFO));
	PyModule_AddObject(m, "DNS_RPC_ZONE_PAUSED", PyInt_FromLong(DNS_RPC_ZONE_PAUSED));
	PyModule_AddObject(m, "DNS_ZONE_REQUEST_DOMAIN_DP", PyInt_FromLong(DNS_ZONE_REQUEST_DOMAIN_DP));
	PyModule_AddObject(m, "DNSSRV_TYPEID_DP_ENUM", PyInt_FromLong(DNSSRV_TYPEID_DP_ENUM));
	PyModule_AddObject(m, "DNS_ZONE_NOTIFY_LIST_ONLY", PyInt_FromLong(DNS_ZONE_NOTIFY_LIST_ONLY));
	PyModule_AddObject(m, "DNS_ALLOW_ALL_NAMES", PyInt_FromLong(DNS_ALLOW_ALL_NAMES));
	PyModule_AddObject(m, "DNS_ZONE_REQUEST_FORWARD", PyInt_FromLong(DNS_ZONE_REQUEST_FORWARD));
	PyModule_AddObject(m, "DNS_RPC_AUTOCONFIG_INTERNAL_FORWARDERS", PyInt_FromLong(DNS_RPC_AUTOCONFIG_INTERNAL_FORWARDERS));
	PyModule_AddObject(m, "DNSSRV_TYPEID_STATS", PyInt_FromLong(DNSSRV_TYPEID_STATS));
	PyModule_AddObject(m, "DNS_RPC_ZONE_REVERSE", PyInt_FromLong(DNS_RPC_ZONE_REVERSE));
	PyModule_AddObject(m, "DNS_RPC_USE_ALL_PROTOCOLS", PyInt_FromLong(DNS_RPC_USE_ALL_PROTOCOLS));
	PyModule_AddObject(m, "DNSSRV_TYPEID_LPSTR", PyInt_FromLong(DNSSRV_TYPEID_LPSTR));
	PyModule_AddObject(m, "DNS_DP_OKAY", PyInt_FromLong(DNS_DP_OKAY));
	PyModule_AddObject(m, "DNS_RPC_AUTOCONFIG_INTERNAL_RETURN_ERROR", PyInt_FromLong(DNS_RPC_AUTOCONFIG_INTERNAL_RETURN_ERROR));
	PyModule_AddObject(m, "DNS_ZONE_REQUEST_PRIMARY", PyInt_FromLong(DNS_ZONE_REQUEST_PRIMARY));
	PyModule_AddObject(m, "DNSSRV_TYPEID_SERVER_INFO_DOTNET", PyInt_FromLong(DNSSRV_TYPEID_SERVER_INFO_DOTNET));
	PyModule_AddObject(m, "DNS_ZONE_REQUEST_DS", PyInt_FromLong(DNS_ZONE_REQUEST_DS));
	PyModule_AddObject(m, "DNS_ZONE_SECSECURE_NS_ONLY", PyInt_FromLong(DNS_ZONE_SECSECURE_NS_ONLY));
	PyModule_AddObject(m, "DNS_IPVAL_NOT_AUTH_FOR_ZONE", PyInt_FromLong(DNS_IPVAL_NOT_AUTH_FOR_ZONE));
	PyModule_AddObject(m, "DNS_IPVAL_NO_RESPONSE", PyInt_FromLong(DNS_IPVAL_NO_RESPONSE));
	PyModule_AddObject(m, "DNSSRV_TYPEID_ZONE_TYPE_RESET_W2K", PyInt_FromLong(DNSSRV_TYPEID_ZONE_TYPE_RESET_W2K));
	PyModule_AddObject(m, "DNSSRV_TYPEID_ENUM_ZONES_FILTER", PyInt_FromLong(DNSSRV_TYPEID_ENUM_ZONES_FILTER));
	PyModule_AddObject(m, "DNS_RPC_VIEW_GLUE_DATA", PyInt_FromLong(DNS_RPC_VIEW_GLUE_DATA));
	PyModule_AddObject(m, "DNS_ZONE_SECSECURE_NO_XFER", PyInt_FromLong(DNS_ZONE_SECSECURE_NO_XFER));
	PyModule_AddObject(m, "DNSSRV_TYPEID_ZONE_INFO_DOTNET", PyInt_FromLong(DNSSRV_TYPEID_ZONE_INFO_DOTNET));
	PyModule_AddObject(m, "DNS_RPC_ZONE_DSINTEGRATED", PyInt_FromLong(DNS_RPC_ZONE_DSINTEGRATED));
	PyModule_AddObject(m, "DNS_DP_STATE_REPL_OUTGOING", PyInt_FromLong(DNS_DP_STATE_REPL_OUTGOING));
	PyModule_AddObject(m, "DNSSRV_TYPEID_ZONE_W2K", PyInt_FromLong(DNSSRV_TYPEID_ZONE_W2K));
	PyModule_AddObject(m, "DNS_RPC_ZONE_UPDATE_UNSECURE", PyInt_FromLong(DNS_RPC_ZONE_UPDATE_UNSECURE));
	PyModule_AddObject(m, "DNS_RPC_VIEW_ROOT_HINT_DATA", PyInt_FromLong(DNS_RPC_VIEW_ROOT_HINT_DATA));
	PyModule_AddObject(m, "DNS_EVENT_LOG_SUCCESS", PyInt_FromLong(DNS_EVENT_LOG_SUCCESS));
	PyModule_AddObject(m, "DNS_IPVAL_UNKNOWN_ERROR", PyInt_FromLong(DNS_IPVAL_UNKNOWN_ERROR));
	PyModule_AddObject(m, "DNS_RPC_AUTOCONFIG_INTERNAL_SELFPOINT", PyInt_FromLong(DNS_RPC_AUTOCONFIG_INTERNAL_SELFPOINT));
	PyModule_AddObject(m, "DNSSRV_TYPEID_IP_VALIDATE", PyInt_FromLong(DNSSRV_TYPEID_IP_VALIDATE));
	PyModule_AddObject(m, "DNS_EVENT_LOG_WARNING_TYPE", PyInt_FromLong(DNS_EVENT_LOG_WARNING_TYPE));
	PyModule_AddObject(m, "DNSSRV_TYPEID_ZONE_CREATE_DOTNET", PyInt_FromLong(DNSSRV_TYPEID_ZONE_CREATE_DOTNET));
	PyModule_AddObject(m, "DNSSRV_TYPEID_ZONE_CREATE_W2K", PyInt_FromLong(DNSSRV_TYPEID_ZONE_CREATE_W2K));
	PyModule_AddObject(m, "DNS_RPC_AUTOCONFIG_INTERNAL_ROOTHINTS", PyInt_FromLong(DNS_RPC_AUTOCONFIG_INTERNAL_ROOTHINTS));
	PyModule_AddObject(m, "DNS_ALLOW_MULTIBYTE_NAMES", PyInt_FromLong(DNS_ALLOW_MULTIBYTE_NAMES));
	PyModule_AddObject(m, "DNSSRV_TYPEID_FORWARDERS_DOTNET", PyInt_FromLong(DNSSRV_TYPEID_FORWARDERS_DOTNET));
	PyModule_AddObject(m, "DNSSRV_TYPEID_ZONE_LIST_W2K", PyInt_FromLong(DNSSRV_TYPEID_ZONE_LIST_W2K));
	PyModule_AddObject(m, "DNS_IPVAL_DNS_SERVERS", PyInt_FromLong(DNS_IPVAL_DNS_SERVERS));
	PyModule_AddObject(m, "DNSSRV_TYPEID_ZONE_SECONDARIES_W2K", PyInt_FromLong(DNSSRV_TYPEID_ZONE_SECONDARIES_W2K));
	PyModule_AddObject(m, "DNSSRV_TYPEID_ZONE_LIST", PyInt_FromLong(DNSSRV_TYPEID_ZONE_LIST));
	PyModule_AddObject(m, "DNS_RPC_AUTOCONFIG_ALL", PyInt_FromLong(DNS_RPC_AUTOCONFIG_ALL));
	PyModule_AddObject(m, "DNS_IPVAL_DNS_DELEGATIONS", PyInt_FromLong(DNS_IPVAL_DNS_DELEGATIONS));
	PyModule_AddObject(m, "DNS_RPC_ZONE_READONLY", PyInt_FromLong(DNS_RPC_ZONE_READONLY));
	PyModule_AddObject(m, "DNS_ZONE_REQUEST_FORWARDER", PyInt_FromLong(DNS_ZONE_REQUEST_FORWARDER));
	PyModule_AddObject(m, "DNS_ALLOW_NONRFC_NAMES", PyInt_FromLong(DNS_ALLOW_NONRFC_NAMES));
	PyModule_AddObject(m, "DNS_RPC_ZONE_AGING", PyInt_FromLong(DNS_RPC_ZONE_AGING));
	PyModule_AddObject(m, "DNS_EVENT_LOG_ERROR_TYPE", PyInt_FromLong(DNS_EVENT_LOG_ERROR_TYPE));
	PyModule_AddObject(m, "DNS_BOOT_METHOD_DIRECTORY", PyInt_FromLong(DNS_BOOT_METHOD_DIRECTORY));
	Py_INCREF((PyObject *)(void *)&DNS_RPC_BUFFER_Type);
	PyModule_AddObject(m, "DNS_RPC_BUFFER", (PyObject *)(void *)&DNS_RPC_BUFFER_Type);
	Py_INCREF((PyObject *)(void *)&DNS_RPC_UTF8_STRING_LIST_Type);
	PyModule_AddObject(m, "DNS_RPC_UTF8_STRING_LIST", (PyObject *)(void *)&DNS_RPC_UTF8_STRING_LIST_Type);
	Py_INCREF((PyObject *)(void *)&DNS_RPC_NAME_AND_PARAM_Type);
	PyModule_AddObject(m, "DNS_RPC_NAME_AND_PARAM", (PyObject *)(void *)&DNS_RPC_NAME_AND_PARAM_Type);
	Py_INCREF((PyObject *)(void *)&DNS_RPC_NAME_Type);
	PyModule_AddObject(m, "DNS_RPC_NAME", (PyObject *)(void *)&DNS_RPC_NAME_Type);
	Py_INCREF((PyObject *)(void *)&DNS_RPC_NODE_Type);
	PyModule_AddObject(m, "DNS_RPC_NODE", (PyObject *)(void *)&DNS_RPC_NODE_Type);
	Py_INCREF((PyObject *)(void *)&DNS_RPC_RECORD_SOA_Type);
	PyModule_AddObject(m, "DNS_RPC_RECORD_SOA", (PyObject *)(void *)&DNS_RPC_RECORD_SOA_Type);
	Py_INCREF((PyObject *)(void *)&DNS_RPC_RECORD_NAME_PREFERENCE_Type);
	PyModule_AddObject(m, "DNS_RPC_RECORD_NAME_PREFERENCE", (PyObject *)(void *)&DNS_RPC_RECORD_NAME_PREFERENCE_Type);
	Py_INCREF((PyObject *)(void *)&DNS_RPC_RECORD_STRING_Type);
	PyModule_AddObject(m, "DNS_RPC_RECORD_STRING", (PyObject *)(void *)&DNS_RPC_RECORD_STRING_Type);
	Py_INCREF((PyObject *)(void *)&DNS_RPC_RECORD_SRV_Type);
	PyModule_AddObject(m, "DNS_RPC_RECORD_SRV", (PyObject *)(void *)&DNS_RPC_RECORD_SRV_Type);
	Py_INCREF((PyObject *)(void *)&DNS_RPC_RECORD_Type);
	PyModule_AddObject(m, "DNS_RPC_RECORD", (PyObject *)(void *)&DNS_RPC_RECORD_Type);
	Py_INCREF((PyObject *)(void *)&DNS_RPC_RECORD_BUF_Type);
	PyModule_AddObject(m, "DNS_RPC_RECORD_BUF", (PyObject *)(void *)&DNS_RPC_RECORD_BUF_Type);
	Py_INCREF((PyObject *)(void *)&IP4_ARRAY_Type);
	PyModule_AddObject(m, "IP4_ARRAY", (PyObject *)(void *)&IP4_ARRAY_Type);
	Py_INCREF((PyObject *)(void *)&DNS_ADDR_Type);
	PyModule_AddObject(m, "DNS_ADDR", (PyObject *)(void *)&DNS_ADDR_Type);
	Py_INCREF((PyObject *)(void *)&DNS_ADDR_ARRAY_Type);
	PyModule_AddObject(m, "DNS_ADDR_ARRAY", (PyObject *)(void *)&DNS_ADDR_ARRAY_Type);
	Py_INCREF((PyObject *)(void *)&DNS_RPC_IP_VALIDATE_Type);
	PyModule_AddObject(m, "DNS_RPC_IP_VALIDATE", (PyObject *)(void *)&DNS_RPC_IP_VALIDATE_Type);
	Py_INCREF((PyObject *)(void *)&DNS_RPC_SERVER_INFO_W2K_Type);
	PyModule_AddObject(m, "DNS_RPC_SERVER_INFO_W2K", (PyObject *)(void *)&DNS_RPC_SERVER_INFO_W2K_Type);
	Py_INCREF((PyObject *)(void *)&DNS_EXTENSION_Type);
	PyModule_AddObject(m, "DNS_EXTENSION", (PyObject *)(void *)&DNS_EXTENSION_Type);
	Py_INCREF((PyObject *)(void *)&DNS_RPC_SERVER_INFO_DOTNET_Type);
	PyModule_AddObject(m, "DNS_RPC_SERVER_INFO_DOTNET", (PyObject *)(void *)&DNS_RPC_SERVER_INFO_DOTNET_Type);
	Py_INCREF((PyObject *)(void *)&DNS_RPC_SERVER_INFO_LONGHORN_Type);
	PyModule_AddObject(m, "DNS_RPC_SERVER_INFO_LONGHORN", (PyObject *)(void *)&DNS_RPC_SERVER_INFO_LONGHORN_Type);
	Py_INCREF((PyObject *)(void *)&DNS_RPC_DP_REPLICA_Type);
	PyModule_AddObject(m, "DNS_RPC_DP_REPLICA", (PyObject *)(void *)&DNS_RPC_DP_REPLICA_Type);
	Py_INCREF((PyObject *)(void *)&DNS_RPC_DP_INFO_Type);
	PyModule_AddObject(m, "DNS_RPC_DP_INFO", (PyObject *)(void *)&DNS_RPC_DP_INFO_Type);
	Py_INCREF((PyObject *)(void *)&DNS_RPC_DP_ENUM_Type);
	PyModule_AddObject(m, "DNS_RPC_DP_ENUM", (PyObject *)(void *)&DNS_RPC_DP_ENUM_Type);
	Py_INCREF((PyObject *)(void *)&DNS_RPC_DP_LIST_Type);
	PyModule_AddObject(m, "DNS_RPC_DP_LIST", (PyObject *)(void *)&DNS_RPC_DP_LIST_Type);
	Py_INCREF((PyObject *)(void *)&DNS_RPC_ENLIST_DP_Type);
	PyModule_AddObject(m, "DNS_RPC_ENLIST_DP", (PyObject *)(void *)&DNS_RPC_ENLIST_DP_Type);
	Py_INCREF((PyObject *)(void *)&DNS_RPC_ZONE_CHANGE_DP_Type);
	PyModule_AddObject(m, "DNS_RPC_ZONE_CHANGE_DP", (PyObject *)(void *)&DNS_RPC_ZONE_CHANGE_DP_Type);
	Py_INCREF((PyObject *)(void *)&DNS_RPC_ZONE_W2K_Type);
	PyModule_AddObject(m, "DNS_RPC_ZONE_W2K", (PyObject *)(void *)&DNS_RPC_ZONE_W2K_Type);
	Py_INCREF((PyObject *)(void *)&DNS_RPC_ZONE_DOTNET_Type);
	PyModule_AddObject(m, "DNS_RPC_ZONE_DOTNET", (PyObject *)(void *)&DNS_RPC_ZONE_DOTNET_Type);
	Py_INCREF((PyObject *)(void *)&DNS_RPC_ZONE_LIST_W2K_Type);
	PyModule_AddObject(m, "DNS_RPC_ZONE_LIST_W2K", (PyObject *)(void *)&DNS_RPC_ZONE_LIST_W2K_Type);
	Py_INCREF((PyObject *)(void *)&DNS_RPC_ZONE_LIST_DOTNET_Type);
	PyModule_AddObject(m, "DNS_RPC_ZONE_LIST_DOTNET", (PyObject *)(void *)&DNS_RPC_ZONE_LIST_DOTNET_Type);
	Py_INCREF((PyObject *)(void *)&DNS_RPC_ZONE_INFO_W2K_Type);
	PyModule_AddObject(m, "DNS_RPC_ZONE_INFO_W2K", (PyObject *)(void *)&DNS_RPC_ZONE_INFO_W2K_Type);
	Py_INCREF((PyObject *)(void *)&DNS_RPC_ZONE_INFO_DOTNET_Type);
	PyModule_AddObject(m, "DNS_RPC_ZONE_INFO_DOTNET", (PyObject *)(void *)&DNS_RPC_ZONE_INFO_DOTNET_Type);
	Py_INCREF((PyObject *)(void *)&DNS_RPC_ZONE_INFO_LONGHORN_Type);
	PyModule_AddObject(m, "DNS_RPC_ZONE_INFO_LONGHORN", (PyObject *)(void *)&DNS_RPC_ZONE_INFO_LONGHORN_Type);
	Py_INCREF((PyObject *)(void *)&DNS_RPC_ZONE_SECONDARIES_W2K_Type);
	PyModule_AddObject(m, "DNS_RPC_ZONE_SECONDARIES_W2K", (PyObject *)(void *)&DNS_RPC_ZONE_SECONDARIES_W2K_Type);
	Py_INCREF((PyObject *)(void *)&DNS_RPC_ZONE_SECONDARIES_DOTNET_Type);
	PyModule_AddObject(m, "DNS_RPC_ZONE_SECONDARIES_DOTNET", (PyObject *)(void *)&DNS_RPC_ZONE_SECONDARIES_DOTNET_Type);
	Py_INCREF((PyObject *)(void *)&DNS_RPC_ZONE_SECONDARIES_LONGHORN_Type);
	PyModule_AddObject(m, "DNS_RPC_ZONE_SECONDARIES_LONGHORN", (PyObject *)(void *)&DNS_RPC_ZONE_SECONDARIES_LONGHORN_Type);
	Py_INCREF((PyObject *)(void *)&DNS_RPC_ZONE_DATABASE_W2K_Type);
	PyModule_AddObject(m, "DNS_RPC_ZONE_DATABASE_W2K", (PyObject *)(void *)&DNS_RPC_ZONE_DATABASE_W2K_Type);
	Py_INCREF((PyObject *)(void *)&DNS_RPC_ZONE_DATABASE_DOTNET_Type);
	PyModule_AddObject(m, "DNS_RPC_ZONE_DATABASE_DOTNET", (PyObject *)(void *)&DNS_RPC_ZONE_DATABASE_DOTNET_Type);
	Py_INCREF((PyObject *)(void *)&DNS_RPC_ZONE_CREATE_INFO_W2K_Type);
	PyModule_AddObject(m, "DNS_RPC_ZONE_CREATE_INFO_W2K", (PyObject *)(void *)&DNS_RPC_ZONE_CREATE_INFO_W2K_Type);
	Py_INCREF((PyObject *)(void *)&DNS_RPC_ZONE_CREATE_INFO_DOTNET_Type);
	PyModule_AddObject(m, "DNS_RPC_ZONE_CREATE_INFO_DOTNET", (PyObject *)(void *)&DNS_RPC_ZONE_CREATE_INFO_DOTNET_Type);
	Py_INCREF((PyObject *)(void *)&DNS_RPC_ZONE_CREATE_INFO_LONGHORN_Type);
	PyModule_AddObject(m, "DNS_RPC_ZONE_CREATE_INFO_LONGHORN", (PyObject *)(void *)&DNS_RPC_ZONE_CREATE_INFO_LONGHORN_Type);
	Py_INCREF((PyObject *)(void *)&DNS_RPC_ZONE_EXPORT_INFO_Type);
	PyModule_AddObject(m, "DNS_RPC_ZONE_EXPORT_INFO", (PyObject *)(void *)&DNS_RPC_ZONE_EXPORT_INFO_Type);
	Py_INCREF((PyObject *)(void *)&DNS_RPC_ENUM_ZONES_FILTER_Type);
	PyModule_AddObject(m, "DNS_RPC_ENUM_ZONES_FILTER", (PyObject *)(void *)&DNS_RPC_ENUM_ZONES_FILTER_Type);
	Py_INCREF((PyObject *)(void *)&DNS_RPC_FORWARDERS_W2K_Type);
	PyModule_AddObject(m, "DNS_RPC_FORWARDERS_W2K", (PyObject *)(void *)&DNS_RPC_FORWARDERS_W2K_Type);
	Py_INCREF((PyObject *)(void *)&DNS_RPC_FORWARDERS_DOTNET_Type);
	PyModule_AddObject(m, "DNS_RPC_FORWARDERS_DOTNET", (PyObject *)(void *)&DNS_RPC_FORWARDERS_DOTNET_Type);
	Py_INCREF((PyObject *)(void *)&DNS_RPC_FORWARDERS_LONGHORN_Type);
	PyModule_AddObject(m, "DNS_RPC_FORWARDERS_LONGHORN", (PyObject *)(void *)&DNS_RPC_FORWARDERS_LONGHORN_Type);
	Py_INCREF((PyObject *)(void *)&DNS_RPC_AUTOCONFIGURE_Type);
	PyModule_AddObject(m, "DNS_RPC_AUTOCONFIGURE", (PyObject *)(void *)&DNS_RPC_AUTOCONFIGURE_Type);
	Py_INCREF((PyObject *)(void *)&DNSSRV_STAT_HEADER_Type);
	PyModule_AddObject(m, "DNSSRV_STAT_HEADER", (PyObject *)(void *)&DNSSRV_STAT_HEADER_Type);
	Py_INCREF((PyObject *)(void *)&DNSSRV_STAT_Type);
	PyModule_AddObject(m, "DNSSRV_STAT", (PyObject *)(void *)&DNSSRV_STAT_Type);
	Py_INCREF((PyObject *)(void *)&DNS_RPC_RECORDS_Type);
	PyModule_AddObject(m, "DNS_RPC_RECORDS", (PyObject *)(void *)&DNS_RPC_RECORDS_Type);
	Py_INCREF((PyObject *)(void *)&DNS_RPC_RECORDS_ARRAY_Type);
	PyModule_AddObject(m, "DNS_RPC_RECORDS_ARRAY", (PyObject *)(void *)&DNS_RPC_RECORDS_ARRAY_Type);
	Py_INCREF((PyObject *)(void *)&dnsserver_InterfaceType);
	PyModule_AddObject(m, "dnsserver", (PyObject *)(void *)&dnsserver_InterfaceType);
#ifdef PY_MOD_DNSSERVER_PATCH
	PY_MOD_DNSSERVER_PATCH(m);
#endif

}
