/* client functions auto-generated by pidl */

#include "includes.h"
#include <tevent.h>
#include "lib/util/tevent_ntstatus.h"
#include "autoconf/librpc/gen_ndr/ndr_wkssvc.h"
#include "autoconf/librpc/gen_ndr/ndr_wkssvc_c.h"

/* wkssvc - client functions generated by pidl */

struct dcerpc_wkssvc_NetWkstaGetInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetWkstaGetInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetWkstaGetInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wkssvc_NetWkstaGetInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetWkstaGetInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetWkstaGetInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETWKSTAGETINFO, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetWkstaGetInfo_r_done, req);

	return req;
}

static void dcerpc_wkssvc_NetWkstaGetInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetWkstaGetInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wkssvc_NetWkstaGetInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wkssvc_NetWkstaGetInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetWkstaGetInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wkssvc_NetWkstaGetInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETWKSTAGETINFO, mem_ctx, r);

	return status;
}

struct dcerpc_wkssvc_NetWkstaGetInfo_state {
	struct wkssvc_NetWkstaGetInfo orig;
	struct wkssvc_NetWkstaGetInfo tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetWkstaGetInfo_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetWkstaGetInfo_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      const char *_server_name /* [in] [charset(UTF16),unique] */,
						      uint32_t _level /* [in]  */,
						      union wkssvc_NetWkstaInfo *_info /* [out] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetWkstaGetInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetWkstaGetInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.level = _level;

	/* Out parameters */
	state->orig.out.info = _info;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wkssvc_NetWkstaGetInfo_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wkssvc_NetWkstaGetInfo_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetWkstaGetInfo_done, req);
	return req;
}

static void dcerpc_wkssvc_NetWkstaGetInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wkssvc_NetWkstaGetInfo_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetWkstaGetInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wkssvc_NetWkstaGetInfo_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetWkstaGetInfo_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    WERROR *result)
{
	struct dcerpc_wkssvc_NetWkstaGetInfo_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetWkstaGetInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetWkstaGetInfo(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       const char *_server_name /* [in] [charset(UTF16),unique] */,
				       uint32_t _level /* [in]  */,
				       union wkssvc_NetWkstaInfo *_info /* [out] [ref,switch_is(level)] */,
				       WERROR *result)
{
	struct wkssvc_NetWkstaGetInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.level = _level;

	/* Out parameters */
	r.out.info = _info;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_wkssvc_NetWkstaGetInfo_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_info = *r.out.info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wkssvc_NetWkstaSetInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetWkstaSetInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetWkstaSetInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wkssvc_NetWkstaSetInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetWkstaSetInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetWkstaSetInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETWKSTASETINFO, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetWkstaSetInfo_r_done, req);

	return req;
}

static void dcerpc_wkssvc_NetWkstaSetInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetWkstaSetInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wkssvc_NetWkstaSetInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wkssvc_NetWkstaSetInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetWkstaSetInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wkssvc_NetWkstaSetInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETWKSTASETINFO, mem_ctx, r);

	return status;
}

struct dcerpc_wkssvc_NetWkstaSetInfo_state {
	struct wkssvc_NetWkstaSetInfo orig;
	struct wkssvc_NetWkstaSetInfo tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetWkstaSetInfo_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetWkstaSetInfo_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      const char *_server_name /* [in] [charset(UTF16),unique] */,
						      uint32_t _level /* [in]  */,
						      union wkssvc_NetWkstaInfo *_info /* [in] [switch_is(level),ref] */,
						      uint32_t *_parm_error /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetWkstaSetInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetWkstaSetInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.level = _level;
	state->orig.in.info = _info;
	state->orig.in.parm_error = _parm_error;

	/* Out parameters */
	state->orig.out.parm_error = _parm_error;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wkssvc_NetWkstaSetInfo_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wkssvc_NetWkstaSetInfo_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetWkstaSetInfo_done, req);
	return req;
}

static void dcerpc_wkssvc_NetWkstaSetInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wkssvc_NetWkstaSetInfo_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetWkstaSetInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wkssvc_NetWkstaSetInfo_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.parm_error = *state->tmp.out.parm_error;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetWkstaSetInfo_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    WERROR *result)
{
	struct dcerpc_wkssvc_NetWkstaSetInfo_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetWkstaSetInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetWkstaSetInfo(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       const char *_server_name /* [in] [charset(UTF16),unique] */,
				       uint32_t _level /* [in]  */,
				       union wkssvc_NetWkstaInfo *_info /* [in] [switch_is(level),ref] */,
				       uint32_t *_parm_error /* [in,out] [ref] */,
				       WERROR *result)
{
	struct wkssvc_NetWkstaSetInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.level = _level;
	r.in.info = _info;
	r.in.parm_error = _parm_error;

	/* Out parameters */
	r.out.parm_error = _parm_error;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_wkssvc_NetWkstaSetInfo_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_parm_error = *r.out.parm_error;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wkssvc_NetWkstaEnumUsers_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetWkstaEnumUsers_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetWkstaEnumUsers_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wkssvc_NetWkstaEnumUsers *r)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetWkstaEnumUsers_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetWkstaEnumUsers_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETWKSTAENUMUSERS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetWkstaEnumUsers_r_done, req);

	return req;
}

static void dcerpc_wkssvc_NetWkstaEnumUsers_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetWkstaEnumUsers_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wkssvc_NetWkstaEnumUsers_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wkssvc_NetWkstaEnumUsers_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetWkstaEnumUsers_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wkssvc_NetWkstaEnumUsers *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETWKSTAENUMUSERS, mem_ctx, r);

	return status;
}

struct dcerpc_wkssvc_NetWkstaEnumUsers_state {
	struct wkssvc_NetWkstaEnumUsers orig;
	struct wkssvc_NetWkstaEnumUsers tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetWkstaEnumUsers_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetWkstaEnumUsers_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							const char *_server_name /* [in] [unique,charset(UTF16)] */,
							struct wkssvc_NetWkstaEnumUsersInfo *_info /* [in,out] [ref] */,
							uint32_t _prefmaxlen /* [in]  */,
							uint32_t *_entries_read /* [out] [ref] */,
							uint32_t *_resume_handle /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetWkstaEnumUsers_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetWkstaEnumUsers_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.info = _info;
	state->orig.in.prefmaxlen = _prefmaxlen;
	state->orig.in.resume_handle = _resume_handle;

	/* Out parameters */
	state->orig.out.info = _info;
	state->orig.out.entries_read = _entries_read;
	state->orig.out.resume_handle = _resume_handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wkssvc_NetWkstaEnumUsers_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wkssvc_NetWkstaEnumUsers_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetWkstaEnumUsers_done, req);
	return req;
}

static void dcerpc_wkssvc_NetWkstaEnumUsers_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wkssvc_NetWkstaEnumUsers_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetWkstaEnumUsers_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wkssvc_NetWkstaEnumUsers_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;
	*state->orig.out.entries_read = *state->tmp.out.entries_read;
	if (state->orig.out.resume_handle && state->tmp.out.resume_handle) {
		*state->orig.out.resume_handle = *state->tmp.out.resume_handle;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetWkstaEnumUsers_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      WERROR *result)
{
	struct dcerpc_wkssvc_NetWkstaEnumUsers_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetWkstaEnumUsers_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetWkstaEnumUsers(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 const char *_server_name /* [in] [unique,charset(UTF16)] */,
					 struct wkssvc_NetWkstaEnumUsersInfo *_info /* [in,out] [ref] */,
					 uint32_t _prefmaxlen /* [in]  */,
					 uint32_t *_entries_read /* [out] [ref] */,
					 uint32_t *_resume_handle /* [in,out] [unique] */,
					 WERROR *result)
{
	struct wkssvc_NetWkstaEnumUsers r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.info = _info;
	r.in.prefmaxlen = _prefmaxlen;
	r.in.resume_handle = _resume_handle;

	/* Out parameters */
	r.out.info = _info;
	r.out.entries_read = _entries_read;
	r.out.resume_handle = _resume_handle;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_wkssvc_NetWkstaEnumUsers_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_info = *r.out.info;
	*_entries_read = *r.out.entries_read;
	if (_resume_handle && r.out.resume_handle) {
		*_resume_handle = *r.out.resume_handle;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wkssvc_NetrWkstaUserGetInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrWkstaUserGetInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrWkstaUserGetInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wkssvc_NetrWkstaUserGetInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrWkstaUserGetInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrWkstaUserGetInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRWKSTAUSERGETINFO, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrWkstaUserGetInfo_r_done, req);

	return req;
}

static void dcerpc_wkssvc_NetrWkstaUserGetInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrWkstaUserGetInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wkssvc_NetrWkstaUserGetInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wkssvc_NetrWkstaUserGetInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrWkstaUserGetInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wkssvc_NetrWkstaUserGetInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRWKSTAUSERGETINFO, mem_ctx, r);

	return status;
}

struct dcerpc_wkssvc_NetrWkstaUserGetInfo_state {
	struct wkssvc_NetrWkstaUserGetInfo orig;
	struct wkssvc_NetrWkstaUserGetInfo tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrWkstaUserGetInfo_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrWkstaUserGetInfo_send(TALLOC_CTX *mem_ctx,
							   struct tevent_context *ev,
							   struct dcerpc_binding_handle *h,
							   const char *_unknown /* [in] [unique,charset(UTF16)] */,
							   uint32_t _level /* [in]  */,
							   union wkssvc_NetrWkstaUserInfo *_info /* [out] [ref,switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrWkstaUserGetInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrWkstaUserGetInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.unknown = _unknown;
	state->orig.in.level = _level;

	/* Out parameters */
	state->orig.out.info = _info;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wkssvc_NetrWkstaUserGetInfo_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wkssvc_NetrWkstaUserGetInfo_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrWkstaUserGetInfo_done, req);
	return req;
}

static void dcerpc_wkssvc_NetrWkstaUserGetInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wkssvc_NetrWkstaUserGetInfo_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrWkstaUserGetInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wkssvc_NetrWkstaUserGetInfo_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrWkstaUserGetInfo_recv(struct tevent_req *req,
						 TALLOC_CTX *mem_ctx,
						 WERROR *result)
{
	struct dcerpc_wkssvc_NetrWkstaUserGetInfo_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrWkstaUserGetInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrWkstaUserGetInfo(struct dcerpc_binding_handle *h,
					    TALLOC_CTX *mem_ctx,
					    const char *_unknown /* [in] [unique,charset(UTF16)] */,
					    uint32_t _level /* [in]  */,
					    union wkssvc_NetrWkstaUserInfo *_info /* [out] [ref,switch_is(level)] */,
					    WERROR *result)
{
	struct wkssvc_NetrWkstaUserGetInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.unknown = _unknown;
	r.in.level = _level;

	/* Out parameters */
	r.out.info = _info;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_wkssvc_NetrWkstaUserGetInfo_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_info = *r.out.info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wkssvc_NetrWkstaUserSetInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrWkstaUserSetInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrWkstaUserSetInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wkssvc_NetrWkstaUserSetInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrWkstaUserSetInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrWkstaUserSetInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRWKSTAUSERSETINFO, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrWkstaUserSetInfo_r_done, req);

	return req;
}

static void dcerpc_wkssvc_NetrWkstaUserSetInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrWkstaUserSetInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wkssvc_NetrWkstaUserSetInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wkssvc_NetrWkstaUserSetInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrWkstaUserSetInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wkssvc_NetrWkstaUserSetInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRWKSTAUSERSETINFO, mem_ctx, r);

	return status;
}

struct dcerpc_wkssvc_NetrWkstaUserSetInfo_state {
	struct wkssvc_NetrWkstaUserSetInfo orig;
	struct wkssvc_NetrWkstaUserSetInfo tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrWkstaUserSetInfo_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrWkstaUserSetInfo_send(TALLOC_CTX *mem_ctx,
							   struct tevent_context *ev,
							   struct dcerpc_binding_handle *h,
							   const char *_unknown /* [in] [charset(UTF16),unique] */,
							   uint32_t _level /* [in]  */,
							   union wkssvc_NetrWkstaUserInfo *_info /* [in] [switch_is(level),ref] */,
							   uint32_t *_parm_err /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrWkstaUserSetInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrWkstaUserSetInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.unknown = _unknown;
	state->orig.in.level = _level;
	state->orig.in.info = _info;
	state->orig.in.parm_err = _parm_err;

	/* Out parameters */
	state->orig.out.parm_err = _parm_err;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wkssvc_NetrWkstaUserSetInfo_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wkssvc_NetrWkstaUserSetInfo_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrWkstaUserSetInfo_done, req);
	return req;
}

static void dcerpc_wkssvc_NetrWkstaUserSetInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wkssvc_NetrWkstaUserSetInfo_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrWkstaUserSetInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wkssvc_NetrWkstaUserSetInfo_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.parm_err && state->tmp.out.parm_err) {
		*state->orig.out.parm_err = *state->tmp.out.parm_err;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrWkstaUserSetInfo_recv(struct tevent_req *req,
						 TALLOC_CTX *mem_ctx,
						 WERROR *result)
{
	struct dcerpc_wkssvc_NetrWkstaUserSetInfo_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrWkstaUserSetInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrWkstaUserSetInfo(struct dcerpc_binding_handle *h,
					    TALLOC_CTX *mem_ctx,
					    const char *_unknown /* [in] [charset(UTF16),unique] */,
					    uint32_t _level /* [in]  */,
					    union wkssvc_NetrWkstaUserInfo *_info /* [in] [switch_is(level),ref] */,
					    uint32_t *_parm_err /* [in,out] [unique] */,
					    WERROR *result)
{
	struct wkssvc_NetrWkstaUserSetInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.unknown = _unknown;
	r.in.level = _level;
	r.in.info = _info;
	r.in.parm_err = _parm_err;

	/* Out parameters */
	r.out.parm_err = _parm_err;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_wkssvc_NetrWkstaUserSetInfo_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_parm_err && r.out.parm_err) {
		*_parm_err = *r.out.parm_err;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wkssvc_NetWkstaTransportEnum_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetWkstaTransportEnum_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetWkstaTransportEnum_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wkssvc_NetWkstaTransportEnum *r)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetWkstaTransportEnum_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetWkstaTransportEnum_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETWKSTATRANSPORTENUM, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetWkstaTransportEnum_r_done, req);

	return req;
}

static void dcerpc_wkssvc_NetWkstaTransportEnum_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetWkstaTransportEnum_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wkssvc_NetWkstaTransportEnum_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wkssvc_NetWkstaTransportEnum_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetWkstaTransportEnum_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wkssvc_NetWkstaTransportEnum *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETWKSTATRANSPORTENUM, mem_ctx, r);

	return status;
}

struct dcerpc_wkssvc_NetWkstaTransportEnum_state {
	struct wkssvc_NetWkstaTransportEnum orig;
	struct wkssvc_NetWkstaTransportEnum tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetWkstaTransportEnum_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetWkstaTransportEnum_send(TALLOC_CTX *mem_ctx,
							    struct tevent_context *ev,
							    struct dcerpc_binding_handle *h,
							    const char *_server_name /* [in] [charset(UTF16),unique] */,
							    struct wkssvc_NetWkstaTransportInfo *_info /* [in,out] [ref] */,
							    uint32_t _max_buffer /* [in]  */,
							    uint32_t *_total_entries /* [out] [ref] */,
							    uint32_t *_resume_handle /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetWkstaTransportEnum_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetWkstaTransportEnum_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.info = _info;
	state->orig.in.max_buffer = _max_buffer;
	state->orig.in.resume_handle = _resume_handle;

	/* Out parameters */
	state->orig.out.info = _info;
	state->orig.out.total_entries = _total_entries;
	state->orig.out.resume_handle = _resume_handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wkssvc_NetWkstaTransportEnum_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wkssvc_NetWkstaTransportEnum_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetWkstaTransportEnum_done, req);
	return req;
}

static void dcerpc_wkssvc_NetWkstaTransportEnum_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wkssvc_NetWkstaTransportEnum_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetWkstaTransportEnum_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wkssvc_NetWkstaTransportEnum_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;
	*state->orig.out.total_entries = *state->tmp.out.total_entries;
	if (state->orig.out.resume_handle && state->tmp.out.resume_handle) {
		*state->orig.out.resume_handle = *state->tmp.out.resume_handle;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetWkstaTransportEnum_recv(struct tevent_req *req,
						  TALLOC_CTX *mem_ctx,
						  WERROR *result)
{
	struct dcerpc_wkssvc_NetWkstaTransportEnum_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetWkstaTransportEnum_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetWkstaTransportEnum(struct dcerpc_binding_handle *h,
					     TALLOC_CTX *mem_ctx,
					     const char *_server_name /* [in] [charset(UTF16),unique] */,
					     struct wkssvc_NetWkstaTransportInfo *_info /* [in,out] [ref] */,
					     uint32_t _max_buffer /* [in]  */,
					     uint32_t *_total_entries /* [out] [ref] */,
					     uint32_t *_resume_handle /* [in,out] [unique] */,
					     WERROR *result)
{
	struct wkssvc_NetWkstaTransportEnum r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.info = _info;
	r.in.max_buffer = _max_buffer;
	r.in.resume_handle = _resume_handle;

	/* Out parameters */
	r.out.info = _info;
	r.out.total_entries = _total_entries;
	r.out.resume_handle = _resume_handle;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_wkssvc_NetWkstaTransportEnum_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_info = *r.out.info;
	*_total_entries = *r.out.total_entries;
	if (_resume_handle && r.out.resume_handle) {
		*_resume_handle = *r.out.resume_handle;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wkssvc_NetrWkstaTransportAdd_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrWkstaTransportAdd_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrWkstaTransportAdd_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wkssvc_NetrWkstaTransportAdd *r)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrWkstaTransportAdd_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrWkstaTransportAdd_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRWKSTATRANSPORTADD, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrWkstaTransportAdd_r_done, req);

	return req;
}

static void dcerpc_wkssvc_NetrWkstaTransportAdd_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrWkstaTransportAdd_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wkssvc_NetrWkstaTransportAdd_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wkssvc_NetrWkstaTransportAdd_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrWkstaTransportAdd_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wkssvc_NetrWkstaTransportAdd *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRWKSTATRANSPORTADD, mem_ctx, r);

	return status;
}

struct dcerpc_wkssvc_NetrWkstaTransportAdd_state {
	struct wkssvc_NetrWkstaTransportAdd orig;
	struct wkssvc_NetrWkstaTransportAdd tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrWkstaTransportAdd_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrWkstaTransportAdd_send(TALLOC_CTX *mem_ctx,
							    struct tevent_context *ev,
							    struct dcerpc_binding_handle *h,
							    const char *_server_name /* [in] [charset(UTF16),unique] */,
							    uint32_t _level /* [in]  */,
							    struct wkssvc_NetWkstaTransportInfo0 *_info0 /* [in] [ref] */,
							    uint32_t *_parm_err /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrWkstaTransportAdd_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrWkstaTransportAdd_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.level = _level;
	state->orig.in.info0 = _info0;
	state->orig.in.parm_err = _parm_err;

	/* Out parameters */
	state->orig.out.parm_err = _parm_err;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wkssvc_NetrWkstaTransportAdd_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wkssvc_NetrWkstaTransportAdd_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrWkstaTransportAdd_done, req);
	return req;
}

static void dcerpc_wkssvc_NetrWkstaTransportAdd_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wkssvc_NetrWkstaTransportAdd_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrWkstaTransportAdd_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wkssvc_NetrWkstaTransportAdd_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.parm_err && state->tmp.out.parm_err) {
		*state->orig.out.parm_err = *state->tmp.out.parm_err;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrWkstaTransportAdd_recv(struct tevent_req *req,
						  TALLOC_CTX *mem_ctx,
						  WERROR *result)
{
	struct dcerpc_wkssvc_NetrWkstaTransportAdd_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrWkstaTransportAdd_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrWkstaTransportAdd(struct dcerpc_binding_handle *h,
					     TALLOC_CTX *mem_ctx,
					     const char *_server_name /* [in] [charset(UTF16),unique] */,
					     uint32_t _level /* [in]  */,
					     struct wkssvc_NetWkstaTransportInfo0 *_info0 /* [in] [ref] */,
					     uint32_t *_parm_err /* [in,out] [unique] */,
					     WERROR *result)
{
	struct wkssvc_NetrWkstaTransportAdd r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.level = _level;
	r.in.info0 = _info0;
	r.in.parm_err = _parm_err;

	/* Out parameters */
	r.out.parm_err = _parm_err;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_wkssvc_NetrWkstaTransportAdd_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_parm_err && r.out.parm_err) {
		*_parm_err = *r.out.parm_err;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wkssvc_NetrWkstaTransportDel_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrWkstaTransportDel_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrWkstaTransportDel_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wkssvc_NetrWkstaTransportDel *r)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrWkstaTransportDel_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrWkstaTransportDel_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRWKSTATRANSPORTDEL, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrWkstaTransportDel_r_done, req);

	return req;
}

static void dcerpc_wkssvc_NetrWkstaTransportDel_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrWkstaTransportDel_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wkssvc_NetrWkstaTransportDel_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wkssvc_NetrWkstaTransportDel_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrWkstaTransportDel_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wkssvc_NetrWkstaTransportDel *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRWKSTATRANSPORTDEL, mem_ctx, r);

	return status;
}

struct dcerpc_wkssvc_NetrWkstaTransportDel_state {
	struct wkssvc_NetrWkstaTransportDel orig;
	struct wkssvc_NetrWkstaTransportDel tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrWkstaTransportDel_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrWkstaTransportDel_send(TALLOC_CTX *mem_ctx,
							    struct tevent_context *ev,
							    struct dcerpc_binding_handle *h,
							    const char *_server_name /* [in] [charset(UTF16),unique] */,
							    const char *_transport_name /* [in] [charset(UTF16),unique] */,
							    uint32_t _unknown3 /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrWkstaTransportDel_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrWkstaTransportDel_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.transport_name = _transport_name;
	state->orig.in.unknown3 = _unknown3;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wkssvc_NetrWkstaTransportDel_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrWkstaTransportDel_done, req);
	return req;
}

static void dcerpc_wkssvc_NetrWkstaTransportDel_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wkssvc_NetrWkstaTransportDel_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrWkstaTransportDel_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wkssvc_NetrWkstaTransportDel_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrWkstaTransportDel_recv(struct tevent_req *req,
						  TALLOC_CTX *mem_ctx,
						  WERROR *result)
{
	struct dcerpc_wkssvc_NetrWkstaTransportDel_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrWkstaTransportDel_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrWkstaTransportDel(struct dcerpc_binding_handle *h,
					     TALLOC_CTX *mem_ctx,
					     const char *_server_name /* [in] [charset(UTF16),unique] */,
					     const char *_transport_name /* [in] [charset(UTF16),unique] */,
					     uint32_t _unknown3 /* [in]  */,
					     WERROR *result)
{
	struct wkssvc_NetrWkstaTransportDel r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.transport_name = _transport_name;
	r.in.unknown3 = _unknown3;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_wkssvc_NetrWkstaTransportDel_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wkssvc_NetrUseAdd_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrUseAdd_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrUseAdd_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wkssvc_NetrUseAdd *r)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrUseAdd_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrUseAdd_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRUSEADD, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrUseAdd_r_done, req);

	return req;
}

static void dcerpc_wkssvc_NetrUseAdd_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrUseAdd_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wkssvc_NetrUseAdd_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wkssvc_NetrUseAdd_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrUseAdd_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wkssvc_NetrUseAdd *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRUSEADD, mem_ctx, r);

	return status;
}

struct dcerpc_wkssvc_NetrUseAdd_state {
	struct wkssvc_NetrUseAdd orig;
	struct wkssvc_NetrUseAdd tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrUseAdd_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrUseAdd_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 const char *_server_name /* [in] [charset(UTF16),unique] */,
						 uint32_t _level /* [in]  */,
						 union wkssvc_NetrUseGetInfoCtr *_ctr /* [in] [switch_is(level),ref] */,
						 uint32_t *_parm_err /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrUseAdd_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrUseAdd_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.level = _level;
	state->orig.in.ctr = _ctr;
	state->orig.in.parm_err = _parm_err;

	/* Out parameters */
	state->orig.out.parm_err = _parm_err;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wkssvc_NetrUseAdd_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wkssvc_NetrUseAdd_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrUseAdd_done, req);
	return req;
}

static void dcerpc_wkssvc_NetrUseAdd_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wkssvc_NetrUseAdd_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrUseAdd_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wkssvc_NetrUseAdd_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.parm_err && state->tmp.out.parm_err) {
		*state->orig.out.parm_err = *state->tmp.out.parm_err;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrUseAdd_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       WERROR *result)
{
	struct dcerpc_wkssvc_NetrUseAdd_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrUseAdd_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrUseAdd(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  const char *_server_name /* [in] [charset(UTF16),unique] */,
				  uint32_t _level /* [in]  */,
				  union wkssvc_NetrUseGetInfoCtr *_ctr /* [in] [switch_is(level),ref] */,
				  uint32_t *_parm_err /* [in,out] [unique] */,
				  WERROR *result)
{
	struct wkssvc_NetrUseAdd r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.level = _level;
	r.in.ctr = _ctr;
	r.in.parm_err = _parm_err;

	/* Out parameters */
	r.out.parm_err = _parm_err;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_wkssvc_NetrUseAdd_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_parm_err && r.out.parm_err) {
		*_parm_err = *r.out.parm_err;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wkssvc_NetrUseGetInfo_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrUseGetInfo_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrUseGetInfo_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wkssvc_NetrUseGetInfo *r)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrUseGetInfo_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrUseGetInfo_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRUSEGETINFO, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrUseGetInfo_r_done, req);

	return req;
}

static void dcerpc_wkssvc_NetrUseGetInfo_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrUseGetInfo_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wkssvc_NetrUseGetInfo_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wkssvc_NetrUseGetInfo_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrUseGetInfo_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wkssvc_NetrUseGetInfo *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRUSEGETINFO, mem_ctx, r);

	return status;
}

struct dcerpc_wkssvc_NetrUseGetInfo_state {
	struct wkssvc_NetrUseGetInfo orig;
	struct wkssvc_NetrUseGetInfo tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrUseGetInfo_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrUseGetInfo_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     const char *_server_name /* [in] [unique,charset(UTF16)] */,
						     const char *_use_name /* [in] [ref,charset(UTF16)] */,
						     uint32_t _level /* [in]  */,
						     union wkssvc_NetrUseGetInfoCtr *_ctr /* [out] [switch_is(level),ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrUseGetInfo_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrUseGetInfo_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.use_name = _use_name;
	state->orig.in.level = _level;

	/* Out parameters */
	state->orig.out.ctr = _ctr;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wkssvc_NetrUseGetInfo_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wkssvc_NetrUseGetInfo_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrUseGetInfo_done, req);
	return req;
}

static void dcerpc_wkssvc_NetrUseGetInfo_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wkssvc_NetrUseGetInfo_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrUseGetInfo_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wkssvc_NetrUseGetInfo_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ctr = *state->tmp.out.ctr;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrUseGetInfo_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_wkssvc_NetrUseGetInfo_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrUseGetInfo_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrUseGetInfo(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      const char *_server_name /* [in] [unique,charset(UTF16)] */,
				      const char *_use_name /* [in] [ref,charset(UTF16)] */,
				      uint32_t _level /* [in]  */,
				      union wkssvc_NetrUseGetInfoCtr *_ctr /* [out] [switch_is(level),ref] */,
				      WERROR *result)
{
	struct wkssvc_NetrUseGetInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.use_name = _use_name;
	r.in.level = _level;

	/* Out parameters */
	r.out.ctr = _ctr;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_wkssvc_NetrUseGetInfo_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ctr = *r.out.ctr;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wkssvc_NetrUseDel_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrUseDel_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrUseDel_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wkssvc_NetrUseDel *r)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrUseDel_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrUseDel_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRUSEDEL, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrUseDel_r_done, req);

	return req;
}

static void dcerpc_wkssvc_NetrUseDel_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrUseDel_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wkssvc_NetrUseDel_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wkssvc_NetrUseDel_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrUseDel_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wkssvc_NetrUseDel *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRUSEDEL, mem_ctx, r);

	return status;
}

struct dcerpc_wkssvc_NetrUseDel_state {
	struct wkssvc_NetrUseDel orig;
	struct wkssvc_NetrUseDel tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrUseDel_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrUseDel_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 const char *_server_name /* [in] [unique,charset(UTF16)] */,
						 const char *_use_name /* [in] [ref,charset(UTF16)] */,
						 uint32_t _force_cond /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrUseDel_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrUseDel_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.use_name = _use_name;
	state->orig.in.force_cond = _force_cond;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wkssvc_NetrUseDel_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrUseDel_done, req);
	return req;
}

static void dcerpc_wkssvc_NetrUseDel_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wkssvc_NetrUseDel_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrUseDel_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wkssvc_NetrUseDel_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrUseDel_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       WERROR *result)
{
	struct dcerpc_wkssvc_NetrUseDel_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrUseDel_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrUseDel(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  const char *_server_name /* [in] [unique,charset(UTF16)] */,
				  const char *_use_name /* [in] [ref,charset(UTF16)] */,
				  uint32_t _force_cond /* [in]  */,
				  WERROR *result)
{
	struct wkssvc_NetrUseDel r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.use_name = _use_name;
	r.in.force_cond = _force_cond;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_wkssvc_NetrUseDel_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wkssvc_NetrUseEnum_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrUseEnum_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrUseEnum_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wkssvc_NetrUseEnum *r)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrUseEnum_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrUseEnum_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRUSEENUM, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrUseEnum_r_done, req);

	return req;
}

static void dcerpc_wkssvc_NetrUseEnum_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrUseEnum_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wkssvc_NetrUseEnum_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wkssvc_NetrUseEnum_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrUseEnum_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wkssvc_NetrUseEnum *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRUSEENUM, mem_ctx, r);

	return status;
}

struct dcerpc_wkssvc_NetrUseEnum_state {
	struct wkssvc_NetrUseEnum orig;
	struct wkssvc_NetrUseEnum tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrUseEnum_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrUseEnum_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct dcerpc_binding_handle *h,
						  const char *_server_name /* [in] [charset(UTF16),unique] */,
						  struct wkssvc_NetrUseEnumInfo *_info /* [in,out] [ref] */,
						  uint32_t _prefmaxlen /* [in]  */,
						  uint32_t *_entries_read /* [out] [ref] */,
						  uint32_t *_resume_handle /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrUseEnum_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrUseEnum_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.info = _info;
	state->orig.in.prefmaxlen = _prefmaxlen;
	state->orig.in.resume_handle = _resume_handle;

	/* Out parameters */
	state->orig.out.info = _info;
	state->orig.out.entries_read = _entries_read;
	state->orig.out.resume_handle = _resume_handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wkssvc_NetrUseEnum_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wkssvc_NetrUseEnum_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrUseEnum_done, req);
	return req;
}

static void dcerpc_wkssvc_NetrUseEnum_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wkssvc_NetrUseEnum_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrUseEnum_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wkssvc_NetrUseEnum_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;
	*state->orig.out.entries_read = *state->tmp.out.entries_read;
	if (state->orig.out.resume_handle && state->tmp.out.resume_handle) {
		*state->orig.out.resume_handle = *state->tmp.out.resume_handle;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrUseEnum_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					WERROR *result)
{
	struct dcerpc_wkssvc_NetrUseEnum_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrUseEnum_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrUseEnum(struct dcerpc_binding_handle *h,
				   TALLOC_CTX *mem_ctx,
				   const char *_server_name /* [in] [charset(UTF16),unique] */,
				   struct wkssvc_NetrUseEnumInfo *_info /* [in,out] [ref] */,
				   uint32_t _prefmaxlen /* [in]  */,
				   uint32_t *_entries_read /* [out] [ref] */,
				   uint32_t *_resume_handle /* [in,out] [unique] */,
				   WERROR *result)
{
	struct wkssvc_NetrUseEnum r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.info = _info;
	r.in.prefmaxlen = _prefmaxlen;
	r.in.resume_handle = _resume_handle;

	/* Out parameters */
	r.out.info = _info;
	r.out.entries_read = _entries_read;
	r.out.resume_handle = _resume_handle;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_wkssvc_NetrUseEnum_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_info = *r.out.info;
	*_entries_read = *r.out.entries_read;
	if (_resume_handle && r.out.resume_handle) {
		*_resume_handle = *r.out.resume_handle;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wkssvc_NetrMessageBufferSend_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrMessageBufferSend_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrMessageBufferSend_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wkssvc_NetrMessageBufferSend *r)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrMessageBufferSend_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrMessageBufferSend_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRMESSAGEBUFFERSEND, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrMessageBufferSend_r_done, req);

	return req;
}

static void dcerpc_wkssvc_NetrMessageBufferSend_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrMessageBufferSend_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wkssvc_NetrMessageBufferSend_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wkssvc_NetrMessageBufferSend_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrMessageBufferSend_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wkssvc_NetrMessageBufferSend *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRMESSAGEBUFFERSEND, mem_ctx, r);

	return status;
}

struct dcerpc_wkssvc_NetrMessageBufferSend_state {
	struct wkssvc_NetrMessageBufferSend orig;
	struct wkssvc_NetrMessageBufferSend tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrMessageBufferSend_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrMessageBufferSend_send(TALLOC_CTX *mem_ctx,
							    struct tevent_context *ev,
							    struct dcerpc_binding_handle *h,
							    const char *_server_name /* [in] [charset(UTF16),unique] */,
							    const char *_message_name /* [in] [ref,charset(UTF16)] */,
							    const char *_message_sender_name /* [in] [charset(UTF16),unique] */,
							    uint8_t *_message_buffer /* [in] [ref,size_is(message_size)] */,
							    uint32_t _message_size /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrMessageBufferSend_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrMessageBufferSend_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.message_name = _message_name;
	state->orig.in.message_sender_name = _message_sender_name;
	state->orig.in.message_buffer = _message_buffer;
	state->orig.in.message_size = _message_size;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wkssvc_NetrMessageBufferSend_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrMessageBufferSend_done, req);
	return req;
}

static void dcerpc_wkssvc_NetrMessageBufferSend_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wkssvc_NetrMessageBufferSend_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrMessageBufferSend_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wkssvc_NetrMessageBufferSend_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrMessageBufferSend_recv(struct tevent_req *req,
						  TALLOC_CTX *mem_ctx,
						  WERROR *result)
{
	struct dcerpc_wkssvc_NetrMessageBufferSend_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrMessageBufferSend_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrMessageBufferSend(struct dcerpc_binding_handle *h,
					     TALLOC_CTX *mem_ctx,
					     const char *_server_name /* [in] [charset(UTF16),unique] */,
					     const char *_message_name /* [in] [ref,charset(UTF16)] */,
					     const char *_message_sender_name /* [in] [charset(UTF16),unique] */,
					     uint8_t *_message_buffer /* [in] [ref,size_is(message_size)] */,
					     uint32_t _message_size /* [in]  */,
					     WERROR *result)
{
	struct wkssvc_NetrMessageBufferSend r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.message_name = _message_name;
	r.in.message_sender_name = _message_sender_name;
	r.in.message_buffer = _message_buffer;
	r.in.message_size = _message_size;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_wkssvc_NetrMessageBufferSend_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wkssvc_NetrWorkstationStatisticsGet_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrWorkstationStatisticsGet_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrWorkstationStatisticsGet_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wkssvc_NetrWorkstationStatisticsGet *r)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrWorkstationStatisticsGet_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrWorkstationStatisticsGet_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRWORKSTATIONSTATISTICSGET, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrWorkstationStatisticsGet_r_done, req);

	return req;
}

static void dcerpc_wkssvc_NetrWorkstationStatisticsGet_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrWorkstationStatisticsGet_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wkssvc_NetrWorkstationStatisticsGet_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wkssvc_NetrWorkstationStatisticsGet_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrWorkstationStatisticsGet_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wkssvc_NetrWorkstationStatisticsGet *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRWORKSTATIONSTATISTICSGET, mem_ctx, r);

	return status;
}

struct dcerpc_wkssvc_NetrWorkstationStatisticsGet_state {
	struct wkssvc_NetrWorkstationStatisticsGet orig;
	struct wkssvc_NetrWorkstationStatisticsGet tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrWorkstationStatisticsGet_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrWorkstationStatisticsGet_send(TALLOC_CTX *mem_ctx,
								   struct tevent_context *ev,
								   struct dcerpc_binding_handle *h,
								   const char *_server_name /* [in] [unique,charset(UTF16)] */,
								   const char *_unknown2 /* [in] [unique,charset(UTF16)] */,
								   uint32_t _unknown3 /* [in]  */,
								   uint32_t _unknown4 /* [in]  */,
								   struct wkssvc_NetrWorkstationStatistics **_info /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrWorkstationStatisticsGet_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrWorkstationStatisticsGet_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.unknown2 = _unknown2;
	state->orig.in.unknown3 = _unknown3;
	state->orig.in.unknown4 = _unknown4;

	/* Out parameters */
	state->orig.out.info = _info;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wkssvc_NetrWorkstationStatisticsGet_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wkssvc_NetrWorkstationStatisticsGet_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrWorkstationStatisticsGet_done, req);
	return req;
}

static void dcerpc_wkssvc_NetrWorkstationStatisticsGet_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wkssvc_NetrWorkstationStatisticsGet_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrWorkstationStatisticsGet_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wkssvc_NetrWorkstationStatisticsGet_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrWorkstationStatisticsGet_recv(struct tevent_req *req,
							 TALLOC_CTX *mem_ctx,
							 WERROR *result)
{
	struct dcerpc_wkssvc_NetrWorkstationStatisticsGet_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrWorkstationStatisticsGet_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrWorkstationStatisticsGet(struct dcerpc_binding_handle *h,
						    TALLOC_CTX *mem_ctx,
						    const char *_server_name /* [in] [unique,charset(UTF16)] */,
						    const char *_unknown2 /* [in] [unique,charset(UTF16)] */,
						    uint32_t _unknown3 /* [in]  */,
						    uint32_t _unknown4 /* [in]  */,
						    struct wkssvc_NetrWorkstationStatistics **_info /* [out] [ref] */,
						    WERROR *result)
{
	struct wkssvc_NetrWorkstationStatisticsGet r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.unknown2 = _unknown2;
	r.in.unknown3 = _unknown3;
	r.in.unknown4 = _unknown4;

	/* Out parameters */
	r.out.info = _info;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_wkssvc_NetrWorkstationStatisticsGet_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_info = *r.out.info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wkssvc_NetrLogonDomainNameAdd_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrLogonDomainNameAdd_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrLogonDomainNameAdd_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wkssvc_NetrLogonDomainNameAdd *r)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrLogonDomainNameAdd_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrLogonDomainNameAdd_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRLOGONDOMAINNAMEADD, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrLogonDomainNameAdd_r_done, req);

	return req;
}

static void dcerpc_wkssvc_NetrLogonDomainNameAdd_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrLogonDomainNameAdd_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wkssvc_NetrLogonDomainNameAdd_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wkssvc_NetrLogonDomainNameAdd_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrLogonDomainNameAdd_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wkssvc_NetrLogonDomainNameAdd *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRLOGONDOMAINNAMEADD, mem_ctx, r);

	return status;
}

struct dcerpc_wkssvc_NetrLogonDomainNameAdd_state {
	struct wkssvc_NetrLogonDomainNameAdd orig;
	struct wkssvc_NetrLogonDomainNameAdd tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrLogonDomainNameAdd_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrLogonDomainNameAdd_send(TALLOC_CTX *mem_ctx,
							     struct tevent_context *ev,
							     struct dcerpc_binding_handle *h,
							     const char *_domain_name /* [in] [charset(UTF16),ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrLogonDomainNameAdd_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrLogonDomainNameAdd_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.domain_name = _domain_name;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wkssvc_NetrLogonDomainNameAdd_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrLogonDomainNameAdd_done, req);
	return req;
}

static void dcerpc_wkssvc_NetrLogonDomainNameAdd_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wkssvc_NetrLogonDomainNameAdd_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrLogonDomainNameAdd_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wkssvc_NetrLogonDomainNameAdd_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrLogonDomainNameAdd_recv(struct tevent_req *req,
						   TALLOC_CTX *mem_ctx,
						   WERROR *result)
{
	struct dcerpc_wkssvc_NetrLogonDomainNameAdd_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrLogonDomainNameAdd_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrLogonDomainNameAdd(struct dcerpc_binding_handle *h,
					      TALLOC_CTX *mem_ctx,
					      const char *_domain_name /* [in] [charset(UTF16),ref] */,
					      WERROR *result)
{
	struct wkssvc_NetrLogonDomainNameAdd r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_name = _domain_name;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_wkssvc_NetrLogonDomainNameAdd_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wkssvc_NetrLogonDomainNameDel_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrLogonDomainNameDel_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrLogonDomainNameDel_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wkssvc_NetrLogonDomainNameDel *r)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrLogonDomainNameDel_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrLogonDomainNameDel_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRLOGONDOMAINNAMEDEL, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrLogonDomainNameDel_r_done, req);

	return req;
}

static void dcerpc_wkssvc_NetrLogonDomainNameDel_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrLogonDomainNameDel_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wkssvc_NetrLogonDomainNameDel_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wkssvc_NetrLogonDomainNameDel_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrLogonDomainNameDel_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wkssvc_NetrLogonDomainNameDel *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRLOGONDOMAINNAMEDEL, mem_ctx, r);

	return status;
}

struct dcerpc_wkssvc_NetrLogonDomainNameDel_state {
	struct wkssvc_NetrLogonDomainNameDel orig;
	struct wkssvc_NetrLogonDomainNameDel tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrLogonDomainNameDel_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrLogonDomainNameDel_send(TALLOC_CTX *mem_ctx,
							     struct tevent_context *ev,
							     struct dcerpc_binding_handle *h,
							     const char *_domain_name /* [in] [charset(UTF16),ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrLogonDomainNameDel_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrLogonDomainNameDel_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.domain_name = _domain_name;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wkssvc_NetrLogonDomainNameDel_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrLogonDomainNameDel_done, req);
	return req;
}

static void dcerpc_wkssvc_NetrLogonDomainNameDel_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wkssvc_NetrLogonDomainNameDel_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrLogonDomainNameDel_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wkssvc_NetrLogonDomainNameDel_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrLogonDomainNameDel_recv(struct tevent_req *req,
						   TALLOC_CTX *mem_ctx,
						   WERROR *result)
{
	struct dcerpc_wkssvc_NetrLogonDomainNameDel_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrLogonDomainNameDel_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrLogonDomainNameDel(struct dcerpc_binding_handle *h,
					      TALLOC_CTX *mem_ctx,
					      const char *_domain_name /* [in] [charset(UTF16),ref] */,
					      WERROR *result)
{
	struct wkssvc_NetrLogonDomainNameDel r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_name = _domain_name;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_wkssvc_NetrLogonDomainNameDel_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wkssvc_NetrJoinDomain_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrJoinDomain_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrJoinDomain_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wkssvc_NetrJoinDomain *r)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrJoinDomain_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrJoinDomain_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRJOINDOMAIN, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrJoinDomain_r_done, req);

	return req;
}

static void dcerpc_wkssvc_NetrJoinDomain_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrJoinDomain_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wkssvc_NetrJoinDomain_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wkssvc_NetrJoinDomain_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrJoinDomain_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wkssvc_NetrJoinDomain *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRJOINDOMAIN, mem_ctx, r);

	return status;
}

struct dcerpc_wkssvc_NetrJoinDomain_state {
	struct wkssvc_NetrJoinDomain orig;
	struct wkssvc_NetrJoinDomain tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrJoinDomain_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrJoinDomain_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     const char *_server_name /* [in] [charset(UTF16),unique] */,
						     const char *_domain_name /* [in] [ref,charset(UTF16)] */,
						     const char *_account_ou /* [in] [unique,charset(UTF16)] */,
						     const char *_Account /* [in] [charset(UTF16),unique] */,
						     const char *_password /* [in] [unique,charset(UTF16)] */,
						     uint32_t _join_flags /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrJoinDomain_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrJoinDomain_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.domain_name = _domain_name;
	state->orig.in.account_ou = _account_ou;
	state->orig.in.Account = _Account;
	state->orig.in.password = _password;
	state->orig.in.join_flags = _join_flags;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wkssvc_NetrJoinDomain_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrJoinDomain_done, req);
	return req;
}

static void dcerpc_wkssvc_NetrJoinDomain_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wkssvc_NetrJoinDomain_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrJoinDomain_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wkssvc_NetrJoinDomain_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrJoinDomain_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_wkssvc_NetrJoinDomain_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrJoinDomain_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrJoinDomain(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      const char *_server_name /* [in] [charset(UTF16),unique] */,
				      const char *_domain_name /* [in] [ref,charset(UTF16)] */,
				      const char *_account_ou /* [in] [unique,charset(UTF16)] */,
				      const char *_Account /* [in] [charset(UTF16),unique] */,
				      const char *_password /* [in] [unique,charset(UTF16)] */,
				      uint32_t _join_flags /* [in]  */,
				      WERROR *result)
{
	struct wkssvc_NetrJoinDomain r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.domain_name = _domain_name;
	r.in.account_ou = _account_ou;
	r.in.Account = _Account;
	r.in.password = _password;
	r.in.join_flags = _join_flags;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_wkssvc_NetrJoinDomain_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wkssvc_NetrUnjoinDomain_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrUnjoinDomain_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrUnjoinDomain_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wkssvc_NetrUnjoinDomain *r)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrUnjoinDomain_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrUnjoinDomain_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRUNJOINDOMAIN, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrUnjoinDomain_r_done, req);

	return req;
}

static void dcerpc_wkssvc_NetrUnjoinDomain_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrUnjoinDomain_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wkssvc_NetrUnjoinDomain_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wkssvc_NetrUnjoinDomain_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrUnjoinDomain_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wkssvc_NetrUnjoinDomain *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRUNJOINDOMAIN, mem_ctx, r);

	return status;
}

struct dcerpc_wkssvc_NetrUnjoinDomain_state {
	struct wkssvc_NetrUnjoinDomain orig;
	struct wkssvc_NetrUnjoinDomain tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrUnjoinDomain_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrUnjoinDomain_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       const char *_server_name /* [in] [charset(UTF16),unique] */,
						       const char *_Account /* [in] [charset(UTF16),unique] */,
						       const char *_password /* [in] [unique,charset(UTF16)] */,
						       uint32_t _unjoin_flags /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrUnjoinDomain_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrUnjoinDomain_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.Account = _Account;
	state->orig.in.password = _password;
	state->orig.in.unjoin_flags = _unjoin_flags;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wkssvc_NetrUnjoinDomain_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrUnjoinDomain_done, req);
	return req;
}

static void dcerpc_wkssvc_NetrUnjoinDomain_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wkssvc_NetrUnjoinDomain_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrUnjoinDomain_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wkssvc_NetrUnjoinDomain_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrUnjoinDomain_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     WERROR *result)
{
	struct dcerpc_wkssvc_NetrUnjoinDomain_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrUnjoinDomain_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrUnjoinDomain(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					const char *_server_name /* [in] [charset(UTF16),unique] */,
					const char *_Account /* [in] [charset(UTF16),unique] */,
					const char *_password /* [in] [unique,charset(UTF16)] */,
					uint32_t _unjoin_flags /* [in]  */,
					WERROR *result)
{
	struct wkssvc_NetrUnjoinDomain r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.Account = _Account;
	r.in.password = _password;
	r.in.unjoin_flags = _unjoin_flags;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_wkssvc_NetrUnjoinDomain_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wkssvc_NetrRenameMachineInDomain_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrRenameMachineInDomain_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrRenameMachineInDomain_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wkssvc_NetrRenameMachineInDomain *r)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrRenameMachineInDomain_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrRenameMachineInDomain_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRRENAMEMACHINEINDOMAIN, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrRenameMachineInDomain_r_done, req);

	return req;
}

static void dcerpc_wkssvc_NetrRenameMachineInDomain_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrRenameMachineInDomain_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wkssvc_NetrRenameMachineInDomain_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wkssvc_NetrRenameMachineInDomain_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrRenameMachineInDomain_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wkssvc_NetrRenameMachineInDomain *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRRENAMEMACHINEINDOMAIN, mem_ctx, r);

	return status;
}

struct dcerpc_wkssvc_NetrRenameMachineInDomain_state {
	struct wkssvc_NetrRenameMachineInDomain orig;
	struct wkssvc_NetrRenameMachineInDomain tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrRenameMachineInDomain_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrRenameMachineInDomain_send(TALLOC_CTX *mem_ctx,
								struct tevent_context *ev,
								struct dcerpc_binding_handle *h,
								const char *_server_name /* [in] [charset(UTF16),unique] */,
								const char *_NewMachineName /* [in] [charset(UTF16),unique] */,
								const char *_Account /* [in] [charset(UTF16),unique] */,
								const char *_password /* [in] [unique,charset(UTF16)] */,
								uint32_t _RenameOptions /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrRenameMachineInDomain_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrRenameMachineInDomain_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.NewMachineName = _NewMachineName;
	state->orig.in.Account = _Account;
	state->orig.in.password = _password;
	state->orig.in.RenameOptions = _RenameOptions;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wkssvc_NetrRenameMachineInDomain_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrRenameMachineInDomain_done, req);
	return req;
}

static void dcerpc_wkssvc_NetrRenameMachineInDomain_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wkssvc_NetrRenameMachineInDomain_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrRenameMachineInDomain_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wkssvc_NetrRenameMachineInDomain_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrRenameMachineInDomain_recv(struct tevent_req *req,
						      TALLOC_CTX *mem_ctx,
						      WERROR *result)
{
	struct dcerpc_wkssvc_NetrRenameMachineInDomain_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrRenameMachineInDomain_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrRenameMachineInDomain(struct dcerpc_binding_handle *h,
						 TALLOC_CTX *mem_ctx,
						 const char *_server_name /* [in] [charset(UTF16),unique] */,
						 const char *_NewMachineName /* [in] [charset(UTF16),unique] */,
						 const char *_Account /* [in] [charset(UTF16),unique] */,
						 const char *_password /* [in] [unique,charset(UTF16)] */,
						 uint32_t _RenameOptions /* [in]  */,
						 WERROR *result)
{
	struct wkssvc_NetrRenameMachineInDomain r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.NewMachineName = _NewMachineName;
	r.in.Account = _Account;
	r.in.password = _password;
	r.in.RenameOptions = _RenameOptions;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_wkssvc_NetrRenameMachineInDomain_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wkssvc_NetrValidateName_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrValidateName_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrValidateName_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wkssvc_NetrValidateName *r)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrValidateName_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrValidateName_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRVALIDATENAME, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrValidateName_r_done, req);

	return req;
}

static void dcerpc_wkssvc_NetrValidateName_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrValidateName_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wkssvc_NetrValidateName_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wkssvc_NetrValidateName_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrValidateName_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wkssvc_NetrValidateName *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRVALIDATENAME, mem_ctx, r);

	return status;
}

struct dcerpc_wkssvc_NetrValidateName_state {
	struct wkssvc_NetrValidateName orig;
	struct wkssvc_NetrValidateName tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrValidateName_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrValidateName_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       const char *_server_name /* [in] [charset(UTF16),unique] */,
						       const char *_name /* [in] [charset(UTF16),ref] */,
						       const char *_Account /* [in] [charset(UTF16),unique] */,
						       const char *_Password /* [in] [charset(UTF16),unique] */,
						       enum wkssvc_NetValidateNameType _name_type /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrValidateName_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrValidateName_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.name = _name;
	state->orig.in.Account = _Account;
	state->orig.in.Password = _Password;
	state->orig.in.name_type = _name_type;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wkssvc_NetrValidateName_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrValidateName_done, req);
	return req;
}

static void dcerpc_wkssvc_NetrValidateName_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wkssvc_NetrValidateName_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrValidateName_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wkssvc_NetrValidateName_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrValidateName_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     WERROR *result)
{
	struct dcerpc_wkssvc_NetrValidateName_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrValidateName_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrValidateName(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					const char *_server_name /* [in] [charset(UTF16),unique] */,
					const char *_name /* [in] [charset(UTF16),ref] */,
					const char *_Account /* [in] [charset(UTF16),unique] */,
					const char *_Password /* [in] [charset(UTF16),unique] */,
					enum wkssvc_NetValidateNameType _name_type /* [in]  */,
					WERROR *result)
{
	struct wkssvc_NetrValidateName r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.name = _name;
	r.in.Account = _Account;
	r.in.Password = _Password;
	r.in.name_type = _name_type;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_wkssvc_NetrValidateName_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wkssvc_NetrGetJoinInformation_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrGetJoinInformation_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrGetJoinInformation_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wkssvc_NetrGetJoinInformation *r)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrGetJoinInformation_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrGetJoinInformation_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRGETJOININFORMATION, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrGetJoinInformation_r_done, req);

	return req;
}

static void dcerpc_wkssvc_NetrGetJoinInformation_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrGetJoinInformation_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wkssvc_NetrGetJoinInformation_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wkssvc_NetrGetJoinInformation_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrGetJoinInformation_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wkssvc_NetrGetJoinInformation *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRGETJOININFORMATION, mem_ctx, r);

	return status;
}

struct dcerpc_wkssvc_NetrGetJoinInformation_state {
	struct wkssvc_NetrGetJoinInformation orig;
	struct wkssvc_NetrGetJoinInformation tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrGetJoinInformation_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrGetJoinInformation_send(TALLOC_CTX *mem_ctx,
							     struct tevent_context *ev,
							     struct dcerpc_binding_handle *h,
							     const char *_server_name /* [in] [unique,charset(UTF16)] */,
							     const char **_name_buffer /* [in,out] [charset(UTF16),ref] */,
							     enum wkssvc_NetJoinStatus *_name_type /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrGetJoinInformation_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrGetJoinInformation_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.name_buffer = _name_buffer;

	/* Out parameters */
	state->orig.out.name_buffer = _name_buffer;
	state->orig.out.name_type = _name_type;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wkssvc_NetrGetJoinInformation_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wkssvc_NetrGetJoinInformation_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrGetJoinInformation_done, req);
	return req;
}

static void dcerpc_wkssvc_NetrGetJoinInformation_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wkssvc_NetrGetJoinInformation_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrGetJoinInformation_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wkssvc_NetrGetJoinInformation_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.name_buffer = *state->tmp.out.name_buffer;
	*state->orig.out.name_type = *state->tmp.out.name_type;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrGetJoinInformation_recv(struct tevent_req *req,
						   TALLOC_CTX *mem_ctx,
						   WERROR *result)
{
	struct dcerpc_wkssvc_NetrGetJoinInformation_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrGetJoinInformation_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrGetJoinInformation(struct dcerpc_binding_handle *h,
					      TALLOC_CTX *mem_ctx,
					      const char *_server_name /* [in] [unique,charset(UTF16)] */,
					      const char **_name_buffer /* [in,out] [charset(UTF16),ref] */,
					      enum wkssvc_NetJoinStatus *_name_type /* [out] [ref] */,
					      WERROR *result)
{
	struct wkssvc_NetrGetJoinInformation r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.name_buffer = _name_buffer;

	/* Out parameters */
	r.out.name_buffer = _name_buffer;
	r.out.name_type = _name_type;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_wkssvc_NetrGetJoinInformation_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_name_buffer = *r.out.name_buffer;
	*_name_type = *r.out.name_type;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wkssvc_NetrGetJoinableOus_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrGetJoinableOus_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrGetJoinableOus_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wkssvc_NetrGetJoinableOus *r)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrGetJoinableOus_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrGetJoinableOus_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRGETJOINABLEOUS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrGetJoinableOus_r_done, req);

	return req;
}

static void dcerpc_wkssvc_NetrGetJoinableOus_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrGetJoinableOus_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wkssvc_NetrGetJoinableOus_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wkssvc_NetrGetJoinableOus_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrGetJoinableOus_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wkssvc_NetrGetJoinableOus *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRGETJOINABLEOUS, mem_ctx, r);

	return status;
}

struct dcerpc_wkssvc_NetrGetJoinableOus_state {
	struct wkssvc_NetrGetJoinableOus orig;
	struct wkssvc_NetrGetJoinableOus tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrGetJoinableOus_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrGetJoinableOus_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h,
							 const char *_server_name /* [in] [charset(UTF16),unique] */,
							 const char *_domain_name /* [in] [ref,charset(UTF16)] */,
							 const char *_Account /* [in] [unique,charset(UTF16)] */,
							 const char *_unknown /* [in] [charset(UTF16),unique] */,
							 uint32_t *_num_ous /* [in,out] [ref] */,
							 const char ***_ous /* [out] [size_is(,*num_ous),ref,charset(UTF16)] */)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrGetJoinableOus_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrGetJoinableOus_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.domain_name = _domain_name;
	state->orig.in.Account = _Account;
	state->orig.in.unknown = _unknown;
	state->orig.in.num_ous = _num_ous;

	/* Out parameters */
	state->orig.out.num_ous = _num_ous;
	state->orig.out.ous = _ous;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wkssvc_NetrGetJoinableOus_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wkssvc_NetrGetJoinableOus_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrGetJoinableOus_done, req);
	return req;
}

static void dcerpc_wkssvc_NetrGetJoinableOus_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wkssvc_NetrGetJoinableOus_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrGetJoinableOus_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wkssvc_NetrGetJoinableOus_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.num_ous = *state->tmp.out.num_ous;
	*state->orig.out.ous = *state->tmp.out.ous;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrGetJoinableOus_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result)
{
	struct dcerpc_wkssvc_NetrGetJoinableOus_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrGetJoinableOus_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrGetJoinableOus(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  const char *_server_name /* [in] [charset(UTF16),unique] */,
					  const char *_domain_name /* [in] [ref,charset(UTF16)] */,
					  const char *_Account /* [in] [unique,charset(UTF16)] */,
					  const char *_unknown /* [in] [charset(UTF16),unique] */,
					  uint32_t *_num_ous /* [in,out] [ref] */,
					  const char ***_ous /* [out] [size_is(,*num_ous),ref,charset(UTF16)] */,
					  WERROR *result)
{
	struct wkssvc_NetrGetJoinableOus r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.domain_name = _domain_name;
	r.in.Account = _Account;
	r.in.unknown = _unknown;
	r.in.num_ous = _num_ous;

	/* Out parameters */
	r.out.num_ous = _num_ous;
	r.out.ous = _ous;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_wkssvc_NetrGetJoinableOus_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_num_ous = *r.out.num_ous;
	*_ous = *r.out.ous;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wkssvc_NetrJoinDomain2_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrJoinDomain2_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrJoinDomain2_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wkssvc_NetrJoinDomain2 *r)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrJoinDomain2_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrJoinDomain2_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRJOINDOMAIN2, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrJoinDomain2_r_done, req);

	return req;
}

static void dcerpc_wkssvc_NetrJoinDomain2_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrJoinDomain2_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wkssvc_NetrJoinDomain2_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wkssvc_NetrJoinDomain2_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrJoinDomain2_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wkssvc_NetrJoinDomain2 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRJOINDOMAIN2, mem_ctx, r);

	return status;
}

struct dcerpc_wkssvc_NetrJoinDomain2_state {
	struct wkssvc_NetrJoinDomain2 orig;
	struct wkssvc_NetrJoinDomain2 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrJoinDomain2_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrJoinDomain2_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      const char *_server_name /* [in] [charset(UTF16),unique] */,
						      const char *_domain_name /* [in] [charset(UTF16),ref] */,
						      const char *_account_ou /* [in] [charset(UTF16),unique] */,
						      const char *_admin_account /* [in] [charset(UTF16),unique] */,
						      struct wkssvc_PasswordBuffer *_encrypted_password /* [in] [unique] */,
						      uint32_t _join_flags /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrJoinDomain2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrJoinDomain2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.domain_name = _domain_name;
	state->orig.in.account_ou = _account_ou;
	state->orig.in.admin_account = _admin_account;
	state->orig.in.encrypted_password = _encrypted_password;
	state->orig.in.join_flags = _join_flags;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wkssvc_NetrJoinDomain2_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrJoinDomain2_done, req);
	return req;
}

static void dcerpc_wkssvc_NetrJoinDomain2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wkssvc_NetrJoinDomain2_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrJoinDomain2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wkssvc_NetrJoinDomain2_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrJoinDomain2_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    WERROR *result)
{
	struct dcerpc_wkssvc_NetrJoinDomain2_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrJoinDomain2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrJoinDomain2(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       const char *_server_name /* [in] [charset(UTF16),unique] */,
				       const char *_domain_name /* [in] [charset(UTF16),ref] */,
				       const char *_account_ou /* [in] [charset(UTF16),unique] */,
				       const char *_admin_account /* [in] [charset(UTF16),unique] */,
				       struct wkssvc_PasswordBuffer *_encrypted_password /* [in] [unique] */,
				       uint32_t _join_flags /* [in]  */,
				       WERROR *result)
{
	struct wkssvc_NetrJoinDomain2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.domain_name = _domain_name;
	r.in.account_ou = _account_ou;
	r.in.admin_account = _admin_account;
	r.in.encrypted_password = _encrypted_password;
	r.in.join_flags = _join_flags;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_wkssvc_NetrJoinDomain2_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wkssvc_NetrUnjoinDomain2_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrUnjoinDomain2_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrUnjoinDomain2_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wkssvc_NetrUnjoinDomain2 *r)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrUnjoinDomain2_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrUnjoinDomain2_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRUNJOINDOMAIN2, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrUnjoinDomain2_r_done, req);

	return req;
}

static void dcerpc_wkssvc_NetrUnjoinDomain2_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrUnjoinDomain2_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wkssvc_NetrUnjoinDomain2_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wkssvc_NetrUnjoinDomain2_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrUnjoinDomain2_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wkssvc_NetrUnjoinDomain2 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRUNJOINDOMAIN2, mem_ctx, r);

	return status;
}

struct dcerpc_wkssvc_NetrUnjoinDomain2_state {
	struct wkssvc_NetrUnjoinDomain2 orig;
	struct wkssvc_NetrUnjoinDomain2 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrUnjoinDomain2_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrUnjoinDomain2_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							const char *_server_name /* [in] [charset(UTF16),unique] */,
							const char *_account /* [in] [charset(UTF16),unique] */,
							struct wkssvc_PasswordBuffer *_encrypted_password /* [in] [unique] */,
							uint32_t _unjoin_flags /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrUnjoinDomain2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrUnjoinDomain2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.account = _account;
	state->orig.in.encrypted_password = _encrypted_password;
	state->orig.in.unjoin_flags = _unjoin_flags;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wkssvc_NetrUnjoinDomain2_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrUnjoinDomain2_done, req);
	return req;
}

static void dcerpc_wkssvc_NetrUnjoinDomain2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wkssvc_NetrUnjoinDomain2_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrUnjoinDomain2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wkssvc_NetrUnjoinDomain2_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrUnjoinDomain2_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      WERROR *result)
{
	struct dcerpc_wkssvc_NetrUnjoinDomain2_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrUnjoinDomain2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrUnjoinDomain2(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 const char *_server_name /* [in] [charset(UTF16),unique] */,
					 const char *_account /* [in] [charset(UTF16),unique] */,
					 struct wkssvc_PasswordBuffer *_encrypted_password /* [in] [unique] */,
					 uint32_t _unjoin_flags /* [in]  */,
					 WERROR *result)
{
	struct wkssvc_NetrUnjoinDomain2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.account = _account;
	r.in.encrypted_password = _encrypted_password;
	r.in.unjoin_flags = _unjoin_flags;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_wkssvc_NetrUnjoinDomain2_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wkssvc_NetrRenameMachineInDomain2_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrRenameMachineInDomain2_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrRenameMachineInDomain2_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wkssvc_NetrRenameMachineInDomain2 *r)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrRenameMachineInDomain2_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrRenameMachineInDomain2_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRRENAMEMACHINEINDOMAIN2, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrRenameMachineInDomain2_r_done, req);

	return req;
}

static void dcerpc_wkssvc_NetrRenameMachineInDomain2_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrRenameMachineInDomain2_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wkssvc_NetrRenameMachineInDomain2_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wkssvc_NetrRenameMachineInDomain2_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrRenameMachineInDomain2_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wkssvc_NetrRenameMachineInDomain2 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRRENAMEMACHINEINDOMAIN2, mem_ctx, r);

	return status;
}

struct dcerpc_wkssvc_NetrRenameMachineInDomain2_state {
	struct wkssvc_NetrRenameMachineInDomain2 orig;
	struct wkssvc_NetrRenameMachineInDomain2 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrRenameMachineInDomain2_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrRenameMachineInDomain2_send(TALLOC_CTX *mem_ctx,
								 struct tevent_context *ev,
								 struct dcerpc_binding_handle *h,
								 const char *_server_name /* [in] [unique,charset(UTF16)] */,
								 const char *_NewMachineName /* [in] [charset(UTF16),unique] */,
								 const char *_Account /* [in] [unique,charset(UTF16)] */,
								 struct wkssvc_PasswordBuffer *_EncryptedPassword /* [in] [unique] */,
								 uint32_t _RenameOptions /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrRenameMachineInDomain2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrRenameMachineInDomain2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.NewMachineName = _NewMachineName;
	state->orig.in.Account = _Account;
	state->orig.in.EncryptedPassword = _EncryptedPassword;
	state->orig.in.RenameOptions = _RenameOptions;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wkssvc_NetrRenameMachineInDomain2_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrRenameMachineInDomain2_done, req);
	return req;
}

static void dcerpc_wkssvc_NetrRenameMachineInDomain2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wkssvc_NetrRenameMachineInDomain2_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrRenameMachineInDomain2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wkssvc_NetrRenameMachineInDomain2_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrRenameMachineInDomain2_recv(struct tevent_req *req,
						       TALLOC_CTX *mem_ctx,
						       WERROR *result)
{
	struct dcerpc_wkssvc_NetrRenameMachineInDomain2_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrRenameMachineInDomain2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrRenameMachineInDomain2(struct dcerpc_binding_handle *h,
						  TALLOC_CTX *mem_ctx,
						  const char *_server_name /* [in] [unique,charset(UTF16)] */,
						  const char *_NewMachineName /* [in] [charset(UTF16),unique] */,
						  const char *_Account /* [in] [unique,charset(UTF16)] */,
						  struct wkssvc_PasswordBuffer *_EncryptedPassword /* [in] [unique] */,
						  uint32_t _RenameOptions /* [in]  */,
						  WERROR *result)
{
	struct wkssvc_NetrRenameMachineInDomain2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.NewMachineName = _NewMachineName;
	r.in.Account = _Account;
	r.in.EncryptedPassword = _EncryptedPassword;
	r.in.RenameOptions = _RenameOptions;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_wkssvc_NetrRenameMachineInDomain2_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wkssvc_NetrValidateName2_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrValidateName2_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrValidateName2_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wkssvc_NetrValidateName2 *r)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrValidateName2_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrValidateName2_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRVALIDATENAME2, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrValidateName2_r_done, req);

	return req;
}

static void dcerpc_wkssvc_NetrValidateName2_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrValidateName2_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wkssvc_NetrValidateName2_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wkssvc_NetrValidateName2_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrValidateName2_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wkssvc_NetrValidateName2 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRVALIDATENAME2, mem_ctx, r);

	return status;
}

struct dcerpc_wkssvc_NetrValidateName2_state {
	struct wkssvc_NetrValidateName2 orig;
	struct wkssvc_NetrValidateName2 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrValidateName2_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrValidateName2_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							const char *_server_name /* [in] [charset(UTF16),unique] */,
							const char *_name /* [in] [ref,charset(UTF16)] */,
							const char *_Account /* [in] [charset(UTF16),unique] */,
							struct wkssvc_PasswordBuffer *_EncryptedPassword /* [in] [unique] */,
							enum wkssvc_NetValidateNameType _name_type /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrValidateName2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrValidateName2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.name = _name;
	state->orig.in.Account = _Account;
	state->orig.in.EncryptedPassword = _EncryptedPassword;
	state->orig.in.name_type = _name_type;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wkssvc_NetrValidateName2_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrValidateName2_done, req);
	return req;
}

static void dcerpc_wkssvc_NetrValidateName2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wkssvc_NetrValidateName2_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrValidateName2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wkssvc_NetrValidateName2_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrValidateName2_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      WERROR *result)
{
	struct dcerpc_wkssvc_NetrValidateName2_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrValidateName2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrValidateName2(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 const char *_server_name /* [in] [charset(UTF16),unique] */,
					 const char *_name /* [in] [ref,charset(UTF16)] */,
					 const char *_Account /* [in] [charset(UTF16),unique] */,
					 struct wkssvc_PasswordBuffer *_EncryptedPassword /* [in] [unique] */,
					 enum wkssvc_NetValidateNameType _name_type /* [in]  */,
					 WERROR *result)
{
	struct wkssvc_NetrValidateName2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.name = _name;
	r.in.Account = _Account;
	r.in.EncryptedPassword = _EncryptedPassword;
	r.in.name_type = _name_type;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_wkssvc_NetrValidateName2_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wkssvc_NetrGetJoinableOus2_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrGetJoinableOus2_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrGetJoinableOus2_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wkssvc_NetrGetJoinableOus2 *r)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrGetJoinableOus2_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrGetJoinableOus2_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRGETJOINABLEOUS2, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrGetJoinableOus2_r_done, req);

	return req;
}

static void dcerpc_wkssvc_NetrGetJoinableOus2_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrGetJoinableOus2_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wkssvc_NetrGetJoinableOus2_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wkssvc_NetrGetJoinableOus2_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrGetJoinableOus2_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wkssvc_NetrGetJoinableOus2 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRGETJOINABLEOUS2, mem_ctx, r);

	return status;
}

struct dcerpc_wkssvc_NetrGetJoinableOus2_state {
	struct wkssvc_NetrGetJoinableOus2 orig;
	struct wkssvc_NetrGetJoinableOus2 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrGetJoinableOus2_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrGetJoinableOus2_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  const char *_server_name /* [in] [charset(UTF16),unique] */,
							  const char *_domain_name /* [in] [ref,charset(UTF16)] */,
							  const char *_Account /* [in] [charset(UTF16),unique] */,
							  struct wkssvc_PasswordBuffer *_EncryptedPassword /* [in] [unique] */,
							  uint32_t *_num_ous /* [in,out] [ref] */,
							  const char ***_ous /* [out] [charset(UTF16),ref,size_is(,*num_ous)] */)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrGetJoinableOus2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrGetJoinableOus2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.domain_name = _domain_name;
	state->orig.in.Account = _Account;
	state->orig.in.EncryptedPassword = _EncryptedPassword;
	state->orig.in.num_ous = _num_ous;

	/* Out parameters */
	state->orig.out.num_ous = _num_ous;
	state->orig.out.ous = _ous;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wkssvc_NetrGetJoinableOus2_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wkssvc_NetrGetJoinableOus2_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrGetJoinableOus2_done, req);
	return req;
}

static void dcerpc_wkssvc_NetrGetJoinableOus2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wkssvc_NetrGetJoinableOus2_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrGetJoinableOus2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wkssvc_NetrGetJoinableOus2_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.num_ous = *state->tmp.out.num_ous;
	*state->orig.out.ous = *state->tmp.out.ous;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrGetJoinableOus2_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result)
{
	struct dcerpc_wkssvc_NetrGetJoinableOus2_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrGetJoinableOus2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrGetJoinableOus2(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   const char *_server_name /* [in] [charset(UTF16),unique] */,
					   const char *_domain_name /* [in] [ref,charset(UTF16)] */,
					   const char *_Account /* [in] [charset(UTF16),unique] */,
					   struct wkssvc_PasswordBuffer *_EncryptedPassword /* [in] [unique] */,
					   uint32_t *_num_ous /* [in,out] [ref] */,
					   const char ***_ous /* [out] [charset(UTF16),ref,size_is(,*num_ous)] */,
					   WERROR *result)
{
	struct wkssvc_NetrGetJoinableOus2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.domain_name = _domain_name;
	r.in.Account = _Account;
	r.in.EncryptedPassword = _EncryptedPassword;
	r.in.num_ous = _num_ous;

	/* Out parameters */
	r.out.num_ous = _num_ous;
	r.out.ous = _ous;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_wkssvc_NetrGetJoinableOus2_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_num_ous = *r.out.num_ous;
	*_ous = *r.out.ous;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wkssvc_NetrAddAlternateComputerName_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrAddAlternateComputerName_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrAddAlternateComputerName_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wkssvc_NetrAddAlternateComputerName *r)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrAddAlternateComputerName_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrAddAlternateComputerName_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRADDALTERNATECOMPUTERNAME, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrAddAlternateComputerName_r_done, req);

	return req;
}

static void dcerpc_wkssvc_NetrAddAlternateComputerName_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrAddAlternateComputerName_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wkssvc_NetrAddAlternateComputerName_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wkssvc_NetrAddAlternateComputerName_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrAddAlternateComputerName_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wkssvc_NetrAddAlternateComputerName *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRADDALTERNATECOMPUTERNAME, mem_ctx, r);

	return status;
}

struct dcerpc_wkssvc_NetrAddAlternateComputerName_state {
	struct wkssvc_NetrAddAlternateComputerName orig;
	struct wkssvc_NetrAddAlternateComputerName tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrAddAlternateComputerName_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrAddAlternateComputerName_send(TALLOC_CTX *mem_ctx,
								   struct tevent_context *ev,
								   struct dcerpc_binding_handle *h,
								   const char *_server_name /* [in] [unique,charset(UTF16)] */,
								   const char *_NewAlternateMachineName /* [in] [charset(UTF16),unique] */,
								   const char *_Account /* [in] [charset(UTF16),unique] */,
								   struct wkssvc_PasswordBuffer *_EncryptedPassword /* [in] [unique] */,
								   uint32_t _Reserved /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrAddAlternateComputerName_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrAddAlternateComputerName_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.NewAlternateMachineName = _NewAlternateMachineName;
	state->orig.in.Account = _Account;
	state->orig.in.EncryptedPassword = _EncryptedPassword;
	state->orig.in.Reserved = _Reserved;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wkssvc_NetrAddAlternateComputerName_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrAddAlternateComputerName_done, req);
	return req;
}

static void dcerpc_wkssvc_NetrAddAlternateComputerName_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wkssvc_NetrAddAlternateComputerName_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrAddAlternateComputerName_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wkssvc_NetrAddAlternateComputerName_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrAddAlternateComputerName_recv(struct tevent_req *req,
							 TALLOC_CTX *mem_ctx,
							 WERROR *result)
{
	struct dcerpc_wkssvc_NetrAddAlternateComputerName_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrAddAlternateComputerName_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrAddAlternateComputerName(struct dcerpc_binding_handle *h,
						    TALLOC_CTX *mem_ctx,
						    const char *_server_name /* [in] [unique,charset(UTF16)] */,
						    const char *_NewAlternateMachineName /* [in] [charset(UTF16),unique] */,
						    const char *_Account /* [in] [charset(UTF16),unique] */,
						    struct wkssvc_PasswordBuffer *_EncryptedPassword /* [in] [unique] */,
						    uint32_t _Reserved /* [in]  */,
						    WERROR *result)
{
	struct wkssvc_NetrAddAlternateComputerName r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.NewAlternateMachineName = _NewAlternateMachineName;
	r.in.Account = _Account;
	r.in.EncryptedPassword = _EncryptedPassword;
	r.in.Reserved = _Reserved;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_wkssvc_NetrAddAlternateComputerName_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wkssvc_NetrRemoveAlternateComputerName_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrRemoveAlternateComputerName_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrRemoveAlternateComputerName_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wkssvc_NetrRemoveAlternateComputerName *r)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrRemoveAlternateComputerName_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrRemoveAlternateComputerName_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRREMOVEALTERNATECOMPUTERNAME, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrRemoveAlternateComputerName_r_done, req);

	return req;
}

static void dcerpc_wkssvc_NetrRemoveAlternateComputerName_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrRemoveAlternateComputerName_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wkssvc_NetrRemoveAlternateComputerName_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wkssvc_NetrRemoveAlternateComputerName_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrRemoveAlternateComputerName_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wkssvc_NetrRemoveAlternateComputerName *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRREMOVEALTERNATECOMPUTERNAME, mem_ctx, r);

	return status;
}

struct dcerpc_wkssvc_NetrRemoveAlternateComputerName_state {
	struct wkssvc_NetrRemoveAlternateComputerName orig;
	struct wkssvc_NetrRemoveAlternateComputerName tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrRemoveAlternateComputerName_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrRemoveAlternateComputerName_send(TALLOC_CTX *mem_ctx,
								      struct tevent_context *ev,
								      struct dcerpc_binding_handle *h,
								      const char *_server_name /* [in] [charset(UTF16),unique] */,
								      const char *_AlternateMachineNameToRemove /* [in] [unique,charset(UTF16)] */,
								      const char *_Account /* [in] [unique,charset(UTF16)] */,
								      struct wkssvc_PasswordBuffer *_EncryptedPassword /* [in] [unique] */,
								      uint32_t _Reserved /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrRemoveAlternateComputerName_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrRemoveAlternateComputerName_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.AlternateMachineNameToRemove = _AlternateMachineNameToRemove;
	state->orig.in.Account = _Account;
	state->orig.in.EncryptedPassword = _EncryptedPassword;
	state->orig.in.Reserved = _Reserved;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wkssvc_NetrRemoveAlternateComputerName_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrRemoveAlternateComputerName_done, req);
	return req;
}

static void dcerpc_wkssvc_NetrRemoveAlternateComputerName_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wkssvc_NetrRemoveAlternateComputerName_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrRemoveAlternateComputerName_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wkssvc_NetrRemoveAlternateComputerName_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrRemoveAlternateComputerName_recv(struct tevent_req *req,
							    TALLOC_CTX *mem_ctx,
							    WERROR *result)
{
	struct dcerpc_wkssvc_NetrRemoveAlternateComputerName_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrRemoveAlternateComputerName_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrRemoveAlternateComputerName(struct dcerpc_binding_handle *h,
						       TALLOC_CTX *mem_ctx,
						       const char *_server_name /* [in] [charset(UTF16),unique] */,
						       const char *_AlternateMachineNameToRemove /* [in] [unique,charset(UTF16)] */,
						       const char *_Account /* [in] [unique,charset(UTF16)] */,
						       struct wkssvc_PasswordBuffer *_EncryptedPassword /* [in] [unique] */,
						       uint32_t _Reserved /* [in]  */,
						       WERROR *result)
{
	struct wkssvc_NetrRemoveAlternateComputerName r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.AlternateMachineNameToRemove = _AlternateMachineNameToRemove;
	r.in.Account = _Account;
	r.in.EncryptedPassword = _EncryptedPassword;
	r.in.Reserved = _Reserved;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_wkssvc_NetrRemoveAlternateComputerName_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wkssvc_NetrSetPrimaryComputername_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrSetPrimaryComputername_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrSetPrimaryComputername_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wkssvc_NetrSetPrimaryComputername *r)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrSetPrimaryComputername_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrSetPrimaryComputername_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRSETPRIMARYCOMPUTERNAME, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrSetPrimaryComputername_r_done, req);

	return req;
}

static void dcerpc_wkssvc_NetrSetPrimaryComputername_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrSetPrimaryComputername_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wkssvc_NetrSetPrimaryComputername_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wkssvc_NetrSetPrimaryComputername_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrSetPrimaryComputername_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wkssvc_NetrSetPrimaryComputername *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRSETPRIMARYCOMPUTERNAME, mem_ctx, r);

	return status;
}

struct dcerpc_wkssvc_NetrSetPrimaryComputername_state {
	struct wkssvc_NetrSetPrimaryComputername orig;
	struct wkssvc_NetrSetPrimaryComputername tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrSetPrimaryComputername_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrSetPrimaryComputername_send(TALLOC_CTX *mem_ctx,
								 struct tevent_context *ev,
								 struct dcerpc_binding_handle *h,
								 const char *_server_name /* [in] [charset(UTF16),unique] */,
								 const char *_primary_name /* [in] [unique,charset(UTF16)] */,
								 const char *_Account /* [in] [charset(UTF16),unique] */,
								 struct wkssvc_PasswordBuffer *_EncryptedPassword /* [in] [unique] */,
								 uint32_t _Reserved /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrSetPrimaryComputername_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrSetPrimaryComputername_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.primary_name = _primary_name;
	state->orig.in.Account = _Account;
	state->orig.in.EncryptedPassword = _EncryptedPassword;
	state->orig.in.Reserved = _Reserved;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wkssvc_NetrSetPrimaryComputername_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrSetPrimaryComputername_done, req);
	return req;
}

static void dcerpc_wkssvc_NetrSetPrimaryComputername_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wkssvc_NetrSetPrimaryComputername_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrSetPrimaryComputername_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wkssvc_NetrSetPrimaryComputername_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrSetPrimaryComputername_recv(struct tevent_req *req,
						       TALLOC_CTX *mem_ctx,
						       WERROR *result)
{
	struct dcerpc_wkssvc_NetrSetPrimaryComputername_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrSetPrimaryComputername_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrSetPrimaryComputername(struct dcerpc_binding_handle *h,
						  TALLOC_CTX *mem_ctx,
						  const char *_server_name /* [in] [charset(UTF16),unique] */,
						  const char *_primary_name /* [in] [unique,charset(UTF16)] */,
						  const char *_Account /* [in] [charset(UTF16),unique] */,
						  struct wkssvc_PasswordBuffer *_EncryptedPassword /* [in] [unique] */,
						  uint32_t _Reserved /* [in]  */,
						  WERROR *result)
{
	struct wkssvc_NetrSetPrimaryComputername r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.primary_name = _primary_name;
	r.in.Account = _Account;
	r.in.EncryptedPassword = _EncryptedPassword;
	r.in.Reserved = _Reserved;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_wkssvc_NetrSetPrimaryComputername_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wkssvc_NetrEnumerateComputerNames_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrEnumerateComputerNames_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrEnumerateComputerNames_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wkssvc_NetrEnumerateComputerNames *r)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrEnumerateComputerNames_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrEnumerateComputerNames_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRENUMERATECOMPUTERNAMES, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrEnumerateComputerNames_r_done, req);

	return req;
}

static void dcerpc_wkssvc_NetrEnumerateComputerNames_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrEnumerateComputerNames_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wkssvc_NetrEnumerateComputerNames_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wkssvc_NetrEnumerateComputerNames_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrEnumerateComputerNames_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wkssvc_NetrEnumerateComputerNames *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wkssvc,
			NDR_WKSSVC_NETRENUMERATECOMPUTERNAMES, mem_ctx, r);

	return status;
}

struct dcerpc_wkssvc_NetrEnumerateComputerNames_state {
	struct wkssvc_NetrEnumerateComputerNames orig;
	struct wkssvc_NetrEnumerateComputerNames tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wkssvc_NetrEnumerateComputerNames_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wkssvc_NetrEnumerateComputerNames_send(TALLOC_CTX *mem_ctx,
								 struct tevent_context *ev,
								 struct dcerpc_binding_handle *h,
								 const char *_server_name /* [in] [unique,charset(UTF16)] */,
								 enum wkssvc_ComputerNameType _name_type /* [in]  */,
								 uint32_t _Reserved /* [in]  */,
								 struct wkssvc_ComputerNamesCtr **_ctr /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wkssvc_NetrEnumerateComputerNames_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wkssvc_NetrEnumerateComputerNames_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.name_type = _name_type;
	state->orig.in.Reserved = _Reserved;

	/* Out parameters */
	state->orig.out.ctr = _ctr;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wkssvc_NetrEnumerateComputerNames_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wkssvc_NetrEnumerateComputerNames_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wkssvc_NetrEnumerateComputerNames_done, req);
	return req;
}

static void dcerpc_wkssvc_NetrEnumerateComputerNames_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wkssvc_NetrEnumerateComputerNames_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrEnumerateComputerNames_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wkssvc_NetrEnumerateComputerNames_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ctr = *state->tmp.out.ctr;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wkssvc_NetrEnumerateComputerNames_recv(struct tevent_req *req,
						       TALLOC_CTX *mem_ctx,
						       WERROR *result)
{
	struct dcerpc_wkssvc_NetrEnumerateComputerNames_state *state = tevent_req_data(
		req, struct dcerpc_wkssvc_NetrEnumerateComputerNames_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wkssvc_NetrEnumerateComputerNames(struct dcerpc_binding_handle *h,
						  TALLOC_CTX *mem_ctx,
						  const char *_server_name /* [in] [unique,charset(UTF16)] */,
						  enum wkssvc_ComputerNameType _name_type /* [in]  */,
						  uint32_t _Reserved /* [in]  */,
						  struct wkssvc_ComputerNamesCtr **_ctr /* [out] [ref] */,
						  WERROR *result)
{
	struct wkssvc_NetrEnumerateComputerNames r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.name_type = _name_type;
	r.in.Reserved = _Reserved;

	/* Out parameters */
	r.out.ctr = _ctr;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_wkssvc_NetrEnumerateComputerNames_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ctr = *r.out.ctr;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

