/* parser auto-generated by pidl */

#include "includes.h"
#include "librpc/gen_ndr/ndr_dnsp.h"

#include "librpc/gen_ndr/ndr_misc.h"
static enum ndr_err_code ndr_push_dns_record_type(struct ndr_push *ndr, int ndr_flags, enum dns_record_type r)
{
	NDR_CHECK(ndr_push_enum_uint16(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dns_record_type(struct ndr_pull *ndr, int ndr_flags, enum dns_record_type *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint16(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dns_record_type(struct ndr_print *ndr, const char *name, enum dns_record_type r)
{
	const char *val = NULL;

	switch (r) {
		case DNS_TYPE_TOMBSTONE: val = "DNS_TYPE_TOMBSTONE"; break;
		case DNS_TYPE_A: val = "DNS_TYPE_A"; break;
		case DNS_TYPE_NS: val = "DNS_TYPE_NS"; break;
		case DNS_TYPE_MD: val = "DNS_TYPE_MD"; break;
		case DNS_TYPE_MF: val = "DNS_TYPE_MF"; break;
		case DNS_TYPE_CNAME: val = "DNS_TYPE_CNAME"; break;
		case DNS_TYPE_SOA: val = "DNS_TYPE_SOA"; break;
		case DNS_TYPE_MB: val = "DNS_TYPE_MB"; break;
		case DNS_TYPE_MG: val = "DNS_TYPE_MG"; break;
		case DNS_TYPE_MR: val = "DNS_TYPE_MR"; break;
		case DNS_TYPE_NULL: val = "DNS_TYPE_NULL"; break;
		case DNS_TYPE_WKS: val = "DNS_TYPE_WKS"; break;
		case DNS_TYPE_PTR: val = "DNS_TYPE_PTR"; break;
		case DNS_TYPE_HINFO: val = "DNS_TYPE_HINFO"; break;
		case DNS_TYPE_MINFO: val = "DNS_TYPE_MINFO"; break;
		case DNS_TYPE_MX: val = "DNS_TYPE_MX"; break;
		case DNS_TYPE_TXT: val = "DNS_TYPE_TXT"; break;
		case DNS_TYPE_RP: val = "DNS_TYPE_RP"; break;
		case DNS_TYPE_AFSDB: val = "DNS_TYPE_AFSDB"; break;
		case DNS_TYPE_X25: val = "DNS_TYPE_X25"; break;
		case DNS_TYPE_ISDN: val = "DNS_TYPE_ISDN"; break;
		case DNS_TYPE_RT: val = "DNS_TYPE_RT"; break;
		case DNS_TYPE_SIG: val = "DNS_TYPE_SIG"; break;
		case DNS_TYPE_KEY: val = "DNS_TYPE_KEY"; break;
		case DNS_TYPE_AAAA: val = "DNS_TYPE_AAAA"; break;
		case DNS_TYPE_LOC: val = "DNS_TYPE_LOC"; break;
		case DNS_TYPE_NXT: val = "DNS_TYPE_NXT"; break;
		case DNS_TYPE_SRV: val = "DNS_TYPE_SRV"; break;
		case DNS_TYPE_ATMA: val = "DNS_TYPE_ATMA"; break;
		case DNS_TYPE_NAPTR: val = "DNS_TYPE_NAPTR"; break;
		case DNS_TYPE_DNAME: val = "DNS_TYPE_DNAME"; break;
		case DNS_TYPE_DS: val = "DNS_TYPE_DS"; break;
		case DNS_TYPE_RRSIG: val = "DNS_TYPE_RRSIG"; break;
		case DNS_TYPE_NSEC: val = "DNS_TYPE_NSEC"; break;
		case DNS_TYPE_DNSKEY: val = "DNS_TYPE_DNSKEY"; break;
		case DNS_TYPE_DHCID: val = "DNS_TYPE_DHCID"; break;
		case DNS_TYPE_ALL: val = "DNS_TYPE_ALL"; break;
		case DNS_TYPE_WINS: val = "DNS_TYPE_WINS"; break;
		case DNS_TYPE_WINSR: val = "DNS_TYPE_WINSR"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_dns_record_rank(struct ndr_push *ndr, int ndr_flags, enum dns_record_rank r)
{
	NDR_CHECK(ndr_push_enum_uint8(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dns_record_rank(struct ndr_pull *ndr, int ndr_flags, enum dns_record_rank *r)
{
	uint8_t v;
	NDR_CHECK(ndr_pull_enum_uint8(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dns_record_rank(struct ndr_print *ndr, const char *name, enum dns_record_rank r)
{
	const char *val = NULL;

	switch (r) {
		case DNS_RANK_NONE: val = "DNS_RANK_NONE"; break;
		case DNS_RANK_CACHE_BIT: val = "DNS_RANK_CACHE_BIT"; break;
		case DNS_RANK_ROOT_HINT: val = "DNS_RANK_ROOT_HINT"; break;
		case DNS_RANK_OUTSIDE_GLUE: val = "DNS_RANK_OUTSIDE_GLUE"; break;
		case DNS_RANK_CACHE_NA_ADDITIONAL: val = "DNS_RANK_CACHE_NA_ADDITIONAL"; break;
		case DNS_RANK_CACHE_NA_AUTHORITY: val = "DNS_RANK_CACHE_NA_AUTHORITY"; break;
		case DNS_RANK_CACHE_A_ADDITIONAL: val = "DNS_RANK_CACHE_A_ADDITIONAL"; break;
		case DNS_RANK_CACHE_NA_ANSWER: val = "DNS_RANK_CACHE_NA_ANSWER"; break;
		case DNS_RANK_CACHE_A_AUTHORITY: val = "DNS_RANK_CACHE_A_AUTHORITY"; break;
		case DNS_RANK_GLUE: val = "DNS_RANK_GLUE"; break;
		case DNS_RANK_NS_GLUE: val = "DNS_RANK_NS_GLUE"; break;
		case DNS_RANK_CACHE_A_ANSWER: val = "DNS_RANK_CACHE_A_ANSWER"; break;
		case DNS_RANK_ZONE: val = "DNS_RANK_ZONE"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_dnsp_soa(struct ndr_push *ndr, int ndr_flags, const struct dnsp_soa *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->serial));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->refresh));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->retry));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->expire));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->minimum));
		NDR_CHECK(ndr_push_dnsp_name(ndr, NDR_SCALARS, r->mname));
		NDR_CHECK(ndr_push_dnsp_name(ndr, NDR_SCALARS, r->rname));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dnsp_soa(struct ndr_pull *ndr, int ndr_flags, struct dnsp_soa *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->serial));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->refresh));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->retry));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->expire));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->minimum));
		NDR_CHECK(ndr_pull_dnsp_name(ndr, NDR_SCALARS, &r->mname));
		NDR_CHECK(ndr_pull_dnsp_name(ndr, NDR_SCALARS, &r->rname));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dnsp_soa(struct ndr_print *ndr, const char *name, const struct dnsp_soa *r)
{
	ndr_print_struct(ndr, name, "dnsp_soa");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "serial", r->serial);
	ndr_print_uint32(ndr, "refresh", r->refresh);
	ndr_print_uint32(ndr, "retry", r->retry);
	ndr_print_uint32(ndr, "expire", r->expire);
	ndr_print_uint32(ndr, "minimum", r->minimum);
	ndr_print_dnsp_name(ndr, "mname", r->mname);
	ndr_print_dnsp_name(ndr, "rname", r->rname);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dnsp_mx(struct ndr_push *ndr, int ndr_flags, const struct dnsp_mx *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 2));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->wPriority));
		NDR_CHECK(ndr_push_dnsp_name(ndr, NDR_SCALARS, r->nameTarget));
		NDR_CHECK(ndr_push_trailer_align(ndr, 2));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dnsp_mx(struct ndr_pull *ndr, int ndr_flags, struct dnsp_mx *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 2));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->wPriority));
		NDR_CHECK(ndr_pull_dnsp_name(ndr, NDR_SCALARS, &r->nameTarget));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 2));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dnsp_mx(struct ndr_print *ndr, const char *name, const struct dnsp_mx *r)
{
	ndr_print_struct(ndr, name, "dnsp_mx");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "wPriority", r->wPriority);
	ndr_print_dnsp_name(ndr, "nameTarget", r->nameTarget);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dnsp_hinfo(struct ndr_push *ndr, int ndr_flags, const struct dnsp_hinfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		NDR_CHECK(ndr_push_dnsp_string(ndr, NDR_SCALARS, r->cpu));
		NDR_CHECK(ndr_push_dnsp_string(ndr, NDR_SCALARS, r->os));
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dnsp_hinfo(struct ndr_pull *ndr, int ndr_flags, struct dnsp_hinfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		NDR_CHECK(ndr_pull_dnsp_string(ndr, NDR_SCALARS, &r->cpu));
		NDR_CHECK(ndr_pull_dnsp_string(ndr, NDR_SCALARS, &r->os));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dnsp_hinfo(struct ndr_print *ndr, const char *name, const struct dnsp_hinfo *r)
{
	ndr_print_struct(ndr, name, "dnsp_hinfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_dnsp_string(ndr, "cpu", r->cpu);
	ndr_print_dnsp_string(ndr, "os", r->os);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dnsp_srv(struct ndr_push *ndr, int ndr_flags, const struct dnsp_srv *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 2));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->wPriority));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->wWeight));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->wPort));
		NDR_CHECK(ndr_push_dnsp_name(ndr, NDR_SCALARS, r->nameTarget));
		NDR_CHECK(ndr_push_trailer_align(ndr, 2));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dnsp_srv(struct ndr_pull *ndr, int ndr_flags, struct dnsp_srv *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 2));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->wPriority));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->wWeight));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->wPort));
		NDR_CHECK(ndr_pull_dnsp_name(ndr, NDR_SCALARS, &r->nameTarget));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 2));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dnsp_srv(struct ndr_print *ndr, const char *name, const struct dnsp_srv *r)
{
	ndr_print_struct(ndr, name, "dnsp_srv");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "wPriority", r->wPriority);
	ndr_print_uint16(ndr, "wWeight", r->wWeight);
	ndr_print_uint16(ndr, "wPort", r->wPort);
	ndr_print_dnsp_name(ndr, "nameTarget", r->nameTarget);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dnsRecordData(struct ndr_push *ndr, int ndr_flags, const union dnsRecordData *r)
{
	if (ndr_flags & NDR_SCALARS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_union_align(ndr, 4));
		switch (level) {
			case DNS_TYPE_TOMBSTONE: {
				NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->timestamp));
			break; }

			case DNS_TYPE_A: {
				{
					uint32_t _flags_save_ipv4address = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
					NDR_CHECK(ndr_push_ipv4address(ndr, NDR_SCALARS, r->ipv4));
					ndr->flags = _flags_save_ipv4address;
				}
			break; }

			case DNS_TYPE_NS: {
				NDR_CHECK(ndr_push_dnsp_name(ndr, NDR_SCALARS, r->ns));
			break; }

			case DNS_TYPE_CNAME: {
				NDR_CHECK(ndr_push_dnsp_name(ndr, NDR_SCALARS, r->cname));
			break; }

			case DNS_TYPE_SOA: {
				{
					uint32_t _flags_save_dnsp_soa = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
					NDR_CHECK(ndr_push_dnsp_soa(ndr, NDR_SCALARS, &r->soa));
					ndr->flags = _flags_save_dnsp_soa;
				}
			break; }

			case DNS_TYPE_MX: {
				{
					uint32_t _flags_save_dnsp_mx = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
					NDR_CHECK(ndr_push_dnsp_mx(ndr, NDR_SCALARS, &r->mx));
					ndr->flags = _flags_save_dnsp_mx;
				}
			break; }

			case DNS_TYPE_TXT: {
				NDR_CHECK(ndr_push_dnsp_string(ndr, NDR_SCALARS, r->txt));
			break; }

			case DNS_TYPE_PTR: {
				NDR_CHECK(ndr_push_dnsp_name(ndr, NDR_SCALARS, r->ptr));
			break; }

			case DNS_TYPE_HINFO: {
				NDR_CHECK(ndr_push_dnsp_hinfo(ndr, NDR_SCALARS, &r->hinfo));
			break; }

			case DNS_TYPE_AAAA: {
				NDR_CHECK(ndr_push_ipv6address(ndr, NDR_SCALARS, r->ipv6));
			break; }

			case DNS_TYPE_SRV: {
				{
					uint32_t _flags_save_dnsp_srv = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
					NDR_CHECK(ndr_push_dnsp_srv(ndr, NDR_SCALARS, &r->srv));
					ndr->flags = _flags_save_dnsp_srv;
				}
			break; }

			default: {
				{
					uint32_t _flags_save_DATA_BLOB = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
					NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->data));
					ndr->flags = _flags_save_DATA_BLOB;
				}
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case DNS_TYPE_TOMBSTONE:
			break;

			case DNS_TYPE_A:
			break;

			case DNS_TYPE_NS:
			break;

			case DNS_TYPE_CNAME:
			break;

			case DNS_TYPE_SOA:
			break;

			case DNS_TYPE_MX:
			break;

			case DNS_TYPE_TXT:
			break;

			case DNS_TYPE_PTR:
			break;

			case DNS_TYPE_HINFO:
			break;

			case DNS_TYPE_AAAA:
			break;

			case DNS_TYPE_SRV:
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dnsRecordData(struct ndr_pull *ndr, int ndr_flags, union dnsRecordData *r)
{
	uint32_t level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_union_align(ndr, 4));
		switch (level) {
			case DNS_TYPE_TOMBSTONE: {
				NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->timestamp));
			break; }

			case DNS_TYPE_A: {
				{
					uint32_t _flags_save_ipv4address = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
					NDR_CHECK(ndr_pull_ipv4address(ndr, NDR_SCALARS, &r->ipv4));
					ndr->flags = _flags_save_ipv4address;
				}
			break; }

			case DNS_TYPE_NS: {
				NDR_CHECK(ndr_pull_dnsp_name(ndr, NDR_SCALARS, &r->ns));
			break; }

			case DNS_TYPE_CNAME: {
				NDR_CHECK(ndr_pull_dnsp_name(ndr, NDR_SCALARS, &r->cname));
			break; }

			case DNS_TYPE_SOA: {
				{
					uint32_t _flags_save_dnsp_soa = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
					NDR_CHECK(ndr_pull_dnsp_soa(ndr, NDR_SCALARS, &r->soa));
					ndr->flags = _flags_save_dnsp_soa;
				}
			break; }

			case DNS_TYPE_MX: {
				{
					uint32_t _flags_save_dnsp_mx = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
					NDR_CHECK(ndr_pull_dnsp_mx(ndr, NDR_SCALARS, &r->mx));
					ndr->flags = _flags_save_dnsp_mx;
				}
			break; }

			case DNS_TYPE_TXT: {
				NDR_CHECK(ndr_pull_dnsp_string(ndr, NDR_SCALARS, &r->txt));
			break; }

			case DNS_TYPE_PTR: {
				NDR_CHECK(ndr_pull_dnsp_name(ndr, NDR_SCALARS, &r->ptr));
			break; }

			case DNS_TYPE_HINFO: {
				NDR_CHECK(ndr_pull_dnsp_hinfo(ndr, NDR_SCALARS, &r->hinfo));
			break; }

			case DNS_TYPE_AAAA: {
				NDR_CHECK(ndr_pull_ipv6address(ndr, NDR_SCALARS, &r->ipv6));
			break; }

			case DNS_TYPE_SRV: {
				{
					uint32_t _flags_save_dnsp_srv = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
					NDR_CHECK(ndr_pull_dnsp_srv(ndr, NDR_SCALARS, &r->srv));
					ndr->flags = _flags_save_dnsp_srv;
				}
			break; }

			default: {
				{
					uint32_t _flags_save_DATA_BLOB = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
					NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->data));
					ndr->flags = _flags_save_DATA_BLOB;
				}
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case DNS_TYPE_TOMBSTONE:
			break;

			case DNS_TYPE_A:
			break;

			case DNS_TYPE_NS:
			break;

			case DNS_TYPE_CNAME:
			break;

			case DNS_TYPE_SOA:
			break;

			case DNS_TYPE_MX:
			break;

			case DNS_TYPE_TXT:
			break;

			case DNS_TYPE_PTR:
			break;

			case DNS_TYPE_HINFO:
			break;

			case DNS_TYPE_AAAA:
			break;

			case DNS_TYPE_SRV:
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dnsRecordData(struct ndr_print *ndr, const char *name, const union dnsRecordData *r)
{
	uint32_t level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "dnsRecordData");
	switch (level) {
		case DNS_TYPE_TOMBSTONE:
			ndr_print_NTTIME(ndr, "timestamp", r->timestamp);
		break;

		case DNS_TYPE_A:
			ndr_print_ipv4address(ndr, "ipv4", r->ipv4);
		break;

		case DNS_TYPE_NS:
			ndr_print_dnsp_name(ndr, "ns", r->ns);
		break;

		case DNS_TYPE_CNAME:
			ndr_print_dnsp_name(ndr, "cname", r->cname);
		break;

		case DNS_TYPE_SOA:
			ndr_print_dnsp_soa(ndr, "soa", &r->soa);
		break;

		case DNS_TYPE_MX:
			ndr_print_dnsp_mx(ndr, "mx", &r->mx);
		break;

		case DNS_TYPE_TXT:
			ndr_print_dnsp_string(ndr, "txt", r->txt);
		break;

		case DNS_TYPE_PTR:
			ndr_print_dnsp_name(ndr, "ptr", r->ptr);
		break;

		case DNS_TYPE_HINFO:
			ndr_print_dnsp_hinfo(ndr, "hinfo", &r->hinfo);
		break;

		case DNS_TYPE_AAAA:
			ndr_print_ipv6address(ndr, "ipv6", r->ipv6);
		break;

		case DNS_TYPE_SRV:
			ndr_print_dnsp_srv(ndr, "srv", &r->srv);
		break;

		default:
			ndr_print_DATA_BLOB(ndr, "data", r->data);
		break;

	}
}

static size_t ndr_size_dnsRecordData(const union dnsRecordData *r, uint32_t level, int flags)
{
	return ndr_size_union(r, flags, level, (ndr_push_flags_fn_t)ndr_push_dnsRecordData);
}

_PUBLIC_ enum ndr_err_code ndr_push_dnsp_DnssrvRpcRecord(struct ndr_push *ndr, int ndr_flags, const struct dnsp_DnssrvRpcRecord *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, ndr_size_dnsRecordData(&r->data, r->wType, ndr->flags)));
		NDR_CHECK(ndr_push_dns_record_type(ndr, NDR_SCALARS, r->wType));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, 5));
		NDR_CHECK(ndr_push_dns_record_rank(ndr, NDR_SCALARS, r->rank));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwSerial));
		{
			uint32_t _flags_save_uint32 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwTtlSeconds));
			ndr->flags = _flags_save_uint32;
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReserved));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwTimeStamp));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->data, r->wType));
		NDR_CHECK(ndr_push_dnsRecordData(ndr, NDR_SCALARS, &r->data));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dnsp_DnssrvRpcRecord(struct ndr_pull *ndr, int ndr_flags, struct dnsp_DnssrvRpcRecord *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->wDataLength));
		NDR_CHECK(ndr_pull_dns_record_type(ndr, NDR_SCALARS, &r->wType));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_dns_record_rank(ndr, NDR_SCALARS, &r->rank));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwSerial));
		{
			uint32_t _flags_save_uint32 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwTtlSeconds));
			ndr->flags = _flags_save_uint32;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReserved));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwTimeStamp));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->data, r->wType));
		NDR_CHECK(ndr_pull_dnsRecordData(ndr, NDR_SCALARS, &r->data));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dnsp_DnssrvRpcRecord(struct ndr_print *ndr, const char *name, const struct dnsp_DnssrvRpcRecord *r)
{
	ndr_print_struct(ndr, name, "dnsp_DnssrvRpcRecord");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "wDataLength", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_dnsRecordData(&r->data, r->wType, ndr->flags):r->wDataLength);
	ndr_print_dns_record_type(ndr, "wType", r->wType);
	ndr_print_uint8(ndr, "version", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?5:r->version);
	ndr_print_dns_record_rank(ndr, "rank", r->rank);
	ndr_print_uint16(ndr, "flags", r->flags);
	ndr_print_uint32(ndr, "dwSerial", r->dwSerial);
	ndr_print_uint32(ndr, "dwTtlSeconds", r->dwTtlSeconds);
	ndr_print_uint32(ndr, "dwReserved", r->dwReserved);
	ndr_print_uint32(ndr, "dwTimeStamp", r->dwTimeStamp);
	ndr_print_set_switch_value(ndr, &r->data, r->wType);
	ndr_print_dnsRecordData(ndr, "data", &r->data);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_decode_DnssrvRpcRecord(struct ndr_push *ndr, int flags, const struct decode_DnssrvRpcRecord *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_dnsp_DnssrvRpcRecord(ndr, NDR_SCALARS, &r->in.blob));
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_decode_DnssrvRpcRecord(struct ndr_pull *ndr, int flags, struct decode_DnssrvRpcRecord *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_dnsp_DnssrvRpcRecord(ndr, NDR_SCALARS, &r->in.blob));
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_decode_DnssrvRpcRecord(struct ndr_print *ndr, const char *name, int flags, const struct decode_DnssrvRpcRecord *r)
{
	ndr_print_struct(ndr, name, "decode_DnssrvRpcRecord");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "decode_DnssrvRpcRecord");
		ndr->depth++;
		ndr_print_dnsp_DnssrvRpcRecord(ndr, "blob", &r->in.blob);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "decode_DnssrvRpcRecord");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct ndr_interface_call dnsp_calls[] = {
	{
		"decode_DnssrvRpcRecord",
		sizeof(struct decode_DnssrvRpcRecord),
		(ndr_push_flags_fn_t) ndr_push_decode_DnssrvRpcRecord,
		(ndr_pull_flags_fn_t) ndr_pull_decode_DnssrvRpcRecord,
		(ndr_print_function_t) ndr_print_decode_DnssrvRpcRecord,
		{ 0, NULL },
		{ 0, NULL },
	},
	{ NULL, 0, NULL, NULL, NULL }
};

static const char * const dnsp_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\dnsp]", 
};

static const struct ndr_interface_string_array dnsp_endpoints = {
	.count	= 1,
	.names	= dnsp_endpoint_strings
};

static const char * const dnsp_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array dnsp_authservices = {
	.count	= 1,
	.names	= dnsp_authservice_strings
};


const struct ndr_interface_table ndr_table_dnsp = {
	.name		= "dnsp",
	.syntax_id	= {
		{0xbdd66e9e,0xd45f,0x4202,{0x85,0xc0},{0x61,0x32,0xed,0xc4,0xf3,0x0a}},
		NDR_DNSP_VERSION
	},
	.helpstring	= NDR_DNSP_HELPSTRING,
	.num_calls	= 1,
	.calls		= dnsp_calls,
	.endpoints	= &dnsp_endpoints,
	.authservices	= &dnsp_authservices
};

