/* parser auto-generated by pidl */

#include "includes.h"
#include "librpc/gen_ndr/ndr_wmi.h"

#include "librpc/gen_ndr/ndr_orpc.h"
#include "librpc/gen_ndr/ndr_dcom.h"
#include "librpc/gen_ndr/ndr_misc.h"
#include "librpc/gen_ndr/ndr_orpc.h"
static enum ndr_err_code ndr_push_BSTR(struct ndr_push *ndr, int ndr_flags, const struct BSTR *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->data, CH_UTF16)));
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0x72657355));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->data, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->data, ndr_charset_length(r->data, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_BSTR(struct ndr_pull *ndr, int ndr_flags, struct BSTR *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->data));
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->data));
		if (ndr_get_array_length(ndr, &r->data) > ndr_get_array_size(ndr, &r->data)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->data), ndr_get_array_length(ndr, &r->data));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->data), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->data, ndr_get_array_length(ndr, &r->data), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_push_Delete(struct ndr_push *ndr, int flags, const struct Delete *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		if (r->in.wszName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.wszName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.wszName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.wszName, ndr_charset_length(r->in.wszName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_Delete(struct ndr_pull *ndr, int flags, struct Delete *r)
{
	TALLOC_CTX *_mem_save_ORPCthat_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.wszName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.wszName));
		if (ndr_get_array_length(ndr, &r->in.wszName) > ndr_get_array_size(ndr, &r->in.wszName)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.wszName), ndr_get_array_length(ndr, &r->in.wszName));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.wszName), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.wszName, ndr_get_array_length(ndr, &r->in.wszName), sizeof(uint16_t), CH_UTF16));
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_Delete(struct ndr_print *ndr, const char *name, int flags, const struct Delete *r)
{
	ndr_print_struct(ndr, name, "Delete");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "Delete");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_ptr(ndr, "wszName", r->in.wszName);
		ndr->depth++;
		ndr_print_string(ndr, "wszName", r->in.wszName);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "Delete");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct ndr_interface_call IWbemClassObject_calls[] = {
	{
		"Delete",
		sizeof(struct Delete),
		(ndr_push_flags_fn_t) ndr_push_Delete,
		(ndr_pull_flags_fn_t) ndr_pull_Delete,
		(ndr_print_function_t) ndr_print_Delete,
		{ 0, NULL },
		{ 0, NULL },
	},
	{ NULL, 0, NULL, NULL, NULL }
};

static const char * const IWbemClassObject_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\IWbemClassObject]", 
};

static const struct ndr_interface_string_array IWbemClassObject_endpoints = {
	.count	= 1,
	.names	= IWbemClassObject_endpoint_strings
};

static const char * const IWbemClassObject_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array IWbemClassObject_authservices = {
	.count	= 1,
	.names	= IWbemClassObject_authservice_strings
};


const struct ndr_interface_table ndr_table_IWbemClassObject = {
	.name		= "IWbemClassObject",
	.syntax_id	= {
		{0xdc12a681,0x737f,0x11cf,{0x88,0x4d},{0x00,0xaa,0x00,0x4b,0x2e,0x24}},
		NDR_IWBEMCLASSOBJECT_VERSION
	},
	.helpstring	= NDR_IWBEMCLASSOBJECT_HELPSTRING,
	.num_calls	= 1,
	.calls		= IWbemClassObject_calls,
	.endpoints	= &IWbemClassObject_endpoints,
	.authservices	= &IWbemClassObject_authservices
};

#include "librpc/gen_ndr/ndr_orpc.h"
_PUBLIC_ enum ndr_err_code ndr_push_WBEM_GENERIC_FLAG_TYPE(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_WBEM_GENERIC_FLAG_TYPE(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_WBEM_GENERIC_FLAG_TYPE(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "WBEM_FLAG_RETURN_WBEM_COMPLETE", WBEM_FLAG_RETURN_WBEM_COMPLETE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "WBEM_FLAG_BIDIRECTIONAL", WBEM_FLAG_BIDIRECTIONAL, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "WBEM_FLAG_RETURN_IMMEDIATELY", WBEM_FLAG_RETURN_IMMEDIATELY, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "WBEM_FLAG_FORWARD_ONLY", WBEM_FLAG_FORWARD_ONLY, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "WBEM_FLAG_NO_ERROR_OBJECT", WBEM_FLAG_NO_ERROR_OBJECT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "WBEM_FLAG_SEND_STATUS", WBEM_FLAG_SEND_STATUS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "WBEM_FLAG_ENSURE_LOCATABLE", WBEM_FLAG_ENSURE_LOCATABLE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "WBEM_FLAG_DIRECT_READ", WBEM_FLAG_DIRECT_READ, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "WBEM_FLAG_USE_AMENDED_QUALIFIERS", WBEM_FLAG_USE_AMENDED_QUALIFIERS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "WBEM_FLAG_STRONG_VALIDATION", WBEM_FLAG_STRONG_VALIDATION, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "WBEM_FLAG_RETURN_ERROR_OBJECT", WBEM_FLAG_RETURN_ERROR_OBJECT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "WBEM_FLAG_DONT_SEND_STATUS", WBEM_FLAG_DONT_SEND_STATUS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "WBEM_FLAG_SEND_ONLY_SELECTED", WBEM_FLAG_SEND_ONLY_SELECTED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "WBEM_RETURN_WHEN_COMPLETE", WBEM_RETURN_WHEN_COMPLETE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "WBEM_RETURN_IMMEDIATELY", WBEM_RETURN_IMMEDIATELY, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "WBEM_MASK_RESERVED_FLAGS", WBEM_MASK_RESERVED_FLAGS, r);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_WBEM_TIMEOUT_TYPE(struct ndr_push *ndr, int ndr_flags, enum WBEM_TIMEOUT_TYPE r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_WBEM_TIMEOUT_TYPE(struct ndr_pull *ndr, int ndr_flags, enum WBEM_TIMEOUT_TYPE *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_WBEM_TIMEOUT_TYPE(struct ndr_print *ndr, const char *name, enum WBEM_TIMEOUT_TYPE r)
{
	const char *val = NULL;

	switch (r) {
		case WBEM_NO_WAIT: val = "WBEM_NO_WAIT"; break;
		case WBEM_INFINITE: val = "WBEM_INFINITE"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_CIMTYPE_ENUMERATION(struct ndr_push *ndr, int ndr_flags, enum CIMTYPE_ENUMERATION r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_CIMTYPE_ENUMERATION(struct ndr_pull *ndr, int ndr_flags, enum CIMTYPE_ENUMERATION *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_CIMTYPE_ENUMERATION(struct ndr_print *ndr, const char *name, enum CIMTYPE_ENUMERATION r)
{
	const char *val = NULL;

	switch (r) {
		case CIM_EMPTY: val = "CIM_EMPTY"; break;
		case CIM_SINT16: val = "CIM_SINT16"; break;
		case CIM_SINT32: val = "CIM_SINT32"; break;
		case CIM_REAL32: val = "CIM_REAL32"; break;
		case CIM_REAL64: val = "CIM_REAL64"; break;
		case CIM_STRING: val = "CIM_STRING"; break;
		case CIM_BOOLEAN: val = "CIM_BOOLEAN"; break;
		case CIM_OBJECT: val = "CIM_OBJECT"; break;
		case CIM_SINT8: val = "CIM_SINT8"; break;
		case CIM_UINT8: val = "CIM_UINT8"; break;
		case CIM_UINT16: val = "CIM_UINT16"; break;
		case CIM_UINT32: val = "CIM_UINT32"; break;
		case CIM_SINT64: val = "CIM_SINT64"; break;
		case CIM_UINT64: val = "CIM_UINT64"; break;
		case CIM_DATETIME: val = "CIM_DATETIME"; break;
		case CIM_REFERENCE: val = "CIM_REFERENCE"; break;
		case CIM_CHAR16: val = "CIM_CHAR16"; break;
		case CIM_FLAG_ARRAY: val = "CIM_FLAG_ARRAY"; break;
		case CIM_ILLEGAL: val = "CIM_ILLEGAL"; break;
		case CIM_TYPEMASK: val = "CIM_TYPEMASK"; break;
		case CIM_ARR_SINT8: val = "CIM_ARR_SINT8"; break;
		case CIM_ARR_UINT8: val = "CIM_ARR_UINT8"; break;
		case CIM_ARR_SINT16: val = "CIM_ARR_SINT16"; break;
		case CIM_ARR_UINT16: val = "CIM_ARR_UINT16"; break;
		case CIM_ARR_SINT32: val = "CIM_ARR_SINT32"; break;
		case CIM_ARR_UINT32: val = "CIM_ARR_UINT32"; break;
		case CIM_ARR_SINT64: val = "CIM_ARR_SINT64"; break;
		case CIM_ARR_UINT64: val = "CIM_ARR_UINT64"; break;
		case CIM_ARR_REAL32: val = "CIM_ARR_REAL32"; break;
		case CIM_ARR_REAL64: val = "CIM_ARR_REAL64"; break;
		case CIM_ARR_BOOLEAN: val = "CIM_ARR_BOOLEAN"; break;
		case CIM_ARR_STRING: val = "CIM_ARR_STRING"; break;
		case CIM_ARR_DATETIME: val = "CIM_ARR_DATETIME"; break;
		case CIM_ARR_REFERENCE: val = "CIM_ARR_REFERENCE"; break;
		case CIM_ARR_CHAR16: val = "CIM_ARR_CHAR16"; break;
		case CIM_ARR_OBJECT: val = "CIM_ARR_OBJECT"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_WBEM_FLAVOR_TYPE(struct ndr_push *ndr, int ndr_flags, uint8_t r)
{
	NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_WBEM_FLAVOR_TYPE(struct ndr_pull *ndr, int ndr_flags, uint8_t *r)
{
	uint8_t v;
	NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_WBEM_FLAVOR_TYPE(struct ndr_print *ndr, const char *name, uint8_t r)
{
	ndr_print_uint8(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint8_t), "WBEM_FLAVOR_FLAG_PROPAGATE_TO_INSTANCE", WBEM_FLAVOR_FLAG_PROPAGATE_TO_INSTANCE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint8_t), "WBEM_FLAVOR_FLAG_PROPAGATE_TO_DERIVED_CLASS", WBEM_FLAVOR_FLAG_PROPAGATE_TO_DERIVED_CLASS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint8_t), "WBEM_FLAVOR_NOT_OVERRIDABLE", WBEM_FLAVOR_NOT_OVERRIDABLE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint8_t), "WBEM_FLAVOR_ORIGIN_PROPAGATED", WBEM_FLAVOR_ORIGIN_PROPAGATED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint8_t), "WBEM_FLAVOR_ORIGIN_SYSTEM", WBEM_FLAVOR_ORIGIN_SYSTEM, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint8_t), "WBEM_FLAVOR_AMENDED", WBEM_FLAVOR_AMENDED, r);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_WCO_FLAGS(struct ndr_push *ndr, int ndr_flags, uint8_t r)
{
	NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_WCO_FLAGS(struct ndr_pull *ndr, int ndr_flags, uint8_t *r)
{
	uint8_t v;
	NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_WCO_FLAGS(struct ndr_print *ndr, const char *name, uint8_t r)
{
	ndr_print_uint8(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint8_t), "WCF_DECORATIONS", WCF_DECORATIONS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint8_t), "WCF_INSTANCE", WCF_INSTANCE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint8_t), "WCF_CLASS", WCF_CLASS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint8_t), "WCF_CLASS_PART_INTERNAL", WCF_CLASS_PART_INTERNAL, r);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_DEFAULT_FLAGS(struct ndr_push *ndr, int ndr_flags, uint8_t r)
{
	NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_DEFAULT_FLAGS(struct ndr_pull *ndr, int ndr_flags, uint8_t *r)
{
	uint8_t v;
	NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DEFAULT_FLAGS(struct ndr_print *ndr, const char *name, uint8_t r)
{
	ndr_print_uint8(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint8_t), "DEFAULT_FLAG_EMPTY", DEFAULT_FLAG_EMPTY, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint8_t), "DEFAULT_FLAG_INHERITED", DEFAULT_FLAG_INHERITED, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_OpenNamespace(struct ndr_push *ndr, int flags, const struct OpenNamespace *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_push_BSTR(ndr, NDR_SCALARS, &r->in.strNamespace));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->in.lFlags));
		if (r->in.pCtx == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pCtx));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.ppWorkingNamespace));
		if (r->in.ppWorkingNamespace) {
			NDR_CHECK(ndr_push_unique_ptr(ndr, *r->in.ppWorkingNamespace));
			if (*r->in.ppWorkingNamespace) {
				NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->in.ppWorkingNamespace));
			}
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.ppResult));
		if (r->in.ppResult) {
			NDR_CHECK(ndr_push_unique_ptr(ndr, *r->in.ppResult));
			if (*r->in.ppResult) {
				NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->in.ppResult));
			}
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.ppWorkingNamespace));
		if (r->out.ppWorkingNamespace) {
			NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.ppWorkingNamespace));
			if (*r->out.ppWorkingNamespace) {
				NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppWorkingNamespace));
			}
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.ppResult));
		if (r->out.ppResult) {
			NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.ppResult));
			if (*r->out.ppResult) {
				NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppResult));
			}
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_OpenNamespace(struct ndr_pull *ndr, int flags, struct OpenNamespace *r)
{
	uint32_t _ptr_ppWorkingNamespace;
	uint32_t _ptr_ppResult;
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_pCtx_0;
	TALLOC_CTX *_mem_save_ppWorkingNamespace_0;
	TALLOC_CTX *_mem_save_ppWorkingNamespace_1;
	TALLOC_CTX *_mem_save_ppResult_0;
	TALLOC_CTX *_mem_save_ppResult_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_pull_BSTR(ndr, NDR_SCALARS, &r->in.strNamespace));
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->in.lFlags));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pCtx);
		}
		_mem_save_pCtx_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pCtx, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pCtx));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pCtx_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppWorkingNamespace));
		if (_ptr_ppWorkingNamespace) {
			NDR_PULL_ALLOC(ndr, r->in.ppWorkingNamespace);
		} else {
			r->in.ppWorkingNamespace = NULL;
		}
		if (r->in.ppWorkingNamespace) {
			_mem_save_ppWorkingNamespace_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.ppWorkingNamespace, 0);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppWorkingNamespace));
			if (_ptr_ppWorkingNamespace) {
				NDR_PULL_ALLOC(ndr, *r->in.ppWorkingNamespace);
			} else {
				*r->in.ppWorkingNamespace = NULL;
			}
			if (*r->in.ppWorkingNamespace) {
				_mem_save_ppWorkingNamespace_1 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, *r->in.ppWorkingNamespace, 0);
				NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->in.ppWorkingNamespace));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppWorkingNamespace_1, 0);
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppWorkingNamespace_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppResult));
		if (_ptr_ppResult) {
			NDR_PULL_ALLOC(ndr, r->in.ppResult);
		} else {
			r->in.ppResult = NULL;
		}
		if (r->in.ppResult) {
			_mem_save_ppResult_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.ppResult, 0);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppResult));
			if (_ptr_ppResult) {
				NDR_PULL_ALLOC(ndr, *r->in.ppResult);
			} else {
				*r->in.ppResult = NULL;
			}
			if (*r->in.ppResult) {
				_mem_save_ppResult_1 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, *r->in.ppResult, 0);
				NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->in.ppResult));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppResult_1, 0);
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppResult_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppWorkingNamespace));
		if (_ptr_ppWorkingNamespace) {
			NDR_PULL_ALLOC(ndr, r->out.ppWorkingNamespace);
		} else {
			r->out.ppWorkingNamespace = NULL;
		}
		if (r->out.ppWorkingNamespace) {
			_mem_save_ppWorkingNamespace_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.ppWorkingNamespace, 0);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppWorkingNamespace));
			if (_ptr_ppWorkingNamespace) {
				NDR_PULL_ALLOC(ndr, *r->out.ppWorkingNamespace);
			} else {
				*r->out.ppWorkingNamespace = NULL;
			}
			if (*r->out.ppWorkingNamespace) {
				_mem_save_ppWorkingNamespace_1 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, *r->out.ppWorkingNamespace, 0);
				NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppWorkingNamespace));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppWorkingNamespace_1, 0);
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppWorkingNamespace_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppResult));
		if (_ptr_ppResult) {
			NDR_PULL_ALLOC(ndr, r->out.ppResult);
		} else {
			r->out.ppResult = NULL;
		}
		if (r->out.ppResult) {
			_mem_save_ppResult_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.ppResult, 0);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppResult));
			if (_ptr_ppResult) {
				NDR_PULL_ALLOC(ndr, *r->out.ppResult);
			} else {
				*r->out.ppResult = NULL;
			}
			if (*r->out.ppResult) {
				_mem_save_ppResult_1 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, *r->out.ppResult, 0);
				NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppResult));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppResult_1, 0);
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppResult_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_OpenNamespace(struct ndr_print *ndr, const char *name, int flags, const struct OpenNamespace *r)
{
	ndr_print_struct(ndr, name, "OpenNamespace");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "OpenNamespace");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_BSTR(ndr, "strNamespace", &r->in.strNamespace);
		ndr_print_int32(ndr, "lFlags", r->in.lFlags);
		ndr_print_ptr(ndr, "pCtx", r->in.pCtx);
		ndr->depth++;
		ndr_print_MInterfacePointer(ndr, "pCtx", r->in.pCtx);
		ndr->depth--;
		ndr_print_ptr(ndr, "ppWorkingNamespace", r->in.ppWorkingNamespace);
		ndr->depth++;
		if (r->in.ppWorkingNamespace) {
			ndr_print_ptr(ndr, "ppWorkingNamespace", *r->in.ppWorkingNamespace);
			ndr->depth++;
			if (*r->in.ppWorkingNamespace) {
				ndr_print_MInterfacePointer(ndr, "ppWorkingNamespace", *r->in.ppWorkingNamespace);
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "ppResult", r->in.ppResult);
		ndr->depth++;
		if (r->in.ppResult) {
			ndr_print_ptr(ndr, "ppResult", *r->in.ppResult);
			ndr->depth++;
			if (*r->in.ppResult) {
				ndr_print_MInterfacePointer(ndr, "ppResult", *r->in.ppResult);
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "OpenNamespace");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_ptr(ndr, "ppWorkingNamespace", r->out.ppWorkingNamespace);
		ndr->depth++;
		if (r->out.ppWorkingNamespace) {
			ndr_print_ptr(ndr, "ppWorkingNamespace", *r->out.ppWorkingNamespace);
			ndr->depth++;
			if (*r->out.ppWorkingNamespace) {
				ndr_print_MInterfacePointer(ndr, "ppWorkingNamespace", *r->out.ppWorkingNamespace);
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "ppResult", r->out.ppResult);
		ndr->depth++;
		if (r->out.ppResult) {
			ndr_print_ptr(ndr, "ppResult", *r->out.ppResult);
			ndr->depth++;
			if (*r->out.ppResult) {
				ndr_print_MInterfacePointer(ndr, "ppResult", *r->out.ppResult);
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_CancelAsyncCall(struct ndr_push *ndr, int flags, const struct CancelAsyncCall *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		if (r->in.pSink == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pSink));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_CancelAsyncCall(struct ndr_pull *ndr, int flags, struct CancelAsyncCall *r)
{
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_pSink_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pSink);
		}
		_mem_save_pSink_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pSink, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pSink));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pSink_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_CancelAsyncCall(struct ndr_print *ndr, const char *name, int flags, const struct CancelAsyncCall *r)
{
	ndr_print_struct(ndr, name, "CancelAsyncCall");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "CancelAsyncCall");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_ptr(ndr, "pSink", r->in.pSink);
		ndr->depth++;
		ndr_print_MInterfacePointer(ndr, "pSink", r->in.pSink);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "CancelAsyncCall");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_QueryObjectSink(struct ndr_push *ndr, int flags, const struct QueryObjectSink *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->in.lFlags));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		if (r->out.ppResponseHandler == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.ppResponseHandler));
		if (*r->out.ppResponseHandler) {
			NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppResponseHandler));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_QueryObjectSink(struct ndr_pull *ndr, int flags, struct QueryObjectSink *r)
{
	uint32_t _ptr_ppResponseHandler;
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_ppResponseHandler_0;
	TALLOC_CTX *_mem_save_ppResponseHandler_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->in.lFlags));
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
		NDR_PULL_ALLOC(ndr, r->out.ppResponseHandler);
		ZERO_STRUCTP(r->out.ppResponseHandler);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ppResponseHandler);
		}
		_mem_save_ppResponseHandler_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ppResponseHandler, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppResponseHandler));
		if (_ptr_ppResponseHandler) {
			NDR_PULL_ALLOC(ndr, *r->out.ppResponseHandler);
		} else {
			*r->out.ppResponseHandler = NULL;
		}
		if (*r->out.ppResponseHandler) {
			_mem_save_ppResponseHandler_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.ppResponseHandler, 0);
			NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppResponseHandler));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppResponseHandler_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppResponseHandler_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_QueryObjectSink(struct ndr_print *ndr, const char *name, int flags, const struct QueryObjectSink *r)
{
	ndr_print_struct(ndr, name, "QueryObjectSink");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "QueryObjectSink");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_int32(ndr, "lFlags", r->in.lFlags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "QueryObjectSink");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_ptr(ndr, "ppResponseHandler", r->out.ppResponseHandler);
		ndr->depth++;
		ndr_print_ptr(ndr, "ppResponseHandler", *r->out.ppResponseHandler);
		ndr->depth++;
		if (*r->out.ppResponseHandler) {
			ndr_print_MInterfacePointer(ndr, "ppResponseHandler", *r->out.ppResponseHandler);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_GetObject(struct ndr_push *ndr, int flags, const struct GetObject *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_push_BSTR(ndr, NDR_SCALARS, &r->in.strObjectPath));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->in.lFlags));
		if (r->in.pCtx == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pCtx));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.ppObject));
		if (r->in.ppObject) {
			NDR_CHECK(ndr_push_unique_ptr(ndr, *r->in.ppObject));
			if (*r->in.ppObject) {
				NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->in.ppObject));
			}
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.ppCallResult));
		if (r->in.ppCallResult) {
			NDR_CHECK(ndr_push_unique_ptr(ndr, *r->in.ppCallResult));
			if (*r->in.ppCallResult) {
				NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->in.ppCallResult));
			}
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.ppObject));
		if (r->out.ppObject) {
			NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.ppObject));
			if (*r->out.ppObject) {
				NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppObject));
			}
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.ppCallResult));
		if (r->out.ppCallResult) {
			NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.ppCallResult));
			if (*r->out.ppCallResult) {
				NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppCallResult));
			}
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_GetObject(struct ndr_pull *ndr, int flags, struct GetObject *r)
{
	uint32_t _ptr_ppObject;
	uint32_t _ptr_ppCallResult;
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_pCtx_0;
	TALLOC_CTX *_mem_save_ppObject_0;
	TALLOC_CTX *_mem_save_ppObject_1;
	TALLOC_CTX *_mem_save_ppCallResult_0;
	TALLOC_CTX *_mem_save_ppCallResult_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_pull_BSTR(ndr, NDR_SCALARS, &r->in.strObjectPath));
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->in.lFlags));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pCtx);
		}
		_mem_save_pCtx_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pCtx, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pCtx));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pCtx_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppObject));
		if (_ptr_ppObject) {
			NDR_PULL_ALLOC(ndr, r->in.ppObject);
		} else {
			r->in.ppObject = NULL;
		}
		if (r->in.ppObject) {
			_mem_save_ppObject_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.ppObject, 0);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppObject));
			if (_ptr_ppObject) {
				NDR_PULL_ALLOC(ndr, *r->in.ppObject);
			} else {
				*r->in.ppObject = NULL;
			}
			if (*r->in.ppObject) {
				_mem_save_ppObject_1 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, *r->in.ppObject, 0);
				NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->in.ppObject));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppObject_1, 0);
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppObject_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppCallResult));
		if (_ptr_ppCallResult) {
			NDR_PULL_ALLOC(ndr, r->in.ppCallResult);
		} else {
			r->in.ppCallResult = NULL;
		}
		if (r->in.ppCallResult) {
			_mem_save_ppCallResult_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.ppCallResult, 0);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppCallResult));
			if (_ptr_ppCallResult) {
				NDR_PULL_ALLOC(ndr, *r->in.ppCallResult);
			} else {
				*r->in.ppCallResult = NULL;
			}
			if (*r->in.ppCallResult) {
				_mem_save_ppCallResult_1 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, *r->in.ppCallResult, 0);
				NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->in.ppCallResult));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppCallResult_1, 0);
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppCallResult_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppObject));
		if (_ptr_ppObject) {
			NDR_PULL_ALLOC(ndr, r->out.ppObject);
		} else {
			r->out.ppObject = NULL;
		}
		if (r->out.ppObject) {
			_mem_save_ppObject_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.ppObject, 0);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppObject));
			if (_ptr_ppObject) {
				NDR_PULL_ALLOC(ndr, *r->out.ppObject);
			} else {
				*r->out.ppObject = NULL;
			}
			if (*r->out.ppObject) {
				_mem_save_ppObject_1 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, *r->out.ppObject, 0);
				NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppObject));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppObject_1, 0);
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppObject_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppCallResult));
		if (_ptr_ppCallResult) {
			NDR_PULL_ALLOC(ndr, r->out.ppCallResult);
		} else {
			r->out.ppCallResult = NULL;
		}
		if (r->out.ppCallResult) {
			_mem_save_ppCallResult_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.ppCallResult, 0);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppCallResult));
			if (_ptr_ppCallResult) {
				NDR_PULL_ALLOC(ndr, *r->out.ppCallResult);
			} else {
				*r->out.ppCallResult = NULL;
			}
			if (*r->out.ppCallResult) {
				_mem_save_ppCallResult_1 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, *r->out.ppCallResult, 0);
				NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppCallResult));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppCallResult_1, 0);
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppCallResult_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_GetObject(struct ndr_print *ndr, const char *name, int flags, const struct GetObject *r)
{
	ndr_print_struct(ndr, name, "GetObject");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "GetObject");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_BSTR(ndr, "strObjectPath", &r->in.strObjectPath);
		ndr_print_int32(ndr, "lFlags", r->in.lFlags);
		ndr_print_ptr(ndr, "pCtx", r->in.pCtx);
		ndr->depth++;
		ndr_print_MInterfacePointer(ndr, "pCtx", r->in.pCtx);
		ndr->depth--;
		ndr_print_ptr(ndr, "ppObject", r->in.ppObject);
		ndr->depth++;
		if (r->in.ppObject) {
			ndr_print_ptr(ndr, "ppObject", *r->in.ppObject);
			ndr->depth++;
			if (*r->in.ppObject) {
				ndr_print_MInterfacePointer(ndr, "ppObject", *r->in.ppObject);
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "ppCallResult", r->in.ppCallResult);
		ndr->depth++;
		if (r->in.ppCallResult) {
			ndr_print_ptr(ndr, "ppCallResult", *r->in.ppCallResult);
			ndr->depth++;
			if (*r->in.ppCallResult) {
				ndr_print_MInterfacePointer(ndr, "ppCallResult", *r->in.ppCallResult);
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "GetObject");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_ptr(ndr, "ppObject", r->out.ppObject);
		ndr->depth++;
		if (r->out.ppObject) {
			ndr_print_ptr(ndr, "ppObject", *r->out.ppObject);
			ndr->depth++;
			if (*r->out.ppObject) {
				ndr_print_MInterfacePointer(ndr, "ppObject", *r->out.ppObject);
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "ppCallResult", r->out.ppCallResult);
		ndr->depth++;
		if (r->out.ppCallResult) {
			ndr_print_ptr(ndr, "ppCallResult", *r->out.ppCallResult);
			ndr->depth++;
			if (*r->out.ppCallResult) {
				ndr_print_MInterfacePointer(ndr, "ppCallResult", *r->out.ppCallResult);
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_GetObjectAsync(struct ndr_push *ndr, int flags, const struct GetObjectAsync *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_push_BSTR(ndr, NDR_SCALARS, &r->in.strObjectPath));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->in.lFlags));
		if (r->in.pCtx == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pCtx));
		if (r->in.pResponseHandler == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pResponseHandler));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_GetObjectAsync(struct ndr_pull *ndr, int flags, struct GetObjectAsync *r)
{
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_pCtx_0;
	TALLOC_CTX *_mem_save_pResponseHandler_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_pull_BSTR(ndr, NDR_SCALARS, &r->in.strObjectPath));
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->in.lFlags));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pCtx);
		}
		_mem_save_pCtx_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pCtx, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pCtx));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pCtx_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pResponseHandler);
		}
		_mem_save_pResponseHandler_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pResponseHandler, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pResponseHandler));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pResponseHandler_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_GetObjectAsync(struct ndr_print *ndr, const char *name, int flags, const struct GetObjectAsync *r)
{
	ndr_print_struct(ndr, name, "GetObjectAsync");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "GetObjectAsync");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_BSTR(ndr, "strObjectPath", &r->in.strObjectPath);
		ndr_print_int32(ndr, "lFlags", r->in.lFlags);
		ndr_print_ptr(ndr, "pCtx", r->in.pCtx);
		ndr->depth++;
		ndr_print_MInterfacePointer(ndr, "pCtx", r->in.pCtx);
		ndr->depth--;
		ndr_print_ptr(ndr, "pResponseHandler", r->in.pResponseHandler);
		ndr->depth++;
		ndr_print_MInterfacePointer(ndr, "pResponseHandler", r->in.pResponseHandler);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "GetObjectAsync");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PutClass(struct ndr_push *ndr, int flags, const struct PutClass *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		if (r->in.pObject == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pObject));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->in.lFlags));
		if (r->in.pCtx == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pCtx));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.ppCallResult));
		if (r->in.ppCallResult) {
			NDR_CHECK(ndr_push_unique_ptr(ndr, *r->in.ppCallResult));
			if (*r->in.ppCallResult) {
				NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->in.ppCallResult));
			}
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.ppCallResult));
		if (r->out.ppCallResult) {
			NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.ppCallResult));
			if (*r->out.ppCallResult) {
				NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppCallResult));
			}
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PutClass(struct ndr_pull *ndr, int flags, struct PutClass *r)
{
	uint32_t _ptr_ppCallResult;
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_pObject_0;
	TALLOC_CTX *_mem_save_pCtx_0;
	TALLOC_CTX *_mem_save_ppCallResult_0;
	TALLOC_CTX *_mem_save_ppCallResult_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pObject);
		}
		_mem_save_pObject_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pObject, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pObject));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pObject_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->in.lFlags));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pCtx);
		}
		_mem_save_pCtx_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pCtx, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pCtx));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pCtx_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppCallResult));
		if (_ptr_ppCallResult) {
			NDR_PULL_ALLOC(ndr, r->in.ppCallResult);
		} else {
			r->in.ppCallResult = NULL;
		}
		if (r->in.ppCallResult) {
			_mem_save_ppCallResult_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.ppCallResult, 0);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppCallResult));
			if (_ptr_ppCallResult) {
				NDR_PULL_ALLOC(ndr, *r->in.ppCallResult);
			} else {
				*r->in.ppCallResult = NULL;
			}
			if (*r->in.ppCallResult) {
				_mem_save_ppCallResult_1 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, *r->in.ppCallResult, 0);
				NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->in.ppCallResult));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppCallResult_1, 0);
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppCallResult_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppCallResult));
		if (_ptr_ppCallResult) {
			NDR_PULL_ALLOC(ndr, r->out.ppCallResult);
		} else {
			r->out.ppCallResult = NULL;
		}
		if (r->out.ppCallResult) {
			_mem_save_ppCallResult_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.ppCallResult, 0);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppCallResult));
			if (_ptr_ppCallResult) {
				NDR_PULL_ALLOC(ndr, *r->out.ppCallResult);
			} else {
				*r->out.ppCallResult = NULL;
			}
			if (*r->out.ppCallResult) {
				_mem_save_ppCallResult_1 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, *r->out.ppCallResult, 0);
				NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppCallResult));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppCallResult_1, 0);
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppCallResult_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PutClass(struct ndr_print *ndr, const char *name, int flags, const struct PutClass *r)
{
	ndr_print_struct(ndr, name, "PutClass");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PutClass");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_ptr(ndr, "pObject", r->in.pObject);
		ndr->depth++;
		ndr_print_MInterfacePointer(ndr, "pObject", r->in.pObject);
		ndr->depth--;
		ndr_print_int32(ndr, "lFlags", r->in.lFlags);
		ndr_print_ptr(ndr, "pCtx", r->in.pCtx);
		ndr->depth++;
		ndr_print_MInterfacePointer(ndr, "pCtx", r->in.pCtx);
		ndr->depth--;
		ndr_print_ptr(ndr, "ppCallResult", r->in.ppCallResult);
		ndr->depth++;
		if (r->in.ppCallResult) {
			ndr_print_ptr(ndr, "ppCallResult", *r->in.ppCallResult);
			ndr->depth++;
			if (*r->in.ppCallResult) {
				ndr_print_MInterfacePointer(ndr, "ppCallResult", *r->in.ppCallResult);
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PutClass");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_ptr(ndr, "ppCallResult", r->out.ppCallResult);
		ndr->depth++;
		if (r->out.ppCallResult) {
			ndr_print_ptr(ndr, "ppCallResult", *r->out.ppCallResult);
			ndr->depth++;
			if (*r->out.ppCallResult) {
				ndr_print_MInterfacePointer(ndr, "ppCallResult", *r->out.ppCallResult);
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PutClassAsync(struct ndr_push *ndr, int flags, const struct PutClassAsync *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		if (r->in.pObject == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pObject));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->in.lFlags));
		if (r->in.pCtx == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pCtx));
		if (r->in.pResponseHandler == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pResponseHandler));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PutClassAsync(struct ndr_pull *ndr, int flags, struct PutClassAsync *r)
{
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_pObject_0;
	TALLOC_CTX *_mem_save_pCtx_0;
	TALLOC_CTX *_mem_save_pResponseHandler_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pObject);
		}
		_mem_save_pObject_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pObject, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pObject));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pObject_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->in.lFlags));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pCtx);
		}
		_mem_save_pCtx_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pCtx, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pCtx));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pCtx_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pResponseHandler);
		}
		_mem_save_pResponseHandler_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pResponseHandler, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pResponseHandler));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pResponseHandler_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PutClassAsync(struct ndr_print *ndr, const char *name, int flags, const struct PutClassAsync *r)
{
	ndr_print_struct(ndr, name, "PutClassAsync");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PutClassAsync");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_ptr(ndr, "pObject", r->in.pObject);
		ndr->depth++;
		ndr_print_MInterfacePointer(ndr, "pObject", r->in.pObject);
		ndr->depth--;
		ndr_print_int32(ndr, "lFlags", r->in.lFlags);
		ndr_print_ptr(ndr, "pCtx", r->in.pCtx);
		ndr->depth++;
		ndr_print_MInterfacePointer(ndr, "pCtx", r->in.pCtx);
		ndr->depth--;
		ndr_print_ptr(ndr, "pResponseHandler", r->in.pResponseHandler);
		ndr->depth++;
		ndr_print_MInterfacePointer(ndr, "pResponseHandler", r->in.pResponseHandler);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PutClassAsync");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DeleteClass(struct ndr_push *ndr, int flags, const struct DeleteClass *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_push_BSTR(ndr, NDR_SCALARS, &r->in.strClass));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->in.lFlags));
		if (r->in.pCtx == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pCtx));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.ppCallResult));
		if (r->in.ppCallResult) {
			NDR_CHECK(ndr_push_unique_ptr(ndr, *r->in.ppCallResult));
			if (*r->in.ppCallResult) {
				NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->in.ppCallResult));
			}
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.ppCallResult));
		if (r->out.ppCallResult) {
			NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.ppCallResult));
			if (*r->out.ppCallResult) {
				NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppCallResult));
			}
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DeleteClass(struct ndr_pull *ndr, int flags, struct DeleteClass *r)
{
	uint32_t _ptr_ppCallResult;
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_pCtx_0;
	TALLOC_CTX *_mem_save_ppCallResult_0;
	TALLOC_CTX *_mem_save_ppCallResult_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_pull_BSTR(ndr, NDR_SCALARS, &r->in.strClass));
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->in.lFlags));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pCtx);
		}
		_mem_save_pCtx_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pCtx, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pCtx));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pCtx_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppCallResult));
		if (_ptr_ppCallResult) {
			NDR_PULL_ALLOC(ndr, r->in.ppCallResult);
		} else {
			r->in.ppCallResult = NULL;
		}
		if (r->in.ppCallResult) {
			_mem_save_ppCallResult_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.ppCallResult, 0);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppCallResult));
			if (_ptr_ppCallResult) {
				NDR_PULL_ALLOC(ndr, *r->in.ppCallResult);
			} else {
				*r->in.ppCallResult = NULL;
			}
			if (*r->in.ppCallResult) {
				_mem_save_ppCallResult_1 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, *r->in.ppCallResult, 0);
				NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->in.ppCallResult));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppCallResult_1, 0);
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppCallResult_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppCallResult));
		if (_ptr_ppCallResult) {
			NDR_PULL_ALLOC(ndr, r->out.ppCallResult);
		} else {
			r->out.ppCallResult = NULL;
		}
		if (r->out.ppCallResult) {
			_mem_save_ppCallResult_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.ppCallResult, 0);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppCallResult));
			if (_ptr_ppCallResult) {
				NDR_PULL_ALLOC(ndr, *r->out.ppCallResult);
			} else {
				*r->out.ppCallResult = NULL;
			}
			if (*r->out.ppCallResult) {
				_mem_save_ppCallResult_1 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, *r->out.ppCallResult, 0);
				NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppCallResult));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppCallResult_1, 0);
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppCallResult_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DeleteClass(struct ndr_print *ndr, const char *name, int flags, const struct DeleteClass *r)
{
	ndr_print_struct(ndr, name, "DeleteClass");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "DeleteClass");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_BSTR(ndr, "strClass", &r->in.strClass);
		ndr_print_int32(ndr, "lFlags", r->in.lFlags);
		ndr_print_ptr(ndr, "pCtx", r->in.pCtx);
		ndr->depth++;
		ndr_print_MInterfacePointer(ndr, "pCtx", r->in.pCtx);
		ndr->depth--;
		ndr_print_ptr(ndr, "ppCallResult", r->in.ppCallResult);
		ndr->depth++;
		if (r->in.ppCallResult) {
			ndr_print_ptr(ndr, "ppCallResult", *r->in.ppCallResult);
			ndr->depth++;
			if (*r->in.ppCallResult) {
				ndr_print_MInterfacePointer(ndr, "ppCallResult", *r->in.ppCallResult);
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "DeleteClass");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_ptr(ndr, "ppCallResult", r->out.ppCallResult);
		ndr->depth++;
		if (r->out.ppCallResult) {
			ndr_print_ptr(ndr, "ppCallResult", *r->out.ppCallResult);
			ndr->depth++;
			if (*r->out.ppCallResult) {
				ndr_print_MInterfacePointer(ndr, "ppCallResult", *r->out.ppCallResult);
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DeleteClassAsync(struct ndr_push *ndr, int flags, const struct DeleteClassAsync *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_push_BSTR(ndr, NDR_SCALARS, &r->in.strClass));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->in.lFlags));
		if (r->in.pCtx == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pCtx));
		if (r->in.pResponseHandler == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pResponseHandler));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DeleteClassAsync(struct ndr_pull *ndr, int flags, struct DeleteClassAsync *r)
{
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_pCtx_0;
	TALLOC_CTX *_mem_save_pResponseHandler_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_pull_BSTR(ndr, NDR_SCALARS, &r->in.strClass));
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->in.lFlags));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pCtx);
		}
		_mem_save_pCtx_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pCtx, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pCtx));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pCtx_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pResponseHandler);
		}
		_mem_save_pResponseHandler_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pResponseHandler, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pResponseHandler));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pResponseHandler_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DeleteClassAsync(struct ndr_print *ndr, const char *name, int flags, const struct DeleteClassAsync *r)
{
	ndr_print_struct(ndr, name, "DeleteClassAsync");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "DeleteClassAsync");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_BSTR(ndr, "strClass", &r->in.strClass);
		ndr_print_int32(ndr, "lFlags", r->in.lFlags);
		ndr_print_ptr(ndr, "pCtx", r->in.pCtx);
		ndr->depth++;
		ndr_print_MInterfacePointer(ndr, "pCtx", r->in.pCtx);
		ndr->depth--;
		ndr_print_ptr(ndr, "pResponseHandler", r->in.pResponseHandler);
		ndr->depth++;
		ndr_print_MInterfacePointer(ndr, "pResponseHandler", r->in.pResponseHandler);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "DeleteClassAsync");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_CreateClassEnum(struct ndr_push *ndr, int flags, const struct CreateClassEnum *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_push_BSTR(ndr, NDR_SCALARS, &r->in.strSuperclass));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->in.lFlags));
		if (r->in.pCtx == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pCtx));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		if (r->out.ppEnum == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.ppEnum));
		if (*r->out.ppEnum) {
			NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppEnum));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_CreateClassEnum(struct ndr_pull *ndr, int flags, struct CreateClassEnum *r)
{
	uint32_t _ptr_ppEnum;
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_pCtx_0;
	TALLOC_CTX *_mem_save_ppEnum_0;
	TALLOC_CTX *_mem_save_ppEnum_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_pull_BSTR(ndr, NDR_SCALARS, &r->in.strSuperclass));
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->in.lFlags));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pCtx);
		}
		_mem_save_pCtx_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pCtx, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pCtx));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pCtx_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
		NDR_PULL_ALLOC(ndr, r->out.ppEnum);
		ZERO_STRUCTP(r->out.ppEnum);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ppEnum);
		}
		_mem_save_ppEnum_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ppEnum, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppEnum));
		if (_ptr_ppEnum) {
			NDR_PULL_ALLOC(ndr, *r->out.ppEnum);
		} else {
			*r->out.ppEnum = NULL;
		}
		if (*r->out.ppEnum) {
			_mem_save_ppEnum_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.ppEnum, 0);
			NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppEnum));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppEnum_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppEnum_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_CreateClassEnum(struct ndr_print *ndr, const char *name, int flags, const struct CreateClassEnum *r)
{
	ndr_print_struct(ndr, name, "CreateClassEnum");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "CreateClassEnum");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_BSTR(ndr, "strSuperclass", &r->in.strSuperclass);
		ndr_print_int32(ndr, "lFlags", r->in.lFlags);
		ndr_print_ptr(ndr, "pCtx", r->in.pCtx);
		ndr->depth++;
		ndr_print_MInterfacePointer(ndr, "pCtx", r->in.pCtx);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "CreateClassEnum");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_ptr(ndr, "ppEnum", r->out.ppEnum);
		ndr->depth++;
		ndr_print_ptr(ndr, "ppEnum", *r->out.ppEnum);
		ndr->depth++;
		if (*r->out.ppEnum) {
			ndr_print_MInterfacePointer(ndr, "ppEnum", *r->out.ppEnum);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_CreateClassEnumAsync(struct ndr_push *ndr, int flags, const struct CreateClassEnumAsync *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_push_BSTR(ndr, NDR_SCALARS, &r->in.strSuperclass));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->in.lFlags));
		if (r->in.pCtx == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pCtx));
		if (r->in.pResponseHandler == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pResponseHandler));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_CreateClassEnumAsync(struct ndr_pull *ndr, int flags, struct CreateClassEnumAsync *r)
{
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_pCtx_0;
	TALLOC_CTX *_mem_save_pResponseHandler_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_pull_BSTR(ndr, NDR_SCALARS, &r->in.strSuperclass));
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->in.lFlags));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pCtx);
		}
		_mem_save_pCtx_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pCtx, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pCtx));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pCtx_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pResponseHandler);
		}
		_mem_save_pResponseHandler_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pResponseHandler, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pResponseHandler));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pResponseHandler_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_CreateClassEnumAsync(struct ndr_print *ndr, const char *name, int flags, const struct CreateClassEnumAsync *r)
{
	ndr_print_struct(ndr, name, "CreateClassEnumAsync");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "CreateClassEnumAsync");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_BSTR(ndr, "strSuperclass", &r->in.strSuperclass);
		ndr_print_int32(ndr, "lFlags", r->in.lFlags);
		ndr_print_ptr(ndr, "pCtx", r->in.pCtx);
		ndr->depth++;
		ndr_print_MInterfacePointer(ndr, "pCtx", r->in.pCtx);
		ndr->depth--;
		ndr_print_ptr(ndr, "pResponseHandler", r->in.pResponseHandler);
		ndr->depth++;
		ndr_print_MInterfacePointer(ndr, "pResponseHandler", r->in.pResponseHandler);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "CreateClassEnumAsync");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PutInstance(struct ndr_push *ndr, int flags, const struct PutInstance *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		if (r->in.pInst == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pInst));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->in.lFlags));
		if (r->in.pCtx == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pCtx));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.ppCallResult));
		if (r->in.ppCallResult) {
			NDR_CHECK(ndr_push_unique_ptr(ndr, *r->in.ppCallResult));
			if (*r->in.ppCallResult) {
				NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->in.ppCallResult));
			}
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.ppCallResult));
		if (r->out.ppCallResult) {
			NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.ppCallResult));
			if (*r->out.ppCallResult) {
				NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppCallResult));
			}
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PutInstance(struct ndr_pull *ndr, int flags, struct PutInstance *r)
{
	uint32_t _ptr_ppCallResult;
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_pInst_0;
	TALLOC_CTX *_mem_save_pCtx_0;
	TALLOC_CTX *_mem_save_ppCallResult_0;
	TALLOC_CTX *_mem_save_ppCallResult_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pInst);
		}
		_mem_save_pInst_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pInst, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pInst));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pInst_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->in.lFlags));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pCtx);
		}
		_mem_save_pCtx_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pCtx, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pCtx));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pCtx_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppCallResult));
		if (_ptr_ppCallResult) {
			NDR_PULL_ALLOC(ndr, r->in.ppCallResult);
		} else {
			r->in.ppCallResult = NULL;
		}
		if (r->in.ppCallResult) {
			_mem_save_ppCallResult_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.ppCallResult, 0);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppCallResult));
			if (_ptr_ppCallResult) {
				NDR_PULL_ALLOC(ndr, *r->in.ppCallResult);
			} else {
				*r->in.ppCallResult = NULL;
			}
			if (*r->in.ppCallResult) {
				_mem_save_ppCallResult_1 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, *r->in.ppCallResult, 0);
				NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->in.ppCallResult));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppCallResult_1, 0);
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppCallResult_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppCallResult));
		if (_ptr_ppCallResult) {
			NDR_PULL_ALLOC(ndr, r->out.ppCallResult);
		} else {
			r->out.ppCallResult = NULL;
		}
		if (r->out.ppCallResult) {
			_mem_save_ppCallResult_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.ppCallResult, 0);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppCallResult));
			if (_ptr_ppCallResult) {
				NDR_PULL_ALLOC(ndr, *r->out.ppCallResult);
			} else {
				*r->out.ppCallResult = NULL;
			}
			if (*r->out.ppCallResult) {
				_mem_save_ppCallResult_1 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, *r->out.ppCallResult, 0);
				NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppCallResult));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppCallResult_1, 0);
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppCallResult_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PutInstance(struct ndr_print *ndr, const char *name, int flags, const struct PutInstance *r)
{
	ndr_print_struct(ndr, name, "PutInstance");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PutInstance");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_ptr(ndr, "pInst", r->in.pInst);
		ndr->depth++;
		ndr_print_MInterfacePointer(ndr, "pInst", r->in.pInst);
		ndr->depth--;
		ndr_print_int32(ndr, "lFlags", r->in.lFlags);
		ndr_print_ptr(ndr, "pCtx", r->in.pCtx);
		ndr->depth++;
		ndr_print_MInterfacePointer(ndr, "pCtx", r->in.pCtx);
		ndr->depth--;
		ndr_print_ptr(ndr, "ppCallResult", r->in.ppCallResult);
		ndr->depth++;
		if (r->in.ppCallResult) {
			ndr_print_ptr(ndr, "ppCallResult", *r->in.ppCallResult);
			ndr->depth++;
			if (*r->in.ppCallResult) {
				ndr_print_MInterfacePointer(ndr, "ppCallResult", *r->in.ppCallResult);
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PutInstance");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_ptr(ndr, "ppCallResult", r->out.ppCallResult);
		ndr->depth++;
		if (r->out.ppCallResult) {
			ndr_print_ptr(ndr, "ppCallResult", *r->out.ppCallResult);
			ndr->depth++;
			if (*r->out.ppCallResult) {
				ndr_print_MInterfacePointer(ndr, "ppCallResult", *r->out.ppCallResult);
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PutInstanceAsync(struct ndr_push *ndr, int flags, const struct PutInstanceAsync *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		if (r->in.pInst == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pInst));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->in.lFlags));
		if (r->in.pCtx == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pCtx));
		if (r->in.pResponseHandler == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pResponseHandler));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PutInstanceAsync(struct ndr_pull *ndr, int flags, struct PutInstanceAsync *r)
{
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_pInst_0;
	TALLOC_CTX *_mem_save_pCtx_0;
	TALLOC_CTX *_mem_save_pResponseHandler_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pInst);
		}
		_mem_save_pInst_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pInst, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pInst));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pInst_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->in.lFlags));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pCtx);
		}
		_mem_save_pCtx_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pCtx, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pCtx));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pCtx_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pResponseHandler);
		}
		_mem_save_pResponseHandler_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pResponseHandler, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pResponseHandler));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pResponseHandler_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PutInstanceAsync(struct ndr_print *ndr, const char *name, int flags, const struct PutInstanceAsync *r)
{
	ndr_print_struct(ndr, name, "PutInstanceAsync");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PutInstanceAsync");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_ptr(ndr, "pInst", r->in.pInst);
		ndr->depth++;
		ndr_print_MInterfacePointer(ndr, "pInst", r->in.pInst);
		ndr->depth--;
		ndr_print_int32(ndr, "lFlags", r->in.lFlags);
		ndr_print_ptr(ndr, "pCtx", r->in.pCtx);
		ndr->depth++;
		ndr_print_MInterfacePointer(ndr, "pCtx", r->in.pCtx);
		ndr->depth--;
		ndr_print_ptr(ndr, "pResponseHandler", r->in.pResponseHandler);
		ndr->depth++;
		ndr_print_MInterfacePointer(ndr, "pResponseHandler", r->in.pResponseHandler);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PutInstanceAsync");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DeleteInstance(struct ndr_push *ndr, int flags, const struct DeleteInstance *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_push_BSTR(ndr, NDR_SCALARS, &r->in.strObjectPath));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->in.lFlags));
		if (r->in.pCtx == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pCtx));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.ppCallResult));
		if (r->in.ppCallResult) {
			NDR_CHECK(ndr_push_unique_ptr(ndr, *r->in.ppCallResult));
			if (*r->in.ppCallResult) {
				NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->in.ppCallResult));
			}
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.ppCallResult));
		if (r->out.ppCallResult) {
			NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.ppCallResult));
			if (*r->out.ppCallResult) {
				NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppCallResult));
			}
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DeleteInstance(struct ndr_pull *ndr, int flags, struct DeleteInstance *r)
{
	uint32_t _ptr_ppCallResult;
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_pCtx_0;
	TALLOC_CTX *_mem_save_ppCallResult_0;
	TALLOC_CTX *_mem_save_ppCallResult_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_pull_BSTR(ndr, NDR_SCALARS, &r->in.strObjectPath));
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->in.lFlags));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pCtx);
		}
		_mem_save_pCtx_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pCtx, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pCtx));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pCtx_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppCallResult));
		if (_ptr_ppCallResult) {
			NDR_PULL_ALLOC(ndr, r->in.ppCallResult);
		} else {
			r->in.ppCallResult = NULL;
		}
		if (r->in.ppCallResult) {
			_mem_save_ppCallResult_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.ppCallResult, 0);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppCallResult));
			if (_ptr_ppCallResult) {
				NDR_PULL_ALLOC(ndr, *r->in.ppCallResult);
			} else {
				*r->in.ppCallResult = NULL;
			}
			if (*r->in.ppCallResult) {
				_mem_save_ppCallResult_1 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, *r->in.ppCallResult, 0);
				NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->in.ppCallResult));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppCallResult_1, 0);
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppCallResult_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppCallResult));
		if (_ptr_ppCallResult) {
			NDR_PULL_ALLOC(ndr, r->out.ppCallResult);
		} else {
			r->out.ppCallResult = NULL;
		}
		if (r->out.ppCallResult) {
			_mem_save_ppCallResult_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.ppCallResult, 0);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppCallResult));
			if (_ptr_ppCallResult) {
				NDR_PULL_ALLOC(ndr, *r->out.ppCallResult);
			} else {
				*r->out.ppCallResult = NULL;
			}
			if (*r->out.ppCallResult) {
				_mem_save_ppCallResult_1 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, *r->out.ppCallResult, 0);
				NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppCallResult));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppCallResult_1, 0);
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppCallResult_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DeleteInstance(struct ndr_print *ndr, const char *name, int flags, const struct DeleteInstance *r)
{
	ndr_print_struct(ndr, name, "DeleteInstance");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "DeleteInstance");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_BSTR(ndr, "strObjectPath", &r->in.strObjectPath);
		ndr_print_int32(ndr, "lFlags", r->in.lFlags);
		ndr_print_ptr(ndr, "pCtx", r->in.pCtx);
		ndr->depth++;
		ndr_print_MInterfacePointer(ndr, "pCtx", r->in.pCtx);
		ndr->depth--;
		ndr_print_ptr(ndr, "ppCallResult", r->in.ppCallResult);
		ndr->depth++;
		if (r->in.ppCallResult) {
			ndr_print_ptr(ndr, "ppCallResult", *r->in.ppCallResult);
			ndr->depth++;
			if (*r->in.ppCallResult) {
				ndr_print_MInterfacePointer(ndr, "ppCallResult", *r->in.ppCallResult);
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "DeleteInstance");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_ptr(ndr, "ppCallResult", r->out.ppCallResult);
		ndr->depth++;
		if (r->out.ppCallResult) {
			ndr_print_ptr(ndr, "ppCallResult", *r->out.ppCallResult);
			ndr->depth++;
			if (*r->out.ppCallResult) {
				ndr_print_MInterfacePointer(ndr, "ppCallResult", *r->out.ppCallResult);
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DeleteInstanceAsync(struct ndr_push *ndr, int flags, const struct DeleteInstanceAsync *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_push_BSTR(ndr, NDR_SCALARS, &r->in.strObjectPath));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->in.lFlags));
		if (r->in.pCtx == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pCtx));
		if (r->in.pResponseHandler == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pResponseHandler));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DeleteInstanceAsync(struct ndr_pull *ndr, int flags, struct DeleteInstanceAsync *r)
{
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_pCtx_0;
	TALLOC_CTX *_mem_save_pResponseHandler_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_pull_BSTR(ndr, NDR_SCALARS, &r->in.strObjectPath));
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->in.lFlags));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pCtx);
		}
		_mem_save_pCtx_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pCtx, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pCtx));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pCtx_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pResponseHandler);
		}
		_mem_save_pResponseHandler_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pResponseHandler, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pResponseHandler));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pResponseHandler_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DeleteInstanceAsync(struct ndr_print *ndr, const char *name, int flags, const struct DeleteInstanceAsync *r)
{
	ndr_print_struct(ndr, name, "DeleteInstanceAsync");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "DeleteInstanceAsync");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_BSTR(ndr, "strObjectPath", &r->in.strObjectPath);
		ndr_print_int32(ndr, "lFlags", r->in.lFlags);
		ndr_print_ptr(ndr, "pCtx", r->in.pCtx);
		ndr->depth++;
		ndr_print_MInterfacePointer(ndr, "pCtx", r->in.pCtx);
		ndr->depth--;
		ndr_print_ptr(ndr, "pResponseHandler", r->in.pResponseHandler);
		ndr->depth++;
		ndr_print_MInterfacePointer(ndr, "pResponseHandler", r->in.pResponseHandler);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "DeleteInstanceAsync");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_CreateInstanceEnum(struct ndr_push *ndr, int flags, const struct CreateInstanceEnum *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_push_BSTR(ndr, NDR_SCALARS, &r->in.strFilter));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->in.lFlags));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pCtx));
		if (r->in.pCtx) {
			NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pCtx));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		if (r->out.ppEnum == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.ppEnum));
		if (*r->out.ppEnum) {
			NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppEnum));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_CreateInstanceEnum(struct ndr_pull *ndr, int flags, struct CreateInstanceEnum *r)
{
	uint32_t _ptr_pCtx;
	uint32_t _ptr_ppEnum;
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_pCtx_0;
	TALLOC_CTX *_mem_save_ppEnum_0;
	TALLOC_CTX *_mem_save_ppEnum_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_pull_BSTR(ndr, NDR_SCALARS, &r->in.strFilter));
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->in.lFlags));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pCtx));
		if (_ptr_pCtx) {
			NDR_PULL_ALLOC(ndr, r->in.pCtx);
		} else {
			r->in.pCtx = NULL;
		}
		if (r->in.pCtx) {
			_mem_save_pCtx_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pCtx, 0);
			NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pCtx));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pCtx_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
		NDR_PULL_ALLOC(ndr, r->out.ppEnum);
		ZERO_STRUCTP(r->out.ppEnum);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ppEnum);
		}
		_mem_save_ppEnum_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ppEnum, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppEnum));
		if (_ptr_ppEnum) {
			NDR_PULL_ALLOC(ndr, *r->out.ppEnum);
		} else {
			*r->out.ppEnum = NULL;
		}
		if (*r->out.ppEnum) {
			_mem_save_ppEnum_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.ppEnum, 0);
			NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppEnum));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppEnum_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppEnum_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_CreateInstanceEnum(struct ndr_print *ndr, const char *name, int flags, const struct CreateInstanceEnum *r)
{
	ndr_print_struct(ndr, name, "CreateInstanceEnum");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "CreateInstanceEnum");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_BSTR(ndr, "strFilter", &r->in.strFilter);
		ndr_print_int32(ndr, "lFlags", r->in.lFlags);
		ndr_print_ptr(ndr, "pCtx", r->in.pCtx);
		ndr->depth++;
		if (r->in.pCtx) {
			ndr_print_MInterfacePointer(ndr, "pCtx", r->in.pCtx);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "CreateInstanceEnum");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_ptr(ndr, "ppEnum", r->out.ppEnum);
		ndr->depth++;
		ndr_print_ptr(ndr, "ppEnum", *r->out.ppEnum);
		ndr->depth++;
		if (*r->out.ppEnum) {
			ndr_print_MInterfacePointer(ndr, "ppEnum", *r->out.ppEnum);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_CreateInstanceEnumAsync(struct ndr_push *ndr, int flags, const struct CreateInstanceEnumAsync *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_push_BSTR(ndr, NDR_SCALARS, &r->in.strSuperClass));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->in.lFlags));
		if (r->in.pCtx == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pCtx));
		if (r->in.pResponseHandler == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pResponseHandler));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_CreateInstanceEnumAsync(struct ndr_pull *ndr, int flags, struct CreateInstanceEnumAsync *r)
{
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_pCtx_0;
	TALLOC_CTX *_mem_save_pResponseHandler_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_pull_BSTR(ndr, NDR_SCALARS, &r->in.strSuperClass));
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->in.lFlags));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pCtx);
		}
		_mem_save_pCtx_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pCtx, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pCtx));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pCtx_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pResponseHandler);
		}
		_mem_save_pResponseHandler_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pResponseHandler, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pResponseHandler));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pResponseHandler_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_CreateInstanceEnumAsync(struct ndr_print *ndr, const char *name, int flags, const struct CreateInstanceEnumAsync *r)
{
	ndr_print_struct(ndr, name, "CreateInstanceEnumAsync");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "CreateInstanceEnumAsync");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_BSTR(ndr, "strSuperClass", &r->in.strSuperClass);
		ndr_print_int32(ndr, "lFlags", r->in.lFlags);
		ndr_print_ptr(ndr, "pCtx", r->in.pCtx);
		ndr->depth++;
		ndr_print_MInterfacePointer(ndr, "pCtx", r->in.pCtx);
		ndr->depth--;
		ndr_print_ptr(ndr, "pResponseHandler", r->in.pResponseHandler);
		ndr->depth++;
		ndr_print_MInterfacePointer(ndr, "pResponseHandler", r->in.pResponseHandler);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "CreateInstanceEnumAsync");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_ExecQuery(struct ndr_push *ndr, int flags, const struct ExecQuery *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_push_BSTR(ndr, NDR_SCALARS, &r->in.strQueryLanguage));
		NDR_CHECK(ndr_push_BSTR(ndr, NDR_SCALARS, &r->in.strQuery));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->in.lFlags));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pCtx));
		if (r->in.pCtx) {
			NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pCtx));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		if (r->out.ppEnum == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.ppEnum));
		if (*r->out.ppEnum) {
			NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppEnum));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_ExecQuery(struct ndr_pull *ndr, int flags, struct ExecQuery *r)
{
	uint32_t _ptr_pCtx;
	uint32_t _ptr_ppEnum;
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_pCtx_0;
	TALLOC_CTX *_mem_save_ppEnum_0;
	TALLOC_CTX *_mem_save_ppEnum_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_pull_BSTR(ndr, NDR_SCALARS, &r->in.strQueryLanguage));
		NDR_CHECK(ndr_pull_BSTR(ndr, NDR_SCALARS, &r->in.strQuery));
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->in.lFlags));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pCtx));
		if (_ptr_pCtx) {
			NDR_PULL_ALLOC(ndr, r->in.pCtx);
		} else {
			r->in.pCtx = NULL;
		}
		if (r->in.pCtx) {
			_mem_save_pCtx_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pCtx, 0);
			NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pCtx));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pCtx_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
		NDR_PULL_ALLOC(ndr, r->out.ppEnum);
		ZERO_STRUCTP(r->out.ppEnum);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ppEnum);
		}
		_mem_save_ppEnum_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ppEnum, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppEnum));
		if (_ptr_ppEnum) {
			NDR_PULL_ALLOC(ndr, *r->out.ppEnum);
		} else {
			*r->out.ppEnum = NULL;
		}
		if (*r->out.ppEnum) {
			_mem_save_ppEnum_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.ppEnum, 0);
			NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppEnum));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppEnum_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppEnum_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_ExecQuery(struct ndr_print *ndr, const char *name, int flags, const struct ExecQuery *r)
{
	ndr_print_struct(ndr, name, "ExecQuery");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "ExecQuery");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_BSTR(ndr, "strQueryLanguage", &r->in.strQueryLanguage);
		ndr_print_BSTR(ndr, "strQuery", &r->in.strQuery);
		ndr_print_int32(ndr, "lFlags", r->in.lFlags);
		ndr_print_ptr(ndr, "pCtx", r->in.pCtx);
		ndr->depth++;
		if (r->in.pCtx) {
			ndr_print_MInterfacePointer(ndr, "pCtx", r->in.pCtx);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "ExecQuery");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_ptr(ndr, "ppEnum", r->out.ppEnum);
		ndr->depth++;
		ndr_print_ptr(ndr, "ppEnum", *r->out.ppEnum);
		ndr->depth++;
		if (*r->out.ppEnum) {
			ndr_print_MInterfacePointer(ndr, "ppEnum", *r->out.ppEnum);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_ExecQueryAsync(struct ndr_push *ndr, int flags, const struct ExecQueryAsync *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_push_BSTR(ndr, NDR_SCALARS, &r->in.strQueryLanguage));
		NDR_CHECK(ndr_push_BSTR(ndr, NDR_SCALARS, &r->in.strQuery));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->in.lFlags));
		if (r->in.pCtx == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pCtx));
		if (r->in.pResponseHandler == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pResponseHandler));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_ExecQueryAsync(struct ndr_pull *ndr, int flags, struct ExecQueryAsync *r)
{
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_pCtx_0;
	TALLOC_CTX *_mem_save_pResponseHandler_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_pull_BSTR(ndr, NDR_SCALARS, &r->in.strQueryLanguage));
		NDR_CHECK(ndr_pull_BSTR(ndr, NDR_SCALARS, &r->in.strQuery));
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->in.lFlags));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pCtx);
		}
		_mem_save_pCtx_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pCtx, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pCtx));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pCtx_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pResponseHandler);
		}
		_mem_save_pResponseHandler_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pResponseHandler, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pResponseHandler));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pResponseHandler_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_ExecQueryAsync(struct ndr_print *ndr, const char *name, int flags, const struct ExecQueryAsync *r)
{
	ndr_print_struct(ndr, name, "ExecQueryAsync");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "ExecQueryAsync");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_BSTR(ndr, "strQueryLanguage", &r->in.strQueryLanguage);
		ndr_print_BSTR(ndr, "strQuery", &r->in.strQuery);
		ndr_print_int32(ndr, "lFlags", r->in.lFlags);
		ndr_print_ptr(ndr, "pCtx", r->in.pCtx);
		ndr->depth++;
		ndr_print_MInterfacePointer(ndr, "pCtx", r->in.pCtx);
		ndr->depth--;
		ndr_print_ptr(ndr, "pResponseHandler", r->in.pResponseHandler);
		ndr->depth++;
		ndr_print_MInterfacePointer(ndr, "pResponseHandler", r->in.pResponseHandler);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "ExecQueryAsync");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_ExecNotificationQuery(struct ndr_push *ndr, int flags, const struct ExecNotificationQuery *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_push_BSTR(ndr, NDR_SCALARS, &r->in.strQueryLanguage));
		NDR_CHECK(ndr_push_BSTR(ndr, NDR_SCALARS, &r->in.strQuery));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->in.lFlags));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pCtx));
		if (r->in.pCtx) {
			NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pCtx));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		if (r->out.ppEnum == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.ppEnum));
		if (*r->out.ppEnum) {
			NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppEnum));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_ExecNotificationQuery(struct ndr_pull *ndr, int flags, struct ExecNotificationQuery *r)
{
	uint32_t _ptr_pCtx;
	uint32_t _ptr_ppEnum;
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_pCtx_0;
	TALLOC_CTX *_mem_save_ppEnum_0;
	TALLOC_CTX *_mem_save_ppEnum_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_pull_BSTR(ndr, NDR_SCALARS, &r->in.strQueryLanguage));
		NDR_CHECK(ndr_pull_BSTR(ndr, NDR_SCALARS, &r->in.strQuery));
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->in.lFlags));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pCtx));
		if (_ptr_pCtx) {
			NDR_PULL_ALLOC(ndr, r->in.pCtx);
		} else {
			r->in.pCtx = NULL;
		}
		if (r->in.pCtx) {
			_mem_save_pCtx_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pCtx, 0);
			NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pCtx));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pCtx_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
		NDR_PULL_ALLOC(ndr, r->out.ppEnum);
		ZERO_STRUCTP(r->out.ppEnum);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ppEnum);
		}
		_mem_save_ppEnum_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ppEnum, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppEnum));
		if (_ptr_ppEnum) {
			NDR_PULL_ALLOC(ndr, *r->out.ppEnum);
		} else {
			*r->out.ppEnum = NULL;
		}
		if (*r->out.ppEnum) {
			_mem_save_ppEnum_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.ppEnum, 0);
			NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppEnum));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppEnum_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppEnum_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_ExecNotificationQuery(struct ndr_print *ndr, const char *name, int flags, const struct ExecNotificationQuery *r)
{
	ndr_print_struct(ndr, name, "ExecNotificationQuery");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "ExecNotificationQuery");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_BSTR(ndr, "strQueryLanguage", &r->in.strQueryLanguage);
		ndr_print_BSTR(ndr, "strQuery", &r->in.strQuery);
		ndr_print_int32(ndr, "lFlags", r->in.lFlags);
		ndr_print_ptr(ndr, "pCtx", r->in.pCtx);
		ndr->depth++;
		if (r->in.pCtx) {
			ndr_print_MInterfacePointer(ndr, "pCtx", r->in.pCtx);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "ExecNotificationQuery");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_ptr(ndr, "ppEnum", r->out.ppEnum);
		ndr->depth++;
		ndr_print_ptr(ndr, "ppEnum", *r->out.ppEnum);
		ndr->depth++;
		if (*r->out.ppEnum) {
			ndr_print_MInterfacePointer(ndr, "ppEnum", *r->out.ppEnum);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_ExecNotificationQueryAsync(struct ndr_push *ndr, int flags, const struct ExecNotificationQueryAsync *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_push_BSTR(ndr, NDR_SCALARS, &r->in.strQueryLanguage));
		NDR_CHECK(ndr_push_BSTR(ndr, NDR_SCALARS, &r->in.strQuery));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->in.lFlags));
		if (r->in.pCtx == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pCtx));
		if (r->in.pResponseHandler == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pResponseHandler));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_ExecNotificationQueryAsync(struct ndr_pull *ndr, int flags, struct ExecNotificationQueryAsync *r)
{
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_pCtx_0;
	TALLOC_CTX *_mem_save_pResponseHandler_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_pull_BSTR(ndr, NDR_SCALARS, &r->in.strQueryLanguage));
		NDR_CHECK(ndr_pull_BSTR(ndr, NDR_SCALARS, &r->in.strQuery));
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->in.lFlags));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pCtx);
		}
		_mem_save_pCtx_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pCtx, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pCtx));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pCtx_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pResponseHandler);
		}
		_mem_save_pResponseHandler_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pResponseHandler, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pResponseHandler));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pResponseHandler_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_ExecNotificationQueryAsync(struct ndr_print *ndr, const char *name, int flags, const struct ExecNotificationQueryAsync *r)
{
	ndr_print_struct(ndr, name, "ExecNotificationQueryAsync");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "ExecNotificationQueryAsync");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_BSTR(ndr, "strQueryLanguage", &r->in.strQueryLanguage);
		ndr_print_BSTR(ndr, "strQuery", &r->in.strQuery);
		ndr_print_int32(ndr, "lFlags", r->in.lFlags);
		ndr_print_ptr(ndr, "pCtx", r->in.pCtx);
		ndr->depth++;
		ndr_print_MInterfacePointer(ndr, "pCtx", r->in.pCtx);
		ndr->depth--;
		ndr_print_ptr(ndr, "pResponseHandler", r->in.pResponseHandler);
		ndr->depth++;
		ndr_print_MInterfacePointer(ndr, "pResponseHandler", r->in.pResponseHandler);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "ExecNotificationQueryAsync");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_ExecMethod(struct ndr_push *ndr, int flags, const struct ExecMethod *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_push_BSTR(ndr, NDR_SCALARS, &r->in.strObjectPath));
		NDR_CHECK(ndr_push_BSTR(ndr, NDR_SCALARS, &r->in.strMethodName));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->in.lFlags));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pCtx));
		if (r->in.pCtx) {
			NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pCtx));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pInParams));
		if (r->in.pInParams) {
			NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pInParams));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.ppOutParams));
		if (r->in.ppOutParams) {
			NDR_CHECK(ndr_push_unique_ptr(ndr, *r->in.ppOutParams));
			if (*r->in.ppOutParams) {
				NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->in.ppOutParams));
			}
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.ppCallResult));
		if (r->in.ppCallResult) {
			NDR_CHECK(ndr_push_unique_ptr(ndr, *r->in.ppCallResult));
			if (*r->in.ppCallResult) {
				NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->in.ppCallResult));
			}
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.ppOutParams));
		if (r->out.ppOutParams) {
			NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.ppOutParams));
			if (*r->out.ppOutParams) {
				NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppOutParams));
			}
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.ppCallResult));
		if (r->out.ppCallResult) {
			NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.ppCallResult));
			if (*r->out.ppCallResult) {
				NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppCallResult));
			}
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_ExecMethod(struct ndr_pull *ndr, int flags, struct ExecMethod *r)
{
	uint32_t _ptr_pCtx;
	uint32_t _ptr_pInParams;
	uint32_t _ptr_ppOutParams;
	uint32_t _ptr_ppCallResult;
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_pCtx_0;
	TALLOC_CTX *_mem_save_pInParams_0;
	TALLOC_CTX *_mem_save_ppOutParams_0;
	TALLOC_CTX *_mem_save_ppOutParams_1;
	TALLOC_CTX *_mem_save_ppCallResult_0;
	TALLOC_CTX *_mem_save_ppCallResult_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_pull_BSTR(ndr, NDR_SCALARS, &r->in.strObjectPath));
		NDR_CHECK(ndr_pull_BSTR(ndr, NDR_SCALARS, &r->in.strMethodName));
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->in.lFlags));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pCtx));
		if (_ptr_pCtx) {
			NDR_PULL_ALLOC(ndr, r->in.pCtx);
		} else {
			r->in.pCtx = NULL;
		}
		if (r->in.pCtx) {
			_mem_save_pCtx_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pCtx, 0);
			NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pCtx));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pCtx_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pInParams));
		if (_ptr_pInParams) {
			NDR_PULL_ALLOC(ndr, r->in.pInParams);
		} else {
			r->in.pInParams = NULL;
		}
		if (r->in.pInParams) {
			_mem_save_pInParams_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pInParams, 0);
			NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pInParams));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pInParams_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppOutParams));
		if (_ptr_ppOutParams) {
			NDR_PULL_ALLOC(ndr, r->in.ppOutParams);
		} else {
			r->in.ppOutParams = NULL;
		}
		if (r->in.ppOutParams) {
			_mem_save_ppOutParams_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.ppOutParams, 0);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppOutParams));
			if (_ptr_ppOutParams) {
				NDR_PULL_ALLOC(ndr, *r->in.ppOutParams);
			} else {
				*r->in.ppOutParams = NULL;
			}
			if (*r->in.ppOutParams) {
				_mem_save_ppOutParams_1 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, *r->in.ppOutParams, 0);
				NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->in.ppOutParams));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppOutParams_1, 0);
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppOutParams_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppCallResult));
		if (_ptr_ppCallResult) {
			NDR_PULL_ALLOC(ndr, r->in.ppCallResult);
		} else {
			r->in.ppCallResult = NULL;
		}
		if (r->in.ppCallResult) {
			_mem_save_ppCallResult_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.ppCallResult, 0);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppCallResult));
			if (_ptr_ppCallResult) {
				NDR_PULL_ALLOC(ndr, *r->in.ppCallResult);
			} else {
				*r->in.ppCallResult = NULL;
			}
			if (*r->in.ppCallResult) {
				_mem_save_ppCallResult_1 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, *r->in.ppCallResult, 0);
				NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->in.ppCallResult));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppCallResult_1, 0);
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppCallResult_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppOutParams));
		if (_ptr_ppOutParams) {
			NDR_PULL_ALLOC(ndr, r->out.ppOutParams);
		} else {
			r->out.ppOutParams = NULL;
		}
		if (r->out.ppOutParams) {
			_mem_save_ppOutParams_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.ppOutParams, 0);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppOutParams));
			if (_ptr_ppOutParams) {
				NDR_PULL_ALLOC(ndr, *r->out.ppOutParams);
			} else {
				*r->out.ppOutParams = NULL;
			}
			if (*r->out.ppOutParams) {
				_mem_save_ppOutParams_1 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, *r->out.ppOutParams, 0);
				NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppOutParams));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppOutParams_1, 0);
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppOutParams_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppCallResult));
		if (_ptr_ppCallResult) {
			NDR_PULL_ALLOC(ndr, r->out.ppCallResult);
		} else {
			r->out.ppCallResult = NULL;
		}
		if (r->out.ppCallResult) {
			_mem_save_ppCallResult_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.ppCallResult, 0);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppCallResult));
			if (_ptr_ppCallResult) {
				NDR_PULL_ALLOC(ndr, *r->out.ppCallResult);
			} else {
				*r->out.ppCallResult = NULL;
			}
			if (*r->out.ppCallResult) {
				_mem_save_ppCallResult_1 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, *r->out.ppCallResult, 0);
				NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppCallResult));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppCallResult_1, 0);
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppCallResult_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_ExecMethod(struct ndr_print *ndr, const char *name, int flags, const struct ExecMethod *r)
{
	ndr_print_struct(ndr, name, "ExecMethod");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "ExecMethod");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_BSTR(ndr, "strObjectPath", &r->in.strObjectPath);
		ndr_print_BSTR(ndr, "strMethodName", &r->in.strMethodName);
		ndr_print_int32(ndr, "lFlags", r->in.lFlags);
		ndr_print_ptr(ndr, "pCtx", r->in.pCtx);
		ndr->depth++;
		if (r->in.pCtx) {
			ndr_print_MInterfacePointer(ndr, "pCtx", r->in.pCtx);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pInParams", r->in.pInParams);
		ndr->depth++;
		if (r->in.pInParams) {
			ndr_print_MInterfacePointer(ndr, "pInParams", r->in.pInParams);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "ppOutParams", r->in.ppOutParams);
		ndr->depth++;
		if (r->in.ppOutParams) {
			ndr_print_ptr(ndr, "ppOutParams", *r->in.ppOutParams);
			ndr->depth++;
			if (*r->in.ppOutParams) {
				ndr_print_MInterfacePointer(ndr, "ppOutParams", *r->in.ppOutParams);
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "ppCallResult", r->in.ppCallResult);
		ndr->depth++;
		if (r->in.ppCallResult) {
			ndr_print_ptr(ndr, "ppCallResult", *r->in.ppCallResult);
			ndr->depth++;
			if (*r->in.ppCallResult) {
				ndr_print_MInterfacePointer(ndr, "ppCallResult", *r->in.ppCallResult);
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "ExecMethod");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_ptr(ndr, "ppOutParams", r->out.ppOutParams);
		ndr->depth++;
		if (r->out.ppOutParams) {
			ndr_print_ptr(ndr, "ppOutParams", *r->out.ppOutParams);
			ndr->depth++;
			if (*r->out.ppOutParams) {
				ndr_print_MInterfacePointer(ndr, "ppOutParams", *r->out.ppOutParams);
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "ppCallResult", r->out.ppCallResult);
		ndr->depth++;
		if (r->out.ppCallResult) {
			ndr_print_ptr(ndr, "ppCallResult", *r->out.ppCallResult);
			ndr->depth++;
			if (*r->out.ppCallResult) {
				ndr_print_MInterfacePointer(ndr, "ppCallResult", *r->out.ppCallResult);
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_ExecMethodAsync(struct ndr_push *ndr, int flags, const struct ExecMethodAsync *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_push_BSTR(ndr, NDR_SCALARS, &r->in.strObjectPath));
		NDR_CHECK(ndr_push_BSTR(ndr, NDR_SCALARS, &r->in.strMethodName));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.lFlags));
		if (r->in.pCtx == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pCtx));
		if (r->in.pInParams == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pInParams));
		if (r->in.pResponseHandler == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pResponseHandler));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_ExecMethodAsync(struct ndr_pull *ndr, int flags, struct ExecMethodAsync *r)
{
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_pCtx_0;
	TALLOC_CTX *_mem_save_pInParams_0;
	TALLOC_CTX *_mem_save_pResponseHandler_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_pull_BSTR(ndr, NDR_SCALARS, &r->in.strObjectPath));
		NDR_CHECK(ndr_pull_BSTR(ndr, NDR_SCALARS, &r->in.strMethodName));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.lFlags));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pCtx);
		}
		_mem_save_pCtx_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pCtx, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pCtx));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pCtx_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pInParams);
		}
		_mem_save_pInParams_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pInParams, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pInParams));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pInParams_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pResponseHandler);
		}
		_mem_save_pResponseHandler_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pResponseHandler, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pResponseHandler));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pResponseHandler_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_ExecMethodAsync(struct ndr_print *ndr, const char *name, int flags, const struct ExecMethodAsync *r)
{
	ndr_print_struct(ndr, name, "ExecMethodAsync");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "ExecMethodAsync");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_BSTR(ndr, "strObjectPath", &r->in.strObjectPath);
		ndr_print_BSTR(ndr, "strMethodName", &r->in.strMethodName);
		ndr_print_uint32(ndr, "lFlags", r->in.lFlags);
		ndr_print_ptr(ndr, "pCtx", r->in.pCtx);
		ndr->depth++;
		ndr_print_MInterfacePointer(ndr, "pCtx", r->in.pCtx);
		ndr->depth--;
		ndr_print_ptr(ndr, "pInParams", r->in.pInParams);
		ndr->depth++;
		ndr_print_MInterfacePointer(ndr, "pInParams", r->in.pInParams);
		ndr->depth--;
		ndr_print_ptr(ndr, "pResponseHandler", r->in.pResponseHandler);
		ndr->depth++;
		ndr_print_MInterfacePointer(ndr, "pResponseHandler", r->in.pResponseHandler);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "ExecMethodAsync");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct ndr_interface_call IWbemServices_calls[] = {
	{
		"OpenNamespace",
		sizeof(struct OpenNamespace),
		(ndr_push_flags_fn_t) ndr_push_OpenNamespace,
		(ndr_pull_flags_fn_t) ndr_pull_OpenNamespace,
		(ndr_print_function_t) ndr_print_OpenNamespace,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"CancelAsyncCall",
		sizeof(struct CancelAsyncCall),
		(ndr_push_flags_fn_t) ndr_push_CancelAsyncCall,
		(ndr_pull_flags_fn_t) ndr_pull_CancelAsyncCall,
		(ndr_print_function_t) ndr_print_CancelAsyncCall,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"QueryObjectSink",
		sizeof(struct QueryObjectSink),
		(ndr_push_flags_fn_t) ndr_push_QueryObjectSink,
		(ndr_pull_flags_fn_t) ndr_pull_QueryObjectSink,
		(ndr_print_function_t) ndr_print_QueryObjectSink,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"GetObject",
		sizeof(struct GetObject),
		(ndr_push_flags_fn_t) ndr_push_GetObject,
		(ndr_pull_flags_fn_t) ndr_pull_GetObject,
		(ndr_print_function_t) ndr_print_GetObject,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"GetObjectAsync",
		sizeof(struct GetObjectAsync),
		(ndr_push_flags_fn_t) ndr_push_GetObjectAsync,
		(ndr_pull_flags_fn_t) ndr_pull_GetObjectAsync,
		(ndr_print_function_t) ndr_print_GetObjectAsync,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PutClass",
		sizeof(struct PutClass),
		(ndr_push_flags_fn_t) ndr_push_PutClass,
		(ndr_pull_flags_fn_t) ndr_pull_PutClass,
		(ndr_print_function_t) ndr_print_PutClass,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PutClassAsync",
		sizeof(struct PutClassAsync),
		(ndr_push_flags_fn_t) ndr_push_PutClassAsync,
		(ndr_pull_flags_fn_t) ndr_pull_PutClassAsync,
		(ndr_print_function_t) ndr_print_PutClassAsync,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"DeleteClass",
		sizeof(struct DeleteClass),
		(ndr_push_flags_fn_t) ndr_push_DeleteClass,
		(ndr_pull_flags_fn_t) ndr_pull_DeleteClass,
		(ndr_print_function_t) ndr_print_DeleteClass,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"DeleteClassAsync",
		sizeof(struct DeleteClassAsync),
		(ndr_push_flags_fn_t) ndr_push_DeleteClassAsync,
		(ndr_pull_flags_fn_t) ndr_pull_DeleteClassAsync,
		(ndr_print_function_t) ndr_print_DeleteClassAsync,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"CreateClassEnum",
		sizeof(struct CreateClassEnum),
		(ndr_push_flags_fn_t) ndr_push_CreateClassEnum,
		(ndr_pull_flags_fn_t) ndr_pull_CreateClassEnum,
		(ndr_print_function_t) ndr_print_CreateClassEnum,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"CreateClassEnumAsync",
		sizeof(struct CreateClassEnumAsync),
		(ndr_push_flags_fn_t) ndr_push_CreateClassEnumAsync,
		(ndr_pull_flags_fn_t) ndr_pull_CreateClassEnumAsync,
		(ndr_print_function_t) ndr_print_CreateClassEnumAsync,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PutInstance",
		sizeof(struct PutInstance),
		(ndr_push_flags_fn_t) ndr_push_PutInstance,
		(ndr_pull_flags_fn_t) ndr_pull_PutInstance,
		(ndr_print_function_t) ndr_print_PutInstance,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PutInstanceAsync",
		sizeof(struct PutInstanceAsync),
		(ndr_push_flags_fn_t) ndr_push_PutInstanceAsync,
		(ndr_pull_flags_fn_t) ndr_pull_PutInstanceAsync,
		(ndr_print_function_t) ndr_print_PutInstanceAsync,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"DeleteInstance",
		sizeof(struct DeleteInstance),
		(ndr_push_flags_fn_t) ndr_push_DeleteInstance,
		(ndr_pull_flags_fn_t) ndr_pull_DeleteInstance,
		(ndr_print_function_t) ndr_print_DeleteInstance,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"DeleteInstanceAsync",
		sizeof(struct DeleteInstanceAsync),
		(ndr_push_flags_fn_t) ndr_push_DeleteInstanceAsync,
		(ndr_pull_flags_fn_t) ndr_pull_DeleteInstanceAsync,
		(ndr_print_function_t) ndr_print_DeleteInstanceAsync,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"CreateInstanceEnum",
		sizeof(struct CreateInstanceEnum),
		(ndr_push_flags_fn_t) ndr_push_CreateInstanceEnum,
		(ndr_pull_flags_fn_t) ndr_pull_CreateInstanceEnum,
		(ndr_print_function_t) ndr_print_CreateInstanceEnum,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"CreateInstanceEnumAsync",
		sizeof(struct CreateInstanceEnumAsync),
		(ndr_push_flags_fn_t) ndr_push_CreateInstanceEnumAsync,
		(ndr_pull_flags_fn_t) ndr_pull_CreateInstanceEnumAsync,
		(ndr_print_function_t) ndr_print_CreateInstanceEnumAsync,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"ExecQuery",
		sizeof(struct ExecQuery),
		(ndr_push_flags_fn_t) ndr_push_ExecQuery,
		(ndr_pull_flags_fn_t) ndr_pull_ExecQuery,
		(ndr_print_function_t) ndr_print_ExecQuery,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"ExecQueryAsync",
		sizeof(struct ExecQueryAsync),
		(ndr_push_flags_fn_t) ndr_push_ExecQueryAsync,
		(ndr_pull_flags_fn_t) ndr_pull_ExecQueryAsync,
		(ndr_print_function_t) ndr_print_ExecQueryAsync,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"ExecNotificationQuery",
		sizeof(struct ExecNotificationQuery),
		(ndr_push_flags_fn_t) ndr_push_ExecNotificationQuery,
		(ndr_pull_flags_fn_t) ndr_pull_ExecNotificationQuery,
		(ndr_print_function_t) ndr_print_ExecNotificationQuery,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"ExecNotificationQueryAsync",
		sizeof(struct ExecNotificationQueryAsync),
		(ndr_push_flags_fn_t) ndr_push_ExecNotificationQueryAsync,
		(ndr_pull_flags_fn_t) ndr_pull_ExecNotificationQueryAsync,
		(ndr_print_function_t) ndr_print_ExecNotificationQueryAsync,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"ExecMethod",
		sizeof(struct ExecMethod),
		(ndr_push_flags_fn_t) ndr_push_ExecMethod,
		(ndr_pull_flags_fn_t) ndr_pull_ExecMethod,
		(ndr_print_function_t) ndr_print_ExecMethod,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"ExecMethodAsync",
		sizeof(struct ExecMethodAsync),
		(ndr_push_flags_fn_t) ndr_push_ExecMethodAsync,
		(ndr_pull_flags_fn_t) ndr_pull_ExecMethodAsync,
		(ndr_print_function_t) ndr_print_ExecMethodAsync,
		{ 0, NULL },
		{ 0, NULL },
	},
	{ NULL, 0, NULL, NULL, NULL }
};

static const char * const IWbemServices_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\IWbemServices]", 
};

static const struct ndr_interface_string_array IWbemServices_endpoints = {
	.count	= 1,
	.names	= IWbemServices_endpoint_strings
};

static const char * const IWbemServices_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array IWbemServices_authservices = {
	.count	= 1,
	.names	= IWbemServices_authservice_strings
};


const struct ndr_interface_table ndr_table_IWbemServices = {
	.name		= "IWbemServices",
	.syntax_id	= {
		{0x9556dc99,0x828c,0x11cf,{0xa3,0x7e},{0x00,0xaa,0x00,0x32,0x40,0xc7}},
		NDR_IWBEMSERVICES_VERSION
	},
	.helpstring	= NDR_IWBEMSERVICES_HELPSTRING,
	.num_calls	= 23,
	.calls		= IWbemServices_calls,
	.endpoints	= &IWbemServices_endpoints,
	.authservices	= &IWbemServices_authservices
};

#include "librpc/gen_ndr/ndr_orpc.h"
static enum ndr_err_code ndr_push_Reset(struct ndr_push *ndr, int flags, const struct Reset *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_Reset(struct ndr_pull *ndr, int flags, struct Reset *r)
{
	TALLOC_CTX *_mem_save_ORPCthat_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_Reset(struct ndr_print *ndr, const char *name, int flags, const struct Reset *r)
{
	ndr_print_struct(ndr, name, "Reset");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "Reset");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "Reset");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_IEnumWbemClassObject_Next(struct ndr_push *ndr, int flags, const struct IEnumWbemClassObject_Next *r)
{
	uint32_t cntr_apObjects_1;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->in.lTimeout));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.uCount));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		if (r->out.apObjects == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.uCount));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.puReturned));
		for (cntr_apObjects_1 = 0; cntr_apObjects_1 < *r->out.puReturned; cntr_apObjects_1++) {
			NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.apObjects[cntr_apObjects_1]));
		}
		for (cntr_apObjects_1 = 0; cntr_apObjects_1 < *r->out.puReturned; cntr_apObjects_1++) {
			if (r->out.apObjects[cntr_apObjects_1]) {
				NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.apObjects[cntr_apObjects_1]));
			}
		}
		if (r->out.puReturned == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.puReturned));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_IEnumWbemClassObject_Next(struct ndr_pull *ndr, int flags, struct IEnumWbemClassObject_Next *r)
{
	uint32_t _ptr_apObjects;
	uint32_t cntr_apObjects_1;
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_apObjects_1;
	TALLOC_CTX *_mem_save_apObjects_2;
	TALLOC_CTX *_mem_save_puReturned_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->in.lTimeout));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.uCount));
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
		NDR_PULL_ALLOC_N(ndr, r->out.apObjects, r->in.uCount);
		memset(r->out.apObjects, 0, (r->in.uCount) * sizeof(*r->out.apObjects));
		NDR_PULL_ALLOC(ndr, r->out.puReturned);
		ZERO_STRUCTP(r->out.puReturned);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.apObjects));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->out.apObjects));
		if (ndr_get_array_length(ndr, &r->out.apObjects) > ndr_get_array_size(ndr, &r->out.apObjects)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->out.apObjects), ndr_get_array_length(ndr, &r->out.apObjects));
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.apObjects, ndr_get_array_size(ndr, &r->out.apObjects));
		}
		_mem_save_apObjects_1 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.apObjects, 0);
		for (cntr_apObjects_1 = 0; cntr_apObjects_1 < ndr_get_array_length(ndr, &r->out.apObjects); cntr_apObjects_1++) {
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_apObjects));
			if (_ptr_apObjects) {
				NDR_PULL_ALLOC(ndr, r->out.apObjects[cntr_apObjects_1]);
			} else {
				r->out.apObjects[cntr_apObjects_1] = NULL;
			}
		}
		for (cntr_apObjects_1 = 0; cntr_apObjects_1 < ndr_get_array_length(ndr, &r->out.apObjects); cntr_apObjects_1++) {
			if (r->out.apObjects[cntr_apObjects_1]) {
				_mem_save_apObjects_2 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->out.apObjects[cntr_apObjects_1], 0);
				NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.apObjects[cntr_apObjects_1]));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_apObjects_2, 0);
			}
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_apObjects_1, 0);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.puReturned);
		}
		_mem_save_puReturned_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.puReturned, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.puReturned));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_puReturned_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.apObjects) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->out.apObjects, r->in.uCount));
		}
		if (r->out.apObjects) {
			NDR_CHECK(ndr_check_array_length(ndr, (void*)&r->out.apObjects, *r->out.puReturned));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_IEnumWbemClassObject_Next(struct ndr_print *ndr, const char *name, int flags, const struct IEnumWbemClassObject_Next *r)
{
	uint32_t cntr_apObjects_1;
	ndr_print_struct(ndr, name, "IEnumWbemClassObject_Next");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "IEnumWbemClassObject_Next");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_int32(ndr, "lTimeout", r->in.lTimeout);
		ndr_print_uint32(ndr, "uCount", r->in.uCount);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "IEnumWbemClassObject_Next");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_ptr(ndr, "apObjects", r->out.apObjects);
		ndr->depth++;
		ndr->print(ndr, "%s: ARRAY(%d)", "apObjects", (int)*r->out.puReturned);
		ndr->depth++;
		for (cntr_apObjects_1=0;cntr_apObjects_1<*r->out.puReturned;cntr_apObjects_1++) {
			ndr_print_ptr(ndr, "apObjects", r->out.apObjects[cntr_apObjects_1]);
			ndr->depth++;
			if (r->out.apObjects[cntr_apObjects_1]) {
				ndr_print_MInterfacePointer(ndr, "apObjects", r->out.apObjects[cntr_apObjects_1]);
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "puReturned", r->out.puReturned);
		ndr->depth++;
		ndr_print_uint32(ndr, "puReturned", *r->out.puReturned);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_NextAsync(struct ndr_push *ndr, int flags, const struct NextAsync *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.uCount));
		if (r->in.pSink == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pSink));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_NextAsync(struct ndr_pull *ndr, int flags, struct NextAsync *r)
{
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_pSink_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.uCount));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pSink);
		}
		_mem_save_pSink_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pSink, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pSink));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pSink_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_NextAsync(struct ndr_print *ndr, const char *name, int flags, const struct NextAsync *r)
{
	ndr_print_struct(ndr, name, "NextAsync");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NextAsync");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_uint32(ndr, "uCount", r->in.uCount);
		ndr_print_ptr(ndr, "pSink", r->in.pSink);
		ndr->depth++;
		ndr_print_MInterfacePointer(ndr, "pSink", r->in.pSink);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NextAsync");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_IEnumWbemClassObject_Clone(struct ndr_push *ndr, int flags, const struct IEnumWbemClassObject_Clone *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		if (r->out.ppEnum == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.ppEnum));
		if (*r->out.ppEnum) {
			NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppEnum));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_IEnumWbemClassObject_Clone(struct ndr_pull *ndr, int flags, struct IEnumWbemClassObject_Clone *r)
{
	uint32_t _ptr_ppEnum;
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_ppEnum_0;
	TALLOC_CTX *_mem_save_ppEnum_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
		NDR_PULL_ALLOC(ndr, r->out.ppEnum);
		ZERO_STRUCTP(r->out.ppEnum);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ppEnum);
		}
		_mem_save_ppEnum_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ppEnum, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppEnum));
		if (_ptr_ppEnum) {
			NDR_PULL_ALLOC(ndr, *r->out.ppEnum);
		} else {
			*r->out.ppEnum = NULL;
		}
		if (*r->out.ppEnum) {
			_mem_save_ppEnum_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.ppEnum, 0);
			NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppEnum));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppEnum_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppEnum_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_IEnumWbemClassObject_Clone(struct ndr_print *ndr, const char *name, int flags, const struct IEnumWbemClassObject_Clone *r)
{
	ndr_print_struct(ndr, name, "IEnumWbemClassObject_Clone");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "IEnumWbemClassObject_Clone");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "IEnumWbemClassObject_Clone");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_ptr(ndr, "ppEnum", r->out.ppEnum);
		ndr->depth++;
		ndr_print_ptr(ndr, "ppEnum", *r->out.ppEnum);
		ndr->depth++;
		if (*r->out.ppEnum) {
			ndr_print_MInterfacePointer(ndr, "ppEnum", *r->out.ppEnum);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_Skip(struct ndr_push *ndr, int flags, const struct Skip *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->in.lTimeout));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.nCount));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_Skip(struct ndr_pull *ndr, int flags, struct Skip *r)
{
	TALLOC_CTX *_mem_save_ORPCthat_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->in.lTimeout));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.nCount));
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_Skip(struct ndr_print *ndr, const char *name, int flags, const struct Skip *r)
{
	ndr_print_struct(ndr, name, "Skip");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "Skip");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_int32(ndr, "lTimeout", r->in.lTimeout);
		ndr_print_uint32(ndr, "nCount", r->in.nCount);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "Skip");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct ndr_interface_call IEnumWbemClassObject_calls[] = {
	{
		"Reset",
		sizeof(struct Reset),
		(ndr_push_flags_fn_t) ndr_push_Reset,
		(ndr_pull_flags_fn_t) ndr_pull_Reset,
		(ndr_print_function_t) ndr_print_Reset,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"IEnumWbemClassObject_Next",
		sizeof(struct IEnumWbemClassObject_Next),
		(ndr_push_flags_fn_t) ndr_push_IEnumWbemClassObject_Next,
		(ndr_pull_flags_fn_t) ndr_pull_IEnumWbemClassObject_Next,
		(ndr_print_function_t) ndr_print_IEnumWbemClassObject_Next,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"NextAsync",
		sizeof(struct NextAsync),
		(ndr_push_flags_fn_t) ndr_push_NextAsync,
		(ndr_pull_flags_fn_t) ndr_pull_NextAsync,
		(ndr_print_function_t) ndr_print_NextAsync,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"IEnumWbemClassObject_Clone",
		sizeof(struct IEnumWbemClassObject_Clone),
		(ndr_push_flags_fn_t) ndr_push_IEnumWbemClassObject_Clone,
		(ndr_pull_flags_fn_t) ndr_pull_IEnumWbemClassObject_Clone,
		(ndr_print_function_t) ndr_print_IEnumWbemClassObject_Clone,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"Skip",
		sizeof(struct Skip),
		(ndr_push_flags_fn_t) ndr_push_Skip,
		(ndr_pull_flags_fn_t) ndr_pull_Skip,
		(ndr_print_function_t) ndr_print_Skip,
		{ 0, NULL },
		{ 0, NULL },
	},
	{ NULL, 0, NULL, NULL, NULL }
};

static const char * const IEnumWbemClassObject_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\IEnumWbemClassObject]", 
};

static const struct ndr_interface_string_array IEnumWbemClassObject_endpoints = {
	.count	= 1,
	.names	= IEnumWbemClassObject_endpoint_strings
};

static const char * const IEnumWbemClassObject_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array IEnumWbemClassObject_authservices = {
	.count	= 1,
	.names	= IEnumWbemClassObject_authservice_strings
};


const struct ndr_interface_table ndr_table_IEnumWbemClassObject = {
	.name		= "IEnumWbemClassObject",
	.syntax_id	= {
		{0x027947e1,0xd731,0x11ce,{0xa3,0x57},{0x00,0x00,0x00,0x00,0x00,0x01}},
		NDR_IENUMWBEMCLASSOBJECT_VERSION
	},
	.helpstring	= NDR_IENUMWBEMCLASSOBJECT_HELPSTRING,
	.num_calls	= 5,
	.calls		= IEnumWbemClassObject_calls,
	.endpoints	= &IEnumWbemClassObject_endpoints,
	.authservices	= &IEnumWbemClassObject_authservices
};

#include "librpc/gen_ndr/ndr_orpc.h"
static enum ndr_err_code ndr_push_Clone(struct ndr_push *ndr, int flags, const struct Clone *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		if (r->out.ppNewCopy == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.ppNewCopy));
		if (*r->out.ppNewCopy) {
			NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppNewCopy));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_Clone(struct ndr_pull *ndr, int flags, struct Clone *r)
{
	uint32_t _ptr_ppNewCopy;
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_ppNewCopy_0;
	TALLOC_CTX *_mem_save_ppNewCopy_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
		NDR_PULL_ALLOC(ndr, r->out.ppNewCopy);
		ZERO_STRUCTP(r->out.ppNewCopy);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ppNewCopy);
		}
		_mem_save_ppNewCopy_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ppNewCopy, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppNewCopy));
		if (_ptr_ppNewCopy) {
			NDR_PULL_ALLOC(ndr, *r->out.ppNewCopy);
		} else {
			*r->out.ppNewCopy = NULL;
		}
		if (*r->out.ppNewCopy) {
			_mem_save_ppNewCopy_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.ppNewCopy, 0);
			NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppNewCopy));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppNewCopy_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppNewCopy_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_Clone(struct ndr_print *ndr, const char *name, int flags, const struct Clone *r)
{
	ndr_print_struct(ndr, name, "Clone");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "Clone");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "Clone");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_ptr(ndr, "ppNewCopy", r->out.ppNewCopy);
		ndr->depth++;
		ndr_print_ptr(ndr, "ppNewCopy", *r->out.ppNewCopy);
		ndr->depth++;
		if (*r->out.ppNewCopy) {
			ndr_print_MInterfacePointer(ndr, "ppNewCopy", *r->out.ppNewCopy);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_GetNames(struct ndr_push *ndr, int flags, const struct GetNames *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_GetNames(struct ndr_pull *ndr, int flags, struct GetNames *r)
{
	TALLOC_CTX *_mem_save_ORPCthat_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_GetNames(struct ndr_print *ndr, const char *name, int flags, const struct GetNames *r)
{
	ndr_print_struct(ndr, name, "GetNames");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "GetNames");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "GetNames");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_BeginEnumeration(struct ndr_push *ndr, int flags, const struct BeginEnumeration *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->in.lFlags));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_BeginEnumeration(struct ndr_pull *ndr, int flags, struct BeginEnumeration *r)
{
	TALLOC_CTX *_mem_save_ORPCthat_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->in.lFlags));
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_BeginEnumeration(struct ndr_print *ndr, const char *name, int flags, const struct BeginEnumeration *r)
{
	ndr_print_struct(ndr, name, "BeginEnumeration");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "BeginEnumeration");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_int32(ndr, "lFlags", r->in.lFlags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "BeginEnumeration");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_Next(struct ndr_push *ndr, int flags, const struct Next *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_Next(struct ndr_pull *ndr, int flags, struct Next *r)
{
	TALLOC_CTX *_mem_save_ORPCthat_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_Next(struct ndr_print *ndr, const char *name, int flags, const struct Next *r)
{
	ndr_print_struct(ndr, name, "Next");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "Next");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "Next");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_EndEnumeration(struct ndr_push *ndr, int flags, const struct EndEnumeration *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_EndEnumeration(struct ndr_pull *ndr, int flags, struct EndEnumeration *r)
{
	TALLOC_CTX *_mem_save_ORPCthat_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_EndEnumeration(struct ndr_print *ndr, const char *name, int flags, const struct EndEnumeration *r)
{
	ndr_print_struct(ndr, name, "EndEnumeration");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "EndEnumeration");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "EndEnumeration");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_SetValue(struct ndr_push *ndr, int flags, const struct SetValue *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_SetValue(struct ndr_pull *ndr, int flags, struct SetValue *r)
{
	TALLOC_CTX *_mem_save_ORPCthat_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SetValue(struct ndr_print *ndr, const char *name, int flags, const struct SetValue *r)
{
	ndr_print_struct(ndr, name, "SetValue");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "SetValue");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "SetValue");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_GetValue(struct ndr_push *ndr, int flags, const struct GetValue *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_GetValue(struct ndr_pull *ndr, int flags, struct GetValue *r)
{
	TALLOC_CTX *_mem_save_ORPCthat_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_GetValue(struct ndr_print *ndr, const char *name, int flags, const struct GetValue *r)
{
	ndr_print_struct(ndr, name, "GetValue");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "GetValue");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "GetValue");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DeleteValue(struct ndr_push *ndr, int flags, const struct DeleteValue *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DeleteValue(struct ndr_pull *ndr, int flags, struct DeleteValue *r)
{
	TALLOC_CTX *_mem_save_ORPCthat_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DeleteValue(struct ndr_print *ndr, const char *name, int flags, const struct DeleteValue *r)
{
	ndr_print_struct(ndr, name, "DeleteValue");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "DeleteValue");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "DeleteValue");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DeleteAll(struct ndr_push *ndr, int flags, const struct DeleteAll *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DeleteAll(struct ndr_pull *ndr, int flags, struct DeleteAll *r)
{
	TALLOC_CTX *_mem_save_ORPCthat_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DeleteAll(struct ndr_print *ndr, const char *name, int flags, const struct DeleteAll *r)
{
	ndr_print_struct(ndr, name, "DeleteAll");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "DeleteAll");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "DeleteAll");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct ndr_interface_call IWbemContext_calls[] = {
	{
		"Clone",
		sizeof(struct Clone),
		(ndr_push_flags_fn_t) ndr_push_Clone,
		(ndr_pull_flags_fn_t) ndr_pull_Clone,
		(ndr_print_function_t) ndr_print_Clone,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"GetNames",
		sizeof(struct GetNames),
		(ndr_push_flags_fn_t) ndr_push_GetNames,
		(ndr_pull_flags_fn_t) ndr_pull_GetNames,
		(ndr_print_function_t) ndr_print_GetNames,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"BeginEnumeration",
		sizeof(struct BeginEnumeration),
		(ndr_push_flags_fn_t) ndr_push_BeginEnumeration,
		(ndr_pull_flags_fn_t) ndr_pull_BeginEnumeration,
		(ndr_print_function_t) ndr_print_BeginEnumeration,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"Next",
		sizeof(struct Next),
		(ndr_push_flags_fn_t) ndr_push_Next,
		(ndr_pull_flags_fn_t) ndr_pull_Next,
		(ndr_print_function_t) ndr_print_Next,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"EndEnumeration",
		sizeof(struct EndEnumeration),
		(ndr_push_flags_fn_t) ndr_push_EndEnumeration,
		(ndr_pull_flags_fn_t) ndr_pull_EndEnumeration,
		(ndr_print_function_t) ndr_print_EndEnumeration,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"SetValue",
		sizeof(struct SetValue),
		(ndr_push_flags_fn_t) ndr_push_SetValue,
		(ndr_pull_flags_fn_t) ndr_pull_SetValue,
		(ndr_print_function_t) ndr_print_SetValue,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"GetValue",
		sizeof(struct GetValue),
		(ndr_push_flags_fn_t) ndr_push_GetValue,
		(ndr_pull_flags_fn_t) ndr_pull_GetValue,
		(ndr_print_function_t) ndr_print_GetValue,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"DeleteValue",
		sizeof(struct DeleteValue),
		(ndr_push_flags_fn_t) ndr_push_DeleteValue,
		(ndr_pull_flags_fn_t) ndr_pull_DeleteValue,
		(ndr_print_function_t) ndr_print_DeleteValue,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"DeleteAll",
		sizeof(struct DeleteAll),
		(ndr_push_flags_fn_t) ndr_push_DeleteAll,
		(ndr_pull_flags_fn_t) ndr_pull_DeleteAll,
		(ndr_print_function_t) ndr_print_DeleteAll,
		{ 0, NULL },
		{ 0, NULL },
	},
	{ NULL, 0, NULL, NULL, NULL }
};

static const char * const IWbemContext_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\IWbemContext]", 
};

static const struct ndr_interface_string_array IWbemContext_endpoints = {
	.count	= 1,
	.names	= IWbemContext_endpoint_strings
};

static const char * const IWbemContext_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array IWbemContext_authservices = {
	.count	= 1,
	.names	= IWbemContext_authservice_strings
};


const struct ndr_interface_table ndr_table_IWbemContext = {
	.name		= "IWbemContext",
	.syntax_id	= {
		{0x44aca674,0xe8fc,0x11d0,{0xa0,0x7c},{0x00,0xc0,0x4f,0xb6,0x88,0x20}},
		NDR_IWBEMCONTEXT_VERSION
	},
	.helpstring	= NDR_IWBEMCONTEXT_HELPSTRING,
	.num_calls	= 9,
	.calls		= IWbemContext_calls,
	.endpoints	= &IWbemContext_endpoints,
	.authservices	= &IWbemContext_authservices
};

#include "librpc/gen_ndr/ndr_orpc.h"
static enum ndr_err_code ndr_push_EstablishPosition(struct ndr_push *ndr, int flags, const struct EstablishPosition *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.wszLocaleList));
		if (r->in.wszLocaleList) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.wszLocaleList, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.wszLocaleList, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.wszLocaleList, ndr_charset_length(r->in.wszLocaleList, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwNumLocales));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		if (r->out.reserved == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.reserved));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_EstablishPosition(struct ndr_pull *ndr, int flags, struct EstablishPosition *r)
{
	uint32_t _ptr_wszLocaleList;
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_wszLocaleList_0;
	TALLOC_CTX *_mem_save_reserved_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_wszLocaleList));
		if (_ptr_wszLocaleList) {
			NDR_PULL_ALLOC(ndr, r->in.wszLocaleList);
		} else {
			r->in.wszLocaleList = NULL;
		}
		if (r->in.wszLocaleList) {
			_mem_save_wszLocaleList_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.wszLocaleList, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.wszLocaleList));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.wszLocaleList));
			if (ndr_get_array_length(ndr, &r->in.wszLocaleList) > ndr_get_array_size(ndr, &r->in.wszLocaleList)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.wszLocaleList), ndr_get_array_length(ndr, &r->in.wszLocaleList));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.wszLocaleList), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.wszLocaleList, ndr_get_array_length(ndr, &r->in.wszLocaleList), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_wszLocaleList_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwNumLocales));
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
		NDR_PULL_ALLOC(ndr, r->out.reserved);
		ZERO_STRUCTP(r->out.reserved);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.reserved);
		}
		_mem_save_reserved_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.reserved, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.reserved));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_reserved_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_EstablishPosition(struct ndr_print *ndr, const char *name, int flags, const struct EstablishPosition *r)
{
	ndr_print_struct(ndr, name, "EstablishPosition");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "EstablishPosition");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_ptr(ndr, "wszLocaleList", r->in.wszLocaleList);
		ndr->depth++;
		if (r->in.wszLocaleList) {
			ndr_print_string(ndr, "wszLocaleList", r->in.wszLocaleList);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "dwNumLocales", r->in.dwNumLocales);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "EstablishPosition");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_ptr(ndr, "reserved", r->out.reserved);
		ndr->depth++;
		ndr_print_uint32(ndr, "reserved", *r->out.reserved);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_RequestChallenge(struct ndr_push *ndr, int flags, const struct RequestChallenge *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.wszNetworkResource));
		if (r->in.wszNetworkResource) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.wszNetworkResource, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.wszNetworkResource, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.wszNetworkResource, ndr_charset_length(r->in.wszNetworkResource, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.wszUser));
		if (r->in.wszUser) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.wszUser, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.wszUser, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.wszUser, ndr_charset_length(r->in.wszUser, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		if (r->out.Nonce == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 16));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 16));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.Nonce, 16));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_RequestChallenge(struct ndr_pull *ndr, int flags, struct RequestChallenge *r)
{
	uint32_t _ptr_wszNetworkResource;
	uint32_t _ptr_wszUser;
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_wszNetworkResource_0;
	TALLOC_CTX *_mem_save_wszUser_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_wszNetworkResource));
		if (_ptr_wszNetworkResource) {
			NDR_PULL_ALLOC(ndr, r->in.wszNetworkResource);
		} else {
			r->in.wszNetworkResource = NULL;
		}
		if (r->in.wszNetworkResource) {
			_mem_save_wszNetworkResource_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.wszNetworkResource, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.wszNetworkResource));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.wszNetworkResource));
			if (ndr_get_array_length(ndr, &r->in.wszNetworkResource) > ndr_get_array_size(ndr, &r->in.wszNetworkResource)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.wszNetworkResource), ndr_get_array_length(ndr, &r->in.wszNetworkResource));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.wszNetworkResource), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.wszNetworkResource, ndr_get_array_length(ndr, &r->in.wszNetworkResource), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_wszNetworkResource_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_wszUser));
		if (_ptr_wszUser) {
			NDR_PULL_ALLOC(ndr, r->in.wszUser);
		} else {
			r->in.wszUser = NULL;
		}
		if (r->in.wszUser) {
			_mem_save_wszUser_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.wszUser, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.wszUser));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.wszUser));
			if (ndr_get_array_length(ndr, &r->in.wszUser) > ndr_get_array_size(ndr, &r->in.wszUser)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.wszUser), ndr_get_array_length(ndr, &r->in.wszUser));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.wszUser), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.wszUser, ndr_get_array_length(ndr, &r->in.wszUser), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_wszUser_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
		NDR_PULL_ALLOC_N(ndr, r->out.Nonce, 16);
		memset(r->out.Nonce, 0, (16) * sizeof(*r->out.Nonce));
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.Nonce));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->out.Nonce));
		if (ndr_get_array_length(ndr, &r->out.Nonce) > ndr_get_array_size(ndr, &r->out.Nonce)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->out.Nonce), ndr_get_array_length(ndr, &r->out.Nonce));
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.Nonce, ndr_get_array_size(ndr, &r->out.Nonce));
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.Nonce, ndr_get_array_length(ndr, &r->out.Nonce)));
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.Nonce) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->out.Nonce, 16));
		}
		if (r->out.Nonce) {
			NDR_CHECK(ndr_check_array_length(ndr, (void*)&r->out.Nonce, 16));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_RequestChallenge(struct ndr_print *ndr, const char *name, int flags, const struct RequestChallenge *r)
{
	ndr_print_struct(ndr, name, "RequestChallenge");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "RequestChallenge");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_ptr(ndr, "wszNetworkResource", r->in.wszNetworkResource);
		ndr->depth++;
		if (r->in.wszNetworkResource) {
			ndr_print_string(ndr, "wszNetworkResource", r->in.wszNetworkResource);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "wszUser", r->in.wszUser);
		ndr->depth++;
		if (r->in.wszUser) {
			ndr_print_string(ndr, "wszUser", r->in.wszUser);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "RequestChallenge");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_ptr(ndr, "Nonce", r->out.Nonce);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "Nonce", r->out.Nonce, 16);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_WBEMLogin(struct ndr_push *ndr, int flags, const struct WBEMLogin *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.wszPreferredLocale));
		if (r->in.wszPreferredLocale) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.wszPreferredLocale, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.wszPreferredLocale, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.wszPreferredLocale, ndr_charset_length(r->in.wszPreferredLocale, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.AccessToken));
		if (r->in.AccessToken) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 16));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 16));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.AccessToken, 16));
		}
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->in.lFlags));
		if (r->in.pCtx == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pCtx));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		if (r->out.ppNamespace == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.ppNamespace));
		if (*r->out.ppNamespace) {
			NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppNamespace));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_WBEMLogin(struct ndr_pull *ndr, int flags, struct WBEMLogin *r)
{
	uint32_t _ptr_wszPreferredLocale;
	uint32_t _ptr_AccessToken;
	uint32_t _ptr_ppNamespace;
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_wszPreferredLocale_0;
	TALLOC_CTX *_mem_save_AccessToken_0;
	TALLOC_CTX *_mem_save_pCtx_0;
	TALLOC_CTX *_mem_save_ppNamespace_0;
	TALLOC_CTX *_mem_save_ppNamespace_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_wszPreferredLocale));
		if (_ptr_wszPreferredLocale) {
			NDR_PULL_ALLOC(ndr, r->in.wszPreferredLocale);
		} else {
			r->in.wszPreferredLocale = NULL;
		}
		if (r->in.wszPreferredLocale) {
			_mem_save_wszPreferredLocale_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.wszPreferredLocale, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.wszPreferredLocale));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.wszPreferredLocale));
			if (ndr_get_array_length(ndr, &r->in.wszPreferredLocale) > ndr_get_array_size(ndr, &r->in.wszPreferredLocale)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.wszPreferredLocale), ndr_get_array_length(ndr, &r->in.wszPreferredLocale));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.wszPreferredLocale), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.wszPreferredLocale, ndr_get_array_length(ndr, &r->in.wszPreferredLocale), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_wszPreferredLocale_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_AccessToken));
		if (_ptr_AccessToken) {
			NDR_PULL_ALLOC(ndr, r->in.AccessToken);
		} else {
			r->in.AccessToken = NULL;
		}
		if (r->in.AccessToken) {
			_mem_save_AccessToken_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.AccessToken, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.AccessToken));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.AccessToken));
			if (ndr_get_array_length(ndr, &r->in.AccessToken) > ndr_get_array_size(ndr, &r->in.AccessToken)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.AccessToken), ndr_get_array_length(ndr, &r->in.AccessToken));
			}
			NDR_PULL_ALLOC_N(ndr, r->in.AccessToken, ndr_get_array_size(ndr, &r->in.AccessToken));
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.AccessToken, ndr_get_array_length(ndr, &r->in.AccessToken)));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_AccessToken_0, 0);
		}
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->in.lFlags));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pCtx);
		}
		_mem_save_pCtx_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pCtx, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pCtx));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pCtx_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
		NDR_PULL_ALLOC(ndr, r->out.ppNamespace);
		ZERO_STRUCTP(r->out.ppNamespace);
		if (r->in.AccessToken) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->in.AccessToken, 16));
		}
		if (r->in.AccessToken) {
			NDR_CHECK(ndr_check_array_length(ndr, (void*)&r->in.AccessToken, 16));
		}
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ppNamespace);
		}
		_mem_save_ppNamespace_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ppNamespace, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppNamespace));
		if (_ptr_ppNamespace) {
			NDR_PULL_ALLOC(ndr, *r->out.ppNamespace);
		} else {
			*r->out.ppNamespace = NULL;
		}
		if (*r->out.ppNamespace) {
			_mem_save_ppNamespace_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.ppNamespace, 0);
			NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppNamespace));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppNamespace_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppNamespace_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_WBEMLogin(struct ndr_print *ndr, const char *name, int flags, const struct WBEMLogin *r)
{
	ndr_print_struct(ndr, name, "WBEMLogin");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "WBEMLogin");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_ptr(ndr, "wszPreferredLocale", r->in.wszPreferredLocale);
		ndr->depth++;
		if (r->in.wszPreferredLocale) {
			ndr_print_string(ndr, "wszPreferredLocale", r->in.wszPreferredLocale);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "AccessToken", r->in.AccessToken);
		ndr->depth++;
		if (r->in.AccessToken) {
			ndr_print_array_uint8(ndr, "AccessToken", r->in.AccessToken, 16);
		}
		ndr->depth--;
		ndr_print_int32(ndr, "lFlags", r->in.lFlags);
		ndr_print_ptr(ndr, "pCtx", r->in.pCtx);
		ndr->depth++;
		ndr_print_MInterfacePointer(ndr, "pCtx", r->in.pCtx);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "WBEMLogin");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_ptr(ndr, "ppNamespace", r->out.ppNamespace);
		ndr->depth++;
		ndr_print_ptr(ndr, "ppNamespace", *r->out.ppNamespace);
		ndr->depth++;
		if (*r->out.ppNamespace) {
			ndr_print_MInterfacePointer(ndr, "ppNamespace", *r->out.ppNamespace);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_NTLMLogin(struct ndr_push *ndr, int flags, const struct NTLMLogin *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.wszNetworkResource));
		if (r->in.wszNetworkResource) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.wszNetworkResource, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.wszNetworkResource, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.wszNetworkResource, ndr_charset_length(r->in.wszNetworkResource, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.wszPreferredLocale));
		if (r->in.wszPreferredLocale) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.wszPreferredLocale, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.wszPreferredLocale, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.wszPreferredLocale, ndr_charset_length(r->in.wszPreferredLocale, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->in.lFlags));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pCtx));
		if (r->in.pCtx) {
			NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pCtx));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		if (r->out.ppNamespace == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.ppNamespace));
		if (*r->out.ppNamespace) {
			NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppNamespace));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_NTLMLogin(struct ndr_pull *ndr, int flags, struct NTLMLogin *r)
{
	uint32_t _ptr_wszNetworkResource;
	uint32_t _ptr_wszPreferredLocale;
	uint32_t _ptr_pCtx;
	uint32_t _ptr_ppNamespace;
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_wszNetworkResource_0;
	TALLOC_CTX *_mem_save_wszPreferredLocale_0;
	TALLOC_CTX *_mem_save_pCtx_0;
	TALLOC_CTX *_mem_save_ppNamespace_0;
	TALLOC_CTX *_mem_save_ppNamespace_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_wszNetworkResource));
		if (_ptr_wszNetworkResource) {
			NDR_PULL_ALLOC(ndr, r->in.wszNetworkResource);
		} else {
			r->in.wszNetworkResource = NULL;
		}
		if (r->in.wszNetworkResource) {
			_mem_save_wszNetworkResource_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.wszNetworkResource, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.wszNetworkResource));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.wszNetworkResource));
			if (ndr_get_array_length(ndr, &r->in.wszNetworkResource) > ndr_get_array_size(ndr, &r->in.wszNetworkResource)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.wszNetworkResource), ndr_get_array_length(ndr, &r->in.wszNetworkResource));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.wszNetworkResource), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.wszNetworkResource, ndr_get_array_length(ndr, &r->in.wszNetworkResource), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_wszNetworkResource_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_wszPreferredLocale));
		if (_ptr_wszPreferredLocale) {
			NDR_PULL_ALLOC(ndr, r->in.wszPreferredLocale);
		} else {
			r->in.wszPreferredLocale = NULL;
		}
		if (r->in.wszPreferredLocale) {
			_mem_save_wszPreferredLocale_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.wszPreferredLocale, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.wszPreferredLocale));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.wszPreferredLocale));
			if (ndr_get_array_length(ndr, &r->in.wszPreferredLocale) > ndr_get_array_size(ndr, &r->in.wszPreferredLocale)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.wszPreferredLocale), ndr_get_array_length(ndr, &r->in.wszPreferredLocale));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.wszPreferredLocale), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.wszPreferredLocale, ndr_get_array_length(ndr, &r->in.wszPreferredLocale), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_wszPreferredLocale_0, 0);
		}
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->in.lFlags));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pCtx));
		if (_ptr_pCtx) {
			NDR_PULL_ALLOC(ndr, r->in.pCtx);
		} else {
			r->in.pCtx = NULL;
		}
		if (r->in.pCtx) {
			_mem_save_pCtx_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pCtx, 0);
			NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pCtx));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pCtx_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
		NDR_PULL_ALLOC(ndr, r->out.ppNamespace);
		ZERO_STRUCTP(r->out.ppNamespace);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ppNamespace);
		}
		_mem_save_ppNamespace_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ppNamespace, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppNamespace));
		if (_ptr_ppNamespace) {
			NDR_PULL_ALLOC(ndr, *r->out.ppNamespace);
		} else {
			*r->out.ppNamespace = NULL;
		}
		if (*r->out.ppNamespace) {
			_mem_save_ppNamespace_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.ppNamespace, 0);
			NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppNamespace));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppNamespace_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppNamespace_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_NTLMLogin(struct ndr_print *ndr, const char *name, int flags, const struct NTLMLogin *r)
{
	ndr_print_struct(ndr, name, "NTLMLogin");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NTLMLogin");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_ptr(ndr, "wszNetworkResource", r->in.wszNetworkResource);
		ndr->depth++;
		if (r->in.wszNetworkResource) {
			ndr_print_string(ndr, "wszNetworkResource", r->in.wszNetworkResource);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "wszPreferredLocale", r->in.wszPreferredLocale);
		ndr->depth++;
		if (r->in.wszPreferredLocale) {
			ndr_print_string(ndr, "wszPreferredLocale", r->in.wszPreferredLocale);
		}
		ndr->depth--;
		ndr_print_int32(ndr, "lFlags", r->in.lFlags);
		ndr_print_ptr(ndr, "pCtx", r->in.pCtx);
		ndr->depth++;
		if (r->in.pCtx) {
			ndr_print_MInterfacePointer(ndr, "pCtx", r->in.pCtx);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NTLMLogin");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_ptr(ndr, "ppNamespace", r->out.ppNamespace);
		ndr->depth++;
		ndr_print_ptr(ndr, "ppNamespace", *r->out.ppNamespace);
		ndr->depth++;
		if (*r->out.ppNamespace) {
			ndr_print_MInterfacePointer(ndr, "ppNamespace", *r->out.ppNamespace);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct ndr_interface_call IWbemLevel1Login_calls[] = {
	{
		"EstablishPosition",
		sizeof(struct EstablishPosition),
		(ndr_push_flags_fn_t) ndr_push_EstablishPosition,
		(ndr_pull_flags_fn_t) ndr_pull_EstablishPosition,
		(ndr_print_function_t) ndr_print_EstablishPosition,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"RequestChallenge",
		sizeof(struct RequestChallenge),
		(ndr_push_flags_fn_t) ndr_push_RequestChallenge,
		(ndr_pull_flags_fn_t) ndr_pull_RequestChallenge,
		(ndr_print_function_t) ndr_print_RequestChallenge,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"WBEMLogin",
		sizeof(struct WBEMLogin),
		(ndr_push_flags_fn_t) ndr_push_WBEMLogin,
		(ndr_pull_flags_fn_t) ndr_pull_WBEMLogin,
		(ndr_print_function_t) ndr_print_WBEMLogin,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"NTLMLogin",
		sizeof(struct NTLMLogin),
		(ndr_push_flags_fn_t) ndr_push_NTLMLogin,
		(ndr_pull_flags_fn_t) ndr_pull_NTLMLogin,
		(ndr_print_function_t) ndr_print_NTLMLogin,
		{ 0, NULL },
		{ 0, NULL },
	},
	{ NULL, 0, NULL, NULL, NULL }
};

static const char * const IWbemLevel1Login_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\IWbemLevel1Login]", 
};

static const struct ndr_interface_string_array IWbemLevel1Login_endpoints = {
	.count	= 1,
	.names	= IWbemLevel1Login_endpoint_strings
};

static const char * const IWbemLevel1Login_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array IWbemLevel1Login_authservices = {
	.count	= 1,
	.names	= IWbemLevel1Login_authservice_strings
};


const struct ndr_interface_table ndr_table_IWbemLevel1Login = {
	.name		= "IWbemLevel1Login",
	.syntax_id	= {
		{0xf309ad18,0xd86a,0x11d0,{0xa0,0x75},{0x00,0xc0,0x4f,0xb6,0x88,0x20}},
		NDR_IWBEMLEVEL1LOGIN_VERSION
	},
	.helpstring	= NDR_IWBEMLEVEL1LOGIN_HELPSTRING,
	.num_calls	= 4,
	.calls		= IWbemLevel1Login_calls,
	.endpoints	= &IWbemLevel1Login_endpoints,
	.authservices	= &IWbemLevel1Login_authservices
};

#include "librpc/gen_ndr/ndr_orpc.h"
static enum ndr_err_code ndr_push_IWbemWCOSmartEnum_Next(struct ndr_push *ndr, int flags, const struct IWbemWCOSmartEnum_Next *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		if (r->in.gEWCO == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, r->in.gEWCO));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.lTimeOut));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.uCount));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.unknown));
		if (r->in.gWCO == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, r->in.gWCO));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		if (r->out.puReturned == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.puReturned));
		if (r->out.pSize == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pSize));
		if (r->out.pData == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.pData));
		if (*r->out.pData) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.pSize));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, *r->out.pData, *r->out.pSize));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_IWbemWCOSmartEnum_Next(struct ndr_pull *ndr, int flags, struct IWbemWCOSmartEnum_Next *r)
{
	uint32_t _ptr_pData;
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_gEWCO_0;
	TALLOC_CTX *_mem_save_gWCO_0;
	TALLOC_CTX *_mem_save_puReturned_0;
	TALLOC_CTX *_mem_save_pSize_0;
	TALLOC_CTX *_mem_save_pData_0;
	TALLOC_CTX *_mem_save_pData_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.gEWCO);
		}
		_mem_save_gEWCO_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.gEWCO, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, r->in.gEWCO));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_gEWCO_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.lTimeOut));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.uCount));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.unknown));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.gWCO);
		}
		_mem_save_gWCO_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.gWCO, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, r->in.gWCO));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_gWCO_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
		NDR_PULL_ALLOC(ndr, r->out.puReturned);
		ZERO_STRUCTP(r->out.puReturned);
		NDR_PULL_ALLOC(ndr, r->out.pSize);
		ZERO_STRUCTP(r->out.pSize);
		NDR_PULL_ALLOC(ndr, r->out.pData);
		ZERO_STRUCTP(r->out.pData);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.puReturned);
		}
		_mem_save_puReturned_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.puReturned, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.puReturned));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_puReturned_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pSize);
		}
		_mem_save_pSize_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pSize, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pSize));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pSize_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pData);
		}
		_mem_save_pData_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pData, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pData));
		if (_ptr_pData) {
			NDR_PULL_ALLOC(ndr, *r->out.pData);
		} else {
			*r->out.pData = NULL;
		}
		if (*r->out.pData) {
			_mem_save_pData_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.pData, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.pData));
			NDR_PULL_ALLOC_N(ndr, *r->out.pData, ndr_get_array_size(ndr, r->out.pData));
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, *r->out.pData, ndr_get_array_size(ndr, r->out.pData)));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pData_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pData_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (*r->out.pData) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)r->out.pData, *r->out.pSize));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_IWbemWCOSmartEnum_Next(struct ndr_print *ndr, const char *name, int flags, const struct IWbemWCOSmartEnum_Next *r)
{
	ndr_print_struct(ndr, name, "IWbemWCOSmartEnum_Next");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "IWbemWCOSmartEnum_Next");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_ptr(ndr, "gEWCO", r->in.gEWCO);
		ndr->depth++;
		ndr_print_GUID(ndr, "gEWCO", r->in.gEWCO);
		ndr->depth--;
		ndr_print_uint32(ndr, "lTimeOut", r->in.lTimeOut);
		ndr_print_uint32(ndr, "uCount", r->in.uCount);
		ndr_print_uint32(ndr, "unknown", r->in.unknown);
		ndr_print_ptr(ndr, "gWCO", r->in.gWCO);
		ndr->depth++;
		ndr_print_GUID(ndr, "gWCO", r->in.gWCO);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "IWbemWCOSmartEnum_Next");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_ptr(ndr, "puReturned", r->out.puReturned);
		ndr->depth++;
		ndr_print_uint32(ndr, "puReturned", *r->out.puReturned);
		ndr->depth--;
		ndr_print_ptr(ndr, "pSize", r->out.pSize);
		ndr->depth++;
		ndr_print_uint32(ndr, "pSize", *r->out.pSize);
		ndr->depth--;
		ndr_print_ptr(ndr, "pData", r->out.pData);
		ndr->depth++;
		ndr_print_ptr(ndr, "pData", *r->out.pData);
		ndr->depth++;
		if (*r->out.pData) {
			ndr_print_array_uint8(ndr, "pData", *r->out.pData, *r->out.pSize);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct ndr_interface_call IWbemWCOSmartEnum_calls[] = {
	{
		"IWbemWCOSmartEnum_Next",
		sizeof(struct IWbemWCOSmartEnum_Next),
		(ndr_push_flags_fn_t) ndr_push_IWbemWCOSmartEnum_Next,
		(ndr_pull_flags_fn_t) ndr_pull_IWbemWCOSmartEnum_Next,
		(ndr_print_function_t) ndr_print_IWbemWCOSmartEnum_Next,
		{ 0, NULL },
		{ 0, NULL },
	},
	{ NULL, 0, NULL, NULL, NULL }
};

static const char * const IWbemWCOSmartEnum_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\IWbemWCOSmartEnum]", 
};

static const struct ndr_interface_string_array IWbemWCOSmartEnum_endpoints = {
	.count	= 1,
	.names	= IWbemWCOSmartEnum_endpoint_strings
};

static const char * const IWbemWCOSmartEnum_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array IWbemWCOSmartEnum_authservices = {
	.count	= 1,
	.names	= IWbemWCOSmartEnum_authservice_strings
};


const struct ndr_interface_table ndr_table_IWbemWCOSmartEnum = {
	.name		= "IWbemWCOSmartEnum",
	.syntax_id	= {
		{0x423ec01e,0x2e35,0x11d2,{0xb6,0x04},{0x00,0x10,0x4b,0x70,0x3e,0xfd}},
		NDR_IWBEMWCOSMARTENUM_VERSION
	},
	.helpstring	= NDR_IWBEMWCOSMARTENUM_HELPSTRING,
	.num_calls	= 1,
	.calls		= IWbemWCOSmartEnum_calls,
	.endpoints	= &IWbemWCOSmartEnum_endpoints,
	.authservices	= &IWbemWCOSmartEnum_authservices
};

#include "librpc/gen_ndr/ndr_orpc.h"
static enum ndr_err_code ndr_push_Fetch(struct ndr_push *ndr, int flags, const struct Fetch *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		if (r->out.ppEnum == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.ppEnum));
		if (*r->out.ppEnum) {
			NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppEnum));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_Fetch(struct ndr_pull *ndr, int flags, struct Fetch *r)
{
	uint32_t _ptr_ppEnum;
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_ppEnum_0;
	TALLOC_CTX *_mem_save_ppEnum_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
		NDR_PULL_ALLOC(ndr, r->out.ppEnum);
		ZERO_STRUCTP(r->out.ppEnum);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ppEnum);
		}
		_mem_save_ppEnum_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ppEnum, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppEnum));
		if (_ptr_ppEnum) {
			NDR_PULL_ALLOC(ndr, *r->out.ppEnum);
		} else {
			*r->out.ppEnum = NULL;
		}
		if (*r->out.ppEnum) {
			_mem_save_ppEnum_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.ppEnum, 0);
			NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppEnum));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppEnum_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppEnum_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_Fetch(struct ndr_print *ndr, const char *name, int flags, const struct Fetch *r)
{
	ndr_print_struct(ndr, name, "Fetch");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "Fetch");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "Fetch");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_ptr(ndr, "ppEnum", r->out.ppEnum);
		ndr->depth++;
		ndr_print_ptr(ndr, "ppEnum", *r->out.ppEnum);
		ndr->depth++;
		if (*r->out.ppEnum) {
			ndr_print_MInterfacePointer(ndr, "ppEnum", *r->out.ppEnum);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_Test(struct ndr_push *ndr, int flags, const struct Test *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		if (r->out.ppEnum == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.ppEnum));
		if (*r->out.ppEnum) {
			NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppEnum));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_Test(struct ndr_pull *ndr, int flags, struct Test *r)
{
	uint32_t _ptr_ppEnum;
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_ppEnum_0;
	TALLOC_CTX *_mem_save_ppEnum_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
		NDR_PULL_ALLOC(ndr, r->out.ppEnum);
		ZERO_STRUCTP(r->out.ppEnum);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ppEnum);
		}
		_mem_save_ppEnum_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ppEnum, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppEnum));
		if (_ptr_ppEnum) {
			NDR_PULL_ALLOC(ndr, *r->out.ppEnum);
		} else {
			*r->out.ppEnum = NULL;
		}
		if (*r->out.ppEnum) {
			_mem_save_ppEnum_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.ppEnum, 0);
			NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppEnum));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppEnum_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppEnum_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_Test(struct ndr_print *ndr, const char *name, int flags, const struct Test *r)
{
	ndr_print_struct(ndr, name, "Test");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "Test");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "Test");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_ptr(ndr, "ppEnum", r->out.ppEnum);
		ndr->depth++;
		ndr_print_ptr(ndr, "ppEnum", *r->out.ppEnum);
		ndr->depth++;
		if (*r->out.ppEnum) {
			ndr_print_MInterfacePointer(ndr, "ppEnum", *r->out.ppEnum);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct ndr_interface_call IWbemFetchSmartEnum_calls[] = {
	{
		"Fetch",
		sizeof(struct Fetch),
		(ndr_push_flags_fn_t) ndr_push_Fetch,
		(ndr_pull_flags_fn_t) ndr_pull_Fetch,
		(ndr_print_function_t) ndr_print_Fetch,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"Test",
		sizeof(struct Test),
		(ndr_push_flags_fn_t) ndr_push_Test,
		(ndr_pull_flags_fn_t) ndr_pull_Test,
		(ndr_print_function_t) ndr_print_Test,
		{ 0, NULL },
		{ 0, NULL },
	},
	{ NULL, 0, NULL, NULL, NULL }
};

static const char * const IWbemFetchSmartEnum_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\IWbemFetchSmartEnum]", 
};

static const struct ndr_interface_string_array IWbemFetchSmartEnum_endpoints = {
	.count	= 1,
	.names	= IWbemFetchSmartEnum_endpoint_strings
};

static const char * const IWbemFetchSmartEnum_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array IWbemFetchSmartEnum_authservices = {
	.count	= 1,
	.names	= IWbemFetchSmartEnum_authservice_strings
};


const struct ndr_interface_table ndr_table_IWbemFetchSmartEnum = {
	.name		= "IWbemFetchSmartEnum",
	.syntax_id	= {
		{0x1c1c45ee,0x4395,0x11d2,{0xb6,0x0b},{0x00,0x10,0x4b,0x70,0x3e,0xfd}},
		NDR_IWBEMFETCHSMARTENUM_VERSION
	},
	.helpstring	= NDR_IWBEMFETCHSMARTENUM_HELPSTRING,
	.num_calls	= 2,
	.calls		= IWbemFetchSmartEnum_calls,
	.endpoints	= &IWbemFetchSmartEnum_endpoints,
	.authservices	= &IWbemFetchSmartEnum_authservices
};

#include "librpc/gen_ndr/ndr_orpc.h"
static enum ndr_err_code ndr_push_GetResultObject(struct ndr_push *ndr, int flags, const struct GetResultObject *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->in.lTimeout));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		if (r->out.ppResultObject == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.ppResultObject));
		if (*r->out.ppResultObject) {
			NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppResultObject));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_GetResultObject(struct ndr_pull *ndr, int flags, struct GetResultObject *r)
{
	uint32_t _ptr_ppResultObject;
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_ppResultObject_0;
	TALLOC_CTX *_mem_save_ppResultObject_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->in.lTimeout));
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
		NDR_PULL_ALLOC(ndr, r->out.ppResultObject);
		ZERO_STRUCTP(r->out.ppResultObject);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ppResultObject);
		}
		_mem_save_ppResultObject_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ppResultObject, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppResultObject));
		if (_ptr_ppResultObject) {
			NDR_PULL_ALLOC(ndr, *r->out.ppResultObject);
		} else {
			*r->out.ppResultObject = NULL;
		}
		if (*r->out.ppResultObject) {
			_mem_save_ppResultObject_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.ppResultObject, 0);
			NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppResultObject));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppResultObject_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppResultObject_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_GetResultObject(struct ndr_print *ndr, const char *name, int flags, const struct GetResultObject *r)
{
	ndr_print_struct(ndr, name, "GetResultObject");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "GetResultObject");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_int32(ndr, "lTimeout", r->in.lTimeout);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "GetResultObject");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_ptr(ndr, "ppResultObject", r->out.ppResultObject);
		ndr->depth++;
		ndr_print_ptr(ndr, "ppResultObject", *r->out.ppResultObject);
		ndr->depth++;
		if (*r->out.ppResultObject) {
			ndr_print_MInterfacePointer(ndr, "ppResultObject", *r->out.ppResultObject);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_GetResultString(struct ndr_push *ndr, int flags, const struct GetResultString *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->in.lTimeout));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		if (r->out.pstrResultString == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_BSTR(ndr, NDR_SCALARS, r->out.pstrResultString));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_GetResultString(struct ndr_pull *ndr, int flags, struct GetResultString *r)
{
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_pstrResultString_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->in.lTimeout));
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
		NDR_PULL_ALLOC(ndr, r->out.pstrResultString);
		ZERO_STRUCTP(r->out.pstrResultString);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pstrResultString);
		}
		_mem_save_pstrResultString_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pstrResultString, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_BSTR(ndr, NDR_SCALARS, r->out.pstrResultString));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pstrResultString_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_GetResultString(struct ndr_print *ndr, const char *name, int flags, const struct GetResultString *r)
{
	ndr_print_struct(ndr, name, "GetResultString");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "GetResultString");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_int32(ndr, "lTimeout", r->in.lTimeout);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "GetResultString");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_ptr(ndr, "pstrResultString", r->out.pstrResultString);
		ndr->depth++;
		ndr_print_BSTR(ndr, "pstrResultString", r->out.pstrResultString);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_GetResultServices(struct ndr_push *ndr, int flags, const struct GetResultServices *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->in.lTimeout));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		if (r->out.ppServices == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.ppServices));
		if (*r->out.ppServices) {
			NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppServices));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_GetResultServices(struct ndr_pull *ndr, int flags, struct GetResultServices *r)
{
	uint32_t _ptr_ppServices;
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_ppServices_0;
	TALLOC_CTX *_mem_save_ppServices_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->in.lTimeout));
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
		NDR_PULL_ALLOC(ndr, r->out.ppServices);
		ZERO_STRUCTP(r->out.ppServices);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ppServices);
		}
		_mem_save_ppServices_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ppServices, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppServices));
		if (_ptr_ppServices) {
			NDR_PULL_ALLOC(ndr, *r->out.ppServices);
		} else {
			*r->out.ppServices = NULL;
		}
		if (*r->out.ppServices) {
			_mem_save_ppServices_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.ppServices, 0);
			NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppServices));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppServices_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppServices_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_GetResultServices(struct ndr_print *ndr, const char *name, int flags, const struct GetResultServices *r)
{
	ndr_print_struct(ndr, name, "GetResultServices");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "GetResultServices");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_int32(ndr, "lTimeout", r->in.lTimeout);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "GetResultServices");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_ptr(ndr, "ppServices", r->out.ppServices);
		ndr->depth++;
		ndr_print_ptr(ndr, "ppServices", *r->out.ppServices);
		ndr->depth++;
		if (*r->out.ppServices) {
			ndr_print_MInterfacePointer(ndr, "ppServices", *r->out.ppServices);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_GetCallStatus(struct ndr_push *ndr, int flags, const struct GetCallStatus *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->in.lTimeout));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		if (r->out.plStatus == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, *r->out.plStatus));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_GetCallStatus(struct ndr_pull *ndr, int flags, struct GetCallStatus *r)
{
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_plStatus_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->in.lTimeout));
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
		NDR_PULL_ALLOC(ndr, r->out.plStatus);
		ZERO_STRUCTP(r->out.plStatus);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.plStatus);
		}
		_mem_save_plStatus_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.plStatus, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, r->out.plStatus));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_plStatus_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_GetCallStatus(struct ndr_print *ndr, const char *name, int flags, const struct GetCallStatus *r)
{
	ndr_print_struct(ndr, name, "GetCallStatus");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "GetCallStatus");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_int32(ndr, "lTimeout", r->in.lTimeout);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "GetCallStatus");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_ptr(ndr, "plStatus", r->out.plStatus);
		ndr->depth++;
		ndr_print_int32(ndr, "plStatus", *r->out.plStatus);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct ndr_interface_call IWbemCallResult_calls[] = {
	{
		"GetResultObject",
		sizeof(struct GetResultObject),
		(ndr_push_flags_fn_t) ndr_push_GetResultObject,
		(ndr_pull_flags_fn_t) ndr_pull_GetResultObject,
		(ndr_print_function_t) ndr_print_GetResultObject,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"GetResultString",
		sizeof(struct GetResultString),
		(ndr_push_flags_fn_t) ndr_push_GetResultString,
		(ndr_pull_flags_fn_t) ndr_pull_GetResultString,
		(ndr_print_function_t) ndr_print_GetResultString,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"GetResultServices",
		sizeof(struct GetResultServices),
		(ndr_push_flags_fn_t) ndr_push_GetResultServices,
		(ndr_pull_flags_fn_t) ndr_pull_GetResultServices,
		(ndr_print_function_t) ndr_print_GetResultServices,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"GetCallStatus",
		sizeof(struct GetCallStatus),
		(ndr_push_flags_fn_t) ndr_push_GetCallStatus,
		(ndr_pull_flags_fn_t) ndr_pull_GetCallStatus,
		(ndr_print_function_t) ndr_print_GetCallStatus,
		{ 0, NULL },
		{ 0, NULL },
	},
	{ NULL, 0, NULL, NULL, NULL }
};

static const char * const IWbemCallResult_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\IWbemCallResult]", 
};

static const struct ndr_interface_string_array IWbemCallResult_endpoints = {
	.count	= 1,
	.names	= IWbemCallResult_endpoint_strings
};

static const char * const IWbemCallResult_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array IWbemCallResult_authservices = {
	.count	= 1,
	.names	= IWbemCallResult_authservice_strings
};


const struct ndr_interface_table ndr_table_IWbemCallResult = {
	.name		= "IWbemCallResult",
	.syntax_id	= {
		{0x44aca675,0xe8fc,0x11d0,{0xa0,0x7c},{0x00,0xc0,0x4f,0xb6,0x88,0x20}},
		NDR_IWBEMCALLRESULT_VERSION
	},
	.helpstring	= NDR_IWBEMCALLRESULT_HELPSTRING,
	.num_calls	= 4,
	.calls		= IWbemCallResult_calls,
	.endpoints	= &IWbemCallResult_endpoints,
	.authservices	= &IWbemCallResult_authservices
};

#include "librpc/gen_ndr/ndr_orpc.h"
static enum ndr_err_code ndr_push_SetStatus(struct ndr_push *ndr, int flags, const struct SetStatus *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->in.lFlags));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->in.hResult));
		NDR_CHECK(ndr_push_BSTR(ndr, NDR_SCALARS, &r->in.strParam));
		if (r->in.pObjParam == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pObjParam));
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_SetStatus(struct ndr_pull *ndr, int flags, struct SetStatus *r)
{
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_pObjParam_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->in.lFlags));
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->in.hResult));
		NDR_CHECK(ndr_pull_BSTR(ndr, NDR_SCALARS, &r->in.strParam));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pObjParam);
		}
		_mem_save_pObjParam_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pObjParam, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pObjParam));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pObjParam_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SetStatus(struct ndr_print *ndr, const char *name, int flags, const struct SetStatus *r)
{
	ndr_print_struct(ndr, name, "SetStatus");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "SetStatus");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_int32(ndr, "lFlags", r->in.lFlags);
		ndr_print_WERROR(ndr, "hResult", r->in.hResult);
		ndr_print_BSTR(ndr, "strParam", &r->in.strParam);
		ndr_print_ptr(ndr, "pObjParam", r->in.pObjParam);
		ndr->depth++;
		ndr_print_MInterfacePointer(ndr, "pObjParam", r->in.pObjParam);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "SetStatus");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_Indicate(struct ndr_push *ndr, int flags, const struct Indicate *r)
{
	uint32_t cntr_apObjArray_1;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->in.lObjectCount));
		if (r->in.apObjArray == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.lObjectCount));
		for (cntr_apObjArray_1 = 0; cntr_apObjArray_1 < r->in.lObjectCount; cntr_apObjArray_1++) {
			NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.apObjArray[cntr_apObjArray_1]));
		}
		for (cntr_apObjArray_1 = 0; cntr_apObjArray_1 < r->in.lObjectCount; cntr_apObjArray_1++) {
			if (r->in.apObjArray[cntr_apObjArray_1]) {
				NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.apObjArray[cntr_apObjArray_1]));
			}
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.ORPCthat == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_Indicate(struct ndr_pull *ndr, int flags, struct Indicate *r)
{
	uint32_t _ptr_apObjArray;
	uint32_t cntr_apObjArray_1;
	TALLOC_CTX *_mem_save_ORPCthat_0;
	TALLOC_CTX *_mem_save_apObjArray_1;
	TALLOC_CTX *_mem_save_apObjArray_2;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.ORPCthis));
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->in.lObjectCount));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.apObjArray));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->in.apObjArray, ndr_get_array_size(ndr, &r->in.apObjArray));
		}
		_mem_save_apObjArray_1 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.apObjArray, 0);
		for (cntr_apObjArray_1 = 0; cntr_apObjArray_1 < r->in.lObjectCount; cntr_apObjArray_1++) {
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_apObjArray));
			if (_ptr_apObjArray) {
				NDR_PULL_ALLOC(ndr, r->in.apObjArray[cntr_apObjArray_1]);
			} else {
				r->in.apObjArray[cntr_apObjArray_1] = NULL;
			}
		}
		for (cntr_apObjArray_1 = 0; cntr_apObjArray_1 < r->in.lObjectCount; cntr_apObjArray_1++) {
			if (r->in.apObjArray[cntr_apObjArray_1]) {
				_mem_save_apObjArray_2 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->in.apObjArray[cntr_apObjArray_1], 0);
				NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.apObjArray[cntr_apObjArray_1]));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_apObjArray_2, 0);
			}
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_apObjArray_1, 0);
		NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		ZERO_STRUCTP(r->out.ORPCthat);
		if (r->in.apObjArray) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->in.apObjArray, r->in.lObjectCount));
		}
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ORPCthat);
		}
		_mem_save_ORPCthat_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ORPCthat, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ORPCthat));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ORPCthat_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_Indicate(struct ndr_print *ndr, const char *name, int flags, const struct Indicate *r)
{
	uint32_t cntr_apObjArray_1;
	ndr_print_struct(ndr, name, "Indicate");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "Indicate");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "ORPCthis", &r->in.ORPCthis);
		ndr_print_int32(ndr, "lObjectCount", r->in.lObjectCount);
		ndr_print_ptr(ndr, "apObjArray", r->in.apObjArray);
		ndr->depth++;
		ndr->print(ndr, "%s: ARRAY(%d)", "apObjArray", (int)r->in.lObjectCount);
		ndr->depth++;
		for (cntr_apObjArray_1=0;cntr_apObjArray_1<r->in.lObjectCount;cntr_apObjArray_1++) {
			ndr_print_ptr(ndr, "apObjArray", r->in.apObjArray[cntr_apObjArray_1]);
			ndr->depth++;
			if (r->in.apObjArray[cntr_apObjArray_1]) {
				ndr_print_MInterfacePointer(ndr, "apObjArray", r->in.apObjArray[cntr_apObjArray_1]);
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "Indicate");
		ndr->depth++;
		ndr_print_ptr(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "ORPCthat", r->out.ORPCthat);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct ndr_interface_call IWbemObjectSink_calls[] = {
	{
		"SetStatus",
		sizeof(struct SetStatus),
		(ndr_push_flags_fn_t) ndr_push_SetStatus,
		(ndr_pull_flags_fn_t) ndr_pull_SetStatus,
		(ndr_print_function_t) ndr_print_SetStatus,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"Indicate",
		sizeof(struct Indicate),
		(ndr_push_flags_fn_t) ndr_push_Indicate,
		(ndr_pull_flags_fn_t) ndr_pull_Indicate,
		(ndr_print_function_t) ndr_print_Indicate,
		{ 0, NULL },
		{ 0, NULL },
	},
	{ NULL, 0, NULL, NULL, NULL }
};

static const char * const IWbemObjectSink_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\IWbemObjectSink]", 
};

static const struct ndr_interface_string_array IWbemObjectSink_endpoints = {
	.count	= 1,
	.names	= IWbemObjectSink_endpoint_strings
};

static const char * const IWbemObjectSink_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array IWbemObjectSink_authservices = {
	.count	= 1,
	.names	= IWbemObjectSink_authservice_strings
};


const struct ndr_interface_table ndr_table_IWbemObjectSink = {
	.name		= "IWbemObjectSink",
	.syntax_id	= {
		{0x7c857801,0x7381,0x11cf,{0x88,0x4d},{0x00,0xaa,0x00,0x4b,0x2e,0x24}},
		NDR_IWBEMOBJECTSINK_VERSION
	},
	.helpstring	= NDR_IWBEMOBJECTSINK_HELPSTRING,
	.num_calls	= 2,
	.calls		= IWbemObjectSink_calls,
	.endpoints	= &IWbemObjectSink_endpoints,
	.authservices	= &IWbemObjectSink_authservices
};

