/*
 * Unix SMB/CIFS implementation.
 * client auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "librpc/gen_ndr/cli_wbint.h"

struct rpccli_wbint_Ping_state {
	struct wbint_Ping orig;
	struct wbint_Ping tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_wbint_Ping_done(struct tevent_req *subreq);

struct tevent_req *rpccli_wbint_Ping_send(TALLOC_CTX *mem_ctx,
					  struct tevent_context *ev,
					  struct rpc_pipe_client *cli,
					  uint32_t _in_data /* [in]  */,
					  uint32_t *_out_data /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_wbint_Ping_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_wbint_Ping_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.in_data = _in_data;

	/* Out parameters */
	state->orig.out.out_data = _out_data;

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_wbint_Ping_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_wbint,
				    NDR_WBINT_PING,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_wbint_Ping_done, req);
	return req;
}

static void rpccli_wbint_Ping_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_wbint_Ping_state *state = tevent_req_data(
		req, struct rpccli_wbint_Ping_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.out_data = *state->tmp.out.out_data;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_wbint_Ping_recv(struct tevent_req *req,
				TALLOC_CTX *mem_ctx)
{
	struct rpccli_wbint_Ping_state *state = tevent_req_data(
		req, struct rpccli_wbint_Ping_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_wbint_Ping(struct rpc_pipe_client *cli,
			   TALLOC_CTX *mem_ctx,
			   uint32_t in_data /* [in]  */,
			   uint32_t *out_data /* [out] [ref] */)
{
	struct wbint_Ping r;
	NTSTATUS status;

	/* In parameters */
	r.in.in_data = in_data;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_wbint,
				NDR_WBINT_PING,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*out_data = *r.out.out_data;

	/* Return result */
	return NT_STATUS_OK;
}

struct rpccli_wbint_LookupSid_state {
	struct wbint_LookupSid orig;
	struct wbint_LookupSid tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_wbint_LookupSid_done(struct tevent_req *subreq);

struct tevent_req *rpccli_wbint_LookupSid_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct rpc_pipe_client *cli,
					       struct dom_sid *_sid /* [in] [ref] */,
					       enum lsa_SidType *_type /* [out] [ref] */,
					       const char **_domain /* [out] [ref,charset(UTF8)] */,
					       const char **_name /* [out] [ref,charset(UTF8)] */)
{
	struct tevent_req *req;
	struct rpccli_wbint_LookupSid_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_wbint_LookupSid_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.sid = _sid;

	/* Out parameters */
	state->orig.out.type = _type;
	state->orig.out.domain = _domain;
	state->orig.out.name = _name;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_wbint_LookupSid_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_wbint,
				    NDR_WBINT_LOOKUPSID,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_wbint_LookupSid_done, req);
	return req;
}

static void rpccli_wbint_LookupSid_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_wbint_LookupSid_state *state = tevent_req_data(
		req, struct rpccli_wbint_LookupSid_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.type = *state->tmp.out.type;
	*state->orig.out.domain = *state->tmp.out.domain;
	*state->orig.out.name = *state->tmp.out.name;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_wbint_LookupSid_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     NTSTATUS *result)
{
	struct rpccli_wbint_LookupSid_state *state = tevent_req_data(
		req, struct rpccli_wbint_LookupSid_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_wbint_LookupSid(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct dom_sid *sid /* [in] [ref] */,
				enum lsa_SidType *type /* [out] [ref] */,
				const char **domain /* [out] [ref,charset(UTF8)] */,
				const char **name /* [out] [ref,charset(UTF8)] */)
{
	struct wbint_LookupSid r;
	NTSTATUS status;

	/* In parameters */
	r.in.sid = sid;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_wbint,
				NDR_WBINT_LOOKUPSID,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*type = *r.out.type;
	*domain = *r.out.domain;
	*name = *r.out.name;

	/* Return result */
	return r.out.result;
}

struct rpccli_wbint_LookupName_state {
	struct wbint_LookupName orig;
	struct wbint_LookupName tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_wbint_LookupName_done(struct tevent_req *subreq);

struct tevent_req *rpccli_wbint_LookupName_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct rpc_pipe_client *cli,
						const char *_domain /* [in] [ref,charset(UTF8)] */,
						const char *_name /* [in] [ref,charset(UTF8)] */,
						uint32_t _flags /* [in]  */,
						enum lsa_SidType *_type /* [out] [ref] */,
						struct dom_sid *_sid /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_wbint_LookupName_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_wbint_LookupName_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.domain = _domain;
	state->orig.in.name = _name;
	state->orig.in.flags = _flags;

	/* Out parameters */
	state->orig.out.type = _type;
	state->orig.out.sid = _sid;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_wbint_LookupName_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_wbint,
				    NDR_WBINT_LOOKUPNAME,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_wbint_LookupName_done, req);
	return req;
}

static void rpccli_wbint_LookupName_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_wbint_LookupName_state *state = tevent_req_data(
		req, struct rpccli_wbint_LookupName_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.type = *state->tmp.out.type;
	*state->orig.out.sid = *state->tmp.out.sid;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_wbint_LookupName_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      NTSTATUS *result)
{
	struct rpccli_wbint_LookupName_state *state = tevent_req_data(
		req, struct rpccli_wbint_LookupName_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_wbint_LookupName(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 const char *domain /* [in] [ref,charset(UTF8)] */,
				 const char *name /* [in] [ref,charset(UTF8)] */,
				 uint32_t flags /* [in]  */,
				 enum lsa_SidType *type /* [out] [ref] */,
				 struct dom_sid *sid /* [out] [ref] */)
{
	struct wbint_LookupName r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain = domain;
	r.in.name = name;
	r.in.flags = flags;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_wbint,
				NDR_WBINT_LOOKUPNAME,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*type = *r.out.type;
	*sid = *r.out.sid;

	/* Return result */
	return r.out.result;
}

struct rpccli_wbint_Sid2Uid_state {
	struct wbint_Sid2Uid orig;
	struct wbint_Sid2Uid tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_wbint_Sid2Uid_done(struct tevent_req *subreq);

struct tevent_req *rpccli_wbint_Sid2Uid_send(TALLOC_CTX *mem_ctx,
					     struct tevent_context *ev,
					     struct rpc_pipe_client *cli,
					     const char *_dom_name /* [in] [unique,charset(UTF8)] */,
					     struct dom_sid *_sid /* [in] [ref] */,
					     uint64_t *_uid /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_wbint_Sid2Uid_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_wbint_Sid2Uid_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.dom_name = _dom_name;
	state->orig.in.sid = _sid;

	/* Out parameters */
	state->orig.out.uid = _uid;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_wbint_Sid2Uid_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_wbint,
				    NDR_WBINT_SID2UID,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_wbint_Sid2Uid_done, req);
	return req;
}

static void rpccli_wbint_Sid2Uid_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_wbint_Sid2Uid_state *state = tevent_req_data(
		req, struct rpccli_wbint_Sid2Uid_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.uid = *state->tmp.out.uid;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_wbint_Sid2Uid_recv(struct tevent_req *req,
				   TALLOC_CTX *mem_ctx,
				   NTSTATUS *result)
{
	struct rpccli_wbint_Sid2Uid_state *state = tevent_req_data(
		req, struct rpccli_wbint_Sid2Uid_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_wbint_Sid2Uid(struct rpc_pipe_client *cli,
			      TALLOC_CTX *mem_ctx,
			      const char *dom_name /* [in] [unique,charset(UTF8)] */,
			      struct dom_sid *sid /* [in] [ref] */,
			      uint64_t *uid /* [out] [ref] */)
{
	struct wbint_Sid2Uid r;
	NTSTATUS status;

	/* In parameters */
	r.in.dom_name = dom_name;
	r.in.sid = sid;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_wbint,
				NDR_WBINT_SID2UID,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*uid = *r.out.uid;

	/* Return result */
	return r.out.result;
}

struct rpccli_wbint_Sid2Gid_state {
	struct wbint_Sid2Gid orig;
	struct wbint_Sid2Gid tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_wbint_Sid2Gid_done(struct tevent_req *subreq);

struct tevent_req *rpccli_wbint_Sid2Gid_send(TALLOC_CTX *mem_ctx,
					     struct tevent_context *ev,
					     struct rpc_pipe_client *cli,
					     const char *_dom_name /* [in] [unique,charset(UTF8)] */,
					     struct dom_sid *_sid /* [in] [ref] */,
					     uint64_t *_gid /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_wbint_Sid2Gid_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_wbint_Sid2Gid_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.dom_name = _dom_name;
	state->orig.in.sid = _sid;

	/* Out parameters */
	state->orig.out.gid = _gid;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_wbint_Sid2Gid_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_wbint,
				    NDR_WBINT_SID2GID,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_wbint_Sid2Gid_done, req);
	return req;
}

static void rpccli_wbint_Sid2Gid_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_wbint_Sid2Gid_state *state = tevent_req_data(
		req, struct rpccli_wbint_Sid2Gid_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.gid = *state->tmp.out.gid;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_wbint_Sid2Gid_recv(struct tevent_req *req,
				   TALLOC_CTX *mem_ctx,
				   NTSTATUS *result)
{
	struct rpccli_wbint_Sid2Gid_state *state = tevent_req_data(
		req, struct rpccli_wbint_Sid2Gid_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_wbint_Sid2Gid(struct rpc_pipe_client *cli,
			      TALLOC_CTX *mem_ctx,
			      const char *dom_name /* [in] [unique,charset(UTF8)] */,
			      struct dom_sid *sid /* [in] [ref] */,
			      uint64_t *gid /* [out] [ref] */)
{
	struct wbint_Sid2Gid r;
	NTSTATUS status;

	/* In parameters */
	r.in.dom_name = dom_name;
	r.in.sid = sid;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_wbint,
				NDR_WBINT_SID2GID,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*gid = *r.out.gid;

	/* Return result */
	return r.out.result;
}

struct rpccli_wbint_Uid2Sid_state {
	struct wbint_Uid2Sid orig;
	struct wbint_Uid2Sid tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_wbint_Uid2Sid_done(struct tevent_req *subreq);

struct tevent_req *rpccli_wbint_Uid2Sid_send(TALLOC_CTX *mem_ctx,
					     struct tevent_context *ev,
					     struct rpc_pipe_client *cli,
					     const char *_dom_name /* [in] [unique,charset(UTF8)] */,
					     uint64_t _uid /* [in]  */,
					     struct dom_sid *_sid /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_wbint_Uid2Sid_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_wbint_Uid2Sid_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.dom_name = _dom_name;
	state->orig.in.uid = _uid;

	/* Out parameters */
	state->orig.out.sid = _sid;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_wbint_Uid2Sid_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_wbint,
				    NDR_WBINT_UID2SID,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_wbint_Uid2Sid_done, req);
	return req;
}

static void rpccli_wbint_Uid2Sid_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_wbint_Uid2Sid_state *state = tevent_req_data(
		req, struct rpccli_wbint_Uid2Sid_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.sid = *state->tmp.out.sid;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_wbint_Uid2Sid_recv(struct tevent_req *req,
				   TALLOC_CTX *mem_ctx,
				   NTSTATUS *result)
{
	struct rpccli_wbint_Uid2Sid_state *state = tevent_req_data(
		req, struct rpccli_wbint_Uid2Sid_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_wbint_Uid2Sid(struct rpc_pipe_client *cli,
			      TALLOC_CTX *mem_ctx,
			      const char *dom_name /* [in] [unique,charset(UTF8)] */,
			      uint64_t uid /* [in]  */,
			      struct dom_sid *sid /* [out] [ref] */)
{
	struct wbint_Uid2Sid r;
	NTSTATUS status;

	/* In parameters */
	r.in.dom_name = dom_name;
	r.in.uid = uid;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_wbint,
				NDR_WBINT_UID2SID,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*sid = *r.out.sid;

	/* Return result */
	return r.out.result;
}

struct rpccli_wbint_Gid2Sid_state {
	struct wbint_Gid2Sid orig;
	struct wbint_Gid2Sid tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_wbint_Gid2Sid_done(struct tevent_req *subreq);

struct tevent_req *rpccli_wbint_Gid2Sid_send(TALLOC_CTX *mem_ctx,
					     struct tevent_context *ev,
					     struct rpc_pipe_client *cli,
					     const char *_dom_name /* [in] [unique,charset(UTF8)] */,
					     uint64_t _gid /* [in]  */,
					     struct dom_sid *_sid /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_wbint_Gid2Sid_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_wbint_Gid2Sid_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.dom_name = _dom_name;
	state->orig.in.gid = _gid;

	/* Out parameters */
	state->orig.out.sid = _sid;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_wbint_Gid2Sid_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_wbint,
				    NDR_WBINT_GID2SID,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_wbint_Gid2Sid_done, req);
	return req;
}

static void rpccli_wbint_Gid2Sid_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_wbint_Gid2Sid_state *state = tevent_req_data(
		req, struct rpccli_wbint_Gid2Sid_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.sid = *state->tmp.out.sid;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_wbint_Gid2Sid_recv(struct tevent_req *req,
				   TALLOC_CTX *mem_ctx,
				   NTSTATUS *result)
{
	struct rpccli_wbint_Gid2Sid_state *state = tevent_req_data(
		req, struct rpccli_wbint_Gid2Sid_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_wbint_Gid2Sid(struct rpc_pipe_client *cli,
			      TALLOC_CTX *mem_ctx,
			      const char *dom_name /* [in] [unique,charset(UTF8)] */,
			      uint64_t gid /* [in]  */,
			      struct dom_sid *sid /* [out] [ref] */)
{
	struct wbint_Gid2Sid r;
	NTSTATUS status;

	/* In parameters */
	r.in.dom_name = dom_name;
	r.in.gid = gid;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_wbint,
				NDR_WBINT_GID2SID,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*sid = *r.out.sid;

	/* Return result */
	return r.out.result;
}

struct rpccli_wbint_AllocateUid_state {
	struct wbint_AllocateUid orig;
	struct wbint_AllocateUid tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_wbint_AllocateUid_done(struct tevent_req *subreq);

struct tevent_req *rpccli_wbint_AllocateUid_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct rpc_pipe_client *cli,
						 uint64_t *_uid /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_wbint_AllocateUid_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_wbint_AllocateUid_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */
	state->orig.out.uid = _uid;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_wbint_AllocateUid_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_wbint,
				    NDR_WBINT_ALLOCATEUID,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_wbint_AllocateUid_done, req);
	return req;
}

static void rpccli_wbint_AllocateUid_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_wbint_AllocateUid_state *state = tevent_req_data(
		req, struct rpccli_wbint_AllocateUid_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.uid = *state->tmp.out.uid;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_wbint_AllocateUid_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       NTSTATUS *result)
{
	struct rpccli_wbint_AllocateUid_state *state = tevent_req_data(
		req, struct rpccli_wbint_AllocateUid_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_wbint_AllocateUid(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  uint64_t *uid /* [out] [ref] */)
{
	struct wbint_AllocateUid r;
	NTSTATUS status;

	/* In parameters */

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_wbint,
				NDR_WBINT_ALLOCATEUID,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*uid = *r.out.uid;

	/* Return result */
	return r.out.result;
}

struct rpccli_wbint_AllocateGid_state {
	struct wbint_AllocateGid orig;
	struct wbint_AllocateGid tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_wbint_AllocateGid_done(struct tevent_req *subreq);

struct tevent_req *rpccli_wbint_AllocateGid_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct rpc_pipe_client *cli,
						 uint64_t *_gid /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_wbint_AllocateGid_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_wbint_AllocateGid_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */
	state->orig.out.gid = _gid;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_wbint_AllocateGid_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_wbint,
				    NDR_WBINT_ALLOCATEGID,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_wbint_AllocateGid_done, req);
	return req;
}

static void rpccli_wbint_AllocateGid_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_wbint_AllocateGid_state *state = tevent_req_data(
		req, struct rpccli_wbint_AllocateGid_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.gid = *state->tmp.out.gid;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_wbint_AllocateGid_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       NTSTATUS *result)
{
	struct rpccli_wbint_AllocateGid_state *state = tevent_req_data(
		req, struct rpccli_wbint_AllocateGid_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_wbint_AllocateGid(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  uint64_t *gid /* [out] [ref] */)
{
	struct wbint_AllocateGid r;
	NTSTATUS status;

	/* In parameters */

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_wbint,
				NDR_WBINT_ALLOCATEGID,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*gid = *r.out.gid;

	/* Return result */
	return r.out.result;
}

struct rpccli_wbint_QueryUser_state {
	struct wbint_QueryUser orig;
	struct wbint_QueryUser tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_wbint_QueryUser_done(struct tevent_req *subreq);

struct tevent_req *rpccli_wbint_QueryUser_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct rpc_pipe_client *cli,
					       struct dom_sid *_sid /* [in] [ref] */,
					       struct wbint_userinfo *_info /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_wbint_QueryUser_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_wbint_QueryUser_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.sid = _sid;

	/* Out parameters */
	state->orig.out.info = _info;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_wbint_QueryUser_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_wbint,
				    NDR_WBINT_QUERYUSER,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_wbint_QueryUser_done, req);
	return req;
}

static void rpccli_wbint_QueryUser_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_wbint_QueryUser_state *state = tevent_req_data(
		req, struct rpccli_wbint_QueryUser_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_wbint_QueryUser_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     NTSTATUS *result)
{
	struct rpccli_wbint_QueryUser_state *state = tevent_req_data(
		req, struct rpccli_wbint_QueryUser_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_wbint_QueryUser(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct dom_sid *sid /* [in] [ref] */,
				struct wbint_userinfo *info /* [out] [ref] */)
{
	struct wbint_QueryUser r;
	NTSTATUS status;

	/* In parameters */
	r.in.sid = sid;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_wbint,
				NDR_WBINT_QUERYUSER,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info = *r.out.info;

	/* Return result */
	return r.out.result;
}

struct rpccli_wbint_LookupUserAliases_state {
	struct wbint_LookupUserAliases orig;
	struct wbint_LookupUserAliases tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_wbint_LookupUserAliases_done(struct tevent_req *subreq);

struct tevent_req *rpccli_wbint_LookupUserAliases_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct rpc_pipe_client *cli,
						       struct wbint_SidArray *_sids /* [in] [ref] */,
						       struct wbint_RidArray *_rids /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_wbint_LookupUserAliases_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_wbint_LookupUserAliases_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.sids = _sids;

	/* Out parameters */
	state->orig.out.rids = _rids;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_wbint_LookupUserAliases_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_wbint,
				    NDR_WBINT_LOOKUPUSERALIASES,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_wbint_LookupUserAliases_done, req);
	return req;
}

static void rpccli_wbint_LookupUserAliases_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_wbint_LookupUserAliases_state *state = tevent_req_data(
		req, struct rpccli_wbint_LookupUserAliases_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rids = *state->tmp.out.rids;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_wbint_LookupUserAliases_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     NTSTATUS *result)
{
	struct rpccli_wbint_LookupUserAliases_state *state = tevent_req_data(
		req, struct rpccli_wbint_LookupUserAliases_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_wbint_LookupUserAliases(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					struct wbint_SidArray *sids /* [in] [ref] */,
					struct wbint_RidArray *rids /* [out] [ref] */)
{
	struct wbint_LookupUserAliases r;
	NTSTATUS status;

	/* In parameters */
	r.in.sids = sids;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_wbint,
				NDR_WBINT_LOOKUPUSERALIASES,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*rids = *r.out.rids;

	/* Return result */
	return r.out.result;
}

struct rpccli_wbint_LookupUserGroups_state {
	struct wbint_LookupUserGroups orig;
	struct wbint_LookupUserGroups tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_wbint_LookupUserGroups_done(struct tevent_req *subreq);

struct tevent_req *rpccli_wbint_LookupUserGroups_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct rpc_pipe_client *cli,
						      struct dom_sid *_sid /* [in] [ref] */,
						      struct wbint_SidArray *_sids /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_wbint_LookupUserGroups_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_wbint_LookupUserGroups_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.sid = _sid;

	/* Out parameters */
	state->orig.out.sids = _sids;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_wbint_LookupUserGroups_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_wbint,
				    NDR_WBINT_LOOKUPUSERGROUPS,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_wbint_LookupUserGroups_done, req);
	return req;
}

static void rpccli_wbint_LookupUserGroups_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_wbint_LookupUserGroups_state *state = tevent_req_data(
		req, struct rpccli_wbint_LookupUserGroups_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.sids = *state->tmp.out.sids;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_wbint_LookupUserGroups_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    NTSTATUS *result)
{
	struct rpccli_wbint_LookupUserGroups_state *state = tevent_req_data(
		req, struct rpccli_wbint_LookupUserGroups_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_wbint_LookupUserGroups(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       struct dom_sid *sid /* [in] [ref] */,
				       struct wbint_SidArray *sids /* [out] [ref] */)
{
	struct wbint_LookupUserGroups r;
	NTSTATUS status;

	/* In parameters */
	r.in.sid = sid;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_wbint,
				NDR_WBINT_LOOKUPUSERGROUPS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*sids = *r.out.sids;

	/* Return result */
	return r.out.result;
}

struct rpccli_wbint_QuerySequenceNumber_state {
	struct wbint_QuerySequenceNumber orig;
	struct wbint_QuerySequenceNumber tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_wbint_QuerySequenceNumber_done(struct tevent_req *subreq);

struct tevent_req *rpccli_wbint_QuerySequenceNumber_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct rpc_pipe_client *cli,
							 uint32_t *_sequence /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_wbint_QuerySequenceNumber_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_wbint_QuerySequenceNumber_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */
	state->orig.out.sequence = _sequence;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_wbint_QuerySequenceNumber_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_wbint,
				    NDR_WBINT_QUERYSEQUENCENUMBER,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_wbint_QuerySequenceNumber_done, req);
	return req;
}

static void rpccli_wbint_QuerySequenceNumber_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_wbint_QuerySequenceNumber_state *state = tevent_req_data(
		req, struct rpccli_wbint_QuerySequenceNumber_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.sequence = *state->tmp.out.sequence;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_wbint_QuerySequenceNumber_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       NTSTATUS *result)
{
	struct rpccli_wbint_QuerySequenceNumber_state *state = tevent_req_data(
		req, struct rpccli_wbint_QuerySequenceNumber_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_wbint_QuerySequenceNumber(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  uint32_t *sequence /* [out] [ref] */)
{
	struct wbint_QuerySequenceNumber r;
	NTSTATUS status;

	/* In parameters */

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_wbint,
				NDR_WBINT_QUERYSEQUENCENUMBER,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*sequence = *r.out.sequence;

	/* Return result */
	return r.out.result;
}

struct rpccli_wbint_LookupGroupMembers_state {
	struct wbint_LookupGroupMembers orig;
	struct wbint_LookupGroupMembers tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_wbint_LookupGroupMembers_done(struct tevent_req *subreq);

struct tevent_req *rpccli_wbint_LookupGroupMembers_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct rpc_pipe_client *cli,
							struct dom_sid *_sid /* [in] [ref] */,
							enum lsa_SidType _type /* [in]  */,
							struct wbint_Principals *_members /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_wbint_LookupGroupMembers_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_wbint_LookupGroupMembers_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.sid = _sid;
	state->orig.in.type = _type;

	/* Out parameters */
	state->orig.out.members = _members;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_wbint_LookupGroupMembers_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_wbint,
				    NDR_WBINT_LOOKUPGROUPMEMBERS,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_wbint_LookupGroupMembers_done, req);
	return req;
}

static void rpccli_wbint_LookupGroupMembers_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_wbint_LookupGroupMembers_state *state = tevent_req_data(
		req, struct rpccli_wbint_LookupGroupMembers_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.members = *state->tmp.out.members;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_wbint_LookupGroupMembers_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      NTSTATUS *result)
{
	struct rpccli_wbint_LookupGroupMembers_state *state = tevent_req_data(
		req, struct rpccli_wbint_LookupGroupMembers_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_wbint_LookupGroupMembers(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 struct dom_sid *sid /* [in] [ref] */,
					 enum lsa_SidType type /* [in]  */,
					 struct wbint_Principals *members /* [out] [ref] */)
{
	struct wbint_LookupGroupMembers r;
	NTSTATUS status;

	/* In parameters */
	r.in.sid = sid;
	r.in.type = type;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_wbint,
				NDR_WBINT_LOOKUPGROUPMEMBERS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*members = *r.out.members;

	/* Return result */
	return r.out.result;
}

struct rpccli_wbint_QueryUserList_state {
	struct wbint_QueryUserList orig;
	struct wbint_QueryUserList tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_wbint_QueryUserList_done(struct tevent_req *subreq);

struct tevent_req *rpccli_wbint_QueryUserList_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct rpc_pipe_client *cli,
						   struct wbint_userinfos *_users /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_wbint_QueryUserList_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_wbint_QueryUserList_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */
	state->orig.out.users = _users;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_wbint_QueryUserList_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_wbint,
				    NDR_WBINT_QUERYUSERLIST,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_wbint_QueryUserList_done, req);
	return req;
}

static void rpccli_wbint_QueryUserList_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_wbint_QueryUserList_state *state = tevent_req_data(
		req, struct rpccli_wbint_QueryUserList_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.users = *state->tmp.out.users;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_wbint_QueryUserList_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 NTSTATUS *result)
{
	struct rpccli_wbint_QueryUserList_state *state = tevent_req_data(
		req, struct rpccli_wbint_QueryUserList_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_wbint_QueryUserList(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    struct wbint_userinfos *users /* [out] [ref] */)
{
	struct wbint_QueryUserList r;
	NTSTATUS status;

	/* In parameters */

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_wbint,
				NDR_WBINT_QUERYUSERLIST,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*users = *r.out.users;

	/* Return result */
	return r.out.result;
}

struct rpccli_wbint_QueryGroupList_state {
	struct wbint_QueryGroupList orig;
	struct wbint_QueryGroupList tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_wbint_QueryGroupList_done(struct tevent_req *subreq);

struct tevent_req *rpccli_wbint_QueryGroupList_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct rpc_pipe_client *cli,
						    struct wbint_Principals *_groups /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_wbint_QueryGroupList_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_wbint_QueryGroupList_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */
	state->orig.out.groups = _groups;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_wbint_QueryGroupList_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_wbint,
				    NDR_WBINT_QUERYGROUPLIST,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_wbint_QueryGroupList_done, req);
	return req;
}

static void rpccli_wbint_QueryGroupList_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_wbint_QueryGroupList_state *state = tevent_req_data(
		req, struct rpccli_wbint_QueryGroupList_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.groups = *state->tmp.out.groups;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_wbint_QueryGroupList_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  NTSTATUS *result)
{
	struct rpccli_wbint_QueryGroupList_state *state = tevent_req_data(
		req, struct rpccli_wbint_QueryGroupList_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_wbint_QueryGroupList(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     struct wbint_Principals *groups /* [out] [ref] */)
{
	struct wbint_QueryGroupList r;
	NTSTATUS status;

	/* In parameters */

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_wbint,
				NDR_WBINT_QUERYGROUPLIST,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*groups = *r.out.groups;

	/* Return result */
	return r.out.result;
}

struct rpccli_wbint_DsGetDcName_state {
	struct wbint_DsGetDcName orig;
	struct wbint_DsGetDcName tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_wbint_DsGetDcName_done(struct tevent_req *subreq);

struct tevent_req *rpccli_wbint_DsGetDcName_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct rpc_pipe_client *cli,
						 const char *_domain_name /* [in] [ref,charset(UTF8)] */,
						 struct GUID *_domain_guid /* [in] [unique] */,
						 const char *_site_name /* [in] [unique,charset(UTF8)] */,
						 uint32_t _flags /* [in]  */,
						 struct netr_DsRGetDCNameInfo **_dc_info /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_wbint_DsGetDcName_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_wbint_DsGetDcName_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.domain_name = _domain_name;
	state->orig.in.domain_guid = _domain_guid;
	state->orig.in.site_name = _site_name;
	state->orig.in.flags = _flags;

	/* Out parameters */
	state->orig.out.dc_info = _dc_info;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_wbint_DsGetDcName_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_wbint,
				    NDR_WBINT_DSGETDCNAME,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_wbint_DsGetDcName_done, req);
	return req;
}

static void rpccli_wbint_DsGetDcName_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_wbint_DsGetDcName_state *state = tevent_req_data(
		req, struct rpccli_wbint_DsGetDcName_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.dc_info = *state->tmp.out.dc_info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_wbint_DsGetDcName_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       NTSTATUS *result)
{
	struct rpccli_wbint_DsGetDcName_state *state = tevent_req_data(
		req, struct rpccli_wbint_DsGetDcName_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_wbint_DsGetDcName(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  const char *domain_name /* [in] [ref,charset(UTF8)] */,
				  struct GUID *domain_guid /* [in] [unique] */,
				  const char *site_name /* [in] [unique,charset(UTF8)] */,
				  uint32_t flags /* [in]  */,
				  struct netr_DsRGetDCNameInfo **dc_info /* [out] [ref] */)
{
	struct wbint_DsGetDcName r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_name = domain_name;
	r.in.domain_guid = domain_guid;
	r.in.site_name = site_name;
	r.in.flags = flags;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_wbint,
				NDR_WBINT_DSGETDCNAME,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*dc_info = *r.out.dc_info;

	/* Return result */
	return r.out.result;
}

struct rpccli_wbint_LookupRids_state {
	struct wbint_LookupRids orig;
	struct wbint_LookupRids tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_wbint_LookupRids_done(struct tevent_req *subreq);

struct tevent_req *rpccli_wbint_LookupRids_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct rpc_pipe_client *cli,
						struct dom_sid *_domain_sid /* [in] [ref] */,
						struct wbint_RidArray *_rids /* [in] [ref] */,
						const char **_domain_name /* [out] [ref,charset(UTF8)] */,
						struct wbint_Principals *_names /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_wbint_LookupRids_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_wbint_LookupRids_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.domain_sid = _domain_sid;
	state->orig.in.rids = _rids;

	/* Out parameters */
	state->orig.out.domain_name = _domain_name;
	state->orig.out.names = _names;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_wbint_LookupRids_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_wbint,
				    NDR_WBINT_LOOKUPRIDS,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_wbint_LookupRids_done, req);
	return req;
}

static void rpccli_wbint_LookupRids_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_wbint_LookupRids_state *state = tevent_req_data(
		req, struct rpccli_wbint_LookupRids_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.domain_name = *state->tmp.out.domain_name;
	*state->orig.out.names = *state->tmp.out.names;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_wbint_LookupRids_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      NTSTATUS *result)
{
	struct rpccli_wbint_LookupRids_state *state = tevent_req_data(
		req, struct rpccli_wbint_LookupRids_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_wbint_LookupRids(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct dom_sid *domain_sid /* [in] [ref] */,
				 struct wbint_RidArray *rids /* [in] [ref] */,
				 const char **domain_name /* [out] [ref,charset(UTF8)] */,
				 struct wbint_Principals *names /* [out] [ref] */)
{
	struct wbint_LookupRids r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_sid = domain_sid;
	r.in.rids = rids;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_wbint,
				NDR_WBINT_LOOKUPRIDS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*domain_name = *r.out.domain_name;
	*names = *r.out.names;

	/* Return result */
	return r.out.result;
}

struct rpccli_wbint_CheckMachineAccount_state {
	struct wbint_CheckMachineAccount orig;
	struct wbint_CheckMachineAccount tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_wbint_CheckMachineAccount_done(struct tevent_req *subreq);

struct tevent_req *rpccli_wbint_CheckMachineAccount_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_wbint_CheckMachineAccount_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_wbint_CheckMachineAccount_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_wbint,
				    NDR_WBINT_CHECKMACHINEACCOUNT,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_wbint_CheckMachineAccount_done, req);
	return req;
}

static void rpccli_wbint_CheckMachineAccount_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_wbint_CheckMachineAccount_state *state = tevent_req_data(
		req, struct rpccli_wbint_CheckMachineAccount_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_wbint_CheckMachineAccount_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       NTSTATUS *result)
{
	struct rpccli_wbint_CheckMachineAccount_state *state = tevent_req_data(
		req, struct rpccli_wbint_CheckMachineAccount_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_wbint_CheckMachineAccount(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx)
{
	struct wbint_CheckMachineAccount r;
	NTSTATUS status;

	/* In parameters */

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_wbint,
				NDR_WBINT_CHECKMACHINEACCOUNT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_wbint_ChangeMachineAccount_state {
	struct wbint_ChangeMachineAccount orig;
	struct wbint_ChangeMachineAccount tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_wbint_ChangeMachineAccount_done(struct tevent_req *subreq);

struct tevent_req *rpccli_wbint_ChangeMachineAccount_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_wbint_ChangeMachineAccount_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_wbint_ChangeMachineAccount_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_wbint,
				    NDR_WBINT_CHANGEMACHINEACCOUNT,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_wbint_ChangeMachineAccount_done, req);
	return req;
}

static void rpccli_wbint_ChangeMachineAccount_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_wbint_ChangeMachineAccount_state *state = tevent_req_data(
		req, struct rpccli_wbint_ChangeMachineAccount_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_wbint_ChangeMachineAccount_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						NTSTATUS *result)
{
	struct rpccli_wbint_ChangeMachineAccount_state *state = tevent_req_data(
		req, struct rpccli_wbint_ChangeMachineAccount_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_wbint_ChangeMachineAccount(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx)
{
	struct wbint_ChangeMachineAccount r;
	NTSTATUS status;

	/* In parameters */

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_wbint,
				NDR_WBINT_CHANGEMACHINEACCOUNT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_wbint_PingDc_state {
	struct wbint_PingDc orig;
	struct wbint_PingDc tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_wbint_PingDc_done(struct tevent_req *subreq);

struct tevent_req *rpccli_wbint_PingDc_send(TALLOC_CTX *mem_ctx,
					    struct tevent_context *ev,
					    struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_wbint_PingDc_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_wbint_PingDc_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_wbint,
				    NDR_WBINT_PINGDC,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_wbint_PingDc_done, req);
	return req;
}

static void rpccli_wbint_PingDc_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_wbint_PingDc_state *state = tevent_req_data(
		req, struct rpccli_wbint_PingDc_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_wbint_PingDc_recv(struct tevent_req *req,
				  TALLOC_CTX *mem_ctx,
				  NTSTATUS *result)
{
	struct rpccli_wbint_PingDc_state *state = tevent_req_data(
		req, struct rpccli_wbint_PingDc_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_wbint_PingDc(struct rpc_pipe_client *cli,
			     TALLOC_CTX *mem_ctx)
{
	struct wbint_PingDc r;
	NTSTATUS status;

	/* In parameters */

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_wbint,
				NDR_WBINT_PINGDC,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_wbint_SetMapping_state {
	struct wbint_SetMapping orig;
	struct wbint_SetMapping tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_wbint_SetMapping_done(struct tevent_req *subreq);

struct tevent_req *rpccli_wbint_SetMapping_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct rpc_pipe_client *cli,
						struct dom_sid *_sid /* [in] [ref] */,
						enum wbint_IdType _type /* [in]  */,
						uint64_t _id /* [in]  */)
{
	struct tevent_req *req;
	struct rpccli_wbint_SetMapping_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_wbint_SetMapping_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.sid = _sid;
	state->orig.in.type = _type;
	state->orig.in.id = _id;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_wbint,
				    NDR_WBINT_SETMAPPING,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_wbint_SetMapping_done, req);
	return req;
}

static void rpccli_wbint_SetMapping_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_wbint_SetMapping_state *state = tevent_req_data(
		req, struct rpccli_wbint_SetMapping_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_wbint_SetMapping_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      NTSTATUS *result)
{
	struct rpccli_wbint_SetMapping_state *state = tevent_req_data(
		req, struct rpccli_wbint_SetMapping_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_wbint_SetMapping(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct dom_sid *sid /* [in] [ref] */,
				 enum wbint_IdType type /* [in]  */,
				 uint64_t id /* [in]  */)
{
	struct wbint_SetMapping r;
	NTSTATUS status;

	/* In parameters */
	r.in.sid = sid;
	r.in.type = type;
	r.in.id = id;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_wbint,
				NDR_WBINT_SETMAPPING,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_wbint_RemoveMapping_state {
	struct wbint_RemoveMapping orig;
	struct wbint_RemoveMapping tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_wbint_RemoveMapping_done(struct tevent_req *subreq);

struct tevent_req *rpccli_wbint_RemoveMapping_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct rpc_pipe_client *cli,
						   struct dom_sid *_sid /* [in] [ref] */,
						   enum wbint_IdType _type /* [in]  */,
						   uint64_t _id /* [in]  */)
{
	struct tevent_req *req;
	struct rpccli_wbint_RemoveMapping_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_wbint_RemoveMapping_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.sid = _sid;
	state->orig.in.type = _type;
	state->orig.in.id = _id;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_wbint,
				    NDR_WBINT_REMOVEMAPPING,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_wbint_RemoveMapping_done, req);
	return req;
}

static void rpccli_wbint_RemoveMapping_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_wbint_RemoveMapping_state *state = tevent_req_data(
		req, struct rpccli_wbint_RemoveMapping_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_wbint_RemoveMapping_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 NTSTATUS *result)
{
	struct rpccli_wbint_RemoveMapping_state *state = tevent_req_data(
		req, struct rpccli_wbint_RemoveMapping_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_wbint_RemoveMapping(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    struct dom_sid *sid /* [in] [ref] */,
				    enum wbint_IdType type /* [in]  */,
				    uint64_t id /* [in]  */)
{
	struct wbint_RemoveMapping r;
	NTSTATUS status;

	/* In parameters */
	r.in.sid = sid;
	r.in.type = type;
	r.in.id = id;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_wbint,
				NDR_WBINT_REMOVEMAPPING,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_wbint_SetHWM_state {
	struct wbint_SetHWM orig;
	struct wbint_SetHWM tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_wbint_SetHWM_done(struct tevent_req *subreq);

struct tevent_req *rpccli_wbint_SetHWM_send(TALLOC_CTX *mem_ctx,
					    struct tevent_context *ev,
					    struct rpc_pipe_client *cli,
					    enum wbint_IdType _type /* [in]  */,
					    uint64_t _id /* [in]  */)
{
	struct tevent_req *req;
	struct rpccli_wbint_SetHWM_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_wbint_SetHWM_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.type = _type;
	state->orig.in.id = _id;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_wbint,
				    NDR_WBINT_SETHWM,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_wbint_SetHWM_done, req);
	return req;
}

static void rpccli_wbint_SetHWM_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_wbint_SetHWM_state *state = tevent_req_data(
		req, struct rpccli_wbint_SetHWM_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_wbint_SetHWM_recv(struct tevent_req *req,
				  TALLOC_CTX *mem_ctx,
				  NTSTATUS *result)
{
	struct rpccli_wbint_SetHWM_state *state = tevent_req_data(
		req, struct rpccli_wbint_SetHWM_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_wbint_SetHWM(struct rpc_pipe_client *cli,
			     TALLOC_CTX *mem_ctx,
			     enum wbint_IdType type /* [in]  */,
			     uint64_t id /* [in]  */)
{
	struct wbint_SetHWM r;
	NTSTATUS status;

	/* In parameters */
	r.in.type = type;
	r.in.id = id;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_wbint,
				NDR_WBINT_SETHWM,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

