/*
 * Unix SMB/CIFS implementation.
 * client auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "../librpc/gen_ndr/cli_spoolss.h"

NTSTATUS rpccli_spoolss_EnumPrinters(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     uint32_t flags /* [in]  */,
				     const char *server /* [in] [unique,charset(UTF16)] */,
				     uint32_t level /* [in]  */,
				     DATA_BLOB *buffer /* [in] [unique] */,
				     uint32_t offered /* [in]  */,
				     uint32_t *count /* [out] [ref] */,
				     union spoolss_PrinterInfo **info /* [out] [ref,switch_is(level),size_is(,*count)] */,
				     uint32_t *needed /* [out] [ref] */,
				     WERROR *werror)
{
	struct spoolss_EnumPrinters r;
	NTSTATUS status;

	/* In parameters */
	r.in.flags = flags;
	r.in.server = server;
	r.in.level = level;
	r.in.buffer = buffer;
	r.in.offered = offered;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_EnumPrinters, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_ENUMPRINTERS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_EnumPrinters, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*count = *r.out.count;
	*info = *r.out.info;
	*needed = *r.out.needed;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_OpenPrinter(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    const char *printername /* [in] [unique,charset(UTF16)] */,
				    const char *datatype /* [in] [unique,charset(UTF16)] */,
				    struct spoolss_DevmodeContainer devmode_ctr /* [in]  */,
				    uint32_t access_mask /* [in]  */,
				    struct policy_handle *handle /* [out] [ref] */,
				    WERROR *werror)
{
	struct spoolss_OpenPrinter r;
	NTSTATUS status;

	/* In parameters */
	r.in.printername = printername;
	r.in.datatype = datatype;
	r.in.devmode_ctr = devmode_ctr;
	r.in.access_mask = access_mask;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_OpenPrinter, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_OPENPRINTER,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_OpenPrinter, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*handle = *r.out.handle;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_SetJob(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       struct policy_handle *handle /* [in] [ref] */,
			       uint32_t job_id /* [in]  */,
			       struct spoolss_JobInfoContainer *ctr /* [in] [unique] */,
			       enum spoolss_JobControl command /* [in]  */,
			       WERROR *werror)
{
	struct spoolss_SetJob r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.job_id = job_id;
	r.in.ctr = ctr;
	r.in.command = command;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_SetJob, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_SETJOB,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_SetJob, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_GetJob(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       struct policy_handle *handle /* [in] [ref] */,
			       uint32_t job_id /* [in]  */,
			       uint32_t level /* [in]  */,
			       DATA_BLOB *buffer /* [in] [unique] */,
			       uint32_t offered /* [in]  */,
			       union spoolss_JobInfo *info /* [out] [unique,subcontext_size(offered),subcontext(4),switch_is(level)] */,
			       uint32_t *needed /* [out] [ref] */,
			       WERROR *werror)
{
	struct spoolss_GetJob r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.job_id = job_id;
	r.in.level = level;
	r.in.buffer = buffer;
	r.in.offered = offered;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_GetJob, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_GETJOB,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_GetJob, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	if (info && r.out.info) {
		*info = *r.out.info;
	}
	*needed = *r.out.needed;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_EnumJobs(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct policy_handle *handle /* [in] [ref] */,
				 uint32_t firstjob /* [in]  */,
				 uint32_t numjobs /* [in]  */,
				 uint32_t level /* [in]  */,
				 DATA_BLOB *buffer /* [in] [unique] */,
				 uint32_t offered /* [in]  */,
				 uint32_t *count /* [out] [ref] */,
				 union spoolss_JobInfo **info /* [out] [ref,switch_is(level),size_is(,*count)] */,
				 uint32_t *needed /* [out] [ref] */,
				 WERROR *werror)
{
	struct spoolss_EnumJobs r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.firstjob = firstjob;
	r.in.numjobs = numjobs;
	r.in.level = level;
	r.in.buffer = buffer;
	r.in.offered = offered;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_EnumJobs, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_ENUMJOBS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_EnumJobs, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*count = *r.out.count;
	*info = *r.out.info;
	*needed = *r.out.needed;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_AddPrinter(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   WERROR *werror)
{
	struct spoolss_AddPrinter r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_AddPrinter, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_ADDPRINTER,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_AddPrinter, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_DeletePrinter(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *handle /* [in] [ref] */,
				      WERROR *werror)
{
	struct spoolss_DeletePrinter r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_DeletePrinter, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_DELETEPRINTER,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_DeletePrinter, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_SetPrinter(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   struct policy_handle *handle /* [in] [ref] */,
				   struct spoolss_SetPrinterInfoCtr *info_ctr /* [in] [ref] */,
				   struct spoolss_DevmodeContainer *devmode_ctr /* [in] [ref] */,
				   struct sec_desc_buf *secdesc_ctr /* [in] [ref] */,
				   enum spoolss_PrinterControl command /* [in]  */,
				   WERROR *werror)
{
	struct spoolss_SetPrinter r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.info_ctr = info_ctr;
	r.in.devmode_ctr = devmode_ctr;
	r.in.secdesc_ctr = secdesc_ctr;
	r.in.command = command;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_SetPrinter, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_SETPRINTER,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_SetPrinter, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_GetPrinter(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   struct policy_handle *handle /* [in] [ref] */,
				   uint32_t level /* [in]  */,
				   DATA_BLOB *buffer /* [in] [unique] */,
				   uint32_t offered /* [in]  */,
				   union spoolss_PrinterInfo *info /* [out] [unique,subcontext_size(offered),subcontext(4),switch_is(level)] */,
				   uint32_t *needed /* [out] [ref] */,
				   WERROR *werror)
{
	struct spoolss_GetPrinter r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.level = level;
	r.in.buffer = buffer;
	r.in.offered = offered;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_GetPrinter, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_GETPRINTER,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_GetPrinter, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	if (info && r.out.info) {
		*info = *r.out.info;
	}
	*needed = *r.out.needed;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_AddPrinterDriver(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 const char *servername /* [in] [unique,charset(UTF16)] */,
					 struct spoolss_AddDriverInfoCtr *info_ctr /* [in] [ref] */,
					 WERROR *werror)
{
	struct spoolss_AddPrinterDriver r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = servername;
	r.in.info_ctr = info_ctr;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_AddPrinterDriver, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_ADDPRINTERDRIVER,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_AddPrinterDriver, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_EnumPrinterDrivers(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   const char *server /* [in] [unique,charset(UTF16)] */,
					   const char *environment /* [in] [unique,charset(UTF16)] */,
					   uint32_t level /* [in]  */,
					   DATA_BLOB *buffer /* [in] [unique] */,
					   uint32_t offered /* [in]  */,
					   uint32_t *count /* [out] [ref] */,
					   union spoolss_DriverInfo **info /* [out] [ref,switch_is(level),size_is(,*count)] */,
					   uint32_t *needed /* [out] [ref] */,
					   WERROR *werror)
{
	struct spoolss_EnumPrinterDrivers r;
	NTSTATUS status;

	/* In parameters */
	r.in.server = server;
	r.in.environment = environment;
	r.in.level = level;
	r.in.buffer = buffer;
	r.in.offered = offered;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_EnumPrinterDrivers, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_ENUMPRINTERDRIVERS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_EnumPrinterDrivers, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*count = *r.out.count;
	*info = *r.out.info;
	*needed = *r.out.needed;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_GetPrinterDriver(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 WERROR *werror)
{
	struct spoolss_GetPrinterDriver r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_GetPrinterDriver, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_GETPRINTERDRIVER,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_GetPrinterDriver, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_GetPrinterDriverDirectory(struct rpc_pipe_client *cli,
						  TALLOC_CTX *mem_ctx,
						  const char *server /* [in] [unique,charset(UTF16)] */,
						  const char *environment /* [in] [unique,charset(UTF16)] */,
						  uint32_t level /* [in]  */,
						  DATA_BLOB *buffer /* [in] [unique] */,
						  uint32_t offered /* [in]  */,
						  union spoolss_DriverDirectoryInfo *info /* [out] [unique,subcontext_size(offered),subcontext(4),switch_is(level)] */,
						  uint32_t *needed /* [out] [ref] */,
						  WERROR *werror)
{
	struct spoolss_GetPrinterDriverDirectory r;
	NTSTATUS status;

	/* In parameters */
	r.in.server = server;
	r.in.environment = environment;
	r.in.level = level;
	r.in.buffer = buffer;
	r.in.offered = offered;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_GetPrinterDriverDirectory, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_GETPRINTERDRIVERDIRECTORY,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_GetPrinterDriverDirectory, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	if (info && r.out.info) {
		*info = *r.out.info;
	}
	*needed = *r.out.needed;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_DeletePrinterDriver(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx,
					    const char *server /* [in] [unique,charset(UTF16)] */,
					    const char *architecture /* [in] [charset(UTF16)] */,
					    const char *driver /* [in] [charset(UTF16)] */,
					    WERROR *werror)
{
	struct spoolss_DeletePrinterDriver r;
	NTSTATUS status;

	/* In parameters */
	r.in.server = server;
	r.in.architecture = architecture;
	r.in.driver = driver;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_DeletePrinterDriver, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_DELETEPRINTERDRIVER,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_DeletePrinterDriver, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_AddPrintProcessor(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  const char *server /* [in] [unique,charset(UTF16)] */,
					  const char *architecture /* [in] [charset(UTF16)] */,
					  const char *path_name /* [in] [charset(UTF16)] */,
					  const char *print_processor_name /* [in] [charset(UTF16)] */,
					  WERROR *werror)
{
	struct spoolss_AddPrintProcessor r;
	NTSTATUS status;

	/* In parameters */
	r.in.server = server;
	r.in.architecture = architecture;
	r.in.path_name = path_name;
	r.in.print_processor_name = print_processor_name;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_AddPrintProcessor, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_ADDPRINTPROCESSOR,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_AddPrintProcessor, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_EnumPrintProcessors(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx,
					    const char *servername /* [in] [unique,charset(UTF16)] */,
					    const char *environment /* [in] [unique,charset(UTF16)] */,
					    uint32_t level /* [in]  */,
					    DATA_BLOB *buffer /* [in] [unique] */,
					    uint32_t offered /* [in]  */,
					    uint32_t *count /* [out] [ref] */,
					    union spoolss_PrintProcessorInfo **info /* [out] [ref,switch_is(level),size_is(,*count)] */,
					    uint32_t *needed /* [out] [ref] */,
					    WERROR *werror)
{
	struct spoolss_EnumPrintProcessors r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = servername;
	r.in.environment = environment;
	r.in.level = level;
	r.in.buffer = buffer;
	r.in.offered = offered;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_EnumPrintProcessors, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_ENUMPRINTPROCESSORS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_EnumPrintProcessors, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*count = *r.out.count;
	*info = *r.out.info;
	*needed = *r.out.needed;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_GetPrintProcessorDirectory(struct rpc_pipe_client *cli,
						   TALLOC_CTX *mem_ctx,
						   const char *server /* [in] [unique,charset(UTF16)] */,
						   const char *environment /* [in] [unique,charset(UTF16)] */,
						   uint32_t level /* [in]  */,
						   DATA_BLOB *buffer /* [in] [unique] */,
						   uint32_t offered /* [in]  */,
						   union spoolss_PrintProcessorDirectoryInfo *info /* [out] [unique,subcontext_size(offered),subcontext(4),switch_is(level)] */,
						   uint32_t *needed /* [out] [ref] */,
						   WERROR *werror)
{
	struct spoolss_GetPrintProcessorDirectory r;
	NTSTATUS status;

	/* In parameters */
	r.in.server = server;
	r.in.environment = environment;
	r.in.level = level;
	r.in.buffer = buffer;
	r.in.offered = offered;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_GetPrintProcessorDirectory, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_GETPRINTPROCESSORDIRECTORY,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_GetPrintProcessorDirectory, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	if (info && r.out.info) {
		*info = *r.out.info;
	}
	*needed = *r.out.needed;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_StartDocPrinter(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					struct policy_handle *handle /* [in] [ref] */,
					uint32_t level /* [in]  */,
					union spoolss_DocumentInfo info /* [in] [switch_is(level)] */,
					uint32_t *job_id /* [out] [ref] */,
					WERROR *werror)
{
	struct spoolss_StartDocPrinter r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.level = level;
	r.in.info = info;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_StartDocPrinter, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_STARTDOCPRINTER,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_StartDocPrinter, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*job_id = *r.out.job_id;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_StartPagePrinter(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle *handle /* [in] [ref] */,
					 WERROR *werror)
{
	struct spoolss_StartPagePrinter r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_StartPagePrinter, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_STARTPAGEPRINTER,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_StartPagePrinter, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_WritePrinter(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle *handle /* [in] [ref] */,
				     DATA_BLOB data /* [in]  */,
				     uint32_t _data_size /* [in] [value(r->in.data.length)] */,
				     uint32_t *num_written /* [out] [ref] */,
				     WERROR *werror)
{
	struct spoolss_WritePrinter r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.data = data;
	r.in._data_size = _data_size;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_WritePrinter, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_WRITEPRINTER,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_WritePrinter, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*num_written = *r.out.num_written;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_EndPagePrinter(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle *handle /* [in] [ref] */,
				       WERROR *werror)
{
	struct spoolss_EndPagePrinter r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_EndPagePrinter, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_ENDPAGEPRINTER,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_EndPagePrinter, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_AbortPrinter(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle *handle /* [in] [ref] */,
				     WERROR *werror)
{
	struct spoolss_AbortPrinter r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_AbortPrinter, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_ABORTPRINTER,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_AbortPrinter, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_ReadPrinter(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    struct policy_handle *handle /* [in] [ref] */,
				    uint8_t *data /* [out] [ref,size_is(data_size)] */,
				    uint32_t data_size /* [in]  */,
				    uint32_t *_data_size /* [out] [ref] */,
				    WERROR *werror)
{
	struct spoolss_ReadPrinter r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.data_size = data_size;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_ReadPrinter, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_READPRINTER,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_ReadPrinter, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	memcpy(data, r.out.data, (r.in.data_size) * sizeof(*data));
	*_data_size = *r.out._data_size;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_EndDocPrinter(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *handle /* [in] [ref] */,
				      WERROR *werror)
{
	struct spoolss_EndDocPrinter r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_EndDocPrinter, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_ENDDOCPRINTER,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_EndDocPrinter, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_AddJob(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       struct policy_handle *handle /* [in] [ref] */,
			       uint32_t level /* [in]  */,
			       uint8_t *buffer /* [in,out] [unique,size_is(offered)] */,
			       uint32_t offered /* [in]  */,
			       uint32_t *needed /* [out] [ref] */,
			       WERROR *werror)
{
	struct spoolss_AddJob r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.level = level;
	r.in.buffer = buffer;
	r.in.offered = offered;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_AddJob, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_ADDJOB,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_AddJob, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	if (buffer && r.out.buffer) {
		memcpy(buffer, r.out.buffer, (r.in.offered) * sizeof(*buffer));
	}
	*needed = *r.out.needed;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_ScheduleJob(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    struct policy_handle *handle /* [in] [ref] */,
				    uint32_t jobid /* [in]  */,
				    WERROR *werror)
{
	struct spoolss_ScheduleJob r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.jobid = jobid;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_ScheduleJob, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_SCHEDULEJOB,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_ScheduleJob, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_GetPrinterData(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle *handle /* [in] [ref] */,
				       const char *value_name /* [in] [charset(UTF16)] */,
				       uint32_t offered /* [in]  */,
				       enum winreg_Type *type /* [out] [ref] */,
				       union spoolss_PrinterData *data /* [out] [subcontext_size(offered),ref,subcontext(4),switch_is(*type)] */,
				       uint32_t *needed /* [out] [ref] */,
				       WERROR *werror)
{
	struct spoolss_GetPrinterData r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.value_name = value_name;
	r.in.offered = offered;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_GetPrinterData, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_GETPRINTERDATA,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_GetPrinterData, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*type = *r.out.type;
	*data = *r.out.data;
	*needed = *r.out.needed;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_SetPrinterData(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle *handle /* [in] [ref] */,
				       const char *value_name /* [in] [charset(UTF16)] */,
				       enum winreg_Type type /* [in]  */,
				       union spoolss_PrinterData data /* [in] [subcontext(4),switch_is(type)] */,
				       uint32_t _offered /* [in] [value(ndr_size_spoolss_PrinterData(&data,type,ndr->iconv_convenience,flags))] */,
				       WERROR *werror)
{
	struct spoolss_SetPrinterData r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.value_name = value_name;
	r.in.type = type;
	r.in.data = data;
	r.in._offered = _offered;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_SetPrinterData, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_SETPRINTERDATA,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_SetPrinterData, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_WaitForPrinterChange(struct rpc_pipe_client *cli,
					     TALLOC_CTX *mem_ctx,
					     WERROR *werror)
{
	struct spoolss_WaitForPrinterChange r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_WaitForPrinterChange, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_WAITFORPRINTERCHANGE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_WaitForPrinterChange, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_ClosePrinter(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle *handle /* [in,out] [ref] */,
				     WERROR *werror)
{
	struct spoolss_ClosePrinter r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_ClosePrinter, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_CLOSEPRINTER,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_ClosePrinter, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*handle = *r.out.handle;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_AddForm(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct policy_handle *handle /* [in] [ref] */,
				uint32_t level /* [in]  */,
				union spoolss_AddFormInfo info /* [in] [switch_is(level)] */,
				WERROR *werror)
{
	struct spoolss_AddForm r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.level = level;
	r.in.info = info;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_AddForm, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_ADDFORM,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_AddForm, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_DeleteForm(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   struct policy_handle *handle /* [in] [ref] */,
				   const char *form_name /* [in] [charset(UTF16)] */,
				   WERROR *werror)
{
	struct spoolss_DeleteForm r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.form_name = form_name;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_DeleteForm, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_DELETEFORM,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_DeleteForm, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_GetForm(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct policy_handle *handle /* [in] [ref] */,
				const char *form_name /* [in] [charset(UTF16)] */,
				uint32_t level /* [in]  */,
				DATA_BLOB *buffer /* [in] [unique] */,
				uint32_t offered /* [in]  */,
				union spoolss_FormInfo *info /* [out] [unique,subcontext_size(offered),subcontext(4),switch_is(level)] */,
				uint32_t *needed /* [out] [ref] */,
				WERROR *werror)
{
	struct spoolss_GetForm r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.form_name = form_name;
	r.in.level = level;
	r.in.buffer = buffer;
	r.in.offered = offered;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_GetForm, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_GETFORM,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_GetForm, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	if (info && r.out.info) {
		*info = *r.out.info;
	}
	*needed = *r.out.needed;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_SetForm(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct policy_handle *handle /* [in] [ref] */,
				const char *form_name /* [in] [charset(UTF16)] */,
				uint32_t level /* [in]  */,
				union spoolss_AddFormInfo info /* [in] [switch_is(level)] */,
				WERROR *werror)
{
	struct spoolss_SetForm r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.form_name = form_name;
	r.in.level = level;
	r.in.info = info;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_SetForm, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_SETFORM,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_SetForm, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_EnumForms(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  struct policy_handle *handle /* [in] [ref] */,
				  uint32_t level /* [in]  */,
				  DATA_BLOB *buffer /* [in] [unique] */,
				  uint32_t offered /* [in]  */,
				  uint32_t *count /* [out] [ref] */,
				  union spoolss_FormInfo **info /* [out] [ref,switch_is(level),size_is(,*count)] */,
				  uint32_t *needed /* [out] [ref] */,
				  WERROR *werror)
{
	struct spoolss_EnumForms r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.level = level;
	r.in.buffer = buffer;
	r.in.offered = offered;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_EnumForms, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_ENUMFORMS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_EnumForms, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*count = *r.out.count;
	*info = *r.out.info;
	*needed = *r.out.needed;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_EnumPorts(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  const char *servername /* [in] [unique,charset(UTF16)] */,
				  uint32_t level /* [in]  */,
				  DATA_BLOB *buffer /* [in] [unique] */,
				  uint32_t offered /* [in]  */,
				  uint32_t *count /* [out] [ref] */,
				  union spoolss_PortInfo **info /* [out] [ref,switch_is(level),size_is(,*count)] */,
				  uint32_t *needed /* [out] [ref] */,
				  WERROR *werror)
{
	struct spoolss_EnumPorts r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = servername;
	r.in.level = level;
	r.in.buffer = buffer;
	r.in.offered = offered;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_EnumPorts, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_ENUMPORTS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_EnumPorts, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*count = *r.out.count;
	*info = *r.out.info;
	*needed = *r.out.needed;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_EnumMonitors(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     const char *servername /* [in] [unique,charset(UTF16)] */,
				     uint32_t level /* [in]  */,
				     DATA_BLOB *buffer /* [in] [unique] */,
				     uint32_t offered /* [in]  */,
				     uint32_t *count /* [out] [ref] */,
				     union spoolss_MonitorInfo **info /* [out] [ref,switch_is(level),size_is(,*count)] */,
				     uint32_t *needed /* [out] [ref] */,
				     WERROR *werror)
{
	struct spoolss_EnumMonitors r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = servername;
	r.in.level = level;
	r.in.buffer = buffer;
	r.in.offered = offered;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_EnumMonitors, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_ENUMMONITORS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_EnumMonitors, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*count = *r.out.count;
	*info = *r.out.info;
	*needed = *r.out.needed;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_AddPort(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				const char *server_name /* [in] [unique,charset(UTF16)] */,
				uint32_t unknown /* [in]  */,
				const char *monitor_name /* [in] [charset(UTF16)] */,
				WERROR *werror)
{
	struct spoolss_AddPort r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;
	r.in.unknown = unknown;
	r.in.monitor_name = monitor_name;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_AddPort, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_ADDPORT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_AddPort, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_ConfigurePort(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      WERROR *werror)
{
	struct spoolss_ConfigurePort r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_ConfigurePort, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_CONFIGUREPORT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_ConfigurePort, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_DeletePort(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   WERROR *werror)
{
	struct spoolss_DeletePort r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_DeletePort, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_DELETEPORT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_DeletePort, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_CreatePrinterIC(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					WERROR *werror)
{
	struct spoolss_CreatePrinterIC r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_CreatePrinterIC, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_CREATEPRINTERIC,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_CreatePrinterIC, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_PlayGDIScriptOnPrinterIC(struct rpc_pipe_client *cli,
						 TALLOC_CTX *mem_ctx,
						 WERROR *werror)
{
	struct spoolss_PlayGDIScriptOnPrinterIC r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_PlayGDIScriptOnPrinterIC, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_PLAYGDISCRIPTONPRINTERIC,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_PlayGDIScriptOnPrinterIC, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_DeletePrinterIC(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					WERROR *werror)
{
	struct spoolss_DeletePrinterIC r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_DeletePrinterIC, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_DELETEPRINTERIC,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_DeletePrinterIC, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_AddPrinterConnection(struct rpc_pipe_client *cli,
					     TALLOC_CTX *mem_ctx,
					     WERROR *werror)
{
	struct spoolss_AddPrinterConnection r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_AddPrinterConnection, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_ADDPRINTERCONNECTION,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_AddPrinterConnection, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_DeletePrinterConnection(struct rpc_pipe_client *cli,
						TALLOC_CTX *mem_ctx,
						WERROR *werror)
{
	struct spoolss_DeletePrinterConnection r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_DeletePrinterConnection, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_DELETEPRINTERCONNECTION,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_DeletePrinterConnection, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_PrinterMessageBox(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  WERROR *werror)
{
	struct spoolss_PrinterMessageBox r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_PrinterMessageBox, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_PRINTERMESSAGEBOX,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_PrinterMessageBox, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_AddMonitor(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   WERROR *werror)
{
	struct spoolss_AddMonitor r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_AddMonitor, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_ADDMONITOR,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_AddMonitor, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_DeleteMonitor(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      WERROR *werror)
{
	struct spoolss_DeleteMonitor r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_DeleteMonitor, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_DELETEMONITOR,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_DeleteMonitor, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_DeletePrintProcessor(struct rpc_pipe_client *cli,
					     TALLOC_CTX *mem_ctx,
					     WERROR *werror)
{
	struct spoolss_DeletePrintProcessor r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_DeletePrintProcessor, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_DELETEPRINTPROCESSOR,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_DeletePrintProcessor, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_AddPrintProvidor(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 WERROR *werror)
{
	struct spoolss_AddPrintProvidor r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_AddPrintProvidor, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_ADDPRINTPROVIDOR,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_AddPrintProvidor, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_DeletePrintProvidor(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx,
					    WERROR *werror)
{
	struct spoolss_DeletePrintProvidor r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_DeletePrintProvidor, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_DELETEPRINTPROVIDOR,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_DeletePrintProvidor, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_EnumPrintProcDataTypes(struct rpc_pipe_client *cli,
					       TALLOC_CTX *mem_ctx,
					       const char *servername /* [in] [unique,charset(UTF16)] */,
					       const char *print_processor_name /* [in] [unique,charset(UTF16)] */,
					       uint32_t level /* [in]  */,
					       DATA_BLOB *buffer /* [in] [unique] */,
					       uint32_t offered /* [in]  */,
					       uint32_t *count /* [out] [ref] */,
					       union spoolss_PrintProcDataTypesInfo **info /* [out] [ref,switch_is(level),size_is(,*count)] */,
					       uint32_t *needed /* [out] [ref] */,
					       WERROR *werror)
{
	struct spoolss_EnumPrintProcDataTypes r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = servername;
	r.in.print_processor_name = print_processor_name;
	r.in.level = level;
	r.in.buffer = buffer;
	r.in.offered = offered;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_EnumPrintProcDataTypes, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_ENUMPRINTPROCDATATYPES,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_EnumPrintProcDataTypes, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*count = *r.out.count;
	*info = *r.out.info;
	*needed = *r.out.needed;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_ResetPrinter(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle *handle /* [in] [ref] */,
				     const char *data_type /* [in] [unique,charset(UTF16)] */,
				     struct spoolss_DevmodeContainer *devmode_ctr /* [in] [ref] */,
				     WERROR *werror)
{
	struct spoolss_ResetPrinter r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.data_type = data_type;
	r.in.devmode_ctr = devmode_ctr;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_ResetPrinter, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_RESETPRINTER,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_ResetPrinter, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_GetPrinterDriver2(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  struct policy_handle *handle /* [in] [ref] */,
					  const char *architecture /* [in] [unique,charset(UTF16)] */,
					  uint32_t level /* [in]  */,
					  DATA_BLOB *buffer /* [in] [unique] */,
					  uint32_t offered /* [in]  */,
					  uint32_t client_major_version /* [in]  */,
					  uint32_t client_minor_version /* [in]  */,
					  union spoolss_DriverInfo *info /* [out] [unique,subcontext_size(offered),subcontext(4),switch_is(level)] */,
					  uint32_t *needed /* [out] [ref] */,
					  uint32_t *server_major_version /* [out] [ref] */,
					  uint32_t *server_minor_version /* [out] [ref] */,
					  WERROR *werror)
{
	struct spoolss_GetPrinterDriver2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.architecture = architecture;
	r.in.level = level;
	r.in.buffer = buffer;
	r.in.offered = offered;
	r.in.client_major_version = client_major_version;
	r.in.client_minor_version = client_minor_version;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_GetPrinterDriver2, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_GETPRINTERDRIVER2,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_GetPrinterDriver2, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	if (info && r.out.info) {
		*info = *r.out.info;
	}
	*needed = *r.out.needed;
	*server_major_version = *r.out.server_major_version;
	*server_minor_version = *r.out.server_minor_version;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_FindFirstPrinterChangeNotification(struct rpc_pipe_client *cli,
							   TALLOC_CTX *mem_ctx,
							   WERROR *werror)
{
	struct spoolss_FindFirstPrinterChangeNotification r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_FindFirstPrinterChangeNotification, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_FINDFIRSTPRINTERCHANGENOTIFICATION,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_FindFirstPrinterChangeNotification, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_FindNextPrinterChangeNotification(struct rpc_pipe_client *cli,
							  TALLOC_CTX *mem_ctx,
							  WERROR *werror)
{
	struct spoolss_FindNextPrinterChangeNotification r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_FindNextPrinterChangeNotification, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_FINDNEXTPRINTERCHANGENOTIFICATION,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_FindNextPrinterChangeNotification, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_FindClosePrinterNotify(struct rpc_pipe_client *cli,
					       TALLOC_CTX *mem_ctx,
					       struct policy_handle *handle /* [in] [ref] */,
					       WERROR *werror)
{
	struct spoolss_FindClosePrinterNotify r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_FindClosePrinterNotify, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_FINDCLOSEPRINTERNOTIFY,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_FindClosePrinterNotify, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_RouterFindFirstPrinterChangeNotificationOld(struct rpc_pipe_client *cli,
								    TALLOC_CTX *mem_ctx,
								    WERROR *werror)
{
	struct spoolss_RouterFindFirstPrinterChangeNotificationOld r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_RouterFindFirstPrinterChangeNotificationOld, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_ROUTERFINDFIRSTPRINTERCHANGENOTIFICATIONOLD,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_RouterFindFirstPrinterChangeNotificationOld, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_ReplyOpenPrinter(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 const char *server_name /* [in] [charset(UTF16)] */,
					 uint32_t printer_local /* [in]  */,
					 enum winreg_Type type /* [in]  */,
					 uint32_t bufsize /* [in] [range(0,512)] */,
					 uint8_t *buffer /* [in] [unique,size_is(bufsize)] */,
					 struct policy_handle *handle /* [out] [ref] */,
					 WERROR *werror)
{
	struct spoolss_ReplyOpenPrinter r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;
	r.in.printer_local = printer_local;
	r.in.type = type;
	r.in.bufsize = bufsize;
	r.in.buffer = buffer;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_ReplyOpenPrinter, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_REPLYOPENPRINTER,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_ReplyOpenPrinter, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*handle = *r.out.handle;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_RouterReplyPrinter(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle *handle /* [in] [ref] */,
					   uint32_t flags /* [in]  */,
					   uint32_t bufsize /* [in] [range(0,512)] */,
					   uint8_t *buffer /* [in] [unique,size_is(bufsize)] */,
					   WERROR *werror)
{
	struct spoolss_RouterReplyPrinter r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.flags = flags;
	r.in.bufsize = bufsize;
	r.in.buffer = buffer;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_RouterReplyPrinter, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_ROUTERREPLYPRINTER,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_RouterReplyPrinter, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_ReplyClosePrinter(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  struct policy_handle *handle /* [in,out] [ref] */,
					  WERROR *werror)
{
	struct spoolss_ReplyClosePrinter r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_ReplyClosePrinter, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_REPLYCLOSEPRINTER,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_ReplyClosePrinter, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*handle = *r.out.handle;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_AddPortEx(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  WERROR *werror)
{
	struct spoolss_AddPortEx r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_AddPortEx, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_ADDPORTEX,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_AddPortEx, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_RouterFindFirstPrinterChangeNotification(struct rpc_pipe_client *cli,
								 TALLOC_CTX *mem_ctx,
								 WERROR *werror)
{
	struct spoolss_RouterFindFirstPrinterChangeNotification r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_RouterFindFirstPrinterChangeNotification, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_ROUTERFINDFIRSTPRINTERCHANGENOTIFICATION,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_RouterFindFirstPrinterChangeNotification, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_SpoolerInit(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    WERROR *werror)
{
	struct spoolss_SpoolerInit r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_SpoolerInit, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_SPOOLERINIT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_SpoolerInit, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_ResetPrinterEx(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       WERROR *werror)
{
	struct spoolss_ResetPrinterEx r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_ResetPrinterEx, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_RESETPRINTEREX,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_ResetPrinterEx, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_RemoteFindFirstPrinterChangeNotifyEx(struct rpc_pipe_client *cli,
							     TALLOC_CTX *mem_ctx,
							     struct policy_handle *handle /* [in] [ref] */,
							     uint32_t flags /* [in]  */,
							     uint32_t options /* [in]  */,
							     const char *local_machine /* [in] [unique,charset(UTF16)] */,
							     uint32_t printer_local /* [in]  */,
							     struct spoolss_NotifyOption *notify_options /* [in] [unique] */,
							     WERROR *werror)
{
	struct spoolss_RemoteFindFirstPrinterChangeNotifyEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.flags = flags;
	r.in.options = options;
	r.in.local_machine = local_machine;
	r.in.printer_local = printer_local;
	r.in.notify_options = notify_options;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_RemoteFindFirstPrinterChangeNotifyEx, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_REMOTEFINDFIRSTPRINTERCHANGENOTIFYEX,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_RemoteFindFirstPrinterChangeNotifyEx, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_RouterReplyPrinterEx(struct rpc_pipe_client *cli,
					     TALLOC_CTX *mem_ctx,
					     struct policy_handle *handle /* [in] [ref] */,
					     uint32_t color /* [in]  */,
					     uint32_t flags /* [in]  */,
					     uint32_t *reply_result /* [out] [ref] */,
					     uint32_t reply_type /* [in]  */,
					     union spoolss_ReplyPrinterInfo info /* [in] [switch_is(reply_type)] */,
					     WERROR *werror)
{
	struct spoolss_RouterReplyPrinterEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.color = color;
	r.in.flags = flags;
	r.in.reply_type = reply_type;
	r.in.info = info;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_RouterReplyPrinterEx, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_ROUTERREPLYPRINTEREX,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_RouterReplyPrinterEx, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*reply_result = *r.out.reply_result;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_RouterRefreshPrinterChangeNotify(struct rpc_pipe_client *cli,
							 TALLOC_CTX *mem_ctx,
							 struct policy_handle *handle /* [in] [ref] */,
							 uint32_t change_low /* [in]  */,
							 struct spoolss_NotifyOption *options /* [in] [unique] */,
							 struct spoolss_NotifyInfo **info /* [out] [ref] */,
							 WERROR *werror)
{
	struct spoolss_RouterRefreshPrinterChangeNotify r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.change_low = change_low;
	r.in.options = options;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_RouterRefreshPrinterChangeNotify, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_ROUTERREFRESHPRINTERCHANGENOTIFY,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_RouterRefreshPrinterChangeNotify, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info = *r.out.info;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_44(struct rpc_pipe_client *cli,
			   TALLOC_CTX *mem_ctx,
			   WERROR *werror)
{
	struct spoolss_44 r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_44, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_44,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_44, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_OpenPrinterEx(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      const char *printername /* [in] [unique,charset(UTF16)] */,
				      const char *datatype /* [in] [unique,charset(UTF16)] */,
				      struct spoolss_DevmodeContainer devmode_ctr /* [in]  */,
				      uint32_t access_mask /* [in]  */,
				      uint32_t level /* [in]  */,
				      union spoolss_UserLevel userlevel /* [in] [switch_is(level)] */,
				      struct policy_handle *handle /* [out] [ref] */,
				      WERROR *werror)
{
	struct spoolss_OpenPrinterEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.printername = printername;
	r.in.datatype = datatype;
	r.in.devmode_ctr = devmode_ctr;
	r.in.access_mask = access_mask;
	r.in.level = level;
	r.in.userlevel = userlevel;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_OpenPrinterEx, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_OPENPRINTEREX,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_OpenPrinterEx, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*handle = *r.out.handle;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_AddPrinterEx(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     const char *server /* [in] [unique,charset(UTF16)] */,
				     struct spoolss_SetPrinterInfoCtr *info_ctr /* [in] [ref] */,
				     struct spoolss_DevmodeContainer *devmode_ctr /* [in] [ref] */,
				     struct sec_desc_buf *secdesc_ctr /* [in] [ref] */,
				     struct spoolss_UserLevelCtr *userlevel_ctr /* [in] [ref] */,
				     struct policy_handle *handle /* [out] [ref] */,
				     WERROR *werror)
{
	struct spoolss_AddPrinterEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.server = server;
	r.in.info_ctr = info_ctr;
	r.in.devmode_ctr = devmode_ctr;
	r.in.secdesc_ctr = secdesc_ctr;
	r.in.userlevel_ctr = userlevel_ctr;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_AddPrinterEx, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_ADDPRINTEREX,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_AddPrinterEx, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*handle = *r.out.handle;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_47(struct rpc_pipe_client *cli,
			   TALLOC_CTX *mem_ctx,
			   WERROR *werror)
{
	struct spoolss_47 r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_47, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_47,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_47, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_EnumPrinterData(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					struct policy_handle *handle /* [in] [ref] */,
					uint32_t enum_index /* [in]  */,
					const char *value_name /* [out] [charset(UTF16),size_is(value_offered/2)] */,
					uint32_t value_offered /* [in]  */,
					uint32_t *value_needed /* [out] [ref] */,
					enum winreg_Type *type /* [out] [ref] */,
					uint8_t *data /* [out] [ref,flag(LIBNDR_PRINT_ARRAY_HEX),size_is(data_offered)] */,
					uint32_t data_offered /* [in]  */,
					uint32_t *data_needed /* [out] [ref] */,
					WERROR *werror)
{
	struct spoolss_EnumPrinterData r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.enum_index = enum_index;
	r.in.value_offered = value_offered;
	r.in.data_offered = data_offered;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_EnumPrinterData, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_ENUMPRINTERDATA,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_EnumPrinterData, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	memcpy(discard_const_p(uint8_t *, value_name), r.out.value_name, (r.in.value_offered / 2) * sizeof(*value_name));
	*value_needed = *r.out.value_needed;
	*type = *r.out.type;
	memcpy(data, r.out.data, (r.in.data_offered) * sizeof(*data));
	*data_needed = *r.out.data_needed;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_DeletePrinterData(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  struct policy_handle *handle /* [in] [ref] */,
					  const char *value_name /* [in] [charset(UTF16)] */,
					  WERROR *werror)
{
	struct spoolss_DeletePrinterData r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.value_name = value_name;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_DeletePrinterData, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_DELETEPRINTERDATA,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_DeletePrinterData, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_4a(struct rpc_pipe_client *cli,
			   TALLOC_CTX *mem_ctx,
			   WERROR *werror)
{
	struct spoolss_4a r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_4a, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_4A,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_4a, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_4b(struct rpc_pipe_client *cli,
			   TALLOC_CTX *mem_ctx,
			   WERROR *werror)
{
	struct spoolss_4b r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_4b, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_4B,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_4b, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_4c(struct rpc_pipe_client *cli,
			   TALLOC_CTX *mem_ctx,
			   WERROR *werror)
{
	struct spoolss_4c r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_4c, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_4C,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_4c, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_SetPrinterDataEx(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle *handle /* [in] [ref] */,
					 const char *key_name /* [in] [charset(UTF16)] */,
					 const char *value_name /* [in] [charset(UTF16)] */,
					 enum winreg_Type type /* [in]  */,
					 uint8_t *buffer /* [in] [ref,size_is(offered)] */,
					 uint32_t offered /* [in]  */,
					 WERROR *werror)
{
	struct spoolss_SetPrinterDataEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.key_name = key_name;
	r.in.value_name = value_name;
	r.in.type = type;
	r.in.buffer = buffer;
	r.in.offered = offered;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_SetPrinterDataEx, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_SETPRINTERDATAEX,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_SetPrinterDataEx, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_GetPrinterDataEx(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle *handle /* [in] [ref] */,
					 const char *key_name /* [in] [charset(UTF16)] */,
					 const char *value_name /* [in] [charset(UTF16)] */,
					 enum winreg_Type *type /* [out] [ref] */,
					 uint8_t *buffer /* [out] [ref,size_is(offered)] */,
					 uint32_t offered /* [in]  */,
					 uint32_t *needed /* [out] [ref] */,
					 WERROR *werror)
{
	struct spoolss_GetPrinterDataEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.key_name = key_name;
	r.in.value_name = value_name;
	r.in.offered = offered;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_GetPrinterDataEx, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_GETPRINTERDATAEX,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_GetPrinterDataEx, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*type = *r.out.type;
	memcpy(buffer, r.out.buffer, (r.in.offered) * sizeof(*buffer));
	*needed = *r.out.needed;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_EnumPrinterDataEx(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  struct policy_handle *handle /* [in] [ref] */,
					  const char *key_name /* [in] [charset(UTF16)] */,
					  uint32_t offered /* [in]  */,
					  uint32_t *count /* [out] [ref] */,
					  struct spoolss_PrinterEnumValues **info /* [out] [ref,size_is(,*count)] */,
					  uint32_t *needed /* [out] [ref] */,
					  WERROR *werror)
{
	struct spoolss_EnumPrinterDataEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.key_name = key_name;
	r.in.offered = offered;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_EnumPrinterDataEx, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_ENUMPRINTERDATAEX,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_EnumPrinterDataEx, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*count = *r.out.count;
	*info = *r.out.info;
	*needed = *r.out.needed;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_EnumPrinterKey(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle *handle /* [in] [ref] */,
				       const char *key_name /* [in] [charset(UTF16)] */,
				       uint32_t *_ndr_size /* [out] [ref] */,
				       union spoolss_KeyNames *key_buffer /* [out] [subcontext_size(*_ndr_size*2),ref,subcontext(0),switch_is(*_ndr_size)] */,
				       uint32_t offered /* [in]  */,
				       uint32_t *needed /* [out] [ref] */,
				       WERROR *werror)
{
	struct spoolss_EnumPrinterKey r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.key_name = key_name;
	r.in.offered = offered;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_EnumPrinterKey, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_ENUMPRINTERKEY,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_EnumPrinterKey, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*_ndr_size = *r.out._ndr_size;
	*key_buffer = *r.out.key_buffer;
	*needed = *r.out.needed;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_DeletePrinterDataEx(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx,
					    struct policy_handle *handle /* [in] [ref] */,
					    const char *key_name /* [in] [charset(UTF16)] */,
					    const char *value_name /* [in] [charset(UTF16)] */,
					    WERROR *werror)
{
	struct spoolss_DeletePrinterDataEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.key_name = key_name;
	r.in.value_name = value_name;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_DeletePrinterDataEx, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_DELETEPRINTERDATAEX,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_DeletePrinterDataEx, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_DeletePrinterKey(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle *handle /* [in] [ref] */,
					 const char *key_name /* [in] [charset(UTF16)] */,
					 WERROR *werror)
{
	struct spoolss_DeletePrinterKey r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.key_name = key_name;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_DeletePrinterKey, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_DELETEPRINTERKEY,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_DeletePrinterKey, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_53(struct rpc_pipe_client *cli,
			   TALLOC_CTX *mem_ctx,
			   WERROR *werror)
{
	struct spoolss_53 r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_53, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_53,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_53, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_DeletePrinterDriverEx(struct rpc_pipe_client *cli,
					      TALLOC_CTX *mem_ctx,
					      const char *server /* [in] [unique,charset(UTF16)] */,
					      const char *architecture /* [in] [charset(UTF16)] */,
					      const char *driver /* [in] [charset(UTF16)] */,
					      uint32_t delete_flags /* [in]  */,
					      uint32_t version /* [in]  */,
					      WERROR *werror)
{
	struct spoolss_DeletePrinterDriverEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.server = server;
	r.in.architecture = architecture;
	r.in.driver = driver;
	r.in.delete_flags = delete_flags;
	r.in.version = version;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_DeletePrinterDriverEx, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_DELETEPRINTERDRIVEREX,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_DeletePrinterDriverEx, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_55(struct rpc_pipe_client *cli,
			   TALLOC_CTX *mem_ctx,
			   WERROR *werror)
{
	struct spoolss_55 r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_55, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_55,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_55, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_56(struct rpc_pipe_client *cli,
			   TALLOC_CTX *mem_ctx,
			   WERROR *werror)
{
	struct spoolss_56 r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_56, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_56,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_56, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_57(struct rpc_pipe_client *cli,
			   TALLOC_CTX *mem_ctx,
			   WERROR *werror)
{
	struct spoolss_57 r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_57, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_57,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_57, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_XcvData(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct policy_handle *handle /* [in] [ref] */,
				const char *function_name /* [in] [charset(UTF16)] */,
				DATA_BLOB in_data /* [in]  */,
				uint32_t _in_data_length /* [in] [value(r->in.in_data.length)] */,
				uint8_t *out_data /* [out] [ref,size_is(out_data_size)] */,
				uint32_t out_data_size /* [in]  */,
				uint32_t *needed /* [out] [ref] */,
				uint32_t *status_code /* [in,out] [ref] */,
				WERROR *werror)
{
	struct spoolss_XcvData r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.function_name = function_name;
	r.in.in_data = in_data;
	r.in._in_data_length = _in_data_length;
	r.in.out_data_size = out_data_size;
	r.in.status_code = status_code;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_XcvData, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_XCVDATA,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_XcvData, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	memcpy(out_data, r.out.out_data, (r.in.out_data_size) * sizeof(*out_data));
	*needed = *r.out.needed;
	*status_code = *r.out.status_code;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_AddPrinterDriverEx(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   const char *servername /* [in] [unique,charset(UTF16)] */,
					   struct spoolss_AddDriverInfoCtr *info_ctr /* [in] [ref] */,
					   uint32_t flags /* [in]  */,
					   WERROR *werror)
{
	struct spoolss_AddPrinterDriverEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = servername;
	r.in.info_ctr = info_ctr;
	r.in.flags = flags;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_AddPrinterDriverEx, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_ADDPRINTERDRIVEREX,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_AddPrinterDriverEx, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_5a(struct rpc_pipe_client *cli,
			   TALLOC_CTX *mem_ctx,
			   WERROR *werror)
{
	struct spoolss_5a r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_5a, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_5A,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_5a, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_5b(struct rpc_pipe_client *cli,
			   TALLOC_CTX *mem_ctx,
			   WERROR *werror)
{
	struct spoolss_5b r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_5b, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_5B,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_5b, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_5c(struct rpc_pipe_client *cli,
			   TALLOC_CTX *mem_ctx,
			   WERROR *werror)
{
	struct spoolss_5c r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_5c, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_5C,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_5c, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_5d(struct rpc_pipe_client *cli,
			   TALLOC_CTX *mem_ctx,
			   WERROR *werror)
{
	struct spoolss_5d r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_5d, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_5D,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_5d, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_5e(struct rpc_pipe_client *cli,
			   TALLOC_CTX *mem_ctx,
			   WERROR *werror)
{
	struct spoolss_5e r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_5e, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_5E,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_5e, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_spoolss_5f(struct rpc_pipe_client *cli,
			   TALLOC_CTX *mem_ctx,
			   WERROR *werror)
{
	struct spoolss_5f r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(spoolss_5f, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_spoolss,
				NDR_SPOOLSS_5F,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(spoolss_5f, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

