/* parser auto-generated by pidl */

#include "includes.h"
#include "../librpc/gen_ndr/ndr_spoolss.h"

#include "librpc/gen_ndr/ndr_misc.h"
#include "librpc/gen_ndr/ndr_security.h"
#include "librpc/gen_ndr/ndr_winreg.h"
static enum ndr_err_code ndr_push_spoolss_Time(struct ndr_push *ndr, int ndr_flags, const struct spoolss_Time *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 2));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->year));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->month));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->day_of_week));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->day));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->hour));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->minute));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->second));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->millisecond));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_Time(struct ndr_pull *ndr, int ndr_flags, struct spoolss_Time *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 2));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->year));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->month));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->day_of_week));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->day));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->hour));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->minute));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->second));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->millisecond));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_Time(struct ndr_print *ndr, const char *name, const struct spoolss_Time *r)
{
	ndr_print_struct(ndr, name, "spoolss_Time");
	ndr->depth++;
	ndr_print_uint16(ndr, "year", r->year);
	ndr_print_uint16(ndr, "month", r->month);
	ndr_print_uint16(ndr, "day_of_week", r->day_of_week);
	ndr_print_uint16(ndr, "day", r->day);
	ndr_print_uint16(ndr, "hour", r->hour);
	ndr_print_uint16(ndr, "minute", r->minute);
	ndr_print_uint16(ndr, "second", r->second);
	ndr_print_uint16(ndr, "millisecond", r->millisecond);
	ndr->depth--;
}

static size_t ndr_size_spoolss_Time(const struct spoolss_Time *r, struct smb_iconv_convenience *ic, int flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_spoolss_Time, ic);
}

static enum ndr_err_code ndr_push_spoolss_TimeCtr(struct ndr_push *ndr, int ndr_flags, const struct spoolss_TimeCtr *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_size_spoolss_Time(r->time, ndr->iconv_convenience, ndr->flags)));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->time));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->time) {
			NDR_CHECK(ndr_push_spoolss_Time(ndr, NDR_SCALARS, r->time));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_TimeCtr(struct ndr_pull *ndr, int ndr_flags, struct spoolss_TimeCtr *r)
{
	uint32_t _ptr_time;
	TALLOC_CTX *_mem_save_time_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_time));
		if (_ptr_time) {
			NDR_PULL_ALLOC(ndr, r->time);
		} else {
			r->time = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->time) {
			_mem_save_time_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->time, 0);
			NDR_CHECK(ndr_pull_spoolss_Time(ndr, NDR_SCALARS, r->time));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_time_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_TimeCtr(struct ndr_print *ndr, const char *name, const struct spoolss_TimeCtr *r)
{
	ndr_print_struct(ndr, name, "spoolss_TimeCtr");
	ndr->depth++;
	ndr_print_uint32(ndr, "size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_spoolss_Time(r->time, ndr->iconv_convenience, ndr->flags):r->size);
	ndr_print_ptr(ndr, "time", r->time);
	ndr->depth++;
	if (r->time) {
		ndr_print_spoolss_Time(ndr, "time", r->time);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_ProcessorArchitecture(struct ndr_push *ndr, int ndr_flags, enum spoolss_ProcessorArchitecture r)
{
	NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_ProcessorArchitecture(struct ndr_pull *ndr, int ndr_flags, enum spoolss_ProcessorArchitecture *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_ProcessorArchitecture(struct ndr_print *ndr, const char *name, enum spoolss_ProcessorArchitecture r)
{
	const char *val = NULL;

	switch (r) {
		case PROCESSOR_ARCHITECTURE_INTEL: val = "PROCESSOR_ARCHITECTURE_INTEL"; break;
		case PROCESSOR_ARCHITECTURE_IA64: val = "PROCESSOR_ARCHITECTURE_IA64"; break;
		case PROCESSOR_ARCHITECTURE_AMD64: val = "PROCESSOR_ARCHITECTURE_AMD64"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_spoolss_ProcessorType(struct ndr_push *ndr, int ndr_flags, enum spoolss_ProcessorType r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_ProcessorType(struct ndr_pull *ndr, int ndr_flags, enum spoolss_ProcessorType *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_ProcessorType(struct ndr_print *ndr, const char *name, enum spoolss_ProcessorType r)
{
	const char *val = NULL;

	switch (r) {
		case PROCESSOR_INTEL_386: val = "PROCESSOR_INTEL_386"; break;
		case PROCESSOR_INTEL_486: val = "PROCESSOR_INTEL_486"; break;
		case PROCESSOR_INTEL_PENTIUM: val = "PROCESSOR_INTEL_PENTIUM"; break;
		case PROCESSOR_INTEL_IA64: val = "PROCESSOR_INTEL_IA64"; break;
		case PROCESSOR_AMD_X8664: val = "PROCESSOR_AMD_X8664"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_spoolss_MajorVersion(struct ndr_push *ndr, int ndr_flags, enum spoolss_MajorVersion r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_MajorVersion(struct ndr_pull *ndr, int ndr_flags, enum spoolss_MajorVersion *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_MajorVersion(struct ndr_print *ndr, const char *name, enum spoolss_MajorVersion r)
{
	const char *val = NULL;

	switch (r) {
		case SPOOLSS_MAJOR_VERSION_NT4_95_98_ME: val = "SPOOLSS_MAJOR_VERSION_NT4_95_98_ME"; break;
		case SPOOLSS_MAJOR_VERSION_2000_2003_XP: val = "SPOOLSS_MAJOR_VERSION_2000_2003_XP"; break;
		case SPOOLSS_MAJOR_VERSION_2008_VISTA: val = "SPOOLSS_MAJOR_VERSION_2008_VISTA"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_spoolss_MinorVersion(struct ndr_push *ndr, int ndr_flags, enum spoolss_MinorVersion r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_MinorVersion(struct ndr_pull *ndr, int ndr_flags, enum spoolss_MinorVersion *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_MinorVersion(struct ndr_print *ndr, const char *name, enum spoolss_MinorVersion r)
{
	const char *val = NULL;

	switch (r) {
		case SPOOLSS_MINOR_VERSION_0: val = "SPOOLSS_MINOR_VERSION_0"; break;
		case SPOOLSS_MINOR_VERSION_XP: val = "SPOOLSS_MINOR_VERSION_XP"; break;
		case SPOOLSS_MINOR_VERSION_2003_XP64: val = "SPOOLSS_MINOR_VERSION_2003_XP64"; break;
		case SPOOLSS_MINOR_VERSION_98: val = "SPOOLSS_MINOR_VERSION_98"; break;
		case SPOOLSS_MINOR_VERSION_ME: val = "SPOOLSS_MINOR_VERSION_ME"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_spoolss_PrinterStatus(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_PrinterStatus(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_PrinterStatus(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_STATUS_PAUSED", PRINTER_STATUS_PAUSED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_STATUS_ERROR", PRINTER_STATUS_ERROR, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_STATUS_PENDING_DELETION", PRINTER_STATUS_PENDING_DELETION, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_STATUS_PAPER_JAM", PRINTER_STATUS_PAPER_JAM, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_STATUS_PAPER_OUT", PRINTER_STATUS_PAPER_OUT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_STATUS_MANUAL_FEED", PRINTER_STATUS_MANUAL_FEED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_STATUS_PAPER_PROBLEM", PRINTER_STATUS_PAPER_PROBLEM, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_STATUS_OFFLINE", PRINTER_STATUS_OFFLINE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_STATUS_IO_ACTIVE", PRINTER_STATUS_IO_ACTIVE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_STATUS_BUSY", PRINTER_STATUS_BUSY, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_STATUS_PRINTING", PRINTER_STATUS_PRINTING, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_STATUS_OUTPUT_BIN_FULL", PRINTER_STATUS_OUTPUT_BIN_FULL, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_STATUS_NOT_AVAILABLE", PRINTER_STATUS_NOT_AVAILABLE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_STATUS_WAITING", PRINTER_STATUS_WAITING, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_STATUS_PROCESSING", PRINTER_STATUS_PROCESSING, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_STATUS_INITIALIZING", PRINTER_STATUS_INITIALIZING, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_STATUS_WARMING_UP", PRINTER_STATUS_WARMING_UP, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_STATUS_TONER_LOW", PRINTER_STATUS_TONER_LOW, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_STATUS_NO_TONER", PRINTER_STATUS_NO_TONER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_STATUS_PAGE_PUNT", PRINTER_STATUS_PAGE_PUNT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_STATUS_USER_INTERVENTION", PRINTER_STATUS_USER_INTERVENTION, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_STATUS_OUT_OF_MEMORY", PRINTER_STATUS_OUT_OF_MEMORY, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_STATUS_DOOR_OPEN", PRINTER_STATUS_DOOR_OPEN, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_STATUS_SERVER_UNKNOWN", PRINTER_STATUS_SERVER_UNKNOWN, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_STATUS_POWER_SAVE", PRINTER_STATUS_POWER_SAVE, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_JobStatus(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_JobStatus(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_JobStatus(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "JOB_STATUS_PAUSED", JOB_STATUS_PAUSED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "JOB_STATUS_ERROR", JOB_STATUS_ERROR, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "JOB_STATUS_DELETING", JOB_STATUS_DELETING, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "JOB_STATUS_SPOOLING", JOB_STATUS_SPOOLING, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "JOB_STATUS_PRINTING", JOB_STATUS_PRINTING, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "JOB_STATUS_OFFLINE", JOB_STATUS_OFFLINE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "JOB_STATUS_PAPEROUT", JOB_STATUS_PAPEROUT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "JOB_STATUS_PRINTED", JOB_STATUS_PRINTED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "JOB_STATUS_DELETED", JOB_STATUS_DELETED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "JOB_STATUS_BLOCKED_DEVQ", JOB_STATUS_BLOCKED_DEVQ, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "JOB_STATUS_USER_INTERVENTION", JOB_STATUS_USER_INTERVENTION, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "JOB_STATUS_RESTART", JOB_STATUS_RESTART, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "JOB_STATUS_COMPLETE", JOB_STATUS_COMPLETE, r);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_PrinterInfo0(struct ndr_push *ndr, int ndr_flags, const struct spoolss_PrinterInfo0 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->printername));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->servername));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->cjobs));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->total_jobs));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->total_bytes));
		NDR_CHECK(ndr_push_spoolss_Time(ndr, NDR_SCALARS, &r->time));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->global_counter));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->total_pages));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->free_build));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->spooling));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->max_spooling));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->session_counter));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_error_out_of_paper));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_error_not_ready));
		NDR_CHECK(ndr_push_spoolss_JobStatus(ndr, NDR_SCALARS, r->job_error));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->number_of_processors));
		NDR_CHECK(ndr_push_spoolss_ProcessorType(ndr, NDR_SCALARS, r->processor_type));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->high_part_total_bytes));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->change_id));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->last_error));
		NDR_CHECK(ndr_push_spoolss_PrinterStatus(ndr, NDR_SCALARS, r->status));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->enumerate_network_printers));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->c_setprinter));
		NDR_CHECK(ndr_push_spoolss_ProcessorArchitecture(ndr, NDR_SCALARS, r->processor_architecture));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->processor_level));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->ref_ic));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->reserved2));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->reserved3));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->printername) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->printername));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->printername));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->servername) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->servername));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->servername));
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_PrinterInfo0(struct ndr_pull *ndr, int ndr_flags, struct spoolss_PrinterInfo0 *r)
{
	uint32_t _ptr_printername;
	TALLOC_CTX *_mem_save_printername_0;
	uint32_t _ptr_servername;
	TALLOC_CTX *_mem_save_servername_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_printername));
			if (_ptr_printername) {
				NDR_PULL_ALLOC(ndr, r->printername);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->printername, _ptr_printername));
			} else {
				r->printername = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_servername));
			if (_ptr_servername) {
				NDR_PULL_ALLOC(ndr, r->servername);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->servername, _ptr_servername));
			} else {
				r->servername = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->cjobs));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->total_jobs));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->total_bytes));
		NDR_CHECK(ndr_pull_spoolss_Time(ndr, NDR_SCALARS, &r->time));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->global_counter));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->total_pages));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->free_build));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->spooling));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->max_spooling));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->session_counter));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_error_out_of_paper));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_error_not_ready));
		NDR_CHECK(ndr_pull_spoolss_JobStatus(ndr, NDR_SCALARS, &r->job_error));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->number_of_processors));
		NDR_CHECK(ndr_pull_spoolss_ProcessorType(ndr, NDR_SCALARS, &r->processor_type));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->high_part_total_bytes));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->change_id));
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->last_error));
		NDR_CHECK(ndr_pull_spoolss_PrinterStatus(ndr, NDR_SCALARS, &r->status));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->enumerate_network_printers));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->c_setprinter));
		NDR_CHECK(ndr_pull_spoolss_ProcessorArchitecture(ndr, NDR_SCALARS, &r->processor_architecture));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->processor_level));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->ref_ic));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved2));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved3));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->printername) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->printername));
				_mem_save_printername_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->printername, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->printername));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_printername_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->servername) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->servername));
				_mem_save_servername_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->servername, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->servername));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_servername_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_PrinterInfo0(struct ndr_print *ndr, const char *name, const struct spoolss_PrinterInfo0 *r)
{
	ndr_print_struct(ndr, name, "spoolss_PrinterInfo0");
	ndr->depth++;
	ndr_print_ptr(ndr, "printername", r->printername);
	ndr->depth++;
	if (r->printername) {
		ndr_print_string(ndr, "printername", r->printername);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "servername", r->servername);
	ndr->depth++;
	if (r->servername) {
		ndr_print_string(ndr, "servername", r->servername);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "cjobs", r->cjobs);
	ndr_print_uint32(ndr, "total_jobs", r->total_jobs);
	ndr_print_uint32(ndr, "total_bytes", r->total_bytes);
	ndr_print_spoolss_Time(ndr, "time", &r->time);
	ndr_print_uint32(ndr, "global_counter", r->global_counter);
	ndr_print_uint32(ndr, "total_pages", r->total_pages);
	ndr_print_uint32(ndr, "version", r->version);
	ndr_print_uint32(ndr, "free_build", r->free_build);
	ndr_print_uint32(ndr, "spooling", r->spooling);
	ndr_print_uint32(ndr, "max_spooling", r->max_spooling);
	ndr_print_uint32(ndr, "session_counter", r->session_counter);
	ndr_print_uint32(ndr, "num_error_out_of_paper", r->num_error_out_of_paper);
	ndr_print_uint32(ndr, "num_error_not_ready", r->num_error_not_ready);
	ndr_print_spoolss_JobStatus(ndr, "job_error", r->job_error);
	ndr_print_uint32(ndr, "number_of_processors", r->number_of_processors);
	ndr_print_spoolss_ProcessorType(ndr, "processor_type", r->processor_type);
	ndr_print_uint32(ndr, "high_part_total_bytes", r->high_part_total_bytes);
	ndr_print_uint32(ndr, "change_id", r->change_id);
	ndr_print_WERROR(ndr, "last_error", r->last_error);
	ndr_print_spoolss_PrinterStatus(ndr, "status", r->status);
	ndr_print_uint32(ndr, "enumerate_network_printers", r->enumerate_network_printers);
	ndr_print_uint32(ndr, "c_setprinter", r->c_setprinter);
	ndr_print_spoolss_ProcessorArchitecture(ndr, "processor_architecture", r->processor_architecture);
	ndr_print_uint16(ndr, "processor_level", r->processor_level);
	ndr_print_uint32(ndr, "ref_ic", r->ref_ic);
	ndr_print_uint32(ndr, "reserved2", r->reserved2);
	ndr_print_uint32(ndr, "reserved3", r->reserved3);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_spoolss_PrinterInfo0(const struct spoolss_PrinterInfo0 *r, struct smb_iconv_convenience *ic, int flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_spoolss_PrinterInfo0, ic);
}

static enum ndr_err_code ndr_push_spoolss_DeviceModeFields(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_DeviceModeFields(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_DeviceModeFields(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DEVMODE_ORIENTATION", DEVMODE_ORIENTATION, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DEVMODE_PAPERSIZE", DEVMODE_PAPERSIZE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DEVMODE_PAPERLENGTH", DEVMODE_PAPERLENGTH, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DEVMODE_PAPERWIDTH", DEVMODE_PAPERWIDTH, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DEVMODE_SCALE", DEVMODE_SCALE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DEVMODE_POSITION", DEVMODE_POSITION, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DEVMODE_NUP", DEVMODE_NUP, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DEVMODE_COPIES", DEVMODE_COPIES, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DEVMODE_DEFAULTSOURCE", DEVMODE_DEFAULTSOURCE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DEVMODE_PRINTQUALITY", DEVMODE_PRINTQUALITY, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DEVMODE_COLOR", DEVMODE_COLOR, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DEVMODE_DUPLEX", DEVMODE_DUPLEX, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DEVMODE_YRESOLUTION", DEVMODE_YRESOLUTION, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DEVMODE_TTOPTION", DEVMODE_TTOPTION, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DEVMODE_COLLATE", DEVMODE_COLLATE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DEVMODE_FORMNAME", DEVMODE_FORMNAME, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DEVMODE_LOGPIXELS", DEVMODE_LOGPIXELS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DEVMODE_BITSPERPEL", DEVMODE_BITSPERPEL, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DEVMODE_PELSWIDTH", DEVMODE_PELSWIDTH, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DEVMODE_PELSHEIGHT", DEVMODE_PELSHEIGHT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DEVMODE_DISPLAYFLAGS", DEVMODE_DISPLAYFLAGS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DEVMODE_DISPLAYFREQUENCY", DEVMODE_DISPLAYFREQUENCY, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DEVMODE_ICMMETHOD", DEVMODE_ICMMETHOD, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DEVMODE_ICMINTENT", DEVMODE_ICMINTENT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DEVMODE_MEDIATYPE", DEVMODE_MEDIATYPE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DEVMODE_DITHERTYPE", DEVMODE_DITHERTYPE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DEVMODE_PANNINGWIDTH", DEVMODE_PANNINGWIDTH, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DEVMODE_PANNINGHEIGHT", DEVMODE_PANNINGHEIGHT, r);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_DeviceMode(struct ndr_push *ndr, int ndr_flags, const struct spoolss_DeviceMode *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->devicename, 32, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->specversion));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->driverversion));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->size));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->driverextra_data.length));
		NDR_CHECK(ndr_push_spoolss_DeviceModeFields(ndr, NDR_SCALARS, r->fields));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->orientation));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->papersize));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->paperlength));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->paperwidth));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->scale));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->copies));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->defaultsource));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->printquality));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->color));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->duplex));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->yresolution));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->ttoption));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->collate));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->formname, 32, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->logpixels));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->bitsperpel));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->pelswidth));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->pelsheight));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->displayflags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->displayfrequency));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->icmmethod));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->icmintent));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->mediatype));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dithertype));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->reserved1));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->reserved2));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->panningwidth));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->panningheight));
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			{
				struct ndr_push *_ndr_driverextra_data;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_driverextra_data, 0, r->driverextra_data.length));
				NDR_CHECK(ndr_push_DATA_BLOB(_ndr_driverextra_data, NDR_SCALARS, r->driverextra_data));
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_driverextra_data, 0, r->driverextra_data.length));
			}
			ndr->flags = _flags_save_DATA_BLOB;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_DeviceMode(struct ndr_pull *ndr, int ndr_flags, struct spoolss_DeviceMode *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->devicename, 32, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->specversion));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->driverversion));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->__driverextra_length));
		NDR_CHECK(ndr_pull_spoolss_DeviceModeFields(ndr, NDR_SCALARS, &r->fields));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->orientation));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->papersize));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->paperlength));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->paperwidth));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->scale));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->copies));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->defaultsource));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->printquality));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->color));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->duplex));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->yresolution));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->ttoption));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->collate));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->formname, 32, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->logpixels));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->bitsperpel));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->pelswidth));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->pelsheight));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->displayflags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->displayfrequency));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->icmmethod));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->icmintent));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->mediatype));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dithertype));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved2));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->panningwidth));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->panningheight));
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			{
				struct ndr_pull *_ndr_driverextra_data;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_driverextra_data, 0, r->__driverextra_length));
				NDR_CHECK(ndr_pull_DATA_BLOB(_ndr_driverextra_data, NDR_SCALARS, &r->driverextra_data));
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_driverextra_data, 0, r->__driverextra_length));
			}
			ndr->flags = _flags_save_DATA_BLOB;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_DeviceMode(struct ndr_print *ndr, const char *name, const struct spoolss_DeviceMode *r)
{
	ndr_print_struct(ndr, name, "spoolss_DeviceMode");
	ndr->depth++;
	ndr_print_string(ndr, "devicename", r->devicename);
	ndr_print_uint16(ndr, "specversion", r->specversion);
	ndr_print_uint16(ndr, "driverversion", r->driverversion);
	ndr_print_uint16(ndr, "size", r->size);
	ndr_print_uint16(ndr, "__driverextra_length", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?r->driverextra_data.length:r->__driverextra_length);
	ndr_print_spoolss_DeviceModeFields(ndr, "fields", r->fields);
	ndr_print_uint16(ndr, "orientation", r->orientation);
	ndr_print_uint16(ndr, "papersize", r->papersize);
	ndr_print_uint16(ndr, "paperlength", r->paperlength);
	ndr_print_uint16(ndr, "paperwidth", r->paperwidth);
	ndr_print_uint16(ndr, "scale", r->scale);
	ndr_print_uint16(ndr, "copies", r->copies);
	ndr_print_uint16(ndr, "defaultsource", r->defaultsource);
	ndr_print_uint16(ndr, "printquality", r->printquality);
	ndr_print_uint16(ndr, "color", r->color);
	ndr_print_uint16(ndr, "duplex", r->duplex);
	ndr_print_uint16(ndr, "yresolution", r->yresolution);
	ndr_print_uint16(ndr, "ttoption", r->ttoption);
	ndr_print_uint16(ndr, "collate", r->collate);
	ndr_print_string(ndr, "formname", r->formname);
	ndr_print_uint16(ndr, "logpixels", r->logpixels);
	ndr_print_uint32(ndr, "bitsperpel", r->bitsperpel);
	ndr_print_uint32(ndr, "pelswidth", r->pelswidth);
	ndr_print_uint32(ndr, "pelsheight", r->pelsheight);
	ndr_print_uint32(ndr, "displayflags", r->displayflags);
	ndr_print_uint32(ndr, "displayfrequency", r->displayfrequency);
	ndr_print_uint32(ndr, "icmmethod", r->icmmethod);
	ndr_print_uint32(ndr, "icmintent", r->icmintent);
	ndr_print_uint32(ndr, "mediatype", r->mediatype);
	ndr_print_uint32(ndr, "dithertype", r->dithertype);
	ndr_print_uint32(ndr, "reserved1", r->reserved1);
	ndr_print_uint32(ndr, "reserved2", r->reserved2);
	ndr_print_uint32(ndr, "panningwidth", r->panningwidth);
	ndr_print_uint32(ndr, "panningheight", r->panningheight);
	ndr_print_DATA_BLOB(ndr, "driverextra_data", r->driverextra_data);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_spoolss_DeviceMode(const struct spoolss_DeviceMode *r, struct smb_iconv_convenience *ic, int flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_spoolss_DeviceMode, ic);
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_EnumPrinterFlags(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_EnumPrinterFlags(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_EnumPrinterFlags(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_ENUM_DEFAULT", PRINTER_ENUM_DEFAULT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_ENUM_LOCAL", PRINTER_ENUM_LOCAL, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_ENUM_CONNECTIONS", PRINTER_ENUM_CONNECTIONS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_ENUM_FAVORITE", PRINTER_ENUM_FAVORITE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_ENUM_NAME", PRINTER_ENUM_NAME, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_ENUM_REMOTE", PRINTER_ENUM_REMOTE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_ENUM_SHARED", PRINTER_ENUM_SHARED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_ENUM_NETWORK", PRINTER_ENUM_NETWORK, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_ENUM_EXPAND", PRINTER_ENUM_EXPAND, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_ENUM_CONTAINER", PRINTER_ENUM_CONTAINER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_ENUM_ICON1", PRINTER_ENUM_ICON1, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_ENUM_ICON2", PRINTER_ENUM_ICON2, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_ENUM_ICON3", PRINTER_ENUM_ICON3, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_ENUM_ICON4", PRINTER_ENUM_ICON4, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_ENUM_ICON5", PRINTER_ENUM_ICON5, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_ENUM_ICON6", PRINTER_ENUM_ICON6, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_ENUM_ICON7", PRINTER_ENUM_ICON7, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_ENUM_ICON8", PRINTER_ENUM_ICON8, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_ENUM_HIDE", PRINTER_ENUM_HIDE, r);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_PrinterInfo1(struct ndr_push *ndr, int ndr_flags, const struct spoolss_PrinterInfo1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_spoolss_EnumPrinterFlags(ndr, NDR_SCALARS, r->flags));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->description));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->comment));
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->description) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->description));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->description));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->name) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->name));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->comment) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->comment));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->comment));
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_PrinterInfo1(struct ndr_pull *ndr, int ndr_flags, struct spoolss_PrinterInfo1 *r)
{
	uint32_t _ptr_description;
	TALLOC_CTX *_mem_save_description_0;
	uint32_t _ptr_name;
	TALLOC_CTX *_mem_save_name_0;
	uint32_t _ptr_comment;
	TALLOC_CTX *_mem_save_comment_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_spoolss_EnumPrinterFlags(ndr, NDR_SCALARS, &r->flags));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_description));
			if (_ptr_description) {
				NDR_PULL_ALLOC(ndr, r->description);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->description, _ptr_description));
			} else {
				r->description = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_name));
			if (_ptr_name) {
				NDR_PULL_ALLOC(ndr, r->name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->name, _ptr_name));
			} else {
				r->name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_comment));
			if (_ptr_comment) {
				NDR_PULL_ALLOC(ndr, r->comment);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->comment, _ptr_comment));
			} else {
				r->comment = NULL;
			}
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->description) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->description));
				_mem_save_description_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->description, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->description));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_description_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->name));
				_mem_save_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->comment) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->comment));
				_mem_save_comment_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->comment, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->comment));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_comment_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_PrinterInfo1(struct ndr_print *ndr, const char *name, const struct spoolss_PrinterInfo1 *r)
{
	ndr_print_struct(ndr, name, "spoolss_PrinterInfo1");
	ndr->depth++;
	ndr_print_spoolss_EnumPrinterFlags(ndr, "flags", r->flags);
	ndr_print_ptr(ndr, "description", r->description);
	ndr->depth++;
	if (r->description) {
		ndr_print_string(ndr, "description", r->description);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "name", r->name);
	ndr->depth++;
	if (r->name) {
		ndr_print_string(ndr, "name", r->name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "comment", r->comment);
	ndr->depth++;
	if (r->comment) {
		ndr_print_string(ndr, "comment", r->comment);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_spoolss_PrinterInfo1(const struct spoolss_PrinterInfo1 *r, struct smb_iconv_convenience *ic, int flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_spoolss_PrinterInfo1, ic);
}

static enum ndr_err_code ndr_push_spoolss_PrinterAttributes(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_PrinterAttributes(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_PrinterAttributes(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_ATTRIBUTE_QUEUED", PRINTER_ATTRIBUTE_QUEUED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_ATTRIBUTE_DIRECT", PRINTER_ATTRIBUTE_DIRECT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_ATTRIBUTE_DEFAULT", PRINTER_ATTRIBUTE_DEFAULT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_ATTRIBUTE_SHARED", PRINTER_ATTRIBUTE_SHARED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_ATTRIBUTE_NETWORK", PRINTER_ATTRIBUTE_NETWORK, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_ATTRIBUTE_HIDDEN", PRINTER_ATTRIBUTE_HIDDEN, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_ATTRIBUTE_LOCAL", PRINTER_ATTRIBUTE_LOCAL, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_ATTRIBUTE_ENABLE_DEVQ", PRINTER_ATTRIBUTE_ENABLE_DEVQ, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_ATTRIBUTE_KEEPPRINTEDJOBS", PRINTER_ATTRIBUTE_KEEPPRINTEDJOBS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_ATTRIBUTE_DO_COMPLETE_FIRST", PRINTER_ATTRIBUTE_DO_COMPLETE_FIRST, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_ATTRIBUTE_WORK_OFFLINE", PRINTER_ATTRIBUTE_WORK_OFFLINE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_ATTRIBUTE_ENABLE_BIDI", PRINTER_ATTRIBUTE_ENABLE_BIDI, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_ATTRIBUTE_RAW_ONLY", PRINTER_ATTRIBUTE_RAW_ONLY, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_ATTRIBUTE_PUBLISHED", PRINTER_ATTRIBUTE_PUBLISHED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_ATTRIBUTE_FAX", PRINTER_ATTRIBUTE_FAX, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_ATTRIBUTE_TS", PRINTER_ATTRIBUTE_TS, r);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_PrinterInfo2(struct ndr_push *ndr, int ndr_flags, const struct spoolss_PrinterInfo2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->servername));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->printername));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->sharename));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->portname));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->drivername));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->comment));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->location));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_relative_ptr1(ndr, r->devmode));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->sepfile));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->printprocessor));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->datatype));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->parameters));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_relative_ptr1(ndr, r->secdesc));
		NDR_CHECK(ndr_push_spoolss_PrinterAttributes(ndr, NDR_SCALARS, r->attributes));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->priority));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->defaultpriority));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->starttime));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->untiltime));
		NDR_CHECK(ndr_push_spoolss_PrinterStatus(ndr, NDR_SCALARS, r->status));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->cjobs));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->averageppm));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->servername) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->servername));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->servername));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->printername) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->printername));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->printername));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->sharename) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->sharename));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->sharename));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->portname) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->portname));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->portname));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->drivername) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->drivername));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->drivername));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->comment) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->comment));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->comment));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->location) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->location));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->location));
			}
			ndr->flags = _flags_save_string;
		}
		if (r->devmode) {
			NDR_CHECK(ndr_push_relative_ptr2(ndr, r->devmode));
			{
				struct ndr_push *_ndr_devmode;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_devmode, 0, -1));
				NDR_CHECK(ndr_push_spoolss_DeviceMode(_ndr_devmode, NDR_SCALARS, r->devmode));
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_devmode, 0, -1));
			}
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->sepfile) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->sepfile));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->sepfile));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->printprocessor) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->printprocessor));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->printprocessor));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->datatype) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->datatype));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->datatype));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->parameters) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->parameters));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->parameters));
			}
			ndr->flags = _flags_save_string;
		}
		if (r->secdesc) {
			NDR_CHECK(ndr_push_relative_ptr2(ndr, r->secdesc));
			{
				struct ndr_push *_ndr_secdesc;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_secdesc, 0, -1));
				NDR_CHECK(ndr_push_security_descriptor(_ndr_secdesc, NDR_SCALARS|NDR_BUFFERS, r->secdesc));
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_secdesc, 0, -1));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_PrinterInfo2(struct ndr_pull *ndr, int ndr_flags, struct spoolss_PrinterInfo2 *r)
{
	uint32_t _ptr_servername;
	TALLOC_CTX *_mem_save_servername_0;
	uint32_t _ptr_printername;
	TALLOC_CTX *_mem_save_printername_0;
	uint32_t _ptr_sharename;
	TALLOC_CTX *_mem_save_sharename_0;
	uint32_t _ptr_portname;
	TALLOC_CTX *_mem_save_portname_0;
	uint32_t _ptr_drivername;
	TALLOC_CTX *_mem_save_drivername_0;
	uint32_t _ptr_comment;
	TALLOC_CTX *_mem_save_comment_0;
	uint32_t _ptr_location;
	TALLOC_CTX *_mem_save_location_0;
	uint32_t _ptr_devmode;
	TALLOC_CTX *_mem_save_devmode_0;
	uint32_t _ptr_sepfile;
	TALLOC_CTX *_mem_save_sepfile_0;
	uint32_t _ptr_printprocessor;
	TALLOC_CTX *_mem_save_printprocessor_0;
	uint32_t _ptr_datatype;
	TALLOC_CTX *_mem_save_datatype_0;
	uint32_t _ptr_parameters;
	TALLOC_CTX *_mem_save_parameters_0;
	uint32_t _ptr_secdesc;
	TALLOC_CTX *_mem_save_secdesc_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_servername));
			if (_ptr_servername) {
				NDR_PULL_ALLOC(ndr, r->servername);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->servername, _ptr_servername));
			} else {
				r->servername = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_printername));
			if (_ptr_printername) {
				NDR_PULL_ALLOC(ndr, r->printername);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->printername, _ptr_printername));
			} else {
				r->printername = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sharename));
			if (_ptr_sharename) {
				NDR_PULL_ALLOC(ndr, r->sharename);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->sharename, _ptr_sharename));
			} else {
				r->sharename = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_portname));
			if (_ptr_portname) {
				NDR_PULL_ALLOC(ndr, r->portname);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->portname, _ptr_portname));
			} else {
				r->portname = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_drivername));
			if (_ptr_drivername) {
				NDR_PULL_ALLOC(ndr, r->drivername);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->drivername, _ptr_drivername));
			} else {
				r->drivername = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_comment));
			if (_ptr_comment) {
				NDR_PULL_ALLOC(ndr, r->comment);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->comment, _ptr_comment));
			} else {
				r->comment = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_location));
			if (_ptr_location) {
				NDR_PULL_ALLOC(ndr, r->location);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->location, _ptr_location));
			} else {
				r->location = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_devmode));
		if (_ptr_devmode) {
			NDR_PULL_ALLOC(ndr, r->devmode);
			NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->devmode, _ptr_devmode));
		} else {
			r->devmode = NULL;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sepfile));
			if (_ptr_sepfile) {
				NDR_PULL_ALLOC(ndr, r->sepfile);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->sepfile, _ptr_sepfile));
			} else {
				r->sepfile = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_printprocessor));
			if (_ptr_printprocessor) {
				NDR_PULL_ALLOC(ndr, r->printprocessor);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->printprocessor, _ptr_printprocessor));
			} else {
				r->printprocessor = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_datatype));
			if (_ptr_datatype) {
				NDR_PULL_ALLOC(ndr, r->datatype);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->datatype, _ptr_datatype));
			} else {
				r->datatype = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_parameters));
			if (_ptr_parameters) {
				NDR_PULL_ALLOC(ndr, r->parameters);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->parameters, _ptr_parameters));
			} else {
				r->parameters = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_secdesc));
		if (_ptr_secdesc) {
			NDR_PULL_ALLOC(ndr, r->secdesc);
			NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->secdesc, _ptr_secdesc));
		} else {
			r->secdesc = NULL;
		}
		NDR_CHECK(ndr_pull_spoolss_PrinterAttributes(ndr, NDR_SCALARS, &r->attributes));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->priority));
		if (r->priority > 99) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->defaultpriority));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->starttime));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->untiltime));
		NDR_CHECK(ndr_pull_spoolss_PrinterStatus(ndr, NDR_SCALARS, &r->status));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->cjobs));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->averageppm));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->servername) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->servername));
				_mem_save_servername_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->servername, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->servername));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_servername_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->printername) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->printername));
				_mem_save_printername_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->printername, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->printername));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_printername_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->sharename) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->sharename));
				_mem_save_sharename_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->sharename, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->sharename));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sharename_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->portname) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->portname));
				_mem_save_portname_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->portname, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->portname));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_portname_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->drivername) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->drivername));
				_mem_save_drivername_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->drivername, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->drivername));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_drivername_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->comment) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->comment));
				_mem_save_comment_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->comment, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->comment));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_comment_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->location) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->location));
				_mem_save_location_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->location, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->location));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_location_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		if (r->devmode) {
			uint32_t _relative_save_offset;
			_relative_save_offset = ndr->offset;
			NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->devmode));
			_mem_save_devmode_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->devmode, 0);
			{
				struct ndr_pull *_ndr_devmode;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_devmode, 0, -1));
				NDR_CHECK(ndr_pull_spoolss_DeviceMode(_ndr_devmode, NDR_SCALARS, r->devmode));
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_devmode, 0, -1));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_devmode_0, 0);
			ndr->offset = _relative_save_offset;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->sepfile) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->sepfile));
				_mem_save_sepfile_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->sepfile, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->sepfile));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sepfile_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->printprocessor) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->printprocessor));
				_mem_save_printprocessor_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->printprocessor, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->printprocessor));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_printprocessor_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->datatype) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->datatype));
				_mem_save_datatype_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->datatype, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->datatype));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_datatype_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->parameters) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->parameters));
				_mem_save_parameters_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->parameters, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->parameters));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_parameters_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		if (r->secdesc) {
			uint32_t _relative_save_offset;
			_relative_save_offset = ndr->offset;
			NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->secdesc));
			_mem_save_secdesc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->secdesc, 0);
			{
				struct ndr_pull *_ndr_secdesc;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_secdesc, 0, -1));
				NDR_CHECK(ndr_pull_security_descriptor(_ndr_secdesc, NDR_SCALARS|NDR_BUFFERS, r->secdesc));
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_secdesc, 0, -1));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_secdesc_0, 0);
			ndr->offset = _relative_save_offset;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_PrinterInfo2(struct ndr_print *ndr, const char *name, const struct spoolss_PrinterInfo2 *r)
{
	ndr_print_struct(ndr, name, "spoolss_PrinterInfo2");
	ndr->depth++;
	ndr_print_ptr(ndr, "servername", r->servername);
	ndr->depth++;
	if (r->servername) {
		ndr_print_string(ndr, "servername", r->servername);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "printername", r->printername);
	ndr->depth++;
	if (r->printername) {
		ndr_print_string(ndr, "printername", r->printername);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "sharename", r->sharename);
	ndr->depth++;
	if (r->sharename) {
		ndr_print_string(ndr, "sharename", r->sharename);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "portname", r->portname);
	ndr->depth++;
	if (r->portname) {
		ndr_print_string(ndr, "portname", r->portname);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "drivername", r->drivername);
	ndr->depth++;
	if (r->drivername) {
		ndr_print_string(ndr, "drivername", r->drivername);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "comment", r->comment);
	ndr->depth++;
	if (r->comment) {
		ndr_print_string(ndr, "comment", r->comment);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "location", r->location);
	ndr->depth++;
	if (r->location) {
		ndr_print_string(ndr, "location", r->location);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "devmode", r->devmode);
	ndr->depth++;
	if (r->devmode) {
		ndr_print_spoolss_DeviceMode(ndr, "devmode", r->devmode);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "sepfile", r->sepfile);
	ndr->depth++;
	if (r->sepfile) {
		ndr_print_string(ndr, "sepfile", r->sepfile);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "printprocessor", r->printprocessor);
	ndr->depth++;
	if (r->printprocessor) {
		ndr_print_string(ndr, "printprocessor", r->printprocessor);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "datatype", r->datatype);
	ndr->depth++;
	if (r->datatype) {
		ndr_print_string(ndr, "datatype", r->datatype);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "parameters", r->parameters);
	ndr->depth++;
	if (r->parameters) {
		ndr_print_string(ndr, "parameters", r->parameters);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "secdesc", r->secdesc);
	ndr->depth++;
	if (r->secdesc) {
		ndr_print_security_descriptor(ndr, "secdesc", r->secdesc);
	}
	ndr->depth--;
	ndr_print_spoolss_PrinterAttributes(ndr, "attributes", r->attributes);
	ndr_print_uint32(ndr, "priority", r->priority);
	ndr_print_uint32(ndr, "defaultpriority", r->defaultpriority);
	ndr_print_uint32(ndr, "starttime", r->starttime);
	ndr_print_uint32(ndr, "untiltime", r->untiltime);
	ndr_print_spoolss_PrinterStatus(ndr, "status", r->status);
	ndr_print_uint32(ndr, "cjobs", r->cjobs);
	ndr_print_uint32(ndr, "averageppm", r->averageppm);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_spoolss_PrinterInfo2(const struct spoolss_PrinterInfo2 *r, struct smb_iconv_convenience *ic, int flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_spoolss_PrinterInfo2, ic);
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_PrinterInfo3(struct ndr_push *ndr, int ndr_flags, const struct spoolss_PrinterInfo3 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_relative_ptr1(ndr, r->secdesc));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->secdesc) {
			NDR_CHECK(ndr_push_relative_ptr2(ndr, r->secdesc));
			{
				struct ndr_push *_ndr_secdesc;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_secdesc, 0, -1));
				NDR_CHECK(ndr_push_security_descriptor(_ndr_secdesc, NDR_SCALARS|NDR_BUFFERS, r->secdesc));
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_secdesc, 0, -1));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_PrinterInfo3(struct ndr_pull *ndr, int ndr_flags, struct spoolss_PrinterInfo3 *r)
{
	uint32_t _ptr_secdesc;
	TALLOC_CTX *_mem_save_secdesc_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_secdesc));
		if (_ptr_secdesc) {
			NDR_PULL_ALLOC(ndr, r->secdesc);
			NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->secdesc, _ptr_secdesc));
		} else {
			r->secdesc = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->secdesc) {
			uint32_t _relative_save_offset;
			_relative_save_offset = ndr->offset;
			NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->secdesc));
			_mem_save_secdesc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->secdesc, 0);
			{
				struct ndr_pull *_ndr_secdesc;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_secdesc, 0, -1));
				NDR_CHECK(ndr_pull_security_descriptor(_ndr_secdesc, NDR_SCALARS|NDR_BUFFERS, r->secdesc));
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_secdesc, 0, -1));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_secdesc_0, 0);
			ndr->offset = _relative_save_offset;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_PrinterInfo3(struct ndr_print *ndr, const char *name, const struct spoolss_PrinterInfo3 *r)
{
	ndr_print_struct(ndr, name, "spoolss_PrinterInfo3");
	ndr->depth++;
	ndr_print_ptr(ndr, "secdesc", r->secdesc);
	ndr->depth++;
	if (r->secdesc) {
		ndr_print_security_descriptor(ndr, "secdesc", r->secdesc);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_spoolss_PrinterInfo3(const struct spoolss_PrinterInfo3 *r, struct smb_iconv_convenience *ic, int flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_spoolss_PrinterInfo3, ic);
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_PrinterInfo4(struct ndr_push *ndr, int ndr_flags, const struct spoolss_PrinterInfo4 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->printername));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->servername));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_spoolss_PrinterAttributes(ndr, NDR_SCALARS, r->attributes));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->printername) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->printername));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->printername));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->servername) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->servername));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->servername));
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_PrinterInfo4(struct ndr_pull *ndr, int ndr_flags, struct spoolss_PrinterInfo4 *r)
{
	uint32_t _ptr_printername;
	TALLOC_CTX *_mem_save_printername_0;
	uint32_t _ptr_servername;
	TALLOC_CTX *_mem_save_servername_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_printername));
			if (_ptr_printername) {
				NDR_PULL_ALLOC(ndr, r->printername);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->printername, _ptr_printername));
			} else {
				r->printername = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_servername));
			if (_ptr_servername) {
				NDR_PULL_ALLOC(ndr, r->servername);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->servername, _ptr_servername));
			} else {
				r->servername = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_spoolss_PrinterAttributes(ndr, NDR_SCALARS, &r->attributes));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->printername) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->printername));
				_mem_save_printername_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->printername, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->printername));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_printername_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->servername) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->servername));
				_mem_save_servername_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->servername, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->servername));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_servername_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_PrinterInfo4(struct ndr_print *ndr, const char *name, const struct spoolss_PrinterInfo4 *r)
{
	ndr_print_struct(ndr, name, "spoolss_PrinterInfo4");
	ndr->depth++;
	ndr_print_ptr(ndr, "printername", r->printername);
	ndr->depth++;
	if (r->printername) {
		ndr_print_string(ndr, "printername", r->printername);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "servername", r->servername);
	ndr->depth++;
	if (r->servername) {
		ndr_print_string(ndr, "servername", r->servername);
	}
	ndr->depth--;
	ndr_print_spoolss_PrinterAttributes(ndr, "attributes", r->attributes);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_spoolss_PrinterInfo4(const struct spoolss_PrinterInfo4 *r, struct smb_iconv_convenience *ic, int flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_spoolss_PrinterInfo4, ic);
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_PrinterInfo5(struct ndr_push *ndr, int ndr_flags, const struct spoolss_PrinterInfo5 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->printername));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->portname));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_spoolss_PrinterAttributes(ndr, NDR_SCALARS, r->attributes));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->device_not_selected_timeout));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->transmission_retry_timeout));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->printername) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->printername));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->printername));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->portname) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->portname));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->portname));
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_PrinterInfo5(struct ndr_pull *ndr, int ndr_flags, struct spoolss_PrinterInfo5 *r)
{
	uint32_t _ptr_printername;
	TALLOC_CTX *_mem_save_printername_0;
	uint32_t _ptr_portname;
	TALLOC_CTX *_mem_save_portname_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_printername));
			if (_ptr_printername) {
				NDR_PULL_ALLOC(ndr, r->printername);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->printername, _ptr_printername));
			} else {
				r->printername = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_portname));
			if (_ptr_portname) {
				NDR_PULL_ALLOC(ndr, r->portname);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->portname, _ptr_portname));
			} else {
				r->portname = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_spoolss_PrinterAttributes(ndr, NDR_SCALARS, &r->attributes));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->device_not_selected_timeout));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->transmission_retry_timeout));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->printername) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->printername));
				_mem_save_printername_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->printername, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->printername));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_printername_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->portname) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->portname));
				_mem_save_portname_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->portname, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->portname));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_portname_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_PrinterInfo5(struct ndr_print *ndr, const char *name, const struct spoolss_PrinterInfo5 *r)
{
	ndr_print_struct(ndr, name, "spoolss_PrinterInfo5");
	ndr->depth++;
	ndr_print_ptr(ndr, "printername", r->printername);
	ndr->depth++;
	if (r->printername) {
		ndr_print_string(ndr, "printername", r->printername);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "portname", r->portname);
	ndr->depth++;
	if (r->portname) {
		ndr_print_string(ndr, "portname", r->portname);
	}
	ndr->depth--;
	ndr_print_spoolss_PrinterAttributes(ndr, "attributes", r->attributes);
	ndr_print_uint32(ndr, "device_not_selected_timeout", r->device_not_selected_timeout);
	ndr_print_uint32(ndr, "transmission_retry_timeout", r->transmission_retry_timeout);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_spoolss_PrinterInfo5(const struct spoolss_PrinterInfo5 *r, struct smb_iconv_convenience *ic, int flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_spoolss_PrinterInfo5, ic);
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_PrinterInfo6(struct ndr_push *ndr, int ndr_flags, const struct spoolss_PrinterInfo6 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_spoolss_PrinterStatus(ndr, NDR_SCALARS, r->status));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_PrinterInfo6(struct ndr_pull *ndr, int ndr_flags, struct spoolss_PrinterInfo6 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_spoolss_PrinterStatus(ndr, NDR_SCALARS, &r->status));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_PrinterInfo6(struct ndr_print *ndr, const char *name, const struct spoolss_PrinterInfo6 *r)
{
	ndr_print_struct(ndr, name, "spoolss_PrinterInfo6");
	ndr->depth++;
	ndr_print_spoolss_PrinterStatus(ndr, "status", r->status);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_spoolss_PrinterInfo6(const struct spoolss_PrinterInfo6 *r, struct smb_iconv_convenience *ic, int flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_spoolss_PrinterInfo6, ic);
}

static enum ndr_err_code ndr_push_spoolss_DsPrintAction(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_DsPrintAction(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_DsPrintAction(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DSPRINT_PUBLISH", DSPRINT_PUBLISH, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DSPRINT_UPDATE", DSPRINT_UPDATE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DSPRINT_UNPUBLISH", DSPRINT_UNPUBLISH, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DSPRINT_REPUBLISH", DSPRINT_REPUBLISH, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DSPRINT_PENDING", DSPRINT_PENDING, r);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_PrinterInfo7(struct ndr_push *ndr, int ndr_flags, const struct spoolss_PrinterInfo7 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->guid));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_spoolss_DsPrintAction(ndr, NDR_SCALARS, r->action));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->guid) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->guid));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->guid));
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_PrinterInfo7(struct ndr_pull *ndr, int ndr_flags, struct spoolss_PrinterInfo7 *r)
{
	uint32_t _ptr_guid;
	TALLOC_CTX *_mem_save_guid_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_guid));
			if (_ptr_guid) {
				NDR_PULL_ALLOC(ndr, r->guid);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->guid, _ptr_guid));
			} else {
				r->guid = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_spoolss_DsPrintAction(ndr, NDR_SCALARS, &r->action));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->guid) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->guid));
				_mem_save_guid_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->guid, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->guid));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_guid_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_PrinterInfo7(struct ndr_print *ndr, const char *name, const struct spoolss_PrinterInfo7 *r)
{
	ndr_print_struct(ndr, name, "spoolss_PrinterInfo7");
	ndr->depth++;
	ndr_print_ptr(ndr, "guid", r->guid);
	ndr->depth++;
	if (r->guid) {
		ndr_print_string(ndr, "guid", r->guid);
	}
	ndr->depth--;
	ndr_print_spoolss_DsPrintAction(ndr, "action", r->action);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_spoolss_PrinterInfo7(const struct spoolss_PrinterInfo7 *r, struct smb_iconv_convenience *ic, int flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_spoolss_PrinterInfo7, ic);
}

static enum ndr_err_code ndr_push_spoolss_DeviceModeInfo(struct ndr_push *ndr, int ndr_flags, const struct spoolss_DeviceModeInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_relative_ptr1(ndr, r->devmode));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->devmode) {
			NDR_CHECK(ndr_push_relative_ptr2(ndr, r->devmode));
			{
				struct ndr_push *_ndr_devmode;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_devmode, 0, -1));
				NDR_CHECK(ndr_push_spoolss_DeviceMode(_ndr_devmode, NDR_SCALARS, r->devmode));
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_devmode, 0, -1));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_DeviceModeInfo(struct ndr_pull *ndr, int ndr_flags, struct spoolss_DeviceModeInfo *r)
{
	uint32_t _ptr_devmode;
	TALLOC_CTX *_mem_save_devmode_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_devmode));
		if (_ptr_devmode) {
			NDR_PULL_ALLOC(ndr, r->devmode);
			NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->devmode, _ptr_devmode));
		} else {
			r->devmode = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->devmode) {
			uint32_t _relative_save_offset;
			_relative_save_offset = ndr->offset;
			NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->devmode));
			_mem_save_devmode_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->devmode, 0);
			{
				struct ndr_pull *_ndr_devmode;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_devmode, 0, -1));
				NDR_CHECK(ndr_pull_spoolss_DeviceMode(_ndr_devmode, NDR_SCALARS, r->devmode));
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_devmode, 0, -1));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_devmode_0, 0);
			ndr->offset = _relative_save_offset;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_DeviceModeInfo(struct ndr_print *ndr, const char *name, const struct spoolss_DeviceModeInfo *r)
{
	ndr_print_struct(ndr, name, "spoolss_DeviceModeInfo");
	ndr->depth++;
	ndr_print_ptr(ndr, "devmode", r->devmode);
	ndr->depth++;
	if (r->devmode) {
		ndr_print_spoolss_DeviceMode(ndr, "devmode", r->devmode);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_PrinterInfo(struct ndr_push *ndr, int ndr_flags, const union spoolss_PrinterInfo *r)
{
	uint32_t _save_relative_base_offset = ndr_push_get_relative_base_offset(ndr);
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_push_align(ndr, 4));
				NDR_CHECK(ndr_push_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_push_spoolss_PrinterInfo0(ndr, NDR_SCALARS, &r->info0));
			break; }

			case 1: {
				NDR_CHECK(ndr_push_align(ndr, 4));
				NDR_CHECK(ndr_push_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_push_spoolss_PrinterInfo1(ndr, NDR_SCALARS, &r->info1));
			break; }

			case 2: {
				NDR_CHECK(ndr_push_align(ndr, 4));
				NDR_CHECK(ndr_push_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_push_spoolss_PrinterInfo2(ndr, NDR_SCALARS, &r->info2));
			break; }

			case 3: {
				NDR_CHECK(ndr_push_align(ndr, 4));
				NDR_CHECK(ndr_push_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_push_spoolss_PrinterInfo3(ndr, NDR_SCALARS, &r->info3));
			break; }

			case 4: {
				NDR_CHECK(ndr_push_align(ndr, 4));
				NDR_CHECK(ndr_push_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_push_spoolss_PrinterInfo4(ndr, NDR_SCALARS, &r->info4));
			break; }

			case 5: {
				NDR_CHECK(ndr_push_align(ndr, 4));
				NDR_CHECK(ndr_push_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_push_spoolss_PrinterInfo5(ndr, NDR_SCALARS, &r->info5));
			break; }

			case 6: {
				NDR_CHECK(ndr_push_align(ndr, 4));
				NDR_CHECK(ndr_push_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_push_spoolss_PrinterInfo6(ndr, NDR_SCALARS, &r->info6));
			break; }

			case 7: {
				NDR_CHECK(ndr_push_align(ndr, 4));
				NDR_CHECK(ndr_push_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_push_spoolss_PrinterInfo7(ndr, NDR_SCALARS, &r->info7));
			break; }

			case 8: {
				NDR_CHECK(ndr_push_align(ndr, 4));
				NDR_CHECK(ndr_push_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_push_spoolss_DeviceModeInfo(ndr, NDR_SCALARS, &r->info8));
			break; }

			case 9: {
				NDR_CHECK(ndr_push_align(ndr, 4));
				NDR_CHECK(ndr_push_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_push_spoolss_DeviceModeInfo(ndr, NDR_SCALARS, &r->info9));
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_setup_relative_base_offset2(ndr, r));
		switch (level) {
			case 0:
				NDR_CHECK(ndr_push_spoolss_PrinterInfo0(ndr, NDR_BUFFERS, &r->info0));
			break;

			case 1:
				NDR_CHECK(ndr_push_spoolss_PrinterInfo1(ndr, NDR_BUFFERS, &r->info1));
			break;

			case 2:
				NDR_CHECK(ndr_push_spoolss_PrinterInfo2(ndr, NDR_BUFFERS, &r->info2));
			break;

			case 3:
				NDR_CHECK(ndr_push_spoolss_PrinterInfo3(ndr, NDR_BUFFERS, &r->info3));
			break;

			case 4:
				NDR_CHECK(ndr_push_spoolss_PrinterInfo4(ndr, NDR_BUFFERS, &r->info4));
			break;

			case 5:
				NDR_CHECK(ndr_push_spoolss_PrinterInfo5(ndr, NDR_BUFFERS, &r->info5));
			break;

			case 6:
			break;

			case 7:
				NDR_CHECK(ndr_push_spoolss_PrinterInfo7(ndr, NDR_BUFFERS, &r->info7));
			break;

			case 8:
				NDR_CHECK(ndr_push_spoolss_DeviceModeInfo(ndr, NDR_BUFFERS, &r->info8));
			break;

			case 9:
				NDR_CHECK(ndr_push_spoolss_DeviceModeInfo(ndr, NDR_BUFFERS, &r->info9));
			break;

			default:
			break;

		}
	}
	ndr_push_restore_relative_base_offset(ndr, _save_relative_base_offset);
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_PrinterInfo(struct ndr_pull *ndr, int ndr_flags, union spoolss_PrinterInfo *r)
{
	uint32_t _save_relative_base_offset = ndr_pull_get_relative_base_offset(ndr);
	int level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_pull_align(ndr, 4));
				NDR_CHECK(ndr_pull_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_pull_spoolss_PrinterInfo0(ndr, NDR_SCALARS, &r->info0));
			break; }

			case 1: {
				NDR_CHECK(ndr_pull_align(ndr, 4));
				NDR_CHECK(ndr_pull_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_pull_spoolss_PrinterInfo1(ndr, NDR_SCALARS, &r->info1));
			break; }

			case 2: {
				NDR_CHECK(ndr_pull_align(ndr, 4));
				NDR_CHECK(ndr_pull_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_pull_spoolss_PrinterInfo2(ndr, NDR_SCALARS, &r->info2));
			break; }

			case 3: {
				NDR_CHECK(ndr_pull_align(ndr, 4));
				NDR_CHECK(ndr_pull_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_pull_spoolss_PrinterInfo3(ndr, NDR_SCALARS, &r->info3));
			break; }

			case 4: {
				NDR_CHECK(ndr_pull_align(ndr, 4));
				NDR_CHECK(ndr_pull_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_pull_spoolss_PrinterInfo4(ndr, NDR_SCALARS, &r->info4));
			break; }

			case 5: {
				NDR_CHECK(ndr_pull_align(ndr, 4));
				NDR_CHECK(ndr_pull_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_pull_spoolss_PrinterInfo5(ndr, NDR_SCALARS, &r->info5));
			break; }

			case 6: {
				NDR_CHECK(ndr_pull_align(ndr, 4));
				NDR_CHECK(ndr_pull_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_pull_spoolss_PrinterInfo6(ndr, NDR_SCALARS, &r->info6));
			break; }

			case 7: {
				NDR_CHECK(ndr_pull_align(ndr, 4));
				NDR_CHECK(ndr_pull_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_pull_spoolss_PrinterInfo7(ndr, NDR_SCALARS, &r->info7));
			break; }

			case 8: {
				NDR_CHECK(ndr_pull_align(ndr, 4));
				NDR_CHECK(ndr_pull_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_pull_spoolss_DeviceModeInfo(ndr, NDR_SCALARS, &r->info8));
			break; }

			case 9: {
				NDR_CHECK(ndr_pull_align(ndr, 4));
				NDR_CHECK(ndr_pull_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_pull_spoolss_DeviceModeInfo(ndr, NDR_SCALARS, &r->info9));
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_setup_relative_base_offset2(ndr, r));
		switch (level) {
			case 0:
				NDR_CHECK(ndr_pull_spoolss_PrinterInfo0(ndr, NDR_BUFFERS, &r->info0));
			break;

			case 1:
				NDR_CHECK(ndr_pull_spoolss_PrinterInfo1(ndr, NDR_BUFFERS, &r->info1));
			break;

			case 2:
				NDR_CHECK(ndr_pull_spoolss_PrinterInfo2(ndr, NDR_BUFFERS, &r->info2));
			break;

			case 3:
				NDR_CHECK(ndr_pull_spoolss_PrinterInfo3(ndr, NDR_BUFFERS, &r->info3));
			break;

			case 4:
				NDR_CHECK(ndr_pull_spoolss_PrinterInfo4(ndr, NDR_BUFFERS, &r->info4));
			break;

			case 5:
				NDR_CHECK(ndr_pull_spoolss_PrinterInfo5(ndr, NDR_BUFFERS, &r->info5));
			break;

			case 6:
			break;

			case 7:
				NDR_CHECK(ndr_pull_spoolss_PrinterInfo7(ndr, NDR_BUFFERS, &r->info7));
			break;

			case 8:
				NDR_CHECK(ndr_pull_spoolss_DeviceModeInfo(ndr, NDR_BUFFERS, &r->info8));
			break;

			case 9:
				NDR_CHECK(ndr_pull_spoolss_DeviceModeInfo(ndr, NDR_BUFFERS, &r->info9));
			break;

			default:
			break;

		}
	}
	ndr_pull_restore_relative_base_offset(ndr, _save_relative_base_offset);
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_PrinterInfo(struct ndr_print *ndr, const char *name, const union spoolss_PrinterInfo *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "spoolss_PrinterInfo");
	switch (level) {
		case 0:
			ndr_print_spoolss_PrinterInfo0(ndr, "info0", &r->info0);
		break;

		case 1:
			ndr_print_spoolss_PrinterInfo1(ndr, "info1", &r->info1);
		break;

		case 2:
			ndr_print_spoolss_PrinterInfo2(ndr, "info2", &r->info2);
		break;

		case 3:
			ndr_print_spoolss_PrinterInfo3(ndr, "info3", &r->info3);
		break;

		case 4:
			ndr_print_spoolss_PrinterInfo4(ndr, "info4", &r->info4);
		break;

		case 5:
			ndr_print_spoolss_PrinterInfo5(ndr, "info5", &r->info5);
		break;

		case 6:
			ndr_print_spoolss_PrinterInfo6(ndr, "info6", &r->info6);
		break;

		case 7:
			ndr_print_spoolss_PrinterInfo7(ndr, "info7", &r->info7);
		break;

		case 8:
			ndr_print_spoolss_DeviceModeInfo(ndr, "info8", &r->info8);
		break;

		case 9:
			ndr_print_spoolss_DeviceModeInfo(ndr, "info9", &r->info9);
		break;

		default:
		break;

	}
}

_PUBLIC_ size_t ndr_size_spoolss_PrinterInfo(const union spoolss_PrinterInfo *r, uint32_t level, struct smb_iconv_convenience *ic, int flags)
{
	return ndr_size_union(r, flags, level, (ndr_push_flags_fn_t)ndr_push_spoolss_PrinterInfo, ic);
}

static enum ndr_err_code ndr_push_spoolss_DevmodeContainer(struct ndr_push *ndr, int ndr_flags, const struct spoolss_DevmodeContainer *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, _ndr_size_spoolss_DeviceMode(r->devmode, ndr->iconv_convenience, ndr->flags)));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->devmode));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->devmode) {
			{
				struct ndr_push *_ndr_devmode;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_devmode, 4, _ndr_size_spoolss_DeviceMode(r->devmode, ndr->iconv_convenience, ndr->flags)));
				NDR_CHECK(ndr_push_spoolss_DeviceMode(_ndr_devmode, NDR_SCALARS, r->devmode));
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_devmode, 4, _ndr_size_spoolss_DeviceMode(r->devmode, ndr->iconv_convenience, ndr->flags)));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_DevmodeContainer(struct ndr_pull *ndr, int ndr_flags, struct spoolss_DevmodeContainer *r)
{
	uint32_t _ptr_devmode;
	TALLOC_CTX *_mem_save_devmode_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->_ndr_size));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_devmode));
		if (_ptr_devmode) {
			NDR_PULL_ALLOC(ndr, r->devmode);
		} else {
			r->devmode = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->devmode) {
			_mem_save_devmode_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->devmode, 0);
			{
				struct ndr_pull *_ndr_devmode;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_devmode, 4, r->_ndr_size));
				NDR_CHECK(ndr_pull_spoolss_DeviceMode(_ndr_devmode, NDR_SCALARS, r->devmode));
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_devmode, 4, r->_ndr_size));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_devmode_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_DevmodeContainer(struct ndr_print *ndr, const char *name, const struct spoolss_DevmodeContainer *r)
{
	ndr_print_struct(ndr, name, "spoolss_DevmodeContainer");
	ndr->depth++;
	ndr_print_uint32(ndr, "_ndr_size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?_ndr_size_spoolss_DeviceMode(r->devmode, ndr->iconv_convenience, ndr->flags):r->_ndr_size);
	ndr_print_ptr(ndr, "devmode", r->devmode);
	ndr->depth++;
	if (r->devmode) {
		ndr_print_spoolss_DeviceMode(ndr, "devmode", r->devmode);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_JobInfo1(struct ndr_push *ndr, int ndr_flags, const struct spoolss_JobInfo1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->job_id));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->printer_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->server_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->user_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->document_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->data_type));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->text_status));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_spoolss_JobStatus(ndr, NDR_SCALARS, r->status));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->priority));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->position));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->total_pages));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->pages_printed));
		NDR_CHECK(ndr_push_spoolss_Time(ndr, NDR_SCALARS, &r->submitted));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->printer_name) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->printer_name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->printer_name));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->server_name) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->server_name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->server_name));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->user_name) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->user_name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->user_name));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->document_name) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->document_name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->document_name));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->data_type) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->data_type));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->data_type));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->text_status) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->text_status));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->text_status));
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_JobInfo1(struct ndr_pull *ndr, int ndr_flags, struct spoolss_JobInfo1 *r)
{
	uint32_t _ptr_printer_name;
	TALLOC_CTX *_mem_save_printer_name_0;
	uint32_t _ptr_server_name;
	TALLOC_CTX *_mem_save_server_name_0;
	uint32_t _ptr_user_name;
	TALLOC_CTX *_mem_save_user_name_0;
	uint32_t _ptr_document_name;
	TALLOC_CTX *_mem_save_document_name_0;
	uint32_t _ptr_data_type;
	TALLOC_CTX *_mem_save_data_type_0;
	uint32_t _ptr_text_status;
	TALLOC_CTX *_mem_save_text_status_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->job_id));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_printer_name));
			if (_ptr_printer_name) {
				NDR_PULL_ALLOC(ndr, r->printer_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->printer_name, _ptr_printer_name));
			} else {
				r->printer_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_name));
			if (_ptr_server_name) {
				NDR_PULL_ALLOC(ndr, r->server_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->server_name, _ptr_server_name));
			} else {
				r->server_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_user_name));
			if (_ptr_user_name) {
				NDR_PULL_ALLOC(ndr, r->user_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->user_name, _ptr_user_name));
			} else {
				r->user_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_document_name));
			if (_ptr_document_name) {
				NDR_PULL_ALLOC(ndr, r->document_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->document_name, _ptr_document_name));
			} else {
				r->document_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_data_type));
			if (_ptr_data_type) {
				NDR_PULL_ALLOC(ndr, r->data_type);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->data_type, _ptr_data_type));
			} else {
				r->data_type = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_text_status));
			if (_ptr_text_status) {
				NDR_PULL_ALLOC(ndr, r->text_status);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->text_status, _ptr_text_status));
			} else {
				r->text_status = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_spoolss_JobStatus(ndr, NDR_SCALARS, &r->status));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->priority));
		if (r->priority > 99) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->position));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->total_pages));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->pages_printed));
		NDR_CHECK(ndr_pull_spoolss_Time(ndr, NDR_SCALARS, &r->submitted));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->printer_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->printer_name));
				_mem_save_printer_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->printer_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->printer_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_printer_name_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->server_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->server_name));
				_mem_save_server_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->server_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->server_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_name_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->user_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->user_name));
				_mem_save_user_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->user_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->user_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_user_name_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->document_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->document_name));
				_mem_save_document_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->document_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->document_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_document_name_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->data_type) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->data_type));
				_mem_save_data_type_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->data_type, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->data_type));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_type_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->text_status) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->text_status));
				_mem_save_text_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->text_status, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->text_status));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_text_status_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_JobInfo1(struct ndr_print *ndr, const char *name, const struct spoolss_JobInfo1 *r)
{
	ndr_print_struct(ndr, name, "spoolss_JobInfo1");
	ndr->depth++;
	ndr_print_uint32(ndr, "job_id", r->job_id);
	ndr_print_ptr(ndr, "printer_name", r->printer_name);
	ndr->depth++;
	if (r->printer_name) {
		ndr_print_string(ndr, "printer_name", r->printer_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "server_name", r->server_name);
	ndr->depth++;
	if (r->server_name) {
		ndr_print_string(ndr, "server_name", r->server_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "user_name", r->user_name);
	ndr->depth++;
	if (r->user_name) {
		ndr_print_string(ndr, "user_name", r->user_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "document_name", r->document_name);
	ndr->depth++;
	if (r->document_name) {
		ndr_print_string(ndr, "document_name", r->document_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "data_type", r->data_type);
	ndr->depth++;
	if (r->data_type) {
		ndr_print_string(ndr, "data_type", r->data_type);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "text_status", r->text_status);
	ndr->depth++;
	if (r->text_status) {
		ndr_print_string(ndr, "text_status", r->text_status);
	}
	ndr->depth--;
	ndr_print_spoolss_JobStatus(ndr, "status", r->status);
	ndr_print_uint32(ndr, "priority", r->priority);
	ndr_print_uint32(ndr, "position", r->position);
	ndr_print_uint32(ndr, "total_pages", r->total_pages);
	ndr_print_uint32(ndr, "pages_printed", r->pages_printed);
	ndr_print_spoolss_Time(ndr, "submitted", &r->submitted);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_spoolss_JobInfo1(const struct spoolss_JobInfo1 *r, struct smb_iconv_convenience *ic, int flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_spoolss_JobInfo1, ic);
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_JobInfo2(struct ndr_push *ndr, int ndr_flags, const struct spoolss_JobInfo2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->job_id));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->printer_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->server_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->user_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->document_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->notify_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->data_type));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->print_processor));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->parameters));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->driver_name));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_relative_ptr1(ndr, r->devmode));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->text_status));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_relative_ptr1(ndr, r->secdesc));
		NDR_CHECK(ndr_push_spoolss_JobStatus(ndr, NDR_SCALARS, r->status));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->priority));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->position));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->start_time));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->until_time));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->total_pages));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->size));
		NDR_CHECK(ndr_push_spoolss_Time(ndr, NDR_SCALARS, &r->submitted));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->time));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->pages_printed));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->printer_name) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->printer_name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->printer_name));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->server_name) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->server_name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->server_name));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->user_name) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->user_name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->user_name));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->document_name) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->document_name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->document_name));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->notify_name) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->notify_name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->notify_name));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->data_type) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->data_type));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->data_type));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->print_processor) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->print_processor));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->print_processor));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->parameters) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->parameters));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->parameters));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->driver_name) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->driver_name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->driver_name));
			}
			ndr->flags = _flags_save_string;
		}
		if (r->devmode) {
			NDR_CHECK(ndr_push_relative_ptr2(ndr, r->devmode));
			NDR_CHECK(ndr_push_spoolss_DeviceMode(ndr, NDR_SCALARS, r->devmode));
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->text_status) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->text_status));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->text_status));
			}
			ndr->flags = _flags_save_string;
		}
		if (r->secdesc) {
			NDR_CHECK(ndr_push_relative_ptr2(ndr, r->secdesc));
			NDR_CHECK(ndr_push_security_descriptor(ndr, NDR_SCALARS|NDR_BUFFERS, r->secdesc));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_JobInfo2(struct ndr_pull *ndr, int ndr_flags, struct spoolss_JobInfo2 *r)
{
	uint32_t _ptr_printer_name;
	TALLOC_CTX *_mem_save_printer_name_0;
	uint32_t _ptr_server_name;
	TALLOC_CTX *_mem_save_server_name_0;
	uint32_t _ptr_user_name;
	TALLOC_CTX *_mem_save_user_name_0;
	uint32_t _ptr_document_name;
	TALLOC_CTX *_mem_save_document_name_0;
	uint32_t _ptr_notify_name;
	TALLOC_CTX *_mem_save_notify_name_0;
	uint32_t _ptr_data_type;
	TALLOC_CTX *_mem_save_data_type_0;
	uint32_t _ptr_print_processor;
	TALLOC_CTX *_mem_save_print_processor_0;
	uint32_t _ptr_parameters;
	TALLOC_CTX *_mem_save_parameters_0;
	uint32_t _ptr_driver_name;
	TALLOC_CTX *_mem_save_driver_name_0;
	uint32_t _ptr_devmode;
	TALLOC_CTX *_mem_save_devmode_0;
	uint32_t _ptr_text_status;
	TALLOC_CTX *_mem_save_text_status_0;
	uint32_t _ptr_secdesc;
	TALLOC_CTX *_mem_save_secdesc_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->job_id));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_printer_name));
			if (_ptr_printer_name) {
				NDR_PULL_ALLOC(ndr, r->printer_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->printer_name, _ptr_printer_name));
			} else {
				r->printer_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_name));
			if (_ptr_server_name) {
				NDR_PULL_ALLOC(ndr, r->server_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->server_name, _ptr_server_name));
			} else {
				r->server_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_user_name));
			if (_ptr_user_name) {
				NDR_PULL_ALLOC(ndr, r->user_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->user_name, _ptr_user_name));
			} else {
				r->user_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_document_name));
			if (_ptr_document_name) {
				NDR_PULL_ALLOC(ndr, r->document_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->document_name, _ptr_document_name));
			} else {
				r->document_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_notify_name));
			if (_ptr_notify_name) {
				NDR_PULL_ALLOC(ndr, r->notify_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->notify_name, _ptr_notify_name));
			} else {
				r->notify_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_data_type));
			if (_ptr_data_type) {
				NDR_PULL_ALLOC(ndr, r->data_type);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->data_type, _ptr_data_type));
			} else {
				r->data_type = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_print_processor));
			if (_ptr_print_processor) {
				NDR_PULL_ALLOC(ndr, r->print_processor);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->print_processor, _ptr_print_processor));
			} else {
				r->print_processor = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_parameters));
			if (_ptr_parameters) {
				NDR_PULL_ALLOC(ndr, r->parameters);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->parameters, _ptr_parameters));
			} else {
				r->parameters = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_driver_name));
			if (_ptr_driver_name) {
				NDR_PULL_ALLOC(ndr, r->driver_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->driver_name, _ptr_driver_name));
			} else {
				r->driver_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_devmode));
		if (_ptr_devmode) {
			NDR_PULL_ALLOC(ndr, r->devmode);
			NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->devmode, _ptr_devmode));
		} else {
			r->devmode = NULL;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_text_status));
			if (_ptr_text_status) {
				NDR_PULL_ALLOC(ndr, r->text_status);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->text_status, _ptr_text_status));
			} else {
				r->text_status = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_secdesc));
		if (_ptr_secdesc) {
			NDR_PULL_ALLOC(ndr, r->secdesc);
			NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->secdesc, _ptr_secdesc));
		} else {
			r->secdesc = NULL;
		}
		NDR_CHECK(ndr_pull_spoolss_JobStatus(ndr, NDR_SCALARS, &r->status));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->priority));
		if (r->priority > 99) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->position));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->start_time));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->until_time));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->total_pages));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_pull_spoolss_Time(ndr, NDR_SCALARS, &r->submitted));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->time));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->pages_printed));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->printer_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->printer_name));
				_mem_save_printer_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->printer_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->printer_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_printer_name_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->server_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->server_name));
				_mem_save_server_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->server_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->server_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_name_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->user_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->user_name));
				_mem_save_user_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->user_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->user_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_user_name_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->document_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->document_name));
				_mem_save_document_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->document_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->document_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_document_name_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->notify_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->notify_name));
				_mem_save_notify_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->notify_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->notify_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_notify_name_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->data_type) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->data_type));
				_mem_save_data_type_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->data_type, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->data_type));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_type_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->print_processor) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->print_processor));
				_mem_save_print_processor_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->print_processor, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->print_processor));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_print_processor_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->parameters) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->parameters));
				_mem_save_parameters_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->parameters, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->parameters));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_parameters_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->driver_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->driver_name));
				_mem_save_driver_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->driver_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->driver_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_driver_name_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		if (r->devmode) {
			uint32_t _relative_save_offset;
			_relative_save_offset = ndr->offset;
			NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->devmode));
			_mem_save_devmode_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->devmode, 0);
			NDR_CHECK(ndr_pull_spoolss_DeviceMode(ndr, NDR_SCALARS, r->devmode));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_devmode_0, 0);
			ndr->offset = _relative_save_offset;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->text_status) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->text_status));
				_mem_save_text_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->text_status, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->text_status));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_text_status_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		if (r->secdesc) {
			uint32_t _relative_save_offset;
			_relative_save_offset = ndr->offset;
			NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->secdesc));
			_mem_save_secdesc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->secdesc, 0);
			NDR_CHECK(ndr_pull_security_descriptor(ndr, NDR_SCALARS|NDR_BUFFERS, r->secdesc));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_secdesc_0, 0);
			ndr->offset = _relative_save_offset;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_JobInfo2(struct ndr_print *ndr, const char *name, const struct spoolss_JobInfo2 *r)
{
	ndr_print_struct(ndr, name, "spoolss_JobInfo2");
	ndr->depth++;
	ndr_print_uint32(ndr, "job_id", r->job_id);
	ndr_print_ptr(ndr, "printer_name", r->printer_name);
	ndr->depth++;
	if (r->printer_name) {
		ndr_print_string(ndr, "printer_name", r->printer_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "server_name", r->server_name);
	ndr->depth++;
	if (r->server_name) {
		ndr_print_string(ndr, "server_name", r->server_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "user_name", r->user_name);
	ndr->depth++;
	if (r->user_name) {
		ndr_print_string(ndr, "user_name", r->user_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "document_name", r->document_name);
	ndr->depth++;
	if (r->document_name) {
		ndr_print_string(ndr, "document_name", r->document_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "notify_name", r->notify_name);
	ndr->depth++;
	if (r->notify_name) {
		ndr_print_string(ndr, "notify_name", r->notify_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "data_type", r->data_type);
	ndr->depth++;
	if (r->data_type) {
		ndr_print_string(ndr, "data_type", r->data_type);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "print_processor", r->print_processor);
	ndr->depth++;
	if (r->print_processor) {
		ndr_print_string(ndr, "print_processor", r->print_processor);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "parameters", r->parameters);
	ndr->depth++;
	if (r->parameters) {
		ndr_print_string(ndr, "parameters", r->parameters);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "driver_name", r->driver_name);
	ndr->depth++;
	if (r->driver_name) {
		ndr_print_string(ndr, "driver_name", r->driver_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "devmode", r->devmode);
	ndr->depth++;
	if (r->devmode) {
		ndr_print_spoolss_DeviceMode(ndr, "devmode", r->devmode);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "text_status", r->text_status);
	ndr->depth++;
	if (r->text_status) {
		ndr_print_string(ndr, "text_status", r->text_status);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "secdesc", r->secdesc);
	ndr->depth++;
	if (r->secdesc) {
		ndr_print_security_descriptor(ndr, "secdesc", r->secdesc);
	}
	ndr->depth--;
	ndr_print_spoolss_JobStatus(ndr, "status", r->status);
	ndr_print_uint32(ndr, "priority", r->priority);
	ndr_print_uint32(ndr, "position", r->position);
	ndr_print_uint32(ndr, "start_time", r->start_time);
	ndr_print_uint32(ndr, "until_time", r->until_time);
	ndr_print_uint32(ndr, "total_pages", r->total_pages);
	ndr_print_uint32(ndr, "size", r->size);
	ndr_print_spoolss_Time(ndr, "submitted", &r->submitted);
	ndr_print_uint32(ndr, "time", r->time);
	ndr_print_uint32(ndr, "pages_printed", r->pages_printed);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_spoolss_JobInfo2(const struct spoolss_JobInfo2 *r, struct smb_iconv_convenience *ic, int flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_spoolss_JobInfo2, ic);
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_JobInfo3(struct ndr_push *ndr, int ndr_flags, const struct spoolss_JobInfo3 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->job_id));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->next_job_id));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->reserved));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_JobInfo3(struct ndr_pull *ndr, int ndr_flags, struct spoolss_JobInfo3 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->job_id));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->next_job_id));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_JobInfo3(struct ndr_print *ndr, const char *name, const struct spoolss_JobInfo3 *r)
{
	ndr_print_struct(ndr, name, "spoolss_JobInfo3");
	ndr->depth++;
	ndr_print_uint32(ndr, "job_id", r->job_id);
	ndr_print_uint32(ndr, "next_job_id", r->next_job_id);
	ndr_print_uint32(ndr, "reserved", r->reserved);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_spoolss_JobInfo3(const struct spoolss_JobInfo3 *r, struct smb_iconv_convenience *ic, int flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_spoolss_JobInfo3, ic);
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_JobInfo4(struct ndr_push *ndr, int ndr_flags, const struct spoolss_JobInfo4 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->job_id));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->printer_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->server_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->user_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->document_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->notify_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->data_type));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->print_processor));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->parameters));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->driver_name));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_relative_ptr1(ndr, r->devmode));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->text_status));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_relative_ptr1(ndr, r->secdesc));
		NDR_CHECK(ndr_push_spoolss_JobStatus(ndr, NDR_SCALARS, r->status));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->priority));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->position));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->start_time));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->until_time));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->total_pages));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->size));
		NDR_CHECK(ndr_push_spoolss_Time(ndr, NDR_SCALARS, &r->submitted));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->time));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->pages_printed));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->size_high));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->printer_name) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->printer_name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->printer_name));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->server_name) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->server_name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->server_name));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->user_name) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->user_name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->user_name));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->document_name) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->document_name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->document_name));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->notify_name) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->notify_name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->notify_name));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->data_type) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->data_type));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->data_type));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->print_processor) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->print_processor));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->print_processor));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->parameters) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->parameters));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->parameters));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->driver_name) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->driver_name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->driver_name));
			}
			ndr->flags = _flags_save_string;
		}
		if (r->devmode) {
			NDR_CHECK(ndr_push_relative_ptr2(ndr, r->devmode));
			NDR_CHECK(ndr_push_spoolss_DeviceMode(ndr, NDR_SCALARS, r->devmode));
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->text_status) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->text_status));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->text_status));
			}
			ndr->flags = _flags_save_string;
		}
		if (r->secdesc) {
			NDR_CHECK(ndr_push_relative_ptr2(ndr, r->secdesc));
			NDR_CHECK(ndr_push_security_descriptor(ndr, NDR_SCALARS|NDR_BUFFERS, r->secdesc));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_JobInfo4(struct ndr_pull *ndr, int ndr_flags, struct spoolss_JobInfo4 *r)
{
	uint32_t _ptr_printer_name;
	TALLOC_CTX *_mem_save_printer_name_0;
	uint32_t _ptr_server_name;
	TALLOC_CTX *_mem_save_server_name_0;
	uint32_t _ptr_user_name;
	TALLOC_CTX *_mem_save_user_name_0;
	uint32_t _ptr_document_name;
	TALLOC_CTX *_mem_save_document_name_0;
	uint32_t _ptr_notify_name;
	TALLOC_CTX *_mem_save_notify_name_0;
	uint32_t _ptr_data_type;
	TALLOC_CTX *_mem_save_data_type_0;
	uint32_t _ptr_print_processor;
	TALLOC_CTX *_mem_save_print_processor_0;
	uint32_t _ptr_parameters;
	TALLOC_CTX *_mem_save_parameters_0;
	uint32_t _ptr_driver_name;
	TALLOC_CTX *_mem_save_driver_name_0;
	uint32_t _ptr_devmode;
	TALLOC_CTX *_mem_save_devmode_0;
	uint32_t _ptr_text_status;
	TALLOC_CTX *_mem_save_text_status_0;
	uint32_t _ptr_secdesc;
	TALLOC_CTX *_mem_save_secdesc_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->job_id));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_printer_name));
			if (_ptr_printer_name) {
				NDR_PULL_ALLOC(ndr, r->printer_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->printer_name, _ptr_printer_name));
			} else {
				r->printer_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_name));
			if (_ptr_server_name) {
				NDR_PULL_ALLOC(ndr, r->server_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->server_name, _ptr_server_name));
			} else {
				r->server_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_user_name));
			if (_ptr_user_name) {
				NDR_PULL_ALLOC(ndr, r->user_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->user_name, _ptr_user_name));
			} else {
				r->user_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_document_name));
			if (_ptr_document_name) {
				NDR_PULL_ALLOC(ndr, r->document_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->document_name, _ptr_document_name));
			} else {
				r->document_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_notify_name));
			if (_ptr_notify_name) {
				NDR_PULL_ALLOC(ndr, r->notify_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->notify_name, _ptr_notify_name));
			} else {
				r->notify_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_data_type));
			if (_ptr_data_type) {
				NDR_PULL_ALLOC(ndr, r->data_type);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->data_type, _ptr_data_type));
			} else {
				r->data_type = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_print_processor));
			if (_ptr_print_processor) {
				NDR_PULL_ALLOC(ndr, r->print_processor);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->print_processor, _ptr_print_processor));
			} else {
				r->print_processor = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_parameters));
			if (_ptr_parameters) {
				NDR_PULL_ALLOC(ndr, r->parameters);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->parameters, _ptr_parameters));
			} else {
				r->parameters = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_driver_name));
			if (_ptr_driver_name) {
				NDR_PULL_ALLOC(ndr, r->driver_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->driver_name, _ptr_driver_name));
			} else {
				r->driver_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_devmode));
		if (_ptr_devmode) {
			NDR_PULL_ALLOC(ndr, r->devmode);
			NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->devmode, _ptr_devmode));
		} else {
			r->devmode = NULL;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_text_status));
			if (_ptr_text_status) {
				NDR_PULL_ALLOC(ndr, r->text_status);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->text_status, _ptr_text_status));
			} else {
				r->text_status = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_secdesc));
		if (_ptr_secdesc) {
			NDR_PULL_ALLOC(ndr, r->secdesc);
			NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->secdesc, _ptr_secdesc));
		} else {
			r->secdesc = NULL;
		}
		NDR_CHECK(ndr_pull_spoolss_JobStatus(ndr, NDR_SCALARS, &r->status));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->priority));
		if (r->priority > 99) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->position));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->start_time));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->until_time));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->total_pages));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_pull_spoolss_Time(ndr, NDR_SCALARS, &r->submitted));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->time));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->pages_printed));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->size_high));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->printer_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->printer_name));
				_mem_save_printer_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->printer_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->printer_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_printer_name_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->server_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->server_name));
				_mem_save_server_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->server_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->server_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_name_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->user_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->user_name));
				_mem_save_user_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->user_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->user_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_user_name_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->document_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->document_name));
				_mem_save_document_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->document_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->document_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_document_name_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->notify_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->notify_name));
				_mem_save_notify_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->notify_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->notify_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_notify_name_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->data_type) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->data_type));
				_mem_save_data_type_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->data_type, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->data_type));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_type_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->print_processor) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->print_processor));
				_mem_save_print_processor_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->print_processor, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->print_processor));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_print_processor_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->parameters) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->parameters));
				_mem_save_parameters_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->parameters, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->parameters));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_parameters_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->driver_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->driver_name));
				_mem_save_driver_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->driver_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->driver_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_driver_name_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		if (r->devmode) {
			uint32_t _relative_save_offset;
			_relative_save_offset = ndr->offset;
			NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->devmode));
			_mem_save_devmode_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->devmode, 0);
			NDR_CHECK(ndr_pull_spoolss_DeviceMode(ndr, NDR_SCALARS, r->devmode));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_devmode_0, 0);
			ndr->offset = _relative_save_offset;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->text_status) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->text_status));
				_mem_save_text_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->text_status, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->text_status));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_text_status_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		if (r->secdesc) {
			uint32_t _relative_save_offset;
			_relative_save_offset = ndr->offset;
			NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->secdesc));
			_mem_save_secdesc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->secdesc, 0);
			NDR_CHECK(ndr_pull_security_descriptor(ndr, NDR_SCALARS|NDR_BUFFERS, r->secdesc));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_secdesc_0, 0);
			ndr->offset = _relative_save_offset;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_JobInfo4(struct ndr_print *ndr, const char *name, const struct spoolss_JobInfo4 *r)
{
	ndr_print_struct(ndr, name, "spoolss_JobInfo4");
	ndr->depth++;
	ndr_print_uint32(ndr, "job_id", r->job_id);
	ndr_print_ptr(ndr, "printer_name", r->printer_name);
	ndr->depth++;
	if (r->printer_name) {
		ndr_print_string(ndr, "printer_name", r->printer_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "server_name", r->server_name);
	ndr->depth++;
	if (r->server_name) {
		ndr_print_string(ndr, "server_name", r->server_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "user_name", r->user_name);
	ndr->depth++;
	if (r->user_name) {
		ndr_print_string(ndr, "user_name", r->user_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "document_name", r->document_name);
	ndr->depth++;
	if (r->document_name) {
		ndr_print_string(ndr, "document_name", r->document_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "notify_name", r->notify_name);
	ndr->depth++;
	if (r->notify_name) {
		ndr_print_string(ndr, "notify_name", r->notify_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "data_type", r->data_type);
	ndr->depth++;
	if (r->data_type) {
		ndr_print_string(ndr, "data_type", r->data_type);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "print_processor", r->print_processor);
	ndr->depth++;
	if (r->print_processor) {
		ndr_print_string(ndr, "print_processor", r->print_processor);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "parameters", r->parameters);
	ndr->depth++;
	if (r->parameters) {
		ndr_print_string(ndr, "parameters", r->parameters);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "driver_name", r->driver_name);
	ndr->depth++;
	if (r->driver_name) {
		ndr_print_string(ndr, "driver_name", r->driver_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "devmode", r->devmode);
	ndr->depth++;
	if (r->devmode) {
		ndr_print_spoolss_DeviceMode(ndr, "devmode", r->devmode);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "text_status", r->text_status);
	ndr->depth++;
	if (r->text_status) {
		ndr_print_string(ndr, "text_status", r->text_status);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "secdesc", r->secdesc);
	ndr->depth++;
	if (r->secdesc) {
		ndr_print_security_descriptor(ndr, "secdesc", r->secdesc);
	}
	ndr->depth--;
	ndr_print_spoolss_JobStatus(ndr, "status", r->status);
	ndr_print_uint32(ndr, "priority", r->priority);
	ndr_print_uint32(ndr, "position", r->position);
	ndr_print_uint32(ndr, "start_time", r->start_time);
	ndr_print_uint32(ndr, "until_time", r->until_time);
	ndr_print_uint32(ndr, "total_pages", r->total_pages);
	ndr_print_uint32(ndr, "size", r->size);
	ndr_print_spoolss_Time(ndr, "submitted", &r->submitted);
	ndr_print_uint32(ndr, "time", r->time);
	ndr_print_uint32(ndr, "pages_printed", r->pages_printed);
	ndr_print_uint32(ndr, "size_high", r->size_high);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_spoolss_JobInfo4(const struct spoolss_JobInfo4 *r, struct smb_iconv_convenience *ic, int flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_spoolss_JobInfo4, ic);
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_JobInfo(struct ndr_push *ndr, int ndr_flags, const union spoolss_JobInfo *r)
{
	uint32_t _save_relative_base_offset = ndr_push_get_relative_base_offset(ndr);
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_align(ndr, 4));
				NDR_CHECK(ndr_push_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_push_spoolss_JobInfo1(ndr, NDR_SCALARS, &r->info1));
			break; }

			case 2: {
				NDR_CHECK(ndr_push_align(ndr, 4));
				NDR_CHECK(ndr_push_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_push_spoolss_JobInfo2(ndr, NDR_SCALARS, &r->info2));
			break; }

			case 3: {
				NDR_CHECK(ndr_push_align(ndr, 4));
				NDR_CHECK(ndr_push_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_push_spoolss_JobInfo3(ndr, NDR_SCALARS, &r->info3));
			break; }

			case 4: {
				NDR_CHECK(ndr_push_align(ndr, 4));
				NDR_CHECK(ndr_push_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_push_spoolss_JobInfo4(ndr, NDR_SCALARS, &r->info4));
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_setup_relative_base_offset2(ndr, r));
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_spoolss_JobInfo1(ndr, NDR_BUFFERS, &r->info1));
			break;

			case 2:
				NDR_CHECK(ndr_push_spoolss_JobInfo2(ndr, NDR_BUFFERS, &r->info2));
			break;

			case 3:
			break;

			case 4:
				NDR_CHECK(ndr_push_spoolss_JobInfo4(ndr, NDR_BUFFERS, &r->info4));
			break;

			default:
			break;

		}
	}
	ndr_push_restore_relative_base_offset(ndr, _save_relative_base_offset);
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_JobInfo(struct ndr_pull *ndr, int ndr_flags, union spoolss_JobInfo *r)
{
	uint32_t _save_relative_base_offset = ndr_pull_get_relative_base_offset(ndr);
	int level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_align(ndr, 4));
				NDR_CHECK(ndr_pull_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_pull_spoolss_JobInfo1(ndr, NDR_SCALARS, &r->info1));
			break; }

			case 2: {
				NDR_CHECK(ndr_pull_align(ndr, 4));
				NDR_CHECK(ndr_pull_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_pull_spoolss_JobInfo2(ndr, NDR_SCALARS, &r->info2));
			break; }

			case 3: {
				NDR_CHECK(ndr_pull_align(ndr, 4));
				NDR_CHECK(ndr_pull_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_pull_spoolss_JobInfo3(ndr, NDR_SCALARS, &r->info3));
			break; }

			case 4: {
				NDR_CHECK(ndr_pull_align(ndr, 4));
				NDR_CHECK(ndr_pull_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_pull_spoolss_JobInfo4(ndr, NDR_SCALARS, &r->info4));
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_setup_relative_base_offset2(ndr, r));
		switch (level) {
			case 1:
				NDR_CHECK(ndr_pull_spoolss_JobInfo1(ndr, NDR_BUFFERS, &r->info1));
			break;

			case 2:
				NDR_CHECK(ndr_pull_spoolss_JobInfo2(ndr, NDR_BUFFERS, &r->info2));
			break;

			case 3:
			break;

			case 4:
				NDR_CHECK(ndr_pull_spoolss_JobInfo4(ndr, NDR_BUFFERS, &r->info4));
			break;

			default:
			break;

		}
	}
	ndr_pull_restore_relative_base_offset(ndr, _save_relative_base_offset);
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_JobInfo(struct ndr_print *ndr, const char *name, const union spoolss_JobInfo *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "spoolss_JobInfo");
	switch (level) {
		case 1:
			ndr_print_spoolss_JobInfo1(ndr, "info1", &r->info1);
		break;

		case 2:
			ndr_print_spoolss_JobInfo2(ndr, "info2", &r->info2);
		break;

		case 3:
			ndr_print_spoolss_JobInfo3(ndr, "info3", &r->info3);
		break;

		case 4:
			ndr_print_spoolss_JobInfo4(ndr, "info4", &r->info4);
		break;

		default:
		break;

	}
}

_PUBLIC_ size_t ndr_size_spoolss_JobInfo(const union spoolss_JobInfo *r, uint32_t level, struct smb_iconv_convenience *ic, int flags)
{
	return ndr_size_union(r, flags, level, (ndr_push_flags_fn_t)ndr_push_spoolss_JobInfo, ic);
}

static enum ndr_err_code ndr_push_spoolss_SetJobInfo1(struct ndr_push *ndr, int ndr_flags, const struct spoolss_SetJobInfo1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->job_id));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->printer_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->server_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->user_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->document_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->data_type));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->text_status));
		NDR_CHECK(ndr_push_spoolss_JobStatus(ndr, NDR_SCALARS, r->status));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->priority));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->position));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->total_pages));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->pages_printed));
		NDR_CHECK(ndr_push_spoolss_Time(ndr, NDR_SCALARS, &r->submitted));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->printer_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->printer_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->printer_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->printer_name, ndr_charset_length(r->printer_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->server_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->server_name, ndr_charset_length(r->server_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->user_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->user_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->user_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->user_name, ndr_charset_length(r->user_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->document_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->document_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->document_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->document_name, ndr_charset_length(r->document_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->data_type) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->data_type, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->data_type, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->data_type, ndr_charset_length(r->data_type, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->text_status) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->text_status, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->text_status, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->text_status, ndr_charset_length(r->text_status, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_SetJobInfo1(struct ndr_pull *ndr, int ndr_flags, struct spoolss_SetJobInfo1 *r)
{
	uint32_t _ptr_printer_name;
	TALLOC_CTX *_mem_save_printer_name_0;
	uint32_t _ptr_server_name;
	TALLOC_CTX *_mem_save_server_name_0;
	uint32_t _ptr_user_name;
	TALLOC_CTX *_mem_save_user_name_0;
	uint32_t _ptr_document_name;
	TALLOC_CTX *_mem_save_document_name_0;
	uint32_t _ptr_data_type;
	TALLOC_CTX *_mem_save_data_type_0;
	uint32_t _ptr_text_status;
	TALLOC_CTX *_mem_save_text_status_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->job_id));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_printer_name));
		if (_ptr_printer_name) {
			NDR_PULL_ALLOC(ndr, r->printer_name);
		} else {
			r->printer_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_name));
		if (_ptr_server_name) {
			NDR_PULL_ALLOC(ndr, r->server_name);
		} else {
			r->server_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_user_name));
		if (_ptr_user_name) {
			NDR_PULL_ALLOC(ndr, r->user_name);
		} else {
			r->user_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_document_name));
		if (_ptr_document_name) {
			NDR_PULL_ALLOC(ndr, r->document_name);
		} else {
			r->document_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_data_type));
		if (_ptr_data_type) {
			NDR_PULL_ALLOC(ndr, r->data_type);
		} else {
			r->data_type = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_text_status));
		if (_ptr_text_status) {
			NDR_PULL_ALLOC(ndr, r->text_status);
		} else {
			r->text_status = NULL;
		}
		NDR_CHECK(ndr_pull_spoolss_JobStatus(ndr, NDR_SCALARS, &r->status));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->priority));
		if (r->priority > 99) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->position));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->total_pages));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->pages_printed));
		NDR_CHECK(ndr_pull_spoolss_Time(ndr, NDR_SCALARS, &r->submitted));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->printer_name) {
			_mem_save_printer_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->printer_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->printer_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->printer_name));
			if (ndr_get_array_length(ndr, &r->printer_name) > ndr_get_array_size(ndr, &r->printer_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->printer_name), ndr_get_array_length(ndr, &r->printer_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->printer_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->printer_name, ndr_get_array_length(ndr, &r->printer_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_printer_name_0, 0);
		}
		if (r->server_name) {
			_mem_save_server_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->server_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->server_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->server_name));
			if (ndr_get_array_length(ndr, &r->server_name) > ndr_get_array_size(ndr, &r->server_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->server_name), ndr_get_array_length(ndr, &r->server_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->server_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->server_name, ndr_get_array_length(ndr, &r->server_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_name_0, 0);
		}
		if (r->user_name) {
			_mem_save_user_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->user_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->user_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->user_name));
			if (ndr_get_array_length(ndr, &r->user_name) > ndr_get_array_size(ndr, &r->user_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->user_name), ndr_get_array_length(ndr, &r->user_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->user_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->user_name, ndr_get_array_length(ndr, &r->user_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_user_name_0, 0);
		}
		if (r->document_name) {
			_mem_save_document_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->document_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->document_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->document_name));
			if (ndr_get_array_length(ndr, &r->document_name) > ndr_get_array_size(ndr, &r->document_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->document_name), ndr_get_array_length(ndr, &r->document_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->document_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->document_name, ndr_get_array_length(ndr, &r->document_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_document_name_0, 0);
		}
		if (r->data_type) {
			_mem_save_data_type_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->data_type, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->data_type));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->data_type));
			if (ndr_get_array_length(ndr, &r->data_type) > ndr_get_array_size(ndr, &r->data_type)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->data_type), ndr_get_array_length(ndr, &r->data_type));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->data_type), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->data_type, ndr_get_array_length(ndr, &r->data_type), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_type_0, 0);
		}
		if (r->text_status) {
			_mem_save_text_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->text_status, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->text_status));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->text_status));
			if (ndr_get_array_length(ndr, &r->text_status) > ndr_get_array_size(ndr, &r->text_status)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->text_status), ndr_get_array_length(ndr, &r->text_status));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->text_status), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->text_status, ndr_get_array_length(ndr, &r->text_status), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_text_status_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_SetJobInfo1(struct ndr_print *ndr, const char *name, const struct spoolss_SetJobInfo1 *r)
{
	ndr_print_struct(ndr, name, "spoolss_SetJobInfo1");
	ndr->depth++;
	ndr_print_uint32(ndr, "job_id", r->job_id);
	ndr_print_ptr(ndr, "printer_name", r->printer_name);
	ndr->depth++;
	if (r->printer_name) {
		ndr_print_string(ndr, "printer_name", r->printer_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "server_name", r->server_name);
	ndr->depth++;
	if (r->server_name) {
		ndr_print_string(ndr, "server_name", r->server_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "user_name", r->user_name);
	ndr->depth++;
	if (r->user_name) {
		ndr_print_string(ndr, "user_name", r->user_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "document_name", r->document_name);
	ndr->depth++;
	if (r->document_name) {
		ndr_print_string(ndr, "document_name", r->document_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "data_type", r->data_type);
	ndr->depth++;
	if (r->data_type) {
		ndr_print_string(ndr, "data_type", r->data_type);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "text_status", r->text_status);
	ndr->depth++;
	if (r->text_status) {
		ndr_print_string(ndr, "text_status", r->text_status);
	}
	ndr->depth--;
	ndr_print_spoolss_JobStatus(ndr, "status", r->status);
	ndr_print_uint32(ndr, "priority", r->priority);
	ndr_print_uint32(ndr, "position", r->position);
	ndr_print_uint32(ndr, "total_pages", r->total_pages);
	ndr_print_uint32(ndr, "pages_printed", r->pages_printed);
	ndr_print_spoolss_Time(ndr, "submitted", &r->submitted);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_SetJobInfo2(struct ndr_push *ndr, int ndr_flags, const struct spoolss_SetJobInfo2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->job_id));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->printer_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->server_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->user_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->document_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->notify_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->data_type));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->print_processor));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->parameters));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->driver_name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->_devmode_ptr));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->text_status));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->_secdesc_ptr));
		NDR_CHECK(ndr_push_spoolss_JobStatus(ndr, NDR_SCALARS, r->status));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->priority));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->position));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->start_time));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->until_time));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->total_pages));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->size));
		NDR_CHECK(ndr_push_spoolss_Time(ndr, NDR_SCALARS, &r->submitted));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->time));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->pages_printed));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->printer_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->printer_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->printer_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->printer_name, ndr_charset_length(r->printer_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->server_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->server_name, ndr_charset_length(r->server_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->user_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->user_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->user_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->user_name, ndr_charset_length(r->user_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->document_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->document_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->document_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->document_name, ndr_charset_length(r->document_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->notify_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->notify_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->notify_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->notify_name, ndr_charset_length(r->notify_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->data_type) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->data_type, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->data_type, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->data_type, ndr_charset_length(r->data_type, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->print_processor) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->print_processor, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->print_processor, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->print_processor, ndr_charset_length(r->print_processor, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->parameters) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->parameters, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->parameters, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->parameters, ndr_charset_length(r->parameters, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->driver_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->driver_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->driver_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->driver_name, ndr_charset_length(r->driver_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->text_status) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->text_status, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->text_status, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->text_status, ndr_charset_length(r->text_status, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_SetJobInfo2(struct ndr_pull *ndr, int ndr_flags, struct spoolss_SetJobInfo2 *r)
{
	uint32_t _ptr_printer_name;
	TALLOC_CTX *_mem_save_printer_name_0;
	uint32_t _ptr_server_name;
	TALLOC_CTX *_mem_save_server_name_0;
	uint32_t _ptr_user_name;
	TALLOC_CTX *_mem_save_user_name_0;
	uint32_t _ptr_document_name;
	TALLOC_CTX *_mem_save_document_name_0;
	uint32_t _ptr_notify_name;
	TALLOC_CTX *_mem_save_notify_name_0;
	uint32_t _ptr_data_type;
	TALLOC_CTX *_mem_save_data_type_0;
	uint32_t _ptr_print_processor;
	TALLOC_CTX *_mem_save_print_processor_0;
	uint32_t _ptr_parameters;
	TALLOC_CTX *_mem_save_parameters_0;
	uint32_t _ptr_driver_name;
	TALLOC_CTX *_mem_save_driver_name_0;
	uint32_t _ptr_text_status;
	TALLOC_CTX *_mem_save_text_status_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->job_id));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_printer_name));
		if (_ptr_printer_name) {
			NDR_PULL_ALLOC(ndr, r->printer_name);
		} else {
			r->printer_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_name));
		if (_ptr_server_name) {
			NDR_PULL_ALLOC(ndr, r->server_name);
		} else {
			r->server_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_user_name));
		if (_ptr_user_name) {
			NDR_PULL_ALLOC(ndr, r->user_name);
		} else {
			r->user_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_document_name));
		if (_ptr_document_name) {
			NDR_PULL_ALLOC(ndr, r->document_name);
		} else {
			r->document_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_notify_name));
		if (_ptr_notify_name) {
			NDR_PULL_ALLOC(ndr, r->notify_name);
		} else {
			r->notify_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_data_type));
		if (_ptr_data_type) {
			NDR_PULL_ALLOC(ndr, r->data_type);
		} else {
			r->data_type = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_print_processor));
		if (_ptr_print_processor) {
			NDR_PULL_ALLOC(ndr, r->print_processor);
		} else {
			r->print_processor = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_parameters));
		if (_ptr_parameters) {
			NDR_PULL_ALLOC(ndr, r->parameters);
		} else {
			r->parameters = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_driver_name));
		if (_ptr_driver_name) {
			NDR_PULL_ALLOC(ndr, r->driver_name);
		} else {
			r->driver_name = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->_devmode_ptr));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_text_status));
		if (_ptr_text_status) {
			NDR_PULL_ALLOC(ndr, r->text_status);
		} else {
			r->text_status = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->_secdesc_ptr));
		NDR_CHECK(ndr_pull_spoolss_JobStatus(ndr, NDR_SCALARS, &r->status));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->priority));
		if (r->priority > 99) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->position));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->start_time));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->until_time));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->total_pages));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_pull_spoolss_Time(ndr, NDR_SCALARS, &r->submitted));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->time));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->pages_printed));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->printer_name) {
			_mem_save_printer_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->printer_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->printer_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->printer_name));
			if (ndr_get_array_length(ndr, &r->printer_name) > ndr_get_array_size(ndr, &r->printer_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->printer_name), ndr_get_array_length(ndr, &r->printer_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->printer_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->printer_name, ndr_get_array_length(ndr, &r->printer_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_printer_name_0, 0);
		}
		if (r->server_name) {
			_mem_save_server_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->server_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->server_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->server_name));
			if (ndr_get_array_length(ndr, &r->server_name) > ndr_get_array_size(ndr, &r->server_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->server_name), ndr_get_array_length(ndr, &r->server_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->server_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->server_name, ndr_get_array_length(ndr, &r->server_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_name_0, 0);
		}
		if (r->user_name) {
			_mem_save_user_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->user_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->user_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->user_name));
			if (ndr_get_array_length(ndr, &r->user_name) > ndr_get_array_size(ndr, &r->user_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->user_name), ndr_get_array_length(ndr, &r->user_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->user_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->user_name, ndr_get_array_length(ndr, &r->user_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_user_name_0, 0);
		}
		if (r->document_name) {
			_mem_save_document_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->document_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->document_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->document_name));
			if (ndr_get_array_length(ndr, &r->document_name) > ndr_get_array_size(ndr, &r->document_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->document_name), ndr_get_array_length(ndr, &r->document_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->document_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->document_name, ndr_get_array_length(ndr, &r->document_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_document_name_0, 0);
		}
		if (r->notify_name) {
			_mem_save_notify_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->notify_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->notify_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->notify_name));
			if (ndr_get_array_length(ndr, &r->notify_name) > ndr_get_array_size(ndr, &r->notify_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->notify_name), ndr_get_array_length(ndr, &r->notify_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->notify_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->notify_name, ndr_get_array_length(ndr, &r->notify_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_notify_name_0, 0);
		}
		if (r->data_type) {
			_mem_save_data_type_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->data_type, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->data_type));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->data_type));
			if (ndr_get_array_length(ndr, &r->data_type) > ndr_get_array_size(ndr, &r->data_type)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->data_type), ndr_get_array_length(ndr, &r->data_type));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->data_type), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->data_type, ndr_get_array_length(ndr, &r->data_type), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_type_0, 0);
		}
		if (r->print_processor) {
			_mem_save_print_processor_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->print_processor, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->print_processor));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->print_processor));
			if (ndr_get_array_length(ndr, &r->print_processor) > ndr_get_array_size(ndr, &r->print_processor)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->print_processor), ndr_get_array_length(ndr, &r->print_processor));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->print_processor), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->print_processor, ndr_get_array_length(ndr, &r->print_processor), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_print_processor_0, 0);
		}
		if (r->parameters) {
			_mem_save_parameters_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->parameters, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->parameters));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->parameters));
			if (ndr_get_array_length(ndr, &r->parameters) > ndr_get_array_size(ndr, &r->parameters)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->parameters), ndr_get_array_length(ndr, &r->parameters));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->parameters), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->parameters, ndr_get_array_length(ndr, &r->parameters), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_parameters_0, 0);
		}
		if (r->driver_name) {
			_mem_save_driver_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->driver_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->driver_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->driver_name));
			if (ndr_get_array_length(ndr, &r->driver_name) > ndr_get_array_size(ndr, &r->driver_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->driver_name), ndr_get_array_length(ndr, &r->driver_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->driver_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->driver_name, ndr_get_array_length(ndr, &r->driver_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_driver_name_0, 0);
		}
		if (r->text_status) {
			_mem_save_text_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->text_status, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->text_status));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->text_status));
			if (ndr_get_array_length(ndr, &r->text_status) > ndr_get_array_size(ndr, &r->text_status)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->text_status), ndr_get_array_length(ndr, &r->text_status));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->text_status), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->text_status, ndr_get_array_length(ndr, &r->text_status), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_text_status_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_SetJobInfo2(struct ndr_print *ndr, const char *name, const struct spoolss_SetJobInfo2 *r)
{
	ndr_print_struct(ndr, name, "spoolss_SetJobInfo2");
	ndr->depth++;
	ndr_print_uint32(ndr, "job_id", r->job_id);
	ndr_print_ptr(ndr, "printer_name", r->printer_name);
	ndr->depth++;
	if (r->printer_name) {
		ndr_print_string(ndr, "printer_name", r->printer_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "server_name", r->server_name);
	ndr->depth++;
	if (r->server_name) {
		ndr_print_string(ndr, "server_name", r->server_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "user_name", r->user_name);
	ndr->depth++;
	if (r->user_name) {
		ndr_print_string(ndr, "user_name", r->user_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "document_name", r->document_name);
	ndr->depth++;
	if (r->document_name) {
		ndr_print_string(ndr, "document_name", r->document_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "notify_name", r->notify_name);
	ndr->depth++;
	if (r->notify_name) {
		ndr_print_string(ndr, "notify_name", r->notify_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "data_type", r->data_type);
	ndr->depth++;
	if (r->data_type) {
		ndr_print_string(ndr, "data_type", r->data_type);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "print_processor", r->print_processor);
	ndr->depth++;
	if (r->print_processor) {
		ndr_print_string(ndr, "print_processor", r->print_processor);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "parameters", r->parameters);
	ndr->depth++;
	if (r->parameters) {
		ndr_print_string(ndr, "parameters", r->parameters);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "driver_name", r->driver_name);
	ndr->depth++;
	if (r->driver_name) {
		ndr_print_string(ndr, "driver_name", r->driver_name);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "_devmode_ptr", r->_devmode_ptr);
	ndr_print_ptr(ndr, "text_status", r->text_status);
	ndr->depth++;
	if (r->text_status) {
		ndr_print_string(ndr, "text_status", r->text_status);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "_secdesc_ptr", r->_secdesc_ptr);
	ndr_print_spoolss_JobStatus(ndr, "status", r->status);
	ndr_print_uint32(ndr, "priority", r->priority);
	ndr_print_uint32(ndr, "position", r->position);
	ndr_print_uint32(ndr, "start_time", r->start_time);
	ndr_print_uint32(ndr, "until_time", r->until_time);
	ndr_print_uint32(ndr, "total_pages", r->total_pages);
	ndr_print_uint32(ndr, "size", r->size);
	ndr_print_spoolss_Time(ndr, "submitted", &r->submitted);
	ndr_print_uint32(ndr, "time", r->time);
	ndr_print_uint32(ndr, "pages_printed", r->pages_printed);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_SetJobInfo4(struct ndr_push *ndr, int ndr_flags, const struct spoolss_SetJobInfo4 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->job_id));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->printer_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->server_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->user_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->document_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->notify_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->data_type));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->print_processor));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->parameters));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->driver_name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->_devmode_ptr));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->text_status));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->_secdesc_ptr));
		NDR_CHECK(ndr_push_spoolss_JobStatus(ndr, NDR_SCALARS, r->status));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->priority));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->position));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->start_time));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->until_time));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->total_pages));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->size));
		NDR_CHECK(ndr_push_spoolss_Time(ndr, NDR_SCALARS, &r->submitted));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->time));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->pages_printed));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->size_high));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->printer_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->printer_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->printer_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->printer_name, ndr_charset_length(r->printer_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->server_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->server_name, ndr_charset_length(r->server_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->user_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->user_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->user_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->user_name, ndr_charset_length(r->user_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->document_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->document_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->document_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->document_name, ndr_charset_length(r->document_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->notify_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->notify_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->notify_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->notify_name, ndr_charset_length(r->notify_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->data_type) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->data_type, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->data_type, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->data_type, ndr_charset_length(r->data_type, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->print_processor) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->print_processor, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->print_processor, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->print_processor, ndr_charset_length(r->print_processor, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->parameters) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->parameters, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->parameters, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->parameters, ndr_charset_length(r->parameters, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->driver_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->driver_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->driver_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->driver_name, ndr_charset_length(r->driver_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->text_status) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->text_status, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->text_status, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->text_status, ndr_charset_length(r->text_status, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_SetJobInfo4(struct ndr_pull *ndr, int ndr_flags, struct spoolss_SetJobInfo4 *r)
{
	uint32_t _ptr_printer_name;
	TALLOC_CTX *_mem_save_printer_name_0;
	uint32_t _ptr_server_name;
	TALLOC_CTX *_mem_save_server_name_0;
	uint32_t _ptr_user_name;
	TALLOC_CTX *_mem_save_user_name_0;
	uint32_t _ptr_document_name;
	TALLOC_CTX *_mem_save_document_name_0;
	uint32_t _ptr_notify_name;
	TALLOC_CTX *_mem_save_notify_name_0;
	uint32_t _ptr_data_type;
	TALLOC_CTX *_mem_save_data_type_0;
	uint32_t _ptr_print_processor;
	TALLOC_CTX *_mem_save_print_processor_0;
	uint32_t _ptr_parameters;
	TALLOC_CTX *_mem_save_parameters_0;
	uint32_t _ptr_driver_name;
	TALLOC_CTX *_mem_save_driver_name_0;
	uint32_t _ptr_text_status;
	TALLOC_CTX *_mem_save_text_status_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->job_id));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_printer_name));
		if (_ptr_printer_name) {
			NDR_PULL_ALLOC(ndr, r->printer_name);
		} else {
			r->printer_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_name));
		if (_ptr_server_name) {
			NDR_PULL_ALLOC(ndr, r->server_name);
		} else {
			r->server_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_user_name));
		if (_ptr_user_name) {
			NDR_PULL_ALLOC(ndr, r->user_name);
		} else {
			r->user_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_document_name));
		if (_ptr_document_name) {
			NDR_PULL_ALLOC(ndr, r->document_name);
		} else {
			r->document_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_notify_name));
		if (_ptr_notify_name) {
			NDR_PULL_ALLOC(ndr, r->notify_name);
		} else {
			r->notify_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_data_type));
		if (_ptr_data_type) {
			NDR_PULL_ALLOC(ndr, r->data_type);
		} else {
			r->data_type = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_print_processor));
		if (_ptr_print_processor) {
			NDR_PULL_ALLOC(ndr, r->print_processor);
		} else {
			r->print_processor = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_parameters));
		if (_ptr_parameters) {
			NDR_PULL_ALLOC(ndr, r->parameters);
		} else {
			r->parameters = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_driver_name));
		if (_ptr_driver_name) {
			NDR_PULL_ALLOC(ndr, r->driver_name);
		} else {
			r->driver_name = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->_devmode_ptr));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_text_status));
		if (_ptr_text_status) {
			NDR_PULL_ALLOC(ndr, r->text_status);
		} else {
			r->text_status = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->_secdesc_ptr));
		NDR_CHECK(ndr_pull_spoolss_JobStatus(ndr, NDR_SCALARS, &r->status));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->priority));
		if (r->priority > 99) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->position));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->start_time));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->until_time));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->total_pages));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_pull_spoolss_Time(ndr, NDR_SCALARS, &r->submitted));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->time));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->pages_printed));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->size_high));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->printer_name) {
			_mem_save_printer_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->printer_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->printer_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->printer_name));
			if (ndr_get_array_length(ndr, &r->printer_name) > ndr_get_array_size(ndr, &r->printer_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->printer_name), ndr_get_array_length(ndr, &r->printer_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->printer_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->printer_name, ndr_get_array_length(ndr, &r->printer_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_printer_name_0, 0);
		}
		if (r->server_name) {
			_mem_save_server_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->server_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->server_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->server_name));
			if (ndr_get_array_length(ndr, &r->server_name) > ndr_get_array_size(ndr, &r->server_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->server_name), ndr_get_array_length(ndr, &r->server_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->server_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->server_name, ndr_get_array_length(ndr, &r->server_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_name_0, 0);
		}
		if (r->user_name) {
			_mem_save_user_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->user_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->user_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->user_name));
			if (ndr_get_array_length(ndr, &r->user_name) > ndr_get_array_size(ndr, &r->user_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->user_name), ndr_get_array_length(ndr, &r->user_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->user_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->user_name, ndr_get_array_length(ndr, &r->user_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_user_name_0, 0);
		}
		if (r->document_name) {
			_mem_save_document_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->document_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->document_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->document_name));
			if (ndr_get_array_length(ndr, &r->document_name) > ndr_get_array_size(ndr, &r->document_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->document_name), ndr_get_array_length(ndr, &r->document_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->document_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->document_name, ndr_get_array_length(ndr, &r->document_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_document_name_0, 0);
		}
		if (r->notify_name) {
			_mem_save_notify_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->notify_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->notify_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->notify_name));
			if (ndr_get_array_length(ndr, &r->notify_name) > ndr_get_array_size(ndr, &r->notify_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->notify_name), ndr_get_array_length(ndr, &r->notify_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->notify_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->notify_name, ndr_get_array_length(ndr, &r->notify_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_notify_name_0, 0);
		}
		if (r->data_type) {
			_mem_save_data_type_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->data_type, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->data_type));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->data_type));
			if (ndr_get_array_length(ndr, &r->data_type) > ndr_get_array_size(ndr, &r->data_type)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->data_type), ndr_get_array_length(ndr, &r->data_type));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->data_type), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->data_type, ndr_get_array_length(ndr, &r->data_type), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_type_0, 0);
		}
		if (r->print_processor) {
			_mem_save_print_processor_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->print_processor, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->print_processor));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->print_processor));
			if (ndr_get_array_length(ndr, &r->print_processor) > ndr_get_array_size(ndr, &r->print_processor)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->print_processor), ndr_get_array_length(ndr, &r->print_processor));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->print_processor), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->print_processor, ndr_get_array_length(ndr, &r->print_processor), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_print_processor_0, 0);
		}
		if (r->parameters) {
			_mem_save_parameters_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->parameters, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->parameters));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->parameters));
			if (ndr_get_array_length(ndr, &r->parameters) > ndr_get_array_size(ndr, &r->parameters)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->parameters), ndr_get_array_length(ndr, &r->parameters));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->parameters), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->parameters, ndr_get_array_length(ndr, &r->parameters), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_parameters_0, 0);
		}
		if (r->driver_name) {
			_mem_save_driver_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->driver_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->driver_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->driver_name));
			if (ndr_get_array_length(ndr, &r->driver_name) > ndr_get_array_size(ndr, &r->driver_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->driver_name), ndr_get_array_length(ndr, &r->driver_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->driver_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->driver_name, ndr_get_array_length(ndr, &r->driver_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_driver_name_0, 0);
		}
		if (r->text_status) {
			_mem_save_text_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->text_status, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->text_status));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->text_status));
			if (ndr_get_array_length(ndr, &r->text_status) > ndr_get_array_size(ndr, &r->text_status)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->text_status), ndr_get_array_length(ndr, &r->text_status));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->text_status), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->text_status, ndr_get_array_length(ndr, &r->text_status), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_text_status_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_SetJobInfo4(struct ndr_print *ndr, const char *name, const struct spoolss_SetJobInfo4 *r)
{
	ndr_print_struct(ndr, name, "spoolss_SetJobInfo4");
	ndr->depth++;
	ndr_print_uint32(ndr, "job_id", r->job_id);
	ndr_print_ptr(ndr, "printer_name", r->printer_name);
	ndr->depth++;
	if (r->printer_name) {
		ndr_print_string(ndr, "printer_name", r->printer_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "server_name", r->server_name);
	ndr->depth++;
	if (r->server_name) {
		ndr_print_string(ndr, "server_name", r->server_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "user_name", r->user_name);
	ndr->depth++;
	if (r->user_name) {
		ndr_print_string(ndr, "user_name", r->user_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "document_name", r->document_name);
	ndr->depth++;
	if (r->document_name) {
		ndr_print_string(ndr, "document_name", r->document_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "notify_name", r->notify_name);
	ndr->depth++;
	if (r->notify_name) {
		ndr_print_string(ndr, "notify_name", r->notify_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "data_type", r->data_type);
	ndr->depth++;
	if (r->data_type) {
		ndr_print_string(ndr, "data_type", r->data_type);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "print_processor", r->print_processor);
	ndr->depth++;
	if (r->print_processor) {
		ndr_print_string(ndr, "print_processor", r->print_processor);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "parameters", r->parameters);
	ndr->depth++;
	if (r->parameters) {
		ndr_print_string(ndr, "parameters", r->parameters);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "driver_name", r->driver_name);
	ndr->depth++;
	if (r->driver_name) {
		ndr_print_string(ndr, "driver_name", r->driver_name);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "_devmode_ptr", r->_devmode_ptr);
	ndr_print_ptr(ndr, "text_status", r->text_status);
	ndr->depth++;
	if (r->text_status) {
		ndr_print_string(ndr, "text_status", r->text_status);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "_secdesc_ptr", r->_secdesc_ptr);
	ndr_print_spoolss_JobStatus(ndr, "status", r->status);
	ndr_print_uint32(ndr, "priority", r->priority);
	ndr_print_uint32(ndr, "position", r->position);
	ndr_print_uint32(ndr, "start_time", r->start_time);
	ndr_print_uint32(ndr, "until_time", r->until_time);
	ndr_print_uint32(ndr, "total_pages", r->total_pages);
	ndr_print_uint32(ndr, "size", r->size);
	ndr_print_spoolss_Time(ndr, "submitted", &r->submitted);
	ndr_print_uint32(ndr, "time", r->time);
	ndr_print_uint32(ndr, "pages_printed", r->pages_printed);
	ndr_print_uint32(ndr, "size_high", r->size_high);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_SetJobInfo(struct ndr_push *ndr, int ndr_flags, const union spoolss_SetJobInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1));
			break; }

			case 2: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info2));
			break; }

			case 3: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info3));
			break; }

			case 4: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info4));
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 1:
				if (r->info1) {
					NDR_CHECK(ndr_push_spoolss_SetJobInfo1(ndr, NDR_SCALARS|NDR_BUFFERS, r->info1));
				}
			break;

			case 2:
				if (r->info2) {
					NDR_CHECK(ndr_push_spoolss_SetJobInfo2(ndr, NDR_SCALARS|NDR_BUFFERS, r->info2));
				}
			break;

			case 3:
				if (r->info3) {
					NDR_CHECK(ndr_push_spoolss_JobInfo3(ndr, NDR_SCALARS, r->info3));
				}
			break;

			case 4:
				if (r->info4) {
					NDR_CHECK(ndr_push_spoolss_SetJobInfo4(ndr, NDR_SCALARS|NDR_BUFFERS, r->info4));
				}
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_SetJobInfo(struct ndr_pull *ndr, int ndr_flags, union spoolss_SetJobInfo *r)
{
	int level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_info1_0;
	TALLOC_CTX *_mem_save_info2_0;
	TALLOC_CTX *_mem_save_info3_0;
	TALLOC_CTX *_mem_save_info4_0;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r", _level);
		}
		switch (level) {
			case 1: {
				uint32_t _ptr_info1;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1));
				if (_ptr_info1) {
					NDR_PULL_ALLOC(ndr, r->info1);
				} else {
					r->info1 = NULL;
				}
			break; }

			case 2: {
				uint32_t _ptr_info2;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info2));
				if (_ptr_info2) {
					NDR_PULL_ALLOC(ndr, r->info2);
				} else {
					r->info2 = NULL;
				}
			break; }

			case 3: {
				uint32_t _ptr_info3;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info3));
				if (_ptr_info3) {
					NDR_PULL_ALLOC(ndr, r->info3);
				} else {
					r->info3 = NULL;
				}
			break; }

			case 4: {
				uint32_t _ptr_info4;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info4));
				if (_ptr_info4) {
					NDR_PULL_ALLOC(ndr, r->info4);
				} else {
					r->info4 = NULL;
				}
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
				if (r->info1) {
					_mem_save_info1_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1, 0);
					NDR_CHECK(ndr_pull_spoolss_SetJobInfo1(ndr, NDR_SCALARS|NDR_BUFFERS, r->info1));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1_0, 0);
				}
			break;

			case 2:
				if (r->info2) {
					_mem_save_info2_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info2, 0);
					NDR_CHECK(ndr_pull_spoolss_SetJobInfo2(ndr, NDR_SCALARS|NDR_BUFFERS, r->info2));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info2_0, 0);
				}
			break;

			case 3:
				if (r->info3) {
					_mem_save_info3_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info3, 0);
					NDR_CHECK(ndr_pull_spoolss_JobInfo3(ndr, NDR_SCALARS, r->info3));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info3_0, 0);
				}
			break;

			case 4:
				if (r->info4) {
					_mem_save_info4_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info4, 0);
					NDR_CHECK(ndr_pull_spoolss_SetJobInfo4(ndr, NDR_SCALARS|NDR_BUFFERS, r->info4));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info4_0, 0);
				}
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_SetJobInfo(struct ndr_print *ndr, const char *name, const union spoolss_SetJobInfo *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "spoolss_SetJobInfo");
	switch (level) {
		case 1:
			ndr_print_ptr(ndr, "info1", r->info1);
			ndr->depth++;
			if (r->info1) {
				ndr_print_spoolss_SetJobInfo1(ndr, "info1", r->info1);
			}
			ndr->depth--;
		break;

		case 2:
			ndr_print_ptr(ndr, "info2", r->info2);
			ndr->depth++;
			if (r->info2) {
				ndr_print_spoolss_SetJobInfo2(ndr, "info2", r->info2);
			}
			ndr->depth--;
		break;

		case 3:
			ndr_print_ptr(ndr, "info3", r->info3);
			ndr->depth++;
			if (r->info3) {
				ndr_print_spoolss_JobInfo3(ndr, "info3", r->info3);
			}
			ndr->depth--;
		break;

		case 4:
			ndr_print_ptr(ndr, "info4", r->info4);
			ndr->depth++;
			if (r->info4) {
				ndr_print_spoolss_SetJobInfo4(ndr, "info4", r->info4);
			}
			ndr->depth--;
		break;

		default:
		break;

	}
}

static enum ndr_err_code ndr_push_spoolss_JobInfoContainer(struct ndr_push *ndr, int ndr_flags, const struct spoolss_JobInfoContainer *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->info, r->level));
		NDR_CHECK(ndr_push_spoolss_SetJobInfo(ndr, NDR_SCALARS, &r->info));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_spoolss_SetJobInfo(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_JobInfoContainer(struct ndr_pull *ndr, int ndr_flags, struct spoolss_JobInfoContainer *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->level));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->info, r->level));
		NDR_CHECK(ndr_pull_spoolss_SetJobInfo(ndr, NDR_SCALARS, &r->info));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_spoolss_SetJobInfo(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_JobInfoContainer(struct ndr_print *ndr, const char *name, const struct spoolss_JobInfoContainer *r)
{
	ndr_print_struct(ndr, name, "spoolss_JobInfoContainer");
	ndr->depth++;
	ndr_print_uint32(ndr, "level", r->level);
	ndr_print_set_switch_value(ndr, &r->info, r->level);
	ndr_print_spoolss_SetJobInfo(ndr, "info", &r->info);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_JobControl(struct ndr_push *ndr, int ndr_flags, enum spoolss_JobControl r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_JobControl(struct ndr_pull *ndr, int ndr_flags, enum spoolss_JobControl *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_JobControl(struct ndr_print *ndr, const char *name, enum spoolss_JobControl r)
{
	const char *val = NULL;

	switch (r) {
		case SPOOLSS_JOB_CONTROL_PAUSE: val = "SPOOLSS_JOB_CONTROL_PAUSE"; break;
		case SPOOLSS_JOB_CONTROL_RESUME: val = "SPOOLSS_JOB_CONTROL_RESUME"; break;
		case SPOOLSS_JOB_CONTROL_CANCEL: val = "SPOOLSS_JOB_CONTROL_CANCEL"; break;
		case SPOOLSS_JOB_CONTROL_RESTART: val = "SPOOLSS_JOB_CONTROL_RESTART"; break;
		case SPOOLSS_JOB_CONTROL_DELETE: val = "SPOOLSS_JOB_CONTROL_DELETE"; break;
		case SPOOLSS_JOB_CONTROL_SEND_TO_PRINTER: val = "SPOOLSS_JOB_CONTROL_SEND_TO_PRINTER"; break;
		case SPOOLSS_JOB_CONTROL_LAST_PAGE_EJECTED: val = "SPOOLSS_JOB_CONTROL_LAST_PAGE_EJECTED"; break;
		case SPOOLSS_JOB_CONTROL_RETAIN: val = "SPOOLSS_JOB_CONTROL_RETAIN"; break;
		case SPOOLSS_JOB_CONTROL_RELEASE: val = "SPOOLSS_JOB_CONTROL_RELEASE"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_spoolss_PrinterControl(struct ndr_push *ndr, int ndr_flags, enum spoolss_PrinterControl r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_PrinterControl(struct ndr_pull *ndr, int ndr_flags, enum spoolss_PrinterControl *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_PrinterControl(struct ndr_print *ndr, const char *name, enum spoolss_PrinterControl r)
{
	const char *val = NULL;

	switch (r) {
		case SPOOLSS_PRINTER_CONTROL_UNPAUSE: val = "SPOOLSS_PRINTER_CONTROL_UNPAUSE"; break;
		case SPOOLSS_PRINTER_CONTROL_PAUSE: val = "SPOOLSS_PRINTER_CONTROL_PAUSE"; break;
		case SPOOLSS_PRINTER_CONTROL_RESUME: val = "SPOOLSS_PRINTER_CONTROL_RESUME"; break;
		case SPOOLSS_PRINTER_CONTROL_PURGE: val = "SPOOLSS_PRINTER_CONTROL_PURGE"; break;
		case SPOOLSS_PRINTER_CONTROL_SET_STATUS: val = "SPOOLSS_PRINTER_CONTROL_SET_STATUS"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_spoolss_SetPrinterInfo0(struct ndr_push *ndr, int ndr_flags, const struct spoolss_SetPrinterInfo0 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->servername));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->printername));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->cjobs));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->total_jobs));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->total_bytes));
		NDR_CHECK(ndr_push_spoolss_Time(ndr, NDR_SCALARS, &r->time));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->global_counter));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->total_pages));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->free_build));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->spooling));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->max_spooling));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->session_counter));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_error_out_of_paper));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_error_not_ready));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->job_error));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->number_of_processors));
		NDR_CHECK(ndr_push_spoolss_ProcessorType(ndr, NDR_SCALARS, r->processor_type));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->high_part_total_bytes));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->change_id));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->last_error));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->status));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->enumerate_network_printers));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->c_setprinter));
		NDR_CHECK(ndr_push_spoolss_ProcessorArchitecture(ndr, NDR_SCALARS, r->processor_architecture));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->processor_level));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->ref_ic));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->reserved2));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->reserved3));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->servername) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->servername, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->servername, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->servername, ndr_charset_length(r->servername, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->printername) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->printername, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->printername, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->printername, ndr_charset_length(r->printername, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_SetPrinterInfo0(struct ndr_pull *ndr, int ndr_flags, struct spoolss_SetPrinterInfo0 *r)
{
	uint32_t _ptr_servername;
	TALLOC_CTX *_mem_save_servername_0;
	uint32_t _ptr_printername;
	TALLOC_CTX *_mem_save_printername_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_servername));
		if (_ptr_servername) {
			NDR_PULL_ALLOC(ndr, r->servername);
		} else {
			r->servername = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_printername));
		if (_ptr_printername) {
			NDR_PULL_ALLOC(ndr, r->printername);
		} else {
			r->printername = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->cjobs));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->total_jobs));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->total_bytes));
		NDR_CHECK(ndr_pull_spoolss_Time(ndr, NDR_SCALARS, &r->time));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->global_counter));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->total_pages));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->free_build));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->spooling));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->max_spooling));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->session_counter));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_error_out_of_paper));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_error_not_ready));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->job_error));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->number_of_processors));
		NDR_CHECK(ndr_pull_spoolss_ProcessorType(ndr, NDR_SCALARS, &r->processor_type));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->high_part_total_bytes));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->change_id));
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->last_error));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->status));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->enumerate_network_printers));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->c_setprinter));
		NDR_CHECK(ndr_pull_spoolss_ProcessorArchitecture(ndr, NDR_SCALARS, &r->processor_architecture));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->processor_level));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->ref_ic));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved2));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved3));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->servername) {
			_mem_save_servername_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->servername, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->servername));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->servername));
			if (ndr_get_array_length(ndr, &r->servername) > ndr_get_array_size(ndr, &r->servername)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->servername), ndr_get_array_length(ndr, &r->servername));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->servername), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->servername, ndr_get_array_length(ndr, &r->servername), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_servername_0, 0);
		}
		if (r->printername) {
			_mem_save_printername_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->printername, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->printername));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->printername));
			if (ndr_get_array_length(ndr, &r->printername) > ndr_get_array_size(ndr, &r->printername)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->printername), ndr_get_array_length(ndr, &r->printername));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->printername), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->printername, ndr_get_array_length(ndr, &r->printername), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_printername_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_SetPrinterInfo0(struct ndr_print *ndr, const char *name, const struct spoolss_SetPrinterInfo0 *r)
{
	ndr_print_struct(ndr, name, "spoolss_SetPrinterInfo0");
	ndr->depth++;
	ndr_print_ptr(ndr, "servername", r->servername);
	ndr->depth++;
	if (r->servername) {
		ndr_print_string(ndr, "servername", r->servername);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "printername", r->printername);
	ndr->depth++;
	if (r->printername) {
		ndr_print_string(ndr, "printername", r->printername);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "cjobs", r->cjobs);
	ndr_print_uint32(ndr, "total_jobs", r->total_jobs);
	ndr_print_uint32(ndr, "total_bytes", r->total_bytes);
	ndr_print_spoolss_Time(ndr, "time", &r->time);
	ndr_print_uint32(ndr, "global_counter", r->global_counter);
	ndr_print_uint32(ndr, "total_pages", r->total_pages);
	ndr_print_uint32(ndr, "version", r->version);
	ndr_print_uint32(ndr, "free_build", r->free_build);
	ndr_print_uint32(ndr, "spooling", r->spooling);
	ndr_print_uint32(ndr, "max_spooling", r->max_spooling);
	ndr_print_uint32(ndr, "session_counter", r->session_counter);
	ndr_print_uint32(ndr, "num_error_out_of_paper", r->num_error_out_of_paper);
	ndr_print_uint32(ndr, "num_error_not_ready", r->num_error_not_ready);
	ndr_print_uint32(ndr, "job_error", r->job_error);
	ndr_print_uint32(ndr, "number_of_processors", r->number_of_processors);
	ndr_print_spoolss_ProcessorType(ndr, "processor_type", r->processor_type);
	ndr_print_uint32(ndr, "high_part_total_bytes", r->high_part_total_bytes);
	ndr_print_uint32(ndr, "change_id", r->change_id);
	ndr_print_WERROR(ndr, "last_error", r->last_error);
	ndr_print_uint32(ndr, "status", r->status);
	ndr_print_uint32(ndr, "enumerate_network_printers", r->enumerate_network_printers);
	ndr_print_uint32(ndr, "c_setprinter", r->c_setprinter);
	ndr_print_spoolss_ProcessorArchitecture(ndr, "processor_architecture", r->processor_architecture);
	ndr_print_uint16(ndr, "processor_level", r->processor_level);
	ndr_print_uint32(ndr, "ref_ic", r->ref_ic);
	ndr_print_uint32(ndr, "reserved2", r->reserved2);
	ndr_print_uint32(ndr, "reserved3", r->reserved3);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_SetPrinterInfo1(struct ndr_push *ndr, int ndr_flags, const struct spoolss_SetPrinterInfo1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_spoolss_EnumPrinterFlags(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->description));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->comment));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->description) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->description, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->description, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->description, ndr_charset_length(r->description, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->name, ndr_charset_length(r->name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->comment) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->comment, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->comment, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->comment, ndr_charset_length(r->comment, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_SetPrinterInfo1(struct ndr_pull *ndr, int ndr_flags, struct spoolss_SetPrinterInfo1 *r)
{
	uint32_t _ptr_description;
	TALLOC_CTX *_mem_save_description_0;
	uint32_t _ptr_name;
	TALLOC_CTX *_mem_save_name_0;
	uint32_t _ptr_comment;
	TALLOC_CTX *_mem_save_comment_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_spoolss_EnumPrinterFlags(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_description));
		if (_ptr_description) {
			NDR_PULL_ALLOC(ndr, r->description);
		} else {
			r->description = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_name));
		if (_ptr_name) {
			NDR_PULL_ALLOC(ndr, r->name);
		} else {
			r->name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_comment));
		if (_ptr_comment) {
			NDR_PULL_ALLOC(ndr, r->comment);
		} else {
			r->comment = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->description) {
			_mem_save_description_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->description, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->description));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->description));
			if (ndr_get_array_length(ndr, &r->description) > ndr_get_array_size(ndr, &r->description)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->description), ndr_get_array_length(ndr, &r->description));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->description), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->description, ndr_get_array_length(ndr, &r->description), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_description_0, 0);
		}
		if (r->name) {
			_mem_save_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->name));
			if (ndr_get_array_length(ndr, &r->name) > ndr_get_array_size(ndr, &r->name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->name), ndr_get_array_length(ndr, &r->name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->name, ndr_get_array_length(ndr, &r->name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_0, 0);
		}
		if (r->comment) {
			_mem_save_comment_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->comment, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->comment));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->comment));
			if (ndr_get_array_length(ndr, &r->comment) > ndr_get_array_size(ndr, &r->comment)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->comment), ndr_get_array_length(ndr, &r->comment));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->comment), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->comment, ndr_get_array_length(ndr, &r->comment), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_comment_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_SetPrinterInfo1(struct ndr_print *ndr, const char *name, const struct spoolss_SetPrinterInfo1 *r)
{
	ndr_print_struct(ndr, name, "spoolss_SetPrinterInfo1");
	ndr->depth++;
	ndr_print_spoolss_EnumPrinterFlags(ndr, "flags", r->flags);
	ndr_print_ptr(ndr, "description", r->description);
	ndr->depth++;
	if (r->description) {
		ndr_print_string(ndr, "description", r->description);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "name", r->name);
	ndr->depth++;
	if (r->name) {
		ndr_print_string(ndr, "name", r->name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "comment", r->comment);
	ndr->depth++;
	if (r->comment) {
		ndr_print_string(ndr, "comment", r->comment);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_SetPrinterInfo2(struct ndr_push *ndr, int ndr_flags, const struct spoolss_SetPrinterInfo2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->servername));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->printername));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->sharename));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->portname));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->drivername));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->comment));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->location));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->devmode));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->sepfile));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->printprocessor));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->datatype));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->parameters));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->secdesc));
		NDR_CHECK(ndr_push_spoolss_PrinterAttributes(ndr, NDR_SCALARS, r->attributes));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->priority));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->defaultpriority));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->starttime));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->untiltime));
		NDR_CHECK(ndr_push_spoolss_PrinterStatus(ndr, NDR_SCALARS, r->status));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->cjobs));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->averageppm));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->servername) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->servername, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->servername, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->servername, ndr_charset_length(r->servername, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->printername) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->printername, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->printername, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->printername, ndr_charset_length(r->printername, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->sharename) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->sharename, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->sharename, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->sharename, ndr_charset_length(r->sharename, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->portname) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->portname, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->portname, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->portname, ndr_charset_length(r->portname, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->drivername) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->drivername, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->drivername, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->drivername, ndr_charset_length(r->drivername, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->comment) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->comment, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->comment, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->comment, ndr_charset_length(r->comment, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->location) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->location, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->location, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->location, ndr_charset_length(r->location, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->devmode) {
			{
				struct ndr_push *_ndr_devmode;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_devmode, 0, -1));
				NDR_CHECK(ndr_push_spoolss_DeviceMode(_ndr_devmode, NDR_SCALARS, r->devmode));
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_devmode, 0, -1));
			}
		}
		if (r->sepfile) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->sepfile, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->sepfile, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->sepfile, ndr_charset_length(r->sepfile, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->printprocessor) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->printprocessor, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->printprocessor, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->printprocessor, ndr_charset_length(r->printprocessor, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->datatype) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->datatype, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->datatype, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->datatype, ndr_charset_length(r->datatype, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->parameters) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->parameters, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->parameters, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->parameters, ndr_charset_length(r->parameters, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->secdesc) {
			{
				struct ndr_push *_ndr_secdesc;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_secdesc, 0, -1));
				NDR_CHECK(ndr_push_security_descriptor(_ndr_secdesc, NDR_SCALARS|NDR_BUFFERS, r->secdesc));
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_secdesc, 0, -1));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_SetPrinterInfo2(struct ndr_pull *ndr, int ndr_flags, struct spoolss_SetPrinterInfo2 *r)
{
	uint32_t _ptr_servername;
	TALLOC_CTX *_mem_save_servername_0;
	uint32_t _ptr_printername;
	TALLOC_CTX *_mem_save_printername_0;
	uint32_t _ptr_sharename;
	TALLOC_CTX *_mem_save_sharename_0;
	uint32_t _ptr_portname;
	TALLOC_CTX *_mem_save_portname_0;
	uint32_t _ptr_drivername;
	TALLOC_CTX *_mem_save_drivername_0;
	uint32_t _ptr_comment;
	TALLOC_CTX *_mem_save_comment_0;
	uint32_t _ptr_location;
	TALLOC_CTX *_mem_save_location_0;
	uint32_t _ptr_devmode;
	TALLOC_CTX *_mem_save_devmode_0;
	uint32_t _ptr_sepfile;
	TALLOC_CTX *_mem_save_sepfile_0;
	uint32_t _ptr_printprocessor;
	TALLOC_CTX *_mem_save_printprocessor_0;
	uint32_t _ptr_datatype;
	TALLOC_CTX *_mem_save_datatype_0;
	uint32_t _ptr_parameters;
	TALLOC_CTX *_mem_save_parameters_0;
	uint32_t _ptr_secdesc;
	TALLOC_CTX *_mem_save_secdesc_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_servername));
		if (_ptr_servername) {
			NDR_PULL_ALLOC(ndr, r->servername);
		} else {
			r->servername = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_printername));
		if (_ptr_printername) {
			NDR_PULL_ALLOC(ndr, r->printername);
		} else {
			r->printername = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sharename));
		if (_ptr_sharename) {
			NDR_PULL_ALLOC(ndr, r->sharename);
		} else {
			r->sharename = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_portname));
		if (_ptr_portname) {
			NDR_PULL_ALLOC(ndr, r->portname);
		} else {
			r->portname = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_drivername));
		if (_ptr_drivername) {
			NDR_PULL_ALLOC(ndr, r->drivername);
		} else {
			r->drivername = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_comment));
		if (_ptr_comment) {
			NDR_PULL_ALLOC(ndr, r->comment);
		} else {
			r->comment = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_location));
		if (_ptr_location) {
			NDR_PULL_ALLOC(ndr, r->location);
		} else {
			r->location = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_devmode));
		if (_ptr_devmode) {
			NDR_PULL_ALLOC(ndr, r->devmode);
		} else {
			r->devmode = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sepfile));
		if (_ptr_sepfile) {
			NDR_PULL_ALLOC(ndr, r->sepfile);
		} else {
			r->sepfile = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_printprocessor));
		if (_ptr_printprocessor) {
			NDR_PULL_ALLOC(ndr, r->printprocessor);
		} else {
			r->printprocessor = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_datatype));
		if (_ptr_datatype) {
			NDR_PULL_ALLOC(ndr, r->datatype);
		} else {
			r->datatype = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_parameters));
		if (_ptr_parameters) {
			NDR_PULL_ALLOC(ndr, r->parameters);
		} else {
			r->parameters = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_secdesc));
		if (_ptr_secdesc) {
			NDR_PULL_ALLOC(ndr, r->secdesc);
		} else {
			r->secdesc = NULL;
		}
		NDR_CHECK(ndr_pull_spoolss_PrinterAttributes(ndr, NDR_SCALARS, &r->attributes));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->priority));
		if (r->priority > 99) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->defaultpriority));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->starttime));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->untiltime));
		NDR_CHECK(ndr_pull_spoolss_PrinterStatus(ndr, NDR_SCALARS, &r->status));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->cjobs));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->averageppm));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->servername) {
			_mem_save_servername_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->servername, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->servername));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->servername));
			if (ndr_get_array_length(ndr, &r->servername) > ndr_get_array_size(ndr, &r->servername)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->servername), ndr_get_array_length(ndr, &r->servername));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->servername), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->servername, ndr_get_array_length(ndr, &r->servername), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_servername_0, 0);
		}
		if (r->printername) {
			_mem_save_printername_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->printername, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->printername));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->printername));
			if (ndr_get_array_length(ndr, &r->printername) > ndr_get_array_size(ndr, &r->printername)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->printername), ndr_get_array_length(ndr, &r->printername));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->printername), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->printername, ndr_get_array_length(ndr, &r->printername), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_printername_0, 0);
		}
		if (r->sharename) {
			_mem_save_sharename_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sharename, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->sharename));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->sharename));
			if (ndr_get_array_length(ndr, &r->sharename) > ndr_get_array_size(ndr, &r->sharename)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->sharename), ndr_get_array_length(ndr, &r->sharename));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->sharename), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->sharename, ndr_get_array_length(ndr, &r->sharename), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sharename_0, 0);
		}
		if (r->portname) {
			_mem_save_portname_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->portname, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->portname));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->portname));
			if (ndr_get_array_length(ndr, &r->portname) > ndr_get_array_size(ndr, &r->portname)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->portname), ndr_get_array_length(ndr, &r->portname));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->portname), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->portname, ndr_get_array_length(ndr, &r->portname), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_portname_0, 0);
		}
		if (r->drivername) {
			_mem_save_drivername_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->drivername, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->drivername));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->drivername));
			if (ndr_get_array_length(ndr, &r->drivername) > ndr_get_array_size(ndr, &r->drivername)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->drivername), ndr_get_array_length(ndr, &r->drivername));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->drivername), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->drivername, ndr_get_array_length(ndr, &r->drivername), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_drivername_0, 0);
		}
		if (r->comment) {
			_mem_save_comment_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->comment, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->comment));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->comment));
			if (ndr_get_array_length(ndr, &r->comment) > ndr_get_array_size(ndr, &r->comment)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->comment), ndr_get_array_length(ndr, &r->comment));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->comment), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->comment, ndr_get_array_length(ndr, &r->comment), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_comment_0, 0);
		}
		if (r->location) {
			_mem_save_location_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->location, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->location));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->location));
			if (ndr_get_array_length(ndr, &r->location) > ndr_get_array_size(ndr, &r->location)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->location), ndr_get_array_length(ndr, &r->location));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->location), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->location, ndr_get_array_length(ndr, &r->location), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_location_0, 0);
		}
		if (r->devmode) {
			_mem_save_devmode_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->devmode, 0);
			{
				struct ndr_pull *_ndr_devmode;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_devmode, 0, -1));
				NDR_CHECK(ndr_pull_spoolss_DeviceMode(_ndr_devmode, NDR_SCALARS, r->devmode));
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_devmode, 0, -1));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_devmode_0, 0);
		}
		if (r->sepfile) {
			_mem_save_sepfile_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sepfile, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->sepfile));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->sepfile));
			if (ndr_get_array_length(ndr, &r->sepfile) > ndr_get_array_size(ndr, &r->sepfile)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->sepfile), ndr_get_array_length(ndr, &r->sepfile));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->sepfile), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->sepfile, ndr_get_array_length(ndr, &r->sepfile), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sepfile_0, 0);
		}
		if (r->printprocessor) {
			_mem_save_printprocessor_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->printprocessor, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->printprocessor));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->printprocessor));
			if (ndr_get_array_length(ndr, &r->printprocessor) > ndr_get_array_size(ndr, &r->printprocessor)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->printprocessor), ndr_get_array_length(ndr, &r->printprocessor));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->printprocessor), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->printprocessor, ndr_get_array_length(ndr, &r->printprocessor), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_printprocessor_0, 0);
		}
		if (r->datatype) {
			_mem_save_datatype_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->datatype, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->datatype));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->datatype));
			if (ndr_get_array_length(ndr, &r->datatype) > ndr_get_array_size(ndr, &r->datatype)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->datatype), ndr_get_array_length(ndr, &r->datatype));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->datatype), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->datatype, ndr_get_array_length(ndr, &r->datatype), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_datatype_0, 0);
		}
		if (r->parameters) {
			_mem_save_parameters_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->parameters, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->parameters));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->parameters));
			if (ndr_get_array_length(ndr, &r->parameters) > ndr_get_array_size(ndr, &r->parameters)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->parameters), ndr_get_array_length(ndr, &r->parameters));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->parameters), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->parameters, ndr_get_array_length(ndr, &r->parameters), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_parameters_0, 0);
		}
		if (r->secdesc) {
			_mem_save_secdesc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->secdesc, 0);
			{
				struct ndr_pull *_ndr_secdesc;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_secdesc, 0, -1));
				NDR_CHECK(ndr_pull_security_descriptor(_ndr_secdesc, NDR_SCALARS|NDR_BUFFERS, r->secdesc));
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_secdesc, 0, -1));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_secdesc_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_SetPrinterInfo2(struct ndr_print *ndr, const char *name, const struct spoolss_SetPrinterInfo2 *r)
{
	ndr_print_struct(ndr, name, "spoolss_SetPrinterInfo2");
	ndr->depth++;
	ndr_print_ptr(ndr, "servername", r->servername);
	ndr->depth++;
	if (r->servername) {
		ndr_print_string(ndr, "servername", r->servername);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "printername", r->printername);
	ndr->depth++;
	if (r->printername) {
		ndr_print_string(ndr, "printername", r->printername);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "sharename", r->sharename);
	ndr->depth++;
	if (r->sharename) {
		ndr_print_string(ndr, "sharename", r->sharename);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "portname", r->portname);
	ndr->depth++;
	if (r->portname) {
		ndr_print_string(ndr, "portname", r->portname);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "drivername", r->drivername);
	ndr->depth++;
	if (r->drivername) {
		ndr_print_string(ndr, "drivername", r->drivername);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "comment", r->comment);
	ndr->depth++;
	if (r->comment) {
		ndr_print_string(ndr, "comment", r->comment);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "location", r->location);
	ndr->depth++;
	if (r->location) {
		ndr_print_string(ndr, "location", r->location);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "devmode", r->devmode);
	ndr->depth++;
	if (r->devmode) {
		ndr_print_spoolss_DeviceMode(ndr, "devmode", r->devmode);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "sepfile", r->sepfile);
	ndr->depth++;
	if (r->sepfile) {
		ndr_print_string(ndr, "sepfile", r->sepfile);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "printprocessor", r->printprocessor);
	ndr->depth++;
	if (r->printprocessor) {
		ndr_print_string(ndr, "printprocessor", r->printprocessor);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "datatype", r->datatype);
	ndr->depth++;
	if (r->datatype) {
		ndr_print_string(ndr, "datatype", r->datatype);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "parameters", r->parameters);
	ndr->depth++;
	if (r->parameters) {
		ndr_print_string(ndr, "parameters", r->parameters);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "secdesc", r->secdesc);
	ndr->depth++;
	if (r->secdesc) {
		ndr_print_security_descriptor(ndr, "secdesc", r->secdesc);
	}
	ndr->depth--;
	ndr_print_spoolss_PrinterAttributes(ndr, "attributes", r->attributes);
	ndr_print_uint32(ndr, "priority", r->priority);
	ndr_print_uint32(ndr, "defaultpriority", r->defaultpriority);
	ndr_print_uint32(ndr, "starttime", r->starttime);
	ndr_print_uint32(ndr, "untiltime", r->untiltime);
	ndr_print_spoolss_PrinterStatus(ndr, "status", r->status);
	ndr_print_uint32(ndr, "cjobs", r->cjobs);
	ndr_print_uint32(ndr, "averageppm", r->averageppm);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_SetPrinterInfo3(struct ndr_push *ndr, int ndr_flags, const struct spoolss_SetPrinterInfo3 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sec_desc_ptr));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_SetPrinterInfo3(struct ndr_pull *ndr, int ndr_flags, struct spoolss_SetPrinterInfo3 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sec_desc_ptr));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_SetPrinterInfo3(struct ndr_print *ndr, const char *name, const struct spoolss_SetPrinterInfo3 *r)
{
	ndr_print_struct(ndr, name, "spoolss_SetPrinterInfo3");
	ndr->depth++;
	ndr_print_uint32(ndr, "sec_desc_ptr", r->sec_desc_ptr);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_SetPrinterInfo4(struct ndr_push *ndr, int ndr_flags, const struct spoolss_SetPrinterInfo4 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->printername));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->servername));
		NDR_CHECK(ndr_push_spoolss_PrinterAttributes(ndr, NDR_SCALARS, r->attributes));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->printername) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->printername, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->printername, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->printername, ndr_charset_length(r->printername, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->servername) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->servername, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->servername, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->servername, ndr_charset_length(r->servername, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_SetPrinterInfo4(struct ndr_pull *ndr, int ndr_flags, struct spoolss_SetPrinterInfo4 *r)
{
	uint32_t _ptr_printername;
	TALLOC_CTX *_mem_save_printername_0;
	uint32_t _ptr_servername;
	TALLOC_CTX *_mem_save_servername_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_printername));
		if (_ptr_printername) {
			NDR_PULL_ALLOC(ndr, r->printername);
		} else {
			r->printername = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_servername));
		if (_ptr_servername) {
			NDR_PULL_ALLOC(ndr, r->servername);
		} else {
			r->servername = NULL;
		}
		NDR_CHECK(ndr_pull_spoolss_PrinterAttributes(ndr, NDR_SCALARS, &r->attributes));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->printername) {
			_mem_save_printername_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->printername, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->printername));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->printername));
			if (ndr_get_array_length(ndr, &r->printername) > ndr_get_array_size(ndr, &r->printername)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->printername), ndr_get_array_length(ndr, &r->printername));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->printername), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->printername, ndr_get_array_length(ndr, &r->printername), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_printername_0, 0);
		}
		if (r->servername) {
			_mem_save_servername_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->servername, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->servername));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->servername));
			if (ndr_get_array_length(ndr, &r->servername) > ndr_get_array_size(ndr, &r->servername)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->servername), ndr_get_array_length(ndr, &r->servername));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->servername), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->servername, ndr_get_array_length(ndr, &r->servername), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_servername_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_SetPrinterInfo4(struct ndr_print *ndr, const char *name, const struct spoolss_SetPrinterInfo4 *r)
{
	ndr_print_struct(ndr, name, "spoolss_SetPrinterInfo4");
	ndr->depth++;
	ndr_print_ptr(ndr, "printername", r->printername);
	ndr->depth++;
	if (r->printername) {
		ndr_print_string(ndr, "printername", r->printername);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "servername", r->servername);
	ndr->depth++;
	if (r->servername) {
		ndr_print_string(ndr, "servername", r->servername);
	}
	ndr->depth--;
	ndr_print_spoolss_PrinterAttributes(ndr, "attributes", r->attributes);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_SetPrinterInfo5(struct ndr_push *ndr, int ndr_flags, const struct spoolss_SetPrinterInfo5 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->printername));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->portname));
		NDR_CHECK(ndr_push_spoolss_PrinterAttributes(ndr, NDR_SCALARS, r->attributes));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->device_not_selected_timeout));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->transmission_retry_timeout));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->printername) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->printername, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->printername, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->printername, ndr_charset_length(r->printername, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->portname) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->portname, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->portname, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->portname, ndr_charset_length(r->portname, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_SetPrinterInfo5(struct ndr_pull *ndr, int ndr_flags, struct spoolss_SetPrinterInfo5 *r)
{
	uint32_t _ptr_printername;
	TALLOC_CTX *_mem_save_printername_0;
	uint32_t _ptr_portname;
	TALLOC_CTX *_mem_save_portname_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_printername));
		if (_ptr_printername) {
			NDR_PULL_ALLOC(ndr, r->printername);
		} else {
			r->printername = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_portname));
		if (_ptr_portname) {
			NDR_PULL_ALLOC(ndr, r->portname);
		} else {
			r->portname = NULL;
		}
		NDR_CHECK(ndr_pull_spoolss_PrinterAttributes(ndr, NDR_SCALARS, &r->attributes));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->device_not_selected_timeout));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->transmission_retry_timeout));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->printername) {
			_mem_save_printername_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->printername, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->printername));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->printername));
			if (ndr_get_array_length(ndr, &r->printername) > ndr_get_array_size(ndr, &r->printername)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->printername), ndr_get_array_length(ndr, &r->printername));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->printername), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->printername, ndr_get_array_length(ndr, &r->printername), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_printername_0, 0);
		}
		if (r->portname) {
			_mem_save_portname_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->portname, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->portname));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->portname));
			if (ndr_get_array_length(ndr, &r->portname) > ndr_get_array_size(ndr, &r->portname)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->portname), ndr_get_array_length(ndr, &r->portname));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->portname), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->portname, ndr_get_array_length(ndr, &r->portname), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_portname_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_SetPrinterInfo5(struct ndr_print *ndr, const char *name, const struct spoolss_SetPrinterInfo5 *r)
{
	ndr_print_struct(ndr, name, "spoolss_SetPrinterInfo5");
	ndr->depth++;
	ndr_print_ptr(ndr, "printername", r->printername);
	ndr->depth++;
	if (r->printername) {
		ndr_print_string(ndr, "printername", r->printername);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "portname", r->portname);
	ndr->depth++;
	if (r->portname) {
		ndr_print_string(ndr, "portname", r->portname);
	}
	ndr->depth--;
	ndr_print_spoolss_PrinterAttributes(ndr, "attributes", r->attributes);
	ndr_print_uint32(ndr, "device_not_selected_timeout", r->device_not_selected_timeout);
	ndr_print_uint32(ndr, "transmission_retry_timeout", r->transmission_retry_timeout);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_SetPrinterInfo6(struct ndr_push *ndr, int ndr_flags, const struct spoolss_SetPrinterInfo6 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_spoolss_PrinterStatus(ndr, NDR_SCALARS, r->status));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_SetPrinterInfo6(struct ndr_pull *ndr, int ndr_flags, struct spoolss_SetPrinterInfo6 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_spoolss_PrinterStatus(ndr, NDR_SCALARS, &r->status));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_SetPrinterInfo6(struct ndr_print *ndr, const char *name, const struct spoolss_SetPrinterInfo6 *r)
{
	ndr_print_struct(ndr, name, "spoolss_SetPrinterInfo6");
	ndr->depth++;
	ndr_print_spoolss_PrinterStatus(ndr, "status", r->status);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_SetPrinterInfo7(struct ndr_push *ndr, int ndr_flags, const struct spoolss_SetPrinterInfo7 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->guid));
		NDR_CHECK(ndr_push_spoolss_DsPrintAction(ndr, NDR_SCALARS, r->action));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->guid) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->guid, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->guid, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->guid, ndr_charset_length(r->guid, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_SetPrinterInfo7(struct ndr_pull *ndr, int ndr_flags, struct spoolss_SetPrinterInfo7 *r)
{
	uint32_t _ptr_guid;
	TALLOC_CTX *_mem_save_guid_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_guid));
		if (_ptr_guid) {
			NDR_PULL_ALLOC(ndr, r->guid);
		} else {
			r->guid = NULL;
		}
		NDR_CHECK(ndr_pull_spoolss_DsPrintAction(ndr, NDR_SCALARS, &r->action));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->guid) {
			_mem_save_guid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->guid, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->guid));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->guid));
			if (ndr_get_array_length(ndr, &r->guid) > ndr_get_array_size(ndr, &r->guid)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->guid), ndr_get_array_length(ndr, &r->guid));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->guid), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->guid, ndr_get_array_length(ndr, &r->guid), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_guid_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_SetPrinterInfo7(struct ndr_print *ndr, const char *name, const struct spoolss_SetPrinterInfo7 *r)
{
	ndr_print_struct(ndr, name, "spoolss_SetPrinterInfo7");
	ndr->depth++;
	ndr_print_ptr(ndr, "guid", r->guid);
	ndr->depth++;
	if (r->guid) {
		ndr_print_string(ndr, "guid", r->guid);
	}
	ndr->depth--;
	ndr_print_spoolss_DsPrintAction(ndr, "action", r->action);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_SetPrinterInfo(struct ndr_push *ndr, int ndr_flags, const union spoolss_SetPrinterInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info0));
			break; }

			case 1: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1));
			break; }

			case 2: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info2));
			break; }

			case 3: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info3));
			break; }

			case 4: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info4));
			break; }

			case 5: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info5));
			break; }

			case 6: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info6));
			break; }

			case 7: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info7));
			break; }

			case 8: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info8));
			break; }

			case 9: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info9));
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 0:
				if (r->info0) {
					NDR_CHECK(ndr_push_spoolss_SetPrinterInfo0(ndr, NDR_SCALARS|NDR_BUFFERS, r->info0));
				}
			break;

			case 1:
				if (r->info1) {
					NDR_CHECK(ndr_push_spoolss_SetPrinterInfo1(ndr, NDR_SCALARS|NDR_BUFFERS, r->info1));
				}
			break;

			case 2:
				if (r->info2) {
					NDR_CHECK(ndr_push_spoolss_SetPrinterInfo2(ndr, NDR_SCALARS|NDR_BUFFERS, r->info2));
				}
			break;

			case 3:
				if (r->info3) {
					NDR_CHECK(ndr_push_spoolss_SetPrinterInfo3(ndr, NDR_SCALARS, r->info3));
				}
			break;

			case 4:
				if (r->info4) {
					NDR_CHECK(ndr_push_spoolss_SetPrinterInfo4(ndr, NDR_SCALARS|NDR_BUFFERS, r->info4));
				}
			break;

			case 5:
				if (r->info5) {
					NDR_CHECK(ndr_push_spoolss_SetPrinterInfo5(ndr, NDR_SCALARS|NDR_BUFFERS, r->info5));
				}
			break;

			case 6:
				if (r->info6) {
					NDR_CHECK(ndr_push_spoolss_SetPrinterInfo6(ndr, NDR_SCALARS, r->info6));
				}
			break;

			case 7:
				if (r->info7) {
					NDR_CHECK(ndr_push_spoolss_SetPrinterInfo7(ndr, NDR_SCALARS|NDR_BUFFERS, r->info7));
				}
			break;

			case 8:
				if (r->info8) {
					NDR_CHECK(ndr_push_spoolss_DeviceModeInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->info8));
				}
			break;

			case 9:
				if (r->info9) {
					NDR_CHECK(ndr_push_spoolss_DeviceModeInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->info9));
				}
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_SetPrinterInfo(struct ndr_pull *ndr, int ndr_flags, union spoolss_SetPrinterInfo *r)
{
	int level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_info0_0;
	TALLOC_CTX *_mem_save_info1_0;
	TALLOC_CTX *_mem_save_info2_0;
	TALLOC_CTX *_mem_save_info3_0;
	TALLOC_CTX *_mem_save_info4_0;
	TALLOC_CTX *_mem_save_info5_0;
	TALLOC_CTX *_mem_save_info6_0;
	TALLOC_CTX *_mem_save_info7_0;
	TALLOC_CTX *_mem_save_info8_0;
	TALLOC_CTX *_mem_save_info9_0;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r", _level);
		}
		switch (level) {
			case 0: {
				uint32_t _ptr_info0;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info0));
				if (_ptr_info0) {
					NDR_PULL_ALLOC(ndr, r->info0);
				} else {
					r->info0 = NULL;
				}
			break; }

			case 1: {
				uint32_t _ptr_info1;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1));
				if (_ptr_info1) {
					NDR_PULL_ALLOC(ndr, r->info1);
				} else {
					r->info1 = NULL;
				}
			break; }

			case 2: {
				uint32_t _ptr_info2;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info2));
				if (_ptr_info2) {
					NDR_PULL_ALLOC(ndr, r->info2);
				} else {
					r->info2 = NULL;
				}
			break; }

			case 3: {
				uint32_t _ptr_info3;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info3));
				if (_ptr_info3) {
					NDR_PULL_ALLOC(ndr, r->info3);
				} else {
					r->info3 = NULL;
				}
			break; }

			case 4: {
				uint32_t _ptr_info4;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info4));
				if (_ptr_info4) {
					NDR_PULL_ALLOC(ndr, r->info4);
				} else {
					r->info4 = NULL;
				}
			break; }

			case 5: {
				uint32_t _ptr_info5;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info5));
				if (_ptr_info5) {
					NDR_PULL_ALLOC(ndr, r->info5);
				} else {
					r->info5 = NULL;
				}
			break; }

			case 6: {
				uint32_t _ptr_info6;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info6));
				if (_ptr_info6) {
					NDR_PULL_ALLOC(ndr, r->info6);
				} else {
					r->info6 = NULL;
				}
			break; }

			case 7: {
				uint32_t _ptr_info7;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info7));
				if (_ptr_info7) {
					NDR_PULL_ALLOC(ndr, r->info7);
				} else {
					r->info7 = NULL;
				}
			break; }

			case 8: {
				uint32_t _ptr_info8;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info8));
				if (_ptr_info8) {
					NDR_PULL_ALLOC(ndr, r->info8);
				} else {
					r->info8 = NULL;
				}
			break; }

			case 9: {
				uint32_t _ptr_info9;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info9));
				if (_ptr_info9) {
					NDR_PULL_ALLOC(ndr, r->info9);
				} else {
					r->info9 = NULL;
				}
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 0:
				if (r->info0) {
					_mem_save_info0_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info0, 0);
					NDR_CHECK(ndr_pull_spoolss_SetPrinterInfo0(ndr, NDR_SCALARS|NDR_BUFFERS, r->info0));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info0_0, 0);
				}
			break;

			case 1:
				if (r->info1) {
					_mem_save_info1_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1, 0);
					NDR_CHECK(ndr_pull_spoolss_SetPrinterInfo1(ndr, NDR_SCALARS|NDR_BUFFERS, r->info1));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1_0, 0);
				}
			break;

			case 2:
				if (r->info2) {
					_mem_save_info2_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info2, 0);
					NDR_CHECK(ndr_pull_spoolss_SetPrinterInfo2(ndr, NDR_SCALARS|NDR_BUFFERS, r->info2));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info2_0, 0);
				}
			break;

			case 3:
				if (r->info3) {
					_mem_save_info3_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info3, 0);
					NDR_CHECK(ndr_pull_spoolss_SetPrinterInfo3(ndr, NDR_SCALARS, r->info3));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info3_0, 0);
				}
			break;

			case 4:
				if (r->info4) {
					_mem_save_info4_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info4, 0);
					NDR_CHECK(ndr_pull_spoolss_SetPrinterInfo4(ndr, NDR_SCALARS|NDR_BUFFERS, r->info4));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info4_0, 0);
				}
			break;

			case 5:
				if (r->info5) {
					_mem_save_info5_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info5, 0);
					NDR_CHECK(ndr_pull_spoolss_SetPrinterInfo5(ndr, NDR_SCALARS|NDR_BUFFERS, r->info5));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info5_0, 0);
				}
			break;

			case 6:
				if (r->info6) {
					_mem_save_info6_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info6, 0);
					NDR_CHECK(ndr_pull_spoolss_SetPrinterInfo6(ndr, NDR_SCALARS, r->info6));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info6_0, 0);
				}
			break;

			case 7:
				if (r->info7) {
					_mem_save_info7_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info7, 0);
					NDR_CHECK(ndr_pull_spoolss_SetPrinterInfo7(ndr, NDR_SCALARS|NDR_BUFFERS, r->info7));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info7_0, 0);
				}
			break;

			case 8:
				if (r->info8) {
					_mem_save_info8_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info8, 0);
					NDR_CHECK(ndr_pull_spoolss_DeviceModeInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->info8));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info8_0, 0);
				}
			break;

			case 9:
				if (r->info9) {
					_mem_save_info9_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info9, 0);
					NDR_CHECK(ndr_pull_spoolss_DeviceModeInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->info9));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info9_0, 0);
				}
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_SetPrinterInfo(struct ndr_print *ndr, const char *name, const union spoolss_SetPrinterInfo *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "spoolss_SetPrinterInfo");
	switch (level) {
		case 0:
			ndr_print_ptr(ndr, "info0", r->info0);
			ndr->depth++;
			if (r->info0) {
				ndr_print_spoolss_SetPrinterInfo0(ndr, "info0", r->info0);
			}
			ndr->depth--;
		break;

		case 1:
			ndr_print_ptr(ndr, "info1", r->info1);
			ndr->depth++;
			if (r->info1) {
				ndr_print_spoolss_SetPrinterInfo1(ndr, "info1", r->info1);
			}
			ndr->depth--;
		break;

		case 2:
			ndr_print_ptr(ndr, "info2", r->info2);
			ndr->depth++;
			if (r->info2) {
				ndr_print_spoolss_SetPrinterInfo2(ndr, "info2", r->info2);
			}
			ndr->depth--;
		break;

		case 3:
			ndr_print_ptr(ndr, "info3", r->info3);
			ndr->depth++;
			if (r->info3) {
				ndr_print_spoolss_SetPrinterInfo3(ndr, "info3", r->info3);
			}
			ndr->depth--;
		break;

		case 4:
			ndr_print_ptr(ndr, "info4", r->info4);
			ndr->depth++;
			if (r->info4) {
				ndr_print_spoolss_SetPrinterInfo4(ndr, "info4", r->info4);
			}
			ndr->depth--;
		break;

		case 5:
			ndr_print_ptr(ndr, "info5", r->info5);
			ndr->depth++;
			if (r->info5) {
				ndr_print_spoolss_SetPrinterInfo5(ndr, "info5", r->info5);
			}
			ndr->depth--;
		break;

		case 6:
			ndr_print_ptr(ndr, "info6", r->info6);
			ndr->depth++;
			if (r->info6) {
				ndr_print_spoolss_SetPrinterInfo6(ndr, "info6", r->info6);
			}
			ndr->depth--;
		break;

		case 7:
			ndr_print_ptr(ndr, "info7", r->info7);
			ndr->depth++;
			if (r->info7) {
				ndr_print_spoolss_SetPrinterInfo7(ndr, "info7", r->info7);
			}
			ndr->depth--;
		break;

		case 8:
			ndr_print_ptr(ndr, "info8", r->info8);
			ndr->depth++;
			if (r->info8) {
				ndr_print_spoolss_DeviceModeInfo(ndr, "info8", r->info8);
			}
			ndr->depth--;
		break;

		case 9:
			ndr_print_ptr(ndr, "info9", r->info9);
			ndr->depth++;
			if (r->info9) {
				ndr_print_spoolss_DeviceModeInfo(ndr, "info9", r->info9);
			}
			ndr->depth--;
		break;

		default:
		break;

	}
}

static enum ndr_err_code ndr_push_spoolss_SetPrinterInfoCtr(struct ndr_push *ndr, int ndr_flags, const struct spoolss_SetPrinterInfoCtr *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->info, r->level));
		NDR_CHECK(ndr_push_spoolss_SetPrinterInfo(ndr, NDR_SCALARS, &r->info));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_spoolss_SetPrinterInfo(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_SetPrinterInfoCtr(struct ndr_pull *ndr, int ndr_flags, struct spoolss_SetPrinterInfoCtr *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->level));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->info, r->level));
		NDR_CHECK(ndr_pull_spoolss_SetPrinterInfo(ndr, NDR_SCALARS, &r->info));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_spoolss_SetPrinterInfo(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_SetPrinterInfoCtr(struct ndr_print *ndr, const char *name, const struct spoolss_SetPrinterInfoCtr *r)
{
	ndr_print_struct(ndr, name, "spoolss_SetPrinterInfoCtr");
	ndr->depth++;
	ndr_print_uint32(ndr, "level", r->level);
	ndr_print_set_switch_value(ndr, &r->info, r->level);
	ndr_print_spoolss_SetPrinterInfo(ndr, "info", &r->info);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_StringArray(struct ndr_push *ndr, int ndr_flags, const struct spoolss_StringArray *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, (ndr_size_spoolss_StringArray(r, ndr->iconv_convenience, ndr->flags) - 4) / 2));
		{
			uint32_t _flags_save_string_array = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string_array(ndr, NDR_SCALARS, r->string));
			ndr->flags = _flags_save_string_array;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_StringArray(struct ndr_pull *ndr, int ndr_flags, struct spoolss_StringArray *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->_ndr_size));
		{
			uint32_t _flags_save_string_array = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string_array(ndr, NDR_SCALARS, &r->string));
			ndr->flags = _flags_save_string_array;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_StringArray(struct ndr_print *ndr, const char *name, const struct spoolss_StringArray *r)
{
	ndr_print_struct(ndr, name, "spoolss_StringArray");
	ndr->depth++;
	ndr_print_uint32(ndr, "_ndr_size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?(ndr_size_spoolss_StringArray(r, ndr->iconv_convenience, ndr->flags) - 4) / 2:r->_ndr_size);
	ndr_print_string_array(ndr, "string", r->string);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_AddDriverInfo1(struct ndr_push *ndr, int ndr_flags, const struct spoolss_AddDriverInfo1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->driver_name));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->driver_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->driver_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->driver_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->driver_name, ndr_charset_length(r->driver_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_AddDriverInfo1(struct ndr_pull *ndr, int ndr_flags, struct spoolss_AddDriverInfo1 *r)
{
	uint32_t _ptr_driver_name;
	TALLOC_CTX *_mem_save_driver_name_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_driver_name));
		if (_ptr_driver_name) {
			NDR_PULL_ALLOC(ndr, r->driver_name);
		} else {
			r->driver_name = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->driver_name) {
			_mem_save_driver_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->driver_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->driver_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->driver_name));
			if (ndr_get_array_length(ndr, &r->driver_name) > ndr_get_array_size(ndr, &r->driver_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->driver_name), ndr_get_array_length(ndr, &r->driver_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->driver_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->driver_name, ndr_get_array_length(ndr, &r->driver_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_driver_name_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_AddDriverInfo1(struct ndr_print *ndr, const char *name, const struct spoolss_AddDriverInfo1 *r)
{
	ndr_print_struct(ndr, name, "spoolss_AddDriverInfo1");
	ndr->depth++;
	ndr_print_ptr(ndr, "driver_name", r->driver_name);
	ndr->depth++;
	if (r->driver_name) {
		ndr_print_string(ndr, "driver_name", r->driver_name);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_DriverOSVersion(struct ndr_push *ndr, int ndr_flags, enum spoolss_DriverOSVersion r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_DriverOSVersion(struct ndr_pull *ndr, int ndr_flags, enum spoolss_DriverOSVersion *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_DriverOSVersion(struct ndr_print *ndr, const char *name, enum spoolss_DriverOSVersion r)
{
	const char *val = NULL;

	switch (r) {
		case SPOOLSS_DRIVER_VERSION_9X: val = "SPOOLSS_DRIVER_VERSION_9X"; break;
		case SPOOLSS_DRIVER_VERSION_NT35: val = "SPOOLSS_DRIVER_VERSION_NT35"; break;
		case SPOOLSS_DRIVER_VERSION_NT4: val = "SPOOLSS_DRIVER_VERSION_NT4"; break;
		case SPOOLSS_DRIVER_VERSION_200X: val = "SPOOLSS_DRIVER_VERSION_200X"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_spoolss_AddDriverInfo2(struct ndr_push *ndr, int ndr_flags, const struct spoolss_AddDriverInfo2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_spoolss_DriverOSVersion(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->driver_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->architecture));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->driver_path));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->data_file));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->config_file));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->driver_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->driver_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->driver_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->driver_name, ndr_charset_length(r->driver_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->architecture) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->architecture, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->architecture, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->architecture, ndr_charset_length(r->architecture, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->driver_path) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->driver_path, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->driver_path, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->driver_path, ndr_charset_length(r->driver_path, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->data_file) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->data_file, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->data_file, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->data_file, ndr_charset_length(r->data_file, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->config_file) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->config_file, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->config_file, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->config_file, ndr_charset_length(r->config_file, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_AddDriverInfo2(struct ndr_pull *ndr, int ndr_flags, struct spoolss_AddDriverInfo2 *r)
{
	uint32_t _ptr_driver_name;
	TALLOC_CTX *_mem_save_driver_name_0;
	uint32_t _ptr_architecture;
	TALLOC_CTX *_mem_save_architecture_0;
	uint32_t _ptr_driver_path;
	TALLOC_CTX *_mem_save_driver_path_0;
	uint32_t _ptr_data_file;
	TALLOC_CTX *_mem_save_data_file_0;
	uint32_t _ptr_config_file;
	TALLOC_CTX *_mem_save_config_file_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_spoolss_DriverOSVersion(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_driver_name));
		if (_ptr_driver_name) {
			NDR_PULL_ALLOC(ndr, r->driver_name);
		} else {
			r->driver_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_architecture));
		if (_ptr_architecture) {
			NDR_PULL_ALLOC(ndr, r->architecture);
		} else {
			r->architecture = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_driver_path));
		if (_ptr_driver_path) {
			NDR_PULL_ALLOC(ndr, r->driver_path);
		} else {
			r->driver_path = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_data_file));
		if (_ptr_data_file) {
			NDR_PULL_ALLOC(ndr, r->data_file);
		} else {
			r->data_file = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_config_file));
		if (_ptr_config_file) {
			NDR_PULL_ALLOC(ndr, r->config_file);
		} else {
			r->config_file = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->driver_name) {
			_mem_save_driver_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->driver_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->driver_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->driver_name));
			if (ndr_get_array_length(ndr, &r->driver_name) > ndr_get_array_size(ndr, &r->driver_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->driver_name), ndr_get_array_length(ndr, &r->driver_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->driver_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->driver_name, ndr_get_array_length(ndr, &r->driver_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_driver_name_0, 0);
		}
		if (r->architecture) {
			_mem_save_architecture_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->architecture, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->architecture));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->architecture));
			if (ndr_get_array_length(ndr, &r->architecture) > ndr_get_array_size(ndr, &r->architecture)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->architecture), ndr_get_array_length(ndr, &r->architecture));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->architecture), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->architecture, ndr_get_array_length(ndr, &r->architecture), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_architecture_0, 0);
		}
		if (r->driver_path) {
			_mem_save_driver_path_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->driver_path, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->driver_path));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->driver_path));
			if (ndr_get_array_length(ndr, &r->driver_path) > ndr_get_array_size(ndr, &r->driver_path)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->driver_path), ndr_get_array_length(ndr, &r->driver_path));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->driver_path), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->driver_path, ndr_get_array_length(ndr, &r->driver_path), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_driver_path_0, 0);
		}
		if (r->data_file) {
			_mem_save_data_file_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->data_file, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->data_file));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->data_file));
			if (ndr_get_array_length(ndr, &r->data_file) > ndr_get_array_size(ndr, &r->data_file)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->data_file), ndr_get_array_length(ndr, &r->data_file));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->data_file), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->data_file, ndr_get_array_length(ndr, &r->data_file), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_file_0, 0);
		}
		if (r->config_file) {
			_mem_save_config_file_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->config_file, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->config_file));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->config_file));
			if (ndr_get_array_length(ndr, &r->config_file) > ndr_get_array_size(ndr, &r->config_file)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->config_file), ndr_get_array_length(ndr, &r->config_file));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->config_file), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->config_file, ndr_get_array_length(ndr, &r->config_file), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_config_file_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_AddDriverInfo2(struct ndr_print *ndr, const char *name, const struct spoolss_AddDriverInfo2 *r)
{
	ndr_print_struct(ndr, name, "spoolss_AddDriverInfo2");
	ndr->depth++;
	ndr_print_spoolss_DriverOSVersion(ndr, "version", r->version);
	ndr_print_ptr(ndr, "driver_name", r->driver_name);
	ndr->depth++;
	if (r->driver_name) {
		ndr_print_string(ndr, "driver_name", r->driver_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "architecture", r->architecture);
	ndr->depth++;
	if (r->architecture) {
		ndr_print_string(ndr, "architecture", r->architecture);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "driver_path", r->driver_path);
	ndr->depth++;
	if (r->driver_path) {
		ndr_print_string(ndr, "driver_path", r->driver_path);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "data_file", r->data_file);
	ndr->depth++;
	if (r->data_file) {
		ndr_print_string(ndr, "data_file", r->data_file);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "config_file", r->config_file);
	ndr->depth++;
	if (r->config_file) {
		ndr_print_string(ndr, "config_file", r->config_file);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_AddDriverInfo3(struct ndr_push *ndr, int ndr_flags, const struct spoolss_AddDriverInfo3 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_spoolss_DriverOSVersion(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->driver_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->architecture));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->driver_path));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->data_file));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->config_file));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->help_file));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->monitor_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->default_datatype));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ((ndr_size_spoolss_StringArray(r->dependent_files, ndr->iconv_convenience, ndr->flags) - 4) / 2)));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->dependent_files));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->driver_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->driver_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->driver_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->driver_name, ndr_charset_length(r->driver_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->architecture) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->architecture, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->architecture, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->architecture, ndr_charset_length(r->architecture, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->driver_path) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->driver_path, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->driver_path, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->driver_path, ndr_charset_length(r->driver_path, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->data_file) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->data_file, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->data_file, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->data_file, ndr_charset_length(r->data_file, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->config_file) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->config_file, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->config_file, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->config_file, ndr_charset_length(r->config_file, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->help_file) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->help_file, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->help_file, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->help_file, ndr_charset_length(r->help_file, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->monitor_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->monitor_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->monitor_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->monitor_name, ndr_charset_length(r->monitor_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->default_datatype) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->default_datatype, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->default_datatype, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->default_datatype, ndr_charset_length(r->default_datatype, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->dependent_files) {
			NDR_CHECK(ndr_push_spoolss_StringArray(ndr, NDR_SCALARS, r->dependent_files));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_AddDriverInfo3(struct ndr_pull *ndr, int ndr_flags, struct spoolss_AddDriverInfo3 *r)
{
	uint32_t _ptr_driver_name;
	TALLOC_CTX *_mem_save_driver_name_0;
	uint32_t _ptr_architecture;
	TALLOC_CTX *_mem_save_architecture_0;
	uint32_t _ptr_driver_path;
	TALLOC_CTX *_mem_save_driver_path_0;
	uint32_t _ptr_data_file;
	TALLOC_CTX *_mem_save_data_file_0;
	uint32_t _ptr_config_file;
	TALLOC_CTX *_mem_save_config_file_0;
	uint32_t _ptr_help_file;
	TALLOC_CTX *_mem_save_help_file_0;
	uint32_t _ptr_monitor_name;
	TALLOC_CTX *_mem_save_monitor_name_0;
	uint32_t _ptr_default_datatype;
	TALLOC_CTX *_mem_save_default_datatype_0;
	uint32_t _ptr_dependent_files;
	TALLOC_CTX *_mem_save_dependent_files_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_spoolss_DriverOSVersion(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_driver_name));
		if (_ptr_driver_name) {
			NDR_PULL_ALLOC(ndr, r->driver_name);
		} else {
			r->driver_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_architecture));
		if (_ptr_architecture) {
			NDR_PULL_ALLOC(ndr, r->architecture);
		} else {
			r->architecture = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_driver_path));
		if (_ptr_driver_path) {
			NDR_PULL_ALLOC(ndr, r->driver_path);
		} else {
			r->driver_path = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_data_file));
		if (_ptr_data_file) {
			NDR_PULL_ALLOC(ndr, r->data_file);
		} else {
			r->data_file = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_config_file));
		if (_ptr_config_file) {
			NDR_PULL_ALLOC(ndr, r->config_file);
		} else {
			r->config_file = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_help_file));
		if (_ptr_help_file) {
			NDR_PULL_ALLOC(ndr, r->help_file);
		} else {
			r->help_file = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_monitor_name));
		if (_ptr_monitor_name) {
			NDR_PULL_ALLOC(ndr, r->monitor_name);
		} else {
			r->monitor_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_default_datatype));
		if (_ptr_default_datatype) {
			NDR_PULL_ALLOC(ndr, r->default_datatype);
		} else {
			r->default_datatype = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->_ndr_size_dependent_files));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dependent_files));
		if (_ptr_dependent_files) {
			NDR_PULL_ALLOC(ndr, r->dependent_files);
		} else {
			r->dependent_files = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->driver_name) {
			_mem_save_driver_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->driver_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->driver_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->driver_name));
			if (ndr_get_array_length(ndr, &r->driver_name) > ndr_get_array_size(ndr, &r->driver_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->driver_name), ndr_get_array_length(ndr, &r->driver_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->driver_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->driver_name, ndr_get_array_length(ndr, &r->driver_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_driver_name_0, 0);
		}
		if (r->architecture) {
			_mem_save_architecture_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->architecture, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->architecture));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->architecture));
			if (ndr_get_array_length(ndr, &r->architecture) > ndr_get_array_size(ndr, &r->architecture)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->architecture), ndr_get_array_length(ndr, &r->architecture));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->architecture), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->architecture, ndr_get_array_length(ndr, &r->architecture), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_architecture_0, 0);
		}
		if (r->driver_path) {
			_mem_save_driver_path_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->driver_path, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->driver_path));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->driver_path));
			if (ndr_get_array_length(ndr, &r->driver_path) > ndr_get_array_size(ndr, &r->driver_path)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->driver_path), ndr_get_array_length(ndr, &r->driver_path));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->driver_path), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->driver_path, ndr_get_array_length(ndr, &r->driver_path), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_driver_path_0, 0);
		}
		if (r->data_file) {
			_mem_save_data_file_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->data_file, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->data_file));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->data_file));
			if (ndr_get_array_length(ndr, &r->data_file) > ndr_get_array_size(ndr, &r->data_file)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->data_file), ndr_get_array_length(ndr, &r->data_file));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->data_file), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->data_file, ndr_get_array_length(ndr, &r->data_file), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_file_0, 0);
		}
		if (r->config_file) {
			_mem_save_config_file_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->config_file, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->config_file));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->config_file));
			if (ndr_get_array_length(ndr, &r->config_file) > ndr_get_array_size(ndr, &r->config_file)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->config_file), ndr_get_array_length(ndr, &r->config_file));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->config_file), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->config_file, ndr_get_array_length(ndr, &r->config_file), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_config_file_0, 0);
		}
		if (r->help_file) {
			_mem_save_help_file_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->help_file, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->help_file));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->help_file));
			if (ndr_get_array_length(ndr, &r->help_file) > ndr_get_array_size(ndr, &r->help_file)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->help_file), ndr_get_array_length(ndr, &r->help_file));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->help_file), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->help_file, ndr_get_array_length(ndr, &r->help_file), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_help_file_0, 0);
		}
		if (r->monitor_name) {
			_mem_save_monitor_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->monitor_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->monitor_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->monitor_name));
			if (ndr_get_array_length(ndr, &r->monitor_name) > ndr_get_array_size(ndr, &r->monitor_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->monitor_name), ndr_get_array_length(ndr, &r->monitor_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->monitor_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->monitor_name, ndr_get_array_length(ndr, &r->monitor_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_monitor_name_0, 0);
		}
		if (r->default_datatype) {
			_mem_save_default_datatype_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->default_datatype, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->default_datatype));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->default_datatype));
			if (ndr_get_array_length(ndr, &r->default_datatype) > ndr_get_array_size(ndr, &r->default_datatype)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->default_datatype), ndr_get_array_length(ndr, &r->default_datatype));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->default_datatype), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->default_datatype, ndr_get_array_length(ndr, &r->default_datatype), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_default_datatype_0, 0);
		}
		if (r->dependent_files) {
			_mem_save_dependent_files_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->dependent_files, 0);
			NDR_CHECK(ndr_pull_spoolss_StringArray(ndr, NDR_SCALARS, r->dependent_files));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dependent_files_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_AddDriverInfo3(struct ndr_print *ndr, const char *name, const struct spoolss_AddDriverInfo3 *r)
{
	ndr_print_struct(ndr, name, "spoolss_AddDriverInfo3");
	ndr->depth++;
	ndr_print_spoolss_DriverOSVersion(ndr, "version", r->version);
	ndr_print_ptr(ndr, "driver_name", r->driver_name);
	ndr->depth++;
	if (r->driver_name) {
		ndr_print_string(ndr, "driver_name", r->driver_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "architecture", r->architecture);
	ndr->depth++;
	if (r->architecture) {
		ndr_print_string(ndr, "architecture", r->architecture);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "driver_path", r->driver_path);
	ndr->depth++;
	if (r->driver_path) {
		ndr_print_string(ndr, "driver_path", r->driver_path);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "data_file", r->data_file);
	ndr->depth++;
	if (r->data_file) {
		ndr_print_string(ndr, "data_file", r->data_file);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "config_file", r->config_file);
	ndr->depth++;
	if (r->config_file) {
		ndr_print_string(ndr, "config_file", r->config_file);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "help_file", r->help_file);
	ndr->depth++;
	if (r->help_file) {
		ndr_print_string(ndr, "help_file", r->help_file);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "monitor_name", r->monitor_name);
	ndr->depth++;
	if (r->monitor_name) {
		ndr_print_string(ndr, "monitor_name", r->monitor_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "default_datatype", r->default_datatype);
	ndr->depth++;
	if (r->default_datatype) {
		ndr_print_string(ndr, "default_datatype", r->default_datatype);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "_ndr_size_dependent_files", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?((ndr_size_spoolss_StringArray(r->dependent_files, ndr->iconv_convenience, ndr->flags) - 4) / 2):r->_ndr_size_dependent_files);
	ndr_print_ptr(ndr, "dependent_files", r->dependent_files);
	ndr->depth++;
	if (r->dependent_files) {
		ndr_print_spoolss_StringArray(ndr, "dependent_files", r->dependent_files);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_AddDriverInfo4(struct ndr_push *ndr, int ndr_flags, const struct spoolss_AddDriverInfo4 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_spoolss_DriverOSVersion(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->driver_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->architecture));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->driver_path));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->data_file));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->config_file));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->help_file));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->monitor_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->default_datatype));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ((ndr_size_spoolss_StringArray(r->dependent_files, ndr->iconv_convenience, ndr->flags) - 4) / 2)));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->dependent_files));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ((ndr_size_spoolss_StringArray(r->previous_names, ndr->iconv_convenience, ndr->flags) - 4) / 2)));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->previous_names));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->driver_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->driver_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->driver_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->driver_name, ndr_charset_length(r->driver_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->architecture) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->architecture, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->architecture, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->architecture, ndr_charset_length(r->architecture, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->driver_path) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->driver_path, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->driver_path, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->driver_path, ndr_charset_length(r->driver_path, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->data_file) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->data_file, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->data_file, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->data_file, ndr_charset_length(r->data_file, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->config_file) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->config_file, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->config_file, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->config_file, ndr_charset_length(r->config_file, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->help_file) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->help_file, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->help_file, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->help_file, ndr_charset_length(r->help_file, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->monitor_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->monitor_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->monitor_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->monitor_name, ndr_charset_length(r->monitor_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->default_datatype) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->default_datatype, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->default_datatype, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->default_datatype, ndr_charset_length(r->default_datatype, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->dependent_files) {
			NDR_CHECK(ndr_push_spoolss_StringArray(ndr, NDR_SCALARS, r->dependent_files));
		}
		if (r->previous_names) {
			NDR_CHECK(ndr_push_spoolss_StringArray(ndr, NDR_SCALARS, r->previous_names));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_AddDriverInfo4(struct ndr_pull *ndr, int ndr_flags, struct spoolss_AddDriverInfo4 *r)
{
	uint32_t _ptr_driver_name;
	TALLOC_CTX *_mem_save_driver_name_0;
	uint32_t _ptr_architecture;
	TALLOC_CTX *_mem_save_architecture_0;
	uint32_t _ptr_driver_path;
	TALLOC_CTX *_mem_save_driver_path_0;
	uint32_t _ptr_data_file;
	TALLOC_CTX *_mem_save_data_file_0;
	uint32_t _ptr_config_file;
	TALLOC_CTX *_mem_save_config_file_0;
	uint32_t _ptr_help_file;
	TALLOC_CTX *_mem_save_help_file_0;
	uint32_t _ptr_monitor_name;
	TALLOC_CTX *_mem_save_monitor_name_0;
	uint32_t _ptr_default_datatype;
	TALLOC_CTX *_mem_save_default_datatype_0;
	uint32_t _ptr_dependent_files;
	TALLOC_CTX *_mem_save_dependent_files_0;
	uint32_t _ptr_previous_names;
	TALLOC_CTX *_mem_save_previous_names_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_spoolss_DriverOSVersion(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_driver_name));
		if (_ptr_driver_name) {
			NDR_PULL_ALLOC(ndr, r->driver_name);
		} else {
			r->driver_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_architecture));
		if (_ptr_architecture) {
			NDR_PULL_ALLOC(ndr, r->architecture);
		} else {
			r->architecture = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_driver_path));
		if (_ptr_driver_path) {
			NDR_PULL_ALLOC(ndr, r->driver_path);
		} else {
			r->driver_path = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_data_file));
		if (_ptr_data_file) {
			NDR_PULL_ALLOC(ndr, r->data_file);
		} else {
			r->data_file = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_config_file));
		if (_ptr_config_file) {
			NDR_PULL_ALLOC(ndr, r->config_file);
		} else {
			r->config_file = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_help_file));
		if (_ptr_help_file) {
			NDR_PULL_ALLOC(ndr, r->help_file);
		} else {
			r->help_file = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_monitor_name));
		if (_ptr_monitor_name) {
			NDR_PULL_ALLOC(ndr, r->monitor_name);
		} else {
			r->monitor_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_default_datatype));
		if (_ptr_default_datatype) {
			NDR_PULL_ALLOC(ndr, r->default_datatype);
		} else {
			r->default_datatype = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->_ndr_size_dependent_files));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dependent_files));
		if (_ptr_dependent_files) {
			NDR_PULL_ALLOC(ndr, r->dependent_files);
		} else {
			r->dependent_files = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->_ndr_size_previous_names));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_previous_names));
		if (_ptr_previous_names) {
			NDR_PULL_ALLOC(ndr, r->previous_names);
		} else {
			r->previous_names = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->driver_name) {
			_mem_save_driver_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->driver_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->driver_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->driver_name));
			if (ndr_get_array_length(ndr, &r->driver_name) > ndr_get_array_size(ndr, &r->driver_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->driver_name), ndr_get_array_length(ndr, &r->driver_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->driver_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->driver_name, ndr_get_array_length(ndr, &r->driver_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_driver_name_0, 0);
		}
		if (r->architecture) {
			_mem_save_architecture_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->architecture, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->architecture));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->architecture));
			if (ndr_get_array_length(ndr, &r->architecture) > ndr_get_array_size(ndr, &r->architecture)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->architecture), ndr_get_array_length(ndr, &r->architecture));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->architecture), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->architecture, ndr_get_array_length(ndr, &r->architecture), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_architecture_0, 0);
		}
		if (r->driver_path) {
			_mem_save_driver_path_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->driver_path, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->driver_path));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->driver_path));
			if (ndr_get_array_length(ndr, &r->driver_path) > ndr_get_array_size(ndr, &r->driver_path)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->driver_path), ndr_get_array_length(ndr, &r->driver_path));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->driver_path), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->driver_path, ndr_get_array_length(ndr, &r->driver_path), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_driver_path_0, 0);
		}
		if (r->data_file) {
			_mem_save_data_file_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->data_file, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->data_file));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->data_file));
			if (ndr_get_array_length(ndr, &r->data_file) > ndr_get_array_size(ndr, &r->data_file)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->data_file), ndr_get_array_length(ndr, &r->data_file));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->data_file), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->data_file, ndr_get_array_length(ndr, &r->data_file), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_file_0, 0);
		}
		if (r->config_file) {
			_mem_save_config_file_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->config_file, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->config_file));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->config_file));
			if (ndr_get_array_length(ndr, &r->config_file) > ndr_get_array_size(ndr, &r->config_file)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->config_file), ndr_get_array_length(ndr, &r->config_file));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->config_file), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->config_file, ndr_get_array_length(ndr, &r->config_file), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_config_file_0, 0);
		}
		if (r->help_file) {
			_mem_save_help_file_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->help_file, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->help_file));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->help_file));
			if (ndr_get_array_length(ndr, &r->help_file) > ndr_get_array_size(ndr, &r->help_file)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->help_file), ndr_get_array_length(ndr, &r->help_file));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->help_file), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->help_file, ndr_get_array_length(ndr, &r->help_file), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_help_file_0, 0);
		}
		if (r->monitor_name) {
			_mem_save_monitor_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->monitor_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->monitor_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->monitor_name));
			if (ndr_get_array_length(ndr, &r->monitor_name) > ndr_get_array_size(ndr, &r->monitor_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->monitor_name), ndr_get_array_length(ndr, &r->monitor_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->monitor_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->monitor_name, ndr_get_array_length(ndr, &r->monitor_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_monitor_name_0, 0);
		}
		if (r->default_datatype) {
			_mem_save_default_datatype_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->default_datatype, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->default_datatype));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->default_datatype));
			if (ndr_get_array_length(ndr, &r->default_datatype) > ndr_get_array_size(ndr, &r->default_datatype)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->default_datatype), ndr_get_array_length(ndr, &r->default_datatype));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->default_datatype), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->default_datatype, ndr_get_array_length(ndr, &r->default_datatype), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_default_datatype_0, 0);
		}
		if (r->dependent_files) {
			_mem_save_dependent_files_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->dependent_files, 0);
			NDR_CHECK(ndr_pull_spoolss_StringArray(ndr, NDR_SCALARS, r->dependent_files));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dependent_files_0, 0);
		}
		if (r->previous_names) {
			_mem_save_previous_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->previous_names, 0);
			NDR_CHECK(ndr_pull_spoolss_StringArray(ndr, NDR_SCALARS, r->previous_names));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_previous_names_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_AddDriverInfo4(struct ndr_print *ndr, const char *name, const struct spoolss_AddDriverInfo4 *r)
{
	ndr_print_struct(ndr, name, "spoolss_AddDriverInfo4");
	ndr->depth++;
	ndr_print_spoolss_DriverOSVersion(ndr, "version", r->version);
	ndr_print_ptr(ndr, "driver_name", r->driver_name);
	ndr->depth++;
	if (r->driver_name) {
		ndr_print_string(ndr, "driver_name", r->driver_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "architecture", r->architecture);
	ndr->depth++;
	if (r->architecture) {
		ndr_print_string(ndr, "architecture", r->architecture);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "driver_path", r->driver_path);
	ndr->depth++;
	if (r->driver_path) {
		ndr_print_string(ndr, "driver_path", r->driver_path);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "data_file", r->data_file);
	ndr->depth++;
	if (r->data_file) {
		ndr_print_string(ndr, "data_file", r->data_file);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "config_file", r->config_file);
	ndr->depth++;
	if (r->config_file) {
		ndr_print_string(ndr, "config_file", r->config_file);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "help_file", r->help_file);
	ndr->depth++;
	if (r->help_file) {
		ndr_print_string(ndr, "help_file", r->help_file);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "monitor_name", r->monitor_name);
	ndr->depth++;
	if (r->monitor_name) {
		ndr_print_string(ndr, "monitor_name", r->monitor_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "default_datatype", r->default_datatype);
	ndr->depth++;
	if (r->default_datatype) {
		ndr_print_string(ndr, "default_datatype", r->default_datatype);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "_ndr_size_dependent_files", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?((ndr_size_spoolss_StringArray(r->dependent_files, ndr->iconv_convenience, ndr->flags) - 4) / 2):r->_ndr_size_dependent_files);
	ndr_print_ptr(ndr, "dependent_files", r->dependent_files);
	ndr->depth++;
	if (r->dependent_files) {
		ndr_print_spoolss_StringArray(ndr, "dependent_files", r->dependent_files);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "_ndr_size_previous_names", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?((ndr_size_spoolss_StringArray(r->previous_names, ndr->iconv_convenience, ndr->flags) - 4) / 2):r->_ndr_size_previous_names);
	ndr_print_ptr(ndr, "previous_names", r->previous_names);
	ndr->depth++;
	if (r->previous_names) {
		ndr_print_spoolss_StringArray(ndr, "previous_names", r->previous_names);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_DriverAttributes(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_DriverAttributes(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_DriverAttributes(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_DRIVER_PACKAGE_AWARE", PRINTER_DRIVER_PACKAGE_AWARE, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_AddDriverInfo6(struct ndr_push *ndr, int ndr_flags, const struct spoolss_AddDriverInfo6 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_spoolss_DriverOSVersion(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->driver_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->architecture));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->driver_path));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->data_file));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->config_file));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->help_file));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->monitor_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->default_datatype));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ((ndr_size_spoolss_StringArray(r->dependent_files, ndr->iconv_convenience, ndr->flags) - 4) / 2)));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->dependent_files));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ((ndr_size_spoolss_StringArray(r->previous_names, ndr->iconv_convenience, ndr->flags) - 4) / 2)));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->previous_names));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->driver_date));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->driver_version));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->manufacturer_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->manufacturer_url));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->hardware_id));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->provider));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->driver_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->driver_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->driver_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->driver_name, ndr_charset_length(r->driver_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->architecture) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->architecture, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->architecture, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->architecture, ndr_charset_length(r->architecture, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->driver_path) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->driver_path, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->driver_path, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->driver_path, ndr_charset_length(r->driver_path, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->data_file) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->data_file, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->data_file, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->data_file, ndr_charset_length(r->data_file, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->config_file) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->config_file, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->config_file, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->config_file, ndr_charset_length(r->config_file, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->help_file) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->help_file, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->help_file, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->help_file, ndr_charset_length(r->help_file, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->monitor_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->monitor_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->monitor_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->monitor_name, ndr_charset_length(r->monitor_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->default_datatype) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->default_datatype, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->default_datatype, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->default_datatype, ndr_charset_length(r->default_datatype, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->dependent_files) {
			NDR_CHECK(ndr_push_spoolss_StringArray(ndr, NDR_SCALARS, r->dependent_files));
		}
		if (r->previous_names) {
			NDR_CHECK(ndr_push_spoolss_StringArray(ndr, NDR_SCALARS, r->previous_names));
		}
		if (r->manufacturer_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->manufacturer_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->manufacturer_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->manufacturer_name, ndr_charset_length(r->manufacturer_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->manufacturer_url) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->manufacturer_url, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->manufacturer_url, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->manufacturer_url, ndr_charset_length(r->manufacturer_url, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->hardware_id) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->hardware_id, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->hardware_id, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->hardware_id, ndr_charset_length(r->hardware_id, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->provider) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->provider, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->provider, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->provider, ndr_charset_length(r->provider, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_AddDriverInfo6(struct ndr_pull *ndr, int ndr_flags, struct spoolss_AddDriverInfo6 *r)
{
	uint32_t _ptr_driver_name;
	TALLOC_CTX *_mem_save_driver_name_0;
	uint32_t _ptr_architecture;
	TALLOC_CTX *_mem_save_architecture_0;
	uint32_t _ptr_driver_path;
	TALLOC_CTX *_mem_save_driver_path_0;
	uint32_t _ptr_data_file;
	TALLOC_CTX *_mem_save_data_file_0;
	uint32_t _ptr_config_file;
	TALLOC_CTX *_mem_save_config_file_0;
	uint32_t _ptr_help_file;
	TALLOC_CTX *_mem_save_help_file_0;
	uint32_t _ptr_monitor_name;
	TALLOC_CTX *_mem_save_monitor_name_0;
	uint32_t _ptr_default_datatype;
	TALLOC_CTX *_mem_save_default_datatype_0;
	uint32_t _ptr_dependent_files;
	TALLOC_CTX *_mem_save_dependent_files_0;
	uint32_t _ptr_previous_names;
	TALLOC_CTX *_mem_save_previous_names_0;
	uint32_t _ptr_manufacturer_name;
	TALLOC_CTX *_mem_save_manufacturer_name_0;
	uint32_t _ptr_manufacturer_url;
	TALLOC_CTX *_mem_save_manufacturer_url_0;
	uint32_t _ptr_hardware_id;
	TALLOC_CTX *_mem_save_hardware_id_0;
	uint32_t _ptr_provider;
	TALLOC_CTX *_mem_save_provider_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_spoolss_DriverOSVersion(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_driver_name));
		if (_ptr_driver_name) {
			NDR_PULL_ALLOC(ndr, r->driver_name);
		} else {
			r->driver_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_architecture));
		if (_ptr_architecture) {
			NDR_PULL_ALLOC(ndr, r->architecture);
		} else {
			r->architecture = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_driver_path));
		if (_ptr_driver_path) {
			NDR_PULL_ALLOC(ndr, r->driver_path);
		} else {
			r->driver_path = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_data_file));
		if (_ptr_data_file) {
			NDR_PULL_ALLOC(ndr, r->data_file);
		} else {
			r->data_file = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_config_file));
		if (_ptr_config_file) {
			NDR_PULL_ALLOC(ndr, r->config_file);
		} else {
			r->config_file = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_help_file));
		if (_ptr_help_file) {
			NDR_PULL_ALLOC(ndr, r->help_file);
		} else {
			r->help_file = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_monitor_name));
		if (_ptr_monitor_name) {
			NDR_PULL_ALLOC(ndr, r->monitor_name);
		} else {
			r->monitor_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_default_datatype));
		if (_ptr_default_datatype) {
			NDR_PULL_ALLOC(ndr, r->default_datatype);
		} else {
			r->default_datatype = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->_ndr_size_dependent_files));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dependent_files));
		if (_ptr_dependent_files) {
			NDR_PULL_ALLOC(ndr, r->dependent_files);
		} else {
			r->dependent_files = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->_ndr_size_previous_names));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_previous_names));
		if (_ptr_previous_names) {
			NDR_PULL_ALLOC(ndr, r->previous_names);
		} else {
			r->previous_names = NULL;
		}
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->driver_date));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->driver_version));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_manufacturer_name));
		if (_ptr_manufacturer_name) {
			NDR_PULL_ALLOC(ndr, r->manufacturer_name);
		} else {
			r->manufacturer_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_manufacturer_url));
		if (_ptr_manufacturer_url) {
			NDR_PULL_ALLOC(ndr, r->manufacturer_url);
		} else {
			r->manufacturer_url = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_hardware_id));
		if (_ptr_hardware_id) {
			NDR_PULL_ALLOC(ndr, r->hardware_id);
		} else {
			r->hardware_id = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_provider));
		if (_ptr_provider) {
			NDR_PULL_ALLOC(ndr, r->provider);
		} else {
			r->provider = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->driver_name) {
			_mem_save_driver_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->driver_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->driver_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->driver_name));
			if (ndr_get_array_length(ndr, &r->driver_name) > ndr_get_array_size(ndr, &r->driver_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->driver_name), ndr_get_array_length(ndr, &r->driver_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->driver_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->driver_name, ndr_get_array_length(ndr, &r->driver_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_driver_name_0, 0);
		}
		if (r->architecture) {
			_mem_save_architecture_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->architecture, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->architecture));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->architecture));
			if (ndr_get_array_length(ndr, &r->architecture) > ndr_get_array_size(ndr, &r->architecture)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->architecture), ndr_get_array_length(ndr, &r->architecture));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->architecture), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->architecture, ndr_get_array_length(ndr, &r->architecture), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_architecture_0, 0);
		}
		if (r->driver_path) {
			_mem_save_driver_path_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->driver_path, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->driver_path));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->driver_path));
			if (ndr_get_array_length(ndr, &r->driver_path) > ndr_get_array_size(ndr, &r->driver_path)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->driver_path), ndr_get_array_length(ndr, &r->driver_path));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->driver_path), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->driver_path, ndr_get_array_length(ndr, &r->driver_path), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_driver_path_0, 0);
		}
		if (r->data_file) {
			_mem_save_data_file_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->data_file, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->data_file));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->data_file));
			if (ndr_get_array_length(ndr, &r->data_file) > ndr_get_array_size(ndr, &r->data_file)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->data_file), ndr_get_array_length(ndr, &r->data_file));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->data_file), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->data_file, ndr_get_array_length(ndr, &r->data_file), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_file_0, 0);
		}
		if (r->config_file) {
			_mem_save_config_file_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->config_file, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->config_file));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->config_file));
			if (ndr_get_array_length(ndr, &r->config_file) > ndr_get_array_size(ndr, &r->config_file)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->config_file), ndr_get_array_length(ndr, &r->config_file));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->config_file), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->config_file, ndr_get_array_length(ndr, &r->config_file), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_config_file_0, 0);
		}
		if (r->help_file) {
			_mem_save_help_file_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->help_file, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->help_file));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->help_file));
			if (ndr_get_array_length(ndr, &r->help_file) > ndr_get_array_size(ndr, &r->help_file)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->help_file), ndr_get_array_length(ndr, &r->help_file));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->help_file), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->help_file, ndr_get_array_length(ndr, &r->help_file), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_help_file_0, 0);
		}
		if (r->monitor_name) {
			_mem_save_monitor_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->monitor_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->monitor_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->monitor_name));
			if (ndr_get_array_length(ndr, &r->monitor_name) > ndr_get_array_size(ndr, &r->monitor_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->monitor_name), ndr_get_array_length(ndr, &r->monitor_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->monitor_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->monitor_name, ndr_get_array_length(ndr, &r->monitor_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_monitor_name_0, 0);
		}
		if (r->default_datatype) {
			_mem_save_default_datatype_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->default_datatype, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->default_datatype));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->default_datatype));
			if (ndr_get_array_length(ndr, &r->default_datatype) > ndr_get_array_size(ndr, &r->default_datatype)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->default_datatype), ndr_get_array_length(ndr, &r->default_datatype));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->default_datatype), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->default_datatype, ndr_get_array_length(ndr, &r->default_datatype), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_default_datatype_0, 0);
		}
		if (r->dependent_files) {
			_mem_save_dependent_files_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->dependent_files, 0);
			NDR_CHECK(ndr_pull_spoolss_StringArray(ndr, NDR_SCALARS, r->dependent_files));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dependent_files_0, 0);
		}
		if (r->previous_names) {
			_mem_save_previous_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->previous_names, 0);
			NDR_CHECK(ndr_pull_spoolss_StringArray(ndr, NDR_SCALARS, r->previous_names));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_previous_names_0, 0);
		}
		if (r->manufacturer_name) {
			_mem_save_manufacturer_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->manufacturer_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->manufacturer_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->manufacturer_name));
			if (ndr_get_array_length(ndr, &r->manufacturer_name) > ndr_get_array_size(ndr, &r->manufacturer_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->manufacturer_name), ndr_get_array_length(ndr, &r->manufacturer_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->manufacturer_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->manufacturer_name, ndr_get_array_length(ndr, &r->manufacturer_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_manufacturer_name_0, 0);
		}
		if (r->manufacturer_url) {
			_mem_save_manufacturer_url_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->manufacturer_url, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->manufacturer_url));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->manufacturer_url));
			if (ndr_get_array_length(ndr, &r->manufacturer_url) > ndr_get_array_size(ndr, &r->manufacturer_url)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->manufacturer_url), ndr_get_array_length(ndr, &r->manufacturer_url));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->manufacturer_url), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->manufacturer_url, ndr_get_array_length(ndr, &r->manufacturer_url), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_manufacturer_url_0, 0);
		}
		if (r->hardware_id) {
			_mem_save_hardware_id_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->hardware_id, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->hardware_id));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->hardware_id));
			if (ndr_get_array_length(ndr, &r->hardware_id) > ndr_get_array_size(ndr, &r->hardware_id)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->hardware_id), ndr_get_array_length(ndr, &r->hardware_id));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->hardware_id), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->hardware_id, ndr_get_array_length(ndr, &r->hardware_id), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_hardware_id_0, 0);
		}
		if (r->provider) {
			_mem_save_provider_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->provider, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->provider));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->provider));
			if (ndr_get_array_length(ndr, &r->provider) > ndr_get_array_size(ndr, &r->provider)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->provider), ndr_get_array_length(ndr, &r->provider));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->provider), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->provider, ndr_get_array_length(ndr, &r->provider), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_provider_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_AddDriverInfo6(struct ndr_print *ndr, const char *name, const struct spoolss_AddDriverInfo6 *r)
{
	ndr_print_struct(ndr, name, "spoolss_AddDriverInfo6");
	ndr->depth++;
	ndr_print_spoolss_DriverOSVersion(ndr, "version", r->version);
	ndr_print_ptr(ndr, "driver_name", r->driver_name);
	ndr->depth++;
	if (r->driver_name) {
		ndr_print_string(ndr, "driver_name", r->driver_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "architecture", r->architecture);
	ndr->depth++;
	if (r->architecture) {
		ndr_print_string(ndr, "architecture", r->architecture);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "driver_path", r->driver_path);
	ndr->depth++;
	if (r->driver_path) {
		ndr_print_string(ndr, "driver_path", r->driver_path);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "data_file", r->data_file);
	ndr->depth++;
	if (r->data_file) {
		ndr_print_string(ndr, "data_file", r->data_file);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "config_file", r->config_file);
	ndr->depth++;
	if (r->config_file) {
		ndr_print_string(ndr, "config_file", r->config_file);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "help_file", r->help_file);
	ndr->depth++;
	if (r->help_file) {
		ndr_print_string(ndr, "help_file", r->help_file);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "monitor_name", r->monitor_name);
	ndr->depth++;
	if (r->monitor_name) {
		ndr_print_string(ndr, "monitor_name", r->monitor_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "default_datatype", r->default_datatype);
	ndr->depth++;
	if (r->default_datatype) {
		ndr_print_string(ndr, "default_datatype", r->default_datatype);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "_ndr_size_dependent_files", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?((ndr_size_spoolss_StringArray(r->dependent_files, ndr->iconv_convenience, ndr->flags) - 4) / 2):r->_ndr_size_dependent_files);
	ndr_print_ptr(ndr, "dependent_files", r->dependent_files);
	ndr->depth++;
	if (r->dependent_files) {
		ndr_print_spoolss_StringArray(ndr, "dependent_files", r->dependent_files);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "_ndr_size_previous_names", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?((ndr_size_spoolss_StringArray(r->previous_names, ndr->iconv_convenience, ndr->flags) - 4) / 2):r->_ndr_size_previous_names);
	ndr_print_ptr(ndr, "previous_names", r->previous_names);
	ndr->depth++;
	if (r->previous_names) {
		ndr_print_spoolss_StringArray(ndr, "previous_names", r->previous_names);
	}
	ndr->depth--;
	ndr_print_NTTIME(ndr, "driver_date", r->driver_date);
	ndr_print_hyper(ndr, "driver_version", r->driver_version);
	ndr_print_ptr(ndr, "manufacturer_name", r->manufacturer_name);
	ndr->depth++;
	if (r->manufacturer_name) {
		ndr_print_string(ndr, "manufacturer_name", r->manufacturer_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "manufacturer_url", r->manufacturer_url);
	ndr->depth++;
	if (r->manufacturer_url) {
		ndr_print_string(ndr, "manufacturer_url", r->manufacturer_url);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "hardware_id", r->hardware_id);
	ndr->depth++;
	if (r->hardware_id) {
		ndr_print_string(ndr, "hardware_id", r->hardware_id);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "provider", r->provider);
	ndr->depth++;
	if (r->provider) {
		ndr_print_string(ndr, "provider", r->provider);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_AddDriverInfo8(struct ndr_push *ndr, int ndr_flags, const struct spoolss_AddDriverInfo8 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_spoolss_DriverOSVersion(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->driver_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->architecture));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->driver_path));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->data_file));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->config_file));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->help_file));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->monitor_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->default_datatype));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ((ndr_size_spoolss_StringArray(r->dependent_files, ndr->iconv_convenience, ndr->flags) - 4) / 2)));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->dependent_files));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ((ndr_size_spoolss_StringArray(r->previous_names, ndr->iconv_convenience, ndr->flags) - 4) / 2)));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->previous_names));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->driver_date));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->driver_version));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->manufacturer_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->manufacturer_url));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->hardware_id));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->provider));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->print_processor));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->vendor_setup));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ((ndr_size_spoolss_StringArray(r->color_profiles, ndr->iconv_convenience, ndr->flags) - 4) / 2)));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->color_profiles));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->inf_path));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->printer_driver_attributes));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ((ndr_size_spoolss_StringArray(r->core_driver_dependencies, ndr->iconv_convenience, ndr->flags) - 4) / 2)));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->core_driver_dependencies));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->min_inbox_driver_ver_date));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->min_inbox_driver_ver_version));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->driver_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->driver_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->driver_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->driver_name, ndr_charset_length(r->driver_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->architecture) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->architecture, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->architecture, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->architecture, ndr_charset_length(r->architecture, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->driver_path) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->driver_path, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->driver_path, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->driver_path, ndr_charset_length(r->driver_path, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->data_file) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->data_file, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->data_file, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->data_file, ndr_charset_length(r->data_file, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->config_file) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->config_file, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->config_file, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->config_file, ndr_charset_length(r->config_file, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->help_file) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->help_file, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->help_file, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->help_file, ndr_charset_length(r->help_file, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->monitor_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->monitor_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->monitor_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->monitor_name, ndr_charset_length(r->monitor_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->default_datatype) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->default_datatype, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->default_datatype, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->default_datatype, ndr_charset_length(r->default_datatype, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->dependent_files) {
			NDR_CHECK(ndr_push_spoolss_StringArray(ndr, NDR_SCALARS, r->dependent_files));
		}
		if (r->previous_names) {
			NDR_CHECK(ndr_push_spoolss_StringArray(ndr, NDR_SCALARS, r->previous_names));
		}
		if (r->manufacturer_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->manufacturer_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->manufacturer_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->manufacturer_name, ndr_charset_length(r->manufacturer_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->manufacturer_url) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->manufacturer_url, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->manufacturer_url, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->manufacturer_url, ndr_charset_length(r->manufacturer_url, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->hardware_id) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->hardware_id, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->hardware_id, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->hardware_id, ndr_charset_length(r->hardware_id, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->provider) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->provider, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->provider, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->provider, ndr_charset_length(r->provider, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->print_processor) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->print_processor, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->print_processor, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->print_processor, ndr_charset_length(r->print_processor, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->vendor_setup) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->vendor_setup, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->vendor_setup, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->vendor_setup, ndr_charset_length(r->vendor_setup, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->color_profiles) {
			NDR_CHECK(ndr_push_spoolss_StringArray(ndr, NDR_SCALARS, r->color_profiles));
		}
		if (r->inf_path) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->inf_path, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->inf_path, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->inf_path, ndr_charset_length(r->inf_path, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->core_driver_dependencies) {
			NDR_CHECK(ndr_push_spoolss_StringArray(ndr, NDR_SCALARS, r->core_driver_dependencies));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_AddDriverInfo8(struct ndr_pull *ndr, int ndr_flags, struct spoolss_AddDriverInfo8 *r)
{
	uint32_t _ptr_driver_name;
	TALLOC_CTX *_mem_save_driver_name_0;
	uint32_t _ptr_architecture;
	TALLOC_CTX *_mem_save_architecture_0;
	uint32_t _ptr_driver_path;
	TALLOC_CTX *_mem_save_driver_path_0;
	uint32_t _ptr_data_file;
	TALLOC_CTX *_mem_save_data_file_0;
	uint32_t _ptr_config_file;
	TALLOC_CTX *_mem_save_config_file_0;
	uint32_t _ptr_help_file;
	TALLOC_CTX *_mem_save_help_file_0;
	uint32_t _ptr_monitor_name;
	TALLOC_CTX *_mem_save_monitor_name_0;
	uint32_t _ptr_default_datatype;
	TALLOC_CTX *_mem_save_default_datatype_0;
	uint32_t _ptr_dependent_files;
	TALLOC_CTX *_mem_save_dependent_files_0;
	uint32_t _ptr_previous_names;
	TALLOC_CTX *_mem_save_previous_names_0;
	uint32_t _ptr_manufacturer_name;
	TALLOC_CTX *_mem_save_manufacturer_name_0;
	uint32_t _ptr_manufacturer_url;
	TALLOC_CTX *_mem_save_manufacturer_url_0;
	uint32_t _ptr_hardware_id;
	TALLOC_CTX *_mem_save_hardware_id_0;
	uint32_t _ptr_provider;
	TALLOC_CTX *_mem_save_provider_0;
	uint32_t _ptr_print_processor;
	TALLOC_CTX *_mem_save_print_processor_0;
	uint32_t _ptr_vendor_setup;
	TALLOC_CTX *_mem_save_vendor_setup_0;
	uint32_t _ptr_color_profiles;
	TALLOC_CTX *_mem_save_color_profiles_0;
	uint32_t _ptr_inf_path;
	TALLOC_CTX *_mem_save_inf_path_0;
	uint32_t _ptr_core_driver_dependencies;
	TALLOC_CTX *_mem_save_core_driver_dependencies_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_spoolss_DriverOSVersion(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_driver_name));
		if (_ptr_driver_name) {
			NDR_PULL_ALLOC(ndr, r->driver_name);
		} else {
			r->driver_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_architecture));
		if (_ptr_architecture) {
			NDR_PULL_ALLOC(ndr, r->architecture);
		} else {
			r->architecture = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_driver_path));
		if (_ptr_driver_path) {
			NDR_PULL_ALLOC(ndr, r->driver_path);
		} else {
			r->driver_path = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_data_file));
		if (_ptr_data_file) {
			NDR_PULL_ALLOC(ndr, r->data_file);
		} else {
			r->data_file = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_config_file));
		if (_ptr_config_file) {
			NDR_PULL_ALLOC(ndr, r->config_file);
		} else {
			r->config_file = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_help_file));
		if (_ptr_help_file) {
			NDR_PULL_ALLOC(ndr, r->help_file);
		} else {
			r->help_file = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_monitor_name));
		if (_ptr_monitor_name) {
			NDR_PULL_ALLOC(ndr, r->monitor_name);
		} else {
			r->monitor_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_default_datatype));
		if (_ptr_default_datatype) {
			NDR_PULL_ALLOC(ndr, r->default_datatype);
		} else {
			r->default_datatype = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->_ndr_size_dependent_files));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dependent_files));
		if (_ptr_dependent_files) {
			NDR_PULL_ALLOC(ndr, r->dependent_files);
		} else {
			r->dependent_files = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->_ndr_size_previous_names));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_previous_names));
		if (_ptr_previous_names) {
			NDR_PULL_ALLOC(ndr, r->previous_names);
		} else {
			r->previous_names = NULL;
		}
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->driver_date));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->driver_version));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_manufacturer_name));
		if (_ptr_manufacturer_name) {
			NDR_PULL_ALLOC(ndr, r->manufacturer_name);
		} else {
			r->manufacturer_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_manufacturer_url));
		if (_ptr_manufacturer_url) {
			NDR_PULL_ALLOC(ndr, r->manufacturer_url);
		} else {
			r->manufacturer_url = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_hardware_id));
		if (_ptr_hardware_id) {
			NDR_PULL_ALLOC(ndr, r->hardware_id);
		} else {
			r->hardware_id = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_provider));
		if (_ptr_provider) {
			NDR_PULL_ALLOC(ndr, r->provider);
		} else {
			r->provider = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_print_processor));
		if (_ptr_print_processor) {
			NDR_PULL_ALLOC(ndr, r->print_processor);
		} else {
			r->print_processor = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_vendor_setup));
		if (_ptr_vendor_setup) {
			NDR_PULL_ALLOC(ndr, r->vendor_setup);
		} else {
			r->vendor_setup = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->_ndr_size_color_profiles));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_color_profiles));
		if (_ptr_color_profiles) {
			NDR_PULL_ALLOC(ndr, r->color_profiles);
		} else {
			r->color_profiles = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_inf_path));
		if (_ptr_inf_path) {
			NDR_PULL_ALLOC(ndr, r->inf_path);
		} else {
			r->inf_path = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->printer_driver_attributes));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->_ndr_size_core_driver_dependencies));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_core_driver_dependencies));
		if (_ptr_core_driver_dependencies) {
			NDR_PULL_ALLOC(ndr, r->core_driver_dependencies);
		} else {
			r->core_driver_dependencies = NULL;
		}
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->min_inbox_driver_ver_date));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->min_inbox_driver_ver_version));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->driver_name) {
			_mem_save_driver_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->driver_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->driver_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->driver_name));
			if (ndr_get_array_length(ndr, &r->driver_name) > ndr_get_array_size(ndr, &r->driver_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->driver_name), ndr_get_array_length(ndr, &r->driver_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->driver_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->driver_name, ndr_get_array_length(ndr, &r->driver_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_driver_name_0, 0);
		}
		if (r->architecture) {
			_mem_save_architecture_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->architecture, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->architecture));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->architecture));
			if (ndr_get_array_length(ndr, &r->architecture) > ndr_get_array_size(ndr, &r->architecture)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->architecture), ndr_get_array_length(ndr, &r->architecture));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->architecture), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->architecture, ndr_get_array_length(ndr, &r->architecture), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_architecture_0, 0);
		}
		if (r->driver_path) {
			_mem_save_driver_path_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->driver_path, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->driver_path));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->driver_path));
			if (ndr_get_array_length(ndr, &r->driver_path) > ndr_get_array_size(ndr, &r->driver_path)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->driver_path), ndr_get_array_length(ndr, &r->driver_path));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->driver_path), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->driver_path, ndr_get_array_length(ndr, &r->driver_path), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_driver_path_0, 0);
		}
		if (r->data_file) {
			_mem_save_data_file_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->data_file, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->data_file));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->data_file));
			if (ndr_get_array_length(ndr, &r->data_file) > ndr_get_array_size(ndr, &r->data_file)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->data_file), ndr_get_array_length(ndr, &r->data_file));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->data_file), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->data_file, ndr_get_array_length(ndr, &r->data_file), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_file_0, 0);
		}
		if (r->config_file) {
			_mem_save_config_file_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->config_file, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->config_file));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->config_file));
			if (ndr_get_array_length(ndr, &r->config_file) > ndr_get_array_size(ndr, &r->config_file)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->config_file), ndr_get_array_length(ndr, &r->config_file));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->config_file), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->config_file, ndr_get_array_length(ndr, &r->config_file), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_config_file_0, 0);
		}
		if (r->help_file) {
			_mem_save_help_file_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->help_file, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->help_file));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->help_file));
			if (ndr_get_array_length(ndr, &r->help_file) > ndr_get_array_size(ndr, &r->help_file)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->help_file), ndr_get_array_length(ndr, &r->help_file));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->help_file), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->help_file, ndr_get_array_length(ndr, &r->help_file), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_help_file_0, 0);
		}
		if (r->monitor_name) {
			_mem_save_monitor_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->monitor_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->monitor_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->monitor_name));
			if (ndr_get_array_length(ndr, &r->monitor_name) > ndr_get_array_size(ndr, &r->monitor_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->monitor_name), ndr_get_array_length(ndr, &r->monitor_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->monitor_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->monitor_name, ndr_get_array_length(ndr, &r->monitor_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_monitor_name_0, 0);
		}
		if (r->default_datatype) {
			_mem_save_default_datatype_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->default_datatype, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->default_datatype));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->default_datatype));
			if (ndr_get_array_length(ndr, &r->default_datatype) > ndr_get_array_size(ndr, &r->default_datatype)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->default_datatype), ndr_get_array_length(ndr, &r->default_datatype));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->default_datatype), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->default_datatype, ndr_get_array_length(ndr, &r->default_datatype), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_default_datatype_0, 0);
		}
		if (r->dependent_files) {
			_mem_save_dependent_files_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->dependent_files, 0);
			NDR_CHECK(ndr_pull_spoolss_StringArray(ndr, NDR_SCALARS, r->dependent_files));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dependent_files_0, 0);
		}
		if (r->previous_names) {
			_mem_save_previous_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->previous_names, 0);
			NDR_CHECK(ndr_pull_spoolss_StringArray(ndr, NDR_SCALARS, r->previous_names));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_previous_names_0, 0);
		}
		if (r->manufacturer_name) {
			_mem_save_manufacturer_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->manufacturer_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->manufacturer_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->manufacturer_name));
			if (ndr_get_array_length(ndr, &r->manufacturer_name) > ndr_get_array_size(ndr, &r->manufacturer_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->manufacturer_name), ndr_get_array_length(ndr, &r->manufacturer_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->manufacturer_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->manufacturer_name, ndr_get_array_length(ndr, &r->manufacturer_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_manufacturer_name_0, 0);
		}
		if (r->manufacturer_url) {
			_mem_save_manufacturer_url_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->manufacturer_url, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->manufacturer_url));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->manufacturer_url));
			if (ndr_get_array_length(ndr, &r->manufacturer_url) > ndr_get_array_size(ndr, &r->manufacturer_url)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->manufacturer_url), ndr_get_array_length(ndr, &r->manufacturer_url));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->manufacturer_url), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->manufacturer_url, ndr_get_array_length(ndr, &r->manufacturer_url), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_manufacturer_url_0, 0);
		}
		if (r->hardware_id) {
			_mem_save_hardware_id_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->hardware_id, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->hardware_id));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->hardware_id));
			if (ndr_get_array_length(ndr, &r->hardware_id) > ndr_get_array_size(ndr, &r->hardware_id)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->hardware_id), ndr_get_array_length(ndr, &r->hardware_id));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->hardware_id), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->hardware_id, ndr_get_array_length(ndr, &r->hardware_id), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_hardware_id_0, 0);
		}
		if (r->provider) {
			_mem_save_provider_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->provider, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->provider));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->provider));
			if (ndr_get_array_length(ndr, &r->provider) > ndr_get_array_size(ndr, &r->provider)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->provider), ndr_get_array_length(ndr, &r->provider));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->provider), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->provider, ndr_get_array_length(ndr, &r->provider), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_provider_0, 0);
		}
		if (r->print_processor) {
			_mem_save_print_processor_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->print_processor, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->print_processor));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->print_processor));
			if (ndr_get_array_length(ndr, &r->print_processor) > ndr_get_array_size(ndr, &r->print_processor)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->print_processor), ndr_get_array_length(ndr, &r->print_processor));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->print_processor), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->print_processor, ndr_get_array_length(ndr, &r->print_processor), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_print_processor_0, 0);
		}
		if (r->vendor_setup) {
			_mem_save_vendor_setup_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->vendor_setup, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->vendor_setup));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->vendor_setup));
			if (ndr_get_array_length(ndr, &r->vendor_setup) > ndr_get_array_size(ndr, &r->vendor_setup)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->vendor_setup), ndr_get_array_length(ndr, &r->vendor_setup));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->vendor_setup), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->vendor_setup, ndr_get_array_length(ndr, &r->vendor_setup), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_vendor_setup_0, 0);
		}
		if (r->color_profiles) {
			_mem_save_color_profiles_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->color_profiles, 0);
			NDR_CHECK(ndr_pull_spoolss_StringArray(ndr, NDR_SCALARS, r->color_profiles));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_color_profiles_0, 0);
		}
		if (r->inf_path) {
			_mem_save_inf_path_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->inf_path, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->inf_path));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->inf_path));
			if (ndr_get_array_length(ndr, &r->inf_path) > ndr_get_array_size(ndr, &r->inf_path)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->inf_path), ndr_get_array_length(ndr, &r->inf_path));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->inf_path), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->inf_path, ndr_get_array_length(ndr, &r->inf_path), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_inf_path_0, 0);
		}
		if (r->core_driver_dependencies) {
			_mem_save_core_driver_dependencies_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->core_driver_dependencies, 0);
			NDR_CHECK(ndr_pull_spoolss_StringArray(ndr, NDR_SCALARS, r->core_driver_dependencies));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_core_driver_dependencies_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_AddDriverInfo8(struct ndr_print *ndr, const char *name, const struct spoolss_AddDriverInfo8 *r)
{
	ndr_print_struct(ndr, name, "spoolss_AddDriverInfo8");
	ndr->depth++;
	ndr_print_spoolss_DriverOSVersion(ndr, "version", r->version);
	ndr_print_ptr(ndr, "driver_name", r->driver_name);
	ndr->depth++;
	if (r->driver_name) {
		ndr_print_string(ndr, "driver_name", r->driver_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "architecture", r->architecture);
	ndr->depth++;
	if (r->architecture) {
		ndr_print_string(ndr, "architecture", r->architecture);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "driver_path", r->driver_path);
	ndr->depth++;
	if (r->driver_path) {
		ndr_print_string(ndr, "driver_path", r->driver_path);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "data_file", r->data_file);
	ndr->depth++;
	if (r->data_file) {
		ndr_print_string(ndr, "data_file", r->data_file);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "config_file", r->config_file);
	ndr->depth++;
	if (r->config_file) {
		ndr_print_string(ndr, "config_file", r->config_file);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "help_file", r->help_file);
	ndr->depth++;
	if (r->help_file) {
		ndr_print_string(ndr, "help_file", r->help_file);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "monitor_name", r->monitor_name);
	ndr->depth++;
	if (r->monitor_name) {
		ndr_print_string(ndr, "monitor_name", r->monitor_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "default_datatype", r->default_datatype);
	ndr->depth++;
	if (r->default_datatype) {
		ndr_print_string(ndr, "default_datatype", r->default_datatype);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "_ndr_size_dependent_files", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?((ndr_size_spoolss_StringArray(r->dependent_files, ndr->iconv_convenience, ndr->flags) - 4) / 2):r->_ndr_size_dependent_files);
	ndr_print_ptr(ndr, "dependent_files", r->dependent_files);
	ndr->depth++;
	if (r->dependent_files) {
		ndr_print_spoolss_StringArray(ndr, "dependent_files", r->dependent_files);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "_ndr_size_previous_names", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?((ndr_size_spoolss_StringArray(r->previous_names, ndr->iconv_convenience, ndr->flags) - 4) / 2):r->_ndr_size_previous_names);
	ndr_print_ptr(ndr, "previous_names", r->previous_names);
	ndr->depth++;
	if (r->previous_names) {
		ndr_print_spoolss_StringArray(ndr, "previous_names", r->previous_names);
	}
	ndr->depth--;
	ndr_print_NTTIME(ndr, "driver_date", r->driver_date);
	ndr_print_hyper(ndr, "driver_version", r->driver_version);
	ndr_print_ptr(ndr, "manufacturer_name", r->manufacturer_name);
	ndr->depth++;
	if (r->manufacturer_name) {
		ndr_print_string(ndr, "manufacturer_name", r->manufacturer_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "manufacturer_url", r->manufacturer_url);
	ndr->depth++;
	if (r->manufacturer_url) {
		ndr_print_string(ndr, "manufacturer_url", r->manufacturer_url);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "hardware_id", r->hardware_id);
	ndr->depth++;
	if (r->hardware_id) {
		ndr_print_string(ndr, "hardware_id", r->hardware_id);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "provider", r->provider);
	ndr->depth++;
	if (r->provider) {
		ndr_print_string(ndr, "provider", r->provider);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "print_processor", r->print_processor);
	ndr->depth++;
	if (r->print_processor) {
		ndr_print_string(ndr, "print_processor", r->print_processor);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "vendor_setup", r->vendor_setup);
	ndr->depth++;
	if (r->vendor_setup) {
		ndr_print_string(ndr, "vendor_setup", r->vendor_setup);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "_ndr_size_color_profiles", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?((ndr_size_spoolss_StringArray(r->color_profiles, ndr->iconv_convenience, ndr->flags) - 4) / 2):r->_ndr_size_color_profiles);
	ndr_print_ptr(ndr, "color_profiles", r->color_profiles);
	ndr->depth++;
	if (r->color_profiles) {
		ndr_print_spoolss_StringArray(ndr, "color_profiles", r->color_profiles);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "inf_path", r->inf_path);
	ndr->depth++;
	if (r->inf_path) {
		ndr_print_string(ndr, "inf_path", r->inf_path);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "printer_driver_attributes", r->printer_driver_attributes);
	ndr_print_uint32(ndr, "_ndr_size_core_driver_dependencies", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?((ndr_size_spoolss_StringArray(r->core_driver_dependencies, ndr->iconv_convenience, ndr->flags) - 4) / 2):r->_ndr_size_core_driver_dependencies);
	ndr_print_ptr(ndr, "core_driver_dependencies", r->core_driver_dependencies);
	ndr->depth++;
	if (r->core_driver_dependencies) {
		ndr_print_spoolss_StringArray(ndr, "core_driver_dependencies", r->core_driver_dependencies);
	}
	ndr->depth--;
	ndr_print_NTTIME(ndr, "min_inbox_driver_ver_date", r->min_inbox_driver_ver_date);
	ndr_print_hyper(ndr, "min_inbox_driver_ver_version", r->min_inbox_driver_ver_version);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_AddDriverInfo(struct ndr_push *ndr, int ndr_flags, const union spoolss_AddDriverInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1));
			break; }

			case 2: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info2));
			break; }

			case 3: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info3));
			break; }

			case 4: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info4));
			break; }

			case 6: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info6));
			break; }

			case 8: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info8));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 1:
				if (r->info1) {
					NDR_CHECK(ndr_push_spoolss_AddDriverInfo1(ndr, NDR_SCALARS|NDR_BUFFERS, r->info1));
				}
			break;

			case 2:
				if (r->info2) {
					NDR_CHECK(ndr_push_spoolss_AddDriverInfo2(ndr, NDR_SCALARS|NDR_BUFFERS, r->info2));
				}
			break;

			case 3:
				if (r->info3) {
					NDR_CHECK(ndr_push_spoolss_AddDriverInfo3(ndr, NDR_SCALARS|NDR_BUFFERS, r->info3));
				}
			break;

			case 4:
				if (r->info4) {
					NDR_CHECK(ndr_push_spoolss_AddDriverInfo4(ndr, NDR_SCALARS|NDR_BUFFERS, r->info4));
				}
			break;

			case 6:
				if (r->info6) {
					NDR_CHECK(ndr_push_spoolss_AddDriverInfo6(ndr, NDR_SCALARS|NDR_BUFFERS, r->info6));
				}
			break;

			case 8:
				if (r->info8) {
					NDR_CHECK(ndr_push_spoolss_AddDriverInfo8(ndr, NDR_SCALARS|NDR_BUFFERS, r->info8));
				}
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_AddDriverInfo(struct ndr_pull *ndr, int ndr_flags, union spoolss_AddDriverInfo *r)
{
	int level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_info1_0;
	TALLOC_CTX *_mem_save_info2_0;
	TALLOC_CTX *_mem_save_info3_0;
	TALLOC_CTX *_mem_save_info4_0;
	TALLOC_CTX *_mem_save_info6_0;
	TALLOC_CTX *_mem_save_info8_0;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r", _level);
		}
		switch (level) {
			case 1: {
				uint32_t _ptr_info1;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1));
				if (_ptr_info1) {
					NDR_PULL_ALLOC(ndr, r->info1);
				} else {
					r->info1 = NULL;
				}
			break; }

			case 2: {
				uint32_t _ptr_info2;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info2));
				if (_ptr_info2) {
					NDR_PULL_ALLOC(ndr, r->info2);
				} else {
					r->info2 = NULL;
				}
			break; }

			case 3: {
				uint32_t _ptr_info3;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info3));
				if (_ptr_info3) {
					NDR_PULL_ALLOC(ndr, r->info3);
				} else {
					r->info3 = NULL;
				}
			break; }

			case 4: {
				uint32_t _ptr_info4;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info4));
				if (_ptr_info4) {
					NDR_PULL_ALLOC(ndr, r->info4);
				} else {
					r->info4 = NULL;
				}
			break; }

			case 6: {
				uint32_t _ptr_info6;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info6));
				if (_ptr_info6) {
					NDR_PULL_ALLOC(ndr, r->info6);
				} else {
					r->info6 = NULL;
				}
			break; }

			case 8: {
				uint32_t _ptr_info8;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info8));
				if (_ptr_info8) {
					NDR_PULL_ALLOC(ndr, r->info8);
				} else {
					r->info8 = NULL;
				}
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
				if (r->info1) {
					_mem_save_info1_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1, 0);
					NDR_CHECK(ndr_pull_spoolss_AddDriverInfo1(ndr, NDR_SCALARS|NDR_BUFFERS, r->info1));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1_0, 0);
				}
			break;

			case 2:
				if (r->info2) {
					_mem_save_info2_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info2, 0);
					NDR_CHECK(ndr_pull_spoolss_AddDriverInfo2(ndr, NDR_SCALARS|NDR_BUFFERS, r->info2));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info2_0, 0);
				}
			break;

			case 3:
				if (r->info3) {
					_mem_save_info3_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info3, 0);
					NDR_CHECK(ndr_pull_spoolss_AddDriverInfo3(ndr, NDR_SCALARS|NDR_BUFFERS, r->info3));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info3_0, 0);
				}
			break;

			case 4:
				if (r->info4) {
					_mem_save_info4_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info4, 0);
					NDR_CHECK(ndr_pull_spoolss_AddDriverInfo4(ndr, NDR_SCALARS|NDR_BUFFERS, r->info4));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info4_0, 0);
				}
			break;

			case 6:
				if (r->info6) {
					_mem_save_info6_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info6, 0);
					NDR_CHECK(ndr_pull_spoolss_AddDriverInfo6(ndr, NDR_SCALARS|NDR_BUFFERS, r->info6));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info6_0, 0);
				}
			break;

			case 8:
				if (r->info8) {
					_mem_save_info8_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info8, 0);
					NDR_CHECK(ndr_pull_spoolss_AddDriverInfo8(ndr, NDR_SCALARS|NDR_BUFFERS, r->info8));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info8_0, 0);
				}
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_AddDriverInfo(struct ndr_print *ndr, const char *name, const union spoolss_AddDriverInfo *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "spoolss_AddDriverInfo");
	switch (level) {
		case 1:
			ndr_print_ptr(ndr, "info1", r->info1);
			ndr->depth++;
			if (r->info1) {
				ndr_print_spoolss_AddDriverInfo1(ndr, "info1", r->info1);
			}
			ndr->depth--;
		break;

		case 2:
			ndr_print_ptr(ndr, "info2", r->info2);
			ndr->depth++;
			if (r->info2) {
				ndr_print_spoolss_AddDriverInfo2(ndr, "info2", r->info2);
			}
			ndr->depth--;
		break;

		case 3:
			ndr_print_ptr(ndr, "info3", r->info3);
			ndr->depth++;
			if (r->info3) {
				ndr_print_spoolss_AddDriverInfo3(ndr, "info3", r->info3);
			}
			ndr->depth--;
		break;

		case 4:
			ndr_print_ptr(ndr, "info4", r->info4);
			ndr->depth++;
			if (r->info4) {
				ndr_print_spoolss_AddDriverInfo4(ndr, "info4", r->info4);
			}
			ndr->depth--;
		break;

		case 6:
			ndr_print_ptr(ndr, "info6", r->info6);
			ndr->depth++;
			if (r->info6) {
				ndr_print_spoolss_AddDriverInfo6(ndr, "info6", r->info6);
			}
			ndr->depth--;
		break;

		case 8:
			ndr_print_ptr(ndr, "info8", r->info8);
			ndr->depth++;
			if (r->info8) {
				ndr_print_spoolss_AddDriverInfo8(ndr, "info8", r->info8);
			}
			ndr->depth--;
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_spoolss_AddDriverInfoCtr(struct ndr_push *ndr, int ndr_flags, const struct spoolss_AddDriverInfoCtr *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->info, r->level));
		NDR_CHECK(ndr_push_spoolss_AddDriverInfo(ndr, NDR_SCALARS, &r->info));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_spoolss_AddDriverInfo(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_AddDriverInfoCtr(struct ndr_pull *ndr, int ndr_flags, struct spoolss_AddDriverInfoCtr *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->level));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->info, r->level));
		NDR_CHECK(ndr_pull_spoolss_AddDriverInfo(ndr, NDR_SCALARS, &r->info));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_spoolss_AddDriverInfo(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_AddDriverInfoCtr(struct ndr_print *ndr, const char *name, const struct spoolss_AddDriverInfoCtr *r)
{
	ndr_print_struct(ndr, name, "spoolss_AddDriverInfoCtr");
	ndr->depth++;
	ndr_print_uint32(ndr, "level", r->level);
	ndr_print_set_switch_value(ndr, &r->info, r->level);
	ndr_print_spoolss_AddDriverInfo(ndr, "info", &r->info);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_DriverInfo1(struct ndr_push *ndr, int ndr_flags, const struct spoolss_DriverInfo1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->driver_name));
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->driver_name) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->driver_name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->driver_name));
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_DriverInfo1(struct ndr_pull *ndr, int ndr_flags, struct spoolss_DriverInfo1 *r)
{
	uint32_t _ptr_driver_name;
	TALLOC_CTX *_mem_save_driver_name_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_driver_name));
			if (_ptr_driver_name) {
				NDR_PULL_ALLOC(ndr, r->driver_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->driver_name, _ptr_driver_name));
			} else {
				r->driver_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->driver_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->driver_name));
				_mem_save_driver_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->driver_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->driver_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_driver_name_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_DriverInfo1(struct ndr_print *ndr, const char *name, const struct spoolss_DriverInfo1 *r)
{
	ndr_print_struct(ndr, name, "spoolss_DriverInfo1");
	ndr->depth++;
	ndr_print_ptr(ndr, "driver_name", r->driver_name);
	ndr->depth++;
	if (r->driver_name) {
		ndr_print_string(ndr, "driver_name", r->driver_name);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_spoolss_DriverInfo1(const struct spoolss_DriverInfo1 *r, struct smb_iconv_convenience *ic, int flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_spoolss_DriverInfo1, ic);
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_DriverInfo2(struct ndr_push *ndr, int ndr_flags, const struct spoolss_DriverInfo2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_spoolss_DriverOSVersion(ndr, NDR_SCALARS, r->version));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->driver_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->architecture));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->driver_path));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->data_file));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->config_file));
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->driver_name) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->driver_name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->driver_name));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->architecture) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->architecture));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->architecture));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->driver_path) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->driver_path));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->driver_path));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->data_file) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->data_file));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->data_file));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->config_file) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->config_file));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->config_file));
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_DriverInfo2(struct ndr_pull *ndr, int ndr_flags, struct spoolss_DriverInfo2 *r)
{
	uint32_t _ptr_driver_name;
	TALLOC_CTX *_mem_save_driver_name_0;
	uint32_t _ptr_architecture;
	TALLOC_CTX *_mem_save_architecture_0;
	uint32_t _ptr_driver_path;
	TALLOC_CTX *_mem_save_driver_path_0;
	uint32_t _ptr_data_file;
	TALLOC_CTX *_mem_save_data_file_0;
	uint32_t _ptr_config_file;
	TALLOC_CTX *_mem_save_config_file_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_spoolss_DriverOSVersion(ndr, NDR_SCALARS, &r->version));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_driver_name));
			if (_ptr_driver_name) {
				NDR_PULL_ALLOC(ndr, r->driver_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->driver_name, _ptr_driver_name));
			} else {
				r->driver_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_architecture));
			if (_ptr_architecture) {
				NDR_PULL_ALLOC(ndr, r->architecture);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->architecture, _ptr_architecture));
			} else {
				r->architecture = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_driver_path));
			if (_ptr_driver_path) {
				NDR_PULL_ALLOC(ndr, r->driver_path);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->driver_path, _ptr_driver_path));
			} else {
				r->driver_path = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_data_file));
			if (_ptr_data_file) {
				NDR_PULL_ALLOC(ndr, r->data_file);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->data_file, _ptr_data_file));
			} else {
				r->data_file = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_config_file));
			if (_ptr_config_file) {
				NDR_PULL_ALLOC(ndr, r->config_file);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->config_file, _ptr_config_file));
			} else {
				r->config_file = NULL;
			}
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->driver_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->driver_name));
				_mem_save_driver_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->driver_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->driver_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_driver_name_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->architecture) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->architecture));
				_mem_save_architecture_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->architecture, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->architecture));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_architecture_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->driver_path) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->driver_path));
				_mem_save_driver_path_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->driver_path, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->driver_path));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_driver_path_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->data_file) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->data_file));
				_mem_save_data_file_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->data_file, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->data_file));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_file_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->config_file) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->config_file));
				_mem_save_config_file_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->config_file, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->config_file));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_config_file_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_DriverInfo2(struct ndr_print *ndr, const char *name, const struct spoolss_DriverInfo2 *r)
{
	ndr_print_struct(ndr, name, "spoolss_DriverInfo2");
	ndr->depth++;
	ndr_print_spoolss_DriverOSVersion(ndr, "version", r->version);
	ndr_print_ptr(ndr, "driver_name", r->driver_name);
	ndr->depth++;
	if (r->driver_name) {
		ndr_print_string(ndr, "driver_name", r->driver_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "architecture", r->architecture);
	ndr->depth++;
	if (r->architecture) {
		ndr_print_string(ndr, "architecture", r->architecture);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "driver_path", r->driver_path);
	ndr->depth++;
	if (r->driver_path) {
		ndr_print_string(ndr, "driver_path", r->driver_path);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "data_file", r->data_file);
	ndr->depth++;
	if (r->data_file) {
		ndr_print_string(ndr, "data_file", r->data_file);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "config_file", r->config_file);
	ndr->depth++;
	if (r->config_file) {
		ndr_print_string(ndr, "config_file", r->config_file);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_spoolss_DriverInfo2(const struct spoolss_DriverInfo2 *r, struct smb_iconv_convenience *ic, int flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_spoolss_DriverInfo2, ic);
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_DriverInfo3(struct ndr_push *ndr, int ndr_flags, const struct spoolss_DriverInfo3 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_spoolss_DriverOSVersion(ndr, NDR_SCALARS, r->version));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->driver_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->architecture));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->driver_path));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->data_file));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->config_file));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->help_file));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string_array = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->dependent_files));
			ndr->flags = _flags_save_string_array;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->monitor_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->default_datatype));
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->driver_name) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->driver_name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->driver_name));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->architecture) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->architecture));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->architecture));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->driver_path) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->driver_path));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->driver_path));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->data_file) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->data_file));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->data_file));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->config_file) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->config_file));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->config_file));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->help_file) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->help_file));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->help_file));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string_array = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->dependent_files) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->dependent_files));
				NDR_CHECK(ndr_push_string_array(ndr, NDR_SCALARS, r->dependent_files));
			}
			ndr->flags = _flags_save_string_array;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->monitor_name) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->monitor_name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->monitor_name));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->default_datatype) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->default_datatype));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->default_datatype));
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_DriverInfo3(struct ndr_pull *ndr, int ndr_flags, struct spoolss_DriverInfo3 *r)
{
	uint32_t _ptr_driver_name;
	TALLOC_CTX *_mem_save_driver_name_0;
	uint32_t _ptr_architecture;
	TALLOC_CTX *_mem_save_architecture_0;
	uint32_t _ptr_driver_path;
	TALLOC_CTX *_mem_save_driver_path_0;
	uint32_t _ptr_data_file;
	TALLOC_CTX *_mem_save_data_file_0;
	uint32_t _ptr_config_file;
	TALLOC_CTX *_mem_save_config_file_0;
	uint32_t _ptr_help_file;
	TALLOC_CTX *_mem_save_help_file_0;
	uint32_t _ptr_dependent_files;
	TALLOC_CTX *_mem_save_dependent_files_0;
	uint32_t _ptr_monitor_name;
	TALLOC_CTX *_mem_save_monitor_name_0;
	uint32_t _ptr_default_datatype;
	TALLOC_CTX *_mem_save_default_datatype_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_spoolss_DriverOSVersion(ndr, NDR_SCALARS, &r->version));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_driver_name));
			if (_ptr_driver_name) {
				NDR_PULL_ALLOC(ndr, r->driver_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->driver_name, _ptr_driver_name));
			} else {
				r->driver_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_architecture));
			if (_ptr_architecture) {
				NDR_PULL_ALLOC(ndr, r->architecture);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->architecture, _ptr_architecture));
			} else {
				r->architecture = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_driver_path));
			if (_ptr_driver_path) {
				NDR_PULL_ALLOC(ndr, r->driver_path);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->driver_path, _ptr_driver_path));
			} else {
				r->driver_path = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_data_file));
			if (_ptr_data_file) {
				NDR_PULL_ALLOC(ndr, r->data_file);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->data_file, _ptr_data_file));
			} else {
				r->data_file = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_config_file));
			if (_ptr_config_file) {
				NDR_PULL_ALLOC(ndr, r->config_file);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->config_file, _ptr_config_file));
			} else {
				r->config_file = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_help_file));
			if (_ptr_help_file) {
				NDR_PULL_ALLOC(ndr, r->help_file);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->help_file, _ptr_help_file));
			} else {
				r->help_file = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string_array = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dependent_files));
			if (_ptr_dependent_files) {
				NDR_PULL_ALLOC(ndr, r->dependent_files);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->dependent_files, _ptr_dependent_files));
			} else {
				r->dependent_files = NULL;
			}
			ndr->flags = _flags_save_string_array;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_monitor_name));
			if (_ptr_monitor_name) {
				NDR_PULL_ALLOC(ndr, r->monitor_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->monitor_name, _ptr_monitor_name));
			} else {
				r->monitor_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_default_datatype));
			if (_ptr_default_datatype) {
				NDR_PULL_ALLOC(ndr, r->default_datatype);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->default_datatype, _ptr_default_datatype));
			} else {
				r->default_datatype = NULL;
			}
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->driver_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->driver_name));
				_mem_save_driver_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->driver_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->driver_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_driver_name_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->architecture) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->architecture));
				_mem_save_architecture_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->architecture, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->architecture));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_architecture_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->driver_path) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->driver_path));
				_mem_save_driver_path_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->driver_path, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->driver_path));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_driver_path_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->data_file) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->data_file));
				_mem_save_data_file_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->data_file, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->data_file));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_file_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->config_file) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->config_file));
				_mem_save_config_file_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->config_file, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->config_file));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_config_file_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->help_file) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->help_file));
				_mem_save_help_file_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->help_file, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->help_file));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_help_file_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string_array = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->dependent_files) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->dependent_files));
				_mem_save_dependent_files_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->dependent_files, 0);
				NDR_CHECK(ndr_pull_string_array(ndr, NDR_SCALARS, &r->dependent_files));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dependent_files_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string_array;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->monitor_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->monitor_name));
				_mem_save_monitor_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->monitor_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->monitor_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_monitor_name_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->default_datatype) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->default_datatype));
				_mem_save_default_datatype_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->default_datatype, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->default_datatype));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_default_datatype_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_DriverInfo3(struct ndr_print *ndr, const char *name, const struct spoolss_DriverInfo3 *r)
{
	ndr_print_struct(ndr, name, "spoolss_DriverInfo3");
	ndr->depth++;
	ndr_print_spoolss_DriverOSVersion(ndr, "version", r->version);
	ndr_print_ptr(ndr, "driver_name", r->driver_name);
	ndr->depth++;
	if (r->driver_name) {
		ndr_print_string(ndr, "driver_name", r->driver_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "architecture", r->architecture);
	ndr->depth++;
	if (r->architecture) {
		ndr_print_string(ndr, "architecture", r->architecture);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "driver_path", r->driver_path);
	ndr->depth++;
	if (r->driver_path) {
		ndr_print_string(ndr, "driver_path", r->driver_path);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "data_file", r->data_file);
	ndr->depth++;
	if (r->data_file) {
		ndr_print_string(ndr, "data_file", r->data_file);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "config_file", r->config_file);
	ndr->depth++;
	if (r->config_file) {
		ndr_print_string(ndr, "config_file", r->config_file);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "help_file", r->help_file);
	ndr->depth++;
	if (r->help_file) {
		ndr_print_string(ndr, "help_file", r->help_file);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "dependent_files", r->dependent_files);
	ndr->depth++;
	if (r->dependent_files) {
		ndr_print_string_array(ndr, "dependent_files", r->dependent_files);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "monitor_name", r->monitor_name);
	ndr->depth++;
	if (r->monitor_name) {
		ndr_print_string(ndr, "monitor_name", r->monitor_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "default_datatype", r->default_datatype);
	ndr->depth++;
	if (r->default_datatype) {
		ndr_print_string(ndr, "default_datatype", r->default_datatype);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_spoolss_DriverInfo3(const struct spoolss_DriverInfo3 *r, struct smb_iconv_convenience *ic, int flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_spoolss_DriverInfo3, ic);
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_DriverInfo4(struct ndr_push *ndr, int ndr_flags, const struct spoolss_DriverInfo4 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_spoolss_DriverOSVersion(ndr, NDR_SCALARS, r->version));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->driver_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->architecture));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->driver_path));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->data_file));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->config_file));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->help_file));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string_array = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->dependent_files));
			ndr->flags = _flags_save_string_array;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->monitor_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->default_datatype));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string_array = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->previous_names));
			ndr->flags = _flags_save_string_array;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->driver_name) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->driver_name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->driver_name));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->architecture) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->architecture));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->architecture));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->driver_path) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->driver_path));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->driver_path));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->data_file) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->data_file));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->data_file));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->config_file) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->config_file));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->config_file));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->help_file) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->help_file));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->help_file));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string_array = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->dependent_files) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->dependent_files));
				NDR_CHECK(ndr_push_string_array(ndr, NDR_SCALARS, r->dependent_files));
			}
			ndr->flags = _flags_save_string_array;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->monitor_name) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->monitor_name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->monitor_name));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->default_datatype) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->default_datatype));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->default_datatype));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string_array = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->previous_names) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->previous_names));
				NDR_CHECK(ndr_push_string_array(ndr, NDR_SCALARS, r->previous_names));
			}
			ndr->flags = _flags_save_string_array;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_DriverInfo4(struct ndr_pull *ndr, int ndr_flags, struct spoolss_DriverInfo4 *r)
{
	uint32_t _ptr_driver_name;
	TALLOC_CTX *_mem_save_driver_name_0;
	uint32_t _ptr_architecture;
	TALLOC_CTX *_mem_save_architecture_0;
	uint32_t _ptr_driver_path;
	TALLOC_CTX *_mem_save_driver_path_0;
	uint32_t _ptr_data_file;
	TALLOC_CTX *_mem_save_data_file_0;
	uint32_t _ptr_config_file;
	TALLOC_CTX *_mem_save_config_file_0;
	uint32_t _ptr_help_file;
	TALLOC_CTX *_mem_save_help_file_0;
	uint32_t _ptr_dependent_files;
	TALLOC_CTX *_mem_save_dependent_files_0;
	uint32_t _ptr_monitor_name;
	TALLOC_CTX *_mem_save_monitor_name_0;
	uint32_t _ptr_default_datatype;
	TALLOC_CTX *_mem_save_default_datatype_0;
	uint32_t _ptr_previous_names;
	TALLOC_CTX *_mem_save_previous_names_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_spoolss_DriverOSVersion(ndr, NDR_SCALARS, &r->version));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_driver_name));
			if (_ptr_driver_name) {
				NDR_PULL_ALLOC(ndr, r->driver_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->driver_name, _ptr_driver_name));
			} else {
				r->driver_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_architecture));
			if (_ptr_architecture) {
				NDR_PULL_ALLOC(ndr, r->architecture);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->architecture, _ptr_architecture));
			} else {
				r->architecture = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_driver_path));
			if (_ptr_driver_path) {
				NDR_PULL_ALLOC(ndr, r->driver_path);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->driver_path, _ptr_driver_path));
			} else {
				r->driver_path = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_data_file));
			if (_ptr_data_file) {
				NDR_PULL_ALLOC(ndr, r->data_file);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->data_file, _ptr_data_file));
			} else {
				r->data_file = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_config_file));
			if (_ptr_config_file) {
				NDR_PULL_ALLOC(ndr, r->config_file);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->config_file, _ptr_config_file));
			} else {
				r->config_file = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_help_file));
			if (_ptr_help_file) {
				NDR_PULL_ALLOC(ndr, r->help_file);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->help_file, _ptr_help_file));
			} else {
				r->help_file = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string_array = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dependent_files));
			if (_ptr_dependent_files) {
				NDR_PULL_ALLOC(ndr, r->dependent_files);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->dependent_files, _ptr_dependent_files));
			} else {
				r->dependent_files = NULL;
			}
			ndr->flags = _flags_save_string_array;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_monitor_name));
			if (_ptr_monitor_name) {
				NDR_PULL_ALLOC(ndr, r->monitor_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->monitor_name, _ptr_monitor_name));
			} else {
				r->monitor_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_default_datatype));
			if (_ptr_default_datatype) {
				NDR_PULL_ALLOC(ndr, r->default_datatype);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->default_datatype, _ptr_default_datatype));
			} else {
				r->default_datatype = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string_array = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_previous_names));
			if (_ptr_previous_names) {
				NDR_PULL_ALLOC(ndr, r->previous_names);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->previous_names, _ptr_previous_names));
			} else {
				r->previous_names = NULL;
			}
			ndr->flags = _flags_save_string_array;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->driver_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->driver_name));
				_mem_save_driver_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->driver_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->driver_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_driver_name_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->architecture) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->architecture));
				_mem_save_architecture_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->architecture, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->architecture));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_architecture_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->driver_path) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->driver_path));
				_mem_save_driver_path_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->driver_path, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->driver_path));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_driver_path_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->data_file) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->data_file));
				_mem_save_data_file_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->data_file, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->data_file));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_file_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->config_file) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->config_file));
				_mem_save_config_file_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->config_file, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->config_file));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_config_file_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->help_file) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->help_file));
				_mem_save_help_file_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->help_file, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->help_file));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_help_file_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string_array = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->dependent_files) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->dependent_files));
				_mem_save_dependent_files_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->dependent_files, 0);
				NDR_CHECK(ndr_pull_string_array(ndr, NDR_SCALARS, &r->dependent_files));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dependent_files_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string_array;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->monitor_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->monitor_name));
				_mem_save_monitor_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->monitor_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->monitor_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_monitor_name_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->default_datatype) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->default_datatype));
				_mem_save_default_datatype_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->default_datatype, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->default_datatype));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_default_datatype_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string_array = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->previous_names) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->previous_names));
				_mem_save_previous_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->previous_names, 0);
				NDR_CHECK(ndr_pull_string_array(ndr, NDR_SCALARS, &r->previous_names));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_previous_names_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string_array;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_DriverInfo4(struct ndr_print *ndr, const char *name, const struct spoolss_DriverInfo4 *r)
{
	ndr_print_struct(ndr, name, "spoolss_DriverInfo4");
	ndr->depth++;
	ndr_print_spoolss_DriverOSVersion(ndr, "version", r->version);
	ndr_print_ptr(ndr, "driver_name", r->driver_name);
	ndr->depth++;
	if (r->driver_name) {
		ndr_print_string(ndr, "driver_name", r->driver_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "architecture", r->architecture);
	ndr->depth++;
	if (r->architecture) {
		ndr_print_string(ndr, "architecture", r->architecture);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "driver_path", r->driver_path);
	ndr->depth++;
	if (r->driver_path) {
		ndr_print_string(ndr, "driver_path", r->driver_path);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "data_file", r->data_file);
	ndr->depth++;
	if (r->data_file) {
		ndr_print_string(ndr, "data_file", r->data_file);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "config_file", r->config_file);
	ndr->depth++;
	if (r->config_file) {
		ndr_print_string(ndr, "config_file", r->config_file);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "help_file", r->help_file);
	ndr->depth++;
	if (r->help_file) {
		ndr_print_string(ndr, "help_file", r->help_file);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "dependent_files", r->dependent_files);
	ndr->depth++;
	if (r->dependent_files) {
		ndr_print_string_array(ndr, "dependent_files", r->dependent_files);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "monitor_name", r->monitor_name);
	ndr->depth++;
	if (r->monitor_name) {
		ndr_print_string(ndr, "monitor_name", r->monitor_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "default_datatype", r->default_datatype);
	ndr->depth++;
	if (r->default_datatype) {
		ndr_print_string(ndr, "default_datatype", r->default_datatype);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "previous_names", r->previous_names);
	ndr->depth++;
	if (r->previous_names) {
		ndr_print_string_array(ndr, "previous_names", r->previous_names);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_spoolss_DriverInfo4(const struct spoolss_DriverInfo4 *r, struct smb_iconv_convenience *ic, int flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_spoolss_DriverInfo4, ic);
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_DriverInfo5(struct ndr_push *ndr, int ndr_flags, const struct spoolss_DriverInfo5 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_spoolss_DriverOSVersion(ndr, NDR_SCALARS, r->version));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->driver_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->architecture));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->driver_path));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->data_file));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->config_file));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_spoolss_DriverAttributes(ndr, NDR_SCALARS, r->driver_attributes));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->config_version));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->driver_version));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->driver_name) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->driver_name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->driver_name));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->architecture) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->architecture));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->architecture));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->driver_path) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->driver_path));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->driver_path));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->data_file) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->data_file));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->data_file));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->config_file) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->config_file));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->config_file));
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_DriverInfo5(struct ndr_pull *ndr, int ndr_flags, struct spoolss_DriverInfo5 *r)
{
	uint32_t _ptr_driver_name;
	TALLOC_CTX *_mem_save_driver_name_0;
	uint32_t _ptr_architecture;
	TALLOC_CTX *_mem_save_architecture_0;
	uint32_t _ptr_driver_path;
	TALLOC_CTX *_mem_save_driver_path_0;
	uint32_t _ptr_data_file;
	TALLOC_CTX *_mem_save_data_file_0;
	uint32_t _ptr_config_file;
	TALLOC_CTX *_mem_save_config_file_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_spoolss_DriverOSVersion(ndr, NDR_SCALARS, &r->version));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_driver_name));
			if (_ptr_driver_name) {
				NDR_PULL_ALLOC(ndr, r->driver_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->driver_name, _ptr_driver_name));
			} else {
				r->driver_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_architecture));
			if (_ptr_architecture) {
				NDR_PULL_ALLOC(ndr, r->architecture);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->architecture, _ptr_architecture));
			} else {
				r->architecture = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_driver_path));
			if (_ptr_driver_path) {
				NDR_PULL_ALLOC(ndr, r->driver_path);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->driver_path, _ptr_driver_path));
			} else {
				r->driver_path = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_data_file));
			if (_ptr_data_file) {
				NDR_PULL_ALLOC(ndr, r->data_file);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->data_file, _ptr_data_file));
			} else {
				r->data_file = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_config_file));
			if (_ptr_config_file) {
				NDR_PULL_ALLOC(ndr, r->config_file);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->config_file, _ptr_config_file));
			} else {
				r->config_file = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_spoolss_DriverAttributes(ndr, NDR_SCALARS, &r->driver_attributes));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->config_version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->driver_version));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->driver_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->driver_name));
				_mem_save_driver_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->driver_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->driver_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_driver_name_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->architecture) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->architecture));
				_mem_save_architecture_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->architecture, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->architecture));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_architecture_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->driver_path) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->driver_path));
				_mem_save_driver_path_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->driver_path, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->driver_path));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_driver_path_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->data_file) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->data_file));
				_mem_save_data_file_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->data_file, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->data_file));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_file_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->config_file) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->config_file));
				_mem_save_config_file_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->config_file, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->config_file));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_config_file_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_DriverInfo5(struct ndr_print *ndr, const char *name, const struct spoolss_DriverInfo5 *r)
{
	ndr_print_struct(ndr, name, "spoolss_DriverInfo5");
	ndr->depth++;
	ndr_print_spoolss_DriverOSVersion(ndr, "version", r->version);
	ndr_print_ptr(ndr, "driver_name", r->driver_name);
	ndr->depth++;
	if (r->driver_name) {
		ndr_print_string(ndr, "driver_name", r->driver_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "architecture", r->architecture);
	ndr->depth++;
	if (r->architecture) {
		ndr_print_string(ndr, "architecture", r->architecture);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "driver_path", r->driver_path);
	ndr->depth++;
	if (r->driver_path) {
		ndr_print_string(ndr, "driver_path", r->driver_path);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "data_file", r->data_file);
	ndr->depth++;
	if (r->data_file) {
		ndr_print_string(ndr, "data_file", r->data_file);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "config_file", r->config_file);
	ndr->depth++;
	if (r->config_file) {
		ndr_print_string(ndr, "config_file", r->config_file);
	}
	ndr->depth--;
	ndr_print_spoolss_DriverAttributes(ndr, "driver_attributes", r->driver_attributes);
	ndr_print_uint32(ndr, "config_version", r->config_version);
	ndr_print_uint32(ndr, "driver_version", r->driver_version);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_spoolss_DriverInfo5(const struct spoolss_DriverInfo5 *r, struct smb_iconv_convenience *ic, int flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_spoolss_DriverInfo5, ic);
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_DriverInfo6(struct ndr_push *ndr, int ndr_flags, const struct spoolss_DriverInfo6 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_spoolss_DriverOSVersion(ndr, NDR_SCALARS, r->version));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->driver_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->architecture));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->driver_path));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->data_file));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->config_file));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->help_file));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string_array = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->dependent_files));
			ndr->flags = _flags_save_string_array;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->monitor_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->default_datatype));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string_array = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->previous_names));
			ndr->flags = _flags_save_string_array;
		}
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->driver_date));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->driver_version));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->manufacturer_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->manufacturer_url));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->hardware_id));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->provider));
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->driver_name) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->driver_name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->driver_name));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->architecture) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->architecture));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->architecture));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->driver_path) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->driver_path));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->driver_path));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->data_file) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->data_file));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->data_file));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->config_file) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->config_file));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->config_file));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->help_file) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->help_file));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->help_file));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string_array = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->dependent_files) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->dependent_files));
				NDR_CHECK(ndr_push_string_array(ndr, NDR_SCALARS, r->dependent_files));
			}
			ndr->flags = _flags_save_string_array;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->monitor_name) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->monitor_name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->monitor_name));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->default_datatype) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->default_datatype));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->default_datatype));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string_array = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->previous_names) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->previous_names));
				NDR_CHECK(ndr_push_string_array(ndr, NDR_SCALARS, r->previous_names));
			}
			ndr->flags = _flags_save_string_array;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->manufacturer_name) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->manufacturer_name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->manufacturer_name));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->manufacturer_url) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->manufacturer_url));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->manufacturer_url));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->hardware_id) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->hardware_id));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->hardware_id));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->provider) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->provider));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->provider));
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_DriverInfo6(struct ndr_pull *ndr, int ndr_flags, struct spoolss_DriverInfo6 *r)
{
	uint32_t _ptr_driver_name;
	TALLOC_CTX *_mem_save_driver_name_0;
	uint32_t _ptr_architecture;
	TALLOC_CTX *_mem_save_architecture_0;
	uint32_t _ptr_driver_path;
	TALLOC_CTX *_mem_save_driver_path_0;
	uint32_t _ptr_data_file;
	TALLOC_CTX *_mem_save_data_file_0;
	uint32_t _ptr_config_file;
	TALLOC_CTX *_mem_save_config_file_0;
	uint32_t _ptr_help_file;
	TALLOC_CTX *_mem_save_help_file_0;
	uint32_t _ptr_dependent_files;
	TALLOC_CTX *_mem_save_dependent_files_0;
	uint32_t _ptr_monitor_name;
	TALLOC_CTX *_mem_save_monitor_name_0;
	uint32_t _ptr_default_datatype;
	TALLOC_CTX *_mem_save_default_datatype_0;
	uint32_t _ptr_previous_names;
	TALLOC_CTX *_mem_save_previous_names_0;
	uint32_t _ptr_manufacturer_name;
	TALLOC_CTX *_mem_save_manufacturer_name_0;
	uint32_t _ptr_manufacturer_url;
	TALLOC_CTX *_mem_save_manufacturer_url_0;
	uint32_t _ptr_hardware_id;
	TALLOC_CTX *_mem_save_hardware_id_0;
	uint32_t _ptr_provider;
	TALLOC_CTX *_mem_save_provider_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_spoolss_DriverOSVersion(ndr, NDR_SCALARS, &r->version));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_driver_name));
			if (_ptr_driver_name) {
				NDR_PULL_ALLOC(ndr, r->driver_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->driver_name, _ptr_driver_name));
			} else {
				r->driver_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_architecture));
			if (_ptr_architecture) {
				NDR_PULL_ALLOC(ndr, r->architecture);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->architecture, _ptr_architecture));
			} else {
				r->architecture = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_driver_path));
			if (_ptr_driver_path) {
				NDR_PULL_ALLOC(ndr, r->driver_path);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->driver_path, _ptr_driver_path));
			} else {
				r->driver_path = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_data_file));
			if (_ptr_data_file) {
				NDR_PULL_ALLOC(ndr, r->data_file);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->data_file, _ptr_data_file));
			} else {
				r->data_file = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_config_file));
			if (_ptr_config_file) {
				NDR_PULL_ALLOC(ndr, r->config_file);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->config_file, _ptr_config_file));
			} else {
				r->config_file = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_help_file));
			if (_ptr_help_file) {
				NDR_PULL_ALLOC(ndr, r->help_file);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->help_file, _ptr_help_file));
			} else {
				r->help_file = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string_array = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dependent_files));
			if (_ptr_dependent_files) {
				NDR_PULL_ALLOC(ndr, r->dependent_files);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->dependent_files, _ptr_dependent_files));
			} else {
				r->dependent_files = NULL;
			}
			ndr->flags = _flags_save_string_array;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_monitor_name));
			if (_ptr_monitor_name) {
				NDR_PULL_ALLOC(ndr, r->monitor_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->monitor_name, _ptr_monitor_name));
			} else {
				r->monitor_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_default_datatype));
			if (_ptr_default_datatype) {
				NDR_PULL_ALLOC(ndr, r->default_datatype);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->default_datatype, _ptr_default_datatype));
			} else {
				r->default_datatype = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string_array = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_previous_names));
			if (_ptr_previous_names) {
				NDR_PULL_ALLOC(ndr, r->previous_names);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->previous_names, _ptr_previous_names));
			} else {
				r->previous_names = NULL;
			}
			ndr->flags = _flags_save_string_array;
		}
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->driver_date));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->driver_version));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_manufacturer_name));
			if (_ptr_manufacturer_name) {
				NDR_PULL_ALLOC(ndr, r->manufacturer_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->manufacturer_name, _ptr_manufacturer_name));
			} else {
				r->manufacturer_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_manufacturer_url));
			if (_ptr_manufacturer_url) {
				NDR_PULL_ALLOC(ndr, r->manufacturer_url);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->manufacturer_url, _ptr_manufacturer_url));
			} else {
				r->manufacturer_url = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_hardware_id));
			if (_ptr_hardware_id) {
				NDR_PULL_ALLOC(ndr, r->hardware_id);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->hardware_id, _ptr_hardware_id));
			} else {
				r->hardware_id = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_provider));
			if (_ptr_provider) {
				NDR_PULL_ALLOC(ndr, r->provider);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->provider, _ptr_provider));
			} else {
				r->provider = NULL;
			}
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->driver_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->driver_name));
				_mem_save_driver_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->driver_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->driver_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_driver_name_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->architecture) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->architecture));
				_mem_save_architecture_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->architecture, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->architecture));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_architecture_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->driver_path) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->driver_path));
				_mem_save_driver_path_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->driver_path, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->driver_path));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_driver_path_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->data_file) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->data_file));
				_mem_save_data_file_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->data_file, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->data_file));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_file_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->config_file) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->config_file));
				_mem_save_config_file_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->config_file, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->config_file));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_config_file_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->help_file) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->help_file));
				_mem_save_help_file_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->help_file, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->help_file));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_help_file_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string_array = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->dependent_files) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->dependent_files));
				_mem_save_dependent_files_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->dependent_files, 0);
				NDR_CHECK(ndr_pull_string_array(ndr, NDR_SCALARS, &r->dependent_files));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dependent_files_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string_array;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->monitor_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->monitor_name));
				_mem_save_monitor_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->monitor_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->monitor_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_monitor_name_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->default_datatype) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->default_datatype));
				_mem_save_default_datatype_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->default_datatype, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->default_datatype));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_default_datatype_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string_array = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->previous_names) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->previous_names));
				_mem_save_previous_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->previous_names, 0);
				NDR_CHECK(ndr_pull_string_array(ndr, NDR_SCALARS, &r->previous_names));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_previous_names_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string_array;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->manufacturer_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->manufacturer_name));
				_mem_save_manufacturer_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->manufacturer_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->manufacturer_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_manufacturer_name_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->manufacturer_url) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->manufacturer_url));
				_mem_save_manufacturer_url_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->manufacturer_url, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->manufacturer_url));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_manufacturer_url_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->hardware_id) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->hardware_id));
				_mem_save_hardware_id_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->hardware_id, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->hardware_id));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_hardware_id_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->provider) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->provider));
				_mem_save_provider_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->provider, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->provider));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_provider_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_DriverInfo6(struct ndr_print *ndr, const char *name, const struct spoolss_DriverInfo6 *r)
{
	ndr_print_struct(ndr, name, "spoolss_DriverInfo6");
	ndr->depth++;
	ndr_print_spoolss_DriverOSVersion(ndr, "version", r->version);
	ndr_print_ptr(ndr, "driver_name", r->driver_name);
	ndr->depth++;
	if (r->driver_name) {
		ndr_print_string(ndr, "driver_name", r->driver_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "architecture", r->architecture);
	ndr->depth++;
	if (r->architecture) {
		ndr_print_string(ndr, "architecture", r->architecture);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "driver_path", r->driver_path);
	ndr->depth++;
	if (r->driver_path) {
		ndr_print_string(ndr, "driver_path", r->driver_path);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "data_file", r->data_file);
	ndr->depth++;
	if (r->data_file) {
		ndr_print_string(ndr, "data_file", r->data_file);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "config_file", r->config_file);
	ndr->depth++;
	if (r->config_file) {
		ndr_print_string(ndr, "config_file", r->config_file);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "help_file", r->help_file);
	ndr->depth++;
	if (r->help_file) {
		ndr_print_string(ndr, "help_file", r->help_file);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "dependent_files", r->dependent_files);
	ndr->depth++;
	if (r->dependent_files) {
		ndr_print_string_array(ndr, "dependent_files", r->dependent_files);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "monitor_name", r->monitor_name);
	ndr->depth++;
	if (r->monitor_name) {
		ndr_print_string(ndr, "monitor_name", r->monitor_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "default_datatype", r->default_datatype);
	ndr->depth++;
	if (r->default_datatype) {
		ndr_print_string(ndr, "default_datatype", r->default_datatype);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "previous_names", r->previous_names);
	ndr->depth++;
	if (r->previous_names) {
		ndr_print_string_array(ndr, "previous_names", r->previous_names);
	}
	ndr->depth--;
	ndr_print_NTTIME(ndr, "driver_date", r->driver_date);
	ndr_print_hyper(ndr, "driver_version", r->driver_version);
	ndr_print_ptr(ndr, "manufacturer_name", r->manufacturer_name);
	ndr->depth++;
	if (r->manufacturer_name) {
		ndr_print_string(ndr, "manufacturer_name", r->manufacturer_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "manufacturer_url", r->manufacturer_url);
	ndr->depth++;
	if (r->manufacturer_url) {
		ndr_print_string(ndr, "manufacturer_url", r->manufacturer_url);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "hardware_id", r->hardware_id);
	ndr->depth++;
	if (r->hardware_id) {
		ndr_print_string(ndr, "hardware_id", r->hardware_id);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "provider", r->provider);
	ndr->depth++;
	if (r->provider) {
		ndr_print_string(ndr, "provider", r->provider);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_spoolss_DriverInfo6(const struct spoolss_DriverInfo6 *r, struct smb_iconv_convenience *ic, int flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_spoolss_DriverInfo6, ic);
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_DriverInfo8(struct ndr_push *ndr, int ndr_flags, const struct spoolss_DriverInfo8 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_spoolss_DriverOSVersion(ndr, NDR_SCALARS, r->version));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->driver_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->architecture));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->driver_path));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->data_file));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->config_file));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->help_file));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->monitor_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->default_datatype));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string_array = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->dependent_files));
			ndr->flags = _flags_save_string_array;
		}
		{
			uint32_t _flags_save_string_array = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->previous_names));
			ndr->flags = _flags_save_string_array;
		}
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->driver_date));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->driver_version));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->manufacturer_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->manufacturer_url));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->hardware_id));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->provider));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->print_processor));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->vendor_setup));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string_array = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->color_profiles));
			ndr->flags = _flags_save_string_array;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->inf_path));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->printer_driver_attributes));
		{
			uint32_t _flags_save_string_array = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->core_driver_dependencies));
			ndr->flags = _flags_save_string_array;
		}
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->min_inbox_driver_ver_date));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->min_inbox_driver_ver_version));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->driver_name) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->driver_name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->driver_name));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->architecture) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->architecture));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->architecture));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->driver_path) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->driver_path));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->driver_path));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->data_file) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->data_file));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->data_file));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->config_file) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->config_file));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->config_file));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->help_file) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->help_file));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->help_file));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->monitor_name) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->monitor_name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->monitor_name));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->default_datatype) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->default_datatype));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->default_datatype));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string_array = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->dependent_files) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->dependent_files));
				NDR_CHECK(ndr_push_string_array(ndr, NDR_SCALARS, r->dependent_files));
			}
			ndr->flags = _flags_save_string_array;
		}
		{
			uint32_t _flags_save_string_array = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->previous_names) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->previous_names));
				NDR_CHECK(ndr_push_string_array(ndr, NDR_SCALARS, r->previous_names));
			}
			ndr->flags = _flags_save_string_array;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->manufacturer_name) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->manufacturer_name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->manufacturer_name));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->manufacturer_url) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->manufacturer_url));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->manufacturer_url));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->hardware_id) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->hardware_id));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->hardware_id));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->provider) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->provider));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->provider));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->print_processor) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->print_processor));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->print_processor));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->vendor_setup) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->vendor_setup));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->vendor_setup));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string_array = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->color_profiles) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->color_profiles));
				NDR_CHECK(ndr_push_string_array(ndr, NDR_SCALARS, r->color_profiles));
			}
			ndr->flags = _flags_save_string_array;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->inf_path) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->inf_path));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->inf_path));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string_array = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->core_driver_dependencies) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->core_driver_dependencies));
				NDR_CHECK(ndr_push_string_array(ndr, NDR_SCALARS, r->core_driver_dependencies));
			}
			ndr->flags = _flags_save_string_array;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_DriverInfo8(struct ndr_pull *ndr, int ndr_flags, struct spoolss_DriverInfo8 *r)
{
	uint32_t _ptr_driver_name;
	TALLOC_CTX *_mem_save_driver_name_0;
	uint32_t _ptr_architecture;
	TALLOC_CTX *_mem_save_architecture_0;
	uint32_t _ptr_driver_path;
	TALLOC_CTX *_mem_save_driver_path_0;
	uint32_t _ptr_data_file;
	TALLOC_CTX *_mem_save_data_file_0;
	uint32_t _ptr_config_file;
	TALLOC_CTX *_mem_save_config_file_0;
	uint32_t _ptr_help_file;
	TALLOC_CTX *_mem_save_help_file_0;
	uint32_t _ptr_monitor_name;
	TALLOC_CTX *_mem_save_monitor_name_0;
	uint32_t _ptr_default_datatype;
	TALLOC_CTX *_mem_save_default_datatype_0;
	uint32_t _ptr_dependent_files;
	TALLOC_CTX *_mem_save_dependent_files_0;
	uint32_t _ptr_previous_names;
	TALLOC_CTX *_mem_save_previous_names_0;
	uint32_t _ptr_manufacturer_name;
	TALLOC_CTX *_mem_save_manufacturer_name_0;
	uint32_t _ptr_manufacturer_url;
	TALLOC_CTX *_mem_save_manufacturer_url_0;
	uint32_t _ptr_hardware_id;
	TALLOC_CTX *_mem_save_hardware_id_0;
	uint32_t _ptr_provider;
	TALLOC_CTX *_mem_save_provider_0;
	uint32_t _ptr_print_processor;
	TALLOC_CTX *_mem_save_print_processor_0;
	uint32_t _ptr_vendor_setup;
	TALLOC_CTX *_mem_save_vendor_setup_0;
	uint32_t _ptr_color_profiles;
	TALLOC_CTX *_mem_save_color_profiles_0;
	uint32_t _ptr_inf_path;
	TALLOC_CTX *_mem_save_inf_path_0;
	uint32_t _ptr_core_driver_dependencies;
	TALLOC_CTX *_mem_save_core_driver_dependencies_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_spoolss_DriverOSVersion(ndr, NDR_SCALARS, &r->version));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_driver_name));
			if (_ptr_driver_name) {
				NDR_PULL_ALLOC(ndr, r->driver_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->driver_name, _ptr_driver_name));
			} else {
				r->driver_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_architecture));
			if (_ptr_architecture) {
				NDR_PULL_ALLOC(ndr, r->architecture);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->architecture, _ptr_architecture));
			} else {
				r->architecture = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_driver_path));
			if (_ptr_driver_path) {
				NDR_PULL_ALLOC(ndr, r->driver_path);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->driver_path, _ptr_driver_path));
			} else {
				r->driver_path = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_data_file));
			if (_ptr_data_file) {
				NDR_PULL_ALLOC(ndr, r->data_file);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->data_file, _ptr_data_file));
			} else {
				r->data_file = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_config_file));
			if (_ptr_config_file) {
				NDR_PULL_ALLOC(ndr, r->config_file);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->config_file, _ptr_config_file));
			} else {
				r->config_file = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_help_file));
			if (_ptr_help_file) {
				NDR_PULL_ALLOC(ndr, r->help_file);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->help_file, _ptr_help_file));
			} else {
				r->help_file = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_monitor_name));
			if (_ptr_monitor_name) {
				NDR_PULL_ALLOC(ndr, r->monitor_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->monitor_name, _ptr_monitor_name));
			} else {
				r->monitor_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_default_datatype));
			if (_ptr_default_datatype) {
				NDR_PULL_ALLOC(ndr, r->default_datatype);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->default_datatype, _ptr_default_datatype));
			} else {
				r->default_datatype = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string_array = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dependent_files));
			if (_ptr_dependent_files) {
				NDR_PULL_ALLOC(ndr, r->dependent_files);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->dependent_files, _ptr_dependent_files));
			} else {
				r->dependent_files = NULL;
			}
			ndr->flags = _flags_save_string_array;
		}
		{
			uint32_t _flags_save_string_array = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_previous_names));
			if (_ptr_previous_names) {
				NDR_PULL_ALLOC(ndr, r->previous_names);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->previous_names, _ptr_previous_names));
			} else {
				r->previous_names = NULL;
			}
			ndr->flags = _flags_save_string_array;
		}
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->driver_date));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->driver_version));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_manufacturer_name));
			if (_ptr_manufacturer_name) {
				NDR_PULL_ALLOC(ndr, r->manufacturer_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->manufacturer_name, _ptr_manufacturer_name));
			} else {
				r->manufacturer_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_manufacturer_url));
			if (_ptr_manufacturer_url) {
				NDR_PULL_ALLOC(ndr, r->manufacturer_url);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->manufacturer_url, _ptr_manufacturer_url));
			} else {
				r->manufacturer_url = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_hardware_id));
			if (_ptr_hardware_id) {
				NDR_PULL_ALLOC(ndr, r->hardware_id);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->hardware_id, _ptr_hardware_id));
			} else {
				r->hardware_id = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_provider));
			if (_ptr_provider) {
				NDR_PULL_ALLOC(ndr, r->provider);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->provider, _ptr_provider));
			} else {
				r->provider = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_print_processor));
			if (_ptr_print_processor) {
				NDR_PULL_ALLOC(ndr, r->print_processor);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->print_processor, _ptr_print_processor));
			} else {
				r->print_processor = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_vendor_setup));
			if (_ptr_vendor_setup) {
				NDR_PULL_ALLOC(ndr, r->vendor_setup);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->vendor_setup, _ptr_vendor_setup));
			} else {
				r->vendor_setup = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string_array = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_color_profiles));
			if (_ptr_color_profiles) {
				NDR_PULL_ALLOC(ndr, r->color_profiles);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->color_profiles, _ptr_color_profiles));
			} else {
				r->color_profiles = NULL;
			}
			ndr->flags = _flags_save_string_array;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_inf_path));
			if (_ptr_inf_path) {
				NDR_PULL_ALLOC(ndr, r->inf_path);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->inf_path, _ptr_inf_path));
			} else {
				r->inf_path = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->printer_driver_attributes));
		{
			uint32_t _flags_save_string_array = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_core_driver_dependencies));
			if (_ptr_core_driver_dependencies) {
				NDR_PULL_ALLOC(ndr, r->core_driver_dependencies);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->core_driver_dependencies, _ptr_core_driver_dependencies));
			} else {
				r->core_driver_dependencies = NULL;
			}
			ndr->flags = _flags_save_string_array;
		}
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->min_inbox_driver_ver_date));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->min_inbox_driver_ver_version));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->driver_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->driver_name));
				_mem_save_driver_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->driver_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->driver_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_driver_name_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->architecture) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->architecture));
				_mem_save_architecture_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->architecture, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->architecture));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_architecture_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->driver_path) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->driver_path));
				_mem_save_driver_path_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->driver_path, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->driver_path));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_driver_path_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->data_file) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->data_file));
				_mem_save_data_file_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->data_file, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->data_file));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_file_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->config_file) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->config_file));
				_mem_save_config_file_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->config_file, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->config_file));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_config_file_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->help_file) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->help_file));
				_mem_save_help_file_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->help_file, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->help_file));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_help_file_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->monitor_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->monitor_name));
				_mem_save_monitor_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->monitor_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->monitor_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_monitor_name_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->default_datatype) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->default_datatype));
				_mem_save_default_datatype_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->default_datatype, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->default_datatype));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_default_datatype_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string_array = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->dependent_files) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->dependent_files));
				_mem_save_dependent_files_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->dependent_files, 0);
				NDR_CHECK(ndr_pull_string_array(ndr, NDR_SCALARS, &r->dependent_files));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dependent_files_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string_array;
		}
		{
			uint32_t _flags_save_string_array = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->previous_names) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->previous_names));
				_mem_save_previous_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->previous_names, 0);
				NDR_CHECK(ndr_pull_string_array(ndr, NDR_SCALARS, &r->previous_names));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_previous_names_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string_array;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->manufacturer_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->manufacturer_name));
				_mem_save_manufacturer_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->manufacturer_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->manufacturer_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_manufacturer_name_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->manufacturer_url) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->manufacturer_url));
				_mem_save_manufacturer_url_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->manufacturer_url, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->manufacturer_url));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_manufacturer_url_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->hardware_id) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->hardware_id));
				_mem_save_hardware_id_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->hardware_id, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->hardware_id));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_hardware_id_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->provider) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->provider));
				_mem_save_provider_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->provider, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->provider));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_provider_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->print_processor) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->print_processor));
				_mem_save_print_processor_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->print_processor, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->print_processor));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_print_processor_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->vendor_setup) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->vendor_setup));
				_mem_save_vendor_setup_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->vendor_setup, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->vendor_setup));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_vendor_setup_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string_array = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->color_profiles) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->color_profiles));
				_mem_save_color_profiles_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->color_profiles, 0);
				NDR_CHECK(ndr_pull_string_array(ndr, NDR_SCALARS, &r->color_profiles));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_color_profiles_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string_array;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->inf_path) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->inf_path));
				_mem_save_inf_path_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->inf_path, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->inf_path));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_inf_path_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string_array = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->core_driver_dependencies) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->core_driver_dependencies));
				_mem_save_core_driver_dependencies_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->core_driver_dependencies, 0);
				NDR_CHECK(ndr_pull_string_array(ndr, NDR_SCALARS, &r->core_driver_dependencies));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_core_driver_dependencies_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string_array;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_DriverInfo8(struct ndr_print *ndr, const char *name, const struct spoolss_DriverInfo8 *r)
{
	ndr_print_struct(ndr, name, "spoolss_DriverInfo8");
	ndr->depth++;
	ndr_print_spoolss_DriverOSVersion(ndr, "version", r->version);
	ndr_print_ptr(ndr, "driver_name", r->driver_name);
	ndr->depth++;
	if (r->driver_name) {
		ndr_print_string(ndr, "driver_name", r->driver_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "architecture", r->architecture);
	ndr->depth++;
	if (r->architecture) {
		ndr_print_string(ndr, "architecture", r->architecture);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "driver_path", r->driver_path);
	ndr->depth++;
	if (r->driver_path) {
		ndr_print_string(ndr, "driver_path", r->driver_path);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "data_file", r->data_file);
	ndr->depth++;
	if (r->data_file) {
		ndr_print_string(ndr, "data_file", r->data_file);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "config_file", r->config_file);
	ndr->depth++;
	if (r->config_file) {
		ndr_print_string(ndr, "config_file", r->config_file);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "help_file", r->help_file);
	ndr->depth++;
	if (r->help_file) {
		ndr_print_string(ndr, "help_file", r->help_file);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "monitor_name", r->monitor_name);
	ndr->depth++;
	if (r->monitor_name) {
		ndr_print_string(ndr, "monitor_name", r->monitor_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "default_datatype", r->default_datatype);
	ndr->depth++;
	if (r->default_datatype) {
		ndr_print_string(ndr, "default_datatype", r->default_datatype);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "dependent_files", r->dependent_files);
	ndr->depth++;
	if (r->dependent_files) {
		ndr_print_string_array(ndr, "dependent_files", r->dependent_files);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "previous_names", r->previous_names);
	ndr->depth++;
	if (r->previous_names) {
		ndr_print_string_array(ndr, "previous_names", r->previous_names);
	}
	ndr->depth--;
	ndr_print_NTTIME(ndr, "driver_date", r->driver_date);
	ndr_print_hyper(ndr, "driver_version", r->driver_version);
	ndr_print_ptr(ndr, "manufacturer_name", r->manufacturer_name);
	ndr->depth++;
	if (r->manufacturer_name) {
		ndr_print_string(ndr, "manufacturer_name", r->manufacturer_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "manufacturer_url", r->manufacturer_url);
	ndr->depth++;
	if (r->manufacturer_url) {
		ndr_print_string(ndr, "manufacturer_url", r->manufacturer_url);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "hardware_id", r->hardware_id);
	ndr->depth++;
	if (r->hardware_id) {
		ndr_print_string(ndr, "hardware_id", r->hardware_id);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "provider", r->provider);
	ndr->depth++;
	if (r->provider) {
		ndr_print_string(ndr, "provider", r->provider);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "print_processor", r->print_processor);
	ndr->depth++;
	if (r->print_processor) {
		ndr_print_string(ndr, "print_processor", r->print_processor);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "vendor_setup", r->vendor_setup);
	ndr->depth++;
	if (r->vendor_setup) {
		ndr_print_string(ndr, "vendor_setup", r->vendor_setup);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "color_profiles", r->color_profiles);
	ndr->depth++;
	if (r->color_profiles) {
		ndr_print_string_array(ndr, "color_profiles", r->color_profiles);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "inf_path", r->inf_path);
	ndr->depth++;
	if (r->inf_path) {
		ndr_print_string(ndr, "inf_path", r->inf_path);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "printer_driver_attributes", r->printer_driver_attributes);
	ndr_print_ptr(ndr, "core_driver_dependencies", r->core_driver_dependencies);
	ndr->depth++;
	if (r->core_driver_dependencies) {
		ndr_print_string_array(ndr, "core_driver_dependencies", r->core_driver_dependencies);
	}
	ndr->depth--;
	ndr_print_NTTIME(ndr, "min_inbox_driver_ver_date", r->min_inbox_driver_ver_date);
	ndr_print_hyper(ndr, "min_inbox_driver_ver_version", r->min_inbox_driver_ver_version);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_spoolss_DriverInfo8(const struct spoolss_DriverInfo8 *r, struct smb_iconv_convenience *ic, int flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_spoolss_DriverInfo8, ic);
}

static enum ndr_err_code ndr_push_spoolss_DriverFileType(struct ndr_push *ndr, int ndr_flags, enum spoolss_DriverFileType r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_DriverFileType(struct ndr_pull *ndr, int ndr_flags, enum spoolss_DriverFileType *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_DriverFileType(struct ndr_print *ndr, const char *name, enum spoolss_DriverFileType r)
{
	const char *val = NULL;

	switch (r) {
		case SPOOLSS_DRIVER_FILE_TYPE_RENDERING: val = "SPOOLSS_DRIVER_FILE_TYPE_RENDERING"; break;
		case SPOOLSS_DRIVER_FILE_TYPE_CONFIGURATION: val = "SPOOLSS_DRIVER_FILE_TYPE_CONFIGURATION"; break;
		case SPOOLSS_DRIVER_FILE_TYPE_DATA: val = "SPOOLSS_DRIVER_FILE_TYPE_DATA"; break;
		case SPOOLSS_DRIVER_FILE_TYPE_HELP: val = "SPOOLSS_DRIVER_FILE_TYPE_HELP"; break;
		case SPOOLSS_DRIVER_FILE_TYPE_OTHER: val = "SPOOLSS_DRIVER_FILE_TYPE_OTHER"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_DriverFileInfo(struct ndr_push *ndr, int ndr_flags, const struct spoolss_DriverFileInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->file_name));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_spoolss_DriverFileType(ndr, NDR_SCALARS, r->file_type));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->file_version));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->file_name) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->file_name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->file_name));
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_DriverFileInfo(struct ndr_pull *ndr, int ndr_flags, struct spoolss_DriverFileInfo *r)
{
	uint32_t _ptr_file_name;
	TALLOC_CTX *_mem_save_file_name_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_file_name));
			if (_ptr_file_name) {
				NDR_PULL_ALLOC(ndr, r->file_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->file_name, _ptr_file_name));
			} else {
				r->file_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_spoolss_DriverFileType(ndr, NDR_SCALARS, &r->file_type));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->file_version));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->file_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->file_name));
				_mem_save_file_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->file_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->file_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_file_name_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_DriverFileInfo(struct ndr_print *ndr, const char *name, const struct spoolss_DriverFileInfo *r)
{
	ndr_print_struct(ndr, name, "spoolss_DriverFileInfo");
	ndr->depth++;
	ndr_print_ptr(ndr, "file_name", r->file_name);
	ndr->depth++;
	if (r->file_name) {
		ndr_print_string(ndr, "file_name", r->file_name);
	}
	ndr->depth--;
	ndr_print_spoolss_DriverFileType(ndr, "file_type", r->file_type);
	ndr_print_uint32(ndr, "file_version", r->file_version);
	ndr->depth--;
}

_PUBLIC_ void ndr_print_spoolss_DriverInfo101(struct ndr_print *ndr, const char *name, const struct spoolss_DriverInfo101 *r)
{
	uint32_t cntr_file_info_1;
	ndr_print_struct(ndr, name, "spoolss_DriverInfo101");
	ndr->depth++;
	ndr_print_spoolss_DriverOSVersion(ndr, "version", r->version);
	ndr_print_ptr(ndr, "driver_name", r->driver_name);
	ndr->depth++;
	if (r->driver_name) {
		ndr_print_string(ndr, "driver_name", r->driver_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "architecture", r->architecture);
	ndr->depth++;
	if (r->architecture) {
		ndr_print_string(ndr, "architecture", r->architecture);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "file_info", r->file_info);
	ndr->depth++;
	if (r->file_info) {
		ndr->print(ndr, "%s: ARRAY(%d)", "file_info", (int)r->file_count);
		ndr->depth++;
		for (cntr_file_info_1=0;cntr_file_info_1<r->file_count;cntr_file_info_1++) {
			char *idx_1=NULL;
			if (asprintf(&idx_1, "[%d]", cntr_file_info_1) != -1) {
				ndr_print_spoolss_DriverFileInfo(ndr, "file_info", &r->file_info[cntr_file_info_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "file_count", r->file_count);
	ndr_print_ptr(ndr, "monitor_name", r->monitor_name);
	ndr->depth++;
	if (r->monitor_name) {
		ndr_print_string(ndr, "monitor_name", r->monitor_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "default_datatype", r->default_datatype);
	ndr->depth++;
	if (r->default_datatype) {
		ndr_print_string(ndr, "default_datatype", r->default_datatype);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "previous_names", r->previous_names);
	ndr->depth++;
	if (r->previous_names) {
		ndr_print_string_array(ndr, "previous_names", r->previous_names);
	}
	ndr->depth--;
	ndr_print_NTTIME(ndr, "driver_date", r->driver_date);
	ndr_print_hyper(ndr, "driver_version", r->driver_version);
	ndr_print_ptr(ndr, "manufacturer_name", r->manufacturer_name);
	ndr->depth++;
	if (r->manufacturer_name) {
		ndr_print_string(ndr, "manufacturer_name", r->manufacturer_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "manufacturer_url", r->manufacturer_url);
	ndr->depth++;
	if (r->manufacturer_url) {
		ndr_print_string(ndr, "manufacturer_url", r->manufacturer_url);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "hardware_id", r->hardware_id);
	ndr->depth++;
	if (r->hardware_id) {
		ndr_print_string(ndr, "hardware_id", r->hardware_id);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "provider", r->provider);
	ndr->depth++;
	if (r->provider) {
		ndr_print_string(ndr, "provider", r->provider);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_spoolss_DriverInfo101(const struct spoolss_DriverInfo101 *r, struct smb_iconv_convenience *ic, int flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_spoolss_DriverInfo101, ic);
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_DriverInfo(struct ndr_push *ndr, int ndr_flags, const union spoolss_DriverInfo *r)
{
	uint32_t _save_relative_base_offset = ndr_push_get_relative_base_offset(ndr);
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_align(ndr, 4));
				NDR_CHECK(ndr_push_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_push_spoolss_DriverInfo1(ndr, NDR_SCALARS, &r->info1));
			break; }

			case 2: {
				NDR_CHECK(ndr_push_align(ndr, 4));
				NDR_CHECK(ndr_push_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_push_spoolss_DriverInfo2(ndr, NDR_SCALARS, &r->info2));
			break; }

			case 3: {
				NDR_CHECK(ndr_push_align(ndr, 4));
				NDR_CHECK(ndr_push_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_push_spoolss_DriverInfo3(ndr, NDR_SCALARS, &r->info3));
			break; }

			case 4: {
				NDR_CHECK(ndr_push_align(ndr, 4));
				NDR_CHECK(ndr_push_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_push_spoolss_DriverInfo4(ndr, NDR_SCALARS, &r->info4));
			break; }

			case 5: {
				NDR_CHECK(ndr_push_align(ndr, 4));
				NDR_CHECK(ndr_push_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_push_spoolss_DriverInfo5(ndr, NDR_SCALARS, &r->info5));
			break; }

			case 6: {
				NDR_CHECK(ndr_push_align(ndr, 8));
				NDR_CHECK(ndr_push_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_push_spoolss_DriverInfo6(ndr, NDR_SCALARS, &r->info6));
			break; }

			case 8: {
				NDR_CHECK(ndr_push_align(ndr, 8));
				NDR_CHECK(ndr_push_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_push_spoolss_DriverInfo8(ndr, NDR_SCALARS, &r->info8));
			break; }

			case 101: {
				NDR_CHECK(ndr_push_align(ndr, 8));
				NDR_CHECK(ndr_push_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_push_spoolss_DriverInfo101(ndr, NDR_SCALARS, &r->info101));
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_setup_relative_base_offset2(ndr, r));
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_spoolss_DriverInfo1(ndr, NDR_BUFFERS, &r->info1));
			break;

			case 2:
				NDR_CHECK(ndr_push_spoolss_DriverInfo2(ndr, NDR_BUFFERS, &r->info2));
			break;

			case 3:
				NDR_CHECK(ndr_push_spoolss_DriverInfo3(ndr, NDR_BUFFERS, &r->info3));
			break;

			case 4:
				NDR_CHECK(ndr_push_spoolss_DriverInfo4(ndr, NDR_BUFFERS, &r->info4));
			break;

			case 5:
				NDR_CHECK(ndr_push_spoolss_DriverInfo5(ndr, NDR_BUFFERS, &r->info5));
			break;

			case 6:
				NDR_CHECK(ndr_push_spoolss_DriverInfo6(ndr, NDR_BUFFERS, &r->info6));
			break;

			case 8:
				NDR_CHECK(ndr_push_spoolss_DriverInfo8(ndr, NDR_BUFFERS, &r->info8));
			break;

			case 101:
				NDR_CHECK(ndr_push_spoolss_DriverInfo101(ndr, NDR_BUFFERS, &r->info101));
			break;

			default:
			break;

		}
	}
	ndr_push_restore_relative_base_offset(ndr, _save_relative_base_offset);
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_DriverInfo(struct ndr_pull *ndr, int ndr_flags, union spoolss_DriverInfo *r)
{
	uint32_t _save_relative_base_offset = ndr_pull_get_relative_base_offset(ndr);
	int level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_align(ndr, 4));
				NDR_CHECK(ndr_pull_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_pull_spoolss_DriverInfo1(ndr, NDR_SCALARS, &r->info1));
			break; }

			case 2: {
				NDR_CHECK(ndr_pull_align(ndr, 4));
				NDR_CHECK(ndr_pull_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_pull_spoolss_DriverInfo2(ndr, NDR_SCALARS, &r->info2));
			break; }

			case 3: {
				NDR_CHECK(ndr_pull_align(ndr, 4));
				NDR_CHECK(ndr_pull_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_pull_spoolss_DriverInfo3(ndr, NDR_SCALARS, &r->info3));
			break; }

			case 4: {
				NDR_CHECK(ndr_pull_align(ndr, 4));
				NDR_CHECK(ndr_pull_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_pull_spoolss_DriverInfo4(ndr, NDR_SCALARS, &r->info4));
			break; }

			case 5: {
				NDR_CHECK(ndr_pull_align(ndr, 4));
				NDR_CHECK(ndr_pull_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_pull_spoolss_DriverInfo5(ndr, NDR_SCALARS, &r->info5));
			break; }

			case 6: {
				NDR_CHECK(ndr_pull_align(ndr, 8));
				NDR_CHECK(ndr_pull_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_pull_spoolss_DriverInfo6(ndr, NDR_SCALARS, &r->info6));
			break; }

			case 8: {
				NDR_CHECK(ndr_pull_align(ndr, 8));
				NDR_CHECK(ndr_pull_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_pull_spoolss_DriverInfo8(ndr, NDR_SCALARS, &r->info8));
			break; }

			case 101: {
				NDR_CHECK(ndr_pull_align(ndr, 8));
				NDR_CHECK(ndr_pull_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_pull_spoolss_DriverInfo101(ndr, NDR_SCALARS, &r->info101));
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_setup_relative_base_offset2(ndr, r));
		switch (level) {
			case 1:
				NDR_CHECK(ndr_pull_spoolss_DriverInfo1(ndr, NDR_BUFFERS, &r->info1));
			break;

			case 2:
				NDR_CHECK(ndr_pull_spoolss_DriverInfo2(ndr, NDR_BUFFERS, &r->info2));
			break;

			case 3:
				NDR_CHECK(ndr_pull_spoolss_DriverInfo3(ndr, NDR_BUFFERS, &r->info3));
			break;

			case 4:
				NDR_CHECK(ndr_pull_spoolss_DriverInfo4(ndr, NDR_BUFFERS, &r->info4));
			break;

			case 5:
				NDR_CHECK(ndr_pull_spoolss_DriverInfo5(ndr, NDR_BUFFERS, &r->info5));
			break;

			case 6:
				NDR_CHECK(ndr_pull_spoolss_DriverInfo6(ndr, NDR_BUFFERS, &r->info6));
			break;

			case 8:
				NDR_CHECK(ndr_pull_spoolss_DriverInfo8(ndr, NDR_BUFFERS, &r->info8));
			break;

			case 101:
				NDR_CHECK(ndr_pull_spoolss_DriverInfo101(ndr, NDR_BUFFERS, &r->info101));
			break;

			default:
			break;

		}
	}
	ndr_pull_restore_relative_base_offset(ndr, _save_relative_base_offset);
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_DriverInfo(struct ndr_print *ndr, const char *name, const union spoolss_DriverInfo *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "spoolss_DriverInfo");
	switch (level) {
		case 1:
			ndr_print_spoolss_DriverInfo1(ndr, "info1", &r->info1);
		break;

		case 2:
			ndr_print_spoolss_DriverInfo2(ndr, "info2", &r->info2);
		break;

		case 3:
			ndr_print_spoolss_DriverInfo3(ndr, "info3", &r->info3);
		break;

		case 4:
			ndr_print_spoolss_DriverInfo4(ndr, "info4", &r->info4);
		break;

		case 5:
			ndr_print_spoolss_DriverInfo5(ndr, "info5", &r->info5);
		break;

		case 6:
			ndr_print_spoolss_DriverInfo6(ndr, "info6", &r->info6);
		break;

		case 8:
			ndr_print_spoolss_DriverInfo8(ndr, "info8", &r->info8);
		break;

		case 101:
			ndr_print_spoolss_DriverInfo101(ndr, "info101", &r->info101);
		break;

		default:
		break;

	}
}

_PUBLIC_ size_t ndr_size_spoolss_DriverInfo(const union spoolss_DriverInfo *r, uint32_t level, struct smb_iconv_convenience *ic, int flags)
{
	return ndr_size_union(r, flags, level, (ndr_push_flags_fn_t)ndr_push_spoolss_DriverInfo, ic);
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_DriverDirectoryInfo1(struct ndr_push *ndr, int ndr_flags, const struct spoolss_DriverDirectoryInfo1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->directory_name));
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_DriverDirectoryInfo1(struct ndr_pull *ndr, int ndr_flags, struct spoolss_DriverDirectoryInfo1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->directory_name));
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_DriverDirectoryInfo1(struct ndr_print *ndr, const char *name, const struct spoolss_DriverDirectoryInfo1 *r)
{
	ndr_print_struct(ndr, name, "spoolss_DriverDirectoryInfo1");
	ndr->depth++;
	ndr_print_string(ndr, "directory_name", r->directory_name);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_spoolss_DriverDirectoryInfo1(const struct spoolss_DriverDirectoryInfo1 *r, struct smb_iconv_convenience *ic, int flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_spoolss_DriverDirectoryInfo1, ic);
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_DriverDirectoryInfo(struct ndr_push *ndr, int ndr_flags, const union spoolss_DriverDirectoryInfo *r)
{
	uint32_t _save_relative_base_offset = ndr_push_get_relative_base_offset(ndr);
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_align(ndr, 4));
				NDR_CHECK(ndr_push_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_push_spoolss_DriverDirectoryInfo1(ndr, NDR_SCALARS, &r->info1));
			break; }

			default: {
				NDR_CHECK(ndr_push_align(ndr, 4));
				NDR_CHECK(ndr_push_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_push_spoolss_DriverDirectoryInfo1(ndr, NDR_SCALARS, &r->info1));
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_setup_relative_base_offset2(ndr, r));
		switch (level) {
			case 1:
			break;

			default:
			break;

		}
	}
	ndr_push_restore_relative_base_offset(ndr, _save_relative_base_offset);
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_DriverDirectoryInfo(struct ndr_pull *ndr, int ndr_flags, union spoolss_DriverDirectoryInfo *r)
{
	uint32_t _save_relative_base_offset = ndr_pull_get_relative_base_offset(ndr);
	int level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_align(ndr, 4));
				NDR_CHECK(ndr_pull_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_pull_spoolss_DriverDirectoryInfo1(ndr, NDR_SCALARS, &r->info1));
			break; }

			default: {
				NDR_CHECK(ndr_pull_align(ndr, 4));
				NDR_CHECK(ndr_pull_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_pull_spoolss_DriverDirectoryInfo1(ndr, NDR_SCALARS, &r->info1));
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_setup_relative_base_offset2(ndr, r));
		switch (level) {
			case 1:
			break;

			default:
			break;

		}
	}
	ndr_pull_restore_relative_base_offset(ndr, _save_relative_base_offset);
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_DriverDirectoryInfo(struct ndr_print *ndr, const char *name, const union spoolss_DriverDirectoryInfo *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "spoolss_DriverDirectoryInfo");
	switch (level) {
		case 1:
			ndr_print_spoolss_DriverDirectoryInfo1(ndr, "info1", &r->info1);
		break;

		default:
			ndr_print_spoolss_DriverDirectoryInfo1(ndr, "info1", &r->info1);
		break;

	}
}

_PUBLIC_ size_t ndr_size_spoolss_DriverDirectoryInfo(const union spoolss_DriverDirectoryInfo *r, uint32_t level, struct smb_iconv_convenience *ic, int flags)
{
	return ndr_size_union(r, flags, level, (ndr_push_flags_fn_t)ndr_push_spoolss_DriverDirectoryInfo, ic);
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_PrintProcessorInfo1(struct ndr_push *ndr, int ndr_flags, const struct spoolss_PrintProcessorInfo1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->print_processor_name));
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->print_processor_name) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->print_processor_name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->print_processor_name));
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_PrintProcessorInfo1(struct ndr_pull *ndr, int ndr_flags, struct spoolss_PrintProcessorInfo1 *r)
{
	uint32_t _ptr_print_processor_name;
	TALLOC_CTX *_mem_save_print_processor_name_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_print_processor_name));
			if (_ptr_print_processor_name) {
				NDR_PULL_ALLOC(ndr, r->print_processor_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->print_processor_name, _ptr_print_processor_name));
			} else {
				r->print_processor_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->print_processor_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->print_processor_name));
				_mem_save_print_processor_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->print_processor_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->print_processor_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_print_processor_name_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_PrintProcessorInfo1(struct ndr_print *ndr, const char *name, const struct spoolss_PrintProcessorInfo1 *r)
{
	ndr_print_struct(ndr, name, "spoolss_PrintProcessorInfo1");
	ndr->depth++;
	ndr_print_ptr(ndr, "print_processor_name", r->print_processor_name);
	ndr->depth++;
	if (r->print_processor_name) {
		ndr_print_string(ndr, "print_processor_name", r->print_processor_name);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_spoolss_PrintProcessorInfo1(const struct spoolss_PrintProcessorInfo1 *r, struct smb_iconv_convenience *ic, int flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_spoolss_PrintProcessorInfo1, ic);
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_PrintProcessorInfo(struct ndr_push *ndr, int ndr_flags, const union spoolss_PrintProcessorInfo *r)
{
	uint32_t _save_relative_base_offset = ndr_push_get_relative_base_offset(ndr);
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_align(ndr, 4));
				NDR_CHECK(ndr_push_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_push_spoolss_PrintProcessorInfo1(ndr, NDR_SCALARS, &r->info1));
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_setup_relative_base_offset2(ndr, r));
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_spoolss_PrintProcessorInfo1(ndr, NDR_BUFFERS, &r->info1));
			break;

			default:
			break;

		}
	}
	ndr_push_restore_relative_base_offset(ndr, _save_relative_base_offset);
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_PrintProcessorInfo(struct ndr_pull *ndr, int ndr_flags, union spoolss_PrintProcessorInfo *r)
{
	uint32_t _save_relative_base_offset = ndr_pull_get_relative_base_offset(ndr);
	int level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_align(ndr, 4));
				NDR_CHECK(ndr_pull_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_pull_spoolss_PrintProcessorInfo1(ndr, NDR_SCALARS, &r->info1));
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_setup_relative_base_offset2(ndr, r));
		switch (level) {
			case 1:
				NDR_CHECK(ndr_pull_spoolss_PrintProcessorInfo1(ndr, NDR_BUFFERS, &r->info1));
			break;

			default:
			break;

		}
	}
	ndr_pull_restore_relative_base_offset(ndr, _save_relative_base_offset);
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_PrintProcessorInfo(struct ndr_print *ndr, const char *name, const union spoolss_PrintProcessorInfo *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "spoolss_PrintProcessorInfo");
	switch (level) {
		case 1:
			ndr_print_spoolss_PrintProcessorInfo1(ndr, "info1", &r->info1);
		break;

		default:
		break;

	}
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_PrintProcessorDirectoryInfo1(struct ndr_push *ndr, int ndr_flags, const struct spoolss_PrintProcessorDirectoryInfo1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->directory_name));
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_PrintProcessorDirectoryInfo1(struct ndr_pull *ndr, int ndr_flags, struct spoolss_PrintProcessorDirectoryInfo1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->directory_name));
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_PrintProcessorDirectoryInfo1(struct ndr_print *ndr, const char *name, const struct spoolss_PrintProcessorDirectoryInfo1 *r)
{
	ndr_print_struct(ndr, name, "spoolss_PrintProcessorDirectoryInfo1");
	ndr->depth++;
	ndr_print_string(ndr, "directory_name", r->directory_name);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_spoolss_PrintProcessorDirectoryInfo1(const struct spoolss_PrintProcessorDirectoryInfo1 *r, struct smb_iconv_convenience *ic, int flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_spoolss_PrintProcessorDirectoryInfo1, ic);
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_PrintProcessorDirectoryInfo(struct ndr_push *ndr, int ndr_flags, const union spoolss_PrintProcessorDirectoryInfo *r)
{
	uint32_t _save_relative_base_offset = ndr_push_get_relative_base_offset(ndr);
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_align(ndr, 4));
				NDR_CHECK(ndr_push_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_push_spoolss_PrintProcessorDirectoryInfo1(ndr, NDR_SCALARS, &r->info1));
			break; }

			default: {
				NDR_CHECK(ndr_push_align(ndr, 4));
				NDR_CHECK(ndr_push_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_push_spoolss_PrintProcessorDirectoryInfo1(ndr, NDR_SCALARS, &r->info1));
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_setup_relative_base_offset2(ndr, r));
		switch (level) {
			case 1:
			break;

			default:
			break;

		}
	}
	ndr_push_restore_relative_base_offset(ndr, _save_relative_base_offset);
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_PrintProcessorDirectoryInfo(struct ndr_pull *ndr, int ndr_flags, union spoolss_PrintProcessorDirectoryInfo *r)
{
	uint32_t _save_relative_base_offset = ndr_pull_get_relative_base_offset(ndr);
	int level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_align(ndr, 4));
				NDR_CHECK(ndr_pull_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_pull_spoolss_PrintProcessorDirectoryInfo1(ndr, NDR_SCALARS, &r->info1));
			break; }

			default: {
				NDR_CHECK(ndr_pull_align(ndr, 4));
				NDR_CHECK(ndr_pull_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_pull_spoolss_PrintProcessorDirectoryInfo1(ndr, NDR_SCALARS, &r->info1));
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_setup_relative_base_offset2(ndr, r));
		switch (level) {
			case 1:
			break;

			default:
			break;

		}
	}
	ndr_pull_restore_relative_base_offset(ndr, _save_relative_base_offset);
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_PrintProcessorDirectoryInfo(struct ndr_print *ndr, const char *name, const union spoolss_PrintProcessorDirectoryInfo *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "spoolss_PrintProcessorDirectoryInfo");
	switch (level) {
		case 1:
			ndr_print_spoolss_PrintProcessorDirectoryInfo1(ndr, "info1", &r->info1);
		break;

		default:
			ndr_print_spoolss_PrintProcessorDirectoryInfo1(ndr, "info1", &r->info1);
		break;

	}
}

_PUBLIC_ size_t ndr_size_spoolss_PrintProcessorDirectoryInfo(const union spoolss_PrintProcessorDirectoryInfo *r, uint32_t level, struct smb_iconv_convenience *ic, int flags)
{
	return ndr_size_union(r, flags, level, (ndr_push_flags_fn_t)ndr_push_spoolss_PrintProcessorDirectoryInfo, ic);
}

static enum ndr_err_code ndr_push_spoolss_DocumentInfo1(struct ndr_push *ndr, int ndr_flags, const struct spoolss_DocumentInfo1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->document_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->output_file));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->datatype));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->document_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->document_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->document_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->document_name, ndr_charset_length(r->document_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->output_file) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->output_file, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->output_file, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->output_file, ndr_charset_length(r->output_file, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->datatype) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->datatype, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->datatype, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->datatype, ndr_charset_length(r->datatype, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_DocumentInfo1(struct ndr_pull *ndr, int ndr_flags, struct spoolss_DocumentInfo1 *r)
{
	uint32_t _ptr_document_name;
	TALLOC_CTX *_mem_save_document_name_0;
	uint32_t _ptr_output_file;
	TALLOC_CTX *_mem_save_output_file_0;
	uint32_t _ptr_datatype;
	TALLOC_CTX *_mem_save_datatype_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_document_name));
		if (_ptr_document_name) {
			NDR_PULL_ALLOC(ndr, r->document_name);
		} else {
			r->document_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_output_file));
		if (_ptr_output_file) {
			NDR_PULL_ALLOC(ndr, r->output_file);
		} else {
			r->output_file = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_datatype));
		if (_ptr_datatype) {
			NDR_PULL_ALLOC(ndr, r->datatype);
		} else {
			r->datatype = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->document_name) {
			_mem_save_document_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->document_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->document_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->document_name));
			if (ndr_get_array_length(ndr, &r->document_name) > ndr_get_array_size(ndr, &r->document_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->document_name), ndr_get_array_length(ndr, &r->document_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->document_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->document_name, ndr_get_array_length(ndr, &r->document_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_document_name_0, 0);
		}
		if (r->output_file) {
			_mem_save_output_file_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->output_file, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->output_file));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->output_file));
			if (ndr_get_array_length(ndr, &r->output_file) > ndr_get_array_size(ndr, &r->output_file)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->output_file), ndr_get_array_length(ndr, &r->output_file));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->output_file), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->output_file, ndr_get_array_length(ndr, &r->output_file), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_output_file_0, 0);
		}
		if (r->datatype) {
			_mem_save_datatype_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->datatype, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->datatype));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->datatype));
			if (ndr_get_array_length(ndr, &r->datatype) > ndr_get_array_size(ndr, &r->datatype)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->datatype), ndr_get_array_length(ndr, &r->datatype));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->datatype), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->datatype, ndr_get_array_length(ndr, &r->datatype), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_datatype_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_DocumentInfo1(struct ndr_print *ndr, const char *name, const struct spoolss_DocumentInfo1 *r)
{
	ndr_print_struct(ndr, name, "spoolss_DocumentInfo1");
	ndr->depth++;
	ndr_print_ptr(ndr, "document_name", r->document_name);
	ndr->depth++;
	if (r->document_name) {
		ndr_print_string(ndr, "document_name", r->document_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "output_file", r->output_file);
	ndr->depth++;
	if (r->output_file) {
		ndr_print_string(ndr, "output_file", r->output_file);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "datatype", r->datatype);
	ndr->depth++;
	if (r->datatype) {
		ndr_print_string(ndr, "datatype", r->datatype);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_DocumentInfo(struct ndr_push *ndr, int ndr_flags, const union spoolss_DocumentInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1));
			break; }

			case 2: {
			break; }

			case 3: {
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 1:
				if (r->info1) {
					NDR_CHECK(ndr_push_spoolss_DocumentInfo1(ndr, NDR_SCALARS|NDR_BUFFERS, r->info1));
				}
			break;

			case 2:
			break;

			case 3:
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_DocumentInfo(struct ndr_pull *ndr, int ndr_flags, union spoolss_DocumentInfo *r)
{
	int level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_info1_0;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r", _level);
		}
		switch (level) {
			case 1: {
				uint32_t _ptr_info1;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1));
				if (_ptr_info1) {
					NDR_PULL_ALLOC(ndr, r->info1);
				} else {
					r->info1 = NULL;
				}
			break; }

			case 2: {
			break; }

			case 3: {
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
				if (r->info1) {
					_mem_save_info1_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1, 0);
					NDR_CHECK(ndr_pull_spoolss_DocumentInfo1(ndr, NDR_SCALARS|NDR_BUFFERS, r->info1));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1_0, 0);
				}
			break;

			case 2:
			break;

			case 3:
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_DocumentInfo(struct ndr_print *ndr, const char *name, const union spoolss_DocumentInfo *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "spoolss_DocumentInfo");
	switch (level) {
		case 1:
			ndr_print_ptr(ndr, "info1", r->info1);
			ndr->depth++;
			if (r->info1) {
				ndr_print_spoolss_DocumentInfo1(ndr, "info1", r->info1);
			}
			ndr->depth--;
		break;

		case 2:
		break;

		case 3:
		break;

		default:
		break;

	}
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_OSVersion(struct ndr_push *ndr, int ndr_flags, const struct spoolss_OSVersion *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_size_spoolss_OSVersion(r, ndr->iconv_convenience, ndr->flags)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->major));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->minor));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->build));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 2));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			{
				struct ndr_push *_ndr_extra_string;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_extra_string, 0, 256));
				NDR_CHECK(ndr_push_string(_ndr_extra_string, NDR_SCALARS, r->extra_string));
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_extra_string, 0, 256));
			}
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_OSVersion(struct ndr_pull *ndr, int ndr_flags, struct spoolss_OSVersion *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->_ndr_size));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->major));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->minor));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->build));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			{
				struct ndr_pull *_ndr_extra_string;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_extra_string, 0, 256));
				NDR_CHECK(ndr_pull_string(_ndr_extra_string, NDR_SCALARS, &r->extra_string));
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_extra_string, 0, 256));
			}
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_OSVersion(struct ndr_print *ndr, const char *name, const struct spoolss_OSVersion *r)
{
	ndr_print_struct(ndr, name, "spoolss_OSVersion");
	ndr->depth++;
	ndr_print_uint32(ndr, "_ndr_size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_spoolss_OSVersion(r, ndr->iconv_convenience, ndr->flags):r->_ndr_size);
	ndr_print_uint32(ndr, "major", r->major);
	ndr_print_uint32(ndr, "minor", r->minor);
	ndr_print_uint32(ndr, "build", r->build);
	ndr_print_uint32(ndr, "unknown", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?2:r->unknown);
	ndr_print_string(ndr, "extra_string", r->extra_string);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_spoolss_OSVersion(const struct spoolss_OSVersion *r, struct smb_iconv_convenience *ic, int flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_spoolss_OSVersion, ic);
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_OSVersionEx(struct ndr_push *ndr, int ndr_flags, const struct spoolss_OSVersionEx *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_size_spoolss_OSVersionEx(r, ndr->iconv_convenience, ndr->flags)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->major));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->minor));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->build));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 2));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			{
				struct ndr_push *_ndr_extra_string;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_extra_string, 0, 256));
				NDR_CHECK(ndr_push_string(_ndr_extra_string, NDR_SCALARS, r->extra_string));
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_extra_string, 0, 256));
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown2));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown3));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_OSVersionEx(struct ndr_pull *ndr, int ndr_flags, struct spoolss_OSVersionEx *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->_ndr_size));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->major));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->minor));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->build));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown1));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			{
				struct ndr_pull *_ndr_extra_string;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_extra_string, 0, 256));
				NDR_CHECK(ndr_pull_string(_ndr_extra_string, NDR_SCALARS, &r->extra_string));
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_extra_string, 0, 256));
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown2));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown3));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_OSVersionEx(struct ndr_print *ndr, const char *name, const struct spoolss_OSVersionEx *r)
{
	ndr_print_struct(ndr, name, "spoolss_OSVersionEx");
	ndr->depth++;
	ndr_print_uint32(ndr, "_ndr_size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_spoolss_OSVersionEx(r, ndr->iconv_convenience, ndr->flags):r->_ndr_size);
	ndr_print_uint32(ndr, "major", r->major);
	ndr_print_uint32(ndr, "minor", r->minor);
	ndr_print_uint32(ndr, "build", r->build);
	ndr_print_uint32(ndr, "unknown1", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?2:r->unknown1);
	ndr_print_string(ndr, "extra_string", r->extra_string);
	ndr_print_uint32(ndr, "unknown2", r->unknown2);
	ndr_print_uint32(ndr, "unknown3", r->unknown3);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_spoolss_OSVersionEx(const struct spoolss_OSVersionEx *r, struct smb_iconv_convenience *ic, int flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_spoolss_OSVersionEx, ic);
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_PrinterData(struct ndr_push *ndr, int ndr_flags, const union spoolss_PrinterData *r)
{
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case REG_NONE: {
			break; }

			case REG_SZ: {
				{
					uint32_t _flags_save_string = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
					NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->string));
					ndr->flags = _flags_save_string;
				}
			break; }

			case REG_BINARY: {
				{
					uint32_t _flags_save_DATA_BLOB = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
					NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->binary));
					ndr->flags = _flags_save_DATA_BLOB;
				}
			break; }

			case REG_DWORD: {
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->value));
			break; }

			case REG_MULTI_SZ: {
				{
					uint32_t _flags_save_string_array = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
					NDR_CHECK(ndr_push_string_array(ndr, NDR_SCALARS, r->string_array));
					ndr->flags = _flags_save_string_array;
				}
			break; }

			default: {
				{
					uint32_t _flags_save_DATA_BLOB = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
					NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->data));
					ndr->flags = _flags_save_DATA_BLOB;
				}
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case REG_NONE:
			break;

			case REG_SZ:
			break;

			case REG_BINARY:
			break;

			case REG_DWORD:
			break;

			case REG_MULTI_SZ:
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_PrinterData(struct ndr_pull *ndr, int ndr_flags, union spoolss_PrinterData *r)
{
	int level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		switch (level) {
			case REG_NONE: {
			break; }

			case REG_SZ: {
				{
					uint32_t _flags_save_string = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
					NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->string));
					ndr->flags = _flags_save_string;
				}
			break; }

			case REG_BINARY: {
				{
					uint32_t _flags_save_DATA_BLOB = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
					NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->binary));
					ndr->flags = _flags_save_DATA_BLOB;
				}
			break; }

			case REG_DWORD: {
				NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->value));
			break; }

			case REG_MULTI_SZ: {
				{
					uint32_t _flags_save_string_array = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
					NDR_CHECK(ndr_pull_string_array(ndr, NDR_SCALARS, &r->string_array));
					ndr->flags = _flags_save_string_array;
				}
			break; }

			default: {
				{
					uint32_t _flags_save_DATA_BLOB = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
					NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->data));
					ndr->flags = _flags_save_DATA_BLOB;
				}
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case REG_NONE:
			break;

			case REG_SZ:
			break;

			case REG_BINARY:
			break;

			case REG_DWORD:
			break;

			case REG_MULTI_SZ:
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_PrinterData(struct ndr_print *ndr, const char *name, const union spoolss_PrinterData *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "spoolss_PrinterData");
	switch (level) {
		case REG_NONE:
		break;

		case REG_SZ:
			ndr_print_string(ndr, "string", r->string);
		break;

		case REG_BINARY:
			ndr_print_DATA_BLOB(ndr, "binary", r->binary);
		break;

		case REG_DWORD:
			ndr_print_uint32(ndr, "value", r->value);
		break;

		case REG_MULTI_SZ:
			ndr_print_string_array(ndr, "string_array", r->string_array);
		break;

		default:
			ndr_print_DATA_BLOB(ndr, "data", r->data);
		break;

	}
}

_PUBLIC_ size_t ndr_size_spoolss_PrinterData(const union spoolss_PrinterData *r, uint32_t level, struct smb_iconv_convenience *ic, int flags)
{
	return ndr_size_union(r, flags, level, (ndr_push_flags_fn_t)ndr_push_spoolss_PrinterData, ic);
}

static enum ndr_err_code ndr_push_spoolss_FormFlags(struct ndr_push *ndr, int ndr_flags, enum spoolss_FormFlags r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_FormFlags(struct ndr_pull *ndr, int ndr_flags, enum spoolss_FormFlags *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_FormFlags(struct ndr_print *ndr, const char *name, enum spoolss_FormFlags r)
{
	const char *val = NULL;

	switch (r) {
		case SPOOLSS_FORM_USER: val = "SPOOLSS_FORM_USER"; break;
		case SPOOLSS_FORM_BUILTIN: val = "SPOOLSS_FORM_BUILTIN"; break;
		case SPOOLSS_FORM_PRINTER: val = "SPOOLSS_FORM_PRINTER"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_spoolss_FormSize(struct ndr_push *ndr, int ndr_flags, const struct spoolss_FormSize *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->width));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->height));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_FormSize(struct ndr_pull *ndr, int ndr_flags, struct spoolss_FormSize *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->width));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->height));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_FormSize(struct ndr_print *ndr, const char *name, const struct spoolss_FormSize *r)
{
	ndr_print_struct(ndr, name, "spoolss_FormSize");
	ndr->depth++;
	ndr_print_uint32(ndr, "width", r->width);
	ndr_print_uint32(ndr, "height", r->height);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_FormArea(struct ndr_push *ndr, int ndr_flags, const struct spoolss_FormArea *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->left));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->top));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->right));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->bottom));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_FormArea(struct ndr_pull *ndr, int ndr_flags, struct spoolss_FormArea *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->left));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->top));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->right));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->bottom));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_FormArea(struct ndr_print *ndr, const char *name, const struct spoolss_FormArea *r)
{
	ndr_print_struct(ndr, name, "spoolss_FormArea");
	ndr->depth++;
	ndr_print_uint32(ndr, "left", r->left);
	ndr_print_uint32(ndr, "top", r->top);
	ndr_print_uint32(ndr, "right", r->right);
	ndr_print_uint32(ndr, "bottom", r->bottom);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_FormInfo1(struct ndr_push *ndr, int ndr_flags, const struct spoolss_FormInfo1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_spoolss_FormFlags(ndr, NDR_SCALARS, r->flags));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->form_name));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_spoolss_FormSize(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_push_spoolss_FormArea(ndr, NDR_SCALARS, &r->area));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->form_name) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->form_name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->form_name));
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_FormInfo1(struct ndr_pull *ndr, int ndr_flags, struct spoolss_FormInfo1 *r)
{
	uint32_t _ptr_form_name;
	TALLOC_CTX *_mem_save_form_name_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_spoolss_FormFlags(ndr, NDR_SCALARS, &r->flags));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_form_name));
			if (_ptr_form_name) {
				NDR_PULL_ALLOC(ndr, r->form_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->form_name, _ptr_form_name));
			} else {
				r->form_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_spoolss_FormSize(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_pull_spoolss_FormArea(ndr, NDR_SCALARS, &r->area));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->form_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->form_name));
				_mem_save_form_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->form_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->form_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_form_name_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_FormInfo1(struct ndr_print *ndr, const char *name, const struct spoolss_FormInfo1 *r)
{
	ndr_print_struct(ndr, name, "spoolss_FormInfo1");
	ndr->depth++;
	ndr_print_spoolss_FormFlags(ndr, "flags", r->flags);
	ndr_print_ptr(ndr, "form_name", r->form_name);
	ndr->depth++;
	if (r->form_name) {
		ndr_print_string(ndr, "form_name", r->form_name);
	}
	ndr->depth--;
	ndr_print_spoolss_FormSize(ndr, "size", &r->size);
	ndr_print_spoolss_FormArea(ndr, "area", &r->area);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_spoolss_FormInfo1(const struct spoolss_FormInfo1 *r, struct smb_iconv_convenience *ic, int flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_spoolss_FormInfo1, ic);
}

static enum ndr_err_code ndr_push_spoolss_FormStringType(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_FormStringType(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_FormStringType(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SPOOLSS_FORM_STRING_TYPE_NONE", SPOOLSS_FORM_STRING_TYPE_NONE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SPOOLSS_FORM_STRING_TYPE_MUI_DLL", SPOOLSS_FORM_STRING_TYPE_MUI_DLL, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SPOOLSS_FORM_STRING_TYPE_LANG_PAIR", SPOOLSS_FORM_STRING_TYPE_LANG_PAIR, r);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_FormInfo2(struct ndr_push *ndr, int ndr_flags, const struct spoolss_FormInfo2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_spoolss_FormFlags(ndr, NDR_SCALARS, r->flags));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->form_name));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_spoolss_FormSize(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_push_spoolss_FormArea(ndr, NDR_SCALARS, &r->area));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->keyword));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_spoolss_FormStringType(ndr, NDR_SCALARS, r->string_type));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->mui_dll));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->ressource_id));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->display_name));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->lang_id));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->form_name) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->form_name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->form_name));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->keyword) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->keyword));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->keyword));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->mui_dll) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->mui_dll));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->mui_dll));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->display_name) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->display_name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->display_name));
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_FormInfo2(struct ndr_pull *ndr, int ndr_flags, struct spoolss_FormInfo2 *r)
{
	uint32_t _ptr_form_name;
	TALLOC_CTX *_mem_save_form_name_0;
	uint32_t _ptr_keyword;
	TALLOC_CTX *_mem_save_keyword_0;
	uint32_t _ptr_mui_dll;
	TALLOC_CTX *_mem_save_mui_dll_0;
	uint32_t _ptr_display_name;
	TALLOC_CTX *_mem_save_display_name_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_spoolss_FormFlags(ndr, NDR_SCALARS, &r->flags));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_form_name));
			if (_ptr_form_name) {
				NDR_PULL_ALLOC(ndr, r->form_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->form_name, _ptr_form_name));
			} else {
				r->form_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_spoolss_FormSize(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_pull_spoolss_FormArea(ndr, NDR_SCALARS, &r->area));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_keyword));
			if (_ptr_keyword) {
				NDR_PULL_ALLOC(ndr, r->keyword);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->keyword, _ptr_keyword));
			} else {
				r->keyword = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_spoolss_FormStringType(ndr, NDR_SCALARS, &r->string_type));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_mui_dll));
			if (_ptr_mui_dll) {
				NDR_PULL_ALLOC(ndr, r->mui_dll);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->mui_dll, _ptr_mui_dll));
			} else {
				r->mui_dll = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->ressource_id));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_display_name));
			if (_ptr_display_name) {
				NDR_PULL_ALLOC(ndr, r->display_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->display_name, _ptr_display_name));
			} else {
				r->display_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->lang_id));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->form_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->form_name));
				_mem_save_form_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->form_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->form_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_form_name_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->keyword) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->keyword));
				_mem_save_keyword_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->keyword, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->keyword));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_keyword_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->mui_dll) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->mui_dll));
				_mem_save_mui_dll_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->mui_dll, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->mui_dll));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_mui_dll_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->display_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->display_name));
				_mem_save_display_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->display_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->display_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_display_name_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_FormInfo2(struct ndr_print *ndr, const char *name, const struct spoolss_FormInfo2 *r)
{
	ndr_print_struct(ndr, name, "spoolss_FormInfo2");
	ndr->depth++;
	ndr_print_spoolss_FormFlags(ndr, "flags", r->flags);
	ndr_print_ptr(ndr, "form_name", r->form_name);
	ndr->depth++;
	if (r->form_name) {
		ndr_print_string(ndr, "form_name", r->form_name);
	}
	ndr->depth--;
	ndr_print_spoolss_FormSize(ndr, "size", &r->size);
	ndr_print_spoolss_FormArea(ndr, "area", &r->area);
	ndr_print_ptr(ndr, "keyword", r->keyword);
	ndr->depth++;
	if (r->keyword) {
		ndr_print_string(ndr, "keyword", r->keyword);
	}
	ndr->depth--;
	ndr_print_spoolss_FormStringType(ndr, "string_type", r->string_type);
	ndr_print_ptr(ndr, "mui_dll", r->mui_dll);
	ndr->depth++;
	if (r->mui_dll) {
		ndr_print_string(ndr, "mui_dll", r->mui_dll);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "ressource_id", r->ressource_id);
	ndr_print_ptr(ndr, "display_name", r->display_name);
	ndr->depth++;
	if (r->display_name) {
		ndr_print_string(ndr, "display_name", r->display_name);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "lang_id", r->lang_id);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_spoolss_FormInfo2(const struct spoolss_FormInfo2 *r, struct smb_iconv_convenience *ic, int flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_spoolss_FormInfo2, ic);
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_FormInfo(struct ndr_push *ndr, int ndr_flags, const union spoolss_FormInfo *r)
{
	uint32_t _save_relative_base_offset = ndr_push_get_relative_base_offset(ndr);
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_align(ndr, 4));
				NDR_CHECK(ndr_push_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_push_spoolss_FormInfo1(ndr, NDR_SCALARS, &r->info1));
			break; }

			case 2: {
				NDR_CHECK(ndr_push_align(ndr, 4));
				NDR_CHECK(ndr_push_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_push_spoolss_FormInfo2(ndr, NDR_SCALARS, &r->info2));
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_setup_relative_base_offset2(ndr, r));
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_spoolss_FormInfo1(ndr, NDR_BUFFERS, &r->info1));
			break;

			case 2:
				NDR_CHECK(ndr_push_spoolss_FormInfo2(ndr, NDR_BUFFERS, &r->info2));
			break;

			default:
			break;

		}
	}
	ndr_push_restore_relative_base_offset(ndr, _save_relative_base_offset);
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_FormInfo(struct ndr_pull *ndr, int ndr_flags, union spoolss_FormInfo *r)
{
	uint32_t _save_relative_base_offset = ndr_pull_get_relative_base_offset(ndr);
	int level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_align(ndr, 4));
				NDR_CHECK(ndr_pull_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_pull_spoolss_FormInfo1(ndr, NDR_SCALARS, &r->info1));
			break; }

			case 2: {
				NDR_CHECK(ndr_pull_align(ndr, 4));
				NDR_CHECK(ndr_pull_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_pull_spoolss_FormInfo2(ndr, NDR_SCALARS, &r->info2));
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_setup_relative_base_offset2(ndr, r));
		switch (level) {
			case 1:
				NDR_CHECK(ndr_pull_spoolss_FormInfo1(ndr, NDR_BUFFERS, &r->info1));
			break;

			case 2:
				NDR_CHECK(ndr_pull_spoolss_FormInfo2(ndr, NDR_BUFFERS, &r->info2));
			break;

			default:
			break;

		}
	}
	ndr_pull_restore_relative_base_offset(ndr, _save_relative_base_offset);
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_FormInfo(struct ndr_print *ndr, const char *name, const union spoolss_FormInfo *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "spoolss_FormInfo");
	switch (level) {
		case 1:
			ndr_print_spoolss_FormInfo1(ndr, "info1", &r->info1);
		break;

		case 2:
			ndr_print_spoolss_FormInfo2(ndr, "info2", &r->info2);
		break;

		default:
		break;

	}
}

_PUBLIC_ size_t ndr_size_spoolss_FormInfo(const union spoolss_FormInfo *r, uint32_t level, struct smb_iconv_convenience *ic, int flags)
{
	return ndr_size_union(r, flags, level, (ndr_push_flags_fn_t)ndr_push_spoolss_FormInfo, ic);
}

static enum ndr_err_code ndr_push_spoolss_AddFormInfo1(struct ndr_push *ndr, int ndr_flags, const struct spoolss_AddFormInfo1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_spoolss_FormFlags(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->form_name));
		NDR_CHECK(ndr_push_spoolss_FormSize(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_push_spoolss_FormArea(ndr, NDR_SCALARS, &r->area));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->form_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->form_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->form_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->form_name, ndr_charset_length(r->form_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_AddFormInfo1(struct ndr_pull *ndr, int ndr_flags, struct spoolss_AddFormInfo1 *r)
{
	uint32_t _ptr_form_name;
	TALLOC_CTX *_mem_save_form_name_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_spoolss_FormFlags(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_form_name));
		if (_ptr_form_name) {
			NDR_PULL_ALLOC(ndr, r->form_name);
		} else {
			r->form_name = NULL;
		}
		NDR_CHECK(ndr_pull_spoolss_FormSize(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_pull_spoolss_FormArea(ndr, NDR_SCALARS, &r->area));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->form_name) {
			_mem_save_form_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->form_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->form_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->form_name));
			if (ndr_get_array_length(ndr, &r->form_name) > ndr_get_array_size(ndr, &r->form_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->form_name), ndr_get_array_length(ndr, &r->form_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->form_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->form_name, ndr_get_array_length(ndr, &r->form_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_form_name_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_AddFormInfo1(struct ndr_print *ndr, const char *name, const struct spoolss_AddFormInfo1 *r)
{
	ndr_print_struct(ndr, name, "spoolss_AddFormInfo1");
	ndr->depth++;
	ndr_print_spoolss_FormFlags(ndr, "flags", r->flags);
	ndr_print_ptr(ndr, "form_name", r->form_name);
	ndr->depth++;
	if (r->form_name) {
		ndr_print_string(ndr, "form_name", r->form_name);
	}
	ndr->depth--;
	ndr_print_spoolss_FormSize(ndr, "size", &r->size);
	ndr_print_spoolss_FormArea(ndr, "area", &r->area);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_AddFormInfo2(struct ndr_push *ndr, int ndr_flags, const struct spoolss_AddFormInfo2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_spoolss_FormFlags(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->form_name));
		NDR_CHECK(ndr_push_spoolss_FormSize(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_push_spoolss_FormArea(ndr, NDR_SCALARS, &r->area));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->keyword));
		NDR_CHECK(ndr_push_spoolss_FormStringType(ndr, NDR_SCALARS, r->string_type));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->mui_dll));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->ressource_id));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->display_name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->lang_id));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->form_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->form_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->form_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->form_name, ndr_charset_length(r->form_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->keyword) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->keyword, CH_DOS)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->keyword, CH_DOS)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->keyword, ndr_charset_length(r->keyword, CH_DOS), sizeof(uint8_t), CH_DOS));
		}
		if (r->mui_dll) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->mui_dll, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->mui_dll, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->mui_dll, ndr_charset_length(r->mui_dll, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->display_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->display_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->display_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->display_name, ndr_charset_length(r->display_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_AddFormInfo2(struct ndr_pull *ndr, int ndr_flags, struct spoolss_AddFormInfo2 *r)
{
	uint32_t _ptr_form_name;
	TALLOC_CTX *_mem_save_form_name_0;
	uint32_t _ptr_keyword;
	TALLOC_CTX *_mem_save_keyword_0;
	uint32_t _ptr_mui_dll;
	TALLOC_CTX *_mem_save_mui_dll_0;
	uint32_t _ptr_display_name;
	TALLOC_CTX *_mem_save_display_name_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_spoolss_FormFlags(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_form_name));
		if (_ptr_form_name) {
			NDR_PULL_ALLOC(ndr, r->form_name);
		} else {
			r->form_name = NULL;
		}
		NDR_CHECK(ndr_pull_spoolss_FormSize(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_pull_spoolss_FormArea(ndr, NDR_SCALARS, &r->area));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_keyword));
		if (_ptr_keyword) {
			NDR_PULL_ALLOC(ndr, r->keyword);
		} else {
			r->keyword = NULL;
		}
		NDR_CHECK(ndr_pull_spoolss_FormStringType(ndr, NDR_SCALARS, &r->string_type));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_mui_dll));
		if (_ptr_mui_dll) {
			NDR_PULL_ALLOC(ndr, r->mui_dll);
		} else {
			r->mui_dll = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->ressource_id));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_display_name));
		if (_ptr_display_name) {
			NDR_PULL_ALLOC(ndr, r->display_name);
		} else {
			r->display_name = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->lang_id));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->form_name) {
			_mem_save_form_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->form_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->form_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->form_name));
			if (ndr_get_array_length(ndr, &r->form_name) > ndr_get_array_size(ndr, &r->form_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->form_name), ndr_get_array_length(ndr, &r->form_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->form_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->form_name, ndr_get_array_length(ndr, &r->form_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_form_name_0, 0);
		}
		if (r->keyword) {
			_mem_save_keyword_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->keyword, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->keyword));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->keyword));
			if (ndr_get_array_length(ndr, &r->keyword) > ndr_get_array_size(ndr, &r->keyword)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->keyword), ndr_get_array_length(ndr, &r->keyword));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->keyword), sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->keyword, ndr_get_array_length(ndr, &r->keyword), sizeof(uint8_t), CH_DOS));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_keyword_0, 0);
		}
		if (r->mui_dll) {
			_mem_save_mui_dll_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->mui_dll, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->mui_dll));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->mui_dll));
			if (ndr_get_array_length(ndr, &r->mui_dll) > ndr_get_array_size(ndr, &r->mui_dll)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->mui_dll), ndr_get_array_length(ndr, &r->mui_dll));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->mui_dll), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->mui_dll, ndr_get_array_length(ndr, &r->mui_dll), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_mui_dll_0, 0);
		}
		if (r->display_name) {
			_mem_save_display_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->display_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->display_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->display_name));
			if (ndr_get_array_length(ndr, &r->display_name) > ndr_get_array_size(ndr, &r->display_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->display_name), ndr_get_array_length(ndr, &r->display_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->display_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->display_name, ndr_get_array_length(ndr, &r->display_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_display_name_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_AddFormInfo2(struct ndr_print *ndr, const char *name, const struct spoolss_AddFormInfo2 *r)
{
	ndr_print_struct(ndr, name, "spoolss_AddFormInfo2");
	ndr->depth++;
	ndr_print_spoolss_FormFlags(ndr, "flags", r->flags);
	ndr_print_ptr(ndr, "form_name", r->form_name);
	ndr->depth++;
	if (r->form_name) {
		ndr_print_string(ndr, "form_name", r->form_name);
	}
	ndr->depth--;
	ndr_print_spoolss_FormSize(ndr, "size", &r->size);
	ndr_print_spoolss_FormArea(ndr, "area", &r->area);
	ndr_print_ptr(ndr, "keyword", r->keyword);
	ndr->depth++;
	if (r->keyword) {
		ndr_print_string(ndr, "keyword", r->keyword);
	}
	ndr->depth--;
	ndr_print_spoolss_FormStringType(ndr, "string_type", r->string_type);
	ndr_print_ptr(ndr, "mui_dll", r->mui_dll);
	ndr->depth++;
	if (r->mui_dll) {
		ndr_print_string(ndr, "mui_dll", r->mui_dll);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "ressource_id", r->ressource_id);
	ndr_print_ptr(ndr, "display_name", r->display_name);
	ndr->depth++;
	if (r->display_name) {
		ndr_print_string(ndr, "display_name", r->display_name);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "lang_id", r->lang_id);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_AddFormInfo(struct ndr_push *ndr, int ndr_flags, const union spoolss_AddFormInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1));
			break; }

			case 2: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info2));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 1:
				if (r->info1) {
					NDR_CHECK(ndr_push_spoolss_AddFormInfo1(ndr, NDR_SCALARS|NDR_BUFFERS, r->info1));
				}
			break;

			case 2:
				if (r->info2) {
					NDR_CHECK(ndr_push_spoolss_AddFormInfo2(ndr, NDR_SCALARS|NDR_BUFFERS, r->info2));
				}
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_AddFormInfo(struct ndr_pull *ndr, int ndr_flags, union spoolss_AddFormInfo *r)
{
	int level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_info1_0;
	TALLOC_CTX *_mem_save_info2_0;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r", _level);
		}
		switch (level) {
			case 1: {
				uint32_t _ptr_info1;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1));
				if (_ptr_info1) {
					NDR_PULL_ALLOC(ndr, r->info1);
				} else {
					r->info1 = NULL;
				}
			break; }

			case 2: {
				uint32_t _ptr_info2;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info2));
				if (_ptr_info2) {
					NDR_PULL_ALLOC(ndr, r->info2);
				} else {
					r->info2 = NULL;
				}
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
				if (r->info1) {
					_mem_save_info1_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1, 0);
					NDR_CHECK(ndr_pull_spoolss_AddFormInfo1(ndr, NDR_SCALARS|NDR_BUFFERS, r->info1));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1_0, 0);
				}
			break;

			case 2:
				if (r->info2) {
					_mem_save_info2_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info2, 0);
					NDR_CHECK(ndr_pull_spoolss_AddFormInfo2(ndr, NDR_SCALARS|NDR_BUFFERS, r->info2));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info2_0, 0);
				}
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_AddFormInfo(struct ndr_print *ndr, const char *name, const union spoolss_AddFormInfo *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "spoolss_AddFormInfo");
	switch (level) {
		case 1:
			ndr_print_ptr(ndr, "info1", r->info1);
			ndr->depth++;
			if (r->info1) {
				ndr_print_spoolss_AddFormInfo1(ndr, "info1", r->info1);
			}
			ndr->depth--;
		break;

		case 2:
			ndr_print_ptr(ndr, "info2", r->info2);
			ndr->depth++;
			if (r->info2) {
				ndr_print_spoolss_AddFormInfo2(ndr, "info2", r->info2);
			}
			ndr->depth--;
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_PortInfo1(struct ndr_push *ndr, int ndr_flags, const struct spoolss_PortInfo1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->port_name));
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->port_name) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->port_name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->port_name));
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_PortInfo1(struct ndr_pull *ndr, int ndr_flags, struct spoolss_PortInfo1 *r)
{
	uint32_t _ptr_port_name;
	TALLOC_CTX *_mem_save_port_name_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_port_name));
			if (_ptr_port_name) {
				NDR_PULL_ALLOC(ndr, r->port_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->port_name, _ptr_port_name));
			} else {
				r->port_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->port_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->port_name));
				_mem_save_port_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->port_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->port_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_port_name_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_PortInfo1(struct ndr_print *ndr, const char *name, const struct spoolss_PortInfo1 *r)
{
	ndr_print_struct(ndr, name, "spoolss_PortInfo1");
	ndr->depth++;
	ndr_print_ptr(ndr, "port_name", r->port_name);
	ndr->depth++;
	if (r->port_name) {
		ndr_print_string(ndr, "port_name", r->port_name);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_spoolss_PortInfo1(const struct spoolss_PortInfo1 *r, struct smb_iconv_convenience *ic, int flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_spoolss_PortInfo1, ic);
}

static enum ndr_err_code ndr_push_spoolss_PortType(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_PortType(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_PortType(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SPOOLSS_PORT_TYPE_WRITE", SPOOLSS_PORT_TYPE_WRITE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SPOOLSS_PORT_TYPE_READ", SPOOLSS_PORT_TYPE_READ, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SPOOLSS_PORT_TYPE_REDIRECTED", SPOOLSS_PORT_TYPE_REDIRECTED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SPOOLSS_PORT_TYPE_NET_ATTACHED", SPOOLSS_PORT_TYPE_NET_ATTACHED, r);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_PortInfo2(struct ndr_push *ndr, int ndr_flags, const struct spoolss_PortInfo2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->port_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->monitor_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->description));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_spoolss_PortType(ndr, NDR_SCALARS, r->port_type));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->reserved));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->port_name) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->port_name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->port_name));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->monitor_name) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->monitor_name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->monitor_name));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->description) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->description));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->description));
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_PortInfo2(struct ndr_pull *ndr, int ndr_flags, struct spoolss_PortInfo2 *r)
{
	uint32_t _ptr_port_name;
	TALLOC_CTX *_mem_save_port_name_0;
	uint32_t _ptr_monitor_name;
	TALLOC_CTX *_mem_save_monitor_name_0;
	uint32_t _ptr_description;
	TALLOC_CTX *_mem_save_description_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_port_name));
			if (_ptr_port_name) {
				NDR_PULL_ALLOC(ndr, r->port_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->port_name, _ptr_port_name));
			} else {
				r->port_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_monitor_name));
			if (_ptr_monitor_name) {
				NDR_PULL_ALLOC(ndr, r->monitor_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->monitor_name, _ptr_monitor_name));
			} else {
				r->monitor_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_description));
			if (_ptr_description) {
				NDR_PULL_ALLOC(ndr, r->description);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->description, _ptr_description));
			} else {
				r->description = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_spoolss_PortType(ndr, NDR_SCALARS, &r->port_type));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->port_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->port_name));
				_mem_save_port_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->port_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->port_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_port_name_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->monitor_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->monitor_name));
				_mem_save_monitor_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->monitor_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->monitor_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_monitor_name_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->description) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->description));
				_mem_save_description_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->description, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->description));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_description_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_PortInfo2(struct ndr_print *ndr, const char *name, const struct spoolss_PortInfo2 *r)
{
	ndr_print_struct(ndr, name, "spoolss_PortInfo2");
	ndr->depth++;
	ndr_print_ptr(ndr, "port_name", r->port_name);
	ndr->depth++;
	if (r->port_name) {
		ndr_print_string(ndr, "port_name", r->port_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "monitor_name", r->monitor_name);
	ndr->depth++;
	if (r->monitor_name) {
		ndr_print_string(ndr, "monitor_name", r->monitor_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "description", r->description);
	ndr->depth++;
	if (r->description) {
		ndr_print_string(ndr, "description", r->description);
	}
	ndr->depth--;
	ndr_print_spoolss_PortType(ndr, "port_type", r->port_type);
	ndr_print_uint32(ndr, "reserved", r->reserved);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_spoolss_PortInfo2(const struct spoolss_PortInfo2 *r, struct smb_iconv_convenience *ic, int flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_spoolss_PortInfo2, ic);
}

static enum ndr_err_code ndr_push_spoolss_PortStatus(struct ndr_push *ndr, int ndr_flags, enum spoolss_PortStatus r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_PortStatus(struct ndr_pull *ndr, int ndr_flags, enum spoolss_PortStatus *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_PortStatus(struct ndr_print *ndr, const char *name, enum spoolss_PortStatus r)
{
	const char *val = NULL;

	switch (r) {
		case PORT_STATUS_CLEAR: val = "PORT_STATUS_CLEAR"; break;
		case PORT_STATUS_OFFLINE: val = "PORT_STATUS_OFFLINE"; break;
		case PORT_STATUS_PAPER_JAM: val = "PORT_STATUS_PAPER_JAM"; break;
		case PORT_STATUS_PAPER_OUT: val = "PORT_STATUS_PAPER_OUT"; break;
		case PORT_STATUS_OUTPUT_BIN_FULL: val = "PORT_STATUS_OUTPUT_BIN_FULL"; break;
		case PORT_STATUS_PAPER_PROBLEM: val = "PORT_STATUS_PAPER_PROBLEM"; break;
		case PORT_STATUS_NO_TONER: val = "PORT_STATUS_NO_TONER"; break;
		case PORT_STATUS_DOOR_OPEN: val = "PORT_STATUS_DOOR_OPEN"; break;
		case PORT_STATUS_USER_INTERVENTION: val = "PORT_STATUS_USER_INTERVENTION"; break;
		case PORT_STATUS_OUT_OF_MEMORY: val = "PORT_STATUS_OUT_OF_MEMORY"; break;
		case PORT_STATUS_TONER_LOW: val = "PORT_STATUS_TONER_LOW"; break;
		case PORT_STATUS_WARMING_UP: val = "PORT_STATUS_WARMING_UP"; break;
		case PORT_STATUS_POWER_SAVE: val = "PORT_STATUS_POWER_SAVE"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_spoolss_PortSeverity(struct ndr_push *ndr, int ndr_flags, enum spoolss_PortSeverity r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_PortSeverity(struct ndr_pull *ndr, int ndr_flags, enum spoolss_PortSeverity *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_PortSeverity(struct ndr_print *ndr, const char *name, enum spoolss_PortSeverity r)
{
	const char *val = NULL;

	switch (r) {
		case PORT_STATUS_TYPE_ERROR: val = "PORT_STATUS_TYPE_ERROR"; break;
		case PORT_STATUS_TYPE_WARNING: val = "PORT_STATUS_TYPE_WARNING"; break;
		case PORT_STATUS_TYPE_INFO: val = "PORT_STATUS_TYPE_INFO"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_PortInfo3(struct ndr_push *ndr, int ndr_flags, const struct spoolss_PortInfo3 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_spoolss_PortStatus(ndr, NDR_SCALARS, r->status));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->status_string));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_spoolss_PortSeverity(ndr, NDR_SCALARS, r->severity));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->status_string) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->status_string));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->status_string));
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_PortInfo3(struct ndr_pull *ndr, int ndr_flags, struct spoolss_PortInfo3 *r)
{
	uint32_t _ptr_status_string;
	TALLOC_CTX *_mem_save_status_string_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_spoolss_PortStatus(ndr, NDR_SCALARS, &r->status));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_status_string));
			if (_ptr_status_string) {
				NDR_PULL_ALLOC(ndr, r->status_string);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->status_string, _ptr_status_string));
			} else {
				r->status_string = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_spoolss_PortSeverity(ndr, NDR_SCALARS, &r->severity));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->status_string) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->status_string));
				_mem_save_status_string_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->status_string, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->status_string));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_status_string_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_PortInfo3(struct ndr_print *ndr, const char *name, const struct spoolss_PortInfo3 *r)
{
	ndr_print_struct(ndr, name, "spoolss_PortInfo3");
	ndr->depth++;
	ndr_print_spoolss_PortStatus(ndr, "status", r->status);
	ndr_print_ptr(ndr, "status_string", r->status_string);
	ndr->depth++;
	if (r->status_string) {
		ndr_print_string(ndr, "status_string", r->status_string);
	}
	ndr->depth--;
	ndr_print_spoolss_PortSeverity(ndr, "severity", r->severity);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_spoolss_PortInfo3(const struct spoolss_PortInfo3 *r, struct smb_iconv_convenience *ic, int flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_spoolss_PortInfo3, ic);
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_PortInfoFF(struct ndr_push *ndr, int ndr_flags, const struct spoolss_PortInfoFF *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->port_name));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->monitor_data));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->port_name) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->port_name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->port_name));
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_PortInfoFF(struct ndr_pull *ndr, int ndr_flags, struct spoolss_PortInfoFF *r)
{
	uint32_t _ptr_port_name;
	TALLOC_CTX *_mem_save_port_name_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_port_name));
			if (_ptr_port_name) {
				NDR_PULL_ALLOC(ndr, r->port_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->port_name, _ptr_port_name));
			} else {
				r->port_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->monitor_data));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->port_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->port_name));
				_mem_save_port_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->port_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->port_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_port_name_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_PortInfoFF(struct ndr_print *ndr, const char *name, const struct spoolss_PortInfoFF *r)
{
	ndr_print_struct(ndr, name, "spoolss_PortInfoFF");
	ndr->depth++;
	ndr_print_ptr(ndr, "port_name", r->port_name);
	ndr->depth++;
	if (r->port_name) {
		ndr_print_string(ndr, "port_name", r->port_name);
	}
	ndr->depth--;
	ndr_print_DATA_BLOB(ndr, "monitor_data", r->monitor_data);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_spoolss_PortInfoFF(const struct spoolss_PortInfoFF *r, struct smb_iconv_convenience *ic, int flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_spoolss_PortInfoFF, ic);
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_PortInfo(struct ndr_push *ndr, int ndr_flags, const union spoolss_PortInfo *r)
{
	uint32_t _save_relative_base_offset = ndr_push_get_relative_base_offset(ndr);
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_align(ndr, 4));
				NDR_CHECK(ndr_push_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_push_spoolss_PortInfo1(ndr, NDR_SCALARS, &r->info1));
			break; }

			case 2: {
				NDR_CHECK(ndr_push_align(ndr, 4));
				NDR_CHECK(ndr_push_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_push_spoolss_PortInfo2(ndr, NDR_SCALARS, &r->info2));
			break; }

			case 3: {
				NDR_CHECK(ndr_push_align(ndr, 4));
				NDR_CHECK(ndr_push_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_push_spoolss_PortInfo3(ndr, NDR_SCALARS, &r->info3));
			break; }

			case 0xff: {
				NDR_CHECK(ndr_push_align(ndr, 4));
				NDR_CHECK(ndr_push_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_push_spoolss_PortInfoFF(ndr, NDR_SCALARS, &r->infoFF));
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_setup_relative_base_offset2(ndr, r));
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_spoolss_PortInfo1(ndr, NDR_BUFFERS, &r->info1));
			break;

			case 2:
				NDR_CHECK(ndr_push_spoolss_PortInfo2(ndr, NDR_BUFFERS, &r->info2));
			break;

			case 3:
				NDR_CHECK(ndr_push_spoolss_PortInfo3(ndr, NDR_BUFFERS, &r->info3));
			break;

			case 0xff:
				NDR_CHECK(ndr_push_spoolss_PortInfoFF(ndr, NDR_BUFFERS, &r->infoFF));
			break;

			default:
			break;

		}
	}
	ndr_push_restore_relative_base_offset(ndr, _save_relative_base_offset);
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_PortInfo(struct ndr_pull *ndr, int ndr_flags, union spoolss_PortInfo *r)
{
	uint32_t _save_relative_base_offset = ndr_pull_get_relative_base_offset(ndr);
	int level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_align(ndr, 4));
				NDR_CHECK(ndr_pull_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_pull_spoolss_PortInfo1(ndr, NDR_SCALARS, &r->info1));
			break; }

			case 2: {
				NDR_CHECK(ndr_pull_align(ndr, 4));
				NDR_CHECK(ndr_pull_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_pull_spoolss_PortInfo2(ndr, NDR_SCALARS, &r->info2));
			break; }

			case 3: {
				NDR_CHECK(ndr_pull_align(ndr, 4));
				NDR_CHECK(ndr_pull_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_pull_spoolss_PortInfo3(ndr, NDR_SCALARS, &r->info3));
			break; }

			case 0xff: {
				NDR_CHECK(ndr_pull_align(ndr, 4));
				NDR_CHECK(ndr_pull_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_pull_spoolss_PortInfoFF(ndr, NDR_SCALARS, &r->infoFF));
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_setup_relative_base_offset2(ndr, r));
		switch (level) {
			case 1:
				NDR_CHECK(ndr_pull_spoolss_PortInfo1(ndr, NDR_BUFFERS, &r->info1));
			break;

			case 2:
				NDR_CHECK(ndr_pull_spoolss_PortInfo2(ndr, NDR_BUFFERS, &r->info2));
			break;

			case 3:
				NDR_CHECK(ndr_pull_spoolss_PortInfo3(ndr, NDR_BUFFERS, &r->info3));
			break;

			case 0xff:
				NDR_CHECK(ndr_pull_spoolss_PortInfoFF(ndr, NDR_BUFFERS, &r->infoFF));
			break;

			default:
			break;

		}
	}
	ndr_pull_restore_relative_base_offset(ndr, _save_relative_base_offset);
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_PortInfo(struct ndr_print *ndr, const char *name, const union spoolss_PortInfo *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "spoolss_PortInfo");
	switch (level) {
		case 1:
			ndr_print_spoolss_PortInfo1(ndr, "info1", &r->info1);
		break;

		case 2:
			ndr_print_spoolss_PortInfo2(ndr, "info2", &r->info2);
		break;

		case 3:
			ndr_print_spoolss_PortInfo3(ndr, "info3", &r->info3);
		break;

		case 0xff:
			ndr_print_spoolss_PortInfoFF(ndr, "infoFF", &r->infoFF);
		break;

		default:
		break;

	}
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_MonitorInfo1(struct ndr_push *ndr, int ndr_flags, const struct spoolss_MonitorInfo1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->monitor_name));
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->monitor_name) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->monitor_name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->monitor_name));
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_MonitorInfo1(struct ndr_pull *ndr, int ndr_flags, struct spoolss_MonitorInfo1 *r)
{
	uint32_t _ptr_monitor_name;
	TALLOC_CTX *_mem_save_monitor_name_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_monitor_name));
			if (_ptr_monitor_name) {
				NDR_PULL_ALLOC(ndr, r->monitor_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->monitor_name, _ptr_monitor_name));
			} else {
				r->monitor_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->monitor_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->monitor_name));
				_mem_save_monitor_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->monitor_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->monitor_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_monitor_name_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_MonitorInfo1(struct ndr_print *ndr, const char *name, const struct spoolss_MonitorInfo1 *r)
{
	ndr_print_struct(ndr, name, "spoolss_MonitorInfo1");
	ndr->depth++;
	ndr_print_ptr(ndr, "monitor_name", r->monitor_name);
	ndr->depth++;
	if (r->monitor_name) {
		ndr_print_string(ndr, "monitor_name", r->monitor_name);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_spoolss_MonitorInfo1(const struct spoolss_MonitorInfo1 *r, struct smb_iconv_convenience *ic, int flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_spoolss_MonitorInfo1, ic);
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_MonitorInfo2(struct ndr_push *ndr, int ndr_flags, const struct spoolss_MonitorInfo2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->monitor_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->environment));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->dll_name));
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->monitor_name) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->monitor_name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->monitor_name));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->environment) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->environment));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->environment));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->dll_name) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->dll_name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->dll_name));
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_MonitorInfo2(struct ndr_pull *ndr, int ndr_flags, struct spoolss_MonitorInfo2 *r)
{
	uint32_t _ptr_monitor_name;
	TALLOC_CTX *_mem_save_monitor_name_0;
	uint32_t _ptr_environment;
	TALLOC_CTX *_mem_save_environment_0;
	uint32_t _ptr_dll_name;
	TALLOC_CTX *_mem_save_dll_name_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_monitor_name));
			if (_ptr_monitor_name) {
				NDR_PULL_ALLOC(ndr, r->monitor_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->monitor_name, _ptr_monitor_name));
			} else {
				r->monitor_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_environment));
			if (_ptr_environment) {
				NDR_PULL_ALLOC(ndr, r->environment);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->environment, _ptr_environment));
			} else {
				r->environment = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dll_name));
			if (_ptr_dll_name) {
				NDR_PULL_ALLOC(ndr, r->dll_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->dll_name, _ptr_dll_name));
			} else {
				r->dll_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->monitor_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->monitor_name));
				_mem_save_monitor_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->monitor_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->monitor_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_monitor_name_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->environment) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->environment));
				_mem_save_environment_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->environment, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->environment));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_environment_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->dll_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->dll_name));
				_mem_save_dll_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->dll_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->dll_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dll_name_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_MonitorInfo2(struct ndr_print *ndr, const char *name, const struct spoolss_MonitorInfo2 *r)
{
	ndr_print_struct(ndr, name, "spoolss_MonitorInfo2");
	ndr->depth++;
	ndr_print_ptr(ndr, "monitor_name", r->monitor_name);
	ndr->depth++;
	if (r->monitor_name) {
		ndr_print_string(ndr, "monitor_name", r->monitor_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "environment", r->environment);
	ndr->depth++;
	if (r->environment) {
		ndr_print_string(ndr, "environment", r->environment);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "dll_name", r->dll_name);
	ndr->depth++;
	if (r->dll_name) {
		ndr_print_string(ndr, "dll_name", r->dll_name);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_spoolss_MonitorInfo2(const struct spoolss_MonitorInfo2 *r, struct smb_iconv_convenience *ic, int flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_spoolss_MonitorInfo2, ic);
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_MonitorInfo(struct ndr_push *ndr, int ndr_flags, const union spoolss_MonitorInfo *r)
{
	uint32_t _save_relative_base_offset = ndr_push_get_relative_base_offset(ndr);
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_align(ndr, 4));
				NDR_CHECK(ndr_push_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_push_spoolss_MonitorInfo1(ndr, NDR_SCALARS, &r->info1));
			break; }

			case 2: {
				NDR_CHECK(ndr_push_align(ndr, 4));
				NDR_CHECK(ndr_push_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_push_spoolss_MonitorInfo2(ndr, NDR_SCALARS, &r->info2));
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_setup_relative_base_offset2(ndr, r));
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_spoolss_MonitorInfo1(ndr, NDR_BUFFERS, &r->info1));
			break;

			case 2:
				NDR_CHECK(ndr_push_spoolss_MonitorInfo2(ndr, NDR_BUFFERS, &r->info2));
			break;

			default:
			break;

		}
	}
	ndr_push_restore_relative_base_offset(ndr, _save_relative_base_offset);
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_MonitorInfo(struct ndr_pull *ndr, int ndr_flags, union spoolss_MonitorInfo *r)
{
	uint32_t _save_relative_base_offset = ndr_pull_get_relative_base_offset(ndr);
	int level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_align(ndr, 4));
				NDR_CHECK(ndr_pull_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_pull_spoolss_MonitorInfo1(ndr, NDR_SCALARS, &r->info1));
			break; }

			case 2: {
				NDR_CHECK(ndr_pull_align(ndr, 4));
				NDR_CHECK(ndr_pull_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_pull_spoolss_MonitorInfo2(ndr, NDR_SCALARS, &r->info2));
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_setup_relative_base_offset2(ndr, r));
		switch (level) {
			case 1:
				NDR_CHECK(ndr_pull_spoolss_MonitorInfo1(ndr, NDR_BUFFERS, &r->info1));
			break;

			case 2:
				NDR_CHECK(ndr_pull_spoolss_MonitorInfo2(ndr, NDR_BUFFERS, &r->info2));
			break;

			default:
			break;

		}
	}
	ndr_pull_restore_relative_base_offset(ndr, _save_relative_base_offset);
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_MonitorInfo(struct ndr_print *ndr, const char *name, const union spoolss_MonitorInfo *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "spoolss_MonitorInfo");
	switch (level) {
		case 1:
			ndr_print_spoolss_MonitorInfo1(ndr, "info1", &r->info1);
		break;

		case 2:
			ndr_print_spoolss_MonitorInfo2(ndr, "info2", &r->info2);
		break;

		default:
		break;

	}
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_PrintProcDataTypesInfo1(struct ndr_push *ndr, int ndr_flags, const struct spoolss_PrintProcDataTypesInfo1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->name_array));
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->name_array) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->name_array));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->name_array));
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_PrintProcDataTypesInfo1(struct ndr_pull *ndr, int ndr_flags, struct spoolss_PrintProcDataTypesInfo1 *r)
{
	uint32_t _ptr_name_array;
	TALLOC_CTX *_mem_save_name_array_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_name_array));
			if (_ptr_name_array) {
				NDR_PULL_ALLOC(ndr, r->name_array);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->name_array, _ptr_name_array));
			} else {
				r->name_array = NULL;
			}
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->name_array) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->name_array));
				_mem_save_name_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->name_array, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->name_array));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_array_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_PrintProcDataTypesInfo1(struct ndr_print *ndr, const char *name, const struct spoolss_PrintProcDataTypesInfo1 *r)
{
	ndr_print_struct(ndr, name, "spoolss_PrintProcDataTypesInfo1");
	ndr->depth++;
	ndr_print_ptr(ndr, "name_array", r->name_array);
	ndr->depth++;
	if (r->name_array) {
		ndr_print_string(ndr, "name_array", r->name_array);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_spoolss_PrintProcDataTypesInfo1(const struct spoolss_PrintProcDataTypesInfo1 *r, struct smb_iconv_convenience *ic, int flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_spoolss_PrintProcDataTypesInfo1, ic);
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_PrintProcDataTypesInfo(struct ndr_push *ndr, int ndr_flags, const union spoolss_PrintProcDataTypesInfo *r)
{
	uint32_t _save_relative_base_offset = ndr_push_get_relative_base_offset(ndr);
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_align(ndr, 4));
				NDR_CHECK(ndr_push_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_push_spoolss_PrintProcDataTypesInfo1(ndr, NDR_SCALARS, &r->info1));
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_setup_relative_base_offset2(ndr, r));
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_spoolss_PrintProcDataTypesInfo1(ndr, NDR_BUFFERS, &r->info1));
			break;

			default:
			break;

		}
	}
	ndr_push_restore_relative_base_offset(ndr, _save_relative_base_offset);
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_PrintProcDataTypesInfo(struct ndr_pull *ndr, int ndr_flags, union spoolss_PrintProcDataTypesInfo *r)
{
	uint32_t _save_relative_base_offset = ndr_pull_get_relative_base_offset(ndr);
	int level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_align(ndr, 4));
				NDR_CHECK(ndr_pull_setup_relative_base_offset1(ndr, r, ndr->offset));
				NDR_CHECK(ndr_pull_spoolss_PrintProcDataTypesInfo1(ndr, NDR_SCALARS, &r->info1));
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_setup_relative_base_offset2(ndr, r));
		switch (level) {
			case 1:
				NDR_CHECK(ndr_pull_spoolss_PrintProcDataTypesInfo1(ndr, NDR_BUFFERS, &r->info1));
			break;

			default:
			break;

		}
	}
	ndr_pull_restore_relative_base_offset(ndr, _save_relative_base_offset);
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_PrintProcDataTypesInfo(struct ndr_print *ndr, const char *name, const union spoolss_PrintProcDataTypesInfo *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "spoolss_PrintProcDataTypesInfo");
	switch (level) {
		case 1:
			ndr_print_spoolss_PrintProcDataTypesInfo1(ndr, "info1", &r->info1);
		break;

		default:
		break;

	}
}

static enum ndr_err_code ndr_push_spoolss_PrinterChangeFlags(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_PrinterChangeFlags(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_PrinterChangeFlags(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_CHANGE_ADD_PRINTER", PRINTER_CHANGE_ADD_PRINTER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_CHANGE_SET_PRINTER", PRINTER_CHANGE_SET_PRINTER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_CHANGE_DELETE_PRINTER", PRINTER_CHANGE_DELETE_PRINTER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_CHANGE_FAILED_CONNECTION_PRINTER", PRINTER_CHANGE_FAILED_CONNECTION_PRINTER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_CHANGE_ADD_JOB", PRINTER_CHANGE_ADD_JOB, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_CHANGE_SET_JOB", PRINTER_CHANGE_SET_JOB, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_CHANGE_DELETE_JOB", PRINTER_CHANGE_DELETE_JOB, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_CHANGE_WRITE_JOB", PRINTER_CHANGE_WRITE_JOB, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_CHANGE_ADD_FORM", PRINTER_CHANGE_ADD_FORM, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_CHANGE_SET_FORM", PRINTER_CHANGE_SET_FORM, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_CHANGE_DELETE_FORM", PRINTER_CHANGE_DELETE_FORM, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_CHANGE_ADD_PORT", PRINTER_CHANGE_ADD_PORT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_CHANGE_CONFIGURE_PORT", PRINTER_CHANGE_CONFIGURE_PORT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_CHANGE_DELETE_PORT", PRINTER_CHANGE_DELETE_PORT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_CHANGE_ADD_PRINT_PROCESSOR", PRINTER_CHANGE_ADD_PRINT_PROCESSOR, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_CHANGE_DELETE_PRINT_PROCESSOR", PRINTER_CHANGE_DELETE_PRINT_PROCESSOR, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_CHANGE_SERVER", PRINTER_CHANGE_SERVER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_CHANGE_ADD_PRINTER_DRIVER", PRINTER_CHANGE_ADD_PRINTER_DRIVER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_CHANGE_SET_PRINTER_DRIVER", PRINTER_CHANGE_SET_PRINTER_DRIVER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_CHANGE_DELETE_PRINTER_DRIVER", PRINTER_CHANGE_DELETE_PRINTER_DRIVER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_CHANGE_TIMEOUT", PRINTER_CHANGE_TIMEOUT, r);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_JobNotifyField(struct ndr_push *ndr, int ndr_flags, enum spoolss_JobNotifyField r)
{
	NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_JobNotifyField(struct ndr_pull *ndr, int ndr_flags, enum spoolss_JobNotifyField *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_JobNotifyField(struct ndr_print *ndr, const char *name, enum spoolss_JobNotifyField r)
{
	const char *val = NULL;

	switch (r) {
		case JOB_NOTIFY_FIELD_PRINTER_NAME: val = "JOB_NOTIFY_FIELD_PRINTER_NAME"; break;
		case JOB_NOTIFY_FIELD_MACHINE_NAME: val = "JOB_NOTIFY_FIELD_MACHINE_NAME"; break;
		case JOB_NOTIFY_FIELD_PORT_NAME: val = "JOB_NOTIFY_FIELD_PORT_NAME"; break;
		case JOB_NOTIFY_FIELD_USER_NAME: val = "JOB_NOTIFY_FIELD_USER_NAME"; break;
		case JOB_NOTIFY_FIELD_NOTIFY_NAME: val = "JOB_NOTIFY_FIELD_NOTIFY_NAME"; break;
		case JOB_NOTIFY_FIELD_DATATYPE: val = "JOB_NOTIFY_FIELD_DATATYPE"; break;
		case JOB_NOTIFY_FIELD_PRINT_PROCESSOR: val = "JOB_NOTIFY_FIELD_PRINT_PROCESSOR"; break;
		case JOB_NOTIFY_FIELD_PARAMETERS: val = "JOB_NOTIFY_FIELD_PARAMETERS"; break;
		case JOB_NOTIFY_FIELD_DRIVER_NAME: val = "JOB_NOTIFY_FIELD_DRIVER_NAME"; break;
		case JOB_NOTIFY_FIELD_DEVMODE: val = "JOB_NOTIFY_FIELD_DEVMODE"; break;
		case JOB_NOTIFY_FIELD_STATUS: val = "JOB_NOTIFY_FIELD_STATUS"; break;
		case JOB_NOTIFY_FIELD_STATUS_STRING: val = "JOB_NOTIFY_FIELD_STATUS_STRING"; break;
		case JOB_NOTIFY_FIELD_SECURITY_DESCRIPTOR: val = "JOB_NOTIFY_FIELD_SECURITY_DESCRIPTOR"; break;
		case JOB_NOTIFY_FIELD_DOCUMENT: val = "JOB_NOTIFY_FIELD_DOCUMENT"; break;
		case JOB_NOTIFY_FIELD_PRIORITY: val = "JOB_NOTIFY_FIELD_PRIORITY"; break;
		case JOB_NOTIFY_FIELD_POSITION: val = "JOB_NOTIFY_FIELD_POSITION"; break;
		case JOB_NOTIFY_FIELD_SUBMITTED: val = "JOB_NOTIFY_FIELD_SUBMITTED"; break;
		case JOB_NOTIFY_FIELD_START_TIME: val = "JOB_NOTIFY_FIELD_START_TIME"; break;
		case JOB_NOTIFY_FIELD_UNTIL_TIME: val = "JOB_NOTIFY_FIELD_UNTIL_TIME"; break;
		case JOB_NOTIFY_FIELD_TIME: val = "JOB_NOTIFY_FIELD_TIME"; break;
		case JOB_NOTIFY_FIELD_TOTAL_PAGES: val = "JOB_NOTIFY_FIELD_TOTAL_PAGES"; break;
		case JOB_NOTIFY_FIELD_PAGES_PRINTED: val = "JOB_NOTIFY_FIELD_PAGES_PRINTED"; break;
		case JOB_NOTIFY_FIELD_TOTAL_BYTES: val = "JOB_NOTIFY_FIELD_TOTAL_BYTES"; break;
		case JOB_NOTIFY_FIELD_BYTES_PRINTED: val = "JOB_NOTIFY_FIELD_BYTES_PRINTED"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_PrintNotifyField(struct ndr_push *ndr, int ndr_flags, enum spoolss_PrintNotifyField r)
{
	NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_PrintNotifyField(struct ndr_pull *ndr, int ndr_flags, enum spoolss_PrintNotifyField *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_PrintNotifyField(struct ndr_print *ndr, const char *name, enum spoolss_PrintNotifyField r)
{
	const char *val = NULL;

	switch (r) {
		case PRINTER_NOTIFY_FIELD_SERVER_NAME: val = "PRINTER_NOTIFY_FIELD_SERVER_NAME"; break;
		case PRINTER_NOTIFY_FIELD_PRINTER_NAME: val = "PRINTER_NOTIFY_FIELD_PRINTER_NAME"; break;
		case PRINTER_NOTIFY_FIELD_SHARE_NAME: val = "PRINTER_NOTIFY_FIELD_SHARE_NAME"; break;
		case PRINTER_NOTIFY_FIELD_PORT_NAME: val = "PRINTER_NOTIFY_FIELD_PORT_NAME"; break;
		case PRINTER_NOTIFY_FIELD_DRIVER_NAME: val = "PRINTER_NOTIFY_FIELD_DRIVER_NAME"; break;
		case PRINTER_NOTIFY_FIELD_COMMENT: val = "PRINTER_NOTIFY_FIELD_COMMENT"; break;
		case PRINTER_NOTIFY_FIELD_LOCATION: val = "PRINTER_NOTIFY_FIELD_LOCATION"; break;
		case PRINTER_NOTIFY_FIELD_DEVMODE: val = "PRINTER_NOTIFY_FIELD_DEVMODE"; break;
		case PRINTER_NOTIFY_FIELD_SEPFILE: val = "PRINTER_NOTIFY_FIELD_SEPFILE"; break;
		case PRINTER_NOTIFY_FIELD_PRINT_PROCESSOR: val = "PRINTER_NOTIFY_FIELD_PRINT_PROCESSOR"; break;
		case PRINTER_NOTIFY_FIELD_PARAMETERS: val = "PRINTER_NOTIFY_FIELD_PARAMETERS"; break;
		case PRINTER_NOTIFY_FIELD_DATATYPE: val = "PRINTER_NOTIFY_FIELD_DATATYPE"; break;
		case PRINTER_NOTIFY_FIELD_SECURITY_DESCRIPTOR: val = "PRINTER_NOTIFY_FIELD_SECURITY_DESCRIPTOR"; break;
		case PRINTER_NOTIFY_FIELD_ATTRIBUTES: val = "PRINTER_NOTIFY_FIELD_ATTRIBUTES"; break;
		case PRINTER_NOTIFY_FIELD_PRIORITY: val = "PRINTER_NOTIFY_FIELD_PRIORITY"; break;
		case PRINTER_NOTIFY_FIELD_DEFAULT_PRIORITY: val = "PRINTER_NOTIFY_FIELD_DEFAULT_PRIORITY"; break;
		case PRINTER_NOTIFY_FIELD_START_TIME: val = "PRINTER_NOTIFY_FIELD_START_TIME"; break;
		case PRINTER_NOTIFY_FIELD_UNTIL_TIME: val = "PRINTER_NOTIFY_FIELD_UNTIL_TIME"; break;
		case PRINTER_NOTIFY_FIELD_STATUS: val = "PRINTER_NOTIFY_FIELD_STATUS"; break;
		case PRINTER_NOTIFY_FIELD_STATUS_STRING: val = "PRINTER_NOTIFY_FIELD_STATUS_STRING"; break;
		case PRINTER_NOTIFY_FIELD_CJOBS: val = "PRINTER_NOTIFY_FIELD_CJOBS"; break;
		case PRINTER_NOTIFY_FIELD_AVERAGE_PPM: val = "PRINTER_NOTIFY_FIELD_AVERAGE_PPM"; break;
		case PRINTER_NOTIFY_FIELD_TOTAL_PAGES: val = "PRINTER_NOTIFY_FIELD_TOTAL_PAGES"; break;
		case PRINTER_NOTIFY_FIELD_PAGES_PRINTED: val = "PRINTER_NOTIFY_FIELD_PAGES_PRINTED"; break;
		case PRINTER_NOTIFY_FIELD_TOTAL_BYTES: val = "PRINTER_NOTIFY_FIELD_TOTAL_BYTES"; break;
		case PRINTER_NOTIFY_FIELD_BYTES_PRINTED: val = "PRINTER_NOTIFY_FIELD_BYTES_PRINTED"; break;
		case PRINTER_NOTIFY_FIELD_OBJECT_GUID: val = "PRINTER_NOTIFY_FIELD_OBJECT_GUID"; break;
		case PRINTER_NOTIFY_FIELD_FRIENDLY_NAME: val = "PRINTER_NOTIFY_FIELD_FRIENDLY_NAME"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_spoolss_NotifyType(struct ndr_push *ndr, int ndr_flags, enum spoolss_NotifyType r)
{
	NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_NotifyType(struct ndr_pull *ndr, int ndr_flags, enum spoolss_NotifyType *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_NotifyType(struct ndr_print *ndr, const char *name, enum spoolss_NotifyType r)
{
	const char *val = NULL;

	switch (r) {
		case PRINTER_NOTIFY_TYPE: val = "PRINTER_NOTIFY_TYPE"; break;
		case JOB_NOTIFY_TYPE: val = "JOB_NOTIFY_TYPE"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_spoolss_Field(struct ndr_push *ndr, int ndr_flags, const union spoolss_Field *r)
{
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case PRINTER_NOTIFY_TYPE: {
				NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->field));
			break; }

			case JOB_NOTIFY_TYPE: {
				NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->field));
			break; }

			default: {
				NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->field));
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case PRINTER_NOTIFY_TYPE:
			break;

			case JOB_NOTIFY_TYPE:
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_Field(struct ndr_pull *ndr, int ndr_flags, union spoolss_Field *r)
{
	int level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		switch (level) {
			case PRINTER_NOTIFY_TYPE: {
				NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->field));
			break; }

			case JOB_NOTIFY_TYPE: {
				NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->field));
			break; }

			default: {
				NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->field));
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case PRINTER_NOTIFY_TYPE:
			break;

			case JOB_NOTIFY_TYPE:
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_push_spoolss_NotifyOptionType(struct ndr_push *ndr, int ndr_flags, const struct spoolss_NotifyOptionType *r)
{
	uint32_t cntr_fields_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_spoolss_NotifyType(ndr, NDR_SCALARS, r->type));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->u1));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->u2));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->u3));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->fields));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->fields) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
			for (cntr_fields_1 = 0; cntr_fields_1 < r->count; cntr_fields_1++) {
				NDR_CHECK(ndr_push_set_switch_value(ndr, &r->fields[cntr_fields_1], r->type));
				NDR_CHECK(ndr_push_spoolss_Field(ndr, NDR_SCALARS, &r->fields[cntr_fields_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_NotifyOptionType(struct ndr_pull *ndr, int ndr_flags, struct spoolss_NotifyOptionType *r)
{
	uint32_t _ptr_fields;
	uint32_t cntr_fields_1;
	TALLOC_CTX *_mem_save_fields_0;
	TALLOC_CTX *_mem_save_fields_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_spoolss_NotifyType(ndr, NDR_SCALARS, &r->type));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->u1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->u2));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->u3));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_fields));
		if (_ptr_fields) {
			NDR_PULL_ALLOC(ndr, r->fields);
		} else {
			r->fields = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->fields) {
			_mem_save_fields_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->fields, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->fields));
			NDR_PULL_ALLOC_N(ndr, r->fields, ndr_get_array_size(ndr, &r->fields));
			_mem_save_fields_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->fields, 0);
			for (cntr_fields_1 = 0; cntr_fields_1 < r->count; cntr_fields_1++) {
				NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->fields[cntr_fields_1], r->type));
				NDR_CHECK(ndr_pull_spoolss_Field(ndr, NDR_SCALARS, &r->fields[cntr_fields_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_fields_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_fields_0, 0);
		}
		if (r->fields) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->fields, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_NotifyOptionType(struct ndr_print *ndr, const char *name, const struct spoolss_NotifyOptionType *r)
{
	uint32_t cntr_fields_1;
	ndr_print_struct(ndr, name, "spoolss_NotifyOptionType");
	ndr->depth++;
	ndr_print_spoolss_NotifyType(ndr, "type", r->type);
	ndr_print_uint16(ndr, "u1", r->u1);
	ndr_print_uint32(ndr, "u2", r->u2);
	ndr_print_uint32(ndr, "u3", r->u3);
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "fields", r->fields);
	ndr->depth++;
	if (r->fields) {
		ndr->print(ndr, "%s: ARRAY(%d)", "fields", (int)r->count);
		ndr->depth++;
		for (cntr_fields_1=0;cntr_fields_1<r->count;cntr_fields_1++) {
			char *idx_1=NULL;
			if (asprintf(&idx_1, "[%d]", cntr_fields_1) != -1) {
				ndr_print_set_switch_value(ndr, &r->fields[cntr_fields_1], r->type);
				ndr_print_spoolss_Field(ndr, "fields", &r->fields[cntr_fields_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolssNotifyOptionFlags(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolssNotifyOptionFlags(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolssNotifyOptionFlags(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_NOTIFY_OPTIONS_REFRESH", PRINTER_NOTIFY_OPTIONS_REFRESH, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_NotifyOption(struct ndr_push *ndr, int ndr_flags, const struct spoolss_NotifyOption *r)
{
	uint32_t cntr_types_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 2));
		NDR_CHECK(ndr_push_spoolssNotifyOptionFlags(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->types));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->types) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
			for (cntr_types_1 = 0; cntr_types_1 < r->count; cntr_types_1++) {
				NDR_CHECK(ndr_push_spoolss_NotifyOptionType(ndr, NDR_SCALARS, &r->types[cntr_types_1]));
			}
			for (cntr_types_1 = 0; cntr_types_1 < r->count; cntr_types_1++) {
				NDR_CHECK(ndr_push_spoolss_NotifyOptionType(ndr, NDR_BUFFERS, &r->types[cntr_types_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_NotifyOption(struct ndr_pull *ndr, int ndr_flags, struct spoolss_NotifyOption *r)
{
	uint32_t _ptr_types;
	uint32_t cntr_types_1;
	TALLOC_CTX *_mem_save_types_0;
	TALLOC_CTX *_mem_save_types_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_spoolssNotifyOptionFlags(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_types));
		if (_ptr_types) {
			NDR_PULL_ALLOC(ndr, r->types);
		} else {
			r->types = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->types) {
			_mem_save_types_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->types, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->types));
			NDR_PULL_ALLOC_N(ndr, r->types, ndr_get_array_size(ndr, &r->types));
			_mem_save_types_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->types, 0);
			for (cntr_types_1 = 0; cntr_types_1 < r->count; cntr_types_1++) {
				NDR_CHECK(ndr_pull_spoolss_NotifyOptionType(ndr, NDR_SCALARS, &r->types[cntr_types_1]));
			}
			for (cntr_types_1 = 0; cntr_types_1 < r->count; cntr_types_1++) {
				NDR_CHECK(ndr_pull_spoolss_NotifyOptionType(ndr, NDR_BUFFERS, &r->types[cntr_types_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_types_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_types_0, 0);
		}
		if (r->types) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->types, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_NotifyOption(struct ndr_print *ndr, const char *name, const struct spoolss_NotifyOption *r)
{
	uint32_t cntr_types_1;
	ndr_print_struct(ndr, name, "spoolss_NotifyOption");
	ndr->depth++;
	ndr_print_uint32(ndr, "version", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?2:r->version);
	ndr_print_spoolssNotifyOptionFlags(ndr, "flags", r->flags);
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "types", r->types);
	ndr->depth++;
	if (r->types) {
		ndr->print(ndr, "%s: ARRAY(%d)", "types", (int)r->count);
		ndr->depth++;
		for (cntr_types_1=0;cntr_types_1<r->count;cntr_types_1++) {
			char *idx_1=NULL;
			if (asprintf(&idx_1, "[%d]", cntr_types_1) != -1) {
				ndr_print_spoolss_NotifyOptionType(ndr, "types", &r->types[cntr_types_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_NotifyString(struct ndr_push *ndr, int ndr_flags, const struct spoolss_NotifyString *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->size));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->string));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->string) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->size / 2));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->string, r->size / 2, sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_NotifyString(struct ndr_pull *ndr, int ndr_flags, struct spoolss_NotifyString *r)
{
	uint32_t _ptr_string;
	TALLOC_CTX *_mem_save_string_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_string));
		if (_ptr_string) {
			NDR_PULL_ALLOC(ndr, r->string);
		} else {
			r->string = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->string) {
			_mem_save_string_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->string, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->string));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->string, ndr_get_array_size(ndr, &r->string), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_string_0, 0);
		}
		if (r->string) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->string, r->size / 2));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_NotifyString(struct ndr_print *ndr, const char *name, const struct spoolss_NotifyString *r)
{
	ndr_print_struct(ndr, name, "spoolss_NotifyString");
	ndr->depth++;
	ndr_print_uint32(ndr, "size", r->size);
	ndr_print_ptr(ndr, "string", r->string);
	ndr->depth++;
	if (r->string) {
		ndr_print_string(ndr, "string", r->string);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_NotifyTable(struct ndr_push *ndr, int ndr_flags, enum spoolss_NotifyTable r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_NotifyTable(struct ndr_pull *ndr, int ndr_flags, enum spoolss_NotifyTable *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_NotifyTable(struct ndr_print *ndr, const char *name, enum spoolss_NotifyTable r)
{
	const char *val = NULL;

	switch (r) {
		case NOTIFY_TABLE_DWORD: val = "NOTIFY_TABLE_DWORD"; break;
		case NOTIFY_TABLE_STRING: val = "NOTIFY_TABLE_STRING"; break;
		case NOTIFY_TABLE_DEVMODE: val = "NOTIFY_TABLE_DEVMODE"; break;
		case NOTIFY_TABLE_TIME: val = "NOTIFY_TABLE_TIME"; break;
		case NOTIFY_TABLE_SECURITYDESCRIPTOR: val = "NOTIFY_TABLE_SECURITYDESCRIPTOR"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_spoolss_NotifyData(struct ndr_push *ndr, int ndr_flags, const union spoolss_NotifyData *r)
{
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		switch (level) {
			case 1: {
				uint32_t cntr_integer_0;
				for (cntr_integer_0 = 0; cntr_integer_0 < 2; cntr_integer_0++) {
					NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->integer[cntr_integer_0]));
				}
			break; }

			case 2: {
				NDR_CHECK(ndr_push_spoolss_NotifyString(ndr, NDR_SCALARS, &r->string));
			break; }

			case 3: {
				NDR_CHECK(ndr_push_spoolss_DevmodeContainer(ndr, NDR_SCALARS, &r->devmode));
			break; }

			case 4: {
				NDR_CHECK(ndr_push_spoolss_TimeCtr(ndr, NDR_SCALARS, &r->time));
			break; }

			case 5: {
				NDR_CHECK(ndr_push_sec_desc_buf(ndr, NDR_SCALARS, &r->sd));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 1:
			break;

			case 2:
				NDR_CHECK(ndr_push_spoolss_NotifyString(ndr, NDR_BUFFERS, &r->string));
			break;

			case 3:
				NDR_CHECK(ndr_push_spoolss_DevmodeContainer(ndr, NDR_BUFFERS, &r->devmode));
			break;

			case 4:
				NDR_CHECK(ndr_push_spoolss_TimeCtr(ndr, NDR_BUFFERS, &r->time));
			break;

			case 5:
				NDR_CHECK(ndr_push_sec_desc_buf(ndr, NDR_BUFFERS, &r->sd));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_NotifyData(struct ndr_pull *ndr, int ndr_flags, union spoolss_NotifyData *r)
{
	int level;
	uint32_t _level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r", _level);
		}
		switch (level) {
			case 1: {
				uint32_t cntr_integer_0;
				for (cntr_integer_0 = 0; cntr_integer_0 < 2; cntr_integer_0++) {
					NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->integer[cntr_integer_0]));
				}
			break; }

			case 2: {
				NDR_CHECK(ndr_pull_spoolss_NotifyString(ndr, NDR_SCALARS, &r->string));
			break; }

			case 3: {
				NDR_CHECK(ndr_pull_spoolss_DevmodeContainer(ndr, NDR_SCALARS, &r->devmode));
			break; }

			case 4: {
				NDR_CHECK(ndr_pull_spoolss_TimeCtr(ndr, NDR_SCALARS, &r->time));
			break; }

			case 5: {
				NDR_CHECK(ndr_pull_sec_desc_buf(ndr, NDR_SCALARS, &r->sd));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
			break;

			case 2:
				NDR_CHECK(ndr_pull_spoolss_NotifyString(ndr, NDR_BUFFERS, &r->string));
			break;

			case 3:
				NDR_CHECK(ndr_pull_spoolss_DevmodeContainer(ndr, NDR_BUFFERS, &r->devmode));
			break;

			case 4:
				NDR_CHECK(ndr_pull_spoolss_TimeCtr(ndr, NDR_BUFFERS, &r->time));
			break;

			case 5:
				NDR_CHECK(ndr_pull_sec_desc_buf(ndr, NDR_BUFFERS, &r->sd));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_NotifyData(struct ndr_print *ndr, const char *name, const union spoolss_NotifyData *r)
{
	int level;
	uint32_t cntr_integer_0;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "spoolss_NotifyData");
	switch (level) {
		case 1:
			ndr->print(ndr, "%s: ARRAY(%d)", "integer", (int)2);
			ndr->depth++;
			for (cntr_integer_0=0;cntr_integer_0<2;cntr_integer_0++) {
				char *idx_0=NULL;
				if (asprintf(&idx_0, "[%d]", cntr_integer_0) != -1) {
					ndr_print_uint32(ndr, "integer", r->integer[cntr_integer_0]);
					free(idx_0);
				}
			}
			ndr->depth--;
		break;

		case 2:
			ndr_print_spoolss_NotifyString(ndr, "string", &r->string);
		break;

		case 3:
			ndr_print_spoolss_DevmodeContainer(ndr, "devmode", &r->devmode);
		break;

		case 4:
			ndr_print_spoolss_TimeCtr(ndr, "time", &r->time);
		break;

		case 5:
			ndr_print_sec_desc_buf(ndr, "sd", &r->sd);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_spoolss_Notify(struct ndr_push *ndr, int ndr_flags, const struct spoolss_Notify *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_spoolss_NotifyType(ndr, NDR_SCALARS, r->type));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->field, r->type));
		NDR_CHECK(ndr_push_spoolss_Field(ndr, NDR_SCALARS, &r->field));
		NDR_CHECK(ndr_push_spoolss_NotifyTable(ndr, NDR_SCALARS, r->variable_type));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->job_id));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->data, r->variable_type));
		NDR_CHECK(ndr_push_spoolss_NotifyData(ndr, NDR_SCALARS, &r->data));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_spoolss_NotifyData(ndr, NDR_BUFFERS, &r->data));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_Notify(struct ndr_pull *ndr, int ndr_flags, struct spoolss_Notify *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_spoolss_NotifyType(ndr, NDR_SCALARS, &r->type));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->field, r->type));
		NDR_CHECK(ndr_pull_spoolss_Field(ndr, NDR_SCALARS, &r->field));
		NDR_CHECK(ndr_pull_spoolss_NotifyTable(ndr, NDR_SCALARS, &r->variable_type));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->job_id));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->data, r->variable_type));
		NDR_CHECK(ndr_pull_spoolss_NotifyData(ndr, NDR_SCALARS, &r->data));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_spoolss_NotifyData(ndr, NDR_BUFFERS, &r->data));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_Notify(struct ndr_print *ndr, const char *name, const struct spoolss_Notify *r)
{
	ndr_print_struct(ndr, name, "spoolss_Notify");
	ndr->depth++;
	ndr_print_spoolss_NotifyType(ndr, "type", r->type);
	ndr_print_set_switch_value(ndr, &r->field, r->type);
	ndr_print_spoolss_Field(ndr, "field", &r->field);
	ndr_print_spoolss_NotifyTable(ndr, "variable_type", r->variable_type);
	ndr_print_uint32(ndr, "job_id", r->job_id);
	ndr_print_set_switch_value(ndr, &r->data, r->variable_type);
	ndr_print_spoolss_NotifyData(ndr, "data", &r->data);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_NotifyInfo(struct ndr_push *ndr, int ndr_flags, const struct spoolss_NotifyInfo *r)
{
	uint32_t cntr_notifies_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 2));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		for (cntr_notifies_0 = 0; cntr_notifies_0 < r->count; cntr_notifies_0++) {
			NDR_CHECK(ndr_push_spoolss_Notify(ndr, NDR_SCALARS, &r->notifies[cntr_notifies_0]));
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_notifies_0 = 0; cntr_notifies_0 < r->count; cntr_notifies_0++) {
			NDR_CHECK(ndr_push_spoolss_Notify(ndr, NDR_BUFFERS, &r->notifies[cntr_notifies_0]));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_NotifyInfo(struct ndr_pull *ndr, int ndr_flags, struct spoolss_NotifyInfo *r)
{
	uint32_t cntr_notifies_0;
	TALLOC_CTX *_mem_save_notifies_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->notifies));
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_PULL_ALLOC_N(ndr, r->notifies, ndr_get_array_size(ndr, &r->notifies));
		_mem_save_notifies_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->notifies, 0);
		for (cntr_notifies_0 = 0; cntr_notifies_0 < r->count; cntr_notifies_0++) {
			NDR_CHECK(ndr_pull_spoolss_Notify(ndr, NDR_SCALARS, &r->notifies[cntr_notifies_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_notifies_0, 0);
		if (r->notifies) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->notifies, r->count));
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		_mem_save_notifies_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->notifies, 0);
		for (cntr_notifies_0 = 0; cntr_notifies_0 < r->count; cntr_notifies_0++) {
			NDR_CHECK(ndr_pull_spoolss_Notify(ndr, NDR_BUFFERS, &r->notifies[cntr_notifies_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_notifies_0, 0);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_NotifyInfo(struct ndr_print *ndr, const char *name, const struct spoolss_NotifyInfo *r)
{
	uint32_t cntr_notifies_0;
	ndr_print_struct(ndr, name, "spoolss_NotifyInfo");
	ndr->depth++;
	ndr_print_uint32(ndr, "version", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?2:r->version);
	ndr_print_uint32(ndr, "flags", r->flags);
	ndr_print_uint32(ndr, "count", r->count);
	ndr->print(ndr, "%s: ARRAY(%d)", "notifies", (int)r->count);
	ndr->depth++;
	for (cntr_notifies_0=0;cntr_notifies_0<r->count;cntr_notifies_0++) {
		char *idx_0=NULL;
		if (asprintf(&idx_0, "[%d]", cntr_notifies_0) != -1) {
			ndr_print_spoolss_Notify(ndr, "notifies", &r->notifies[cntr_notifies_0]);
			free(idx_0);
		}
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_ReplyPrinterInfo(struct ndr_push *ndr, int ndr_flags, const union spoolss_ReplyPrinterInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info0));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 0:
				if (r->info0) {
					NDR_CHECK(ndr_push_spoolss_NotifyInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->info0));
				}
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_ReplyPrinterInfo(struct ndr_pull *ndr, int ndr_flags, union spoolss_ReplyPrinterInfo *r)
{
	int level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_info0_0;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r", _level);
		}
		switch (level) {
			case 0: {
				uint32_t _ptr_info0;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info0));
				if (_ptr_info0) {
					NDR_PULL_ALLOC(ndr, r->info0);
				} else {
					r->info0 = NULL;
				}
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 0:
				if (r->info0) {
					_mem_save_info0_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info0, 0);
					NDR_CHECK(ndr_pull_spoolss_NotifyInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->info0));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info0_0, 0);
				}
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_ReplyPrinterInfo(struct ndr_print *ndr, const char *name, const union spoolss_ReplyPrinterInfo *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "spoolss_ReplyPrinterInfo");
	switch (level) {
		case 0:
			ndr_print_ptr(ndr, "info0", r->info0);
			ndr->depth++;
			if (r->info0) {
				ndr_print_spoolss_NotifyInfo(ndr, "info0", r->info0);
			}
			ndr->depth--;
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_spoolss_PrinterNotifyFlags(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_PrinterNotifyFlags(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_PrinterNotifyFlags(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_NOTIFY_INFO_DISCARDED", PRINTER_NOTIFY_INFO_DISCARDED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_NOTIFY_INFO_DISCARDNOTED", PRINTER_NOTIFY_INFO_DISCARDNOTED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_NOTIFY_INFO_COLOR_MISMATCH", PRINTER_NOTIFY_INFO_COLOR_MISMATCH, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_UserLevel1(struct ndr_push *ndr, int ndr_flags, const struct spoolss_UserLevel1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->size));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->client));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->user));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->build));
		NDR_CHECK(ndr_push_spoolss_MajorVersion(ndr, NDR_SCALARS, r->major));
		NDR_CHECK(ndr_push_spoolss_MinorVersion(ndr, NDR_SCALARS, r->minor));
		NDR_CHECK(ndr_push_spoolss_ProcessorArchitecture(ndr, NDR_SCALARS, r->processor));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->client) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->client, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->client, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->client, ndr_charset_length(r->client, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->user) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->user, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->user, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->user, ndr_charset_length(r->user, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_UserLevel1(struct ndr_pull *ndr, int ndr_flags, struct spoolss_UserLevel1 *r)
{
	uint32_t _ptr_client;
	TALLOC_CTX *_mem_save_client_0;
	uint32_t _ptr_user;
	TALLOC_CTX *_mem_save_user_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_client));
		if (_ptr_client) {
			NDR_PULL_ALLOC(ndr, r->client);
		} else {
			r->client = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_user));
		if (_ptr_user) {
			NDR_PULL_ALLOC(ndr, r->user);
		} else {
			r->user = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->build));
		NDR_CHECK(ndr_pull_spoolss_MajorVersion(ndr, NDR_SCALARS, &r->major));
		NDR_CHECK(ndr_pull_spoolss_MinorVersion(ndr, NDR_SCALARS, &r->minor));
		NDR_CHECK(ndr_pull_spoolss_ProcessorArchitecture(ndr, NDR_SCALARS, &r->processor));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->client) {
			_mem_save_client_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->client, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->client));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->client));
			if (ndr_get_array_length(ndr, &r->client) > ndr_get_array_size(ndr, &r->client)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->client), ndr_get_array_length(ndr, &r->client));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->client), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->client, ndr_get_array_length(ndr, &r->client), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_client_0, 0);
		}
		if (r->user) {
			_mem_save_user_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->user, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->user));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->user));
			if (ndr_get_array_length(ndr, &r->user) > ndr_get_array_size(ndr, &r->user)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->user), ndr_get_array_length(ndr, &r->user));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->user), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->user, ndr_get_array_length(ndr, &r->user), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_user_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_UserLevel1(struct ndr_print *ndr, const char *name, const struct spoolss_UserLevel1 *r)
{
	ndr_print_struct(ndr, name, "spoolss_UserLevel1");
	ndr->depth++;
	ndr_print_uint32(ndr, "size", r->size);
	ndr_print_ptr(ndr, "client", r->client);
	ndr->depth++;
	if (r->client) {
		ndr_print_string(ndr, "client", r->client);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "user", r->user);
	ndr->depth++;
	if (r->user) {
		ndr_print_string(ndr, "user", r->user);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "build", r->build);
	ndr_print_spoolss_MajorVersion(ndr, "major", r->major);
	ndr_print_spoolss_MinorVersion(ndr, "minor", r->minor);
	ndr_print_spoolss_ProcessorArchitecture(ndr, "processor", r->processor);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_UserLevel2(struct ndr_push *ndr, int ndr_flags, const struct spoolss_UserLevel2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->not_used));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_UserLevel2(struct ndr_pull *ndr, int ndr_flags, struct spoolss_UserLevel2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->not_used));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_UserLevel2(struct ndr_print *ndr, const char *name, const struct spoolss_UserLevel2 *r)
{
	ndr_print_struct(ndr, name, "spoolss_UserLevel2");
	ndr->depth++;
	ndr_print_uint32(ndr, "not_used", r->not_used);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_UserLevel3(struct ndr_push *ndr, int ndr_flags, const struct spoolss_UserLevel3 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->size));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->size2));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->client));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->user));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->build));
		NDR_CHECK(ndr_push_spoolss_MajorVersion(ndr, NDR_SCALARS, r->major));
		NDR_CHECK(ndr_push_spoolss_MinorVersion(ndr, NDR_SCALARS, r->minor));
		NDR_CHECK(ndr_push_spoolss_ProcessorArchitecture(ndr, NDR_SCALARS, r->processor));
		NDR_CHECK(ndr_push_udlong(ndr, NDR_SCALARS, r->reserved));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->client) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->client, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->client, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->client, ndr_charset_length(r->client, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->user) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->user, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->user, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->user, ndr_charset_length(r->user, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_UserLevel3(struct ndr_pull *ndr, int ndr_flags, struct spoolss_UserLevel3 *r)
{
	uint32_t _ptr_client;
	TALLOC_CTX *_mem_save_client_0;
	uint32_t _ptr_user;
	TALLOC_CTX *_mem_save_user_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->size2));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_client));
		if (_ptr_client) {
			NDR_PULL_ALLOC(ndr, r->client);
		} else {
			r->client = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_user));
		if (_ptr_user) {
			NDR_PULL_ALLOC(ndr, r->user);
		} else {
			r->user = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->build));
		NDR_CHECK(ndr_pull_spoolss_MajorVersion(ndr, NDR_SCALARS, &r->major));
		NDR_CHECK(ndr_pull_spoolss_MinorVersion(ndr, NDR_SCALARS, &r->minor));
		NDR_CHECK(ndr_pull_spoolss_ProcessorArchitecture(ndr, NDR_SCALARS, &r->processor));
		NDR_CHECK(ndr_pull_udlong(ndr, NDR_SCALARS, &r->reserved));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->client) {
			_mem_save_client_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->client, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->client));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->client));
			if (ndr_get_array_length(ndr, &r->client) > ndr_get_array_size(ndr, &r->client)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->client), ndr_get_array_length(ndr, &r->client));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->client), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->client, ndr_get_array_length(ndr, &r->client), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_client_0, 0);
		}
		if (r->user) {
			_mem_save_user_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->user, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->user));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->user));
			if (ndr_get_array_length(ndr, &r->user) > ndr_get_array_size(ndr, &r->user)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->user), ndr_get_array_length(ndr, &r->user));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->user), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->user, ndr_get_array_length(ndr, &r->user), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_user_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_UserLevel3(struct ndr_print *ndr, const char *name, const struct spoolss_UserLevel3 *r)
{
	ndr_print_struct(ndr, name, "spoolss_UserLevel3");
	ndr->depth++;
	ndr_print_uint32(ndr, "size", r->size);
	ndr_print_uint32(ndr, "flags", r->flags);
	ndr_print_uint32(ndr, "size2", r->size2);
	ndr_print_ptr(ndr, "client", r->client);
	ndr->depth++;
	if (r->client) {
		ndr_print_string(ndr, "client", r->client);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "user", r->user);
	ndr->depth++;
	if (r->user) {
		ndr_print_string(ndr, "user", r->user);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "build", r->build);
	ndr_print_spoolss_MajorVersion(ndr, "major", r->major);
	ndr_print_spoolss_MinorVersion(ndr, "minor", r->minor);
	ndr_print_spoolss_ProcessorArchitecture(ndr, "processor", r->processor);
	ndr_print_udlong(ndr, "reserved", r->reserved);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_UserLevel(struct ndr_push *ndr, int ndr_flags, const union spoolss_UserLevel *r)
{
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->level1));
			break; }

			case 2: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->level2));
			break; }

			case 3: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->level3));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 1:
				if (r->level1) {
					NDR_CHECK(ndr_push_spoolss_UserLevel1(ndr, NDR_SCALARS|NDR_BUFFERS, r->level1));
				}
			break;

			case 2:
				if (r->level2) {
					NDR_CHECK(ndr_push_spoolss_UserLevel2(ndr, NDR_SCALARS, r->level2));
				}
			break;

			case 3:
				if (r->level3) {
					NDR_CHECK(ndr_push_spoolss_UserLevel3(ndr, NDR_SCALARS|NDR_BUFFERS, r->level3));
				}
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_UserLevel(struct ndr_pull *ndr, int ndr_flags, union spoolss_UserLevel *r)
{
	int level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_level1_0;
	TALLOC_CTX *_mem_save_level2_0;
	TALLOC_CTX *_mem_save_level3_0;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r", _level);
		}
		switch (level) {
			case 1: {
				uint32_t _ptr_level1;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_level1));
				if (_ptr_level1) {
					NDR_PULL_ALLOC(ndr, r->level1);
				} else {
					r->level1 = NULL;
				}
			break; }

			case 2: {
				uint32_t _ptr_level2;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_level2));
				if (_ptr_level2) {
					NDR_PULL_ALLOC(ndr, r->level2);
				} else {
					r->level2 = NULL;
				}
			break; }

			case 3: {
				uint32_t _ptr_level3;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_level3));
				if (_ptr_level3) {
					NDR_PULL_ALLOC(ndr, r->level3);
				} else {
					r->level3 = NULL;
				}
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
				if (r->level1) {
					_mem_save_level1_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->level1, 0);
					NDR_CHECK(ndr_pull_spoolss_UserLevel1(ndr, NDR_SCALARS|NDR_BUFFERS, r->level1));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_level1_0, 0);
				}
			break;

			case 2:
				if (r->level2) {
					_mem_save_level2_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->level2, 0);
					NDR_CHECK(ndr_pull_spoolss_UserLevel2(ndr, NDR_SCALARS, r->level2));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_level2_0, 0);
				}
			break;

			case 3:
				if (r->level3) {
					_mem_save_level3_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->level3, 0);
					NDR_CHECK(ndr_pull_spoolss_UserLevel3(ndr, NDR_SCALARS|NDR_BUFFERS, r->level3));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_level3_0, 0);
				}
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_UserLevel(struct ndr_print *ndr, const char *name, const union spoolss_UserLevel *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "spoolss_UserLevel");
	switch (level) {
		case 1:
			ndr_print_ptr(ndr, "level1", r->level1);
			ndr->depth++;
			if (r->level1) {
				ndr_print_spoolss_UserLevel1(ndr, "level1", r->level1);
			}
			ndr->depth--;
		break;

		case 2:
			ndr_print_ptr(ndr, "level2", r->level2);
			ndr->depth++;
			if (r->level2) {
				ndr_print_spoolss_UserLevel2(ndr, "level2", r->level2);
			}
			ndr->depth--;
		break;

		case 3:
			ndr_print_ptr(ndr, "level3", r->level3);
			ndr->depth++;
			if (r->level3) {
				ndr_print_spoolss_UserLevel3(ndr, "level3", r->level3);
			}
			ndr->depth--;
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_spoolss_UserLevelCtr(struct ndr_push *ndr, int ndr_flags, const struct spoolss_UserLevelCtr *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->user_info, r->level));
		NDR_CHECK(ndr_push_spoolss_UserLevel(ndr, NDR_SCALARS, &r->user_info));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_spoolss_UserLevel(ndr, NDR_BUFFERS, &r->user_info));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_UserLevelCtr(struct ndr_pull *ndr, int ndr_flags, struct spoolss_UserLevelCtr *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->level));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->user_info, r->level));
		NDR_CHECK(ndr_pull_spoolss_UserLevel(ndr, NDR_SCALARS, &r->user_info));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_spoolss_UserLevel(ndr, NDR_BUFFERS, &r->user_info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_UserLevelCtr(struct ndr_print *ndr, const char *name, const struct spoolss_UserLevelCtr *r)
{
	ndr_print_struct(ndr, name, "spoolss_UserLevelCtr");
	ndr->depth++;
	ndr_print_uint32(ndr, "level", r->level);
	ndr_print_set_switch_value(ndr, &r->user_info, r->level);
	ndr_print_spoolss_UserLevel(ndr, "user_info", &r->user_info);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_AccessRights(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_AccessRights(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_AccessRights(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SERVER_ACCESS_ADMINISTER", SERVER_ACCESS_ADMINISTER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SERVER_ACCESS_ENUMERATE", SERVER_ACCESS_ENUMERATE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_ACCESS_ADMINISTER", PRINTER_ACCESS_ADMINISTER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "PRINTER_ACCESS_USE", PRINTER_ACCESS_USE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "JOB_ACCESS_ADMINISTER", JOB_ACCESS_ADMINISTER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "JOB_ACCESS_READ", JOB_ACCESS_READ, r);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_PrinterEnumValues(struct ndr_push *ndr, int ndr_flags, const struct spoolss_PrinterEnumValues *r)
{
	uint32_t _save_relative_base_offset = ndr_push_get_relative_base_offset(ndr);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_setup_relative_base_offset1(ndr, r, ndr->offset));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->value_name));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 2 * strlen_m_term(r->value_name)));
		NDR_CHECK(ndr_push_winreg_Type(ndr, NDR_SCALARS, r->type));
		NDR_CHECK(ndr_push_relative_ptr1(ndr, r->data));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_size_spoolss_PrinterData(r->data, r->type, ndr->iconv_convenience, ndr->flags)));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_setup_relative_base_offset2(ndr, r));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->value_name) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->value_name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->value_name));
			}
			ndr->flags = _flags_save_string;
		}
		if (r->data) {
			NDR_CHECK(ndr_push_relative_ptr2(ndr, r->data));
			{
				struct ndr_push *_ndr_data;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_data, 0, r->data_length));
				NDR_CHECK(ndr_push_set_switch_value(_ndr_data, r->data, r->type));
				NDR_CHECK(ndr_push_spoolss_PrinterData(_ndr_data, NDR_SCALARS|NDR_BUFFERS, r->data));
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_data, 0, r->data_length));
			}
		}
	}
	ndr_push_restore_relative_base_offset(ndr, _save_relative_base_offset);
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_PrinterEnumValues(struct ndr_pull *ndr, int ndr_flags, struct spoolss_PrinterEnumValues *r)
{
	uint32_t _save_relative_base_offset = ndr_pull_get_relative_base_offset(ndr);
	uint32_t _ptr_value_name;
	TALLOC_CTX *_mem_save_value_name_0;
	uint32_t _ptr_data;
	TALLOC_CTX *_mem_save_data_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_setup_relative_base_offset1(ndr, r, ndr->offset));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_value_name));
			if (_ptr_value_name) {
				NDR_PULL_ALLOC(ndr, r->value_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->value_name, _ptr_value_name));
			} else {
				r->value_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->value_name_len));
		NDR_CHECK(ndr_pull_winreg_Type(ndr, NDR_SCALARS, &r->type));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_data));
		if (_ptr_data) {
			NDR_PULL_ALLOC(ndr, r->data);
			NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->data, _ptr_data));
		} else {
			r->data = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->data_length));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_setup_relative_base_offset2(ndr, r));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			if (r->value_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->value_name));
				_mem_save_value_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->value_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->value_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_value_name_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		if (r->data) {
			uint32_t _relative_save_offset;
			_relative_save_offset = ndr->offset;
			NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->data));
			_mem_save_data_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->data, 0);
			{
				struct ndr_pull *_ndr_data;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_data, 0, r->data_length));
				NDR_CHECK(ndr_pull_set_switch_value(_ndr_data, r->data, r->type));
				NDR_CHECK(ndr_pull_spoolss_PrinterData(_ndr_data, NDR_SCALARS|NDR_BUFFERS, r->data));
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_data, 0, r->data_length));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_0, 0);
			ndr->offset = _relative_save_offset;
		}
	}
	ndr_pull_restore_relative_base_offset(ndr, _save_relative_base_offset);
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_PrinterEnumValues(struct ndr_print *ndr, const char *name, const struct spoolss_PrinterEnumValues *r)
{
	ndr_print_struct(ndr, name, "spoolss_PrinterEnumValues");
	ndr->depth++;
	ndr_print_ptr(ndr, "value_name", r->value_name);
	ndr->depth++;
	if (r->value_name) {
		ndr_print_string(ndr, "value_name", r->value_name);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "value_name_len", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?2 * strlen_m_term(r->value_name):r->value_name_len);
	ndr_print_winreg_Type(ndr, "type", r->type);
	ndr_print_ptr(ndr, "data", r->data);
	ndr->depth++;
	if (r->data) {
		ndr_print_set_switch_value(ndr, r->data, r->type);
		ndr_print_spoolss_PrinterData(ndr, "data", r->data);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "data_length", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_spoolss_PrinterData(r->data, r->type, ndr->iconv_convenience, ndr->flags):r->data_length);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_spoolss_PrinterEnumValues(const struct spoolss_PrinterEnumValues *r, struct smb_iconv_convenience *ic, int flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_spoolss_PrinterEnumValues, ic);
}

static enum ndr_err_code ndr_push_spoolss_KeyNames(struct ndr_push *ndr, int ndr_flags, const union spoolss_KeyNames *r)
{
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 0: {
			break; }

			case 1: {
			break; }

			default: {
				{
					uint32_t _flags_save_string_array = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
					NDR_CHECK(ndr_push_string_array(ndr, NDR_SCALARS, r->string_array));
					ndr->flags = _flags_save_string_array;
				}
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 0:
			break;

			case 1:
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_KeyNames(struct ndr_pull *ndr, int ndr_flags, union spoolss_KeyNames *r)
{
	int level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		switch (level) {
			case 0: {
			break; }

			case 1: {
			break; }

			default: {
				{
					uint32_t _flags_save_string_array = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
					NDR_CHECK(ndr_pull_string_array(ndr, NDR_SCALARS, &r->string_array));
					ndr->flags = _flags_save_string_array;
				}
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 0:
			break;

			case 1:
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_KeyNames(struct ndr_print *ndr, const char *name, const union spoolss_KeyNames *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "spoolss_KeyNames");
	switch (level) {
		case 0:
		break;

		case 1:
		break;

		default:
			ndr_print_string_array(ndr, "string_array", r->string_array);
		break;

	}
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_DeleteDriverFlags(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_DeleteDriverFlags(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_DeleteDriverFlags(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DPD_DELETE_UNUSED_FILES", DPD_DELETE_UNUSED_FILES, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DPD_DELETE_SPECIFIC_VERSION", DPD_DELETE_SPECIFIC_VERSION, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DPD_DELETE_ALL_FILES", DPD_DELETE_ALL_FILES, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_PortProtocol(struct ndr_push *ndr, int ndr_flags, enum spoolss_PortProtocol r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_PortProtocol(struct ndr_pull *ndr, int ndr_flags, enum spoolss_PortProtocol *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_PortProtocol(struct ndr_print *ndr, const char *name, enum spoolss_PortProtocol r)
{
	const char *val = NULL;

	switch (r) {
		case PROTOCOL_RAWTCP_TYPE: val = "PROTOCOL_RAWTCP_TYPE"; break;
		case PROTOCOL_LPR_TYPE: val = "PROTOCOL_LPR_TYPE"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_PortData1(struct ndr_push *ndr, int ndr_flags, const struct spoolss_PortData1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->portname, 64, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0x00000001));
		NDR_CHECK(ndr_push_spoolss_PortProtocol(ndr, NDR_SCALARS, r->protocol));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, sizeof(r)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->reserved));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->hostaddress, 49, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->snmpcommunity, 33, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dblspool));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->queue, 33, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->ip_address, 16, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->hardware_address, 13, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->device_type, 257, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->port_number));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->snmp_enabled));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->snmp_dev_index));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_PortData1(struct ndr_pull *ndr, int ndr_flags, struct spoolss_PortData1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->portname, 64, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_spoolss_PortProtocol(ndr, NDR_SCALARS, &r->protocol));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->hostaddress, 49, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->snmpcommunity, 33, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dblspool));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->queue, 33, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->ip_address, 16, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->hardware_address, 13, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->device_type, 257, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->port_number));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->snmp_enabled));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->snmp_dev_index));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_PortData1(struct ndr_print *ndr, const char *name, const struct spoolss_PortData1 *r)
{
	ndr_print_struct(ndr, name, "spoolss_PortData1");
	ndr->depth++;
	ndr_print_string(ndr, "portname", r->portname);
	ndr_print_uint32(ndr, "version", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0x00000001:r->version);
	ndr_print_spoolss_PortProtocol(ndr, "protocol", r->protocol);
	ndr_print_uint32(ndr, "size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?sizeof(r):r->size);
	ndr_print_uint32(ndr, "reserved", r->reserved);
	ndr_print_string(ndr, "hostaddress", r->hostaddress);
	ndr_print_string(ndr, "snmpcommunity", r->snmpcommunity);
	ndr_print_uint32(ndr, "dblspool", r->dblspool);
	ndr_print_string(ndr, "queue", r->queue);
	ndr_print_string(ndr, "ip_address", r->ip_address);
	ndr_print_string(ndr, "hardware_address", r->hardware_address);
	ndr_print_string(ndr, "device_type", r->device_type);
	ndr_print_uint32(ndr, "port_number", r->port_number);
	ndr_print_uint32(ndr, "snmp_enabled", r->snmp_enabled);
	ndr_print_uint32(ndr, "snmp_dev_index", r->snmp_dev_index);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_PortData2(struct ndr_push *ndr, int ndr_flags, const struct spoolss_PortData2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->portname, 64, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0x00000002));
		NDR_CHECK(ndr_push_spoolss_PortProtocol(ndr, NDR_SCALARS, r->protocol));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, sizeof(r)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->reserved));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->hostaddress, 128, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->snmpcommunity, 33, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dblspool));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->queue, 33, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->device_type, 257, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->port_number));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->snmp_enabled));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->snmp_dev_index));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->port_monitor_mib_index));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_PortData2(struct ndr_pull *ndr, int ndr_flags, struct spoolss_PortData2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->portname, 64, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_spoolss_PortProtocol(ndr, NDR_SCALARS, &r->protocol));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->hostaddress, 128, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->snmpcommunity, 33, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dblspool));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->queue, 33, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->device_type, 257, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->port_number));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->snmp_enabled));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->snmp_dev_index));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->port_monitor_mib_index));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_PortData2(struct ndr_print *ndr, const char *name, const struct spoolss_PortData2 *r)
{
	ndr_print_struct(ndr, name, "spoolss_PortData2");
	ndr->depth++;
	ndr_print_string(ndr, "portname", r->portname);
	ndr_print_uint32(ndr, "version", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0x00000002:r->version);
	ndr_print_spoolss_PortProtocol(ndr, "protocol", r->protocol);
	ndr_print_uint32(ndr, "size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?sizeof(r):r->size);
	ndr_print_uint32(ndr, "reserved", r->reserved);
	ndr_print_string(ndr, "hostaddress", r->hostaddress);
	ndr_print_string(ndr, "snmpcommunity", r->snmpcommunity);
	ndr_print_uint32(ndr, "dblspool", r->dblspool);
	ndr_print_string(ndr, "queue", r->queue);
	ndr_print_string(ndr, "device_type", r->device_type);
	ndr_print_uint32(ndr, "port_number", r->port_number);
	ndr_print_uint32(ndr, "snmp_enabled", r->snmp_enabled);
	ndr_print_uint32(ndr, "snmp_dev_index", r->snmp_dev_index);
	ndr_print_uint32(ndr, "port_monitor_mib_index", r->port_monitor_mib_index);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_MonitorUi(struct ndr_push *ndr, int ndr_flags, const struct spoolss_MonitorUi *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->dll_name));
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_MonitorUi(struct ndr_pull *ndr, int ndr_flags, struct spoolss_MonitorUi *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->dll_name));
			ndr->flags = _flags_save_string;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_MonitorUi(struct ndr_print *ndr, const char *name, const struct spoolss_MonitorUi *r)
{
	ndr_print_struct(ndr, name, "spoolss_MonitorUi");
	ndr->depth++;
	ndr_print_string(ndr, "dll_name", r->dll_name);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_AddPrinterDriverExFlags(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_AddPrinterDriverExFlags(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_AddPrinterDriverExFlags(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "APD_STRICT_UPGRADE", APD_STRICT_UPGRADE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "APD_STRICT_DOWNGRADE", APD_STRICT_DOWNGRADE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "APD_COPY_ALL_FILES", APD_COPY_ALL_FILES, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "APD_COPY_NEW_FILES", APD_COPY_NEW_FILES, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "APD_COPY_FROM_DIRECTORY", APD_COPY_FROM_DIRECTORY, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "APD_DONT_COPY_FILES_TO_CLUSTER", APD_DONT_COPY_FILES_TO_CLUSTER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "APD_COPY_TO_ALL_SPOOLERS", APD_COPY_TO_ALL_SPOOLERS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "APD_RETURN_BLOCKING_STATUS_CODE", APD_RETURN_BLOCKING_STATUS_CODE, r);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push__spoolss_EnumPrinters(struct ndr_push *ndr, int flags, const struct _spoolss_EnumPrinters *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_spoolss_EnumPrinterFlags(ndr, NDR_SCALARS, r->in.flags));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server));
		if (r->in.server) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.server, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.server, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server, ndr_charset_length(r->in.server, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.buffer));
		if (r->in.buffer) {
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, *r->in.buffer));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.offered));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.info));
		if (r->out.info) {
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, *r->out.info));
		}
		if (r->out.needed == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.needed));
		if (r->out.count == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.count));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull__spoolss_EnumPrinters(struct ndr_pull *ndr, int flags, struct _spoolss_EnumPrinters *r)
{
	uint32_t _ptr_server;
	uint32_t _ptr_buffer;
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_server_0;
	TALLOC_CTX *_mem_save_buffer_0;
	TALLOC_CTX *_mem_save_info_0;
	TALLOC_CTX *_mem_save_needed_0;
	TALLOC_CTX *_mem_save_count_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_spoolss_EnumPrinterFlags(ndr, NDR_SCALARS, &r->in.flags));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server));
		if (_ptr_server) {
			NDR_PULL_ALLOC(ndr, r->in.server);
		} else {
			r->in.server = NULL;
		}
		if (r->in.server) {
			_mem_save_server_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server));
			if (ndr_get_array_length(ndr, &r->in.server) > ndr_get_array_size(ndr, &r->in.server)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server), ndr_get_array_length(ndr, &r->in.server));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server, ndr_get_array_length(ndr, &r->in.server), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_buffer));
		if (_ptr_buffer) {
			NDR_PULL_ALLOC(ndr, r->in.buffer);
		} else {
			r->in.buffer = NULL;
		}
		if (r->in.buffer) {
			_mem_save_buffer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.buffer, 0);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, r->in.buffer));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_buffer_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.offered));
		NDR_PULL_ALLOC(ndr, r->out.needed);
		ZERO_STRUCTP(r->out.needed);
		NDR_PULL_ALLOC(ndr, r->out.count);
		ZERO_STRUCTP(r->out.count);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		} else {
			r->out.info = NULL;
		}
		if (r->out.info) {
			_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.info, 0);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, r->out.info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.needed);
		}
		_mem_save_needed_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.needed, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.needed));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_needed_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.count);
		}
		_mem_save_count_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.count, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.count));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_count_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_push___spoolss_EnumPrinters(struct ndr_push *ndr, int flags, const struct __spoolss_EnumPrinters *r)
{
	uint32_t cntr_info_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.count));
	}
	if (flags & NDR_OUT) {
		for (cntr_info_0 = 0; cntr_info_0 < r->in.count; cntr_info_0++) {
			NDR_CHECK(ndr_push_set_switch_value(ndr, &r->out.info[cntr_info_0], r->in.level));
			NDR_CHECK(ndr_push_spoolss_PrinterInfo(ndr, NDR_SCALARS, &r->out.info[cntr_info_0]));
		}
		for (cntr_info_0 = 0; cntr_info_0 < r->in.count; cntr_info_0++) {
			NDR_CHECK(ndr_push_spoolss_PrinterInfo(ndr, NDR_BUFFERS, &r->out.info[cntr_info_0]));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull___spoolss_EnumPrinters(struct ndr_pull *ndr, int flags, struct __spoolss_EnumPrinters *r)
{
	uint32_t cntr_info_0;
	TALLOC_CTX *_mem_save_info_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.count));
	}
	if (flags & NDR_OUT) {
		NDR_PULL_ALLOC_N(ndr, r->out.info, r->in.count);
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, 0);
		for (cntr_info_0 = 0; cntr_info_0 < r->in.count; cntr_info_0++) {
			NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->out.info[cntr_info_0], r->in.level));
			NDR_CHECK(ndr_pull_spoolss_PrinterInfo(ndr, NDR_SCALARS, &r->out.info[cntr_info_0]));
		}
		for (cntr_info_0 = 0; cntr_info_0 < r->in.count; cntr_info_0++) {
			NDR_CHECK(ndr_pull_spoolss_PrinterInfo(ndr, NDR_BUFFERS, &r->out.info[cntr_info_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_EnumPrinters(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_EnumPrinters *r)
{
	uint32_t cntr_info_2;
	ndr_print_struct(ndr, name, "spoolss_EnumPrinters");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_EnumPrinters");
		ndr->depth++;
		ndr_print_spoolss_EnumPrinterFlags(ndr, "flags", r->in.flags);
		ndr_print_ptr(ndr, "server", r->in.server);
		ndr->depth++;
		if (r->in.server) {
			ndr_print_string(ndr, "server", r->in.server);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		if (r->in.buffer) {
			ndr_print_DATA_BLOB(ndr, "buffer", *r->in.buffer);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "offered", r->in.offered);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_EnumPrinters");
		ndr->depth++;
		ndr_print_ptr(ndr, "count", r->out.count);
		ndr->depth++;
		ndr_print_uint32(ndr, "count", *r->out.count);
		ndr->depth--;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		ndr_print_ptr(ndr, "info", *r->out.info);
		ndr->depth++;
		if (*r->out.info) {
			ndr->print(ndr, "%s: ARRAY(%d)", "info", (int)*r->out.count);
			ndr->depth++;
			for (cntr_info_2=0;cntr_info_2<*r->out.count;cntr_info_2++) {
				char *idx_2=NULL;
				if (asprintf(&idx_2, "[%d]", cntr_info_2) != -1) {
					ndr_print_set_switch_value(ndr, &(*r->out.info)[cntr_info_2], r->in.level);
					ndr_print_spoolss_PrinterInfo(ndr, "info", &(*r->out.info)[cntr_info_2]);
					free(idx_2);
				}
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "needed", r->out.needed);
		ndr->depth++;
		ndr_print_uint32(ndr, "needed", *r->out.needed);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_OpenPrinter(struct ndr_push *ndr, int flags, const struct spoolss_OpenPrinter *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.printername));
		if (r->in.printername) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.printername, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.printername, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.printername, ndr_charset_length(r->in.printername, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.datatype));
		if (r->in.datatype) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.datatype, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.datatype, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.datatype, ndr_charset_length(r->in.datatype, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_spoolss_DevmodeContainer(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.devmode_ctr));
		NDR_CHECK(ndr_push_spoolss_AccessRights(ndr, NDR_SCALARS, r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		if (r->out.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_OpenPrinter(struct ndr_pull *ndr, int flags, struct spoolss_OpenPrinter *r)
{
	uint32_t _ptr_printername;
	uint32_t _ptr_datatype;
	TALLOC_CTX *_mem_save_printername_0;
	TALLOC_CTX *_mem_save_datatype_0;
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_printername));
		if (_ptr_printername) {
			NDR_PULL_ALLOC(ndr, r->in.printername);
		} else {
			r->in.printername = NULL;
		}
		if (r->in.printername) {
			_mem_save_printername_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.printername, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.printername));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.printername));
			if (ndr_get_array_length(ndr, &r->in.printername) > ndr_get_array_size(ndr, &r->in.printername)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.printername), ndr_get_array_length(ndr, &r->in.printername));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.printername), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.printername, ndr_get_array_length(ndr, &r->in.printername), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_printername_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_datatype));
		if (_ptr_datatype) {
			NDR_PULL_ALLOC(ndr, r->in.datatype);
		} else {
			r->in.datatype = NULL;
		}
		if (r->in.datatype) {
			_mem_save_datatype_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.datatype, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.datatype));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.datatype));
			if (ndr_get_array_length(ndr, &r->in.datatype) > ndr_get_array_size(ndr, &r->in.datatype)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.datatype), ndr_get_array_length(ndr, &r->in.datatype));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.datatype), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.datatype, ndr_get_array_length(ndr, &r->in.datatype), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_datatype_0, 0);
		}
		NDR_CHECK(ndr_pull_spoolss_DevmodeContainer(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.devmode_ctr));
		NDR_CHECK(ndr_pull_spoolss_AccessRights(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_PULL_ALLOC(ndr, r->out.handle);
		ZERO_STRUCTP(r->out.handle);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_OpenPrinter(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_OpenPrinter *r)
{
	ndr_print_struct(ndr, name, "spoolss_OpenPrinter");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_OpenPrinter");
		ndr->depth++;
		ndr_print_ptr(ndr, "printername", r->in.printername);
		ndr->depth++;
		if (r->in.printername) {
			ndr_print_string(ndr, "printername", r->in.printername);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "datatype", r->in.datatype);
		ndr->depth++;
		if (r->in.datatype) {
			ndr_print_string(ndr, "datatype", r->in.datatype);
		}
		ndr->depth--;
		ndr_print_spoolss_DevmodeContainer(ndr, "devmode_ctr", &r->in.devmode_ctr);
		ndr_print_spoolss_AccessRights(ndr, "access_mask", r->in.access_mask);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_OpenPrinter");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->out.handle);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_SetJob(struct ndr_push *ndr, int flags, const struct spoolss_SetJob *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.job_id));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.ctr));
		if (r->in.ctr) {
			NDR_CHECK(ndr_push_spoolss_JobInfoContainer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.ctr));
		}
		NDR_CHECK(ndr_push_spoolss_JobControl(ndr, NDR_SCALARS, r->in.command));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_SetJob(struct ndr_pull *ndr, int flags, struct spoolss_SetJob *r)
{
	uint32_t _ptr_ctr;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_ctr_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.job_id));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ctr));
		if (_ptr_ctr) {
			NDR_PULL_ALLOC(ndr, r->in.ctr);
		} else {
			r->in.ctr = NULL;
		}
		if (r->in.ctr) {
			_mem_save_ctr_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.ctr, 0);
			NDR_CHECK(ndr_pull_spoolss_JobInfoContainer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.ctr));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctr_0, 0);
		}
		NDR_CHECK(ndr_pull_spoolss_JobControl(ndr, NDR_SCALARS, &r->in.command));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_SetJob(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_SetJob *r)
{
	ndr_print_struct(ndr, name, "spoolss_SetJob");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_SetJob");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "job_id", r->in.job_id);
		ndr_print_ptr(ndr, "ctr", r->in.ctr);
		ndr->depth++;
		if (r->in.ctr) {
			ndr_print_spoolss_JobInfoContainer(ndr, "ctr", r->in.ctr);
		}
		ndr->depth--;
		ndr_print_spoolss_JobControl(ndr, "command", r->in.command);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_SetJob");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_GetJob(struct ndr_push *ndr, int flags, const struct spoolss_GetJob *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.job_id));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.buffer));
		if (r->in.buffer) {
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, *r->in.buffer));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.offered));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.info));
		if (r->out.info) {
			{
				struct ndr_push *_ndr_info;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_info, 4, r->in.offered));
				NDR_CHECK(ndr_push_set_switch_value(_ndr_info, r->out.info, r->in.level));
				NDR_CHECK(ndr_push_spoolss_JobInfo(_ndr_info, NDR_SCALARS|NDR_BUFFERS, r->out.info));
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_info, 4, r->in.offered));
			}
		}
		if (r->out.needed == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.needed));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_GetJob(struct ndr_pull *ndr, int flags, struct spoolss_GetJob *r)
{
	uint32_t _ptr_buffer;
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_buffer_0;
	TALLOC_CTX *_mem_save_info_0;
	TALLOC_CTX *_mem_save_needed_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.job_id));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_buffer));
		if (_ptr_buffer) {
			NDR_PULL_ALLOC(ndr, r->in.buffer);
		} else {
			r->in.buffer = NULL;
		}
		if (r->in.buffer) {
			_mem_save_buffer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.buffer, 0);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, r->in.buffer));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_buffer_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.offered));
		NDR_PULL_ALLOC(ndr, r->out.needed);
		ZERO_STRUCTP(r->out.needed);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		} else {
			r->out.info = NULL;
		}
		if (r->out.info) {
			_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.info, 0);
			{
				struct ndr_pull *_ndr_info;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_info, 4, r->in.offered));
				NDR_CHECK(ndr_pull_set_switch_value(_ndr_info, r->out.info, r->in.level));
				NDR_CHECK(ndr_pull_spoolss_JobInfo(_ndr_info, NDR_SCALARS|NDR_BUFFERS, r->out.info));
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_info, 4, r->in.offered));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.needed);
		}
		_mem_save_needed_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.needed, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.needed));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_needed_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_GetJob(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_GetJob *r)
{
	ndr_print_struct(ndr, name, "spoolss_GetJob");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_GetJob");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "job_id", r->in.job_id);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		if (r->in.buffer) {
			ndr_print_DATA_BLOB(ndr, "buffer", *r->in.buffer);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "offered", r->in.offered);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_GetJob");
		ndr->depth++;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		if (r->out.info) {
			ndr_print_set_switch_value(ndr, r->out.info, r->in.level);
			ndr_print_spoolss_JobInfo(ndr, "info", r->out.info);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "needed", r->out.needed);
		ndr->depth++;
		ndr_print_uint32(ndr, "needed", *r->out.needed);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push__spoolss_EnumJobs(struct ndr_push *ndr, int flags, const struct _spoolss_EnumJobs *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.firstjob));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.numjobs));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.buffer));
		if (r->in.buffer) {
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, *r->in.buffer));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.offered));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.info));
		if (r->out.info) {
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, *r->out.info));
		}
		if (r->out.needed == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.needed));
		if (r->out.count == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.count));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull__spoolss_EnumJobs(struct ndr_pull *ndr, int flags, struct _spoolss_EnumJobs *r)
{
	uint32_t _ptr_buffer;
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_buffer_0;
	TALLOC_CTX *_mem_save_info_0;
	TALLOC_CTX *_mem_save_needed_0;
	TALLOC_CTX *_mem_save_count_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.firstjob));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.numjobs));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_buffer));
		if (_ptr_buffer) {
			NDR_PULL_ALLOC(ndr, r->in.buffer);
		} else {
			r->in.buffer = NULL;
		}
		if (r->in.buffer) {
			_mem_save_buffer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.buffer, 0);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, r->in.buffer));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_buffer_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.offered));
		NDR_PULL_ALLOC(ndr, r->out.needed);
		ZERO_STRUCTP(r->out.needed);
		NDR_PULL_ALLOC(ndr, r->out.count);
		ZERO_STRUCTP(r->out.count);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		} else {
			r->out.info = NULL;
		}
		if (r->out.info) {
			_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.info, 0);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, r->out.info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.needed);
		}
		_mem_save_needed_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.needed, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.needed));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_needed_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.count);
		}
		_mem_save_count_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.count, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.count));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_count_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_push___spoolss_EnumJobs(struct ndr_push *ndr, int flags, const struct __spoolss_EnumJobs *r)
{
	uint32_t cntr_info_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.count));
	}
	if (flags & NDR_OUT) {
		for (cntr_info_0 = 0; cntr_info_0 < r->in.count; cntr_info_0++) {
			NDR_CHECK(ndr_push_set_switch_value(ndr, &r->out.info[cntr_info_0], r->in.level));
			NDR_CHECK(ndr_push_spoolss_JobInfo(ndr, NDR_SCALARS, &r->out.info[cntr_info_0]));
		}
		for (cntr_info_0 = 0; cntr_info_0 < r->in.count; cntr_info_0++) {
			NDR_CHECK(ndr_push_spoolss_JobInfo(ndr, NDR_BUFFERS, &r->out.info[cntr_info_0]));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull___spoolss_EnumJobs(struct ndr_pull *ndr, int flags, struct __spoolss_EnumJobs *r)
{
	uint32_t cntr_info_0;
	TALLOC_CTX *_mem_save_info_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.count));
	}
	if (flags & NDR_OUT) {
		NDR_PULL_ALLOC_N(ndr, r->out.info, r->in.count);
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, 0);
		for (cntr_info_0 = 0; cntr_info_0 < r->in.count; cntr_info_0++) {
			NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->out.info[cntr_info_0], r->in.level));
			NDR_CHECK(ndr_pull_spoolss_JobInfo(ndr, NDR_SCALARS, &r->out.info[cntr_info_0]));
		}
		for (cntr_info_0 = 0; cntr_info_0 < r->in.count; cntr_info_0++) {
			NDR_CHECK(ndr_pull_spoolss_JobInfo(ndr, NDR_BUFFERS, &r->out.info[cntr_info_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_EnumJobs(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_EnumJobs *r)
{
	uint32_t cntr_info_2;
	ndr_print_struct(ndr, name, "spoolss_EnumJobs");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_EnumJobs");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "firstjob", r->in.firstjob);
		ndr_print_uint32(ndr, "numjobs", r->in.numjobs);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		if (r->in.buffer) {
			ndr_print_DATA_BLOB(ndr, "buffer", *r->in.buffer);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "offered", r->in.offered);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_EnumJobs");
		ndr->depth++;
		ndr_print_ptr(ndr, "count", r->out.count);
		ndr->depth++;
		ndr_print_uint32(ndr, "count", *r->out.count);
		ndr->depth--;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		ndr_print_ptr(ndr, "info", *r->out.info);
		ndr->depth++;
		if (*r->out.info) {
			ndr->print(ndr, "%s: ARRAY(%d)", "info", (int)*r->out.count);
			ndr->depth++;
			for (cntr_info_2=0;cntr_info_2<*r->out.count;cntr_info_2++) {
				char *idx_2=NULL;
				if (asprintf(&idx_2, "[%d]", cntr_info_2) != -1) {
					ndr_print_set_switch_value(ndr, &(*r->out.info)[cntr_info_2], r->in.level);
					ndr_print_spoolss_JobInfo(ndr, "info", &(*r->out.info)[cntr_info_2]);
					free(idx_2);
				}
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "needed", r->out.needed);
		ndr->depth++;
		ndr_print_uint32(ndr, "needed", *r->out.needed);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_AddPrinter(struct ndr_push *ndr, int flags, const struct spoolss_AddPrinter *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_AddPrinter(struct ndr_pull *ndr, int flags, struct spoolss_AddPrinter *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_AddPrinter(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_AddPrinter *r)
{
	ndr_print_struct(ndr, name, "spoolss_AddPrinter");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_AddPrinter");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_AddPrinter");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_DeletePrinter(struct ndr_push *ndr, int flags, const struct spoolss_DeletePrinter *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_DeletePrinter(struct ndr_pull *ndr, int flags, struct spoolss_DeletePrinter *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_DeletePrinter(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_DeletePrinter *r)
{
	ndr_print_struct(ndr, name, "spoolss_DeletePrinter");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_DeletePrinter");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_DeletePrinter");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_SetPrinter(struct ndr_push *ndr, int flags, const struct spoolss_SetPrinter *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		if (r->in.info_ctr == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_spoolss_SetPrinterInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info_ctr));
		if (r->in.devmode_ctr == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_spoolss_DevmodeContainer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.devmode_ctr));
		if (r->in.secdesc_ctr == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_sec_desc_buf(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.secdesc_ctr));
		NDR_CHECK(ndr_push_spoolss_PrinterControl(ndr, NDR_SCALARS, r->in.command));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_SetPrinter(struct ndr_pull *ndr, int flags, struct spoolss_SetPrinter *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_info_ctr_0;
	TALLOC_CTX *_mem_save_devmode_ctr_0;
	TALLOC_CTX *_mem_save_secdesc_ctr_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.info_ctr);
		}
		_mem_save_info_ctr_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.info_ctr, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_spoolss_SetPrinterInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info_ctr));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_ctr_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.devmode_ctr);
		}
		_mem_save_devmode_ctr_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.devmode_ctr, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_spoolss_DevmodeContainer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.devmode_ctr));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_devmode_ctr_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.secdesc_ctr);
		}
		_mem_save_secdesc_ctr_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.secdesc_ctr, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_sec_desc_buf(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.secdesc_ctr));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_secdesc_ctr_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_spoolss_PrinterControl(ndr, NDR_SCALARS, &r->in.command));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_SetPrinter(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_SetPrinter *r)
{
	ndr_print_struct(ndr, name, "spoolss_SetPrinter");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_SetPrinter");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "info_ctr", r->in.info_ctr);
		ndr->depth++;
		ndr_print_spoolss_SetPrinterInfoCtr(ndr, "info_ctr", r->in.info_ctr);
		ndr->depth--;
		ndr_print_ptr(ndr, "devmode_ctr", r->in.devmode_ctr);
		ndr->depth++;
		ndr_print_spoolss_DevmodeContainer(ndr, "devmode_ctr", r->in.devmode_ctr);
		ndr->depth--;
		ndr_print_ptr(ndr, "secdesc_ctr", r->in.secdesc_ctr);
		ndr->depth++;
		ndr_print_sec_desc_buf(ndr, "secdesc_ctr", r->in.secdesc_ctr);
		ndr->depth--;
		ndr_print_spoolss_PrinterControl(ndr, "command", r->in.command);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_SetPrinter");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_GetPrinter(struct ndr_push *ndr, int flags, const struct spoolss_GetPrinter *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.buffer));
		if (r->in.buffer) {
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, *r->in.buffer));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.offered));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.info));
		if (r->out.info) {
			{
				struct ndr_push *_ndr_info;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_info, 4, r->in.offered));
				NDR_CHECK(ndr_push_set_switch_value(_ndr_info, r->out.info, r->in.level));
				NDR_CHECK(ndr_push_spoolss_PrinterInfo(_ndr_info, NDR_SCALARS|NDR_BUFFERS, r->out.info));
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_info, 4, r->in.offered));
			}
		}
		if (r->out.needed == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.needed));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_GetPrinter(struct ndr_pull *ndr, int flags, struct spoolss_GetPrinter *r)
{
	uint32_t _ptr_buffer;
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_buffer_0;
	TALLOC_CTX *_mem_save_info_0;
	TALLOC_CTX *_mem_save_needed_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_buffer));
		if (_ptr_buffer) {
			NDR_PULL_ALLOC(ndr, r->in.buffer);
		} else {
			r->in.buffer = NULL;
		}
		if (r->in.buffer) {
			_mem_save_buffer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.buffer, 0);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, r->in.buffer));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_buffer_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.offered));
		NDR_PULL_ALLOC(ndr, r->out.needed);
		ZERO_STRUCTP(r->out.needed);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		} else {
			r->out.info = NULL;
		}
		if (r->out.info) {
			_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.info, 0);
			{
				struct ndr_pull *_ndr_info;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_info, 4, r->in.offered));
				NDR_CHECK(ndr_pull_set_switch_value(_ndr_info, r->out.info, r->in.level));
				NDR_CHECK(ndr_pull_spoolss_PrinterInfo(_ndr_info, NDR_SCALARS|NDR_BUFFERS, r->out.info));
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_info, 4, r->in.offered));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.needed);
		}
		_mem_save_needed_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.needed, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.needed));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_needed_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_GetPrinter(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_GetPrinter *r)
{
	ndr_print_struct(ndr, name, "spoolss_GetPrinter");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_GetPrinter");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		if (r->in.buffer) {
			ndr_print_DATA_BLOB(ndr, "buffer", *r->in.buffer);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "offered", r->in.offered);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_GetPrinter");
		ndr->depth++;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		if (r->out.info) {
			ndr_print_set_switch_value(ndr, r->out.info, r->in.level);
			ndr_print_spoolss_PrinterInfo(ndr, "info", r->out.info);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "needed", r->out.needed);
		ndr->depth++;
		ndr_print_uint32(ndr, "needed", *r->out.needed);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_AddPrinterDriver(struct ndr_push *ndr, int flags, const struct spoolss_AddPrinterDriver *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.servername));
		if (r->in.servername) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.servername, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.servername, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.servername, ndr_charset_length(r->in.servername, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->in.info_ctr == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_spoolss_AddDriverInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info_ctr));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_AddPrinterDriver(struct ndr_pull *ndr, int flags, struct spoolss_AddPrinterDriver *r)
{
	uint32_t _ptr_servername;
	TALLOC_CTX *_mem_save_servername_0;
	TALLOC_CTX *_mem_save_info_ctr_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_servername));
		if (_ptr_servername) {
			NDR_PULL_ALLOC(ndr, r->in.servername);
		} else {
			r->in.servername = NULL;
		}
		if (r->in.servername) {
			_mem_save_servername_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.servername, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.servername));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.servername));
			if (ndr_get_array_length(ndr, &r->in.servername) > ndr_get_array_size(ndr, &r->in.servername)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.servername), ndr_get_array_length(ndr, &r->in.servername));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.servername), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.servername, ndr_get_array_length(ndr, &r->in.servername), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_servername_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.info_ctr);
		}
		_mem_save_info_ctr_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.info_ctr, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_spoolss_AddDriverInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info_ctr));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_ctr_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_AddPrinterDriver(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_AddPrinterDriver *r)
{
	ndr_print_struct(ndr, name, "spoolss_AddPrinterDriver");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_AddPrinterDriver");
		ndr->depth++;
		ndr_print_ptr(ndr, "servername", r->in.servername);
		ndr->depth++;
		if (r->in.servername) {
			ndr_print_string(ndr, "servername", r->in.servername);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "info_ctr", r->in.info_ctr);
		ndr->depth++;
		ndr_print_spoolss_AddDriverInfoCtr(ndr, "info_ctr", r->in.info_ctr);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_AddPrinterDriver");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push__spoolss_EnumPrinterDrivers(struct ndr_push *ndr, int flags, const struct _spoolss_EnumPrinterDrivers *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server));
		if (r->in.server) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.server, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.server, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server, ndr_charset_length(r->in.server, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.environment));
		if (r->in.environment) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.environment, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.environment, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.environment, ndr_charset_length(r->in.environment, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.buffer));
		if (r->in.buffer) {
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, *r->in.buffer));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.offered));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.info));
		if (r->out.info) {
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, *r->out.info));
		}
		if (r->out.needed == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.needed));
		if (r->out.count == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.count));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull__spoolss_EnumPrinterDrivers(struct ndr_pull *ndr, int flags, struct _spoolss_EnumPrinterDrivers *r)
{
	uint32_t _ptr_server;
	uint32_t _ptr_environment;
	uint32_t _ptr_buffer;
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_server_0;
	TALLOC_CTX *_mem_save_environment_0;
	TALLOC_CTX *_mem_save_buffer_0;
	TALLOC_CTX *_mem_save_info_0;
	TALLOC_CTX *_mem_save_needed_0;
	TALLOC_CTX *_mem_save_count_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server));
		if (_ptr_server) {
			NDR_PULL_ALLOC(ndr, r->in.server);
		} else {
			r->in.server = NULL;
		}
		if (r->in.server) {
			_mem_save_server_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server));
			if (ndr_get_array_length(ndr, &r->in.server) > ndr_get_array_size(ndr, &r->in.server)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server), ndr_get_array_length(ndr, &r->in.server));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server, ndr_get_array_length(ndr, &r->in.server), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_environment));
		if (_ptr_environment) {
			NDR_PULL_ALLOC(ndr, r->in.environment);
		} else {
			r->in.environment = NULL;
		}
		if (r->in.environment) {
			_mem_save_environment_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.environment, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.environment));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.environment));
			if (ndr_get_array_length(ndr, &r->in.environment) > ndr_get_array_size(ndr, &r->in.environment)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.environment), ndr_get_array_length(ndr, &r->in.environment));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.environment), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.environment, ndr_get_array_length(ndr, &r->in.environment), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_environment_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_buffer));
		if (_ptr_buffer) {
			NDR_PULL_ALLOC(ndr, r->in.buffer);
		} else {
			r->in.buffer = NULL;
		}
		if (r->in.buffer) {
			_mem_save_buffer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.buffer, 0);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, r->in.buffer));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_buffer_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.offered));
		NDR_PULL_ALLOC(ndr, r->out.needed);
		ZERO_STRUCTP(r->out.needed);
		NDR_PULL_ALLOC(ndr, r->out.count);
		ZERO_STRUCTP(r->out.count);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		} else {
			r->out.info = NULL;
		}
		if (r->out.info) {
			_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.info, 0);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, r->out.info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.needed);
		}
		_mem_save_needed_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.needed, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.needed));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_needed_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.count);
		}
		_mem_save_count_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.count, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.count));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_count_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_push___spoolss_EnumPrinterDrivers(struct ndr_push *ndr, int flags, const struct __spoolss_EnumPrinterDrivers *r)
{
	uint32_t cntr_info_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.count));
	}
	if (flags & NDR_OUT) {
		for (cntr_info_0 = 0; cntr_info_0 < r->in.count; cntr_info_0++) {
			NDR_CHECK(ndr_push_set_switch_value(ndr, &r->out.info[cntr_info_0], r->in.level));
			NDR_CHECK(ndr_push_spoolss_DriverInfo(ndr, NDR_SCALARS, &r->out.info[cntr_info_0]));
		}
		for (cntr_info_0 = 0; cntr_info_0 < r->in.count; cntr_info_0++) {
			NDR_CHECK(ndr_push_spoolss_DriverInfo(ndr, NDR_BUFFERS, &r->out.info[cntr_info_0]));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull___spoolss_EnumPrinterDrivers(struct ndr_pull *ndr, int flags, struct __spoolss_EnumPrinterDrivers *r)
{
	uint32_t cntr_info_0;
	TALLOC_CTX *_mem_save_info_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.count));
	}
	if (flags & NDR_OUT) {
		NDR_PULL_ALLOC_N(ndr, r->out.info, r->in.count);
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, 0);
		for (cntr_info_0 = 0; cntr_info_0 < r->in.count; cntr_info_0++) {
			NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->out.info[cntr_info_0], r->in.level));
			NDR_CHECK(ndr_pull_spoolss_DriverInfo(ndr, NDR_SCALARS, &r->out.info[cntr_info_0]));
		}
		for (cntr_info_0 = 0; cntr_info_0 < r->in.count; cntr_info_0++) {
			NDR_CHECK(ndr_pull_spoolss_DriverInfo(ndr, NDR_BUFFERS, &r->out.info[cntr_info_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_EnumPrinterDrivers(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_EnumPrinterDrivers *r)
{
	uint32_t cntr_info_2;
	ndr_print_struct(ndr, name, "spoolss_EnumPrinterDrivers");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_EnumPrinterDrivers");
		ndr->depth++;
		ndr_print_ptr(ndr, "server", r->in.server);
		ndr->depth++;
		if (r->in.server) {
			ndr_print_string(ndr, "server", r->in.server);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "environment", r->in.environment);
		ndr->depth++;
		if (r->in.environment) {
			ndr_print_string(ndr, "environment", r->in.environment);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		if (r->in.buffer) {
			ndr_print_DATA_BLOB(ndr, "buffer", *r->in.buffer);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "offered", r->in.offered);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_EnumPrinterDrivers");
		ndr->depth++;
		ndr_print_ptr(ndr, "count", r->out.count);
		ndr->depth++;
		ndr_print_uint32(ndr, "count", *r->out.count);
		ndr->depth--;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		ndr_print_ptr(ndr, "info", *r->out.info);
		ndr->depth++;
		if (*r->out.info) {
			ndr->print(ndr, "%s: ARRAY(%d)", "info", (int)*r->out.count);
			ndr->depth++;
			for (cntr_info_2=0;cntr_info_2<*r->out.count;cntr_info_2++) {
				char *idx_2=NULL;
				if (asprintf(&idx_2, "[%d]", cntr_info_2) != -1) {
					ndr_print_set_switch_value(ndr, &(*r->out.info)[cntr_info_2], r->in.level);
					ndr_print_spoolss_DriverInfo(ndr, "info", &(*r->out.info)[cntr_info_2]);
					free(idx_2);
				}
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "needed", r->out.needed);
		ndr->depth++;
		ndr_print_uint32(ndr, "needed", *r->out.needed);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_GetPrinterDriver(struct ndr_push *ndr, int flags, const struct spoolss_GetPrinterDriver *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_GetPrinterDriver(struct ndr_pull *ndr, int flags, struct spoolss_GetPrinterDriver *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_GetPrinterDriver(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_GetPrinterDriver *r)
{
	ndr_print_struct(ndr, name, "spoolss_GetPrinterDriver");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_GetPrinterDriver");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_GetPrinterDriver");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_GetPrinterDriverDirectory(struct ndr_push *ndr, int flags, const struct spoolss_GetPrinterDriverDirectory *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server));
		if (r->in.server) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.server, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.server, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server, ndr_charset_length(r->in.server, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.environment));
		if (r->in.environment) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.environment, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.environment, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.environment, ndr_charset_length(r->in.environment, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.buffer));
		if (r->in.buffer) {
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, *r->in.buffer));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.offered));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.info));
		if (r->out.info) {
			{
				struct ndr_push *_ndr_info;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_info, 4, r->in.offered));
				NDR_CHECK(ndr_push_set_switch_value(_ndr_info, r->out.info, r->in.level));
				NDR_CHECK(ndr_push_spoolss_DriverDirectoryInfo(_ndr_info, NDR_SCALARS, r->out.info));
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_info, 4, r->in.offered));
			}
		}
		if (r->out.needed == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.needed));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_GetPrinterDriverDirectory(struct ndr_pull *ndr, int flags, struct spoolss_GetPrinterDriverDirectory *r)
{
	uint32_t _ptr_server;
	uint32_t _ptr_environment;
	uint32_t _ptr_buffer;
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_server_0;
	TALLOC_CTX *_mem_save_environment_0;
	TALLOC_CTX *_mem_save_buffer_0;
	TALLOC_CTX *_mem_save_info_0;
	TALLOC_CTX *_mem_save_needed_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server));
		if (_ptr_server) {
			NDR_PULL_ALLOC(ndr, r->in.server);
		} else {
			r->in.server = NULL;
		}
		if (r->in.server) {
			_mem_save_server_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server));
			if (ndr_get_array_length(ndr, &r->in.server) > ndr_get_array_size(ndr, &r->in.server)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server), ndr_get_array_length(ndr, &r->in.server));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server, ndr_get_array_length(ndr, &r->in.server), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_environment));
		if (_ptr_environment) {
			NDR_PULL_ALLOC(ndr, r->in.environment);
		} else {
			r->in.environment = NULL;
		}
		if (r->in.environment) {
			_mem_save_environment_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.environment, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.environment));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.environment));
			if (ndr_get_array_length(ndr, &r->in.environment) > ndr_get_array_size(ndr, &r->in.environment)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.environment), ndr_get_array_length(ndr, &r->in.environment));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.environment), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.environment, ndr_get_array_length(ndr, &r->in.environment), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_environment_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_buffer));
		if (_ptr_buffer) {
			NDR_PULL_ALLOC(ndr, r->in.buffer);
		} else {
			r->in.buffer = NULL;
		}
		if (r->in.buffer) {
			_mem_save_buffer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.buffer, 0);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, r->in.buffer));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_buffer_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.offered));
		NDR_PULL_ALLOC(ndr, r->out.needed);
		ZERO_STRUCTP(r->out.needed);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		} else {
			r->out.info = NULL;
		}
		if (r->out.info) {
			_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.info, 0);
			{
				struct ndr_pull *_ndr_info;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_info, 4, r->in.offered));
				NDR_CHECK(ndr_pull_set_switch_value(_ndr_info, r->out.info, r->in.level));
				NDR_CHECK(ndr_pull_spoolss_DriverDirectoryInfo(_ndr_info, NDR_SCALARS, r->out.info));
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_info, 4, r->in.offered));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.needed);
		}
		_mem_save_needed_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.needed, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.needed));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_needed_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_GetPrinterDriverDirectory(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_GetPrinterDriverDirectory *r)
{
	ndr_print_struct(ndr, name, "spoolss_GetPrinterDriverDirectory");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_GetPrinterDriverDirectory");
		ndr->depth++;
		ndr_print_ptr(ndr, "server", r->in.server);
		ndr->depth++;
		if (r->in.server) {
			ndr_print_string(ndr, "server", r->in.server);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "environment", r->in.environment);
		ndr->depth++;
		if (r->in.environment) {
			ndr_print_string(ndr, "environment", r->in.environment);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		if (r->in.buffer) {
			ndr_print_DATA_BLOB(ndr, "buffer", *r->in.buffer);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "offered", r->in.offered);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_GetPrinterDriverDirectory");
		ndr->depth++;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		if (r->out.info) {
			ndr_print_set_switch_value(ndr, r->out.info, r->in.level);
			ndr_print_spoolss_DriverDirectoryInfo(ndr, "info", r->out.info);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "needed", r->out.needed);
		ndr->depth++;
		ndr_print_uint32(ndr, "needed", *r->out.needed);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_DeletePrinterDriver(struct ndr_push *ndr, int flags, const struct spoolss_DeletePrinterDriver *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server));
		if (r->in.server) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.server, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.server, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server, ndr_charset_length(r->in.server, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.architecture, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.architecture, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.architecture, ndr_charset_length(r->in.architecture, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.driver, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.driver, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.driver, ndr_charset_length(r->in.driver, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_DeletePrinterDriver(struct ndr_pull *ndr, int flags, struct spoolss_DeletePrinterDriver *r)
{
	uint32_t _ptr_server;
	TALLOC_CTX *_mem_save_server_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server));
		if (_ptr_server) {
			NDR_PULL_ALLOC(ndr, r->in.server);
		} else {
			r->in.server = NULL;
		}
		if (r->in.server) {
			_mem_save_server_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server));
			if (ndr_get_array_length(ndr, &r->in.server) > ndr_get_array_size(ndr, &r->in.server)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server), ndr_get_array_length(ndr, &r->in.server));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server, ndr_get_array_length(ndr, &r->in.server), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.architecture));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.architecture));
		if (ndr_get_array_length(ndr, &r->in.architecture) > ndr_get_array_size(ndr, &r->in.architecture)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.architecture), ndr_get_array_length(ndr, &r->in.architecture));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.architecture), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.architecture, ndr_get_array_length(ndr, &r->in.architecture), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.driver));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.driver));
		if (ndr_get_array_length(ndr, &r->in.driver) > ndr_get_array_size(ndr, &r->in.driver)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.driver), ndr_get_array_length(ndr, &r->in.driver));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.driver), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.driver, ndr_get_array_length(ndr, &r->in.driver), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_DeletePrinterDriver(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_DeletePrinterDriver *r)
{
	ndr_print_struct(ndr, name, "spoolss_DeletePrinterDriver");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_DeletePrinterDriver");
		ndr->depth++;
		ndr_print_ptr(ndr, "server", r->in.server);
		ndr->depth++;
		if (r->in.server) {
			ndr_print_string(ndr, "server", r->in.server);
		}
		ndr->depth--;
		ndr_print_string(ndr, "architecture", r->in.architecture);
		ndr_print_string(ndr, "driver", r->in.driver);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_DeletePrinterDriver");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_AddPrintProcessor(struct ndr_push *ndr, int flags, const struct spoolss_AddPrintProcessor *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server));
		if (r->in.server) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.server, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.server, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server, ndr_charset_length(r->in.server, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.architecture, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.architecture, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.architecture, ndr_charset_length(r->in.architecture, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.path_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.path_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.path_name, ndr_charset_length(r->in.path_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.print_processor_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.print_processor_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.print_processor_name, ndr_charset_length(r->in.print_processor_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_AddPrintProcessor(struct ndr_pull *ndr, int flags, struct spoolss_AddPrintProcessor *r)
{
	uint32_t _ptr_server;
	TALLOC_CTX *_mem_save_server_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server));
		if (_ptr_server) {
			NDR_PULL_ALLOC(ndr, r->in.server);
		} else {
			r->in.server = NULL;
		}
		if (r->in.server) {
			_mem_save_server_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server));
			if (ndr_get_array_length(ndr, &r->in.server) > ndr_get_array_size(ndr, &r->in.server)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server), ndr_get_array_length(ndr, &r->in.server));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server, ndr_get_array_length(ndr, &r->in.server), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.architecture));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.architecture));
		if (ndr_get_array_length(ndr, &r->in.architecture) > ndr_get_array_size(ndr, &r->in.architecture)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.architecture), ndr_get_array_length(ndr, &r->in.architecture));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.architecture), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.architecture, ndr_get_array_length(ndr, &r->in.architecture), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.path_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.path_name));
		if (ndr_get_array_length(ndr, &r->in.path_name) > ndr_get_array_size(ndr, &r->in.path_name)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.path_name), ndr_get_array_length(ndr, &r->in.path_name));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.path_name), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.path_name, ndr_get_array_length(ndr, &r->in.path_name), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.print_processor_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.print_processor_name));
		if (ndr_get_array_length(ndr, &r->in.print_processor_name) > ndr_get_array_size(ndr, &r->in.print_processor_name)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.print_processor_name), ndr_get_array_length(ndr, &r->in.print_processor_name));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.print_processor_name), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.print_processor_name, ndr_get_array_length(ndr, &r->in.print_processor_name), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_AddPrintProcessor(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_AddPrintProcessor *r)
{
	ndr_print_struct(ndr, name, "spoolss_AddPrintProcessor");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_AddPrintProcessor");
		ndr->depth++;
		ndr_print_ptr(ndr, "server", r->in.server);
		ndr->depth++;
		if (r->in.server) {
			ndr_print_string(ndr, "server", r->in.server);
		}
		ndr->depth--;
		ndr_print_string(ndr, "architecture", r->in.architecture);
		ndr_print_string(ndr, "path_name", r->in.path_name);
		ndr_print_string(ndr, "print_processor_name", r->in.print_processor_name);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_AddPrintProcessor");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push__spoolss_EnumPrintProcessors(struct ndr_push *ndr, int flags, const struct _spoolss_EnumPrintProcessors *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.servername));
		if (r->in.servername) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.servername, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.servername, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.servername, ndr_charset_length(r->in.servername, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.environment));
		if (r->in.environment) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.environment, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.environment, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.environment, ndr_charset_length(r->in.environment, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.buffer));
		if (r->in.buffer) {
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, *r->in.buffer));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.offered));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.info));
		if (r->out.info) {
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, *r->out.info));
		}
		if (r->out.needed == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.needed));
		if (r->out.count == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.count));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull__spoolss_EnumPrintProcessors(struct ndr_pull *ndr, int flags, struct _spoolss_EnumPrintProcessors *r)
{
	uint32_t _ptr_servername;
	uint32_t _ptr_environment;
	uint32_t _ptr_buffer;
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_servername_0;
	TALLOC_CTX *_mem_save_environment_0;
	TALLOC_CTX *_mem_save_buffer_0;
	TALLOC_CTX *_mem_save_info_0;
	TALLOC_CTX *_mem_save_needed_0;
	TALLOC_CTX *_mem_save_count_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_servername));
		if (_ptr_servername) {
			NDR_PULL_ALLOC(ndr, r->in.servername);
		} else {
			r->in.servername = NULL;
		}
		if (r->in.servername) {
			_mem_save_servername_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.servername, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.servername));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.servername));
			if (ndr_get_array_length(ndr, &r->in.servername) > ndr_get_array_size(ndr, &r->in.servername)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.servername), ndr_get_array_length(ndr, &r->in.servername));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.servername), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.servername, ndr_get_array_length(ndr, &r->in.servername), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_servername_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_environment));
		if (_ptr_environment) {
			NDR_PULL_ALLOC(ndr, r->in.environment);
		} else {
			r->in.environment = NULL;
		}
		if (r->in.environment) {
			_mem_save_environment_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.environment, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.environment));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.environment));
			if (ndr_get_array_length(ndr, &r->in.environment) > ndr_get_array_size(ndr, &r->in.environment)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.environment), ndr_get_array_length(ndr, &r->in.environment));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.environment), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.environment, ndr_get_array_length(ndr, &r->in.environment), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_environment_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_buffer));
		if (_ptr_buffer) {
			NDR_PULL_ALLOC(ndr, r->in.buffer);
		} else {
			r->in.buffer = NULL;
		}
		if (r->in.buffer) {
			_mem_save_buffer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.buffer, 0);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, r->in.buffer));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_buffer_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.offered));
		NDR_PULL_ALLOC(ndr, r->out.needed);
		ZERO_STRUCTP(r->out.needed);
		NDR_PULL_ALLOC(ndr, r->out.count);
		ZERO_STRUCTP(r->out.count);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		} else {
			r->out.info = NULL;
		}
		if (r->out.info) {
			_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.info, 0);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, r->out.info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.needed);
		}
		_mem_save_needed_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.needed, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.needed));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_needed_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.count);
		}
		_mem_save_count_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.count, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.count));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_count_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_push___spoolss_EnumPrintProcessors(struct ndr_push *ndr, int flags, const struct __spoolss_EnumPrintProcessors *r)
{
	uint32_t cntr_info_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.count));
	}
	if (flags & NDR_OUT) {
		for (cntr_info_0 = 0; cntr_info_0 < r->in.count; cntr_info_0++) {
			NDR_CHECK(ndr_push_set_switch_value(ndr, &r->out.info[cntr_info_0], r->in.level));
			NDR_CHECK(ndr_push_spoolss_PrintProcessorInfo(ndr, NDR_SCALARS, &r->out.info[cntr_info_0]));
		}
		for (cntr_info_0 = 0; cntr_info_0 < r->in.count; cntr_info_0++) {
			NDR_CHECK(ndr_push_spoolss_PrintProcessorInfo(ndr, NDR_BUFFERS, &r->out.info[cntr_info_0]));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull___spoolss_EnumPrintProcessors(struct ndr_pull *ndr, int flags, struct __spoolss_EnumPrintProcessors *r)
{
	uint32_t cntr_info_0;
	TALLOC_CTX *_mem_save_info_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.count));
	}
	if (flags & NDR_OUT) {
		NDR_PULL_ALLOC_N(ndr, r->out.info, r->in.count);
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, 0);
		for (cntr_info_0 = 0; cntr_info_0 < r->in.count; cntr_info_0++) {
			NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->out.info[cntr_info_0], r->in.level));
			NDR_CHECK(ndr_pull_spoolss_PrintProcessorInfo(ndr, NDR_SCALARS, &r->out.info[cntr_info_0]));
		}
		for (cntr_info_0 = 0; cntr_info_0 < r->in.count; cntr_info_0++) {
			NDR_CHECK(ndr_pull_spoolss_PrintProcessorInfo(ndr, NDR_BUFFERS, &r->out.info[cntr_info_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_EnumPrintProcessors(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_EnumPrintProcessors *r)
{
	uint32_t cntr_info_2;
	ndr_print_struct(ndr, name, "spoolss_EnumPrintProcessors");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_EnumPrintProcessors");
		ndr->depth++;
		ndr_print_ptr(ndr, "servername", r->in.servername);
		ndr->depth++;
		if (r->in.servername) {
			ndr_print_string(ndr, "servername", r->in.servername);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "environment", r->in.environment);
		ndr->depth++;
		if (r->in.environment) {
			ndr_print_string(ndr, "environment", r->in.environment);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		if (r->in.buffer) {
			ndr_print_DATA_BLOB(ndr, "buffer", *r->in.buffer);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "offered", r->in.offered);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_EnumPrintProcessors");
		ndr->depth++;
		ndr_print_ptr(ndr, "count", r->out.count);
		ndr->depth++;
		ndr_print_uint32(ndr, "count", *r->out.count);
		ndr->depth--;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		ndr_print_ptr(ndr, "info", *r->out.info);
		ndr->depth++;
		if (*r->out.info) {
			ndr->print(ndr, "%s: ARRAY(%d)", "info", (int)*r->out.count);
			ndr->depth++;
			for (cntr_info_2=0;cntr_info_2<*r->out.count;cntr_info_2++) {
				char *idx_2=NULL;
				if (asprintf(&idx_2, "[%d]", cntr_info_2) != -1) {
					ndr_print_set_switch_value(ndr, &(*r->out.info)[cntr_info_2], r->in.level);
					ndr_print_spoolss_PrintProcessorInfo(ndr, "info", &(*r->out.info)[cntr_info_2]);
					free(idx_2);
				}
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "needed", r->out.needed);
		ndr->depth++;
		ndr_print_uint32(ndr, "needed", *r->out.needed);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_GetPrintProcessorDirectory(struct ndr_push *ndr, int flags, const struct spoolss_GetPrintProcessorDirectory *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server));
		if (r->in.server) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.server, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.server, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server, ndr_charset_length(r->in.server, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.environment));
		if (r->in.environment) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.environment, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.environment, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.environment, ndr_charset_length(r->in.environment, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.buffer));
		if (r->in.buffer) {
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, *r->in.buffer));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.offered));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.info));
		if (r->out.info) {
			{
				struct ndr_push *_ndr_info;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_info, 4, r->in.offered));
				NDR_CHECK(ndr_push_set_switch_value(_ndr_info, r->out.info, r->in.level));
				NDR_CHECK(ndr_push_spoolss_PrintProcessorDirectoryInfo(_ndr_info, NDR_SCALARS, r->out.info));
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_info, 4, r->in.offered));
			}
		}
		if (r->out.needed == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.needed));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_GetPrintProcessorDirectory(struct ndr_pull *ndr, int flags, struct spoolss_GetPrintProcessorDirectory *r)
{
	uint32_t _ptr_server;
	uint32_t _ptr_environment;
	uint32_t _ptr_buffer;
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_server_0;
	TALLOC_CTX *_mem_save_environment_0;
	TALLOC_CTX *_mem_save_buffer_0;
	TALLOC_CTX *_mem_save_info_0;
	TALLOC_CTX *_mem_save_needed_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server));
		if (_ptr_server) {
			NDR_PULL_ALLOC(ndr, r->in.server);
		} else {
			r->in.server = NULL;
		}
		if (r->in.server) {
			_mem_save_server_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server));
			if (ndr_get_array_length(ndr, &r->in.server) > ndr_get_array_size(ndr, &r->in.server)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server), ndr_get_array_length(ndr, &r->in.server));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server, ndr_get_array_length(ndr, &r->in.server), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_environment));
		if (_ptr_environment) {
			NDR_PULL_ALLOC(ndr, r->in.environment);
		} else {
			r->in.environment = NULL;
		}
		if (r->in.environment) {
			_mem_save_environment_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.environment, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.environment));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.environment));
			if (ndr_get_array_length(ndr, &r->in.environment) > ndr_get_array_size(ndr, &r->in.environment)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.environment), ndr_get_array_length(ndr, &r->in.environment));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.environment), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.environment, ndr_get_array_length(ndr, &r->in.environment), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_environment_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_buffer));
		if (_ptr_buffer) {
			NDR_PULL_ALLOC(ndr, r->in.buffer);
		} else {
			r->in.buffer = NULL;
		}
		if (r->in.buffer) {
			_mem_save_buffer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.buffer, 0);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, r->in.buffer));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_buffer_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.offered));
		NDR_PULL_ALLOC(ndr, r->out.needed);
		ZERO_STRUCTP(r->out.needed);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		} else {
			r->out.info = NULL;
		}
		if (r->out.info) {
			_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.info, 0);
			{
				struct ndr_pull *_ndr_info;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_info, 4, r->in.offered));
				NDR_CHECK(ndr_pull_set_switch_value(_ndr_info, r->out.info, r->in.level));
				NDR_CHECK(ndr_pull_spoolss_PrintProcessorDirectoryInfo(_ndr_info, NDR_SCALARS, r->out.info));
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_info, 4, r->in.offered));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.needed);
		}
		_mem_save_needed_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.needed, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.needed));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_needed_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_GetPrintProcessorDirectory(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_GetPrintProcessorDirectory *r)
{
	ndr_print_struct(ndr, name, "spoolss_GetPrintProcessorDirectory");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_GetPrintProcessorDirectory");
		ndr->depth++;
		ndr_print_ptr(ndr, "server", r->in.server);
		ndr->depth++;
		if (r->in.server) {
			ndr_print_string(ndr, "server", r->in.server);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "environment", r->in.environment);
		ndr->depth++;
		if (r->in.environment) {
			ndr_print_string(ndr, "environment", r->in.environment);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		if (r->in.buffer) {
			ndr_print_DATA_BLOB(ndr, "buffer", *r->in.buffer);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "offered", r->in.offered);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_GetPrintProcessorDirectory");
		ndr->depth++;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		if (r->out.info) {
			ndr_print_set_switch_value(ndr, r->out.info, r->in.level);
			ndr_print_spoolss_PrintProcessorDirectoryInfo(ndr, "info", r->out.info);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "needed", r->out.needed);
		ndr->depth++;
		ndr_print_uint32(ndr, "needed", *r->out.needed);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_StartDocPrinter(struct ndr_push *ndr, int flags, const struct spoolss_StartDocPrinter *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->in.info, r->in.level));
		NDR_CHECK(ndr_push_spoolss_DocumentInfo(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.info));
	}
	if (flags & NDR_OUT) {
		if (r->out.job_id == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.job_id));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_StartDocPrinter(struct ndr_pull *ndr, int flags, struct spoolss_StartDocPrinter *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_job_id_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->in.info, r->in.level));
		NDR_CHECK(ndr_pull_spoolss_DocumentInfo(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.info));
		NDR_PULL_ALLOC(ndr, r->out.job_id);
		ZERO_STRUCTP(r->out.job_id);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.job_id);
		}
		_mem_save_job_id_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.job_id, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.job_id));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_job_id_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_StartDocPrinter(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_StartDocPrinter *r)
{
	ndr_print_struct(ndr, name, "spoolss_StartDocPrinter");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_StartDocPrinter");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_set_switch_value(ndr, &r->in.info, r->in.level);
		ndr_print_spoolss_DocumentInfo(ndr, "info", &r->in.info);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_StartDocPrinter");
		ndr->depth++;
		ndr_print_ptr(ndr, "job_id", r->out.job_id);
		ndr->depth++;
		ndr_print_uint32(ndr, "job_id", *r->out.job_id);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_StartPagePrinter(struct ndr_push *ndr, int flags, const struct spoolss_StartPagePrinter *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_StartPagePrinter(struct ndr_pull *ndr, int flags, struct spoolss_StartPagePrinter *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_StartPagePrinter(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_StartPagePrinter *r)
{
	ndr_print_struct(ndr, name, "spoolss_StartPagePrinter");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_StartPagePrinter");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_StartPagePrinter");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_WritePrinter(struct ndr_push *ndr, int flags, const struct spoolss_WritePrinter *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->in.data));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.data.length));
	}
	if (flags & NDR_OUT) {
		if (r->out.num_written == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.num_written));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_WritePrinter(struct ndr_pull *ndr, int flags, struct spoolss_WritePrinter *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_num_written_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->in.data));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in._data_size));
		NDR_PULL_ALLOC(ndr, r->out.num_written);
		ZERO_STRUCTP(r->out.num_written);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.num_written);
		}
		_mem_save_num_written_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.num_written, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.num_written));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_num_written_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_WritePrinter(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_WritePrinter *r)
{
	ndr_print_struct(ndr, name, "spoolss_WritePrinter");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_WritePrinter");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_DATA_BLOB(ndr, "data", r->in.data);
		ndr_print_uint32(ndr, "_data_size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?r->in.data.length:r->in._data_size);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_WritePrinter");
		ndr->depth++;
		ndr_print_ptr(ndr, "num_written", r->out.num_written);
		ndr->depth++;
		ndr_print_uint32(ndr, "num_written", *r->out.num_written);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_EndPagePrinter(struct ndr_push *ndr, int flags, const struct spoolss_EndPagePrinter *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_EndPagePrinter(struct ndr_pull *ndr, int flags, struct spoolss_EndPagePrinter *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_EndPagePrinter(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_EndPagePrinter *r)
{
	ndr_print_struct(ndr, name, "spoolss_EndPagePrinter");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_EndPagePrinter");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_EndPagePrinter");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_AbortPrinter(struct ndr_push *ndr, int flags, const struct spoolss_AbortPrinter *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_AbortPrinter(struct ndr_pull *ndr, int flags, struct spoolss_AbortPrinter *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_AbortPrinter(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_AbortPrinter *r)
{
	ndr_print_struct(ndr, name, "spoolss_AbortPrinter");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_AbortPrinter");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_AbortPrinter");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_ReadPrinter(struct ndr_push *ndr, int flags, const struct spoolss_ReadPrinter *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.data_size));
	}
	if (flags & NDR_OUT) {
		if (r->out.data == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.data_size));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.data, r->in.data_size));
		if (r->out._data_size == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out._data_size));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_ReadPrinter(struct ndr_pull *ndr, int flags, struct spoolss_ReadPrinter *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save__data_size_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.data_size));
		NDR_PULL_ALLOC_N(ndr, r->out.data, r->in.data_size);
		memset(r->out.data, 0, (r->in.data_size) * sizeof(*r->out.data));
		NDR_PULL_ALLOC(ndr, r->out._data_size);
		ZERO_STRUCTP(r->out._data_size);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.data));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.data, ndr_get_array_size(ndr, &r->out.data));
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.data, ndr_get_array_size(ndr, &r->out.data)));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out._data_size);
		}
		_mem_save__data_size_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out._data_size, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out._data_size));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save__data_size_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.data) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->out.data, r->in.data_size));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_ReadPrinter(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_ReadPrinter *r)
{
	ndr_print_struct(ndr, name, "spoolss_ReadPrinter");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_ReadPrinter");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "data_size", r->in.data_size);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_ReadPrinter");
		ndr->depth++;
		ndr_print_ptr(ndr, "data", r->out.data);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "data", r->out.data, r->in.data_size);
		ndr->depth--;
		ndr_print_ptr(ndr, "_data_size", r->out._data_size);
		ndr->depth++;
		ndr_print_uint32(ndr, "_data_size", *r->out._data_size);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_EndDocPrinter(struct ndr_push *ndr, int flags, const struct spoolss_EndDocPrinter *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_EndDocPrinter(struct ndr_pull *ndr, int flags, struct spoolss_EndDocPrinter *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_EndDocPrinter(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_EndDocPrinter *r)
{
	ndr_print_struct(ndr, name, "spoolss_EndDocPrinter");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_EndDocPrinter");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_EndDocPrinter");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_AddJob(struct ndr_push *ndr, int flags, const struct spoolss_AddJob *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.buffer));
		if (r->in.buffer) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.offered));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.buffer, r->in.offered));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.offered));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.buffer));
		if (r->out.buffer) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.offered));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.buffer, r->in.offered));
		}
		if (r->out.needed == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.needed));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_AddJob(struct ndr_pull *ndr, int flags, struct spoolss_AddJob *r)
{
	uint32_t _ptr_buffer;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_buffer_0;
	TALLOC_CTX *_mem_save_needed_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_buffer));
		if (_ptr_buffer) {
			NDR_PULL_ALLOC(ndr, r->in.buffer);
		} else {
			r->in.buffer = NULL;
		}
		if (r->in.buffer) {
			_mem_save_buffer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.buffer, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.buffer));
			NDR_PULL_ALLOC_N(ndr, r->in.buffer, ndr_get_array_size(ndr, &r->in.buffer));
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.buffer, ndr_get_array_size(ndr, &r->in.buffer)));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_buffer_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.offered));
		NDR_PULL_ALLOC(ndr, r->out.needed);
		ZERO_STRUCTP(r->out.needed);
		if (r->in.buffer) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->in.buffer, r->in.offered));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_buffer));
		if (_ptr_buffer) {
			NDR_PULL_ALLOC(ndr, r->out.buffer);
		} else {
			r->out.buffer = NULL;
		}
		if (r->out.buffer) {
			_mem_save_buffer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.buffer, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->out.buffer));
			NDR_PULL_ALLOC_N(ndr, r->out.buffer, ndr_get_array_size(ndr, &r->out.buffer));
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.buffer, ndr_get_array_size(ndr, &r->out.buffer)));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_buffer_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.needed);
		}
		_mem_save_needed_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.needed, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.needed));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_needed_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.buffer) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->out.buffer, r->in.offered));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_AddJob(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_AddJob *r)
{
	ndr_print_struct(ndr, name, "spoolss_AddJob");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_AddJob");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		if (r->in.buffer) {
			ndr_print_array_uint8(ndr, "buffer", r->in.buffer, r->in.offered);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "offered", r->in.offered);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_AddJob");
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		if (r->out.buffer) {
			ndr_print_array_uint8(ndr, "buffer", r->out.buffer, r->in.offered);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "needed", r->out.needed);
		ndr->depth++;
		ndr_print_uint32(ndr, "needed", *r->out.needed);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_ScheduleJob(struct ndr_push *ndr, int flags, const struct spoolss_ScheduleJob *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.jobid));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_ScheduleJob(struct ndr_pull *ndr, int flags, struct spoolss_ScheduleJob *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.jobid));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_ScheduleJob(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_ScheduleJob *r)
{
	ndr_print_struct(ndr, name, "spoolss_ScheduleJob");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_ScheduleJob");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "jobid", r->in.jobid);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_ScheduleJob");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push__spoolss_GetPrinterData(struct ndr_push *ndr, int flags, const struct _spoolss_GetPrinterData *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.value_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.value_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.value_name, ndr_charset_length(r->in.value_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.offered));
	}
	if (flags & NDR_OUT) {
		if (r->out.type == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_winreg_Type(ndr, NDR_SCALARS, *r->out.type));
		if (r->out.data == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, *r->out.data));
		if (r->out.needed == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.needed));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull__spoolss_GetPrinterData(struct ndr_pull *ndr, int flags, struct _spoolss_GetPrinterData *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_type_0;
	TALLOC_CTX *_mem_save_data_0;
	TALLOC_CTX *_mem_save_needed_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.value_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.value_name));
		if (ndr_get_array_length(ndr, &r->in.value_name) > ndr_get_array_size(ndr, &r->in.value_name)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.value_name), ndr_get_array_length(ndr, &r->in.value_name));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.value_name), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.value_name, ndr_get_array_length(ndr, &r->in.value_name), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.offered));
		NDR_PULL_ALLOC(ndr, r->out.type);
		ZERO_STRUCTP(r->out.type);
		NDR_PULL_ALLOC(ndr, r->out.data);
		ZERO_STRUCTP(r->out.data);
		NDR_PULL_ALLOC(ndr, r->out.needed);
		ZERO_STRUCTP(r->out.needed);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.type);
		}
		_mem_save_type_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.type, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_winreg_Type(ndr, NDR_SCALARS, r->out.type));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_type_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.data);
		}
		_mem_save_data_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.data, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, r->out.data));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.needed);
		}
		_mem_save_needed_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.needed, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.needed));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_needed_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_push___spoolss_GetPrinterData(struct ndr_push *ndr, int flags, const struct __spoolss_GetPrinterData *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_winreg_Type(ndr, NDR_SCALARS, r->in.type));
	}
	if (flags & NDR_OUT) {
		if (r->out.data == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->out.data, r->in.type));
		NDR_CHECK(ndr_push_spoolss_PrinterData(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.data));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull___spoolss_GetPrinterData(struct ndr_pull *ndr, int flags, struct __spoolss_GetPrinterData *r)
{
	TALLOC_CTX *_mem_save_data_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_winreg_Type(ndr, NDR_SCALARS, &r->in.type));
		NDR_PULL_ALLOC(ndr, r->out.data);
		ZERO_STRUCTP(r->out.data);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.data);
		}
		_mem_save_data_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.data, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->out.data, r->in.type));
		NDR_CHECK(ndr_pull_spoolss_PrinterData(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.data));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_0, LIBNDR_FLAG_REF_ALLOC);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_GetPrinterData(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_GetPrinterData *r)
{
	ndr_print_struct(ndr, name, "spoolss_GetPrinterData");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_GetPrinterData");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_string(ndr, "value_name", r->in.value_name);
		ndr_print_uint32(ndr, "offered", r->in.offered);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_GetPrinterData");
		ndr->depth++;
		ndr_print_ptr(ndr, "type", r->out.type);
		ndr->depth++;
		ndr_print_winreg_Type(ndr, "type", *r->out.type);
		ndr->depth--;
		ndr_print_ptr(ndr, "data", r->out.data);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->out.data, *r->out.type);
		ndr_print_spoolss_PrinterData(ndr, "data", r->out.data);
		ndr->depth--;
		ndr_print_ptr(ndr, "needed", r->out.needed);
		ndr->depth++;
		ndr_print_uint32(ndr, "needed", *r->out.needed);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push__spoolss_SetPrinterData(struct ndr_push *ndr, int flags, const struct _spoolss_SetPrinterData *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.value_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.value_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.value_name, ndr_charset_length(r->in.value_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_winreg_Type(ndr, NDR_SCALARS, r->in.type));
		NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->in.data));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in._offered));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_push___spoolss_SetPrinterData(struct ndr_push *ndr, int flags, const struct __spoolss_SetPrinterData *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_winreg_Type(ndr, NDR_SCALARS, r->in.type));
	}
	if (flags & NDR_OUT) {
		if (r->out.data == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->out.data, r->in.type));
		NDR_CHECK(ndr_push_spoolss_PrinterData(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.data));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_SetPrinterData(struct ndr_pull *ndr, int flags, struct spoolss_SetPrinterData *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.value_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.value_name));
		if (ndr_get_array_length(ndr, &r->in.value_name) > ndr_get_array_size(ndr, &r->in.value_name)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.value_name), ndr_get_array_length(ndr, &r->in.value_name));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.value_name), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.value_name, ndr_get_array_length(ndr, &r->in.value_name), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_winreg_Type(ndr, NDR_SCALARS, &r->in.type));
		{
			struct ndr_pull *_ndr_data;
			NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_data, 4, -1));
			NDR_CHECK(ndr_pull_set_switch_value(_ndr_data, &r->in.data, r->in.type));
			NDR_CHECK(ndr_pull_spoolss_PrinterData(_ndr_data, NDR_SCALARS|NDR_BUFFERS, &r->in.data));
			NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_data, 4, -1));
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in._offered));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_SetPrinterData(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_SetPrinterData *r)
{
	ndr_print_struct(ndr, name, "spoolss_SetPrinterData");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_SetPrinterData");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_string(ndr, "value_name", r->in.value_name);
		ndr_print_winreg_Type(ndr, "type", r->in.type);
		ndr_print_set_switch_value(ndr, &r->in.data, r->in.type);
		ndr_print_spoolss_PrinterData(ndr, "data", &r->in.data);
		ndr_print_uint32(ndr, "_offered", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_spoolss_PrinterData(&r->in.data, r->in.type, ndr->iconv_convenience, flags):r->in._offered);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_SetPrinterData");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_WaitForPrinterChange(struct ndr_push *ndr, int flags, const struct spoolss_WaitForPrinterChange *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_WaitForPrinterChange(struct ndr_pull *ndr, int flags, struct spoolss_WaitForPrinterChange *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_WaitForPrinterChange(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_WaitForPrinterChange *r)
{
	ndr_print_struct(ndr, name, "spoolss_WaitForPrinterChange");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_WaitForPrinterChange");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_WaitForPrinterChange");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_ClosePrinter(struct ndr_push *ndr, int flags, const struct spoolss_ClosePrinter *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
	}
	if (flags & NDR_OUT) {
		if (r->out.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_ClosePrinter(struct ndr_pull *ndr, int flags, struct spoolss_ClosePrinter *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.handle);
		*r->out.handle = *r->in.handle;
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_ClosePrinter(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_ClosePrinter *r)
{
	ndr_print_struct(ndr, name, "spoolss_ClosePrinter");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_ClosePrinter");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_ClosePrinter");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->out.handle);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_AddForm(struct ndr_push *ndr, int flags, const struct spoolss_AddForm *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->in.info, r->in.level));
		NDR_CHECK(ndr_push_spoolss_AddFormInfo(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.info));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_AddForm(struct ndr_pull *ndr, int flags, struct spoolss_AddForm *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->in.info, r->in.level));
		NDR_CHECK(ndr_pull_spoolss_AddFormInfo(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.info));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_AddForm(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_AddForm *r)
{
	ndr_print_struct(ndr, name, "spoolss_AddForm");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_AddForm");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_set_switch_value(ndr, &r->in.info, r->in.level);
		ndr_print_spoolss_AddFormInfo(ndr, "info", &r->in.info);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_AddForm");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_DeleteForm(struct ndr_push *ndr, int flags, const struct spoolss_DeleteForm *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.form_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.form_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.form_name, ndr_charset_length(r->in.form_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_DeleteForm(struct ndr_pull *ndr, int flags, struct spoolss_DeleteForm *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.form_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.form_name));
		if (ndr_get_array_length(ndr, &r->in.form_name) > ndr_get_array_size(ndr, &r->in.form_name)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.form_name), ndr_get_array_length(ndr, &r->in.form_name));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.form_name), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.form_name, ndr_get_array_length(ndr, &r->in.form_name), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_DeleteForm(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_DeleteForm *r)
{
	ndr_print_struct(ndr, name, "spoolss_DeleteForm");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_DeleteForm");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_string(ndr, "form_name", r->in.form_name);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_DeleteForm");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_GetForm(struct ndr_push *ndr, int flags, const struct spoolss_GetForm *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.form_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.form_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.form_name, ndr_charset_length(r->in.form_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.buffer));
		if (r->in.buffer) {
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, *r->in.buffer));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.offered));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.info));
		if (r->out.info) {
			{
				struct ndr_push *_ndr_info;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_info, 4, r->in.offered));
				NDR_CHECK(ndr_push_set_switch_value(_ndr_info, r->out.info, r->in.level));
				NDR_CHECK(ndr_push_spoolss_FormInfo(_ndr_info, NDR_SCALARS|NDR_BUFFERS, r->out.info));
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_info, 4, r->in.offered));
			}
		}
		if (r->out.needed == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.needed));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_GetForm(struct ndr_pull *ndr, int flags, struct spoolss_GetForm *r)
{
	uint32_t _ptr_buffer;
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_buffer_0;
	TALLOC_CTX *_mem_save_info_0;
	TALLOC_CTX *_mem_save_needed_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.form_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.form_name));
		if (ndr_get_array_length(ndr, &r->in.form_name) > ndr_get_array_size(ndr, &r->in.form_name)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.form_name), ndr_get_array_length(ndr, &r->in.form_name));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.form_name), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.form_name, ndr_get_array_length(ndr, &r->in.form_name), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_buffer));
		if (_ptr_buffer) {
			NDR_PULL_ALLOC(ndr, r->in.buffer);
		} else {
			r->in.buffer = NULL;
		}
		if (r->in.buffer) {
			_mem_save_buffer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.buffer, 0);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, r->in.buffer));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_buffer_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.offered));
		NDR_PULL_ALLOC(ndr, r->out.needed);
		ZERO_STRUCTP(r->out.needed);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		} else {
			r->out.info = NULL;
		}
		if (r->out.info) {
			_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.info, 0);
			{
				struct ndr_pull *_ndr_info;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_info, 4, r->in.offered));
				NDR_CHECK(ndr_pull_set_switch_value(_ndr_info, r->out.info, r->in.level));
				NDR_CHECK(ndr_pull_spoolss_FormInfo(_ndr_info, NDR_SCALARS|NDR_BUFFERS, r->out.info));
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_info, 4, r->in.offered));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.needed);
		}
		_mem_save_needed_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.needed, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.needed));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_needed_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_GetForm(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_GetForm *r)
{
	ndr_print_struct(ndr, name, "spoolss_GetForm");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_GetForm");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_string(ndr, "form_name", r->in.form_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		if (r->in.buffer) {
			ndr_print_DATA_BLOB(ndr, "buffer", *r->in.buffer);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "offered", r->in.offered);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_GetForm");
		ndr->depth++;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		if (r->out.info) {
			ndr_print_set_switch_value(ndr, r->out.info, r->in.level);
			ndr_print_spoolss_FormInfo(ndr, "info", r->out.info);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "needed", r->out.needed);
		ndr->depth++;
		ndr_print_uint32(ndr, "needed", *r->out.needed);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_SetForm(struct ndr_push *ndr, int flags, const struct spoolss_SetForm *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.form_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.form_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.form_name, ndr_charset_length(r->in.form_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->in.info, r->in.level));
		NDR_CHECK(ndr_push_spoolss_AddFormInfo(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.info));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_SetForm(struct ndr_pull *ndr, int flags, struct spoolss_SetForm *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.form_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.form_name));
		if (ndr_get_array_length(ndr, &r->in.form_name) > ndr_get_array_size(ndr, &r->in.form_name)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.form_name), ndr_get_array_length(ndr, &r->in.form_name));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.form_name), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.form_name, ndr_get_array_length(ndr, &r->in.form_name), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->in.info, r->in.level));
		NDR_CHECK(ndr_pull_spoolss_AddFormInfo(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.info));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_SetForm(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_SetForm *r)
{
	ndr_print_struct(ndr, name, "spoolss_SetForm");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_SetForm");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_string(ndr, "form_name", r->in.form_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_set_switch_value(ndr, &r->in.info, r->in.level);
		ndr_print_spoolss_AddFormInfo(ndr, "info", &r->in.info);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_SetForm");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push__spoolss_EnumForms(struct ndr_push *ndr, int flags, const struct _spoolss_EnumForms *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.buffer));
		if (r->in.buffer) {
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, *r->in.buffer));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.offered));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.info));
		if (r->out.info) {
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, *r->out.info));
		}
		if (r->out.needed == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.needed));
		if (r->out.count == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.count));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull__spoolss_EnumForms(struct ndr_pull *ndr, int flags, struct _spoolss_EnumForms *r)
{
	uint32_t _ptr_buffer;
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_buffer_0;
	TALLOC_CTX *_mem_save_info_0;
	TALLOC_CTX *_mem_save_needed_0;
	TALLOC_CTX *_mem_save_count_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_buffer));
		if (_ptr_buffer) {
			NDR_PULL_ALLOC(ndr, r->in.buffer);
		} else {
			r->in.buffer = NULL;
		}
		if (r->in.buffer) {
			_mem_save_buffer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.buffer, 0);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, r->in.buffer));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_buffer_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.offered));
		NDR_PULL_ALLOC(ndr, r->out.needed);
		ZERO_STRUCTP(r->out.needed);
		NDR_PULL_ALLOC(ndr, r->out.count);
		ZERO_STRUCTP(r->out.count);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		} else {
			r->out.info = NULL;
		}
		if (r->out.info) {
			_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.info, 0);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, r->out.info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.needed);
		}
		_mem_save_needed_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.needed, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.needed));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_needed_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.count);
		}
		_mem_save_count_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.count, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.count));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_count_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_push___spoolss_EnumForms(struct ndr_push *ndr, int flags, const struct __spoolss_EnumForms *r)
{
	uint32_t cntr_info_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.count));
	}
	if (flags & NDR_OUT) {
		for (cntr_info_0 = 0; cntr_info_0 < r->in.count; cntr_info_0++) {
			NDR_CHECK(ndr_push_set_switch_value(ndr, &r->out.info[cntr_info_0], r->in.level));
			NDR_CHECK(ndr_push_spoolss_FormInfo(ndr, NDR_SCALARS, &r->out.info[cntr_info_0]));
		}
		for (cntr_info_0 = 0; cntr_info_0 < r->in.count; cntr_info_0++) {
			NDR_CHECK(ndr_push_spoolss_FormInfo(ndr, NDR_BUFFERS, &r->out.info[cntr_info_0]));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull___spoolss_EnumForms(struct ndr_pull *ndr, int flags, struct __spoolss_EnumForms *r)
{
	uint32_t cntr_info_0;
	TALLOC_CTX *_mem_save_info_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.count));
	}
	if (flags & NDR_OUT) {
		NDR_PULL_ALLOC_N(ndr, r->out.info, r->in.count);
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, 0);
		for (cntr_info_0 = 0; cntr_info_0 < r->in.count; cntr_info_0++) {
			NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->out.info[cntr_info_0], r->in.level));
			NDR_CHECK(ndr_pull_spoolss_FormInfo(ndr, NDR_SCALARS, &r->out.info[cntr_info_0]));
		}
		for (cntr_info_0 = 0; cntr_info_0 < r->in.count; cntr_info_0++) {
			NDR_CHECK(ndr_pull_spoolss_FormInfo(ndr, NDR_BUFFERS, &r->out.info[cntr_info_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_EnumForms(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_EnumForms *r)
{
	uint32_t cntr_info_2;
	ndr_print_struct(ndr, name, "spoolss_EnumForms");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_EnumForms");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		if (r->in.buffer) {
			ndr_print_DATA_BLOB(ndr, "buffer", *r->in.buffer);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "offered", r->in.offered);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_EnumForms");
		ndr->depth++;
		ndr_print_ptr(ndr, "count", r->out.count);
		ndr->depth++;
		ndr_print_uint32(ndr, "count", *r->out.count);
		ndr->depth--;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		ndr_print_ptr(ndr, "info", *r->out.info);
		ndr->depth++;
		if (*r->out.info) {
			ndr->print(ndr, "%s: ARRAY(%d)", "info", (int)*r->out.count);
			ndr->depth++;
			for (cntr_info_2=0;cntr_info_2<*r->out.count;cntr_info_2++) {
				char *idx_2=NULL;
				if (asprintf(&idx_2, "[%d]", cntr_info_2) != -1) {
					ndr_print_set_switch_value(ndr, &(*r->out.info)[cntr_info_2], r->in.level);
					ndr_print_spoolss_FormInfo(ndr, "info", &(*r->out.info)[cntr_info_2]);
					free(idx_2);
				}
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "needed", r->out.needed);
		ndr->depth++;
		ndr_print_uint32(ndr, "needed", *r->out.needed);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push__spoolss_EnumPorts(struct ndr_push *ndr, int flags, const struct _spoolss_EnumPorts *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.servername));
		if (r->in.servername) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.servername, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.servername, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.servername, ndr_charset_length(r->in.servername, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.buffer));
		if (r->in.buffer) {
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, *r->in.buffer));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.offered));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.info));
		if (r->out.info) {
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, *r->out.info));
		}
		if (r->out.needed == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.needed));
		if (r->out.count == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.count));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull__spoolss_EnumPorts(struct ndr_pull *ndr, int flags, struct _spoolss_EnumPorts *r)
{
	uint32_t _ptr_servername;
	uint32_t _ptr_buffer;
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_servername_0;
	TALLOC_CTX *_mem_save_buffer_0;
	TALLOC_CTX *_mem_save_info_0;
	TALLOC_CTX *_mem_save_needed_0;
	TALLOC_CTX *_mem_save_count_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_servername));
		if (_ptr_servername) {
			NDR_PULL_ALLOC(ndr, r->in.servername);
		} else {
			r->in.servername = NULL;
		}
		if (r->in.servername) {
			_mem_save_servername_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.servername, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.servername));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.servername));
			if (ndr_get_array_length(ndr, &r->in.servername) > ndr_get_array_size(ndr, &r->in.servername)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.servername), ndr_get_array_length(ndr, &r->in.servername));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.servername), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.servername, ndr_get_array_length(ndr, &r->in.servername), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_servername_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_buffer));
		if (_ptr_buffer) {
			NDR_PULL_ALLOC(ndr, r->in.buffer);
		} else {
			r->in.buffer = NULL;
		}
		if (r->in.buffer) {
			_mem_save_buffer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.buffer, 0);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, r->in.buffer));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_buffer_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.offered));
		NDR_PULL_ALLOC(ndr, r->out.needed);
		ZERO_STRUCTP(r->out.needed);
		NDR_PULL_ALLOC(ndr, r->out.count);
		ZERO_STRUCTP(r->out.count);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		} else {
			r->out.info = NULL;
		}
		if (r->out.info) {
			_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.info, 0);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, r->out.info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.needed);
		}
		_mem_save_needed_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.needed, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.needed));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_needed_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.count);
		}
		_mem_save_count_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.count, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.count));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_count_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_push___spoolss_EnumPorts(struct ndr_push *ndr, int flags, const struct __spoolss_EnumPorts *r)
{
	uint32_t cntr_info_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.count));
	}
	if (flags & NDR_OUT) {
		for (cntr_info_0 = 0; cntr_info_0 < r->in.count; cntr_info_0++) {
			NDR_CHECK(ndr_push_set_switch_value(ndr, &r->out.info[cntr_info_0], r->in.level));
			NDR_CHECK(ndr_push_spoolss_PortInfo(ndr, NDR_SCALARS, &r->out.info[cntr_info_0]));
		}
		for (cntr_info_0 = 0; cntr_info_0 < r->in.count; cntr_info_0++) {
			NDR_CHECK(ndr_push_spoolss_PortInfo(ndr, NDR_BUFFERS, &r->out.info[cntr_info_0]));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull___spoolss_EnumPorts(struct ndr_pull *ndr, int flags, struct __spoolss_EnumPorts *r)
{
	uint32_t cntr_info_0;
	TALLOC_CTX *_mem_save_info_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.count));
	}
	if (flags & NDR_OUT) {
		NDR_PULL_ALLOC_N(ndr, r->out.info, r->in.count);
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, 0);
		for (cntr_info_0 = 0; cntr_info_0 < r->in.count; cntr_info_0++) {
			NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->out.info[cntr_info_0], r->in.level));
			NDR_CHECK(ndr_pull_spoolss_PortInfo(ndr, NDR_SCALARS, &r->out.info[cntr_info_0]));
		}
		for (cntr_info_0 = 0; cntr_info_0 < r->in.count; cntr_info_0++) {
			NDR_CHECK(ndr_pull_spoolss_PortInfo(ndr, NDR_BUFFERS, &r->out.info[cntr_info_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_EnumPorts(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_EnumPorts *r)
{
	uint32_t cntr_info_2;
	ndr_print_struct(ndr, name, "spoolss_EnumPorts");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_EnumPorts");
		ndr->depth++;
		ndr_print_ptr(ndr, "servername", r->in.servername);
		ndr->depth++;
		if (r->in.servername) {
			ndr_print_string(ndr, "servername", r->in.servername);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		if (r->in.buffer) {
			ndr_print_DATA_BLOB(ndr, "buffer", *r->in.buffer);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "offered", r->in.offered);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_EnumPorts");
		ndr->depth++;
		ndr_print_ptr(ndr, "count", r->out.count);
		ndr->depth++;
		ndr_print_uint32(ndr, "count", *r->out.count);
		ndr->depth--;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		ndr_print_ptr(ndr, "info", *r->out.info);
		ndr->depth++;
		if (*r->out.info) {
			ndr->print(ndr, "%s: ARRAY(%d)", "info", (int)*r->out.count);
			ndr->depth++;
			for (cntr_info_2=0;cntr_info_2<*r->out.count;cntr_info_2++) {
				char *idx_2=NULL;
				if (asprintf(&idx_2, "[%d]", cntr_info_2) != -1) {
					ndr_print_set_switch_value(ndr, &(*r->out.info)[cntr_info_2], r->in.level);
					ndr_print_spoolss_PortInfo(ndr, "info", &(*r->out.info)[cntr_info_2]);
					free(idx_2);
				}
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "needed", r->out.needed);
		ndr->depth++;
		ndr_print_uint32(ndr, "needed", *r->out.needed);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push__spoolss_EnumMonitors(struct ndr_push *ndr, int flags, const struct _spoolss_EnumMonitors *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.servername));
		if (r->in.servername) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.servername, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.servername, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.servername, ndr_charset_length(r->in.servername, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.buffer));
		if (r->in.buffer) {
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, *r->in.buffer));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.offered));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.info));
		if (r->out.info) {
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, *r->out.info));
		}
		if (r->out.needed == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.needed));
		if (r->out.count == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.count));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull__spoolss_EnumMonitors(struct ndr_pull *ndr, int flags, struct _spoolss_EnumMonitors *r)
{
	uint32_t _ptr_servername;
	uint32_t _ptr_buffer;
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_servername_0;
	TALLOC_CTX *_mem_save_buffer_0;
	TALLOC_CTX *_mem_save_info_0;
	TALLOC_CTX *_mem_save_needed_0;
	TALLOC_CTX *_mem_save_count_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_servername));
		if (_ptr_servername) {
			NDR_PULL_ALLOC(ndr, r->in.servername);
		} else {
			r->in.servername = NULL;
		}
		if (r->in.servername) {
			_mem_save_servername_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.servername, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.servername));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.servername));
			if (ndr_get_array_length(ndr, &r->in.servername) > ndr_get_array_size(ndr, &r->in.servername)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.servername), ndr_get_array_length(ndr, &r->in.servername));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.servername), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.servername, ndr_get_array_length(ndr, &r->in.servername), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_servername_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_buffer));
		if (_ptr_buffer) {
			NDR_PULL_ALLOC(ndr, r->in.buffer);
		} else {
			r->in.buffer = NULL;
		}
		if (r->in.buffer) {
			_mem_save_buffer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.buffer, 0);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, r->in.buffer));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_buffer_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.offered));
		NDR_PULL_ALLOC(ndr, r->out.needed);
		ZERO_STRUCTP(r->out.needed);
		NDR_PULL_ALLOC(ndr, r->out.count);
		ZERO_STRUCTP(r->out.count);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		} else {
			r->out.info = NULL;
		}
		if (r->out.info) {
			_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.info, 0);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, r->out.info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.needed);
		}
		_mem_save_needed_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.needed, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.needed));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_needed_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.count);
		}
		_mem_save_count_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.count, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.count));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_count_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_push___spoolss_EnumMonitors(struct ndr_push *ndr, int flags, const struct __spoolss_EnumMonitors *r)
{
	uint32_t cntr_info_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.count));
	}
	if (flags & NDR_OUT) {
		for (cntr_info_0 = 0; cntr_info_0 < r->in.count; cntr_info_0++) {
			NDR_CHECK(ndr_push_set_switch_value(ndr, &r->out.info[cntr_info_0], r->in.level));
			NDR_CHECK(ndr_push_spoolss_MonitorInfo(ndr, NDR_SCALARS, &r->out.info[cntr_info_0]));
		}
		for (cntr_info_0 = 0; cntr_info_0 < r->in.count; cntr_info_0++) {
			NDR_CHECK(ndr_push_spoolss_MonitorInfo(ndr, NDR_BUFFERS, &r->out.info[cntr_info_0]));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull___spoolss_EnumMonitors(struct ndr_pull *ndr, int flags, struct __spoolss_EnumMonitors *r)
{
	uint32_t cntr_info_0;
	TALLOC_CTX *_mem_save_info_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.count));
	}
	if (flags & NDR_OUT) {
		NDR_PULL_ALLOC_N(ndr, r->out.info, r->in.count);
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, 0);
		for (cntr_info_0 = 0; cntr_info_0 < r->in.count; cntr_info_0++) {
			NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->out.info[cntr_info_0], r->in.level));
			NDR_CHECK(ndr_pull_spoolss_MonitorInfo(ndr, NDR_SCALARS, &r->out.info[cntr_info_0]));
		}
		for (cntr_info_0 = 0; cntr_info_0 < r->in.count; cntr_info_0++) {
			NDR_CHECK(ndr_pull_spoolss_MonitorInfo(ndr, NDR_BUFFERS, &r->out.info[cntr_info_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_EnumMonitors(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_EnumMonitors *r)
{
	uint32_t cntr_info_2;
	ndr_print_struct(ndr, name, "spoolss_EnumMonitors");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_EnumMonitors");
		ndr->depth++;
		ndr_print_ptr(ndr, "servername", r->in.servername);
		ndr->depth++;
		if (r->in.servername) {
			ndr_print_string(ndr, "servername", r->in.servername);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		if (r->in.buffer) {
			ndr_print_DATA_BLOB(ndr, "buffer", *r->in.buffer);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "offered", r->in.offered);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_EnumMonitors");
		ndr->depth++;
		ndr_print_ptr(ndr, "count", r->out.count);
		ndr->depth++;
		ndr_print_uint32(ndr, "count", *r->out.count);
		ndr->depth--;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		ndr_print_ptr(ndr, "info", *r->out.info);
		ndr->depth++;
		if (*r->out.info) {
			ndr->print(ndr, "%s: ARRAY(%d)", "info", (int)*r->out.count);
			ndr->depth++;
			for (cntr_info_2=0;cntr_info_2<*r->out.count;cntr_info_2++) {
				char *idx_2=NULL;
				if (asprintf(&idx_2, "[%d]", cntr_info_2) != -1) {
					ndr_print_set_switch_value(ndr, &(*r->out.info)[cntr_info_2], r->in.level);
					ndr_print_spoolss_MonitorInfo(ndr, "info", &(*r->out.info)[cntr_info_2]);
					free(idx_2);
				}
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "needed", r->out.needed);
		ndr->depth++;
		ndr_print_uint32(ndr, "needed", *r->out.needed);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_AddPort(struct ndr_push *ndr, int flags, const struct spoolss_AddPort *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_name));
		if (r->in.server_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_name, ndr_charset_length(r->in.server_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.unknown));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.monitor_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.monitor_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.monitor_name, ndr_charset_length(r->in.monitor_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_AddPort(struct ndr_pull *ndr, int flags, struct spoolss_AddPort *r)
{
	uint32_t _ptr_server_name;
	TALLOC_CTX *_mem_save_server_name_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_name));
		if (_ptr_server_name) {
			NDR_PULL_ALLOC(ndr, r->in.server_name);
		} else {
			r->in.server_name = NULL;
		}
		if (r->in.server_name) {
			_mem_save_server_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_name));
			if (ndr_get_array_length(ndr, &r->in.server_name) > ndr_get_array_size(ndr, &r->in.server_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_name), ndr_get_array_length(ndr, &r->in.server_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_name, ndr_get_array_length(ndr, &r->in.server_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_name_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.unknown));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.monitor_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.monitor_name));
		if (ndr_get_array_length(ndr, &r->in.monitor_name) > ndr_get_array_size(ndr, &r->in.monitor_name)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.monitor_name), ndr_get_array_length(ndr, &r->in.monitor_name));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.monitor_name), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.monitor_name, ndr_get_array_length(ndr, &r->in.monitor_name), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_AddPort(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_AddPort *r)
{
	ndr_print_struct(ndr, name, "spoolss_AddPort");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_AddPort");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "unknown", r->in.unknown);
		ndr_print_string(ndr, "monitor_name", r->in.monitor_name);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_AddPort");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_ConfigurePort(struct ndr_push *ndr, int flags, const struct spoolss_ConfigurePort *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_ConfigurePort(struct ndr_pull *ndr, int flags, struct spoolss_ConfigurePort *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_ConfigurePort(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_ConfigurePort *r)
{
	ndr_print_struct(ndr, name, "spoolss_ConfigurePort");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_ConfigurePort");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_ConfigurePort");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_DeletePort(struct ndr_push *ndr, int flags, const struct spoolss_DeletePort *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_DeletePort(struct ndr_pull *ndr, int flags, struct spoolss_DeletePort *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_DeletePort(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_DeletePort *r)
{
	ndr_print_struct(ndr, name, "spoolss_DeletePort");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_DeletePort");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_DeletePort");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_CreatePrinterIC(struct ndr_push *ndr, int flags, const struct spoolss_CreatePrinterIC *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_CreatePrinterIC(struct ndr_pull *ndr, int flags, struct spoolss_CreatePrinterIC *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_CreatePrinterIC(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_CreatePrinterIC *r)
{
	ndr_print_struct(ndr, name, "spoolss_CreatePrinterIC");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_CreatePrinterIC");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_CreatePrinterIC");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_PlayGDIScriptOnPrinterIC(struct ndr_push *ndr, int flags, const struct spoolss_PlayGDIScriptOnPrinterIC *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_PlayGDIScriptOnPrinterIC(struct ndr_pull *ndr, int flags, struct spoolss_PlayGDIScriptOnPrinterIC *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_PlayGDIScriptOnPrinterIC(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_PlayGDIScriptOnPrinterIC *r)
{
	ndr_print_struct(ndr, name, "spoolss_PlayGDIScriptOnPrinterIC");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_PlayGDIScriptOnPrinterIC");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_PlayGDIScriptOnPrinterIC");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_DeletePrinterIC(struct ndr_push *ndr, int flags, const struct spoolss_DeletePrinterIC *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_DeletePrinterIC(struct ndr_pull *ndr, int flags, struct spoolss_DeletePrinterIC *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_DeletePrinterIC(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_DeletePrinterIC *r)
{
	ndr_print_struct(ndr, name, "spoolss_DeletePrinterIC");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_DeletePrinterIC");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_DeletePrinterIC");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_AddPrinterConnection(struct ndr_push *ndr, int flags, const struct spoolss_AddPrinterConnection *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_AddPrinterConnection(struct ndr_pull *ndr, int flags, struct spoolss_AddPrinterConnection *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_AddPrinterConnection(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_AddPrinterConnection *r)
{
	ndr_print_struct(ndr, name, "spoolss_AddPrinterConnection");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_AddPrinterConnection");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_AddPrinterConnection");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_DeletePrinterConnection(struct ndr_push *ndr, int flags, const struct spoolss_DeletePrinterConnection *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_DeletePrinterConnection(struct ndr_pull *ndr, int flags, struct spoolss_DeletePrinterConnection *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_DeletePrinterConnection(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_DeletePrinterConnection *r)
{
	ndr_print_struct(ndr, name, "spoolss_DeletePrinterConnection");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_DeletePrinterConnection");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_DeletePrinterConnection");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_PrinterMessageBox(struct ndr_push *ndr, int flags, const struct spoolss_PrinterMessageBox *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_PrinterMessageBox(struct ndr_pull *ndr, int flags, struct spoolss_PrinterMessageBox *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_PrinterMessageBox(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_PrinterMessageBox *r)
{
	ndr_print_struct(ndr, name, "spoolss_PrinterMessageBox");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_PrinterMessageBox");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_PrinterMessageBox");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_AddMonitor(struct ndr_push *ndr, int flags, const struct spoolss_AddMonitor *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_AddMonitor(struct ndr_pull *ndr, int flags, struct spoolss_AddMonitor *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_AddMonitor(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_AddMonitor *r)
{
	ndr_print_struct(ndr, name, "spoolss_AddMonitor");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_AddMonitor");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_AddMonitor");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_DeleteMonitor(struct ndr_push *ndr, int flags, const struct spoolss_DeleteMonitor *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_DeleteMonitor(struct ndr_pull *ndr, int flags, struct spoolss_DeleteMonitor *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_DeleteMonitor(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_DeleteMonitor *r)
{
	ndr_print_struct(ndr, name, "spoolss_DeleteMonitor");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_DeleteMonitor");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_DeleteMonitor");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_DeletePrintProcessor(struct ndr_push *ndr, int flags, const struct spoolss_DeletePrintProcessor *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_DeletePrintProcessor(struct ndr_pull *ndr, int flags, struct spoolss_DeletePrintProcessor *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_DeletePrintProcessor(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_DeletePrintProcessor *r)
{
	ndr_print_struct(ndr, name, "spoolss_DeletePrintProcessor");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_DeletePrintProcessor");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_DeletePrintProcessor");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_AddPrintProvidor(struct ndr_push *ndr, int flags, const struct spoolss_AddPrintProvidor *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_AddPrintProvidor(struct ndr_pull *ndr, int flags, struct spoolss_AddPrintProvidor *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_AddPrintProvidor(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_AddPrintProvidor *r)
{
	ndr_print_struct(ndr, name, "spoolss_AddPrintProvidor");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_AddPrintProvidor");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_AddPrintProvidor");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_DeletePrintProvidor(struct ndr_push *ndr, int flags, const struct spoolss_DeletePrintProvidor *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_DeletePrintProvidor(struct ndr_pull *ndr, int flags, struct spoolss_DeletePrintProvidor *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_DeletePrintProvidor(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_DeletePrintProvidor *r)
{
	ndr_print_struct(ndr, name, "spoolss_DeletePrintProvidor");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_DeletePrintProvidor");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_DeletePrintProvidor");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push__spoolss_EnumPrintProcDataTypes(struct ndr_push *ndr, int flags, const struct _spoolss_EnumPrintProcDataTypes *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.servername));
		if (r->in.servername) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.servername, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.servername, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.servername, ndr_charset_length(r->in.servername, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.print_processor_name));
		if (r->in.print_processor_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.print_processor_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.print_processor_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.print_processor_name, ndr_charset_length(r->in.print_processor_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.buffer));
		if (r->in.buffer) {
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, *r->in.buffer));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.offered));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.info));
		if (r->out.info) {
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, *r->out.info));
		}
		if (r->out.needed == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.needed));
		if (r->out.count == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.count));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull__spoolss_EnumPrintProcDataTypes(struct ndr_pull *ndr, int flags, struct _spoolss_EnumPrintProcDataTypes *r)
{
	uint32_t _ptr_servername;
	uint32_t _ptr_print_processor_name;
	uint32_t _ptr_buffer;
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_servername_0;
	TALLOC_CTX *_mem_save_print_processor_name_0;
	TALLOC_CTX *_mem_save_buffer_0;
	TALLOC_CTX *_mem_save_info_0;
	TALLOC_CTX *_mem_save_needed_0;
	TALLOC_CTX *_mem_save_count_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_servername));
		if (_ptr_servername) {
			NDR_PULL_ALLOC(ndr, r->in.servername);
		} else {
			r->in.servername = NULL;
		}
		if (r->in.servername) {
			_mem_save_servername_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.servername, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.servername));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.servername));
			if (ndr_get_array_length(ndr, &r->in.servername) > ndr_get_array_size(ndr, &r->in.servername)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.servername), ndr_get_array_length(ndr, &r->in.servername));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.servername), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.servername, ndr_get_array_length(ndr, &r->in.servername), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_servername_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_print_processor_name));
		if (_ptr_print_processor_name) {
			NDR_PULL_ALLOC(ndr, r->in.print_processor_name);
		} else {
			r->in.print_processor_name = NULL;
		}
		if (r->in.print_processor_name) {
			_mem_save_print_processor_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.print_processor_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.print_processor_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.print_processor_name));
			if (ndr_get_array_length(ndr, &r->in.print_processor_name) > ndr_get_array_size(ndr, &r->in.print_processor_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.print_processor_name), ndr_get_array_length(ndr, &r->in.print_processor_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.print_processor_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.print_processor_name, ndr_get_array_length(ndr, &r->in.print_processor_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_print_processor_name_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_buffer));
		if (_ptr_buffer) {
			NDR_PULL_ALLOC(ndr, r->in.buffer);
		} else {
			r->in.buffer = NULL;
		}
		if (r->in.buffer) {
			_mem_save_buffer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.buffer, 0);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, r->in.buffer));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_buffer_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.offered));
		NDR_PULL_ALLOC(ndr, r->out.needed);
		ZERO_STRUCTP(r->out.needed);
		NDR_PULL_ALLOC(ndr, r->out.count);
		ZERO_STRUCTP(r->out.count);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		} else {
			r->out.info = NULL;
		}
		if (r->out.info) {
			_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.info, 0);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, r->out.info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.needed);
		}
		_mem_save_needed_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.needed, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.needed));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_needed_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.count);
		}
		_mem_save_count_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.count, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.count));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_count_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_push___spoolss_EnumPrintProcDataTypes(struct ndr_push *ndr, int flags, const struct __spoolss_EnumPrintProcDataTypes *r)
{
	uint32_t cntr_info_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.count));
	}
	if (flags & NDR_OUT) {
		for (cntr_info_0 = 0; cntr_info_0 < r->in.count; cntr_info_0++) {
			NDR_CHECK(ndr_push_set_switch_value(ndr, &r->out.info[cntr_info_0], r->in.level));
			NDR_CHECK(ndr_push_spoolss_PrintProcDataTypesInfo(ndr, NDR_SCALARS, &r->out.info[cntr_info_0]));
		}
		for (cntr_info_0 = 0; cntr_info_0 < r->in.count; cntr_info_0++) {
			NDR_CHECK(ndr_push_spoolss_PrintProcDataTypesInfo(ndr, NDR_BUFFERS, &r->out.info[cntr_info_0]));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull___spoolss_EnumPrintProcDataTypes(struct ndr_pull *ndr, int flags, struct __spoolss_EnumPrintProcDataTypes *r)
{
	uint32_t cntr_info_0;
	TALLOC_CTX *_mem_save_info_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.count));
	}
	if (flags & NDR_OUT) {
		NDR_PULL_ALLOC_N(ndr, r->out.info, r->in.count);
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, 0);
		for (cntr_info_0 = 0; cntr_info_0 < r->in.count; cntr_info_0++) {
			NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->out.info[cntr_info_0], r->in.level));
			NDR_CHECK(ndr_pull_spoolss_PrintProcDataTypesInfo(ndr, NDR_SCALARS, &r->out.info[cntr_info_0]));
		}
		for (cntr_info_0 = 0; cntr_info_0 < r->in.count; cntr_info_0++) {
			NDR_CHECK(ndr_pull_spoolss_PrintProcDataTypesInfo(ndr, NDR_BUFFERS, &r->out.info[cntr_info_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_EnumPrintProcDataTypes(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_EnumPrintProcDataTypes *r)
{
	uint32_t cntr_info_2;
	ndr_print_struct(ndr, name, "spoolss_EnumPrintProcDataTypes");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_EnumPrintProcDataTypes");
		ndr->depth++;
		ndr_print_ptr(ndr, "servername", r->in.servername);
		ndr->depth++;
		if (r->in.servername) {
			ndr_print_string(ndr, "servername", r->in.servername);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "print_processor_name", r->in.print_processor_name);
		ndr->depth++;
		if (r->in.print_processor_name) {
			ndr_print_string(ndr, "print_processor_name", r->in.print_processor_name);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		if (r->in.buffer) {
			ndr_print_DATA_BLOB(ndr, "buffer", *r->in.buffer);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "offered", r->in.offered);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_EnumPrintProcDataTypes");
		ndr->depth++;
		ndr_print_ptr(ndr, "count", r->out.count);
		ndr->depth++;
		ndr_print_uint32(ndr, "count", *r->out.count);
		ndr->depth--;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		ndr_print_ptr(ndr, "info", *r->out.info);
		ndr->depth++;
		if (*r->out.info) {
			ndr->print(ndr, "%s: ARRAY(%d)", "info", (int)*r->out.count);
			ndr->depth++;
			for (cntr_info_2=0;cntr_info_2<*r->out.count;cntr_info_2++) {
				char *idx_2=NULL;
				if (asprintf(&idx_2, "[%d]", cntr_info_2) != -1) {
					ndr_print_set_switch_value(ndr, &(*r->out.info)[cntr_info_2], r->in.level);
					ndr_print_spoolss_PrintProcDataTypesInfo(ndr, "info", &(*r->out.info)[cntr_info_2]);
					free(idx_2);
				}
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "needed", r->out.needed);
		ndr->depth++;
		ndr_print_uint32(ndr, "needed", *r->out.needed);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_ResetPrinter(struct ndr_push *ndr, int flags, const struct spoolss_ResetPrinter *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.data_type));
		if (r->in.data_type) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.data_type, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.data_type, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.data_type, ndr_charset_length(r->in.data_type, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->in.devmode_ctr == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_spoolss_DevmodeContainer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.devmode_ctr));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_ResetPrinter(struct ndr_pull *ndr, int flags, struct spoolss_ResetPrinter *r)
{
	uint32_t _ptr_data_type;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_data_type_0;
	TALLOC_CTX *_mem_save_devmode_ctr_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_data_type));
		if (_ptr_data_type) {
			NDR_PULL_ALLOC(ndr, r->in.data_type);
		} else {
			r->in.data_type = NULL;
		}
		if (r->in.data_type) {
			_mem_save_data_type_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.data_type, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.data_type));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.data_type));
			if (ndr_get_array_length(ndr, &r->in.data_type) > ndr_get_array_size(ndr, &r->in.data_type)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.data_type), ndr_get_array_length(ndr, &r->in.data_type));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.data_type), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.data_type, ndr_get_array_length(ndr, &r->in.data_type), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_type_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.devmode_ctr);
		}
		_mem_save_devmode_ctr_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.devmode_ctr, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_spoolss_DevmodeContainer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.devmode_ctr));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_devmode_ctr_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_ResetPrinter(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_ResetPrinter *r)
{
	ndr_print_struct(ndr, name, "spoolss_ResetPrinter");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_ResetPrinter");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "data_type", r->in.data_type);
		ndr->depth++;
		if (r->in.data_type) {
			ndr_print_string(ndr, "data_type", r->in.data_type);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "devmode_ctr", r->in.devmode_ctr);
		ndr->depth++;
		ndr_print_spoolss_DevmodeContainer(ndr, "devmode_ctr", r->in.devmode_ctr);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_ResetPrinter");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_GetPrinterDriver2(struct ndr_push *ndr, int flags, const struct spoolss_GetPrinterDriver2 *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.architecture));
		if (r->in.architecture) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.architecture, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.architecture, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.architecture, ndr_charset_length(r->in.architecture, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.buffer));
		if (r->in.buffer) {
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, *r->in.buffer));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.offered));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.client_major_version));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.client_minor_version));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.info));
		if (r->out.info) {
			{
				struct ndr_push *_ndr_info;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_info, 4, r->in.offered));
				NDR_CHECK(ndr_push_set_switch_value(_ndr_info, r->out.info, r->in.level));
				NDR_CHECK(ndr_push_spoolss_DriverInfo(_ndr_info, NDR_SCALARS|NDR_BUFFERS, r->out.info));
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_info, 4, r->in.offered));
			}
		}
		if (r->out.needed == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.needed));
		if (r->out.server_major_version == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.server_major_version));
		if (r->out.server_minor_version == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.server_minor_version));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_GetPrinterDriver2(struct ndr_pull *ndr, int flags, struct spoolss_GetPrinterDriver2 *r)
{
	uint32_t _ptr_architecture;
	uint32_t _ptr_buffer;
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_architecture_0;
	TALLOC_CTX *_mem_save_buffer_0;
	TALLOC_CTX *_mem_save_info_0;
	TALLOC_CTX *_mem_save_needed_0;
	TALLOC_CTX *_mem_save_server_major_version_0;
	TALLOC_CTX *_mem_save_server_minor_version_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_architecture));
		if (_ptr_architecture) {
			NDR_PULL_ALLOC(ndr, r->in.architecture);
		} else {
			r->in.architecture = NULL;
		}
		if (r->in.architecture) {
			_mem_save_architecture_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.architecture, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.architecture));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.architecture));
			if (ndr_get_array_length(ndr, &r->in.architecture) > ndr_get_array_size(ndr, &r->in.architecture)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.architecture), ndr_get_array_length(ndr, &r->in.architecture));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.architecture), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.architecture, ndr_get_array_length(ndr, &r->in.architecture), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_architecture_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_buffer));
		if (_ptr_buffer) {
			NDR_PULL_ALLOC(ndr, r->in.buffer);
		} else {
			r->in.buffer = NULL;
		}
		if (r->in.buffer) {
			_mem_save_buffer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.buffer, 0);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, r->in.buffer));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_buffer_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.offered));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.client_major_version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.client_minor_version));
		NDR_PULL_ALLOC(ndr, r->out.needed);
		ZERO_STRUCTP(r->out.needed);
		NDR_PULL_ALLOC(ndr, r->out.server_major_version);
		ZERO_STRUCTP(r->out.server_major_version);
		NDR_PULL_ALLOC(ndr, r->out.server_minor_version);
		ZERO_STRUCTP(r->out.server_minor_version);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		} else {
			r->out.info = NULL;
		}
		if (r->out.info) {
			_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.info, 0);
			{
				struct ndr_pull *_ndr_info;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_info, 4, r->in.offered));
				NDR_CHECK(ndr_pull_set_switch_value(_ndr_info, r->out.info, r->in.level));
				NDR_CHECK(ndr_pull_spoolss_DriverInfo(_ndr_info, NDR_SCALARS|NDR_BUFFERS, r->out.info));
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_info, 4, r->in.offered));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.needed);
		}
		_mem_save_needed_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.needed, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.needed));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_needed_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.server_major_version);
		}
		_mem_save_server_major_version_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.server_major_version, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.server_major_version));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_major_version_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.server_minor_version);
		}
		_mem_save_server_minor_version_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.server_minor_version, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.server_minor_version));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_minor_version_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_GetPrinterDriver2(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_GetPrinterDriver2 *r)
{
	ndr_print_struct(ndr, name, "spoolss_GetPrinterDriver2");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_GetPrinterDriver2");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "architecture", r->in.architecture);
		ndr->depth++;
		if (r->in.architecture) {
			ndr_print_string(ndr, "architecture", r->in.architecture);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		if (r->in.buffer) {
			ndr_print_DATA_BLOB(ndr, "buffer", *r->in.buffer);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "offered", r->in.offered);
		ndr_print_uint32(ndr, "client_major_version", r->in.client_major_version);
		ndr_print_uint32(ndr, "client_minor_version", r->in.client_minor_version);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_GetPrinterDriver2");
		ndr->depth++;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		if (r->out.info) {
			ndr_print_set_switch_value(ndr, r->out.info, r->in.level);
			ndr_print_spoolss_DriverInfo(ndr, "info", r->out.info);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "needed", r->out.needed);
		ndr->depth++;
		ndr_print_uint32(ndr, "needed", *r->out.needed);
		ndr->depth--;
		ndr_print_ptr(ndr, "server_major_version", r->out.server_major_version);
		ndr->depth++;
		ndr_print_uint32(ndr, "server_major_version", *r->out.server_major_version);
		ndr->depth--;
		ndr_print_ptr(ndr, "server_minor_version", r->out.server_minor_version);
		ndr->depth++;
		ndr_print_uint32(ndr, "server_minor_version", *r->out.server_minor_version);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_FindFirstPrinterChangeNotification(struct ndr_push *ndr, int flags, const struct spoolss_FindFirstPrinterChangeNotification *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_FindFirstPrinterChangeNotification(struct ndr_pull *ndr, int flags, struct spoolss_FindFirstPrinterChangeNotification *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_FindFirstPrinterChangeNotification(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_FindFirstPrinterChangeNotification *r)
{
	ndr_print_struct(ndr, name, "spoolss_FindFirstPrinterChangeNotification");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_FindFirstPrinterChangeNotification");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_FindFirstPrinterChangeNotification");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_FindNextPrinterChangeNotification(struct ndr_push *ndr, int flags, const struct spoolss_FindNextPrinterChangeNotification *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_FindNextPrinterChangeNotification(struct ndr_pull *ndr, int flags, struct spoolss_FindNextPrinterChangeNotification *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_FindNextPrinterChangeNotification(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_FindNextPrinterChangeNotification *r)
{
	ndr_print_struct(ndr, name, "spoolss_FindNextPrinterChangeNotification");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_FindNextPrinterChangeNotification");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_FindNextPrinterChangeNotification");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_FindClosePrinterNotify(struct ndr_push *ndr, int flags, const struct spoolss_FindClosePrinterNotify *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_FindClosePrinterNotify(struct ndr_pull *ndr, int flags, struct spoolss_FindClosePrinterNotify *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_FindClosePrinterNotify(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_FindClosePrinterNotify *r)
{
	ndr_print_struct(ndr, name, "spoolss_FindClosePrinterNotify");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_FindClosePrinterNotify");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_FindClosePrinterNotify");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_RouterFindFirstPrinterChangeNotificationOld(struct ndr_push *ndr, int flags, const struct spoolss_RouterFindFirstPrinterChangeNotificationOld *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_RouterFindFirstPrinterChangeNotificationOld(struct ndr_pull *ndr, int flags, struct spoolss_RouterFindFirstPrinterChangeNotificationOld *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_RouterFindFirstPrinterChangeNotificationOld(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_RouterFindFirstPrinterChangeNotificationOld *r)
{
	ndr_print_struct(ndr, name, "spoolss_RouterFindFirstPrinterChangeNotificationOld");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_RouterFindFirstPrinterChangeNotificationOld");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_RouterFindFirstPrinterChangeNotificationOld");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_ReplyOpenPrinter(struct ndr_push *ndr, int flags, const struct spoolss_ReplyOpenPrinter *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_name, ndr_charset_length(r->in.server_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.printer_local));
		NDR_CHECK(ndr_push_winreg_Type(ndr, NDR_SCALARS, r->in.type));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.bufsize));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.buffer));
		if (r->in.buffer) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.bufsize));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.buffer, r->in.bufsize));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_ReplyOpenPrinter(struct ndr_pull *ndr, int flags, struct spoolss_ReplyOpenPrinter *r)
{
	uint32_t _ptr_buffer;
	TALLOC_CTX *_mem_save_buffer_0;
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_name));
		if (ndr_get_array_length(ndr, &r->in.server_name) > ndr_get_array_size(ndr, &r->in.server_name)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server_name), ndr_get_array_length(ndr, &r->in.server_name));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server_name), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_name, ndr_get_array_length(ndr, &r->in.server_name), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.printer_local));
		NDR_CHECK(ndr_pull_winreg_Type(ndr, NDR_SCALARS, &r->in.type));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.bufsize));
		if (r->in.bufsize > 512) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_buffer));
		if (_ptr_buffer) {
			NDR_PULL_ALLOC(ndr, r->in.buffer);
		} else {
			r->in.buffer = NULL;
		}
		if (r->in.buffer) {
			_mem_save_buffer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.buffer, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.buffer));
			NDR_PULL_ALLOC_N(ndr, r->in.buffer, ndr_get_array_size(ndr, &r->in.buffer));
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.buffer, ndr_get_array_size(ndr, &r->in.buffer)));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_buffer_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.handle);
		ZERO_STRUCTP(r->out.handle);
		if (r->in.buffer) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->in.buffer, r->in.bufsize));
		}
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_ReplyOpenPrinter(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_ReplyOpenPrinter *r)
{
	ndr_print_struct(ndr, name, "spoolss_ReplyOpenPrinter");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_ReplyOpenPrinter");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_uint32(ndr, "printer_local", r->in.printer_local);
		ndr_print_winreg_Type(ndr, "type", r->in.type);
		ndr_print_uint32(ndr, "bufsize", r->in.bufsize);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		if (r->in.buffer) {
			ndr_print_array_uint8(ndr, "buffer", r->in.buffer, r->in.bufsize);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_ReplyOpenPrinter");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->out.handle);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_RouterReplyPrinter(struct ndr_push *ndr, int flags, const struct spoolss_RouterReplyPrinter *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_spoolss_PrinterChangeFlags(ndr, NDR_SCALARS, r->in.flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.bufsize));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.buffer));
		if (r->in.buffer) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.bufsize));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.buffer, r->in.bufsize));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_RouterReplyPrinter(struct ndr_pull *ndr, int flags, struct spoolss_RouterReplyPrinter *r)
{
	uint32_t _ptr_buffer;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_buffer_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_spoolss_PrinterChangeFlags(ndr, NDR_SCALARS, &r->in.flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.bufsize));
		if (r->in.bufsize > 512) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_buffer));
		if (_ptr_buffer) {
			NDR_PULL_ALLOC(ndr, r->in.buffer);
		} else {
			r->in.buffer = NULL;
		}
		if (r->in.buffer) {
			_mem_save_buffer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.buffer, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.buffer));
			NDR_PULL_ALLOC_N(ndr, r->in.buffer, ndr_get_array_size(ndr, &r->in.buffer));
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.buffer, ndr_get_array_size(ndr, &r->in.buffer)));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_buffer_0, 0);
		}
		if (r->in.buffer) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->in.buffer, r->in.bufsize));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_RouterReplyPrinter(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_RouterReplyPrinter *r)
{
	ndr_print_struct(ndr, name, "spoolss_RouterReplyPrinter");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_RouterReplyPrinter");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_spoolss_PrinterChangeFlags(ndr, "flags", r->in.flags);
		ndr_print_uint32(ndr, "bufsize", r->in.bufsize);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		if (r->in.buffer) {
			ndr_print_array_uint8(ndr, "buffer", r->in.buffer, r->in.bufsize);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_RouterReplyPrinter");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_ReplyClosePrinter(struct ndr_push *ndr, int flags, const struct spoolss_ReplyClosePrinter *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
	}
	if (flags & NDR_OUT) {
		if (r->out.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_ReplyClosePrinter(struct ndr_pull *ndr, int flags, struct spoolss_ReplyClosePrinter *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.handle);
		*r->out.handle = *r->in.handle;
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_ReplyClosePrinter(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_ReplyClosePrinter *r)
{
	ndr_print_struct(ndr, name, "spoolss_ReplyClosePrinter");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_ReplyClosePrinter");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_ReplyClosePrinter");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->out.handle);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_AddPortEx(struct ndr_push *ndr, int flags, const struct spoolss_AddPortEx *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_AddPortEx(struct ndr_pull *ndr, int flags, struct spoolss_AddPortEx *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_AddPortEx(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_AddPortEx *r)
{
	ndr_print_struct(ndr, name, "spoolss_AddPortEx");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_AddPortEx");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_AddPortEx");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_RouterFindFirstPrinterChangeNotification(struct ndr_push *ndr, int flags, const struct spoolss_RouterFindFirstPrinterChangeNotification *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_RouterFindFirstPrinterChangeNotification(struct ndr_pull *ndr, int flags, struct spoolss_RouterFindFirstPrinterChangeNotification *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_RouterFindFirstPrinterChangeNotification(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_RouterFindFirstPrinterChangeNotification *r)
{
	ndr_print_struct(ndr, name, "spoolss_RouterFindFirstPrinterChangeNotification");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_RouterFindFirstPrinterChangeNotification");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_RouterFindFirstPrinterChangeNotification");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_SpoolerInit(struct ndr_push *ndr, int flags, const struct spoolss_SpoolerInit *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_SpoolerInit(struct ndr_pull *ndr, int flags, struct spoolss_SpoolerInit *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_SpoolerInit(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_SpoolerInit *r)
{
	ndr_print_struct(ndr, name, "spoolss_SpoolerInit");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_SpoolerInit");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_SpoolerInit");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_ResetPrinterEx(struct ndr_push *ndr, int flags, const struct spoolss_ResetPrinterEx *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_ResetPrinterEx(struct ndr_pull *ndr, int flags, struct spoolss_ResetPrinterEx *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_ResetPrinterEx(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_ResetPrinterEx *r)
{
	ndr_print_struct(ndr, name, "spoolss_ResetPrinterEx");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_ResetPrinterEx");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_ResetPrinterEx");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_RemoteFindFirstPrinterChangeNotifyEx(struct ndr_push *ndr, int flags, const struct spoolss_RemoteFindFirstPrinterChangeNotifyEx *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_spoolss_PrinterChangeFlags(ndr, NDR_SCALARS, r->in.flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.options));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.local_machine));
		if (r->in.local_machine) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.local_machine, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.local_machine, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.local_machine, ndr_charset_length(r->in.local_machine, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.printer_local));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.notify_options));
		if (r->in.notify_options) {
			NDR_CHECK(ndr_push_spoolss_NotifyOption(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.notify_options));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_RemoteFindFirstPrinterChangeNotifyEx(struct ndr_pull *ndr, int flags, struct spoolss_RemoteFindFirstPrinterChangeNotifyEx *r)
{
	uint32_t _ptr_local_machine;
	uint32_t _ptr_notify_options;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_local_machine_0;
	TALLOC_CTX *_mem_save_notify_options_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_spoolss_PrinterChangeFlags(ndr, NDR_SCALARS, &r->in.flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.options));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_local_machine));
		if (_ptr_local_machine) {
			NDR_PULL_ALLOC(ndr, r->in.local_machine);
		} else {
			r->in.local_machine = NULL;
		}
		if (r->in.local_machine) {
			_mem_save_local_machine_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.local_machine, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.local_machine));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.local_machine));
			if (ndr_get_array_length(ndr, &r->in.local_machine) > ndr_get_array_size(ndr, &r->in.local_machine)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.local_machine), ndr_get_array_length(ndr, &r->in.local_machine));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.local_machine), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.local_machine, ndr_get_array_length(ndr, &r->in.local_machine), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_local_machine_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.printer_local));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_notify_options));
		if (_ptr_notify_options) {
			NDR_PULL_ALLOC(ndr, r->in.notify_options);
		} else {
			r->in.notify_options = NULL;
		}
		if (r->in.notify_options) {
			_mem_save_notify_options_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.notify_options, 0);
			NDR_CHECK(ndr_pull_spoolss_NotifyOption(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.notify_options));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_notify_options_0, 0);
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_RemoteFindFirstPrinterChangeNotifyEx(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_RemoteFindFirstPrinterChangeNotifyEx *r)
{
	ndr_print_struct(ndr, name, "spoolss_RemoteFindFirstPrinterChangeNotifyEx");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_RemoteFindFirstPrinterChangeNotifyEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_spoolss_PrinterChangeFlags(ndr, "flags", r->in.flags);
		ndr_print_uint32(ndr, "options", r->in.options);
		ndr_print_ptr(ndr, "local_machine", r->in.local_machine);
		ndr->depth++;
		if (r->in.local_machine) {
			ndr_print_string(ndr, "local_machine", r->in.local_machine);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "printer_local", r->in.printer_local);
		ndr_print_ptr(ndr, "notify_options", r->in.notify_options);
		ndr->depth++;
		if (r->in.notify_options) {
			ndr_print_spoolss_NotifyOption(ndr, "notify_options", r->in.notify_options);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_RemoteFindFirstPrinterChangeNotifyEx");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_RouterReplyPrinterEx(struct ndr_push *ndr, int flags, const struct spoolss_RouterReplyPrinterEx *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.color));
		NDR_CHECK(ndr_push_spoolss_PrinterChangeFlags(ndr, NDR_SCALARS, r->in.flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.reply_type));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->in.info, r->in.reply_type));
		NDR_CHECK(ndr_push_spoolss_ReplyPrinterInfo(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.info));
	}
	if (flags & NDR_OUT) {
		if (r->out.reply_result == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_spoolss_PrinterNotifyFlags(ndr, NDR_SCALARS, *r->out.reply_result));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_RouterReplyPrinterEx(struct ndr_pull *ndr, int flags, struct spoolss_RouterReplyPrinterEx *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_reply_result_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.color));
		NDR_CHECK(ndr_pull_spoolss_PrinterChangeFlags(ndr, NDR_SCALARS, &r->in.flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.reply_type));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->in.info, r->in.reply_type));
		NDR_CHECK(ndr_pull_spoolss_ReplyPrinterInfo(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.info));
		NDR_PULL_ALLOC(ndr, r->out.reply_result);
		ZERO_STRUCTP(r->out.reply_result);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.reply_result);
		}
		_mem_save_reply_result_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.reply_result, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_spoolss_PrinterNotifyFlags(ndr, NDR_SCALARS, r->out.reply_result));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_reply_result_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_RouterReplyPrinterEx(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_RouterReplyPrinterEx *r)
{
	ndr_print_struct(ndr, name, "spoolss_RouterReplyPrinterEx");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_RouterReplyPrinterEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "color", r->in.color);
		ndr_print_spoolss_PrinterChangeFlags(ndr, "flags", r->in.flags);
		ndr_print_uint32(ndr, "reply_type", r->in.reply_type);
		ndr_print_set_switch_value(ndr, &r->in.info, r->in.reply_type);
		ndr_print_spoolss_ReplyPrinterInfo(ndr, "info", &r->in.info);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_RouterReplyPrinterEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "reply_result", r->out.reply_result);
		ndr->depth++;
		ndr_print_spoolss_PrinterNotifyFlags(ndr, "reply_result", *r->out.reply_result);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_RouterRefreshPrinterChangeNotify(struct ndr_push *ndr, int flags, const struct spoolss_RouterRefreshPrinterChangeNotify *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.change_low));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.options));
		if (r->in.options) {
			NDR_CHECK(ndr_push_spoolss_NotifyOption(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.options));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.info));
		if (*r->out.info) {
			NDR_CHECK(ndr_push_spoolss_NotifyInfo(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.info));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_RouterRefreshPrinterChangeNotify(struct ndr_pull *ndr, int flags, struct spoolss_RouterRefreshPrinterChangeNotify *r)
{
	uint32_t _ptr_options;
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_options_0;
	TALLOC_CTX *_mem_save_info_0;
	TALLOC_CTX *_mem_save_info_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.change_low));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_options));
		if (_ptr_options) {
			NDR_PULL_ALLOC(ndr, r->in.options);
		} else {
			r->in.options = NULL;
		}
		if (r->in.options) {
			_mem_save_options_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.options, 0);
			NDR_CHECK(ndr_pull_spoolss_NotifyOption(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.options));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_options_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.info);
		ZERO_STRUCTP(r->out.info);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, *r->out.info);
		} else {
			*r->out.info = NULL;
		}
		if (*r->out.info) {
			_mem_save_info_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.info, 0);
			NDR_CHECK(ndr_pull_spoolss_NotifyInfo(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_RouterRefreshPrinterChangeNotify(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_RouterRefreshPrinterChangeNotify *r)
{
	ndr_print_struct(ndr, name, "spoolss_RouterRefreshPrinterChangeNotify");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_RouterRefreshPrinterChangeNotify");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "change_low", r->in.change_low);
		ndr_print_ptr(ndr, "options", r->in.options);
		ndr->depth++;
		if (r->in.options) {
			ndr_print_spoolss_NotifyOption(ndr, "options", r->in.options);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_RouterRefreshPrinterChangeNotify");
		ndr->depth++;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		ndr_print_ptr(ndr, "info", *r->out.info);
		ndr->depth++;
		if (*r->out.info) {
			ndr_print_spoolss_NotifyInfo(ndr, "info", *r->out.info);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_44(struct ndr_push *ndr, int flags, const struct spoolss_44 *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_44(struct ndr_pull *ndr, int flags, struct spoolss_44 *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_44(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_44 *r)
{
	ndr_print_struct(ndr, name, "spoolss_44");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_44");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_44");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_spoolss_OpenPrinterEx(struct ndr_push *ndr, int flags, const struct spoolss_OpenPrinterEx *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.printername));
		if (r->in.printername) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.printername, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.printername, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.printername, ndr_charset_length(r->in.printername, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.datatype));
		if (r->in.datatype) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.datatype, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.datatype, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.datatype, ndr_charset_length(r->in.datatype, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_spoolss_DevmodeContainer(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.devmode_ctr));
		NDR_CHECK(ndr_push_spoolss_AccessRights(ndr, NDR_SCALARS, r->in.access_mask));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->in.userlevel, r->in.level));
		NDR_CHECK(ndr_push_spoolss_UserLevel(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.userlevel));
	}
	if (flags & NDR_OUT) {
		if (r->out.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_spoolss_OpenPrinterEx(struct ndr_pull *ndr, int flags, struct spoolss_OpenPrinterEx *r)
{
	uint32_t _ptr_printername;
	uint32_t _ptr_datatype;
	TALLOC_CTX *_mem_save_printername_0;
	TALLOC_CTX *_mem_save_datatype_0;
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_printername));
		if (_ptr_printername) {
			NDR_PULL_ALLOC(ndr, r->in.printername);
		} else {
			r->in.printername = NULL;
		}
		if (r->in.printername) {
			_mem_save_printername_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.printername, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.printername));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.printername));
			if (ndr_get_array_length(ndr, &r->in.printername) > ndr_get_array_size(ndr, &r->in.printername)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.printername), ndr_get_array_length(ndr, &r->in.printername));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.printername), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.printername, ndr_get_array_length(ndr, &r->in.printername), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_printername_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_datatype));
		if (_ptr_datatype) {
			NDR_PULL_ALLOC(ndr, r->in.datatype);
		} else {
			r->in.datatype = NULL;
		}
		if (r->in.datatype) {
			_mem_save_datatype_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.datatype, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.datatype));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.datatype));
			if (ndr_get_array_length(ndr, &r->in.datatype) > ndr_get_array_size(ndr, &r->in.datatype)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.datatype), ndr_get_array_length(ndr, &r->in.datatype));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.datatype), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.datatype, ndr_get_array_length(ndr, &r->in.datatype), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_datatype_0, 0);
		}
		NDR_CHECK(ndr_pull_spoolss_DevmodeContainer(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.devmode_ctr));
		NDR_CHECK(ndr_pull_spoolss_AccessRights(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->in.userlevel, r->in.level));
		NDR_CHECK(ndr_pull_spoolss_UserLevel(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.userlevel));
		NDR_PULL_ALLOC(ndr, r->out.handle);
		ZERO_STRUCTP(r->out.handle);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_OpenPrinterEx(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_OpenPrinterEx *r)
{
	ndr_print_struct(ndr, name, "spoolss_OpenPrinterEx");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_OpenPrinterEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "printername", r->in.printername);
		ndr->depth++;
		if (r->in.printername) {
			ndr_print_string(ndr, "printername", r->in.printername);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "datatype", r->in.datatype);
		ndr->depth++;
		if (r->in.datatype) {
			ndr_print_string(ndr, "datatype", r->in.datatype);
		}
		ndr->depth--;
		ndr_print_spoolss_DevmodeContainer(ndr, "devmode_ctr", &r->in.devmode_ctr);
		ndr_print_spoolss_AccessRights(ndr, "access_mask", r->in.access_mask);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_set_switch_value(ndr, &r->in.userlevel, r->in.level);
		ndr_print_spoolss_UserLevel(ndr, "userlevel", &r->in.userlevel);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_OpenPrinterEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->out.handle);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_AddPrinterEx(struct ndr_push *ndr, int flags, const struct spoolss_AddPrinterEx *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server));
		if (r->in.server) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.server, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.server, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server, ndr_charset_length(r->in.server, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->in.info_ctr == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_spoolss_SetPrinterInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info_ctr));
		if (r->in.devmode_ctr == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_spoolss_DevmodeContainer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.devmode_ctr));
		if (r->in.secdesc_ctr == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_sec_desc_buf(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.secdesc_ctr));
		if (r->in.userlevel_ctr == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_spoolss_UserLevelCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.userlevel_ctr));
	}
	if (flags & NDR_OUT) {
		if (r->out.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_AddPrinterEx(struct ndr_pull *ndr, int flags, struct spoolss_AddPrinterEx *r)
{
	uint32_t _ptr_server;
	TALLOC_CTX *_mem_save_server_0;
	TALLOC_CTX *_mem_save_info_ctr_0;
	TALLOC_CTX *_mem_save_devmode_ctr_0;
	TALLOC_CTX *_mem_save_secdesc_ctr_0;
	TALLOC_CTX *_mem_save_userlevel_ctr_0;
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server));
		if (_ptr_server) {
			NDR_PULL_ALLOC(ndr, r->in.server);
		} else {
			r->in.server = NULL;
		}
		if (r->in.server) {
			_mem_save_server_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server));
			if (ndr_get_array_length(ndr, &r->in.server) > ndr_get_array_size(ndr, &r->in.server)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.server), ndr_get_array_length(ndr, &r->in.server));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.server), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server, ndr_get_array_length(ndr, &r->in.server), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.info_ctr);
		}
		_mem_save_info_ctr_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.info_ctr, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_spoolss_SetPrinterInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info_ctr));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_ctr_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.devmode_ctr);
		}
		_mem_save_devmode_ctr_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.devmode_ctr, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_spoolss_DevmodeContainer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.devmode_ctr));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_devmode_ctr_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.secdesc_ctr);
		}
		_mem_save_secdesc_ctr_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.secdesc_ctr, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_sec_desc_buf(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.secdesc_ctr));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_secdesc_ctr_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.userlevel_ctr);
		}
		_mem_save_userlevel_ctr_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.userlevel_ctr, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_spoolss_UserLevelCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.userlevel_ctr));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_userlevel_ctr_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.handle);
		ZERO_STRUCTP(r->out.handle);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_AddPrinterEx(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_AddPrinterEx *r)
{
	ndr_print_struct(ndr, name, "spoolss_AddPrinterEx");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_AddPrinterEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "server", r->in.server);
		ndr->depth++;
		if (r->in.server) {
			ndr_print_string(ndr, "server", r->in.server);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "info_ctr", r->in.info_ctr);
		ndr->depth++;
		ndr_print_spoolss_SetPrinterInfoCtr(ndr, "info_ctr", r->in.info_ctr);
		ndr->depth--;
		ndr_print_ptr(ndr, "devmode_ctr", r->in.devmode_ctr);
		ndr->depth++;
		ndr_print_spoolss_DevmodeContainer(ndr, "devmode_ctr", r->in.devmode_ctr);
		ndr->depth--;
		ndr_print_ptr(ndr, "secdesc_ctr", r->in.secdesc_ctr);
		ndr->depth++;
		ndr_print_sec_desc_buf(ndr, "secdesc_ctr", r->in.secdesc_ctr);
		ndr->depth--;
		ndr_print_ptr(ndr, "userlevel_ctr", r->in.userlevel_ctr);
		ndr->depth++;
		ndr_print_spoolss_UserLevelCtr(ndr, "userlevel_ctr", r->in.userlevel_ctr);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_AddPrinterEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->out.handle);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_47(struct ndr_push *ndr, int flags, const struct spoolss_47 *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_47(struct ndr_pull *ndr, int flags, struct spoolss_47 *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_47(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_47 *r)
{
	ndr_print_struct(ndr, name, "spoolss_47");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_47");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_47");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_EnumPrinterData(struct ndr_push *ndr, int flags, const struct spoolss_EnumPrinterData *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.enum_index));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.value_offered));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.data_offered));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.value_offered / 2));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->out.value_name, r->in.value_offered / 2, sizeof(uint16_t), CH_UTF16));
		if (r->out.value_needed == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.value_needed));
		if (r->out.type == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_winreg_Type(ndr, NDR_SCALARS, *r->out.type));
		{
			uint32_t _flags_save_uint8 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
			if (r->out.data == NULL) {
				return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
			}
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.data_offered));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.data, r->in.data_offered));
			ndr->flags = _flags_save_uint8;
		}
		if (r->out.data_needed == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.data_needed));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_EnumPrinterData(struct ndr_pull *ndr, int flags, struct spoolss_EnumPrinterData *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_value_needed_0;
	TALLOC_CTX *_mem_save_type_0;
	TALLOC_CTX *_mem_save_data_needed_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.enum_index));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.value_offered));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.data_offered));
		NDR_PULL_ALLOC(ndr, r->out.value_needed);
		ZERO_STRUCTP(r->out.value_needed);
		NDR_PULL_ALLOC(ndr, r->out.type);
		ZERO_STRUCTP(r->out.type);
		NDR_PULL_ALLOC_N(ndr, r->out.data, r->in.data_offered);
		memset(r->out.data, 0, (r->in.data_offered) * sizeof(*r->out.data));
		NDR_PULL_ALLOC(ndr, r->out.data_needed);
		ZERO_STRUCTP(r->out.data_needed);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.value_name));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->out.value_name, ndr_get_array_size(ndr, &r->out.value_name), sizeof(uint16_t), CH_UTF16));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.value_needed);
		}
		_mem_save_value_needed_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.value_needed, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.value_needed));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_value_needed_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.type);
		}
		_mem_save_type_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.type, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_winreg_Type(ndr, NDR_SCALARS, r->out.type));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_type_0, LIBNDR_FLAG_REF_ALLOC);
		{
			uint32_t _flags_save_uint8 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->out.data));
			if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
				NDR_PULL_ALLOC_N(ndr, r->out.data, ndr_get_array_size(ndr, &r->out.data));
			}
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.data, ndr_get_array_size(ndr, &r->out.data)));
			ndr->flags = _flags_save_uint8;
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.data_needed);
		}
		_mem_save_data_needed_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.data_needed, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.data_needed));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_needed_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.value_name) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->out.value_name, r->in.value_offered / 2));
		}
		if (r->out.data) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->out.data, r->in.data_offered));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_EnumPrinterData(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_EnumPrinterData *r)
{
	ndr_print_struct(ndr, name, "spoolss_EnumPrinterData");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_EnumPrinterData");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "enum_index", r->in.enum_index);
		ndr_print_uint32(ndr, "value_offered", r->in.value_offered);
		ndr_print_uint32(ndr, "data_offered", r->in.data_offered);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_EnumPrinterData");
		ndr->depth++;
		ndr_print_string(ndr, "value_name", r->out.value_name);
		ndr_print_ptr(ndr, "value_needed", r->out.value_needed);
		ndr->depth++;
		ndr_print_uint32(ndr, "value_needed", *r->out.value_needed);
		ndr->depth--;
		ndr_print_ptr(ndr, "type", r->out.type);
		ndr->depth++;
		ndr_print_winreg_Type(ndr, "type", *r->out.type);
		ndr->depth--;
		ndr_print_ptr(ndr, "data", r->out.data);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "data", r->out.data, r->in.data_offered);
		ndr->depth--;
		ndr_print_ptr(ndr, "data_needed", r->out.data_needed);
		ndr->depth++;
		ndr_print_uint32(ndr, "data_needed", *r->out.data_needed);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_DeletePrinterData(struct ndr_push *ndr, int flags, const struct spoolss_DeletePrinterData *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.value_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.value_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.value_name, ndr_charset_length(r->in.value_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_DeletePrinterData(struct ndr_pull *ndr, int flags, struct spoolss_DeletePrinterData *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.value_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.value_name));
		if (ndr_get_array_length(ndr, &r->in.value_name) > ndr_get_array_size(ndr, &r->in.value_name)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.value_name), ndr_get_array_length(ndr, &r->in.value_name));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.value_name), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.value_name, ndr_get_array_length(ndr, &r->in.value_name), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_DeletePrinterData(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_DeletePrinterData *r)
{
	ndr_print_struct(ndr, name, "spoolss_DeletePrinterData");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_DeletePrinterData");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_string(ndr, "value_name", r->in.value_name);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_DeletePrinterData");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_4a(struct ndr_push *ndr, int flags, const struct spoolss_4a *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_4a(struct ndr_pull *ndr, int flags, struct spoolss_4a *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_4a(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_4a *r)
{
	ndr_print_struct(ndr, name, "spoolss_4a");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_4a");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_4a");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_4b(struct ndr_push *ndr, int flags, const struct spoolss_4b *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_4b(struct ndr_pull *ndr, int flags, struct spoolss_4b *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_4b(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_4b *r)
{
	ndr_print_struct(ndr, name, "spoolss_4b");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_4b");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_4b");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_4c(struct ndr_push *ndr, int flags, const struct spoolss_4c *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_4c(struct ndr_pull *ndr, int flags, struct spoolss_4c *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_spoolss_4c(struct ndr_print *ndr, const char *name, int flags, const struct spoolss_4c *r)
{
	ndr_print_struct(ndr, name, "spoolss_4c");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "spoolss_4c");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "spoolss_4c");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_spoolss_SetPrinterDataEx(struct ndr_push *ndr, int flags, const struct spoolss_SetPrinterDataEx *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.key_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.key_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.key_name, ndr_charset_length(r->in.key_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.value_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.value_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.value_name, ndr_charset_length(r->in.value_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_winreg_Type(ndr, NDR_SCALARS, r->in.type));
		if (r->in.buffer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.offered));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.buffer, r->in.offered));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.offered));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_spoolss_SetPrinterDataEx(struct ndr_pull *ndr, int flags, struct spoolss_SetPrinterDataEx *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.key_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.key_name));
		if (ndr_get_array_length(ndr, &r->in.key_name) > ndr_get_array_size(ndr, &r->in.key_name)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.key_name), ndr_get_array_length(ndr, &r->in.key_name));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.key_name), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.key_name, ndr_get_array_length(ndr, &r->in.key_name), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(