/* parser auto-generated by pidl */

#include "includes.h"
#include "../librpc/gen_ndr/ndr_dfs.h"

#include "librpc/gen_ndr/ndr_misc.h"
static enum ndr_err_code ndr_push_dfs_ManagerVersion(struct ndr_push *ndr, int ndr_flags, enum dfs_ManagerVersion r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_ManagerVersion(struct ndr_pull *ndr, int ndr_flags, enum dfs_ManagerVersion *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_ManagerVersion(struct ndr_print *ndr, const char *name, enum dfs_ManagerVersion r)
{
	const char *val = NULL;

	switch (r) {
		case DFS_MANAGER_VERSION_NT4: val = "DFS_MANAGER_VERSION_NT4"; break;
		case DFS_MANAGER_VERSION_W2K: val = "DFS_MANAGER_VERSION_W2K"; break;
		case DFS_MANAGER_VERSION_W2K3: val = "DFS_MANAGER_VERSION_W2K3"; break;
		case DFS_MANAGER_VERSION_W2K8: val = "DFS_MANAGER_VERSION_W2K8"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_dfs_Info0(struct ndr_push *ndr, int ndr_flags, const struct dfs_Info0 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_Info0(struct ndr_pull *ndr, int ndr_flags, struct dfs_Info0 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_Info0(struct ndr_print *ndr, const char *name, const struct dfs_Info0 *r)
{
	ndr_print_struct(ndr, name, "dfs_Info0");
	ndr->depth++;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_Info1(struct ndr_push *ndr, int ndr_flags, const struct dfs_Info1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->path));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->path) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->path, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->path, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->path, ndr_charset_length(r->path, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_Info1(struct ndr_pull *ndr, int ndr_flags, struct dfs_Info1 *r)
{
	uint32_t _ptr_path;
	uint32_t size_path_1 = 0;
	uint32_t length_path_1 = 0;
	TALLOC_CTX *_mem_save_path_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_path));
		if (_ptr_path) {
			NDR_PULL_ALLOC(ndr, r->path);
		} else {
			r->path = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->path) {
			_mem_save_path_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->path, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->path));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->path));
			size_path_1 = ndr_get_array_size(ndr, &r->path);
			length_path_1 = ndr_get_array_length(ndr, &r->path);
			if (length_path_1 > size_path_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_path_1, length_path_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_path_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->path, length_path_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_path_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_Info1(struct ndr_print *ndr, const char *name, const struct dfs_Info1 *r)
{
	ndr_print_struct(ndr, name, "dfs_Info1");
	ndr->depth++;
	ndr_print_ptr(ndr, "path", r->path);
	ndr->depth++;
	if (r->path) {
		ndr_print_string(ndr, "path", r->path);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dfs_VolumeState(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dfs_VolumeState(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_VolumeState(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DFS_VOLUME_STATE_OK", DFS_VOLUME_STATE_OK, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DFS_VOLUME_STATE_INCONSISTENT", DFS_VOLUME_STATE_INCONSISTENT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DFS_VOLUME_STATE_OFFLINE", DFS_VOLUME_STATE_OFFLINE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DFS_VOLUME_STATE_ONLINE", DFS_VOLUME_STATE_ONLINE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DFS_VOLUME_STATE_STANDALONE", DFS_VOLUME_STATE_STANDALONE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DFS_VOLUME_STATE_AD_BLOB", DFS_VOLUME_STATE_AD_BLOB, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_Info2(struct ndr_push *ndr, int ndr_flags, const struct dfs_Info2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->path));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->comment));
		NDR_CHECK(ndr_push_dfs_VolumeState(ndr, NDR_SCALARS, r->state));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_stores));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->path) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->path, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->path, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->path, ndr_charset_length(r->path, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->comment) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->comment, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->comment, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->comment, ndr_charset_length(r->comment, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_Info2(struct ndr_pull *ndr, int ndr_flags, struct dfs_Info2 *r)
{
	uint32_t _ptr_path;
	uint32_t size_path_1 = 0;
	uint32_t length_path_1 = 0;
	TALLOC_CTX *_mem_save_path_0;
	uint32_t _ptr_comment;
	uint32_t size_comment_1 = 0;
	uint32_t length_comment_1 = 0;
	TALLOC_CTX *_mem_save_comment_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_path));
		if (_ptr_path) {
			NDR_PULL_ALLOC(ndr, r->path);
		} else {
			r->path = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_comment));
		if (_ptr_comment) {
			NDR_PULL_ALLOC(ndr, r->comment);
		} else {
			r->comment = NULL;
		}
		NDR_CHECK(ndr_pull_dfs_VolumeState(ndr, NDR_SCALARS, &r->state));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_stores));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->path) {
			_mem_save_path_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->path, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->path));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->path));
			size_path_1 = ndr_get_array_size(ndr, &r->path);
			length_path_1 = ndr_get_array_length(ndr, &r->path);
			if (length_path_1 > size_path_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_path_1, length_path_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_path_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->path, length_path_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_path_0, 0);
		}
		if (r->comment) {
			_mem_save_comment_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->comment, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->comment));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->comment));
			size_comment_1 = ndr_get_array_size(ndr, &r->comment);
			length_comment_1 = ndr_get_array_length(ndr, &r->comment);
			if (length_comment_1 > size_comment_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_comment_1, length_comment_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_comment_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->comment, length_comment_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_comment_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_Info2(struct ndr_print *ndr, const char *name, const struct dfs_Info2 *r)
{
	ndr_print_struct(ndr, name, "dfs_Info2");
	ndr->depth++;
	ndr_print_ptr(ndr, "path", r->path);
	ndr->depth++;
	if (r->path) {
		ndr_print_string(ndr, "path", r->path);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "comment", r->comment);
	ndr->depth++;
	if (r->comment) {
		ndr_print_string(ndr, "comment", r->comment);
	}
	ndr->depth--;
	ndr_print_dfs_VolumeState(ndr, "state", r->state);
	ndr_print_uint32(ndr, "num_stores", r->num_stores);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dfs_StorageState(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dfs_StorageState(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_StorageState(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DFS_STORAGE_STATE_OFFLINE", DFS_STORAGE_STATE_OFFLINE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DFS_STORAGE_STATE_ONLINE", DFS_STORAGE_STATE_ONLINE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DFS_STORAGE_STATE_ACTIVE", DFS_STORAGE_STATE_ACTIVE, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_StorageInfo(struct ndr_push *ndr, int ndr_flags, const struct dfs_StorageInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_dfs_StorageState(ndr, NDR_SCALARS, r->state));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->server));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->share));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->server) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->server, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->server, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->server, ndr_charset_length(r->server, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->share) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->share, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->share, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->share, ndr_charset_length(r->share, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_StorageInfo(struct ndr_pull *ndr, int ndr_flags, struct dfs_StorageInfo *r)
{
	uint32_t _ptr_server;
	uint32_t size_server_1 = 0;
	uint32_t length_server_1 = 0;
	TALLOC_CTX *_mem_save_server_0;
	uint32_t _ptr_share;
	uint32_t size_share_1 = 0;
	uint32_t length_share_1 = 0;
	TALLOC_CTX *_mem_save_share_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_dfs_StorageState(ndr, NDR_SCALARS, &r->state));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server));
		if (_ptr_server) {
			NDR_PULL_ALLOC(ndr, r->server);
		} else {
			r->server = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_share));
		if (_ptr_share) {
			NDR_PULL_ALLOC(ndr, r->share);
		} else {
			r->share = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->server) {
			_mem_save_server_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->server, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->server));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->server));
			size_server_1 = ndr_get_array_size(ndr, &r->server);
			length_server_1 = ndr_get_array_length(ndr, &r->server);
			if (length_server_1 > size_server_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_server_1, length_server_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_server_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->server, length_server_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_0, 0);
		}
		if (r->share) {
			_mem_save_share_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->share, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->share));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->share));
			size_share_1 = ndr_get_array_size(ndr, &r->share);
			length_share_1 = ndr_get_array_length(ndr, &r->share);
			if (length_share_1 > size_share_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_share_1, length_share_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_share_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->share, length_share_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_share_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_StorageInfo(struct ndr_print *ndr, const char *name, const struct dfs_StorageInfo *r)
{
	ndr_print_struct(ndr, name, "dfs_StorageInfo");
	ndr->depth++;
	ndr_print_dfs_StorageState(ndr, "state", r->state);
	ndr_print_ptr(ndr, "server", r->server);
	ndr->depth++;
	if (r->server) {
		ndr_print_string(ndr, "server", r->server);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "share", r->share);
	ndr->depth++;
	if (r->share) {
		ndr_print_string(ndr, "share", r->share);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_Info3(struct ndr_push *ndr, int ndr_flags, const struct dfs_Info3 *r)
{
	uint32_t cntr_stores_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->path));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->comment));
		NDR_CHECK(ndr_push_dfs_VolumeState(ndr, NDR_SCALARS, r->state));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_stores));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->stores));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->path) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->path, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->path, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->path, ndr_charset_length(r->path, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->comment) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->comment, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->comment, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->comment, ndr_charset_length(r->comment, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->stores) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_stores));
			for (cntr_stores_1 = 0; cntr_stores_1 < r->num_stores; cntr_stores_1++) {
				NDR_CHECK(ndr_push_dfs_StorageInfo(ndr, NDR_SCALARS, &r->stores[cntr_stores_1]));
			}
			for (cntr_stores_1 = 0; cntr_stores_1 < r->num_stores; cntr_stores_1++) {
				NDR_CHECK(ndr_push_dfs_StorageInfo(ndr, NDR_BUFFERS, &r->stores[cntr_stores_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_Info3(struct ndr_pull *ndr, int ndr_flags, struct dfs_Info3 *r)
{
	uint32_t _ptr_path;
	uint32_t size_path_1 = 0;
	uint32_t length_path_1 = 0;
	TALLOC_CTX *_mem_save_path_0;
	uint32_t _ptr_comment;
	uint32_t size_comment_1 = 0;
	uint32_t length_comment_1 = 0;
	TALLOC_CTX *_mem_save_comment_0;
	uint32_t _ptr_stores;
	uint32_t size_stores_1 = 0;
	uint32_t cntr_stores_1;
	TALLOC_CTX *_mem_save_stores_0;
	TALLOC_CTX *_mem_save_stores_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_path));
		if (_ptr_path) {
			NDR_PULL_ALLOC(ndr, r->path);
		} else {
			r->path = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_comment));
		if (_ptr_comment) {
			NDR_PULL_ALLOC(ndr, r->comment);
		} else {
			r->comment = NULL;
		}
		NDR_CHECK(ndr_pull_dfs_VolumeState(ndr, NDR_SCALARS, &r->state));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_stores));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_stores));
		if (_ptr_stores) {
			NDR_PULL_ALLOC(ndr, r->stores);
		} else {
			r->stores = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->path) {
			_mem_save_path_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->path, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->path));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->path));
			size_path_1 = ndr_get_array_size(ndr, &r->path);
			length_path_1 = ndr_get_array_length(ndr, &r->path);
			if (length_path_1 > size_path_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_path_1, length_path_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_path_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->path, length_path_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_path_0, 0);
		}
		if (r->comment) {
			_mem_save_comment_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->comment, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->comment));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->comment));
			size_comment_1 = ndr_get_array_size(ndr, &r->comment);
			length_comment_1 = ndr_get_array_length(ndr, &r->comment);
			if (length_comment_1 > size_comment_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_comment_1, length_comment_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_comment_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->comment, length_comment_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_comment_0, 0);
		}
		if (r->stores) {
			_mem_save_stores_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->stores, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->stores));
			size_stores_1 = ndr_get_array_size(ndr, &r->stores);
			NDR_PULL_ALLOC_N(ndr, r->stores, size_stores_1);
			_mem_save_stores_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->stores, 0);
			for (cntr_stores_1 = 0; cntr_stores_1 < size_stores_1; cntr_stores_1++) {
				NDR_CHECK(ndr_pull_dfs_StorageInfo(ndr, NDR_SCALARS, &r->stores[cntr_stores_1]));
			}
			for (cntr_stores_1 = 0; cntr_stores_1 < size_stores_1; cntr_stores_1++) {
				NDR_CHECK(ndr_pull_dfs_StorageInfo(ndr, NDR_BUFFERS, &r->stores[cntr_stores_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_stores_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_stores_0, 0);
		}
		if (r->stores) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->stores, r->num_stores));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_Info3(struct ndr_print *ndr, const char *name, const struct dfs_Info3 *r)
{
	uint32_t cntr_stores_1;
	ndr_print_struct(ndr, name, "dfs_Info3");
	ndr->depth++;
	ndr_print_ptr(ndr, "path", r->path);
	ndr->depth++;
	if (r->path) {
		ndr_print_string(ndr, "path", r->path);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "comment", r->comment);
	ndr->depth++;
	if (r->comment) {
		ndr_print_string(ndr, "comment", r->comment);
	}
	ndr->depth--;
	ndr_print_dfs_VolumeState(ndr, "state", r->state);
	ndr_print_uint32(ndr, "num_stores", r->num_stores);
	ndr_print_ptr(ndr, "stores", r->stores);
	ndr->depth++;
	if (r->stores) {
		ndr->print(ndr, "%s: ARRAY(%d)", "stores", (int)r->num_stores);
		ndr->depth++;
		for (cntr_stores_1=0;cntr_stores_1<r->num_stores;cntr_stores_1++) {
			char *idx_1=NULL;
			if (asprintf(&idx_1, "[%d]", cntr_stores_1) != -1) {
				ndr_print_dfs_StorageInfo(ndr, "stores", &r->stores[cntr_stores_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_Info4(struct ndr_push *ndr, int ndr_flags, const struct dfs_Info4 *r)
{
	uint32_t cntr_stores_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->path));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->comment));
		NDR_CHECK(ndr_push_dfs_VolumeState(ndr, NDR_SCALARS, r->state));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->timeout));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->guid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_stores));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->stores));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->path) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->path, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->path, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->path, ndr_charset_length(r->path, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->comment) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->comment, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->comment, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->comment, ndr_charset_length(r->comment, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->stores) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_stores));
			for (cntr_stores_1 = 0; cntr_stores_1 < r->num_stores; cntr_stores_1++) {
				NDR_CHECK(ndr_push_dfs_StorageInfo(ndr, NDR_SCALARS, &r->stores[cntr_stores_1]));
			}
			for (cntr_stores_1 = 0; cntr_stores_1 < r->num_stores; cntr_stores_1++) {
				NDR_CHECK(ndr_push_dfs_StorageInfo(ndr, NDR_BUFFERS, &r->stores[cntr_stores_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_Info4(struct ndr_pull *ndr, int ndr_flags, struct dfs_Info4 *r)
{
	uint32_t _ptr_path;
	uint32_t size_path_1 = 0;
	uint32_t length_path_1 = 0;
	TALLOC_CTX *_mem_save_path_0;
	uint32_t _ptr_comment;
	uint32_t size_comment_1 = 0;
	uint32_t length_comment_1 = 0;
	TALLOC_CTX *_mem_save_comment_0;
	uint32_t _ptr_stores;
	uint32_t size_stores_1 = 0;
	uint32_t cntr_stores_1;
	TALLOC_CTX *_mem_save_stores_0;
	TALLOC_CTX *_mem_save_stores_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_path));
		if (_ptr_path) {
			NDR_PULL_ALLOC(ndr, r->path);
		} else {
			r->path = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_comment));
		if (_ptr_comment) {
			NDR_PULL_ALLOC(ndr, r->comment);
		} else {
			r->comment = NULL;
		}
		NDR_CHECK(ndr_pull_dfs_VolumeState(ndr, NDR_SCALARS, &r->state));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->timeout));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->guid));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_stores));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_stores));
		if (_ptr_stores) {
			NDR_PULL_ALLOC(ndr, r->stores);
		} else {
			r->stores = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->path) {
			_mem_save_path_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->path, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->path));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->path));
			size_path_1 = ndr_get_array_size(ndr, &r->path);
			length_path_1 = ndr_get_array_length(ndr, &r->path);
			if (length_path_1 > size_path_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_path_1, length_path_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_path_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->path, length_path_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_path_0, 0);
		}
		if (r->comment) {
			_mem_save_comment_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->comment, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->comment));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->comment));
			size_comment_1 = ndr_get_array_size(ndr, &r->comment);
			length_comment_1 = ndr_get_array_length(ndr, &r->comment);
			if (length_comment_1 > size_comment_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_comment_1, length_comment_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_comment_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->comment, length_comment_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_comment_0, 0);
		}
		if (r->stores) {
			_mem_save_stores_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->stores, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->stores));
			size_stores_1 = ndr_get_array_size(ndr, &r->stores);
			NDR_PULL_ALLOC_N(ndr, r->stores, size_stores_1);
			_mem_save_stores_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->stores, 0);
			for (cntr_stores_1 = 0; cntr_stores_1 < size_stores_1; cntr_stores_1++) {
				NDR_CHECK(ndr_pull_dfs_StorageInfo(ndr, NDR_SCALARS, &r->stores[cntr_stores_1]));
			}
			for (cntr_stores_1 = 0; cntr_stores_1 < size_stores_1; cntr_stores_1++) {
				NDR_CHECK(ndr_pull_dfs_StorageInfo(ndr, NDR_BUFFERS, &r->stores[cntr_stores_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_stores_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_stores_0, 0);
		}
		if (r->stores) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->stores, r->num_stores));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_Info4(struct ndr_print *ndr, const char *name, const struct dfs_Info4 *r)
{
	uint32_t cntr_stores_1;
	ndr_print_struct(ndr, name, "dfs_Info4");
	ndr->depth++;
	ndr_print_ptr(ndr, "path", r->path);
	ndr->depth++;
	if (r->path) {
		ndr_print_string(ndr, "path", r->path);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "comment", r->comment);
	ndr->depth++;
	if (r->comment) {
		ndr_print_string(ndr, "comment", r->comment);
	}
	ndr->depth--;
	ndr_print_dfs_VolumeState(ndr, "state", r->state);
	ndr_print_uint32(ndr, "timeout", r->timeout);
	ndr_print_GUID(ndr, "guid", &r->guid);
	ndr_print_uint32(ndr, "num_stores", r->num_stores);
	ndr_print_ptr(ndr, "stores", r->stores);
	ndr->depth++;
	if (r->stores) {
		ndr->print(ndr, "%s: ARRAY(%d)", "stores", (int)r->num_stores);
		ndr->depth++;
		for (cntr_stores_1=0;cntr_stores_1<r->num_stores;cntr_stores_1++) {
			char *idx_1=NULL;
			if (asprintf(&idx_1, "[%d]", cntr_stores_1) != -1) {
				ndr_print_dfs_StorageInfo(ndr, "stores", &r->stores[cntr_stores_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dfs_PropertyFlags(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dfs_PropertyFlags(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_PropertyFlags(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DFS_PROPERTY_FLAG_INSITE_REFERRALS", DFS_PROPERTY_FLAG_INSITE_REFERRALS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DFS_PROPERTY_FLAG_ROOT_SCALABILITY", DFS_PROPERTY_FLAG_ROOT_SCALABILITY, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DFS_PROPERTY_FLAG_SITE_COSTING", DFS_PROPERTY_FLAG_SITE_COSTING, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DFS_PROPERTY_FLAG_TARGET_FAILBACK", DFS_PROPERTY_FLAG_TARGET_FAILBACK, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DFS_PROPERTY_FLAG_CLUSTER_ENABLED", DFS_PROPERTY_FLAG_CLUSTER_ENABLED, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_Info5(struct ndr_push *ndr, int ndr_flags, const struct dfs_Info5 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->path));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->comment));
		NDR_CHECK(ndr_push_dfs_VolumeState(ndr, NDR_SCALARS, r->state));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->timeout));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->guid));
		NDR_CHECK(ndr_push_dfs_PropertyFlags(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->pktsize));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_stores));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->path) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->path, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->path, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->path, ndr_charset_length(r->path, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->comment) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->comment, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->comment, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->comment, ndr_charset_length(r->comment, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_Info5(struct ndr_pull *ndr, int ndr_flags, struct dfs_Info5 *r)
{
	uint32_t _ptr_path;
	uint32_t size_path_1 = 0;
	uint32_t length_path_1 = 0;
	TALLOC_CTX *_mem_save_path_0;
	uint32_t _ptr_comment;
	uint32_t size_comment_1 = 0;
	uint32_t length_comment_1 = 0;
	TALLOC_CTX *_mem_save_comment_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_path));
		if (_ptr_path) {
			NDR_PULL_ALLOC(ndr, r->path);
		} else {
			r->path = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_comment));
		if (_ptr_comment) {
			NDR_PULL_ALLOC(ndr, r->comment);
		} else {
			r->comment = NULL;
		}
		NDR_CHECK(ndr_pull_dfs_VolumeState(ndr, NDR_SCALARS, &r->state));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->timeout));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->guid));
		NDR_CHECK(ndr_pull_dfs_PropertyFlags(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->pktsize));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_stores));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->path) {
			_mem_save_path_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->path, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->path));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->path));
			size_path_1 = ndr_get_array_size(ndr, &r->path);
			length_path_1 = ndr_get_array_length(ndr, &r->path);
			if (length_path_1 > size_path_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_path_1, length_path_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_path_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->path, length_path_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_path_0, 0);
		}
		if (r->comment) {
			_mem_save_comment_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->comment, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->comment));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->comment));
			size_comment_1 = ndr_get_array_size(ndr, &r->comment);
			length_comment_1 = ndr_get_array_length(ndr, &r->comment);
			if (length_comment_1 > size_comment_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_comment_1, length_comment_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_comment_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->comment, length_comment_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_comment_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_Info5(struct ndr_print *ndr, const char *name, const struct dfs_Info5 *r)
{
	ndr_print_struct(ndr, name, "dfs_Info5");
	ndr->depth++;
	ndr_print_ptr(ndr, "path", r->path);
	ndr->depth++;
	if (r->path) {
		ndr_print_string(ndr, "path", r->path);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "comment", r->comment);
	ndr->depth++;
	if (r->comment) {
		ndr_print_string(ndr, "comment", r->comment);
	}
	ndr->depth--;
	ndr_print_dfs_VolumeState(ndr, "state", r->state);
	ndr_print_uint32(ndr, "timeout", r->timeout);
	ndr_print_GUID(ndr, "guid", &r->guid);
	ndr_print_dfs_PropertyFlags(ndr, "flags", r->flags);
	ndr_print_uint32(ndr, "pktsize", r->pktsize);
	ndr_print_uint32(ndr, "num_stores", r->num_stores);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_Target_PriorityClass(struct ndr_push *ndr, int ndr_flags, enum dfs_Target_PriorityClass r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_Target_PriorityClass(struct ndr_pull *ndr, int ndr_flags, enum dfs_Target_PriorityClass *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_Target_PriorityClass(struct ndr_print *ndr, const char *name, enum dfs_Target_PriorityClass r)
{
	const char *val = NULL;

	switch (r) {
		case DFS_INVALID_PRIORITY_CLASS: val = "DFS_INVALID_PRIORITY_CLASS"; break;
		case DFS_SITE_COST_NORMAL_PRIORITY_CLASS: val = "DFS_SITE_COST_NORMAL_PRIORITY_CLASS"; break;
		case DFS_GLOBAL_HIGH_PRIORITY_CLASS: val = "DFS_GLOBAL_HIGH_PRIORITY_CLASS"; break;
		case DFS_SITE_COST_HIGH_PRIORITY_CLASS: val = "DFS_SITE_COST_HIGH_PRIORITY_CLASS"; break;
		case DFS_SITE_COST_LOW_PRIORITY_CLASS: val = "DFS_SITE_COST_LOW_PRIORITY_CLASS"; break;
		case DFS_GLOBAL_LOW_PRIORITY_CLASS: val = "DFS_GLOBAL_LOW_PRIORITY_CLASS"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_dfs_Target_Priority(struct ndr_push *ndr, int ndr_flags, const struct dfs_Target_Priority *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_dfs_Target_PriorityClass(ndr, NDR_SCALARS, r->target_priority_class));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->target_priority_rank));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->reserved));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_Target_Priority(struct ndr_pull *ndr, int ndr_flags, struct dfs_Target_Priority *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_dfs_Target_PriorityClass(ndr, NDR_SCALARS, &r->target_priority_class));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->target_priority_rank));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->reserved));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_Target_Priority(struct ndr_print *ndr, const char *name, const struct dfs_Target_Priority *r)
{
	ndr_print_struct(ndr, name, "dfs_Target_Priority");
	ndr->depth++;
	ndr_print_dfs_Target_PriorityClass(ndr, "target_priority_class", r->target_priority_class);
	ndr_print_uint16(ndr, "target_priority_rank", r->target_priority_rank);
	ndr_print_uint16(ndr, "reserved", r->reserved);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_StorageInfo2(struct ndr_push *ndr, int ndr_flags, const struct dfs_StorageInfo2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_dfs_StorageInfo(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_push_dfs_Target_Priority(ndr, NDR_SCALARS, &r->target_priority));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_dfs_StorageInfo(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_StorageInfo2(struct ndr_pull *ndr, int ndr_flags, struct dfs_StorageInfo2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_dfs_StorageInfo(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_pull_dfs_Target_Priority(ndr, NDR_SCALARS, &r->target_priority));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_dfs_StorageInfo(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_StorageInfo2(struct ndr_print *ndr, const char *name, const struct dfs_StorageInfo2 *r)
{
	ndr_print_struct(ndr, name, "dfs_StorageInfo2");
	ndr->depth++;
	ndr_print_dfs_StorageInfo(ndr, "info", &r->info);
	ndr_print_dfs_Target_Priority(ndr, "target_priority", &r->target_priority);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_Info6(struct ndr_push *ndr, int ndr_flags, const struct dfs_Info6 *r)
{
	uint32_t cntr_stores_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->entry_path));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->comment));
		NDR_CHECK(ndr_push_dfs_VolumeState(ndr, NDR_SCALARS, r->state));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->timeout));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->guid));
		NDR_CHECK(ndr_push_dfs_PropertyFlags(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->pktsize));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->num_stores));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->stores));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->entry_path) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->entry_path, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->entry_path, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->entry_path, ndr_charset_length(r->entry_path, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->comment) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->comment, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->comment, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->comment, ndr_charset_length(r->comment, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->stores) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_stores));
			for (cntr_stores_1 = 0; cntr_stores_1 < r->num_stores; cntr_stores_1++) {
				NDR_CHECK(ndr_push_dfs_StorageInfo2(ndr, NDR_SCALARS, &r->stores[cntr_stores_1]));
			}
			for (cntr_stores_1 = 0; cntr_stores_1 < r->num_stores; cntr_stores_1++) {
				NDR_CHECK(ndr_push_dfs_StorageInfo2(ndr, NDR_BUFFERS, &r->stores[cntr_stores_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_Info6(struct ndr_pull *ndr, int ndr_flags, struct dfs_Info6 *r)
{
	uint32_t _ptr_entry_path;
	uint32_t size_entry_path_1 = 0;
	uint32_t length_entry_path_1 = 0;
	TALLOC_CTX *_mem_save_entry_path_0;
	uint32_t _ptr_comment;
	uint32_t size_comment_1 = 0;
	uint32_t length_comment_1 = 0;
	TALLOC_CTX *_mem_save_comment_0;
	uint32_t _ptr_stores;
	uint32_t size_stores_1 = 0;
	uint32_t cntr_stores_1;
	TALLOC_CTX *_mem_save_stores_0;
	TALLOC_CTX *_mem_save_stores_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_entry_path));
		if (_ptr_entry_path) {
			NDR_PULL_ALLOC(ndr, r->entry_path);
		} else {
			r->entry_path = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_comment));
		if (_ptr_comment) {
			NDR_PULL_ALLOC(ndr, r->comment);
		} else {
			r->comment = NULL;
		}
		NDR_CHECK(ndr_pull_dfs_VolumeState(ndr, NDR_SCALARS, &r->state));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->timeout));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->guid));
		NDR_CHECK(ndr_pull_dfs_PropertyFlags(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->pktsize));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->num_stores));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_stores));
		if (_ptr_stores) {
			NDR_PULL_ALLOC(ndr, r->stores);
		} else {
			r->stores = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->entry_path) {
			_mem_save_entry_path_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->entry_path, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->entry_path));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->entry_path));
			size_entry_path_1 = ndr_get_array_size(ndr, &r->entry_path);
			length_entry_path_1 = ndr_get_array_length(ndr, &r->entry_path);
			if (length_entry_path_1 > size_entry_path_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_entry_path_1, length_entry_path_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_entry_path_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->entry_path, length_entry_path_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_entry_path_0, 0);
		}
		if (r->comment) {
			_mem_save_comment_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->comment, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->comment));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->comment));
			size_comment_1 = ndr_get_array_size(ndr, &r->comment);
			length_comment_1 = ndr_get_array_length(ndr, &r->comment);
			if (length_comment_1 > size_comment_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_comment_1, length_comment_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_comment_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->comment, length_comment_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_comment_0, 0);
		}
		if (r->stores) {
			_mem_save_stores_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->stores, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->stores));
			size_stores_1 = ndr_get_array_size(ndr, &r->stores);
			NDR_PULL_ALLOC_N(ndr, r->stores, size_stores_1);
			_mem_save_stores_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->stores, 0);
			for (cntr_stores_1 = 0; cntr_stores_1 < size_stores_1; cntr_stores_1++) {
				NDR_CHECK(ndr_pull_dfs_StorageInfo2(ndr, NDR_SCALARS, &r->stores[cntr_stores_1]));
			}
			for (cntr_stores_1 = 0; cntr_stores_1 < size_stores_1; cntr_stores_1++) {
				NDR_CHECK(ndr_pull_dfs_StorageInfo2(ndr, NDR_BUFFERS, &r->stores[cntr_stores_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_stores_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_stores_0, 0);
		}
		if (r->stores) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->stores, r->num_stores));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_Info6(struct ndr_print *ndr, const char *name, const struct dfs_Info6 *r)
{
	uint32_t cntr_stores_1;
	ndr_print_struct(ndr, name, "dfs_Info6");
	ndr->depth++;
	ndr_print_ptr(ndr, "entry_path", r->entry_path);
	ndr->depth++;
	if (r->entry_path) {
		ndr_print_string(ndr, "entry_path", r->entry_path);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "comment", r->comment);
	ndr->depth++;
	if (r->comment) {
		ndr_print_string(ndr, "comment", r->comment);
	}
	ndr->depth--;
	ndr_print_dfs_VolumeState(ndr, "state", r->state);
	ndr_print_uint32(ndr, "timeout", r->timeout);
	ndr_print_GUID(ndr, "guid", &r->guid);
	ndr_print_dfs_PropertyFlags(ndr, "flags", r->flags);
	ndr_print_uint32(ndr, "pktsize", r->pktsize);
	ndr_print_uint16(ndr, "num_stores", r->num_stores);
	ndr_print_ptr(ndr, "stores", r->stores);
	ndr->depth++;
	if (r->stores) {
		ndr->print(ndr, "%s: ARRAY(%d)", "stores", (int)r->num_stores);
		ndr->depth++;
		for (cntr_stores_1=0;cntr_stores_1<r->num_stores;cntr_stores_1++) {
			char *idx_1=NULL;
			if (asprintf(&idx_1, "[%d]", cntr_stores_1) != -1) {
				ndr_print_dfs_StorageInfo2(ndr, "stores", &r->stores[cntr_stores_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_Info7(struct ndr_push *ndr, int ndr_flags, const struct dfs_Info7 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->generation_guid));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_Info7(struct ndr_pull *ndr, int ndr_flags, struct dfs_Info7 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->generation_guid));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_Info7(struct ndr_print *ndr, const char *name, const struct dfs_Info7 *r)
{
	ndr_print_struct(ndr, name, "dfs_Info7");
	ndr->depth++;
	ndr_print_GUID(ndr, "generation_guid", &r->generation_guid);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_Info100(struct ndr_push *ndr, int ndr_flags, const struct dfs_Info100 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->comment));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->comment) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->comment, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->comment, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->comment, ndr_charset_length(r->comment, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_Info100(struct ndr_pull *ndr, int ndr_flags, struct dfs_Info100 *r)
{
	uint32_t _ptr_comment;
	uint32_t size_comment_1 = 0;
	uint32_t length_comment_1 = 0;
	TALLOC_CTX *_mem_save_comment_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_comment));
		if (_ptr_comment) {
			NDR_PULL_ALLOC(ndr, r->comment);
		} else {
			r->comment = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->comment) {
			_mem_save_comment_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->comment, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->comment));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->comment));
			size_comment_1 = ndr_get_array_size(ndr, &r->comment);
			length_comment_1 = ndr_get_array_length(ndr, &r->comment);
			if (length_comment_1 > size_comment_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_comment_1, length_comment_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_comment_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->comment, length_comment_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_comment_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_Info100(struct ndr_print *ndr, const char *name, const struct dfs_Info100 *r)
{
	ndr_print_struct(ndr, name, "dfs_Info100");
	ndr->depth++;
	ndr_print_ptr(ndr, "comment", r->comment);
	ndr->depth++;
	if (r->comment) {
		ndr_print_string(ndr, "comment", r->comment);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_Info101(struct ndr_push *ndr, int ndr_flags, const struct dfs_Info101 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_dfs_StorageState(ndr, NDR_SCALARS, r->state));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_Info101(struct ndr_pull *ndr, int ndr_flags, struct dfs_Info101 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_dfs_StorageState(ndr, NDR_SCALARS, &r->state));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_Info101(struct ndr_print *ndr, const char *name, const struct dfs_Info101 *r)
{
	ndr_print_struct(ndr, name, "dfs_Info101");
	ndr->depth++;
	ndr_print_dfs_StorageState(ndr, "state", r->state);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_Info102(struct ndr_push *ndr, int ndr_flags, const struct dfs_Info102 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->timeout));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_Info102(struct ndr_pull *ndr, int ndr_flags, struct dfs_Info102 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->timeout));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_Info102(struct ndr_print *ndr, const char *name, const struct dfs_Info102 *r)
{
	ndr_print_struct(ndr, name, "dfs_Info102");
	ndr->depth++;
	ndr_print_uint32(ndr, "timeout", r->timeout);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_Info103(struct ndr_push *ndr, int ndr_flags, const struct dfs_Info103 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_dfs_PropertyFlags(ndr, NDR_SCALARS, r->flags));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_Info103(struct ndr_pull *ndr, int ndr_flags, struct dfs_Info103 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_dfs_PropertyFlags(ndr, NDR_SCALARS, &r->flags));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_Info103(struct ndr_print *ndr, const char *name, const struct dfs_Info103 *r)
{
	ndr_print_struct(ndr, name, "dfs_Info103");
	ndr->depth++;
	ndr_print_dfs_PropertyFlags(ndr, "flags", r->flags);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_Info104(struct ndr_push *ndr, int ndr_flags, const struct dfs_Info104 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_dfs_Target_Priority(ndr, NDR_SCALARS, &r->priority));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_Info104(struct ndr_pull *ndr, int ndr_flags, struct dfs_Info104 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_dfs_Target_Priority(ndr, NDR_SCALARS, &r->priority));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_Info104(struct ndr_print *ndr, const char *name, const struct dfs_Info104 *r)
{
	ndr_print_struct(ndr, name, "dfs_Info104");
	ndr->depth++;
	ndr_print_dfs_Target_Priority(ndr, "priority", &r->priority);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_Info105(struct ndr_push *ndr, int ndr_flags, const struct dfs_Info105 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->comment));
		NDR_CHECK(ndr_push_dfs_VolumeState(ndr, NDR_SCALARS, r->state));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->timeout));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->property_flag_mask));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->property_flags));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->comment) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->comment, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->comment, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->comment, ndr_charset_length(r->comment, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_Info105(struct ndr_pull *ndr, int ndr_flags, struct dfs_Info105 *r)
{
	uint32_t _ptr_comment;
	uint32_t size_comment_1 = 0;
	uint32_t length_comment_1 = 0;
	TALLOC_CTX *_mem_save_comment_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_comment));
		if (_ptr_comment) {
			NDR_PULL_ALLOC(ndr, r->comment);
		} else {
			r->comment = NULL;
		}
		NDR_CHECK(ndr_pull_dfs_VolumeState(ndr, NDR_SCALARS, &r->state));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->timeout));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->property_flag_mask));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->property_flags));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->comment) {
			_mem_save_comment_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->comment, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->comment));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->comment));
			size_comment_1 = ndr_get_array_size(ndr, &r->comment);
			length_comment_1 = ndr_get_array_length(ndr, &r->comment);
			if (length_comment_1 > size_comment_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_comment_1, length_comment_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_comment_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->comment, length_comment_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_comment_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_Info105(struct ndr_print *ndr, const char *name, const struct dfs_Info105 *r)
{
	ndr_print_struct(ndr, name, "dfs_Info105");
	ndr->depth++;
	ndr_print_ptr(ndr, "comment", r->comment);
	ndr->depth++;
	if (r->comment) {
		ndr_print_string(ndr, "comment", r->comment);
	}
	ndr->depth--;
	ndr_print_dfs_VolumeState(ndr, "state", r->state);
	ndr_print_uint32(ndr, "timeout", r->timeout);
	ndr_print_uint32(ndr, "property_flag_mask", r->property_flag_mask);
	ndr_print_uint32(ndr, "property_flags", r->property_flags);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_Info106(struct ndr_push *ndr, int ndr_flags, const struct dfs_Info106 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_dfs_StorageState(ndr, NDR_SCALARS, r->state));
		NDR_CHECK(ndr_push_dfs_Target_Priority(ndr, NDR_SCALARS, &r->priority));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_Info106(struct ndr_pull *ndr, int ndr_flags, struct dfs_Info106 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_dfs_StorageState(ndr, NDR_SCALARS, &r->state));
		NDR_CHECK(ndr_pull_dfs_Target_Priority(ndr, NDR_SCALARS, &r->priority));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_Info106(struct ndr_print *ndr, const char *name, const struct dfs_Info106 *r)
{
	ndr_print_struct(ndr, name, "dfs_Info106");
	ndr->depth++;
	ndr_print_dfs_StorageState(ndr, "state", r->state);
	ndr_print_dfs_Target_Priority(ndr, "priority", &r->priority);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_Info200(struct ndr_push *ndr, int ndr_flags, const struct dfs_Info200 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->dom_root));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->dom_root) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->dom_root, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->dom_root, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->dom_root, ndr_charset_length(r->dom_root, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_Info200(struct ndr_pull *ndr, int ndr_flags, struct dfs_Info200 *r)
{
	uint32_t _ptr_dom_root;
	uint32_t size_dom_root_1 = 0;
	uint32_t length_dom_root_1 = 0;
	TALLOC_CTX *_mem_save_dom_root_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dom_root));
		if (_ptr_dom_root) {
			NDR_PULL_ALLOC(ndr, r->dom_root);
		} else {
			r->dom_root = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->dom_root) {
			_mem_save_dom_root_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->dom_root, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->dom_root));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->dom_root));
			size_dom_root_1 = ndr_get_array_size(ndr, &r->dom_root);
			length_dom_root_1 = ndr_get_array_length(ndr, &r->dom_root);
			if (length_dom_root_1 > size_dom_root_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_dom_root_1, length_dom_root_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_dom_root_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->dom_root, length_dom_root_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dom_root_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_Info200(struct ndr_print *ndr, const char *name, const struct dfs_Info200 *r)
{
	ndr_print_struct(ndr, name, "dfs_Info200");
	ndr->depth++;
	ndr_print_ptr(ndr, "dom_root", r->dom_root);
	ndr->depth++;
	if (r->dom_root) {
		ndr_print_string(ndr, "dom_root", r->dom_root);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_VolumeFlavor(struct ndr_push *ndr, int ndr_flags, enum dfs_VolumeFlavor r)
{
	NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_VolumeFlavor(struct ndr_pull *ndr, int ndr_flags, enum dfs_VolumeFlavor *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_VolumeFlavor(struct ndr_print *ndr, const char *name, enum dfs_VolumeFlavor r)
{
	const char *val = NULL;

	switch (r) {
		case DFS_VOLUME_FLAVOR_STANDALONE: val = "DFS_VOLUME_FLAVOR_STANDALONE"; break;
		case DFS_VOLUME_FLAVOR_AD_BLOB: val = "DFS_VOLUME_FLAVOR_AD_BLOB"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_dfs_Info300(struct ndr_push *ndr, int ndr_flags, const struct dfs_Info300 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_dfs_VolumeFlavor(ndr, NDR_SCALARS, r->flavor));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->dom_root));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->dom_root) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->dom_root, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->dom_root, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->dom_root, ndr_charset_length(r->dom_root, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_Info300(struct ndr_pull *ndr, int ndr_flags, struct dfs_Info300 *r)
{
	uint32_t _ptr_dom_root;
	uint32_t size_dom_root_1 = 0;
	uint32_t length_dom_root_1 = 0;
	TALLOC_CTX *_mem_save_dom_root_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_dfs_VolumeFlavor(ndr, NDR_SCALARS, &r->flavor));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dom_root));
		if (_ptr_dom_root) {
			NDR_PULL_ALLOC(ndr, r->dom_root);
		} else {
			r->dom_root = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->dom_root) {
			_mem_save_dom_root_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->dom_root, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->dom_root));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->dom_root));
			size_dom_root_1 = ndr_get_array_size(ndr, &r->dom_root);
			length_dom_root_1 = ndr_get_array_length(ndr, &r->dom_root);
			if (length_dom_root_1 > size_dom_root_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_dom_root_1, length_dom_root_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_dom_root_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->dom_root, length_dom_root_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dom_root_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_Info300(struct ndr_print *ndr, const char *name, const struct dfs_Info300 *r)
{
	ndr_print_struct(ndr, name, "dfs_Info300");
	ndr->depth++;
	ndr_print_dfs_VolumeFlavor(ndr, "flavor", r->flavor);
	ndr_print_ptr(ndr, "dom_root", r->dom_root);
	ndr->depth++;
	if (r->dom_root) {
		ndr_print_string(ndr, "dom_root", r->dom_root);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_Info(struct ndr_push *ndr, int ndr_flags, const union dfs_Info *r)
{
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info0));
			break; }

			case 1: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1));
			break; }

			case 2: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info2));
			break; }

			case 3: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info3));
			break; }

			case 4: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info4));
			break; }

			case 5: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info5));
			break; }

			case 6: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info6));
			break; }

			case 7: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info7));
			break; }

			case 100: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info100));
			break; }

			case 101: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info101));
			break; }

			case 102: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info102));
			break; }

			case 103: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info103));
			break; }

			case 104: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info104));
			break; }

			case 105: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info105));
			break; }

			case 106: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info106));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 0:
				if (r->info0) {
					NDR_CHECK(ndr_push_dfs_Info0(ndr, NDR_SCALARS, r->info0));
				}
			break;

			case 1:
				if (r->info1) {
					NDR_CHECK(ndr_push_dfs_Info1(ndr, NDR_SCALARS|NDR_BUFFERS, r->info1));
				}
			break;

			case 2:
				if (r->info2) {
					NDR_CHECK(ndr_push_dfs_Info2(ndr, NDR_SCALARS|NDR_BUFFERS, r->info2));
				}
			break;

			case 3:
				if (r->info3) {
					NDR_CHECK(ndr_push_dfs_Info3(ndr, NDR_SCALARS|NDR_BUFFERS, r->info3));
				}
			break;

			case 4:
				if (r->info4) {
					NDR_CHECK(ndr_push_dfs_Info4(ndr, NDR_SCALARS|NDR_BUFFERS, r->info4));
				}
			break;

			case 5:
				if (r->info5) {
					NDR_CHECK(ndr_push_dfs_Info5(ndr, NDR_SCALARS|NDR_BUFFERS, r->info5));
				}
			break;

			case 6:
				if (r->info6) {
					NDR_CHECK(ndr_push_dfs_Info6(ndr, NDR_SCALARS|NDR_BUFFERS, r->info6));
				}
			break;

			case 7:
				if (r->info7) {
					NDR_CHECK(ndr_push_dfs_Info7(ndr, NDR_SCALARS, r->info7));
				}
			break;

			case 100:
				if (r->info100) {
					NDR_CHECK(ndr_push_dfs_Info100(ndr, NDR_SCALARS|NDR_BUFFERS, r->info100));
				}
			break;

			case 101:
				if (r->info101) {
					NDR_CHECK(ndr_push_dfs_Info101(ndr, NDR_SCALARS, r->info101));
				}
			break;

			case 102:
				if (r->info102) {
					NDR_CHECK(ndr_push_dfs_Info102(ndr, NDR_SCALARS, r->info102));
				}
			break;

			case 103:
				if (r->info103) {
					NDR_CHECK(ndr_push_dfs_Info103(ndr, NDR_SCALARS, r->info103));
				}
			break;

			case 104:
				if (r->info104) {
					NDR_CHECK(ndr_push_dfs_Info104(ndr, NDR_SCALARS, r->info104));
				}
			break;

			case 105:
				if (r->info105) {
					NDR_CHECK(ndr_push_dfs_Info105(ndr, NDR_SCALARS|NDR_BUFFERS, r->info105));
				}
			break;

			case 106:
				if (r->info106) {
					NDR_CHECK(ndr_push_dfs_Info106(ndr, NDR_SCALARS, r->info106));
				}
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_Info(struct ndr_pull *ndr, int ndr_flags, union dfs_Info *r)
{
	int level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_info0_0;
	uint32_t _ptr_info0;
	TALLOC_CTX *_mem_save_info1_0;
	uint32_t _ptr_info1;
	TALLOC_CTX *_mem_save_info2_0;
	uint32_t _ptr_info2;
	TALLOC_CTX *_mem_save_info3_0;
	uint32_t _ptr_info3;
	TALLOC_CTX *_mem_save_info4_0;
	uint32_t _ptr_info4;
	TALLOC_CTX *_mem_save_info5_0;
	uint32_t _ptr_info5;
	TALLOC_CTX *_mem_save_info6_0;
	uint32_t _ptr_info6;
	TALLOC_CTX *_mem_save_info7_0;
	uint32_t _ptr_info7;
	TALLOC_CTX *_mem_save_info100_0;
	uint32_t _ptr_info100;
	TALLOC_CTX *_mem_save_info101_0;
	uint32_t _ptr_info101;
	TALLOC_CTX *_mem_save_info102_0;
	uint32_t _ptr_info102;
	TALLOC_CTX *_mem_save_info103_0;
	uint32_t _ptr_info103;
	TALLOC_CTX *_mem_save_info104_0;
	uint32_t _ptr_info104;
	TALLOC_CTX *_mem_save_info105_0;
	uint32_t _ptr_info105;
	TALLOC_CTX *_mem_save_info106_0;
	uint32_t _ptr_info106;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r", _level);
		}
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info0));
				if (_ptr_info0) {
					NDR_PULL_ALLOC(ndr, r->info0);
				} else {
					r->info0 = NULL;
				}
			break; }

			case 1: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1));
				if (_ptr_info1) {
					NDR_PULL_ALLOC(ndr, r->info1);
				} else {
					r->info1 = NULL;
				}
			break; }

			case 2: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info2));
				if (_ptr_info2) {
					NDR_PULL_ALLOC(ndr, r->info2);
				} else {
					r->info2 = NULL;
				}
			break; }

			case 3: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info3));
				if (_ptr_info3) {
					NDR_PULL_ALLOC(ndr, r->info3);
				} else {
					r->info3 = NULL;
				}
			break; }

			case 4: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info4));
				if (_ptr_info4) {
					NDR_PULL_ALLOC(ndr, r->info4);
				} else {
					r->info4 = NULL;
				}
			break; }

			case 5: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info5));
				if (_ptr_info5) {
					NDR_PULL_ALLOC(ndr, r->info5);
				} else {
					r->info5 = NULL;
				}
			break; }

			case 6: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info6));
				if (_ptr_info6) {
					NDR_PULL_ALLOC(ndr, r->info6);
				} else {
					r->info6 = NULL;
				}
			break; }

			case 7: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info7));
				if (_ptr_info7) {
					NDR_PULL_ALLOC(ndr, r->info7);
				} else {
					r->info7 = NULL;
				}
			break; }

			case 100: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info100));
				if (_ptr_info100) {
					NDR_PULL_ALLOC(ndr, r->info100);
				} else {
					r->info100 = NULL;
				}
			break; }

			case 101: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info101));
				if (_ptr_info101) {
					NDR_PULL_ALLOC(ndr, r->info101);
				} else {
					r->info101 = NULL;
				}
			break; }

			case 102: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info102));
				if (_ptr_info102) {
					NDR_PULL_ALLOC(ndr, r->info102);
				} else {
					r->info102 = NULL;
				}
			break; }

			case 103: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info103));
				if (_ptr_info103) {
					NDR_PULL_ALLOC(ndr, r->info103);
				} else {
					r->info103 = NULL;
				}
			break; }

			case 104: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info104));
				if (_ptr_info104) {
					NDR_PULL_ALLOC(ndr, r->info104);
				} else {
					r->info104 = NULL;
				}
			break; }

			case 105: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info105));
				if (_ptr_info105) {
					NDR_PULL_ALLOC(ndr, r->info105);
				} else {
					r->info105 = NULL;
				}
			break; }

			case 106: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info106));
				if (_ptr_info106) {
					NDR_PULL_ALLOC(ndr, r->info106);
				} else {
					r->info106 = NULL;
				}
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 0:
				if (r->info0) {
					_mem_save_info0_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info0, 0);
					NDR_CHECK(ndr_pull_dfs_Info0(ndr, NDR_SCALARS, r->info0));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info0_0, 0);
				}
			break;

			case 1:
				if (r->info1) {
					_mem_save_info1_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1, 0);
					NDR_CHECK(ndr_pull_dfs_Info1(ndr, NDR_SCALARS|NDR_BUFFERS, r->info1));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1_0, 0);
				}
			break;

			case 2:
				if (r->info2) {
					_mem_save_info2_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info2, 0);
					NDR_CHECK(ndr_pull_dfs_Info2(ndr, NDR_SCALARS|NDR_BUFFERS, r->info2));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info2_0, 0);
				}
			break;

			case 3:
				if (r->info3) {
					_mem_save_info3_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info3, 0);
					NDR_CHECK(ndr_pull_dfs_Info3(ndr, NDR_SCALARS|NDR_BUFFERS, r->info3));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info3_0, 0);
				}
			break;

			case 4:
				if (r->info4) {
					_mem_save_info4_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info4, 0);
					NDR_CHECK(ndr_pull_dfs_Info4(ndr, NDR_SCALARS|NDR_BUFFERS, r->info4));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info4_0, 0);
				}
			break;

			case 5:
				if (r->info5) {
					_mem_save_info5_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info5, 0);
					NDR_CHECK(ndr_pull_dfs_Info5(ndr, NDR_SCALARS|NDR_BUFFERS, r->info5));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info5_0, 0);
				}
			break;

			case 6:
				if (r->info6) {
					_mem_save_info6_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info6, 0);
					NDR_CHECK(ndr_pull_dfs_Info6(ndr, NDR_SCALARS|NDR_BUFFERS, r->info6));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info6_0, 0);
				}
			break;

			case 7:
				if (r->info7) {
					_mem_save_info7_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info7, 0);
					NDR_CHECK(ndr_pull_dfs_Info7(ndr, NDR_SCALARS, r->info7));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info7_0, 0);
				}
			break;

			case 100:
				if (r->info100) {
					_mem_save_info100_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info100, 0);
					NDR_CHECK(ndr_pull_dfs_Info100(ndr, NDR_SCALARS|NDR_BUFFERS, r->info100));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info100_0, 0);
				}
			break;

			case 101:
				if (r->info101) {
					_mem_save_info101_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info101, 0);
					NDR_CHECK(ndr_pull_dfs_Info101(ndr, NDR_SCALARS, r->info101));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info101_0, 0);
				}
			break;

			case 102:
				if (r->info102) {
					_mem_save_info102_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info102, 0);
					NDR_CHECK(ndr_pull_dfs_Info102(ndr, NDR_SCALARS, r->info102));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info102_0, 0);
				}
			break;

			case 103:
				if (r->info103) {
					_mem_save_info103_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info103, 0);
					NDR_CHECK(ndr_pull_dfs_Info103(ndr, NDR_SCALARS, r->info103));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info103_0, 0);
				}
			break;

			case 104:
				if (r->info104) {
					_mem_save_info104_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info104, 0);
					NDR_CHECK(ndr_pull_dfs_Info104(ndr, NDR_SCALARS, r->info104));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info104_0, 0);
				}
			break;

			case 105:
				if (r->info105) {
					_mem_save_info105_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info105, 0);
					NDR_CHECK(ndr_pull_dfs_Info105(ndr, NDR_SCALARS|NDR_BUFFERS, r->info105));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info105_0, 0);
				}
			break;

			case 106:
				if (r->info106) {
					_mem_save_info106_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info106, 0);
					NDR_CHECK(ndr_pull_dfs_Info106(ndr, NDR_SCALARS, r->info106));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info106_0, 0);
				}
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_Info(struct ndr_print *ndr, const char *name, const union dfs_Info *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "dfs_Info");
	switch (level) {
		case 0:
			ndr_print_ptr(ndr, "info0", r->info0);
			ndr->depth++;
			if (r->info0) {
				ndr_print_dfs_Info0(ndr, "info0", r->info0);
			}
			ndr->depth--;
		break;

		case 1:
			ndr_print_ptr(ndr, "info1", r->info1);
			ndr->depth++;
			if (r->info1) {
				ndr_print_dfs_Info1(ndr, "info1", r->info1);
			}
			ndr->depth--;
		break;

		case 2:
			ndr_print_ptr(ndr, "info2", r->info2);
			ndr->depth++;
			if (r->info2) {
				ndr_print_dfs_Info2(ndr, "info2", r->info2);
			}
			ndr->depth--;
		break;

		case 3:
			ndr_print_ptr(ndr, "info3", r->info3);
			ndr->depth++;
			if (r->info3) {
				ndr_print_dfs_Info3(ndr, "info3", r->info3);
			}
			ndr->depth--;
		break;

		case 4:
			ndr_print_ptr(ndr, "info4", r->info4);
			ndr->depth++;
			if (r->info4) {
				ndr_print_dfs_Info4(ndr, "info4", r->info4);
			}
			ndr->depth--;
		break;

		case 5:
			ndr_print_ptr(ndr, "info5", r->info5);
			ndr->depth++;
			if (r->info5) {
				ndr_print_dfs_Info5(ndr, "info5", r->info5);
			}
			ndr->depth--;
		break;

		case 6:
			ndr_print_ptr(ndr, "info6", r->info6);
			ndr->depth++;
			if (r->info6) {
				ndr_print_dfs_Info6(ndr, "info6", r->info6);
			}
			ndr->depth--;
		break;

		case 7:
			ndr_print_ptr(ndr, "info7", r->info7);
			ndr->depth++;
			if (r->info7) {
				ndr_print_dfs_Info7(ndr, "info7", r->info7);
			}
			ndr->depth--;
		break;

		case 100:
			ndr_print_ptr(ndr, "info100", r->info100);
			ndr->depth++;
			if (r->info100) {
				ndr_print_dfs_Info100(ndr, "info100", r->info100);
			}
			ndr->depth--;
		break;

		case 101:
			ndr_print_ptr(ndr, "info101", r->info101);
			ndr->depth++;
			if (r->info101) {
				ndr_print_dfs_Info101(ndr, "info101", r->info101);
			}
			ndr->depth--;
		break;

		case 102:
			ndr_print_ptr(ndr, "info102", r->info102);
			ndr->depth++;
			if (r->info102) {
				ndr_print_dfs_Info102(ndr, "info102", r->info102);
			}
			ndr->depth--;
		break;

		case 103:
			ndr_print_ptr(ndr, "info103", r->info103);
			ndr->depth++;
			if (r->info103) {
				ndr_print_dfs_Info103(ndr, "info103", r->info103);
			}
			ndr->depth--;
		break;

		case 104:
			ndr_print_ptr(ndr, "info104", r->info104);
			ndr->depth++;
			if (r->info104) {
				ndr_print_dfs_Info104(ndr, "info104", r->info104);
			}
			ndr->depth--;
		break;

		case 105:
			ndr_print_ptr(ndr, "info105", r->info105);
			ndr->depth++;
			if (r->info105) {
				ndr_print_dfs_Info105(ndr, "info105", r->info105);
			}
			ndr->depth--;
		break;

		case 106:
			ndr_print_ptr(ndr, "info106", r->info106);
			ndr->depth++;
			if (r->info106) {
				ndr_print_dfs_Info106(ndr, "info106", r->info106);
			}
			ndr->depth--;
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_dfs_EnumArray1(struct ndr_push *ndr, int ndr_flags, const struct dfs_EnumArray1 *r)
{
	uint32_t cntr_s_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->s));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->s) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
			for (cntr_s_1 = 0; cntr_s_1 < r->count; cntr_s_1++) {
				NDR_CHECK(ndr_push_dfs_Info1(ndr, NDR_SCALARS, &r->s[cntr_s_1]));
			}
			for (cntr_s_1 = 0; cntr_s_1 < r->count; cntr_s_1++) {
				NDR_CHECK(ndr_push_dfs_Info1(ndr, NDR_BUFFERS, &r->s[cntr_s_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_EnumArray1(struct ndr_pull *ndr, int ndr_flags, struct dfs_EnumArray1 *r)
{
	uint32_t _ptr_s;
	uint32_t size_s_1 = 0;
	uint32_t cntr_s_1;
	TALLOC_CTX *_mem_save_s_0;
	TALLOC_CTX *_mem_save_s_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_s));
		if (_ptr_s) {
			NDR_PULL_ALLOC(ndr, r->s);
		} else {
			r->s = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->s) {
			_mem_save_s_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->s, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->s));
			size_s_1 = ndr_get_array_size(ndr, &r->s);
			NDR_PULL_ALLOC_N(ndr, r->s, size_s_1);
			_mem_save_s_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->s, 0);
			for (cntr_s_1 = 0; cntr_s_1 < size_s_1; cntr_s_1++) {
				NDR_CHECK(ndr_pull_dfs_Info1(ndr, NDR_SCALARS, &r->s[cntr_s_1]));
			}
			for (cntr_s_1 = 0; cntr_s_1 < size_s_1; cntr_s_1++) {
				NDR_CHECK(ndr_pull_dfs_Info1(ndr, NDR_BUFFERS, &r->s[cntr_s_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_s_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_s_0, 0);
		}
		if (r->s) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->s, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_EnumArray1(struct ndr_print *ndr, const char *name, const struct dfs_EnumArray1 *r)
{
	uint32_t cntr_s_1;
	ndr_print_struct(ndr, name, "dfs_EnumArray1");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "s", r->s);
	ndr->depth++;
	if (r->s) {
		ndr->print(ndr, "%s: ARRAY(%d)", "s", (int)r->count);
		ndr->depth++;
		for (cntr_s_1=0;cntr_s_1<r->count;cntr_s_1++) {
			char *idx_1=NULL;
			if (asprintf(&idx_1, "[%d]", cntr_s_1) != -1) {
				ndr_print_dfs_Info1(ndr, "s", &r->s[cntr_s_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_EnumArray2(struct ndr_push *ndr, int ndr_flags, const struct dfs_EnumArray2 *r)
{
	uint32_t cntr_s_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->s));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->s) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
			for (cntr_s_1 = 0; cntr_s_1 < r->count; cntr_s_1++) {
				NDR_CHECK(ndr_push_dfs_Info2(ndr, NDR_SCALARS, &r->s[cntr_s_1]));
			}
			for (cntr_s_1 = 0; cntr_s_1 < r->count; cntr_s_1++) {
				NDR_CHECK(ndr_push_dfs_Info2(ndr, NDR_BUFFERS, &r->s[cntr_s_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_EnumArray2(struct ndr_pull *ndr, int ndr_flags, struct dfs_EnumArray2 *r)
{
	uint32_t _ptr_s;
	uint32_t size_s_1 = 0;
	uint32_t cntr_s_1;
	TALLOC_CTX *_mem_save_s_0;
	TALLOC_CTX *_mem_save_s_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_s));
		if (_ptr_s) {
			NDR_PULL_ALLOC(ndr, r->s);
		} else {
			r->s = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->s) {
			_mem_save_s_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->s, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->s));
			size_s_1 = ndr_get_array_size(ndr, &r->s);
			NDR_PULL_ALLOC_N(ndr, r->s, size_s_1);
			_mem_save_s_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->s, 0);
			for (cntr_s_1 = 0; cntr_s_1 < size_s_1; cntr_s_1++) {
				NDR_CHECK(ndr_pull_dfs_Info2(ndr, NDR_SCALARS, &r->s[cntr_s_1]));
			}
			for (cntr_s_1 = 0; cntr_s_1 < size_s_1; cntr_s_1++) {
				NDR_CHECK(ndr_pull_dfs_Info2(ndr, NDR_BUFFERS, &r->s[cntr_s_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_s_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_s_0, 0);
		}
		if (r->s) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->s, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_EnumArray2(struct ndr_print *ndr, const char *name, const struct dfs_EnumArray2 *r)
{
	uint32_t cntr_s_1;
	ndr_print_struct(ndr, name, "dfs_EnumArray2");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "s", r->s);
	ndr->depth++;
	if (r->s) {
		ndr->print(ndr, "%s: ARRAY(%d)", "s", (int)r->count);
		ndr->depth++;
		for (cntr_s_1=0;cntr_s_1<r->count;cntr_s_1++) {
			char *idx_1=NULL;
			if (asprintf(&idx_1, "[%d]", cntr_s_1) != -1) {
				ndr_print_dfs_Info2(ndr, "s", &r->s[cntr_s_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_EnumArray3(struct ndr_push *ndr, int ndr_flags, const struct dfs_EnumArray3 *r)
{
	uint32_t cntr_s_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->s));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->s) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
			for (cntr_s_1 = 0; cntr_s_1 < r->count; cntr_s_1++) {
				NDR_CHECK(ndr_push_dfs_Info3(ndr, NDR_SCALARS, &r->s[cntr_s_1]));
			}
			for (cntr_s_1 = 0; cntr_s_1 < r->count; cntr_s_1++) {
				NDR_CHECK(ndr_push_dfs_Info3(ndr, NDR_BUFFERS, &r->s[cntr_s_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_EnumArray3(struct ndr_pull *ndr, int ndr_flags, struct dfs_EnumArray3 *r)
{
	uint32_t _ptr_s;
	uint32_t size_s_1 = 0;
	uint32_t cntr_s_1;
	TALLOC_CTX *_mem_save_s_0;
	TALLOC_CTX *_mem_save_s_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_s));
		if (_ptr_s) {
			NDR_PULL_ALLOC(ndr, r->s);
		} else {
			r->s = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->s) {
			_mem_save_s_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->s, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->s));
			size_s_1 = ndr_get_array_size(ndr, &r->s);
			NDR_PULL_ALLOC_N(ndr, r->s, size_s_1);
			_mem_save_s_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->s, 0);
			for (cntr_s_1 = 0; cntr_s_1 < size_s_1; cntr_s_1++) {
				NDR_CHECK(ndr_pull_dfs_Info3(ndr, NDR_SCALARS, &r->s[cntr_s_1]));
			}
			for (cntr_s_1 = 0; cntr_s_1 < size_s_1; cntr_s_1++) {
				NDR_CHECK(ndr_pull_dfs_Info3(ndr, NDR_BUFFERS, &r->s[cntr_s_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_s_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_s_0, 0);
		}
		if (r->s) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->s, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_EnumArray3(struct ndr_print *ndr, const char *name, const struct dfs_EnumArray3 *r)
{
	uint32_t cntr_s_1;
	ndr_print_struct(ndr, name, "dfs_EnumArray3");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "s", r->s);
	ndr->depth++;
	if (r->s) {
		ndr->print(ndr, "%s: ARRAY(%d)", "s", (int)r->count);
		ndr->depth++;
		for (cntr_s_1=0;cntr_s_1<r->count;cntr_s_1++) {
			char *idx_1=NULL;
			if (asprintf(&idx_1, "[%d]", cntr_s_1) != -1) {
				ndr_print_dfs_Info3(ndr, "s", &r->s[cntr_s_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_EnumArray4(struct ndr_push *ndr, int ndr_flags, const struct dfs_EnumArray4 *r)
{
	uint32_t cntr_s_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->s));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->s) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
			for (cntr_s_1 = 0; cntr_s_1 < r->count; cntr_s_1++) {
				NDR_CHECK(ndr_push_dfs_Info4(ndr, NDR_SCALARS, &r->s[cntr_s_1]));
			}
			for (cntr_s_1 = 0; cntr_s_1 < r->count; cntr_s_1++) {
				NDR_CHECK(ndr_push_dfs_Info4(ndr, NDR_BUFFERS, &r->s[cntr_s_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_EnumArray4(struct ndr_pull *ndr, int ndr_flags, struct dfs_EnumArray4 *r)
{
	uint32_t _ptr_s;
	uint32_t size_s_1 = 0;
	uint32_t cntr_s_1;
	TALLOC_CTX *_mem_save_s_0;
	TALLOC_CTX *_mem_save_s_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_s));
		if (_ptr_s) {
			NDR_PULL_ALLOC(ndr, r->s);
		} else {
			r->s = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->s) {
			_mem_save_s_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->s, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->s));
			size_s_1 = ndr_get_array_size(ndr, &r->s);
			NDR_PULL_ALLOC_N(ndr, r->s, size_s_1);
			_mem_save_s_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->s, 0);
			for (cntr_s_1 = 0; cntr_s_1 < size_s_1; cntr_s_1++) {
				NDR_CHECK(ndr_pull_dfs_Info4(ndr, NDR_SCALARS, &r->s[cntr_s_1]));
			}
			for (cntr_s_1 = 0; cntr_s_1 < size_s_1; cntr_s_1++) {
				NDR_CHECK(ndr_pull_dfs_Info4(ndr, NDR_BUFFERS, &r->s[cntr_s_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_s_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_s_0, 0);
		}
		if (r->s) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->s, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_EnumArray4(struct ndr_print *ndr, const char *name, const struct dfs_EnumArray4 *r)
{
	uint32_t cntr_s_1;
	ndr_print_struct(ndr, name, "dfs_EnumArray4");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "s", r->s);
	ndr->depth++;
	if (r->s) {
		ndr->print(ndr, "%s: ARRAY(%d)", "s", (int)r->count);
		ndr->depth++;
		for (cntr_s_1=0;cntr_s_1<r->count;cntr_s_1++) {
			char *idx_1=NULL;
			if (asprintf(&idx_1, "[%d]", cntr_s_1) != -1) {
				ndr_print_dfs_Info4(ndr, "s", &r->s[cntr_s_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_EnumArray5(struct ndr_push *ndr, int ndr_flags, const struct dfs_EnumArray5 *r)
{
	uint32_t cntr_s_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->s));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->s) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
			for (cntr_s_1 = 0; cntr_s_1 < r->count; cntr_s_1++) {
				NDR_CHECK(ndr_push_dfs_Info5(ndr, NDR_SCALARS, &r->s[cntr_s_1]));
			}
			for (cntr_s_1 = 0; cntr_s_1 < r->count; cntr_s_1++) {
				NDR_CHECK(ndr_push_dfs_Info5(ndr, NDR_BUFFERS, &r->s[cntr_s_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_EnumArray5(struct ndr_pull *ndr, int ndr_flags, struct dfs_EnumArray5 *r)
{
	uint32_t _ptr_s;
	uint32_t size_s_1 = 0;
	uint32_t cntr_s_1;
	TALLOC_CTX *_mem_save_s_0;
	TALLOC_CTX *_mem_save_s_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_s));
		if (_ptr_s) {
			NDR_PULL_ALLOC(ndr, r->s);
		} else {
			r->s = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->s) {
			_mem_save_s_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->s, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->s));
			size_s_1 = ndr_get_array_size(ndr, &r->s);
			NDR_PULL_ALLOC_N(ndr, r->s, size_s_1);
			_mem_save_s_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->s, 0);
			for (cntr_s_1 = 0; cntr_s_1 < size_s_1; cntr_s_1++) {
				NDR_CHECK(ndr_pull_dfs_Info5(ndr, NDR_SCALARS, &r->s[cntr_s_1]));
			}
			for (cntr_s_1 = 0; cntr_s_1 < size_s_1; cntr_s_1++) {
				NDR_CHECK(ndr_pull_dfs_Info5(ndr, NDR_BUFFERS, &r->s[cntr_s_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_s_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_s_0, 0);
		}
		if (r->s) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->s, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_EnumArray5(struct ndr_print *ndr, const char *name, const struct dfs_EnumArray5 *r)
{
	uint32_t cntr_s_1;
	ndr_print_struct(ndr, name, "dfs_EnumArray5");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "s", r->s);
	ndr->depth++;
	if (r->s) {
		ndr->print(ndr, "%s: ARRAY(%d)", "s", (int)r->count);
		ndr->depth++;
		for (cntr_s_1=0;cntr_s_1<r->count;cntr_s_1++) {
			char *idx_1=NULL;
			if (asprintf(&idx_1, "[%d]", cntr_s_1) != -1) {
				ndr_print_dfs_Info5(ndr, "s", &r->s[cntr_s_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_EnumArray6(struct ndr_push *ndr, int ndr_flags, const struct dfs_EnumArray6 *r)
{
	uint32_t cntr_s_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->s));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->s) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
			for (cntr_s_1 = 0; cntr_s_1 < r->count; cntr_s_1++) {
				NDR_CHECK(ndr_push_dfs_Info6(ndr, NDR_SCALARS, &r->s[cntr_s_1]));
			}
			for (cntr_s_1 = 0; cntr_s_1 < r->count; cntr_s_1++) {
				NDR_CHECK(ndr_push_dfs_Info6(ndr, NDR_BUFFERS, &r->s[cntr_s_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_EnumArray6(struct ndr_pull *ndr, int ndr_flags, struct dfs_EnumArray6 *r)
{
	uint32_t _ptr_s;
	uint32_t size_s_1 = 0;
	uint32_t cntr_s_1;
	TALLOC_CTX *_mem_save_s_0;
	TALLOC_CTX *_mem_save_s_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_s));
		if (_ptr_s) {
			NDR_PULL_ALLOC(ndr, r->s);
		} else {
			r->s = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->s) {
			_mem_save_s_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->s, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->s));
			size_s_1 = ndr_get_array_size(ndr, &r->s);
			NDR_PULL_ALLOC_N(ndr, r->s, size_s_1);
			_mem_save_s_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->s, 0);
			for (cntr_s_1 = 0; cntr_s_1 < size_s_1; cntr_s_1++) {
				NDR_CHECK(ndr_pull_dfs_Info6(ndr, NDR_SCALARS, &r->s[cntr_s_1]));
			}
			for (cntr_s_1 = 0; cntr_s_1 < size_s_1; cntr_s_1++) {
				NDR_CHECK(ndr_pull_dfs_Info6(ndr, NDR_BUFFERS, &r->s[cntr_s_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_s_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_s_0, 0);
		}
		if (r->s) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->s, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_EnumArray6(struct ndr_print *ndr, const char *name, const struct dfs_EnumArray6 *r)
{
	uint32_t cntr_s_1;
	ndr_print_struct(ndr, name, "dfs_EnumArray6");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "s", r->s);
	ndr->depth++;
	if (r->s) {
		ndr->print(ndr, "%s: ARRAY(%d)", "s", (int)r->count);
		ndr->depth++;
		for (cntr_s_1=0;cntr_s_1<r->count;cntr_s_1++) {
			char *idx_1=NULL;
			if (asprintf(&idx_1, "[%d]", cntr_s_1) != -1) {
				ndr_print_dfs_Info6(ndr, "s", &r->s[cntr_s_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_EnumArray200(struct ndr_push *ndr, int ndr_flags, const struct dfs_EnumArray200 *r)
{
	uint32_t cntr_s_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->s));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->s) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
			for (cntr_s_1 = 0; cntr_s_1 < r->count; cntr_s_1++) {
				NDR_CHECK(ndr_push_dfs_Info200(ndr, NDR_SCALARS, &r->s[cntr_s_1]));
			}
			for (cntr_s_1 = 0; cntr_s_1 < r->count; cntr_s_1++) {
				NDR_CHECK(ndr_push_dfs_Info200(ndr, NDR_BUFFERS, &r->s[cntr_s_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_EnumArray200(struct ndr_pull *ndr, int ndr_flags, struct dfs_EnumArray200 *r)
{
	uint32_t _ptr_s;
	uint32_t size_s_1 = 0;
	uint32_t cntr_s_1;
	TALLOC_CTX *_mem_save_s_0;
	TALLOC_CTX *_mem_save_s_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_s));
		if (_ptr_s) {
			NDR_PULL_ALLOC(ndr, r->s);
		} else {
			r->s = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->s) {
			_mem_save_s_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->s, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->s));
			size_s_1 = ndr_get_array_size(ndr, &r->s);
			NDR_PULL_ALLOC_N(ndr, r->s, size_s_1);
			_mem_save_s_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->s, 0);
			for (cntr_s_1 = 0; cntr_s_1 < size_s_1; cntr_s_1++) {
				NDR_CHECK(ndr_pull_dfs_Info200(ndr, NDR_SCALARS, &r->s[cntr_s_1]));
			}
			for (cntr_s_1 = 0; cntr_s_1 < size_s_1; cntr_s_1++) {
				NDR_CHECK(ndr_pull_dfs_Info200(ndr, NDR_BUFFERS, &r->s[cntr_s_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_s_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_s_0, 0);
		}
		if (r->s) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->s, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_EnumArray200(struct ndr_print *ndr, const char *name, const struct dfs_EnumArray200 *r)
{
	uint32_t cntr_s_1;
	ndr_print_struct(ndr, name, "dfs_EnumArray200");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "s", r->s);
	ndr->depth++;
	if (r->s) {
		ndr->print(ndr, "%s: ARRAY(%d)", "s", (int)r->count);
		ndr->depth++;
		for (cntr_s_1=0;cntr_s_1<r->count;cntr_s_1++) {
			char *idx_1=NULL;
			if (asprintf(&idx_1, "[%d]", cntr_s_1) != -1) {
				ndr_print_dfs_Info200(ndr, "s", &r->s[cntr_s_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_EnumArray300(struct ndr_push *ndr, int ndr_flags, const struct dfs_EnumArray300 *r)
{
	uint32_t cntr_s_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->s));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->s) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
			for (cntr_s_1 = 0; cntr_s_1 < r->count; cntr_s_1++) {
				NDR_CHECK(ndr_push_dfs_Info300(ndr, NDR_SCALARS, &r->s[cntr_s_1]));
			}
			for (cntr_s_1 = 0; cntr_s_1 < r->count; cntr_s_1++) {
				NDR_CHECK(ndr_push_dfs_Info300(ndr, NDR_BUFFERS, &r->s[cntr_s_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_EnumArray300(struct ndr_pull *ndr, int ndr_flags, struct dfs_EnumArray300 *r)
{
	uint32_t _ptr_s;
	uint32_t size_s_1 = 0;
	uint32_t cntr_s_1;
	TALLOC_CTX *_mem_save_s_0;
	TALLOC_CTX *_mem_save_s_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_s));
		if (_ptr_s) {
			NDR_PULL_ALLOC(ndr, r->s);
		} else {
			r->s = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->s) {
			_mem_save_s_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->s, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->s));
			size_s_1 = ndr_get_array_size(ndr, &r->s);
			NDR_PULL_ALLOC_N(ndr, r->s, size_s_1);
			_mem_save_s_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->s, 0);
			for (cntr_s_1 = 0; cntr_s_1 < size_s_1; cntr_s_1++) {
				NDR_CHECK(ndr_pull_dfs_Info300(ndr, NDR_SCALARS, &r->s[cntr_s_1]));
			}
			for (cntr_s_1 = 0; cntr_s_1 < size_s_1; cntr_s_1++) {
				NDR_CHECK(ndr_pull_dfs_Info300(ndr, NDR_BUFFERS, &r->s[cntr_s_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_s_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_s_0, 0);
		}
		if (r->s) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->s, r->count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_EnumArray300(struct ndr_print *ndr, const char *name, const struct dfs_EnumArray300 *r)
{
	uint32_t cntr_s_1;
	ndr_print_struct(ndr, name, "dfs_EnumArray300");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "s", r->s);
	ndr->depth++;
	if (r->s) {
		ndr->print(ndr, "%s: ARRAY(%d)", "s", (int)r->count);
		ndr->depth++;
		for (cntr_s_1=0;cntr_s_1<r->count;cntr_s_1++) {
			char *idx_1=NULL;
			if (asprintf(&idx_1, "[%d]", cntr_s_1) != -1) {
				ndr_print_dfs_Info300(ndr, "s", &r->s[cntr_s_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_EnumInfo(struct ndr_push *ndr, int ndr_flags, const union dfs_EnumInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info1));
			break; }

			case 2: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info2));
			break; }

			case 3: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info3));
			break; }

			case 4: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info4));
			break; }

			case 5: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info5));
			break; }

			case 6: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info6));
			break; }

			case 200: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info200));
			break; }

			case 300: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info300));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 1:
				if (r->info1) {
					NDR_CHECK(ndr_push_dfs_EnumArray1(ndr, NDR_SCALARS|NDR_BUFFERS, r->info1));
				}
			break;

			case 2:
				if (r->info2) {
					NDR_CHECK(ndr_push_dfs_EnumArray2(ndr, NDR_SCALARS|NDR_BUFFERS, r->info2));
				}
			break;

			case 3:
				if (r->info3) {
					NDR_CHECK(ndr_push_dfs_EnumArray3(ndr, NDR_SCALARS|NDR_BUFFERS, r->info3));
				}
			break;

			case 4:
				if (r->info4) {
					NDR_CHECK(ndr_push_dfs_EnumArray4(ndr, NDR_SCALARS|NDR_BUFFERS, r->info4));
				}
			break;

			case 5:
				if (r->info5) {
					NDR_CHECK(ndr_push_dfs_EnumArray5(ndr, NDR_SCALARS|NDR_BUFFERS, r->info5));
				}
			break;

			case 6:
				if (r->info6) {
					NDR_CHECK(ndr_push_dfs_EnumArray6(ndr, NDR_SCALARS|NDR_BUFFERS, r->info6));
				}
			break;

			case 200:
				if (r->info200) {
					NDR_CHECK(ndr_push_dfs_EnumArray200(ndr, NDR_SCALARS|NDR_BUFFERS, r->info200));
				}
			break;

			case 300:
				if (r->info300) {
					NDR_CHECK(ndr_push_dfs_EnumArray300(ndr, NDR_SCALARS|NDR_BUFFERS, r->info300));
				}
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_EnumInfo(struct ndr_pull *ndr, int ndr_flags, union dfs_EnumInfo *r)
{
	int level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_info1_0;
	uint32_t _ptr_info1;
	TALLOC_CTX *_mem_save_info2_0;
	uint32_t _ptr_info2;
	TALLOC_CTX *_mem_save_info3_0;
	uint32_t _ptr_info3;
	TALLOC_CTX *_mem_save_info4_0;
	uint32_t _ptr_info4;
	TALLOC_CTX *_mem_save_info5_0;
	uint32_t _ptr_info5;
	TALLOC_CTX *_mem_save_info6_0;
	uint32_t _ptr_info6;
	TALLOC_CTX *_mem_save_info200_0;
	uint32_t _ptr_info200;
	TALLOC_CTX *_mem_save_info300_0;
	uint32_t _ptr_info300;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r", _level);
		}
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info1));
				if (_ptr_info1) {
					NDR_PULL_ALLOC(ndr, r->info1);
				} else {
					r->info1 = NULL;
				}
			break; }

			case 2: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info2));
				if (_ptr_info2) {
					NDR_PULL_ALLOC(ndr, r->info2);
				} else {
					r->info2 = NULL;
				}
			break; }

			case 3: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info3));
				if (_ptr_info3) {
					NDR_PULL_ALLOC(ndr, r->info3);
				} else {
					r->info3 = NULL;
				}
			break; }

			case 4: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info4));
				if (_ptr_info4) {
					NDR_PULL_ALLOC(ndr, r->info4);
				} else {
					r->info4 = NULL;
				}
			break; }

			case 5: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info5));
				if (_ptr_info5) {
					NDR_PULL_ALLOC(ndr, r->info5);
				} else {
					r->info5 = NULL;
				}
			break; }

			case 6: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info6));
				if (_ptr_info6) {
					NDR_PULL_ALLOC(ndr, r->info6);
				} else {
					r->info6 = NULL;
				}
			break; }

			case 200: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info200));
				if (_ptr_info200) {
					NDR_PULL_ALLOC(ndr, r->info200);
				} else {
					r->info200 = NULL;
				}
			break; }

			case 300: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info300));
				if (_ptr_info300) {
					NDR_PULL_ALLOC(ndr, r->info300);
				} else {
					r->info300 = NULL;
				}
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 1:
				if (r->info1) {
					_mem_save_info1_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info1, 0);
					NDR_CHECK(ndr_pull_dfs_EnumArray1(ndr, NDR_SCALARS|NDR_BUFFERS, r->info1));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info1_0, 0);
				}
			break;

			case 2:
				if (r->info2) {
					_mem_save_info2_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info2, 0);
					NDR_CHECK(ndr_pull_dfs_EnumArray2(ndr, NDR_SCALARS|NDR_BUFFERS, r->info2));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info2_0, 0);
				}
			break;

			case 3:
				if (r->info3) {
					_mem_save_info3_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info3, 0);
					NDR_CHECK(ndr_pull_dfs_EnumArray3(ndr, NDR_SCALARS|NDR_BUFFERS, r->info3));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info3_0, 0);
				}
			break;

			case 4:
				if (r->info4) {
					_mem_save_info4_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info4, 0);
					NDR_CHECK(ndr_pull_dfs_EnumArray4(ndr, NDR_SCALARS|NDR_BUFFERS, r->info4));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info4_0, 0);
				}
			break;

			case 5:
				if (r->info5) {
					_mem_save_info5_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info5, 0);
					NDR_CHECK(ndr_pull_dfs_EnumArray5(ndr, NDR_SCALARS|NDR_BUFFERS, r->info5));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info5_0, 0);
				}
			break;

			case 6:
				if (r->info6) {
					_mem_save_info6_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info6, 0);
					NDR_CHECK(ndr_pull_dfs_EnumArray6(ndr, NDR_SCALARS|NDR_BUFFERS, r->info6));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info6_0, 0);
				}
			break;

			case 200:
				if (r->info200) {
					_mem_save_info200_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info200, 0);
					NDR_CHECK(ndr_pull_dfs_EnumArray200(ndr, NDR_SCALARS|NDR_BUFFERS, r->info200));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info200_0, 0);
				}
			break;

			case 300:
				if (r->info300) {
					_mem_save_info300_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info300, 0);
					NDR_CHECK(ndr_pull_dfs_EnumArray300(ndr, NDR_SCALARS|NDR_BUFFERS, r->info300));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info300_0, 0);
				}
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_EnumInfo(struct ndr_print *ndr, const char *name, const union dfs_EnumInfo *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "dfs_EnumInfo");
	switch (level) {
		case 1:
			ndr_print_ptr(ndr, "info1", r->info1);
			ndr->depth++;
			if (r->info1) {
				ndr_print_dfs_EnumArray1(ndr, "info1", r->info1);
			}
			ndr->depth--;
		break;

		case 2:
			ndr_print_ptr(ndr, "info2", r->info2);
			ndr->depth++;
			if (r->info2) {
				ndr_print_dfs_EnumArray2(ndr, "info2", r->info2);
			}
			ndr->depth--;
		break;

		case 3:
			ndr_print_ptr(ndr, "info3", r->info3);
			ndr->depth++;
			if (r->info3) {
				ndr_print_dfs_EnumArray3(ndr, "info3", r->info3);
			}
			ndr->depth--;
		break;

		case 4:
			ndr_print_ptr(ndr, "info4", r->info4);
			ndr->depth++;
			if (r->info4) {
				ndr_print_dfs_EnumArray4(ndr, "info4", r->info4);
			}
			ndr->depth--;
		break;

		case 5:
			ndr_print_ptr(ndr, "info5", r->info5);
			ndr->depth++;
			if (r->info5) {
				ndr_print_dfs_EnumArray5(ndr, "info5", r->info5);
			}
			ndr->depth--;
		break;

		case 6:
			ndr_print_ptr(ndr, "info6", r->info6);
			ndr->depth++;
			if (r->info6) {
				ndr_print_dfs_EnumArray6(ndr, "info6", r->info6);
			}
			ndr->depth--;
		break;

		case 200:
			ndr_print_ptr(ndr, "info200", r->info200);
			ndr->depth++;
			if (r->info200) {
				ndr_print_dfs_EnumArray200(ndr, "info200", r->info200);
			}
			ndr->depth--;
		break;

		case 300:
			ndr_print_ptr(ndr, "info300", r->info300);
			ndr->depth++;
			if (r->info300) {
				ndr_print_dfs_EnumArray300(ndr, "info300", r->info300);
			}
			ndr->depth--;
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_dfs_EnumStruct(struct ndr_push *ndr, int ndr_flags, const struct dfs_EnumStruct *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->e, r->level));
		NDR_CHECK(ndr_push_dfs_EnumInfo(ndr, NDR_SCALARS, &r->e));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_dfs_EnumInfo(ndr, NDR_BUFFERS, &r->e));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_EnumStruct(struct ndr_pull *ndr, int ndr_flags, struct dfs_EnumStruct *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->level));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->e, r->level));
		NDR_CHECK(ndr_pull_dfs_EnumInfo(ndr, NDR_SCALARS, &r->e));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_dfs_EnumInfo(ndr, NDR_BUFFERS, &r->e));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_EnumStruct(struct ndr_print *ndr, const char *name, const struct dfs_EnumStruct *r)
{
	ndr_print_struct(ndr, name, "dfs_EnumStruct");
	ndr->depth++;
	ndr_print_uint32(ndr, "level", r->level);
	ndr_print_set_switch_value(ndr, &r->e, r->level);
	ndr_print_dfs_EnumInfo(ndr, "e", &r->e);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_UnknownStruct(struct ndr_push *ndr, int ndr_flags, const struct dfs_UnknownStruct *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown1));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->unknown2));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->unknown2) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->unknown2, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->unknown2, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->unknown2, ndr_charset_length(r->unknown2, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_UnknownStruct(struct ndr_pull *ndr, int ndr_flags, struct dfs_UnknownStruct *r)
{
	uint32_t _ptr_unknown2;
	uint32_t size_unknown2_1 = 0;
	uint32_t length_unknown2_1 = 0;
	TALLOC_CTX *_mem_save_unknown2_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown1));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_unknown2));
		if (_ptr_unknown2) {
			NDR_PULL_ALLOC(ndr, r->unknown2);
		} else {
			r->unknown2 = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->unknown2) {
			_mem_save_unknown2_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->unknown2, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->unknown2));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->unknown2));
			size_unknown2_1 = ndr_get_array_size(ndr, &r->unknown2);
			length_unknown2_1 = ndr_get_array_length(ndr, &r->unknown2);
			if (length_unknown2_1 > size_unknown2_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_unknown2_1, length_unknown2_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_unknown2_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->unknown2, length_unknown2_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_unknown2_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_UnknownStruct(struct ndr_print *ndr, const char *name, const struct dfs_UnknownStruct *r)
{
	ndr_print_struct(ndr, name, "dfs_UnknownStruct");
	ndr->depth++;
	ndr_print_uint32(ndr, "unknown1", r->unknown1);
	ndr_print_ptr(ndr, "unknown2", r->unknown2);
	ndr->depth++;
	if (r->unknown2) {
		ndr_print_string(ndr, "unknown2", r->unknown2);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dfs_GetManagerVersion(struct ndr_push *ndr, int flags, const struct dfs_GetManagerVersion *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		if (r->out.version == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_dfs_ManagerVersion(ndr, NDR_SCALARS, *r->out.version));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dfs_GetManagerVersion(struct ndr_pull *ndr, int flags, struct dfs_GetManagerVersion *r)
{
	TALLOC_CTX *_mem_save_version_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_PULL_ALLOC(ndr, r->out.version);
		ZERO_STRUCTP(r->out.version);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.version);
		}
		_mem_save_version_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.version, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_dfs_ManagerVersion(ndr, NDR_SCALARS, r->out.version));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_version_0, LIBNDR_FLAG_REF_ALLOC);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_GetManagerVersion(struct ndr_print *ndr, const char *name, int flags, const struct dfs_GetManagerVersion *r)
{
	ndr_print_struct(ndr, name, "dfs_GetManagerVersion");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "dfs_GetManagerVersion");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "dfs_GetManagerVersion");
		ndr->depth++;
		ndr_print_ptr(ndr, "version", r->out.version);
		ndr->depth++;
		ndr_print_dfs_ManagerVersion(ndr, "version", *r->out.version);
		ndr->depth--;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_Add(struct ndr_push *ndr, int flags, const struct dfs_Add *r)
{
	if (flags & NDR_IN) {
		if (r->in.path == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.path, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.path, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.path, ndr_charset_length(r->in.path, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		if (r->in.server == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.server, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.server, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server, ndr_charset_length(r->in.server, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.share));
		if (r->in.share) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.share, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.share, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.share, ndr_charset_length(r->in.share, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.comment));
		if (r->in.comment) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.comment, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.comment, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.comment, ndr_charset_length(r->in.comment, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_Add(struct ndr_pull *ndr, int flags, struct dfs_Add *r)
{
	uint32_t size_path_1 = 0;
	uint32_t length_path_1 = 0;
	uint32_t size_server_1 = 0;
	uint32_t length_server_1 = 0;
	uint32_t _ptr_share;
	uint32_t size_share_1 = 0;
	uint32_t length_share_1 = 0;
	uint32_t _ptr_comment;
	uint32_t size_comment_1 = 0;
	uint32_t length_comment_1 = 0;
	TALLOC_CTX *_mem_save_share_0;
	TALLOC_CTX *_mem_save_comment_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.path));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.path));
		size_path_1 = ndr_get_array_size(ndr, &r->in.path);
		length_path_1 = ndr_get_array_length(ndr, &r->in.path);
		if (length_path_1 > size_path_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_path_1, length_path_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_path_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.path, length_path_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server));
		size_server_1 = ndr_get_array_size(ndr, &r->in.server);
		length_server_1 = ndr_get_array_length(ndr, &r->in.server);
		if (length_server_1 > size_server_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_server_1, length_server_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_server_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server, length_server_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_share));
		if (_ptr_share) {
			NDR_PULL_ALLOC(ndr, r->in.share);
		} else {
			r->in.share = NULL;
		}
		if (r->in.share) {
			_mem_save_share_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.share, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.share));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.share));
			size_share_1 = ndr_get_array_size(ndr, &r->in.share);
			length_share_1 = ndr_get_array_length(ndr, &r->in.share);
			if (length_share_1 > size_share_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_share_1, length_share_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_share_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.share, length_share_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_share_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_comment));
		if (_ptr_comment) {
			NDR_PULL_ALLOC(ndr, r->in.comment);
		} else {
			r->in.comment = NULL;
		}
		if (r->in.comment) {
			_mem_save_comment_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.comment, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.comment));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.comment));
			size_comment_1 = ndr_get_array_size(ndr, &r->in.comment);
			length_comment_1 = ndr_get_array_length(ndr, &r->in.comment);
			if (length_comment_1 > size_comment_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_comment_1, length_comment_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_comment_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.comment, length_comment_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_comment_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_Add(struct ndr_print *ndr, const char *name, int flags, const struct dfs_Add *r)
{
	ndr_print_struct(ndr, name, "dfs_Add");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "dfs_Add");
		ndr->depth++;
		ndr_print_ptr(ndr, "path", r->in.path);
		ndr->depth++;
		ndr_print_string(ndr, "path", r->in.path);
		ndr->depth--;
		ndr_print_ptr(ndr, "server", r->in.server);
		ndr->depth++;
		ndr_print_string(ndr, "server", r->in.server);
		ndr->depth--;
		ndr_print_ptr(ndr, "share", r->in.share);
		ndr->depth++;
		if (r->in.share) {
			ndr_print_string(ndr, "share", r->in.share);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "comment", r->in.comment);
		ndr->depth++;
		if (r->in.comment) {
			ndr_print_string(ndr, "comment", r->in.comment);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "dfs_Add");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_Remove(struct ndr_push *ndr, int flags, const struct dfs_Remove *r)
{
	if (flags & NDR_IN) {
		if (r->in.dfs_entry_path == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.dfs_entry_path, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.dfs_entry_path, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.dfs_entry_path, ndr_charset_length(r->in.dfs_entry_path, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.servername));
		if (r->in.servername) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.servername, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.servername, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.servername, ndr_charset_length(r->in.servername, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.sharename));
		if (r->in.sharename) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.sharename, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.sharename, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.sharename, ndr_charset_length(r->in.sharename, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_Remove(struct ndr_pull *ndr, int flags, struct dfs_Remove *r)
{
	uint32_t size_dfs_entry_path_1 = 0;
	uint32_t length_dfs_entry_path_1 = 0;
	uint32_t _ptr_servername;
	uint32_t size_servername_1 = 0;
	uint32_t length_servername_1 = 0;
	uint32_t _ptr_sharename;
	uint32_t size_sharename_1 = 0;
	uint32_t length_sharename_1 = 0;
	TALLOC_CTX *_mem_save_servername_0;
	TALLOC_CTX *_mem_save_sharename_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.dfs_entry_path));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.dfs_entry_path));
		size_dfs_entry_path_1 = ndr_get_array_size(ndr, &r->in.dfs_entry_path);
		length_dfs_entry_path_1 = ndr_get_array_length(ndr, &r->in.dfs_entry_path);
		if (length_dfs_entry_path_1 > size_dfs_entry_path_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_dfs_entry_path_1, length_dfs_entry_path_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_dfs_entry_path_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.dfs_entry_path, length_dfs_entry_path_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_servername));
		if (_ptr_servername) {
			NDR_PULL_ALLOC(ndr, r->in.servername);
		} else {
			r->in.servername = NULL;
		}
		if (r->in.servername) {
			_mem_save_servername_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.servername, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.servername));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.servername));
			size_servername_1 = ndr_get_array_size(ndr, &r->in.servername);
			length_servername_1 = ndr_get_array_length(ndr, &r->in.servername);
			if (length_servername_1 > size_servername_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_servername_1, length_servername_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_servername_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.servername, length_servername_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_servername_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sharename));
		if (_ptr_sharename) {
			NDR_PULL_ALLOC(ndr, r->in.sharename);
		} else {
			r->in.sharename = NULL;
		}
		if (r->in.sharename) {
			_mem_save_sharename_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.sharename, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.sharename));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.sharename));
			size_sharename_1 = ndr_get_array_size(ndr, &r->in.sharename);
			length_sharename_1 = ndr_get_array_length(ndr, &r->in.sharename);
			if (length_sharename_1 > size_sharename_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_sharename_1, length_sharename_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_sharename_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.sharename, length_sharename_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sharename_0, 0);
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_Remove(struct ndr_print *ndr, const char *name, int flags, const struct dfs_Remove *r)
{
	ndr_print_struct(ndr, name, "dfs_Remove");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "dfs_Remove");
		ndr->depth++;
		ndr_print_ptr(ndr, "dfs_entry_path", r->in.dfs_entry_path);
		ndr->depth++;
		ndr_print_string(ndr, "dfs_entry_path", r->in.dfs_entry_path);
		ndr->depth--;
		ndr_print_ptr(ndr, "servername", r->in.servername);
		ndr->depth++;
		if (r->in.servername) {
			ndr_print_string(ndr, "servername", r->in.servername);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "sharename", r->in.sharename);
		ndr->depth++;
		if (r->in.sharename) {
			ndr_print_string(ndr, "sharename", r->in.sharename);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "dfs_Remove");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_SetInfo(struct ndr_push *ndr, int flags, const struct dfs_SetInfo *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.dfs_entry_path, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.dfs_entry_path, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.dfs_entry_path, ndr_charset_length(r->in.dfs_entry_path, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.servername));
		if (r->in.servername) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.servername, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.servername, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.servername, ndr_charset_length(r->in.servername, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.sharename));
		if (r->in.sharename) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.sharename, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.sharename, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.sharename, ndr_charset_length(r->in.sharename, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		if (r->in.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->in.info, r->in.level));
		NDR_CHECK(ndr_push_dfs_Info(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_SetInfo(struct ndr_pull *ndr, int flags, struct dfs_SetInfo *r)
{
	uint32_t size_dfs_entry_path_0 = 0;
	uint32_t length_dfs_entry_path_0 = 0;
	uint32_t _ptr_servername;
	uint32_t size_servername_1 = 0;
	uint32_t length_servername_1 = 0;
	uint32_t _ptr_sharename;
	uint32_t size_sharename_1 = 0;
	uint32_t length_sharename_1 = 0;
	TALLOC_CTX *_mem_save_servername_0;
	TALLOC_CTX *_mem_save_sharename_0;
	TALLOC_CTX *_mem_save_info_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.dfs_entry_path));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.dfs_entry_path));
		size_dfs_entry_path_0 = ndr_get_array_size(ndr, &r->in.dfs_entry_path);
		length_dfs_entry_path_0 = ndr_get_array_length(ndr, &r->in.dfs_entry_path);
		if (length_dfs_entry_path_0 > size_dfs_entry_path_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_dfs_entry_path_0, length_dfs_entry_path_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_dfs_entry_path_0, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.dfs_entry_path, length_dfs_entry_path_0, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_servername));
		if (_ptr_servername) {
			NDR_PULL_ALLOC(ndr, r->in.servername);
		} else {
			r->in.servername = NULL;
		}
		if (r->in.servername) {
			_mem_save_servername_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.servername, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.servername));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.servername));
			size_servername_1 = ndr_get_array_size(ndr, &r->in.servername);
			length_servername_1 = ndr_get_array_length(ndr, &r->in.servername);
			if (length_servername_1 > size_servername_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_servername_1, length_servername_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_servername_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.servername, length_servername_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_servername_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sharename));
		if (_ptr_sharename) {
			NDR_PULL_ALLOC(ndr, r->in.sharename);
		} else {
			r->in.sharename = NULL;
		}
		if (r->in.sharename) {
			_mem_save_sharename_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.sharename, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.sharename));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.sharename));
			size_sharename_1 = ndr_get_array_size(ndr, &r->in.sharename);
			length_sharename_1 = ndr_get_array_length(ndr, &r->in.sharename);
			if (length_sharename_1 > size_sharename_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_sharename_1, length_sharename_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_sharename_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.sharename, length_sharename_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sharename_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->in.info, r->in.level));
		NDR_CHECK(ndr_pull_dfs_Info(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_SetInfo(struct ndr_print *ndr, const char *name, int flags, const struct dfs_SetInfo *r)
{
	ndr_print_struct(ndr, name, "dfs_SetInfo");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "dfs_SetInfo");
		ndr->depth++;
		ndr_print_string(ndr, "dfs_entry_path", r->in.dfs_entry_path);
		ndr_print_ptr(ndr, "servername", r->in.servername);
		ndr->depth++;
		if (r->in.servername) {
			ndr_print_string(ndr, "servername", r->in.servername);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "sharename", r->in.sharename);
		ndr->depth++;
		if (r->in.sharename) {
			ndr_print_string(ndr, "sharename", r->in.sharename);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "info", r->in.info);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->in.info, r->in.level);
		ndr_print_dfs_Info(ndr, "info", r->in.info);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "dfs_SetInfo");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_GetInfo(struct ndr_push *ndr, int flags, const struct dfs_GetInfo *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.dfs_entry_path, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.dfs_entry_path, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.dfs_entry_path, ndr_charset_length(r->in.dfs_entry_path, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.servername));
		if (r->in.servername) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.servername, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.servername, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.servername, ndr_charset_length(r->in.servername, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.sharename));
		if (r->in.sharename) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.sharename, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.sharename, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.sharename, ndr_charset_length(r->in.sharename, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
	}
	if (flags & NDR_OUT) {
		if (r->out.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->out.info, r->in.level));
		NDR_CHECK(ndr_push_dfs_Info(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_GetInfo(struct ndr_pull *ndr, int flags, struct dfs_GetInfo *r)
{
	uint32_t size_dfs_entry_path_0 = 0;
	uint32_t length_dfs_entry_path_0 = 0;
	uint32_t _ptr_servername;
	uint32_t size_servername_1 = 0;
	uint32_t length_servername_1 = 0;
	uint32_t _ptr_sharename;
	uint32_t size_sharename_1 = 0;
	uint32_t length_sharename_1 = 0;
	TALLOC_CTX *_mem_save_servername_0;
	TALLOC_CTX *_mem_save_sharename_0;
	TALLOC_CTX *_mem_save_info_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.dfs_entry_path));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.dfs_entry_path));
		size_dfs_entry_path_0 = ndr_get_array_size(ndr, &r->in.dfs_entry_path);
		length_dfs_entry_path_0 = ndr_get_array_length(ndr, &r->in.dfs_entry_path);
		if (length_dfs_entry_path_0 > size_dfs_entry_path_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_dfs_entry_path_0, length_dfs_entry_path_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_dfs_entry_path_0, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.dfs_entry_path, length_dfs_entry_path_0, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_servername));
		if (_ptr_servername) {
			NDR_PULL_ALLOC(ndr, r->in.servername);
		} else {
			r->in.servername = NULL;
		}
		if (r->in.servername) {
			_mem_save_servername_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.servername, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.servername));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.servername));
			size_servername_1 = ndr_get_array_size(ndr, &r->in.servername);
			length_servername_1 = ndr_get_array_length(ndr, &r->in.servername);
			if (length_servername_1 > size_servername_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_servername_1, length_servername_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_servername_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.servername, length_servername_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_servername_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sharename));
		if (_ptr_sharename) {
			NDR_PULL_ALLOC(ndr, r->in.sharename);
		} else {
			r->in.sharename = NULL;
		}
		if (r->in.sharename) {
			_mem_save_sharename_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.sharename, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.sharename));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.sharename));
			size_sharename_1 = ndr_get_array_size(ndr, &r->in.sharename);
			length_sharename_1 = ndr_get_array_length(ndr, &r->in.sharename);
			if (length_sharename_1 > size_sharename_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_sharename_1, length_sharename_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_sharename_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.sharename, length_sharename_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sharename_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		NDR_PULL_ALLOC(ndr, r->out.info);
		ZERO_STRUCTP(r->out.info);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->out.info, r->in.level));
		NDR_CHECK(ndr_pull_dfs_Info(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_GetInfo(struct ndr_print *ndr, const char *name, int flags, const struct dfs_GetInfo *r)
{
	ndr_print_struct(ndr, name, "dfs_GetInfo");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "dfs_GetInfo");
		ndr->depth++;
		ndr_print_string(ndr, "dfs_entry_path", r->in.dfs_entry_path);
		ndr_print_ptr(ndr, "servername", r->in.servername);
		ndr->depth++;
		if (r->in.servername) {
			ndr_print_string(ndr, "servername", r->in.servername);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "sharename", r->in.sharename);
		ndr->depth++;
		if (r->in.sharename) {
			ndr_print_string(ndr, "sharename", r->in.sharename);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "dfs_GetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->out.info, r->in.level);
		ndr_print_dfs_Info(ndr, "info", r->out.info);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_Enum(struct ndr_push *ndr, int flags, const struct dfs_Enum *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.bufsize));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.info));
		if (r->in.info) {
			NDR_CHECK(ndr_push_dfs_EnumStruct(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.total));
		if (r->in.total) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.total));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.info));
		if (r->out.info) {
			NDR_CHECK(ndr_push_dfs_EnumStruct(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.total));
		if (r->out.total) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.total));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_Enum(struct ndr_pull *ndr, int flags, struct dfs_Enum *r)
{
	uint32_t _ptr_info;
	uint32_t _ptr_total;
	TALLOC_CTX *_mem_save_info_0;
	TALLOC_CTX *_mem_save_total_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.bufsize));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, r->in.info);
		} else {
			r->in.info = NULL;
		}
		if (r->in.info) {
			_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.info, 0);
			NDR_CHECK(ndr_pull_dfs_EnumStruct(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_total));
		if (_ptr_total) {
			NDR_PULL_ALLOC(ndr, r->in.total);
		} else {
			r->in.total = NULL;
		}
		if (r->in.total) {
			_mem_save_total_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.total, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.total));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_total_0, 0);
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		} else {
			r->out.info = NULL;
		}
		if (r->out.info) {
			_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.info, 0);
			NDR_CHECK(ndr_pull_dfs_EnumStruct(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_total));
		if (_ptr_total) {
			NDR_PULL_ALLOC(ndr, r->out.total);
		} else {
			r->out.total = NULL;
		}
		if (r->out.total) {
			_mem_save_total_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.total, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.total));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_total_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_Enum(struct ndr_print *ndr, const char *name, int flags, const struct dfs_Enum *r)
{
	ndr_print_struct(ndr, name, "dfs_Enum");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "dfs_Enum");
		ndr->depth++;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_uint32(ndr, "bufsize", r->in.bufsize);
		ndr_print_ptr(ndr, "info", r->in.info);
		ndr->depth++;
		if (r->in.info) {
			ndr_print_dfs_EnumStruct(ndr, "info", r->in.info);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "total", r->in.total);
		ndr->depth++;
		if (r->in.total) {
			ndr_print_uint32(ndr, "total", *r->in.total);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "dfs_Enum");
		ndr->depth++;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		if (r->out.info) {
			ndr_print_dfs_EnumStruct(ndr, "info", r->out.info);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "total", r->out.total);
		ndr->depth++;
		if (r->out.total) {
			ndr_print_uint32(ndr, "total", *r->out.total);
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_Rename(struct ndr_push *ndr, int flags, const struct dfs_Rename *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_Rename(struct ndr_pull *ndr, int flags, struct dfs_Rename *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_Rename(struct ndr_print *ndr, const char *name, int flags, const struct dfs_Rename *r)
{
	ndr_print_struct(ndr, name, "dfs_Rename");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "dfs_Rename");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "dfs_Rename");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_Move(struct ndr_push *ndr, int flags, const struct dfs_Move *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_Move(struct ndr_pull *ndr, int flags, struct dfs_Move *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_Move(struct ndr_print *ndr, const char *name, int flags, const struct dfs_Move *r)
{
	ndr_print_struct(ndr, name, "dfs_Move");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "dfs_Move");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "dfs_Move");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_ManagerGetConfigInfo(struct ndr_push *ndr, int flags, const struct dfs_ManagerGetConfigInfo *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_ManagerGetConfigInfo(struct ndr_pull *ndr, int flags, struct dfs_ManagerGetConfigInfo *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_ManagerGetConfigInfo(struct ndr_print *ndr, const char *name, int flags, const struct dfs_ManagerGetConfigInfo *r)
{
	ndr_print_struct(ndr, name, "dfs_ManagerGetConfigInfo");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "dfs_ManagerGetConfigInfo");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "dfs_ManagerGetConfigInfo");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_ManagerSendSiteInfo(struct ndr_push *ndr, int flags, const struct dfs_ManagerSendSiteInfo *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_ManagerSendSiteInfo(struct ndr_pull *ndr, int flags, struct dfs_ManagerSendSiteInfo *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_ManagerSendSiteInfo(struct ndr_print *ndr, const char *name, int flags, const struct dfs_ManagerSendSiteInfo *r)
{
	ndr_print_struct(ndr, name, "dfs_ManagerSendSiteInfo");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "dfs_ManagerSendSiteInfo");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "dfs_ManagerSendSiteInfo");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_AddFtRoot(struct ndr_push *ndr, int flags, const struct dfs_AddFtRoot *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.servername, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.servername, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.servername, ndr_charset_length(r->in.servername, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.dns_servername, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.dns_servername, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.dns_servername, ndr_charset_length(r->in.dns_servername, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.dfsname, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.dfsname, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.dfsname, ndr_charset_length(r->in.dfsname, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.rootshare, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.rootshare, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.rootshare, ndr_charset_length(r->in.rootshare, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.comment, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.comment, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.comment, ndr_charset_length(r->in.comment, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.dfs_config_dn, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.dfs_config_dn, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.dfs_config_dn, ndr_charset_length(r->in.dfs_config_dn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->in.unknown1));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.unknown2));
		if (r->in.unknown2) {
			NDR_CHECK(ndr_push_unique_ptr(ndr, *r->in.unknown2));
			if (*r->in.unknown2) {
				NDR_CHECK(ndr_push_dfs_UnknownStruct(ndr, NDR_SCALARS|NDR_BUFFERS, *r->in.unknown2));
			}
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.unknown2));
		if (r->out.unknown2) {
			NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.unknown2));
			if (*r->out.unknown2) {
				NDR_CHECK(ndr_push_dfs_UnknownStruct(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.unknown2));
			}
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_AddFtRoot(struct ndr_pull *ndr, int flags, struct dfs_AddFtRoot *r)
{
	uint32_t size_servername_0 = 0;
	uint32_t length_servername_0 = 0;
	uint32_t size_dns_servername_0 = 0;
	uint32_t length_dns_servername_0 = 0;
	uint32_t size_dfsname_0 = 0;
	uint32_t length_dfsname_0 = 0;
	uint32_t size_rootshare_0 = 0;
	uint32_t length_rootshare_0 = 0;
	uint32_t size_comment_0 = 0;
	uint32_t length_comment_0 = 0;
	uint32_t size_dfs_config_dn_0 = 0;
	uint32_t length_dfs_config_dn_0 = 0;
	uint32_t _ptr_unknown2;
	TALLOC_CTX *_mem_save_unknown2_0;
	TALLOC_CTX *_mem_save_unknown2_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.servername));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.servername));
		size_servername_0 = ndr_get_array_size(ndr, &r->in.servername);
		length_servername_0 = ndr_get_array_length(ndr, &r->in.servername);
		if (length_servername_0 > size_servername_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_servername_0, length_servername_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_servername_0, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.servername, length_servername_0, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.dns_servername));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.dns_servername));
		size_dns_servername_0 = ndr_get_array_size(ndr, &r->in.dns_servername);
		length_dns_servername_0 = ndr_get_array_length(ndr, &r->in.dns_servername);
		if (length_dns_servername_0 > size_dns_servername_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_dns_servername_0, length_dns_servername_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_dns_servername_0, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.dns_servername, length_dns_servername_0, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.dfsname));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.dfsname));
		size_dfsname_0 = ndr_get_array_size(ndr, &r->in.dfsname);
		length_dfsname_0 = ndr_get_array_length(ndr, &r->in.dfsname);
		if (length_dfsname_0 > size_dfsname_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_dfsname_0, length_dfsname_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_dfsname_0, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.dfsname, length_dfsname_0, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.rootshare));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.rootshare));
		size_rootshare_0 = ndr_get_array_size(ndr, &r->in.rootshare);
		length_rootshare_0 = ndr_get_array_length(ndr, &r->in.rootshare);
		if (length_rootshare_0 > size_rootshare_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_rootshare_0, length_rootshare_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_rootshare_0, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.rootshare, length_rootshare_0, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.comment));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.comment));
		size_comment_0 = ndr_get_array_size(ndr, &r->in.comment);
		length_comment_0 = ndr_get_array_length(ndr, &r->in.comment);
		if (length_comment_0 > size_comment_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_comment_0, length_comment_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_comment_0, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.comment, length_comment_0, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.dfs_config_dn));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.dfs_config_dn));
		size_dfs_config_dn_0 = ndr_get_array_size(ndr, &r->in.dfs_config_dn);
		length_dfs_config_dn_0 = ndr_get_array_length(ndr, &r->in.dfs_config_dn);
		if (length_dfs_config_dn_0 > size_dfs_config_dn_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_dfs_config_dn_0, length_dfs_config_dn_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_dfs_config_dn_0, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.dfs_config_dn, length_dfs_config_dn_0, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->in.unknown1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_unknown2));
		if (_ptr_unknown2) {
			NDR_PULL_ALLOC(ndr, r->in.unknown2);
		} else {
			r->in.unknown2 = NULL;
		}
		if (r->in.unknown2) {
			_mem_save_unknown2_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.unknown2, 0);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_unknown2));
			if (_ptr_unknown2) {
				NDR_PULL_ALLOC(ndr, *r->in.unknown2);
			} else {
				*r->in.unknown2 = NULL;
			}
			if (*r->in.unknown2) {
				_mem_save_unknown2_1 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, *r->in.unknown2, 0);
				NDR_CHECK(ndr_pull_dfs_UnknownStruct(ndr, NDR_SCALARS|NDR_BUFFERS, *r->in.unknown2));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_unknown2_1, 0);
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_unknown2_0, 0);
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_unknown2));
		if (_ptr_unknown2) {
			NDR_PULL_ALLOC(ndr, r->out.unknown2);
		} else {
			r->out.unknown2 = NULL;
		}
		if (r->out.unknown2) {
			_mem_save_unknown2_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.unknown2, 0);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_unknown2));
			if (_ptr_unknown2) {
				NDR_PULL_ALLOC(ndr, *r->out.unknown2);
			} else {
				*r->out.unknown2 = NULL;
			}
			if (*r->out.unknown2) {
				_mem_save_unknown2_1 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, *r->out.unknown2, 0);
				NDR_CHECK(ndr_pull_dfs_UnknownStruct(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.unknown2));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_unknown2_1, 0);
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_unknown2_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_AddFtRoot(struct ndr_print *ndr, const char *name, int flags, const struct dfs_AddFtRoot *r)
{
	ndr_print_struct(ndr, name, "dfs_AddFtRoot");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "dfs_AddFtRoot");
		ndr->depth++;
		ndr_print_string(ndr, "servername", r->in.servername);
		ndr_print_string(ndr, "dns_servername", r->in.dns_servername);
		ndr_print_string(ndr, "dfsname", r->in.dfsname);
		ndr_print_string(ndr, "rootshare", r->in.rootshare);
		ndr_print_string(ndr, "comment", r->in.comment);
		ndr_print_string(ndr, "dfs_config_dn", r->in.dfs_config_dn);
		ndr_print_uint8(ndr, "unknown1", r->in.unknown1);
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr_print_ptr(ndr, "unknown2", r->in.unknown2);
		ndr->depth++;
		if (r->in.unknown2) {
			ndr_print_ptr(ndr, "unknown2", *r->in.unknown2);
			ndr->depth++;
			if (*r->in.unknown2) {
				ndr_print_dfs_UnknownStruct(ndr, "unknown2", *r->in.unknown2);
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "dfs_AddFtRoot");
		ndr->depth++;
		ndr_print_ptr(ndr, "unknown2", r->out.unknown2);
		ndr->depth++;
		if (r->out.unknown2) {
			ndr_print_ptr(ndr, "unknown2", *r->out.unknown2);
			ndr->depth++;
			if (*r->out.unknown2) {
				ndr_print_dfs_UnknownStruct(ndr, "unknown2", *r->out.unknown2);
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_RemoveFtRoot(struct ndr_push *ndr, int flags, const struct dfs_RemoveFtRoot *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.servername, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.servername, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.servername, ndr_charset_length(r->in.servername, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.dns_servername, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.dns_servername, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.dns_servername, ndr_charset_length(r->in.dns_servername, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.dfsname, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.dfsname, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.dfsname, ndr_charset_length(r->in.dfsname, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.rootshare, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.rootshare, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.rootshare, ndr_charset_length(r->in.rootshare, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.unknown));
		if (r->in.unknown) {
			NDR_CHECK(ndr_push_unique_ptr(ndr, *r->in.unknown));
			if (*r->in.unknown) {
				NDR_CHECK(ndr_push_dfs_UnknownStruct(ndr, NDR_SCALARS|NDR_BUFFERS, *r->in.unknown));
			}
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.unknown));
		if (r->out.unknown) {
			NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.unknown));
			if (*r->out.unknown) {
				NDR_CHECK(ndr_push_dfs_UnknownStruct(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.unknown));
			}
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_RemoveFtRoot(struct ndr_pull *ndr, int flags, struct dfs_RemoveFtRoot *r)
{
	uint32_t size_servername_0 = 0;
	uint32_t length_servername_0 = 0;
	uint32_t size_dns_servername_0 = 0;
	uint32_t length_dns_servername_0 = 0;
	uint32_t size_dfsname_0 = 0;
	uint32_t length_dfsname_0 = 0;
	uint32_t size_rootshare_0 = 0;
	uint32_t length_rootshare_0 = 0;
	uint32_t _ptr_unknown;
	TALLOC_CTX *_mem_save_unknown_0;
	TALLOC_CTX *_mem_save_unknown_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.servername));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.servername));
		size_servername_0 = ndr_get_array_size(ndr, &r->in.servername);
		length_servername_0 = ndr_get_array_length(ndr, &r->in.servername);
		if (length_servername_0 > size_servername_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_servername_0, length_servername_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_servername_0, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.servername, length_servername_0, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.dns_servername));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.dns_servername));
		size_dns_servername_0 = ndr_get_array_size(ndr, &r->in.dns_servername);
		length_dns_servername_0 = ndr_get_array_length(ndr, &r->in.dns_servername);
		if (length_dns_servername_0 > size_dns_servername_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_dns_servername_0, length_dns_servername_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_dns_servername_0, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.dns_servername, length_dns_servername_0, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.dfsname));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.dfsname));
		size_dfsname_0 = ndr_get_array_size(ndr, &r->in.dfsname);
		length_dfsname_0 = ndr_get_array_length(ndr, &r->in.dfsname);
		if (length_dfsname_0 > size_dfsname_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_dfsname_0, length_dfsname_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_dfsname_0, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.dfsname, length_dfsname_0, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.rootshare));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.rootshare));
		size_rootshare_0 = ndr_get_array_size(ndr, &r->in.rootshare);
		length_rootshare_0 = ndr_get_array_length(ndr, &r->in.rootshare);
		if (length_rootshare_0 > size_rootshare_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_rootshare_0, length_rootshare_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_rootshare_0, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.rootshare, length_rootshare_0, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_unknown));
		if (_ptr_unknown) {
			NDR_PULL_ALLOC(ndr, r->in.unknown);
		} else {
			r->in.unknown = NULL;
		}
		if (r->in.unknown) {
			_mem_save_unknown_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.unknown, 0);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_unknown));
			if (_ptr_unknown) {
				NDR_PULL_ALLOC(ndr, *r->in.unknown);
			} else {
				*r->in.unknown = NULL;
			}
			if (*r->in.unknown) {
				_mem_save_unknown_1 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, *r->in.unknown, 0);
				NDR_CHECK(ndr_pull_dfs_UnknownStruct(ndr, NDR_SCALARS|NDR_BUFFERS, *r->in.unknown));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_unknown_1, 0);
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_unknown_0, 0);
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_unknown));
		if (_ptr_unknown) {
			NDR_PULL_ALLOC(ndr, r->out.unknown);
		} else {
			r->out.unknown = NULL;
		}
		if (r->out.unknown) {
			_mem_save_unknown_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.unknown, 0);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_unknown));
			if (_ptr_unknown) {
				NDR_PULL_ALLOC(ndr, *r->out.unknown);
			} else {
				*r->out.unknown = NULL;
			}
			if (*r->out.unknown) {
				_mem_save_unknown_1 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, *r->out.unknown, 0);
				NDR_CHECK(ndr_pull_dfs_UnknownStruct(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.unknown));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_unknown_1, 0);
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_unknown_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_RemoveFtRoot(struct ndr_print *ndr, const char *name, int flags, const struct dfs_RemoveFtRoot *r)
{
	ndr_print_struct(ndr, name, "dfs_RemoveFtRoot");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "dfs_RemoveFtRoot");
		ndr->depth++;
		ndr_print_string(ndr, "servername", r->in.servername);
		ndr_print_string(ndr, "dns_servername", r->in.dns_servername);
		ndr_print_string(ndr, "dfsname", r->in.dfsname);
		ndr_print_string(ndr, "rootshare", r->in.rootshare);
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr_print_ptr(ndr, "unknown", r->in.unknown);
		ndr->depth++;
		if (r->in.unknown) {
			ndr_print_ptr(ndr, "unknown", *r->in.unknown);
			ndr->depth++;
			if (*r->in.unknown) {
				ndr_print_dfs_UnknownStruct(ndr, "unknown", *r->in.unknown);
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "dfs_RemoveFtRoot");
		ndr->depth++;
		ndr_print_ptr(ndr, "unknown", r->out.unknown);
		ndr->depth++;
		if (r->out.unknown) {
			ndr_print_ptr(ndr, "unknown", *r->out.unknown);
			ndr->depth++;
			if (*r->out.unknown) {
				ndr_print_dfs_UnknownStruct(ndr, "unknown", *r->out.unknown);
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_AddStdRoot(struct ndr_push *ndr, int flags, const struct dfs_AddStdRoot *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.servername, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.servername, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.servername, ndr_charset_length(r->in.servername, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.rootshare, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.rootshare, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.rootshare, ndr_charset_length(r->in.rootshare, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.comment, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.comment, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.comment, ndr_charset_length(r->in.comment, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_AddStdRoot(struct ndr_pull *ndr, int flags, struct dfs_AddStdRoot *r)
{
	uint32_t size_servername_0 = 0;
	uint32_t length_servername_0 = 0;
	uint32_t size_rootshare_0 = 0;
	uint32_t length_rootshare_0 = 0;
	uint32_t size_comment_0 = 0;
	uint32_t length_comment_0 = 0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.servername));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.servername));
		size_servername_0 = ndr_get_array_size(ndr, &r->in.servername);
		length_servername_0 = ndr_get_array_length(ndr, &r->in.servername);
		if (length_servername_0 > size_servername_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_servername_0, length_servername_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_servername_0, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.servername, length_servername_0, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.rootshare));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.rootshare));
		size_rootshare_0 = ndr_get_array_size(ndr, &r->in.rootshare);
		length_rootshare_0 = ndr_get_array_length(ndr, &r->in.rootshare);
		if (length_rootshare_0 > size_rootshare_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_rootshare_0, length_rootshare_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_rootshare_0, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.rootshare, length_rootshare_0, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.comment));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.comment));
		size_comment_0 = ndr_get_array_size(ndr, &r->in.comment);
		length_comment_0 = ndr_get_array_length(ndr, &r->in.comment);
		if (length_comment_0 > size_comment_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_comment_0, length_comment_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_comment_0, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.comment, length_comment_0, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_AddStdRoot(struct ndr_print *ndr, const char *name, int flags, const struct dfs_AddStdRoot *r)
{
	ndr_print_struct(ndr, name, "dfs_AddStdRoot");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "dfs_AddStdRoot");
		ndr->depth++;
		ndr_print_string(ndr, "servername", r->in.servername);
		ndr_print_string(ndr, "rootshare", r->in.rootshare);
		ndr_print_string(ndr, "comment", r->in.comment);
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "dfs_AddStdRoot");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_RemoveStdRoot(struct ndr_push *ndr, int flags, const struct dfs_RemoveStdRoot *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.servername, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.servername, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.servername, ndr_charset_length(r->in.servername, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.rootshare, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.rootshare, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.rootshare, ndr_charset_length(r->in.rootshare, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_RemoveStdRoot(struct ndr_pull *ndr, int flags, struct dfs_RemoveStdRoot *r)
{
	uint32_t size_servername_0 = 0;
	uint32_t length_servername_0 = 0;
	uint32_t size_rootshare_0 = 0;
	uint32_t length_rootshare_0 = 0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.servername));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.servername));
		size_servername_0 = ndr_get_array_size(ndr, &r->in.servername);
		length_servername_0 = ndr_get_array_length(ndr, &r->in.servername);
		if (length_servername_0 > size_servername_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_servername_0, length_servername_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_servername_0, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.servername, length_servername_0, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.rootshare));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.rootshare));
		size_rootshare_0 = ndr_get_array_size(ndr, &r->in.rootshare);
		length_rootshare_0 = ndr_get_array_length(ndr, &r->in.rootshare);
		if (length_rootshare_0 > size_rootshare_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_rootshare_0, length_rootshare_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_rootshare_0, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.rootshare, length_rootshare_0, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_RemoveStdRoot(struct ndr_print *ndr, const char *name, int flags, const struct dfs_RemoveStdRoot *r)
{
	ndr_print_struct(ndr, name, "dfs_RemoveStdRoot");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "dfs_RemoveStdRoot");
		ndr->depth++;
		ndr_print_string(ndr, "servername", r->in.servername);
		ndr_print_string(ndr, "rootshare", r->in.rootshare);
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "dfs_RemoveStdRoot");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_ManagerInitialize(struct ndr_push *ndr, int flags, const struct dfs_ManagerInitialize *r)
{
	if (flags & NDR_IN) {
		if (r->in.servername == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.servername, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.servername, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.servername, ndr_charset_length(r->in.servername, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_ManagerInitialize(struct ndr_pull *ndr, int flags, struct dfs_ManagerInitialize *r)
{
	uint32_t size_servername_1 = 0;
	uint32_t length_servername_1 = 0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.servername));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.servername));
		size_servername_1 = ndr_get_array_size(ndr, &r->in.servername);
		length_servername_1 = ndr_get_array_length(ndr, &r->in.servername);
		if (length_servername_1 > size_servername_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_servername_1, length_servername_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_servername_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.servername, length_servername_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_ManagerInitialize(struct ndr_print *ndr, const char *name, int flags, const struct dfs_ManagerInitialize *r)
{
	ndr_print_struct(ndr, name, "dfs_ManagerInitialize");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "dfs_ManagerInitialize");
		ndr->depth++;
		ndr_print_ptr(ndr, "servername", r->in.servername);
		ndr->depth++;
		ndr_print_string(ndr, "servername", r->in.servername);
		ndr->depth--;
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "dfs_ManagerInitialize");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_AddStdRootForced(struct ndr_push *ndr, int flags, const struct dfs_AddStdRootForced *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.servername, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.servername, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.servername, ndr_charset_length(r->in.servername, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.rootshare, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.rootshare, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.rootshare, ndr_charset_length(r->in.rootshare, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.comment, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.comment, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.comment, ndr_charset_length(r->in.comment, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.store, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.store, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.store, ndr_charset_length(r->in.store, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_AddStdRootForced(struct ndr_pull *ndr, int flags, struct dfs_AddStdRootForced *r)
{
	uint32_t size_servername_0 = 0;
	uint32_t length_servername_0 = 0;
	uint32_t size_rootshare_0 = 0;
	uint32_t length_rootshare_0 = 0;
	uint32_t size_comment_0 = 0;
	uint32_t length_comment_0 = 0;
	uint32_t size_store_0 = 0;
	uint32_t length_store_0 = 0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.servername));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.servername));
		size_servername_0 = ndr_get_array_size(ndr, &r->in.servername);
		length_servername_0 = ndr_get_array_length(ndr, &r->in.servername);
		if (length_servername_0 > size_servername_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_servername_0, length_servername_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_servername_0, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.servername, length_servername_0, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.rootshare));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.rootshare));
		size_rootshare_0 = ndr_get_array_size(ndr, &r->in.rootshare);
		length_rootshare_0 = ndr_get_array_length(ndr, &r->in.rootshare);
		if (length_rootshare_0 > size_rootshare_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_rootshare_0, length_rootshare_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_rootshare_0, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.rootshare, length_rootshare_0, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.comment));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.comment));
		size_comment_0 = ndr_get_array_size(ndr, &r->in.comment);
		length_comment_0 = ndr_get_array_length(ndr, &r->in.comment);
		if (length_comment_0 > size_comment_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_comment_0, length_comment_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_comment_0, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.comment, length_comment_0, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.store));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.store));
		size_store_0 = ndr_get_array_size(ndr, &r->in.store);
		length_store_0 = ndr_get_array_length(ndr, &r->in.store);
		if (length_store_0 > size_store_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_store_0, length_store_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_store_0, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.store, length_store_0, sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_AddStdRootForced(struct ndr_print *ndr, const char *name, int flags, const struct dfs_AddStdRootForced *r)
{
	ndr_print_struct(ndr, name, "dfs_AddStdRootForced");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "dfs_AddStdRootForced");
		ndr->depth++;
		ndr_print_string(ndr, "servername", r->in.servername);
		ndr_print_string(ndr, "rootshare", r->in.rootshare);
		ndr_print_string(ndr, "comment", r->in.comment);
		ndr_print_string(ndr, "store", r->in.store);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "dfs_AddStdRootForced");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_GetDcAddress(struct ndr_push *ndr, int flags, const struct dfs_GetDcAddress *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.servername, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.servername, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.servername, ndr_charset_length(r->in.servername, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		if (r->in.server_fullname == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->in.server_fullname));
		if (*r->in.server_fullname) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(*r->in.server_fullname, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(*r->in.server_fullname, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->in.server_fullname, ndr_charset_length(*r->in.server_fullname, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->in.is_root == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, *r->in.is_root));
		if (r->in.ttl == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.ttl));
	}
	if (flags & NDR_OUT) {
		if (r->out.server_fullname == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.server_fullname));
		if (*r->out.server_fullname) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(*r->out.server_fullname, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(*r->out.server_fullname, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.server_fullname, ndr_charset_length(*r->out.server_fullname, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->out.is_root == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, *r->out.is_root));
		if (r->out.ttl == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.ttl));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_GetDcAddress(struct ndr_pull *ndr, int flags, struct dfs_GetDcAddress *r)
{
	uint32_t size_servername_0 = 0;
	uint32_t length_servername_0 = 0;
	uint32_t _ptr_server_fullname;
	uint32_t size_server_fullname_2 = 0;
	uint32_t length_server_fullname_2 = 0;
	TALLOC_CTX *_mem_save_server_fullname_0;
	TALLOC_CTX *_mem_save_server_fullname_1;
	TALLOC_CTX *_mem_save_is_root_0;
	TALLOC_CTX *_mem_save_ttl_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.servername));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.servername));
		size_servername_0 = ndr_get_array_size(ndr, &r->in.servername);
		length_servername_0 = ndr_get_array_length(ndr, &r->in.servername);
		if (length_servername_0 > size_servername_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_servername_0, length_servername_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_servername_0, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.servername, length_servername_0, sizeof(uint16_t), CH_UTF16));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.server_fullname);
		}
		_mem_save_server_fullname_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.server_fullname, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_fullname));
		if (_ptr_server_fullname) {
			NDR_PULL_ALLOC(ndr, *r->in.server_fullname);
		} else {
			*r->in.server_fullname = NULL;
		}
		if (*r->in.server_fullname) {
			_mem_save_server_fullname_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->in.server_fullname, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->in.server_fullname));
			NDR_CHECK(ndr_pull_array_length(ndr, r->in.server_fullname));
			size_server_fullname_2 = ndr_get_array_size(ndr, r->in.server_fullname);
			length_server_fullname_2 = ndr_get_array_length(ndr, r->in.server_fullname);
			if (length_server_fullname_2 > size_server_fullname_2) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_server_fullname_2, length_server_fullname_2);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_server_fullname_2, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->in.server_fullname, length_server_fullname_2, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_fullname_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_fullname_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.is_root);
		}
		_mem_save_is_root_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.is_root, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, r->in.is_root));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_is_root_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.ttl);
		}
		_mem_save_ttl_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.ttl, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.ttl));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ttl_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.server_fullname);
		*r->out.server_fullname = *r->in.server_fullname;
		NDR_PULL_ALLOC(ndr, r->out.is_root);
		*r->out.is_root = *r->in.is_root;
		NDR_PULL_ALLOC(ndr, r->out.ttl);
		*r->out.ttl = *r->in.ttl;
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.server_fullname);
		}
		_mem_save_server_fullname_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.server_fullname, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_fullname));
		if (_ptr_server_fullname) {
			NDR_PULL_ALLOC(ndr, *r->out.server_fullname);
		} else {
			*r->out.server_fullname = NULL;
		}
		if (*r->out.server_fullname) {
			_mem_save_server_fullname_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.server_fullname, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.server_fullname));
			NDR_CHECK(ndr_pull_array_length(ndr, r->out.server_fullname));
			size_server_fullname_2 = ndr_get_array_size(ndr, r->out.server_fullname);
			length_server_fullname_2 = ndr_get_array_length(ndr, r->out.server_fullname);
			if (length_server_fullname_2 > size_server_fullname_2) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_server_fullname_2, length_server_fullname_2);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_server_fullname_2, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.server_fullname, length_server_fullname_2, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_fullname_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_fullname_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.is_root);
		}
		_mem_save_is_root_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.is_root, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, r->out.is_root));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_is_root_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ttl);
		}
		_mem_save_ttl_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ttl, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.ttl));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ttl_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_GetDcAddress(struct ndr_print *ndr, const char *name, int flags, const struct dfs_GetDcAddress *r)
{
	ndr_print_struct(ndr, name, "dfs_GetDcAddress");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "dfs_GetDcAddress");
		ndr->depth++;
		ndr_print_string(ndr, "servername", r->in.servername);
		ndr_print_ptr(ndr, "server_fullname", r->in.server_fullname);
		ndr->depth++;
		ndr_print_ptr(ndr, "server_fullname", *r->in.server_fullname);
		ndr->depth++;
		if (*r->in.server_fullname) {
			ndr_print_string(ndr, "server_fullname", *r->in.server_fullname);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "is_root", r->in.is_root);
		ndr->depth++;
		ndr_print_uint8(ndr, "is_root", *r->in.is_root);
		ndr->depth--;
		ndr_print_ptr(ndr, "ttl", r->in.ttl);
		ndr->depth++;
		ndr_print_uint32(ndr, "ttl", *r->in.ttl);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "dfs_GetDcAddress");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_fullname", r->out.server_fullname);
		ndr->depth++;
		ndr_print_ptr(ndr, "server_fullname", *r->out.server_fullname);
		ndr->depth++;
		if (*r->out.server_fullname) {
			ndr_print_string(ndr, "server_fullname", *r->out.server_fullname);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "is_root", r->out.is_root);
		ndr->depth++;
		ndr_print_uint8(ndr, "is_root", *r->out.is_root);
		ndr->depth--;
		ndr_print_ptr(ndr, "ttl", r->out.ttl);
		ndr->depth++;
		ndr_print_uint32(ndr, "ttl", *r->out.ttl);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_SetDcAddress(struct ndr_push *ndr, int flags, const struct dfs_SetDcAddress *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.servername, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.servername, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.servername, ndr_charset_length(r->in.servername, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_fullname, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_fullname, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_fullname, ndr_charset_length(r->in.server_fullname, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.ttl));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_SetDcAddress(struct ndr_pull *ndr, int flags, struct dfs_SetDcAddress *r)
{
	uint32_t size_servername_0 = 0;
	uint32_t length_servername_0 = 0;
	uint32_t size_server_fullname_0 = 0;
	uint32_t length_server_fullname_0 = 0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.servername));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.servername));
		size_servername_0 = ndr_get_array_size(ndr, &r->in.servername);
		length_servername_0 = ndr_get_array_length(ndr, &r->in.servername);
		if (length_servername_0 > size_servername_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_servername_0, length_servername_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_servername_0, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.servername, length_servername_0, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_fullname));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_fullname));
		size_server_fullname_0 = ndr_get_array_size(ndr, &r->in.server_fullname);
		length_server_fullname_0 = ndr_get_array_length(ndr, &r->in.server_fullname);
		if (length_server_fullname_0 > size_server_fullname_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_server_fullname_0, length_server_fullname_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_server_fullname_0, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_fullname, length_server_fullname_0, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.ttl));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_SetDcAddress(struct ndr_print *ndr, const char *name, int flags, const struct dfs_SetDcAddress *r)
{
	ndr_print_struct(ndr, name, "dfs_SetDcAddress");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "dfs_SetDcAddress");
		ndr->depth++;
		ndr_print_string(ndr, "servername", r->in.servername);
		ndr_print_string(ndr, "server_fullname", r->in.server_fullname);
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr_print_uint32(ndr, "ttl", r->in.ttl);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "dfs_SetDcAddress");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_FlushFtTable(struct ndr_push *ndr, int flags, const struct dfs_FlushFtTable *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.servername, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.servername, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.servername, ndr_charset_length(r->in.servername, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.rootshare, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.rootshare, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.rootshare, ndr_charset_length(r->in.rootshare, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_FlushFtTable(struct ndr_pull *ndr, int flags, struct dfs_FlushFtTable *r)
{
	uint32_t size_servername_0 = 0;
	uint32_t length_servername_0 = 0;
	uint32_t size_rootshare_0 = 0;
	uint32_t length_rootshare_0 = 0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.servername));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.servername));
		size_servername_0 = ndr_get_array_size(ndr, &r->in.servername);
		length_servername_0 = ndr_get_array_length(ndr, &r->in.servername);
		if (length_servername_0 > size_servername_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_servername_0, length_servername_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_servername_0, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.servername, length_servername_0, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.rootshare));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.rootshare));
		size_rootshare_0 = ndr_get_array_size(ndr, &r->in.rootshare);
		length_rootshare_0 = ndr_get_array_length(ndr, &r->in.rootshare);
		if (length_rootshare_0 > size_rootshare_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_rootshare_0, length_rootshare_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_rootshare_0, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.rootshare, length_rootshare_0, sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_FlushFtTable(struct ndr_print *ndr, const char *name, int flags, const struct dfs_FlushFtTable *r)
{
	ndr_print_struct(ndr, name, "dfs_FlushFtTable");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "dfs_FlushFtTable");
		ndr->depth++;
		ndr_print_string(ndr, "servername", r->in.servername);
		ndr_print_string(ndr, "rootshare", r->in.rootshare);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "dfs_FlushFtTable");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_Add2(struct ndr_push *ndr, int flags, const struct dfs_Add2 *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_Add2(struct ndr_pull *ndr, int flags, struct dfs_Add2 *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_Add2(struct ndr_print *ndr, const char *name, int flags, const struct dfs_Add2 *r)
{
	ndr_print_struct(ndr, name, "dfs_Add2");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "dfs_Add2");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "dfs_Add2");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_Remove2(struct ndr_push *ndr, int flags, const struct dfs_Remove2 *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_Remove2(struct ndr_pull *ndr, int flags, struct dfs_Remove2 *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_Remove2(struct ndr_print *ndr, const char *name, int flags, const struct dfs_Remove2 *r)
{
	ndr_print_struct(ndr, name, "dfs_Remove2");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "dfs_Remove2");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "dfs_Remove2");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dfs_EnumEx(struct ndr_push *ndr, int flags, const struct dfs_EnumEx *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.dfs_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.dfs_name, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.dfs_name, ndr_charset_length(r->in.dfs_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.bufsize));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.info));
		if (r->in.info) {
			NDR_CHECK(ndr_push_dfs_EnumStruct(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.total));
		if (r->in.total) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.total));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.info));
		if (r->out.info) {
			NDR_CHECK(ndr_push_dfs_EnumStruct(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.total));
		if (r->out.total) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.total));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dfs_EnumEx(struct ndr_pull *ndr, int flags, struct dfs_EnumEx *r)
{
	uint32_t size_dfs_name_0 = 0;
	uint32_t length_dfs_name_0 = 0;
	uint32_t _ptr_info;
	uint32_t _ptr_total;
	TALLOC_CTX *_mem_save_info_0;
	TALLOC_CTX *_mem_save_total_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.dfs_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.dfs_name));
		size_dfs_name_0 = ndr_get_array_size(ndr, &r->in.dfs_name);
		length_dfs_name_0 = ndr_get_array_length(ndr, &r->in.dfs_name);
		if (length_dfs_name_0 > size_dfs_name_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_dfs_name_0, length_dfs_name_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_dfs_name_0, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.dfs_name, length_dfs_name_0, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.bufsize));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, r->in.info);
		} else {
			r->in.info = NULL;
		}
		if (r->in.info) {
			_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.info, 0);
			NDR_CHECK(ndr_pull_dfs_EnumStruct(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_total));
		if (_ptr_total) {
			NDR_PULL_ALLOC(ndr, r->in.total);
		} else {
			r->in.total = NULL;
		}
		if (r->in.total) {
			_mem_save_total_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.total, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.total));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_total_0, 0);
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		} else {
			r->out.info = NULL;
		}
		if (r->out.info) {
			_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.info, 0);
			NDR_CHECK(ndr_pull_dfs_EnumStruct(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_total));
		if (_ptr_total) {
			NDR_PULL_ALLOC(ndr, r->out.total);
		} else {
			r->out.total = NULL;
		}
		if (r->out.total) {
			_mem_save_total_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.total, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.total));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_total_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_EnumEx(struct ndr_print *ndr, const char *name, int flags, const struct dfs_EnumEx *r)
{
	ndr_print_struct(ndr, name, "dfs_EnumEx");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "dfs_EnumEx");
		ndr->depth++;
		ndr_print_string(ndr, "dfs_name", r->in.dfs_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_uint32(ndr, "bufsize", r->in.bufsize);
		ndr_print_ptr(ndr, "info", r->in.info);
		ndr->depth++;
		if (r->in.info) {
			ndr_print_dfs_EnumStruct(ndr, "info", r->in.info);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "total", r->in.total);
		ndr->depth++;
		if (r->in.total) {
			ndr_print_uint32(ndr, "total", *r->in.total);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "dfs_EnumEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		if (r->out.info) {
			ndr_print_dfs_EnumStruct(ndr, "info", r->out.info);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "total", r->out.total);
		ndr->depth++;
		if (r->out.total) {
			ndr_print_uint32(ndr, "total", *r->out.total);
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_SetInfo2(struct ndr_push *ndr, int flags, const struct dfs_SetInfo2 *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_SetInfo2(struct ndr_pull *ndr, int flags, struct dfs_SetInfo2 *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_SetInfo2(struct ndr_print *ndr, const char *name, int flags, const struct dfs_SetInfo2 *r)
{
	ndr_print_struct(ndr, name, "dfs_SetInfo2");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "dfs_SetInfo2");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "dfs_SetInfo2");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct ndr_interface_call netdfs_calls[] = {
	{
		"dfs_GetManagerVersion",
		sizeof(struct dfs_GetManagerVersion),
		(ndr_push_flags_fn_t) ndr_push_dfs_GetManagerVersion,
		(ndr_pull_flags_fn_t) ndr_pull_dfs_GetManagerVersion,
		(ndr_print_function_t) ndr_print_dfs_GetManagerVersion,
		false,
	},
	{
		"dfs_Add",
		sizeof(struct dfs_Add),
		(ndr_push_flags_fn_t) ndr_push_dfs_Add,
		(ndr_pull_flags_fn_t) ndr_pull_dfs_Add,
		(ndr_print_function_t) ndr_print_dfs_Add,
		false,
	},
	{
		"dfs_Remove",
		sizeof(struct dfs_Remove),
		(ndr_push_flags_fn_t) ndr_push_dfs_Remove,
		(ndr_pull_flags_fn_t) ndr_pull_dfs_Remove,
		(ndr_print_function_t) ndr_print_dfs_Remove,
		false,
	},
	{
		"dfs_SetInfo",
		sizeof(struct dfs_SetInfo),
		(ndr_push_flags_fn_t) ndr_push_dfs_SetInfo,
		(ndr_pull_flags_fn_t) ndr_pull_dfs_SetInfo,
		(ndr_print_function_t) ndr_print_dfs_SetInfo,
		false,
	},
	{
		"dfs_GetInfo",
		sizeof(struct dfs_GetInfo),
		(ndr_push_flags_fn_t) ndr_push_dfs_GetInfo,
		(ndr_pull_flags_fn_t) ndr_pull_dfs_GetInfo,
		(ndr_print_function_t) ndr_print_dfs_GetInfo,
		false,
	},
	{
		"dfs_Enum",
		sizeof(struct dfs_Enum),
		(ndr_push_flags_fn_t) ndr_push_dfs_Enum,
		(ndr_pull_flags_fn_t) ndr_pull_dfs_Enum,
		(ndr_print_function_t) ndr_print_dfs_Enum,
		false,
	},
	{
		"dfs_Rename",
		sizeof(struct dfs_Rename),
		(ndr_push_flags_fn_t) ndr_push_dfs_Rename,
		(ndr_pull_flags_fn_t) ndr_pull_dfs_Rename,
		(ndr_print_function_t) ndr_print_dfs_Rename,
		false,
	},
	{
		"dfs_Move",
		sizeof(struct dfs_Move),
		(ndr_push_flags_fn_t) ndr_push_dfs_Move,
		(ndr_pull_flags_fn_t) ndr_pull_dfs_Move,
		(ndr_print_function_t) ndr_print_dfs_Move,
		false,
	},
	{
		"dfs_ManagerGetConfigInfo",
		sizeof(struct dfs_ManagerGetConfigInfo),
		(ndr_push_flags_fn_t) ndr_push_dfs_ManagerGetConfigInfo,
		(ndr_pull_flags_fn_t) ndr_pull_dfs_ManagerGetConfigInfo,
		(ndr_print_function_t) ndr_print_dfs_ManagerGetConfigInfo,
		false,
	},
	{
		"dfs_ManagerSendSiteInfo",
		sizeof(struct dfs_ManagerSendSiteInfo),
		(ndr_push_flags_fn_t) ndr_push_dfs_ManagerSendSiteInfo,
		(ndr_pull_flags_fn_t) ndr_pull_dfs_ManagerSendSiteInfo,
		(ndr_print_function_t) ndr_print_dfs_ManagerSendSiteInfo,
		false,
	},
	{
		"dfs_AddFtRoot",
		sizeof(struct dfs_AddFtRoot),
		(ndr_push_flags_fn_t) ndr_push_dfs_AddFtRoot,
		(ndr_pull_flags_fn_t) ndr_pull_dfs_AddFtRoot,
		(ndr_print_function_t) ndr_print_dfs_AddFtRoot,
		false,
	},
	{
		"dfs_RemoveFtRoot",
		sizeof(struct dfs_RemoveFtRoot),
		(ndr_push_flags_fn_t) ndr_push_dfs_RemoveFtRoot,
		(ndr_pull_flags_fn_t) ndr_pull_dfs_RemoveFtRoot,
		(ndr_print_function_t) ndr_print_dfs_RemoveFtRoot,
		false,
	},
	{
		"dfs_AddStdRoot",
		sizeof(struct dfs_AddStdRoot),
		(ndr_push_flags_fn_t) ndr_push_dfs_AddStdRoot,
		(ndr_pull_flags_fn_t) ndr_pull_dfs_AddStdRoot,
		(ndr_print_function_t) ndr_print_dfs_AddStdRoot,
		false,
	},
	{
		"dfs_RemoveStdRoot",
		sizeof(struct dfs_RemoveStdRoot),
		(ndr_push_flags_fn_t) ndr_push_dfs_RemoveStdRoot,
		(ndr_pull_flags_fn_t) ndr_pull_dfs_RemoveStdRoot,
		(ndr_print_function_t) ndr_print_dfs_RemoveStdRoot,
		false,
	},
	{
		"dfs_ManagerInitialize",
		sizeof(struct dfs_ManagerInitialize),
		(ndr_push_flags_fn_t) ndr_push_dfs_ManagerInitialize,
		(ndr_pull_flags_fn_t) ndr_pull_dfs_ManagerInitialize,
		(ndr_print_function_t) ndr_print_dfs_ManagerInitialize,
		false,
	},
	{
		"dfs_AddStdRootForced",
		sizeof(struct dfs_AddStdRootForced),
		(ndr_push_flags_fn_t) ndr_push_dfs_AddStdRootForced,
		(ndr_pull_flags_fn_t) ndr_pull_dfs_AddStdRootForced,
		(ndr_print_function_t) ndr_print_dfs_AddStdRootForced,
		false,
	},
	{
		"dfs_GetDcAddress",
		sizeof(struct dfs_GetDcAddress),
		(ndr_push_flags_fn_t) ndr_push_dfs_GetDcAddress,
		(ndr_pull_flags_fn_t) ndr_pull_dfs_GetDcAddress,
		(ndr_print_function_t) ndr_print_dfs_GetDcAddress,
		false,
	},
	{
		"dfs_SetDcAddress",
		sizeof(struct dfs_SetDcAddress),
		(ndr_push_flags_fn_t) ndr_push_dfs_SetDcAddress,
		(ndr_pull_flags_fn_t) ndr_pull_dfs_SetDcAddress,
		(ndr_print_function_t) ndr_print_dfs_SetDcAddress,
		false,
	},
	{
		"dfs_FlushFtTable",
		sizeof(struct dfs_FlushFtTable),
		(ndr_push_flags_fn_t) ndr_push_dfs_FlushFtTable,
		(ndr_pull_flags_fn_t) ndr_pull_dfs_FlushFtTable,
		(ndr_print_function_t) ndr_print_dfs_FlushFtTable,
		false,
	},
	{
		"dfs_Add2",
		sizeof(struct dfs_Add2),
		(ndr_push_flags_fn_t) ndr_push_dfs_Add2,
		(ndr_pull_flags_fn_t) ndr_pull_dfs_Add2,
		(ndr_print_function_t) ndr_print_dfs_Add2,
		false,
	},
	{
		"dfs_Remove2",
		sizeof(struct dfs_Remove2),
		(ndr_push_flags_fn_t) ndr_push_dfs_Remove2,
		(ndr_pull_flags_fn_t) ndr_pull_dfs_Remove2,
		(ndr_print_function_t) ndr_print_dfs_Remove2,
		false,
	},
	{
		"dfs_EnumEx",
		sizeof(struct dfs_EnumEx),
		(ndr_push_flags_fn_t) ndr_push_dfs_EnumEx,
		(ndr_pull_flags_fn_t) ndr_pull_dfs_EnumEx,
		(ndr_print_function_t) ndr_print_dfs_EnumEx,
		false,
	},
	{
		"dfs_SetInfo2",
		sizeof(struct dfs_SetInfo2),
		(ndr_push_flags_fn_t) ndr_push_dfs_SetInfo2,
		(ndr_pull_flags_fn_t) ndr_pull_dfs_SetInfo2,
		(ndr_print_function_t) ndr_print_dfs_SetInfo2,
		false,
	},
	{ NULL, 0, NULL, NULL, NULL, false }
};

static const char * const netdfs_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\netdfs]", 
	"ncacn_ip_tcp:", 
	"ncalrpc:", 
};

static const struct ndr_interface_string_array netdfs_endpoints = {
	.count	= 3,
	.names	= netdfs_endpoint_strings
};

static const char * const netdfs_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array netdfs_authservices = {
	.count	= 1,
	.names	= netdfs_authservice_strings
};


const struct ndr_interface_table ndr_table_netdfs = {
	.name		= "netdfs",
	.syntax_id	= {
		{0x4fc742e0,0x4a10,0x11cf,{0x82,0x73},{0x00,0xaa,0x00,0x4a,0xe6,0x73}},
		NDR_NETDFS_VERSION
	},
	.helpstring	= NDR_NETDFS_HELPSTRING,
	.num_calls	= 23,
	.calls		= netdfs_calls,
	.endpoints	= &netdfs_endpoints,
	.authservices	= &netdfs_authservices
};

