/* header auto-generated by pidl */

#include <stdint.h>

#define LIBNETAPI_LOCAL_SERVER(x) (!x || is_myname_or_ipaddr(x))
#ifndef MAXSUBAUTHS
#define MAXSUBAUTHS 15 /* max sub authorities in a SID */
#endif
#ifndef _HEADER_libnetapi
#define _HEADER_libnetapi

#define ERROR_MORE_DATA	( 234L )
#define USER_PRIV_GUEST	( 0 )
#define USER_PRIV_USER	( 1 )
#define USER_PRIV_ADMIN	( 2 )
#define AF_OP_PRINT	( 0x1 )
#define AF_OP_COMM	( 0x2 )
#define AF_OP_SERVER	( 0x4 )
#define AF_OP_ACCOUNTS	( 0x8 )
#define AF_SETTABLE_BITS	( (AF_OP_PRINT|AF_OP_COMM|AF_OP_SERVER|AF_OP_ACCOUNTS) )
#define USER_MAXSTORAGE_UNLIMITED	( (uint32_t)-1L )
#define ENCRYPTED_PWLEN	( 16 )
#define FILTER_TEMP_DUPLICATE_ACCOUNT	( 0x0001 )
#define FILTER_NORMAL_ACCOUNT	( 0x0002 )
#define FILTER_INTERDOMAIN_TRUST_ACCOUNT	( 0x0008 )
#define FILTER_WORKSTATION_TRUST_ACCOUNT	( 0x0010 )
#define FILTER_SERVER_TRUST_ACCOUNT	( 0x0020 )
#define LG_INCLUDE_INDIRECT	( 0x0001 )
#define TIMEQ_FOREVER	( (uint32_t)-1L )
#define CSC_MASK	( 0x30 )
enum NET_API_STATUS
#ifndef USE_UINT_ENUMS
 {
	NERR_Success=0
}
#else
 { __donnot_use_enum_NET_API_STATUS=0x7FFFFFFF}
#define NERR_Success ( 0 )
#endif
;

struct domsid {
	uint8_t sid_rev_num;
	uint8_t num_auths;
	uint8_t id_auth[6];
	uint32_t *sub_auths;
};

/* bitmap NetJoinFlags */
#define NETSETUP_JOIN_DOMAIN ( 0x00000001 )
#define NETSETUP_ACCT_CREATE ( 0x00000002 )
#define NETSETUP_ACCT_DELETE ( 0x00000004 )
#define NETSETUP_WIN9X_UPGRADE ( 0x00000010 )
#define NETSETUP_DOMAIN_JOIN_IF_JOINED ( 0x00000020 )
#define NETSETUP_JOIN_UNSECURE ( 0x00000040 )
#define NETSETUP_MACHINE_PWD_PASSED ( 0x00000080 )
#define NETSETUP_DEFER_SPN_SET ( 0x00000100 )
#define NETSETUP_JOIN_DC_ACCOUNT ( 0x00000200 )
#define NETSETUP_JOIN_WITH_NEW_NAME ( 0x00000400 )
#define NETSETUP_INSTALL_INVOCATION ( 0x00040000 )
#define NETSETUP_IGNORE_UNSUPPORTED_FLAGS ( 0x10000000 )

enum NETSETUP_JOIN_STATUS
#ifndef USE_UINT_ENUMS
 {
	NetSetupUnknownStatus=0,
	NetSetupUnjoined=1,
	NetSetupWorkgroupName=2,
	NetSetupDomainName=3
}
#else
 { __donnot_use_enum_NETSETUP_JOIN_STATUS=0x7FFFFFFF}
#define NetSetupUnknownStatus ( 0 )
#define NetSetupUnjoined ( 1 )
#define NetSetupWorkgroupName ( 2 )
#define NetSetupDomainName ( 3 )
#endif
;

struct SERVER_INFO_100 {
	uint32_t sv100_platform_id;
	const char * sv100_name;
};

struct SERVER_INFO_101 {
	uint32_t sv101_platform_id;
	const char * sv101_name;
	uint32_t sv101_version_major;
	uint32_t sv101_version_minor;
	uint32_t sv101_type;
	const char * sv101_comment;
};

struct SERVER_INFO_102 {
	uint32_t sv102_platform_id;
	const char * sv102_name;
	uint32_t sv102_version_major;
	uint32_t sv102_version_minor;
	uint32_t sv102_type;
	const char * sv102_comment;
	uint32_t sv102_users;
	uint32_t sv102_disc;
	uint8_t sv102_hidden;
	uint32_t sv102_announce;
	uint32_t sv102_anndelta;
	uint32_t sv102_licenses;
	const char * sv102_userpath;
};

struct SERVER_INFO_1005 {
	const char * sv1005_comment;
};

struct DOMAIN_CONTROLLER_INFO {
	const char * domain_controller_name;
	const char * domain_controller_address;
	uint32_t domain_controller_address_type;
	struct GUID domain_guid;
	const char * domain_name;
	const char * dns_forest_name;
	uint32_t flags;
	const char * dc_site_name;
	const char * client_site_name;
};

struct USER_INFO_0 {
	const char * usri0_name;
};

struct USER_INFO_1 {
	const char * usri1_name;
	const char * usri1_password;
	uint32_t usri1_password_age;
	uint32_t usri1_priv;
	const char * usri1_home_dir;
	const char * usri1_comment;
	uint32_t usri1_flags;
	const char * usri1_script_path;
};

struct USER_INFO_2 {
	const char * usri2_name;
	const char * usri2_password;
	uint32_t usri2_password_age;
	uint32_t usri2_priv;
	const char * usri2_home_dir;
	const char * usri2_comment;
	uint32_t usri2_flags;
	const char * usri2_script_path;
	uint32_t usri2_auth_flags;
	const char * usri2_full_name;
	const char * usri2_usr_comment;
	const char * usri2_parms;
	const char * usri2_workstations;
	uint32_t usri2_last_logon;
	uint32_t usri2_last_logoff;
	uint32_t usri2_acct_expires;
	uint32_t usri2_max_storage;
	uint32_t usri2_units_per_week;
	uint8_t *usri2_logon_hours;/* [unique] */
	uint32_t usri2_bad_pw_count;
	uint32_t usri2_num_logons;
	const char * usri2_logon_server;
	uint32_t usri2_country_code;
	uint32_t usri2_code_page;
};

struct USER_INFO_3 {
	const char * usri3_name;
	uint32_t usri3_password_age;
	uint32_t usri3_priv;
	const char * usri3_home_dir;
	const char * usri3_comment;
	uint32_t usri3_flags;
	const char * usri3_script_path;
	uint32_t usri3_auth_flags;
	const char * usri3_full_name;
	const char * usri3_usr_comment;
	const char * usri3_parms;
	const char * usri3_workstations;
	uint32_t usri3_last_logon;
	uint32_t usri3_last_logoff;
	uint32_t usri3_acct_expires;
	uint32_t usri3_max_storage;
	uint32_t usri3_units_per_week;
	uint8_t *usri3_logon_hours;/* [unique] */
	uint32_t usri3_bad_pw_count;
	uint32_t usri3_num_logons;
	const char * usri3_logon_server;
	uint32_t usri3_country_code;
	uint32_t usri3_code_page;
	uint32_t usri3_user_id;
	uint32_t usri3_primary_group_id;
	const char * usri3_profile;
	const char * usri3_home_dir_drive;
	uint32_t usri3_password_expired;
};

struct USER_INFO_4 {
	const char * usri4_name;
	const char * usri4_password;
	uint32_t usri4_password_age;
	uint32_t usri4_priv;
	const char * usri4_home_dir;
	const char * usri4_comment;
	uint32_t usri4_flags;
	const char * usri4_script_path;
	uint32_t usri4_auth_flags;
	const char * usri4_full_name;
	const char * usri4_usr_comment;
	const char * usri4_parms;
	const char * usri4_workstations;
	uint32_t usri4_last_logon;
	uint32_t usri4_last_logoff;
	uint32_t usri4_acct_expires;
	uint32_t usri4_max_storage;
	uint32_t usri4_units_per_week;
	uint8_t *usri4_logon_hours;/* [unique] */
	uint32_t usri4_bad_pw_count;
	uint32_t usri4_num_logons;
	const char * usri4_logon_server;
	uint32_t usri4_country_code;
	uint32_t usri4_code_page;
	struct domsid *usri4_user_sid;/* [unique] */
	uint32_t usri4_primary_group_id;
	const char * usri4_profile;
	const char * usri4_home_dir_drive;
	uint32_t usri4_password_expired;
};

struct USER_INFO_10 {
	const char * usri10_name;
	const char * usri10_comment;
	const char * usri10_usr_comment;
	const char * usri10_full_name;
};

struct USER_INFO_11 {
	const char * usri11_name;
	const char * usri11_comment;
	const char * usri11_usr_comment;
	const char * usri11_full_name;
	uint32_t usri11_priv;
	uint32_t usri11_auth_flags;
	uint32_t usri11_password_age;
	const char * usri11_home_dir;
	const char * usri11_parms;
	uint32_t usri11_last_logon;
	uint32_t usri11_last_logoff;
	uint32_t usri11_bad_pw_count;
	uint32_t usri11_num_logons;
	const char * usri11_logon_server;
	uint32_t usri11_country_code;
	const char * usri11_workstations;
	uint32_t usri11_max_storage;
	uint32_t usri11_units_per_week;
	uint8_t *usri11_logon_hours;/* [unique] */
	uint32_t usri11_code_page;
};

struct USER_INFO_20 {
	const char * usri20_name;
	const char * usri20_full_name;
	const char * usri20_comment;
	uint32_t usri20_flags;
	uint32_t usri20_user_id;
};

struct USER_INFO_21 {
	uint8_t *usri21_password;
};

struct USER_INFO_22 {
	const char * usri22_name;
	uint8_t *usri22_password;
	uint32_t usri22_password_age;
	uint32_t usri22_priv;
	const char * usri22_home_dir;
	const char * usri22_comment;
	uint32_t usri22_flags;
	uint32_t usri22_script_path;
	uint32_t usri22_auth_flags;
	const char * usri22_full_name;
	const char * usri22_usr_comment;
	const char * usri22_parms;
	const char * usri22_workstations;
	uint32_t usri22_last_logon;
	uint32_t usri22_last_logoff;
	uint32_t usri22_acct_expires;
	uint32_t usri22_max_storage;
	uint32_t usri22_units_per_week;
	uint8_t *usri22_logon_hours;/* [unique] */
	uint32_t usri22_bad_pw_count;
	uint32_t usri22_num_logons;
	const char * usri22_logon_server;
	uint32_t usri22_country_code;
	uint32_t usri22_code_page;
};

struct USER_INFO_23 {
	const char * usri23_name;
	const char * usri23_full_name;
	const char * usri23_comment;
	uint32_t usri23_flags;
	struct domsid *usri23_user_sid;/* [unique] */
};

struct USER_INFO_1003 {
	const char * usri1003_password;
};

struct USER_INFO_1005 {
	uint32_t usri1005_priv;
};

struct USER_INFO_1006 {
	const char * usri1006_home_dir;
};

struct USER_INFO_1007 {
	const char * usri1007_comment;
};

struct USER_INFO_1008 {
	uint32_t usri1008_flags;
};

struct USER_INFO_1009 {
	const char * usri1009_script_path;
};

struct USER_INFO_1010 {
	uint32_t usri1010_auth_flags;
};

struct USER_INFO_1011 {
	const char * usri1011_full_name;
};

struct USER_INFO_1012 {
	const char * usri1012_usr_comment;
};

struct USER_INFO_1013 {
	const char * usri1013_parms;
};

struct USER_INFO_1014 {
	const char * usri1014_workstations;
};

struct USER_INFO_1017 {
	uint32_t usri1017_acct_expires;
};

struct USER_INFO_1018 {
	uint32_t usri1018_max_storage;
};

struct USER_INFO_1020 {
	uint32_t usri1020_units_per_week;
	uint8_t *usri1020_logon_hours;/* [unique] */
};

struct USER_INFO_1023 {
	const char * usri1023_logon_server;
};

struct USER_INFO_1024 {
	uint32_t usri1024_country_code;
};

struct USER_INFO_1025 {
	uint32_t usri1025_code_page;
};

struct USER_INFO_1051 {
	uint32_t usri1051_primary_group_id;
};

struct USER_INFO_1052 {
	const char * usri1052_profile;
};

struct USER_INFO_1053 {
	const char * usri1053_home_dir_drive;
};

struct USER_INFO_X {
	const char * usriX_name;
	const char * usriX_password;
	uint32_t usriX_password_age;
	uint32_t usriX_priv;
	const char * usriX_home_dir;
	const char * usriX_comment;
	uint32_t usriX_flags;
	const char * usriX_script_path;
	uint32_t usriX_auth_flags;
	const char * usriX_full_name;
	const char * usriX_usr_comment;
	const char * usriX_parms;
	const char * usriX_workstations;
	uint32_t usriX_last_logon;
	uint32_t usriX_last_logoff;
	uint32_t usriX_acct_expires;
	uint32_t usriX_max_storage;
	uint32_t usriX_units_per_week;
	uint8_t *usriX_logon_hours;/* [unique] */
	uint32_t usriX_bad_pw_count;
	uint32_t usriX_num_logons;
	const char * usriX_logon_server;
	uint32_t usriX_country_code;
	uint32_t usriX_code_page;
	const char * usriX_profile;
	const char * usriX_home_dir_drive;
	uint32_t usriX_user_id;
	uint32_t usriX_primary_group_id;
	uint32_t usriX_password_expired;
};

struct GROUP_USERS_INFO_0 {
	const char * grui0_name;
};

struct GROUP_USERS_INFO_1 {
	const char * grui1_name;
	uint32_t grui1_attributes;
};

struct LOCALGROUP_USERS_INFO_0 {
	const char * lgrui0_name;
};

struct USER_MODALS_INFO_0 {
	uint32_t usrmod0_min_passwd_len;
	uint32_t usrmod0_max_passwd_age;
	uint32_t usrmod0_min_passwd_age;
	uint32_t usrmod0_force_logoff;
	uint32_t usrmod0_password_hist_len;
};

struct USER_MODALS_INFO_1 {
	uint32_t usrmod1_role;
	const char * usrmod1_primary;
};

struct USER_MODALS_INFO_2 {
	const char * usrmod2_domain_name;
	struct domsid *usrmod2_domain_id;/* [unique] */
};

struct USER_MODALS_INFO_3 {
	uint32_t usrmod3_lockout_duration;
	uint32_t usrmod3_lockout_observation_window;
	uint32_t usrmod3_lockout_threshold;
};

struct USER_MODALS_INFO_1001 {
	uint32_t usrmod1001_min_passwd_len;
};

struct USER_MODALS_INFO_1002 {
	uint32_t usrmod1002_max_passwd_age;
};

struct USER_MODALS_INFO_1003 {
	uint32_t usrmod1003_min_passwd_age;
};

struct USER_MODALS_INFO_1004 {
	uint32_t usrmod1004_force_logoff;
};

struct USER_MODALS_INFO_1005 {
	uint32_t usrmod1005_password_hist_len;
};

struct USER_MODALS_INFO_1006 {
	uint32_t usrmod1006_role;
};

struct USER_MODALS_INFO_1007 {
	const char * usrmod1007_primary;
};

struct NET_DISPLAY_USER {
	const char * usri1_name;
	const char * usri1_comment;
	uint32_t usri1_flags;
	const char * usri1_full_name;
	uint32_t usri1_user_id;
	uint32_t usri1_next_index;
};

struct NET_DISPLAY_MACHINE {
	const char * usri2_name;
	const char * usri2_comment;
	uint32_t usri2_flags;
	uint32_t usri2_user_id;
	uint32_t usri2_next_index;
};

struct NET_DISPLAY_GROUP {
	const char * grpi3_name;
	const char * grpi3_comment;
	uint32_t grpi3_group_id;
	uint32_t grpi3_attributes;
	uint32_t grpi3_next_index;
};

struct GROUP_INFO_0 {
	const char * grpi0_name;
};

struct GROUP_INFO_1 {
	const char * grpi1_name;
	const char * grpi1_comment;
};

struct GROUP_INFO_2 {
	const char * grpi2_name;
	const char * grpi2_comment;
	uint32_t grpi2_group_id;
	uint32_t grpi2_attributes;
};

struct GROUP_INFO_3 {
	const char * grpi3_name;
	const char * grpi3_comment;
	struct domsid *grpi3_group_sid;/* [unique] */
	uint32_t grpi3_attributes;
};

struct GROUP_INFO_1002 {
	const char * grpi1002_comment;
};

struct GROUP_INFO_1005 {
	uint32_t grpi1005_attributes;
};

struct LOCALGROUP_INFO_0 {
	const char * lgrpi0_name;
};

struct LOCALGROUP_INFO_1 {
	const char * lgrpi1_name;
	const char * lgrpi1_comment;
};

struct LOCALGROUP_INFO_1002 {
	const char * lgrpi1002_comment;
};

enum SID_NAME_USE
#ifndef USE_UINT_ENUMS
 {
	SidTypeUser=1,
	SidTypeGroup=2,
	SidTypeDomain=3,
	SidTypeAlias=4,
	SidTypeWellKnownGroup=5,
	SidTypeDeletedAccount=6,
	SidTypeInvalid=7,
	SidTypeUnknown=8,
	SidTypeComputer=9,
	SidTypeLabel=10
}
#else
 { __donnot_use_enum_SID_NAME_USE=0x7FFFFFFF}
#define SidTypeUser ( 1 )
#define SidTypeGroup ( 2 )
#define SidTypeDomain ( 3 )
#define SidTypeAlias ( 4 )
#define SidTypeWellKnownGroup ( 5 )
#define SidTypeDeletedAccount ( 6 )
#define SidTypeInvalid ( 7 )
#define SidTypeUnknown ( 8 )
#define SidTypeComputer ( 9 )
#define SidTypeLabel ( 10 )
#endif
;

struct LOCALGROUP_MEMBERS_INFO_0 {
	struct domsid *lgrmi0_sid;/* [unique] */
};

struct LOCALGROUP_MEMBERS_INFO_1 {
	struct domsid *lgrmi1_sid;/* [unique] */
	enum SID_NAME_USE lgrmi1_sidusage;
	const char * lgrmi1_name;
};

struct LOCALGROUP_MEMBERS_INFO_2 {
	struct domsid *lgrmi2_sid;/* [unique] */
	enum SID_NAME_USE lgrmi2_sidusage;
	const char * lgrmi2_domainandname;
};

struct LOCALGROUP_MEMBERS_INFO_3 {
	const char * lgrmi3_domainandname;
};

struct TIME_OF_DAY_INFO {
	uint32_t tod_elapsedt;
	uint32_t tod_msecs;
	uint32_t tod_hours;
	uint32_t tod_mins;
	uint32_t tod_secs;
	uint32_t tod_hunds;
	int32_t tod_timezone;
	uint32_t tod_tinterval;
	uint32_t tod_day;
	uint32_t tod_month;
	uint32_t tod_year;
	uint32_t tod_weekday;
};

struct SHARE_INFO_0 {
	const char * shi0_netname;
};

struct SHARE_INFO_1 {
	const char * shi1_netname;
	uint32_t shi1_type;
	const char * shi1_remark;
};

struct SHARE_INFO_2 {
	const char * shi2_netname;
	uint32_t shi2_type;
	const char * shi2_remark;
	uint32_t shi2_permissions;
	uint32_t shi2_max_uses;
	uint32_t shi2_current_uses;
	const char * shi2_path;
	const char * shi2_passwd;
};

struct SHARE_INFO_501 {
	const char * shi501_netname;
	uint32_t shi501_type;
	const char * shi501_remark;
	uint32_t shi501_flags;
};

struct SHARE_INFO_1004 {
	const char * shi1004_remark;
};

/* bitmap SHARE_INFO_1005_FLAGS */
#define SHI1005_FLAGS_DFS ( 0x01 )
#define SHI1005_FLAGS_DFS_ROOT ( 0x02 )
#define CSC_CACHE_MANUAL_REINT ( 0x00 )
#define CSC_CACHE_AUTO_REINT ( 0x10 )
#define CSC_CACHE_VDO ( 0x20 )
#define CSC_CACHE_NONE ( 0x30 )
#define SHI1005_FLAGS_RESTRICT_EXCLUSIVE_OPENS ( 0x0100 )
#define SHI1005_FLAGS_FORCE_SHARED_DELETE ( 0x0200 )
#define SHI1005_FLAGS_ALLOW_NAMESPACE_CACHING ( 0x0400 )
#define SHI1005_FLAGS_ACCESS_BASED_DIRECTORY_ENUM ( 0x0800 )

struct SHARE_INFO_1005 {
	uint32_t shi1005_flags;
};

struct SHARE_INFO_1006 {
	uint32_t shi1006_max_uses;
};

struct FILE_INFO_2 {
	uint32_t fi2_id;
};

struct FILE_INFO_3 {
	uint32_t fi3_id;
	uint32_t fi3_permissions;
	uint32_t fi3_num_locks;
	const char * fi3_pathname;
	const char * fi3_username;
};


struct NetJoinDomain {
	struct {
		const char * server;/* [unique] */
		const char * domain;/* [ref] */
		const char * account_ou;/* [unique] */
		const char * account;/* [unique] */
		const char * password;/* [unique] */
		uint32_t join_flags;
	} in;

	struct {
		enum NET_API_STATUS result;
	} out;

};


struct NetUnjoinDomain {
	struct {
		const char * server_name;/* [unique] */
		const char * account;/* [unique] */
		const char * password;/* [unique] */
		uint32_t unjoin_flags;
	} in;

	struct {
		enum NET_API_STATUS result;
	} out;

};


struct NetGetJoinInformation {
	struct {
		const char * server_name;/* [unique] */
	} in;

	struct {
		const char * *name_buffer;/* [ref] */
		uint16_t *name_type;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetGetJoinableOUs {
	struct {
		const char * server_name;/* [unique] */
		const char * domain;/* [ref] */
		const char * account;/* [unique] */
		const char * password;/* [unique] */
	} in;

	struct {
		uint32_t *ou_count;/* [ref] */
		const char * **ous;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetRenameMachineInDomain {
	struct {
		const char * server_name;
		const char * new_machine_name;
		const char * account;
		const char * password;
		uint32_t rename_options;
	} in;

	struct {
		enum NET_API_STATUS result;
	} out;

};


struct NetServerGetInfo {
	struct {
		const char * server_name;/* [unique] */
		uint32_t level;
	} in;

	struct {
		uint8_t **buffer;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetServerSetInfo {
	struct {
		const char * server_name;/* [unique] */
		uint32_t level;
		uint8_t *buffer;/* [ref] */
	} in;

	struct {
		uint32_t *parm_error;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetGetDCName {
	struct {
		const char * server_name;/* [unique] */
		const char * domain_name;/* [unique] */
	} in;

	struct {
		uint8_t **buffer;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetGetAnyDCName {
	struct {
		const char * server_name;/* [unique] */
		const char * domain_name;/* [unique] */
	} in;

	struct {
		uint8_t **buffer;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct DsGetDcName {
	struct {
		const char * server_name;/* [unique] */
		const char * domain_name;/* [ref] */
		struct GUID *domain_guid;/* [unique] */
		const char * site_name;/* [unique] */
		uint32_t flags;
	} in;

	struct {
		struct DOMAIN_CONTROLLER_INFO **dc_info;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetUserAdd {
	struct {
		const char * server_name;/* [unique] */
		uint32_t level;
		uint8_t *buffer;/* [ref] */
	} in;

	struct {
		uint32_t *parm_error;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetUserDel {
	struct {
		const char * server_name;/* [unique] */
		const char * user_name;/* [ref] */
	} in;

	struct {
		enum NET_API_STATUS result;
	} out;

};


struct NetUserEnum {
	struct {
		const char * server_name;/* [unique] */
		uint32_t level;
		uint32_t filter;
		uint32_t prefmaxlen;
		uint32_t *resume_handle;/* [ref] */
	} in;

	struct {
		uint8_t **buffer;/* [ref] */
		uint32_t *entries_read;/* [ref] */
		uint32_t *total_entries;/* [ref] */
		uint32_t *resume_handle;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetUserChangePassword {
	struct {
		const char * domain_name;
		const char * user_name;
		const char * old_password;
		const char * new_password;
	} in;

	struct {
		enum NET_API_STATUS result;
	} out;

};


struct NetUserGetInfo {
	struct {
		const char * server_name;
		const char * user_name;
		uint32_t level;
	} in;

	struct {
		uint8_t **buffer;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetUserSetInfo {
	struct {
		const char * server_name;
		const char * user_name;
		uint32_t level;
		uint8_t *buffer;/* [ref] */
	} in;

	struct {
		uint32_t *parm_err;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetUserGetGroups {
	struct {
		const char * server_name;
		const char * user_name;
		uint32_t level;
		uint32_t prefmaxlen;
	} in;

	struct {
		uint8_t **buffer;/* [ref] */
		uint32_t *entries_read;/* [ref] */
		uint32_t *total_entries;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetUserSetGroups {
	struct {
		const char * server_name;
		const char * user_name;
		uint32_t level;
		uint8_t *buffer;/* [ref] */
		uint32_t num_entries;
	} in;

	struct {
		enum NET_API_STATUS result;
	} out;

};


struct NetUserGetLocalGroups {
	struct {
		const char * server_name;
		const char * user_name;
		uint32_t level;
		uint32_t flags;
		uint32_t prefmaxlen;
	} in;

	struct {
		uint8_t **buffer;/* [ref] */
		uint32_t *entries_read;/* [ref] */
		uint32_t *total_entries;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetUserModalsGet {
	struct {
		const char * server_name;
		uint32_t level;
	} in;

	struct {
		uint8_t **buffer;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetUserModalsSet {
	struct {
		const char * server_name;
		uint32_t level;
		uint8_t *buffer;/* [ref] */
	} in;

	struct {
		uint32_t *parm_err;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetQueryDisplayInformation {
	struct {
		const char * server_name;/* [unique] */
		uint32_t level;
		uint32_t idx;
		uint32_t entries_requested;
		uint32_t prefmaxlen;
	} in;

	struct {
		uint32_t *entries_read;/* [ref] */
		void **buffer;/* [noprint,ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetGroupAdd {
	struct {
		const char * server_name;
		uint32_t level;
		uint8_t *buffer;/* [ref] */
	} in;

	struct {
		uint32_t *parm_err;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetGroupDel {
	struct {
		const char * server_name;
		const char * group_name;
	} in;

	struct {
		enum NET_API_STATUS result;
	} out;

};


struct NetGroupEnum {
	struct {
		const char * server_name;
		uint32_t level;
		uint32_t prefmaxlen;
		uint32_t *resume_handle;/* [ref] */
	} in;

	struct {
		uint8_t **buffer;/* [ref] */
		uint32_t *entries_read;/* [ref] */
		uint32_t *total_entries;/* [ref] */
		uint32_t *resume_handle;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetGroupSetInfo {
	struct {
		const char * server_name;
		const char * group_name;
		uint32_t level;
		uint8_t *buffer;/* [ref] */
	} in;

	struct {
		uint32_t *parm_err;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetGroupGetInfo {
	struct {
		const char * server_name;
		const char * group_name;
		uint32_t level;
	} in;

	struct {
		uint8_t **buffer;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetGroupAddUser {
	struct {
		const char * server_name;
		const char * group_name;
		const char * user_name;
	} in;

	struct {
		enum NET_API_STATUS result;
	} out;

};


struct NetGroupDelUser {
	struct {
		const char * server_name;
		const char * group_name;
		const char * user_name;
	} in;

	struct {
		enum NET_API_STATUS result;
	} out;

};


struct NetGroupGetUsers {
	struct {
		const char * server_name;
		const char * group_name;
		uint32_t level;
		uint32_t prefmaxlen;
		uint32_t *resume_handle;/* [ref] */
	} in;

	struct {
		uint8_t **buffer;/* [ref] */
		uint32_t *entries_read;/* [ref] */
		uint32_t *total_entries;/* [ref] */
		uint32_t *resume_handle;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetGroupSetUsers {
	struct {
		const char * server_name;
		const char * group_name;
		uint32_t level;
		uint8_t *buffer;/* [ref] */
		uint32_t num_entries;
	} in;

	struct {
		enum NET_API_STATUS result;
	} out;

};


struct NetLocalGroupAdd {
	struct {
		const char * server_name;
		uint32_t level;
		uint8_t *buffer;/* [ref] */
	} in;

	struct {
		uint32_t *parm_err;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetLocalGroupDel {
	struct {
		const char * server_name;
		const char * group_name;
	} in;

	struct {
		enum NET_API_STATUS result;
	} out;

};


struct NetLocalGroupGetInfo {
	struct {
		const char * server_name;
		const char * group_name;
		uint32_t level;
	} in;

	struct {
		uint8_t **buffer;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetLocalGroupSetInfo {
	struct {
		const char * server_name;
		const char * group_name;
		uint32_t level;
		uint8_t *buffer;/* [ref] */
	} in;

	struct {
		uint32_t *parm_err;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetLocalGroupEnum {
	struct {
		const char * server_name;
		uint32_t level;
		uint32_t prefmaxlen;
		uint32_t *resume_handle;/* [ref] */
	} in;

	struct {
		uint8_t **buffer;/* [ref] */
		uint32_t *entries_read;/* [ref] */
		uint32_t *total_entries;/* [ref] */
		uint32_t *resume_handle;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetLocalGroupAddMembers {
	struct {
		const char * server_name;
		const char * group_name;
		uint32_t level;
		uint8_t *buffer;/* [ref] */
		uint32_t total_entries;
	} in;

	struct {
		enum NET_API_STATUS result;
	} out;

};


struct NetLocalGroupDelMembers {
	struct {
		const char * server_name;
		const char * group_name;
		uint32_t level;
		uint8_t *buffer;/* [ref] */
		uint32_t total_entries;
	} in;

	struct {
		enum NET_API_STATUS result;
	} out;

};


struct NetLocalGroupGetMembers {
	struct {
		const char * server_name;
		const char * local_group_name;
		uint32_t level;
		uint32_t prefmaxlen;
		uint32_t *resume_handle;/* [ref] */
	} in;

	struct {
		uint8_t **buffer;/* [ref] */
		uint32_t *entries_read;/* [ref] */
		uint32_t *total_entries;/* [ref] */
		uint32_t *resume_handle;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetLocalGroupSetMembers {
	struct {
		const char * server_name;
		const char * group_name;
		uint32_t level;
		uint8_t *buffer;/* [ref] */
		uint32_t total_entries;
	} in;

	struct {
		enum NET_API_STATUS result;
	} out;

};


struct NetRemoteTOD {
	struct {
		const char * server_name;
	} in;

	struct {
		uint8_t **buffer;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetShareAdd {
	struct {
		const char * server_name;
		uint32_t level;
		uint8_t *buffer;/* [ref] */
	} in;

	struct {
		uint32_t *parm_err;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetShareDel {
	struct {
		const char * server_name;
		const char * net_name;
		uint32_t reserved;
	} in;

	struct {
		enum NET_API_STATUS result;
	} out;

};


struct NetShareEnum {
	struct {
		const char * server_name;
		uint32_t level;
		uint32_t prefmaxlen;
		uint32_t *resume_handle;/* [ref] */
	} in;

	struct {
		uint8_t **buffer;/* [ref] */
		uint32_t *entries_read;/* [ref] */
		uint32_t *total_entries;/* [ref] */
		uint32_t *resume_handle;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetShareGetInfo {
	struct {
		const char * server_name;
		const char * net_name;
		uint32_t level;
	} in;

	struct {
		uint8_t **buffer;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetShareSetInfo {
	struct {
		const char * server_name;
		const char * net_name;
		uint32_t level;
		uint8_t *buffer;/* [ref] */
	} in;

	struct {
		uint32_t *parm_err;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetFileClose {
	struct {
		const char * server_name;
		uint32_t fileid;
	} in;

	struct {
		enum NET_API_STATUS result;
	} out;

};


struct NetFileGetInfo {
	struct {
		const char * server_name;
		uint32_t fileid;
		uint32_t level;
	} in;

	struct {
		uint8_t **buffer;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};


struct NetFileEnum {
	struct {
		const char * server_name;
		const char * base_path;
		const char * user_name;
		uint32_t level;
		uint32_t prefmaxlen;
		uint32_t *resume_handle;/* [ref] */
	} in;

	struct {
		uint8_t **buffer;/* [ref] */
		uint32_t *entries_read;/* [ref] */
		uint32_t *total_entries;/* [ref] */
		uint32_t *resume_handle;/* [ref] */
		enum NET_API_STATUS result;
	} out;

};

#endif /* _HEADER_libnetapi */
