/* parser auto-generated by pidl */

#include "includes.h"
#include "librpc/gen_ndr/ndr_svcctl.h"

static enum ndr_err_code ndr_push_SERVICE_LOCK_STATUS(struct ndr_push *ndr, int ndr_flags, const struct SERVICE_LOCK_STATUS *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->is_locked));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->lock_owner));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->lock_duration));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->lock_owner) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->lock_owner, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->lock_owner, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->lock_owner, ndr_charset_length(r->lock_owner, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_SERVICE_LOCK_STATUS(struct ndr_pull *ndr, int ndr_flags, struct SERVICE_LOCK_STATUS *r)
{
	uint32_t _ptr_lock_owner;
	TALLOC_CTX *_mem_save_lock_owner_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->is_locked));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lock_owner));
		if (_ptr_lock_owner) {
			NDR_PULL_ALLOC(ndr, r->lock_owner);
		} else {
			r->lock_owner = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->lock_duration));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->lock_owner) {
			_mem_save_lock_owner_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->lock_owner, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->lock_owner));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->lock_owner));
			if (ndr_get_array_length(ndr, &r->lock_owner) > ndr_get_array_size(ndr, &r->lock_owner)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->lock_owner), ndr_get_array_length(ndr, &r->lock_owner));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->lock_owner), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->lock_owner, ndr_get_array_length(ndr, &r->lock_owner), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lock_owner_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVICE_LOCK_STATUS(struct ndr_print *ndr, const char *name, const struct SERVICE_LOCK_STATUS *r)
{
	ndr_print_struct(ndr, name, "SERVICE_LOCK_STATUS");
	ndr->depth++;
	ndr_print_uint32(ndr, "is_locked", r->is_locked);
	ndr_print_ptr(ndr, "lock_owner", r->lock_owner);
	ndr->depth++;
	if (r->lock_owner) {
		ndr_print_string(ndr, "lock_owner", r->lock_owner);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "lock_duration", r->lock_duration);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_SERVICE_STATUS(struct ndr_push *ndr, int ndr_flags, const struct SERVICE_STATUS *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->type));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->state));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->controls_accepted));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->win32_exit_code));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->service_exit_code));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->check_point));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->wait_hint));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_SERVICE_STATUS(struct ndr_pull *ndr, int ndr_flags, struct SERVICE_STATUS *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->type));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->state));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->controls_accepted));
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->win32_exit_code));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->service_exit_code));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->check_point));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->wait_hint));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVICE_STATUS(struct ndr_print *ndr, const char *name, const struct SERVICE_STATUS *r)
{
	ndr_print_struct(ndr, name, "SERVICE_STATUS");
	ndr->depth++;
	ndr_print_uint32(ndr, "type", r->type);
	ndr_print_uint32(ndr, "state", r->state);
	ndr_print_uint32(ndr, "controls_accepted", r->controls_accepted);
	ndr_print_WERROR(ndr, "win32_exit_code", r->win32_exit_code);
	ndr_print_uint32(ndr, "service_exit_code", r->service_exit_code);
	ndr_print_uint32(ndr, "check_point", r->check_point);
	ndr_print_uint32(ndr, "wait_hint", r->wait_hint);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_ENUM_SERVICE_STATUS(struct ndr_push *ndr, int ndr_flags, const struct ENUM_SERVICE_STATUS *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->service_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->display_name));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_SERVICE_STATUS(ndr, NDR_SCALARS, &r->status));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->service_name) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->service_name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->service_name));
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->display_name) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->display_name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->display_name));
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_ENUM_SERVICE_STATUS(struct ndr_pull *ndr, int ndr_flags, struct ENUM_SERVICE_STATUS *r)
{
	uint32_t _ptr_service_name;
	TALLOC_CTX *_mem_save_service_name_0;
	uint32_t _ptr_display_name;
	TALLOC_CTX *_mem_save_display_name_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_service_name));
			if (_ptr_service_name) {
				NDR_PULL_ALLOC(ndr, r->service_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->service_name, _ptr_service_name));
			} else {
				r->service_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_display_name));
			if (_ptr_display_name) {
				NDR_PULL_ALLOC(ndr, r->display_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->display_name, _ptr_display_name));
			} else {
				r->display_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_SERVICE_STATUS(ndr, NDR_SCALARS, &r->status));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->service_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->service_name));
				_mem_save_service_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->service_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->service_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_service_name_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->display_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->display_name));
				_mem_save_display_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->display_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->display_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_display_name_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_ENUM_SERVICE_STATUS(struct ndr_print *ndr, const char *name, const struct ENUM_SERVICE_STATUS *r)
{
	ndr_print_struct(ndr, name, "ENUM_SERVICE_STATUS");
	ndr->depth++;
	ndr_print_ptr(ndr, "service_name", r->service_name);
	ndr->depth++;
	if (r->service_name) {
		ndr_print_string(ndr, "service_name", r->service_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "display_name", r->display_name);
	ndr->depth++;
	if (r->display_name) {
		ndr_print_string(ndr, "display_name", r->display_name);
	}
	ndr->depth--;
	ndr_print_SERVICE_STATUS(ndr, "status", &r->status);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_svcctl_ServerType(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_svcctl_ServerType(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_ServerType(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_WORKSTATION", SV_TYPE_WORKSTATION, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_SERVER", SV_TYPE_SERVER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_SQLSERVER", SV_TYPE_SQLSERVER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_DOMAIN_CTRL", SV_TYPE_DOMAIN_CTRL, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_DOMAIN_BAKCTRL", SV_TYPE_DOMAIN_BAKCTRL, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_TIME_SOURCE", SV_TYPE_TIME_SOURCE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_AFP", SV_TYPE_AFP, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_NOVELL", SV_TYPE_NOVELL, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_DOMAIN_MEMBER", SV_TYPE_DOMAIN_MEMBER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_PRINTQ_SERVER", SV_TYPE_PRINTQ_SERVER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_DIALIN_SERVER", SV_TYPE_DIALIN_SERVER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_SERVER_UNIX", SV_TYPE_SERVER_UNIX, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_NT", SV_TYPE_NT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_WFW", SV_TYPE_WFW, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_SERVER_MFPN", SV_TYPE_SERVER_MFPN, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_SERVER_NT", SV_TYPE_SERVER_NT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_POTENTIAL_BROWSER", SV_TYPE_POTENTIAL_BROWSER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_BACKUP_BROWSER", SV_TYPE_BACKUP_BROWSER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_MASTER_BROWSER", SV_TYPE_MASTER_BROWSER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_DOMAIN_MASTER", SV_TYPE_DOMAIN_MASTER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_SERVER_OSF", SV_TYPE_SERVER_OSF, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_SERVER_VMS", SV_TYPE_SERVER_VMS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_WIN95_PLUS", SV_TYPE_WIN95_PLUS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_DFS_SERVER", SV_TYPE_DFS_SERVER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_ALTERNATE_XPORT", SV_TYPE_ALTERNATE_XPORT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_LOCAL_LIST_ONLY", SV_TYPE_LOCAL_LIST_ONLY, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_DOMAIN_ENUM", SV_TYPE_DOMAIN_ENUM, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_MgrAccessMask(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_MgrAccessMask(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_MgrAccessMask(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SC_RIGHT_MGR_CONNECT", SC_RIGHT_MGR_CONNECT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SC_RIGHT_MGR_CREATE_SERVICE", SC_RIGHT_MGR_CREATE_SERVICE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SC_RIGHT_MGR_ENUMERATE_SERVICE", SC_RIGHT_MGR_ENUMERATE_SERVICE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SC_RIGHT_MGR_LOCK", SC_RIGHT_MGR_LOCK, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SC_RIGHT_MGR_QUERY_LOCK_STATUS", SC_RIGHT_MGR_QUERY_LOCK_STATUS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SC_RIGHT_MGR_MODIFY_BOOT_CONFIG", SC_RIGHT_MGR_MODIFY_BOOT_CONFIG, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_ServiceAccessMask(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_ServiceAccessMask(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_ServiceAccessMask(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SC_RIGHT_SVC_QUERY_CONFIG", SC_RIGHT_SVC_QUERY_CONFIG, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SC_RIGHT_SVC_CHANGE_CONFIG", SC_RIGHT_SVC_CHANGE_CONFIG, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SC_RIGHT_SVC_QUERY_STATUS", SC_RIGHT_SVC_QUERY_STATUS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SC_RIGHT_SVC_ENUMERATE_DEPENDENTS", SC_RIGHT_SVC_ENUMERATE_DEPENDENTS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SC_RIGHT_SVC_START", SC_RIGHT_SVC_START, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SC_RIGHT_SVC_STOP", SC_RIGHT_SVC_STOP, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SC_RIGHT_SVC_PAUSE_CONTINUE", SC_RIGHT_SVC_PAUSE_CONTINUE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SC_RIGHT_SVC_INTERROGATE", SC_RIGHT_SVC_INTERROGATE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SC_RIGHT_SVC_USER_DEFINED_CONTROL", SC_RIGHT_SVC_USER_DEFINED_CONTROL, r);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_QUERY_SERVICE_CONFIG(struct ndr_push *ndr, int ndr_flags, const struct QUERY_SERVICE_CONFIG *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->service_type));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->start_type));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->error_control));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->executablepath));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->loadordergroup));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->tag_id));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->dependencies));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->startname));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->displayname));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->executablepath) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->executablepath, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->executablepath, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->executablepath, ndr_charset_length(r->executablepath, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->loadordergroup) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->loadordergroup, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->loadordergroup, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->loadordergroup, ndr_charset_length(r->loadordergroup, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->dependencies) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->dependencies, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->dependencies, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->dependencies, ndr_charset_length(r->dependencies, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->startname) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->startname, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->startname, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->startname, ndr_charset_length(r->startname, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->displayname) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->displayname, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->displayname, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->displayname, ndr_charset_length(r->displayname, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_QUERY_SERVICE_CONFIG(struct ndr_pull *ndr, int ndr_flags, struct QUERY_SERVICE_CONFIG *r)
{
	uint32_t _ptr_executablepath;
	TALLOC_CTX *_mem_save_executablepath_0;
	uint32_t _ptr_loadordergroup;
	TALLOC_CTX *_mem_save_loadordergroup_0;
	uint32_t _ptr_dependencies;
	TALLOC_CTX *_mem_save_dependencies_0;
	uint32_t _ptr_startname;
	TALLOC_CTX *_mem_save_startname_0;
	uint32_t _ptr_displayname;
	TALLOC_CTX *_mem_save_displayname_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->service_type));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->start_type));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->error_control));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_executablepath));
		if (_ptr_executablepath) {
			NDR_PULL_ALLOC(ndr, r->executablepath);
		} else {
			r->executablepath = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_loadordergroup));
		if (_ptr_loadordergroup) {
			NDR_PULL_ALLOC(ndr, r->loadordergroup);
		} else {
			r->loadordergroup = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->tag_id));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dependencies));
		if (_ptr_dependencies) {
			NDR_PULL_ALLOC(ndr, r->dependencies);
		} else {
			r->dependencies = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_startname));
		if (_ptr_startname) {
			NDR_PULL_ALLOC(ndr, r->startname);
		} else {
			r->startname = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_displayname));
		if (_ptr_displayname) {
			NDR_PULL_ALLOC(ndr, r->displayname);
		} else {
			r->displayname = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->executablepath) {
			_mem_save_executablepath_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->executablepath, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->executablepath));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->executablepath));
			if (ndr_get_array_length(ndr, &r->executablepath) > ndr_get_array_size(ndr, &r->executablepath)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->executablepath), ndr_get_array_length(ndr, &r->executablepath));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->executablepath), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->executablepath, ndr_get_array_length(ndr, &r->executablepath), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_executablepath_0, 0);
		}
		if (r->loadordergroup) {
			_mem_save_loadordergroup_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->loadordergroup, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->loadordergroup));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->loadordergroup));
			if (ndr_get_array_length(ndr, &r->loadordergroup) > ndr_get_array_size(ndr, &r->loadordergroup)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->loadordergroup), ndr_get_array_length(ndr, &r->loadordergroup));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->loadordergroup), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->loadordergroup, ndr_get_array_length(ndr, &r->loadordergroup), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_loadordergroup_0, 0);
		}
		if (r->dependencies) {
			_mem_save_dependencies_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->dependencies, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->dependencies));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->dependencies));
			if (ndr_get_array_length(ndr, &r->dependencies) > ndr_get_array_size(ndr, &r->dependencies)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->dependencies), ndr_get_array_length(ndr, &r->dependencies));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->dependencies), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->dependencies, ndr_get_array_length(ndr, &r->dependencies), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dependencies_0, 0);
		}
		if (r->startname) {
			_mem_save_startname_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->startname, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->startname));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->startname));
			if (ndr_get_array_length(ndr, &r->startname) > ndr_get_array_size(ndr, &r->startname)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->startname), ndr_get_array_length(ndr, &r->startname));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->startname), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->startname, ndr_get_array_length(ndr, &r->startname), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_startname_0, 0);
		}
		if (r->displayname) {
			_mem_save_displayname_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->displayname, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->displayname));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->displayname));
			if (ndr_get_array_length(ndr, &r->displayname) > ndr_get_array_size(ndr, &r->displayname)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->displayname), ndr_get_array_length(ndr, &r->displayname));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->displayname), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->displayname, ndr_get_array_length(ndr, &r->displayname), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_displayname_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_QUERY_SERVICE_CONFIG(struct ndr_print *ndr, const char *name, const struct QUERY_SERVICE_CONFIG *r)
{
	ndr_print_struct(ndr, name, "QUERY_SERVICE_CONFIG");
	ndr->depth++;
	ndr_print_uint32(ndr, "service_type", r->service_type);
	ndr_print_uint32(ndr, "start_type", r->start_type);
	ndr_print_uint32(ndr, "error_control", r->error_control);
	ndr_print_ptr(ndr, "executablepath", r->executablepath);
	ndr->depth++;
	if (r->executablepath) {
		ndr_print_string(ndr, "executablepath", r->executablepath);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "loadordergroup", r->loadordergroup);
	ndr->depth++;
	if (r->loadordergroup) {
		ndr_print_string(ndr, "loadordergroup", r->loadordergroup);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "tag_id", r->tag_id);
	ndr_print_ptr(ndr, "dependencies", r->dependencies);
	ndr->depth++;
	if (r->dependencies) {
		ndr_print_string(ndr, "dependencies", r->dependencies);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "startname", r->startname);
	ndr->depth++;
	if (r->startname) {
		ndr_print_string(ndr, "startname", r->startname);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "displayname", r->displayname);
	ndr->depth++;
	if (r->displayname) {
		ndr_print_string(ndr, "displayname", r->displayname);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_QUERY_SERVICE_CONFIG(const struct QUERY_SERVICE_CONFIG *r, int flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_QUERY_SERVICE_CONFIG);
}

static enum ndr_err_code ndr_push_svcctl_CloseServiceHandle(struct ndr_push *ndr, int flags, const struct svcctl_CloseServiceHandle *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
	}
	if (flags & NDR_OUT) {
		if (r->out.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.handle));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_CloseServiceHandle(struct ndr_pull *ndr, int flags, struct svcctl_CloseServiceHandle *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.handle);
		*r->out.handle = *r->in.handle;
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_CloseServiceHandle(struct ndr_print *ndr, const char *name, int flags, const struct svcctl_CloseServiceHandle *r)
{
	ndr_print_struct(ndr, name, "svcctl_CloseServiceHandle");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_CloseServiceHandle");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_CloseServiceHandle");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->out.handle);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_ControlService(struct ndr_push *ndr, int flags, const struct svcctl_ControlService *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.control));
	}
	if (flags & NDR_OUT) {
		if (r->out.service_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_SERVICE_STATUS(ndr, NDR_SCALARS, r->out.service_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_ControlService(struct ndr_pull *ndr, int flags, struct svcctl_ControlService *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_service_status_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.control));
		NDR_PULL_ALLOC(ndr, r->out.service_status);
		ZERO_STRUCTP(r->out.service_status);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.service_status);
		}
		_mem_save_service_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.service_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_SERVICE_STATUS(ndr, NDR_SCALARS, r->out.service_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_service_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_ControlService(struct ndr_print *ndr, const char *name, int flags, const struct svcctl_ControlService *r)
{
	ndr_print_struct(ndr, name, "svcctl_ControlService");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_ControlService");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "control", r->in.control);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_ControlService");
		ndr->depth++;
		ndr_print_ptr(ndr, "service_status", r->out.service_status);
		ndr->depth++;
		ndr_print_SERVICE_STATUS(ndr, "service_status", r->out.service_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_DeleteService(struct ndr_push *ndr, int flags, const struct svcctl_DeleteService *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_DeleteService(struct ndr_pull *ndr, int flags, struct svcctl_DeleteService *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_DeleteService(struct ndr_print *ndr, const char *name, int flags, const struct svcctl_DeleteService *r)
{
	ndr_print_struct(ndr, name, "svcctl_DeleteService");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_DeleteService");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_DeleteService");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_LockServiceDatabase(struct ndr_push *ndr, int flags, const struct svcctl_LockServiceDatabase *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
	}
	if (flags & NDR_OUT) {
		if (r->out.lock == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.lock));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_LockServiceDatabase(struct ndr_pull *ndr, int flags, struct svcctl_LockServiceDatabase *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_lock_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.lock);
		ZERO_STRUCTP(r->out.lock);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lock);
		}
		_mem_save_lock_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lock, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.lock));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lock_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_LockServiceDatabase(struct ndr_print *ndr, const char *name, int flags, const struct svcctl_LockServiceDatabase *r)
{
	ndr_print_struct(ndr, name, "svcctl_LockServiceDatabase");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_LockServiceDatabase");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_LockServiceDatabase");
		ndr->depth++;
		ndr_print_ptr(ndr, "lock", r->out.lock);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "lock", r->out.lock);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_QueryServiceObjectSecurity(struct ndr_push *ndr, int flags, const struct svcctl_QueryServiceObjectSecurity *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.security_flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.buffer_size));
	}
	if (flags & NDR_OUT) {
		if (r->out.buffer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.buffer_size));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.buffer, r->in.buffer_size));
		if (r->out.needed == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.needed));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_QueryServiceObjectSecurity(struct ndr_pull *ndr, int flags, struct svcctl_QueryServiceObjectSecurity *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_needed_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.security_flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.buffer_size));
		if (r->in.buffer_size < 0 || r->in.buffer_size > 0x40000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_PULL_ALLOC_N(ndr, r->out.buffer, r->in.buffer_size);
		memset(r->out.buffer, 0, (r->in.buffer_size) * sizeof(*r->out.buffer));
		NDR_PULL_ALLOC(ndr, r->out.needed);
		ZERO_STRUCTP(r->out.needed);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.buffer));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.buffer, ndr_get_array_size(ndr, &r->out.buffer));
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.buffer, ndr_get_array_size(ndr, &r->out.buffer)));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.needed);
		}
		_mem_save_needed_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.needed, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.needed));
		if (*r->out.needed < 0 || *r->out.needed > 0x40000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_needed_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.buffer) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->out.buffer, r->in.buffer_size));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_QueryServiceObjectSecurity(struct ndr_print *ndr, const char *name, int flags, const struct svcctl_QueryServiceObjectSecurity *r)
{
	ndr_print_struct(ndr, name, "svcctl_QueryServiceObjectSecurity");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_QueryServiceObjectSecurity");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "security_flags", r->in.security_flags);
		ndr_print_uint32(ndr, "buffer_size", r->in.buffer_size);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_QueryServiceObjectSecurity");
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "buffer", r->out.buffer, r->in.buffer_size);
		ndr->depth--;
		ndr_print_ptr(ndr, "needed", r->out.needed);
		ndr->depth++;
		ndr_print_uint32(ndr, "needed", *r->out.needed);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_SetServiceObjectSecurity(struct ndr_push *ndr, int flags, const struct svcctl_SetServiceObjectSecurity *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.security_flags));
		if (r->in.buffer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.buffer_size));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.buffer, r->in.buffer_size));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.buffer_size));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_SetServiceObjectSecurity(struct ndr_pull *ndr, int flags, struct svcctl_SetServiceObjectSecurity *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.security_flags));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.buffer));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->in.buffer, ndr_get_array_size(ndr, &r->in.buffer));
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.buffer, ndr_get_array_size(ndr, &r->in.buffer)));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.buffer_size));
		if (r->in.buffer) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->in.buffer, r->in.buffer_size));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_SetServiceObjectSecurity(struct ndr_print *ndr, const char *name, int flags, const struct svcctl_SetServiceObjectSecurity *r)
{
	ndr_print_struct(ndr, name, "svcctl_SetServiceObjectSecurity");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_SetServiceObjectSecurity");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "security_flags", r->in.security_flags);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "buffer", r->in.buffer, r->in.buffer_size);
		ndr->depth--;
		ndr_print_uint32(ndr, "buffer_size", r->in.buffer_size);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_SetServiceObjectSecurity");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_QueryServiceStatus(struct ndr_push *ndr, int flags, const struct svcctl_QueryServiceStatus *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
	}
	if (flags & NDR_OUT) {
		if (r->out.service_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_SERVICE_STATUS(ndr, NDR_SCALARS, r->out.service_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_QueryServiceStatus(struct ndr_pull *ndr, int flags, struct svcctl_QueryServiceStatus *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_service_status_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.service_status);
		ZERO_STRUCTP(r->out.service_status);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.service_status);
		}
		_mem_save_service_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.service_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_SERVICE_STATUS(ndr, NDR_SCALARS, r->out.service_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_service_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_QueryServiceStatus(struct ndr_print *ndr, const char *name, int flags, const struct svcctl_QueryServiceStatus *r)
{
	ndr_print_struct(ndr, name, "svcctl_QueryServiceStatus");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_QueryServiceStatus");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_QueryServiceStatus");
		ndr->depth++;
		ndr_print_ptr(ndr, "service_status", r->out.service_status);
		ndr->depth++;
		ndr_print_SERVICE_STATUS(ndr, "service_status", r->out.service_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_SetServiceStatus(struct ndr_push *ndr, int flags, const struct svcctl_SetServiceStatus *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_SetServiceStatus(struct ndr_pull *ndr, int flags, struct svcctl_SetServiceStatus *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_SetServiceStatus(struct ndr_print *ndr, const char *name, int flags, const struct svcctl_SetServiceStatus *r)
{
	ndr_print_struct(ndr, name, "svcctl_SetServiceStatus");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_SetServiceStatus");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_SetServiceStatus");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_UnlockServiceDatabase(struct ndr_push *ndr, int flags, const struct svcctl_UnlockServiceDatabase *r)
{
	if (flags & NDR_IN) {
		if (r->in.lock == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.lock));
	}
	if (flags & NDR_OUT) {
		if (r->out.lock == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.lock));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_UnlockServiceDatabase(struct ndr_pull *ndr, int flags, struct svcctl_UnlockServiceDatabase *r)
{
	TALLOC_CTX *_mem_save_lock_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.lock);
		}
		_mem_save_lock_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.lock, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.lock));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lock_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.lock);
		*r->out.lock = *r->in.lock;
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lock);
		}
		_mem_save_lock_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lock, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.lock));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lock_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_UnlockServiceDatabase(struct ndr_print *ndr, const char *name, int flags, const struct svcctl_UnlockServiceDatabase *r)
{
	ndr_print_struct(ndr, name, "svcctl_UnlockServiceDatabase");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_UnlockServiceDatabase");
		ndr->depth++;
		ndr_print_ptr(ndr, "lock", r->in.lock);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "lock", r->in.lock);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_UnlockServiceDatabase");
		ndr->depth++;
		ndr_print_ptr(ndr, "lock", r->out.lock);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "lock", r->out.lock);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_NotifyBootConfigStatus(struct ndr_push *ndr, int flags, const struct svcctl_NotifyBootConfigStatus *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_NotifyBootConfigStatus(struct ndr_pull *ndr, int flags, struct svcctl_NotifyBootConfigStatus *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_NotifyBootConfigStatus(struct ndr_print *ndr, const char *name, int flags, const struct svcctl_NotifyBootConfigStatus *r)
{
	ndr_print_struct(ndr, name, "svcctl_NotifyBootConfigStatus");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_NotifyBootConfigStatus");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_NotifyBootConfigStatus");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_SCSetServiceBitsW(struct ndr_push *ndr, int flags, const struct svcctl_SCSetServiceBitsW *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.bits));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.bitson));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.immediate));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_SCSetServiceBitsW(struct ndr_pull *ndr, int flags, struct svcctl_SCSetServiceBitsW *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.bits));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.bitson));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.immediate));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_SCSetServiceBitsW(struct ndr_print *ndr, const char *name, int flags, const struct svcctl_SCSetServiceBitsW *r)
{
	ndr_print_struct(ndr, name, "svcctl_SCSetServiceBitsW");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_SCSetServiceBitsW");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "bits", r->in.bits);
		ndr_print_uint32(ndr, "bitson", r->in.bitson);
		ndr_print_uint32(ndr, "immediate", r->in.immediate);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_SCSetServiceBitsW");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_ChangeServiceConfigW(struct ndr_push *ndr, int flags, const struct svcctl_ChangeServiceConfigW *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.type));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.start));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.error));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.binary_path));
		if (r->in.binary_path) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.binary_path, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.binary_path, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.binary_path, ndr_charset_length(r->in.binary_path, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.load_order_group));
		if (r->in.load_order_group) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.load_order_group, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.load_order_group, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.load_order_group, ndr_charset_length(r->in.load_order_group, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.dependencies));
		if (r->in.dependencies) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.dependencies, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.dependencies, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.dependencies, ndr_charset_length(r->in.dependencies, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.service_start_name));
		if (r->in.service_start_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.service_start_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.service_start_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.service_start_name, ndr_charset_length(r->in.service_start_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.password));
		if (r->in.password) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.password, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.password, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.password, ndr_charset_length(r->in.password, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.display_name));
		if (r->in.display_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.display_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.display_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.display_name, ndr_charset_length(r->in.display_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.tag_id == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.tag_id));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_ChangeServiceConfigW(struct ndr_pull *ndr, int flags, struct svcctl_ChangeServiceConfigW *r)
{
	uint32_t _ptr_binary_path;
	uint32_t _ptr_load_order_group;
	uint32_t _ptr_dependencies;
	uint32_t _ptr_service_start_name;
	uint32_t _ptr_password;
	uint32_t _ptr_display_name;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_binary_path_0;
	TALLOC_CTX *_mem_save_load_order_group_0;
	TALLOC_CTX *_mem_save_tag_id_0;
	TALLOC_CTX *_mem_save_dependencies_0;
	TALLOC_CTX *_mem_save_service_start_name_0;
	TALLOC_CTX *_mem_save_password_0;
	TALLOC_CTX *_mem_save_display_name_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.type));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.start));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.error));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_binary_path));
		if (_ptr_binary_path) {
			NDR_PULL_ALLOC(ndr, r->in.binary_path);
		} else {
			r->in.binary_path = NULL;
		}
		if (r->in.binary_path) {
			_mem_save_binary_path_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.binary_path, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.binary_path));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.binary_path));
			if (ndr_get_array_length(ndr, &r->in.binary_path) > ndr_get_array_size(ndr, &r->in.binary_path)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.binary_path), ndr_get_array_length(ndr, &r->in.binary_path));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.binary_path), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.binary_path, ndr_get_array_length(ndr, &r->in.binary_path), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_binary_path_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_load_order_group));
		if (_ptr_load_order_group) {
			NDR_PULL_ALLOC(ndr, r->in.load_order_group);
		} else {
			r->in.load_order_group = NULL;
		}
		if (r->in.load_order_group) {
			_mem_save_load_order_group_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.load_order_group, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.load_order_group));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.load_order_group));
			if (ndr_get_array_length(ndr, &r->in.load_order_group) > ndr_get_array_size(ndr, &r->in.load_order_group)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.load_order_group), ndr_get_array_length(ndr, &r->in.load_order_group));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.load_order_group), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.load_order_group, ndr_get_array_length(ndr, &r->in.load_order_group), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_load_order_group_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dependencies));
		if (_ptr_dependencies) {
			NDR_PULL_ALLOC(ndr, r->in.dependencies);
		} else {
			r->in.dependencies = NULL;
		}
		if (r->in.dependencies) {
			_mem_save_dependencies_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.dependencies, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.dependencies));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.dependencies));
			if (ndr_get_array_length(ndr, &r->in.dependencies) > ndr_get_array_size(ndr, &r->in.dependencies)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.dependencies), ndr_get_array_length(ndr, &r->in.dependencies));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.dependencies), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.dependencies, ndr_get_array_length(ndr, &r->in.dependencies), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dependencies_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_service_start_name));
		if (_ptr_service_start_name) {
			NDR_PULL_ALLOC(ndr, r->in.service_start_name);
		} else {
			r->in.service_start_name = NULL;
		}
		if (r->in.service_start_name) {
			_mem_save_service_start_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.service_start_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.service_start_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.service_start_name));
			if (ndr_get_array_length(ndr, &r->in.service_start_name) > ndr_get_array_size(ndr, &r->in.service_start_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.service_start_name), ndr_get_array_length(ndr, &r->in.service_start_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.service_start_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.service_start_name, ndr_get_array_length(ndr, &r->in.service_start_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_service_start_name_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_password));
		if (_ptr_password) {
			NDR_PULL_ALLOC(ndr, r->in.password);
		} else {
			r->in.password = NULL;
		}
		if (r->in.password) {
			_mem_save_password_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.password, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.password));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.password));
			if (ndr_get_array_length(ndr, &r->in.password) > ndr_get_array_size(ndr, &r->in.password)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.password), ndr_get_array_length(ndr, &r->in.password));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.password), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.password, ndr_get_array_length(ndr, &r->in.password), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_password_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_display_name));
		if (_ptr_display_name) {
			NDR_PULL_ALLOC(ndr, r->in.display_name);
		} else {
			r->in.display_name = NULL;
		}
		if (r->in.display_name) {
			_mem_save_display_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.display_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.display_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.display_name));
			if (ndr_get_array_length(ndr, &r->in.display_name) > ndr_get_array_size(ndr, &r->in.display_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.display_name), ndr_get_array_length(ndr, &r->in.display_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.display_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.display_name, ndr_get_array_length(ndr, &r->in.display_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_display_name_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.tag_id);
		ZERO_STRUCTP(r->out.tag_id);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.tag_id);
		}
		_mem_save_tag_id_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.tag_id, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.tag_id));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_tag_id_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_ChangeServiceConfigW(struct ndr_print *ndr, const char *name, int flags, const struct svcctl_ChangeServiceConfigW *r)
{
	ndr_print_struct(ndr, name, "svcctl_ChangeServiceConfigW");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_ChangeServiceConfigW");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "type", r->in.type);
		ndr_print_uint32(ndr, "start", r->in.start);
		ndr_print_uint32(ndr, "error", r->in.error);
		ndr_print_ptr(ndr, "binary_path", r->in.binary_path);
		ndr->depth++;
		if (r->in.binary_path) {
			ndr_print_string(ndr, "binary_path", r->in.binary_path);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "load_order_group", r->in.load_order_group);
		ndr->depth++;
		if (r->in.load_order_group) {
			ndr_print_string(ndr, "load_order_group", r->in.load_order_group);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "dependencies", r->in.dependencies);
		ndr->depth++;
		if (r->in.dependencies) {
			ndr_print_string(ndr, "dependencies", r->in.dependencies);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "service_start_name", r->in.service_start_name);
		ndr->depth++;
		if (r->in.service_start_name) {
			ndr_print_string(ndr, "service_start_name", r->in.service_start_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "password", r->in.password);
		ndr->depth++;
		if (r->in.password) {
			ndr_print_string(ndr, "password", r->in.password);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "display_name", r->in.display_name);
		ndr->depth++;
		if (r->in.display_name) {
			ndr_print_string(ndr, "display_name", r->in.display_name);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_ChangeServiceConfigW");
		ndr->depth++;
		ndr_print_ptr(ndr, "tag_id", r->out.tag_id);
		ndr->depth++;
		ndr_print_uint32(ndr, "tag_id", *r->out.tag_id);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_CreateServiceW(struct ndr_push *ndr, int flags, const struct svcctl_CreateServiceW *r)
{
	if (flags & NDR_IN) {
		if (r->in.scmanager_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.scmanager_handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.ServiceName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.ServiceName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.ServiceName, ndr_charset_length(r->in.ServiceName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.DisplayName));
		if (r->in.DisplayName) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.DisplayName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.DisplayName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.DisplayName, ndr_charset_length(r->in.DisplayName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.desired_access));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.type));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.start_type));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.error_control));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.binary_path, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.binary_path, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.binary_path, ndr_charset_length(r->in.binary_path, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.LoadOrderGroupKey));
		if (r->in.LoadOrderGroupKey) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.LoadOrderGroupKey, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.LoadOrderGroupKey, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.LoadOrderGroupKey, ndr_charset_length(r->in.LoadOrderGroupKey, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.TagId));
		if (r->in.TagId) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.TagId));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.dependencies));
		if (r->in.dependencies) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dependencies_size));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.dependencies, r->in.dependencies_size));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dependencies_size));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.service_start_name));
		if (r->in.service_start_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.service_start_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.service_start_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.service_start_name, ndr_charset_length(r->in.service_start_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.password));
		if (r->in.password) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.password_size));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.password, r->in.password_size));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.password_size));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.TagId));
		if (r->out.TagId) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.TagId));
		}
		if (r->out.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.handle));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_CreateServiceW(struct ndr_pull *ndr, int flags, struct svcctl_CreateServiceW *r)
{
	uint32_t _ptr_DisplayName;
	uint32_t _ptr_LoadOrderGroupKey;
	uint32_t _ptr_TagId;
	uint32_t _ptr_dependencies;
	uint32_t _ptr_service_start_name;
	uint32_t _ptr_password;
	TALLOC_CTX *_mem_save_scmanager_handle_0;
	TALLOC_CTX *_mem_save_DisplayName_0;
	TALLOC_CTX *_mem_save_LoadOrderGroupKey_0;
	TALLOC_CTX *_mem_save_TagId_0;
	TALLOC_CTX *_mem_save_dependencies_0;
	TALLOC_CTX *_mem_save_service_start_name_0;
	TALLOC_CTX *_mem_save_password_0;
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.scmanager_handle);
		}
		_mem_save_scmanager_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.scmanager_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.scmanager_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_scmanager_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.ServiceName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.ServiceName));
		if (ndr_get_array_length(ndr, &r->in.ServiceName) > ndr_get_array_size(ndr, &r->in.ServiceName)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.ServiceName), ndr_get_array_length(ndr, &r->in.ServiceName));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.ServiceName), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.ServiceName, ndr_get_array_length(ndr, &r->in.ServiceName), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_DisplayName));
		if (_ptr_DisplayName) {
			NDR_PULL_ALLOC(ndr, r->in.DisplayName);
		} else {
			r->in.DisplayName = NULL;
		}
		if (r->in.DisplayName) {
			_mem_save_DisplayName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.DisplayName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.DisplayName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.DisplayName));
			if (ndr_get_array_length(ndr, &r->in.DisplayName) > ndr_get_array_size(ndr, &r->in.DisplayName)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.DisplayName), ndr_get_array_length(ndr, &r->in.DisplayName));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.DisplayName), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.DisplayName, ndr_get_array_length(ndr, &r->in.DisplayName), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_DisplayName_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.desired_access));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.type));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.start_type));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.error_control));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.binary_path));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.binary_path));
		if (ndr_get_array_length(ndr, &r->in.binary_path) > ndr_get_array_size(ndr, &r->in.binary_path)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.binary_path), ndr_get_array_length(ndr, &r->in.binary_path));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.binary_path), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.binary_path, ndr_get_array_length(ndr, &r->in.binary_path), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_LoadOrderGroupKey));
		if (_ptr_LoadOrderGroupKey) {
			NDR_PULL_ALLOC(ndr, r->in.LoadOrderGroupKey);
		} else {
			r->in.LoadOrderGroupKey = NULL;
		}
		if (r->in.LoadOrderGroupKey) {
			_mem_save_LoadOrderGroupKey_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.LoadOrderGroupKey, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.LoadOrderGroupKey));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.LoadOrderGroupKey));
			if (ndr_get_array_length(ndr, &r->in.LoadOrderGroupKey) > ndr_get_array_size(ndr, &r->in.LoadOrderGroupKey)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.LoadOrderGroupKey), ndr_get_array_length(ndr, &r->in.LoadOrderGroupKey));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.LoadOrderGroupKey), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.LoadOrderGroupKey, ndr_get_array_length(ndr, &r->in.LoadOrderGroupKey), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_LoadOrderGroupKey_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_TagId));
		if (_ptr_TagId) {
			NDR_PULL_ALLOC(ndr, r->in.TagId);
		} else {
			r->in.TagId = NULL;
		}
		if (r->in.TagId) {
			_mem_save_TagId_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.TagId, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.TagId));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_TagId_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dependencies));
		if (_ptr_dependencies) {
			NDR_PULL_ALLOC(ndr, r->in.dependencies);
		} else {
			r->in.dependencies = NULL;
		}
		if (r->in.dependencies) {
			_mem_save_dependencies_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.dependencies, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.dependencies));
			NDR_PULL_ALLOC_N(ndr, r->in.dependencies, ndr_get_array_size(ndr, &r->in.dependencies));
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.dependencies, ndr_get_array_size(ndr, &r->in.dependencies)));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dependencies_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dependencies_size));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_service_start_name));
		if (_ptr_service_start_name) {
			NDR_PULL_ALLOC(ndr, r->in.service_start_name);
		} else {
			r->in.service_start_name = NULL;
		}
		if (r->in.service_start_name) {
			_mem_save_service_start_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.service_start_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.service_start_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.service_start_name));
			if (ndr_get_array_length(ndr, &r->in.service_start_name) > ndr_get_array_size(ndr, &r->in.service_start_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.service_start_name), ndr_get_array_length(ndr, &r->in.service_start_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.service_start_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.service_start_name, ndr_get_array_length(ndr, &r->in.service_start_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_service_start_name_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_password));
		if (_ptr_password) {
			NDR_PULL_ALLOC(ndr, r->in.password);
		} else {
			r->in.password = NULL;
		}
		if (r->in.password) {
			_mem_save_password_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.password, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.password));
			NDR_PULL_ALLOC_N(ndr, r->in.password, ndr_get_array_size(ndr, &r->in.password));
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.password, ndr_get_array_size(ndr, &r->in.password)));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_password_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.password_size));
		NDR_PULL_ALLOC(ndr, r->out.handle);
		ZERO_STRUCTP(r->out.handle);
		if (r->in.dependencies) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->in.dependencies, r->in.dependencies_size));
		}
		if (r->in.password) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->in.password, r->in.password_size));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_TagId));
		if (_ptr_TagId) {
			NDR_PULL_ALLOC(ndr, r->out.TagId);
		} else {
			r->out.TagId = NULL;
		}
		if (r->out.TagId) {
			_mem_save_TagId_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.TagId, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.TagId));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_TagId_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_CreateServiceW(struct ndr_print *ndr, const char *name, int flags, const struct svcctl_CreateServiceW *r)
{
	ndr_print_struct(ndr, name, "svcctl_CreateServiceW");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_CreateServiceW");
		ndr->depth++;
		ndr_print_ptr(ndr, "scmanager_handle", r->in.scmanager_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "scmanager_handle", r->in.scmanager_handle);
		ndr->depth--;
		ndr_print_string(ndr, "ServiceName", r->in.ServiceName);
		ndr_print_ptr(ndr, "DisplayName", r->in.DisplayName);
		ndr->depth++;
		if (r->in.DisplayName) {
			ndr_print_string(ndr, "DisplayName", r->in.DisplayName);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "desired_access", r->in.desired_access);
		ndr_print_uint32(ndr, "type", r->in.type);
		ndr_print_uint32(ndr, "start_type", r->in.start_type);
		ndr_print_uint32(ndr, "error_control", r->in.error_control);
		ndr_print_string(ndr, "binary_path", r->in.binary_path);
		ndr_print_ptr(ndr, "LoadOrderGroupKey", r->in.LoadOrderGroupKey);
		ndr->depth++;
		if (r->in.LoadOrderGroupKey) {
			ndr_print_string(ndr, "LoadOrderGroupKey", r->in.LoadOrderGroupKey);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "TagId", r->in.TagId);
		ndr->depth++;
		if (r->in.TagId) {
			ndr_print_uint32(ndr, "TagId", *r->in.TagId);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "dependencies", r->in.dependencies);
		ndr->depth++;
		if (r->in.dependencies) {
			ndr_print_array_uint8(ndr, "dependencies", r->in.dependencies, r->in.dependencies_size);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "dependencies_size", r->in.dependencies_size);
		ndr_print_ptr(ndr, "service_start_name", r->in.service_start_name);
		ndr->depth++;
		if (r->in.service_start_name) {
			ndr_print_string(ndr, "service_start_name", r->in.service_start_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "password", r->in.password);
		ndr->depth++;
		if (r->in.password) {
			ndr_print_array_uint8(ndr, "password", r->in.password, r->in.password_size);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "password_size", r->in.password_size);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_CreateServiceW");
		ndr->depth++;
		ndr_print_ptr(ndr, "TagId", r->out.TagId);
		ndr->depth++;
		if (r->out.TagId) {
			ndr_print_uint32(ndr, "TagId", *r->out.TagId);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->out.handle);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_EnumDependentServicesW(struct ndr_push *ndr, int flags, const struct svcctl_EnumDependentServicesW *r)
{
	if (flags & NDR_IN) {
		if (r->in.service == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.service));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.state));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.buf_size));
	}
	if (flags & NDR_OUT) {
		if (r->out.service_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.buf_size));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.service_status, r->in.buf_size));
		if (r->out.bytes_needed == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.bytes_needed));
		if (r->out.services_returned == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.services_returned));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_EnumDependentServicesW(struct ndr_pull *ndr, int flags, struct svcctl_EnumDependentServicesW *r)
{
	TALLOC_CTX *_mem_save_service_0;
	TALLOC_CTX *_mem_save_bytes_needed_0;
	TALLOC_CTX *_mem_save_services_returned_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.service);
		}
		_mem_save_service_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.service, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.service));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_service_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.state));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.buf_size));
		if (r->in.buf_size < 0 || r->in.buf_size > 0x40000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_PULL_ALLOC_N(ndr, r->out.service_status, r->in.buf_size);
		memset(r->out.service_status, 0, (r->in.buf_size) * sizeof(*r->out.service_status));
		NDR_PULL_ALLOC(ndr, r->out.bytes_needed);
		ZERO_STRUCTP(r->out.bytes_needed);
		NDR_PULL_ALLOC(ndr, r->out.services_returned);
		ZERO_STRUCTP(r->out.services_returned);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.service_status));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.service_status, ndr_get_array_size(ndr, &r->out.service_status));
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.service_status, ndr_get_array_size(ndr, &r->out.service_status)));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.bytes_needed);
		}
		_mem_save_bytes_needed_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.bytes_needed, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.bytes_needed));
		if (*r->out.bytes_needed < 0 || *r->out.bytes_needed > 0x40000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bytes_needed_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.services_returned);
		}
		_mem_save_services_returned_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.services_returned, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.services_returned));
		if (*r->out.services_returned < 0 || *r->out.services_returned > 0x40000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_services_returned_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.service_status) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->out.service_status, r->in.buf_size));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_EnumDependentServicesW(struct ndr_print *ndr, const char *name, int flags, const struct svcctl_EnumDependentServicesW *r)
{
	ndr_print_struct(ndr, name, "svcctl_EnumDependentServicesW");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_EnumDependentServicesW");
		ndr->depth++;
		ndr_print_ptr(ndr, "service", r->in.service);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "service", r->in.service);
		ndr->depth--;
		ndr_print_uint32(ndr, "state", r->in.state);
		ndr_print_uint32(ndr, "buf_size", r->in.buf_size);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_EnumDependentServicesW");
		ndr->depth++;
		ndr_print_ptr(ndr, "service_status", r->out.service_status);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "service_status", r->out.service_status, r->in.buf_size);
		ndr->depth--;
		ndr_print_ptr(ndr, "bytes_needed", r->out.bytes_needed);
		ndr->depth++;
		ndr_print_uint32(ndr, "bytes_needed", *r->out.bytes_needed);
		ndr->depth--;
		ndr_print_ptr(ndr, "services_returned", r->out.services_returned);
		ndr->depth++;
		ndr_print_uint32(ndr, "services_returned", *r->out.services_returned);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_EnumServicesStatusW(struct ndr_push *ndr, int flags, const struct svcctl_EnumServicesStatusW *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.type));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.state));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.buf_size));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.resume_handle));
		if (r->in.resume_handle) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.resume_handle));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.buf_size));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.service, r->in.buf_size));
		if (r->out.bytes_needed == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.bytes_needed));
		if (r->out.services_returned == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.services_returned));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.resume_handle));
		if (r->out.resume_handle) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.resume_handle));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_EnumServicesStatusW(struct ndr_pull *ndr, int flags, struct svcctl_EnumServicesStatusW *r)
{
	uint32_t _ptr_resume_handle;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_bytes_needed_0;
	TALLOC_CTX *_mem_save_services_returned_0;
	TALLOC_CTX *_mem_save_resume_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.type));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.state));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.buf_size));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_resume_handle));
		if (_ptr_resume_handle) {
			NDR_PULL_ALLOC(ndr, r->in.resume_handle);
		} else {
			r->in.resume_handle = NULL;
		}
		if (r->in.resume_handle) {
			_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.resume_handle, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.resume_handle));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.bytes_needed);
		ZERO_STRUCTP(r->out.bytes_needed);
		NDR_PULL_ALLOC(ndr, r->out.services_returned);
		ZERO_STRUCTP(r->out.services_returned);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.service));
		NDR_PULL_ALLOC_N(ndr, r->out.service, ndr_get_array_size(ndr, &r->out.service));
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.service, ndr_get_array_size(ndr, &r->out.service)));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.bytes_needed);
		}
		_mem_save_bytes_needed_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.bytes_needed, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.bytes_needed));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bytes_needed_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.services_returned);
		}
		_mem_save_services_returned_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.services_returned, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.services_returned));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_services_returned_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_resume_handle));
		if (_ptr_resume_handle) {
			NDR_PULL_ALLOC(ndr, r->out.resume_handle);
		} else {
			r->out.resume_handle = NULL;
		}
		if (r->out.resume_handle) {
			_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.resume_handle, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.resume_handle));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.service) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->out.service, r->in.buf_size));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_EnumServicesStatusW(struct ndr_print *ndr, const char *name, int flags, const struct svcctl_EnumServicesStatusW *r)
{
	ndr_print_struct(ndr, name, "svcctl_EnumServicesStatusW");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_EnumServicesStatusW");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "type", r->in.type);
		ndr_print_uint32(ndr, "state", r->in.state);
		ndr_print_uint32(ndr, "buf_size", r->in.buf_size);
		ndr_print_ptr(ndr, "resume_handle", r->in.resume_handle);
		ndr->depth++;
		if (r->in.resume_handle) {
			ndr_print_uint32(ndr, "resume_handle", *r->in.resume_handle);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_EnumServicesStatusW");
		ndr->depth++;
		ndr_print_array_uint8(ndr, "service", r->out.service, r->in.buf_size);
		ndr_print_ptr(ndr, "bytes_needed", r->out.bytes_needed);
		ndr->depth++;
		ndr_print_uint32(ndr, "bytes_needed", *r->out.bytes_needed);
		ndr->depth--;
		ndr_print_ptr(ndr, "services_returned", r->out.services_returned);
		ndr->depth++;
		ndr_print_uint32(ndr, "services_returned", *r->out.services_returned);
		ndr->depth--;
		ndr_print_ptr(ndr, "resume_handle", r->out.resume_handle);
		ndr->depth++;
		if (r->out.resume_handle) {
			ndr_print_uint32(ndr, "resume_handle", *r->out.resume_handle);
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_OpenSCManagerW(struct ndr_push *ndr, int flags, const struct svcctl_OpenSCManagerW *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.MachineName));
		if (r->in.MachineName) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.MachineName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.MachineName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.MachineName, ndr_charset_length(r->in.MachineName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.DatabaseName));
		if (r->in.DatabaseName) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.DatabaseName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.DatabaseName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.DatabaseName, ndr_charset_length(r->in.DatabaseName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_svcctl_MgrAccessMask(ndr, NDR_SCALARS, r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		if (r->out.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.handle));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_OpenSCManagerW(struct ndr_pull *ndr, int flags, struct svcctl_OpenSCManagerW *r)
{
	uint32_t _ptr_MachineName;
	uint32_t _ptr_DatabaseName;
	TALLOC_CTX *_mem_save_MachineName_0;
	TALLOC_CTX *_mem_save_DatabaseName_0;
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_MachineName));
		if (_ptr_MachineName) {
			NDR_PULL_ALLOC(ndr, r->in.MachineName);
		} else {
			r->in.MachineName = NULL;
		}
		if (r->in.MachineName) {
			_mem_save_MachineName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.MachineName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.MachineName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.MachineName));
			if (ndr_get_array_length(ndr, &r->in.MachineName) > ndr_get_array_size(ndr, &r->in.MachineName)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.MachineName), ndr_get_array_length(ndr, &r->in.MachineName));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.MachineName), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.MachineName, ndr_get_array_length(ndr, &r->in.MachineName), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_MachineName_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_DatabaseName));
		if (_ptr_DatabaseName) {
			NDR_PULL_ALLOC(ndr, r->in.DatabaseName);
		} else {
			r->in.DatabaseName = NULL;
		}
		if (r->in.DatabaseName) {
			_mem_save_DatabaseName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.DatabaseName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.DatabaseName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.DatabaseName));
			if (ndr_get_array_length(ndr, &r->in.DatabaseName) > ndr_get_array_size(ndr, &r->in.DatabaseName)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.DatabaseName), ndr_get_array_length(ndr, &r->in.DatabaseName));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.DatabaseName), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.DatabaseName, ndr_get_array_length(ndr, &r->in.DatabaseName), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_DatabaseName_0, 0);
		}
		NDR_CHECK(ndr_pull_svcctl_MgrAccessMask(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_PULL_ALLOC(ndr, r->out.handle);
		ZERO_STRUCTP(r->out.handle);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_OpenSCManagerW(struct ndr_print *ndr, const char *name, int flags, const struct svcctl_OpenSCManagerW *r)
{
	ndr_print_struct(ndr, name, "svcctl_OpenSCManagerW");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_OpenSCManagerW");
		ndr->depth++;
		ndr_print_ptr(ndr, "MachineName", r->in.MachineName);
		ndr->depth++;
		if (r->in.MachineName) {
			ndr_print_string(ndr, "MachineName", r->in.MachineName);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "DatabaseName", r->in.DatabaseName);
		ndr->depth++;
		if (r->in.DatabaseName) {
			ndr_print_string(ndr, "DatabaseName", r->in.DatabaseName);
		}
		ndr->depth--;
		ndr_print_svcctl_MgrAccessMask(ndr, "access_mask", r->in.access_mask);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_OpenSCManagerW");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->out.handle);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_OpenServiceW(struct ndr_push *ndr, int flags, const struct svcctl_OpenServiceW *r)
{
	if (flags & NDR_IN) {
		if (r->in.scmanager_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.scmanager_handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.ServiceName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.ServiceName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.ServiceName, ndr_charset_length(r->in.ServiceName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_svcctl_ServiceAccessMask(ndr, NDR_SCALARS, r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		if (r->out.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.handle));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_OpenServiceW(struct ndr_pull *ndr, int flags, struct svcctl_OpenServiceW *r)
{
	TALLOC_CTX *_mem_save_scmanager_handle_0;
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.scmanager_handle);
		}
		_mem_save_scmanager_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.scmanager_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.scmanager_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_scmanager_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.ServiceName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.ServiceName));
		if (ndr_get_array_length(ndr, &r->in.ServiceName) > ndr_get_array_size(ndr, &r->in.ServiceName)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.ServiceName), ndr_get_array_length(ndr, &r->in.ServiceName));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.ServiceName), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.ServiceName, ndr_get_array_length(ndr, &r->in.ServiceName), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_svcctl_ServiceAccessMask(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_PULL_ALLOC(ndr, r->out.handle);
		ZERO_STRUCTP(r->out.handle);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_OpenServiceW(struct ndr_print *ndr, const char *name, int flags, const struct svcctl_OpenServiceW *r)
{
	ndr_print_struct(ndr, name, "svcctl_OpenServiceW");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_OpenServiceW");
		ndr->depth++;
		ndr_print_ptr(ndr, "scmanager_handle", r->in.scmanager_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "scmanager_handle", r->in.scmanager_handle);
		ndr->depth--;
		ndr_print_string(ndr, "ServiceName", r->in.ServiceName);
		ndr_print_svcctl_ServiceAccessMask(ndr, "access_mask", r->in.access_mask);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_OpenServiceW");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->out.handle);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_QueryServiceConfigW(struct ndr_push *ndr, int flags, const struct svcctl_QueryServiceConfigW *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.buf_size));
	}
	if (flags & NDR_OUT) {
		if (r->out.query == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_QUERY_SERVICE_CONFIG(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.query));
		if (r->out.bytes_needed == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.bytes_needed));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_QueryServiceConfigW(struct ndr_pull *ndr, int flags, struct svcctl_QueryServiceConfigW *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_query_0;
	TALLOC_CTX *_mem_save_bytes_needed_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.buf_size));
		if (r->in.buf_size < 0 || r->in.buf_size > 8192) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_PULL_ALLOC(ndr, r->out.query);
		ZERO_STRUCTP(r->out.query);
		NDR_PULL_ALLOC(ndr, r->out.bytes_needed);
		ZERO_STRUCTP(r->out.bytes_needed);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.query);
		}
		_mem_save_query_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.query, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_QUERY_SERVICE_CONFIG(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.query));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_query_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.bytes_needed);
		}
		_mem_save_bytes_needed_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.bytes_needed, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.bytes_needed));
		if (*r->out.bytes_needed < 0 || *r->out.bytes_needed > 8192) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bytes_needed_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_QueryServiceConfigW(struct ndr_print *ndr, const char *name, int flags, const struct svcctl_QueryServiceConfigW *r)
{
	ndr_print_struct(ndr, name, "svcctl_QueryServiceConfigW");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_QueryServiceConfigW");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "buf_size", r->in.buf_size);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_QueryServiceConfigW");
		ndr->depth++;
		ndr_print_ptr(ndr, "query", r->out.query);
		ndr->depth++;
		ndr_print_QUERY_SERVICE_CONFIG(ndr, "query", r->out.query);
		ndr->depth--;
		ndr_print_ptr(ndr, "bytes_needed", r->out.bytes_needed);
		ndr->depth++;
		ndr_print_uint32(ndr, "bytes_needed", *r->out.bytes_needed);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_QueryServiceLockStatusW(struct ndr_push *ndr, int flags, const struct svcctl_QueryServiceLockStatusW *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.buf_size));
	}
	if (flags & NDR_OUT) {
		if (r->out.lock_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_SERVICE_LOCK_STATUS(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.lock_status));
		if (r->out.required_buf_size == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.required_buf_size));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_QueryServiceLockStatusW(struct ndr_pull *ndr, int flags, struct svcctl_QueryServiceLockStatusW *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_lock_status_0;
	TALLOC_CTX *_mem_save_required_buf_size_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.buf_size));
		NDR_PULL_ALLOC(ndr, r->out.lock_status);
		ZERO_STRUCTP(r->out.lock_status);
		NDR_PULL_ALLOC(ndr, r->out.required_buf_size);
		ZERO_STRUCTP(r->out.required_buf_size);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lock_status);
		}
		_mem_save_lock_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lock_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_SERVICE_LOCK_STATUS(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.lock_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lock_status_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.required_buf_size);
		}
		_mem_save_required_buf_size_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.required_buf_size, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.required_buf_size));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_required_buf_size_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_QueryServiceLockStatusW(struct ndr_print *ndr, const char *name, int flags, const struct svcctl_QueryServiceLockStatusW *r)
{
	ndr_print_struct(ndr, name, "svcctl_QueryServiceLockStatusW");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_QueryServiceLockStatusW");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "buf_size", r->in.buf_size);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_QueryServiceLockStatusW");
		ndr->depth++;
		ndr_print_ptr(ndr, "lock_status", r->out.lock_status);
		ndr->depth++;
		ndr_print_SERVICE_LOCK_STATUS(ndr, "lock_status", r->out.lock_status);
		ndr->depth--;
		ndr_print_ptr(ndr, "required_buf_size", r->out.required_buf_size);
		ndr->depth++;
		ndr_print_uint32(ndr, "required_buf_size", *r->out.required_buf_size);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_StartServiceW(struct ndr_push *ndr, int flags, const struct svcctl_StartServiceW *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.NumArgs));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.Arguments));
		if (r->in.Arguments) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.Arguments, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.Arguments, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.Arguments, ndr_charset_length(r->in.Arguments, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_StartServiceW(struct ndr_pull *ndr, int flags, struct svcctl_StartServiceW *r)
{
	uint32_t _ptr_Arguments;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_Arguments_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.NumArgs));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_Arguments));
		if (_ptr_Arguments) {
			NDR_PULL_ALLOC(ndr, r->in.Arguments);
		} else {
			r->in.Arguments = NULL;
		}
		if (r->in.Arguments) {
			_mem_save_Arguments_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.Arguments, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.Arguments));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.Arguments));
			if (ndr_get_array_length(ndr, &r->in.Arguments) > ndr_get_array_size(ndr, &r->in.Arguments)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.Arguments), ndr_get_array_length(ndr, &r->in.Arguments));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.Arguments), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.Arguments, ndr_get_array_length(ndr, &r->in.Arguments), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Arguments_0, 0);
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_StartServiceW(struct ndr_print *ndr, const char *name, int flags, const struct svcctl_StartServiceW *r)
{
	ndr_print_struct(ndr, name, "svcctl_StartServiceW");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_StartServiceW");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "NumArgs", r->in.NumArgs);
		ndr_print_ptr(ndr, "Arguments", r->in.Arguments);
		ndr->depth++;
		if (r->in.Arguments) {
			ndr_print_string(ndr, "Arguments", r->in.Arguments);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_StartServiceW");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_GetServiceDisplayNameW(struct ndr_push *ndr, int flags, const struct svcctl_GetServiceDisplayNameW *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.service_name));
		if (r->in.service_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.service_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.service_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.service_name, ndr_charset_length(r->in.service_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.display_name_length));
		if (r->in.display_name_length) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.display_name_length));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.display_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.display_name));
		if (*r->out.display_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(*r->out.display_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(*r->out.display_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.display_name, ndr_charset_length(*r->out.display_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.display_name_length));
		if (r->out.display_name_length) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.display_name_length));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_GetServiceDisplayNameW(struct ndr_pull *ndr, int flags, struct svcctl_GetServiceDisplayNameW *r)
{
	uint32_t _ptr_service_name;
	uint32_t _ptr_display_name;
	uint32_t _ptr_display_name_length;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_service_name_0;
	TALLOC_CTX *_mem_save_display_name_0;
	TALLOC_CTX *_mem_save_display_name_1;
	TALLOC_CTX *_mem_save_display_name_length_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_service_name));
		if (_ptr_service_name) {
			NDR_PULL_ALLOC(ndr, r->in.service_name);
		} else {
			r->in.service_name = NULL;
		}
		if (r->in.service_name) {
			_mem_save_service_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.service_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.service_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.service_name));
			if (ndr_get_array_length(ndr, &r->in.service_name) > ndr_get_array_size(ndr, &r->in.service_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.service_name), ndr_get_array_length(ndr, &r->in.service_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.service_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.service_name, ndr_get_array_length(ndr, &r->in.service_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_service_name_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_display_name_length));
		if (_ptr_display_name_length) {
			NDR_PULL_ALLOC(ndr, r->in.display_name_length);
		} else {
			r->in.display_name_length = NULL;
		}
		if (r->in.display_name_length) {
			_mem_save_display_name_length_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.display_name_length, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.display_name_length));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_display_name_length_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.display_name);
		ZERO_STRUCTP(r->out.display_name);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.display_name);
		}
		_mem_save_display_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.display_name, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_display_name));
		if (_ptr_display_name) {
			NDR_PULL_ALLOC(ndr, *r->out.display_name);
		} else {
			*r->out.display_name = NULL;
		}
		if (*r->out.display_name) {
			_mem_save_display_name_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.display_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.display_name));
			NDR_CHECK(ndr_pull_array_length(ndr, r->out.display_name));
			if (ndr_get_array_length(ndr, r->out.display_name) > ndr_get_array_size(ndr, r->out.display_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, r->out.display_name), ndr_get_array_length(ndr, r->out.display_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, r->out.display_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.display_name, ndr_get_array_length(ndr, r->out.display_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_display_name_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_display_name_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_display_name_length));
		if (_ptr_display_name_length) {
			NDR_PULL_ALLOC(ndr, r->out.display_name_length);
		} else {
			r->out.display_name_length = NULL;
		}
		if (r->out.display_name_length) {
			_mem_save_display_name_length_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.display_name_length, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.display_name_length));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_display_name_length_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_GetServiceDisplayNameW(struct ndr_print *ndr, const char *name, int flags, const struct svcctl_GetServiceDisplayNameW *r)
{
	ndr_print_struct(ndr, name, "svcctl_GetServiceDisplayNameW");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_GetServiceDisplayNameW");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "service_name", r->in.service_name);
		ndr->depth++;
		if (r->in.service_name) {
			ndr_print_string(ndr, "service_name", r->in.service_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "display_name_length", r->in.display_name_length);
		ndr->depth++;
		if (r->in.display_name_length) {
			ndr_print_uint32(ndr, "display_name_length", *r->in.display_name_length);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_GetServiceDisplayNameW");
		ndr->depth++;
		ndr_print_ptr(ndr, "display_name", r->out.display_name);
		ndr->depth++;
		ndr_print_ptr(ndr, "display_name", *r->out.display_name);
		ndr->depth++;
		if (*r->out.display_name) {
			ndr_print_string(ndr, "display_name", *r->out.display_name);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "display_name_length", r->out.display_name_length);
		ndr->depth++;
		if (r->out.display_name_length) {
			ndr_print_uint32(ndr, "display_name_length", *r->out.display_name_length);
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_GetServiceKeyNameW(struct ndr_push *ndr, int flags, const struct svcctl_GetServiceKeyNameW *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.service_name));
		if (r->in.service_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.service_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.service_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.service_name, ndr_charset_length(r->in.service_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.display_name_length));
		if (r->in.display_name_length) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.display_name_length));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.key_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.key_name));
		if (*r->out.key_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(*r->out.key_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(*r->out.key_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.key_name, ndr_charset_length(*r->out.key_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.display_name_length));
		if (r->out.display_name_length) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.display_name_length));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_GetServiceKeyNameW(struct ndr_pull *ndr, int flags, struct svcctl_GetServiceKeyNameW *r)
{
	uint32_t _ptr_service_name;
	uint32_t _ptr_key_name;
	uint32_t _ptr_display_name_length;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_service_name_0;
	TALLOC_CTX *_mem_save_key_name_0;
	TALLOC_CTX *_mem_save_key_name_1;
	TALLOC_CTX *_mem_save_display_name_length_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_service_name));
		if (_ptr_service_name) {
			NDR_PULL_ALLOC(ndr, r->in.service_name);
		} else {
			r->in.service_name = NULL;
		}
		if (r->in.service_name) {
			_mem_save_service_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.service_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.service_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.service_name));
			if (ndr_get_array_length(ndr, &r->in.service_name) > ndr_get_array_size(ndr, &r->in.service_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.service_name), ndr_get_array_length(ndr, &r->in.service_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.service_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.service_name, ndr_get_array_length(ndr, &r->in.service_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_service_name_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_display_name_length));
		if (_ptr_display_name_length) {
			NDR_PULL_ALLOC(ndr, r->in.display_name_length);
		} else {
			r->in.display_name_length = NULL;
		}
		if (r->in.display_name_length) {
			_mem_save_display_name_length_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.display_name_length, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.display_name_length));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_display_name_length_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.key_name);
		ZERO_STRUCTP(r->out.key_name);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.key_name);
		}
		_mem_save_key_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.key_name, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_key_name));
		if (_ptr_key_name) {
			NDR_PULL_ALLOC(ndr, *r->out.key_name);
		} else {
			*r->out.key_name = NULL;
		}
		if (*r->out.key_name) {
			_mem_save_key_name_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.key_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.key_name));
			NDR_CHECK(ndr_pull_array_length(ndr, r->out.key_name));
			if (ndr_get_array_length(ndr, r->out.key_name) > ndr_get_array_size(ndr, r->out.key_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, r->out.key_name), ndr_get_array_length(ndr, r->out.key_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, r->out.key_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.key_name, ndr_get_array_length(ndr, r->out.key_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_key_name_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_key_name_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_display_name_length));
		if (_ptr_display_name_length) {
			NDR_PULL_ALLOC(ndr, r->out.display_name_length);
		} else {
			r->out.display_name_length = NULL;
		}
		if (r->out.display_name_length) {
			_mem_save_display_name_length_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.display_name_length, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.display_name_length));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_display_name_length_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_GetServiceKeyNameW(struct ndr_print *ndr, const char *name, int flags, const struct svcctl_GetServiceKeyNameW *r)
{
	ndr_print_struct(ndr, name, "svcctl_GetServiceKeyNameW");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_GetServiceKeyNameW");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "service_name", r->in.service_name);
		ndr->depth++;
		if (r->in.service_name) {
			ndr_print_string(ndr, "service_name", r->in.service_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "display_name_length", r->in.display_name_length);
		ndr->depth++;
		if (r->in.display_name_length) {
			ndr_print_uint32(ndr, "display_name_length", *r->in.display_name_length);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_GetServiceKeyNameW");
		ndr->depth++;
		ndr_print_ptr(ndr, "key_name", r->out.key_name);
		ndr->depth++;
		ndr_print_ptr(ndr, "key_name", *r->out.key_name);
		ndr->depth++;
		if (*r->out.key_name) {
			ndr_print_string(ndr, "key_name", *r->out.key_name);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "display_name_length", r->out.display_name_length);
		ndr->depth++;
		if (r->out.display_name_length) {
			ndr_print_uint32(ndr, "display_name_length", *r->out.display_name_length);
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_SCSetServiceBitsA(struct ndr_push *ndr, int flags, const struct svcctl_SCSetServiceBitsA *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.bits));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.bitson));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.immediate));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_SCSetServiceBitsA(struct ndr_pull *ndr, int flags, struct svcctl_SCSetServiceBitsA *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.bits));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.bitson));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.immediate));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_SCSetServiceBitsA(struct ndr_print *ndr, const char *name, int flags, const struct svcctl_SCSetServiceBitsA *r)
{
	ndr_print_struct(ndr, name, "svcctl_SCSetServiceBitsA");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_SCSetServiceBitsA");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "bits", r->in.bits);
		ndr_print_uint32(ndr, "bitson", r->in.bitson);
		ndr_print_uint32(ndr, "immediate", r->in.immediate);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_SCSetServiceBitsA");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_ChangeServiceConfigA(struct ndr_push *ndr, int flags, const struct svcctl_ChangeServiceConfigA *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.type));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.start));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.error));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.binary_path));
		if (r->in.binary_path) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.binary_path, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.binary_path, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.binary_path, ndr_charset_length(r->in.binary_path, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.load_order_group));
		if (r->in.load_order_group) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.load_order_group, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.load_order_group, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.load_order_group, ndr_charset_length(r->in.load_order_group, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.dependencies));
		if (r->in.dependencies) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.dependencies, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.dependencies, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.dependencies, ndr_charset_length(r->in.dependencies, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.service_start_name));
		if (r->in.service_start_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.service_start_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.service_start_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.service_start_name, ndr_charset_length(r->in.service_start_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.password));
		if (r->in.password) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.password, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.password, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.password, ndr_charset_length(r->in.password, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.display_name));
		if (r->in.display_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.display_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.display_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.display_name, ndr_charset_length(r->in.display_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.tag_id == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.tag_id));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_ChangeServiceConfigA(struct ndr_pull *ndr, int flags, struct svcctl_ChangeServiceConfigA *r)
{
	uint32_t _ptr_binary_path;
	uint32_t _ptr_load_order_group;
	uint32_t _ptr_dependencies;
	uint32_t _ptr_service_start_name;
	uint32_t _ptr_password;
	uint32_t _ptr_display_name;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_binary_path_0;
	TALLOC_CTX *_mem_save_load_order_group_0;
	TALLOC_CTX *_mem_save_tag_id_0;
	TALLOC_CTX *_mem_save_dependencies_0;
	TALLOC_CTX *_mem_save_service_start_name_0;
	TALLOC_CTX *_mem_save_password_0;
	TALLOC_CTX *_mem_save_display_name_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.type));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.start));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.error));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_binary_path));
		if (_ptr_binary_path) {
			NDR_PULL_ALLOC(ndr, r->in.binary_path);
		} else {
			r->in.binary_path = NULL;
		}
		if (r->in.binary_path) {
			_mem_save_binary_path_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.binary_path, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.binary_path));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.binary_path));
			if (ndr_get_array_length(ndr, &r->in.binary_path) > ndr_get_array_size(ndr, &r->in.binary_path)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.binary_path), ndr_get_array_length(ndr, &r->in.binary_path));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.binary_path), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.binary_path, ndr_get_array_length(ndr, &r->in.binary_path), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_binary_path_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_load_order_group));
		if (_ptr_load_order_group) {
			NDR_PULL_ALLOC(ndr, r->in.load_order_group);
		} else {
			r->in.load_order_group = NULL;
		}
		if (r->in.load_order_group) {
			_mem_save_load_order_group_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.load_order_group, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.load_order_group));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.load_order_group));
			if (ndr_get_array_length(ndr, &r->in.load_order_group) > ndr_get_array_size(ndr, &r->in.load_order_group)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.load_order_group), ndr_get_array_length(ndr, &r->in.load_order_group));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.load_order_group), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.load_order_group, ndr_get_array_length(ndr, &r->in.load_order_group), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_load_order_group_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dependencies));
		if (_ptr_dependencies) {
			NDR_PULL_ALLOC(ndr, r->in.dependencies);
		} else {
			r->in.dependencies = NULL;
		}
		if (r->in.dependencies) {
			_mem_save_dependencies_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.dependencies, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.dependencies));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.dependencies));
			if (ndr_get_array_length(ndr, &r->in.dependencies) > ndr_get_array_size(ndr, &r->in.dependencies)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.dependencies), ndr_get_array_length(ndr, &r->in.dependencies));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.dependencies), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.dependencies, ndr_get_array_length(ndr, &r->in.dependencies), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dependencies_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_service_start_name));
		if (_ptr_service_start_name) {
			NDR_PULL_ALLOC(ndr, r->in.service_start_name);
		} else {
			r->in.service_start_name = NULL;
		}
		if (r->in.service_start_name) {
			_mem_save_service_start_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.service_start_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.service_start_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.service_start_name));
			if (ndr_get_array_length(ndr, &r->in.service_start_name) > ndr_get_array_size(ndr, &r->in.service_start_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.service_start_name), ndr_get_array_length(ndr, &r->in.service_start_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.service_start_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.service_start_name, ndr_get_array_length(ndr, &r->in.service_start_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_service_start_name_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_password));
		if (_ptr_password) {
			NDR_PULL_ALLOC(ndr, r->in.password);
		} else {
			r->in.password = NULL;
		}
		if (r->in.password) {
			_mem_save_password_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.password, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.password));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.password));
			if (ndr_get_array_length(ndr, &r->in.password) > ndr_get_array_size(ndr, &r->in.password)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.password), ndr_get_array_length(ndr, &r->in.password));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.password), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.password, ndr_get_array_length(ndr, &r->in.password), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_password_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_display_name));
		if (_ptr_display_name) {
			NDR_PULL_ALLOC(ndr, r->in.display_name);
		} else {
			r->in.display_name = NULL;
		}
		if (r->in.display_name) {
			_mem_save_display_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.display_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.display_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.display_name));
			if (ndr_get_array_length(ndr, &r->in.display_name) > ndr_get_array_size(ndr, &r->in.display_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.display_name), ndr_get_array_length(ndr, &r->in.display_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.display_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.display_name, ndr_get_array_length(ndr, &r->in.display_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_display_name_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.tag_id);
		ZERO_STRUCTP(r->out.tag_id);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.tag_id);
		}
		_mem_save_tag_id_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.tag_id, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.tag_id));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_tag_id_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_ChangeServiceConfigA(struct ndr_print *ndr, const char *name, int flags, const struct svcctl_ChangeServiceConfigA *r)
{
	ndr_print_struct(ndr, name, "svcctl_ChangeServiceConfigA");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_ChangeServiceConfigA");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "type", r->in.type);
		ndr_print_uint32(ndr, "start", r->in.start);
		ndr_print_uint32(ndr, "error", r->in.error);
		ndr_print_ptr(ndr, "binary_path", r->in.binary_path);
		ndr->depth++;
		if (r->in.binary_path) {
			ndr_print_string(ndr, "binary_path", r->in.binary_path);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "load_order_group", r->in.load_order_group);
		ndr->depth++;
		if (r->in.load_order_group) {
			ndr_print_string(ndr, "load_order_group", r->in.load_order_group);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "dependencies", r->in.dependencies);
		ndr->depth++;
		if (r->in.dependencies) {
			ndr_print_string(ndr, "dependencies", r->in.dependencies);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "service_start_name", r->in.service_start_name);
		ndr->depth++;
		if (r->in.service_start_name) {
			ndr_print_string(ndr, "service_start_name", r->in.service_start_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "password", r->in.password);
		ndr->depth++;
		if (r->in.password) {
			ndr_print_string(ndr, "password", r->in.password);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "display_name", r->in.display_name);
		ndr->depth++;
		if (r->in.display_name) {
			ndr_print_string(ndr, "display_name", r->in.display_name);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_ChangeServiceConfigA");
		ndr->depth++;
		ndr_print_ptr(ndr, "tag_id", r->out.tag_id);
		ndr->depth++;
		ndr_print_uint32(ndr, "tag_id", *r->out.tag_id);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_CreateServiceA(struct ndr_push *ndr, int flags, const struct svcctl_CreateServiceA *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.ServiceName));
		if (r->in.ServiceName) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.ServiceName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.ServiceName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.ServiceName, ndr_charset_length(r->in.ServiceName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.DisplayName));
		if (r->in.DisplayName) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.DisplayName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.DisplayName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.DisplayName, ndr_charset_length(r->in.DisplayName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.desired_access));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.type));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.start_type));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.error_control));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.binary_path));
		if (r->in.binary_path) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.binary_path, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.binary_path, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.binary_path, ndr_charset_length(r->in.binary_path, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.LoadOrderGroupKey));
		if (r->in.LoadOrderGroupKey) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.LoadOrderGroupKey, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.LoadOrderGroupKey, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.LoadOrderGroupKey, ndr_charset_length(r->in.LoadOrderGroupKey, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.dependencies));
		if (r->in.dependencies) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.dependencies, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.dependencies, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.dependencies, ndr_charset_length(r->in.dependencies, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.service_start_name));
		if (r->in.service_start_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.service_start_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.service_start_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.service_start_name, ndr_charset_length(r->in.service_start_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.password));
		if (r->in.password) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.password, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.password, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.password, ndr_charset_length(r->in.password, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.TagId));
		if (r->out.TagId) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.TagId));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_CreateServiceA(struct ndr_pull *ndr, int flags, struct svcctl_CreateServiceA *r)
{
	uint32_t _ptr_ServiceName;
	uint32_t _ptr_DisplayName;
	uint32_t _ptr_binary_path;
	uint32_t _ptr_LoadOrderGroupKey;
	uint32_t _ptr_TagId;
	uint32_t _ptr_dependencies;
	uint32_t _ptr_service_start_name;
	uint32_t _ptr_password;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_ServiceName_0;
	TALLOC_CTX *_mem_save_DisplayName_0;
	TALLOC_CTX *_mem_save_binary_path_0;
	TALLOC_CTX *_mem_save_LoadOrderGroupKey_0;
	TALLOC_CTX *_mem_save_TagId_0;
	TALLOC_CTX *_mem_save_dependencies_0;
	TALLOC_CTX *_mem_save_service_start_name_0;
	TALLOC_CTX *_mem_save_password_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ServiceName));
		if (_ptr_ServiceName) {
			NDR_PULL_ALLOC(ndr, r->in.ServiceName);
		} else {
			r->in.ServiceName = NULL;
		}
		if (r->in.ServiceName) {
			_mem_save_ServiceName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.ServiceName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.ServiceName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.ServiceName));
			if (ndr_get_array_length(ndr, &r->in.ServiceName) > ndr_get_array_size(ndr, &r->in.ServiceName)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.ServiceName), ndr_get_array_length(ndr, &r->in.ServiceName));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.ServiceName), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.ServiceName, ndr_get_array_length(ndr, &r->in.ServiceName), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ServiceName_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_DisplayName));
		if (_ptr_DisplayName) {
			NDR_PULL_ALLOC(ndr, r->in.DisplayName);
		} else {
			r->in.DisplayName = NULL;
		}
		if (r->in.DisplayName) {
			_mem_save_DisplayName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.DisplayName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.DisplayName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.DisplayName));
			if (ndr_get_array_length(ndr, &r->in.DisplayName) > ndr_get_array_size(ndr, &r->in.DisplayName)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.DisplayName), ndr_get_array_length(ndr, &r->in.DisplayName));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.DisplayName), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.DisplayName, ndr_get_array_length(ndr, &r->in.DisplayName), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_DisplayName_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.desired_access));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.type));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.start_type));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.error_control));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_binary_path));
		if (_ptr_binary_path) {
			NDR_PULL_ALLOC(ndr, r->in.binary_path);
		} else {
			r->in.binary_path = NULL;
		}
		if (r->in.binary_path) {
			_mem_save_binary_path_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.binary_path, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.binary_path));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.binary_path));
			if (ndr_get_array_length(ndr, &r->in.binary_path) > ndr_get_array_size(ndr, &r->in.binary_path)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.binary_path), ndr_get_array_length(ndr, &r->in.binary_path));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.binary_path), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.binary_path, ndr_get_array_length(ndr, &r->in.binary_path), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_binary_path_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_LoadOrderGroupKey));
		if (_ptr_LoadOrderGroupKey) {
			NDR_PULL_ALLOC(ndr, r->in.LoadOrderGroupKey);
		} else {
			r->in.LoadOrderGroupKey = NULL;
		}
		if (r->in.LoadOrderGroupKey) {
			_mem_save_LoadOrderGroupKey_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.LoadOrderGroupKey, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.LoadOrderGroupKey));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.LoadOrderGroupKey));
			if (ndr_get_array_length(ndr, &r->in.LoadOrderGroupKey) > ndr_get_array_size(ndr, &r->in.LoadOrderGroupKey)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.LoadOrderGroupKey), ndr_get_array_length(ndr, &r->in.LoadOrderGroupKey));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.LoadOrderGroupKey), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.LoadOrderGroupKey, ndr_get_array_length(ndr, &r->in.LoadOrderGroupKey), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_LoadOrderGroupKey_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dependencies));
		if (_ptr_dependencies) {
			NDR_PULL_ALLOC(ndr, r->in.dependencies);
		} else {
			r->in.dependencies = NULL;
		}
		if (r->in.dependencies) {
			_mem_save_dependencies_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.dependencies, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.dependencies));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.dependencies));
			if (ndr_get_array_length(ndr, &r->in.dependencies) > ndr_get_array_size(ndr, &r->in.dependencies)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.dependencies), ndr_get_array_length(ndr, &r->in.dependencies));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.dependencies), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.dependencies, ndr_get_array_length(ndr, &r->in.dependencies), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dependencies_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_service_start_name));
		if (_ptr_service_start_name) {
			NDR_PULL_ALLOC(ndr, r->in.service_start_name);
		} else {
			r->in.service_start_name = NULL;
		}
		if (r->in.service_start_name) {
			_mem_save_service_start_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.service_start_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.service_start_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.service_start_name));
			if (ndr_get_array_length(ndr, &r->in.service_start_name) > ndr_get_array_size(ndr, &r->in.service_start_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.service_start_name), ndr_get_array_length(ndr, &r->in.service_start_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.service_start_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.service_start_name, ndr_get_array_length(ndr, &r->in.service_start_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_service_start_name_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_password));
		if (_ptr_password) {
			NDR_PULL_ALLOC(ndr, r->in.password);
		} else {
			r->in.password = NULL;
		}
		if (r->in.password) {
			_mem_save_password_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.password, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.password));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.password));
			if (ndr_get_array_length(ndr, &r->in.password) > ndr_get_array_size(ndr, &r->in.password)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.password), ndr_get_array_length(ndr, &r->in.password));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.password), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.password, ndr_get_array_length(ndr, &r->in.password), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_password_0, 0);
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_TagId));
		if (_ptr_TagId) {
			NDR_PULL_ALLOC(ndr, r->out.TagId);
		} else {
			r->out.TagId = NULL;
		}
		if (r->out.TagId) {
			_mem_save_TagId_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.TagId, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.TagId));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_TagId_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_CreateServiceA(struct ndr_print *ndr, const char *name, int flags, const struct svcctl_CreateServiceA *r)
{
	ndr_print_struct(ndr, name, "svcctl_CreateServiceA");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_CreateServiceA");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "ServiceName", r->in.ServiceName);
		ndr->depth++;
		if (r->in.ServiceName) {
			ndr_print_string(ndr, "ServiceName", r->in.ServiceName);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "DisplayName", r->in.DisplayName);
		ndr->depth++;
		if (r->in.DisplayName) {
			ndr_print_string(ndr, "DisplayName", r->in.DisplayName);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "desired_access", r->in.desired_access);
		ndr_print_uint32(ndr, "type", r->in.type);
		ndr_print_uint32(ndr, "start_type", r->in.start_type);
		ndr_print_uint32(ndr, "error_control", r->in.error_control);
		ndr_print_ptr(ndr, "binary_path", r->in.binary_path);
		ndr->depth++;
		if (r->in.binary_path) {
			ndr_print_string(ndr, "binary_path", r->in.binary_path);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "LoadOrderGroupKey", r->in.LoadOrderGroupKey);
		ndr->depth++;
		if (r->in.LoadOrderGroupKey) {
			ndr_print_string(ndr, "LoadOrderGroupKey", r->in.LoadOrderGroupKey);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "dependencies", r->in.dependencies);
		ndr->depth++;
		if (r->in.dependencies) {
			ndr_print_string(ndr, "dependencies", r->in.dependencies);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "service_start_name", r->in.service_start_name);
		ndr->depth++;
		if (r->in.service_start_name) {
			ndr_print_string(ndr, "service_start_name", r->in.service_start_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "password", r->in.password);
		ndr->depth++;
		if (r->in.password) {
			ndr_print_string(ndr, "password", r->in.password);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_CreateServiceA");
		ndr->depth++;
		ndr_print_ptr(ndr, "TagId", r->out.TagId);
		ndr->depth++;
		if (r->out.TagId) {
			ndr_print_uint32(ndr, "TagId", *r->out.TagId);
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_EnumDependentServicesA(struct ndr_push *ndr, int flags, const struct svcctl_EnumDependentServicesA *r)
{
	if (flags & NDR_IN) {
		if (r->in.service == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.service));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.state));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.buf_size));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.service_status));
		if (r->out.service_status) {
			NDR_CHECK(ndr_push_ENUM_SERVICE_STATUS(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.service_status));
		}
		if (r->out.bytes_needed == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.bytes_needed));
		if (r->out.services_returned == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.services_returned));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_EnumDependentServicesA(struct ndr_pull *ndr, int flags, struct svcctl_EnumDependentServicesA *r)
{
	uint32_t _ptr_service_status;
	TALLOC_CTX *_mem_save_service_0;
	TALLOC_CTX *_mem_save_service_status_0;
	TALLOC_CTX *_mem_save_bytes_needed_0;
	TALLOC_CTX *_mem_save_services_returned_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.service);
		}
		_mem_save_service_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.service, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.service));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_service_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.state));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.buf_size));
		NDR_PULL_ALLOC(ndr, r->out.bytes_needed);
		ZERO_STRUCTP(r->out.bytes_needed);
		NDR_PULL_ALLOC(ndr, r->out.services_returned);
		ZERO_STRUCTP(r->out.services_returned);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_service_status));
		if (_ptr_service_status) {
			NDR_PULL_ALLOC(ndr, r->out.service_status);
		} else {
			r->out.service_status = NULL;
		}
		if (r->out.service_status) {
			_mem_save_service_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.service_status, 0);
			NDR_CHECK(ndr_pull_ENUM_SERVICE_STATUS(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.service_status));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_service_status_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.bytes_needed);
		}
		_mem_save_bytes_needed_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.bytes_needed, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.bytes_needed));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bytes_needed_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.services_returned);
		}
		_mem_save_services_returned_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.services_returned, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.services_returned));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_services_returned_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_EnumDependentServicesA(struct ndr_print *ndr, const char *name, int flags, const struct svcctl_EnumDependentServicesA *r)
{
	ndr_print_struct(ndr, name, "svcctl_EnumDependentServicesA");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_EnumDependentServicesA");
		ndr->depth++;
		ndr_print_ptr(ndr, "service", r->in.service);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "service", r->in.service);
		ndr->depth--;
		ndr_print_uint32(ndr, "state", r->in.state);
		ndr_print_uint32(ndr, "buf_size", r->in.buf_size);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_EnumDependentServicesA");
		ndr->depth++;
		ndr_print_ptr(ndr, "service_status", r->out.service_status);
		ndr->depth++;
		if (r->out.service_status) {
			ndr_print_ENUM_SERVICE_STATUS(ndr, "service_status", r->out.service_status);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "bytes_needed", r->out.bytes_needed);
		ndr->depth++;
		ndr_print_uint32(ndr, "bytes_needed", *r->out.bytes_needed);
		ndr->depth--;
		ndr_print_ptr(ndr, "services_returned", r->out.services_returned);
		ndr->depth++;
		ndr_print_uint32(ndr, "services_returned", *r->out.services_returned);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_EnumServicesStatusA(struct ndr_push *ndr, int flags, const struct svcctl_EnumServicesStatusA *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.type));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.state));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.buf_size));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.resume_handle));
		if (r->in.resume_handle) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.resume_handle));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.buf_size));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.service, r->in.buf_size));
		if (r->out.bytes_needed == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.bytes_needed));
		if (r->out.services_returned == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.services_returned));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.resume_handle));
		if (r->out.resume_handle) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.resume_handle));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_EnumServicesStatusA(struct ndr_pull *ndr, int flags, struct svcctl_EnumServicesStatusA *r)
{
	uint32_t _ptr_resume_handle;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_bytes_needed_0;
	TALLOC_CTX *_mem_save_services_returned_0;
	TALLOC_CTX *_mem_save_resume_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.type));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.state));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.buf_size));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_resume_handle));
		if (_ptr_resume_handle) {
			NDR_PULL_ALLOC(ndr, r->in.resume_handle);
		} else {
			r->in.resume_handle = NULL;
		}
		if (r->in.resume_handle) {
			_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.resume_handle, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.resume_handle));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.bytes_needed);
		ZERO_STRUCTP(r->out.bytes_needed);
		NDR_PULL_ALLOC(ndr, r->out.services_returned);
		ZERO_STRUCTP(r->out.services_returned);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.service));
		NDR_PULL_ALLOC_N(ndr, r->out.service, ndr_get_array_size(ndr, &r->out.service));
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.service, ndr_get_array_size(ndr, &r->out.service)));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.bytes_needed);
		}
		_mem_save_bytes_needed_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.bytes_needed, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.bytes_needed));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bytes_needed_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.services_returned);
		}
		_mem_save_services_returned_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.services_returned, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.services_returned));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_services_returned_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_resume_handle));
		if (_ptr_resume_handle) {
			NDR_PULL_ALLOC(ndr, r->out.resume_handle);
		} else {
			r->out.resume_handle = NULL;
		}
		if (r->out.resume_handle) {
			_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.resume_handle, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.resume_handle));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.service) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->out.service, r->in.buf_size));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_EnumServicesStatusA(struct ndr_print *ndr, const char *name, int flags, const struct svcctl_EnumServicesStatusA *r)
{
	ndr_print_struct(ndr, name, "svcctl_EnumServicesStatusA");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_EnumServicesStatusA");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "type", r->in.type);
		ndr_print_uint32(ndr, "state", r->in.state);
		ndr_print_uint32(ndr, "buf_size", r->in.buf_size);
		ndr_print_ptr(ndr, "resume_handle", r->in.resume_handle);
		ndr->depth++;
		if (r->in.resume_handle) {
			ndr_print_uint32(ndr, "resume_handle", *r->in.resume_handle);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_EnumServicesStatusA");
		ndr->depth++;
		ndr_print_array_uint8(ndr, "service", r->out.service, r->in.buf_size);
		ndr_print_ptr(ndr, "bytes_needed", r->out.bytes_needed);
		ndr->depth++;
		ndr_print_uint32(ndr, "bytes_needed", *r->out.bytes_needed);
		ndr->depth--;
		ndr_print_ptr(ndr, "services_returned", r->out.services_returned);
		ndr->depth++;
		ndr_print_uint32(ndr, "services_returned", *r->out.services_returned);
		ndr->depth--;
		ndr_print_ptr(ndr, "resume_handle", r->out.resume_handle);
		ndr->depth++;
		if (r->out.resume_handle) {
			ndr_print_uint32(ndr, "resume_handle", *r->out.resume_handle);
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_OpenSCManagerA(struct ndr_push *ndr, int flags, const struct svcctl_OpenSCManagerA *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.MachineName));
		if (r->in.MachineName) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.MachineName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.MachineName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.MachineName, ndr_charset_length(r->in.MachineName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.DatabaseName));
		if (r->in.DatabaseName) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.DatabaseName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.DatabaseName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.DatabaseName, ndr_charset_length(r->in.DatabaseName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		if (r->out.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.handle));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_OpenSCManagerA(struct ndr_pull *ndr, int flags, struct svcctl_OpenSCManagerA *r)
{
	uint32_t _ptr_MachineName;
	uint32_t _ptr_DatabaseName;
	TALLOC_CTX *_mem_save_MachineName_0;
	TALLOC_CTX *_mem_save_DatabaseName_0;
	TALLOC_CTX *_mem_save_handle_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_MachineName));
		if (_ptr_MachineName) {
			NDR_PULL_ALLOC(ndr, r->in.MachineName);
		} else {
			r->in.MachineName = NULL;
		}
		if (r->in.MachineName) {
			_mem_save_MachineName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.MachineName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.MachineName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.MachineName));
			if (ndr_get_array_length(ndr, &r->in.MachineName) > ndr_get_array_size(ndr, &r->in.MachineName)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.MachineName), ndr_get_array_length(ndr, &r->in.MachineName));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.MachineName), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.MachineName, ndr_get_array_length(ndr, &r->in.MachineName), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_MachineName_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_DatabaseName));
		if (_ptr_DatabaseName) {
			NDR_PULL_ALLOC(ndr, r->in.DatabaseName);
		} else {
			r->in.DatabaseName = NULL;
		}
		if (r->in.DatabaseName) {
			_mem_save_DatabaseName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.DatabaseName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.DatabaseName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.DatabaseName));
			if (ndr_get_array_length(ndr, &r->in.DatabaseName) > ndr_get_array_size(ndr, &r->in.DatabaseName)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.DatabaseName), ndr_get_array_length(ndr, &r->in.DatabaseName));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.DatabaseName), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.DatabaseName, ndr_get_array_length(ndr, &r->in.DatabaseName), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_DatabaseName_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_PULL_ALLOC(ndr, r->out.handle);
		ZERO_STRUCTP(r->out.handle);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_OpenSCManagerA(struct ndr_print *ndr, const char *name, int flags, const struct svcctl_OpenSCManagerA *r)
{
	ndr_print_struct(ndr, name, "svcctl_OpenSCManagerA");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_OpenSCManagerA");
		ndr->depth++;
		ndr_print_ptr(ndr, "MachineName", r->in.MachineName);
		ndr->depth++;
		if (r->in.MachineName) {
			ndr_print_string(ndr, "MachineName", r->in.MachineName);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "DatabaseName", r->in.DatabaseName);
		ndr->depth++;
		if (r->in.DatabaseName) {
			ndr_print_string(ndr, "DatabaseName", r->in.DatabaseName);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "access_mask", r->in.access_mask);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_OpenSCManagerA");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->out.handle);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_OpenServiceA(struct ndr_push *ndr, int flags, const struct svcctl_OpenServiceA *r)
{
	if (flags & NDR_IN) {
		if (r->in.scmanager_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.scmanager_handle));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.ServiceName));
		if (r->in.ServiceName) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.ServiceName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.ServiceName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.ServiceName, ndr_charset_length(r->in.ServiceName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_OpenServiceA(struct ndr_pull *ndr, int flags, struct svcctl_OpenServiceA *r)
{
	uint32_t _ptr_ServiceName;
	TALLOC_CTX *_mem_save_scmanager_handle_0;
	TALLOC_CTX *_mem_save_ServiceName_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.scmanager_handle);
		}
		_mem_save_scmanager_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.scmanager_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.scmanager_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_scmanager_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ServiceName));
		if (_ptr_ServiceName) {
			NDR_PULL_ALLOC(ndr, r->in.ServiceName);
		} else {
			r->in.ServiceName = NULL;
		}
		if (r->in.ServiceName) {
			_mem_save_ServiceName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.ServiceName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.ServiceName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.ServiceName));
			if (ndr_get_array_length(ndr, &r->in.ServiceName) > ndr_get_array_size(ndr, &r->in.ServiceName)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.ServiceName), ndr_get_array_length(ndr, &r->in.ServiceName));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.ServiceName), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.ServiceName, ndr_get_array_length(ndr, &r->in.ServiceName), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ServiceName_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_OpenServiceA(struct ndr_print *ndr, const char *name, int flags, const struct svcctl_OpenServiceA *r)
{
	ndr_print_struct(ndr, name, "svcctl_OpenServiceA");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_OpenServiceA");
		ndr->depth++;
		ndr_print_ptr(ndr, "scmanager_handle", r->in.scmanager_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "scmanager_handle", r->in.scmanager_handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "ServiceName", r->in.ServiceName);
		ndr->depth++;
		if (r->in.ServiceName) {
			ndr_print_string(ndr, "ServiceName", r->in.ServiceName);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "access_mask", r->in.access_mask);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_OpenServiceA");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_QueryServiceConfigA(struct ndr_push *ndr, int flags, const struct svcctl_QueryServiceConfigA *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.buf_size));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.query, r->in.buf_size));
		if (r->out.bytes_needed == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.bytes_needed));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_QueryServiceConfigA(struct ndr_pull *ndr, int flags, struct svcctl_QueryServiceConfigA *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_bytes_needed_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.buf_size));
		NDR_PULL_ALLOC(ndr, r->out.bytes_needed);
		ZERO_STRUCTP(r->out.bytes_needed);
	}
	if (flags & NDR_OUT) {
		NDR_PULL_ALLOC_N(ndr, r->out.query, r->in.buf_size);
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.query, r->in.buf_size));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.bytes_needed);
		}
		_mem_save_bytes_needed_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.bytes_needed, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.bytes_needed));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bytes_needed_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_QueryServiceConfigA(struct ndr_print *ndr, const char *name, int flags, const struct svcctl_QueryServiceConfigA *r)
{
	ndr_print_struct(ndr, name, "svcctl_QueryServiceConfigA");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_QueryServiceConfigA");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "buf_size", r->in.buf_size);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_QueryServiceConfigA");
		ndr->depth++;
		ndr_print_array_uint8(ndr, "query", r->out.query, r->in.buf_size);
		ndr_print_ptr(ndr, "bytes_needed", r->out.bytes_needed);
		ndr->depth++;
		ndr_print_uint32(ndr, "bytes_needed", *r->out.bytes_needed);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_QueryServiceLockStatusA(struct ndr_push *ndr, int flags, const struct svcctl_QueryServiceLockStatusA *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.buf_size));
	}
	if (flags & NDR_OUT) {
		if (r->out.lock_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_SERVICE_LOCK_STATUS(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.lock_status));
		if (r->out.required_buf_size == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.required_buf_size));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_QueryServiceLockStatusA(struct ndr_pull *ndr, int flags, struct svcctl_QueryServiceLockStatusA *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_lock_status_0;
	TALLOC_CTX *_mem_save_required_buf_size_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.buf_size));
		NDR_PULL_ALLOC(ndr, r->out.lock_status);
		ZERO_STRUCTP(r->out.lock_status);
		NDR_PULL_ALLOC(ndr, r->out.required_buf_size);
		ZERO_STRUCTP(r->out.required_buf_size);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lock_status);
		}
		_mem_save_lock_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lock_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_SERVICE_LOCK_STATUS(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.lock_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lock_status_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.required_buf_size);
		}
		_mem_save_required_buf_size_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.required_buf_size, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.required_buf_size));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_required_buf_size_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_QueryServiceLockStatusA(struct ndr_print *ndr, const char *name, int flags, const struct svcctl_QueryServiceLockStatusA *r)
{
	ndr_print_struct(ndr, name, "svcctl_QueryServiceLockStatusA");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_QueryServiceLockStatusA");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "buf_size", r->in.buf_size);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_QueryServiceLockStatusA");
		ndr->depth++;
		ndr_print_ptr(ndr, "lock_status", r->out.lock_status);
		ndr->depth++;
		ndr_print_SERVICE_LOCK_STATUS(ndr, "lock_status", r->out.lock_status);
		ndr->depth--;
		ndr_print_ptr(ndr, "required_buf_size", r->out.required_buf_size);
		ndr->depth++;
		ndr_print_uint32(ndr, "required_buf_size", *r->out.required_buf_size);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_StartServiceA(struct ndr_push *ndr, int flags, const struct svcctl_StartServiceA *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.NumArgs));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.Arguments));
		if (r->in.Arguments) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.Arguments, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.Arguments, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.Arguments, ndr_charset_length(r->in.Arguments, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_StartServiceA(struct ndr_pull *ndr, int flags, struct svcctl_StartServiceA *r)
{
	uint32_t _ptr_Arguments;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_Arguments_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.NumArgs));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_Arguments));
		if (_ptr_Arguments) {
			NDR_PULL_ALLOC(ndr, r->in.Arguments);
		} else {
			r->in.Arguments = NULL;
		}
		if (r->in.Arguments) {
			_mem_save_Arguments_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.Arguments, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.Arguments));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.Arguments));
			if (ndr_get_array_length(ndr, &r->in.Arguments) > ndr_get_array_size(ndr, &r->in.Arguments)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.Arguments), ndr_get_array_length(ndr, &r->in.Arguments));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.Arguments), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.Arguments, ndr_get_array_length(ndr, &r->in.Arguments), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Arguments_0, 0);
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_StartServiceA(struct ndr_print *ndr, const char *name, int flags, const struct svcctl_StartServiceA *r)
{
	ndr_print_struct(ndr, name, "svcctl_StartServiceA");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_StartServiceA");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "NumArgs", r->in.NumArgs);
		ndr_print_ptr(ndr, "Arguments", r->in.Arguments);
		ndr->depth++;
		if (r->in.Arguments) {
			ndr_print_string(ndr, "Arguments", r->in.Arguments);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_StartServiceA");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_GetServiceDisplayNameA(struct ndr_push *ndr, int flags, const struct svcctl_GetServiceDisplayNameA *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.service_name));
		if (r->in.service_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.service_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.service_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.service_name, ndr_charset_length(r->in.service_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.display_name_length));
		if (r->in.display_name_length) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.display_name_length));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.display_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.display_name));
		if (*r->out.display_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(*r->out.display_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(*r->out.display_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.display_name, ndr_charset_length(*r->out.display_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.display_name_length));
		if (r->out.display_name_length) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.display_name_length));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_GetServiceDisplayNameA(struct ndr_pull *ndr, int flags, struct svcctl_GetServiceDisplayNameA *r)
{
	uint32_t _ptr_service_name;
	uint32_t _ptr_display_name;
	uint32_t _ptr_display_name_length;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_service_name_0;
	TALLOC_CTX *_mem_save_display_name_0;
	TALLOC_CTX *_mem_save_display_name_1;
	TALLOC_CTX *_mem_save_display_name_length_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_service_name));
		if (_ptr_service_name) {
			NDR_PULL_ALLOC(ndr, r->in.service_name);
		} else {
			r->in.service_name = NULL;
		}
		if (r->in.service_name) {
			_mem_save_service_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.service_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.service_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.service_name));
			if (ndr_get_array_length(ndr, &r->in.service_name) > ndr_get_array_size(ndr, &r->in.service_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.service_name), ndr_get_array_length(ndr, &r->in.service_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.service_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.service_name, ndr_get_array_length(ndr, &r->in.service_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_service_name_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_display_name_length));
		if (_ptr_display_name_length) {
			NDR_PULL_ALLOC(ndr, r->in.display_name_length);
		} else {
			r->in.display_name_length = NULL;
		}
		if (r->in.display_name_length) {
			_mem_save_display_name_length_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.display_name_length, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.display_name_length));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_display_name_length_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.display_name);
		ZERO_STRUCTP(r->out.display_name);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.display_name);
		}
		_mem_save_display_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.display_name, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_display_name));
		if (_ptr_display_name) {
			NDR_PULL_ALLOC(ndr, *r->out.display_name);
		} else {
			*r->out.display_name = NULL;
		}
		if (*r->out.display_name) {
			_mem_save_display_name_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.display_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.display_name));
			NDR_CHECK(ndr_pull_array_length(ndr, r->out.display_name));
			if (ndr_get_array_length(ndr, r->out.display_name) > ndr_get_array_size(ndr, r->out.display_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, r->out.display_name), ndr_get_array_length(ndr, r->out.display_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, r->out.display_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.display_name, ndr_get_array_length(ndr, r->out.display_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_display_name_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_display_name_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_display_name_length));
		if (_ptr_display_name_length) {
			NDR_PULL_ALLOC(ndr, r->out.display_name_length);
		} else {
			r->out.display_name_length = NULL;
		}
		if (r->out.display_name_length) {
			_mem_save_display_name_length_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.display_name_length, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.display_name_length));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_display_name_length_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_GetServiceDisplayNameA(struct ndr_print *ndr, const char *name, int flags, const struct svcctl_GetServiceDisplayNameA *r)
{
	ndr_print_struct(ndr, name, "svcctl_GetServiceDisplayNameA");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_GetServiceDisplayNameA");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "service_name", r->in.service_name);
		ndr->depth++;
		if (r->in.service_name) {
			ndr_print_string(ndr, "service_name", r->in.service_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "display_name_length", r->in.display_name_length);
		ndr->depth++;
		if (r->in.display_name_length) {
			ndr_print_uint32(ndr, "display_name_length", *r->in.display_name_length);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_GetServiceDisplayNameA");
		ndr->depth++;
		ndr_print_ptr(ndr, "display_name", r->out.display_name);
		ndr->depth++;
		ndr_print_ptr(ndr, "display_name", *r->out.display_name);
		ndr->depth++;
		if (*r->out.display_name) {
			ndr_print_string(ndr, "display_name", *r->out.display_name);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "display_name_length", r->out.display_name_length);
		ndr->depth++;
		if (r->out.display_name_length) {
			ndr_print_uint32(ndr, "display_name_length", *r->out.display_name_length);
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_GetServiceKeyNameA(struct ndr_push *ndr, int flags, const struct svcctl_GetServiceKeyNameA *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.service_name));
		if (r->in.service_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.service_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.service_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.service_name, ndr_charset_length(r->in.service_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.display_name_length));
		if (r->in.display_name_length) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.display_name_length));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.key_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.key_name));
		if (*r->out.key_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(*r->out.key_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(*r->out.key_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.key_name, ndr_charset_length(*r->out.key_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.display_name_length));
		if (r->out.display_name_length) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.display_name_length));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_GetServiceKeyNameA(struct ndr_pull *ndr, int flags, struct svcctl_GetServiceKeyNameA *r)
{
	uint32_t _ptr_service_name;
	uint32_t _ptr_key_name;
	uint32_t _ptr_display_name_length;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_service_name_0;
	TALLOC_CTX *_mem_save_key_name_0;
	TALLOC_CTX *_mem_save_key_name_1;
	TALLOC_CTX *_mem_save_display_name_length_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_service_name));
		if (_ptr_service_name) {
			NDR_PULL_ALLOC(ndr, r->in.service_name);
		} else {
			r->in.service_name = NULL;
		}
		if (r->in.service_name) {
			_mem_save_service_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.service_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.service_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.service_name));
			if (ndr_get_array_length(ndr, &r->in.service_name) > ndr_get_array_size(ndr, &r->in.service_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.service_name), ndr_get_array_length(ndr, &r->in.service_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.service_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.service_name, ndr_get_array_length(ndr, &r->in.service_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_service_name_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_display_name_length));
		if (_ptr_display_name_length) {
			NDR_PULL_ALLOC(ndr, r->in.display_name_length);
		} else {
			r->in.display_name_length = NULL;
		}
		if (r->in.display_name_length) {
			_mem_save_display_name_length_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.display_name_length, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.display_name_length));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_display_name_length_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.key_name);
		ZERO_STRUCTP(r->out.key_name);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.key_name);
		}
		_mem_save_key_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.key_name, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_key_name));
		if (_ptr_key_name) {
			NDR_PULL_ALLOC(ndr, *r->out.key_name);
		} else {
			*r->out.key_name = NULL;
		}
		if (*r->out.key_name) {
			_mem_save_key_name_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.key_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.key_name));
			NDR_CHECK(ndr_pull_array_length(ndr, r->out.key_name));
			if (ndr_get_array_length(ndr, r->out.key_name) > ndr_get_array_size(ndr, r->out.key_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, r->out.key_name), ndr_get_array_length(ndr, r->out.key_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, r->out.key_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.key_name, ndr_get_array_length(ndr, r->out.key_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_key_name_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_key_name_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_display_name_length));
		if (_ptr_display_name_length) {
			NDR_PULL_ALLOC(ndr, r->out.display_name_length);
		} else {
			r->out.display_name_length = NULL;
		}
		if (r->out.display_name_length) {
			_mem_save_display_name_length_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.display_name_length, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.display_name_length));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_display_name_length_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_GetServiceKeyNameA(struct ndr_print *ndr, const char *name, int flags, const struct svcctl_GetServiceKeyNameA *r)
{
	ndr_print_struct(ndr, name, "svcctl_GetServiceKeyNameA");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_GetServiceKeyNameA");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "service_name", r->in.service_name);
		ndr->depth++;
		if (r->in.service_name) {
			ndr_print_string(ndr, "service_name", r->in.service_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "display_name_length", r->in.display_name_length);
		ndr->depth++;
		if (r->in.display_name_length) {
			ndr_print_uint32(ndr, "display_name_length", *r->in.display_name_length);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_GetServiceKeyNameA");
		ndr->depth++;
		ndr_print_ptr(ndr, "key_name", r->out.key_name);
		ndr->depth++;
		ndr_print_ptr(ndr, "key_name", *r->out.key_name);
		ndr->depth++;
		if (*r->out.key_name) {
			ndr_print_string(ndr, "key_name", *r->out.key_name);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "display_name_length", r->out.display_name_length);
		ndr->depth++;
		if (r->out.display_name_length) {
			ndr_print_uint32(ndr, "display_name_length", *r->out.display_name_length);
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_GetCurrentGroupeStateW(struct ndr_push *ndr, int flags, const struct svcctl_GetCurrentGroupeStateW *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_GetCurrentGroupeStateW(struct ndr_pull *ndr, int flags, struct svcctl_GetCurrentGroupeStateW *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_GetCurrentGroupeStateW(struct ndr_print *ndr, const char *name, int flags, const struct svcctl_GetCurrentGroupeStateW *r)
{
	ndr_print_struct(ndr, name, "svcctl_GetCurrentGroupeStateW");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_GetCurrentGroupeStateW");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_GetCurrentGroupeStateW");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_EnumServiceGroupW(struct ndr_push *ndr, int flags, const struct svcctl_EnumServiceGroupW *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_EnumServiceGroupW(struct ndr_pull *ndr, int flags, struct svcctl_EnumServiceGroupW *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_EnumServiceGroupW(struct ndr_print *ndr, const char *name, int flags, const struct svcctl_EnumServiceGroupW *r)
{
	ndr_print_struct(ndr, name, "svcctl_EnumServiceGroupW");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_EnumServiceGroupW");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_EnumServiceGroupW");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_ChangeServiceConfig2A(struct ndr_push *ndr, int flags, const struct svcctl_ChangeServiceConfig2A *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.info_level));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.info));
		if (r->in.info) {
			NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, *r->in.info));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_ChangeServiceConfig2A(struct ndr_pull *ndr, int flags, struct svcctl_ChangeServiceConfig2A *r)
{
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_info_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.info_level));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, r->in.info);
		} else {
			r->in.info = NULL;
		}
		if (r->in.info) {
			_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.info, 0);
			NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, r->in.info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_ChangeServiceConfig2A(struct ndr_print *ndr, const char *name, int flags, const struct svcctl_ChangeServiceConfig2A *r)
{
	ndr_print_struct(ndr, name, "svcctl_ChangeServiceConfig2A");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_ChangeServiceConfig2A");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "info_level", r->in.info_level);
		ndr_print_ptr(ndr, "info", r->in.info);
		ndr->depth++;
		if (r->in.info) {
			ndr_print_uint8(ndr, "info", *r->in.info);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_ChangeServiceConfig2A");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_ChangeServiceConfig2W(struct ndr_push *ndr, int flags, const struct svcctl_ChangeServiceConfig2W *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.info_level));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.info));
		if (r->in.info) {
			NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, *r->in.info));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_ChangeServiceConfig2W(struct ndr_pull *ndr, int flags, struct svcctl_ChangeServiceConfig2W *r)
{
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_info_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.info_level));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, r->in.info);
		} else {
			r->in.info = NULL;
		}
		if (r->in.info) {
			_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.info, 0);
			NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, r->in.info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_ChangeServiceConfig2W(struct ndr_print *ndr, const char *name, int flags, const struct svcctl_ChangeServiceConfig2W *r)
{
	ndr_print_struct(ndr, name, "svcctl_ChangeServiceConfig2W");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_ChangeServiceConfig2W");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "info_level", r->in.info_level);
		ndr_print_ptr(ndr, "info", r->in.info);
		ndr->depth++;
		if (r->in.info) {
			ndr_print_uint8(ndr, "info", *r->in.info);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_ChangeServiceConfig2W");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_QueryServiceConfig2A(struct ndr_push *ndr, int flags, const struct svcctl_QueryServiceConfig2A *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.info_level));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.buf_size));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.buffer, r->in.buf_size));
		if (r->out.bytes_needed == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.bytes_needed));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_QueryServiceConfig2A(struct ndr_pull *ndr, int flags, struct svcctl_QueryServiceConfig2A *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_bytes_needed_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.info_level));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.buf_size));
		NDR_PULL_ALLOC(ndr, r->out.bytes_needed);
		ZERO_STRUCTP(r->out.bytes_needed);
	}
	if (flags & NDR_OUT) {
		NDR_PULL_ALLOC_N(ndr, r->out.buffer, r->in.buf_size);
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.buffer, r->in.buf_size));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.bytes_needed);
		}
		_mem_save_bytes_needed_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.bytes_needed, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.bytes_needed));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bytes_needed_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_QueryServiceConfig2A(struct ndr_print *ndr, const char *name, int flags, const struct svcctl_QueryServiceConfig2A *r)
{
	ndr_print_struct(ndr, name, "svcctl_QueryServiceConfig2A");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_QueryServiceConfig2A");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "info_level", r->in.info_level);
		ndr_print_uint32(ndr, "buf_size", r->in.buf_size);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_QueryServiceConfig2A");
		ndr->depth++;
		ndr_print_array_uint8(ndr, "buffer", r->out.buffer, r->in.buf_size);
		ndr_print_ptr(ndr, "bytes_needed", r->out.bytes_needed);
		ndr->depth++;
		ndr_print_uint32(ndr, "bytes_needed", *r->out.bytes_needed);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_QueryServiceConfig2W(struct ndr_push *ndr, int flags, const struct svcctl_QueryServiceConfig2W *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.info_level));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.buf_size));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.buffer, r->in.buf_size));
		if (r->out.bytes_needed == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.bytes_needed));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_QueryServiceConfig2W(struct ndr_pull *ndr, int flags, struct svcctl_QueryServiceConfig2W *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_bytes_needed_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.info_level));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.buf_size));
		NDR_PULL_ALLOC(ndr, r->out.bytes_needed);
		ZERO_STRUCTP(r->out.bytes_needed);
	}
	if (flags & NDR_OUT) {
		NDR_PULL_ALLOC_N(ndr, r->out.buffer, r->in.buf_size);
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.buffer, r->in.buf_size));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.bytes_needed);
		}
		_mem_save_bytes_needed_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.bytes_needed, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.bytes_needed));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bytes_needed_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_QueryServiceConfig2W(struct ndr_print *ndr, const char *name, int flags, const struct svcctl_QueryServiceConfig2W *r)
{
	ndr_print_struct(ndr, name, "svcctl_QueryServiceConfig2W");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_QueryServiceConfig2W");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "info_level", r->in.info_level);
		ndr_print_uint32(ndr, "buf_size", r->in.buf_size);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_QueryServiceConfig2W");
		ndr->depth++;
		ndr_print_array_uint8(ndr, "buffer", r->out.buffer, r->in.buf_size);
		ndr_print_ptr(ndr, "bytes_needed", r->out.bytes_needed);
		ndr->depth++;
		ndr_print_uint32(ndr, "bytes_needed", *r->out.bytes_needed);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_QueryServiceStatusEx(struct ndr_push *ndr, int flags, const struct svcctl_QueryServiceStatusEx *r)
{
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.info_level));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.buf_size));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.buffer, r->in.buf_size));
		if (r->out.bytes_needed == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.bytes_needed));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_QueryServiceStatusEx(struct ndr_pull *ndr, int flags, struct svcctl_QueryServiceStatusEx *r)
{
	TALLOC_CTX *_mem_save_handle_0;
	TALLOC_CTX *_mem_save_bytes_needed_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.info_level));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.buf_size));
		NDR_PULL_ALLOC(ndr, r->out.bytes_needed);
		ZERO_STRUCTP(r->out.bytes_needed);
	}
	if (flags & NDR_OUT) {
		NDR_PULL_ALLOC_N(ndr, r->out.buffer, r->in.buf_size);
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.buffer, r->in.buf_size));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.bytes_needed);
		}
		_mem_save_bytes_needed_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.bytes_needed, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.bytes_needed));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bytes_needed_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_QueryServiceStatusEx(struct ndr_print *ndr, const char *name, int flags, const struct svcctl_QueryServiceStatusEx *r)
{
	ndr_print_struct(ndr, name, "svcctl_QueryServiceStatusEx");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_QueryServiceStatusEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "info_level", r->in.info_level);
		ndr_print_uint32(ndr, "buf_size", r->in.buf_size);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_QueryServiceStatusEx");
		ndr->depth++;
		ndr_print_array_uint8(ndr, "buffer", r->out.buffer, r->in.buf_size);
		ndr_print_ptr(ndr, "bytes_needed", r->out.bytes_needed);
		ndr->depth++;
		ndr_print_uint32(ndr, "bytes_needed", *r->out.bytes_needed);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_EnumServicesStatusExA(struct ndr_push *ndr, int flags, const struct EnumServicesStatusExA *r)
{
	if (flags & NDR_IN) {
		if (r->in.scmanager == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.scmanager));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.info_level));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.type));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.state));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.buf_size));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.resume_handle));
		if (r->in.resume_handle) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.resume_handle));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.services, r->in.buf_size));
		if (r->out.bytes_needed == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.bytes_needed));
		if (r->out.service_returned == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.service_returned));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.resume_handle));
		if (r->out.resume_handle) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.resume_handle));
		}
		if (r->out.group_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.group_name));
		if (*r->out.group_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(*r->out.group_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(*r->out.group_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.group_name, ndr_charset_length(*r->out.group_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_EnumServicesStatusExA(struct ndr_pull *ndr, int flags, struct EnumServicesStatusExA *r)
{
	uint32_t _ptr_resume_handle;
	uint32_t _ptr_group_name;
	TALLOC_CTX *_mem_save_scmanager_0;
	TALLOC_CTX *_mem_save_bytes_needed_0;
	TALLOC_CTX *_mem_save_service_returned_0;
	TALLOC_CTX *_mem_save_resume_handle_0;
	TALLOC_CTX *_mem_save_group_name_0;
	TALLOC_CTX *_mem_save_group_name_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.scmanager);
		}
		_mem_save_scmanager_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.scmanager, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.scmanager));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_scmanager_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.info_level));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.type));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.state));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.buf_size));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_resume_handle));
		if (_ptr_resume_handle) {
			NDR_PULL_ALLOC(ndr, r->in.resume_handle);
		} else {
			r->in.resume_handle = NULL;
		}
		if (r->in.resume_handle) {
			_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.resume_handle, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.resume_handle));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.bytes_needed);
		ZERO_STRUCTP(r->out.bytes_needed);
		NDR_PULL_ALLOC(ndr, r->out.service_returned);
		ZERO_STRUCTP(r->out.service_returned);
		NDR_PULL_ALLOC(ndr, r->out.group_name);
		ZERO_STRUCTP(r->out.group_name);
	}
	if (flags & NDR_OUT) {
		NDR_PULL_ALLOC_N(ndr, r->out.services, r->in.buf_size);
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.services, r->in.buf_size));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.bytes_needed);
		}
		_mem_save_bytes_needed_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.bytes_needed, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.bytes_needed));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bytes_needed_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.service_returned);
		}
		_mem_save_service_returned_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.service_returned, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.service_returned));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_service_returned_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_resume_handle));
		if (_ptr_resume_handle) {
			NDR_PULL_ALLOC(ndr, r->out.resume_handle);
		} else {
			r->out.resume_handle = NULL;
		}
		if (r->out.resume_handle) {
			_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.resume_handle, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.resume_handle));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.group_name);
		}
		_mem_save_group_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.group_name, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_group_name));
		if (_ptr_group_name) {
			NDR_PULL_ALLOC(ndr, *r->out.group_name);
		} else {
			*r->out.group_name = NULL;
		}
		if (*r->out.group_name) {
			_mem_save_group_name_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.group_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.group_name));
			NDR_CHECK(ndr_pull_array_length(ndr, r->out.group_name));
			if (ndr_get_array_length(ndr, r->out.group_name) > ndr_get_array_size(ndr, r->out.group_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, r->out.group_name), ndr_get_array_length(ndr, r->out.group_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, r->out.group_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.group_name, ndr_get_array_length(ndr, r->out.group_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_group_name_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_group_name_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_EnumServicesStatusExA(struct ndr_print *ndr, const char *name, int flags, const struct EnumServicesStatusExA *r)
{
	ndr_print_struct(ndr, name, "EnumServicesStatusExA");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "EnumServicesStatusExA");
		ndr->depth++;
		ndr_print_ptr(ndr, "scmanager", r->in.scmanager);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "scmanager", r->in.scmanager);
		ndr->depth--;
		ndr_print_uint32(ndr, "info_level", r->in.info_level);
		ndr_print_uint32(ndr, "type", r->in.type);
		ndr_print_uint32(ndr, "state", r->in.state);
		ndr_print_uint32(ndr, "buf_size", r->in.buf_size);
		ndr_print_ptr(ndr, "resume_handle", r->in.resume_handle);
		ndr->depth++;
		if (r->in.resume_handle) {
			ndr_print_uint32(ndr, "resume_handle", *r->in.resume_handle);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "EnumServicesStatusExA");
		ndr->depth++;
		ndr_print_array_uint8(ndr, "services", r->out.services, r->in.buf_size);
		ndr_print_ptr(ndr, "bytes_needed", r->out.bytes_needed);
		ndr->depth++;
		ndr_print_uint32(ndr, "bytes_needed", *r->out.bytes_needed);
		ndr->depth--;
		ndr_print_ptr(ndr, "service_returned", r->out.service_returned);
		ndr->depth++;
		ndr_print_uint32(ndr, "service_returned", *r->out.service_returned);
		ndr->depth--;
		ndr_print_ptr(ndr, "resume_handle", r->out.resume_handle);
		ndr->depth++;
		if (r->out.resume_handle) {
			ndr_print_uint32(ndr, "resume_handle", *r->out.resume_handle);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "group_name", r->out.group_name);
		ndr->depth++;
		ndr_print_ptr(ndr, "group_name", *r->out.group_name);
		ndr->depth++;
		if (*r->out.group_name) {
			ndr_print_string(ndr, "group_name", *r->out.group_name);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_EnumServicesStatusExW(struct ndr_push *ndr, int flags, const struct EnumServicesStatusExW *r)
{
	if (flags & NDR_IN) {
		if (r->in.scmanager == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.scmanager));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.info_level));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.type));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.state));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.buf_size));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.resume_handle));
		if (r->in.resume_handle) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.resume_handle));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.services, r->in.buf_size));
		if (r->out.bytes_needed == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.bytes_needed));
		if (r->out.service_returned == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.service_returned));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.resume_handle));
		if (r->out.resume_handle) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.resume_handle));
		}
		if (r->out.group_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.group_name));
		if (*r->out.group_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(*r->out.group_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(*r->out.group_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.group_name, ndr_charset_length(*r->out.group_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_EnumServicesStatusExW(struct ndr_pull *ndr, int flags, struct EnumServicesStatusExW *r)
{
	uint32_t _ptr_resume_handle;
	uint32_t _ptr_group_name;
	TALLOC_CTX *_mem_save_scmanager_0;
	TALLOC_CTX *_mem_save_bytes_needed_0;
	TALLOC_CTX *_mem_save_service_returned_0;
	TALLOC_CTX *_mem_save_resume_handle_0;
	TALLOC_CTX *_mem_save_group_name_0;
	TALLOC_CTX *_mem_save_group_name_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.scmanager);
		}
		_mem_save_scmanager_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.scmanager, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.scmanager));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_scmanager_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.info_level));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.type));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.state));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.buf_size));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_resume_handle));
		if (_ptr_resume_handle) {
			NDR_PULL_ALLOC(ndr, r->in.resume_handle);
		} else {
			r->in.resume_handle = NULL;
		}
		if (r->in.resume_handle) {
			_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.resume_handle, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.resume_handle));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.bytes_needed);
		ZERO_STRUCTP(r->out.bytes_needed);
		NDR_PULL_ALLOC(ndr, r->out.service_returned);
		ZERO_STRUCTP(r->out.service_returned);
		NDR_PULL_ALLOC(ndr, r->out.group_name);
		ZERO_STRUCTP(r->out.group_name);
	}
	if (flags & NDR_OUT) {
		NDR_PULL_ALLOC_N(ndr, r->out.services, r->in.buf_size);
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.services, r->in.buf_size));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.bytes_needed);
		}
		_mem_save_bytes_needed_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.bytes_needed, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.bytes_needed));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bytes_needed_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.service_returned);
		}
		_mem_save_service_returned_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.service_returned, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.service_returned));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_service_returned_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_resume_handle));
		if (_ptr_resume_handle) {
			NDR_PULL_ALLOC(ndr, r->out.resume_handle);
		} else {
			r->out.resume_handle = NULL;
		}
		if (r->out.resume_handle) {
			_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.resume_handle, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.resume_handle));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.group_name);
		}
		_mem_save_group_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.group_name, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_group_name));
		if (_ptr_group_name) {
			NDR_PULL_ALLOC(ndr, *r->out.group_name);
		} else {
			*r->out.group_name = NULL;
		}
		if (*r->out.group_name) {
			_mem_save_group_name_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.group_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.group_name));
			NDR_CHECK(ndr_pull_array_length(ndr, r->out.group_name));
			if (ndr_get_array_length(ndr, r->out.group_name) > ndr_get_array_size(ndr, r->out.group_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, r->out.group_name), ndr_get_array_length(ndr, r->out.group_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, r->out.group_name), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.group_name, ndr_get_array_length(ndr, r->out.group_name), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_group_name_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_group_name_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_EnumServicesStatusExW(struct ndr_print *ndr, const char *name, int flags, const struct EnumServicesStatusExW *r)
{
	ndr_print_struct(ndr, name, "EnumServicesStatusExW");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "EnumServicesStatusExW");
		ndr->depth++;
		ndr_print_ptr(ndr, "scmanager", r->in.scmanager);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "scmanager", r->in.scmanager);
		ndr->depth--;
		ndr_print_uint32(ndr, "info_level", r->in.info_level);
		ndr_print_uint32(ndr, "type", r->in.type);
		ndr_print_uint32(ndr, "state", r->in.state);
		ndr_print_uint32(ndr, "buf_size", r->in.buf_size);
		ndr_print_ptr(ndr, "resume_handle", r->in.resume_handle);
		ndr->depth++;
		if (r->in.resume_handle) {
			ndr_print_uint32(ndr, "resume_handle", *r->in.resume_handle);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "EnumServicesStatusExW");
		ndr->depth++;
		ndr_print_array_uint8(ndr, "services", r->out.services, r->in.buf_size);
		ndr_print_ptr(ndr, "bytes_needed", r->out.bytes_needed);
		ndr->depth++;
		ndr_print_uint32(ndr, "bytes_needed", *r->out.bytes_needed);
		ndr->depth--;
		ndr_print_ptr(ndr, "service_returned", r->out.service_returned);
		ndr->depth++;
		ndr_print_uint32(ndr, "service_returned", *r->out.service_returned);
		ndr->depth--;
		ndr_print_ptr(ndr, "resume_handle", r->out.resume_handle);
		ndr->depth++;
		if (r->out.resume_handle) {
			ndr_print_uint32(ndr, "resume_handle", *r->out.resume_handle);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "group_name", r->out.group_name);
		ndr->depth++;
		ndr_print_ptr(ndr, "group_name", *r->out.group_name);
		ndr->depth++;
		if (*r->out.group_name) {
			ndr_print_string(ndr, "group_name", *r->out.group_name);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_SCSendTSMessage(struct ndr_push *ndr, int flags, const struct svcctl_SCSendTSMessage *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_SCSendTSMessage(struct ndr_pull *ndr, int flags, struct svcctl_SCSendTSMessage *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_SCSendTSMessage(struct ndr_print *ndr, const char *name, int flags, const struct svcctl_SCSendTSMessage *r)
{
	ndr_print_struct(ndr, name, "svcctl_SCSendTSMessage");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_SCSendTSMessage");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_SCSendTSMessage");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct ndr_interface_call svcctl_calls[] = {
	{
		"svcctl_CloseServiceHandle",
		sizeof(struct svcctl_CloseServiceHandle),
		(ndr_push_flags_fn_t) ndr_push_svcctl_CloseServiceHandle,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_CloseServiceHandle,
		(ndr_print_function_t) ndr_print_svcctl_CloseServiceHandle,
		false,
	},
	{
		"svcctl_ControlService",
		sizeof(struct svcctl_ControlService),
		(ndr_push_flags_fn_t) ndr_push_svcctl_ControlService,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_ControlService,
		(ndr_print_function_t) ndr_print_svcctl_ControlService,
		false,
	},
	{
		"svcctl_DeleteService",
		sizeof(struct svcctl_DeleteService),
		(ndr_push_flags_fn_t) ndr_push_svcctl_DeleteService,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_DeleteService,
		(ndr_print_function_t) ndr_print_svcctl_DeleteService,
		false,
	},
	{
		"svcctl_LockServiceDatabase",
		sizeof(struct svcctl_LockServiceDatabase),
		(ndr_push_flags_fn_t) ndr_push_svcctl_LockServiceDatabase,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_LockServiceDatabase,
		(ndr_print_function_t) ndr_print_svcctl_LockServiceDatabase,
		false,
	},
	{
		"svcctl_QueryServiceObjectSecurity",
		sizeof(struct svcctl_QueryServiceObjectSecurity),
		(ndr_push_flags_fn_t) ndr_push_svcctl_QueryServiceObjectSecurity,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_QueryServiceObjectSecurity,
		(ndr_print_function_t) ndr_print_svcctl_QueryServiceObjectSecurity,
		false,
	},
	{
		"svcctl_SetServiceObjectSecurity",
		sizeof(struct svcctl_SetServiceObjectSecurity),
		(ndr_push_flags_fn_t) ndr_push_svcctl_SetServiceObjectSecurity,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_SetServiceObjectSecurity,
		(ndr_print_function_t) ndr_print_svcctl_SetServiceObjectSecurity,
		false,
	},
	{
		"svcctl_QueryServiceStatus",
		sizeof(struct svcctl_QueryServiceStatus),
		(ndr_push_flags_fn_t) ndr_push_svcctl_QueryServiceStatus,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_QueryServiceStatus,
		(ndr_print_function_t) ndr_print_svcctl_QueryServiceStatus,
		false,
	},
	{
		"svcctl_SetServiceStatus",
		sizeof(struct svcctl_SetServiceStatus),
		(ndr_push_flags_fn_t) ndr_push_svcctl_SetServiceStatus,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_SetServiceStatus,
		(ndr_print_function_t) ndr_print_svcctl_SetServiceStatus,
		false,
	},
	{
		"svcctl_UnlockServiceDatabase",
		sizeof(struct svcctl_UnlockServiceDatabase),
		(ndr_push_flags_fn_t) ndr_push_svcctl_UnlockServiceDatabase,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_UnlockServiceDatabase,
		(ndr_print_function_t) ndr_print_svcctl_UnlockServiceDatabase,
		false,
	},
	{
		"svcctl_NotifyBootConfigStatus",
		sizeof(struct svcctl_NotifyBootConfigStatus),
		(ndr_push_flags_fn_t) ndr_push_svcctl_NotifyBootConfigStatus,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_NotifyBootConfigStatus,
		(ndr_print_function_t) ndr_print_svcctl_NotifyBootConfigStatus,
		false,
	},
	{
		"svcctl_SCSetServiceBitsW",
		sizeof(struct svcctl_SCSetServiceBitsW),
		(ndr_push_flags_fn_t) ndr_push_svcctl_SCSetServiceBitsW,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_SCSetServiceBitsW,
		(ndr_print_function_t) ndr_print_svcctl_SCSetServiceBitsW,
		false,
	},
	{
		"svcctl_ChangeServiceConfigW",
		sizeof(struct svcctl_ChangeServiceConfigW),
		(ndr_push_flags_fn_t) ndr_push_svcctl_ChangeServiceConfigW,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_ChangeServiceConfigW,
		(ndr_print_function_t) ndr_print_svcctl_ChangeServiceConfigW,
		false,
	},
	{
		"svcctl_CreateServiceW",
		sizeof(struct svcctl_CreateServiceW),
		(ndr_push_flags_fn_t) ndr_push_svcctl_CreateServiceW,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_CreateServiceW,
		(ndr_print_function_t) ndr_print_svcctl_CreateServiceW,
		false,
	},
	{
		"svcctl_EnumDependentServicesW",
		sizeof(struct svcctl_EnumDependentServicesW),
		(ndr_push_flags_fn_t) ndr_push_svcctl_EnumDependentServicesW,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_EnumDependentServicesW,
		(ndr_print_function_t) ndr_print_svcctl_EnumDependentServicesW,
		false,
	},
	{
		"svcctl_EnumServicesStatusW",
		sizeof(struct svcctl_EnumServicesStatusW),
		(ndr_push_flags_fn_t) ndr_push_svcctl_EnumServicesStatusW,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_EnumServicesStatusW,
		(ndr_print_function_t) ndr_print_svcctl_EnumServicesStatusW,
		false,
	},
	{
		"svcctl_OpenSCManagerW",
		sizeof(struct svcctl_OpenSCManagerW),
		(ndr_push_flags_fn_t) ndr_push_svcctl_OpenSCManagerW,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_OpenSCManagerW,
		(ndr_print_function_t) ndr_print_svcctl_OpenSCManagerW,
		false,
	},
	{
		"svcctl_OpenServiceW",
		sizeof(struct svcctl_OpenServiceW),
		(ndr_push_flags_fn_t) ndr_push_svcctl_OpenServiceW,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_OpenServiceW,
		(ndr_print_function_t) ndr_print_svcctl_OpenServiceW,
		false,
	},
	{
		"svcctl_QueryServiceConfigW",
		sizeof(struct svcctl_QueryServiceConfigW),
		(ndr_push_flags_fn_t) ndr_push_svcctl_QueryServiceConfigW,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_QueryServiceConfigW,
		(ndr_print_function_t) ndr_print_svcctl_QueryServiceConfigW,
		false,
	},
	{
		"svcctl_QueryServiceLockStatusW",
		sizeof(struct svcctl_QueryServiceLockStatusW),
		(ndr_push_flags_fn_t) ndr_push_svcctl_QueryServiceLockStatusW,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_QueryServiceLockStatusW,
		(ndr_print_function_t) ndr_print_svcctl_QueryServiceLockStatusW,
		false,
	},
	{
		"svcctl_StartServiceW",
		sizeof(struct svcctl_StartServiceW),
		(ndr_push_flags_fn_t) ndr_push_svcctl_StartServiceW,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_StartServiceW,
		(ndr_print_function_t) ndr_print_svcctl_StartServiceW,
		false,
	},
	{
		"svcctl_GetServiceDisplayNameW",
		sizeof(struct svcctl_GetServiceDisplayNameW),
		(ndr_push_flags_fn_t) ndr_push_svcctl_GetServiceDisplayNameW,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_GetServiceDisplayNameW,
		(ndr_print_function_t) ndr_print_svcctl_GetServiceDisplayNameW,
		false,
	},
	{
		"svcctl_GetServiceKeyNameW",
		sizeof(struct svcctl_GetServiceKeyNameW),
		(ndr_push_flags_fn_t) ndr_push_svcctl_GetServiceKeyNameW,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_GetServiceKeyNameW,
		(ndr_print_function_t) ndr_print_svcctl_GetServiceKeyNameW,
		false,
	},
	{
		"svcctl_SCSetServiceBitsA",
		sizeof(struct svcctl_SCSetServiceBitsA),
		(ndr_push_flags_fn_t) ndr_push_svcctl_SCSetServiceBitsA,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_SCSetServiceBitsA,
		(ndr_print_function_t) ndr_print_svcctl_SCSetServiceBitsA,
		false,
	},
	{
		"svcctl_ChangeServiceConfigA",
		sizeof(struct svcctl_ChangeServiceConfigA),
		(ndr_push_flags_fn_t) ndr_push_svcctl_ChangeServiceConfigA,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_ChangeServiceConfigA,
		(ndr_print_function_t) ndr_print_svcctl_ChangeServiceConfigA,
		false,
	},
	{
		"svcctl_CreateServiceA",
		sizeof(struct svcctl_CreateServiceA),
		(ndr_push_flags_fn_t) ndr_push_svcctl_CreateServiceA,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_CreateServiceA,
		(ndr_print_function_t) ndr_print_svcctl_CreateServiceA,
		false,
	},
	{
		"svcctl_EnumDependentServicesA",
		sizeof(struct svcctl_EnumDependentServicesA),
		(ndr_push_flags_fn_t) ndr_push_svcctl_EnumDependentServicesA,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_EnumDependentServicesA,
		(ndr_print_function_t) ndr_print_svcctl_EnumDependentServicesA,
		false,
	},
	{
		"svcctl_EnumServicesStatusA",
		sizeof(struct svcctl_EnumServicesStatusA),
		(ndr_push_flags_fn_t) ndr_push_svcctl_EnumServicesStatusA,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_EnumServicesStatusA,
		(ndr_print_function_t) ndr_print_svcctl_EnumServicesStatusA,
		false,
	},
	{
		"svcctl_OpenSCManagerA",
		sizeof(struct svcctl_OpenSCManagerA),
		(ndr_push_flags_fn_t) ndr_push_svcctl_OpenSCManagerA,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_OpenSCManagerA,
		(ndr_print_function_t) ndr_print_svcctl_OpenSCManagerA,
		false,
	},
	{
		"svcctl_OpenServiceA",
		sizeof(struct svcctl_OpenServiceA),
		(ndr_push_flags_fn_t) ndr_push_svcctl_OpenServiceA,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_OpenServiceA,
		(ndr_print_function_t) ndr_print_svcctl_OpenServiceA,
		false,
	},
	{
		"svcctl_QueryServiceConfigA",
		sizeof(struct svcctl_QueryServiceConfigA),
		(ndr_push_flags_fn_t) ndr_push_svcctl_QueryServiceConfigA,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_QueryServiceConfigA,
		(ndr_print_function_t) ndr_print_svcctl_QueryServiceConfigA,
		false,
	},
	{
		"svcctl_QueryServiceLockStatusA",
		sizeof(struct svcctl_QueryServiceLockStatusA),
		(ndr_push_flags_fn_t) ndr_push_svcctl_QueryServiceLockStatusA,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_QueryServiceLockStatusA,
		(ndr_print_function_t) ndr_print_svcctl_QueryServiceLockStatusA,
		false,
	},
	{
		"svcctl_StartServiceA",
		sizeof(struct svcctl_StartServiceA),
		(ndr_push_flags_fn_t) ndr_push_svcctl_StartServiceA,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_StartServiceA,
		(ndr_print_function_t) ndr_print_svcctl_StartServiceA,
		false,
	},
	{
		"svcctl_GetServiceDisplayNameA",
		sizeof(struct svcctl_GetServiceDisplayNameA),
		(ndr_push_flags_fn_t) ndr_push_svcctl_GetServiceDisplayNameA,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_GetServiceDisplayNameA,
		(ndr_print_function_t) ndr_print_svcctl_GetServiceDisplayNameA,
		false,
	},
	{
		"svcctl_GetServiceKeyNameA",
		sizeof(struct svcctl_GetServiceKeyNameA),
		(ndr_push_flags_fn_t) ndr_push_svcctl_GetServiceKeyNameA,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_GetServiceKeyNameA,
		(ndr_print_function_t) ndr_print_svcctl_GetServiceKeyNameA,
		false,
	},
	{
		"svcctl_GetCurrentGroupeStateW",
		sizeof(struct svcctl_GetCurrentGroupeStateW),
		(ndr_push_flags_fn_t) ndr_push_svcctl_GetCurrentGroupeStateW,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_GetCurrentGroupeStateW,
		(ndr_print_function_t) ndr_print_svcctl_GetCurrentGroupeStateW,
		false,
	},
	{
		"svcctl_EnumServiceGroupW",
		sizeof(struct svcctl_EnumServiceGroupW),
		(ndr_push_flags_fn_t) ndr_push_svcctl_EnumServiceGroupW,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_EnumServiceGroupW,
		(ndr_print_function_t) ndr_print_svcctl_EnumServiceGroupW,
		false,
	},
	{
		"svcctl_ChangeServiceConfig2A",
		sizeof(struct svcctl_ChangeServiceConfig2A),
		(ndr_push_flags_fn_t) ndr_push_svcctl_ChangeServiceConfig2A,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_ChangeServiceConfig2A,
		(ndr_print_function_t) ndr_print_svcctl_ChangeServiceConfig2A,
		false,
	},
	{
		"svcctl_ChangeServiceConfig2W",
		sizeof(struct svcctl_ChangeServiceConfig2W),
		(ndr_push_flags_fn_t) ndr_push_svcctl_ChangeServiceConfig2W,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_ChangeServiceConfig2W,
		(ndr_print_function_t) ndr_print_svcctl_ChangeServiceConfig2W,
		false,
	},
	{
		"svcctl_QueryServiceConfig2A",
		sizeof(struct svcctl_QueryServiceConfig2A),
		(ndr_push_flags_fn_t) ndr_push_svcctl_QueryServiceConfig2A,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_QueryServiceConfig2A,
		(ndr_print_function_t) ndr_print_svcctl_QueryServiceConfig2A,
		false,
	},
	{
		"svcctl_QueryServiceConfig2W",
		sizeof(struct svcctl_QueryServiceConfig2W),
		(ndr_push_flags_fn_t) ndr_push_svcctl_QueryServiceConfig2W,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_QueryServiceConfig2W,
		(ndr_print_function_t) ndr_print_svcctl_QueryServiceConfig2W,
		false,
	},
	{
		"svcctl_QueryServiceStatusEx",
		sizeof(struct svcctl_QueryServiceStatusEx),
		(ndr_push_flags_fn_t) ndr_push_svcctl_QueryServiceStatusEx,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_QueryServiceStatusEx,
		(ndr_print_function_t) ndr_print_svcctl_QueryServiceStatusEx,
		false,
	},
	{
		"EnumServicesStatusExA",
		sizeof(struct EnumServicesStatusExA),
		(ndr_push_flags_fn_t) ndr_push_EnumServicesStatusExA,
		(ndr_pull_flags_fn_t) ndr_pull_EnumServicesStatusExA,
		(ndr_print_function_t) ndr_print_EnumServicesStatusExA,
		false,
	},
	{
		"EnumServicesStatusExW",
		sizeof(struct EnumServicesStatusExW),
		(ndr_push_flags_fn_t) ndr_push_EnumServicesStatusExW,
		(ndr_pull_flags_fn_t) ndr_pull_EnumServicesStatusExW,
		(ndr_print_function_t) ndr_print_EnumServicesStatusExW,
		false,
	},
	{
		"svcctl_SCSendTSMessage",
		sizeof(struct svcctl_SCSendTSMessage),
		(ndr_push_flags_fn_t) ndr_push_svcctl_SCSendTSMessage,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_SCSendTSMessage,
		(ndr_print_function_t) ndr_print_svcctl_SCSendTSMessage,
		false,
	},
	{ NULL, 0, NULL, NULL, NULL, false }
};

static const char * const svcctl_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\svcctl]", 
	"ncalrpc:", 
};

static const struct ndr_interface_string_array svcctl_endpoints = {
	.count	= 2,
	.names	= svcctl_endpoint_strings
};

static const char * const svcctl_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array svcctl_authservices = {
	.count	= 1,
	.names	= svcctl_authservice_strings
};


const struct ndr_interface_table ndr_table_svcctl = {
	.name		= "svcctl",
	.syntax_id	= {
		{0x367abb81,0x9844,0x35f1,{0xad,0x32},{0x98,0xf0,0x38,0x00,0x10,0x03}},
		NDR_SVCCTL_VERSION
	},
	.helpstring	= NDR_SVCCTL_HELPSTRING,
	.num_calls	= 44,
	.calls		= svcctl_calls,
	.endpoints	= &svcctl_endpoints,
	.authservices	= &svcctl_authservices
};

