/*
 * Unix SMB/CIFS implementation.
 * client auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "librpc/gen_ndr/cli_netlogon.h"

NTSTATUS rpccli_netr_LogonUasLogon(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   const char *server_name /* [in] [unique,charset(UTF16)] */,
				   const char *account_name /* [in] [charset(UTF16)] */,
				   const char *workstation /* [in] [charset(UTF16)] */,
				   struct netr_UasInfo *info /* [out] [ref] */,
				   WERROR *werror)
{
	struct netr_LogonUasLogon r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;
	r.in.account_name = account_name;
	r.in.workstation = workstation;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_LogonUasLogon, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_LOGONUASLOGON,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_LogonUasLogon, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info = *r.out.info;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_netr_LogonUasLogoff(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    const char *server_name /* [in] [unique,charset(UTF16)] */,
				    const char *account_name /* [in] [charset(UTF16)] */,
				    const char *workstation /* [in] [charset(UTF16)] */,
				    struct netr_UasLogoffInfo *info /* [out] [ref] */,
				    WERROR *werror)
{
	struct netr_LogonUasLogoff r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;
	r.in.account_name = account_name;
	r.in.workstation = workstation;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_LogonUasLogoff, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_LOGONUASLOGOFF,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_LogonUasLogoff, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info = *r.out.info;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_netr_LogonSamLogon(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   const char *server_name /* [in] [unique,charset(UTF16)] */,
				   const char *computer_name /* [in] [unique,charset(UTF16)] */,
				   struct netr_Authenticator *credential /* [in] [unique] */,
				   struct netr_Authenticator *return_authenticator /* [in,out] [unique] */,
				   enum netr_LogonLevel logon_level /* [in]  */,
				   union netr_LogonInfo *logon /* [in] [ref,switch_is(logon_level)] */,
				   uint16_t validation_level /* [in]  */,
				   union netr_Validation *validation /* [out] [ref,switch_is(validation_level)] */,
				   uint8_t *authoritative /* [out] [ref] */)
{
	struct netr_LogonSamLogon r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;
	r.in.computer_name = computer_name;
	r.in.credential = credential;
	r.in.return_authenticator = return_authenticator;
	r.in.logon_level = logon_level;
	r.in.logon = logon;
	r.in.validation_level = validation_level;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_LogonSamLogon, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_LOGONSAMLOGON,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_LogonSamLogon, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	if (return_authenticator && r.out.return_authenticator) {
		*return_authenticator = *r.out.return_authenticator;
	}
	*validation = *r.out.validation;
	*authoritative = *r.out.authoritative;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_netr_LogonSamLogoff(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    const char *server_name /* [in] [unique,charset(UTF16)] */,
				    const char *computer_name /* [in] [unique,charset(UTF16)] */,
				    struct netr_Authenticator *credential /* [in] [unique] */,
				    struct netr_Authenticator *return_authenticator /* [in,out] [unique] */,
				    enum netr_LogonLevel logon_level /* [in]  */,
				    union netr_LogonInfo logon /* [in] [switch_is(logon_level)] */)
{
	struct netr_LogonSamLogoff r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;
	r.in.computer_name = computer_name;
	r.in.credential = credential;
	r.in.return_authenticator = return_authenticator;
	r.in.logon_level = logon_level;
	r.in.logon = logon;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_LogonSamLogoff, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_LOGONSAMLOGOFF,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_LogonSamLogoff, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	if (return_authenticator && r.out.return_authenticator) {
		*return_authenticator = *r.out.return_authenticator;
	}

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_netr_ServerReqChallenge(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					const char *server_name /* [in] [unique,charset(UTF16)] */,
					const char *computer_name /* [in] [charset(UTF16)] */,
					struct netr_Credential *credentials /* [in] [ref] */,
					struct netr_Credential *return_credentials /* [out] [ref] */)
{
	struct netr_ServerReqChallenge r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;
	r.in.computer_name = computer_name;
	r.in.credentials = credentials;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_ServerReqChallenge, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_SERVERREQCHALLENGE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_ServerReqChallenge, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*return_credentials = *r.out.return_credentials;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_netr_ServerAuthenticate(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					const char *server_name /* [in] [unique,charset(UTF16)] */,
					const char *account_name /* [in] [charset(UTF16)] */,
					enum netr_SchannelType secure_channel_type /* [in]  */,
					const char *computer_name /* [in] [charset(UTF16)] */,
					struct netr_Credential *credentials /* [in] [ref] */,
					struct netr_Credential *return_credentials /* [out] [ref] */)
{
	struct netr_ServerAuthenticate r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;
	r.in.account_name = account_name;
	r.in.secure_channel_type = secure_channel_type;
	r.in.computer_name = computer_name;
	r.in.credentials = credentials;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_ServerAuthenticate, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_SERVERAUTHENTICATE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_ServerAuthenticate, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*return_credentials = *r.out.return_credentials;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_netr_ServerPasswordSet(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       const char *server_name /* [in] [unique,charset(UTF16)] */,
				       const char *account_name /* [in] [charset(UTF16)] */,
				       enum netr_SchannelType secure_channel_type /* [in]  */,
				       const char *computer_name /* [in] [charset(UTF16)] */,
				       struct netr_Authenticator *credential /* [in] [ref] */,
				       struct netr_Authenticator *return_authenticator /* [out] [ref] */,
				       struct samr_Password *new_password /* [in] [ref] */)
{
	struct netr_ServerPasswordSet r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;
	r.in.account_name = account_name;
	r.in.secure_channel_type = secure_channel_type;
	r.in.computer_name = computer_name;
	r.in.credential = credential;
	r.in.new_password = new_password;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_ServerPasswordSet, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_SERVERPASSWORDSET,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_ServerPasswordSet, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*return_authenticator = *r.out.return_authenticator;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_netr_DatabaseDeltas(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    const char *logon_server /* [in] [charset(UTF16)] */,
				    const char *computername /* [in] [charset(UTF16)] */,
				    struct netr_Authenticator *credential /* [in] [ref] */,
				    struct netr_Authenticator *return_authenticator /* [in,out] [ref] */,
				    enum netr_SamDatabaseID database_id /* [in]  */,
				    uint64_t *sequence_num /* [in,out] [ref] */,
				    struct netr_DELTA_ENUM_ARRAY **delta_enum_array /* [out] [ref] */,
				    uint32_t preferredmaximumlength /* [in]  */)
{
	struct netr_DatabaseDeltas r;
	NTSTATUS status;

	/* In parameters */
	r.in.logon_server = logon_server;
	r.in.computername = computername;
	r.in.credential = credential;
	r.in.return_authenticator = return_authenticator;
	r.in.database_id = database_id;
	r.in.sequence_num = sequence_num;
	r.in.preferredmaximumlength = preferredmaximumlength;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_DatabaseDeltas, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_DATABASEDELTAS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_DatabaseDeltas, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*return_authenticator = *r.out.return_authenticator;
	*sequence_num = *r.out.sequence_num;
	*delta_enum_array = *r.out.delta_enum_array;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_netr_DatabaseSync(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  const char *logon_server /* [in] [charset(UTF16)] */,
				  const char *computername /* [in] [charset(UTF16)] */,
				  struct netr_Authenticator credential /* [in]  */,
				  struct netr_Authenticator *return_authenticator /* [in,out] [ref] */,
				  enum netr_SamDatabaseID database_id /* [in]  */,
				  uint32_t *sync_context /* [in,out] [ref] */,
				  uint32_t preferredmaximumlength /* [in]  */,
				  struct netr_DELTA_ENUM_ARRAY *delta_enum_array /* [out] [ref] */)
{
	struct netr_DatabaseSync r;
	NTSTATUS status;

	/* In parameters */
	r.in.logon_server = logon_server;
	r.in.computername = computername;
	r.in.credential = credential;
	r.in.return_authenticator = return_authenticator;
	r.in.database_id = database_id;
	r.in.sync_context = sync_context;
	r.in.preferredmaximumlength = preferredmaximumlength;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_DatabaseSync, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_DATABASESYNC,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_DatabaseSync, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*return_authenticator = *r.out.return_authenticator;
	*sync_context = *r.out.sync_context;
	*delta_enum_array = *r.out.delta_enum_array;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_netr_AccountDeltas(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   const char *logon_server /* [in] [unique,charset(UTF16)] */,
				   const char *computername /* [in] [charset(UTF16)] */,
				   struct netr_Authenticator credential /* [in]  */,
				   struct netr_Authenticator *return_authenticator /* [in,out] [ref] */,
				   struct netr_UAS_INFO_0 uas /* [in]  */,
				   uint32_t count /* [in]  */,
				   uint32_t level /* [in]  */,
				   uint32_t buffersize /* [in]  */,
				   struct netr_AccountBuffer *buffer /* [out] [ref,subcontext(4)] */,
				   uint32_t *count_returned /* [out] [ref] */,
				   uint32_t *total_entries /* [out] [ref] */,
				   struct netr_UAS_INFO_0 *recordid /* [out] [ref] */)
{
	struct netr_AccountDeltas r;
	NTSTATUS status;

	/* In parameters */
	r.in.logon_server = logon_server;
	r.in.computername = computername;
	r.in.credential = credential;
	r.in.return_authenticator = return_authenticator;
	r.in.uas = uas;
	r.in.count = count;
	r.in.level = level;
	r.in.buffersize = buffersize;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_AccountDeltas, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_ACCOUNTDELTAS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_AccountDeltas, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*return_authenticator = *r.out.return_authenticator;
	*buffer = *r.out.buffer;
	*count_returned = *r.out.count_returned;
	*total_entries = *r.out.total_entries;
	*recordid = *r.out.recordid;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_netr_AccountSync(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 const char *logon_server /* [in] [unique,charset(UTF16)] */,
				 const char *computername /* [in] [charset(UTF16)] */,
				 struct netr_Authenticator credential /* [in]  */,
				 struct netr_Authenticator *return_authenticator /* [in,out] [ref] */,
				 uint32_t reference /* [in]  */,
				 uint32_t level /* [in]  */,
				 uint32_t buffersize /* [in]  */,
				 struct netr_AccountBuffer *buffer /* [out] [ref,subcontext(4)] */,
				 uint32_t *count_returned /* [out] [ref] */,
				 uint32_t *total_entries /* [out] [ref] */,
				 uint32_t *next_reference /* [out] [ref] */,
				 struct netr_UAS_INFO_0 *recordid /* [in,out] [ref] */)
{
	struct netr_AccountSync r;
	NTSTATUS status;

	/* In parameters */
	r.in.logon_server = logon_server;
	r.in.computername = computername;
	r.in.credential = credential;
	r.in.return_authenticator = return_authenticator;
	r.in.reference = reference;
	r.in.level = level;
	r.in.buffersize = buffersize;
	r.in.recordid = recordid;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_AccountSync, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_ACCOUNTSYNC,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_AccountSync, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*return_authenticator = *r.out.return_authenticator;
	*buffer = *r.out.buffer;
	*count_returned = *r.out.count_returned;
	*total_entries = *r.out.total_entries;
	*next_reference = *r.out.next_reference;
	*recordid = *r.out.recordid;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_netr_GetDcName(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       const char *logon_server /* [in] [charset(UTF16)] */,
			       const char *domainname /* [in] [unique,charset(UTF16)] */,
			       const char **dcname /* [out] [ref,charset(UTF16)] */,
			       WERROR *werror)
{
	struct netr_GetDcName r;
	NTSTATUS status;

	/* In parameters */
	r.in.logon_server = logon_server;
	r.in.domainname = domainname;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_GetDcName, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_GETDCNAME,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_GetDcName, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*dcname = *r.out.dcname;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_netr_LogonControl(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  const char *logon_server /* [in] [unique,charset(UTF16)] */,
				  enum netr_LogonControlCode function_code /* [in]  */,
				  uint32_t level /* [in]  */,
				  union netr_CONTROL_QUERY_INFORMATION *info /* [out] [ref,switch_is(level)] */,
				  WERROR *werror)
{
	struct netr_LogonControl r;
	NTSTATUS status;

	/* In parameters */
	r.in.logon_server = logon_server;
	r.in.function_code = function_code;
	r.in.level = level;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_LogonControl, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_LOGONCONTROL,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_LogonControl, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info = *r.out.info;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_netr_GetAnyDCName(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  const char *logon_server /* [in] [unique,charset(UTF16)] */,
				  const char *domainname /* [in] [unique,charset(UTF16)] */,
				  const char **dcname /* [out] [ref,charset(UTF16)] */,
				  WERROR *werror)
{
	struct netr_GetAnyDCName r;
	NTSTATUS status;

	/* In parameters */
	r.in.logon_server = logon_server;
	r.in.domainname = domainname;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_GetAnyDCName, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_GETANYDCNAME,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_GetAnyDCName, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*dcname = *r.out.dcname;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_netr_LogonControl2(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   const char *logon_server /* [in] [unique,charset(UTF16)] */,
				   enum netr_LogonControlCode function_code /* [in]  */,
				   uint32_t level /* [in]  */,
				   union netr_CONTROL_DATA_INFORMATION *data /* [in] [ref,switch_is(function_code)] */,
				   union netr_CONTROL_QUERY_INFORMATION *query /* [out] [ref,switch_is(level)] */,
				   WERROR *werror)
{
	struct netr_LogonControl2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.logon_server = logon_server;
	r.in.function_code = function_code;
	r.in.level = level;
	r.in.data = data;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_LogonControl2, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_LOGONCONTROL2,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_LogonControl2, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*query = *r.out.query;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_netr_ServerAuthenticate2(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 const char *server_name /* [in] [unique,charset(UTF16)] */,
					 const char *account_name /* [in] [charset(UTF16)] */,
					 enum netr_SchannelType secure_channel_type /* [in]  */,
					 const char *computer_name /* [in] [charset(UTF16)] */,
					 struct netr_Credential *credentials /* [in] [ref] */,
					 struct netr_Credential *return_credentials /* [out] [ref] */,
					 uint32_t *negotiate_flags /* [in,out] [ref] */)
{
	struct netr_ServerAuthenticate2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;
	r.in.account_name = account_name;
	r.in.secure_channel_type = secure_channel_type;
	r.in.computer_name = computer_name;
	r.in.credentials = credentials;
	r.in.negotiate_flags = negotiate_flags;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_ServerAuthenticate2, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_SERVERAUTHENTICATE2,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_ServerAuthenticate2, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*return_credentials = *r.out.return_credentials;
	*negotiate_flags = *r.out.negotiate_flags;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_netr_DatabaseSync2(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   const char *logon_server /* [in] [charset(UTF16)] */,
				   const char *computername /* [in] [charset(UTF16)] */,
				   struct netr_Authenticator *credential /* [in] [ref] */,
				   struct netr_Authenticator *return_authenticator /* [in,out] [ref] */,
				   enum netr_SamDatabaseID database_id /* [in]  */,
				   uint16_t restart_state /* [in]  */,
				   uint32_t *sync_context /* [in,out] [ref] */,
				   struct netr_DELTA_ENUM_ARRAY **delta_enum_array /* [out] [ref] */,
				   uint32_t preferredmaximumlength /* [in]  */)
{
	struct netr_DatabaseSync2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.logon_server = logon_server;
	r.in.computername = computername;
	r.in.credential = credential;
	r.in.return_authenticator = return_authenticator;
	r.in.database_id = database_id;
	r.in.restart_state = restart_state;
	r.in.sync_context = sync_context;
	r.in.preferredmaximumlength = preferredmaximumlength;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_DatabaseSync2, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_DATABASESYNC2,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_DatabaseSync2, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*return_authenticator = *r.out.return_authenticator;
	*sync_context = *r.out.sync_context;
	*delta_enum_array = *r.out.delta_enum_array;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_netr_DatabaseRedo(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  const char *logon_server /* [in] [charset(UTF16)] */,
				  const char *computername /* [in] [charset(UTF16)] */,
				  struct netr_Authenticator *credential /* [in] [ref] */,
				  struct netr_Authenticator *return_authenticator /* [in,out] [ref] */,
				  struct netr_ChangeLogEntry change_log_entry /* [in] [subcontext_size(change_log_entry_size),subcontext(4)] */,
				  uint32_t change_log_entry_size /* [in] [value(ndr_size_netr_ChangeLogEntry(&change_log_entry,ndr->flags))] */,
				  struct netr_DELTA_ENUM_ARRAY **delta_enum_array /* [out] [ref] */)
{
	struct netr_DatabaseRedo r;
	NTSTATUS status;

	/* In parameters */
	r.in.logon_server = logon_server;
	r.in.computername = computername;
	r.in.credential = credential;
	r.in.return_authenticator = return_authenticator;
	r.in.change_log_entry = change_log_entry;
	r.in.change_log_entry_size = change_log_entry_size;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_DatabaseRedo, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_DATABASEREDO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_DatabaseRedo, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*return_authenticator = *r.out.return_authenticator;
	*delta_enum_array = *r.out.delta_enum_array;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_netr_LogonControl2Ex(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     const char *logon_server /* [in] [unique,charset(UTF16)] */,
				     uint32_t function_code /* [in]  */,
				     uint32_t level /* [in]  */,
				     union netr_CONTROL_DATA_INFORMATION data /* [in] [switch_is(function_code)] */,
				     union netr_CONTROL_QUERY_INFORMATION *query /* [out] [ref,switch_is(level)] */,
				     WERROR *werror)
{
	struct netr_LogonControl2Ex r;
	NTSTATUS status;

	/* In parameters */
	r.in.logon_server = logon_server;
	r.in.function_code = function_code;
	r.in.level = level;
	r.in.data = data;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_LogonControl2Ex, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_LOGONCONTROL2EX,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_LogonControl2Ex, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*query = *r.out.query;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_netr_NetrEnumerateTrustedDomains(struct rpc_pipe_client *cli,
						 TALLOC_CTX *mem_ctx,
						 const char *server_name /* [in] [unique,charset(UTF16)] */,
						 struct netr_Blob *trusted_domains_blob /* [out] [ref] */,
						 WERROR *werror)
{
	struct netr_NetrEnumerateTrustedDomains r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_NetrEnumerateTrustedDomains, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_NETRENUMERATETRUSTEDDOMAINS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_NetrEnumerateTrustedDomains, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*trusted_domains_blob = *r.out.trusted_domains_blob;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_netr_DsRGetDCName(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  const char *server_unc /* [in] [unique,charset(UTF16)] */,
				  const char *domain_name /* [in] [unique,charset(UTF16)] */,
				  struct GUID *domain_guid /* [in] [unique] */,
				  struct GUID *site_guid /* [in] [unique] */,
				  uint32_t flags /* [in]  */,
				  struct netr_DsRGetDCNameInfo **info /* [out] [ref] */,
				  WERROR *werror)
{
	struct netr_DsRGetDCName r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = server_unc;
	r.in.domain_name = domain_name;
	r.in.domain_guid = domain_guid;
	r.in.site_guid = site_guid;
	r.in.flags = flags;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_DsRGetDCName, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_DSRGETDCNAME,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_DsRGetDCName, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info = *r.out.info;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_netr_NETRLOGONDUMMYROUTINE1(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx,
					    WERROR *werror)
{
	struct netr_NETRLOGONDUMMYROUTINE1 r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_NETRLOGONDUMMYROUTINE1, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_NETRLOGONDUMMYROUTINE1,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_NETRLOGONDUMMYROUTINE1, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_netr_NETRLOGONSETSERVICEBITS(struct rpc_pipe_client *cli,
					     TALLOC_CTX *mem_ctx,
					     WERROR *werror)
{
	struct netr_NETRLOGONSETSERVICEBITS r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_NETRLOGONSETSERVICEBITS, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_NETRLOGONSETSERVICEBITS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_NETRLOGONSETSERVICEBITS, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_netr_LogonGetTrustRid(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      const char *server_name /* [in] [unique,charset(UTF16)] */,
				      const char *domain_name /* [in] [unique,charset(UTF16)] */,
				      uint32_t *rid /* [out] [ref] */,
				      WERROR *werror)
{
	struct netr_LogonGetTrustRid r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;
	r.in.domain_name = domain_name;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_LogonGetTrustRid, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_LOGONGETTRUSTRID,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_LogonGetTrustRid, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*rid = *r.out.rid;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_netr_NETRLOGONCOMPUTESERVERDIGEST(struct rpc_pipe_client *cli,
						  TALLOC_CTX *mem_ctx,
						  WERROR *werror)
{
	struct netr_NETRLOGONCOMPUTESERVERDIGEST r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_NETRLOGONCOMPUTESERVERDIGEST, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_NETRLOGONCOMPUTESERVERDIGEST,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_NETRLOGONCOMPUTESERVERDIGEST, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_netr_NETRLOGONCOMPUTECLIENTDIGEST(struct rpc_pipe_client *cli,
						  TALLOC_CTX *mem_ctx,
						  WERROR *werror)
{
	struct netr_NETRLOGONCOMPUTECLIENTDIGEST r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_NETRLOGONCOMPUTECLIENTDIGEST, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_NETRLOGONCOMPUTECLIENTDIGEST,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_NETRLOGONCOMPUTECLIENTDIGEST, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_netr_ServerAuthenticate3(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 const char *server_name /* [in] [unique,charset(UTF16)] */,
					 const char *account_name /* [in] [charset(UTF16)] */,
					 enum netr_SchannelType secure_channel_type /* [in]  */,
					 const char *computer_name /* [in] [charset(UTF16)] */,
					 struct netr_Credential *credentials /* [in,out] [ref] */,
					 uint32_t *negotiate_flags /* [in,out] [ref] */,
					 uint32_t *rid /* [out] [ref] */)
{
	struct netr_ServerAuthenticate3 r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;
	r.in.account_name = account_name;
	r.in.secure_channel_type = secure_channel_type;
	r.in.computer_name = computer_name;
	r.in.credentials = credentials;
	r.in.negotiate_flags = negotiate_flags;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_ServerAuthenticate3, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_SERVERAUTHENTICATE3,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_ServerAuthenticate3, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*credentials = *r.out.credentials;
	*negotiate_flags = *r.out.negotiate_flags;
	*rid = *r.out.rid;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_netr_DsRGetDCNameEx(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    const char *server_unc /* [in] [unique,charset(UTF16)] */,
				    const char *domain_name /* [in] [unique,charset(UTF16)] */,
				    struct GUID *domain_guid /* [in] [unique] */,
				    const char *site_name /* [in] [unique,charset(UTF16)] */,
				    uint32_t flags /* [in]  */,
				    struct netr_DsRGetDCNameInfo **info /* [out] [ref] */,
				    WERROR *werror)
{
	struct netr_DsRGetDCNameEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = server_unc;
	r.in.domain_name = domain_name;
	r.in.domain_guid = domain_guid;
	r.in.site_name = site_name;
	r.in.flags = flags;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_DsRGetDCNameEx, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_DSRGETDCNAMEEX,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_DsRGetDCNameEx, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info = *r.out.info;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_netr_DsRGetSiteName(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    const char *computer_name /* [in] [unique,charset(UTF16)] */,
				    const char **site /* [out] [ref,charset(UTF16)] */,
				    WERROR *werror)
{
	struct netr_DsRGetSiteName r;
	NTSTATUS status;

	/* In parameters */
	r.in.computer_name = computer_name;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_DsRGetSiteName, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_DSRGETSITENAME,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_DsRGetSiteName, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*site = *r.out.site;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_netr_LogonGetDomainInfo(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					const char *server_name /* [in] [charset(UTF16)] */,
					const char *computer_name /* [in] [unique,charset(UTF16)] */,
					struct netr_Authenticator *credential /* [in] [ref] */,
					struct netr_Authenticator *return_authenticator /* [in,out] [ref] */,
					uint32_t level /* [in]  */,
					union netr_DomainQuery query /* [in] [switch_is(level)] */,
					union netr_DomainInfo *info /* [out] [ref,switch_is(level)] */)
{
	struct netr_LogonGetDomainInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;
	r.in.computer_name = computer_name;
	r.in.credential = credential;
	r.in.return_authenticator = return_authenticator;
	r.in.level = level;
	r.in.query = query;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_LogonGetDomainInfo, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_LOGONGETDOMAININFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_LogonGetDomainInfo, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*return_authenticator = *r.out.return_authenticator;
	*info = *r.out.info;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_netr_ServerPasswordSet2(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					const char *server_name /* [in] [unique,charset(UTF16)] */,
					const char *account_name /* [in] [charset(UTF16)] */,
					enum netr_SchannelType secure_channel_type /* [in]  */,
					const char *computer_name /* [in] [charset(UTF16)] */,
					struct netr_Authenticator *credential /* [in] [ref] */,
					struct netr_Authenticator *return_authenticator /* [out] [ref] */,
					struct netr_CryptPassword *new_password /* [in] [ref] */)
{
	struct netr_ServerPasswordSet2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;
	r.in.account_name = account_name;
	r.in.secure_channel_type = secure_channel_type;
	r.in.computer_name = computer_name;
	r.in.credential = credential;
	r.in.new_password = new_password;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_ServerPasswordSet2, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_SERVERPASSWORDSET2,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_ServerPasswordSet2, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*return_authenticator = *r.out.return_authenticator;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_netr_ServerPasswordGet(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       const char *server_name /* [in] [unique,charset(UTF16)] */,
				       const char *account_name /* [in] [charset(UTF16)] */,
				       enum netr_SchannelType secure_channel_type /* [in]  */,
				       const char *computer_name /* [in] [charset(UTF16)] */,
				       struct netr_Authenticator *credential /* [in] [ref] */,
				       struct netr_Authenticator *return_authenticator /* [out] [ref] */,
				       struct samr_Password *password /* [out] [ref] */,
				       WERROR *werror)
{
	struct netr_ServerPasswordGet r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;
	r.in.account_name = account_name;
	r.in.secure_channel_type = secure_channel_type;
	r.in.computer_name = computer_name;
	r.in.credential = credential;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_ServerPasswordGet, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_SERVERPASSWORDGET,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_ServerPasswordGet, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*return_authenticator = *r.out.return_authenticator;
	*password = *r.out.password;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_netr_NETRLOGONSENDTOSAM(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					WERROR *werror)
{
	struct netr_NETRLOGONSENDTOSAM r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_NETRLOGONSENDTOSAM, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_NETRLOGONSENDTOSAM,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_NETRLOGONSENDTOSAM, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_netr_DsRAddressToSitenamesW(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx,
					    const char *server_name /* [in] [unique,charset(UTF16)] */,
					    uint32_t count /* [in] [range(0,32000)] */,
					    struct netr_DsRAddress *addresses /* [in] [ref,size_is(count)] */,
					    struct netr_DsRAddressToSitenamesWCtr **ctr /* [out] [ref] */,
					    WERROR *werror)
{
	struct netr_DsRAddressToSitenamesW r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;
	r.in.count = count;
	r.in.addresses = addresses;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_DsRAddressToSitenamesW, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_DSRADDRESSTOSITENAMESW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_DsRAddressToSitenamesW, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ctr = *r.out.ctr;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_netr_DsRGetDCNameEx2(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     const char *server_unc /* [in] [unique,charset(UTF16)] */,
				     const char *client_account /* [in] [unique,charset(UTF16)] */,
				     uint32_t mask /* [in]  */,
				     const char *domain_name /* [in] [unique,charset(UTF16)] */,
				     struct GUID *domain_guid /* [in] [unique] */,
				     const char *site_name /* [in] [unique,charset(UTF16)] */,
				     uint32_t flags /* [in]  */,
				     struct netr_DsRGetDCNameInfo **info /* [out] [ref] */,
				     WERROR *werror)
{
	struct netr_DsRGetDCNameEx2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_unc = server_unc;
	r.in.client_account = client_account;
	r.in.mask = mask;
	r.in.domain_name = domain_name;
	r.in.domain_guid = domain_guid;
	r.in.site_name = site_name;
	r.in.flags = flags;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_DsRGetDCNameEx2, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_DSRGETDCNAMEEX2,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_DsRGetDCNameEx2, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info = *r.out.info;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN(struct rpc_pipe_client *cli,
							 TALLOC_CTX *mem_ctx,
							 WERROR *werror)
{
	struct netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_NETRLOGONGETTIMESERVICEPARENTDOMAIN,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_netr_NetrEnumerateTrustedDomainsEx(struct rpc_pipe_client *cli,
						   TALLOC_CTX *mem_ctx,
						   const char *server_name /* [in] [unique,charset(UTF16)] */,
						   struct netr_DomainTrustList *dom_trust_list /* [out] [ref] */,
						   WERROR *werror)
{
	struct netr_NetrEnumerateTrustedDomainsEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_NetrEnumerateTrustedDomainsEx, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_NETRENUMERATETRUSTEDDOMAINSEX,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_NetrEnumerateTrustedDomainsEx, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*dom_trust_list = *r.out.dom_trust_list;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_netr_DsRAddressToSitenamesExW(struct rpc_pipe_client *cli,
					      TALLOC_CTX *mem_ctx,
					      const char *server_name /* [in] [unique,charset(UTF16)] */,
					      uint32_t count /* [in] [range(0,32000)] */,
					      struct netr_DsRAddress *addresses /* [in] [ref,size_is(count)] */,
					      struct netr_DsRAddressToSitenamesExWCtr **ctr /* [out] [ref] */,
					      WERROR *werror)
{
	struct netr_DsRAddressToSitenamesExW r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;
	r.in.count = count;
	r.in.addresses = addresses;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_DsRAddressToSitenamesExW, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_DSRADDRESSTOSITENAMESEXW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_DsRAddressToSitenamesExW, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ctr = *r.out.ctr;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_netr_DsrGetDcSiteCoverageW(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   const char *server_name /* [in] [unique,charset(UTF16)] */,
					   struct DcSitesCtr *ctr /* [out] [ref] */,
					   WERROR *werror)
{
	struct netr_DsrGetDcSiteCoverageW r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_DsrGetDcSiteCoverageW, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_DSRGETDCSITECOVERAGEW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_DsrGetDcSiteCoverageW, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*ctr = *r.out.ctr;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_netr_LogonSamLogonEx(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     const char *server_name /* [in] [unique,charset(UTF16)] */,
				     const char *computer_name /* [in] [unique,charset(UTF16)] */,
				     enum netr_LogonLevel logon_level /* [in]  */,
				     union netr_LogonInfo *logon /* [in] [ref,switch_is(logon_level)] */,
				     uint16_t validation_level /* [in]  */,
				     union netr_Validation *validation /* [out] [ref,switch_is(validation_level)] */,
				     uint8_t *authoritative /* [out] [ref] */,
				     uint32_t *flags /* [in,out] [ref] */)
{
	struct netr_LogonSamLogonEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;
	r.in.computer_name = computer_name;
	r.in.logon_level = logon_level;
	r.in.logon = logon;
	r.in.validation_level = validation_level;
	r.in.flags = flags;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_LogonSamLogonEx, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_LOGONSAMLOGONEX,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_LogonSamLogonEx, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*validation = *r.out.validation;
	*authoritative = *r.out.authoritative;
	*flags = *r.out.flags;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_netr_DsrEnumerateDomainTrusts(struct rpc_pipe_client *cli,
					      TALLOC_CTX *mem_ctx,
					      const char *server_name /* [in] [unique,charset(UTF16)] */,
					      uint32_t trust_flags /* [in]  */,
					      struct netr_DomainTrustList *trusts /* [out] [ref] */,
					      WERROR *werror)
{
	struct netr_DsrEnumerateDomainTrusts r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;
	r.in.trust_flags = trust_flags;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_DsrEnumerateDomainTrusts, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_DSRENUMERATEDOMAINTRUSTS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_DsrEnumerateDomainTrusts, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*trusts = *r.out.trusts;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_netr_DsrDeregisterDNSHostRecords(struct rpc_pipe_client *cli,
						 TALLOC_CTX *mem_ctx,
						 const char *server_name /* [in] [unique,charset(UTF16)] */,
						 const char *domain /* [in] [unique,charset(UTF16)] */,
						 struct GUID *domain_guid /* [in] [unique] */,
						 struct GUID *dsa_guid /* [in] [unique] */,
						 const char *dns_host /* [in] [ref,charset(UTF16)] */,
						 WERROR *werror)
{
	struct netr_DsrDeregisterDNSHostRecords r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;
	r.in.domain = domain;
	r.in.domain_guid = domain_guid;
	r.in.dsa_guid = dsa_guid;
	r.in.dns_host = dns_host;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_DsrDeregisterDNSHostRecords, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_DSRDEREGISTERDNSHOSTRECORDS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_DsrDeregisterDNSHostRecords, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_netr_ServerTrustPasswordsGet(struct rpc_pipe_client *cli,
					     TALLOC_CTX *mem_ctx,
					     const char *server_name /* [in] [unique,charset(UTF16)] */,
					     const char *account_name /* [in] [charset(UTF16)] */,
					     enum netr_SchannelType secure_channel_type /* [in]  */,
					     const char *computer_name /* [in] [charset(UTF16)] */,
					     struct netr_Authenticator *credential /* [in] [ref] */,
					     struct netr_Authenticator *return_authenticator /* [out] [ref] */,
					     struct samr_Password *password /* [out] [ref] */,
					     struct samr_Password *password2 /* [out] [ref] */)
{
	struct netr_ServerTrustPasswordsGet r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;
	r.in.account_name = account_name;
	r.in.secure_channel_type = secure_channel_type;
	r.in.computer_name = computer_name;
	r.in.credential = credential;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_ServerTrustPasswordsGet, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_SERVERTRUSTPASSWORDSGET,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_ServerTrustPasswordsGet, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*return_authenticator = *r.out.return_authenticator;
	*password = *r.out.password;
	*password2 = *r.out.password2;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_netr_DsRGetForestTrustInformation(struct rpc_pipe_client *cli,
						  TALLOC_CTX *mem_ctx,
						  const char *server_name /* [in] [unique,charset(UTF16)] */,
						  const char *trusted_domain_name /* [in] [unique,charset(UTF16)] */,
						  uint32_t flags /* [in]  */,
						  struct lsa_ForestTrustInformation **forest_trust_info /* [out] [ref] */,
						  WERROR *werror)
{
	struct netr_DsRGetForestTrustInformation r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;
	r.in.trusted_domain_name = trusted_domain_name;
	r.in.flags = flags;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_DsRGetForestTrustInformation, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_DSRGETFORESTTRUSTINFORMATION,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_DsRGetForestTrustInformation, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*forest_trust_info = *r.out.forest_trust_info;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_netr_GetForestTrustInformation(struct rpc_pipe_client *cli,
					       TALLOC_CTX *mem_ctx,
					       const char *server_name /* [in] [unique,charset(UTF16)] */,
					       const char *trusted_domain_name /* [in] [ref,charset(UTF16)] */,
					       struct netr_Authenticator *credential /* [in] [ref] */,
					       struct netr_Authenticator *return_authenticator /* [out] [ref] */,
					       uint32_t flags /* [in]  */,
					       struct lsa_ForestTrustInformation **forest_trust_info /* [out] [ref] */,
					       WERROR *werror)
{
	struct netr_GetForestTrustInformation r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;
	r.in.trusted_domain_name = trusted_domain_name;
	r.in.credential = credential;
	r.in.flags = flags;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_GetForestTrustInformation, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_GETFORESTTRUSTINFORMATION,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_GetForestTrustInformation, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*return_authenticator = *r.out.return_authenticator;
	*forest_trust_info = *r.out.forest_trust_info;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_netr_LogonSamLogonWithFlags(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx,
					    const char *server_name /* [in] [unique,charset(UTF16)] */,
					    const char *computer_name /* [in] [unique,charset(UTF16)] */,
					    struct netr_Authenticator *credential /* [in] [unique] */,
					    struct netr_Authenticator *return_authenticator /* [in,out] [unique] */,
					    enum netr_LogonLevel logon_level /* [in]  */,
					    union netr_LogonInfo logon /* [in] [switch_is(logon_level)] */,
					    uint16_t validation_level /* [in]  */,
					    union netr_Validation *validation /* [out] [ref,switch_is(validation_level)] */,
					    uint8_t *authoritative /* [out] [ref] */,
					    uint32_t *flags /* [in,out] [ref] */)
{
	struct netr_LogonSamLogonWithFlags r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = server_name;
	r.in.computer_name = computer_name;
	r.in.credential = credential;
	r.in.return_authenticator = return_authenticator;
	r.in.logon_level = logon_level;
	r.in.logon = logon;
	r.in.validation_level = validation_level;
	r.in.flags = flags;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_LogonSamLogonWithFlags, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_LOGONSAMLOGONWITHFLAGS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_LogonSamLogonWithFlags, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	if (return_authenticator && r.out.return_authenticator) {
		*return_authenticator = *r.out.return_authenticator;
	}
	*validation = *r.out.validation;
	*authoritative = *r.out.authoritative;
	*flags = *r.out.flags;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_netr_NETRSERVERGETTRUSTINFO(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx,
					    WERROR *werror)
{
	struct netr_NETRSERVERGETTRUSTINFO r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(netr_NETRSERVERGETTRUSTINFO, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_netlogon,
				NDR_NETR_NETRSERVERGETTRUSTINFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(netr_NETRSERVERGETTRUSTINFO, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

