
/* 
 *  Unix SMB/Netbios implementation.
 *  Version 1.9.
 *  RPC Pipe client / server routines
 *  Copyright (C) Andrew Tridgell              1992-1997,
 *  Copyright (C) Luke Kenneth Casson Leighton 1996-1997,
 *  Copyright (C) Paul Ashton                       1997.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "../includes.h"

extern int DEBUGLEVEL;


/*******************************************************************
reads or writes a structure.
********************************************************************/
void wks_io_q_unknown_0(char *desc,  WKS_Q_UNKNOWN_0 *q_u, prs_struct *ps)
{
	if (q_u == NULL) return;

	prs_debug(ps, desc, "wks_io_q_unknown_0");
	

	prs_align(ps);

	prs_uint32("ptr_srv_name", ps, &(q_u->ptr_srv_name));
	smb_io_unistr2("", &(q_u->uni_srv_name), q_u->ptr_srv_name, ps); 

	prs_align(ps);

	prs_uint32("unknown_0   ", ps, &(q_u->unknown_0   ));
	prs_uint16("unknown_1   ", ps, &(q_u->unknown_1   ));
}

/*******************************************************************
reads or writes a structure.
********************************************************************/
void wks_io_r_unknown_0(char *desc,  WKS_R_UNKNOWN_0 *r_u, prs_struct *ps)
{
	if (r_u == NULL) return;

	prs_debug(ps, desc, "wks_io_r_unknown_0");
	

	prs_align(ps);

	prs_uint32("unknown_0   ", ps, &(r_u->unknown_0   )); /* 64 - unknown */
	prs_uint32("ptr_1       ", ps, &(r_u->ptr_1       )); /* pointer 1 */
	prs_uint32("unknown_1   ", ps, &(r_u->unknown_1   )); /* 0x0000 01f4 - unknown */
	prs_uint32("ptr_srv_name", ps, &(r_u->ptr_srv_name)); /* pointer to server name */
	prs_uint32("ptr_dom_name", ps, &(r_u->ptr_dom_name)); /* pointer to domain name */
	prs_uint32("unknown_2   ", ps, &(r_u->unknown_2   )); /* 4 - unknown */
	prs_uint32("unknown_3   ", ps, &(r_u->unknown_3   )); /* 0 - unknown */

	smb_io_unistr2("", &(r_u->uni_srv_name), r_u->ptr_srv_name, ps); 
	prs_align(ps);

	smb_io_unistr2("", &(r_u->uni_dom_name), r_u->ptr_dom_name, ps); 
	prs_align(ps);

	prs_uint32("status        ", ps, &(r_u->status));
}

