
/* 
 *  Unix SMB/Netbios implementation.
 *  Version 1.9.
 *  RPC Pipe client / server routines
 *  Copyright (C) Andrew Tridgell              1992-1997,
 *  Copyright (C) Luke Kenneth Casson Leighton 1996-1997,
 *  Copyright (C) Paul Ashton                       1997.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "../includes.h"

extern int DEBUGLEVEL;


/*******************************************************************
reads or writes a structure.
********************************************************************/
void wks_io_q_unknown_0(char *desc, BOOL io, WKS_Q_UNKNOWN_0 *q_u, struct mem_buffer *buf, int *q,  int depth)
{
	if (q_u == NULL) return;

	DEBUG(5,("%s%06x wks_io_q_unknown_0%s\n", tab_depth(depth), *q, desc));
	depth++;

	buf_align(buf, q);

	buf_uint32("ptr_srv_name", depth, buf, q, io, &(q_u->ptr_srv_name));
	smb_io_unistr2("", io, &(q_u->uni_srv_name), q_u->ptr_srv_name, buf, q, depth); 

	buf_align(buf, q);

	buf_uint32("unknown_0   ", depth, buf, q, io, &(q_u->unknown_0   ));
	buf_uint16("unknown_1   ", depth, buf, q, io, &(q_u->unknown_1   ));
}

/*******************************************************************
reads or writes a structure.
********************************************************************/
void wks_io_r_unknown_0(char *desc, BOOL io, WKS_R_UNKNOWN_0 *r_u, struct mem_buffer *buf, int *q,  int depth)
{
	if (r_u == NULL) return;

	DEBUG(5,("%s%06x wks_io_r_unknown_0%s\n", tab_depth(depth), *q, desc));
	depth++;

	buf_align(buf, q);

	buf_uint32("unknown_0   ", depth, buf, q, io, &(r_u->unknown_0   )); /* 64 - unknown */
	buf_uint32("ptr_1       ", depth, buf, q, io, &(r_u->ptr_1       )); /* pointer 1 */
	buf_uint32("unknown_1   ", depth, buf, q, io, &(r_u->unknown_1   )); /* 0x0000 01f4 - unknown */
	buf_uint32("ptr_srv_name", depth, buf, q, io, &(r_u->ptr_srv_name)); /* pointer to server name */
	buf_uint32("ptr_dom_name", depth, buf, q, io, &(r_u->ptr_dom_name)); /* pointer to domain name */
	buf_uint32("unknown_2   ", depth, buf, q, io, &(r_u->unknown_2   )); /* 4 - unknown */
	buf_uint32("unknown_3   ", depth, buf, q, io, &(r_u->unknown_3   )); /* 0 - unknown */

	smb_io_unistr2("", io, &(r_u->uni_srv_name), r_u->ptr_srv_name, buf, q, depth); 
	buf_align(buf, q);

	smb_io_unistr2("", io, &(r_u->uni_dom_name), r_u->ptr_dom_name, buf, q, depth); 
	buf_align(buf, q);

	buf_uint32("status        ", depth, buf, q, io, &(r_u->status));
}

