#! /usr/bin/perl

# SMB2WWW - a smb to WWW gateway; access windows computers through a browser
# Copyright (C) 1997 Remco van Mook

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# The author can be contacted by e-mail: remco@samba.anu.edu.au

use strict;
use smb2www;

my %all=decode_query;
my $key = "";
foreach $key (keys %all) {
  $all{$key} = urlDecode $all{$key};
}

my @smbout = GetSMBHosts ("$all{master}","$all{group}");

if ( $#smbout < 0 ) {
   header ("Group Not Found");
   print "<H1>The group you requested could not be found.</H1><BR>\n";
   table ( 
     href (shref("all"),image ($cfg{icon_all},"Network")),
     "<H3>The Entire Network</H3>",
     ""
   );
   trailer;
   exit;
}

header ( "Computers in group $all{'group'}" );

table ( 
  href (shref("all"), image ($cfg{icon_all},"Network")),
  "",
  "",
  "<H3>The Entire Network</H3>",
  ""
);        
table ( 
  "",
  image ($cfg{icon_group},"Workgroup"),
  "",
  "<H3>".uc ($all{'group'})."</H3>",
  ""
);

my $line = "";
foreach $line ( @smbout ) { 
    my $url = shref("share","$all{'group'}","$all{'master'}","$line->{name}");
    table ( "",
            "",
            href ($url,image ($cfg{icon_computer},"Shares")),
            href ($url,"<B>$line->{name}</B>"),
            "$line->{comment}"
    );
  }                                                                             
trailer;
