/* This file is autogenerated by pidl. DO NOT EDIT */
%module spoolss

%{
#include "includes.h"
#include "auth/credentials/credentials.h"
#include "librpc/gen_ndr/ndr_spoolss_c.h"
#include "librpc/gen_ndr/spoolss.h"
%}
%import "samba.i"

%inline {
void ntstatus_exception(NTSTATUS status)
{
	/* FIXME */
}
}

%types(spoolss_DeviceMode);
%types(spoolss_EnumPrinterFlags);
%types(spoolss_PrinterInfo);
%types(spoolss_JobInfo);
%types(spoolss_DriverInfo);
%types(spoolss_DriverDirectoryInfo);
%types(spoolss_PrintProcessorInfo);
%types(spoolss_OSVersion);
%types(spoolss_OSVersionEx);
%types(spoolss_PrinterData);
%types(spoolss_FormInfo);
%types(spoolss_PortInfo);
%types(spoolss_MonitorInfo);


%inline {
struct spoolss { struct dcerpc_pipe *pipe; };
}

%extend spoolss {
	spoolss (const char *binding, struct cli_credentials *cred = NULL, TALLOC_CTX *mem_ctx = NULL, struct event_context *event = NULL)
	{
		struct spoolss *ret = talloc(mem_ctx, struct spoolss);
		NTSTATUS status;
		
		status = dcerpc_pipe_connect(mem_ctx, &ret->pipe, binding, &dcerpc_table_spoolss, cred, event);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return NULL;
		}
		
		return ret;
	}
	
	~spoolss() {
		talloc_free(self);
	}
	
	/* _spoolss_EnumPrinters */
	WERROR _spoolss_EnumPrinters(uint32_t flags, const char *server, uint32_t level, DATA_BLOB *buffer, uint32_t offered, DATA_BLOB *info, uint32_t needed, uint32_t count, TALLOC_CTX *mem_ctx = NULL)
	{
		struct _spoolss_EnumPrinters r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.flags = flags;
		r.in.server = server;
		r.in.level = level;
		r.in.buffer = buffer;
		r.in.offered = offered;
		
		status = dcerpc__spoolss_EnumPrinters(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*info = *r.out.info;
		/* FIXME: needed [out] argument is not a pointer */
		*needed = *r.out.needed;
		/* FIXME: count [out] argument is not a pointer */
		*count = *r.out.count;
		return r.out.result;
	}
	
	/* __spoolss_EnumPrinters */
	void __spoolss_EnumPrinters(uint32_t level, uint32_t count, union spoolss_PrinterInfo *info, TALLOC_CTX *mem_ctx = NULL)
	{
		struct __spoolss_EnumPrinters r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.level = level;
		r.in.count = count;
		
		status = dcerpc___spoolss_EnumPrinters(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return;
		}
		
		/* Set out arguments */
		/* FIXME: info [out] argument is not a pointer */
		*info = *r.out.info;
	}
	
	/* spoolss_EnumPrinters */
	WERROR EnumPrinters(uint32_t flags, const char *server, uint32_t level, DATA_BLOB *buffer, uint32_t offered, union spoolss_PrinterInfo *info, uint32_t needed, uint32_t count, TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_EnumPrinters r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.flags = flags;
		r.in.server = server;
		r.in.level = level;
		r.in.buffer = buffer;
		r.in.offered = offered;
		
		status = dcerpc_spoolss_EnumPrinters(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*info = *r.out.info;
		/* FIXME: needed [out] argument is not a pointer */
		*needed = *r.out.needed;
		/* FIXME: count [out] argument is not a pointer */
		*count = *r.out.count;
		return r.out.result;
	}
	
	/* spoolss_OpenPrinter */
	WERROR OpenPrinter(const char *printername, const char *datatype, struct spoolss_DevmodeContainer devmode_ctr, uint32_t access_mask, struct policy_handle *handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_OpenPrinter r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.printername = printername;
		r.in.datatype = datatype;
		r.in.devmode_ctr = devmode_ctr;
		r.in.access_mask = access_mask;
		
		status = dcerpc_spoolss_OpenPrinter(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*handle = *r.out.handle;
		return r.out.result;
	}
	
	/* spoolss_SetJob */
	WERROR SetJob(struct policy_handle *handle, uint32_t job_id, struct spoolss_JobInfoContainer *ctr, enum spoolss_JobControl command, TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_SetJob r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.job_id = job_id;
		r.in.ctr = ctr;
		r.in.command = command;
		
		status = dcerpc_spoolss_SetJob(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_GetJob */
	WERROR GetJob(struct policy_handle *handle, uint32_t job_id, uint32_t level, DATA_BLOB *buffer, uint32_t offered, union spoolss_JobInfo *info, uint32_t needed, TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_GetJob r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.job_id = job_id;
		r.in.level = level;
		r.in.buffer = buffer;
		r.in.offered = offered;
		
		status = dcerpc_spoolss_GetJob(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*info = *r.out.info;
		/* FIXME: needed [out] argument is not a pointer */
		*needed = *r.out.needed;
		return r.out.result;
	}
	
	/* _spoolss_EnumJobs */
	WERROR _spoolss_EnumJobs(struct policy_handle *handle, uint32_t firstjob, uint32_t numjobs, uint32_t level, DATA_BLOB *buffer, uint32_t offered, DATA_BLOB *info, uint32_t needed, uint32_t count, TALLOC_CTX *mem_ctx = NULL)
	{
		struct _spoolss_EnumJobs r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.firstjob = firstjob;
		r.in.numjobs = numjobs;
		r.in.level = level;
		r.in.buffer = buffer;
		r.in.offered = offered;
		
		status = dcerpc__spoolss_EnumJobs(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*info = *r.out.info;
		/* FIXME: needed [out] argument is not a pointer */
		*needed = *r.out.needed;
		/* FIXME: count [out] argument is not a pointer */
		*count = *r.out.count;
		return r.out.result;
	}
	
	/* __spoolss_EnumJobs */
	void __spoolss_EnumJobs(uint32_t level, uint32_t count, union spoolss_JobInfo *info, TALLOC_CTX *mem_ctx = NULL)
	{
		struct __spoolss_EnumJobs r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.level = level;
		r.in.count = count;
		
		status = dcerpc___spoolss_EnumJobs(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return;
		}
		
		/* Set out arguments */
		/* FIXME: info [out] argument is not a pointer */
		*info = *r.out.info;
	}
	
	/* spoolss_EnumJobs */
	WERROR EnumJobs(struct policy_handle *handle, uint32_t firstjob, uint32_t numjobs, uint32_t level, DATA_BLOB *buffer, uint32_t offered, union spoolss_JobInfo *info, uint32_t needed, uint32_t count, TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_EnumJobs r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.firstjob = firstjob;
		r.in.numjobs = numjobs;
		r.in.level = level;
		r.in.buffer = buffer;
		r.in.offered = offered;
		
		status = dcerpc_spoolss_EnumJobs(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*info = *r.out.info;
		/* FIXME: needed [out] argument is not a pointer */
		*needed = *r.out.needed;
		/* FIXME: count [out] argument is not a pointer */
		*count = *r.out.count;
		return r.out.result;
	}
	
	/* spoolss_AddPrinter */
	WERROR AddPrinter(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_AddPrinter r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_AddPrinter(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_DeletePrinter */
	WERROR DeletePrinter(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_DeletePrinter r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_DeletePrinter(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_SetPrinter */
	WERROR SetPrinter(struct policy_handle *handle, uint32_t level, union spoolss_SetPrinterInfo info, struct spoolss_DevmodeContainer devmode_ctr, struct sec_desc_buf secdesc_ctr, enum spoolss_PrinterControl command, TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_SetPrinter r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.level = level;
		r.in.info = info;
		r.in.devmode_ctr = devmode_ctr;
		r.in.secdesc_ctr = secdesc_ctr;
		r.in.command = command;
		
		status = dcerpc_spoolss_SetPrinter(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_GetPrinter */
	WERROR GetPrinter(struct policy_handle *handle, uint32_t level, DATA_BLOB *buffer, uint32_t offered, union spoolss_PrinterInfo *info, uint32_t needed, TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_GetPrinter r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.level = level;
		r.in.buffer = buffer;
		r.in.offered = offered;
		
		status = dcerpc_spoolss_GetPrinter(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*info = *r.out.info;
		/* FIXME: needed [out] argument is not a pointer */
		*needed = *r.out.needed;
		return r.out.result;
	}
	
	/* spoolss_AddPrinterDriver */
	WERROR AddPrinterDriver(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_AddPrinterDriver r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_AddPrinterDriver(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* _spoolss_EnumPrinterDrivers */
	WERROR _spoolss_EnumPrinterDrivers(const char *server, const char *environment, uint32_t level, DATA_BLOB *buffer, uint32_t offered, DATA_BLOB *info, uint32_t needed, uint32_t count, TALLOC_CTX *mem_ctx = NULL)
	{
		struct _spoolss_EnumPrinterDrivers r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.server = server;
		r.in.environment = environment;
		r.in.level = level;
		r.in.buffer = buffer;
		r.in.offered = offered;
		
		status = dcerpc__spoolss_EnumPrinterDrivers(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*info = *r.out.info;
		/* FIXME: needed [out] argument is not a pointer */
		*needed = *r.out.needed;
		/* FIXME: count [out] argument is not a pointer */
		*count = *r.out.count;
		return r.out.result;
	}
	
	/* __spoolss_EnumPrinterDrivers */
	void __spoolss_EnumPrinterDrivers(uint32_t level, uint32_t count, union spoolss_DriverInfo *info, TALLOC_CTX *mem_ctx = NULL)
	{
		struct __spoolss_EnumPrinterDrivers r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.level = level;
		r.in.count = count;
		
		status = dcerpc___spoolss_EnumPrinterDrivers(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return;
		}
		
		/* Set out arguments */
		/* FIXME: info [out] argument is not a pointer */
		*info = *r.out.info;
	}
	
	/* spoolss_EnumPrinterDrivers */
	WERROR EnumPrinterDrivers(const char *server, const char *environment, uint32_t level, DATA_BLOB *buffer, uint32_t offered, union spoolss_DriverInfo *info, uint32_t needed, uint32_t count, TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_EnumPrinterDrivers r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.server = server;
		r.in.environment = environment;
		r.in.level = level;
		r.in.buffer = buffer;
		r.in.offered = offered;
		
		status = dcerpc_spoolss_EnumPrinterDrivers(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*info = *r.out.info;
		/* FIXME: needed [out] argument is not a pointer */
		*needed = *r.out.needed;
		/* FIXME: count [out] argument is not a pointer */
		*count = *r.out.count;
		return r.out.result;
	}
	
	/* spoolss_GetPrinterDriver */
	WERROR GetPrinterDriver(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_GetPrinterDriver r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_GetPrinterDriver(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_GetPrinterDriverDirectory */
	WERROR GetPrinterDriverDirectory(const char *server, const char *environment, uint32_t level, DATA_BLOB *buffer, uint32_t offered, union spoolss_DriverDirectoryInfo *info, uint32_t needed, TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_GetPrinterDriverDirectory r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.server = server;
		r.in.environment = environment;
		r.in.level = level;
		r.in.buffer = buffer;
		r.in.offered = offered;
		
		status = dcerpc_spoolss_GetPrinterDriverDirectory(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*info = *r.out.info;
		/* FIXME: needed [out] argument is not a pointer */
		*needed = *r.out.needed;
		return r.out.result;
	}
	
	/* spoolss_DeletePrinterDriver */
	WERROR DeletePrinterDriver(struct policy_handle *handle, const char *server, const char *architecture, const char *driver, TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_DeletePrinterDriver r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.server = server;
		r.in.architecture = architecture;
		r.in.driver = driver;
		
		status = dcerpc_spoolss_DeletePrinterDriver(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_AddPrintProcessor */
	WERROR AddPrintProcessor(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_AddPrintProcessor r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_AddPrintProcessor(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* _spoolss_EnumPrintProcessors */
	WERROR _spoolss_EnumPrintProcessors(const char *servername, const char *environment, uint32_t level, DATA_BLOB *buffer, uint32_t offered, DATA_BLOB *info, uint32_t needed, uint32_t count, TALLOC_CTX *mem_ctx = NULL)
	{
		struct _spoolss_EnumPrintProcessors r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.servername = servername;
		r.in.environment = environment;
		r.in.level = level;
		r.in.buffer = buffer;
		r.in.offered = offered;
		
		status = dcerpc__spoolss_EnumPrintProcessors(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*info = *r.out.info;
		/* FIXME: needed [out] argument is not a pointer */
		*needed = *r.out.needed;
		/* FIXME: count [out] argument is not a pointer */
		*count = *r.out.count;
		return r.out.result;
	}
	
	/* __spoolss_EnumPrintProcessors */
	void __spoolss_EnumPrintProcessors(uint32_t level, uint32_t count, union spoolss_PrintProcessorInfo *info, TALLOC_CTX *mem_ctx = NULL)
	{
		struct __spoolss_EnumPrintProcessors r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.level = level;
		r.in.count = count;
		
		status = dcerpc___spoolss_EnumPrintProcessors(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return;
		}
		
		/* Set out arguments */
		/* FIXME: info [out] argument is not a pointer */
		*info = *r.out.info;
	}
	
	/* spoolss_EnumPrintProcessors */
	WERROR EnumPrintProcessors(const char *servername, const char *environment, uint32_t level, DATA_BLOB *buffer, uint32_t offered, union spoolss_PrintProcessorInfo *info, uint32_t needed, uint32_t count, TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_EnumPrintProcessors r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.servername = servername;
		r.in.environment = environment;
		r.in.level = level;
		r.in.buffer = buffer;
		r.in.offered = offered;
		
		status = dcerpc_spoolss_EnumPrintProcessors(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*info = *r.out.info;
		/* FIXME: needed [out] argument is not a pointer */
		*needed = *r.out.needed;
		/* FIXME: count [out] argument is not a pointer */
		*count = *r.out.count;
		return r.out.result;
	}
	
	/* spoolss_GetPrintProcessorDirectory */
	WERROR GetPrintProcessorDirectory(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_GetPrintProcessorDirectory r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_GetPrintProcessorDirectory(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_StartDocPrinter */
	WERROR StartDocPrinter(struct policy_handle *handle, uint32_t level, union spoolss_DocumentInfo info, uint32_t job_id, TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_StartDocPrinter r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.level = level;
		r.in.info = info;
		
		status = dcerpc_spoolss_StartDocPrinter(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: job_id [out] argument is not a pointer */
		*job_id = *r.out.job_id;
		return r.out.result;
	}
	
	/* spoolss_StartPagePrinter */
	WERROR StartPagePrinter(struct policy_handle *handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_StartPagePrinter r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		
		status = dcerpc_spoolss_StartPagePrinter(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_WritePrinter */
	WERROR WritePrinter(struct policy_handle *handle, DATA_BLOB data, uint32_t _data_size, uint32_t num_written, TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_WritePrinter r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.data = data;
		r.in._data_size = _data_size;
		
		status = dcerpc_spoolss_WritePrinter(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: num_written [out] argument is not a pointer */
		*num_written = *r.out.num_written;
		return r.out.result;
	}
	
	/* spoolss_EndPagePrinter */
	WERROR EndPagePrinter(struct policy_handle *handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_EndPagePrinter r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		
		status = dcerpc_spoolss_EndPagePrinter(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_AbortPrinter */
	WERROR AbortPrinter(struct policy_handle *handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_AbortPrinter r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		
		status = dcerpc_spoolss_AbortPrinter(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_ReadPrinter */
	WERROR ReadPrinter(struct policy_handle *handle, uint32_t data_size, DATA_BLOB data, uint32_t _data_size, TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_ReadPrinter r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.data_size = data_size;
		
		status = dcerpc_spoolss_ReadPrinter(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: data [out] argument is not a pointer */
		*data = *r.out.data;
		/* FIXME: _data_size [out] argument is not a pointer */
		*_data_size = *r.out._data_size;
		return r.out.result;
	}
	
	/* spoolss_EndDocPrinter */
	WERROR EndDocPrinter(struct policy_handle *handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_EndDocPrinter r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		
		status = dcerpc_spoolss_EndDocPrinter(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_AddJob */
	WERROR AddJob(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_AddJob r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_AddJob(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_ScheduleJob */
	WERROR ScheduleJob(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_ScheduleJob r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_ScheduleJob(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* _spoolss_GetPrinterData */
	WERROR _spoolss_GetPrinterData(struct policy_handle *handle, const char *value_name, uint32_t offered, enum spoolss_PrinterDataType type, DATA_BLOB data, uint32_t needed, TALLOC_CTX *mem_ctx = NULL)
	{
		struct _spoolss_GetPrinterData r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.value_name = value_name;
		r.in.offered = offered;
		
		status = dcerpc__spoolss_GetPrinterData(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: type [out] argument is not a pointer */
		*type = *r.out.type;
		/* FIXME: data [out] argument is not a pointer */
		*data = *r.out.data;
		/* FIXME: needed [out] argument is not a pointer */
		*needed = *r.out.needed;
		return r.out.result;
	}
	
	/* __spoolss_GetPrinterData */
	void __spoolss_GetPrinterData(enum spoolss_PrinterDataType type, union spoolss_PrinterData data, TALLOC_CTX *mem_ctx = NULL)
	{
		struct __spoolss_GetPrinterData r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.type = type;
		
		status = dcerpc___spoolss_GetPrinterData(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return;
		}
		
		/* Set out arguments */
		/* FIXME: data [out] argument is not a pointer */
		*data = *r.out.data;
	}
	
	/* spoolss_GetPrinterData */
	WERROR GetPrinterData(struct policy_handle *handle, const char *value_name, uint32_t offered, enum spoolss_PrinterDataType type, union spoolss_PrinterData data, uint32_t needed, TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_GetPrinterData r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.value_name = value_name;
		r.in.offered = offered;
		
		status = dcerpc_spoolss_GetPrinterData(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: type [out] argument is not a pointer */
		*type = *r.out.type;
		/* FIXME: data [out] argument is not a pointer */
		*data = *r.out.data;
		/* FIXME: needed [out] argument is not a pointer */
		*needed = *r.out.needed;
		return r.out.result;
	}
	
	/* _spoolss_SetPrinterData */
	WERROR _spoolss_SetPrinterData(struct policy_handle *handle, const char *value_name, enum spoolss_PrinterDataType type, DATA_BLOB data, uint32_t _offered, TALLOC_CTX *mem_ctx = NULL)
	{
		struct _spoolss_SetPrinterData r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.value_name = value_name;
		r.in.type = type;
		r.in.data = data;
		r.in._offered = _offered;
		
		status = dcerpc__spoolss_SetPrinterData(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* __spoolss_SetPrinterData */
	void __spoolss_SetPrinterData(enum spoolss_PrinterDataType type, union spoolss_PrinterData data, TALLOC_CTX *mem_ctx = NULL)
	{
		struct __spoolss_SetPrinterData r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.type = type;
		
		status = dcerpc___spoolss_SetPrinterData(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return;
		}
		
		/* Set out arguments */
		/* FIXME: data [out] argument is not a pointer */
		*data = *r.out.data;
	}
	
	/* spoolss_SetPrinterData */
	WERROR SetPrinterData(struct policy_handle *handle, const char *value_name, enum spoolss_PrinterDataType type, union spoolss_PrinterData data, uint32_t _offered, TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_SetPrinterData r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.value_name = value_name;
		r.in.type = type;
		r.in.data = data;
		r.in._offered = _offered;
		
		status = dcerpc_spoolss_SetPrinterData(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_WaitForPrinterChange */
	WERROR WaitForPrinterChange(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_WaitForPrinterChange r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_WaitForPrinterChange(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_ClosePrinter */
	WERROR ClosePrinter(struct policy_handle *handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_ClosePrinter r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		
		status = dcerpc_spoolss_ClosePrinter(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*handle = *r.out.handle;
		return r.out.result;
	}
	
	/* spoolss_AddForm */
	WERROR AddForm(struct policy_handle *handle, uint32_t level, union spoolss_AddFormInfo info, TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_AddForm r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.level = level;
		r.in.info = info;
		
		status = dcerpc_spoolss_AddForm(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_DeleteForm */
	WERROR DeleteForm(struct policy_handle *handle, const char *form_name, TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_DeleteForm r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.form_name = form_name;
		
		status = dcerpc_spoolss_DeleteForm(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_GetForm */
	WERROR GetForm(struct policy_handle *handle, const char *form_name, uint32_t level, DATA_BLOB *buffer, uint32_t offered, union spoolss_FormInfo *info, uint32_t needed, TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_GetForm r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.form_name = form_name;
		r.in.level = level;
		r.in.buffer = buffer;
		r.in.offered = offered;
		
		status = dcerpc_spoolss_GetForm(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*info = *r.out.info;
		/* FIXME: needed [out] argument is not a pointer */
		*needed = *r.out.needed;
		return r.out.result;
	}
	
	/* spoolss_SetForm */
	WERROR SetForm(struct policy_handle *handle, const char *form_name, uint32_t level, union spoolss_AddFormInfo info, TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_SetForm r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.form_name = form_name;
		r.in.level = level;
		r.in.info = info;
		
		status = dcerpc_spoolss_SetForm(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* _spoolss_EnumForms */
	WERROR _spoolss_EnumForms(struct policy_handle *handle, uint32_t level, DATA_BLOB *buffer, uint32_t offered, DATA_BLOB *info, uint32_t needed, uint32_t count, TALLOC_CTX *mem_ctx = NULL)
	{
		struct _spoolss_EnumForms r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.level = level;
		r.in.buffer = buffer;
		r.in.offered = offered;
		
		status = dcerpc__spoolss_EnumForms(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*info = *r.out.info;
		/* FIXME: needed [out] argument is not a pointer */
		*needed = *r.out.needed;
		/* FIXME: count [out] argument is not a pointer */
		*count = *r.out.count;
		return r.out.result;
	}
	
	/* __spoolss_EnumForms */
	void __spoolss_EnumForms(uint32_t level, uint32_t count, union spoolss_FormInfo *info, TALLOC_CTX *mem_ctx = NULL)
	{
		struct __spoolss_EnumForms r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.level = level;
		r.in.count = count;
		
		status = dcerpc___spoolss_EnumForms(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return;
		}
		
		/* Set out arguments */
		/* FIXME: info [out] argument is not a pointer */
		*info = *r.out.info;
	}
	
	/* spoolss_EnumForms */
	WERROR EnumForms(struct policy_handle *handle, uint32_t level, DATA_BLOB *buffer, uint32_t offered, union spoolss_FormInfo *info, uint32_t needed, uint32_t count, TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_EnumForms r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.level = level;
		r.in.buffer = buffer;
		r.in.offered = offered;
		
		status = dcerpc_spoolss_EnumForms(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*info = *r.out.info;
		/* FIXME: needed [out] argument is not a pointer */
		*needed = *r.out.needed;
		/* FIXME: count [out] argument is not a pointer */
		*count = *r.out.count;
		return r.out.result;
	}
	
	/* _spoolss_EnumPorts */
	WERROR _spoolss_EnumPorts(const char *servername, uint32_t level, DATA_BLOB *buffer, uint32_t offered, DATA_BLOB *info, uint32_t needed, uint32_t count, TALLOC_CTX *mem_ctx = NULL)
	{
		struct _spoolss_EnumPorts r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.servername = servername;
		r.in.level = level;
		r.in.buffer = buffer;
		r.in.offered = offered;
		
		status = dcerpc__spoolss_EnumPorts(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*info = *r.out.info;
		/* FIXME: needed [out] argument is not a pointer */
		*needed = *r.out.needed;
		/* FIXME: count [out] argument is not a pointer */
		*count = *r.out.count;
		return r.out.result;
	}
	
	/* __spoolss_EnumPorts */
	void __spoolss_EnumPorts(uint32_t level, uint32_t count, union spoolss_PortInfo *info, TALLOC_CTX *mem_ctx = NULL)
	{
		struct __spoolss_EnumPorts r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.level = level;
		r.in.count = count;
		
		status = dcerpc___spoolss_EnumPorts(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return;
		}
		
		/* Set out arguments */
		/* FIXME: info [out] argument is not a pointer */
		*info = *r.out.info;
	}
	
	/* spoolss_EnumPorts */
	WERROR EnumPorts(const char *servername, uint32_t level, DATA_BLOB *buffer, uint32_t offered, union spoolss_PortInfo *info, uint32_t needed, uint32_t count, TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_EnumPorts r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.servername = servername;
		r.in.level = level;
		r.in.buffer = buffer;
		r.in.offered = offered;
		
		status = dcerpc_spoolss_EnumPorts(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*info = *r.out.info;
		/* FIXME: needed [out] argument is not a pointer */
		*needed = *r.out.needed;
		/* FIXME: count [out] argument is not a pointer */
		*count = *r.out.count;
		return r.out.result;
	}
	
	/* _spoolss_EnumMonitors */
	WERROR _spoolss_EnumMonitors(const char *servername, uint32_t level, DATA_BLOB *buffer, uint32_t offered, DATA_BLOB *info, uint32_t needed, uint32_t count, TALLOC_CTX *mem_ctx = NULL)
	{
		struct _spoolss_EnumMonitors r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.servername = servername;
		r.in.level = level;
		r.in.buffer = buffer;
		r.in.offered = offered;
		
		status = dcerpc__spoolss_EnumMonitors(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*info = *r.out.info;
		/* FIXME: needed [out] argument is not a pointer */
		*needed = *r.out.needed;
		/* FIXME: count [out] argument is not a pointer */
		*count = *r.out.count;
		return r.out.result;
	}
	
	/* __spoolss_EnumMonitors */
	void __spoolss_EnumMonitors(uint32_t level, uint32_t count, union spoolss_MonitorInfo *info, TALLOC_CTX *mem_ctx = NULL)
	{
		struct __spoolss_EnumMonitors r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.level = level;
		r.in.count = count;
		
		status = dcerpc___spoolss_EnumMonitors(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return;
		}
		
		/* Set out arguments */
		/* FIXME: info [out] argument is not a pointer */
		*info = *r.out.info;
	}
	
	/* spoolss_EnumMonitors */
	WERROR EnumMonitors(const char *servername, uint32_t level, DATA_BLOB *buffer, uint32_t offered, union spoolss_MonitorInfo *info, uint32_t needed, uint32_t count, TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_EnumMonitors r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.servername = servername;
		r.in.level = level;
		r.in.buffer = buffer;
		r.in.offered = offered;
		
		status = dcerpc_spoolss_EnumMonitors(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*info = *r.out.info;
		/* FIXME: needed [out] argument is not a pointer */
		*needed = *r.out.needed;
		/* FIXME: count [out] argument is not a pointer */
		*count = *r.out.count;
		return r.out.result;
	}
	
	/* spoolss_AddPort */
	WERROR AddPort(const char *server_name, uint32_t unknown, const char *monitor_name, TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_AddPort r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.server_name = server_name;
		r.in.unknown = unknown;
		r.in.monitor_name = monitor_name;
		
		status = dcerpc_spoolss_AddPort(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_ConfigurePort */
	WERROR ConfigurePort(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_ConfigurePort r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_ConfigurePort(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_DeletePort */
	WERROR DeletePort(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_DeletePort r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_DeletePort(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_CreatePrinterIC */
	WERROR CreatePrinterIC(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_CreatePrinterIC r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_CreatePrinterIC(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_PlayGDIScriptOnPrinterIC */
	WERROR PlayGDIScriptOnPrinterIC(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_PlayGDIScriptOnPrinterIC r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_PlayGDIScriptOnPrinterIC(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_DeletePrinterIC */
	WERROR DeletePrinterIC(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_DeletePrinterIC r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_DeletePrinterIC(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_AddPrinterConnection */
	WERROR AddPrinterConnection(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_AddPrinterConnection r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_AddPrinterConnection(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_DeletePrinterConnection */
	WERROR DeletePrinterConnection(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_DeletePrinterConnection r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_DeletePrinterConnection(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_PrinterMessageBox */
	WERROR PrinterMessageBox(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_PrinterMessageBox r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_PrinterMessageBox(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_AddMonitor */
	WERROR AddMonitor(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_AddMonitor r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_AddMonitor(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_DeleteMonitor */
	WERROR DeleteMonitor(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_DeleteMonitor r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_DeleteMonitor(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_DeletePrintProcessor */
	WERROR DeletePrintProcessor(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_DeletePrintProcessor r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_DeletePrintProcessor(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_AddPrintProvidor */
	WERROR AddPrintProvidor(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_AddPrintProvidor r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_AddPrintProvidor(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_DeletePrintProvidor */
	WERROR DeletePrintProvidor(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_DeletePrintProvidor r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_DeletePrintProvidor(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_EnumPrintProcDataTypes */
	WERROR EnumPrintProcDataTypes(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_EnumPrintProcDataTypes r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_EnumPrintProcDataTypes(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_ResetPrinter */
	WERROR ResetPrinter(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_ResetPrinter r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_ResetPrinter(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_GetPrinterDriver2 */
	WERROR GetPrinterDriver2(struct policy_handle *handle, const char *architecture, uint32_t level, DATA_BLOB *buffer, uint32_t offered, uint32_t client_major_version, uint32_t client_minor_version, DATA_BLOB *info, uint32_t needed, uint32_t server_major_version, uint32_t server_minor_version, TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_GetPrinterDriver2 r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.architecture = architecture;
		r.in.level = level;
		r.in.buffer = buffer;
		r.in.offered = offered;
		r.in.client_major_version = client_major_version;
		r.in.client_minor_version = client_minor_version;
		
		status = dcerpc_spoolss_GetPrinterDriver2(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*info = *r.out.info;
		/* FIXME: needed [out] argument is not a pointer */
		*needed = *r.out.needed;
		/* FIXME: server_major_version [out] argument is not a pointer */
		*server_major_version = *r.out.server_major_version;
		/* FIXME: server_minor_version [out] argument is not a pointer */
		*server_minor_version = *r.out.server_minor_version;
		return r.out.result;
	}
	
	/* spoolss_FindFirstPrinterChangeNotification */
	WERROR FindFirstPrinterChangeNotification(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_FindFirstPrinterChangeNotification r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_FindFirstPrinterChangeNotification(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_FindNextPrinterChangeNotification */
	WERROR FindNextPrinterChangeNotification(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_FindNextPrinterChangeNotification r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_FindNextPrinterChangeNotification(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_FindClosePrinterNotify */
	WERROR FindClosePrinterNotify(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_FindClosePrinterNotify r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_FindClosePrinterNotify(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_RouterFindFirstPrinterChangeNotificationOld */
	WERROR RouterFindFirstPrinterChangeNotificationOld(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_RouterFindFirstPrinterChangeNotificationOld r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_RouterFindFirstPrinterChangeNotificationOld(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_ReplyOpenPrinter */
	WERROR ReplyOpenPrinter(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_ReplyOpenPrinter r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_ReplyOpenPrinter(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_RouterReplyPrinter */
	WERROR RouterReplyPrinter(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_RouterReplyPrinter r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_RouterReplyPrinter(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_ReplyClosePrinter */
	WERROR ReplyClosePrinter(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_ReplyClosePrinter r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_ReplyClosePrinter(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_AddPortEx */
	WERROR AddPortEx(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_AddPortEx r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_AddPortEx(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_RouterFindFirstPrinterChangeNotification */
	WERROR RouterFindFirstPrinterChangeNotification(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_RouterFindFirstPrinterChangeNotification r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_RouterFindFirstPrinterChangeNotification(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_SpoolerInit */
	WERROR SpoolerInit(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_SpoolerInit r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_SpoolerInit(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_ResetPrinterEx */
	WERROR ResetPrinterEx(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_ResetPrinterEx r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_ResetPrinterEx(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_RemoteFindFirstPrinterChangeNotifyEx */
	WERROR RemoteFindFirstPrinterChangeNotifyEx(struct policy_handle *handle, uint32_t u1, uint32_t u2, const char *str, uint32_t u3, struct spoolss_RemoteFindFirstPrinterChangeNotifyEx_t1 *t1, TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_RemoteFindFirstPrinterChangeNotifyEx r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.u1 = u1;
		r.in.u2 = u2;
		r.in.str = str;
		r.in.u3 = u3;
		r.in.t1 = t1;
		
		status = dcerpc_spoolss_RemoteFindFirstPrinterChangeNotifyEx(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_RouterRefreshPrinterChangeNotification */
	WERROR RouterRefreshPrinterChangeNotification(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_RouterRefreshPrinterChangeNotification r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_RouterRefreshPrinterChangeNotification(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_RemoteFindNextPrinterChangeNotifyEx */
	WERROR RemoteFindNextPrinterChangeNotifyEx(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_RemoteFindNextPrinterChangeNotifyEx r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_RemoteFindNextPrinterChangeNotifyEx(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_44 */
	WERROR 44(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_44 r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_44(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_OpenPrinterEx */
	WERROR OpenPrinterEx(const char *printername, const char *datatype, struct spoolss_DevmodeContainer devmode_ctr, uint32_t access_mask, uint32_t level, union spoolss_UserLevel userlevel, struct policy_handle *handle, TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_OpenPrinterEx r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.printername = printername;
		r.in.datatype = datatype;
		r.in.devmode_ctr = devmode_ctr;
		r.in.access_mask = access_mask;
		r.in.level = level;
		r.in.userlevel = userlevel;
		
		status = dcerpc_spoolss_OpenPrinterEx(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*handle = *r.out.handle;
		return r.out.result;
	}
	
	/* spoolss_AddPrinterEx */
	WERROR AddPrinterEx(const char *server, uint32_t level, union spoolss_PrinterInfo *info, struct spoolss_DevmodeContainer devmode_ctr, struct security_descriptor *secdesc, uint32_t ulevel, union spoolss_UserLevel userlevel, TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_AddPrinterEx r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.server = server;
		r.in.level = level;
		r.in.info = info;
		r.in.devmode_ctr = devmode_ctr;
		r.in.secdesc = secdesc;
		r.in.ulevel = ulevel;
		r.in.userlevel = userlevel;
		
		status = dcerpc_spoolss_AddPrinterEx(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_47 */
	WERROR 47(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_47 r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_47(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_EnumPrinterData */
	WERROR EnumPrinterData(struct policy_handle *handle, uint32_t enum_index, uint32_t value_offered, const char * value_name, uint32_t value_needed, uint32_t printerdata_type, DATA_BLOB buffer, uint32_t *data_size, TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_EnumPrinterData r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.enum_index = enum_index;
		r.in.value_offered = value_offered;
		r.in.data_size = data_size;
		
		status = dcerpc_spoolss_EnumPrinterData(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: value_name [out] argument is not a pointer */
		*value_name = *r.out.value_name;
		/* FIXME: value_needed [out] argument is not a pointer */
		*value_needed = *r.out.value_needed;
		/* FIXME: printerdata_type [out] argument is not a pointer */
		*printerdata_type = *r.out.printerdata_type;
		/* FIXME: buffer [out] argument is not a pointer */
		*buffer = *r.out.buffer;
		*data_size = *r.out.data_size;
		return r.out.result;
	}
	
	/* spoolss_DeletePrinterData */
	WERROR DeletePrinterData(struct policy_handle *handle, const char *value_name, TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_DeletePrinterData r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.value_name = value_name;
		
		status = dcerpc_spoolss_DeletePrinterData(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_4a */
	WERROR 4a(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_4a r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_4a(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_4b */
	WERROR 4b(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_4b r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_4b(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_4c */
	WERROR 4c(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_4c r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_4c(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_SetPrinterDataEx */
	WERROR SetPrinterDataEx(struct policy_handle *handle, const char *key_name, const char *value_name, uint32_t type, DATA_BLOB buffer, uint32_t offered, TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_SetPrinterDataEx r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.key_name = key_name;
		r.in.value_name = value_name;
		r.in.type = type;
		r.in.buffer = buffer;
		r.in.offered = offered;
		
		status = dcerpc_spoolss_SetPrinterDataEx(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_GetPrinterDataEx */
	WERROR GetPrinterDataEx(struct policy_handle *handle, const char *key_name, const char *value_name, uint32_t offered, uint32_t type, DATA_BLOB buffer, uint32_t needed, TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_GetPrinterDataEx r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.key_name = key_name;
		r.in.value_name = value_name;
		r.in.offered = offered;
		
		status = dcerpc_spoolss_GetPrinterDataEx(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: type [out] argument is not a pointer */
		*type = *r.out.type;
		/* FIXME: buffer [out] argument is not a pointer */
		*buffer = *r.out.buffer;
		/* FIXME: needed [out] argument is not a pointer */
		*needed = *r.out.needed;
		return r.out.result;
	}
	
	/* spoolss_EnumPrinterDataEx */
	WERROR EnumPrinterDataEx(struct policy_handle *handle, const char *key_name, uint32_t offered, DATA_BLOB buffer, uint32_t needed, uint32_t count, TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_EnumPrinterDataEx r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.key_name = key_name;
		r.in.offered = offered;
		
		status = dcerpc_spoolss_EnumPrinterDataEx(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: buffer [out] argument is not a pointer */
		*buffer = *r.out.buffer;
		/* FIXME: needed [out] argument is not a pointer */
		*needed = *r.out.needed;
		/* FIXME: count [out] argument is not a pointer */
		*count = *r.out.count;
		return r.out.result;
	}
	
	/* spoolss_EnumPrinterKey */
	WERROR EnumPrinterKey(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_EnumPrinterKey r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_EnumPrinterKey(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_DeletePrinterDataEx */
	WERROR DeletePrinterDataEx(struct policy_handle *handle, const char *key_name, const char *value_name, TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_DeletePrinterDataEx r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.key_name = key_name;
		r.in.value_name = value_name;
		
		status = dcerpc_spoolss_DeletePrinterDataEx(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_DeletePrinterKey */
	WERROR DeletePrinterKey(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_DeletePrinterKey r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_DeletePrinterKey(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_53 */
	WERROR 53(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_53 r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_53(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_DeletePrinterDriverEx */
	WERROR DeletePrinterDriverEx(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_DeletePrinterDriverEx r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_DeletePrinterDriverEx(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_55 */
	WERROR 55(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_55 r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_55(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_56 */
	WERROR 56(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_56 r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_56(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_57 */
	WERROR 57(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_57 r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_57(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_XcvData */
	WERROR XcvData(struct policy_handle *handle, const char *function_name, DATA_BLOB in_data, uint32_t _in_data_length, uint32_t offered, uint32_t unknown1, DATA_BLOB out_data, uint32_t needed, uint32_t unknown2, TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_XcvData r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.handle = handle;
		r.in.function_name = function_name;
		r.in.in_data = in_data;
		r.in._in_data_length = _in_data_length;
		r.in.offered = offered;
		r.in.unknown1 = unknown1;
		
		status = dcerpc_spoolss_XcvData(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: out_data [out] argument is not a pointer */
		*out_data = *r.out.out_data;
		/* FIXME: needed [out] argument is not a pointer */
		*needed = *r.out.needed;
		/* FIXME: unknown2 [out] argument is not a pointer */
		*unknown2 = *r.out.unknown2;
		return r.out.result;
	}
	
	/* spoolss_AddPrinterDriverEx */
	WERROR AddPrinterDriverEx(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_AddPrinterDriverEx r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_AddPrinterDriverEx(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_5a */
	WERROR 5a(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_5a r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_5a(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_5b */
	WERROR 5b(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_5b r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_5b(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_5c */
	WERROR 5c(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_5c r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_5c(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_5d */
	WERROR 5d(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_5d r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_5d(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_5e */
	WERROR 5e(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_5e r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_5e(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* spoolss_5f */
	WERROR 5f(TALLOC_CTX *mem_ctx = NULL)
	{
		struct spoolss_5f r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_spoolss_5f(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
};

/* spoolss_Time */
/* spoolss_PrinterInfo0 */
/* spoolss_DeviceMode */
/* spoolss_EnumPrinterFlags */
/* spoolss_PrinterInfo1 */
/* spoolss_PrinterAttributes */
/* spoolss_PrinterStatus */
/* spoolss_PrinterInfo2 */
/* spoolss_PrinterInfo3 */
/* spoolss_PrinterInfo4 */
/* spoolss_PrinterInfo5 */
/* spoolss_PrinterInfo6 */
/* spoolss_DsPrintAction */
/* spoolss_PrinterInfo7 */
/* spoolss_DeviceModeInfo */
/* spoolss_PrinterInfo */
/* spoolss_DevmodeContainer */
/* spoolss_JobInfo1 */
/* spoolss_JobInfo */
/* spoolss_JobInfoContainer */
/* spoolss_JobControl */
/* spoolss_PrinterControl */
/* spoolss_SetPrinterInfo */
/* spoolss_DriverInfo1 */
/* spoolss_DriverOSVersion */
/* spoolss_DriverInfo2 */
/* spoolss_DriverInfo3 */
/* spoolss_DriverInfo4 */
/* spoolss_DriverInfo5 */
/* spoolss_DriverInfo6 */
/* spoolss_DriverInfo */
/* spoolss_DriverDirectoryInfo1 */
/* spoolss_DriverDirectoryInfo */
/* spoolss_PrintProcessorInfo1 */
/* spoolss_PrintProcessorInfo */
/* spoolss_DocumentInfo1 */
/* spoolss_DocumentInfo */
/* spoolss_OSVersion */
/* spoolss_OSVersionEx */
/* spoolss_PrinterDataType */
/* spoolss_PrinterData */
/* spoolss_FormFlags */
/* spoolss_FormSize */
/* spoolss_FormArea */
/* spoolss_FormInfo1 */
/* spoolss_FormInfo */
/* spoolss_AddFormInfo1 */
/* spoolss_AddFormInfo */
/* spoolss_PortInfo1 */
/* spoolss_PortType */
/* spoolss_PortInfo2 */
/* spoolss_PortInfo */
/* spoolss_MonitorInfo1 */
/* spoolss_MonitorInfo2 */
/* spoolss_MonitorInfo */
/* spoolss_RemoteFindFirstPrinterChangeNotifyEx_t2 */
/* spoolss_RemoteFindFirstPrinterChangeNotifyEx_t1 */
/* spoolss_UserLevel1 */
/* spoolss_UserLevel */

