/* This file is autogenerated by pidl. DO NOT EDIT */
%module rot

%{
#include "includes.h"
#include "auth/credentials/credentials.h"
#include "librpc/gen_ndr/ndr_rot_c.h"
#include "librpc/gen_ndr/rot.h"
%}
%import "samba.i"

%inline {
void ntstatus_exception(NTSTATUS status)
{
	/* FIXME */
}
}



%inline {
struct rot { struct dcerpc_pipe *pipe; };
}

%extend rot {
	rot (const char *binding, struct cli_credentials *cred = NULL, TALLOC_CTX *mem_ctx = NULL, struct event_context *event = NULL)
	{
		struct rot *ret = talloc(mem_ctx, struct rot);
		NTSTATUS status;
		
		status = dcerpc_pipe_connect(mem_ctx, &ret->pipe, binding, &dcerpc_table_rot, cred, event);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return NULL;
		}
		
		return ret;
	}
	
	~rot() {
		talloc_free(self);
	}
	
	/* rot_add */
	WERROR add(uint32_t flags, struct MInterfacePointer *unk, struct MInterfacePointer *moniker, uint32_t *rotid, TALLOC_CTX *mem_ctx = NULL)
	{
		struct rot_add r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.flags = flags;
		r.in.unk = unk;
		r.in.moniker = moniker;
		
		status = dcerpc_rot_add(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*rotid = *r.out.rotid;
		return r.out.result;
	}
	
	/* rot_remove */
	WERROR remove(uint32_t rotid, TALLOC_CTX *mem_ctx = NULL)
	{
		struct rot_remove r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.rotid = rotid;
		
		status = dcerpc_rot_remove(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* rot_is_listed */
	WERROR is_listed(struct MInterfacePointer *moniker, TALLOC_CTX *mem_ctx = NULL)
	{
		struct rot_is_listed r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.moniker = moniker;
		
		status = dcerpc_rot_is_listed(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* rot_get_interface_pointer */
	WERROR get_interface_pointer(struct MInterfacePointer *moniker, struct MInterfacePointer *ip, TALLOC_CTX *mem_ctx = NULL)
	{
		struct rot_get_interface_pointer r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.moniker = moniker;
		
		status = dcerpc_rot_get_interface_pointer(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*ip = *r.out.ip;
		return r.out.result;
	}
	
	/* rot_set_modification_time */
	WERROR set_modification_time(uint32_t rotid, NTTIME *t, TALLOC_CTX *mem_ctx = NULL)
	{
		struct rot_set_modification_time r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.rotid = rotid;
		r.in.t = t;
		
		status = dcerpc_rot_set_modification_time(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* rot_get_modification_time */
	WERROR get_modification_time(struct MInterfacePointer *moniker, NTTIME *t, TALLOC_CTX *mem_ctx = NULL)
	{
		struct rot_get_modification_time r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.moniker = moniker;
		
		status = dcerpc_rot_get_modification_time(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*t = *r.out.t;
		return r.out.result;
	}
	
	/* rot_enum */
	WERROR enum(struct MInterfacePointer *EnumMoniker, TALLOC_CTX *mem_ctx = NULL)
	{
		struct rot_enum r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_rot_enum(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*EnumMoniker = *r.out.EnumMoniker;
		return r.out.result;
	}
	
};


