/* This file is autogenerated by pidl. DO NOT EDIT */
%module netlogon

%{
#include "includes.h"
#include "auth/credentials/credentials.h"
#include "librpc/gen_ndr/ndr_netlogon_c.h"
#include "librpc/gen_ndr/netlogon.h"
%}
%import "samba.i"

%inline {
void ntstatus_exception(NTSTATUS status)
{
	/* FIXME */
}
}

%types(netr_LogonLevel);
%types(netr_GroupMembership);
%types(netr_UserSessionKey);
%types(netr_LMSessionKey);
%types(netr_UserFlags);
%types(netr_SamInfo3);
%types(netr_Validation);
%types(netr_Credential);
%types(netr_Authenticator);
%types(netr_USER_KEYS);


%inline {
struct netlogon { struct dcerpc_pipe *pipe; };
}

%extend netlogon {
	netlogon (const char *binding, struct cli_credentials *cred = NULL, TALLOC_CTX *mem_ctx = NULL, struct event_context *event = NULL)
	{
		struct netlogon *ret = talloc(mem_ctx, struct netlogon);
		NTSTATUS status;
		
		status = dcerpc_pipe_connect(mem_ctx, &ret->pipe, binding, &dcerpc_table_netlogon, cred, event);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return NULL;
		}
		
		return ret;
	}
	
	~netlogon() {
		talloc_free(self);
	}
	
	/* netr_LogonUasLogon */
	WERROR netr_LogonUasLogon(const char *server_name, const char *account_name, const char *workstation, struct netr_UasInfo *info, TALLOC_CTX *mem_ctx = NULL)
	{
		struct netr_LogonUasLogon r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.server_name = server_name;
		r.in.account_name = account_name;
		r.in.workstation = workstation;
		
		status = dcerpc_netr_LogonUasLogon(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*info = *r.out.info;
		return r.out.result;
	}
	
	/* netr_LogonUasLogoff */
	WERROR netr_LogonUasLogoff(const char *server_name, const char *account_name, const char *workstation, struct netr_UasLogoffInfo info, TALLOC_CTX *mem_ctx = NULL)
	{
		struct netr_LogonUasLogoff r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.server_name = server_name;
		r.in.account_name = account_name;
		r.in.workstation = workstation;
		
		status = dcerpc_netr_LogonUasLogoff(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: info [out] argument is not a pointer */
		*info = *r.out.info;
		return r.out.result;
	}
	
	/* netr_LogonSamLogon */
	NTSTATUS netr_LogonSamLogon(const char *server_name, const char *computer_name, struct netr_Authenticator *credential, struct netr_Authenticator *return_authenticator, uint16_t logon_level, union netr_LogonLevel logon, uint16_t validation_level, union netr_Validation validation, uint8_t authoritative, TALLOC_CTX *mem_ctx = NULL)
	{
		struct netr_LogonSamLogon r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.server_name = server_name;
		r.in.computer_name = computer_name;
		r.in.credential = credential;
		r.in.return_authenticator = return_authenticator;
		r.in.logon_level = logon_level;
		r.in.logon = logon;
		r.in.validation_level = validation_level;
		
		status = dcerpc_netr_LogonSamLogon(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*return_authenticator = *r.out.return_authenticator;
		/* FIXME: validation [out] argument is not a pointer */
		*validation = *r.out.validation;
		/* FIXME: authoritative [out] argument is not a pointer */
		*authoritative = *r.out.authoritative;
		return r.out.result;
	}
	
	/* netr_LogonSamLogoff */
	NTSTATUS netr_LogonSamLogoff(const char *server_name, const char *computer_name, struct netr_Authenticator *credential, struct netr_Authenticator *return_authenticator, uint16_t logon_level, union netr_LogonLevel logon, TALLOC_CTX *mem_ctx = NULL)
	{
		struct netr_LogonSamLogoff r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.server_name = server_name;
		r.in.computer_name = computer_name;
		r.in.credential = credential;
		r.in.return_authenticator = return_authenticator;
		r.in.logon_level = logon_level;
		r.in.logon = logon;
		
		status = dcerpc_netr_LogonSamLogoff(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*return_authenticator = *r.out.return_authenticator;
		return r.out.result;
	}
	
	/* netr_ServerReqChallenge */
	NTSTATUS netr_ServerReqChallenge(const char *server_name, const char *computer_name, struct netr_Credential *credentials, TALLOC_CTX *mem_ctx = NULL)
	{
		struct netr_ServerReqChallenge r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.server_name = server_name;
		r.in.computer_name = computer_name;
		r.in.credentials = credentials;
		
		status = dcerpc_netr_ServerReqChallenge(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*credentials = *r.out.credentials;
		return r.out.result;
	}
	
	/* netr_ServerAuthenticate */
	NTSTATUS netr_ServerAuthenticate(const char *server_name, const char *account_name, enum netr_SchannelType secure_channel_type, const char *computer_name, struct netr_Credential *credentials, TALLOC_CTX *mem_ctx = NULL)
	{
		struct netr_ServerAuthenticate r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.server_name = server_name;
		r.in.account_name = account_name;
		r.in.secure_channel_type = secure_channel_type;
		r.in.computer_name = computer_name;
		r.in.credentials = credentials;
		
		status = dcerpc_netr_ServerAuthenticate(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*credentials = *r.out.credentials;
		return r.out.result;
	}
	
	/* netr_ServerPasswordSet */
	NTSTATUS netr_ServerPasswordSet(const char *server_name, const char *account_name, enum netr_SchannelType secure_channel_type, const char *computer_name, struct netr_Authenticator credential, struct samr_Password new_password, struct netr_Authenticator return_authenticator, TALLOC_CTX *mem_ctx = NULL)
	{
		struct netr_ServerPasswordSet r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.server_name = server_name;
		r.in.account_name = account_name;
		r.in.secure_channel_type = secure_channel_type;
		r.in.computer_name = computer_name;
		r.in.credential = credential;
		r.in.new_password = new_password;
		
		status = dcerpc_netr_ServerPasswordSet(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: return_authenticator [out] argument is not a pointer */
		*return_authenticator = *r.out.return_authenticator;
		return r.out.result;
	}
	
	/* netr_DatabaseDeltas */
	NTSTATUS netr_DatabaseDeltas(const char *logon_server, const char *computername, struct netr_Authenticator credential, struct netr_Authenticator return_authenticator, enum netr_SamDatabaseID database_id, uint64_t sequence_num, uint32_t preferredmaximumlength, struct netr_DELTA_ENUM_ARRAY *delta_enum_array, TALLOC_CTX *mem_ctx = NULL)
	{
		struct netr_DatabaseDeltas r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.logon_server = logon_server;
		r.in.computername = computername;
		r.in.credential = credential;
		r.in.return_authenticator = return_authenticator;
		r.in.database_id = database_id;
		r.in.sequence_num = sequence_num;
		r.in.preferredmaximumlength = preferredmaximumlength;
		
		status = dcerpc_netr_DatabaseDeltas(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: return_authenticator [out] argument is not a pointer */
		*return_authenticator = *r.out.return_authenticator;
		/* FIXME: sequence_num [out] argument is not a pointer */
		*sequence_num = *r.out.sequence_num;
		*delta_enum_array = *r.out.delta_enum_array;
		return r.out.result;
	}
	
	/* netr_DatabaseSync */
	NTSTATUS netr_DatabaseSync(const char *logon_server, const char *computername, struct netr_Authenticator credential, struct netr_Authenticator return_authenticator, enum netr_SamDatabaseID database_id, uint32_t sync_context, uint32_t preferredmaximumlength, struct netr_DELTA_ENUM_ARRAY *delta_enum_array, TALLOC_CTX *mem_ctx = NULL)
	{
		struct netr_DatabaseSync r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.logon_server = logon_server;
		r.in.computername = computername;
		r.in.credential = credential;
		r.in.return_authenticator = return_authenticator;
		r.in.database_id = database_id;
		r.in.sync_context = sync_context;
		r.in.preferredmaximumlength = preferredmaximumlength;
		
		status = dcerpc_netr_DatabaseSync(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: return_authenticator [out] argument is not a pointer */
		*return_authenticator = *r.out.return_authenticator;
		/* FIXME: sync_context [out] argument is not a pointer */
		*sync_context = *r.out.sync_context;
		*delta_enum_array = *r.out.delta_enum_array;
		return r.out.result;
	}
	
	/* netr_AccountDeltas */
	NTSTATUS netr_AccountDeltas(const char *logon_server, const char *computername, struct netr_Authenticator credential, struct netr_Authenticator return_authenticator, struct netr_UAS_INFO_0 uas, uint32_t count, uint32_t level, uint32_t buffersize, struct netr_AccountBuffer buffer, uint32_t count_returned, uint32_t total_entries, struct netr_UAS_INFO_0 recordid, TALLOC_CTX *mem_ctx = NULL)
	{
		struct netr_AccountDeltas r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.logon_server = logon_server;
		r.in.computername = computername;
		r.in.credential = credential;
		r.in.return_authenticator = return_authenticator;
		r.in.uas = uas;
		r.in.count = count;
		r.in.level = level;
		r.in.buffersize = buffersize;
		
		status = dcerpc_netr_AccountDeltas(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: return_authenticator [out] argument is not a pointer */
		*return_authenticator = *r.out.return_authenticator;
		/* FIXME: buffer [out] argument is not a pointer */
		*buffer = *r.out.buffer;
		/* FIXME: count_returned [out] argument is not a pointer */
		*count_returned = *r.out.count_returned;
		/* FIXME: total_entries [out] argument is not a pointer */
		*total_entries = *r.out.total_entries;
		/* FIXME: recordid [out] argument is not a pointer */
		*recordid = *r.out.recordid;
		return r.out.result;
	}
	
	/* netr_AccountSync */
	NTSTATUS netr_AccountSync(const char *logon_server, const char *computername, struct netr_Authenticator credential, struct netr_Authenticator return_authenticator, uint32_t reference, uint32_t level, uint32_t buffersize, struct netr_AccountBuffer buffer, uint32_t count_returned, uint32_t total_entries, uint32_t next_reference, struct netr_UAS_INFO_0 recordid, TALLOC_CTX *mem_ctx = NULL)
	{
		struct netr_AccountSync r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.logon_server = logon_server;
		r.in.computername = computername;
		r.in.credential = credential;
		r.in.return_authenticator = return_authenticator;
		r.in.reference = reference;
		r.in.level = level;
		r.in.buffersize = buffersize;
		r.in.recordid = recordid;
		
		status = dcerpc_netr_AccountSync(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: return_authenticator [out] argument is not a pointer */
		*return_authenticator = *r.out.return_authenticator;
		/* FIXME: buffer [out] argument is not a pointer */
		*buffer = *r.out.buffer;
		/* FIXME: count_returned [out] argument is not a pointer */
		*count_returned = *r.out.count_returned;
		/* FIXME: total_entries [out] argument is not a pointer */
		*total_entries = *r.out.total_entries;
		/* FIXME: next_reference [out] argument is not a pointer */
		*next_reference = *r.out.next_reference;
		/* FIXME: recordid [out] argument is not a pointer */
		*recordid = *r.out.recordid;
		return r.out.result;
	}
	
	/* netr_GetDcName */
	NTSTATUS netr_GetDcName(const char *logon_server, const char *domainname, const char *dcname, TALLOC_CTX *mem_ctx = NULL)
	{
		struct netr_GetDcName r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.logon_server = logon_server;
		r.in.domainname = domainname;
		
		status = dcerpc_netr_GetDcName(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*dcname = *r.out.dcname;
		return r.out.result;
	}
	
	/* netr_LogonControl */
	WERROR netr_LogonControl(const char *logon_server, enum netr_LogonControlCode function_code, uint32_t level, union netr_CONTROL_QUERY_INFORMATION info, TALLOC_CTX *mem_ctx = NULL)
	{
		struct netr_LogonControl r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.logon_server = logon_server;
		r.in.function_code = function_code;
		r.in.level = level;
		
		status = dcerpc_netr_LogonControl(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: info [out] argument is not a pointer */
		*info = *r.out.info;
		return r.out.result;
	}
	
	/* netr_GetAnyDCName */
	WERROR netr_GetAnyDCName(const char *logon_server, const char *domainname, const char *dcname, TALLOC_CTX *mem_ctx = NULL)
	{
		struct netr_GetAnyDCName r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.logon_server = logon_server;
		r.in.domainname = domainname;
		
		status = dcerpc_netr_GetAnyDCName(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*dcname = *r.out.dcname;
		return r.out.result;
	}
	
	/* netr_LogonControl2 */
	WERROR netr_LogonControl2(const char *logon_server, uint32_t function_code, uint32_t level, union netr_CONTROL_DATA_INFORMATION data, union netr_CONTROL_QUERY_INFORMATION query, TALLOC_CTX *mem_ctx = NULL)
	{
		struct netr_LogonControl2 r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.logon_server = logon_server;
		r.in.function_code = function_code;
		r.in.level = level;
		r.in.data = data;
		
		status = dcerpc_netr_LogonControl2(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: query [out] argument is not a pointer */
		*query = *r.out.query;
		return r.out.result;
	}
	
	/* netr_ServerAuthenticate2 */
	NTSTATUS netr_ServerAuthenticate2(const char *server_name, const char *account_name, enum netr_SchannelType secure_channel_type, const char *computer_name, struct netr_Credential *credentials, uint32_t *negotiate_flags, TALLOC_CTX *mem_ctx = NULL)
	{
		struct netr_ServerAuthenticate2 r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.server_name = server_name;
		r.in.account_name = account_name;
		r.in.secure_channel_type = secure_channel_type;
		r.in.computer_name = computer_name;
		r.in.credentials = credentials;
		r.in.negotiate_flags = negotiate_flags;
		
		status = dcerpc_netr_ServerAuthenticate2(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*credentials = *r.out.credentials;
		*negotiate_flags = *r.out.negotiate_flags;
		return r.out.result;
	}
	
	/* netr_DatabaseSync2 */
	NTSTATUS netr_DatabaseSync2(const char *logon_server, const char *computername, struct netr_Authenticator credential, struct netr_Authenticator return_authenticator, enum netr_SamDatabaseID database_id, uint16_t restart_state, uint32_t sync_context, uint32_t preferredmaximumlength, struct netr_DELTA_ENUM_ARRAY *delta_enum_array, TALLOC_CTX *mem_ctx = NULL)
	{
		struct netr_DatabaseSync2 r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.logon_server = logon_server;
		r.in.computername = computername;
		r.in.credential = credential;
		r.in.return_authenticator = return_authenticator;
		r.in.database_id = database_id;
		r.in.restart_state = restart_state;
		r.in.sync_context = sync_context;
		r.in.preferredmaximumlength = preferredmaximumlength;
		
		status = dcerpc_netr_DatabaseSync2(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: return_authenticator [out] argument is not a pointer */
		*return_authenticator = *r.out.return_authenticator;
		/* FIXME: sync_context [out] argument is not a pointer */
		*sync_context = *r.out.sync_context;
		*delta_enum_array = *r.out.delta_enum_array;
		return r.out.result;
	}
	
	/* netr_DatabaseRedo */
	NTSTATUS netr_DatabaseRedo(const char *logon_server, const char *computername, struct netr_Authenticator credential, struct netr_Authenticator return_authenticator, uint8_t *change_log_entry, uint32_t change_log_entry_size, struct netr_DELTA_ENUM_ARRAY *delta_enum_array, TALLOC_CTX *mem_ctx = NULL)
	{
		struct netr_DatabaseRedo r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.logon_server = logon_server;
		r.in.computername = computername;
		r.in.credential = credential;
		r.in.return_authenticator = return_authenticator;
		r.in.change_log_entry = change_log_entry;
		r.in.change_log_entry_size = change_log_entry_size;
		
		status = dcerpc_netr_DatabaseRedo(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: return_authenticator [out] argument is not a pointer */
		*return_authenticator = *r.out.return_authenticator;
		*delta_enum_array = *r.out.delta_enum_array;
		return r.out.result;
	}
	
	/* netr_LogonControl2Ex */
	WERROR netr_LogonControl2Ex(const char *logon_server, uint32_t function_code, uint32_t level, union netr_CONTROL_DATA_INFORMATION data, union netr_CONTROL_QUERY_INFORMATION query, TALLOC_CTX *mem_ctx = NULL)
	{
		struct netr_LogonControl2Ex r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.logon_server = logon_server;
		r.in.function_code = function_code;
		r.in.level = level;
		r.in.data = data;
		
		status = dcerpc_netr_LogonControl2Ex(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: query [out] argument is not a pointer */
		*query = *r.out.query;
		return r.out.result;
	}
	
	/* netr_NETRENUMERATETRUSTEDDOMAINS */
	WERROR netr_NETRENUMERATETRUSTEDDOMAINS(TALLOC_CTX *mem_ctx = NULL)
	{
		struct netr_NETRENUMERATETRUSTEDDOMAINS r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_netr_NETRENUMERATETRUSTEDDOMAINS(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* netr_DsRGetDCName */
	WERROR netr_DsRGetDCName(const char *server_unc, const char *domain_name, struct GUID *domain_guid, struct GUID *site_guid, uint32_t flags, struct netr_DsRGetDCNameInfo *info, TALLOC_CTX *mem_ctx = NULL)
	{
		struct netr_DsRGetDCName r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.server_unc = server_unc;
		r.in.domain_name = domain_name;
		r.in.domain_guid = domain_guid;
		r.in.site_guid = site_guid;
		r.in.flags = flags;
		
		status = dcerpc_netr_DsRGetDCName(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*info = *r.out.info;
		return r.out.result;
	}
	
	/* netr_NETRLOGONDUMMYROUTINE1 */
	WERROR netr_NETRLOGONDUMMYROUTINE1(TALLOC_CTX *mem_ctx = NULL)
	{
		struct netr_NETRLOGONDUMMYROUTINE1 r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_netr_NETRLOGONDUMMYROUTINE1(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* netr_NETRLOGONSETSERVICEBITS */
	WERROR netr_NETRLOGONSETSERVICEBITS(TALLOC_CTX *mem_ctx = NULL)
	{
		struct netr_NETRLOGONSETSERVICEBITS r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_netr_NETRLOGONSETSERVICEBITS(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* netr_NETRLOGONGETTRUSTRID */
	WERROR netr_NETRLOGONGETTRUSTRID(TALLOC_CTX *mem_ctx = NULL)
	{
		struct netr_NETRLOGONGETTRUSTRID r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_netr_NETRLOGONGETTRUSTRID(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* netr_NETRLOGONCOMPUTESERVERDIGEST */
	WERROR netr_NETRLOGONCOMPUTESERVERDIGEST(TALLOC_CTX *mem_ctx = NULL)
	{
		struct netr_NETRLOGONCOMPUTESERVERDIGEST r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_netr_NETRLOGONCOMPUTESERVERDIGEST(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* netr_NETRLOGONCOMPUTECLIENTDIGEST */
	WERROR netr_NETRLOGONCOMPUTECLIENTDIGEST(TALLOC_CTX *mem_ctx = NULL)
	{
		struct netr_NETRLOGONCOMPUTECLIENTDIGEST r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_netr_NETRLOGONCOMPUTECLIENTDIGEST(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* netr_ServerAuthenticate3 */
	NTSTATUS netr_ServerAuthenticate3(const char *server_name, const char *account_name, enum netr_SchannelType secure_channel_type, const char *computer_name, struct netr_Credential *credentials, uint32_t *negotiate_flags, uint32_t *rid, TALLOC_CTX *mem_ctx = NULL)
	{
		struct netr_ServerAuthenticate3 r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.server_name = server_name;
		r.in.account_name = account_name;
		r.in.secure_channel_type = secure_channel_type;
		r.in.computer_name = computer_name;
		r.in.credentials = credentials;
		r.in.negotiate_flags = negotiate_flags;
		
		status = dcerpc_netr_ServerAuthenticate3(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*credentials = *r.out.credentials;
		*negotiate_flags = *r.out.negotiate_flags;
		*rid = *r.out.rid;
		return r.out.result;
	}
	
	/* netr_DsRGetDCNameEx */
	WERROR netr_DsRGetDCNameEx(const char *server_unc, const char *domain_name, struct GUID *domain_guid, const char *site_name, uint32_t flags, struct netr_DsRGetDCNameInfo *info, TALLOC_CTX *mem_ctx = NULL)
	{
		struct netr_DsRGetDCNameEx r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.server_unc = server_unc;
		r.in.domain_name = domain_name;
		r.in.domain_guid = domain_guid;
		r.in.site_name = site_name;
		r.in.flags = flags;
		
		status = dcerpc_netr_DsRGetDCNameEx(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*info = *r.out.info;
		return r.out.result;
	}
	
	/* netr_DsRGetSiteName */
	WERROR netr_DsRGetSiteName(const char *computer_name, const char *site, TALLOC_CTX *mem_ctx = NULL)
	{
		struct netr_DsRGetSiteName r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.computer_name = computer_name;
		
		status = dcerpc_netr_DsRGetSiteName(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*site = *r.out.site;
		return r.out.result;
	}
	
	/* netr_LogonGetDomainInfo */
	NTSTATUS netr_LogonGetDomainInfo(const char *server_name, const char *computer_name, struct netr_Authenticator *credential, struct netr_Authenticator *return_authenticator, uint32_t level, union netr_DomainQuery query, union netr_DomainInfo info, TALLOC_CTX *mem_ctx = NULL)
	{
		struct netr_LogonGetDomainInfo r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.server_name = server_name;
		r.in.computer_name = computer_name;
		r.in.credential = credential;
		r.in.return_authenticator = return_authenticator;
		r.in.level = level;
		r.in.query = query;
		
		status = dcerpc_netr_LogonGetDomainInfo(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*return_authenticator = *r.out.return_authenticator;
		/* FIXME: info [out] argument is not a pointer */
		*info = *r.out.info;
		return r.out.result;
	}
	
	/* netr_ServerPasswordSet2 */
	NTSTATUS netr_ServerPasswordSet2(const char *server_name, const char *account_name, enum netr_SchannelType secure_channel_type, const char *computer_name, struct netr_Authenticator credential, struct netr_CryptPassword new_password, struct netr_Authenticator return_authenticator, TALLOC_CTX *mem_ctx = NULL)
	{
		struct netr_ServerPasswordSet2 r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.server_name = server_name;
		r.in.account_name = account_name;
		r.in.secure_channel_type = secure_channel_type;
		r.in.computer_name = computer_name;
		r.in.credential = credential;
		r.in.new_password = new_password;
		
		status = dcerpc_netr_ServerPasswordSet2(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: return_authenticator [out] argument is not a pointer */
		*return_authenticator = *r.out.return_authenticator;
		return r.out.result;
	}
	
	/* netr_NETRSERVERPASSWORDGET */
	WERROR netr_NETRSERVERPASSWORDGET(TALLOC_CTX *mem_ctx = NULL)
	{
		struct netr_NETRSERVERPASSWORDGET r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_netr_NETRSERVERPASSWORDGET(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* netr_NETRLOGONSENDTOSAM */
	WERROR netr_NETRLOGONSENDTOSAM(TALLOC_CTX *mem_ctx = NULL)
	{
		struct netr_NETRLOGONSENDTOSAM r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_netr_NETRLOGONSENDTOSAM(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* netr_DSRADDRESSTOSITENAMESW */
	WERROR netr_DSRADDRESSTOSITENAMESW(TALLOC_CTX *mem_ctx = NULL)
	{
		struct netr_DSRADDRESSTOSITENAMESW r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_netr_DSRADDRESSTOSITENAMESW(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* netr_DsRGetDCNameEx2 */
	WERROR netr_DsRGetDCNameEx2(const char *server_unc, const char *client_account, uint32_t mask, const char *domain_name, struct GUID *domain_guid, const char *site_name, uint32_t flags, struct netr_DsRGetDCNameInfo *info, TALLOC_CTX *mem_ctx = NULL)
	{
		struct netr_DsRGetDCNameEx2 r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.server_unc = server_unc;
		r.in.client_account = client_account;
		r.in.mask = mask;
		r.in.domain_name = domain_name;
		r.in.domain_guid = domain_guid;
		r.in.site_name = site_name;
		r.in.flags = flags;
		
		status = dcerpc_netr_DsRGetDCNameEx2(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*info = *r.out.info;
		return r.out.result;
	}
	
	/* netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN */
	WERROR netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN(TALLOC_CTX *mem_ctx = NULL)
	{
		struct netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* netr_NETRENUMERATETRUSTEDDOMAINSEX */
	WERROR netr_NETRENUMERATETRUSTEDDOMAINSEX(TALLOC_CTX *mem_ctx = NULL)
	{
		struct netr_NETRENUMERATETRUSTEDDOMAINSEX r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_netr_NETRENUMERATETRUSTEDDOMAINSEX(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* netr_DSRADDRESSTOSITENAMESEXW */
	WERROR netr_DSRADDRESSTOSITENAMESEXW(TALLOC_CTX *mem_ctx = NULL)
	{
		struct netr_DSRADDRESSTOSITENAMESEXW r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_netr_DSRADDRESSTOSITENAMESEXW(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* netr_DSRGETDCSITECOVERAGEW */
	WERROR netr_DSRGETDCSITECOVERAGEW(TALLOC_CTX *mem_ctx = NULL)
	{
		struct netr_DSRGETDCSITECOVERAGEW r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_netr_DSRGETDCSITECOVERAGEW(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* netr_LogonSamLogonEx */
	NTSTATUS netr_LogonSamLogonEx(const char *server_name, const char *computer_name, uint16_t logon_level, union netr_LogonLevel logon, uint16_t validation_level, union netr_Validation validation, uint8_t authoritative, uint32_t flags, TALLOC_CTX *mem_ctx = NULL)
	{
		struct netr_LogonSamLogonEx r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.server_name = server_name;
		r.in.computer_name = computer_name;
		r.in.logon_level = logon_level;
		r.in.logon = logon;
		r.in.validation_level = validation_level;
		r.in.flags = flags;
		
		status = dcerpc_netr_LogonSamLogonEx(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: validation [out] argument is not a pointer */
		*validation = *r.out.validation;
		/* FIXME: authoritative [out] argument is not a pointer */
		*authoritative = *r.out.authoritative;
		/* FIXME: flags [out] argument is not a pointer */
		*flags = *r.out.flags;
		return r.out.result;
	}
	
	/* netr_DsrEnumerateDomainTrusts */
	WERROR netr_DsrEnumerateDomainTrusts(const char *server_name, uint32_t trust_flags, uint32_t count, struct netr_DomainTrust *trusts, TALLOC_CTX *mem_ctx = NULL)
	{
		struct netr_DsrEnumerateDomainTrusts r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.server_name = server_name;
		r.in.trust_flags = trust_flags;
		
		status = dcerpc_netr_DsrEnumerateDomainTrusts(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		/* FIXME: count [out] argument is not a pointer */
		*count = *r.out.count;
		*trusts = *r.out.trusts;
		return r.out.result;
	}
	
	/* netr_DSRDEREGISTERDNSHOSTRECORDS */
	WERROR netr_DSRDEREGISTERDNSHOSTRECORDS(TALLOC_CTX *mem_ctx = NULL)
	{
		struct netr_DSRDEREGISTERDNSHOSTRECORDS r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_netr_DSRDEREGISTERDNSHOSTRECORDS(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* netr_NETRSERVERTRUSTPASSWORDSGET */
	WERROR netr_NETRSERVERTRUSTPASSWORDSGET(TALLOC_CTX *mem_ctx = NULL)
	{
		struct netr_NETRSERVERTRUSTPASSWORDSGET r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_netr_NETRSERVERTRUSTPASSWORDSGET(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* netr_DSRGETFORESTTRUSTINFORMATION */
	WERROR netr_DSRGETFORESTTRUSTINFORMATION(TALLOC_CTX *mem_ctx = NULL)
	{
		struct netr_DSRGETFORESTTRUSTINFORMATION r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_netr_DSRGETFORESTTRUSTINFORMATION(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* netr_NETRGETFORESTTRUSTINFORMATION */
	WERROR netr_NETRGETFORESTTRUSTINFORMATION(TALLOC_CTX *mem_ctx = NULL)
	{
		struct netr_NETRGETFORESTTRUSTINFORMATION r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_netr_NETRGETFORESTTRUSTINFORMATION(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
	/* netr_LogonSamLogonWithFlags */
	NTSTATUS netr_LogonSamLogonWithFlags(const char *server_name, const char *computer_name, struct netr_Authenticator *credential, struct netr_Authenticator *return_authenticator, uint16_t logon_level, union netr_LogonLevel logon, uint16_t validation_level, union netr_Validation validation, uint8_t authoritative, uint32_t flags, TALLOC_CTX *mem_ctx = NULL)
	{
		struct netr_LogonSamLogonWithFlags r;
		NTSTATUS status;
		
		/* Fill r structure */
		r.in.server_name = server_name;
		r.in.computer_name = computer_name;
		r.in.credential = credential;
		r.in.return_authenticator = return_authenticator;
		r.in.logon_level = logon_level;
		r.in.logon = logon;
		r.in.validation_level = validation_level;
		r.in.flags = flags;
		
		status = dcerpc_netr_LogonSamLogonWithFlags(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		*return_authenticator = *r.out.return_authenticator;
		/* FIXME: validation [out] argument is not a pointer */
		*validation = *r.out.validation;
		/* FIXME: authoritative [out] argument is not a pointer */
		*authoritative = *r.out.authoritative;
		/* FIXME: flags [out] argument is not a pointer */
		*flags = *r.out.flags;
		return r.out.result;
	}
	
	/* netr_NETRSERVERGETTRUSTINFO */
	WERROR netr_NETRSERVERGETTRUSTINFO(TALLOC_CTX *mem_ctx = NULL)
	{
		struct netr_NETRSERVERGETTRUSTINFO r;
		NTSTATUS status;
		
		/* Fill r structure */
		
		status = dcerpc_netr_NETRSERVERGETTRUSTINFO(self->pipe, mem_ctx, &r);
		if (NT_STATUS_IS_ERR(status)) {
			ntstatus_exception(status);
			return r.out.result;
		}
		
		/* Set out arguments */
		return r.out.result;
	}
	
};

/* netr_UasInfo */
/* netr_UasLogoffInfo */
/* netr_AcctLockStr */
/* netr_IdentityInfo */
/* netr_PasswordInfo */
/* netr_ChallengeResponse */
/* netr_NetworkInfo */
/* netr_LogonLevel */
/* netr_GroupMembership */
/* netr_UserSessionKey */
/* netr_LMSessionKey */
/* netr_UserFlags */
/* netr_SamBaseInfo */
/* netr_SamInfo2 */
/* netr_SidAttr */
/* netr_SamInfo3 */
/* netr_SamInfo6 */
/* netr_PacInfo */
/* netr_Validation */
/* netr_Credential */
/* netr_Authenticator */
/* netr_DELTA_DELETE_USER */
/* netr_USER_KEY16 */
/* netr_PasswordHistory */
/* netr_USER_KEYS2 */
/* netr_USER_KEY_UNION */
/* netr_USER_KEYS */
/* netr_USER_PRIVATE_INFO */
/* netr_DELTA_USER */
/* netr_DELTA_DOMAIN */
/* netr_DELTA_GROUP */
/* netr_DELTA_RENAME */
/* netr_DELTA_GROUP_MEMBER */
/* netr_DELTA_ALIAS */
/* netr_DELTA_ALIAS_MEMBER */
/* netr_QUOTA_LIMITS */
/* netr_DELTA_POLICY */
/* netr_DELTA_TRUSTED_DOMAIN */
/* netr_DELTA_DELETE_TRUST */
/* netr_DELTA_ACCOUNT */
/* netr_DELTA_DELETE_ACCOUNT */
/* netr_DELTA_DELETE_SECRET */
/* netr_CIPHER_VALUE */
/* netr_DELTA_SECRET */
/* netr_DeltaEnum */
/* netr_DELTA_UNION */
/* netr_DELTA_ID_UNION */
/* netr_DELTA_ENUM */
/* netr_DELTA_ENUM_ARRAY */
/* netr_UAS_INFO_0 */
/* netr_AccountBuffer */
/* netr_NETLOGON_INFO_1 */
/* netr_NETLOGON_INFO_2 */
/* netr_NETLOGON_INFO_3 */
/* netr_CONTROL_QUERY_INFORMATION */
/* netr_LogonControlCode */
/* netr_CONTROL_DATA_INFORMATION */
/* netr_DsRGetDCNameInfo */
/* netr_Blob */
/* netr_BinaryString */
/* netr_DomainQuery1 */
/* netr_DomainQuery */
/* netr_DomainTrustInfo */
/* netr_DomainInfo1 */
/* netr_DomainInfo */
/* netr_CryptPassword */
/* netr_TrustFlags */
/* netr_TrustType */
/* netr_TrustAttributes */
/* netr_DomainTrust */

