
/* EJS wrapper functions auto-generated by pidl */
#include "includes.h"
#include "librpc/rpc/dcerpc.h"
#include "lib/appweb/ejs/ejs.h"
#include "scripting/ejs/ejsrpc.h"
#include "scripting/ejs/smbcalls.h"
#include "librpc/gen_ndr/ndr_misc_ejs.h"
#include "librpc/gen_ndr/ndr_wkssvc.h"
#include "librpc/gen_ndr/ndr_wkssvc_ejs.h"


static NTSTATUS ejs_push_wkssvc_NetWkstaInfo100(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct wkssvc_NetWkstaInfo100 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_srvsvc_PlatformId(ejs, v, "platform_id", &r->platform_id));
	if (NULL == r->server_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "server_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "server_name", r->server_name));
	}
	if (NULL == r->domain_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "domain_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "domain_name", r->domain_name));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "version_major", &r->version_major));
	NDR_CHECK(ejs_push_uint32(ejs, v, "version_minor", &r->version_minor));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_wkssvc_NetWkstaInfo100(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct wkssvc_NetWkstaInfo100 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_srvsvc_PlatformId(ejs, v, "platform_id", &r->platform_id));
	if (ejs_pull_null(ejs, v, "server_name")) {
		r->server_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->server_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_name", &r->server_name));
	}
	if (ejs_pull_null(ejs, v, "domain_name")) {
		r->domain_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->domain_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "domain_name", &r->domain_name));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "version_major", &r->version_major));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "version_minor", &r->version_minor));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_wkssvc_NetWkstaInfo101(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct wkssvc_NetWkstaInfo101 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_srvsvc_PlatformId(ejs, v, "platform_id", &r->platform_id));
	if (NULL == r->server_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "server_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "server_name", r->server_name));
	}
	if (NULL == r->domain_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "domain_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "domain_name", r->domain_name));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "version_major", &r->version_major));
	NDR_CHECK(ejs_push_uint32(ejs, v, "version_minor", &r->version_minor));
	if (NULL == r->lan_root) {
		NDR_CHECK(ejs_push_null(ejs, v, "lan_root"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "lan_root", r->lan_root));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_wkssvc_NetWkstaInfo101(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct wkssvc_NetWkstaInfo101 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_srvsvc_PlatformId(ejs, v, "platform_id", &r->platform_id));
	if (ejs_pull_null(ejs, v, "server_name")) {
		r->server_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->server_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_name", &r->server_name));
	}
	if (ejs_pull_null(ejs, v, "domain_name")) {
		r->domain_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->domain_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "domain_name", &r->domain_name));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "version_major", &r->version_major));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "version_minor", &r->version_minor));
	if (ejs_pull_null(ejs, v, "lan_root")) {
		r->lan_root = NULL;
	} else {
		EJS_ALLOC(ejs, r->lan_root);
		NDR_CHECK(ejs_pull_string(ejs, v, "lan_root", &r->lan_root));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_wkssvc_NetWkstaInfo102(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct wkssvc_NetWkstaInfo102 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_srvsvc_PlatformId(ejs, v, "platform_id", &r->platform_id));
	if (NULL == r->server_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "server_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "server_name", r->server_name));
	}
	if (NULL == r->domain_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "domain_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "domain_name", r->domain_name));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "version_major", &r->version_major));
	NDR_CHECK(ejs_push_uint32(ejs, v, "version_minor", &r->version_minor));
	if (NULL == r->lan_root) {
		NDR_CHECK(ejs_push_null(ejs, v, "lan_root"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "lan_root", r->lan_root));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "logged_on_users", &r->logged_on_users));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_wkssvc_NetWkstaInfo102(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct wkssvc_NetWkstaInfo102 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_srvsvc_PlatformId(ejs, v, "platform_id", &r->platform_id));
	if (ejs_pull_null(ejs, v, "server_name")) {
		r->server_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->server_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_name", &r->server_name));
	}
	if (ejs_pull_null(ejs, v, "domain_name")) {
		r->domain_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->domain_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "domain_name", &r->domain_name));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "version_major", &r->version_major));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "version_minor", &r->version_minor));
	if (ejs_pull_null(ejs, v, "lan_root")) {
		r->lan_root = NULL;
	} else {
		EJS_ALLOC(ejs, r->lan_root);
		NDR_CHECK(ejs_pull_string(ejs, v, "lan_root", &r->lan_root));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "logged_on_users", &r->logged_on_users));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_wkssvc_NetWkstaInfo502(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct wkssvc_NetWkstaInfo502 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "char_wait", &r->char_wait));
	NDR_CHECK(ejs_push_uint32(ejs, v, "collection_time", &r->collection_time));
	NDR_CHECK(ejs_push_uint32(ejs, v, "maximum_collection_count", &r->maximum_collection_count));
	NDR_CHECK(ejs_push_uint32(ejs, v, "keep_connection", &r->keep_connection));
	NDR_CHECK(ejs_push_uint32(ejs, v, "max_commands", &r->max_commands));
	NDR_CHECK(ejs_push_uint32(ejs, v, "session_timeout", &r->session_timeout));
	NDR_CHECK(ejs_push_uint32(ejs, v, "size_char_buf", &r->size_char_buf));
	NDR_CHECK(ejs_push_uint32(ejs, v, "max_threads", &r->max_threads));
	NDR_CHECK(ejs_push_uint32(ejs, v, "lock_quota", &r->lock_quota));
	NDR_CHECK(ejs_push_uint32(ejs, v, "lock_increment", &r->lock_increment));
	NDR_CHECK(ejs_push_uint32(ejs, v, "lock_maximum", &r->lock_maximum));
	NDR_CHECK(ejs_push_uint32(ejs, v, "pipe_increment", &r->pipe_increment));
	NDR_CHECK(ejs_push_uint32(ejs, v, "pipe_maximum", &r->pipe_maximum));
	NDR_CHECK(ejs_push_uint32(ejs, v, "cache_file_timeout", &r->cache_file_timeout));
	NDR_CHECK(ejs_push_uint32(ejs, v, "dormant_file_limit", &r->dormant_file_limit));
	NDR_CHECK(ejs_push_uint32(ejs, v, "read_ahead_throughput", &r->read_ahead_throughput));
	NDR_CHECK(ejs_push_uint32(ejs, v, "num_mailslot_buffers", &r->num_mailslot_buffers));
	NDR_CHECK(ejs_push_uint32(ejs, v, "num_srv_announce_buffers", &r->num_srv_announce_buffers));
	NDR_CHECK(ejs_push_uint32(ejs, v, "max_illegal_dgram_events", &r->max_illegal_dgram_events));
	NDR_CHECK(ejs_push_uint32(ejs, v, "dgram_event_reset_freq", &r->dgram_event_reset_freq));
	NDR_CHECK(ejs_push_uint32(ejs, v, "log_election_packets", &r->log_election_packets));
	NDR_CHECK(ejs_push_uint32(ejs, v, "use_opportunistic_locking", &r->use_opportunistic_locking));
	NDR_CHECK(ejs_push_uint32(ejs, v, "use_unlock_behind", &r->use_unlock_behind));
	NDR_CHECK(ejs_push_uint32(ejs, v, "use_close_behind", &r->use_close_behind));
	NDR_CHECK(ejs_push_uint32(ejs, v, "buf_named_pipes", &r->buf_named_pipes));
	NDR_CHECK(ejs_push_uint32(ejs, v, "use_lock_read_unlock", &r->use_lock_read_unlock));
	NDR_CHECK(ejs_push_uint32(ejs, v, "utilize_nt_caching", &r->utilize_nt_caching));
	NDR_CHECK(ejs_push_uint32(ejs, v, "use_raw_read", &r->use_raw_read));
	NDR_CHECK(ejs_push_uint32(ejs, v, "use_raw_write", &r->use_raw_write));
	NDR_CHECK(ejs_push_uint32(ejs, v, "use_write_raw_data", &r->use_write_raw_data));
	NDR_CHECK(ejs_push_uint32(ejs, v, "use_encryption", &r->use_encryption));
	NDR_CHECK(ejs_push_uint32(ejs, v, "buf_files_deny_write", &r->buf_files_deny_write));
	NDR_CHECK(ejs_push_uint32(ejs, v, "buf_read_only_files", &r->buf_read_only_files));
	NDR_CHECK(ejs_push_uint32(ejs, v, "force_core_create_mode", &r->force_core_create_mode));
	NDR_CHECK(ejs_push_uint32(ejs, v, "use_512_byte_max_transfer", &r->use_512_byte_max_transfer));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_wkssvc_NetWkstaInfo502(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct wkssvc_NetWkstaInfo502 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "char_wait", &r->char_wait));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "collection_time", &r->collection_time));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "maximum_collection_count", &r->maximum_collection_count));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "keep_connection", &r->keep_connection));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "max_commands", &r->max_commands));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "session_timeout", &r->session_timeout));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "size_char_buf", &r->size_char_buf));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "max_threads", &r->max_threads));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "lock_quota", &r->lock_quota));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "lock_increment", &r->lock_increment));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "lock_maximum", &r->lock_maximum));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "pipe_increment", &r->pipe_increment));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "pipe_maximum", &r->pipe_maximum));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "cache_file_timeout", &r->cache_file_timeout));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "dormant_file_limit", &r->dormant_file_limit));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "read_ahead_throughput", &r->read_ahead_throughput));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "num_mailslot_buffers", &r->num_mailslot_buffers));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "num_srv_announce_buffers", &r->num_srv_announce_buffers));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "max_illegal_dgram_events", &r->max_illegal_dgram_events));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "dgram_event_reset_freq", &r->dgram_event_reset_freq));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "log_election_packets", &r->log_election_packets));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "use_opportunistic_locking", &r->use_opportunistic_locking));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "use_unlock_behind", &r->use_unlock_behind));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "use_close_behind", &r->use_close_behind));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "buf_named_pipes", &r->buf_named_pipes));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "use_lock_read_unlock", &r->use_lock_read_unlock));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "utilize_nt_caching", &r->utilize_nt_caching));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "use_raw_read", &r->use_raw_read));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "use_raw_write", &r->use_raw_write));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "use_write_raw_data", &r->use_write_raw_data));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "use_encryption", &r->use_encryption));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "buf_files_deny_write", &r->buf_files_deny_write));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "buf_read_only_files", &r->buf_read_only_files));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "force_core_create_mode", &r->force_core_create_mode));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "use_512_byte_max_transfer", &r->use_512_byte_max_transfer));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_wkssvc_NetWkstaInfo1010(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct wkssvc_NetWkstaInfo1010 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "char_wait", &r->char_wait));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_wkssvc_NetWkstaInfo1010(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct wkssvc_NetWkstaInfo1010 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "char_wait", &r->char_wait));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_wkssvc_NetWkstaInfo1011(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct wkssvc_NetWkstaInfo1011 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "collection_time", &r->collection_time));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_wkssvc_NetWkstaInfo1011(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct wkssvc_NetWkstaInfo1011 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "collection_time", &r->collection_time));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_wkssvc_NetWkstaInfo1012(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct wkssvc_NetWkstaInfo1012 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "maximum_collection_count", &r->maximum_collection_count));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_wkssvc_NetWkstaInfo1012(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct wkssvc_NetWkstaInfo1012 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "maximum_collection_count", &r->maximum_collection_count));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_wkssvc_NetWkstaInfo1013(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct wkssvc_NetWkstaInfo1013 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "keep_connection", &r->keep_connection));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_wkssvc_NetWkstaInfo1013(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct wkssvc_NetWkstaInfo1013 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "keep_connection", &r->keep_connection));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_wkssvc_NetWkstaInfo1018(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct wkssvc_NetWkstaInfo1018 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "session_timeout", &r->session_timeout));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_wkssvc_NetWkstaInfo1018(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct wkssvc_NetWkstaInfo1018 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "session_timeout", &r->session_timeout));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_wkssvc_NetWkstaInfo1023(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct wkssvc_NetWkstaInfo1023 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "size_char_buf", &r->size_char_buf));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_wkssvc_NetWkstaInfo1023(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct wkssvc_NetWkstaInfo1023 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "size_char_buf", &r->size_char_buf));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_wkssvc_NetWkstaInfo1027(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct wkssvc_NetWkstaInfo1027 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "errorlog_sz", &r->errorlog_sz));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_wkssvc_NetWkstaInfo1027(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct wkssvc_NetWkstaInfo1027 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "errorlog_sz", &r->errorlog_sz));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_wkssvc_NetWkstaInfo1033(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct wkssvc_NetWkstaInfo1033 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "max_threads", &r->max_threads));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_wkssvc_NetWkstaInfo1033(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct wkssvc_NetWkstaInfo1033 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "max_threads", &r->max_threads));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_wkssvc_NetWkstaInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union wkssvc_NetWkstaInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 100:
			if (NULL == r->info100) {
				NDR_CHECK(ejs_push_null(ejs, v, "info100"));
			} else {
				NDR_CHECK(ejs_push_wkssvc_NetWkstaInfo100(ejs, v, "info100", r->info100));
			}
			break;
		case 101:
			if (NULL == r->info101) {
				NDR_CHECK(ejs_push_null(ejs, v, "info101"));
			} else {
				NDR_CHECK(ejs_push_wkssvc_NetWkstaInfo101(ejs, v, "info101", r->info101));
			}
			break;
		case 102:
			if (NULL == r->info102) {
				NDR_CHECK(ejs_push_null(ejs, v, "info102"));
			} else {
				NDR_CHECK(ejs_push_wkssvc_NetWkstaInfo102(ejs, v, "info102", r->info102));
			}
			break;
		case 502:
			if (NULL == r->info502) {
				NDR_CHECK(ejs_push_null(ejs, v, "info502"));
			} else {
				NDR_CHECK(ejs_push_wkssvc_NetWkstaInfo502(ejs, v, "info502", r->info502));
			}
			break;
		case 1010:
			if (NULL == r->info1010) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1010"));
			} else {
				NDR_CHECK(ejs_push_wkssvc_NetWkstaInfo1010(ejs, v, "info1010", r->info1010));
			}
			break;
		case 1011:
			if (NULL == r->info1011) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1011"));
			} else {
				NDR_CHECK(ejs_push_wkssvc_NetWkstaInfo1011(ejs, v, "info1011", r->info1011));
			}
			break;
		case 1012:
			if (NULL == r->info1012) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1012"));
			} else {
				NDR_CHECK(ejs_push_wkssvc_NetWkstaInfo1012(ejs, v, "info1012", r->info1012));
			}
			break;
		case 1013:
			if (NULL == r->info1013) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1013"));
			} else {
				NDR_CHECK(ejs_push_wkssvc_NetWkstaInfo1013(ejs, v, "info1013", r->info1013));
			}
			break;
		case 1018:
			if (NULL == r->info1018) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1018"));
			} else {
				NDR_CHECK(ejs_push_wkssvc_NetWkstaInfo1018(ejs, v, "info1018", r->info1018));
			}
			break;
		case 1023:
			if (NULL == r->info1023) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1023"));
			} else {
				NDR_CHECK(ejs_push_wkssvc_NetWkstaInfo1023(ejs, v, "info1023", r->info1023));
			}
			break;
		case 1027:
			if (NULL == r->info1027) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1027"));
			} else {
				NDR_CHECK(ejs_push_wkssvc_NetWkstaInfo1027(ejs, v, "info1027", r->info1027));
			}
			break;
		case 1033:
			if (NULL == r->info1033) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1033"));
			} else {
				NDR_CHECK(ejs_push_wkssvc_NetWkstaInfo1033(ejs, v, "info1033", r->info1033));
			}
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_wkssvc_NetWkstaInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union wkssvc_NetWkstaInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 100:
			if (ejs_pull_null(ejs, v, "info100")) {
				r->info100 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info100);
				NDR_CHECK(ejs_pull_wkssvc_NetWkstaInfo100(ejs, v, "info100", r->info100));
			}
			break;
		case 101:
			if (ejs_pull_null(ejs, v, "info101")) {
				r->info101 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info101);
				NDR_CHECK(ejs_pull_wkssvc_NetWkstaInfo101(ejs, v, "info101", r->info101));
			}
			break;
		case 102:
			if (ejs_pull_null(ejs, v, "info102")) {
				r->info102 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info102);
				NDR_CHECK(ejs_pull_wkssvc_NetWkstaInfo102(ejs, v, "info102", r->info102));
			}
			break;
		case 502:
			if (ejs_pull_null(ejs, v, "info502")) {
				r->info502 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info502);
				NDR_CHECK(ejs_pull_wkssvc_NetWkstaInfo502(ejs, v, "info502", r->info502));
			}
			break;
		case 1010:
			if (ejs_pull_null(ejs, v, "info1010")) {
				r->info1010 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1010);
				NDR_CHECK(ejs_pull_wkssvc_NetWkstaInfo1010(ejs, v, "info1010", r->info1010));
			}
			break;
		case 1011:
			if (ejs_pull_null(ejs, v, "info1011")) {
				r->info1011 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1011);
				NDR_CHECK(ejs_pull_wkssvc_NetWkstaInfo1011(ejs, v, "info1011", r->info1011));
			}
			break;
		case 1012:
			if (ejs_pull_null(ejs, v, "info1012")) {
				r->info1012 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1012);
				NDR_CHECK(ejs_pull_wkssvc_NetWkstaInfo1012(ejs, v, "info1012", r->info1012));
			}
			break;
		case 1013:
			if (ejs_pull_null(ejs, v, "info1013")) {
				r->info1013 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1013);
				NDR_CHECK(ejs_pull_wkssvc_NetWkstaInfo1013(ejs, v, "info1013", r->info1013));
			}
			break;
		case 1018:
			if (ejs_pull_null(ejs, v, "info1018")) {
				r->info1018 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1018);
				NDR_CHECK(ejs_pull_wkssvc_NetWkstaInfo1018(ejs, v, "info1018", r->info1018));
			}
			break;
		case 1023:
			if (ejs_pull_null(ejs, v, "info1023")) {
				r->info1023 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1023);
				NDR_CHECK(ejs_pull_wkssvc_NetWkstaInfo1023(ejs, v, "info1023", r->info1023));
			}
			break;
		case 1027:
			if (ejs_pull_null(ejs, v, "info1027")) {
				r->info1027 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1027);
				NDR_CHECK(ejs_pull_wkssvc_NetWkstaInfo1027(ejs, v, "info1027", r->info1027));
			}
			break;
		case 1033:
			if (ejs_pull_null(ejs, v, "info1033")) {
				r->info1033 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1033);
				NDR_CHECK(ejs_pull_wkssvc_NetWkstaInfo1033(ejs, v, "info1033", r->info1033));
			}
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_USER_INFO_0(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct USER_INFO_0 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->user) {
		NDR_CHECK(ejs_push_null(ejs, v, "user"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "user", r->user));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_USER_INFO_0(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct USER_INFO_0 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "user")) {
		r->user = NULL;
	} else {
		EJS_ALLOC(ejs, r->user);
		NDR_CHECK(ejs_pull_string(ejs, v, "user", &r->user));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_USER_INFO_0_CONTAINER(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct USER_INFO_0_CONTAINER *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "entries_read", &r->entries_read));
	if (NULL == r->user0) {
		NDR_CHECK(ejs_push_null(ejs, v, "user0"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->entries_read;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "user0", i);
				NDR_CHECK(ejs_push_USER_INFO_0(ejs, v, id, &r->user0[i]));
			}
			ejs_push_uint32(ejs, v, "user0" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_USER_INFO_0_CONTAINER(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct USER_INFO_0_CONTAINER *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "entries_read", &r->entries_read));
	if (ejs_pull_null(ejs, v, "user0")) {
		r->user0 = NULL;
	} else {
		EJS_ALLOC(ejs, r->user0);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->user0, r->entries_read);
			for (i=0;i<r->entries_read;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "user0", i);
				NDR_CHECK(ejs_pull_USER_INFO_0(ejs, v, id, &r->user0[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "user0" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_USER_INFO_1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct USER_INFO_1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->user_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "user_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "user_name", r->user_name));
	}
	if (NULL == r->logon_domain) {
		NDR_CHECK(ejs_push_null(ejs, v, "logon_domain"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "logon_domain", r->logon_domain));
	}
	if (NULL == r->other_domains) {
		NDR_CHECK(ejs_push_null(ejs, v, "other_domains"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "other_domains", r->other_domains));
	}
	if (NULL == r->logon_server) {
		NDR_CHECK(ejs_push_null(ejs, v, "logon_server"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "logon_server", r->logon_server));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_USER_INFO_1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct USER_INFO_1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "user_name")) {
		r->user_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->user_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "user_name", &r->user_name));
	}
	if (ejs_pull_null(ejs, v, "logon_domain")) {
		r->logon_domain = NULL;
	} else {
		EJS_ALLOC(ejs, r->logon_domain);
		NDR_CHECK(ejs_pull_string(ejs, v, "logon_domain", &r->logon_domain));
	}
	if (ejs_pull_null(ejs, v, "other_domains")) {
		r->other_domains = NULL;
	} else {
		EJS_ALLOC(ejs, r->other_domains);
		NDR_CHECK(ejs_pull_string(ejs, v, "other_domains", &r->other_domains));
	}
	if (ejs_pull_null(ejs, v, "logon_server")) {
		r->logon_server = NULL;
	} else {
		EJS_ALLOC(ejs, r->logon_server);
		NDR_CHECK(ejs_pull_string(ejs, v, "logon_server", &r->logon_server));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_USER_INFO_1_CONTAINER(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct USER_INFO_1_CONTAINER *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "entries_read", &r->entries_read));
	if (NULL == r->user1) {
		NDR_CHECK(ejs_push_null(ejs, v, "user1"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->entries_read;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "user1", i);
				NDR_CHECK(ejs_push_USER_INFO_1(ejs, v, id, &r->user1[i]));
			}
			ejs_push_uint32(ejs, v, "user1" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_USER_INFO_1_CONTAINER(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct USER_INFO_1_CONTAINER *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "entries_read", &r->entries_read));
	if (ejs_pull_null(ejs, v, "user1")) {
		r->user1 = NULL;
	} else {
		EJS_ALLOC(ejs, r->user1);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->user1, r->entries_read);
			for (i=0;i<r->entries_read;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "user1", i);
				NDR_CHECK(ejs_pull_USER_INFO_1(ejs, v, id, &r->user1[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "user1" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_WKS_USER_ENUM_UNION(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union WKS_USER_ENUM_UNION *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 0:
			if (NULL == r->user0) {
				NDR_CHECK(ejs_push_null(ejs, v, "user0"));
			} else {
				NDR_CHECK(ejs_push_USER_INFO_0_CONTAINER(ejs, v, "user0", r->user0));
			}
			break;
		case 1:
			if (NULL == r->user1) {
				NDR_CHECK(ejs_push_null(ejs, v, "user1"));
			} else {
				NDR_CHECK(ejs_push_USER_INFO_1_CONTAINER(ejs, v, "user1", r->user1));
			}
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_WKS_USER_ENUM_UNION(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union WKS_USER_ENUM_UNION *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 0:
			if (ejs_pull_null(ejs, v, "user0")) {
				r->user0 = NULL;
			} else {
				EJS_ALLOC(ejs, r->user0);
				NDR_CHECK(ejs_pull_USER_INFO_0_CONTAINER(ejs, v, "user0", r->user0));
			}
			break;
		case 1:
			if (ejs_pull_null(ejs, v, "user1")) {
				r->user1 = NULL;
			} else {
				EJS_ALLOC(ejs, r->user1);
				NDR_CHECK(ejs_pull_USER_INFO_1_CONTAINER(ejs, v, "user1", r->user1));
			}
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_wkssvc_NetWkstaTransportInfo0(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct wkssvc_NetWkstaTransportInfo0 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "quality_of_service", &r->quality_of_service));
	NDR_CHECK(ejs_push_uint32(ejs, v, "vc_count", &r->vc_count));
	if (NULL == r->name) {
		NDR_CHECK(ejs_push_null(ejs, v, "name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "name", r->name));
	}
	if (NULL == r->address) {
		NDR_CHECK(ejs_push_null(ejs, v, "address"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "address", r->address));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "wan_link", &r->wan_link));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_wkssvc_NetWkstaTransportInfo0(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct wkssvc_NetWkstaTransportInfo0 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "quality_of_service", &r->quality_of_service));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "vc_count", &r->vc_count));
	if (ejs_pull_null(ejs, v, "name")) {
		r->name = NULL;
	} else {
		EJS_ALLOC(ejs, r->name);
		NDR_CHECK(ejs_pull_string(ejs, v, "name", &r->name));
	}
	if (ejs_pull_null(ejs, v, "address")) {
		r->address = NULL;
	} else {
		EJS_ALLOC(ejs, r->address);
		NDR_CHECK(ejs_pull_string(ejs, v, "address", &r->address));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "wan_link", &r->wan_link));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_wkssvc_NetWkstaTransportCtr0(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct wkssvc_NetWkstaTransportCtr0 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->array) {
		NDR_CHECK(ejs_push_null(ejs, v, "array"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_push_wkssvc_NetWkstaTransportInfo0(ejs, v, id, &r->array[i]));
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_wkssvc_NetWkstaTransportCtr0(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct wkssvc_NetWkstaTransportCtr0 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	if (ejs_pull_null(ejs, v, "array")) {
		r->array = NULL;
	} else {
		EJS_ALLOC(ejs, r->array);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->array, r->count);
			for (i=0;i<r->count;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_pull_wkssvc_NetWkstaTransportInfo0(ejs, v, id, &r->array[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_wkssvc_NetWkstaTransportCtr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union wkssvc_NetWkstaTransportCtr *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 0:
			if (NULL == r->ctr0) {
				NDR_CHECK(ejs_push_null(ejs, v, "ctr0"));
			} else {
				NDR_CHECK(ejs_push_wkssvc_NetWkstaTransportCtr0(ejs, v, "ctr0", r->ctr0));
			}
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_wkssvc_NetWkstaTransportCtr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union wkssvc_NetWkstaTransportCtr *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 0:
			if (ejs_pull_null(ejs, v, "ctr0")) {
				r->ctr0 = NULL;
			} else {
				EJS_ALLOC(ejs, r->ctr0);
				NDR_CHECK(ejs_pull_wkssvc_NetWkstaTransportCtr0(ejs, v, "ctr0", r->ctr0));
			}
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_wkssvc_PasswordBuffer(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct wkssvc_PasswordBuffer *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	ejs_pull_array_uint8(ejs, v, "data", r->data, 524);
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_wkssvc_joinflags(struct ejs_rpc *ejs, struct MprVar *v, const char *name, uint32_t *r)
{
	return ejs_pull_uint32(ejs, v, name, r);
}
static NTSTATUS ejs_pull_wkssvc_renameflags(struct ejs_rpc *ejs, struct MprVar *v, const char *name, uint32_t *r)
{
	return ejs_pull_uint32(ejs, v, name, r);
}

static NTSTATUS ejs_pull_wkssvc_NetWkstaGetInfo(struct ejs_rpc *ejs, struct MprVar *v, struct wkssvc_NetWkstaGetInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_name")) {
		r->in.server_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_name", &r->in.server_name));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_wkssvc_NetWkstaGetInfo(struct ejs_rpc *ejs, struct MprVar *v, const struct wkssvc_NetWkstaGetInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.info) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		ejs_set_switch(ejs, r->in.level);
		NDR_CHECK(ejs_push_wkssvc_NetWkstaInfo(ejs, v, "info", r->out.info));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_wkssvc_NetWkstaGetInfo(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_wkssvc, DCERPC_WKSSVC_NETWKSTAGETINFO, (ejs_pull_function_t)ejs_pull_wkssvc_NetWkstaGetInfo, (ejs_push_function_t)ejs_push_wkssvc_NetWkstaGetInfo);
}


static NTSTATUS ejs_pull_wkssvc_NetWkstaSetInfo(struct ejs_rpc *ejs, struct MprVar *v, struct wkssvc_NetWkstaSetInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_name")) {
		r->in.server_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_name", &r->in.server_name));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	if (ejs_pull_null(ejs, v, "info")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.info);
		ejs_set_switch(ejs, r->in.level);
		NDR_CHECK(ejs_pull_wkssvc_NetWkstaInfo(ejs, v, "info", r->in.info));
	}
	if (ejs_pull_null(ejs, v, "parm_error")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.parm_error);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "parm_error", r->in.parm_error));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_wkssvc_NetWkstaSetInfo(struct ejs_rpc *ejs, struct MprVar *v, const struct wkssvc_NetWkstaSetInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.parm_error) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "parm_error", r->out.parm_error));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_wkssvc_NetWkstaSetInfo(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_wkssvc, DCERPC_WKSSVC_NETWKSTASETINFO, (ejs_pull_function_t)ejs_pull_wkssvc_NetWkstaSetInfo, (ejs_push_function_t)ejs_push_wkssvc_NetWkstaSetInfo);
}


static NTSTATUS ejs_pull_wkssvc_NetWkstaEnumUsers(struct ejs_rpc *ejs, struct MprVar *v, struct wkssvc_NetWkstaEnumUsers *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_name")) {
		r->in.server_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_name", &r->in.server_name));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	if (ejs_pull_null(ejs, v, "users")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.users);
		NDR_CHECK(ejs_pull_WKS_USER_ENUM_UNION(ejs, v, "users", r->in.users));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "prefmaxlen", &r->in.prefmaxlen));
	if (ejs_pull_null(ejs, v, "resumehandle")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.resumehandle);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "resumehandle", r->in.resumehandle));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_wkssvc_NetWkstaEnumUsers(struct ejs_rpc *ejs, struct MprVar *v, const struct wkssvc_NetWkstaEnumUsers *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.users) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_WKS_USER_ENUM_UNION(ejs, v, "users", r->out.users));
	}
	if (NULL == r->out.entriesread) {
		NDR_CHECK(ejs_push_null(ejs, v, "entriesread"));
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "entriesread", r->out.entriesread));
	}
	if (NULL == r->out.totalentries) {
		NDR_CHECK(ejs_push_null(ejs, v, "totalentries"));
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "totalentries", r->out.totalentries));
	}
	if (NULL == r->out.resumehandle) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "resumehandle", r->out.resumehandle));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_wkssvc_NetWkstaEnumUsers(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_wkssvc, DCERPC_WKSSVC_NETWKSTAENUMUSERS, (ejs_pull_function_t)ejs_pull_wkssvc_NetWkstaEnumUsers, (ejs_push_function_t)ejs_push_wkssvc_NetWkstaEnumUsers);
}


static NTSTATUS ejs_pull_WKSSVC_NETRWKSTAUSERGETINFO(struct ejs_rpc *ejs, struct MprVar *v, struct WKSSVC_NETRWKSTAUSERGETINFO *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_WKSSVC_NETRWKSTAUSERGETINFO(struct ejs_rpc *ejs, struct MprVar *v, const struct WKSSVC_NETRWKSTAUSERGETINFO *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_WKSSVC_NETRWKSTAUSERGETINFO(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_wkssvc, DCERPC_WKSSVC_NETRWKSTAUSERGETINFO, (ejs_pull_function_t)ejs_pull_WKSSVC_NETRWKSTAUSERGETINFO, (ejs_push_function_t)ejs_push_WKSSVC_NETRWKSTAUSERGETINFO);
}


static NTSTATUS ejs_pull_WKSSVC_NETRWKSTAUSERSETINFO(struct ejs_rpc *ejs, struct MprVar *v, struct WKSSVC_NETRWKSTAUSERSETINFO *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_WKSSVC_NETRWKSTAUSERSETINFO(struct ejs_rpc *ejs, struct MprVar *v, const struct WKSSVC_NETRWKSTAUSERSETINFO *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_WKSSVC_NETRWKSTAUSERSETINFO(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_wkssvc, DCERPC_WKSSVC_NETRWKSTAUSERSETINFO, (ejs_pull_function_t)ejs_pull_WKSSVC_NETRWKSTAUSERSETINFO, (ejs_push_function_t)ejs_push_WKSSVC_NETRWKSTAUSERSETINFO);
}


static NTSTATUS ejs_pull_wkssvc_NetWkstaTransportEnum(struct ejs_rpc *ejs, struct MprVar *v, struct wkssvc_NetWkstaTransportEnum *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_name")) {
		r->in.server_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_name", &r->in.server_name));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	if (ejs_pull_null(ejs, v, "ctr")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.ctr);
		ejs_set_switch(ejs, r->in.level);
		NDR_CHECK(ejs_pull_wkssvc_NetWkstaTransportCtr(ejs, v, "ctr", r->in.ctr));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "max_buffer", &r->in.max_buffer));
	if (ejs_pull_null(ejs, v, "resume_handle")) {
		r->in.resume_handle = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.resume_handle);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "resume_handle", r->in.resume_handle));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_wkssvc_NetWkstaTransportEnum(struct ejs_rpc *ejs, struct MprVar *v, const struct wkssvc_NetWkstaTransportEnum *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_uint32(ejs, v, "level", &r->out.level));
	if (NULL == r->out.ctr) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		ejs_set_switch(ejs, r->out.level);
		NDR_CHECK(ejs_push_wkssvc_NetWkstaTransportCtr(ejs, v, "ctr", r->out.ctr));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "totalentries", &r->out.totalentries));
	if (NULL == r->out.resume_handle) {
		NDR_CHECK(ejs_push_null(ejs, v, "resume_handle"));
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "resume_handle", r->out.resume_handle));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_wkssvc_NetWkstaTransportEnum(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_wkssvc, DCERPC_WKSSVC_NETWKSTATRANSPORTENUM, (ejs_pull_function_t)ejs_pull_wkssvc_NetWkstaTransportEnum, (ejs_push_function_t)ejs_push_wkssvc_NetWkstaTransportEnum);
}


static NTSTATUS ejs_pull_WKSSVC_NETRWKSTATRANSPORTADD(struct ejs_rpc *ejs, struct MprVar *v, struct WKSSVC_NETRWKSTATRANSPORTADD *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_WKSSVC_NETRWKSTATRANSPORTADD(struct ejs_rpc *ejs, struct MprVar *v, const struct WKSSVC_NETRWKSTATRANSPORTADD *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_WKSSVC_NETRWKSTATRANSPORTADD(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_wkssvc, DCERPC_WKSSVC_NETRWKSTATRANSPORTADD, (ejs_pull_function_t)ejs_pull_WKSSVC_NETRWKSTATRANSPORTADD, (ejs_push_function_t)ejs_push_WKSSVC_NETRWKSTATRANSPORTADD);
}


static NTSTATUS ejs_pull_WKSSVC_NETRWKSTATRANSPORTDEL(struct ejs_rpc *ejs, struct MprVar *v, struct WKSSVC_NETRWKSTATRANSPORTDEL *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_WKSSVC_NETRWKSTATRANSPORTDEL(struct ejs_rpc *ejs, struct MprVar *v, const struct WKSSVC_NETRWKSTATRANSPORTDEL *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_WKSSVC_NETRWKSTATRANSPORTDEL(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_wkssvc, DCERPC_WKSSVC_NETRWKSTATRANSPORTDEL, (ejs_pull_function_t)ejs_pull_WKSSVC_NETRWKSTATRANSPORTDEL, (ejs_push_function_t)ejs_push_WKSSVC_NETRWKSTATRANSPORTDEL);
}


static NTSTATUS ejs_pull_WKSSVC_NETRUSEADD(struct ejs_rpc *ejs, struct MprVar *v, struct WKSSVC_NETRUSEADD *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_WKSSVC_NETRUSEADD(struct ejs_rpc *ejs, struct MprVar *v, const struct WKSSVC_NETRUSEADD *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_WKSSVC_NETRUSEADD(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_wkssvc, DCERPC_WKSSVC_NETRUSEADD, (ejs_pull_function_t)ejs_pull_WKSSVC_NETRUSEADD, (ejs_push_function_t)ejs_push_WKSSVC_NETRUSEADD);
}


static NTSTATUS ejs_pull_WKSSVC_NETRUSEGETINFO(struct ejs_rpc *ejs, struct MprVar *v, struct WKSSVC_NETRUSEGETINFO *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_WKSSVC_NETRUSEGETINFO(struct ejs_rpc *ejs, struct MprVar *v, const struct WKSSVC_NETRUSEGETINFO *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_WKSSVC_NETRUSEGETINFO(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_wkssvc, DCERPC_WKSSVC_NETRUSEGETINFO, (ejs_pull_function_t)ejs_pull_WKSSVC_NETRUSEGETINFO, (ejs_push_function_t)ejs_push_WKSSVC_NETRUSEGETINFO);
}


static NTSTATUS ejs_pull_WKSSVC_NETRUSEDEL(struct ejs_rpc *ejs, struct MprVar *v, struct WKSSVC_NETRUSEDEL *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_WKSSVC_NETRUSEDEL(struct ejs_rpc *ejs, struct MprVar *v, const struct WKSSVC_NETRUSEDEL *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_WKSSVC_NETRUSEDEL(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_wkssvc, DCERPC_WKSSVC_NETRUSEDEL, (ejs_pull_function_t)ejs_pull_WKSSVC_NETRUSEDEL, (ejs_push_function_t)ejs_push_WKSSVC_NETRUSEDEL);
}


static NTSTATUS ejs_pull_WKSSVC_NETRUSEENUM(struct ejs_rpc *ejs, struct MprVar *v, struct WKSSVC_NETRUSEENUM *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_WKSSVC_NETRUSEENUM(struct ejs_rpc *ejs, struct MprVar *v, const struct WKSSVC_NETRUSEENUM *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_WKSSVC_NETRUSEENUM(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_wkssvc, DCERPC_WKSSVC_NETRUSEENUM, (ejs_pull_function_t)ejs_pull_WKSSVC_NETRUSEENUM, (ejs_push_function_t)ejs_push_WKSSVC_NETRUSEENUM);
}


static NTSTATUS ejs_pull_WKSSVC_NETRMESSAGEBUFFERSEND(struct ejs_rpc *ejs, struct MprVar *v, struct WKSSVC_NETRMESSAGEBUFFERSEND *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_WKSSVC_NETRMESSAGEBUFFERSEND(struct ejs_rpc *ejs, struct MprVar *v, const struct WKSSVC_NETRMESSAGEBUFFERSEND *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_WKSSVC_NETRMESSAGEBUFFERSEND(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_wkssvc, DCERPC_WKSSVC_NETRMESSAGEBUFFERSEND, (ejs_pull_function_t)ejs_pull_WKSSVC_NETRMESSAGEBUFFERSEND, (ejs_push_function_t)ejs_push_WKSSVC_NETRMESSAGEBUFFERSEND);
}


static NTSTATUS ejs_pull_WKSSVC_NETRWORKSTATIONSTATISTICSGET(struct ejs_rpc *ejs, struct MprVar *v, struct WKSSVC_NETRWORKSTATIONSTATISTICSGET *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_WKSSVC_NETRWORKSTATIONSTATISTICSGET(struct ejs_rpc *ejs, struct MprVar *v, const struct WKSSVC_NETRWORKSTATIONSTATISTICSGET *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_WKSSVC_NETRWORKSTATIONSTATISTICSGET(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_wkssvc, DCERPC_WKSSVC_NETRWORKSTATIONSTATISTICSGET, (ejs_pull_function_t)ejs_pull_WKSSVC_NETRWORKSTATIONSTATISTICSGET, (ejs_push_function_t)ejs_push_WKSSVC_NETRWORKSTATIONSTATISTICSGET);
}


static NTSTATUS ejs_pull_WKSSVC_NETRLOGONDOMAINNAMEADD(struct ejs_rpc *ejs, struct MprVar *v, struct WKSSVC_NETRLOGONDOMAINNAMEADD *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_WKSSVC_NETRLOGONDOMAINNAMEADD(struct ejs_rpc *ejs, struct MprVar *v, const struct WKSSVC_NETRLOGONDOMAINNAMEADD *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_WKSSVC_NETRLOGONDOMAINNAMEADD(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_wkssvc, DCERPC_WKSSVC_NETRLOGONDOMAINNAMEADD, (ejs_pull_function_t)ejs_pull_WKSSVC_NETRLOGONDOMAINNAMEADD, (ejs_push_function_t)ejs_push_WKSSVC_NETRLOGONDOMAINNAMEADD);
}


static NTSTATUS ejs_pull_WKSSVC_NETRLOGONDOMAINNAMEDEL(struct ejs_rpc *ejs, struct MprVar *v, struct WKSSVC_NETRLOGONDOMAINNAMEDEL *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_WKSSVC_NETRLOGONDOMAINNAMEDEL(struct ejs_rpc *ejs, struct MprVar *v, const struct WKSSVC_NETRLOGONDOMAINNAMEDEL *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_WKSSVC_NETRLOGONDOMAINNAMEDEL(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_wkssvc, DCERPC_WKSSVC_NETRLOGONDOMAINNAMEDEL, (ejs_pull_function_t)ejs_pull_WKSSVC_NETRLOGONDOMAINNAMEDEL, (ejs_push_function_t)ejs_push_WKSSVC_NETRLOGONDOMAINNAMEDEL);
}


static NTSTATUS ejs_pull_WKSSVC_NETRJOINDOMAIN(struct ejs_rpc *ejs, struct MprVar *v, struct WKSSVC_NETRJOINDOMAIN *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_WKSSVC_NETRJOINDOMAIN(struct ejs_rpc *ejs, struct MprVar *v, const struct WKSSVC_NETRJOINDOMAIN *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_WKSSVC_NETRJOINDOMAIN(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_wkssvc, DCERPC_WKSSVC_NETRJOINDOMAIN, (ejs_pull_function_t)ejs_pull_WKSSVC_NETRJOINDOMAIN, (ejs_push_function_t)ejs_push_WKSSVC_NETRJOINDOMAIN);
}


static NTSTATUS ejs_pull_WKSSVC_NETRUNJOINDOMAIN(struct ejs_rpc *ejs, struct MprVar *v, struct WKSSVC_NETRUNJOINDOMAIN *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_WKSSVC_NETRUNJOINDOMAIN(struct ejs_rpc *ejs, struct MprVar *v, const struct WKSSVC_NETRUNJOINDOMAIN *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_WKSSVC_NETRUNJOINDOMAIN(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_wkssvc, DCERPC_WKSSVC_NETRUNJOINDOMAIN, (ejs_pull_function_t)ejs_pull_WKSSVC_NETRUNJOINDOMAIN, (ejs_push_function_t)ejs_push_WKSSVC_NETRUNJOINDOMAIN);
}


static NTSTATUS ejs_pull_WKSSVC_NETRRENAMEMACHINEINDOMAIN(struct ejs_rpc *ejs, struct MprVar *v, struct WKSSVC_NETRRENAMEMACHINEINDOMAIN *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_WKSSVC_NETRRENAMEMACHINEINDOMAIN(struct ejs_rpc *ejs, struct MprVar *v, const struct WKSSVC_NETRRENAMEMACHINEINDOMAIN *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_WKSSVC_NETRRENAMEMACHINEINDOMAIN(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_wkssvc, DCERPC_WKSSVC_NETRRENAMEMACHINEINDOMAIN, (ejs_pull_function_t)ejs_pull_WKSSVC_NETRRENAMEMACHINEINDOMAIN, (ejs_push_function_t)ejs_push_WKSSVC_NETRRENAMEMACHINEINDOMAIN);
}


static NTSTATUS ejs_pull_WKSSVC_NETRVALIDATENAME(struct ejs_rpc *ejs, struct MprVar *v, struct WKSSVC_NETRVALIDATENAME *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_WKSSVC_NETRVALIDATENAME(struct ejs_rpc *ejs, struct MprVar *v, const struct WKSSVC_NETRVALIDATENAME *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_WKSSVC_NETRVALIDATENAME(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_wkssvc, DCERPC_WKSSVC_NETRVALIDATENAME, (ejs_pull_function_t)ejs_pull_WKSSVC_NETRVALIDATENAME, (ejs_push_function_t)ejs_push_WKSSVC_NETRVALIDATENAME);
}


static NTSTATUS ejs_pull_WKSSVC_NETRGETJOININFORMATION(struct ejs_rpc *ejs, struct MprVar *v, struct WKSSVC_NETRGETJOININFORMATION *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_WKSSVC_NETRGETJOININFORMATION(struct ejs_rpc *ejs, struct MprVar *v, const struct WKSSVC_NETRGETJOININFORMATION *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_WKSSVC_NETRGETJOININFORMATION(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_wkssvc, DCERPC_WKSSVC_NETRGETJOININFORMATION, (ejs_pull_function_t)ejs_pull_WKSSVC_NETRGETJOININFORMATION, (ejs_push_function_t)ejs_push_WKSSVC_NETRGETJOININFORMATION);
}


static NTSTATUS ejs_pull_WKSSVC_NETRGETJOINABLEOUS(struct ejs_rpc *ejs, struct MprVar *v, struct WKSSVC_NETRGETJOINABLEOUS *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_WKSSVC_NETRGETJOINABLEOUS(struct ejs_rpc *ejs, struct MprVar *v, const struct WKSSVC_NETRGETJOINABLEOUS *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_WKSSVC_NETRGETJOINABLEOUS(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_wkssvc, DCERPC_WKSSVC_NETRGETJOINABLEOUS, (ejs_pull_function_t)ejs_pull_WKSSVC_NETRGETJOINABLEOUS, (ejs_push_function_t)ejs_push_WKSSVC_NETRGETJOINABLEOUS);
}


static NTSTATUS ejs_pull_wkssvc_NetrJoinDomain2(struct ejs_rpc *ejs, struct MprVar *v, struct wkssvc_NetrJoinDomain2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_name")) {
		r->in.server_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_name", &r->in.server_name));
	}
	if (ejs_pull_null(ejs, v, "domain_name")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.domain_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "domain_name", &r->in.domain_name));
	}
	if (ejs_pull_null(ejs, v, "account_name")) {
		r->in.account_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.account_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "account_name", &r->in.account_name));
	}
	if (ejs_pull_null(ejs, v, "admin_account")) {
		r->in.admin_account = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.admin_account);
		NDR_CHECK(ejs_pull_string(ejs, v, "admin_account", &r->in.admin_account));
	}
	if (ejs_pull_null(ejs, v, "encrypted_password")) {
		r->in.encrypted_password = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.encrypted_password);
		NDR_CHECK(ejs_pull_wkssvc_PasswordBuffer(ejs, v, "encrypted_password", r->in.encrypted_password));
	}
	NDR_CHECK(ejs_pull_wkssvc_joinflags(ejs, v, "join_flags", &r->in.join_flags));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_wkssvc_NetrJoinDomain2(struct ejs_rpc *ejs, struct MprVar *v, const struct wkssvc_NetrJoinDomain2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_wkssvc_NetrJoinDomain2(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_wkssvc, DCERPC_WKSSVC_NETRJOINDOMAIN2, (ejs_pull_function_t)ejs_pull_wkssvc_NetrJoinDomain2, (ejs_push_function_t)ejs_push_wkssvc_NetrJoinDomain2);
}


static NTSTATUS ejs_pull_wkssvc_NetrUnjoinDomain2(struct ejs_rpc *ejs, struct MprVar *v, struct wkssvc_NetrUnjoinDomain2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_name")) {
		r->in.server_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_name", &r->in.server_name));
	}
	if (ejs_pull_null(ejs, v, "account")) {
		r->in.account = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.account);
		NDR_CHECK(ejs_pull_string(ejs, v, "account", &r->in.account));
	}
	if (ejs_pull_null(ejs, v, "encrypted_password")) {
		r->in.encrypted_password = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.encrypted_password);
		NDR_CHECK(ejs_pull_wkssvc_PasswordBuffer(ejs, v, "encrypted_password", r->in.encrypted_password));
	}
	NDR_CHECK(ejs_pull_wkssvc_joinflags(ejs, v, "unjoin_flags", &r->in.unjoin_flags));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_wkssvc_NetrUnjoinDomain2(struct ejs_rpc *ejs, struct MprVar *v, const struct wkssvc_NetrUnjoinDomain2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_wkssvc_NetrUnjoinDomain2(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_wkssvc, DCERPC_WKSSVC_NETRUNJOINDOMAIN2, (ejs_pull_function_t)ejs_pull_wkssvc_NetrUnjoinDomain2, (ejs_push_function_t)ejs_push_wkssvc_NetrUnjoinDomain2);
}


static NTSTATUS ejs_pull_wkssvc_NetrRenameMachineInDomain2(struct ejs_rpc *ejs, struct MprVar *v, struct wkssvc_NetrRenameMachineInDomain2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_name")) {
		r->in.server_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_name", &r->in.server_name));
	}
	if (ejs_pull_null(ejs, v, "NewMachineName")) {
		r->in.NewMachineName = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.NewMachineName);
		NDR_CHECK(ejs_pull_string(ejs, v, "NewMachineName", &r->in.NewMachineName));
	}
	if (ejs_pull_null(ejs, v, "Account")) {
		r->in.Account = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.Account);
		NDR_CHECK(ejs_pull_string(ejs, v, "Account", &r->in.Account));
	}
	if (ejs_pull_null(ejs, v, "EncryptedPassword")) {
		r->in.EncryptedPassword = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.EncryptedPassword);
		NDR_CHECK(ejs_pull_wkssvc_PasswordBuffer(ejs, v, "EncryptedPassword", r->in.EncryptedPassword));
	}
	NDR_CHECK(ejs_pull_wkssvc_renameflags(ejs, v, "RenameOptions", &r->in.RenameOptions));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_wkssvc_NetrRenameMachineInDomain2(struct ejs_rpc *ejs, struct MprVar *v, const struct wkssvc_NetrRenameMachineInDomain2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_wkssvc_NetrRenameMachineInDomain2(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_wkssvc, DCERPC_WKSSVC_NETRRENAMEMACHINEINDOMAIN2, (ejs_pull_function_t)ejs_pull_wkssvc_NetrRenameMachineInDomain2, (ejs_push_function_t)ejs_push_wkssvc_NetrRenameMachineInDomain2);
}


static NTSTATUS ejs_pull_WKSSVC_NETRVALIDATENAME2(struct ejs_rpc *ejs, struct MprVar *v, struct WKSSVC_NETRVALIDATENAME2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_WKSSVC_NETRVALIDATENAME2(struct ejs_rpc *ejs, struct MprVar *v, const struct WKSSVC_NETRVALIDATENAME2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_WKSSVC_NETRVALIDATENAME2(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_wkssvc, DCERPC_WKSSVC_NETRVALIDATENAME2, (ejs_pull_function_t)ejs_pull_WKSSVC_NETRVALIDATENAME2, (ejs_push_function_t)ejs_push_WKSSVC_NETRVALIDATENAME2);
}


static NTSTATUS ejs_pull_WKSSVC_NETRGETJOINABLEOUS2(struct ejs_rpc *ejs, struct MprVar *v, struct WKSSVC_NETRGETJOINABLEOUS2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_WKSSVC_NETRGETJOINABLEOUS2(struct ejs_rpc *ejs, struct MprVar *v, const struct WKSSVC_NETRGETJOINABLEOUS2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_WKSSVC_NETRGETJOINABLEOUS2(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_wkssvc, DCERPC_WKSSVC_NETRGETJOINABLEOUS2, (ejs_pull_function_t)ejs_pull_WKSSVC_NETRGETJOINABLEOUS2, (ejs_push_function_t)ejs_push_WKSSVC_NETRGETJOINABLEOUS2);
}


static NTSTATUS ejs_pull_wkssvc_NetrAddAlternateComputerName(struct ejs_rpc *ejs, struct MprVar *v, struct wkssvc_NetrAddAlternateComputerName *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_name")) {
		r->in.server_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_name", &r->in.server_name));
	}
	if (ejs_pull_null(ejs, v, "NewAlternateMachineName")) {
		r->in.NewAlternateMachineName = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.NewAlternateMachineName);
		NDR_CHECK(ejs_pull_string(ejs, v, "NewAlternateMachineName", &r->in.NewAlternateMachineName));
	}
	if (ejs_pull_null(ejs, v, "Account")) {
		r->in.Account = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.Account);
		NDR_CHECK(ejs_pull_string(ejs, v, "Account", &r->in.Account));
	}
	if (ejs_pull_null(ejs, v, "EncryptedPassword")) {
		r->in.EncryptedPassword = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.EncryptedPassword);
		NDR_CHECK(ejs_pull_wkssvc_PasswordBuffer(ejs, v, "EncryptedPassword", r->in.EncryptedPassword));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "Reserved", &r->in.Reserved));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_wkssvc_NetrAddAlternateComputerName(struct ejs_rpc *ejs, struct MprVar *v, const struct wkssvc_NetrAddAlternateComputerName *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_wkssvc_NetrAddAlternateComputerName(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_wkssvc, DCERPC_WKSSVC_NETRADDALTERNATECOMPUTERNAME, (ejs_pull_function_t)ejs_pull_wkssvc_NetrAddAlternateComputerName, (ejs_push_function_t)ejs_push_wkssvc_NetrAddAlternateComputerName);
}


static NTSTATUS ejs_pull_wkssvc_NetrRemoveAlternateComputerName(struct ejs_rpc *ejs, struct MprVar *v, struct wkssvc_NetrRemoveAlternateComputerName *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_name")) {
		r->in.server_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_name", &r->in.server_name));
	}
	if (ejs_pull_null(ejs, v, "AlternateMachineNameToRemove")) {
		r->in.AlternateMachineNameToRemove = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.AlternateMachineNameToRemove);
		NDR_CHECK(ejs_pull_string(ejs, v, "AlternateMachineNameToRemove", &r->in.AlternateMachineNameToRemove));
	}
	if (ejs_pull_null(ejs, v, "Account")) {
		r->in.Account = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.Account);
		NDR_CHECK(ejs_pull_string(ejs, v, "Account", &r->in.Account));
	}
	if (ejs_pull_null(ejs, v, "EncryptedPassword")) {
		r->in.EncryptedPassword = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.EncryptedPassword);
		NDR_CHECK(ejs_pull_wkssvc_PasswordBuffer(ejs, v, "EncryptedPassword", r->in.EncryptedPassword));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "Reserved", &r->in.Reserved));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_wkssvc_NetrRemoveAlternateComputerName(struct ejs_rpc *ejs, struct MprVar *v, const struct wkssvc_NetrRemoveAlternateComputerName *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_wkssvc_NetrRemoveAlternateComputerName(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_wkssvc, DCERPC_WKSSVC_NETRREMOVEALTERNATECOMPUTERNAME, (ejs_pull_function_t)ejs_pull_wkssvc_NetrRemoveAlternateComputerName, (ejs_push_function_t)ejs_push_wkssvc_NetrRemoveAlternateComputerName);
}


static NTSTATUS ejs_pull_WKSSVC_NETRSETPRIMARYCOMPUTERNAME(struct ejs_rpc *ejs, struct MprVar *v, struct WKSSVC_NETRSETPRIMARYCOMPUTERNAME *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_WKSSVC_NETRSETPRIMARYCOMPUTERNAME(struct ejs_rpc *ejs, struct MprVar *v, const struct WKSSVC_NETRSETPRIMARYCOMPUTERNAME *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_WKSSVC_NETRSETPRIMARYCOMPUTERNAME(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_wkssvc, DCERPC_WKSSVC_NETRSETPRIMARYCOMPUTERNAME, (ejs_pull_function_t)ejs_pull_WKSSVC_NETRSETPRIMARYCOMPUTERNAME, (ejs_push_function_t)ejs_push_WKSSVC_NETRSETPRIMARYCOMPUTERNAME);
}


static NTSTATUS ejs_pull_WKSSVC_NETRENUMERATECOMPUTERNAMES(struct ejs_rpc *ejs, struct MprVar *v, struct WKSSVC_NETRENUMERATECOMPUTERNAMES *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_WKSSVC_NETRENUMERATECOMPUTERNAMES(struct ejs_rpc *ejs, struct MprVar *v, const struct WKSSVC_NETRENUMERATECOMPUTERNAMES *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_WKSSVC_NETRENUMERATECOMPUTERNAMES(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_wkssvc, DCERPC_WKSSVC_NETRENUMERATECOMPUTERNAMES, (ejs_pull_function_t)ejs_pull_WKSSVC_NETRENUMERATECOMPUTERNAMES, (ejs_push_function_t)ejs_push_WKSSVC_NETRENUMERATECOMPUTERNAMES);
}

static int ejs_wkssvc_init(int eid, int argc, struct MprVar **argv)
{
	struct MprVar *obj = mprInitObject(eid, "wkssvc", argc, argv);
	mprSetCFunction(obj, "wkssvc_NetWkstaGetInfo", ejs_wkssvc_NetWkstaGetInfo);
	mprSetCFunction(obj, "wkssvc_NetWkstaSetInfo", ejs_wkssvc_NetWkstaSetInfo);
	mprSetCFunction(obj, "wkssvc_NetWkstaEnumUsers", ejs_wkssvc_NetWkstaEnumUsers);
	mprSetCFunction(obj, "WKSSVC_NETRWKSTAUSERGETINFO", ejs_WKSSVC_NETRWKSTAUSERGETINFO);
	mprSetCFunction(obj, "WKSSVC_NETRWKSTAUSERSETINFO", ejs_WKSSVC_NETRWKSTAUSERSETINFO);
	mprSetCFunction(obj, "wkssvc_NetWkstaTransportEnum", ejs_wkssvc_NetWkstaTransportEnum);
	mprSetCFunction(obj, "WKSSVC_NETRWKSTATRANSPORTADD", ejs_WKSSVC_NETRWKSTATRANSPORTADD);
	mprSetCFunction(obj, "WKSSVC_NETRWKSTATRANSPORTDEL", ejs_WKSSVC_NETRWKSTATRANSPORTDEL);
	mprSetCFunction(obj, "WKSSVC_NETRUSEADD", ejs_WKSSVC_NETRUSEADD);
	mprSetCFunction(obj, "WKSSVC_NETRUSEGETINFO", ejs_WKSSVC_NETRUSEGETINFO);
	mprSetCFunction(obj, "WKSSVC_NETRUSEDEL", ejs_WKSSVC_NETRUSEDEL);
	mprSetCFunction(obj, "WKSSVC_NETRUSEENUM", ejs_WKSSVC_NETRUSEENUM);
	mprSetCFunction(obj, "WKSSVC_NETRMESSAGEBUFFERSEND", ejs_WKSSVC_NETRMESSAGEBUFFERSEND);
	mprSetCFunction(obj, "WKSSVC_NETRWORKSTATIONSTATISTICSGET", ejs_WKSSVC_NETRWORKSTATIONSTATISTICSGET);
	mprSetCFunction(obj, "WKSSVC_NETRLOGONDOMAINNAMEADD", ejs_WKSSVC_NETRLOGONDOMAINNAMEADD);
	mprSetCFunction(obj, "WKSSVC_NETRLOGONDOMAINNAMEDEL", ejs_WKSSVC_NETRLOGONDOMAINNAMEDEL);
	mprSetCFunction(obj, "WKSSVC_NETRJOINDOMAIN", ejs_WKSSVC_NETRJOINDOMAIN);
	mprSetCFunction(obj, "WKSSVC_NETRUNJOINDOMAIN", ejs_WKSSVC_NETRUNJOINDOMAIN);
	mprSetCFunction(obj, "WKSSVC_NETRRENAMEMACHINEINDOMAIN", ejs_WKSSVC_NETRRENAMEMACHINEINDOMAIN);
	mprSetCFunction(obj, "WKSSVC_NETRVALIDATENAME", ejs_WKSSVC_NETRVALIDATENAME);
	mprSetCFunction(obj, "WKSSVC_NETRGETJOININFORMATION", ejs_WKSSVC_NETRGETJOININFORMATION);
	mprSetCFunction(obj, "WKSSVC_NETRGETJOINABLEOUS", ejs_WKSSVC_NETRGETJOINABLEOUS);
	mprSetCFunction(obj, "wkssvc_NetrJoinDomain2", ejs_wkssvc_NetrJoinDomain2);
	mprSetCFunction(obj, "wkssvc_NetrUnjoinDomain2", ejs_wkssvc_NetrUnjoinDomain2);
	mprSetCFunction(obj, "wkssvc_NetrRenameMachineInDomain2", ejs_wkssvc_NetrRenameMachineInDomain2);
	mprSetCFunction(obj, "WKSSVC_NETRVALIDATENAME2", ejs_WKSSVC_NETRVALIDATENAME2);
	mprSetCFunction(obj, "WKSSVC_NETRGETJOINABLEOUS2", ejs_WKSSVC_NETRGETJOINABLEOUS2);
	mprSetCFunction(obj, "wkssvc_NetrAddAlternateComputerName", ejs_wkssvc_NetrAddAlternateComputerName);
	mprSetCFunction(obj, "wkssvc_NetrRemoveAlternateComputerName", ejs_wkssvc_NetrRemoveAlternateComputerName);
	mprSetCFunction(obj, "WKSSVC_NETRSETPRIMARYCOMPUTERNAME", ejs_WKSSVC_NETRSETPRIMARYCOMPUTERNAME);
	mprSetCFunction(obj, "WKSSVC_NETRENUMERATECOMPUTERNAMES", ejs_WKSSVC_NETRENUMERATECOMPUTERNAMES);
	return ejs_rpc_init(obj, "wkssvc");
}

NTSTATUS ejs_init_wkssvc(void)
{
	ejsDefineCFunction(-1, "wkssvc_init", ejs_wkssvc_init, NULL, MPR_VAR_SCRIPT_HANDLE);
	return NT_STATUS_OK;
}
