/* server functions auto-generated by pidl */
#include "librpc/gen_ndr/ndr_winreg.h"

/* winreg - dcerpc server boilerplate generated by pidl */


static NTSTATUS winreg__op_bind(struct dcesrv_call_state *dce_call, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_WINREG_BIND
	return DCESRV_INTERFACE_WINREG_BIND(dce_call,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void winreg__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_WINREG_UNBIND
	DCESRV_INTERFACE_WINREG_UNBIND(context, iface);
#else
	return;
#endif
}

static NTSTATUS winreg__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	NTSTATUS status;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= dcerpc_table_winreg.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_size(mem_ctx, dcerpc_table_winreg.calls[opnum].struct_size);
	NT_STATUS_HAVE_NO_MEMORY(*r);

        /* unravel the NDR for the packet */
	status = dcerpc_table_winreg.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NT_STATUS_IS_OK(status)) {
		dcerpc_log_packet(&dcerpc_table_winreg, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS winreg__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct winreg_OpenHKCR *r2 = (struct winreg_OpenHKCR *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_OpenHKCR, NDR_IN, r2);
		}
		r2->out.result = dcesrv_winreg_OpenHKCR(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_OpenHKCR will reply async\n"));
		}
		break;
	}
	case 1: {
		struct winreg_OpenHKCU *r2 = (struct winreg_OpenHKCU *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_OpenHKCU, NDR_IN, r2);
		}
		r2->out.result = dcesrv_winreg_OpenHKCU(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_OpenHKCU will reply async\n"));
		}
		break;
	}
	case 2: {
		struct winreg_OpenHKLM *r2 = (struct winreg_OpenHKLM *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_OpenHKLM, NDR_IN, r2);
		}
		r2->out.result = dcesrv_winreg_OpenHKLM(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_OpenHKLM will reply async\n"));
		}
		break;
	}
	case 3: {
		struct winreg_OpenHKPD *r2 = (struct winreg_OpenHKPD *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_OpenHKPD, NDR_IN, r2);
		}
		r2->out.result = dcesrv_winreg_OpenHKPD(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_OpenHKPD will reply async\n"));
		}
		break;
	}
	case 4: {
		struct winreg_OpenHKU *r2 = (struct winreg_OpenHKU *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_OpenHKU, NDR_IN, r2);
		}
		r2->out.result = dcesrv_winreg_OpenHKU(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_OpenHKU will reply async\n"));
		}
		break;
	}
	case 5: {
		struct winreg_CloseKey *r2 = (struct winreg_CloseKey *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_CloseKey, NDR_IN, r2);
		}
		r2->out.result = dcesrv_winreg_CloseKey(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_CloseKey will reply async\n"));
		}
		break;
	}
	case 6: {
		struct winreg_CreateKey *r2 = (struct winreg_CreateKey *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_CreateKey, NDR_IN, r2);
		}
		r2->out.result = dcesrv_winreg_CreateKey(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_CreateKey will reply async\n"));
		}
		break;
	}
	case 7: {
		struct winreg_DeleteKey *r2 = (struct winreg_DeleteKey *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_DeleteKey, NDR_IN, r2);
		}
		r2->out.result = dcesrv_winreg_DeleteKey(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_DeleteKey will reply async\n"));
		}
		break;
	}
	case 8: {
		struct winreg_DeleteValue *r2 = (struct winreg_DeleteValue *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_DeleteValue, NDR_IN, r2);
		}
		r2->out.result = dcesrv_winreg_DeleteValue(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_DeleteValue will reply async\n"));
		}
		break;
	}
	case 9: {
		struct winreg_EnumKey *r2 = (struct winreg_EnumKey *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_EnumKey, NDR_IN, r2);
		}
		r2->out.result = dcesrv_winreg_EnumKey(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_EnumKey will reply async\n"));
		}
		break;
	}
	case 10: {
		struct winreg_EnumValue *r2 = (struct winreg_EnumValue *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_EnumValue, NDR_IN, r2);
		}
		r2->out.result = dcesrv_winreg_EnumValue(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_EnumValue will reply async\n"));
		}
		break;
	}
	case 11: {
		struct winreg_FlushKey *r2 = (struct winreg_FlushKey *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_FlushKey, NDR_IN, r2);
		}
		r2->out.result = dcesrv_winreg_FlushKey(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_FlushKey will reply async\n"));
		}
		break;
	}
	case 12: {
		struct winreg_GetKeySecurity *r2 = (struct winreg_GetKeySecurity *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_GetKeySecurity, NDR_IN, r2);
		}
		r2->out.result = dcesrv_winreg_GetKeySecurity(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_GetKeySecurity will reply async\n"));
		}
		break;
	}
	case 13: {
		struct winreg_LoadKey *r2 = (struct winreg_LoadKey *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_LoadKey, NDR_IN, r2);
		}
		r2->out.result = dcesrv_winreg_LoadKey(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_LoadKey will reply async\n"));
		}
		break;
	}
	case 14: {
		struct winreg_NotifyChangeKeyValue *r2 = (struct winreg_NotifyChangeKeyValue *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_NotifyChangeKeyValue, NDR_IN, r2);
		}
		r2->out.result = dcesrv_winreg_NotifyChangeKeyValue(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_NotifyChangeKeyValue will reply async\n"));
		}
		break;
	}
	case 15: {
		struct winreg_OpenKey *r2 = (struct winreg_OpenKey *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_OpenKey, NDR_IN, r2);
		}
		r2->out.result = dcesrv_winreg_OpenKey(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_OpenKey will reply async\n"));
		}
		break;
	}
	case 16: {
		struct winreg_QueryInfoKey *r2 = (struct winreg_QueryInfoKey *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_QueryInfoKey, NDR_IN, r2);
		}
		r2->out.result = dcesrv_winreg_QueryInfoKey(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_QueryInfoKey will reply async\n"));
		}
		break;
	}
	case 17: {
		struct winreg_QueryValue *r2 = (struct winreg_QueryValue *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_QueryValue, NDR_IN, r2);
		}
		r2->out.result = dcesrv_winreg_QueryValue(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_QueryValue will reply async\n"));
		}
		break;
	}
	case 18: {
		struct winreg_ReplaceKey *r2 = (struct winreg_ReplaceKey *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_ReplaceKey, NDR_IN, r2);
		}
		r2->out.result = dcesrv_winreg_ReplaceKey(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_ReplaceKey will reply async\n"));
		}
		break;
	}
	case 19: {
		struct winreg_RestoreKey *r2 = (struct winreg_RestoreKey *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_RestoreKey, NDR_IN, r2);
		}
		r2->out.result = dcesrv_winreg_RestoreKey(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_RestoreKey will reply async\n"));
		}
		break;
	}
	case 20: {
		struct winreg_SaveKey *r2 = (struct winreg_SaveKey *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_SaveKey, NDR_IN, r2);
		}
		r2->out.result = dcesrv_winreg_SaveKey(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_SaveKey will reply async\n"));
		}
		break;
	}
	case 21: {
		struct winreg_SetKeySecurity *r2 = (struct winreg_SetKeySecurity *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_SetKeySecurity, NDR_IN, r2);
		}
		r2->out.result = dcesrv_winreg_SetKeySecurity(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_SetKeySecurity will reply async\n"));
		}
		break;
	}
	case 22: {
		struct winreg_SetValue *r2 = (struct winreg_SetValue *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_SetValue, NDR_IN, r2);
		}
		r2->out.result = dcesrv_winreg_SetValue(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_SetValue will reply async\n"));
		}
		break;
	}
	case 23: {
		struct winreg_UnLoadKey *r2 = (struct winreg_UnLoadKey *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_UnLoadKey, NDR_IN, r2);
		}
		r2->out.result = dcesrv_winreg_UnLoadKey(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_UnLoadKey will reply async\n"));
		}
		break;
	}
	case 24: {
		struct winreg_InitiateSystemShutdown *r2 = (struct winreg_InitiateSystemShutdown *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_InitiateSystemShutdown, NDR_IN, r2);
		}
		r2->out.result = dcesrv_winreg_InitiateSystemShutdown(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_InitiateSystemShutdown will reply async\n"));
		}
		break;
	}
	case 25: {
		struct winreg_AbortSystemShutdown *r2 = (struct winreg_AbortSystemShutdown *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_AbortSystemShutdown, NDR_IN, r2);
		}
		r2->out.result = dcesrv_winreg_AbortSystemShutdown(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_AbortSystemShutdown will reply async\n"));
		}
		break;
	}
	case 26: {
		struct winreg_GetVersion *r2 = (struct winreg_GetVersion *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_GetVersion, NDR_IN, r2);
		}
		r2->out.result = dcesrv_winreg_GetVersion(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_GetVersion will reply async\n"));
		}
		break;
	}
	case 27: {
		struct winreg_OpenHKCC *r2 = (struct winreg_OpenHKCC *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_OpenHKCC, NDR_IN, r2);
		}
		r2->out.result = dcesrv_winreg_OpenHKCC(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_OpenHKCC will reply async\n"));
		}
		break;
	}
	case 28: {
		struct winreg_OpenHKDD *r2 = (struct winreg_OpenHKDD *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_OpenHKDD, NDR_IN, r2);
		}
		r2->out.result = dcesrv_winreg_OpenHKDD(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_OpenHKDD will reply async\n"));
		}
		break;
	}
	case 29: {
		struct winreg_QueryMultipleValues *r2 = (struct winreg_QueryMultipleValues *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_QueryMultipleValues, NDR_IN, r2);
		}
		r2->out.result = dcesrv_winreg_QueryMultipleValues(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_QueryMultipleValues will reply async\n"));
		}
		break;
	}
	case 30: {
		struct winreg_InitiateSystemShutdownEx *r2 = (struct winreg_InitiateSystemShutdownEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_InitiateSystemShutdownEx, NDR_IN, r2);
		}
		r2->out.result = dcesrv_winreg_InitiateSystemShutdownEx(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_InitiateSystemShutdownEx will reply async\n"));
		}
		break;
	}
	case 31: {
		struct winreg_SaveKeyEx *r2 = (struct winreg_SaveKeyEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_SaveKeyEx, NDR_IN, r2);
		}
		r2->out.result = dcesrv_winreg_SaveKeyEx(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_SaveKeyEx will reply async\n"));
		}
		break;
	}
	case 32: {
		struct winreg_OpenHKPT *r2 = (struct winreg_OpenHKPT *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_OpenHKPT, NDR_IN, r2);
		}
		r2->out.result = dcesrv_winreg_OpenHKPT(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_OpenHKPT will reply async\n"));
		}
		break;
	}
	case 33: {
		struct winreg_OpenHKPN *r2 = (struct winreg_OpenHKPN *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_OpenHKPN, NDR_IN, r2);
		}
		r2->out.result = dcesrv_winreg_OpenHKPN(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_OpenHKPN will reply async\n"));
		}
		break;
	}
	case 34: {
		struct winreg_QueryMultipleValues2 *r2 = (struct winreg_QueryMultipleValues2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_QueryMultipleValues2, NDR_IN, r2);
		}
		r2->out.result = dcesrv_winreg_QueryMultipleValues2(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_QueryMultipleValues2 will reply async\n"));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(&dcerpc_table_winreg, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS winreg__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct winreg_OpenHKCR *r2 = (struct winreg_OpenHKCR *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_OpenHKCR replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_OpenHKCR, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in winreg_OpenHKCR\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 1: {
		struct winreg_OpenHKCU *r2 = (struct winreg_OpenHKCU *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_OpenHKCU replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_OpenHKCU, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in winreg_OpenHKCU\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 2: {
		struct winreg_OpenHKLM *r2 = (struct winreg_OpenHKLM *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_OpenHKLM replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_OpenHKLM, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in winreg_OpenHKLM\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 3: {
		struct winreg_OpenHKPD *r2 = (struct winreg_OpenHKPD *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_OpenHKPD replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_OpenHKPD, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in winreg_OpenHKPD\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 4: {
		struct winreg_OpenHKU *r2 = (struct winreg_OpenHKU *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_OpenHKU replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_OpenHKU, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in winreg_OpenHKU\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 5: {
		struct winreg_CloseKey *r2 = (struct winreg_CloseKey *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_CloseKey replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_CloseKey, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in winreg_CloseKey\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 6: {
		struct winreg_CreateKey *r2 = (struct winreg_CreateKey *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_CreateKey replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_CreateKey, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in winreg_CreateKey\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 7: {
		struct winreg_DeleteKey *r2 = (struct winreg_DeleteKey *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_DeleteKey replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_DeleteKey, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in winreg_DeleteKey\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 8: {
		struct winreg_DeleteValue *r2 = (struct winreg_DeleteValue *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_DeleteValue replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_DeleteValue, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in winreg_DeleteValue\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 9: {
		struct winreg_EnumKey *r2 = (struct winreg_EnumKey *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_EnumKey replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_EnumKey, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in winreg_EnumKey\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 10: {
		struct winreg_EnumValue *r2 = (struct winreg_EnumValue *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_EnumValue replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_EnumValue, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in winreg_EnumValue\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 11: {
		struct winreg_FlushKey *r2 = (struct winreg_FlushKey *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_FlushKey replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_FlushKey, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in winreg_FlushKey\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 12: {
		struct winreg_GetKeySecurity *r2 = (struct winreg_GetKeySecurity *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_GetKeySecurity replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_GetKeySecurity, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in winreg_GetKeySecurity\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 13: {
		struct winreg_LoadKey *r2 = (struct winreg_LoadKey *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_LoadKey replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_LoadKey, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in winreg_LoadKey\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 14: {
		struct winreg_NotifyChangeKeyValue *r2 = (struct winreg_NotifyChangeKeyValue *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_NotifyChangeKeyValue replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_NotifyChangeKeyValue, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in winreg_NotifyChangeKeyValue\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 15: {
		struct winreg_OpenKey *r2 = (struct winreg_OpenKey *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_OpenKey replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_OpenKey, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in winreg_OpenKey\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 16: {
		struct winreg_QueryInfoKey *r2 = (struct winreg_QueryInfoKey *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_QueryInfoKey replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_QueryInfoKey, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in winreg_QueryInfoKey\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 17: {
		struct winreg_QueryValue *r2 = (struct winreg_QueryValue *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_QueryValue replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_QueryValue, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in winreg_QueryValue\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 18: {
		struct winreg_ReplaceKey *r2 = (struct winreg_ReplaceKey *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_ReplaceKey replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_ReplaceKey, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in winreg_ReplaceKey\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 19: {
		struct winreg_RestoreKey *r2 = (struct winreg_RestoreKey *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_RestoreKey replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_RestoreKey, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in winreg_RestoreKey\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 20: {
		struct winreg_SaveKey *r2 = (struct winreg_SaveKey *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_SaveKey replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_SaveKey, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in winreg_SaveKey\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 21: {
		struct winreg_SetKeySecurity *r2 = (struct winreg_SetKeySecurity *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_SetKeySecurity replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_SetKeySecurity, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in winreg_SetKeySecurity\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 22: {
		struct winreg_SetValue *r2 = (struct winreg_SetValue *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_SetValue replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_SetValue, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in winreg_SetValue\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 23: {
		struct winreg_UnLoadKey *r2 = (struct winreg_UnLoadKey *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_UnLoadKey replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_UnLoadKey, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in winreg_UnLoadKey\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 24: {
		struct winreg_InitiateSystemShutdown *r2 = (struct winreg_InitiateSystemShutdown *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_InitiateSystemShutdown replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_InitiateSystemShutdown, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in winreg_InitiateSystemShutdown\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 25: {
		struct winreg_AbortSystemShutdown *r2 = (struct winreg_AbortSystemShutdown *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_AbortSystemShutdown replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_AbortSystemShutdown, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in winreg_AbortSystemShutdown\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 26: {
		struct winreg_GetVersion *r2 = (struct winreg_GetVersion *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_GetVersion replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_GetVersion, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in winreg_GetVersion\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 27: {
		struct winreg_OpenHKCC *r2 = (struct winreg_OpenHKCC *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_OpenHKCC replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_OpenHKCC, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in winreg_OpenHKCC\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 28: {
		struct winreg_OpenHKDD *r2 = (struct winreg_OpenHKDD *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_OpenHKDD replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_OpenHKDD, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in winreg_OpenHKDD\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 29: {
		struct winreg_QueryMultipleValues *r2 = (struct winreg_QueryMultipleValues *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_QueryMultipleValues replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_QueryMultipleValues, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in winreg_QueryMultipleValues\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 30: {
		struct winreg_InitiateSystemShutdownEx *r2 = (struct winreg_InitiateSystemShutdownEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_InitiateSystemShutdownEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_InitiateSystemShutdownEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in winreg_InitiateSystemShutdownEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 31: {
		struct winreg_SaveKeyEx *r2 = (struct winreg_SaveKeyEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_SaveKeyEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_SaveKeyEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in winreg_SaveKeyEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 32: {
		struct winreg_OpenHKPT *r2 = (struct winreg_OpenHKPT *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_OpenHKPT replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_OpenHKPT, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in winreg_OpenHKPT\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 33: {
		struct winreg_OpenHKPN *r2 = (struct winreg_OpenHKPN *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_OpenHKPN replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_OpenHKPN, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in winreg_OpenHKPN\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 34: {
		struct winreg_QueryMultipleValues2 *r2 = (struct winreg_QueryMultipleValues2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winreg_QueryMultipleValues2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winreg_QueryMultipleValues2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in winreg_QueryMultipleValues2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(&dcerpc_table_winreg, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS winreg__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	NTSTATUS status;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	status = dcerpc_table_winreg.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NT_STATUS_IS_OK(status)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

const struct dcesrv_interface dcesrv_winreg_interface = {
	.name		= "winreg",
	.syntax_id  = {{0x338cd001,0x2244,0x31f1,{0xaa,0xaa},{0x90,0x00,0x38,0x00,0x10,0x03}},1.0},
	.bind		= winreg__op_bind,
	.unbind		= winreg__op_unbind,
	.ndr_pull	= winreg__op_ndr_pull,
	.dispatch	= winreg__op_dispatch,
	.reply		= winreg__op_reply,
	.ndr_push	= winreg__op_ndr_push
};


static NTSTATUS winreg__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	int i;

	for (i=0;i<dcerpc_table_winreg.endpoints->count;i++) {
		NTSTATUS ret;
		const char *name = dcerpc_table_winreg.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, &dcesrv_winreg_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DEBUG(1,("winreg_op_init_server: failed to register endpoint '%s'\n",name));
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static BOOL winreg__op_interface_by_uuid(struct dcesrv_interface *iface, const struct GUID *uuid, uint32_t if_version)
{
	if (dcesrv_winreg_interface.syntax_id.if_version == if_version &&
		GUID_equal(&dcesrv_winreg_interface.syntax_id.uuid, uuid)) {
		memcpy(iface,&dcesrv_winreg_interface, sizeof(*iface));
		return True;
	}

	return False;
}

static BOOL winreg__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcesrv_winreg_interface.name, name)==0) {
		memcpy(iface, &dcesrv_winreg_interface, sizeof(*iface));
		return True;
	}

	return False;	
}
	
NTSTATUS dcerpc_server_winreg_init(void)
{
	NTSTATUS ret;
	struct dcesrv_endpoint_server ep_server;

	/* fill in our name */
	ep_server.name = "winreg";

	/* fill in all the operations */
	ep_server.init_server = winreg__op_init_server;

	ep_server.interface_by_uuid = winreg__op_interface_by_uuid;
	ep_server.interface_by_name = winreg__op_interface_by_name;

	/* register ourselves with the DCERPC subsystem. */
	ret = dcerpc_register_ep_server(&ep_server);

	if (!NT_STATUS_IS_OK(ret)) {
		DEBUG(0,("Failed to register 'winreg' endpoint server!\n"));
		return ret;
	}

	return ret;
}

