/* parser auto-generated by pidl */

#include "includes.h"
#include "libcli/util/nterr.h"
#include "librpc/gen_ndr/ndr_misc.h"
#include "librpc/gen_ndr/ndr_dcerpc.h"
#include "librpc/rpc/dcerpc.h"
#include "librpc/gen_ndr/ndr_winbind.h"

#include "librpc/gen_ndr/ndr_netlogon.h"
static NTSTATUS ndr_push_winbind_information(struct ndr_push *ndr, int flags, const struct winbind_information *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_winbind_information(struct ndr_pull *ndr, int flags, struct winbind_information *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_winbind_information(struct ndr_print *ndr, const char *name, int flags, const struct winbind_information *r)
{
	ndr_print_struct(ndr, name, "winbind_information");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winbind_information");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winbind_information");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_winbind_remote_control(struct ndr_push *ndr, int flags, const struct winbind_remote_control *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_winbind_remote_control(struct ndr_pull *ndr, int flags, struct winbind_remote_control *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_winbind_remote_control(struct ndr_print *ndr, const char *name, int flags, const struct winbind_remote_control *r)
{
	ndr_print_struct(ndr, name, "winbind_remote_control");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winbind_remote_control");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winbind_remote_control");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_winbind_SamLogon(struct ndr_push *ndr, int flags, const struct winbind_SamLogon *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.logon_level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->in.logon, r->in.logon_level));
		NDR_CHECK(ndr_push_netr_LogonLevel(ndr, NDR_SCALARS, &r->in.logon));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.validation_level));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->out.validation, r->in.validation_level));
		NDR_CHECK(ndr_push_netr_Validation(ndr, NDR_SCALARS, &r->out.validation));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->out.authoritative));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->out.flags));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_winbind_SamLogon(struct ndr_pull *ndr, int flags, struct winbind_SamLogon *r)
{
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.logon_level));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->in.logon, r->in.logon_level));
		NDR_CHECK(ndr_pull_netr_LogonLevel(ndr, NDR_SCALARS, &r->in.logon));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.validation_level));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->out.validation, r->in.validation_level));
		NDR_CHECK(ndr_pull_netr_Validation(ndr, NDR_SCALARS, &r->out.validation));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->out.authoritative));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->out.flags));
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_winbind_SamLogon(struct ndr_print *ndr, const char *name, int flags, const struct winbind_SamLogon *r)
{
	ndr_print_struct(ndr, name, "winbind_SamLogon");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winbind_SamLogon");
		ndr->depth++;
		ndr_print_uint16(ndr, "logon_level", r->in.logon_level);
		ndr_print_set_switch_value(ndr, &r->in.logon, r->in.logon_level);
		ndr_print_netr_LogonLevel(ndr, "logon", &r->in.logon);
		ndr_print_uint16(ndr, "validation_level", r->in.validation_level);
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winbind_SamLogon");
		ndr->depth++;
		ndr_print_set_switch_value(ndr, &r->out.validation, r->in.validation_level);
		ndr_print_netr_Validation(ndr, "validation", &r->out.validation);
		ndr_print_uint8(ndr, "authoritative", r->out.authoritative);
		ndr_print_uint32(ndr, "flags", r->out.flags);
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct dcerpc_interface_call winbind_calls[] = {
	{
		"winbind_information",
		sizeof(struct winbind_information),
		(ndr_push_flags_fn_t) ndr_push_winbind_information,
		(ndr_pull_flags_fn_t) ndr_pull_winbind_information,
		(ndr_print_function_t) ndr_print_winbind_information,
		False,
	},
	{
		"winbind_remote_control",
		sizeof(struct winbind_remote_control),
		(ndr_push_flags_fn_t) ndr_push_winbind_remote_control,
		(ndr_pull_flags_fn_t) ndr_pull_winbind_remote_control,
		(ndr_print_function_t) ndr_print_winbind_remote_control,
		False,
	},
	{
		"winbind_SamLogon",
		sizeof(struct winbind_SamLogon),
		(ndr_push_flags_fn_t) ndr_push_winbind_SamLogon,
		(ndr_pull_flags_fn_t) ndr_pull_winbind_SamLogon,
		(ndr_print_function_t) ndr_print_winbind_SamLogon,
		False,
	},
	{ NULL, 0, NULL, NULL, NULL, False }
};

static const char * const winbind_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\winbind]", 
};

static const struct dcerpc_endpoint_list winbind_endpoints = {
	.count	= 1,
	.names	= winbind_endpoint_strings
};

static const char * const winbind_authservice_strings[] = {
	"host", 
};

static const struct dcerpc_authservice_list winbind_authservices = {
	.count	= 1,
	.names	= winbind_authservice_strings
};


const struct dcerpc_interface_table dcerpc_table_winbind = {
	.name		= "winbind",
	.syntax_id	= {
		{0x245f3e6b,0x3c5d,0x6e21,{0x3a,0x2d},{0x2a,0x3d,0x64,0x5b,0x72,0x21}},
		DCERPC_WINBIND_VERSION
	},
	.helpstring	= DCERPC_WINBIND_HELPSTRING,
	.num_calls	= 3,
	.calls		= winbind_calls,
	.endpoints	= &winbind_endpoints,
	.authservices	= &winbind_authservices
};

