/* server functions auto-generated by pidl */
#include "librpc/gen_ndr/ndr_w32time.h"

/* w32time - dcerpc server boilerplate generated by pidl */


static NTSTATUS w32time__op_bind(struct dcesrv_call_state *dce_call, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_W32TIME_BIND
	return DCESRV_INTERFACE_W32TIME_BIND(dce_call,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void w32time__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_W32TIME_UNBIND
	DCESRV_INTERFACE_W32TIME_UNBIND(context, iface);
#else
	return;
#endif
}

static NTSTATUS w32time__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	NTSTATUS status;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= dcerpc_table_w32time.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_size(mem_ctx, dcerpc_table_w32time.calls[opnum].struct_size);
	NT_STATUS_HAVE_NO_MEMORY(*r);

        /* unravel the NDR for the packet */
	status = dcerpc_table_w32time.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NT_STATUS_IS_OK(status)) {
		dcerpc_log_packet(&dcerpc_table_w32time, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS w32time__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct w32time_SyncTime *r2 = (struct w32time_SyncTime *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(w32time_SyncTime, NDR_IN, r2);
		}
		r2->out.result = dcesrv_w32time_SyncTime(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function w32time_SyncTime will reply async\n"));
		}
		break;
	}
	case 1: {
		struct w32time_GetNetLogonServiceBits *r2 = (struct w32time_GetNetLogonServiceBits *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(w32time_GetNetLogonServiceBits, NDR_IN, r2);
		}
		r2->out.result = dcesrv_w32time_GetNetLogonServiceBits(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function w32time_GetNetLogonServiceBits will reply async\n"));
		}
		break;
	}
	case 2: {
		struct w32time_QueryProviderStatus *r2 = (struct w32time_QueryProviderStatus *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(w32time_QueryProviderStatus, NDR_IN, r2);
		}
		r2->out.result = dcesrv_w32time_QueryProviderStatus(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function w32time_QueryProviderStatus will reply async\n"));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(&dcerpc_table_w32time, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS w32time__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct w32time_SyncTime *r2 = (struct w32time_SyncTime *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function w32time_SyncTime replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(w32time_SyncTime, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in w32time_SyncTime\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 1: {
		struct w32time_GetNetLogonServiceBits *r2 = (struct w32time_GetNetLogonServiceBits *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function w32time_GetNetLogonServiceBits replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(w32time_GetNetLogonServiceBits, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in w32time_GetNetLogonServiceBits\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 2: {
		struct w32time_QueryProviderStatus *r2 = (struct w32time_QueryProviderStatus *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function w32time_QueryProviderStatus replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(w32time_QueryProviderStatus, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in w32time_QueryProviderStatus\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(&dcerpc_table_w32time, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS w32time__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	NTSTATUS status;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	status = dcerpc_table_w32time.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NT_STATUS_IS_OK(status)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

const struct dcesrv_interface dcesrv_w32time_interface = {
	.name		= "w32time",
	.syntax_id  = {{0x8fb6d884,0x2388,0x11d0,{0x8c,0x35},{0x00,0xc0,0x4f,0xda,0x27,0x95}},4.1},
	.bind		= w32time__op_bind,
	.unbind		= w32time__op_unbind,
	.ndr_pull	= w32time__op_ndr_pull,
	.dispatch	= w32time__op_dispatch,
	.reply		= w32time__op_reply,
	.ndr_push	= w32time__op_ndr_push
};


static NTSTATUS w32time__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	int i;

	for (i=0;i<dcerpc_table_w32time.endpoints->count;i++) {
		NTSTATUS ret;
		const char *name = dcerpc_table_w32time.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, &dcesrv_w32time_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DEBUG(1,("w32time_op_init_server: failed to register endpoint '%s'\n",name));
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static BOOL w32time__op_interface_by_uuid(struct dcesrv_interface *iface, const struct GUID *uuid, uint32_t if_version)
{
	if (dcesrv_w32time_interface.syntax_id.if_version == if_version &&
		GUID_equal(&dcesrv_w32time_interface.syntax_id.uuid, uuid)) {
		memcpy(iface,&dcesrv_w32time_interface, sizeof(*iface));
		return True;
	}

	return False;
}

static BOOL w32time__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcesrv_w32time_interface.name, name)==0) {
		memcpy(iface, &dcesrv_w32time_interface, sizeof(*iface));
		return True;
	}

	return False;	
}
	
NTSTATUS dcerpc_server_w32time_init(void)
{
	NTSTATUS ret;
	struct dcesrv_endpoint_server ep_server;

	/* fill in our name */
	ep_server.name = "w32time";

	/* fill in all the operations */
	ep_server.init_server = w32time__op_init_server;

	ep_server.interface_by_uuid = w32time__op_interface_by_uuid;
	ep_server.interface_by_name = w32time__op_interface_by_name;

	/* register ourselves with the DCERPC subsystem. */
	ret = dcerpc_register_ep_server(&ep_server);

	if (!NT_STATUS_IS_OK(ret)) {
		DEBUG(0,("Failed to register 'w32time' endpoint server!\n"));
		return ret;
	}

	return ret;
}

