
/* EJS wrapper functions auto-generated by pidl */
#include "includes.h"
#include "librpc/rpc/dcerpc.h"
#include "lib/appweb/ejs/ejs.h"
#include "scripting/ejs/ejsrpc.h"
#include "scripting/ejs/smbcalls.h"
#include "librpc/gen_ndr/ndr_misc_ejs.h"
#include "librpc/gen_ndr/ndr_srvsvc.h"
#include "librpc/gen_ndr/ndr_srvsvc_ejs.h"


static NTSTATUS ejs_push_srvsvc_NetCharDevInfo0(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetCharDevInfo0 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->device) {
		NDR_CHECK(ejs_push_null(ejs, v, "device"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "device", r->device));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetCharDevInfo0(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetCharDevInfo0 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "device")) {
		r->device = NULL;
	} else {
		EJS_ALLOC(ejs, r->device);
		NDR_CHECK(ejs_pull_string(ejs, v, "device", &r->device));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetCharDevCtr0(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetCharDevCtr0 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->array) {
		NDR_CHECK(ejs_push_null(ejs, v, "array"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_push_srvsvc_NetCharDevInfo0(ejs, v, id, &r->array[i]));
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetCharDevCtr0(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetCharDevCtr0 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	if (ejs_pull_null(ejs, v, "array")) {
		r->array = NULL;
	} else {
		EJS_ALLOC(ejs, r->array);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->array, r->count);
			for (i=0;i<r->count;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_pull_srvsvc_NetCharDevInfo0(ejs, v, id, &r->array[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetCharDevInfo1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetCharDevInfo1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->device) {
		NDR_CHECK(ejs_push_null(ejs, v, "device"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "device", r->device));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "status", &r->status));
	if (NULL == r->user) {
		NDR_CHECK(ejs_push_null(ejs, v, "user"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "user", r->user));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "time", &r->time));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetCharDevInfo1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetCharDevInfo1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "device")) {
		r->device = NULL;
	} else {
		EJS_ALLOC(ejs, r->device);
		NDR_CHECK(ejs_pull_string(ejs, v, "device", &r->device));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "status", &r->status));
	if (ejs_pull_null(ejs, v, "user")) {
		r->user = NULL;
	} else {
		EJS_ALLOC(ejs, r->user);
		NDR_CHECK(ejs_pull_string(ejs, v, "user", &r->user));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "time", &r->time));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetCharDevCtr1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetCharDevCtr1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->array) {
		NDR_CHECK(ejs_push_null(ejs, v, "array"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_push_srvsvc_NetCharDevInfo1(ejs, v, id, &r->array[i]));
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetCharDevCtr1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetCharDevCtr1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	if (ejs_pull_null(ejs, v, "array")) {
		r->array = NULL;
	} else {
		EJS_ALLOC(ejs, r->array);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->array, r->count);
			for (i=0;i<r->count;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_pull_srvsvc_NetCharDevInfo1(ejs, v, id, &r->array[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetCharDevInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union srvsvc_NetCharDevInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 0:
			if (NULL == r->info0) {
				NDR_CHECK(ejs_push_null(ejs, v, "info0"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetCharDevInfo0(ejs, v, "info0", r->info0));
			}
			break;
		case 1:
			if (NULL == r->info1) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetCharDevInfo1(ejs, v, "info1", r->info1));
			}
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_srvsvc_NetCharDevCtr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union srvsvc_NetCharDevCtr *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 0:
			if (NULL == r->ctr0) {
				NDR_CHECK(ejs_push_null(ejs, v, "ctr0"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetCharDevCtr0(ejs, v, "ctr0", r->ctr0));
			}
			break;
		case 1:
			if (NULL == r->ctr1) {
				NDR_CHECK(ejs_push_null(ejs, v, "ctr1"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetCharDevCtr1(ejs, v, "ctr1", r->ctr1));
			}
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_srvsvc_NetCharDevCtr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union srvsvc_NetCharDevCtr *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 0:
			if (ejs_pull_null(ejs, v, "ctr0")) {
				r->ctr0 = NULL;
			} else {
				EJS_ALLOC(ejs, r->ctr0);
				NDR_CHECK(ejs_pull_srvsvc_NetCharDevCtr0(ejs, v, "ctr0", r->ctr0));
			}
			break;
		case 1:
			if (ejs_pull_null(ejs, v, "ctr1")) {
				r->ctr1 = NULL;
			} else {
				EJS_ALLOC(ejs, r->ctr1);
				NDR_CHECK(ejs_pull_srvsvc_NetCharDevCtr1(ejs, v, "ctr1", r->ctr1));
			}
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_srvsvc_NetCharDevQInfo0(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetCharDevQInfo0 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->device) {
		NDR_CHECK(ejs_push_null(ejs, v, "device"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "device", r->device));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetCharDevQInfo0(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetCharDevQInfo0 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "device")) {
		r->device = NULL;
	} else {
		EJS_ALLOC(ejs, r->device);
		NDR_CHECK(ejs_pull_string(ejs, v, "device", &r->device));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetCharDevQCtr0(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetCharDevQCtr0 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->array) {
		NDR_CHECK(ejs_push_null(ejs, v, "array"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_push_srvsvc_NetCharDevQInfo0(ejs, v, id, &r->array[i]));
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetCharDevQCtr0(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetCharDevQCtr0 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	if (ejs_pull_null(ejs, v, "array")) {
		r->array = NULL;
	} else {
		EJS_ALLOC(ejs, r->array);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->array, r->count);
			for (i=0;i<r->count;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_pull_srvsvc_NetCharDevQInfo0(ejs, v, id, &r->array[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetCharDevQInfo1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetCharDevQInfo1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->device) {
		NDR_CHECK(ejs_push_null(ejs, v, "device"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "device", r->device));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "priority", &r->priority));
	if (NULL == r->devices) {
		NDR_CHECK(ejs_push_null(ejs, v, "devices"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "devices", r->devices));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "users", &r->users));
	NDR_CHECK(ejs_push_uint32(ejs, v, "num_ahead", &r->num_ahead));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetCharDevQInfo1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetCharDevQInfo1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "device")) {
		r->device = NULL;
	} else {
		EJS_ALLOC(ejs, r->device);
		NDR_CHECK(ejs_pull_string(ejs, v, "device", &r->device));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "priority", &r->priority));
	if (ejs_pull_null(ejs, v, "devices")) {
		r->devices = NULL;
	} else {
		EJS_ALLOC(ejs, r->devices);
		NDR_CHECK(ejs_pull_string(ejs, v, "devices", &r->devices));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "users", &r->users));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "num_ahead", &r->num_ahead));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetCharDevQCtr1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetCharDevQCtr1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->array) {
		NDR_CHECK(ejs_push_null(ejs, v, "array"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_push_srvsvc_NetCharDevQInfo1(ejs, v, id, &r->array[i]));
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetCharDevQCtr1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetCharDevQCtr1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	if (ejs_pull_null(ejs, v, "array")) {
		r->array = NULL;
	} else {
		EJS_ALLOC(ejs, r->array);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->array, r->count);
			for (i=0;i<r->count;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_pull_srvsvc_NetCharDevQInfo1(ejs, v, id, &r->array[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetCharDevQInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union srvsvc_NetCharDevQInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 0:
			if (NULL == r->info0) {
				NDR_CHECK(ejs_push_null(ejs, v, "info0"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetCharDevQInfo0(ejs, v, "info0", r->info0));
			}
			break;
		case 1:
			if (NULL == r->info1) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetCharDevQInfo1(ejs, v, "info1", r->info1));
			}
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_srvsvc_NetCharDevQInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union srvsvc_NetCharDevQInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 0:
			if (ejs_pull_null(ejs, v, "info0")) {
				r->info0 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info0);
				NDR_CHECK(ejs_pull_srvsvc_NetCharDevQInfo0(ejs, v, "info0", r->info0));
			}
			break;
		case 1:
			if (ejs_pull_null(ejs, v, "info1")) {
				r->info1 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1);
				NDR_CHECK(ejs_pull_srvsvc_NetCharDevQInfo1(ejs, v, "info1", r->info1));
			}
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_srvsvc_NetCharDevQCtr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union srvsvc_NetCharDevQCtr *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 0:
			if (NULL == r->ctr0) {
				NDR_CHECK(ejs_push_null(ejs, v, "ctr0"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetCharDevQCtr0(ejs, v, "ctr0", r->ctr0));
			}
			break;
		case 1:
			if (NULL == r->ctr1) {
				NDR_CHECK(ejs_push_null(ejs, v, "ctr1"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetCharDevQCtr1(ejs, v, "ctr1", r->ctr1));
			}
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_srvsvc_NetCharDevQCtr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union srvsvc_NetCharDevQCtr *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 0:
			if (ejs_pull_null(ejs, v, "ctr0")) {
				r->ctr0 = NULL;
			} else {
				EJS_ALLOC(ejs, r->ctr0);
				NDR_CHECK(ejs_pull_srvsvc_NetCharDevQCtr0(ejs, v, "ctr0", r->ctr0));
			}
			break;
		case 1:
			if (ejs_pull_null(ejs, v, "ctr1")) {
				r->ctr1 = NULL;
			} else {
				EJS_ALLOC(ejs, r->ctr1);
				NDR_CHECK(ejs_pull_srvsvc_NetCharDevQCtr1(ejs, v, "ctr1", r->ctr1));
			}
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_srvsvc_NetConnInfo0(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetConnInfo0 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "conn_id", &r->conn_id));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetConnInfo0(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetConnInfo0 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "conn_id", &r->conn_id));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetConnCtr0(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetConnCtr0 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->array) {
		NDR_CHECK(ejs_push_null(ejs, v, "array"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_push_srvsvc_NetConnInfo0(ejs, v, id, &r->array[i]));
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetConnCtr0(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetConnCtr0 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	if (ejs_pull_null(ejs, v, "array")) {
		r->array = NULL;
	} else {
		EJS_ALLOC(ejs, r->array);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->array, r->count);
			for (i=0;i<r->count;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_pull_srvsvc_NetConnInfo0(ejs, v, id, &r->array[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetConnInfo1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetConnInfo1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "conn_id", &r->conn_id));
	NDR_CHECK(ejs_push_uint32(ejs, v, "conn_type", &r->conn_type));
	NDR_CHECK(ejs_push_uint32(ejs, v, "num_open", &r->num_open));
	NDR_CHECK(ejs_push_uint32(ejs, v, "num_users", &r->num_users));
	NDR_CHECK(ejs_push_uint32(ejs, v, "conn_time", &r->conn_time));
	if (NULL == r->user) {
		NDR_CHECK(ejs_push_null(ejs, v, "user"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "user", r->user));
	}
	if (NULL == r->share) {
		NDR_CHECK(ejs_push_null(ejs, v, "share"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "share", r->share));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetConnInfo1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetConnInfo1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "conn_id", &r->conn_id));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "conn_type", &r->conn_type));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "num_open", &r->num_open));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "num_users", &r->num_users));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "conn_time", &r->conn_time));
	if (ejs_pull_null(ejs, v, "user")) {
		r->user = NULL;
	} else {
		EJS_ALLOC(ejs, r->user);
		NDR_CHECK(ejs_pull_string(ejs, v, "user", &r->user));
	}
	if (ejs_pull_null(ejs, v, "share")) {
		r->share = NULL;
	} else {
		EJS_ALLOC(ejs, r->share);
		NDR_CHECK(ejs_pull_string(ejs, v, "share", &r->share));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetConnCtr1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetConnCtr1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->array) {
		NDR_CHECK(ejs_push_null(ejs, v, "array"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_push_srvsvc_NetConnInfo1(ejs, v, id, &r->array[i]));
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetConnCtr1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetConnCtr1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	if (ejs_pull_null(ejs, v, "array")) {
		r->array = NULL;
	} else {
		EJS_ALLOC(ejs, r->array);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->array, r->count);
			for (i=0;i<r->count;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_pull_srvsvc_NetConnInfo1(ejs, v, id, &r->array[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetConnCtr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union srvsvc_NetConnCtr *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 0:
			if (NULL == r->ctr0) {
				NDR_CHECK(ejs_push_null(ejs, v, "ctr0"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetConnCtr0(ejs, v, "ctr0", r->ctr0));
			}
			break;
		case 1:
			if (NULL == r->ctr1) {
				NDR_CHECK(ejs_push_null(ejs, v, "ctr1"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetConnCtr1(ejs, v, "ctr1", r->ctr1));
			}
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_srvsvc_NetConnCtr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union srvsvc_NetConnCtr *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 0:
			if (ejs_pull_null(ejs, v, "ctr0")) {
				r->ctr0 = NULL;
			} else {
				EJS_ALLOC(ejs, r->ctr0);
				NDR_CHECK(ejs_pull_srvsvc_NetConnCtr0(ejs, v, "ctr0", r->ctr0));
			}
			break;
		case 1:
			if (ejs_pull_null(ejs, v, "ctr1")) {
				r->ctr1 = NULL;
			} else {
				EJS_ALLOC(ejs, r->ctr1);
				NDR_CHECK(ejs_pull_srvsvc_NetConnCtr1(ejs, v, "ctr1", r->ctr1));
			}
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_srvsvc_NetFileInfo2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetFileInfo2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "fid", &r->fid));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetFileInfo2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetFileInfo2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "fid", &r->fid));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetFileCtr2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetFileCtr2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->array) {
		NDR_CHECK(ejs_push_null(ejs, v, "array"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_push_srvsvc_NetFileInfo2(ejs, v, id, &r->array[i]));
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetFileCtr2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetFileCtr2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	if (ejs_pull_null(ejs, v, "array")) {
		r->array = NULL;
	} else {
		EJS_ALLOC(ejs, r->array);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->array, r->count);
			for (i=0;i<r->count;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_pull_srvsvc_NetFileInfo2(ejs, v, id, &r->array[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetFileInfo3(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetFileInfo3 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "fid", &r->fid));
	NDR_CHECK(ejs_push_uint32(ejs, v, "permissions", &r->permissions));
	NDR_CHECK(ejs_push_uint32(ejs, v, "num_locks", &r->num_locks));
	if (NULL == r->path) {
		NDR_CHECK(ejs_push_null(ejs, v, "path"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "path", r->path));
	}
	if (NULL == r->user) {
		NDR_CHECK(ejs_push_null(ejs, v, "user"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "user", r->user));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetFileInfo3(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetFileInfo3 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "fid", &r->fid));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "permissions", &r->permissions));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "num_locks", &r->num_locks));
	if (ejs_pull_null(ejs, v, "path")) {
		r->path = NULL;
	} else {
		EJS_ALLOC(ejs, r->path);
		NDR_CHECK(ejs_pull_string(ejs, v, "path", &r->path));
	}
	if (ejs_pull_null(ejs, v, "user")) {
		r->user = NULL;
	} else {
		EJS_ALLOC(ejs, r->user);
		NDR_CHECK(ejs_pull_string(ejs, v, "user", &r->user));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetFileCtr3(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetFileCtr3 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->array) {
		NDR_CHECK(ejs_push_null(ejs, v, "array"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_push_srvsvc_NetFileInfo3(ejs, v, id, &r->array[i]));
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetFileCtr3(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetFileCtr3 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	if (ejs_pull_null(ejs, v, "array")) {
		r->array = NULL;
	} else {
		EJS_ALLOC(ejs, r->array);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->array, r->count);
			for (i=0;i<r->count;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_pull_srvsvc_NetFileInfo3(ejs, v, id, &r->array[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetFileInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union srvsvc_NetFileInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 2:
			if (NULL == r->info2) {
				NDR_CHECK(ejs_push_null(ejs, v, "info2"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetFileInfo2(ejs, v, "info2", r->info2));
			}
			break;
		case 3:
			if (NULL == r->info3) {
				NDR_CHECK(ejs_push_null(ejs, v, "info3"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetFileInfo3(ejs, v, "info3", r->info3));
			}
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_srvsvc_NetFileCtr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union srvsvc_NetFileCtr *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 2:
			if (NULL == r->ctr2) {
				NDR_CHECK(ejs_push_null(ejs, v, "ctr2"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetFileCtr2(ejs, v, "ctr2", r->ctr2));
			}
			break;
		case 3:
			if (NULL == r->ctr3) {
				NDR_CHECK(ejs_push_null(ejs, v, "ctr3"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetFileCtr3(ejs, v, "ctr3", r->ctr3));
			}
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_srvsvc_NetFileCtr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union srvsvc_NetFileCtr *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 2:
			if (ejs_pull_null(ejs, v, "ctr2")) {
				r->ctr2 = NULL;
			} else {
				EJS_ALLOC(ejs, r->ctr2);
				NDR_CHECK(ejs_pull_srvsvc_NetFileCtr2(ejs, v, "ctr2", r->ctr2));
			}
			break;
		case 3:
			if (ejs_pull_null(ejs, v, "ctr3")) {
				r->ctr3 = NULL;
			} else {
				EJS_ALLOC(ejs, r->ctr3);
				NDR_CHECK(ejs_pull_srvsvc_NetFileCtr3(ejs, v, "ctr3", r->ctr3));
			}
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_srvsvc_NetSessInfo0(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSessInfo0 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->client) {
		NDR_CHECK(ejs_push_null(ejs, v, "client"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "client", r->client));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSessInfo0(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSessInfo0 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "client")) {
		r->client = NULL;
	} else {
		EJS_ALLOC(ejs, r->client);
		NDR_CHECK(ejs_pull_string(ejs, v, "client", &r->client));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSessCtr0(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSessCtr0 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->array) {
		NDR_CHECK(ejs_push_null(ejs, v, "array"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_push_srvsvc_NetSessInfo0(ejs, v, id, &r->array[i]));
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSessCtr0(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSessCtr0 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	if (ejs_pull_null(ejs, v, "array")) {
		r->array = NULL;
	} else {
		EJS_ALLOC(ejs, r->array);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->array, r->count);
			for (i=0;i<r->count;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_pull_srvsvc_NetSessInfo0(ejs, v, id, &r->array[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSessInfo1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSessInfo1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->client) {
		NDR_CHECK(ejs_push_null(ejs, v, "client"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "client", r->client));
	}
	if (NULL == r->user) {
		NDR_CHECK(ejs_push_null(ejs, v, "user"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "user", r->user));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "num_open", &r->num_open));
	NDR_CHECK(ejs_push_uint32(ejs, v, "time", &r->time));
	NDR_CHECK(ejs_push_uint32(ejs, v, "idle_time", &r->idle_time));
	NDR_CHECK(ejs_push_uint32(ejs, v, "user_flags", &r->user_flags));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSessInfo1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSessInfo1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "client")) {
		r->client = NULL;
	} else {
		EJS_ALLOC(ejs, r->client);
		NDR_CHECK(ejs_pull_string(ejs, v, "client", &r->client));
	}
	if (ejs_pull_null(ejs, v, "user")) {
		r->user = NULL;
	} else {
		EJS_ALLOC(ejs, r->user);
		NDR_CHECK(ejs_pull_string(ejs, v, "user", &r->user));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "num_open", &r->num_open));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "time", &r->time));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "idle_time", &r->idle_time));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "user_flags", &r->user_flags));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSessCtr1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSessCtr1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->array) {
		NDR_CHECK(ejs_push_null(ejs, v, "array"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_push_srvsvc_NetSessInfo1(ejs, v, id, &r->array[i]));
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSessCtr1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSessCtr1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	if (ejs_pull_null(ejs, v, "array")) {
		r->array = NULL;
	} else {
		EJS_ALLOC(ejs, r->array);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->array, r->count);
			for (i=0;i<r->count;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_pull_srvsvc_NetSessInfo1(ejs, v, id, &r->array[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSessInfo2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSessInfo2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->client) {
		NDR_CHECK(ejs_push_null(ejs, v, "client"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "client", r->client));
	}
	if (NULL == r->user) {
		NDR_CHECK(ejs_push_null(ejs, v, "user"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "user", r->user));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "num_open", &r->num_open));
	NDR_CHECK(ejs_push_uint32(ejs, v, "time", &r->time));
	NDR_CHECK(ejs_push_uint32(ejs, v, "idle_time", &r->idle_time));
	NDR_CHECK(ejs_push_uint32(ejs, v, "user_flags", &r->user_flags));
	if (NULL == r->client_type) {
		NDR_CHECK(ejs_push_null(ejs, v, "client_type"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "client_type", r->client_type));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSessInfo2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSessInfo2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "client")) {
		r->client = NULL;
	} else {
		EJS_ALLOC(ejs, r->client);
		NDR_CHECK(ejs_pull_string(ejs, v, "client", &r->client));
	}
	if (ejs_pull_null(ejs, v, "user")) {
		r->user = NULL;
	} else {
		EJS_ALLOC(ejs, r->user);
		NDR_CHECK(ejs_pull_string(ejs, v, "user", &r->user));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "num_open", &r->num_open));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "time", &r->time));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "idle_time", &r->idle_time));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "user_flags", &r->user_flags));
	if (ejs_pull_null(ejs, v, "client_type")) {
		r->client_type = NULL;
	} else {
		EJS_ALLOC(ejs, r->client_type);
		NDR_CHECK(ejs_pull_string(ejs, v, "client_type", &r->client_type));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSessCtr2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSessCtr2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->array) {
		NDR_CHECK(ejs_push_null(ejs, v, "array"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_push_srvsvc_NetSessInfo2(ejs, v, id, &r->array[i]));
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSessCtr2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSessCtr2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	if (ejs_pull_null(ejs, v, "array")) {
		r->array = NULL;
	} else {
		EJS_ALLOC(ejs, r->array);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->array, r->count);
			for (i=0;i<r->count;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_pull_srvsvc_NetSessInfo2(ejs, v, id, &r->array[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSessInfo10(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSessInfo10 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->client) {
		NDR_CHECK(ejs_push_null(ejs, v, "client"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "client", r->client));
	}
	if (NULL == r->user) {
		NDR_CHECK(ejs_push_null(ejs, v, "user"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "user", r->user));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "time", &r->time));
	NDR_CHECK(ejs_push_uint32(ejs, v, "idle_time", &r->idle_time));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSessInfo10(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSessInfo10 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "client")) {
		r->client = NULL;
	} else {
		EJS_ALLOC(ejs, r->client);
		NDR_CHECK(ejs_pull_string(ejs, v, "client", &r->client));
	}
	if (ejs_pull_null(ejs, v, "user")) {
		r->user = NULL;
	} else {
		EJS_ALLOC(ejs, r->user);
		NDR_CHECK(ejs_pull_string(ejs, v, "user", &r->user));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "time", &r->time));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "idle_time", &r->idle_time));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSessCtr10(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSessCtr10 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->array) {
		NDR_CHECK(ejs_push_null(ejs, v, "array"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_push_srvsvc_NetSessInfo10(ejs, v, id, &r->array[i]));
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSessCtr10(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSessCtr10 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	if (ejs_pull_null(ejs, v, "array")) {
		r->array = NULL;
	} else {
		EJS_ALLOC(ejs, r->array);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->array, r->count);
			for (i=0;i<r->count;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_pull_srvsvc_NetSessInfo10(ejs, v, id, &r->array[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSessInfo502(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSessInfo502 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->client) {
		NDR_CHECK(ejs_push_null(ejs, v, "client"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "client", r->client));
	}
	if (NULL == r->user) {
		NDR_CHECK(ejs_push_null(ejs, v, "user"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "user", r->user));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "num_open", &r->num_open));
	NDR_CHECK(ejs_push_uint32(ejs, v, "time", &r->time));
	NDR_CHECK(ejs_push_uint32(ejs, v, "idle_time", &r->idle_time));
	NDR_CHECK(ejs_push_uint32(ejs, v, "user_flags", &r->user_flags));
	if (NULL == r->client_type) {
		NDR_CHECK(ejs_push_null(ejs, v, "client_type"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "client_type", r->client_type));
	}
	if (NULL == r->transport) {
		NDR_CHECK(ejs_push_null(ejs, v, "transport"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "transport", r->transport));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSessInfo502(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSessInfo502 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "client")) {
		r->client = NULL;
	} else {
		EJS_ALLOC(ejs, r->client);
		NDR_CHECK(ejs_pull_string(ejs, v, "client", &r->client));
	}
	if (ejs_pull_null(ejs, v, "user")) {
		r->user = NULL;
	} else {
		EJS_ALLOC(ejs, r->user);
		NDR_CHECK(ejs_pull_string(ejs, v, "user", &r->user));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "num_open", &r->num_open));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "time", &r->time));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "idle_time", &r->idle_time));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "user_flags", &r->user_flags));
	if (ejs_pull_null(ejs, v, "client_type")) {
		r->client_type = NULL;
	} else {
		EJS_ALLOC(ejs, r->client_type);
		NDR_CHECK(ejs_pull_string(ejs, v, "client_type", &r->client_type));
	}
	if (ejs_pull_null(ejs, v, "transport")) {
		r->transport = NULL;
	} else {
		EJS_ALLOC(ejs, r->transport);
		NDR_CHECK(ejs_pull_string(ejs, v, "transport", &r->transport));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSessCtr502(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSessCtr502 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->array) {
		NDR_CHECK(ejs_push_null(ejs, v, "array"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_push_srvsvc_NetSessInfo502(ejs, v, id, &r->array[i]));
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSessCtr502(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSessCtr502 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	if (ejs_pull_null(ejs, v, "array")) {
		r->array = NULL;
	} else {
		EJS_ALLOC(ejs, r->array);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->array, r->count);
			for (i=0;i<r->count;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_pull_srvsvc_NetSessInfo502(ejs, v, id, &r->array[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSessCtr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union srvsvc_NetSessCtr *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 0:
			if (NULL == r->ctr0) {
				NDR_CHECK(ejs_push_null(ejs, v, "ctr0"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSessCtr0(ejs, v, "ctr0", r->ctr0));
			}
			break;
		case 1:
			if (NULL == r->ctr1) {
				NDR_CHECK(ejs_push_null(ejs, v, "ctr1"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSessCtr1(ejs, v, "ctr1", r->ctr1));
			}
			break;
		case 2:
			if (NULL == r->ctr2) {
				NDR_CHECK(ejs_push_null(ejs, v, "ctr2"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSessCtr2(ejs, v, "ctr2", r->ctr2));
			}
			break;
		case 10:
			if (NULL == r->ctr10) {
				NDR_CHECK(ejs_push_null(ejs, v, "ctr10"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSessCtr10(ejs, v, "ctr10", r->ctr10));
			}
			break;
		case 502:
			if (NULL == r->ctr502) {
				NDR_CHECK(ejs_push_null(ejs, v, "ctr502"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSessCtr502(ejs, v, "ctr502", r->ctr502));
			}
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_srvsvc_NetSessCtr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union srvsvc_NetSessCtr *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 0:
			if (ejs_pull_null(ejs, v, "ctr0")) {
				r->ctr0 = NULL;
			} else {
				EJS_ALLOC(ejs, r->ctr0);
				NDR_CHECK(ejs_pull_srvsvc_NetSessCtr0(ejs, v, "ctr0", r->ctr0));
			}
			break;
		case 1:
			if (ejs_pull_null(ejs, v, "ctr1")) {
				r->ctr1 = NULL;
			} else {
				EJS_ALLOC(ejs, r->ctr1);
				NDR_CHECK(ejs_pull_srvsvc_NetSessCtr1(ejs, v, "ctr1", r->ctr1));
			}
			break;
		case 2:
			if (ejs_pull_null(ejs, v, "ctr2")) {
				r->ctr2 = NULL;
			} else {
				EJS_ALLOC(ejs, r->ctr2);
				NDR_CHECK(ejs_pull_srvsvc_NetSessCtr2(ejs, v, "ctr2", r->ctr2));
			}
			break;
		case 10:
			if (ejs_pull_null(ejs, v, "ctr10")) {
				r->ctr10 = NULL;
			} else {
				EJS_ALLOC(ejs, r->ctr10);
				NDR_CHECK(ejs_pull_srvsvc_NetSessCtr10(ejs, v, "ctr10", r->ctr10));
			}
			break;
		case 502:
			if (ejs_pull_null(ejs, v, "ctr502")) {
				r->ctr502 = NULL;
			} else {
				EJS_ALLOC(ejs, r->ctr502);
				NDR_CHECK(ejs_pull_srvsvc_NetSessCtr502(ejs, v, "ctr502", r->ctr502));
			}
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_srvsvc_ShareType(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const enum srvsvc_ShareType *r)
{
	unsigned e = *r;
	NDR_CHECK(ejs_push_enum(ejs, v, name, &e));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_ShareType(struct ejs_rpc *ejs, struct MprVar *v, const char *name, enum srvsvc_ShareType *r)
{
	unsigned e;
	NDR_CHECK(ejs_pull_enum(ejs, v, name, &e));
	*r = e;
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetShareInfo0(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetShareInfo0 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->name) {
		NDR_CHECK(ejs_push_null(ejs, v, "name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "name", r->name));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetShareInfo0(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetShareInfo0 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "name")) {
		r->name = NULL;
	} else {
		EJS_ALLOC(ejs, r->name);
		NDR_CHECK(ejs_pull_string(ejs, v, "name", &r->name));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetShareInfo1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetShareInfo1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->name) {
		NDR_CHECK(ejs_push_null(ejs, v, "name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "name", r->name));
	}
	NDR_CHECK(ejs_push_srvsvc_ShareType(ejs, v, "type", &r->type));
	if (NULL == r->comment) {
		NDR_CHECK(ejs_push_null(ejs, v, "comment"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "comment", r->comment));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetShareInfo1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetShareInfo1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "name")) {
		r->name = NULL;
	} else {
		EJS_ALLOC(ejs, r->name);
		NDR_CHECK(ejs_pull_string(ejs, v, "name", &r->name));
	}
	NDR_CHECK(ejs_pull_srvsvc_ShareType(ejs, v, "type", &r->type));
	if (ejs_pull_null(ejs, v, "comment")) {
		r->comment = NULL;
	} else {
		EJS_ALLOC(ejs, r->comment);
		NDR_CHECK(ejs_pull_string(ejs, v, "comment", &r->comment));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetShareInfo2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetShareInfo2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->name) {
		NDR_CHECK(ejs_push_null(ejs, v, "name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "name", r->name));
	}
	NDR_CHECK(ejs_push_srvsvc_ShareType(ejs, v, "type", &r->type));
	if (NULL == r->comment) {
		NDR_CHECK(ejs_push_null(ejs, v, "comment"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "comment", r->comment));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "permissions", &r->permissions));
	NDR_CHECK(ejs_push_uint32(ejs, v, "max_users", &r->max_users));
	NDR_CHECK(ejs_push_uint32(ejs, v, "current_users", &r->current_users));
	if (NULL == r->path) {
		NDR_CHECK(ejs_push_null(ejs, v, "path"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "path", r->path));
	}
	if (NULL == r->password) {
		NDR_CHECK(ejs_push_null(ejs, v, "password"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "password", r->password));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetShareInfo2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetShareInfo2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "name")) {
		r->name = NULL;
	} else {
		EJS_ALLOC(ejs, r->name);
		NDR_CHECK(ejs_pull_string(ejs, v, "name", &r->name));
	}
	NDR_CHECK(ejs_pull_srvsvc_ShareType(ejs, v, "type", &r->type));
	if (ejs_pull_null(ejs, v, "comment")) {
		r->comment = NULL;
	} else {
		EJS_ALLOC(ejs, r->comment);
		NDR_CHECK(ejs_pull_string(ejs, v, "comment", &r->comment));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "permissions", &r->permissions));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "max_users", &r->max_users));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "current_users", &r->current_users));
	if (ejs_pull_null(ejs, v, "path")) {
		r->path = NULL;
	} else {
		EJS_ALLOC(ejs, r->path);
		NDR_CHECK(ejs_pull_string(ejs, v, "path", &r->path));
	}
	if (ejs_pull_null(ejs, v, "password")) {
		r->password = NULL;
	} else {
		EJS_ALLOC(ejs, r->password);
		NDR_CHECK(ejs_pull_string(ejs, v, "password", &r->password));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetShareInfo501(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetShareInfo501 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->name) {
		NDR_CHECK(ejs_push_null(ejs, v, "name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "name", r->name));
	}
	NDR_CHECK(ejs_push_srvsvc_ShareType(ejs, v, "type", &r->type));
	if (NULL == r->comment) {
		NDR_CHECK(ejs_push_null(ejs, v, "comment"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "comment", r->comment));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "csc_policy", &r->csc_policy));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetShareInfo501(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetShareInfo501 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "name")) {
		r->name = NULL;
	} else {
		EJS_ALLOC(ejs, r->name);
		NDR_CHECK(ejs_pull_string(ejs, v, "name", &r->name));
	}
	NDR_CHECK(ejs_pull_srvsvc_ShareType(ejs, v, "type", &r->type));
	if (ejs_pull_null(ejs, v, "comment")) {
		r->comment = NULL;
	} else {
		EJS_ALLOC(ejs, r->comment);
		NDR_CHECK(ejs_pull_string(ejs, v, "comment", &r->comment));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "csc_policy", &r->csc_policy));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetShareInfo502(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetShareInfo502 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->name) {
		NDR_CHECK(ejs_push_null(ejs, v, "name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "name", r->name));
	}
	NDR_CHECK(ejs_push_srvsvc_ShareType(ejs, v, "type", &r->type));
	if (NULL == r->comment) {
		NDR_CHECK(ejs_push_null(ejs, v, "comment"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "comment", r->comment));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "permissions", &r->permissions));
	NDR_CHECK(ejs_push_int32(ejs, v, "max_users", &r->max_users));
	NDR_CHECK(ejs_push_uint32(ejs, v, "current_users", &r->current_users));
	if (NULL == r->path) {
		NDR_CHECK(ejs_push_null(ejs, v, "path"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "path", r->path));
	}
	if (NULL == r->password) {
		NDR_CHECK(ejs_push_null(ejs, v, "password"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "password", r->password));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown", &r->unknown));
	if (NULL == r->sd) {
		NDR_CHECK(ejs_push_null(ejs, v, "sd"));
	} else {
		return ejs_panic(ejs, "unhandled push type SUBCONTEXT");
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetShareInfo502(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetShareInfo502 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "name")) {
		r->name = NULL;
	} else {
		EJS_ALLOC(ejs, r->name);
		NDR_CHECK(ejs_pull_string(ejs, v, "name", &r->name));
	}
	NDR_CHECK(ejs_pull_srvsvc_ShareType(ejs, v, "type", &r->type));
	if (ejs_pull_null(ejs, v, "comment")) {
		r->comment = NULL;
	} else {
		EJS_ALLOC(ejs, r->comment);
		NDR_CHECK(ejs_pull_string(ejs, v, "comment", &r->comment));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "permissions", &r->permissions));
	NDR_CHECK(ejs_pull_int32(ejs, v, "max_users", &r->max_users));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "current_users", &r->current_users));
	if (ejs_pull_null(ejs, v, "path")) {
		r->path = NULL;
	} else {
		EJS_ALLOC(ejs, r->path);
		NDR_CHECK(ejs_pull_string(ejs, v, "path", &r->path));
	}
	if (ejs_pull_null(ejs, v, "password")) {
		r->password = NULL;
	} else {
		EJS_ALLOC(ejs, r->password);
		NDR_CHECK(ejs_pull_string(ejs, v, "password", &r->password));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown", &r->unknown));
	if (ejs_pull_null(ejs, v, "sd")) {
		r->sd = NULL;
	} else {
		EJS_ALLOC(ejs, r->sd);
		return ejs_panic(ejs, "unhandled pull type SUBCONTEXT");
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetShareInfo1004(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetShareInfo1004 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->comment) {
		NDR_CHECK(ejs_push_null(ejs, v, "comment"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "comment", r->comment));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetShareInfo1004(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetShareInfo1004 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "comment")) {
		r->comment = NULL;
	} else {
		EJS_ALLOC(ejs, r->comment);
		NDR_CHECK(ejs_pull_string(ejs, v, "comment", &r->comment));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetShareInfo1006(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetShareInfo1006 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_int32(ejs, v, "max_users", &r->max_users));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetShareInfo1006(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetShareInfo1006 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_int32(ejs, v, "max_users", &r->max_users));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_NetShareInfo1005Flags(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const uint32_t *r)
{
	return ejs_push_uint32(ejs, v, name, r);
}
static NTSTATUS ejs_pull_NetShareInfo1005Flags(struct ejs_rpc *ejs, struct MprVar *v, const char *name, uint32_t *r)
{
	return ejs_pull_uint32(ejs, v, name, r);
}
static NTSTATUS ejs_push_srvsvc_NetShareInfo1005(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetShareInfo1005 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_NetShareInfo1005Flags(ejs, v, "dfs_flags", &r->dfs_flags));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetShareInfo1005(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetShareInfo1005 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_NetShareInfo1005Flags(ejs, v, "dfs_flags", &r->dfs_flags));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetShareInfo1007(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetShareInfo1007 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "flags", &r->flags));
	if (NULL == r->alternate_directory_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "alternate_directory_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "alternate_directory_name", r->alternate_directory_name));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetShareInfo1007(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetShareInfo1007 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "flags", &r->flags));
	if (ejs_pull_null(ejs, v, "alternate_directory_name")) {
		r->alternate_directory_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->alternate_directory_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "alternate_directory_name", &r->alternate_directory_name));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetShareInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union srvsvc_NetShareInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 0:
			if (NULL == r->info0) {
				NDR_CHECK(ejs_push_null(ejs, v, "info0"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetShareInfo0(ejs, v, "info0", r->info0));
			}
			break;
		case 1:
			if (NULL == r->info1) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetShareInfo1(ejs, v, "info1", r->info1));
			}
			break;
		case 2:
			if (NULL == r->info2) {
				NDR_CHECK(ejs_push_null(ejs, v, "info2"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetShareInfo2(ejs, v, "info2", r->info2));
			}
			break;
		case 501:
			if (NULL == r->info501) {
				NDR_CHECK(ejs_push_null(ejs, v, "info501"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetShareInfo501(ejs, v, "info501", r->info501));
			}
			break;
		case 502:
			if (NULL == r->info502) {
				NDR_CHECK(ejs_push_null(ejs, v, "info502"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetShareInfo502(ejs, v, "info502", r->info502));
			}
			break;
		case 1004:
			if (NULL == r->info1004) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1004"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetShareInfo1004(ejs, v, "info1004", r->info1004));
			}
			break;
		case 1005:
			if (NULL == r->info1005) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1005"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetShareInfo1005(ejs, v, "info1005", r->info1005));
			}
			break;
		case 1006:
			if (NULL == r->info1006) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1006"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetShareInfo1006(ejs, v, "info1006", r->info1006));
			}
			break;
		case 1007:
			if (NULL == r->info1007) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1007"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetShareInfo1007(ejs, v, "info1007", r->info1007));
			}
			break;
		case 1501:
			if (NULL == r->info1501) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1501"));
			} else {
				NDR_CHECK(ejs_push_sec_desc_buf(ejs, v, "info1501", r->info1501));
			}
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_srvsvc_NetShareInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union srvsvc_NetShareInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 0:
			if (ejs_pull_null(ejs, v, "info0")) {
				r->info0 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info0);
				NDR_CHECK(ejs_pull_srvsvc_NetShareInfo0(ejs, v, "info0", r->info0));
			}
			break;
		case 1:
			if (ejs_pull_null(ejs, v, "info1")) {
				r->info1 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1);
				NDR_CHECK(ejs_pull_srvsvc_NetShareInfo1(ejs, v, "info1", r->info1));
			}
			break;
		case 2:
			if (ejs_pull_null(ejs, v, "info2")) {
				r->info2 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info2);
				NDR_CHECK(ejs_pull_srvsvc_NetShareInfo2(ejs, v, "info2", r->info2));
			}
			break;
		case 501:
			if (ejs_pull_null(ejs, v, "info501")) {
				r->info501 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info501);
				NDR_CHECK(ejs_pull_srvsvc_NetShareInfo501(ejs, v, "info501", r->info501));
			}
			break;
		case 502:
			if (ejs_pull_null(ejs, v, "info502")) {
				r->info502 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info502);
				NDR_CHECK(ejs_pull_srvsvc_NetShareInfo502(ejs, v, "info502", r->info502));
			}
			break;
		case 1004:
			if (ejs_pull_null(ejs, v, "info1004")) {
				r->info1004 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1004);
				NDR_CHECK(ejs_pull_srvsvc_NetShareInfo1004(ejs, v, "info1004", r->info1004));
			}
			break;
		case 1005:
			if (ejs_pull_null(ejs, v, "info1005")) {
				r->info1005 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1005);
				NDR_CHECK(ejs_pull_srvsvc_NetShareInfo1005(ejs, v, "info1005", r->info1005));
			}
			break;
		case 1006:
			if (ejs_pull_null(ejs, v, "info1006")) {
				r->info1006 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1006);
				NDR_CHECK(ejs_pull_srvsvc_NetShareInfo1006(ejs, v, "info1006", r->info1006));
			}
			break;
		case 1007:
			if (ejs_pull_null(ejs, v, "info1007")) {
				r->info1007 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1007);
				NDR_CHECK(ejs_pull_srvsvc_NetShareInfo1007(ejs, v, "info1007", r->info1007));
			}
			break;
		case 1501:
			if (ejs_pull_null(ejs, v, "info1501")) {
				r->info1501 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1501);
				NDR_CHECK(ejs_pull_sec_desc_buf(ejs, v, "info1501", r->info1501));
			}
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_srvsvc_NetShareCtr0(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetShareCtr0 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->array) {
		NDR_CHECK(ejs_push_null(ejs, v, "array"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_push_srvsvc_NetShareInfo0(ejs, v, id, &r->array[i]));
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetShareCtr0(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetShareCtr0 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	if (ejs_pull_null(ejs, v, "array")) {
		r->array = NULL;
	} else {
		EJS_ALLOC(ejs, r->array);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->array, r->count);
			for (i=0;i<r->count;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_pull_srvsvc_NetShareInfo0(ejs, v, id, &r->array[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetShareCtr1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetShareCtr1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->array) {
		NDR_CHECK(ejs_push_null(ejs, v, "array"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_push_srvsvc_NetShareInfo1(ejs, v, id, &r->array[i]));
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetShareCtr1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetShareCtr1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	if (ejs_pull_null(ejs, v, "array")) {
		r->array = NULL;
	} else {
		EJS_ALLOC(ejs, r->array);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->array, r->count);
			for (i=0;i<r->count;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_pull_srvsvc_NetShareInfo1(ejs, v, id, &r->array[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetShareCtr2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetShareCtr2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->array) {
		NDR_CHECK(ejs_push_null(ejs, v, "array"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_push_srvsvc_NetShareInfo2(ejs, v, id, &r->array[i]));
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetShareCtr2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetShareCtr2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	if (ejs_pull_null(ejs, v, "array")) {
		r->array = NULL;
	} else {
		EJS_ALLOC(ejs, r->array);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->array, r->count);
			for (i=0;i<r->count;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_pull_srvsvc_NetShareInfo2(ejs, v, id, &r->array[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetShareCtr501(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetShareCtr501 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->array) {
		NDR_CHECK(ejs_push_null(ejs, v, "array"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_push_srvsvc_NetShareInfo501(ejs, v, id, &r->array[i]));
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetShareCtr501(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetShareCtr501 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	if (ejs_pull_null(ejs, v, "array")) {
		r->array = NULL;
	} else {
		EJS_ALLOC(ejs, r->array);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->array, r->count);
			for (i=0;i<r->count;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_pull_srvsvc_NetShareInfo501(ejs, v, id, &r->array[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetShareCtr502(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetShareCtr502 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->array) {
		NDR_CHECK(ejs_push_null(ejs, v, "array"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_push_srvsvc_NetShareInfo502(ejs, v, id, &r->array[i]));
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetShareCtr502(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetShareCtr502 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	if (ejs_pull_null(ejs, v, "array")) {
		r->array = NULL;
	} else {
		EJS_ALLOC(ejs, r->array);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->array, r->count);
			for (i=0;i<r->count;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_pull_srvsvc_NetShareInfo502(ejs, v, id, &r->array[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetShareCtr1004(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetShareCtr1004 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->array) {
		NDR_CHECK(ejs_push_null(ejs, v, "array"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_push_srvsvc_NetShareInfo1004(ejs, v, id, &r->array[i]));
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetShareCtr1004(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetShareCtr1004 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	if (ejs_pull_null(ejs, v, "array")) {
		r->array = NULL;
	} else {
		EJS_ALLOC(ejs, r->array);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->array, r->count);
			for (i=0;i<r->count;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_pull_srvsvc_NetShareInfo1004(ejs, v, id, &r->array[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetShareCtr1005(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetShareCtr1005 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->array) {
		NDR_CHECK(ejs_push_null(ejs, v, "array"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_push_srvsvc_NetShareInfo1005(ejs, v, id, &r->array[i]));
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetShareCtr1005(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetShareCtr1005 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	if (ejs_pull_null(ejs, v, "array")) {
		r->array = NULL;
	} else {
		EJS_ALLOC(ejs, r->array);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->array, r->count);
			for (i=0;i<r->count;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_pull_srvsvc_NetShareInfo1005(ejs, v, id, &r->array[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetShareCtr1006(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetShareCtr1006 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->array) {
		NDR_CHECK(ejs_push_null(ejs, v, "array"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_push_srvsvc_NetShareInfo1006(ejs, v, id, &r->array[i]));
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetShareCtr1006(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetShareCtr1006 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	if (ejs_pull_null(ejs, v, "array")) {
		r->array = NULL;
	} else {
		EJS_ALLOC(ejs, r->array);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->array, r->count);
			for (i=0;i<r->count;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_pull_srvsvc_NetShareInfo1006(ejs, v, id, &r->array[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetShareCtr1007(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetShareCtr1007 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->array) {
		NDR_CHECK(ejs_push_null(ejs, v, "array"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_push_srvsvc_NetShareInfo1007(ejs, v, id, &r->array[i]));
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetShareCtr1007(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetShareCtr1007 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	if (ejs_pull_null(ejs, v, "array")) {
		r->array = NULL;
	} else {
		EJS_ALLOC(ejs, r->array);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->array, r->count);
			for (i=0;i<r->count;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_pull_srvsvc_NetShareInfo1007(ejs, v, id, &r->array[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetShareCtr1501(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetShareCtr1501 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->array) {
		NDR_CHECK(ejs_push_null(ejs, v, "array"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_push_sec_desc_buf(ejs, v, id, &r->array[i]));
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetShareCtr1501(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetShareCtr1501 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	if (ejs_pull_null(ejs, v, "array")) {
		r->array = NULL;
	} else {
		EJS_ALLOC(ejs, r->array);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->array, r->count);
			for (i=0;i<r->count;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_pull_sec_desc_buf(ejs, v, id, &r->array[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetShareCtr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union srvsvc_NetShareCtr *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 0:
			if (NULL == r->ctr0) {
				NDR_CHECK(ejs_push_null(ejs, v, "ctr0"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetShareCtr0(ejs, v, "ctr0", r->ctr0));
			}
			break;
		case 1:
			if (NULL == r->ctr1) {
				NDR_CHECK(ejs_push_null(ejs, v, "ctr1"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetShareCtr1(ejs, v, "ctr1", r->ctr1));
			}
			break;
		case 2:
			if (NULL == r->ctr2) {
				NDR_CHECK(ejs_push_null(ejs, v, "ctr2"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetShareCtr2(ejs, v, "ctr2", r->ctr2));
			}
			break;
		case 501:
			if (NULL == r->ctr501) {
				NDR_CHECK(ejs_push_null(ejs, v, "ctr501"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetShareCtr501(ejs, v, "ctr501", r->ctr501));
			}
			break;
		case 502:
			if (NULL == r->ctr502) {
				NDR_CHECK(ejs_push_null(ejs, v, "ctr502"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetShareCtr502(ejs, v, "ctr502", r->ctr502));
			}
			break;
		case 1004:
			if (NULL == r->ctr1004) {
				NDR_CHECK(ejs_push_null(ejs, v, "ctr1004"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetShareCtr1004(ejs, v, "ctr1004", r->ctr1004));
			}
			break;
		case 1005:
			if (NULL == r->ctr1005) {
				NDR_CHECK(ejs_push_null(ejs, v, "ctr1005"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetShareCtr1005(ejs, v, "ctr1005", r->ctr1005));
			}
			break;
		case 1006:
			if (NULL == r->ctr1006) {
				NDR_CHECK(ejs_push_null(ejs, v, "ctr1006"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetShareCtr1006(ejs, v, "ctr1006", r->ctr1006));
			}
			break;
		case 1007:
			if (NULL == r->ctr1007) {
				NDR_CHECK(ejs_push_null(ejs, v, "ctr1007"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetShareCtr1007(ejs, v, "ctr1007", r->ctr1007));
			}
			break;
		case 1501:
			if (NULL == r->ctr1501) {
				NDR_CHECK(ejs_push_null(ejs, v, "ctr1501"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetShareCtr1501(ejs, v, "ctr1501", r->ctr1501));
			}
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_srvsvc_NetShareCtr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union srvsvc_NetShareCtr *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 0:
			if (ejs_pull_null(ejs, v, "ctr0")) {
				r->ctr0 = NULL;
			} else {
				EJS_ALLOC(ejs, r->ctr0);
				NDR_CHECK(ejs_pull_srvsvc_NetShareCtr0(ejs, v, "ctr0", r->ctr0));
			}
			break;
		case 1:
			if (ejs_pull_null(ejs, v, "ctr1")) {
				r->ctr1 = NULL;
			} else {
				EJS_ALLOC(ejs, r->ctr1);
				NDR_CHECK(ejs_pull_srvsvc_NetShareCtr1(ejs, v, "ctr1", r->ctr1));
			}
			break;
		case 2:
			if (ejs_pull_null(ejs, v, "ctr2")) {
				r->ctr2 = NULL;
			} else {
				EJS_ALLOC(ejs, r->ctr2);
				NDR_CHECK(ejs_pull_srvsvc_NetShareCtr2(ejs, v, "ctr2", r->ctr2));
			}
			break;
		case 501:
			if (ejs_pull_null(ejs, v, "ctr501")) {
				r->ctr501 = NULL;
			} else {
				EJS_ALLOC(ejs, r->ctr501);
				NDR_CHECK(ejs_pull_srvsvc_NetShareCtr501(ejs, v, "ctr501", r->ctr501));
			}
			break;
		case 502:
			if (ejs_pull_null(ejs, v, "ctr502")) {
				r->ctr502 = NULL;
			} else {
				EJS_ALLOC(ejs, r->ctr502);
				NDR_CHECK(ejs_pull_srvsvc_NetShareCtr502(ejs, v, "ctr502", r->ctr502));
			}
			break;
		case 1004:
			if (ejs_pull_null(ejs, v, "ctr1004")) {
				r->ctr1004 = NULL;
			} else {
				EJS_ALLOC(ejs, r->ctr1004);
				NDR_CHECK(ejs_pull_srvsvc_NetShareCtr1004(ejs, v, "ctr1004", r->ctr1004));
			}
			break;
		case 1005:
			if (ejs_pull_null(ejs, v, "ctr1005")) {
				r->ctr1005 = NULL;
			} else {
				EJS_ALLOC(ejs, r->ctr1005);
				NDR_CHECK(ejs_pull_srvsvc_NetShareCtr1005(ejs, v, "ctr1005", r->ctr1005));
			}
			break;
		case 1006:
			if (ejs_pull_null(ejs, v, "ctr1006")) {
				r->ctr1006 = NULL;
			} else {
				EJS_ALLOC(ejs, r->ctr1006);
				NDR_CHECK(ejs_pull_srvsvc_NetShareCtr1006(ejs, v, "ctr1006", r->ctr1006));
			}
			break;
		case 1007:
			if (ejs_pull_null(ejs, v, "ctr1007")) {
				r->ctr1007 = NULL;
			} else {
				EJS_ALLOC(ejs, r->ctr1007);
				NDR_CHECK(ejs_pull_srvsvc_NetShareCtr1007(ejs, v, "ctr1007", r->ctr1007));
			}
			break;
		case 1501:
			if (ejs_pull_null(ejs, v, "ctr1501")) {
				r->ctr1501 = NULL;
			} else {
				EJS_ALLOC(ejs, r->ctr1501);
				NDR_CHECK(ejs_pull_srvsvc_NetShareCtr1501(ejs, v, "ctr1501", r->ctr1501));
			}
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
_PUBLIC_ NTSTATUS ejs_push_srvsvc_PlatformId(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const enum srvsvc_PlatformId *r)
{
	unsigned e = *r;
	NDR_CHECK(ejs_push_enum(ejs, v, name, &e));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_srvsvc_PlatformId(struct ejs_rpc *ejs, struct MprVar *v, const char *name, enum srvsvc_PlatformId *r)
{
	unsigned e;
	NDR_CHECK(ejs_pull_enum(ejs, v, name, &e));
	*r = e;
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo100(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo100 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_srvsvc_PlatformId(ejs, v, "platform_id", &r->platform_id));
	if (NULL == r->server_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "server_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "server_name", r->server_name));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo100(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo100 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_srvsvc_PlatformId(ejs, v, "platform_id", &r->platform_id));
	if (ejs_pull_null(ejs, v, "server_name")) {
		r->server_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->server_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_name", &r->server_name));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo101(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo101 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_srvsvc_PlatformId(ejs, v, "platform_id", &r->platform_id));
	if (NULL == r->server_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "server_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "server_name", r->server_name));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "version_major", &r->version_major));
	NDR_CHECK(ejs_push_uint32(ejs, v, "version_minor", &r->version_minor));
	NDR_CHECK(ejs_push_svcctl_ServerType(ejs, v, "server_type", &r->server_type));
	if (NULL == r->comment) {
		NDR_CHECK(ejs_push_null(ejs, v, "comment"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "comment", r->comment));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo101(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo101 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_srvsvc_PlatformId(ejs, v, "platform_id", &r->platform_id));
	if (ejs_pull_null(ejs, v, "server_name")) {
		r->server_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->server_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_name", &r->server_name));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "version_major", &r->version_major));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "version_minor", &r->version_minor));
	NDR_CHECK(ejs_pull_svcctl_ServerType(ejs, v, "server_type", &r->server_type));
	if (ejs_pull_null(ejs, v, "comment")) {
		r->comment = NULL;
	} else {
		EJS_ALLOC(ejs, r->comment);
		NDR_CHECK(ejs_pull_string(ejs, v, "comment", &r->comment));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo102(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo102 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_srvsvc_PlatformId(ejs, v, "platform_id", &r->platform_id));
	if (NULL == r->server_name) {
		NDR_CHECK(ejs_push_null(ejs, v, "server_name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "server_name", r->server_name));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "version_major", &r->version_major));
	NDR_CHECK(ejs_push_uint32(ejs, v, "version_minor", &r->version_minor));
	NDR_CHECK(ejs_push_svcctl_ServerType(ejs, v, "server_type", &r->server_type));
	if (NULL == r->comment) {
		NDR_CHECK(ejs_push_null(ejs, v, "comment"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "comment", r->comment));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "users", &r->users));
	NDR_CHECK(ejs_push_uint32(ejs, v, "disc", &r->disc));
	NDR_CHECK(ejs_push_uint32(ejs, v, "hidden", &r->hidden));
	NDR_CHECK(ejs_push_uint32(ejs, v, "announce", &r->announce));
	NDR_CHECK(ejs_push_uint32(ejs, v, "anndelta", &r->anndelta));
	NDR_CHECK(ejs_push_uint32(ejs, v, "licenses", &r->licenses));
	if (NULL == r->userpath) {
		NDR_CHECK(ejs_push_null(ejs, v, "userpath"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "userpath", r->userpath));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo102(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo102 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_srvsvc_PlatformId(ejs, v, "platform_id", &r->platform_id));
	if (ejs_pull_null(ejs, v, "server_name")) {
		r->server_name = NULL;
	} else {
		EJS_ALLOC(ejs, r->server_name);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_name", &r->server_name));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "version_major", &r->version_major));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "version_minor", &r->version_minor));
	NDR_CHECK(ejs_pull_svcctl_ServerType(ejs, v, "server_type", &r->server_type));
	if (ejs_pull_null(ejs, v, "comment")) {
		r->comment = NULL;
	} else {
		EJS_ALLOC(ejs, r->comment);
		NDR_CHECK(ejs_pull_string(ejs, v, "comment", &r->comment));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "users", &r->users));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "disc", &r->disc));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "hidden", &r->hidden));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "announce", &r->announce));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "anndelta", &r->anndelta));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "licenses", &r->licenses));
	if (ejs_pull_null(ejs, v, "userpath")) {
		r->userpath = NULL;
	} else {
		EJS_ALLOC(ejs, r->userpath);
		NDR_CHECK(ejs_pull_string(ejs, v, "userpath", &r->userpath));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo402(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo402 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "ulist_mtime", &r->ulist_mtime));
	NDR_CHECK(ejs_push_uint32(ejs, v, "glist_mtime", &r->glist_mtime));
	NDR_CHECK(ejs_push_uint32(ejs, v, "alist_mtime", &r->alist_mtime));
	if (NULL == r->alerts) {
		NDR_CHECK(ejs_push_null(ejs, v, "alerts"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "alerts", r->alerts));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "security", &r->security));
	NDR_CHECK(ejs_push_uint32(ejs, v, "numadmin", &r->numadmin));
	NDR_CHECK(ejs_push_uint32(ejs, v, "lanmask", &r->lanmask));
	if (NULL == r->guestaccount) {
		NDR_CHECK(ejs_push_null(ejs, v, "guestaccount"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "guestaccount", r->guestaccount));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "chdevs", &r->chdevs));
	NDR_CHECK(ejs_push_uint32(ejs, v, "chdevqs", &r->chdevqs));
	NDR_CHECK(ejs_push_uint32(ejs, v, "chdevjobs", &r->chdevjobs));
	NDR_CHECK(ejs_push_uint32(ejs, v, "connections", &r->connections));
	NDR_CHECK(ejs_push_uint32(ejs, v, "shares", &r->shares));
	NDR_CHECK(ejs_push_uint32(ejs, v, "openfiles", &r->openfiles));
	NDR_CHECK(ejs_push_uint32(ejs, v, "sessopen", &r->sessopen));
	NDR_CHECK(ejs_push_uint32(ejs, v, "sesssvc", &r->sesssvc));
	NDR_CHECK(ejs_push_uint32(ejs, v, "sessreqs", &r->sessreqs));
	NDR_CHECK(ejs_push_uint32(ejs, v, "opensearch", &r->opensearch));
	NDR_CHECK(ejs_push_uint32(ejs, v, "activelocks", &r->activelocks));
	NDR_CHECK(ejs_push_uint32(ejs, v, "sizereqbufs", &r->sizereqbufs));
	NDR_CHECK(ejs_push_uint32(ejs, v, "numbigbufs", &r->numbigbufs));
	NDR_CHECK(ejs_push_uint32(ejs, v, "numfiletasks", &r->numfiletasks));
	NDR_CHECK(ejs_push_uint32(ejs, v, "alertsched", &r->alertsched));
	NDR_CHECK(ejs_push_uint32(ejs, v, "erroralert", &r->erroralert));
	NDR_CHECK(ejs_push_uint32(ejs, v, "logonalert", &r->logonalert));
	NDR_CHECK(ejs_push_uint32(ejs, v, "accessalert", &r->accessalert));
	NDR_CHECK(ejs_push_uint32(ejs, v, "diskalert", &r->diskalert));
	NDR_CHECK(ejs_push_uint32(ejs, v, "netioalert", &r->netioalert));
	NDR_CHECK(ejs_push_uint32(ejs, v, "maxaudits", &r->maxaudits));
	if (NULL == r->srvheuristics) {
		NDR_CHECK(ejs_push_null(ejs, v, "srvheuristics"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "srvheuristics", r->srvheuristics));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo402(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo402 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "ulist_mtime", &r->ulist_mtime));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "glist_mtime", &r->glist_mtime));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "alist_mtime", &r->alist_mtime));
	if (ejs_pull_null(ejs, v, "alerts")) {
		r->alerts = NULL;
	} else {
		EJS_ALLOC(ejs, r->alerts);
		NDR_CHECK(ejs_pull_string(ejs, v, "alerts", &r->alerts));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "security", &r->security));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "numadmin", &r->numadmin));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "lanmask", &r->lanmask));
	if (ejs_pull_null(ejs, v, "guestaccount")) {
		r->guestaccount = NULL;
	} else {
		EJS_ALLOC(ejs, r->guestaccount);
		NDR_CHECK(ejs_pull_string(ejs, v, "guestaccount", &r->guestaccount));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "chdevs", &r->chdevs));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "chdevqs", &r->chdevqs));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "chdevjobs", &r->chdevjobs));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "connections", &r->connections));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "shares", &r->shares));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "openfiles", &r->openfiles));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "sessopen", &r->sessopen));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "sesssvc", &r->sesssvc));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "sessreqs", &r->sessreqs));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "opensearch", &r->opensearch));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "activelocks", &r->activelocks));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "sizereqbufs", &r->sizereqbufs));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "numbigbufs", &r->numbigbufs));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "numfiletasks", &r->numfiletasks));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "alertsched", &r->alertsched));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "erroralert", &r->erroralert));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "logonalert", &r->logonalert));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "accessalert", &r->accessalert));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "diskalert", &r->diskalert));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "netioalert", &r->netioalert));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "maxaudits", &r->maxaudits));
	if (ejs_pull_null(ejs, v, "srvheuristics")) {
		r->srvheuristics = NULL;
	} else {
		EJS_ALLOC(ejs, r->srvheuristics);
		NDR_CHECK(ejs_pull_string(ejs, v, "srvheuristics", &r->srvheuristics));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo403(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo403 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "ulist_mtime", &r->ulist_mtime));
	NDR_CHECK(ejs_push_uint32(ejs, v, "glist_mtime", &r->glist_mtime));
	NDR_CHECK(ejs_push_uint32(ejs, v, "alist_mtime", &r->alist_mtime));
	if (NULL == r->alerts) {
		NDR_CHECK(ejs_push_null(ejs, v, "alerts"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "alerts", r->alerts));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "security", &r->security));
	NDR_CHECK(ejs_push_uint32(ejs, v, "numadmin", &r->numadmin));
	NDR_CHECK(ejs_push_uint32(ejs, v, "lanmask", &r->lanmask));
	if (NULL == r->guestaccount) {
		NDR_CHECK(ejs_push_null(ejs, v, "guestaccount"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "guestaccount", r->guestaccount));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "chdevs", &r->chdevs));
	NDR_CHECK(ejs_push_uint32(ejs, v, "chdevqs", &r->chdevqs));
	NDR_CHECK(ejs_push_uint32(ejs, v, "chdevjobs", &r->chdevjobs));
	NDR_CHECK(ejs_push_uint32(ejs, v, "connections", &r->connections));
	NDR_CHECK(ejs_push_uint32(ejs, v, "shares", &r->shares));
	NDR_CHECK(ejs_push_uint32(ejs, v, "openfiles", &r->openfiles));
	NDR_CHECK(ejs_push_uint32(ejs, v, "sessopen", &r->sessopen));
	NDR_CHECK(ejs_push_uint32(ejs, v, "sesssvc", &r->sesssvc));
	NDR_CHECK(ejs_push_uint32(ejs, v, "sessreqs", &r->sessreqs));
	NDR_CHECK(ejs_push_uint32(ejs, v, "opensearch", &r->opensearch));
	NDR_CHECK(ejs_push_uint32(ejs, v, "activelocks", &r->activelocks));
	NDR_CHECK(ejs_push_uint32(ejs, v, "sizereqbufs", &r->sizereqbufs));
	NDR_CHECK(ejs_push_uint32(ejs, v, "numbigbufs", &r->numbigbufs));
	NDR_CHECK(ejs_push_uint32(ejs, v, "numfiletasks", &r->numfiletasks));
	NDR_CHECK(ejs_push_uint32(ejs, v, "alertsched", &r->alertsched));
	NDR_CHECK(ejs_push_uint32(ejs, v, "eroralert", &r->eroralert));
	NDR_CHECK(ejs_push_uint32(ejs, v, "logonalert", &r->logonalert));
	NDR_CHECK(ejs_push_uint32(ejs, v, "accessalert", &r->accessalert));
	NDR_CHECK(ejs_push_uint32(ejs, v, "diskalert", &r->diskalert));
	NDR_CHECK(ejs_push_uint32(ejs, v, "netioalert", &r->netioalert));
	NDR_CHECK(ejs_push_uint32(ejs, v, "maxaudits", &r->maxaudits));
	if (NULL == r->srvheuristics) {
		NDR_CHECK(ejs_push_null(ejs, v, "srvheuristics"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "srvheuristics", r->srvheuristics));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "auditedevents", &r->auditedevents));
	NDR_CHECK(ejs_push_uint32(ejs, v, "auditprofile", &r->auditprofile));
	if (NULL == r->autopath) {
		NDR_CHECK(ejs_push_null(ejs, v, "autopath"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "autopath", r->autopath));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo403(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo403 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "ulist_mtime", &r->ulist_mtime));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "glist_mtime", &r->glist_mtime));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "alist_mtime", &r->alist_mtime));
	if (ejs_pull_null(ejs, v, "alerts")) {
		r->alerts = NULL;
	} else {
		EJS_ALLOC(ejs, r->alerts);
		NDR_CHECK(ejs_pull_string(ejs, v, "alerts", &r->alerts));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "security", &r->security));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "numadmin", &r->numadmin));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "lanmask", &r->lanmask));
	if (ejs_pull_null(ejs, v, "guestaccount")) {
		r->guestaccount = NULL;
	} else {
		EJS_ALLOC(ejs, r->guestaccount);
		NDR_CHECK(ejs_pull_string(ejs, v, "guestaccount", &r->guestaccount));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "chdevs", &r->chdevs));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "chdevqs", &r->chdevqs));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "chdevjobs", &r->chdevjobs));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "connections", &r->connections));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "shares", &r->shares));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "openfiles", &r->openfiles));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "sessopen", &r->sessopen));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "sesssvc", &r->sesssvc));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "sessreqs", &r->sessreqs));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "opensearch", &r->opensearch));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "activelocks", &r->activelocks));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "sizereqbufs", &r->sizereqbufs));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "numbigbufs", &r->numbigbufs));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "numfiletasks", &r->numfiletasks));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "alertsched", &r->alertsched));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "eroralert", &r->eroralert));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "logonalert", &r->logonalert));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "accessalert", &r->accessalert));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "diskalert", &r->diskalert));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "netioalert", &r->netioalert));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "maxaudits", &r->maxaudits));
	if (ejs_pull_null(ejs, v, "srvheuristics")) {
		r->srvheuristics = NULL;
	} else {
		EJS_ALLOC(ejs, r->srvheuristics);
		NDR_CHECK(ejs_pull_string(ejs, v, "srvheuristics", &r->srvheuristics));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "auditedevents", &r->auditedevents));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "auditprofile", &r->auditprofile));
	if (ejs_pull_null(ejs, v, "autopath")) {
		r->autopath = NULL;
	} else {
		EJS_ALLOC(ejs, r->autopath);
		NDR_CHECK(ejs_pull_string(ejs, v, "autopath", &r->autopath));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo502(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo502 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "sessopen", &r->sessopen));
	NDR_CHECK(ejs_push_uint32(ejs, v, "sesssvc", &r->sesssvc));
	NDR_CHECK(ejs_push_uint32(ejs, v, "opensearch", &r->opensearch));
	NDR_CHECK(ejs_push_uint32(ejs, v, "sizereqbufs", &r->sizereqbufs));
	NDR_CHECK(ejs_push_uint32(ejs, v, "initworkitems", &r->initworkitems));
	NDR_CHECK(ejs_push_uint32(ejs, v, "maxworkitems", &r->maxworkitems));
	NDR_CHECK(ejs_push_uint32(ejs, v, "rawworkitems", &r->rawworkitems));
	NDR_CHECK(ejs_push_uint32(ejs, v, "irpstacksize", &r->irpstacksize));
	NDR_CHECK(ejs_push_uint32(ejs, v, "maxrawbuflen", &r->maxrawbuflen));
	NDR_CHECK(ejs_push_uint32(ejs, v, "sessusers", &r->sessusers));
	NDR_CHECK(ejs_push_uint32(ejs, v, "sessconns", &r->sessconns));
	NDR_CHECK(ejs_push_uint32(ejs, v, "maxpagedmemoryusage", &r->maxpagedmemoryusage));
	NDR_CHECK(ejs_push_uint32(ejs, v, "maxnonpagedmemoryusage", &r->maxnonpagedmemoryusage));
	NDR_CHECK(ejs_push_uint32(ejs, v, "enablesoftcompat", &r->enablesoftcompat));
	NDR_CHECK(ejs_push_uint32(ejs, v, "enableforcedlogoff", &r->enableforcedlogoff));
	NDR_CHECK(ejs_push_uint32(ejs, v, "timesource", &r->timesource));
	NDR_CHECK(ejs_push_uint32(ejs, v, "acceptdownlevelapis", &r->acceptdownlevelapis));
	NDR_CHECK(ejs_push_uint32(ejs, v, "lmannounce", &r->lmannounce));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo502(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo502 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "sessopen", &r->sessopen));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "sesssvc", &r->sesssvc));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "opensearch", &r->opensearch));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "sizereqbufs", &r->sizereqbufs));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "initworkitems", &r->initworkitems));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "maxworkitems", &r->maxworkitems));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "rawworkitems", &r->rawworkitems));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "irpstacksize", &r->irpstacksize));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "maxrawbuflen", &r->maxrawbuflen));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "sessusers", &r->sessusers));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "sessconns", &r->sessconns));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "maxpagedmemoryusage", &r->maxpagedmemoryusage));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "maxnonpagedmemoryusage", &r->maxnonpagedmemoryusage));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "enablesoftcompat", &r->enablesoftcompat));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "enableforcedlogoff", &r->enableforcedlogoff));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "timesource", &r->timesource));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "acceptdownlevelapis", &r->acceptdownlevelapis));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "lmannounce", &r->lmannounce));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo503(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo503 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "sessopen", &r->sessopen));
	NDR_CHECK(ejs_push_uint32(ejs, v, "sesssvc", &r->sesssvc));
	NDR_CHECK(ejs_push_uint32(ejs, v, "opensearch", &r->opensearch));
	NDR_CHECK(ejs_push_uint32(ejs, v, "sizereqbufs", &r->sizereqbufs));
	NDR_CHECK(ejs_push_uint32(ejs, v, "initworkitems", &r->initworkitems));
	NDR_CHECK(ejs_push_uint32(ejs, v, "maxworkitems", &r->maxworkitems));
	NDR_CHECK(ejs_push_uint32(ejs, v, "rawworkitems", &r->rawworkitems));
	NDR_CHECK(ejs_push_uint32(ejs, v, "irpstacksize", &r->irpstacksize));
	NDR_CHECK(ejs_push_uint32(ejs, v, "maxrawbuflen", &r->maxrawbuflen));
	NDR_CHECK(ejs_push_uint32(ejs, v, "sessusers", &r->sessusers));
	NDR_CHECK(ejs_push_uint32(ejs, v, "sessconns", &r->sessconns));
	NDR_CHECK(ejs_push_uint32(ejs, v, "maxpagedmemoryusage", &r->maxpagedmemoryusage));
	NDR_CHECK(ejs_push_uint32(ejs, v, "maxnonpagedmemoryusage", &r->maxnonpagedmemoryusage));
	NDR_CHECK(ejs_push_uint32(ejs, v, "enablesoftcompat", &r->enablesoftcompat));
	NDR_CHECK(ejs_push_uint32(ejs, v, "enableforcedlogoff", &r->enableforcedlogoff));
	NDR_CHECK(ejs_push_uint32(ejs, v, "timesource", &r->timesource));
	NDR_CHECK(ejs_push_uint32(ejs, v, "acceptdownlevelapis", &r->acceptdownlevelapis));
	NDR_CHECK(ejs_push_uint32(ejs, v, "lmannounce", &r->lmannounce));
	if (NULL == r->domain) {
		NDR_CHECK(ejs_push_null(ejs, v, "domain"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "domain", r->domain));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "maxcopyreadlen", &r->maxcopyreadlen));
	NDR_CHECK(ejs_push_uint32(ejs, v, "maxcopywritelen", &r->maxcopywritelen));
	NDR_CHECK(ejs_push_uint32(ejs, v, "minkeepsearch", &r->minkeepsearch));
	NDR_CHECK(ejs_push_uint32(ejs, v, "maxkeepsearch", &r->maxkeepsearch));
	NDR_CHECK(ejs_push_uint32(ejs, v, "minkeepcomplsearch", &r->minkeepcomplsearch));
	NDR_CHECK(ejs_push_uint32(ejs, v, "maxkeepcomplsearch", &r->maxkeepcomplsearch));
	NDR_CHECK(ejs_push_uint32(ejs, v, "threadcountadd", &r->threadcountadd));
	NDR_CHECK(ejs_push_uint32(ejs, v, "numlockthreads", &r->numlockthreads));
	NDR_CHECK(ejs_push_uint32(ejs, v, "scavtimeout", &r->scavtimeout));
	NDR_CHECK(ejs_push_uint32(ejs, v, "minrcvqueue", &r->minrcvqueue));
	NDR_CHECK(ejs_push_uint32(ejs, v, "minfreeworkitems", &r->minfreeworkitems));
	NDR_CHECK(ejs_push_uint32(ejs, v, "xactmemsize", &r->xactmemsize));
	NDR_CHECK(ejs_push_uint32(ejs, v, "threadpriority", &r->threadpriority));
	NDR_CHECK(ejs_push_uint32(ejs, v, "maxmpxct", &r->maxmpxct));
	NDR_CHECK(ejs_push_uint32(ejs, v, "oplockbreakwait", &r->oplockbreakwait));
	NDR_CHECK(ejs_push_uint32(ejs, v, "oplockbreakresponsewait", &r->oplockbreakresponsewait));
	NDR_CHECK(ejs_push_uint32(ejs, v, "enableoplocks", &r->enableoplocks));
	NDR_CHECK(ejs_push_uint32(ejs, v, "enableoplockforceclose", &r->enableoplockforceclose));
	NDR_CHECK(ejs_push_uint32(ejs, v, "enablefcbopens", &r->enablefcbopens));
	NDR_CHECK(ejs_push_uint32(ejs, v, "enableraw", &r->enableraw));
	NDR_CHECK(ejs_push_uint32(ejs, v, "enablesharednetdrives", &r->enablesharednetdrives));
	NDR_CHECK(ejs_push_uint32(ejs, v, "minfreeconnections", &r->minfreeconnections));
	NDR_CHECK(ejs_push_uint32(ejs, v, "maxfreeconnections", &r->maxfreeconnections));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo503(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo503 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "sessopen", &r->sessopen));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "sesssvc", &r->sesssvc));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "opensearch", &r->opensearch));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "sizereqbufs", &r->sizereqbufs));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "initworkitems", &r->initworkitems));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "maxworkitems", &r->maxworkitems));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "rawworkitems", &r->rawworkitems));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "irpstacksize", &r->irpstacksize));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "maxrawbuflen", &r->maxrawbuflen));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "sessusers", &r->sessusers));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "sessconns", &r->sessconns));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "maxpagedmemoryusage", &r->maxpagedmemoryusage));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "maxnonpagedmemoryusage", &r->maxnonpagedmemoryusage));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "enablesoftcompat", &r->enablesoftcompat));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "enableforcedlogoff", &r->enableforcedlogoff));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "timesource", &r->timesource));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "acceptdownlevelapis", &r->acceptdownlevelapis));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "lmannounce", &r->lmannounce));
	if (ejs_pull_null(ejs, v, "domain")) {
		r->domain = NULL;
	} else {
		EJS_ALLOC(ejs, r->domain);
		NDR_CHECK(ejs_pull_string(ejs, v, "domain", &r->domain));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "maxcopyreadlen", &r->maxcopyreadlen));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "maxcopywritelen", &r->maxcopywritelen));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "minkeepsearch", &r->minkeepsearch));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "maxkeepsearch", &r->maxkeepsearch));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "minkeepcomplsearch", &r->minkeepcomplsearch));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "maxkeepcomplsearch", &r->maxkeepcomplsearch));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "threadcountadd", &r->threadcountadd));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "numlockthreads", &r->numlockthreads));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "scavtimeout", &r->scavtimeout));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "minrcvqueue", &r->minrcvqueue));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "minfreeworkitems", &r->minfreeworkitems));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "xactmemsize", &r->xactmemsize));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "threadpriority", &r->threadpriority));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "maxmpxct", &r->maxmpxct));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "oplockbreakwait", &r->oplockbreakwait));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "oplockbreakresponsewait", &r->oplockbreakresponsewait));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "enableoplocks", &r->enableoplocks));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "enableoplockforceclose", &r->enableoplockforceclose));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "enablefcbopens", &r->enablefcbopens));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "enableraw", &r->enableraw));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "enablesharednetdrives", &r->enablesharednetdrives));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "minfreeconnections", &r->minfreeconnections));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "maxfreeconnections", &r->maxfreeconnections));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo599(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo599 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "sessopen", &r->sessopen));
	NDR_CHECK(ejs_push_uint32(ejs, v, "sesssvc", &r->sesssvc));
	NDR_CHECK(ejs_push_uint32(ejs, v, "opensearch", &r->opensearch));
	NDR_CHECK(ejs_push_uint32(ejs, v, "sizereqbufs", &r->sizereqbufs));
	NDR_CHECK(ejs_push_uint32(ejs, v, "initworkitems", &r->initworkitems));
	NDR_CHECK(ejs_push_uint32(ejs, v, "maxworkitems", &r->maxworkitems));
	NDR_CHECK(ejs_push_uint32(ejs, v, "rawworkitems", &r->rawworkitems));
	NDR_CHECK(ejs_push_uint32(ejs, v, "irpstacksize", &r->irpstacksize));
	NDR_CHECK(ejs_push_uint32(ejs, v, "maxrawbuflen", &r->maxrawbuflen));
	NDR_CHECK(ejs_push_uint32(ejs, v, "sessusers", &r->sessusers));
	NDR_CHECK(ejs_push_uint32(ejs, v, "sessconns", &r->sessconns));
	NDR_CHECK(ejs_push_uint32(ejs, v, "maxpagedmemoryusage", &r->maxpagedmemoryusage));
	NDR_CHECK(ejs_push_uint32(ejs, v, "maxnonpagedmemoryusage", &r->maxnonpagedmemoryusage));
	NDR_CHECK(ejs_push_uint32(ejs, v, "enablesoftcompat", &r->enablesoftcompat));
	NDR_CHECK(ejs_push_uint32(ejs, v, "enableforcedlogoff", &r->enableforcedlogoff));
	NDR_CHECK(ejs_push_uint32(ejs, v, "timesource", &r->timesource));
	NDR_CHECK(ejs_push_uint32(ejs, v, "acceptdownlevelapis", &r->acceptdownlevelapis));
	NDR_CHECK(ejs_push_uint32(ejs, v, "lmannounce", &r->lmannounce));
	if (NULL == r->domain) {
		NDR_CHECK(ejs_push_null(ejs, v, "domain"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "domain", r->domain));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "maxcopyreadlen", &r->maxcopyreadlen));
	NDR_CHECK(ejs_push_uint32(ejs, v, "maxcopywritelen", &r->maxcopywritelen));
	NDR_CHECK(ejs_push_uint32(ejs, v, "minkeepsearch", &r->minkeepsearch));
	NDR_CHECK(ejs_push_uint32(ejs, v, "minkeepcomplsearch", &r->minkeepcomplsearch));
	NDR_CHECK(ejs_push_uint32(ejs, v, "maxkeepcomplsearch", &r->maxkeepcomplsearch));
	NDR_CHECK(ejs_push_uint32(ejs, v, "threadcountadd", &r->threadcountadd));
	NDR_CHECK(ejs_push_uint32(ejs, v, "numlockthreads", &r->numlockthreads));
	NDR_CHECK(ejs_push_uint32(ejs, v, "scavtimeout", &r->scavtimeout));
	NDR_CHECK(ejs_push_uint32(ejs, v, "minrcvqueue", &r->minrcvqueue));
	NDR_CHECK(ejs_push_uint32(ejs, v, "minfreeworkitems", &r->minfreeworkitems));
	NDR_CHECK(ejs_push_uint32(ejs, v, "xactmemsize", &r->xactmemsize));
	NDR_CHECK(ejs_push_uint32(ejs, v, "threadpriority", &r->threadpriority));
	NDR_CHECK(ejs_push_uint32(ejs, v, "maxmpxct", &r->maxmpxct));
	NDR_CHECK(ejs_push_uint32(ejs, v, "oplockbreakwait", &r->oplockbreakwait));
	NDR_CHECK(ejs_push_uint32(ejs, v, "oplockbreakresponsewait", &r->oplockbreakresponsewait));
	NDR_CHECK(ejs_push_uint32(ejs, v, "enableoplocks", &r->enableoplocks));
	NDR_CHECK(ejs_push_uint32(ejs, v, "enableoplockforceclose", &r->enableoplockforceclose));
	NDR_CHECK(ejs_push_uint32(ejs, v, "enablefcbopens", &r->enablefcbopens));
	NDR_CHECK(ejs_push_uint32(ejs, v, "enableraw", &r->enableraw));
	NDR_CHECK(ejs_push_uint32(ejs, v, "enablesharednetdrives", &r->enablesharednetdrives));
	NDR_CHECK(ejs_push_uint32(ejs, v, "minfreeconnections", &r->minfreeconnections));
	NDR_CHECK(ejs_push_uint32(ejs, v, "maxfreeconnections", &r->maxfreeconnections));
	NDR_CHECK(ejs_push_uint32(ejs, v, "initsesstable", &r->initsesstable));
	NDR_CHECK(ejs_push_uint32(ejs, v, "initconntable", &r->initconntable));
	NDR_CHECK(ejs_push_uint32(ejs, v, "initfiletable", &r->initfiletable));
	NDR_CHECK(ejs_push_uint32(ejs, v, "initsearchtable", &r->initsearchtable));
	NDR_CHECK(ejs_push_uint32(ejs, v, "alertsched", &r->alertsched));
	NDR_CHECK(ejs_push_uint32(ejs, v, "errortreshold", &r->errortreshold));
	NDR_CHECK(ejs_push_uint32(ejs, v, "networkerrortreshold", &r->networkerrortreshold));
	NDR_CHECK(ejs_push_uint32(ejs, v, "diskspacetreshold", &r->diskspacetreshold));
	NDR_CHECK(ejs_push_uint32(ejs, v, "reserved", &r->reserved));
	NDR_CHECK(ejs_push_uint32(ejs, v, "maxlinkdelay", &r->maxlinkdelay));
	NDR_CHECK(ejs_push_uint32(ejs, v, "minlinkthroughput", &r->minlinkthroughput));
	NDR_CHECK(ejs_push_uint32(ejs, v, "linkinfovalidtime", &r->linkinfovalidtime));
	NDR_CHECK(ejs_push_uint32(ejs, v, "scavqosinfoupdatetime", &r->scavqosinfoupdatetime));
	NDR_CHECK(ejs_push_uint32(ejs, v, "maxworkitemidletime", &r->maxworkitemidletime));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo599(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo599 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "sessopen", &r->sessopen));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "sesssvc", &r->sesssvc));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "opensearch", &r->opensearch));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "sizereqbufs", &r->sizereqbufs));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "initworkitems", &r->initworkitems));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "maxworkitems", &r->maxworkitems));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "rawworkitems", &r->rawworkitems));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "irpstacksize", &r->irpstacksize));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "maxrawbuflen", &r->maxrawbuflen));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "sessusers", &r->sessusers));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "sessconns", &r->sessconns));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "maxpagedmemoryusage", &r->maxpagedmemoryusage));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "maxnonpagedmemoryusage", &r->maxnonpagedmemoryusage));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "enablesoftcompat", &r->enablesoftcompat));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "enableforcedlogoff", &r->enableforcedlogoff));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "timesource", &r->timesource));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "acceptdownlevelapis", &r->acceptdownlevelapis));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "lmannounce", &r->lmannounce));
	if (ejs_pull_null(ejs, v, "domain")) {
		r->domain = NULL;
	} else {
		EJS_ALLOC(ejs, r->domain);
		NDR_CHECK(ejs_pull_string(ejs, v, "domain", &r->domain));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "maxcopyreadlen", &r->maxcopyreadlen));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "maxcopywritelen", &r->maxcopywritelen));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "minkeepsearch", &r->minkeepsearch));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "minkeepcomplsearch", &r->minkeepcomplsearch));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "maxkeepcomplsearch", &r->maxkeepcomplsearch));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "threadcountadd", &r->threadcountadd));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "numlockthreads", &r->numlockthreads));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "scavtimeout", &r->scavtimeout));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "minrcvqueue", &r->minrcvqueue));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "minfreeworkitems", &r->minfreeworkitems));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "xactmemsize", &r->xactmemsize));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "threadpriority", &r->threadpriority));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "maxmpxct", &r->maxmpxct));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "oplockbreakwait", &r->oplockbreakwait));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "oplockbreakresponsewait", &r->oplockbreakresponsewait));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "enableoplocks", &r->enableoplocks));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "enableoplockforceclose", &r->enableoplockforceclose));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "enablefcbopens", &r->enablefcbopens));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "enableraw", &r->enableraw));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "enablesharednetdrives", &r->enablesharednetdrives));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "minfreeconnections", &r->minfreeconnections));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "maxfreeconnections", &r->maxfreeconnections));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "initsesstable", &r->initsesstable));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "initconntable", &r->initconntable));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "initfiletable", &r->initfiletable));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "initsearchtable", &r->initsearchtable));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "alertsched", &r->alertsched));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "errortreshold", &r->errortreshold));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "networkerrortreshold", &r->networkerrortreshold));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "diskspacetreshold", &r->diskspacetreshold));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "reserved", &r->reserved));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "maxlinkdelay", &r->maxlinkdelay));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "minlinkthroughput", &r->minlinkthroughput));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "linkinfovalidtime", &r->linkinfovalidtime));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "scavqosinfoupdatetime", &r->scavqosinfoupdatetime));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "maxworkitemidletime", &r->maxworkitemidletime));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1005(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1005 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->comment) {
		NDR_CHECK(ejs_push_null(ejs, v, "comment"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "comment", r->comment));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1005(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1005 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "comment")) {
		r->comment = NULL;
	} else {
		EJS_ALLOC(ejs, r->comment);
		NDR_CHECK(ejs_pull_string(ejs, v, "comment", &r->comment));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1010(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1010 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "disc", &r->disc));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1010(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1010 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "disc", &r->disc));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1016(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1016 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "hidden", &r->hidden));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1016(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1016 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "hidden", &r->hidden));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1017(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1017 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "announce", &r->announce));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1017(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1017 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "announce", &r->announce));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1018(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1018 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "anndelta", &r->anndelta));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1018(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1018 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "anndelta", &r->anndelta));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1107(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1107 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "users", &r->users));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1107(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1107 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "users", &r->users));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1501(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1501 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "sessopens", &r->sessopens));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1501(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1501 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "sessopens", &r->sessopens));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1502(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1502 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "sessvcs", &r->sessvcs));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1502(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1502 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "sessvcs", &r->sessvcs));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1503(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1503 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "opensearch", &r->opensearch));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1503(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1503 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "opensearch", &r->opensearch));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1506(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1506 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "maxworkitems", &r->maxworkitems));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1506(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1506 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "maxworkitems", &r->maxworkitems));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1509(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1509 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "maxrawbuflen", &r->maxrawbuflen));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1509(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1509 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "maxrawbuflen", &r->maxrawbuflen));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1510(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1510 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "sessusers", &r->sessusers));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1510(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1510 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "sessusers", &r->sessusers));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1511(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1511 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "sesscons", &r->sesscons));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1511(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1511 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "sesscons", &r->sesscons));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1512(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1512 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "maxnonpagedmemoryusage", &r->maxnonpagedmemoryusage));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1512(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1512 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "maxnonpagedmemoryusage", &r->maxnonpagedmemoryusage));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1513(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1513 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "maxpagedmemoryusage", &r->maxpagedmemoryusage));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1513(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1513 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "maxpagedmemoryusage", &r->maxpagedmemoryusage));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1514(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1514 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "enablesoftcompat", &r->enablesoftcompat));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1514(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1514 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "enablesoftcompat", &r->enablesoftcompat));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1515(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1515 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "enableforcedlogoff", &r->enableforcedlogoff));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1515(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1515 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "enableforcedlogoff", &r->enableforcedlogoff));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1516(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1516 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "timesource", &r->timesource));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1516(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1516 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "timesource", &r->timesource));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1518(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1518 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "lmannounce", &r->lmannounce));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1518(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1518 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "lmannounce", &r->lmannounce));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1520(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1520 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "maxcopyreadlen", &r->maxcopyreadlen));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1520(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1520 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "maxcopyreadlen", &r->maxcopyreadlen));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1521(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1521 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "maxcopywritelen", &r->maxcopywritelen));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1521(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1521 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "maxcopywritelen", &r->maxcopywritelen));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1522(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1522 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "minkeepsearch", &r->minkeepsearch));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1522(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1522 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "minkeepsearch", &r->minkeepsearch));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1523(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1523 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "maxkeepsearch", &r->maxkeepsearch));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1523(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1523 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "maxkeepsearch", &r->maxkeepsearch));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1524(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1524 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "minkeepcomplsearch", &r->minkeepcomplsearch));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1524(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1524 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "minkeepcomplsearch", &r->minkeepcomplsearch));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1525(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1525 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "maxkeepcomplsearch", &r->maxkeepcomplsearch));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1525(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1525 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "maxkeepcomplsearch", &r->maxkeepcomplsearch));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1528(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1528 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "scavtimeout", &r->scavtimeout));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1528(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1528 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "scavtimeout", &r->scavtimeout));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1529(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1529 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "minrcvqueue", &r->minrcvqueue));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1529(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1529 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "minrcvqueue", &r->minrcvqueue));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1530(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1530 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "minfreeworkitems", &r->minfreeworkitems));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1530(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1530 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "minfreeworkitems", &r->minfreeworkitems));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1533(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1533 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "maxmpxct", &r->maxmpxct));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1533(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1533 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "maxmpxct", &r->maxmpxct));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1534(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1534 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "oplockbreakwait", &r->oplockbreakwait));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1534(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1534 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "oplockbreakwait", &r->oplockbreakwait));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1535(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1535 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "oplockbreakresponsewait", &r->oplockbreakresponsewait));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1535(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1535 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "oplockbreakresponsewait", &r->oplockbreakresponsewait));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1536(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1536 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "enableoplocks", &r->enableoplocks));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1536(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1536 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "enableoplocks", &r->enableoplocks));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1537(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1537 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "enableoplockforceclose", &r->enableoplockforceclose));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1537(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1537 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "enableoplockforceclose", &r->enableoplockforceclose));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1538(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1538 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "enablefcbopens", &r->enablefcbopens));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1538(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1538 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "enablefcbopens", &r->enablefcbopens));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1539(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1539 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "enableraw", &r->enableraw));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1539(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1539 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "enableraw", &r->enableraw));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1540(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1540 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "enablesharednetdrives", &r->enablesharednetdrives));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1540(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1540 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "enablesharednetdrives", &r->enablesharednetdrives));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1541(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1541 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "minfreeconnections", &r->minfreeconnections));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1541(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1541 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "minfreeconnections", &r->minfreeconnections));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1542(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1542 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "maxfreeconnections", &r->maxfreeconnections));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1542(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1542 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "maxfreeconnections", &r->maxfreeconnections));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1543(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1543 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "initsesstable", &r->initsesstable));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1543(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1543 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "initsesstable", &r->initsesstable));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1544(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1544 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "initconntable", &r->initconntable));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1544(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1544 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "initconntable", &r->initconntable));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1545(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1545 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "initfiletable", &r->initfiletable));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1545(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1545 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "initfiletable", &r->initfiletable));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1546(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1546 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "initsearchtable", &r->initsearchtable));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1546(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1546 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "initsearchtable", &r->initsearchtable));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1547(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1547 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "alertsched", &r->alertsched));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1547(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1547 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "alertsched", &r->alertsched));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1548(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1548 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "errortreshold", &r->errortreshold));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1548(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1548 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "errortreshold", &r->errortreshold));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1549(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1549 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "networkerrortreshold", &r->networkerrortreshold));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1549(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1549 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "networkerrortreshold", &r->networkerrortreshold));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1550(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1550 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "diskspacetreshold", &r->diskspacetreshold));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1550(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1550 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "diskspacetreshold", &r->diskspacetreshold));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1552(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1552 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "maxlinkdelay", &r->maxlinkdelay));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1552(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1552 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "maxlinkdelay", &r->maxlinkdelay));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1553(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1553 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "minlinkthroughput", &r->minlinkthroughput));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1553(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1553 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "minlinkthroughput", &r->minlinkthroughput));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1554(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1554 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "linkinfovalidtime", &r->linkinfovalidtime));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1554(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1554 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "linkinfovalidtime", &r->linkinfovalidtime));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1555(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1555 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "scavqosinfoupdatetime", &r->scavqosinfoupdatetime));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1555(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1555 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "scavqosinfoupdatetime", &r->scavqosinfoupdatetime));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo1556(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetSrvInfo1556 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "maxworkitemidletime", &r->maxworkitemidletime));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetSrvInfo1556(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetSrvInfo1556 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "maxworkitemidletime", &r->maxworkitemidletime));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetSrvInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union srvsvc_NetSrvInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 100:
			if (NULL == r->info100) {
				NDR_CHECK(ejs_push_null(ejs, v, "info100"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo100(ejs, v, "info100", r->info100));
			}
			break;
		case 101:
			if (NULL == r->info101) {
				NDR_CHECK(ejs_push_null(ejs, v, "info101"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo101(ejs, v, "info101", r->info101));
			}
			break;
		case 102:
			if (NULL == r->info102) {
				NDR_CHECK(ejs_push_null(ejs, v, "info102"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo102(ejs, v, "info102", r->info102));
			}
			break;
		case 402:
			if (NULL == r->info402) {
				NDR_CHECK(ejs_push_null(ejs, v, "info402"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo402(ejs, v, "info402", r->info402));
			}
			break;
		case 403:
			if (NULL == r->info403) {
				NDR_CHECK(ejs_push_null(ejs, v, "info403"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo403(ejs, v, "info403", r->info403));
			}
			break;
		case 502:
			if (NULL == r->info502) {
				NDR_CHECK(ejs_push_null(ejs, v, "info502"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo502(ejs, v, "info502", r->info502));
			}
			break;
		case 503:
			if (NULL == r->info503) {
				NDR_CHECK(ejs_push_null(ejs, v, "info503"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo503(ejs, v, "info503", r->info503));
			}
			break;
		case 599:
			if (NULL == r->info599) {
				NDR_CHECK(ejs_push_null(ejs, v, "info599"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo599(ejs, v, "info599", r->info599));
			}
			break;
		case 1005:
			if (NULL == r->info1005) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1005"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1005(ejs, v, "info1005", r->info1005));
			}
			break;
		case 1010:
			if (NULL == r->info1010) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1010"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1010(ejs, v, "info1010", r->info1010));
			}
			break;
		case 1016:
			if (NULL == r->info1016) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1016"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1016(ejs, v, "info1016", r->info1016));
			}
			break;
		case 1017:
			if (NULL == r->info1017) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1017"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1017(ejs, v, "info1017", r->info1017));
			}
			break;
		case 1018:
			if (NULL == r->info1018) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1018"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1018(ejs, v, "info1018", r->info1018));
			}
			break;
		case 1107:
			if (NULL == r->info1107) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1107"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1107(ejs, v, "info1107", r->info1107));
			}
			break;
		case 1501:
			if (NULL == r->info1501) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1501"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1501(ejs, v, "info1501", r->info1501));
			}
			break;
		case 1502:
			if (NULL == r->info1502) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1502"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1502(ejs, v, "info1502", r->info1502));
			}
			break;
		case 1503:
			if (NULL == r->info1503) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1503"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1503(ejs, v, "info1503", r->info1503));
			}
			break;
		case 1506:
			if (NULL == r->info1506) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1506"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1506(ejs, v, "info1506", r->info1506));
			}
			break;
		case 1509:
			if (NULL == r->info1509) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1509"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1509(ejs, v, "info1509", r->info1509));
			}
			break;
		case 1510:
			if (NULL == r->info1510) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1510"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1510(ejs, v, "info1510", r->info1510));
			}
			break;
		case 1511:
			if (NULL == r->info1511) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1511"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1511(ejs, v, "info1511", r->info1511));
			}
			break;
		case 1512:
			if (NULL == r->info1512) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1512"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1512(ejs, v, "info1512", r->info1512));
			}
			break;
		case 1513:
			if (NULL == r->info1513) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1513"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1513(ejs, v, "info1513", r->info1513));
			}
			break;
		case 1514:
			if (NULL == r->info1514) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1514"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1514(ejs, v, "info1514", r->info1514));
			}
			break;
		case 1515:
			if (NULL == r->info1515) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1515"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1515(ejs, v, "info1515", r->info1515));
			}
			break;
		case 1516:
			if (NULL == r->info1516) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1516"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1516(ejs, v, "info1516", r->info1516));
			}
			break;
		case 1518:
			if (NULL == r->info1518) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1518"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1518(ejs, v, "info1518", r->info1518));
			}
			break;
		case 1520:
			if (NULL == r->info1520) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1520"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1520(ejs, v, "info1520", r->info1520));
			}
			break;
		case 1521:
			if (NULL == r->info1521) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1521"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1521(ejs, v, "info1521", r->info1521));
			}
			break;
		case 1522:
			if (NULL == r->info1522) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1522"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1522(ejs, v, "info1522", r->info1522));
			}
			break;
		case 1523:
			if (NULL == r->info1523) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1523"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1523(ejs, v, "info1523", r->info1523));
			}
			break;
		case 1524:
			if (NULL == r->info1524) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1524"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1524(ejs, v, "info1524", r->info1524));
			}
			break;
		case 1525:
			if (NULL == r->info1525) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1525"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1525(ejs, v, "info1525", r->info1525));
			}
			break;
		case 1528:
			if (NULL == r->info1528) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1528"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1528(ejs, v, "info1528", r->info1528));
			}
			break;
		case 1529:
			if (NULL == r->info1529) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1529"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1529(ejs, v, "info1529", r->info1529));
			}
			break;
		case 1530:
			if (NULL == r->info1530) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1530"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1530(ejs, v, "info1530", r->info1530));
			}
			break;
		case 1533:
			if (NULL == r->info1533) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1533"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1533(ejs, v, "info1533", r->info1533));
			}
			break;
		case 1534:
			if (NULL == r->info1534) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1534"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1534(ejs, v, "info1534", r->info1534));
			}
			break;
		case 1535:
			if (NULL == r->info1535) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1535"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1535(ejs, v, "info1535", r->info1535));
			}
			break;
		case 1536:
			if (NULL == r->info1536) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1536"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1536(ejs, v, "info1536", r->info1536));
			}
			break;
		case 1537:
			if (NULL == r->info1537) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1537"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1537(ejs, v, "info1537", r->info1537));
			}
			break;
		case 1538:
			if (NULL == r->info1538) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1538"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1538(ejs, v, "info1538", r->info1538));
			}
			break;
		case 1539:
			if (NULL == r->info1539) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1539"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1539(ejs, v, "info1539", r->info1539));
			}
			break;
		case 1540:
			if (NULL == r->info1540) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1540"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1540(ejs, v, "info1540", r->info1540));
			}
			break;
		case 1541:
			if (NULL == r->info1541) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1541"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1541(ejs, v, "info1541", r->info1541));
			}
			break;
		case 1542:
			if (NULL == r->info1542) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1542"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1542(ejs, v, "info1542", r->info1542));
			}
			break;
		case 1543:
			if (NULL == r->info1543) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1543"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1543(ejs, v, "info1543", r->info1543));
			}
			break;
		case 1544:
			if (NULL == r->info1544) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1544"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1544(ejs, v, "info1544", r->info1544));
			}
			break;
		case 1545:
			if (NULL == r->info1545) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1545"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1545(ejs, v, "info1545", r->info1545));
			}
			break;
		case 1546:
			if (NULL == r->info1546) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1546"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1546(ejs, v, "info1546", r->info1546));
			}
			break;
		case 1547:
			if (NULL == r->info1547) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1547"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1547(ejs, v, "info1547", r->info1547));
			}
			break;
		case 1548:
			if (NULL == r->info1548) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1548"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1548(ejs, v, "info1548", r->info1548));
			}
			break;
		case 1549:
			if (NULL == r->info1549) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1549"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1549(ejs, v, "info1549", r->info1549));
			}
			break;
		case 1550:
			if (NULL == r->info1550) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1550"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1550(ejs, v, "info1550", r->info1550));
			}
			break;
		case 1552:
			if (NULL == r->info1552) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1552"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1552(ejs, v, "info1552", r->info1552));
			}
			break;
		case 1553:
			if (NULL == r->info1553) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1553"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1553(ejs, v, "info1553", r->info1553));
			}
			break;
		case 1554:
			if (NULL == r->info1554) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1554"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1554(ejs, v, "info1554", r->info1554));
			}
			break;
		case 1555:
			if (NULL == r->info1555) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1555"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1555(ejs, v, "info1555", r->info1555));
			}
			break;
		case 1556:
			if (NULL == r->info1556) {
				NDR_CHECK(ejs_push_null(ejs, v, "info1556"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetSrvInfo1556(ejs, v, "info1556", r->info1556));
			}
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_srvsvc_NetSrvInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union srvsvc_NetSrvInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 100:
			if (ejs_pull_null(ejs, v, "info100")) {
				r->info100 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info100);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo100(ejs, v, "info100", r->info100));
			}
			break;
		case 101:
			if (ejs_pull_null(ejs, v, "info101")) {
				r->info101 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info101);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo101(ejs, v, "info101", r->info101));
			}
			break;
		case 102:
			if (ejs_pull_null(ejs, v, "info102")) {
				r->info102 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info102);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo102(ejs, v, "info102", r->info102));
			}
			break;
		case 402:
			if (ejs_pull_null(ejs, v, "info402")) {
				r->info402 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info402);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo402(ejs, v, "info402", r->info402));
			}
			break;
		case 403:
			if (ejs_pull_null(ejs, v, "info403")) {
				r->info403 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info403);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo403(ejs, v, "info403", r->info403));
			}
			break;
		case 502:
			if (ejs_pull_null(ejs, v, "info502")) {
				r->info502 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info502);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo502(ejs, v, "info502", r->info502));
			}
			break;
		case 503:
			if (ejs_pull_null(ejs, v, "info503")) {
				r->info503 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info503);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo503(ejs, v, "info503", r->info503));
			}
			break;
		case 599:
			if (ejs_pull_null(ejs, v, "info599")) {
				r->info599 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info599);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo599(ejs, v, "info599", r->info599));
			}
			break;
		case 1005:
			if (ejs_pull_null(ejs, v, "info1005")) {
				r->info1005 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1005);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1005(ejs, v, "info1005", r->info1005));
			}
			break;
		case 1010:
			if (ejs_pull_null(ejs, v, "info1010")) {
				r->info1010 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1010);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1010(ejs, v, "info1010", r->info1010));
			}
			break;
		case 1016:
			if (ejs_pull_null(ejs, v, "info1016")) {
				r->info1016 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1016);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1016(ejs, v, "info1016", r->info1016));
			}
			break;
		case 1017:
			if (ejs_pull_null(ejs, v, "info1017")) {
				r->info1017 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1017);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1017(ejs, v, "info1017", r->info1017));
			}
			break;
		case 1018:
			if (ejs_pull_null(ejs, v, "info1018")) {
				r->info1018 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1018);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1018(ejs, v, "info1018", r->info1018));
			}
			break;
		case 1107:
			if (ejs_pull_null(ejs, v, "info1107")) {
				r->info1107 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1107);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1107(ejs, v, "info1107", r->info1107));
			}
			break;
		case 1501:
			if (ejs_pull_null(ejs, v, "info1501")) {
				r->info1501 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1501);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1501(ejs, v, "info1501", r->info1501));
			}
			break;
		case 1502:
			if (ejs_pull_null(ejs, v, "info1502")) {
				r->info1502 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1502);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1502(ejs, v, "info1502", r->info1502));
			}
			break;
		case 1503:
			if (ejs_pull_null(ejs, v, "info1503")) {
				r->info1503 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1503);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1503(ejs, v, "info1503", r->info1503));
			}
			break;
		case 1506:
			if (ejs_pull_null(ejs, v, "info1506")) {
				r->info1506 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1506);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1506(ejs, v, "info1506", r->info1506));
			}
			break;
		case 1509:
			if (ejs_pull_null(ejs, v, "info1509")) {
				r->info1509 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1509);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1509(ejs, v, "info1509", r->info1509));
			}
			break;
		case 1510:
			if (ejs_pull_null(ejs, v, "info1510")) {
				r->info1510 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1510);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1510(ejs, v, "info1510", r->info1510));
			}
			break;
		case 1511:
			if (ejs_pull_null(ejs, v, "info1511")) {
				r->info1511 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1511);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1511(ejs, v, "info1511", r->info1511));
			}
			break;
		case 1512:
			if (ejs_pull_null(ejs, v, "info1512")) {
				r->info1512 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1512);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1512(ejs, v, "info1512", r->info1512));
			}
			break;
		case 1513:
			if (ejs_pull_null(ejs, v, "info1513")) {
				r->info1513 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1513);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1513(ejs, v, "info1513", r->info1513));
			}
			break;
		case 1514:
			if (ejs_pull_null(ejs, v, "info1514")) {
				r->info1514 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1514);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1514(ejs, v, "info1514", r->info1514));
			}
			break;
		case 1515:
			if (ejs_pull_null(ejs, v, "info1515")) {
				r->info1515 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1515);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1515(ejs, v, "info1515", r->info1515));
			}
			break;
		case 1516:
			if (ejs_pull_null(ejs, v, "info1516")) {
				r->info1516 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1516);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1516(ejs, v, "info1516", r->info1516));
			}
			break;
		case 1518:
			if (ejs_pull_null(ejs, v, "info1518")) {
				r->info1518 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1518);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1518(ejs, v, "info1518", r->info1518));
			}
			break;
		case 1520:
			if (ejs_pull_null(ejs, v, "info1520")) {
				r->info1520 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1520);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1520(ejs, v, "info1520", r->info1520));
			}
			break;
		case 1521:
			if (ejs_pull_null(ejs, v, "info1521")) {
				r->info1521 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1521);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1521(ejs, v, "info1521", r->info1521));
			}
			break;
		case 1522:
			if (ejs_pull_null(ejs, v, "info1522")) {
				r->info1522 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1522);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1522(ejs, v, "info1522", r->info1522));
			}
			break;
		case 1523:
			if (ejs_pull_null(ejs, v, "info1523")) {
				r->info1523 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1523);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1523(ejs, v, "info1523", r->info1523));
			}
			break;
		case 1524:
			if (ejs_pull_null(ejs, v, "info1524")) {
				r->info1524 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1524);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1524(ejs, v, "info1524", r->info1524));
			}
			break;
		case 1525:
			if (ejs_pull_null(ejs, v, "info1525")) {
				r->info1525 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1525);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1525(ejs, v, "info1525", r->info1525));
			}
			break;
		case 1528:
			if (ejs_pull_null(ejs, v, "info1528")) {
				r->info1528 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1528);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1528(ejs, v, "info1528", r->info1528));
			}
			break;
		case 1529:
			if (ejs_pull_null(ejs, v, "info1529")) {
				r->info1529 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1529);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1529(ejs, v, "info1529", r->info1529));
			}
			break;
		case 1530:
			if (ejs_pull_null(ejs, v, "info1530")) {
				r->info1530 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1530);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1530(ejs, v, "info1530", r->info1530));
			}
			break;
		case 1533:
			if (ejs_pull_null(ejs, v, "info1533")) {
				r->info1533 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1533);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1533(ejs, v, "info1533", r->info1533));
			}
			break;
		case 1534:
			if (ejs_pull_null(ejs, v, "info1534")) {
				r->info1534 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1534);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1534(ejs, v, "info1534", r->info1534));
			}
			break;
		case 1535:
			if (ejs_pull_null(ejs, v, "info1535")) {
				r->info1535 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1535);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1535(ejs, v, "info1535", r->info1535));
			}
			break;
		case 1536:
			if (ejs_pull_null(ejs, v, "info1536")) {
				r->info1536 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1536);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1536(ejs, v, "info1536", r->info1536));
			}
			break;
		case 1537:
			if (ejs_pull_null(ejs, v, "info1537")) {
				r->info1537 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1537);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1537(ejs, v, "info1537", r->info1537));
			}
			break;
		case 1538:
			if (ejs_pull_null(ejs, v, "info1538")) {
				r->info1538 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1538);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1538(ejs, v, "info1538", r->info1538));
			}
			break;
		case 1539:
			if (ejs_pull_null(ejs, v, "info1539")) {
				r->info1539 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1539);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1539(ejs, v, "info1539", r->info1539));
			}
			break;
		case 1540:
			if (ejs_pull_null(ejs, v, "info1540")) {
				r->info1540 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1540);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1540(ejs, v, "info1540", r->info1540));
			}
			break;
		case 1541:
			if (ejs_pull_null(ejs, v, "info1541")) {
				r->info1541 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1541);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1541(ejs, v, "info1541", r->info1541));
			}
			break;
		case 1542:
			if (ejs_pull_null(ejs, v, "info1542")) {
				r->info1542 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1542);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1542(ejs, v, "info1542", r->info1542));
			}
			break;
		case 1543:
			if (ejs_pull_null(ejs, v, "info1543")) {
				r->info1543 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1543);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1543(ejs, v, "info1543", r->info1543));
			}
			break;
		case 1544:
			if (ejs_pull_null(ejs, v, "info1544")) {
				r->info1544 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1544);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1544(ejs, v, "info1544", r->info1544));
			}
			break;
		case 1545:
			if (ejs_pull_null(ejs, v, "info1545")) {
				r->info1545 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1545);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1545(ejs, v, "info1545", r->info1545));
			}
			break;
		case 1546:
			if (ejs_pull_null(ejs, v, "info1546")) {
				r->info1546 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1546);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1546(ejs, v, "info1546", r->info1546));
			}
			break;
		case 1547:
			if (ejs_pull_null(ejs, v, "info1547")) {
				r->info1547 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1547);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1547(ejs, v, "info1547", r->info1547));
			}
			break;
		case 1548:
			if (ejs_pull_null(ejs, v, "info1548")) {
				r->info1548 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1548);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1548(ejs, v, "info1548", r->info1548));
			}
			break;
		case 1549:
			if (ejs_pull_null(ejs, v, "info1549")) {
				r->info1549 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1549);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1549(ejs, v, "info1549", r->info1549));
			}
			break;
		case 1550:
			if (ejs_pull_null(ejs, v, "info1550")) {
				r->info1550 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1550);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1550(ejs, v, "info1550", r->info1550));
			}
			break;
		case 1552:
			if (ejs_pull_null(ejs, v, "info1552")) {
				r->info1552 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1552);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1552(ejs, v, "info1552", r->info1552));
			}
			break;
		case 1553:
			if (ejs_pull_null(ejs, v, "info1553")) {
				r->info1553 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1553);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1553(ejs, v, "info1553", r->info1553));
			}
			break;
		case 1554:
			if (ejs_pull_null(ejs, v, "info1554")) {
				r->info1554 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1554);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1554(ejs, v, "info1554", r->info1554));
			}
			break;
		case 1555:
			if (ejs_pull_null(ejs, v, "info1555")) {
				r->info1555 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1555);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1555(ejs, v, "info1555", r->info1555));
			}
			break;
		case 1556:
			if (ejs_pull_null(ejs, v, "info1556")) {
				r->info1556 = NULL;
			} else {
				EJS_ALLOC(ejs, r->info1556);
				NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo1556(ejs, v, "info1556", r->info1556));
			}
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_srvsvc_NetDiskInfo0(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetDiskInfo0 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_string(ejs, v, "disk", r->disk));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetDiskInfo0(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetDiskInfo0 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_string(ejs, v, "disk", &r->disk));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetDiskInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetDiskInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->disks) {
		NDR_CHECK(ejs_push_null(ejs, v, "disks"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "disks", i);
				NDR_CHECK(ejs_push_srvsvc_NetDiskInfo0(ejs, v, id, &r->disks[i]));
			}
			ejs_push_uint32(ejs, v, "disks" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetDiskInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetDiskInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	if (ejs_pull_null(ejs, v, "disks")) {
		r->disks = NULL;
	} else {
		EJS_ALLOC(ejs, r->disks);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->disks, r->count);
			for (i=0;i<r->count;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "disks", i);
				NDR_CHECK(ejs_pull_srvsvc_NetDiskInfo0(ejs, v, id, &r->disks[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "disks" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_Statistics(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_Statistics *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "start", &r->start));
	NDR_CHECK(ejs_push_uint32(ejs, v, "fopens", &r->fopens));
	NDR_CHECK(ejs_push_uint32(ejs, v, "devopens", &r->devopens));
	NDR_CHECK(ejs_push_uint32(ejs, v, "jobsqueued", &r->jobsqueued));
	NDR_CHECK(ejs_push_uint32(ejs, v, "sopens", &r->sopens));
	NDR_CHECK(ejs_push_uint32(ejs, v, "stimeouts", &r->stimeouts));
	NDR_CHECK(ejs_push_uint32(ejs, v, "serrorout", &r->serrorout));
	NDR_CHECK(ejs_push_uint32(ejs, v, "pwerrors", &r->pwerrors));
	NDR_CHECK(ejs_push_uint32(ejs, v, "permerrors", &r->permerrors));
	NDR_CHECK(ejs_push_uint32(ejs, v, "syserrors", &r->syserrors));
	NDR_CHECK(ejs_push_uint32(ejs, v, "bytessent_low", &r->bytessent_low));
	NDR_CHECK(ejs_push_uint32(ejs, v, "bytessent_high", &r->bytessent_high));
	NDR_CHECK(ejs_push_uint32(ejs, v, "bytesrcvd_low", &r->bytesrcvd_low));
	NDR_CHECK(ejs_push_uint32(ejs, v, "bytesrcvd_high", &r->bytesrcvd_high));
	NDR_CHECK(ejs_push_uint32(ejs, v, "avresponse", &r->avresponse));
	NDR_CHECK(ejs_push_uint32(ejs, v, "reqbufneed", &r->reqbufneed));
	NDR_CHECK(ejs_push_uint32(ejs, v, "bigbufneed", &r->bigbufneed));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetTransportInfo0(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetTransportInfo0 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "vcs", &r->vcs));
	if (NULL == r->name) {
		NDR_CHECK(ejs_push_null(ejs, v, "name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "name", r->name));
	}
	if (NULL == r->addr) {
		NDR_CHECK(ejs_push_null(ejs, v, "addr"));
	} else {
		ejs_push_array_uint8(ejs, v, "addr", r->addr, r->addr_len);
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "addr_len", &r->addr_len));
	if (NULL == r->net_addr) {
		NDR_CHECK(ejs_push_null(ejs, v, "net_addr"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "net_addr", r->net_addr));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetTransportInfo0(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetTransportInfo0 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "vcs", &r->vcs));
	if (ejs_pull_null(ejs, v, "name")) {
		r->name = NULL;
	} else {
		EJS_ALLOC(ejs, r->name);
		NDR_CHECK(ejs_pull_string(ejs, v, "name", &r->name));
	}
	if (ejs_pull_null(ejs, v, "addr")) {
		r->addr = NULL;
	} else {
		EJS_ALLOC(ejs, r->addr);
		EJS_ALLOC_N(ejs, r->addr, r->addr_len);
		ejs_pull_array_uint8(ejs, v, "addr", r->addr, r->addr_len);
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "addr_len", &r->addr_len));
	if (ejs_pull_null(ejs, v, "net_addr")) {
		r->net_addr = NULL;
	} else {
		EJS_ALLOC(ejs, r->net_addr);
		NDR_CHECK(ejs_pull_string(ejs, v, "net_addr", &r->net_addr));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetTransportCtr0(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetTransportCtr0 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->array) {
		NDR_CHECK(ejs_push_null(ejs, v, "array"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_push_srvsvc_NetTransportInfo0(ejs, v, id, &r->array[i]));
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetTransportCtr0(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetTransportCtr0 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	if (ejs_pull_null(ejs, v, "array")) {
		r->array = NULL;
	} else {
		EJS_ALLOC(ejs, r->array);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->array, r->count);
			for (i=0;i<r->count;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_pull_srvsvc_NetTransportInfo0(ejs, v, id, &r->array[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetTransportInfo1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetTransportInfo1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "vcs", &r->vcs));
	if (NULL == r->name) {
		NDR_CHECK(ejs_push_null(ejs, v, "name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "name", r->name));
	}
	if (NULL == r->addr) {
		NDR_CHECK(ejs_push_null(ejs, v, "addr"));
	} else {
		ejs_push_array_uint8(ejs, v, "addr", r->addr, r->addr_len);
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "addr_len", &r->addr_len));
	if (NULL == r->net_addr) {
		NDR_CHECK(ejs_push_null(ejs, v, "net_addr"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "net_addr", r->net_addr));
	}
	if (NULL == r->domain) {
		NDR_CHECK(ejs_push_null(ejs, v, "domain"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "domain", r->domain));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetTransportInfo1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetTransportInfo1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "vcs", &r->vcs));
	if (ejs_pull_null(ejs, v, "name")) {
		r->name = NULL;
	} else {
		EJS_ALLOC(ejs, r->name);
		NDR_CHECK(ejs_pull_string(ejs, v, "name", &r->name));
	}
	if (ejs_pull_null(ejs, v, "addr")) {
		r->addr = NULL;
	} else {
		EJS_ALLOC(ejs, r->addr);
		EJS_ALLOC_N(ejs, r->addr, r->addr_len);
		ejs_pull_array_uint8(ejs, v, "addr", r->addr, r->addr_len);
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "addr_len", &r->addr_len));
	if (ejs_pull_null(ejs, v, "net_addr")) {
		r->net_addr = NULL;
	} else {
		EJS_ALLOC(ejs, r->net_addr);
		NDR_CHECK(ejs_pull_string(ejs, v, "net_addr", &r->net_addr));
	}
	if (ejs_pull_null(ejs, v, "domain")) {
		r->domain = NULL;
	} else {
		EJS_ALLOC(ejs, r->domain);
		NDR_CHECK(ejs_pull_string(ejs, v, "domain", &r->domain));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetTransportCtr1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetTransportCtr1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->array) {
		NDR_CHECK(ejs_push_null(ejs, v, "array"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_push_srvsvc_NetTransportInfo1(ejs, v, id, &r->array[i]));
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetTransportCtr1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetTransportCtr1 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	if (ejs_pull_null(ejs, v, "array")) {
		r->array = NULL;
	} else {
		EJS_ALLOC(ejs, r->array);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->array, r->count);
			for (i=0;i<r->count;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_pull_srvsvc_NetTransportInfo1(ejs, v, id, &r->array[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetTransportInfo2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetTransportInfo2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "vcs", &r->vcs));
	if (NULL == r->name) {
		NDR_CHECK(ejs_push_null(ejs, v, "name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "name", r->name));
	}
	if (NULL == r->addr) {
		NDR_CHECK(ejs_push_null(ejs, v, "addr"));
	} else {
		ejs_push_array_uint8(ejs, v, "addr", r->addr, r->addr_len);
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "addr_len", &r->addr_len));
	if (NULL == r->net_addr) {
		NDR_CHECK(ejs_push_null(ejs, v, "net_addr"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "net_addr", r->net_addr));
	}
	if (NULL == r->domain) {
		NDR_CHECK(ejs_push_null(ejs, v, "domain"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "domain", r->domain));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown", &r->unknown));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetTransportInfo2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetTransportInfo2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "vcs", &r->vcs));
	if (ejs_pull_null(ejs, v, "name")) {
		r->name = NULL;
	} else {
		EJS_ALLOC(ejs, r->name);
		NDR_CHECK(ejs_pull_string(ejs, v, "name", &r->name));
	}
	if (ejs_pull_null(ejs, v, "addr")) {
		r->addr = NULL;
	} else {
		EJS_ALLOC(ejs, r->addr);
		EJS_ALLOC_N(ejs, r->addr, r->addr_len);
		ejs_pull_array_uint8(ejs, v, "addr", r->addr, r->addr_len);
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "addr_len", &r->addr_len));
	if (ejs_pull_null(ejs, v, "net_addr")) {
		r->net_addr = NULL;
	} else {
		EJS_ALLOC(ejs, r->net_addr);
		NDR_CHECK(ejs_pull_string(ejs, v, "net_addr", &r->net_addr));
	}
	if (ejs_pull_null(ejs, v, "domain")) {
		r->domain = NULL;
	} else {
		EJS_ALLOC(ejs, r->domain);
		NDR_CHECK(ejs_pull_string(ejs, v, "domain", &r->domain));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown", &r->unknown));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetTransportCtr2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetTransportCtr2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->array) {
		NDR_CHECK(ejs_push_null(ejs, v, "array"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_push_srvsvc_NetTransportInfo2(ejs, v, id, &r->array[i]));
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetTransportCtr2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetTransportCtr2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	if (ejs_pull_null(ejs, v, "array")) {
		r->array = NULL;
	} else {
		EJS_ALLOC(ejs, r->array);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->array, r->count);
			for (i=0;i<r->count;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_pull_srvsvc_NetTransportInfo2(ejs, v, id, &r->array[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetTransportInfo3(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetTransportInfo3 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "vcs", &r->vcs));
	if (NULL == r->name) {
		NDR_CHECK(ejs_push_null(ejs, v, "name"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "name", r->name));
	}
	if (NULL == r->addr) {
		NDR_CHECK(ejs_push_null(ejs, v, "addr"));
	} else {
		ejs_push_array_uint8(ejs, v, "addr", r->addr, r->addr_len);
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "addr_len", &r->addr_len));
	if (NULL == r->net_addr) {
		NDR_CHECK(ejs_push_null(ejs, v, "net_addr"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "net_addr", r->net_addr));
	}
	if (NULL == r->domain) {
		NDR_CHECK(ejs_push_null(ejs, v, "domain"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "domain", r->domain));
	}
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown1", &r->unknown1));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown2", &r->unknown2));
	ejs_push_array_uint8(ejs, v, "unknown3", r->unknown3, 256);
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetTransportInfo3(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetTransportInfo3 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "vcs", &r->vcs));
	if (ejs_pull_null(ejs, v, "name")) {
		r->name = NULL;
	} else {
		EJS_ALLOC(ejs, r->name);
		NDR_CHECK(ejs_pull_string(ejs, v, "name", &r->name));
	}
	if (ejs_pull_null(ejs, v, "addr")) {
		r->addr = NULL;
	} else {
		EJS_ALLOC(ejs, r->addr);
		EJS_ALLOC_N(ejs, r->addr, r->addr_len);
		ejs_pull_array_uint8(ejs, v, "addr", r->addr, r->addr_len);
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "addr_len", &r->addr_len));
	if (ejs_pull_null(ejs, v, "net_addr")) {
		r->net_addr = NULL;
	} else {
		EJS_ALLOC(ejs, r->net_addr);
		NDR_CHECK(ejs_pull_string(ejs, v, "net_addr", &r->net_addr));
	}
	if (ejs_pull_null(ejs, v, "domain")) {
		r->domain = NULL;
	} else {
		EJS_ALLOC(ejs, r->domain);
		NDR_CHECK(ejs_pull_string(ejs, v, "domain", &r->domain));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown1", &r->unknown1));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown2", &r->unknown2));
	ejs_pull_array_uint8(ejs, v, "unknown3", r->unknown3, 256);
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetTransportCtr3(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetTransportCtr3 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "count", &r->count));
	if (NULL == r->array) {
		NDR_CHECK(ejs_push_null(ejs, v, "array"));
	} else {
		{
			uint32_t i;
			for (i=0;i<r->count;i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_push_srvsvc_NetTransportInfo3(ejs, v, id, &r->array[i]));
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetTransportCtr3(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct srvsvc_NetTransportCtr3 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "count", &r->count));
	if (ejs_pull_null(ejs, v, "array")) {
		r->array = NULL;
	} else {
		EJS_ALLOC(ejs, r->array);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->array, r->count);
			for (i=0;i<r->count;i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "array", i);
				NDR_CHECK(ejs_pull_srvsvc_NetTransportInfo3(ejs, v, id, &r->array[i]));
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "array" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_srvsvc_NetTransportCtr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union srvsvc_NetTransportCtr *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 0:
			if (NULL == r->ctr0) {
				NDR_CHECK(ejs_push_null(ejs, v, "ctr0"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetTransportCtr0(ejs, v, "ctr0", r->ctr0));
			}
			break;
		case 1:
			if (NULL == r->ctr1) {
				NDR_CHECK(ejs_push_null(ejs, v, "ctr1"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetTransportCtr1(ejs, v, "ctr1", r->ctr1));
			}
			break;
		case 2:
			if (NULL == r->ctr2) {
				NDR_CHECK(ejs_push_null(ejs, v, "ctr2"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetTransportCtr2(ejs, v, "ctr2", r->ctr2));
			}
			break;
		case 3:
			if (NULL == r->ctr3) {
				NDR_CHECK(ejs_push_null(ejs, v, "ctr3"));
			} else {
				NDR_CHECK(ejs_push_srvsvc_NetTransportCtr3(ejs, v, "ctr3", r->ctr3));
			}
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_srvsvc_NetTransportCtr(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union srvsvc_NetTransportCtr *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 0:
			if (ejs_pull_null(ejs, v, "ctr0")) {
				r->ctr0 = NULL;
			} else {
				EJS_ALLOC(ejs, r->ctr0);
				NDR_CHECK(ejs_pull_srvsvc_NetTransportCtr0(ejs, v, "ctr0", r->ctr0));
			}
			break;
		case 1:
			if (ejs_pull_null(ejs, v, "ctr1")) {
				r->ctr1 = NULL;
			} else {
				EJS_ALLOC(ejs, r->ctr1);
				NDR_CHECK(ejs_pull_srvsvc_NetTransportCtr1(ejs, v, "ctr1", r->ctr1));
			}
			break;
		case 2:
			if (ejs_pull_null(ejs, v, "ctr2")) {
				r->ctr2 = NULL;
			} else {
				EJS_ALLOC(ejs, r->ctr2);
				NDR_CHECK(ejs_pull_srvsvc_NetTransportCtr2(ejs, v, "ctr2", r->ctr2));
			}
			break;
		case 3:
			if (ejs_pull_null(ejs, v, "ctr3")) {
				r->ctr3 = NULL;
			} else {
				EJS_ALLOC(ejs, r->ctr3);
				NDR_CHECK(ejs_pull_srvsvc_NetTransportCtr3(ejs, v, "ctr3", r->ctr3));
			}
			break;
		default:
			break;
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_srvsvc_NetRemoteTODInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct srvsvc_NetRemoteTODInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "elapsed", &r->elapsed));
	NDR_CHECK(ejs_push_uint32(ejs, v, "msecs", &r->msecs));
	NDR_CHECK(ejs_push_uint32(ejs, v, "hours", &r->hours));
	NDR_CHECK(ejs_push_uint32(ejs, v, "mins", &r->mins));
	NDR_CHECK(ejs_push_uint32(ejs, v, "secs", &r->secs));
	NDR_CHECK(ejs_push_uint32(ejs, v, "hunds", &r->hunds));
	NDR_CHECK(ejs_push_int32(ejs, v, "timezone", &r->timezone));
	NDR_CHECK(ejs_push_uint32(ejs, v, "tinterval", &r->tinterval));
	NDR_CHECK(ejs_push_uint32(ejs, v, "day", &r->day));
	NDR_CHECK(ejs_push_uint32(ejs, v, "month", &r->month));
	NDR_CHECK(ejs_push_uint32(ejs, v, "year", &r->year));
	NDR_CHECK(ejs_push_uint32(ejs, v, "weekday", &r->weekday));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetTransportInfo(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union srvsvc_NetTransportInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 0:
			NDR_CHECK(ejs_pull_srvsvc_NetTransportInfo0(ejs, v, "info0", &r->info0));
			break;
		case 1:
			NDR_CHECK(ejs_pull_srvsvc_NetTransportInfo1(ejs, v, "info1", &r->info1));
			break;
		case 2:
			NDR_CHECK(ejs_pull_srvsvc_NetTransportInfo2(ejs, v, "info2", &r->info2));
			break;
		case 3:
			NDR_CHECK(ejs_pull_srvsvc_NetTransportInfo3(ejs, v, "info3", &r->info3));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_srvsvc_NetCharDevEnum(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NetCharDevEnum *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_unc")) {
		r->in.server_unc = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_unc);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_unc", &r->in.server_unc));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	ejs_set_switch(ejs, r->in.level);
	NDR_CHECK(ejs_pull_srvsvc_NetCharDevCtr(ejs, v, "ctr", &r->in.ctr));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "max_buffer", &r->in.max_buffer));
	if (ejs_pull_null(ejs, v, "resume_handle")) {
		r->in.resume_handle = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.resume_handle);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "resume_handle", r->in.resume_handle));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NetCharDevEnum(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NetCharDevEnum *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_uint32(ejs, v, "level", &r->out.level));
	ejs_set_switch(ejs, r->out.level);
	NDR_CHECK(ejs_push_srvsvc_NetCharDevCtr(ejs, v, "ctr", &r->out.ctr));
	NDR_CHECK(ejs_push_uint32(ejs, v, "totalentries", &r->out.totalentries));
	if (NULL == r->out.resume_handle) {
		NDR_CHECK(ejs_push_null(ejs, v, "resume_handle"));
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "resume_handle", r->out.resume_handle));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NetCharDevEnum(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETCHARDEVENUM, (ejs_pull_function_t)ejs_pull_srvsvc_NetCharDevEnum, (ejs_push_function_t)ejs_push_srvsvc_NetCharDevEnum);
}


static NTSTATUS ejs_pull_srvsvc_NetCharDevGetInfo(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NetCharDevGetInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_unc")) {
		r->in.server_unc = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_unc);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_unc", &r->in.server_unc));
	}
	NDR_CHECK(ejs_pull_string(ejs, v, "device_name", &r->in.device_name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NetCharDevGetInfo(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NetCharDevGetInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	ejs_set_switch(ejs, r->in.level);
	NDR_CHECK(ejs_push_srvsvc_NetCharDevInfo(ejs, v, "info", &r->out.info));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NetCharDevGetInfo(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETCHARDEVGETINFO, (ejs_pull_function_t)ejs_pull_srvsvc_NetCharDevGetInfo, (ejs_push_function_t)ejs_push_srvsvc_NetCharDevGetInfo);
}


static NTSTATUS ejs_pull_srvsvc_NetCharDevControl(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NetCharDevControl *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_unc")) {
		r->in.server_unc = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_unc);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_unc", &r->in.server_unc));
	}
	NDR_CHECK(ejs_pull_string(ejs, v, "device_name", &r->in.device_name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "opcode", &r->in.opcode));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NetCharDevControl(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NetCharDevControl *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NetCharDevControl(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETCHARDEVCONTROL, (ejs_pull_function_t)ejs_pull_srvsvc_NetCharDevControl, (ejs_push_function_t)ejs_push_srvsvc_NetCharDevControl);
}


static NTSTATUS ejs_pull_srvsvc_NetCharDevQEnum(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NetCharDevQEnum *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_unc")) {
		r->in.server_unc = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_unc);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_unc", &r->in.server_unc));
	}
	if (ejs_pull_null(ejs, v, "user")) {
		r->in.user = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.user);
		NDR_CHECK(ejs_pull_string(ejs, v, "user", &r->in.user));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	ejs_set_switch(ejs, r->in.level);
	NDR_CHECK(ejs_pull_srvsvc_NetCharDevQCtr(ejs, v, "ctr", &r->in.ctr));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "max_buffer", &r->in.max_buffer));
	if (ejs_pull_null(ejs, v, "resume_handle")) {
		r->in.resume_handle = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.resume_handle);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "resume_handle", r->in.resume_handle));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NetCharDevQEnum(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NetCharDevQEnum *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_uint32(ejs, v, "level", &r->out.level));
	ejs_set_switch(ejs, r->out.level);
	NDR_CHECK(ejs_push_srvsvc_NetCharDevQCtr(ejs, v, "ctr", &r->out.ctr));
	NDR_CHECK(ejs_push_uint32(ejs, v, "totalentries", &r->out.totalentries));
	if (NULL == r->out.resume_handle) {
		NDR_CHECK(ejs_push_null(ejs, v, "resume_handle"));
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "resume_handle", r->out.resume_handle));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NetCharDevQEnum(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETCHARDEVQENUM, (ejs_pull_function_t)ejs_pull_srvsvc_NetCharDevQEnum, (ejs_push_function_t)ejs_push_srvsvc_NetCharDevQEnum);
}


static NTSTATUS ejs_pull_srvsvc_NetCharDevQGetInfo(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NetCharDevQGetInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_unc")) {
		r->in.server_unc = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_unc);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_unc", &r->in.server_unc));
	}
	NDR_CHECK(ejs_pull_string(ejs, v, "queue_name", &r->in.queue_name));
	NDR_CHECK(ejs_pull_string(ejs, v, "user", &r->in.user));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NetCharDevQGetInfo(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NetCharDevQGetInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	ejs_set_switch(ejs, r->in.level);
	NDR_CHECK(ejs_push_srvsvc_NetCharDevQInfo(ejs, v, "info", &r->out.info));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NetCharDevQGetInfo(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETCHARDEVQGETINFO, (ejs_pull_function_t)ejs_pull_srvsvc_NetCharDevQGetInfo, (ejs_push_function_t)ejs_push_srvsvc_NetCharDevQGetInfo);
}


static NTSTATUS ejs_pull_srvsvc_NetCharDevQSetInfo(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NetCharDevQSetInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_unc")) {
		r->in.server_unc = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_unc);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_unc", &r->in.server_unc));
	}
	NDR_CHECK(ejs_pull_string(ejs, v, "queue_name", &r->in.queue_name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	ejs_set_switch(ejs, r->in.level);
	NDR_CHECK(ejs_pull_srvsvc_NetCharDevQInfo(ejs, v, "info", &r->in.info));
	if (ejs_pull_null(ejs, v, "parm_error")) {
		r->in.parm_error = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.parm_error);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "parm_error", r->in.parm_error));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NetCharDevQSetInfo(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NetCharDevQSetInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.parm_error) {
		NDR_CHECK(ejs_push_null(ejs, v, "parm_error"));
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "parm_error", r->out.parm_error));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NetCharDevQSetInfo(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETCHARDEVQSETINFO, (ejs_pull_function_t)ejs_pull_srvsvc_NetCharDevQSetInfo, (ejs_push_function_t)ejs_push_srvsvc_NetCharDevQSetInfo);
}


static NTSTATUS ejs_pull_srvsvc_NetCharDevQPurge(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NetCharDevQPurge *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_unc")) {
		r->in.server_unc = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_unc);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_unc", &r->in.server_unc));
	}
	NDR_CHECK(ejs_pull_string(ejs, v, "queue_name", &r->in.queue_name));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NetCharDevQPurge(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NetCharDevQPurge *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NetCharDevQPurge(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETCHARDEVQPURGE, (ejs_pull_function_t)ejs_pull_srvsvc_NetCharDevQPurge, (ejs_push_function_t)ejs_push_srvsvc_NetCharDevQPurge);
}


static NTSTATUS ejs_pull_srvsvc_NetCharDevQPurgeSelf(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NetCharDevQPurgeSelf *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_unc")) {
		r->in.server_unc = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_unc);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_unc", &r->in.server_unc));
	}
	NDR_CHECK(ejs_pull_string(ejs, v, "queue_name", &r->in.queue_name));
	NDR_CHECK(ejs_pull_string(ejs, v, "computer_name", &r->in.computer_name));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NetCharDevQPurgeSelf(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NetCharDevQPurgeSelf *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NetCharDevQPurgeSelf(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETCHARDEVQPURGESELF, (ejs_pull_function_t)ejs_pull_srvsvc_NetCharDevQPurgeSelf, (ejs_push_function_t)ejs_push_srvsvc_NetCharDevQPurgeSelf);
}


static NTSTATUS ejs_pull_srvsvc_NetConnEnum(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NetConnEnum *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_unc")) {
		r->in.server_unc = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_unc);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_unc", &r->in.server_unc));
	}
	if (ejs_pull_null(ejs, v, "path")) {
		r->in.path = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.path);
		NDR_CHECK(ejs_pull_string(ejs, v, "path", &r->in.path));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	ejs_set_switch(ejs, r->in.level);
	NDR_CHECK(ejs_pull_srvsvc_NetConnCtr(ejs, v, "ctr", &r->in.ctr));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "max_buffer", &r->in.max_buffer));
	if (ejs_pull_null(ejs, v, "resume_handle")) {
		r->in.resume_handle = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.resume_handle);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "resume_handle", r->in.resume_handle));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NetConnEnum(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NetConnEnum *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_uint32(ejs, v, "level", &r->out.level));
	ejs_set_switch(ejs, r->out.level);
	NDR_CHECK(ejs_push_srvsvc_NetConnCtr(ejs, v, "ctr", &r->out.ctr));
	NDR_CHECK(ejs_push_uint32(ejs, v, "totalentries", &r->out.totalentries));
	if (NULL == r->out.resume_handle) {
		NDR_CHECK(ejs_push_null(ejs, v, "resume_handle"));
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "resume_handle", r->out.resume_handle));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NetConnEnum(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETCONNENUM, (ejs_pull_function_t)ejs_pull_srvsvc_NetConnEnum, (ejs_push_function_t)ejs_push_srvsvc_NetConnEnum);
}


static NTSTATUS ejs_pull_srvsvc_NetFileEnum(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NetFileEnum *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_unc")) {
		r->in.server_unc = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_unc);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_unc", &r->in.server_unc));
	}
	if (ejs_pull_null(ejs, v, "path")) {
		r->in.path = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.path);
		NDR_CHECK(ejs_pull_string(ejs, v, "path", &r->in.path));
	}
	if (ejs_pull_null(ejs, v, "user")) {
		r->in.user = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.user);
		NDR_CHECK(ejs_pull_string(ejs, v, "user", &r->in.user));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	ejs_set_switch(ejs, r->in.level);
	NDR_CHECK(ejs_pull_srvsvc_NetFileCtr(ejs, v, "ctr", &r->in.ctr));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "max_buffer", &r->in.max_buffer));
	if (ejs_pull_null(ejs, v, "resume_handle")) {
		r->in.resume_handle = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.resume_handle);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "resume_handle", r->in.resume_handle));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NetFileEnum(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NetFileEnum *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_uint32(ejs, v, "level", &r->out.level));
	ejs_set_switch(ejs, r->out.level);
	NDR_CHECK(ejs_push_srvsvc_NetFileCtr(ejs, v, "ctr", &r->out.ctr));
	NDR_CHECK(ejs_push_uint32(ejs, v, "totalentries", &r->out.totalentries));
	if (NULL == r->out.resume_handle) {
		NDR_CHECK(ejs_push_null(ejs, v, "resume_handle"));
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "resume_handle", r->out.resume_handle));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NetFileEnum(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETFILEENUM, (ejs_pull_function_t)ejs_pull_srvsvc_NetFileEnum, (ejs_push_function_t)ejs_push_srvsvc_NetFileEnum);
}


static NTSTATUS ejs_pull_srvsvc_NetFileGetInfo(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NetFileGetInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_unc")) {
		r->in.server_unc = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_unc);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_unc", &r->in.server_unc));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "fid", &r->in.fid));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NetFileGetInfo(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NetFileGetInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	ejs_set_switch(ejs, r->in.level);
	NDR_CHECK(ejs_push_srvsvc_NetFileInfo(ejs, v, "info", &r->out.info));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NetFileGetInfo(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETFILEGETINFO, (ejs_pull_function_t)ejs_pull_srvsvc_NetFileGetInfo, (ejs_push_function_t)ejs_push_srvsvc_NetFileGetInfo);
}


static NTSTATUS ejs_pull_srvsvc_NetFileClose(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NetFileClose *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_unc")) {
		r->in.server_unc = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_unc);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_unc", &r->in.server_unc));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "fid", &r->in.fid));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NetFileClose(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NetFileClose *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NetFileClose(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETFILECLOSE, (ejs_pull_function_t)ejs_pull_srvsvc_NetFileClose, (ejs_push_function_t)ejs_push_srvsvc_NetFileClose);
}


static NTSTATUS ejs_pull_srvsvc_NetSessEnum(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NetSessEnum *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_unc")) {
		r->in.server_unc = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_unc);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_unc", &r->in.server_unc));
	}
	if (ejs_pull_null(ejs, v, "client")) {
		r->in.client = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.client);
		NDR_CHECK(ejs_pull_string(ejs, v, "client", &r->in.client));
	}
	if (ejs_pull_null(ejs, v, "user")) {
		r->in.user = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.user);
		NDR_CHECK(ejs_pull_string(ejs, v, "user", &r->in.user));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	ejs_set_switch(ejs, r->in.level);
	NDR_CHECK(ejs_pull_srvsvc_NetSessCtr(ejs, v, "ctr", &r->in.ctr));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "max_buffer", &r->in.max_buffer));
	if (ejs_pull_null(ejs, v, "resume_handle")) {
		r->in.resume_handle = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.resume_handle);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "resume_handle", r->in.resume_handle));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NetSessEnum(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NetSessEnum *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_uint32(ejs, v, "level", &r->out.level));
	ejs_set_switch(ejs, r->out.level);
	NDR_CHECK(ejs_push_srvsvc_NetSessCtr(ejs, v, "ctr", &r->out.ctr));
	NDR_CHECK(ejs_push_uint32(ejs, v, "totalentries", &r->out.totalentries));
	if (NULL == r->out.resume_handle) {
		NDR_CHECK(ejs_push_null(ejs, v, "resume_handle"));
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "resume_handle", r->out.resume_handle));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NetSessEnum(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETSESSENUM, (ejs_pull_function_t)ejs_pull_srvsvc_NetSessEnum, (ejs_push_function_t)ejs_push_srvsvc_NetSessEnum);
}


static NTSTATUS ejs_pull_srvsvc_NetSessDel(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NetSessDel *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_unc")) {
		r->in.server_unc = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_unc);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_unc", &r->in.server_unc));
	}
	if (ejs_pull_null(ejs, v, "client")) {
		r->in.client = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.client);
		NDR_CHECK(ejs_pull_string(ejs, v, "client", &r->in.client));
	}
	if (ejs_pull_null(ejs, v, "user")) {
		r->in.user = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.user);
		NDR_CHECK(ejs_pull_string(ejs, v, "user", &r->in.user));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NetSessDel(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NetSessDel *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NetSessDel(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETSESSDEL, (ejs_pull_function_t)ejs_pull_srvsvc_NetSessDel, (ejs_push_function_t)ejs_push_srvsvc_NetSessDel);
}


static NTSTATUS ejs_pull_srvsvc_NetShareAdd(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NetShareAdd *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_unc")) {
		r->in.server_unc = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_unc);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_unc", &r->in.server_unc));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	ejs_set_switch(ejs, r->in.level);
	NDR_CHECK(ejs_pull_srvsvc_NetShareInfo(ejs, v, "info", &r->in.info));
	if (ejs_pull_null(ejs, v, "parm_error")) {
		r->in.parm_error = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.parm_error);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "parm_error", r->in.parm_error));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NetShareAdd(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NetShareAdd *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.parm_error) {
		NDR_CHECK(ejs_push_null(ejs, v, "parm_error"));
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "parm_error", r->out.parm_error));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NetShareAdd(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETSHAREADD, (ejs_pull_function_t)ejs_pull_srvsvc_NetShareAdd, (ejs_push_function_t)ejs_push_srvsvc_NetShareAdd);
}


static NTSTATUS ejs_pull_srvsvc_NetShareEnumAll(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NetShareEnumAll *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_unc")) {
		r->in.server_unc = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_unc);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_unc", &r->in.server_unc));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	ejs_set_switch(ejs, r->in.level);
	NDR_CHECK(ejs_pull_srvsvc_NetShareCtr(ejs, v, "ctr", &r->in.ctr));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "max_buffer", &r->in.max_buffer));
	if (ejs_pull_null(ejs, v, "resume_handle")) {
		r->in.resume_handle = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.resume_handle);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "resume_handle", r->in.resume_handle));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NetShareEnumAll(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NetShareEnumAll *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_uint32(ejs, v, "level", &r->out.level));
	ejs_set_switch(ejs, r->out.level);
	NDR_CHECK(ejs_push_srvsvc_NetShareCtr(ejs, v, "ctr", &r->out.ctr));
	NDR_CHECK(ejs_push_uint32(ejs, v, "totalentries", &r->out.totalentries));
	if (NULL == r->out.resume_handle) {
		NDR_CHECK(ejs_push_null(ejs, v, "resume_handle"));
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "resume_handle", r->out.resume_handle));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NetShareEnumAll(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETSHAREENUMALL, (ejs_pull_function_t)ejs_pull_srvsvc_NetShareEnumAll, (ejs_push_function_t)ejs_push_srvsvc_NetShareEnumAll);
}


static NTSTATUS ejs_pull_srvsvc_NetShareGetInfo(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NetShareGetInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_unc")) {
		r->in.server_unc = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_unc);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_unc", &r->in.server_unc));
	}
	NDR_CHECK(ejs_pull_string(ejs, v, "share_name", &r->in.share_name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NetShareGetInfo(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NetShareGetInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	ejs_set_switch(ejs, r->in.level);
	NDR_CHECK(ejs_push_srvsvc_NetShareInfo(ejs, v, "info", &r->out.info));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NetShareGetInfo(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETSHAREGETINFO, (ejs_pull_function_t)ejs_pull_srvsvc_NetShareGetInfo, (ejs_push_function_t)ejs_push_srvsvc_NetShareGetInfo);
}


static NTSTATUS ejs_pull_srvsvc_NetShareSetInfo(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NetShareSetInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_unc")) {
		r->in.server_unc = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_unc);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_unc", &r->in.server_unc));
	}
	NDR_CHECK(ejs_pull_string(ejs, v, "share_name", &r->in.share_name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	ejs_set_switch(ejs, r->in.level);
	NDR_CHECK(ejs_pull_srvsvc_NetShareInfo(ejs, v, "info", &r->in.info));
	if (ejs_pull_null(ejs, v, "parm_error")) {
		r->in.parm_error = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.parm_error);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "parm_error", r->in.parm_error));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NetShareSetInfo(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NetShareSetInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.parm_error) {
		NDR_CHECK(ejs_push_null(ejs, v, "parm_error"));
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "parm_error", r->out.parm_error));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NetShareSetInfo(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETSHARESETINFO, (ejs_pull_function_t)ejs_pull_srvsvc_NetShareSetInfo, (ejs_push_function_t)ejs_push_srvsvc_NetShareSetInfo);
}


static NTSTATUS ejs_pull_srvsvc_NetShareDel(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NetShareDel *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_unc")) {
		r->in.server_unc = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_unc);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_unc", &r->in.server_unc));
	}
	NDR_CHECK(ejs_pull_string(ejs, v, "share_name", &r->in.share_name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "reserved", &r->in.reserved));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NetShareDel(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NetShareDel *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NetShareDel(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETSHAREDEL, (ejs_pull_function_t)ejs_pull_srvsvc_NetShareDel, (ejs_push_function_t)ejs_push_srvsvc_NetShareDel);
}


static NTSTATUS ejs_pull_srvsvc_NetShareDelSticky(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NetShareDelSticky *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_unc")) {
		r->in.server_unc = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_unc);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_unc", &r->in.server_unc));
	}
	NDR_CHECK(ejs_pull_string(ejs, v, "share_name", &r->in.share_name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "reserved", &r->in.reserved));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NetShareDelSticky(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NetShareDelSticky *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NetShareDelSticky(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETSHAREDELSTICKY, (ejs_pull_function_t)ejs_pull_srvsvc_NetShareDelSticky, (ejs_push_function_t)ejs_push_srvsvc_NetShareDelSticky);
}


static NTSTATUS ejs_pull_srvsvc_NetShareCheck(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NetShareCheck *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_unc")) {
		r->in.server_unc = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_unc);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_unc", &r->in.server_unc));
	}
	NDR_CHECK(ejs_pull_string(ejs, v, "device_name", &r->in.device_name));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NetShareCheck(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NetShareCheck *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_srvsvc_ShareType(ejs, v, "type", &r->out.type));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NetShareCheck(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETSHARECHECK, (ejs_pull_function_t)ejs_pull_srvsvc_NetShareCheck, (ejs_push_function_t)ejs_push_srvsvc_NetShareCheck);
}


static NTSTATUS ejs_pull_srvsvc_NetSrvGetInfo(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NetSrvGetInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_unc")) {
		r->in.server_unc = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_unc);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_unc", &r->in.server_unc));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NetSrvGetInfo(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NetSrvGetInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	ejs_set_switch(ejs, r->in.level);
	NDR_CHECK(ejs_push_srvsvc_NetSrvInfo(ejs, v, "info", &r->out.info));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NetSrvGetInfo(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETSRVGETINFO, (ejs_pull_function_t)ejs_pull_srvsvc_NetSrvGetInfo, (ejs_push_function_t)ejs_push_srvsvc_NetSrvGetInfo);
}


static NTSTATUS ejs_pull_srvsvc_NetSrvSetInfo(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NetSrvSetInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_unc")) {
		r->in.server_unc = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_unc);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_unc", &r->in.server_unc));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	ejs_set_switch(ejs, r->in.level);
	NDR_CHECK(ejs_pull_srvsvc_NetSrvInfo(ejs, v, "info", &r->in.info));
	if (ejs_pull_null(ejs, v, "parm_error")) {
		r->in.parm_error = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.parm_error);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "parm_error", r->in.parm_error));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NetSrvSetInfo(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NetSrvSetInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.parm_error) {
		NDR_CHECK(ejs_push_null(ejs, v, "parm_error"));
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "parm_error", r->out.parm_error));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NetSrvSetInfo(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETSRVSETINFO, (ejs_pull_function_t)ejs_pull_srvsvc_NetSrvSetInfo, (ejs_push_function_t)ejs_push_srvsvc_NetSrvSetInfo);
}


static NTSTATUS ejs_pull_srvsvc_NetDiskEnum(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NetDiskEnum *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_unc")) {
		r->in.server_unc = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_unc);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_unc", &r->in.server_unc));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	NDR_CHECK(ejs_pull_srvsvc_NetDiskInfo(ejs, v, "info", &r->in.info));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "maxlen", &r->in.maxlen));
	if (ejs_pull_null(ejs, v, "resume_handle")) {
		r->in.resume_handle = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.resume_handle);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "resume_handle", r->in.resume_handle));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NetDiskEnum(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NetDiskEnum *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_srvsvc_NetDiskInfo(ejs, v, "info", &r->out.info));
	NDR_CHECK(ejs_push_uint32(ejs, v, "totalentries", &r->out.totalentries));
	if (NULL == r->out.resume_handle) {
		NDR_CHECK(ejs_push_null(ejs, v, "resume_handle"));
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "resume_handle", r->out.resume_handle));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NetDiskEnum(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETDISKENUM, (ejs_pull_function_t)ejs_pull_srvsvc_NetDiskEnum, (ejs_push_function_t)ejs_push_srvsvc_NetDiskEnum);
}


static NTSTATUS ejs_pull_srvsvc_NetServerStatisticsGet(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NetServerStatisticsGet *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_unc")) {
		r->in.server_unc = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_unc);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_unc", &r->in.server_unc));
	}
	if (ejs_pull_null(ejs, v, "service")) {
		r->in.service = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.service);
		NDR_CHECK(ejs_pull_string(ejs, v, "service", &r->in.service));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "options", &r->in.options));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NetServerStatisticsGet(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NetServerStatisticsGet *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_srvsvc_Statistics(ejs, v, "stat", &r->out.stat));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NetServerStatisticsGet(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETSERVERSTATISTICSGET, (ejs_pull_function_t)ejs_pull_srvsvc_NetServerStatisticsGet, (ejs_push_function_t)ejs_push_srvsvc_NetServerStatisticsGet);
}


static NTSTATUS ejs_pull_srvsvc_NetTransportAdd(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NetTransportAdd *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_unc")) {
		r->in.server_unc = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_unc);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_unc", &r->in.server_unc));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	ejs_set_switch(ejs, r->in.level);
	NDR_CHECK(ejs_pull_srvsvc_NetTransportInfo(ejs, v, "info", &r->in.info));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NetTransportAdd(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NetTransportAdd *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NetTransportAdd(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETTRANSPORTADD, (ejs_pull_function_t)ejs_pull_srvsvc_NetTransportAdd, (ejs_push_function_t)ejs_push_srvsvc_NetTransportAdd);
}


static NTSTATUS ejs_pull_srvsvc_NetTransportEnum(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NetTransportEnum *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_unc")) {
		r->in.server_unc = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_unc);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_unc", &r->in.server_unc));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	ejs_set_switch(ejs, r->in.level);
	NDR_CHECK(ejs_pull_srvsvc_NetTransportCtr(ejs, v, "transports", &r->in.transports));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "max_buffer", &r->in.max_buffer));
	if (ejs_pull_null(ejs, v, "resume_handle")) {
		r->in.resume_handle = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.resume_handle);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "resume_handle", r->in.resume_handle));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NetTransportEnum(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NetTransportEnum *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_uint32(ejs, v, "level", &r->out.level));
	ejs_set_switch(ejs, r->out.level);
	NDR_CHECK(ejs_push_srvsvc_NetTransportCtr(ejs, v, "transports", &r->out.transports));
	NDR_CHECK(ejs_push_uint32(ejs, v, "totalentries", &r->out.totalentries));
	if (NULL == r->out.resume_handle) {
		NDR_CHECK(ejs_push_null(ejs, v, "resume_handle"));
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "resume_handle", r->out.resume_handle));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NetTransportEnum(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETTRANSPORTENUM, (ejs_pull_function_t)ejs_pull_srvsvc_NetTransportEnum, (ejs_push_function_t)ejs_push_srvsvc_NetTransportEnum);
}


static NTSTATUS ejs_pull_srvsvc_NetTransportDel(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NetTransportDel *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_unc")) {
		r->in.server_unc = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_unc);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_unc", &r->in.server_unc));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	ejs_set_switch(ejs, r->in.level);
	NDR_CHECK(ejs_pull_srvsvc_NetTransportInfo(ejs, v, "info", &r->in.info));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NetTransportDel(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NetTransportDel *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NetTransportDel(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETTRANSPORTDEL, (ejs_pull_function_t)ejs_pull_srvsvc_NetTransportDel, (ejs_push_function_t)ejs_push_srvsvc_NetTransportDel);
}


static NTSTATUS ejs_pull_srvsvc_NetRemoteTOD(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NetRemoteTOD *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_unc")) {
		r->in.server_unc = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_unc);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_unc", &r->in.server_unc));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NetRemoteTOD(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NetRemoteTOD *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.info) {
		NDR_CHECK(ejs_push_null(ejs, v, "info"));
	} else {
		NDR_CHECK(ejs_push_srvsvc_NetRemoteTODInfo(ejs, v, "info", r->out.info));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NetRemoteTOD(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETREMOTETOD, (ejs_pull_function_t)ejs_pull_srvsvc_NetRemoteTOD, (ejs_push_function_t)ejs_push_srvsvc_NetRemoteTOD);
}


static NTSTATUS ejs_pull_srvsvc_NetSetServiceBits(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NetSetServiceBits *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_unc")) {
		r->in.server_unc = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_unc);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_unc", &r->in.server_unc));
	}
	if (ejs_pull_null(ejs, v, "transport")) {
		r->in.transport = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.transport);
		NDR_CHECK(ejs_pull_string(ejs, v, "transport", &r->in.transport));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "servicebits", &r->in.servicebits));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "updateimmediately", &r->in.updateimmediately));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NetSetServiceBits(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NetSetServiceBits *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NetSetServiceBits(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETSETSERVICEBITS, (ejs_pull_function_t)ejs_pull_srvsvc_NetSetServiceBits, (ejs_push_function_t)ejs_push_srvsvc_NetSetServiceBits);
}


static NTSTATUS ejs_pull_srvsvc_NetPathType(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NetPathType *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_unc")) {
		r->in.server_unc = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_unc);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_unc", &r->in.server_unc));
	}
	NDR_CHECK(ejs_pull_string(ejs, v, "path", &r->in.path));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "pathflags", &r->in.pathflags));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NetPathType(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NetPathType *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_uint32(ejs, v, "pathtype", &r->out.pathtype));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NetPathType(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETPATHTYPE, (ejs_pull_function_t)ejs_pull_srvsvc_NetPathType, (ejs_push_function_t)ejs_push_srvsvc_NetPathType);
}


static NTSTATUS ejs_pull_srvsvc_NetPathCanonicalize(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NetPathCanonicalize *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_unc")) {
		r->in.server_unc = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_unc);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_unc", &r->in.server_unc));
	}
	NDR_CHECK(ejs_pull_string(ejs, v, "path", &r->in.path));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "maxbuf", &r->in.maxbuf));
	NDR_CHECK(ejs_pull_string(ejs, v, "prefix", &r->in.prefix));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "pathtype", &r->in.pathtype));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "pathflags", &r->in.pathflags));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NetPathCanonicalize(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NetPathCanonicalize *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	ejs_push_array_uint8(ejs, v, "can_path", r->out.can_path, r->in.maxbuf);
	NDR_CHECK(ejs_push_uint32(ejs, v, "pathtype", &r->out.pathtype));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NetPathCanonicalize(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETPATHCANONICALIZE, (ejs_pull_function_t)ejs_pull_srvsvc_NetPathCanonicalize, (ejs_push_function_t)ejs_push_srvsvc_NetPathCanonicalize);
}


static NTSTATUS ejs_pull_srvsvc_NetPathCompare(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NetPathCompare *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_unc")) {
		r->in.server_unc = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_unc);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_unc", &r->in.server_unc));
	}
	NDR_CHECK(ejs_pull_string(ejs, v, "path1", &r->in.path1));
	NDR_CHECK(ejs_pull_string(ejs, v, "path2", &r->in.path2));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "pathtype", &r->in.pathtype));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "pathflags", &r->in.pathflags));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NetPathCompare(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NetPathCompare *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NetPathCompare(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETPATHCOMPARE, (ejs_pull_function_t)ejs_pull_srvsvc_NetPathCompare, (ejs_push_function_t)ejs_push_srvsvc_NetPathCompare);
}


static NTSTATUS ejs_pull_srvsvc_NetNameValidate(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NetNameValidate *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_unc")) {
		r->in.server_unc = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_unc);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_unc", &r->in.server_unc));
	}
	NDR_CHECK(ejs_pull_string(ejs, v, "name", &r->in.name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "name_type", &r->in.name_type));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "flags", &r->in.flags));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NetNameValidate(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NetNameValidate *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NetNameValidate(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETNAMEVALIDATE, (ejs_pull_function_t)ejs_pull_srvsvc_NetNameValidate, (ejs_push_function_t)ejs_push_srvsvc_NetNameValidate);
}


static NTSTATUS ejs_pull_srvsvc_NETRPRNAMECANONICALIZE(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NETRPRNAMECANONICALIZE *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NETRPRNAMECANONICALIZE(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NETRPRNAMECANONICALIZE *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NETRPRNAMECANONICALIZE(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETRPRNAMECANONICALIZE, (ejs_pull_function_t)ejs_pull_srvsvc_NETRPRNAMECANONICALIZE, (ejs_push_function_t)ejs_push_srvsvc_NETRPRNAMECANONICALIZE);
}


static NTSTATUS ejs_pull_srvsvc_NetPRNameCompare(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NetPRNameCompare *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_unc")) {
		r->in.server_unc = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_unc);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_unc", &r->in.server_unc));
	}
	NDR_CHECK(ejs_pull_string(ejs, v, "name1", &r->in.name1));
	NDR_CHECK(ejs_pull_string(ejs, v, "name2", &r->in.name2));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "name_type", &r->in.name_type));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "flags", &r->in.flags));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NetPRNameCompare(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NetPRNameCompare *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NetPRNameCompare(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETPRNAMECOMPARE, (ejs_pull_function_t)ejs_pull_srvsvc_NetPRNameCompare, (ejs_push_function_t)ejs_push_srvsvc_NetPRNameCompare);
}


static NTSTATUS ejs_pull_srvsvc_NetShareEnum(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NetShareEnum *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_unc")) {
		r->in.server_unc = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_unc);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_unc", &r->in.server_unc));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	ejs_set_switch(ejs, r->in.level);
	NDR_CHECK(ejs_pull_srvsvc_NetShareCtr(ejs, v, "ctr", &r->in.ctr));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "max_buffer", &r->in.max_buffer));
	if (ejs_pull_null(ejs, v, "resume_handle")) {
		r->in.resume_handle = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.resume_handle);
		NDR_CHECK(ejs_pull_uint32(ejs, v, "resume_handle", r->in.resume_handle));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NetShareEnum(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NetShareEnum *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_uint32(ejs, v, "level", &r->out.level));
	ejs_set_switch(ejs, r->out.level);
	NDR_CHECK(ejs_push_srvsvc_NetShareCtr(ejs, v, "ctr", &r->out.ctr));
	NDR_CHECK(ejs_push_uint32(ejs, v, "totalentries", &r->out.totalentries));
	if (NULL == r->out.resume_handle) {
		NDR_CHECK(ejs_push_null(ejs, v, "resume_handle"));
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "resume_handle", r->out.resume_handle));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NetShareEnum(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETSHAREENUM, (ejs_pull_function_t)ejs_pull_srvsvc_NetShareEnum, (ejs_push_function_t)ejs_push_srvsvc_NetShareEnum);
}


static NTSTATUS ejs_pull_srvsvc_NetShareDelStart(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NetShareDelStart *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_unc")) {
		r->in.server_unc = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_unc);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_unc", &r->in.server_unc));
	}
	NDR_CHECK(ejs_pull_string(ejs, v, "share", &r->in.share));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "reserved", &r->in.reserved));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NetShareDelStart(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NetShareDelStart *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.hnd) {
		NDR_CHECK(ejs_push_null(ejs, v, "hnd"));
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "hnd", r->out.hnd));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NetShareDelStart(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETSHAREDELSTART, (ejs_pull_function_t)ejs_pull_srvsvc_NetShareDelStart, (ejs_push_function_t)ejs_push_srvsvc_NetShareDelStart);
}


static NTSTATUS ejs_pull_srvsvc_NetShareDelCommit(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NetShareDelCommit *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "hnd")) {
		r->in.hnd = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.hnd);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "hnd", r->in.hnd));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NetShareDelCommit(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NetShareDelCommit *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.hnd) {
		NDR_CHECK(ejs_push_null(ejs, v, "hnd"));
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "hnd", r->out.hnd));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NetShareDelCommit(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETSHAREDELCOMMIT, (ejs_pull_function_t)ejs_pull_srvsvc_NetShareDelCommit, (ejs_push_function_t)ejs_push_srvsvc_NetShareDelCommit);
}


static NTSTATUS ejs_pull_srvsvc_NetGetFileSecurity(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NetGetFileSecurity *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_unc")) {
		r->in.server_unc = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_unc);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_unc", &r->in.server_unc));
	}
	if (ejs_pull_null(ejs, v, "share")) {
		r->in.share = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.share);
		NDR_CHECK(ejs_pull_string(ejs, v, "share", &r->in.share));
	}
	NDR_CHECK(ejs_pull_string(ejs, v, "file", &r->in.file));
	NDR_CHECK(ejs_pull_security_secinfo(ejs, v, "securityinformation", &r->in.securityinformation));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NetGetFileSecurity(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NetGetFileSecurity *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.sd_buf) {
		NDR_CHECK(ejs_push_null(ejs, v, "sd_buf"));
	} else {
		NDR_CHECK(ejs_push_sec_desc_buf(ejs, v, "sd_buf", r->out.sd_buf));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NetGetFileSecurity(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETGETFILESECURITY, (ejs_pull_function_t)ejs_pull_srvsvc_NetGetFileSecurity, (ejs_push_function_t)ejs_push_srvsvc_NetGetFileSecurity);
}


static NTSTATUS ejs_pull_srvsvc_NetSetFileSecurity(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NetSetFileSecurity *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_unc")) {
		r->in.server_unc = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_unc);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_unc", &r->in.server_unc));
	}
	if (ejs_pull_null(ejs, v, "share")) {
		r->in.share = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.share);
		NDR_CHECK(ejs_pull_string(ejs, v, "share", &r->in.share));
	}
	NDR_CHECK(ejs_pull_string(ejs, v, "file", &r->in.file));
	NDR_CHECK(ejs_pull_security_secinfo(ejs, v, "securityinformation", &r->in.securityinformation));
	NDR_CHECK(ejs_pull_sec_desc_buf(ejs, v, "sd_buf", &r->in.sd_buf));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NetSetFileSecurity(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NetSetFileSecurity *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NetSetFileSecurity(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETSETFILESECURITY, (ejs_pull_function_t)ejs_pull_srvsvc_NetSetFileSecurity, (ejs_push_function_t)ejs_push_srvsvc_NetSetFileSecurity);
}


static NTSTATUS ejs_pull_srvsvc_NetServerTransportAddEx(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NetServerTransportAddEx *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_unc")) {
		r->in.server_unc = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_unc);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_unc", &r->in.server_unc));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "level", &r->in.level));
	ejs_set_switch(ejs, r->in.level);
	NDR_CHECK(ejs_pull_srvsvc_NetTransportInfo(ejs, v, "info", &r->in.info));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NetServerTransportAddEx(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NetServerTransportAddEx *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NetServerTransportAddEx(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETSERVERTRANSPORTADDEX, (ejs_pull_function_t)ejs_pull_srvsvc_NetServerTransportAddEx, (ejs_push_function_t)ejs_push_srvsvc_NetServerTransportAddEx);
}


static NTSTATUS ejs_pull_srvsvc_NetServerSetServiceBitsEx(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NetServerSetServiceBitsEx *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "server_unc")) {
		r->in.server_unc = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.server_unc);
		NDR_CHECK(ejs_pull_string(ejs, v, "server_unc", &r->in.server_unc));
	}
	if (ejs_pull_null(ejs, v, "emulated_server_unc")) {
		r->in.emulated_server_unc = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.emulated_server_unc);
		NDR_CHECK(ejs_pull_string(ejs, v, "emulated_server_unc", &r->in.emulated_server_unc));
	}
	if (ejs_pull_null(ejs, v, "transport")) {
		r->in.transport = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.transport);
		NDR_CHECK(ejs_pull_string(ejs, v, "transport", &r->in.transport));
	}
	NDR_CHECK(ejs_pull_uint32(ejs, v, "servicebitsofinterest", &r->in.servicebitsofinterest));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "servicebits", &r->in.servicebits));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "updateimmediately", &r->in.updateimmediately));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NetServerSetServiceBitsEx(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NetServerSetServiceBitsEx *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NetServerSetServiceBitsEx(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETSERVERSETSERVICEBITSEX, (ejs_pull_function_t)ejs_pull_srvsvc_NetServerSetServiceBitsEx, (ejs_push_function_t)ejs_push_srvsvc_NetServerSetServiceBitsEx);
}


static NTSTATUS ejs_pull_srvsvc_NETRDFSGETVERSION(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NETRDFSGETVERSION *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NETRDFSGETVERSION(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NETRDFSGETVERSION *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NETRDFSGETVERSION(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETRDFSGETVERSION, (ejs_pull_function_t)ejs_pull_srvsvc_NETRDFSGETVERSION, (ejs_push_function_t)ejs_push_srvsvc_NETRDFSGETVERSION);
}


static NTSTATUS ejs_pull_srvsvc_NETRDFSCREATELOCALPARTITION(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NETRDFSCREATELOCALPARTITION *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NETRDFSCREATELOCALPARTITION(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NETRDFSCREATELOCALPARTITION *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NETRDFSCREATELOCALPARTITION(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETRDFSCREATELOCALPARTITION, (ejs_pull_function_t)ejs_pull_srvsvc_NETRDFSCREATELOCALPARTITION, (ejs_push_function_t)ejs_push_srvsvc_NETRDFSCREATELOCALPARTITION);
}


static NTSTATUS ejs_pull_srvsvc_NETRDFSDELETELOCALPARTITION(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NETRDFSDELETELOCALPARTITION *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NETRDFSDELETELOCALPARTITION(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NETRDFSDELETELOCALPARTITION *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NETRDFSDELETELOCALPARTITION(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETRDFSDELETELOCALPARTITION, (ejs_pull_function_t)ejs_pull_srvsvc_NETRDFSDELETELOCALPARTITION, (ejs_push_function_t)ejs_push_srvsvc_NETRDFSDELETELOCALPARTITION);
}


static NTSTATUS ejs_pull_srvsvc_NETRDFSSETLOCALVOLUMESTATE(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NETRDFSSETLOCALVOLUMESTATE *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NETRDFSSETLOCALVOLUMESTATE(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NETRDFSSETLOCALVOLUMESTATE *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NETRDFSSETLOCALVOLUMESTATE(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETRDFSSETLOCALVOLUMESTATE, (ejs_pull_function_t)ejs_pull_srvsvc_NETRDFSSETLOCALVOLUMESTATE, (ejs_push_function_t)ejs_push_srvsvc_NETRDFSSETLOCALVOLUMESTATE);
}


static NTSTATUS ejs_pull_srvsvc_NETRDFSSETSERVERINFO(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NETRDFSSETSERVERINFO *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NETRDFSSETSERVERINFO(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NETRDFSSETSERVERINFO *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NETRDFSSETSERVERINFO(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETRDFSSETSERVERINFO, (ejs_pull_function_t)ejs_pull_srvsvc_NETRDFSSETSERVERINFO, (ejs_push_function_t)ejs_push_srvsvc_NETRDFSSETSERVERINFO);
}


static NTSTATUS ejs_pull_srvsvc_NETRDFSCREATEEXITPOINT(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NETRDFSCREATEEXITPOINT *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NETRDFSCREATEEXITPOINT(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NETRDFSCREATEEXITPOINT *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NETRDFSCREATEEXITPOINT(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETRDFSCREATEEXITPOINT, (ejs_pull_function_t)ejs_pull_srvsvc_NETRDFSCREATEEXITPOINT, (ejs_push_function_t)ejs_push_srvsvc_NETRDFSCREATEEXITPOINT);
}


static NTSTATUS ejs_pull_srvsvc_NETRDFSDELETEEXITPOINT(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NETRDFSDELETEEXITPOINT *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NETRDFSDELETEEXITPOINT(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NETRDFSDELETEEXITPOINT *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NETRDFSDELETEEXITPOINT(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETRDFSDELETEEXITPOINT, (ejs_pull_function_t)ejs_pull_srvsvc_NETRDFSDELETEEXITPOINT, (ejs_push_function_t)ejs_push_srvsvc_NETRDFSDELETEEXITPOINT);
}


static NTSTATUS ejs_pull_srvsvc_NETRDFSMODIFYPREFIX(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NETRDFSMODIFYPREFIX *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NETRDFSMODIFYPREFIX(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NETRDFSMODIFYPREFIX *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NETRDFSMODIFYPREFIX(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETRDFSMODIFYPREFIX, (ejs_pull_function_t)ejs_pull_srvsvc_NETRDFSMODIFYPREFIX, (ejs_push_function_t)ejs_push_srvsvc_NETRDFSMODIFYPREFIX);
}


static NTSTATUS ejs_pull_srvsvc_NETRDFSFIXLOCALVOLUME(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NETRDFSFIXLOCALVOLUME *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NETRDFSFIXLOCALVOLUME(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NETRDFSFIXLOCALVOLUME *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NETRDFSFIXLOCALVOLUME(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETRDFSFIXLOCALVOLUME, (ejs_pull_function_t)ejs_pull_srvsvc_NETRDFSFIXLOCALVOLUME, (ejs_push_function_t)ejs_push_srvsvc_NETRDFSFIXLOCALVOLUME);
}


static NTSTATUS ejs_pull_srvsvc_NETRDFSMANAGERREPORTSITEINFO(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NETRDFSMANAGERREPORTSITEINFO *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NETRDFSMANAGERREPORTSITEINFO(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NETRDFSMANAGERREPORTSITEINFO *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NETRDFSMANAGERREPORTSITEINFO(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETRDFSMANAGERREPORTSITEINFO, (ejs_pull_function_t)ejs_pull_srvsvc_NETRDFSMANAGERREPORTSITEINFO, (ejs_push_function_t)ejs_push_srvsvc_NETRDFSMANAGERREPORTSITEINFO);
}


static NTSTATUS ejs_pull_srvsvc_NETRSERVERTRANSPORTDELEX(struct ejs_rpc *ejs, struct MprVar *v, struct srvsvc_NETRSERVERTRANSPORTDELEX *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_srvsvc_NETRSERVERTRANSPORTDELEX(struct ejs_rpc *ejs, struct MprVar *v, const struct srvsvc_NETRSERVERTRANSPORTDELEX *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_srvsvc_NETRSERVERTRANSPORTDELEX(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_srvsvc, DCERPC_SRVSVC_NETRSERVERTRANSPORTDELEX, (ejs_pull_function_t)ejs_pull_srvsvc_NETRSERVERTRANSPORTDELEX, (ejs_push_function_t)ejs_push_srvsvc_NETRSERVERTRANSPORTDELEX);
}

static int ejs_srvsvc_init(int eid, int argc, struct MprVar **argv)
{
	struct MprVar *obj = mprInitObject(eid, "srvsvc", argc, argv);
	mprSetCFunction(obj, "srvsvc_NetCharDevEnum", ejs_srvsvc_NetCharDevEnum);
	mprSetCFunction(obj, "srvsvc_NetCharDevGetInfo", ejs_srvsvc_NetCharDevGetInfo);
	mprSetCFunction(obj, "srvsvc_NetCharDevControl", ejs_srvsvc_NetCharDevControl);
	mprSetCFunction(obj, "srvsvc_NetCharDevQEnum", ejs_srvsvc_NetCharDevQEnum);
	mprSetCFunction(obj, "srvsvc_NetCharDevQGetInfo", ejs_srvsvc_NetCharDevQGetInfo);
	mprSetCFunction(obj, "srvsvc_NetCharDevQSetInfo", ejs_srvsvc_NetCharDevQSetInfo);
	mprSetCFunction(obj, "srvsvc_NetCharDevQPurge", ejs_srvsvc_NetCharDevQPurge);
	mprSetCFunction(obj, "srvsvc_NetCharDevQPurgeSelf", ejs_srvsvc_NetCharDevQPurgeSelf);
	mprSetCFunction(obj, "srvsvc_NetConnEnum", ejs_srvsvc_NetConnEnum);
	mprSetCFunction(obj, "srvsvc_NetFileEnum", ejs_srvsvc_NetFileEnum);
	mprSetCFunction(obj, "srvsvc_NetFileGetInfo", ejs_srvsvc_NetFileGetInfo);
	mprSetCFunction(obj, "srvsvc_NetFileClose", ejs_srvsvc_NetFileClose);
	mprSetCFunction(obj, "srvsvc_NetSessEnum", ejs_srvsvc_NetSessEnum);
	mprSetCFunction(obj, "srvsvc_NetSessDel", ejs_srvsvc_NetSessDel);
	mprSetCFunction(obj, "srvsvc_NetShareAdd", ejs_srvsvc_NetShareAdd);
	mprSetCFunction(obj, "srvsvc_NetShareEnumAll", ejs_srvsvc_NetShareEnumAll);
	mprSetCFunction(obj, "srvsvc_NetShareGetInfo", ejs_srvsvc_NetShareGetInfo);
	mprSetCFunction(obj, "srvsvc_NetShareSetInfo", ejs_srvsvc_NetShareSetInfo);
	mprSetCFunction(obj, "srvsvc_NetShareDel", ejs_srvsvc_NetShareDel);
	mprSetCFunction(obj, "srvsvc_NetShareDelSticky", ejs_srvsvc_NetShareDelSticky);
	mprSetCFunction(obj, "srvsvc_NetShareCheck", ejs_srvsvc_NetShareCheck);
	mprSetCFunction(obj, "srvsvc_NetSrvGetInfo", ejs_srvsvc_NetSrvGetInfo);
	mprSetCFunction(obj, "srvsvc_NetSrvSetInfo", ejs_srvsvc_NetSrvSetInfo);
	mprSetCFunction(obj, "srvsvc_NetDiskEnum", ejs_srvsvc_NetDiskEnum);
	mprSetCFunction(obj, "srvsvc_NetServerStatisticsGet", ejs_srvsvc_NetServerStatisticsGet);
	mprSetCFunction(obj, "srvsvc_NetTransportAdd", ejs_srvsvc_NetTransportAdd);
	mprSetCFunction(obj, "srvsvc_NetTransportEnum", ejs_srvsvc_NetTransportEnum);
	mprSetCFunction(obj, "srvsvc_NetTransportDel", ejs_srvsvc_NetTransportDel);
	mprSetCFunction(obj, "srvsvc_NetRemoteTOD", ejs_srvsvc_NetRemoteTOD);
	mprSetCFunction(obj, "srvsvc_NetSetServiceBits", ejs_srvsvc_NetSetServiceBits);
	mprSetCFunction(obj, "srvsvc_NetPathType", ejs_srvsvc_NetPathType);
	mprSetCFunction(obj, "srvsvc_NetPathCanonicalize", ejs_srvsvc_NetPathCanonicalize);
	mprSetCFunction(obj, "srvsvc_NetPathCompare", ejs_srvsvc_NetPathCompare);
	mprSetCFunction(obj, "srvsvc_NetNameValidate", ejs_srvsvc_NetNameValidate);
	mprSetCFunction(obj, "srvsvc_NETRPRNAMECANONICALIZE", ejs_srvsvc_NETRPRNAMECANONICALIZE);
	mprSetCFunction(obj, "srvsvc_NetPRNameCompare", ejs_srvsvc_NetPRNameCompare);
	mprSetCFunction(obj, "srvsvc_NetShareEnum", ejs_srvsvc_NetShareEnum);
	mprSetCFunction(obj, "srvsvc_NetShareDelStart", ejs_srvsvc_NetShareDelStart);
	mprSetCFunction(obj, "srvsvc_NetShareDelCommit", ejs_srvsvc_NetShareDelCommit);
	mprSetCFunction(obj, "srvsvc_NetGetFileSecurity", ejs_srvsvc_NetGetFileSecurity);
	mprSetCFunction(obj, "srvsvc_NetSetFileSecurity", ejs_srvsvc_NetSetFileSecurity);
	mprSetCFunction(obj, "srvsvc_NetServerTransportAddEx", ejs_srvsvc_NetServerTransportAddEx);
	mprSetCFunction(obj, "srvsvc_NetServerSetServiceBitsEx", ejs_srvsvc_NetServerSetServiceBitsEx);
	mprSetCFunction(obj, "srvsvc_NETRDFSGETVERSION", ejs_srvsvc_NETRDFSGETVERSION);
	mprSetCFunction(obj, "srvsvc_NETRDFSCREATELOCALPARTITION", ejs_srvsvc_NETRDFSCREATELOCALPARTITION);
	mprSetCFunction(obj, "srvsvc_NETRDFSDELETELOCALPARTITION", ejs_srvsvc_NETRDFSDELETELOCALPARTITION);
	mprSetCFunction(obj, "srvsvc_NETRDFSSETLOCALVOLUMESTATE", ejs_srvsvc_NETRDFSSETLOCALVOLUMESTATE);
	mprSetCFunction(obj, "srvsvc_NETRDFSSETSERVERINFO", ejs_srvsvc_NETRDFSSETSERVERINFO);
	mprSetCFunction(obj, "srvsvc_NETRDFSCREATEEXITPOINT", ejs_srvsvc_NETRDFSCREATEEXITPOINT);
	mprSetCFunction(obj, "srvsvc_NETRDFSDELETEEXITPOINT", ejs_srvsvc_NETRDFSDELETEEXITPOINT);
	mprSetCFunction(obj, "srvsvc_NETRDFSMODIFYPREFIX", ejs_srvsvc_NETRDFSMODIFYPREFIX);
	mprSetCFunction(obj, "srvsvc_NETRDFSFIXLOCALVOLUME", ejs_srvsvc_NETRDFSFIXLOCALVOLUME);
	mprSetCFunction(obj, "srvsvc_NETRDFSMANAGERREPORTSITEINFO", ejs_srvsvc_NETRDFSMANAGERREPORTSITEINFO);
	mprSetCFunction(obj, "srvsvc_NETRSERVERTRANSPORTDELEX", ejs_srvsvc_NETRSERVERTRANSPORTDELEX);
	mprSetVar(obj, "STYPE_PRINTQ", mprCreateNumberVar(1));
	mprSetVar(obj, "STYPE_DEVICE_TEMPORARY", mprCreateNumberVar(STYPE_DEVICE|STYPE_TEMPORARY));
	mprSetVar(obj, "STYPE_PRINTQ_TEMPORARY", mprCreateNumberVar(STYPE_PRINTQ|STYPE_TEMPORARY));
	mprSetVar(obj, "SHARE_1005_CSC_POLICY_SHIFT", mprCreateNumberVar(4));
	mprSetVar(obj, "STYPE_IPC_TEMPORARY", mprCreateNumberVar(STYPE_IPC|STYPE_TEMPORARY));
	mprSetVar(obj, "PLATFORM_ID_VMS", mprCreateNumberVar(700));
	mprSetVar(obj, "STYPE_IPC", mprCreateNumberVar(3));
	mprSetVar(obj, "PLATFORM_ID_OS2", mprCreateNumberVar(400));
	mprSetVar(obj, "STYPE_HIDDEN", mprCreateNumberVar(0x80000000));
	mprSetVar(obj, "PLATFORM_ID_DOS", mprCreateNumberVar(300));
	mprSetVar(obj, "STYPE_IPC_HIDDEN", mprCreateNumberVar(STYPE_IPC|STYPE_HIDDEN));
	mprSetVar(obj, "STYPE_DISKTREE_TEMPORARY", mprCreateNumberVar(STYPE_DISKTREE|STYPE_TEMPORARY));
	mprSetVar(obj, "STYPE_TEMPORARY", mprCreateNumberVar(0x40000000));
	mprSetVar(obj, "PLATFORM_ID_OSF", mprCreateNumberVar(600));
	mprSetVar(obj, "STYPE_PRINTQ_HIDDEN", mprCreateNumberVar(STYPE_PRINTQ|STYPE_HIDDEN));
	mprSetVar(obj, "STYPE_DEVICE_HIDDEN", mprCreateNumberVar(STYPE_DEVICE|STYPE_HIDDEN));
	mprSetVar(obj, "SHARE_1005_IN_DFS", mprCreateNumberVar(( 0x00000001 )));
	mprSetVar(obj, "STYPE_DEVICE", mprCreateNumberVar(2));
	mprSetVar(obj, "STYPE_DISKTREE", mprCreateNumberVar(0));
	mprSetVar(obj, "SHARE_1005_CSC_POLICY_MASK", mprCreateNumberVar(0x00000030));
	mprSetVar(obj, "SHARE_1005_DFS_ROOT", mprCreateNumberVar(( 0x00000002 )));
	mprSetVar(obj, "PLATFORM_ID_NT", mprCreateNumberVar(500));
	mprSetVar(obj, "STYPE_DISKTREE_HIDDEN", mprCreateNumberVar(STYPE_DISKTREE|STYPE_HIDDEN));
	return ejs_rpc_init(obj, "srvsvc");
}

NTSTATUS ejs_init_srvsvc(void)
{
	ejsDefineCFunction(-1, "srvsvc_init", ejs_srvsvc_init, NULL, MPR_VAR_SCRIPT_HANDLE);
	return NT_STATUS_OK;
}
