/* server functions auto-generated by pidl */
#include "librpc/gen_ndr/ndr_spoolss.h"

/* spoolss - dcerpc server boilerplate generated by pidl */


static NTSTATUS spoolss__op_bind(struct dcesrv_call_state *dce_call, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_SPOOLSS_BIND
	return DCESRV_INTERFACE_SPOOLSS_BIND(dce_call,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void spoolss__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_SPOOLSS_UNBIND
	DCESRV_INTERFACE_SPOOLSS_UNBIND(context, iface);
#else
	return;
#endif
}

static NTSTATUS spoolss__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	NTSTATUS status;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= dcerpc_table_spoolss.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_size(mem_ctx, dcerpc_table_spoolss.calls[opnum].struct_size);
	NT_STATUS_HAVE_NO_MEMORY(*r);

        /* unravel the NDR for the packet */
	status = dcerpc_table_spoolss.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NT_STATUS_IS_OK(status)) {
		dcerpc_log_packet(&dcerpc_table_spoolss, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS spoolss__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct spoolss_EnumPrinters *r2 = (struct spoolss_EnumPrinters *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EnumPrinters, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_EnumPrinters(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_EnumPrinters will reply async\n"));
		}
		break;
	}
	case 1: {
		struct spoolss_OpenPrinter *r2 = (struct spoolss_OpenPrinter *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_OpenPrinter, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_OpenPrinter(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_OpenPrinter will reply async\n"));
		}
		break;
	}
	case 2: {
		struct spoolss_SetJob *r2 = (struct spoolss_SetJob *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_SetJob, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_SetJob(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_SetJob will reply async\n"));
		}
		break;
	}
	case 3: {
		struct spoolss_GetJob *r2 = (struct spoolss_GetJob *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_GetJob, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_GetJob(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_GetJob will reply async\n"));
		}
		break;
	}
	case 4: {
		struct spoolss_EnumJobs *r2 = (struct spoolss_EnumJobs *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EnumJobs, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_EnumJobs(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_EnumJobs will reply async\n"));
		}
		break;
	}
	case 5: {
		struct spoolss_AddPrinter *r2 = (struct spoolss_AddPrinter *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddPrinter, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_AddPrinter(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_AddPrinter will reply async\n"));
		}
		break;
	}
	case 6: {
		struct spoolss_DeletePrinter *r2 = (struct spoolss_DeletePrinter *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeletePrinter, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_DeletePrinter(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_DeletePrinter will reply async\n"));
		}
		break;
	}
	case 7: {
		struct spoolss_SetPrinter *r2 = (struct spoolss_SetPrinter *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_SetPrinter, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_SetPrinter(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_SetPrinter will reply async\n"));
		}
		break;
	}
	case 8: {
		struct spoolss_GetPrinter *r2 = (struct spoolss_GetPrinter *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_GetPrinter, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_GetPrinter(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_GetPrinter will reply async\n"));
		}
		break;
	}
	case 9: {
		struct spoolss_AddPrinterDriver *r2 = (struct spoolss_AddPrinterDriver *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddPrinterDriver, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_AddPrinterDriver(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_AddPrinterDriver will reply async\n"));
		}
		break;
	}
	case 10: {
		struct spoolss_EnumPrinterDrivers *r2 = (struct spoolss_EnumPrinterDrivers *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EnumPrinterDrivers, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_EnumPrinterDrivers(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_EnumPrinterDrivers will reply async\n"));
		}
		break;
	}
	case 11: {
		struct spoolss_GetPrinterDriver *r2 = (struct spoolss_GetPrinterDriver *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_GetPrinterDriver, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_GetPrinterDriver(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_GetPrinterDriver will reply async\n"));
		}
		break;
	}
	case 12: {
		struct spoolss_GetPrinterDriverDirectory *r2 = (struct spoolss_GetPrinterDriverDirectory *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_GetPrinterDriverDirectory, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_GetPrinterDriverDirectory(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_GetPrinterDriverDirectory will reply async\n"));
		}
		break;
	}
	case 13: {
		struct spoolss_DeletePrinterDriver *r2 = (struct spoolss_DeletePrinterDriver *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeletePrinterDriver, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_DeletePrinterDriver(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_DeletePrinterDriver will reply async\n"));
		}
		break;
	}
	case 14: {
		struct spoolss_AddPrintProcessor *r2 = (struct spoolss_AddPrintProcessor *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddPrintProcessor, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_AddPrintProcessor(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_AddPrintProcessor will reply async\n"));
		}
		break;
	}
	case 15: {
		struct spoolss_EnumPrintProcessors *r2 = (struct spoolss_EnumPrintProcessors *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EnumPrintProcessors, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_EnumPrintProcessors(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_EnumPrintProcessors will reply async\n"));
		}
		break;
	}
	case 16: {
		struct spoolss_GetPrintProcessorDirectory *r2 = (struct spoolss_GetPrintProcessorDirectory *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_GetPrintProcessorDirectory, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_GetPrintProcessorDirectory(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_GetPrintProcessorDirectory will reply async\n"));
		}
		break;
	}
	case 17: {
		struct spoolss_StartDocPrinter *r2 = (struct spoolss_StartDocPrinter *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_StartDocPrinter, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_StartDocPrinter(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_StartDocPrinter will reply async\n"));
		}
		break;
	}
	case 18: {
		struct spoolss_StartPagePrinter *r2 = (struct spoolss_StartPagePrinter *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_StartPagePrinter, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_StartPagePrinter(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_StartPagePrinter will reply async\n"));
		}
		break;
	}
	case 19: {
		struct spoolss_WritePrinter *r2 = (struct spoolss_WritePrinter *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_WritePrinter, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_WritePrinter(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_WritePrinter will reply async\n"));
		}
		break;
	}
	case 20: {
		struct spoolss_EndPagePrinter *r2 = (struct spoolss_EndPagePrinter *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EndPagePrinter, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_EndPagePrinter(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_EndPagePrinter will reply async\n"));
		}
		break;
	}
	case 21: {
		struct spoolss_AbortPrinter *r2 = (struct spoolss_AbortPrinter *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AbortPrinter, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_AbortPrinter(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_AbortPrinter will reply async\n"));
		}
		break;
	}
	case 22: {
		struct spoolss_ReadPrinter *r2 = (struct spoolss_ReadPrinter *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_ReadPrinter, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_ReadPrinter(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_ReadPrinter will reply async\n"));
		}
		break;
	}
	case 23: {
		struct spoolss_EndDocPrinter *r2 = (struct spoolss_EndDocPrinter *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EndDocPrinter, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_EndDocPrinter(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_EndDocPrinter will reply async\n"));
		}
		break;
	}
	case 24: {
		struct spoolss_AddJob *r2 = (struct spoolss_AddJob *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddJob, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_AddJob(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_AddJob will reply async\n"));
		}
		break;
	}
	case 25: {
		struct spoolss_ScheduleJob *r2 = (struct spoolss_ScheduleJob *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_ScheduleJob, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_ScheduleJob(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_ScheduleJob will reply async\n"));
		}
		break;
	}
	case 26: {
		struct spoolss_GetPrinterData *r2 = (struct spoolss_GetPrinterData *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_GetPrinterData, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_GetPrinterData(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_GetPrinterData will reply async\n"));
		}
		break;
	}
	case 27: {
		struct spoolss_SetPrinterData *r2 = (struct spoolss_SetPrinterData *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_SetPrinterData, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_SetPrinterData(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_SetPrinterData will reply async\n"));
		}
		break;
	}
	case 28: {
		struct spoolss_WaitForPrinterChange *r2 = (struct spoolss_WaitForPrinterChange *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_WaitForPrinterChange, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_WaitForPrinterChange(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_WaitForPrinterChange will reply async\n"));
		}
		break;
	}
	case 29: {
		struct spoolss_ClosePrinter *r2 = (struct spoolss_ClosePrinter *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_ClosePrinter, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_ClosePrinter(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_ClosePrinter will reply async\n"));
		}
		break;
	}
	case 30: {
		struct spoolss_AddForm *r2 = (struct spoolss_AddForm *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddForm, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_AddForm(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_AddForm will reply async\n"));
		}
		break;
	}
	case 31: {
		struct spoolss_DeleteForm *r2 = (struct spoolss_DeleteForm *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeleteForm, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_DeleteForm(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_DeleteForm will reply async\n"));
		}
		break;
	}
	case 32: {
		struct spoolss_GetForm *r2 = (struct spoolss_GetForm *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_GetForm, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_GetForm(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_GetForm will reply async\n"));
		}
		break;
	}
	case 33: {
		struct spoolss_SetForm *r2 = (struct spoolss_SetForm *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_SetForm, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_SetForm(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_SetForm will reply async\n"));
		}
		break;
	}
	case 34: {
		struct spoolss_EnumForms *r2 = (struct spoolss_EnumForms *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EnumForms, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_EnumForms(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_EnumForms will reply async\n"));
		}
		break;
	}
	case 35: {
		struct spoolss_EnumPorts *r2 = (struct spoolss_EnumPorts *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EnumPorts, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_EnumPorts(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_EnumPorts will reply async\n"));
		}
		break;
	}
	case 36: {
		struct spoolss_EnumMonitors *r2 = (struct spoolss_EnumMonitors *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EnumMonitors, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_EnumMonitors(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_EnumMonitors will reply async\n"));
		}
		break;
	}
	case 37: {
		struct spoolss_AddPort *r2 = (struct spoolss_AddPort *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddPort, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_AddPort(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_AddPort will reply async\n"));
		}
		break;
	}
	case 38: {
		struct spoolss_ConfigurePort *r2 = (struct spoolss_ConfigurePort *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_ConfigurePort, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_ConfigurePort(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_ConfigurePort will reply async\n"));
		}
		break;
	}
	case 39: {
		struct spoolss_DeletePort *r2 = (struct spoolss_DeletePort *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeletePort, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_DeletePort(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_DeletePort will reply async\n"));
		}
		break;
	}
	case 40: {
		struct spoolss_CreatePrinterIC *r2 = (struct spoolss_CreatePrinterIC *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_CreatePrinterIC, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_CreatePrinterIC(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_CreatePrinterIC will reply async\n"));
		}
		break;
	}
	case 41: {
		struct spoolss_PlayGDIScriptOnPrinterIC *r2 = (struct spoolss_PlayGDIScriptOnPrinterIC *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_PlayGDIScriptOnPrinterIC, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_PlayGDIScriptOnPrinterIC(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_PlayGDIScriptOnPrinterIC will reply async\n"));
		}
		break;
	}
	case 42: {
		struct spoolss_DeletePrinterIC *r2 = (struct spoolss_DeletePrinterIC *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeletePrinterIC, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_DeletePrinterIC(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_DeletePrinterIC will reply async\n"));
		}
		break;
	}
	case 43: {
		struct spoolss_AddPrinterConnection *r2 = (struct spoolss_AddPrinterConnection *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddPrinterConnection, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_AddPrinterConnection(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_AddPrinterConnection will reply async\n"));
		}
		break;
	}
	case 44: {
		struct spoolss_DeletePrinterConnection *r2 = (struct spoolss_DeletePrinterConnection *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeletePrinterConnection, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_DeletePrinterConnection(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_DeletePrinterConnection will reply async\n"));
		}
		break;
	}
	case 45: {
		struct spoolss_PrinterMessageBox *r2 = (struct spoolss_PrinterMessageBox *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_PrinterMessageBox, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_PrinterMessageBox(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_PrinterMessageBox will reply async\n"));
		}
		break;
	}
	case 46: {
		struct spoolss_AddMonitor *r2 = (struct spoolss_AddMonitor *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddMonitor, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_AddMonitor(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_AddMonitor will reply async\n"));
		}
		break;
	}
	case 47: {
		struct spoolss_DeleteMonitor *r2 = (struct spoolss_DeleteMonitor *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeleteMonitor, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_DeleteMonitor(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_DeleteMonitor will reply async\n"));
		}
		break;
	}
	case 48: {
		struct spoolss_DeletePrintProcessor *r2 = (struct spoolss_DeletePrintProcessor *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeletePrintProcessor, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_DeletePrintProcessor(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_DeletePrintProcessor will reply async\n"));
		}
		break;
	}
	case 49: {
		struct spoolss_AddPrintProvidor *r2 = (struct spoolss_AddPrintProvidor *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddPrintProvidor, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_AddPrintProvidor(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_AddPrintProvidor will reply async\n"));
		}
		break;
	}
	case 50: {
		struct spoolss_DeletePrintProvidor *r2 = (struct spoolss_DeletePrintProvidor *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeletePrintProvidor, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_DeletePrintProvidor(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_DeletePrintProvidor will reply async\n"));
		}
		break;
	}
	case 51: {
		struct spoolss_EnumPrintProcDataTypes *r2 = (struct spoolss_EnumPrintProcDataTypes *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EnumPrintProcDataTypes, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_EnumPrintProcDataTypes(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_EnumPrintProcDataTypes will reply async\n"));
		}
		break;
	}
	case 52: {
		struct spoolss_ResetPrinter *r2 = (struct spoolss_ResetPrinter *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_ResetPrinter, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_ResetPrinter(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_ResetPrinter will reply async\n"));
		}
		break;
	}
	case 53: {
		struct spoolss_GetPrinterDriver2 *r2 = (struct spoolss_GetPrinterDriver2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_GetPrinterDriver2, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_GetPrinterDriver2(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_GetPrinterDriver2 will reply async\n"));
		}
		break;
	}
	case 54: {
		struct spoolss_FindFirstPrinterChangeNotification *r2 = (struct spoolss_FindFirstPrinterChangeNotification *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_FindFirstPrinterChangeNotification, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_FindFirstPrinterChangeNotification(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_FindFirstPrinterChangeNotification will reply async\n"));
		}
		break;
	}
	case 55: {
		struct spoolss_FindNextPrinterChangeNotification *r2 = (struct spoolss_FindNextPrinterChangeNotification *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_FindNextPrinterChangeNotification, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_FindNextPrinterChangeNotification(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_FindNextPrinterChangeNotification will reply async\n"));
		}
		break;
	}
	case 56: {
		struct spoolss_FindClosePrinterNotify *r2 = (struct spoolss_FindClosePrinterNotify *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_FindClosePrinterNotify, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_FindClosePrinterNotify(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_FindClosePrinterNotify will reply async\n"));
		}
		break;
	}
	case 57: {
		struct spoolss_RouterFindFirstPrinterChangeNotificationOld *r2 = (struct spoolss_RouterFindFirstPrinterChangeNotificationOld *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_RouterFindFirstPrinterChangeNotificationOld, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_RouterFindFirstPrinterChangeNotificationOld(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_RouterFindFirstPrinterChangeNotificationOld will reply async\n"));
		}
		break;
	}
	case 58: {
		struct spoolss_ReplyOpenPrinter *r2 = (struct spoolss_ReplyOpenPrinter *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_ReplyOpenPrinter, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_ReplyOpenPrinter(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_ReplyOpenPrinter will reply async\n"));
		}
		break;
	}
	case 59: {
		struct spoolss_RouterReplyPrinter *r2 = (struct spoolss_RouterReplyPrinter *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_RouterReplyPrinter, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_RouterReplyPrinter(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_RouterReplyPrinter will reply async\n"));
		}
		break;
	}
	case 60: {
		struct spoolss_ReplyClosePrinter *r2 = (struct spoolss_ReplyClosePrinter *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_ReplyClosePrinter, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_ReplyClosePrinter(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_ReplyClosePrinter will reply async\n"));
		}
		break;
	}
	case 61: {
		struct spoolss_AddPortEx *r2 = (struct spoolss_AddPortEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddPortEx, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_AddPortEx(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_AddPortEx will reply async\n"));
		}
		break;
	}
	case 62: {
		struct spoolss_RouterFindFirstPrinterChangeNotification *r2 = (struct spoolss_RouterFindFirstPrinterChangeNotification *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_RouterFindFirstPrinterChangeNotification, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_RouterFindFirstPrinterChangeNotification(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_RouterFindFirstPrinterChangeNotification will reply async\n"));
		}
		break;
	}
	case 63: {
		struct spoolss_SpoolerInit *r2 = (struct spoolss_SpoolerInit *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_SpoolerInit, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_SpoolerInit(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_SpoolerInit will reply async\n"));
		}
		break;
	}
	case 64: {
		struct spoolss_ResetPrinterEx *r2 = (struct spoolss_ResetPrinterEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_ResetPrinterEx, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_ResetPrinterEx(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_ResetPrinterEx will reply async\n"));
		}
		break;
	}
	case 65: {
		struct spoolss_RemoteFindFirstPrinterChangeNotifyEx *r2 = (struct spoolss_RemoteFindFirstPrinterChangeNotifyEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_RemoteFindFirstPrinterChangeNotifyEx, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_RemoteFindFirstPrinterChangeNotifyEx(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_RemoteFindFirstPrinterChangeNotifyEx will reply async\n"));
		}
		break;
	}
	case 66: {
		struct spoolss_RouterRefreshPrinterChangeNotification *r2 = (struct spoolss_RouterRefreshPrinterChangeNotification *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_RouterRefreshPrinterChangeNotification, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_RouterRefreshPrinterChangeNotification(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_RouterRefreshPrinterChangeNotification will reply async\n"));
		}
		break;
	}
	case 67: {
		struct spoolss_RemoteFindNextPrinterChangeNotifyEx *r2 = (struct spoolss_RemoteFindNextPrinterChangeNotifyEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_RemoteFindNextPrinterChangeNotifyEx, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_RemoteFindNextPrinterChangeNotifyEx(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_RemoteFindNextPrinterChangeNotifyEx will reply async\n"));
		}
		break;
	}
	case 68: {
		struct spoolss_44 *r2 = (struct spoolss_44 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_44, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_44(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_44 will reply async\n"));
		}
		break;
	}
	case 69: {
		struct spoolss_OpenPrinterEx *r2 = (struct spoolss_OpenPrinterEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_OpenPrinterEx, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_OpenPrinterEx(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_OpenPrinterEx will reply async\n"));
		}
		break;
	}
	case 70: {
		struct spoolss_AddPrinterEx *r2 = (struct spoolss_AddPrinterEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddPrinterEx, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_AddPrinterEx(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_AddPrinterEx will reply async\n"));
		}
		break;
	}
	case 71: {
		struct spoolss_47 *r2 = (struct spoolss_47 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_47, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_47(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_47 will reply async\n"));
		}
		break;
	}
	case 72: {
		struct spoolss_EnumPrinterData *r2 = (struct spoolss_EnumPrinterData *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EnumPrinterData, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_EnumPrinterData(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_EnumPrinterData will reply async\n"));
		}
		break;
	}
	case 73: {
		struct spoolss_DeletePrinterData *r2 = (struct spoolss_DeletePrinterData *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeletePrinterData, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_DeletePrinterData(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_DeletePrinterData will reply async\n"));
		}
		break;
	}
	case 74: {
		struct spoolss_4a *r2 = (struct spoolss_4a *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_4a, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_4a(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_4a will reply async\n"));
		}
		break;
	}
	case 75: {
		struct spoolss_4b *r2 = (struct spoolss_4b *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_4b, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_4b(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_4b will reply async\n"));
		}
		break;
	}
	case 76: {
		struct spoolss_4c *r2 = (struct spoolss_4c *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_4c, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_4c(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_4c will reply async\n"));
		}
		break;
	}
	case 77: {
		struct spoolss_SetPrinterDataEx *r2 = (struct spoolss_SetPrinterDataEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_SetPrinterDataEx, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_SetPrinterDataEx(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_SetPrinterDataEx will reply async\n"));
		}
		break;
	}
	case 78: {
		struct spoolss_GetPrinterDataEx *r2 = (struct spoolss_GetPrinterDataEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_GetPrinterDataEx, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_GetPrinterDataEx(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_GetPrinterDataEx will reply async\n"));
		}
		break;
	}
	case 79: {
		struct spoolss_EnumPrinterDataEx *r2 = (struct spoolss_EnumPrinterDataEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EnumPrinterDataEx, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_EnumPrinterDataEx(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_EnumPrinterDataEx will reply async\n"));
		}
		break;
	}
	case 80: {
		struct spoolss_EnumPrinterKey *r2 = (struct spoolss_EnumPrinterKey *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EnumPrinterKey, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_EnumPrinterKey(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_EnumPrinterKey will reply async\n"));
		}
		break;
	}
	case 81: {
		struct spoolss_DeletePrinterDataEx *r2 = (struct spoolss_DeletePrinterDataEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeletePrinterDataEx, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_DeletePrinterDataEx(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_DeletePrinterDataEx will reply async\n"));
		}
		break;
	}
	case 82: {
		struct spoolss_DeletePrinterKey *r2 = (struct spoolss_DeletePrinterKey *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeletePrinterKey, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_DeletePrinterKey(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_DeletePrinterKey will reply async\n"));
		}
		break;
	}
	case 83: {
		struct spoolss_53 *r2 = (struct spoolss_53 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_53, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_53(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_53 will reply async\n"));
		}
		break;
	}
	case 84: {
		struct spoolss_DeletePrinterDriverEx *r2 = (struct spoolss_DeletePrinterDriverEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeletePrinterDriverEx, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_DeletePrinterDriverEx(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_DeletePrinterDriverEx will reply async\n"));
		}
		break;
	}
	case 85: {
		struct spoolss_55 *r2 = (struct spoolss_55 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_55, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_55(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_55 will reply async\n"));
		}
		break;
	}
	case 86: {
		struct spoolss_56 *r2 = (struct spoolss_56 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_56, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_56(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_56 will reply async\n"));
		}
		break;
	}
	case 87: {
		struct spoolss_57 *r2 = (struct spoolss_57 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_57, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_57(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_57 will reply async\n"));
		}
		break;
	}
	case 88: {
		struct spoolss_XcvData *r2 = (struct spoolss_XcvData *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_XcvData, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_XcvData(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_XcvData will reply async\n"));
		}
		break;
	}
	case 89: {
		struct spoolss_AddPrinterDriverEx *r2 = (struct spoolss_AddPrinterDriverEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddPrinterDriverEx, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_AddPrinterDriverEx(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_AddPrinterDriverEx will reply async\n"));
		}
		break;
	}
	case 90: {
		struct spoolss_5a *r2 = (struct spoolss_5a *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_5a, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_5a(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_5a will reply async\n"));
		}
		break;
	}
	case 91: {
		struct spoolss_5b *r2 = (struct spoolss_5b *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_5b, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_5b(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_5b will reply async\n"));
		}
		break;
	}
	case 92: {
		struct spoolss_5c *r2 = (struct spoolss_5c *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_5c, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_5c(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_5c will reply async\n"));
		}
		break;
	}
	case 93: {
		struct spoolss_5d *r2 = (struct spoolss_5d *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_5d, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_5d(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_5d will reply async\n"));
		}
		break;
	}
	case 94: {
		struct spoolss_5e *r2 = (struct spoolss_5e *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_5e, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_5e(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_5e will reply async\n"));
		}
		break;
	}
	case 95: {
		struct spoolss_5f *r2 = (struct spoolss_5f *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_5f, NDR_IN, r2);
		}
		r2->out.result = dcesrv_spoolss_5f(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_5f will reply async\n"));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(&dcerpc_table_spoolss, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS spoolss__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct spoolss_EnumPrinters *r2 = (struct spoolss_EnumPrinters *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_EnumPrinters replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EnumPrinters, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_EnumPrinters\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 1: {
		struct spoolss_OpenPrinter *r2 = (struct spoolss_OpenPrinter *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_OpenPrinter replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_OpenPrinter, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_OpenPrinter\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 2: {
		struct spoolss_SetJob *r2 = (struct spoolss_SetJob *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_SetJob replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_SetJob, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_SetJob\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 3: {
		struct spoolss_GetJob *r2 = (struct spoolss_GetJob *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_GetJob replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_GetJob, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_GetJob\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 4: {
		struct spoolss_EnumJobs *r2 = (struct spoolss_EnumJobs *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_EnumJobs replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EnumJobs, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_EnumJobs\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 5: {
		struct spoolss_AddPrinter *r2 = (struct spoolss_AddPrinter *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_AddPrinter replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddPrinter, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_AddPrinter\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 6: {
		struct spoolss_DeletePrinter *r2 = (struct spoolss_DeletePrinter *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_DeletePrinter replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeletePrinter, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_DeletePrinter\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 7: {
		struct spoolss_SetPrinter *r2 = (struct spoolss_SetPrinter *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_SetPrinter replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_SetPrinter, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_SetPrinter\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 8: {
		struct spoolss_GetPrinter *r2 = (struct spoolss_GetPrinter *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_GetPrinter replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_GetPrinter, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_GetPrinter\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 9: {
		struct spoolss_AddPrinterDriver *r2 = (struct spoolss_AddPrinterDriver *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_AddPrinterDriver replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddPrinterDriver, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_AddPrinterDriver\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 10: {
		struct spoolss_EnumPrinterDrivers *r2 = (struct spoolss_EnumPrinterDrivers *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_EnumPrinterDrivers replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EnumPrinterDrivers, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_EnumPrinterDrivers\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 11: {
		struct spoolss_GetPrinterDriver *r2 = (struct spoolss_GetPrinterDriver *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_GetPrinterDriver replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_GetPrinterDriver, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_GetPrinterDriver\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 12: {
		struct spoolss_GetPrinterDriverDirectory *r2 = (struct spoolss_GetPrinterDriverDirectory *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_GetPrinterDriverDirectory replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_GetPrinterDriverDirectory, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_GetPrinterDriverDirectory\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 13: {
		struct spoolss_DeletePrinterDriver *r2 = (struct spoolss_DeletePrinterDriver *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_DeletePrinterDriver replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeletePrinterDriver, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_DeletePrinterDriver\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 14: {
		struct spoolss_AddPrintProcessor *r2 = (struct spoolss_AddPrintProcessor *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_AddPrintProcessor replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddPrintProcessor, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_AddPrintProcessor\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 15: {
		struct spoolss_EnumPrintProcessors *r2 = (struct spoolss_EnumPrintProcessors *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_EnumPrintProcessors replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EnumPrintProcessors, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_EnumPrintProcessors\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 16: {
		struct spoolss_GetPrintProcessorDirectory *r2 = (struct spoolss_GetPrintProcessorDirectory *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_GetPrintProcessorDirectory replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_GetPrintProcessorDirectory, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_GetPrintProcessorDirectory\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 17: {
		struct spoolss_StartDocPrinter *r2 = (struct spoolss_StartDocPrinter *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_StartDocPrinter replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_StartDocPrinter, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_StartDocPrinter\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 18: {
		struct spoolss_StartPagePrinter *r2 = (struct spoolss_StartPagePrinter *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_StartPagePrinter replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_StartPagePrinter, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_StartPagePrinter\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 19: {
		struct spoolss_WritePrinter *r2 = (struct spoolss_WritePrinter *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_WritePrinter replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_WritePrinter, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_WritePrinter\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 20: {
		struct spoolss_EndPagePrinter *r2 = (struct spoolss_EndPagePrinter *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_EndPagePrinter replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EndPagePrinter, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_EndPagePrinter\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 21: {
		struct spoolss_AbortPrinter *r2 = (struct spoolss_AbortPrinter *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_AbortPrinter replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AbortPrinter, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_AbortPrinter\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 22: {
		struct spoolss_ReadPrinter *r2 = (struct spoolss_ReadPrinter *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_ReadPrinter replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_ReadPrinter, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_ReadPrinter\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 23: {
		struct spoolss_EndDocPrinter *r2 = (struct spoolss_EndDocPrinter *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_EndDocPrinter replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EndDocPrinter, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_EndDocPrinter\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 24: {
		struct spoolss_AddJob *r2 = (struct spoolss_AddJob *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_AddJob replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddJob, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_AddJob\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 25: {
		struct spoolss_ScheduleJob *r2 = (struct spoolss_ScheduleJob *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_ScheduleJob replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_ScheduleJob, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_ScheduleJob\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 26: {
		struct spoolss_GetPrinterData *r2 = (struct spoolss_GetPrinterData *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_GetPrinterData replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_GetPrinterData, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_GetPrinterData\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 27: {
		struct spoolss_SetPrinterData *r2 = (struct spoolss_SetPrinterData *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_SetPrinterData replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_SetPrinterData, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_SetPrinterData\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 28: {
		struct spoolss_WaitForPrinterChange *r2 = (struct spoolss_WaitForPrinterChange *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_WaitForPrinterChange replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_WaitForPrinterChange, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_WaitForPrinterChange\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 29: {
		struct spoolss_ClosePrinter *r2 = (struct spoolss_ClosePrinter *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_ClosePrinter replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_ClosePrinter, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_ClosePrinter\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 30: {
		struct spoolss_AddForm *r2 = (struct spoolss_AddForm *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_AddForm replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddForm, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_AddForm\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 31: {
		struct spoolss_DeleteForm *r2 = (struct spoolss_DeleteForm *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_DeleteForm replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeleteForm, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_DeleteForm\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 32: {
		struct spoolss_GetForm *r2 = (struct spoolss_GetForm *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_GetForm replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_GetForm, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_GetForm\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 33: {
		struct spoolss_SetForm *r2 = (struct spoolss_SetForm *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_SetForm replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_SetForm, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_SetForm\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 34: {
		struct spoolss_EnumForms *r2 = (struct spoolss_EnumForms *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_EnumForms replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EnumForms, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_EnumForms\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 35: {
		struct spoolss_EnumPorts *r2 = (struct spoolss_EnumPorts *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_EnumPorts replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EnumPorts, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_EnumPorts\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 36: {
		struct spoolss_EnumMonitors *r2 = (struct spoolss_EnumMonitors *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_EnumMonitors replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EnumMonitors, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_EnumMonitors\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 37: {
		struct spoolss_AddPort *r2 = (struct spoolss_AddPort *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_AddPort replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddPort, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_AddPort\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 38: {
		struct spoolss_ConfigurePort *r2 = (struct spoolss_ConfigurePort *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_ConfigurePort replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_ConfigurePort, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_ConfigurePort\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 39: {
		struct spoolss_DeletePort *r2 = (struct spoolss_DeletePort *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_DeletePort replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeletePort, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_DeletePort\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 40: {
		struct spoolss_CreatePrinterIC *r2 = (struct spoolss_CreatePrinterIC *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_CreatePrinterIC replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_CreatePrinterIC, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_CreatePrinterIC\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 41: {
		struct spoolss_PlayGDIScriptOnPrinterIC *r2 = (struct spoolss_PlayGDIScriptOnPrinterIC *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_PlayGDIScriptOnPrinterIC replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_PlayGDIScriptOnPrinterIC, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_PlayGDIScriptOnPrinterIC\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 42: {
		struct spoolss_DeletePrinterIC *r2 = (struct spoolss_DeletePrinterIC *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_DeletePrinterIC replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeletePrinterIC, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_DeletePrinterIC\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 43: {
		struct spoolss_AddPrinterConnection *r2 = (struct spoolss_AddPrinterConnection *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_AddPrinterConnection replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddPrinterConnection, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_AddPrinterConnection\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 44: {
		struct spoolss_DeletePrinterConnection *r2 = (struct spoolss_DeletePrinterConnection *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_DeletePrinterConnection replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeletePrinterConnection, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_DeletePrinterConnection\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 45: {
		struct spoolss_PrinterMessageBox *r2 = (struct spoolss_PrinterMessageBox *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_PrinterMessageBox replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_PrinterMessageBox, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_PrinterMessageBox\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 46: {
		struct spoolss_AddMonitor *r2 = (struct spoolss_AddMonitor *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_AddMonitor replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddMonitor, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_AddMonitor\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 47: {
		struct spoolss_DeleteMonitor *r2 = (struct spoolss_DeleteMonitor *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_DeleteMonitor replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeleteMonitor, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_DeleteMonitor\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 48: {
		struct spoolss_DeletePrintProcessor *r2 = (struct spoolss_DeletePrintProcessor *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_DeletePrintProcessor replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeletePrintProcessor, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_DeletePrintProcessor\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 49: {
		struct spoolss_AddPrintProvidor *r2 = (struct spoolss_AddPrintProvidor *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_AddPrintProvidor replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddPrintProvidor, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_AddPrintProvidor\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 50: {
		struct spoolss_DeletePrintProvidor *r2 = (struct spoolss_DeletePrintProvidor *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_DeletePrintProvidor replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeletePrintProvidor, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_DeletePrintProvidor\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 51: {
		struct spoolss_EnumPrintProcDataTypes *r2 = (struct spoolss_EnumPrintProcDataTypes *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_EnumPrintProcDataTypes replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EnumPrintProcDataTypes, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_EnumPrintProcDataTypes\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 52: {
		struct spoolss_ResetPrinter *r2 = (struct spoolss_ResetPrinter *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_ResetPrinter replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_ResetPrinter, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_ResetPrinter\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 53: {
		struct spoolss_GetPrinterDriver2 *r2 = (struct spoolss_GetPrinterDriver2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_GetPrinterDriver2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_GetPrinterDriver2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_GetPrinterDriver2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 54: {
		struct spoolss_FindFirstPrinterChangeNotification *r2 = (struct spoolss_FindFirstPrinterChangeNotification *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_FindFirstPrinterChangeNotification replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_FindFirstPrinterChangeNotification, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_FindFirstPrinterChangeNotification\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 55: {
		struct spoolss_FindNextPrinterChangeNotification *r2 = (struct spoolss_FindNextPrinterChangeNotification *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_FindNextPrinterChangeNotification replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_FindNextPrinterChangeNotification, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_FindNextPrinterChangeNotification\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 56: {
		struct spoolss_FindClosePrinterNotify *r2 = (struct spoolss_FindClosePrinterNotify *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_FindClosePrinterNotify replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_FindClosePrinterNotify, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_FindClosePrinterNotify\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 57: {
		struct spoolss_RouterFindFirstPrinterChangeNotificationOld *r2 = (struct spoolss_RouterFindFirstPrinterChangeNotificationOld *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_RouterFindFirstPrinterChangeNotificationOld replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_RouterFindFirstPrinterChangeNotificationOld, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_RouterFindFirstPrinterChangeNotificationOld\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 58: {
		struct spoolss_ReplyOpenPrinter *r2 = (struct spoolss_ReplyOpenPrinter *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_ReplyOpenPrinter replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_ReplyOpenPrinter, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_ReplyOpenPrinter\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 59: {
		struct spoolss_RouterReplyPrinter *r2 = (struct spoolss_RouterReplyPrinter *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_RouterReplyPrinter replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_RouterReplyPrinter, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_RouterReplyPrinter\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 60: {
		struct spoolss_ReplyClosePrinter *r2 = (struct spoolss_ReplyClosePrinter *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_ReplyClosePrinter replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_ReplyClosePrinter, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_ReplyClosePrinter\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 61: {
		struct spoolss_AddPortEx *r2 = (struct spoolss_AddPortEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_AddPortEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddPortEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_AddPortEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 62: {
		struct spoolss_RouterFindFirstPrinterChangeNotification *r2 = (struct spoolss_RouterFindFirstPrinterChangeNotification *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_RouterFindFirstPrinterChangeNotification replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_RouterFindFirstPrinterChangeNotification, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_RouterFindFirstPrinterChangeNotification\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 63: {
		struct spoolss_SpoolerInit *r2 = (struct spoolss_SpoolerInit *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_SpoolerInit replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_SpoolerInit, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_SpoolerInit\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 64: {
		struct spoolss_ResetPrinterEx *r2 = (struct spoolss_ResetPrinterEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_ResetPrinterEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_ResetPrinterEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_ResetPrinterEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 65: {
		struct spoolss_RemoteFindFirstPrinterChangeNotifyEx *r2 = (struct spoolss_RemoteFindFirstPrinterChangeNotifyEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_RemoteFindFirstPrinterChangeNotifyEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_RemoteFindFirstPrinterChangeNotifyEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_RemoteFindFirstPrinterChangeNotifyEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 66: {
		struct spoolss_RouterRefreshPrinterChangeNotification *r2 = (struct spoolss_RouterRefreshPrinterChangeNotification *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_RouterRefreshPrinterChangeNotification replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_RouterRefreshPrinterChangeNotification, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_RouterRefreshPrinterChangeNotification\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 67: {
		struct spoolss_RemoteFindNextPrinterChangeNotifyEx *r2 = (struct spoolss_RemoteFindNextPrinterChangeNotifyEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_RemoteFindNextPrinterChangeNotifyEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_RemoteFindNextPrinterChangeNotifyEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_RemoteFindNextPrinterChangeNotifyEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 68: {
		struct spoolss_44 *r2 = (struct spoolss_44 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_44 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_44, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_44\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 69: {
		struct spoolss_OpenPrinterEx *r2 = (struct spoolss_OpenPrinterEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_OpenPrinterEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_OpenPrinterEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_OpenPrinterEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 70: {
		struct spoolss_AddPrinterEx *r2 = (struct spoolss_AddPrinterEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_AddPrinterEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddPrinterEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_AddPrinterEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 71: {
		struct spoolss_47 *r2 = (struct spoolss_47 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_47 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_47, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_47\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 72: {
		struct spoolss_EnumPrinterData *r2 = (struct spoolss_EnumPrinterData *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_EnumPrinterData replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EnumPrinterData, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_EnumPrinterData\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 73: {
		struct spoolss_DeletePrinterData *r2 = (struct spoolss_DeletePrinterData *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_DeletePrinterData replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeletePrinterData, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_DeletePrinterData\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 74: {
		struct spoolss_4a *r2 = (struct spoolss_4a *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_4a replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_4a, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_4a\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 75: {
		struct spoolss_4b *r2 = (struct spoolss_4b *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_4b replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_4b, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_4b\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 76: {
		struct spoolss_4c *r2 = (struct spoolss_4c *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_4c replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_4c, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_4c\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 77: {
		struct spoolss_SetPrinterDataEx *r2 = (struct spoolss_SetPrinterDataEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_SetPrinterDataEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_SetPrinterDataEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_SetPrinterDataEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 78: {
		struct spoolss_GetPrinterDataEx *r2 = (struct spoolss_GetPrinterDataEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_GetPrinterDataEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_GetPrinterDataEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_GetPrinterDataEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 79: {
		struct spoolss_EnumPrinterDataEx *r2 = (struct spoolss_EnumPrinterDataEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_EnumPrinterDataEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EnumPrinterDataEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_EnumPrinterDataEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 80: {
		struct spoolss_EnumPrinterKey *r2 = (struct spoolss_EnumPrinterKey *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_EnumPrinterKey replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EnumPrinterKey, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_EnumPrinterKey\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 81: {
		struct spoolss_DeletePrinterDataEx *r2 = (struct spoolss_DeletePrinterDataEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_DeletePrinterDataEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeletePrinterDataEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_DeletePrinterDataEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 82: {
		struct spoolss_DeletePrinterKey *r2 = (struct spoolss_DeletePrinterKey *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_DeletePrinterKey replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeletePrinterKey, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_DeletePrinterKey\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 83: {
		struct spoolss_53 *r2 = (struct spoolss_53 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_53 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_53, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_53\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 84: {
		struct spoolss_DeletePrinterDriverEx *r2 = (struct spoolss_DeletePrinterDriverEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_DeletePrinterDriverEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeletePrinterDriverEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_DeletePrinterDriverEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 85: {
		struct spoolss_55 *r2 = (struct spoolss_55 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_55 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_55, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_55\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 86: {
		struct spoolss_56 *r2 = (struct spoolss_56 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_56 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_56, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_56\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 87: {
		struct spoolss_57 *r2 = (struct spoolss_57 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_57 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_57, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_57\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 88: {
		struct spoolss_XcvData *r2 = (struct spoolss_XcvData *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_XcvData replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_XcvData, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_XcvData\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 89: {
		struct spoolss_AddPrinterDriverEx *r2 = (struct spoolss_AddPrinterDriverEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_AddPrinterDriverEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddPrinterDriverEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_AddPrinterDriverEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 90: {
		struct spoolss_5a *r2 = (struct spoolss_5a *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_5a replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_5a, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_5a\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 91: {
		struct spoolss_5b *r2 = (struct spoolss_5b *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_5b replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_5b, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_5b\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 92: {
		struct spoolss_5c *r2 = (struct spoolss_5c *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_5c replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_5c, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_5c\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 93: {
		struct spoolss_5d *r2 = (struct spoolss_5d *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_5d replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_5d, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_5d\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 94: {
		struct spoolss_5e *r2 = (struct spoolss_5e *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_5e replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_5e, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_5e\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 95: {
		struct spoolss_5f *r2 = (struct spoolss_5f *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_5f replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_5f, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in spoolss_5f\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(&dcerpc_table_spoolss, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS spoolss__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	NTSTATUS status;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	status = dcerpc_table_spoolss.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NT_STATUS_IS_OK(status)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

const struct dcesrv_interface dcesrv_spoolss_interface = {
	.name		= "spoolss",
	.syntax_id  = {{0x12345678,0x1234,0xabcd,{0xef,0x00},{0x01,0x23,0x45,0x67,0x89,0xab}},1.0},
	.bind		= spoolss__op_bind,
	.unbind		= spoolss__op_unbind,
	.ndr_pull	= spoolss__op_ndr_pull,
	.dispatch	= spoolss__op_dispatch,
	.reply		= spoolss__op_reply,
	.ndr_push	= spoolss__op_ndr_push
};


static NTSTATUS spoolss__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	int i;

	for (i=0;i<dcerpc_table_spoolss.endpoints->count;i++) {
		NTSTATUS ret;
		const char *name = dcerpc_table_spoolss.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, &dcesrv_spoolss_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DEBUG(1,("spoolss_op_init_server: failed to register endpoint '%s'\n",name));
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static BOOL spoolss__op_interface_by_uuid(struct dcesrv_interface *iface, const struct GUID *uuid, uint32_t if_version)
{
	if (dcesrv_spoolss_interface.syntax_id.if_version == if_version &&
		GUID_equal(&dcesrv_spoolss_interface.syntax_id.uuid, uuid)) {
		memcpy(iface,&dcesrv_spoolss_interface, sizeof(*iface));
		return True;
	}

	return False;
}

static BOOL spoolss__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcesrv_spoolss_interface.name, name)==0) {
		memcpy(iface, &dcesrv_spoolss_interface, sizeof(*iface));
		return True;
	}

	return False;	
}
	
NTSTATUS dcerpc_server_spoolss_init(void)
{
	NTSTATUS ret;
	struct dcesrv_endpoint_server ep_server;

	/* fill in our name */
	ep_server.name = "spoolss";

	/* fill in all the operations */
	ep_server.init_server = spoolss__op_init_server;

	ep_server.interface_by_uuid = spoolss__op_interface_by_uuid;
	ep_server.interface_by_name = spoolss__op_interface_by_name;

	/* register ourselves with the DCERPC subsystem. */
	ret = dcerpc_register_ep_server(&ep_server);

	if (!NT_STATUS_IS_OK(ret)) {
		DEBUG(0,("Failed to register 'spoolss' endpoint server!\n"));
		return ret;
	}

	return ret;
}

