
/* EJS wrapper functions auto-generated by pidl */
#include "includes.h"
#include "librpc/rpc/dcerpc.h"
#include "lib/appweb/ejs/ejs.h"
#include "scripting/ejs/ejsrpc.h"
#include "scripting/ejs/smbcalls.h"
#include "librpc/gen_ndr/ndr_misc_ejs.h"
#include "librpc/gen_ndr/ndr_schannel.h"
#include "librpc/gen_ndr/ndr_schannel_ejs.h"


static NTSTATUS ejs_push_schannel_bind_3(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct schannel_bind_3 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_string(ejs, v, "domain", r->domain));
	NDR_CHECK(ejs_push_string(ejs, v, "workstation", r->workstation));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_schannel_bind_3(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct schannel_bind_3 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_string(ejs, v, "domain", &r->domain));
	NDR_CHECK(ejs_pull_string(ejs, v, "workstation", &r->workstation));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_schannel_bind_23(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct schannel_bind_23 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_string(ejs, v, "domain", r->domain));
	NDR_CHECK(ejs_push_string(ejs, v, "workstation", r->workstation));
	NDR_CHECK(ejs_push_nbt_string(ejs, v, "dnsdomain", r->dnsdomain));
	NDR_CHECK(ejs_push_nbt_string(ejs, v, "dnsworkstation", r->dnsworkstation));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_schannel_bind_23(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct schannel_bind_23 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_string(ejs, v, "domain", &r->domain));
	NDR_CHECK(ejs_pull_string(ejs, v, "workstation", &r->workstation));
	NDR_CHECK(ejs_pull_nbt_string(ejs, v, "dnsdomain", &r->dnsdomain));
	NDR_CHECK(ejs_pull_nbt_string(ejs, v, "dnsworkstation", &r->dnsworkstation));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_schannel_bind_info(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union schannel_bind_info *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 3:
			NDR_CHECK(ejs_push_schannel_bind_3(ejs, v, "info3", &r->info3));
			break;
		case 23:
			NDR_CHECK(ejs_push_schannel_bind_23(ejs, v, "info23", &r->info23));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_schannel_bind_info(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union schannel_bind_info *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 3:
			NDR_CHECK(ejs_pull_schannel_bind_3(ejs, v, "info3", &r->info3));
			break;
		case 23:
			NDR_CHECK(ejs_pull_schannel_bind_23(ejs, v, "info23", &r->info23));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
_PUBLIC_ NTSTATUS ejs_push_schannel_bind(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct schannel_bind *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown1", &r->unknown1));
	NDR_CHECK(ejs_push_uint32(ejs, v, "bind_type", &r->bind_type));
	ejs_set_switch(ejs, r->bind_type);
	NDR_CHECK(ejs_push_schannel_bind_info(ejs, v, "u", &r->u));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_schannel_bind(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct schannel_bind *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown1", &r->unknown1));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "bind_type", &r->bind_type));
	ejs_set_switch(ejs, r->bind_type);
	NDR_CHECK(ejs_pull_schannel_bind_info(ejs, v, "u", &r->u));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_schannel_bind_ack(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct schannel_bind_ack *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown1", &r->unknown1));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown2", &r->unknown2));
	NDR_CHECK(ejs_push_uint32(ejs, v, "unknown3", &r->unknown3));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_schannel_bind_ack(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct schannel_bind_ack *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown1", &r->unknown1));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown2", &r->unknown2));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "unknown3", &r->unknown3));
	return NT_STATUS_OK;
}

static int ejs_schannel_init(int eid, int argc, struct MprVar **argv)
{
	struct MprVar *obj = mprInitObject(eid, "schannel", argc, argv);
	return ejs_rpc_init(obj, "schannel");
}

NTSTATUS ejs_init_schannel(void)
{
	ejsDefineCFunction(-1, "schannel_init", ejs_schannel_init, NULL, MPR_VAR_SCRIPT_HANDLE);
	return NT_STATUS_OK;
}
