/* server functions auto-generated by pidl */
#include "librpc/gen_ndr/ndr_oxidresolver.h"

/* IOXIDResolver - dcerpc server boilerplate generated by pidl */


static NTSTATUS IOXIDResolver__op_bind(struct dcesrv_call_state *dce_call, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_IOXIDRESOLVER_BIND
	return DCESRV_INTERFACE_IOXIDRESOLVER_BIND(dce_call,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void IOXIDResolver__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_IOXIDRESOLVER_UNBIND
	DCESRV_INTERFACE_IOXIDRESOLVER_UNBIND(context, iface);
#else
	return;
#endif
}

static NTSTATUS IOXIDResolver__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	NTSTATUS status;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= dcerpc_table_IOXIDResolver.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_size(mem_ctx, dcerpc_table_IOXIDResolver.calls[opnum].struct_size);
	NT_STATUS_HAVE_NO_MEMORY(*r);

        /* unravel the NDR for the packet */
	status = dcerpc_table_IOXIDResolver.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NT_STATUS_IS_OK(status)) {
		dcerpc_log_packet(&dcerpc_table_IOXIDResolver, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS IOXIDResolver__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct ResolveOxid *r2 = (struct ResolveOxid *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(ResolveOxid, NDR_IN, r2);
		}
		r2->out.result = dcesrv_ResolveOxid(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function ResolveOxid will reply async\n"));
		}
		break;
	}
	case 1: {
		struct SimplePing *r2 = (struct SimplePing *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(SimplePing, NDR_IN, r2);
		}
		r2->out.result = dcesrv_SimplePing(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function SimplePing will reply async\n"));
		}
		break;
	}
	case 2: {
		struct ComplexPing *r2 = (struct ComplexPing *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(ComplexPing, NDR_IN, r2);
		}
		r2->out.result = dcesrv_ComplexPing(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function ComplexPing will reply async\n"));
		}
		break;
	}
	case 3: {
		struct ServerAlive *r2 = (struct ServerAlive *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(ServerAlive, NDR_IN, r2);
		}
		r2->out.result = dcesrv_ServerAlive(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function ServerAlive will reply async\n"));
		}
		break;
	}
	case 4: {
		struct ResolveOxid2 *r2 = (struct ResolveOxid2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(ResolveOxid2, NDR_IN, r2);
		}
		r2->out.result = dcesrv_ResolveOxid2(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function ResolveOxid2 will reply async\n"));
		}
		break;
	}
	case 5: {
		struct ServerAlive2 *r2 = (struct ServerAlive2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(ServerAlive2, NDR_IN, r2);
		}
		r2->out.result = dcesrv_ServerAlive2(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function ServerAlive2 will reply async\n"));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(&dcerpc_table_IOXIDResolver, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS IOXIDResolver__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct ResolveOxid *r2 = (struct ResolveOxid *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function ResolveOxid replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(ResolveOxid, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in ResolveOxid\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 1: {
		struct SimplePing *r2 = (struct SimplePing *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function SimplePing replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(SimplePing, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in SimplePing\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 2: {
		struct ComplexPing *r2 = (struct ComplexPing *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function ComplexPing replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(ComplexPing, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in ComplexPing\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 3: {
		struct ServerAlive *r2 = (struct ServerAlive *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function ServerAlive replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(ServerAlive, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in ServerAlive\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 4: {
		struct ResolveOxid2 *r2 = (struct ResolveOxid2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function ResolveOxid2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(ResolveOxid2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in ResolveOxid2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 5: {
		struct ServerAlive2 *r2 = (struct ServerAlive2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function ServerAlive2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(ServerAlive2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in ServerAlive2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(&dcerpc_table_IOXIDResolver, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS IOXIDResolver__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	NTSTATUS status;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	status = dcerpc_table_IOXIDResolver.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NT_STATUS_IS_OK(status)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

const struct dcesrv_interface dcesrv_IOXIDResolver_interface = {
	.name		= "IOXIDResolver",
	.syntax_id  = {{0x99fcfec4,0x5260,0x101b,{0xbb,0xcb},{0x00,0xaa,0x00,0x21,0x34,0x7a}},0.0},
	.bind		= IOXIDResolver__op_bind,
	.unbind		= IOXIDResolver__op_unbind,
	.ndr_pull	= IOXIDResolver__op_ndr_pull,
	.dispatch	= IOXIDResolver__op_dispatch,
	.reply		= IOXIDResolver__op_reply,
	.ndr_push	= IOXIDResolver__op_ndr_push
};


static NTSTATUS IOXIDResolver__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	int i;

	for (i=0;i<dcerpc_table_IOXIDResolver.endpoints->count;i++) {
		NTSTATUS ret;
		const char *name = dcerpc_table_IOXIDResolver.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, &dcesrv_IOXIDResolver_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DEBUG(1,("IOXIDResolver_op_init_server: failed to register endpoint '%s'\n",name));
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static BOOL IOXIDResolver__op_interface_by_uuid(struct dcesrv_interface *iface, const struct GUID *uuid, uint32_t if_version)
{
	if (dcesrv_IOXIDResolver_interface.syntax_id.if_version == if_version &&
		GUID_equal(&dcesrv_IOXIDResolver_interface.syntax_id.uuid, uuid)) {
		memcpy(iface,&dcesrv_IOXIDResolver_interface, sizeof(*iface));
		return True;
	}

	return False;
}

static BOOL IOXIDResolver__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcesrv_IOXIDResolver_interface.name, name)==0) {
		memcpy(iface, &dcesrv_IOXIDResolver_interface, sizeof(*iface));
		return True;
	}

	return False;	
}
	
NTSTATUS dcerpc_server_IOXIDResolver_init(void)
{
	NTSTATUS ret;
	struct dcesrv_endpoint_server ep_server;

	/* fill in our name */
	ep_server.name = "IOXIDResolver";

	/* fill in all the operations */
	ep_server.init_server = IOXIDResolver__op_init_server;

	ep_server.interface_by_uuid = IOXIDResolver__op_interface_by_uuid;
	ep_server.interface_by_name = IOXIDResolver__op_interface_by_name;

	/* register ourselves with the DCERPC subsystem. */
	ret = dcerpc_register_ep_server(&ep_server);

	if (!NT_STATUS_IS_OK(ret)) {
		DEBUG(0,("Failed to register 'IOXIDResolver' endpoint server!\n"));
		return ret;
	}

	return ret;
}

