
/* EJS wrapper functions auto-generated by pidl */
#include "includes.h"
#include "librpc/rpc/dcerpc.h"
#include "lib/appweb/ejs/ejs.h"
#include "scripting/ejs/ejsrpc.h"
#include "scripting/ejs/smbcalls.h"
#include "librpc/gen_ndr/ndr_misc_ejs.h"
#include "librpc/gen_ndr/ndr_orpc.h"
#include "librpc/gen_ndr/ndr_orpc_ejs.h"


_PUBLIC_ NTSTATUS ejs_push_COMVERSION(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct COMVERSION *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint16(ejs, v, "MajorVersion", &r->MajorVersion));
	NDR_CHECK(ejs_push_uint16(ejs, v, "MinorVersion", &r->MinorVersion));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_COMVERSION(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct COMVERSION *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "MajorVersion", &r->MajorVersion));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "MinorVersion", &r->MinorVersion));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_ORPC_EXTENT(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct ORPC_EXTENT *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_GUID(ejs, v, "id", &r->id));
	NDR_CHECK(ejs_push_uint32(ejs, v, "size", &r->size));
	ejs_push_array_uint8(ejs, v, "data", r->data, ((r->size + 7) & ~7));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_ORPC_EXTENT(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct ORPC_EXTENT *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_GUID(ejs, v, "id", &r->id));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "size", &r->size));
	EJS_ALLOC_N(ejs, r->data, ((r->size + 7) & ~7));
	ejs_pull_array_uint8(ejs, v, "data", r->data, ((r->size + 7) & ~7));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_ORPC_EXTENT_ARRAY(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct ORPC_EXTENT_ARRAY *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "size", &r->size));
	NDR_CHECK(ejs_push_uint32(ejs, v, "reserved", &r->reserved));
	if (NULL == r->extent) {
		NDR_CHECK(ejs_push_null(ejs, v, "extent"));
	} else {
		{
			uint32_t i;
			for (i=0;i<((r->size + 1) & ~1);i++) {
				const char *id = talloc_asprintf(ejs, "%s.%u", "extent", i);
				if (NULL == r->extent[i]) {
					NDR_CHECK(ejs_push_null(ejs, v, id));
				} else {
					NDR_CHECK(ejs_push_ORPC_EXTENT(ejs, v, id, r->extent[i]));
				}
			}
			ejs_push_uint32(ejs, v, "extent" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_ORPC_EXTENT_ARRAY(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct ORPC_EXTENT_ARRAY *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "size", &r->size));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "reserved", &r->reserved));
	if (ejs_pull_null(ejs, v, "extent")) {
		r->extent = NULL;
	} else {
		EJS_ALLOC(ejs, r->extent);
		{
			uint32_t i;
			EJS_ALLOC_N(ejs, r->extent, ((r->size + 1) & ~1));
			for (i=0;i<((r->size + 1) & ~1);i++) {
				char *id = talloc_asprintf(ejs, "%s.%u", "extent", i);
				if (ejs_pull_null(ejs, v, id)) {
					r->extent[i] = NULL;
				} else {
					EJS_ALLOC(ejs, r->extent[i]);
					NDR_CHECK(ejs_pull_ORPC_EXTENT(ejs, v, id, r->extent[i]));
				}
				talloc_free(id);
			}
			ejs_push_uint32(ejs, v, "extent" ".length", &i);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_ORPCTHIS(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct ORPCTHIS *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_COMVERSION(ejs, v, "version", &r->version));
	NDR_CHECK(ejs_push_uint32(ejs, v, "flags", &r->flags));
	NDR_CHECK(ejs_push_uint32(ejs, v, "reserved1", &r->reserved1));
	NDR_CHECK(ejs_push_GUID(ejs, v, "cid", &r->cid));
	if (NULL == r->extensions) {
		NDR_CHECK(ejs_push_null(ejs, v, "extensions"));
	} else {
		NDR_CHECK(ejs_push_ORPC_EXTENT_ARRAY(ejs, v, "extensions", r->extensions));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_ORPCTHIS(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct ORPCTHIS *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_COMVERSION(ejs, v, "version", &r->version));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "flags", &r->flags));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "reserved1", &r->reserved1));
	NDR_CHECK(ejs_pull_GUID(ejs, v, "cid", &r->cid));
	if (ejs_pull_null(ejs, v, "extensions")) {
		r->extensions = NULL;
	} else {
		EJS_ALLOC(ejs, r->extensions);
		NDR_CHECK(ejs_pull_ORPC_EXTENT_ARRAY(ejs, v, "extensions", r->extensions));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_ORPCTHAT(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct ORPCTHAT *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "flags", &r->flags));
	if (NULL == r->extensions) {
		NDR_CHECK(ejs_push_null(ejs, v, "extensions"));
	} else {
		NDR_CHECK(ejs_push_ORPC_EXTENT_ARRAY(ejs, v, "extensions", r->extensions));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_ORPCTHAT(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct ORPCTHAT *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "flags", &r->flags));
	if (ejs_pull_null(ejs, v, "extensions")) {
		r->extensions = NULL;
	} else {
		EJS_ALLOC(ejs, r->extensions);
		NDR_CHECK(ejs_pull_ORPC_EXTENT_ARRAY(ejs, v, "extensions", r->extensions));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_STRINGBINDING(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct STRINGBINDING *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint16(ejs, v, "wTowerId", &r->wTowerId));
	NDR_CHECK(ejs_push_string(ejs, v, "NetworkAddr", r->NetworkAddr));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_STRINGBINDING(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct STRINGBINDING *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "wTowerId", &r->wTowerId));
	NDR_CHECK(ejs_pull_string(ejs, v, "NetworkAddr", &r->NetworkAddr));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_STRINGARRAY(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct STRINGARRAY *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->stringbindings) {
		NDR_CHECK(ejs_push_null(ejs, v, "stringbindings"));
	} else {
		if (NULL == *r->stringbindings) {
			NDR_CHECK(ejs_push_null(ejs, v, "stringbindings"));
		} else {
			NDR_CHECK(ejs_push_STRINGBINDING(ejs, v, "stringbindings", *r->stringbindings));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_STRINGARRAY(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct STRINGARRAY *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "stringbindings")) {
		r->stringbindings = NULL;
	} else {
		EJS_ALLOC(ejs, r->stringbindings);
		if (ejs_pull_null(ejs, v, "stringbindings")) {
			*r->stringbindings = NULL;
		} else {
			EJS_ALLOC(ejs, *r->stringbindings);
			NDR_CHECK(ejs_pull_STRINGBINDING(ejs, v, "stringbindings", *r->stringbindings));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_DUALSTRINGARRAY(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct DUALSTRINGARRAY *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	if (NULL == r->stringbindings) {
		NDR_CHECK(ejs_push_null(ejs, v, "stringbindings"));
	} else {
		if (NULL == *r->stringbindings) {
			NDR_CHECK(ejs_push_null(ejs, v, "stringbindings"));
		} else {
			NDR_CHECK(ejs_push_STRINGBINDING(ejs, v, "stringbindings", *r->stringbindings));
		}
	}
	if (NULL == r->securitybindings) {
		NDR_CHECK(ejs_push_null(ejs, v, "securitybindings"));
	} else {
		if (NULL == *r->securitybindings) {
			NDR_CHECK(ejs_push_null(ejs, v, "securitybindings"));
		} else {
			NDR_CHECK(ejs_push_SECURITYBINDING(ejs, v, "securitybindings", *r->securitybindings));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_DUALSTRINGARRAY(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct DUALSTRINGARRAY *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	if (ejs_pull_null(ejs, v, "stringbindings")) {
		r->stringbindings = NULL;
	} else {
		EJS_ALLOC(ejs, r->stringbindings);
		if (ejs_pull_null(ejs, v, "stringbindings")) {
			*r->stringbindings = NULL;
		} else {
			EJS_ALLOC(ejs, *r->stringbindings);
			NDR_CHECK(ejs_pull_STRINGBINDING(ejs, v, "stringbindings", *r->stringbindings));
		}
	}
	if (ejs_pull_null(ejs, v, "securitybindings")) {
		r->securitybindings = NULL;
	} else {
		EJS_ALLOC(ejs, r->securitybindings);
		if (ejs_pull_null(ejs, v, "securitybindings")) {
			*r->securitybindings = NULL;
		} else {
			EJS_ALLOC(ejs, *r->securitybindings);
			NDR_CHECK(ejs_pull_SECURITYBINDING(ejs, v, "securitybindings", *r->securitybindings));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_SECURITYBINDING(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct SECURITYBINDING *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint16(ejs, v, "wAuthnSvc", &r->wAuthnSvc));
	NDR_CHECK(ejs_push_uint16(ejs, v, "wAuthzSvc", &r->wAuthzSvc));
	NDR_CHECK(ejs_push_string(ejs, v, "PrincName", r->PrincName));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_SECURITYBINDING(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct SECURITYBINDING *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "wAuthnSvc", &r->wAuthnSvc));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "wAuthzSvc", &r->wAuthzSvc));
	NDR_CHECK(ejs_pull_string(ejs, v, "PrincName", &r->PrincName));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_STDOBJREF(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct STDOBJREF *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "flags", &r->flags));
	NDR_CHECK(ejs_push_uint32(ejs, v, "cPublicRefs", &r->cPublicRefs));
	NDR_CHECK(ejs_push_hyper(ejs, v, "oxid", &r->oxid));
	NDR_CHECK(ejs_push_hyper(ejs, v, "oid", &r->oid));
	NDR_CHECK(ejs_push_GUID(ejs, v, "ipid", &r->ipid));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_STDOBJREF(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct STDOBJREF *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "flags", &r->flags));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "cPublicRefs", &r->cPublicRefs));
	NDR_CHECK(ejs_pull_hyper(ejs, v, "oxid", &r->oxid));
	NDR_CHECK(ejs_pull_hyper(ejs, v, "oid", &r->oid));
	NDR_CHECK(ejs_pull_GUID(ejs, v, "ipid", &r->ipid));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_u_standard(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct u_standard *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_STDOBJREF(ejs, v, "std", &r->std));
	NDR_CHECK(ejs_push_STRINGARRAY(ejs, v, "saResAddr", &r->saResAddr));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_u_standard(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct u_standard *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_STDOBJREF(ejs, v, "std", &r->std));
	NDR_CHECK(ejs_pull_STRINGARRAY(ejs, v, "saResAddr", &r->saResAddr));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_u_handler(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct u_handler *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_STDOBJREF(ejs, v, "std", &r->std));
	NDR_CHECK(ejs_push_GUID(ejs, v, "clsid", &r->clsid));
	NDR_CHECK(ejs_push_STRINGARRAY(ejs, v, "saResAddr", &r->saResAddr));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_u_handler(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct u_handler *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_STDOBJREF(ejs, v, "std", &r->std));
	NDR_CHECK(ejs_pull_GUID(ejs, v, "clsid", &r->clsid));
	NDR_CHECK(ejs_pull_STRINGARRAY(ejs, v, "saResAddr", &r->saResAddr));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_u_custom(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct u_custom *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_GUID(ejs, v, "clsid", &r->clsid));
	NDR_CHECK(ejs_push_uint32(ejs, v, "cbExtension", &r->cbExtension));
	NDR_CHECK(ejs_push_uint32(ejs, v, "size", &r->size));
	ejs_push_array_uint8(ejs, v, "pData", r->pData, r->size);
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_u_custom(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct u_custom *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_GUID(ejs, v, "clsid", &r->clsid));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "cbExtension", &r->cbExtension));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "size", &r->size));
	EJS_ALLOC_N(ejs, r->pData, r->size);
	ejs_pull_array_uint8(ejs, v, "pData", r->pData, r->size);
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_u_null(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct u_null *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_u_null(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct u_null *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_OBJREF_Types(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union OBJREF_Types *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case OBJREF_NULL:
			NDR_CHECK(ejs_push_u_null(ejs, v, "u_null", &r->u_null));
			break;
		case OBJREF_STANDARD:
			NDR_CHECK(ejs_push_u_standard(ejs, v, "u_standard", &r->u_standard));
			break;
		case OBJREF_HANDLER:
			NDR_CHECK(ejs_push_u_handler(ejs, v, "u_handler", &r->u_handler));
			break;
		case OBJREF_CUSTOM:
			NDR_CHECK(ejs_push_u_custom(ejs, v, "u_custom", &r->u_custom));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_OBJREF_Types(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union OBJREF_Types *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case OBJREF_NULL:
			NDR_CHECK(ejs_pull_u_null(ejs, v, "u_null", &r->u_null));
			break;
		case OBJREF_STANDARD:
			NDR_CHECK(ejs_pull_u_standard(ejs, v, "u_standard", &r->u_standard));
			break;
		case OBJREF_HANDLER:
			NDR_CHECK(ejs_pull_u_handler(ejs, v, "u_handler", &r->u_handler));
			break;
		case OBJREF_CUSTOM:
			NDR_CHECK(ejs_pull_u_custom(ejs, v, "u_custom", &r->u_custom));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
_PUBLIC_ NTSTATUS ejs_push_OBJREF(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct OBJREF *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "signature", &r->signature));
	NDR_CHECK(ejs_push_uint32(ejs, v, "flags", &r->flags));
	NDR_CHECK(ejs_push_GUID(ejs, v, "iid", &r->iid));
	ejs_set_switch(ejs, r->flags);
	NDR_CHECK(ejs_push_OBJREF_Types(ejs, v, "u_objref", &r->u_objref));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_OBJREF(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct OBJREF *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "signature", &r->signature));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "flags", &r->flags));
	NDR_CHECK(ejs_pull_GUID(ejs, v, "iid", &r->iid));
	ejs_set_switch(ejs, r->flags);
	NDR_CHECK(ejs_pull_OBJREF_Types(ejs, v, "u_objref", &r->u_objref));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_MInterfacePointer(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct MInterfacePointer *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "size", &r->size));
	return ejs_panic(ejs, "unhandled push type SUBCONTEXT");
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_MInterfacePointer(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct MInterfacePointer *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "size", &r->size));
	return ejs_panic(ejs, "unhandled pull type SUBCONTEXT");
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_COMRESULT(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const enum COMRESULT *r)
{
	unsigned e = *r;
	NDR_CHECK(ejs_push_enum(ejs, v, name, &e));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_COMRESULT(struct ejs_rpc *ejs, struct MprVar *v, const char *name, enum COMRESULT *r)
{
	unsigned e;
	NDR_CHECK(ejs_pull_enum(ejs, v, name, &e));
	*r = e;
	return NT_STATUS_OK;
}

static int ejs_ObjectRpcBaseTypes_init(int eid, int argc, struct MprVar **argv)
{
	struct MprVar *obj = mprInitObject(eid, "ObjectRpcBaseTypes", argc, argv);
	mprSetVar(obj, "COM_INVALID_OXID", mprCreateNumberVar(0x80070776));
	mprSetVar(obj, "COM_INVALID_OID", mprCreateNumberVar(0x80070777));
	mprSetVar(obj, "COM_UNEXPECTED", mprCreateNumberVar(0x8000FFFF));
	mprSetVar(obj, "dcom_ext_extended_error", mprString("f1f19681-4d2a-11ce-a66a-0020af6e72f4"));
	mprSetVar(obj, "COM_NOINTERFACE", mprCreateNumberVar(0x80000004));
	mprSetVar(obj, "COM_MINOR_VERSION", mprCreateNumberVar(1));
	mprSetVar(obj, "COM_ACCESSDENIED", mprCreateNumberVar(0x80070005));
	mprSetVar(obj, "COM_INVALID_SET", mprCreateNumberVar(0x80070778));
	mprSetVar(obj, "COM_CLSNOTFOUND", mprCreateNumberVar(0x80040154));
	mprSetVar(obj, "COM_INVALIDARG", mprCreateNumberVar(0x80000003));
	mprSetVar(obj, "COM_OUTOFMEMORY", mprCreateNumberVar(0x80000002));
	mprSetVar(obj, "COM_MAJOR_VERSION", mprCreateNumberVar(5));
	mprSetVar(obj, "COM_OK", mprCreateNumberVar(0x00000000));
	mprSetVar(obj, "dcom_ext_debugging", mprString("f1f19680-4d2a-11ce-a66a-0020af6e72f4"));
	mprSetVar(obj, "COM_C_AUTHZ_NONE", mprCreateNumberVar(0xffff));
	mprSetVar(obj, "OBJREF_SIGNATURE", mprCreateNumberVar(0x574f454d));
	return ejs_rpc_init(obj, "ObjectRpcBaseTypes");
}

NTSTATUS ejs_init_ObjectRpcBaseTypes(void)
{
	ejsDefineCFunction(-1, "ObjectRpcBaseTypes_init", ejs_ObjectRpcBaseTypes_init, NULL, MPR_VAR_SCRIPT_HANDLE);
	return NT_STATUS_OK;
}
