
/* EJS wrapper functions auto-generated by pidl */
#include "includes.h"
#include "librpc/rpc/dcerpc.h"
#include "lib/appweb/ejs/ejs.h"
#include "scripting/ejs/ejsrpc.h"
#include "scripting/ejs/smbcalls.h"
#include "librpc/gen_ndr/ndr_misc_ejs.h"
#include "librpc/gen_ndr/ndr_nfs4acl.h"
#include "librpc/gen_ndr/ndr_nfs4acl_ejs.h"


static NTSTATUS ejs_push_nfs4ace(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct nfs4ace *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint16(ejs, v, "e_type", &r->e_type));
	NDR_CHECK(ejs_push_uint16(ejs, v, "e_flags", &r->e_flags));
	NDR_CHECK(ejs_push_uint32(ejs, v, "e_mask", &r->e_mask));
	NDR_CHECK(ejs_push_uint32(ejs, v, "e_id", &r->e_id));
	NDR_CHECK(ejs_push_string(ejs, v, "e_who", r->e_who));
	NDR_CHECK(ejs_push_DATA_BLOB(ejs, v, "_pad", &r->_pad));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_nfs4ace(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct nfs4ace *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "e_type", &r->e_type));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "e_flags", &r->e_flags));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "e_mask", &r->e_mask));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "e_id", &r->e_id));
	NDR_CHECK(ejs_pull_string(ejs, v, "e_who", &r->e_who));
	NDR_CHECK(ejs_pull_DATA_BLOB(ejs, v, "_pad", &r->_pad));
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_push_nfs4acl(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct nfs4acl *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint8(ejs, v, "a_version", &r->a_version));
	NDR_CHECK(ejs_push_uint8(ejs, v, "a_flags", &r->a_flags));
	NDR_CHECK(ejs_push_uint16(ejs, v, "a_count", &r->a_count));
	NDR_CHECK(ejs_push_uint32(ejs, v, "a_owner_mask", &r->a_owner_mask));
	NDR_CHECK(ejs_push_uint32(ejs, v, "a_group_mask", &r->a_group_mask));
	NDR_CHECK(ejs_push_uint32(ejs, v, "a_other_mask", &r->a_other_mask));
	{
		uint32_t i;
		for (i=0;i<r->a_count;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "ace", i);
			NDR_CHECK(ejs_push_nfs4ace(ejs, v, id, &r->ace[i]));
		}
		ejs_push_uint32(ejs, v, "ace" ".length", &i);
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ejs_pull_nfs4acl(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct nfs4acl *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "a_version", &r->a_version));
	NDR_CHECK(ejs_pull_uint8(ejs, v, "a_flags", &r->a_flags));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "a_count", &r->a_count));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "a_owner_mask", &r->a_owner_mask));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "a_group_mask", &r->a_group_mask));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "a_other_mask", &r->a_other_mask));
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->ace, r->a_count);
		for (i=0;i<r->a_count;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "ace", i);
			NDR_CHECK(ejs_pull_nfs4ace(ejs, v, id, &r->ace[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "ace" ".length", &i);
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_pull_nfs4acl_test(struct ejs_rpc *ejs, struct MprVar *v, struct nfs4acl_test *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_nfs4acl(ejs, v, "acl", &r->in.acl));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_nfs4acl_test(struct ejs_rpc *ejs, struct MprVar *v, const struct nfs4acl_test *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_nfs4acl_test(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_nfs4acl, DCERPC_NFS4ACL_TEST, (ejs_pull_function_t)ejs_pull_nfs4acl_test, (ejs_push_function_t)ejs_push_nfs4acl_test);
}

static int ejs_nfs4acl_init(int eid, int argc, struct MprVar **argv)
{
	struct MprVar *obj = mprInitObject(eid, "nfs4acl", argc, argv);
	mprSetCFunction(obj, "nfs4acl_test", ejs_nfs4acl_test);
	mprSetVar(obj, "NFS4ACL_XATTR_NAME", mprString("system.nfs4acl"));
	return ejs_rpc_init(obj, "nfs4acl");
}

NTSTATUS ejs_init_nfs4acl(void)
{
	ejsDefineCFunction(-1, "nfs4acl_init", ejs_nfs4acl_init, NULL, MPR_VAR_SCRIPT_HANDLE);
	return NT_STATUS_OK;
}
