/* parser auto-generated by pidl */

#include "includes.h"
#include "libcli/util/nterr.h"
#include "librpc/gen_ndr/ndr_misc.h"
#include "librpc/gen_ndr/ndr_dcerpc.h"
#include "librpc/rpc/dcerpc.h"
#include "librpc/gen_ndr/ndr_irpc.h"

#include "librpc/gen_ndr/ndr_security.h"
#include "librpc/gen_ndr/ndr_nbt.h"
static NTSTATUS ndr_push_irpc_flags(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_irpc_flags(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_irpc_flags(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "IRPC_FLAG_REPLY", IRPC_FLAG_REPLY, r);
	ndr->depth--;
}

_PUBLIC_ NTSTATUS ndr_push_irpc_header(struct ndr_push *ndr, int ndr_flags, const struct irpc_header *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->uuid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->if_version));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->callnum));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->callid));
		NDR_CHECK(ndr_push_irpc_flags(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->status));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_GUID(ndr, NDR_BUFFERS, &r->uuid));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ NTSTATUS ndr_pull_irpc_header(struct ndr_pull *ndr, int ndr_flags, struct irpc_header *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->uuid));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->if_version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->callnum));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->callid));
		NDR_CHECK(ndr_pull_irpc_flags(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->status));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_BUFFERS, &r->uuid));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_irpc_header(struct ndr_print *ndr, const char *name, const struct irpc_header *r)
{
	ndr_print_struct(ndr, name, "irpc_header");
	ndr->depth++;
	ndr_print_GUID(ndr, "uuid", &r->uuid);
	ndr_print_uint32(ndr, "if_version", r->if_version);
	ndr_print_uint32(ndr, "callnum", r->callnum);
	ndr_print_uint32(ndr, "callid", r->callid);
	ndr_print_irpc_flags(ndr, "flags", r->flags);
	ndr_print_NTSTATUS(ndr, "status", r->status);
	ndr->depth--;
}

static NTSTATUS ndr_push_nbtd_info_level(struct ndr_push *ndr, int ndr_flags, enum nbtd_info_level r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_nbtd_info_level(struct ndr_pull *ndr, int ndr_flags, enum nbtd_info_level *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_nbtd_info_level(struct ndr_print *ndr, const char *name, enum nbtd_info_level r)
{
	const char *val = NULL;

	switch (r) {
		case NBTD_INFO_STATISTICS: val = "NBTD_INFO_STATISTICS"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static NTSTATUS ndr_push_nbtd_statistics(struct ndr_push *ndr, int ndr_flags, const struct nbtd_statistics *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->total_received));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->total_sent));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->query_count));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->register_count));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->release_count));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_nbtd_statistics(struct ndr_pull *ndr, int ndr_flags, struct nbtd_statistics *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->total_received));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->total_sent));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->query_count));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->register_count));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->release_count));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_nbtd_statistics(struct ndr_print *ndr, const char *name, const struct nbtd_statistics *r)
{
	ndr_print_struct(ndr, name, "nbtd_statistics");
	ndr->depth++;
	ndr_print_hyper(ndr, "total_received", r->total_received);
	ndr_print_hyper(ndr, "total_sent", r->total_sent);
	ndr_print_hyper(ndr, "query_count", r->query_count);
	ndr_print_hyper(ndr, "register_count", r->register_count);
	ndr_print_hyper(ndr, "release_count", r->release_count);
	ndr->depth--;
}

static NTSTATUS ndr_push_nbtd_info(struct ndr_push *ndr, int ndr_flags, const union nbtd_info *r)
{
	int level;
	level = ndr_push_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		switch (level) {
			case NBTD_INFO_STATISTICS:
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->stats));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case NBTD_INFO_STATISTICS:
				if (r->stats) {
					NDR_CHECK(ndr_push_nbtd_statistics(ndr, NDR_SCALARS, r->stats));
				}
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_nbtd_info(struct ndr_pull *ndr, int ndr_flags, union nbtd_info *r)
{
	int level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_stats_0;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for nbtd_info", _level);
		}
		switch (level) {
			case NBTD_INFO_STATISTICS: {
				uint32_t _ptr_stats;
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_stats));
				if (_ptr_stats) {
					NDR_PULL_ALLOC(ndr, r->stats);
				} else {
					r->stats = NULL;
				}
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case NBTD_INFO_STATISTICS:
				if (r->stats) {
					_mem_save_stats_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->stats, 0);
					NDR_CHECK(ndr_pull_nbtd_statistics(ndr, NDR_SCALARS, r->stats));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_stats_0, 0);
				}
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_nbtd_info(struct ndr_print *ndr, const char *name, const union nbtd_info *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "nbtd_info");
	switch (level) {
		case NBTD_INFO_STATISTICS:
			ndr_print_ptr(ndr, "stats", r->stats);
			ndr->depth++;
			if (r->stats) {
				ndr_print_nbtd_statistics(ndr, "stats", r->stats);
			}
			ndr->depth--;
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static NTSTATUS ndr_push_nbtd_proxy_wins_addr(struct ndr_push *ndr, int ndr_flags, const struct nbtd_proxy_wins_addr *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_ipv4address(ndr, NDR_SCALARS, r->addr));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_nbtd_proxy_wins_addr(struct ndr_pull *ndr, int ndr_flags, struct nbtd_proxy_wins_addr *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_ipv4address(ndr, NDR_SCALARS, &r->addr));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_nbtd_proxy_wins_addr(struct ndr_print *ndr, const char *name, const struct nbtd_proxy_wins_addr *r)
{
	ndr_print_struct(ndr, name, "nbtd_proxy_wins_addr");
	ndr->depth++;
	ndr_print_ipv4address(ndr, "addr", r->addr);
	ndr->depth--;
}

static NTSTATUS ndr_push_smbsrv_info_level(struct ndr_push *ndr, int ndr_flags, enum smbsrv_info_level r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_smbsrv_info_level(struct ndr_pull *ndr, int ndr_flags, enum smbsrv_info_level *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_smbsrv_info_level(struct ndr_print *ndr, const char *name, enum smbsrv_info_level r)
{
	const char *val = NULL;

	switch (r) {
		case SMBSRV_INFO_SESSIONS: val = "SMBSRV_INFO_SESSIONS"; break;
		case SMBSRV_INFO_TCONS: val = "SMBSRV_INFO_TCONS"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static NTSTATUS ndr_push_smbsrv_session_info(struct ndr_push *ndr, int ndr_flags, const struct smbsrv_session_info *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->vuid));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->account_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->domain_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->client_ip));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->connect_time));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->auth_time));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->last_use_time));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_smbsrv_session_info(struct ndr_pull *ndr, int ndr_flags, struct smbsrv_session_info *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->vuid));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->account_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->domain_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->client_ip));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->connect_time));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->auth_time));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->last_use_time));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_smbsrv_session_info(struct ndr_print *ndr, const char *name, const struct smbsrv_session_info *r)
{
	ndr_print_struct(ndr, name, "smbsrv_session_info");
	ndr->depth++;
	ndr_print_hyper(ndr, "vuid", r->vuid);
	ndr_print_string(ndr, "account_name", r->account_name);
	ndr_print_string(ndr, "domain_name", r->domain_name);
	ndr_print_string(ndr, "client_ip", r->client_ip);
	ndr_print_NTTIME(ndr, "connect_time", r->connect_time);
	ndr_print_NTTIME(ndr, "auth_time", r->auth_time);
	ndr_print_NTTIME(ndr, "last_use_time", r->last_use_time);
	ndr->depth--;
}

static NTSTATUS ndr_push_smbsrv_sessions(struct ndr_push *ndr, int ndr_flags, const struct smbsrv_sessions *r)
{
	uint32_t cntr_sessions_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_sessions));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->sessions));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->sessions) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_sessions));
			for (cntr_sessions_1 = 0; cntr_sessions_1 < r->num_sessions; cntr_sessions_1++) {
				NDR_CHECK(ndr_push_smbsrv_session_info(ndr, NDR_SCALARS, &r->sessions[cntr_sessions_1]));
			}
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_smbsrv_sessions(struct ndr_pull *ndr, int ndr_flags, struct smbsrv_sessions *r)
{
	uint32_t _ptr_sessions;
	uint32_t cntr_sessions_1;
	TALLOC_CTX *_mem_save_sessions_0;
	TALLOC_CTX *_mem_save_sessions_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_sessions));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sessions));
		if (_ptr_sessions) {
			NDR_PULL_ALLOC(ndr, r->sessions);
		} else {
			r->sessions = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->sessions) {
			_mem_save_sessions_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sessions, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->sessions));
			NDR_PULL_ALLOC_N(ndr, r->sessions, ndr_get_array_size(ndr, &r->sessions));
			_mem_save_sessions_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sessions, 0);
			for (cntr_sessions_1 = 0; cntr_sessions_1 < r->num_sessions; cntr_sessions_1++) {
				NDR_CHECK(ndr_pull_smbsrv_session_info(ndr, NDR_SCALARS, &r->sessions[cntr_sessions_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sessions_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sessions_0, 0);
		}
		if (r->sessions) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->sessions, r->num_sessions));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_smbsrv_sessions(struct ndr_print *ndr, const char *name, const struct smbsrv_sessions *r)
{
	uint32_t cntr_sessions_1;
	ndr_print_struct(ndr, name, "smbsrv_sessions");
	ndr->depth++;
	ndr_print_uint32(ndr, "num_sessions", r->num_sessions);
	ndr_print_ptr(ndr, "sessions", r->sessions);
	ndr->depth++;
	if (r->sessions) {
		ndr->print(ndr, "%s: ARRAY(%d)", "sessions", r->num_sessions);
		ndr->depth++;
		for (cntr_sessions_1=0;cntr_sessions_1<r->num_sessions;cntr_sessions_1++) {
			char *idx_1=NULL;
			asprintf(&idx_1, "[%d]", cntr_sessions_1);
			if (idx_1) {
				ndr_print_smbsrv_session_info(ndr, "sessions", &r->sessions[cntr_sessions_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_smbsrv_tcon_info(struct ndr_push *ndr, int ndr_flags, const struct smbsrv_tcon_info *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->tid));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->share_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->client_ip));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->connect_time));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->last_use_time));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_smbsrv_tcon_info(struct ndr_pull *ndr, int ndr_flags, struct smbsrv_tcon_info *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->tid));
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->share_name));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->client_ip));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->connect_time));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->last_use_time));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_smbsrv_tcon_info(struct ndr_print *ndr, const char *name, const struct smbsrv_tcon_info *r)
{
	ndr_print_struct(ndr, name, "smbsrv_tcon_info");
	ndr->depth++;
	ndr_print_uint32(ndr, "tid", r->tid);
	ndr_print_string(ndr, "share_name", r->share_name);
	ndr_print_string(ndr, "client_ip", r->client_ip);
	ndr_print_NTTIME(ndr, "connect_time", r->connect_time);
	ndr_print_NTTIME(ndr, "last_use_time", r->last_use_time);
	ndr->depth--;
}

static NTSTATUS ndr_push_smbsrv_tcons(struct ndr_push *ndr, int ndr_flags, const struct smbsrv_tcons *r)
{
	uint32_t cntr_tcons_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_tcons));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->tcons));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->tcons) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_tcons));
			for (cntr_tcons_1 = 0; cntr_tcons_1 < r->num_tcons; cntr_tcons_1++) {
				NDR_CHECK(ndr_push_smbsrv_tcon_info(ndr, NDR_SCALARS, &r->tcons[cntr_tcons_1]));
			}
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_smbsrv_tcons(struct ndr_pull *ndr, int ndr_flags, struct smbsrv_tcons *r)
{
	uint32_t _ptr_tcons;
	uint32_t cntr_tcons_1;
	TALLOC_CTX *_mem_save_tcons_0;
	TALLOC_CTX *_mem_save_tcons_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_tcons));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_tcons));
		if (_ptr_tcons) {
			NDR_PULL_ALLOC(ndr, r->tcons);
		} else {
			r->tcons = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->tcons) {
			_mem_save_tcons_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->tcons, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->tcons));
			NDR_PULL_ALLOC_N(ndr, r->tcons, ndr_get_array_size(ndr, &r->tcons));
			_mem_save_tcons_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->tcons, 0);
			for (cntr_tcons_1 = 0; cntr_tcons_1 < r->num_tcons; cntr_tcons_1++) {
				NDR_CHECK(ndr_pull_smbsrv_tcon_info(ndr, NDR_SCALARS, &r->tcons[cntr_tcons_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_tcons_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_tcons_0, 0);
		}
		if (r->tcons) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->tcons, r->num_tcons));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_smbsrv_tcons(struct ndr_print *ndr, const char *name, const struct smbsrv_tcons *r)
{
	uint32_t cntr_tcons_1;
	ndr_print_struct(ndr, name, "smbsrv_tcons");
	ndr->depth++;
	ndr_print_uint32(ndr, "num_tcons", r->num_tcons);
	ndr_print_ptr(ndr, "tcons", r->tcons);
	ndr->depth++;
	if (r->tcons) {
		ndr->print(ndr, "%s: ARRAY(%d)", "tcons", r->num_tcons);
		ndr->depth++;
		for (cntr_tcons_1=0;cntr_tcons_1<r->num_tcons;cntr_tcons_1++) {
			char *idx_1=NULL;
			asprintf(&idx_1, "[%d]", cntr_tcons_1);
			if (idx_1) {
				ndr_print_smbsrv_tcon_info(ndr, "tcons", &r->tcons[cntr_tcons_1]);
				free(idx_1);
			}
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_smbsrv_info(struct ndr_push *ndr, int ndr_flags, const union smbsrv_info *r)
{
	int level;
	level = ndr_push_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		switch (level) {
			case SMBSRV_INFO_SESSIONS:
				NDR_CHECK(ndr_push_smbsrv_sessions(ndr, NDR_SCALARS, &r->sessions));
			break;

			case SMBSRV_INFO_TCONS:
				NDR_CHECK(ndr_push_smbsrv_tcons(ndr, NDR_SCALARS, &r->tcons));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case SMBSRV_INFO_SESSIONS:
				NDR_CHECK(ndr_push_smbsrv_sessions(ndr, NDR_BUFFERS, &r->sessions));
			break;

			case SMBSRV_INFO_TCONS:
				NDR_CHECK(ndr_push_smbsrv_tcons(ndr, NDR_BUFFERS, &r->tcons));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_smbsrv_info(struct ndr_pull *ndr, int ndr_flags, union smbsrv_info *r)
{
	int level;
	uint32_t _level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for smbsrv_info", _level);
		}
		switch (level) {
			case SMBSRV_INFO_SESSIONS: {
				NDR_CHECK(ndr_pull_smbsrv_sessions(ndr, NDR_SCALARS, &r->sessions));
			break; }

			case SMBSRV_INFO_TCONS: {
				NDR_CHECK(ndr_pull_smbsrv_tcons(ndr, NDR_SCALARS, &r->tcons));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case SMBSRV_INFO_SESSIONS:
				NDR_CHECK(ndr_pull_smbsrv_sessions(ndr, NDR_BUFFERS, &r->sessions));
			break;

			case SMBSRV_INFO_TCONS:
				NDR_CHECK(ndr_pull_smbsrv_tcons(ndr, NDR_BUFFERS, &r->tcons));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_smbsrv_info(struct ndr_print *ndr, const char *name, const union smbsrv_info *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "smbsrv_info");
	switch (level) {
		case SMBSRV_INFO_SESSIONS:
			ndr_print_smbsrv_sessions(ndr, "sessions", &r->sessions);
		break;

		case SMBSRV_INFO_TCONS:
			ndr_print_smbsrv_tcons(ndr, "tcons", &r->tcons);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static NTSTATUS ndr_push_irpc_uptime(struct ndr_push *ndr, int flags, const struct irpc_uptime *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		if (r->out.start_time == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, *r->out.start_time));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_irpc_uptime(struct ndr_pull *ndr, int flags, struct irpc_uptime *r)
{
	TALLOC_CTX *_mem_save_start_time_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_PULL_ALLOC(ndr, r->out.start_time);
		ZERO_STRUCTP(r->out.start_time);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.start_time);
		}
		_mem_save_start_time_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.start_time, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, r->out.start_time));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_start_time_0, LIBNDR_FLAG_REF_ALLOC);
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_irpc_uptime(struct ndr_print *ndr, const char *name, int flags, const struct irpc_uptime *r)
{
	ndr_print_struct(ndr, name, "irpc_uptime");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "irpc_uptime");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "irpc_uptime");
		ndr->depth++;
		ndr_print_ptr(ndr, "start_time", r->out.start_time);
		ndr->depth++;
		ndr_print_NTTIME(ndr, "start_time", *r->out.start_time);
		ndr->depth--;
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_nbtd_information(struct ndr_push *ndr, int flags, const struct nbtd_information *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_nbtd_info_level(ndr, NDR_SCALARS, r->in.level));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->out.info, r->in.level));
		NDR_CHECK(ndr_push_nbtd_info(ndr, NDR_SCALARS|NDR_BUFFERS, &r->out.info));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_nbtd_information(struct ndr_pull *ndr, int flags, struct nbtd_information *r)
{
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_nbtd_info_level(ndr, NDR_SCALARS, &r->in.level));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->out.info, r->in.level));
		NDR_CHECK(ndr_pull_nbtd_info(ndr, NDR_SCALARS|NDR_BUFFERS, &r->out.info));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_nbtd_information(struct ndr_print *ndr, const char *name, int flags, const struct nbtd_information *r)
{
	ndr_print_struct(ndr, name, "nbtd_information");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "nbtd_information");
		ndr->depth++;
		ndr_print_nbtd_info_level(ndr, "level", r->in.level);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "nbtd_information");
		ndr->depth++;
		ndr_print_set_switch_value(ndr, &r->out.info, r->in.level);
		ndr_print_nbtd_info(ndr, "info", &r->out.info);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_nbtd_getdcname(struct ndr_push *ndr, int flags, const struct nbtd_getdcname *r)
{
	if (flags & NDR_IN) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->in.domainname));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->in.ip_address));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->in.my_computername));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->in.my_accountname));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.account_control));
		if (r->in.domain_sid == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_dom_sid(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.domain_sid));
	}
	if (flags & NDR_OUT) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.dcname));
			if (r->out.dcname) {
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->out.dcname));
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_nbtd_getdcname(struct ndr_pull *ndr, int flags, struct nbtd_getdcname *r)
{
	uint32_t _ptr_dcname;
	TALLOC_CTX *_mem_save_domain_sid_0;
	TALLOC_CTX *_mem_save_dcname_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->in.domainname));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->in.ip_address));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->in.my_computername));
			ndr->flags = _flags_save_string;
		}
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->in.my_accountname));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.account_control));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.domain_sid);
		}
		_mem_save_domain_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.domain_sid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_dom_sid(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.domain_sid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_sid_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
		{
			uint32_t _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dcname));
			if (_ptr_dcname) {
				NDR_PULL_ALLOC(ndr, r->out.dcname);
			} else {
				r->out.dcname = NULL;
			}
			if (r->out.dcname) {
				_mem_save_dcname_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->out.dcname, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->out.dcname));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dcname_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_nbtd_getdcname(struct ndr_print *ndr, const char *name, int flags, const struct nbtd_getdcname *r)
{
	ndr_print_struct(ndr, name, "nbtd_getdcname");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "nbtd_getdcname");
		ndr->depth++;
		ndr_print_string(ndr, "domainname", r->in.domainname);
		ndr_print_string(ndr, "ip_address", r->in.ip_address);
		ndr_print_string(ndr, "my_computername", r->in.my_computername);
		ndr_print_string(ndr, "my_accountname", r->in.my_accountname);
		ndr_print_uint32(ndr, "account_control", r->in.account_control);
		ndr_print_ptr(ndr, "domain_sid", r->in.domain_sid);
		ndr->depth++;
		ndr_print_dom_sid(ndr, "domain_sid", r->in.domain_sid);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "nbtd_getdcname");
		ndr->depth++;
		ndr_print_ptr(ndr, "dcname", r->out.dcname);
		ndr->depth++;
		if (r->out.dcname) {
			ndr_print_string(ndr, "dcname", r->out.dcname);
		}
		ndr->depth--;
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_nbtd_proxy_wins_challenge(struct ndr_push *ndr, int flags, const struct nbtd_proxy_wins_challenge *r)
{
	uint32_t cntr_addrs_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_nbt_name(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.num_addrs));
		for (cntr_addrs_0 = 0; cntr_addrs_0 < r->in.num_addrs; cntr_addrs_0++) {
			NDR_CHECK(ndr_push_nbtd_proxy_wins_addr(ndr, NDR_SCALARS, &r->in.addrs[cntr_addrs_0]));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->out.num_addrs));
		for (cntr_addrs_0 = 0; cntr_addrs_0 < r->out.num_addrs; cntr_addrs_0++) {
			NDR_CHECK(ndr_push_nbtd_proxy_wins_addr(ndr, NDR_SCALARS, &r->out.addrs[cntr_addrs_0]));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_nbtd_proxy_wins_challenge(struct ndr_pull *ndr, int flags, struct nbtd_proxy_wins_challenge *r)
{
	uint32_t cntr_addrs_0;
	TALLOC_CTX *_mem_save_addrs_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_nbt_name(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.name));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.num_addrs));
		NDR_PULL_ALLOC_N(ndr, r->in.addrs, r->in.num_addrs);
		_mem_save_addrs_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.addrs, 0);
		for (cntr_addrs_0 = 0; cntr_addrs_0 < r->in.num_addrs; cntr_addrs_0++) {
			NDR_CHECK(ndr_pull_nbtd_proxy_wins_addr(ndr, NDR_SCALARS, &r->in.addrs[cntr_addrs_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_addrs_0, 0);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->out.num_addrs));
		NDR_PULL_ALLOC_N(ndr, r->out.addrs, r->out.num_addrs);
		_mem_save_addrs_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.addrs, 0);
		for (cntr_addrs_0 = 0; cntr_addrs_0 < r->out.num_addrs; cntr_addrs_0++) {
			NDR_CHECK(ndr_pull_nbtd_proxy_wins_addr(ndr, NDR_SCALARS, &r->out.addrs[cntr_addrs_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_addrs_0, 0);
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_nbtd_proxy_wins_challenge(struct ndr_print *ndr, const char *name, int flags, const struct nbtd_proxy_wins_challenge *r)
{
	uint32_t cntr_addrs_0;
	ndr_print_struct(ndr, name, "nbtd_proxy_wins_challenge");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "nbtd_proxy_wins_challenge");
		ndr->depth++;
		ndr_print_nbt_name(ndr, "name", &r->in.name);
		ndr_print_uint32(ndr, "num_addrs", r->in.num_addrs);
		ndr->print(ndr, "%s: ARRAY(%d)", "addrs", r->in.num_addrs);
		ndr->depth++;
		for (cntr_addrs_0=0;cntr_addrs_0<r->in.num_addrs;cntr_addrs_0++) {
			char *idx_0=NULL;
			asprintf(&idx_0, "[%d]", cntr_addrs_0);
			if (idx_0) {
				ndr_print_nbtd_proxy_wins_addr(ndr, "addrs", &r->in.addrs[cntr_addrs_0]);
				free(idx_0);
			}
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "nbtd_proxy_wins_challenge");
		ndr->depth++;
		ndr_print_uint32(ndr, "num_addrs", r->out.num_addrs);
		ndr->print(ndr, "%s: ARRAY(%d)", "addrs", r->out.num_addrs);
		ndr->depth++;
		for (cntr_addrs_0=0;cntr_addrs_0<r->out.num_addrs;cntr_addrs_0++) {
			char *idx_0=NULL;
			asprintf(&idx_0, "[%d]", cntr_addrs_0);
			if (idx_0) {
				ndr_print_nbtd_proxy_wins_addr(ndr, "addrs", &r->out.addrs[cntr_addrs_0]);
				free(idx_0);
			}
		}
		ndr->depth--;
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_nbtd_proxy_wins_release_demand(struct ndr_push *ndr, int flags, const struct nbtd_proxy_wins_release_demand *r)
{
	uint32_t cntr_addrs_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_nbt_name(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.num_addrs));
		for (cntr_addrs_0 = 0; cntr_addrs_0 < r->in.num_addrs; cntr_addrs_0++) {
			NDR_CHECK(ndr_push_nbtd_proxy_wins_addr(ndr, NDR_SCALARS, &r->in.addrs[cntr_addrs_0]));
		}
	}
	if (flags & NDR_OUT) {
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_nbtd_proxy_wins_release_demand(struct ndr_pull *ndr, int flags, struct nbtd_proxy_wins_release_demand *r)
{
	uint32_t cntr_addrs_0;
	TALLOC_CTX *_mem_save_addrs_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_nbt_name(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.name));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.num_addrs));
		NDR_PULL_ALLOC_N(ndr, r->in.addrs, r->in.num_addrs);
		_mem_save_addrs_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.addrs, 0);
		for (cntr_addrs_0 = 0; cntr_addrs_0 < r->in.num_addrs; cntr_addrs_0++) {
			NDR_CHECK(ndr_pull_nbtd_proxy_wins_addr(ndr, NDR_SCALARS, &r->in.addrs[cntr_addrs_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_addrs_0, 0);
	}
	if (flags & NDR_OUT) {
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_nbtd_proxy_wins_release_demand(struct ndr_print *ndr, const char *name, int flags, const struct nbtd_proxy_wins_release_demand *r)
{
	uint32_t cntr_addrs_0;
	ndr_print_struct(ndr, name, "nbtd_proxy_wins_release_demand");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "nbtd_proxy_wins_release_demand");
		ndr->depth++;
		ndr_print_nbt_name(ndr, "name", &r->in.name);
		ndr_print_uint32(ndr, "num_addrs", r->in.num_addrs);
		ndr->print(ndr, "%s: ARRAY(%d)", "addrs", r->in.num_addrs);
		ndr->depth++;
		for (cntr_addrs_0=0;cntr_addrs_0<r->in.num_addrs;cntr_addrs_0++) {
			char *idx_0=NULL;
			asprintf(&idx_0, "[%d]", cntr_addrs_0);
			if (idx_0) {
				ndr_print_nbtd_proxy_wins_addr(ndr, "addrs", &r->in.addrs[cntr_addrs_0]);
				free(idx_0);
			}
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "nbtd_proxy_wins_release_demand");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_smbsrv_information(struct ndr_push *ndr, int flags, const struct smbsrv_information *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_smbsrv_info_level(ndr, NDR_SCALARS, r->in.level));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->out.info, r->in.level));
		NDR_CHECK(ndr_push_smbsrv_info(ndr, NDR_SCALARS|NDR_BUFFERS, &r->out.info));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_smbsrv_information(struct ndr_pull *ndr, int flags, struct smbsrv_information *r)
{
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_smbsrv_info_level(ndr, NDR_SCALARS, &r->in.level));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->out.info, r->in.level));
		NDR_CHECK(ndr_pull_smbsrv_info(ndr, NDR_SCALARS|NDR_BUFFERS, &r->out.info));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_smbsrv_information(struct ndr_print *ndr, const char *name, int flags, const struct smbsrv_information *r)
{
	ndr_print_struct(ndr, name, "smbsrv_information");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "smbsrv_information");
		ndr->depth++;
		ndr_print_smbsrv_info_level(ndr, "level", r->in.level);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "smbsrv_information");
		ndr->depth++;
		ndr_print_set_switch_value(ndr, &r->out.info, r->in.level);
		ndr_print_smbsrv_info(ndr, "info", &r->out.info);
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct dcerpc_interface_call irpc_calls[] = {
	{
		"irpc_uptime",
		sizeof(struct irpc_uptime),
		(ndr_push_flags_fn_t) ndr_push_irpc_uptime,
		(ndr_pull_flags_fn_t) ndr_pull_irpc_uptime,
		(ndr_print_function_t) ndr_print_irpc_uptime,
		False,
	},
	{
		"nbtd_information",
		sizeof(struct nbtd_information),
		(ndr_push_flags_fn_t) ndr_push_nbtd_information,
		(ndr_pull_flags_fn_t) ndr_pull_nbtd_information,
		(ndr_print_function_t) ndr_print_nbtd_information,
		False,
	},
	{
		"nbtd_getdcname",
		sizeof(struct nbtd_getdcname),
		(ndr_push_flags_fn_t) ndr_push_nbtd_getdcname,
		(ndr_pull_flags_fn_t) ndr_pull_nbtd_getdcname,
		(ndr_print_function_t) ndr_print_nbtd_getdcname,
		False,
	},
	{
		"nbtd_proxy_wins_challenge",
		sizeof(struct nbtd_proxy_wins_challenge),
		(ndr_push_flags_fn_t) ndr_push_nbtd_proxy_wins_challenge,
		(ndr_pull_flags_fn_t) ndr_pull_nbtd_proxy_wins_challenge,
		(ndr_print_function_t) ndr_print_nbtd_proxy_wins_challenge,
		False,
	},
	{
		"nbtd_proxy_wins_release_demand",
		sizeof(struct nbtd_proxy_wins_release_demand),
		(ndr_push_flags_fn_t) ndr_push_nbtd_proxy_wins_release_demand,
		(ndr_pull_flags_fn_t) ndr_pull_nbtd_proxy_wins_release_demand,
		(ndr_print_function_t) ndr_print_nbtd_proxy_wins_release_demand,
		False,
	},
	{
		"smbsrv_information",
		sizeof(struct smbsrv_information),
		(ndr_push_flags_fn_t) ndr_push_smbsrv_information,
		(ndr_pull_flags_fn_t) ndr_pull_smbsrv_information,
		(ndr_print_function_t) ndr_print_smbsrv_information,
		False,
	},
	{ NULL, 0, NULL, NULL, NULL, False }
};

static const char * const irpc_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\irpc]", 
};

static const struct dcerpc_endpoint_list irpc_endpoints = {
	.count	= 1,
	.names	= irpc_endpoint_strings
};

static const char * const irpc_authservice_strings[] = {
	"host", 
};

static const struct dcerpc_authservice_list irpc_authservices = {
	.count	= 1,
	.names	= irpc_authservice_strings
};


const struct dcerpc_interface_table dcerpc_table_irpc = {
	.name		= "irpc",
	.syntax_id	= {
		{0xe770c620,0x0b06,0x4b5e,{0x8d,0x87},{0xa2,0x6e,0x20,0xf2,0x83,0x40}},
		DCERPC_IRPC_VERSION
	},
	.helpstring	= DCERPC_IRPC_HELPSTRING,
	.num_calls	= 6,
	.calls		= irpc_calls,
	.endpoints	= &irpc_endpoints,
	.authservices	= &irpc_authservices
};

