
/* EJS wrapper functions auto-generated by pidl */
#include "includes.h"
#include "librpc/rpc/dcerpc.h"
#include "lib/appweb/ejs/ejs.h"
#include "scripting/ejs/ejsrpc.h"
#include "scripting/ejs/smbcalls.h"
#include "librpc/gen_ndr/ndr_misc_ejs.h"
#include "librpc/gen_ndr/ndr_efs.h"
#include "librpc/gen_ndr/ndr_efs_ejs.h"


static NTSTATUS ejs_push_EFS_HASH_BLOB(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct EFS_HASH_BLOB *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "cbData", &r->cbData));
	if (NULL == r->pbData) {
		NDR_CHECK(ejs_push_null(ejs, v, "pbData"));
	} else {
		ejs_push_array_uint8(ejs, v, "pbData", r->pbData, r->cbData);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_ENCRYPTION_CERTIFICATE_HASH(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct ENCRYPTION_CERTIFICATE_HASH *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "cbTotalLength", &r->cbTotalLength));
	if (NULL == r->pUserSid) {
		NDR_CHECK(ejs_push_null(ejs, v, "pUserSid"));
	} else {
		NDR_CHECK(ejs_push_dom_sid(ejs, v, "pUserSid", r->pUserSid));
	}
	if (NULL == r->pHash) {
		NDR_CHECK(ejs_push_null(ejs, v, "pHash"));
	} else {
		NDR_CHECK(ejs_push_EFS_HASH_BLOB(ejs, v, "pHash", r->pHash));
	}
	if (NULL == r->lpDisplayInformation) {
		NDR_CHECK(ejs_push_null(ejs, v, "lpDisplayInformation"));
	} else {
		NDR_CHECK(ejs_push_string(ejs, v, "lpDisplayInformation", r->lpDisplayInformation));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_ENCRYPTION_CERTIFICATE_HASH_LIST(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct ENCRYPTION_CERTIFICATE_HASH_LIST *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "nCert_Hash", &r->nCert_Hash));
	{
		uint32_t i;
		for (i=0;i<r->nCert_Hash;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "pUsers", i);
			if (NULL == r->pUsers[i]) {
				NDR_CHECK(ejs_push_null(ejs, v, id));
			} else {
				NDR_CHECK(ejs_push_ENCRYPTION_CERTIFICATE_HASH(ejs, v, id, r->pUsers[i]));
			}
		}
		ejs_push_uint32(ejs, v, "pUsers" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_EFS_CERTIFICATE_BLOB(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct EFS_CERTIFICATE_BLOB *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "dwCertEncodingType", &r->dwCertEncodingType));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "cbData", &r->cbData));
	if (ejs_pull_null(ejs, v, "pbData")) {
		r->pbData = NULL;
	} else {
		EJS_ALLOC(ejs, r->pbData);
		EJS_ALLOC_N(ejs, r->pbData, r->cbData);
		ejs_pull_array_uint8(ejs, v, "pbData", r->pbData, r->cbData);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_ENCRYPTION_CERTIFICATE(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct ENCRYPTION_CERTIFICATE *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "TotalLength", &r->TotalLength));
	if (ejs_pull_null(ejs, v, "pUserSid")) {
		r->pUserSid = NULL;
	} else {
		EJS_ALLOC(ejs, r->pUserSid);
		NDR_CHECK(ejs_pull_dom_sid(ejs, v, "pUserSid", r->pUserSid));
	}
	if (ejs_pull_null(ejs, v, "pCertBlob")) {
		r->pCertBlob = NULL;
	} else {
		EJS_ALLOC(ejs, r->pCertBlob);
		NDR_CHECK(ejs_pull_EFS_CERTIFICATE_BLOB(ejs, v, "pCertBlob", r->pCertBlob));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_pull_EfsRpcOpenFileRaw(struct ejs_rpc *ejs, struct MprVar *v, struct EfsRpcOpenFileRaw *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_string(ejs, v, "FileName", &r->in.FileName));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "Flags", &r->in.Flags));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_EfsRpcOpenFileRaw(struct ejs_rpc *ejs, struct MprVar *v, const struct EfsRpcOpenFileRaw *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.pvContext) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "pvContext", r->out.pvContext));
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_EfsRpcOpenFileRaw(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_efs, DCERPC_EFSRPCOPENFILERAW, (ejs_pull_function_t)ejs_pull_EfsRpcOpenFileRaw, (ejs_push_function_t)ejs_push_EfsRpcOpenFileRaw);
}


static NTSTATUS ejs_pull_EfsRpcReadFileRaw(struct ejs_rpc *ejs, struct MprVar *v, struct EfsRpcReadFileRaw *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "pvContext")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.pvContext);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "pvContext", r->in.pvContext));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_EfsRpcReadFileRaw(struct ejs_rpc *ejs, struct MprVar *v, const struct EfsRpcReadFileRaw *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_EfsRpcReadFileRaw(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_efs, DCERPC_EFSRPCREADFILERAW, (ejs_pull_function_t)ejs_pull_EfsRpcReadFileRaw, (ejs_push_function_t)ejs_push_EfsRpcReadFileRaw);
}


static NTSTATUS ejs_pull_EfsRpcWriteFileRaw(struct ejs_rpc *ejs, struct MprVar *v, struct EfsRpcWriteFileRaw *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "pvContext")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.pvContext);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "pvContext", r->in.pvContext));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_EfsRpcWriteFileRaw(struct ejs_rpc *ejs, struct MprVar *v, const struct EfsRpcWriteFileRaw *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_EfsRpcWriteFileRaw(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_efs, DCERPC_EFSRPCWRITEFILERAW, (ejs_pull_function_t)ejs_pull_EfsRpcWriteFileRaw, (ejs_push_function_t)ejs_push_EfsRpcWriteFileRaw);
}


static NTSTATUS ejs_pull_EfsRpcCloseRaw(struct ejs_rpc *ejs, struct MprVar *v, struct EfsRpcCloseRaw *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "pvContext")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.pvContext);
		NDR_CHECK(ejs_pull_policy_handle(ejs, v, "pvContext", r->in.pvContext));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_EfsRpcCloseRaw(struct ejs_rpc *ejs, struct MprVar *v, const struct EfsRpcCloseRaw *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.pvContext) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_policy_handle(ejs, v, "pvContext", r->out.pvContext));
	}
	return NT_STATUS_OK;
}

static int ejs_EfsRpcCloseRaw(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_efs, DCERPC_EFSRPCCLOSERAW, (ejs_pull_function_t)ejs_pull_EfsRpcCloseRaw, (ejs_push_function_t)ejs_push_EfsRpcCloseRaw);
}


static NTSTATUS ejs_pull_EfsRpcEncryptFileSrv(struct ejs_rpc *ejs, struct MprVar *v, struct EfsRpcEncryptFileSrv *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_string(ejs, v, "Filename", &r->in.Filename));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_EfsRpcEncryptFileSrv(struct ejs_rpc *ejs, struct MprVar *v, const struct EfsRpcEncryptFileSrv *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_EfsRpcEncryptFileSrv(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_efs, DCERPC_EFSRPCENCRYPTFILESRV, (ejs_pull_function_t)ejs_pull_EfsRpcEncryptFileSrv, (ejs_push_function_t)ejs_push_EfsRpcEncryptFileSrv);
}


static NTSTATUS ejs_pull_EfsRpcDecryptFileSrv(struct ejs_rpc *ejs, struct MprVar *v, struct EfsRpcDecryptFileSrv *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_string(ejs, v, "FileName", &r->in.FileName));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "Reserved", &r->in.Reserved));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_EfsRpcDecryptFileSrv(struct ejs_rpc *ejs, struct MprVar *v, const struct EfsRpcDecryptFileSrv *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_EfsRpcDecryptFileSrv(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_efs, DCERPC_EFSRPCDECRYPTFILESRV, (ejs_pull_function_t)ejs_pull_EfsRpcDecryptFileSrv, (ejs_push_function_t)ejs_push_EfsRpcDecryptFileSrv);
}


static NTSTATUS ejs_pull_EfsRpcQueryUsersOnFile(struct ejs_rpc *ejs, struct MprVar *v, struct EfsRpcQueryUsersOnFile *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_string(ejs, v, "FileName", &r->in.FileName));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_EfsRpcQueryUsersOnFile(struct ejs_rpc *ejs, struct MprVar *v, const struct EfsRpcQueryUsersOnFile *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.pUsers) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		if (NULL == *r->out.pUsers) {
			return NT_STATUS_INVALID_PARAMETER_MIX;
		} else {
			NDR_CHECK(ejs_push_ENCRYPTION_CERTIFICATE_HASH_LIST(ejs, v, "pUsers", *r->out.pUsers));
		}
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_EfsRpcQueryUsersOnFile(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_efs, DCERPC_EFSRPCQUERYUSERSONFILE, (ejs_pull_function_t)ejs_pull_EfsRpcQueryUsersOnFile, (ejs_push_function_t)ejs_push_EfsRpcQueryUsersOnFile);
}


static NTSTATUS ejs_pull_EfsRpcQueryRecoveryAgents(struct ejs_rpc *ejs, struct MprVar *v, struct EfsRpcQueryRecoveryAgents *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_string(ejs, v, "FileName", &r->in.FileName));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_EfsRpcQueryRecoveryAgents(struct ejs_rpc *ejs, struct MprVar *v, const struct EfsRpcQueryRecoveryAgents *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.pRecoveryAgents) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		if (NULL == *r->out.pRecoveryAgents) {
			return NT_STATUS_INVALID_PARAMETER_MIX;
		} else {
			NDR_CHECK(ejs_push_ENCRYPTION_CERTIFICATE_HASH_LIST(ejs, v, "pRecoveryAgents", *r->out.pRecoveryAgents));
		}
	}
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_EfsRpcQueryRecoveryAgents(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_efs, DCERPC_EFSRPCQUERYRECOVERYAGENTS, (ejs_pull_function_t)ejs_pull_EfsRpcQueryRecoveryAgents, (ejs_push_function_t)ejs_push_EfsRpcQueryRecoveryAgents);
}


static NTSTATUS ejs_pull_EfsRpcRemoveUsersFromFile(struct ejs_rpc *ejs, struct MprVar *v, struct EfsRpcRemoveUsersFromFile *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_string(ejs, v, "FileName", &r->in.FileName));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_EfsRpcRemoveUsersFromFile(struct ejs_rpc *ejs, struct MprVar *v, const struct EfsRpcRemoveUsersFromFile *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_EfsRpcRemoveUsersFromFile(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_efs, DCERPC_EFSRPCREMOVEUSERSFROMFILE, (ejs_pull_function_t)ejs_pull_EfsRpcRemoveUsersFromFile, (ejs_push_function_t)ejs_push_EfsRpcRemoveUsersFromFile);
}


static NTSTATUS ejs_pull_EfsRpcAddUsersToFile(struct ejs_rpc *ejs, struct MprVar *v, struct EfsRpcAddUsersToFile *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_string(ejs, v, "FileName", &r->in.FileName));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_EfsRpcAddUsersToFile(struct ejs_rpc *ejs, struct MprVar *v, const struct EfsRpcAddUsersToFile *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_EfsRpcAddUsersToFile(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_efs, DCERPC_EFSRPCADDUSERSTOFILE, (ejs_pull_function_t)ejs_pull_EfsRpcAddUsersToFile, (ejs_push_function_t)ejs_push_EfsRpcAddUsersToFile);
}


static NTSTATUS ejs_pull_EfsRpcSetFileEncryptionKey(struct ejs_rpc *ejs, struct MprVar *v, struct EfsRpcSetFileEncryptionKey *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "pEncryptionCertificate")) {
		r->in.pEncryptionCertificate = NULL;
	} else {
		EJS_ALLOC(ejs, r->in.pEncryptionCertificate);
		NDR_CHECK(ejs_pull_ENCRYPTION_CERTIFICATE(ejs, v, "pEncryptionCertificate", r->in.pEncryptionCertificate));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_EfsRpcSetFileEncryptionKey(struct ejs_rpc *ejs, struct MprVar *v, const struct EfsRpcSetFileEncryptionKey *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_EfsRpcSetFileEncryptionKey(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_efs, DCERPC_EFSRPCSETFILEENCRYPTIONKEY, (ejs_pull_function_t)ejs_pull_EfsRpcSetFileEncryptionKey, (ejs_push_function_t)ejs_push_EfsRpcSetFileEncryptionKey);
}


static NTSTATUS ejs_pull_EfsRpcNotSupported(struct ejs_rpc *ejs, struct MprVar *v, struct EfsRpcNotSupported *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_EfsRpcNotSupported(struct ejs_rpc *ejs, struct MprVar *v, const struct EfsRpcNotSupported *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_EfsRpcNotSupported(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_efs, DCERPC_EFSRPCNOTSUPPORTED, (ejs_pull_function_t)ejs_pull_EfsRpcNotSupported, (ejs_push_function_t)ejs_push_EfsRpcNotSupported);
}


static NTSTATUS ejs_pull_EfsRpcFileKeyInfo(struct ejs_rpc *ejs, struct MprVar *v, struct EfsRpcFileKeyInfo *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_EfsRpcFileKeyInfo(struct ejs_rpc *ejs, struct MprVar *v, const struct EfsRpcFileKeyInfo *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_EfsRpcFileKeyInfo(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_efs, DCERPC_EFSRPCFILEKEYINFO, (ejs_pull_function_t)ejs_pull_EfsRpcFileKeyInfo, (ejs_push_function_t)ejs_push_EfsRpcFileKeyInfo);
}


static NTSTATUS ejs_pull_EfsRpcDuplicateEncryptionInfoFile(struct ejs_rpc *ejs, struct MprVar *v, struct EfsRpcDuplicateEncryptionInfoFile *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_EfsRpcDuplicateEncryptionInfoFile(struct ejs_rpc *ejs, struct MprVar *v, const struct EfsRpcDuplicateEncryptionInfoFile *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_WERROR(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_EfsRpcDuplicateEncryptionInfoFile(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_efs, DCERPC_EFSRPCDUPLICATEENCRYPTIONINFOFILE, (ejs_pull_function_t)ejs_pull_EfsRpcDuplicateEncryptionInfoFile, (ejs_push_function_t)ejs_push_EfsRpcDuplicateEncryptionInfoFile);
}

static int ejs_efs_init(int eid, int argc, struct MprVar **argv)
{
	struct MprVar *obj = mprInitObject(eid, "efs", argc, argv);
	mprSetCFunction(obj, "EfsRpcOpenFileRaw", ejs_EfsRpcOpenFileRaw);
	mprSetCFunction(obj, "EfsRpcReadFileRaw", ejs_EfsRpcReadFileRaw);
	mprSetCFunction(obj, "EfsRpcWriteFileRaw", ejs_EfsRpcWriteFileRaw);
	mprSetCFunction(obj, "EfsRpcCloseRaw", ejs_EfsRpcCloseRaw);
	mprSetCFunction(obj, "EfsRpcEncryptFileSrv", ejs_EfsRpcEncryptFileSrv);
	mprSetCFunction(obj, "EfsRpcDecryptFileSrv", ejs_EfsRpcDecryptFileSrv);
	mprSetCFunction(obj, "EfsRpcQueryUsersOnFile", ejs_EfsRpcQueryUsersOnFile);
	mprSetCFunction(obj, "EfsRpcQueryRecoveryAgents", ejs_EfsRpcQueryRecoveryAgents);
	mprSetCFunction(obj, "EfsRpcRemoveUsersFromFile", ejs_EfsRpcRemoveUsersFromFile);
	mprSetCFunction(obj, "EfsRpcAddUsersToFile", ejs_EfsRpcAddUsersToFile);
	mprSetCFunction(obj, "EfsRpcSetFileEncryptionKey", ejs_EfsRpcSetFileEncryptionKey);
	mprSetCFunction(obj, "EfsRpcNotSupported", ejs_EfsRpcNotSupported);
	mprSetCFunction(obj, "EfsRpcFileKeyInfo", ejs_EfsRpcFileKeyInfo);
	mprSetCFunction(obj, "EfsRpcDuplicateEncryptionInfoFile", ejs_EfsRpcDuplicateEncryptionInfoFile);
	return ejs_rpc_init(obj, "efs");
}

NTSTATUS ejs_init_efs(void)
{
	ejsDefineCFunction(-1, "efs_init", ejs_efs_init, NULL, MPR_VAR_SCRIPT_HANDLE);
	return NT_STATUS_OK;
}
