/* parser auto-generated by pidl */

#include "includes.h"
#include "libcli/util/nterr.h"
#include "librpc/gen_ndr/ndr_misc.h"
#include "librpc/gen_ndr/ndr_dcerpc.h"
#include "librpc/rpc/dcerpc.h"
#include "librpc/gen_ndr/ndr_efs.h"

#include "librpc/gen_ndr/ndr_security.h"
static NTSTATUS ndr_push_EFS_HASH_BLOB(struct ndr_push *ndr, int ndr_flags, const struct EFS_HASH_BLOB *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->cbData));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pbData));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pbData) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->cbData));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->pbData, r->cbData));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_EFS_HASH_BLOB(struct ndr_pull *ndr, int ndr_flags, struct EFS_HASH_BLOB *r)
{
	uint32_t _ptr_pbData;
	TALLOC_CTX *_mem_save_pbData_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->cbData));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pbData));
		if (_ptr_pbData) {
			NDR_PULL_ALLOC(ndr, r->pbData);
		} else {
			r->pbData = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pbData) {
			_mem_save_pbData_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pbData, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pbData));
			NDR_PULL_ALLOC_N(ndr, r->pbData, ndr_get_array_size(ndr, &r->pbData));
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->pbData, ndr_get_array_size(ndr, &r->pbData)));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pbData_0, 0);
		}
		if (r->pbData) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->pbData, r->cbData));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_EFS_HASH_BLOB(struct ndr_print *ndr, const char *name, const struct EFS_HASH_BLOB *r)
{
	ndr_print_struct(ndr, name, "EFS_HASH_BLOB");
	ndr->depth++;
	ndr_print_uint32(ndr, "cbData", r->cbData);
	ndr_print_ptr(ndr, "pbData", r->pbData);
	ndr->depth++;
	if (r->pbData) {
		ndr_print_array_uint8(ndr, "pbData", r->pbData, r->cbData);
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_ENCRYPTION_CERTIFICATE_HASH(struct ndr_push *ndr, int ndr_flags, const struct ENCRYPTION_CERTIFICATE_HASH *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->cbTotalLength));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pUserSid));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pHash));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->lpDisplayInformation));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pUserSid) {
			NDR_CHECK(ndr_push_dom_sid(ndr, NDR_SCALARS|NDR_BUFFERS, r->pUserSid));
		}
		if (r->pHash) {
			NDR_CHECK(ndr_push_EFS_HASH_BLOB(ndr, NDR_SCALARS|NDR_BUFFERS, r->pHash));
		}
		if (r->lpDisplayInformation) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->lpDisplayInformation, CH_UTF16)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->lpDisplayInformation, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->lpDisplayInformation, ndr_charset_length(r->lpDisplayInformation, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_ENCRYPTION_CERTIFICATE_HASH(struct ndr_pull *ndr, int ndr_flags, struct ENCRYPTION_CERTIFICATE_HASH *r)
{
	uint32_t _ptr_pUserSid;
	TALLOC_CTX *_mem_save_pUserSid_0;
	uint32_t _ptr_pHash;
	TALLOC_CTX *_mem_save_pHash_0;
	uint32_t _ptr_lpDisplayInformation;
	TALLOC_CTX *_mem_save_lpDisplayInformation_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->cbTotalLength));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pUserSid));
		if (_ptr_pUserSid) {
			NDR_PULL_ALLOC(ndr, r->pUserSid);
		} else {
			r->pUserSid = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pHash));
		if (_ptr_pHash) {
			NDR_PULL_ALLOC(ndr, r->pHash);
		} else {
			r->pHash = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpDisplayInformation));
		if (_ptr_lpDisplayInformation) {
			NDR_PULL_ALLOC(ndr, r->lpDisplayInformation);
		} else {
			r->lpDisplayInformation = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pUserSid) {
			_mem_save_pUserSid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pUserSid, 0);
			NDR_CHECK(ndr_pull_dom_sid(ndr, NDR_SCALARS|NDR_BUFFERS, r->pUserSid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pUserSid_0, 0);
		}
		if (r->pHash) {
			_mem_save_pHash_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pHash, 0);
			NDR_CHECK(ndr_pull_EFS_HASH_BLOB(ndr, NDR_SCALARS|NDR_BUFFERS, r->pHash));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pHash_0, 0);
		}
		if (r->lpDisplayInformation) {
			_mem_save_lpDisplayInformation_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->lpDisplayInformation, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->lpDisplayInformation));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->lpDisplayInformation));
			if (ndr_get_array_length(ndr, &r->lpDisplayInformation) > ndr_get_array_size(ndr, &r->lpDisplayInformation)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->lpDisplayInformation), ndr_get_array_length(ndr, &r->lpDisplayInformation));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->lpDisplayInformation), sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->lpDisplayInformation, ndr_get_array_length(ndr, &r->lpDisplayInformation), sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpDisplayInformation_0, 0);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_ENCRYPTION_CERTIFICATE_HASH(struct ndr_print *ndr, const char *name, const struct ENCRYPTION_CERTIFICATE_HASH *r)
{
	ndr_print_struct(ndr, name, "ENCRYPTION_CERTIFICATE_HASH");
	ndr->depth++;
	ndr_print_uint32(ndr, "cbTotalLength", r->cbTotalLength);
	ndr_print_ptr(ndr, "pUserSid", r->pUserSid);
	ndr->depth++;
	if (r->pUserSid) {
		ndr_print_dom_sid(ndr, "pUserSid", r->pUserSid);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "pHash", r->pHash);
	ndr->depth++;
	if (r->pHash) {
		ndr_print_EFS_HASH_BLOB(ndr, "pHash", r->pHash);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "lpDisplayInformation", r->lpDisplayInformation);
	ndr->depth++;
	if (r->lpDisplayInformation) {
		ndr_print_string(ndr, "lpDisplayInformation", r->lpDisplayInformation);
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_ENCRYPTION_CERTIFICATE_HASH_LIST(struct ndr_push *ndr, int ndr_flags, const struct ENCRYPTION_CERTIFICATE_HASH_LIST *r)
{
	uint32_t cntr_pUsers_0;
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->nCert_Hash));
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->nCert_Hash));
		for (cntr_pUsers_0 = 0; cntr_pUsers_0 < r->nCert_Hash; cntr_pUsers_0++) {
			NDR_CHECK(ndr_push_unique_ptr(ndr, r->pUsers[cntr_pUsers_0]));
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_pUsers_0 = 0; cntr_pUsers_0 < r->nCert_Hash; cntr_pUsers_0++) {
			if (r->pUsers[cntr_pUsers_0]) {
				NDR_CHECK(ndr_push_ENCRYPTION_CERTIFICATE_HASH(ndr, NDR_SCALARS|NDR_BUFFERS, r->pUsers[cntr_pUsers_0]));
			}
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_ENCRYPTION_CERTIFICATE_HASH_LIST(struct ndr_pull *ndr, int ndr_flags, struct ENCRYPTION_CERTIFICATE_HASH_LIST *r)
{
	uint32_t _ptr_pUsers;
	uint32_t cntr_pUsers_0;
	TALLOC_CTX *_mem_save_pUsers_0;
	TALLOC_CTX *_mem_save_pUsers_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->pUsers));
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->nCert_Hash));
		NDR_PULL_ALLOC_N(ndr, r->pUsers, ndr_get_array_size(ndr, &r->pUsers));
		_mem_save_pUsers_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->pUsers, 0);
		for (cntr_pUsers_0 = 0; cntr_pUsers_0 < r->nCert_Hash; cntr_pUsers_0++) {
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pUsers));
			if (_ptr_pUsers) {
				NDR_PULL_ALLOC(ndr, r->pUsers[cntr_pUsers_0]);
			} else {
				r->pUsers[cntr_pUsers_0] = NULL;
			}
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pUsers_0, 0);
		if (r->pUsers) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->pUsers, r->nCert_Hash));
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		_mem_save_pUsers_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->pUsers, 0);
		for (cntr_pUsers_0 = 0; cntr_pUsers_0 < r->nCert_Hash; cntr_pUsers_0++) {
			if (r->pUsers[cntr_pUsers_0]) {
				_mem_save_pUsers_1 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->pUsers[cntr_pUsers_0], 0);
				NDR_CHECK(ndr_pull_ENCRYPTION_CERTIFICATE_HASH(ndr, NDR_SCALARS|NDR_BUFFERS, r->pUsers[cntr_pUsers_0]));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pUsers_1, 0);
			}
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pUsers_0, 0);
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_ENCRYPTION_CERTIFICATE_HASH_LIST(struct ndr_print *ndr, const char *name, const struct ENCRYPTION_CERTIFICATE_HASH_LIST *r)
{
	uint32_t cntr_pUsers_0;
	ndr_print_struct(ndr, name, "ENCRYPTION_CERTIFICATE_HASH_LIST");
	ndr->depth++;
	ndr_print_uint32(ndr, "nCert_Hash", r->nCert_Hash);
	ndr->print(ndr, "%s: ARRAY(%d)", "pUsers", r->nCert_Hash);
	ndr->depth++;
	for (cntr_pUsers_0=0;cntr_pUsers_0<r->nCert_Hash;cntr_pUsers_0++) {
		char *idx_0=NULL;
		asprintf(&idx_0, "[%d]", cntr_pUsers_0);
		if (idx_0) {
			ndr_print_ptr(ndr, "pUsers", r->pUsers[cntr_pUsers_0]);
			ndr->depth++;
			if (r->pUsers[cntr_pUsers_0]) {
				ndr_print_ENCRYPTION_CERTIFICATE_HASH(ndr, "pUsers", r->pUsers[cntr_pUsers_0]);
			}
			ndr->depth--;
			free(idx_0);
		}
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_EFS_CERTIFICATE_BLOB(struct ndr_push *ndr, int ndr_flags, const struct EFS_CERTIFICATE_BLOB *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwCertEncodingType));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->cbData));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pbData));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pbData) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->cbData));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->pbData, r->cbData));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_EFS_CERTIFICATE_BLOB(struct ndr_pull *ndr, int ndr_flags, struct EFS_CERTIFICATE_BLOB *r)
{
	uint32_t _ptr_pbData;
	TALLOC_CTX *_mem_save_pbData_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwCertEncodingType));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->cbData));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pbData));
		if (_ptr_pbData) {
			NDR_PULL_ALLOC(ndr, r->pbData);
		} else {
			r->pbData = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pbData) {
			_mem_save_pbData_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pbData, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pbData));
			NDR_PULL_ALLOC_N(ndr, r->pbData, ndr_get_array_size(ndr, &r->pbData));
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->pbData, ndr_get_array_size(ndr, &r->pbData)));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pbData_0, 0);
		}
		if (r->pbData) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->pbData, r->cbData));
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_EFS_CERTIFICATE_BLOB(struct ndr_print *ndr, const char *name, const struct EFS_CERTIFICATE_BLOB *r)
{
	ndr_print_struct(ndr, name, "EFS_CERTIFICATE_BLOB");
	ndr->depth++;
	ndr_print_uint32(ndr, "dwCertEncodingType", r->dwCertEncodingType);
	ndr_print_uint32(ndr, "cbData", r->cbData);
	ndr_print_ptr(ndr, "pbData", r->pbData);
	ndr->depth++;
	if (r->pbData) {
		ndr_print_array_uint8(ndr, "pbData", r->pbData, r->cbData);
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_ENCRYPTION_CERTIFICATE(struct ndr_push *ndr, int ndr_flags, const struct ENCRYPTION_CERTIFICATE *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->TotalLength));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pUserSid));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pCertBlob));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pUserSid) {
			NDR_CHECK(ndr_push_dom_sid(ndr, NDR_SCALARS|NDR_BUFFERS, r->pUserSid));
		}
		if (r->pCertBlob) {
			NDR_CHECK(ndr_push_EFS_CERTIFICATE_BLOB(ndr, NDR_SCALARS|NDR_BUFFERS, r->pCertBlob));
		}
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_ENCRYPTION_CERTIFICATE(struct ndr_pull *ndr, int ndr_flags, struct ENCRYPTION_CERTIFICATE *r)
{
	uint32_t _ptr_pUserSid;
	TALLOC_CTX *_mem_save_pUserSid_0;
	uint32_t _ptr_pCertBlob;
	TALLOC_CTX *_mem_save_pCertBlob_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->TotalLength));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pUserSid));
		if (_ptr_pUserSid) {
			NDR_PULL_ALLOC(ndr, r->pUserSid);
		} else {
			r->pUserSid = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pCertBlob));
		if (_ptr_pCertBlob) {
			NDR_PULL_ALLOC(ndr, r->pCertBlob);
		} else {
			r->pCertBlob = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pUserSid) {
			_mem_save_pUserSid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pUserSid, 0);
			NDR_CHECK(ndr_pull_dom_sid(ndr, NDR_SCALARS|NDR_BUFFERS, r->pUserSid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pUserSid_0, 0);
		}
		if (r->pCertBlob) {
			_mem_save_pCertBlob_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pCertBlob, 0);
			NDR_CHECK(ndr_pull_EFS_CERTIFICATE_BLOB(ndr, NDR_SCALARS|NDR_BUFFERS, r->pCertBlob));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pCertBlob_0, 0);
		}
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_ENCRYPTION_CERTIFICATE(struct ndr_print *ndr, const char *name, const struct ENCRYPTION_CERTIFICATE *r)
{
	ndr_print_struct(ndr, name, "ENCRYPTION_CERTIFICATE");
	ndr->depth++;
	ndr_print_uint32(ndr, "TotalLength", r->TotalLength);
	ndr_print_ptr(ndr, "pUserSid", r->pUserSid);
	ndr->depth++;
	if (r->pUserSid) {
		ndr_print_dom_sid(ndr, "pUserSid", r->pUserSid);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "pCertBlob", r->pCertBlob);
	ndr->depth++;
	if (r->pCertBlob) {
		ndr_print_EFS_CERTIFICATE_BLOB(ndr, "pCertBlob", r->pCertBlob);
	}
	ndr->depth--;
	ndr->depth--;
}

static NTSTATUS ndr_push_EfsRpcOpenFileRaw(struct ndr_push *ndr, int flags, const struct EfsRpcOpenFileRaw *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.FileName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.FileName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.FileName, ndr_charset_length(r->in.FileName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.Flags));
	}
	if (flags & NDR_OUT) {
		if (r->out.pvContext == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.pvContext));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_EfsRpcOpenFileRaw(struct ndr_pull *ndr, int flags, struct EfsRpcOpenFileRaw *r)
{
	TALLOC_CTX *_mem_save_pvContext_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.FileName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.FileName));
		if (ndr_get_array_length(ndr, &r->in.FileName) > ndr_get_array_size(ndr, &r->in.FileName)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.FileName), ndr_get_array_length(ndr, &r->in.FileName));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.FileName), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.FileName, ndr_get_array_length(ndr, &r->in.FileName), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.Flags));
		NDR_PULL_ALLOC(ndr, r->out.pvContext);
		ZERO_STRUCTP(r->out.pvContext);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pvContext);
		}
		_mem_save_pvContext_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pvContext, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.pvContext));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pvContext_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_EfsRpcOpenFileRaw(struct ndr_print *ndr, const char *name, int flags, const struct EfsRpcOpenFileRaw *r)
{
	ndr_print_struct(ndr, name, "EfsRpcOpenFileRaw");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "EfsRpcOpenFileRaw");
		ndr->depth++;
		ndr_print_string(ndr, "FileName", r->in.FileName);
		ndr_print_uint32(ndr, "Flags", r->in.Flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "EfsRpcOpenFileRaw");
		ndr->depth++;
		ndr_print_ptr(ndr, "pvContext", r->out.pvContext);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "pvContext", r->out.pvContext);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_EfsRpcReadFileRaw(struct ndr_push *ndr, int flags, const struct EfsRpcReadFileRaw *r)
{
	if (flags & NDR_IN) {
		if (r->in.pvContext == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pvContext));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_EfsRpcReadFileRaw(struct ndr_pull *ndr, int flags, struct EfsRpcReadFileRaw *r)
{
	TALLOC_CTX *_mem_save_pvContext_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pvContext);
		}
		_mem_save_pvContext_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pvContext, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pvContext));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pvContext_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_EfsRpcReadFileRaw(struct ndr_print *ndr, const char *name, int flags, const struct EfsRpcReadFileRaw *r)
{
	ndr_print_struct(ndr, name, "EfsRpcReadFileRaw");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "EfsRpcReadFileRaw");
		ndr->depth++;
		ndr_print_ptr(ndr, "pvContext", r->in.pvContext);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "pvContext", r->in.pvContext);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "EfsRpcReadFileRaw");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_EfsRpcWriteFileRaw(struct ndr_push *ndr, int flags, const struct EfsRpcWriteFileRaw *r)
{
	if (flags & NDR_IN) {
		if (r->in.pvContext == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pvContext));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_EfsRpcWriteFileRaw(struct ndr_pull *ndr, int flags, struct EfsRpcWriteFileRaw *r)
{
	TALLOC_CTX *_mem_save_pvContext_0;
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pvContext);
		}
		_mem_save_pvContext_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pvContext, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pvContext));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pvContext_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_EfsRpcWriteFileRaw(struct ndr_print *ndr, const char *name, int flags, const struct EfsRpcWriteFileRaw *r)
{
	ndr_print_struct(ndr, name, "EfsRpcWriteFileRaw");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "EfsRpcWriteFileRaw");
		ndr->depth++;
		ndr_print_ptr(ndr, "pvContext", r->in.pvContext);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "pvContext", r->in.pvContext);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "EfsRpcWriteFileRaw");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_EfsRpcCloseRaw(struct ndr_push *ndr, int flags, const struct EfsRpcCloseRaw *r)
{
	if (flags & NDR_IN) {
		if (r->in.pvContext == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pvContext));
	}
	if (flags & NDR_OUT) {
		if (r->out.pvContext == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.pvContext));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_EfsRpcCloseRaw(struct ndr_pull *ndr, int flags, struct EfsRpcCloseRaw *r)
{
	TALLOC_CTX *_mem_save_pvContext_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pvContext);
		}
		_mem_save_pvContext_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pvContext, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pvContext));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pvContext_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.pvContext);
		*r->out.pvContext = *r->in.pvContext;
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pvContext);
		}
		_mem_save_pvContext_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pvContext, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.pvContext));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pvContext_0, LIBNDR_FLAG_REF_ALLOC);
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_EfsRpcCloseRaw(struct ndr_print *ndr, const char *name, int flags, const struct EfsRpcCloseRaw *r)
{
	ndr_print_struct(ndr, name, "EfsRpcCloseRaw");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "EfsRpcCloseRaw");
		ndr->depth++;
		ndr_print_ptr(ndr, "pvContext", r->in.pvContext);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "pvContext", r->in.pvContext);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "EfsRpcCloseRaw");
		ndr->depth++;
		ndr_print_ptr(ndr, "pvContext", r->out.pvContext);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "pvContext", r->out.pvContext);
		ndr->depth--;
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_EfsRpcEncryptFileSrv(struct ndr_push *ndr, int flags, const struct EfsRpcEncryptFileSrv *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.Filename, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.Filename, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.Filename, ndr_charset_length(r->in.Filename, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_EfsRpcEncryptFileSrv(struct ndr_pull *ndr, int flags, struct EfsRpcEncryptFileSrv *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.Filename));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.Filename));
		if (ndr_get_array_length(ndr, &r->in.Filename) > ndr_get_array_size(ndr, &r->in.Filename)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.Filename), ndr_get_array_length(ndr, &r->in.Filename));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.Filename), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.Filename, ndr_get_array_length(ndr, &r->in.Filename), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_EfsRpcEncryptFileSrv(struct ndr_print *ndr, const char *name, int flags, const struct EfsRpcEncryptFileSrv *r)
{
	ndr_print_struct(ndr, name, "EfsRpcEncryptFileSrv");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "EfsRpcEncryptFileSrv");
		ndr->depth++;
		ndr_print_string(ndr, "Filename", r->in.Filename);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "EfsRpcEncryptFileSrv");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_EfsRpcDecryptFileSrv(struct ndr_push *ndr, int flags, const struct EfsRpcDecryptFileSrv *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.FileName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.FileName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.FileName, ndr_charset_length(r->in.FileName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.Reserved));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_EfsRpcDecryptFileSrv(struct ndr_pull *ndr, int flags, struct EfsRpcDecryptFileSrv *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.FileName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.FileName));
		if (ndr_get_array_length(ndr, &r->in.FileName) > ndr_get_array_size(ndr, &r->in.FileName)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.FileName), ndr_get_array_length(ndr, &r->in.FileName));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.FileName), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.FileName, ndr_get_array_length(ndr, &r->in.FileName), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.Reserved));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_EfsRpcDecryptFileSrv(struct ndr_print *ndr, const char *name, int flags, const struct EfsRpcDecryptFileSrv *r)
{
	ndr_print_struct(ndr, name, "EfsRpcDecryptFileSrv");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "EfsRpcDecryptFileSrv");
		ndr->depth++;
		ndr_print_string(ndr, "FileName", r->in.FileName);
		ndr_print_uint32(ndr, "Reserved", r->in.Reserved);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "EfsRpcDecryptFileSrv");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_EfsRpcQueryUsersOnFile(struct ndr_push *ndr, int flags, const struct EfsRpcQueryUsersOnFile *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.FileName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.FileName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.FileName, ndr_charset_length(r->in.FileName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		if (r->out.pUsers == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		if (*r->out.pUsers == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_ref_ptr(ndr));
		NDR_CHECK(ndr_push_ENCRYPTION_CERTIFICATE_HASH_LIST(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.pUsers));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_EfsRpcQueryUsersOnFile(struct ndr_pull *ndr, int flags, struct EfsRpcQueryUsersOnFile *r)
{
	uint32_t _ptr_pUsers;
	TALLOC_CTX *_mem_save_pUsers_0;
	TALLOC_CTX *_mem_save_pUsers_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.FileName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.FileName));
		if (ndr_get_array_length(ndr, &r->in.FileName) > ndr_get_array_size(ndr, &r->in.FileName)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.FileName), ndr_get_array_length(ndr, &r->in.FileName));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.FileName), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.FileName, ndr_get_array_length(ndr, &r->in.FileName), sizeof(uint16_t), CH_UTF16));
		NDR_PULL_ALLOC(ndr, r->out.pUsers);
		ZERO_STRUCTP(r->out.pUsers);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pUsers);
		}
		_mem_save_pUsers_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pUsers, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ref_ptr(ndr, &_ptr_pUsers));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, *r->out.pUsers);
		}
		_mem_save_pUsers_1 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, *r->out.pUsers, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ENCRYPTION_CERTIFICATE_HASH_LIST(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.pUsers));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pUsers_1, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pUsers_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_EfsRpcQueryUsersOnFile(struct ndr_print *ndr, const char *name, int flags, const struct EfsRpcQueryUsersOnFile *r)
{
	ndr_print_struct(ndr, name, "EfsRpcQueryUsersOnFile");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "EfsRpcQueryUsersOnFile");
		ndr->depth++;
		ndr_print_string(ndr, "FileName", r->in.FileName);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "EfsRpcQueryUsersOnFile");
		ndr->depth++;
		ndr_print_ptr(ndr, "pUsers", r->out.pUsers);
		ndr->depth++;
		ndr_print_ptr(ndr, "pUsers", *r->out.pUsers);
		ndr->depth++;
		ndr_print_ENCRYPTION_CERTIFICATE_HASH_LIST(ndr, "pUsers", *r->out.pUsers);
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_EfsRpcQueryRecoveryAgents(struct ndr_push *ndr, int flags, const struct EfsRpcQueryRecoveryAgents *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.FileName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.FileName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.FileName, ndr_charset_length(r->in.FileName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		if (r->out.pRecoveryAgents == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		if (*r->out.pRecoveryAgents == NULL) return NT_STATUS_INVALID_PARAMETER_MIX;
		NDR_CHECK(ndr_push_ref_ptr(ndr));
		NDR_CHECK(ndr_push_ENCRYPTION_CERTIFICATE_HASH_LIST(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.pRecoveryAgents));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_EfsRpcQueryRecoveryAgents(struct ndr_pull *ndr, int flags, struct EfsRpcQueryRecoveryAgents *r)
{
	uint32_t _ptr_pRecoveryAgents;
	TALLOC_CTX *_mem_save_pRecoveryAgents_0;
	TALLOC_CTX *_mem_save_pRecoveryAgents_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.FileName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.FileName));
		if (ndr_get_array_length(ndr, &r->in.FileName) > ndr_get_array_size(ndr, &r->in.FileName)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.FileName), ndr_get_array_length(ndr, &r->in.FileName));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.FileName), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.FileName, ndr_get_array_length(ndr, &r->in.FileName), sizeof(uint16_t), CH_UTF16));
		NDR_PULL_ALLOC(ndr, r->out.pRecoveryAgents);
		ZERO_STRUCTP(r->out.pRecoveryAgents);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pRecoveryAgents);
		}
		_mem_save_pRecoveryAgents_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pRecoveryAgents, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ref_ptr(ndr, &_ptr_pRecoveryAgents));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, *r->out.pRecoveryAgents);
		}
		_mem_save_pRecoveryAgents_1 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, *r->out.pRecoveryAgents, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ENCRYPTION_CERTIFICATE_HASH_LIST(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.pRecoveryAgents));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pRecoveryAgents_1, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pRecoveryAgents_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_EfsRpcQueryRecoveryAgents(struct ndr_print *ndr, const char *name, int flags, const struct EfsRpcQueryRecoveryAgents *r)
{
	ndr_print_struct(ndr, name, "EfsRpcQueryRecoveryAgents");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "EfsRpcQueryRecoveryAgents");
		ndr->depth++;
		ndr_print_string(ndr, "FileName", r->in.FileName);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "EfsRpcQueryRecoveryAgents");
		ndr->depth++;
		ndr_print_ptr(ndr, "pRecoveryAgents", r->out.pRecoveryAgents);
		ndr->depth++;
		ndr_print_ptr(ndr, "pRecoveryAgents", *r->out.pRecoveryAgents);
		ndr->depth++;
		ndr_print_ENCRYPTION_CERTIFICATE_HASH_LIST(ndr, "pRecoveryAgents", *r->out.pRecoveryAgents);
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_EfsRpcRemoveUsersFromFile(struct ndr_push *ndr, int flags, const struct EfsRpcRemoveUsersFromFile *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.FileName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.FileName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.FileName, ndr_charset_length(r->in.FileName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_EfsRpcRemoveUsersFromFile(struct ndr_pull *ndr, int flags, struct EfsRpcRemoveUsersFromFile *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.FileName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.FileName));
		if (ndr_get_array_length(ndr, &r->in.FileName) > ndr_get_array_size(ndr, &r->in.FileName)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.FileName), ndr_get_array_length(ndr, &r->in.FileName));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.FileName), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.FileName, ndr_get_array_length(ndr, &r->in.FileName), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_EfsRpcRemoveUsersFromFile(struct ndr_print *ndr, const char *name, int flags, const struct EfsRpcRemoveUsersFromFile *r)
{
	ndr_print_struct(ndr, name, "EfsRpcRemoveUsersFromFile");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "EfsRpcRemoveUsersFromFile");
		ndr->depth++;
		ndr_print_string(ndr, "FileName", r->in.FileName);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "EfsRpcRemoveUsersFromFile");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_EfsRpcAddUsersToFile(struct ndr_push *ndr, int flags, const struct EfsRpcAddUsersToFile *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.FileName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->in.FileName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.FileName, ndr_charset_length(r->in.FileName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_EfsRpcAddUsersToFile(struct ndr_pull *ndr, int flags, struct EfsRpcAddUsersToFile *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.FileName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.FileName));
		if (ndr_get_array_length(ndr, &r->in.FileName) > ndr_get_array_size(ndr, &r->in.FileName)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.FileName), ndr_get_array_length(ndr, &r->in.FileName));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.FileName), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.FileName, ndr_get_array_length(ndr, &r->in.FileName), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_EfsRpcAddUsersToFile(struct ndr_print *ndr, const char *name, int flags, const struct EfsRpcAddUsersToFile *r)
{
	ndr_print_struct(ndr, name, "EfsRpcAddUsersToFile");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "EfsRpcAddUsersToFile");
		ndr->depth++;
		ndr_print_string(ndr, "FileName", r->in.FileName);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "EfsRpcAddUsersToFile");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_EfsRpcSetFileEncryptionKey(struct ndr_push *ndr, int flags, const struct EfsRpcSetFileEncryptionKey *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pEncryptionCertificate));
		if (r->in.pEncryptionCertificate) {
			NDR_CHECK(ndr_push_ENCRYPTION_CERTIFICATE(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pEncryptionCertificate));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_EfsRpcSetFileEncryptionKey(struct ndr_pull *ndr, int flags, struct EfsRpcSetFileEncryptionKey *r)
{
	uint32_t _ptr_pEncryptionCertificate;
	TALLOC_CTX *_mem_save_pEncryptionCertificate_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pEncryptionCertificate));
		if (_ptr_pEncryptionCertificate) {
			NDR_PULL_ALLOC(ndr, r->in.pEncryptionCertificate);
		} else {
			r->in.pEncryptionCertificate = NULL;
		}
		if (r->in.pEncryptionCertificate) {
			_mem_save_pEncryptionCertificate_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pEncryptionCertificate, 0);
			NDR_CHECK(ndr_pull_ENCRYPTION_CERTIFICATE(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pEncryptionCertificate));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pEncryptionCertificate_0, 0);
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_EfsRpcSetFileEncryptionKey(struct ndr_print *ndr, const char *name, int flags, const struct EfsRpcSetFileEncryptionKey *r)
{
	ndr_print_struct(ndr, name, "EfsRpcSetFileEncryptionKey");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "EfsRpcSetFileEncryptionKey");
		ndr->depth++;
		ndr_print_ptr(ndr, "pEncryptionCertificate", r->in.pEncryptionCertificate);
		ndr->depth++;
		if (r->in.pEncryptionCertificate) {
			ndr_print_ENCRYPTION_CERTIFICATE(ndr, "pEncryptionCertificate", r->in.pEncryptionCertificate);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "EfsRpcSetFileEncryptionKey");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_EfsRpcNotSupported(struct ndr_push *ndr, int flags, const struct EfsRpcNotSupported *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_EfsRpcNotSupported(struct ndr_pull *ndr, int flags, struct EfsRpcNotSupported *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_EfsRpcNotSupported(struct ndr_print *ndr, const char *name, int flags, const struct EfsRpcNotSupported *r)
{
	ndr_print_struct(ndr, name, "EfsRpcNotSupported");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "EfsRpcNotSupported");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "EfsRpcNotSupported");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_EfsRpcFileKeyInfo(struct ndr_push *ndr, int flags, const struct EfsRpcFileKeyInfo *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_EfsRpcFileKeyInfo(struct ndr_pull *ndr, int flags, struct EfsRpcFileKeyInfo *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_EfsRpcFileKeyInfo(struct ndr_print *ndr, const char *name, int flags, const struct EfsRpcFileKeyInfo *r)
{
	ndr_print_struct(ndr, name, "EfsRpcFileKeyInfo");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "EfsRpcFileKeyInfo");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "EfsRpcFileKeyInfo");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static NTSTATUS ndr_push_EfsRpcDuplicateEncryptionInfoFile(struct ndr_push *ndr, int flags, const struct EfsRpcDuplicateEncryptionInfoFile *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NT_STATUS_OK;
}

static NTSTATUS ndr_pull_EfsRpcDuplicateEncryptionInfoFile(struct ndr_pull *ndr, int flags, struct EfsRpcDuplicateEncryptionInfoFile *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NT_STATUS_OK;
}

_PUBLIC_ void ndr_print_EfsRpcDuplicateEncryptionInfoFile(struct ndr_print *ndr, const char *name, int flags, const struct EfsRpcDuplicateEncryptionInfoFile *r)
{
	ndr_print_struct(ndr, name, "EfsRpcDuplicateEncryptionInfoFile");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "EfsRpcDuplicateEncryptionInfoFile");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "EfsRpcDuplicateEncryptionInfoFile");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct dcerpc_interface_call efs_calls[] = {
	{
		"EfsRpcOpenFileRaw",
		sizeof(struct EfsRpcOpenFileRaw),
		(ndr_push_flags_fn_t) ndr_push_EfsRpcOpenFileRaw,
		(ndr_pull_flags_fn_t) ndr_pull_EfsRpcOpenFileRaw,
		(ndr_print_function_t) ndr_print_EfsRpcOpenFileRaw,
		False,
	},
	{
		"EfsRpcReadFileRaw",
		sizeof(struct EfsRpcReadFileRaw),
		(ndr_push_flags_fn_t) ndr_push_EfsRpcReadFileRaw,
		(ndr_pull_flags_fn_t) ndr_pull_EfsRpcReadFileRaw,
		(ndr_print_function_t) ndr_print_EfsRpcReadFileRaw,
		False,
	},
	{
		"EfsRpcWriteFileRaw",
		sizeof(struct EfsRpcWriteFileRaw),
		(ndr_push_flags_fn_t) ndr_push_EfsRpcWriteFileRaw,
		(ndr_pull_flags_fn_t) ndr_pull_EfsRpcWriteFileRaw,
		(ndr_print_function_t) ndr_print_EfsRpcWriteFileRaw,
		False,
	},
	{
		"EfsRpcCloseRaw",
		sizeof(struct EfsRpcCloseRaw),
		(ndr_push_flags_fn_t) ndr_push_EfsRpcCloseRaw,
		(ndr_pull_flags_fn_t) ndr_pull_EfsRpcCloseRaw,
		(ndr_print_function_t) ndr_print_EfsRpcCloseRaw,
		False,
	},
	{
		"EfsRpcEncryptFileSrv",
		sizeof(struct EfsRpcEncryptFileSrv),
		(ndr_push_flags_fn_t) ndr_push_EfsRpcEncryptFileSrv,
		(ndr_pull_flags_fn_t) ndr_pull_EfsRpcEncryptFileSrv,
		(ndr_print_function_t) ndr_print_EfsRpcEncryptFileSrv,
		False,
	},
	{
		"EfsRpcDecryptFileSrv",
		sizeof(struct EfsRpcDecryptFileSrv),
		(ndr_push_flags_fn_t) ndr_push_EfsRpcDecryptFileSrv,
		(ndr_pull_flags_fn_t) ndr_pull_EfsRpcDecryptFileSrv,
		(ndr_print_function_t) ndr_print_EfsRpcDecryptFileSrv,
		False,
	},
	{
		"EfsRpcQueryUsersOnFile",
		sizeof(struct EfsRpcQueryUsersOnFile),
		(ndr_push_flags_fn_t) ndr_push_EfsRpcQueryUsersOnFile,
		(ndr_pull_flags_fn_t) ndr_pull_EfsRpcQueryUsersOnFile,
		(ndr_print_function_t) ndr_print_EfsRpcQueryUsersOnFile,
		False,
	},
	{
		"EfsRpcQueryRecoveryAgents",
		sizeof(struct EfsRpcQueryRecoveryAgents),
		(ndr_push_flags_fn_t) ndr_push_EfsRpcQueryRecoveryAgents,
		(ndr_pull_flags_fn_t) ndr_pull_EfsRpcQueryRecoveryAgents,
		(ndr_print_function_t) ndr_print_EfsRpcQueryRecoveryAgents,
		False,
	},
	{
		"EfsRpcRemoveUsersFromFile",
		sizeof(struct EfsRpcRemoveUsersFromFile),
		(ndr_push_flags_fn_t) ndr_push_EfsRpcRemoveUsersFromFile,
		(ndr_pull_flags_fn_t) ndr_pull_EfsRpcRemoveUsersFromFile,
		(ndr_print_function_t) ndr_print_EfsRpcRemoveUsersFromFile,
		False,
	},
	{
		"EfsRpcAddUsersToFile",
		sizeof(struct EfsRpcAddUsersToFile),
		(ndr_push_flags_fn_t) ndr_push_EfsRpcAddUsersToFile,
		(ndr_pull_flags_fn_t) ndr_pull_EfsRpcAddUsersToFile,
		(ndr_print_function_t) ndr_print_EfsRpcAddUsersToFile,
		False,
	},
	{
		"EfsRpcSetFileEncryptionKey",
		sizeof(struct EfsRpcSetFileEncryptionKey),
		(ndr_push_flags_fn_t) ndr_push_EfsRpcSetFileEncryptionKey,
		(ndr_pull_flags_fn_t) ndr_pull_EfsRpcSetFileEncryptionKey,
		(ndr_print_function_t) ndr_print_EfsRpcSetFileEncryptionKey,
		False,
	},
	{
		"EfsRpcNotSupported",
		sizeof(struct EfsRpcNotSupported),
		(ndr_push_flags_fn_t) ndr_push_EfsRpcNotSupported,
		(ndr_pull_flags_fn_t) ndr_pull_EfsRpcNotSupported,
		(ndr_print_function_t) ndr_print_EfsRpcNotSupported,
		False,
	},
	{
		"EfsRpcFileKeyInfo",
		sizeof(struct EfsRpcFileKeyInfo),
		(ndr_push_flags_fn_t) ndr_push_EfsRpcFileKeyInfo,
		(ndr_pull_flags_fn_t) ndr_pull_EfsRpcFileKeyInfo,
		(ndr_print_function_t) ndr_print_EfsRpcFileKeyInfo,
		False,
	},
	{
		"EfsRpcDuplicateEncryptionInfoFile",
		sizeof(struct EfsRpcDuplicateEncryptionInfoFile),
		(ndr_push_flags_fn_t) ndr_push_EfsRpcDuplicateEncryptionInfoFile,
		(ndr_pull_flags_fn_t) ndr_pull_EfsRpcDuplicateEncryptionInfoFile,
		(ndr_print_function_t) ndr_print_EfsRpcDuplicateEncryptionInfoFile,
		False,
	},
	{ NULL, 0, NULL, NULL, NULL, False }
};

static const char * const efs_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\efs]", 
};

static const struct dcerpc_endpoint_list efs_endpoints = {
	.count	= 1,
	.names	= efs_endpoint_strings
};

static const char * const efs_authservice_strings[] = {
	"host", 
};

static const struct dcerpc_authservice_list efs_authservices = {
	.count	= 1,
	.names	= efs_authservice_strings
};


const struct dcerpc_interface_table dcerpc_table_efs = {
	.name		= "efs",
	.syntax_id	= {
		{0xc681d488,0xd850,0x11d0,{0x8c,0x52},{0x00,0xc0,0x4f,0xd9,0x0f,0x7e}},
		DCERPC_EFS_VERSION
	},
	.helpstring	= DCERPC_EFS_HELPSTRING,
	.num_calls	= 14,
	.calls		= efs_calls,
	.endpoints	= &efs_endpoints,
	.authservices	= &efs_authservices
};

