
/* EJS wrapper functions auto-generated by pidl */
#include "includes.h"
#include "librpc/rpc/dcerpc.h"
#include "lib/appweb/ejs/ejs.h"
#include "scripting/ejs/ejsrpc.h"
#include "scripting/ejs/smbcalls.h"
#include "librpc/gen_ndr/ndr_misc_ejs.h"
#include "librpc/gen_ndr/ndr_echo.h"
#include "librpc/gen_ndr/ndr_echo_ejs.h"


static NTSTATUS ejs_push_echo_info1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct echo_info1 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint8(ejs, v, "v", &r->v));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_echo_info2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct echo_info2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint16(ejs, v, "v", &r->v));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_echo_info3(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct echo_info3 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "v", &r->v));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_echo_info4(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct echo_info4 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_hyper(ejs, v, "v", &r->v));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_echo_info5(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct echo_info5 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint8(ejs, v, "v1", &r->v1));
	NDR_CHECK(ejs_push_hyper(ejs, v, "v2", &r->v2));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_echo_info6(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct echo_info6 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint8(ejs, v, "v1", &r->v1));
	NDR_CHECK(ejs_push_echo_info1(ejs, v, "info1", &r->info1));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_echo_info7(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct echo_info7 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint8(ejs, v, "v1", &r->v1));
	NDR_CHECK(ejs_push_echo_info4(ejs, v, "info4", &r->info4));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_echo_Info(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union echo_Info *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case 1:
			NDR_CHECK(ejs_push_echo_info1(ejs, v, "info1", &r->info1));
			break;
		case 2:
			NDR_CHECK(ejs_push_echo_info2(ejs, v, "info2", &r->info2));
			break;
		case 3:
			NDR_CHECK(ejs_push_echo_info3(ejs, v, "info3", &r->info3));
			break;
		case 4:
			NDR_CHECK(ejs_push_echo_info4(ejs, v, "info4", &r->info4));
			break;
		case 5:
			NDR_CHECK(ejs_push_echo_info5(ejs, v, "info5", &r->info5));
			break;
		case 6:
			NDR_CHECK(ejs_push_echo_info6(ejs, v, "info6", &r->info6));
			break;
		case 7:
			NDR_CHECK(ejs_push_echo_info7(ejs, v, "info7", &r->info7));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_echo_Enum1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const enum echo_Enum1 *r)
{
	unsigned e = *r;
	NDR_CHECK(ejs_push_enum(ejs, v, name, &e));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_echo_Enum1(struct ejs_rpc *ejs, struct MprVar *v, const char *name, enum echo_Enum1 *r)
{
	unsigned e;
	NDR_CHECK(ejs_pull_enum(ejs, v, name, &e));
	*r = e;
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_echo_Enum1_32(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const enum echo_Enum1_32 *r)
{
	unsigned e = *r;
	NDR_CHECK(ejs_push_enum(ejs, v, name, &e));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_echo_Enum1_32(struct ejs_rpc *ejs, struct MprVar *v, const char *name, enum echo_Enum1_32 *r)
{
	unsigned e;
	NDR_CHECK(ejs_pull_enum(ejs, v, name, &e));
	*r = e;
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_echo_Enum2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct echo_Enum2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_echo_Enum1(ejs, v, "e1", &r->e1));
	NDR_CHECK(ejs_push_echo_Enum1_32(ejs, v, "e2", &r->e2));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_echo_Enum2(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct echo_Enum2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_echo_Enum1(ejs, v, "e1", &r->e1));
	NDR_CHECK(ejs_pull_echo_Enum1_32(ejs, v, "e2", &r->e2));
	return NT_STATUS_OK;
}

static NTSTATUS ejs_push_echo_Enum3(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const union echo_Enum3 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case ECHO_ENUM1:
			NDR_CHECK(ejs_push_echo_Enum1(ejs, v, "e1", &r->e1));
			break;
		case ECHO_ENUM2:
			NDR_CHECK(ejs_push_echo_Enum2(ejs, v, "e2", &r->e2));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_pull_echo_Enum3(struct ejs_rpc *ejs, struct MprVar *v, const char *name, union echo_Enum3 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	switch (ejs->switch_var) {
		case ECHO_ENUM1:
			NDR_CHECK(ejs_pull_echo_Enum1(ejs, v, "e1", &r->e1));
			break;
		case ECHO_ENUM2:
			NDR_CHECK(ejs_pull_echo_Enum2(ejs, v, "e2", &r->e2));
			break;
		default:
			return ejs_panic(ejs, "Bad switch value");
	}
	return NT_STATUS_OK;
}
static NTSTATUS ejs_push_echo_Surrounding(struct ejs_rpc *ejs, struct MprVar *v, const char *name, const struct echo_Surrounding *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_push_uint32(ejs, v, "x", &r->x));
	{
		uint32_t i;
		for (i=0;i<r->x;i++) {
			const char *id = talloc_asprintf(ejs, "%s.%u", "surrounding", i);
			NDR_CHECK(ejs_push_uint16(ejs, v, id, &r->surrounding[i]));
		}
		ejs_push_uint32(ejs, v, "surrounding" ".length", &i);
	}
	return NT_STATUS_OK;
}

static NTSTATUS ejs_pull_echo_Surrounding(struct ejs_rpc *ejs, struct MprVar *v, const char *name, struct echo_Surrounding *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, name));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "x", &r->x));
	{
		uint32_t i;
		EJS_ALLOC_N(ejs, r->surrounding, r->x);
		for (i=0;i<r->x;i++) {
			char *id = talloc_asprintf(ejs, "%s.%u", "surrounding", i);
			NDR_CHECK(ejs_pull_uint16(ejs, v, id, &r->surrounding[i]));
			talloc_free(id);
		}
		ejs_push_uint32(ejs, v, "surrounding" ".length", &i);
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_pull_echo_AddOne(struct ejs_rpc *ejs, struct MprVar *v, struct echo_AddOne *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "in_data", &r->in.in_data));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_echo_AddOne(struct ejs_rpc *ejs, struct MprVar *v, const struct echo_AddOne *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.out_data) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_uint32(ejs, v, "out_data", r->out.out_data));
	}
	return NT_STATUS_OK;
}

static int ejs_echo_AddOne(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_rpcecho, DCERPC_ECHO_ADDONE, (ejs_pull_function_t)ejs_pull_echo_AddOne, (ejs_push_function_t)ejs_push_echo_AddOne);
}


static NTSTATUS ejs_pull_echo_EchoData(struct ejs_rpc *ejs, struct MprVar *v, struct echo_EchoData *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "len", &r->in.len));
	EJS_ALLOC_N(ejs, r->in.in_data, r->in.len);
	ejs_pull_array_uint8(ejs, v, "in_data", r->in.in_data, r->in.len);
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_echo_EchoData(struct ejs_rpc *ejs, struct MprVar *v, const struct echo_EchoData *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	ejs_push_array_uint8(ejs, v, "out_data", r->out.out_data, r->in.len);
	return NT_STATUS_OK;
}

static int ejs_echo_EchoData(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_rpcecho, DCERPC_ECHO_ECHODATA, (ejs_pull_function_t)ejs_pull_echo_EchoData, (ejs_push_function_t)ejs_push_echo_EchoData);
}


static NTSTATUS ejs_pull_echo_SinkData(struct ejs_rpc *ejs, struct MprVar *v, struct echo_SinkData *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "len", &r->in.len));
	EJS_ALLOC_N(ejs, r->in.data, r->in.len);
	ejs_pull_array_uint8(ejs, v, "data", r->in.data, r->in.len);
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_echo_SinkData(struct ejs_rpc *ejs, struct MprVar *v, const struct echo_SinkData *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	return NT_STATUS_OK;
}

static int ejs_echo_SinkData(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_rpcecho, DCERPC_ECHO_SINKDATA, (ejs_pull_function_t)ejs_pull_echo_SinkData, (ejs_push_function_t)ejs_push_echo_SinkData);
}


static NTSTATUS ejs_pull_echo_SourceData(struct ejs_rpc *ejs, struct MprVar *v, struct echo_SourceData *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "len", &r->in.len));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_echo_SourceData(struct ejs_rpc *ejs, struct MprVar *v, const struct echo_SourceData *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	ejs_push_array_uint8(ejs, v, "data", r->out.data, r->in.len);
	return NT_STATUS_OK;
}

static int ejs_echo_SourceData(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_rpcecho, DCERPC_ECHO_SOURCEDATA, (ejs_pull_function_t)ejs_pull_echo_SourceData, (ejs_push_function_t)ejs_push_echo_SourceData);
}


static NTSTATUS ejs_pull_echo_TestCall(struct ejs_rpc *ejs, struct MprVar *v, struct echo_TestCall *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "s1")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.s1);
		NDR_CHECK(ejs_pull_string(ejs, v, "s1", &r->in.s1));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_echo_TestCall(struct ejs_rpc *ejs, struct MprVar *v, const struct echo_TestCall *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.s2) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		if (NULL == *r->out.s2) {
			return NT_STATUS_INVALID_PARAMETER_MIX;
		} else {
			NDR_CHECK(ejs_push_string(ejs, v, "s2", *r->out.s2));
		}
	}
	return NT_STATUS_OK;
}

static int ejs_echo_TestCall(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_rpcecho, DCERPC_ECHO_TESTCALL, (ejs_pull_function_t)ejs_pull_echo_TestCall, (ejs_push_function_t)ejs_push_echo_TestCall);
}


static NTSTATUS ejs_pull_echo_TestCall2(struct ejs_rpc *ejs, struct MprVar *v, struct echo_TestCall2 *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_uint16(ejs, v, "level", &r->in.level));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_echo_TestCall2(struct ejs_rpc *ejs, struct MprVar *v, const struct echo_TestCall2 *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.info) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		ejs_set_switch(ejs, r->in.level);
		NDR_CHECK(ejs_push_echo_Info(ejs, v, "info", r->out.info));
	}
	NDR_CHECK(ejs_push_NTSTATUS(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_echo_TestCall2(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_rpcecho, DCERPC_ECHO_TESTCALL2, (ejs_pull_function_t)ejs_pull_echo_TestCall2, (ejs_push_function_t)ejs_push_echo_TestCall2);
}


static NTSTATUS ejs_pull_echo_TestSleep(struct ejs_rpc *ejs, struct MprVar *v, struct echo_TestSleep *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	NDR_CHECK(ejs_pull_uint32(ejs, v, "seconds", &r->in.seconds));
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_echo_TestSleep(struct ejs_rpc *ejs, struct MprVar *v, const struct echo_TestSleep *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_uint32(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_echo_TestSleep(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_rpcecho, DCERPC_ECHO_TESTSLEEP, (ejs_pull_function_t)ejs_pull_echo_TestSleep, (ejs_push_function_t)ejs_push_echo_TestSleep);
}


static NTSTATUS ejs_pull_echo_TestEnum(struct ejs_rpc *ejs, struct MprVar *v, struct echo_TestEnum *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "foo1")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.foo1);
		NDR_CHECK(ejs_pull_echo_Enum1(ejs, v, "foo1", r->in.foo1));
	}
	if (ejs_pull_null(ejs, v, "foo2")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.foo2);
		NDR_CHECK(ejs_pull_echo_Enum2(ejs, v, "foo2", r->in.foo2));
	}
	if (ejs_pull_null(ejs, v, "foo3")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.foo3);
		ejs_set_switch(ejs, *r->in.foo1);
		NDR_CHECK(ejs_pull_echo_Enum3(ejs, v, "foo3", r->in.foo3));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_echo_TestEnum(struct ejs_rpc *ejs, struct MprVar *v, const struct echo_TestEnum *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.foo1) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_echo_Enum1(ejs, v, "foo1", r->out.foo1));
	}
	if (NULL == r->out.foo2) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_echo_Enum2(ejs, v, "foo2", r->out.foo2));
	}
	if (NULL == r->out.foo3) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		ejs_set_switch(ejs, *r->out.foo1);
		NDR_CHECK(ejs_push_echo_Enum3(ejs, v, "foo3", r->out.foo3));
	}
	return NT_STATUS_OK;
}

static int ejs_echo_TestEnum(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_rpcecho, DCERPC_ECHO_TESTENUM, (ejs_pull_function_t)ejs_pull_echo_TestEnum, (ejs_push_function_t)ejs_push_echo_TestEnum);
}


static NTSTATUS ejs_pull_echo_TestSurrounding(struct ejs_rpc *ejs, struct MprVar *v, struct echo_TestSurrounding *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "data")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.data);
		NDR_CHECK(ejs_pull_echo_Surrounding(ejs, v, "data", r->in.data));
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_echo_TestSurrounding(struct ejs_rpc *ejs, struct MprVar *v, const struct echo_TestSurrounding *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	if (NULL == r->out.data) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		NDR_CHECK(ejs_push_echo_Surrounding(ejs, v, "data", r->out.data));
	}
	return NT_STATUS_OK;
}

static int ejs_echo_TestSurrounding(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_rpcecho, DCERPC_ECHO_TESTSURROUNDING, (ejs_pull_function_t)ejs_pull_echo_TestSurrounding, (ejs_push_function_t)ejs_push_echo_TestSurrounding);
}


static NTSTATUS ejs_pull_echo_TestDoublePointer(struct ejs_rpc *ejs, struct MprVar *v, struct echo_TestDoublePointer *r)
{
	NDR_CHECK(ejs_pull_struct_start(ejs, &v, "input"));
	if (ejs_pull_null(ejs, v, "data")) {
		return NT_STATUS_INVALID_PARAMETER_MIX;
	} else {
		EJS_ALLOC(ejs, r->in.data);
		if (ejs_pull_null(ejs, v, "data")) {
			return NT_STATUS_INVALID_PARAMETER_MIX;
		} else {
			EJS_ALLOC(ejs, *r->in.data);
			if (ejs_pull_null(ejs, v, "data")) {
				return NT_STATUS_INVALID_PARAMETER_MIX;
			} else {
				EJS_ALLOC(ejs, **r->in.data);
				NDR_CHECK(ejs_pull_uint16(ejs, v, "data", **r->in.data));
			}
		}
	}
	return NT_STATUS_OK;
}


static NTSTATUS ejs_push_echo_TestDoublePointer(struct ejs_rpc *ejs, struct MprVar *v, const struct echo_TestDoublePointer *r)
{
	NDR_CHECK(ejs_push_struct_start(ejs, &v, "output"));
	NDR_CHECK(ejs_push_uint16(ejs, v, "result", &r->out.result));
	return NT_STATUS_OK;
}

static int ejs_echo_TestDoublePointer(int eid, int argc, struct MprVar **argv)
{
	return ejs_rpc_call(eid, argc, argv, &dcerpc_table_rpcecho, DCERPC_ECHO_TESTDOUBLEPOINTER, (ejs_pull_function_t)ejs_pull_echo_TestDoublePointer, (ejs_push_function_t)ejs_push_echo_TestDoublePointer);
}

static int ejs_rpcecho_init(int eid, int argc, struct MprVar **argv)
{
	struct MprVar *obj = mprInitObject(eid, "rpcecho", argc, argv);
	mprSetCFunction(obj, "echo_AddOne", ejs_echo_AddOne);
	mprSetCFunction(obj, "echo_EchoData", ejs_echo_EchoData);
	mprSetCFunction(obj, "echo_SinkData", ejs_echo_SinkData);
	mprSetCFunction(obj, "echo_SourceData", ejs_echo_SourceData);
	mprSetCFunction(obj, "echo_TestCall", ejs_echo_TestCall);
	mprSetCFunction(obj, "echo_TestCall2", ejs_echo_TestCall2);
	mprSetCFunction(obj, "echo_TestSleep", ejs_echo_TestSleep);
	mprSetCFunction(obj, "echo_TestEnum", ejs_echo_TestEnum);
	mprSetCFunction(obj, "echo_TestSurrounding", ejs_echo_TestSurrounding);
	mprSetCFunction(obj, "echo_TestDoublePointer", ejs_echo_TestDoublePointer);
	mprSetVar(obj, "ECHO_ENUM2", mprCreateNumberVar(2));
	mprSetVar(obj, "ECHO_ENUM1_32", mprCreateNumberVar(1));
	mprSetVar(obj, "ECHO_ENUM1", mprCreateNumberVar(1));
	mprSetVar(obj, "ECHO_ENUM2_32", mprCreateNumberVar(2));
	return ejs_rpc_init(obj, "rpcecho");
}

NTSTATUS ejs_init_rpcecho(void)
{
	ejsDefineCFunction(-1, "rpcecho_init", ejs_rpcecho_init, NULL, MPR_VAR_SCRIPT_HANDLE);
	return NT_STATUS_OK;
}
